// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `DynamoDB_20120810`.
///
/// This client allows ergonomic access to a `DynamoDB_20120810`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `BatchExecuteStatement` operation.
    ///
    /// See [`BatchExecuteStatement`](crate::client::fluent_builders::BatchExecuteStatement) for more information about the
    /// operation and its arguments.
    pub fn batch_execute_statement(&self) -> fluent_builders::BatchExecuteStatement<C, M, R> {
        fluent_builders::BatchExecuteStatement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetItem` operation.
    ///
    /// See [`BatchGetItem`](crate::client::fluent_builders::BatchGetItem) for more information about the
    /// operation and its arguments.
    pub fn batch_get_item(&self) -> fluent_builders::BatchGetItem<C, M, R> {
        fluent_builders::BatchGetItem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchWriteItem` operation.
    ///
    /// See [`BatchWriteItem`](crate::client::fluent_builders::BatchWriteItem) for more information about the
    /// operation and its arguments.
    pub fn batch_write_item(&self) -> fluent_builders::BatchWriteItem<C, M, R> {
        fluent_builders::BatchWriteItem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateBackup` operation.
    ///
    /// See [`CreateBackup`](crate::client::fluent_builders::CreateBackup) for more information about the
    /// operation and its arguments.
    pub fn create_backup(&self) -> fluent_builders::CreateBackup<C, M, R> {
        fluent_builders::CreateBackup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateGlobalTable` operation.
    ///
    /// See [`CreateGlobalTable`](crate::client::fluent_builders::CreateGlobalTable) for more information about the
    /// operation and its arguments.
    pub fn create_global_table(&self) -> fluent_builders::CreateGlobalTable<C, M, R> {
        fluent_builders::CreateGlobalTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTable` operation.
    ///
    /// See [`CreateTable`](crate::client::fluent_builders::CreateTable) for more information about the
    /// operation and its arguments.
    pub fn create_table(&self) -> fluent_builders::CreateTable<C, M, R> {
        fluent_builders::CreateTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBackup` operation.
    ///
    /// See [`DeleteBackup`](crate::client::fluent_builders::DeleteBackup) for more information about the
    /// operation and its arguments.
    pub fn delete_backup(&self) -> fluent_builders::DeleteBackup<C, M, R> {
        fluent_builders::DeleteBackup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteItem` operation.
    ///
    /// See [`DeleteItem`](crate::client::fluent_builders::DeleteItem) for more information about the
    /// operation and its arguments.
    pub fn delete_item(&self) -> fluent_builders::DeleteItem<C, M, R> {
        fluent_builders::DeleteItem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTable` operation.
    ///
    /// See [`DeleteTable`](crate::client::fluent_builders::DeleteTable) for more information about the
    /// operation and its arguments.
    pub fn delete_table(&self) -> fluent_builders::DeleteTable<C, M, R> {
        fluent_builders::DeleteTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeBackup` operation.
    ///
    /// See [`DescribeBackup`](crate::client::fluent_builders::DescribeBackup) for more information about the
    /// operation and its arguments.
    pub fn describe_backup(&self) -> fluent_builders::DescribeBackup<C, M, R> {
        fluent_builders::DescribeBackup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeContinuousBackups` operation.
    ///
    /// See [`DescribeContinuousBackups`](crate::client::fluent_builders::DescribeContinuousBackups) for more information about the
    /// operation and its arguments.
    pub fn describe_continuous_backups(
        &self,
    ) -> fluent_builders::DescribeContinuousBackups<C, M, R> {
        fluent_builders::DescribeContinuousBackups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeContributorInsights` operation.
    ///
    /// See [`DescribeContributorInsights`](crate::client::fluent_builders::DescribeContributorInsights) for more information about the
    /// operation and its arguments.
    pub fn describe_contributor_insights(
        &self,
    ) -> fluent_builders::DescribeContributorInsights<C, M, R> {
        fluent_builders::DescribeContributorInsights::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEndpoints` operation.
    ///
    /// See [`DescribeEndpoints`](crate::client::fluent_builders::DescribeEndpoints) for more information about the
    /// operation and its arguments.
    pub fn describe_endpoints(&self) -> fluent_builders::DescribeEndpoints<C, M, R> {
        fluent_builders::DescribeEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeExport` operation.
    ///
    /// See [`DescribeExport`](crate::client::fluent_builders::DescribeExport) for more information about the
    /// operation and its arguments.
    pub fn describe_export(&self) -> fluent_builders::DescribeExport<C, M, R> {
        fluent_builders::DescribeExport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeGlobalTable` operation.
    ///
    /// See [`DescribeGlobalTable`](crate::client::fluent_builders::DescribeGlobalTable) for more information about the
    /// operation and its arguments.
    pub fn describe_global_table(&self) -> fluent_builders::DescribeGlobalTable<C, M, R> {
        fluent_builders::DescribeGlobalTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeGlobalTableSettings` operation.
    ///
    /// See [`DescribeGlobalTableSettings`](crate::client::fluent_builders::DescribeGlobalTableSettings) for more information about the
    /// operation and its arguments.
    pub fn describe_global_table_settings(
        &self,
    ) -> fluent_builders::DescribeGlobalTableSettings<C, M, R> {
        fluent_builders::DescribeGlobalTableSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeKinesisStreamingDestination` operation.
    ///
    /// See [`DescribeKinesisStreamingDestination`](crate::client::fluent_builders::DescribeKinesisStreamingDestination) for more information about the
    /// operation and its arguments.
    pub fn describe_kinesis_streaming_destination(
        &self,
    ) -> fluent_builders::DescribeKinesisStreamingDestination<C, M, R> {
        fluent_builders::DescribeKinesisStreamingDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLimits` operation.
    ///
    /// See [`DescribeLimits`](crate::client::fluent_builders::DescribeLimits) for more information about the
    /// operation and its arguments.
    pub fn describe_limits(&self) -> fluent_builders::DescribeLimits<C, M, R> {
        fluent_builders::DescribeLimits::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTable` operation.
    ///
    /// See [`DescribeTable`](crate::client::fluent_builders::DescribeTable) for more information about the
    /// operation and its arguments.
    pub fn describe_table(&self) -> fluent_builders::DescribeTable<C, M, R> {
        fluent_builders::DescribeTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTableReplicaAutoScaling` operation.
    ///
    /// See [`DescribeTableReplicaAutoScaling`](crate::client::fluent_builders::DescribeTableReplicaAutoScaling) for more information about the
    /// operation and its arguments.
    pub fn describe_table_replica_auto_scaling(
        &self,
    ) -> fluent_builders::DescribeTableReplicaAutoScaling<C, M, R> {
        fluent_builders::DescribeTableReplicaAutoScaling::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTimeToLive` operation.
    ///
    /// See [`DescribeTimeToLive`](crate::client::fluent_builders::DescribeTimeToLive) for more information about the
    /// operation and its arguments.
    pub fn describe_time_to_live(&self) -> fluent_builders::DescribeTimeToLive<C, M, R> {
        fluent_builders::DescribeTimeToLive::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableKinesisStreamingDestination` operation.
    ///
    /// See [`DisableKinesisStreamingDestination`](crate::client::fluent_builders::DisableKinesisStreamingDestination) for more information about the
    /// operation and its arguments.
    pub fn disable_kinesis_streaming_destination(
        &self,
    ) -> fluent_builders::DisableKinesisStreamingDestination<C, M, R> {
        fluent_builders::DisableKinesisStreamingDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableKinesisStreamingDestination` operation.
    ///
    /// See [`EnableKinesisStreamingDestination`](crate::client::fluent_builders::EnableKinesisStreamingDestination) for more information about the
    /// operation and its arguments.
    pub fn enable_kinesis_streaming_destination(
        &self,
    ) -> fluent_builders::EnableKinesisStreamingDestination<C, M, R> {
        fluent_builders::EnableKinesisStreamingDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ExecuteStatement` operation.
    ///
    /// See [`ExecuteStatement`](crate::client::fluent_builders::ExecuteStatement) for more information about the
    /// operation and its arguments.
    pub fn execute_statement(&self) -> fluent_builders::ExecuteStatement<C, M, R> {
        fluent_builders::ExecuteStatement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ExecuteTransaction` operation.
    ///
    /// See [`ExecuteTransaction`](crate::client::fluent_builders::ExecuteTransaction) for more information about the
    /// operation and its arguments.
    pub fn execute_transaction(&self) -> fluent_builders::ExecuteTransaction<C, M, R> {
        fluent_builders::ExecuteTransaction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ExportTableToPointInTime` operation.
    ///
    /// See [`ExportTableToPointInTime`](crate::client::fluent_builders::ExportTableToPointInTime) for more information about the
    /// operation and its arguments.
    pub fn export_table_to_point_in_time(
        &self,
    ) -> fluent_builders::ExportTableToPointInTime<C, M, R> {
        fluent_builders::ExportTableToPointInTime::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetItem` operation.
    ///
    /// See [`GetItem`](crate::client::fluent_builders::GetItem) for more information about the
    /// operation and its arguments.
    pub fn get_item(&self) -> fluent_builders::GetItem<C, M, R> {
        fluent_builders::GetItem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBackups` operation.
    ///
    /// See [`ListBackups`](crate::client::fluent_builders::ListBackups) for more information about the
    /// operation and its arguments.
    pub fn list_backups(&self) -> fluent_builders::ListBackups<C, M, R> {
        fluent_builders::ListBackups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListContributorInsights` operation.
    ///
    /// See [`ListContributorInsights`](crate::client::fluent_builders::ListContributorInsights) for more information about the
    /// operation and its arguments.
    pub fn list_contributor_insights(&self) -> fluent_builders::ListContributorInsights<C, M, R> {
        fluent_builders::ListContributorInsights::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListExports` operation.
    ///
    /// See [`ListExports`](crate::client::fluent_builders::ListExports) for more information about the
    /// operation and its arguments.
    pub fn list_exports(&self) -> fluent_builders::ListExports<C, M, R> {
        fluent_builders::ListExports::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListGlobalTables` operation.
    ///
    /// See [`ListGlobalTables`](crate::client::fluent_builders::ListGlobalTables) for more information about the
    /// operation and its arguments.
    pub fn list_global_tables(&self) -> fluent_builders::ListGlobalTables<C, M, R> {
        fluent_builders::ListGlobalTables::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTables` operation.
    ///
    /// See [`ListTables`](crate::client::fluent_builders::ListTables) for more information about the
    /// operation and its arguments.
    pub fn list_tables(&self) -> fluent_builders::ListTables<C, M, R> {
        fluent_builders::ListTables::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsOfResource` operation.
    ///
    /// See [`ListTagsOfResource`](crate::client::fluent_builders::ListTagsOfResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_of_resource(&self) -> fluent_builders::ListTagsOfResource<C, M, R> {
        fluent_builders::ListTagsOfResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutItem` operation.
    ///
    /// See [`PutItem`](crate::client::fluent_builders::PutItem) for more information about the
    /// operation and its arguments.
    pub fn put_item(&self) -> fluent_builders::PutItem<C, M, R> {
        fluent_builders::PutItem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `Query` operation.
    ///
    /// See [`Query`](crate::client::fluent_builders::Query) for more information about the
    /// operation and its arguments.
    pub fn query(&self) -> fluent_builders::Query<C, M, R> {
        fluent_builders::Query::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RestoreTableFromBackup` operation.
    ///
    /// See [`RestoreTableFromBackup`](crate::client::fluent_builders::RestoreTableFromBackup) for more information about the
    /// operation and its arguments.
    pub fn restore_table_from_backup(&self) -> fluent_builders::RestoreTableFromBackup<C, M, R> {
        fluent_builders::RestoreTableFromBackup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RestoreTableToPointInTime` operation.
    ///
    /// See [`RestoreTableToPointInTime`](crate::client::fluent_builders::RestoreTableToPointInTime) for more information about the
    /// operation and its arguments.
    pub fn restore_table_to_point_in_time(
        &self,
    ) -> fluent_builders::RestoreTableToPointInTime<C, M, R> {
        fluent_builders::RestoreTableToPointInTime::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `Scan` operation.
    ///
    /// See [`Scan`](crate::client::fluent_builders::Scan) for more information about the
    /// operation and its arguments.
    pub fn scan(&self) -> fluent_builders::Scan<C, M, R> {
        fluent_builders::Scan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TransactGetItems` operation.
    ///
    /// See [`TransactGetItems`](crate::client::fluent_builders::TransactGetItems) for more information about the
    /// operation and its arguments.
    pub fn transact_get_items(&self) -> fluent_builders::TransactGetItems<C, M, R> {
        fluent_builders::TransactGetItems::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TransactWriteItems` operation.
    ///
    /// See [`TransactWriteItems`](crate::client::fluent_builders::TransactWriteItems) for more information about the
    /// operation and its arguments.
    pub fn transact_write_items(&self) -> fluent_builders::TransactWriteItems<C, M, R> {
        fluent_builders::TransactWriteItems::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateContinuousBackups` operation.
    ///
    /// See [`UpdateContinuousBackups`](crate::client::fluent_builders::UpdateContinuousBackups) for more information about the
    /// operation and its arguments.
    pub fn update_continuous_backups(&self) -> fluent_builders::UpdateContinuousBackups<C, M, R> {
        fluent_builders::UpdateContinuousBackups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateContributorInsights` operation.
    ///
    /// See [`UpdateContributorInsights`](crate::client::fluent_builders::UpdateContributorInsights) for more information about the
    /// operation and its arguments.
    pub fn update_contributor_insights(
        &self,
    ) -> fluent_builders::UpdateContributorInsights<C, M, R> {
        fluent_builders::UpdateContributorInsights::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateGlobalTable` operation.
    ///
    /// See [`UpdateGlobalTable`](crate::client::fluent_builders::UpdateGlobalTable) for more information about the
    /// operation and its arguments.
    pub fn update_global_table(&self) -> fluent_builders::UpdateGlobalTable<C, M, R> {
        fluent_builders::UpdateGlobalTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateGlobalTableSettings` operation.
    ///
    /// See [`UpdateGlobalTableSettings`](crate::client::fluent_builders::UpdateGlobalTableSettings) for more information about the
    /// operation and its arguments.
    pub fn update_global_table_settings(
        &self,
    ) -> fluent_builders::UpdateGlobalTableSettings<C, M, R> {
        fluent_builders::UpdateGlobalTableSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateItem` operation.
    ///
    /// See [`UpdateItem`](crate::client::fluent_builders::UpdateItem) for more information about the
    /// operation and its arguments.
    pub fn update_item(&self) -> fluent_builders::UpdateItem<C, M, R> {
        fluent_builders::UpdateItem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTable` operation.
    ///
    /// See [`UpdateTable`](crate::client::fluent_builders::UpdateTable) for more information about the
    /// operation and its arguments.
    pub fn update_table(&self) -> fluent_builders::UpdateTable<C, M, R> {
        fluent_builders::UpdateTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTableReplicaAutoScaling` operation.
    ///
    /// See [`UpdateTableReplicaAutoScaling`](crate::client::fluent_builders::UpdateTableReplicaAutoScaling) for more information about the
    /// operation and its arguments.
    pub fn update_table_replica_auto_scaling(
        &self,
    ) -> fluent_builders::UpdateTableReplicaAutoScaling<C, M, R> {
        fluent_builders::UpdateTableReplicaAutoScaling::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTimeToLive` operation.
    ///
    /// See [`UpdateTimeToLive`](crate::client::fluent_builders::UpdateTimeToLive) for more information about the
    /// operation and its arguments.
    pub fn update_time_to_live(&self) -> fluent_builders::UpdateTimeToLive<C, M, R> {
        fluent_builders::UpdateTimeToLive::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchExecuteStatement`.
    ///
    /// <p>
    /// This operation allows you to perform batch reads and writes on data stored in DynamoDB, using PartiQL.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct BatchExecuteStatement<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_execute_statement_input::Builder,
    }
    impl<C, M, R> BatchExecuteStatement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchExecuteStatement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchExecuteStatementOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchExecuteStatementError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchExecuteStatementInputOperationOutputAlias,
                crate::output::BatchExecuteStatementOutput,
                crate::error::BatchExecuteStatementError,
                crate::input::BatchExecuteStatementInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Statements`.
        ///
        /// To override the contents of this collection use [`set_statements`](Self::set_statements).
        ///
        /// <p>
        /// The list of PartiQL statements representing the batch to run.
        /// </p>
        pub fn statements(mut self, inp: impl Into<crate::model::BatchStatementRequest>) -> Self {
            self.inner = self.inner.statements(inp);
            self
        }
        /// <p>
        /// The list of PartiQL statements representing the batch to run.
        /// </p>
        pub fn set_statements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchStatementRequest>>,
        ) -> Self {
            self.inner = self.inner.set_statements(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetItem`.
    ///
    /// <p>The <code>BatchGetItem</code> operation returns the attributes of one or more items from one or
    /// more tables. You identify requested items by primary key.</p>
    /// <p>A single operation can retrieve up to 16 MB of data, which can contain as many as 100
    /// items. <code>BatchGetItem</code> returns a partial result if the response size limit is
    /// exceeded, the table's provisioned throughput is exceeded, or an internal processing
    /// failure occurs. If a partial result is returned, the operation returns a value for
    /// <code>UnprocessedKeys</code>. You can use this value to retry the operation starting
    /// with the next item to get.</p>
    /// <important>
    /// <p>If you request more than 100 items, <code>BatchGetItem</code> returns a
    /// <code>ValidationException</code> with the message "Too many items requested for
    /// the BatchGetItem call."</p>
    /// </important>
    /// <p>For example, if you ask to retrieve 100 items, but each individual item is 300 KB in
    /// size, the system returns 52 items (so as not to exceed the 16 MB limit). It also returns
    /// an appropriate <code>UnprocessedKeys</code> value so you can get the next page of
    /// results. If desired, your application can include its own logic to assemble the pages of
    /// results into one dataset.</p>
    /// <p>If <i>none</i> of the items can be processed due to insufficient
    /// provisioned throughput on all of the tables in the request, then
    /// <code>BatchGetItem</code> returns a
    /// <code>ProvisionedThroughputExceededException</code>. If <i>at least
    /// one</i> of the items is successfully processed, then
    /// <code>BatchGetItem</code> completes successfully, while returning the keys of the
    /// unread items in <code>UnprocessedKeys</code>.</p>
    /// <important>
    /// <p>If DynamoDB returns any unprocessed items, you should retry the batch operation on those
    /// items. However, <i>we strongly recommend that you use an exponential backoff algorithm</i>.
    /// If you retry the batch operation immediately, the underlying read or write requests can
    /// still fail due to throttling on the individual tables. If you delay the batch operation
    /// using exponential backoff, the individual requests in the batch are much more likely to
    /// succeed.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ErrorHandling.html#BatchOperations">Batch
    /// Operations and Error Handling</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    /// </important>
    /// <p>By default, <code>BatchGetItem</code> performs eventually consistent reads on every table in the
    /// request. If you want strongly consistent reads instead, you can set <code>ConsistentRead</code> to
    /// <code>true</code> for any or all tables.</p>
    /// <p>In order to minimize response latency, <code>BatchGetItem</code> retrieves items in parallel.</p>
    /// <p>When designing your application, keep in mind that DynamoDB does not return items in any
    /// particular order. To help parse the response by item, include the primary key values for the
    /// items in your request in the <code>ProjectionExpression</code> parameter.</p>
    /// <p>If a requested item does not exist, it is not returned in the result. Requests for
    /// nonexistent items consume the minimum read capacity units according to the type of read.
    /// For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#CapacityUnitCalculations">Working with Tables</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetItem<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_item_input::Builder,
    }
    impl<C, M, R> BatchGetItem<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetItem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetItemOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetItemError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetItemInputOperationOutputAlias,
                crate::output::BatchGetItemOutput,
                crate::error::BatchGetItemError,
                crate::input::BatchGetItemInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Adds a key-value pair to `RequestItems`.
        ///
        /// To override the contents of this collection use [`set_request_items`](Self::set_request_items).
        ///
        /// <p>A map of one or more table names and, for each table, a map that describes one or more items to retrieve from that table. Each table name can be used only once per <code>BatchGetItem</code> request.</p>
        /// <p>Each element in the map of items to retrieve consists of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ConsistentRead</code> - If <code>true</code>, a strongly consistent read is used; if
        /// <code>false</code> (the default), an eventually consistent read is used.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ExpressionAttributeNames</code> - One or more substitution tokens for attribute names in the <code>ProjectionExpression</code> parameter. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p>
        /// </li>
        /// <li>
        /// <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p>
        /// </li>
        /// <li>
        /// <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p>
        /// </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Percentile</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>{"#P":"Percentile"}</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#P = :val</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>
        /// </note>
        /// <p>For more information about expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB
        /// Developer Guide</i>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Keys</code> - An array of primary key attribute values that define specific items in the
        /// table. For each primary key, you must provide <i>all</i> of the key attributes. For
        /// example, with a simple primary key, you only need to provide the partition key value. For a
        /// composite key, you must provide <i>both</i> the partition key value and the sort key value.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ProjectionExpression</code> - A string that identifies one or more
        /// attributes to retrieve from the table. These attributes can include scalars,
        /// sets, or elements of a JSON document. The attributes in the expression must be
        /// separated by commas.</p>
        /// <p>If no attribute names are specified, then all attributes are returned. If any
        /// of the requested attributes are not found, they do not appear in the
        /// result.</p>
        /// <p>For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AttributesToGet</code> - This is a legacy parameter.  Use <code>ProjectionExpression</code> instead.  For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.
        ///
        /// </p>
        ///
        /// </li>
        /// </ul>
        pub fn request_items(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::KeysAndAttributes>,
        ) -> Self {
            self.inner = self.inner.request_items(k, v);
            self
        }
        /// <p>A map of one or more table names and, for each table, a map that describes one or more items to retrieve from that table. Each table name can be used only once per <code>BatchGetItem</code> request.</p>
        /// <p>Each element in the map of items to retrieve consists of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ConsistentRead</code> - If <code>true</code>, a strongly consistent read is used; if
        /// <code>false</code> (the default), an eventually consistent read is used.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ExpressionAttributeNames</code> - One or more substitution tokens for attribute names in the <code>ProjectionExpression</code> parameter. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p>
        /// </li>
        /// <li>
        /// <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p>
        /// </li>
        /// <li>
        /// <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p>
        /// </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Percentile</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>{"#P":"Percentile"}</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#P = :val</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>
        /// </note>
        /// <p>For more information about expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB
        /// Developer Guide</i>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Keys</code> - An array of primary key attribute values that define specific items in the
        /// table. For each primary key, you must provide <i>all</i> of the key attributes. For
        /// example, with a simple primary key, you only need to provide the partition key value. For a
        /// composite key, you must provide <i>both</i> the partition key value and the sort key value.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ProjectionExpression</code> - A string that identifies one or more
        /// attributes to retrieve from the table. These attributes can include scalars,
        /// sets, or elements of a JSON document. The attributes in the expression must be
        /// separated by commas.</p>
        /// <p>If no attribute names are specified, then all attributes are returned. If any
        /// of the requested attributes are not found, they do not appear in the
        /// result.</p>
        /// <p>For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AttributesToGet</code> - This is a legacy parameter.  Use <code>ProjectionExpression</code> instead.  For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.
        ///
        /// </p>
        ///
        /// </li>
        /// </ul>
        pub fn set_request_items(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::KeysAndAttributes>,
            >,
        ) -> Self {
            self.inner = self.inner.set_request_items(input);
            self
        }
        /// <p>Determines the level of detail about provisioned throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all.  In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p>
        /// </li>
        /// </ul>
        pub fn return_consumed_capacity(
            mut self,
            inp: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.inner = self.inner.return_consumed_capacity(inp);
            self
        }
        /// <p>Determines the level of detail about provisioned throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all.  In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p>
        /// </li>
        /// </ul>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.inner = self.inner.set_return_consumed_capacity(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchWriteItem`.
    ///
    /// <p>The <code>BatchWriteItem</code> operation puts or deletes multiple items in one or more
    /// tables. A single call to <code>BatchWriteItem</code> can write up to 16 MB of data,
    /// which can comprise as many as 25 put or delete requests. Individual items to be written
    /// can be as large as 400 KB.</p>
    /// <note>
    /// <p>
    /// <code>BatchWriteItem</code> cannot update items. To update items, use the <code>UpdateItem</code>
    /// action.</p>
    /// </note>
    /// <p>The individual <code>PutItem</code> and <code>DeleteItem</code> operations specified in
    /// <code>BatchWriteItem</code> are atomic; however <code>BatchWriteItem</code> as a whole is not. If any
    /// requested operations fail because the table's provisioned throughput is exceeded or an
    /// internal processing failure occurs, the failed operations are returned in the
    /// <code>UnprocessedItems</code> response parameter. You can investigate and optionally resend the
    /// requests. Typically, you would call <code>BatchWriteItem</code> in a loop. Each iteration would
    /// check for unprocessed items and submit a new <code>BatchWriteItem</code> request with those
    /// unprocessed items until all items have been processed.</p>
    /// <p>If <i>none</i> of the items can be processed due to insufficient
    /// provisioned throughput on all of the tables in the request, then
    /// <code>BatchWriteItem</code> returns a
    /// <code>ProvisionedThroughputExceededException</code>.</p>
    /// <important>
    /// <p>If DynamoDB returns any unprocessed items, you should retry the batch operation on those
    /// items. However, <i>we strongly recommend that you use an exponential backoff algorithm</i>.
    /// If you retry the batch operation immediately, the underlying read or write requests can
    /// still fail due to throttling on the individual tables. If you delay the batch operation
    /// using exponential backoff, the individual requests in the batch are much more likely to
    /// succeed.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ErrorHandling.html#Programming.Errors.BatchOperations">Batch Operations and Error Handling</a> in the <i>Amazon DynamoDB
    /// Developer Guide</i>.</p>
    /// </important>
    ///
    /// <p>With <code>BatchWriteItem</code>, you can efficiently write or delete large amounts of
    /// data, such as from Amazon EMR, or copy data from another database into DynamoDB. In
    /// order to improve performance with these large-scale operations,
    /// <code>BatchWriteItem</code> does not behave in the same way as individual
    /// <code>PutItem</code> and <code>DeleteItem</code> calls would. For example, you
    /// cannot specify conditions on individual put and delete requests, and
    /// <code>BatchWriteItem</code> does not return deleted items in the response.</p>
    /// <p>If you use a programming language that supports concurrency, you can use
    /// threads to write items in parallel. Your application must include the necessary logic to
    /// manage the threads. With languages that don't support threading, you must update
    /// or delete the specified items one at a time. In both situations, <code>BatchWriteItem</code>
    /// performs the specified put and delete operations in
    /// parallel, giving you the power of the thread pool approach without having to introduce
    /// complexity into your application.</p>
    /// <p>Parallel processing reduces latency, but each specified put and delete request consumes the same number of write capacity units whether it is processed in parallel or not. Delete operations on nonexistent items consume one write capacity unit.</p>
    /// <p>If one or more of the following is true, DynamoDB rejects the entire batch write operation:</p>
    /// <ul>
    /// <li>
    /// <p>One or more tables specified in the <code>BatchWriteItem</code> request does not exist.</p>
    /// </li>
    /// <li>
    /// <p>Primary key attributes specified on an item in the request do not match those in the corresponding table's primary key schema.</p>
    /// </li>
    /// <li>
    /// <p>You try to perform multiple operations on the same item in the same <code>BatchWriteItem</code>
    /// request. For example, you cannot put and delete the same item in the same
    /// <code>BatchWriteItem</code> request. </p>
    /// </li>
    /// <li>
    /// <p>
    /// Your request contains at least two items with identical hash and range keys (which essentially is two put operations).
    /// </p>
    /// </li>
    /// <li>
    /// <p>There are more than 25 requests in the batch.</p>
    /// </li>
    /// <li>
    /// <p>Any individual item in a batch exceeds 400 KB.</p>
    /// </li>
    /// <li>
    /// <p>The total request size exceeds 16 MB.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct BatchWriteItem<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_write_item_input::Builder,
    }
    impl<C, M, R> BatchWriteItem<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchWriteItem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchWriteItemOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchWriteItemError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchWriteItemInputOperationOutputAlias,
                crate::output::BatchWriteItemOutput,
                crate::error::BatchWriteItemError,
                crate::input::BatchWriteItemInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Adds a key-value pair to `RequestItems`.
        ///
        /// To override the contents of this collection use [`set_request_items`](Self::set_request_items).
        ///
        /// <p>A map of one or more table names and, for each table, a list of operations to be performed
        /// (<code>DeleteRequest</code> or <code>PutRequest</code>). Each element in the map consists of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DeleteRequest</code> - Perform a <code>DeleteItem</code> operation on the specified item. The
        /// item to be deleted is identified by a <code>Key</code> subelement:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Key</code> - A map of primary key attribute values that uniquely identify the item.
        /// Each entry in this map consists of an attribute name and an attribute value. For each
        /// primary key, you must provide <i>all</i> of the key attributes. For example, with a
        /// simple primary key, you only need to provide a value for the partition key. For a
        /// composite primary key, you must provide values for <i>both</i> the partition key and the sort key.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PutRequest</code> - Perform a <code>PutItem</code> operation on the specified item. The item to
        /// be put is identified by an <code>Item</code> subelement:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Item</code> - A map of attributes and their values. Each entry in
        /// this map consists of an attribute name and an attribute value. Attribute
        /// values must not be null; string and binary type attributes must have
        /// lengths greater than zero; and set type attributes must not be empty.
        /// Requests that contain empty values are rejected with a
        /// <code>ValidationException</code> exception.</p>
        /// <p>If you specify any attributes that are part of an index key, then the data types for those attributes must match those of the schema in the table's attribute definition.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn request_items(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<crate::model::WriteRequest>>,
        ) -> Self {
            self.inner = self.inner.request_items(k, v);
            self
        }
        /// <p>A map of one or more table names and, for each table, a list of operations to be performed
        /// (<code>DeleteRequest</code> or <code>PutRequest</code>). Each element in the map consists of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DeleteRequest</code> - Perform a <code>DeleteItem</code> operation on the specified item. The
        /// item to be deleted is identified by a <code>Key</code> subelement:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Key</code> - A map of primary key attribute values that uniquely identify the item.
        /// Each entry in this map consists of an attribute name and an attribute value. For each
        /// primary key, you must provide <i>all</i> of the key attributes. For example, with a
        /// simple primary key, you only need to provide a value for the partition key. For a
        /// composite primary key, you must provide values for <i>both</i> the partition key and the sort key.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PutRequest</code> - Perform a <code>PutItem</code> operation on the specified item. The item to
        /// be put is identified by an <code>Item</code> subelement:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Item</code> - A map of attributes and their values. Each entry in
        /// this map consists of an attribute name and an attribute value. Attribute
        /// values must not be null; string and binary type attributes must have
        /// lengths greater than zero; and set type attributes must not be empty.
        /// Requests that contain empty values are rejected with a
        /// <code>ValidationException</code> exception.</p>
        /// <p>If you specify any attributes that are part of an index key, then the data types for those attributes must match those of the schema in the table's attribute definition.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_request_items(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::vec::Vec<crate::model::WriteRequest>,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_request_items(input);
            self
        }
        /// <p>Determines the level of detail about provisioned throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all.  In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p>
        /// </li>
        /// </ul>
        pub fn return_consumed_capacity(
            mut self,
            inp: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.inner = self.inner.return_consumed_capacity(inp);
            self
        }
        /// <p>Determines the level of detail about provisioned throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all.  In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p>
        /// </li>
        /// </ul>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.inner = self.inner.set_return_consumed_capacity(input);
            self
        }
        /// <p>Determines whether item collection metrics are returned.  If set to <code>SIZE</code>, the response includes statistics about item collections, if any, that were modified during
        /// the operation are returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.</p>
        pub fn return_item_collection_metrics(
            mut self,
            inp: crate::model::ReturnItemCollectionMetrics,
        ) -> Self {
            self.inner = self.inner.return_item_collection_metrics(inp);
            self
        }
        /// <p>Determines whether item collection metrics are returned.  If set to <code>SIZE</code>, the response includes statistics about item collections, if any, that were modified during
        /// the operation are returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.</p>
        pub fn set_return_item_collection_metrics(
            mut self,
            input: std::option::Option<crate::model::ReturnItemCollectionMetrics>,
        ) -> Self {
            self.inner = self.inner.set_return_item_collection_metrics(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBackup`.
    ///
    /// <p>Creates a backup for an existing table.</p>
    /// <p> Each time you create an on-demand backup, the entire table data is backed up. There
    /// is no limit to the number of on-demand backups that can be taken. </p>
    /// <p> When you create an on-demand backup, a time marker of the request is cataloged, and
    /// the backup is created asynchronously, by applying all changes until the time of the
    /// request to the last full table snapshot. Backup requests are processed instantaneously
    /// and become available for restore within minutes. </p>
    /// <p>You can call <code>CreateBackup</code> at a maximum rate of 50 times per second.</p>
    /// <p>All backups in DynamoDB work without consuming any provisioned throughput on the table.</p>
    /// <p> If you submit a backup request on 2018-12-14 at 14:25:00, the backup is guaranteed
    /// to contain all data committed to the table up to 14:24:00, and data committed after
    /// 14:26:00 will not be. The backup might contain data modifications made between 14:24:00
    /// and 14:26:00. On-demand backup does not support causal consistency. </p>
    /// <p>
    /// Along with data, the following are also included on the backups:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>Global secondary indexes (GSIs)</p>
    /// </li>
    /// <li>
    /// <p>Local secondary indexes (LSIs)</p>
    /// </li>
    /// <li>
    /// <p>Streams</p>
    /// </li>
    /// <li>
    /// <p>Provisioned read and write capacity</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct CreateBackup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_backup_input::Builder,
    }
    impl<C, M, R> CreateBackup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBackup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBackupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBackupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBackupInputOperationOutputAlias,
                crate::output::CreateBackupOutput,
                crate::error::CreateBackupError,
                crate::input::CreateBackupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the table.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>Specified name for the backup.</p>
        pub fn backup_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_name(inp);
            self
        }
        /// <p>Specified name for the backup.</p>
        pub fn set_backup_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_backup_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGlobalTable`.
    ///
    /// <p>Creates a global table from an existing table. A global table creates a replication
    /// relationship between two or more DynamoDB tables with the same table name in the
    /// provided Regions. </p>
    /// <note>
    /// <p>This operation only applies to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html">Version 2017.11.29</a> of global tables.</p>
    /// </note>
    ///
    /// <p>If you want to add a new replica table to a global table, each of the following conditions
    /// must be true:</p>
    /// <ul>
    /// <li>
    /// <p>The table must have the same primary key as all of the other replicas.</p>
    /// </li>
    /// <li>
    /// <p>The table must have the same name as all of the other replicas.</p>
    /// </li>
    /// <li>
    /// <p>The table must have DynamoDB Streams enabled, with the stream containing both the new and the old
    /// images of the item.</p>
    /// </li>
    /// <li>
    /// <p>None of the replica tables in the global table can contain any data.</p>
    /// </li>
    /// </ul>
    /// <p>
    /// If global secondary indexes are specified, then the following conditions must also be met:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The global secondary indexes must have the same name.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The global secondary indexes must have the same hash key and sort key (if present).
    /// </p>
    /// </li>
    /// </ul>
    /// <p>
    /// If local secondary indexes are specified, then the following conditions must also be met:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The local secondary indexes must have the same name.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The local secondary indexes must have the same hash key and sort key (if present).
    /// </p>
    /// </li>
    /// </ul>
    ///
    /// <important>
    /// <p>
    /// Write capacity settings should be set consistently across your replica tables and
    /// secondary indexes. DynamoDB strongly recommends enabling auto scaling to manage the write
    /// capacity settings for all of your global tables replicas and indexes.
    /// </p>
    /// <p>
    /// If you prefer to manage write capacity settings manually, you should provision equal
    /// replicated write capacity units to your replica tables. You should also provision
    /// equal replicated write capacity units to matching secondary indexes across
    /// your global table.
    /// </p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct CreateGlobalTable<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_global_table_input::Builder,
    }
    impl<C, M, R> CreateGlobalTable<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateGlobalTable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGlobalTableOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGlobalTableError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateGlobalTableInputOperationOutputAlias,
                crate::output::CreateGlobalTableOutput,
                crate::error::CreateGlobalTableError,
                crate::input::CreateGlobalTableInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The global table name.</p>
        pub fn global_table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_table_name(inp);
            self
        }
        /// <p>The global table name.</p>
        pub fn set_global_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_table_name(input);
            self
        }
        /// Appends an item to `ReplicationGroup`.
        ///
        /// To override the contents of this collection use [`set_replication_group`](Self::set_replication_group).
        ///
        /// <p>The Regions where the global table needs to be created.</p>
        pub fn replication_group(mut self, inp: impl Into<crate::model::Replica>) -> Self {
            self.inner = self.inner.replication_group(inp);
            self
        }
        /// <p>The Regions where the global table needs to be created.</p>
        pub fn set_replication_group(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Replica>>,
        ) -> Self {
            self.inner = self.inner.set_replication_group(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTable`.
    ///
    /// <p>The <code>CreateTable</code> operation adds a new table to your account. In an AWS
    /// account, table names must be unique within each Region. That is, you can have two tables
    /// with same name if you create the tables in different Regions.</p>
    /// <p>
    /// <code>CreateTable</code> is an asynchronous operation. Upon receiving a <code>CreateTable</code> request,
    /// DynamoDB immediately returns a response with a <code>TableStatus</code> of <code>CREATING</code>. After
    /// the table is created, DynamoDB sets the <code>TableStatus</code> to <code>ACTIVE</code>. You can
    /// perform read and write operations only on an <code>ACTIVE</code> table. </p>
    /// <p>You can optionally define secondary indexes on the new table, as part of the <code>CreateTable</code>
    /// operation. If you want to create multiple tables with secondary indexes on them, you must create the
    /// tables sequentially. Only one table with secondary indexes can be in the <code>CREATING</code> state at
    /// any given time.</p>
    /// <p>You can use the <code>DescribeTable</code> action to check the table status.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateTable<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_table_input::Builder,
    }
    impl<C, M, R> CreateTable<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTableOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTableError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTableInputOperationOutputAlias,
                crate::output::CreateTableOutput,
                crate::error::CreateTableError,
                crate::input::CreateTableInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AttributeDefinitions`.
        ///
        /// To override the contents of this collection use [`set_attribute_definitions`](Self::set_attribute_definitions).
        ///
        /// <p>An array of attributes that describe the key schema for the table and indexes.</p>
        pub fn attribute_definitions(
            mut self,
            inp: impl Into<crate::model::AttributeDefinition>,
        ) -> Self {
            self.inner = self.inner.attribute_definitions(inp);
            self
        }
        /// <p>An array of attributes that describe the key schema for the table and indexes.</p>
        pub fn set_attribute_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeDefinition>>,
        ) -> Self {
            self.inner = self.inner.set_attribute_definitions(input);
            self
        }
        /// <p>The name of the table to create.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the table to create.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// Appends an item to `KeySchema`.
        ///
        /// To override the contents of this collection use [`set_key_schema`](Self::set_key_schema).
        ///
        /// <p>Specifies the attributes that make up the primary key for a table or an index. The attributes
        /// in <code>KeySchema</code> must also be defined in the <code>AttributeDefinitions</code> array. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html">Data Model</a> in the
        /// <i>Amazon DynamoDB Developer Guide</i>.</p>
        /// <p>Each <code>KeySchemaElement</code> in the array is composed of:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AttributeName</code> - The name of this key attribute.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KeyType</code> - The role that the key attribute will assume:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>HASH</code> - partition key</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RANGE</code> - sort key</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>The partition key of an item is also known as its <i>hash
        /// attribute</i>. The term "hash attribute" derives from the DynamoDB usage of
        /// an internal hash function to evenly distribute data items across partitions, based
        /// on their partition key values.</p>
        /// <p>The sort key of an item is also known as its <i>range attribute</i>.
        /// The term "range attribute" derives from the way DynamoDB stores items with the same
        /// partition key physically close together, in sorted order by the sort key value.</p>
        /// </note>
        ///
        /// <p>For a simple primary key (partition key), you must provide
        /// exactly one element with a <code>KeyType</code> of <code>HASH</code>.</p>
        /// <p>For a composite primary key (partition key and sort key), you must provide exactly two
        /// elements, in this order: The first element must have a <code>KeyType</code> of <code>HASH</code>,
        /// and the second element must have a <code>KeyType</code> of <code>RANGE</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key">Working with Tables</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn key_schema(mut self, inp: impl Into<crate::model::KeySchemaElement>) -> Self {
            self.inner = self.inner.key_schema(inp);
            self
        }
        /// <p>Specifies the attributes that make up the primary key for a table or an index. The attributes
        /// in <code>KeySchema</code> must also be defined in the <code>AttributeDefinitions</code> array. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html">Data Model</a> in the
        /// <i>Amazon DynamoDB Developer Guide</i>.</p>
        /// <p>Each <code>KeySchemaElement</code> in the array is composed of:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AttributeName</code> - The name of this key attribute.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KeyType</code> - The role that the key attribute will assume:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>HASH</code> - partition key</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RANGE</code> - sort key</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>The partition key of an item is also known as its <i>hash
        /// attribute</i>. The term "hash attribute" derives from the DynamoDB usage of
        /// an internal hash function to evenly distribute data items across partitions, based
        /// on their partition key values.</p>
        /// <p>The sort key of an item is also known as its <i>range attribute</i>.
        /// The term "range attribute" derives from the way DynamoDB stores items with the same
        /// partition key physically close together, in sorted order by the sort key value.</p>
        /// </note>
        ///
        /// <p>For a simple primary key (partition key), you must provide
        /// exactly one element with a <code>KeyType</code> of <code>HASH</code>.</p>
        /// <p>For a composite primary key (partition key and sort key), you must provide exactly two
        /// elements, in this order: The first element must have a <code>KeyType</code> of <code>HASH</code>,
        /// and the second element must have a <code>KeyType</code> of <code>RANGE</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key">Working with Tables</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_key_schema(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
        ) -> Self {
            self.inner = self.inner.set_key_schema(input);
            self
        }
        /// Appends an item to `LocalSecondaryIndexes`.
        ///
        /// To override the contents of this collection use [`set_local_secondary_indexes`](Self::set_local_secondary_indexes).
        ///
        /// <p>One or more local secondary indexes (the maximum is 5) to be created on the table. Each index is scoped to a given partition key value. There is a 10 GB size limit per partition key value; otherwise, the size of a local secondary index is unconstrained.</p>
        /// <p>Each local secondary index in the array includes the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>IndexName</code> - The name of the local secondary index. Must be unique only for this table.</p>
        /// <p></p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KeySchema</code> - Specifies the key schema for the local secondary index. The key schema must begin with
        /// the same partition key as the table.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Projection</code> - Specifies
        /// attributes that are copied (projected) from the table into the index. These are in
        /// addition to the primary key attributes and index key
        /// attributes, which are automatically projected. Each
        /// attribute specification is composed of:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ProjectionType</code> - One
        /// of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the
        /// index.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INCLUDE</code> - Only the specified table attributes are
        /// projected into the index. The list of projected attributes is in
        /// <code>NonKeyAttributes</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL</code> - All of the table attributes are projected into the
        /// index.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NonKeyAttributes</code> - A list of one or more non-key
        /// attribute names that are projected into the secondary index. The total
        /// count of attributes provided in <code>NonKeyAttributes</code>,
        /// summed across all of the secondary indexes, must not exceed 100. If you
        /// project the same attribute into two different indexes, this counts as
        /// two distinct attributes when determining the total.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn local_secondary_indexes(
            mut self,
            inp: impl Into<crate::model::LocalSecondaryIndex>,
        ) -> Self {
            self.inner = self.inner.local_secondary_indexes(inp);
            self
        }
        /// <p>One or more local secondary indexes (the maximum is 5) to be created on the table. Each index is scoped to a given partition key value. There is a 10 GB size limit per partition key value; otherwise, the size of a local secondary index is unconstrained.</p>
        /// <p>Each local secondary index in the array includes the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>IndexName</code> - The name of the local secondary index. Must be unique only for this table.</p>
        /// <p></p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KeySchema</code> - Specifies the key schema for the local secondary index. The key schema must begin with
        /// the same partition key as the table.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Projection</code> - Specifies
        /// attributes that are copied (projected) from the table into the index. These are in
        /// addition to the primary key attributes and index key
        /// attributes, which are automatically projected. Each
        /// attribute specification is composed of:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ProjectionType</code> - One
        /// of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the
        /// index.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INCLUDE</code> - Only the specified table attributes are
        /// projected into the index. The list of projected attributes is in
        /// <code>NonKeyAttributes</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL</code> - All of the table attributes are projected into the
        /// index.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NonKeyAttributes</code> - A list of one or more non-key
        /// attribute names that are projected into the secondary index. The total
        /// count of attributes provided in <code>NonKeyAttributes</code>,
        /// summed across all of the secondary indexes, must not exceed 100. If you
        /// project the same attribute into two different indexes, this counts as
        /// two distinct attributes when determining the total.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_local_secondary_indexes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LocalSecondaryIndex>>,
        ) -> Self {
            self.inner = self.inner.set_local_secondary_indexes(input);
            self
        }
        /// Appends an item to `GlobalSecondaryIndexes`.
        ///
        /// To override the contents of this collection use [`set_global_secondary_indexes`](Self::set_global_secondary_indexes).
        ///
        /// <p>One or more global secondary indexes (the maximum is 20) to be created on the table. Each global secondary index in the array includes the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>IndexName</code> - The name of the global secondary index. Must be unique only for this table.</p>
        /// <p></p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KeySchema</code> - Specifies the key schema for the global secondary index.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Projection</code> - Specifies
        /// attributes that are copied (projected) from the table into the index. These are in
        /// addition to the primary key attributes and index key
        /// attributes, which are automatically projected. Each
        /// attribute specification is composed of:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ProjectionType</code> - One
        /// of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the
        /// index.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INCLUDE</code> - Only the specified table attributes are
        /// projected into the index. The list of projected attributes is in
        /// <code>NonKeyAttributes</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL</code> - All of the table attributes are projected into the
        /// index.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are
        /// projected into the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary index,
        /// consisting of read and write capacity units.</p>
        /// </li>
        /// </ul>
        pub fn global_secondary_indexes(
            mut self,
            inp: impl Into<crate::model::GlobalSecondaryIndex>,
        ) -> Self {
            self.inner = self.inner.global_secondary_indexes(inp);
            self
        }
        /// <p>One or more global secondary indexes (the maximum is 20) to be created on the table. Each global secondary index in the array includes the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>IndexName</code> - The name of the global secondary index. Must be unique only for this table.</p>
        /// <p></p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KeySchema</code> - Specifies the key schema for the global secondary index.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Projection</code> - Specifies
        /// attributes that are copied (projected) from the table into the index. These are in
        /// addition to the primary key attributes and index key
        /// attributes, which are automatically projected. Each
        /// attribute specification is composed of:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ProjectionType</code> - One
        /// of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the
        /// index.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INCLUDE</code> - Only the specified table attributes are
        /// projected into the index. The list of projected attributes is in
        /// <code>NonKeyAttributes</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL</code> - All of the table attributes are projected into the
        /// index.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are
        /// projected into the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary index,
        /// consisting of read and write capacity units.</p>
        /// </li>
        /// </ul>
        pub fn set_global_secondary_indexes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GlobalSecondaryIndex>>,
        ) -> Self {
            self.inner = self.inner.set_global_secondary_indexes(input);
            self
        }
        /// <p>Controls how you are charged for read and write throughput and how you manage capacity. This setting can be changed later.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual">Provisioned Mode</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand">On-Demand Mode</a>.
        /// </p>
        /// </li>
        /// </ul>
        pub fn billing_mode(mut self, inp: crate::model::BillingMode) -> Self {
            self.inner = self.inner.billing_mode(inp);
            self
        }
        /// <p>Controls how you are charged for read and write throughput and how you manage capacity. This setting can be changed later.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual">Provisioned Mode</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand">On-Demand Mode</a>.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_billing_mode(
            mut self,
            input: std::option::Option<crate::model::BillingMode>,
        ) -> Self {
            self.inner = self.inner.set_billing_mode(input);
            self
        }
        /// <p>Represents the provisioned throughput settings for a specified table or index. The
        /// settings can be modified using the <code>UpdateTable</code> operation.</p>
        /// <p> If you set BillingMode as <code>PROVISIONED</code>, you must specify this property. If you
        /// set BillingMode as <code>PAY_PER_REQUEST</code>, you cannot specify this
        /// property.</p>
        /// <p>For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service,
        /// Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn provisioned_throughput(mut self, inp: crate::model::ProvisionedThroughput) -> Self {
            self.inner = self.inner.provisioned_throughput(inp);
            self
        }
        /// <p>Represents the provisioned throughput settings for a specified table or index. The
        /// settings can be modified using the <code>UpdateTable</code> operation.</p>
        /// <p> If you set BillingMode as <code>PROVISIONED</code>, you must specify this property. If you
        /// set BillingMode as <code>PAY_PER_REQUEST</code>, you cannot specify this
        /// property.</p>
        /// <p>For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service,
        /// Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_provisioned_throughput(
            mut self,
            input: std::option::Option<crate::model::ProvisionedThroughput>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_throughput(input);
            self
        }
        /// <p>The settings for DynamoDB Streams on the table. These settings consist of:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>StreamEnabled</code> - Indicates whether DynamoDB Streams is to be enabled
        /// (true) or disabled (false).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>StreamViewType</code> - When an item in the table is modified, <code>StreamViewType</code>
        /// determines what information is written to the table's stream. Valid values for
        /// <code>StreamViewType</code> are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the
        /// stream.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written
        /// to the stream.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is
        /// written to the stream.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are
        /// written to the stream.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn stream_specification(mut self, inp: crate::model::StreamSpecification) -> Self {
            self.inner = self.inner.stream_specification(inp);
            self
        }
        /// <p>The settings for DynamoDB Streams on the table. These settings consist of:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>StreamEnabled</code> - Indicates whether DynamoDB Streams is to be enabled
        /// (true) or disabled (false).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>StreamViewType</code> - When an item in the table is modified, <code>StreamViewType</code>
        /// determines what information is written to the table's stream. Valid values for
        /// <code>StreamViewType</code> are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the
        /// stream.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written
        /// to the stream.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is
        /// written to the stream.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are
        /// written to the stream.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_stream_specification(
            mut self,
            input: std::option::Option<crate::model::StreamSpecification>,
        ) -> Self {
            self.inner = self.inner.set_stream_specification(input);
            self
        }
        /// <p>Represents the settings used to enable server-side encryption.</p>
        pub fn sse_specification(mut self, inp: crate::model::SseSpecification) -> Self {
            self.inner = self.inner.sse_specification(inp);
            self
        }
        /// <p>Represents the settings used to enable server-side encryption.</p>
        pub fn set_sse_specification(
            mut self,
            input: std::option::Option<crate::model::SseSpecification>,
        ) -> Self {
            self.inner = self.inner.set_sse_specification(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs to label the table. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for DynamoDB</a>.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of key-value pairs to label the table. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for DynamoDB</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBackup`.
    ///
    /// <p>Deletes an existing backup of a table.</p>
    /// <p>You can call <code>DeleteBackup</code> at a maximum rate of 10 times per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBackup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_backup_input::Builder,
    }
    impl<C, M, R> DeleteBackup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBackup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBackupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBackupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBackupInputOperationOutputAlias,
                crate::output::DeleteBackupOutput,
                crate::error::DeleteBackupError,
                crate::input::DeleteBackupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN associated with the backup.</p>
        pub fn backup_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_arn(inp);
            self
        }
        /// <p>The ARN associated with the backup.</p>
        pub fn set_backup_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_backup_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteItem`.
    ///
    /// <p>Deletes a single item in a table by primary key. You can perform a conditional delete operation that deletes the item if it exists, or if it has an expected attribute value.</p>
    /// <p>In addition to deleting an item, you can also return the item's attribute values in the same
    /// operation, using the <code>ReturnValues</code> parameter.</p>
    /// <p>Unless you specify conditions, the <code>DeleteItem</code> is an idempotent operation; running it
    /// multiple times on the same item or attribute does <i>not</i> result in an error response.</p>
    /// <p>Conditional deletes are useful for deleting items only if specific conditions are met. If those conditions are met, DynamoDB performs the delete. Otherwise, the item is not deleted.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteItem<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_item_input::Builder,
    }
    impl<C, M, R> DeleteItem<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteItem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteItemOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteItemError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteItemInputOperationOutputAlias,
                crate::output::DeleteItemOutput,
                crate::error::DeleteItemError,
                crate::input::DeleteItemInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the table from which to delete the item.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the table from which to delete the item.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// Adds a key-value pair to `Key`.
        ///
        /// To override the contents of this collection use [`set_key`](Self::set_key).
        ///
        /// <p>A map of attribute names to <code>AttributeValue</code> objects, representing the primary key of
        /// the item to delete.</p>
        /// <p>For the primary key, you must provide all of the attributes. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide values for both the partition key and the sort key.</p>
        pub fn key(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeValue>,
        ) -> Self {
            self.inner = self.inner.key(k, v);
            self
        }
        /// <p>A map of attribute names to <code>AttributeValue</code> objects, representing the primary key of
        /// the item to delete.</p>
        /// <p>For the primary key, you must provide all of the attributes. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide values for both the partition key and the sort key.</p>
        pub fn set_key(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_key(input);
            self
        }
        /// Adds a key-value pair to `Expected`.
        ///
        /// To override the contents of this collection use [`set_expected`](Self::set_expected).
        ///
        /// <p>This is a legacy parameter.  Use <code>ConditionExpression</code> instead.  For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html">Expected</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn expected(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ExpectedAttributeValue>,
        ) -> Self {
            self.inner = self.inner.expected(k, v);
            self
        }
        /// <p>This is a legacy parameter.  Use <code>ConditionExpression</code> instead.  For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html">Expected</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_expected(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::ExpectedAttributeValue,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_expected(input);
            self
        }
        /// <p>This is a legacy parameter.  Use <code>ConditionExpression</code> instead.  For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn conditional_operator(mut self, inp: crate::model::ConditionalOperator) -> Self {
            self.inner = self.inner.conditional_operator(inp);
            self
        }
        /// <p>This is a legacy parameter.  Use <code>ConditionExpression</code> instead.  For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_conditional_operator(
            mut self,
            input: std::option::Option<crate::model::ConditionalOperator>,
        ) -> Self {
            self.inner = self.inner.set_conditional_operator(input);
            self
        }
        /// <p>Use <code>ReturnValues</code> if you want to get the item attributes as they appeared before they
        /// were deleted. For <code>DeleteItem</code>, the valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is
        /// <code>NONE</code>, then nothing is returned. (This setting is the default for
        /// <code>ReturnValues</code>.)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL_OLD</code> - The content of the old item is returned.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>The <code>ReturnValues</code> parameter is used by several DynamoDB operations; however,
        /// <code>DeleteItem</code> does not recognize any values other than <code>NONE</code> or
        /// <code>ALL_OLD</code>.</p>
        /// </note>
        pub fn return_values(mut self, inp: crate::model::ReturnValue) -> Self {
            self.inner = self.inner.return_values(inp);
            self
        }
        /// <p>Use <code>ReturnValues</code> if you want to get the item attributes as they appeared before they
        /// were deleted. For <code>DeleteItem</code>, the valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is
        /// <code>NONE</code>, then nothing is returned. (This setting is the default for
        /// <code>ReturnValues</code>.)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL_OLD</code> - The content of the old item is returned.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>The <code>ReturnValues</code> parameter is used by several DynamoDB operations; however,
        /// <code>DeleteItem</code> does not recognize any values other than <code>NONE</code> or
        /// <code>ALL_OLD</code>.</p>
        /// </note>
        pub fn set_return_values(
            mut self,
            input: std::option::Option<crate::model::ReturnValue>,
        ) -> Self {
            self.inner = self.inner.set_return_values(input);
            self
        }
        /// <p>Determines the level of detail about provisioned throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all.  In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p>
        /// </li>
        /// </ul>
        pub fn return_consumed_capacity(
            mut self,
            inp: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.inner = self.inner.return_consumed_capacity(inp);
            self
        }
        /// <p>Determines the level of detail about provisioned throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all.  In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p>
        /// </li>
        /// </ul>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.inner = self.inner.set_return_consumed_capacity(input);
            self
        }
        /// <p>Determines whether item collection metrics are returned.  If set to <code>SIZE</code>, the response includes statistics about item collections, if any, that were modified during
        /// the operation are returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.</p>
        pub fn return_item_collection_metrics(
            mut self,
            inp: crate::model::ReturnItemCollectionMetrics,
        ) -> Self {
            self.inner = self.inner.return_item_collection_metrics(inp);
            self
        }
        /// <p>Determines whether item collection metrics are returned.  If set to <code>SIZE</code>, the response includes statistics about item collections, if any, that were modified during
        /// the operation are returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.</p>
        pub fn set_return_item_collection_metrics(
            mut self,
            input: std::option::Option<crate::model::ReturnItemCollectionMetrics>,
        ) -> Self {
            self.inner = self.inner.set_return_item_collection_metrics(input);
            self
        }
        /// <p>A condition that must be satisfied in order for a conditional <code>DeleteItem</code> to
        /// succeed.</p>
        /// <p>An expression can contain any of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Functions: <code>attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size</code>
        /// </p>
        /// <p>These function names are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Comparison operators: <code>= | <> |
        /// < | > | <= | >= |
        /// BETWEEN | IN </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p> Logical operators: <code>AND | OR | NOT</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information about condition expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn condition_expression(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.condition_expression(inp);
            self
        }
        /// <p>A condition that must be satisfied in order for a conditional <code>DeleteItem</code> to
        /// succeed.</p>
        /// <p>An expression can contain any of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Functions: <code>attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size</code>
        /// </p>
        /// <p>These function names are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Comparison operators: <code>= | <> |
        /// < | > | <= | >= |
        /// BETWEEN | IN </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p> Logical operators: <code>AND | OR | NOT</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information about condition expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_condition_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_condition_expression(input);
            self
        }
        /// Adds a key-value pair to `ExpressionAttributeNames`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_names`](Self::set_expression_attribute_names).
        ///
        /// <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p>
        /// </li>
        /// <li>
        /// <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p>
        /// </li>
        /// <li>
        /// <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p>
        /// </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Percentile</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>{"#P":"Percentile"}</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#P = :val</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>
        /// </note>
        /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn expression_attribute_names(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.expression_attribute_names(k, v);
            self
        }
        /// <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p>
        /// </li>
        /// <li>
        /// <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p>
        /// </li>
        /// <li>
        /// <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p>
        /// </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Percentile</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>{"#P":"Percentile"}</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#P = :val</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>
        /// </note>
        /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_expression_attribute_names(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_expression_attribute_names(input);
            self
        }
        /// Adds a key-value pair to `ExpressionAttributeValues`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_values`](Self::set_expression_attribute_values).
        ///
        /// <p>One or more values that can be substituted in an expression.</p>
        /// <p>Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose that you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of the following: </p>
        /// <p>
        /// <code>Available | Backordered | Discontinued</code>
        /// </p>
        /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as follows:</p>
        /// <p>
        /// <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
        /// </p>
        /// <p>You could then use these values in an expression, such as this:</p>
        /// <p>
        /// <code>ProductStatus IN (:avail, :back, :disc)</code>
        /// </p>
        /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn expression_attribute_values(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeValue>,
        ) -> Self {
            self.inner = self.inner.expression_attribute_values(k, v);
            self
        }
        /// <p>One or more values that can be substituted in an expression.</p>
        /// <p>Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose that you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of the following: </p>
        /// <p>
        /// <code>Available | Backordered | Discontinued</code>
        /// </p>
        /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as follows:</p>
        /// <p>
        /// <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
        /// </p>
        /// <p>You could then use these values in an expression, such as this:</p>
        /// <p>
        /// <code>ProductStatus IN (:avail, :back, :disc)</code>
        /// </p>
        /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_expression_attribute_values(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_expression_attribute_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTable`.
    ///
    /// <p>The <code>DeleteTable</code> operation deletes a table and all of its items. After a
    /// <code>DeleteTable</code> request, the specified table is in the <code>DELETING</code> state until
    /// DynamoDB completes the deletion. If the table is in the <code>ACTIVE</code> state, you can delete
    /// it. If a table is in <code>CREATING</code> or <code>UPDATING</code> states, then DynamoDB returns
    /// a <code>ResourceInUseException</code>. If the specified table does not exist, DynamoDB returns a
    /// <code>ResourceNotFoundException</code>. If table is already in the <code>DELETING</code> state, no
    /// error is returned. </p>
    /// <note>
    /// <p>DynamoDB might continue to accept data read and write operations, such as <code>GetItem</code> and
    /// <code>PutItem</code>, on a table in the <code>DELETING</code> state until the table deletion is
    /// complete.</p>
    /// </note>
    /// <p>When you delete a table, any indexes on that table are also deleted.</p>
    /// <p>If you have DynamoDB Streams enabled on the table, then the corresponding stream on that table goes
    /// into the <code>DISABLED</code> state, and the stream is automatically deleted after 24 hours.</p>
    ///
    /// <p>Use the <code>DescribeTable</code> action to check the status of the table. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteTable<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_table_input::Builder,
    }
    impl<C, M, R> DeleteTable<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTableOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTableError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTableInputOperationOutputAlias,
                crate::output::DeleteTableOutput,
                crate::error::DeleteTableError,
                crate::input::DeleteTableInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the table to delete.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the table to delete.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBackup`.
    ///
    /// <p>Describes an existing backup of a table.</p>
    /// <p>You can call <code>DescribeBackup</code> at a maximum rate of 10 times per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeBackup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_backup_input::Builder,
    }
    impl<C, M, R> DescribeBackup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeBackup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBackupOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBackupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeBackupInputOperationOutputAlias,
                crate::output::DescribeBackupOutput,
                crate::error::DescribeBackupError,
                crate::input::DescribeBackupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) associated with the backup.</p>
        pub fn backup_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) associated with the backup.</p>
        pub fn set_backup_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_backup_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeContinuousBackups`.
    ///
    /// <p>Checks the status of continuous backups and point in time recovery on the specified table.
    /// Continuous backups are <code>ENABLED</code> on all tables at table creation.
    /// If point in time recovery is enabled, <code>PointInTimeRecoveryStatus</code> will be set to ENABLED.</p>
    /// <p> After continuous backups and point in time recovery are enabled, you can restore to any
    /// point in time within <code>EarliestRestorableDateTime</code> and
    /// <code>LatestRestorableDateTime</code>. </p>
    /// <p>
    /// <code>LatestRestorableDateTime</code> is typically 5 minutes before the current time. You can restore your table to any point
    /// in time during the last 35 days.
    /// </p>
    /// <p>You can call <code>DescribeContinuousBackups</code> at a maximum rate of 10 times per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeContinuousBackups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_continuous_backups_input::Builder,
    }
    impl<C, M, R> DescribeContinuousBackups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeContinuousBackups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeContinuousBackupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeContinuousBackupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeContinuousBackupsInputOperationOutputAlias,
                crate::output::DescribeContinuousBackupsOutput,
                crate::error::DescribeContinuousBackupsError,
                crate::input::DescribeContinuousBackupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the table for which the customer wants to check the continuous backups and point in time recovery settings.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>Name of the table for which the customer wants to check the continuous backups and point in time recovery settings.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeContributorInsights`.
    ///
    /// <p>Returns information about contributor insights, for a given table or global secondary index.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeContributorInsights<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_contributor_insights_input::Builder,
    }
    impl<C, M, R> DescribeContributorInsights<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeContributorInsights`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeContributorInsightsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeContributorInsightsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeContributorInsightsInputOperationOutputAlias,
                crate::output::DescribeContributorInsightsOutput,
                crate::error::DescribeContributorInsightsError,
                crate::input::DescribeContributorInsightsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the table to describe.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the table to describe.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>The name of the global secondary index to describe, if applicable.</p>
        pub fn index_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(inp);
            self
        }
        /// <p>The name of the global secondary index to describe, if applicable.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEndpoints`.
    ///
    /// <p>Returns the regional endpoint information.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEndpoints<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_endpoints_input::Builder,
    }
    impl<C, M, R> DescribeEndpoints<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEndpoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEndpointsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEndpointsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEndpointsInputOperationOutputAlias,
                crate::output::DescribeEndpointsOutput,
                crate::error::DescribeEndpointsError,
                crate::input::DescribeEndpointsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeExport`.
    ///
    /// <p>Describes an existing table export.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeExport<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_export_input::Builder,
    }
    impl<C, M, R> DescribeExport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeExport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeExportOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeExportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeExportInputOperationOutputAlias,
                crate::output::DescribeExportOutput,
                crate::error::DescribeExportError,
                crate::input::DescribeExportInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) associated with the export.</p>
        pub fn export_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.export_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) associated with the export.</p>
        pub fn set_export_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_export_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeGlobalTable`.
    ///
    /// <p>Returns information about the specified global table.</p>
    /// <note>
    /// <p>This operation only applies to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html">Version 2017.11.29</a> of global tables.
    /// If you are using global tables <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html">Version 2019.11.21</a> you can use <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DescribeTable.html">DescribeTable</a> instead.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeGlobalTable<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_global_table_input::Builder,
    }
    impl<C, M, R> DescribeGlobalTable<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeGlobalTable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeGlobalTableOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeGlobalTableError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeGlobalTableInputOperationOutputAlias,
                crate::output::DescribeGlobalTableOutput,
                crate::error::DescribeGlobalTableError,
                crate::input::DescribeGlobalTableInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the global table.</p>
        pub fn global_table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_table_name(inp);
            self
        }
        /// <p>The name of the global table.</p>
        pub fn set_global_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_table_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeGlobalTableSettings`.
    ///
    /// <p>Describes Region-specific settings for a global table.</p>
    /// <note>
    /// <p>This operation only applies to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html">Version 2017.11.29</a> of global tables.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeGlobalTableSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_global_table_settings_input::Builder,
    }
    impl<C, M, R> DescribeGlobalTableSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeGlobalTableSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeGlobalTableSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeGlobalTableSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeGlobalTableSettingsInputOperationOutputAlias,
                crate::output::DescribeGlobalTableSettingsOutput,
                crate::error::DescribeGlobalTableSettingsError,
                crate::input::DescribeGlobalTableSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the global table to describe.</p>
        pub fn global_table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_table_name(inp);
            self
        }
        /// <p>The name of the global table to describe.</p>
        pub fn set_global_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_table_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeKinesisStreamingDestination`.
    ///
    /// <p>Returns information about the status of Kinesis streaming.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeKinesisStreamingDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_kinesis_streaming_destination_input::Builder,
    }
    impl<C, M, R> DescribeKinesisStreamingDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeKinesisStreamingDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeKinesisStreamingDestinationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeKinesisStreamingDestinationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeKinesisStreamingDestinationInputOperationOutputAlias,
                crate::output::DescribeKinesisStreamingDestinationOutput,
                crate::error::DescribeKinesisStreamingDestinationError,
                crate::input::DescribeKinesisStreamingDestinationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the table being described.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the table being described.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLimits`.
    ///
    /// <p>Returns the current provisioned-capacity quotas for your AWS account in a Region, both
    /// for the Region as a whole and for any one DynamoDB table that you create there.</p>
    /// <p>When you establish an AWS account, the account has initial quotas on the maximum read
    /// capacity units and write capacity units that you can provision across all of your
    /// DynamoDB tables in a given Region. Also, there are per-table quotas that apply when you
    /// create a table there. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table
    /// Quotas</a> page in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    ///
    /// <p>Although you can increase these quotas by filing a case at <a href="https://console.aws.amazon.com/support/home#/">AWS Support Center</a>, obtaining the increase is not
    /// instantaneous. The <code>DescribeLimits</code> action lets you write code to compare the
    /// capacity you are currently using to those quotas imposed by your account so that you
    /// have enough time to apply for an increase before you hit a quota.</p>
    ///
    /// <p>For example, you could use one of the AWS SDKs to do the following:</p>
    ///
    /// <ol>
    /// <li>
    /// <p>Call <code>DescribeLimits</code> for a particular Region to obtain your current
    /// account quotas on provisioned capacity there.</p>
    /// </li>
    /// <li>
    /// <p>Create a variable to hold the aggregate read capacity units provisioned for all
    /// your tables in that Region, and one to hold the aggregate write capacity units.
    /// Zero them both.</p>
    /// </li>
    /// <li>
    /// <p>Call <code>ListTables</code> to obtain a list of all your DynamoDB tables.</p>
    /// </li>
    /// <li>
    /// <p>For each table name listed by <code>ListTables</code>, do the following:</p>
    /// <ul>
    /// <li>
    /// <p>Call <code>DescribeTable</code> with the table name.</p>
    /// </li>
    /// <li>
    /// <p>Use the data returned by <code>DescribeTable</code> to add the read capacity units and write capacity
    /// units provisioned for the table itself to your variables.</p>
    /// </li>
    /// <li>
    /// <p>If the table has one or more global secondary indexes (GSIs), loop over these GSIs and add their provisioned capacity values to your variables as well.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Report the account quotas for that Region returned by <code>DescribeLimits</code>, along with
    /// the total current provisioned capacity levels you have calculated.</p>
    /// </li>
    /// </ol>
    ///
    /// <p>This will let you see whether you are getting close to your account-level quotas.</p>
    /// <p>The per-table quotas apply only when you are creating a new table. They restrict the sum
    /// of the provisioned capacity of the new table itself and all its global secondary
    /// indexes.</p>
    /// <p>For existing tables and their GSIs, DynamoDB doesn't let you increase provisioned
    /// capacity extremely rapidly, but the only quota that applies is that the aggregate
    /// provisioned capacity over all your tables and GSIs cannot exceed either of the
    /// per-account quotas.</p>
    /// <note>
    /// <p>
    /// <code>DescribeLimits</code> should only be called periodically. You can expect throttling
    /// errors if you call it more than once in a minute.</p>
    /// </note>
    /// <p>The <code>DescribeLimits</code> Request element has no content.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeLimits<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_limits_input::Builder,
    }
    impl<C, M, R> DescribeLimits<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeLimits`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLimitsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLimitsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeLimitsInputOperationOutputAlias,
                crate::output::DescribeLimitsOutput,
                crate::error::DescribeLimitsError,
                crate::input::DescribeLimitsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeTable`.
    ///
    /// <p>Returns information about the table, including the current status of the table, when it was created, the primary key schema, and any indexes on the table.</p>
    /// <note>
    /// <p>If you issue a <code>DescribeTable</code> request immediately after a <code>CreateTable</code> request, DynamoDB might
    /// return a <code>ResourceNotFoundException</code>. This is because <code>DescribeTable</code> uses an eventually
    /// consistent query, and the metadata for your table might not be available at that moment.
    /// Wait for a few seconds, and then try the <code>DescribeTable</code> request again.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeTable<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_table_input::Builder,
    }
    impl<C, M, R> DescribeTable<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTableOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTableError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTableInputOperationOutputAlias,
                crate::output::DescribeTableOutput,
                crate::error::DescribeTableError,
                crate::input::DescribeTableInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the table to describe.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the table to describe.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTableReplicaAutoScaling`.
    ///
    /// <p>Describes auto scaling settings across replicas of the global table at once.</p>
    /// <note>
    /// <p>This operation only applies to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html">Version 2019.11.21</a> of global tables.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeTableReplicaAutoScaling<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_table_replica_auto_scaling_input::Builder,
    }
    impl<C, M, R> DescribeTableReplicaAutoScaling<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTableReplicaAutoScaling`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTableReplicaAutoScalingOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTableReplicaAutoScalingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTableReplicaAutoScalingInputOperationOutputAlias,
                crate::output::DescribeTableReplicaAutoScalingOutput,
                crate::error::DescribeTableReplicaAutoScalingError,
                crate::input::DescribeTableReplicaAutoScalingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the table.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTimeToLive`.
    ///
    /// <p>Gives a description of the Time to Live (TTL) status on the specified table. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeTimeToLive<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_time_to_live_input::Builder,
    }
    impl<C, M, R> DescribeTimeToLive<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTimeToLive`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTimeToLiveOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTimeToLiveError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTimeToLiveInputOperationOutputAlias,
                crate::output::DescribeTimeToLiveOutput,
                crate::error::DescribeTimeToLiveError,
                crate::input::DescribeTimeToLiveInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the table to be described.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the table to be described.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableKinesisStreamingDestination`.
    ///
    /// <p>Stops replication from the DynamoDB table to the Kinesis data stream. This is done
    /// without deleting either of the resources.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisableKinesisStreamingDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_kinesis_streaming_destination_input::Builder,
    }
    impl<C, M, R> DisableKinesisStreamingDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableKinesisStreamingDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableKinesisStreamingDestinationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisableKinesisStreamingDestinationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableKinesisStreamingDestinationInputOperationOutputAlias,
                crate::output::DisableKinesisStreamingDestinationOutput,
                crate::error::DisableKinesisStreamingDestinationError,
                crate::input::DisableKinesisStreamingDestinationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DynamoDB table.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the DynamoDB table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>The ARN for a Kinesis data stream.</p>
        pub fn stream_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_arn(inp);
            self
        }
        /// <p>The ARN for a Kinesis data stream.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableKinesisStreamingDestination`.
    ///
    /// <p>Starts table data replication to the specified Kinesis data stream at a timestamp chosen
    /// during the enable workflow. If this operation doesn't return results immediately, use
    /// DescribeKinesisStreamingDestination to check if streaming to the Kinesis data stream is
    /// ACTIVE.</p>
    #[derive(std::fmt::Debug)]
    pub struct EnableKinesisStreamingDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_kinesis_streaming_destination_input::Builder,
    }
    impl<C, M, R> EnableKinesisStreamingDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableKinesisStreamingDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableKinesisStreamingDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableKinesisStreamingDestinationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableKinesisStreamingDestinationInputOperationOutputAlias,
                crate::output::EnableKinesisStreamingDestinationOutput,
                crate::error::EnableKinesisStreamingDestinationError,
                crate::input::EnableKinesisStreamingDestinationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DynamoDB table.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the DynamoDB table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>The ARN for a Kinesis data stream.</p>
        pub fn stream_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_arn(inp);
            self
        }
        /// <p>The ARN for a Kinesis data stream.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExecuteStatement`.
    ///
    /// <p>
    /// This operation allows you to perform reads and singleton writes on data stored in DynamoDB, using PartiQL.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ExecuteStatement<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::execute_statement_input::Builder,
    }
    impl<C, M, R> ExecuteStatement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ExecuteStatement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExecuteStatementOutput,
            aws_smithy_http::result::SdkError<crate::error::ExecuteStatementError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ExecuteStatementInputOperationOutputAlias,
                crate::output::ExecuteStatementOutput,
                crate::error::ExecuteStatementError,
                crate::input::ExecuteStatementInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The PartiQL statement representing the operation to run.
        /// </p>
        pub fn statement(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.statement(inp);
            self
        }
        /// <p>
        /// The PartiQL statement representing the operation to run.
        /// </p>
        pub fn set_statement(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_statement(input);
            self
        }
        /// Appends an item to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>
        /// The parameters for the PartiQL statement, if any.
        /// </p>
        pub fn parameters(mut self, inp: impl Into<crate::model::AttributeValue>) -> Self {
            self.inner = self.inner.parameters(inp);
            self
        }
        /// <p>
        /// The parameters for the PartiQL statement, if any.
        /// </p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeValue>>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// <p>
        /// The consistency of a read operation. If set to <code>true</code>, then a strongly consistent read is used; otherwise, an eventually consistent read is used.
        /// </p>
        pub fn consistent_read(mut self, inp: bool) -> Self {
            self.inner = self.inner.consistent_read(inp);
            self
        }
        /// <p>
        /// The consistency of a read operation. If set to <code>true</code>, then a strongly consistent read is used; otherwise, an eventually consistent read is used.
        /// </p>
        pub fn set_consistent_read(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_consistent_read(input);
            self
        }
        /// <p>
        /// Set this value to get remaining results, if <code>NextToken</code> was returned in the statement response.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// Set this value to get remaining results, if <code>NextToken</code> was returned in the statement response.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExecuteTransaction`.
    ///
    /// <p>
    /// This operation allows you to perform transactional reads or writes on data stored in DynamoDB, using PartiQL.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ExecuteTransaction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::execute_transaction_input::Builder,
    }
    impl<C, M, R> ExecuteTransaction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ExecuteTransaction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExecuteTransactionOutput,
            aws_smithy_http::result::SdkError<crate::error::ExecuteTransactionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ExecuteTransactionInputOperationOutputAlias,
                crate::output::ExecuteTransactionOutput,
                crate::error::ExecuteTransactionError,
                crate::input::ExecuteTransactionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TransactStatements`.
        ///
        /// To override the contents of this collection use [`set_transact_statements`](Self::set_transact_statements).
        ///
        /// <p>
        /// The list of PartiQL statements representing the transaction to run.
        /// </p>
        pub fn transact_statements(
            mut self,
            inp: impl Into<crate::model::ParameterizedStatement>,
        ) -> Self {
            self.inner = self.inner.transact_statements(inp);
            self
        }
        /// <p>
        /// The list of PartiQL statements representing the transaction to run.
        /// </p>
        pub fn set_transact_statements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterizedStatement>>,
        ) -> Self {
            self.inner = self.inner.set_transact_statements(input);
            self
        }
        /// <p>
        /// Set this value to get remaining results, if <code>NextToken</code> was returned in the statement response.
        /// </p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>
        /// Set this value to get remaining results, if <code>NextToken</code> was returned in the statement response.
        /// </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExportTableToPointInTime`.
    ///
    /// <p>Exports table data to an S3 bucket. The table must have point in time recovery
    /// enabled, and you can export data from any time within the point in time recovery
    /// window.</p>
    #[derive(std::fmt::Debug)]
    pub struct ExportTableToPointInTime<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::export_table_to_point_in_time_input::Builder,
    }
    impl<C, M, R> ExportTableToPointInTime<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ExportTableToPointInTime`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExportTableToPointInTimeOutput,
            aws_smithy_http::result::SdkError<crate::error::ExportTableToPointInTimeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ExportTableToPointInTimeInputOperationOutputAlias,
                crate::output::ExportTableToPointInTimeOutput,
                crate::error::ExportTableToPointInTimeError,
                crate::input::ExportTableToPointInTimeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) associated with the table to export.</p>
        pub fn table_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) associated with the table to export.</p>
        pub fn set_table_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_arn(input);
            self
        }
        /// <p>Time in the past from which to export table data. The table export will be a snapshot
        /// of the table's state at this point in time.</p>
        pub fn export_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.export_time(inp);
            self
        }
        /// <p>Time in the past from which to export table data. The table export will be a snapshot
        /// of the table's state at this point in time.</p>
        pub fn set_export_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_export_time(input);
            self
        }
        /// <p>Providing a <code>ClientToken</code> makes the call to
        /// <code>ExportTableToPointInTimeInput</code> idempotent, meaning that multiple
        /// identical calls have the same effect as one single call.</p>
        /// <p>A client token is valid for 8 hours after the first request that uses it is
        /// completed. After 8 hours, any request with the same client token is treated as a new
        /// request. Do not resubmit the same request with the same client token for more than 8
        /// hours, or the result might not be idempotent.</p>
        /// <p>If you submit a request with the same client token but a change in other parameters
        /// within the 8-hour idempotency window, DynamoDB returns an
        /// <code>IdempotentParameterMismatch</code> exception.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Providing a <code>ClientToken</code> makes the call to
        /// <code>ExportTableToPointInTimeInput</code> idempotent, meaning that multiple
        /// identical calls have the same effect as one single call.</p>
        /// <p>A client token is valid for 8 hours after the first request that uses it is
        /// completed. After 8 hours, any request with the same client token is treated as a new
        /// request. Do not resubmit the same request with the same client token for more than 8
        /// hours, or the result might not be idempotent.</p>
        /// <p>If you submit a request with the same client token but a change in other parameters
        /// within the 8-hour idempotency window, DynamoDB returns an
        /// <code>IdempotentParameterMismatch</code> exception.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The name of the Amazon S3 bucket to export the snapshot to.</p>
        pub fn s3_bucket(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_bucket(inp);
            self
        }
        /// <p>The name of the Amazon S3 bucket to export the snapshot to.</p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_s3_bucket(input);
            self
        }
        /// <p>The ID of the AWS account that owns the bucket the export will be stored in.</p>
        pub fn s3_bucket_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_bucket_owner(inp);
            self
        }
        /// <p>The ID of the AWS account that owns the bucket the export will be stored in.</p>
        pub fn set_s3_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3_bucket_owner(input);
            self
        }
        /// <p>The Amazon S3 bucket prefix to use as the file name and path of the exported
        /// snapshot.</p>
        pub fn s3_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_prefix(inp);
            self
        }
        /// <p>The Amazon S3 bucket prefix to use as the file name and path of the exported
        /// snapshot.</p>
        pub fn set_s3_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_s3_prefix(input);
            self
        }
        /// <p>Type of encryption used on the bucket where export data will be stored. Valid values
        /// for <code>S3SseAlgorithm</code> are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AES256</code> - server-side encryption with Amazon S3 managed keys</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KMS</code> - server-side encryption with AWS KMS managed keys</p>
        /// </li>
        /// </ul>
        pub fn s3_sse_algorithm(mut self, inp: crate::model::S3SseAlgorithm) -> Self {
            self.inner = self.inner.s3_sse_algorithm(inp);
            self
        }
        /// <p>Type of encryption used on the bucket where export data will be stored. Valid values
        /// for <code>S3SseAlgorithm</code> are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AES256</code> - server-side encryption with Amazon S3 managed keys</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KMS</code> - server-side encryption with AWS KMS managed keys</p>
        /// </li>
        /// </ul>
        pub fn set_s3_sse_algorithm(
            mut self,
            input: std::option::Option<crate::model::S3SseAlgorithm>,
        ) -> Self {
            self.inner = self.inner.set_s3_sse_algorithm(input);
            self
        }
        /// <p>The ID of the AWS KMS managed key used to encrypt the S3 bucket where export data will
        /// be stored (if applicable).</p>
        pub fn s3_sse_kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_sse_kms_key_id(inp);
            self
        }
        /// <p>The ID of the AWS KMS managed key used to encrypt the S3 bucket where export data will
        /// be stored (if applicable).</p>
        pub fn set_s3_sse_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3_sse_kms_key_id(input);
            self
        }
        /// <p>The format for the exported data. Valid values for <code>ExportFormat</code> are
        /// <code>DYNAMODB_JSON</code> or <code>ION</code>.</p>
        pub fn export_format(mut self, inp: crate::model::ExportFormat) -> Self {
            self.inner = self.inner.export_format(inp);
            self
        }
        /// <p>The format for the exported data. Valid values for <code>ExportFormat</code> are
        /// <code>DYNAMODB_JSON</code> or <code>ION</code>.</p>
        pub fn set_export_format(
            mut self,
            input: std::option::Option<crate::model::ExportFormat>,
        ) -> Self {
            self.inner = self.inner.set_export_format(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetItem`.
    ///
    /// <p>The <code>GetItem</code> operation returns a set of attributes for the item with the given primary
    /// key. If there is no matching item, <code>GetItem</code> does not return any data and there will be no <code>Item</code> element in the response.</p>
    /// <p>
    /// <code>GetItem</code> provides an eventually consistent read by default. If your application
    /// requires a strongly consistent read, set <code>ConsistentRead</code> to <code>true</code>. Although
    /// a strongly consistent read might take more time than an eventually consistent read, it always
    /// returns the last updated value.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetItem<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_item_input::Builder,
    }
    impl<C, M, R> GetItem<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetItem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetItemOutput,
            aws_smithy_http::result::SdkError<crate::error::GetItemError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetItemInputOperationOutputAlias,
                crate::output::GetItemOutput,
                crate::error::GetItemError,
                crate::input::GetItemInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the table containing the requested item.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the table containing the requested item.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// Adds a key-value pair to `Key`.
        ///
        /// To override the contents of this collection use [`set_key`](Self::set_key).
        ///
        /// <p>A map of attribute names to <code>AttributeValue</code> objects, representing the primary key of
        /// the item to retrieve.</p>
        /// <p>For the primary key, you must provide all of the attributes. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide values for both the partition key and the sort key.</p>
        pub fn key(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeValue>,
        ) -> Self {
            self.inner = self.inner.key(k, v);
            self
        }
        /// <p>A map of attribute names to <code>AttributeValue</code> objects, representing the primary key of
        /// the item to retrieve.</p>
        /// <p>For the primary key, you must provide all of the attributes. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide values for both the partition key and the sort key.</p>
        pub fn set_key(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_key(input);
            self
        }
        /// Appends an item to `AttributesToGet`.
        ///
        /// To override the contents of this collection use [`set_attributes_to_get`](Self::set_attributes_to_get).
        ///
        /// <p>This is a legacy parameter.  Use <code>ProjectionExpression</code> instead.  For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn attributes_to_get(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attributes_to_get(inp);
            self
        }
        /// <p>This is a legacy parameter.  Use <code>ProjectionExpression</code> instead.  For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_attributes_to_get(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_attributes_to_get(input);
            self
        }
        /// <p>Determines the read consistency model:  If set to <code>true</code>, then the operation uses strongly consistent reads; otherwise, the operation uses eventually consistent reads.</p>
        pub fn consistent_read(mut self, inp: bool) -> Self {
            self.inner = self.inner.consistent_read(inp);
            self
        }
        /// <p>Determines the read consistency model:  If set to <code>true</code>, then the operation uses strongly consistent reads; otherwise, the operation uses eventually consistent reads.</p>
        pub fn set_consistent_read(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_consistent_read(input);
            self
        }
        /// <p>Determines the level of detail about provisioned throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all.  In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p>
        /// </li>
        /// </ul>
        pub fn return_consumed_capacity(
            mut self,
            inp: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.inner = self.inner.return_consumed_capacity(inp);
            self
        }
        /// <p>Determines the level of detail about provisioned throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all.  In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p>
        /// </li>
        /// </ul>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.inner = self.inner.set_return_consumed_capacity(input);
            self
        }
        /// <p>A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.</p>
        /// <p>If no attribute names are specified, then all attributes are returned. If any of the
        /// requested attributes are not found, they do not appear in the result.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn projection_expression(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.projection_expression(inp);
            self
        }
        /// <p>A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.</p>
        /// <p>If no attribute names are specified, then all attributes are returned. If any of the
        /// requested attributes are not found, they do not appear in the result.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_projection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_projection_expression(input);
            self
        }
        /// Adds a key-value pair to `ExpressionAttributeNames`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_names`](Self::set_expression_attribute_names).
        ///
        /// <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p>
        /// </li>
        /// <li>
        /// <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p>
        /// </li>
        /// <li>
        /// <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p>
        /// </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Percentile</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>{"#P":"Percentile"}</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#P = :val</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>
        /// </note>
        /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn expression_attribute_names(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.expression_attribute_names(k, v);
            self
        }
        /// <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p>
        /// </li>
        /// <li>
        /// <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p>
        /// </li>
        /// <li>
        /// <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p>
        /// </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Percentile</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>{"#P":"Percentile"}</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#P = :val</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>
        /// </note>
        /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_expression_attribute_names(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_expression_attribute_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBackups`.
    ///
    /// <p>List backups associated with an AWS account. To list backups for a given table, specify
    /// <code>TableName</code>. <code>ListBackups</code> returns a paginated list of results
    /// with at most 1 MB worth of items in a page. You can also specify a maximum number of
    /// entries to be returned in a page. </p>
    /// <p>In the request, start time is inclusive, but end time is exclusive. Note that these
    /// boundaries are for the time at which the original backup was requested.</p>
    /// <p>You can call <code>ListBackups</code> a maximum of five times per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListBackups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_backups_input::Builder,
    }
    impl<C, M, R> ListBackups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBackups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBackupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBackupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBackupsInputOperationOutputAlias,
                crate::output::ListBackupsOutput,
                crate::error::ListBackupsError,
                crate::input::ListBackupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The backups from the table specified by <code>TableName</code> are listed. </p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The backups from the table specified by <code>TableName</code> are listed. </p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>Maximum number of backups to return at once.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>Maximum number of backups to return at once.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>Only backups created after this time are listed. <code>TimeRangeLowerBound</code> is inclusive.</p>
        pub fn time_range_lower_bound(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.time_range_lower_bound(inp);
            self
        }
        /// <p>Only backups created after this time are listed. <code>TimeRangeLowerBound</code> is inclusive.</p>
        pub fn set_time_range_lower_bound(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_time_range_lower_bound(input);
            self
        }
        /// <p>Only backups created before this time are listed. <code>TimeRangeUpperBound</code> is exclusive. </p>
        pub fn time_range_upper_bound(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.time_range_upper_bound(inp);
            self
        }
        /// <p>Only backups created before this time are listed. <code>TimeRangeUpperBound</code> is exclusive. </p>
        pub fn set_time_range_upper_bound(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_time_range_upper_bound(input);
            self
        }
        /// <p>
        /// <code>LastEvaluatedBackupArn</code> is the Amazon Resource Name (ARN) of the backup last
        /// evaluated when the current page of results was returned, inclusive of the current page
        /// of results. This value may be specified as the <code>ExclusiveStartBackupArn</code> of a
        /// new <code>ListBackups</code> operation in order to fetch the next page of results. </p>
        pub fn exclusive_start_backup_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.exclusive_start_backup_arn(inp);
            self
        }
        /// <p>
        /// <code>LastEvaluatedBackupArn</code> is the Amazon Resource Name (ARN) of the backup last
        /// evaluated when the current page of results was returned, inclusive of the current page
        /// of results. This value may be specified as the <code>ExclusiveStartBackupArn</code> of a
        /// new <code>ListBackups</code> operation in order to fetch the next page of results. </p>
        pub fn set_exclusive_start_backup_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_exclusive_start_backup_arn(input);
            self
        }
        /// <p>The backups from the table specified by <code>BackupType</code> are listed.</p>
        /// <p>Where <code>BackupType</code> can be:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>USER</code> - On-demand backup created by you.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SYSTEM</code> - On-demand backup automatically created by
        /// DynamoDB.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL</code> - All types of on-demand backups (USER and SYSTEM).</p>
        /// </li>
        /// </ul>
        pub fn backup_type(mut self, inp: crate::model::BackupTypeFilter) -> Self {
            self.inner = self.inner.backup_type(inp);
            self
        }
        /// <p>The backups from the table specified by <code>BackupType</code> are listed.</p>
        /// <p>Where <code>BackupType</code> can be:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>USER</code> - On-demand backup created by you.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SYSTEM</code> - On-demand backup automatically created by
        /// DynamoDB.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL</code> - All types of on-demand backups (USER and SYSTEM).</p>
        /// </li>
        /// </ul>
        pub fn set_backup_type(
            mut self,
            input: std::option::Option<crate::model::BackupTypeFilter>,
        ) -> Self {
            self.inner = self.inner.set_backup_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListContributorInsights`.
    ///
    /// <p>Returns a list of ContributorInsightsSummary for a table and all its global secondary indexes.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListContributorInsights<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_contributor_insights_input::Builder,
    }
    impl<C, M, R> ListContributorInsights<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListContributorInsights`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListContributorInsightsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListContributorInsightsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListContributorInsightsInputOperationOutputAlias,
                crate::output::ListContributorInsightsOutput,
                crate::error::ListContributorInsightsError,
                crate::input::ListContributorInsightsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the table.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>A token to for the desired page, if there is one.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to for the desired page, if there is one.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of results to return per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListExports`.
    ///
    /// <p>Lists completed exports within the past 90 days.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListExports<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_exports_input::Builder,
    }
    impl<C, M, R> ListExports<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListExports`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListExportsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListExportsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListExportsInputOperationOutputAlias,
                crate::output::ListExportsOutput,
                crate::error::ListExportsError,
                crate::input::ListExportsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) associated with the exported table.</p>
        pub fn table_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) associated with the exported table.</p>
        pub fn set_table_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_arn(input);
            self
        }
        /// <p>Maximum number of results to return per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An optional string that, if supplied, must be copied from the output of a previous
        /// call to <code>ListExports</code>. When provided in this manner, the API fetches the next
        /// page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An optional string that, if supplied, must be copied from the output of a previous
        /// call to <code>ListExports</code>. When provided in this manner, the API fetches the next
        /// page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGlobalTables`.
    ///
    /// <p>Lists all global tables that have a replica in the specified Region.</p>
    /// <note>
    /// <p>This operation only applies to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html">Version 2017.11.29</a> of global tables.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListGlobalTables<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_global_tables_input::Builder,
    }
    impl<C, M, R> ListGlobalTables<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListGlobalTables`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGlobalTablesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGlobalTablesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListGlobalTablesInputOperationOutputAlias,
                crate::output::ListGlobalTablesOutput,
                crate::error::ListGlobalTablesError,
                crate::input::ListGlobalTablesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The first global table name that this operation will evaluate.</p>
        pub fn exclusive_start_global_table_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.exclusive_start_global_table_name(inp);
            self
        }
        /// <p>The first global table name that this operation will evaluate.</p>
        pub fn set_exclusive_start_global_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_exclusive_start_global_table_name(input);
            self
        }
        /// <p>The maximum number of table names to return, if the parameter is not specified DynamoDB defaults to 100.</p>
        /// <p>If the number of global tables DynamoDB finds reaches this limit, it stops the operation and returns the table names collected up to that point,
        /// with a table name in the <code>LastEvaluatedGlobalTableName</code> to apply in a subsequent operation to the <code>ExclusiveStartGlobalTableName</code> parameter.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of table names to return, if the parameter is not specified DynamoDB defaults to 100.</p>
        /// <p>If the number of global tables DynamoDB finds reaches this limit, it stops the operation and returns the table names collected up to that point,
        /// with a table name in the <code>LastEvaluatedGlobalTableName</code> to apply in a subsequent operation to the <code>ExclusiveStartGlobalTableName</code> parameter.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>Lists the global tables in a specific Region.</p>
        pub fn region_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.region_name(inp);
            self
        }
        /// <p>Lists the global tables in a specific Region.</p>
        pub fn set_region_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_region_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTables`.
    ///
    /// <p>Returns an array of table names associated with the current account and endpoint. The output
    /// from <code>ListTables</code> is paginated, with each page returning a maximum of 100 table
    /// names.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTables<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tables_input::Builder,
    }
    impl<C, M, R> ListTables<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTables`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTablesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTablesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTablesInputOperationOutputAlias,
                crate::output::ListTablesOutput,
                crate::error::ListTablesError,
                crate::input::ListTablesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The first table name that this operation will evaluate. Use the value that was returned for
        /// <code>LastEvaluatedTableName</code> in a previous operation, so that you can obtain the next page
        /// of results.</p>
        pub fn exclusive_start_table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.exclusive_start_table_name(inp);
            self
        }
        /// <p>The first table name that this operation will evaluate. Use the value that was returned for
        /// <code>LastEvaluatedTableName</code> in a previous operation, so that you can obtain the next page
        /// of results.</p>
        pub fn set_exclusive_start_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_exclusive_start_table_name(input);
            self
        }
        /// <p>A maximum number of table names to return. If this parameter is not specified, the limit is 100.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>A maximum number of table names to return. If this parameter is not specified, the limit is 100.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsOfResource`.
    ///
    /// <p>List all tags on an Amazon DynamoDB resource. You can call ListTagsOfResource up to 10 times per second, per account.</p>
    /// <p>For an overview on tagging DynamoDB resources, see
    /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for DynamoDB</a>
    /// in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsOfResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_of_resource_input::Builder,
    }
    impl<C, M, R> ListTagsOfResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsOfResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsOfResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsOfResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsOfResourceInputOperationOutputAlias,
                crate::output::ListTagsOfResourceOutput,
                crate::error::ListTagsOfResourceError,
                crate::input::ListTagsOfResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon DynamoDB resource with tags to be listed. This value is an Amazon Resource Name (ARN).</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon DynamoDB resource with tags to be listed. This value is an Amazon Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>An optional string that, if supplied, must be copied from the output of a previous
        /// call to ListTagOfResource. When provided in this manner, this API fetches the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An optional string that, if supplied, must be copied from the output of a previous
        /// call to ListTagOfResource. When provided in this manner, this API fetches the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutItem`.
    ///
    /// <p>Creates a new item, or replaces an old item with a new item. If an item that has the same primary key as the new item already exists in the specified table, the new item completely replaces the existing item. You can perform a conditional put operation (add a new item if one with the specified primary key doesn't exist), or replace an existing item if it has certain attribute values. You can return the item's attribute values in the same operation, using the <code>ReturnValues</code> parameter.</p>
    /// <important>
    /// <p>This topic provides general information about the <code>PutItem</code> API.</p>
    /// <p>For information on how to call the <code>PutItem</code> API using the AWS SDK in specific languages, see the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="http://docs.aws.amazon.com/goto/aws-cli/dynamodb-2012-08-10/PutItem"> PutItem in the AWS Command Line Interface</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="http://docs.aws.amazon.com/goto/DotNetSDKV3/dynamodb-2012-08-10/PutItem"> PutItem in the AWS SDK for .NET</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="http://docs.aws.amazon.com/goto/SdkForCpp/dynamodb-2012-08-10/PutItem"> PutItem in the AWS SDK for C++</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="http://docs.aws.amazon.com/goto/SdkForGoV1/dynamodb-2012-08-10/PutItem"> PutItem in the AWS SDK for Go</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="http://docs.aws.amazon.com/goto/SdkForJava/dynamodb-2012-08-10/PutItem"> PutItem in the AWS SDK for Java</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="http://docs.aws.amazon.com/goto/AWSJavaScriptSDK/dynamodb-2012-08-10/PutItem"> PutItem in the AWS SDK for JavaScript</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="http://docs.aws.amazon.com/goto/SdkForPHPV3/dynamodb-2012-08-10/PutItem"> PutItem in the AWS SDK for PHP V3</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="http://docs.aws.amazon.com/goto/boto3/dynamodb-2012-08-10/PutItem">
    /// PutItem in the AWS SDK for Python</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="http://docs.aws.amazon.com/goto/SdkForRubyV2/dynamodb-2012-08-10/PutItem"> PutItem in the AWS SDK for Ruby V2</a>
    /// </p>
    /// </li>
    /// </ul>
    /// </important>
    ///
    /// <p>When you add an item, the primary key attributes are the only required attributes.
    /// Attribute values cannot be null.</p>
    /// <p>Empty String and Binary attribute values are allowed. Attribute values of type String and Binary must have a length greater than zero if the attribute is used as a key attribute for a table or index.
    /// Set type attributes cannot be empty. </p>
    /// <p>Invalid Requests with empty values will
    /// be rejected with a <code>ValidationException</code> exception.</p>
    /// <note>
    /// <p>To prevent a new item from replacing an existing item, use a conditional expression
    /// that contains the <code>attribute_not_exists</code> function with the name of the
    /// attribute being used as the partition key for the table.  Since every record must contain
    /// that attribute, the <code>attribute_not_exists</code> function will only succeed if
    /// no matching item exists.</p>
    /// </note>
    /// <p>For more information about <code>PutItem</code>, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithItems.html">Working with Items</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutItem<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_item_input::Builder,
    }
    impl<C, M, R> PutItem<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutItem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutItemOutput,
            aws_smithy_http::result::SdkError<crate::error::PutItemError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutItemInputOperationOutputAlias,
                crate::output::PutItemOutput,
                crate::error::PutItemError,
                crate::input::PutItemInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the table to contain the item.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the table to contain the item.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// Adds a key-value pair to `Item`.
        ///
        /// To override the contents of this collection use [`set_item`](Self::set_item).
        ///
        /// <p>A map of attribute name/value pairs, one for each attribute. Only the primary key attributes are required; you can optionally provide other attribute name-value pairs for the item.</p>
        /// <p>You must provide all of the attributes for the primary key. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide both values for both the partition key and the sort key.</p>
        /// <p>If you specify any attributes that are part of an index key, then the data types for those attributes must match those of the schema in the table's attribute definition.</p>
        /// <p>Empty String and Binary attribute values are allowed. Attribute values of type String and Binary must have a length greater than zero if the attribute is used as a key attribute for a table or index.</p>
        ///
        /// <p>For more information about primary keys, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.CoreComponents.html#HowItWorks.CoreComponents.PrimaryKey">Primary Key</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        /// <p>Each element in the <code>Item</code> map is an <code>AttributeValue</code> object.</p>
        pub fn item(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeValue>,
        ) -> Self {
            self.inner = self.inner.item(k, v);
            self
        }
        /// <p>A map of attribute name/value pairs, one for each attribute. Only the primary key attributes are required; you can optionally provide other attribute name-value pairs for the item.</p>
        /// <p>You must provide all of the attributes for the primary key. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide both values for both the partition key and the sort key.</p>
        /// <p>If you specify any attributes that are part of an index key, then the data types for those attributes must match those of the schema in the table's attribute definition.</p>
        /// <p>Empty String and Binary attribute values are allowed. Attribute values of type String and Binary must have a length greater than zero if the attribute is used as a key attribute for a table or index.</p>
        ///
        /// <p>For more information about primary keys, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.CoreComponents.html#HowItWorks.CoreComponents.PrimaryKey">Primary Key</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        /// <p>Each element in the <code>Item</code> map is an <code>AttributeValue</code> object.</p>
        pub fn set_item(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_item(input);
            self
        }
        /// Adds a key-value pair to `Expected`.
        ///
        /// To override the contents of this collection use [`set_expected`](Self::set_expected).
        ///
        /// <p>This is a legacy parameter.  Use <code>ConditionExpression</code> instead.  For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html">Expected</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn expected(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ExpectedAttributeValue>,
        ) -> Self {
            self.inner = self.inner.expected(k, v);
            self
        }
        /// <p>This is a legacy parameter.  Use <code>ConditionExpression</code> instead.  For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html">Expected</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_expected(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::ExpectedAttributeValue,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_expected(input);
            self
        }
        /// <p>Use <code>ReturnValues</code> if you want to get the item attributes as they appeared before they
        /// were updated with the <code>PutItem</code> request. For <code>PutItem</code>, the valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is
        /// <code>NONE</code>, then nothing is returned. (This setting is the default for
        /// <code>ReturnValues</code>.)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL_OLD</code> - If <code>PutItem</code> overwrote an attribute name-value pair, then the
        /// content of the old item is returned.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>The <code>ReturnValues</code> parameter is used by several DynamoDB operations; however,
        /// <code>PutItem</code> does not recognize any values other than <code>NONE</code> or
        /// <code>ALL_OLD</code>.</p>
        /// </note>
        pub fn return_values(mut self, inp: crate::model::ReturnValue) -> Self {
            self.inner = self.inner.return_values(inp);
            self
        }
        /// <p>Use <code>ReturnValues</code> if you want to get the item attributes as they appeared before they
        /// were updated with the <code>PutItem</code> request. For <code>PutItem</code>, the valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is
        /// <code>NONE</code>, then nothing is returned. (This setting is the default for
        /// <code>ReturnValues</code>.)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL_OLD</code> - If <code>PutItem</code> overwrote an attribute name-value pair, then the
        /// content of the old item is returned.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>The <code>ReturnValues</code> parameter is used by several DynamoDB operations; however,
        /// <code>PutItem</code> does not recognize any values other than <code>NONE</code> or
        /// <code>ALL_OLD</code>.</p>
        /// </note>
        pub fn set_return_values(
            mut self,
            input: std::option::Option<crate::model::ReturnValue>,
        ) -> Self {
            self.inner = self.inner.set_return_values(input);
            self
        }
        /// <p>Determines the level of detail about provisioned throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all.  In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p>
        /// </li>
        /// </ul>
        pub fn return_consumed_capacity(
            mut self,
            inp: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.inner = self.inner.return_consumed_capacity(inp);
            self
        }
        /// <p>Determines the level of detail about provisioned throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all.  In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p>
        /// </li>
        /// </ul>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.inner = self.inner.set_return_consumed_capacity(input);
            self
        }
        /// <p>Determines whether item collection metrics are returned.  If set to <code>SIZE</code>, the response includes statistics about item collections, if any, that were modified during
        /// the operation are returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.</p>
        pub fn return_item_collection_metrics(
            mut self,
            inp: crate::model::ReturnItemCollectionMetrics,
        ) -> Self {
            self.inner = self.inner.return_item_collection_metrics(inp);
            self
        }
        /// <p>Determines whether item collection metrics are returned.  If set to <code>SIZE</code>, the response includes statistics about item collections, if any, that were modified during
        /// the operation are returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.</p>
        pub fn set_return_item_collection_metrics(
            mut self,
            input: std::option::Option<crate::model::ReturnItemCollectionMetrics>,
        ) -> Self {
            self.inner = self.inner.set_return_item_collection_metrics(input);
            self
        }
        /// <p>This is a legacy parameter.  Use <code>ConditionExpression</code> instead.  For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn conditional_operator(mut self, inp: crate::model::ConditionalOperator) -> Self {
            self.inner = self.inner.conditional_operator(inp);
            self
        }
        /// <p>This is a legacy parameter.  Use <code>ConditionExpression</code> instead.  For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_conditional_operator(
            mut self,
            input: std::option::Option<crate::model::ConditionalOperator>,
        ) -> Self {
            self.inner = self.inner.set_conditional_operator(input);
            self
        }
        /// <p>A condition that must be satisfied in order for a conditional <code>PutItem</code> operation to
        /// succeed.</p>
        /// <p>An expression can contain any of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Functions: <code>attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size</code>
        /// </p>
        /// <p>These function names are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Comparison operators: <code>= | <> |
        /// < | > | <= | >= |
        /// BETWEEN | IN </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p> Logical operators: <code>AND | OR | NOT</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information on condition expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn condition_expression(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.condition_expression(inp);
            self
        }
        /// <p>A condition that must be satisfied in order for a conditional <code>PutItem</code> operation to
        /// succeed.</p>
        /// <p>An expression can contain any of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Functions: <code>attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size</code>
        /// </p>
        /// <p>These function names are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Comparison operators: <code>= | <> |
        /// < | > | <= | >= |
        /// BETWEEN | IN </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p> Logical operators: <code>AND | OR | NOT</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information on condition expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_condition_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_condition_expression(input);
            self
        }
        /// Adds a key-value pair to `ExpressionAttributeNames`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_names`](Self::set_expression_attribute_names).
        ///
        /// <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p>
        /// </li>
        /// <li>
        /// <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p>
        /// </li>
        /// <li>
        /// <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p>
        /// </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Percentile</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>{"#P":"Percentile"}</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#P = :val</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>
        /// </note>
        /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn expression_attribute_names(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.expression_attribute_names(k, v);
            self
        }
        /// <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p>
        /// </li>
        /// <li>
        /// <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p>
        /// </li>
        /// <li>
        /// <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p>
        /// </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Percentile</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>{"#P":"Percentile"}</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#P = :val</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>
        /// </note>
        /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_expression_attribute_names(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_expression_attribute_names(input);
            self
        }
        /// Adds a key-value pair to `ExpressionAttributeValues`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_values`](Self::set_expression_attribute_values).
        ///
        /// <p>One or more values that can be substituted in an expression.</p>
        /// <p>Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose that you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of the following: </p>
        /// <p>
        /// <code>Available | Backordered | Discontinued</code>
        /// </p>
        /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as follows:</p>
        /// <p>
        /// <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
        /// </p>
        /// <p>You could then use these values in an expression, such as this:</p>
        /// <p>
        /// <code>ProductStatus IN (:avail, :back, :disc)</code>
        /// </p>
        /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn expression_attribute_values(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeValue>,
        ) -> Self {
            self.inner = self.inner.expression_attribute_values(k, v);
            self
        }
        /// <p>One or more values that can be substituted in an expression.</p>
        /// <p>Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose that you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of the following: </p>
        /// <p>
        /// <code>Available | Backordered | Discontinued</code>
        /// </p>
        /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as follows:</p>
        /// <p>
        /// <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
        /// </p>
        /// <p>You could then use these values in an expression, such as this:</p>
        /// <p>
        /// <code>ProductStatus IN (:avail, :back, :disc)</code>
        /// </p>
        /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_expression_attribute_values(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_expression_attribute_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `Query`.
    ///
    /// <p>The <code>Query</code> operation finds items based on primary key values.
    /// You can query any table or secondary index that has a composite primary key (a partition
    /// key and a sort key).
    /// </p>
    /// <p>Use the <code>KeyConditionExpression</code> parameter to provide a specific value
    /// for the partition key. The <code>Query</code> operation will return all of the items
    /// from the table or index with that partition key value. You can optionally narrow the
    /// scope of the <code>Query</code> operation by specifying a sort key value and a
    /// comparison operator in <code>KeyConditionExpression</code>. To further refine the <code>Query</code> results,
    /// you can optionally provide a <code>FilterExpression</code>. A <code>FilterExpression</code> determines which items
    /// within the results should be returned to you. All of the other results are discarded.
    /// </p>
    /// <p>
    /// A <code>Query</code> operation always returns a result set. If no matching items are found,
    /// the result set will be empty. Queries that do not return results consume the minimum number of
    /// read capacity units for that type of read operation.
    /// </p>
    /// <note>
    /// <p>
    /// DynamoDB calculates the number of read capacity units consumed based on item size,
    /// not on the amount of data that is returned to an application. The number of capacity
    /// units consumed will be the same whether you request all of the attributes (the default behavior)
    /// or just some of them (using a projection expression). The number will also be the same
    /// whether or not you use a <code>FilterExpression</code>.
    /// </p>
    /// </note>
    /// <p>
    /// <code>Query</code> results are always sorted by the sort key value. If the data type of the sort key is Number,
    /// the results are returned in numeric order; otherwise, the results are returned in order of UTF-8 bytes.
    /// By default, the sort order is ascending. To reverse the order, set the <code>ScanIndexForward</code> parameter
    /// to false.
    /// </p>
    /// <p> A single <code>Query</code> operation will read up to the maximum number of items
    /// set (if using the <code>Limit</code> parameter) or a maximum of 1 MB of data and then
    /// apply any filtering to the results using <code>FilterExpression</code>. If
    /// <code>LastEvaluatedKey</code> is present in the response, you will need to paginate
    /// the result set. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Query.html#Query.Pagination">Paginating
    /// the Results</a> in the <i>Amazon DynamoDB Developer Guide</i>. </p>
    /// <p>
    /// <code>FilterExpression</code> is applied after a <code>Query</code> finishes, but before
    /// the results are returned.
    /// A <code>FilterExpression</code> cannot contain partition key or sort key attributes.
    /// You need to specify those attributes in the <code>KeyConditionExpression</code>.
    /// </p>
    /// <note>
    /// <p>
    /// A <code>Query</code> operation can return an empty result set and a <code>LastEvaluatedKey</code>
    /// if all the items read for the page of results are filtered out.
    /// </p>
    /// </note>
    /// <p>You can query a table, a local secondary index, or a global secondary index. For a
    /// query on a table or on a local secondary index, you can set the
    /// <code>ConsistentRead</code> parameter to <code>true</code> and obtain a
    /// strongly consistent result. Global secondary indexes support eventually consistent reads
    /// only, so do not specify <code>ConsistentRead</code> when querying a global
    /// secondary index.</p>
    #[derive(std::fmt::Debug)]
    pub struct Query<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::query_input::Builder,
    }
    impl<C, M, R> Query<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `Query`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::QueryOutput,
            aws_smithy_http::result::SdkError<crate::error::QueryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::QueryInputOperationOutputAlias,
                crate::output::QueryOutput,
                crate::error::QueryError,
                crate::input::QueryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the table containing the requested items.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the table containing the requested items.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>The name of an index to query. This index can be any local secondary index or global secondary index on the table. Note that
        /// if you use the <code>IndexName</code> parameter, you must also provide <code>TableName.</code>
        /// </p>
        pub fn index_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(inp);
            self
        }
        /// <p>The name of an index to query. This index can be any local secondary index or global secondary index on the table. Note that
        /// if you use the <code>IndexName</code> parameter, you must also provide <code>TableName.</code>
        /// </p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
        /// <p>The attributes to be returned in the
        /// result. You can retrieve all item attributes, specific item attributes, the count of
        /// matching items, or in the case of an index, some or all of the attributes projected into
        /// the index.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the
        /// specified table or index. If you query a local secondary index, then for each
        /// matching item in the index, DynamoDB fetches the entire item from the parent
        /// table. If the index is configured to project all item attributes, then all of
        /// the data can be obtained from the local secondary index, and no fetching is
        /// required.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index.
        /// Retrieves all attributes that have been projected into the index. If the
        /// index is configured to project all attributes, this return value is
        /// equivalent to specifying <code>ALL_ATTRIBUTES</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COUNT</code> - Returns the number of matching items, rather than the
        /// matching items themselves.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in
        /// <code>AttributesToGet</code>. This return value is equivalent to
        /// specifying <code>AttributesToGet</code> without specifying any value
        /// for <code>Select</code>.</p>
        /// <p>If you query or scan a local secondary index and request only attributes that
        /// are projected into that index, the operation will read only the index and not
        /// the table. If any of the requested attributes are not projected into the local
        /// secondary index, DynamoDB fetches each of these attributes from the parent
        /// table. This extra fetching incurs additional throughput cost and latency.</p>
        /// <p>If you query or scan a global secondary index, you can only request
        /// attributes that are projected into the index. Global secondary index queries
        /// cannot fetch attributes from the parent table.</p>
        /// </li>
        /// </ul>
        /// <p>If neither <code>Select</code> nor <code>AttributesToGet</code>
        /// are specified, DynamoDB defaults to <code>ALL_ATTRIBUTES</code> when accessing a
        /// table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when accessing an index. You cannot
        /// use both <code>Select</code> and <code>AttributesToGet</code>
        /// together in a single request, unless the value for <code>Select</code> is
        /// <code>SPECIFIC_ATTRIBUTES</code>. (This usage is equivalent to specifying
        /// <code>AttributesToGet</code> without any value for
        /// <code>Select</code>.)</p>
        /// <note>
        /// <p>If you use the <code>ProjectionExpression</code> parameter, then
        /// the value for <code>Select</code> can only be
        /// <code>SPECIFIC_ATTRIBUTES</code>. Any other value for
        /// <code>Select</code> will return an error.</p>
        /// </note>
        pub fn select(mut self, inp: crate::model::Select) -> Self {
            self.inner = self.inner.select(inp);
            self
        }
        /// <p>The attributes to be returned in the
        /// result. You can retrieve all item attributes, specific item attributes, the count of
        /// matching items, or in the case of an index, some or all of the attributes projected into
        /// the index.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the
        /// specified table or index. If you query a local secondary index, then for each
        /// matching item in the index, DynamoDB fetches the entire item from the parent
        /// table. If the index is configured to project all item attributes, then all of
        /// the data can be obtained from the local secondary index, and no fetching is
        /// required.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index.
        /// Retrieves all attributes that have been projected into the index. If the
        /// index is configured to project all attributes, this return value is
        /// equivalent to specifying <code>ALL_ATTRIBUTES</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COUNT</code> - Returns the number of matching items, rather than the
        /// matching items themselves.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in
        /// <code>AttributesToGet</code>. This return value is equivalent to
        /// specifying <code>AttributesToGet</code> without specifying any value
        /// for <code>Select</code>.</p>
        /// <p>If you query or scan a local secondary index and request only attributes that
        /// are projected into that index, the operation will read only the index and not
        /// the table. If any of the requested attributes are not projected into the local
        /// secondary index, DynamoDB fetches each of these attributes from the parent
        /// table. This extra fetching incurs additional throughput cost and latency.</p>
        /// <p>If you query or scan a global secondary index, you can only request
        /// attributes that are projected into the index. Global secondary index queries
        /// cannot fetch attributes from the parent table.</p>
        /// </li>
        /// </ul>
        /// <p>If neither <code>Select</code> nor <code>AttributesToGet</code>
        /// are specified, DynamoDB defaults to <code>ALL_ATTRIBUTES</code> when accessing a
        /// table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when accessing an index. You cannot
        /// use both <code>Select</code> and <code>AttributesToGet</code>
        /// together in a single request, unless the value for <code>Select</code> is
        /// <code>SPECIFIC_ATTRIBUTES</code>. (This usage is equivalent to specifying
        /// <code>AttributesToGet</code> without any value for
        /// <code>Select</code>.)</p>
        /// <note>
        /// <p>If you use the <code>ProjectionExpression</code> parameter, then
        /// the value for <code>Select</code> can only be
        /// <code>SPECIFIC_ATTRIBUTES</code>. Any other value for
        /// <code>Select</code> will return an error.</p>
        /// </note>
        pub fn set_select(mut self, input: std::option::Option<crate::model::Select>) -> Self {
            self.inner = self.inner.set_select(input);
            self
        }
        /// Appends an item to `AttributesToGet`.
        ///
        /// To override the contents of this collection use [`set_attributes_to_get`](Self::set_attributes_to_get).
        ///
        /// <p>This is a legacy parameter.  Use <code>ProjectionExpression</code> instead.  For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn attributes_to_get(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attributes_to_get(inp);
            self
        }
        /// <p>This is a legacy parameter.  Use <code>ProjectionExpression</code> instead.  For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_attributes_to_get(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_attributes_to_get(input);
            self
        }
        /// <p>The maximum number of items to evaluate (not necessarily the number of matching items).
        /// If DynamoDB processes the number of items up to the limit while processing the results,
        /// it stops the operation and returns the matching values up to that point, and a key in
        /// <code>LastEvaluatedKey</code> to apply in a subsequent operation, so that you can
        /// pick up where you left off. Also, if the processed dataset size exceeds 1 MB before
        /// DynamoDB reaches this limit, it stops the operation and returns the matching values up
        /// to the limit, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent
        /// operation to continue the operation. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html">Query and Scan</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of items to evaluate (not necessarily the number of matching items).
        /// If DynamoDB processes the number of items up to the limit while processing the results,
        /// it stops the operation and returns the matching values up to that point, and a key in
        /// <code>LastEvaluatedKey</code> to apply in a subsequent operation, so that you can
        /// pick up where you left off. Also, if the processed dataset size exceeds 1 MB before
        /// DynamoDB reaches this limit, it stops the operation and returns the matching values up
        /// to the limit, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent
        /// operation to continue the operation. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html">Query and Scan</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>Determines the read consistency model:  If set to <code>true</code>, then the operation uses strongly consistent reads; otherwise, the operation uses eventually consistent reads.</p>
        /// <p>Strongly consistent reads
        /// are not supported on global secondary indexes. If you query a global secondary index with <code>ConsistentRead</code> set to
        /// <code>true</code>, you will receive a <code>ValidationException</code>.</p>
        pub fn consistent_read(mut self, inp: bool) -> Self {
            self.inner = self.inner.consistent_read(inp);
            self
        }
        /// <p>Determines the read consistency model:  If set to <code>true</code>, then the operation uses strongly consistent reads; otherwise, the operation uses eventually consistent reads.</p>
        /// <p>Strongly consistent reads
        /// are not supported on global secondary indexes. If you query a global secondary index with <code>ConsistentRead</code> set to
        /// <code>true</code>, you will receive a <code>ValidationException</code>.</p>
        pub fn set_consistent_read(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_consistent_read(input);
            self
        }
        /// Adds a key-value pair to `KeyConditions`.
        ///
        /// To override the contents of this collection use [`set_key_conditions`](Self::set_key_conditions).
        ///
        /// <p>This is a legacy parameter.  Use <code>KeyConditionExpression</code> instead.   For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.KeyConditions.html">KeyConditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn key_conditions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::Condition>,
        ) -> Self {
            self.inner = self.inner.key_conditions(k, v);
            self
        }
        /// <p>This is a legacy parameter.  Use <code>KeyConditionExpression</code> instead.   For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.KeyConditions.html">KeyConditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_key_conditions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Condition>,
            >,
        ) -> Self {
            self.inner = self.inner.set_key_conditions(input);
            self
        }
        /// Adds a key-value pair to `QueryFilter`.
        ///
        /// To override the contents of this collection use [`set_query_filter`](Self::set_query_filter).
        ///
        /// <p>This is a legacy parameter.  Use <code>FilterExpression</code> instead.   For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.QueryFilter.html">QueryFilter</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn query_filter(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::Condition>,
        ) -> Self {
            self.inner = self.inner.query_filter(k, v);
            self
        }
        /// <p>This is a legacy parameter.  Use <code>FilterExpression</code> instead.   For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.QueryFilter.html">QueryFilter</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_query_filter(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Condition>,
            >,
        ) -> Self {
            self.inner = self.inner.set_query_filter(input);
            self
        }
        /// <p>This is a legacy parameter.  Use <code>FilterExpression</code> instead.  For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn conditional_operator(mut self, inp: crate::model::ConditionalOperator) -> Self {
            self.inner = self.inner.conditional_operator(inp);
            self
        }
        /// <p>This is a legacy parameter.  Use <code>FilterExpression</code> instead.  For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_conditional_operator(
            mut self,
            input: std::option::Option<crate::model::ConditionalOperator>,
        ) -> Self {
            self.inner = self.inner.set_conditional_operator(input);
            self
        }
        /// <p>Specifies the order for index traversal: If <code>true</code> (default), the traversal is performed in ascending order; if <code>false</code>, the traversal is performed in descending order. </p>
        /// <p>Items with the same partition key value are stored in sorted order by sort key. If the sort key data type is Number, the results are stored in numeric order. For type String, the results are stored in order of UTF-8 bytes. For type Binary, DynamoDB treats each byte of the binary data as unsigned.</p>
        /// <p>If <code>ScanIndexForward</code> is <code>true</code>, DynamoDB returns the results in the order in which they are stored (by sort key value). This is the default behavior. If <code>ScanIndexForward</code> is <code>false</code>, DynamoDB reads the results in reverse order by sort key value, and then returns the results to the client.</p>
        pub fn scan_index_forward(mut self, inp: bool) -> Self {
            self.inner = self.inner.scan_index_forward(inp);
            self
        }
        /// <p>Specifies the order for index traversal: If <code>true</code> (default), the traversal is performed in ascending order; if <code>false</code>, the traversal is performed in descending order. </p>
        /// <p>Items with the same partition key value are stored in sorted order by sort key. If the sort key data type is Number, the results are stored in numeric order. For type String, the results are stored in order of UTF-8 bytes. For type Binary, DynamoDB treats each byte of the binary data as unsigned.</p>
        /// <p>If <code>ScanIndexForward</code> is <code>true</code>, DynamoDB returns the results in the order in which they are stored (by sort key value). This is the default behavior. If <code>ScanIndexForward</code> is <code>false</code>, DynamoDB reads the results in reverse order by sort key value, and then returns the results to the client.</p>
        pub fn set_scan_index_forward(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_scan_index_forward(input);
            self
        }
        /// Adds a key-value pair to `ExclusiveStartKey`.
        ///
        /// To override the contents of this collection use [`set_exclusive_start_key`](Self::set_exclusive_start_key).
        ///
        /// <p>The primary key of the first item that this operation will evaluate. Use the value that was returned for <code>LastEvaluatedKey</code> in the previous operation.</p>
        /// <p>The data type for <code>ExclusiveStartKey</code> must be String, Number, or Binary. No
        /// set data types are allowed.</p>
        pub fn exclusive_start_key(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeValue>,
        ) -> Self {
            self.inner = self.inner.exclusive_start_key(k, v);
            self
        }
        /// <p>The primary key of the first item that this operation will evaluate. Use the value that was returned for <code>LastEvaluatedKey</code> in the previous operation.</p>
        /// <p>The data type for <code>ExclusiveStartKey</code> must be String, Number, or Binary. No
        /// set data types are allowed.</p>
        pub fn set_exclusive_start_key(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_exclusive_start_key(input);
            self
        }
        /// <p>Determines the level of detail about provisioned throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all.  In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p>
        /// </li>
        /// </ul>
        pub fn return_consumed_capacity(
            mut self,
            inp: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.inner = self.inner.return_consumed_capacity(inp);
            self
        }
        /// <p>Determines the level of detail about provisioned throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all.  In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p>
        /// </li>
        /// </ul>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.inner = self.inner.set_return_consumed_capacity(input);
            self
        }
        /// <p>A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.</p>
        /// <p>If no attribute names are specified, then all attributes will be returned. If any of the requested attributes are not found, they will not appear in the result.</p>
        /// <p>For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn projection_expression(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.projection_expression(inp);
            self
        }
        /// <p>A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.</p>
        /// <p>If no attribute names are specified, then all attributes will be returned. If any of the requested attributes are not found, they will not appear in the result.</p>
        /// <p>For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_projection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_projection_expression(input);
            self
        }
        /// <p>A string that contains conditions that DynamoDB applies after the <code>Query</code> operation, but
        /// before the data is returned to you. Items that do not satisfy the <code>FilterExpression</code>
        /// criteria are not returned.</p>
        /// <p>A <code>FilterExpression</code> does not allow key attributes.  You cannot define a filter expression based on a partition key or a sort key.</p>
        /// <note>
        /// <p>A <code>FilterExpression</code> is applied after the items have already been read; the process of
        /// filtering does not consume any additional read capacity units.</p>
        /// </note>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults">Filter
        /// Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn filter_expression(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_expression(inp);
            self
        }
        /// <p>A string that contains conditions that DynamoDB applies after the <code>Query</code> operation, but
        /// before the data is returned to you. Items that do not satisfy the <code>FilterExpression</code>
        /// criteria are not returned.</p>
        /// <p>A <code>FilterExpression</code> does not allow key attributes.  You cannot define a filter expression based on a partition key or a sort key.</p>
        /// <note>
        /// <p>A <code>FilterExpression</code> is applied after the items have already been read; the process of
        /// filtering does not consume any additional read capacity units.</p>
        /// </note>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults">Filter
        /// Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_filter_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_filter_expression(input);
            self
        }
        /// <p>The condition that specifies the key values for items to be retrieved by the
        /// <code>Query</code> action.</p>
        ///
        /// <p>The condition must perform an equality test on a single partition key value.</p>
        /// <p>The condition can optionally perform one of several comparison tests on a single
        /// sort key value. This allows <code>Query</code> to retrieve one item with a given
        /// partition key value and sort key value, or several items that have the same partition
        /// key value but different sort key values.</p>
        ///
        /// <p>The partition key equality test is required, and must be specified in the following format:</p>
        ///
        /// <p>
        /// <code>partitionKeyName</code>
        /// <i>=</i>
        /// <code>:partitionkeyval</code>
        /// </p>
        ///
        /// <p>If you also want to provide a condition for the sort key, it must be combined using <code>AND</code> with the condition
        /// for the sort key. Following is an example, using the <b>=</b> comparison operator for the sort key:</p>
        ///
        /// <p>
        /// <code>partitionKeyName</code>
        /// <code>=</code>
        /// <code>:partitionkeyval</code>
        /// <code>AND</code>
        /// <code>sortKeyName</code>
        /// <code>=</code>
        /// <code>:sortkeyval</code>
        /// </p>
        /// <p>Valid comparisons for the sort key condition are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>sortKeyName</code>
        /// <code>=</code>
        /// <code>:sortkeyval</code> - true if the sort key value is equal to <code>:sortkeyval</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sortKeyName</code>
        /// <code><</code>
        /// <code>:sortkeyval</code> - true if the sort key value is less than <code>:sortkeyval</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sortKeyName</code>
        /// <code><=</code>
        /// <code>:sortkeyval</code> - true if the sort key value is less than or equal to
        /// <code>:sortkeyval</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sortKeyName</code>
        /// <code>></code>
        /// <code>:sortkeyval</code> - true if the sort key value is greater than <code>:sortkeyval</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sortKeyName</code>
        /// <code>>= </code>
        /// <code>:sortkeyval</code> - true if the sort key value is greater than
        /// or equal to <code>:sortkeyval</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sortKeyName</code>
        /// <code>BETWEEN</code>
        /// <code>:sortkeyval1</code>
        /// <code>AND</code>
        /// <code>:sortkeyval2</code> - true if the sort key value is greater than or equal to
        /// <code>:sortkeyval1</code>, and less than or equal to <code>:sortkeyval2</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>begins_with (</code>
        /// <code>sortKeyName</code>, <code>:sortkeyval</code>
        /// <code>)</code> -
        /// true if the sort key value begins with a particular operand. (You cannot use this function with a sort key that is of type Number.)  Note that the function name
        /// <code>begins_with</code> is case-sensitive.</p>
        ///
        /// </li>
        /// </ul>
        ///
        /// <p>Use the <code>ExpressionAttributeValues</code> parameter to replace tokens such as
        /// <code>:partitionval</code> and <code>:sortval</code> with actual values at runtime.</p>
        ///
        /// <p>You can optionally use the <code>ExpressionAttributeNames</code> parameter to replace the names of
        /// the partition key and sort key with placeholder tokens. This option might be necessary if an attribute
        /// name conflicts with a DynamoDB reserved word. For example, the following
        /// <code>KeyConditionExpression</code> parameter causes an error because <i>Size</i> is a reserved
        /// word:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Size = :myval</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>To work around this, define a placeholder (such a <code>#S</code>) to represent the attribute
        /// name <i>Size</i>. <code>KeyConditionExpression</code> then is as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#S = :myval</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For a list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved
        /// Words</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        ///
        /// <p>For more information on <code>ExpressionAttributeNames</code> and <code>ExpressionAttributeValues</code>,
        /// see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ExpressionPlaceholders.html">Using Placeholders for Attribute
        /// Names and Values</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn key_condition_expression(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_condition_expression(inp);
            self
        }
        /// <p>The condition that specifies the key values for items to be retrieved by the
        /// <code>Query</code> action.</p>
        ///
        /// <p>The condition must perform an equality test on a single partition key value.</p>
        /// <p>The condition can optionally perform one of several comparison tests on a single
        /// sort key value. This allows <code>Query</code> to retrieve one item with a given
        /// partition key value and sort key value, or several items that have the same partition
        /// key value but different sort key values.</p>
        ///
        /// <p>The partition key equality test is required, and must be specified in the following format:</p>
        ///
        /// <p>
        /// <code>partitionKeyName</code>
        /// <i>=</i>
        /// <code>:partitionkeyval</code>
        /// </p>
        ///
        /// <p>If you also want to provide a condition for the sort key, it must be combined using <code>AND</code> with the condition
        /// for the sort key. Following is an example, using the <b>=</b> comparison operator for the sort key:</p>
        ///
        /// <p>
        /// <code>partitionKeyName</code>
        /// <code>=</code>
        /// <code>:partitionkeyval</code>
        /// <code>AND</code>
        /// <code>sortKeyName</code>
        /// <code>=</code>
        /// <code>:sortkeyval</code>
        /// </p>
        /// <p>Valid comparisons for the sort key condition are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>sortKeyName</code>
        /// <code>=</code>
        /// <code>:sortkeyval</code> - true if the sort key value is equal to <code>:sortkeyval</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sortKeyName</code>
        /// <code><</code>
        /// <code>:sortkeyval</code> - true if the sort key value is less than <code>:sortkeyval</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sortKeyName</code>
        /// <code><=</code>
        /// <code>:sortkeyval</code> - true if the sort key value is less than or equal to
        /// <code>:sortkeyval</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sortKeyName</code>
        /// <code>></code>
        /// <code>:sortkeyval</code> - true if the sort key value is greater than <code>:sortkeyval</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sortKeyName</code>
        /// <code>>= </code>
        /// <code>:sortkeyval</code> - true if the sort key value is greater than
        /// or equal to <code>:sortkeyval</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sortKeyName</code>
        /// <code>BETWEEN</code>
        /// <code>:sortkeyval1</code>
        /// <code>AND</code>
        /// <code>:sortkeyval2</code> - true if the sort key value is greater than or equal to
        /// <code>:sortkeyval1</code>, and less than or equal to <code>:sortkeyval2</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>begins_with (</code>
        /// <code>sortKeyName</code>, <code>:sortkeyval</code>
        /// <code>)</code> -
        /// true if the sort key value begins with a particular operand. (You cannot use this function with a sort key that is of type Number.)  Note that the function name
        /// <code>begins_with</code> is case-sensitive.</p>
        ///
        /// </li>
        /// </ul>
        ///
        /// <p>Use the <code>ExpressionAttributeValues</code> parameter to replace tokens such as
        /// <code>:partitionval</code> and <code>:sortval</code> with actual values at runtime.</p>
        ///
        /// <p>You can optionally use the <code>ExpressionAttributeNames</code> parameter to replace the names of
        /// the partition key and sort key with placeholder tokens. This option might be necessary if an attribute
        /// name conflicts with a DynamoDB reserved word. For example, the following
        /// <code>KeyConditionExpression</code> parameter causes an error because <i>Size</i> is a reserved
        /// word:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Size = :myval</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>To work around this, define a placeholder (such a <code>#S</code>) to represent the attribute
        /// name <i>Size</i>. <code>KeyConditionExpression</code> then is as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#S = :myval</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For a list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved
        /// Words</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        ///
        /// <p>For more information on <code>ExpressionAttributeNames</code> and <code>ExpressionAttributeValues</code>,
        /// see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ExpressionPlaceholders.html">Using Placeholders for Attribute
        /// Names and Values</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_key_condition_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_key_condition_expression(input);
            self
        }
        /// Adds a key-value pair to `ExpressionAttributeNames`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_names`](Self::set_expression_attribute_names).
        ///
        /// <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p>
        /// </li>
        /// <li>
        /// <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p>
        /// </li>
        /// <li>
        /// <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p>
        /// </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Percentile</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for
        /// <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>{"#P":"Percentile"}</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#P = :val</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>
        /// </note>
        /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn expression_attribute_names(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.expression_attribute_names(k, v);
            self
        }
        /// <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p>
        /// </li>
        /// <li>
        /// <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p>
        /// </li>
        /// <li>
        /// <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p>
        /// </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Percentile</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for
        /// <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>{"#P":"Percentile"}</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#P = :val</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>
        /// </note>
        /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_expression_attribute_names(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_expression_attribute_names(input);
            self
        }
        /// Adds a key-value pair to `ExpressionAttributeValues`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_values`](Self::set_expression_attribute_values).
        ///
        /// <p>One or more values that can be substituted in an expression.</p>
        /// <p>Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose that you wanted to check whether the value of the
        /// <i>ProductStatus</i> attribute was one of the following: </p>
        /// <p>
        /// <code>Available | Backordered | Discontinued</code>
        /// </p>
        /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as follows:</p>
        /// <p>
        /// <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
        /// </p>
        /// <p>You could then use these values in an expression, such as this:</p>
        /// <p>
        /// <code>ProductStatus IN (:avail, :back, :disc)</code>
        /// </p>
        /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn expression_attribute_values(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeValue>,
        ) -> Self {
            self.inner = self.inner.expression_attribute_values(k, v);
            self
        }
        /// <p>One or more values that can be substituted in an expression.</p>
        /// <p>Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose that you wanted to check whether the value of the
        /// <i>ProductStatus</i> attribute was one of the following: </p>
        /// <p>
        /// <code>Available | Backordered | Discontinued</code>
        /// </p>
        /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as follows:</p>
        /// <p>
        /// <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
        /// </p>
        /// <p>You could then use these values in an expression, such as this:</p>
        /// <p>
        /// <code>ProductStatus IN (:avail, :back, :disc)</code>
        /// </p>
        /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_expression_attribute_values(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_expression_attribute_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestoreTableFromBackup`.
    ///
    /// <p>Creates a new table from an existing backup. Any number of users can execute up to 4 concurrent restores
    /// (any type of restore) in a given account.
    /// </p>
    /// <p>You can call <code>RestoreTableFromBackup</code> at a maximum rate of 10 times per second.</p>
    /// <p>You must manually set up the following on the restored table:</p>
    /// <ul>
    /// <li>
    /// <p>Auto scaling policies</p>
    /// </li>
    /// <li>
    /// <p>IAM policies</p>
    /// </li>
    /// <li>
    /// <p>Amazon CloudWatch metrics and alarms</p>
    /// </li>
    /// <li>
    /// <p>Tags</p>
    /// </li>
    /// <li>
    /// <p>Stream settings</p>
    /// </li>
    /// <li>
    /// <p>Time to Live (TTL) settings</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct RestoreTableFromBackup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::restore_table_from_backup_input::Builder,
    }
    impl<C, M, R> RestoreTableFromBackup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RestoreTableFromBackup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestoreTableFromBackupOutput,
            aws_smithy_http::result::SdkError<crate::error::RestoreTableFromBackupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RestoreTableFromBackupInputOperationOutputAlias,
                crate::output::RestoreTableFromBackupOutput,
                crate::error::RestoreTableFromBackupError,
                crate::input::RestoreTableFromBackupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the new table to which the backup must be restored.</p>
        pub fn target_table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_table_name(inp);
            self
        }
        /// <p>The name of the new table to which the backup must be restored.</p>
        pub fn set_target_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_table_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) associated with the backup.</p>
        pub fn backup_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) associated with the backup.</p>
        pub fn set_backup_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_backup_arn(input);
            self
        }
        /// <p>The billing mode of the restored table.</p>
        pub fn billing_mode_override(mut self, inp: crate::model::BillingMode) -> Self {
            self.inner = self.inner.billing_mode_override(inp);
            self
        }
        /// <p>The billing mode of the restored table.</p>
        pub fn set_billing_mode_override(
            mut self,
            input: std::option::Option<crate::model::BillingMode>,
        ) -> Self {
            self.inner = self.inner.set_billing_mode_override(input);
            self
        }
        /// Appends an item to `GlobalSecondaryIndexOverride`.
        ///
        /// To override the contents of this collection use [`set_global_secondary_index_override`](Self::set_global_secondary_index_override).
        ///
        /// <p>List of global secondary indexes for the restored table. The indexes
        /// provided should match existing secondary indexes. You can choose to exclude
        /// some or all of the indexes at the time of restore.</p>
        pub fn global_secondary_index_override(
            mut self,
            inp: impl Into<crate::model::GlobalSecondaryIndex>,
        ) -> Self {
            self.inner = self.inner.global_secondary_index_override(inp);
            self
        }
        /// <p>List of global secondary indexes for the restored table. The indexes
        /// provided should match existing secondary indexes. You can choose to exclude
        /// some or all of the indexes at the time of restore.</p>
        pub fn set_global_secondary_index_override(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GlobalSecondaryIndex>>,
        ) -> Self {
            self.inner = self.inner.set_global_secondary_index_override(input);
            self
        }
        /// Appends an item to `LocalSecondaryIndexOverride`.
        ///
        /// To override the contents of this collection use [`set_local_secondary_index_override`](Self::set_local_secondary_index_override).
        ///
        /// <p>List of local secondary indexes for the restored table. The indexes
        /// provided should match existing secondary indexes. You can choose to exclude
        /// some or all of the indexes at the time of restore.</p>
        pub fn local_secondary_index_override(
            mut self,
            inp: impl Into<crate::model::LocalSecondaryIndex>,
        ) -> Self {
            self.inner = self.inner.local_secondary_index_override(inp);
            self
        }
        /// <p>List of local secondary indexes for the restored table. The indexes
        /// provided should match existing secondary indexes. You can choose to exclude
        /// some or all of the indexes at the time of restore.</p>
        pub fn set_local_secondary_index_override(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LocalSecondaryIndex>>,
        ) -> Self {
            self.inner = self.inner.set_local_secondary_index_override(input);
            self
        }
        /// <p>Provisioned throughput settings for the restored table.</p>
        pub fn provisioned_throughput_override(
            mut self,
            inp: crate::model::ProvisionedThroughput,
        ) -> Self {
            self.inner = self.inner.provisioned_throughput_override(inp);
            self
        }
        /// <p>Provisioned throughput settings for the restored table.</p>
        pub fn set_provisioned_throughput_override(
            mut self,
            input: std::option::Option<crate::model::ProvisionedThroughput>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_throughput_override(input);
            self
        }
        /// <p>The new server-side encryption settings for the restored table.</p>
        pub fn sse_specification_override(mut self, inp: crate::model::SseSpecification) -> Self {
            self.inner = self.inner.sse_specification_override(inp);
            self
        }
        /// <p>The new server-side encryption settings for the restored table.</p>
        pub fn set_sse_specification_override(
            mut self,
            input: std::option::Option<crate::model::SseSpecification>,
        ) -> Self {
            self.inner = self.inner.set_sse_specification_override(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestoreTableToPointInTime`.
    ///
    /// <p>Restores the specified table to the specified point in time within
    /// <code>EarliestRestorableDateTime</code> and <code>LatestRestorableDateTime</code>.
    /// You can restore your table to any point in time during the last 35 days.
    /// Any number of users can execute up to 4 concurrent restores (any type of restore) in a given account.
    /// </p>
    /// <p>
    /// When you restore using point in time recovery, DynamoDB restores your table data to the state based on
    /// the selected date and time (day:hour:minute:second) to a new table.
    /// </p>
    /// <p>
    /// Along with data, the following are also included on the new restored table using point in time recovery:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>Global secondary indexes (GSIs)</p>
    /// </li>
    /// <li>
    /// <p>Local secondary indexes (LSIs)</p>
    /// </li>
    /// <li>
    /// <p>Provisioned read and write capacity</p>
    /// </li>
    /// <li>
    /// <p>Encryption settings</p>
    /// <important>
    /// <p>
    /// All these settings come from the current settings of the source table at the time of restore.
    /// </p>
    /// </important>
    /// </li>
    /// </ul>
    ///
    /// <p>You must manually set up the following on the restored table:</p>
    /// <ul>
    /// <li>
    /// <p>Auto scaling policies</p>
    /// </li>
    /// <li>
    /// <p>IAM policies</p>
    /// </li>
    /// <li>
    /// <p>Amazon CloudWatch metrics and alarms</p>
    /// </li>
    /// <li>
    /// <p>Tags</p>
    /// </li>
    /// <li>
    /// <p>Stream settings</p>
    /// </li>
    /// <li>
    /// <p>Time to Live (TTL) settings</p>
    /// </li>
    /// <li>
    /// <p>Point in time recovery settings</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct RestoreTableToPointInTime<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::restore_table_to_point_in_time_input::Builder,
    }
    impl<C, M, R> RestoreTableToPointInTime<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RestoreTableToPointInTime`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestoreTableToPointInTimeOutput,
            aws_smithy_http::result::SdkError<crate::error::RestoreTableToPointInTimeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RestoreTableToPointInTimeInputOperationOutputAlias,
                crate::output::RestoreTableToPointInTimeOutput,
                crate::error::RestoreTableToPointInTimeError,
                crate::input::RestoreTableToPointInTimeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DynamoDB table that will be restored. This value is an Amazon
        /// Resource Name (ARN).</p>
        pub fn source_table_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_table_arn(inp);
            self
        }
        /// <p>The DynamoDB table that will be restored. This value is an Amazon
        /// Resource Name (ARN).</p>
        pub fn set_source_table_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_table_arn(input);
            self
        }
        /// <p>Name of the source table that is being restored.</p>
        pub fn source_table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_table_name(inp);
            self
        }
        /// <p>Name of the source table that is being restored.</p>
        pub fn set_source_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_table_name(input);
            self
        }
        /// <p>The name of the new table to which it must be restored to.</p>
        pub fn target_table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_table_name(inp);
            self
        }
        /// <p>The name of the new table to which it must be restored to.</p>
        pub fn set_target_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_table_name(input);
            self
        }
        /// <p>Restore the table to the latest possible time. <code>LatestRestorableDateTime</code>
        /// is typically 5 minutes before the current time. </p>
        pub fn use_latest_restorable_time(mut self, inp: bool) -> Self {
            self.inner = self.inner.use_latest_restorable_time(inp);
            self
        }
        /// <p>Restore the table to the latest possible time. <code>LatestRestorableDateTime</code>
        /// is typically 5 minutes before the current time. </p>
        pub fn set_use_latest_restorable_time(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_use_latest_restorable_time(input);
            self
        }
        /// <p>Time in the past to restore the table to.</p>
        pub fn restore_date_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.restore_date_time(inp);
            self
        }
        /// <p>Time in the past to restore the table to.</p>
        pub fn set_restore_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_restore_date_time(input);
            self
        }
        /// <p>The billing mode of the restored table.</p>
        pub fn billing_mode_override(mut self, inp: crate::model::BillingMode) -> Self {
            self.inner = self.inner.billing_mode_override(inp);
            self
        }
        /// <p>The billing mode of the restored table.</p>
        pub fn set_billing_mode_override(
            mut self,
            input: std::option::Option<crate::model::BillingMode>,
        ) -> Self {
            self.inner = self.inner.set_billing_mode_override(input);
            self
        }
        /// Appends an item to `GlobalSecondaryIndexOverride`.
        ///
        /// To override the contents of this collection use [`set_global_secondary_index_override`](Self::set_global_secondary_index_override).
        ///
        /// <p>List of global secondary indexes for the restored table. The indexes
        /// provided should match existing secondary indexes. You can choose to exclude
        /// some or all of the indexes at the time of restore.</p>
        pub fn global_secondary_index_override(
            mut self,
            inp: impl Into<crate::model::GlobalSecondaryIndex>,
        ) -> Self {
            self.inner = self.inner.global_secondary_index_override(inp);
            self
        }
        /// <p>List of global secondary indexes for the restored table. The indexes
        /// provided should match existing secondary indexes. You can choose to exclude
        /// some or all of the indexes at the time of restore.</p>
        pub fn set_global_secondary_index_override(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GlobalSecondaryIndex>>,
        ) -> Self {
            self.inner = self.inner.set_global_secondary_index_override(input);
            self
        }
        /// Appends an item to `LocalSecondaryIndexOverride`.
        ///
        /// To override the contents of this collection use [`set_local_secondary_index_override`](Self::set_local_secondary_index_override).
        ///
        /// <p>List of local secondary indexes for the restored table. The indexes
        /// provided should match existing secondary indexes. You can choose to exclude
        /// some or all of the indexes at the time of restore.</p>
        pub fn local_secondary_index_override(
            mut self,
            inp: impl Into<crate::model::LocalSecondaryIndex>,
        ) -> Self {
            self.inner = self.inner.local_secondary_index_override(inp);
            self
        }
        /// <p>List of local secondary indexes for the restored table. The indexes
        /// provided should match existing secondary indexes. You can choose to exclude
        /// some or all of the indexes at the time of restore.</p>
        pub fn set_local_secondary_index_override(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LocalSecondaryIndex>>,
        ) -> Self {
            self.inner = self.inner.set_local_secondary_index_override(input);
            self
        }
        /// <p>Provisioned throughput settings for the restored table.</p>
        pub fn provisioned_throughput_override(
            mut self,
            inp: crate::model::ProvisionedThroughput,
        ) -> Self {
            self.inner = self.inner.provisioned_throughput_override(inp);
            self
        }
        /// <p>Provisioned throughput settings for the restored table.</p>
        pub fn set_provisioned_throughput_override(
            mut self,
            input: std::option::Option<crate::model::ProvisionedThroughput>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_throughput_override(input);
            self
        }
        /// <p>The new server-side encryption settings for the restored table.</p>
        pub fn sse_specification_override(mut self, inp: crate::model::SseSpecification) -> Self {
            self.inner = self.inner.sse_specification_override(inp);
            self
        }
        /// <p>The new server-side encryption settings for the restored table.</p>
        pub fn set_sse_specification_override(
            mut self,
            input: std::option::Option<crate::model::SseSpecification>,
        ) -> Self {
            self.inner = self.inner.set_sse_specification_override(input);
            self
        }
    }
    /// Fluent builder constructing a request to `Scan`.
    ///
    /// <p>The <code>Scan</code> operation returns one or more items and item attributes by accessing every
    /// item in a table or a secondary index. To have DynamoDB return fewer items, you can provide a <code>FilterExpression</code> operation.</p>
    /// <p>If the total number of scanned items exceeds the maximum dataset size limit of 1 MB, the
    /// scan stops and results are returned to the user as a <code>LastEvaluatedKey</code> value
    /// to continue the scan in a subsequent operation. The results also include the number of
    /// items exceeding the limit. A scan can result in no table data meeting the filter
    /// criteria. </p>
    /// <p>A single <code>Scan</code> operation reads up to the maximum number of items set (if
    /// using the <code>Limit</code> parameter) or a maximum of 1 MB of data and then apply any
    /// filtering to the results using <code>FilterExpression</code>. If
    /// <code>LastEvaluatedKey</code> is present in the response, you need to paginate the
    /// result set. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Scan.html#Scan.Pagination">Paginating the
    /// Results</a> in the <i>Amazon DynamoDB Developer Guide</i>. </p>
    /// <p>
    /// <code>Scan</code> operations proceed sequentially; however, for faster performance on
    /// a large table or secondary index, applications can request a parallel <code>Scan</code>
    /// operation by providing the <code>Segment</code> and <code>TotalSegments</code>
    /// parameters. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Scan.html#Scan.ParallelScan">Parallel
    /// Scan</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    /// <p>
    /// <code>Scan</code> uses eventually consistent reads when accessing the data in a
    /// table; therefore, the result set might not include the changes to data in the table
    /// immediately before the operation began. If you need a consistent copy of the data, as of
    /// the time that the <code>Scan</code> begins, you can set the <code>ConsistentRead</code>
    /// parameter to <code>true</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct Scan<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::scan_input::Builder,
    }
    impl<C, M, R> Scan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `Scan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ScanOutput,
            aws_smithy_http::result::SdkError<crate::error::ScanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ScanInputOperationOutputAlias,
                crate::output::ScanOutput,
                crate::error::ScanError,
                crate::input::ScanInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the table containing the requested items; or, if you provide
        /// <code>IndexName</code>, the name of the table to which that index belongs.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the table containing the requested items; or, if you provide
        /// <code>IndexName</code>, the name of the table to which that index belongs.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>The name of a secondary index to scan. This index can be any local secondary index or global secondary index.  Note that if you use the <code>IndexName</code> parameter, you must also provide <code>TableName</code>.</p>
        pub fn index_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(inp);
            self
        }
        /// <p>The name of a secondary index to scan. This index can be any local secondary index or global secondary index.  Note that if you use the <code>IndexName</code> parameter, you must also provide <code>TableName</code>.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
        /// Appends an item to `AttributesToGet`.
        ///
        /// To override the contents of this collection use [`set_attributes_to_get`](Self::set_attributes_to_get).
        ///
        /// <p>This is a legacy parameter.  Use <code>ProjectionExpression</code> instead.  For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn attributes_to_get(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attributes_to_get(inp);
            self
        }
        /// <p>This is a legacy parameter.  Use <code>ProjectionExpression</code> instead.  For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_attributes_to_get(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_attributes_to_get(input);
            self
        }
        /// <p>The maximum number of items to evaluate (not necessarily the number of matching items).
        /// If DynamoDB processes the number of items up to the limit while processing the results,
        /// it stops the operation and returns the matching values up to that point, and a key in
        /// <code>LastEvaluatedKey</code> to apply in a subsequent operation, so that you can
        /// pick up where you left off. Also, if the processed dataset size exceeds 1 MB before
        /// DynamoDB reaches this limit, it stops the operation and returns the matching values up
        /// to the limit, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent
        /// operation to continue the operation. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html">Working with Queries</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of items to evaluate (not necessarily the number of matching items).
        /// If DynamoDB processes the number of items up to the limit while processing the results,
        /// it stops the operation and returns the matching values up to that point, and a key in
        /// <code>LastEvaluatedKey</code> to apply in a subsequent operation, so that you can
        /// pick up where you left off. Also, if the processed dataset size exceeds 1 MB before
        /// DynamoDB reaches this limit, it stops the operation and returns the matching values up
        /// to the limit, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent
        /// operation to continue the operation. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html">Working with Queries</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The attributes to be returned in the
        /// result. You can retrieve all item attributes, specific item attributes, the count of
        /// matching items, or in the case of an index, some or all of the attributes projected into
        /// the index.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the
        /// specified table or index. If you query a local secondary index, then for each
        /// matching item in the index, DynamoDB fetches the entire item from the parent
        /// table. If the index is configured to project all item attributes, then all of
        /// the data can be obtained from the local secondary index, and no fetching is
        /// required.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index.
        /// Retrieves all attributes that have been projected into the index. If the
        /// index is configured to project all attributes, this return value is
        /// equivalent to specifying <code>ALL_ATTRIBUTES</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COUNT</code> - Returns the number of matching items, rather than the
        /// matching items themselves.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in
        /// <code>AttributesToGet</code>. This return value is equivalent to
        /// specifying <code>AttributesToGet</code> without specifying any value
        /// for <code>Select</code>.</p>
        /// <p>If you query or scan a local secondary index and request only attributes that
        /// are projected into that index, the operation reads only the index and not the
        /// table. If any of the requested attributes are not projected into the local
        /// secondary index, DynamoDB fetches each of these attributes from the parent
        /// table. This extra fetching incurs additional throughput cost and latency.</p>
        /// <p>If you query or scan a global secondary index, you can only request
        /// attributes that are projected into the index. Global secondary index queries
        /// cannot fetch attributes from the parent table.</p>
        /// </li>
        /// </ul>
        /// <p>If neither <code>Select</code> nor <code>AttributesToGet</code>
        /// are specified, DynamoDB defaults to <code>ALL_ATTRIBUTES</code> when accessing a
        /// table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when accessing an index. You cannot
        /// use both <code>Select</code> and <code>AttributesToGet</code>
        /// together in a single request, unless the value for <code>Select</code> is
        /// <code>SPECIFIC_ATTRIBUTES</code>. (This usage is equivalent to specifying
        /// <code>AttributesToGet</code> without any value for
        /// <code>Select</code>.)</p>
        /// <note>
        /// <p>If you use the <code>ProjectionExpression</code> parameter, then
        /// the value for <code>Select</code> can only be
        /// <code>SPECIFIC_ATTRIBUTES</code>. Any other value for
        /// <code>Select</code> will return an error.</p>
        /// </note>
        pub fn select(mut self, inp: crate::model::Select) -> Self {
            self.inner = self.inner.select(inp);
            self
        }
        /// <p>The attributes to be returned in the
        /// result. You can retrieve all item attributes, specific item attributes, the count of
        /// matching items, or in the case of an index, some or all of the attributes projected into
        /// the index.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the
        /// specified table or index. If you query a local secondary index, then for each
        /// matching item in the index, DynamoDB fetches the entire item from the parent
        /// table. If the index is configured to project all item attributes, then all of
        /// the data can be obtained from the local secondary index, and no fetching is
        /// required.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index.
        /// Retrieves all attributes that have been projected into the index. If the
        /// index is configured to project all attributes, this return value is
        /// equivalent to specifying <code>ALL_ATTRIBUTES</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COUNT</code> - Returns the number of matching items, rather than the
        /// matching items themselves.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in
        /// <code>AttributesToGet</code>. This return value is equivalent to
        /// specifying <code>AttributesToGet</code> without specifying any value
        /// for <code>Select</code>.</p>
        /// <p>If you query or scan a local secondary index and request only attributes that
        /// are projected into that index, the operation reads only the index and not the
        /// table. If any of the requested attributes are not projected into the local
        /// secondary index, DynamoDB fetches each of these attributes from the parent
        /// table. This extra fetching incurs additional throughput cost and latency.</p>
        /// <p>If you query or scan a global secondary index, you can only request
        /// attributes that are projected into the index. Global secondary index queries
        /// cannot fetch attributes from the parent table.</p>
        /// </li>
        /// </ul>
        /// <p>If neither <code>Select</code> nor <code>AttributesToGet</code>
        /// are specified, DynamoDB defaults to <code>ALL_ATTRIBUTES</code> when accessing a
        /// table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when accessing an index. You cannot
        /// use both <code>Select</code> and <code>AttributesToGet</code>
        /// together in a single request, unless the value for <code>Select</code> is
        /// <code>SPECIFIC_ATTRIBUTES</code>. (This usage is equivalent to specifying
        /// <code>AttributesToGet</code> without any value for
        /// <code>Select</code>.)</p>
        /// <note>
        /// <p>If you use the <code>ProjectionExpression</code> parameter, then
        /// the value for <code>Select</code> can only be
        /// <code>SPECIFIC_ATTRIBUTES</code>. Any other value for
        /// <code>Select</code> will return an error.</p>
        /// </note>
        pub fn set_select(mut self, input: std::option::Option<crate::model::Select>) -> Self {
            self.inner = self.inner.set_select(input);
            self
        }
        /// Adds a key-value pair to `ScanFilter`.
        ///
        /// To override the contents of this collection use [`set_scan_filter`](Self::set_scan_filter).
        ///
        /// <p>This is a legacy parameter.  Use <code>FilterExpression</code> instead.   For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ScanFilter.html">ScanFilter</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn scan_filter(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::Condition>,
        ) -> Self {
            self.inner = self.inner.scan_filter(k, v);
            self
        }
        /// <p>This is a legacy parameter.  Use <code>FilterExpression</code> instead.   For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ScanFilter.html">ScanFilter</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_scan_filter(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Condition>,
            >,
        ) -> Self {
            self.inner = self.inner.set_scan_filter(input);
            self
        }
        /// <p>This is a legacy parameter.  Use <code>FilterExpression</code> instead.   For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn conditional_operator(mut self, inp: crate::model::ConditionalOperator) -> Self {
            self.inner = self.inner.conditional_operator(inp);
            self
        }
        /// <p>This is a legacy parameter.  Use <code>FilterExpression</code> instead.   For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_conditional_operator(
            mut self,
            input: std::option::Option<crate::model::ConditionalOperator>,
        ) -> Self {
            self.inner = self.inner.set_conditional_operator(input);
            self
        }
        /// Adds a key-value pair to `ExclusiveStartKey`.
        ///
        /// To override the contents of this collection use [`set_exclusive_start_key`](Self::set_exclusive_start_key).
        ///
        /// <p>The primary key of the first item that this operation will evaluate. Use the value that was returned for <code>LastEvaluatedKey</code> in the previous operation.</p>
        /// <p>The data type for <code>ExclusiveStartKey</code> must be String, Number or Binary. No set data types are allowed.</p>
        /// <p>In a parallel scan, a
        /// <code>Scan</code> request that includes <code>ExclusiveStartKey</code> must specify the same segment
        /// whose previous <code>Scan</code> returned the corresponding value of <code>LastEvaluatedKey</code>.</p>
        pub fn exclusive_start_key(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeValue>,
        ) -> Self {
            self.inner = self.inner.exclusive_start_key(k, v);
            self
        }
        /// <p>The primary key of the first item that this operation will evaluate. Use the value that was returned for <code>LastEvaluatedKey</code> in the previous operation.</p>
        /// <p>The data type for <code>ExclusiveStartKey</code> must be String, Number or Binary. No set data types are allowed.</p>
        /// <p>In a parallel scan, a
        /// <code>Scan</code> request that includes <code>ExclusiveStartKey</code> must specify the same segment
        /// whose previous <code>Scan</code> returned the corresponding value of <code>LastEvaluatedKey</code>.</p>
        pub fn set_exclusive_start_key(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_exclusive_start_key(input);
            self
        }
        /// <p>Determines the level of detail about provisioned throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all.  In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p>
        /// </li>
        /// </ul>
        pub fn return_consumed_capacity(
            mut self,
            inp: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.inner = self.inner.return_consumed_capacity(inp);
            self
        }
        /// <p>Determines the level of detail about provisioned throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all.  In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p>
        /// </li>
        /// </ul>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.inner = self.inner.set_return_consumed_capacity(input);
            self
        }
        /// <p>For a parallel <code>Scan</code> request, <code>TotalSegments</code> represents the total number of
        /// segments into which the <code>Scan</code> operation will be divided. The value of
        /// <code>TotalSegments</code> corresponds to the number of application workers that will perform the
        /// parallel scan. For example, if you want to use four application threads to scan a table or an index,
        /// specify a <code>TotalSegments</code> value of 4.</p>
        /// <p>The value for <code>TotalSegments</code> must be greater than or equal to 1, and less than or equal
        /// to 1000000. If you specify a <code>TotalSegments</code> value of 1, the <code>Scan</code> operation will
        /// be sequential rather than parallel.</p>
        /// <p>If you specify <code>TotalSegments</code>, you must also specify <code>Segment</code>.</p>
        pub fn total_segments(mut self, inp: i32) -> Self {
            self.inner = self.inner.total_segments(inp);
            self
        }
        /// <p>For a parallel <code>Scan</code> request, <code>TotalSegments</code> represents the total number of
        /// segments into which the <code>Scan</code> operation will be divided. The value of
        /// <code>TotalSegments</code> corresponds to the number of application workers that will perform the
        /// parallel scan. For example, if you want to use four application threads to scan a table or an index,
        /// specify a <code>TotalSegments</code> value of 4.</p>
        /// <p>The value for <code>TotalSegments</code> must be greater than or equal to 1, and less than or equal
        /// to 1000000. If you specify a <code>TotalSegments</code> value of 1, the <code>Scan</code> operation will
        /// be sequential rather than parallel.</p>
        /// <p>If you specify <code>TotalSegments</code>, you must also specify <code>Segment</code>.</p>
        pub fn set_total_segments(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_total_segments(input);
            self
        }
        /// <p>For a parallel <code>Scan</code> request, <code>Segment</code> identifies an individual segment to be
        /// scanned by an application worker.</p>
        /// <p>Segment IDs are zero-based, so the first segment is always 0. For example, if you want to
        /// use four application threads to scan a table or an index, then the first thread specifies a <code>Segment</code> value
        /// of 0, the second thread specifies 1, and so on.</p>
        /// <p>The value of <code>LastEvaluatedKey</code> returned from a parallel <code>Scan</code> request must be
        /// used as <code>ExclusiveStartKey</code> with the same segment ID in a subsequent <code>Scan</code>
        /// operation.</p>
        /// <p>The value for <code>Segment</code> must be greater than or equal to 0, and less than the value
        /// provided for <code>TotalSegments</code>.</p>
        /// <p>If you provide <code>Segment</code>, you must also provide <code>TotalSegments</code>.</p>
        pub fn segment(mut self, inp: i32) -> Self {
            self.inner = self.inner.segment(inp);
            self
        }
        /// <p>For a parallel <code>Scan</code> request, <code>Segment</code> identifies an individual segment to be
        /// scanned by an application worker.</p>
        /// <p>Segment IDs are zero-based, so the first segment is always 0. For example, if you want to
        /// use four application threads to scan a table or an index, then the first thread specifies a <code>Segment</code> value
        /// of 0, the second thread specifies 1, and so on.</p>
        /// <p>The value of <code>LastEvaluatedKey</code> returned from a parallel <code>Scan</code> request must be
        /// used as <code>ExclusiveStartKey</code> with the same segment ID in a subsequent <code>Scan</code>
        /// operation.</p>
        /// <p>The value for <code>Segment</code> must be greater than or equal to 0, and less than the value
        /// provided for <code>TotalSegments</code>.</p>
        /// <p>If you provide <code>Segment</code>, you must also provide <code>TotalSegments</code>.</p>
        pub fn set_segment(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_segment(input);
            self
        }
        /// <p>A string that identifies one or more attributes to retrieve from the specified table or index. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.</p>
        /// <p>If no attribute names are specified, then all attributes will be returned. If any of the requested attributes are not found, they will not appear in the result.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn projection_expression(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.projection_expression(inp);
            self
        }
        /// <p>A string that identifies one or more attributes to retrieve from the specified table or index. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.</p>
        /// <p>If no attribute names are specified, then all attributes will be returned. If any of the requested attributes are not found, they will not appear in the result.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_projection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_projection_expression(input);
            self
        }
        /// <p>A string that contains conditions that DynamoDB applies after the <code>Scan</code> operation, but
        /// before the data is returned to you. Items that do not satisfy the <code>FilterExpression</code>
        /// criteria are not returned.</p>
        /// <note>
        /// <p>A <code>FilterExpression</code> is applied after the items have already been read; the process of
        /// filtering does not consume any additional read capacity units.</p>
        /// </note>
        /// <p>For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults">Filter Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn filter_expression(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_expression(inp);
            self
        }
        /// <p>A string that contains conditions that DynamoDB applies after the <code>Scan</code> operation, but
        /// before the data is returned to you. Items that do not satisfy the <code>FilterExpression</code>
        /// criteria are not returned.</p>
        /// <note>
        /// <p>A <code>FilterExpression</code> is applied after the items have already been read; the process of
        /// filtering does not consume any additional read capacity units.</p>
        /// </note>
        /// <p>For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults">Filter Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_filter_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_filter_expression(input);
            self
        }
        /// Adds a key-value pair to `ExpressionAttributeNames`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_names`](Self::set_expression_attribute_names).
        ///
        /// <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p>
        /// </li>
        /// <li>
        /// <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p>
        /// </li>
        /// <li>
        /// <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p>
        /// </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Percentile</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>{"#P":"Percentile"}</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#P = :val</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>
        /// </note>
        /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn expression_attribute_names(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.expression_attribute_names(k, v);
            self
        }
        /// <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p>
        /// </li>
        /// <li>
        /// <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p>
        /// </li>
        /// <li>
        /// <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p>
        /// </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Percentile</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>{"#P":"Percentile"}</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#P = :val</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>
        /// </note>
        /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_expression_attribute_names(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_expression_attribute_names(input);
            self
        }
        /// Adds a key-value pair to `ExpressionAttributeValues`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_values`](Self::set_expression_attribute_values).
        ///
        /// <p>One or more values that can be substituted in an expression.</p>
        /// <p>Use the <b>:</b> (colon) character in an expression to
        /// dereference an attribute value. For example, suppose that you wanted to check whether
        /// the value of the <code>ProductStatus</code> attribute was one of the following: </p>
        /// <p>
        /// <code>Available | Backordered | Discontinued</code>
        /// </p>
        /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as follows:</p>
        /// <p>
        /// <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
        /// </p>
        /// <p>You could then use these values in an expression, such as this:</p>
        /// <p>
        /// <code>ProductStatus IN (:avail, :back, :disc)</code>
        /// </p>
        /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn expression_attribute_values(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeValue>,
        ) -> Self {
            self.inner = self.inner.expression_attribute_values(k, v);
            self
        }
        /// <p>One or more values that can be substituted in an expression.</p>
        /// <p>Use the <b>:</b> (colon) character in an expression to
        /// dereference an attribute value. For example, suppose that you wanted to check whether
        /// the value of the <code>ProductStatus</code> attribute was one of the following: </p>
        /// <p>
        /// <code>Available | Backordered | Discontinued</code>
        /// </p>
        /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as follows:</p>
        /// <p>
        /// <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
        /// </p>
        /// <p>You could then use these values in an expression, such as this:</p>
        /// <p>
        /// <code>ProductStatus IN (:avail, :back, :disc)</code>
        /// </p>
        /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_expression_attribute_values(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_expression_attribute_values(input);
            self
        }
        /// <p>A Boolean value that determines the read consistency model during the scan:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>ConsistentRead</code> is <code>false</code>, then the data returned from
        /// <code>Scan</code> might not contain the results from other recently
        /// completed write operations (<code>PutItem</code>, <code>UpdateItem</code>, or
        /// <code>DeleteItem</code>).</p>
        /// </li>
        /// <li>
        /// <p>If <code>ConsistentRead</code> is <code>true</code>, then all of the write operations that completed before the <code>Scan</code> began are guaranteed to be contained in the <code>Scan</code> response.</p>
        /// </li>
        /// </ul>
        /// <p>The default setting for <code>ConsistentRead</code> is <code>false</code>.</p>
        /// <p>The <code>ConsistentRead</code> parameter is not supported on global secondary indexes. If you scan a global secondary index with <code>ConsistentRead</code> set to true, you will receive a <code>ValidationException</code>.</p>
        pub fn consistent_read(mut self, inp: bool) -> Self {
            self.inner = self.inner.consistent_read(inp);
            self
        }
        /// <p>A Boolean value that determines the read consistency model during the scan:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>ConsistentRead</code> is <code>false</code>, then the data returned from
        /// <code>Scan</code> might not contain the results from other recently
        /// completed write operations (<code>PutItem</code>, <code>UpdateItem</code>, or
        /// <code>DeleteItem</code>).</p>
        /// </li>
        /// <li>
        /// <p>If <code>ConsistentRead</code> is <code>true</code>, then all of the write operations that completed before the <code>Scan</code> began are guaranteed to be contained in the <code>Scan</code> response.</p>
        /// </li>
        /// </ul>
        /// <p>The default setting for <code>ConsistentRead</code> is <code>false</code>.</p>
        /// <p>The <code>ConsistentRead</code> parameter is not supported on global secondary indexes. If you scan a global secondary index with <code>ConsistentRead</code> set to true, you will receive a <code>ValidationException</code>.</p>
        pub fn set_consistent_read(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_consistent_read(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Associate a set of tags with an Amazon DynamoDB resource. You can then activate these
    /// user-defined tags so that they appear on the Billing and Cost Management console for
    /// cost allocation tracking. You can call TagResource up to five times per second, per
    /// account. </p>
    /// <p>For an overview on tagging DynamoDB resources, see
    /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for DynamoDB</a>
    /// in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifies the Amazon DynamoDB resource to which tags should be added. This value is an Amazon Resource Name (ARN).</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>Identifies the Amazon DynamoDB resource to which tags should be added. This value is an Amazon Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the Amazon DynamoDB resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be assigned to the Amazon DynamoDB resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TransactGetItems`.
    ///
    /// <p>
    /// <code>TransactGetItems</code> is a synchronous operation that atomically retrieves
    /// multiple items from one or more tables (but not from indexes) in a single account and
    /// Region. A <code>TransactGetItems</code> call can contain up to 25
    /// <code>TransactGetItem</code> objects, each of which contains a <code>Get</code>
    /// structure that specifies an item to retrieve from a table in the account and Region. A
    /// call to <code>TransactGetItems</code> cannot retrieve items from tables in more than one
    /// AWS account or Region. The aggregate size of the items in the transaction cannot exceed
    /// 4 MB.</p>
    /// <p>DynamoDB rejects the entire <code>TransactGetItems</code> request if any of the following is true:</p>
    /// <ul>
    /// <li>
    /// <p>A conflicting operation is in the process of updating an
    /// item to be read.</p>
    /// </li>
    /// <li>
    /// <p>There is insufficient provisioned capacity for the transaction
    /// to be completed.</p>
    /// </li>
    /// <li>
    /// <p>There is a user error, such as an invalid data format.</p>
    /// </li>
    /// <li>
    /// <p>The aggregate size of the items in the transaction cannot exceed 4 MB.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct TransactGetItems<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::transact_get_items_input::Builder,
    }
    impl<C, M, R> TransactGetItems<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TransactGetItems`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TransactGetItemsOutput,
            aws_smithy_http::result::SdkError<crate::error::TransactGetItemsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TransactGetItemsInputOperationOutputAlias,
                crate::output::TransactGetItemsOutput,
                crate::error::TransactGetItemsError,
                crate::input::TransactGetItemsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TransactItems`.
        ///
        /// To override the contents of this collection use [`set_transact_items`](Self::set_transact_items).
        ///
        /// <p>An ordered array of up to 25 <code>TransactGetItem</code> objects,
        /// each of which contains a <code>Get</code> structure.</p>
        pub fn transact_items(mut self, inp: impl Into<crate::model::TransactGetItem>) -> Self {
            self.inner = self.inner.transact_items(inp);
            self
        }
        /// <p>An ordered array of up to 25 <code>TransactGetItem</code> objects,
        /// each of which contains a <code>Get</code> structure.</p>
        pub fn set_transact_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TransactGetItem>>,
        ) -> Self {
            self.inner = self.inner.set_transact_items(input);
            self
        }
        /// <p>A value of <code>TOTAL</code> causes consumed capacity information
        /// to be returned, and a value of <code>NONE</code> prevents that information
        /// from being returned. No other value is valid.</p>
        pub fn return_consumed_capacity(
            mut self,
            inp: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.inner = self.inner.return_consumed_capacity(inp);
            self
        }
        /// <p>A value of <code>TOTAL</code> causes consumed capacity information
        /// to be returned, and a value of <code>NONE</code> prevents that information
        /// from being returned. No other value is valid.</p>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.inner = self.inner.set_return_consumed_capacity(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TransactWriteItems`.
    ///
    /// <p>
    /// <code>TransactWriteItems</code> is a synchronous write operation that groups up to 25
    /// action requests. These actions can target items in different tables, but not in
    /// different AWS accounts or Regions, and no two actions can target the same item. For
    /// example, you cannot both <code>ConditionCheck</code> and <code>Update</code> the same
    /// item. The aggregate size of the items in the transaction cannot exceed 4 MB.</p>
    ///
    /// <p>The actions are completed atomically so that either all of
    /// them succeed, or all of them fail. They are defined by the following objects:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Put</code>     Initiates a <code>PutItem</code> operation to write a new
    /// item. This structure specifies the primary key of the item to be written, the
    /// name of the table to write it in, an optional condition expression that must be
    /// satisfied for the write to succeed, a list of the item's attributes, and a field
    /// indicating whether to retrieve the item's attributes if the condition is not
    /// met.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Update</code>     Initiates an <code>UpdateItem</code> operation to
    /// update an existing item. This structure specifies the primary key of the item to
    /// be updated, the name of the table where it resides, an optional condition
    /// expression that must be satisfied for the update to succeed, an expression that
    /// defines one or more attributes to be updated, and a field indicating whether to
    /// retrieve the item's attributes if the condition is not met.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Delete</code>     Initiates a <code>DeleteItem</code> operation to
    /// delete an existing item. This structure specifies the primary key of the item to
    /// be deleted, the name of the table where it resides, an optional condition
    /// expression that must be satisfied for the deletion to succeed, and a field
    /// indicating whether to retrieve the item's attributes if the condition is not
    /// met.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ConditionCheck</code>     Applies a condition to an item that is not
    /// being modified by the transaction. This structure specifies the primary key of
    /// the item to be checked, the name of the table where it resides, a condition
    /// expression that must be satisfied for the transaction to succeed, and a field
    /// indicating whether to retrieve the item's attributes if the condition is not
    /// met.</p>
    /// </li>
    /// </ul>
    ///
    /// <p>DynamoDB rejects the entire <code>TransactWriteItems</code> request if any of the following is true:</p>
    /// <ul>
    /// <li>
    /// <p>A condition in one of the condition expressions is not met.</p>
    /// </li>
    /// <li>
    /// <p>An ongoing operation is in the process of updating the same
    /// item.</p>
    /// </li>
    /// <li>
    /// <p>There is insufficient provisioned capacity for the transaction
    /// to be completed.</p>
    /// </li>
    /// <li>
    /// <p>An item size becomes too large (bigger than 400 KB), a local secondary index (LSI) becomes too
    /// large, or a similar validation error occurs because of changes made by the
    /// transaction.</p>
    /// </li>
    /// <li>
    /// <p>The aggregate size of the items in the transaction exceeds 4 MB.</p>
    /// </li>
    /// <li>
    /// <p>There  is a user error, such as an invalid data format.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct TransactWriteItems<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::transact_write_items_input::Builder,
    }
    impl<C, M, R> TransactWriteItems<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TransactWriteItems`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TransactWriteItemsOutput,
            aws_smithy_http::result::SdkError<crate::error::TransactWriteItemsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TransactWriteItemsInputOperationOutputAlias,
                crate::output::TransactWriteItemsOutput,
                crate::error::TransactWriteItemsError,
                crate::input::TransactWriteItemsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TransactItems`.
        ///
        /// To override the contents of this collection use [`set_transact_items`](Self::set_transact_items).
        ///
        /// <p>An ordered array of up to 25 <code>TransactWriteItem</code> objects, each of which
        /// contains a <code>ConditionCheck</code>, <code>Put</code>, <code>Update</code>, or
        /// <code>Delete</code> object. These can operate on items in different tables, but the
        /// tables must reside in the same AWS account and Region, and no two of them can operate on
        /// the same item. </p>
        pub fn transact_items(mut self, inp: impl Into<crate::model::TransactWriteItem>) -> Self {
            self.inner = self.inner.transact_items(inp);
            self
        }
        /// <p>An ordered array of up to 25 <code>TransactWriteItem</code> objects, each of which
        /// contains a <code>ConditionCheck</code>, <code>Put</code>, <code>Update</code>, or
        /// <code>Delete</code> object. These can operate on items in different tables, but the
        /// tables must reside in the same AWS account and Region, and no two of them can operate on
        /// the same item. </p>
        pub fn set_transact_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TransactWriteItem>>,
        ) -> Self {
            self.inner = self.inner.set_transact_items(input);
            self
        }
        /// <p>Determines the level of detail about provisioned throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all.  In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p>
        /// </li>
        /// </ul>
        pub fn return_consumed_capacity(
            mut self,
            inp: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.inner = self.inner.return_consumed_capacity(inp);
            self
        }
        /// <p>Determines the level of detail about provisioned throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all.  In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p>
        /// </li>
        /// </ul>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.inner = self.inner.set_return_consumed_capacity(input);
            self
        }
        /// <p>Determines whether item collection metrics are returned. If set to
        /// <code>SIZE</code>, the response includes statistics about item collections (if any), that
        /// were modified during the operation and are returned in the response.
        /// If set to <code>NONE</code> (the default), no statistics are returned.
        /// </p>
        pub fn return_item_collection_metrics(
            mut self,
            inp: crate::model::ReturnItemCollectionMetrics,
        ) -> Self {
            self.inner = self.inner.return_item_collection_metrics(inp);
            self
        }
        /// <p>Determines whether item collection metrics are returned. If set to
        /// <code>SIZE</code>, the response includes statistics about item collections (if any), that
        /// were modified during the operation and are returned in the response.
        /// If set to <code>NONE</code> (the default), no statistics are returned.
        /// </p>
        pub fn set_return_item_collection_metrics(
            mut self,
            input: std::option::Option<crate::model::ReturnItemCollectionMetrics>,
        ) -> Self {
            self.inner = self.inner.set_return_item_collection_metrics(input);
            self
        }
        /// <p>Providing a <code>ClientRequestToken</code> makes the call to <code>TransactWriteItems</code>
        /// idempotent, meaning that multiple identical calls have the same effect as one single call.</p>
        /// <p>Although multiple identical calls using the same client request token produce the same
        /// result on the server (no side effects), the responses to the calls might not be the
        /// same. If the <code>ReturnConsumedCapacity></code> parameter is set, then the initial
        /// <code>TransactWriteItems</code> call returns the amount of write capacity units
        /// consumed in making the changes. Subsequent <code>TransactWriteItems</code> calls with
        /// the same client token return the number of read capacity units consumed in reading the
        /// item.</p>
        /// <p>A client request token is valid for 10 minutes after the first request that uses it is
        /// completed. After 10 minutes, any request with the same client token is treated as a new
        /// request. Do not resubmit the same request with the same client token for more than 10
        /// minutes, or the result might not be idempotent.</p>
        /// <p>If you submit a request with the same client token but a change in other parameters
        /// within the 10-minute idempotency window, DynamoDB returns an
        /// <code>IdempotentParameterMismatch</code> exception.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>Providing a <code>ClientRequestToken</code> makes the call to <code>TransactWriteItems</code>
        /// idempotent, meaning that multiple identical calls have the same effect as one single call.</p>
        /// <p>Although multiple identical calls using the same client request token produce the same
        /// result on the server (no side effects), the responses to the calls might not be the
        /// same. If the <code>ReturnConsumedCapacity></code> parameter is set, then the initial
        /// <code>TransactWriteItems</code> call returns the amount of write capacity units
        /// consumed in making the changes. Subsequent <code>TransactWriteItems</code> calls with
        /// the same client token return the number of read capacity units consumed in reading the
        /// item.</p>
        /// <p>A client request token is valid for 10 minutes after the first request that uses it is
        /// completed. After 10 minutes, any request with the same client token is treated as a new
        /// request. Do not resubmit the same request with the same client token for more than 10
        /// minutes, or the result might not be idempotent.</p>
        /// <p>If you submit a request with the same client token but a change in other parameters
        /// within the 10-minute idempotency window, DynamoDB returns an
        /// <code>IdempotentParameterMismatch</code> exception.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the association of tags from an Amazon DynamoDB resource. You can call
    /// <code>UntagResource</code> up to five times per second, per account. </p>
    /// <p>For an overview on tagging DynamoDB resources, see
    /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for DynamoDB</a>
    /// in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DynamoDB resource that the tags will be removed from. This value is an Amazon
        /// Resource Name (ARN).</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The DynamoDB resource that the tags will be removed from. This value is an Amazon
        /// Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag keys. Existing tags of the resource whose keys are members of this list
        /// will be removed from the DynamoDB resource.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A list of tag keys. Existing tags of the resource whose keys are members of this list
        /// will be removed from the DynamoDB resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContinuousBackups`.
    ///
    /// <p>
    /// <code>UpdateContinuousBackups</code> enables or disables point in time recovery for the specified table.
    /// A successful <code>UpdateContinuousBackups</code> call returns the current <code>ContinuousBackupsDescription</code>.
    /// Continuous backups are <code>ENABLED</code> on all tables at table creation.
    /// If point in time recovery is enabled, <code>PointInTimeRecoveryStatus</code> will be set to ENABLED.</p>
    /// <p>
    /// Once continuous backups and point in time recovery are enabled, you can restore to any point in time within
    /// <code>EarliestRestorableDateTime</code> and <code>LatestRestorableDateTime</code>.
    /// </p>
    /// <p>
    /// <code>LatestRestorableDateTime</code> is typically 5 minutes before the current time.
    /// You can restore your table to any point in time during the last 35 days. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateContinuousBackups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_continuous_backups_input::Builder,
    }
    impl<C, M, R> UpdateContinuousBackups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateContinuousBackups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContinuousBackupsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContinuousBackupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateContinuousBackupsInputOperationOutputAlias,
                crate::output::UpdateContinuousBackupsOutput,
                crate::error::UpdateContinuousBackupsError,
                crate::input::UpdateContinuousBackupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the table.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>Represents the settings used to enable point in time recovery.</p>
        pub fn point_in_time_recovery_specification(
            mut self,
            inp: crate::model::PointInTimeRecoverySpecification,
        ) -> Self {
            self.inner = self.inner.point_in_time_recovery_specification(inp);
            self
        }
        /// <p>Represents the settings used to enable point in time recovery.</p>
        pub fn set_point_in_time_recovery_specification(
            mut self,
            input: std::option::Option<crate::model::PointInTimeRecoverySpecification>,
        ) -> Self {
            self.inner = self.inner.set_point_in_time_recovery_specification(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContributorInsights`.
    ///
    /// <p>Updates the status for contributor insights for a specific table or index.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateContributorInsights<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_contributor_insights_input::Builder,
    }
    impl<C, M, R> UpdateContributorInsights<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateContributorInsights`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContributorInsightsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContributorInsightsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateContributorInsightsInputOperationOutputAlias,
                crate::output::UpdateContributorInsightsOutput,
                crate::error::UpdateContributorInsightsError,
                crate::input::UpdateContributorInsightsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the table.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>The global secondary index name, if applicable.</p>
        pub fn index_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(inp);
            self
        }
        /// <p>The global secondary index name, if applicable.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
        /// <p>Represents the contributor insights action.</p>
        pub fn contributor_insights_action(
            mut self,
            inp: crate::model::ContributorInsightsAction,
        ) -> Self {
            self.inner = self.inner.contributor_insights_action(inp);
            self
        }
        /// <p>Represents the contributor insights action.</p>
        pub fn set_contributor_insights_action(
            mut self,
            input: std::option::Option<crate::model::ContributorInsightsAction>,
        ) -> Self {
            self.inner = self.inner.set_contributor_insights_action(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGlobalTable`.
    ///
    /// <p>Adds or removes replicas in the specified global table. The global table must already
    /// exist to be able to use this operation. Any replica to be added must be empty, have the
    /// same name as the global table, have the same key schema, have DynamoDB Streams enabled,
    /// and have the same provisioned and maximum write capacity units.</p>
    /// <note>
    /// <p>Although you can use <code>UpdateGlobalTable</code> to add replicas and remove replicas in
    /// a single request, for simplicity we recommend that you issue separate requests for
    /// adding or removing replicas.</p>
    /// </note>
    /// <p>
    /// If global secondary indexes are specified, then the following conditions must also be met:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The global secondary indexes must have the same name.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The global secondary indexes must have the same hash key and sort key (if present).
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The global secondary indexes must have the same provisioned and maximum write capacity units.
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct UpdateGlobalTable<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_global_table_input::Builder,
    }
    impl<C, M, R> UpdateGlobalTable<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateGlobalTable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGlobalTableOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGlobalTableError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateGlobalTableInputOperationOutputAlias,
                crate::output::UpdateGlobalTableOutput,
                crate::error::UpdateGlobalTableError,
                crate::input::UpdateGlobalTableInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The global table name.</p>
        pub fn global_table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_table_name(inp);
            self
        }
        /// <p>The global table name.</p>
        pub fn set_global_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_table_name(input);
            self
        }
        /// Appends an item to `ReplicaUpdates`.
        ///
        /// To override the contents of this collection use [`set_replica_updates`](Self::set_replica_updates).
        ///
        /// <p>A list of Regions that should be added or removed from the global table.</p>
        pub fn replica_updates(mut self, inp: impl Into<crate::model::ReplicaUpdate>) -> Self {
            self.inner = self.inner.replica_updates(inp);
            self
        }
        /// <p>A list of Regions that should be added or removed from the global table.</p>
        pub fn set_replica_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicaUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_replica_updates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGlobalTableSettings`.
    ///
    /// <p>Updates settings for a global table.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateGlobalTableSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_global_table_settings_input::Builder,
    }
    impl<C, M, R> UpdateGlobalTableSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateGlobalTableSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGlobalTableSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGlobalTableSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateGlobalTableSettingsInputOperationOutputAlias,
                crate::output::UpdateGlobalTableSettingsOutput,
                crate::error::UpdateGlobalTableSettingsError,
                crate::input::UpdateGlobalTableSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the global table</p>
        pub fn global_table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_table_name(inp);
            self
        }
        /// <p>The name of the global table</p>
        pub fn set_global_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_table_name(input);
            self
        }
        /// <p>The billing mode of the global table. If <code>GlobalTableBillingMode</code> is not specified, the global table defaults to <code>PROVISIONED</code> capacity billing mode.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual">Provisioned Mode</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand">On-Demand Mode</a>.
        /// </p>
        /// </li>
        /// </ul>
        pub fn global_table_billing_mode(mut self, inp: crate::model::BillingMode) -> Self {
            self.inner = self.inner.global_table_billing_mode(inp);
            self
        }
        /// <p>The billing mode of the global table. If <code>GlobalTableBillingMode</code> is not specified, the global table defaults to <code>PROVISIONED</code> capacity billing mode.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual">Provisioned Mode</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand">On-Demand Mode</a>.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_global_table_billing_mode(
            mut self,
            input: std::option::Option<crate::model::BillingMode>,
        ) -> Self {
            self.inner = self.inner.set_global_table_billing_mode(input);
            self
        }
        /// <p>The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException.</code>
        /// </p>
        pub fn global_table_provisioned_write_capacity_units(mut self, inp: i64) -> Self {
            self.inner = self
                .inner
                .global_table_provisioned_write_capacity_units(inp);
            self
        }
        /// <p>The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException.</code>
        /// </p>
        pub fn set_global_table_provisioned_write_capacity_units(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.inner = self
                .inner
                .set_global_table_provisioned_write_capacity_units(input);
            self
        }
        /// <p>Auto scaling settings for managing provisioned write capacity for the global
        /// table.</p>
        pub fn global_table_provisioned_write_capacity_auto_scaling_settings_update(
            mut self,
            inp: crate::model::AutoScalingSettingsUpdate,
        ) -> Self {
            self.inner = self
                .inner
                .global_table_provisioned_write_capacity_auto_scaling_settings_update(inp);
            self
        }
        /// <p>Auto scaling settings for managing provisioned write capacity for the global
        /// table.</p>
        pub fn set_global_table_provisioned_write_capacity_auto_scaling_settings_update(
            mut self,
            input: std::option::Option<crate::model::AutoScalingSettingsUpdate>,
        ) -> Self {
            self.inner = self
                .inner
                .set_global_table_provisioned_write_capacity_auto_scaling_settings_update(input);
            self
        }
        /// Appends an item to `GlobalTableGlobalSecondaryIndexSettingsUpdate`.
        ///
        /// To override the contents of this collection use [`set_global_table_global_secondary_index_settings_update`](Self::set_global_table_global_secondary_index_settings_update).
        ///
        /// <p>Represents the settings of a global secondary index for a global table that will be modified.</p>
        pub fn global_table_global_secondary_index_settings_update(
            mut self,
            inp: impl Into<crate::model::GlobalTableGlobalSecondaryIndexSettingsUpdate>,
        ) -> Self {
            self.inner = self
                .inner
                .global_table_global_secondary_index_settings_update(inp);
            self
        }
        /// <p>Represents the settings of a global secondary index for a global table that will be modified.</p>
        pub fn set_global_table_global_secondary_index_settings_update(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::GlobalTableGlobalSecondaryIndexSettingsUpdate>,
            >,
        ) -> Self {
            self.inner = self
                .inner
                .set_global_table_global_secondary_index_settings_update(input);
            self
        }
        /// Appends an item to `ReplicaSettingsUpdate`.
        ///
        /// To override the contents of this collection use [`set_replica_settings_update`](Self::set_replica_settings_update).
        ///
        /// <p>Represents the settings for a global table in a Region that will be modified.</p>
        pub fn replica_settings_update(
            mut self,
            inp: impl Into<crate::model::ReplicaSettingsUpdate>,
        ) -> Self {
            self.inner = self.inner.replica_settings_update(inp);
            self
        }
        /// <p>Represents the settings for a global table in a Region that will be modified.</p>
        pub fn set_replica_settings_update(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicaSettingsUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_replica_settings_update(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateItem`.
    ///
    /// <p>Edits an existing item's attributes, or adds a new item to the table if it does not already exist. You can put, delete, or add attribute values. You can also perform a conditional update on an existing item (insert a new attribute name-value pair if it doesn't exist, or replace an existing name-value pair if it has certain expected attribute values).</p>
    /// <p>You can also return the item's attribute values in the same <code>UpdateItem</code>
    /// operation using the <code>ReturnValues</code> parameter.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateItem<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_item_input::Builder,
    }
    impl<C, M, R> UpdateItem<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateItem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateItemOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateItemError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateItemInputOperationOutputAlias,
                crate::output::UpdateItemOutput,
                crate::error::UpdateItemError,
                crate::input::UpdateItemInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the table containing the item to update.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the table containing the item to update.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// Adds a key-value pair to `Key`.
        ///
        /// To override the contents of this collection use [`set_key`](Self::set_key).
        ///
        /// <p>The primary key of the item to be updated. Each element consists of an attribute name and a value for that attribute.</p>
        /// <p>For the primary key, you must provide all of the attributes. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide values for both the partition key and the sort key.</p>
        pub fn key(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeValue>,
        ) -> Self {
            self.inner = self.inner.key(k, v);
            self
        }
        /// <p>The primary key of the item to be updated. Each element consists of an attribute name and a value for that attribute.</p>
        /// <p>For the primary key, you must provide all of the attributes. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide values for both the partition key and the sort key.</p>
        pub fn set_key(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_key(input);
            self
        }
        /// Adds a key-value pair to `AttributeUpdates`.
        ///
        /// To override the contents of this collection use [`set_attribute_updates`](Self::set_attribute_updates).
        ///
        /// <p>This is a legacy parameter.  Use <code>UpdateExpression</code> instead.   For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributeUpdates.html">AttributeUpdates</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn attribute_updates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeValueUpdate>,
        ) -> Self {
            self.inner = self.inner.attribute_updates(k, v);
            self
        }
        /// <p>This is a legacy parameter.  Use <code>UpdateExpression</code> instead.   For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributeUpdates.html">AttributeUpdates</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_attribute_updates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValueUpdate>,
            >,
        ) -> Self {
            self.inner = self.inner.set_attribute_updates(input);
            self
        }
        /// Adds a key-value pair to `Expected`.
        ///
        /// To override the contents of this collection use [`set_expected`](Self::set_expected).
        ///
        /// <p>This is a legacy parameter.  Use <code>ConditionExpression</code> instead.   For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html">Expected</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn expected(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ExpectedAttributeValue>,
        ) -> Self {
            self.inner = self.inner.expected(k, v);
            self
        }
        /// <p>This is a legacy parameter.  Use <code>ConditionExpression</code> instead.   For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html">Expected</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_expected(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::ExpectedAttributeValue,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_expected(input);
            self
        }
        /// <p>This is a legacy parameter.  Use <code>ConditionExpression</code> instead.   For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn conditional_operator(mut self, inp: crate::model::ConditionalOperator) -> Self {
            self.inner = self.inner.conditional_operator(inp);
            self
        }
        /// <p>This is a legacy parameter.  Use <code>ConditionExpression</code> instead.   For more information, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_conditional_operator(
            mut self,
            input: std::option::Option<crate::model::ConditionalOperator>,
        ) -> Self {
            self.inner = self.inner.set_conditional_operator(input);
            self
        }
        /// <p>Use <code>ReturnValues</code> if you want to get the item attributes as they appear
        /// before or after they are updated. For <code>UpdateItem</code>, the valid values
        /// are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is
        /// <code>NONE</code>, then nothing is returned. (This setting is the default for
        /// <code>ReturnValues</code>.)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL_OLD</code> - Returns all of the attributes of the item, as they appeared before the UpdateItem operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATED_OLD</code> - Returns only the updated attributes, as they appeared before the UpdateItem operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL_NEW</code> - Returns all of the attributes of the item, as they appear after the UpdateItem operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATED_NEW</code> - Returns only the updated attributes, as they appear after the UpdateItem operation.</p>
        /// </li>
        /// </ul>
        /// <p>There is no additional cost associated with requesting a return value aside from the
        /// small network and processing overhead of receiving a larger response. No read capacity
        /// units are consumed.</p>
        /// <p>The values returned are strongly consistent.</p>
        pub fn return_values(mut self, inp: crate::model::ReturnValue) -> Self {
            self.inner = self.inner.return_values(inp);
            self
        }
        /// <p>Use <code>ReturnValues</code> if you want to get the item attributes as they appear
        /// before or after they are updated. For <code>UpdateItem</code>, the valid values
        /// are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is
        /// <code>NONE</code>, then nothing is returned. (This setting is the default for
        /// <code>ReturnValues</code>.)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL_OLD</code> - Returns all of the attributes of the item, as they appeared before the UpdateItem operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATED_OLD</code> - Returns only the updated attributes, as they appeared before the UpdateItem operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL_NEW</code> - Returns all of the attributes of the item, as they appear after the UpdateItem operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATED_NEW</code> - Returns only the updated attributes, as they appear after the UpdateItem operation.</p>
        /// </li>
        /// </ul>
        /// <p>There is no additional cost associated with requesting a return value aside from the
        /// small network and processing overhead of receiving a larger response. No read capacity
        /// units are consumed.</p>
        /// <p>The values returned are strongly consistent.</p>
        pub fn set_return_values(
            mut self,
            input: std::option::Option<crate::model::ReturnValue>,
        ) -> Self {
            self.inner = self.inner.set_return_values(input);
            self
        }
        /// <p>Determines the level of detail about provisioned throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all.  In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p>
        /// </li>
        /// </ul>
        pub fn return_consumed_capacity(
            mut self,
            inp: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.inner = self.inner.return_consumed_capacity(inp);
            self
        }
        /// <p>Determines the level of detail about provisioned throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all.  In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p>
        /// </li>
        /// </ul>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.inner = self.inner.set_return_consumed_capacity(input);
            self
        }
        /// <p>Determines whether item collection metrics are returned.  If set to <code>SIZE</code>, the response includes statistics about item collections, if any, that were modified during
        /// the operation are returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.</p>
        pub fn return_item_collection_metrics(
            mut self,
            inp: crate::model::ReturnItemCollectionMetrics,
        ) -> Self {
            self.inner = self.inner.return_item_collection_metrics(inp);
            self
        }
        /// <p>Determines whether item collection metrics are returned.  If set to <code>SIZE</code>, the response includes statistics about item collections, if any, that were modified during
        /// the operation are returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.</p>
        pub fn set_return_item_collection_metrics(
            mut self,
            input: std::option::Option<crate::model::ReturnItemCollectionMetrics>,
        ) -> Self {
            self.inner = self.inner.set_return_item_collection_metrics(input);
            self
        }
        /// <p>An expression that defines one or more attributes to be updated, the action to be
        /// performed on them, and new values for them.</p>
        /// <p>The following action values are available for <code>UpdateExpression</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SET</code> - Adds one or more attributes and values to an item. If any of
        /// these attributes already exist, they are replaced by the new values. You can
        /// also use <code>SET</code> to add or subtract from an attribute that is of type
        /// Number. For example: <code>SET myNum = myNum + :val</code>
        /// </p>
        /// <p>
        /// <code>SET</code> supports the following functions:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>if_not_exists (path, operand)</code> - if the item does not contain an attribute at the specified path, then <code>if_not_exists</code> evaluates to operand; otherwise, it evaluates to path. You can use this function to avoid overwriting an attribute that may already be present in the item.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>list_append (operand, operand)</code> - evaluates to a list with a new element added to it. You can append the new element to the start or the end of the list by reversing the order of the operands.</p>
        /// </li>
        /// </ul>
        /// <p>These function names are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REMOVE</code> - Removes one or more attributes from an item.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ADD</code> - Adds the specified value to the item, if the attribute does not already exist. If the attribute does exist, then the behavior of
        /// <code>ADD</code> depends on the data type of the attribute:</p>
        /// <ul>
        /// <li>
        /// <p>If the existing attribute is a number, and if <code>Value</code> is also a number, then
        /// <code>Value</code> is mathematically added to the existing attribute. If <code>Value</code> is a
        /// negative number, then it is subtracted from the existing attribute.</p>
        /// <note>
        /// <p>If you use <code>ADD</code> to increment or decrement a number value for an item
        /// that doesn't exist before the update, DynamoDB uses <code>0</code> as the initial
        /// value.</p>
        /// <p>Similarly, if you use <code>ADD</code> for an existing item to increment
        /// or decrement an attribute value that doesn't exist before the
        /// update, DynamoDB uses <code>0</code> as the initial value. For
        /// example, suppose that the item you want to update doesn't have an
        /// attribute named <code>itemcount</code>, but you decide to
        /// <code>ADD</code> the number <code>3</code> to this attribute
        /// anyway. DynamoDB will create the <code>itemcount</code> attribute,
        /// set its initial value to <code>0</code>, and finally add
        /// <code>3</code> to it. The result will be a new
        /// <code>itemcount</code> attribute in the item, with a value of
        /// <code>3</code>.</p>
        /// </note>
        /// </li>
        /// <li>
        /// <p>If the existing data type is a set and if <code>Value</code> is also a set, then
        /// <code>Value</code> is added to the existing set. For example, if the attribute value is the set
        /// <code>[1,2]</code>, and the <code>ADD</code> action specified <code>[3]</code>, then
        /// the final attribute value is <code>[1,2,3]</code>. An error occurs if an <code>ADD</code>
        /// action is specified for a set attribute and the attribute type specified does not
        /// match the existing set type. </p>
        /// <p>Both sets must have the same primitive data type. For example, if the existing data
        /// type is a set of strings, the <code>Value</code> must also be a set of strings.</p>
        /// </li>
        /// </ul>
        /// <important>
        /// <p>The <code>ADD</code> action only supports Number and set data types. In addition,
        /// <code>ADD</code> can only be used on top-level attributes, not nested attributes.</p>
        /// </important>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE</code> - Deletes an element from a set.</p>
        /// <p>If a set of values is specified, then those values are subtracted from the old
        /// set. For example, if the attribute value was the set <code>[a,b,c]</code> and the
        /// <code>DELETE</code> action specifies <code>[a,c]</code>, then the final attribute value
        /// is <code>[b]</code>. Specifying an empty set is an error.</p>
        /// <important>
        /// <p>The <code>DELETE</code> action only supports set data types. In addition,
        /// <code>DELETE</code> can only be used on top-level attributes, not nested attributes.</p>
        /// </important>
        ///
        /// </li>
        /// </ul>
        /// <p>You can have many actions in a single expression, such as the following: <code>SET a=:value1,
        /// b=:value2 DELETE :value3, :value4, :value5</code>
        /// </p>
        /// <p>For more information on update expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Modifying.html">Modifying Items and Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn update_expression(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.update_expression(inp);
            self
        }
        /// <p>An expression that defines one or more attributes to be updated, the action to be
        /// performed on them, and new values for them.</p>
        /// <p>The following action values are available for <code>UpdateExpression</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SET</code> - Adds one or more attributes and values to an item. If any of
        /// these attributes already exist, they are replaced by the new values. You can
        /// also use <code>SET</code> to add or subtract from an attribute that is of type
        /// Number. For example: <code>SET myNum = myNum + :val</code>
        /// </p>
        /// <p>
        /// <code>SET</code> supports the following functions:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>if_not_exists (path, operand)</code> - if the item does not contain an attribute at the specified path, then <code>if_not_exists</code> evaluates to operand; otherwise, it evaluates to path. You can use this function to avoid overwriting an attribute that may already be present in the item.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>list_append (operand, operand)</code> - evaluates to a list with a new element added to it. You can append the new element to the start or the end of the list by reversing the order of the operands.</p>
        /// </li>
        /// </ul>
        /// <p>These function names are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REMOVE</code> - Removes one or more attributes from an item.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ADD</code> - Adds the specified value to the item, if the attribute does not already exist. If the attribute does exist, then the behavior of
        /// <code>ADD</code> depends on the data type of the attribute:</p>
        /// <ul>
        /// <li>
        /// <p>If the existing attribute is a number, and if <code>Value</code> is also a number, then
        /// <code>Value</code> is mathematically added to the existing attribute. If <code>Value</code> is a
        /// negative number, then it is subtracted from the existing attribute.</p>
        /// <note>
        /// <p>If you use <code>ADD</code> to increment or decrement a number value for an item
        /// that doesn't exist before the update, DynamoDB uses <code>0</code> as the initial
        /// value.</p>
        /// <p>Similarly, if you use <code>ADD</code> for an existing item to increment
        /// or decrement an attribute value that doesn't exist before the
        /// update, DynamoDB uses <code>0</code> as the initial value. For
        /// example, suppose that the item you want to update doesn't have an
        /// attribute named <code>itemcount</code>, but you decide to
        /// <code>ADD</code> the number <code>3</code> to this attribute
        /// anyway. DynamoDB will create the <code>itemcount</code> attribute,
        /// set its initial value to <code>0</code>, and finally add
        /// <code>3</code> to it. The result will be a new
        /// <code>itemcount</code> attribute in the item, with a value of
        /// <code>3</code>.</p>
        /// </note>
        /// </li>
        /// <li>
        /// <p>If the existing data type is a set and if <code>Value</code> is also a set, then
        /// <code>Value</code> is added to the existing set. For example, if the attribute value is the set
        /// <code>[1,2]</code>, and the <code>ADD</code> action specified <code>[3]</code>, then
        /// the final attribute value is <code>[1,2,3]</code>. An error occurs if an <code>ADD</code>
        /// action is specified for a set attribute and the attribute type specified does not
        /// match the existing set type. </p>
        /// <p>Both sets must have the same primitive data type. For example, if the existing data
        /// type is a set of strings, the <code>Value</code> must also be a set of strings.</p>
        /// </li>
        /// </ul>
        /// <important>
        /// <p>The <code>ADD</code> action only supports Number and set data types. In addition,
        /// <code>ADD</code> can only be used on top-level attributes, not nested attributes.</p>
        /// </important>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE</code> - Deletes an element from a set.</p>
        /// <p>If a set of values is specified, then those values are subtracted from the old
        /// set. For example, if the attribute value was the set <code>[a,b,c]</code> and the
        /// <code>DELETE</code> action specifies <code>[a,c]</code>, then the final attribute value
        /// is <code>[b]</code>. Specifying an empty set is an error.</p>
        /// <important>
        /// <p>The <code>DELETE</code> action only supports set data types. In addition,
        /// <code>DELETE</code> can only be used on top-level attributes, not nested attributes.</p>
        /// </important>
        ///
        /// </li>
        /// </ul>
        /// <p>You can have many actions in a single expression, such as the following: <code>SET a=:value1,
        /// b=:value2 DELETE :value3, :value4, :value5</code>
        /// </p>
        /// <p>For more information on update expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Modifying.html">Modifying Items and Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_update_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_update_expression(input);
            self
        }
        /// <p>A condition that must be satisfied in order for a conditional update to succeed.</p>
        /// <p>An expression can contain any of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Functions: <code>attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size</code>
        /// </p>
        /// <p>These function names are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Comparison operators: <code>= | <> |
        /// < | > | <= | >= |
        /// BETWEEN | IN </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p> Logical operators: <code>AND | OR | NOT</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information about condition expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Specifying Conditions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn condition_expression(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.condition_expression(inp);
            self
        }
        /// <p>A condition that must be satisfied in order for a conditional update to succeed.</p>
        /// <p>An expression can contain any of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Functions: <code>attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size</code>
        /// </p>
        /// <p>These function names are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Comparison operators: <code>= | <> |
        /// < | > | <= | >= |
        /// BETWEEN | IN </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p> Logical operators: <code>AND | OR | NOT</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information about condition expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Specifying Conditions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_condition_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_condition_expression(input);
            self
        }
        /// Adds a key-value pair to `ExpressionAttributeNames`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_names`](Self::set_expression_attribute_names).
        ///
        /// <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p>
        /// </li>
        /// <li>
        /// <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p>
        /// </li>
        /// <li>
        /// <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p>
        /// </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Percentile</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly
        /// in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.) To work around this, you could specify the following for
        /// <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>{"#P":"Percentile"}</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#P = :val</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>
        /// </note>
        /// <p>For more information about expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn expression_attribute_names(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.expression_attribute_names(k, v);
            self
        }
        /// <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p>
        /// </li>
        /// <li>
        /// <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p>
        /// </li>
        /// <li>
        /// <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p>
        /// </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Percentile</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly
        /// in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.) To work around this, you could specify the following for
        /// <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>{"#P":"Percentile"}</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#P = :val</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>
        /// </note>
        /// <p>For more information about expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_expression_attribute_names(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_expression_attribute_names(input);
            self
        }
        /// Adds a key-value pair to `ExpressionAttributeValues`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_values`](Self::set_expression_attribute_values).
        ///
        /// <p>One or more values that can be substituted in an expression.</p>
        /// <p>Use the <b>:</b> (colon) character in an expression to
        /// dereference an attribute value. For example, suppose that you wanted to check whether
        /// the value of the <code>ProductStatus</code> attribute was one of the following: </p>
        /// <p>
        /// <code>Available | Backordered | Discontinued</code>
        /// </p>
        /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as follows:</p>
        /// <p>
        /// <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
        /// </p>
        /// <p>You could then use these values in an expression, such as this:</p>
        /// <p>
        /// <code>ProductStatus IN (:avail, :back, :disc)</code>
        /// </p>
        /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn expression_attribute_values(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeValue>,
        ) -> Self {
            self.inner = self.inner.expression_attribute_values(k, v);
            self
        }
        /// <p>One or more values that can be substituted in an expression.</p>
        /// <p>Use the <b>:</b> (colon) character in an expression to
        /// dereference an attribute value. For example, suppose that you wanted to check whether
        /// the value of the <code>ProductStatus</code> attribute was one of the following: </p>
        /// <p>
        /// <code>Available | Backordered | Discontinued</code>
        /// </p>
        /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as follows:</p>
        /// <p>
        /// <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
        /// </p>
        /// <p>You could then use these values in an expression, such as this:</p>
        /// <p>
        /// <code>ProductStatus IN (:avail, :back, :disc)</code>
        /// </p>
        /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_expression_attribute_values(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_expression_attribute_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTable`.
    ///
    /// <p>Modifies the provisioned throughput settings, global secondary indexes, or DynamoDB Streams settings for a given table.</p>
    /// <p>You can only perform one of the following operations at once:</p>
    /// <ul>
    /// <li>
    /// <p>Modify the provisioned throughput settings of the table.</p>
    /// </li>
    /// <li>
    /// <p>Enable or disable DynamoDB Streams on the table.</p>
    /// </li>
    /// <li>
    /// <p>Remove a global secondary index from the table.</p>
    /// </li>
    /// <li>
    /// <p>Create a new global secondary index on the table. After the index begins
    /// backfilling, you can use <code>UpdateTable</code> to perform other
    /// operations.</p>
    /// </li>
    /// </ul>
    /// <p>
    /// <code>UpdateTable</code> is an asynchronous operation; while it is executing, the table status
    /// changes from <code>ACTIVE</code> to <code>UPDATING</code>. While it is <code>UPDATING</code>,
    /// you cannot issue another <code>UpdateTable</code> request. When the table returns to the
    /// <code>ACTIVE</code> state, the <code>UpdateTable</code> operation is complete.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateTable<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_table_input::Builder,
    }
    impl<C, M, R> UpdateTable<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTableOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTableError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTableInputOperationOutputAlias,
                crate::output::UpdateTableOutput,
                crate::error::UpdateTableError,
                crate::input::UpdateTableInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AttributeDefinitions`.
        ///
        /// To override the contents of this collection use [`set_attribute_definitions`](Self::set_attribute_definitions).
        ///
        /// <p>An array of attributes that describe the key schema for the table and indexes. If you are adding a new global secondary index to the table, <code>AttributeDefinitions</code> must include the key element(s) of the new index.</p>
        pub fn attribute_definitions(
            mut self,
            inp: impl Into<crate::model::AttributeDefinition>,
        ) -> Self {
            self.inner = self.inner.attribute_definitions(inp);
            self
        }
        /// <p>An array of attributes that describe the key schema for the table and indexes. If you are adding a new global secondary index to the table, <code>AttributeDefinitions</code> must include the key element(s) of the new index.</p>
        pub fn set_attribute_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeDefinition>>,
        ) -> Self {
            self.inner = self.inner.set_attribute_definitions(input);
            self
        }
        /// <p>The name of the table to be updated.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the table to be updated.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>Controls how you are charged for read and write throughput and how you manage capacity.
        /// When switching from pay-per-request to provisioned capacity, initial provisioned capacity values must be set. The initial
        /// provisioned capacity values are estimated based on the consumed read and write capacity of your table and global secondary indexes
        /// over the past 30 minutes.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual">Provisioned Mode</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand">On-Demand Mode</a>.
        /// </p>
        /// </li>
        /// </ul>
        pub fn billing_mode(mut self, inp: crate::model::BillingMode) -> Self {
            self.inner = self.inner.billing_mode(inp);
            self
        }
        /// <p>Controls how you are charged for read and write throughput and how you manage capacity.
        /// When switching from pay-per-request to provisioned capacity, initial provisioned capacity values must be set. The initial
        /// provisioned capacity values are estimated based on the consumed read and write capacity of your table and global secondary indexes
        /// over the past 30 minutes.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual">Provisioned Mode</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand">On-Demand Mode</a>.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_billing_mode(
            mut self,
            input: std::option::Option<crate::model::BillingMode>,
        ) -> Self {
            self.inner = self.inner.set_billing_mode(input);
            self
        }
        /// <p>The new provisioned throughput settings for the specified table or index.</p>
        pub fn provisioned_throughput(mut self, inp: crate::model::ProvisionedThroughput) -> Self {
            self.inner = self.inner.provisioned_throughput(inp);
            self
        }
        /// <p>The new provisioned throughput settings for the specified table or index.</p>
        pub fn set_provisioned_throughput(
            mut self,
            input: std::option::Option<crate::model::ProvisionedThroughput>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_throughput(input);
            self
        }
        /// Appends an item to `GlobalSecondaryIndexUpdates`.
        ///
        /// To override the contents of this collection use [`set_global_secondary_index_updates`](Self::set_global_secondary_index_updates).
        ///
        /// <p>An array of one or more global secondary indexes for the table. For each index in the array, you can request one action:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Create</code> - add a new global secondary index to the table.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Update</code> - modify the provisioned throughput settings of an existing global secondary index.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Delete</code> - remove a global secondary index from the table.</p>
        /// </li>
        /// </ul>
        /// <p>You can create or delete only one global secondary index per <code>UpdateTable</code> operation.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html">Managing Global Secondary
        /// Indexes</a> in the <i>Amazon DynamoDB Developer Guide</i>. </p>
        pub fn global_secondary_index_updates(
            mut self,
            inp: impl Into<crate::model::GlobalSecondaryIndexUpdate>,
        ) -> Self {
            self.inner = self.inner.global_secondary_index_updates(inp);
            self
        }
        /// <p>An array of one or more global secondary indexes for the table. For each index in the array, you can request one action:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Create</code> - add a new global secondary index to the table.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Update</code> - modify the provisioned throughput settings of an existing global secondary index.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Delete</code> - remove a global secondary index from the table.</p>
        /// </li>
        /// </ul>
        /// <p>You can create or delete only one global secondary index per <code>UpdateTable</code> operation.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html">Managing Global Secondary
        /// Indexes</a> in the <i>Amazon DynamoDB Developer Guide</i>. </p>
        pub fn set_global_secondary_index_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GlobalSecondaryIndexUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_global_secondary_index_updates(input);
            self
        }
        /// <p>Represents the DynamoDB Streams configuration for the table.</p>
        /// <note>
        /// <p>You receive a <code>ResourceInUseException</code> if you try to enable a stream on a
        /// table that already has a stream, or if you try to disable a stream on a table that
        /// doesn't have a stream.</p>
        /// </note>
        pub fn stream_specification(mut self, inp: crate::model::StreamSpecification) -> Self {
            self.inner = self.inner.stream_specification(inp);
            self
        }
        /// <p>Represents the DynamoDB Streams configuration for the table.</p>
        /// <note>
        /// <p>You receive a <code>ResourceInUseException</code> if you try to enable a stream on a
        /// table that already has a stream, or if you try to disable a stream on a table that
        /// doesn't have a stream.</p>
        /// </note>
        pub fn set_stream_specification(
            mut self,
            input: std::option::Option<crate::model::StreamSpecification>,
        ) -> Self {
            self.inner = self.inner.set_stream_specification(input);
            self
        }
        /// <p>The new server-side encryption settings for the specified table.</p>
        pub fn sse_specification(mut self, inp: crate::model::SseSpecification) -> Self {
            self.inner = self.inner.sse_specification(inp);
            self
        }
        /// <p>The new server-side encryption settings for the specified table.</p>
        pub fn set_sse_specification(
            mut self,
            input: std::option::Option<crate::model::SseSpecification>,
        ) -> Self {
            self.inner = self.inner.set_sse_specification(input);
            self
        }
        /// Appends an item to `ReplicaUpdates`.
        ///
        /// To override the contents of this collection use [`set_replica_updates`](Self::set_replica_updates).
        ///
        /// <p>A list of replica update actions (create, delete, or update) for the table.</p>
        /// <note>
        /// <p>This property only applies to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html">Version 2019.11.21</a> of global tables.</p>
        /// </note>
        pub fn replica_updates(
            mut self,
            inp: impl Into<crate::model::ReplicationGroupUpdate>,
        ) -> Self {
            self.inner = self.inner.replica_updates(inp);
            self
        }
        /// <p>A list of replica update actions (create, delete, or update) for the table.</p>
        /// <note>
        /// <p>This property only applies to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html">Version 2019.11.21</a> of global tables.</p>
        /// </note>
        pub fn set_replica_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicationGroupUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_replica_updates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTableReplicaAutoScaling`.
    ///
    /// <p>Updates auto scaling settings on your global tables at once.</p>
    /// <note>
    /// <p>This operation only applies to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html">Version 2019.11.21</a> of global tables.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct UpdateTableReplicaAutoScaling<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_table_replica_auto_scaling_input::Builder,
    }
    impl<C, M, R> UpdateTableReplicaAutoScaling<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTableReplicaAutoScaling`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTableReplicaAutoScalingOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTableReplicaAutoScalingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTableReplicaAutoScalingInputOperationOutputAlias,
                crate::output::UpdateTableReplicaAutoScalingOutput,
                crate::error::UpdateTableReplicaAutoScalingError,
                crate::input::UpdateTableReplicaAutoScalingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `GlobalSecondaryIndexUpdates`.
        ///
        /// To override the contents of this collection use [`set_global_secondary_index_updates`](Self::set_global_secondary_index_updates).
        ///
        /// <p>Represents the auto scaling settings of the global secondary indexes of the replica
        /// to be updated.</p>
        pub fn global_secondary_index_updates(
            mut self,
            inp: impl Into<crate::model::GlobalSecondaryIndexAutoScalingUpdate>,
        ) -> Self {
            self.inner = self.inner.global_secondary_index_updates(inp);
            self
        }
        /// <p>Represents the auto scaling settings of the global secondary indexes of the replica
        /// to be updated.</p>
        pub fn set_global_secondary_index_updates(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::GlobalSecondaryIndexAutoScalingUpdate>,
            >,
        ) -> Self {
            self.inner = self.inner.set_global_secondary_index_updates(input);
            self
        }
        /// <p>The name of the global table to be updated.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the global table to be updated.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>Represents the auto scaling settings to be modified for a global table or global
        /// secondary index.</p>
        pub fn provisioned_write_capacity_auto_scaling_update(
            mut self,
            inp: crate::model::AutoScalingSettingsUpdate,
        ) -> Self {
            self.inner = self
                .inner
                .provisioned_write_capacity_auto_scaling_update(inp);
            self
        }
        /// <p>Represents the auto scaling settings to be modified for a global table or global
        /// secondary index.</p>
        pub fn set_provisioned_write_capacity_auto_scaling_update(
            mut self,
            input: std::option::Option<crate::model::AutoScalingSettingsUpdate>,
        ) -> Self {
            self.inner = self
                .inner
                .set_provisioned_write_capacity_auto_scaling_update(input);
            self
        }
        /// Appends an item to `ReplicaUpdates`.
        ///
        /// To override the contents of this collection use [`set_replica_updates`](Self::set_replica_updates).
        ///
        /// <p>Represents the auto scaling settings of replicas of the table that will be
        /// modified.</p>
        pub fn replica_updates(
            mut self,
            inp: impl Into<crate::model::ReplicaAutoScalingUpdate>,
        ) -> Self {
            self.inner = self.inner.replica_updates(inp);
            self
        }
        /// <p>Represents the auto scaling settings of replicas of the table that will be
        /// modified.</p>
        pub fn set_replica_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicaAutoScalingUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_replica_updates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTimeToLive`.
    ///
    /// <p>The <code>UpdateTimeToLive</code> method enables or disables Time to Live (TTL) for the
    /// specified table. A successful <code>UpdateTimeToLive</code> call returns the current
    /// <code>TimeToLiveSpecification</code>. It can take up to one hour for the change to
    /// fully process. Any additional <code>UpdateTimeToLive</code> calls for the same table
    /// during this one hour duration result in a <code>ValidationException</code>. </p>
    /// <p>TTL compares the current time in epoch time format to the time stored in the TTL
    /// attribute of an item. If the epoch time value stored in the attribute is less than the
    /// current time, the item is marked as expired and subsequently deleted.</p>
    /// <note>
    /// <p> The epoch time format is the number of seconds elapsed since 12:00:00 AM January 1,
    /// 1970 UTC. </p>
    /// </note>
    /// <p>DynamoDB deletes expired items on a best-effort basis to ensure availability of
    /// throughput for other data operations.
    /// </p>
    /// <important>
    /// <p>DynamoDB typically deletes expired items within two days of expiration. The exact duration
    /// within which an item gets deleted after expiration is specific to the
    /// nature of the workload. Items that have expired and not been deleted will still show up in reads,
    /// queries, and scans.</p>
    /// </important>
    /// <p>As items are deleted, they are removed from any local secondary index and global
    /// secondary index immediately in the same eventually consistent way as a standard delete
    /// operation.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/TTL.html">Time To Live</a> in the Amazon DynamoDB Developer Guide. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateTimeToLive<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_time_to_live_input::Builder,
    }
    impl<C, M, R> UpdateTimeToLive<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTimeToLive`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTimeToLiveOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTimeToLiveError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTimeToLiveInputOperationOutputAlias,
                crate::output::UpdateTimeToLiveOutput,
                crate::error::UpdateTimeToLiveError,
                crate::input::UpdateTimeToLiveInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the table to be configured.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the table to be configured.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>Represents the settings used to enable or disable Time to Live for the specified table.</p>
        pub fn time_to_live_specification(
            mut self,
            inp: crate::model::TimeToLiveSpecification,
        ) -> Self {
            self.inner = self.inner.time_to_live_specification(inp);
            self
        }
        /// <p>Represents the settings used to enable or disable Time to Live for the specified table.</p>
        pub fn set_time_to_live_specification(
            mut self,
            input: std::option::Option<crate::model::TimeToLiveSpecification>,
        ) -> Self {
            self.inner = self.inner.set_time_to_live_specification(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
