// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateReplicationConfigurationTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateReplicationConfigurationTemplateError {
    /// Kind of error that occurred.
    pub kind: CreateReplicationConfigurationTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateReplicationConfigurationTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateReplicationConfigurationTemplateErrorKind {
    /// <p>TYou do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request could not be completed because its exceeded the service quota.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The account performing the request has not been initialized.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateReplicationConfigurationTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateReplicationConfigurationTemplateErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            CreateReplicationConfigurationTemplateErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            CreateReplicationConfigurationTemplateErrorKind::ServiceQuotaExceededException(
                _inner,
            ) => _inner.fmt(f),
            CreateReplicationConfigurationTemplateErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            CreateReplicationConfigurationTemplateErrorKind::UninitializedAccountException(
                _inner,
            ) => _inner.fmt(f),
            CreateReplicationConfigurationTemplateErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            CreateReplicationConfigurationTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateReplicationConfigurationTemplateError {
    fn code(&self) -> Option<&str> {
        CreateReplicationConfigurationTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateReplicationConfigurationTemplateError {
    /// Creates a new `CreateReplicationConfigurationTemplateError`.
    pub fn new(
        kind: CreateReplicationConfigurationTemplateErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateReplicationConfigurationTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateReplicationConfigurationTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateReplicationConfigurationTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateReplicationConfigurationTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateReplicationConfigurationTemplateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationConfigurationTemplateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationConfigurationTemplateErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationConfigurationTemplateErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationConfigurationTemplateErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationConfigurationTemplateErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationConfigurationTemplateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationConfigurationTemplateErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationConfigurationTemplateErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationConfigurationTemplateErrorKind::UninitializedAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationConfigurationTemplateErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationConfigurationTemplateErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateReplicationConfigurationTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateReplicationConfigurationTemplateErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            CreateReplicationConfigurationTemplateErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            CreateReplicationConfigurationTemplateErrorKind::ServiceQuotaExceededException(
                _inner,
            ) => Some(_inner),
            CreateReplicationConfigurationTemplateErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            CreateReplicationConfigurationTemplateErrorKind::UninitializedAccountException(
                _inner,
            ) => Some(_inner),
            CreateReplicationConfigurationTemplateErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            CreateReplicationConfigurationTemplateErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DeleteJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteJobError {
    /// Kind of error that occurred.
    pub kind: DeleteJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteJobErrorKind {
    /// <p>The request could not be completed due to a conflict with the current state of the target resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource for this operation was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The account performing the request has not been initialized.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteJobErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteJobErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteJobErrorKind::UninitializedAccountException(_inner) => _inner.fmt(f),
            DeleteJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteJobError {
    fn code(&self) -> Option<&str> {
        DeleteJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteJobError {
    /// Creates a new `DeleteJobError`.
    pub fn new(kind: DeleteJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteJobErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteJobErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, DeleteJobErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `DeleteJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteJobErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteJobErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteJobErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteJobErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteJobErrorKind::UninitializedAccountException(_)
        )
    }
}
impl std::error::Error for DeleteJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteJobErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteJobErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteJobErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteJobErrorKind::UninitializedAccountException(_inner) => Some(_inner),
            DeleteJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRecoveryInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRecoveryInstanceError {
    /// Kind of error that occurred.
    pub kind: DeleteRecoveryInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRecoveryInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRecoveryInstanceErrorKind {
    /// <p>TYou do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request could not be completed due to a conflict with the current state of the target resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The account performing the request has not been initialized.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRecoveryInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRecoveryInstanceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteRecoveryInstanceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteRecoveryInstanceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteRecoveryInstanceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteRecoveryInstanceErrorKind::UninitializedAccountException(_inner) => _inner.fmt(f),
            DeleteRecoveryInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRecoveryInstanceError {
    fn code(&self) -> Option<&str> {
        DeleteRecoveryInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRecoveryInstanceError {
    /// Creates a new `DeleteRecoveryInstanceError`.
    pub fn new(kind: DeleteRecoveryInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRecoveryInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRecoveryInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRecoveryInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRecoveryInstanceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRecoveryInstanceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRecoveryInstanceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRecoveryInstanceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRecoveryInstanceErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRecoveryInstanceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRecoveryInstanceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRecoveryInstanceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRecoveryInstanceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRecoveryInstanceErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRecoveryInstanceErrorKind::UninitializedAccountException(_)
        )
    }
}
impl std::error::Error for DeleteRecoveryInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRecoveryInstanceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteRecoveryInstanceErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteRecoveryInstanceErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteRecoveryInstanceErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteRecoveryInstanceErrorKind::UninitializedAccountException(_inner) => Some(_inner),
            DeleteRecoveryInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteReplicationConfigurationTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteReplicationConfigurationTemplateError {
    /// Kind of error that occurred.
    pub kind: DeleteReplicationConfigurationTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteReplicationConfigurationTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteReplicationConfigurationTemplateErrorKind {
    /// <p>The request could not be completed due to a conflict with the current state of the target resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource for this operation was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The account performing the request has not been initialized.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteReplicationConfigurationTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteReplicationConfigurationTemplateErrorKind::ConflictException(_inner) => {
                _inner.fmt(f)
            }
            DeleteReplicationConfigurationTemplateErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DeleteReplicationConfigurationTemplateErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteReplicationConfigurationTemplateErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DeleteReplicationConfigurationTemplateErrorKind::UninitializedAccountException(
                _inner,
            ) => _inner.fmt(f),
            DeleteReplicationConfigurationTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteReplicationConfigurationTemplateError {
    fn code(&self) -> Option<&str> {
        DeleteReplicationConfigurationTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteReplicationConfigurationTemplateError {
    /// Creates a new `DeleteReplicationConfigurationTemplateError`.
    pub fn new(
        kind: DeleteReplicationConfigurationTemplateErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteReplicationConfigurationTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteReplicationConfigurationTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteReplicationConfigurationTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteReplicationConfigurationTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteReplicationConfigurationTemplateErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReplicationConfigurationTemplateErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReplicationConfigurationTemplateErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReplicationConfigurationTemplateErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReplicationConfigurationTemplateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReplicationConfigurationTemplateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReplicationConfigurationTemplateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReplicationConfigurationTemplateErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReplicationConfigurationTemplateErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReplicationConfigurationTemplateErrorKind::UninitializedAccountException(_)
        )
    }
}
impl std::error::Error for DeleteReplicationConfigurationTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteReplicationConfigurationTemplateErrorKind::ConflictException(_inner) => {
                Some(_inner)
            }
            DeleteReplicationConfigurationTemplateErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DeleteReplicationConfigurationTemplateErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteReplicationConfigurationTemplateErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            DeleteReplicationConfigurationTemplateErrorKind::UninitializedAccountException(
                _inner,
            ) => Some(_inner),
            DeleteReplicationConfigurationTemplateErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DeleteSourceServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSourceServerError {
    /// Kind of error that occurred.
    pub kind: DeleteSourceServerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSourceServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSourceServerErrorKind {
    /// <p>The request could not be completed due to a conflict with the current state of the target resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource for this operation was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The account performing the request has not been initialized.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSourceServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSourceServerErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteSourceServerErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteSourceServerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteSourceServerErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteSourceServerErrorKind::UninitializedAccountException(_inner) => _inner.fmt(f),
            DeleteSourceServerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSourceServerError {
    fn code(&self) -> Option<&str> {
        DeleteSourceServerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSourceServerError {
    /// Creates a new `DeleteSourceServerError`.
    pub fn new(kind: DeleteSourceServerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSourceServerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSourceServerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSourceServerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSourceServerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSourceServerErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSourceServerErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSourceServerErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSourceServerErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSourceServerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSourceServerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSourceServerErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSourceServerErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSourceServerErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSourceServerErrorKind::UninitializedAccountException(_)
        )
    }
}
impl std::error::Error for DeleteSourceServerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSourceServerErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteSourceServerErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteSourceServerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteSourceServerErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteSourceServerErrorKind::UninitializedAccountException(_inner) => Some(_inner),
            DeleteSourceServerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeJobLogItems` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeJobLogItemsError {
    /// Kind of error that occurred.
    pub kind: DescribeJobLogItemsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeJobLogItems` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeJobLogItemsErrorKind {
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The account performing the request has not been initialized.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeJobLogItemsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeJobLogItemsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeJobLogItemsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeJobLogItemsErrorKind::UninitializedAccountException(_inner) => _inner.fmt(f),
            DescribeJobLogItemsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeJobLogItemsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeJobLogItemsError {
    fn code(&self) -> Option<&str> {
        DescribeJobLogItemsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeJobLogItemsError {
    /// Creates a new `DescribeJobLogItemsError`.
    pub fn new(kind: DescribeJobLogItemsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeJobLogItemsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeJobLogItemsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeJobLogItemsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeJobLogItemsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeJobLogItemsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobLogItemsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeJobLogItemsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobLogItemsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeJobLogItemsErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobLogItemsErrorKind::UninitializedAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeJobLogItemsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobLogItemsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeJobLogItemsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeJobLogItemsErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeJobLogItemsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeJobLogItemsErrorKind::UninitializedAccountException(_inner) => Some(_inner),
            DescribeJobLogItemsErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeJobLogItemsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeJobsError {
    /// Kind of error that occurred.
    pub kind: DescribeJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeJobsErrorKind {
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The account performing the request has not been initialized.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeJobsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeJobsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeJobsErrorKind::UninitializedAccountException(_inner) => _inner.fmt(f),
            DescribeJobsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeJobsError {
    fn code(&self) -> Option<&str> {
        DescribeJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeJobsError {
    /// Creates a new `DescribeJobsError`.
    pub fn new(kind: DescribeJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeJobsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeJobsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeJobsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeJobsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DescribeJobsErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobsErrorKind::UninitializedAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeJobsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribeJobsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribeJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeJobsErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeJobsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeJobsErrorKind::UninitializedAccountException(_inner) => Some(_inner),
            DescribeJobsErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeRecoveryInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeRecoveryInstancesError {
    /// Kind of error that occurred.
    pub kind: DescribeRecoveryInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeRecoveryInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeRecoveryInstancesErrorKind {
    /// <p>TYou do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The account performing the request has not been initialized.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeRecoveryInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeRecoveryInstancesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeRecoveryInstancesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeRecoveryInstancesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeRecoveryInstancesErrorKind::UninitializedAccountException(_inner) => {
                _inner.fmt(f)
            }
            DescribeRecoveryInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeRecoveryInstancesError {
    fn code(&self) -> Option<&str> {
        DescribeRecoveryInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeRecoveryInstancesError {
    /// Creates a new `DescribeRecoveryInstancesError`.
    pub fn new(kind: DescribeRecoveryInstancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeRecoveryInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeRecoveryInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeRecoveryInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeRecoveryInstancesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeRecoveryInstancesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRecoveryInstancesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRecoveryInstancesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRecoveryInstancesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRecoveryInstancesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRecoveryInstancesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRecoveryInstancesErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRecoveryInstancesErrorKind::UninitializedAccountException(_)
        )
    }
}
impl std::error::Error for DescribeRecoveryInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeRecoveryInstancesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeRecoveryInstancesErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeRecoveryInstancesErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeRecoveryInstancesErrorKind::UninitializedAccountException(_inner) => {
                Some(_inner)
            }
            DescribeRecoveryInstancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeRecoverySnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeRecoverySnapshotsError {
    /// Kind of error that occurred.
    pub kind: DescribeRecoverySnapshotsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeRecoverySnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeRecoverySnapshotsErrorKind {
    /// <p>TYou do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The account performing the request has not been initialized.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeRecoverySnapshotsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeRecoverySnapshotsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeRecoverySnapshotsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeRecoverySnapshotsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeRecoverySnapshotsErrorKind::UninitializedAccountException(_inner) => {
                _inner.fmt(f)
            }
            DescribeRecoverySnapshotsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeRecoverySnapshotsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeRecoverySnapshotsError {
    fn code(&self) -> Option<&str> {
        DescribeRecoverySnapshotsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeRecoverySnapshotsError {
    /// Creates a new `DescribeRecoverySnapshotsError`.
    pub fn new(kind: DescribeRecoverySnapshotsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeRecoverySnapshotsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeRecoverySnapshotsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeRecoverySnapshotsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeRecoverySnapshotsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeRecoverySnapshotsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRecoverySnapshotsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRecoverySnapshotsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRecoverySnapshotsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRecoverySnapshotsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRecoverySnapshotsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRecoverySnapshotsErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRecoverySnapshotsErrorKind::UninitializedAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRecoverySnapshotsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRecoverySnapshotsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeRecoverySnapshotsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeRecoverySnapshotsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeRecoverySnapshotsErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeRecoverySnapshotsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeRecoverySnapshotsErrorKind::UninitializedAccountException(_inner) => {
                Some(_inner)
            }
            DescribeRecoverySnapshotsErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeRecoverySnapshotsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeReplicationConfigurationTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeReplicationConfigurationTemplatesError {
    /// Kind of error that occurred.
    pub kind: DescribeReplicationConfigurationTemplatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeReplicationConfigurationTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeReplicationConfigurationTemplatesErrorKind {
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource for this operation was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The account performing the request has not been initialized.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeReplicationConfigurationTemplatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeReplicationConfigurationTemplatesErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DescribeReplicationConfigurationTemplatesErrorKind::ResourceNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            DescribeReplicationConfigurationTemplatesErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DescribeReplicationConfigurationTemplatesErrorKind::UninitializedAccountException(
                _inner,
            ) => _inner.fmt(f),
            DescribeReplicationConfigurationTemplatesErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeReplicationConfigurationTemplatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeReplicationConfigurationTemplatesError {
    fn code(&self) -> Option<&str> {
        DescribeReplicationConfigurationTemplatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeReplicationConfigurationTemplatesError {
    /// Creates a new `DescribeReplicationConfigurationTemplatesError`.
    pub fn new(
        kind: DescribeReplicationConfigurationTemplatesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeReplicationConfigurationTemplatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeReplicationConfigurationTemplatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeReplicationConfigurationTemplatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeReplicationConfigurationTemplatesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeReplicationConfigurationTemplatesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReplicationConfigurationTemplatesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReplicationConfigurationTemplatesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReplicationConfigurationTemplatesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReplicationConfigurationTemplatesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReplicationConfigurationTemplatesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReplicationConfigurationTemplatesErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReplicationConfigurationTemplatesErrorKind::UninitializedAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReplicationConfigurationTemplatesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReplicationConfigurationTemplatesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeReplicationConfigurationTemplatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeReplicationConfigurationTemplatesErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DescribeReplicationConfigurationTemplatesErrorKind::ResourceNotFoundException(
                _inner,
            ) => Some(_inner),
            DescribeReplicationConfigurationTemplatesErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            DescribeReplicationConfigurationTemplatesErrorKind::UninitializedAccountException(
                _inner,
            ) => Some(_inner),
            DescribeReplicationConfigurationTemplatesErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            DescribeReplicationConfigurationTemplatesErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeSourceServers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSourceServersError {
    /// Kind of error that occurred.
    pub kind: DescribeSourceServersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSourceServers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSourceServersErrorKind {
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The account performing the request has not been initialized.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSourceServersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSourceServersErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeSourceServersErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeSourceServersErrorKind::UninitializedAccountException(_inner) => _inner.fmt(f),
            DescribeSourceServersErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeSourceServersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSourceServersError {
    fn code(&self) -> Option<&str> {
        DescribeSourceServersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSourceServersError {
    /// Creates a new `DescribeSourceServersError`.
    pub fn new(kind: DescribeSourceServersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSourceServersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSourceServersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSourceServersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSourceServersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeSourceServersErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSourceServersErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSourceServersErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSourceServersErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSourceServersErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSourceServersErrorKind::UninitializedAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSourceServersErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSourceServersErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeSourceServersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSourceServersErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeSourceServersErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeSourceServersErrorKind::UninitializedAccountException(_inner) => Some(_inner),
            DescribeSourceServersErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeSourceServersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisconnectRecoveryInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisconnectRecoveryInstanceError {
    /// Kind of error that occurred.
    pub kind: DisconnectRecoveryInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisconnectRecoveryInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisconnectRecoveryInstanceErrorKind {
    /// <p>TYou do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request could not be completed due to a conflict with the current state of the target resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource for this operation was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The account performing the request has not been initialized.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisconnectRecoveryInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisconnectRecoveryInstanceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DisconnectRecoveryInstanceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DisconnectRecoveryInstanceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DisconnectRecoveryInstanceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisconnectRecoveryInstanceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisconnectRecoveryInstanceErrorKind::UninitializedAccountException(_inner) => {
                _inner.fmt(f)
            }
            DisconnectRecoveryInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisconnectRecoveryInstanceError {
    fn code(&self) -> Option<&str> {
        DisconnectRecoveryInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisconnectRecoveryInstanceError {
    /// Creates a new `DisconnectRecoveryInstanceError`.
    pub fn new(kind: DisconnectRecoveryInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisconnectRecoveryInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisconnectRecoveryInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisconnectRecoveryInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisconnectRecoveryInstanceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisconnectRecoveryInstanceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisconnectRecoveryInstanceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisconnectRecoveryInstanceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisconnectRecoveryInstanceErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DisconnectRecoveryInstanceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisconnectRecoveryInstanceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisconnectRecoveryInstanceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisconnectRecoveryInstanceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisconnectRecoveryInstanceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisconnectRecoveryInstanceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisconnectRecoveryInstanceErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisconnectRecoveryInstanceErrorKind::UninitializedAccountException(_)
        )
    }
}
impl std::error::Error for DisconnectRecoveryInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisconnectRecoveryInstanceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisconnectRecoveryInstanceErrorKind::ConflictException(_inner) => Some(_inner),
            DisconnectRecoveryInstanceErrorKind::InternalServerException(_inner) => Some(_inner),
            DisconnectRecoveryInstanceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisconnectRecoveryInstanceErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisconnectRecoveryInstanceErrorKind::UninitializedAccountException(_inner) => {
                Some(_inner)
            }
            DisconnectRecoveryInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisconnectSourceServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisconnectSourceServerError {
    /// Kind of error that occurred.
    pub kind: DisconnectSourceServerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisconnectSourceServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisconnectSourceServerErrorKind {
    /// <p>The request could not be completed due to a conflict with the current state of the target resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource for this operation was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The account performing the request has not been initialized.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisconnectSourceServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisconnectSourceServerErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DisconnectSourceServerErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DisconnectSourceServerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisconnectSourceServerErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisconnectSourceServerErrorKind::UninitializedAccountException(_inner) => _inner.fmt(f),
            DisconnectSourceServerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisconnectSourceServerError {
    fn code(&self) -> Option<&str> {
        DisconnectSourceServerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisconnectSourceServerError {
    /// Creates a new `DisconnectSourceServerError`.
    pub fn new(kind: DisconnectSourceServerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisconnectSourceServerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisconnectSourceServerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisconnectSourceServerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisconnectSourceServerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisconnectSourceServerErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisconnectSourceServerErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DisconnectSourceServerErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisconnectSourceServerErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisconnectSourceServerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisconnectSourceServerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisconnectSourceServerErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisconnectSourceServerErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisconnectSourceServerErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisconnectSourceServerErrorKind::UninitializedAccountException(_)
        )
    }
}
impl std::error::Error for DisconnectSourceServerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisconnectSourceServerErrorKind::ConflictException(_inner) => Some(_inner),
            DisconnectSourceServerErrorKind::InternalServerException(_inner) => Some(_inner),
            DisconnectSourceServerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisconnectSourceServerErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisconnectSourceServerErrorKind::UninitializedAccountException(_inner) => Some(_inner),
            DisconnectSourceServerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetFailbackReplicationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetFailbackReplicationConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetFailbackReplicationConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetFailbackReplicationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetFailbackReplicationConfigurationErrorKind {
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource for this operation was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The account performing the request has not been initialized.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetFailbackReplicationConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetFailbackReplicationConfigurationErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            GetFailbackReplicationConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetFailbackReplicationConfigurationErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            GetFailbackReplicationConfigurationErrorKind::UninitializedAccountException(_inner) => {
                _inner.fmt(f)
            }
            GetFailbackReplicationConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetFailbackReplicationConfigurationError {
    fn code(&self) -> Option<&str> {
        GetFailbackReplicationConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetFailbackReplicationConfigurationError {
    /// Creates a new `GetFailbackReplicationConfigurationError`.
    pub fn new(
        kind: GetFailbackReplicationConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetFailbackReplicationConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetFailbackReplicationConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetFailbackReplicationConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetFailbackReplicationConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetFailbackReplicationConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFailbackReplicationConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFailbackReplicationConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFailbackReplicationConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFailbackReplicationConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFailbackReplicationConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFailbackReplicationConfigurationErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFailbackReplicationConfigurationErrorKind::UninitializedAccountException(_)
        )
    }
}
impl std::error::Error for GetFailbackReplicationConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetFailbackReplicationConfigurationErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            GetFailbackReplicationConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetFailbackReplicationConfigurationErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            GetFailbackReplicationConfigurationErrorKind::UninitializedAccountException(_inner) => {
                Some(_inner)
            }
            GetFailbackReplicationConfigurationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetLaunchConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLaunchConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetLaunchConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLaunchConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLaunchConfigurationErrorKind {
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource for this operation was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The account performing the request has not been initialized.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLaunchConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLaunchConfigurationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetLaunchConfigurationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetLaunchConfigurationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetLaunchConfigurationErrorKind::UninitializedAccountException(_inner) => _inner.fmt(f),
            GetLaunchConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLaunchConfigurationError {
    fn code(&self) -> Option<&str> {
        GetLaunchConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLaunchConfigurationError {
    /// Creates a new `GetLaunchConfigurationError`.
    pub fn new(kind: GetLaunchConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLaunchConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLaunchConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLaunchConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLaunchConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetLaunchConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLaunchConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLaunchConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLaunchConfigurationErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchConfigurationErrorKind::UninitializedAccountException(_)
        )
    }
}
impl std::error::Error for GetLaunchConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLaunchConfigurationErrorKind::InternalServerException(_inner) => Some(_inner),
            GetLaunchConfigurationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetLaunchConfigurationErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetLaunchConfigurationErrorKind::UninitializedAccountException(_inner) => Some(_inner),
            GetLaunchConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetReplicationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetReplicationConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetReplicationConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetReplicationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetReplicationConfigurationErrorKind {
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource for this operation was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The account performing the request has not been initialized.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetReplicationConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetReplicationConfigurationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetReplicationConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetReplicationConfigurationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetReplicationConfigurationErrorKind::UninitializedAccountException(_inner) => {
                _inner.fmt(f)
            }
            GetReplicationConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetReplicationConfigurationError {
    fn code(&self) -> Option<&str> {
        GetReplicationConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetReplicationConfigurationError {
    /// Creates a new `GetReplicationConfigurationError`.
    pub fn new(kind: GetReplicationConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetReplicationConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetReplicationConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetReplicationConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetReplicationConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetReplicationConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReplicationConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetReplicationConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReplicationConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetReplicationConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReplicationConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetReplicationConfigurationErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReplicationConfigurationErrorKind::UninitializedAccountException(_)
        )
    }
}
impl std::error::Error for GetReplicationConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetReplicationConfigurationErrorKind::InternalServerException(_inner) => Some(_inner),
            GetReplicationConfigurationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetReplicationConfigurationErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetReplicationConfigurationErrorKind::UninitializedAccountException(_inner) => {
                Some(_inner)
            }
            GetReplicationConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `InitializeService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct InitializeServiceError {
    /// Kind of error that occurred.
    pub kind: InitializeServiceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `InitializeService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum InitializeServiceErrorKind {
    /// <p>TYou do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for InitializeServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            InitializeServiceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            InitializeServiceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            InitializeServiceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            InitializeServiceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            InitializeServiceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for InitializeServiceError {
    fn code(&self) -> Option<&str> {
        InitializeServiceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl InitializeServiceError {
    /// Creates a new `InitializeServiceError`.
    pub fn new(kind: InitializeServiceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `InitializeServiceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: InitializeServiceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `InitializeServiceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: InitializeServiceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `InitializeServiceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitializeServiceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `InitializeServiceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitializeServiceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `InitializeServiceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitializeServiceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `InitializeServiceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitializeServiceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for InitializeServiceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            InitializeServiceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            InitializeServiceErrorKind::InternalServerException(_inner) => Some(_inner),
            InitializeServiceErrorKind::ThrottlingException(_inner) => Some(_inner),
            InitializeServiceErrorKind::ValidationException(_inner) => Some(_inner),
            InitializeServiceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>TYou do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource for this operation was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RetryDataReplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RetryDataReplicationError {
    /// Kind of error that occurred.
    pub kind: RetryDataReplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RetryDataReplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RetryDataReplicationErrorKind {
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource for this operation was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The account performing the request has not been initialized.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RetryDataReplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RetryDataReplicationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            RetryDataReplicationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RetryDataReplicationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            RetryDataReplicationErrorKind::UninitializedAccountException(_inner) => _inner.fmt(f),
            RetryDataReplicationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            RetryDataReplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RetryDataReplicationError {
    fn code(&self) -> Option<&str> {
        RetryDataReplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RetryDataReplicationError {
    /// Creates a new `RetryDataReplicationError`.
    pub fn new(kind: RetryDataReplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RetryDataReplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RetryDataReplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RetryDataReplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RetryDataReplicationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RetryDataReplicationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            RetryDataReplicationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `RetryDataReplicationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RetryDataReplicationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RetryDataReplicationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            RetryDataReplicationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `RetryDataReplicationErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            RetryDataReplicationErrorKind::UninitializedAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `RetryDataReplicationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            RetryDataReplicationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for RetryDataReplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RetryDataReplicationErrorKind::InternalServerException(_inner) => Some(_inner),
            RetryDataReplicationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RetryDataReplicationErrorKind::ThrottlingException(_inner) => Some(_inner),
            RetryDataReplicationErrorKind::UninitializedAccountException(_inner) => Some(_inner),
            RetryDataReplicationErrorKind::ValidationException(_inner) => Some(_inner),
            RetryDataReplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartFailbackLaunch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartFailbackLaunchError {
    /// Kind of error that occurred.
    pub kind: StartFailbackLaunchErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartFailbackLaunch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartFailbackLaunchErrorKind {
    /// <p>The request could not be completed due to a conflict with the current state of the target resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request could not be completed because its exceeded the service quota.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The account performing the request has not been initialized.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartFailbackLaunchError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartFailbackLaunchErrorKind::ConflictException(_inner) => _inner.fmt(f),
            StartFailbackLaunchErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StartFailbackLaunchErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            StartFailbackLaunchErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StartFailbackLaunchErrorKind::UninitializedAccountException(_inner) => _inner.fmt(f),
            StartFailbackLaunchErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StartFailbackLaunchErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartFailbackLaunchError {
    fn code(&self) -> Option<&str> {
        StartFailbackLaunchError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartFailbackLaunchError {
    /// Creates a new `StartFailbackLaunchError`.
    pub fn new(kind: StartFailbackLaunchErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartFailbackLaunchError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartFailbackLaunchErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartFailbackLaunchError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartFailbackLaunchErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartFailbackLaunchErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFailbackLaunchErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `StartFailbackLaunchErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFailbackLaunchErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartFailbackLaunchErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFailbackLaunchErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartFailbackLaunchErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFailbackLaunchErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `StartFailbackLaunchErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFailbackLaunchErrorKind::UninitializedAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `StartFailbackLaunchErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFailbackLaunchErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for StartFailbackLaunchError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartFailbackLaunchErrorKind::ConflictException(_inner) => Some(_inner),
            StartFailbackLaunchErrorKind::InternalServerException(_inner) => Some(_inner),
            StartFailbackLaunchErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            StartFailbackLaunchErrorKind::ThrottlingException(_inner) => Some(_inner),
            StartFailbackLaunchErrorKind::UninitializedAccountException(_inner) => Some(_inner),
            StartFailbackLaunchErrorKind::ValidationException(_inner) => Some(_inner),
            StartFailbackLaunchErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartRecovery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartRecoveryError {
    /// Kind of error that occurred.
    pub kind: StartRecoveryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartRecovery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartRecoveryErrorKind {
    /// <p>The request could not be completed due to a conflict with the current state of the target resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request could not be completed because its exceeded the service quota.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The account performing the request has not been initialized.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartRecoveryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartRecoveryErrorKind::ConflictException(_inner) => _inner.fmt(f),
            StartRecoveryErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StartRecoveryErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            StartRecoveryErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StartRecoveryErrorKind::UninitializedAccountException(_inner) => _inner.fmt(f),
            StartRecoveryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartRecoveryError {
    fn code(&self) -> Option<&str> {
        StartRecoveryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartRecoveryError {
    /// Creates a new `StartRecoveryError`.
    pub fn new(kind: StartRecoveryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartRecoveryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartRecoveryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartRecoveryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartRecoveryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartRecoveryErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, StartRecoveryErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `StartRecoveryErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartRecoveryErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartRecoveryErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartRecoveryErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartRecoveryErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, StartRecoveryErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `StartRecoveryErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartRecoveryErrorKind::UninitializedAccountException(_)
        )
    }
}
impl std::error::Error for StartRecoveryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartRecoveryErrorKind::ConflictException(_inner) => Some(_inner),
            StartRecoveryErrorKind::InternalServerException(_inner) => Some(_inner),
            StartRecoveryErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            StartRecoveryErrorKind::ThrottlingException(_inner) => Some(_inner),
            StartRecoveryErrorKind::UninitializedAccountException(_inner) => Some(_inner),
            StartRecoveryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopFailback` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopFailbackError {
    /// Kind of error that occurred.
    pub kind: StopFailbackErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopFailback` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopFailbackErrorKind {
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource for this operation was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The account performing the request has not been initialized.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopFailbackError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopFailbackErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StopFailbackErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StopFailbackErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StopFailbackErrorKind::UninitializedAccountException(_inner) => _inner.fmt(f),
            StopFailbackErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopFailbackError {
    fn code(&self) -> Option<&str> {
        StopFailbackError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopFailbackError {
    /// Creates a new `StopFailbackError`.
    pub fn new(kind: StopFailbackErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopFailbackError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopFailbackErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopFailbackError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopFailbackErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopFailbackErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopFailbackErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StopFailbackErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopFailbackErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StopFailbackErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, StopFailbackErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `StopFailbackErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopFailbackErrorKind::UninitializedAccountException(_)
        )
    }
}
impl std::error::Error for StopFailbackError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopFailbackErrorKind::InternalServerException(_inner) => Some(_inner),
            StopFailbackErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StopFailbackErrorKind::ThrottlingException(_inner) => Some(_inner),
            StopFailbackErrorKind::UninitializedAccountException(_inner) => Some(_inner),
            StopFailbackErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>TYou do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource for this operation was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TerminateRecoveryInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TerminateRecoveryInstancesError {
    /// Kind of error that occurred.
    pub kind: TerminateRecoveryInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TerminateRecoveryInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TerminateRecoveryInstancesErrorKind {
    /// <p>The request could not be completed due to a conflict with the current state of the target resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request could not be completed because its exceeded the service quota.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The account performing the request has not been initialized.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TerminateRecoveryInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TerminateRecoveryInstancesErrorKind::ConflictException(_inner) => _inner.fmt(f),
            TerminateRecoveryInstancesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TerminateRecoveryInstancesErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            TerminateRecoveryInstancesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            TerminateRecoveryInstancesErrorKind::UninitializedAccountException(_inner) => {
                _inner.fmt(f)
            }
            TerminateRecoveryInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TerminateRecoveryInstancesError {
    fn code(&self) -> Option<&str> {
        TerminateRecoveryInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TerminateRecoveryInstancesError {
    /// Creates a new `TerminateRecoveryInstancesError`.
    pub fn new(kind: TerminateRecoveryInstancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TerminateRecoveryInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TerminateRecoveryInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TerminateRecoveryInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TerminateRecoveryInstancesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TerminateRecoveryInstancesErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            TerminateRecoveryInstancesErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `TerminateRecoveryInstancesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            TerminateRecoveryInstancesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `TerminateRecoveryInstancesErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            TerminateRecoveryInstancesErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `TerminateRecoveryInstancesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            TerminateRecoveryInstancesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `TerminateRecoveryInstancesErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            TerminateRecoveryInstancesErrorKind::UninitializedAccountException(_)
        )
    }
}
impl std::error::Error for TerminateRecoveryInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TerminateRecoveryInstancesErrorKind::ConflictException(_inner) => Some(_inner),
            TerminateRecoveryInstancesErrorKind::InternalServerException(_inner) => Some(_inner),
            TerminateRecoveryInstancesErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            TerminateRecoveryInstancesErrorKind::ThrottlingException(_inner) => Some(_inner),
            TerminateRecoveryInstancesErrorKind::UninitializedAccountException(_inner) => {
                Some(_inner)
            }
            TerminateRecoveryInstancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>TYou do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource for this operation was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateFailbackReplicationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFailbackReplicationConfigurationError {
    /// Kind of error that occurred.
    pub kind: UpdateFailbackReplicationConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFailbackReplicationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFailbackReplicationConfigurationErrorKind {
    /// <p>TYou do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource for this operation was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The account performing the request has not been initialized.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFailbackReplicationConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFailbackReplicationConfigurationErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            UpdateFailbackReplicationConfigurationErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            UpdateFailbackReplicationConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateFailbackReplicationConfigurationErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            UpdateFailbackReplicationConfigurationErrorKind::UninitializedAccountException(
                _inner,
            ) => _inner.fmt(f),
            UpdateFailbackReplicationConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFailbackReplicationConfigurationError {
    fn code(&self) -> Option<&str> {
        UpdateFailbackReplicationConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFailbackReplicationConfigurationError {
    /// Creates a new `UpdateFailbackReplicationConfigurationError`.
    pub fn new(
        kind: UpdateFailbackReplicationConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFailbackReplicationConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFailbackReplicationConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFailbackReplicationConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFailbackReplicationConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateFailbackReplicationConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFailbackReplicationConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFailbackReplicationConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFailbackReplicationConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFailbackReplicationConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFailbackReplicationConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFailbackReplicationConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFailbackReplicationConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFailbackReplicationConfigurationErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFailbackReplicationConfigurationErrorKind::UninitializedAccountException(_)
        )
    }
}
impl std::error::Error for UpdateFailbackReplicationConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFailbackReplicationConfigurationErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            UpdateFailbackReplicationConfigurationErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            UpdateFailbackReplicationConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateFailbackReplicationConfigurationErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            UpdateFailbackReplicationConfigurationErrorKind::UninitializedAccountException(
                _inner,
            ) => Some(_inner),
            UpdateFailbackReplicationConfigurationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `UpdateLaunchConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateLaunchConfigurationError {
    /// Kind of error that occurred.
    pub kind: UpdateLaunchConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateLaunchConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateLaunchConfigurationErrorKind {
    /// <p>The request could not be completed due to a conflict with the current state of the target resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource for this operation was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The account performing the request has not been initialized.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateLaunchConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateLaunchConfigurationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateLaunchConfigurationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateLaunchConfigurationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateLaunchConfigurationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateLaunchConfigurationErrorKind::UninitializedAccountException(_inner) => {
                _inner.fmt(f)
            }
            UpdateLaunchConfigurationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateLaunchConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateLaunchConfigurationError {
    fn code(&self) -> Option<&str> {
        UpdateLaunchConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateLaunchConfigurationError {
    /// Creates a new `UpdateLaunchConfigurationError`.
    pub fn new(kind: UpdateLaunchConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateLaunchConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateLaunchConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateLaunchConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateLaunchConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateLaunchConfigurationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLaunchConfigurationErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLaunchConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLaunchConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLaunchConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLaunchConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLaunchConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLaunchConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLaunchConfigurationErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLaunchConfigurationErrorKind::UninitializedAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLaunchConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLaunchConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateLaunchConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateLaunchConfigurationErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateLaunchConfigurationErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateLaunchConfigurationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateLaunchConfigurationErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateLaunchConfigurationErrorKind::UninitializedAccountException(_inner) => {
                Some(_inner)
            }
            UpdateLaunchConfigurationErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateLaunchConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateReplicationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateReplicationConfigurationError {
    /// Kind of error that occurred.
    pub kind: UpdateReplicationConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateReplicationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateReplicationConfigurationErrorKind {
    /// <p>TYou do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request could not be completed due to a conflict with the current state of the target resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource for this operation was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The account performing the request has not been initialized.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateReplicationConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateReplicationConfigurationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateReplicationConfigurationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateReplicationConfigurationErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            UpdateReplicationConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateReplicationConfigurationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateReplicationConfigurationErrorKind::UninitializedAccountException(_inner) => {
                _inner.fmt(f)
            }
            UpdateReplicationConfigurationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateReplicationConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateReplicationConfigurationError {
    fn code(&self) -> Option<&str> {
        UpdateReplicationConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateReplicationConfigurationError {
    /// Creates a new `UpdateReplicationConfigurationError`.
    pub fn new(
        kind: UpdateReplicationConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateReplicationConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateReplicationConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateReplicationConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateReplicationConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateReplicationConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReplicationConfigurationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationConfigurationErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReplicationConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReplicationConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReplicationConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReplicationConfigurationErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationConfigurationErrorKind::UninitializedAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReplicationConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateReplicationConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateReplicationConfigurationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateReplicationConfigurationErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateReplicationConfigurationErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            UpdateReplicationConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateReplicationConfigurationErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateReplicationConfigurationErrorKind::UninitializedAccountException(_inner) => {
                Some(_inner)
            }
            UpdateReplicationConfigurationErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateReplicationConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateReplicationConfigurationTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateReplicationConfigurationTemplateError {
    /// Kind of error that occurred.
    pub kind: UpdateReplicationConfigurationTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateReplicationConfigurationTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateReplicationConfigurationTemplateErrorKind {
    /// <p>TYou do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource for this operation was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The account performing the request has not been initialized.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateReplicationConfigurationTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateReplicationConfigurationTemplateErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            UpdateReplicationConfigurationTemplateErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            UpdateReplicationConfigurationTemplateErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateReplicationConfigurationTemplateErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            UpdateReplicationConfigurationTemplateErrorKind::UninitializedAccountException(
                _inner,
            ) => _inner.fmt(f),
            UpdateReplicationConfigurationTemplateErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            UpdateReplicationConfigurationTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateReplicationConfigurationTemplateError {
    fn code(&self) -> Option<&str> {
        UpdateReplicationConfigurationTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateReplicationConfigurationTemplateError {
    /// Creates a new `UpdateReplicationConfigurationTemplateError`.
    pub fn new(
        kind: UpdateReplicationConfigurationTemplateErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateReplicationConfigurationTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateReplicationConfigurationTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateReplicationConfigurationTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateReplicationConfigurationTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateReplicationConfigurationTemplateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationConfigurationTemplateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReplicationConfigurationTemplateErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationConfigurationTemplateErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReplicationConfigurationTemplateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationConfigurationTemplateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReplicationConfigurationTemplateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationConfigurationTemplateErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReplicationConfigurationTemplateErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationConfigurationTemplateErrorKind::UninitializedAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReplicationConfigurationTemplateErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationConfigurationTemplateErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateReplicationConfigurationTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateReplicationConfigurationTemplateErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            UpdateReplicationConfigurationTemplateErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            UpdateReplicationConfigurationTemplateErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateReplicationConfigurationTemplateErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            UpdateReplicationConfigurationTemplateErrorKind::UninitializedAccountException(
                _inner,
            ) => Some(_inner),
            UpdateReplicationConfigurationTemplateErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            UpdateReplicationConfigurationTemplateErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// <p>The input fails to satisfy the constraints specified by the AWS service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
    /// <p>Validation exception reason.</p>
    pub reason: std::option::Option<crate::model::ValidationExceptionReason>,
    /// <p>A list of fields that failed validation.</p>
    pub field_list: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
}
impl ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>Validation exception reason.</p>
    pub fn reason(&self) -> std::option::Option<&crate::model::ValidationExceptionReason> {
        self.reason.as_ref()
    }
    /// <p>A list of fields that failed validation.</p>
    pub fn field_list(&self) -> std::option::Option<&[crate::model::ValidationExceptionField]> {
        self.field_list.as_deref()
    }
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.field("code", &self.code);
        formatter.field("reason", &self.reason);
        formatter.field("field_list", &self.field_list);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::ValidationExceptionReason>,
        pub(crate) field_list:
            std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>Validation exception reason.</p>
        pub fn reason(mut self, input: crate::model::ValidationExceptionReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>Validation exception reason.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ValidationExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Appends an item to `field_list`.
        ///
        /// To override the contents of this collection use [`set_field_list`](Self::set_field_list).
        ///
        /// <p>A list of fields that failed validation.</p>
        pub fn field_list(mut self, input: crate::model::ValidationExceptionField) -> Self {
            let mut v = self.field_list.unwrap_or_default();
            v.push(input);
            self.field_list = Some(v);
            self
        }
        /// <p>A list of fields that failed validation.</p>
        pub fn set_field_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
        ) -> Self {
            self.field_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
                code: self.code,
                reason: self.reason,
                field_list: self.field_list,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>The account performing the request has not been initialized.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UninitializedAccountException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
}
impl UninitializedAccountException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
}
impl std::fmt::Debug for UninitializedAccountException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UninitializedAccountException");
        formatter.field("message", &self.message);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
impl UninitializedAccountException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UninitializedAccountException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UninitializedAccountException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for UninitializedAccountException {}
/// See [`UninitializedAccountException`](crate::error::UninitializedAccountException)
pub mod uninitialized_account_exception {
    /// A builder for [`UninitializedAccountException`](crate::error::UninitializedAccountException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`UninitializedAccountException`](crate::error::UninitializedAccountException)
        pub fn build(self) -> crate::error::UninitializedAccountException {
            crate::error::UninitializedAccountException {
                message: self.message,
                code: self.code,
            }
        }
    }
}
impl UninitializedAccountException {
    /// Creates a new builder-style object to manufacture [`UninitializedAccountException`](crate::error::UninitializedAccountException)
    pub fn builder() -> crate::error::uninitialized_account_exception::Builder {
        crate::error::uninitialized_account_exception::Builder::default()
    }
}

/// <p>The request was denied due to request throttling.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>Service code.</p>
    pub service_code: std::option::Option<std::string::String>,
    /// <p>Quota code.</p>
    pub quota_code: std::option::Option<std::string::String>,
    /// <p>The number of seconds after which the request should be safe to retry.</p>
    pub retry_after_seconds: std::option::Option<std::string::String>,
}
impl ThrottlingException {
    /// <p>Service code.</p>
    pub fn service_code(&self) -> std::option::Option<&str> {
        self.service_code.as_deref()
    }
    /// <p>Quota code.</p>
    pub fn quota_code(&self) -> std::option::Option<&str> {
        self.quota_code.as_deref()
    }
    /// <p>The number of seconds after which the request should be safe to retry.</p>
    pub fn retry_after_seconds(&self) -> std::option::Option<&str> {
        self.retry_after_seconds.as_deref()
    }
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.field("service_code", &self.service_code);
        formatter.field("quota_code", &self.quota_code);
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<std::string::String>,
        pub(crate) quota_code: std::option::Option<std::string::String>,
        pub(crate) retry_after_seconds: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Service code.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// <p>Service code.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// <p>Quota code.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_code = Some(input.into());
            self
        }
        /// <p>Quota code.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_code = input;
            self
        }
        /// <p>The number of seconds after which the request should be safe to retry.</p>
        pub fn retry_after_seconds(mut self, input: impl Into<std::string::String>) -> Self {
            self.retry_after_seconds = Some(input.into());
            self
        }
        /// <p>The number of seconds after which the request should be safe to retry.</p>
        pub fn set_retry_after_seconds(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
                service_code: self.service_code,
                quota_code: self.quota_code,
                retry_after_seconds: self.retry_after_seconds,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>The resource for this operation was not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of the resource.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>The ID of the resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The type of the resource.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("code", &self.code);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of the resource.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of the resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                code: self.code,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The request processing has failed because of an unknown error, exception or failure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The number of seconds after which the request should be safe to retry.</p>
    pub retry_after_seconds: i64,
}
impl InternalServerException {
    /// <p>The number of seconds after which the request should be safe to retry.</p>
    pub fn retry_after_seconds(&self) -> i64 {
        self.retry_after_seconds
    }
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) retry_after_seconds: std::option::Option<i64>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The number of seconds after which the request should be safe to retry.</p>
        pub fn retry_after_seconds(mut self, input: i64) -> Self {
            self.retry_after_seconds = Some(input);
            self
        }
        /// <p>The number of seconds after which the request should be safe to retry.</p>
        pub fn set_retry_after_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
                retry_after_seconds: self.retry_after_seconds.unwrap_or_default(),
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>The request could not be completed due to a conflict with the current state of the target resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of the resource.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>The ID of the resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The type of the resource.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.field("code", &self.code);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of the resource.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of the resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
                code: self.code,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>TYou do not have sufficient access to perform this action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
}
impl AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
                code: self.code,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>The request could not be completed because its exceeded the service quota.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of the resource.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>Service code.</p>
    pub service_code: std::option::Option<std::string::String>,
    /// <p>Quota code.</p>
    pub quota_code: std::option::Option<std::string::String>,
}
impl ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>The ID of the resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The type of the resource.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>Service code.</p>
    pub fn service_code(&self) -> std::option::Option<&str> {
        self.service_code.as_deref()
    }
    /// <p>Quota code.</p>
    pub fn quota_code(&self) -> std::option::Option<&str> {
        self.quota_code.as_deref()
    }
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.field("code", &self.code);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("service_code", &self.service_code);
        formatter.field("quota_code", &self.quota_code);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<std::string::String>,
        pub(crate) quota_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of the resource.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of the resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>Service code.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// <p>Service code.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// <p>Quota code.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_code = Some(input.into());
            self
        }
        /// <p>Quota code.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_code = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
                code: self.code,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
                service_code: self.service_code,
                quota_code: self.quota_code,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}
