// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Elastic Disaster Recovery Service
///
/// Client for invoking operations on Elastic Disaster Recovery Service. Each operation on Elastic Disaster Recovery Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_drs::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_drs::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_drs::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateReplicationConfigurationTemplate`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`staging_area_subnet_id(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::staging_area_subnet_id) / [`set_staging_area_subnet_id(Option<String>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::set_staging_area_subnet_id): <p>The subnet to be used by the replication staging area.</p>
    ///   - [`associate_default_security_group(bool)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::associate_default_security_group) / [`set_associate_default_security_group(Option<bool>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::set_associate_default_security_group): <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>
    ///   - [`replication_servers_security_groups_i_ds(Vec<String>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::replication_servers_security_groups_i_ds) / [`set_replication_servers_security_groups_i_ds(Option<Vec<String>>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::set_replication_servers_security_groups_i_ds): <p>The security group IDs that will be used by the replication server.</p>
    ///   - [`replication_server_instance_type(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::replication_server_instance_type) / [`set_replication_server_instance_type(Option<String>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::set_replication_server_instance_type): <p>The instance type to be used for the replication server.</p>
    ///   - [`use_dedicated_replication_server(bool)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::use_dedicated_replication_server) / [`set_use_dedicated_replication_server(Option<bool>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::set_use_dedicated_replication_server): <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
    ///   - [`default_large_staging_disk_type(ReplicationConfigurationDefaultLargeStagingDiskType)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::default_large_staging_disk_type) / [`set_default_large_staging_disk_type(Option<ReplicationConfigurationDefaultLargeStagingDiskType>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::set_default_large_staging_disk_type): <p>The Staging Disk EBS volume type to be used during replication.</p>
    ///   - [`ebs_encryption(ReplicationConfigurationEbsEncryption)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::ebs_encryption) / [`set_ebs_encryption(Option<ReplicationConfigurationEbsEncryption>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::set_ebs_encryption): <p>The type of EBS encryption to be used during replication.</p>
    ///   - [`ebs_encryption_key_arn(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::ebs_encryption_key_arn) / [`set_ebs_encryption_key_arn(Option<String>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::set_ebs_encryption_key_arn): <p>The ARN of the EBS encryption key to be used during replication.</p>
    ///   - [`bandwidth_throttling(i64)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::bandwidth_throttling) / [`set_bandwidth_throttling(i64)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::set_bandwidth_throttling): <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
    ///   - [`data_plane_routing(ReplicationConfigurationDataPlaneRouting)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::data_plane_routing) / [`set_data_plane_routing(Option<ReplicationConfigurationDataPlaneRouting>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::set_data_plane_routing): <p>The data plane routing mechanism that will be used for replication.</p>
    ///   - [`create_public_ip(bool)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::create_public_ip) / [`set_create_public_ip(Option<bool>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::set_create_public_ip): <p>Whether to create a Public IP for the Recovery Instance by default.</p>
    ///   - [`staging_area_tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::staging_area_tags) / [`set_staging_area_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::set_staging_area_tags): <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
    ///   - [`pit_policy(Vec<PitPolicyRule>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::pit_policy) / [`set_pit_policy(Option<Vec<PitPolicyRule>>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::set_pit_policy): <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::set_tags): <p>A set of tags to be associated with the Replication Configuration Template resource.</p>
    /// - On success, responds with [`CreateReplicationConfigurationTemplateOutput`](crate::output::CreateReplicationConfigurationTemplateOutput) with field(s):
    ///   - [`replication_configuration_template_id(Option<String>)`](crate::output::CreateReplicationConfigurationTemplateOutput::replication_configuration_template_id): <p>The Replication Configuration Template ID.</p>
    ///   - [`arn(Option<String>)`](crate::output::CreateReplicationConfigurationTemplateOutput::arn): <p>The Replication Configuration Template ARN.</p>
    ///   - [`staging_area_subnet_id(Option<String>)`](crate::output::CreateReplicationConfigurationTemplateOutput::staging_area_subnet_id): <p>The subnet to be used by the replication staging area.</p>
    ///   - [`associate_default_security_group(Option<bool>)`](crate::output::CreateReplicationConfigurationTemplateOutput::associate_default_security_group): <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>
    ///   - [`replication_servers_security_groups_i_ds(Option<Vec<String>>)`](crate::output::CreateReplicationConfigurationTemplateOutput::replication_servers_security_groups_i_ds): <p>The security group IDs that will be used by the replication server.</p>
    ///   - [`replication_server_instance_type(Option<String>)`](crate::output::CreateReplicationConfigurationTemplateOutput::replication_server_instance_type): <p>The instance type to be used for the replication server.</p>
    ///   - [`use_dedicated_replication_server(Option<bool>)`](crate::output::CreateReplicationConfigurationTemplateOutput::use_dedicated_replication_server): <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
    ///   - [`default_large_staging_disk_type(Option<ReplicationConfigurationDefaultLargeStagingDiskType>)`](crate::output::CreateReplicationConfigurationTemplateOutput::default_large_staging_disk_type): <p>The Staging Disk EBS volume type to be used during replication.</p>
    ///   - [`ebs_encryption(Option<ReplicationConfigurationEbsEncryption>)`](crate::output::CreateReplicationConfigurationTemplateOutput::ebs_encryption): <p>The type of EBS encryption to be used during replication.</p>
    ///   - [`ebs_encryption_key_arn(Option<String>)`](crate::output::CreateReplicationConfigurationTemplateOutput::ebs_encryption_key_arn): <p>The ARN of the EBS encryption key to be used during replication.</p>
    ///   - [`bandwidth_throttling(i64)`](crate::output::CreateReplicationConfigurationTemplateOutput::bandwidth_throttling): <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
    ///   - [`data_plane_routing(Option<ReplicationConfigurationDataPlaneRouting>)`](crate::output::CreateReplicationConfigurationTemplateOutput::data_plane_routing): <p>The data plane routing mechanism that will be used for replication.</p>
    ///   - [`create_public_ip(Option<bool>)`](crate::output::CreateReplicationConfigurationTemplateOutput::create_public_ip): <p>Whether to create a Public IP for the Recovery Instance by default.</p>
    ///   - [`staging_area_tags(Option<HashMap<String, String>>)`](crate::output::CreateReplicationConfigurationTemplateOutput::staging_area_tags): <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateReplicationConfigurationTemplateOutput::tags): <p>A set of tags to be associated with the Replication Configuration Template resource.</p>
    ///   - [`pit_policy(Option<Vec<PitPolicyRule>>)`](crate::output::CreateReplicationConfigurationTemplateOutput::pit_policy): <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
    /// - On failure, responds with [`SdkError<CreateReplicationConfigurationTemplateError>`](crate::error::CreateReplicationConfigurationTemplateError)
    pub fn create_replication_configuration_template(
        &self,
    ) -> fluent_builders::CreateReplicationConfigurationTemplate {
        fluent_builders::CreateReplicationConfigurationTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteJob`](crate::client::fluent_builders::DeleteJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::DeleteJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::DeleteJob::set_job_id): <p>The ID of the Job to be deleted.</p>
    /// - On success, responds with [`DeleteJobOutput`](crate::output::DeleteJobOutput)

    /// - On failure, responds with [`SdkError<DeleteJobError>`](crate::error::DeleteJobError)
    pub fn delete_job(&self) -> fluent_builders::DeleteJob {
        fluent_builders::DeleteJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRecoveryInstance`](crate::client::fluent_builders::DeleteRecoveryInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`recovery_instance_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRecoveryInstance::recovery_instance_id) / [`set_recovery_instance_id(Option<String>)`](crate::client::fluent_builders::DeleteRecoveryInstance::set_recovery_instance_id): <p>RThe ID of the Recovery Instance to be deleted.</p>
    /// - On success, responds with [`DeleteRecoveryInstanceOutput`](crate::output::DeleteRecoveryInstanceOutput)

    /// - On failure, responds with [`SdkError<DeleteRecoveryInstanceError>`](crate::error::DeleteRecoveryInstanceError)
    pub fn delete_recovery_instance(&self) -> fluent_builders::DeleteRecoveryInstance {
        fluent_builders::DeleteRecoveryInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteReplicationConfigurationTemplate`](crate::client::fluent_builders::DeleteReplicationConfigurationTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_configuration_template_id(impl Into<String>)`](crate::client::fluent_builders::DeleteReplicationConfigurationTemplate::replication_configuration_template_id) / [`set_replication_configuration_template_id(Option<String>)`](crate::client::fluent_builders::DeleteReplicationConfigurationTemplate::set_replication_configuration_template_id): <p>The ID of the Replication Configuration Template to be deleted.</p>
    /// - On success, responds with [`DeleteReplicationConfigurationTemplateOutput`](crate::output::DeleteReplicationConfigurationTemplateOutput)

    /// - On failure, responds with [`SdkError<DeleteReplicationConfigurationTemplateError>`](crate::error::DeleteReplicationConfigurationTemplateError)
    pub fn delete_replication_configuration_template(
        &self,
    ) -> fluent_builders::DeleteReplicationConfigurationTemplate {
        fluent_builders::DeleteReplicationConfigurationTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSourceServer`](crate::client::fluent_builders::DeleteSourceServer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_server_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSourceServer::source_server_id) / [`set_source_server_id(Option<String>)`](crate::client::fluent_builders::DeleteSourceServer::set_source_server_id): <p>The ID of the Source Server to be deleted.</p>
    /// - On success, responds with [`DeleteSourceServerOutput`](crate::output::DeleteSourceServerOutput)

    /// - On failure, responds with [`SdkError<DeleteSourceServerError>`](crate::error::DeleteSourceServerError)
    pub fn delete_source_server(&self) -> fluent_builders::DeleteSourceServer {
        fluent_builders::DeleteSourceServer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeJobLogItems`](crate::client::fluent_builders::DescribeJobLogItems) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeJobLogItems::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::DescribeJobLogItems::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::DescribeJobLogItems::set_job_id): <p>The ID of the Job for which Job log items will be retrieved.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeJobLogItems::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeJobLogItems::set_max_results): <p>Maximum number of Job log items to retrieve.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeJobLogItems::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeJobLogItems::set_next_token): <p>The token of the next Job log items to retrieve.</p>
    /// - On success, responds with [`DescribeJobLogItemsOutput`](crate::output::DescribeJobLogItemsOutput) with field(s):
    ///   - [`items(Option<Vec<JobLog>>)`](crate::output::DescribeJobLogItemsOutput::items): <p>An array of Job log items.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeJobLogItemsOutput::next_token): <p>The token of the next Job log items to retrieve.</p>
    /// - On failure, responds with [`SdkError<DescribeJobLogItemsError>`](crate::error::DescribeJobLogItemsError)
    pub fn describe_job_log_items(&self) -> fluent_builders::DescribeJobLogItems {
        fluent_builders::DescribeJobLogItems::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeJobs`](crate::client::fluent_builders::DescribeJobs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeJobs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(DescribeJobsRequestFilters)`](crate::client::fluent_builders::DescribeJobs::filters) / [`set_filters(Option<DescribeJobsRequestFilters>)`](crate::client::fluent_builders::DescribeJobs::set_filters): <p>A set of filters by which to return Jobs.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeJobs::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeJobs::set_max_results): <p>Maximum number of Jobs to retrieve.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeJobs::set_next_token): <p>The token of the next Job to retrieve.</p>
    /// - On success, responds with [`DescribeJobsOutput`](crate::output::DescribeJobsOutput) with field(s):
    ///   - [`items(Option<Vec<Job>>)`](crate::output::DescribeJobsOutput::items): <p>An array of Jobs.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeJobsOutput::next_token): <p>The token of the next Job to retrieve.</p>
    /// - On failure, responds with [`SdkError<DescribeJobsError>`](crate::error::DescribeJobsError)
    pub fn describe_jobs(&self) -> fluent_builders::DescribeJobs {
        fluent_builders::DescribeJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeRecoveryInstances`](crate::client::fluent_builders::DescribeRecoveryInstances) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeRecoveryInstances::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(DescribeRecoveryInstancesRequestFilters)`](crate::client::fluent_builders::DescribeRecoveryInstances::filters) / [`set_filters(Option<DescribeRecoveryInstancesRequestFilters>)`](crate::client::fluent_builders::DescribeRecoveryInstances::set_filters): <p>A set of filters by which to return Recovery Instances.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeRecoveryInstances::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeRecoveryInstances::set_max_results): <p>Maximum number of Recovery Instances to retrieve.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeRecoveryInstances::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeRecoveryInstances::set_next_token): <p>The token of the next Recovery Instance to retrieve.</p>
    /// - On success, responds with [`DescribeRecoveryInstancesOutput`](crate::output::DescribeRecoveryInstancesOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribeRecoveryInstancesOutput::next_token): <p>The token of the next Recovery Instance to retrieve.</p>
    ///   - [`items(Option<Vec<RecoveryInstance>>)`](crate::output::DescribeRecoveryInstancesOutput::items): <p>An array of Recovery Instances.</p>
    /// - On failure, responds with [`SdkError<DescribeRecoveryInstancesError>`](crate::error::DescribeRecoveryInstancesError)
    pub fn describe_recovery_instances(&self) -> fluent_builders::DescribeRecoveryInstances {
        fluent_builders::DescribeRecoveryInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeRecoverySnapshots`](crate::client::fluent_builders::DescribeRecoverySnapshots) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeRecoverySnapshots::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_server_id(impl Into<String>)`](crate::client::fluent_builders::DescribeRecoverySnapshots::source_server_id) / [`set_source_server_id(Option<String>)`](crate::client::fluent_builders::DescribeRecoverySnapshots::set_source_server_id): <p>Filter Recovery Snapshots by Source Server ID.</p>
    ///   - [`filters(DescribeRecoverySnapshotsRequestFilters)`](crate::client::fluent_builders::DescribeRecoverySnapshots::filters) / [`set_filters(Option<DescribeRecoverySnapshotsRequestFilters>)`](crate::client::fluent_builders::DescribeRecoverySnapshots::set_filters): <p>A set of filters by which to return Recovery Snapshots.</p>
    ///   - [`order(RecoverySnapshotsOrder)`](crate::client::fluent_builders::DescribeRecoverySnapshots::order) / [`set_order(Option<RecoverySnapshotsOrder>)`](crate::client::fluent_builders::DescribeRecoverySnapshots::set_order): <p>The sorted ordering by which to return Recovery Snapshots.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeRecoverySnapshots::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeRecoverySnapshots::set_max_results): <p>Maximum number of Recovery Snapshots to retrieve.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeRecoverySnapshots::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeRecoverySnapshots::set_next_token): <p>The token of the next Recovery Snapshot to retrieve.</p>
    /// - On success, responds with [`DescribeRecoverySnapshotsOutput`](crate::output::DescribeRecoverySnapshotsOutput) with field(s):
    ///   - [`items(Option<Vec<RecoverySnapshot>>)`](crate::output::DescribeRecoverySnapshotsOutput::items): <p>An array of Recovery Snapshots.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeRecoverySnapshotsOutput::next_token): <p>The token of the next Recovery Snapshot to retrieve.</p>
    /// - On failure, responds with [`SdkError<DescribeRecoverySnapshotsError>`](crate::error::DescribeRecoverySnapshotsError)
    pub fn describe_recovery_snapshots(&self) -> fluent_builders::DescribeRecoverySnapshots {
        fluent_builders::DescribeRecoverySnapshots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReplicationConfigurationTemplates`](crate::client::fluent_builders::DescribeReplicationConfigurationTemplates) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeReplicationConfigurationTemplates::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_configuration_template_i_ds(Vec<String>)`](crate::client::fluent_builders::DescribeReplicationConfigurationTemplates::replication_configuration_template_i_ds) / [`set_replication_configuration_template_i_ds(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeReplicationConfigurationTemplates::set_replication_configuration_template_i_ds): <p>The IDs of the Replication Configuration Templates to retrieve. An empty list means all Replication Configuration Templates.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeReplicationConfigurationTemplates::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeReplicationConfigurationTemplates::set_max_results): <p>Maximum number of Replication Configuration Templates to retrieve.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeReplicationConfigurationTemplates::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeReplicationConfigurationTemplates::set_next_token): <p>The token of the next Replication Configuration Template to retrieve.</p>
    /// - On success, responds with [`DescribeReplicationConfigurationTemplatesOutput`](crate::output::DescribeReplicationConfigurationTemplatesOutput) with field(s):
    ///   - [`items(Option<Vec<ReplicationConfigurationTemplate>>)`](crate::output::DescribeReplicationConfigurationTemplatesOutput::items): <p>An array of Replication Configuration Templates.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeReplicationConfigurationTemplatesOutput::next_token): <p>The token of the next Replication Configuration Template to retrieve.</p>
    /// - On failure, responds with [`SdkError<DescribeReplicationConfigurationTemplatesError>`](crate::error::DescribeReplicationConfigurationTemplatesError)
    pub fn describe_replication_configuration_templates(
        &self,
    ) -> fluent_builders::DescribeReplicationConfigurationTemplates {
        fluent_builders::DescribeReplicationConfigurationTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSourceServers`](crate::client::fluent_builders::DescribeSourceServers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeSourceServers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(DescribeSourceServersRequestFilters)`](crate::client::fluent_builders::DescribeSourceServers::filters) / [`set_filters(Option<DescribeSourceServersRequestFilters>)`](crate::client::fluent_builders::DescribeSourceServers::set_filters): <p>A set of filters by which to return Source Servers.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeSourceServers::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeSourceServers::set_max_results): <p>Maximum number of Source Servers to retrieve.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeSourceServers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeSourceServers::set_next_token): <p>The token of the next Source Server to retrieve.</p>
    /// - On success, responds with [`DescribeSourceServersOutput`](crate::output::DescribeSourceServersOutput) with field(s):
    ///   - [`items(Option<Vec<SourceServer>>)`](crate::output::DescribeSourceServersOutput::items): <p>An array of Source Servers.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeSourceServersOutput::next_token): <p>The token of the next Source Server to retrieve.</p>
    /// - On failure, responds with [`SdkError<DescribeSourceServersError>`](crate::error::DescribeSourceServersError)
    pub fn describe_source_servers(&self) -> fluent_builders::DescribeSourceServers {
        fluent_builders::DescribeSourceServers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisconnectRecoveryInstance`](crate::client::fluent_builders::DisconnectRecoveryInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`recovery_instance_id(impl Into<String>)`](crate::client::fluent_builders::DisconnectRecoveryInstance::recovery_instance_id) / [`set_recovery_instance_id(Option<String>)`](crate::client::fluent_builders::DisconnectRecoveryInstance::set_recovery_instance_id): <p>The ID of the Recovery Instance to disconnect.</p>
    /// - On success, responds with [`DisconnectRecoveryInstanceOutput`](crate::output::DisconnectRecoveryInstanceOutput)

    /// - On failure, responds with [`SdkError<DisconnectRecoveryInstanceError>`](crate::error::DisconnectRecoveryInstanceError)
    pub fn disconnect_recovery_instance(&self) -> fluent_builders::DisconnectRecoveryInstance {
        fluent_builders::DisconnectRecoveryInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisconnectSourceServer`](crate::client::fluent_builders::DisconnectSourceServer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_server_id(impl Into<String>)`](crate::client::fluent_builders::DisconnectSourceServer::source_server_id) / [`set_source_server_id(Option<String>)`](crate::client::fluent_builders::DisconnectSourceServer::set_source_server_id): <p>The ID of the Source Server to disconnect.</p>
    /// - On success, responds with [`DisconnectSourceServerOutput`](crate::output::DisconnectSourceServerOutput) with field(s):
    ///   - [`source_server_id(Option<String>)`](crate::output::DisconnectSourceServerOutput::source_server_id): <p>The ID of the Source Server.</p>
    ///   - [`arn(Option<String>)`](crate::output::DisconnectSourceServerOutput::arn): <p>The ARN of the Source Server.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::DisconnectSourceServerOutput::tags): <p>The tags associated with the Source Server.</p>
    ///   - [`recovery_instance_id(Option<String>)`](crate::output::DisconnectSourceServerOutput::recovery_instance_id): <p>The ID of the Recovery Instance associated with this Source Server.</p>
    ///   - [`last_launch_result(Option<LastLaunchResult>)`](crate::output::DisconnectSourceServerOutput::last_launch_result): <p>The status of the last recovery launch of this Source Server.</p>
    ///   - [`data_replication_info(Option<DataReplicationInfo>)`](crate::output::DisconnectSourceServerOutput::data_replication_info): <p>The Data Replication Info of the Source Server.</p>
    ///   - [`life_cycle(Option<LifeCycle>)`](crate::output::DisconnectSourceServerOutput::life_cycle): <p>The lifecycle information of this Source Server.</p>
    ///   - [`source_properties(Option<SourceProperties>)`](crate::output::DisconnectSourceServerOutput::source_properties): <p>The source properties of the Source Server.</p>
    /// - On failure, responds with [`SdkError<DisconnectSourceServerError>`](crate::error::DisconnectSourceServerError)
    pub fn disconnect_source_server(&self) -> fluent_builders::DisconnectSourceServer {
        fluent_builders::DisconnectSourceServer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFailbackReplicationConfiguration`](crate::client::fluent_builders::GetFailbackReplicationConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`recovery_instance_id(impl Into<String>)`](crate::client::fluent_builders::GetFailbackReplicationConfiguration::recovery_instance_id) / [`set_recovery_instance_id(Option<String>)`](crate::client::fluent_builders::GetFailbackReplicationConfiguration::set_recovery_instance_id): <p>The ID of the Recovery Instance whose failback replication configuration should be returned.</p>
    /// - On success, responds with [`GetFailbackReplicationConfigurationOutput`](crate::output::GetFailbackReplicationConfigurationOutput) with field(s):
    ///   - [`recovery_instance_id(Option<String>)`](crate::output::GetFailbackReplicationConfigurationOutput::recovery_instance_id): <p>The ID of the Recovery Instance.</p>
    ///   - [`name(Option<String>)`](crate::output::GetFailbackReplicationConfigurationOutput::name): <p>The name of the Failback Replication Configuration.</p>
    ///   - [`bandwidth_throttling(i64)`](crate::output::GetFailbackReplicationConfigurationOutput::bandwidth_throttling): <p>Configure bandwidth throttling for the outbound data transfer rate of the Recovery Instance in Mbps.</p>
    ///   - [`use_private_ip(Option<bool>)`](crate::output::GetFailbackReplicationConfigurationOutput::use_private_ip): <p>Whether to use Private IP for the failback replication of the Recovery Instance.</p>
    /// - On failure, responds with [`SdkError<GetFailbackReplicationConfigurationError>`](crate::error::GetFailbackReplicationConfigurationError)
    pub fn get_failback_replication_configuration(
        &self,
    ) -> fluent_builders::GetFailbackReplicationConfiguration {
        fluent_builders::GetFailbackReplicationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLaunchConfiguration`](crate::client::fluent_builders::GetLaunchConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_server_id(impl Into<String>)`](crate::client::fluent_builders::GetLaunchConfiguration::source_server_id) / [`set_source_server_id(Option<String>)`](crate::client::fluent_builders::GetLaunchConfiguration::set_source_server_id): <p>The ID of the Source Server that we want to retrieve a Launch Configuration for.</p>
    /// - On success, responds with [`GetLaunchConfigurationOutput`](crate::output::GetLaunchConfigurationOutput) with field(s):
    ///   - [`source_server_id(Option<String>)`](crate::output::GetLaunchConfigurationOutput::source_server_id): <p>The ID of the Source Server for this launch configuration.</p>
    ///   - [`name(Option<String>)`](crate::output::GetLaunchConfigurationOutput::name): <p>The name of the launch configuration.</p>
    ///   - [`ec2_launch_template_id(Option<String>)`](crate::output::GetLaunchConfigurationOutput::ec2_launch_template_id): <p>The EC2 launch template ID of this launch configuration.</p>
    ///   - [`launch_disposition(Option<LaunchDisposition>)`](crate::output::GetLaunchConfigurationOutput::launch_disposition): <p>The state of the Recovery Instance in EC2 after the recovery operation.</p>
    ///   - [`target_instance_type_right_sizing_method(Option<TargetInstanceTypeRightSizingMethod>)`](crate::output::GetLaunchConfigurationOutput::target_instance_type_right_sizing_method): <p>Whether Elastic Disaster Recovery should try to automatically choose the instance type that best matches the OS, CPU, and RAM of your Source Server.</p>
    ///   - [`copy_private_ip(Option<bool>)`](crate::output::GetLaunchConfigurationOutput::copy_private_ip): <p>Whether we should copy the Private IP of the Source Server to the Recovery Instance.</p>
    ///   - [`copy_tags(Option<bool>)`](crate::output::GetLaunchConfigurationOutput::copy_tags): <p>Whether we want to copy the tags of the Source Server to the EC2 machine of the Recovery Instance.</p>
    ///   - [`licensing(Option<Licensing>)`](crate::output::GetLaunchConfigurationOutput::licensing): <p>The licensing configuration to be used for this launch configuration.</p>
    /// - On failure, responds with [`SdkError<GetLaunchConfigurationError>`](crate::error::GetLaunchConfigurationError)
    pub fn get_launch_configuration(&self) -> fluent_builders::GetLaunchConfiguration {
        fluent_builders::GetLaunchConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetReplicationConfiguration`](crate::client::fluent_builders::GetReplicationConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_server_id(impl Into<String>)`](crate::client::fluent_builders::GetReplicationConfiguration::source_server_id) / [`set_source_server_id(Option<String>)`](crate::client::fluent_builders::GetReplicationConfiguration::set_source_server_id): <p>The ID of the Source Serve for this Replication Configuration.r</p>
    /// - On success, responds with [`GetReplicationConfigurationOutput`](crate::output::GetReplicationConfigurationOutput) with field(s):
    ///   - [`source_server_id(Option<String>)`](crate::output::GetReplicationConfigurationOutput::source_server_id): <p>The ID of the Source Server for this Replication Configuration.</p>
    ///   - [`name(Option<String>)`](crate::output::GetReplicationConfigurationOutput::name): <p>The name of the Replication Configuration.</p>
    ///   - [`staging_area_subnet_id(Option<String>)`](crate::output::GetReplicationConfigurationOutput::staging_area_subnet_id): <p>The subnet to be used by the replication staging area.</p>
    ///   - [`associate_default_security_group(Option<bool>)`](crate::output::GetReplicationConfigurationOutput::associate_default_security_group): <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration.</p>
    ///   - [`replication_servers_security_groups_i_ds(Option<Vec<String>>)`](crate::output::GetReplicationConfigurationOutput::replication_servers_security_groups_i_ds): <p>The security group IDs that will be used by the replication server.</p>
    ///   - [`replication_server_instance_type(Option<String>)`](crate::output::GetReplicationConfigurationOutput::replication_server_instance_type): <p>The instance type to be used for the replication server.</p>
    ///   - [`use_dedicated_replication_server(Option<bool>)`](crate::output::GetReplicationConfigurationOutput::use_dedicated_replication_server): <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
    ///   - [`default_large_staging_disk_type(Option<ReplicationConfigurationDefaultLargeStagingDiskType>)`](crate::output::GetReplicationConfigurationOutput::default_large_staging_disk_type): <p>The Staging Disk EBS volume type to be used during replication.</p>
    ///   - [`replicated_disks(Option<Vec<ReplicationConfigurationReplicatedDisk>>)`](crate::output::GetReplicationConfigurationOutput::replicated_disks): <p>The configuration of the disks of the Source Server to be replicated.</p>
    ///   - [`ebs_encryption(Option<ReplicationConfigurationEbsEncryption>)`](crate::output::GetReplicationConfigurationOutput::ebs_encryption): <p>The type of EBS encryption to be used during replication.</p>
    ///   - [`ebs_encryption_key_arn(Option<String>)`](crate::output::GetReplicationConfigurationOutput::ebs_encryption_key_arn): <p>The ARN of the EBS encryption key to be used during replication.</p>
    ///   - [`bandwidth_throttling(i64)`](crate::output::GetReplicationConfigurationOutput::bandwidth_throttling): <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
    ///   - [`data_plane_routing(Option<ReplicationConfigurationDataPlaneRouting>)`](crate::output::GetReplicationConfigurationOutput::data_plane_routing): <p>The data plane routing mechanism that will be used for replication.</p>
    ///   - [`create_public_ip(Option<bool>)`](crate::output::GetReplicationConfigurationOutput::create_public_ip): <p>Whether to create a Public IP for the Recovery Instance by default.</p>
    ///   - [`staging_area_tags(Option<HashMap<String, String>>)`](crate::output::GetReplicationConfigurationOutput::staging_area_tags): <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
    ///   - [`pit_policy(Option<Vec<PitPolicyRule>>)`](crate::output::GetReplicationConfigurationOutput::pit_policy): <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
    /// - On failure, responds with [`SdkError<GetReplicationConfigurationError>`](crate::error::GetReplicationConfigurationError)
    pub fn get_replication_configuration(&self) -> fluent_builders::GetReplicationConfiguration {
        fluent_builders::GetReplicationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`InitializeService`](crate::client::fluent_builders::InitializeService) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::InitializeService::send) it.

    /// - On success, responds with [`InitializeServiceOutput`](crate::output::InitializeServiceOutput)

    /// - On failure, responds with [`SdkError<InitializeServiceError>`](crate::error::InitializeServiceError)
    pub fn initialize_service(&self) -> fluent_builders::InitializeService {
        fluent_builders::InitializeService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The ARN of the resource whose tags should be returned.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags of the requested resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RetryDataReplication`](crate::client::fluent_builders::RetryDataReplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_server_id(impl Into<String>)`](crate::client::fluent_builders::RetryDataReplication::source_server_id) / [`set_source_server_id(Option<String>)`](crate::client::fluent_builders::RetryDataReplication::set_source_server_id): <p>The ID of the Source Server whose data replication should be retried.</p>
    /// - On success, responds with [`RetryDataReplicationOutput`](crate::output::RetryDataReplicationOutput) with field(s):
    ///   - [`source_server_id(Option<String>)`](crate::output::RetryDataReplicationOutput::source_server_id): <p>The ID of the Source Server.</p>
    ///   - [`arn(Option<String>)`](crate::output::RetryDataReplicationOutput::arn): <p>The ARN of the Source Server.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::RetryDataReplicationOutput::tags): <p>The tags associated with the Source Server.</p>
    ///   - [`recovery_instance_id(Option<String>)`](crate::output::RetryDataReplicationOutput::recovery_instance_id): <p>The ID of the Recovery Instance associated with this Source Server.</p>
    ///   - [`last_launch_result(Option<LastLaunchResult>)`](crate::output::RetryDataReplicationOutput::last_launch_result): <p>The status of the last recovery launch of this Source Server.</p>
    ///   - [`data_replication_info(Option<DataReplicationInfo>)`](crate::output::RetryDataReplicationOutput::data_replication_info): <p>The Data Replication Info of the Source Server.</p>
    ///   - [`life_cycle(Option<LifeCycle>)`](crate::output::RetryDataReplicationOutput::life_cycle): <p>The lifecycle information of this Source Server.</p>
    ///   - [`source_properties(Option<SourceProperties>)`](crate::output::RetryDataReplicationOutput::source_properties): <p>The source properties of the Source Server.</p>
    /// - On failure, responds with [`SdkError<RetryDataReplicationError>`](crate::error::RetryDataReplicationError)
    pub fn retry_data_replication(&self) -> fluent_builders::RetryDataReplication {
        fluent_builders::RetryDataReplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartFailbackLaunch`](crate::client::fluent_builders::StartFailbackLaunch) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`recovery_instance_i_ds(Vec<String>)`](crate::client::fluent_builders::StartFailbackLaunch::recovery_instance_i_ds) / [`set_recovery_instance_i_ds(Option<Vec<String>>)`](crate::client::fluent_builders::StartFailbackLaunch::set_recovery_instance_i_ds): <p>The IDs of the Recovery Instance whose failback launch we want to request.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::StartFailbackLaunch::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::StartFailbackLaunch::set_tags): <p>The tags to be associated with the failback launch Job.</p>
    /// - On success, responds with [`StartFailbackLaunchOutput`](crate::output::StartFailbackLaunchOutput) with field(s):
    ///   - [`job(Option<Job>)`](crate::output::StartFailbackLaunchOutput::job): <p>The failback launch Job.</p>
    /// - On failure, responds with [`SdkError<StartFailbackLaunchError>`](crate::error::StartFailbackLaunchError)
    pub fn start_failback_launch(&self) -> fluent_builders::StartFailbackLaunch {
        fluent_builders::StartFailbackLaunch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartRecovery`](crate::client::fluent_builders::StartRecovery) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_servers(Vec<StartRecoveryRequestSourceServer>)`](crate::client::fluent_builders::StartRecovery::source_servers) / [`set_source_servers(Option<Vec<StartRecoveryRequestSourceServer>>)`](crate::client::fluent_builders::StartRecovery::set_source_servers): <p>The Source Servers that we want to start a Recovery Job for.</p>
    ///   - [`is_drill(bool)`](crate::client::fluent_builders::StartRecovery::is_drill) / [`set_is_drill(Option<bool>)`](crate::client::fluent_builders::StartRecovery::set_is_drill): <p>Whether this Source Server Recovery operation is a drill or not.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::StartRecovery::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::StartRecovery::set_tags): <p>The tags to be associated with the Recovery Job.</p>
    /// - On success, responds with [`StartRecoveryOutput`](crate::output::StartRecoveryOutput) with field(s):
    ///   - [`job(Option<Job>)`](crate::output::StartRecoveryOutput::job): <p>The Recovery Job.</p>
    /// - On failure, responds with [`SdkError<StartRecoveryError>`](crate::error::StartRecoveryError)
    pub fn start_recovery(&self) -> fluent_builders::StartRecovery {
        fluent_builders::StartRecovery::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopFailback`](crate::client::fluent_builders::StopFailback) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`recovery_instance_id(impl Into<String>)`](crate::client::fluent_builders::StopFailback::recovery_instance_id) / [`set_recovery_instance_id(Option<String>)`](crate::client::fluent_builders::StopFailback::set_recovery_instance_id): <p>The ID of the Recovery Instance we want to stop failback for.</p>
    /// - On success, responds with [`StopFailbackOutput`](crate::output::StopFailbackOutput)

    /// - On failure, responds with [`SdkError<StopFailbackError>`](crate::error::StopFailbackError)
    pub fn stop_failback(&self) -> fluent_builders::StopFailback {
        fluent_builders::StopFailback::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>ARN of the resource for which tags are to be added or updated.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>Array of tags to be added or updated.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TerminateRecoveryInstances`](crate::client::fluent_builders::TerminateRecoveryInstances) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`recovery_instance_i_ds(Vec<String>)`](crate::client::fluent_builders::TerminateRecoveryInstances::recovery_instance_i_ds) / [`set_recovery_instance_i_ds(Option<Vec<String>>)`](crate::client::fluent_builders::TerminateRecoveryInstances::set_recovery_instance_i_ds): <p>The IDs of the Recovery Instances that should be terminated.</p>
    /// - On success, responds with [`TerminateRecoveryInstancesOutput`](crate::output::TerminateRecoveryInstancesOutput) with field(s):
    ///   - [`job(Option<Job>)`](crate::output::TerminateRecoveryInstancesOutput::job): <p>The Job for terminating the Recovery Instances.</p>
    /// - On failure, responds with [`SdkError<TerminateRecoveryInstancesError>`](crate::error::TerminateRecoveryInstancesError)
    pub fn terminate_recovery_instances(&self) -> fluent_builders::TerminateRecoveryInstances {
        fluent_builders::TerminateRecoveryInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>ARN of the resource for which tags are to be removed.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>Array of tags to be removed.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFailbackReplicationConfiguration`](crate::client::fluent_builders::UpdateFailbackReplicationConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`recovery_instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateFailbackReplicationConfiguration::recovery_instance_id) / [`set_recovery_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateFailbackReplicationConfiguration::set_recovery_instance_id): <p>The ID of the Recovery Instance.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateFailbackReplicationConfiguration::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateFailbackReplicationConfiguration::set_name): <p>The name of the Failback Replication Configuration.</p>
    ///   - [`bandwidth_throttling(i64)`](crate::client::fluent_builders::UpdateFailbackReplicationConfiguration::bandwidth_throttling) / [`set_bandwidth_throttling(i64)`](crate::client::fluent_builders::UpdateFailbackReplicationConfiguration::set_bandwidth_throttling): <p>Configure bandwidth throttling for the outbound data transfer rate of the Recovery Instance in Mbps.</p>
    ///   - [`use_private_ip(bool)`](crate::client::fluent_builders::UpdateFailbackReplicationConfiguration::use_private_ip) / [`set_use_private_ip(Option<bool>)`](crate::client::fluent_builders::UpdateFailbackReplicationConfiguration::set_use_private_ip): <p>Whether to use Private IP for the failback replication of the Recovery Instance.</p>
    /// - On success, responds with [`UpdateFailbackReplicationConfigurationOutput`](crate::output::UpdateFailbackReplicationConfigurationOutput)

    /// - On failure, responds with [`SdkError<UpdateFailbackReplicationConfigurationError>`](crate::error::UpdateFailbackReplicationConfigurationError)
    pub fn update_failback_replication_configuration(
        &self,
    ) -> fluent_builders::UpdateFailbackReplicationConfiguration {
        fluent_builders::UpdateFailbackReplicationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateLaunchConfiguration`](crate::client::fluent_builders::UpdateLaunchConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_server_id(impl Into<String>)`](crate::client::fluent_builders::UpdateLaunchConfiguration::source_server_id) / [`set_source_server_id(Option<String>)`](crate::client::fluent_builders::UpdateLaunchConfiguration::set_source_server_id): <p>The ID of the Source Server that we want to retrieve a Launch Configuration for.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateLaunchConfiguration::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateLaunchConfiguration::set_name): <p>The name of the launch configuration.</p>
    ///   - [`launch_disposition(LaunchDisposition)`](crate::client::fluent_builders::UpdateLaunchConfiguration::launch_disposition) / [`set_launch_disposition(Option<LaunchDisposition>)`](crate::client::fluent_builders::UpdateLaunchConfiguration::set_launch_disposition): <p>The state of the Recovery Instance in EC2 after the recovery operation.</p>
    ///   - [`target_instance_type_right_sizing_method(TargetInstanceTypeRightSizingMethod)`](crate::client::fluent_builders::UpdateLaunchConfiguration::target_instance_type_right_sizing_method) / [`set_target_instance_type_right_sizing_method(Option<TargetInstanceTypeRightSizingMethod>)`](crate::client::fluent_builders::UpdateLaunchConfiguration::set_target_instance_type_right_sizing_method): <p>Whether Elastic Disaster Recovery should try to automatically choose the instance type that best matches the OS, CPU, and RAM of your Source Server.</p>
    ///   - [`copy_private_ip(bool)`](crate::client::fluent_builders::UpdateLaunchConfiguration::copy_private_ip) / [`set_copy_private_ip(Option<bool>)`](crate::client::fluent_builders::UpdateLaunchConfiguration::set_copy_private_ip): <p>Whether we should copy the Private IP of the Source Server to the Recovery Instance.</p>
    ///   - [`copy_tags(bool)`](crate::client::fluent_builders::UpdateLaunchConfiguration::copy_tags) / [`set_copy_tags(Option<bool>)`](crate::client::fluent_builders::UpdateLaunchConfiguration::set_copy_tags): <p>Whether we want to copy the tags of the Source Server to the EC2 machine of the Recovery Instance.</p>
    ///   - [`licensing(Licensing)`](crate::client::fluent_builders::UpdateLaunchConfiguration::licensing) / [`set_licensing(Option<Licensing>)`](crate::client::fluent_builders::UpdateLaunchConfiguration::set_licensing): <p>The licensing configuration to be used for this launch configuration.</p>
    /// - On success, responds with [`UpdateLaunchConfigurationOutput`](crate::output::UpdateLaunchConfigurationOutput) with field(s):
    ///   - [`source_server_id(Option<String>)`](crate::output::UpdateLaunchConfigurationOutput::source_server_id): <p>The ID of the Source Server for this launch configuration.</p>
    ///   - [`name(Option<String>)`](crate::output::UpdateLaunchConfigurationOutput::name): <p>The name of the launch configuration.</p>
    ///   - [`ec2_launch_template_id(Option<String>)`](crate::output::UpdateLaunchConfigurationOutput::ec2_launch_template_id): <p>The EC2 launch template ID of this launch configuration.</p>
    ///   - [`launch_disposition(Option<LaunchDisposition>)`](crate::output::UpdateLaunchConfigurationOutput::launch_disposition): <p>The state of the Recovery Instance in EC2 after the recovery operation.</p>
    ///   - [`target_instance_type_right_sizing_method(Option<TargetInstanceTypeRightSizingMethod>)`](crate::output::UpdateLaunchConfigurationOutput::target_instance_type_right_sizing_method): <p>Whether Elastic Disaster Recovery should try to automatically choose the instance type that best matches the OS, CPU, and RAM of your Source Server.</p>
    ///   - [`copy_private_ip(Option<bool>)`](crate::output::UpdateLaunchConfigurationOutput::copy_private_ip): <p>Whether we should copy the Private IP of the Source Server to the Recovery Instance.</p>
    ///   - [`copy_tags(Option<bool>)`](crate::output::UpdateLaunchConfigurationOutput::copy_tags): <p>Whether we want to copy the tags of the Source Server to the EC2 machine of the Recovery Instance.</p>
    ///   - [`licensing(Option<Licensing>)`](crate::output::UpdateLaunchConfigurationOutput::licensing): <p>The licensing configuration to be used for this launch configuration.</p>
    /// - On failure, responds with [`SdkError<UpdateLaunchConfigurationError>`](crate::error::UpdateLaunchConfigurationError)
    pub fn update_launch_configuration(&self) -> fluent_builders::UpdateLaunchConfiguration {
        fluent_builders::UpdateLaunchConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateReplicationConfiguration`](crate::client::fluent_builders::UpdateReplicationConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_server_id(impl Into<String>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::source_server_id) / [`set_source_server_id(Option<String>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::set_source_server_id): <p>The ID of the Source Server for this Replication Configuration.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::set_name): <p>The name of the Replication Configuration.</p>
    ///   - [`staging_area_subnet_id(impl Into<String>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::staging_area_subnet_id) / [`set_staging_area_subnet_id(Option<String>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::set_staging_area_subnet_id): <p>The subnet to be used by the replication staging area.</p>
    ///   - [`associate_default_security_group(bool)`](crate::client::fluent_builders::UpdateReplicationConfiguration::associate_default_security_group) / [`set_associate_default_security_group(Option<bool>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::set_associate_default_security_group): <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration.</p>
    ///   - [`replication_servers_security_groups_i_ds(Vec<String>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::replication_servers_security_groups_i_ds) / [`set_replication_servers_security_groups_i_ds(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::set_replication_servers_security_groups_i_ds): <p>The security group IDs that will be used by the replication server.</p>
    ///   - [`replication_server_instance_type(impl Into<String>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::replication_server_instance_type) / [`set_replication_server_instance_type(Option<String>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::set_replication_server_instance_type): <p>The instance type to be used for the replication server.</p>
    ///   - [`use_dedicated_replication_server(bool)`](crate::client::fluent_builders::UpdateReplicationConfiguration::use_dedicated_replication_server) / [`set_use_dedicated_replication_server(Option<bool>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::set_use_dedicated_replication_server): <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
    ///   - [`default_large_staging_disk_type(ReplicationConfigurationDefaultLargeStagingDiskType)`](crate::client::fluent_builders::UpdateReplicationConfiguration::default_large_staging_disk_type) / [`set_default_large_staging_disk_type(Option<ReplicationConfigurationDefaultLargeStagingDiskType>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::set_default_large_staging_disk_type): <p>The Staging Disk EBS volume type to be used during replication.</p>
    ///   - [`replicated_disks(Vec<ReplicationConfigurationReplicatedDisk>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::replicated_disks) / [`set_replicated_disks(Option<Vec<ReplicationConfigurationReplicatedDisk>>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::set_replicated_disks): <p>The configuration of the disks of the Source Server to be replicated.</p>
    ///   - [`ebs_encryption(ReplicationConfigurationEbsEncryption)`](crate::client::fluent_builders::UpdateReplicationConfiguration::ebs_encryption) / [`set_ebs_encryption(Option<ReplicationConfigurationEbsEncryption>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::set_ebs_encryption): <p>The type of EBS encryption to be used during replication.</p>
    ///   - [`ebs_encryption_key_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::ebs_encryption_key_arn) / [`set_ebs_encryption_key_arn(Option<String>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::set_ebs_encryption_key_arn): <p>The ARN of the EBS encryption key to be used during replication.</p>
    ///   - [`bandwidth_throttling(i64)`](crate::client::fluent_builders::UpdateReplicationConfiguration::bandwidth_throttling) / [`set_bandwidth_throttling(i64)`](crate::client::fluent_builders::UpdateReplicationConfiguration::set_bandwidth_throttling): <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
    ///   - [`data_plane_routing(ReplicationConfigurationDataPlaneRouting)`](crate::client::fluent_builders::UpdateReplicationConfiguration::data_plane_routing) / [`set_data_plane_routing(Option<ReplicationConfigurationDataPlaneRouting>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::set_data_plane_routing): <p>The data plane routing mechanism that will be used for replication.</p>
    ///   - [`create_public_ip(bool)`](crate::client::fluent_builders::UpdateReplicationConfiguration::create_public_ip) / [`set_create_public_ip(Option<bool>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::set_create_public_ip): <p>Whether to create a Public IP for the Recovery Instance by default.</p>
    ///   - [`staging_area_tags(HashMap<String, String>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::staging_area_tags) / [`set_staging_area_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::set_staging_area_tags): <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
    ///   - [`pit_policy(Vec<PitPolicyRule>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::pit_policy) / [`set_pit_policy(Option<Vec<PitPolicyRule>>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::set_pit_policy): <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
    /// - On success, responds with [`UpdateReplicationConfigurationOutput`](crate::output::UpdateReplicationConfigurationOutput) with field(s):
    ///   - [`source_server_id(Option<String>)`](crate::output::UpdateReplicationConfigurationOutput::source_server_id): <p>The ID of the Source Server for this Replication Configuration.</p>
    ///   - [`name(Option<String>)`](crate::output::UpdateReplicationConfigurationOutput::name): <p>The name of the Replication Configuration.</p>
    ///   - [`staging_area_subnet_id(Option<String>)`](crate::output::UpdateReplicationConfigurationOutput::staging_area_subnet_id): <p>The subnet to be used by the replication staging area.</p>
    ///   - [`associate_default_security_group(Option<bool>)`](crate::output::UpdateReplicationConfigurationOutput::associate_default_security_group): <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration.</p>
    ///   - [`replication_servers_security_groups_i_ds(Option<Vec<String>>)`](crate::output::UpdateReplicationConfigurationOutput::replication_servers_security_groups_i_ds): <p>The security group IDs that will be used by the replication server.</p>
    ///   - [`replication_server_instance_type(Option<String>)`](crate::output::UpdateReplicationConfigurationOutput::replication_server_instance_type): <p>The instance type to be used for the replication server.</p>
    ///   - [`use_dedicated_replication_server(Option<bool>)`](crate::output::UpdateReplicationConfigurationOutput::use_dedicated_replication_server): <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
    ///   - [`default_large_staging_disk_type(Option<ReplicationConfigurationDefaultLargeStagingDiskType>)`](crate::output::UpdateReplicationConfigurationOutput::default_large_staging_disk_type): <p>The Staging Disk EBS volume type to be used during replication.</p>
    ///   - [`replicated_disks(Option<Vec<ReplicationConfigurationReplicatedDisk>>)`](crate::output::UpdateReplicationConfigurationOutput::replicated_disks): <p>The configuration of the disks of the Source Server to be replicated.</p>
    ///   - [`ebs_encryption(Option<ReplicationConfigurationEbsEncryption>)`](crate::output::UpdateReplicationConfigurationOutput::ebs_encryption): <p>The type of EBS encryption to be used during replication.</p>
    ///   - [`ebs_encryption_key_arn(Option<String>)`](crate::output::UpdateReplicationConfigurationOutput::ebs_encryption_key_arn): <p>The ARN of the EBS encryption key to be used during replication.</p>
    ///   - [`bandwidth_throttling(i64)`](crate::output::UpdateReplicationConfigurationOutput::bandwidth_throttling): <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
    ///   - [`data_plane_routing(Option<ReplicationConfigurationDataPlaneRouting>)`](crate::output::UpdateReplicationConfigurationOutput::data_plane_routing): <p>The data plane routing mechanism that will be used for replication.</p>
    ///   - [`create_public_ip(Option<bool>)`](crate::output::UpdateReplicationConfigurationOutput::create_public_ip): <p>Whether to create a Public IP for the Recovery Instance by default.</p>
    ///   - [`staging_area_tags(Option<HashMap<String, String>>)`](crate::output::UpdateReplicationConfigurationOutput::staging_area_tags): <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
    ///   - [`pit_policy(Option<Vec<PitPolicyRule>>)`](crate::output::UpdateReplicationConfigurationOutput::pit_policy): <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
    /// - On failure, responds with [`SdkError<UpdateReplicationConfigurationError>`](crate::error::UpdateReplicationConfigurationError)
    pub fn update_replication_configuration(
        &self,
    ) -> fluent_builders::UpdateReplicationConfiguration {
        fluent_builders::UpdateReplicationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateReplicationConfigurationTemplate`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_configuration_template_id(impl Into<String>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::replication_configuration_template_id) / [`set_replication_configuration_template_id(Option<String>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::set_replication_configuration_template_id): <p>The Replication Configuration Template ID.</p>
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::set_arn): <p>The Replication Configuration Template ARN.</p>
    ///   - [`staging_area_subnet_id(impl Into<String>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::staging_area_subnet_id) / [`set_staging_area_subnet_id(Option<String>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::set_staging_area_subnet_id): <p>The subnet to be used by the replication staging area.</p>
    ///   - [`associate_default_security_group(bool)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::associate_default_security_group) / [`set_associate_default_security_group(Option<bool>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::set_associate_default_security_group): <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>
    ///   - [`replication_servers_security_groups_i_ds(Vec<String>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::replication_servers_security_groups_i_ds) / [`set_replication_servers_security_groups_i_ds(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::set_replication_servers_security_groups_i_ds): <p>The security group IDs that will be used by the replication server.</p>
    ///   - [`replication_server_instance_type(impl Into<String>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::replication_server_instance_type) / [`set_replication_server_instance_type(Option<String>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::set_replication_server_instance_type): <p>The instance type to be used for the replication server.</p>
    ///   - [`use_dedicated_replication_server(bool)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::use_dedicated_replication_server) / [`set_use_dedicated_replication_server(Option<bool>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::set_use_dedicated_replication_server): <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
    ///   - [`default_large_staging_disk_type(ReplicationConfigurationDefaultLargeStagingDiskType)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::default_large_staging_disk_type) / [`set_default_large_staging_disk_type(Option<ReplicationConfigurationDefaultLargeStagingDiskType>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::set_default_large_staging_disk_type): <p>The Staging Disk EBS volume type to be used during replication.</p>
    ///   - [`ebs_encryption(ReplicationConfigurationEbsEncryption)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::ebs_encryption) / [`set_ebs_encryption(Option<ReplicationConfigurationEbsEncryption>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::set_ebs_encryption): <p>The type of EBS encryption to be used during replication.</p>
    ///   - [`ebs_encryption_key_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::ebs_encryption_key_arn) / [`set_ebs_encryption_key_arn(Option<String>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::set_ebs_encryption_key_arn): <p>The ARN of the EBS encryption key to be used during replication.</p>
    ///   - [`bandwidth_throttling(i64)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::bandwidth_throttling) / [`set_bandwidth_throttling(i64)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::set_bandwidth_throttling): <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
    ///   - [`data_plane_routing(ReplicationConfigurationDataPlaneRouting)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::data_plane_routing) / [`set_data_plane_routing(Option<ReplicationConfigurationDataPlaneRouting>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::set_data_plane_routing): <p>The data plane routing mechanism that will be used for replication.</p>
    ///   - [`create_public_ip(bool)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::create_public_ip) / [`set_create_public_ip(Option<bool>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::set_create_public_ip): <p>Whether to create a Public IP for the Recovery Instance by default.</p>
    ///   - [`staging_area_tags(HashMap<String, String>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::staging_area_tags) / [`set_staging_area_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::set_staging_area_tags): <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
    ///   - [`pit_policy(Vec<PitPolicyRule>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::pit_policy) / [`set_pit_policy(Option<Vec<PitPolicyRule>>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::set_pit_policy): <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
    /// - On success, responds with [`UpdateReplicationConfigurationTemplateOutput`](crate::output::UpdateReplicationConfigurationTemplateOutput) with field(s):
    ///   - [`replication_configuration_template_id(Option<String>)`](crate::output::UpdateReplicationConfigurationTemplateOutput::replication_configuration_template_id): <p>The Replication Configuration Template ID.</p>
    ///   - [`arn(Option<String>)`](crate::output::UpdateReplicationConfigurationTemplateOutput::arn): <p>The Replication Configuration Template ARN.</p>
    ///   - [`staging_area_subnet_id(Option<String>)`](crate::output::UpdateReplicationConfigurationTemplateOutput::staging_area_subnet_id): <p>The subnet to be used by the replication staging area.</p>
    ///   - [`associate_default_security_group(Option<bool>)`](crate::output::UpdateReplicationConfigurationTemplateOutput::associate_default_security_group): <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>
    ///   - [`replication_servers_security_groups_i_ds(Option<Vec<String>>)`](crate::output::UpdateReplicationConfigurationTemplateOutput::replication_servers_security_groups_i_ds): <p>The security group IDs that will be used by the replication server.</p>
    ///   - [`replication_server_instance_type(Option<String>)`](crate::output::UpdateReplicationConfigurationTemplateOutput::replication_server_instance_type): <p>The instance type to be used for the replication server.</p>
    ///   - [`use_dedicated_replication_server(Option<bool>)`](crate::output::UpdateReplicationConfigurationTemplateOutput::use_dedicated_replication_server): <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
    ///   - [`default_large_staging_disk_type(Option<ReplicationConfigurationDefaultLargeStagingDiskType>)`](crate::output::UpdateReplicationConfigurationTemplateOutput::default_large_staging_disk_type): <p>The Staging Disk EBS volume type to be used during replication.</p>
    ///   - [`ebs_encryption(Option<ReplicationConfigurationEbsEncryption>)`](crate::output::UpdateReplicationConfigurationTemplateOutput::ebs_encryption): <p>The type of EBS encryption to be used during replication.</p>
    ///   - [`ebs_encryption_key_arn(Option<String>)`](crate::output::UpdateReplicationConfigurationTemplateOutput::ebs_encryption_key_arn): <p>The ARN of the EBS encryption key to be used during replication.</p>
    ///   - [`bandwidth_throttling(i64)`](crate::output::UpdateReplicationConfigurationTemplateOutput::bandwidth_throttling): <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
    ///   - [`data_plane_routing(Option<ReplicationConfigurationDataPlaneRouting>)`](crate::output::UpdateReplicationConfigurationTemplateOutput::data_plane_routing): <p>The data plane routing mechanism that will be used for replication.</p>
    ///   - [`create_public_ip(Option<bool>)`](crate::output::UpdateReplicationConfigurationTemplateOutput::create_public_ip): <p>Whether to create a Public IP for the Recovery Instance by default.</p>
    ///   - [`staging_area_tags(Option<HashMap<String, String>>)`](crate::output::UpdateReplicationConfigurationTemplateOutput::staging_area_tags): <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::UpdateReplicationConfigurationTemplateOutput::tags): <p>A set of tags to be associated with the Replication Configuration Template resource.</p>
    ///   - [`pit_policy(Option<Vec<PitPolicyRule>>)`](crate::output::UpdateReplicationConfigurationTemplateOutput::pit_policy): <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
    /// - On failure, responds with [`SdkError<UpdateReplicationConfigurationTemplateError>`](crate::error::UpdateReplicationConfigurationTemplateError)
    pub fn update_replication_configuration_template(
        &self,
    ) -> fluent_builders::UpdateReplicationConfigurationTemplate {
        fluent_builders::UpdateReplicationConfigurationTemplate::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateReplicationConfigurationTemplate`.
    ///
    /// <p>Creates a new ReplicationConfigurationTemplate.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateReplicationConfigurationTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_replication_configuration_template_input::Builder,
    }
    impl CreateReplicationConfigurationTemplate {
        /// Creates a new `CreateReplicationConfigurationTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateReplicationConfigurationTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateReplicationConfigurationTemplateError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The subnet to be used by the replication staging area.</p>
        pub fn staging_area_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.staging_area_subnet_id(input.into());
            self
        }
        /// <p>The subnet to be used by the replication staging area.</p>
        pub fn set_staging_area_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_staging_area_subnet_id(input);
            self
        }
        /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>
        pub fn associate_default_security_group(mut self, input: bool) -> Self {
            self.inner = self.inner.associate_default_security_group(input);
            self
        }
        /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>
        pub fn set_associate_default_security_group(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_associate_default_security_group(input);
            self
        }
        /// Appends an item to `replicationServersSecurityGroupsIDs`.
        ///
        /// To override the contents of this collection use [`set_replication_servers_security_groups_i_ds`](Self::set_replication_servers_security_groups_i_ds).
        ///
        /// <p>The security group IDs that will be used by the replication server.</p>
        pub fn replication_servers_security_groups_i_ds(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .replication_servers_security_groups_i_ds(input.into());
            self
        }
        /// <p>The security group IDs that will be used by the replication server.</p>
        pub fn set_replication_servers_security_groups_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_replication_servers_security_groups_i_ds(input);
            self
        }
        /// <p>The instance type to be used for the replication server.</p>
        pub fn replication_server_instance_type(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_server_instance_type(input.into());
            self
        }
        /// <p>The instance type to be used for the replication server.</p>
        pub fn set_replication_server_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_server_instance_type(input);
            self
        }
        /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
        pub fn use_dedicated_replication_server(mut self, input: bool) -> Self {
            self.inner = self.inner.use_dedicated_replication_server(input);
            self
        }
        /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
        pub fn set_use_dedicated_replication_server(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_use_dedicated_replication_server(input);
            self
        }
        /// <p>The Staging Disk EBS volume type to be used during replication.</p>
        pub fn default_large_staging_disk_type(
            mut self,
            input: crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
        ) -> Self {
            self.inner = self.inner.default_large_staging_disk_type(input);
            self
        }
        /// <p>The Staging Disk EBS volume type to be used during replication.</p>
        pub fn set_default_large_staging_disk_type(
            mut self,
            input: std::option::Option<
                crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
            >,
        ) -> Self {
            self.inner = self.inner.set_default_large_staging_disk_type(input);
            self
        }
        /// <p>The type of EBS encryption to be used during replication.</p>
        pub fn ebs_encryption(
            mut self,
            input: crate::model::ReplicationConfigurationEbsEncryption,
        ) -> Self {
            self.inner = self.inner.ebs_encryption(input);
            self
        }
        /// <p>The type of EBS encryption to be used during replication.</p>
        pub fn set_ebs_encryption(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        ) -> Self {
            self.inner = self.inner.set_ebs_encryption(input);
            self
        }
        /// <p>The ARN of the EBS encryption key to be used during replication.</p>
        pub fn ebs_encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ebs_encryption_key_arn(input.into());
            self
        }
        /// <p>The ARN of the EBS encryption key to be used during replication.</p>
        pub fn set_ebs_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ebs_encryption_key_arn(input);
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
        pub fn bandwidth_throttling(mut self, input: i64) -> Self {
            self.inner = self.inner.bandwidth_throttling(input);
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
        pub fn set_bandwidth_throttling(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_bandwidth_throttling(input);
            self
        }
        /// <p>The data plane routing mechanism that will be used for replication.</p>
        pub fn data_plane_routing(
            mut self,
            input: crate::model::ReplicationConfigurationDataPlaneRouting,
        ) -> Self {
            self.inner = self.inner.data_plane_routing(input);
            self
        }
        /// <p>The data plane routing mechanism that will be used for replication.</p>
        pub fn set_data_plane_routing(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        ) -> Self {
            self.inner = self.inner.set_data_plane_routing(input);
            self
        }
        /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
        pub fn create_public_ip(mut self, input: bool) -> Self {
            self.inner = self.inner.create_public_ip(input);
            self
        }
        /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
        pub fn set_create_public_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_create_public_ip(input);
            self
        }
        /// Adds a key-value pair to `stagingAreaTags`.
        ///
        /// To override the contents of this collection use [`set_staging_area_tags`](Self::set_staging_area_tags).
        ///
        /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
        pub fn staging_area_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.staging_area_tags(k.into(), v.into());
            self
        }
        /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
        pub fn set_staging_area_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_staging_area_tags(input);
            self
        }
        /// Appends an item to `pitPolicy`.
        ///
        /// To override the contents of this collection use [`set_pit_policy`](Self::set_pit_policy).
        ///
        /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
        pub fn pit_policy(mut self, input: crate::model::PitPolicyRule) -> Self {
            self.inner = self.inner.pit_policy(input);
            self
        }
        /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
        pub fn set_pit_policy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PitPolicyRule>>,
        ) -> Self {
            self.inner = self.inner.set_pit_policy(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A set of tags to be associated with the Replication Configuration Template resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A set of tags to be associated with the Replication Configuration Template resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteJob`.
    ///
    /// <p>Deletes a single Job by ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_job_input::Builder,
    }
    impl DeleteJob {
        /// Creates a new `DeleteJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Job to be deleted.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The ID of the Job to be deleted.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRecoveryInstance`.
    ///
    /// <p>Deletes a single Recovery Instance by ID. This deletes the Recovery Instance resource from Elastic Disaster Recovery. The Recovery Instance must be disconnected first in order to delete it.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRecoveryInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_recovery_instance_input::Builder,
    }
    impl DeleteRecoveryInstance {
        /// Creates a new `DeleteRecoveryInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRecoveryInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRecoveryInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>RThe ID of the Recovery Instance to be deleted.</p>
        pub fn recovery_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_instance_id(input.into());
            self
        }
        /// <p>RThe ID of the Recovery Instance to be deleted.</p>
        pub fn set_recovery_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReplicationConfigurationTemplate`.
    ///
    /// <p>Deletes a single Replication Configuration Template by ID</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteReplicationConfigurationTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_replication_configuration_template_input::Builder,
    }
    impl DeleteReplicationConfigurationTemplate {
        /// Creates a new `DeleteReplicationConfigurationTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReplicationConfigurationTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteReplicationConfigurationTemplateError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Replication Configuration Template to be deleted.</p>
        pub fn replication_configuration_template_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .replication_configuration_template_id(input.into());
            self
        }
        /// <p>The ID of the Replication Configuration Template to be deleted.</p>
        pub fn set_replication_configuration_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_configuration_template_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSourceServer`.
    ///
    /// <p>Deletes a single Source Server by ID. The Source Server must be disconnected first.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSourceServer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_source_server_input::Builder,
    }
    impl DeleteSourceServer {
        /// Creates a new `DeleteSourceServer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSourceServerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSourceServerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Source Server to be deleted.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(input.into());
            self
        }
        /// <p>The ID of the Source Server to be deleted.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeJobLogItems`.
    ///
    /// <p>Retrieves a detailed Job log with pagination.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeJobLogItems {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_job_log_items_input::Builder,
    }
    impl DescribeJobLogItems {
        /// Creates a new `DescribeJobLogItems`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeJobLogItemsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeJobLogItemsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeJobLogItemsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeJobLogItemsPaginator {
            crate::paginator::DescribeJobLogItemsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the Job for which Job log items will be retrieved.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The ID of the Job for which Job log items will be retrieved.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>Maximum number of Job log items to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of Job log items to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token of the next Job log items to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token of the next Job log items to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeJobs`.
    ///
    /// <p>Returns a list of Jobs. Use the JobsID and fromDate and toDate filters to limit which jobs are returned. The response is sorted by creationDataTime - latest date first. Jobs are created by the StartRecovery, TerminateRecoveryInstances and StartFailbackLaunch APIs. Jobs are also created by DiagnosticLaunch and TerminateDiagnosticInstances, which are APIs available only to *Support* and only used in response to relevant support tickets.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeJobs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_jobs_input::Builder,
    }
    impl DescribeJobs {
        /// Creates a new `DescribeJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeJobsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeJobsPaginator {
            crate::paginator::DescribeJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>A set of filters by which to return Jobs.</p>
        pub fn filters(mut self, input: crate::model::DescribeJobsRequestFilters) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>A set of filters by which to return Jobs.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::DescribeJobsRequestFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Maximum number of Jobs to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of Jobs to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token of the next Job to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token of the next Job to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRecoveryInstances`.
    ///
    /// <p>Lists all Recovery Instances or multiple Recovery Instances by ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRecoveryInstances {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_recovery_instances_input::Builder,
    }
    impl DescribeRecoveryInstances {
        /// Creates a new `DescribeRecoveryInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRecoveryInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRecoveryInstancesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeRecoveryInstancesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeRecoveryInstancesPaginator {
            crate::paginator::DescribeRecoveryInstancesPaginator::new(self.handle, self.inner)
        }
        /// <p>A set of filters by which to return Recovery Instances.</p>
        pub fn filters(
            mut self,
            input: crate::model::DescribeRecoveryInstancesRequestFilters,
        ) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>A set of filters by which to return Recovery Instances.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::DescribeRecoveryInstancesRequestFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Maximum number of Recovery Instances to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of Recovery Instances to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token of the next Recovery Instance to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token of the next Recovery Instance to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRecoverySnapshots`.
    ///
    /// <p>Lists all Recovery Snapshots for a single Source Server.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRecoverySnapshots {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_recovery_snapshots_input::Builder,
    }
    impl DescribeRecoverySnapshots {
        /// Creates a new `DescribeRecoverySnapshots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRecoverySnapshotsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRecoverySnapshotsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeRecoverySnapshotsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeRecoverySnapshotsPaginator {
            crate::paginator::DescribeRecoverySnapshotsPaginator::new(self.handle, self.inner)
        }
        /// <p>Filter Recovery Snapshots by Source Server ID.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(input.into());
            self
        }
        /// <p>Filter Recovery Snapshots by Source Server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
        /// <p>A set of filters by which to return Recovery Snapshots.</p>
        pub fn filters(
            mut self,
            input: crate::model::DescribeRecoverySnapshotsRequestFilters,
        ) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>A set of filters by which to return Recovery Snapshots.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::DescribeRecoverySnapshotsRequestFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The sorted ordering by which to return Recovery Snapshots.</p>
        pub fn order(mut self, input: crate::model::RecoverySnapshotsOrder) -> Self {
            self.inner = self.inner.order(input);
            self
        }
        /// <p>The sorted ordering by which to return Recovery Snapshots.</p>
        pub fn set_order(
            mut self,
            input: std::option::Option<crate::model::RecoverySnapshotsOrder>,
        ) -> Self {
            self.inner = self.inner.set_order(input);
            self
        }
        /// <p>Maximum number of Recovery Snapshots to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of Recovery Snapshots to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token of the next Recovery Snapshot to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token of the next Recovery Snapshot to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReplicationConfigurationTemplates`.
    ///
    /// <p>Lists all ReplicationConfigurationTemplates, filtered by Source Server IDs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeReplicationConfigurationTemplates {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_replication_configuration_templates_input::Builder,
    }
    impl DescribeReplicationConfigurationTemplates {
        /// Creates a new `DescribeReplicationConfigurationTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReplicationConfigurationTemplatesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeReplicationConfigurationTemplatesError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeReplicationConfigurationTemplatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeReplicationConfigurationTemplatesPaginator {
            crate::paginator::DescribeReplicationConfigurationTemplatesPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// Appends an item to `replicationConfigurationTemplateIDs`.
        ///
        /// To override the contents of this collection use [`set_replication_configuration_template_i_ds`](Self::set_replication_configuration_template_i_ds).
        ///
        /// <p>The IDs of the Replication Configuration Templates to retrieve. An empty list means all Replication Configuration Templates.</p>
        pub fn replication_configuration_template_i_ds(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .replication_configuration_template_i_ds(input.into());
            self
        }
        /// <p>The IDs of the Replication Configuration Templates to retrieve. An empty list means all Replication Configuration Templates.</p>
        pub fn set_replication_configuration_template_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_replication_configuration_template_i_ds(input);
            self
        }
        /// <p>Maximum number of Replication Configuration Templates to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of Replication Configuration Templates to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token of the next Replication Configuration Template to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token of the next Replication Configuration Template to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSourceServers`.
    ///
    /// <p>Lists all Source Servers or multiple Source Servers filtered by ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSourceServers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_source_servers_input::Builder,
    }
    impl DescribeSourceServers {
        /// Creates a new `DescribeSourceServers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSourceServersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSourceServersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeSourceServersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeSourceServersPaginator {
            crate::paginator::DescribeSourceServersPaginator::new(self.handle, self.inner)
        }
        /// <p>A set of filters by which to return Source Servers.</p>
        pub fn filters(mut self, input: crate::model::DescribeSourceServersRequestFilters) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>A set of filters by which to return Source Servers.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::DescribeSourceServersRequestFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Maximum number of Source Servers to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of Source Servers to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token of the next Source Server to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token of the next Source Server to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisconnectRecoveryInstance`.
    ///
    /// <p>Disconnect a Recovery Instance from Elastic Disaster Recovery. Data replication is stopped immediately. All AWS resources created by Elastic Disaster Recovery for enabling the replication of the Recovery Instance will be terminated / deleted within 90 minutes. If the agent on the Recovery Instance has not been prevented from communicating with the Elastic Disaster Recovery service, then it will receive a command to uninstall itself (within approximately 10 minutes). The following properties of the Recovery Instance will be changed immediately: dataReplicationInfo.dataReplicationState will be set to DISCONNECTED; The totalStorageBytes property for each of dataReplicationInfo.replicatedDisks will be set to zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisconnectRecoveryInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disconnect_recovery_instance_input::Builder,
    }
    impl DisconnectRecoveryInstance {
        /// Creates a new `DisconnectRecoveryInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisconnectRecoveryInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DisconnectRecoveryInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Recovery Instance to disconnect.</p>
        pub fn recovery_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_instance_id(input.into());
            self
        }
        /// <p>The ID of the Recovery Instance to disconnect.</p>
        pub fn set_recovery_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisconnectSourceServer`.
    ///
    /// <p>Disconnects a specific Source Server from Elastic Disaster Recovery. Data replication is stopped immediately. All AWS resources created by Elastic Disaster Recovery for enabling the replication of the Source Server will be terminated / deleted within 90 minutes. You cannot disconnect a Source Server if it has a Recovery Instance. If the agent on the Source Server has not been prevented from communicating with the Elastic Disaster Recovery service, then it will receive a command to uninstall itself (within approximately 10 minutes). The following properties of the SourceServer will be changed immediately: dataReplicationInfo.dataReplicationState will be set to DISCONNECTED; The totalStorageBytes property for each of dataReplicationInfo.replicatedDisks will be set to zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisconnectSourceServer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disconnect_source_server_input::Builder,
    }
    impl DisconnectSourceServer {
        /// Creates a new `DisconnectSourceServer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisconnectSourceServerOutput,
            aws_smithy_http::result::SdkError<crate::error::DisconnectSourceServerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Source Server to disconnect.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(input.into());
            self
        }
        /// <p>The ID of the Source Server to disconnect.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFailbackReplicationConfiguration`.
    ///
    /// <p>Lists all Failback ReplicationConfigurations, filtered by Recovery Instance ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFailbackReplicationConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_failback_replication_configuration_input::Builder,
    }
    impl GetFailbackReplicationConfiguration {
        /// Creates a new `GetFailbackReplicationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFailbackReplicationConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetFailbackReplicationConfigurationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Recovery Instance whose failback replication configuration should be returned.</p>
        pub fn recovery_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_instance_id(input.into());
            self
        }
        /// <p>The ID of the Recovery Instance whose failback replication configuration should be returned.</p>
        pub fn set_recovery_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLaunchConfiguration`.
    ///
    /// <p>Gets a LaunchConfiguration, filtered by Source Server IDs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLaunchConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_launch_configuration_input::Builder,
    }
    impl GetLaunchConfiguration {
        /// Creates a new `GetLaunchConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLaunchConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLaunchConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Source Server that we want to retrieve a Launch Configuration for.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(input.into());
            self
        }
        /// <p>The ID of the Source Server that we want to retrieve a Launch Configuration for.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetReplicationConfiguration`.
    ///
    /// <p>Gets a ReplicationConfiguration, filtered by Source Server ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetReplicationConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_replication_configuration_input::Builder,
    }
    impl GetReplicationConfiguration {
        /// Creates a new `GetReplicationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetReplicationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetReplicationConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Source Serve for this Replication Configuration.r</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(input.into());
            self
        }
        /// <p>The ID of the Source Serve for this Replication Configuration.r</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `InitializeService`.
    ///
    /// <p>Initialize Elastic Disaster Recovery.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct InitializeService {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::initialize_service_input::Builder,
    }
    impl InitializeService {
        /// Creates a new `InitializeService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::InitializeServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::InitializeServiceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>List all tags for your Elastic Disaster Recovery resources.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource whose tags should be returned.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource whose tags should be returned.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RetryDataReplication`.
    ///
    /// <p>Causes the data replication initiation sequence to begin immediately upon next Handshake for the specified Source Server ID, regardless of when the previous initiation started. This command will work only if the Source Server is stalled or is in a DISCONNECTED or STOPPED state.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RetryDataReplication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::retry_data_replication_input::Builder,
    }
    impl RetryDataReplication {
        /// Creates a new `RetryDataReplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RetryDataReplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::RetryDataReplicationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Source Server whose data replication should be retried.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(input.into());
            self
        }
        /// <p>The ID of the Source Server whose data replication should be retried.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartFailbackLaunch`.
    ///
    /// <p>Initiates a Job for launching the machine that is being failed back to from the specified Recovery Instance. This will run conversion on the failback client and will reboot your machine, thus completing the failback process.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartFailbackLaunch {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_failback_launch_input::Builder,
    }
    impl StartFailbackLaunch {
        /// Creates a new `StartFailbackLaunch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartFailbackLaunchOutput,
            aws_smithy_http::result::SdkError<crate::error::StartFailbackLaunchError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `recoveryInstanceIDs`.
        ///
        /// To override the contents of this collection use [`set_recovery_instance_i_ds`](Self::set_recovery_instance_i_ds).
        ///
        /// <p>The IDs of the Recovery Instance whose failback launch we want to request.</p>
        pub fn recovery_instance_i_ds(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_instance_i_ds(input.into());
            self
        }
        /// <p>The IDs of the Recovery Instance whose failback launch we want to request.</p>
        pub fn set_recovery_instance_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_recovery_instance_i_ds(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be associated with the failback launch Job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to be associated with the failback launch Job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartRecovery`.
    ///
    /// <p>Launches Recovery Instances for the specified Source Servers. For each Source Server you may choose a point in time snapshot to launch from, or use an on demand snapshot.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartRecovery {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_recovery_input::Builder,
    }
    impl StartRecovery {
        /// Creates a new `StartRecovery`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartRecoveryOutput,
            aws_smithy_http::result::SdkError<crate::error::StartRecoveryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `sourceServers`.
        ///
        /// To override the contents of this collection use [`set_source_servers`](Self::set_source_servers).
        ///
        /// <p>The Source Servers that we want to start a Recovery Job for.</p>
        pub fn source_servers(
            mut self,
            input: crate::model::StartRecoveryRequestSourceServer,
        ) -> Self {
            self.inner = self.inner.source_servers(input);
            self
        }
        /// <p>The Source Servers that we want to start a Recovery Job for.</p>
        pub fn set_source_servers(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::StartRecoveryRequestSourceServer>,
            >,
        ) -> Self {
            self.inner = self.inner.set_source_servers(input);
            self
        }
        /// <p>Whether this Source Server Recovery operation is a drill or not.</p>
        pub fn is_drill(mut self, input: bool) -> Self {
            self.inner = self.inner.is_drill(input);
            self
        }
        /// <p>Whether this Source Server Recovery operation is a drill or not.</p>
        pub fn set_is_drill(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_is_drill(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be associated with the Recovery Job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to be associated with the Recovery Job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopFailback`.
    ///
    /// <p>Stops the failback process for a specified Recovery Instance. This changes the Failback State of the Recovery Instance back to FAILBACK_NOT_STARTED.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopFailback {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_failback_input::Builder,
    }
    impl StopFailback {
        /// Creates a new `StopFailback`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopFailbackOutput,
            aws_smithy_http::result::SdkError<crate::error::StopFailbackError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Recovery Instance we want to stop failback for.</p>
        pub fn recovery_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_instance_id(input.into());
            self
        }
        /// <p>The ID of the Recovery Instance we want to stop failback for.</p>
        pub fn set_recovery_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds or overwrites only the specified tags for the specified Elastic Disaster Recovery resource or resources. When you specify an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of 50 tags. Each tag consists of a key and optional value.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the resource for which tags are to be added or updated.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>ARN of the resource for which tags are to be added or updated.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Array of tags to be added or updated.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Array of tags to be added or updated.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TerminateRecoveryInstances`.
    ///
    /// <p>Initiates a Job for terminating the EC2 resources associated with the specified Recovery Instances, and then will delete the Recovery Instances from the Elastic Disaster Recovery service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TerminateRecoveryInstances {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::terminate_recovery_instances_input::Builder,
    }
    impl TerminateRecoveryInstances {
        /// Creates a new `TerminateRecoveryInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TerminateRecoveryInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::TerminateRecoveryInstancesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `recoveryInstanceIDs`.
        ///
        /// To override the contents of this collection use [`set_recovery_instance_i_ds`](Self::set_recovery_instance_i_ds).
        ///
        /// <p>The IDs of the Recovery Instances that should be terminated.</p>
        pub fn recovery_instance_i_ds(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_instance_i_ds(input.into());
            self
        }
        /// <p>The IDs of the Recovery Instances that should be terminated.</p>
        pub fn set_recovery_instance_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_recovery_instance_i_ds(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Deletes the specified set of tags from the specified set of Elastic Disaster Recovery resources.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the resource for which tags are to be removed.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>ARN of the resource for which tags are to be removed.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Array of tags to be removed.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>Array of tags to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFailbackReplicationConfiguration`.
    ///
    /// <p>Allows you to update the failback replication configuration of a Recovery Instance by ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFailbackReplicationConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_failback_replication_configuration_input::Builder,
    }
    impl UpdateFailbackReplicationConfiguration {
        /// Creates a new `UpdateFailbackReplicationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFailbackReplicationConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateFailbackReplicationConfigurationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Recovery Instance.</p>
        pub fn recovery_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_instance_id(input.into());
            self
        }
        /// <p>The ID of the Recovery Instance.</p>
        pub fn set_recovery_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_instance_id(input);
            self
        }
        /// <p>The name of the Failback Replication Configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the Failback Replication Configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Recovery Instance in Mbps.</p>
        pub fn bandwidth_throttling(mut self, input: i64) -> Self {
            self.inner = self.inner.bandwidth_throttling(input);
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Recovery Instance in Mbps.</p>
        pub fn set_bandwidth_throttling(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_bandwidth_throttling(input);
            self
        }
        /// <p>Whether to use Private IP for the failback replication of the Recovery Instance.</p>
        pub fn use_private_ip(mut self, input: bool) -> Self {
            self.inner = self.inner.use_private_ip(input);
            self
        }
        /// <p>Whether to use Private IP for the failback replication of the Recovery Instance.</p>
        pub fn set_use_private_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_use_private_ip(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLaunchConfiguration`.
    ///
    /// <p>Updates a LaunchConfiguration by Source Server ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateLaunchConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_launch_configuration_input::Builder,
    }
    impl UpdateLaunchConfiguration {
        /// Creates a new `UpdateLaunchConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLaunchConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLaunchConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Source Server that we want to retrieve a Launch Configuration for.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(input.into());
            self
        }
        /// <p>The ID of the Source Server that we want to retrieve a Launch Configuration for.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
        /// <p>The name of the launch configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the launch configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The state of the Recovery Instance in EC2 after the recovery operation.</p>
        pub fn launch_disposition(mut self, input: crate::model::LaunchDisposition) -> Self {
            self.inner = self.inner.launch_disposition(input);
            self
        }
        /// <p>The state of the Recovery Instance in EC2 after the recovery operation.</p>
        pub fn set_launch_disposition(
            mut self,
            input: std::option::Option<crate::model::LaunchDisposition>,
        ) -> Self {
            self.inner = self.inner.set_launch_disposition(input);
            self
        }
        /// <p>Whether Elastic Disaster Recovery should try to automatically choose the instance type that best matches the OS, CPU, and RAM of your Source Server.</p>
        pub fn target_instance_type_right_sizing_method(
            mut self,
            input: crate::model::TargetInstanceTypeRightSizingMethod,
        ) -> Self {
            self.inner = self.inner.target_instance_type_right_sizing_method(input);
            self
        }
        /// <p>Whether Elastic Disaster Recovery should try to automatically choose the instance type that best matches the OS, CPU, and RAM of your Source Server.</p>
        pub fn set_target_instance_type_right_sizing_method(
            mut self,
            input: std::option::Option<crate::model::TargetInstanceTypeRightSizingMethod>,
        ) -> Self {
            self.inner = self
                .inner
                .set_target_instance_type_right_sizing_method(input);
            self
        }
        /// <p>Whether we should copy the Private IP of the Source Server to the Recovery Instance.</p>
        pub fn copy_private_ip(mut self, input: bool) -> Self {
            self.inner = self.inner.copy_private_ip(input);
            self
        }
        /// <p>Whether we should copy the Private IP of the Source Server to the Recovery Instance.</p>
        pub fn set_copy_private_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_copy_private_ip(input);
            self
        }
        /// <p>Whether we want to copy the tags of the Source Server to the EC2 machine of the Recovery Instance.</p>
        pub fn copy_tags(mut self, input: bool) -> Self {
            self.inner = self.inner.copy_tags(input);
            self
        }
        /// <p>Whether we want to copy the tags of the Source Server to the EC2 machine of the Recovery Instance.</p>
        pub fn set_copy_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_copy_tags(input);
            self
        }
        /// <p>The licensing configuration to be used for this launch configuration.</p>
        pub fn licensing(mut self, input: crate::model::Licensing) -> Self {
            self.inner = self.inner.licensing(input);
            self
        }
        /// <p>The licensing configuration to be used for this launch configuration.</p>
        pub fn set_licensing(
            mut self,
            input: std::option::Option<crate::model::Licensing>,
        ) -> Self {
            self.inner = self.inner.set_licensing(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateReplicationConfiguration`.
    ///
    /// <p>Allows you to update a ReplicationConfiguration by Source Server ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateReplicationConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_replication_configuration_input::Builder,
    }
    impl UpdateReplicationConfiguration {
        /// Creates a new `UpdateReplicationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateReplicationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateReplicationConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Source Server for this Replication Configuration.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(input.into());
            self
        }
        /// <p>The ID of the Source Server for this Replication Configuration.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
        /// <p>The name of the Replication Configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the Replication Configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The subnet to be used by the replication staging area.</p>
        pub fn staging_area_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.staging_area_subnet_id(input.into());
            self
        }
        /// <p>The subnet to be used by the replication staging area.</p>
        pub fn set_staging_area_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_staging_area_subnet_id(input);
            self
        }
        /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration.</p>
        pub fn associate_default_security_group(mut self, input: bool) -> Self {
            self.inner = self.inner.associate_default_security_group(input);
            self
        }
        /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration.</p>
        pub fn set_associate_default_security_group(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_associate_default_security_group(input);
            self
        }
        /// Appends an item to `replicationServersSecurityGroupsIDs`.
        ///
        /// To override the contents of this collection use [`set_replication_servers_security_groups_i_ds`](Self::set_replication_servers_security_groups_i_ds).
        ///
        /// <p>The security group IDs that will be used by the replication server.</p>
        pub fn replication_servers_security_groups_i_ds(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .replication_servers_security_groups_i_ds(input.into());
            self
        }
        /// <p>The security group IDs that will be used by the replication server.</p>
        pub fn set_replication_servers_security_groups_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_replication_servers_security_groups_i_ds(input);
            self
        }
        /// <p>The instance type to be used for the replication server.</p>
        pub fn replication_server_instance_type(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_server_instance_type(input.into());
            self
        }
        /// <p>The instance type to be used for the replication server.</p>
        pub fn set_replication_server_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_server_instance_type(input);
            self
        }
        /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
        pub fn use_dedicated_replication_server(mut self, input: bool) -> Self {
            self.inner = self.inner.use_dedicated_replication_server(input);
            self
        }
        /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
        pub fn set_use_dedicated_replication_server(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_use_dedicated_replication_server(input);
            self
        }
        /// <p>The Staging Disk EBS volume type to be used during replication.</p>
        pub fn default_large_staging_disk_type(
            mut self,
            input: crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
        ) -> Self {
            self.inner = self.inner.default_large_staging_disk_type(input);
            self
        }
        /// <p>The Staging Disk EBS volume type to be used during replication.</p>
        pub fn set_default_large_staging_disk_type(
            mut self,
            input: std::option::Option<
                crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
            >,
        ) -> Self {
            self.inner = self.inner.set_default_large_staging_disk_type(input);
            self
        }
        /// Appends an item to `replicatedDisks`.
        ///
        /// To override the contents of this collection use [`set_replicated_disks`](Self::set_replicated_disks).
        ///
        /// <p>The configuration of the disks of the Source Server to be replicated.</p>
        pub fn replicated_disks(
            mut self,
            input: crate::model::ReplicationConfigurationReplicatedDisk,
        ) -> Self {
            self.inner = self.inner.replicated_disks(input);
            self
        }
        /// <p>The configuration of the disks of the Source Server to be replicated.</p>
        pub fn set_replicated_disks(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ReplicationConfigurationReplicatedDisk>,
            >,
        ) -> Self {
            self.inner = self.inner.set_replicated_disks(input);
            self
        }
        /// <p>The type of EBS encryption to be used during replication.</p>
        pub fn ebs_encryption(
            mut self,
            input: crate::model::ReplicationConfigurationEbsEncryption,
        ) -> Self {
            self.inner = self.inner.ebs_encryption(input);
            self
        }
        /// <p>The type of EBS encryption to be used during replication.</p>
        pub fn set_ebs_encryption(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        ) -> Self {
            self.inner = self.inner.set_ebs_encryption(input);
            self
        }
        /// <p>The ARN of the EBS encryption key to be used during replication.</p>
        pub fn ebs_encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ebs_encryption_key_arn(input.into());
            self
        }
        /// <p>The ARN of the EBS encryption key to be used during replication.</p>
        pub fn set_ebs_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ebs_encryption_key_arn(input);
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
        pub fn bandwidth_throttling(mut self, input: i64) -> Self {
            self.inner = self.inner.bandwidth_throttling(input);
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
        pub fn set_bandwidth_throttling(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_bandwidth_throttling(input);
            self
        }
        /// <p>The data plane routing mechanism that will be used for replication.</p>
        pub fn data_plane_routing(
            mut self,
            input: crate::model::ReplicationConfigurationDataPlaneRouting,
        ) -> Self {
            self.inner = self.inner.data_plane_routing(input);
            self
        }
        /// <p>The data plane routing mechanism that will be used for replication.</p>
        pub fn set_data_plane_routing(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        ) -> Self {
            self.inner = self.inner.set_data_plane_routing(input);
            self
        }
        /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
        pub fn create_public_ip(mut self, input: bool) -> Self {
            self.inner = self.inner.create_public_ip(input);
            self
        }
        /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
        pub fn set_create_public_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_create_public_ip(input);
            self
        }
        /// Adds a key-value pair to `stagingAreaTags`.
        ///
        /// To override the contents of this collection use [`set_staging_area_tags`](Self::set_staging_area_tags).
        ///
        /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
        pub fn staging_area_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.staging_area_tags(k.into(), v.into());
            self
        }
        /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
        pub fn set_staging_area_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_staging_area_tags(input);
            self
        }
        /// Appends an item to `pitPolicy`.
        ///
        /// To override the contents of this collection use [`set_pit_policy`](Self::set_pit_policy).
        ///
        /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
        pub fn pit_policy(mut self, input: crate::model::PitPolicyRule) -> Self {
            self.inner = self.inner.pit_policy(input);
            self
        }
        /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
        pub fn set_pit_policy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PitPolicyRule>>,
        ) -> Self {
            self.inner = self.inner.set_pit_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateReplicationConfigurationTemplate`.
    ///
    /// <p>Updates a ReplicationConfigurationTemplate by ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateReplicationConfigurationTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_replication_configuration_template_input::Builder,
    }
    impl UpdateReplicationConfigurationTemplate {
        /// Creates a new `UpdateReplicationConfigurationTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateReplicationConfigurationTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateReplicationConfigurationTemplateError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Replication Configuration Template ID.</p>
        pub fn replication_configuration_template_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .replication_configuration_template_id(input.into());
            self
        }
        /// <p>The Replication Configuration Template ID.</p>
        pub fn set_replication_configuration_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_configuration_template_id(input);
            self
        }
        /// <p>The Replication Configuration Template ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The Replication Configuration Template ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>The subnet to be used by the replication staging area.</p>
        pub fn staging_area_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.staging_area_subnet_id(input.into());
            self
        }
        /// <p>The subnet to be used by the replication staging area.</p>
        pub fn set_staging_area_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_staging_area_subnet_id(input);
            self
        }
        /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>
        pub fn associate_default_security_group(mut self, input: bool) -> Self {
            self.inner = self.inner.associate_default_security_group(input);
            self
        }
        /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>
        pub fn set_associate_default_security_group(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_associate_default_security_group(input);
            self
        }
        /// Appends an item to `replicationServersSecurityGroupsIDs`.
        ///
        /// To override the contents of this collection use [`set_replication_servers_security_groups_i_ds`](Self::set_replication_servers_security_groups_i_ds).
        ///
        /// <p>The security group IDs that will be used by the replication server.</p>
        pub fn replication_servers_security_groups_i_ds(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .replication_servers_security_groups_i_ds(input.into());
            self
        }
        /// <p>The security group IDs that will be used by the replication server.</p>
        pub fn set_replication_servers_security_groups_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_replication_servers_security_groups_i_ds(input);
            self
        }
        /// <p>The instance type to be used for the replication server.</p>
        pub fn replication_server_instance_type(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_server_instance_type(input.into());
            self
        }
        /// <p>The instance type to be used for the replication server.</p>
        pub fn set_replication_server_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_server_instance_type(input);
            self
        }
        /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
        pub fn use_dedicated_replication_server(mut self, input: bool) -> Self {
            self.inner = self.inner.use_dedicated_replication_server(input);
            self
        }
        /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
        pub fn set_use_dedicated_replication_server(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_use_dedicated_replication_server(input);
            self
        }
        /// <p>The Staging Disk EBS volume type to be used during replication.</p>
        pub fn default_large_staging_disk_type(
            mut self,
            input: crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
        ) -> Self {
            self.inner = self.inner.default_large_staging_disk_type(input);
            self
        }
        /// <p>The Staging Disk EBS volume type to be used during replication.</p>
        pub fn set_default_large_staging_disk_type(
            mut self,
            input: std::option::Option<
                crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
            >,
        ) -> Self {
            self.inner = self.inner.set_default_large_staging_disk_type(input);
            self
        }
        /// <p>The type of EBS encryption to be used during replication.</p>
        pub fn ebs_encryption(
            mut self,
            input: crate::model::ReplicationConfigurationEbsEncryption,
        ) -> Self {
            self.inner = self.inner.ebs_encryption(input);
            self
        }
        /// <p>The type of EBS encryption to be used during replication.</p>
        pub fn set_ebs_encryption(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        ) -> Self {
            self.inner = self.inner.set_ebs_encryption(input);
            self
        }
        /// <p>The ARN of the EBS encryption key to be used during replication.</p>
        pub fn ebs_encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ebs_encryption_key_arn(input.into());
            self
        }
        /// <p>The ARN of the EBS encryption key to be used during replication.</p>
        pub fn set_ebs_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ebs_encryption_key_arn(input);
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
        pub fn bandwidth_throttling(mut self, input: i64) -> Self {
            self.inner = self.inner.bandwidth_throttling(input);
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
        pub fn set_bandwidth_throttling(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_bandwidth_throttling(input);
            self
        }
        /// <p>The data plane routing mechanism that will be used for replication.</p>
        pub fn data_plane_routing(
            mut self,
            input: crate::model::ReplicationConfigurationDataPlaneRouting,
        ) -> Self {
            self.inner = self.inner.data_plane_routing(input);
            self
        }
        /// <p>The data plane routing mechanism that will be used for replication.</p>
        pub fn set_data_plane_routing(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        ) -> Self {
            self.inner = self.inner.set_data_plane_routing(input);
            self
        }
        /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
        pub fn create_public_ip(mut self, input: bool) -> Self {
            self.inner = self.inner.create_public_ip(input);
            self
        }
        /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
        pub fn set_create_public_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_create_public_ip(input);
            self
        }
        /// Adds a key-value pair to `stagingAreaTags`.
        ///
        /// To override the contents of this collection use [`set_staging_area_tags`](Self::set_staging_area_tags).
        ///
        /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
        pub fn staging_area_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.staging_area_tags(k.into(), v.into());
            self
        }
        /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
        pub fn set_staging_area_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_staging_area_tags(input);
            self
        }
        /// Appends an item to `pitPolicy`.
        ///
        /// To override the contents of this collection use [`set_pit_policy`](Self::set_pit_policy).
        ///
        /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
        pub fn pit_policy(mut self, input: crate::model::PitPolicyRule) -> Self {
            self.inner = self.inner.pit_policy(input);
            self
        }
        /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
        pub fn set_pit_policy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PitPolicyRule>>,
        ) -> Self {
            self.inner = self.inner.set_pit_policy(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
