// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateReplicationConfigurationTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_replication_configuration_template`](crate::client::Client::create_replication_configuration_template).
///
/// See [`crate::client::fluent_builders::CreateReplicationConfigurationTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateReplicationConfigurationTemplate {
    _private: (),
}
impl CreateReplicationConfigurationTemplate {
    /// Creates a new builder-style object to manufacture [`CreateReplicationConfigurationTemplateInput`](crate::input::CreateReplicationConfigurationTemplateInput)
    pub fn builder() -> crate::input::create_replication_configuration_template_input::Builder {
        crate::input::create_replication_configuration_template_input::Builder::default()
    }
    /// Creates a new `CreateReplicationConfigurationTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateReplicationConfigurationTemplate {
    type Output = std::result::Result<
        crate::output::CreateReplicationConfigurationTemplateOutput,
        crate::error::CreateReplicationConfigurationTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_replication_configuration_template_error(response)
        } else {
            crate::operation_deser::parse_create_replication_configuration_template_response(
                response,
            )
        }
    }
}

/// Operation shape for `DeleteJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_job`](crate::client::Client::delete_job).
///
/// See [`crate::client::fluent_builders::DeleteJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteJob {
    _private: (),
}
impl DeleteJob {
    /// Creates a new builder-style object to manufacture [`DeleteJobInput`](crate::input::DeleteJobInput)
    pub fn builder() -> crate::input::delete_job_input::Builder {
        crate::input::delete_job_input::Builder::default()
    }
    /// Creates a new `DeleteJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteJob {
    type Output = std::result::Result<crate::output::DeleteJobOutput, crate::error::DeleteJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_job_error(response)
        } else {
            crate::operation_deser::parse_delete_job_response(response)
        }
    }
}

/// Operation shape for `DeleteRecoveryInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_recovery_instance`](crate::client::Client::delete_recovery_instance).
///
/// See [`crate::client::fluent_builders::DeleteRecoveryInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRecoveryInstance {
    _private: (),
}
impl DeleteRecoveryInstance {
    /// Creates a new builder-style object to manufacture [`DeleteRecoveryInstanceInput`](crate::input::DeleteRecoveryInstanceInput)
    pub fn builder() -> crate::input::delete_recovery_instance_input::Builder {
        crate::input::delete_recovery_instance_input::Builder::default()
    }
    /// Creates a new `DeleteRecoveryInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRecoveryInstance {
    type Output = std::result::Result<
        crate::output::DeleteRecoveryInstanceOutput,
        crate::error::DeleteRecoveryInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_recovery_instance_error(response)
        } else {
            crate::operation_deser::parse_delete_recovery_instance_response(response)
        }
    }
}

/// Operation shape for `DeleteReplicationConfigurationTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_replication_configuration_template`](crate::client::Client::delete_replication_configuration_template).
///
/// See [`crate::client::fluent_builders::DeleteReplicationConfigurationTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteReplicationConfigurationTemplate {
    _private: (),
}
impl DeleteReplicationConfigurationTemplate {
    /// Creates a new builder-style object to manufacture [`DeleteReplicationConfigurationTemplateInput`](crate::input::DeleteReplicationConfigurationTemplateInput)
    pub fn builder() -> crate::input::delete_replication_configuration_template_input::Builder {
        crate::input::delete_replication_configuration_template_input::Builder::default()
    }
    /// Creates a new `DeleteReplicationConfigurationTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteReplicationConfigurationTemplate {
    type Output = std::result::Result<
        crate::output::DeleteReplicationConfigurationTemplateOutput,
        crate::error::DeleteReplicationConfigurationTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_replication_configuration_template_error(response)
        } else {
            crate::operation_deser::parse_delete_replication_configuration_template_response(
                response,
            )
        }
    }
}

/// Operation shape for `DeleteSourceServer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_source_server`](crate::client::Client::delete_source_server).
///
/// See [`crate::client::fluent_builders::DeleteSourceServer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSourceServer {
    _private: (),
}
impl DeleteSourceServer {
    /// Creates a new builder-style object to manufacture [`DeleteSourceServerInput`](crate::input::DeleteSourceServerInput)
    pub fn builder() -> crate::input::delete_source_server_input::Builder {
        crate::input::delete_source_server_input::Builder::default()
    }
    /// Creates a new `DeleteSourceServer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSourceServer {
    type Output = std::result::Result<
        crate::output::DeleteSourceServerOutput,
        crate::error::DeleteSourceServerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_source_server_error(response)
        } else {
            crate::operation_deser::parse_delete_source_server_response(response)
        }
    }
}

/// Operation shape for `DescribeJobLogItems`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_job_log_items`](crate::client::Client::describe_job_log_items).
///
/// See [`crate::client::fluent_builders::DescribeJobLogItems`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeJobLogItems {
    _private: (),
}
impl DescribeJobLogItems {
    /// Creates a new builder-style object to manufacture [`DescribeJobLogItemsInput`](crate::input::DescribeJobLogItemsInput)
    pub fn builder() -> crate::input::describe_job_log_items_input::Builder {
        crate::input::describe_job_log_items_input::Builder::default()
    }
    /// Creates a new `DescribeJobLogItems` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeJobLogItems {
    type Output = std::result::Result<
        crate::output::DescribeJobLogItemsOutput,
        crate::error::DescribeJobLogItemsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_job_log_items_error(response)
        } else {
            crate::operation_deser::parse_describe_job_log_items_response(response)
        }
    }
}

/// Operation shape for `DescribeJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_jobs`](crate::client::Client::describe_jobs).
///
/// See [`crate::client::fluent_builders::DescribeJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeJobs {
    _private: (),
}
impl DescribeJobs {
    /// Creates a new builder-style object to manufacture [`DescribeJobsInput`](crate::input::DescribeJobsInput)
    pub fn builder() -> crate::input::describe_jobs_input::Builder {
        crate::input::describe_jobs_input::Builder::default()
    }
    /// Creates a new `DescribeJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeJobs {
    type Output =
        std::result::Result<crate::output::DescribeJobsOutput, crate::error::DescribeJobsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_jobs_error(response)
        } else {
            crate::operation_deser::parse_describe_jobs_response(response)
        }
    }
}

/// Operation shape for `DescribeRecoveryInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_recovery_instances`](crate::client::Client::describe_recovery_instances).
///
/// See [`crate::client::fluent_builders::DescribeRecoveryInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRecoveryInstances {
    _private: (),
}
impl DescribeRecoveryInstances {
    /// Creates a new builder-style object to manufacture [`DescribeRecoveryInstancesInput`](crate::input::DescribeRecoveryInstancesInput)
    pub fn builder() -> crate::input::describe_recovery_instances_input::Builder {
        crate::input::describe_recovery_instances_input::Builder::default()
    }
    /// Creates a new `DescribeRecoveryInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRecoveryInstances {
    type Output = std::result::Result<
        crate::output::DescribeRecoveryInstancesOutput,
        crate::error::DescribeRecoveryInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_recovery_instances_error(response)
        } else {
            crate::operation_deser::parse_describe_recovery_instances_response(response)
        }
    }
}

/// Operation shape for `DescribeRecoverySnapshots`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_recovery_snapshots`](crate::client::Client::describe_recovery_snapshots).
///
/// See [`crate::client::fluent_builders::DescribeRecoverySnapshots`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRecoverySnapshots {
    _private: (),
}
impl DescribeRecoverySnapshots {
    /// Creates a new builder-style object to manufacture [`DescribeRecoverySnapshotsInput`](crate::input::DescribeRecoverySnapshotsInput)
    pub fn builder() -> crate::input::describe_recovery_snapshots_input::Builder {
        crate::input::describe_recovery_snapshots_input::Builder::default()
    }
    /// Creates a new `DescribeRecoverySnapshots` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRecoverySnapshots {
    type Output = std::result::Result<
        crate::output::DescribeRecoverySnapshotsOutput,
        crate::error::DescribeRecoverySnapshotsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_recovery_snapshots_error(response)
        } else {
            crate::operation_deser::parse_describe_recovery_snapshots_response(response)
        }
    }
}

/// Operation shape for `DescribeReplicationConfigurationTemplates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_replication_configuration_templates`](crate::client::Client::describe_replication_configuration_templates).
///
/// See [`crate::client::fluent_builders::DescribeReplicationConfigurationTemplates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReplicationConfigurationTemplates {
    _private: (),
}
impl DescribeReplicationConfigurationTemplates {
    /// Creates a new builder-style object to manufacture [`DescribeReplicationConfigurationTemplatesInput`](crate::input::DescribeReplicationConfigurationTemplatesInput)
    pub fn builder() -> crate::input::describe_replication_configuration_templates_input::Builder {
        crate::input::describe_replication_configuration_templates_input::Builder::default()
    }
    /// Creates a new `DescribeReplicationConfigurationTemplates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeReplicationConfigurationTemplates {
    type Output = std::result::Result<
        crate::output::DescribeReplicationConfigurationTemplatesOutput,
        crate::error::DescribeReplicationConfigurationTemplatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_replication_configuration_templates_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_replication_configuration_templates_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeSourceServers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_source_servers`](crate::client::Client::describe_source_servers).
///
/// See [`crate::client::fluent_builders::DescribeSourceServers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSourceServers {
    _private: (),
}
impl DescribeSourceServers {
    /// Creates a new builder-style object to manufacture [`DescribeSourceServersInput`](crate::input::DescribeSourceServersInput)
    pub fn builder() -> crate::input::describe_source_servers_input::Builder {
        crate::input::describe_source_servers_input::Builder::default()
    }
    /// Creates a new `DescribeSourceServers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSourceServers {
    type Output = std::result::Result<
        crate::output::DescribeSourceServersOutput,
        crate::error::DescribeSourceServersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_source_servers_error(response)
        } else {
            crate::operation_deser::parse_describe_source_servers_response(response)
        }
    }
}

/// Operation shape for `DisconnectRecoveryInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disconnect_recovery_instance`](crate::client::Client::disconnect_recovery_instance).
///
/// See [`crate::client::fluent_builders::DisconnectRecoveryInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisconnectRecoveryInstance {
    _private: (),
}
impl DisconnectRecoveryInstance {
    /// Creates a new builder-style object to manufacture [`DisconnectRecoveryInstanceInput`](crate::input::DisconnectRecoveryInstanceInput)
    pub fn builder() -> crate::input::disconnect_recovery_instance_input::Builder {
        crate::input::disconnect_recovery_instance_input::Builder::default()
    }
    /// Creates a new `DisconnectRecoveryInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisconnectRecoveryInstance {
    type Output = std::result::Result<
        crate::output::DisconnectRecoveryInstanceOutput,
        crate::error::DisconnectRecoveryInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disconnect_recovery_instance_error(response)
        } else {
            crate::operation_deser::parse_disconnect_recovery_instance_response(response)
        }
    }
}

/// Operation shape for `DisconnectSourceServer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disconnect_source_server`](crate::client::Client::disconnect_source_server).
///
/// See [`crate::client::fluent_builders::DisconnectSourceServer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisconnectSourceServer {
    _private: (),
}
impl DisconnectSourceServer {
    /// Creates a new builder-style object to manufacture [`DisconnectSourceServerInput`](crate::input::DisconnectSourceServerInput)
    pub fn builder() -> crate::input::disconnect_source_server_input::Builder {
        crate::input::disconnect_source_server_input::Builder::default()
    }
    /// Creates a new `DisconnectSourceServer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisconnectSourceServer {
    type Output = std::result::Result<
        crate::output::DisconnectSourceServerOutput,
        crate::error::DisconnectSourceServerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disconnect_source_server_error(response)
        } else {
            crate::operation_deser::parse_disconnect_source_server_response(response)
        }
    }
}

/// Operation shape for `GetFailbackReplicationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_failback_replication_configuration`](crate::client::Client::get_failback_replication_configuration).
///
/// See [`crate::client::fluent_builders::GetFailbackReplicationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFailbackReplicationConfiguration {
    _private: (),
}
impl GetFailbackReplicationConfiguration {
    /// Creates a new builder-style object to manufacture [`GetFailbackReplicationConfigurationInput`](crate::input::GetFailbackReplicationConfigurationInput)
    pub fn builder() -> crate::input::get_failback_replication_configuration_input::Builder {
        crate::input::get_failback_replication_configuration_input::Builder::default()
    }
    /// Creates a new `GetFailbackReplicationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFailbackReplicationConfiguration {
    type Output = std::result::Result<
        crate::output::GetFailbackReplicationConfigurationOutput,
        crate::error::GetFailbackReplicationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_failback_replication_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_failback_replication_configuration_response(response)
        }
    }
}

/// Operation shape for `GetLaunchConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_launch_configuration`](crate::client::Client::get_launch_configuration).
///
/// See [`crate::client::fluent_builders::GetLaunchConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLaunchConfiguration {
    _private: (),
}
impl GetLaunchConfiguration {
    /// Creates a new builder-style object to manufacture [`GetLaunchConfigurationInput`](crate::input::GetLaunchConfigurationInput)
    pub fn builder() -> crate::input::get_launch_configuration_input::Builder {
        crate::input::get_launch_configuration_input::Builder::default()
    }
    /// Creates a new `GetLaunchConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLaunchConfiguration {
    type Output = std::result::Result<
        crate::output::GetLaunchConfigurationOutput,
        crate::error::GetLaunchConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_launch_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_launch_configuration_response(response)
        }
    }
}

/// Operation shape for `GetReplicationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_replication_configuration`](crate::client::Client::get_replication_configuration).
///
/// See [`crate::client::fluent_builders::GetReplicationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetReplicationConfiguration {
    _private: (),
}
impl GetReplicationConfiguration {
    /// Creates a new builder-style object to manufacture [`GetReplicationConfigurationInput`](crate::input::GetReplicationConfigurationInput)
    pub fn builder() -> crate::input::get_replication_configuration_input::Builder {
        crate::input::get_replication_configuration_input::Builder::default()
    }
    /// Creates a new `GetReplicationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetReplicationConfiguration {
    type Output = std::result::Result<
        crate::output::GetReplicationConfigurationOutput,
        crate::error::GetReplicationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_replication_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_replication_configuration_response(response)
        }
    }
}

/// Operation shape for `InitializeService`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`initialize_service`](crate::client::Client::initialize_service).
///
/// See [`crate::client::fluent_builders::InitializeService`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct InitializeService {
    _private: (),
}
impl InitializeService {
    /// Creates a new builder-style object to manufacture [`InitializeServiceInput`](crate::input::InitializeServiceInput)
    pub fn builder() -> crate::input::initialize_service_input::Builder {
        crate::input::initialize_service_input::Builder::default()
    }
    /// Creates a new `InitializeService` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for InitializeService {
    type Output = std::result::Result<
        crate::output::InitializeServiceOutput,
        crate::error::InitializeServiceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_initialize_service_error(response)
        } else {
            crate::operation_deser::parse_initialize_service_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `RetryDataReplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`retry_data_replication`](crate::client::Client::retry_data_replication).
///
/// See [`crate::client::fluent_builders::RetryDataReplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RetryDataReplication {
    _private: (),
}
impl RetryDataReplication {
    /// Creates a new builder-style object to manufacture [`RetryDataReplicationInput`](crate::input::RetryDataReplicationInput)
    pub fn builder() -> crate::input::retry_data_replication_input::Builder {
        crate::input::retry_data_replication_input::Builder::default()
    }
    /// Creates a new `RetryDataReplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RetryDataReplication {
    type Output = std::result::Result<
        crate::output::RetryDataReplicationOutput,
        crate::error::RetryDataReplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_retry_data_replication_error(response)
        } else {
            crate::operation_deser::parse_retry_data_replication_response(response)
        }
    }
}

/// Operation shape for `StartFailbackLaunch`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_failback_launch`](crate::client::Client::start_failback_launch).
///
/// See [`crate::client::fluent_builders::StartFailbackLaunch`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartFailbackLaunch {
    _private: (),
}
impl StartFailbackLaunch {
    /// Creates a new builder-style object to manufacture [`StartFailbackLaunchInput`](crate::input::StartFailbackLaunchInput)
    pub fn builder() -> crate::input::start_failback_launch_input::Builder {
        crate::input::start_failback_launch_input::Builder::default()
    }
    /// Creates a new `StartFailbackLaunch` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartFailbackLaunch {
    type Output = std::result::Result<
        crate::output::StartFailbackLaunchOutput,
        crate::error::StartFailbackLaunchError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_failback_launch_error(response)
        } else {
            crate::operation_deser::parse_start_failback_launch_response(response)
        }
    }
}

/// Operation shape for `StartRecovery`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_recovery`](crate::client::Client::start_recovery).
///
/// See [`crate::client::fluent_builders::StartRecovery`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartRecovery {
    _private: (),
}
impl StartRecovery {
    /// Creates a new builder-style object to manufacture [`StartRecoveryInput`](crate::input::StartRecoveryInput)
    pub fn builder() -> crate::input::start_recovery_input::Builder {
        crate::input::start_recovery_input::Builder::default()
    }
    /// Creates a new `StartRecovery` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartRecovery {
    type Output =
        std::result::Result<crate::output::StartRecoveryOutput, crate::error::StartRecoveryError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_start_recovery_error(response)
        } else {
            crate::operation_deser::parse_start_recovery_response(response)
        }
    }
}

/// Operation shape for `StopFailback`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_failback`](crate::client::Client::stop_failback).
///
/// See [`crate::client::fluent_builders::StopFailback`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopFailback {
    _private: (),
}
impl StopFailback {
    /// Creates a new builder-style object to manufacture [`StopFailbackInput`](crate::input::StopFailbackInput)
    pub fn builder() -> crate::input::stop_failback_input::Builder {
        crate::input::stop_failback_input::Builder::default()
    }
    /// Creates a new `StopFailback` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopFailback {
    type Output =
        std::result::Result<crate::output::StopFailbackOutput, crate::error::StopFailbackError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_failback_error(response)
        } else {
            crate::operation_deser::parse_stop_failback_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `TerminateRecoveryInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`terminate_recovery_instances`](crate::client::Client::terminate_recovery_instances).
///
/// See [`crate::client::fluent_builders::TerminateRecoveryInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TerminateRecoveryInstances {
    _private: (),
}
impl TerminateRecoveryInstances {
    /// Creates a new builder-style object to manufacture [`TerminateRecoveryInstancesInput`](crate::input::TerminateRecoveryInstancesInput)
    pub fn builder() -> crate::input::terminate_recovery_instances_input::Builder {
        crate::input::terminate_recovery_instances_input::Builder::default()
    }
    /// Creates a new `TerminateRecoveryInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TerminateRecoveryInstances {
    type Output = std::result::Result<
        crate::output::TerminateRecoveryInstancesOutput,
        crate::error::TerminateRecoveryInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_terminate_recovery_instances_error(response)
        } else {
            crate::operation_deser::parse_terminate_recovery_instances_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateFailbackReplicationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_failback_replication_configuration`](crate::client::Client::update_failback_replication_configuration).
///
/// See [`crate::client::fluent_builders::UpdateFailbackReplicationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFailbackReplicationConfiguration {
    _private: (),
}
impl UpdateFailbackReplicationConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateFailbackReplicationConfigurationInput`](crate::input::UpdateFailbackReplicationConfigurationInput)
    pub fn builder() -> crate::input::update_failback_replication_configuration_input::Builder {
        crate::input::update_failback_replication_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateFailbackReplicationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFailbackReplicationConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateFailbackReplicationConfigurationOutput,
        crate::error::UpdateFailbackReplicationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_failback_replication_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_failback_replication_configuration_response(
                response,
            )
        }
    }
}

/// Operation shape for `UpdateLaunchConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_launch_configuration`](crate::client::Client::update_launch_configuration).
///
/// See [`crate::client::fluent_builders::UpdateLaunchConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateLaunchConfiguration {
    _private: (),
}
impl UpdateLaunchConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateLaunchConfigurationInput`](crate::input::UpdateLaunchConfigurationInput)
    pub fn builder() -> crate::input::update_launch_configuration_input::Builder {
        crate::input::update_launch_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateLaunchConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateLaunchConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateLaunchConfigurationOutput,
        crate::error::UpdateLaunchConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_launch_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_launch_configuration_response(response)
        }
    }
}

/// Operation shape for `UpdateReplicationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_replication_configuration`](crate::client::Client::update_replication_configuration).
///
/// See [`crate::client::fluent_builders::UpdateReplicationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateReplicationConfiguration {
    _private: (),
}
impl UpdateReplicationConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateReplicationConfigurationInput`](crate::input::UpdateReplicationConfigurationInput)
    pub fn builder() -> crate::input::update_replication_configuration_input::Builder {
        crate::input::update_replication_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateReplicationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateReplicationConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateReplicationConfigurationOutput,
        crate::error::UpdateReplicationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_replication_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_replication_configuration_response(response)
        }
    }
}

/// Operation shape for `UpdateReplicationConfigurationTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_replication_configuration_template`](crate::client::Client::update_replication_configuration_template).
///
/// See [`crate::client::fluent_builders::UpdateReplicationConfigurationTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateReplicationConfigurationTemplate {
    _private: (),
}
impl UpdateReplicationConfigurationTemplate {
    /// Creates a new builder-style object to manufacture [`UpdateReplicationConfigurationTemplateInput`](crate::input::UpdateReplicationConfigurationTemplateInput)
    pub fn builder() -> crate::input::update_replication_configuration_template_input::Builder {
        crate::input::update_replication_configuration_template_input::Builder::default()
    }
    /// Creates a new `UpdateReplicationConfigurationTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateReplicationConfigurationTemplate {
    type Output = std::result::Result<
        crate::output::UpdateReplicationConfigurationTemplateOutput,
        crate::error::UpdateReplicationConfigurationTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_replication_configuration_template_error(response)
        } else {
            crate::operation_deser::parse_update_replication_configuration_template_response(
                response,
            )
        }
    }
}
