// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Validate exception field.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationExceptionField {
    /// <p>Validate exception field name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Validate exception field message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ValidationExceptionField {
    /// <p>Validate exception field name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Validate exception field message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for ValidationExceptionField {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationExceptionField");
        formatter.field("name", &self.name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ValidationExceptionField`](crate::model::ValidationExceptionField)
pub mod validation_exception_field {
    /// A builder for [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Validate exception field name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Validate exception field name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Validate exception field message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Validate exception field message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationExceptionField`](crate::model::ValidationExceptionField)
        pub fn build(self) -> crate::model::ValidationExceptionField {
            crate::model::ValidationExceptionField {
                name: self.name,
                message: self.message,
            }
        }
    }
}
impl ValidationExceptionField {
    /// Creates a new builder-style object to manufacture [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    pub fn builder() -> crate::model::validation_exception_field::Builder {
        crate::model::validation_exception_field::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ValidationExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    CannotParse,
    #[allow(missing_docs)] // documentation missing in model
    FieldValidationFailed,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    UnknownOperation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ValidationExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "cannotParse" => ValidationExceptionReason::CannotParse,
            "fieldValidationFailed" => ValidationExceptionReason::FieldValidationFailed,
            "other" => ValidationExceptionReason::Other,
            "unknownOperation" => ValidationExceptionReason::UnknownOperation,
            other => ValidationExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ValidationExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ValidationExceptionReason::from(s))
    }
}
impl ValidationExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ValidationExceptionReason::CannotParse => "cannotParse",
            ValidationExceptionReason::FieldValidationFailed => "fieldValidationFailed",
            ValidationExceptionReason::Other => "other",
            ValidationExceptionReason::UnknownOperation => "unknownOperation",
            ValidationExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "cannotParse",
            "fieldValidationFailed",
            "other",
            "unknownOperation",
        ]
    }
}
impl AsRef<str> for ValidationExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A rule in the Point in Time (PIT) policy representing when to take snapshots and how long to retain them for.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PitPolicyRule {
    /// <p>The ID of the rule.</p>
    pub rule_id: i64,
    /// <p>The units used to measure the interval and retentionDuration.</p>
    pub units: std::option::Option<crate::model::PitPolicyRuleUnits>,
    /// <p>How often, in the chosen units, a snapshot should be taken.</p>
    pub interval: i32,
    /// <p>The duration to retain a snapshot for, in the chosen units.</p>
    pub retention_duration: i32,
    /// <p>Whether this rule is enabled or not.</p>
    pub enabled: std::option::Option<bool>,
}
impl PitPolicyRule {
    /// <p>The ID of the rule.</p>
    pub fn rule_id(&self) -> i64 {
        self.rule_id
    }
    /// <p>The units used to measure the interval and retentionDuration.</p>
    pub fn units(&self) -> std::option::Option<&crate::model::PitPolicyRuleUnits> {
        self.units.as_ref()
    }
    /// <p>How often, in the chosen units, a snapshot should be taken.</p>
    pub fn interval(&self) -> i32 {
        self.interval
    }
    /// <p>The duration to retain a snapshot for, in the chosen units.</p>
    pub fn retention_duration(&self) -> i32 {
        self.retention_duration
    }
    /// <p>Whether this rule is enabled or not.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
}
impl std::fmt::Debug for PitPolicyRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PitPolicyRule");
        formatter.field("rule_id", &self.rule_id);
        formatter.field("units", &self.units);
        formatter.field("interval", &self.interval);
        formatter.field("retention_duration", &self.retention_duration);
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`PitPolicyRule`](crate::model::PitPolicyRule)
pub mod pit_policy_rule {
    /// A builder for [`PitPolicyRule`](crate::model::PitPolicyRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_id: std::option::Option<i64>,
        pub(crate) units: std::option::Option<crate::model::PitPolicyRuleUnits>,
        pub(crate) interval: std::option::Option<i32>,
        pub(crate) retention_duration: std::option::Option<i32>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the rule.</p>
        pub fn rule_id(mut self, input: i64) -> Self {
            self.rule_id = Some(input);
            self
        }
        /// <p>The ID of the rule.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<i64>) -> Self {
            self.rule_id = input;
            self
        }
        /// <p>The units used to measure the interval and retentionDuration.</p>
        pub fn units(mut self, input: crate::model::PitPolicyRuleUnits) -> Self {
            self.units = Some(input);
            self
        }
        /// <p>The units used to measure the interval and retentionDuration.</p>
        pub fn set_units(
            mut self,
            input: std::option::Option<crate::model::PitPolicyRuleUnits>,
        ) -> Self {
            self.units = input;
            self
        }
        /// <p>How often, in the chosen units, a snapshot should be taken.</p>
        pub fn interval(mut self, input: i32) -> Self {
            self.interval = Some(input);
            self
        }
        /// <p>How often, in the chosen units, a snapshot should be taken.</p>
        pub fn set_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.interval = input;
            self
        }
        /// <p>The duration to retain a snapshot for, in the chosen units.</p>
        pub fn retention_duration(mut self, input: i32) -> Self {
            self.retention_duration = Some(input);
            self
        }
        /// <p>The duration to retain a snapshot for, in the chosen units.</p>
        pub fn set_retention_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.retention_duration = input;
            self
        }
        /// <p>Whether this rule is enabled or not.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Whether this rule is enabled or not.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`PitPolicyRule`](crate::model::PitPolicyRule)
        pub fn build(self) -> crate::model::PitPolicyRule {
            crate::model::PitPolicyRule {
                rule_id: self.rule_id.unwrap_or_default(),
                units: self.units,
                interval: self.interval.unwrap_or_default(),
                retention_duration: self.retention_duration.unwrap_or_default(),
                enabled: self.enabled,
            }
        }
    }
}
impl PitPolicyRule {
    /// Creates a new builder-style object to manufacture [`PitPolicyRule`](crate::model::PitPolicyRule)
    pub fn builder() -> crate::model::pit_policy_rule::Builder {
        crate::model::pit_policy_rule::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PitPolicyRuleUnits {
    #[allow(missing_docs)] // documentation missing in model
    Day,
    #[allow(missing_docs)] // documentation missing in model
    Hour,
    #[allow(missing_docs)] // documentation missing in model
    Minute,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PitPolicyRuleUnits {
    fn from(s: &str) -> Self {
        match s {
            "DAY" => PitPolicyRuleUnits::Day,
            "HOUR" => PitPolicyRuleUnits::Hour,
            "MINUTE" => PitPolicyRuleUnits::Minute,
            other => PitPolicyRuleUnits::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PitPolicyRuleUnits {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PitPolicyRuleUnits::from(s))
    }
}
impl PitPolicyRuleUnits {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PitPolicyRuleUnits::Day => "DAY",
            PitPolicyRuleUnits::Hour => "HOUR",
            PitPolicyRuleUnits::Minute => "MINUTE",
            PitPolicyRuleUnits::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DAY", "HOUR", "MINUTE"]
    }
}
impl AsRef<str> for PitPolicyRuleUnits {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReplicationConfigurationDataPlaneRouting {
    #[allow(missing_docs)] // documentation missing in model
    PrivateIp,
    #[allow(missing_docs)] // documentation missing in model
    PublicIp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReplicationConfigurationDataPlaneRouting {
    fn from(s: &str) -> Self {
        match s {
            "PRIVATE_IP" => ReplicationConfigurationDataPlaneRouting::PrivateIp,
            "PUBLIC_IP" => ReplicationConfigurationDataPlaneRouting::PublicIp,
            other => ReplicationConfigurationDataPlaneRouting::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReplicationConfigurationDataPlaneRouting {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReplicationConfigurationDataPlaneRouting::from(s))
    }
}
impl ReplicationConfigurationDataPlaneRouting {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReplicationConfigurationDataPlaneRouting::PrivateIp => "PRIVATE_IP",
            ReplicationConfigurationDataPlaneRouting::PublicIp => "PUBLIC_IP",
            ReplicationConfigurationDataPlaneRouting::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PRIVATE_IP", "PUBLIC_IP"]
    }
}
impl AsRef<str> for ReplicationConfigurationDataPlaneRouting {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReplicationConfigurationEbsEncryption {
    #[allow(missing_docs)] // documentation missing in model
    Custom,
    #[allow(missing_docs)] // documentation missing in model
    Default,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReplicationConfigurationEbsEncryption {
    fn from(s: &str) -> Self {
        match s {
            "CUSTOM" => ReplicationConfigurationEbsEncryption::Custom,
            "DEFAULT" => ReplicationConfigurationEbsEncryption::Default,
            other => ReplicationConfigurationEbsEncryption::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReplicationConfigurationEbsEncryption {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReplicationConfigurationEbsEncryption::from(s))
    }
}
impl ReplicationConfigurationEbsEncryption {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReplicationConfigurationEbsEncryption::Custom => "CUSTOM",
            ReplicationConfigurationEbsEncryption::Default => "DEFAULT",
            ReplicationConfigurationEbsEncryption::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CUSTOM", "DEFAULT"]
    }
}
impl AsRef<str> for ReplicationConfigurationEbsEncryption {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The configuration of a disk of the Source Server to be replicated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationConfigurationReplicatedDisk {
    /// <p>The name of the device.</p>
    pub device_name: std::option::Option<std::string::String>,
    /// <p>Whether to boot from this disk or not.</p>
    pub is_boot_disk: std::option::Option<bool>,
    /// <p>The Staging Disk EBS volume type to be used during replication.</p>
    pub staging_disk_type:
        std::option::Option<crate::model::ReplicationConfigurationReplicatedDiskStagingDiskType>,
    /// <p>The requested number of I/O operations per second (IOPS).</p>
    pub iops: i64,
    /// <p>The throughput to use for the EBS volume in MiB/s. This parameter is valid only for gp3 volumes.</p>
    pub throughput: i64,
}
impl ReplicationConfigurationReplicatedDisk {
    /// <p>The name of the device.</p>
    pub fn device_name(&self) -> std::option::Option<&str> {
        self.device_name.as_deref()
    }
    /// <p>Whether to boot from this disk or not.</p>
    pub fn is_boot_disk(&self) -> std::option::Option<bool> {
        self.is_boot_disk
    }
    /// <p>The Staging Disk EBS volume type to be used during replication.</p>
    pub fn staging_disk_type(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationReplicatedDiskStagingDiskType>
    {
        self.staging_disk_type.as_ref()
    }
    /// <p>The requested number of I/O operations per second (IOPS).</p>
    pub fn iops(&self) -> i64 {
        self.iops
    }
    /// <p>The throughput to use for the EBS volume in MiB/s. This parameter is valid only for gp3 volumes.</p>
    pub fn throughput(&self) -> i64 {
        self.throughput
    }
}
impl std::fmt::Debug for ReplicationConfigurationReplicatedDisk {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationConfigurationReplicatedDisk");
        formatter.field("device_name", &self.device_name);
        formatter.field("is_boot_disk", &self.is_boot_disk);
        formatter.field("staging_disk_type", &self.staging_disk_type);
        formatter.field("iops", &self.iops);
        formatter.field("throughput", &self.throughput);
        formatter.finish()
    }
}
/// See [`ReplicationConfigurationReplicatedDisk`](crate::model::ReplicationConfigurationReplicatedDisk)
pub mod replication_configuration_replicated_disk {
    /// A builder for [`ReplicationConfigurationReplicatedDisk`](crate::model::ReplicationConfigurationReplicatedDisk)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_name: std::option::Option<std::string::String>,
        pub(crate) is_boot_disk: std::option::Option<bool>,
        pub(crate) staging_disk_type: std::option::Option<
            crate::model::ReplicationConfigurationReplicatedDiskStagingDiskType,
        >,
        pub(crate) iops: std::option::Option<i64>,
        pub(crate) throughput: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name of the device.</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_name = Some(input.into());
            self
        }
        /// <p>The name of the device.</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_name = input;
            self
        }
        /// <p>Whether to boot from this disk or not.</p>
        pub fn is_boot_disk(mut self, input: bool) -> Self {
            self.is_boot_disk = Some(input);
            self
        }
        /// <p>Whether to boot from this disk or not.</p>
        pub fn set_is_boot_disk(mut self, input: std::option::Option<bool>) -> Self {
            self.is_boot_disk = input;
            self
        }
        /// <p>The Staging Disk EBS volume type to be used during replication.</p>
        pub fn staging_disk_type(
            mut self,
            input: crate::model::ReplicationConfigurationReplicatedDiskStagingDiskType,
        ) -> Self {
            self.staging_disk_type = Some(input);
            self
        }
        /// <p>The Staging Disk EBS volume type to be used during replication.</p>
        pub fn set_staging_disk_type(
            mut self,
            input: std::option::Option<
                crate::model::ReplicationConfigurationReplicatedDiskStagingDiskType,
            >,
        ) -> Self {
            self.staging_disk_type = input;
            self
        }
        /// <p>The requested number of I/O operations per second (IOPS).</p>
        pub fn iops(mut self, input: i64) -> Self {
            self.iops = Some(input);
            self
        }
        /// <p>The requested number of I/O operations per second (IOPS).</p>
        pub fn set_iops(mut self, input: std::option::Option<i64>) -> Self {
            self.iops = input;
            self
        }
        /// <p>The throughput to use for the EBS volume in MiB/s. This parameter is valid only for gp3 volumes.</p>
        pub fn throughput(mut self, input: i64) -> Self {
            self.throughput = Some(input);
            self
        }
        /// <p>The throughput to use for the EBS volume in MiB/s. This parameter is valid only for gp3 volumes.</p>
        pub fn set_throughput(mut self, input: std::option::Option<i64>) -> Self {
            self.throughput = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationConfigurationReplicatedDisk`](crate::model::ReplicationConfigurationReplicatedDisk)
        pub fn build(self) -> crate::model::ReplicationConfigurationReplicatedDisk {
            crate::model::ReplicationConfigurationReplicatedDisk {
                device_name: self.device_name,
                is_boot_disk: self.is_boot_disk,
                staging_disk_type: self.staging_disk_type,
                iops: self.iops.unwrap_or_default(),
                throughput: self.throughput.unwrap_or_default(),
            }
        }
    }
}
impl ReplicationConfigurationReplicatedDisk {
    /// Creates a new builder-style object to manufacture [`ReplicationConfigurationReplicatedDisk`](crate::model::ReplicationConfigurationReplicatedDisk)
    pub fn builder() -> crate::model::replication_configuration_replicated_disk::Builder {
        crate::model::replication_configuration_replicated_disk::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReplicationConfigurationReplicatedDiskStagingDiskType {
    #[allow(missing_docs)] // documentation missing in model
    Auto,
    #[allow(missing_docs)] // documentation missing in model
    Gp2,
    #[allow(missing_docs)] // documentation missing in model
    Gp3,
    #[allow(missing_docs)] // documentation missing in model
    Io1,
    #[allow(missing_docs)] // documentation missing in model
    Sc1,
    #[allow(missing_docs)] // documentation missing in model
    St1,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReplicationConfigurationReplicatedDiskStagingDiskType {
    fn from(s: &str) -> Self {
        match s {
            "AUTO" => ReplicationConfigurationReplicatedDiskStagingDiskType::Auto,
            "GP2" => ReplicationConfigurationReplicatedDiskStagingDiskType::Gp2,
            "GP3" => ReplicationConfigurationReplicatedDiskStagingDiskType::Gp3,
            "IO1" => ReplicationConfigurationReplicatedDiskStagingDiskType::Io1,
            "SC1" => ReplicationConfigurationReplicatedDiskStagingDiskType::Sc1,
            "ST1" => ReplicationConfigurationReplicatedDiskStagingDiskType::St1,
            "STANDARD" => ReplicationConfigurationReplicatedDiskStagingDiskType::Standard,
            other => {
                ReplicationConfigurationReplicatedDiskStagingDiskType::Unknown(other.to_owned())
            }
        }
    }
}
impl std::str::FromStr for ReplicationConfigurationReplicatedDiskStagingDiskType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReplicationConfigurationReplicatedDiskStagingDiskType::from(
            s,
        ))
    }
}
impl ReplicationConfigurationReplicatedDiskStagingDiskType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReplicationConfigurationReplicatedDiskStagingDiskType::Auto => "AUTO",
            ReplicationConfigurationReplicatedDiskStagingDiskType::Gp2 => "GP2",
            ReplicationConfigurationReplicatedDiskStagingDiskType::Gp3 => "GP3",
            ReplicationConfigurationReplicatedDiskStagingDiskType::Io1 => "IO1",
            ReplicationConfigurationReplicatedDiskStagingDiskType::Sc1 => "SC1",
            ReplicationConfigurationReplicatedDiskStagingDiskType::St1 => "ST1",
            ReplicationConfigurationReplicatedDiskStagingDiskType::Standard => "STANDARD",
            ReplicationConfigurationReplicatedDiskStagingDiskType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTO", "GP2", "GP3", "IO1", "SC1", "ST1", "STANDARD"]
    }
}
impl AsRef<str> for ReplicationConfigurationReplicatedDiskStagingDiskType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReplicationConfigurationDefaultLargeStagingDiskType {
    #[allow(missing_docs)] // documentation missing in model
    Gp2,
    #[allow(missing_docs)] // documentation missing in model
    Gp3,
    #[allow(missing_docs)] // documentation missing in model
    St1,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReplicationConfigurationDefaultLargeStagingDiskType {
    fn from(s: &str) -> Self {
        match s {
            "GP2" => ReplicationConfigurationDefaultLargeStagingDiskType::Gp2,
            "GP3" => ReplicationConfigurationDefaultLargeStagingDiskType::Gp3,
            "ST1" => ReplicationConfigurationDefaultLargeStagingDiskType::St1,
            other => ReplicationConfigurationDefaultLargeStagingDiskType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReplicationConfigurationDefaultLargeStagingDiskType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReplicationConfigurationDefaultLargeStagingDiskType::from(s))
    }
}
impl ReplicationConfigurationDefaultLargeStagingDiskType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReplicationConfigurationDefaultLargeStagingDiskType::Gp2 => "GP2",
            ReplicationConfigurationDefaultLargeStagingDiskType::Gp3 => "GP3",
            ReplicationConfigurationDefaultLargeStagingDiskType::St1 => "ST1",
            ReplicationConfigurationDefaultLargeStagingDiskType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GP2", "GP3", "ST1"]
    }
}
impl AsRef<str> for ReplicationConfigurationDefaultLargeStagingDiskType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Configuration of a machine's license.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Licensing {
    /// <p>Whether to enable "Bring your own license" or not.</p>
    pub os_byol: std::option::Option<bool>,
}
impl Licensing {
    /// <p>Whether to enable "Bring your own license" or not.</p>
    pub fn os_byol(&self) -> std::option::Option<bool> {
        self.os_byol
    }
}
impl std::fmt::Debug for Licensing {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Licensing");
        formatter.field("os_byol", &self.os_byol);
        formatter.finish()
    }
}
/// See [`Licensing`](crate::model::Licensing)
pub mod licensing {
    /// A builder for [`Licensing`](crate::model::Licensing)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) os_byol: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Whether to enable "Bring your own license" or not.</p>
        pub fn os_byol(mut self, input: bool) -> Self {
            self.os_byol = Some(input);
            self
        }
        /// <p>Whether to enable "Bring your own license" or not.</p>
        pub fn set_os_byol(mut self, input: std::option::Option<bool>) -> Self {
            self.os_byol = input;
            self
        }
        /// Consumes the builder and constructs a [`Licensing`](crate::model::Licensing)
        pub fn build(self) -> crate::model::Licensing {
            crate::model::Licensing {
                os_byol: self.os_byol,
            }
        }
    }
}
impl Licensing {
    /// Creates a new builder-style object to manufacture [`Licensing`](crate::model::Licensing)
    pub fn builder() -> crate::model::licensing::Builder {
        crate::model::licensing::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TargetInstanceTypeRightSizingMethod {
    #[allow(missing_docs)] // documentation missing in model
    Basic,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TargetInstanceTypeRightSizingMethod {
    fn from(s: &str) -> Self {
        match s {
            "BASIC" => TargetInstanceTypeRightSizingMethod::Basic,
            "NONE" => TargetInstanceTypeRightSizingMethod::None,
            other => TargetInstanceTypeRightSizingMethod::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TargetInstanceTypeRightSizingMethod {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TargetInstanceTypeRightSizingMethod::from(s))
    }
}
impl TargetInstanceTypeRightSizingMethod {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TargetInstanceTypeRightSizingMethod::Basic => "BASIC",
            TargetInstanceTypeRightSizingMethod::None => "NONE",
            TargetInstanceTypeRightSizingMethod::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BASIC", "NONE"]
    }
}
impl AsRef<str> for TargetInstanceTypeRightSizingMethod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LaunchDisposition {
    #[allow(missing_docs)] // documentation missing in model
    Started,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LaunchDisposition {
    fn from(s: &str) -> Self {
        match s {
            "STARTED" => LaunchDisposition::Started,
            "STOPPED" => LaunchDisposition::Stopped,
            other => LaunchDisposition::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LaunchDisposition {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LaunchDisposition::from(s))
    }
}
impl LaunchDisposition {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LaunchDisposition::Started => "STARTED",
            LaunchDisposition::Stopped => "STOPPED",
            LaunchDisposition::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["STARTED", "STOPPED"]
    }
}
impl AsRef<str> for LaunchDisposition {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Properties of the Source Server machine.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceProperties {
    /// <p>The date and time the Source Properties were last updated on.</p>
    pub last_updated_date_time: std::option::Option<std::string::String>,
    /// <p>The recommended EC2 instance type that will be used when recovering the Source Server.</p>
    pub recommended_instance_type: std::option::Option<std::string::String>,
    /// <p>Hints used to uniquely identify a machine.</p>
    pub identification_hints: std::option::Option<crate::model::IdentificationHints>,
    /// <p>An array of network interfaces.</p>
    pub network_interfaces: std::option::Option<std::vec::Vec<crate::model::NetworkInterface>>,
    /// <p>An array of disks.</p>
    pub disks: std::option::Option<std::vec::Vec<crate::model::Disk>>,
    /// <p>An array of CPUs.</p>
    pub cpus: std::option::Option<std::vec::Vec<crate::model::Cpu>>,
    /// <p>The amount of RAM in bytes.</p>
    pub ram_bytes: i64,
    /// <p>Operating system.</p>
    pub os: std::option::Option<crate::model::Os>,
}
impl SourceProperties {
    /// <p>The date and time the Source Properties were last updated on.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&str> {
        self.last_updated_date_time.as_deref()
    }
    /// <p>The recommended EC2 instance type that will be used when recovering the Source Server.</p>
    pub fn recommended_instance_type(&self) -> std::option::Option<&str> {
        self.recommended_instance_type.as_deref()
    }
    /// <p>Hints used to uniquely identify a machine.</p>
    pub fn identification_hints(&self) -> std::option::Option<&crate::model::IdentificationHints> {
        self.identification_hints.as_ref()
    }
    /// <p>An array of network interfaces.</p>
    pub fn network_interfaces(&self) -> std::option::Option<&[crate::model::NetworkInterface]> {
        self.network_interfaces.as_deref()
    }
    /// <p>An array of disks.</p>
    pub fn disks(&self) -> std::option::Option<&[crate::model::Disk]> {
        self.disks.as_deref()
    }
    /// <p>An array of CPUs.</p>
    pub fn cpus(&self) -> std::option::Option<&[crate::model::Cpu]> {
        self.cpus.as_deref()
    }
    /// <p>The amount of RAM in bytes.</p>
    pub fn ram_bytes(&self) -> i64 {
        self.ram_bytes
    }
    /// <p>Operating system.</p>
    pub fn os(&self) -> std::option::Option<&crate::model::Os> {
        self.os.as_ref()
    }
}
impl std::fmt::Debug for SourceProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceProperties");
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field("recommended_instance_type", &self.recommended_instance_type);
        formatter.field("identification_hints", &self.identification_hints);
        formatter.field("network_interfaces", &self.network_interfaces);
        formatter.field("disks", &self.disks);
        formatter.field("cpus", &self.cpus);
        formatter.field("ram_bytes", &self.ram_bytes);
        formatter.field("os", &self.os);
        formatter.finish()
    }
}
/// See [`SourceProperties`](crate::model::SourceProperties)
pub mod source_properties {
    /// A builder for [`SourceProperties`](crate::model::SourceProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) last_updated_date_time: std::option::Option<std::string::String>,
        pub(crate) recommended_instance_type: std::option::Option<std::string::String>,
        pub(crate) identification_hints: std::option::Option<crate::model::IdentificationHints>,
        pub(crate) network_interfaces:
            std::option::Option<std::vec::Vec<crate::model::NetworkInterface>>,
        pub(crate) disks: std::option::Option<std::vec::Vec<crate::model::Disk>>,
        pub(crate) cpus: std::option::Option<std::vec::Vec<crate::model::Cpu>>,
        pub(crate) ram_bytes: std::option::Option<i64>,
        pub(crate) os: std::option::Option<crate::model::Os>,
    }
    impl Builder {
        /// <p>The date and time the Source Properties were last updated on.</p>
        pub fn last_updated_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_updated_date_time = Some(input.into());
            self
        }
        /// <p>The date and time the Source Properties were last updated on.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// <p>The recommended EC2 instance type that will be used when recovering the Source Server.</p>
        pub fn recommended_instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommended_instance_type = Some(input.into());
            self
        }
        /// <p>The recommended EC2 instance type that will be used when recovering the Source Server.</p>
        pub fn set_recommended_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommended_instance_type = input;
            self
        }
        /// <p>Hints used to uniquely identify a machine.</p>
        pub fn identification_hints(mut self, input: crate::model::IdentificationHints) -> Self {
            self.identification_hints = Some(input);
            self
        }
        /// <p>Hints used to uniquely identify a machine.</p>
        pub fn set_identification_hints(
            mut self,
            input: std::option::Option<crate::model::IdentificationHints>,
        ) -> Self {
            self.identification_hints = input;
            self
        }
        /// Appends an item to `network_interfaces`.
        ///
        /// To override the contents of this collection use [`set_network_interfaces`](Self::set_network_interfaces).
        ///
        /// <p>An array of network interfaces.</p>
        pub fn network_interfaces(mut self, input: crate::model::NetworkInterface) -> Self {
            let mut v = self.network_interfaces.unwrap_or_default();
            v.push(input);
            self.network_interfaces = Some(v);
            self
        }
        /// <p>An array of network interfaces.</p>
        pub fn set_network_interfaces(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NetworkInterface>>,
        ) -> Self {
            self.network_interfaces = input;
            self
        }
        /// Appends an item to `disks`.
        ///
        /// To override the contents of this collection use [`set_disks`](Self::set_disks).
        ///
        /// <p>An array of disks.</p>
        pub fn disks(mut self, input: crate::model::Disk) -> Self {
            let mut v = self.disks.unwrap_or_default();
            v.push(input);
            self.disks = Some(v);
            self
        }
        /// <p>An array of disks.</p>
        pub fn set_disks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Disk>>,
        ) -> Self {
            self.disks = input;
            self
        }
        /// Appends an item to `cpus`.
        ///
        /// To override the contents of this collection use [`set_cpus`](Self::set_cpus).
        ///
        /// <p>An array of CPUs.</p>
        pub fn cpus(mut self, input: crate::model::Cpu) -> Self {
            let mut v = self.cpus.unwrap_or_default();
            v.push(input);
            self.cpus = Some(v);
            self
        }
        /// <p>An array of CPUs.</p>
        pub fn set_cpus(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Cpu>>,
        ) -> Self {
            self.cpus = input;
            self
        }
        /// <p>The amount of RAM in bytes.</p>
        pub fn ram_bytes(mut self, input: i64) -> Self {
            self.ram_bytes = Some(input);
            self
        }
        /// <p>The amount of RAM in bytes.</p>
        pub fn set_ram_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.ram_bytes = input;
            self
        }
        /// <p>Operating system.</p>
        pub fn os(mut self, input: crate::model::Os) -> Self {
            self.os = Some(input);
            self
        }
        /// <p>Operating system.</p>
        pub fn set_os(mut self, input: std::option::Option<crate::model::Os>) -> Self {
            self.os = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceProperties`](crate::model::SourceProperties)
        pub fn build(self) -> crate::model::SourceProperties {
            crate::model::SourceProperties {
                last_updated_date_time: self.last_updated_date_time,
                recommended_instance_type: self.recommended_instance_type,
                identification_hints: self.identification_hints,
                network_interfaces: self.network_interfaces,
                disks: self.disks,
                cpus: self.cpus,
                ram_bytes: self.ram_bytes.unwrap_or_default(),
                os: self.os,
            }
        }
    }
}
impl SourceProperties {
    /// Creates a new builder-style object to manufacture [`SourceProperties`](crate::model::SourceProperties)
    pub fn builder() -> crate::model::source_properties::Builder {
        crate::model::source_properties::Builder::default()
    }
}

/// <p>Operating System.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Os {
    /// <p>The long name of the Operating System.</p>
    pub full_string: std::option::Option<std::string::String>,
}
impl Os {
    /// <p>The long name of the Operating System.</p>
    pub fn full_string(&self) -> std::option::Option<&str> {
        self.full_string.as_deref()
    }
}
impl std::fmt::Debug for Os {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Os");
        formatter.field("full_string", &self.full_string);
        formatter.finish()
    }
}
/// See [`Os`](crate::model::Os)
pub mod os {
    /// A builder for [`Os`](crate::model::Os)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) full_string: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The long name of the Operating System.</p>
        pub fn full_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.full_string = Some(input.into());
            self
        }
        /// <p>The long name of the Operating System.</p>
        pub fn set_full_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.full_string = input;
            self
        }
        /// Consumes the builder and constructs a [`Os`](crate::model::Os)
        pub fn build(self) -> crate::model::Os {
            crate::model::Os {
                full_string: self.full_string,
            }
        }
    }
}
impl Os {
    /// Creates a new builder-style object to manufacture [`Os`](crate::model::Os)
    pub fn builder() -> crate::model::os::Builder {
        crate::model::os::Builder::default()
    }
}

/// <p>Information about a server's CPU.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Cpu {
    /// <p>The number of CPU cores.</p>
    pub cores: i64,
    /// <p>The model name of the CPU.</p>
    pub model_name: std::option::Option<std::string::String>,
}
impl Cpu {
    /// <p>The number of CPU cores.</p>
    pub fn cores(&self) -> i64 {
        self.cores
    }
    /// <p>The model name of the CPU.</p>
    pub fn model_name(&self) -> std::option::Option<&str> {
        self.model_name.as_deref()
    }
}
impl std::fmt::Debug for Cpu {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Cpu");
        formatter.field("cores", &self.cores);
        formatter.field("model_name", &self.model_name);
        formatter.finish()
    }
}
/// See [`Cpu`](crate::model::Cpu)
pub mod cpu {
    /// A builder for [`Cpu`](crate::model::Cpu)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cores: std::option::Option<i64>,
        pub(crate) model_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of CPU cores.</p>
        pub fn cores(mut self, input: i64) -> Self {
            self.cores = Some(input);
            self
        }
        /// <p>The number of CPU cores.</p>
        pub fn set_cores(mut self, input: std::option::Option<i64>) -> Self {
            self.cores = input;
            self
        }
        /// <p>The model name of the CPU.</p>
        pub fn model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_name = Some(input.into());
            self
        }
        /// <p>The model name of the CPU.</p>
        pub fn set_model_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_name = input;
            self
        }
        /// Consumes the builder and constructs a [`Cpu`](crate::model::Cpu)
        pub fn build(self) -> crate::model::Cpu {
            crate::model::Cpu {
                cores: self.cores.unwrap_or_default(),
                model_name: self.model_name,
            }
        }
    }
}
impl Cpu {
    /// Creates a new builder-style object to manufacture [`Cpu`](crate::model::Cpu)
    pub fn builder() -> crate::model::cpu::Builder {
        crate::model::cpu::Builder::default()
    }
}

/// <p>An object representing a data storage device on a server.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Disk {
    /// <p>The disk or device name.</p>
    pub device_name: std::option::Option<std::string::String>,
    /// <p>The amount of storage on the disk in bytes.</p>
    pub bytes: i64,
}
impl Disk {
    /// <p>The disk or device name.</p>
    pub fn device_name(&self) -> std::option::Option<&str> {
        self.device_name.as_deref()
    }
    /// <p>The amount of storage on the disk in bytes.</p>
    pub fn bytes(&self) -> i64 {
        self.bytes
    }
}
impl std::fmt::Debug for Disk {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Disk");
        formatter.field("device_name", &self.device_name);
        formatter.field("bytes", &self.bytes);
        formatter.finish()
    }
}
/// See [`Disk`](crate::model::Disk)
pub mod disk {
    /// A builder for [`Disk`](crate::model::Disk)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_name: std::option::Option<std::string::String>,
        pub(crate) bytes: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The disk or device name.</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_name = Some(input.into());
            self
        }
        /// <p>The disk or device name.</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_name = input;
            self
        }
        /// <p>The amount of storage on the disk in bytes.</p>
        pub fn bytes(mut self, input: i64) -> Self {
            self.bytes = Some(input);
            self
        }
        /// <p>The amount of storage on the disk in bytes.</p>
        pub fn set_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.bytes = input;
            self
        }
        /// Consumes the builder and constructs a [`Disk`](crate::model::Disk)
        pub fn build(self) -> crate::model::Disk {
            crate::model::Disk {
                device_name: self.device_name,
                bytes: self.bytes.unwrap_or_default(),
            }
        }
    }
}
impl Disk {
    /// Creates a new builder-style object to manufacture [`Disk`](crate::model::Disk)
    pub fn builder() -> crate::model::disk::Builder {
        crate::model::disk::Builder::default()
    }
}

/// <p>Network interface.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkInterface {
    /// <p>The MAC address of the network interface.</p>
    pub mac_address: std::option::Option<std::string::String>,
    /// <p>Network interface IPs.</p>
    pub ips: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Whether this is the primary network interface.</p>
    pub is_primary: std::option::Option<bool>,
}
impl NetworkInterface {
    /// <p>The MAC address of the network interface.</p>
    pub fn mac_address(&self) -> std::option::Option<&str> {
        self.mac_address.as_deref()
    }
    /// <p>Network interface IPs.</p>
    pub fn ips(&self) -> std::option::Option<&[std::string::String]> {
        self.ips.as_deref()
    }
    /// <p>Whether this is the primary network interface.</p>
    pub fn is_primary(&self) -> std::option::Option<bool> {
        self.is_primary
    }
}
impl std::fmt::Debug for NetworkInterface {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkInterface");
        formatter.field("mac_address", &self.mac_address);
        formatter.field("ips", &self.ips);
        formatter.field("is_primary", &self.is_primary);
        formatter.finish()
    }
}
/// See [`NetworkInterface`](crate::model::NetworkInterface)
pub mod network_interface {
    /// A builder for [`NetworkInterface`](crate::model::NetworkInterface)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mac_address: std::option::Option<std::string::String>,
        pub(crate) ips: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) is_primary: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The MAC address of the network interface.</p>
        pub fn mac_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.mac_address = Some(input.into());
            self
        }
        /// <p>The MAC address of the network interface.</p>
        pub fn set_mac_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mac_address = input;
            self
        }
        /// Appends an item to `ips`.
        ///
        /// To override the contents of this collection use [`set_ips`](Self::set_ips).
        ///
        /// <p>Network interface IPs.</p>
        pub fn ips(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ips.unwrap_or_default();
            v.push(input.into());
            self.ips = Some(v);
            self
        }
        /// <p>Network interface IPs.</p>
        pub fn set_ips(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ips = input;
            self
        }
        /// <p>Whether this is the primary network interface.</p>
        pub fn is_primary(mut self, input: bool) -> Self {
            self.is_primary = Some(input);
            self
        }
        /// <p>Whether this is the primary network interface.</p>
        pub fn set_is_primary(mut self, input: std::option::Option<bool>) -> Self {
            self.is_primary = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkInterface`](crate::model::NetworkInterface)
        pub fn build(self) -> crate::model::NetworkInterface {
            crate::model::NetworkInterface {
                mac_address: self.mac_address,
                ips: self.ips,
                is_primary: self.is_primary,
            }
        }
    }
}
impl NetworkInterface {
    /// Creates a new builder-style object to manufacture [`NetworkInterface`](crate::model::NetworkInterface)
    pub fn builder() -> crate::model::network_interface::Builder {
        crate::model::network_interface::Builder::default()
    }
}

/// <p>Hints used to uniquely identify a machine.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IdentificationHints {
    /// <p>Fully Qualified Domain Name identification hint.</p>
    pub fqdn: std::option::Option<std::string::String>,
    /// <p>Hostname identification hint.</p>
    pub hostname: std::option::Option<std::string::String>,
    /// <p>vCenter VM path identification hint.</p>
    pub vm_ware_uuid: std::option::Option<std::string::String>,
    /// <p>AWS Instance ID identification hint.</p>
    pub aws_instance_id: std::option::Option<std::string::String>,
}
impl IdentificationHints {
    /// <p>Fully Qualified Domain Name identification hint.</p>
    pub fn fqdn(&self) -> std::option::Option<&str> {
        self.fqdn.as_deref()
    }
    /// <p>Hostname identification hint.</p>
    pub fn hostname(&self) -> std::option::Option<&str> {
        self.hostname.as_deref()
    }
    /// <p>vCenter VM path identification hint.</p>
    pub fn vm_ware_uuid(&self) -> std::option::Option<&str> {
        self.vm_ware_uuid.as_deref()
    }
    /// <p>AWS Instance ID identification hint.</p>
    pub fn aws_instance_id(&self) -> std::option::Option<&str> {
        self.aws_instance_id.as_deref()
    }
}
impl std::fmt::Debug for IdentificationHints {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IdentificationHints");
        formatter.field("fqdn", &self.fqdn);
        formatter.field("hostname", &self.hostname);
        formatter.field("vm_ware_uuid", &self.vm_ware_uuid);
        formatter.field("aws_instance_id", &self.aws_instance_id);
        formatter.finish()
    }
}
/// See [`IdentificationHints`](crate::model::IdentificationHints)
pub mod identification_hints {
    /// A builder for [`IdentificationHints`](crate::model::IdentificationHints)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fqdn: std::option::Option<std::string::String>,
        pub(crate) hostname: std::option::Option<std::string::String>,
        pub(crate) vm_ware_uuid: std::option::Option<std::string::String>,
        pub(crate) aws_instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Fully Qualified Domain Name identification hint.</p>
        pub fn fqdn(mut self, input: impl Into<std::string::String>) -> Self {
            self.fqdn = Some(input.into());
            self
        }
        /// <p>Fully Qualified Domain Name identification hint.</p>
        pub fn set_fqdn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fqdn = input;
            self
        }
        /// <p>Hostname identification hint.</p>
        pub fn hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.hostname = Some(input.into());
            self
        }
        /// <p>Hostname identification hint.</p>
        pub fn set_hostname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hostname = input;
            self
        }
        /// <p>vCenter VM path identification hint.</p>
        pub fn vm_ware_uuid(mut self, input: impl Into<std::string::String>) -> Self {
            self.vm_ware_uuid = Some(input.into());
            self
        }
        /// <p>vCenter VM path identification hint.</p>
        pub fn set_vm_ware_uuid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vm_ware_uuid = input;
            self
        }
        /// <p>AWS Instance ID identification hint.</p>
        pub fn aws_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_instance_id = Some(input.into());
            self
        }
        /// <p>AWS Instance ID identification hint.</p>
        pub fn set_aws_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`IdentificationHints`](crate::model::IdentificationHints)
        pub fn build(self) -> crate::model::IdentificationHints {
            crate::model::IdentificationHints {
                fqdn: self.fqdn,
                hostname: self.hostname,
                vm_ware_uuid: self.vm_ware_uuid,
                aws_instance_id: self.aws_instance_id,
            }
        }
    }
}
impl IdentificationHints {
    /// Creates a new builder-style object to manufacture [`IdentificationHints`](crate::model::IdentificationHints)
    pub fn builder() -> crate::model::identification_hints::Builder {
        crate::model::identification_hints::Builder::default()
    }
}

/// <p>An object representing the Source Server Lifecycle.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LifeCycle {
    /// <p>The date and time of when the Source Server was added to the service.</p>
    pub added_to_service_date_time: std::option::Option<std::string::String>,
    /// <p>The date and time of the first byte that was replicated from the Source Server.</p>
    pub first_byte_date_time: std::option::Option<std::string::String>,
    /// <p>The amount of time that the Source Server has been replicating for.</p>
    pub elapsed_replication_duration: std::option::Option<std::string::String>,
    /// <p>The date and time this Source Server was last seen by the service.</p>
    pub last_seen_by_service_date_time: std::option::Option<std::string::String>,
    /// <p>An object containing information regarding the last launch of the Source Server.</p>
    pub last_launch: std::option::Option<crate::model::LifeCycleLastLaunch>,
}
impl LifeCycle {
    /// <p>The date and time of when the Source Server was added to the service.</p>
    pub fn added_to_service_date_time(&self) -> std::option::Option<&str> {
        self.added_to_service_date_time.as_deref()
    }
    /// <p>The date and time of the first byte that was replicated from the Source Server.</p>
    pub fn first_byte_date_time(&self) -> std::option::Option<&str> {
        self.first_byte_date_time.as_deref()
    }
    /// <p>The amount of time that the Source Server has been replicating for.</p>
    pub fn elapsed_replication_duration(&self) -> std::option::Option<&str> {
        self.elapsed_replication_duration.as_deref()
    }
    /// <p>The date and time this Source Server was last seen by the service.</p>
    pub fn last_seen_by_service_date_time(&self) -> std::option::Option<&str> {
        self.last_seen_by_service_date_time.as_deref()
    }
    /// <p>An object containing information regarding the last launch of the Source Server.</p>
    pub fn last_launch(&self) -> std::option::Option<&crate::model::LifeCycleLastLaunch> {
        self.last_launch.as_ref()
    }
}
impl std::fmt::Debug for LifeCycle {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LifeCycle");
        formatter.field(
            "added_to_service_date_time",
            &self.added_to_service_date_time,
        );
        formatter.field("first_byte_date_time", &self.first_byte_date_time);
        formatter.field(
            "elapsed_replication_duration",
            &self.elapsed_replication_duration,
        );
        formatter.field(
            "last_seen_by_service_date_time",
            &self.last_seen_by_service_date_time,
        );
        formatter.field("last_launch", &self.last_launch);
        formatter.finish()
    }
}
/// See [`LifeCycle`](crate::model::LifeCycle)
pub mod life_cycle {
    /// A builder for [`LifeCycle`](crate::model::LifeCycle)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) added_to_service_date_time: std::option::Option<std::string::String>,
        pub(crate) first_byte_date_time: std::option::Option<std::string::String>,
        pub(crate) elapsed_replication_duration: std::option::Option<std::string::String>,
        pub(crate) last_seen_by_service_date_time: std::option::Option<std::string::String>,
        pub(crate) last_launch: std::option::Option<crate::model::LifeCycleLastLaunch>,
    }
    impl Builder {
        /// <p>The date and time of when the Source Server was added to the service.</p>
        pub fn added_to_service_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.added_to_service_date_time = Some(input.into());
            self
        }
        /// <p>The date and time of when the Source Server was added to the service.</p>
        pub fn set_added_to_service_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.added_to_service_date_time = input;
            self
        }
        /// <p>The date and time of the first byte that was replicated from the Source Server.</p>
        pub fn first_byte_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.first_byte_date_time = Some(input.into());
            self
        }
        /// <p>The date and time of the first byte that was replicated from the Source Server.</p>
        pub fn set_first_byte_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.first_byte_date_time = input;
            self
        }
        /// <p>The amount of time that the Source Server has been replicating for.</p>
        pub fn elapsed_replication_duration(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.elapsed_replication_duration = Some(input.into());
            self
        }
        /// <p>The amount of time that the Source Server has been replicating for.</p>
        pub fn set_elapsed_replication_duration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.elapsed_replication_duration = input;
            self
        }
        /// <p>The date and time this Source Server was last seen by the service.</p>
        pub fn last_seen_by_service_date_time(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.last_seen_by_service_date_time = Some(input.into());
            self
        }
        /// <p>The date and time this Source Server was last seen by the service.</p>
        pub fn set_last_seen_by_service_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_seen_by_service_date_time = input;
            self
        }
        /// <p>An object containing information regarding the last launch of the Source Server.</p>
        pub fn last_launch(mut self, input: crate::model::LifeCycleLastLaunch) -> Self {
            self.last_launch = Some(input);
            self
        }
        /// <p>An object containing information regarding the last launch of the Source Server.</p>
        pub fn set_last_launch(
            mut self,
            input: std::option::Option<crate::model::LifeCycleLastLaunch>,
        ) -> Self {
            self.last_launch = input;
            self
        }
        /// Consumes the builder and constructs a [`LifeCycle`](crate::model::LifeCycle)
        pub fn build(self) -> crate::model::LifeCycle {
            crate::model::LifeCycle {
                added_to_service_date_time: self.added_to_service_date_time,
                first_byte_date_time: self.first_byte_date_time,
                elapsed_replication_duration: self.elapsed_replication_duration,
                last_seen_by_service_date_time: self.last_seen_by_service_date_time,
                last_launch: self.last_launch,
            }
        }
    }
}
impl LifeCycle {
    /// Creates a new builder-style object to manufacture [`LifeCycle`](crate::model::LifeCycle)
    pub fn builder() -> crate::model::life_cycle::Builder {
        crate::model::life_cycle::Builder::default()
    }
}

/// <p>An object containing information regarding the last launch of a Source Server.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LifeCycleLastLaunch {
    /// <p>An object containing information regarding the initiation of the last launch of a Source Server.</p>
    pub initiated: std::option::Option<crate::model::LifeCycleLastLaunchInitiated>,
}
impl LifeCycleLastLaunch {
    /// <p>An object containing information regarding the initiation of the last launch of a Source Server.</p>
    pub fn initiated(&self) -> std::option::Option<&crate::model::LifeCycleLastLaunchInitiated> {
        self.initiated.as_ref()
    }
}
impl std::fmt::Debug for LifeCycleLastLaunch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LifeCycleLastLaunch");
        formatter.field("initiated", &self.initiated);
        formatter.finish()
    }
}
/// See [`LifeCycleLastLaunch`](crate::model::LifeCycleLastLaunch)
pub mod life_cycle_last_launch {
    /// A builder for [`LifeCycleLastLaunch`](crate::model::LifeCycleLastLaunch)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) initiated: std::option::Option<crate::model::LifeCycleLastLaunchInitiated>,
    }
    impl Builder {
        /// <p>An object containing information regarding the initiation of the last launch of a Source Server.</p>
        pub fn initiated(mut self, input: crate::model::LifeCycleLastLaunchInitiated) -> Self {
            self.initiated = Some(input);
            self
        }
        /// <p>An object containing information regarding the initiation of the last launch of a Source Server.</p>
        pub fn set_initiated(
            mut self,
            input: std::option::Option<crate::model::LifeCycleLastLaunchInitiated>,
        ) -> Self {
            self.initiated = input;
            self
        }
        /// Consumes the builder and constructs a [`LifeCycleLastLaunch`](crate::model::LifeCycleLastLaunch)
        pub fn build(self) -> crate::model::LifeCycleLastLaunch {
            crate::model::LifeCycleLastLaunch {
                initiated: self.initiated,
            }
        }
    }
}
impl LifeCycleLastLaunch {
    /// Creates a new builder-style object to manufacture [`LifeCycleLastLaunch`](crate::model::LifeCycleLastLaunch)
    pub fn builder() -> crate::model::life_cycle_last_launch::Builder {
        crate::model::life_cycle_last_launch::Builder::default()
    }
}

/// <p>An object containing information regarding the initiation of the last launch of a Source Server.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LifeCycleLastLaunchInitiated {
    /// <p>The date and time the last Source Server launch was initiated.</p>
    pub api_call_date_time: std::option::Option<std::string::String>,
    /// <p>The ID of the Job that was used to last launch the Source Server.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The Job type that was used to last launch the Source Server.</p>
    pub r#type: std::option::Option<crate::model::LastLaunchType>,
}
impl LifeCycleLastLaunchInitiated {
    /// <p>The date and time the last Source Server launch was initiated.</p>
    pub fn api_call_date_time(&self) -> std::option::Option<&str> {
        self.api_call_date_time.as_deref()
    }
    /// <p>The ID of the Job that was used to last launch the Source Server.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The Job type that was used to last launch the Source Server.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::LastLaunchType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for LifeCycleLastLaunchInitiated {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LifeCycleLastLaunchInitiated");
        formatter.field("api_call_date_time", &self.api_call_date_time);
        formatter.field("job_id", &self.job_id);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`LifeCycleLastLaunchInitiated`](crate::model::LifeCycleLastLaunchInitiated)
pub mod life_cycle_last_launch_initiated {
    /// A builder for [`LifeCycleLastLaunchInitiated`](crate::model::LifeCycleLastLaunchInitiated)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_call_date_time: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::LastLaunchType>,
    }
    impl Builder {
        /// <p>The date and time the last Source Server launch was initiated.</p>
        pub fn api_call_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_call_date_time = Some(input.into());
            self
        }
        /// <p>The date and time the last Source Server launch was initiated.</p>
        pub fn set_api_call_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_call_date_time = input;
            self
        }
        /// <p>The ID of the Job that was used to last launch the Source Server.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID of the Job that was used to last launch the Source Server.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The Job type that was used to last launch the Source Server.</p>
        pub fn r#type(mut self, input: crate::model::LastLaunchType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The Job type that was used to last launch the Source Server.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::LastLaunchType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`LifeCycleLastLaunchInitiated`](crate::model::LifeCycleLastLaunchInitiated)
        pub fn build(self) -> crate::model::LifeCycleLastLaunchInitiated {
            crate::model::LifeCycleLastLaunchInitiated {
                api_call_date_time: self.api_call_date_time,
                job_id: self.job_id,
                r#type: self.r#type,
            }
        }
    }
}
impl LifeCycleLastLaunchInitiated {
    /// Creates a new builder-style object to manufacture [`LifeCycleLastLaunchInitiated`](crate::model::LifeCycleLastLaunchInitiated)
    pub fn builder() -> crate::model::life_cycle_last_launch_initiated::Builder {
        crate::model::life_cycle_last_launch_initiated::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LastLaunchType {
    #[allow(missing_docs)] // documentation missing in model
    Drill,
    #[allow(missing_docs)] // documentation missing in model
    Recovery,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LastLaunchType {
    fn from(s: &str) -> Self {
        match s {
            "DRILL" => LastLaunchType::Drill,
            "RECOVERY" => LastLaunchType::Recovery,
            other => LastLaunchType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LastLaunchType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LastLaunchType::from(s))
    }
}
impl LastLaunchType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LastLaunchType::Drill => "DRILL",
            LastLaunchType::Recovery => "RECOVERY",
            LastLaunchType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DRILL", "RECOVERY"]
    }
}
impl AsRef<str> for LastLaunchType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about Data Replication</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataReplicationInfo {
    /// <p>Data replication lag duration.</p>
    pub lag_duration: std::option::Option<std::string::String>,
    /// <p>An estimate of when the data replication will be completed.</p>
    pub eta_date_time: std::option::Option<std::string::String>,
    /// <p>The disks that should be replicated.</p>
    pub replicated_disks:
        std::option::Option<std::vec::Vec<crate::model::DataReplicationInfoReplicatedDisk>>,
    /// <p>The state of the data replication.</p>
    pub data_replication_state: std::option::Option<crate::model::DataReplicationState>,
    /// <p>Information about whether the data replication has been initiated.</p>
    pub data_replication_initiation: std::option::Option<crate::model::DataReplicationInitiation>,
    /// <p>Error in data replication.</p>
    pub data_replication_error: std::option::Option<crate::model::DataReplicationError>,
}
impl DataReplicationInfo {
    /// <p>Data replication lag duration.</p>
    pub fn lag_duration(&self) -> std::option::Option<&str> {
        self.lag_duration.as_deref()
    }
    /// <p>An estimate of when the data replication will be completed.</p>
    pub fn eta_date_time(&self) -> std::option::Option<&str> {
        self.eta_date_time.as_deref()
    }
    /// <p>The disks that should be replicated.</p>
    pub fn replicated_disks(
        &self,
    ) -> std::option::Option<&[crate::model::DataReplicationInfoReplicatedDisk]> {
        self.replicated_disks.as_deref()
    }
    /// <p>The state of the data replication.</p>
    pub fn data_replication_state(
        &self,
    ) -> std::option::Option<&crate::model::DataReplicationState> {
        self.data_replication_state.as_ref()
    }
    /// <p>Information about whether the data replication has been initiated.</p>
    pub fn data_replication_initiation(
        &self,
    ) -> std::option::Option<&crate::model::DataReplicationInitiation> {
        self.data_replication_initiation.as_ref()
    }
    /// <p>Error in data replication.</p>
    pub fn data_replication_error(
        &self,
    ) -> std::option::Option<&crate::model::DataReplicationError> {
        self.data_replication_error.as_ref()
    }
}
impl std::fmt::Debug for DataReplicationInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataReplicationInfo");
        formatter.field("lag_duration", &self.lag_duration);
        formatter.field("eta_date_time", &self.eta_date_time);
        formatter.field("replicated_disks", &self.replicated_disks);
        formatter.field("data_replication_state", &self.data_replication_state);
        formatter.field(
            "data_replication_initiation",
            &self.data_replication_initiation,
        );
        formatter.field("data_replication_error", &self.data_replication_error);
        formatter.finish()
    }
}
/// See [`DataReplicationInfo`](crate::model::DataReplicationInfo)
pub mod data_replication_info {
    /// A builder for [`DataReplicationInfo`](crate::model::DataReplicationInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lag_duration: std::option::Option<std::string::String>,
        pub(crate) eta_date_time: std::option::Option<std::string::String>,
        pub(crate) replicated_disks:
            std::option::Option<std::vec::Vec<crate::model::DataReplicationInfoReplicatedDisk>>,
        pub(crate) data_replication_state: std::option::Option<crate::model::DataReplicationState>,
        pub(crate) data_replication_initiation:
            std::option::Option<crate::model::DataReplicationInitiation>,
        pub(crate) data_replication_error: std::option::Option<crate::model::DataReplicationError>,
    }
    impl Builder {
        /// <p>Data replication lag duration.</p>
        pub fn lag_duration(mut self, input: impl Into<std::string::String>) -> Self {
            self.lag_duration = Some(input.into());
            self
        }
        /// <p>Data replication lag duration.</p>
        pub fn set_lag_duration(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lag_duration = input;
            self
        }
        /// <p>An estimate of when the data replication will be completed.</p>
        pub fn eta_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.eta_date_time = Some(input.into());
            self
        }
        /// <p>An estimate of when the data replication will be completed.</p>
        pub fn set_eta_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.eta_date_time = input;
            self
        }
        /// Appends an item to `replicated_disks`.
        ///
        /// To override the contents of this collection use [`set_replicated_disks`](Self::set_replicated_disks).
        ///
        /// <p>The disks that should be replicated.</p>
        pub fn replicated_disks(
            mut self,
            input: crate::model::DataReplicationInfoReplicatedDisk,
        ) -> Self {
            let mut v = self.replicated_disks.unwrap_or_default();
            v.push(input);
            self.replicated_disks = Some(v);
            self
        }
        /// <p>The disks that should be replicated.</p>
        pub fn set_replicated_disks(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::DataReplicationInfoReplicatedDisk>,
            >,
        ) -> Self {
            self.replicated_disks = input;
            self
        }
        /// <p>The state of the data replication.</p>
        pub fn data_replication_state(mut self, input: crate::model::DataReplicationState) -> Self {
            self.data_replication_state = Some(input);
            self
        }
        /// <p>The state of the data replication.</p>
        pub fn set_data_replication_state(
            mut self,
            input: std::option::Option<crate::model::DataReplicationState>,
        ) -> Self {
            self.data_replication_state = input;
            self
        }
        /// <p>Information about whether the data replication has been initiated.</p>
        pub fn data_replication_initiation(
            mut self,
            input: crate::model::DataReplicationInitiation,
        ) -> Self {
            self.data_replication_initiation = Some(input);
            self
        }
        /// <p>Information about whether the data replication has been initiated.</p>
        pub fn set_data_replication_initiation(
            mut self,
            input: std::option::Option<crate::model::DataReplicationInitiation>,
        ) -> Self {
            self.data_replication_initiation = input;
            self
        }
        /// <p>Error in data replication.</p>
        pub fn data_replication_error(mut self, input: crate::model::DataReplicationError) -> Self {
            self.data_replication_error = Some(input);
            self
        }
        /// <p>Error in data replication.</p>
        pub fn set_data_replication_error(
            mut self,
            input: std::option::Option<crate::model::DataReplicationError>,
        ) -> Self {
            self.data_replication_error = input;
            self
        }
        /// Consumes the builder and constructs a [`DataReplicationInfo`](crate::model::DataReplicationInfo)
        pub fn build(self) -> crate::model::DataReplicationInfo {
            crate::model::DataReplicationInfo {
                lag_duration: self.lag_duration,
                eta_date_time: self.eta_date_time,
                replicated_disks: self.replicated_disks,
                data_replication_state: self.data_replication_state,
                data_replication_initiation: self.data_replication_initiation,
                data_replication_error: self.data_replication_error,
            }
        }
    }
}
impl DataReplicationInfo {
    /// Creates a new builder-style object to manufacture [`DataReplicationInfo`](crate::model::DataReplicationInfo)
    pub fn builder() -> crate::model::data_replication_info::Builder {
        crate::model::data_replication_info::Builder::default()
    }
}

/// <p>Error in data replication.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataReplicationError {
    /// <p>Error in data replication.</p>
    pub error: std::option::Option<crate::model::DataReplicationErrorString>,
    /// <p>Error in data replication.</p>
    pub raw_error: std::option::Option<std::string::String>,
}
impl DataReplicationError {
    /// <p>Error in data replication.</p>
    pub fn error(&self) -> std::option::Option<&crate::model::DataReplicationErrorString> {
        self.error.as_ref()
    }
    /// <p>Error in data replication.</p>
    pub fn raw_error(&self) -> std::option::Option<&str> {
        self.raw_error.as_deref()
    }
}
impl std::fmt::Debug for DataReplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataReplicationError");
        formatter.field("error", &self.error);
        formatter.field("raw_error", &self.raw_error);
        formatter.finish()
    }
}
/// See [`DataReplicationError`](crate::model::DataReplicationError)
pub mod data_replication_error {
    /// A builder for [`DataReplicationError`](crate::model::DataReplicationError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error: std::option::Option<crate::model::DataReplicationErrorString>,
        pub(crate) raw_error: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error in data replication.</p>
        pub fn error(mut self, input: crate::model::DataReplicationErrorString) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>Error in data replication.</p>
        pub fn set_error(
            mut self,
            input: std::option::Option<crate::model::DataReplicationErrorString>,
        ) -> Self {
            self.error = input;
            self
        }
        /// <p>Error in data replication.</p>
        pub fn raw_error(mut self, input: impl Into<std::string::String>) -> Self {
            self.raw_error = Some(input.into());
            self
        }
        /// <p>Error in data replication.</p>
        pub fn set_raw_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.raw_error = input;
            self
        }
        /// Consumes the builder and constructs a [`DataReplicationError`](crate::model::DataReplicationError)
        pub fn build(self) -> crate::model::DataReplicationError {
            crate::model::DataReplicationError {
                error: self.error,
                raw_error: self.raw_error,
            }
        }
    }
}
impl DataReplicationError {
    /// Creates a new builder-style object to manufacture [`DataReplicationError`](crate::model::DataReplicationError)
    pub fn builder() -> crate::model::data_replication_error::Builder {
        crate::model::data_replication_error::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataReplicationErrorString {
    #[allow(missing_docs)] // documentation missing in model
    AgentNotSeen,
    #[allow(missing_docs)] // documentation missing in model
    FailedToAttachStagingDisks,
    #[allow(missing_docs)] // documentation missing in model
    FailedToAuthenticateWithService,
    #[allow(missing_docs)] // documentation missing in model
    FailedToBootReplicationServer,
    #[allow(missing_docs)] // documentation missing in model
    FailedToConnectAgentToReplicationServer,
    #[allow(missing_docs)] // documentation missing in model
    FailedToCreateSecurityGroup,
    #[allow(missing_docs)] // documentation missing in model
    FailedToCreateStagingDisks,
    #[allow(missing_docs)] // documentation missing in model
    FailedToDownloadReplicationSoftware,
    #[allow(missing_docs)] // documentation missing in model
    FailedToLaunchReplicationServer,
    #[allow(missing_docs)] // documentation missing in model
    FailedToPairReplicationServerWithAgent,
    #[allow(missing_docs)] // documentation missing in model
    FailedToStartDataTransfer,
    #[allow(missing_docs)] // documentation missing in model
    NotConverging,
    #[allow(missing_docs)] // documentation missing in model
    SnapshotsFailure,
    #[allow(missing_docs)] // documentation missing in model
    UnstableNetwork,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataReplicationErrorString {
    fn from(s: &str) -> Self {
        match s {
            "AGENT_NOT_SEEN" => DataReplicationErrorString::AgentNotSeen,
            "FAILED_TO_ATTACH_STAGING_DISKS" => {
                DataReplicationErrorString::FailedToAttachStagingDisks
            }
            "FAILED_TO_AUTHENTICATE_WITH_SERVICE" => {
                DataReplicationErrorString::FailedToAuthenticateWithService
            }
            "FAILED_TO_BOOT_REPLICATION_SERVER" => {
                DataReplicationErrorString::FailedToBootReplicationServer
            }
            "FAILED_TO_CONNECT_AGENT_TO_REPLICATION_SERVER" => {
                DataReplicationErrorString::FailedToConnectAgentToReplicationServer
            }
            "FAILED_TO_CREATE_SECURITY_GROUP" => {
                DataReplicationErrorString::FailedToCreateSecurityGroup
            }
            "FAILED_TO_CREATE_STAGING_DISKS" => {
                DataReplicationErrorString::FailedToCreateStagingDisks
            }
            "FAILED_TO_DOWNLOAD_REPLICATION_SOFTWARE" => {
                DataReplicationErrorString::FailedToDownloadReplicationSoftware
            }
            "FAILED_TO_LAUNCH_REPLICATION_SERVER" => {
                DataReplicationErrorString::FailedToLaunchReplicationServer
            }
            "FAILED_TO_PAIR_REPLICATION_SERVER_WITH_AGENT" => {
                DataReplicationErrorString::FailedToPairReplicationServerWithAgent
            }
            "FAILED_TO_START_DATA_TRANSFER" => {
                DataReplicationErrorString::FailedToStartDataTransfer
            }
            "NOT_CONVERGING" => DataReplicationErrorString::NotConverging,
            "SNAPSHOTS_FAILURE" => DataReplicationErrorString::SnapshotsFailure,
            "UNSTABLE_NETWORK" => DataReplicationErrorString::UnstableNetwork,
            other => DataReplicationErrorString::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataReplicationErrorString {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataReplicationErrorString::from(s))
    }
}
impl DataReplicationErrorString {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataReplicationErrorString::AgentNotSeen => "AGENT_NOT_SEEN",
            DataReplicationErrorString::FailedToAttachStagingDisks => {
                "FAILED_TO_ATTACH_STAGING_DISKS"
            }
            DataReplicationErrorString::FailedToAuthenticateWithService => {
                "FAILED_TO_AUTHENTICATE_WITH_SERVICE"
            }
            DataReplicationErrorString::FailedToBootReplicationServer => {
                "FAILED_TO_BOOT_REPLICATION_SERVER"
            }
            DataReplicationErrorString::FailedToConnectAgentToReplicationServer => {
                "FAILED_TO_CONNECT_AGENT_TO_REPLICATION_SERVER"
            }
            DataReplicationErrorString::FailedToCreateSecurityGroup => {
                "FAILED_TO_CREATE_SECURITY_GROUP"
            }
            DataReplicationErrorString::FailedToCreateStagingDisks => {
                "FAILED_TO_CREATE_STAGING_DISKS"
            }
            DataReplicationErrorString::FailedToDownloadReplicationSoftware => {
                "FAILED_TO_DOWNLOAD_REPLICATION_SOFTWARE"
            }
            DataReplicationErrorString::FailedToLaunchReplicationServer => {
                "FAILED_TO_LAUNCH_REPLICATION_SERVER"
            }
            DataReplicationErrorString::FailedToPairReplicationServerWithAgent => {
                "FAILED_TO_PAIR_REPLICATION_SERVER_WITH_AGENT"
            }
            DataReplicationErrorString::FailedToStartDataTransfer => {
                "FAILED_TO_START_DATA_TRANSFER"
            }
            DataReplicationErrorString::NotConverging => "NOT_CONVERGING",
            DataReplicationErrorString::SnapshotsFailure => "SNAPSHOTS_FAILURE",
            DataReplicationErrorString::UnstableNetwork => "UNSTABLE_NETWORK",
            DataReplicationErrorString::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AGENT_NOT_SEEN",
            "FAILED_TO_ATTACH_STAGING_DISKS",
            "FAILED_TO_AUTHENTICATE_WITH_SERVICE",
            "FAILED_TO_BOOT_REPLICATION_SERVER",
            "FAILED_TO_CONNECT_AGENT_TO_REPLICATION_SERVER",
            "FAILED_TO_CREATE_SECURITY_GROUP",
            "FAILED_TO_CREATE_STAGING_DISKS",
            "FAILED_TO_DOWNLOAD_REPLICATION_SOFTWARE",
            "FAILED_TO_LAUNCH_REPLICATION_SERVER",
            "FAILED_TO_PAIR_REPLICATION_SERVER_WITH_AGENT",
            "FAILED_TO_START_DATA_TRANSFER",
            "NOT_CONVERGING",
            "SNAPSHOTS_FAILURE",
            "UNSTABLE_NETWORK",
        ]
    }
}
impl AsRef<str> for DataReplicationErrorString {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Data replication initiation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataReplicationInitiation {
    /// <p>The date and time of the current attempt to initiate data replication.</p>
    pub start_date_time: std::option::Option<std::string::String>,
    /// <p>The date and time of the next attempt to initiate data replication.</p>
    pub next_attempt_date_time: std::option::Option<std::string::String>,
    /// <p>The steps of the current attempt to initiate data replication.</p>
    pub steps: std::option::Option<std::vec::Vec<crate::model::DataReplicationInitiationStep>>,
}
impl DataReplicationInitiation {
    /// <p>The date and time of the current attempt to initiate data replication.</p>
    pub fn start_date_time(&self) -> std::option::Option<&str> {
        self.start_date_time.as_deref()
    }
    /// <p>The date and time of the next attempt to initiate data replication.</p>
    pub fn next_attempt_date_time(&self) -> std::option::Option<&str> {
        self.next_attempt_date_time.as_deref()
    }
    /// <p>The steps of the current attempt to initiate data replication.</p>
    pub fn steps(&self) -> std::option::Option<&[crate::model::DataReplicationInitiationStep]> {
        self.steps.as_deref()
    }
}
impl std::fmt::Debug for DataReplicationInitiation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataReplicationInitiation");
        formatter.field("start_date_time", &self.start_date_time);
        formatter.field("next_attempt_date_time", &self.next_attempt_date_time);
        formatter.field("steps", &self.steps);
        formatter.finish()
    }
}
/// See [`DataReplicationInitiation`](crate::model::DataReplicationInitiation)
pub mod data_replication_initiation {
    /// A builder for [`DataReplicationInitiation`](crate::model::DataReplicationInitiation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_date_time: std::option::Option<std::string::String>,
        pub(crate) next_attempt_date_time: std::option::Option<std::string::String>,
        pub(crate) steps:
            std::option::Option<std::vec::Vec<crate::model::DataReplicationInitiationStep>>,
    }
    impl Builder {
        /// <p>The date and time of the current attempt to initiate data replication.</p>
        pub fn start_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_date_time = Some(input.into());
            self
        }
        /// <p>The date and time of the current attempt to initiate data replication.</p>
        pub fn set_start_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.start_date_time = input;
            self
        }
        /// <p>The date and time of the next attempt to initiate data replication.</p>
        pub fn next_attempt_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_attempt_date_time = Some(input.into());
            self
        }
        /// <p>The date and time of the next attempt to initiate data replication.</p>
        pub fn set_next_attempt_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_attempt_date_time = input;
            self
        }
        /// Appends an item to `steps`.
        ///
        /// To override the contents of this collection use [`set_steps`](Self::set_steps).
        ///
        /// <p>The steps of the current attempt to initiate data replication.</p>
        pub fn steps(mut self, input: crate::model::DataReplicationInitiationStep) -> Self {
            let mut v = self.steps.unwrap_or_default();
            v.push(input);
            self.steps = Some(v);
            self
        }
        /// <p>The steps of the current attempt to initiate data replication.</p>
        pub fn set_steps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataReplicationInitiationStep>>,
        ) -> Self {
            self.steps = input;
            self
        }
        /// Consumes the builder and constructs a [`DataReplicationInitiation`](crate::model::DataReplicationInitiation)
        pub fn build(self) -> crate::model::DataReplicationInitiation {
            crate::model::DataReplicationInitiation {
                start_date_time: self.start_date_time,
                next_attempt_date_time: self.next_attempt_date_time,
                steps: self.steps,
            }
        }
    }
}
impl DataReplicationInitiation {
    /// Creates a new builder-style object to manufacture [`DataReplicationInitiation`](crate::model::DataReplicationInitiation)
    pub fn builder() -> crate::model::data_replication_initiation::Builder {
        crate::model::data_replication_initiation::Builder::default()
    }
}

/// <p>Data replication initiation step.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataReplicationInitiationStep {
    /// <p>The name of the step.</p>
    pub name: std::option::Option<crate::model::DataReplicationInitiationStepName>,
    /// <p>The status of the step.</p>
    pub status: std::option::Option<crate::model::DataReplicationInitiationStepStatus>,
}
impl DataReplicationInitiationStep {
    /// <p>The name of the step.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::DataReplicationInitiationStepName> {
        self.name.as_ref()
    }
    /// <p>The status of the step.</p>
    pub fn status(
        &self,
    ) -> std::option::Option<&crate::model::DataReplicationInitiationStepStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for DataReplicationInitiationStep {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataReplicationInitiationStep");
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DataReplicationInitiationStep`](crate::model::DataReplicationInitiationStep)
pub mod data_replication_initiation_step {
    /// A builder for [`DataReplicationInitiationStep`](crate::model::DataReplicationInitiationStep)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::DataReplicationInitiationStepName>,
        pub(crate) status: std::option::Option<crate::model::DataReplicationInitiationStepStatus>,
    }
    impl Builder {
        /// <p>The name of the step.</p>
        pub fn name(mut self, input: crate::model::DataReplicationInitiationStepName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the step.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::DataReplicationInitiationStepName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of the step.</p>
        pub fn status(mut self, input: crate::model::DataReplicationInitiationStepStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the step.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DataReplicationInitiationStepStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DataReplicationInitiationStep`](crate::model::DataReplicationInitiationStep)
        pub fn build(self) -> crate::model::DataReplicationInitiationStep {
            crate::model::DataReplicationInitiationStep {
                name: self.name,
                status: self.status,
            }
        }
    }
}
impl DataReplicationInitiationStep {
    /// Creates a new builder-style object to manufacture [`DataReplicationInitiationStep`](crate::model::DataReplicationInitiationStep)
    pub fn builder() -> crate::model::data_replication_initiation_step::Builder {
        crate::model::data_replication_initiation_step::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataReplicationInitiationStepStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    NotStarted,
    #[allow(missing_docs)] // documentation missing in model
    Skipped,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataReplicationInitiationStepStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => DataReplicationInitiationStepStatus::Failed,
            "IN_PROGRESS" => DataReplicationInitiationStepStatus::InProgress,
            "NOT_STARTED" => DataReplicationInitiationStepStatus::NotStarted,
            "SKIPPED" => DataReplicationInitiationStepStatus::Skipped,
            "SUCCEEDED" => DataReplicationInitiationStepStatus::Succeeded,
            other => DataReplicationInitiationStepStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataReplicationInitiationStepStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataReplicationInitiationStepStatus::from(s))
    }
}
impl DataReplicationInitiationStepStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataReplicationInitiationStepStatus::Failed => "FAILED",
            DataReplicationInitiationStepStatus::InProgress => "IN_PROGRESS",
            DataReplicationInitiationStepStatus::NotStarted => "NOT_STARTED",
            DataReplicationInitiationStepStatus::Skipped => "SKIPPED",
            DataReplicationInitiationStepStatus::Succeeded => "SUCCEEDED",
            DataReplicationInitiationStepStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "FAILED",
            "IN_PROGRESS",
            "NOT_STARTED",
            "SKIPPED",
            "SUCCEEDED",
        ]
    }
}
impl AsRef<str> for DataReplicationInitiationStepStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataReplicationInitiationStepName {
    #[allow(missing_docs)] // documentation missing in model
    AttachStagingDisks,
    #[allow(missing_docs)] // documentation missing in model
    AuthenticateWithService,
    #[allow(missing_docs)] // documentation missing in model
    BootReplicationServer,
    #[allow(missing_docs)] // documentation missing in model
    ConnectAgentToReplicationServer,
    #[allow(missing_docs)] // documentation missing in model
    CreateSecurityGroup,
    #[allow(missing_docs)] // documentation missing in model
    CreateStagingDisks,
    #[allow(missing_docs)] // documentation missing in model
    DownloadReplicationSoftware,
    #[allow(missing_docs)] // documentation missing in model
    LaunchReplicationServer,
    #[allow(missing_docs)] // documentation missing in model
    PairReplicationServerWithAgent,
    #[allow(missing_docs)] // documentation missing in model
    StartDataTransfer,
    #[allow(missing_docs)] // documentation missing in model
    Wait,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataReplicationInitiationStepName {
    fn from(s: &str) -> Self {
        match s {
            "ATTACH_STAGING_DISKS" => DataReplicationInitiationStepName::AttachStagingDisks,
            "AUTHENTICATE_WITH_SERVICE" => {
                DataReplicationInitiationStepName::AuthenticateWithService
            }
            "BOOT_REPLICATION_SERVER" => DataReplicationInitiationStepName::BootReplicationServer,
            "CONNECT_AGENT_TO_REPLICATION_SERVER" => {
                DataReplicationInitiationStepName::ConnectAgentToReplicationServer
            }
            "CREATE_SECURITY_GROUP" => DataReplicationInitiationStepName::CreateSecurityGroup,
            "CREATE_STAGING_DISKS" => DataReplicationInitiationStepName::CreateStagingDisks,
            "DOWNLOAD_REPLICATION_SOFTWARE" => {
                DataReplicationInitiationStepName::DownloadReplicationSoftware
            }
            "LAUNCH_REPLICATION_SERVER" => {
                DataReplicationInitiationStepName::LaunchReplicationServer
            }
            "PAIR_REPLICATION_SERVER_WITH_AGENT" => {
                DataReplicationInitiationStepName::PairReplicationServerWithAgent
            }
            "START_DATA_TRANSFER" => DataReplicationInitiationStepName::StartDataTransfer,
            "WAIT" => DataReplicationInitiationStepName::Wait,
            other => DataReplicationInitiationStepName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataReplicationInitiationStepName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataReplicationInitiationStepName::from(s))
    }
}
impl DataReplicationInitiationStepName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataReplicationInitiationStepName::AttachStagingDisks => "ATTACH_STAGING_DISKS",
            DataReplicationInitiationStepName::AuthenticateWithService => {
                "AUTHENTICATE_WITH_SERVICE"
            }
            DataReplicationInitiationStepName::BootReplicationServer => "BOOT_REPLICATION_SERVER",
            DataReplicationInitiationStepName::ConnectAgentToReplicationServer => {
                "CONNECT_AGENT_TO_REPLICATION_SERVER"
            }
            DataReplicationInitiationStepName::CreateSecurityGroup => "CREATE_SECURITY_GROUP",
            DataReplicationInitiationStepName::CreateStagingDisks => "CREATE_STAGING_DISKS",
            DataReplicationInitiationStepName::DownloadReplicationSoftware => {
                "DOWNLOAD_REPLICATION_SOFTWARE"
            }
            DataReplicationInitiationStepName::LaunchReplicationServer => {
                "LAUNCH_REPLICATION_SERVER"
            }
            DataReplicationInitiationStepName::PairReplicationServerWithAgent => {
                "PAIR_REPLICATION_SERVER_WITH_AGENT"
            }
            DataReplicationInitiationStepName::StartDataTransfer => "START_DATA_TRANSFER",
            DataReplicationInitiationStepName::Wait => "WAIT",
            DataReplicationInitiationStepName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ATTACH_STAGING_DISKS",
            "AUTHENTICATE_WITH_SERVICE",
            "BOOT_REPLICATION_SERVER",
            "CONNECT_AGENT_TO_REPLICATION_SERVER",
            "CREATE_SECURITY_GROUP",
            "CREATE_STAGING_DISKS",
            "DOWNLOAD_REPLICATION_SOFTWARE",
            "LAUNCH_REPLICATION_SERVER",
            "PAIR_REPLICATION_SERVER_WITH_AGENT",
            "START_DATA_TRANSFER",
            "WAIT",
        ]
    }
}
impl AsRef<str> for DataReplicationInitiationStepName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataReplicationState {
    #[allow(missing_docs)] // documentation missing in model
    Backlog,
    #[allow(missing_docs)] // documentation missing in model
    Continuous,
    #[allow(missing_docs)] // documentation missing in model
    CreatingSnapshot,
    #[allow(missing_docs)] // documentation missing in model
    Disconnected,
    #[allow(missing_docs)] // documentation missing in model
    InitialSync,
    #[allow(missing_docs)] // documentation missing in model
    Initiating,
    #[allow(missing_docs)] // documentation missing in model
    Paused,
    #[allow(missing_docs)] // documentation missing in model
    Rescan,
    #[allow(missing_docs)] // documentation missing in model
    Stalled,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataReplicationState {
    fn from(s: &str) -> Self {
        match s {
            "BACKLOG" => DataReplicationState::Backlog,
            "CONTINUOUS" => DataReplicationState::Continuous,
            "CREATING_SNAPSHOT" => DataReplicationState::CreatingSnapshot,
            "DISCONNECTED" => DataReplicationState::Disconnected,
            "INITIAL_SYNC" => DataReplicationState::InitialSync,
            "INITIATING" => DataReplicationState::Initiating,
            "PAUSED" => DataReplicationState::Paused,
            "RESCAN" => DataReplicationState::Rescan,
            "STALLED" => DataReplicationState::Stalled,
            "STOPPED" => DataReplicationState::Stopped,
            other => DataReplicationState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataReplicationState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataReplicationState::from(s))
    }
}
impl DataReplicationState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataReplicationState::Backlog => "BACKLOG",
            DataReplicationState::Continuous => "CONTINUOUS",
            DataReplicationState::CreatingSnapshot => "CREATING_SNAPSHOT",
            DataReplicationState::Disconnected => "DISCONNECTED",
            DataReplicationState::InitialSync => "INITIAL_SYNC",
            DataReplicationState::Initiating => "INITIATING",
            DataReplicationState::Paused => "PAUSED",
            DataReplicationState::Rescan => "RESCAN",
            DataReplicationState::Stalled => "STALLED",
            DataReplicationState::Stopped => "STOPPED",
            DataReplicationState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BACKLOG",
            "CONTINUOUS",
            "CREATING_SNAPSHOT",
            "DISCONNECTED",
            "INITIAL_SYNC",
            "INITIATING",
            "PAUSED",
            "RESCAN",
            "STALLED",
            "STOPPED",
        ]
    }
}
impl AsRef<str> for DataReplicationState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A disk that should be replicated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataReplicationInfoReplicatedDisk {
    /// <p>The name of the device.</p>
    pub device_name: std::option::Option<std::string::String>,
    /// <p>The total amount of data to be replicated in bytes.</p>
    pub total_storage_bytes: i64,
    /// <p>The amount of data replicated so far in bytes.</p>
    pub replicated_storage_bytes: i64,
    /// <p>The amount of data to be rescanned in bytes.</p>
    pub rescanned_storage_bytes: i64,
    /// <p>The size of the replication backlog in bytes.</p>
    pub backlogged_storage_bytes: i64,
}
impl DataReplicationInfoReplicatedDisk {
    /// <p>The name of the device.</p>
    pub fn device_name(&self) -> std::option::Option<&str> {
        self.device_name.as_deref()
    }
    /// <p>The total amount of data to be replicated in bytes.</p>
    pub fn total_storage_bytes(&self) -> i64 {
        self.total_storage_bytes
    }
    /// <p>The amount of data replicated so far in bytes.</p>
    pub fn replicated_storage_bytes(&self) -> i64 {
        self.replicated_storage_bytes
    }
    /// <p>The amount of data to be rescanned in bytes.</p>
    pub fn rescanned_storage_bytes(&self) -> i64 {
        self.rescanned_storage_bytes
    }
    /// <p>The size of the replication backlog in bytes.</p>
    pub fn backlogged_storage_bytes(&self) -> i64 {
        self.backlogged_storage_bytes
    }
}
impl std::fmt::Debug for DataReplicationInfoReplicatedDisk {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataReplicationInfoReplicatedDisk");
        formatter.field("device_name", &self.device_name);
        formatter.field("total_storage_bytes", &self.total_storage_bytes);
        formatter.field("replicated_storage_bytes", &self.replicated_storage_bytes);
        formatter.field("rescanned_storage_bytes", &self.rescanned_storage_bytes);
        formatter.field("backlogged_storage_bytes", &self.backlogged_storage_bytes);
        formatter.finish()
    }
}
/// See [`DataReplicationInfoReplicatedDisk`](crate::model::DataReplicationInfoReplicatedDisk)
pub mod data_replication_info_replicated_disk {
    /// A builder for [`DataReplicationInfoReplicatedDisk`](crate::model::DataReplicationInfoReplicatedDisk)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_name: std::option::Option<std::string::String>,
        pub(crate) total_storage_bytes: std::option::Option<i64>,
        pub(crate) replicated_storage_bytes: std::option::Option<i64>,
        pub(crate) rescanned_storage_bytes: std::option::Option<i64>,
        pub(crate) backlogged_storage_bytes: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name of the device.</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_name = Some(input.into());
            self
        }
        /// <p>The name of the device.</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_name = input;
            self
        }
        /// <p>The total amount of data to be replicated in bytes.</p>
        pub fn total_storage_bytes(mut self, input: i64) -> Self {
            self.total_storage_bytes = Some(input);
            self
        }
        /// <p>The total amount of data to be replicated in bytes.</p>
        pub fn set_total_storage_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.total_storage_bytes = input;
            self
        }
        /// <p>The amount of data replicated so far in bytes.</p>
        pub fn replicated_storage_bytes(mut self, input: i64) -> Self {
            self.replicated_storage_bytes = Some(input);
            self
        }
        /// <p>The amount of data replicated so far in bytes.</p>
        pub fn set_replicated_storage_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.replicated_storage_bytes = input;
            self
        }
        /// <p>The amount of data to be rescanned in bytes.</p>
        pub fn rescanned_storage_bytes(mut self, input: i64) -> Self {
            self.rescanned_storage_bytes = Some(input);
            self
        }
        /// <p>The amount of data to be rescanned in bytes.</p>
        pub fn set_rescanned_storage_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.rescanned_storage_bytes = input;
            self
        }
        /// <p>The size of the replication backlog in bytes.</p>
        pub fn backlogged_storage_bytes(mut self, input: i64) -> Self {
            self.backlogged_storage_bytes = Some(input);
            self
        }
        /// <p>The size of the replication backlog in bytes.</p>
        pub fn set_backlogged_storage_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.backlogged_storage_bytes = input;
            self
        }
        /// Consumes the builder and constructs a [`DataReplicationInfoReplicatedDisk`](crate::model::DataReplicationInfoReplicatedDisk)
        pub fn build(self) -> crate::model::DataReplicationInfoReplicatedDisk {
            crate::model::DataReplicationInfoReplicatedDisk {
                device_name: self.device_name,
                total_storage_bytes: self.total_storage_bytes.unwrap_or_default(),
                replicated_storage_bytes: self.replicated_storage_bytes.unwrap_or_default(),
                rescanned_storage_bytes: self.rescanned_storage_bytes.unwrap_or_default(),
                backlogged_storage_bytes: self.backlogged_storage_bytes.unwrap_or_default(),
            }
        }
    }
}
impl DataReplicationInfoReplicatedDisk {
    /// Creates a new builder-style object to manufacture [`DataReplicationInfoReplicatedDisk`](crate::model::DataReplicationInfoReplicatedDisk)
    pub fn builder() -> crate::model::data_replication_info_replicated_disk::Builder {
        crate::model::data_replication_info_replicated_disk::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LastLaunchResult {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    NotStarted,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LastLaunchResult {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => LastLaunchResult::Failed,
            "NOT_STARTED" => LastLaunchResult::NotStarted,
            "PENDING" => LastLaunchResult::Pending,
            "SUCCEEDED" => LastLaunchResult::Succeeded,
            other => LastLaunchResult::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LastLaunchResult {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LastLaunchResult::from(s))
    }
}
impl LastLaunchResult {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LastLaunchResult::Failed => "FAILED",
            LastLaunchResult::NotStarted => "NOT_STARTED",
            LastLaunchResult::Pending => "PENDING",
            LastLaunchResult::Succeeded => "SUCCEEDED",
            LastLaunchResult::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "NOT_STARTED", "PENDING", "SUCCEEDED"]
    }
}
impl AsRef<str> for LastLaunchResult {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A snapshot of a Source Server used during recovery.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecoverySnapshot {
    /// <p>The ID of the Recovery Snapshot.</p>
    pub snapshot_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Source Server that the snapshot was taken for.</p>
    pub source_server_id: std::option::Option<std::string::String>,
    /// <p>The timestamp of when we expect the snapshot to be taken.</p>
    pub expected_timestamp: std::option::Option<std::string::String>,
    /// <p>The actual timestamp that the snapshot was taken.</p>
    pub timestamp: std::option::Option<std::string::String>,
    /// <p>A list of EBS snapshots.</p>
    pub ebs_snapshots: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl RecoverySnapshot {
    /// <p>The ID of the Recovery Snapshot.</p>
    pub fn snapshot_id(&self) -> std::option::Option<&str> {
        self.snapshot_id.as_deref()
    }
    /// <p>The ID of the Source Server that the snapshot was taken for.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
    /// <p>The timestamp of when we expect the snapshot to be taken.</p>
    pub fn expected_timestamp(&self) -> std::option::Option<&str> {
        self.expected_timestamp.as_deref()
    }
    /// <p>The actual timestamp that the snapshot was taken.</p>
    pub fn timestamp(&self) -> std::option::Option<&str> {
        self.timestamp.as_deref()
    }
    /// <p>A list of EBS snapshots.</p>
    pub fn ebs_snapshots(&self) -> std::option::Option<&[std::string::String]> {
        self.ebs_snapshots.as_deref()
    }
}
impl std::fmt::Debug for RecoverySnapshot {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecoverySnapshot");
        formatter.field("snapshot_id", &self.snapshot_id);
        formatter.field("source_server_id", &self.source_server_id);
        formatter.field("expected_timestamp", &self.expected_timestamp);
        formatter.field("timestamp", &self.timestamp);
        formatter.field("ebs_snapshots", &self.ebs_snapshots);
        formatter.finish()
    }
}
/// See [`RecoverySnapshot`](crate::model::RecoverySnapshot)
pub mod recovery_snapshot {
    /// A builder for [`RecoverySnapshot`](crate::model::RecoverySnapshot)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
        pub(crate) source_server_id: std::option::Option<std::string::String>,
        pub(crate) expected_timestamp: std::option::Option<std::string::String>,
        pub(crate) timestamp: std::option::Option<std::string::String>,
        pub(crate) ebs_snapshots: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ID of the Recovery Snapshot.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The ID of the Recovery Snapshot.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// <p>The ID of the Source Server that the snapshot was taken for.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>The ID of the Source Server that the snapshot was taken for.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// <p>The timestamp of when we expect the snapshot to be taken.</p>
        pub fn expected_timestamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_timestamp = Some(input.into());
            self
        }
        /// <p>The timestamp of when we expect the snapshot to be taken.</p>
        pub fn set_expected_timestamp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_timestamp = input;
            self
        }
        /// <p>The actual timestamp that the snapshot was taken.</p>
        pub fn timestamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.timestamp = Some(input.into());
            self
        }
        /// <p>The actual timestamp that the snapshot was taken.</p>
        pub fn set_timestamp(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timestamp = input;
            self
        }
        /// Appends an item to `ebs_snapshots`.
        ///
        /// To override the contents of this collection use [`set_ebs_snapshots`](Self::set_ebs_snapshots).
        ///
        /// <p>A list of EBS snapshots.</p>
        pub fn ebs_snapshots(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ebs_snapshots.unwrap_or_default();
            v.push(input.into());
            self.ebs_snapshots = Some(v);
            self
        }
        /// <p>A list of EBS snapshots.</p>
        pub fn set_ebs_snapshots(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ebs_snapshots = input;
            self
        }
        /// Consumes the builder and constructs a [`RecoverySnapshot`](crate::model::RecoverySnapshot)
        pub fn build(self) -> crate::model::RecoverySnapshot {
            crate::model::RecoverySnapshot {
                snapshot_id: self.snapshot_id,
                source_server_id: self.source_server_id,
                expected_timestamp: self.expected_timestamp,
                timestamp: self.timestamp,
                ebs_snapshots: self.ebs_snapshots,
            }
        }
    }
}
impl RecoverySnapshot {
    /// Creates a new builder-style object to manufacture [`RecoverySnapshot`](crate::model::RecoverySnapshot)
    pub fn builder() -> crate::model::recovery_snapshot::Builder {
        crate::model::recovery_snapshot::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RecoverySnapshotsOrder {
    #[allow(missing_docs)] // documentation missing in model
    Asc,
    #[allow(missing_docs)] // documentation missing in model
    Desc,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RecoverySnapshotsOrder {
    fn from(s: &str) -> Self {
        match s {
            "ASC" => RecoverySnapshotsOrder::Asc,
            "DESC" => RecoverySnapshotsOrder::Desc,
            other => RecoverySnapshotsOrder::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RecoverySnapshotsOrder {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RecoverySnapshotsOrder::from(s))
    }
}
impl RecoverySnapshotsOrder {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RecoverySnapshotsOrder::Asc => "ASC",
            RecoverySnapshotsOrder::Desc => "DESC",
            RecoverySnapshotsOrder::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASC", "DESC"]
    }
}
impl AsRef<str> for RecoverySnapshotsOrder {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A set of filters by which to return Recovery Snapshots.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRecoverySnapshotsRequestFilters {
    /// <p>The start date in a date range query.</p>
    pub from_date_time: std::option::Option<std::string::String>,
    /// <p>The end date in a date range query.</p>
    pub to_date_time: std::option::Option<std::string::String>,
}
impl DescribeRecoverySnapshotsRequestFilters {
    /// <p>The start date in a date range query.</p>
    pub fn from_date_time(&self) -> std::option::Option<&str> {
        self.from_date_time.as_deref()
    }
    /// <p>The end date in a date range query.</p>
    pub fn to_date_time(&self) -> std::option::Option<&str> {
        self.to_date_time.as_deref()
    }
}
impl std::fmt::Debug for DescribeRecoverySnapshotsRequestFilters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRecoverySnapshotsRequestFilters");
        formatter.field("from_date_time", &self.from_date_time);
        formatter.field("to_date_time", &self.to_date_time);
        formatter.finish()
    }
}
/// See [`DescribeRecoverySnapshotsRequestFilters`](crate::model::DescribeRecoverySnapshotsRequestFilters)
pub mod describe_recovery_snapshots_request_filters {
    /// A builder for [`DescribeRecoverySnapshotsRequestFilters`](crate::model::DescribeRecoverySnapshotsRequestFilters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from_date_time: std::option::Option<std::string::String>,
        pub(crate) to_date_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The start date in a date range query.</p>
        pub fn from_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_date_time = Some(input.into());
            self
        }
        /// <p>The start date in a date range query.</p>
        pub fn set_from_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_date_time = input;
            self
        }
        /// <p>The end date in a date range query.</p>
        pub fn to_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.to_date_time = Some(input.into());
            self
        }
        /// <p>The end date in a date range query.</p>
        pub fn set_to_date_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.to_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRecoverySnapshotsRequestFilters`](crate::model::DescribeRecoverySnapshotsRequestFilters)
        pub fn build(self) -> crate::model::DescribeRecoverySnapshotsRequestFilters {
            crate::model::DescribeRecoverySnapshotsRequestFilters {
                from_date_time: self.from_date_time,
                to_date_time: self.to_date_time,
            }
        }
    }
}
impl DescribeRecoverySnapshotsRequestFilters {
    /// Creates a new builder-style object to manufacture [`DescribeRecoverySnapshotsRequestFilters`](crate::model::DescribeRecoverySnapshotsRequestFilters)
    pub fn builder() -> crate::model::describe_recovery_snapshots_request_filters::Builder {
        crate::model::describe_recovery_snapshots_request_filters::Builder::default()
    }
}

/// <p>A job is an asynchronous workflow.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Job {
    /// <p>The ID of the Job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The ARN of a Job.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The type of the Job.</p>
    pub r#type: std::option::Option<crate::model::JobType>,
    /// <p>A string representing who initiated the Job.</p>
    pub initiated_by: std::option::Option<crate::model::InitiatedBy>,
    /// <p>The date and time of when the Job was created.</p>
    pub creation_date_time: std::option::Option<std::string::String>,
    /// <p>The date and time of when the Job ended.</p>
    pub end_date_time: std::option::Option<std::string::String>,
    /// <p>The status of the Job.</p>
    pub status: std::option::Option<crate::model::JobStatus>,
    /// <p>A list of servers that the Job is acting upon.</p>
    pub participating_servers:
        std::option::Option<std::vec::Vec<crate::model::ParticipatingServer>>,
    /// <p>A list of tags associated with the Job.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl Job {
    /// <p>The ID of the Job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The ARN of a Job.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The type of the Job.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::JobType> {
        self.r#type.as_ref()
    }
    /// <p>A string representing who initiated the Job.</p>
    pub fn initiated_by(&self) -> std::option::Option<&crate::model::InitiatedBy> {
        self.initiated_by.as_ref()
    }
    /// <p>The date and time of when the Job was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&str> {
        self.creation_date_time.as_deref()
    }
    /// <p>The date and time of when the Job ended.</p>
    pub fn end_date_time(&self) -> std::option::Option<&str> {
        self.end_date_time.as_deref()
    }
    /// <p>The status of the Job.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.status.as_ref()
    }
    /// <p>A list of servers that the Job is acting upon.</p>
    pub fn participating_servers(
        &self,
    ) -> std::option::Option<&[crate::model::ParticipatingServer]> {
        self.participating_servers.as_deref()
    }
    /// <p>A list of tags associated with the Job.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for Job {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Job");
        formatter.field("job_id", &self.job_id);
        formatter.field("arn", &self.arn);
        formatter.field("r#type", &self.r#type);
        formatter.field("initiated_by", &self.initiated_by);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("end_date_time", &self.end_date_time);
        formatter.field("status", &self.status);
        formatter.field("participating_servers", &self.participating_servers);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`Job`](crate::model::Job)
pub mod job {
    /// A builder for [`Job`](crate::model::Job)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::JobType>,
        pub(crate) initiated_by: std::option::Option<crate::model::InitiatedBy>,
        pub(crate) creation_date_time: std::option::Option<std::string::String>,
        pub(crate) end_date_time: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::JobStatus>,
        pub(crate) participating_servers:
            std::option::Option<std::vec::Vec<crate::model::ParticipatingServer>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the Job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID of the Job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The ARN of a Job.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of a Job.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The type of the Job.</p>
        pub fn r#type(mut self, input: crate::model::JobType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the Job.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::JobType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>A string representing who initiated the Job.</p>
        pub fn initiated_by(mut self, input: crate::model::InitiatedBy) -> Self {
            self.initiated_by = Some(input);
            self
        }
        /// <p>A string representing who initiated the Job.</p>
        pub fn set_initiated_by(
            mut self,
            input: std::option::Option<crate::model::InitiatedBy>,
        ) -> Self {
            self.initiated_by = input;
            self
        }
        /// <p>The date and time of when the Job was created.</p>
        pub fn creation_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_date_time = Some(input.into());
            self
        }
        /// <p>The date and time of when the Job was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time of when the Job ended.</p>
        pub fn end_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.end_date_time = Some(input.into());
            self
        }
        /// <p>The date and time of when the Job ended.</p>
        pub fn set_end_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.end_date_time = input;
            self
        }
        /// <p>The status of the Job.</p>
        pub fn status(mut self, input: crate::model::JobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the Job.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::JobStatus>) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `participating_servers`.
        ///
        /// To override the contents of this collection use [`set_participating_servers`](Self::set_participating_servers).
        ///
        /// <p>A list of servers that the Job is acting upon.</p>
        pub fn participating_servers(mut self, input: crate::model::ParticipatingServer) -> Self {
            let mut v = self.participating_servers.unwrap_or_default();
            v.push(input);
            self.participating_servers = Some(v);
            self
        }
        /// <p>A list of servers that the Job is acting upon.</p>
        pub fn set_participating_servers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParticipatingServer>>,
        ) -> Self {
            self.participating_servers = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags associated with the Job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of tags associated with the Job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Job`](crate::model::Job)
        pub fn build(self) -> crate::model::Job {
            crate::model::Job {
                job_id: self.job_id,
                arn: self.arn,
                r#type: self.r#type,
                initiated_by: self.initiated_by,
                creation_date_time: self.creation_date_time,
                end_date_time: self.end_date_time,
                status: self.status,
                participating_servers: self.participating_servers,
                tags: self.tags,
            }
        }
    }
}
impl Job {
    /// Creates a new builder-style object to manufacture [`Job`](crate::model::Job)
    pub fn builder() -> crate::model::job::Builder {
        crate::model::job::Builder::default()
    }
}

/// <p>Represents a server participating in an asynchronous Job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParticipatingServer {
    /// <p>The Source Server ID of a participating server.</p>
    pub source_server_id: std::option::Option<std::string::String>,
    /// <p>The Recovery Instance ID of a participating server.</p>
    pub recovery_instance_id: std::option::Option<std::string::String>,
    /// <p>The launch status of a participating server.</p>
    pub launch_status: std::option::Option<crate::model::LaunchStatus>,
}
impl ParticipatingServer {
    /// <p>The Source Server ID of a participating server.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
    /// <p>The Recovery Instance ID of a participating server.</p>
    pub fn recovery_instance_id(&self) -> std::option::Option<&str> {
        self.recovery_instance_id.as_deref()
    }
    /// <p>The launch status of a participating server.</p>
    pub fn launch_status(&self) -> std::option::Option<&crate::model::LaunchStatus> {
        self.launch_status.as_ref()
    }
}
impl std::fmt::Debug for ParticipatingServer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParticipatingServer");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.field("recovery_instance_id", &self.recovery_instance_id);
        formatter.field("launch_status", &self.launch_status);
        formatter.finish()
    }
}
/// See [`ParticipatingServer`](crate::model::ParticipatingServer)
pub mod participating_server {
    /// A builder for [`ParticipatingServer`](crate::model::ParticipatingServer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
        pub(crate) recovery_instance_id: std::option::Option<std::string::String>,
        pub(crate) launch_status: std::option::Option<crate::model::LaunchStatus>,
    }
    impl Builder {
        /// <p>The Source Server ID of a participating server.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>The Source Server ID of a participating server.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// <p>The Recovery Instance ID of a participating server.</p>
        pub fn recovery_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_instance_id = Some(input.into());
            self
        }
        /// <p>The Recovery Instance ID of a participating server.</p>
        pub fn set_recovery_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_instance_id = input;
            self
        }
        /// <p>The launch status of a participating server.</p>
        pub fn launch_status(mut self, input: crate::model::LaunchStatus) -> Self {
            self.launch_status = Some(input);
            self
        }
        /// <p>The launch status of a participating server.</p>
        pub fn set_launch_status(
            mut self,
            input: std::option::Option<crate::model::LaunchStatus>,
        ) -> Self {
            self.launch_status = input;
            self
        }
        /// Consumes the builder and constructs a [`ParticipatingServer`](crate::model::ParticipatingServer)
        pub fn build(self) -> crate::model::ParticipatingServer {
            crate::model::ParticipatingServer {
                source_server_id: self.source_server_id,
                recovery_instance_id: self.recovery_instance_id,
                launch_status: self.launch_status,
            }
        }
    }
}
impl ParticipatingServer {
    /// Creates a new builder-style object to manufacture [`ParticipatingServer`](crate::model::ParticipatingServer)
    pub fn builder() -> crate::model::participating_server::Builder {
        crate::model::participating_server::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LaunchStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Launched,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Terminated,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LaunchStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => LaunchStatus::Failed,
            "IN_PROGRESS" => LaunchStatus::InProgress,
            "LAUNCHED" => LaunchStatus::Launched,
            "PENDING" => LaunchStatus::Pending,
            "TERMINATED" => LaunchStatus::Terminated,
            other => LaunchStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LaunchStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LaunchStatus::from(s))
    }
}
impl LaunchStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LaunchStatus::Failed => "FAILED",
            LaunchStatus::InProgress => "IN_PROGRESS",
            LaunchStatus::Launched => "LAUNCHED",
            LaunchStatus::Pending => "PENDING",
            LaunchStatus::Terminated => "TERMINATED",
            LaunchStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "IN_PROGRESS", "LAUNCHED", "PENDING", "TERMINATED"]
    }
}
impl AsRef<str> for LaunchStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Started,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => JobStatus::Completed,
            "PENDING" => JobStatus::Pending,
            "STARTED" => JobStatus::Started,
            other => JobStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobStatus::from(s))
    }
}
impl JobStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobStatus::Completed => "COMPLETED",
            JobStatus::Pending => "PENDING",
            JobStatus::Started => "STARTED",
            JobStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETED", "PENDING", "STARTED"]
    }
}
impl AsRef<str> for JobStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InitiatedBy {
    #[allow(missing_docs)] // documentation missing in model
    Diagnostic,
    #[allow(missing_docs)] // documentation missing in model
    Failback,
    #[allow(missing_docs)] // documentation missing in model
    StartDrill,
    #[allow(missing_docs)] // documentation missing in model
    StartRecovery,
    #[allow(missing_docs)] // documentation missing in model
    TerminateRecoveryInstances,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InitiatedBy {
    fn from(s: &str) -> Self {
        match s {
            "DIAGNOSTIC" => InitiatedBy::Diagnostic,
            "FAILBACK" => InitiatedBy::Failback,
            "START_DRILL" => InitiatedBy::StartDrill,
            "START_RECOVERY" => InitiatedBy::StartRecovery,
            "TERMINATE_RECOVERY_INSTANCES" => InitiatedBy::TerminateRecoveryInstances,
            other => InitiatedBy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InitiatedBy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InitiatedBy::from(s))
    }
}
impl InitiatedBy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InitiatedBy::Diagnostic => "DIAGNOSTIC",
            InitiatedBy::Failback => "FAILBACK",
            InitiatedBy::StartDrill => "START_DRILL",
            InitiatedBy::StartRecovery => "START_RECOVERY",
            InitiatedBy::TerminateRecoveryInstances => "TERMINATE_RECOVERY_INSTANCES",
            InitiatedBy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DIAGNOSTIC",
            "FAILBACK",
            "START_DRILL",
            "START_RECOVERY",
            "TERMINATE_RECOVERY_INSTANCES",
        ]
    }
}
impl AsRef<str> for InitiatedBy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobType {
    #[allow(missing_docs)] // documentation missing in model
    Launch,
    #[allow(missing_docs)] // documentation missing in model
    Terminate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobType {
    fn from(s: &str) -> Self {
        match s {
            "LAUNCH" => JobType::Launch,
            "TERMINATE" => JobType::Terminate,
            other => JobType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobType::from(s))
    }
}
impl JobType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobType::Launch => "LAUNCH",
            JobType::Terminate => "TERMINATE",
            JobType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LAUNCH", "TERMINATE"]
    }
}
impl AsRef<str> for JobType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object representing the Source Server to recover.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartRecoveryRequestSourceServer {
    /// <p>The ID of the Source Server you want to recover.</p>
    pub source_server_id: std::option::Option<std::string::String>,
    /// <p>The ID of a Recovery Snapshot we want to recover from. Omit this field to launch from the latest data by taking an on-demand snapshot.</p>
    pub recovery_snapshot_id: std::option::Option<std::string::String>,
}
impl StartRecoveryRequestSourceServer {
    /// <p>The ID of the Source Server you want to recover.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
    /// <p>The ID of a Recovery Snapshot we want to recover from. Omit this field to launch from the latest data by taking an on-demand snapshot.</p>
    pub fn recovery_snapshot_id(&self) -> std::option::Option<&str> {
        self.recovery_snapshot_id.as_deref()
    }
}
impl std::fmt::Debug for StartRecoveryRequestSourceServer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartRecoveryRequestSourceServer");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.field("recovery_snapshot_id", &self.recovery_snapshot_id);
        formatter.finish()
    }
}
/// See [`StartRecoveryRequestSourceServer`](crate::model::StartRecoveryRequestSourceServer)
pub mod start_recovery_request_source_server {
    /// A builder for [`StartRecoveryRequestSourceServer`](crate::model::StartRecoveryRequestSourceServer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
        pub(crate) recovery_snapshot_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Source Server you want to recover.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>The ID of the Source Server you want to recover.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// <p>The ID of a Recovery Snapshot we want to recover from. Omit this field to launch from the latest data by taking an on-demand snapshot.</p>
        pub fn recovery_snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_snapshot_id = Some(input.into());
            self
        }
        /// <p>The ID of a Recovery Snapshot we want to recover from. Omit this field to launch from the latest data by taking an on-demand snapshot.</p>
        pub fn set_recovery_snapshot_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_snapshot_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartRecoveryRequestSourceServer`](crate::model::StartRecoveryRequestSourceServer)
        pub fn build(self) -> crate::model::StartRecoveryRequestSourceServer {
            crate::model::StartRecoveryRequestSourceServer {
                source_server_id: self.source_server_id,
                recovery_snapshot_id: self.recovery_snapshot_id,
            }
        }
    }
}
impl StartRecoveryRequestSourceServer {
    /// Creates a new builder-style object to manufacture [`StartRecoveryRequestSourceServer`](crate::model::StartRecoveryRequestSourceServer)
    pub fn builder() -> crate::model::start_recovery_request_source_server::Builder {
        crate::model::start_recovery_request_source_server::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceServer {
    /// <p>The ID of the Source Server.</p>
    pub source_server_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the Source Server.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The tags associated with the Source Server.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The ID of the Recovery Instance associated with this Source Server.</p>
    pub recovery_instance_id: std::option::Option<std::string::String>,
    /// <p>The status of the last recovery launch of this Source Server.</p>
    pub last_launch_result: std::option::Option<crate::model::LastLaunchResult>,
    /// <p>The Data Replication Info of the Source Server.</p>
    pub data_replication_info: std::option::Option<crate::model::DataReplicationInfo>,
    /// <p>The lifecycle information of this Source Server.</p>
    pub life_cycle: std::option::Option<crate::model::LifeCycle>,
    /// <p>The source properties of the Source Server.</p>
    pub source_properties: std::option::Option<crate::model::SourceProperties>,
}
impl SourceServer {
    /// <p>The ID of the Source Server.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
    /// <p>The ARN of the Source Server.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The tags associated with the Source Server.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The ID of the Recovery Instance associated with this Source Server.</p>
    pub fn recovery_instance_id(&self) -> std::option::Option<&str> {
        self.recovery_instance_id.as_deref()
    }
    /// <p>The status of the last recovery launch of this Source Server.</p>
    pub fn last_launch_result(&self) -> std::option::Option<&crate::model::LastLaunchResult> {
        self.last_launch_result.as_ref()
    }
    /// <p>The Data Replication Info of the Source Server.</p>
    pub fn data_replication_info(&self) -> std::option::Option<&crate::model::DataReplicationInfo> {
        self.data_replication_info.as_ref()
    }
    /// <p>The lifecycle information of this Source Server.</p>
    pub fn life_cycle(&self) -> std::option::Option<&crate::model::LifeCycle> {
        self.life_cycle.as_ref()
    }
    /// <p>The source properties of the Source Server.</p>
    pub fn source_properties(&self) -> std::option::Option<&crate::model::SourceProperties> {
        self.source_properties.as_ref()
    }
}
impl std::fmt::Debug for SourceServer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceServer");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.field("arn", &self.arn);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("recovery_instance_id", &self.recovery_instance_id);
        formatter.field("last_launch_result", &self.last_launch_result);
        formatter.field("data_replication_info", &self.data_replication_info);
        formatter.field("life_cycle", &self.life_cycle);
        formatter.field("source_properties", &self.source_properties);
        formatter.finish()
    }
}
/// See [`SourceServer`](crate::model::SourceServer)
pub mod source_server {
    /// A builder for [`SourceServer`](crate::model::SourceServer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) recovery_instance_id: std::option::Option<std::string::String>,
        pub(crate) last_launch_result: std::option::Option<crate::model::LastLaunchResult>,
        pub(crate) data_replication_info: std::option::Option<crate::model::DataReplicationInfo>,
        pub(crate) life_cycle: std::option::Option<crate::model::LifeCycle>,
        pub(crate) source_properties: std::option::Option<crate::model::SourceProperties>,
    }
    impl Builder {
        /// <p>The ID of the Source Server.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>The ID of the Source Server.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// <p>The ARN of the Source Server.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Source Server.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the Source Server.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags associated with the Source Server.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The ID of the Recovery Instance associated with this Source Server.</p>
        pub fn recovery_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the Recovery Instance associated with this Source Server.</p>
        pub fn set_recovery_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_instance_id = input;
            self
        }
        /// <p>The status of the last recovery launch of this Source Server.</p>
        pub fn last_launch_result(mut self, input: crate::model::LastLaunchResult) -> Self {
            self.last_launch_result = Some(input);
            self
        }
        /// <p>The status of the last recovery launch of this Source Server.</p>
        pub fn set_last_launch_result(
            mut self,
            input: std::option::Option<crate::model::LastLaunchResult>,
        ) -> Self {
            self.last_launch_result = input;
            self
        }
        /// <p>The Data Replication Info of the Source Server.</p>
        pub fn data_replication_info(mut self, input: crate::model::DataReplicationInfo) -> Self {
            self.data_replication_info = Some(input);
            self
        }
        /// <p>The Data Replication Info of the Source Server.</p>
        pub fn set_data_replication_info(
            mut self,
            input: std::option::Option<crate::model::DataReplicationInfo>,
        ) -> Self {
            self.data_replication_info = input;
            self
        }
        /// <p>The lifecycle information of this Source Server.</p>
        pub fn life_cycle(mut self, input: crate::model::LifeCycle) -> Self {
            self.life_cycle = Some(input);
            self
        }
        /// <p>The lifecycle information of this Source Server.</p>
        pub fn set_life_cycle(
            mut self,
            input: std::option::Option<crate::model::LifeCycle>,
        ) -> Self {
            self.life_cycle = input;
            self
        }
        /// <p>The source properties of the Source Server.</p>
        pub fn source_properties(mut self, input: crate::model::SourceProperties) -> Self {
            self.source_properties = Some(input);
            self
        }
        /// <p>The source properties of the Source Server.</p>
        pub fn set_source_properties(
            mut self,
            input: std::option::Option<crate::model::SourceProperties>,
        ) -> Self {
            self.source_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceServer`](crate::model::SourceServer)
        pub fn build(self) -> crate::model::SourceServer {
            crate::model::SourceServer {
                source_server_id: self.source_server_id,
                arn: self.arn,
                tags: self.tags,
                recovery_instance_id: self.recovery_instance_id,
                last_launch_result: self.last_launch_result,
                data_replication_info: self.data_replication_info,
                life_cycle: self.life_cycle,
                source_properties: self.source_properties,
            }
        }
    }
}
impl SourceServer {
    /// Creates a new builder-style object to manufacture [`SourceServer`](crate::model::SourceServer)
    pub fn builder() -> crate::model::source_server::Builder {
        crate::model::source_server::Builder::default()
    }
}

/// <p>A set of filters by which to return Source Servers.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSourceServersRequestFilters {
    /// <p>An array of Source Servers IDs that should be returned. An empty array means all Source Servers.</p>
    pub source_server_i_ds: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An ID that describes the hardware of the Source Server. This is either an EC2 instance id, a VMware uuid or a mac address.</p>
    pub hardware_id: std::option::Option<std::string::String>,
}
impl DescribeSourceServersRequestFilters {
    /// <p>An array of Source Servers IDs that should be returned. An empty array means all Source Servers.</p>
    pub fn source_server_i_ds(&self) -> std::option::Option<&[std::string::String]> {
        self.source_server_i_ds.as_deref()
    }
    /// <p>An ID that describes the hardware of the Source Server. This is either an EC2 instance id, a VMware uuid or a mac address.</p>
    pub fn hardware_id(&self) -> std::option::Option<&str> {
        self.hardware_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeSourceServersRequestFilters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSourceServersRequestFilters");
        formatter.field("source_server_i_ds", &self.source_server_i_ds);
        formatter.field("hardware_id", &self.hardware_id);
        formatter.finish()
    }
}
/// See [`DescribeSourceServersRequestFilters`](crate::model::DescribeSourceServersRequestFilters)
pub mod describe_source_servers_request_filters {
    /// A builder for [`DescribeSourceServersRequestFilters`](crate::model::DescribeSourceServersRequestFilters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_i_ds: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) hardware_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `source_server_i_ds`.
        ///
        /// To override the contents of this collection use [`set_source_server_i_ds`](Self::set_source_server_i_ds).
        ///
        /// <p>An array of Source Servers IDs that should be returned. An empty array means all Source Servers.</p>
        pub fn source_server_i_ds(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.source_server_i_ds.unwrap_or_default();
            v.push(input.into());
            self.source_server_i_ds = Some(v);
            self
        }
        /// <p>An array of Source Servers IDs that should be returned. An empty array means all Source Servers.</p>
        pub fn set_source_server_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.source_server_i_ds = input;
            self
        }
        /// <p>An ID that describes the hardware of the Source Server. This is either an EC2 instance id, a VMware uuid or a mac address.</p>
        pub fn hardware_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hardware_id = Some(input.into());
            self
        }
        /// <p>An ID that describes the hardware of the Source Server. This is either an EC2 instance id, a VMware uuid or a mac address.</p>
        pub fn set_hardware_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hardware_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSourceServersRequestFilters`](crate::model::DescribeSourceServersRequestFilters)
        pub fn build(self) -> crate::model::DescribeSourceServersRequestFilters {
            crate::model::DescribeSourceServersRequestFilters {
                source_server_i_ds: self.source_server_i_ds,
                hardware_id: self.hardware_id,
            }
        }
    }
}
impl DescribeSourceServersRequestFilters {
    /// Creates a new builder-style object to manufacture [`DescribeSourceServersRequestFilters`](crate::model::DescribeSourceServersRequestFilters)
    pub fn builder() -> crate::model::describe_source_servers_request_filters::Builder {
        crate::model::describe_source_servers_request_filters::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationConfigurationTemplate {
    /// <p>The Replication Configuration Template ID.</p>
    pub replication_configuration_template_id: std::option::Option<std::string::String>,
    /// <p>The Replication Configuration Template ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The subnet to be used by the replication staging area.</p>
    pub staging_area_subnet_id: std::option::Option<std::string::String>,
    /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>
    pub associate_default_security_group: std::option::Option<bool>,
    /// <p>The security group IDs that will be used by the replication server.</p>
    pub replication_servers_security_groups_i_ds:
        std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The instance type to be used for the replication server.</p>
    pub replication_server_instance_type: std::option::Option<std::string::String>,
    /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
    pub use_dedicated_replication_server: std::option::Option<bool>,
    /// <p>The Staging Disk EBS volume type to be used during replication.</p>
    pub default_large_staging_disk_type:
        std::option::Option<crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>,
    /// <p>The type of EBS encryption to be used during replication.</p>
    pub ebs_encryption: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
    /// <p>The ARN of the EBS encryption key to be used during replication.</p>
    pub ebs_encryption_key_arn: std::option::Option<std::string::String>,
    /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
    pub bandwidth_throttling: i64,
    /// <p>The data plane routing mechanism that will be used for replication.</p>
    pub data_plane_routing:
        std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
    /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
    pub create_public_ip: std::option::Option<bool>,
    /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
    pub staging_area_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A set of tags to be associated with the Replication Configuration Template resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
    pub pit_policy: std::option::Option<std::vec::Vec<crate::model::PitPolicyRule>>,
}
impl ReplicationConfigurationTemplate {
    /// <p>The Replication Configuration Template ID.</p>
    pub fn replication_configuration_template_id(&self) -> std::option::Option<&str> {
        self.replication_configuration_template_id.as_deref()
    }
    /// <p>The Replication Configuration Template ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The subnet to be used by the replication staging area.</p>
    pub fn staging_area_subnet_id(&self) -> std::option::Option<&str> {
        self.staging_area_subnet_id.as_deref()
    }
    /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>
    pub fn associate_default_security_group(&self) -> std::option::Option<bool> {
        self.associate_default_security_group
    }
    /// <p>The security group IDs that will be used by the replication server.</p>
    pub fn replication_servers_security_groups_i_ds(
        &self,
    ) -> std::option::Option<&[std::string::String]> {
        self.replication_servers_security_groups_i_ds.as_deref()
    }
    /// <p>The instance type to be used for the replication server.</p>
    pub fn replication_server_instance_type(&self) -> std::option::Option<&str> {
        self.replication_server_instance_type.as_deref()
    }
    /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
    pub fn use_dedicated_replication_server(&self) -> std::option::Option<bool> {
        self.use_dedicated_replication_server
    }
    /// <p>The Staging Disk EBS volume type to be used during replication.</p>
    pub fn default_large_staging_disk_type(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>
    {
        self.default_large_staging_disk_type.as_ref()
    }
    /// <p>The type of EBS encryption to be used during replication.</p>
    pub fn ebs_encryption(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationEbsEncryption> {
        self.ebs_encryption.as_ref()
    }
    /// <p>The ARN of the EBS encryption key to be used during replication.</p>
    pub fn ebs_encryption_key_arn(&self) -> std::option::Option<&str> {
        self.ebs_encryption_key_arn.as_deref()
    }
    /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
    pub fn bandwidth_throttling(&self) -> i64 {
        self.bandwidth_throttling
    }
    /// <p>The data plane routing mechanism that will be used for replication.</p>
    pub fn data_plane_routing(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationDataPlaneRouting> {
        self.data_plane_routing.as_ref()
    }
    /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
    pub fn create_public_ip(&self) -> std::option::Option<bool> {
        self.create_public_ip
    }
    /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
    pub fn staging_area_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.staging_area_tags.as_ref()
    }
    /// <p>A set of tags to be associated with the Replication Configuration Template resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
    pub fn pit_policy(&self) -> std::option::Option<&[crate::model::PitPolicyRule]> {
        self.pit_policy.as_deref()
    }
}
impl std::fmt::Debug for ReplicationConfigurationTemplate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationConfigurationTemplate");
        formatter.field(
            "replication_configuration_template_id",
            &self.replication_configuration_template_id,
        );
        formatter.field("arn", &self.arn);
        formatter.field("staging_area_subnet_id", &self.staging_area_subnet_id);
        formatter.field(
            "associate_default_security_group",
            &self.associate_default_security_group,
        );
        formatter.field(
            "replication_servers_security_groups_i_ds",
            &self.replication_servers_security_groups_i_ds,
        );
        formatter.field(
            "replication_server_instance_type",
            &self.replication_server_instance_type,
        );
        formatter.field(
            "use_dedicated_replication_server",
            &self.use_dedicated_replication_server,
        );
        formatter.field(
            "default_large_staging_disk_type",
            &self.default_large_staging_disk_type,
        );
        formatter.field("ebs_encryption", &self.ebs_encryption);
        formatter.field("ebs_encryption_key_arn", &self.ebs_encryption_key_arn);
        formatter.field("bandwidth_throttling", &self.bandwidth_throttling);
        formatter.field("data_plane_routing", &self.data_plane_routing);
        formatter.field("create_public_ip", &self.create_public_ip);
        formatter.field("staging_area_tags", &"*** Sensitive Data Redacted ***");
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("pit_policy", &self.pit_policy);
        formatter.finish()
    }
}
/// See [`ReplicationConfigurationTemplate`](crate::model::ReplicationConfigurationTemplate)
pub mod replication_configuration_template {
    /// A builder for [`ReplicationConfigurationTemplate`](crate::model::ReplicationConfigurationTemplate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_configuration_template_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) staging_area_subnet_id: std::option::Option<std::string::String>,
        pub(crate) associate_default_security_group: std::option::Option<bool>,
        pub(crate) replication_servers_security_groups_i_ds:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) replication_server_instance_type: std::option::Option<std::string::String>,
        pub(crate) use_dedicated_replication_server: std::option::Option<bool>,
        pub(crate) default_large_staging_disk_type:
            std::option::Option<crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>,
        pub(crate) ebs_encryption:
            std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        pub(crate) ebs_encryption_key_arn: std::option::Option<std::string::String>,
        pub(crate) bandwidth_throttling: std::option::Option<i64>,
        pub(crate) data_plane_routing:
            std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        pub(crate) create_public_ip: std::option::Option<bool>,
        pub(crate) staging_area_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) pit_policy: std::option::Option<std::vec::Vec<crate::model::PitPolicyRule>>,
    }
    impl Builder {
        /// <p>The Replication Configuration Template ID.</p>
        pub fn replication_configuration_template_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_configuration_template_id = Some(input.into());
            self
        }
        /// <p>The Replication Configuration Template ID.</p>
        pub fn set_replication_configuration_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_configuration_template_id = input;
            self
        }
        /// <p>The Replication Configuration Template ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Replication Configuration Template ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The subnet to be used by the replication staging area.</p>
        pub fn staging_area_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.staging_area_subnet_id = Some(input.into());
            self
        }
        /// <p>The subnet to be used by the replication staging area.</p>
        pub fn set_staging_area_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.staging_area_subnet_id = input;
            self
        }
        /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>
        pub fn associate_default_security_group(mut self, input: bool) -> Self {
            self.associate_default_security_group = Some(input);
            self
        }
        /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>
        pub fn set_associate_default_security_group(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.associate_default_security_group = input;
            self
        }
        /// Appends an item to `replication_servers_security_groups_i_ds`.
        ///
        /// To override the contents of this collection use [`set_replication_servers_security_groups_i_ds`](Self::set_replication_servers_security_groups_i_ds).
        ///
        /// <p>The security group IDs that will be used by the replication server.</p>
        pub fn replication_servers_security_groups_i_ds(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self
                .replication_servers_security_groups_i_ds
                .unwrap_or_default();
            v.push(input.into());
            self.replication_servers_security_groups_i_ds = Some(v);
            self
        }
        /// <p>The security group IDs that will be used by the replication server.</p>
        pub fn set_replication_servers_security_groups_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.replication_servers_security_groups_i_ds = input;
            self
        }
        /// <p>The instance type to be used for the replication server.</p>
        pub fn replication_server_instance_type(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_server_instance_type = Some(input.into());
            self
        }
        /// <p>The instance type to be used for the replication server.</p>
        pub fn set_replication_server_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_server_instance_type = input;
            self
        }
        /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
        pub fn use_dedicated_replication_server(mut self, input: bool) -> Self {
            self.use_dedicated_replication_server = Some(input);
            self
        }
        /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
        pub fn set_use_dedicated_replication_server(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.use_dedicated_replication_server = input;
            self
        }
        /// <p>The Staging Disk EBS volume type to be used during replication.</p>
        pub fn default_large_staging_disk_type(
            mut self,
            input: crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
        ) -> Self {
            self.default_large_staging_disk_type = Some(input);
            self
        }
        /// <p>The Staging Disk EBS volume type to be used during replication.</p>
        pub fn set_default_large_staging_disk_type(
            mut self,
            input: std::option::Option<
                crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
            >,
        ) -> Self {
            self.default_large_staging_disk_type = input;
            self
        }
        /// <p>The type of EBS encryption to be used during replication.</p>
        pub fn ebs_encryption(
            mut self,
            input: crate::model::ReplicationConfigurationEbsEncryption,
        ) -> Self {
            self.ebs_encryption = Some(input);
            self
        }
        /// <p>The type of EBS encryption to be used during replication.</p>
        pub fn set_ebs_encryption(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        ) -> Self {
            self.ebs_encryption = input;
            self
        }
        /// <p>The ARN of the EBS encryption key to be used during replication.</p>
        pub fn ebs_encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ebs_encryption_key_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the EBS encryption key to be used during replication.</p>
        pub fn set_ebs_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ebs_encryption_key_arn = input;
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
        pub fn bandwidth_throttling(mut self, input: i64) -> Self {
            self.bandwidth_throttling = Some(input);
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
        pub fn set_bandwidth_throttling(mut self, input: std::option::Option<i64>) -> Self {
            self.bandwidth_throttling = input;
            self
        }
        /// <p>The data plane routing mechanism that will be used for replication.</p>
        pub fn data_plane_routing(
            mut self,
            input: crate::model::ReplicationConfigurationDataPlaneRouting,
        ) -> Self {
            self.data_plane_routing = Some(input);
            self
        }
        /// <p>The data plane routing mechanism that will be used for replication.</p>
        pub fn set_data_plane_routing(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        ) -> Self {
            self.data_plane_routing = input;
            self
        }
        /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
        pub fn create_public_ip(mut self, input: bool) -> Self {
            self.create_public_ip = Some(input);
            self
        }
        /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
        pub fn set_create_public_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.create_public_ip = input;
            self
        }
        /// Adds a key-value pair to `staging_area_tags`.
        ///
        /// To override the contents of this collection use [`set_staging_area_tags`](Self::set_staging_area_tags).
        ///
        /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
        pub fn staging_area_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.staging_area_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.staging_area_tags = Some(hash_map);
            self
        }
        /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
        pub fn set_staging_area_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.staging_area_tags = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A set of tags to be associated with the Replication Configuration Template resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A set of tags to be associated with the Replication Configuration Template resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `pit_policy`.
        ///
        /// To override the contents of this collection use [`set_pit_policy`](Self::set_pit_policy).
        ///
        /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
        pub fn pit_policy(mut self, input: crate::model::PitPolicyRule) -> Self {
            let mut v = self.pit_policy.unwrap_or_default();
            v.push(input);
            self.pit_policy = Some(v);
            self
        }
        /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
        pub fn set_pit_policy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PitPolicyRule>>,
        ) -> Self {
            self.pit_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationConfigurationTemplate`](crate::model::ReplicationConfigurationTemplate)
        pub fn build(self) -> crate::model::ReplicationConfigurationTemplate {
            crate::model::ReplicationConfigurationTemplate {
                replication_configuration_template_id: self.replication_configuration_template_id,
                arn: self.arn,
                staging_area_subnet_id: self.staging_area_subnet_id,
                associate_default_security_group: self.associate_default_security_group,
                replication_servers_security_groups_i_ds: self
                    .replication_servers_security_groups_i_ds,
                replication_server_instance_type: self.replication_server_instance_type,
                use_dedicated_replication_server: self.use_dedicated_replication_server,
                default_large_staging_disk_type: self.default_large_staging_disk_type,
                ebs_encryption: self.ebs_encryption,
                ebs_encryption_key_arn: self.ebs_encryption_key_arn,
                bandwidth_throttling: self.bandwidth_throttling.unwrap_or_default(),
                data_plane_routing: self.data_plane_routing,
                create_public_ip: self.create_public_ip,
                staging_area_tags: self.staging_area_tags,
                tags: self.tags,
                pit_policy: self.pit_policy,
            }
        }
    }
}
impl ReplicationConfigurationTemplate {
    /// Creates a new builder-style object to manufacture [`ReplicationConfigurationTemplate`](crate::model::ReplicationConfigurationTemplate)
    pub fn builder() -> crate::model::replication_configuration_template::Builder {
        crate::model::replication_configuration_template::Builder::default()
    }
}

/// <p>A Recovery Instance is a replica of a Source Server running on EC2.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecoveryInstance {
    /// <p>The EC2 instance ID of the Recovery Instance.</p>
    pub ec2_instance_id: std::option::Option<std::string::String>,
    /// <p>The state of the EC2 instance for this Recovery Instance.</p>
    pub ec2_instance_state: std::option::Option<crate::model::Ec2InstanceState>,
    /// <p>The ID of the Job that created the Recovery Instance.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Recovery Instance.</p>
    pub recovery_instance_id: std::option::Option<std::string::String>,
    /// <p>The Source Server ID that this Recovery Instance is associated with.</p>
    pub source_server_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the Recovery Instance.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>An array of tags that are associated with the Recovery Instance.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>An object representing failback related information of the Recovery Instance.</p>
    pub failback: std::option::Option<crate::model::RecoveryInstanceFailback>,
    /// <p>The Data Replication Info of the Recovery Instance.</p>
    pub data_replication_info:
        std::option::Option<crate::model::RecoveryInstanceDataReplicationInfo>,
    /// <p>Properties of the Recovery Instance machine.</p>
    pub recovery_instance_properties: std::option::Option<crate::model::RecoveryInstanceProperties>,
    /// <p>The date and time of the Point in Time (PIT) snapshot that this Recovery Instance was launched from.</p>
    pub point_in_time_snapshot_date_time: std::option::Option<std::string::String>,
    /// <p>Whether this Recovery Instance was created for a drill or for an actual Recovery event.</p>
    pub is_drill: std::option::Option<bool>,
}
impl RecoveryInstance {
    /// <p>The EC2 instance ID of the Recovery Instance.</p>
    pub fn ec2_instance_id(&self) -> std::option::Option<&str> {
        self.ec2_instance_id.as_deref()
    }
    /// <p>The state of the EC2 instance for this Recovery Instance.</p>
    pub fn ec2_instance_state(&self) -> std::option::Option<&crate::model::Ec2InstanceState> {
        self.ec2_instance_state.as_ref()
    }
    /// <p>The ID of the Job that created the Recovery Instance.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The ID of the Recovery Instance.</p>
    pub fn recovery_instance_id(&self) -> std::option::Option<&str> {
        self.recovery_instance_id.as_deref()
    }
    /// <p>The Source Server ID that this Recovery Instance is associated with.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
    /// <p>The ARN of the Recovery Instance.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>An array of tags that are associated with the Recovery Instance.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>An object representing failback related information of the Recovery Instance.</p>
    pub fn failback(&self) -> std::option::Option<&crate::model::RecoveryInstanceFailback> {
        self.failback.as_ref()
    }
    /// <p>The Data Replication Info of the Recovery Instance.</p>
    pub fn data_replication_info(
        &self,
    ) -> std::option::Option<&crate::model::RecoveryInstanceDataReplicationInfo> {
        self.data_replication_info.as_ref()
    }
    /// <p>Properties of the Recovery Instance machine.</p>
    pub fn recovery_instance_properties(
        &self,
    ) -> std::option::Option<&crate::model::RecoveryInstanceProperties> {
        self.recovery_instance_properties.as_ref()
    }
    /// <p>The date and time of the Point in Time (PIT) snapshot that this Recovery Instance was launched from.</p>
    pub fn point_in_time_snapshot_date_time(&self) -> std::option::Option<&str> {
        self.point_in_time_snapshot_date_time.as_deref()
    }
    /// <p>Whether this Recovery Instance was created for a drill or for an actual Recovery event.</p>
    pub fn is_drill(&self) -> std::option::Option<bool> {
        self.is_drill
    }
}
impl std::fmt::Debug for RecoveryInstance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecoveryInstance");
        formatter.field("ec2_instance_id", &self.ec2_instance_id);
        formatter.field("ec2_instance_state", &self.ec2_instance_state);
        formatter.field("job_id", &self.job_id);
        formatter.field("recovery_instance_id", &self.recovery_instance_id);
        formatter.field("source_server_id", &self.source_server_id);
        formatter.field("arn", &self.arn);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("failback", &self.failback);
        formatter.field("data_replication_info", &self.data_replication_info);
        formatter.field(
            "recovery_instance_properties",
            &self.recovery_instance_properties,
        );
        formatter.field(
            "point_in_time_snapshot_date_time",
            &self.point_in_time_snapshot_date_time,
        );
        formatter.field("is_drill", &self.is_drill);
        formatter.finish()
    }
}
/// See [`RecoveryInstance`](crate::model::RecoveryInstance)
pub mod recovery_instance {
    /// A builder for [`RecoveryInstance`](crate::model::RecoveryInstance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ec2_instance_id: std::option::Option<std::string::String>,
        pub(crate) ec2_instance_state: std::option::Option<crate::model::Ec2InstanceState>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) recovery_instance_id: std::option::Option<std::string::String>,
        pub(crate) source_server_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) failback: std::option::Option<crate::model::RecoveryInstanceFailback>,
        pub(crate) data_replication_info:
            std::option::Option<crate::model::RecoveryInstanceDataReplicationInfo>,
        pub(crate) recovery_instance_properties:
            std::option::Option<crate::model::RecoveryInstanceProperties>,
        pub(crate) point_in_time_snapshot_date_time: std::option::Option<std::string::String>,
        pub(crate) is_drill: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The EC2 instance ID of the Recovery Instance.</p>
        pub fn ec2_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_instance_id = Some(input.into());
            self
        }
        /// <p>The EC2 instance ID of the Recovery Instance.</p>
        pub fn set_ec2_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_instance_id = input;
            self
        }
        /// <p>The state of the EC2 instance for this Recovery Instance.</p>
        pub fn ec2_instance_state(mut self, input: crate::model::Ec2InstanceState) -> Self {
            self.ec2_instance_state = Some(input);
            self
        }
        /// <p>The state of the EC2 instance for this Recovery Instance.</p>
        pub fn set_ec2_instance_state(
            mut self,
            input: std::option::Option<crate::model::Ec2InstanceState>,
        ) -> Self {
            self.ec2_instance_state = input;
            self
        }
        /// <p>The ID of the Job that created the Recovery Instance.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID of the Job that created the Recovery Instance.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The ID of the Recovery Instance.</p>
        pub fn recovery_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the Recovery Instance.</p>
        pub fn set_recovery_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_instance_id = input;
            self
        }
        /// <p>The Source Server ID that this Recovery Instance is associated with.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>The Source Server ID that this Recovery Instance is associated with.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// <p>The ARN of the Recovery Instance.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Recovery Instance.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of tags that are associated with the Recovery Instance.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>An array of tags that are associated with the Recovery Instance.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>An object representing failback related information of the Recovery Instance.</p>
        pub fn failback(mut self, input: crate::model::RecoveryInstanceFailback) -> Self {
            self.failback = Some(input);
            self
        }
        /// <p>An object representing failback related information of the Recovery Instance.</p>
        pub fn set_failback(
            mut self,
            input: std::option::Option<crate::model::RecoveryInstanceFailback>,
        ) -> Self {
            self.failback = input;
            self
        }
        /// <p>The Data Replication Info of the Recovery Instance.</p>
        pub fn data_replication_info(
            mut self,
            input: crate::model::RecoveryInstanceDataReplicationInfo,
        ) -> Self {
            self.data_replication_info = Some(input);
            self
        }
        /// <p>The Data Replication Info of the Recovery Instance.</p>
        pub fn set_data_replication_info(
            mut self,
            input: std::option::Option<crate::model::RecoveryInstanceDataReplicationInfo>,
        ) -> Self {
            self.data_replication_info = input;
            self
        }
        /// <p>Properties of the Recovery Instance machine.</p>
        pub fn recovery_instance_properties(
            mut self,
            input: crate::model::RecoveryInstanceProperties,
        ) -> Self {
            self.recovery_instance_properties = Some(input);
            self
        }
        /// <p>Properties of the Recovery Instance machine.</p>
        pub fn set_recovery_instance_properties(
            mut self,
            input: std::option::Option<crate::model::RecoveryInstanceProperties>,
        ) -> Self {
            self.recovery_instance_properties = input;
            self
        }
        /// <p>The date and time of the Point in Time (PIT) snapshot that this Recovery Instance was launched from.</p>
        pub fn point_in_time_snapshot_date_time(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.point_in_time_snapshot_date_time = Some(input.into());
            self
        }
        /// <p>The date and time of the Point in Time (PIT) snapshot that this Recovery Instance was launched from.</p>
        pub fn set_point_in_time_snapshot_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.point_in_time_snapshot_date_time = input;
            self
        }
        /// <p>Whether this Recovery Instance was created for a drill or for an actual Recovery event.</p>
        pub fn is_drill(mut self, input: bool) -> Self {
            self.is_drill = Some(input);
            self
        }
        /// <p>Whether this Recovery Instance was created for a drill or for an actual Recovery event.</p>
        pub fn set_is_drill(mut self, input: std::option::Option<bool>) -> Self {
            self.is_drill = input;
            self
        }
        /// Consumes the builder and constructs a [`RecoveryInstance`](crate::model::RecoveryInstance)
        pub fn build(self) -> crate::model::RecoveryInstance {
            crate::model::RecoveryInstance {
                ec2_instance_id: self.ec2_instance_id,
                ec2_instance_state: self.ec2_instance_state,
                job_id: self.job_id,
                recovery_instance_id: self.recovery_instance_id,
                source_server_id: self.source_server_id,
                arn: self.arn,
                tags: self.tags,
                failback: self.failback,
                data_replication_info: self.data_replication_info,
                recovery_instance_properties: self.recovery_instance_properties,
                point_in_time_snapshot_date_time: self.point_in_time_snapshot_date_time,
                is_drill: self.is_drill,
            }
        }
    }
}
impl RecoveryInstance {
    /// Creates a new builder-style object to manufacture [`RecoveryInstance`](crate::model::RecoveryInstance)
    pub fn builder() -> crate::model::recovery_instance::Builder {
        crate::model::recovery_instance::Builder::default()
    }
}

/// <p>Properties of the Recovery Instance machine.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecoveryInstanceProperties {
    /// <p>The date and time the Recovery Instance properties were last updated on.</p>
    pub last_updated_date_time: std::option::Option<std::string::String>,
    /// <p>Hints used to uniquely identify a machine.</p>
    pub identification_hints: std::option::Option<crate::model::IdentificationHints>,
    /// <p>An array of network interfaces.</p>
    pub network_interfaces: std::option::Option<std::vec::Vec<crate::model::NetworkInterface>>,
    /// <p>An array of disks.</p>
    pub disks: std::option::Option<std::vec::Vec<crate::model::RecoveryInstanceDisk>>,
    /// <p>An array of CPUs.</p>
    pub cpus: std::option::Option<std::vec::Vec<crate::model::Cpu>>,
    /// <p>The amount of RAM in bytes.</p>
    pub ram_bytes: i64,
    /// <p>Operating system.</p>
    pub os: std::option::Option<crate::model::Os>,
}
impl RecoveryInstanceProperties {
    /// <p>The date and time the Recovery Instance properties were last updated on.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&str> {
        self.last_updated_date_time.as_deref()
    }
    /// <p>Hints used to uniquely identify a machine.</p>
    pub fn identification_hints(&self) -> std::option::Option<&crate::model::IdentificationHints> {
        self.identification_hints.as_ref()
    }
    /// <p>An array of network interfaces.</p>
    pub fn network_interfaces(&self) -> std::option::Option<&[crate::model::NetworkInterface]> {
        self.network_interfaces.as_deref()
    }
    /// <p>An array of disks.</p>
    pub fn disks(&self) -> std::option::Option<&[crate::model::RecoveryInstanceDisk]> {
        self.disks.as_deref()
    }
    /// <p>An array of CPUs.</p>
    pub fn cpus(&self) -> std::option::Option<&[crate::model::Cpu]> {
        self.cpus.as_deref()
    }
    /// <p>The amount of RAM in bytes.</p>
    pub fn ram_bytes(&self) -> i64 {
        self.ram_bytes
    }
    /// <p>Operating system.</p>
    pub fn os(&self) -> std::option::Option<&crate::model::Os> {
        self.os.as_ref()
    }
}
impl std::fmt::Debug for RecoveryInstanceProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecoveryInstanceProperties");
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field("identification_hints", &self.identification_hints);
        formatter.field("network_interfaces", &self.network_interfaces);
        formatter.field("disks", &self.disks);
        formatter.field("cpus", &self.cpus);
        formatter.field("ram_bytes", &self.ram_bytes);
        formatter.field("os", &self.os);
        formatter.finish()
    }
}
/// See [`RecoveryInstanceProperties`](crate::model::RecoveryInstanceProperties)
pub mod recovery_instance_properties {
    /// A builder for [`RecoveryInstanceProperties`](crate::model::RecoveryInstanceProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) last_updated_date_time: std::option::Option<std::string::String>,
        pub(crate) identification_hints: std::option::Option<crate::model::IdentificationHints>,
        pub(crate) network_interfaces:
            std::option::Option<std::vec::Vec<crate::model::NetworkInterface>>,
        pub(crate) disks: std::option::Option<std::vec::Vec<crate::model::RecoveryInstanceDisk>>,
        pub(crate) cpus: std::option::Option<std::vec::Vec<crate::model::Cpu>>,
        pub(crate) ram_bytes: std::option::Option<i64>,
        pub(crate) os: std::option::Option<crate::model::Os>,
    }
    impl Builder {
        /// <p>The date and time the Recovery Instance properties were last updated on.</p>
        pub fn last_updated_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_updated_date_time = Some(input.into());
            self
        }
        /// <p>The date and time the Recovery Instance properties were last updated on.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// <p>Hints used to uniquely identify a machine.</p>
        pub fn identification_hints(mut self, input: crate::model::IdentificationHints) -> Self {
            self.identification_hints = Some(input);
            self
        }
        /// <p>Hints used to uniquely identify a machine.</p>
        pub fn set_identification_hints(
            mut self,
            input: std::option::Option<crate::model::IdentificationHints>,
        ) -> Self {
            self.identification_hints = input;
            self
        }
        /// Appends an item to `network_interfaces`.
        ///
        /// To override the contents of this collection use [`set_network_interfaces`](Self::set_network_interfaces).
        ///
        /// <p>An array of network interfaces.</p>
        pub fn network_interfaces(mut self, input: crate::model::NetworkInterface) -> Self {
            let mut v = self.network_interfaces.unwrap_or_default();
            v.push(input);
            self.network_interfaces = Some(v);
            self
        }
        /// <p>An array of network interfaces.</p>
        pub fn set_network_interfaces(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NetworkInterface>>,
        ) -> Self {
            self.network_interfaces = input;
            self
        }
        /// Appends an item to `disks`.
        ///
        /// To override the contents of this collection use [`set_disks`](Self::set_disks).
        ///
        /// <p>An array of disks.</p>
        pub fn disks(mut self, input: crate::model::RecoveryInstanceDisk) -> Self {
            let mut v = self.disks.unwrap_or_default();
            v.push(input);
            self.disks = Some(v);
            self
        }
        /// <p>An array of disks.</p>
        pub fn set_disks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecoveryInstanceDisk>>,
        ) -> Self {
            self.disks = input;
            self
        }
        /// Appends an item to `cpus`.
        ///
        /// To override the contents of this collection use [`set_cpus`](Self::set_cpus).
        ///
        /// <p>An array of CPUs.</p>
        pub fn cpus(mut self, input: crate::model::Cpu) -> Self {
            let mut v = self.cpus.unwrap_or_default();
            v.push(input);
            self.cpus = Some(v);
            self
        }
        /// <p>An array of CPUs.</p>
        pub fn set_cpus(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Cpu>>,
        ) -> Self {
            self.cpus = input;
            self
        }
        /// <p>The amount of RAM in bytes.</p>
        pub fn ram_bytes(mut self, input: i64) -> Self {
            self.ram_bytes = Some(input);
            self
        }
        /// <p>The amount of RAM in bytes.</p>
        pub fn set_ram_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.ram_bytes = input;
            self
        }
        /// <p>Operating system.</p>
        pub fn os(mut self, input: crate::model::Os) -> Self {
            self.os = Some(input);
            self
        }
        /// <p>Operating system.</p>
        pub fn set_os(mut self, input: std::option::Option<crate::model::Os>) -> Self {
            self.os = input;
            self
        }
        /// Consumes the builder and constructs a [`RecoveryInstanceProperties`](crate::model::RecoveryInstanceProperties)
        pub fn build(self) -> crate::model::RecoveryInstanceProperties {
            crate::model::RecoveryInstanceProperties {
                last_updated_date_time: self.last_updated_date_time,
                identification_hints: self.identification_hints,
                network_interfaces: self.network_interfaces,
                disks: self.disks,
                cpus: self.cpus,
                ram_bytes: self.ram_bytes.unwrap_or_default(),
                os: self.os,
            }
        }
    }
}
impl RecoveryInstanceProperties {
    /// Creates a new builder-style object to manufacture [`RecoveryInstanceProperties`](crate::model::RecoveryInstanceProperties)
    pub fn builder() -> crate::model::recovery_instance_properties::Builder {
        crate::model::recovery_instance_properties::Builder::default()
    }
}

/// <p>An object representing a block storage device on the Recovery Instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecoveryInstanceDisk {
    /// <p>The internal device name of this disk. This is the name that is visible on the machine itself and not from the EC2 console.</p>
    pub internal_device_name: std::option::Option<std::string::String>,
    /// <p>The amount of storage on the disk in bytes.</p>
    pub bytes: i64,
    /// <p>The EBS Volume ID of this disk.</p>
    pub ebs_volume_id: std::option::Option<std::string::String>,
}
impl RecoveryInstanceDisk {
    /// <p>The internal device name of this disk. This is the name that is visible on the machine itself and not from the EC2 console.</p>
    pub fn internal_device_name(&self) -> std::option::Option<&str> {
        self.internal_device_name.as_deref()
    }
    /// <p>The amount of storage on the disk in bytes.</p>
    pub fn bytes(&self) -> i64 {
        self.bytes
    }
    /// <p>The EBS Volume ID of this disk.</p>
    pub fn ebs_volume_id(&self) -> std::option::Option<&str> {
        self.ebs_volume_id.as_deref()
    }
}
impl std::fmt::Debug for RecoveryInstanceDisk {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecoveryInstanceDisk");
        formatter.field("internal_device_name", &self.internal_device_name);
        formatter.field("bytes", &self.bytes);
        formatter.field("ebs_volume_id", &self.ebs_volume_id);
        formatter.finish()
    }
}
/// See [`RecoveryInstanceDisk`](crate::model::RecoveryInstanceDisk)
pub mod recovery_instance_disk {
    /// A builder for [`RecoveryInstanceDisk`](crate::model::RecoveryInstanceDisk)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) internal_device_name: std::option::Option<std::string::String>,
        pub(crate) bytes: std::option::Option<i64>,
        pub(crate) ebs_volume_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The internal device name of this disk. This is the name that is visible on the machine itself and not from the EC2 console.</p>
        pub fn internal_device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.internal_device_name = Some(input.into());
            self
        }
        /// <p>The internal device name of this disk. This is the name that is visible on the machine itself and not from the EC2 console.</p>
        pub fn set_internal_device_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.internal_device_name = input;
            self
        }
        /// <p>The amount of storage on the disk in bytes.</p>
        pub fn bytes(mut self, input: i64) -> Self {
            self.bytes = Some(input);
            self
        }
        /// <p>The amount of storage on the disk in bytes.</p>
        pub fn set_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.bytes = input;
            self
        }
        /// <p>The EBS Volume ID of this disk.</p>
        pub fn ebs_volume_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ebs_volume_id = Some(input.into());
            self
        }
        /// <p>The EBS Volume ID of this disk.</p>
        pub fn set_ebs_volume_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ebs_volume_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RecoveryInstanceDisk`](crate::model::RecoveryInstanceDisk)
        pub fn build(self) -> crate::model::RecoveryInstanceDisk {
            crate::model::RecoveryInstanceDisk {
                internal_device_name: self.internal_device_name,
                bytes: self.bytes.unwrap_or_default(),
                ebs_volume_id: self.ebs_volume_id,
            }
        }
    }
}
impl RecoveryInstanceDisk {
    /// Creates a new builder-style object to manufacture [`RecoveryInstanceDisk`](crate::model::RecoveryInstanceDisk)
    pub fn builder() -> crate::model::recovery_instance_disk::Builder {
        crate::model::recovery_instance_disk::Builder::default()
    }
}

/// <p>Information about Data Replication</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecoveryInstanceDataReplicationInfo {
    /// <p>Data replication lag duration.</p>
    pub lag_duration: std::option::Option<std::string::String>,
    /// <p>An estimate of when the data replication will be completed.</p>
    pub eta_date_time: std::option::Option<std::string::String>,
    /// <p>The disks that should be replicated.</p>
    pub replicated_disks: std::option::Option<
        std::vec::Vec<crate::model::RecoveryInstanceDataReplicationInfoReplicatedDisk>,
    >,
    /// <p>The state of the data replication.</p>
    pub data_replication_state:
        std::option::Option<crate::model::RecoveryInstanceDataReplicationState>,
    /// <p>Information about whether the data replication has been initiated.</p>
    pub data_replication_initiation:
        std::option::Option<crate::model::RecoveryInstanceDataReplicationInitiation>,
    /// <p>Information about Data Replication</p>
    pub data_replication_error:
        std::option::Option<crate::model::RecoveryInstanceDataReplicationError>,
}
impl RecoveryInstanceDataReplicationInfo {
    /// <p>Data replication lag duration.</p>
    pub fn lag_duration(&self) -> std::option::Option<&str> {
        self.lag_duration.as_deref()
    }
    /// <p>An estimate of when the data replication will be completed.</p>
    pub fn eta_date_time(&self) -> std::option::Option<&str> {
        self.eta_date_time.as_deref()
    }
    /// <p>The disks that should be replicated.</p>
    pub fn replicated_disks(
        &self,
    ) -> std::option::Option<&[crate::model::RecoveryInstanceDataReplicationInfoReplicatedDisk]>
    {
        self.replicated_disks.as_deref()
    }
    /// <p>The state of the data replication.</p>
    pub fn data_replication_state(
        &self,
    ) -> std::option::Option<&crate::model::RecoveryInstanceDataReplicationState> {
        self.data_replication_state.as_ref()
    }
    /// <p>Information about whether the data replication has been initiated.</p>
    pub fn data_replication_initiation(
        &self,
    ) -> std::option::Option<&crate::model::RecoveryInstanceDataReplicationInitiation> {
        self.data_replication_initiation.as_ref()
    }
    /// <p>Information about Data Replication</p>
    pub fn data_replication_error(
        &self,
    ) -> std::option::Option<&crate::model::RecoveryInstanceDataReplicationError> {
        self.data_replication_error.as_ref()
    }
}
impl std::fmt::Debug for RecoveryInstanceDataReplicationInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecoveryInstanceDataReplicationInfo");
        formatter.field("lag_duration", &self.lag_duration);
        formatter.field("eta_date_time", &self.eta_date_time);
        formatter.field("replicated_disks", &self.replicated_disks);
        formatter.field("data_replication_state", &self.data_replication_state);
        formatter.field(
            "data_replication_initiation",
            &self.data_replication_initiation,
        );
        formatter.field("data_replication_error", &self.data_replication_error);
        formatter.finish()
    }
}
/// See [`RecoveryInstanceDataReplicationInfo`](crate::model::RecoveryInstanceDataReplicationInfo)
pub mod recovery_instance_data_replication_info {
    /// A builder for [`RecoveryInstanceDataReplicationInfo`](crate::model::RecoveryInstanceDataReplicationInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lag_duration: std::option::Option<std::string::String>,
        pub(crate) eta_date_time: std::option::Option<std::string::String>,
        pub(crate) replicated_disks: std::option::Option<
            std::vec::Vec<crate::model::RecoveryInstanceDataReplicationInfoReplicatedDisk>,
        >,
        pub(crate) data_replication_state:
            std::option::Option<crate::model::RecoveryInstanceDataReplicationState>,
        pub(crate) data_replication_initiation:
            std::option::Option<crate::model::RecoveryInstanceDataReplicationInitiation>,
        pub(crate) data_replication_error:
            std::option::Option<crate::model::RecoveryInstanceDataReplicationError>,
    }
    impl Builder {
        /// <p>Data replication lag duration.</p>
        pub fn lag_duration(mut self, input: impl Into<std::string::String>) -> Self {
            self.lag_duration = Some(input.into());
            self
        }
        /// <p>Data replication lag duration.</p>
        pub fn set_lag_duration(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lag_duration = input;
            self
        }
        /// <p>An estimate of when the data replication will be completed.</p>
        pub fn eta_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.eta_date_time = Some(input.into());
            self
        }
        /// <p>An estimate of when the data replication will be completed.</p>
        pub fn set_eta_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.eta_date_time = input;
            self
        }
        /// Appends an item to `replicated_disks`.
        ///
        /// To override the contents of this collection use [`set_replicated_disks`](Self::set_replicated_disks).
        ///
        /// <p>The disks that should be replicated.</p>
        pub fn replicated_disks(
            mut self,
            input: crate::model::RecoveryInstanceDataReplicationInfoReplicatedDisk,
        ) -> Self {
            let mut v = self.replicated_disks.unwrap_or_default();
            v.push(input);
            self.replicated_disks = Some(v);
            self
        }
        /// <p>The disks that should be replicated.</p>
        pub fn set_replicated_disks(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::RecoveryInstanceDataReplicationInfoReplicatedDisk>,
            >,
        ) -> Self {
            self.replicated_disks = input;
            self
        }
        /// <p>The state of the data replication.</p>
        pub fn data_replication_state(
            mut self,
            input: crate::model::RecoveryInstanceDataReplicationState,
        ) -> Self {
            self.data_replication_state = Some(input);
            self
        }
        /// <p>The state of the data replication.</p>
        pub fn set_data_replication_state(
            mut self,
            input: std::option::Option<crate::model::RecoveryInstanceDataReplicationState>,
        ) -> Self {
            self.data_replication_state = input;
            self
        }
        /// <p>Information about whether the data replication has been initiated.</p>
        pub fn data_replication_initiation(
            mut self,
            input: crate::model::RecoveryInstanceDataReplicationInitiation,
        ) -> Self {
            self.data_replication_initiation = Some(input);
            self
        }
        /// <p>Information about whether the data replication has been initiated.</p>
        pub fn set_data_replication_initiation(
            mut self,
            input: std::option::Option<crate::model::RecoveryInstanceDataReplicationInitiation>,
        ) -> Self {
            self.data_replication_initiation = input;
            self
        }
        /// <p>Information about Data Replication</p>
        pub fn data_replication_error(
            mut self,
            input: crate::model::RecoveryInstanceDataReplicationError,
        ) -> Self {
            self.data_replication_error = Some(input);
            self
        }
        /// <p>Information about Data Replication</p>
        pub fn set_data_replication_error(
            mut self,
            input: std::option::Option<crate::model::RecoveryInstanceDataReplicationError>,
        ) -> Self {
            self.data_replication_error = input;
            self
        }
        /// Consumes the builder and constructs a [`RecoveryInstanceDataReplicationInfo`](crate::model::RecoveryInstanceDataReplicationInfo)
        pub fn build(self) -> crate::model::RecoveryInstanceDataReplicationInfo {
            crate::model::RecoveryInstanceDataReplicationInfo {
                lag_duration: self.lag_duration,
                eta_date_time: self.eta_date_time,
                replicated_disks: self.replicated_disks,
                data_replication_state: self.data_replication_state,
                data_replication_initiation: self.data_replication_initiation,
                data_replication_error: self.data_replication_error,
            }
        }
    }
}
impl RecoveryInstanceDataReplicationInfo {
    /// Creates a new builder-style object to manufacture [`RecoveryInstanceDataReplicationInfo`](crate::model::RecoveryInstanceDataReplicationInfo)
    pub fn builder() -> crate::model::recovery_instance_data_replication_info::Builder {
        crate::model::recovery_instance_data_replication_info::Builder::default()
    }
}

/// <p>Error in data replication.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecoveryInstanceDataReplicationError {
    /// <p>Error in data replication.</p>
    pub error: std::option::Option<crate::model::FailbackReplicationError>,
    /// <p>Error in data replication.</p>
    pub raw_error: std::option::Option<std::string::String>,
}
impl RecoveryInstanceDataReplicationError {
    /// <p>Error in data replication.</p>
    pub fn error(&self) -> std::option::Option<&crate::model::FailbackReplicationError> {
        self.error.as_ref()
    }
    /// <p>Error in data replication.</p>
    pub fn raw_error(&self) -> std::option::Option<&str> {
        self.raw_error.as_deref()
    }
}
impl std::fmt::Debug for RecoveryInstanceDataReplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecoveryInstanceDataReplicationError");
        formatter.field("error", &self.error);
        formatter.field("raw_error", &self.raw_error);
        formatter.finish()
    }
}
/// See [`RecoveryInstanceDataReplicationError`](crate::model::RecoveryInstanceDataReplicationError)
pub mod recovery_instance_data_replication_error {
    /// A builder for [`RecoveryInstanceDataReplicationError`](crate::model::RecoveryInstanceDataReplicationError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error: std::option::Option<crate::model::FailbackReplicationError>,
        pub(crate) raw_error: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error in data replication.</p>
        pub fn error(mut self, input: crate::model::FailbackReplicationError) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>Error in data replication.</p>
        pub fn set_error(
            mut self,
            input: std::option::Option<crate::model::FailbackReplicationError>,
        ) -> Self {
            self.error = input;
            self
        }
        /// <p>Error in data replication.</p>
        pub fn raw_error(mut self, input: impl Into<std::string::String>) -> Self {
            self.raw_error = Some(input.into());
            self
        }
        /// <p>Error in data replication.</p>
        pub fn set_raw_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.raw_error = input;
            self
        }
        /// Consumes the builder and constructs a [`RecoveryInstanceDataReplicationError`](crate::model::RecoveryInstanceDataReplicationError)
        pub fn build(self) -> crate::model::RecoveryInstanceDataReplicationError {
            crate::model::RecoveryInstanceDataReplicationError {
                error: self.error,
                raw_error: self.raw_error,
            }
        }
    }
}
impl RecoveryInstanceDataReplicationError {
    /// Creates a new builder-style object to manufacture [`RecoveryInstanceDataReplicationError`](crate::model::RecoveryInstanceDataReplicationError)
    pub fn builder() -> crate::model::recovery_instance_data_replication_error::Builder {
        crate::model::recovery_instance_data_replication_error::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FailbackReplicationError {
    #[allow(missing_docs)] // documentation missing in model
    AgentNotSeen,
    #[allow(missing_docs)] // documentation missing in model
    FailbackClientNotSeen,
    #[allow(missing_docs)] // documentation missing in model
    FailedToConfigureReplicationSoftware,
    #[allow(missing_docs)] // documentation missing in model
    FailedToDownloadReplicationSoftwareToFailbackClient,
    #[allow(missing_docs)] // documentation missing in model
    FailedToEstablishAgentReplicatorSoftwareCommunication,
    #[allow(missing_docs)] // documentation missing in model
    FailedToEstablishRecoveryInstanceCommunication,
    #[allow(missing_docs)] // documentation missing in model
    FailedToPairAgentWithReplicationSoftware,
    #[allow(missing_docs)] // documentation missing in model
    NotConverging,
    #[allow(missing_docs)] // documentation missing in model
    UnstableNetwork,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FailbackReplicationError {
    fn from(s: &str) -> Self {
        match s {
            "AGENT_NOT_SEEN" => FailbackReplicationError::AgentNotSeen,
            "FAILBACK_CLIENT_NOT_SEEN" => FailbackReplicationError::FailbackClientNotSeen,
            "FAILED_TO_CONFIGURE_REPLICATION_SOFTWARE" => {
                FailbackReplicationError::FailedToConfigureReplicationSoftware
            }
            "FAILED_TO_DOWNLOAD_REPLICATION_SOFTWARE_TO_FAILBACK_CLIENT" => {
                FailbackReplicationError::FailedToDownloadReplicationSoftwareToFailbackClient
            }
            "FAILED_TO_ESTABLISH_AGENT_REPLICATOR_SOFTWARE_COMMUNICATION" => {
                FailbackReplicationError::FailedToEstablishAgentReplicatorSoftwareCommunication
            }
            "FAILED_TO_ESTABLISH_RECOVERY_INSTANCE_COMMUNICATION" => {
                FailbackReplicationError::FailedToEstablishRecoveryInstanceCommunication
            }
            "FAILED_TO_PAIR_AGENT_WITH_REPLICATION_SOFTWARE" => {
                FailbackReplicationError::FailedToPairAgentWithReplicationSoftware
            }
            "NOT_CONVERGING" => FailbackReplicationError::NotConverging,
            "UNSTABLE_NETWORK" => FailbackReplicationError::UnstableNetwork,
            other => FailbackReplicationError::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FailbackReplicationError {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FailbackReplicationError::from(s))
    }
}
impl FailbackReplicationError {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FailbackReplicationError::AgentNotSeen => "AGENT_NOT_SEEN",
            FailbackReplicationError::FailbackClientNotSeen => "FAILBACK_CLIENT_NOT_SEEN",
            FailbackReplicationError::FailedToConfigureReplicationSoftware => {
                "FAILED_TO_CONFIGURE_REPLICATION_SOFTWARE"
            }
            FailbackReplicationError::FailedToDownloadReplicationSoftwareToFailbackClient => {
                "FAILED_TO_DOWNLOAD_REPLICATION_SOFTWARE_TO_FAILBACK_CLIENT"
            }
            FailbackReplicationError::FailedToEstablishAgentReplicatorSoftwareCommunication => {
                "FAILED_TO_ESTABLISH_AGENT_REPLICATOR_SOFTWARE_COMMUNICATION"
            }
            FailbackReplicationError::FailedToEstablishRecoveryInstanceCommunication => {
                "FAILED_TO_ESTABLISH_RECOVERY_INSTANCE_COMMUNICATION"
            }
            FailbackReplicationError::FailedToPairAgentWithReplicationSoftware => {
                "FAILED_TO_PAIR_AGENT_WITH_REPLICATION_SOFTWARE"
            }
            FailbackReplicationError::NotConverging => "NOT_CONVERGING",
            FailbackReplicationError::UnstableNetwork => "UNSTABLE_NETWORK",
            FailbackReplicationError::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AGENT_NOT_SEEN",
            "FAILBACK_CLIENT_NOT_SEEN",
            "FAILED_TO_CONFIGURE_REPLICATION_SOFTWARE",
            "FAILED_TO_DOWNLOAD_REPLICATION_SOFTWARE_TO_FAILBACK_CLIENT",
            "FAILED_TO_ESTABLISH_AGENT_REPLICATOR_SOFTWARE_COMMUNICATION",
            "FAILED_TO_ESTABLISH_RECOVERY_INSTANCE_COMMUNICATION",
            "FAILED_TO_PAIR_AGENT_WITH_REPLICATION_SOFTWARE",
            "NOT_CONVERGING",
            "UNSTABLE_NETWORK",
        ]
    }
}
impl AsRef<str> for FailbackReplicationError {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Data replication initiation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecoveryInstanceDataReplicationInitiation {
    /// <p>The date and time of the current attempt to initiate data replication.</p>
    pub start_date_time: std::option::Option<std::string::String>,
    /// <p>The steps of the current attempt to initiate data replication.</p>
    pub steps: std::option::Option<
        std::vec::Vec<crate::model::RecoveryInstanceDataReplicationInitiationStep>,
    >,
}
impl RecoveryInstanceDataReplicationInitiation {
    /// <p>The date and time of the current attempt to initiate data replication.</p>
    pub fn start_date_time(&self) -> std::option::Option<&str> {
        self.start_date_time.as_deref()
    }
    /// <p>The steps of the current attempt to initiate data replication.</p>
    pub fn steps(
        &self,
    ) -> std::option::Option<&[crate::model::RecoveryInstanceDataReplicationInitiationStep]> {
        self.steps.as_deref()
    }
}
impl std::fmt::Debug for RecoveryInstanceDataReplicationInitiation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecoveryInstanceDataReplicationInitiation");
        formatter.field("start_date_time", &self.start_date_time);
        formatter.field("steps", &self.steps);
        formatter.finish()
    }
}
/// See [`RecoveryInstanceDataReplicationInitiation`](crate::model::RecoveryInstanceDataReplicationInitiation)
pub mod recovery_instance_data_replication_initiation {
    /// A builder for [`RecoveryInstanceDataReplicationInitiation`](crate::model::RecoveryInstanceDataReplicationInitiation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_date_time: std::option::Option<std::string::String>,
        pub(crate) steps: std::option::Option<
            std::vec::Vec<crate::model::RecoveryInstanceDataReplicationInitiationStep>,
        >,
    }
    impl Builder {
        /// <p>The date and time of the current attempt to initiate data replication.</p>
        pub fn start_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_date_time = Some(input.into());
            self
        }
        /// <p>The date and time of the current attempt to initiate data replication.</p>
        pub fn set_start_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.start_date_time = input;
            self
        }
        /// Appends an item to `steps`.
        ///
        /// To override the contents of this collection use [`set_steps`](Self::set_steps).
        ///
        /// <p>The steps of the current attempt to initiate data replication.</p>
        pub fn steps(
            mut self,
            input: crate::model::RecoveryInstanceDataReplicationInitiationStep,
        ) -> Self {
            let mut v = self.steps.unwrap_or_default();
            v.push(input);
            self.steps = Some(v);
            self
        }
        /// <p>The steps of the current attempt to initiate data replication.</p>
        pub fn set_steps(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::RecoveryInstanceDataReplicationInitiationStep>,
            >,
        ) -> Self {
            self.steps = input;
            self
        }
        /// Consumes the builder and constructs a [`RecoveryInstanceDataReplicationInitiation`](crate::model::RecoveryInstanceDataReplicationInitiation)
        pub fn build(self) -> crate::model::RecoveryInstanceDataReplicationInitiation {
            crate::model::RecoveryInstanceDataReplicationInitiation {
                start_date_time: self.start_date_time,
                steps: self.steps,
            }
        }
    }
}
impl RecoveryInstanceDataReplicationInitiation {
    /// Creates a new builder-style object to manufacture [`RecoveryInstanceDataReplicationInitiation`](crate::model::RecoveryInstanceDataReplicationInitiation)
    pub fn builder() -> crate::model::recovery_instance_data_replication_initiation::Builder {
        crate::model::recovery_instance_data_replication_initiation::Builder::default()
    }
}

/// <p>Data replication initiation step.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecoveryInstanceDataReplicationInitiationStep {
    /// <p>The name of the step.</p>
    pub name: std::option::Option<crate::model::RecoveryInstanceDataReplicationInitiationStepName>,
    /// <p>The status of the step.</p>
    pub status:
        std::option::Option<crate::model::RecoveryInstanceDataReplicationInitiationStepStatus>,
}
impl RecoveryInstanceDataReplicationInitiationStep {
    /// <p>The name of the step.</p>
    pub fn name(
        &self,
    ) -> std::option::Option<&crate::model::RecoveryInstanceDataReplicationInitiationStepName> {
        self.name.as_ref()
    }
    /// <p>The status of the step.</p>
    pub fn status(
        &self,
    ) -> std::option::Option<&crate::model::RecoveryInstanceDataReplicationInitiationStepStatus>
    {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for RecoveryInstanceDataReplicationInitiationStep {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecoveryInstanceDataReplicationInitiationStep");
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`RecoveryInstanceDataReplicationInitiationStep`](crate::model::RecoveryInstanceDataReplicationInitiationStep)
pub mod recovery_instance_data_replication_initiation_step {
    /// A builder for [`RecoveryInstanceDataReplicationInitiationStep`](crate::model::RecoveryInstanceDataReplicationInitiationStep)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name:
            std::option::Option<crate::model::RecoveryInstanceDataReplicationInitiationStepName>,
        pub(crate) status:
            std::option::Option<crate::model::RecoveryInstanceDataReplicationInitiationStepStatus>,
    }
    impl Builder {
        /// <p>The name of the step.</p>
        pub fn name(
            mut self,
            input: crate::model::RecoveryInstanceDataReplicationInitiationStepName,
        ) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the step.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<
                crate::model::RecoveryInstanceDataReplicationInitiationStepName,
            >,
        ) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of the step.</p>
        pub fn status(
            mut self,
            input: crate::model::RecoveryInstanceDataReplicationInitiationStepStatus,
        ) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the step.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<
                crate::model::RecoveryInstanceDataReplicationInitiationStepStatus,
            >,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`RecoveryInstanceDataReplicationInitiationStep`](crate::model::RecoveryInstanceDataReplicationInitiationStep)
        pub fn build(self) -> crate::model::RecoveryInstanceDataReplicationInitiationStep {
            crate::model::RecoveryInstanceDataReplicationInitiationStep {
                name: self.name,
                status: self.status,
            }
        }
    }
}
impl RecoveryInstanceDataReplicationInitiationStep {
    /// Creates a new builder-style object to manufacture [`RecoveryInstanceDataReplicationInitiationStep`](crate::model::RecoveryInstanceDataReplicationInitiationStep)
    pub fn builder() -> crate::model::recovery_instance_data_replication_initiation_step::Builder {
        crate::model::recovery_instance_data_replication_initiation_step::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RecoveryInstanceDataReplicationInitiationStepStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    NotStarted,
    #[allow(missing_docs)] // documentation missing in model
    Skipped,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RecoveryInstanceDataReplicationInitiationStepStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => RecoveryInstanceDataReplicationInitiationStepStatus::Failed,
            "IN_PROGRESS" => RecoveryInstanceDataReplicationInitiationStepStatus::InProgress,
            "NOT_STARTED" => RecoveryInstanceDataReplicationInitiationStepStatus::NotStarted,
            "SKIPPED" => RecoveryInstanceDataReplicationInitiationStepStatus::Skipped,
            "SUCCEEDED" => RecoveryInstanceDataReplicationInitiationStepStatus::Succeeded,
            other => RecoveryInstanceDataReplicationInitiationStepStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RecoveryInstanceDataReplicationInitiationStepStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RecoveryInstanceDataReplicationInitiationStepStatus::from(s))
    }
}
impl RecoveryInstanceDataReplicationInitiationStepStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RecoveryInstanceDataReplicationInitiationStepStatus::Failed => "FAILED",
            RecoveryInstanceDataReplicationInitiationStepStatus::InProgress => "IN_PROGRESS",
            RecoveryInstanceDataReplicationInitiationStepStatus::NotStarted => "NOT_STARTED",
            RecoveryInstanceDataReplicationInitiationStepStatus::Skipped => "SKIPPED",
            RecoveryInstanceDataReplicationInitiationStepStatus::Succeeded => "SUCCEEDED",
            RecoveryInstanceDataReplicationInitiationStepStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "FAILED",
            "IN_PROGRESS",
            "NOT_STARTED",
            "SKIPPED",
            "SUCCEEDED",
        ]
    }
}
impl AsRef<str> for RecoveryInstanceDataReplicationInitiationStepStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RecoveryInstanceDataReplicationInitiationStepName {
    #[allow(missing_docs)] // documentation missing in model
    CompleteVolumeMapping,
    #[allow(missing_docs)] // documentation missing in model
    ConfigureReplicationSoftware,
    #[allow(missing_docs)] // documentation missing in model
    DownloadReplicationSoftwareToFailbackClient,
    #[allow(missing_docs)] // documentation missing in model
    EstablishAgentReplicatorSoftwareCommunication,
    #[allow(missing_docs)] // documentation missing in model
    EstablishRecoveryInstanceCommunication,
    #[allow(missing_docs)] // documentation missing in model
    LinkFailbackClientWithRecoveryInstance,
    #[allow(missing_docs)] // documentation missing in model
    PairAgentWithReplicationSoftware,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RecoveryInstanceDataReplicationInitiationStepName {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETE_VOLUME_MAPPING" => RecoveryInstanceDataReplicationInitiationStepName::CompleteVolumeMapping,
            "CONFIGURE_REPLICATION_SOFTWARE" => RecoveryInstanceDataReplicationInitiationStepName::ConfigureReplicationSoftware,
            "DOWNLOAD_REPLICATION_SOFTWARE_TO_FAILBACK_CLIENT" => RecoveryInstanceDataReplicationInitiationStepName::DownloadReplicationSoftwareToFailbackClient,
            "ESTABLISH_AGENT_REPLICATOR_SOFTWARE_COMMUNICATION" => RecoveryInstanceDataReplicationInitiationStepName::EstablishAgentReplicatorSoftwareCommunication,
            "ESTABLISH_RECOVERY_INSTANCE_COMMUNICATION" => RecoveryInstanceDataReplicationInitiationStepName::EstablishRecoveryInstanceCommunication,
            "LINK_FAILBACK_CLIENT_WITH_RECOVERY_INSTANCE" => RecoveryInstanceDataReplicationInitiationStepName::LinkFailbackClientWithRecoveryInstance,
            "PAIR_AGENT_WITH_REPLICATION_SOFTWARE" => RecoveryInstanceDataReplicationInitiationStepName::PairAgentWithReplicationSoftware,
            other => RecoveryInstanceDataReplicationInitiationStepName::Unknown(other.to_owned())
        }
    }
}
impl std::str::FromStr for RecoveryInstanceDataReplicationInitiationStepName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RecoveryInstanceDataReplicationInitiationStepName::from(s))
    }
}
impl RecoveryInstanceDataReplicationInitiationStepName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RecoveryInstanceDataReplicationInitiationStepName::CompleteVolumeMapping => "COMPLETE_VOLUME_MAPPING",
            RecoveryInstanceDataReplicationInitiationStepName::ConfigureReplicationSoftware => "CONFIGURE_REPLICATION_SOFTWARE",
            RecoveryInstanceDataReplicationInitiationStepName::DownloadReplicationSoftwareToFailbackClient => "DOWNLOAD_REPLICATION_SOFTWARE_TO_FAILBACK_CLIENT",
            RecoveryInstanceDataReplicationInitiationStepName::EstablishAgentReplicatorSoftwareCommunication => "ESTABLISH_AGENT_REPLICATOR_SOFTWARE_COMMUNICATION",
            RecoveryInstanceDataReplicationInitiationStepName::EstablishRecoveryInstanceCommunication => "ESTABLISH_RECOVERY_INSTANCE_COMMUNICATION",
            RecoveryInstanceDataReplicationInitiationStepName::LinkFailbackClientWithRecoveryInstance => "LINK_FAILBACK_CLIENT_WITH_RECOVERY_INSTANCE",
            RecoveryInstanceDataReplicationInitiationStepName::PairAgentWithReplicationSoftware => "PAIR_AGENT_WITH_REPLICATION_SOFTWARE",
            RecoveryInstanceDataReplicationInitiationStepName::Unknown(s) => s.as_ref()
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "COMPLETE_VOLUME_MAPPING",
            "CONFIGURE_REPLICATION_SOFTWARE",
            "DOWNLOAD_REPLICATION_SOFTWARE_TO_FAILBACK_CLIENT",
            "ESTABLISH_AGENT_REPLICATOR_SOFTWARE_COMMUNICATION",
            "ESTABLISH_RECOVERY_INSTANCE_COMMUNICATION",
            "LINK_FAILBACK_CLIENT_WITH_RECOVERY_INSTANCE",
            "PAIR_AGENT_WITH_REPLICATION_SOFTWARE",
        ]
    }
}
impl AsRef<str> for RecoveryInstanceDataReplicationInitiationStepName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RecoveryInstanceDataReplicationState {
    #[allow(missing_docs)] // documentation missing in model
    Backlog,
    #[allow(missing_docs)] // documentation missing in model
    Continuous,
    #[allow(missing_docs)] // documentation missing in model
    CreatingSnapshot,
    #[allow(missing_docs)] // documentation missing in model
    Disconnected,
    #[allow(missing_docs)] // documentation missing in model
    InitialSync,
    #[allow(missing_docs)] // documentation missing in model
    Initiating,
    #[allow(missing_docs)] // documentation missing in model
    Paused,
    #[allow(missing_docs)] // documentation missing in model
    Rescan,
    #[allow(missing_docs)] // documentation missing in model
    Stalled,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RecoveryInstanceDataReplicationState {
    fn from(s: &str) -> Self {
        match s {
            "BACKLOG" => RecoveryInstanceDataReplicationState::Backlog,
            "CONTINUOUS" => RecoveryInstanceDataReplicationState::Continuous,
            "CREATING_SNAPSHOT" => RecoveryInstanceDataReplicationState::CreatingSnapshot,
            "DISCONNECTED" => RecoveryInstanceDataReplicationState::Disconnected,
            "INITIAL_SYNC" => RecoveryInstanceDataReplicationState::InitialSync,
            "INITIATING" => RecoveryInstanceDataReplicationState::Initiating,
            "PAUSED" => RecoveryInstanceDataReplicationState::Paused,
            "RESCAN" => RecoveryInstanceDataReplicationState::Rescan,
            "STALLED" => RecoveryInstanceDataReplicationState::Stalled,
            "STOPPED" => RecoveryInstanceDataReplicationState::Stopped,
            other => RecoveryInstanceDataReplicationState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RecoveryInstanceDataReplicationState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RecoveryInstanceDataReplicationState::from(s))
    }
}
impl RecoveryInstanceDataReplicationState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RecoveryInstanceDataReplicationState::Backlog => "BACKLOG",
            RecoveryInstanceDataReplicationState::Continuous => "CONTINUOUS",
            RecoveryInstanceDataReplicationState::CreatingSnapshot => "CREATING_SNAPSHOT",
            RecoveryInstanceDataReplicationState::Disconnected => "DISCONNECTED",
            RecoveryInstanceDataReplicationState::InitialSync => "INITIAL_SYNC",
            RecoveryInstanceDataReplicationState::Initiating => "INITIATING",
            RecoveryInstanceDataReplicationState::Paused => "PAUSED",
            RecoveryInstanceDataReplicationState::Rescan => "RESCAN",
            RecoveryInstanceDataReplicationState::Stalled => "STALLED",
            RecoveryInstanceDataReplicationState::Stopped => "STOPPED",
            RecoveryInstanceDataReplicationState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BACKLOG",
            "CONTINUOUS",
            "CREATING_SNAPSHOT",
            "DISCONNECTED",
            "INITIAL_SYNC",
            "INITIATING",
            "PAUSED",
            "RESCAN",
            "STALLED",
            "STOPPED",
        ]
    }
}
impl AsRef<str> for RecoveryInstanceDataReplicationState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A disk that should be replicated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecoveryInstanceDataReplicationInfoReplicatedDisk {
    /// <p>The name of the device.</p>
    pub device_name: std::option::Option<std::string::String>,
    /// <p>The total amount of data to be replicated in bytes.</p>
    pub total_storage_bytes: i64,
    /// <p>The amount of data replicated so far in bytes.</p>
    pub replicated_storage_bytes: i64,
    /// <p>The amount of data to be rescanned in bytes.</p>
    pub rescanned_storage_bytes: i64,
    /// <p>The size of the replication backlog in bytes.</p>
    pub backlogged_storage_bytes: i64,
}
impl RecoveryInstanceDataReplicationInfoReplicatedDisk {
    /// <p>The name of the device.</p>
    pub fn device_name(&self) -> std::option::Option<&str> {
        self.device_name.as_deref()
    }
    /// <p>The total amount of data to be replicated in bytes.</p>
    pub fn total_storage_bytes(&self) -> i64 {
        self.total_storage_bytes
    }
    /// <p>The amount of data replicated so far in bytes.</p>
    pub fn replicated_storage_bytes(&self) -> i64 {
        self.replicated_storage_bytes
    }
    /// <p>The amount of data to be rescanned in bytes.</p>
    pub fn rescanned_storage_bytes(&self) -> i64 {
        self.rescanned_storage_bytes
    }
    /// <p>The size of the replication backlog in bytes.</p>
    pub fn backlogged_storage_bytes(&self) -> i64 {
        self.backlogged_storage_bytes
    }
}
impl std::fmt::Debug for RecoveryInstanceDataReplicationInfoReplicatedDisk {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecoveryInstanceDataReplicationInfoReplicatedDisk");
        formatter.field("device_name", &self.device_name);
        formatter.field("total_storage_bytes", &self.total_storage_bytes);
        formatter.field("replicated_storage_bytes", &self.replicated_storage_bytes);
        formatter.field("rescanned_storage_bytes", &self.rescanned_storage_bytes);
        formatter.field("backlogged_storage_bytes", &self.backlogged_storage_bytes);
        formatter.finish()
    }
}
/// See [`RecoveryInstanceDataReplicationInfoReplicatedDisk`](crate::model::RecoveryInstanceDataReplicationInfoReplicatedDisk)
pub mod recovery_instance_data_replication_info_replicated_disk {
    /// A builder for [`RecoveryInstanceDataReplicationInfoReplicatedDisk`](crate::model::RecoveryInstanceDataReplicationInfoReplicatedDisk)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_name: std::option::Option<std::string::String>,
        pub(crate) total_storage_bytes: std::option::Option<i64>,
        pub(crate) replicated_storage_bytes: std::option::Option<i64>,
        pub(crate) rescanned_storage_bytes: std::option::Option<i64>,
        pub(crate) backlogged_storage_bytes: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name of the device.</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_name = Some(input.into());
            self
        }
        /// <p>The name of the device.</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_name = input;
            self
        }
        /// <p>The total amount of data to be replicated in bytes.</p>
        pub fn total_storage_bytes(mut self, input: i64) -> Self {
            self.total_storage_bytes = Some(input);
            self
        }
        /// <p>The total amount of data to be replicated in bytes.</p>
        pub fn set_total_storage_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.total_storage_bytes = input;
            self
        }
        /// <p>The amount of data replicated so far in bytes.</p>
        pub fn replicated_storage_bytes(mut self, input: i64) -> Self {
            self.replicated_storage_bytes = Some(input);
            self
        }
        /// <p>The amount of data replicated so far in bytes.</p>
        pub fn set_replicated_storage_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.replicated_storage_bytes = input;
            self
        }
        /// <p>The amount of data to be rescanned in bytes.</p>
        pub fn rescanned_storage_bytes(mut self, input: i64) -> Self {
            self.rescanned_storage_bytes = Some(input);
            self
        }
        /// <p>The amount of data to be rescanned in bytes.</p>
        pub fn set_rescanned_storage_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.rescanned_storage_bytes = input;
            self
        }
        /// <p>The size of the replication backlog in bytes.</p>
        pub fn backlogged_storage_bytes(mut self, input: i64) -> Self {
            self.backlogged_storage_bytes = Some(input);
            self
        }
        /// <p>The size of the replication backlog in bytes.</p>
        pub fn set_backlogged_storage_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.backlogged_storage_bytes = input;
            self
        }
        /// Consumes the builder and constructs a [`RecoveryInstanceDataReplicationInfoReplicatedDisk`](crate::model::RecoveryInstanceDataReplicationInfoReplicatedDisk)
        pub fn build(self) -> crate::model::RecoveryInstanceDataReplicationInfoReplicatedDisk {
            crate::model::RecoveryInstanceDataReplicationInfoReplicatedDisk {
                device_name: self.device_name,
                total_storage_bytes: self.total_storage_bytes.unwrap_or_default(),
                replicated_storage_bytes: self.replicated_storage_bytes.unwrap_or_default(),
                rescanned_storage_bytes: self.rescanned_storage_bytes.unwrap_or_default(),
                backlogged_storage_bytes: self.backlogged_storage_bytes.unwrap_or_default(),
            }
        }
    }
}
impl RecoveryInstanceDataReplicationInfoReplicatedDisk {
    /// Creates a new builder-style object to manufacture [`RecoveryInstanceDataReplicationInfoReplicatedDisk`](crate::model::RecoveryInstanceDataReplicationInfoReplicatedDisk)
    pub fn builder(
    ) -> crate::model::recovery_instance_data_replication_info_replicated_disk::Builder {
        crate::model::recovery_instance_data_replication_info_replicated_disk::Builder::default()
    }
}

/// <p>An object representing failback related information of the Recovery Instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecoveryInstanceFailback {
    /// <p>The ID of the failback client that this Recovery Instance is associated with.</p>
    pub failback_client_id: std::option::Option<std::string::String>,
    /// <p>The Job ID of the last failback log for this Recovery Instance.</p>
    pub failback_job_id: std::option::Option<std::string::String>,
    /// <p>The date and time that the failback initiation started.</p>
    pub failback_initiation_time: std::option::Option<std::string::String>,
    /// <p>The state of the failback process that this Recovery Instance is in.</p>
    pub state: std::option::Option<crate::model::FailbackState>,
    /// <p>The date and time the agent on the Recovery Instance was last seen by the service.</p>
    pub agent_last_seen_by_service_date_time: std::option::Option<std::string::String>,
    /// <p>The date and time that the failback client was last seen by the service.</p>
    pub failback_client_last_seen_by_service_date_time: std::option::Option<std::string::String>,
    /// <p>Whether we are failing back to the original Source Server for this Recovery Instance.</p>
    pub failback_to_original_server: std::option::Option<bool>,
    /// <p>The date and time of the first byte that was replicated from the Recovery Instance.</p>
    pub first_byte_date_time: std::option::Option<std::string::String>,
    /// <p>The amount of time that the Recovery Instance has been replicating for.</p>
    pub elapsed_replication_duration: std::option::Option<std::string::String>,
}
impl RecoveryInstanceFailback {
    /// <p>The ID of the failback client that this Recovery Instance is associated with.</p>
    pub fn failback_client_id(&self) -> std::option::Option<&str> {
        self.failback_client_id.as_deref()
    }
    /// <p>The Job ID of the last failback log for this Recovery Instance.</p>
    pub fn failback_job_id(&self) -> std::option::Option<&str> {
        self.failback_job_id.as_deref()
    }
    /// <p>The date and time that the failback initiation started.</p>
    pub fn failback_initiation_time(&self) -> std::option::Option<&str> {
        self.failback_initiation_time.as_deref()
    }
    /// <p>The state of the failback process that this Recovery Instance is in.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::FailbackState> {
        self.state.as_ref()
    }
    /// <p>The date and time the agent on the Recovery Instance was last seen by the service.</p>
    pub fn agent_last_seen_by_service_date_time(&self) -> std::option::Option<&str> {
        self.agent_last_seen_by_service_date_time.as_deref()
    }
    /// <p>The date and time that the failback client was last seen by the service.</p>
    pub fn failback_client_last_seen_by_service_date_time(&self) -> std::option::Option<&str> {
        self.failback_client_last_seen_by_service_date_time
            .as_deref()
    }
    /// <p>Whether we are failing back to the original Source Server for this Recovery Instance.</p>
    pub fn failback_to_original_server(&self) -> std::option::Option<bool> {
        self.failback_to_original_server
    }
    /// <p>The date and time of the first byte that was replicated from the Recovery Instance.</p>
    pub fn first_byte_date_time(&self) -> std::option::Option<&str> {
        self.first_byte_date_time.as_deref()
    }
    /// <p>The amount of time that the Recovery Instance has been replicating for.</p>
    pub fn elapsed_replication_duration(&self) -> std::option::Option<&str> {
        self.elapsed_replication_duration.as_deref()
    }
}
impl std::fmt::Debug for RecoveryInstanceFailback {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecoveryInstanceFailback");
        formatter.field("failback_client_id", &self.failback_client_id);
        formatter.field("failback_job_id", &self.failback_job_id);
        formatter.field("failback_initiation_time", &self.failback_initiation_time);
        formatter.field("state", &self.state);
        formatter.field(
            "agent_last_seen_by_service_date_time",
            &self.agent_last_seen_by_service_date_time,
        );
        formatter.field(
            "failback_client_last_seen_by_service_date_time",
            &self.failback_client_last_seen_by_service_date_time,
        );
        formatter.field(
            "failback_to_original_server",
            &self.failback_to_original_server,
        );
        formatter.field("first_byte_date_time", &self.first_byte_date_time);
        formatter.field(
            "elapsed_replication_duration",
            &self.elapsed_replication_duration,
        );
        formatter.finish()
    }
}
/// See [`RecoveryInstanceFailback`](crate::model::RecoveryInstanceFailback)
pub mod recovery_instance_failback {
    /// A builder for [`RecoveryInstanceFailback`](crate::model::RecoveryInstanceFailback)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) failback_client_id: std::option::Option<std::string::String>,
        pub(crate) failback_job_id: std::option::Option<std::string::String>,
        pub(crate) failback_initiation_time: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::FailbackState>,
        pub(crate) agent_last_seen_by_service_date_time: std::option::Option<std::string::String>,
        pub(crate) failback_client_last_seen_by_service_date_time:
            std::option::Option<std::string::String>,
        pub(crate) failback_to_original_server: std::option::Option<bool>,
        pub(crate) first_byte_date_time: std::option::Option<std::string::String>,
        pub(crate) elapsed_replication_duration: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the failback client that this Recovery Instance is associated with.</p>
        pub fn failback_client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.failback_client_id = Some(input.into());
            self
        }
        /// <p>The ID of the failback client that this Recovery Instance is associated with.</p>
        pub fn set_failback_client_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failback_client_id = input;
            self
        }
        /// <p>The Job ID of the last failback log for this Recovery Instance.</p>
        pub fn failback_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.failback_job_id = Some(input.into());
            self
        }
        /// <p>The Job ID of the last failback log for this Recovery Instance.</p>
        pub fn set_failback_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failback_job_id = input;
            self
        }
        /// <p>The date and time that the failback initiation started.</p>
        pub fn failback_initiation_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.failback_initiation_time = Some(input.into());
            self
        }
        /// <p>The date and time that the failback initiation started.</p>
        pub fn set_failback_initiation_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failback_initiation_time = input;
            self
        }
        /// <p>The state of the failback process that this Recovery Instance is in.</p>
        pub fn state(mut self, input: crate::model::FailbackState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the failback process that this Recovery Instance is in.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::FailbackState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The date and time the agent on the Recovery Instance was last seen by the service.</p>
        pub fn agent_last_seen_by_service_date_time(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.agent_last_seen_by_service_date_time = Some(input.into());
            self
        }
        /// <p>The date and time the agent on the Recovery Instance was last seen by the service.</p>
        pub fn set_agent_last_seen_by_service_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.agent_last_seen_by_service_date_time = input;
            self
        }
        /// <p>The date and time that the failback client was last seen by the service.</p>
        pub fn failback_client_last_seen_by_service_date_time(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.failback_client_last_seen_by_service_date_time = Some(input.into());
            self
        }
        /// <p>The date and time that the failback client was last seen by the service.</p>
        pub fn set_failback_client_last_seen_by_service_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failback_client_last_seen_by_service_date_time = input;
            self
        }
        /// <p>Whether we are failing back to the original Source Server for this Recovery Instance.</p>
        pub fn failback_to_original_server(mut self, input: bool) -> Self {
            self.failback_to_original_server = Some(input);
            self
        }
        /// <p>Whether we are failing back to the original Source Server for this Recovery Instance.</p>
        pub fn set_failback_to_original_server(mut self, input: std::option::Option<bool>) -> Self {
            self.failback_to_original_server = input;
            self
        }
        /// <p>The date and time of the first byte that was replicated from the Recovery Instance.</p>
        pub fn first_byte_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.first_byte_date_time = Some(input.into());
            self
        }
        /// <p>The date and time of the first byte that was replicated from the Recovery Instance.</p>
        pub fn set_first_byte_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.first_byte_date_time = input;
            self
        }
        /// <p>The amount of time that the Recovery Instance has been replicating for.</p>
        pub fn elapsed_replication_duration(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.elapsed_replication_duration = Some(input.into());
            self
        }
        /// <p>The amount of time that the Recovery Instance has been replicating for.</p>
        pub fn set_elapsed_replication_duration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.elapsed_replication_duration = input;
            self
        }
        /// Consumes the builder and constructs a [`RecoveryInstanceFailback`](crate::model::RecoveryInstanceFailback)
        pub fn build(self) -> crate::model::RecoveryInstanceFailback {
            crate::model::RecoveryInstanceFailback {
                failback_client_id: self.failback_client_id,
                failback_job_id: self.failback_job_id,
                failback_initiation_time: self.failback_initiation_time,
                state: self.state,
                agent_last_seen_by_service_date_time: self.agent_last_seen_by_service_date_time,
                failback_client_last_seen_by_service_date_time: self
                    .failback_client_last_seen_by_service_date_time,
                failback_to_original_server: self.failback_to_original_server,
                first_byte_date_time: self.first_byte_date_time,
                elapsed_replication_duration: self.elapsed_replication_duration,
            }
        }
    }
}
impl RecoveryInstanceFailback {
    /// Creates a new builder-style object to manufacture [`RecoveryInstanceFailback`](crate::model::RecoveryInstanceFailback)
    pub fn builder() -> crate::model::recovery_instance_failback::Builder {
        crate::model::recovery_instance_failback::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FailbackState {
    #[allow(missing_docs)] // documentation missing in model
    FailbackCompleted,
    #[allow(missing_docs)] // documentation missing in model
    FailbackError,
    #[allow(missing_docs)] // documentation missing in model
    FailbackInProgress,
    #[allow(missing_docs)] // documentation missing in model
    FailbackNotStarted,
    #[allow(missing_docs)] // documentation missing in model
    FailbackReadyForLaunch,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FailbackState {
    fn from(s: &str) -> Self {
        match s {
            "FAILBACK_COMPLETED" => FailbackState::FailbackCompleted,
            "FAILBACK_ERROR" => FailbackState::FailbackError,
            "FAILBACK_IN_PROGRESS" => FailbackState::FailbackInProgress,
            "FAILBACK_NOT_STARTED" => FailbackState::FailbackNotStarted,
            "FAILBACK_READY_FOR_LAUNCH" => FailbackState::FailbackReadyForLaunch,
            other => FailbackState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FailbackState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FailbackState::from(s))
    }
}
impl FailbackState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FailbackState::FailbackCompleted => "FAILBACK_COMPLETED",
            FailbackState::FailbackError => "FAILBACK_ERROR",
            FailbackState::FailbackInProgress => "FAILBACK_IN_PROGRESS",
            FailbackState::FailbackNotStarted => "FAILBACK_NOT_STARTED",
            FailbackState::FailbackReadyForLaunch => "FAILBACK_READY_FOR_LAUNCH",
            FailbackState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "FAILBACK_COMPLETED",
            "FAILBACK_ERROR",
            "FAILBACK_IN_PROGRESS",
            "FAILBACK_NOT_STARTED",
            "FAILBACK_READY_FOR_LAUNCH",
        ]
    }
}
impl AsRef<str> for FailbackState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Ec2InstanceState {
    #[allow(missing_docs)] // documentation missing in model
    NotFound,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    ShuttingDown,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    #[allow(missing_docs)] // documentation missing in model
    Terminated,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Ec2InstanceState {
    fn from(s: &str) -> Self {
        match s {
            "NOT_FOUND" => Ec2InstanceState::NotFound,
            "PENDING" => Ec2InstanceState::Pending,
            "RUNNING" => Ec2InstanceState::Running,
            "SHUTTING-DOWN" => Ec2InstanceState::ShuttingDown,
            "STOPPED" => Ec2InstanceState::Stopped,
            "STOPPING" => Ec2InstanceState::Stopping,
            "TERMINATED" => Ec2InstanceState::Terminated,
            other => Ec2InstanceState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Ec2InstanceState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Ec2InstanceState::from(s))
    }
}
impl Ec2InstanceState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Ec2InstanceState::NotFound => "NOT_FOUND",
            Ec2InstanceState::Pending => "PENDING",
            Ec2InstanceState::Running => "RUNNING",
            Ec2InstanceState::ShuttingDown => "SHUTTING-DOWN",
            Ec2InstanceState::Stopped => "STOPPED",
            Ec2InstanceState::Stopping => "STOPPING",
            Ec2InstanceState::Terminated => "TERMINATED",
            Ec2InstanceState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "NOT_FOUND",
            "PENDING",
            "RUNNING",
            "SHUTTING-DOWN",
            "STOPPED",
            "STOPPING",
            "TERMINATED",
        ]
    }
}
impl AsRef<str> for Ec2InstanceState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A set of filters by which to return Recovery Instances.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRecoveryInstancesRequestFilters {
    /// <p>An array of Recovery Instance IDs that should be returned. An empty array means all Recovery Instances.</p>
    pub recovery_instance_i_ds: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of Source Server IDs for which associated Recovery Instances should be returned.</p>
    pub source_server_i_ds: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeRecoveryInstancesRequestFilters {
    /// <p>An array of Recovery Instance IDs that should be returned. An empty array means all Recovery Instances.</p>
    pub fn recovery_instance_i_ds(&self) -> std::option::Option<&[std::string::String]> {
        self.recovery_instance_i_ds.as_deref()
    }
    /// <p>An array of Source Server IDs for which associated Recovery Instances should be returned.</p>
    pub fn source_server_i_ds(&self) -> std::option::Option<&[std::string::String]> {
        self.source_server_i_ds.as_deref()
    }
}
impl std::fmt::Debug for DescribeRecoveryInstancesRequestFilters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRecoveryInstancesRequestFilters");
        formatter.field("recovery_instance_i_ds", &self.recovery_instance_i_ds);
        formatter.field("source_server_i_ds", &self.source_server_i_ds);
        formatter.finish()
    }
}
/// See [`DescribeRecoveryInstancesRequestFilters`](crate::model::DescribeRecoveryInstancesRequestFilters)
pub mod describe_recovery_instances_request_filters {
    /// A builder for [`DescribeRecoveryInstancesRequestFilters`](crate::model::DescribeRecoveryInstancesRequestFilters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recovery_instance_i_ds: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) source_server_i_ds: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `recovery_instance_i_ds`.
        ///
        /// To override the contents of this collection use [`set_recovery_instance_i_ds`](Self::set_recovery_instance_i_ds).
        ///
        /// <p>An array of Recovery Instance IDs that should be returned. An empty array means all Recovery Instances.</p>
        pub fn recovery_instance_i_ds(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.recovery_instance_i_ds.unwrap_or_default();
            v.push(input.into());
            self.recovery_instance_i_ds = Some(v);
            self
        }
        /// <p>An array of Recovery Instance IDs that should be returned. An empty array means all Recovery Instances.</p>
        pub fn set_recovery_instance_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.recovery_instance_i_ds = input;
            self
        }
        /// Appends an item to `source_server_i_ds`.
        ///
        /// To override the contents of this collection use [`set_source_server_i_ds`](Self::set_source_server_i_ds).
        ///
        /// <p>An array of Source Server IDs for which associated Recovery Instances should be returned.</p>
        pub fn source_server_i_ds(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.source_server_i_ds.unwrap_or_default();
            v.push(input.into());
            self.source_server_i_ds = Some(v);
            self
        }
        /// <p>An array of Source Server IDs for which associated Recovery Instances should be returned.</p>
        pub fn set_source_server_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.source_server_i_ds = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRecoveryInstancesRequestFilters`](crate::model::DescribeRecoveryInstancesRequestFilters)
        pub fn build(self) -> crate::model::DescribeRecoveryInstancesRequestFilters {
            crate::model::DescribeRecoveryInstancesRequestFilters {
                recovery_instance_i_ds: self.recovery_instance_i_ds,
                source_server_i_ds: self.source_server_i_ds,
            }
        }
    }
}
impl DescribeRecoveryInstancesRequestFilters {
    /// Creates a new builder-style object to manufacture [`DescribeRecoveryInstancesRequestFilters`](crate::model::DescribeRecoveryInstancesRequestFilters)
    pub fn builder() -> crate::model::describe_recovery_instances_request_filters::Builder {
        crate::model::describe_recovery_instances_request_filters::Builder::default()
    }
}

/// <p>A log outputted by a Job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobLog {
    /// <p>The date and time the log was taken.</p>
    pub log_date_time: std::option::Option<std::string::String>,
    /// <p>The event represents the type of a log.</p>
    pub event: std::option::Option<crate::model::JobLogEvent>,
    /// <p>Metadata associated with a Job log.</p>
    pub event_data: std::option::Option<crate::model::JobLogEventData>,
}
impl JobLog {
    /// <p>The date and time the log was taken.</p>
    pub fn log_date_time(&self) -> std::option::Option<&str> {
        self.log_date_time.as_deref()
    }
    /// <p>The event represents the type of a log.</p>
    pub fn event(&self) -> std::option::Option<&crate::model::JobLogEvent> {
        self.event.as_ref()
    }
    /// <p>Metadata associated with a Job log.</p>
    pub fn event_data(&self) -> std::option::Option<&crate::model::JobLogEventData> {
        self.event_data.as_ref()
    }
}
impl std::fmt::Debug for JobLog {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobLog");
        formatter.field("log_date_time", &self.log_date_time);
        formatter.field("event", &self.event);
        formatter.field("event_data", &self.event_data);
        formatter.finish()
    }
}
/// See [`JobLog`](crate::model::JobLog)
pub mod job_log {
    /// A builder for [`JobLog`](crate::model::JobLog)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_date_time: std::option::Option<std::string::String>,
        pub(crate) event: std::option::Option<crate::model::JobLogEvent>,
        pub(crate) event_data: std::option::Option<crate::model::JobLogEventData>,
    }
    impl Builder {
        /// <p>The date and time the log was taken.</p>
        pub fn log_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_date_time = Some(input.into());
            self
        }
        /// <p>The date and time the log was taken.</p>
        pub fn set_log_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_date_time = input;
            self
        }
        /// <p>The event represents the type of a log.</p>
        pub fn event(mut self, input: crate::model::JobLogEvent) -> Self {
            self.event = Some(input);
            self
        }
        /// <p>The event represents the type of a log.</p>
        pub fn set_event(mut self, input: std::option::Option<crate::model::JobLogEvent>) -> Self {
            self.event = input;
            self
        }
        /// <p>Metadata associated with a Job log.</p>
        pub fn event_data(mut self, input: crate::model::JobLogEventData) -> Self {
            self.event_data = Some(input);
            self
        }
        /// <p>Metadata associated with a Job log.</p>
        pub fn set_event_data(
            mut self,
            input: std::option::Option<crate::model::JobLogEventData>,
        ) -> Self {
            self.event_data = input;
            self
        }
        /// Consumes the builder and constructs a [`JobLog`](crate::model::JobLog)
        pub fn build(self) -> crate::model::JobLog {
            crate::model::JobLog {
                log_date_time: self.log_date_time,
                event: self.event,
                event_data: self.event_data,
            }
        }
    }
}
impl JobLog {
    /// Creates a new builder-style object to manufacture [`JobLog`](crate::model::JobLog)
    pub fn builder() -> crate::model::job_log::Builder {
        crate::model::job_log::Builder::default()
    }
}

/// <p>Metadata associated with a Job log.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobLogEventData {
    /// <p>The ID of a Source Server.</p>
    pub source_server_id: std::option::Option<std::string::String>,
    /// <p>The ID of a conversion server.</p>
    pub conversion_server_id: std::option::Option<std::string::String>,
    /// <p>The ID of a Recovery Instance.</p>
    pub target_instance_id: std::option::Option<std::string::String>,
    /// <p>A string representing a job error.</p>
    pub raw_error: std::option::Option<std::string::String>,
}
impl JobLogEventData {
    /// <p>The ID of a Source Server.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
    /// <p>The ID of a conversion server.</p>
    pub fn conversion_server_id(&self) -> std::option::Option<&str> {
        self.conversion_server_id.as_deref()
    }
    /// <p>The ID of a Recovery Instance.</p>
    pub fn target_instance_id(&self) -> std::option::Option<&str> {
        self.target_instance_id.as_deref()
    }
    /// <p>A string representing a job error.</p>
    pub fn raw_error(&self) -> std::option::Option<&str> {
        self.raw_error.as_deref()
    }
}
impl std::fmt::Debug for JobLogEventData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobLogEventData");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.field("conversion_server_id", &self.conversion_server_id);
        formatter.field("target_instance_id", &self.target_instance_id);
        formatter.field("raw_error", &self.raw_error);
        formatter.finish()
    }
}
/// See [`JobLogEventData`](crate::model::JobLogEventData)
pub mod job_log_event_data {
    /// A builder for [`JobLogEventData`](crate::model::JobLogEventData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
        pub(crate) conversion_server_id: std::option::Option<std::string::String>,
        pub(crate) target_instance_id: std::option::Option<std::string::String>,
        pub(crate) raw_error: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of a Source Server.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>The ID of a Source Server.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// <p>The ID of a conversion server.</p>
        pub fn conversion_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.conversion_server_id = Some(input.into());
            self
        }
        /// <p>The ID of a conversion server.</p>
        pub fn set_conversion_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.conversion_server_id = input;
            self
        }
        /// <p>The ID of a Recovery Instance.</p>
        pub fn target_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_instance_id = Some(input.into());
            self
        }
        /// <p>The ID of a Recovery Instance.</p>
        pub fn set_target_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_instance_id = input;
            self
        }
        /// <p>A string representing a job error.</p>
        pub fn raw_error(mut self, input: impl Into<std::string::String>) -> Self {
            self.raw_error = Some(input.into());
            self
        }
        /// <p>A string representing a job error.</p>
        pub fn set_raw_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.raw_error = input;
            self
        }
        /// Consumes the builder and constructs a [`JobLogEventData`](crate::model::JobLogEventData)
        pub fn build(self) -> crate::model::JobLogEventData {
            crate::model::JobLogEventData {
                source_server_id: self.source_server_id,
                conversion_server_id: self.conversion_server_id,
                target_instance_id: self.target_instance_id,
                raw_error: self.raw_error,
            }
        }
    }
}
impl JobLogEventData {
    /// Creates a new builder-style object to manufacture [`JobLogEventData`](crate::model::JobLogEventData)
    pub fn builder() -> crate::model::job_log_event_data::Builder {
        crate::model::job_log_event_data::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobLogEvent {
    #[allow(missing_docs)] // documentation missing in model
    CleanupEnd,
    #[allow(missing_docs)] // documentation missing in model
    CleanupFail,
    #[allow(missing_docs)] // documentation missing in model
    CleanupStart,
    #[allow(missing_docs)] // documentation missing in model
    ConversionEnd,
    #[allow(missing_docs)] // documentation missing in model
    ConversionFail,
    #[allow(missing_docs)] // documentation missing in model
    ConversionStart,
    #[allow(missing_docs)] // documentation missing in model
    JobCancel,
    #[allow(missing_docs)] // documentation missing in model
    JobEnd,
    #[allow(missing_docs)] // documentation missing in model
    JobStart,
    #[allow(missing_docs)] // documentation missing in model
    LaunchFailed,
    #[allow(missing_docs)] // documentation missing in model
    LaunchStart,
    #[allow(missing_docs)] // documentation missing in model
    ServerSkipped,
    #[allow(missing_docs)] // documentation missing in model
    SnapshotEnd,
    #[allow(missing_docs)] // documentation missing in model
    SnapshotFail,
    #[allow(missing_docs)] // documentation missing in model
    SnapshotStart,
    #[allow(missing_docs)] // documentation missing in model
    UsingPreviousSnapshot,
    #[allow(missing_docs)] // documentation missing in model
    UsingPreviousSnapshotFailed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobLogEvent {
    fn from(s: &str) -> Self {
        match s {
            "CLEANUP_END" => JobLogEvent::CleanupEnd,
            "CLEANUP_FAIL" => JobLogEvent::CleanupFail,
            "CLEANUP_START" => JobLogEvent::CleanupStart,
            "CONVERSION_END" => JobLogEvent::ConversionEnd,
            "CONVERSION_FAIL" => JobLogEvent::ConversionFail,
            "CONVERSION_START" => JobLogEvent::ConversionStart,
            "JOB_CANCEL" => JobLogEvent::JobCancel,
            "JOB_END" => JobLogEvent::JobEnd,
            "JOB_START" => JobLogEvent::JobStart,
            "LAUNCH_FAILED" => JobLogEvent::LaunchFailed,
            "LAUNCH_START" => JobLogEvent::LaunchStart,
            "SERVER_SKIPPED" => JobLogEvent::ServerSkipped,
            "SNAPSHOT_END" => JobLogEvent::SnapshotEnd,
            "SNAPSHOT_FAIL" => JobLogEvent::SnapshotFail,
            "SNAPSHOT_START" => JobLogEvent::SnapshotStart,
            "USING_PREVIOUS_SNAPSHOT" => JobLogEvent::UsingPreviousSnapshot,
            "USING_PREVIOUS_SNAPSHOT_FAILED" => JobLogEvent::UsingPreviousSnapshotFailed,
            other => JobLogEvent::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobLogEvent {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobLogEvent::from(s))
    }
}
impl JobLogEvent {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobLogEvent::CleanupEnd => "CLEANUP_END",
            JobLogEvent::CleanupFail => "CLEANUP_FAIL",
            JobLogEvent::CleanupStart => "CLEANUP_START",
            JobLogEvent::ConversionEnd => "CONVERSION_END",
            JobLogEvent::ConversionFail => "CONVERSION_FAIL",
            JobLogEvent::ConversionStart => "CONVERSION_START",
            JobLogEvent::JobCancel => "JOB_CANCEL",
            JobLogEvent::JobEnd => "JOB_END",
            JobLogEvent::JobStart => "JOB_START",
            JobLogEvent::LaunchFailed => "LAUNCH_FAILED",
            JobLogEvent::LaunchStart => "LAUNCH_START",
            JobLogEvent::ServerSkipped => "SERVER_SKIPPED",
            JobLogEvent::SnapshotEnd => "SNAPSHOT_END",
            JobLogEvent::SnapshotFail => "SNAPSHOT_FAIL",
            JobLogEvent::SnapshotStart => "SNAPSHOT_START",
            JobLogEvent::UsingPreviousSnapshot => "USING_PREVIOUS_SNAPSHOT",
            JobLogEvent::UsingPreviousSnapshotFailed => "USING_PREVIOUS_SNAPSHOT_FAILED",
            JobLogEvent::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CLEANUP_END",
            "CLEANUP_FAIL",
            "CLEANUP_START",
            "CONVERSION_END",
            "CONVERSION_FAIL",
            "CONVERSION_START",
            "JOB_CANCEL",
            "JOB_END",
            "JOB_START",
            "LAUNCH_FAILED",
            "LAUNCH_START",
            "SERVER_SKIPPED",
            "SNAPSHOT_END",
            "SNAPSHOT_FAIL",
            "SNAPSHOT_START",
            "USING_PREVIOUS_SNAPSHOT",
            "USING_PREVIOUS_SNAPSHOT_FAILED",
        ]
    }
}
impl AsRef<str> for JobLogEvent {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A set of filters by which to return Jobs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeJobsRequestFilters {
    /// <p>An array of Job IDs that should be returned. An empty array means all jobs.</p>
    pub job_i_ds: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The start date in a date range query.</p>
    pub from_date: std::option::Option<std::string::String>,
    /// <p>The end date in a date range query.</p>
    pub to_date: std::option::Option<std::string::String>,
}
impl DescribeJobsRequestFilters {
    /// <p>An array of Job IDs that should be returned. An empty array means all jobs.</p>
    pub fn job_i_ds(&self) -> std::option::Option<&[std::string::String]> {
        self.job_i_ds.as_deref()
    }
    /// <p>The start date in a date range query.</p>
    pub fn from_date(&self) -> std::option::Option<&str> {
        self.from_date.as_deref()
    }
    /// <p>The end date in a date range query.</p>
    pub fn to_date(&self) -> std::option::Option<&str> {
        self.to_date.as_deref()
    }
}
impl std::fmt::Debug for DescribeJobsRequestFilters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeJobsRequestFilters");
        formatter.field("job_i_ds", &self.job_i_ds);
        formatter.field("from_date", &self.from_date);
        formatter.field("to_date", &self.to_date);
        formatter.finish()
    }
}
/// See [`DescribeJobsRequestFilters`](crate::model::DescribeJobsRequestFilters)
pub mod describe_jobs_request_filters {
    /// A builder for [`DescribeJobsRequestFilters`](crate::model::DescribeJobsRequestFilters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_i_ds: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) from_date: std::option::Option<std::string::String>,
        pub(crate) to_date: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `job_i_ds`.
        ///
        /// To override the contents of this collection use [`set_job_i_ds`](Self::set_job_i_ds).
        ///
        /// <p>An array of Job IDs that should be returned. An empty array means all jobs.</p>
        pub fn job_i_ds(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.job_i_ds.unwrap_or_default();
            v.push(input.into());
            self.job_i_ds = Some(v);
            self
        }
        /// <p>An array of Job IDs that should be returned. An empty array means all jobs.</p>
        pub fn set_job_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.job_i_ds = input;
            self
        }
        /// <p>The start date in a date range query.</p>
        pub fn from_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_date = Some(input.into());
            self
        }
        /// <p>The start date in a date range query.</p>
        pub fn set_from_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.from_date = input;
            self
        }
        /// <p>The end date in a date range query.</p>
        pub fn to_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.to_date = Some(input.into());
            self
        }
        /// <p>The end date in a date range query.</p>
        pub fn set_to_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.to_date = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeJobsRequestFilters`](crate::model::DescribeJobsRequestFilters)
        pub fn build(self) -> crate::model::DescribeJobsRequestFilters {
            crate::model::DescribeJobsRequestFilters {
                job_i_ds: self.job_i_ds,
                from_date: self.from_date,
                to_date: self.to_date,
            }
        }
    }
}
impl DescribeJobsRequestFilters {
    /// Creates a new builder-style object to manufacture [`DescribeJobsRequestFilters`](crate::model::DescribeJobsRequestFilters)
    pub fn builder() -> crate::model::describe_jobs_request_filters::Builder {
        crate::model::describe_jobs_request_filters::Builder::default()
    }
}
