// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Elastic Disaster Recovery Service
///
/// Client for invoking operations on Elastic Disaster Recovery Service. Each operation on Elastic Disaster Recovery Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_drs::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_drs::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_drs::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateReplicationConfigurationTemplate` operation.
    ///
    /// See [`CreateReplicationConfigurationTemplate`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate) for more information about the
    /// operation and its arguments.
    pub fn create_replication_configuration_template(
        &self,
    ) -> fluent_builders::CreateReplicationConfigurationTemplate<C, M, R> {
        fluent_builders::CreateReplicationConfigurationTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteJob` operation.
    ///
    /// See [`DeleteJob`](crate::client::fluent_builders::DeleteJob) for more information about the
    /// operation and its arguments.
    pub fn delete_job(&self) -> fluent_builders::DeleteJob<C, M, R> {
        fluent_builders::DeleteJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRecoveryInstance` operation.
    ///
    /// See [`DeleteRecoveryInstance`](crate::client::fluent_builders::DeleteRecoveryInstance) for more information about the
    /// operation and its arguments.
    pub fn delete_recovery_instance(&self) -> fluent_builders::DeleteRecoveryInstance<C, M, R> {
        fluent_builders::DeleteRecoveryInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteReplicationConfigurationTemplate` operation.
    ///
    /// See [`DeleteReplicationConfigurationTemplate`](crate::client::fluent_builders::DeleteReplicationConfigurationTemplate) for more information about the
    /// operation and its arguments.
    pub fn delete_replication_configuration_template(
        &self,
    ) -> fluent_builders::DeleteReplicationConfigurationTemplate<C, M, R> {
        fluent_builders::DeleteReplicationConfigurationTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSourceServer` operation.
    ///
    /// See [`DeleteSourceServer`](crate::client::fluent_builders::DeleteSourceServer) for more information about the
    /// operation and its arguments.
    pub fn delete_source_server(&self) -> fluent_builders::DeleteSourceServer<C, M, R> {
        fluent_builders::DeleteSourceServer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeJobLogItems` operation.
    ///
    /// See [`DescribeJobLogItems`](crate::client::fluent_builders::DescribeJobLogItems) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeJobLogItems::into_paginator).
    pub fn describe_job_log_items(&self) -> fluent_builders::DescribeJobLogItems<C, M, R> {
        fluent_builders::DescribeJobLogItems::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeJobs` operation.
    ///
    /// See [`DescribeJobs`](crate::client::fluent_builders::DescribeJobs) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeJobs::into_paginator).
    pub fn describe_jobs(&self) -> fluent_builders::DescribeJobs<C, M, R> {
        fluent_builders::DescribeJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRecoveryInstances` operation.
    ///
    /// See [`DescribeRecoveryInstances`](crate::client::fluent_builders::DescribeRecoveryInstances) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeRecoveryInstances::into_paginator).
    pub fn describe_recovery_instances(
        &self,
    ) -> fluent_builders::DescribeRecoveryInstances<C, M, R> {
        fluent_builders::DescribeRecoveryInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRecoverySnapshots` operation.
    ///
    /// See [`DescribeRecoverySnapshots`](crate::client::fluent_builders::DescribeRecoverySnapshots) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeRecoverySnapshots::into_paginator).
    pub fn describe_recovery_snapshots(
        &self,
    ) -> fluent_builders::DescribeRecoverySnapshots<C, M, R> {
        fluent_builders::DescribeRecoverySnapshots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeReplicationConfigurationTemplates` operation.
    ///
    /// See [`DescribeReplicationConfigurationTemplates`](crate::client::fluent_builders::DescribeReplicationConfigurationTemplates) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeReplicationConfigurationTemplates::into_paginator).
    pub fn describe_replication_configuration_templates(
        &self,
    ) -> fluent_builders::DescribeReplicationConfigurationTemplates<C, M, R> {
        fluent_builders::DescribeReplicationConfigurationTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSourceServers` operation.
    ///
    /// See [`DescribeSourceServers`](crate::client::fluent_builders::DescribeSourceServers) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeSourceServers::into_paginator).
    pub fn describe_source_servers(&self) -> fluent_builders::DescribeSourceServers<C, M, R> {
        fluent_builders::DescribeSourceServers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisconnectRecoveryInstance` operation.
    ///
    /// See [`DisconnectRecoveryInstance`](crate::client::fluent_builders::DisconnectRecoveryInstance) for more information about the
    /// operation and its arguments.
    pub fn disconnect_recovery_instance(
        &self,
    ) -> fluent_builders::DisconnectRecoveryInstance<C, M, R> {
        fluent_builders::DisconnectRecoveryInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisconnectSourceServer` operation.
    ///
    /// See [`DisconnectSourceServer`](crate::client::fluent_builders::DisconnectSourceServer) for more information about the
    /// operation and its arguments.
    pub fn disconnect_source_server(&self) -> fluent_builders::DisconnectSourceServer<C, M, R> {
        fluent_builders::DisconnectSourceServer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFailbackReplicationConfiguration` operation.
    ///
    /// See [`GetFailbackReplicationConfiguration`](crate::client::fluent_builders::GetFailbackReplicationConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_failback_replication_configuration(
        &self,
    ) -> fluent_builders::GetFailbackReplicationConfiguration<C, M, R> {
        fluent_builders::GetFailbackReplicationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLaunchConfiguration` operation.
    ///
    /// See [`GetLaunchConfiguration`](crate::client::fluent_builders::GetLaunchConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_launch_configuration(&self) -> fluent_builders::GetLaunchConfiguration<C, M, R> {
        fluent_builders::GetLaunchConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetReplicationConfiguration` operation.
    ///
    /// See [`GetReplicationConfiguration`](crate::client::fluent_builders::GetReplicationConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_replication_configuration(
        &self,
    ) -> fluent_builders::GetReplicationConfiguration<C, M, R> {
        fluent_builders::GetReplicationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `InitializeService` operation.
    ///
    /// See [`InitializeService`](crate::client::fluent_builders::InitializeService) for more information about the
    /// operation and its arguments.
    pub fn initialize_service(&self) -> fluent_builders::InitializeService<C, M, R> {
        fluent_builders::InitializeService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RetryDataReplication` operation.
    ///
    /// See [`RetryDataReplication`](crate::client::fluent_builders::RetryDataReplication) for more information about the
    /// operation and its arguments.
    pub fn retry_data_replication(&self) -> fluent_builders::RetryDataReplication<C, M, R> {
        fluent_builders::RetryDataReplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartFailbackLaunch` operation.
    ///
    /// See [`StartFailbackLaunch`](crate::client::fluent_builders::StartFailbackLaunch) for more information about the
    /// operation and its arguments.
    pub fn start_failback_launch(&self) -> fluent_builders::StartFailbackLaunch<C, M, R> {
        fluent_builders::StartFailbackLaunch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartRecovery` operation.
    ///
    /// See [`StartRecovery`](crate::client::fluent_builders::StartRecovery) for more information about the
    /// operation and its arguments.
    pub fn start_recovery(&self) -> fluent_builders::StartRecovery<C, M, R> {
        fluent_builders::StartRecovery::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopFailback` operation.
    ///
    /// See [`StopFailback`](crate::client::fluent_builders::StopFailback) for more information about the
    /// operation and its arguments.
    pub fn stop_failback(&self) -> fluent_builders::StopFailback<C, M, R> {
        fluent_builders::StopFailback::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TerminateRecoveryInstances` operation.
    ///
    /// See [`TerminateRecoveryInstances`](crate::client::fluent_builders::TerminateRecoveryInstances) for more information about the
    /// operation and its arguments.
    pub fn terminate_recovery_instances(
        &self,
    ) -> fluent_builders::TerminateRecoveryInstances<C, M, R> {
        fluent_builders::TerminateRecoveryInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFailbackReplicationConfiguration` operation.
    ///
    /// See [`UpdateFailbackReplicationConfiguration`](crate::client::fluent_builders::UpdateFailbackReplicationConfiguration) for more information about the
    /// operation and its arguments.
    pub fn update_failback_replication_configuration(
        &self,
    ) -> fluent_builders::UpdateFailbackReplicationConfiguration<C, M, R> {
        fluent_builders::UpdateFailbackReplicationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateLaunchConfiguration` operation.
    ///
    /// See [`UpdateLaunchConfiguration`](crate::client::fluent_builders::UpdateLaunchConfiguration) for more information about the
    /// operation and its arguments.
    pub fn update_launch_configuration(
        &self,
    ) -> fluent_builders::UpdateLaunchConfiguration<C, M, R> {
        fluent_builders::UpdateLaunchConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateReplicationConfiguration` operation.
    ///
    /// See [`UpdateReplicationConfiguration`](crate::client::fluent_builders::UpdateReplicationConfiguration) for more information about the
    /// operation and its arguments.
    pub fn update_replication_configuration(
        &self,
    ) -> fluent_builders::UpdateReplicationConfiguration<C, M, R> {
        fluent_builders::UpdateReplicationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateReplicationConfigurationTemplate` operation.
    ///
    /// See [`UpdateReplicationConfigurationTemplate`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate) for more information about the
    /// operation and its arguments.
    pub fn update_replication_configuration_template(
        &self,
    ) -> fluent_builders::UpdateReplicationConfigurationTemplate<C, M, R> {
        fluent_builders::UpdateReplicationConfigurationTemplate::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateReplicationConfigurationTemplate`.
    ///
    /// <p>Creates a new ReplicationConfigurationTemplate.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateReplicationConfigurationTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_replication_configuration_template_input::Builder,
    }
    impl<C, M, R> CreateReplicationConfigurationTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateReplicationConfigurationTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateReplicationConfigurationTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateReplicationConfigurationTemplateError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateReplicationConfigurationTemplateInputOperationOutputAlias,
                crate::output::CreateReplicationConfigurationTemplateOutput,
                crate::error::CreateReplicationConfigurationTemplateError,
                crate::input::CreateReplicationConfigurationTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The subnet to be used by the replication staging area.</p>
        pub fn staging_area_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.staging_area_subnet_id(input.into());
            self
        }
        /// <p>The subnet to be used by the replication staging area.</p>
        pub fn set_staging_area_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_staging_area_subnet_id(input);
            self
        }
        /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>
        pub fn associate_default_security_group(mut self, input: bool) -> Self {
            self.inner = self.inner.associate_default_security_group(input);
            self
        }
        /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>
        pub fn set_associate_default_security_group(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_associate_default_security_group(input);
            self
        }
        /// Appends an item to `replicationServersSecurityGroupsIDs`.
        ///
        /// To override the contents of this collection use [`set_replication_servers_security_groups_i_ds`](Self::set_replication_servers_security_groups_i_ds).
        ///
        /// <p>The security group IDs that will be used by the replication server.</p>
        pub fn replication_servers_security_groups_i_ds(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .replication_servers_security_groups_i_ds(input.into());
            self
        }
        /// <p>The security group IDs that will be used by the replication server.</p>
        pub fn set_replication_servers_security_groups_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_replication_servers_security_groups_i_ds(input);
            self
        }
        /// <p>The instance type to be used for the replication server.</p>
        pub fn replication_server_instance_type(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_server_instance_type(input.into());
            self
        }
        /// <p>The instance type to be used for the replication server.</p>
        pub fn set_replication_server_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_server_instance_type(input);
            self
        }
        /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
        pub fn use_dedicated_replication_server(mut self, input: bool) -> Self {
            self.inner = self.inner.use_dedicated_replication_server(input);
            self
        }
        /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
        pub fn set_use_dedicated_replication_server(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_use_dedicated_replication_server(input);
            self
        }
        /// <p>The Staging Disk EBS volume type to be used during replication.</p>
        pub fn default_large_staging_disk_type(
            mut self,
            input: crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
        ) -> Self {
            self.inner = self.inner.default_large_staging_disk_type(input);
            self
        }
        /// <p>The Staging Disk EBS volume type to be used during replication.</p>
        pub fn set_default_large_staging_disk_type(
            mut self,
            input: std::option::Option<
                crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
            >,
        ) -> Self {
            self.inner = self.inner.set_default_large_staging_disk_type(input);
            self
        }
        /// <p>The type of EBS encryption to be used during replication.</p>
        pub fn ebs_encryption(
            mut self,
            input: crate::model::ReplicationConfigurationEbsEncryption,
        ) -> Self {
            self.inner = self.inner.ebs_encryption(input);
            self
        }
        /// <p>The type of EBS encryption to be used during replication.</p>
        pub fn set_ebs_encryption(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        ) -> Self {
            self.inner = self.inner.set_ebs_encryption(input);
            self
        }
        /// <p>The ARN of the EBS encryption key to be used during replication.</p>
        pub fn ebs_encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ebs_encryption_key_arn(input.into());
            self
        }
        /// <p>The ARN of the EBS encryption key to be used during replication.</p>
        pub fn set_ebs_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ebs_encryption_key_arn(input);
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
        pub fn bandwidth_throttling(mut self, input: i64) -> Self {
            self.inner = self.inner.bandwidth_throttling(input);
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
        pub fn set_bandwidth_throttling(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_bandwidth_throttling(input);
            self
        }
        /// <p>The data plane routing mechanism that will be used for replication.</p>
        pub fn data_plane_routing(
            mut self,
            input: crate::model::ReplicationConfigurationDataPlaneRouting,
        ) -> Self {
            self.inner = self.inner.data_plane_routing(input);
            self
        }
        /// <p>The data plane routing mechanism that will be used for replication.</p>
        pub fn set_data_plane_routing(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        ) -> Self {
            self.inner = self.inner.set_data_plane_routing(input);
            self
        }
        /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
        pub fn create_public_ip(mut self, input: bool) -> Self {
            self.inner = self.inner.create_public_ip(input);
            self
        }
        /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
        pub fn set_create_public_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_create_public_ip(input);
            self
        }
        /// Adds a key-value pair to `stagingAreaTags`.
        ///
        /// To override the contents of this collection use [`set_staging_area_tags`](Self::set_staging_area_tags).
        ///
        /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
        pub fn staging_area_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.staging_area_tags(k.into(), v.into());
            self
        }
        /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
        pub fn set_staging_area_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_staging_area_tags(input);
            self
        }
        /// Appends an item to `pitPolicy`.
        ///
        /// To override the contents of this collection use [`set_pit_policy`](Self::set_pit_policy).
        ///
        /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
        pub fn pit_policy(mut self, input: crate::model::PitPolicyRule) -> Self {
            self.inner = self.inner.pit_policy(input);
            self
        }
        /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
        pub fn set_pit_policy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PitPolicyRule>>,
        ) -> Self {
            self.inner = self.inner.set_pit_policy(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A set of tags to be associated with the Replication Configuration Template resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A set of tags to be associated with the Replication Configuration Template resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteJob`.
    ///
    /// <p>Deletes a single Job by ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_job_input::Builder,
    }
    impl<C, M, R> DeleteJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteJobInputOperationOutputAlias,
                crate::output::DeleteJobOutput,
                crate::error::DeleteJobError,
                crate::input::DeleteJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Job to be deleted.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The ID of the Job to be deleted.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRecoveryInstance`.
    ///
    /// <p>Deletes a single Recovery Instance by ID. This deletes the Recovery Instance resource from Elastic Disaster Recovery. The Recovery Instance must be disconnected first in order to delete it.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRecoveryInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_recovery_instance_input::Builder,
    }
    impl<C, M, R> DeleteRecoveryInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRecoveryInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRecoveryInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRecoveryInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRecoveryInstanceInputOperationOutputAlias,
                crate::output::DeleteRecoveryInstanceOutput,
                crate::error::DeleteRecoveryInstanceError,
                crate::input::DeleteRecoveryInstanceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>RThe ID of the Recovery Instance to be deleted.</p>
        pub fn recovery_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_instance_id(input.into());
            self
        }
        /// <p>RThe ID of the Recovery Instance to be deleted.</p>
        pub fn set_recovery_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReplicationConfigurationTemplate`.
    ///
    /// <p>Deletes a single Replication Configuration Template by ID</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteReplicationConfigurationTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_replication_configuration_template_input::Builder,
    }
    impl<C, M, R> DeleteReplicationConfigurationTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteReplicationConfigurationTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReplicationConfigurationTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteReplicationConfigurationTemplateError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteReplicationConfigurationTemplateInputOperationOutputAlias,
                crate::output::DeleteReplicationConfigurationTemplateOutput,
                crate::error::DeleteReplicationConfigurationTemplateError,
                crate::input::DeleteReplicationConfigurationTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Replication Configuration Template to be deleted.</p>
        pub fn replication_configuration_template_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .replication_configuration_template_id(input.into());
            self
        }
        /// <p>The ID of the Replication Configuration Template to be deleted.</p>
        pub fn set_replication_configuration_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_configuration_template_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSourceServer`.
    ///
    /// <p>Deletes a single Source Server by ID. The Source Server must be disconnected first.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSourceServer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_source_server_input::Builder,
    }
    impl<C, M, R> DeleteSourceServer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSourceServer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSourceServerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSourceServerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSourceServerInputOperationOutputAlias,
                crate::output::DeleteSourceServerOutput,
                crate::error::DeleteSourceServerError,
                crate::input::DeleteSourceServerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Source Server to be deleted.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(input.into());
            self
        }
        /// <p>The ID of the Source Server to be deleted.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeJobLogItems`.
    ///
    /// <p>Retrieves a detailed Job log with pagination.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeJobLogItems<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_job_log_items_input::Builder,
    }
    impl<C, M, R> DescribeJobLogItems<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeJobLogItems`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeJobLogItemsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeJobLogItemsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeJobLogItemsInputOperationOutputAlias,
                crate::output::DescribeJobLogItemsOutput,
                crate::error::DescribeJobLogItemsError,
                crate::input::DescribeJobLogItemsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeJobLogItemsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeJobLogItemsPaginator<C, M, R> {
            crate::paginator::DescribeJobLogItemsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the Job for which Job log items will be retrieved.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The ID of the Job for which Job log items will be retrieved.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>Maximum number of Job log items to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of Job log items to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token of the next Job log items to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token of the next Job log items to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeJobs`.
    ///
    /// <p>Returns a list of Jobs. Use the JobsID and fromDate and toDate filters to limit which jobs are returned. The response is sorted by creationDataTime - latest date first. Jobs are created by the StartRecovery, TerminateRecoveryInstances and StartFailbackLaunch APIs. Jobs are also created by DiagnosticLaunch and TerminateDiagnosticInstances, which are APIs available only to *Support* and only used in response to relevant support tickets.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_jobs_input::Builder,
    }
    impl<C, M, R> DescribeJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeJobsInputOperationOutputAlias,
                crate::output::DescribeJobsOutput,
                crate::error::DescribeJobsError,
                crate::input::DescribeJobsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeJobsPaginator<C, M, R> {
            crate::paginator::DescribeJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>A set of filters by which to return Jobs.</p>
        pub fn filters(mut self, input: crate::model::DescribeJobsRequestFilters) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>A set of filters by which to return Jobs.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::DescribeJobsRequestFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Maximum number of Jobs to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of Jobs to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token of the next Job to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token of the next Job to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRecoveryInstances`.
    ///
    /// <p>Lists all Recovery Instances or multiple Recovery Instances by ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRecoveryInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_recovery_instances_input::Builder,
    }
    impl<C, M, R> DescribeRecoveryInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRecoveryInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRecoveryInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRecoveryInstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRecoveryInstancesInputOperationOutputAlias,
                crate::output::DescribeRecoveryInstancesOutput,
                crate::error::DescribeRecoveryInstancesError,
                crate::input::DescribeRecoveryInstancesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeRecoveryInstancesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeRecoveryInstancesPaginator<C, M, R> {
            crate::paginator::DescribeRecoveryInstancesPaginator::new(self.handle, self.inner)
        }
        /// <p>A set of filters by which to return Recovery Instances.</p>
        pub fn filters(
            mut self,
            input: crate::model::DescribeRecoveryInstancesRequestFilters,
        ) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>A set of filters by which to return Recovery Instances.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::DescribeRecoveryInstancesRequestFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Maximum number of Recovery Instances to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of Recovery Instances to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token of the next Recovery Instance to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token of the next Recovery Instance to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRecoverySnapshots`.
    ///
    /// <p>Lists all Recovery Snapshots for a single Source Server.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRecoverySnapshots<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_recovery_snapshots_input::Builder,
    }
    impl<C, M, R> DescribeRecoverySnapshots<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRecoverySnapshots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRecoverySnapshotsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRecoverySnapshotsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRecoverySnapshotsInputOperationOutputAlias,
                crate::output::DescribeRecoverySnapshotsOutput,
                crate::error::DescribeRecoverySnapshotsError,
                crate::input::DescribeRecoverySnapshotsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeRecoverySnapshotsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeRecoverySnapshotsPaginator<C, M, R> {
            crate::paginator::DescribeRecoverySnapshotsPaginator::new(self.handle, self.inner)
        }
        /// <p>Filter Recovery Snapshots by Source Server ID.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(input.into());
            self
        }
        /// <p>Filter Recovery Snapshots by Source Server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
        /// <p>A set of filters by which to return Recovery Snapshots.</p>
        pub fn filters(
            mut self,
            input: crate::model::DescribeRecoverySnapshotsRequestFilters,
        ) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>A set of filters by which to return Recovery Snapshots.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::DescribeRecoverySnapshotsRequestFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The sorted ordering by which to return Recovery Snapshots.</p>
        pub fn order(mut self, input: crate::model::RecoverySnapshotsOrder) -> Self {
            self.inner = self.inner.order(input);
            self
        }
        /// <p>The sorted ordering by which to return Recovery Snapshots.</p>
        pub fn set_order(
            mut self,
            input: std::option::Option<crate::model::RecoverySnapshotsOrder>,
        ) -> Self {
            self.inner = self.inner.set_order(input);
            self
        }
        /// <p>Maximum number of Recovery Snapshots to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of Recovery Snapshots to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token of the next Recovery Snapshot to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token of the next Recovery Snapshot to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReplicationConfigurationTemplates`.
    ///
    /// <p>Lists all ReplicationConfigurationTemplates, filtered by Source Server IDs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeReplicationConfigurationTemplates<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_replication_configuration_templates_input::Builder,
    }
    impl<C, M, R> DescribeReplicationConfigurationTemplates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeReplicationConfigurationTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReplicationConfigurationTemplatesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeReplicationConfigurationTemplatesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeReplicationConfigurationTemplatesInputOperationOutputAlias,
                crate::output::DescribeReplicationConfigurationTemplatesOutput,
                crate::error::DescribeReplicationConfigurationTemplatesError,
                crate::input::DescribeReplicationConfigurationTemplatesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeReplicationConfigurationTemplatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeReplicationConfigurationTemplatesPaginator<C, M, R> {
            crate::paginator::DescribeReplicationConfigurationTemplatesPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// Appends an item to `replicationConfigurationTemplateIDs`.
        ///
        /// To override the contents of this collection use [`set_replication_configuration_template_i_ds`](Self::set_replication_configuration_template_i_ds).
        ///
        /// <p>The IDs of the Replication Configuration Templates to retrieve. An empty list means all Replication Configuration Templates.</p>
        pub fn replication_configuration_template_i_ds(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .replication_configuration_template_i_ds(input.into());
            self
        }
        /// <p>The IDs of the Replication Configuration Templates to retrieve. An empty list means all Replication Configuration Templates.</p>
        pub fn set_replication_configuration_template_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_replication_configuration_template_i_ds(input);
            self
        }
        /// <p>Maximum number of Replication Configuration Templates to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of Replication Configuration Templates to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token of the next Replication Configuration Template to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token of the next Replication Configuration Template to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSourceServers`.
    ///
    /// <p>Lists all Source Servers or multiple Source Servers filtered by ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSourceServers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_source_servers_input::Builder,
    }
    impl<C, M, R> DescribeSourceServers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSourceServers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSourceServersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSourceServersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSourceServersInputOperationOutputAlias,
                crate::output::DescribeSourceServersOutput,
                crate::error::DescribeSourceServersError,
                crate::input::DescribeSourceServersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeSourceServersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeSourceServersPaginator<C, M, R> {
            crate::paginator::DescribeSourceServersPaginator::new(self.handle, self.inner)
        }
        /// <p>A set of filters by which to return Source Servers.</p>
        pub fn filters(mut self, input: crate::model::DescribeSourceServersRequestFilters) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>A set of filters by which to return Source Servers.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::DescribeSourceServersRequestFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Maximum number of Source Servers to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of Source Servers to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token of the next Source Server to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token of the next Source Server to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisconnectRecoveryInstance`.
    ///
    /// <p>Disconnect a Recovery Instance from Elastic Disaster Recovery. Data replication is stopped immediately. All AWS resources created by Elastic Disaster Recovery for enabling the replication of the Recovery Instance will be terminated / deleted within 90 minutes. If the agent on the Recovery Instance has not been prevented from communicating with the Elastic Disaster Recovery service, then it will receive a command to uninstall itself (within approximately 10 minutes). The following properties of the Recovery Instance will be changed immediately: dataReplicationInfo.dataReplicationState will be set to DISCONNECTED; The totalStorageBytes property for each of dataReplicationInfo.replicatedDisks will be set to zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisconnectRecoveryInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disconnect_recovery_instance_input::Builder,
    }
    impl<C, M, R> DisconnectRecoveryInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisconnectRecoveryInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisconnectRecoveryInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DisconnectRecoveryInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisconnectRecoveryInstanceInputOperationOutputAlias,
                crate::output::DisconnectRecoveryInstanceOutput,
                crate::error::DisconnectRecoveryInstanceError,
                crate::input::DisconnectRecoveryInstanceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Recovery Instance to disconnect.</p>
        pub fn recovery_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_instance_id(input.into());
            self
        }
        /// <p>The ID of the Recovery Instance to disconnect.</p>
        pub fn set_recovery_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisconnectSourceServer`.
    ///
    /// <p>Disconnects a specific Source Server from Elastic Disaster Recovery. Data replication is stopped immediately. All AWS resources created by Elastic Disaster Recovery for enabling the replication of the Source Server will be terminated / deleted within 90 minutes. You cannot disconnect a Source Server if it has a Recovery Instance. If the agent on the Source Server has not been prevented from communicating with the Elastic Disaster Recovery service, then it will receive a command to uninstall itself (within approximately 10 minutes). The following properties of the SourceServer will be changed immediately: dataReplicationInfo.dataReplicationState will be set to DISCONNECTED; The totalStorageBytes property for each of dataReplicationInfo.replicatedDisks will be set to zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisconnectSourceServer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disconnect_source_server_input::Builder,
    }
    impl<C, M, R> DisconnectSourceServer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisconnectSourceServer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisconnectSourceServerOutput,
            aws_smithy_http::result::SdkError<crate::error::DisconnectSourceServerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisconnectSourceServerInputOperationOutputAlias,
                crate::output::DisconnectSourceServerOutput,
                crate::error::DisconnectSourceServerError,
                crate::input::DisconnectSourceServerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Source Server to disconnect.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(input.into());
            self
        }
        /// <p>The ID of the Source Server to disconnect.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFailbackReplicationConfiguration`.
    ///
    /// <p>Lists all Failback ReplicationConfigurations, filtered by Recovery Instance ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFailbackReplicationConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_failback_replication_configuration_input::Builder,
    }
    impl<C, M, R> GetFailbackReplicationConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFailbackReplicationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFailbackReplicationConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetFailbackReplicationConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFailbackReplicationConfigurationInputOperationOutputAlias,
                crate::output::GetFailbackReplicationConfigurationOutput,
                crate::error::GetFailbackReplicationConfigurationError,
                crate::input::GetFailbackReplicationConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Recovery Instance whose failback replication configuration should be returned.</p>
        pub fn recovery_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_instance_id(input.into());
            self
        }
        /// <p>The ID of the Recovery Instance whose failback replication configuration should be returned.</p>
        pub fn set_recovery_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLaunchConfiguration`.
    ///
    /// <p>Gets a LaunchConfiguration, filtered by Source Server IDs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLaunchConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_launch_configuration_input::Builder,
    }
    impl<C, M, R> GetLaunchConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLaunchConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLaunchConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLaunchConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLaunchConfigurationInputOperationOutputAlias,
                crate::output::GetLaunchConfigurationOutput,
                crate::error::GetLaunchConfigurationError,
                crate::input::GetLaunchConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Source Server that we want to retrieve a Launch Configuration for.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(input.into());
            self
        }
        /// <p>The ID of the Source Server that we want to retrieve a Launch Configuration for.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetReplicationConfiguration`.
    ///
    /// <p>Gets a ReplicationConfiguration, filtered by Source Server ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetReplicationConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_replication_configuration_input::Builder,
    }
    impl<C, M, R> GetReplicationConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetReplicationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetReplicationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetReplicationConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetReplicationConfigurationInputOperationOutputAlias,
                crate::output::GetReplicationConfigurationOutput,
                crate::error::GetReplicationConfigurationError,
                crate::input::GetReplicationConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Source Serve for this Replication Configuration.r</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(input.into());
            self
        }
        /// <p>The ID of the Source Serve for this Replication Configuration.r</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `InitializeService`.
    ///
    /// <p>Initialize Elastic Disaster Recovery.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct InitializeService<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::initialize_service_input::Builder,
    }
    impl<C, M, R> InitializeService<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `InitializeService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::InitializeServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::InitializeServiceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::InitializeServiceInputOperationOutputAlias,
                crate::output::InitializeServiceOutput,
                crate::error::InitializeServiceError,
                crate::input::InitializeServiceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>List all tags for your Elastic Disaster Recovery resources.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource whose tags should be returned.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource whose tags should be returned.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RetryDataReplication`.
    ///
    /// <p>Causes the data replication initiation sequence to begin immediately upon next Handshake for the specified Source Server ID, regardless of when the previous initiation started. This command will work only if the Source Server is stalled or is in a DISCONNECTED or STOPPED state.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RetryDataReplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::retry_data_replication_input::Builder,
    }
    impl<C, M, R> RetryDataReplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RetryDataReplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RetryDataReplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::RetryDataReplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RetryDataReplicationInputOperationOutputAlias,
                crate::output::RetryDataReplicationOutput,
                crate::error::RetryDataReplicationError,
                crate::input::RetryDataReplicationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Source Server whose data replication should be retried.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(input.into());
            self
        }
        /// <p>The ID of the Source Server whose data replication should be retried.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartFailbackLaunch`.
    ///
    /// <p>Initiates a Job for launching the machine that is being failed back to from the specified Recovery Instance. This will run conversion on the failback client and will reboot your machine, thus completing the failback process.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartFailbackLaunch<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_failback_launch_input::Builder,
    }
    impl<C, M, R> StartFailbackLaunch<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartFailbackLaunch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartFailbackLaunchOutput,
            aws_smithy_http::result::SdkError<crate::error::StartFailbackLaunchError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartFailbackLaunchInputOperationOutputAlias,
                crate::output::StartFailbackLaunchOutput,
                crate::error::StartFailbackLaunchError,
                crate::input::StartFailbackLaunchInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `recoveryInstanceIDs`.
        ///
        /// To override the contents of this collection use [`set_recovery_instance_i_ds`](Self::set_recovery_instance_i_ds).
        ///
        /// <p>The IDs of the Recovery Instance whose failback launch we want to request.</p>
        pub fn recovery_instance_i_ds(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_instance_i_ds(input.into());
            self
        }
        /// <p>The IDs of the Recovery Instance whose failback launch we want to request.</p>
        pub fn set_recovery_instance_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_recovery_instance_i_ds(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be associated with the failback launch Job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to be associated with the failback launch Job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartRecovery`.
    ///
    /// <p>Launches Recovery Instances for the specified Source Servers. For each Source Server you may choose a point in time snapshot to launch from, or use an on demand snapshot.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartRecovery<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_recovery_input::Builder,
    }
    impl<C, M, R> StartRecovery<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartRecovery`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartRecoveryOutput,
            aws_smithy_http::result::SdkError<crate::error::StartRecoveryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartRecoveryInputOperationOutputAlias,
                crate::output::StartRecoveryOutput,
                crate::error::StartRecoveryError,
                crate::input::StartRecoveryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `sourceServers`.
        ///
        /// To override the contents of this collection use [`set_source_servers`](Self::set_source_servers).
        ///
        /// <p>The Source Servers that we want to start a Recovery Job for.</p>
        pub fn source_servers(
            mut self,
            input: crate::model::StartRecoveryRequestSourceServer,
        ) -> Self {
            self.inner = self.inner.source_servers(input);
            self
        }
        /// <p>The Source Servers that we want to start a Recovery Job for.</p>
        pub fn set_source_servers(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::StartRecoveryRequestSourceServer>,
            >,
        ) -> Self {
            self.inner = self.inner.set_source_servers(input);
            self
        }
        /// <p>Whether this Source Server Recovery operation is a drill or not.</p>
        pub fn is_drill(mut self, input: bool) -> Self {
            self.inner = self.inner.is_drill(input);
            self
        }
        /// <p>Whether this Source Server Recovery operation is a drill or not.</p>
        pub fn set_is_drill(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_is_drill(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be associated with the Recovery Job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to be associated with the Recovery Job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopFailback`.
    ///
    /// <p>Stops the failback process for a specified Recovery Instance. This changes the Failback State of the Recovery Instance back to FAILBACK_NOT_STARTED.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopFailback<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_failback_input::Builder,
    }
    impl<C, M, R> StopFailback<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopFailback`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopFailbackOutput,
            aws_smithy_http::result::SdkError<crate::error::StopFailbackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopFailbackInputOperationOutputAlias,
                crate::output::StopFailbackOutput,
                crate::error::StopFailbackError,
                crate::input::StopFailbackInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Recovery Instance we want to stop failback for.</p>
        pub fn recovery_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_instance_id(input.into());
            self
        }
        /// <p>The ID of the Recovery Instance we want to stop failback for.</p>
        pub fn set_recovery_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds or overwrites only the specified tags for the specified Elastic Disaster Recovery resource or resources. When you specify an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of 50 tags. Each tag consists of a key and optional value.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the resource for which tags are to be added or updated.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>ARN of the resource for which tags are to be added or updated.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Array of tags to be added or updated.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Array of tags to be added or updated.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TerminateRecoveryInstances`.
    ///
    /// <p>Initiates a Job for terminating the EC2 resources associated with the specified Recovery Instances, and then will delete the Recovery Instances from the Elastic Disaster Recovery service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TerminateRecoveryInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::terminate_recovery_instances_input::Builder,
    }
    impl<C, M, R> TerminateRecoveryInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TerminateRecoveryInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TerminateRecoveryInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::TerminateRecoveryInstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TerminateRecoveryInstancesInputOperationOutputAlias,
                crate::output::TerminateRecoveryInstancesOutput,
                crate::error::TerminateRecoveryInstancesError,
                crate::input::TerminateRecoveryInstancesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `recoveryInstanceIDs`.
        ///
        /// To override the contents of this collection use [`set_recovery_instance_i_ds`](Self::set_recovery_instance_i_ds).
        ///
        /// <p>The IDs of the Recovery Instances that should be terminated.</p>
        pub fn recovery_instance_i_ds(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_instance_i_ds(input.into());
            self
        }
        /// <p>The IDs of the Recovery Instances that should be terminated.</p>
        pub fn set_recovery_instance_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_recovery_instance_i_ds(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Deletes the specified set of tags from the specified set of Elastic Disaster Recovery resources.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the resource for which tags are to be removed.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>ARN of the resource for which tags are to be removed.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Array of tags to be removed.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>Array of tags to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFailbackReplicationConfiguration`.
    ///
    /// <p>Allows you to update the failback replication configuration of a Recovery Instance by ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFailbackReplicationConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_failback_replication_configuration_input::Builder,
    }
    impl<C, M, R> UpdateFailbackReplicationConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFailbackReplicationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFailbackReplicationConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateFailbackReplicationConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFailbackReplicationConfigurationInputOperationOutputAlias,
                crate::output::UpdateFailbackReplicationConfigurationOutput,
                crate::error::UpdateFailbackReplicationConfigurationError,
                crate::input::UpdateFailbackReplicationConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Recovery Instance.</p>
        pub fn recovery_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_instance_id(input.into());
            self
        }
        /// <p>The ID of the Recovery Instance.</p>
        pub fn set_recovery_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_instance_id(input);
            self
        }
        /// <p>The name of the Failback Replication Configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the Failback Replication Configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Recovery Instance in Mbps.</p>
        pub fn bandwidth_throttling(mut self, input: i64) -> Self {
            self.inner = self.inner.bandwidth_throttling(input);
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Recovery Instance in Mbps.</p>
        pub fn set_bandwidth_throttling(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_bandwidth_throttling(input);
            self
        }
        /// <p>Whether to use Private IP for the failback replication of the Recovery Instance.</p>
        pub fn use_private_ip(mut self, input: bool) -> Self {
            self.inner = self.inner.use_private_ip(input);
            self
        }
        /// <p>Whether to use Private IP for the failback replication of the Recovery Instance.</p>
        pub fn set_use_private_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_use_private_ip(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLaunchConfiguration`.
    ///
    /// <p>Updates a LaunchConfiguration by Source Server ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateLaunchConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_launch_configuration_input::Builder,
    }
    impl<C, M, R> UpdateLaunchConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLaunchConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLaunchConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLaunchConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLaunchConfigurationInputOperationOutputAlias,
                crate::output::UpdateLaunchConfigurationOutput,
                crate::error::UpdateLaunchConfigurationError,
                crate::input::UpdateLaunchConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Source Server that we want to retrieve a Launch Configuration for.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(input.into());
            self
        }
        /// <p>The ID of the Source Server that we want to retrieve a Launch Configuration for.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
        /// <p>The name of the launch configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the launch configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The state of the Recovery Instance in EC2 after the recovery operation.</p>
        pub fn launch_disposition(mut self, input: crate::model::LaunchDisposition) -> Self {
            self.inner = self.inner.launch_disposition(input);
            self
        }
        /// <p>The state of the Recovery Instance in EC2 after the recovery operation.</p>
        pub fn set_launch_disposition(
            mut self,
            input: std::option::Option<crate::model::LaunchDisposition>,
        ) -> Self {
            self.inner = self.inner.set_launch_disposition(input);
            self
        }
        /// <p>Whether Elastic Disaster Recovery should try to automatically choose the instance type that best matches the OS, CPU, and RAM of your Source Server.</p>
        pub fn target_instance_type_right_sizing_method(
            mut self,
            input: crate::model::TargetInstanceTypeRightSizingMethod,
        ) -> Self {
            self.inner = self.inner.target_instance_type_right_sizing_method(input);
            self
        }
        /// <p>Whether Elastic Disaster Recovery should try to automatically choose the instance type that best matches the OS, CPU, and RAM of your Source Server.</p>
        pub fn set_target_instance_type_right_sizing_method(
            mut self,
            input: std::option::Option<crate::model::TargetInstanceTypeRightSizingMethod>,
        ) -> Self {
            self.inner = self
                .inner
                .set_target_instance_type_right_sizing_method(input);
            self
        }
        /// <p>Whether we should copy the Private IP of the Source Server to the Recovery Instance.</p>
        pub fn copy_private_ip(mut self, input: bool) -> Self {
            self.inner = self.inner.copy_private_ip(input);
            self
        }
        /// <p>Whether we should copy the Private IP of the Source Server to the Recovery Instance.</p>
        pub fn set_copy_private_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_copy_private_ip(input);
            self
        }
        /// <p>Whether we want to copy the tags of the Source Server to the EC2 machine of the Recovery Instance.</p>
        pub fn copy_tags(mut self, input: bool) -> Self {
            self.inner = self.inner.copy_tags(input);
            self
        }
        /// <p>Whether we want to copy the tags of the Source Server to the EC2 machine of the Recovery Instance.</p>
        pub fn set_copy_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_copy_tags(input);
            self
        }
        /// <p>The licensing configuration to be used for this launch configuration.</p>
        pub fn licensing(mut self, input: crate::model::Licensing) -> Self {
            self.inner = self.inner.licensing(input);
            self
        }
        /// <p>The licensing configuration to be used for this launch configuration.</p>
        pub fn set_licensing(
            mut self,
            input: std::option::Option<crate::model::Licensing>,
        ) -> Self {
            self.inner = self.inner.set_licensing(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateReplicationConfiguration`.
    ///
    /// <p>Allows you to update a ReplicationConfiguration by Source Server ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateReplicationConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_replication_configuration_input::Builder,
    }
    impl<C, M, R> UpdateReplicationConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateReplicationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateReplicationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateReplicationConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateReplicationConfigurationInputOperationOutputAlias,
                crate::output::UpdateReplicationConfigurationOutput,
                crate::error::UpdateReplicationConfigurationError,
                crate::input::UpdateReplicationConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Source Server for this Replication Configuration.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(input.into());
            self
        }
        /// <p>The ID of the Source Server for this Replication Configuration.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
        /// <p>The name of the Replication Configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the Replication Configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The subnet to be used by the replication staging area.</p>
        pub fn staging_area_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.staging_area_subnet_id(input.into());
            self
        }
        /// <p>The subnet to be used by the replication staging area.</p>
        pub fn set_staging_area_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_staging_area_subnet_id(input);
            self
        }
        /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration.</p>
        pub fn associate_default_security_group(mut self, input: bool) -> Self {
            self.inner = self.inner.associate_default_security_group(input);
            self
        }
        /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration.</p>
        pub fn set_associate_default_security_group(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_associate_default_security_group(input);
            self
        }
        /// Appends an item to `replicationServersSecurityGroupsIDs`.
        ///
        /// To override the contents of this collection use [`set_replication_servers_security_groups_i_ds`](Self::set_replication_servers_security_groups_i_ds).
        ///
        /// <p>The security group IDs that will be used by the replication server.</p>
        pub fn replication_servers_security_groups_i_ds(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .replication_servers_security_groups_i_ds(input.into());
            self
        }
        /// <p>The security group IDs that will be used by the replication server.</p>
        pub fn set_replication_servers_security_groups_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_replication_servers_security_groups_i_ds(input);
            self
        }
        /// <p>The instance type to be used for the replication server.</p>
        pub fn replication_server_instance_type(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_server_instance_type(input.into());
            self
        }
        /// <p>The instance type to be used for the replication server.</p>
        pub fn set_replication_server_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_server_instance_type(input);
            self
        }
        /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
        pub fn use_dedicated_replication_server(mut self, input: bool) -> Self {
            self.inner = self.inner.use_dedicated_replication_server(input);
            self
        }
        /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
        pub fn set_use_dedicated_replication_server(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_use_dedicated_replication_server(input);
            self
        }
        /// <p>The Staging Disk EBS volume type to be used during replication.</p>
        pub fn default_large_staging_disk_type(
            mut self,
            input: crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
        ) -> Self {
            self.inner = self.inner.default_large_staging_disk_type(input);
            self
        }
        /// <p>The Staging Disk EBS volume type to be used during replication.</p>
        pub fn set_default_large_staging_disk_type(
            mut self,
            input: std::option::Option<
                crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
            >,
        ) -> Self {
            self.inner = self.inner.set_default_large_staging_disk_type(input);
            self
        }
        /// Appends an item to `replicatedDisks`.
        ///
        /// To override the contents of this collection use [`set_replicated_disks`](Self::set_replicated_disks).
        ///
        /// <p>The configuration of the disks of the Source Server to be replicated.</p>
        pub fn replicated_disks(
            mut self,
            input: crate::model::ReplicationConfigurationReplicatedDisk,
        ) -> Self {
            self.inner = self.inner.replicated_disks(input);
            self
        }
        /// <p>The configuration of the disks of the Source Server to be replicated.</p>
        pub fn set_replicated_disks(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ReplicationConfigurationReplicatedDisk>,
            >,
        ) -> Self {
            self.inner = self.inner.set_replicated_disks(input);
            self
        }
        /// <p>The type of EBS encryption to be used during replication.</p>
        pub fn ebs_encryption(
            mut self,
            input: crate::model::ReplicationConfigurationEbsEncryption,
        ) -> Self {
            self.inner = self.inner.ebs_encryption(input);
            self
        }
        /// <p>The type of EBS encryption to be used during replication.</p>
        pub fn set_ebs_encryption(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        ) -> Self {
            self.inner = self.inner.set_ebs_encryption(input);
            self
        }
        /// <p>The ARN of the EBS encryption key to be used during replication.</p>
        pub fn ebs_encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ebs_encryption_key_arn(input.into());
            self
        }
        /// <p>The ARN of the EBS encryption key to be used during replication.</p>
        pub fn set_ebs_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ebs_encryption_key_arn(input);
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
        pub fn bandwidth_throttling(mut self, input: i64) -> Self {
            self.inner = self.inner.bandwidth_throttling(input);
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
        pub fn set_bandwidth_throttling(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_bandwidth_throttling(input);
            self
        }
        /// <p>The data plane routing mechanism that will be used for replication.</p>
        pub fn data_plane_routing(
            mut self,
            input: crate::model::ReplicationConfigurationDataPlaneRouting,
        ) -> Self {
            self.inner = self.inner.data_plane_routing(input);
            self
        }
        /// <p>The data plane routing mechanism that will be used for replication.</p>
        pub fn set_data_plane_routing(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        ) -> Self {
            self.inner = self.inner.set_data_plane_routing(input);
            self
        }
        /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
        pub fn create_public_ip(mut self, input: bool) -> Self {
            self.inner = self.inner.create_public_ip(input);
            self
        }
        /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
        pub fn set_create_public_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_create_public_ip(input);
            self
        }
        /// Adds a key-value pair to `stagingAreaTags`.
        ///
        /// To override the contents of this collection use [`set_staging_area_tags`](Self::set_staging_area_tags).
        ///
        /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
        pub fn staging_area_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.staging_area_tags(k.into(), v.into());
            self
        }
        /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
        pub fn set_staging_area_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_staging_area_tags(input);
            self
        }
        /// Appends an item to `pitPolicy`.
        ///
        /// To override the contents of this collection use [`set_pit_policy`](Self::set_pit_policy).
        ///
        /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
        pub fn pit_policy(mut self, input: crate::model::PitPolicyRule) -> Self {
            self.inner = self.inner.pit_policy(input);
            self
        }
        /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
        pub fn set_pit_policy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PitPolicyRule>>,
        ) -> Self {
            self.inner = self.inner.set_pit_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateReplicationConfigurationTemplate`.
    ///
    /// <p>Updates a ReplicationConfigurationTemplate by ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateReplicationConfigurationTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_replication_configuration_template_input::Builder,
    }
    impl<C, M, R> UpdateReplicationConfigurationTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateReplicationConfigurationTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateReplicationConfigurationTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateReplicationConfigurationTemplateError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateReplicationConfigurationTemplateInputOperationOutputAlias,
                crate::output::UpdateReplicationConfigurationTemplateOutput,
                crate::error::UpdateReplicationConfigurationTemplateError,
                crate::input::UpdateReplicationConfigurationTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Replication Configuration Template ID.</p>
        pub fn replication_configuration_template_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .replication_configuration_template_id(input.into());
            self
        }
        /// <p>The Replication Configuration Template ID.</p>
        pub fn set_replication_configuration_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_configuration_template_id(input);
            self
        }
        /// <p>The Replication Configuration Template ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The Replication Configuration Template ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>The subnet to be used by the replication staging area.</p>
        pub fn staging_area_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.staging_area_subnet_id(input.into());
            self
        }
        /// <p>The subnet to be used by the replication staging area.</p>
        pub fn set_staging_area_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_staging_area_subnet_id(input);
            self
        }
        /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>
        pub fn associate_default_security_group(mut self, input: bool) -> Self {
            self.inner = self.inner.associate_default_security_group(input);
            self
        }
        /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>
        pub fn set_associate_default_security_group(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_associate_default_security_group(input);
            self
        }
        /// Appends an item to `replicationServersSecurityGroupsIDs`.
        ///
        /// To override the contents of this collection use [`set_replication_servers_security_groups_i_ds`](Self::set_replication_servers_security_groups_i_ds).
        ///
        /// <p>The security group IDs that will be used by the replication server.</p>
        pub fn replication_servers_security_groups_i_ds(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .replication_servers_security_groups_i_ds(input.into());
            self
        }
        /// <p>The security group IDs that will be used by the replication server.</p>
        pub fn set_replication_servers_security_groups_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_replication_servers_security_groups_i_ds(input);
            self
        }
        /// <p>The instance type to be used for the replication server.</p>
        pub fn replication_server_instance_type(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_server_instance_type(input.into());
            self
        }
        /// <p>The instance type to be used for the replication server.</p>
        pub fn set_replication_server_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_server_instance_type(input);
            self
        }
        /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
        pub fn use_dedicated_replication_server(mut self, input: bool) -> Self {
            self.inner = self.inner.use_dedicated_replication_server(input);
            self
        }
        /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
        pub fn set_use_dedicated_replication_server(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_use_dedicated_replication_server(input);
            self
        }
        /// <p>The Staging Disk EBS volume type to be used during replication.</p>
        pub fn default_large_staging_disk_type(
            mut self,
            input: crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
        ) -> Self {
            self.inner = self.inner.default_large_staging_disk_type(input);
            self
        }
        /// <p>The Staging Disk EBS volume type to be used during replication.</p>
        pub fn set_default_large_staging_disk_type(
            mut self,
            input: std::option::Option<
                crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
            >,
        ) -> Self {
            self.inner = self.inner.set_default_large_staging_disk_type(input);
            self
        }
        /// <p>The type of EBS encryption to be used during replication.</p>
        pub fn ebs_encryption(
            mut self,
            input: crate::model::ReplicationConfigurationEbsEncryption,
        ) -> Self {
            self.inner = self.inner.ebs_encryption(input);
            self
        }
        /// <p>The type of EBS encryption to be used during replication.</p>
        pub fn set_ebs_encryption(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        ) -> Self {
            self.inner = self.inner.set_ebs_encryption(input);
            self
        }
        /// <p>The ARN of the EBS encryption key to be used during replication.</p>
        pub fn ebs_encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ebs_encryption_key_arn(input.into());
            self
        }
        /// <p>The ARN of the EBS encryption key to be used during replication.</p>
        pub fn set_ebs_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ebs_encryption_key_arn(input);
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
        pub fn bandwidth_throttling(mut self, input: i64) -> Self {
            self.inner = self.inner.bandwidth_throttling(input);
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
        pub fn set_bandwidth_throttling(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_bandwidth_throttling(input);
            self
        }
        /// <p>The data plane routing mechanism that will be used for replication.</p>
        pub fn data_plane_routing(
            mut self,
            input: crate::model::ReplicationConfigurationDataPlaneRouting,
        ) -> Self {
            self.inner = self.inner.data_plane_routing(input);
            self
        }
        /// <p>The data plane routing mechanism that will be used for replication.</p>
        pub fn set_data_plane_routing(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        ) -> Self {
            self.inner = self.inner.set_data_plane_routing(input);
            self
        }
        /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
        pub fn create_public_ip(mut self, input: bool) -> Self {
            self.inner = self.inner.create_public_ip(input);
            self
        }
        /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
        pub fn set_create_public_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_create_public_ip(input);
            self
        }
        /// Adds a key-value pair to `stagingAreaTags`.
        ///
        /// To override the contents of this collection use [`set_staging_area_tags`](Self::set_staging_area_tags).
        ///
        /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
        pub fn staging_area_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.staging_area_tags(k.into(), v.into());
            self
        }
        /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
        pub fn set_staging_area_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_staging_area_tags(input);
            self
        }
        /// Appends an item to `pitPolicy`.
        ///
        /// To override the contents of this collection use [`set_pit_policy`](Self::set_pit_policy).
        ///
        /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
        pub fn pit_policy(mut self, input: crate::model::PitPolicyRule) -> Self {
            self.inner = self.inner.pit_policy(input);
            self
        }
        /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
        pub fn set_pit_policy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PitPolicyRule>>,
        ) -> Self {
            self.inner = self.inner.set_pit_policy(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
