// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateReplicationConfigurationTemplateInput`](crate::input::CreateReplicationConfigurationTemplateInput)
pub mod create_replication_configuration_template_input {
    /// A builder for [`CreateReplicationConfigurationTemplateInput`](crate::input::CreateReplicationConfigurationTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) staging_area_subnet_id: std::option::Option<std::string::String>,
        pub(crate) associate_default_security_group: std::option::Option<bool>,
        pub(crate) replication_servers_security_groups_i_ds:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) replication_server_instance_type: std::option::Option<std::string::String>,
        pub(crate) use_dedicated_replication_server: std::option::Option<bool>,
        pub(crate) default_large_staging_disk_type:
            std::option::Option<crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>,
        pub(crate) ebs_encryption:
            std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        pub(crate) ebs_encryption_key_arn: std::option::Option<std::string::String>,
        pub(crate) bandwidth_throttling: std::option::Option<i64>,
        pub(crate) data_plane_routing:
            std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        pub(crate) create_public_ip: std::option::Option<bool>,
        pub(crate) staging_area_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) pit_policy: std::option::Option<std::vec::Vec<crate::model::PitPolicyRule>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The subnet to be used by the replication staging area.</p>
        pub fn staging_area_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.staging_area_subnet_id = Some(input.into());
            self
        }
        /// <p>The subnet to be used by the replication staging area.</p>
        pub fn set_staging_area_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.staging_area_subnet_id = input;
            self
        }
        /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>
        pub fn associate_default_security_group(mut self, input: bool) -> Self {
            self.associate_default_security_group = Some(input);
            self
        }
        /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>
        pub fn set_associate_default_security_group(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.associate_default_security_group = input;
            self
        }
        /// Appends an item to `replication_servers_security_groups_i_ds`.
        ///
        /// To override the contents of this collection use [`set_replication_servers_security_groups_i_ds`](Self::set_replication_servers_security_groups_i_ds).
        ///
        /// <p>The security group IDs that will be used by the replication server.</p>
        pub fn replication_servers_security_groups_i_ds(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self
                .replication_servers_security_groups_i_ds
                .unwrap_or_default();
            v.push(input.into());
            self.replication_servers_security_groups_i_ds = Some(v);
            self
        }
        /// <p>The security group IDs that will be used by the replication server.</p>
        pub fn set_replication_servers_security_groups_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.replication_servers_security_groups_i_ds = input;
            self
        }
        /// <p>The instance type to be used for the replication server.</p>
        pub fn replication_server_instance_type(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_server_instance_type = Some(input.into());
            self
        }
        /// <p>The instance type to be used for the replication server.</p>
        pub fn set_replication_server_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_server_instance_type = input;
            self
        }
        /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
        pub fn use_dedicated_replication_server(mut self, input: bool) -> Self {
            self.use_dedicated_replication_server = Some(input);
            self
        }
        /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
        pub fn set_use_dedicated_replication_server(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.use_dedicated_replication_server = input;
            self
        }
        /// <p>The Staging Disk EBS volume type to be used during replication.</p>
        pub fn default_large_staging_disk_type(
            mut self,
            input: crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
        ) -> Self {
            self.default_large_staging_disk_type = Some(input);
            self
        }
        /// <p>The Staging Disk EBS volume type to be used during replication.</p>
        pub fn set_default_large_staging_disk_type(
            mut self,
            input: std::option::Option<
                crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
            >,
        ) -> Self {
            self.default_large_staging_disk_type = input;
            self
        }
        /// <p>The type of EBS encryption to be used during replication.</p>
        pub fn ebs_encryption(
            mut self,
            input: crate::model::ReplicationConfigurationEbsEncryption,
        ) -> Self {
            self.ebs_encryption = Some(input);
            self
        }
        /// <p>The type of EBS encryption to be used during replication.</p>
        pub fn set_ebs_encryption(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        ) -> Self {
            self.ebs_encryption = input;
            self
        }
        /// <p>The ARN of the EBS encryption key to be used during replication.</p>
        pub fn ebs_encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ebs_encryption_key_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the EBS encryption key to be used during replication.</p>
        pub fn set_ebs_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ebs_encryption_key_arn = input;
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
        pub fn bandwidth_throttling(mut self, input: i64) -> Self {
            self.bandwidth_throttling = Some(input);
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
        pub fn set_bandwidth_throttling(mut self, input: std::option::Option<i64>) -> Self {
            self.bandwidth_throttling = input;
            self
        }
        /// <p>The data plane routing mechanism that will be used for replication.</p>
        pub fn data_plane_routing(
            mut self,
            input: crate::model::ReplicationConfigurationDataPlaneRouting,
        ) -> Self {
            self.data_plane_routing = Some(input);
            self
        }
        /// <p>The data plane routing mechanism that will be used for replication.</p>
        pub fn set_data_plane_routing(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        ) -> Self {
            self.data_plane_routing = input;
            self
        }
        /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
        pub fn create_public_ip(mut self, input: bool) -> Self {
            self.create_public_ip = Some(input);
            self
        }
        /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
        pub fn set_create_public_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.create_public_ip = input;
            self
        }
        /// Adds a key-value pair to `staging_area_tags`.
        ///
        /// To override the contents of this collection use [`set_staging_area_tags`](Self::set_staging_area_tags).
        ///
        /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
        pub fn staging_area_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.staging_area_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.staging_area_tags = Some(hash_map);
            self
        }
        /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
        pub fn set_staging_area_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.staging_area_tags = input;
            self
        }
        /// Appends an item to `pit_policy`.
        ///
        /// To override the contents of this collection use [`set_pit_policy`](Self::set_pit_policy).
        ///
        /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
        pub fn pit_policy(mut self, input: crate::model::PitPolicyRule) -> Self {
            let mut v = self.pit_policy.unwrap_or_default();
            v.push(input);
            self.pit_policy = Some(v);
            self
        }
        /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
        pub fn set_pit_policy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PitPolicyRule>>,
        ) -> Self {
            self.pit_policy = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A set of tags to be associated with the Replication Configuration Template resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A set of tags to be associated with the Replication Configuration Template resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateReplicationConfigurationTemplateInput`](crate::input::CreateReplicationConfigurationTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateReplicationConfigurationTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateReplicationConfigurationTemplateInput {
                staging_area_subnet_id: self.staging_area_subnet_id,
                associate_default_security_group: self.associate_default_security_group,
                replication_servers_security_groups_i_ds: self
                    .replication_servers_security_groups_i_ds,
                replication_server_instance_type: self.replication_server_instance_type,
                use_dedicated_replication_server: self.use_dedicated_replication_server,
                default_large_staging_disk_type: self.default_large_staging_disk_type,
                ebs_encryption: self.ebs_encryption,
                ebs_encryption_key_arn: self.ebs_encryption_key_arn,
                bandwidth_throttling: self.bandwidth_throttling.unwrap_or_default(),
                data_plane_routing: self.data_plane_routing,
                create_public_ip: self.create_public_ip,
                staging_area_tags: self.staging_area_tags,
                pit_policy: self.pit_policy,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateReplicationConfigurationTemplateInputOperationOutputAlias =
    crate::operation::CreateReplicationConfigurationTemplate;
#[doc(hidden)]
pub type CreateReplicationConfigurationTemplateInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateReplicationConfigurationTemplateInput {
    /// Consumes the builder and constructs an Operation<[`CreateReplicationConfigurationTemplate`](crate::operation::CreateReplicationConfigurationTemplate)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateReplicationConfigurationTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateReplicationConfigurationTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/CreateReplicationConfigurationTemplate")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateReplicationConfigurationTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateReplicationConfigurationTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_replication_configuration_template(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateReplicationConfigurationTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateReplicationConfigurationTemplate",
            "drs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateReplicationConfigurationTemplateInput`](crate::input::CreateReplicationConfigurationTemplateInput)
    pub fn builder() -> crate::input::create_replication_configuration_template_input::Builder {
        crate::input::create_replication_configuration_template_input::Builder::default()
    }
}

/// See [`DeleteJobInput`](crate::input::DeleteJobInput)
pub mod delete_job_input {
    /// A builder for [`DeleteJobInput`](crate::input::DeleteJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Job to be deleted.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID of the Job to be deleted.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteJobInput`](crate::input::DeleteJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::DeleteJobInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::DeleteJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteJobInputOperationOutputAlias = crate::operation::DeleteJob;
#[doc(hidden)]
pub type DeleteJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteJobInput {
    /// Consumes the builder and constructs an Operation<[`DeleteJob`](crate::operation::DeleteJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/DeleteJob").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_job(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::DeleteJob::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "DeleteJob",
                    "drs",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteJobInput`](crate::input::DeleteJobInput)
    pub fn builder() -> crate::input::delete_job_input::Builder {
        crate::input::delete_job_input::Builder::default()
    }
}

/// See [`DeleteRecoveryInstanceInput`](crate::input::DeleteRecoveryInstanceInput)
pub mod delete_recovery_instance_input {
    /// A builder for [`DeleteRecoveryInstanceInput`](crate::input::DeleteRecoveryInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recovery_instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>RThe ID of the Recovery Instance to be deleted.</p>
        pub fn recovery_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_instance_id = Some(input.into());
            self
        }
        /// <p>RThe ID of the Recovery Instance to be deleted.</p>
        pub fn set_recovery_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRecoveryInstanceInput`](crate::input::DeleteRecoveryInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRecoveryInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRecoveryInstanceInput {
                recovery_instance_id: self.recovery_instance_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRecoveryInstanceInputOperationOutputAlias = crate::operation::DeleteRecoveryInstance;
#[doc(hidden)]
pub type DeleteRecoveryInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteRecoveryInstanceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRecoveryInstance`](crate::operation::DeleteRecoveryInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRecoveryInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteRecoveryInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/DeleteRecoveryInstance").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteRecoveryInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteRecoveryInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_recovery_instance(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRecoveryInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRecoveryInstance",
            "drs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteRecoveryInstanceInput`](crate::input::DeleteRecoveryInstanceInput)
    pub fn builder() -> crate::input::delete_recovery_instance_input::Builder {
        crate::input::delete_recovery_instance_input::Builder::default()
    }
}

/// See [`DeleteReplicationConfigurationTemplateInput`](crate::input::DeleteReplicationConfigurationTemplateInput)
pub mod delete_replication_configuration_template_input {
    /// A builder for [`DeleteReplicationConfigurationTemplateInput`](crate::input::DeleteReplicationConfigurationTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_configuration_template_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Replication Configuration Template to be deleted.</p>
        pub fn replication_configuration_template_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_configuration_template_id = Some(input.into());
            self
        }
        /// <p>The ID of the Replication Configuration Template to be deleted.</p>
        pub fn set_replication_configuration_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_configuration_template_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteReplicationConfigurationTemplateInput`](crate::input::DeleteReplicationConfigurationTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteReplicationConfigurationTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteReplicationConfigurationTemplateInput {
                replication_configuration_template_id: self.replication_configuration_template_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteReplicationConfigurationTemplateInputOperationOutputAlias =
    crate::operation::DeleteReplicationConfigurationTemplate;
#[doc(hidden)]
pub type DeleteReplicationConfigurationTemplateInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteReplicationConfigurationTemplateInput {
    /// Consumes the builder and constructs an Operation<[`DeleteReplicationConfigurationTemplate`](crate::operation::DeleteReplicationConfigurationTemplate)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteReplicationConfigurationTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteReplicationConfigurationTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/DeleteReplicationConfigurationTemplate")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteReplicationConfigurationTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteReplicationConfigurationTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_replication_configuration_template(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteReplicationConfigurationTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteReplicationConfigurationTemplate",
            "drs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteReplicationConfigurationTemplateInput`](crate::input::DeleteReplicationConfigurationTemplateInput)
    pub fn builder() -> crate::input::delete_replication_configuration_template_input::Builder {
        crate::input::delete_replication_configuration_template_input::Builder::default()
    }
}

/// See [`DeleteSourceServerInput`](crate::input::DeleteSourceServerInput)
pub mod delete_source_server_input {
    /// A builder for [`DeleteSourceServerInput`](crate::input::DeleteSourceServerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Source Server to be deleted.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>The ID of the Source Server to be deleted.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSourceServerInput`](crate::input::DeleteSourceServerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSourceServerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSourceServerInput {
                source_server_id: self.source_server_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSourceServerInputOperationOutputAlias = crate::operation::DeleteSourceServer;
#[doc(hidden)]
pub type DeleteSourceServerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteSourceServerInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSourceServer`](crate::operation::DeleteSourceServer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSourceServer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSourceServerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/DeleteSourceServer").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSourceServerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSourceServerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_source_server(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSourceServer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSourceServer",
            "drs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSourceServerInput`](crate::input::DeleteSourceServerInput)
    pub fn builder() -> crate::input::delete_source_server_input::Builder {
        crate::input::delete_source_server_input::Builder::default()
    }
}

/// See [`DescribeJobLogItemsInput`](crate::input::DescribeJobLogItemsInput)
pub mod describe_job_log_items_input {
    /// A builder for [`DescribeJobLogItemsInput`](crate::input::DescribeJobLogItemsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Job for which Job log items will be retrieved.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID of the Job for which Job log items will be retrieved.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>Maximum number of Job log items to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of Job log items to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token of the next Job log items to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token of the next Job log items to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeJobLogItemsInput`](crate::input::DescribeJobLogItemsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeJobLogItemsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeJobLogItemsInput {
                job_id: self.job_id,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeJobLogItemsInputOperationOutputAlias = crate::operation::DescribeJobLogItems;
#[doc(hidden)]
pub type DescribeJobLogItemsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeJobLogItemsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeJobLogItems`](crate::operation::DescribeJobLogItems)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeJobLogItems,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeJobLogItemsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/DescribeJobLogItems").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeJobLogItemsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeJobLogItemsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_job_log_items(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeJobLogItems::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeJobLogItems",
            "drs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeJobLogItemsInput`](crate::input::DescribeJobLogItemsInput)
    pub fn builder() -> crate::input::describe_job_log_items_input::Builder {
        crate::input::describe_job_log_items_input::Builder::default()
    }
}

/// See [`DescribeJobsInput`](crate::input::DescribeJobsInput)
pub mod describe_jobs_input {
    /// A builder for [`DescribeJobsInput`](crate::input::DescribeJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<crate::model::DescribeJobsRequestFilters>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A set of filters by which to return Jobs.</p>
        pub fn filters(mut self, input: crate::model::DescribeJobsRequestFilters) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p>A set of filters by which to return Jobs.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::DescribeJobsRequestFilters>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>Maximum number of Jobs to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of Jobs to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token of the next Job to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token of the next Job to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeJobsInput`](crate::input::DescribeJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeJobsInput {
                filters: self.filters,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeJobsInputOperationOutputAlias = crate::operation::DescribeJobs;
#[doc(hidden)]
pub type DescribeJobsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeJobsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeJobs`](crate::operation::DescribeJobs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeJobs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/DescribeJobs").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_jobs(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeJobs",
            "drs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeJobsInput`](crate::input::DescribeJobsInput)
    pub fn builder() -> crate::input::describe_jobs_input::Builder {
        crate::input::describe_jobs_input::Builder::default()
    }
}

/// See [`DescribeRecoveryInstancesInput`](crate::input::DescribeRecoveryInstancesInput)
pub mod describe_recovery_instances_input {
    /// A builder for [`DescribeRecoveryInstancesInput`](crate::input::DescribeRecoveryInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters:
            std::option::Option<crate::model::DescribeRecoveryInstancesRequestFilters>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A set of filters by which to return Recovery Instances.</p>
        pub fn filters(
            mut self,
            input: crate::model::DescribeRecoveryInstancesRequestFilters,
        ) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p>A set of filters by which to return Recovery Instances.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::DescribeRecoveryInstancesRequestFilters>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>Maximum number of Recovery Instances to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of Recovery Instances to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token of the next Recovery Instance to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token of the next Recovery Instance to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRecoveryInstancesInput`](crate::input::DescribeRecoveryInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRecoveryInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRecoveryInstancesInput {
                filters: self.filters,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRecoveryInstancesInputOperationOutputAlias =
    crate::operation::DescribeRecoveryInstances;
#[doc(hidden)]
pub type DescribeRecoveryInstancesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeRecoveryInstancesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRecoveryInstances`](crate::operation::DescribeRecoveryInstances)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRecoveryInstances,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeRecoveryInstancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/DescribeRecoveryInstances").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeRecoveryInstancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeRecoveryInstancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_recovery_instances(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRecoveryInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRecoveryInstances",
            "drs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeRecoveryInstancesInput`](crate::input::DescribeRecoveryInstancesInput)
    pub fn builder() -> crate::input::describe_recovery_instances_input::Builder {
        crate::input::describe_recovery_instances_input::Builder::default()
    }
}

/// See [`DescribeRecoverySnapshotsInput`](crate::input::DescribeRecoverySnapshotsInput)
pub mod describe_recovery_snapshots_input {
    /// A builder for [`DescribeRecoverySnapshotsInput`](crate::input::DescribeRecoverySnapshotsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
        pub(crate) filters:
            std::option::Option<crate::model::DescribeRecoverySnapshotsRequestFilters>,
        pub(crate) order: std::option::Option<crate::model::RecoverySnapshotsOrder>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Filter Recovery Snapshots by Source Server ID.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>Filter Recovery Snapshots by Source Server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// <p>A set of filters by which to return Recovery Snapshots.</p>
        pub fn filters(
            mut self,
            input: crate::model::DescribeRecoverySnapshotsRequestFilters,
        ) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p>A set of filters by which to return Recovery Snapshots.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::DescribeRecoverySnapshotsRequestFilters>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The sorted ordering by which to return Recovery Snapshots.</p>
        pub fn order(mut self, input: crate::model::RecoverySnapshotsOrder) -> Self {
            self.order = Some(input);
            self
        }
        /// <p>The sorted ordering by which to return Recovery Snapshots.</p>
        pub fn set_order(
            mut self,
            input: std::option::Option<crate::model::RecoverySnapshotsOrder>,
        ) -> Self {
            self.order = input;
            self
        }
        /// <p>Maximum number of Recovery Snapshots to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of Recovery Snapshots to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token of the next Recovery Snapshot to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token of the next Recovery Snapshot to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRecoverySnapshotsInput`](crate::input::DescribeRecoverySnapshotsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRecoverySnapshotsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRecoverySnapshotsInput {
                source_server_id: self.source_server_id,
                filters: self.filters,
                order: self.order,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRecoverySnapshotsInputOperationOutputAlias =
    crate::operation::DescribeRecoverySnapshots;
#[doc(hidden)]
pub type DescribeRecoverySnapshotsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeRecoverySnapshotsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRecoverySnapshots`](crate::operation::DescribeRecoverySnapshots)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRecoverySnapshots,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeRecoverySnapshotsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/DescribeRecoverySnapshots").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeRecoverySnapshotsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeRecoverySnapshotsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_recovery_snapshots(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRecoverySnapshots::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRecoverySnapshots",
            "drs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeRecoverySnapshotsInput`](crate::input::DescribeRecoverySnapshotsInput)
    pub fn builder() -> crate::input::describe_recovery_snapshots_input::Builder {
        crate::input::describe_recovery_snapshots_input::Builder::default()
    }
}

/// See [`DescribeReplicationConfigurationTemplatesInput`](crate::input::DescribeReplicationConfigurationTemplatesInput)
pub mod describe_replication_configuration_templates_input {
    /// A builder for [`DescribeReplicationConfigurationTemplatesInput`](crate::input::DescribeReplicationConfigurationTemplatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_configuration_template_i_ds:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `replication_configuration_template_i_ds`.
        ///
        /// To override the contents of this collection use [`set_replication_configuration_template_i_ds`](Self::set_replication_configuration_template_i_ds).
        ///
        /// <p>The IDs of the Replication Configuration Templates to retrieve. An empty list means all Replication Configuration Templates.</p>
        pub fn replication_configuration_template_i_ds(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self
                .replication_configuration_template_i_ds
                .unwrap_or_default();
            v.push(input.into());
            self.replication_configuration_template_i_ds = Some(v);
            self
        }
        /// <p>The IDs of the Replication Configuration Templates to retrieve. An empty list means all Replication Configuration Templates.</p>
        pub fn set_replication_configuration_template_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.replication_configuration_template_i_ds = input;
            self
        }
        /// <p>Maximum number of Replication Configuration Templates to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of Replication Configuration Templates to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token of the next Replication Configuration Template to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token of the next Replication Configuration Template to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReplicationConfigurationTemplatesInput`](crate::input::DescribeReplicationConfigurationTemplatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeReplicationConfigurationTemplatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DescribeReplicationConfigurationTemplatesInput {
                    replication_configuration_template_i_ds: self
                        .replication_configuration_template_i_ds,
                    max_results: self.max_results.unwrap_or_default(),
                    next_token: self.next_token,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DescribeReplicationConfigurationTemplatesInputOperationOutputAlias =
    crate::operation::DescribeReplicationConfigurationTemplates;
#[doc(hidden)]
pub type DescribeReplicationConfigurationTemplatesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeReplicationConfigurationTemplatesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeReplicationConfigurationTemplates`](crate::operation::DescribeReplicationConfigurationTemplates)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeReplicationConfigurationTemplates,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeReplicationConfigurationTemplatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/DescribeReplicationConfigurationTemplates")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeReplicationConfigurationTemplatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeReplicationConfigurationTemplatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_replication_configuration_templates(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeReplicationConfigurationTemplates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeReplicationConfigurationTemplates",
            "drs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeReplicationConfigurationTemplatesInput`](crate::input::DescribeReplicationConfigurationTemplatesInput)
    pub fn builder() -> crate::input::describe_replication_configuration_templates_input::Builder {
        crate::input::describe_replication_configuration_templates_input::Builder::default()
    }
}

/// See [`DescribeSourceServersInput`](crate::input::DescribeSourceServersInput)
pub mod describe_source_servers_input {
    /// A builder for [`DescribeSourceServersInput`](crate::input::DescribeSourceServersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<crate::model::DescribeSourceServersRequestFilters>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A set of filters by which to return Source Servers.</p>
        pub fn filters(mut self, input: crate::model::DescribeSourceServersRequestFilters) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p>A set of filters by which to return Source Servers.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::DescribeSourceServersRequestFilters>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>Maximum number of Source Servers to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of Source Servers to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token of the next Source Server to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token of the next Source Server to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSourceServersInput`](crate::input::DescribeSourceServersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSourceServersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSourceServersInput {
                filters: self.filters,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSourceServersInputOperationOutputAlias = crate::operation::DescribeSourceServers;
#[doc(hidden)]
pub type DescribeSourceServersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeSourceServersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSourceServers`](crate::operation::DescribeSourceServers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSourceServers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSourceServersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/DescribeSourceServers").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSourceServersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSourceServersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_source_servers(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSourceServers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSourceServers",
            "drs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSourceServersInput`](crate::input::DescribeSourceServersInput)
    pub fn builder() -> crate::input::describe_source_servers_input::Builder {
        crate::input::describe_source_servers_input::Builder::default()
    }
}

/// See [`DisconnectRecoveryInstanceInput`](crate::input::DisconnectRecoveryInstanceInput)
pub mod disconnect_recovery_instance_input {
    /// A builder for [`DisconnectRecoveryInstanceInput`](crate::input::DisconnectRecoveryInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recovery_instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Recovery Instance to disconnect.</p>
        pub fn recovery_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the Recovery Instance to disconnect.</p>
        pub fn set_recovery_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisconnectRecoveryInstanceInput`](crate::input::DisconnectRecoveryInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisconnectRecoveryInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisconnectRecoveryInstanceInput {
                recovery_instance_id: self.recovery_instance_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DisconnectRecoveryInstanceInputOperationOutputAlias =
    crate::operation::DisconnectRecoveryInstance;
#[doc(hidden)]
pub type DisconnectRecoveryInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisconnectRecoveryInstanceInput {
    /// Consumes the builder and constructs an Operation<[`DisconnectRecoveryInstance`](crate::operation::DisconnectRecoveryInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisconnectRecoveryInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisconnectRecoveryInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/DisconnectRecoveryInstance").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisconnectRecoveryInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisconnectRecoveryInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disconnect_recovery_instance(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisconnectRecoveryInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisconnectRecoveryInstance",
            "drs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisconnectRecoveryInstanceInput`](crate::input::DisconnectRecoveryInstanceInput)
    pub fn builder() -> crate::input::disconnect_recovery_instance_input::Builder {
        crate::input::disconnect_recovery_instance_input::Builder::default()
    }
}

/// See [`DisconnectSourceServerInput`](crate::input::DisconnectSourceServerInput)
pub mod disconnect_source_server_input {
    /// A builder for [`DisconnectSourceServerInput`](crate::input::DisconnectSourceServerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Source Server to disconnect.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>The ID of the Source Server to disconnect.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisconnectSourceServerInput`](crate::input::DisconnectSourceServerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisconnectSourceServerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisconnectSourceServerInput {
                source_server_id: self.source_server_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DisconnectSourceServerInputOperationOutputAlias = crate::operation::DisconnectSourceServer;
#[doc(hidden)]
pub type DisconnectSourceServerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisconnectSourceServerInput {
    /// Consumes the builder and constructs an Operation<[`DisconnectSourceServer`](crate::operation::DisconnectSourceServer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisconnectSourceServer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisconnectSourceServerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/DisconnectSourceServer").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisconnectSourceServerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisconnectSourceServerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disconnect_source_server(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisconnectSourceServer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisconnectSourceServer",
            "drs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisconnectSourceServerInput`](crate::input::DisconnectSourceServerInput)
    pub fn builder() -> crate::input::disconnect_source_server_input::Builder {
        crate::input::disconnect_source_server_input::Builder::default()
    }
}

/// See [`GetFailbackReplicationConfigurationInput`](crate::input::GetFailbackReplicationConfigurationInput)
pub mod get_failback_replication_configuration_input {
    /// A builder for [`GetFailbackReplicationConfigurationInput`](crate::input::GetFailbackReplicationConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recovery_instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Recovery Instance whose failback replication configuration should be returned.</p>
        pub fn recovery_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the Recovery Instance whose failback replication configuration should be returned.</p>
        pub fn set_recovery_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFailbackReplicationConfigurationInput`](crate::input::GetFailbackReplicationConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFailbackReplicationConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFailbackReplicationConfigurationInput {
                recovery_instance_id: self.recovery_instance_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFailbackReplicationConfigurationInputOperationOutputAlias =
    crate::operation::GetFailbackReplicationConfiguration;
#[doc(hidden)]
pub type GetFailbackReplicationConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetFailbackReplicationConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetFailbackReplicationConfiguration`](crate::operation::GetFailbackReplicationConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFailbackReplicationConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetFailbackReplicationConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/GetFailbackReplicationConfiguration")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetFailbackReplicationConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetFailbackReplicationConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_failback_replication_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFailbackReplicationConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFailbackReplicationConfiguration",
            "drs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetFailbackReplicationConfigurationInput`](crate::input::GetFailbackReplicationConfigurationInput)
    pub fn builder() -> crate::input::get_failback_replication_configuration_input::Builder {
        crate::input::get_failback_replication_configuration_input::Builder::default()
    }
}

/// See [`GetLaunchConfigurationInput`](crate::input::GetLaunchConfigurationInput)
pub mod get_launch_configuration_input {
    /// A builder for [`GetLaunchConfigurationInput`](crate::input::GetLaunchConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Source Server that we want to retrieve a Launch Configuration for.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>The ID of the Source Server that we want to retrieve a Launch Configuration for.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLaunchConfigurationInput`](crate::input::GetLaunchConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetLaunchConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetLaunchConfigurationInput {
                source_server_id: self.source_server_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetLaunchConfigurationInputOperationOutputAlias = crate::operation::GetLaunchConfiguration;
#[doc(hidden)]
pub type GetLaunchConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetLaunchConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetLaunchConfiguration`](crate::operation::GetLaunchConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLaunchConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetLaunchConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/GetLaunchConfiguration").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetLaunchConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetLaunchConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_launch_configuration(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetLaunchConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetLaunchConfiguration",
            "drs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetLaunchConfigurationInput`](crate::input::GetLaunchConfigurationInput)
    pub fn builder() -> crate::input::get_launch_configuration_input::Builder {
        crate::input::get_launch_configuration_input::Builder::default()
    }
}

/// See [`GetReplicationConfigurationInput`](crate::input::GetReplicationConfigurationInput)
pub mod get_replication_configuration_input {
    /// A builder for [`GetReplicationConfigurationInput`](crate::input::GetReplicationConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Source Serve for this Replication Configuration.r</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>The ID of the Source Serve for this Replication Configuration.r</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetReplicationConfigurationInput`](crate::input::GetReplicationConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetReplicationConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetReplicationConfigurationInput {
                source_server_id: self.source_server_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetReplicationConfigurationInputOperationOutputAlias =
    crate::operation::GetReplicationConfiguration;
#[doc(hidden)]
pub type GetReplicationConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetReplicationConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetReplicationConfiguration`](crate::operation::GetReplicationConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetReplicationConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetReplicationConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/GetReplicationConfiguration").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetReplicationConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetReplicationConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_replication_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetReplicationConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetReplicationConfiguration",
            "drs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetReplicationConfigurationInput`](crate::input::GetReplicationConfigurationInput)
    pub fn builder() -> crate::input::get_replication_configuration_input::Builder {
        crate::input::get_replication_configuration_input::Builder::default()
    }
}

/// See [`InitializeServiceInput`](crate::input::InitializeServiceInput)
pub mod initialize_service_input {
    /// A builder for [`InitializeServiceInput`](crate::input::InitializeServiceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`InitializeServiceInput`](crate::input::InitializeServiceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::InitializeServiceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::InitializeServiceInput {})
        }
    }
}
#[doc(hidden)]
pub type InitializeServiceInputOperationOutputAlias = crate::operation::InitializeService;
#[doc(hidden)]
pub type InitializeServiceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl InitializeServiceInput {
    /// Consumes the builder and constructs an Operation<[`InitializeService`](crate::operation::InitializeService)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::InitializeService,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::InitializeServiceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/InitializeService").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::InitializeServiceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::InitializeServiceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::InitializeService::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "InitializeService",
            "drs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`InitializeServiceInput`](crate::input::InitializeServiceInput)
    pub fn builder() -> crate::input::initialize_service_input::Builder {
        crate::input::initialize_service_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the resource whose tags should be returned.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource whose tags should be returned.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.resource_arn;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_1, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "drs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`RetryDataReplicationInput`](crate::input::RetryDataReplicationInput)
pub mod retry_data_replication_input {
    /// A builder for [`RetryDataReplicationInput`](crate::input::RetryDataReplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Source Server whose data replication should be retried.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>The ID of the Source Server whose data replication should be retried.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RetryDataReplicationInput`](crate::input::RetryDataReplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RetryDataReplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RetryDataReplicationInput {
                source_server_id: self.source_server_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RetryDataReplicationInputOperationOutputAlias = crate::operation::RetryDataReplication;
#[doc(hidden)]
pub type RetryDataReplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RetryDataReplicationInput {
    /// Consumes the builder and constructs an Operation<[`RetryDataReplication`](crate::operation::RetryDataReplication)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RetryDataReplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RetryDataReplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/RetryDataReplication").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RetryDataReplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RetryDataReplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_retry_data_replication(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RetryDataReplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RetryDataReplication",
            "drs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RetryDataReplicationInput`](crate::input::RetryDataReplicationInput)
    pub fn builder() -> crate::input::retry_data_replication_input::Builder {
        crate::input::retry_data_replication_input::Builder::default()
    }
}

/// See [`StartFailbackLaunchInput`](crate::input::StartFailbackLaunchInput)
pub mod start_failback_launch_input {
    /// A builder for [`StartFailbackLaunchInput`](crate::input::StartFailbackLaunchInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recovery_instance_i_ds: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Appends an item to `recovery_instance_i_ds`.
        ///
        /// To override the contents of this collection use [`set_recovery_instance_i_ds`](Self::set_recovery_instance_i_ds).
        ///
        /// <p>The IDs of the Recovery Instance whose failback launch we want to request.</p>
        pub fn recovery_instance_i_ds(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.recovery_instance_i_ds.unwrap_or_default();
            v.push(input.into());
            self.recovery_instance_i_ds = Some(v);
            self
        }
        /// <p>The IDs of the Recovery Instance whose failback launch we want to request.</p>
        pub fn set_recovery_instance_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.recovery_instance_i_ds = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be associated with the failback launch Job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to be associated with the failback launch Job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`StartFailbackLaunchInput`](crate::input::StartFailbackLaunchInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartFailbackLaunchInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartFailbackLaunchInput {
                recovery_instance_i_ds: self.recovery_instance_i_ds,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type StartFailbackLaunchInputOperationOutputAlias = crate::operation::StartFailbackLaunch;
#[doc(hidden)]
pub type StartFailbackLaunchInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartFailbackLaunchInput {
    /// Consumes the builder and constructs an Operation<[`StartFailbackLaunch`](crate::operation::StartFailbackLaunch)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartFailbackLaunch,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartFailbackLaunchInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/StartFailbackLaunch").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartFailbackLaunchInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartFailbackLaunchInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_failback_launch(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartFailbackLaunch::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartFailbackLaunch",
            "drs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartFailbackLaunchInput`](crate::input::StartFailbackLaunchInput)
    pub fn builder() -> crate::input::start_failback_launch_input::Builder {
        crate::input::start_failback_launch_input::Builder::default()
    }
}

/// See [`StartRecoveryInput`](crate::input::StartRecoveryInput)
pub mod start_recovery_input {
    /// A builder for [`StartRecoveryInput`](crate::input::StartRecoveryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_servers:
            std::option::Option<std::vec::Vec<crate::model::StartRecoveryRequestSourceServer>>,
        pub(crate) is_drill: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Appends an item to `source_servers`.
        ///
        /// To override the contents of this collection use [`set_source_servers`](Self::set_source_servers).
        ///
        /// <p>The Source Servers that we want to start a Recovery Job for.</p>
        pub fn source_servers(
            mut self,
            input: crate::model::StartRecoveryRequestSourceServer,
        ) -> Self {
            let mut v = self.source_servers.unwrap_or_default();
            v.push(input);
            self.source_servers = Some(v);
            self
        }
        /// <p>The Source Servers that we want to start a Recovery Job for.</p>
        pub fn set_source_servers(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::StartRecoveryRequestSourceServer>,
            >,
        ) -> Self {
            self.source_servers = input;
            self
        }
        /// <p>Whether this Source Server Recovery operation is a drill or not.</p>
        pub fn is_drill(mut self, input: bool) -> Self {
            self.is_drill = Some(input);
            self
        }
        /// <p>Whether this Source Server Recovery operation is a drill or not.</p>
        pub fn set_is_drill(mut self, input: std::option::Option<bool>) -> Self {
            self.is_drill = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be associated with the Recovery Job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to be associated with the Recovery Job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`StartRecoveryInput`](crate::input::StartRecoveryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartRecoveryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartRecoveryInput {
                source_servers: self.source_servers,
                is_drill: self.is_drill,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type StartRecoveryInputOperationOutputAlias = crate::operation::StartRecovery;
#[doc(hidden)]
pub type StartRecoveryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartRecoveryInput {
    /// Consumes the builder and constructs an Operation<[`StartRecovery`](crate::operation::StartRecovery)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartRecovery,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartRecoveryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/StartRecovery").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartRecoveryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartRecoveryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_start_recovery(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartRecovery::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartRecovery",
            "drs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartRecoveryInput`](crate::input::StartRecoveryInput)
    pub fn builder() -> crate::input::start_recovery_input::Builder {
        crate::input::start_recovery_input::Builder::default()
    }
}

/// See [`StopFailbackInput`](crate::input::StopFailbackInput)
pub mod stop_failback_input {
    /// A builder for [`StopFailbackInput`](crate::input::StopFailbackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recovery_instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Recovery Instance we want to stop failback for.</p>
        pub fn recovery_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the Recovery Instance we want to stop failback for.</p>
        pub fn set_recovery_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopFailbackInput`](crate::input::StopFailbackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopFailbackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopFailbackInput {
                recovery_instance_id: self.recovery_instance_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StopFailbackInputOperationOutputAlias = crate::operation::StopFailback;
#[doc(hidden)]
pub type StopFailbackInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopFailbackInput {
    /// Consumes the builder and constructs an Operation<[`StopFailback`](crate::operation::StopFailback)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopFailback,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopFailbackInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/StopFailback").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopFailbackInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopFailbackInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_stop_failback(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopFailback::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopFailback",
            "drs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopFailbackInput`](crate::input::StopFailbackInput)
    pub fn builder() -> crate::input::stop_failback_input::Builder {
        crate::input::stop_failback_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>ARN of the resource for which tags are to be added or updated.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>ARN of the resource for which tags are to be added or updated.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Array of tags to be added or updated.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Array of tags to be added or updated.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.resource_arn;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_2, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "drs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`TerminateRecoveryInstancesInput`](crate::input::TerminateRecoveryInstancesInput)
pub mod terminate_recovery_instances_input {
    /// A builder for [`TerminateRecoveryInstancesInput`](crate::input::TerminateRecoveryInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recovery_instance_i_ds: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `recovery_instance_i_ds`.
        ///
        /// To override the contents of this collection use [`set_recovery_instance_i_ds`](Self::set_recovery_instance_i_ds).
        ///
        /// <p>The IDs of the Recovery Instances that should be terminated.</p>
        pub fn recovery_instance_i_ds(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.recovery_instance_i_ds.unwrap_or_default();
            v.push(input.into());
            self.recovery_instance_i_ds = Some(v);
            self
        }
        /// <p>The IDs of the Recovery Instances that should be terminated.</p>
        pub fn set_recovery_instance_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.recovery_instance_i_ds = input;
            self
        }
        /// Consumes the builder and constructs a [`TerminateRecoveryInstancesInput`](crate::input::TerminateRecoveryInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TerminateRecoveryInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TerminateRecoveryInstancesInput {
                recovery_instance_i_ds: self.recovery_instance_i_ds,
            })
        }
    }
}
#[doc(hidden)]
pub type TerminateRecoveryInstancesInputOperationOutputAlias =
    crate::operation::TerminateRecoveryInstances;
#[doc(hidden)]
pub type TerminateRecoveryInstancesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TerminateRecoveryInstancesInput {
    /// Consumes the builder and constructs an Operation<[`TerminateRecoveryInstances`](crate::operation::TerminateRecoveryInstances)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TerminateRecoveryInstances,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TerminateRecoveryInstancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/TerminateRecoveryInstances").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TerminateRecoveryInstancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TerminateRecoveryInstancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_terminate_recovery_instances(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TerminateRecoveryInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TerminateRecoveryInstances",
            "drs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TerminateRecoveryInstancesInput`](crate::input::TerminateRecoveryInstancesInput)
    pub fn builder() -> crate::input::terminate_recovery_instances_input::Builder {
        crate::input::terminate_recovery_instances_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>ARN of the resource for which tags are to be removed.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>ARN of the resource for which tags are to be removed.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Array of tags to be removed.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>Array of tags to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.resource_arn;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_3, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UntagResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_4) = &_input.tag_keys {
                for inner_5 in inner_4 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_5));
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "drs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateFailbackReplicationConfigurationInput`](crate::input::UpdateFailbackReplicationConfigurationInput)
pub mod update_failback_replication_configuration_input {
    /// A builder for [`UpdateFailbackReplicationConfigurationInput`](crate::input::UpdateFailbackReplicationConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recovery_instance_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) bandwidth_throttling: std::option::Option<i64>,
        pub(crate) use_private_ip: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the Recovery Instance.</p>
        pub fn recovery_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the Recovery Instance.</p>
        pub fn set_recovery_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_instance_id = input;
            self
        }
        /// <p>The name of the Failback Replication Configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Failback Replication Configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Recovery Instance in Mbps.</p>
        pub fn bandwidth_throttling(mut self, input: i64) -> Self {
            self.bandwidth_throttling = Some(input);
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Recovery Instance in Mbps.</p>
        pub fn set_bandwidth_throttling(mut self, input: std::option::Option<i64>) -> Self {
            self.bandwidth_throttling = input;
            self
        }
        /// <p>Whether to use Private IP for the failback replication of the Recovery Instance.</p>
        pub fn use_private_ip(mut self, input: bool) -> Self {
            self.use_private_ip = Some(input);
            self
        }
        /// <p>Whether to use Private IP for the failback replication of the Recovery Instance.</p>
        pub fn set_use_private_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.use_private_ip = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFailbackReplicationConfigurationInput`](crate::input::UpdateFailbackReplicationConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFailbackReplicationConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFailbackReplicationConfigurationInput {
                recovery_instance_id: self.recovery_instance_id,
                name: self.name,
                bandwidth_throttling: self.bandwidth_throttling.unwrap_or_default(),
                use_private_ip: self.use_private_ip,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFailbackReplicationConfigurationInputOperationOutputAlias =
    crate::operation::UpdateFailbackReplicationConfiguration;
#[doc(hidden)]
pub type UpdateFailbackReplicationConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateFailbackReplicationConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFailbackReplicationConfiguration`](crate::operation::UpdateFailbackReplicationConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFailbackReplicationConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateFailbackReplicationConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/UpdateFailbackReplicationConfiguration")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateFailbackReplicationConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateFailbackReplicationConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_failback_replication_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFailbackReplicationConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFailbackReplicationConfiguration",
            "drs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateFailbackReplicationConfigurationInput`](crate::input::UpdateFailbackReplicationConfigurationInput)
    pub fn builder() -> crate::input::update_failback_replication_configuration_input::Builder {
        crate::input::update_failback_replication_configuration_input::Builder::default()
    }
}

/// See [`UpdateLaunchConfigurationInput`](crate::input::UpdateLaunchConfigurationInput)
pub mod update_launch_configuration_input {
    /// A builder for [`UpdateLaunchConfigurationInput`](crate::input::UpdateLaunchConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) launch_disposition: std::option::Option<crate::model::LaunchDisposition>,
        pub(crate) target_instance_type_right_sizing_method:
            std::option::Option<crate::model::TargetInstanceTypeRightSizingMethod>,
        pub(crate) copy_private_ip: std::option::Option<bool>,
        pub(crate) copy_tags: std::option::Option<bool>,
        pub(crate) licensing: std::option::Option<crate::model::Licensing>,
    }
    impl Builder {
        /// <p>The ID of the Source Server that we want to retrieve a Launch Configuration for.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>The ID of the Source Server that we want to retrieve a Launch Configuration for.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// <p>The name of the launch configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the launch configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The state of the Recovery Instance in EC2 after the recovery operation.</p>
        pub fn launch_disposition(mut self, input: crate::model::LaunchDisposition) -> Self {
            self.launch_disposition = Some(input);
            self
        }
        /// <p>The state of the Recovery Instance in EC2 after the recovery operation.</p>
        pub fn set_launch_disposition(
            mut self,
            input: std::option::Option<crate::model::LaunchDisposition>,
        ) -> Self {
            self.launch_disposition = input;
            self
        }
        /// <p>Whether Elastic Disaster Recovery should try to automatically choose the instance type that best matches the OS, CPU, and RAM of your Source Server.</p>
        pub fn target_instance_type_right_sizing_method(
            mut self,
            input: crate::model::TargetInstanceTypeRightSizingMethod,
        ) -> Self {
            self.target_instance_type_right_sizing_method = Some(input);
            self
        }
        /// <p>Whether Elastic Disaster Recovery should try to automatically choose the instance type that best matches the OS, CPU, and RAM of your Source Server.</p>
        pub fn set_target_instance_type_right_sizing_method(
            mut self,
            input: std::option::Option<crate::model::TargetInstanceTypeRightSizingMethod>,
        ) -> Self {
            self.target_instance_type_right_sizing_method = input;
            self
        }
        /// <p>Whether we should copy the Private IP of the Source Server to the Recovery Instance.</p>
        pub fn copy_private_ip(mut self, input: bool) -> Self {
            self.copy_private_ip = Some(input);
            self
        }
        /// <p>Whether we should copy the Private IP of the Source Server to the Recovery Instance.</p>
        pub fn set_copy_private_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_private_ip = input;
            self
        }
        /// <p>Whether we want to copy the tags of the Source Server to the EC2 machine of the Recovery Instance.</p>
        pub fn copy_tags(mut self, input: bool) -> Self {
            self.copy_tags = Some(input);
            self
        }
        /// <p>Whether we want to copy the tags of the Source Server to the EC2 machine of the Recovery Instance.</p>
        pub fn set_copy_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_tags = input;
            self
        }
        /// <p>The licensing configuration to be used for this launch configuration.</p>
        pub fn licensing(mut self, input: crate::model::Licensing) -> Self {
            self.licensing = Some(input);
            self
        }
        /// <p>The licensing configuration to be used for this launch configuration.</p>
        pub fn set_licensing(
            mut self,
            input: std::option::Option<crate::model::Licensing>,
        ) -> Self {
            self.licensing = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateLaunchConfigurationInput`](crate::input::UpdateLaunchConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateLaunchConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateLaunchConfigurationInput {
                source_server_id: self.source_server_id,
                name: self.name,
                launch_disposition: self.launch_disposition,
                target_instance_type_right_sizing_method: self
                    .target_instance_type_right_sizing_method,
                copy_private_ip: self.copy_private_ip,
                copy_tags: self.copy_tags,
                licensing: self.licensing,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateLaunchConfigurationInputOperationOutputAlias =
    crate::operation::UpdateLaunchConfiguration;
#[doc(hidden)]
pub type UpdateLaunchConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateLaunchConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateLaunchConfiguration`](crate::operation::UpdateLaunchConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateLaunchConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateLaunchConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/UpdateLaunchConfiguration").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateLaunchConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateLaunchConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_launch_configuration(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateLaunchConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateLaunchConfiguration",
            "drs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateLaunchConfigurationInput`](crate::input::UpdateLaunchConfigurationInput)
    pub fn builder() -> crate::input::update_launch_configuration_input::Builder {
        crate::input::update_launch_configuration_input::Builder::default()
    }
}

/// See [`UpdateReplicationConfigurationInput`](crate::input::UpdateReplicationConfigurationInput)
pub mod update_replication_configuration_input {
    /// A builder for [`UpdateReplicationConfigurationInput`](crate::input::UpdateReplicationConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) staging_area_subnet_id: std::option::Option<std::string::String>,
        pub(crate) associate_default_security_group: std::option::Option<bool>,
        pub(crate) replication_servers_security_groups_i_ds:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) replication_server_instance_type: std::option::Option<std::string::String>,
        pub(crate) use_dedicated_replication_server: std::option::Option<bool>,
        pub(crate) default_large_staging_disk_type:
            std::option::Option<crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>,
        pub(crate) replicated_disks: std::option::Option<
            std::vec::Vec<crate::model::ReplicationConfigurationReplicatedDisk>,
        >,
        pub(crate) ebs_encryption:
            std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        pub(crate) ebs_encryption_key_arn: std::option::Option<std::string::String>,
        pub(crate) bandwidth_throttling: std::option::Option<i64>,
        pub(crate) data_plane_routing:
            std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        pub(crate) create_public_ip: std::option::Option<bool>,
        pub(crate) staging_area_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) pit_policy: std::option::Option<std::vec::Vec<crate::model::PitPolicyRule>>,
    }
    impl Builder {
        /// <p>The ID of the Source Server for this Replication Configuration.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>The ID of the Source Server for this Replication Configuration.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// <p>The name of the Replication Configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Replication Configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The subnet to be used by the replication staging area.</p>
        pub fn staging_area_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.staging_area_subnet_id = Some(input.into());
            self
        }
        /// <p>The subnet to be used by the replication staging area.</p>
        pub fn set_staging_area_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.staging_area_subnet_id = input;
            self
        }
        /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration.</p>
        pub fn associate_default_security_group(mut self, input: bool) -> Self {
            self.associate_default_security_group = Some(input);
            self
        }
        /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration.</p>
        pub fn set_associate_default_security_group(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.associate_default_security_group = input;
            self
        }
        /// Appends an item to `replication_servers_security_groups_i_ds`.
        ///
        /// To override the contents of this collection use [`set_replication_servers_security_groups_i_ds`](Self::set_replication_servers_security_groups_i_ds).
        ///
        /// <p>The security group IDs that will be used by the replication server.</p>
        pub fn replication_servers_security_groups_i_ds(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self
                .replication_servers_security_groups_i_ds
                .unwrap_or_default();
            v.push(input.into());
            self.replication_servers_security_groups_i_ds = Some(v);
            self
        }
        /// <p>The security group IDs that will be used by the replication server.</p>
        pub fn set_replication_servers_security_groups_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.replication_servers_security_groups_i_ds = input;
            self
        }
        /// <p>The instance type to be used for the replication server.</p>
        pub fn replication_server_instance_type(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_server_instance_type = Some(input.into());
            self
        }
        /// <p>The instance type to be used for the replication server.</p>
        pub fn set_replication_server_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_server_instance_type = input;
            self
        }
        /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
        pub fn use_dedicated_replication_server(mut self, input: bool) -> Self {
            self.use_dedicated_replication_server = Some(input);
            self
        }
        /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
        pub fn set_use_dedicated_replication_server(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.use_dedicated_replication_server = input;
            self
        }
        /// <p>The Staging Disk EBS volume type to be used during replication.</p>
        pub fn default_large_staging_disk_type(
            mut self,
            input: crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
        ) -> Self {
            self.default_large_staging_disk_type = Some(input);
            self
        }
        /// <p>The Staging Disk EBS volume type to be used during replication.</p>
        pub fn set_default_large_staging_disk_type(
            mut self,
            input: std::option::Option<
                crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
            >,
        ) -> Self {
            self.default_large_staging_disk_type = input;
            self
        }
        /// Appends an item to `replicated_disks`.
        ///
        /// To override the contents of this collection use [`set_replicated_disks`](Self::set_replicated_disks).
        ///
        /// <p>The configuration of the disks of the Source Server to be replicated.</p>
        pub fn replicated_disks(
            mut self,
            input: crate::model::ReplicationConfigurationReplicatedDisk,
        ) -> Self {
            let mut v = self.replicated_disks.unwrap_or_default();
            v.push(input);
            self.replicated_disks = Some(v);
            self
        }
        /// <p>The configuration of the disks of the Source Server to be replicated.</p>
        pub fn set_replicated_disks(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ReplicationConfigurationReplicatedDisk>,
            >,
        ) -> Self {
            self.replicated_disks = input;
            self
        }
        /// <p>The type of EBS encryption to be used during replication.</p>
        pub fn ebs_encryption(
            mut self,
            input: crate::model::ReplicationConfigurationEbsEncryption,
        ) -> Self {
            self.ebs_encryption = Some(input);
            self
        }
        /// <p>The type of EBS encryption to be used during replication.</p>
        pub fn set_ebs_encryption(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        ) -> Self {
            self.ebs_encryption = input;
            self
        }
        /// <p>The ARN of the EBS encryption key to be used during replication.</p>
        pub fn ebs_encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ebs_encryption_key_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the EBS encryption key to be used during replication.</p>
        pub fn set_ebs_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ebs_encryption_key_arn = input;
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
        pub fn bandwidth_throttling(mut self, input: i64) -> Self {
            self.bandwidth_throttling = Some(input);
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
        pub fn set_bandwidth_throttling(mut self, input: std::option::Option<i64>) -> Self {
            self.bandwidth_throttling = input;
            self
        }
        /// <p>The data plane routing mechanism that will be used for replication.</p>
        pub fn data_plane_routing(
            mut self,
            input: crate::model::ReplicationConfigurationDataPlaneRouting,
        ) -> Self {
            self.data_plane_routing = Some(input);
            self
        }
        /// <p>The data plane routing mechanism that will be used for replication.</p>
        pub fn set_data_plane_routing(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        ) -> Self {
            self.data_plane_routing = input;
            self
        }
        /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
        pub fn create_public_ip(mut self, input: bool) -> Self {
            self.create_public_ip = Some(input);
            self
        }
        /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
        pub fn set_create_public_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.create_public_ip = input;
            self
        }
        /// Adds a key-value pair to `staging_area_tags`.
        ///
        /// To override the contents of this collection use [`set_staging_area_tags`](Self::set_staging_area_tags).
        ///
        /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
        pub fn staging_area_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.staging_area_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.staging_area_tags = Some(hash_map);
            self
        }
        /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
        pub fn set_staging_area_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.staging_area_tags = input;
            self
        }
        /// Appends an item to `pit_policy`.
        ///
        /// To override the contents of this collection use [`set_pit_policy`](Self::set_pit_policy).
        ///
        /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
        pub fn pit_policy(mut self, input: crate::model::PitPolicyRule) -> Self {
            let mut v = self.pit_policy.unwrap_or_default();
            v.push(input);
            self.pit_policy = Some(v);
            self
        }
        /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
        pub fn set_pit_policy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PitPolicyRule>>,
        ) -> Self {
            self.pit_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateReplicationConfigurationInput`](crate::input::UpdateReplicationConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateReplicationConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateReplicationConfigurationInput {
                source_server_id: self.source_server_id,
                name: self.name,
                staging_area_subnet_id: self.staging_area_subnet_id,
                associate_default_security_group: self.associate_default_security_group,
                replication_servers_security_groups_i_ds: self
                    .replication_servers_security_groups_i_ds,
                replication_server_instance_type: self.replication_server_instance_type,
                use_dedicated_replication_server: self.use_dedicated_replication_server,
                default_large_staging_disk_type: self.default_large_staging_disk_type,
                replicated_disks: self.replicated_disks,
                ebs_encryption: self.ebs_encryption,
                ebs_encryption_key_arn: self.ebs_encryption_key_arn,
                bandwidth_throttling: self.bandwidth_throttling.unwrap_or_default(),
                data_plane_routing: self.data_plane_routing,
                create_public_ip: self.create_public_ip,
                staging_area_tags: self.staging_area_tags,
                pit_policy: self.pit_policy,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateReplicationConfigurationInputOperationOutputAlias =
    crate::operation::UpdateReplicationConfiguration;
#[doc(hidden)]
pub type UpdateReplicationConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateReplicationConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateReplicationConfiguration`](crate::operation::UpdateReplicationConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateReplicationConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateReplicationConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/UpdateReplicationConfiguration").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateReplicationConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateReplicationConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_replication_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateReplicationConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateReplicationConfiguration",
            "drs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateReplicationConfigurationInput`](crate::input::UpdateReplicationConfigurationInput)
    pub fn builder() -> crate::input::update_replication_configuration_input::Builder {
        crate::input::update_replication_configuration_input::Builder::default()
    }
}

/// See [`UpdateReplicationConfigurationTemplateInput`](crate::input::UpdateReplicationConfigurationTemplateInput)
pub mod update_replication_configuration_template_input {
    /// A builder for [`UpdateReplicationConfigurationTemplateInput`](crate::input::UpdateReplicationConfigurationTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_configuration_template_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) staging_area_subnet_id: std::option::Option<std::string::String>,
        pub(crate) associate_default_security_group: std::option::Option<bool>,
        pub(crate) replication_servers_security_groups_i_ds:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) replication_server_instance_type: std::option::Option<std::string::String>,
        pub(crate) use_dedicated_replication_server: std::option::Option<bool>,
        pub(crate) default_large_staging_disk_type:
            std::option::Option<crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>,
        pub(crate) ebs_encryption:
            std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        pub(crate) ebs_encryption_key_arn: std::option::Option<std::string::String>,
        pub(crate) bandwidth_throttling: std::option::Option<i64>,
        pub(crate) data_plane_routing:
            std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        pub(crate) create_public_ip: std::option::Option<bool>,
        pub(crate) staging_area_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) pit_policy: std::option::Option<std::vec::Vec<crate::model::PitPolicyRule>>,
    }
    impl Builder {
        /// <p>The Replication Configuration Template ID.</p>
        pub fn replication_configuration_template_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_configuration_template_id = Some(input.into());
            self
        }
        /// <p>The Replication Configuration Template ID.</p>
        pub fn set_replication_configuration_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_configuration_template_id = input;
            self
        }
        /// <p>The Replication Configuration Template ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Replication Configuration Template ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The subnet to be used by the replication staging area.</p>
        pub fn staging_area_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.staging_area_subnet_id = Some(input.into());
            self
        }
        /// <p>The subnet to be used by the replication staging area.</p>
        pub fn set_staging_area_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.staging_area_subnet_id = input;
            self
        }
        /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>
        pub fn associate_default_security_group(mut self, input: bool) -> Self {
            self.associate_default_security_group = Some(input);
            self
        }
        /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>
        pub fn set_associate_default_security_group(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.associate_default_security_group = input;
            self
        }
        /// Appends an item to `replication_servers_security_groups_i_ds`.
        ///
        /// To override the contents of this collection use [`set_replication_servers_security_groups_i_ds`](Self::set_replication_servers_security_groups_i_ds).
        ///
        /// <p>The security group IDs that will be used by the replication server.</p>
        pub fn replication_servers_security_groups_i_ds(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self
                .replication_servers_security_groups_i_ds
                .unwrap_or_default();
            v.push(input.into());
            self.replication_servers_security_groups_i_ds = Some(v);
            self
        }
        /// <p>The security group IDs that will be used by the replication server.</p>
        pub fn set_replication_servers_security_groups_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.replication_servers_security_groups_i_ds = input;
            self
        }
        /// <p>The instance type to be used for the replication server.</p>
        pub fn replication_server_instance_type(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_server_instance_type = Some(input.into());
            self
        }
        /// <p>The instance type to be used for the replication server.</p>
        pub fn set_replication_server_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_server_instance_type = input;
            self
        }
        /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
        pub fn use_dedicated_replication_server(mut self, input: bool) -> Self {
            self.use_dedicated_replication_server = Some(input);
            self
        }
        /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
        pub fn set_use_dedicated_replication_server(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.use_dedicated_replication_server = input;
            self
        }
        /// <p>The Staging Disk EBS volume type to be used during replication.</p>
        pub fn default_large_staging_disk_type(
            mut self,
            input: crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
        ) -> Self {
            self.default_large_staging_disk_type = Some(input);
            self
        }
        /// <p>The Staging Disk EBS volume type to be used during replication.</p>
        pub fn set_default_large_staging_disk_type(
            mut self,
            input: std::option::Option<
                crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
            >,
        ) -> Self {
            self.default_large_staging_disk_type = input;
            self
        }
        /// <p>The type of EBS encryption to be used during replication.</p>
        pub fn ebs_encryption(
            mut self,
            input: crate::model::ReplicationConfigurationEbsEncryption,
        ) -> Self {
            self.ebs_encryption = Some(input);
            self
        }
        /// <p>The type of EBS encryption to be used during replication.</p>
        pub fn set_ebs_encryption(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        ) -> Self {
            self.ebs_encryption = input;
            self
        }
        /// <p>The ARN of the EBS encryption key to be used during replication.</p>
        pub fn ebs_encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ebs_encryption_key_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the EBS encryption key to be used during replication.</p>
        pub fn set_ebs_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ebs_encryption_key_arn = input;
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
        pub fn bandwidth_throttling(mut self, input: i64) -> Self {
            self.bandwidth_throttling = Some(input);
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
        pub fn set_bandwidth_throttling(mut self, input: std::option::Option<i64>) -> Self {
            self.bandwidth_throttling = input;
            self
        }
        /// <p>The data plane routing mechanism that will be used for replication.</p>
        pub fn data_plane_routing(
            mut self,
            input: crate::model::ReplicationConfigurationDataPlaneRouting,
        ) -> Self {
            self.data_plane_routing = Some(input);
            self
        }
        /// <p>The data plane routing mechanism that will be used for replication.</p>
        pub fn set_data_plane_routing(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        ) -> Self {
            self.data_plane_routing = input;
            self
        }
        /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
        pub fn create_public_ip(mut self, input: bool) -> Self {
            self.create_public_ip = Some(input);
            self
        }
        /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
        pub fn set_create_public_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.create_public_ip = input;
            self
        }
        /// Adds a key-value pair to `staging_area_tags`.
        ///
        /// To override the contents of this collection use [`set_staging_area_tags`](Self::set_staging_area_tags).
        ///
        /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
        pub fn staging_area_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.staging_area_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.staging_area_tags = Some(hash_map);
            self
        }
        /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
        pub fn set_staging_area_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.staging_area_tags = input;
            self
        }
        /// Appends an item to `pit_policy`.
        ///
        /// To override the contents of this collection use [`set_pit_policy`](Self::set_pit_policy).
        ///
        /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
        pub fn pit_policy(mut self, input: crate::model::PitPolicyRule) -> Self {
            let mut v = self.pit_policy.unwrap_or_default();
            v.push(input);
            self.pit_policy = Some(v);
            self
        }
        /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
        pub fn set_pit_policy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PitPolicyRule>>,
        ) -> Self {
            self.pit_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateReplicationConfigurationTemplateInput`](crate::input::UpdateReplicationConfigurationTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateReplicationConfigurationTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateReplicationConfigurationTemplateInput {
                replication_configuration_template_id: self.replication_configuration_template_id,
                arn: self.arn,
                staging_area_subnet_id: self.staging_area_subnet_id,
                associate_default_security_group: self.associate_default_security_group,
                replication_servers_security_groups_i_ds: self
                    .replication_servers_security_groups_i_ds,
                replication_server_instance_type: self.replication_server_instance_type,
                use_dedicated_replication_server: self.use_dedicated_replication_server,
                default_large_staging_disk_type: self.default_large_staging_disk_type,
                ebs_encryption: self.ebs_encryption,
                ebs_encryption_key_arn: self.ebs_encryption_key_arn,
                bandwidth_throttling: self.bandwidth_throttling.unwrap_or_default(),
                data_plane_routing: self.data_plane_routing,
                create_public_ip: self.create_public_ip,
                staging_area_tags: self.staging_area_tags,
                pit_policy: self.pit_policy,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateReplicationConfigurationTemplateInputOperationOutputAlias =
    crate::operation::UpdateReplicationConfigurationTemplate;
#[doc(hidden)]
pub type UpdateReplicationConfigurationTemplateInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateReplicationConfigurationTemplateInput {
    /// Consumes the builder and constructs an Operation<[`UpdateReplicationConfigurationTemplate`](crate::operation::UpdateReplicationConfigurationTemplate)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateReplicationConfigurationTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateReplicationConfigurationTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/UpdateReplicationConfigurationTemplate")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateReplicationConfigurationTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateReplicationConfigurationTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_replication_configuration_template(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateReplicationConfigurationTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateReplicationConfigurationTemplate",
            "drs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateReplicationConfigurationTemplateInput`](crate::input::UpdateReplicationConfigurationTemplateInput)
    pub fn builder() -> crate::input::update_replication_configuration_template_input::Builder {
        crate::input::update_replication_configuration_template_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateReplicationConfigurationInput {
    /// <p>The ID of the Source Server for this Replication Configuration.</p>
    pub source_server_id: std::option::Option<std::string::String>,
    /// <p>The name of the Replication Configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The subnet to be used by the replication staging area.</p>
    pub staging_area_subnet_id: std::option::Option<std::string::String>,
    /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration.</p>
    pub associate_default_security_group: std::option::Option<bool>,
    /// <p>The security group IDs that will be used by the replication server.</p>
    pub replication_servers_security_groups_i_ds:
        std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The instance type to be used for the replication server.</p>
    pub replication_server_instance_type: std::option::Option<std::string::String>,
    /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
    pub use_dedicated_replication_server: std::option::Option<bool>,
    /// <p>The Staging Disk EBS volume type to be used during replication.</p>
    pub default_large_staging_disk_type:
        std::option::Option<crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>,
    /// <p>The configuration of the disks of the Source Server to be replicated.</p>
    pub replicated_disks:
        std::option::Option<std::vec::Vec<crate::model::ReplicationConfigurationReplicatedDisk>>,
    /// <p>The type of EBS encryption to be used during replication.</p>
    pub ebs_encryption: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
    /// <p>The ARN of the EBS encryption key to be used during replication.</p>
    pub ebs_encryption_key_arn: std::option::Option<std::string::String>,
    /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
    pub bandwidth_throttling: i64,
    /// <p>The data plane routing mechanism that will be used for replication.</p>
    pub data_plane_routing:
        std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
    /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
    pub create_public_ip: std::option::Option<bool>,
    /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
    pub staging_area_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
    pub pit_policy: std::option::Option<std::vec::Vec<crate::model::PitPolicyRule>>,
}
impl UpdateReplicationConfigurationInput {
    /// <p>The ID of the Source Server for this Replication Configuration.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
    /// <p>The name of the Replication Configuration.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The subnet to be used by the replication staging area.</p>
    pub fn staging_area_subnet_id(&self) -> std::option::Option<&str> {
        self.staging_area_subnet_id.as_deref()
    }
    /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration.</p>
    pub fn associate_default_security_group(&self) -> std::option::Option<bool> {
        self.associate_default_security_group
    }
    /// <p>The security group IDs that will be used by the replication server.</p>
    pub fn replication_servers_security_groups_i_ds(
        &self,
    ) -> std::option::Option<&[std::string::String]> {
        self.replication_servers_security_groups_i_ds.as_deref()
    }
    /// <p>The instance type to be used for the replication server.</p>
    pub fn replication_server_instance_type(&self) -> std::option::Option<&str> {
        self.replication_server_instance_type.as_deref()
    }
    /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
    pub fn use_dedicated_replication_server(&self) -> std::option::Option<bool> {
        self.use_dedicated_replication_server
    }
    /// <p>The Staging Disk EBS volume type to be used during replication.</p>
    pub fn default_large_staging_disk_type(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>
    {
        self.default_large_staging_disk_type.as_ref()
    }
    /// <p>The configuration of the disks of the Source Server to be replicated.</p>
    pub fn replicated_disks(
        &self,
    ) -> std::option::Option<&[crate::model::ReplicationConfigurationReplicatedDisk]> {
        self.replicated_disks.as_deref()
    }
    /// <p>The type of EBS encryption to be used during replication.</p>
    pub fn ebs_encryption(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationEbsEncryption> {
        self.ebs_encryption.as_ref()
    }
    /// <p>The ARN of the EBS encryption key to be used during replication.</p>
    pub fn ebs_encryption_key_arn(&self) -> std::option::Option<&str> {
        self.ebs_encryption_key_arn.as_deref()
    }
    /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
    pub fn bandwidth_throttling(&self) -> i64 {
        self.bandwidth_throttling
    }
    /// <p>The data plane routing mechanism that will be used for replication.</p>
    pub fn data_plane_routing(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationDataPlaneRouting> {
        self.data_plane_routing.as_ref()
    }
    /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
    pub fn create_public_ip(&self) -> std::option::Option<bool> {
        self.create_public_ip
    }
    /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
    pub fn staging_area_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.staging_area_tags.as_ref()
    }
    /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
    pub fn pit_policy(&self) -> std::option::Option<&[crate::model::PitPolicyRule]> {
        self.pit_policy.as_deref()
    }
}
impl std::fmt::Debug for UpdateReplicationConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateReplicationConfigurationInput");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.field("name", &self.name);
        formatter.field("staging_area_subnet_id", &self.staging_area_subnet_id);
        formatter.field(
            "associate_default_security_group",
            &self.associate_default_security_group,
        );
        formatter.field(
            "replication_servers_security_groups_i_ds",
            &self.replication_servers_security_groups_i_ds,
        );
        formatter.field(
            "replication_server_instance_type",
            &self.replication_server_instance_type,
        );
        formatter.field(
            "use_dedicated_replication_server",
            &self.use_dedicated_replication_server,
        );
        formatter.field(
            "default_large_staging_disk_type",
            &self.default_large_staging_disk_type,
        );
        formatter.field("replicated_disks", &self.replicated_disks);
        formatter.field("ebs_encryption", &self.ebs_encryption);
        formatter.field("ebs_encryption_key_arn", &self.ebs_encryption_key_arn);
        formatter.field("bandwidth_throttling", &self.bandwidth_throttling);
        formatter.field("data_plane_routing", &self.data_plane_routing);
        formatter.field("create_public_ip", &self.create_public_ip);
        formatter.field("staging_area_tags", &"*** Sensitive Data Redacted ***");
        formatter.field("pit_policy", &self.pit_policy);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLaunchConfigurationInput {
    /// <p>The ID of the Source Server that we want to retrieve a Launch Configuration for.</p>
    pub source_server_id: std::option::Option<std::string::String>,
    /// <p>The name of the launch configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The state of the Recovery Instance in EC2 after the recovery operation.</p>
    pub launch_disposition: std::option::Option<crate::model::LaunchDisposition>,
    /// <p>Whether Elastic Disaster Recovery should try to automatically choose the instance type that best matches the OS, CPU, and RAM of your Source Server.</p>
    pub target_instance_type_right_sizing_method:
        std::option::Option<crate::model::TargetInstanceTypeRightSizingMethod>,
    /// <p>Whether we should copy the Private IP of the Source Server to the Recovery Instance.</p>
    pub copy_private_ip: std::option::Option<bool>,
    /// <p>Whether we want to copy the tags of the Source Server to the EC2 machine of the Recovery Instance.</p>
    pub copy_tags: std::option::Option<bool>,
    /// <p>The licensing configuration to be used for this launch configuration.</p>
    pub licensing: std::option::Option<crate::model::Licensing>,
}
impl UpdateLaunchConfigurationInput {
    /// <p>The ID of the Source Server that we want to retrieve a Launch Configuration for.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
    /// <p>The name of the launch configuration.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The state of the Recovery Instance in EC2 after the recovery operation.</p>
    pub fn launch_disposition(&self) -> std::option::Option<&crate::model::LaunchDisposition> {
        self.launch_disposition.as_ref()
    }
    /// <p>Whether Elastic Disaster Recovery should try to automatically choose the instance type that best matches the OS, CPU, and RAM of your Source Server.</p>
    pub fn target_instance_type_right_sizing_method(
        &self,
    ) -> std::option::Option<&crate::model::TargetInstanceTypeRightSizingMethod> {
        self.target_instance_type_right_sizing_method.as_ref()
    }
    /// <p>Whether we should copy the Private IP of the Source Server to the Recovery Instance.</p>
    pub fn copy_private_ip(&self) -> std::option::Option<bool> {
        self.copy_private_ip
    }
    /// <p>Whether we want to copy the tags of the Source Server to the EC2 machine of the Recovery Instance.</p>
    pub fn copy_tags(&self) -> std::option::Option<bool> {
        self.copy_tags
    }
    /// <p>The licensing configuration to be used for this launch configuration.</p>
    pub fn licensing(&self) -> std::option::Option<&crate::model::Licensing> {
        self.licensing.as_ref()
    }
}
impl std::fmt::Debug for UpdateLaunchConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLaunchConfigurationInput");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.field("name", &self.name);
        formatter.field("launch_disposition", &self.launch_disposition);
        formatter.field(
            "target_instance_type_right_sizing_method",
            &self.target_instance_type_right_sizing_method,
        );
        formatter.field("copy_private_ip", &self.copy_private_ip);
        formatter.field("copy_tags", &self.copy_tags);
        formatter.field("licensing", &self.licensing);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RetryDataReplicationInput {
    /// <p>The ID of the Source Server whose data replication should be retried.</p>
    pub source_server_id: std::option::Option<std::string::String>,
}
impl RetryDataReplicationInput {
    /// <p>The ID of the Source Server whose data replication should be retried.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
}
impl std::fmt::Debug for RetryDataReplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RetryDataReplicationInput");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetReplicationConfigurationInput {
    /// <p>The ID of the Source Serve for this Replication Configuration.r</p>
    pub source_server_id: std::option::Option<std::string::String>,
}
impl GetReplicationConfigurationInput {
    /// <p>The ID of the Source Serve for this Replication Configuration.r</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
}
impl std::fmt::Debug for GetReplicationConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetReplicationConfigurationInput");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLaunchConfigurationInput {
    /// <p>The ID of the Source Server that we want to retrieve a Launch Configuration for.</p>
    pub source_server_id: std::option::Option<std::string::String>,
}
impl GetLaunchConfigurationInput {
    /// <p>The ID of the Source Server that we want to retrieve a Launch Configuration for.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
}
impl std::fmt::Debug for GetLaunchConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLaunchConfigurationInput");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisconnectSourceServerInput {
    /// <p>The ID of the Source Server to disconnect.</p>
    pub source_server_id: std::option::Option<std::string::String>,
}
impl DisconnectSourceServerInput {
    /// <p>The ID of the Source Server to disconnect.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
}
impl std::fmt::Debug for DisconnectSourceServerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisconnectSourceServerInput");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRecoverySnapshotsInput {
    /// <p>Filter Recovery Snapshots by Source Server ID.</p>
    pub source_server_id: std::option::Option<std::string::String>,
    /// <p>A set of filters by which to return Recovery Snapshots.</p>
    pub filters: std::option::Option<crate::model::DescribeRecoverySnapshotsRequestFilters>,
    /// <p>The sorted ordering by which to return Recovery Snapshots.</p>
    pub order: std::option::Option<crate::model::RecoverySnapshotsOrder>,
    /// <p>Maximum number of Recovery Snapshots to retrieve.</p>
    pub max_results: i32,
    /// <p>The token of the next Recovery Snapshot to retrieve.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeRecoverySnapshotsInput {
    /// <p>Filter Recovery Snapshots by Source Server ID.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
    /// <p>A set of filters by which to return Recovery Snapshots.</p>
    pub fn filters(
        &self,
    ) -> std::option::Option<&crate::model::DescribeRecoverySnapshotsRequestFilters> {
        self.filters.as_ref()
    }
    /// <p>The sorted ordering by which to return Recovery Snapshots.</p>
    pub fn order(&self) -> std::option::Option<&crate::model::RecoverySnapshotsOrder> {
        self.order.as_ref()
    }
    /// <p>Maximum number of Recovery Snapshots to retrieve.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token of the next Recovery Snapshot to retrieve.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeRecoverySnapshotsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRecoverySnapshotsInput");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.field("filters", &self.filters);
        formatter.field("order", &self.order);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartRecoveryInput {
    /// <p>The Source Servers that we want to start a Recovery Job for.</p>
    pub source_servers:
        std::option::Option<std::vec::Vec<crate::model::StartRecoveryRequestSourceServer>>,
    /// <p>Whether this Source Server Recovery operation is a drill or not.</p>
    pub is_drill: std::option::Option<bool>,
    /// <p>The tags to be associated with the Recovery Job.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl StartRecoveryInput {
    /// <p>The Source Servers that we want to start a Recovery Job for.</p>
    pub fn source_servers(
        &self,
    ) -> std::option::Option<&[crate::model::StartRecoveryRequestSourceServer]> {
        self.source_servers.as_deref()
    }
    /// <p>Whether this Source Server Recovery operation is a drill or not.</p>
    pub fn is_drill(&self) -> std::option::Option<bool> {
        self.is_drill
    }
    /// <p>The tags to be associated with the Recovery Job.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for StartRecoveryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartRecoveryInput");
        formatter.field("source_servers", &self.source_servers);
        formatter.field("is_drill", &self.is_drill);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSourceServersInput {
    /// <p>A set of filters by which to return Source Servers.</p>
    pub filters: std::option::Option<crate::model::DescribeSourceServersRequestFilters>,
    /// <p>Maximum number of Source Servers to retrieve.</p>
    pub max_results: i32,
    /// <p>The token of the next Source Server to retrieve.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeSourceServersInput {
    /// <p>A set of filters by which to return Source Servers.</p>
    pub fn filters(
        &self,
    ) -> std::option::Option<&crate::model::DescribeSourceServersRequestFilters> {
        self.filters.as_ref()
    }
    /// <p>Maximum number of Source Servers to retrieve.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token of the next Source Server to retrieve.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeSourceServersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSourceServersInput");
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSourceServerInput {
    /// <p>The ID of the Source Server to be deleted.</p>
    pub source_server_id: std::option::Option<std::string::String>,
}
impl DeleteSourceServerInput {
    /// <p>The ID of the Source Server to be deleted.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteSourceServerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSourceServerInput");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReplicationConfigurationTemplatesInput {
    /// <p>The IDs of the Replication Configuration Templates to retrieve. An empty list means all Replication Configuration Templates.</p>
    pub replication_configuration_template_i_ds:
        std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Maximum number of Replication Configuration Templates to retrieve.</p>
    pub max_results: i32,
    /// <p>The token of the next Replication Configuration Template to retrieve.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeReplicationConfigurationTemplatesInput {
    /// <p>The IDs of the Replication Configuration Templates to retrieve. An empty list means all Replication Configuration Templates.</p>
    pub fn replication_configuration_template_i_ds(
        &self,
    ) -> std::option::Option<&[std::string::String]> {
        self.replication_configuration_template_i_ds.as_deref()
    }
    /// <p>Maximum number of Replication Configuration Templates to retrieve.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token of the next Replication Configuration Template to retrieve.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeReplicationConfigurationTemplatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReplicationConfigurationTemplatesInput");
        formatter.field(
            "replication_configuration_template_i_ds",
            &self.replication_configuration_template_i_ds,
        );
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateReplicationConfigurationTemplateInput {
    /// <p>The subnet to be used by the replication staging area.</p>
    pub staging_area_subnet_id: std::option::Option<std::string::String>,
    /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>
    pub associate_default_security_group: std::option::Option<bool>,
    /// <p>The security group IDs that will be used by the replication server.</p>
    pub replication_servers_security_groups_i_ds:
        std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The instance type to be used for the replication server.</p>
    pub replication_server_instance_type: std::option::Option<std::string::String>,
    /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
    pub use_dedicated_replication_server: std::option::Option<bool>,
    /// <p>The Staging Disk EBS volume type to be used during replication.</p>
    pub default_large_staging_disk_type:
        std::option::Option<crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>,
    /// <p>The type of EBS encryption to be used during replication.</p>
    pub ebs_encryption: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
    /// <p>The ARN of the EBS encryption key to be used during replication.</p>
    pub ebs_encryption_key_arn: std::option::Option<std::string::String>,
    /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
    pub bandwidth_throttling: i64,
    /// <p>The data plane routing mechanism that will be used for replication.</p>
    pub data_plane_routing:
        std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
    /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
    pub create_public_ip: std::option::Option<bool>,
    /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
    pub staging_area_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
    pub pit_policy: std::option::Option<std::vec::Vec<crate::model::PitPolicyRule>>,
    /// <p>A set of tags to be associated with the Replication Configuration Template resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateReplicationConfigurationTemplateInput {
    /// <p>The subnet to be used by the replication staging area.</p>
    pub fn staging_area_subnet_id(&self) -> std::option::Option<&str> {
        self.staging_area_subnet_id.as_deref()
    }
    /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>
    pub fn associate_default_security_group(&self) -> std::option::Option<bool> {
        self.associate_default_security_group
    }
    /// <p>The security group IDs that will be used by the replication server.</p>
    pub fn replication_servers_security_groups_i_ds(
        &self,
    ) -> std::option::Option<&[std::string::String]> {
        self.replication_servers_security_groups_i_ds.as_deref()
    }
    /// <p>The instance type to be used for the replication server.</p>
    pub fn replication_server_instance_type(&self) -> std::option::Option<&str> {
        self.replication_server_instance_type.as_deref()
    }
    /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
    pub fn use_dedicated_replication_server(&self) -> std::option::Option<bool> {
        self.use_dedicated_replication_server
    }
    /// <p>The Staging Disk EBS volume type to be used during replication.</p>
    pub fn default_large_staging_disk_type(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>
    {
        self.default_large_staging_disk_type.as_ref()
    }
    /// <p>The type of EBS encryption to be used during replication.</p>
    pub fn ebs_encryption(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationEbsEncryption> {
        self.ebs_encryption.as_ref()
    }
    /// <p>The ARN of the EBS encryption key to be used during replication.</p>
    pub fn ebs_encryption_key_arn(&self) -> std::option::Option<&str> {
        self.ebs_encryption_key_arn.as_deref()
    }
    /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
    pub fn bandwidth_throttling(&self) -> i64 {
        self.bandwidth_throttling
    }
    /// <p>The data plane routing mechanism that will be used for replication.</p>
    pub fn data_plane_routing(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationDataPlaneRouting> {
        self.data_plane_routing.as_ref()
    }
    /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
    pub fn create_public_ip(&self) -> std::option::Option<bool> {
        self.create_public_ip
    }
    /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
    pub fn staging_area_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.staging_area_tags.as_ref()
    }
    /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
    pub fn pit_policy(&self) -> std::option::Option<&[crate::model::PitPolicyRule]> {
        self.pit_policy.as_deref()
    }
    /// <p>A set of tags to be associated with the Replication Configuration Template resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateReplicationConfigurationTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateReplicationConfigurationTemplateInput");
        formatter.field("staging_area_subnet_id", &self.staging_area_subnet_id);
        formatter.field(
            "associate_default_security_group",
            &self.associate_default_security_group,
        );
        formatter.field(
            "replication_servers_security_groups_i_ds",
            &self.replication_servers_security_groups_i_ds,
        );
        formatter.field(
            "replication_server_instance_type",
            &self.replication_server_instance_type,
        );
        formatter.field(
            "use_dedicated_replication_server",
            &self.use_dedicated_replication_server,
        );
        formatter.field(
            "default_large_staging_disk_type",
            &self.default_large_staging_disk_type,
        );
        formatter.field("ebs_encryption", &self.ebs_encryption);
        formatter.field("ebs_encryption_key_arn", &self.ebs_encryption_key_arn);
        formatter.field("bandwidth_throttling", &self.bandwidth_throttling);
        formatter.field("data_plane_routing", &self.data_plane_routing);
        formatter.field("create_public_ip", &self.create_public_ip);
        formatter.field("staging_area_tags", &"*** Sensitive Data Redacted ***");
        formatter.field("pit_policy", &self.pit_policy);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteReplicationConfigurationTemplateInput {
    /// <p>The ID of the Replication Configuration Template to be deleted.</p>
    pub replication_configuration_template_id: std::option::Option<std::string::String>,
}
impl DeleteReplicationConfigurationTemplateInput {
    /// <p>The ID of the Replication Configuration Template to be deleted.</p>
    pub fn replication_configuration_template_id(&self) -> std::option::Option<&str> {
        self.replication_configuration_template_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteReplicationConfigurationTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteReplicationConfigurationTemplateInput");
        formatter.field(
            "replication_configuration_template_id",
            &self.replication_configuration_template_id,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateReplicationConfigurationTemplateInput {
    /// <p>The Replication Configuration Template ID.</p>
    pub replication_configuration_template_id: std::option::Option<std::string::String>,
    /// <p>The Replication Configuration Template ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The subnet to be used by the replication staging area.</p>
    pub staging_area_subnet_id: std::option::Option<std::string::String>,
    /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>
    pub associate_default_security_group: std::option::Option<bool>,
    /// <p>The security group IDs that will be used by the replication server.</p>
    pub replication_servers_security_groups_i_ds:
        std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The instance type to be used for the replication server.</p>
    pub replication_server_instance_type: std::option::Option<std::string::String>,
    /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
    pub use_dedicated_replication_server: std::option::Option<bool>,
    /// <p>The Staging Disk EBS volume type to be used during replication.</p>
    pub default_large_staging_disk_type:
        std::option::Option<crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>,
    /// <p>The type of EBS encryption to be used during replication.</p>
    pub ebs_encryption: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
    /// <p>The ARN of the EBS encryption key to be used during replication.</p>
    pub ebs_encryption_key_arn: std::option::Option<std::string::String>,
    /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
    pub bandwidth_throttling: i64,
    /// <p>The data plane routing mechanism that will be used for replication.</p>
    pub data_plane_routing:
        std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
    /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
    pub create_public_ip: std::option::Option<bool>,
    /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
    pub staging_area_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
    pub pit_policy: std::option::Option<std::vec::Vec<crate::model::PitPolicyRule>>,
}
impl UpdateReplicationConfigurationTemplateInput {
    /// <p>The Replication Configuration Template ID.</p>
    pub fn replication_configuration_template_id(&self) -> std::option::Option<&str> {
        self.replication_configuration_template_id.as_deref()
    }
    /// <p>The Replication Configuration Template ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The subnet to be used by the replication staging area.</p>
    pub fn staging_area_subnet_id(&self) -> std::option::Option<&str> {
        self.staging_area_subnet_id.as_deref()
    }
    /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>
    pub fn associate_default_security_group(&self) -> std::option::Option<bool> {
        self.associate_default_security_group
    }
    /// <p>The security group IDs that will be used by the replication server.</p>
    pub fn replication_servers_security_groups_i_ds(
        &self,
    ) -> std::option::Option<&[std::string::String]> {
        self.replication_servers_security_groups_i_ds.as_deref()
    }
    /// <p>The instance type to be used for the replication server.</p>
    pub fn replication_server_instance_type(&self) -> std::option::Option<&str> {
        self.replication_server_instance_type.as_deref()
    }
    /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
    pub fn use_dedicated_replication_server(&self) -> std::option::Option<bool> {
        self.use_dedicated_replication_server
    }
    /// <p>The Staging Disk EBS volume type to be used during replication.</p>
    pub fn default_large_staging_disk_type(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>
    {
        self.default_large_staging_disk_type.as_ref()
    }
    /// <p>The type of EBS encryption to be used during replication.</p>
    pub fn ebs_encryption(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationEbsEncryption> {
        self.ebs_encryption.as_ref()
    }
    /// <p>The ARN of the EBS encryption key to be used during replication.</p>
    pub fn ebs_encryption_key_arn(&self) -> std::option::Option<&str> {
        self.ebs_encryption_key_arn.as_deref()
    }
    /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
    pub fn bandwidth_throttling(&self) -> i64 {
        self.bandwidth_throttling
    }
    /// <p>The data plane routing mechanism that will be used for replication.</p>
    pub fn data_plane_routing(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationDataPlaneRouting> {
        self.data_plane_routing.as_ref()
    }
    /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
    pub fn create_public_ip(&self) -> std::option::Option<bool> {
        self.create_public_ip
    }
    /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
    pub fn staging_area_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.staging_area_tags.as_ref()
    }
    /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
    pub fn pit_policy(&self) -> std::option::Option<&[crate::model::PitPolicyRule]> {
        self.pit_policy.as_deref()
    }
}
impl std::fmt::Debug for UpdateReplicationConfigurationTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateReplicationConfigurationTemplateInput");
        formatter.field(
            "replication_configuration_template_id",
            &self.replication_configuration_template_id,
        );
        formatter.field("arn", &self.arn);
        formatter.field("staging_area_subnet_id", &self.staging_area_subnet_id);
        formatter.field(
            "associate_default_security_group",
            &self.associate_default_security_group,
        );
        formatter.field(
            "replication_servers_security_groups_i_ds",
            &self.replication_servers_security_groups_i_ds,
        );
        formatter.field(
            "replication_server_instance_type",
            &self.replication_server_instance_type,
        );
        formatter.field(
            "use_dedicated_replication_server",
            &self.use_dedicated_replication_server,
        );
        formatter.field(
            "default_large_staging_disk_type",
            &self.default_large_staging_disk_type,
        );
        formatter.field("ebs_encryption", &self.ebs_encryption);
        formatter.field("ebs_encryption_key_arn", &self.ebs_encryption_key_arn);
        formatter.field("bandwidth_throttling", &self.bandwidth_throttling);
        formatter.field("data_plane_routing", &self.data_plane_routing);
        formatter.field("create_public_ip", &self.create_public_ip);
        formatter.field("staging_area_tags", &"*** Sensitive Data Redacted ***");
        formatter.field("pit_policy", &self.pit_policy);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFailbackReplicationConfigurationInput {
    /// <p>The ID of the Recovery Instance.</p>
    pub recovery_instance_id: std::option::Option<std::string::String>,
    /// <p>The name of the Failback Replication Configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Recovery Instance in Mbps.</p>
    pub bandwidth_throttling: i64,
    /// <p>Whether to use Private IP for the failback replication of the Recovery Instance.</p>
    pub use_private_ip: std::option::Option<bool>,
}
impl UpdateFailbackReplicationConfigurationInput {
    /// <p>The ID of the Recovery Instance.</p>
    pub fn recovery_instance_id(&self) -> std::option::Option<&str> {
        self.recovery_instance_id.as_deref()
    }
    /// <p>The name of the Failback Replication Configuration.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Recovery Instance in Mbps.</p>
    pub fn bandwidth_throttling(&self) -> i64 {
        self.bandwidth_throttling
    }
    /// <p>Whether to use Private IP for the failback replication of the Recovery Instance.</p>
    pub fn use_private_ip(&self) -> std::option::Option<bool> {
        self.use_private_ip
    }
}
impl std::fmt::Debug for UpdateFailbackReplicationConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFailbackReplicationConfigurationInput");
        formatter.field("recovery_instance_id", &self.recovery_instance_id);
        formatter.field("name", &self.name);
        formatter.field("bandwidth_throttling", &self.bandwidth_throttling);
        formatter.field("use_private_ip", &self.use_private_ip);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopFailbackInput {
    /// <p>The ID of the Recovery Instance we want to stop failback for.</p>
    pub recovery_instance_id: std::option::Option<std::string::String>,
}
impl StopFailbackInput {
    /// <p>The ID of the Recovery Instance we want to stop failback for.</p>
    pub fn recovery_instance_id(&self) -> std::option::Option<&str> {
        self.recovery_instance_id.as_deref()
    }
}
impl std::fmt::Debug for StopFailbackInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopFailbackInput");
        formatter.field("recovery_instance_id", &self.recovery_instance_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFailbackReplicationConfigurationInput {
    /// <p>The ID of the Recovery Instance whose failback replication configuration should be returned.</p>
    pub recovery_instance_id: std::option::Option<std::string::String>,
}
impl GetFailbackReplicationConfigurationInput {
    /// <p>The ID of the Recovery Instance whose failback replication configuration should be returned.</p>
    pub fn recovery_instance_id(&self) -> std::option::Option<&str> {
        self.recovery_instance_id.as_deref()
    }
}
impl std::fmt::Debug for GetFailbackReplicationConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFailbackReplicationConfigurationInput");
        formatter.field("recovery_instance_id", &self.recovery_instance_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisconnectRecoveryInstanceInput {
    /// <p>The ID of the Recovery Instance to disconnect.</p>
    pub recovery_instance_id: std::option::Option<std::string::String>,
}
impl DisconnectRecoveryInstanceInput {
    /// <p>The ID of the Recovery Instance to disconnect.</p>
    pub fn recovery_instance_id(&self) -> std::option::Option<&str> {
        self.recovery_instance_id.as_deref()
    }
}
impl std::fmt::Debug for DisconnectRecoveryInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisconnectRecoveryInstanceInput");
        formatter.field("recovery_instance_id", &self.recovery_instance_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRecoveryInstanceInput {
    /// <p>RThe ID of the Recovery Instance to be deleted.</p>
    pub recovery_instance_id: std::option::Option<std::string::String>,
}
impl DeleteRecoveryInstanceInput {
    /// <p>RThe ID of the Recovery Instance to be deleted.</p>
    pub fn recovery_instance_id(&self) -> std::option::Option<&str> {
        self.recovery_instance_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteRecoveryInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRecoveryInstanceInput");
        formatter.field("recovery_instance_id", &self.recovery_instance_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TerminateRecoveryInstancesInput {
    /// <p>The IDs of the Recovery Instances that should be terminated.</p>
    pub recovery_instance_i_ds: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl TerminateRecoveryInstancesInput {
    /// <p>The IDs of the Recovery Instances that should be terminated.</p>
    pub fn recovery_instance_i_ds(&self) -> std::option::Option<&[std::string::String]> {
        self.recovery_instance_i_ds.as_deref()
    }
}
impl std::fmt::Debug for TerminateRecoveryInstancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TerminateRecoveryInstancesInput");
        formatter.field("recovery_instance_i_ds", &self.recovery_instance_i_ds);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartFailbackLaunchInput {
    /// <p>The IDs of the Recovery Instance whose failback launch we want to request.</p>
    pub recovery_instance_i_ds: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The tags to be associated with the failback launch Job.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl StartFailbackLaunchInput {
    /// <p>The IDs of the Recovery Instance whose failback launch we want to request.</p>
    pub fn recovery_instance_i_ds(&self) -> std::option::Option<&[std::string::String]> {
        self.recovery_instance_i_ds.as_deref()
    }
    /// <p>The tags to be associated with the failback launch Job.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for StartFailbackLaunchInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartFailbackLaunchInput");
        formatter.field("recovery_instance_i_ds", &self.recovery_instance_i_ds);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRecoveryInstancesInput {
    /// <p>A set of filters by which to return Recovery Instances.</p>
    pub filters: std::option::Option<crate::model::DescribeRecoveryInstancesRequestFilters>,
    /// <p>Maximum number of Recovery Instances to retrieve.</p>
    pub max_results: i32,
    /// <p>The token of the next Recovery Instance to retrieve.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeRecoveryInstancesInput {
    /// <p>A set of filters by which to return Recovery Instances.</p>
    pub fn filters(
        &self,
    ) -> std::option::Option<&crate::model::DescribeRecoveryInstancesRequestFilters> {
        self.filters.as_ref()
    }
    /// <p>Maximum number of Recovery Instances to retrieve.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token of the next Recovery Instance to retrieve.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeRecoveryInstancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRecoveryInstancesInput");
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeJobLogItemsInput {
    /// <p>The ID of the Job for which Job log items will be retrieved.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>Maximum number of Job log items to retrieve.</p>
    pub max_results: i32,
    /// <p>The token of the next Job log items to retrieve.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeJobLogItemsInput {
    /// <p>The ID of the Job for which Job log items will be retrieved.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>Maximum number of Job log items to retrieve.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token of the next Job log items to retrieve.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeJobLogItemsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeJobLogItemsInput");
        formatter.field("job_id", &self.job_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeJobsInput {
    /// <p>A set of filters by which to return Jobs.</p>
    pub filters: std::option::Option<crate::model::DescribeJobsRequestFilters>,
    /// <p>Maximum number of Jobs to retrieve.</p>
    pub max_results: i32,
    /// <p>The token of the next Job to retrieve.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeJobsInput {
    /// <p>A set of filters by which to return Jobs.</p>
    pub fn filters(&self) -> std::option::Option<&crate::model::DescribeJobsRequestFilters> {
        self.filters.as_ref()
    }
    /// <p>Maximum number of Jobs to retrieve.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token of the next Job to retrieve.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeJobsInput");
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteJobInput {
    /// <p>The ID of the Job to be deleted.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl DeleteJobInput {
    /// <p>The ID of the Job to be deleted.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>ARN of the resource for which tags are to be removed.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Array of tags to be removed.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>ARN of the resource for which tags are to be removed.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Array of tags to be removed.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>ARN of the resource for which tags are to be added or updated.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Array of tags to be added or updated.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>ARN of the resource for which tags are to be added or updated.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Array of tags to be added or updated.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The ARN of the resource whose tags should be returned.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The ARN of the resource whose tags should be returned.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InitializeServiceInput {}
impl std::fmt::Debug for InitializeServiceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InitializeServiceInput");
        formatter.finish()
    }
}
