// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateReplicationConfigurationOutput {
    /// <p>The ID of the Source Server for this Replication Configuration.</p>
    pub source_server_id: std::option::Option<std::string::String>,
    /// <p>The name of the Replication Configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The subnet to be used by the replication staging area.</p>
    pub staging_area_subnet_id: std::option::Option<std::string::String>,
    /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration.</p>
    pub associate_default_security_group: std::option::Option<bool>,
    /// <p>The security group IDs that will be used by the replication server.</p>
    pub replication_servers_security_groups_i_ds:
        std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The instance type to be used for the replication server.</p>
    pub replication_server_instance_type: std::option::Option<std::string::String>,
    /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
    pub use_dedicated_replication_server: std::option::Option<bool>,
    /// <p>The Staging Disk EBS volume type to be used during replication.</p>
    pub default_large_staging_disk_type:
        std::option::Option<crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>,
    /// <p>The configuration of the disks of the Source Server to be replicated.</p>
    pub replicated_disks:
        std::option::Option<std::vec::Vec<crate::model::ReplicationConfigurationReplicatedDisk>>,
    /// <p>The type of EBS encryption to be used during replication.</p>
    pub ebs_encryption: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
    /// <p>The ARN of the EBS encryption key to be used during replication.</p>
    pub ebs_encryption_key_arn: std::option::Option<std::string::String>,
    /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
    pub bandwidth_throttling: i64,
    /// <p>The data plane routing mechanism that will be used for replication.</p>
    pub data_plane_routing:
        std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
    /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
    pub create_public_ip: std::option::Option<bool>,
    /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
    pub staging_area_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
    pub pit_policy: std::option::Option<std::vec::Vec<crate::model::PitPolicyRule>>,
}
impl UpdateReplicationConfigurationOutput {
    /// <p>The ID of the Source Server for this Replication Configuration.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
    /// <p>The name of the Replication Configuration.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The subnet to be used by the replication staging area.</p>
    pub fn staging_area_subnet_id(&self) -> std::option::Option<&str> {
        self.staging_area_subnet_id.as_deref()
    }
    /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration.</p>
    pub fn associate_default_security_group(&self) -> std::option::Option<bool> {
        self.associate_default_security_group
    }
    /// <p>The security group IDs that will be used by the replication server.</p>
    pub fn replication_servers_security_groups_i_ds(
        &self,
    ) -> std::option::Option<&[std::string::String]> {
        self.replication_servers_security_groups_i_ds.as_deref()
    }
    /// <p>The instance type to be used for the replication server.</p>
    pub fn replication_server_instance_type(&self) -> std::option::Option<&str> {
        self.replication_server_instance_type.as_deref()
    }
    /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
    pub fn use_dedicated_replication_server(&self) -> std::option::Option<bool> {
        self.use_dedicated_replication_server
    }
    /// <p>The Staging Disk EBS volume type to be used during replication.</p>
    pub fn default_large_staging_disk_type(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>
    {
        self.default_large_staging_disk_type.as_ref()
    }
    /// <p>The configuration of the disks of the Source Server to be replicated.</p>
    pub fn replicated_disks(
        &self,
    ) -> std::option::Option<&[crate::model::ReplicationConfigurationReplicatedDisk]> {
        self.replicated_disks.as_deref()
    }
    /// <p>The type of EBS encryption to be used during replication.</p>
    pub fn ebs_encryption(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationEbsEncryption> {
        self.ebs_encryption.as_ref()
    }
    /// <p>The ARN of the EBS encryption key to be used during replication.</p>
    pub fn ebs_encryption_key_arn(&self) -> std::option::Option<&str> {
        self.ebs_encryption_key_arn.as_deref()
    }
    /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
    pub fn bandwidth_throttling(&self) -> i64 {
        self.bandwidth_throttling
    }
    /// <p>The data plane routing mechanism that will be used for replication.</p>
    pub fn data_plane_routing(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationDataPlaneRouting> {
        self.data_plane_routing.as_ref()
    }
    /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
    pub fn create_public_ip(&self) -> std::option::Option<bool> {
        self.create_public_ip
    }
    /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
    pub fn staging_area_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.staging_area_tags.as_ref()
    }
    /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
    pub fn pit_policy(&self) -> std::option::Option<&[crate::model::PitPolicyRule]> {
        self.pit_policy.as_deref()
    }
}
impl std::fmt::Debug for UpdateReplicationConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateReplicationConfigurationOutput");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.field("name", &self.name);
        formatter.field("staging_area_subnet_id", &self.staging_area_subnet_id);
        formatter.field(
            "associate_default_security_group",
            &self.associate_default_security_group,
        );
        formatter.field(
            "replication_servers_security_groups_i_ds",
            &self.replication_servers_security_groups_i_ds,
        );
        formatter.field(
            "replication_server_instance_type",
            &self.replication_server_instance_type,
        );
        formatter.field(
            "use_dedicated_replication_server",
            &self.use_dedicated_replication_server,
        );
        formatter.field(
            "default_large_staging_disk_type",
            &self.default_large_staging_disk_type,
        );
        formatter.field("replicated_disks", &self.replicated_disks);
        formatter.field("ebs_encryption", &self.ebs_encryption);
        formatter.field("ebs_encryption_key_arn", &self.ebs_encryption_key_arn);
        formatter.field("bandwidth_throttling", &self.bandwidth_throttling);
        formatter.field("data_plane_routing", &self.data_plane_routing);
        formatter.field("create_public_ip", &self.create_public_ip);
        formatter.field("staging_area_tags", &"*** Sensitive Data Redacted ***");
        formatter.field("pit_policy", &self.pit_policy);
        formatter.finish()
    }
}
/// See [`UpdateReplicationConfigurationOutput`](crate::output::UpdateReplicationConfigurationOutput)
pub mod update_replication_configuration_output {
    /// A builder for [`UpdateReplicationConfigurationOutput`](crate::output::UpdateReplicationConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) staging_area_subnet_id: std::option::Option<std::string::String>,
        pub(crate) associate_default_security_group: std::option::Option<bool>,
        pub(crate) replication_servers_security_groups_i_ds:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) replication_server_instance_type: std::option::Option<std::string::String>,
        pub(crate) use_dedicated_replication_server: std::option::Option<bool>,
        pub(crate) default_large_staging_disk_type:
            std::option::Option<crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>,
        pub(crate) replicated_disks: std::option::Option<
            std::vec::Vec<crate::model::ReplicationConfigurationReplicatedDisk>,
        >,
        pub(crate) ebs_encryption:
            std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        pub(crate) ebs_encryption_key_arn: std::option::Option<std::string::String>,
        pub(crate) bandwidth_throttling: std::option::Option<i64>,
        pub(crate) data_plane_routing:
            std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        pub(crate) create_public_ip: std::option::Option<bool>,
        pub(crate) staging_area_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) pit_policy: std::option::Option<std::vec::Vec<crate::model::PitPolicyRule>>,
    }
    impl Builder {
        /// <p>The ID of the Source Server for this Replication Configuration.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>The ID of the Source Server for this Replication Configuration.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// <p>The name of the Replication Configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Replication Configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The subnet to be used by the replication staging area.</p>
        pub fn staging_area_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.staging_area_subnet_id = Some(input.into());
            self
        }
        /// <p>The subnet to be used by the replication staging area.</p>
        pub fn set_staging_area_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.staging_area_subnet_id = input;
            self
        }
        /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration.</p>
        pub fn associate_default_security_group(mut self, input: bool) -> Self {
            self.associate_default_security_group = Some(input);
            self
        }
        /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration.</p>
        pub fn set_associate_default_security_group(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.associate_default_security_group = input;
            self
        }
        /// Appends an item to `replication_servers_security_groups_i_ds`.
        ///
        /// To override the contents of this collection use [`set_replication_servers_security_groups_i_ds`](Self::set_replication_servers_security_groups_i_ds).
        ///
        /// <p>The security group IDs that will be used by the replication server.</p>
        pub fn replication_servers_security_groups_i_ds(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self
                .replication_servers_security_groups_i_ds
                .unwrap_or_default();
            v.push(input.into());
            self.replication_servers_security_groups_i_ds = Some(v);
            self
        }
        /// <p>The security group IDs that will be used by the replication server.</p>
        pub fn set_replication_servers_security_groups_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.replication_servers_security_groups_i_ds = input;
            self
        }
        /// <p>The instance type to be used for the replication server.</p>
        pub fn replication_server_instance_type(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_server_instance_type = Some(input.into());
            self
        }
        /// <p>The instance type to be used for the replication server.</p>
        pub fn set_replication_server_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_server_instance_type = input;
            self
        }
        /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
        pub fn use_dedicated_replication_server(mut self, input: bool) -> Self {
            self.use_dedicated_replication_server = Some(input);
            self
        }
        /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
        pub fn set_use_dedicated_replication_server(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.use_dedicated_replication_server = input;
            self
        }
        /// <p>The Staging Disk EBS volume type to be used during replication.</p>
        pub fn default_large_staging_disk_type(
            mut self,
            input: crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
        ) -> Self {
            self.default_large_staging_disk_type = Some(input);
            self
        }
        /// <p>The Staging Disk EBS volume type to be used during replication.</p>
        pub fn set_default_large_staging_disk_type(
            mut self,
            input: std::option::Option<
                crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
            >,
        ) -> Self {
            self.default_large_staging_disk_type = input;
            self
        }
        /// Appends an item to `replicated_disks`.
        ///
        /// To override the contents of this collection use [`set_replicated_disks`](Self::set_replicated_disks).
        ///
        /// <p>The configuration of the disks of the Source Server to be replicated.</p>
        pub fn replicated_disks(
            mut self,
            input: impl Into<crate::model::ReplicationConfigurationReplicatedDisk>,
        ) -> Self {
            let mut v = self.replicated_disks.unwrap_or_default();
            v.push(input.into());
            self.replicated_disks = Some(v);
            self
        }
        /// <p>The configuration of the disks of the Source Server to be replicated.</p>
        pub fn set_replicated_disks(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ReplicationConfigurationReplicatedDisk>,
            >,
        ) -> Self {
            self.replicated_disks = input;
            self
        }
        /// <p>The type of EBS encryption to be used during replication.</p>
        pub fn ebs_encryption(
            mut self,
            input: crate::model::ReplicationConfigurationEbsEncryption,
        ) -> Self {
            self.ebs_encryption = Some(input);
            self
        }
        /// <p>The type of EBS encryption to be used during replication.</p>
        pub fn set_ebs_encryption(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        ) -> Self {
            self.ebs_encryption = input;
            self
        }
        /// <p>The ARN of the EBS encryption key to be used during replication.</p>
        pub fn ebs_encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ebs_encryption_key_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the EBS encryption key to be used during replication.</p>
        pub fn set_ebs_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ebs_encryption_key_arn = input;
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
        pub fn bandwidth_throttling(mut self, input: i64) -> Self {
            self.bandwidth_throttling = Some(input);
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
        pub fn set_bandwidth_throttling(mut self, input: std::option::Option<i64>) -> Self {
            self.bandwidth_throttling = input;
            self
        }
        /// <p>The data plane routing mechanism that will be used for replication.</p>
        pub fn data_plane_routing(
            mut self,
            input: crate::model::ReplicationConfigurationDataPlaneRouting,
        ) -> Self {
            self.data_plane_routing = Some(input);
            self
        }
        /// <p>The data plane routing mechanism that will be used for replication.</p>
        pub fn set_data_plane_routing(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        ) -> Self {
            self.data_plane_routing = input;
            self
        }
        /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
        pub fn create_public_ip(mut self, input: bool) -> Self {
            self.create_public_ip = Some(input);
            self
        }
        /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
        pub fn set_create_public_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.create_public_ip = input;
            self
        }
        /// Adds a key-value pair to `staging_area_tags`.
        ///
        /// To override the contents of this collection use [`set_staging_area_tags`](Self::set_staging_area_tags).
        ///
        /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
        pub fn staging_area_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.staging_area_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.staging_area_tags = Some(hash_map);
            self
        }
        /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
        pub fn set_staging_area_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.staging_area_tags = input;
            self
        }
        /// Appends an item to `pit_policy`.
        ///
        /// To override the contents of this collection use [`set_pit_policy`](Self::set_pit_policy).
        ///
        /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
        pub fn pit_policy(mut self, input: impl Into<crate::model::PitPolicyRule>) -> Self {
            let mut v = self.pit_policy.unwrap_or_default();
            v.push(input.into());
            self.pit_policy = Some(v);
            self
        }
        /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
        pub fn set_pit_policy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PitPolicyRule>>,
        ) -> Self {
            self.pit_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateReplicationConfigurationOutput`](crate::output::UpdateReplicationConfigurationOutput)
        pub fn build(self) -> crate::output::UpdateReplicationConfigurationOutput {
            crate::output::UpdateReplicationConfigurationOutput {
                source_server_id: self.source_server_id,
                name: self.name,
                staging_area_subnet_id: self.staging_area_subnet_id,
                associate_default_security_group: self.associate_default_security_group,
                replication_servers_security_groups_i_ds: self
                    .replication_servers_security_groups_i_ds,
                replication_server_instance_type: self.replication_server_instance_type,
                use_dedicated_replication_server: self.use_dedicated_replication_server,
                default_large_staging_disk_type: self.default_large_staging_disk_type,
                replicated_disks: self.replicated_disks,
                ebs_encryption: self.ebs_encryption,
                ebs_encryption_key_arn: self.ebs_encryption_key_arn,
                bandwidth_throttling: self.bandwidth_throttling.unwrap_or_default(),
                data_plane_routing: self.data_plane_routing,
                create_public_ip: self.create_public_ip,
                staging_area_tags: self.staging_area_tags,
                pit_policy: self.pit_policy,
            }
        }
    }
}
impl UpdateReplicationConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateReplicationConfigurationOutput`](crate::output::UpdateReplicationConfigurationOutput)
    pub fn builder() -> crate::output::update_replication_configuration_output::Builder {
        crate::output::update_replication_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLaunchConfigurationOutput {
    /// <p>The ID of the Source Server for this launch configuration.</p>
    pub source_server_id: std::option::Option<std::string::String>,
    /// <p>The name of the launch configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The EC2 launch template ID of this launch configuration.</p>
    pub ec2_launch_template_id: std::option::Option<std::string::String>,
    /// <p>The state of the Recovery Instance in EC2 after the recovery operation.</p>
    pub launch_disposition: std::option::Option<crate::model::LaunchDisposition>,
    /// <p>Whether Elastic Disaster Recovery should try to automatically choose the instance type that best matches the OS, CPU, and RAM of your Source Server.</p>
    pub target_instance_type_right_sizing_method:
        std::option::Option<crate::model::TargetInstanceTypeRightSizingMethod>,
    /// <p>Whether we should copy the Private IP of the Source Server to the Recovery Instance.</p>
    pub copy_private_ip: std::option::Option<bool>,
    /// <p>Whether we want to copy the tags of the Source Server to the EC2 machine of the Recovery Instance.</p>
    pub copy_tags: std::option::Option<bool>,
    /// <p>The licensing configuration to be used for this launch configuration.</p>
    pub licensing: std::option::Option<crate::model::Licensing>,
}
impl UpdateLaunchConfigurationOutput {
    /// <p>The ID of the Source Server for this launch configuration.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
    /// <p>The name of the launch configuration.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The EC2 launch template ID of this launch configuration.</p>
    pub fn ec2_launch_template_id(&self) -> std::option::Option<&str> {
        self.ec2_launch_template_id.as_deref()
    }
    /// <p>The state of the Recovery Instance in EC2 after the recovery operation.</p>
    pub fn launch_disposition(&self) -> std::option::Option<&crate::model::LaunchDisposition> {
        self.launch_disposition.as_ref()
    }
    /// <p>Whether Elastic Disaster Recovery should try to automatically choose the instance type that best matches the OS, CPU, and RAM of your Source Server.</p>
    pub fn target_instance_type_right_sizing_method(
        &self,
    ) -> std::option::Option<&crate::model::TargetInstanceTypeRightSizingMethod> {
        self.target_instance_type_right_sizing_method.as_ref()
    }
    /// <p>Whether we should copy the Private IP of the Source Server to the Recovery Instance.</p>
    pub fn copy_private_ip(&self) -> std::option::Option<bool> {
        self.copy_private_ip
    }
    /// <p>Whether we want to copy the tags of the Source Server to the EC2 machine of the Recovery Instance.</p>
    pub fn copy_tags(&self) -> std::option::Option<bool> {
        self.copy_tags
    }
    /// <p>The licensing configuration to be used for this launch configuration.</p>
    pub fn licensing(&self) -> std::option::Option<&crate::model::Licensing> {
        self.licensing.as_ref()
    }
}
impl std::fmt::Debug for UpdateLaunchConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLaunchConfigurationOutput");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.field("name", &self.name);
        formatter.field("ec2_launch_template_id", &self.ec2_launch_template_id);
        formatter.field("launch_disposition", &self.launch_disposition);
        formatter.field(
            "target_instance_type_right_sizing_method",
            &self.target_instance_type_right_sizing_method,
        );
        formatter.field("copy_private_ip", &self.copy_private_ip);
        formatter.field("copy_tags", &self.copy_tags);
        formatter.field("licensing", &self.licensing);
        formatter.finish()
    }
}
/// See [`UpdateLaunchConfigurationOutput`](crate::output::UpdateLaunchConfigurationOutput)
pub mod update_launch_configuration_output {
    /// A builder for [`UpdateLaunchConfigurationOutput`](crate::output::UpdateLaunchConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) ec2_launch_template_id: std::option::Option<std::string::String>,
        pub(crate) launch_disposition: std::option::Option<crate::model::LaunchDisposition>,
        pub(crate) target_instance_type_right_sizing_method:
            std::option::Option<crate::model::TargetInstanceTypeRightSizingMethod>,
        pub(crate) copy_private_ip: std::option::Option<bool>,
        pub(crate) copy_tags: std::option::Option<bool>,
        pub(crate) licensing: std::option::Option<crate::model::Licensing>,
    }
    impl Builder {
        /// <p>The ID of the Source Server for this launch configuration.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>The ID of the Source Server for this launch configuration.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// <p>The name of the launch configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the launch configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The EC2 launch template ID of this launch configuration.</p>
        pub fn ec2_launch_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_launch_template_id = Some(input.into());
            self
        }
        /// <p>The EC2 launch template ID of this launch configuration.</p>
        pub fn set_ec2_launch_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_launch_template_id = input;
            self
        }
        /// <p>The state of the Recovery Instance in EC2 after the recovery operation.</p>
        pub fn launch_disposition(mut self, input: crate::model::LaunchDisposition) -> Self {
            self.launch_disposition = Some(input);
            self
        }
        /// <p>The state of the Recovery Instance in EC2 after the recovery operation.</p>
        pub fn set_launch_disposition(
            mut self,
            input: std::option::Option<crate::model::LaunchDisposition>,
        ) -> Self {
            self.launch_disposition = input;
            self
        }
        /// <p>Whether Elastic Disaster Recovery should try to automatically choose the instance type that best matches the OS, CPU, and RAM of your Source Server.</p>
        pub fn target_instance_type_right_sizing_method(
            mut self,
            input: crate::model::TargetInstanceTypeRightSizingMethod,
        ) -> Self {
            self.target_instance_type_right_sizing_method = Some(input);
            self
        }
        /// <p>Whether Elastic Disaster Recovery should try to automatically choose the instance type that best matches the OS, CPU, and RAM of your Source Server.</p>
        pub fn set_target_instance_type_right_sizing_method(
            mut self,
            input: std::option::Option<crate::model::TargetInstanceTypeRightSizingMethod>,
        ) -> Self {
            self.target_instance_type_right_sizing_method = input;
            self
        }
        /// <p>Whether we should copy the Private IP of the Source Server to the Recovery Instance.</p>
        pub fn copy_private_ip(mut self, input: bool) -> Self {
            self.copy_private_ip = Some(input);
            self
        }
        /// <p>Whether we should copy the Private IP of the Source Server to the Recovery Instance.</p>
        pub fn set_copy_private_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_private_ip = input;
            self
        }
        /// <p>Whether we want to copy the tags of the Source Server to the EC2 machine of the Recovery Instance.</p>
        pub fn copy_tags(mut self, input: bool) -> Self {
            self.copy_tags = Some(input);
            self
        }
        /// <p>Whether we want to copy the tags of the Source Server to the EC2 machine of the Recovery Instance.</p>
        pub fn set_copy_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_tags = input;
            self
        }
        /// <p>The licensing configuration to be used for this launch configuration.</p>
        pub fn licensing(mut self, input: crate::model::Licensing) -> Self {
            self.licensing = Some(input);
            self
        }
        /// <p>The licensing configuration to be used for this launch configuration.</p>
        pub fn set_licensing(
            mut self,
            input: std::option::Option<crate::model::Licensing>,
        ) -> Self {
            self.licensing = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateLaunchConfigurationOutput`](crate::output::UpdateLaunchConfigurationOutput)
        pub fn build(self) -> crate::output::UpdateLaunchConfigurationOutput {
            crate::output::UpdateLaunchConfigurationOutput {
                source_server_id: self.source_server_id,
                name: self.name,
                ec2_launch_template_id: self.ec2_launch_template_id,
                launch_disposition: self.launch_disposition,
                target_instance_type_right_sizing_method: self
                    .target_instance_type_right_sizing_method,
                copy_private_ip: self.copy_private_ip,
                copy_tags: self.copy_tags,
                licensing: self.licensing,
            }
        }
    }
}
impl UpdateLaunchConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateLaunchConfigurationOutput`](crate::output::UpdateLaunchConfigurationOutput)
    pub fn builder() -> crate::output::update_launch_configuration_output::Builder {
        crate::output::update_launch_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RetryDataReplicationOutput {
    /// <p>The ID of the Source Server.</p>
    pub source_server_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the Source Server.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The tags associated with the Source Server.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The ID of the Recovery Instance associated with this Source Server.</p>
    pub recovery_instance_id: std::option::Option<std::string::String>,
    /// <p>The status of the last recovery launch of this Source Server.</p>
    pub last_launch_result: std::option::Option<crate::model::LastLaunchResult>,
    /// <p>The Data Replication Info of the Source Server.</p>
    pub data_replication_info: std::option::Option<crate::model::DataReplicationInfo>,
    /// <p>The lifecycle information of this Source Server.</p>
    pub life_cycle: std::option::Option<crate::model::LifeCycle>,
    /// <p>The source properties of the Source Server.</p>
    pub source_properties: std::option::Option<crate::model::SourceProperties>,
}
impl RetryDataReplicationOutput {
    /// <p>The ID of the Source Server.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
    /// <p>The ARN of the Source Server.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The tags associated with the Source Server.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The ID of the Recovery Instance associated with this Source Server.</p>
    pub fn recovery_instance_id(&self) -> std::option::Option<&str> {
        self.recovery_instance_id.as_deref()
    }
    /// <p>The status of the last recovery launch of this Source Server.</p>
    pub fn last_launch_result(&self) -> std::option::Option<&crate::model::LastLaunchResult> {
        self.last_launch_result.as_ref()
    }
    /// <p>The Data Replication Info of the Source Server.</p>
    pub fn data_replication_info(&self) -> std::option::Option<&crate::model::DataReplicationInfo> {
        self.data_replication_info.as_ref()
    }
    /// <p>The lifecycle information of this Source Server.</p>
    pub fn life_cycle(&self) -> std::option::Option<&crate::model::LifeCycle> {
        self.life_cycle.as_ref()
    }
    /// <p>The source properties of the Source Server.</p>
    pub fn source_properties(&self) -> std::option::Option<&crate::model::SourceProperties> {
        self.source_properties.as_ref()
    }
}
impl std::fmt::Debug for RetryDataReplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RetryDataReplicationOutput");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.field("arn", &self.arn);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("recovery_instance_id", &self.recovery_instance_id);
        formatter.field("last_launch_result", &self.last_launch_result);
        formatter.field("data_replication_info", &self.data_replication_info);
        formatter.field("life_cycle", &self.life_cycle);
        formatter.field("source_properties", &self.source_properties);
        formatter.finish()
    }
}
/// See [`RetryDataReplicationOutput`](crate::output::RetryDataReplicationOutput)
pub mod retry_data_replication_output {
    /// A builder for [`RetryDataReplicationOutput`](crate::output::RetryDataReplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) recovery_instance_id: std::option::Option<std::string::String>,
        pub(crate) last_launch_result: std::option::Option<crate::model::LastLaunchResult>,
        pub(crate) data_replication_info: std::option::Option<crate::model::DataReplicationInfo>,
        pub(crate) life_cycle: std::option::Option<crate::model::LifeCycle>,
        pub(crate) source_properties: std::option::Option<crate::model::SourceProperties>,
    }
    impl Builder {
        /// <p>The ID of the Source Server.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>The ID of the Source Server.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// <p>The ARN of the Source Server.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Source Server.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the Source Server.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags associated with the Source Server.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The ID of the Recovery Instance associated with this Source Server.</p>
        pub fn recovery_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the Recovery Instance associated with this Source Server.</p>
        pub fn set_recovery_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_instance_id = input;
            self
        }
        /// <p>The status of the last recovery launch of this Source Server.</p>
        pub fn last_launch_result(mut self, input: crate::model::LastLaunchResult) -> Self {
            self.last_launch_result = Some(input);
            self
        }
        /// <p>The status of the last recovery launch of this Source Server.</p>
        pub fn set_last_launch_result(
            mut self,
            input: std::option::Option<crate::model::LastLaunchResult>,
        ) -> Self {
            self.last_launch_result = input;
            self
        }
        /// <p>The Data Replication Info of the Source Server.</p>
        pub fn data_replication_info(mut self, input: crate::model::DataReplicationInfo) -> Self {
            self.data_replication_info = Some(input);
            self
        }
        /// <p>The Data Replication Info of the Source Server.</p>
        pub fn set_data_replication_info(
            mut self,
            input: std::option::Option<crate::model::DataReplicationInfo>,
        ) -> Self {
            self.data_replication_info = input;
            self
        }
        /// <p>The lifecycle information of this Source Server.</p>
        pub fn life_cycle(mut self, input: crate::model::LifeCycle) -> Self {
            self.life_cycle = Some(input);
            self
        }
        /// <p>The lifecycle information of this Source Server.</p>
        pub fn set_life_cycle(
            mut self,
            input: std::option::Option<crate::model::LifeCycle>,
        ) -> Self {
            self.life_cycle = input;
            self
        }
        /// <p>The source properties of the Source Server.</p>
        pub fn source_properties(mut self, input: crate::model::SourceProperties) -> Self {
            self.source_properties = Some(input);
            self
        }
        /// <p>The source properties of the Source Server.</p>
        pub fn set_source_properties(
            mut self,
            input: std::option::Option<crate::model::SourceProperties>,
        ) -> Self {
            self.source_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`RetryDataReplicationOutput`](crate::output::RetryDataReplicationOutput)
        pub fn build(self) -> crate::output::RetryDataReplicationOutput {
            crate::output::RetryDataReplicationOutput {
                source_server_id: self.source_server_id,
                arn: self.arn,
                tags: self.tags,
                recovery_instance_id: self.recovery_instance_id,
                last_launch_result: self.last_launch_result,
                data_replication_info: self.data_replication_info,
                life_cycle: self.life_cycle,
                source_properties: self.source_properties,
            }
        }
    }
}
impl RetryDataReplicationOutput {
    /// Creates a new builder-style object to manufacture [`RetryDataReplicationOutput`](crate::output::RetryDataReplicationOutput)
    pub fn builder() -> crate::output::retry_data_replication_output::Builder {
        crate::output::retry_data_replication_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetReplicationConfigurationOutput {
    /// <p>The ID of the Source Server for this Replication Configuration.</p>
    pub source_server_id: std::option::Option<std::string::String>,
    /// <p>The name of the Replication Configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The subnet to be used by the replication staging area.</p>
    pub staging_area_subnet_id: std::option::Option<std::string::String>,
    /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration.</p>
    pub associate_default_security_group: std::option::Option<bool>,
    /// <p>The security group IDs that will be used by the replication server.</p>
    pub replication_servers_security_groups_i_ds:
        std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The instance type to be used for the replication server.</p>
    pub replication_server_instance_type: std::option::Option<std::string::String>,
    /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
    pub use_dedicated_replication_server: std::option::Option<bool>,
    /// <p>The Staging Disk EBS volume type to be used during replication.</p>
    pub default_large_staging_disk_type:
        std::option::Option<crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>,
    /// <p>The configuration of the disks of the Source Server to be replicated.</p>
    pub replicated_disks:
        std::option::Option<std::vec::Vec<crate::model::ReplicationConfigurationReplicatedDisk>>,
    /// <p>The type of EBS encryption to be used during replication.</p>
    pub ebs_encryption: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
    /// <p>The ARN of the EBS encryption key to be used during replication.</p>
    pub ebs_encryption_key_arn: std::option::Option<std::string::String>,
    /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
    pub bandwidth_throttling: i64,
    /// <p>The data plane routing mechanism that will be used for replication.</p>
    pub data_plane_routing:
        std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
    /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
    pub create_public_ip: std::option::Option<bool>,
    /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
    pub staging_area_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
    pub pit_policy: std::option::Option<std::vec::Vec<crate::model::PitPolicyRule>>,
}
impl GetReplicationConfigurationOutput {
    /// <p>The ID of the Source Server for this Replication Configuration.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
    /// <p>The name of the Replication Configuration.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The subnet to be used by the replication staging area.</p>
    pub fn staging_area_subnet_id(&self) -> std::option::Option<&str> {
        self.staging_area_subnet_id.as_deref()
    }
    /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration.</p>
    pub fn associate_default_security_group(&self) -> std::option::Option<bool> {
        self.associate_default_security_group
    }
    /// <p>The security group IDs that will be used by the replication server.</p>
    pub fn replication_servers_security_groups_i_ds(
        &self,
    ) -> std::option::Option<&[std::string::String]> {
        self.replication_servers_security_groups_i_ds.as_deref()
    }
    /// <p>The instance type to be used for the replication server.</p>
    pub fn replication_server_instance_type(&self) -> std::option::Option<&str> {
        self.replication_server_instance_type.as_deref()
    }
    /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
    pub fn use_dedicated_replication_server(&self) -> std::option::Option<bool> {
        self.use_dedicated_replication_server
    }
    /// <p>The Staging Disk EBS volume type to be used during replication.</p>
    pub fn default_large_staging_disk_type(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>
    {
        self.default_large_staging_disk_type.as_ref()
    }
    /// <p>The configuration of the disks of the Source Server to be replicated.</p>
    pub fn replicated_disks(
        &self,
    ) -> std::option::Option<&[crate::model::ReplicationConfigurationReplicatedDisk]> {
        self.replicated_disks.as_deref()
    }
    /// <p>The type of EBS encryption to be used during replication.</p>
    pub fn ebs_encryption(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationEbsEncryption> {
        self.ebs_encryption.as_ref()
    }
    /// <p>The ARN of the EBS encryption key to be used during replication.</p>
    pub fn ebs_encryption_key_arn(&self) -> std::option::Option<&str> {
        self.ebs_encryption_key_arn.as_deref()
    }
    /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
    pub fn bandwidth_throttling(&self) -> i64 {
        self.bandwidth_throttling
    }
    /// <p>The data plane routing mechanism that will be used for replication.</p>
    pub fn data_plane_routing(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationDataPlaneRouting> {
        self.data_plane_routing.as_ref()
    }
    /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
    pub fn create_public_ip(&self) -> std::option::Option<bool> {
        self.create_public_ip
    }
    /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
    pub fn staging_area_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.staging_area_tags.as_ref()
    }
    /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
    pub fn pit_policy(&self) -> std::option::Option<&[crate::model::PitPolicyRule]> {
        self.pit_policy.as_deref()
    }
}
impl std::fmt::Debug for GetReplicationConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetReplicationConfigurationOutput");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.field("name", &self.name);
        formatter.field("staging_area_subnet_id", &self.staging_area_subnet_id);
        formatter.field(
            "associate_default_security_group",
            &self.associate_default_security_group,
        );
        formatter.field(
            "replication_servers_security_groups_i_ds",
            &self.replication_servers_security_groups_i_ds,
        );
        formatter.field(
            "replication_server_instance_type",
            &self.replication_server_instance_type,
        );
        formatter.field(
            "use_dedicated_replication_server",
            &self.use_dedicated_replication_server,
        );
        formatter.field(
            "default_large_staging_disk_type",
            &self.default_large_staging_disk_type,
        );
        formatter.field("replicated_disks", &self.replicated_disks);
        formatter.field("ebs_encryption", &self.ebs_encryption);
        formatter.field("ebs_encryption_key_arn", &self.ebs_encryption_key_arn);
        formatter.field("bandwidth_throttling", &self.bandwidth_throttling);
        formatter.field("data_plane_routing", &self.data_plane_routing);
        formatter.field("create_public_ip", &self.create_public_ip);
        formatter.field("staging_area_tags", &"*** Sensitive Data Redacted ***");
        formatter.field("pit_policy", &self.pit_policy);
        formatter.finish()
    }
}
/// See [`GetReplicationConfigurationOutput`](crate::output::GetReplicationConfigurationOutput)
pub mod get_replication_configuration_output {
    /// A builder for [`GetReplicationConfigurationOutput`](crate::output::GetReplicationConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) staging_area_subnet_id: std::option::Option<std::string::String>,
        pub(crate) associate_default_security_group: std::option::Option<bool>,
        pub(crate) replication_servers_security_groups_i_ds:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) replication_server_instance_type: std::option::Option<std::string::String>,
        pub(crate) use_dedicated_replication_server: std::option::Option<bool>,
        pub(crate) default_large_staging_disk_type:
            std::option::Option<crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>,
        pub(crate) replicated_disks: std::option::Option<
            std::vec::Vec<crate::model::ReplicationConfigurationReplicatedDisk>,
        >,
        pub(crate) ebs_encryption:
            std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        pub(crate) ebs_encryption_key_arn: std::option::Option<std::string::String>,
        pub(crate) bandwidth_throttling: std::option::Option<i64>,
        pub(crate) data_plane_routing:
            std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        pub(crate) create_public_ip: std::option::Option<bool>,
        pub(crate) staging_area_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) pit_policy: std::option::Option<std::vec::Vec<crate::model::PitPolicyRule>>,
    }
    impl Builder {
        /// <p>The ID of the Source Server for this Replication Configuration.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>The ID of the Source Server for this Replication Configuration.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// <p>The name of the Replication Configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Replication Configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The subnet to be used by the replication staging area.</p>
        pub fn staging_area_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.staging_area_subnet_id = Some(input.into());
            self
        }
        /// <p>The subnet to be used by the replication staging area.</p>
        pub fn set_staging_area_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.staging_area_subnet_id = input;
            self
        }
        /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration.</p>
        pub fn associate_default_security_group(mut self, input: bool) -> Self {
            self.associate_default_security_group = Some(input);
            self
        }
        /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration.</p>
        pub fn set_associate_default_security_group(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.associate_default_security_group = input;
            self
        }
        /// Appends an item to `replication_servers_security_groups_i_ds`.
        ///
        /// To override the contents of this collection use [`set_replication_servers_security_groups_i_ds`](Self::set_replication_servers_security_groups_i_ds).
        ///
        /// <p>The security group IDs that will be used by the replication server.</p>
        pub fn replication_servers_security_groups_i_ds(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self
                .replication_servers_security_groups_i_ds
                .unwrap_or_default();
            v.push(input.into());
            self.replication_servers_security_groups_i_ds = Some(v);
            self
        }
        /// <p>The security group IDs that will be used by the replication server.</p>
        pub fn set_replication_servers_security_groups_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.replication_servers_security_groups_i_ds = input;
            self
        }
        /// <p>The instance type to be used for the replication server.</p>
        pub fn replication_server_instance_type(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_server_instance_type = Some(input.into());
            self
        }
        /// <p>The instance type to be used for the replication server.</p>
        pub fn set_replication_server_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_server_instance_type = input;
            self
        }
        /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
        pub fn use_dedicated_replication_server(mut self, input: bool) -> Self {
            self.use_dedicated_replication_server = Some(input);
            self
        }
        /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
        pub fn set_use_dedicated_replication_server(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.use_dedicated_replication_server = input;
            self
        }
        /// <p>The Staging Disk EBS volume type to be used during replication.</p>
        pub fn default_large_staging_disk_type(
            mut self,
            input: crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
        ) -> Self {
            self.default_large_staging_disk_type = Some(input);
            self
        }
        /// <p>The Staging Disk EBS volume type to be used during replication.</p>
        pub fn set_default_large_staging_disk_type(
            mut self,
            input: std::option::Option<
                crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
            >,
        ) -> Self {
            self.default_large_staging_disk_type = input;
            self
        }
        /// Appends an item to `replicated_disks`.
        ///
        /// To override the contents of this collection use [`set_replicated_disks`](Self::set_replicated_disks).
        ///
        /// <p>The configuration of the disks of the Source Server to be replicated.</p>
        pub fn replicated_disks(
            mut self,
            input: impl Into<crate::model::ReplicationConfigurationReplicatedDisk>,
        ) -> Self {
            let mut v = self.replicated_disks.unwrap_or_default();
            v.push(input.into());
            self.replicated_disks = Some(v);
            self
        }
        /// <p>The configuration of the disks of the Source Server to be replicated.</p>
        pub fn set_replicated_disks(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ReplicationConfigurationReplicatedDisk>,
            >,
        ) -> Self {
            self.replicated_disks = input;
            self
        }
        /// <p>The type of EBS encryption to be used during replication.</p>
        pub fn ebs_encryption(
            mut self,
            input: crate::model::ReplicationConfigurationEbsEncryption,
        ) -> Self {
            self.ebs_encryption = Some(input);
            self
        }
        /// <p>The type of EBS encryption to be used during replication.</p>
        pub fn set_ebs_encryption(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        ) -> Self {
            self.ebs_encryption = input;
            self
        }
        /// <p>The ARN of the EBS encryption key to be used during replication.</p>
        pub fn ebs_encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ebs_encryption_key_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the EBS encryption key to be used during replication.</p>
        pub fn set_ebs_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ebs_encryption_key_arn = input;
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
        pub fn bandwidth_throttling(mut self, input: i64) -> Self {
            self.bandwidth_throttling = Some(input);
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
        pub fn set_bandwidth_throttling(mut self, input: std::option::Option<i64>) -> Self {
            self.bandwidth_throttling = input;
            self
        }
        /// <p>The data plane routing mechanism that will be used for replication.</p>
        pub fn data_plane_routing(
            mut self,
            input: crate::model::ReplicationConfigurationDataPlaneRouting,
        ) -> Self {
            self.data_plane_routing = Some(input);
            self
        }
        /// <p>The data plane routing mechanism that will be used for replication.</p>
        pub fn set_data_plane_routing(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        ) -> Self {
            self.data_plane_routing = input;
            self
        }
        /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
        pub fn create_public_ip(mut self, input: bool) -> Self {
            self.create_public_ip = Some(input);
            self
        }
        /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
        pub fn set_create_public_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.create_public_ip = input;
            self
        }
        /// Adds a key-value pair to `staging_area_tags`.
        ///
        /// To override the contents of this collection use [`set_staging_area_tags`](Self::set_staging_area_tags).
        ///
        /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
        pub fn staging_area_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.staging_area_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.staging_area_tags = Some(hash_map);
            self
        }
        /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
        pub fn set_staging_area_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.staging_area_tags = input;
            self
        }
        /// Appends an item to `pit_policy`.
        ///
        /// To override the contents of this collection use [`set_pit_policy`](Self::set_pit_policy).
        ///
        /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
        pub fn pit_policy(mut self, input: impl Into<crate::model::PitPolicyRule>) -> Self {
            let mut v = self.pit_policy.unwrap_or_default();
            v.push(input.into());
            self.pit_policy = Some(v);
            self
        }
        /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
        pub fn set_pit_policy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PitPolicyRule>>,
        ) -> Self {
            self.pit_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetReplicationConfigurationOutput`](crate::output::GetReplicationConfigurationOutput)
        pub fn build(self) -> crate::output::GetReplicationConfigurationOutput {
            crate::output::GetReplicationConfigurationOutput {
                source_server_id: self.source_server_id,
                name: self.name,
                staging_area_subnet_id: self.staging_area_subnet_id,
                associate_default_security_group: self.associate_default_security_group,
                replication_servers_security_groups_i_ds: self
                    .replication_servers_security_groups_i_ds,
                replication_server_instance_type: self.replication_server_instance_type,
                use_dedicated_replication_server: self.use_dedicated_replication_server,
                default_large_staging_disk_type: self.default_large_staging_disk_type,
                replicated_disks: self.replicated_disks,
                ebs_encryption: self.ebs_encryption,
                ebs_encryption_key_arn: self.ebs_encryption_key_arn,
                bandwidth_throttling: self.bandwidth_throttling.unwrap_or_default(),
                data_plane_routing: self.data_plane_routing,
                create_public_ip: self.create_public_ip,
                staging_area_tags: self.staging_area_tags,
                pit_policy: self.pit_policy,
            }
        }
    }
}
impl GetReplicationConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`GetReplicationConfigurationOutput`](crate::output::GetReplicationConfigurationOutput)
    pub fn builder() -> crate::output::get_replication_configuration_output::Builder {
        crate::output::get_replication_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLaunchConfigurationOutput {
    /// <p>The ID of the Source Server for this launch configuration.</p>
    pub source_server_id: std::option::Option<std::string::String>,
    /// <p>The name of the launch configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The EC2 launch template ID of this launch configuration.</p>
    pub ec2_launch_template_id: std::option::Option<std::string::String>,
    /// <p>The state of the Recovery Instance in EC2 after the recovery operation.</p>
    pub launch_disposition: std::option::Option<crate::model::LaunchDisposition>,
    /// <p>Whether Elastic Disaster Recovery should try to automatically choose the instance type that best matches the OS, CPU, and RAM of your Source Server.</p>
    pub target_instance_type_right_sizing_method:
        std::option::Option<crate::model::TargetInstanceTypeRightSizingMethod>,
    /// <p>Whether we should copy the Private IP of the Source Server to the Recovery Instance.</p>
    pub copy_private_ip: std::option::Option<bool>,
    /// <p>Whether we want to copy the tags of the Source Server to the EC2 machine of the Recovery Instance.</p>
    pub copy_tags: std::option::Option<bool>,
    /// <p>The licensing configuration to be used for this launch configuration.</p>
    pub licensing: std::option::Option<crate::model::Licensing>,
}
impl GetLaunchConfigurationOutput {
    /// <p>The ID of the Source Server for this launch configuration.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
    /// <p>The name of the launch configuration.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The EC2 launch template ID of this launch configuration.</p>
    pub fn ec2_launch_template_id(&self) -> std::option::Option<&str> {
        self.ec2_launch_template_id.as_deref()
    }
    /// <p>The state of the Recovery Instance in EC2 after the recovery operation.</p>
    pub fn launch_disposition(&self) -> std::option::Option<&crate::model::LaunchDisposition> {
        self.launch_disposition.as_ref()
    }
    /// <p>Whether Elastic Disaster Recovery should try to automatically choose the instance type that best matches the OS, CPU, and RAM of your Source Server.</p>
    pub fn target_instance_type_right_sizing_method(
        &self,
    ) -> std::option::Option<&crate::model::TargetInstanceTypeRightSizingMethod> {
        self.target_instance_type_right_sizing_method.as_ref()
    }
    /// <p>Whether we should copy the Private IP of the Source Server to the Recovery Instance.</p>
    pub fn copy_private_ip(&self) -> std::option::Option<bool> {
        self.copy_private_ip
    }
    /// <p>Whether we want to copy the tags of the Source Server to the EC2 machine of the Recovery Instance.</p>
    pub fn copy_tags(&self) -> std::option::Option<bool> {
        self.copy_tags
    }
    /// <p>The licensing configuration to be used for this launch configuration.</p>
    pub fn licensing(&self) -> std::option::Option<&crate::model::Licensing> {
        self.licensing.as_ref()
    }
}
impl std::fmt::Debug for GetLaunchConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLaunchConfigurationOutput");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.field("name", &self.name);
        formatter.field("ec2_launch_template_id", &self.ec2_launch_template_id);
        formatter.field("launch_disposition", &self.launch_disposition);
        formatter.field(
            "target_instance_type_right_sizing_method",
            &self.target_instance_type_right_sizing_method,
        );
        formatter.field("copy_private_ip", &self.copy_private_ip);
        formatter.field("copy_tags", &self.copy_tags);
        formatter.field("licensing", &self.licensing);
        formatter.finish()
    }
}
/// See [`GetLaunchConfigurationOutput`](crate::output::GetLaunchConfigurationOutput)
pub mod get_launch_configuration_output {
    /// A builder for [`GetLaunchConfigurationOutput`](crate::output::GetLaunchConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) ec2_launch_template_id: std::option::Option<std::string::String>,
        pub(crate) launch_disposition: std::option::Option<crate::model::LaunchDisposition>,
        pub(crate) target_instance_type_right_sizing_method:
            std::option::Option<crate::model::TargetInstanceTypeRightSizingMethod>,
        pub(crate) copy_private_ip: std::option::Option<bool>,
        pub(crate) copy_tags: std::option::Option<bool>,
        pub(crate) licensing: std::option::Option<crate::model::Licensing>,
    }
    impl Builder {
        /// <p>The ID of the Source Server for this launch configuration.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>The ID of the Source Server for this launch configuration.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// <p>The name of the launch configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the launch configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The EC2 launch template ID of this launch configuration.</p>
        pub fn ec2_launch_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_launch_template_id = Some(input.into());
            self
        }
        /// <p>The EC2 launch template ID of this launch configuration.</p>
        pub fn set_ec2_launch_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_launch_template_id = input;
            self
        }
        /// <p>The state of the Recovery Instance in EC2 after the recovery operation.</p>
        pub fn launch_disposition(mut self, input: crate::model::LaunchDisposition) -> Self {
            self.launch_disposition = Some(input);
            self
        }
        /// <p>The state of the Recovery Instance in EC2 after the recovery operation.</p>
        pub fn set_launch_disposition(
            mut self,
            input: std::option::Option<crate::model::LaunchDisposition>,
        ) -> Self {
            self.launch_disposition = input;
            self
        }
        /// <p>Whether Elastic Disaster Recovery should try to automatically choose the instance type that best matches the OS, CPU, and RAM of your Source Server.</p>
        pub fn target_instance_type_right_sizing_method(
            mut self,
            input: crate::model::TargetInstanceTypeRightSizingMethod,
        ) -> Self {
            self.target_instance_type_right_sizing_method = Some(input);
            self
        }
        /// <p>Whether Elastic Disaster Recovery should try to automatically choose the instance type that best matches the OS, CPU, and RAM of your Source Server.</p>
        pub fn set_target_instance_type_right_sizing_method(
            mut self,
            input: std::option::Option<crate::model::TargetInstanceTypeRightSizingMethod>,
        ) -> Self {
            self.target_instance_type_right_sizing_method = input;
            self
        }
        /// <p>Whether we should copy the Private IP of the Source Server to the Recovery Instance.</p>
        pub fn copy_private_ip(mut self, input: bool) -> Self {
            self.copy_private_ip = Some(input);
            self
        }
        /// <p>Whether we should copy the Private IP of the Source Server to the Recovery Instance.</p>
        pub fn set_copy_private_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_private_ip = input;
            self
        }
        /// <p>Whether we want to copy the tags of the Source Server to the EC2 machine of the Recovery Instance.</p>
        pub fn copy_tags(mut self, input: bool) -> Self {
            self.copy_tags = Some(input);
            self
        }
        /// <p>Whether we want to copy the tags of the Source Server to the EC2 machine of the Recovery Instance.</p>
        pub fn set_copy_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_tags = input;
            self
        }
        /// <p>The licensing configuration to be used for this launch configuration.</p>
        pub fn licensing(mut self, input: crate::model::Licensing) -> Self {
            self.licensing = Some(input);
            self
        }
        /// <p>The licensing configuration to be used for this launch configuration.</p>
        pub fn set_licensing(
            mut self,
            input: std::option::Option<crate::model::Licensing>,
        ) -> Self {
            self.licensing = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLaunchConfigurationOutput`](crate::output::GetLaunchConfigurationOutput)
        pub fn build(self) -> crate::output::GetLaunchConfigurationOutput {
            crate::output::GetLaunchConfigurationOutput {
                source_server_id: self.source_server_id,
                name: self.name,
                ec2_launch_template_id: self.ec2_launch_template_id,
                launch_disposition: self.launch_disposition,
                target_instance_type_right_sizing_method: self
                    .target_instance_type_right_sizing_method,
                copy_private_ip: self.copy_private_ip,
                copy_tags: self.copy_tags,
                licensing: self.licensing,
            }
        }
    }
}
impl GetLaunchConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`GetLaunchConfigurationOutput`](crate::output::GetLaunchConfigurationOutput)
    pub fn builder() -> crate::output::get_launch_configuration_output::Builder {
        crate::output::get_launch_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisconnectSourceServerOutput {
    /// <p>The ID of the Source Server.</p>
    pub source_server_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the Source Server.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The tags associated with the Source Server.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The ID of the Recovery Instance associated with this Source Server.</p>
    pub recovery_instance_id: std::option::Option<std::string::String>,
    /// <p>The status of the last recovery launch of this Source Server.</p>
    pub last_launch_result: std::option::Option<crate::model::LastLaunchResult>,
    /// <p>The Data Replication Info of the Source Server.</p>
    pub data_replication_info: std::option::Option<crate::model::DataReplicationInfo>,
    /// <p>The lifecycle information of this Source Server.</p>
    pub life_cycle: std::option::Option<crate::model::LifeCycle>,
    /// <p>The source properties of the Source Server.</p>
    pub source_properties: std::option::Option<crate::model::SourceProperties>,
}
impl DisconnectSourceServerOutput {
    /// <p>The ID of the Source Server.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
    /// <p>The ARN of the Source Server.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The tags associated with the Source Server.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The ID of the Recovery Instance associated with this Source Server.</p>
    pub fn recovery_instance_id(&self) -> std::option::Option<&str> {
        self.recovery_instance_id.as_deref()
    }
    /// <p>The status of the last recovery launch of this Source Server.</p>
    pub fn last_launch_result(&self) -> std::option::Option<&crate::model::LastLaunchResult> {
        self.last_launch_result.as_ref()
    }
    /// <p>The Data Replication Info of the Source Server.</p>
    pub fn data_replication_info(&self) -> std::option::Option<&crate::model::DataReplicationInfo> {
        self.data_replication_info.as_ref()
    }
    /// <p>The lifecycle information of this Source Server.</p>
    pub fn life_cycle(&self) -> std::option::Option<&crate::model::LifeCycle> {
        self.life_cycle.as_ref()
    }
    /// <p>The source properties of the Source Server.</p>
    pub fn source_properties(&self) -> std::option::Option<&crate::model::SourceProperties> {
        self.source_properties.as_ref()
    }
}
impl std::fmt::Debug for DisconnectSourceServerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisconnectSourceServerOutput");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.field("arn", &self.arn);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("recovery_instance_id", &self.recovery_instance_id);
        formatter.field("last_launch_result", &self.last_launch_result);
        formatter.field("data_replication_info", &self.data_replication_info);
        formatter.field("life_cycle", &self.life_cycle);
        formatter.field("source_properties", &self.source_properties);
        formatter.finish()
    }
}
/// See [`DisconnectSourceServerOutput`](crate::output::DisconnectSourceServerOutput)
pub mod disconnect_source_server_output {
    /// A builder for [`DisconnectSourceServerOutput`](crate::output::DisconnectSourceServerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) recovery_instance_id: std::option::Option<std::string::String>,
        pub(crate) last_launch_result: std::option::Option<crate::model::LastLaunchResult>,
        pub(crate) data_replication_info: std::option::Option<crate::model::DataReplicationInfo>,
        pub(crate) life_cycle: std::option::Option<crate::model::LifeCycle>,
        pub(crate) source_properties: std::option::Option<crate::model::SourceProperties>,
    }
    impl Builder {
        /// <p>The ID of the Source Server.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>The ID of the Source Server.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// <p>The ARN of the Source Server.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Source Server.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the Source Server.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags associated with the Source Server.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The ID of the Recovery Instance associated with this Source Server.</p>
        pub fn recovery_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the Recovery Instance associated with this Source Server.</p>
        pub fn set_recovery_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_instance_id = input;
            self
        }
        /// <p>The status of the last recovery launch of this Source Server.</p>
        pub fn last_launch_result(mut self, input: crate::model::LastLaunchResult) -> Self {
            self.last_launch_result = Some(input);
            self
        }
        /// <p>The status of the last recovery launch of this Source Server.</p>
        pub fn set_last_launch_result(
            mut self,
            input: std::option::Option<crate::model::LastLaunchResult>,
        ) -> Self {
            self.last_launch_result = input;
            self
        }
        /// <p>The Data Replication Info of the Source Server.</p>
        pub fn data_replication_info(mut self, input: crate::model::DataReplicationInfo) -> Self {
            self.data_replication_info = Some(input);
            self
        }
        /// <p>The Data Replication Info of the Source Server.</p>
        pub fn set_data_replication_info(
            mut self,
            input: std::option::Option<crate::model::DataReplicationInfo>,
        ) -> Self {
            self.data_replication_info = input;
            self
        }
        /// <p>The lifecycle information of this Source Server.</p>
        pub fn life_cycle(mut self, input: crate::model::LifeCycle) -> Self {
            self.life_cycle = Some(input);
            self
        }
        /// <p>The lifecycle information of this Source Server.</p>
        pub fn set_life_cycle(
            mut self,
            input: std::option::Option<crate::model::LifeCycle>,
        ) -> Self {
            self.life_cycle = input;
            self
        }
        /// <p>The source properties of the Source Server.</p>
        pub fn source_properties(mut self, input: crate::model::SourceProperties) -> Self {
            self.source_properties = Some(input);
            self
        }
        /// <p>The source properties of the Source Server.</p>
        pub fn set_source_properties(
            mut self,
            input: std::option::Option<crate::model::SourceProperties>,
        ) -> Self {
            self.source_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`DisconnectSourceServerOutput`](crate::output::DisconnectSourceServerOutput)
        pub fn build(self) -> crate::output::DisconnectSourceServerOutput {
            crate::output::DisconnectSourceServerOutput {
                source_server_id: self.source_server_id,
                arn: self.arn,
                tags: self.tags,
                recovery_instance_id: self.recovery_instance_id,
                last_launch_result: self.last_launch_result,
                data_replication_info: self.data_replication_info,
                life_cycle: self.life_cycle,
                source_properties: self.source_properties,
            }
        }
    }
}
impl DisconnectSourceServerOutput {
    /// Creates a new builder-style object to manufacture [`DisconnectSourceServerOutput`](crate::output::DisconnectSourceServerOutput)
    pub fn builder() -> crate::output::disconnect_source_server_output::Builder {
        crate::output::disconnect_source_server_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRecoverySnapshotsOutput {
    /// <p>An array of Recovery Snapshots.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::RecoverySnapshot>>,
    /// <p>The token of the next Recovery Snapshot to retrieve.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeRecoverySnapshotsOutput {
    /// <p>An array of Recovery Snapshots.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::RecoverySnapshot]> {
        self.items.as_deref()
    }
    /// <p>The token of the next Recovery Snapshot to retrieve.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeRecoverySnapshotsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRecoverySnapshotsOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeRecoverySnapshotsOutput`](crate::output::DescribeRecoverySnapshotsOutput)
pub mod describe_recovery_snapshots_output {
    /// A builder for [`DescribeRecoverySnapshotsOutput`](crate::output::DescribeRecoverySnapshotsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::RecoverySnapshot>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>An array of Recovery Snapshots.</p>
        pub fn items(mut self, input: impl Into<crate::model::RecoverySnapshot>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>An array of Recovery Snapshots.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecoverySnapshot>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The token of the next Recovery Snapshot to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token of the next Recovery Snapshot to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRecoverySnapshotsOutput`](crate::output::DescribeRecoverySnapshotsOutput)
        pub fn build(self) -> crate::output::DescribeRecoverySnapshotsOutput {
            crate::output::DescribeRecoverySnapshotsOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeRecoverySnapshotsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeRecoverySnapshotsOutput`](crate::output::DescribeRecoverySnapshotsOutput)
    pub fn builder() -> crate::output::describe_recovery_snapshots_output::Builder {
        crate::output::describe_recovery_snapshots_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartRecoveryOutput {
    /// <p>The Recovery Job.</p>
    pub job: std::option::Option<crate::model::Job>,
}
impl StartRecoveryOutput {
    /// <p>The Recovery Job.</p>
    pub fn job(&self) -> std::option::Option<&crate::model::Job> {
        self.job.as_ref()
    }
}
impl std::fmt::Debug for StartRecoveryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartRecoveryOutput");
        formatter.field("job", &self.job);
        formatter.finish()
    }
}
/// See [`StartRecoveryOutput`](crate::output::StartRecoveryOutput)
pub mod start_recovery_output {
    /// A builder for [`StartRecoveryOutput`](crate::output::StartRecoveryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job: std::option::Option<crate::model::Job>,
    }
    impl Builder {
        /// <p>The Recovery Job.</p>
        pub fn job(mut self, input: crate::model::Job) -> Self {
            self.job = Some(input);
            self
        }
        /// <p>The Recovery Job.</p>
        pub fn set_job(mut self, input: std::option::Option<crate::model::Job>) -> Self {
            self.job = input;
            self
        }
        /// Consumes the builder and constructs a [`StartRecoveryOutput`](crate::output::StartRecoveryOutput)
        pub fn build(self) -> crate::output::StartRecoveryOutput {
            crate::output::StartRecoveryOutput { job: self.job }
        }
    }
}
impl StartRecoveryOutput {
    /// Creates a new builder-style object to manufacture [`StartRecoveryOutput`](crate::output::StartRecoveryOutput)
    pub fn builder() -> crate::output::start_recovery_output::Builder {
        crate::output::start_recovery_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSourceServersOutput {
    /// <p>An array of Source Servers.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::SourceServer>>,
    /// <p>The token of the next Source Server to retrieve.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeSourceServersOutput {
    /// <p>An array of Source Servers.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::SourceServer]> {
        self.items.as_deref()
    }
    /// <p>The token of the next Source Server to retrieve.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeSourceServersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSourceServersOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeSourceServersOutput`](crate::output::DescribeSourceServersOutput)
pub mod describe_source_servers_output {
    /// A builder for [`DescribeSourceServersOutput`](crate::output::DescribeSourceServersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::SourceServer>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>An array of Source Servers.</p>
        pub fn items(mut self, input: impl Into<crate::model::SourceServer>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>An array of Source Servers.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SourceServer>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The token of the next Source Server to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token of the next Source Server to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSourceServersOutput`](crate::output::DescribeSourceServersOutput)
        pub fn build(self) -> crate::output::DescribeSourceServersOutput {
            crate::output::DescribeSourceServersOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeSourceServersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSourceServersOutput`](crate::output::DescribeSourceServersOutput)
    pub fn builder() -> crate::output::describe_source_servers_output::Builder {
        crate::output::describe_source_servers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSourceServerOutput {}
impl std::fmt::Debug for DeleteSourceServerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSourceServerOutput");
        formatter.finish()
    }
}
/// See [`DeleteSourceServerOutput`](crate::output::DeleteSourceServerOutput)
pub mod delete_source_server_output {
    /// A builder for [`DeleteSourceServerOutput`](crate::output::DeleteSourceServerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteSourceServerOutput`](crate::output::DeleteSourceServerOutput)
        pub fn build(self) -> crate::output::DeleteSourceServerOutput {
            crate::output::DeleteSourceServerOutput {}
        }
    }
}
impl DeleteSourceServerOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSourceServerOutput`](crate::output::DeleteSourceServerOutput)
    pub fn builder() -> crate::output::delete_source_server_output::Builder {
        crate::output::delete_source_server_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReplicationConfigurationTemplatesOutput {
    /// <p>An array of Replication Configuration Templates.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::ReplicationConfigurationTemplate>>,
    /// <p>The token of the next Replication Configuration Template to retrieve.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeReplicationConfigurationTemplatesOutput {
    /// <p>An array of Replication Configuration Templates.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::ReplicationConfigurationTemplate]> {
        self.items.as_deref()
    }
    /// <p>The token of the next Replication Configuration Template to retrieve.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeReplicationConfigurationTemplatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReplicationConfigurationTemplatesOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeReplicationConfigurationTemplatesOutput`](crate::output::DescribeReplicationConfigurationTemplatesOutput)
pub mod describe_replication_configuration_templates_output {
    /// A builder for [`DescribeReplicationConfigurationTemplatesOutput`](crate::output::DescribeReplicationConfigurationTemplatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items:
            std::option::Option<std::vec::Vec<crate::model::ReplicationConfigurationTemplate>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>An array of Replication Configuration Templates.</p>
        pub fn items(
            mut self,
            input: impl Into<crate::model::ReplicationConfigurationTemplate>,
        ) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>An array of Replication Configuration Templates.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ReplicationConfigurationTemplate>,
            >,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The token of the next Replication Configuration Template to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token of the next Replication Configuration Template to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReplicationConfigurationTemplatesOutput`](crate::output::DescribeReplicationConfigurationTemplatesOutput)
        pub fn build(self) -> crate::output::DescribeReplicationConfigurationTemplatesOutput {
            crate::output::DescribeReplicationConfigurationTemplatesOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeReplicationConfigurationTemplatesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeReplicationConfigurationTemplatesOutput`](crate::output::DescribeReplicationConfigurationTemplatesOutput)
    pub fn builder() -> crate::output::describe_replication_configuration_templates_output::Builder
    {
        crate::output::describe_replication_configuration_templates_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateReplicationConfigurationTemplateOutput {
    /// <p>The Replication Configuration Template ID.</p>
    pub replication_configuration_template_id: std::option::Option<std::string::String>,
    /// <p>The Replication Configuration Template ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The subnet to be used by the replication staging area.</p>
    pub staging_area_subnet_id: std::option::Option<std::string::String>,
    /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>
    pub associate_default_security_group: std::option::Option<bool>,
    /// <p>The security group IDs that will be used by the replication server.</p>
    pub replication_servers_security_groups_i_ds:
        std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The instance type to be used for the replication server.</p>
    pub replication_server_instance_type: std::option::Option<std::string::String>,
    /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
    pub use_dedicated_replication_server: std::option::Option<bool>,
    /// <p>The Staging Disk EBS volume type to be used during replication.</p>
    pub default_large_staging_disk_type:
        std::option::Option<crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>,
    /// <p>The type of EBS encryption to be used during replication.</p>
    pub ebs_encryption: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
    /// <p>The ARN of the EBS encryption key to be used during replication.</p>
    pub ebs_encryption_key_arn: std::option::Option<std::string::String>,
    /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
    pub bandwidth_throttling: i64,
    /// <p>The data plane routing mechanism that will be used for replication.</p>
    pub data_plane_routing:
        std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
    /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
    pub create_public_ip: std::option::Option<bool>,
    /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
    pub staging_area_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A set of tags to be associated with the Replication Configuration Template resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
    pub pit_policy: std::option::Option<std::vec::Vec<crate::model::PitPolicyRule>>,
}
impl CreateReplicationConfigurationTemplateOutput {
    /// <p>The Replication Configuration Template ID.</p>
    pub fn replication_configuration_template_id(&self) -> std::option::Option<&str> {
        self.replication_configuration_template_id.as_deref()
    }
    /// <p>The Replication Configuration Template ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The subnet to be used by the replication staging area.</p>
    pub fn staging_area_subnet_id(&self) -> std::option::Option<&str> {
        self.staging_area_subnet_id.as_deref()
    }
    /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>
    pub fn associate_default_security_group(&self) -> std::option::Option<bool> {
        self.associate_default_security_group
    }
    /// <p>The security group IDs that will be used by the replication server.</p>
    pub fn replication_servers_security_groups_i_ds(
        &self,
    ) -> std::option::Option<&[std::string::String]> {
        self.replication_servers_security_groups_i_ds.as_deref()
    }
    /// <p>The instance type to be used for the replication server.</p>
    pub fn replication_server_instance_type(&self) -> std::option::Option<&str> {
        self.replication_server_instance_type.as_deref()
    }
    /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
    pub fn use_dedicated_replication_server(&self) -> std::option::Option<bool> {
        self.use_dedicated_replication_server
    }
    /// <p>The Staging Disk EBS volume type to be used during replication.</p>
    pub fn default_large_staging_disk_type(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>
    {
        self.default_large_staging_disk_type.as_ref()
    }
    /// <p>The type of EBS encryption to be used during replication.</p>
    pub fn ebs_encryption(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationEbsEncryption> {
        self.ebs_encryption.as_ref()
    }
    /// <p>The ARN of the EBS encryption key to be used during replication.</p>
    pub fn ebs_encryption_key_arn(&self) -> std::option::Option<&str> {
        self.ebs_encryption_key_arn.as_deref()
    }
    /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
    pub fn bandwidth_throttling(&self) -> i64 {
        self.bandwidth_throttling
    }
    /// <p>The data plane routing mechanism that will be used for replication.</p>
    pub fn data_plane_routing(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationDataPlaneRouting> {
        self.data_plane_routing.as_ref()
    }
    /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
    pub fn create_public_ip(&self) -> std::option::Option<bool> {
        self.create_public_ip
    }
    /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
    pub fn staging_area_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.staging_area_tags.as_ref()
    }
    /// <p>A set of tags to be associated with the Replication Configuration Template resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
    pub fn pit_policy(&self) -> std::option::Option<&[crate::model::PitPolicyRule]> {
        self.pit_policy.as_deref()
    }
}
impl std::fmt::Debug for CreateReplicationConfigurationTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateReplicationConfigurationTemplateOutput");
        formatter.field(
            "replication_configuration_template_id",
            &self.replication_configuration_template_id,
        );
        formatter.field("arn", &self.arn);
        formatter.field("staging_area_subnet_id", &self.staging_area_subnet_id);
        formatter.field(
            "associate_default_security_group",
            &self.associate_default_security_group,
        );
        formatter.field(
            "replication_servers_security_groups_i_ds",
            &self.replication_servers_security_groups_i_ds,
        );
        formatter.field(
            "replication_server_instance_type",
            &self.replication_server_instance_type,
        );
        formatter.field(
            "use_dedicated_replication_server",
            &self.use_dedicated_replication_server,
        );
        formatter.field(
            "default_large_staging_disk_type",
            &self.default_large_staging_disk_type,
        );
        formatter.field("ebs_encryption", &self.ebs_encryption);
        formatter.field("ebs_encryption_key_arn", &self.ebs_encryption_key_arn);
        formatter.field("bandwidth_throttling", &self.bandwidth_throttling);
        formatter.field("data_plane_routing", &self.data_plane_routing);
        formatter.field("create_public_ip", &self.create_public_ip);
        formatter.field("staging_area_tags", &"*** Sensitive Data Redacted ***");
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("pit_policy", &self.pit_policy);
        formatter.finish()
    }
}
/// See [`CreateReplicationConfigurationTemplateOutput`](crate::output::CreateReplicationConfigurationTemplateOutput)
pub mod create_replication_configuration_template_output {
    /// A builder for [`CreateReplicationConfigurationTemplateOutput`](crate::output::CreateReplicationConfigurationTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_configuration_template_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) staging_area_subnet_id: std::option::Option<std::string::String>,
        pub(crate) associate_default_security_group: std::option::Option<bool>,
        pub(crate) replication_servers_security_groups_i_ds:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) replication_server_instance_type: std::option::Option<std::string::String>,
        pub(crate) use_dedicated_replication_server: std::option::Option<bool>,
        pub(crate) default_large_staging_disk_type:
            std::option::Option<crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>,
        pub(crate) ebs_encryption:
            std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        pub(crate) ebs_encryption_key_arn: std::option::Option<std::string::String>,
        pub(crate) bandwidth_throttling: std::option::Option<i64>,
        pub(crate) data_plane_routing:
            std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        pub(crate) create_public_ip: std::option::Option<bool>,
        pub(crate) staging_area_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) pit_policy: std::option::Option<std::vec::Vec<crate::model::PitPolicyRule>>,
    }
    impl Builder {
        /// <p>The Replication Configuration Template ID.</p>
        pub fn replication_configuration_template_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_configuration_template_id = Some(input.into());
            self
        }
        /// <p>The Replication Configuration Template ID.</p>
        pub fn set_replication_configuration_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_configuration_template_id = input;
            self
        }
        /// <p>The Replication Configuration Template ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Replication Configuration Template ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The subnet to be used by the replication staging area.</p>
        pub fn staging_area_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.staging_area_subnet_id = Some(input.into());
            self
        }
        /// <p>The subnet to be used by the replication staging area.</p>
        pub fn set_staging_area_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.staging_area_subnet_id = input;
            self
        }
        /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>
        pub fn associate_default_security_group(mut self, input: bool) -> Self {
            self.associate_default_security_group = Some(input);
            self
        }
        /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>
        pub fn set_associate_default_security_group(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.associate_default_security_group = input;
            self
        }
        /// Appends an item to `replication_servers_security_groups_i_ds`.
        ///
        /// To override the contents of this collection use [`set_replication_servers_security_groups_i_ds`](Self::set_replication_servers_security_groups_i_ds).
        ///
        /// <p>The security group IDs that will be used by the replication server.</p>
        pub fn replication_servers_security_groups_i_ds(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self
                .replication_servers_security_groups_i_ds
                .unwrap_or_default();
            v.push(input.into());
            self.replication_servers_security_groups_i_ds = Some(v);
            self
        }
        /// <p>The security group IDs that will be used by the replication server.</p>
        pub fn set_replication_servers_security_groups_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.replication_servers_security_groups_i_ds = input;
            self
        }
        /// <p>The instance type to be used for the replication server.</p>
        pub fn replication_server_instance_type(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_server_instance_type = Some(input.into());
            self
        }
        /// <p>The instance type to be used for the replication server.</p>
        pub fn set_replication_server_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_server_instance_type = input;
            self
        }
        /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
        pub fn use_dedicated_replication_server(mut self, input: bool) -> Self {
            self.use_dedicated_replication_server = Some(input);
            self
        }
        /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
        pub fn set_use_dedicated_replication_server(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.use_dedicated_replication_server = input;
            self
        }
        /// <p>The Staging Disk EBS volume type to be used during replication.</p>
        pub fn default_large_staging_disk_type(
            mut self,
            input: crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
        ) -> Self {
            self.default_large_staging_disk_type = Some(input);
            self
        }
        /// <p>The Staging Disk EBS volume type to be used during replication.</p>
        pub fn set_default_large_staging_disk_type(
            mut self,
            input: std::option::Option<
                crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
            >,
        ) -> Self {
            self.default_large_staging_disk_type = input;
            self
        }
        /// <p>The type of EBS encryption to be used during replication.</p>
        pub fn ebs_encryption(
            mut self,
            input: crate::model::ReplicationConfigurationEbsEncryption,
        ) -> Self {
            self.ebs_encryption = Some(input);
            self
        }
        /// <p>The type of EBS encryption to be used during replication.</p>
        pub fn set_ebs_encryption(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        ) -> Self {
            self.ebs_encryption = input;
            self
        }
        /// <p>The ARN of the EBS encryption key to be used during replication.</p>
        pub fn ebs_encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ebs_encryption_key_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the EBS encryption key to be used during replication.</p>
        pub fn set_ebs_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ebs_encryption_key_arn = input;
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
        pub fn bandwidth_throttling(mut self, input: i64) -> Self {
            self.bandwidth_throttling = Some(input);
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
        pub fn set_bandwidth_throttling(mut self, input: std::option::Option<i64>) -> Self {
            self.bandwidth_throttling = input;
            self
        }
        /// <p>The data plane routing mechanism that will be used for replication.</p>
        pub fn data_plane_routing(
            mut self,
            input: crate::model::ReplicationConfigurationDataPlaneRouting,
        ) -> Self {
            self.data_plane_routing = Some(input);
            self
        }
        /// <p>The data plane routing mechanism that will be used for replication.</p>
        pub fn set_data_plane_routing(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        ) -> Self {
            self.data_plane_routing = input;
            self
        }
        /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
        pub fn create_public_ip(mut self, input: bool) -> Self {
            self.create_public_ip = Some(input);
            self
        }
        /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
        pub fn set_create_public_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.create_public_ip = input;
            self
        }
        /// Adds a key-value pair to `staging_area_tags`.
        ///
        /// To override the contents of this collection use [`set_staging_area_tags`](Self::set_staging_area_tags).
        ///
        /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
        pub fn staging_area_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.staging_area_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.staging_area_tags = Some(hash_map);
            self
        }
        /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
        pub fn set_staging_area_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.staging_area_tags = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A set of tags to be associated with the Replication Configuration Template resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A set of tags to be associated with the Replication Configuration Template resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `pit_policy`.
        ///
        /// To override the contents of this collection use [`set_pit_policy`](Self::set_pit_policy).
        ///
        /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
        pub fn pit_policy(mut self, input: impl Into<crate::model::PitPolicyRule>) -> Self {
            let mut v = self.pit_policy.unwrap_or_default();
            v.push(input.into());
            self.pit_policy = Some(v);
            self
        }
        /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
        pub fn set_pit_policy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PitPolicyRule>>,
        ) -> Self {
            self.pit_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateReplicationConfigurationTemplateOutput`](crate::output::CreateReplicationConfigurationTemplateOutput)
        pub fn build(self) -> crate::output::CreateReplicationConfigurationTemplateOutput {
            crate::output::CreateReplicationConfigurationTemplateOutput {
                replication_configuration_template_id: self.replication_configuration_template_id,
                arn: self.arn,
                staging_area_subnet_id: self.staging_area_subnet_id,
                associate_default_security_group: self.associate_default_security_group,
                replication_servers_security_groups_i_ds: self
                    .replication_servers_security_groups_i_ds,
                replication_server_instance_type: self.replication_server_instance_type,
                use_dedicated_replication_server: self.use_dedicated_replication_server,
                default_large_staging_disk_type: self.default_large_staging_disk_type,
                ebs_encryption: self.ebs_encryption,
                ebs_encryption_key_arn: self.ebs_encryption_key_arn,
                bandwidth_throttling: self.bandwidth_throttling.unwrap_or_default(),
                data_plane_routing: self.data_plane_routing,
                create_public_ip: self.create_public_ip,
                staging_area_tags: self.staging_area_tags,
                tags: self.tags,
                pit_policy: self.pit_policy,
            }
        }
    }
}
impl CreateReplicationConfigurationTemplateOutput {
    /// Creates a new builder-style object to manufacture [`CreateReplicationConfigurationTemplateOutput`](crate::output::CreateReplicationConfigurationTemplateOutput)
    pub fn builder() -> crate::output::create_replication_configuration_template_output::Builder {
        crate::output::create_replication_configuration_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteReplicationConfigurationTemplateOutput {}
impl std::fmt::Debug for DeleteReplicationConfigurationTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteReplicationConfigurationTemplateOutput");
        formatter.finish()
    }
}
/// See [`DeleteReplicationConfigurationTemplateOutput`](crate::output::DeleteReplicationConfigurationTemplateOutput)
pub mod delete_replication_configuration_template_output {
    /// A builder for [`DeleteReplicationConfigurationTemplateOutput`](crate::output::DeleteReplicationConfigurationTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteReplicationConfigurationTemplateOutput`](crate::output::DeleteReplicationConfigurationTemplateOutput)
        pub fn build(self) -> crate::output::DeleteReplicationConfigurationTemplateOutput {
            crate::output::DeleteReplicationConfigurationTemplateOutput {}
        }
    }
}
impl DeleteReplicationConfigurationTemplateOutput {
    /// Creates a new builder-style object to manufacture [`DeleteReplicationConfigurationTemplateOutput`](crate::output::DeleteReplicationConfigurationTemplateOutput)
    pub fn builder() -> crate::output::delete_replication_configuration_template_output::Builder {
        crate::output::delete_replication_configuration_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateReplicationConfigurationTemplateOutput {
    /// <p>The Replication Configuration Template ID.</p>
    pub replication_configuration_template_id: std::option::Option<std::string::String>,
    /// <p>The Replication Configuration Template ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The subnet to be used by the replication staging area.</p>
    pub staging_area_subnet_id: std::option::Option<std::string::String>,
    /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>
    pub associate_default_security_group: std::option::Option<bool>,
    /// <p>The security group IDs that will be used by the replication server.</p>
    pub replication_servers_security_groups_i_ds:
        std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The instance type to be used for the replication server.</p>
    pub replication_server_instance_type: std::option::Option<std::string::String>,
    /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
    pub use_dedicated_replication_server: std::option::Option<bool>,
    /// <p>The Staging Disk EBS volume type to be used during replication.</p>
    pub default_large_staging_disk_type:
        std::option::Option<crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>,
    /// <p>The type of EBS encryption to be used during replication.</p>
    pub ebs_encryption: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
    /// <p>The ARN of the EBS encryption key to be used during replication.</p>
    pub ebs_encryption_key_arn: std::option::Option<std::string::String>,
    /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
    pub bandwidth_throttling: i64,
    /// <p>The data plane routing mechanism that will be used for replication.</p>
    pub data_plane_routing:
        std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
    /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
    pub create_public_ip: std::option::Option<bool>,
    /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
    pub staging_area_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A set of tags to be associated with the Replication Configuration Template resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
    pub pit_policy: std::option::Option<std::vec::Vec<crate::model::PitPolicyRule>>,
}
impl UpdateReplicationConfigurationTemplateOutput {
    /// <p>The Replication Configuration Template ID.</p>
    pub fn replication_configuration_template_id(&self) -> std::option::Option<&str> {
        self.replication_configuration_template_id.as_deref()
    }
    /// <p>The Replication Configuration Template ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The subnet to be used by the replication staging area.</p>
    pub fn staging_area_subnet_id(&self) -> std::option::Option<&str> {
        self.staging_area_subnet_id.as_deref()
    }
    /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>
    pub fn associate_default_security_group(&self) -> std::option::Option<bool> {
        self.associate_default_security_group
    }
    /// <p>The security group IDs that will be used by the replication server.</p>
    pub fn replication_servers_security_groups_i_ds(
        &self,
    ) -> std::option::Option<&[std::string::String]> {
        self.replication_servers_security_groups_i_ds.as_deref()
    }
    /// <p>The instance type to be used for the replication server.</p>
    pub fn replication_server_instance_type(&self) -> std::option::Option<&str> {
        self.replication_server_instance_type.as_deref()
    }
    /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
    pub fn use_dedicated_replication_server(&self) -> std::option::Option<bool> {
        self.use_dedicated_replication_server
    }
    /// <p>The Staging Disk EBS volume type to be used during replication.</p>
    pub fn default_large_staging_disk_type(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>
    {
        self.default_large_staging_disk_type.as_ref()
    }
    /// <p>The type of EBS encryption to be used during replication.</p>
    pub fn ebs_encryption(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationEbsEncryption> {
        self.ebs_encryption.as_ref()
    }
    /// <p>The ARN of the EBS encryption key to be used during replication.</p>
    pub fn ebs_encryption_key_arn(&self) -> std::option::Option<&str> {
        self.ebs_encryption_key_arn.as_deref()
    }
    /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
    pub fn bandwidth_throttling(&self) -> i64 {
        self.bandwidth_throttling
    }
    /// <p>The data plane routing mechanism that will be used for replication.</p>
    pub fn data_plane_routing(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationDataPlaneRouting> {
        self.data_plane_routing.as_ref()
    }
    /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
    pub fn create_public_ip(&self) -> std::option::Option<bool> {
        self.create_public_ip
    }
    /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
    pub fn staging_area_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.staging_area_tags.as_ref()
    }
    /// <p>A set of tags to be associated with the Replication Configuration Template resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
    pub fn pit_policy(&self) -> std::option::Option<&[crate::model::PitPolicyRule]> {
        self.pit_policy.as_deref()
    }
}
impl std::fmt::Debug for UpdateReplicationConfigurationTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateReplicationConfigurationTemplateOutput");
        formatter.field(
            "replication_configuration_template_id",
            &self.replication_configuration_template_id,
        );
        formatter.field("arn", &self.arn);
        formatter.field("staging_area_subnet_id", &self.staging_area_subnet_id);
        formatter.field(
            "associate_default_security_group",
            &self.associate_default_security_group,
        );
        formatter.field(
            "replication_servers_security_groups_i_ds",
            &self.replication_servers_security_groups_i_ds,
        );
        formatter.field(
            "replication_server_instance_type",
            &self.replication_server_instance_type,
        );
        formatter.field(
            "use_dedicated_replication_server",
            &self.use_dedicated_replication_server,
        );
        formatter.field(
            "default_large_staging_disk_type",
            &self.default_large_staging_disk_type,
        );
        formatter.field("ebs_encryption", &self.ebs_encryption);
        formatter.field("ebs_encryption_key_arn", &self.ebs_encryption_key_arn);
        formatter.field("bandwidth_throttling", &self.bandwidth_throttling);
        formatter.field("data_plane_routing", &self.data_plane_routing);
        formatter.field("create_public_ip", &self.create_public_ip);
        formatter.field("staging_area_tags", &"*** Sensitive Data Redacted ***");
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("pit_policy", &self.pit_policy);
        formatter.finish()
    }
}
/// See [`UpdateReplicationConfigurationTemplateOutput`](crate::output::UpdateReplicationConfigurationTemplateOutput)
pub mod update_replication_configuration_template_output {
    /// A builder for [`UpdateReplicationConfigurationTemplateOutput`](crate::output::UpdateReplicationConfigurationTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_configuration_template_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) staging_area_subnet_id: std::option::Option<std::string::String>,
        pub(crate) associate_default_security_group: std::option::Option<bool>,
        pub(crate) replication_servers_security_groups_i_ds:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) replication_server_instance_type: std::option::Option<std::string::String>,
        pub(crate) use_dedicated_replication_server: std::option::Option<bool>,
        pub(crate) default_large_staging_disk_type:
            std::option::Option<crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>,
        pub(crate) ebs_encryption:
            std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        pub(crate) ebs_encryption_key_arn: std::option::Option<std::string::String>,
        pub(crate) bandwidth_throttling: std::option::Option<i64>,
        pub(crate) data_plane_routing:
            std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        pub(crate) create_public_ip: std::option::Option<bool>,
        pub(crate) staging_area_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) pit_policy: std::option::Option<std::vec::Vec<crate::model::PitPolicyRule>>,
    }
    impl Builder {
        /// <p>The Replication Configuration Template ID.</p>
        pub fn replication_configuration_template_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_configuration_template_id = Some(input.into());
            self
        }
        /// <p>The Replication Configuration Template ID.</p>
        pub fn set_replication_configuration_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_configuration_template_id = input;
            self
        }
        /// <p>The Replication Configuration Template ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Replication Configuration Template ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The subnet to be used by the replication staging area.</p>
        pub fn staging_area_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.staging_area_subnet_id = Some(input.into());
            self
        }
        /// <p>The subnet to be used by the replication staging area.</p>
        pub fn set_staging_area_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.staging_area_subnet_id = input;
            self
        }
        /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>
        pub fn associate_default_security_group(mut self, input: bool) -> Self {
            self.associate_default_security_group = Some(input);
            self
        }
        /// <p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>
        pub fn set_associate_default_security_group(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.associate_default_security_group = input;
            self
        }
        /// Appends an item to `replication_servers_security_groups_i_ds`.
        ///
        /// To override the contents of this collection use [`set_replication_servers_security_groups_i_ds`](Self::set_replication_servers_security_groups_i_ds).
        ///
        /// <p>The security group IDs that will be used by the replication server.</p>
        pub fn replication_servers_security_groups_i_ds(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self
                .replication_servers_security_groups_i_ds
                .unwrap_or_default();
            v.push(input.into());
            self.replication_servers_security_groups_i_ds = Some(v);
            self
        }
        /// <p>The security group IDs that will be used by the replication server.</p>
        pub fn set_replication_servers_security_groups_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.replication_servers_security_groups_i_ds = input;
            self
        }
        /// <p>The instance type to be used for the replication server.</p>
        pub fn replication_server_instance_type(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_server_instance_type = Some(input.into());
            self
        }
        /// <p>The instance type to be used for the replication server.</p>
        pub fn set_replication_server_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_server_instance_type = input;
            self
        }
        /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
        pub fn use_dedicated_replication_server(mut self, input: bool) -> Self {
            self.use_dedicated_replication_server = Some(input);
            self
        }
        /// <p>Whether to use a dedicated Replication Server in the replication staging area.</p>
        pub fn set_use_dedicated_replication_server(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.use_dedicated_replication_server = input;
            self
        }
        /// <p>The Staging Disk EBS volume type to be used during replication.</p>
        pub fn default_large_staging_disk_type(
            mut self,
            input: crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
        ) -> Self {
            self.default_large_staging_disk_type = Some(input);
            self
        }
        /// <p>The Staging Disk EBS volume type to be used during replication.</p>
        pub fn set_default_large_staging_disk_type(
            mut self,
            input: std::option::Option<
                crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
            >,
        ) -> Self {
            self.default_large_staging_disk_type = input;
            self
        }
        /// <p>The type of EBS encryption to be used during replication.</p>
        pub fn ebs_encryption(
            mut self,
            input: crate::model::ReplicationConfigurationEbsEncryption,
        ) -> Self {
            self.ebs_encryption = Some(input);
            self
        }
        /// <p>The type of EBS encryption to be used during replication.</p>
        pub fn set_ebs_encryption(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        ) -> Self {
            self.ebs_encryption = input;
            self
        }
        /// <p>The ARN of the EBS encryption key to be used during replication.</p>
        pub fn ebs_encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ebs_encryption_key_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the EBS encryption key to be used during replication.</p>
        pub fn set_ebs_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ebs_encryption_key_arn = input;
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
        pub fn bandwidth_throttling(mut self, input: i64) -> Self {
            self.bandwidth_throttling = Some(input);
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>
        pub fn set_bandwidth_throttling(mut self, input: std::option::Option<i64>) -> Self {
            self.bandwidth_throttling = input;
            self
        }
        /// <p>The data plane routing mechanism that will be used for replication.</p>
        pub fn data_plane_routing(
            mut self,
            input: crate::model::ReplicationConfigurationDataPlaneRouting,
        ) -> Self {
            self.data_plane_routing = Some(input);
            self
        }
        /// <p>The data plane routing mechanism that will be used for replication.</p>
        pub fn set_data_plane_routing(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        ) -> Self {
            self.data_plane_routing = input;
            self
        }
        /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
        pub fn create_public_ip(mut self, input: bool) -> Self {
            self.create_public_ip = Some(input);
            self
        }
        /// <p>Whether to create a Public IP for the Recovery Instance by default.</p>
        pub fn set_create_public_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.create_public_ip = input;
            self
        }
        /// Adds a key-value pair to `staging_area_tags`.
        ///
        /// To override the contents of this collection use [`set_staging_area_tags`](Self::set_staging_area_tags).
        ///
        /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
        pub fn staging_area_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.staging_area_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.staging_area_tags = Some(hash_map);
            self
        }
        /// <p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>
        pub fn set_staging_area_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.staging_area_tags = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A set of tags to be associated with the Replication Configuration Template resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A set of tags to be associated with the Replication Configuration Template resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `pit_policy`.
        ///
        /// To override the contents of this collection use [`set_pit_policy`](Self::set_pit_policy).
        ///
        /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
        pub fn pit_policy(mut self, input: impl Into<crate::model::PitPolicyRule>) -> Self {
            let mut v = self.pit_policy.unwrap_or_default();
            v.push(input.into());
            self.pit_policy = Some(v);
            self
        }
        /// <p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>
        pub fn set_pit_policy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PitPolicyRule>>,
        ) -> Self {
            self.pit_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateReplicationConfigurationTemplateOutput`](crate::output::UpdateReplicationConfigurationTemplateOutput)
        pub fn build(self) -> crate::output::UpdateReplicationConfigurationTemplateOutput {
            crate::output::UpdateReplicationConfigurationTemplateOutput {
                replication_configuration_template_id: self.replication_configuration_template_id,
                arn: self.arn,
                staging_area_subnet_id: self.staging_area_subnet_id,
                associate_default_security_group: self.associate_default_security_group,
                replication_servers_security_groups_i_ds: self
                    .replication_servers_security_groups_i_ds,
                replication_server_instance_type: self.replication_server_instance_type,
                use_dedicated_replication_server: self.use_dedicated_replication_server,
                default_large_staging_disk_type: self.default_large_staging_disk_type,
                ebs_encryption: self.ebs_encryption,
                ebs_encryption_key_arn: self.ebs_encryption_key_arn,
                bandwidth_throttling: self.bandwidth_throttling.unwrap_or_default(),
                data_plane_routing: self.data_plane_routing,
                create_public_ip: self.create_public_ip,
                staging_area_tags: self.staging_area_tags,
                tags: self.tags,
                pit_policy: self.pit_policy,
            }
        }
    }
}
impl UpdateReplicationConfigurationTemplateOutput {
    /// Creates a new builder-style object to manufacture [`UpdateReplicationConfigurationTemplateOutput`](crate::output::UpdateReplicationConfigurationTemplateOutput)
    pub fn builder() -> crate::output::update_replication_configuration_template_output::Builder {
        crate::output::update_replication_configuration_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFailbackReplicationConfigurationOutput {}
impl std::fmt::Debug for UpdateFailbackReplicationConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFailbackReplicationConfigurationOutput");
        formatter.finish()
    }
}
/// See [`UpdateFailbackReplicationConfigurationOutput`](crate::output::UpdateFailbackReplicationConfigurationOutput)
pub mod update_failback_replication_configuration_output {
    /// A builder for [`UpdateFailbackReplicationConfigurationOutput`](crate::output::UpdateFailbackReplicationConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateFailbackReplicationConfigurationOutput`](crate::output::UpdateFailbackReplicationConfigurationOutput)
        pub fn build(self) -> crate::output::UpdateFailbackReplicationConfigurationOutput {
            crate::output::UpdateFailbackReplicationConfigurationOutput {}
        }
    }
}
impl UpdateFailbackReplicationConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFailbackReplicationConfigurationOutput`](crate::output::UpdateFailbackReplicationConfigurationOutput)
    pub fn builder() -> crate::output::update_failback_replication_configuration_output::Builder {
        crate::output::update_failback_replication_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopFailbackOutput {}
impl std::fmt::Debug for StopFailbackOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopFailbackOutput");
        formatter.finish()
    }
}
/// See [`StopFailbackOutput`](crate::output::StopFailbackOutput)
pub mod stop_failback_output {
    /// A builder for [`StopFailbackOutput`](crate::output::StopFailbackOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StopFailbackOutput`](crate::output::StopFailbackOutput)
        pub fn build(self) -> crate::output::StopFailbackOutput {
            crate::output::StopFailbackOutput {}
        }
    }
}
impl StopFailbackOutput {
    /// Creates a new builder-style object to manufacture [`StopFailbackOutput`](crate::output::StopFailbackOutput)
    pub fn builder() -> crate::output::stop_failback_output::Builder {
        crate::output::stop_failback_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFailbackReplicationConfigurationOutput {
    /// <p>The ID of the Recovery Instance.</p>
    pub recovery_instance_id: std::option::Option<std::string::String>,
    /// <p>The name of the Failback Replication Configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Recovery Instance in Mbps.</p>
    pub bandwidth_throttling: i64,
    /// <p>Whether to use Private IP for the failback replication of the Recovery Instance.</p>
    pub use_private_ip: std::option::Option<bool>,
}
impl GetFailbackReplicationConfigurationOutput {
    /// <p>The ID of the Recovery Instance.</p>
    pub fn recovery_instance_id(&self) -> std::option::Option<&str> {
        self.recovery_instance_id.as_deref()
    }
    /// <p>The name of the Failback Replication Configuration.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Recovery Instance in Mbps.</p>
    pub fn bandwidth_throttling(&self) -> i64 {
        self.bandwidth_throttling
    }
    /// <p>Whether to use Private IP for the failback replication of the Recovery Instance.</p>
    pub fn use_private_ip(&self) -> std::option::Option<bool> {
        self.use_private_ip
    }
}
impl std::fmt::Debug for GetFailbackReplicationConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFailbackReplicationConfigurationOutput");
        formatter.field("recovery_instance_id", &self.recovery_instance_id);
        formatter.field("name", &self.name);
        formatter.field("bandwidth_throttling", &self.bandwidth_throttling);
        formatter.field("use_private_ip", &self.use_private_ip);
        formatter.finish()
    }
}
/// See [`GetFailbackReplicationConfigurationOutput`](crate::output::GetFailbackReplicationConfigurationOutput)
pub mod get_failback_replication_configuration_output {
    /// A builder for [`GetFailbackReplicationConfigurationOutput`](crate::output::GetFailbackReplicationConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recovery_instance_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) bandwidth_throttling: std::option::Option<i64>,
        pub(crate) use_private_ip: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the Recovery Instance.</p>
        pub fn recovery_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the Recovery Instance.</p>
        pub fn set_recovery_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_instance_id = input;
            self
        }
        /// <p>The name of the Failback Replication Configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Failback Replication Configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Recovery Instance in Mbps.</p>
        pub fn bandwidth_throttling(mut self, input: i64) -> Self {
            self.bandwidth_throttling = Some(input);
            self
        }
        /// <p>Configure bandwidth throttling for the outbound data transfer rate of the Recovery Instance in Mbps.</p>
        pub fn set_bandwidth_throttling(mut self, input: std::option::Option<i64>) -> Self {
            self.bandwidth_throttling = input;
            self
        }
        /// <p>Whether to use Private IP for the failback replication of the Recovery Instance.</p>
        pub fn use_private_ip(mut self, input: bool) -> Self {
            self.use_private_ip = Some(input);
            self
        }
        /// <p>Whether to use Private IP for the failback replication of the Recovery Instance.</p>
        pub fn set_use_private_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.use_private_ip = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFailbackReplicationConfigurationOutput`](crate::output::GetFailbackReplicationConfigurationOutput)
        pub fn build(self) -> crate::output::GetFailbackReplicationConfigurationOutput {
            crate::output::GetFailbackReplicationConfigurationOutput {
                recovery_instance_id: self.recovery_instance_id,
                name: self.name,
                bandwidth_throttling: self.bandwidth_throttling.unwrap_or_default(),
                use_private_ip: self.use_private_ip,
            }
        }
    }
}
impl GetFailbackReplicationConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`GetFailbackReplicationConfigurationOutput`](crate::output::GetFailbackReplicationConfigurationOutput)
    pub fn builder() -> crate::output::get_failback_replication_configuration_output::Builder {
        crate::output::get_failback_replication_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisconnectRecoveryInstanceOutput {}
impl std::fmt::Debug for DisconnectRecoveryInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisconnectRecoveryInstanceOutput");
        formatter.finish()
    }
}
/// See [`DisconnectRecoveryInstanceOutput`](crate::output::DisconnectRecoveryInstanceOutput)
pub mod disconnect_recovery_instance_output {
    /// A builder for [`DisconnectRecoveryInstanceOutput`](crate::output::DisconnectRecoveryInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisconnectRecoveryInstanceOutput`](crate::output::DisconnectRecoveryInstanceOutput)
        pub fn build(self) -> crate::output::DisconnectRecoveryInstanceOutput {
            crate::output::DisconnectRecoveryInstanceOutput {}
        }
    }
}
impl DisconnectRecoveryInstanceOutput {
    /// Creates a new builder-style object to manufacture [`DisconnectRecoveryInstanceOutput`](crate::output::DisconnectRecoveryInstanceOutput)
    pub fn builder() -> crate::output::disconnect_recovery_instance_output::Builder {
        crate::output::disconnect_recovery_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRecoveryInstanceOutput {}
impl std::fmt::Debug for DeleteRecoveryInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRecoveryInstanceOutput");
        formatter.finish()
    }
}
/// See [`DeleteRecoveryInstanceOutput`](crate::output::DeleteRecoveryInstanceOutput)
pub mod delete_recovery_instance_output {
    /// A builder for [`DeleteRecoveryInstanceOutput`](crate::output::DeleteRecoveryInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteRecoveryInstanceOutput`](crate::output::DeleteRecoveryInstanceOutput)
        pub fn build(self) -> crate::output::DeleteRecoveryInstanceOutput {
            crate::output::DeleteRecoveryInstanceOutput {}
        }
    }
}
impl DeleteRecoveryInstanceOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRecoveryInstanceOutput`](crate::output::DeleteRecoveryInstanceOutput)
    pub fn builder() -> crate::output::delete_recovery_instance_output::Builder {
        crate::output::delete_recovery_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TerminateRecoveryInstancesOutput {
    /// <p>The Job for terminating the Recovery Instances.</p>
    pub job: std::option::Option<crate::model::Job>,
}
impl TerminateRecoveryInstancesOutput {
    /// <p>The Job for terminating the Recovery Instances.</p>
    pub fn job(&self) -> std::option::Option<&crate::model::Job> {
        self.job.as_ref()
    }
}
impl std::fmt::Debug for TerminateRecoveryInstancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TerminateRecoveryInstancesOutput");
        formatter.field("job", &self.job);
        formatter.finish()
    }
}
/// See [`TerminateRecoveryInstancesOutput`](crate::output::TerminateRecoveryInstancesOutput)
pub mod terminate_recovery_instances_output {
    /// A builder for [`TerminateRecoveryInstancesOutput`](crate::output::TerminateRecoveryInstancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job: std::option::Option<crate::model::Job>,
    }
    impl Builder {
        /// <p>The Job for terminating the Recovery Instances.</p>
        pub fn job(mut self, input: crate::model::Job) -> Self {
            self.job = Some(input);
            self
        }
        /// <p>The Job for terminating the Recovery Instances.</p>
        pub fn set_job(mut self, input: std::option::Option<crate::model::Job>) -> Self {
            self.job = input;
            self
        }
        /// Consumes the builder and constructs a [`TerminateRecoveryInstancesOutput`](crate::output::TerminateRecoveryInstancesOutput)
        pub fn build(self) -> crate::output::TerminateRecoveryInstancesOutput {
            crate::output::TerminateRecoveryInstancesOutput { job: self.job }
        }
    }
}
impl TerminateRecoveryInstancesOutput {
    /// Creates a new builder-style object to manufacture [`TerminateRecoveryInstancesOutput`](crate::output::TerminateRecoveryInstancesOutput)
    pub fn builder() -> crate::output::terminate_recovery_instances_output::Builder {
        crate::output::terminate_recovery_instances_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartFailbackLaunchOutput {
    /// <p>The failback launch Job.</p>
    pub job: std::option::Option<crate::model::Job>,
}
impl StartFailbackLaunchOutput {
    /// <p>The failback launch Job.</p>
    pub fn job(&self) -> std::option::Option<&crate::model::Job> {
        self.job.as_ref()
    }
}
impl std::fmt::Debug for StartFailbackLaunchOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartFailbackLaunchOutput");
        formatter.field("job", &self.job);
        formatter.finish()
    }
}
/// See [`StartFailbackLaunchOutput`](crate::output::StartFailbackLaunchOutput)
pub mod start_failback_launch_output {
    /// A builder for [`StartFailbackLaunchOutput`](crate::output::StartFailbackLaunchOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job: std::option::Option<crate::model::Job>,
    }
    impl Builder {
        /// <p>The failback launch Job.</p>
        pub fn job(mut self, input: crate::model::Job) -> Self {
            self.job = Some(input);
            self
        }
        /// <p>The failback launch Job.</p>
        pub fn set_job(mut self, input: std::option::Option<crate::model::Job>) -> Self {
            self.job = input;
            self
        }
        /// Consumes the builder and constructs a [`StartFailbackLaunchOutput`](crate::output::StartFailbackLaunchOutput)
        pub fn build(self) -> crate::output::StartFailbackLaunchOutput {
            crate::output::StartFailbackLaunchOutput { job: self.job }
        }
    }
}
impl StartFailbackLaunchOutput {
    /// Creates a new builder-style object to manufacture [`StartFailbackLaunchOutput`](crate::output::StartFailbackLaunchOutput)
    pub fn builder() -> crate::output::start_failback_launch_output::Builder {
        crate::output::start_failback_launch_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRecoveryInstancesOutput {
    /// <p>The token of the next Recovery Instance to retrieve.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of Recovery Instances.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::RecoveryInstance>>,
}
impl DescribeRecoveryInstancesOutput {
    /// <p>The token of the next Recovery Instance to retrieve.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>An array of Recovery Instances.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::RecoveryInstance]> {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for DescribeRecoveryInstancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRecoveryInstancesOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`DescribeRecoveryInstancesOutput`](crate::output::DescribeRecoveryInstancesOutput)
pub mod describe_recovery_instances_output {
    /// A builder for [`DescribeRecoveryInstancesOutput`](crate::output::DescribeRecoveryInstancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::RecoveryInstance>>,
    }
    impl Builder {
        /// <p>The token of the next Recovery Instance to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token of the next Recovery Instance to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>An array of Recovery Instances.</p>
        pub fn items(mut self, input: impl Into<crate::model::RecoveryInstance>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>An array of Recovery Instances.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecoveryInstance>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRecoveryInstancesOutput`](crate::output::DescribeRecoveryInstancesOutput)
        pub fn build(self) -> crate::output::DescribeRecoveryInstancesOutput {
            crate::output::DescribeRecoveryInstancesOutput {
                next_token: self.next_token,
                items: self.items,
            }
        }
    }
}
impl DescribeRecoveryInstancesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeRecoveryInstancesOutput`](crate::output::DescribeRecoveryInstancesOutput)
    pub fn builder() -> crate::output::describe_recovery_instances_output::Builder {
        crate::output::describe_recovery_instances_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeJobLogItemsOutput {
    /// <p>An array of Job log items.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::JobLog>>,
    /// <p>The token of the next Job log items to retrieve.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeJobLogItemsOutput {
    /// <p>An array of Job log items.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::JobLog]> {
        self.items.as_deref()
    }
    /// <p>The token of the next Job log items to retrieve.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeJobLogItemsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeJobLogItemsOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeJobLogItemsOutput`](crate::output::DescribeJobLogItemsOutput)
pub mod describe_job_log_items_output {
    /// A builder for [`DescribeJobLogItemsOutput`](crate::output::DescribeJobLogItemsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::JobLog>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>An array of Job log items.</p>
        pub fn items(mut self, input: impl Into<crate::model::JobLog>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>An array of Job log items.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobLog>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The token of the next Job log items to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token of the next Job log items to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeJobLogItemsOutput`](crate::output::DescribeJobLogItemsOutput)
        pub fn build(self) -> crate::output::DescribeJobLogItemsOutput {
            crate::output::DescribeJobLogItemsOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeJobLogItemsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeJobLogItemsOutput`](crate::output::DescribeJobLogItemsOutput)
    pub fn builder() -> crate::output::describe_job_log_items_output::Builder {
        crate::output::describe_job_log_items_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeJobsOutput {
    /// <p>An array of Jobs.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::Job>>,
    /// <p>The token of the next Job to retrieve.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeJobsOutput {
    /// <p>An array of Jobs.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::Job]> {
        self.items.as_deref()
    }
    /// <p>The token of the next Job to retrieve.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeJobsOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeJobsOutput`](crate::output::DescribeJobsOutput)
pub mod describe_jobs_output {
    /// A builder for [`DescribeJobsOutput`](crate::output::DescribeJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::Job>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>An array of Jobs.</p>
        pub fn items(mut self, input: impl Into<crate::model::Job>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>An array of Jobs.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Job>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The token of the next Job to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token of the next Job to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeJobsOutput`](crate::output::DescribeJobsOutput)
        pub fn build(self) -> crate::output::DescribeJobsOutput {
            crate::output::DescribeJobsOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeJobsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeJobsOutput`](crate::output::DescribeJobsOutput)
    pub fn builder() -> crate::output::describe_jobs_output::Builder {
        crate::output::describe_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteJobOutput {}
impl std::fmt::Debug for DeleteJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteJobOutput");
        formatter.finish()
    }
}
/// See [`DeleteJobOutput`](crate::output::DeleteJobOutput)
pub mod delete_job_output {
    /// A builder for [`DeleteJobOutput`](crate::output::DeleteJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteJobOutput`](crate::output::DeleteJobOutput)
        pub fn build(self) -> crate::output::DeleteJobOutput {
            crate::output::DeleteJobOutput {}
        }
    }
}
impl DeleteJobOutput {
    /// Creates a new builder-style object to manufacture [`DeleteJobOutput`](crate::output::DeleteJobOutput)
    pub fn builder() -> crate::output::delete_job_output::Builder {
        crate::output::delete_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The tags of the requested resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p>The tags of the requested resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags of the requested resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags of the requested resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InitializeServiceOutput {}
impl std::fmt::Debug for InitializeServiceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InitializeServiceOutput");
        formatter.finish()
    }
}
/// See [`InitializeServiceOutput`](crate::output::InitializeServiceOutput)
pub mod initialize_service_output {
    /// A builder for [`InitializeServiceOutput`](crate::output::InitializeServiceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`InitializeServiceOutput`](crate::output::InitializeServiceOutput)
        pub fn build(self) -> crate::output::InitializeServiceOutput {
            crate::output::InitializeServiceOutput {}
        }
    }
}
impl InitializeServiceOutput {
    /// Creates a new builder-style object to manufacture [`InitializeServiceOutput`](crate::output::InitializeServiceOutput)
    pub fn builder() -> crate::output::initialize_service_output::Builder {
        crate::output::initialize_service_output::Builder::default()
    }
}
