// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>The specified CIDR IP or Amazon EC2 security group isn't authorized for the specified security group.</p>
    /// <p>Amazon DocumentDB also might not be authorized to perform necessary actions on your behalf using IAM.</p>
    AuthorizationNotFoundFault(crate::error::AuthorizationNotFoundFault),
    /// <p> <code>CertificateIdentifier</code> doesn't refer to an existing certificate. </p>
    CertificateNotFoundFault(crate::error::CertificateNotFoundFault),
    /// <p>You already have a cluster with the given identifier.</p>
    DbClusterAlreadyExistsFault(crate::error::DbClusterAlreadyExistsFault),
    /// <p> <code>DBClusterIdentifier</code> doesn't refer to an existing cluster. </p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p> <code>DBClusterParameterGroupName</code> doesn't refer to an existing cluster parameter group. </p>
    DbClusterParameterGroupNotFoundFault(crate::error::DbClusterParameterGroupNotFoundFault),
    /// <p>The cluster can't be created because you have reached the maximum allowed quota of clusters.</p>
    DbClusterQuotaExceededFault(crate::error::DbClusterQuotaExceededFault),
    /// <p>You already have a cluster snapshot with the given identifier.</p>
    DbClusterSnapshotAlreadyExistsFault(crate::error::DbClusterSnapshotAlreadyExistsFault),
    /// <p> <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing cluster snapshot. </p>
    DbClusterSnapshotNotFoundFault(crate::error::DbClusterSnapshotNotFoundFault),
    /// <p>You already have a instance with the given identifier.</p>
    DbInstanceAlreadyExistsFault(crate::error::DbInstanceAlreadyExistsFault),
    /// <p> <code>DBInstanceIdentifier</code> doesn't refer to an existing instance. </p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p>A parameter group with the same name already exists.</p>
    DbParameterGroupAlreadyExistsFault(crate::error::DbParameterGroupAlreadyExistsFault),
    /// <p> <code>DBParameterGroupName</code> doesn't refer to an existing parameter group. </p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// <p>This request would cause you to exceed the allowed number of parameter groups.</p>
    DbParameterGroupQuotaExceededFault(crate::error::DbParameterGroupQuotaExceededFault),
    /// <p> <code>DBSecurityGroupName</code> doesn't refer to an existing security group. </p>
    DbSecurityGroupNotFoundFault(crate::error::DbSecurityGroupNotFoundFault),
    /// <p> <code>DBSnapshotIdentifier</code> is already being used by an existing snapshot. </p>
    DbSnapshotAlreadyExistsFault(crate::error::DbSnapshotAlreadyExistsFault),
    /// <p> <code>DBSnapshotIdentifier</code> doesn't refer to an existing snapshot. </p>
    DbSnapshotNotFoundFault(crate::error::DbSnapshotNotFoundFault),
    /// <p> <code>DBSubnetGroupName</code> is already being used by an existing subnet group. </p>
    DbSubnetGroupAlreadyExistsFault(crate::error::DbSubnetGroupAlreadyExistsFault),
    /// <p>Subnets in the subnet group should cover at least two Availability Zones unless there is only one Availability Zone.</p>
    DbSubnetGroupDoesNotCoverEnoughAZs(crate::error::DbSubnetGroupDoesNotCoverEnoughAZs),
    /// <p> <code>DBSubnetGroupName</code> doesn't refer to an existing subnet group. </p>
    DbSubnetGroupNotFoundFault(crate::error::DbSubnetGroupNotFoundFault),
    /// <p>The request would cause you to exceed the allowed number of subnet groups.</p>
    DbSubnetGroupQuotaExceededFault(crate::error::DbSubnetGroupQuotaExceededFault),
    /// <p>The request would cause you to exceed the allowed number of subnets in a subnet group.</p>
    DbSubnetQuotaExceededFault(crate::error::DbSubnetQuotaExceededFault),
    /// <p>The upgrade failed because a resource that the depends on can't be modified.</p>
    DbUpgradeDependencyFailureFault(crate::error::DbUpgradeDependencyFailureFault),
    /// <p>You have reached the maximum number of event subscriptions. </p>
    EventSubscriptionQuotaExceededFault(crate::error::EventSubscriptionQuotaExceededFault),
    /// <p>The <code>GlobalClusterIdentifier</code> already exists. Choose a new global cluster identifier (unique name) to create a new global cluster. </p>
    GlobalClusterAlreadyExistsFault(crate::error::GlobalClusterAlreadyExistsFault),
    /// <p>The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global cluster.</p>
    GlobalClusterNotFoundFault(crate::error::GlobalClusterNotFoundFault),
    /// <p>The number of global clusters for this account is already at the maximum allowed.</p>
    GlobalClusterQuotaExceededFault(crate::error::GlobalClusterQuotaExceededFault),
    /// <p>The request would cause you to exceed the allowed number of instances.</p>
    InstanceQuotaExceededFault(crate::error::InstanceQuotaExceededFault),
    /// <p>The cluster doesn't have enough capacity for the current operation.</p>
    InsufficientDbClusterCapacityFault(crate::error::InsufficientDbClusterCapacityFault),
    /// <p>The specified instance class isn't available in the specified Availability Zone.</p>
    InsufficientDbInstanceCapacityFault(crate::error::InsufficientDbInstanceCapacityFault),
    /// <p>There is not enough storage available for the current action. You might be able to resolve this error by updating your subnet group to use different Availability Zones that have more storage available. </p>
    InsufficientStorageClusterCapacityFault(crate::error::InsufficientStorageClusterCapacityFault),
    /// <p>The provided value isn't a valid cluster snapshot state.</p>
    InvalidDbClusterSnapshotStateFault(crate::error::InvalidDbClusterSnapshotStateFault),
    /// <p>The cluster isn't in a valid state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p> The specified instance isn't in the <i>available</i> state. </p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// <p>The parameter group is in use, or it is in a state that is not valid. If you are trying to delete the parameter group, you can't delete it when the parameter group is in this state.</p>
    InvalidDbParameterGroupStateFault(crate::error::InvalidDbParameterGroupStateFault),
    /// <p>The state of the security group doesn't allow deletion.</p>
    InvalidDbSecurityGroupStateFault(crate::error::InvalidDbSecurityGroupStateFault),
    /// <p>The state of the snapshot doesn't allow deletion.</p>
    InvalidDbSnapshotStateFault(crate::error::InvalidDbSnapshotStateFault),
    /// <p>The subnet group can't be deleted because it's in use.</p>
    InvalidDbSubnetGroupStateFault(crate::error::InvalidDbSubnetGroupStateFault),
    /// <p> The subnet isn't in the <i>available</i> state. </p>
    InvalidDbSubnetStateFault(crate::error::InvalidDbSubnetStateFault),
    /// <p>Someone else might be modifying a subscription. Wait a few seconds, and try again.</p>
    InvalidEventSubscriptionStateFault(crate::error::InvalidEventSubscriptionStateFault),
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidGlobalClusterStateFault(crate::error::InvalidGlobalClusterStateFault),
    /// <p>You cannot restore from a virtual private cloud (VPC) backup to a non-VPC DB instance.</p>
    InvalidRestoreFault(crate::error::InvalidRestoreFault),
    /// <p>The requested subnet is not valid, or multiple subnets were requested that are not all in a common virtual private cloud (VPC).</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>The subnet group doesn't cover all Availability Zones after it is created because of changes that were made.</p>
    InvalidVpcNetworkStateFault(crate::error::InvalidVpcNetworkStateFault),
    /// <p>An error occurred when accessing an KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// <p>The specified resource ID was not found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// <p>Amazon SNS has responded that there is a problem with the specified topic. </p>
    SnsInvalidTopicFault(crate::error::SnsInvalidTopicFault),
    /// <p>You do not have permission to publish to the SNS topic Amazon Resource Name (ARN). </p>
    SnsNoAuthorizationFault(crate::error::SnsNoAuthorizationFault),
    /// <p>The SNS topic Amazon Resource Name (ARN) does not exist. </p>
    SnsTopicArnNotFoundFault(crate::error::SnsTopicArnNotFoundFault),
    /// <p>You have exceeded the maximum number of accounts that you can share a manual DB snapshot with. </p>
    SharedSnapshotQuotaExceededFault(crate::error::SharedSnapshotQuotaExceededFault),
    /// <p>The request would cause you to exceed the allowed number of snapshots.</p>
    SnapshotQuotaExceededFault(crate::error::SnapshotQuotaExceededFault),
    /// <p>The requested source could not be found. </p>
    SourceNotFoundFault(crate::error::SourceNotFoundFault),
    /// <p>The request would cause you to exceed the allowed amount of storage available across all instances.</p>
    StorageQuotaExceededFault(crate::error::StorageQuotaExceededFault),
    /// <p>Storage of the specified <code>StorageType</code> can't be associated with the DB instance. </p>
    StorageTypeNotSupportedFault(crate::error::StorageTypeNotSupportedFault),
    /// <p>The subnet is already in use in the Availability Zone.</p>
    SubnetAlreadyInUse(crate::error::SubnetAlreadyInUse),
    /// <p>The provided subscription name already exists. </p>
    SubscriptionAlreadyExistFault(crate::error::SubscriptionAlreadyExistFault),
    /// <p>The provided category does not exist. </p>
    SubscriptionCategoryNotFoundFault(crate::error::SubscriptionCategoryNotFoundFault),
    /// <p>The subscription name does not exist. </p>
    SubscriptionNotFoundFault(crate::error::SubscriptionNotFoundFault),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::AuthorizationNotFoundFault(inner) => inner.fmt(f),
            Error::CertificateNotFoundFault(inner) => inner.fmt(f),
            Error::DbClusterAlreadyExistsFault(inner) => inner.fmt(f),
            Error::DbClusterNotFoundFault(inner) => inner.fmt(f),
            Error::DbClusterParameterGroupNotFoundFault(inner) => inner.fmt(f),
            Error::DbClusterQuotaExceededFault(inner) => inner.fmt(f),
            Error::DbClusterSnapshotAlreadyExistsFault(inner) => inner.fmt(f),
            Error::DbClusterSnapshotNotFoundFault(inner) => inner.fmt(f),
            Error::DbInstanceAlreadyExistsFault(inner) => inner.fmt(f),
            Error::DbInstanceNotFoundFault(inner) => inner.fmt(f),
            Error::DbParameterGroupAlreadyExistsFault(inner) => inner.fmt(f),
            Error::DbParameterGroupNotFoundFault(inner) => inner.fmt(f),
            Error::DbParameterGroupQuotaExceededFault(inner) => inner.fmt(f),
            Error::DbSecurityGroupNotFoundFault(inner) => inner.fmt(f),
            Error::DbSnapshotAlreadyExistsFault(inner) => inner.fmt(f),
            Error::DbSnapshotNotFoundFault(inner) => inner.fmt(f),
            Error::DbSubnetGroupAlreadyExistsFault(inner) => inner.fmt(f),
            Error::DbSubnetGroupDoesNotCoverEnoughAZs(inner) => inner.fmt(f),
            Error::DbSubnetGroupNotFoundFault(inner) => inner.fmt(f),
            Error::DbSubnetGroupQuotaExceededFault(inner) => inner.fmt(f),
            Error::DbSubnetQuotaExceededFault(inner) => inner.fmt(f),
            Error::DbUpgradeDependencyFailureFault(inner) => inner.fmt(f),
            Error::EventSubscriptionQuotaExceededFault(inner) => inner.fmt(f),
            Error::GlobalClusterAlreadyExistsFault(inner) => inner.fmt(f),
            Error::GlobalClusterNotFoundFault(inner) => inner.fmt(f),
            Error::GlobalClusterQuotaExceededFault(inner) => inner.fmt(f),
            Error::InstanceQuotaExceededFault(inner) => inner.fmt(f),
            Error::InsufficientDbClusterCapacityFault(inner) => inner.fmt(f),
            Error::InsufficientDbInstanceCapacityFault(inner) => inner.fmt(f),
            Error::InsufficientStorageClusterCapacityFault(inner) => inner.fmt(f),
            Error::InvalidDbClusterSnapshotStateFault(inner) => inner.fmt(f),
            Error::InvalidDbClusterStateFault(inner) => inner.fmt(f),
            Error::InvalidDbInstanceStateFault(inner) => inner.fmt(f),
            Error::InvalidDbParameterGroupStateFault(inner) => inner.fmt(f),
            Error::InvalidDbSecurityGroupStateFault(inner) => inner.fmt(f),
            Error::InvalidDbSnapshotStateFault(inner) => inner.fmt(f),
            Error::InvalidDbSubnetGroupStateFault(inner) => inner.fmt(f),
            Error::InvalidDbSubnetStateFault(inner) => inner.fmt(f),
            Error::InvalidEventSubscriptionStateFault(inner) => inner.fmt(f),
            Error::InvalidGlobalClusterStateFault(inner) => inner.fmt(f),
            Error::InvalidRestoreFault(inner) => inner.fmt(f),
            Error::InvalidSubnet(inner) => inner.fmt(f),
            Error::InvalidVpcNetworkStateFault(inner) => inner.fmt(f),
            Error::KmsKeyNotAccessibleFault(inner) => inner.fmt(f),
            Error::ResourceNotFoundFault(inner) => inner.fmt(f),
            Error::SnsInvalidTopicFault(inner) => inner.fmt(f),
            Error::SnsNoAuthorizationFault(inner) => inner.fmt(f),
            Error::SnsTopicArnNotFoundFault(inner) => inner.fmt(f),
            Error::SharedSnapshotQuotaExceededFault(inner) => inner.fmt(f),
            Error::SnapshotQuotaExceededFault(inner) => inner.fmt(f),
            Error::SourceNotFoundFault(inner) => inner.fmt(f),
            Error::StorageQuotaExceededFault(inner) => inner.fmt(f),
            Error::StorageTypeNotSupportedFault(inner) => inner.fmt(f),
            Error::SubnetAlreadyInUse(inner) => inner.fmt(f),
            Error::SubscriptionAlreadyExistFault(inner) => inner.fmt(f),
            Error::SubscriptionCategoryNotFoundFault(inner) => inner.fmt(f),
            Error::SubscriptionNotFoundFault(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::AddSourceIdentifierToSubscriptionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::AddSourceIdentifierToSubscriptionError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AddSourceIdentifierToSubscriptionErrorKind::SourceNotFoundFault(inner) => Error::SourceNotFoundFault(inner),
                crate::error::AddSourceIdentifierToSubscriptionErrorKind::SubscriptionNotFoundFault(inner) => Error::SubscriptionNotFoundFault(inner),
                crate::error::AddSourceIdentifierToSubscriptionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AddTagsToResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AddTagsToResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AddTagsToResourceErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::AddTagsToResourceErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::AddTagsToResourceErrorKind::DbSnapshotNotFoundFault(inner) => {
                    Error::DbSnapshotNotFoundFault(inner)
                }
                crate::error::AddTagsToResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ApplyPendingMaintenanceActionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ApplyPendingMaintenanceActionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ApplyPendingMaintenanceActionErrorKind::InvalidDbClusterStateFault(inner) => Error::InvalidDbClusterStateFault(inner),
                crate::error::ApplyPendingMaintenanceActionErrorKind::InvalidDbInstanceStateFault(inner) => Error::InvalidDbInstanceStateFault(inner),
                crate::error::ApplyPendingMaintenanceActionErrorKind::ResourceNotFoundFault(inner) => Error::ResourceNotFoundFault(inner),
                crate::error::ApplyPendingMaintenanceActionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CopyDBClusterParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CopyDBClusterParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CopyDBClusterParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(inner) => Error::DbParameterGroupAlreadyExistsFault(inner),
                crate::error::CopyDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(inner) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::CopyDBClusterParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(inner) => Error::DbParameterGroupQuotaExceededFault(inner),
                crate::error::CopyDBClusterParameterGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CopyDBClusterSnapshotError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CopyDBClusterSnapshotError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CopyDBClusterSnapshotErrorKind::DbClusterSnapshotAlreadyExistsFault(inner) => Error::DbClusterSnapshotAlreadyExistsFault(inner),
                crate::error::CopyDBClusterSnapshotErrorKind::DbClusterSnapshotNotFoundFault(inner) => Error::DbClusterSnapshotNotFoundFault(inner),
                crate::error::CopyDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(inner) => Error::InvalidDbClusterSnapshotStateFault(inner),
                crate::error::CopyDBClusterSnapshotErrorKind::InvalidDbClusterStateFault(inner) => Error::InvalidDbClusterStateFault(inner),
                crate::error::CopyDBClusterSnapshotErrorKind::KmsKeyNotAccessibleFault(inner) => Error::KmsKeyNotAccessibleFault(inner),
                crate::error::CopyDBClusterSnapshotErrorKind::SnapshotQuotaExceededFault(inner) => Error::SnapshotQuotaExceededFault(inner),
                crate::error::CopyDBClusterSnapshotErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDBClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateDBClusterError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateDBClusterErrorKind::DbClusterAlreadyExistsFault(inner) => {
                    Error::DbClusterAlreadyExistsFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::DbClusterParameterGroupNotFoundFault(
                    inner,
                ) => Error::DbClusterParameterGroupNotFoundFault(inner),
                crate::error::CreateDBClusterErrorKind::DbClusterQuotaExceededFault(inner) => {
                    Error::DbClusterQuotaExceededFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(
                    inner,
                ) => Error::DbSubnetGroupDoesNotCoverEnoughAZs(inner),
                crate::error::CreateDBClusterErrorKind::DbSubnetGroupNotFoundFault(inner) => {
                    Error::DbSubnetGroupNotFoundFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::GlobalClusterNotFoundFault(inner) => {
                    Error::GlobalClusterNotFoundFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::InsufficientStorageClusterCapacityFault(
                    inner,
                ) => Error::InsufficientStorageClusterCapacityFault(inner),
                crate::error::CreateDBClusterErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::InvalidDbInstanceStateFault(inner) => {
                    Error::InvalidDbInstanceStateFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::InvalidDbSubnetGroupStateFault(inner) => {
                    Error::InvalidDbSubnetGroupStateFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::InvalidGlobalClusterStateFault(inner) => {
                    Error::InvalidGlobalClusterStateFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::InvalidSubnet(inner) => {
                    Error::InvalidSubnet(inner)
                }
                crate::error::CreateDBClusterErrorKind::InvalidVpcNetworkStateFault(inner) => {
                    Error::InvalidVpcNetworkStateFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::KmsKeyNotAccessibleFault(inner) => {
                    Error::KmsKeyNotAccessibleFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::StorageQuotaExceededFault(inner) => {
                    Error::StorageQuotaExceededFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDBClusterParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDBClusterParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateDBClusterParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(inner) => Error::DbParameterGroupAlreadyExistsFault(inner),
                crate::error::CreateDBClusterParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(inner) => Error::DbParameterGroupQuotaExceededFault(inner),
                crate::error::CreateDBClusterParameterGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDBClusterSnapshotError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDBClusterSnapshotError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateDBClusterSnapshotErrorKind::DbClusterNotFoundFault(inner) => Error::DbClusterNotFoundFault(inner),
                crate::error::CreateDBClusterSnapshotErrorKind::DbClusterSnapshotAlreadyExistsFault(inner) => Error::DbClusterSnapshotAlreadyExistsFault(inner),
                crate::error::CreateDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(inner) => Error::InvalidDbClusterSnapshotStateFault(inner),
                crate::error::CreateDBClusterSnapshotErrorKind::InvalidDbClusterStateFault(inner) => Error::InvalidDbClusterStateFault(inner),
                crate::error::CreateDBClusterSnapshotErrorKind::SnapshotQuotaExceededFault(inner) => Error::SnapshotQuotaExceededFault(inner),
                crate::error::CreateDBClusterSnapshotErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDBInstanceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDBInstanceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateDBInstanceErrorKind::AuthorizationNotFoundFault(inner) => {
                    Error::AuthorizationNotFoundFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::DbInstanceAlreadyExistsFault(inner) => {
                    Error::DbInstanceAlreadyExistsFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::DbParameterGroupNotFoundFault(inner) => {
                    Error::DbParameterGroupNotFoundFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::DbSecurityGroupNotFoundFault(inner) => {
                    Error::DbSecurityGroupNotFoundFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(
                    inner,
                ) => Error::DbSubnetGroupDoesNotCoverEnoughAZs(inner),
                crate::error::CreateDBInstanceErrorKind::DbSubnetGroupNotFoundFault(inner) => {
                    Error::DbSubnetGroupNotFoundFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::InstanceQuotaExceededFault(inner) => {
                    Error::InstanceQuotaExceededFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::InsufficientDbInstanceCapacityFault(
                    inner,
                ) => Error::InsufficientDbInstanceCapacityFault(inner),
                crate::error::CreateDBInstanceErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::InvalidSubnet(inner) => {
                    Error::InvalidSubnet(inner)
                }
                crate::error::CreateDBInstanceErrorKind::InvalidVpcNetworkStateFault(inner) => {
                    Error::InvalidVpcNetworkStateFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::KmsKeyNotAccessibleFault(inner) => {
                    Error::KmsKeyNotAccessibleFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::StorageQuotaExceededFault(inner) => {
                    Error::StorageQuotaExceededFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::StorageTypeNotSupportedFault(inner) => {
                    Error::StorageTypeNotSupportedFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDBSubnetGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDBSubnetGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateDBSubnetGroupErrorKind::DbSubnetGroupAlreadyExistsFault(
                    inner,
                ) => Error::DbSubnetGroupAlreadyExistsFault(inner),
                crate::error::CreateDBSubnetGroupErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(
                    inner,
                ) => Error::DbSubnetGroupDoesNotCoverEnoughAZs(inner),
                crate::error::CreateDBSubnetGroupErrorKind::DbSubnetGroupQuotaExceededFault(
                    inner,
                ) => Error::DbSubnetGroupQuotaExceededFault(inner),
                crate::error::CreateDBSubnetGroupErrorKind::DbSubnetQuotaExceededFault(inner) => {
                    Error::DbSubnetQuotaExceededFault(inner)
                }
                crate::error::CreateDBSubnetGroupErrorKind::InvalidSubnet(inner) => {
                    Error::InvalidSubnet(inner)
                }
                crate::error::CreateDBSubnetGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateEventSubscriptionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateEventSubscriptionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateEventSubscriptionErrorKind::EventSubscriptionQuotaExceededFault(inner) => Error::EventSubscriptionQuotaExceededFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::SnsInvalidTopicFault(inner) => Error::SnsInvalidTopicFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::SnsNoAuthorizationFault(inner) => Error::SnsNoAuthorizationFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::SnsTopicArnNotFoundFault(inner) => Error::SnsTopicArnNotFoundFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::SourceNotFoundFault(inner) => Error::SourceNotFoundFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::SubscriptionAlreadyExistFault(inner) => Error::SubscriptionAlreadyExistFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault(inner) => Error::SubscriptionCategoryNotFoundFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateGlobalClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateGlobalClusterError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateGlobalClusterErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::CreateGlobalClusterErrorKind::GlobalClusterAlreadyExistsFault(
                    inner,
                ) => Error::GlobalClusterAlreadyExistsFault(inner),
                crate::error::CreateGlobalClusterErrorKind::GlobalClusterQuotaExceededFault(
                    inner,
                ) => Error::GlobalClusterQuotaExceededFault(inner),
                crate::error::CreateGlobalClusterErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::CreateGlobalClusterErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteDBClusterErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::DeleteDBClusterErrorKind::DbClusterSnapshotAlreadyExistsFault(
                    inner,
                ) => Error::DbClusterSnapshotAlreadyExistsFault(inner),
                crate::error::DeleteDBClusterErrorKind::InvalidDbClusterSnapshotStateFault(
                    inner,
                ) => Error::InvalidDbClusterSnapshotStateFault(inner),
                crate::error::DeleteDBClusterErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::DeleteDBClusterErrorKind::SnapshotQuotaExceededFault(inner) => {
                    Error::SnapshotQuotaExceededFault(inner)
                }
                crate::error::DeleteDBClusterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(inner) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::DeleteDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault(inner) => Error::InvalidDbParameterGroupStateFault(inner),
                crate::error::DeleteDBClusterParameterGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterSnapshotError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterSnapshotError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteDBClusterSnapshotErrorKind::DbClusterSnapshotNotFoundFault(inner) => Error::DbClusterSnapshotNotFoundFault(inner),
                crate::error::DeleteDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(inner) => Error::InvalidDbClusterSnapshotStateFault(inner),
                crate::error::DeleteDBClusterSnapshotErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDBInstanceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteDBInstanceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteDBInstanceErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::DeleteDBInstanceErrorKind::DbSnapshotAlreadyExistsFault(inner) => {
                    Error::DbSnapshotAlreadyExistsFault(inner)
                }
                crate::error::DeleteDBInstanceErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::DeleteDBInstanceErrorKind::InvalidDbInstanceStateFault(inner) => {
                    Error::InvalidDbInstanceStateFault(inner)
                }
                crate::error::DeleteDBInstanceErrorKind::SnapshotQuotaExceededFault(inner) => {
                    Error::SnapshotQuotaExceededFault(inner)
                }
                crate::error::DeleteDBInstanceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDBSubnetGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteDBSubnetGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteDBSubnetGroupErrorKind::DbSubnetGroupNotFoundFault(inner) => {
                    Error::DbSubnetGroupNotFoundFault(inner)
                }
                crate::error::DeleteDBSubnetGroupErrorKind::InvalidDbSubnetGroupStateFault(
                    inner,
                ) => Error::InvalidDbSubnetGroupStateFault(inner),
                crate::error::DeleteDBSubnetGroupErrorKind::InvalidDbSubnetStateFault(inner) => {
                    Error::InvalidDbSubnetStateFault(inner)
                }
                crate::error::DeleteDBSubnetGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteEventSubscriptionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteEventSubscriptionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteEventSubscriptionErrorKind::InvalidEventSubscriptionStateFault(inner) => Error::InvalidEventSubscriptionStateFault(inner),
                crate::error::DeleteEventSubscriptionErrorKind::SubscriptionNotFoundFault(inner) => Error::SubscriptionNotFoundFault(inner),
                crate::error::DeleteEventSubscriptionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteGlobalClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteGlobalClusterError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteGlobalClusterErrorKind::GlobalClusterNotFoundFault(inner) => {
                    Error::GlobalClusterNotFoundFault(inner)
                }
                crate::error::DeleteGlobalClusterErrorKind::InvalidGlobalClusterStateFault(
                    inner,
                ) => Error::InvalidGlobalClusterStateFault(inner),
                crate::error::DeleteGlobalClusterErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeCertificatesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeCertificatesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeCertificatesErrorKind::CertificateNotFoundFault(inner) => {
                    Error::CertificateNotFoundFault(inner)
                }
                crate::error::DescribeCertificatesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterParameterGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeDBClusterParameterGroupsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeDBClusterParameterGroupsErrorKind::DbParameterGroupNotFoundFault(inner) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::DescribeDBClusterParameterGroupsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterParametersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterParametersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeDBClusterParametersErrorKind::DbParameterGroupNotFoundFault(inner) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::DescribeDBClusterParametersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBClustersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBClustersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDBClustersErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::DescribeDBClustersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeDBClusterSnapshotAttributesError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeDBClusterSnapshotAttributesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeDBClusterSnapshotAttributesErrorKind::DbClusterSnapshotNotFoundFault(inner) => Error::DbClusterSnapshotNotFoundFault(inner),
                crate::error::DescribeDBClusterSnapshotAttributesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterSnapshotsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterSnapshotsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeDBClusterSnapshotsErrorKind::DbClusterSnapshotNotFoundFault(inner) => Error::DbClusterSnapshotNotFoundFault(inner),
                crate::error::DescribeDBClusterSnapshotsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBEngineVersionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBEngineVersionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDBEngineVersionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBInstancesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBInstancesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDBInstancesErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::DescribeDBInstancesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBSubnetGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBSubnetGroupsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDBSubnetGroupsErrorKind::DbSubnetGroupNotFoundFault(
                    inner,
                ) => Error::DbSubnetGroupNotFoundFault(inner),
                crate::error::DescribeDBSubnetGroupsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeEngineDefaultClusterParametersError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeEngineDefaultClusterParametersError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEngineDefaultClusterParametersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeEventCategoriesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeEventCategoriesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEventCategoriesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeEventsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeEventsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEventsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeEventSubscriptionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeEventSubscriptionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEventSubscriptionsErrorKind::SubscriptionNotFoundFault(
                    inner,
                ) => Error::SubscriptionNotFoundFault(inner),
                crate::error::DescribeEventSubscriptionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeGlobalClustersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeGlobalClustersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeGlobalClustersErrorKind::GlobalClusterNotFoundFault(
                    inner,
                ) => Error::GlobalClusterNotFoundFault(inner),
                crate::error::DescribeGlobalClustersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::DescribeOrderableDBInstanceOptionsError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeOrderableDBInstanceOptionsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeOrderableDBInstanceOptionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribePendingMaintenanceActionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribePendingMaintenanceActionsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribePendingMaintenanceActionsErrorKind::ResourceNotFoundFault(
                    inner,
                ) => Error::ResourceNotFoundFault(inner),
                crate::error::DescribePendingMaintenanceActionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::FailoverDBClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::FailoverDBClusterError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::FailoverDBClusterErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::FailoverDBClusterErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::FailoverDBClusterErrorKind::InvalidDbInstanceStateFault(inner) => {
                    Error::InvalidDbInstanceStateFault(inner)
                }
                crate::error::FailoverDBClusterErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsForResourceErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::ListTagsForResourceErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::ListTagsForResourceErrorKind::DbSnapshotNotFoundFault(inner) => {
                    Error::DbSnapshotNotFoundFault(inner)
                }
                crate::error::ListTagsForResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyDBClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ModifyDBClusterError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyDBClusterErrorKind::DbClusterAlreadyExistsFault(inner) => {
                    Error::DbClusterAlreadyExistsFault(inner)
                }
                crate::error::ModifyDBClusterErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::ModifyDBClusterErrorKind::DbClusterParameterGroupNotFoundFault(
                    inner,
                ) => Error::DbClusterParameterGroupNotFoundFault(inner),
                crate::error::ModifyDBClusterErrorKind::DbSubnetGroupNotFoundFault(inner) => {
                    Error::DbSubnetGroupNotFoundFault(inner)
                }
                crate::error::ModifyDBClusterErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::ModifyDBClusterErrorKind::InvalidDbInstanceStateFault(inner) => {
                    Error::InvalidDbInstanceStateFault(inner)
                }
                crate::error::ModifyDBClusterErrorKind::InvalidDbSecurityGroupStateFault(inner) => {
                    Error::InvalidDbSecurityGroupStateFault(inner)
                }
                crate::error::ModifyDBClusterErrorKind::InvalidDbSubnetGroupStateFault(inner) => {
                    Error::InvalidDbSubnetGroupStateFault(inner)
                }
                crate::error::ModifyDBClusterErrorKind::InvalidSubnet(inner) => {
                    Error::InvalidSubnet(inner)
                }
                crate::error::ModifyDBClusterErrorKind::InvalidVpcNetworkStateFault(inner) => {
                    Error::InvalidVpcNetworkStateFault(inner)
                }
                crate::error::ModifyDBClusterErrorKind::StorageQuotaExceededFault(inner) => {
                    Error::StorageQuotaExceededFault(inner)
                }
                crate::error::ModifyDBClusterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyDBClusterParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyDBClusterParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(inner) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::ModifyDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault(inner) => Error::InvalidDbParameterGroupStateFault(inner),
                crate::error::ModifyDBClusterParameterGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ModifyDBClusterSnapshotAttributeError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ModifyDBClusterSnapshotAttributeError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyDBClusterSnapshotAttributeErrorKind::DbClusterSnapshotNotFoundFault(inner) => Error::DbClusterSnapshotNotFoundFault(inner),
                crate::error::ModifyDBClusterSnapshotAttributeErrorKind::InvalidDbClusterSnapshotStateFault(inner) => Error::InvalidDbClusterSnapshotStateFault(inner),
                crate::error::ModifyDBClusterSnapshotAttributeErrorKind::SharedSnapshotQuotaExceededFault(inner) => Error::SharedSnapshotQuotaExceededFault(inner),
                crate::error::ModifyDBClusterSnapshotAttributeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyDBInstanceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyDBInstanceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyDBInstanceErrorKind::AuthorizationNotFoundFault(inner) => {
                    Error::AuthorizationNotFoundFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::CertificateNotFoundFault(inner) => {
                    Error::CertificateNotFoundFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::DbInstanceAlreadyExistsFault(inner) => {
                    Error::DbInstanceAlreadyExistsFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::DbParameterGroupNotFoundFault(inner) => {
                    Error::DbParameterGroupNotFoundFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::DbSecurityGroupNotFoundFault(inner) => {
                    Error::DbSecurityGroupNotFoundFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::DbUpgradeDependencyFailureFault(inner) => {
                    Error::DbUpgradeDependencyFailureFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::InsufficientDbInstanceCapacityFault(
                    inner,
                ) => Error::InsufficientDbInstanceCapacityFault(inner),
                crate::error::ModifyDBInstanceErrorKind::InvalidDbInstanceStateFault(inner) => {
                    Error::InvalidDbInstanceStateFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::InvalidDbSecurityGroupStateFault(
                    inner,
                ) => Error::InvalidDbSecurityGroupStateFault(inner),
                crate::error::ModifyDBInstanceErrorKind::InvalidVpcNetworkStateFault(inner) => {
                    Error::InvalidVpcNetworkStateFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::StorageQuotaExceededFault(inner) => {
                    Error::StorageQuotaExceededFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::StorageTypeNotSupportedFault(inner) => {
                    Error::StorageTypeNotSupportedFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyDBSubnetGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyDBSubnetGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyDBSubnetGroupErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(
                    inner,
                ) => Error::DbSubnetGroupDoesNotCoverEnoughAZs(inner),
                crate::error::ModifyDBSubnetGroupErrorKind::DbSubnetGroupNotFoundFault(inner) => {
                    Error::DbSubnetGroupNotFoundFault(inner)
                }
                crate::error::ModifyDBSubnetGroupErrorKind::DbSubnetQuotaExceededFault(inner) => {
                    Error::DbSubnetQuotaExceededFault(inner)
                }
                crate::error::ModifyDBSubnetGroupErrorKind::InvalidSubnet(inner) => {
                    Error::InvalidSubnet(inner)
                }
                crate::error::ModifyDBSubnetGroupErrorKind::SubnetAlreadyInUse(inner) => {
                    Error::SubnetAlreadyInUse(inner)
                }
                crate::error::ModifyDBSubnetGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyEventSubscriptionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyEventSubscriptionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyEventSubscriptionErrorKind::EventSubscriptionQuotaExceededFault(inner) => Error::EventSubscriptionQuotaExceededFault(inner),
                crate::error::ModifyEventSubscriptionErrorKind::SnsInvalidTopicFault(inner) => Error::SnsInvalidTopicFault(inner),
                crate::error::ModifyEventSubscriptionErrorKind::SnsNoAuthorizationFault(inner) => Error::SnsNoAuthorizationFault(inner),
                crate::error::ModifyEventSubscriptionErrorKind::SnsTopicArnNotFoundFault(inner) => Error::SnsTopicArnNotFoundFault(inner),
                crate::error::ModifyEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault(inner) => Error::SubscriptionCategoryNotFoundFault(inner),
                crate::error::ModifyEventSubscriptionErrorKind::SubscriptionNotFoundFault(inner) => Error::SubscriptionNotFoundFault(inner),
                crate::error::ModifyEventSubscriptionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyGlobalClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyGlobalClusterError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyGlobalClusterErrorKind::GlobalClusterNotFoundFault(inner) => {
                    Error::GlobalClusterNotFoundFault(inner)
                }
                crate::error::ModifyGlobalClusterErrorKind::InvalidGlobalClusterStateFault(
                    inner,
                ) => Error::InvalidGlobalClusterStateFault(inner),
                crate::error::ModifyGlobalClusterErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RebootDBInstanceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RebootDBInstanceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RebootDBInstanceErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::RebootDBInstanceErrorKind::InvalidDbInstanceStateFault(inner) => {
                    Error::InvalidDbInstanceStateFault(inner)
                }
                crate::error::RebootDBInstanceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RemoveFromGlobalClusterError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RemoveFromGlobalClusterError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RemoveFromGlobalClusterErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::RemoveFromGlobalClusterErrorKind::GlobalClusterNotFoundFault(
                    inner,
                ) => Error::GlobalClusterNotFoundFault(inner),
                crate::error::RemoveFromGlobalClusterErrorKind::InvalidGlobalClusterStateFault(
                    inner,
                ) => Error::InvalidGlobalClusterStateFault(inner),
                crate::error::RemoveFromGlobalClusterErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::RemoveSourceIdentifierFromSubscriptionError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::RemoveSourceIdentifierFromSubscriptionError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RemoveSourceIdentifierFromSubscriptionErrorKind::SourceNotFoundFault(inner) => Error::SourceNotFoundFault(inner),
                crate::error::RemoveSourceIdentifierFromSubscriptionErrorKind::SubscriptionNotFoundFault(inner) => Error::SubscriptionNotFoundFault(inner),
                crate::error::RemoveSourceIdentifierFromSubscriptionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RemoveTagsFromResourceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RemoveTagsFromResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RemoveTagsFromResourceErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::RemoveTagsFromResourceErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::RemoveTagsFromResourceErrorKind::DbSnapshotNotFoundFault(inner) => {
                    Error::DbSnapshotNotFoundFault(inner)
                }
                crate::error::RemoveTagsFromResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ResetDBClusterParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ResetDBClusterParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ResetDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(inner) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::ResetDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault(inner) => Error::InvalidDbParameterGroupStateFault(inner),
                crate::error::ResetDBClusterParameterGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RestoreDBClusterFromSnapshotError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RestoreDBClusterFromSnapshotError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RestoreDBClusterFromSnapshotErrorKind::DbClusterAlreadyExistsFault(inner) => Error::DbClusterAlreadyExistsFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::DbClusterQuotaExceededFault(inner) => Error::DbClusterQuotaExceededFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::DbClusterSnapshotNotFoundFault(inner) => Error::DbClusterSnapshotNotFoundFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::DbSnapshotNotFoundFault(inner) => Error::DbSnapshotNotFoundFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::DbSubnetGroupNotFoundFault(inner) => Error::DbSubnetGroupNotFoundFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::InsufficientDbClusterCapacityFault(inner) => Error::InsufficientDbClusterCapacityFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::InsufficientStorageClusterCapacityFault(inner) => Error::InsufficientStorageClusterCapacityFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(inner) => Error::InvalidDbClusterSnapshotStateFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::InvalidDbSnapshotStateFault(inner) => Error::InvalidDbSnapshotStateFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::InvalidRestoreFault(inner) => Error::InvalidRestoreFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::InvalidSubnet(inner) => Error::InvalidSubnet(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::InvalidVpcNetworkStateFault(inner) => Error::InvalidVpcNetworkStateFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::KmsKeyNotAccessibleFault(inner) => Error::KmsKeyNotAccessibleFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::StorageQuotaExceededFault(inner) => Error::StorageQuotaExceededFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RestoreDBClusterToPointInTimeError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RestoreDBClusterToPointInTimeError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RestoreDBClusterToPointInTimeErrorKind::DbClusterAlreadyExistsFault(inner) => Error::DbClusterAlreadyExistsFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::DbClusterNotFoundFault(inner) => Error::DbClusterNotFoundFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::DbClusterQuotaExceededFault(inner) => Error::DbClusterQuotaExceededFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::DbClusterSnapshotNotFoundFault(inner) => Error::DbClusterSnapshotNotFoundFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::DbSubnetGroupNotFoundFault(inner) => Error::DbSubnetGroupNotFoundFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::InsufficientDbClusterCapacityFault(inner) => Error::InsufficientDbClusterCapacityFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::InsufficientStorageClusterCapacityFault(inner) => Error::InsufficientStorageClusterCapacityFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::InvalidDbClusterSnapshotStateFault(inner) => Error::InvalidDbClusterSnapshotStateFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::InvalidDbClusterStateFault(inner) => Error::InvalidDbClusterStateFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::InvalidDbSnapshotStateFault(inner) => Error::InvalidDbSnapshotStateFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::InvalidRestoreFault(inner) => Error::InvalidRestoreFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::InvalidSubnet(inner) => Error::InvalidSubnet(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::InvalidVpcNetworkStateFault(inner) => Error::InvalidVpcNetworkStateFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::KmsKeyNotAccessibleFault(inner) => Error::KmsKeyNotAccessibleFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::StorageQuotaExceededFault(inner) => Error::StorageQuotaExceededFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartDBClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::StartDBClusterError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartDBClusterErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::StartDBClusterErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::StartDBClusterErrorKind::InvalidDbInstanceStateFault(inner) => {
                    Error::InvalidDbInstanceStateFault(inner)
                }
                crate::error::StartDBClusterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopDBClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::StopDBClusterError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StopDBClusterErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::StopDBClusterErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::StopDBClusterErrorKind::InvalidDbInstanceStateFault(inner) => {
                    Error::InvalidDbInstanceStateFault(inner)
                }
                crate::error::StopDBClusterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
