// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AddSourceIdentifierToSubscriptionInput`](crate::input::AddSourceIdentifierToSubscriptionInput)
pub mod add_source_identifier_to_subscription_input {
    /// A builder for [`AddSourceIdentifierToSubscriptionInput`](crate::input::AddSourceIdentifierToSubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_name: std::option::Option<std::string::String>,
        pub(crate) source_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon DocumentDB event notification subscription that you
        /// want to add a source identifier to.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon DocumentDB event notification subscription that you
        /// want to add a source identifier to.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_name = input;
            self
        }
        /// <p>The identifier of the event source to be added:</p>
        /// <ul>
        /// <li>
        /// <p>If the source type is an instance, a
        /// <code>DBInstanceIdentifier</code> must be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a security group, a
        /// <code>DBSecurityGroupName</code> must be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a parameter group, a
        /// <code>DBParameterGroupName</code> must be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a snapshot, a
        /// <code>DBSnapshotIdentifier</code> must be provided.</p>
        /// </li>
        /// </ul>
        pub fn source_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the event source to be added:</p>
        /// <ul>
        /// <li>
        /// <p>If the source type is an instance, a
        /// <code>DBInstanceIdentifier</code> must be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a security group, a
        /// <code>DBSecurityGroupName</code> must be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a parameter group, a
        /// <code>DBParameterGroupName</code> must be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a snapshot, a
        /// <code>DBSnapshotIdentifier</code> must be provided.</p>
        /// </li>
        /// </ul>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`AddSourceIdentifierToSubscriptionInput`](crate::input::AddSourceIdentifierToSubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddSourceIdentifierToSubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddSourceIdentifierToSubscriptionInput {
                subscription_name: self.subscription_name,
                source_identifier: self.source_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type AddSourceIdentifierToSubscriptionInputOperationOutputAlias =
    crate::operation::AddSourceIdentifierToSubscription;
#[doc(hidden)]
pub type AddSourceIdentifierToSubscriptionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddSourceIdentifierToSubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`AddSourceIdentifierToSubscription`](crate::operation::AddSourceIdentifierToSubscription)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddSourceIdentifierToSubscription,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddSourceIdentifierToSubscriptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddSourceIdentifierToSubscriptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddSourceIdentifierToSubscriptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_source_identifier_to_subscription(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddSourceIdentifierToSubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddSourceIdentifierToSubscription",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddSourceIdentifierToSubscriptionInput`](crate::input::AddSourceIdentifierToSubscriptionInput)
    pub fn builder() -> crate::input::add_source_identifier_to_subscription_input::Builder {
        crate::input::add_source_identifier_to_subscription_input::Builder::default()
    }
}

/// See [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
pub mod add_tags_to_resource_input {
    /// A builder for [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon DocumentDB resource that the tags are added to. This value is an
        /// Amazon Resource Name .</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The Amazon DocumentDB resource that the tags are added to. This value is an
        /// Amazon Resource Name .</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the Amazon DocumentDB resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be assigned to the Amazon DocumentDB resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddTagsToResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddTagsToResourceInput {
                resource_name: self.resource_name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type AddTagsToResourceInputOperationOutputAlias = crate::operation::AddTagsToResource;
#[doc(hidden)]
pub type AddTagsToResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddTagsToResourceInput {
    /// Consumes the builder and constructs an Operation<[`AddTagsToResource`](crate::operation::AddTagsToResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddTagsToResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddTagsToResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddTagsToResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddTagsToResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_tags_to_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddTagsToResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddTagsToResource",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
    pub fn builder() -> crate::input::add_tags_to_resource_input::Builder {
        crate::input::add_tags_to_resource_input::Builder::default()
    }
}

/// See [`ApplyPendingMaintenanceActionInput`](crate::input::ApplyPendingMaintenanceActionInput)
pub mod apply_pending_maintenance_action_input {
    /// A builder for [`ApplyPendingMaintenanceActionInput`](crate::input::ApplyPendingMaintenanceActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_identifier: std::option::Option<std::string::String>,
        pub(crate) apply_action: std::option::Option<std::string::String>,
        pub(crate) opt_in_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource that the pending
        /// maintenance action applies to.</p>
        pub fn resource_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_identifier = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that the pending
        /// maintenance action applies to.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_identifier = input;
            self
        }
        /// <p>The pending maintenance action to apply to this resource.</p>
        /// <p>Valid values: <code>system-update</code>, <code>db-upgrade</code>
        /// </p>
        pub fn apply_action(mut self, input: impl Into<std::string::String>) -> Self {
            self.apply_action = Some(input.into());
            self
        }
        /// <p>The pending maintenance action to apply to this resource.</p>
        /// <p>Valid values: <code>system-update</code>, <code>db-upgrade</code>
        /// </p>
        pub fn set_apply_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.apply_action = input;
            self
        }
        /// <p>A value that specifies the type of opt-in request or undoes an
        /// opt-in request. An opt-in request of type <code>immediate</code>
        /// can't be undone.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>immediate</code> - Apply the maintenance action
        /// immediately.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>next-maintenance</code> - Apply the maintenance
        /// action during the next maintenance window for the resource.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>undo-opt-in</code> - Cancel any existing
        /// <code>next-maintenance</code> opt-in requests.</p>
        /// </li>
        /// </ul>
        pub fn opt_in_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_in_type = Some(input.into());
            self
        }
        /// <p>A value that specifies the type of opt-in request or undoes an
        /// opt-in request. An opt-in request of type <code>immediate</code>
        /// can't be undone.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>immediate</code> - Apply the maintenance action
        /// immediately.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>next-maintenance</code> - Apply the maintenance
        /// action during the next maintenance window for the resource.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>undo-opt-in</code> - Cancel any existing
        /// <code>next-maintenance</code> opt-in requests.</p>
        /// </li>
        /// </ul>
        pub fn set_opt_in_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.opt_in_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplyPendingMaintenanceActionInput`](crate::input::ApplyPendingMaintenanceActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ApplyPendingMaintenanceActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ApplyPendingMaintenanceActionInput {
                resource_identifier: self.resource_identifier,
                apply_action: self.apply_action,
                opt_in_type: self.opt_in_type,
            })
        }
    }
}
#[doc(hidden)]
pub type ApplyPendingMaintenanceActionInputOperationOutputAlias =
    crate::operation::ApplyPendingMaintenanceAction;
#[doc(hidden)]
pub type ApplyPendingMaintenanceActionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ApplyPendingMaintenanceActionInput {
    /// Consumes the builder and constructs an Operation<[`ApplyPendingMaintenanceAction`](crate::operation::ApplyPendingMaintenanceAction)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ApplyPendingMaintenanceAction,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ApplyPendingMaintenanceActionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ApplyPendingMaintenanceActionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ApplyPendingMaintenanceActionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_apply_pending_maintenance_action(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ApplyPendingMaintenanceAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ApplyPendingMaintenanceAction",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ApplyPendingMaintenanceActionInput`](crate::input::ApplyPendingMaintenanceActionInput)
    pub fn builder() -> crate::input::apply_pending_maintenance_action_input::Builder {
        crate::input::apply_pending_maintenance_action_input::Builder::default()
    }
}

/// See [`CopyDbClusterParameterGroupInput`](crate::input::CopyDbClusterParameterGroupInput)
pub mod copy_db_cluster_parameter_group_input {
    /// A builder for [`CopyDbClusterParameterGroupInput`](crate::input::CopyDbClusterParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_db_cluster_parameter_group_identifier:
            std::option::Option<std::string::String>,
        pub(crate) target_db_cluster_parameter_group_identifier:
            std::option::Option<std::string::String>,
        pub(crate) target_db_cluster_parameter_group_description:
            std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The identifier or Amazon Resource Name (ARN) for the source cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must specify a valid cluster parameter group.</p>
        /// </li>
        /// <li>
        /// <p>If the source cluster parameter group is in the same Region as the copy, specify a valid parameter group identifier; for example, <code>my-db-cluster-param-group</code>, or a valid ARN.</p>
        /// </li>
        /// <li>
        /// <p>If the source parameter group is in a different Region than the copy, specify a valid cluster parameter group ARN; for example, <code>arn:aws:rds:us-east-1:123456789012:sample-cluster:sample-parameter-group</code>.</p>
        /// </li>
        /// </ul>
        pub fn source_db_cluster_parameter_group_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.source_db_cluster_parameter_group_identifier = Some(input.into());
            self
        }
        /// <p>The identifier or Amazon Resource Name (ARN) for the source cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must specify a valid cluster parameter group.</p>
        /// </li>
        /// <li>
        /// <p>If the source cluster parameter group is in the same Region as the copy, specify a valid parameter group identifier; for example, <code>my-db-cluster-param-group</code>, or a valid ARN.</p>
        /// </li>
        /// <li>
        /// <p>If the source parameter group is in a different Region than the copy, specify a valid cluster parameter group ARN; for example, <code>arn:aws:rds:us-east-1:123456789012:sample-cluster:sample-parameter-group</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_source_db_cluster_parameter_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_db_cluster_parameter_group_identifier = input;
            self
        }
        /// <p>The identifier for the copied cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Cannot be null, empty, or blank.</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 letters, numbers, or hyphens.
        /// </p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-param-group1</code>
        /// </p>
        pub fn target_db_cluster_parameter_group_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.target_db_cluster_parameter_group_identifier = Some(input.into());
            self
        }
        /// <p>The identifier for the copied cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Cannot be null, empty, or blank.</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 letters, numbers, or hyphens.
        /// </p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-param-group1</code>
        /// </p>
        pub fn set_target_db_cluster_parameter_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_db_cluster_parameter_group_identifier = input;
            self
        }
        /// <p>A description for the copied cluster parameter group.</p>
        pub fn target_db_cluster_parameter_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.target_db_cluster_parameter_group_description = Some(input.into());
            self
        }
        /// <p>A description for the copied cluster parameter group.</p>
        pub fn set_target_db_cluster_parameter_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_db_cluster_parameter_group_description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags that are to be assigned to the parameter group.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags that are to be assigned to the parameter group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyDbClusterParameterGroupInput`](crate::input::CopyDbClusterParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CopyDbClusterParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CopyDbClusterParameterGroupInput {
                source_db_cluster_parameter_group_identifier: self
                    .source_db_cluster_parameter_group_identifier,
                target_db_cluster_parameter_group_identifier: self
                    .target_db_cluster_parameter_group_identifier,
                target_db_cluster_parameter_group_description: self
                    .target_db_cluster_parameter_group_description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CopyDbClusterParameterGroupInputOperationOutputAlias =
    crate::operation::CopyDBClusterParameterGroup;
#[doc(hidden)]
pub type CopyDbClusterParameterGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CopyDbClusterParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`CopyDBClusterParameterGroup`](crate::operation::CopyDBClusterParameterGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CopyDBClusterParameterGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CopyDbClusterParameterGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CopyDbClusterParameterGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CopyDbClusterParameterGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_copy_db_cluster_parameter_group(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CopyDBClusterParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CopyDBClusterParameterGroup",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CopyDbClusterParameterGroupInput`](crate::input::CopyDbClusterParameterGroupInput)
    pub fn builder() -> crate::input::copy_db_cluster_parameter_group_input::Builder {
        crate::input::copy_db_cluster_parameter_group_input::Builder::default()
    }
}

/// See [`CopyDbClusterSnapshotInput`](crate::input::CopyDbClusterSnapshotInput)
pub mod copy_db_cluster_snapshot_input {
    /// A builder for [`CopyDbClusterSnapshotInput`](crate::input::CopyDbClusterSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) target_db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) pre_signed_url: std::option::Option<std::string::String>,
        pub(crate) copy_tags: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The identifier of the cluster snapshot to copy. This parameter is
        /// not case sensitive.</p>
        ///
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must specify a valid system snapshot in the
        /// <i>available</i> state.</p>
        /// </li>
        /// <li>
        /// <p>If the source snapshot is in the same Region as the copy, specify a valid snapshot identifier.</p>
        /// </li>
        /// <li>
        ///
        /// <p>If the source snapshot is in a different Region than the copy, specify a valid cluster snapshot ARN.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot1</code>
        /// </p>
        pub fn source_db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.source_db_cluster_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster snapshot to copy. This parameter is
        /// not case sensitive.</p>
        ///
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must specify a valid system snapshot in the
        /// <i>available</i> state.</p>
        /// </li>
        /// <li>
        /// <p>If the source snapshot is in the same Region as the copy, specify a valid snapshot identifier.</p>
        /// </li>
        /// <li>
        ///
        /// <p>If the source snapshot is in a different Region than the copy, specify a valid cluster snapshot ARN.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot1</code>
        /// </p>
        pub fn set_source_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_db_cluster_snapshot_identifier = input;
            self
        }
        /// <p>The identifier of the new cluster snapshot to create from the
        /// source cluster snapshot. This parameter is not case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.
        /// </p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot2</code>
        /// </p>
        pub fn target_db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.target_db_cluster_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the new cluster snapshot to create from the
        /// source cluster snapshot. This parameter is not case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.
        /// </p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot2</code>
        /// </p>
        pub fn set_target_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_db_cluster_snapshot_identifier = input;
            self
        }
        /// <p>The KMS key ID for an encrypted cluster snapshot. The KMS
        /// key ID is the Amazon Resource Name (ARN), KMS key identifier, or
        /// the KMS key alias for the KMS encryption key. </p>
        ///
        /// <p>If you copy an encrypted cluster snapshot from your account, you can specify a value for <code>KmsKeyId</code> to encrypt the copy with a new KMS encryption key. If you don't specify a value for <code>KmsKeyId</code>, then the copy of the cluster snapshot is encrypted with the same KMS key as the source cluster snapshot.</p>
        ///
        /// <p>If you copy an encrypted cluster snapshot that is shared from another account, then you must specify a value for <code>KmsKeyId</code>.</p>
        ///
        /// <p>To copy an encrypted cluster snapshot to another Region, set <code>KmsKeyId</code> to the KMS key ID that you want to use to encrypt the copy of the cluster snapshot in the destination Region. KMS encryption keys are specific to the Region that they are created in, and you can't use encryption keys from one Region in another Region.</p>
        ///
        /// <p>If you copy an unencrypted cluster snapshot and specify a value for the <code>KmsKeyId</code> parameter, an error is returned.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The KMS key ID for an encrypted cluster snapshot. The KMS
        /// key ID is the Amazon Resource Name (ARN), KMS key identifier, or
        /// the KMS key alias for the KMS encryption key. </p>
        ///
        /// <p>If you copy an encrypted cluster snapshot from your account, you can specify a value for <code>KmsKeyId</code> to encrypt the copy with a new KMS encryption key. If you don't specify a value for <code>KmsKeyId</code>, then the copy of the cluster snapshot is encrypted with the same KMS key as the source cluster snapshot.</p>
        ///
        /// <p>If you copy an encrypted cluster snapshot that is shared from another account, then you must specify a value for <code>KmsKeyId</code>.</p>
        ///
        /// <p>To copy an encrypted cluster snapshot to another Region, set <code>KmsKeyId</code> to the KMS key ID that you want to use to encrypt the copy of the cluster snapshot in the destination Region. KMS encryption keys are specific to the Region that they are created in, and you can't use encryption keys from one Region in another Region.</p>
        ///
        /// <p>If you copy an unencrypted cluster snapshot and specify a value for the <code>KmsKeyId</code> parameter, an error is returned.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The URL that contains a Signature Version 4 signed request for the<code>CopyDBClusterSnapshot</code> API action in the Region that contains the source cluster snapshot to copy. You must use the <code>PreSignedUrl</code> parameter when copying a cluster snapshot from another Region.</p>
        ///
        /// <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify
        /// <code>SourceRegion</code> (or <code>--source-region</code> for the
        /// CLI) instead of specifying <code>PreSignedUrl</code> manually.
        /// Specifying <code>SourceRegion</code> autogenerates a pre-signed URL
        /// that is a valid request for the operation that can be executed in
        /// the source Region.</p>
        ///
        /// <p>The presigned URL must be a valid request for the
        /// <code>CopyDBClusterSnapshot</code> API action that can be executed
        /// in the source Region that contains the cluster snapshot to be
        /// copied. The presigned URL request must contain the following
        /// parameter values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SourceRegion</code> - The ID of the region that
        /// contains the snapshot to be copied.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SourceDBClusterSnapshotIdentifier</code> - The
        /// identifier for the the encrypted cluster snapshot to be
        /// copied. This identifier must be in the Amazon Resource Name
        /// (ARN) format for the source Region. For example, if you
        /// are copying an encrypted cluster snapshot from the us-east-1
        /// Region, then your
        /// <code>SourceDBClusterSnapshotIdentifier</code> looks
        /// something like the following:
        /// <code>arn:aws:rds:us-east-1:12345678012:sample-cluster:sample-cluster-snapshot</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TargetDBClusterSnapshotIdentifier</code> - The
        /// identifier for the new cluster snapshot to be created. This
        /// parameter isn't case sensitive.</p>
        /// </li>
        /// </ul>
        pub fn pre_signed_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.pre_signed_url = Some(input.into());
            self
        }
        /// <p>The URL that contains a Signature Version 4 signed request for the<code>CopyDBClusterSnapshot</code> API action in the Region that contains the source cluster snapshot to copy. You must use the <code>PreSignedUrl</code> parameter when copying a cluster snapshot from another Region.</p>
        ///
        /// <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify
        /// <code>SourceRegion</code> (or <code>--source-region</code> for the
        /// CLI) instead of specifying <code>PreSignedUrl</code> manually.
        /// Specifying <code>SourceRegion</code> autogenerates a pre-signed URL
        /// that is a valid request for the operation that can be executed in
        /// the source Region.</p>
        ///
        /// <p>The presigned URL must be a valid request for the
        /// <code>CopyDBClusterSnapshot</code> API action that can be executed
        /// in the source Region that contains the cluster snapshot to be
        /// copied. The presigned URL request must contain the following
        /// parameter values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SourceRegion</code> - The ID of the region that
        /// contains the snapshot to be copied.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SourceDBClusterSnapshotIdentifier</code> - The
        /// identifier for the the encrypted cluster snapshot to be
        /// copied. This identifier must be in the Amazon Resource Name
        /// (ARN) format for the source Region. For example, if you
        /// are copying an encrypted cluster snapshot from the us-east-1
        /// Region, then your
        /// <code>SourceDBClusterSnapshotIdentifier</code> looks
        /// something like the following:
        /// <code>arn:aws:rds:us-east-1:12345678012:sample-cluster:sample-cluster-snapshot</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TargetDBClusterSnapshotIdentifier</code> - The
        /// identifier for the new cluster snapshot to be created. This
        /// parameter isn't case sensitive.</p>
        /// </li>
        /// </ul>
        pub fn set_pre_signed_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pre_signed_url = input;
            self
        }
        /// <p>Set to <code>true</code> to copy all tags from the source cluster
        /// snapshot to the target cluster snapshot, and otherwise
        /// <code>false</code>. The default is <code>false</code>.</p>
        pub fn copy_tags(mut self, input: bool) -> Self {
            self.copy_tags = Some(input);
            self
        }
        /// <p>Set to <code>true</code> to copy all tags from the source cluster
        /// snapshot to the target cluster snapshot, and otherwise
        /// <code>false</code>. The default is <code>false</code>.</p>
        pub fn set_copy_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_tags = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the cluster snapshot.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be assigned to the cluster snapshot.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyDbClusterSnapshotInput`](crate::input::CopyDbClusterSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CopyDbClusterSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CopyDbClusterSnapshotInput {
                source_db_cluster_snapshot_identifier: self.source_db_cluster_snapshot_identifier,
                target_db_cluster_snapshot_identifier: self.target_db_cluster_snapshot_identifier,
                kms_key_id: self.kms_key_id,
                pre_signed_url: self.pre_signed_url,
                copy_tags: self.copy_tags,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CopyDbClusterSnapshotInputOperationOutputAlias = crate::operation::CopyDBClusterSnapshot;
#[doc(hidden)]
pub type CopyDbClusterSnapshotInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CopyDbClusterSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`CopyDBClusterSnapshot`](crate::operation::CopyDBClusterSnapshot)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CopyDBClusterSnapshot,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CopyDbClusterSnapshotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CopyDbClusterSnapshotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CopyDbClusterSnapshotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_copy_db_cluster_snapshot(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CopyDBClusterSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CopyDBClusterSnapshot",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CopyDbClusterSnapshotInput`](crate::input::CopyDbClusterSnapshotInput)
    pub fn builder() -> crate::input::copy_db_cluster_snapshot_input::Builder {
        crate::input::copy_db_cluster_snapshot_input::Builder::default()
    }
}

/// See [`CreateDbClusterInput`](crate::input::CreateDbClusterInput)
pub mod create_db_cluster_input {
    /// A builder for [`CreateDbClusterInput`](crate::input::CreateDbClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) backup_retention_period: std::option::Option<i32>,
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) db_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) master_username: std::option::Option<std::string::String>,
        pub(crate) master_user_password: std::option::Option<std::string::String>,
        pub(crate) preferred_backup_window: std::option::Option<std::string::String>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) storage_encrypted: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) pre_signed_url: std::option::Option<std::string::String>,
        pub(crate) enable_cloudwatch_logs_exports:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) deletion_protection: std::option::Option<bool>,
        pub(crate) global_cluster_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>A list of Amazon EC2 Availability Zones that instances in the
        /// cluster can be created in.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>A list of Amazon EC2 Availability Zones that instances in the
        /// cluster can be created in.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// <p>The number of days for which automated backups are retained. You
        /// must specify a minimum value of 1.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be a value from 1 to 35.</p>
        /// </li>
        /// </ul>
        pub fn backup_retention_period(mut self, input: i32) -> Self {
            self.backup_retention_period = Some(input);
            self
        }
        /// <p>The number of days for which automated backups are retained. You
        /// must specify a minimum value of 1.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be a value from 1 to 35.</p>
        /// </li>
        /// </ul>
        pub fn set_backup_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.backup_retention_period = input;
            self
        }
        /// <p>The cluster identifier. This parameter is stored as a lowercase
        /// string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.
        /// </p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster</code>
        /// </p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier. This parameter is stored as a lowercase
        /// string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.
        /// </p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster</code>
        /// </p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>The name of the cluster parameter group to associate with this
        /// cluster.</p>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cluster parameter group to associate with this
        /// cluster.</p>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = input;
            self
        }
        /// Appends an item to `vpc_security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of EC2 VPC security groups to associate with this cluster.
        /// </p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpc_security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.vpc_security_group_ids = Some(v);
            self
        }
        /// <p>A list of EC2 VPC security groups to associate with this cluster.
        /// </p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpc_security_group_ids = input;
            self
        }
        /// <p>A subnet group to associate with this cluster.</p>
        /// <p>Constraints: Must match the name of an existing
        /// <code>DBSubnetGroup</code>. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group_name = Some(input.into());
            self
        }
        /// <p>A subnet group to associate with this cluster.</p>
        /// <p>Constraints: Must match the name of an existing
        /// <code>DBSubnetGroup</code>. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_name = input;
            self
        }
        /// <p>The name of the database engine to be used for this cluster.</p>
        /// <p>Valid values: <code>docdb</code>
        /// </p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The name of the database engine to be used for this cluster.</p>
        /// <p>Valid values: <code>docdb</code>
        /// </p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The version number of the database engine to use. The <code>--engine-version</code> will default to the latest major engine version. For production workloads, we recommend explicitly declaring this parameter with the intended major engine version.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The version number of the database engine to use. The <code>--engine-version</code> will default to the latest major engine version. For production workloads, we recommend explicitly declaring this parameter with the intended major engine version.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The port number on which the instances in the cluster accept
        /// connections.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number on which the instances in the cluster accept
        /// connections.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The name of the master user for the cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be from 1 to 63 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot be a reserved word for the chosen database engine.
        /// </p>
        /// </li>
        /// </ul>
        pub fn master_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_username = Some(input.into());
            self
        }
        /// <p>The name of the master user for the cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be from 1 to 63 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot be a reserved word for the chosen database engine.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_master_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_username = input;
            self
        }
        /// <p>The password for the master database user. This password can
        /// contain any printable ASCII character except forward slash (/),
        /// double quote ("), or the "at" symbol (@).</p>
        /// <p>Constraints: Must contain from 8 to 100 characters.</p>
        pub fn master_user_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_user_password = Some(input.into());
            self
        }
        /// <p>The password for the master database user. This password can
        /// contain any printable ASCII character except forward slash (/),
        /// double quote ("), or the "at" symbol (@).</p>
        /// <p>Constraints: Must contain from 8 to 100 characters.</p>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_user_password = input;
            self
        }
        /// <p>The daily time range during which automated backups are created if
        /// automated backups are enabled using the <code>BackupRetentionPeriod</code> parameter. </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Region. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p>
        /// </li>
        /// <li>
        /// <p>Must be in Universal Coordinated Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Must not conflict with the preferred maintenance window.
        /// </p>
        /// </li>
        /// <li>
        /// <p>Must be at least 30 minutes.</p>
        /// </li>
        /// </ul>
        pub fn preferred_backup_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.preferred_backup_window = Some(input.into());
            self
        }
        /// <p>The daily time range during which automated backups are created if
        /// automated backups are enabled using the <code>BackupRetentionPeriod</code> parameter. </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Region. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p>
        /// </li>
        /// <li>
        /// <p>Must be in Universal Coordinated Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Must not conflict with the preferred maintenance window.
        /// </p>
        /// </li>
        /// <li>
        /// <p>Must be at least 30 minutes.</p>
        /// </li>
        /// </ul>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_backup_window = input;
            self
        }
        /// <p>The weekly time range during which system maintenance can occur,
        /// in Universal Coordinated Time (UTC).</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Region, occurring on a random day of the week.</p>
        /// <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>The weekly time range during which system maintenance can occur,
        /// in Universal Coordinated Time (UTC).</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Region, occurring on a random day of the week.</p>
        /// <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the cluster.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be assigned to the cluster.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Specifies whether the cluster is encrypted.</p>
        pub fn storage_encrypted(mut self, input: bool) -> Self {
            self.storage_encrypted = Some(input);
            self
        }
        /// <p>Specifies whether the cluster is encrypted.</p>
        pub fn set_storage_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.storage_encrypted = input;
            self
        }
        /// <p>The KMS key identifier for an encrypted cluster.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a cluster using the same account that owns the KMS encryption key that is used to encrypt the new cluster, you can use the KMS key alias instead of the ARN for the KMS encryption key.</p>
        /// <p>If an encryption key is not specified in <code>KmsKeyId</code>:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>If the <code>StorageEncrypted</code> parameter is
        /// <code>true</code>, Amazon DocumentDB uses your default encryption key.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>KMS creates the default encryption key for your account. Your account has a different default encryption key for each Regions.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The KMS key identifier for an encrypted cluster.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a cluster using the same account that owns the KMS encryption key that is used to encrypt the new cluster, you can use the KMS key alias instead of the ARN for the KMS encryption key.</p>
        /// <p>If an encryption key is not specified in <code>KmsKeyId</code>:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>If the <code>StorageEncrypted</code> parameter is
        /// <code>true</code>, Amazon DocumentDB uses your default encryption key.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>KMS creates the default encryption key for your account. Your account has a different default encryption key for each Regions.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>Not currently supported.
        /// </p>
        pub fn pre_signed_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.pre_signed_url = Some(input.into());
            self
        }
        /// <p>Not currently supported.
        /// </p>
        pub fn set_pre_signed_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pre_signed_url = input;
            self
        }
        /// Appends an item to `enable_cloudwatch_logs_exports`.
        ///
        /// To override the contents of this collection use [`set_enable_cloudwatch_logs_exports`](Self::set_enable_cloudwatch_logs_exports).
        ///
        /// <p>A list of log types that need to be enabled for exporting to Amazon
        /// CloudWatch Logs. You can enable audit logs or profiler logs. For more
        /// information, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/event-auditing.html">
        /// Auditing Amazon DocumentDB Events</a>
        /// and <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/profiling.html">
        /// Profiling Amazon DocumentDB Operations</a>.
        /// </p>
        pub fn enable_cloudwatch_logs_exports(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.enable_cloudwatch_logs_exports.unwrap_or_default();
            v.push(input.into());
            self.enable_cloudwatch_logs_exports = Some(v);
            self
        }
        /// <p>A list of log types that need to be enabled for exporting to Amazon
        /// CloudWatch Logs. You can enable audit logs or profiler logs. For more
        /// information, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/event-auditing.html">
        /// Auditing Amazon DocumentDB Events</a>
        /// and <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/profiling.html">
        /// Profiling Amazon DocumentDB Operations</a>.
        /// </p>
        pub fn set_enable_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.enable_cloudwatch_logs_exports = input;
            self
        }
        /// <p>Specifies whether this cluster can be deleted. If
        /// <code>DeletionProtection</code> is enabled, the cluster cannot be
        /// deleted unless it is modified and <code>DeletionProtection</code> is
        /// disabled. <code>DeletionProtection</code> protects clusters from
        /// being accidentally deleted.</p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.deletion_protection = Some(input);
            self
        }
        /// <p>Specifies whether this cluster can be deleted. If
        /// <code>DeletionProtection</code> is enabled, the cluster cannot be
        /// deleted unless it is modified and <code>DeletionProtection</code> is
        /// disabled. <code>DeletionProtection</code> protects clusters from
        /// being accidentally deleted.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection = input;
            self
        }
        /// <p>The cluster identifier of the new global cluster.</p>
        pub fn global_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier of the new global cluster.</p>
        pub fn set_global_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_cluster_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbClusterInput`](crate::input::CreateDbClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDbClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDbClusterInput {
                availability_zones: self.availability_zones,
                backup_retention_period: self.backup_retention_period,
                db_cluster_identifier: self.db_cluster_identifier,
                db_cluster_parameter_group_name: self.db_cluster_parameter_group_name,
                vpc_security_group_ids: self.vpc_security_group_ids,
                db_subnet_group_name: self.db_subnet_group_name,
                engine: self.engine,
                engine_version: self.engine_version,
                port: self.port,
                master_username: self.master_username,
                master_user_password: self.master_user_password,
                preferred_backup_window: self.preferred_backup_window,
                preferred_maintenance_window: self.preferred_maintenance_window,
                tags: self.tags,
                storage_encrypted: self.storage_encrypted,
                kms_key_id: self.kms_key_id,
                pre_signed_url: self.pre_signed_url,
                enable_cloudwatch_logs_exports: self.enable_cloudwatch_logs_exports,
                deletion_protection: self.deletion_protection,
                global_cluster_identifier: self.global_cluster_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDbClusterInputOperationOutputAlias = crate::operation::CreateDBCluster;
#[doc(hidden)]
pub type CreateDbClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDbClusterInput {
    /// Consumes the builder and constructs an Operation<[`CreateDBCluster`](crate::operation::CreateDBCluster)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDBCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDbClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDbClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDbClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_db_cluster(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDBCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDBCluster",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDbClusterInput`](crate::input::CreateDbClusterInput)
    pub fn builder() -> crate::input::create_db_cluster_input::Builder {
        crate::input::create_db_cluster_input::Builder::default()
    }
}

/// See [`CreateDbClusterParameterGroupInput`](crate::input::CreateDbClusterParameterGroupInput)
pub mod create_db_cluster_parameter_group_input {
    /// A builder for [`CreateDbClusterParameterGroupInput`](crate::input::CreateDbClusterParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) db_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must not match the name of an existing
        /// <code>DBClusterParameterGroup</code>.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must not match the name of an existing
        /// <code>DBClusterParameterGroup</code>.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = input;
            self
        }
        /// <p>The cluster parameter group family name.</p>
        pub fn db_parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_family = Some(input.into());
            self
        }
        /// <p>The cluster parameter group family name.</p>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_family = input;
            self
        }
        /// <p>The description for the cluster parameter group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the cluster parameter group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the cluster parameter group.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be assigned to the cluster parameter group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbClusterParameterGroupInput`](crate::input::CreateDbClusterParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDbClusterParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDbClusterParameterGroupInput {
                db_cluster_parameter_group_name: self.db_cluster_parameter_group_name,
                db_parameter_group_family: self.db_parameter_group_family,
                description: self.description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDbClusterParameterGroupInputOperationOutputAlias =
    crate::operation::CreateDBClusterParameterGroup;
#[doc(hidden)]
pub type CreateDbClusterParameterGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDbClusterParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateDBClusterParameterGroup`](crate::operation::CreateDBClusterParameterGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDBClusterParameterGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDbClusterParameterGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDbClusterParameterGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDbClusterParameterGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_db_cluster_parameter_group(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDBClusterParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDBClusterParameterGroup",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDbClusterParameterGroupInput`](crate::input::CreateDbClusterParameterGroupInput)
    pub fn builder() -> crate::input::create_db_cluster_parameter_group_input::Builder {
        crate::input::create_db_cluster_parameter_group_input::Builder::default()
    }
}

/// See [`CreateDbClusterSnapshotInput`](crate::input::CreateDbClusterSnapshotInput)
pub mod create_db_cluster_snapshot_input {
    /// A builder for [`CreateDbClusterSnapshotInput`](crate::input::CreateDbClusterSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The identifier of the cluster snapshot. This parameter is stored
        /// as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot1</code>
        /// </p>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster snapshot. This parameter is stored
        /// as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot1</code>
        /// </p>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = input;
            self
        }
        /// <p>The identifier of the cluster to create a snapshot for. This
        /// parameter is not case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing
        /// <code>DBCluster</code>.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster</code>
        /// </p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster to create a snapshot for. This
        /// parameter is not case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing
        /// <code>DBCluster</code>.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster</code>
        /// </p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the cluster snapshot.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be assigned to the cluster snapshot.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbClusterSnapshotInput`](crate::input::CreateDbClusterSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDbClusterSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDbClusterSnapshotInput {
                db_cluster_snapshot_identifier: self.db_cluster_snapshot_identifier,
                db_cluster_identifier: self.db_cluster_identifier,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDbClusterSnapshotInputOperationOutputAlias =
    crate::operation::CreateDBClusterSnapshot;
#[doc(hidden)]
pub type CreateDbClusterSnapshotInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDbClusterSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`CreateDBClusterSnapshot`](crate::operation::CreateDBClusterSnapshot)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDBClusterSnapshot,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDbClusterSnapshotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDbClusterSnapshotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDbClusterSnapshotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_db_cluster_snapshot(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDBClusterSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDBClusterSnapshot",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDbClusterSnapshotInput`](crate::input::CreateDbClusterSnapshotInput)
    pub fn builder() -> crate::input::create_db_cluster_snapshot_input::Builder {
        crate::input::create_db_cluster_snapshot_input::Builder::default()
    }
}

/// See [`CreateDbInstanceInput`](crate::input::CreateDbInstanceInput)
pub mod create_db_instance_input {
    /// A builder for [`CreateDbInstanceInput`](crate::input::CreateDbInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) db_instance_class: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) auto_minor_version_upgrade: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) promotion_tier: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The instance identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>mydbinstance</code>
        /// </p>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p>The instance identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>mydbinstance</code>
        /// </p>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// <p>The compute and memory capacity of the instance; for example,
        /// <code>db.r5.large</code>. </p>
        pub fn db_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_class = Some(input.into());
            self
        }
        /// <p>The compute and memory capacity of the instance; for example,
        /// <code>db.r5.large</code>. </p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_class = input;
            self
        }
        /// <p>The name of the database engine to be used for this instance.</p>
        /// <p>Valid value: <code>docdb</code>
        /// </p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The name of the database engine to be used for this instance.</p>
        /// <p>Valid value: <code>docdb</code>
        /// </p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The Amazon EC2 Availability Zone that the instance is created in. </p>
        /// <p>Default: A random, system-chosen Availability Zone in the endpoint's Region.</p>
        /// <p>Example: <code>us-east-1d</code>
        /// </p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Amazon EC2 Availability Zone that the instance is created in. </p>
        /// <p>Default: A random, system-chosen Availability Zone in the endpoint's Region.</p>
        /// <p>Example: <code>us-east-1d</code>
        /// </p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The time range each week during which system maintenance can occur, in Universal
        /// Coordinated Time (UTC).</p>
        /// <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for
        /// each Region, occurring on a random day of the week. </p>
        /// <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>The time range each week during which system maintenance can occur, in Universal
        /// Coordinated Time (UTC).</p>
        /// <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for
        /// each Region, occurring on a random day of the week. </p>
        /// <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p>This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.auto_minor_version_upgrade = Some(input);
            self
        }
        /// <p>This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_minor_version_upgrade = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the instance. You can assign up to
        /// 10 tags to an instance.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be assigned to the instance. You can assign up to
        /// 10 tags to an instance.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The identifier of the cluster that the instance will belong to.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster that the instance will belong to.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>A value that specifies the order in which an Amazon DocumentDB replica is promoted to the
        /// primary instance after a failure of the existing primary instance.</p>
        /// <p>Default: 1</p>
        /// <p>Valid values: 0-15</p>
        pub fn promotion_tier(mut self, input: i32) -> Self {
            self.promotion_tier = Some(input);
            self
        }
        /// <p>A value that specifies the order in which an Amazon DocumentDB replica is promoted to the
        /// primary instance after a failure of the existing primary instance.</p>
        /// <p>Default: 1</p>
        /// <p>Valid values: 0-15</p>
        pub fn set_promotion_tier(mut self, input: std::option::Option<i32>) -> Self {
            self.promotion_tier = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbInstanceInput`](crate::input::CreateDbInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDbInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDbInstanceInput {
                db_instance_identifier: self.db_instance_identifier,
                db_instance_class: self.db_instance_class,
                engine: self.engine,
                availability_zone: self.availability_zone,
                preferred_maintenance_window: self.preferred_maintenance_window,
                auto_minor_version_upgrade: self.auto_minor_version_upgrade,
                tags: self.tags,
                db_cluster_identifier: self.db_cluster_identifier,
                promotion_tier: self.promotion_tier,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDbInstanceInputOperationOutputAlias = crate::operation::CreateDBInstance;
#[doc(hidden)]
pub type CreateDbInstanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDbInstanceInput {
    /// Consumes the builder and constructs an Operation<[`CreateDBInstance`](crate::operation::CreateDBInstance)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDBInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDbInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDbInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDbInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_db_instance(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDBInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDBInstance",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDbInstanceInput`](crate::input::CreateDbInstanceInput)
    pub fn builder() -> crate::input::create_db_instance_input::Builder {
        crate::input::create_db_instance_input::Builder::default()
    }
}

/// See [`CreateDbSubnetGroupInput`](crate::input::CreateDbSubnetGroupInput)
pub mod create_db_subnet_group_input {
    /// A builder for [`CreateDbSubnetGroupInput`](crate::input::CreateDbSubnetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) db_subnet_group_description: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name for the subnet group. This value is stored as a lowercase string.</p>
        /// <p>Constraints: Must contain no more than 255 letters, numbers, periods, underscores,
        /// spaces, or hyphens. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name for the subnet group. This value is stored as a lowercase string.</p>
        /// <p>Constraints: Must contain no more than 255 letters, numbers, periods, underscores,
        /// spaces, or hyphens. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_name = input;
            self
        }
        /// <p>The description for the subnet group.</p>
        pub fn db_subnet_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_subnet_group_description = Some(input.into());
            self
        }
        /// <p>The description for the subnet group.</p>
        pub fn set_db_subnet_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_description = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The Amazon EC2 subnet IDs for the subnet group.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>The Amazon EC2 subnet IDs for the subnet group.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the subnet group.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be assigned to the subnet group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbSubnetGroupInput`](crate::input::CreateDbSubnetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDbSubnetGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDbSubnetGroupInput {
                db_subnet_group_name: self.db_subnet_group_name,
                db_subnet_group_description: self.db_subnet_group_description,
                subnet_ids: self.subnet_ids,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDbSubnetGroupInputOperationOutputAlias = crate::operation::CreateDBSubnetGroup;
#[doc(hidden)]
pub type CreateDbSubnetGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDbSubnetGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateDBSubnetGroup`](crate::operation::CreateDBSubnetGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDBSubnetGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDbSubnetGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDbSubnetGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDbSubnetGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_db_subnet_group(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDBSubnetGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDBSubnetGroup",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDbSubnetGroupInput`](crate::input::CreateDbSubnetGroupInput)
    pub fn builder() -> crate::input::create_db_subnet_group_input::Builder {
        crate::input::create_db_subnet_group_input::Builder::default()
    }
}

/// See [`CreateEventSubscriptionInput`](crate::input::CreateEventSubscriptionInput)
pub mod create_event_subscription_input {
    /// A builder for [`CreateEventSubscriptionInput`](crate::input::CreateEventSubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_name: std::option::Option<std::string::String>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<std::string::String>,
        pub(crate) event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) source_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the subscription.</p>
        /// <p>Constraints: The name must be fewer than 255 characters.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_name = Some(input.into());
            self
        }
        /// <p>The name of the subscription.</p>
        /// <p>Constraints: The name must be fewer than 255 characters.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. Amazon SNS creates the ARN when you create a topic and subscribe to it.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. Amazon SNS creates the ARN when you create a topic and subscribe to it.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// <p>The type of source that is generating the events. For example, if you want to be notified of events generated by an instance, you would set this parameter to <code>db-instance</code>. If this value is not specified, all events are returned.</p>
        /// <p>Valid values: <code>db-instance</code>, <code>db-cluster</code>,
        /// <code>db-parameter-group</code>, <code>db-security-group</code>,
        /// <code>db-cluster-snapshot</code>
        /// </p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_type = Some(input.into());
            self
        }
        /// <p>The type of source that is generating the events. For example, if you want to be notified of events generated by an instance, you would set this parameter to <code>db-instance</code>. If this value is not specified, all events are returned.</p>
        /// <p>Valid values: <code>db-instance</code>, <code>db-cluster</code>,
        /// <code>db-parameter-group</code>, <code>db-security-group</code>,
        /// <code>db-cluster-snapshot</code>
        /// </p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_type = input;
            self
        }
        /// Appends an item to `event_categories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p> A list of event categories for a <code>SourceType</code> that you want to subscribe to. </p>
        pub fn event_categories(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_categories.unwrap_or_default();
            v.push(input.into());
            self.event_categories = Some(v);
            self
        }
        /// <p> A list of event categories for a <code>SourceType</code> that you want to subscribe to. </p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_categories = input;
            self
        }
        /// Appends an item to `source_ids`.
        ///
        /// To override the contents of this collection use [`set_source_ids`](Self::set_source_ids).
        ///
        /// <p>The list of identifiers of the event sources for which events are returned. If not specified, then all sources are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a
        /// hyphen or contain two consecutive hyphens.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>SourceIds</code> are provided, <code>SourceType</code> must also be
        /// provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is an instance, a <code>DBInstanceIdentifier</code> must
        /// be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a security group, a <code>DBSecurityGroupName</code>
        /// must be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a parameter group, a
        /// <code>DBParameterGroupName</code> must be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a snapshot, a <code>DBSnapshotIdentifier</code> must
        /// be provided.</p>
        /// </li>
        /// </ul>
        pub fn source_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.source_ids.unwrap_or_default();
            v.push(input.into());
            self.source_ids = Some(v);
            self
        }
        /// <p>The list of identifiers of the event sources for which events are returned. If not specified, then all sources are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a
        /// hyphen or contain two consecutive hyphens.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>SourceIds</code> are provided, <code>SourceType</code> must also be
        /// provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is an instance, a <code>DBInstanceIdentifier</code> must
        /// be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a security group, a <code>DBSecurityGroupName</code>
        /// must be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a parameter group, a
        /// <code>DBParameterGroupName</code> must be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a snapshot, a <code>DBSnapshotIdentifier</code> must
        /// be provided.</p>
        /// </li>
        /// </ul>
        pub fn set_source_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.source_ids = input;
            self
        }
        /// <p> A Boolean value; set to <code>true</code> to activate the subscription, set to <code>false</code> to create the subscription but not active it. </p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p> A Boolean value; set to <code>true</code> to activate the subscription, set to <code>false</code> to create the subscription but not active it. </p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the event subscription.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be assigned to the event subscription.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEventSubscriptionInput`](crate::input::CreateEventSubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEventSubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEventSubscriptionInput {
                subscription_name: self.subscription_name,
                sns_topic_arn: self.sns_topic_arn,
                source_type: self.source_type,
                event_categories: self.event_categories,
                source_ids: self.source_ids,
                enabled: self.enabled,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEventSubscriptionInputOperationOutputAlias =
    crate::operation::CreateEventSubscription;
#[doc(hidden)]
pub type CreateEventSubscriptionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateEventSubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`CreateEventSubscription`](crate::operation::CreateEventSubscription)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEventSubscription,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateEventSubscriptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateEventSubscriptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateEventSubscriptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_event_subscription(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEventSubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEventSubscription",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateEventSubscriptionInput`](crate::input::CreateEventSubscriptionInput)
    pub fn builder() -> crate::input::create_event_subscription_input::Builder {
        crate::input::create_event_subscription_input::Builder::default()
    }
}

/// See [`CreateGlobalClusterInput`](crate::input::CreateGlobalClusterInput)
pub mod create_global_cluster_input {
    /// A builder for [`CreateGlobalClusterInput`](crate::input::CreateGlobalClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) source_db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) deletion_protection: std::option::Option<bool>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) storage_encrypted: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The cluster identifier of the new global cluster.</p>
        pub fn global_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier of the new global cluster.</p>
        pub fn set_global_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_cluster_identifier = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) to use as the primary cluster of the global cluster. This parameter is optional.</p>
        pub fn source_db_cluster_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.source_db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) to use as the primary cluster of the global cluster. This parameter is optional.</p>
        pub fn set_source_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_db_cluster_identifier = input;
            self
        }
        /// <p>The name of the database engine to be used for this cluster.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The name of the database engine to be used for this cluster.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The engine version of the global cluster.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The engine version of the global cluster.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The deletion protection setting for the new global cluster. The global cluster can't be deleted when deletion protection is enabled. </p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.deletion_protection = Some(input);
            self
        }
        /// <p>The deletion protection setting for the new global cluster. The global cluster can't be deleted when deletion protection is enabled. </p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection = input;
            self
        }
        /// <p>The name for your database of up to 64 alpha-numeric characters. If you do not provide a name, Amazon DocumentDB will not create a database in the global cluster you are creating.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name for your database of up to 64 alpha-numeric characters. If you do not provide a name, Amazon DocumentDB will not create a database in the global cluster you are creating.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>The storage encryption setting for the new global cluster. </p>
        pub fn storage_encrypted(mut self, input: bool) -> Self {
            self.storage_encrypted = Some(input);
            self
        }
        /// <p>The storage encryption setting for the new global cluster. </p>
        pub fn set_storage_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.storage_encrypted = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGlobalClusterInput`](crate::input::CreateGlobalClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateGlobalClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateGlobalClusterInput {
                global_cluster_identifier: self.global_cluster_identifier,
                source_db_cluster_identifier: self.source_db_cluster_identifier,
                engine: self.engine,
                engine_version: self.engine_version,
                deletion_protection: self.deletion_protection,
                database_name: self.database_name,
                storage_encrypted: self.storage_encrypted,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateGlobalClusterInputOperationOutputAlias = crate::operation::CreateGlobalCluster;
#[doc(hidden)]
pub type CreateGlobalClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateGlobalClusterInput {
    /// Consumes the builder and constructs an Operation<[`CreateGlobalCluster`](crate::operation::CreateGlobalCluster)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateGlobalCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateGlobalClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateGlobalClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateGlobalClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_global_cluster(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateGlobalCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateGlobalCluster",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateGlobalClusterInput`](crate::input::CreateGlobalClusterInput)
    pub fn builder() -> crate::input::create_global_cluster_input::Builder {
        crate::input::create_global_cluster_input::Builder::default()
    }
}

/// See [`DeleteDbClusterInput`](crate::input::DeleteDbClusterInput)
pub mod delete_db_cluster_input {
    /// A builder for [`DeleteDbClusterInput`](crate::input::DeleteDbClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) skip_final_snapshot: std::option::Option<bool>,
        pub(crate) final_db_snapshot_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The cluster identifier for the cluster to be deleted. This parameter isn't case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match an existing <code>DBClusterIdentifier</code>.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier for the cluster to be deleted. This parameter isn't case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match an existing <code>DBClusterIdentifier</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p> Determines whether a final cluster snapshot is created before the cluster is deleted. If <code>true</code> is specified, no cluster snapshot is created. If <code>false</code> is specified, a cluster snapshot is created before the DB cluster is deleted. </p>
        /// <note>
        /// <p>If <code>SkipFinalSnapshot</code> is <code>false</code>, you must specify a <code>FinalDBSnapshotIdentifier</code> parameter.</p>
        /// </note>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn skip_final_snapshot(mut self, input: bool) -> Self {
            self.skip_final_snapshot = Some(input);
            self
        }
        /// <p> Determines whether a final cluster snapshot is created before the cluster is deleted. If <code>true</code> is specified, no cluster snapshot is created. If <code>false</code> is specified, a cluster snapshot is created before the DB cluster is deleted. </p>
        /// <note>
        /// <p>If <code>SkipFinalSnapshot</code> is <code>false</code>, you must specify a <code>FinalDBSnapshotIdentifier</code> parameter.</p>
        /// </note>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_skip_final_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.skip_final_snapshot = input;
            self
        }
        /// <p> The cluster snapshot identifier of the new cluster snapshot created when <code>SkipFinalSnapshot</code> is set to <code>false</code>. </p>
        /// <note>
        /// <p> Specifying this parameter and also setting the <code>SkipFinalShapshot</code> parameter to <code>true</code> results in an error. </p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be from 1 to 255 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn final_db_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.final_db_snapshot_identifier = Some(input.into());
            self
        }
        /// <p> The cluster snapshot identifier of the new cluster snapshot created when <code>SkipFinalSnapshot</code> is set to <code>false</code>. </p>
        /// <note>
        /// <p> Specifying this parameter and also setting the <code>SkipFinalShapshot</code> parameter to <code>true</code> results in an error. </p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be from 1 to 255 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn set_final_db_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.final_db_snapshot_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbClusterInput`](crate::input::DeleteDbClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDbClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDbClusterInput {
                db_cluster_identifier: self.db_cluster_identifier,
                skip_final_snapshot: self.skip_final_snapshot.unwrap_or_default(),
                final_db_snapshot_identifier: self.final_db_snapshot_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDbClusterInputOperationOutputAlias = crate::operation::DeleteDBCluster;
#[doc(hidden)]
pub type DeleteDbClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDbClusterInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDBCluster`](crate::operation::DeleteDBCluster)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDBCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDbClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDbClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDbClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_db_cluster(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDBCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDBCluster",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDbClusterInput`](crate::input::DeleteDbClusterInput)
    pub fn builder() -> crate::input::delete_db_cluster_input::Builder {
        crate::input::delete_db_cluster_input::Builder::default()
    }
}

/// See [`DeleteDbClusterParameterGroupInput`](crate::input::DeleteDbClusterParameterGroupInput)
pub mod delete_db_cluster_parameter_group_input {
    /// A builder for [`DeleteDbClusterParameterGroupInput`](crate::input::DeleteDbClusterParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_parameter_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be the name of an existing cluster parameter group.</p>
        /// </li>
        /// <li>
        /// <p>You can't delete a default cluster parameter group.</p>
        /// </li>
        /// <li>
        /// <p>Cannot be associated with any clusters.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be the name of an existing cluster parameter group.</p>
        /// </li>
        /// <li>
        /// <p>You can't delete a default cluster parameter group.</p>
        /// </li>
        /// <li>
        /// <p>Cannot be associated with any clusters.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbClusterParameterGroupInput`](crate::input::DeleteDbClusterParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDbClusterParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDbClusterParameterGroupInput {
                db_cluster_parameter_group_name: self.db_cluster_parameter_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDbClusterParameterGroupInputOperationOutputAlias =
    crate::operation::DeleteDBClusterParameterGroup;
#[doc(hidden)]
pub type DeleteDbClusterParameterGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDbClusterParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDBClusterParameterGroup`](crate::operation::DeleteDBClusterParameterGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDBClusterParameterGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDbClusterParameterGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDbClusterParameterGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDbClusterParameterGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_db_cluster_parameter_group(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDBClusterParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDBClusterParameterGroup",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDbClusterParameterGroupInput`](crate::input::DeleteDbClusterParameterGroupInput)
    pub fn builder() -> crate::input::delete_db_cluster_parameter_group_input::Builder {
        crate::input::delete_db_cluster_parameter_group_input::Builder::default()
    }
}

/// See [`DeleteDbClusterSnapshotInput`](crate::input::DeleteDbClusterSnapshotInput)
pub mod delete_db_cluster_snapshot_input {
    /// A builder for [`DeleteDbClusterSnapshotInput`](crate::input::DeleteDbClusterSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the cluster snapshot to delete.</p>
        /// <p>Constraints: Must be the name of an existing cluster snapshot in the <code>available</code> state.</p>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster snapshot to delete.</p>
        /// <p>Constraints: Must be the name of an existing cluster snapshot in the <code>available</code> state.</p>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbClusterSnapshotInput`](crate::input::DeleteDbClusterSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDbClusterSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDbClusterSnapshotInput {
                db_cluster_snapshot_identifier: self.db_cluster_snapshot_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDbClusterSnapshotInputOperationOutputAlias =
    crate::operation::DeleteDBClusterSnapshot;
#[doc(hidden)]
pub type DeleteDbClusterSnapshotInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDbClusterSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDBClusterSnapshot`](crate::operation::DeleteDBClusterSnapshot)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDBClusterSnapshot,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDbClusterSnapshotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDbClusterSnapshotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDbClusterSnapshotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_db_cluster_snapshot(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDBClusterSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDBClusterSnapshot",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDbClusterSnapshotInput`](crate::input::DeleteDbClusterSnapshotInput)
    pub fn builder() -> crate::input::delete_db_cluster_snapshot_input::Builder {
        crate::input::delete_db_cluster_snapshot_input::Builder::default()
    }
}

/// See [`DeleteDbInstanceInput`](crate::input::DeleteDbInstanceInput)
pub mod delete_db_instance_input {
    /// A builder for [`DeleteDbInstanceInput`](crate::input::DeleteDbInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The instance identifier for the instance to be deleted. This parameter isn't
        /// case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the name of an existing instance.</p>
        /// </li>
        /// </ul>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p>The instance identifier for the instance to be deleted. This parameter isn't
        /// case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the name of an existing instance.</p>
        /// </li>
        /// </ul>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbInstanceInput`](crate::input::DeleteDbInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDbInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDbInstanceInput {
                db_instance_identifier: self.db_instance_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDbInstanceInputOperationOutputAlias = crate::operation::DeleteDBInstance;
#[doc(hidden)]
pub type DeleteDbInstanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDbInstanceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDBInstance`](crate::operation::DeleteDBInstance)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDBInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDbInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDbInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDbInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_db_instance(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDBInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDBInstance",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDbInstanceInput`](crate::input::DeleteDbInstanceInput)
    pub fn builder() -> crate::input::delete_db_instance_input::Builder {
        crate::input::delete_db_instance_input::Builder::default()
    }
}

/// See [`DeleteDbSubnetGroupInput`](crate::input::DeleteDbSubnetGroupInput)
pub mod delete_db_subnet_group_input {
    /// A builder for [`DeleteDbSubnetGroupInput`](crate::input::DeleteDbSubnetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_subnet_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the database subnet group to delete.</p>
        /// <note>
        /// <p>You can't delete the default subnet group.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <p>Must match the name of an existing <code>DBSubnetGroup</code>. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the database subnet group to delete.</p>
        /// <note>
        /// <p>You can't delete the default subnet group.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <p>Must match the name of an existing <code>DBSubnetGroup</code>. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbSubnetGroupInput`](crate::input::DeleteDbSubnetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDbSubnetGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDbSubnetGroupInput {
                db_subnet_group_name: self.db_subnet_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDbSubnetGroupInputOperationOutputAlias = crate::operation::DeleteDBSubnetGroup;
#[doc(hidden)]
pub type DeleteDbSubnetGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDbSubnetGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDBSubnetGroup`](crate::operation::DeleteDBSubnetGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDBSubnetGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDbSubnetGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDbSubnetGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDbSubnetGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_db_subnet_group(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDBSubnetGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDBSubnetGroup",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDbSubnetGroupInput`](crate::input::DeleteDbSubnetGroupInput)
    pub fn builder() -> crate::input::delete_db_subnet_group_input::Builder {
        crate::input::delete_db_subnet_group_input::Builder::default()
    }
}

/// See [`DeleteEventSubscriptionInput`](crate::input::DeleteEventSubscriptionInput)
pub mod delete_event_subscription_input {
    /// A builder for [`DeleteEventSubscriptionInput`](crate::input::DeleteEventSubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon DocumentDB event notification subscription that you want to delete.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon DocumentDB event notification subscription that you want to delete.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEventSubscriptionInput`](crate::input::DeleteEventSubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEventSubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEventSubscriptionInput {
                subscription_name: self.subscription_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEventSubscriptionInputOperationOutputAlias =
    crate::operation::DeleteEventSubscription;
#[doc(hidden)]
pub type DeleteEventSubscriptionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteEventSubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEventSubscription`](crate::operation::DeleteEventSubscription)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEventSubscription,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteEventSubscriptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteEventSubscriptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteEventSubscriptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_event_subscription(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEventSubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEventSubscription",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteEventSubscriptionInput`](crate::input::DeleteEventSubscriptionInput)
    pub fn builder() -> crate::input::delete_event_subscription_input::Builder {
        crate::input::delete_event_subscription_input::Builder::default()
    }
}

/// See [`DeleteGlobalClusterInput`](crate::input::DeleteGlobalClusterInput)
pub mod delete_global_cluster_input {
    /// A builder for [`DeleteGlobalClusterInput`](crate::input::DeleteGlobalClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_cluster_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The cluster identifier of the global cluster being deleted.</p>
        pub fn global_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier of the global cluster being deleted.</p>
        pub fn set_global_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_cluster_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGlobalClusterInput`](crate::input::DeleteGlobalClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteGlobalClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteGlobalClusterInput {
                global_cluster_identifier: self.global_cluster_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteGlobalClusterInputOperationOutputAlias = crate::operation::DeleteGlobalCluster;
#[doc(hidden)]
pub type DeleteGlobalClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteGlobalClusterInput {
    /// Consumes the builder and constructs an Operation<[`DeleteGlobalCluster`](crate::operation::DeleteGlobalCluster)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteGlobalCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteGlobalClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteGlobalClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteGlobalClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_global_cluster(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteGlobalCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteGlobalCluster",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteGlobalClusterInput`](crate::input::DeleteGlobalClusterInput)
    pub fn builder() -> crate::input::delete_global_cluster_input::Builder {
        crate::input::delete_global_cluster_input::Builder::default()
    }
}

/// See [`DescribeCertificatesInput`](crate::input::DescribeCertificatesInput)
pub mod describe_certificates_input {
    /// A builder for [`DescribeCertificatesInput`](crate::input::DescribeCertificatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_identifier: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user-supplied certificate identifier. If this parameter is specified, information for only the specified certificate is returned. If this parameter is omitted, a list of up to <code>MaxRecords</code> certificates is returned. This parameter is not case sensitive.</p>
        /// <p>Constraints</p>
        /// <ul>
        /// <li>
        /// <p>Must match an existing <code>CertificateIdentifier</code>.</p>
        /// </li>
        /// </ul>
        pub fn certificate_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_identifier = Some(input.into());
            self
        }
        /// <p>The user-supplied certificate identifier. If this parameter is specified, information for only the specified certificate is returned. If this parameter is omitted, a list of up to <code>MaxRecords</code> certificates is returned. This parameter is not case sensitive.</p>
        /// <p>Constraints</p>
        /// <ul>
        /// <li>
        /// <p>Must match an existing <code>CertificateIdentifier</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_identifier = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Minimum: 20</p>
        /// </li>
        /// <li>
        /// <p>Maximum: 100</p>
        /// </li>
        /// </ul>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Minimum: 20</p>
        /// </li>
        /// <li>
        /// <p>Maximum: 100</p>
        /// </li>
        /// </ul>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeCertificates</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeCertificates</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCertificatesInput`](crate::input::DescribeCertificatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCertificatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCertificatesInput {
                certificate_identifier: self.certificate_identifier,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCertificatesInputOperationOutputAlias = crate::operation::DescribeCertificates;
#[doc(hidden)]
pub type DescribeCertificatesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeCertificatesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCertificates`](crate::operation::DescribeCertificates)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCertificates,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCertificatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCertificatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCertificatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_certificates(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCertificates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCertificates",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCertificatesInput`](crate::input::DescribeCertificatesInput)
    pub fn builder() -> crate::input::describe_certificates_input::Builder {
        crate::input::describe_certificates_input::Builder::default()
    }
}

/// See [`DescribeDbClusterParameterGroupsInput`](crate::input::DescribeDbClusterParameterGroupsInput)
pub mod describe_db_cluster_parameter_groups_input {
    /// A builder for [`DescribeDbClusterParameterGroupsInput`](crate::input::DescribeDbClusterParameterGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a specific cluster parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If provided, must match the name of an existing
        /// <code>DBClusterParameterGroup</code>.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of a specific cluster parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If provided, must match the name of an existing
        /// <code>DBClusterParameterGroup</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbClusterParameterGroupsInput`](crate::input::DescribeDbClusterParameterGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbClusterParameterGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbClusterParameterGroupsInput {
                db_cluster_parameter_group_name: self.db_cluster_parameter_group_name,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbClusterParameterGroupsInputOperationOutputAlias =
    crate::operation::DescribeDBClusterParameterGroups;
#[doc(hidden)]
pub type DescribeDbClusterParameterGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDbClusterParameterGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBClusterParameterGroups`](crate::operation::DescribeDBClusterParameterGroups)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBClusterParameterGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDbClusterParameterGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDbClusterParameterGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDbClusterParameterGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_db_cluster_parameter_groups(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBClusterParameterGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBClusterParameterGroups",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterParameterGroupsInput`](crate::input::DescribeDbClusterParameterGroupsInput)
    pub fn builder() -> crate::input::describe_db_cluster_parameter_groups_input::Builder {
        crate::input::describe_db_cluster_parameter_groups_input::Builder::default()
    }
}

/// See [`DescribeDbClusterParametersInput`](crate::input::DescribeDbClusterParametersInput)
pub mod describe_db_cluster_parameters_input {
    /// A builder for [`DescribeDbClusterParametersInput`](crate::input::DescribeDbClusterParametersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a specific cluster parameter group to return parameter details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If provided, must match the name of an existing <code>DBClusterParameterGroup</code>.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of a specific cluster parameter group to return parameter details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If provided, must match the name of an existing <code>DBClusterParameterGroup</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = input;
            self
        }
        /// <p> A value that indicates to return only parameters for a specific source. Parameter sources can be <code>engine</code>, <code>service</code>, or <code>customer</code>.
        /// </p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p> A value that indicates to return only parameters for a specific source. Parameter sources can be <code>engine</code>, <code>service</code>, or <code>customer</code>.
        /// </p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbClusterParametersInput`](crate::input::DescribeDbClusterParametersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbClusterParametersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbClusterParametersInput {
                db_cluster_parameter_group_name: self.db_cluster_parameter_group_name,
                source: self.source,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbClusterParametersInputOperationOutputAlias =
    crate::operation::DescribeDBClusterParameters;
#[doc(hidden)]
pub type DescribeDbClusterParametersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDbClusterParametersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBClusterParameters`](crate::operation::DescribeDBClusterParameters)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBClusterParameters,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDbClusterParametersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDbClusterParametersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDbClusterParametersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_db_cluster_parameters(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBClusterParameters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBClusterParameters",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterParametersInput`](crate::input::DescribeDbClusterParametersInput)
    pub fn builder() -> crate::input::describe_db_cluster_parameters_input::Builder {
        crate::input::describe_db_cluster_parameters_input::Builder::default()
    }
}

/// See [`DescribeDbClustersInput`](crate::input::DescribeDbClustersInput)
pub mod describe_db_clusters_input {
    /// A builder for [`DescribeDbClustersInput`](crate::input::DescribeDbClustersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user-provided cluster identifier. If this parameter is specified, information from only the specific cluster is returned. This parameter isn't case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If provided, must match an existing <code>DBClusterIdentifier</code>.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The user-provided cluster identifier. If this parameter is specified, information from only the specific cluster is returned. This parameter isn't case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If provided, must match an existing <code>DBClusterIdentifier</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies one or more clusters to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-cluster-id</code> - Accepts cluster identifiers and cluster Amazon Resource Names (ARNs). The results list only includes information about the clusters identified by these ARNs.</p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>A filter that specifies one or more clusters to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-cluster-id</code> - Accepts cluster identifiers and cluster Amazon Resource Names (ARNs). The results list only includes information about the clusters identified by these ARNs.</p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbClustersInput`](crate::input::DescribeDbClustersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbClustersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbClustersInput {
                db_cluster_identifier: self.db_cluster_identifier,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbClustersInputOperationOutputAlias = crate::operation::DescribeDBClusters;
#[doc(hidden)]
pub type DescribeDbClustersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDbClustersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBClusters`](crate::operation::DescribeDBClusters)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBClusters,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDbClustersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDbClustersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDbClustersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_db_clusters(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBClusters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBClusters",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbClustersInput`](crate::input::DescribeDbClustersInput)
    pub fn builder() -> crate::input::describe_db_clusters_input::Builder {
        crate::input::describe_db_clusters_input::Builder::default()
    }
}

/// See [`DescribeDbClusterSnapshotAttributesInput`](crate::input::DescribeDbClusterSnapshotAttributesInput)
pub mod describe_db_cluster_snapshot_attributes_input {
    /// A builder for [`DescribeDbClusterSnapshotAttributesInput`](crate::input::DescribeDbClusterSnapshotAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the cluster snapshot to describe the attributes for.</p>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier for the cluster snapshot to describe the attributes for.</p>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbClusterSnapshotAttributesInput`](crate::input::DescribeDbClusterSnapshotAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbClusterSnapshotAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbClusterSnapshotAttributesInput {
                db_cluster_snapshot_identifier: self.db_cluster_snapshot_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbClusterSnapshotAttributesInputOperationOutputAlias =
    crate::operation::DescribeDBClusterSnapshotAttributes;
#[doc(hidden)]
pub type DescribeDbClusterSnapshotAttributesInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeDbClusterSnapshotAttributesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBClusterSnapshotAttributes`](crate::operation::DescribeDBClusterSnapshotAttributes)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBClusterSnapshotAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDbClusterSnapshotAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDbClusterSnapshotAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDbClusterSnapshotAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_db_cluster_snapshot_attributes(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBClusterSnapshotAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBClusterSnapshotAttributes",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterSnapshotAttributesInput`](crate::input::DescribeDbClusterSnapshotAttributesInput)
    pub fn builder() -> crate::input::describe_db_cluster_snapshot_attributes_input::Builder {
        crate::input::describe_db_cluster_snapshot_attributes_input::Builder::default()
    }
}

/// See [`DescribeDbClusterSnapshotsInput`](crate::input::DescribeDbClusterSnapshotsInput)
pub mod describe_db_cluster_snapshots_input {
    /// A builder for [`DescribeDbClusterSnapshotsInput`](crate::input::DescribeDbClusterSnapshotsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) snapshot_type: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) include_shared: std::option::Option<bool>,
        pub(crate) include_public: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the cluster to retrieve the list of cluster snapshots for. This parameter can't be used with the <code>DBClusterSnapshotIdentifier</code> parameter. This parameter is not case sensitive. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If provided, must match the identifier of an existing
        /// <code>DBCluster</code>.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the cluster to retrieve the list of cluster snapshots for. This parameter can't be used with the <code>DBClusterSnapshotIdentifier</code> parameter. This parameter is not case sensitive. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If provided, must match the identifier of an existing
        /// <code>DBCluster</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>A specific cluster snapshot identifier to describe. This parameter can't be used with the <code>DBClusterIdentifier</code> parameter. This value is stored as a lowercase string. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If provided, must match the identifier of an existing
        /// <code>DBClusterSnapshot</code>.</p>
        /// </li>
        /// <li>
        /// <p>If this identifier is for an automated snapshot, the <code>SnapshotType</code>
        /// parameter must also be specified.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>A specific cluster snapshot identifier to describe. This parameter can't be used with the <code>DBClusterIdentifier</code> parameter. This value is stored as a lowercase string. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If provided, must match the identifier of an existing
        /// <code>DBClusterSnapshot</code>.</p>
        /// </li>
        /// <li>
        /// <p>If this identifier is for an automated snapshot, the <code>SnapshotType</code>
        /// parameter must also be specified.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = input;
            self
        }
        /// <p>The type of cluster snapshots to be returned. You can specify one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>automated</code> - Return all cluster snapshots that Amazon DocumentDB has automatically created for your account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>manual</code> - Return all cluster snapshots that you have manually created for your account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>shared</code> - Return all manual cluster snapshots that have been shared to your account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>public</code> - Return all cluster snapshots that have been marked as public.</p>
        /// </li>
        /// </ul>
        /// <p>If you don't specify a <code>SnapshotType</code> value, then both automated and manual cluster snapshots are returned. You can include shared cluster snapshots with these results by setting the <code>IncludeShared</code> parameter to <code>true</code>. You can include public cluster snapshots with these results by setting the<code>IncludePublic</code> parameter to <code>true</code>.</p>
        /// <p>The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don't apply for <code>SnapshotType</code> values of <code>manual</code> or <code>automated</code>. The <code>IncludePublic</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>shared</code>. The <code>IncludeShared</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>public</code>.</p>
        pub fn snapshot_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_type = Some(input.into());
            self
        }
        /// <p>The type of cluster snapshots to be returned. You can specify one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>automated</code> - Return all cluster snapshots that Amazon DocumentDB has automatically created for your account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>manual</code> - Return all cluster snapshots that you have manually created for your account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>shared</code> - Return all manual cluster snapshots that have been shared to your account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>public</code> - Return all cluster snapshots that have been marked as public.</p>
        /// </li>
        /// </ul>
        /// <p>If you don't specify a <code>SnapshotType</code> value, then both automated and manual cluster snapshots are returned. You can include shared cluster snapshots with these results by setting the <code>IncludeShared</code> parameter to <code>true</code>. You can include public cluster snapshots with these results by setting the<code>IncludePublic</code> parameter to <code>true</code>.</p>
        /// <p>The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don't apply for <code>SnapshotType</code> values of <code>manual</code> or <code>automated</code>. The <code>IncludePublic</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>shared</code>. The <code>IncludeShared</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>public</code>.</p>
        pub fn set_snapshot_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_type = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Set to <code>true</code> to include shared manual cluster snapshots from other accounts that this account has been given permission to copy or restore, and otherwise <code>false</code>. The default is <code>false</code>.</p>
        pub fn include_shared(mut self, input: bool) -> Self {
            self.include_shared = Some(input);
            self
        }
        /// <p>Set to <code>true</code> to include shared manual cluster snapshots from other accounts that this account has been given permission to copy or restore, and otherwise <code>false</code>. The default is <code>false</code>.</p>
        pub fn set_include_shared(mut self, input: std::option::Option<bool>) -> Self {
            self.include_shared = input;
            self
        }
        /// <p>Set to <code>true</code> to include manual cluster snapshots that are public and can be copied or restored by any account, and otherwise <code>false</code>. The default is <code>false</code>.</p>
        pub fn include_public(mut self, input: bool) -> Self {
            self.include_public = Some(input);
            self
        }
        /// <p>Set to <code>true</code> to include manual cluster snapshots that are public and can be copied or restored by any account, and otherwise <code>false</code>. The default is <code>false</code>.</p>
        pub fn set_include_public(mut self, input: std::option::Option<bool>) -> Self {
            self.include_public = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbClusterSnapshotsInput`](crate::input::DescribeDbClusterSnapshotsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbClusterSnapshotsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbClusterSnapshotsInput {
                db_cluster_identifier: self.db_cluster_identifier,
                db_cluster_snapshot_identifier: self.db_cluster_snapshot_identifier,
                snapshot_type: self.snapshot_type,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
                include_shared: self.include_shared.unwrap_or_default(),
                include_public: self.include_public.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbClusterSnapshotsInputOperationOutputAlias =
    crate::operation::DescribeDBClusterSnapshots;
#[doc(hidden)]
pub type DescribeDbClusterSnapshotsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDbClusterSnapshotsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBClusterSnapshots`](crate::operation::DescribeDBClusterSnapshots)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBClusterSnapshots,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDbClusterSnapshotsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDbClusterSnapshotsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDbClusterSnapshotsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_db_cluster_snapshots(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBClusterSnapshots::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBClusterSnapshots",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterSnapshotsInput`](crate::input::DescribeDbClusterSnapshotsInput)
    pub fn builder() -> crate::input::describe_db_cluster_snapshots_input::Builder {
        crate::input::describe_db_cluster_snapshots_input::Builder::default()
    }
}

/// See [`DescribeDbEngineVersionsInput`](crate::input::DescribeDbEngineVersionsInput)
pub mod describe_db_engine_versions_input {
    /// A builder for [`DescribeDbEngineVersionsInput`](crate::input::DescribeDbEngineVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) db_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) default_only: std::option::Option<bool>,
        pub(crate) list_supported_character_sets: std::option::Option<bool>,
        pub(crate) list_supported_timezones: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The database engine to return.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The database engine to return.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The database engine version to return.</p>
        /// <p>Example: <code>3.6.0</code>
        /// </p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The database engine version to return.</p>
        /// <p>Example: <code>3.6.0</code>
        /// </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The name of a specific parameter group family to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If provided, must match an existing
        /// <code>DBParameterGroupFamily</code>.</p>
        /// </li>
        /// </ul>
        pub fn db_parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_family = Some(input.into());
            self
        }
        /// <p>The name of a specific parameter group family to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If provided, must match an existing
        /// <code>DBParameterGroupFamily</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_family = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Indicates that only the default version of the specified engine or engine and major
        /// version combination is returned.</p>
        pub fn default_only(mut self, input: bool) -> Self {
            self.default_only = Some(input);
            self
        }
        /// <p>Indicates that only the default version of the specified engine or engine and major
        /// version combination is returned.</p>
        pub fn set_default_only(mut self, input: std::option::Option<bool>) -> Self {
            self.default_only = input;
            self
        }
        /// <p>If this parameter is specified and the requested engine supports the <code>CharacterSetName</code> parameter for <code>CreateDBInstance</code>, the response includes a list of supported character sets for each engine version. </p>
        pub fn list_supported_character_sets(mut self, input: bool) -> Self {
            self.list_supported_character_sets = Some(input);
            self
        }
        /// <p>If this parameter is specified and the requested engine supports the <code>CharacterSetName</code> parameter for <code>CreateDBInstance</code>, the response includes a list of supported character sets for each engine version. </p>
        pub fn set_list_supported_character_sets(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.list_supported_character_sets = input;
            self
        }
        /// <p>If this parameter is specified and the requested engine supports the <code>TimeZone</code> parameter for <code>CreateDBInstance</code>, the response includes a list of supported time zones for each engine version. </p>
        pub fn list_supported_timezones(mut self, input: bool) -> Self {
            self.list_supported_timezones = Some(input);
            self
        }
        /// <p>If this parameter is specified and the requested engine supports the <code>TimeZone</code> parameter for <code>CreateDBInstance</code>, the response includes a list of supported time zones for each engine version. </p>
        pub fn set_list_supported_timezones(mut self, input: std::option::Option<bool>) -> Self {
            self.list_supported_timezones = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbEngineVersionsInput`](crate::input::DescribeDbEngineVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbEngineVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbEngineVersionsInput {
                engine: self.engine,
                engine_version: self.engine_version,
                db_parameter_group_family: self.db_parameter_group_family,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
                default_only: self.default_only.unwrap_or_default(),
                list_supported_character_sets: self.list_supported_character_sets,
                list_supported_timezones: self.list_supported_timezones,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbEngineVersionsInputOperationOutputAlias =
    crate::operation::DescribeDBEngineVersions;
#[doc(hidden)]
pub type DescribeDbEngineVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDbEngineVersionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBEngineVersions`](crate::operation::DescribeDBEngineVersions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBEngineVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDbEngineVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDbEngineVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDbEngineVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_db_engine_versions(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBEngineVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBEngineVersions",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbEngineVersionsInput`](crate::input::DescribeDbEngineVersionsInput)
    pub fn builder() -> crate::input::describe_db_engine_versions_input::Builder {
        crate::input::describe_db_engine_versions_input::Builder::default()
    }
}

/// See [`DescribeDbInstancesInput`](crate::input::DescribeDbInstancesInput)
pub mod describe_db_instances_input {
    /// A builder for [`DescribeDbInstancesInput`](crate::input::DescribeDbInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user-provided instance identifier. If this parameter is specified, information from only the specific instance is returned. This parameter isn't case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If provided, must match the identifier of an existing
        /// <code>DBInstance</code>.</p>
        /// </li>
        /// </ul>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p>The user-provided instance identifier. If this parameter is specified, information from only the specific instance is returned. This parameter isn't case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If provided, must match the identifier of an existing
        /// <code>DBInstance</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies one or more instances to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-cluster-id</code> - Accepts cluster identifiers and cluster Amazon Resource Names (ARNs). The results list includes only the information about the instances that are associated with the clusters that are identified by these ARNs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db-instance-id</code> - Accepts instance identifiers and instance ARNs. The results list includes only the information about the instances that are identified by these ARNs.</p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>A filter that specifies one or more instances to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-cluster-id</code> - Accepts cluster identifiers and cluster Amazon Resource Names (ARNs). The results list includes only the information about the instances that are associated with the clusters that are identified by these ARNs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db-instance-id</code> - Accepts instance identifiers and instance ARNs. The results list includes only the information about the instances that are identified by these ARNs.</p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbInstancesInput`](crate::input::DescribeDbInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbInstancesInput {
                db_instance_identifier: self.db_instance_identifier,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbInstancesInputOperationOutputAlias = crate::operation::DescribeDBInstances;
#[doc(hidden)]
pub type DescribeDbInstancesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDbInstancesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBInstances`](crate::operation::DescribeDBInstances)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBInstances,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDbInstancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDbInstancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDbInstancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_db_instances(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBInstances",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbInstancesInput`](crate::input::DescribeDbInstancesInput)
    pub fn builder() -> crate::input::describe_db_instances_input::Builder {
        crate::input::describe_db_instances_input::Builder::default()
    }
}

/// See [`DescribeDbSubnetGroupsInput`](crate::input::DescribeDbSubnetGroupsInput)
pub mod describe_db_subnet_groups_input {
    /// A builder for [`DescribeDbSubnetGroupsInput`](crate::input::DescribeDbSubnetGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the subnet group to return details for.</p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the subnet group to return details for.</p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_name = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbSubnetGroupsInput`](crate::input::DescribeDbSubnetGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbSubnetGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbSubnetGroupsInput {
                db_subnet_group_name: self.db_subnet_group_name,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbSubnetGroupsInputOperationOutputAlias = crate::operation::DescribeDBSubnetGroups;
#[doc(hidden)]
pub type DescribeDbSubnetGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDbSubnetGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBSubnetGroups`](crate::operation::DescribeDBSubnetGroups)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBSubnetGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDbSubnetGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDbSubnetGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDbSubnetGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_db_subnet_groups(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBSubnetGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBSubnetGroups",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbSubnetGroupsInput`](crate::input::DescribeDbSubnetGroupsInput)
    pub fn builder() -> crate::input::describe_db_subnet_groups_input::Builder {
        crate::input::describe_db_subnet_groups_input::Builder::default()
    }
}

/// See [`DescribeEngineDefaultClusterParametersInput`](crate::input::DescribeEngineDefaultClusterParametersInput)
pub mod describe_engine_default_cluster_parameters_input {
    /// A builder for [`DescribeEngineDefaultClusterParametersInput`](crate::input::DescribeEngineDefaultClusterParametersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the cluster parameter group family to return the engine parameter
        /// information for.</p>
        pub fn db_parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_family = Some(input.into());
            self
        }
        /// <p>The name of the cluster parameter group family to return the engine parameter
        /// information for.</p>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_family = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEngineDefaultClusterParametersInput`](crate::input::DescribeEngineDefaultClusterParametersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEngineDefaultClusterParametersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEngineDefaultClusterParametersInput {
                db_parameter_group_family: self.db_parameter_group_family,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEngineDefaultClusterParametersInputOperationOutputAlias =
    crate::operation::DescribeEngineDefaultClusterParameters;
#[doc(hidden)]
pub type DescribeEngineDefaultClusterParametersInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeEngineDefaultClusterParametersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEngineDefaultClusterParameters`](crate::operation::DescribeEngineDefaultClusterParameters)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEngineDefaultClusterParameters,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEngineDefaultClusterParametersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEngineDefaultClusterParametersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEngineDefaultClusterParametersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_engine_default_cluster_parameters(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEngineDefaultClusterParameters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEngineDefaultClusterParameters",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEngineDefaultClusterParametersInput`](crate::input::DescribeEngineDefaultClusterParametersInput)
    pub fn builder() -> crate::input::describe_engine_default_cluster_parameters_input::Builder {
        crate::input::describe_engine_default_cluster_parameters_input::Builder::default()
    }
}

/// See [`DescribeEventCategoriesInput`](crate::input::DescribeEventCategoriesInput)
pub mod describe_event_categories_input {
    /// A builder for [`DescribeEventCategoriesInput`](crate::input::DescribeEventCategoriesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_type: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    }
    impl Builder {
        /// <p>The type of source that is generating the events.</p>
        /// <p>Valid values: <code>db-instance</code>, <code>db-parameter-group</code>, <code>db-security-group</code>
        /// </p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_type = Some(input.into());
            self
        }
        /// <p>The type of source that is generating the events.</p>
        /// <p>Valid values: <code>db-instance</code>, <code>db-parameter-group</code>, <code>db-security-group</code>
        /// </p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_type = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventCategoriesInput`](crate::input::DescribeEventCategoriesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEventCategoriesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEventCategoriesInput {
                source_type: self.source_type,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEventCategoriesInputOperationOutputAlias =
    crate::operation::DescribeEventCategories;
#[doc(hidden)]
pub type DescribeEventCategoriesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEventCategoriesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEventCategories`](crate::operation::DescribeEventCategories)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEventCategories,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEventCategoriesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEventCategoriesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEventCategoriesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_event_categories(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEventCategories::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEventCategories",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEventCategoriesInput`](crate::input::DescribeEventCategoriesInput)
    pub fn builder() -> crate::input::describe_event_categories_input::Builder {
        crate::input::describe_event_categories_input::Builder::default()
    }
}

/// See [`DescribeEventsInput`](crate::input::DescribeEventsInput)
pub mod describe_events_input {
    /// A builder for [`DescribeEventsInput`](crate::input::DescribeEventsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_identifier: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<crate::model::SourceType>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) duration: std::option::Option<i32>,
        pub(crate) event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the event source for which events are returned. If not specified, then all sources are included in the response.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>SourceIdentifier</code> is provided, <code>SourceType</code> must also be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is <code>DBInstance</code>, a
        /// <code>DBInstanceIdentifier</code> must be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is <code>DBSecurityGroup</code>, a
        /// <code>DBSecurityGroupName</code> must be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is <code>DBParameterGroup</code>, a
        /// <code>DBParameterGroupName</code> must be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is <code>DBSnapshot</code>, a
        /// <code>DBSnapshotIdentifier</code> must be provided.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn source_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the event source for which events are returned. If not specified, then all sources are included in the response.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>SourceIdentifier</code> is provided, <code>SourceType</code> must also be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is <code>DBInstance</code>, a
        /// <code>DBInstanceIdentifier</code> must be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is <code>DBSecurityGroup</code>, a
        /// <code>DBSecurityGroupName</code> must be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is <code>DBParameterGroup</code>, a
        /// <code>DBParameterGroupName</code> must be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is <code>DBSnapshot</code>, a
        /// <code>DBSnapshotIdentifier</code> must be provided.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_identifier = input;
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
        pub fn source_type(mut self, input: crate::model::SourceType) -> Self {
            self.source_type = Some(input);
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.source_type = input;
            self
        }
        /// <p> The beginning of the time interval to retrieve events for, specified in ISO 8601 format. </p>
        /// <p>Example: 2009-07-08T18:00Z</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p> The beginning of the time interval to retrieve events for, specified in ISO 8601 format. </p>
        /// <p>Example: 2009-07-08T18:00Z</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p> The end of the time interval for which to retrieve events, specified in ISO 8601
        /// format. </p>
        /// <p>Example: 2009-07-08T18:00Z</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p> The end of the time interval for which to retrieve events, specified in ISO 8601
        /// format. </p>
        /// <p>Example: 2009-07-08T18:00Z</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The number of minutes to retrieve events for.</p>
        /// <p>Default: 60</p>
        pub fn duration(mut self, input: i32) -> Self {
            self.duration = Some(input);
            self
        }
        /// <p>The number of minutes to retrieve events for.</p>
        /// <p>Default: 60</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.duration = input;
            self
        }
        /// Appends an item to `event_categories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p>A list of event categories that trigger notifications for an event notification
        /// subscription.</p>
        pub fn event_categories(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_categories.unwrap_or_default();
            v.push(input.into());
            self.event_categories = Some(v);
            self
        }
        /// <p>A list of event categories that trigger notifications for an event notification
        /// subscription.</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_categories = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventsInput`](crate::input::DescribeEventsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEventsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEventsInput {
                source_identifier: self.source_identifier,
                source_type: self.source_type,
                start_time: self.start_time,
                end_time: self.end_time,
                duration: self.duration,
                event_categories: self.event_categories,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEventsInputOperationOutputAlias = crate::operation::DescribeEvents;
#[doc(hidden)]
pub type DescribeEventsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEventsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEvents`](crate::operation::DescribeEvents)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEvents,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEventsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEventsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEventsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_events(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEvents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEvents",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEventsInput`](crate::input::DescribeEventsInput)
    pub fn builder() -> crate::input::describe_events_input::Builder {
        crate::input::describe_events_input::Builder::default()
    }
}

/// See [`DescribeEventSubscriptionsInput`](crate::input::DescribeEventSubscriptionsInput)
pub mod describe_event_subscriptions_input {
    /// A builder for [`DescribeEventSubscriptionsInput`](crate::input::DescribeEventSubscriptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_name: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon DocumentDB event notification subscription that you want to
        /// describe.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon DocumentDB event notification subscription that you want to
        /// describe.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_name = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventSubscriptionsInput`](crate::input::DescribeEventSubscriptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEventSubscriptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEventSubscriptionsInput {
                subscription_name: self.subscription_name,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEventSubscriptionsInputOperationOutputAlias =
    crate::operation::DescribeEventSubscriptions;
#[doc(hidden)]
pub type DescribeEventSubscriptionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEventSubscriptionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEventSubscriptions`](crate::operation::DescribeEventSubscriptions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEventSubscriptions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEventSubscriptionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEventSubscriptionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEventSubscriptionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_event_subscriptions(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEventSubscriptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEventSubscriptions",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEventSubscriptionsInput`](crate::input::DescribeEventSubscriptionsInput)
    pub fn builder() -> crate::input::describe_event_subscriptions_input::Builder {
        crate::input::describe_event_subscriptions_input::Builder::default()
    }
}

/// See [`DescribeGlobalClustersInput`](crate::input::DescribeGlobalClustersInput)
pub mod describe_global_clusters_input {
    /// A builder for [`DescribeGlobalClustersInput`](crate::input::DescribeGlobalClustersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user-supplied  cluster identifier. If this parameter is specified, information from only the specific cluster is returned. This parameter isn't case-sensitive.</p>
        pub fn global_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The user-supplied  cluster identifier. If this parameter is specified, information from only the specific cluster is returned. This parameter isn't case-sensitive.</p>
        pub fn set_global_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_cluster_identifier = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies one or more global DB clusters to describe.</p>
        /// <p>Supported filters: <code>db-cluster-id</code> accepts  cluster identifiers and  cluster Amazon Resource Names (ARNs). The results list will only include information about the clusters identified by these ARNs.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>A filter that specifies one or more global DB clusters to describe.</p>
        /// <p>Supported filters: <code>db-cluster-id</code> accepts  cluster identifiers and  cluster Amazon Resource Names (ARNs). The results list will only include information about the clusters identified by these ARNs.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results. </p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results. </p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeGlobalClusters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeGlobalClusters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGlobalClustersInput`](crate::input::DescribeGlobalClustersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeGlobalClustersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeGlobalClustersInput {
                global_cluster_identifier: self.global_cluster_identifier,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeGlobalClustersInputOperationOutputAlias = crate::operation::DescribeGlobalClusters;
#[doc(hidden)]
pub type DescribeGlobalClustersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeGlobalClustersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeGlobalClusters`](crate::operation::DescribeGlobalClusters)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeGlobalClusters,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeGlobalClustersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeGlobalClustersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeGlobalClustersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_global_clusters(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeGlobalClusters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeGlobalClusters",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeGlobalClustersInput`](crate::input::DescribeGlobalClustersInput)
    pub fn builder() -> crate::input::describe_global_clusters_input::Builder {
        crate::input::describe_global_clusters_input::Builder::default()
    }
}

/// See [`DescribeOrderableDbInstanceOptionsInput`](crate::input::DescribeOrderableDbInstanceOptionsInput)
pub mod describe_orderable_db_instance_options_input {
    /// A builder for [`DescribeOrderableDbInstanceOptionsInput`](crate::input::DescribeOrderableDbInstanceOptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) db_instance_class: std::option::Option<std::string::String>,
        pub(crate) license_model: std::option::Option<std::string::String>,
        pub(crate) vpc: std::option::Option<bool>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the engine to retrieve instance options for.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The name of the engine to retrieve instance options for.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The engine version filter value. Specify this parameter to show only the available
        /// offerings that match the specified engine version.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The engine version filter value. Specify this parameter to show only the available
        /// offerings that match the specified engine version.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The instance class filter value. Specify this parameter to show only the available
        /// offerings that match the specified instance class.</p>
        pub fn db_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_class = Some(input.into());
            self
        }
        /// <p>The instance class filter value. Specify this parameter to show only the available
        /// offerings that match the specified instance class.</p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_class = input;
            self
        }
        /// <p>The license model filter value. Specify this parameter to show only the available
        /// offerings that match the specified license model.</p>
        pub fn license_model(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_model = Some(input.into());
            self
        }
        /// <p>The license model filter value. Specify this parameter to show only the available
        /// offerings that match the specified license model.</p>
        pub fn set_license_model(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_model = input;
            self
        }
        /// <p>The virtual private cloud (VPC) filter value. Specify this parameter to show only the
        /// available VPC or non-VPC offerings.</p>
        pub fn vpc(mut self, input: bool) -> Self {
            self.vpc = Some(input);
            self
        }
        /// <p>The virtual private cloud (VPC) filter value. Specify this parameter to show only the
        /// available VPC or non-VPC offerings.</p>
        pub fn set_vpc(mut self, input: std::option::Option<bool>) -> Self {
            self.vpc = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOrderableDbInstanceOptionsInput`](crate::input::DescribeOrderableDbInstanceOptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeOrderableDbInstanceOptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeOrderableDbInstanceOptionsInput {
                engine: self.engine,
                engine_version: self.engine_version,
                db_instance_class: self.db_instance_class,
                license_model: self.license_model,
                vpc: self.vpc,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeOrderableDbInstanceOptionsInputOperationOutputAlias =
    crate::operation::DescribeOrderableDBInstanceOptions;
#[doc(hidden)]
pub type DescribeOrderableDbInstanceOptionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeOrderableDbInstanceOptionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeOrderableDBInstanceOptions`](crate::operation::DescribeOrderableDBInstanceOptions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeOrderableDBInstanceOptions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeOrderableDbInstanceOptionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeOrderableDbInstanceOptionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeOrderableDbInstanceOptionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_orderable_db_instance_options(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeOrderableDBInstanceOptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeOrderableDBInstanceOptions",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeOrderableDbInstanceOptionsInput`](crate::input::DescribeOrderableDbInstanceOptionsInput)
    pub fn builder() -> crate::input::describe_orderable_db_instance_options_input::Builder {
        crate::input::describe_orderable_db_instance_options_input::Builder::default()
    }
}

/// See [`DescribePendingMaintenanceActionsInput`](crate::input::DescribePendingMaintenanceActionsInput)
pub mod describe_pending_maintenance_actions_input {
    /// A builder for [`DescribePendingMaintenanceActionsInput`](crate::input::DescribePendingMaintenanceActionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_identifier: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ARN of a resource to return pending maintenance actions for.</p>
        pub fn resource_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_identifier = Some(input.into());
            self
        }
        /// <p>The ARN of a resource to return pending maintenance actions for.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_identifier = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies one or more resources to return pending maintenance actions
        /// for.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-cluster-id</code> - Accepts cluster identifiers and cluster
        /// Amazon Resource Names (ARNs). The results list includes only pending maintenance
        /// actions for the clusters identified by these ARNs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db-instance-id</code> - Accepts instance identifiers and instance
        /// ARNs. The results list includes only pending maintenance actions for the DB
        /// instances identified by these ARNs.</p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>A filter that specifies one or more resources to return pending maintenance actions
        /// for.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-cluster-id</code> - Accepts cluster identifiers and cluster
        /// Amazon Resource Names (ARNs). The results list includes only pending maintenance
        /// actions for the clusters identified by these ARNs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db-instance-id</code> - Accepts instance identifiers and instance
        /// ARNs. The results list includes only pending maintenance actions for the DB
        /// instances identified by these ARNs.</p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePendingMaintenanceActionsInput`](crate::input::DescribePendingMaintenanceActionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePendingMaintenanceActionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePendingMaintenanceActionsInput {
                resource_identifier: self.resource_identifier,
                filters: self.filters,
                marker: self.marker,
                max_records: self.max_records,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePendingMaintenanceActionsInputOperationOutputAlias =
    crate::operation::DescribePendingMaintenanceActions;
#[doc(hidden)]
pub type DescribePendingMaintenanceActionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribePendingMaintenanceActionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribePendingMaintenanceActions`](crate::operation::DescribePendingMaintenanceActions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePendingMaintenanceActions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribePendingMaintenanceActionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribePendingMaintenanceActionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribePendingMaintenanceActionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_pending_maintenance_actions(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePendingMaintenanceActions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePendingMaintenanceActions",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribePendingMaintenanceActionsInput`](crate::input::DescribePendingMaintenanceActionsInput)
    pub fn builder() -> crate::input::describe_pending_maintenance_actions_input::Builder {
        crate::input::describe_pending_maintenance_actions_input::Builder::default()
    }
}

/// See [`FailoverDbClusterInput`](crate::input::FailoverDbClusterInput)
pub mod failover_db_cluster_input {
    /// A builder for [`FailoverDbClusterInput`](crate::input::FailoverDbClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) target_db_instance_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A cluster identifier to force a failover for. This parameter is not case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing <code>DBCluster</code>.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>A cluster identifier to force a failover for. This parameter is not case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing <code>DBCluster</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>The name of the instance to promote to the primary instance.</p>
        /// <p>You must specify the instance identifier for an Amazon DocumentDB replica in the cluster. For
        /// example, <code>mydbcluster-replica1</code>.</p>
        pub fn target_db_instance_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.target_db_instance_identifier = Some(input.into());
            self
        }
        /// <p>The name of the instance to promote to the primary instance.</p>
        /// <p>You must specify the instance identifier for an Amazon DocumentDB replica in the cluster. For
        /// example, <code>mydbcluster-replica1</code>.</p>
        pub fn set_target_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_db_instance_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`FailoverDbClusterInput`](crate::input::FailoverDbClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::FailoverDbClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::FailoverDbClusterInput {
                db_cluster_identifier: self.db_cluster_identifier,
                target_db_instance_identifier: self.target_db_instance_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type FailoverDbClusterInputOperationOutputAlias = crate::operation::FailoverDBCluster;
#[doc(hidden)]
pub type FailoverDbClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl FailoverDbClusterInput {
    /// Consumes the builder and constructs an Operation<[`FailoverDBCluster`](crate::operation::FailoverDBCluster)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::FailoverDBCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::FailoverDbClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::FailoverDbClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::FailoverDbClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_failover_db_cluster(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::FailoverDBCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "FailoverDBCluster",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`FailoverDbClusterInput`](crate::input::FailoverDbClusterInput)
    pub fn builder() -> crate::input::failover_db_cluster_input::Builder {
        crate::input::failover_db_cluster_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_name: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    }
    impl Builder {
        /// <p>The Amazon DocumentDB resource with tags to be listed. This value is an Amazon Resource Name
        /// (ARN).</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The Amazon DocumentDB resource with tags to be listed. This value is an Amazon Resource Name
        /// (ARN).</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_name: self.resource_name,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ModifyDbClusterInput`](crate::input::ModifyDbClusterInput)
pub mod modify_db_cluster_input {
    /// A builder for [`ModifyDbClusterInput`](crate::input::ModifyDbClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) new_db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) apply_immediately: std::option::Option<bool>,
        pub(crate) backup_retention_period: std::option::Option<i32>,
        pub(crate) db_cluster_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) master_user_password: std::option::Option<std::string::String>,
        pub(crate) preferred_backup_window: std::option::Option<std::string::String>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) cloudwatch_logs_export_configuration:
            std::option::Option<crate::model::CloudwatchLogsExportConfiguration>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) deletion_protection: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The cluster identifier for the cluster that is being modified. This parameter is
        /// not case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing <code>DBCluster</code>.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier for the cluster that is being modified. This parameter is
        /// not case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing <code>DBCluster</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>The new cluster identifier for the cluster when renaming a cluster. This
        /// value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster2</code>
        /// </p>
        pub fn new_db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.new_db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The new cluster identifier for the cluster when renaming a cluster. This
        /// value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster2</code>
        /// </p>
        pub fn set_new_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.new_db_cluster_identifier = input;
            self
        }
        /// <p>A value that specifies whether the changes in this request and any pending changes are
        /// asynchronously applied as soon as possible, regardless of the
        /// <code>PreferredMaintenanceWindow</code> setting for the cluster. If this
        /// parameter is set to <code>false</code>, changes to the cluster are applied during the
        /// next maintenance window.</p>
        /// <p>The <code>ApplyImmediately</code> parameter affects only the
        /// <code>NewDBClusterIdentifier</code> and <code>MasterUserPassword</code> values. If
        /// you set this parameter value to <code>false</code>, the changes to the
        /// <code>NewDBClusterIdentifier</code> and <code>MasterUserPassword</code> values are
        /// applied during the next maintenance window. All other changes are applied immediately,
        /// regardless of the value of the <code>ApplyImmediately</code> parameter.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn apply_immediately(mut self, input: bool) -> Self {
            self.apply_immediately = Some(input);
            self
        }
        /// <p>A value that specifies whether the changes in this request and any pending changes are
        /// asynchronously applied as soon as possible, regardless of the
        /// <code>PreferredMaintenanceWindow</code> setting for the cluster. If this
        /// parameter is set to <code>false</code>, changes to the cluster are applied during the
        /// next maintenance window.</p>
        /// <p>The <code>ApplyImmediately</code> parameter affects only the
        /// <code>NewDBClusterIdentifier</code> and <code>MasterUserPassword</code> values. If
        /// you set this parameter value to <code>false</code>, the changes to the
        /// <code>NewDBClusterIdentifier</code> and <code>MasterUserPassword</code> values are
        /// applied during the next maintenance window. All other changes are applied immediately,
        /// regardless of the value of the <code>ApplyImmediately</code> parameter.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.apply_immediately = input;
            self
        }
        /// <p>The number of days for which automated backups are retained. You must specify a
        /// minimum value of 1.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be a value from 1 to 35.</p>
        /// </li>
        /// </ul>
        pub fn backup_retention_period(mut self, input: i32) -> Self {
            self.backup_retention_period = Some(input);
            self
        }
        /// <p>The number of days for which automated backups are retained. You must specify a
        /// minimum value of 1.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be a value from 1 to 35.</p>
        /// </li>
        /// </ul>
        pub fn set_backup_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.backup_retention_period = input;
            self
        }
        /// <p>The name of the cluster parameter group to use for the cluster.</p>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cluster parameter group to use for the cluster.</p>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = input;
            self
        }
        /// Appends an item to `vpc_security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of virtual private cloud (VPC) security groups that the cluster will belong
        /// to.</p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpc_security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.vpc_security_group_ids = Some(v);
            self
        }
        /// <p>A list of virtual private cloud (VPC) security groups that the cluster will belong
        /// to.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpc_security_group_ids = input;
            self
        }
        /// <p>The port number on which the cluster accepts connections.</p>
        /// <p>Constraints: Must be a value from <code>1150</code> to <code>65535</code>. </p>
        /// <p>Default: The same port as the original cluster.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number on which the cluster accepts connections.</p>
        /// <p>Constraints: Must be a value from <code>1150</code> to <code>65535</code>. </p>
        /// <p>Default: The same port as the original cluster.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The password for the master database user. This password can contain any printable
        /// ASCII character except forward slash (/), double quote ("), or the "at" symbol
        /// (@).</p>
        /// <p>Constraints: Must contain from 8 to 100 characters.</p>
        pub fn master_user_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_user_password = Some(input.into());
            self
        }
        /// <p>The password for the master database user. This password can contain any printable
        /// ASCII character except forward slash (/), double quote ("), or the "at" symbol
        /// (@).</p>
        /// <p>Constraints: Must contain from 8 to 100 characters.</p>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_user_password = input;
            self
        }
        /// <p>The daily time range during which automated backups are created if automated backups
        /// are enabled, using the <code>BackupRetentionPeriod</code> parameter. </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for
        /// each Region. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p>
        /// </li>
        /// <li>
        /// <p>Must be in Universal Coordinated Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Must not conflict with the preferred maintenance window.</p>
        /// </li>
        /// <li>
        /// <p>Must be at least 30 minutes.</p>
        /// </li>
        /// </ul>
        pub fn preferred_backup_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.preferred_backup_window = Some(input.into());
            self
        }
        /// <p>The daily time range during which automated backups are created if automated backups
        /// are enabled, using the <code>BackupRetentionPeriod</code> parameter. </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for
        /// each Region. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p>
        /// </li>
        /// <li>
        /// <p>Must be in Universal Coordinated Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Must not conflict with the preferred maintenance window.</p>
        /// </li>
        /// <li>
        /// <p>Must be at least 30 minutes.</p>
        /// </li>
        /// </ul>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_backup_window = input;
            self
        }
        /// <p>The weekly time range during which system maintenance can occur, in Universal
        /// Coordinated Time (UTC).</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for
        /// each Region, occurring on a random day of the week. </p>
        /// <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>The weekly time range during which system maintenance can occur, in Universal
        /// Coordinated Time (UTC).</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for
        /// each Region, occurring on a random day of the week. </p>
        /// <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p>The configuration setting for the log types to be enabled for export to Amazon
        /// CloudWatch Logs for a specific instance or cluster. The
        /// <code>EnableLogTypes</code> and <code>DisableLogTypes</code> arrays determine which
        /// logs are exported (or not exported) to CloudWatch Logs.</p>
        pub fn cloudwatch_logs_export_configuration(
            mut self,
            input: crate::model::CloudwatchLogsExportConfiguration,
        ) -> Self {
            self.cloudwatch_logs_export_configuration = Some(input);
            self
        }
        /// <p>The configuration setting for the log types to be enabled for export to Amazon
        /// CloudWatch Logs for a specific instance or cluster. The
        /// <code>EnableLogTypes</code> and <code>DisableLogTypes</code> arrays determine which
        /// logs are exported (or not exported) to CloudWatch Logs.</p>
        pub fn set_cloudwatch_logs_export_configuration(
            mut self,
            input: std::option::Option<crate::model::CloudwatchLogsExportConfiguration>,
        ) -> Self {
            self.cloudwatch_logs_export_configuration = input;
            self
        }
        /// <p>The version number of the database engine to which you want to upgrade. Modifying engine version is not supported on Amazon DocumentDB.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The version number of the database engine to which you want to upgrade. Modifying engine version is not supported on Amazon DocumentDB.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is
        /// enabled, the cluster cannot be deleted unless it is modified and
        /// <code>DeletionProtection</code> is disabled. <code>DeletionProtection</code>
        /// protects clusters from being accidentally deleted.</p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.deletion_protection = Some(input);
            self
        }
        /// <p>Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is
        /// enabled, the cluster cannot be deleted unless it is modified and
        /// <code>DeletionProtection</code> is disabled. <code>DeletionProtection</code>
        /// protects clusters from being accidentally deleted.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyDbClusterInput`](crate::input::ModifyDbClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyDbClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyDbClusterInput {
                db_cluster_identifier: self.db_cluster_identifier,
                new_db_cluster_identifier: self.new_db_cluster_identifier,
                apply_immediately: self.apply_immediately.unwrap_or_default(),
                backup_retention_period: self.backup_retention_period,
                db_cluster_parameter_group_name: self.db_cluster_parameter_group_name,
                vpc_security_group_ids: self.vpc_security_group_ids,
                port: self.port,
                master_user_password: self.master_user_password,
                preferred_backup_window: self.preferred_backup_window,
                preferred_maintenance_window: self.preferred_maintenance_window,
                cloudwatch_logs_export_configuration: self.cloudwatch_logs_export_configuration,
                engine_version: self.engine_version,
                deletion_protection: self.deletion_protection,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyDbClusterInputOperationOutputAlias = crate::operation::ModifyDBCluster;
#[doc(hidden)]
pub type ModifyDbClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyDbClusterInput {
    /// Consumes the builder and constructs an Operation<[`ModifyDBCluster`](crate::operation::ModifyDBCluster)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyDBCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyDbClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyDbClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyDbClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_db_cluster(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyDBCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyDBCluster",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyDbClusterInput`](crate::input::ModifyDbClusterInput)
    pub fn builder() -> crate::input::modify_db_cluster_input::Builder {
        crate::input::modify_db_cluster_input::Builder::default()
    }
}

/// See [`ModifyDbClusterParameterGroupInput`](crate::input::ModifyDbClusterParameterGroupInput)
pub mod modify_db_cluster_parameter_group_input {
    /// A builder for [`ModifyDbClusterParameterGroupInput`](crate::input::ModifyDbClusterParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
    }
    impl Builder {
        /// <p>The name of the cluster parameter group to modify.</p>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cluster parameter group to modify.</p>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of parameters in the cluster parameter group to modify.</p>
        pub fn parameters(mut self, input: impl Into<crate::model::Parameter>) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input.into());
            self.parameters = Some(v);
            self
        }
        /// <p>A list of parameters in the cluster parameter group to modify.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyDbClusterParameterGroupInput`](crate::input::ModifyDbClusterParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyDbClusterParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyDbClusterParameterGroupInput {
                db_cluster_parameter_group_name: self.db_cluster_parameter_group_name,
                parameters: self.parameters,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyDbClusterParameterGroupInputOperationOutputAlias =
    crate::operation::ModifyDBClusterParameterGroup;
#[doc(hidden)]
pub type ModifyDbClusterParameterGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyDbClusterParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`ModifyDBClusterParameterGroup`](crate::operation::ModifyDBClusterParameterGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyDBClusterParameterGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyDbClusterParameterGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyDbClusterParameterGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyDbClusterParameterGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_db_cluster_parameter_group(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyDBClusterParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyDBClusterParameterGroup",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyDbClusterParameterGroupInput`](crate::input::ModifyDbClusterParameterGroupInput)
    pub fn builder() -> crate::input::modify_db_cluster_parameter_group_input::Builder {
        crate::input::modify_db_cluster_parameter_group_input::Builder::default()
    }
}

/// See [`ModifyDbClusterSnapshotAttributeInput`](crate::input::ModifyDbClusterSnapshotAttributeInput)
pub mod modify_db_cluster_snapshot_attribute_input {
    /// A builder for [`ModifyDbClusterSnapshotAttributeInput`](crate::input::ModifyDbClusterSnapshotAttributeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) attribute_name: std::option::Option<std::string::String>,
        pub(crate) values_to_add: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) values_to_remove: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The identifier for the cluster snapshot to modify the attributes for.</p>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier for the cluster snapshot to modify the attributes for.</p>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = input;
            self
        }
        /// <p>The name of the cluster snapshot attribute to modify.</p>
        /// <p>To manage authorization for other accounts to copy or restore a manual cluster
        /// snapshot, set this value to <code>restore</code>.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p>The name of the cluster snapshot attribute to modify.</p>
        /// <p>To manage authorization for other accounts to copy or restore a manual cluster
        /// snapshot, set this value to <code>restore</code>.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// Appends an item to `values_to_add`.
        ///
        /// To override the contents of this collection use [`set_values_to_add`](Self::set_values_to_add).
        ///
        /// <p>A list of cluster snapshot attributes to add to the attribute specified by <code>AttributeName</code>.</p>
        /// <p>To authorize other accounts to copy or restore a manual cluster snapshot, set this list to include one or more account IDs. To make the manual cluster snapshot restorable by any account, set it to <code>all</code>. Do not add the <code>all</code> value for any manual cluster snapshots that contain private information that you don't want to be available to all accounts.</p>
        pub fn values_to_add(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values_to_add.unwrap_or_default();
            v.push(input.into());
            self.values_to_add = Some(v);
            self
        }
        /// <p>A list of cluster snapshot attributes to add to the attribute specified by <code>AttributeName</code>.</p>
        /// <p>To authorize other accounts to copy or restore a manual cluster snapshot, set this list to include one or more account IDs. To make the manual cluster snapshot restorable by any account, set it to <code>all</code>. Do not add the <code>all</code> value for any manual cluster snapshots that contain private information that you don't want to be available to all accounts.</p>
        pub fn set_values_to_add(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values_to_add = input;
            self
        }
        /// Appends an item to `values_to_remove`.
        ///
        /// To override the contents of this collection use [`set_values_to_remove`](Self::set_values_to_remove).
        ///
        /// <p>A list of cluster snapshot attributes to remove from the attribute specified by <code>AttributeName</code>.</p>
        /// <p>To remove authorization for other accounts to copy or restore a manual cluster snapshot, set this list to include one or more account identifiers. To remove authorization for any account to copy or restore the cluster snapshot, set it to <code>all</code> . If you specify <code>all</code>, an account whose account ID is explicitly added to the <code>restore</code> attribute can still copy or restore a manual cluster snapshot.</p>
        pub fn values_to_remove(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values_to_remove.unwrap_or_default();
            v.push(input.into());
            self.values_to_remove = Some(v);
            self
        }
        /// <p>A list of cluster snapshot attributes to remove from the attribute specified by <code>AttributeName</code>.</p>
        /// <p>To remove authorization for other accounts to copy or restore a manual cluster snapshot, set this list to include one or more account identifiers. To remove authorization for any account to copy or restore the cluster snapshot, set it to <code>all</code> . If you specify <code>all</code>, an account whose account ID is explicitly added to the <code>restore</code> attribute can still copy or restore a manual cluster snapshot.</p>
        pub fn set_values_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values_to_remove = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyDbClusterSnapshotAttributeInput`](crate::input::ModifyDbClusterSnapshotAttributeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyDbClusterSnapshotAttributeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyDbClusterSnapshotAttributeInput {
                db_cluster_snapshot_identifier: self.db_cluster_snapshot_identifier,
                attribute_name: self.attribute_name,
                values_to_add: self.values_to_add,
                values_to_remove: self.values_to_remove,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyDbClusterSnapshotAttributeInputOperationOutputAlias =
    crate::operation::ModifyDBClusterSnapshotAttribute;
#[doc(hidden)]
pub type ModifyDbClusterSnapshotAttributeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyDbClusterSnapshotAttributeInput {
    /// Consumes the builder and constructs an Operation<[`ModifyDBClusterSnapshotAttribute`](crate::operation::ModifyDBClusterSnapshotAttribute)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyDBClusterSnapshotAttribute,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyDbClusterSnapshotAttributeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyDbClusterSnapshotAttributeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyDbClusterSnapshotAttributeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_db_cluster_snapshot_attribute(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyDBClusterSnapshotAttribute::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyDBClusterSnapshotAttribute",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyDbClusterSnapshotAttributeInput`](crate::input::ModifyDbClusterSnapshotAttributeInput)
    pub fn builder() -> crate::input::modify_db_cluster_snapshot_attribute_input::Builder {
        crate::input::modify_db_cluster_snapshot_attribute_input::Builder::default()
    }
}

/// See [`ModifyDbInstanceInput`](crate::input::ModifyDbInstanceInput)
pub mod modify_db_instance_input {
    /// A builder for [`ModifyDbInstanceInput`](crate::input::ModifyDbInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) db_instance_class: std::option::Option<std::string::String>,
        pub(crate) apply_immediately: std::option::Option<bool>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) auto_minor_version_upgrade: std::option::Option<bool>,
        pub(crate) new_db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) ca_certificate_identifier: std::option::Option<std::string::String>,
        pub(crate) promotion_tier: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The instance identifier. This value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing <code>DBInstance</code>.</p>
        /// </li>
        /// </ul>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p>The instance identifier. This value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing <code>DBInstance</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// <p>The new compute and memory capacity of the instance; for example, <code>db.r5.large</code>. Not all instance classes are available in all Regions. </p>
        /// <p>If you modify the instance class, an outage occurs during the change. The change is
        /// applied during the next maintenance window, unless <code>ApplyImmediately</code> is
        /// specified as <code>true</code> for this request. </p>
        /// <p>Default: Uses existing setting.</p>
        pub fn db_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_class = Some(input.into());
            self
        }
        /// <p>The new compute and memory capacity of the instance; for example, <code>db.r5.large</code>. Not all instance classes are available in all Regions. </p>
        /// <p>If you modify the instance class, an outage occurs during the change. The change is
        /// applied during the next maintenance window, unless <code>ApplyImmediately</code> is
        /// specified as <code>true</code> for this request. </p>
        /// <p>Default: Uses existing setting.</p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_class = input;
            self
        }
        /// <p>Specifies whether the modifications in this request and any pending modifications are
        /// asynchronously applied as soon as possible, regardless of the
        /// <code>PreferredMaintenanceWindow</code> setting for the instance. </p>
        /// <p> If this parameter is set to <code>false</code>, changes to the instance are
        /// applied during the next maintenance window. Some parameter changes can cause an outage
        /// and are applied on the next reboot.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn apply_immediately(mut self, input: bool) -> Self {
            self.apply_immediately = Some(input);
            self
        }
        /// <p>Specifies whether the modifications in this request and any pending modifications are
        /// asynchronously applied as soon as possible, regardless of the
        /// <code>PreferredMaintenanceWindow</code> setting for the instance. </p>
        /// <p> If this parameter is set to <code>false</code>, changes to the instance are
        /// applied during the next maintenance window. Some parameter changes can cause an outage
        /// and are applied on the next reboot.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.apply_immediately = input;
            self
        }
        /// <p>The weekly time range (in UTC) during which system maintenance can occur, which might
        /// result in an outage. Changing this parameter doesn't result in an outage except in the
        /// following situation, and the change is asynchronously applied as soon as possible. If
        /// there are pending actions that cause a reboot, and the maintenance window is changed to
        /// include the current time, changing this parameter causes a reboot of the instance. If
        /// you are moving this window to the current time, there must be at least 30 minutes
        /// between the current time and end of the window to ensure that pending changes are
        /// applied.</p>
        /// <p>Default: Uses existing setting.</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p>
        /// <p>Constraints: Must be at least 30 minutes.</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>The weekly time range (in UTC) during which system maintenance can occur, which might
        /// result in an outage. Changing this parameter doesn't result in an outage except in the
        /// following situation, and the change is asynchronously applied as soon as possible. If
        /// there are pending actions that cause a reboot, and the maintenance window is changed to
        /// include the current time, changing this parameter causes a reboot of the instance. If
        /// you are moving this window to the current time, there must be at least 30 minutes
        /// between the current time and end of the window to ensure that pending changes are
        /// applied.</p>
        /// <p>Default: Uses existing setting.</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p>
        /// <p>Constraints: Must be at least 30 minutes.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p>This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.</p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.auto_minor_version_upgrade = Some(input);
            self
        }
        /// <p>This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.</p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_minor_version_upgrade = input;
            self
        }
        /// <p> The new instance identifier for the instance when renaming an instance. When you change the instance identifier, an instance reboot occurs immediately if you set <code>Apply Immediately</code> to <code>true</code>. It occurs during the next maintenance window if you set <code>Apply Immediately</code> to <code>false</code>. This value is stored as a lowercase string. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>mydbinstance</code>
        /// </p>
        pub fn new_db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.new_db_instance_identifier = Some(input.into());
            self
        }
        /// <p> The new instance identifier for the instance when renaming an instance. When you change the instance identifier, an instance reboot occurs immediately if you set <code>Apply Immediately</code> to <code>true</code>. It occurs during the next maintenance window if you set <code>Apply Immediately</code> to <code>false</code>. This value is stored as a lowercase string. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>mydbinstance</code>
        /// </p>
        pub fn set_new_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.new_db_instance_identifier = input;
            self
        }
        /// <p>Indicates the certificate that needs to be associated with the instance.</p>
        pub fn ca_certificate_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.ca_certificate_identifier = Some(input.into());
            self
        }
        /// <p>Indicates the certificate that needs to be associated with the instance.</p>
        pub fn set_ca_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ca_certificate_identifier = input;
            self
        }
        /// <p>A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary instance after a failure of the existing primary instance.</p>
        /// <p>Default: 1</p>
        /// <p>Valid values: 0-15</p>
        pub fn promotion_tier(mut self, input: i32) -> Self {
            self.promotion_tier = Some(input);
            self
        }
        /// <p>A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary instance after a failure of the existing primary instance.</p>
        /// <p>Default: 1</p>
        /// <p>Valid values: 0-15</p>
        pub fn set_promotion_tier(mut self, input: std::option::Option<i32>) -> Self {
            self.promotion_tier = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyDbInstanceInput`](crate::input::ModifyDbInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyDbInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyDbInstanceInput {
                db_instance_identifier: self.db_instance_identifier,
                db_instance_class: self.db_instance_class,
                apply_immediately: self.apply_immediately.unwrap_or_default(),
                preferred_maintenance_window: self.preferred_maintenance_window,
                auto_minor_version_upgrade: self.auto_minor_version_upgrade,
                new_db_instance_identifier: self.new_db_instance_identifier,
                ca_certificate_identifier: self.ca_certificate_identifier,
                promotion_tier: self.promotion_tier,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyDbInstanceInputOperationOutputAlias = crate::operation::ModifyDBInstance;
#[doc(hidden)]
pub type ModifyDbInstanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyDbInstanceInput {
    /// Consumes the builder and constructs an Operation<[`ModifyDBInstance`](crate::operation::ModifyDBInstance)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyDBInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyDbInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyDbInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyDbInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_db_instance(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyDBInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyDBInstance",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyDbInstanceInput`](crate::input::ModifyDbInstanceInput)
    pub fn builder() -> crate::input::modify_db_instance_input::Builder {
        crate::input::modify_db_instance_input::Builder::default()
    }
}

/// See [`ModifyDbSubnetGroupInput`](crate::input::ModifyDbSubnetGroupInput)
pub mod modify_db_subnet_group_input {
    /// A builder for [`ModifyDbSubnetGroupInput`](crate::input::ModifyDbSubnetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) db_subnet_group_description: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name for the subnet group. This value is stored as a lowercase string. You can't modify the default subnet group. </p>
        /// <p>Constraints: Must match the name of an existing <code>DBSubnetGroup</code>. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name for the subnet group. This value is stored as a lowercase string. You can't modify the default subnet group. </p>
        /// <p>Constraints: Must match the name of an existing <code>DBSubnetGroup</code>. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_name = input;
            self
        }
        /// <p>The description for the subnet group.</p>
        pub fn db_subnet_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_subnet_group_description = Some(input.into());
            self
        }
        /// <p>The description for the subnet group.</p>
        pub fn set_db_subnet_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_description = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The Amazon EC2 subnet IDs for the subnet group.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>The Amazon EC2 subnet IDs for the subnet group.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyDbSubnetGroupInput`](crate::input::ModifyDbSubnetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyDbSubnetGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyDbSubnetGroupInput {
                db_subnet_group_name: self.db_subnet_group_name,
                db_subnet_group_description: self.db_subnet_group_description,
                subnet_ids: self.subnet_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyDbSubnetGroupInputOperationOutputAlias = crate::operation::ModifyDBSubnetGroup;
#[doc(hidden)]
pub type ModifyDbSubnetGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyDbSubnetGroupInput {
    /// Consumes the builder and constructs an Operation<[`ModifyDBSubnetGroup`](crate::operation::ModifyDBSubnetGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyDBSubnetGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyDbSubnetGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyDbSubnetGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyDbSubnetGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_db_subnet_group(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyDBSubnetGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyDBSubnetGroup",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyDbSubnetGroupInput`](crate::input::ModifyDbSubnetGroupInput)
    pub fn builder() -> crate::input::modify_db_subnet_group_input::Builder {
        crate::input::modify_db_subnet_group_input::Builder::default()
    }
}

/// See [`ModifyEventSubscriptionInput`](crate::input::ModifyEventSubscriptionInput)
pub mod modify_event_subscription_input {
    /// A builder for [`ModifyEventSubscriptionInput`](crate::input::ModifyEventSubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_name: std::option::Option<std::string::String>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<std::string::String>,
        pub(crate) event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the Amazon DocumentDB event notification subscription.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon DocumentDB event notification subscription.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The
        /// ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The
        /// ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// <p>The type of source that is generating the events. For example, if you want to be notified of events generated by an instance, set this parameter to <code>db-instance</code>. If this value is not specified, all events are returned.</p>
        /// <p>Valid values: <code>db-instance</code>, <code>db-parameter-group</code>, <code>db-security-group</code>
        /// </p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_type = Some(input.into());
            self
        }
        /// <p>The type of source that is generating the events. For example, if you want to be notified of events generated by an instance, set this parameter to <code>db-instance</code>. If this value is not specified, all events are returned.</p>
        /// <p>Valid values: <code>db-instance</code>, <code>db-parameter-group</code>, <code>db-security-group</code>
        /// </p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_type = input;
            self
        }
        /// Appends an item to `event_categories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p> A list of event categories for a <code>SourceType</code> that you want to subscribe
        /// to.</p>
        pub fn event_categories(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_categories.unwrap_or_default();
            v.push(input.into());
            self.event_categories = Some(v);
            self
        }
        /// <p> A list of event categories for a <code>SourceType</code> that you want to subscribe
        /// to.</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_categories = input;
            self
        }
        /// <p> A Boolean value; set to <code>true</code> to activate the subscription. </p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p> A Boolean value; set to <code>true</code> to activate the subscription. </p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyEventSubscriptionInput`](crate::input::ModifyEventSubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyEventSubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyEventSubscriptionInput {
                subscription_name: self.subscription_name,
                sns_topic_arn: self.sns_topic_arn,
                source_type: self.source_type,
                event_categories: self.event_categories,
                enabled: self.enabled,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyEventSubscriptionInputOperationOutputAlias =
    crate::operation::ModifyEventSubscription;
#[doc(hidden)]
pub type ModifyEventSubscriptionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyEventSubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`ModifyEventSubscription`](crate::operation::ModifyEventSubscription)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyEventSubscription,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyEventSubscriptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyEventSubscriptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyEventSubscriptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_event_subscription(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyEventSubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyEventSubscription",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyEventSubscriptionInput`](crate::input::ModifyEventSubscriptionInput)
    pub fn builder() -> crate::input::modify_event_subscription_input::Builder {
        crate::input::modify_event_subscription_input::Builder::default()
    }
}

/// See [`ModifyGlobalClusterInput`](crate::input::ModifyGlobalClusterInput)
pub mod modify_global_cluster_input {
    /// A builder for [`ModifyGlobalClusterInput`](crate::input::ModifyGlobalClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) new_global_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) deletion_protection: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The identifier for the global cluster being modified. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing global cluster.</p>
        /// </li>
        /// </ul>
        pub fn global_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The identifier for the global cluster being modified. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing global cluster.</p>
        /// </li>
        /// </ul>
        pub fn set_global_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_cluster_identifier = input;
            self
        }
        /// <p>The new identifier for a global cluster when you modify a global cluster. This value is stored as a lowercase string.</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens</p>
        /// <p>The first character must be a letter</p>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster2</code>
        /// </p>
        pub fn new_global_cluster_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.new_global_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The new identifier for a global cluster when you modify a global cluster. This value is stored as a lowercase string.</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens</p>
        /// <p>The first character must be a letter</p>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster2</code>
        /// </p>
        pub fn set_new_global_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.new_global_cluster_identifier = input;
            self
        }
        /// <p>Indicates if the global cluster has deletion protection enabled. The global cluster can't be deleted when deletion protection is enabled. </p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.deletion_protection = Some(input);
            self
        }
        /// <p>Indicates if the global cluster has deletion protection enabled. The global cluster can't be deleted when deletion protection is enabled. </p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyGlobalClusterInput`](crate::input::ModifyGlobalClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyGlobalClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyGlobalClusterInput {
                global_cluster_identifier: self.global_cluster_identifier,
                new_global_cluster_identifier: self.new_global_cluster_identifier,
                deletion_protection: self.deletion_protection,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyGlobalClusterInputOperationOutputAlias = crate::operation::ModifyGlobalCluster;
#[doc(hidden)]
pub type ModifyGlobalClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyGlobalClusterInput {
    /// Consumes the builder and constructs an Operation<[`ModifyGlobalCluster`](crate::operation::ModifyGlobalCluster)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyGlobalCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyGlobalClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyGlobalClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyGlobalClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_global_cluster(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyGlobalCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyGlobalCluster",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyGlobalClusterInput`](crate::input::ModifyGlobalClusterInput)
    pub fn builder() -> crate::input::modify_global_cluster_input::Builder {
        crate::input::modify_global_cluster_input::Builder::default()
    }
}

/// See [`RebootDbInstanceInput`](crate::input::RebootDbInstanceInput)
pub mod reboot_db_instance_input {
    /// A builder for [`RebootDbInstanceInput`](crate::input::RebootDbInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) force_failover: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The instance identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing <code>DBInstance</code>.</p>
        /// </li>
        /// </ul>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p>The instance identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing <code>DBInstance</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// <p> When <code>true</code>, the reboot is conducted through a Multi-AZ failover. </p>
        /// <p>Constraint: You can't specify <code>true</code> if the instance is not configured for
        /// Multi-AZ.</p>
        pub fn force_failover(mut self, input: bool) -> Self {
            self.force_failover = Some(input);
            self
        }
        /// <p> When <code>true</code>, the reboot is conducted through a Multi-AZ failover. </p>
        /// <p>Constraint: You can't specify <code>true</code> if the instance is not configured for
        /// Multi-AZ.</p>
        pub fn set_force_failover(mut self, input: std::option::Option<bool>) -> Self {
            self.force_failover = input;
            self
        }
        /// Consumes the builder and constructs a [`RebootDbInstanceInput`](crate::input::RebootDbInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RebootDbInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RebootDbInstanceInput {
                db_instance_identifier: self.db_instance_identifier,
                force_failover: self.force_failover,
            })
        }
    }
}
#[doc(hidden)]
pub type RebootDbInstanceInputOperationOutputAlias = crate::operation::RebootDBInstance;
#[doc(hidden)]
pub type RebootDbInstanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RebootDbInstanceInput {
    /// Consumes the builder and constructs an Operation<[`RebootDBInstance`](crate::operation::RebootDBInstance)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RebootDBInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RebootDbInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RebootDbInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RebootDbInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_reboot_db_instance(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RebootDBInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RebootDBInstance",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RebootDbInstanceInput`](crate::input::RebootDbInstanceInput)
    pub fn builder() -> crate::input::reboot_db_instance_input::Builder {
        crate::input::reboot_db_instance_input::Builder::default()
    }
}

/// See [`RemoveFromGlobalClusterInput`](crate::input::RemoveFromGlobalClusterInput)
pub mod remove_from_global_cluster_input {
    /// A builder for [`RemoveFromGlobalClusterInput`](crate::input::RemoveFromGlobalClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The cluster identifier to detach from the Amazon DocumentDB global cluster. </p>
        pub fn global_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier to detach from the Amazon DocumentDB global cluster. </p>
        pub fn set_global_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_cluster_identifier = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) identifying the cluster that was detached from the Amazon DocumentDB global cluster. </p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) identifying the cluster that was detached from the Amazon DocumentDB global cluster. </p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveFromGlobalClusterInput`](crate::input::RemoveFromGlobalClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveFromGlobalClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveFromGlobalClusterInput {
                global_cluster_identifier: self.global_cluster_identifier,
                db_cluster_identifier: self.db_cluster_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveFromGlobalClusterInputOperationOutputAlias =
    crate::operation::RemoveFromGlobalCluster;
#[doc(hidden)]
pub type RemoveFromGlobalClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemoveFromGlobalClusterInput {
    /// Consumes the builder and constructs an Operation<[`RemoveFromGlobalCluster`](crate::operation::RemoveFromGlobalCluster)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveFromGlobalCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveFromGlobalClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveFromGlobalClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveFromGlobalClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_remove_from_global_cluster(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveFromGlobalCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveFromGlobalCluster",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveFromGlobalClusterInput`](crate::input::RemoveFromGlobalClusterInput)
    pub fn builder() -> crate::input::remove_from_global_cluster_input::Builder {
        crate::input::remove_from_global_cluster_input::Builder::default()
    }
}

/// See [`RemoveSourceIdentifierFromSubscriptionInput`](crate::input::RemoveSourceIdentifierFromSubscriptionInput)
pub mod remove_source_identifier_from_subscription_input {
    /// A builder for [`RemoveSourceIdentifierFromSubscriptionInput`](crate::input::RemoveSourceIdentifierFromSubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_name: std::option::Option<std::string::String>,
        pub(crate) source_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon DocumentDB event notification subscription that you want to remove a
        /// source identifier from.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon DocumentDB event notification subscription that you want to remove a
        /// source identifier from.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_name = input;
            self
        }
        /// <p> The source identifier to be removed from the subscription, such as the instance
        /// identifier for an instance, or the name of a security group. </p>
        pub fn source_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_identifier = Some(input.into());
            self
        }
        /// <p> The source identifier to be removed from the subscription, such as the instance
        /// identifier for an instance, or the name of a security group. </p>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveSourceIdentifierFromSubscriptionInput`](crate::input::RemoveSourceIdentifierFromSubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveSourceIdentifierFromSubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveSourceIdentifierFromSubscriptionInput {
                subscription_name: self.subscription_name,
                source_identifier: self.source_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveSourceIdentifierFromSubscriptionInputOperationOutputAlias =
    crate::operation::RemoveSourceIdentifierFromSubscription;
#[doc(hidden)]
pub type RemoveSourceIdentifierFromSubscriptionInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl RemoveSourceIdentifierFromSubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`RemoveSourceIdentifierFromSubscription`](crate::operation::RemoveSourceIdentifierFromSubscription)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveSourceIdentifierFromSubscription,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveSourceIdentifierFromSubscriptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveSourceIdentifierFromSubscriptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveSourceIdentifierFromSubscriptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_remove_source_identifier_from_subscription(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveSourceIdentifierFromSubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveSourceIdentifierFromSubscription",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveSourceIdentifierFromSubscriptionInput`](crate::input::RemoveSourceIdentifierFromSubscriptionInput)
    pub fn builder() -> crate::input::remove_source_identifier_from_subscription_input::Builder {
        crate::input::remove_source_identifier_from_subscription_input::Builder::default()
    }
}

/// See [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
pub mod remove_tags_from_resource_input {
    /// A builder for [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_name: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon DocumentDB resource that the tags are removed from. This value is an Amazon Resource
        /// Name (ARN).</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The Amazon DocumentDB resource that the tags are removed from. This value is an Amazon Resource
        /// Name (ARN).</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag key (name) of the tag to be removed.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The tag key (name) of the tag to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveTagsFromResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveTagsFromResourceInput {
                resource_name: self.resource_name,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveTagsFromResourceInputOperationOutputAlias = crate::operation::RemoveTagsFromResource;
#[doc(hidden)]
pub type RemoveTagsFromResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemoveTagsFromResourceInput {
    /// Consumes the builder and constructs an Operation<[`RemoveTagsFromResource`](crate::operation::RemoveTagsFromResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveTagsFromResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveTagsFromResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveTagsFromResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveTagsFromResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_remove_tags_from_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveTagsFromResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveTagsFromResource",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
    pub fn builder() -> crate::input::remove_tags_from_resource_input::Builder {
        crate::input::remove_tags_from_resource_input::Builder::default()
    }
}

/// See [`ResetDbClusterParameterGroupInput`](crate::input::ResetDbClusterParameterGroupInput)
pub mod reset_db_cluster_parameter_group_input {
    /// A builder for [`ResetDbClusterParameterGroupInput`](crate::input::ResetDbClusterParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) reset_all_parameters: std::option::Option<bool>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
    }
    impl Builder {
        /// <p>The name of the cluster parameter group to reset.</p>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cluster parameter group to reset.</p>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = input;
            self
        }
        /// <p>A value that is set to <code>true</code> to reset all parameters in the cluster
        /// parameter group to their default values, and <code>false</code> otherwise. You can't use
        /// this parameter if there is a list of parameter names specified for the
        /// <code>Parameters</code> parameter.</p>
        pub fn reset_all_parameters(mut self, input: bool) -> Self {
            self.reset_all_parameters = Some(input);
            self
        }
        /// <p>A value that is set to <code>true</code> to reset all parameters in the cluster
        /// parameter group to their default values, and <code>false</code> otherwise. You can't use
        /// this parameter if there is a list of parameter names specified for the
        /// <code>Parameters</code> parameter.</p>
        pub fn set_reset_all_parameters(mut self, input: std::option::Option<bool>) -> Self {
            self.reset_all_parameters = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of parameter names in the cluster parameter group to reset to the default
        /// values. You can't use this parameter if the <code>ResetAllParameters</code> parameter is
        /// set to <code>true</code>.</p>
        pub fn parameters(mut self, input: impl Into<crate::model::Parameter>) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input.into());
            self.parameters = Some(v);
            self
        }
        /// <p>A list of parameter names in the cluster parameter group to reset to the default
        /// values. You can't use this parameter if the <code>ResetAllParameters</code> parameter is
        /// set to <code>true</code>.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`ResetDbClusterParameterGroupInput`](crate::input::ResetDbClusterParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ResetDbClusterParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ResetDbClusterParameterGroupInput {
                db_cluster_parameter_group_name: self.db_cluster_parameter_group_name,
                reset_all_parameters: self.reset_all_parameters.unwrap_or_default(),
                parameters: self.parameters,
            })
        }
    }
}
#[doc(hidden)]
pub type ResetDbClusterParameterGroupInputOperationOutputAlias =
    crate::operation::ResetDBClusterParameterGroup;
#[doc(hidden)]
pub type ResetDbClusterParameterGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ResetDbClusterParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`ResetDBClusterParameterGroup`](crate::operation::ResetDBClusterParameterGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ResetDBClusterParameterGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ResetDbClusterParameterGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ResetDbClusterParameterGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ResetDbClusterParameterGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_reset_db_cluster_parameter_group(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ResetDBClusterParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ResetDBClusterParameterGroup",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ResetDbClusterParameterGroupInput`](crate::input::ResetDbClusterParameterGroupInput)
    pub fn builder() -> crate::input::reset_db_cluster_parameter_group_input::Builder {
        crate::input::reset_db_cluster_parameter_group_input::Builder::default()
    }
}

/// See [`RestoreDbClusterFromSnapshotInput`](crate::input::RestoreDbClusterFromSnapshotInput)
pub mod restore_db_cluster_from_snapshot_input {
    /// A builder for [`RestoreDbClusterFromSnapshotInput`](crate::input::RestoreDbClusterFromSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) db_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) enable_cloudwatch_logs_exports:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) deletion_protection: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>Provides the list of Amazon EC2 Availability Zones that instances in the restored DB
        /// cluster can be created in.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>Provides the list of Amazon EC2 Availability Zones that instances in the restored DB
        /// cluster can be created in.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// <p>The name of the cluster to create from the snapshot or cluster snapshot. This
        /// parameter isn't case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-snapshot-id</code>
        /// </p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The name of the cluster to create from the snapshot or cluster snapshot. This
        /// parameter isn't case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-snapshot-id</code>
        /// </p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>The identifier for the snapshot or cluster snapshot to restore from.</p>
        /// <p>You can use either the name or the Amazon Resource Name (ARN) to specify a cluster
        /// snapshot. However, you can use only the ARN to specify a snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing snapshot.</p>
        /// </li>
        /// </ul>
        pub fn snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier for the snapshot or cluster snapshot to restore from.</p>
        /// <p>You can use either the name or the Amazon Resource Name (ARN) to specify a cluster
        /// snapshot. However, you can use only the ARN to specify a snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing snapshot.</p>
        /// </li>
        /// </ul>
        pub fn set_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_identifier = input;
            self
        }
        /// <p>The database engine to use for the new cluster.</p>
        /// <p>Default: The same as source.</p>
        /// <p>Constraint: Must be compatible with the engine of the source.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The database engine to use for the new cluster.</p>
        /// <p>Default: The same as source.</p>
        /// <p>Constraint: Must be compatible with the engine of the source.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The version of the database engine to use for the new cluster.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The version of the database engine to use for the new cluster.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The port number on which the new cluster accepts connections.</p>
        /// <p>Constraints: Must be a value from <code>1150</code> to <code>65535</code>.</p>
        /// <p>Default: The same port as the original cluster.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number on which the new cluster accepts connections.</p>
        /// <p>Constraints: Must be a value from <code>1150</code> to <code>65535</code>.</p>
        /// <p>Default: The same port as the original cluster.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The name of the subnet group to use for the new cluster.</p>
        /// <p>Constraints: If provided, must match the name of an existing
        /// <code>DBSubnetGroup</code>.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the subnet group to use for the new cluster.</p>
        /// <p>Constraints: If provided, must match the name of an existing
        /// <code>DBSubnetGroup</code>.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_name = input;
            self
        }
        /// Appends an item to `vpc_security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of virtual private cloud (VPC) security groups that the new cluster will
        /// belong to.</p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpc_security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.vpc_security_group_ids = Some(v);
            self
        }
        /// <p>A list of virtual private cloud (VPC) security groups that the new cluster will
        /// belong to.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpc_security_group_ids = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the restored cluster.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be assigned to the restored cluster.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The KMS key identifier to use when restoring an encrypted cluster from a DB snapshot or cluster snapshot.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a cluster with the same account that owns the KMS encryption key used to encrypt the new cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.</p>
        /// <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the
        /// following occurs:</p>
        /// <ul>
        /// <li>
        /// <p>If the snapshot or cluster snapshot in <code>SnapshotIdentifier</code> is encrypted, then the restored cluster is encrypted using the KMS key that was used to encrypt the snapshot or the cluster snapshot.</p>
        /// </li>
        /// <li>
        /// <p>If the snapshot or the cluster snapshot in
        /// <code>SnapshotIdentifier</code> is not encrypted, then the restored DB
        /// cluster is not encrypted.</p>
        /// </li>
        /// </ul>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The KMS key identifier to use when restoring an encrypted cluster from a DB snapshot or cluster snapshot.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a cluster with the same account that owns the KMS encryption key used to encrypt the new cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.</p>
        /// <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the
        /// following occurs:</p>
        /// <ul>
        /// <li>
        /// <p>If the snapshot or cluster snapshot in <code>SnapshotIdentifier</code> is encrypted, then the restored cluster is encrypted using the KMS key that was used to encrypt the snapshot or the cluster snapshot.</p>
        /// </li>
        /// <li>
        /// <p>If the snapshot or the cluster snapshot in
        /// <code>SnapshotIdentifier</code> is not encrypted, then the restored DB
        /// cluster is not encrypted.</p>
        /// </li>
        /// </ul>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Appends an item to `enable_cloudwatch_logs_exports`.
        ///
        /// To override the contents of this collection use [`set_enable_cloudwatch_logs_exports`](Self::set_enable_cloudwatch_logs_exports).
        ///
        /// <p>A list of log types that must be enabled for exporting to Amazon CloudWatch Logs.</p>
        pub fn enable_cloudwatch_logs_exports(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.enable_cloudwatch_logs_exports.unwrap_or_default();
            v.push(input.into());
            self.enable_cloudwatch_logs_exports = Some(v);
            self
        }
        /// <p>A list of log types that must be enabled for exporting to Amazon CloudWatch Logs.</p>
        pub fn set_enable_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.enable_cloudwatch_logs_exports = input;
            self
        }
        /// <p>Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is enabled, the cluster cannot be deleted unless it is modified and <code>DeletionProtection</code> is disabled. <code>DeletionProtection</code> protects clusters from being accidentally deleted.</p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.deletion_protection = Some(input);
            self
        }
        /// <p>Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is enabled, the cluster cannot be deleted unless it is modified and <code>DeletionProtection</code> is disabled. <code>DeletionProtection</code> protects clusters from being accidentally deleted.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreDbClusterFromSnapshotInput`](crate::input::RestoreDbClusterFromSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RestoreDbClusterFromSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RestoreDbClusterFromSnapshotInput {
                availability_zones: self.availability_zones,
                db_cluster_identifier: self.db_cluster_identifier,
                snapshot_identifier: self.snapshot_identifier,
                engine: self.engine,
                engine_version: self.engine_version,
                port: self.port,
                db_subnet_group_name: self.db_subnet_group_name,
                vpc_security_group_ids: self.vpc_security_group_ids,
                tags: self.tags,
                kms_key_id: self.kms_key_id,
                enable_cloudwatch_logs_exports: self.enable_cloudwatch_logs_exports,
                deletion_protection: self.deletion_protection,
            })
        }
    }
}
#[doc(hidden)]
pub type RestoreDbClusterFromSnapshotInputOperationOutputAlias =
    crate::operation::RestoreDBClusterFromSnapshot;
#[doc(hidden)]
pub type RestoreDbClusterFromSnapshotInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RestoreDbClusterFromSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`RestoreDBClusterFromSnapshot`](crate::operation::RestoreDBClusterFromSnapshot)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RestoreDBClusterFromSnapshot,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RestoreDbClusterFromSnapshotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RestoreDbClusterFromSnapshotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RestoreDbClusterFromSnapshotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_restore_db_cluster_from_snapshot(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RestoreDBClusterFromSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RestoreDBClusterFromSnapshot",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RestoreDbClusterFromSnapshotInput`](crate::input::RestoreDbClusterFromSnapshotInput)
    pub fn builder() -> crate::input::restore_db_cluster_from_snapshot_input::Builder {
        crate::input::restore_db_cluster_from_snapshot_input::Builder::default()
    }
}

/// See [`RestoreDbClusterToPointInTimeInput`](crate::input::RestoreDbClusterToPointInTimeInput)
pub mod restore_db_cluster_to_point_in_time_input {
    /// A builder for [`RestoreDbClusterToPointInTimeInput`](crate::input::RestoreDbClusterToPointInTimeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) source_db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) restore_to_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) use_latest_restorable_time: std::option::Option<bool>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) db_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) enable_cloudwatch_logs_exports:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) deletion_protection: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the new cluster to be created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The name of the new cluster to be created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>The identifier of the source cluster from which to restore.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing <code>DBCluster</code>.</p>
        /// </li>
        /// </ul>
        pub fn source_db_cluster_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.source_db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the source cluster from which to restore.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing <code>DBCluster</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_source_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_db_cluster_identifier = input;
            self
        }
        /// <p>The date and time to restore the cluster to.</p>
        /// <p>Valid values: A time in Universal Coordinated Time (UTC) format.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be before the latest restorable time for the instance.</p>
        /// </li>
        /// <li>
        /// <p>Must be specified if the <code>UseLatestRestorableTime</code> parameter is not provided.</p>
        /// </li>
        /// <li>
        /// <p>Cannot be specified if the <code>UseLatestRestorableTime</code> parameter is <code>true</code>.</p>
        /// </li>
        /// <li>
        /// <p>Cannot be specified if the <code>RestoreType</code> parameter is <code>copy-on-write</code>.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>2015-03-07T23:45:00Z</code>
        /// </p>
        pub fn restore_to_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.restore_to_time = Some(input);
            self
        }
        /// <p>The date and time to restore the cluster to.</p>
        /// <p>Valid values: A time in Universal Coordinated Time (UTC) format.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be before the latest restorable time for the instance.</p>
        /// </li>
        /// <li>
        /// <p>Must be specified if the <code>UseLatestRestorableTime</code> parameter is not provided.</p>
        /// </li>
        /// <li>
        /// <p>Cannot be specified if the <code>UseLatestRestorableTime</code> parameter is <code>true</code>.</p>
        /// </li>
        /// <li>
        /// <p>Cannot be specified if the <code>RestoreType</code> parameter is <code>copy-on-write</code>.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>2015-03-07T23:45:00Z</code>
        /// </p>
        pub fn set_restore_to_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.restore_to_time = input;
            self
        }
        /// <p>A value that is set to <code>true</code> to restore the cluster to the latest
        /// restorable backup time, and <code>false</code> otherwise. </p>
        /// <p>Default: <code>false</code>
        /// </p>
        /// <p>Constraints: Cannot be specified if the <code>RestoreToTime</code> parameter is
        /// provided.</p>
        pub fn use_latest_restorable_time(mut self, input: bool) -> Self {
            self.use_latest_restorable_time = Some(input);
            self
        }
        /// <p>A value that is set to <code>true</code> to restore the cluster to the latest
        /// restorable backup time, and <code>false</code> otherwise. </p>
        /// <p>Default: <code>false</code>
        /// </p>
        /// <p>Constraints: Cannot be specified if the <code>RestoreToTime</code> parameter is
        /// provided.</p>
        pub fn set_use_latest_restorable_time(mut self, input: std::option::Option<bool>) -> Self {
            self.use_latest_restorable_time = input;
            self
        }
        /// <p>The port number on which the new cluster accepts connections.</p>
        /// <p>Constraints: Must be a value from <code>1150</code> to <code>65535</code>. </p>
        /// <p>Default: The default port for the engine.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number on which the new cluster accepts connections.</p>
        /// <p>Constraints: Must be a value from <code>1150</code> to <code>65535</code>. </p>
        /// <p>Default: The default port for the engine.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The subnet group name to use for the new cluster.</p>
        /// <p>Constraints: If provided, must match the name of an existing
        /// <code>DBSubnetGroup</code>.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The subnet group name to use for the new cluster.</p>
        /// <p>Constraints: If provided, must match the name of an existing
        /// <code>DBSubnetGroup</code>.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_name = input;
            self
        }
        /// Appends an item to `vpc_security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of VPC security groups that the new cluster belongs to.</p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpc_security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.vpc_security_group_ids = Some(v);
            self
        }
        /// <p>A list of VPC security groups that the new cluster belongs to.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpc_security_group_ids = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the restored cluster.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be assigned to the restored cluster.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The KMS key identifier to use when restoring an encrypted cluster from an encrypted cluster.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a cluster with the same account that owns the KMS encryption key used to encrypt the new cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.</p>
        /// <p>You can restore to a new cluster and encrypt the new cluster with an KMS key that is different from the KMS key used to encrypt the source cluster. The new DB cluster is encrypted with the KMS key identified by the <code>KmsKeyId</code> parameter.</p>
        /// <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following occurs:</p>
        /// <ul>
        /// <li>
        /// <p>If the cluster is encrypted, then the restored cluster is encrypted using the KMS key that was used to encrypt the source cluster.</p>
        /// </li>
        /// <li>
        /// <p>If the cluster is not encrypted, then the restored cluster is not encrypted.</p>
        /// </li>
        /// </ul>
        /// <p>If <code>DBClusterIdentifier</code> refers to a cluster that is not encrypted, then
        /// the restore request is rejected.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The KMS key identifier to use when restoring an encrypted cluster from an encrypted cluster.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a cluster with the same account that owns the KMS encryption key used to encrypt the new cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.</p>
        /// <p>You can restore to a new cluster and encrypt the new cluster with an KMS key that is different from the KMS key used to encrypt the source cluster. The new DB cluster is encrypted with the KMS key identified by the <code>KmsKeyId</code> parameter.</p>
        /// <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following occurs:</p>
        /// <ul>
        /// <li>
        /// <p>If the cluster is encrypted, then the restored cluster is encrypted using the KMS key that was used to encrypt the source cluster.</p>
        /// </li>
        /// <li>
        /// <p>If the cluster is not encrypted, then the restored cluster is not encrypted.</p>
        /// </li>
        /// </ul>
        /// <p>If <code>DBClusterIdentifier</code> refers to a cluster that is not encrypted, then
        /// the restore request is rejected.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Appends an item to `enable_cloudwatch_logs_exports`.
        ///
        /// To override the contents of this collection use [`set_enable_cloudwatch_logs_exports`](Self::set_enable_cloudwatch_logs_exports).
        ///
        /// <p>A list of log types that must be enabled for exporting to Amazon CloudWatch
        /// Logs.</p>
        pub fn enable_cloudwatch_logs_exports(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.enable_cloudwatch_logs_exports.unwrap_or_default();
            v.push(input.into());
            self.enable_cloudwatch_logs_exports = Some(v);
            self
        }
        /// <p>A list of log types that must be enabled for exporting to Amazon CloudWatch
        /// Logs.</p>
        pub fn set_enable_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.enable_cloudwatch_logs_exports = input;
            self
        }
        /// <p>Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is enabled, the cluster cannot be deleted unless it is modified and <code>DeletionProtection</code> is disabled. <code>DeletionProtection</code> protects clusters from being accidentally deleted.</p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.deletion_protection = Some(input);
            self
        }
        /// <p>Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is enabled, the cluster cannot be deleted unless it is modified and <code>DeletionProtection</code> is disabled. <code>DeletionProtection</code> protects clusters from being accidentally deleted.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreDbClusterToPointInTimeInput`](crate::input::RestoreDbClusterToPointInTimeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RestoreDbClusterToPointInTimeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RestoreDbClusterToPointInTimeInput {
                db_cluster_identifier: self.db_cluster_identifier,
                source_db_cluster_identifier: self.source_db_cluster_identifier,
                restore_to_time: self.restore_to_time,
                use_latest_restorable_time: self.use_latest_restorable_time.unwrap_or_default(),
                port: self.port,
                db_subnet_group_name: self.db_subnet_group_name,
                vpc_security_group_ids: self.vpc_security_group_ids,
                tags: self.tags,
                kms_key_id: self.kms_key_id,
                enable_cloudwatch_logs_exports: self.enable_cloudwatch_logs_exports,
                deletion_protection: self.deletion_protection,
            })
        }
    }
}
#[doc(hidden)]
pub type RestoreDbClusterToPointInTimeInputOperationOutputAlias =
    crate::operation::RestoreDBClusterToPointInTime;
#[doc(hidden)]
pub type RestoreDbClusterToPointInTimeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RestoreDbClusterToPointInTimeInput {
    /// Consumes the builder and constructs an Operation<[`RestoreDBClusterToPointInTime`](crate::operation::RestoreDBClusterToPointInTime)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RestoreDBClusterToPointInTime,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RestoreDbClusterToPointInTimeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RestoreDbClusterToPointInTimeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RestoreDbClusterToPointInTimeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_restore_db_cluster_to_point_in_time(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RestoreDBClusterToPointInTime::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RestoreDBClusterToPointInTime",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RestoreDbClusterToPointInTimeInput`](crate::input::RestoreDbClusterToPointInTimeInput)
    pub fn builder() -> crate::input::restore_db_cluster_to_point_in_time_input::Builder {
        crate::input::restore_db_cluster_to_point_in_time_input::Builder::default()
    }
}

/// See [`StartDbClusterInput`](crate::input::StartDbClusterInput)
pub mod start_db_cluster_input {
    /// A builder for [`StartDbClusterInput`](crate::input::StartDbClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the cluster to restart. Example:
        /// <code>docdb-2019-05-28-15-24-52</code>
        /// </p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster to restart. Example:
        /// <code>docdb-2019-05-28-15-24-52</code>
        /// </p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`StartDbClusterInput`](crate::input::StartDbClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartDbClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartDbClusterInput {
                db_cluster_identifier: self.db_cluster_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type StartDbClusterInputOperationOutputAlias = crate::operation::StartDBCluster;
#[doc(hidden)]
pub type StartDbClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartDbClusterInput {
    /// Consumes the builder and constructs an Operation<[`StartDBCluster`](crate::operation::StartDBCluster)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartDBCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartDbClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartDbClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartDbClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_db_cluster(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartDBCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartDBCluster",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartDbClusterInput`](crate::input::StartDbClusterInput)
    pub fn builder() -> crate::input::start_db_cluster_input::Builder {
        crate::input::start_db_cluster_input::Builder::default()
    }
}

/// See [`StopDbClusterInput`](crate::input::StopDbClusterInput)
pub mod stop_db_cluster_input {
    /// A builder for [`StopDbClusterInput`](crate::input::StopDbClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the cluster to stop. Example:
        /// <code>docdb-2019-05-28-15-24-52</code>
        /// </p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster to stop. Example:
        /// <code>docdb-2019-05-28-15-24-52</code>
        /// </p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`StopDbClusterInput`](crate::input::StopDbClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopDbClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopDbClusterInput {
                db_cluster_identifier: self.db_cluster_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type StopDbClusterInputOperationOutputAlias = crate::operation::StopDBCluster;
#[doc(hidden)]
pub type StopDbClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StopDbClusterInput {
    /// Consumes the builder and constructs an Operation<[`StopDBCluster`](crate::operation::StopDBCluster)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopDBCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopDbClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopDbClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopDbClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_stop_db_cluster(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopDBCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopDBCluster",
            "docdb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopDbClusterInput`](crate::input::StopDbClusterInput)
    pub fn builder() -> crate::input::stop_db_cluster_input::Builder {
        crate::input::stop_db_cluster_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopDbClusterInput {
    /// <p>The identifier of the cluster to stop. Example:
    /// <code>docdb-2019-05-28-15-24-52</code>
    /// </p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
}
impl StopDbClusterInput {
    /// <p>The identifier of the cluster to stop. Example:
    /// <code>docdb-2019-05-28-15-24-52</code>
    /// </p>
    pub fn db_cluster_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_identifier.as_deref()
    }
}
impl std::fmt::Debug for StopDbClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopDbClusterInput");
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartDbClusterInput {
    /// <p>The identifier of the cluster to restart. Example:
    /// <code>docdb-2019-05-28-15-24-52</code>
    /// </p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
}
impl StartDbClusterInput {
    /// <p>The identifier of the cluster to restart. Example:
    /// <code>docdb-2019-05-28-15-24-52</code>
    /// </p>
    pub fn db_cluster_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_identifier.as_deref()
    }
}
impl std::fmt::Debug for StartDbClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartDbClusterInput");
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>RestoreDBClusterToPointInTime</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreDbClusterToPointInTimeInput {
    /// <p>The name of the new cluster to be created.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
    /// </li>
    /// <li>
    /// <p>The first character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
    /// </li>
    /// </ul>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The identifier of the source cluster from which to restore.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must match the identifier of an existing <code>DBCluster</code>.</p>
    /// </li>
    /// </ul>
    pub source_db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The date and time to restore the cluster to.</p>
    /// <p>Valid values: A time in Universal Coordinated Time (UTC) format.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be before the latest restorable time for the instance.</p>
    /// </li>
    /// <li>
    /// <p>Must be specified if the <code>UseLatestRestorableTime</code> parameter is not provided.</p>
    /// </li>
    /// <li>
    /// <p>Cannot be specified if the <code>UseLatestRestorableTime</code> parameter is <code>true</code>.</p>
    /// </li>
    /// <li>
    /// <p>Cannot be specified if the <code>RestoreType</code> parameter is <code>copy-on-write</code>.</p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>2015-03-07T23:45:00Z</code>
    /// </p>
    pub restore_to_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A value that is set to <code>true</code> to restore the cluster to the latest
    /// restorable backup time, and <code>false</code> otherwise. </p>
    /// <p>Default: <code>false</code>
    /// </p>
    /// <p>Constraints: Cannot be specified if the <code>RestoreToTime</code> parameter is
    /// provided.</p>
    pub use_latest_restorable_time: bool,
    /// <p>The port number on which the new cluster accepts connections.</p>
    /// <p>Constraints: Must be a value from <code>1150</code> to <code>65535</code>. </p>
    /// <p>Default: The default port for the engine.</p>
    pub port: std::option::Option<i32>,
    /// <p>The subnet group name to use for the new cluster.</p>
    /// <p>Constraints: If provided, must match the name of an existing
    /// <code>DBSubnetGroup</code>.</p>
    /// <p>Example: <code>mySubnetgroup</code>
    /// </p>
    pub db_subnet_group_name: std::option::Option<std::string::String>,
    /// <p>A list of VPC security groups that the new cluster belongs to.</p>
    pub vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The tags to be assigned to the restored cluster.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The KMS key identifier to use when restoring an encrypted cluster from an encrypted cluster.</p>
    /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a cluster with the same account that owns the KMS encryption key used to encrypt the new cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.</p>
    /// <p>You can restore to a new cluster and encrypt the new cluster with an KMS key that is different from the KMS key used to encrypt the source cluster. The new DB cluster is encrypted with the KMS key identified by the <code>KmsKeyId</code> parameter.</p>
    /// <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following occurs:</p>
    /// <ul>
    /// <li>
    /// <p>If the cluster is encrypted, then the restored cluster is encrypted using the KMS key that was used to encrypt the source cluster.</p>
    /// </li>
    /// <li>
    /// <p>If the cluster is not encrypted, then the restored cluster is not encrypted.</p>
    /// </li>
    /// </ul>
    /// <p>If <code>DBClusterIdentifier</code> refers to a cluster that is not encrypted, then
    /// the restore request is rejected.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>A list of log types that must be enabled for exporting to Amazon CloudWatch
    /// Logs.</p>
    pub enable_cloudwatch_logs_exports: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is enabled, the cluster cannot be deleted unless it is modified and <code>DeletionProtection</code> is disabled. <code>DeletionProtection</code> protects clusters from being accidentally deleted.</p>
    pub deletion_protection: std::option::Option<bool>,
}
impl RestoreDbClusterToPointInTimeInput {
    /// <p>The name of the new cluster to be created.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
    /// </li>
    /// <li>
    /// <p>The first character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
    /// </li>
    /// </ul>
    pub fn db_cluster_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_identifier.as_deref()
    }
    /// <p>The identifier of the source cluster from which to restore.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must match the identifier of an existing <code>DBCluster</code>.</p>
    /// </li>
    /// </ul>
    pub fn source_db_cluster_identifier(&self) -> std::option::Option<&str> {
        self.source_db_cluster_identifier.as_deref()
    }
    /// <p>The date and time to restore the cluster to.</p>
    /// <p>Valid values: A time in Universal Coordinated Time (UTC) format.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be before the latest restorable time for the instance.</p>
    /// </li>
    /// <li>
    /// <p>Must be specified if the <code>UseLatestRestorableTime</code> parameter is not provided.</p>
    /// </li>
    /// <li>
    /// <p>Cannot be specified if the <code>UseLatestRestorableTime</code> parameter is <code>true</code>.</p>
    /// </li>
    /// <li>
    /// <p>Cannot be specified if the <code>RestoreType</code> parameter is <code>copy-on-write</code>.</p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>2015-03-07T23:45:00Z</code>
    /// </p>
    pub fn restore_to_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.restore_to_time.as_ref()
    }
    /// <p>A value that is set to <code>true</code> to restore the cluster to the latest
    /// restorable backup time, and <code>false</code> otherwise. </p>
    /// <p>Default: <code>false</code>
    /// </p>
    /// <p>Constraints: Cannot be specified if the <code>RestoreToTime</code> parameter is
    /// provided.</p>
    pub fn use_latest_restorable_time(&self) -> bool {
        self.use_latest_restorable_time
    }
    /// <p>The port number on which the new cluster accepts connections.</p>
    /// <p>Constraints: Must be a value from <code>1150</code> to <code>65535</code>. </p>
    /// <p>Default: The default port for the engine.</p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
    /// <p>The subnet group name to use for the new cluster.</p>
    /// <p>Constraints: If provided, must match the name of an existing
    /// <code>DBSubnetGroup</code>.</p>
    /// <p>Example: <code>mySubnetgroup</code>
    /// </p>
    pub fn db_subnet_group_name(&self) -> std::option::Option<&str> {
        self.db_subnet_group_name.as_deref()
    }
    /// <p>A list of VPC security groups that the new cluster belongs to.</p>
    pub fn vpc_security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.vpc_security_group_ids.as_deref()
    }
    /// <p>The tags to be assigned to the restored cluster.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The KMS key identifier to use when restoring an encrypted cluster from an encrypted cluster.</p>
    /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a cluster with the same account that owns the KMS encryption key used to encrypt the new cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.</p>
    /// <p>You can restore to a new cluster and encrypt the new cluster with an KMS key that is different from the KMS key used to encrypt the source cluster. The new DB cluster is encrypted with the KMS key identified by the <code>KmsKeyId</code> parameter.</p>
    /// <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following occurs:</p>
    /// <ul>
    /// <li>
    /// <p>If the cluster is encrypted, then the restored cluster is encrypted using the KMS key that was used to encrypt the source cluster.</p>
    /// </li>
    /// <li>
    /// <p>If the cluster is not encrypted, then the restored cluster is not encrypted.</p>
    /// </li>
    /// </ul>
    /// <p>If <code>DBClusterIdentifier</code> refers to a cluster that is not encrypted, then
    /// the restore request is rejected.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>A list of log types that must be enabled for exporting to Amazon CloudWatch
    /// Logs.</p>
    pub fn enable_cloudwatch_logs_exports(&self) -> std::option::Option<&[std::string::String]> {
        self.enable_cloudwatch_logs_exports.as_deref()
    }
    /// <p>Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is enabled, the cluster cannot be deleted unless it is modified and <code>DeletionProtection</code> is disabled. <code>DeletionProtection</code> protects clusters from being accidentally deleted.</p>
    pub fn deletion_protection(&self) -> std::option::Option<bool> {
        self.deletion_protection
    }
}
impl std::fmt::Debug for RestoreDbClusterToPointInTimeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreDbClusterToPointInTimeInput");
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field(
            "source_db_cluster_identifier",
            &self.source_db_cluster_identifier,
        );
        formatter.field("restore_to_time", &self.restore_to_time);
        formatter.field(
            "use_latest_restorable_time",
            &self.use_latest_restorable_time,
        );
        formatter.field("port", &self.port);
        formatter.field("db_subnet_group_name", &self.db_subnet_group_name);
        formatter.field("vpc_security_group_ids", &self.vpc_security_group_ids);
        formatter.field("tags", &self.tags);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field(
            "enable_cloudwatch_logs_exports",
            &self.enable_cloudwatch_logs_exports,
        );
        formatter.field("deletion_protection", &self.deletion_protection);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>RestoreDBClusterFromSnapshot</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreDbClusterFromSnapshotInput {
    /// <p>Provides the list of Amazon EC2 Availability Zones that instances in the restored DB
    /// cluster can be created in.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the cluster to create from the snapshot or cluster snapshot. This
    /// parameter isn't case sensitive.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
    /// </li>
    /// <li>
    /// <p>The first character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>my-snapshot-id</code>
    /// </p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The identifier for the snapshot or cluster snapshot to restore from.</p>
    /// <p>You can use either the name or the Amazon Resource Name (ARN) to specify a cluster
    /// snapshot. However, you can use only the ARN to specify a snapshot.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must match the identifier of an existing snapshot.</p>
    /// </li>
    /// </ul>
    pub snapshot_identifier: std::option::Option<std::string::String>,
    /// <p>The database engine to use for the new cluster.</p>
    /// <p>Default: The same as source.</p>
    /// <p>Constraint: Must be compatible with the engine of the source.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The version of the database engine to use for the new cluster.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The port number on which the new cluster accepts connections.</p>
    /// <p>Constraints: Must be a value from <code>1150</code> to <code>65535</code>.</p>
    /// <p>Default: The same port as the original cluster.</p>
    pub port: std::option::Option<i32>,
    /// <p>The name of the subnet group to use for the new cluster.</p>
    /// <p>Constraints: If provided, must match the name of an existing
    /// <code>DBSubnetGroup</code>.</p>
    /// <p>Example: <code>mySubnetgroup</code>
    /// </p>
    pub db_subnet_group_name: std::option::Option<std::string::String>,
    /// <p>A list of virtual private cloud (VPC) security groups that the new cluster will
    /// belong to.</p>
    pub vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The tags to be assigned to the restored cluster.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The KMS key identifier to use when restoring an encrypted cluster from a DB snapshot or cluster snapshot.</p>
    /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a cluster with the same account that owns the KMS encryption key used to encrypt the new cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.</p>
    /// <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the
    /// following occurs:</p>
    /// <ul>
    /// <li>
    /// <p>If the snapshot or cluster snapshot in <code>SnapshotIdentifier</code> is encrypted, then the restored cluster is encrypted using the KMS key that was used to encrypt the snapshot or the cluster snapshot.</p>
    /// </li>
    /// <li>
    /// <p>If the snapshot or the cluster snapshot in
    /// <code>SnapshotIdentifier</code> is not encrypted, then the restored DB
    /// cluster is not encrypted.</p>
    /// </li>
    /// </ul>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>A list of log types that must be enabled for exporting to Amazon CloudWatch Logs.</p>
    pub enable_cloudwatch_logs_exports: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is enabled, the cluster cannot be deleted unless it is modified and <code>DeletionProtection</code> is disabled. <code>DeletionProtection</code> protects clusters from being accidentally deleted.</p>
    pub deletion_protection: std::option::Option<bool>,
}
impl RestoreDbClusterFromSnapshotInput {
    /// <p>Provides the list of Amazon EC2 Availability Zones that instances in the restored DB
    /// cluster can be created in.</p>
    pub fn availability_zones(&self) -> std::option::Option<&[std::string::String]> {
        self.availability_zones.as_deref()
    }
    /// <p>The name of the cluster to create from the snapshot or cluster snapshot. This
    /// parameter isn't case sensitive.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
    /// </li>
    /// <li>
    /// <p>The first character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>my-snapshot-id</code>
    /// </p>
    pub fn db_cluster_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_identifier.as_deref()
    }
    /// <p>The identifier for the snapshot or cluster snapshot to restore from.</p>
    /// <p>You can use either the name or the Amazon Resource Name (ARN) to specify a cluster
    /// snapshot. However, you can use only the ARN to specify a snapshot.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must match the identifier of an existing snapshot.</p>
    /// </li>
    /// </ul>
    pub fn snapshot_identifier(&self) -> std::option::Option<&str> {
        self.snapshot_identifier.as_deref()
    }
    /// <p>The database engine to use for the new cluster.</p>
    /// <p>Default: The same as source.</p>
    /// <p>Constraint: Must be compatible with the engine of the source.</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The version of the database engine to use for the new cluster.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The port number on which the new cluster accepts connections.</p>
    /// <p>Constraints: Must be a value from <code>1150</code> to <code>65535</code>.</p>
    /// <p>Default: The same port as the original cluster.</p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
    /// <p>The name of the subnet group to use for the new cluster.</p>
    /// <p>Constraints: If provided, must match the name of an existing
    /// <code>DBSubnetGroup</code>.</p>
    /// <p>Example: <code>mySubnetgroup</code>
    /// </p>
    pub fn db_subnet_group_name(&self) -> std::option::Option<&str> {
        self.db_subnet_group_name.as_deref()
    }
    /// <p>A list of virtual private cloud (VPC) security groups that the new cluster will
    /// belong to.</p>
    pub fn vpc_security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.vpc_security_group_ids.as_deref()
    }
    /// <p>The tags to be assigned to the restored cluster.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The KMS key identifier to use when restoring an encrypted cluster from a DB snapshot or cluster snapshot.</p>
    /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a cluster with the same account that owns the KMS encryption key used to encrypt the new cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.</p>
    /// <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the
    /// following occurs:</p>
    /// <ul>
    /// <li>
    /// <p>If the snapshot or cluster snapshot in <code>SnapshotIdentifier</code> is encrypted, then the restored cluster is encrypted using the KMS key that was used to encrypt the snapshot or the cluster snapshot.</p>
    /// </li>
    /// <li>
    /// <p>If the snapshot or the cluster snapshot in
    /// <code>SnapshotIdentifier</code> is not encrypted, then the restored DB
    /// cluster is not encrypted.</p>
    /// </li>
    /// </ul>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>A list of log types that must be enabled for exporting to Amazon CloudWatch Logs.</p>
    pub fn enable_cloudwatch_logs_exports(&self) -> std::option::Option<&[std::string::String]> {
        self.enable_cloudwatch_logs_exports.as_deref()
    }
    /// <p>Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is enabled, the cluster cannot be deleted unless it is modified and <code>DeletionProtection</code> is disabled. <code>DeletionProtection</code> protects clusters from being accidentally deleted.</p>
    pub fn deletion_protection(&self) -> std::option::Option<bool> {
        self.deletion_protection
    }
}
impl std::fmt::Debug for RestoreDbClusterFromSnapshotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreDbClusterFromSnapshotInput");
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field("snapshot_identifier", &self.snapshot_identifier);
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("port", &self.port);
        formatter.field("db_subnet_group_name", &self.db_subnet_group_name);
        formatter.field("vpc_security_group_ids", &self.vpc_security_group_ids);
        formatter.field("tags", &self.tags);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field(
            "enable_cloudwatch_logs_exports",
            &self.enable_cloudwatch_logs_exports,
        );
        formatter.field("deletion_protection", &self.deletion_protection);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>ResetDBClusterParameterGroup</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResetDbClusterParameterGroupInput {
    /// <p>The name of the cluster parameter group to reset.</p>
    pub db_cluster_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>A value that is set to <code>true</code> to reset all parameters in the cluster
    /// parameter group to their default values, and <code>false</code> otherwise. You can't use
    /// this parameter if there is a list of parameter names specified for the
    /// <code>Parameters</code> parameter.</p>
    pub reset_all_parameters: bool,
    /// <p>A list of parameter names in the cluster parameter group to reset to the default
    /// values. You can't use this parameter if the <code>ResetAllParameters</code> parameter is
    /// set to <code>true</code>.</p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
}
impl ResetDbClusterParameterGroupInput {
    /// <p>The name of the cluster parameter group to reset.</p>
    pub fn db_cluster_parameter_group_name(&self) -> std::option::Option<&str> {
        self.db_cluster_parameter_group_name.as_deref()
    }
    /// <p>A value that is set to <code>true</code> to reset all parameters in the cluster
    /// parameter group to their default values, and <code>false</code> otherwise. You can't use
    /// this parameter if there is a list of parameter names specified for the
    /// <code>Parameters</code> parameter.</p>
    pub fn reset_all_parameters(&self) -> bool {
        self.reset_all_parameters
    }
    /// <p>A list of parameter names in the cluster parameter group to reset to the default
    /// values. You can't use this parameter if the <code>ResetAllParameters</code> parameter is
    /// set to <code>true</code>.</p>
    pub fn parameters(&self) -> std::option::Option<&[crate::model::Parameter]> {
        self.parameters.as_deref()
    }
}
impl std::fmt::Debug for ResetDbClusterParameterGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResetDbClusterParameterGroupInput");
        formatter.field(
            "db_cluster_parameter_group_name",
            &self.db_cluster_parameter_group_name,
        );
        formatter.field("reset_all_parameters", &self.reset_all_parameters);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>RemoveTagsFromResource</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTagsFromResourceInput {
    /// <p>The Amazon DocumentDB resource that the tags are removed from. This value is an Amazon Resource
    /// Name (ARN).</p>
    pub resource_name: std::option::Option<std::string::String>,
    /// <p>The tag key (name) of the tag to be removed.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl RemoveTagsFromResourceInput {
    /// <p>The Amazon DocumentDB resource that the tags are removed from. This value is an Amazon Resource
    /// Name (ARN).</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
    /// <p>The tag key (name) of the tag to be removed.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for RemoveTagsFromResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTagsFromResourceInput");
        formatter.field("resource_name", &self.resource_name);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>RemoveSourceIdentifierFromSubscription</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveSourceIdentifierFromSubscriptionInput {
    /// <p>The name of the Amazon DocumentDB event notification subscription that you want to remove a
    /// source identifier from.</p>
    pub subscription_name: std::option::Option<std::string::String>,
    /// <p> The source identifier to be removed from the subscription, such as the instance
    /// identifier for an instance, or the name of a security group. </p>
    pub source_identifier: std::option::Option<std::string::String>,
}
impl RemoveSourceIdentifierFromSubscriptionInput {
    /// <p>The name of the Amazon DocumentDB event notification subscription that you want to remove a
    /// source identifier from.</p>
    pub fn subscription_name(&self) -> std::option::Option<&str> {
        self.subscription_name.as_deref()
    }
    /// <p> The source identifier to be removed from the subscription, such as the instance
    /// identifier for an instance, or the name of a security group. </p>
    pub fn source_identifier(&self) -> std::option::Option<&str> {
        self.source_identifier.as_deref()
    }
}
impl std::fmt::Debug for RemoveSourceIdentifierFromSubscriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveSourceIdentifierFromSubscriptionInput");
        formatter.field("subscription_name", &self.subscription_name);
        formatter.field("source_identifier", &self.source_identifier);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>RemoveFromGlobalCluster</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveFromGlobalClusterInput {
    /// <p>The cluster identifier to detach from the Amazon DocumentDB global cluster. </p>
    pub global_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) identifying the cluster that was detached from the Amazon DocumentDB global cluster. </p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
}
impl RemoveFromGlobalClusterInput {
    /// <p>The cluster identifier to detach from the Amazon DocumentDB global cluster. </p>
    pub fn global_cluster_identifier(&self) -> std::option::Option<&str> {
        self.global_cluster_identifier.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) identifying the cluster that was detached from the Amazon DocumentDB global cluster. </p>
    pub fn db_cluster_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_identifier.as_deref()
    }
}
impl std::fmt::Debug for RemoveFromGlobalClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveFromGlobalClusterInput");
        formatter.field("global_cluster_identifier", &self.global_cluster_identifier);
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>RebootDBInstance</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RebootDbInstanceInput {
    /// <p>The instance identifier. This parameter is stored as a lowercase string.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must match the identifier of an existing <code>DBInstance</code>.</p>
    /// </li>
    /// </ul>
    pub db_instance_identifier: std::option::Option<std::string::String>,
    /// <p> When <code>true</code>, the reboot is conducted through a Multi-AZ failover. </p>
    /// <p>Constraint: You can't specify <code>true</code> if the instance is not configured for
    /// Multi-AZ.</p>
    pub force_failover: std::option::Option<bool>,
}
impl RebootDbInstanceInput {
    /// <p>The instance identifier. This parameter is stored as a lowercase string.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must match the identifier of an existing <code>DBInstance</code>.</p>
    /// </li>
    /// </ul>
    pub fn db_instance_identifier(&self) -> std::option::Option<&str> {
        self.db_instance_identifier.as_deref()
    }
    /// <p> When <code>true</code>, the reboot is conducted through a Multi-AZ failover. </p>
    /// <p>Constraint: You can't specify <code>true</code> if the instance is not configured for
    /// Multi-AZ.</p>
    pub fn force_failover(&self) -> std::option::Option<bool> {
        self.force_failover
    }
}
impl std::fmt::Debug for RebootDbInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RebootDbInstanceInput");
        formatter.field("db_instance_identifier", &self.db_instance_identifier);
        formatter.field("force_failover", &self.force_failover);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>ModifyGlobalCluster</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyGlobalClusterInput {
    /// <p>The identifier for the global cluster being modified. This parameter isn't case-sensitive.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must match the identifier of an existing global cluster.</p>
    /// </li>
    /// </ul>
    pub global_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The new identifier for a global cluster when you modify a global cluster. This value is stored as a lowercase string.</p>
    /// <ul>
    /// <li>
    /// <p>Must contain from 1 to 63 letters, numbers, or hyphens</p>
    /// <p>The first character must be a letter</p>
    /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>my-cluster2</code>
    /// </p>
    pub new_global_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>Indicates if the global cluster has deletion protection enabled. The global cluster can't be deleted when deletion protection is enabled. </p>
    pub deletion_protection: std::option::Option<bool>,
}
impl ModifyGlobalClusterInput {
    /// <p>The identifier for the global cluster being modified. This parameter isn't case-sensitive.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must match the identifier of an existing global cluster.</p>
    /// </li>
    /// </ul>
    pub fn global_cluster_identifier(&self) -> std::option::Option<&str> {
        self.global_cluster_identifier.as_deref()
    }
    /// <p>The new identifier for a global cluster when you modify a global cluster. This value is stored as a lowercase string.</p>
    /// <ul>
    /// <li>
    /// <p>Must contain from 1 to 63 letters, numbers, or hyphens</p>
    /// <p>The first character must be a letter</p>
    /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>my-cluster2</code>
    /// </p>
    pub fn new_global_cluster_identifier(&self) -> std::option::Option<&str> {
        self.new_global_cluster_identifier.as_deref()
    }
    /// <p>Indicates if the global cluster has deletion protection enabled. The global cluster can't be deleted when deletion protection is enabled. </p>
    pub fn deletion_protection(&self) -> std::option::Option<bool> {
        self.deletion_protection
    }
}
impl std::fmt::Debug for ModifyGlobalClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyGlobalClusterInput");
        formatter.field("global_cluster_identifier", &self.global_cluster_identifier);
        formatter.field(
            "new_global_cluster_identifier",
            &self.new_global_cluster_identifier,
        );
        formatter.field("deletion_protection", &self.deletion_protection);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>ModifyEventSubscription</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyEventSubscriptionInput {
    /// <p>The name of the Amazon DocumentDB event notification subscription.</p>
    pub subscription_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The
    /// ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>The type of source that is generating the events. For example, if you want to be notified of events generated by an instance, set this parameter to <code>db-instance</code>. If this value is not specified, all events are returned.</p>
    /// <p>Valid values: <code>db-instance</code>, <code>db-parameter-group</code>, <code>db-security-group</code>
    /// </p>
    pub source_type: std::option::Option<std::string::String>,
    /// <p> A list of event categories for a <code>SourceType</code> that you want to subscribe
    /// to.</p>
    pub event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> A Boolean value; set to <code>true</code> to activate the subscription. </p>
    pub enabled: std::option::Option<bool>,
}
impl ModifyEventSubscriptionInput {
    /// <p>The name of the Amazon DocumentDB event notification subscription.</p>
    pub fn subscription_name(&self) -> std::option::Option<&str> {
        self.subscription_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The
    /// ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>
    pub fn sns_topic_arn(&self) -> std::option::Option<&str> {
        self.sns_topic_arn.as_deref()
    }
    /// <p>The type of source that is generating the events. For example, if you want to be notified of events generated by an instance, set this parameter to <code>db-instance</code>. If this value is not specified, all events are returned.</p>
    /// <p>Valid values: <code>db-instance</code>, <code>db-parameter-group</code>, <code>db-security-group</code>
    /// </p>
    pub fn source_type(&self) -> std::option::Option<&str> {
        self.source_type.as_deref()
    }
    /// <p> A list of event categories for a <code>SourceType</code> that you want to subscribe
    /// to.</p>
    pub fn event_categories(&self) -> std::option::Option<&[std::string::String]> {
        self.event_categories.as_deref()
    }
    /// <p> A Boolean value; set to <code>true</code> to activate the subscription. </p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
}
impl std::fmt::Debug for ModifyEventSubscriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyEventSubscriptionInput");
        formatter.field("subscription_name", &self.subscription_name);
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.field("source_type", &self.source_type);
        formatter.field("event_categories", &self.event_categories);
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>ModifyDBSubnetGroup</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyDbSubnetGroupInput {
    /// <p>The name for the subnet group. This value is stored as a lowercase string. You can't modify the default subnet group. </p>
    /// <p>Constraints: Must match the name of an existing <code>DBSubnetGroup</code>. Must not be default.</p>
    /// <p>Example: <code>mySubnetgroup</code>
    /// </p>
    pub db_subnet_group_name: std::option::Option<std::string::String>,
    /// <p>The description for the subnet group.</p>
    pub db_subnet_group_description: std::option::Option<std::string::String>,
    /// <p>The Amazon EC2 subnet IDs for the subnet group.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ModifyDbSubnetGroupInput {
    /// <p>The name for the subnet group. This value is stored as a lowercase string. You can't modify the default subnet group. </p>
    /// <p>Constraints: Must match the name of an existing <code>DBSubnetGroup</code>. Must not be default.</p>
    /// <p>Example: <code>mySubnetgroup</code>
    /// </p>
    pub fn db_subnet_group_name(&self) -> std::option::Option<&str> {
        self.db_subnet_group_name.as_deref()
    }
    /// <p>The description for the subnet group.</p>
    pub fn db_subnet_group_description(&self) -> std::option::Option<&str> {
        self.db_subnet_group_description.as_deref()
    }
    /// <p>The Amazon EC2 subnet IDs for the subnet group.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
}
impl std::fmt::Debug for ModifyDbSubnetGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyDbSubnetGroupInput");
        formatter.field("db_subnet_group_name", &self.db_subnet_group_name);
        formatter.field(
            "db_subnet_group_description",
            &self.db_subnet_group_description,
        );
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>ModifyDBInstance</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyDbInstanceInput {
    /// <p>The instance identifier. This value is stored as a lowercase string.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must match the identifier of an existing <code>DBInstance</code>.</p>
    /// </li>
    /// </ul>
    pub db_instance_identifier: std::option::Option<std::string::String>,
    /// <p>The new compute and memory capacity of the instance; for example, <code>db.r5.large</code>. Not all instance classes are available in all Regions. </p>
    /// <p>If you modify the instance class, an outage occurs during the change. The change is
    /// applied during the next maintenance window, unless <code>ApplyImmediately</code> is
    /// specified as <code>true</code> for this request. </p>
    /// <p>Default: Uses existing setting.</p>
    pub db_instance_class: std::option::Option<std::string::String>,
    /// <p>Specifies whether the modifications in this request and any pending modifications are
    /// asynchronously applied as soon as possible, regardless of the
    /// <code>PreferredMaintenanceWindow</code> setting for the instance. </p>
    /// <p> If this parameter is set to <code>false</code>, changes to the instance are
    /// applied during the next maintenance window. Some parameter changes can cause an outage
    /// and are applied on the next reboot.</p>
    /// <p>Default: <code>false</code>
    /// </p>
    pub apply_immediately: bool,
    /// <p>The weekly time range (in UTC) during which system maintenance can occur, which might
    /// result in an outage. Changing this parameter doesn't result in an outage except in the
    /// following situation, and the change is asynchronously applied as soon as possible. If
    /// there are pending actions that cause a reboot, and the maintenance window is changed to
    /// include the current time, changing this parameter causes a reboot of the instance. If
    /// you are moving this window to the current time, there must be at least 30 minutes
    /// between the current time and end of the window to ensure that pending changes are
    /// applied.</p>
    /// <p>Default: Uses existing setting.</p>
    /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
    /// </p>
    /// <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p>
    /// <p>Constraints: Must be at least 30 minutes.</p>
    pub preferred_maintenance_window: std::option::Option<std::string::String>,
    /// <p>This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.</p>
    pub auto_minor_version_upgrade: std::option::Option<bool>,
    /// <p> The new instance identifier for the instance when renaming an instance. When you change the instance identifier, an instance reboot occurs immediately if you set <code>Apply Immediately</code> to <code>true</code>. It occurs during the next maintenance window if you set <code>Apply Immediately</code> to <code>false</code>. This value is stored as a lowercase string. </p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
    /// </li>
    /// <li>
    /// <p>The first character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>mydbinstance</code>
    /// </p>
    pub new_db_instance_identifier: std::option::Option<std::string::String>,
    /// <p>Indicates the certificate that needs to be associated with the instance.</p>
    pub ca_certificate_identifier: std::option::Option<std::string::String>,
    /// <p>A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary instance after a failure of the existing primary instance.</p>
    /// <p>Default: 1</p>
    /// <p>Valid values: 0-15</p>
    pub promotion_tier: std::option::Option<i32>,
}
impl ModifyDbInstanceInput {
    /// <p>The instance identifier. This value is stored as a lowercase string.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must match the identifier of an existing <code>DBInstance</code>.</p>
    /// </li>
    /// </ul>
    pub fn db_instance_identifier(&self) -> std::option::Option<&str> {
        self.db_instance_identifier.as_deref()
    }
    /// <p>The new compute and memory capacity of the instance; for example, <code>db.r5.large</code>. Not all instance classes are available in all Regions. </p>
    /// <p>If you modify the instance class, an outage occurs during the change. The change is
    /// applied during the next maintenance window, unless <code>ApplyImmediately</code> is
    /// specified as <code>true</code> for this request. </p>
    /// <p>Default: Uses existing setting.</p>
    pub fn db_instance_class(&self) -> std::option::Option<&str> {
        self.db_instance_class.as_deref()
    }
    /// <p>Specifies whether the modifications in this request and any pending modifications are
    /// asynchronously applied as soon as possible, regardless of the
    /// <code>PreferredMaintenanceWindow</code> setting for the instance. </p>
    /// <p> If this parameter is set to <code>false</code>, changes to the instance are
    /// applied during the next maintenance window. Some parameter changes can cause an outage
    /// and are applied on the next reboot.</p>
    /// <p>Default: <code>false</code>
    /// </p>
    pub fn apply_immediately(&self) -> bool {
        self.apply_immediately
    }
    /// <p>The weekly time range (in UTC) during which system maintenance can occur, which might
    /// result in an outage. Changing this parameter doesn't result in an outage except in the
    /// following situation, and the change is asynchronously applied as soon as possible. If
    /// there are pending actions that cause a reboot, and the maintenance window is changed to
    /// include the current time, changing this parameter causes a reboot of the instance. If
    /// you are moving this window to the current time, there must be at least 30 minutes
    /// between the current time and end of the window to ensure that pending changes are
    /// applied.</p>
    /// <p>Default: Uses existing setting.</p>
    /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
    /// </p>
    /// <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p>
    /// <p>Constraints: Must be at least 30 minutes.</p>
    pub fn preferred_maintenance_window(&self) -> std::option::Option<&str> {
        self.preferred_maintenance_window.as_deref()
    }
    /// <p>This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.</p>
    pub fn auto_minor_version_upgrade(&self) -> std::option::Option<bool> {
        self.auto_minor_version_upgrade
    }
    /// <p> The new instance identifier for the instance when renaming an instance. When you change the instance identifier, an instance reboot occurs immediately if you set <code>Apply Immediately</code> to <code>true</code>. It occurs during the next maintenance window if you set <code>Apply Immediately</code> to <code>false</code>. This value is stored as a lowercase string. </p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
    /// </li>
    /// <li>
    /// <p>The first character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>mydbinstance</code>
    /// </p>
    pub fn new_db_instance_identifier(&self) -> std::option::Option<&str> {
        self.new_db_instance_identifier.as_deref()
    }
    /// <p>Indicates the certificate that needs to be associated with the instance.</p>
    pub fn ca_certificate_identifier(&self) -> std::option::Option<&str> {
        self.ca_certificate_identifier.as_deref()
    }
    /// <p>A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary instance after a failure of the existing primary instance.</p>
    /// <p>Default: 1</p>
    /// <p>Valid values: 0-15</p>
    pub fn promotion_tier(&self) -> std::option::Option<i32> {
        self.promotion_tier
    }
}
impl std::fmt::Debug for ModifyDbInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyDbInstanceInput");
        formatter.field("db_instance_identifier", &self.db_instance_identifier);
        formatter.field("db_instance_class", &self.db_instance_class);
        formatter.field("apply_immediately", &self.apply_immediately);
        formatter.field(
            "preferred_maintenance_window",
            &self.preferred_maintenance_window,
        );
        formatter.field(
            "auto_minor_version_upgrade",
            &self.auto_minor_version_upgrade,
        );
        formatter.field(
            "new_db_instance_identifier",
            &self.new_db_instance_identifier,
        );
        formatter.field("ca_certificate_identifier", &self.ca_certificate_identifier);
        formatter.field("promotion_tier", &self.promotion_tier);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>ModifyDBClusterSnapshotAttribute</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyDbClusterSnapshotAttributeInput {
    /// <p>The identifier for the cluster snapshot to modify the attributes for.</p>
    pub db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
    /// <p>The name of the cluster snapshot attribute to modify.</p>
    /// <p>To manage authorization for other accounts to copy or restore a manual cluster
    /// snapshot, set this value to <code>restore</code>.</p>
    pub attribute_name: std::option::Option<std::string::String>,
    /// <p>A list of cluster snapshot attributes to add to the attribute specified by <code>AttributeName</code>.</p>
    /// <p>To authorize other accounts to copy or restore a manual cluster snapshot, set this list to include one or more account IDs. To make the manual cluster snapshot restorable by any account, set it to <code>all</code>. Do not add the <code>all</code> value for any manual cluster snapshots that contain private information that you don't want to be available to all accounts.</p>
    pub values_to_add: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of cluster snapshot attributes to remove from the attribute specified by <code>AttributeName</code>.</p>
    /// <p>To remove authorization for other accounts to copy or restore a manual cluster snapshot, set this list to include one or more account identifiers. To remove authorization for any account to copy or restore the cluster snapshot, set it to <code>all</code> . If you specify <code>all</code>, an account whose account ID is explicitly added to the <code>restore</code> attribute can still copy or restore a manual cluster snapshot.</p>
    pub values_to_remove: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ModifyDbClusterSnapshotAttributeInput {
    /// <p>The identifier for the cluster snapshot to modify the attributes for.</p>
    pub fn db_cluster_snapshot_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_snapshot_identifier.as_deref()
    }
    /// <p>The name of the cluster snapshot attribute to modify.</p>
    /// <p>To manage authorization for other accounts to copy or restore a manual cluster
    /// snapshot, set this value to <code>restore</code>.</p>
    pub fn attribute_name(&self) -> std::option::Option<&str> {
        self.attribute_name.as_deref()
    }
    /// <p>A list of cluster snapshot attributes to add to the attribute specified by <code>AttributeName</code>.</p>
    /// <p>To authorize other accounts to copy or restore a manual cluster snapshot, set this list to include one or more account IDs. To make the manual cluster snapshot restorable by any account, set it to <code>all</code>. Do not add the <code>all</code> value for any manual cluster snapshots that contain private information that you don't want to be available to all accounts.</p>
    pub fn values_to_add(&self) -> std::option::Option<&[std::string::String]> {
        self.values_to_add.as_deref()
    }
    /// <p>A list of cluster snapshot attributes to remove from the attribute specified by <code>AttributeName</code>.</p>
    /// <p>To remove authorization for other accounts to copy or restore a manual cluster snapshot, set this list to include one or more account identifiers. To remove authorization for any account to copy or restore the cluster snapshot, set it to <code>all</code> . If you specify <code>all</code>, an account whose account ID is explicitly added to the <code>restore</code> attribute can still copy or restore a manual cluster snapshot.</p>
    pub fn values_to_remove(&self) -> std::option::Option<&[std::string::String]> {
        self.values_to_remove.as_deref()
    }
}
impl std::fmt::Debug for ModifyDbClusterSnapshotAttributeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyDbClusterSnapshotAttributeInput");
        formatter.field(
            "db_cluster_snapshot_identifier",
            &self.db_cluster_snapshot_identifier,
        );
        formatter.field("attribute_name", &self.attribute_name);
        formatter.field("values_to_add", &self.values_to_add);
        formatter.field("values_to_remove", &self.values_to_remove);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>ModifyDBClusterParameterGroup</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyDbClusterParameterGroupInput {
    /// <p>The name of the cluster parameter group to modify.</p>
    pub db_cluster_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>A list of parameters in the cluster parameter group to modify.</p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
}
impl ModifyDbClusterParameterGroupInput {
    /// <p>The name of the cluster parameter group to modify.</p>
    pub fn db_cluster_parameter_group_name(&self) -> std::option::Option<&str> {
        self.db_cluster_parameter_group_name.as_deref()
    }
    /// <p>A list of parameters in the cluster parameter group to modify.</p>
    pub fn parameters(&self) -> std::option::Option<&[crate::model::Parameter]> {
        self.parameters.as_deref()
    }
}
impl std::fmt::Debug for ModifyDbClusterParameterGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyDbClusterParameterGroupInput");
        formatter.field(
            "db_cluster_parameter_group_name",
            &self.db_cluster_parameter_group_name,
        );
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>ModifyDBCluster</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyDbClusterInput {
    /// <p>The cluster identifier for the cluster that is being modified. This parameter is
    /// not case sensitive.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must match the identifier of an existing <code>DBCluster</code>.</p>
    /// </li>
    /// </ul>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The new cluster identifier for the cluster when renaming a cluster. This
    /// value is stored as a lowercase string.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
    /// </li>
    /// <li>
    /// <p>The first character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>my-cluster2</code>
    /// </p>
    pub new_db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>A value that specifies whether the changes in this request and any pending changes are
    /// asynchronously applied as soon as possible, regardless of the
    /// <code>PreferredMaintenanceWindow</code> setting for the cluster. If this
    /// parameter is set to <code>false</code>, changes to the cluster are applied during the
    /// next maintenance window.</p>
    /// <p>The <code>ApplyImmediately</code> parameter affects only the
    /// <code>NewDBClusterIdentifier</code> and <code>MasterUserPassword</code> values. If
    /// you set this parameter value to <code>false</code>, the changes to the
    /// <code>NewDBClusterIdentifier</code> and <code>MasterUserPassword</code> values are
    /// applied during the next maintenance window. All other changes are applied immediately,
    /// regardless of the value of the <code>ApplyImmediately</code> parameter.</p>
    /// <p>Default: <code>false</code>
    /// </p>
    pub apply_immediately: bool,
    /// <p>The number of days for which automated backups are retained. You must specify a
    /// minimum value of 1.</p>
    /// <p>Default: 1</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be a value from 1 to 35.</p>
    /// </li>
    /// </ul>
    pub backup_retention_period: std::option::Option<i32>,
    /// <p>The name of the cluster parameter group to use for the cluster.</p>
    pub db_cluster_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>A list of virtual private cloud (VPC) security groups that the cluster will belong
    /// to.</p>
    pub vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The port number on which the cluster accepts connections.</p>
    /// <p>Constraints: Must be a value from <code>1150</code> to <code>65535</code>. </p>
    /// <p>Default: The same port as the original cluster.</p>
    pub port: std::option::Option<i32>,
    /// <p>The password for the master database user. This password can contain any printable
    /// ASCII character except forward slash (/), double quote ("), or the "at" symbol
    /// (@).</p>
    /// <p>Constraints: Must contain from 8 to 100 characters.</p>
    pub master_user_password: std::option::Option<std::string::String>,
    /// <p>The daily time range during which automated backups are created if automated backups
    /// are enabled, using the <code>BackupRetentionPeriod</code> parameter. </p>
    /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for
    /// each Region. </p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p>
    /// </li>
    /// <li>
    /// <p>Must be in Universal Coordinated Time (UTC).</p>
    /// </li>
    /// <li>
    /// <p>Must not conflict with the preferred maintenance window.</p>
    /// </li>
    /// <li>
    /// <p>Must be at least 30 minutes.</p>
    /// </li>
    /// </ul>
    pub preferred_backup_window: std::option::Option<std::string::String>,
    /// <p>The weekly time range during which system maintenance can occur, in Universal
    /// Coordinated Time (UTC).</p>
    /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
    /// </p>
    /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for
    /// each Region, occurring on a random day of the week. </p>
    /// <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p>
    /// <p>Constraints: Minimum 30-minute window.</p>
    pub preferred_maintenance_window: std::option::Option<std::string::String>,
    /// <p>The configuration setting for the log types to be enabled for export to Amazon
    /// CloudWatch Logs for a specific instance or cluster. The
    /// <code>EnableLogTypes</code> and <code>DisableLogTypes</code> arrays determine which
    /// logs are exported (or not exported) to CloudWatch Logs.</p>
    pub cloudwatch_logs_export_configuration:
        std::option::Option<crate::model::CloudwatchLogsExportConfiguration>,
    /// <p>The version number of the database engine to which you want to upgrade. Modifying engine version is not supported on Amazon DocumentDB.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is
    /// enabled, the cluster cannot be deleted unless it is modified and
    /// <code>DeletionProtection</code> is disabled. <code>DeletionProtection</code>
    /// protects clusters from being accidentally deleted.</p>
    pub deletion_protection: std::option::Option<bool>,
}
impl ModifyDbClusterInput {
    /// <p>The cluster identifier for the cluster that is being modified. This parameter is
    /// not case sensitive.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must match the identifier of an existing <code>DBCluster</code>.</p>
    /// </li>
    /// </ul>
    pub fn db_cluster_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_identifier.as_deref()
    }
    /// <p>The new cluster identifier for the cluster when renaming a cluster. This
    /// value is stored as a lowercase string.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
    /// </li>
    /// <li>
    /// <p>The first character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>my-cluster2</code>
    /// </p>
    pub fn new_db_cluster_identifier(&self) -> std::option::Option<&str> {
        self.new_db_cluster_identifier.as_deref()
    }
    /// <p>A value that specifies whether the changes in this request and any pending changes are
    /// asynchronously applied as soon as possible, regardless of the
    /// <code>PreferredMaintenanceWindow</code> setting for the cluster. If this
    /// parameter is set to <code>false</code>, changes to the cluster are applied during the
    /// next maintenance window.</p>
    /// <p>The <code>ApplyImmediately</code> parameter affects only the
    /// <code>NewDBClusterIdentifier</code> and <code>MasterUserPassword</code> values. If
    /// you set this parameter value to <code>false</code>, the changes to the
    /// <code>NewDBClusterIdentifier</code> and <code>MasterUserPassword</code> values are
    /// applied during the next maintenance window. All other changes are applied immediately,
    /// regardless of the value of the <code>ApplyImmediately</code> parameter.</p>
    /// <p>Default: <code>false</code>
    /// </p>
    pub fn apply_immediately(&self) -> bool {
        self.apply_immediately
    }
    /// <p>The number of days for which automated backups are retained. You must specify a
    /// minimum value of 1.</p>
    /// <p>Default: 1</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be a value from 1 to 35.</p>
    /// </li>
    /// </ul>
    pub fn backup_retention_period(&self) -> std::option::Option<i32> {
        self.backup_retention_period
    }
    /// <p>The name of the cluster parameter group to use for the cluster.</p>
    pub fn db_cluster_parameter_group_name(&self) -> std::option::Option<&str> {
        self.db_cluster_parameter_group_name.as_deref()
    }
    /// <p>A list of virtual private cloud (VPC) security groups that the cluster will belong
    /// to.</p>
    pub fn vpc_security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.vpc_security_group_ids.as_deref()
    }
    /// <p>The port number on which the cluster accepts connections.</p>
    /// <p>Constraints: Must be a value from <code>1150</code> to <code>65535</code>. </p>
    /// <p>Default: The same port as the original cluster.</p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
    /// <p>The password for the master database user. This password can contain any printable
    /// ASCII character except forward slash (/), double quote ("), or the "at" symbol
    /// (@).</p>
    /// <p>Constraints: Must contain from 8 to 100 characters.</p>
    pub fn master_user_password(&self) -> std::option::Option<&str> {
        self.master_user_password.as_deref()
    }
    /// <p>The daily time range during which automated backups are created if automated backups
    /// are enabled, using the <code>BackupRetentionPeriod</code> parameter. </p>
    /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for
    /// each Region. </p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p>
    /// </li>
    /// <li>
    /// <p>Must be in Universal Coordinated Time (UTC).</p>
    /// </li>
    /// <li>
    /// <p>Must not conflict with the preferred maintenance window.</p>
    /// </li>
    /// <li>
    /// <p>Must be at least 30 minutes.</p>
    /// </li>
    /// </ul>
    pub fn preferred_backup_window(&self) -> std::option::Option<&str> {
        self.preferred_backup_window.as_deref()
    }
    /// <p>The weekly time range during which system maintenance can occur, in Universal
    /// Coordinated Time (UTC).</p>
    /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
    /// </p>
    /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for
    /// each Region, occurring on a random day of the week. </p>
    /// <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p>
    /// <p>Constraints: Minimum 30-minute window.</p>
    pub fn preferred_maintenance_window(&self) -> std::option::Option<&str> {
        self.preferred_maintenance_window.as_deref()
    }
    /// <p>The configuration setting for the log types to be enabled for export to Amazon
    /// CloudWatch Logs for a specific instance or cluster. The
    /// <code>EnableLogTypes</code> and <code>DisableLogTypes</code> arrays determine which
    /// logs are exported (or not exported) to CloudWatch Logs.</p>
    pub fn cloudwatch_logs_export_configuration(
        &self,
    ) -> std::option::Option<&crate::model::CloudwatchLogsExportConfiguration> {
        self.cloudwatch_logs_export_configuration.as_ref()
    }
    /// <p>The version number of the database engine to which you want to upgrade. Modifying engine version is not supported on Amazon DocumentDB.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is
    /// enabled, the cluster cannot be deleted unless it is modified and
    /// <code>DeletionProtection</code> is disabled. <code>DeletionProtection</code>
    /// protects clusters from being accidentally deleted.</p>
    pub fn deletion_protection(&self) -> std::option::Option<bool> {
        self.deletion_protection
    }
}
impl std::fmt::Debug for ModifyDbClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyDbClusterInput");
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field("new_db_cluster_identifier", &self.new_db_cluster_identifier);
        formatter.field("apply_immediately", &self.apply_immediately);
        formatter.field("backup_retention_period", &self.backup_retention_period);
        formatter.field(
            "db_cluster_parameter_group_name",
            &self.db_cluster_parameter_group_name,
        );
        formatter.field("vpc_security_group_ids", &self.vpc_security_group_ids);
        formatter.field("port", &self.port);
        formatter.field("master_user_password", &self.master_user_password);
        formatter.field("preferred_backup_window", &self.preferred_backup_window);
        formatter.field(
            "preferred_maintenance_window",
            &self.preferred_maintenance_window,
        );
        formatter.field(
            "cloudwatch_logs_export_configuration",
            &self.cloudwatch_logs_export_configuration,
        );
        formatter.field("engine_version", &self.engine_version);
        formatter.field("deletion_protection", &self.deletion_protection);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>ListTagsForResource</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon DocumentDB resource with tags to be listed. This value is an Amazon Resource Name
    /// (ARN).</p>
    pub resource_name: std::option::Option<std::string::String>,
    /// <p>This parameter is not currently supported.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon DocumentDB resource with tags to be listed. This value is an Amazon Resource Name
    /// (ARN).</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
    /// <p>This parameter is not currently supported.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_name", &self.resource_name);
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>FailoverDBCluster</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailoverDbClusterInput {
    /// <p>A cluster identifier to force a failover for. This parameter is not case sensitive.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must match the identifier of an existing <code>DBCluster</code>.</p>
    /// </li>
    /// </ul>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The name of the instance to promote to the primary instance.</p>
    /// <p>You must specify the instance identifier for an Amazon DocumentDB replica in the cluster. For
    /// example, <code>mydbcluster-replica1</code>.</p>
    pub target_db_instance_identifier: std::option::Option<std::string::String>,
}
impl FailoverDbClusterInput {
    /// <p>A cluster identifier to force a failover for. This parameter is not case sensitive.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must match the identifier of an existing <code>DBCluster</code>.</p>
    /// </li>
    /// </ul>
    pub fn db_cluster_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_identifier.as_deref()
    }
    /// <p>The name of the instance to promote to the primary instance.</p>
    /// <p>You must specify the instance identifier for an Amazon DocumentDB replica in the cluster. For
    /// example, <code>mydbcluster-replica1</code>.</p>
    pub fn target_db_instance_identifier(&self) -> std::option::Option<&str> {
        self.target_db_instance_identifier.as_deref()
    }
}
impl std::fmt::Debug for FailoverDbClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailoverDbClusterInput");
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field(
            "target_db_instance_identifier",
            &self.target_db_instance_identifier,
        );
        formatter.finish()
    }
}

/// <p>Represents the input to <a>DescribePendingMaintenanceActions</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePendingMaintenanceActionsInput {
    /// <p>The ARN of a resource to return pending maintenance actions for.</p>
    pub resource_identifier: std::option::Option<std::string::String>,
    /// <p>A filter that specifies one or more resources to return pending maintenance actions
    /// for.</p>
    /// <p>Supported filters:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>db-cluster-id</code> - Accepts cluster identifiers and cluster
    /// Amazon Resource Names (ARNs). The results list includes only pending maintenance
    /// actions for the clusters identified by these ARNs.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>db-instance-id</code> - Accepts instance identifiers and instance
    /// ARNs. The results list includes only pending maintenance actions for the DB
    /// instances identified by these ARNs.</p>
    /// </li>
    /// </ul>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
    /// includes only records beyond the marker, up to the value specified by
    /// <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
    /// in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
}
impl DescribePendingMaintenanceActionsInput {
    /// <p>The ARN of a resource to return pending maintenance actions for.</p>
    pub fn resource_identifier(&self) -> std::option::Option<&str> {
        self.resource_identifier.as_deref()
    }
    /// <p>A filter that specifies one or more resources to return pending maintenance actions
    /// for.</p>
    /// <p>Supported filters:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>db-cluster-id</code> - Accepts cluster identifiers and cluster
    /// Amazon Resource Names (ARNs). The results list includes only pending maintenance
    /// actions for the clusters identified by these ARNs.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>db-instance-id</code> - Accepts instance identifiers and instance
    /// ARNs. The results list includes only pending maintenance actions for the DB
    /// instances identified by these ARNs.</p>
    /// </li>
    /// </ul>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
    /// includes only records beyond the marker, up to the value specified by
    /// <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
    /// in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
}
impl std::fmt::Debug for DescribePendingMaintenanceActionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePendingMaintenanceActionsInput");
        formatter.field("resource_identifier", &self.resource_identifier);
        formatter.field("filters", &self.filters);
        formatter.field("marker", &self.marker);
        formatter.field("max_records", &self.max_records);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>DescribeOrderableDBInstanceOptions</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOrderableDbInstanceOptionsInput {
    /// <p>The name of the engine to retrieve instance options for.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The engine version filter value. Specify this parameter to show only the available
    /// offerings that match the specified engine version.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The instance class filter value. Specify this parameter to show only the available
    /// offerings that match the specified instance class.</p>
    pub db_instance_class: std::option::Option<std::string::String>,
    /// <p>The license model filter value. Specify this parameter to show only the available
    /// offerings that match the specified license model.</p>
    pub license_model: std::option::Option<std::string::String>,
    /// <p>The virtual private cloud (VPC) filter value. Specify this parameter to show only the
    /// available VPC or non-VPC offerings.</p>
    pub vpc: std::option::Option<bool>,
    /// <p>This parameter is not currently supported.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
    /// in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
    /// includes only records beyond the marker, up to the value specified by
    /// <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeOrderableDbInstanceOptionsInput {
    /// <p>The name of the engine to retrieve instance options for.</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The engine version filter value. Specify this parameter to show only the available
    /// offerings that match the specified engine version.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The instance class filter value. Specify this parameter to show only the available
    /// offerings that match the specified instance class.</p>
    pub fn db_instance_class(&self) -> std::option::Option<&str> {
        self.db_instance_class.as_deref()
    }
    /// <p>The license model filter value. Specify this parameter to show only the available
    /// offerings that match the specified license model.</p>
    pub fn license_model(&self) -> std::option::Option<&str> {
        self.license_model.as_deref()
    }
    /// <p>The virtual private cloud (VPC) filter value. Specify this parameter to show only the
    /// available VPC or non-VPC offerings.</p>
    pub fn vpc(&self) -> std::option::Option<bool> {
        self.vpc
    }
    /// <p>This parameter is not currently supported.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
    /// in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
    /// includes only records beyond the marker, up to the value specified by
    /// <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeOrderableDbInstanceOptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOrderableDbInstanceOptionsInput");
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("db_instance_class", &self.db_instance_class);
        formatter.field("license_model", &self.license_model);
        formatter.field("vpc", &self.vpc);
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGlobalClustersInput {
    /// <p>The user-supplied  cluster identifier. If this parameter is specified, information from only the specific cluster is returned. This parameter isn't case-sensitive.</p>
    pub global_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>A filter that specifies one or more global DB clusters to describe.</p>
    /// <p>Supported filters: <code>db-cluster-id</code> accepts  cluster identifiers and  cluster Amazon Resource Names (ARNs). The results list will only include information about the clusters identified by these ARNs.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results. </p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional pagination token provided by a previous <code>DescribeGlobalClusters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeGlobalClustersInput {
    /// <p>The user-supplied  cluster identifier. If this parameter is specified, information from only the specific cluster is returned. This parameter isn't case-sensitive.</p>
    pub fn global_cluster_identifier(&self) -> std::option::Option<&str> {
        self.global_cluster_identifier.as_deref()
    }
    /// <p>A filter that specifies one or more global DB clusters to describe.</p>
    /// <p>Supported filters: <code>db-cluster-id</code> accepts  cluster identifiers and  cluster Amazon Resource Names (ARNs). The results list will only include information about the clusters identified by these ARNs.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results. </p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>An optional pagination token provided by a previous <code>DescribeGlobalClusters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeGlobalClustersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGlobalClustersInput");
        formatter.field("global_cluster_identifier", &self.global_cluster_identifier);
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>DescribeEventSubscriptions</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventSubscriptionsInput {
    /// <p>The name of the Amazon DocumentDB event notification subscription that you want to
    /// describe.</p>
    pub subscription_name: std::option::Option<std::string::String>,
    /// <p>This parameter is not currently supported.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
    /// in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
    /// includes only records beyond the marker, up to the value specified by
    /// <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeEventSubscriptionsInput {
    /// <p>The name of the Amazon DocumentDB event notification subscription that you want to
    /// describe.</p>
    pub fn subscription_name(&self) -> std::option::Option<&str> {
        self.subscription_name.as_deref()
    }
    /// <p>This parameter is not currently supported.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
    /// in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
    /// includes only records beyond the marker, up to the value specified by
    /// <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeEventSubscriptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventSubscriptionsInput");
        formatter.field("subscription_name", &self.subscription_name);
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>DescribeEvents</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventsInput {
    /// <p>The identifier of the event source for which events are returned. If not specified, then all sources are included in the response.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If <code>SourceIdentifier</code> is provided, <code>SourceType</code> must also be provided.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is <code>DBInstance</code>, a
    /// <code>DBInstanceIdentifier</code> must be provided.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is <code>DBSecurityGroup</code>, a
    /// <code>DBSecurityGroupName</code> must be provided.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is <code>DBParameterGroup</code>, a
    /// <code>DBParameterGroupName</code> must be provided.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is <code>DBSnapshot</code>, a
    /// <code>DBSnapshotIdentifier</code> must be provided.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
    /// </li>
    /// </ul>
    pub source_identifier: std::option::Option<std::string::String>,
    /// <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
    pub source_type: std::option::Option<crate::model::SourceType>,
    /// <p> The beginning of the time interval to retrieve events for, specified in ISO 8601 format. </p>
    /// <p>Example: 2009-07-08T18:00Z</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p> The end of the time interval for which to retrieve events, specified in ISO 8601
    /// format. </p>
    /// <p>Example: 2009-07-08T18:00Z</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The number of minutes to retrieve events for.</p>
    /// <p>Default: 60</p>
    pub duration: std::option::Option<i32>,
    /// <p>A list of event categories that trigger notifications for an event notification
    /// subscription.</p>
    pub event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>This parameter is not currently supported.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
    /// in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
    /// includes only records beyond the marker, up to the value specified by
    /// <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeEventsInput {
    /// <p>The identifier of the event source for which events are returned. If not specified, then all sources are included in the response.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If <code>SourceIdentifier</code> is provided, <code>SourceType</code> must also be provided.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is <code>DBInstance</code>, a
    /// <code>DBInstanceIdentifier</code> must be provided.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is <code>DBSecurityGroup</code>, a
    /// <code>DBSecurityGroupName</code> must be provided.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is <code>DBParameterGroup</code>, a
    /// <code>DBParameterGroupName</code> must be provided.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is <code>DBSnapshot</code>, a
    /// <code>DBSnapshotIdentifier</code> must be provided.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
    /// </li>
    /// </ul>
    pub fn source_identifier(&self) -> std::option::Option<&str> {
        self.source_identifier.as_deref()
    }
    /// <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
    pub fn source_type(&self) -> std::option::Option<&crate::model::SourceType> {
        self.source_type.as_ref()
    }
    /// <p> The beginning of the time interval to retrieve events for, specified in ISO 8601 format. </p>
    /// <p>Example: 2009-07-08T18:00Z</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.start_time.as_ref()
    }
    /// <p> The end of the time interval for which to retrieve events, specified in ISO 8601
    /// format. </p>
    /// <p>Example: 2009-07-08T18:00Z</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
    /// <p>The number of minutes to retrieve events for.</p>
    /// <p>Default: 60</p>
    pub fn duration(&self) -> std::option::Option<i32> {
        self.duration
    }
    /// <p>A list of event categories that trigger notifications for an event notification
    /// subscription.</p>
    pub fn event_categories(&self) -> std::option::Option<&[std::string::String]> {
        self.event_categories.as_deref()
    }
    /// <p>This parameter is not currently supported.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
    /// in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
    /// includes only records beyond the marker, up to the value specified by
    /// <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeEventsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventsInput");
        formatter.field("source_identifier", &self.source_identifier);
        formatter.field("source_type", &self.source_type);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("duration", &self.duration);
        formatter.field("event_categories", &self.event_categories);
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>DescribeEventCategories</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventCategoriesInput {
    /// <p>The type of source that is generating the events.</p>
    /// <p>Valid values: <code>db-instance</code>, <code>db-parameter-group</code>, <code>db-security-group</code>
    /// </p>
    pub source_type: std::option::Option<std::string::String>,
    /// <p>This parameter is not currently supported.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
}
impl DescribeEventCategoriesInput {
    /// <p>The type of source that is generating the events.</p>
    /// <p>Valid values: <code>db-instance</code>, <code>db-parameter-group</code>, <code>db-security-group</code>
    /// </p>
    pub fn source_type(&self) -> std::option::Option<&str> {
        self.source_type.as_deref()
    }
    /// <p>This parameter is not currently supported.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
}
impl std::fmt::Debug for DescribeEventCategoriesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventCategoriesInput");
        formatter.field("source_type", &self.source_type);
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>DescribeEngineDefaultClusterParameters</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEngineDefaultClusterParametersInput {
    /// <p>The name of the cluster parameter group family to return the engine parameter
    /// information for.</p>
    pub db_parameter_group_family: std::option::Option<std::string::String>,
    /// <p>This parameter is not currently supported.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
    /// in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
    /// includes only records beyond the marker, up to the value specified by
    /// <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeEngineDefaultClusterParametersInput {
    /// <p>The name of the cluster parameter group family to return the engine parameter
    /// information for.</p>
    pub fn db_parameter_group_family(&self) -> std::option::Option<&str> {
        self.db_parameter_group_family.as_deref()
    }
    /// <p>This parameter is not currently supported.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
    /// in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
    /// includes only records beyond the marker, up to the value specified by
    /// <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeEngineDefaultClusterParametersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEngineDefaultClusterParametersInput");
        formatter.field("db_parameter_group_family", &self.db_parameter_group_family);
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>DescribeDBSubnetGroups</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbSubnetGroupsInput {
    /// <p>The name of the subnet group to return details for.</p>
    pub db_subnet_group_name: std::option::Option<std::string::String>,
    /// <p>This parameter is not currently supported.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
    /// in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
    /// includes only records beyond the marker, up to the value specified by
    /// <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeDbSubnetGroupsInput {
    /// <p>The name of the subnet group to return details for.</p>
    pub fn db_subnet_group_name(&self) -> std::option::Option<&str> {
        self.db_subnet_group_name.as_deref()
    }
    /// <p>This parameter is not currently supported.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
    /// in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
    /// includes only records beyond the marker, up to the value specified by
    /// <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbSubnetGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbSubnetGroupsInput");
        formatter.field("db_subnet_group_name", &self.db_subnet_group_name);
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>DescribeDBInstances</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbInstancesInput {
    /// <p>The user-provided instance identifier. If this parameter is specified, information from only the specific instance is returned. This parameter isn't case sensitive.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If provided, must match the identifier of an existing
    /// <code>DBInstance</code>.</p>
    /// </li>
    /// </ul>
    pub db_instance_identifier: std::option::Option<std::string::String>,
    /// <p>A filter that specifies one or more instances to describe.</p>
    /// <p>Supported filters:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>db-cluster-id</code> - Accepts cluster identifiers and cluster Amazon Resource Names (ARNs). The results list includes only the information about the instances that are associated with the clusters that are identified by these ARNs.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>db-instance-id</code> - Accepts instance identifiers and instance ARNs. The results list includes only the information about the instances that are identified by these ARNs.</p>
    /// </li>
    /// </ul>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
    /// in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
    /// includes only records beyond the marker, up to the value specified by
    /// <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeDbInstancesInput {
    /// <p>The user-provided instance identifier. If this parameter is specified, information from only the specific instance is returned. This parameter isn't case sensitive.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If provided, must match the identifier of an existing
    /// <code>DBInstance</code>.</p>
    /// </li>
    /// </ul>
    pub fn db_instance_identifier(&self) -> std::option::Option<&str> {
        self.db_instance_identifier.as_deref()
    }
    /// <p>A filter that specifies one or more instances to describe.</p>
    /// <p>Supported filters:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>db-cluster-id</code> - Accepts cluster identifiers and cluster Amazon Resource Names (ARNs). The results list includes only the information about the instances that are associated with the clusters that are identified by these ARNs.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>db-instance-id</code> - Accepts instance identifiers and instance ARNs. The results list includes only the information about the instances that are identified by these ARNs.</p>
    /// </li>
    /// </ul>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
    /// in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
    /// includes only records beyond the marker, up to the value specified by
    /// <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbInstancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbInstancesInput");
        formatter.field("db_instance_identifier", &self.db_instance_identifier);
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>DescribeDBEngineVersions</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbEngineVersionsInput {
    /// <p>The database engine to return.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The database engine version to return.</p>
    /// <p>Example: <code>3.6.0</code>
    /// </p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The name of a specific parameter group family to return details for.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If provided, must match an existing
    /// <code>DBParameterGroupFamily</code>.</p>
    /// </li>
    /// </ul>
    pub db_parameter_group_family: std::option::Option<std::string::String>,
    /// <p>This parameter is not currently supported.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
    /// in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
    /// includes only records beyond the marker, up to the value specified by
    /// <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Indicates that only the default version of the specified engine or engine and major
    /// version combination is returned.</p>
    pub default_only: bool,
    /// <p>If this parameter is specified and the requested engine supports the <code>CharacterSetName</code> parameter for <code>CreateDBInstance</code>, the response includes a list of supported character sets for each engine version. </p>
    pub list_supported_character_sets: std::option::Option<bool>,
    /// <p>If this parameter is specified and the requested engine supports the <code>TimeZone</code> parameter for <code>CreateDBInstance</code>, the response includes a list of supported time zones for each engine version. </p>
    pub list_supported_timezones: std::option::Option<bool>,
}
impl DescribeDbEngineVersionsInput {
    /// <p>The database engine to return.</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The database engine version to return.</p>
    /// <p>Example: <code>3.6.0</code>
    /// </p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The name of a specific parameter group family to return details for.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If provided, must match an existing
    /// <code>DBParameterGroupFamily</code>.</p>
    /// </li>
    /// </ul>
    pub fn db_parameter_group_family(&self) -> std::option::Option<&str> {
        self.db_parameter_group_family.as_deref()
    }
    /// <p>This parameter is not currently supported.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
    /// in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
    /// includes only records beyond the marker, up to the value specified by
    /// <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Indicates that only the default version of the specified engine or engine and major
    /// version combination is returned.</p>
    pub fn default_only(&self) -> bool {
        self.default_only
    }
    /// <p>If this parameter is specified and the requested engine supports the <code>CharacterSetName</code> parameter for <code>CreateDBInstance</code>, the response includes a list of supported character sets for each engine version. </p>
    pub fn list_supported_character_sets(&self) -> std::option::Option<bool> {
        self.list_supported_character_sets
    }
    /// <p>If this parameter is specified and the requested engine supports the <code>TimeZone</code> parameter for <code>CreateDBInstance</code>, the response includes a list of supported time zones for each engine version. </p>
    pub fn list_supported_timezones(&self) -> std::option::Option<bool> {
        self.list_supported_timezones
    }
}
impl std::fmt::Debug for DescribeDbEngineVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbEngineVersionsInput");
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("db_parameter_group_family", &self.db_parameter_group_family);
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.field("default_only", &self.default_only);
        formatter.field(
            "list_supported_character_sets",
            &self.list_supported_character_sets,
        );
        formatter.field("list_supported_timezones", &self.list_supported_timezones);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>DescribeDBClusterSnapshots</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbClusterSnapshotsInput {
    /// <p>The ID of the cluster to retrieve the list of cluster snapshots for. This parameter can't be used with the <code>DBClusterSnapshotIdentifier</code> parameter. This parameter is not case sensitive. </p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If provided, must match the identifier of an existing
    /// <code>DBCluster</code>.</p>
    /// </li>
    /// </ul>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>A specific cluster snapshot identifier to describe. This parameter can't be used with the <code>DBClusterIdentifier</code> parameter. This value is stored as a lowercase string. </p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If provided, must match the identifier of an existing
    /// <code>DBClusterSnapshot</code>.</p>
    /// </li>
    /// <li>
    /// <p>If this identifier is for an automated snapshot, the <code>SnapshotType</code>
    /// parameter must also be specified.</p>
    /// </li>
    /// </ul>
    pub db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
    /// <p>The type of cluster snapshots to be returned. You can specify one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>automated</code> - Return all cluster snapshots that Amazon DocumentDB has automatically created for your account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>manual</code> - Return all cluster snapshots that you have manually created for your account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>shared</code> - Return all manual cluster snapshots that have been shared to your account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>public</code> - Return all cluster snapshots that have been marked as public.</p>
    /// </li>
    /// </ul>
    /// <p>If you don't specify a <code>SnapshotType</code> value, then both automated and manual cluster snapshots are returned. You can include shared cluster snapshots with these results by setting the <code>IncludeShared</code> parameter to <code>true</code>. You can include public cluster snapshots with these results by setting the<code>IncludePublic</code> parameter to <code>true</code>.</p>
    /// <p>The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don't apply for <code>SnapshotType</code> values of <code>manual</code> or <code>automated</code>. The <code>IncludePublic</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>shared</code>. The <code>IncludeShared</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>public</code>.</p>
    pub snapshot_type: std::option::Option<std::string::String>,
    /// <p>This parameter is not currently supported.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
    /// in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
    /// includes only records beyond the marker, up to the value specified by
    /// <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Set to <code>true</code> to include shared manual cluster snapshots from other accounts that this account has been given permission to copy or restore, and otherwise <code>false</code>. The default is <code>false</code>.</p>
    pub include_shared: bool,
    /// <p>Set to <code>true</code> to include manual cluster snapshots that are public and can be copied or restored by any account, and otherwise <code>false</code>. The default is <code>false</code>.</p>
    pub include_public: bool,
}
impl DescribeDbClusterSnapshotsInput {
    /// <p>The ID of the cluster to retrieve the list of cluster snapshots for. This parameter can't be used with the <code>DBClusterSnapshotIdentifier</code> parameter. This parameter is not case sensitive. </p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If provided, must match the identifier of an existing
    /// <code>DBCluster</code>.</p>
    /// </li>
    /// </ul>
    pub fn db_cluster_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_identifier.as_deref()
    }
    /// <p>A specific cluster snapshot identifier to describe. This parameter can't be used with the <code>DBClusterIdentifier</code> parameter. This value is stored as a lowercase string. </p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If provided, must match the identifier of an existing
    /// <code>DBClusterSnapshot</code>.</p>
    /// </li>
    /// <li>
    /// <p>If this identifier is for an automated snapshot, the <code>SnapshotType</code>
    /// parameter must also be specified.</p>
    /// </li>
    /// </ul>
    pub fn db_cluster_snapshot_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_snapshot_identifier.as_deref()
    }
    /// <p>The type of cluster snapshots to be returned. You can specify one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>automated</code> - Return all cluster snapshots that Amazon DocumentDB has automatically created for your account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>manual</code> - Return all cluster snapshots that you have manually created for your account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>shared</code> - Return all manual cluster snapshots that have been shared to your account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>public</code> - Return all cluster snapshots that have been marked as public.</p>
    /// </li>
    /// </ul>
    /// <p>If you don't specify a <code>SnapshotType</code> value, then both automated and manual cluster snapshots are returned. You can include shared cluster snapshots with these results by setting the <code>IncludeShared</code> parameter to <code>true</code>. You can include public cluster snapshots with these results by setting the<code>IncludePublic</code> parameter to <code>true</code>.</p>
    /// <p>The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don't apply for <code>SnapshotType</code> values of <code>manual</code> or <code>automated</code>. The <code>IncludePublic</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>shared</code>. The <code>IncludeShared</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>public</code>.</p>
    pub fn snapshot_type(&self) -> std::option::Option<&str> {
        self.snapshot_type.as_deref()
    }
    /// <p>This parameter is not currently supported.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
    /// in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
    /// includes only records beyond the marker, up to the value specified by
    /// <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Set to <code>true</code> to include shared manual cluster snapshots from other accounts that this account has been given permission to copy or restore, and otherwise <code>false</code>. The default is <code>false</code>.</p>
    pub fn include_shared(&self) -> bool {
        self.include_shared
    }
    /// <p>Set to <code>true</code> to include manual cluster snapshots that are public and can be copied or restored by any account, and otherwise <code>false</code>. The default is <code>false</code>.</p>
    pub fn include_public(&self) -> bool {
        self.include_public
    }
}
impl std::fmt::Debug for DescribeDbClusterSnapshotsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbClusterSnapshotsInput");
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field(
            "db_cluster_snapshot_identifier",
            &self.db_cluster_snapshot_identifier,
        );
        formatter.field("snapshot_type", &self.snapshot_type);
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.field("include_shared", &self.include_shared);
        formatter.field("include_public", &self.include_public);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>DescribeDBClusterSnapshotAttributes</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbClusterSnapshotAttributesInput {
    /// <p>The identifier for the cluster snapshot to describe the attributes for.</p>
    pub db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
}
impl DescribeDbClusterSnapshotAttributesInput {
    /// <p>The identifier for the cluster snapshot to describe the attributes for.</p>
    pub fn db_cluster_snapshot_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_snapshot_identifier.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbClusterSnapshotAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbClusterSnapshotAttributesInput");
        formatter.field(
            "db_cluster_snapshot_identifier",
            &self.db_cluster_snapshot_identifier,
        );
        formatter.finish()
    }
}

/// <p>Represents the input to <a>DescribeDBClusters</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbClustersInput {
    /// <p>The user-provided cluster identifier. If this parameter is specified, information from only the specific cluster is returned. This parameter isn't case sensitive.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If provided, must match an existing <code>DBClusterIdentifier</code>.</p>
    /// </li>
    /// </ul>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>A filter that specifies one or more clusters to describe.</p>
    /// <p>Supported filters:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>db-cluster-id</code> - Accepts cluster identifiers and cluster Amazon Resource Names (ARNs). The results list only includes information about the clusters identified by these ARNs.</p>
    /// </li>
    /// </ul>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
    /// in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
    /// includes only records beyond the marker, up to the value specified by
    /// <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeDbClustersInput {
    /// <p>The user-provided cluster identifier. If this parameter is specified, information from only the specific cluster is returned. This parameter isn't case sensitive.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If provided, must match an existing <code>DBClusterIdentifier</code>.</p>
    /// </li>
    /// </ul>
    pub fn db_cluster_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_identifier.as_deref()
    }
    /// <p>A filter that specifies one or more clusters to describe.</p>
    /// <p>Supported filters:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>db-cluster-id</code> - Accepts cluster identifiers and cluster Amazon Resource Names (ARNs). The results list only includes information about the clusters identified by these ARNs.</p>
    /// </li>
    /// </ul>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
    /// in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
    /// includes only records beyond the marker, up to the value specified by
    /// <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbClustersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbClustersInput");
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>DescribeDBClusterParameters</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbClusterParametersInput {
    /// <p>The name of a specific cluster parameter group to return parameter details for.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If provided, must match the name of an existing <code>DBClusterParameterGroup</code>.</p>
    /// </li>
    /// </ul>
    pub db_cluster_parameter_group_name: std::option::Option<std::string::String>,
    /// <p> A value that indicates to return only parameters for a specific source. Parameter sources can be <code>engine</code>, <code>service</code>, or <code>customer</code>.
    /// </p>
    pub source: std::option::Option<std::string::String>,
    /// <p>This parameter is not currently supported.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
    /// in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
    /// includes only records beyond the marker, up to the value specified by
    /// <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeDbClusterParametersInput {
    /// <p>The name of a specific cluster parameter group to return parameter details for.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If provided, must match the name of an existing <code>DBClusterParameterGroup</code>.</p>
    /// </li>
    /// </ul>
    pub fn db_cluster_parameter_group_name(&self) -> std::option::Option<&str> {
        self.db_cluster_parameter_group_name.as_deref()
    }
    /// <p> A value that indicates to return only parameters for a specific source. Parameter sources can be <code>engine</code>, <code>service</code>, or <code>customer</code>.
    /// </p>
    pub fn source(&self) -> std::option::Option<&str> {
        self.source.as_deref()
    }
    /// <p>This parameter is not currently supported.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
    /// in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
    /// includes only records beyond the marker, up to the value specified by
    /// <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbClusterParametersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbClusterParametersInput");
        formatter.field(
            "db_cluster_parameter_group_name",
            &self.db_cluster_parameter_group_name,
        );
        formatter.field("source", &self.source);
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>DescribeDBClusterParameterGroups</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbClusterParameterGroupsInput {
    /// <p>The name of a specific cluster parameter group to return details for.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If provided, must match the name of an existing
    /// <code>DBClusterParameterGroup</code>.</p>
    /// </li>
    /// </ul>
    pub db_cluster_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>This parameter is not currently supported.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
    /// in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
    /// includes only records beyond the marker, up to the value specified by
    /// <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeDbClusterParameterGroupsInput {
    /// <p>The name of a specific cluster parameter group to return details for.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If provided, must match the name of an existing
    /// <code>DBClusterParameterGroup</code>.</p>
    /// </li>
    /// </ul>
    pub fn db_cluster_parameter_group_name(&self) -> std::option::Option<&str> {
        self.db_cluster_parameter_group_name.as_deref()
    }
    /// <p>This parameter is not currently supported.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
    /// in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
    /// includes only records beyond the marker, up to the value specified by
    /// <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbClusterParameterGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbClusterParameterGroupsInput");
        formatter.field(
            "db_cluster_parameter_group_name",
            &self.db_cluster_parameter_group_name,
        );
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCertificatesInput {
    /// <p>The user-supplied certificate identifier. If this parameter is specified, information for only the specified certificate is returned. If this parameter is omitted, a list of up to <code>MaxRecords</code> certificates is returned. This parameter is not case sensitive.</p>
    /// <p>Constraints</p>
    /// <ul>
    /// <li>
    /// <p>Must match an existing <code>CertificateIdentifier</code>.</p>
    /// </li>
    /// </ul>
    pub certificate_identifier: std::option::Option<std::string::String>,
    /// <p>This parameter is not currently supported.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Minimum: 20</p>
    /// </li>
    /// <li>
    /// <p>Maximum: 100</p>
    /// </li>
    /// </ul>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional pagination token provided by a previous <code>DescribeCertificates</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeCertificatesInput {
    /// <p>The user-supplied certificate identifier. If this parameter is specified, information for only the specified certificate is returned. If this parameter is omitted, a list of up to <code>MaxRecords</code> certificates is returned. This parameter is not case sensitive.</p>
    /// <p>Constraints</p>
    /// <ul>
    /// <li>
    /// <p>Must match an existing <code>CertificateIdentifier</code>.</p>
    /// </li>
    /// </ul>
    pub fn certificate_identifier(&self) -> std::option::Option<&str> {
        self.certificate_identifier.as_deref()
    }
    /// <p>This parameter is not currently supported.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Minimum: 20</p>
    /// </li>
    /// <li>
    /// <p>Maximum: 100</p>
    /// </li>
    /// </ul>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>An optional pagination token provided by a previous <code>DescribeCertificates</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeCertificatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCertificatesInput");
        formatter.field("certificate_identifier", &self.certificate_identifier);
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>DeleteGlobalCluster</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGlobalClusterInput {
    /// <p>The cluster identifier of the global cluster being deleted.</p>
    pub global_cluster_identifier: std::option::Option<std::string::String>,
}
impl DeleteGlobalClusterInput {
    /// <p>The cluster identifier of the global cluster being deleted.</p>
    pub fn global_cluster_identifier(&self) -> std::option::Option<&str> {
        self.global_cluster_identifier.as_deref()
    }
}
impl std::fmt::Debug for DeleteGlobalClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGlobalClusterInput");
        formatter.field("global_cluster_identifier", &self.global_cluster_identifier);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>DeleteEventSubscription</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEventSubscriptionInput {
    /// <p>The name of the Amazon DocumentDB event notification subscription that you want to delete.</p>
    pub subscription_name: std::option::Option<std::string::String>,
}
impl DeleteEventSubscriptionInput {
    /// <p>The name of the Amazon DocumentDB event notification subscription that you want to delete.</p>
    pub fn subscription_name(&self) -> std::option::Option<&str> {
        self.subscription_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteEventSubscriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEventSubscriptionInput");
        formatter.field("subscription_name", &self.subscription_name);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>DeleteDBSubnetGroup</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDbSubnetGroupInput {
    /// <p>The name of the database subnet group to delete.</p>
    /// <note>
    /// <p>You can't delete the default subnet group.</p>
    /// </note>
    /// <p>Constraints:</p>
    /// <p>Must match the name of an existing <code>DBSubnetGroup</code>. Must not be default.</p>
    /// <p>Example: <code>mySubnetgroup</code>
    /// </p>
    pub db_subnet_group_name: std::option::Option<std::string::String>,
}
impl DeleteDbSubnetGroupInput {
    /// <p>The name of the database subnet group to delete.</p>
    /// <note>
    /// <p>You can't delete the default subnet group.</p>
    /// </note>
    /// <p>Constraints:</p>
    /// <p>Must match the name of an existing <code>DBSubnetGroup</code>. Must not be default.</p>
    /// <p>Example: <code>mySubnetgroup</code>
    /// </p>
    pub fn db_subnet_group_name(&self) -> std::option::Option<&str> {
        self.db_subnet_group_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteDbSubnetGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDbSubnetGroupInput");
        formatter.field("db_subnet_group_name", &self.db_subnet_group_name);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>DeleteDBInstance</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDbInstanceInput {
    /// <p>The instance identifier for the instance to be deleted. This parameter isn't
    /// case sensitive.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must match the name of an existing instance.</p>
    /// </li>
    /// </ul>
    pub db_instance_identifier: std::option::Option<std::string::String>,
}
impl DeleteDbInstanceInput {
    /// <p>The instance identifier for the instance to be deleted. This parameter isn't
    /// case sensitive.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must match the name of an existing instance.</p>
    /// </li>
    /// </ul>
    pub fn db_instance_identifier(&self) -> std::option::Option<&str> {
        self.db_instance_identifier.as_deref()
    }
}
impl std::fmt::Debug for DeleteDbInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDbInstanceInput");
        formatter.field("db_instance_identifier", &self.db_instance_identifier);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>DeleteDBClusterSnapshot</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDbClusterSnapshotInput {
    /// <p>The identifier of the cluster snapshot to delete.</p>
    /// <p>Constraints: Must be the name of an existing cluster snapshot in the <code>available</code> state.</p>
    pub db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
}
impl DeleteDbClusterSnapshotInput {
    /// <p>The identifier of the cluster snapshot to delete.</p>
    /// <p>Constraints: Must be the name of an existing cluster snapshot in the <code>available</code> state.</p>
    pub fn db_cluster_snapshot_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_snapshot_identifier.as_deref()
    }
}
impl std::fmt::Debug for DeleteDbClusterSnapshotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDbClusterSnapshotInput");
        formatter.field(
            "db_cluster_snapshot_identifier",
            &self.db_cluster_snapshot_identifier,
        );
        formatter.finish()
    }
}

/// <p>Represents the input to <a>DeleteDBClusterParameterGroup</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDbClusterParameterGroupInput {
    /// <p>The name of the cluster parameter group.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be the name of an existing cluster parameter group.</p>
    /// </li>
    /// <li>
    /// <p>You can't delete a default cluster parameter group.</p>
    /// </li>
    /// <li>
    /// <p>Cannot be associated with any clusters.</p>
    /// </li>
    /// </ul>
    pub db_cluster_parameter_group_name: std::option::Option<std::string::String>,
}
impl DeleteDbClusterParameterGroupInput {
    /// <p>The name of the cluster parameter group.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be the name of an existing cluster parameter group.</p>
    /// </li>
    /// <li>
    /// <p>You can't delete a default cluster parameter group.</p>
    /// </li>
    /// <li>
    /// <p>Cannot be associated with any clusters.</p>
    /// </li>
    /// </ul>
    pub fn db_cluster_parameter_group_name(&self) -> std::option::Option<&str> {
        self.db_cluster_parameter_group_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteDbClusterParameterGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDbClusterParameterGroupInput");
        formatter.field(
            "db_cluster_parameter_group_name",
            &self.db_cluster_parameter_group_name,
        );
        formatter.finish()
    }
}

/// <p>Represents the input to <a>DeleteDBCluster</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDbClusterInput {
    /// <p>The cluster identifier for the cluster to be deleted. This parameter isn't case sensitive.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must match an existing <code>DBClusterIdentifier</code>.</p>
    /// </li>
    /// </ul>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p> Determines whether a final cluster snapshot is created before the cluster is deleted. If <code>true</code> is specified, no cluster snapshot is created. If <code>false</code> is specified, a cluster snapshot is created before the DB cluster is deleted. </p>
    /// <note>
    /// <p>If <code>SkipFinalSnapshot</code> is <code>false</code>, you must specify a <code>FinalDBSnapshotIdentifier</code> parameter.</p>
    /// </note>
    /// <p>Default: <code>false</code>
    /// </p>
    pub skip_final_snapshot: bool,
    /// <p> The cluster snapshot identifier of the new cluster snapshot created when <code>SkipFinalSnapshot</code> is set to <code>false</code>. </p>
    /// <note>
    /// <p> Specifying this parameter and also setting the <code>SkipFinalShapshot</code> parameter to <code>true</code> results in an error. </p>
    /// </note>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be from 1 to 255 letters, numbers, or hyphens.</p>
    /// </li>
    /// <li>
    /// <p>The first character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
    /// </li>
    /// </ul>
    pub final_db_snapshot_identifier: std::option::Option<std::string::String>,
}
impl DeleteDbClusterInput {
    /// <p>The cluster identifier for the cluster to be deleted. This parameter isn't case sensitive.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must match an existing <code>DBClusterIdentifier</code>.</p>
    /// </li>
    /// </ul>
    pub fn db_cluster_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_identifier.as_deref()
    }
    /// <p> Determines whether a final cluster snapshot is created before the cluster is deleted. If <code>true</code> is specified, no cluster snapshot is created. If <code>false</code> is specified, a cluster snapshot is created before the DB cluster is deleted. </p>
    /// <note>
    /// <p>If <code>SkipFinalSnapshot</code> is <code>false</code>, you must specify a <code>FinalDBSnapshotIdentifier</code> parameter.</p>
    /// </note>
    /// <p>Default: <code>false</code>
    /// </p>
    pub fn skip_final_snapshot(&self) -> bool {
        self.skip_final_snapshot
    }
    /// <p> The cluster snapshot identifier of the new cluster snapshot created when <code>SkipFinalSnapshot</code> is set to <code>false</code>. </p>
    /// <note>
    /// <p> Specifying this parameter and also setting the <code>SkipFinalShapshot</code> parameter to <code>true</code> results in an error. </p>
    /// </note>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be from 1 to 255 letters, numbers, or hyphens.</p>
    /// </li>
    /// <li>
    /// <p>The first character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
    /// </li>
    /// </ul>
    pub fn final_db_snapshot_identifier(&self) -> std::option::Option<&str> {
        self.final_db_snapshot_identifier.as_deref()
    }
}
impl std::fmt::Debug for DeleteDbClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDbClusterInput");
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field("skip_final_snapshot", &self.skip_final_snapshot);
        formatter.field(
            "final_db_snapshot_identifier",
            &self.final_db_snapshot_identifier,
        );
        formatter.finish()
    }
}

/// <p>Represents the input to <a>CreateGlobalCluster</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGlobalClusterInput {
    /// <p>The cluster identifier of the new global cluster.</p>
    pub global_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) to use as the primary cluster of the global cluster. This parameter is optional.</p>
    pub source_db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The name of the database engine to be used for this cluster.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The engine version of the global cluster.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The deletion protection setting for the new global cluster. The global cluster can't be deleted when deletion protection is enabled. </p>
    pub deletion_protection: std::option::Option<bool>,
    /// <p>The name for your database of up to 64 alpha-numeric characters. If you do not provide a name, Amazon DocumentDB will not create a database in the global cluster you are creating.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>The storage encryption setting for the new global cluster. </p>
    pub storage_encrypted: std::option::Option<bool>,
}
impl CreateGlobalClusterInput {
    /// <p>The cluster identifier of the new global cluster.</p>
    pub fn global_cluster_identifier(&self) -> std::option::Option<&str> {
        self.global_cluster_identifier.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) to use as the primary cluster of the global cluster. This parameter is optional.</p>
    pub fn source_db_cluster_identifier(&self) -> std::option::Option<&str> {
        self.source_db_cluster_identifier.as_deref()
    }
    /// <p>The name of the database engine to be used for this cluster.</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The engine version of the global cluster.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The deletion protection setting for the new global cluster. The global cluster can't be deleted when deletion protection is enabled. </p>
    pub fn deletion_protection(&self) -> std::option::Option<bool> {
        self.deletion_protection
    }
    /// <p>The name for your database of up to 64 alpha-numeric characters. If you do not provide a name, Amazon DocumentDB will not create a database in the global cluster you are creating.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>The storage encryption setting for the new global cluster. </p>
    pub fn storage_encrypted(&self) -> std::option::Option<bool> {
        self.storage_encrypted
    }
}
impl std::fmt::Debug for CreateGlobalClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGlobalClusterInput");
        formatter.field("global_cluster_identifier", &self.global_cluster_identifier);
        formatter.field(
            "source_db_cluster_identifier",
            &self.source_db_cluster_identifier,
        );
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("deletion_protection", &self.deletion_protection);
        formatter.field("database_name", &self.database_name);
        formatter.field("storage_encrypted", &self.storage_encrypted);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>CreateEventSubscription</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEventSubscriptionInput {
    /// <p>The name of the subscription.</p>
    /// <p>Constraints: The name must be fewer than 255 characters.</p>
    pub subscription_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. Amazon SNS creates the ARN when you create a topic and subscribe to it.</p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>The type of source that is generating the events. For example, if you want to be notified of events generated by an instance, you would set this parameter to <code>db-instance</code>. If this value is not specified, all events are returned.</p>
    /// <p>Valid values: <code>db-instance</code>, <code>db-cluster</code>,
    /// <code>db-parameter-group</code>, <code>db-security-group</code>,
    /// <code>db-cluster-snapshot</code>
    /// </p>
    pub source_type: std::option::Option<std::string::String>,
    /// <p> A list of event categories for a <code>SourceType</code> that you want to subscribe to. </p>
    pub event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The list of identifiers of the event sources for which events are returned. If not specified, then all sources are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a
    /// hyphen or contain two consecutive hyphens.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If <code>SourceIds</code> are provided, <code>SourceType</code> must also be
    /// provided.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is an instance, a <code>DBInstanceIdentifier</code> must
    /// be provided.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is a security group, a <code>DBSecurityGroupName</code>
    /// must be provided.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is a parameter group, a
    /// <code>DBParameterGroupName</code> must be provided.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is a snapshot, a <code>DBSnapshotIdentifier</code> must
    /// be provided.</p>
    /// </li>
    /// </ul>
    pub source_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> A Boolean value; set to <code>true</code> to activate the subscription, set to <code>false</code> to create the subscription but not active it. </p>
    pub enabled: std::option::Option<bool>,
    /// <p>The tags to be assigned to the event subscription.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateEventSubscriptionInput {
    /// <p>The name of the subscription.</p>
    /// <p>Constraints: The name must be fewer than 255 characters.</p>
    pub fn subscription_name(&self) -> std::option::Option<&str> {
        self.subscription_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. Amazon SNS creates the ARN when you create a topic and subscribe to it.</p>
    pub fn sns_topic_arn(&self) -> std::option::Option<&str> {
        self.sns_topic_arn.as_deref()
    }
    /// <p>The type of source that is generating the events. For example, if you want to be notified of events generated by an instance, you would set this parameter to <code>db-instance</code>. If this value is not specified, all events are returned.</p>
    /// <p>Valid values: <code>db-instance</code>, <code>db-cluster</code>,
    /// <code>db-parameter-group</code>, <code>db-security-group</code>,
    /// <code>db-cluster-snapshot</code>
    /// </p>
    pub fn source_type(&self) -> std::option::Option<&str> {
        self.source_type.as_deref()
    }
    /// <p> A list of event categories for a <code>SourceType</code> that you want to subscribe to. </p>
    pub fn event_categories(&self) -> std::option::Option<&[std::string::String]> {
        self.event_categories.as_deref()
    }
    /// <p>The list of identifiers of the event sources for which events are returned. If not specified, then all sources are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a
    /// hyphen or contain two consecutive hyphens.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>If <code>SourceIds</code> are provided, <code>SourceType</code> must also be
    /// provided.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is an instance, a <code>DBInstanceIdentifier</code> must
    /// be provided.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is a security group, a <code>DBSecurityGroupName</code>
    /// must be provided.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is a parameter group, a
    /// <code>DBParameterGroupName</code> must be provided.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is a snapshot, a <code>DBSnapshotIdentifier</code> must
    /// be provided.</p>
    /// </li>
    /// </ul>
    pub fn source_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.source_ids.as_deref()
    }
    /// <p> A Boolean value; set to <code>true</code> to activate the subscription, set to <code>false</code> to create the subscription but not active it. </p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>The tags to be assigned to the event subscription.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateEventSubscriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEventSubscriptionInput");
        formatter.field("subscription_name", &self.subscription_name);
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.field("source_type", &self.source_type);
        formatter.field("event_categories", &self.event_categories);
        formatter.field("source_ids", &self.source_ids);
        formatter.field("enabled", &self.enabled);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>CreateDBSubnetGroup</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDbSubnetGroupInput {
    /// <p>The name for the subnet group. This value is stored as a lowercase string.</p>
    /// <p>Constraints: Must contain no more than 255 letters, numbers, periods, underscores,
    /// spaces, or hyphens. Must not be default.</p>
    /// <p>Example: <code>mySubnetgroup</code>
    /// </p>
    pub db_subnet_group_name: std::option::Option<std::string::String>,
    /// <p>The description for the subnet group.</p>
    pub db_subnet_group_description: std::option::Option<std::string::String>,
    /// <p>The Amazon EC2 subnet IDs for the subnet group.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The tags to be assigned to the subnet group.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateDbSubnetGroupInput {
    /// <p>The name for the subnet group. This value is stored as a lowercase string.</p>
    /// <p>Constraints: Must contain no more than 255 letters, numbers, periods, underscores,
    /// spaces, or hyphens. Must not be default.</p>
    /// <p>Example: <code>mySubnetgroup</code>
    /// </p>
    pub fn db_subnet_group_name(&self) -> std::option::Option<&str> {
        self.db_subnet_group_name.as_deref()
    }
    /// <p>The description for the subnet group.</p>
    pub fn db_subnet_group_description(&self) -> std::option::Option<&str> {
        self.db_subnet_group_description.as_deref()
    }
    /// <p>The Amazon EC2 subnet IDs for the subnet group.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>The tags to be assigned to the subnet group.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateDbSubnetGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDbSubnetGroupInput");
        formatter.field("db_subnet_group_name", &self.db_subnet_group_name);
        formatter.field(
            "db_subnet_group_description",
            &self.db_subnet_group_description,
        );
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>CreateDBInstance</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDbInstanceInput {
    /// <p>The instance identifier. This parameter is stored as a lowercase string.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
    /// </li>
    /// <li>
    /// <p>The first character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>mydbinstance</code>
    /// </p>
    pub db_instance_identifier: std::option::Option<std::string::String>,
    /// <p>The compute and memory capacity of the instance; for example,
    /// <code>db.r5.large</code>. </p>
    pub db_instance_class: std::option::Option<std::string::String>,
    /// <p>The name of the database engine to be used for this instance.</p>
    /// <p>Valid value: <code>docdb</code>
    /// </p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The Amazon EC2 Availability Zone that the instance is created in. </p>
    /// <p>Default: A random, system-chosen Availability Zone in the endpoint's Region.</p>
    /// <p>Example: <code>us-east-1d</code>
    /// </p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The time range each week during which system maintenance can occur, in Universal
    /// Coordinated Time (UTC).</p>
    /// <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
    /// </p>
    /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for
    /// each Region, occurring on a random day of the week. </p>
    /// <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p>
    /// <p>Constraints: Minimum 30-minute window.</p>
    pub preferred_maintenance_window: std::option::Option<std::string::String>,
    /// <p>This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.</p>
    /// <p>Default: <code>false</code>
    /// </p>
    pub auto_minor_version_upgrade: std::option::Option<bool>,
    /// <p>The tags to be assigned to the instance. You can assign up to
    /// 10 tags to an instance.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The identifier of the cluster that the instance will belong to.</p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>A value that specifies the order in which an Amazon DocumentDB replica is promoted to the
    /// primary instance after a failure of the existing primary instance.</p>
    /// <p>Default: 1</p>
    /// <p>Valid values: 0-15</p>
    pub promotion_tier: std::option::Option<i32>,
}
impl CreateDbInstanceInput {
    /// <p>The instance identifier. This parameter is stored as a lowercase string.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
    /// </li>
    /// <li>
    /// <p>The first character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>mydbinstance</code>
    /// </p>
    pub fn db_instance_identifier(&self) -> std::option::Option<&str> {
        self.db_instance_identifier.as_deref()
    }
    /// <p>The compute and memory capacity of the instance; for example,
    /// <code>db.r5.large</code>. </p>
    pub fn db_instance_class(&self) -> std::option::Option<&str> {
        self.db_instance_class.as_deref()
    }
    /// <p>The name of the database engine to be used for this instance.</p>
    /// <p>Valid value: <code>docdb</code>
    /// </p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The Amazon EC2 Availability Zone that the instance is created in. </p>
    /// <p>Default: A random, system-chosen Availability Zone in the endpoint's Region.</p>
    /// <p>Example: <code>us-east-1d</code>
    /// </p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>The time range each week during which system maintenance can occur, in Universal
    /// Coordinated Time (UTC).</p>
    /// <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
    /// </p>
    /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for
    /// each Region, occurring on a random day of the week. </p>
    /// <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p>
    /// <p>Constraints: Minimum 30-minute window.</p>
    pub fn preferred_maintenance_window(&self) -> std::option::Option<&str> {
        self.preferred_maintenance_window.as_deref()
    }
    /// <p>This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.</p>
    /// <p>Default: <code>false</code>
    /// </p>
    pub fn auto_minor_version_upgrade(&self) -> std::option::Option<bool> {
        self.auto_minor_version_upgrade
    }
    /// <p>The tags to be assigned to the instance. You can assign up to
    /// 10 tags to an instance.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The identifier of the cluster that the instance will belong to.</p>
    pub fn db_cluster_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_identifier.as_deref()
    }
    /// <p>A value that specifies the order in which an Amazon DocumentDB replica is promoted to the
    /// primary instance after a failure of the existing primary instance.</p>
    /// <p>Default: 1</p>
    /// <p>Valid values: 0-15</p>
    pub fn promotion_tier(&self) -> std::option::Option<i32> {
        self.promotion_tier
    }
}
impl std::fmt::Debug for CreateDbInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDbInstanceInput");
        formatter.field("db_instance_identifier", &self.db_instance_identifier);
        formatter.field("db_instance_class", &self.db_instance_class);
        formatter.field("engine", &self.engine);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field(
            "preferred_maintenance_window",
            &self.preferred_maintenance_window,
        );
        formatter.field(
            "auto_minor_version_upgrade",
            &self.auto_minor_version_upgrade,
        );
        formatter.field("tags", &self.tags);
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field("promotion_tier", &self.promotion_tier);
        formatter.finish()
    }
}

/// <p>Represents the input of <a>CreateDBClusterSnapshot</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDbClusterSnapshotInput {
    /// <p>The identifier of the cluster snapshot. This parameter is stored
    /// as a lowercase string.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
    /// </li>
    /// <li>
    /// <p>The first character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.
    /// </p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>my-cluster-snapshot1</code>
    /// </p>
    pub db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
    /// <p>The identifier of the cluster to create a snapshot for. This
    /// parameter is not case sensitive.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must match the identifier of an existing
    /// <code>DBCluster</code>.</p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>my-cluster</code>
    /// </p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The tags to be assigned to the cluster snapshot.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateDbClusterSnapshotInput {
    /// <p>The identifier of the cluster snapshot. This parameter is stored
    /// as a lowercase string.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
    /// </li>
    /// <li>
    /// <p>The first character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.
    /// </p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>my-cluster-snapshot1</code>
    /// </p>
    pub fn db_cluster_snapshot_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_snapshot_identifier.as_deref()
    }
    /// <p>The identifier of the cluster to create a snapshot for. This
    /// parameter is not case sensitive.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must match the identifier of an existing
    /// <code>DBCluster</code>.</p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>my-cluster</code>
    /// </p>
    pub fn db_cluster_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_identifier.as_deref()
    }
    /// <p>The tags to be assigned to the cluster snapshot.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateDbClusterSnapshotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDbClusterSnapshotInput");
        formatter.field(
            "db_cluster_snapshot_identifier",
            &self.db_cluster_snapshot_identifier,
        );
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Represents the input of <a>CreateDBClusterParameterGroup</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDbClusterParameterGroupInput {
    /// <p>The name of the cluster parameter group.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must not match the name of an existing
    /// <code>DBClusterParameterGroup</code>.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>This value is stored as a lowercase string.</p>
    /// </note>
    pub db_cluster_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>The cluster parameter group family name.</p>
    pub db_parameter_group_family: std::option::Option<std::string::String>,
    /// <p>The description for the cluster parameter group.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The tags to be assigned to the cluster parameter group.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateDbClusterParameterGroupInput {
    /// <p>The name of the cluster parameter group.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must not match the name of an existing
    /// <code>DBClusterParameterGroup</code>.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>This value is stored as a lowercase string.</p>
    /// </note>
    pub fn db_cluster_parameter_group_name(&self) -> std::option::Option<&str> {
        self.db_cluster_parameter_group_name.as_deref()
    }
    /// <p>The cluster parameter group family name.</p>
    pub fn db_parameter_group_family(&self) -> std::option::Option<&str> {
        self.db_parameter_group_family.as_deref()
    }
    /// <p>The description for the cluster parameter group.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The tags to be assigned to the cluster parameter group.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateDbClusterParameterGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDbClusterParameterGroupInput");
        formatter.field(
            "db_cluster_parameter_group_name",
            &self.db_cluster_parameter_group_name,
        );
        formatter.field("db_parameter_group_family", &self.db_parameter_group_family);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>CreateDBCluster</a>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDbClusterInput {
    /// <p>A list of Amazon EC2 Availability Zones that instances in the
    /// cluster can be created in.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The number of days for which automated backups are retained. You
    /// must specify a minimum value of 1.</p>
    /// <p>Default: 1</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be a value from 1 to 35.</p>
    /// </li>
    /// </ul>
    pub backup_retention_period: std::option::Option<i32>,
    /// <p>The cluster identifier. This parameter is stored as a lowercase
    /// string.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.
    /// </p>
    /// </li>
    /// <li>
    /// <p>The first character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.
    /// </p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>my-cluster</code>
    /// </p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The name of the cluster parameter group to associate with this
    /// cluster.</p>
    pub db_cluster_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>A list of EC2 VPC security groups to associate with this cluster.
    /// </p>
    pub vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A subnet group to associate with this cluster.</p>
    /// <p>Constraints: Must match the name of an existing
    /// <code>DBSubnetGroup</code>. Must not be default.</p>
    /// <p>Example: <code>mySubnetgroup</code>
    /// </p>
    pub db_subnet_group_name: std::option::Option<std::string::String>,
    /// <p>The name of the database engine to be used for this cluster.</p>
    /// <p>Valid values: <code>docdb</code>
    /// </p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The version number of the database engine to use. The <code>--engine-version</code> will default to the latest major engine version. For production workloads, we recommend explicitly declaring this parameter with the intended major engine version.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The port number on which the instances in the cluster accept
    /// connections.</p>
    pub port: std::option::Option<i32>,
    /// <p>The name of the master user for the cluster.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be from 1 to 63 letters or numbers.</p>
    /// </li>
    /// <li>
    /// <p>The first character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot be a reserved word for the chosen database engine.
    /// </p>
    /// </li>
    /// </ul>
    pub master_username: std::option::Option<std::string::String>,
    /// <p>The password for the master database user. This password can
    /// contain any printable ASCII character except forward slash (/),
    /// double quote ("), or the "at" symbol (@).</p>
    /// <p>Constraints: Must contain from 8 to 100 characters.</p>
    pub master_user_password: std::option::Option<std::string::String>,
    /// <p>The daily time range during which automated backups are created if
    /// automated backups are enabled using the <code>BackupRetentionPeriod</code> parameter. </p>
    /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Region. </p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p>
    /// </li>
    /// <li>
    /// <p>Must be in Universal Coordinated Time (UTC).</p>
    /// </li>
    /// <li>
    /// <p>Must not conflict with the preferred maintenance window.
    /// </p>
    /// </li>
    /// <li>
    /// <p>Must be at least 30 minutes.</p>
    /// </li>
    /// </ul>
    pub preferred_backup_window: std::option::Option<std::string::String>,
    /// <p>The weekly time range during which system maintenance can occur,
    /// in Universal Coordinated Time (UTC).</p>
    /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
    /// </p>
    /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Region, occurring on a random day of the week.</p>
    /// <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p>
    /// <p>Constraints: Minimum 30-minute window.</p>
    pub preferred_maintenance_window: std::option::Option<std::string::String>,
    /// <p>The tags to be assigned to the cluster.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Specifies whether the cluster is encrypted.</p>
    pub storage_encrypted: std::option::Option<bool>,
    /// <p>The KMS key identifier for an encrypted cluster.</p>
    /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a cluster using the same account that owns the KMS encryption key that is used to encrypt the new cluster, you can use the KMS key alias instead of the ARN for the KMS encryption key.</p>
    /// <p>If an encryption key is not specified in <code>KmsKeyId</code>:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>If the <code>StorageEncrypted</code> parameter is
    /// <code>true</code>, Amazon DocumentDB uses your default encryption key.
    /// </p>
    /// </li>
    /// </ul>
    /// <p>KMS creates the default encryption key for your account. Your account has a different default encryption key for each Regions.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>Not currently supported.
    /// </p>
    pub pre_signed_url: std::option::Option<std::string::String>,
    /// <p>A list of log types that need to be enabled for exporting to Amazon
    /// CloudWatch Logs. You can enable audit logs or profiler logs. For more
    /// information, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/event-auditing.html">
    /// Auditing Amazon DocumentDB Events</a>
    /// and <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/profiling.html">
    /// Profiling Amazon DocumentDB Operations</a>.
    /// </p>
    pub enable_cloudwatch_logs_exports: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies whether this cluster can be deleted. If
    /// <code>DeletionProtection</code> is enabled, the cluster cannot be
    /// deleted unless it is modified and <code>DeletionProtection</code> is
    /// disabled. <code>DeletionProtection</code> protects clusters from
    /// being accidentally deleted.</p>
    pub deletion_protection: std::option::Option<bool>,
    /// <p>The cluster identifier of the new global cluster.</p>
    pub global_cluster_identifier: std::option::Option<std::string::String>,
}
impl CreateDbClusterInput {
    /// <p>A list of Amazon EC2 Availability Zones that instances in the
    /// cluster can be created in.</p>
    pub fn availability_zones(&self) -> std::option::Option<&[std::string::String]> {
        self.availability_zones.as_deref()
    }
    /// <p>The number of days for which automated backups are retained. You
    /// must specify a minimum value of 1.</p>
    /// <p>Default: 1</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be a value from 1 to 35.</p>
    /// </li>
    /// </ul>
    pub fn backup_retention_period(&self) -> std::option::Option<i32> {
        self.backup_retention_period
    }
    /// <p>The cluster identifier. This parameter is stored as a lowercase
    /// string.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.
    /// </p>
    /// </li>
    /// <li>
    /// <p>The first character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.
    /// </p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>my-cluster</code>
    /// </p>
    pub fn db_cluster_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_identifier.as_deref()
    }
    /// <p>The name of the cluster parameter group to associate with this
    /// cluster.</p>
    pub fn db_cluster_parameter_group_name(&self) -> std::option::Option<&str> {
        self.db_cluster_parameter_group_name.as_deref()
    }
    /// <p>A list of EC2 VPC security groups to associate with this cluster.
    /// </p>
    pub fn vpc_security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.vpc_security_group_ids.as_deref()
    }
    /// <p>A subnet group to associate with this cluster.</p>
    /// <p>Constraints: Must match the name of an existing
    /// <code>DBSubnetGroup</code>. Must not be default.</p>
    /// <p>Example: <code>mySubnetgroup</code>
    /// </p>
    pub fn db_subnet_group_name(&self) -> std::option::Option<&str> {
        self.db_subnet_group_name.as_deref()
    }
    /// <p>The name of the database engine to be used for this cluster.</p>
    /// <p>Valid values: <code>docdb</code>
    /// </p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The version number of the database engine to use. The <code>--engine-version</code> will default to the latest major engine version. For production workloads, we recommend explicitly declaring this parameter with the intended major engine version.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The port number on which the instances in the cluster accept
    /// connections.</p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
    /// <p>The name of the master user for the cluster.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be from 1 to 63 letters or numbers.</p>
    /// </li>
    /// <li>
    /// <p>The first character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot be a reserved word for the chosen database engine.
    /// </p>
    /// </li>
    /// </ul>
    pub fn master_username(&self) -> std::option::Option<&str> {
        self.master_username.as_deref()
    }
    /// <p>The password for the master database user. This password can
    /// contain any printable ASCII character except forward slash (/),
    /// double quote ("), or the "at" symbol (@).</p>
    /// <p>Constraints: Must contain from 8 to 100 characters.</p>
    pub fn master_user_password(&self) -> std::option::Option<&str> {
        self.master_user_password.as_deref()
    }
    /// <p>The daily time range during which automated backups are created if
    /// automated backups are enabled using the <code>BackupRetentionPeriod</code> parameter. </p>
    /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Region. </p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p>
    /// </li>
    /// <li>
    /// <p>Must be in Universal Coordinated Time (UTC).</p>
    /// </li>
    /// <li>
    /// <p>Must not conflict with the preferred maintenance window.
    /// </p>
    /// </li>
    /// <li>
    /// <p>Must be at least 30 minutes.</p>
    /// </li>
    /// </ul>
    pub fn preferred_backup_window(&self) -> std::option::Option<&str> {
        self.preferred_backup_window.as_deref()
    }
    /// <p>The weekly time range during which system maintenance can occur,
    /// in Universal Coordinated Time (UTC).</p>
    /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
    /// </p>
    /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Region, occurring on a random day of the week.</p>
    /// <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p>
    /// <p>Constraints: Minimum 30-minute window.</p>
    pub fn preferred_maintenance_window(&self) -> std::option::Option<&str> {
        self.preferred_maintenance_window.as_deref()
    }
    /// <p>The tags to be assigned to the cluster.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>Specifies whether the cluster is encrypted.</p>
    pub fn storage_encrypted(&self) -> std::option::Option<bool> {
        self.storage_encrypted
    }
    /// <p>The KMS key identifier for an encrypted cluster.</p>
    /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a cluster using the same account that owns the KMS encryption key that is used to encrypt the new cluster, you can use the KMS key alias instead of the ARN for the KMS encryption key.</p>
    /// <p>If an encryption key is not specified in <code>KmsKeyId</code>:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>If the <code>StorageEncrypted</code> parameter is
    /// <code>true</code>, Amazon DocumentDB uses your default encryption key.
    /// </p>
    /// </li>
    /// </ul>
    /// <p>KMS creates the default encryption key for your account. Your account has a different default encryption key for each Regions.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>Not currently supported.
    /// </p>
    pub fn pre_signed_url(&self) -> std::option::Option<&str> {
        self.pre_signed_url.as_deref()
    }
    /// <p>A list of log types that need to be enabled for exporting to Amazon
    /// CloudWatch Logs. You can enable audit logs or profiler logs. For more
    /// information, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/event-auditing.html">
    /// Auditing Amazon DocumentDB Events</a>
    /// and <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/profiling.html">
    /// Profiling Amazon DocumentDB Operations</a>.
    /// </p>
    pub fn enable_cloudwatch_logs_exports(&self) -> std::option::Option<&[std::string::String]> {
        self.enable_cloudwatch_logs_exports.as_deref()
    }
    /// <p>Specifies whether this cluster can be deleted. If
    /// <code>DeletionProtection</code> is enabled, the cluster cannot be
    /// deleted unless it is modified and <code>DeletionProtection</code> is
    /// disabled. <code>DeletionProtection</code> protects clusters from
    /// being accidentally deleted.</p>
    pub fn deletion_protection(&self) -> std::option::Option<bool> {
        self.deletion_protection
    }
    /// <p>The cluster identifier of the new global cluster.</p>
    pub fn global_cluster_identifier(&self) -> std::option::Option<&str> {
        self.global_cluster_identifier.as_deref()
    }
}
impl std::fmt::Debug for CreateDbClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDbClusterInput");
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("backup_retention_period", &self.backup_retention_period);
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field(
            "db_cluster_parameter_group_name",
            &self.db_cluster_parameter_group_name,
        );
        formatter.field("vpc_security_group_ids", &self.vpc_security_group_ids);
        formatter.field("db_subnet_group_name", &self.db_subnet_group_name);
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("port", &self.port);
        formatter.field("master_username", &self.master_username);
        formatter.field("master_user_password", &self.master_user_password);
        formatter.field("preferred_backup_window", &self.preferred_backup_window);
        formatter.field(
            "preferred_maintenance_window",
            &self.preferred_maintenance_window,
        );
        formatter.field("tags", &self.tags);
        formatter.field("storage_encrypted", &self.storage_encrypted);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("pre_signed_url", &self.pre_signed_url);
        formatter.field(
            "enable_cloudwatch_logs_exports",
            &self.enable_cloudwatch_logs_exports,
        );
        formatter.field("deletion_protection", &self.deletion_protection);
        formatter.field("global_cluster_identifier", &self.global_cluster_identifier);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>CopyDBClusterSnapshot</a>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CopyDbClusterSnapshotInput {
    /// <p>The identifier of the cluster snapshot to copy. This parameter is
    /// not case sensitive.</p>
    ///
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must specify a valid system snapshot in the
    /// <i>available</i> state.</p>
    /// </li>
    /// <li>
    /// <p>If the source snapshot is in the same Region as the copy, specify a valid snapshot identifier.</p>
    /// </li>
    /// <li>
    ///
    /// <p>If the source snapshot is in a different Region than the copy, specify a valid cluster snapshot ARN.</p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>my-cluster-snapshot1</code>
    /// </p>
    pub source_db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
    /// <p>The identifier of the new cluster snapshot to create from the
    /// source cluster snapshot. This parameter is not case sensitive.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.
    /// </p>
    /// </li>
    /// <li>
    /// <p>The first character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.
    /// </p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>my-cluster-snapshot2</code>
    /// </p>
    pub target_db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
    /// <p>The KMS key ID for an encrypted cluster snapshot. The KMS
    /// key ID is the Amazon Resource Name (ARN), KMS key identifier, or
    /// the KMS key alias for the KMS encryption key. </p>
    ///
    /// <p>If you copy an encrypted cluster snapshot from your account, you can specify a value for <code>KmsKeyId</code> to encrypt the copy with a new KMS encryption key. If you don't specify a value for <code>KmsKeyId</code>, then the copy of the cluster snapshot is encrypted with the same KMS key as the source cluster snapshot.</p>
    ///
    /// <p>If you copy an encrypted cluster snapshot that is shared from another account, then you must specify a value for <code>KmsKeyId</code>.</p>
    ///
    /// <p>To copy an encrypted cluster snapshot to another Region, set <code>KmsKeyId</code> to the KMS key ID that you want to use to encrypt the copy of the cluster snapshot in the destination Region. KMS encryption keys are specific to the Region that they are created in, and you can't use encryption keys from one Region in another Region.</p>
    ///
    /// <p>If you copy an unencrypted cluster snapshot and specify a value for the <code>KmsKeyId</code> parameter, an error is returned.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The URL that contains a Signature Version 4 signed request for the<code>CopyDBClusterSnapshot</code> API action in the Region that contains the source cluster snapshot to copy. You must use the <code>PreSignedUrl</code> parameter when copying a cluster snapshot from another Region.</p>
    ///
    /// <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify
    /// <code>SourceRegion</code> (or <code>--source-region</code> for the
    /// CLI) instead of specifying <code>PreSignedUrl</code> manually.
    /// Specifying <code>SourceRegion</code> autogenerates a pre-signed URL
    /// that is a valid request for the operation that can be executed in
    /// the source Region.</p>
    ///
    /// <p>The presigned URL must be a valid request for the
    /// <code>CopyDBClusterSnapshot</code> API action that can be executed
    /// in the source Region that contains the cluster snapshot to be
    /// copied. The presigned URL request must contain the following
    /// parameter values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SourceRegion</code> - The ID of the region that
    /// contains the snapshot to be copied.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SourceDBClusterSnapshotIdentifier</code> - The
    /// identifier for the the encrypted cluster snapshot to be
    /// copied. This identifier must be in the Amazon Resource Name
    /// (ARN) format for the source Region. For example, if you
    /// are copying an encrypted cluster snapshot from the us-east-1
    /// Region, then your
    /// <code>SourceDBClusterSnapshotIdentifier</code> looks
    /// something like the following:
    /// <code>arn:aws:rds:us-east-1:12345678012:sample-cluster:sample-cluster-snapshot</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TargetDBClusterSnapshotIdentifier</code> - The
    /// identifier for the new cluster snapshot to be created. This
    /// parameter isn't case sensitive.</p>
    /// </li>
    /// </ul>
    pub pre_signed_url: std::option::Option<std::string::String>,
    /// <p>Set to <code>true</code> to copy all tags from the source cluster
    /// snapshot to the target cluster snapshot, and otherwise
    /// <code>false</code>. The default is <code>false</code>.</p>
    pub copy_tags: std::option::Option<bool>,
    /// <p>The tags to be assigned to the cluster snapshot.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CopyDbClusterSnapshotInput {
    /// <p>The identifier of the cluster snapshot to copy. This parameter is
    /// not case sensitive.</p>
    ///
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must specify a valid system snapshot in the
    /// <i>available</i> state.</p>
    /// </li>
    /// <li>
    /// <p>If the source snapshot is in the same Region as the copy, specify a valid snapshot identifier.</p>
    /// </li>
    /// <li>
    ///
    /// <p>If the source snapshot is in a different Region than the copy, specify a valid cluster snapshot ARN.</p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>my-cluster-snapshot1</code>
    /// </p>
    pub fn source_db_cluster_snapshot_identifier(&self) -> std::option::Option<&str> {
        self.source_db_cluster_snapshot_identifier.as_deref()
    }
    /// <p>The identifier of the new cluster snapshot to create from the
    /// source cluster snapshot. This parameter is not case sensitive.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.
    /// </p>
    /// </li>
    /// <li>
    /// <p>The first character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.
    /// </p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>my-cluster-snapshot2</code>
    /// </p>
    pub fn target_db_cluster_snapshot_identifier(&self) -> std::option::Option<&str> {
        self.target_db_cluster_snapshot_identifier.as_deref()
    }
    /// <p>The KMS key ID for an encrypted cluster snapshot. The KMS
    /// key ID is the Amazon Resource Name (ARN), KMS key identifier, or
    /// the KMS key alias for the KMS encryption key. </p>
    ///
    /// <p>If you copy an encrypted cluster snapshot from your account, you can specify a value for <code>KmsKeyId</code> to encrypt the copy with a new KMS encryption key. If you don't specify a value for <code>KmsKeyId</code>, then the copy of the cluster snapshot is encrypted with the same KMS key as the source cluster snapshot.</p>
    ///
    /// <p>If you copy an encrypted cluster snapshot that is shared from another account, then you must specify a value for <code>KmsKeyId</code>.</p>
    ///
    /// <p>To copy an encrypted cluster snapshot to another Region, set <code>KmsKeyId</code> to the KMS key ID that you want to use to encrypt the copy of the cluster snapshot in the destination Region. KMS encryption keys are specific to the Region that they are created in, and you can't use encryption keys from one Region in another Region.</p>
    ///
    /// <p>If you copy an unencrypted cluster snapshot and specify a value for the <code>KmsKeyId</code> parameter, an error is returned.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The URL that contains a Signature Version 4 signed request for the<code>CopyDBClusterSnapshot</code> API action in the Region that contains the source cluster snapshot to copy. You must use the <code>PreSignedUrl</code> parameter when copying a cluster snapshot from another Region.</p>
    ///
    /// <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify
    /// <code>SourceRegion</code> (or <code>--source-region</code> for the
    /// CLI) instead of specifying <code>PreSignedUrl</code> manually.
    /// Specifying <code>SourceRegion</code> autogenerates a pre-signed URL
    /// that is a valid request for the operation that can be executed in
    /// the source Region.</p>
    ///
    /// <p>The presigned URL must be a valid request for the
    /// <code>CopyDBClusterSnapshot</code> API action that can be executed
    /// in the source Region that contains the cluster snapshot to be
    /// copied. The presigned URL request must contain the following
    /// parameter values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SourceRegion</code> - The ID of the region that
    /// contains the snapshot to be copied.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SourceDBClusterSnapshotIdentifier</code> - The
    /// identifier for the the encrypted cluster snapshot to be
    /// copied. This identifier must be in the Amazon Resource Name
    /// (ARN) format for the source Region. For example, if you
    /// are copying an encrypted cluster snapshot from the us-east-1
    /// Region, then your
    /// <code>SourceDBClusterSnapshotIdentifier</code> looks
    /// something like the following:
    /// <code>arn:aws:rds:us-east-1:12345678012:sample-cluster:sample-cluster-snapshot</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TargetDBClusterSnapshotIdentifier</code> - The
    /// identifier for the new cluster snapshot to be created. This
    /// parameter isn't case sensitive.</p>
    /// </li>
    /// </ul>
    pub fn pre_signed_url(&self) -> std::option::Option<&str> {
        self.pre_signed_url.as_deref()
    }
    /// <p>Set to <code>true</code> to copy all tags from the source cluster
    /// snapshot to the target cluster snapshot, and otherwise
    /// <code>false</code>. The default is <code>false</code>.</p>
    pub fn copy_tags(&self) -> std::option::Option<bool> {
        self.copy_tags
    }
    /// <p>The tags to be assigned to the cluster snapshot.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CopyDbClusterSnapshotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CopyDbClusterSnapshotInput");
        formatter.field(
            "source_db_cluster_snapshot_identifier",
            &self.source_db_cluster_snapshot_identifier,
        );
        formatter.field(
            "target_db_cluster_snapshot_identifier",
            &self.target_db_cluster_snapshot_identifier,
        );
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("pre_signed_url", &self.pre_signed_url);
        formatter.field("copy_tags", &self.copy_tags);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>CopyDBClusterParameterGroup</a>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CopyDbClusterParameterGroupInput {
    /// <p>The identifier or Amazon Resource Name (ARN) for the source cluster parameter group.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must specify a valid cluster parameter group.</p>
    /// </li>
    /// <li>
    /// <p>If the source cluster parameter group is in the same Region as the copy, specify a valid parameter group identifier; for example, <code>my-db-cluster-param-group</code>, or a valid ARN.</p>
    /// </li>
    /// <li>
    /// <p>If the source parameter group is in a different Region than the copy, specify a valid cluster parameter group ARN; for example, <code>arn:aws:rds:us-east-1:123456789012:sample-cluster:sample-parameter-group</code>.</p>
    /// </li>
    /// </ul>
    pub source_db_cluster_parameter_group_identifier: std::option::Option<std::string::String>,
    /// <p>The identifier for the copied cluster parameter group.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Cannot be null, empty, or blank.</p>
    /// </li>
    /// <li>
    /// <p>Must contain from 1 to 255 letters, numbers, or hyphens.
    /// </p>
    /// </li>
    /// <li>
    /// <p>The first character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.
    /// </p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>my-cluster-param-group1</code>
    /// </p>
    pub target_db_cluster_parameter_group_identifier: std::option::Option<std::string::String>,
    /// <p>A description for the copied cluster parameter group.</p>
    pub target_db_cluster_parameter_group_description: std::option::Option<std::string::String>,
    /// <p>The tags that are to be assigned to the parameter group.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CopyDbClusterParameterGroupInput {
    /// <p>The identifier or Amazon Resource Name (ARN) for the source cluster parameter group.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must specify a valid cluster parameter group.</p>
    /// </li>
    /// <li>
    /// <p>If the source cluster parameter group is in the same Region as the copy, specify a valid parameter group identifier; for example, <code>my-db-cluster-param-group</code>, or a valid ARN.</p>
    /// </li>
    /// <li>
    /// <p>If the source parameter group is in a different Region than the copy, specify a valid cluster parameter group ARN; for example, <code>arn:aws:rds:us-east-1:123456789012:sample-cluster:sample-parameter-group</code>.</p>
    /// </li>
    /// </ul>
    pub fn source_db_cluster_parameter_group_identifier(&self) -> std::option::Option<&str> {
        self.source_db_cluster_parameter_group_identifier.as_deref()
    }
    /// <p>The identifier for the copied cluster parameter group.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Cannot be null, empty, or blank.</p>
    /// </li>
    /// <li>
    /// <p>Must contain from 1 to 255 letters, numbers, or hyphens.
    /// </p>
    /// </li>
    /// <li>
    /// <p>The first character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.
    /// </p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>my-cluster-param-group1</code>
    /// </p>
    pub fn target_db_cluster_parameter_group_identifier(&self) -> std::option::Option<&str> {
        self.target_db_cluster_parameter_group_identifier.as_deref()
    }
    /// <p>A description for the copied cluster parameter group.</p>
    pub fn target_db_cluster_parameter_group_description(&self) -> std::option::Option<&str> {
        self.target_db_cluster_parameter_group_description
            .as_deref()
    }
    /// <p>The tags that are to be assigned to the parameter group.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CopyDbClusterParameterGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CopyDbClusterParameterGroupInput");
        formatter.field(
            "source_db_cluster_parameter_group_identifier",
            &self.source_db_cluster_parameter_group_identifier,
        );
        formatter.field(
            "target_db_cluster_parameter_group_identifier",
            &self.target_db_cluster_parameter_group_identifier,
        );
        formatter.field(
            "target_db_cluster_parameter_group_description",
            &self.target_db_cluster_parameter_group_description,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>ApplyPendingMaintenanceAction</a>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplyPendingMaintenanceActionInput {
    /// <p>The Amazon Resource Name (ARN) of the resource that the pending
    /// maintenance action applies to.</p>
    pub resource_identifier: std::option::Option<std::string::String>,
    /// <p>The pending maintenance action to apply to this resource.</p>
    /// <p>Valid values: <code>system-update</code>, <code>db-upgrade</code>
    /// </p>
    pub apply_action: std::option::Option<std::string::String>,
    /// <p>A value that specifies the type of opt-in request or undoes an
    /// opt-in request. An opt-in request of type <code>immediate</code>
    /// can't be undone.</p>
    /// <p>Valid values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>immediate</code> - Apply the maintenance action
    /// immediately.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>next-maintenance</code> - Apply the maintenance
    /// action during the next maintenance window for the resource.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>undo-opt-in</code> - Cancel any existing
    /// <code>next-maintenance</code> opt-in requests.</p>
    /// </li>
    /// </ul>
    pub opt_in_type: std::option::Option<std::string::String>,
}
impl ApplyPendingMaintenanceActionInput {
    /// <p>The Amazon Resource Name (ARN) of the resource that the pending
    /// maintenance action applies to.</p>
    pub fn resource_identifier(&self) -> std::option::Option<&str> {
        self.resource_identifier.as_deref()
    }
    /// <p>The pending maintenance action to apply to this resource.</p>
    /// <p>Valid values: <code>system-update</code>, <code>db-upgrade</code>
    /// </p>
    pub fn apply_action(&self) -> std::option::Option<&str> {
        self.apply_action.as_deref()
    }
    /// <p>A value that specifies the type of opt-in request or undoes an
    /// opt-in request. An opt-in request of type <code>immediate</code>
    /// can't be undone.</p>
    /// <p>Valid values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>immediate</code> - Apply the maintenance action
    /// immediately.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>next-maintenance</code> - Apply the maintenance
    /// action during the next maintenance window for the resource.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>undo-opt-in</code> - Cancel any existing
    /// <code>next-maintenance</code> opt-in requests.</p>
    /// </li>
    /// </ul>
    pub fn opt_in_type(&self) -> std::option::Option<&str> {
        self.opt_in_type.as_deref()
    }
}
impl std::fmt::Debug for ApplyPendingMaintenanceActionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplyPendingMaintenanceActionInput");
        formatter.field("resource_identifier", &self.resource_identifier);
        formatter.field("apply_action", &self.apply_action);
        formatter.field("opt_in_type", &self.opt_in_type);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>AddTagsToResource</a>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddTagsToResourceInput {
    /// <p>The Amazon DocumentDB resource that the tags are added to. This value is an
    /// Amazon Resource Name .</p>
    pub resource_name: std::option::Option<std::string::String>,
    /// <p>The tags to be assigned to the Amazon DocumentDB resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl AddTagsToResourceInput {
    /// <p>The Amazon DocumentDB resource that the tags are added to. This value is an
    /// Amazon Resource Name .</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
    /// <p>The tags to be assigned to the Amazon DocumentDB resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for AddTagsToResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddTagsToResourceInput");
        formatter.field("resource_name", &self.resource_name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Represents the input to <a>AddSourceIdentifierToSubscription</a>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddSourceIdentifierToSubscriptionInput {
    /// <p>The name of the Amazon DocumentDB event notification subscription that you
    /// want to add a source identifier to.</p>
    pub subscription_name: std::option::Option<std::string::String>,
    /// <p>The identifier of the event source to be added:</p>
    /// <ul>
    /// <li>
    /// <p>If the source type is an instance, a
    /// <code>DBInstanceIdentifier</code> must be provided.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is a security group, a
    /// <code>DBSecurityGroupName</code> must be provided.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is a parameter group, a
    /// <code>DBParameterGroupName</code> must be provided.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is a snapshot, a
    /// <code>DBSnapshotIdentifier</code> must be provided.</p>
    /// </li>
    /// </ul>
    pub source_identifier: std::option::Option<std::string::String>,
}
impl AddSourceIdentifierToSubscriptionInput {
    /// <p>The name of the Amazon DocumentDB event notification subscription that you
    /// want to add a source identifier to.</p>
    pub fn subscription_name(&self) -> std::option::Option<&str> {
        self.subscription_name.as_deref()
    }
    /// <p>The identifier of the event source to be added:</p>
    /// <ul>
    /// <li>
    /// <p>If the source type is an instance, a
    /// <code>DBInstanceIdentifier</code> must be provided.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is a security group, a
    /// <code>DBSecurityGroupName</code> must be provided.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is a parameter group, a
    /// <code>DBParameterGroupName</code> must be provided.</p>
    /// </li>
    /// <li>
    /// <p>If the source type is a snapshot, a
    /// <code>DBSnapshotIdentifier</code> must be provided.</p>
    /// </li>
    /// </ul>
    pub fn source_identifier(&self) -> std::option::Option<&str> {
        self.source_identifier.as_deref()
    }
}
impl std::fmt::Debug for AddSourceIdentifierToSubscriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddSourceIdentifierToSubscriptionInput");
        formatter.field("subscription_name", &self.subscription_name);
        formatter.field("source_identifier", &self.source_identifier);
        formatter.finish()
    }
}
