// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Detailed information about a cluster. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbCluster {
    /// <p>Provides the list of Amazon EC2 Availability Zones that instances in the cluster
    /// can be created in.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies the number of days for which automatic snapshots are retained.</p>
    pub backup_retention_period: std::option::Option<i32>,
    /// <p>Contains a user-supplied cluster identifier. This identifier is the unique key that
    /// identifies a cluster.</p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>Specifies the name of the cluster parameter group for the cluster.</p>
    pub db_cluster_parameter_group: std::option::Option<std::string::String>,
    /// <p>Specifies information on the subnet group that is associated with the cluster, including the name, description, and subnets in the subnet group.</p>
    pub db_subnet_group: std::option::Option<std::string::String>,
    /// <p>Specifies the current state of this cluster.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>Specifies the progress of the operation as a percentage.</p>
    pub percent_progress: std::option::Option<std::string::String>,
    /// <p>The earliest time to which a database can be restored with point-in-time
    /// restore.</p>
    pub earliest_restorable_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Specifies the connection endpoint for the primary instance of the cluster.</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>The reader endpoint for the cluster. The reader endpoint for a cluster load balances connections across the Amazon DocumentDB replicas that are available in a cluster. As clients request new connections to the reader endpoint, Amazon DocumentDB distributes the connection requests among the Amazon DocumentDB replicas in the cluster. This functionality can help balance your read workload across multiple Amazon DocumentDB replicas in your cluster. </p>
    /// <p>If a failover occurs, and the Amazon DocumentDB replica that you are connected to is promoted to be the primary instance, your connection is dropped. To continue sending your read workload to other Amazon DocumentDB replicas in the cluster, you can then reconnect to the reader endpoint.</p>
    pub reader_endpoint: std::option::Option<std::string::String>,
    /// <p>Specifies whether the cluster has instances in multiple Availability Zones.</p>
    pub multi_az: bool,
    /// <p>Provides the name of the database engine to be used for this cluster.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>Indicates the database engine version.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>Specifies the latest time to which a database can be restored with point-in-time
    /// restore.</p>
    pub latest_restorable_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Specifies the port that the database engine is listening on.</p>
    pub port: std::option::Option<i32>,
    /// <p>Contains the master user name for the cluster.</p>
    pub master_username: std::option::Option<std::string::String>,
    /// <p>Specifies the daily time range during which automated backups are created if automated
    /// backups are enabled, as determined by the <code>BackupRetentionPeriod</code>. </p>
    pub preferred_backup_window: std::option::Option<std::string::String>,
    /// <p>Specifies the weekly time range during which system maintenance can occur, in
    /// Universal Coordinated Time (UTC).</p>
    pub preferred_maintenance_window: std::option::Option<std::string::String>,
    /// <p>Contains the identifier of the source cluster if this cluster is a secondary cluster.</p>
    pub replication_source_identifier: std::option::Option<std::string::String>,
    /// <p>Contains one or more identifiers of the secondary clusters that are associated with this cluster.</p>
    pub read_replica_identifiers: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Provides the list of instances that make up the cluster.</p>
    pub db_cluster_members: std::option::Option<std::vec::Vec<crate::model::DbClusterMember>>,
    /// <p>Provides a list of virtual private cloud (VPC) security groups that the cluster
    /// belongs to.</p>
    pub vpc_security_groups:
        std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
    /// <p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the cluster is encrypted.</p>
    pub storage_encrypted: bool,
    /// <p>If <code>StorageEncrypted</code> is <code>true</code>, the KMS key identifier for
    /// the encrypted cluster.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The Region-unique, immutable identifier for the cluster. This identifier is
    /// found in CloudTrail log entries whenever the KMS key for the cluster is accessed.</p>
    pub db_cluster_resource_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the cluster.</p>
    pub db_cluster_arn: std::option::Option<std::string::String>,
    /// <p>Provides a list of the Identity and Access Management (IAM) roles that are associated with the cluster. (IAM) roles that are associated with a cluster grant permission for the cluster to access other Amazon Web Services services on your behalf.</p>
    pub associated_roles: std::option::Option<std::vec::Vec<crate::model::DbClusterRole>>,
    /// <p>Specifies the time when the cluster was created, in Universal Coordinated Time
    /// (UTC).</p>
    pub cluster_create_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A list of log types that this cluster is configured to export to Amazon CloudWatch
    /// Logs.</p>
    pub enabled_cloudwatch_logs_exports: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is
    /// enabled, the cluster cannot be deleted unless it is modified and
    /// <code>DeletionProtection</code> is disabled. <code>DeletionProtection</code>
    /// protects clusters from being accidentally deleted.</p>
    pub deletion_protection: bool,
}
impl DbCluster {
    /// <p>Provides the list of Amazon EC2 Availability Zones that instances in the cluster
    /// can be created in.</p>
    pub fn availability_zones(&self) -> std::option::Option<&[std::string::String]> {
        self.availability_zones.as_deref()
    }
    /// <p>Specifies the number of days for which automatic snapshots are retained.</p>
    pub fn backup_retention_period(&self) -> std::option::Option<i32> {
        self.backup_retention_period
    }
    /// <p>Contains a user-supplied cluster identifier. This identifier is the unique key that
    /// identifies a cluster.</p>
    pub fn db_cluster_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_identifier.as_deref()
    }
    /// <p>Specifies the name of the cluster parameter group for the cluster.</p>
    pub fn db_cluster_parameter_group(&self) -> std::option::Option<&str> {
        self.db_cluster_parameter_group.as_deref()
    }
    /// <p>Specifies information on the subnet group that is associated with the cluster, including the name, description, and subnets in the subnet group.</p>
    pub fn db_subnet_group(&self) -> std::option::Option<&str> {
        self.db_subnet_group.as_deref()
    }
    /// <p>Specifies the current state of this cluster.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>Specifies the progress of the operation as a percentage.</p>
    pub fn percent_progress(&self) -> std::option::Option<&str> {
        self.percent_progress.as_deref()
    }
    /// <p>The earliest time to which a database can be restored with point-in-time
    /// restore.</p>
    pub fn earliest_restorable_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.earliest_restorable_time.as_ref()
    }
    /// <p>Specifies the connection endpoint for the primary instance of the cluster.</p>
    pub fn endpoint(&self) -> std::option::Option<&str> {
        self.endpoint.as_deref()
    }
    /// <p>The reader endpoint for the cluster. The reader endpoint for a cluster load balances connections across the Amazon DocumentDB replicas that are available in a cluster. As clients request new connections to the reader endpoint, Amazon DocumentDB distributes the connection requests among the Amazon DocumentDB replicas in the cluster. This functionality can help balance your read workload across multiple Amazon DocumentDB replicas in your cluster. </p>
    /// <p>If a failover occurs, and the Amazon DocumentDB replica that you are connected to is promoted to be the primary instance, your connection is dropped. To continue sending your read workload to other Amazon DocumentDB replicas in the cluster, you can then reconnect to the reader endpoint.</p>
    pub fn reader_endpoint(&self) -> std::option::Option<&str> {
        self.reader_endpoint.as_deref()
    }
    /// <p>Specifies whether the cluster has instances in multiple Availability Zones.</p>
    pub fn multi_az(&self) -> bool {
        self.multi_az
    }
    /// <p>Provides the name of the database engine to be used for this cluster.</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>Indicates the database engine version.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>Specifies the latest time to which a database can be restored with point-in-time
    /// restore.</p>
    pub fn latest_restorable_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.latest_restorable_time.as_ref()
    }
    /// <p>Specifies the port that the database engine is listening on.</p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
    /// <p>Contains the master user name for the cluster.</p>
    pub fn master_username(&self) -> std::option::Option<&str> {
        self.master_username.as_deref()
    }
    /// <p>Specifies the daily time range during which automated backups are created if automated
    /// backups are enabled, as determined by the <code>BackupRetentionPeriod</code>. </p>
    pub fn preferred_backup_window(&self) -> std::option::Option<&str> {
        self.preferred_backup_window.as_deref()
    }
    /// <p>Specifies the weekly time range during which system maintenance can occur, in
    /// Universal Coordinated Time (UTC).</p>
    pub fn preferred_maintenance_window(&self) -> std::option::Option<&str> {
        self.preferred_maintenance_window.as_deref()
    }
    /// <p>Contains the identifier of the source cluster if this cluster is a secondary cluster.</p>
    pub fn replication_source_identifier(&self) -> std::option::Option<&str> {
        self.replication_source_identifier.as_deref()
    }
    /// <p>Contains one or more identifiers of the secondary clusters that are associated with this cluster.</p>
    pub fn read_replica_identifiers(&self) -> std::option::Option<&[std::string::String]> {
        self.read_replica_identifiers.as_deref()
    }
    /// <p>Provides the list of instances that make up the cluster.</p>
    pub fn db_cluster_members(&self) -> std::option::Option<&[crate::model::DbClusterMember]> {
        self.db_cluster_members.as_deref()
    }
    /// <p>Provides a list of virtual private cloud (VPC) security groups that the cluster
    /// belongs to.</p>
    pub fn vpc_security_groups(
        &self,
    ) -> std::option::Option<&[crate::model::VpcSecurityGroupMembership]> {
        self.vpc_security_groups.as_deref()
    }
    /// <p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>
    pub fn hosted_zone_id(&self) -> std::option::Option<&str> {
        self.hosted_zone_id.as_deref()
    }
    /// <p>Specifies whether the cluster is encrypted.</p>
    pub fn storage_encrypted(&self) -> bool {
        self.storage_encrypted
    }
    /// <p>If <code>StorageEncrypted</code> is <code>true</code>, the KMS key identifier for
    /// the encrypted cluster.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The Region-unique, immutable identifier for the cluster. This identifier is
    /// found in CloudTrail log entries whenever the KMS key for the cluster is accessed.</p>
    pub fn db_cluster_resource_id(&self) -> std::option::Option<&str> {
        self.db_cluster_resource_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the cluster.</p>
    pub fn db_cluster_arn(&self) -> std::option::Option<&str> {
        self.db_cluster_arn.as_deref()
    }
    /// <p>Provides a list of the Identity and Access Management (IAM) roles that are associated with the cluster. (IAM) roles that are associated with a cluster grant permission for the cluster to access other Amazon Web Services services on your behalf.</p>
    pub fn associated_roles(&self) -> std::option::Option<&[crate::model::DbClusterRole]> {
        self.associated_roles.as_deref()
    }
    /// <p>Specifies the time when the cluster was created, in Universal Coordinated Time
    /// (UTC).</p>
    pub fn cluster_create_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.cluster_create_time.as_ref()
    }
    /// <p>A list of log types that this cluster is configured to export to Amazon CloudWatch
    /// Logs.</p>
    pub fn enabled_cloudwatch_logs_exports(&self) -> std::option::Option<&[std::string::String]> {
        self.enabled_cloudwatch_logs_exports.as_deref()
    }
    /// <p>Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is
    /// enabled, the cluster cannot be deleted unless it is modified and
    /// <code>DeletionProtection</code> is disabled. <code>DeletionProtection</code>
    /// protects clusters from being accidentally deleted.</p>
    pub fn deletion_protection(&self) -> bool {
        self.deletion_protection
    }
}
impl std::fmt::Debug for DbCluster {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbCluster");
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("backup_retention_period", &self.backup_retention_period);
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field(
            "db_cluster_parameter_group",
            &self.db_cluster_parameter_group,
        );
        formatter.field("db_subnet_group", &self.db_subnet_group);
        formatter.field("status", &self.status);
        formatter.field("percent_progress", &self.percent_progress);
        formatter.field("earliest_restorable_time", &self.earliest_restorable_time);
        formatter.field("endpoint", &self.endpoint);
        formatter.field("reader_endpoint", &self.reader_endpoint);
        formatter.field("multi_az", &self.multi_az);
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("latest_restorable_time", &self.latest_restorable_time);
        formatter.field("port", &self.port);
        formatter.field("master_username", &self.master_username);
        formatter.field("preferred_backup_window", &self.preferred_backup_window);
        formatter.field(
            "preferred_maintenance_window",
            &self.preferred_maintenance_window,
        );
        formatter.field(
            "replication_source_identifier",
            &self.replication_source_identifier,
        );
        formatter.field("read_replica_identifiers", &self.read_replica_identifiers);
        formatter.field("db_cluster_members", &self.db_cluster_members);
        formatter.field("vpc_security_groups", &self.vpc_security_groups);
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.field("storage_encrypted", &self.storage_encrypted);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("db_cluster_resource_id", &self.db_cluster_resource_id);
        formatter.field("db_cluster_arn", &self.db_cluster_arn);
        formatter.field("associated_roles", &self.associated_roles);
        formatter.field("cluster_create_time", &self.cluster_create_time);
        formatter.field(
            "enabled_cloudwatch_logs_exports",
            &self.enabled_cloudwatch_logs_exports,
        );
        formatter.field("deletion_protection", &self.deletion_protection);
        formatter.finish()
    }
}
/// See [`DbCluster`](crate::model::DbCluster)
pub mod db_cluster {
    /// A builder for [`DbCluster`](crate::model::DbCluster)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) backup_retention_period: std::option::Option<i32>,
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_parameter_group: std::option::Option<std::string::String>,
        pub(crate) db_subnet_group: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) percent_progress: std::option::Option<std::string::String>,
        pub(crate) earliest_restorable_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) reader_endpoint: std::option::Option<std::string::String>,
        pub(crate) multi_az: std::option::Option<bool>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) latest_restorable_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) master_username: std::option::Option<std::string::String>,
        pub(crate) preferred_backup_window: std::option::Option<std::string::String>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) replication_source_identifier: std::option::Option<std::string::String>,
        pub(crate) read_replica_identifiers:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) db_cluster_members:
            std::option::Option<std::vec::Vec<crate::model::DbClusterMember>>,
        pub(crate) vpc_security_groups:
            std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
        pub(crate) storage_encrypted: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) db_cluster_resource_id: std::option::Option<std::string::String>,
        pub(crate) db_cluster_arn: std::option::Option<std::string::String>,
        pub(crate) associated_roles:
            std::option::Option<std::vec::Vec<crate::model::DbClusterRole>>,
        pub(crate) cluster_create_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) enabled_cloudwatch_logs_exports:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) deletion_protection: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>Provides the list of Amazon EC2 Availability Zones that instances in the cluster
        /// can be created in.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>Provides the list of Amazon EC2 Availability Zones that instances in the cluster
        /// can be created in.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// <p>Specifies the number of days for which automatic snapshots are retained.</p>
        pub fn backup_retention_period(mut self, input: i32) -> Self {
            self.backup_retention_period = Some(input);
            self
        }
        /// <p>Specifies the number of days for which automatic snapshots are retained.</p>
        pub fn set_backup_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.backup_retention_period = input;
            self
        }
        /// <p>Contains a user-supplied cluster identifier. This identifier is the unique key that
        /// identifies a cluster.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>Contains a user-supplied cluster identifier. This identifier is the unique key that
        /// identifies a cluster.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>Specifies the name of the cluster parameter group for the cluster.</p>
        pub fn db_cluster_parameter_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_parameter_group = Some(input.into());
            self
        }
        /// <p>Specifies the name of the cluster parameter group for the cluster.</p>
        pub fn set_db_cluster_parameter_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group = input;
            self
        }
        /// <p>Specifies information on the subnet group that is associated with the cluster, including the name, description, and subnets in the subnet group.</p>
        pub fn db_subnet_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group = Some(input.into());
            self
        }
        /// <p>Specifies information on the subnet group that is associated with the cluster, including the name, description, and subnets in the subnet group.</p>
        pub fn set_db_subnet_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group = input;
            self
        }
        /// <p>Specifies the current state of this cluster.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Specifies the current state of this cluster.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>Specifies the progress of the operation as a percentage.</p>
        pub fn percent_progress(mut self, input: impl Into<std::string::String>) -> Self {
            self.percent_progress = Some(input.into());
            self
        }
        /// <p>Specifies the progress of the operation as a percentage.</p>
        pub fn set_percent_progress(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.percent_progress = input;
            self
        }
        /// <p>The earliest time to which a database can be restored with point-in-time
        /// restore.</p>
        pub fn earliest_restorable_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.earliest_restorable_time = Some(input);
            self
        }
        /// <p>The earliest time to which a database can be restored with point-in-time
        /// restore.</p>
        pub fn set_earliest_restorable_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.earliest_restorable_time = input;
            self
        }
        /// <p>Specifies the connection endpoint for the primary instance of the cluster.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>Specifies the connection endpoint for the primary instance of the cluster.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The reader endpoint for the cluster. The reader endpoint for a cluster load balances connections across the Amazon DocumentDB replicas that are available in a cluster. As clients request new connections to the reader endpoint, Amazon DocumentDB distributes the connection requests among the Amazon DocumentDB replicas in the cluster. This functionality can help balance your read workload across multiple Amazon DocumentDB replicas in your cluster. </p>
        /// <p>If a failover occurs, and the Amazon DocumentDB replica that you are connected to is promoted to be the primary instance, your connection is dropped. To continue sending your read workload to other Amazon DocumentDB replicas in the cluster, you can then reconnect to the reader endpoint.</p>
        pub fn reader_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.reader_endpoint = Some(input.into());
            self
        }
        /// <p>The reader endpoint for the cluster. The reader endpoint for a cluster load balances connections across the Amazon DocumentDB replicas that are available in a cluster. As clients request new connections to the reader endpoint, Amazon DocumentDB distributes the connection requests among the Amazon DocumentDB replicas in the cluster. This functionality can help balance your read workload across multiple Amazon DocumentDB replicas in your cluster. </p>
        /// <p>If a failover occurs, and the Amazon DocumentDB replica that you are connected to is promoted to be the primary instance, your connection is dropped. To continue sending your read workload to other Amazon DocumentDB replicas in the cluster, you can then reconnect to the reader endpoint.</p>
        pub fn set_reader_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reader_endpoint = input;
            self
        }
        /// <p>Specifies whether the cluster has instances in multiple Availability Zones.</p>
        pub fn multi_az(mut self, input: bool) -> Self {
            self.multi_az = Some(input);
            self
        }
        /// <p>Specifies whether the cluster has instances in multiple Availability Zones.</p>
        pub fn set_multi_az(mut self, input: std::option::Option<bool>) -> Self {
            self.multi_az = input;
            self
        }
        /// <p>Provides the name of the database engine to be used for this cluster.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>Provides the name of the database engine to be used for this cluster.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>Indicates the database engine version.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>Indicates the database engine version.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>Specifies the latest time to which a database can be restored with point-in-time
        /// restore.</p>
        pub fn latest_restorable_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.latest_restorable_time = Some(input);
            self
        }
        /// <p>Specifies the latest time to which a database can be restored with point-in-time
        /// restore.</p>
        pub fn set_latest_restorable_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.latest_restorable_time = input;
            self
        }
        /// <p>Specifies the port that the database engine is listening on.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>Specifies the port that the database engine is listening on.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Contains the master user name for the cluster.</p>
        pub fn master_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_username = Some(input.into());
            self
        }
        /// <p>Contains the master user name for the cluster.</p>
        pub fn set_master_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_username = input;
            self
        }
        /// <p>Specifies the daily time range during which automated backups are created if automated
        /// backups are enabled, as determined by the <code>BackupRetentionPeriod</code>. </p>
        pub fn preferred_backup_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.preferred_backup_window = Some(input.into());
            self
        }
        /// <p>Specifies the daily time range during which automated backups are created if automated
        /// backups are enabled, as determined by the <code>BackupRetentionPeriod</code>. </p>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_backup_window = input;
            self
        }
        /// <p>Specifies the weekly time range during which system maintenance can occur, in
        /// Universal Coordinated Time (UTC).</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>Specifies the weekly time range during which system maintenance can occur, in
        /// Universal Coordinated Time (UTC).</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p>Contains the identifier of the source cluster if this cluster is a secondary cluster.</p>
        pub fn replication_source_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_source_identifier = Some(input.into());
            self
        }
        /// <p>Contains the identifier of the source cluster if this cluster is a secondary cluster.</p>
        pub fn set_replication_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_source_identifier = input;
            self
        }
        /// Appends an item to `read_replica_identifiers`.
        ///
        /// To override the contents of this collection use [`set_read_replica_identifiers`](Self::set_read_replica_identifiers).
        ///
        /// <p>Contains one or more identifiers of the secondary clusters that are associated with this cluster.</p>
        pub fn read_replica_identifiers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.read_replica_identifiers.unwrap_or_default();
            v.push(input.into());
            self.read_replica_identifiers = Some(v);
            self
        }
        /// <p>Contains one or more identifiers of the secondary clusters that are associated with this cluster.</p>
        pub fn set_read_replica_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.read_replica_identifiers = input;
            self
        }
        /// Appends an item to `db_cluster_members`.
        ///
        /// To override the contents of this collection use [`set_db_cluster_members`](Self::set_db_cluster_members).
        ///
        /// <p>Provides the list of instances that make up the cluster.</p>
        pub fn db_cluster_members(
            mut self,
            input: impl Into<crate::model::DbClusterMember>,
        ) -> Self {
            let mut v = self.db_cluster_members.unwrap_or_default();
            v.push(input.into());
            self.db_cluster_members = Some(v);
            self
        }
        /// <p>Provides the list of instances that make up the cluster.</p>
        pub fn set_db_cluster_members(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbClusterMember>>,
        ) -> Self {
            self.db_cluster_members = input;
            self
        }
        /// Appends an item to `vpc_security_groups`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_groups`](Self::set_vpc_security_groups).
        ///
        /// <p>Provides a list of virtual private cloud (VPC) security groups that the cluster
        /// belongs to.</p>
        pub fn vpc_security_groups(
            mut self,
            input: impl Into<crate::model::VpcSecurityGroupMembership>,
        ) -> Self {
            let mut v = self.vpc_security_groups.unwrap_or_default();
            v.push(input.into());
            self.vpc_security_groups = Some(v);
            self
        }
        /// <p>Provides a list of virtual private cloud (VPC) security groups that the cluster
        /// belongs to.</p>
        pub fn set_vpc_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
        ) -> Self {
            self.vpc_security_groups = input;
            self
        }
        /// <p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// <p>Specifies whether the cluster is encrypted.</p>
        pub fn storage_encrypted(mut self, input: bool) -> Self {
            self.storage_encrypted = Some(input);
            self
        }
        /// <p>Specifies whether the cluster is encrypted.</p>
        pub fn set_storage_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.storage_encrypted = input;
            self
        }
        /// <p>If <code>StorageEncrypted</code> is <code>true</code>, the KMS key identifier for
        /// the encrypted cluster.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>If <code>StorageEncrypted</code> is <code>true</code>, the KMS key identifier for
        /// the encrypted cluster.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The Region-unique, immutable identifier for the cluster. This identifier is
        /// found in CloudTrail log entries whenever the KMS key for the cluster is accessed.</p>
        pub fn db_cluster_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_resource_id = Some(input.into());
            self
        }
        /// <p>The Region-unique, immutable identifier for the cluster. This identifier is
        /// found in CloudTrail log entries whenever the KMS key for the cluster is accessed.</p>
        pub fn set_db_cluster_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_resource_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the cluster.</p>
        pub fn db_cluster_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the cluster.</p>
        pub fn set_db_cluster_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_arn = input;
            self
        }
        /// Appends an item to `associated_roles`.
        ///
        /// To override the contents of this collection use [`set_associated_roles`](Self::set_associated_roles).
        ///
        /// <p>Provides a list of the Identity and Access Management (IAM) roles that are associated with the cluster. (IAM) roles that are associated with a cluster grant permission for the cluster to access other Amazon Web Services services on your behalf.</p>
        pub fn associated_roles(mut self, input: impl Into<crate::model::DbClusterRole>) -> Self {
            let mut v = self.associated_roles.unwrap_or_default();
            v.push(input.into());
            self.associated_roles = Some(v);
            self
        }
        /// <p>Provides a list of the Identity and Access Management (IAM) roles that are associated with the cluster. (IAM) roles that are associated with a cluster grant permission for the cluster to access other Amazon Web Services services on your behalf.</p>
        pub fn set_associated_roles(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbClusterRole>>,
        ) -> Self {
            self.associated_roles = input;
            self
        }
        /// <p>Specifies the time when the cluster was created, in Universal Coordinated Time
        /// (UTC).</p>
        pub fn cluster_create_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.cluster_create_time = Some(input);
            self
        }
        /// <p>Specifies the time when the cluster was created, in Universal Coordinated Time
        /// (UTC).</p>
        pub fn set_cluster_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.cluster_create_time = input;
            self
        }
        /// Appends an item to `enabled_cloudwatch_logs_exports`.
        ///
        /// To override the contents of this collection use [`set_enabled_cloudwatch_logs_exports`](Self::set_enabled_cloudwatch_logs_exports).
        ///
        /// <p>A list of log types that this cluster is configured to export to Amazon CloudWatch
        /// Logs.</p>
        pub fn enabled_cloudwatch_logs_exports(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.enabled_cloudwatch_logs_exports.unwrap_or_default();
            v.push(input.into());
            self.enabled_cloudwatch_logs_exports = Some(v);
            self
        }
        /// <p>A list of log types that this cluster is configured to export to Amazon CloudWatch
        /// Logs.</p>
        pub fn set_enabled_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.enabled_cloudwatch_logs_exports = input;
            self
        }
        /// <p>Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is
        /// enabled, the cluster cannot be deleted unless it is modified and
        /// <code>DeletionProtection</code> is disabled. <code>DeletionProtection</code>
        /// protects clusters from being accidentally deleted.</p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.deletion_protection = Some(input);
            self
        }
        /// <p>Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is
        /// enabled, the cluster cannot be deleted unless it is modified and
        /// <code>DeletionProtection</code> is disabled. <code>DeletionProtection</code>
        /// protects clusters from being accidentally deleted.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection = input;
            self
        }
        /// Consumes the builder and constructs a [`DbCluster`](crate::model::DbCluster)
        pub fn build(self) -> crate::model::DbCluster {
            crate::model::DbCluster {
                availability_zones: self.availability_zones,
                backup_retention_period: self.backup_retention_period,
                db_cluster_identifier: self.db_cluster_identifier,
                db_cluster_parameter_group: self.db_cluster_parameter_group,
                db_subnet_group: self.db_subnet_group,
                status: self.status,
                percent_progress: self.percent_progress,
                earliest_restorable_time: self.earliest_restorable_time,
                endpoint: self.endpoint,
                reader_endpoint: self.reader_endpoint,
                multi_az: self.multi_az.unwrap_or_default(),
                engine: self.engine,
                engine_version: self.engine_version,
                latest_restorable_time: self.latest_restorable_time,
                port: self.port,
                master_username: self.master_username,
                preferred_backup_window: self.preferred_backup_window,
                preferred_maintenance_window: self.preferred_maintenance_window,
                replication_source_identifier: self.replication_source_identifier,
                read_replica_identifiers: self.read_replica_identifiers,
                db_cluster_members: self.db_cluster_members,
                vpc_security_groups: self.vpc_security_groups,
                hosted_zone_id: self.hosted_zone_id,
                storage_encrypted: self.storage_encrypted.unwrap_or_default(),
                kms_key_id: self.kms_key_id,
                db_cluster_resource_id: self.db_cluster_resource_id,
                db_cluster_arn: self.db_cluster_arn,
                associated_roles: self.associated_roles,
                cluster_create_time: self.cluster_create_time,
                enabled_cloudwatch_logs_exports: self.enabled_cloudwatch_logs_exports,
                deletion_protection: self.deletion_protection.unwrap_or_default(),
            }
        }
    }
}
impl DbCluster {
    /// Creates a new builder-style object to manufacture [`DbCluster`](crate::model::DbCluster)
    pub fn builder() -> crate::model::db_cluster::Builder {
        crate::model::db_cluster::Builder::default()
    }
}

/// <p>Describes an Identity and Access Management (IAM) role that is associated with a
/// cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterRole {
    /// <p>The Amazon Resource Name (ARN) of the IAMrole that is associated with the DB
    /// cluster.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>Describes the state of association between the IAMrole and the cluster. The <code>Status</code> property returns one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code> - The IAMrole ARN is associated with the cluster and can be used to access other Amazon Web Services services on your behalf.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PENDING</code> - The IAMrole ARN is being associated with the cluster.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INVALID</code> - The IAMrole ARN is associated with the cluster, but the cluster cannot assume the IAMrole to access other Amazon Web Services services on your behalf.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
}
impl DbClusterRole {
    /// <p>The Amazon Resource Name (ARN) of the IAMrole that is associated with the DB
    /// cluster.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>Describes the state of association between the IAMrole and the cluster. The <code>Status</code> property returns one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code> - The IAMrole ARN is associated with the cluster and can be used to access other Amazon Web Services services on your behalf.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PENDING</code> - The IAMrole ARN is being associated with the cluster.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INVALID</code> - The IAMrole ARN is associated with the cluster, but the cluster cannot assume the IAMrole to access other Amazon Web Services services on your behalf.</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for DbClusterRole {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterRole");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DbClusterRole`](crate::model::DbClusterRole)
pub mod db_cluster_role {
    /// A builder for [`DbClusterRole`](crate::model::DbClusterRole)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the IAMrole that is associated with the DB
        /// cluster.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAMrole that is associated with the DB
        /// cluster.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>Describes the state of association between the IAMrole and the cluster. The <code>Status</code> property returns one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code> - The IAMrole ARN is associated with the cluster and can be used to access other Amazon Web Services services on your behalf.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PENDING</code> - The IAMrole ARN is being associated with the cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INVALID</code> - The IAMrole ARN is associated with the cluster, but the cluster cannot assume the IAMrole to access other Amazon Web Services services on your behalf.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Describes the state of association between the IAMrole and the cluster. The <code>Status</code> property returns one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code> - The IAMrole ARN is associated with the cluster and can be used to access other Amazon Web Services services on your behalf.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PENDING</code> - The IAMrole ARN is being associated with the cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INVALID</code> - The IAMrole ARN is associated with the cluster, but the cluster cannot assume the IAMrole to access other Amazon Web Services services on your behalf.</p>
        /// </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterRole`](crate::model::DbClusterRole)
        pub fn build(self) -> crate::model::DbClusterRole {
            crate::model::DbClusterRole {
                role_arn: self.role_arn,
                status: self.status,
            }
        }
    }
}
impl DbClusterRole {
    /// Creates a new builder-style object to manufacture [`DbClusterRole`](crate::model::DbClusterRole)
    pub fn builder() -> crate::model::db_cluster_role::Builder {
        crate::model::db_cluster_role::Builder::default()
    }
}

/// <p>Used as a response element for queries on virtual private cloud (VPC) security group
/// membership.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcSecurityGroupMembership {
    /// <p>The name of the VPC security group.</p>
    pub vpc_security_group_id: std::option::Option<std::string::String>,
    /// <p>The status of the VPC security group.</p>
    pub status: std::option::Option<std::string::String>,
}
impl VpcSecurityGroupMembership {
    /// <p>The name of the VPC security group.</p>
    pub fn vpc_security_group_id(&self) -> std::option::Option<&str> {
        self.vpc_security_group_id.as_deref()
    }
    /// <p>The status of the VPC security group.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for VpcSecurityGroupMembership {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcSecurityGroupMembership");
        formatter.field("vpc_security_group_id", &self.vpc_security_group_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`VpcSecurityGroupMembership`](crate::model::VpcSecurityGroupMembership)
pub mod vpc_security_group_membership {
    /// A builder for [`VpcSecurityGroupMembership`](crate::model::VpcSecurityGroupMembership)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_security_group_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the VPC security group.</p>
        pub fn vpc_security_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_security_group_id = Some(input.into());
            self
        }
        /// <p>The name of the VPC security group.</p>
        pub fn set_vpc_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_security_group_id = input;
            self
        }
        /// <p>The status of the VPC security group.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the VPC security group.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcSecurityGroupMembership`](crate::model::VpcSecurityGroupMembership)
        pub fn build(self) -> crate::model::VpcSecurityGroupMembership {
            crate::model::VpcSecurityGroupMembership {
                vpc_security_group_id: self.vpc_security_group_id,
                status: self.status,
            }
        }
    }
}
impl VpcSecurityGroupMembership {
    /// Creates a new builder-style object to manufacture [`VpcSecurityGroupMembership`](crate::model::VpcSecurityGroupMembership)
    pub fn builder() -> crate::model::vpc_security_group_membership::Builder {
        crate::model::vpc_security_group_membership::Builder::default()
    }
}

/// <p>Contains information about an instance that is part of a cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterMember {
    /// <p>Specifies the instance identifier for this member of the cluster.</p>
    pub db_instance_identifier: std::option::Option<std::string::String>,
    /// <p>A value that is <code>true</code> if the cluster member is the primary instance for
    /// the cluster and <code>false</code> otherwise.</p>
    pub is_cluster_writer: bool,
    /// <p>Specifies the status of the cluster parameter group for this member of the DB
    /// cluster.</p>
    pub db_cluster_parameter_group_status: std::option::Option<std::string::String>,
    /// <p>A value that specifies the order in which an Amazon DocumentDB replica is promoted to the
    /// primary instance after a failure of the existing primary instance. </p>
    pub promotion_tier: std::option::Option<i32>,
}
impl DbClusterMember {
    /// <p>Specifies the instance identifier for this member of the cluster.</p>
    pub fn db_instance_identifier(&self) -> std::option::Option<&str> {
        self.db_instance_identifier.as_deref()
    }
    /// <p>A value that is <code>true</code> if the cluster member is the primary instance for
    /// the cluster and <code>false</code> otherwise.</p>
    pub fn is_cluster_writer(&self) -> bool {
        self.is_cluster_writer
    }
    /// <p>Specifies the status of the cluster parameter group for this member of the DB
    /// cluster.</p>
    pub fn db_cluster_parameter_group_status(&self) -> std::option::Option<&str> {
        self.db_cluster_parameter_group_status.as_deref()
    }
    /// <p>A value that specifies the order in which an Amazon DocumentDB replica is promoted to the
    /// primary instance after a failure of the existing primary instance. </p>
    pub fn promotion_tier(&self) -> std::option::Option<i32> {
        self.promotion_tier
    }
}
impl std::fmt::Debug for DbClusterMember {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterMember");
        formatter.field("db_instance_identifier", &self.db_instance_identifier);
        formatter.field("is_cluster_writer", &self.is_cluster_writer);
        formatter.field(
            "db_cluster_parameter_group_status",
            &self.db_cluster_parameter_group_status,
        );
        formatter.field("promotion_tier", &self.promotion_tier);
        formatter.finish()
    }
}
/// See [`DbClusterMember`](crate::model::DbClusterMember)
pub mod db_cluster_member {
    /// A builder for [`DbClusterMember`](crate::model::DbClusterMember)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) is_cluster_writer: std::option::Option<bool>,
        pub(crate) db_cluster_parameter_group_status: std::option::Option<std::string::String>,
        pub(crate) promotion_tier: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Specifies the instance identifier for this member of the cluster.</p>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p>Specifies the instance identifier for this member of the cluster.</p>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// <p>A value that is <code>true</code> if the cluster member is the primary instance for
        /// the cluster and <code>false</code> otherwise.</p>
        pub fn is_cluster_writer(mut self, input: bool) -> Self {
            self.is_cluster_writer = Some(input);
            self
        }
        /// <p>A value that is <code>true</code> if the cluster member is the primary instance for
        /// the cluster and <code>false</code> otherwise.</p>
        pub fn set_is_cluster_writer(mut self, input: std::option::Option<bool>) -> Self {
            self.is_cluster_writer = input;
            self
        }
        /// <p>Specifies the status of the cluster parameter group for this member of the DB
        /// cluster.</p>
        pub fn db_cluster_parameter_group_status(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_status = Some(input.into());
            self
        }
        /// <p>Specifies the status of the cluster parameter group for this member of the DB
        /// cluster.</p>
        pub fn set_db_cluster_parameter_group_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_status = input;
            self
        }
        /// <p>A value that specifies the order in which an Amazon DocumentDB replica is promoted to the
        /// primary instance after a failure of the existing primary instance. </p>
        pub fn promotion_tier(mut self, input: i32) -> Self {
            self.promotion_tier = Some(input);
            self
        }
        /// <p>A value that specifies the order in which an Amazon DocumentDB replica is promoted to the
        /// primary instance after a failure of the existing primary instance. </p>
        pub fn set_promotion_tier(mut self, input: std::option::Option<i32>) -> Self {
            self.promotion_tier = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterMember`](crate::model::DbClusterMember)
        pub fn build(self) -> crate::model::DbClusterMember {
            crate::model::DbClusterMember {
                db_instance_identifier: self.db_instance_identifier,
                is_cluster_writer: self.is_cluster_writer.unwrap_or_default(),
                db_cluster_parameter_group_status: self.db_cluster_parameter_group_status,
                promotion_tier: self.promotion_tier,
            }
        }
    }
}
impl DbClusterMember {
    /// Creates a new builder-style object to manufacture [`DbClusterMember`](crate::model::DbClusterMember)
    pub fn builder() -> crate::model::db_cluster_member::Builder {
        crate::model::db_cluster_member::Builder::default()
    }
}

/// <p>Metadata assigned to an Amazon DocumentDB resource consisting of a key-value pair.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The required name of the tag. The string value can be from 1 to 128 Unicode characters in length and can't be prefixed with "<code>aws:</code>" or "<code>rds:</code>". The string can contain only the set of Unicode letters, digits, white space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The optional value of the tag. The string value can be from 1 to 256 Unicode characters in length and can't be prefixed with "<code>aws:</code>" or "<code>rds:</code>". The string can contain only the set of Unicode letters, digits, white space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The required name of the tag. The string value can be from 1 to 128 Unicode characters in length and can't be prefixed with "<code>aws:</code>" or "<code>rds:</code>". The string can contain only the set of Unicode letters, digits, white space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The optional value of the tag. The string value can be from 1 to 256 Unicode characters in length and can't be prefixed with "<code>aws:</code>" or "<code>rds:</code>". The string can contain only the set of Unicode letters, digits, white space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The required name of the tag. The string value can be from 1 to 128 Unicode characters in length and can't be prefixed with "<code>aws:</code>" or "<code>rds:</code>". The string can contain only the set of Unicode letters, digits, white space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The required name of the tag. The string value can be from 1 to 128 Unicode characters in length and can't be prefixed with "<code>aws:</code>" or "<code>rds:</code>". The string can contain only the set of Unicode letters, digits, white space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The optional value of the tag. The string value can be from 1 to 256 Unicode characters in length and can't be prefixed with "<code>aws:</code>" or "<code>rds:</code>". The string can contain only the set of Unicode letters, digits, white space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The optional value of the tag. The string value can be from 1 to 256 Unicode characters in length and can't be prefixed with "<code>aws:</code>" or "<code>rds:</code>". The string can contain only the set of Unicode letters, digits, white space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Detailed information about an individual parameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Parameter {
    /// <p>Specifies the name of the parameter.</p>
    pub parameter_name: std::option::Option<std::string::String>,
    /// <p>Specifies the value of the parameter.</p>
    pub parameter_value: std::option::Option<std::string::String>,
    /// <p>Provides a description of the parameter.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Indicates the source of the parameter value.</p>
    pub source: std::option::Option<std::string::String>,
    /// <p>Specifies the engine-specific parameters type.</p>
    pub apply_type: std::option::Option<std::string::String>,
    /// <p>Specifies the valid data type for the parameter.</p>
    pub data_type: std::option::Option<std::string::String>,
    /// <p>Specifies the valid range of values for the parameter.</p>
    pub allowed_values: std::option::Option<std::string::String>,
    /// <p> Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can
    /// be modified. Some parameters have security or operational implications that prevent them
    /// from being changed. </p>
    pub is_modifiable: bool,
    /// <p>The earliest engine version to which the parameter can apply.</p>
    pub minimum_engine_version: std::option::Option<std::string::String>,
    /// <p>Indicates when to apply parameter updates.</p>
    pub apply_method: std::option::Option<crate::model::ApplyMethod>,
}
impl Parameter {
    /// <p>Specifies the name of the parameter.</p>
    pub fn parameter_name(&self) -> std::option::Option<&str> {
        self.parameter_name.as_deref()
    }
    /// <p>Specifies the value of the parameter.</p>
    pub fn parameter_value(&self) -> std::option::Option<&str> {
        self.parameter_value.as_deref()
    }
    /// <p>Provides a description of the parameter.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Indicates the source of the parameter value.</p>
    pub fn source(&self) -> std::option::Option<&str> {
        self.source.as_deref()
    }
    /// <p>Specifies the engine-specific parameters type.</p>
    pub fn apply_type(&self) -> std::option::Option<&str> {
        self.apply_type.as_deref()
    }
    /// <p>Specifies the valid data type for the parameter.</p>
    pub fn data_type(&self) -> std::option::Option<&str> {
        self.data_type.as_deref()
    }
    /// <p>Specifies the valid range of values for the parameter.</p>
    pub fn allowed_values(&self) -> std::option::Option<&str> {
        self.allowed_values.as_deref()
    }
    /// <p> Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can
    /// be modified. Some parameters have security or operational implications that prevent them
    /// from being changed. </p>
    pub fn is_modifiable(&self) -> bool {
        self.is_modifiable
    }
    /// <p>The earliest engine version to which the parameter can apply.</p>
    pub fn minimum_engine_version(&self) -> std::option::Option<&str> {
        self.minimum_engine_version.as_deref()
    }
    /// <p>Indicates when to apply parameter updates.</p>
    pub fn apply_method(&self) -> std::option::Option<&crate::model::ApplyMethod> {
        self.apply_method.as_ref()
    }
}
impl std::fmt::Debug for Parameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Parameter");
        formatter.field("parameter_name", &self.parameter_name);
        formatter.field("parameter_value", &self.parameter_value);
        formatter.field("description", &self.description);
        formatter.field("source", &self.source);
        formatter.field("apply_type", &self.apply_type);
        formatter.field("data_type", &self.data_type);
        formatter.field("allowed_values", &self.allowed_values);
        formatter.field("is_modifiable", &self.is_modifiable);
        formatter.field("minimum_engine_version", &self.minimum_engine_version);
        formatter.field("apply_method", &self.apply_method);
        formatter.finish()
    }
}
/// See [`Parameter`](crate::model::Parameter)
pub mod parameter {
    /// A builder for [`Parameter`](crate::model::Parameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_name: std::option::Option<std::string::String>,
        pub(crate) parameter_value: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) apply_type: std::option::Option<std::string::String>,
        pub(crate) data_type: std::option::Option<std::string::String>,
        pub(crate) allowed_values: std::option::Option<std::string::String>,
        pub(crate) is_modifiable: std::option::Option<bool>,
        pub(crate) minimum_engine_version: std::option::Option<std::string::String>,
        pub(crate) apply_method: std::option::Option<crate::model::ApplyMethod>,
    }
    impl Builder {
        /// <p>Specifies the name of the parameter.</p>
        pub fn parameter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the parameter.</p>
        pub fn set_parameter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_name = input;
            self
        }
        /// <p>Specifies the value of the parameter.</p>
        pub fn parameter_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_value = Some(input.into());
            self
        }
        /// <p>Specifies the value of the parameter.</p>
        pub fn set_parameter_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_value = input;
            self
        }
        /// <p>Provides a description of the parameter.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Provides a description of the parameter.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Indicates the source of the parameter value.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>Indicates the source of the parameter value.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// <p>Specifies the engine-specific parameters type.</p>
        pub fn apply_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.apply_type = Some(input.into());
            self
        }
        /// <p>Specifies the engine-specific parameters type.</p>
        pub fn set_apply_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.apply_type = input;
            self
        }
        /// <p>Specifies the valid data type for the parameter.</p>
        pub fn data_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_type = Some(input.into());
            self
        }
        /// <p>Specifies the valid data type for the parameter.</p>
        pub fn set_data_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_type = input;
            self
        }
        /// <p>Specifies the valid range of values for the parameter.</p>
        pub fn allowed_values(mut self, input: impl Into<std::string::String>) -> Self {
            self.allowed_values = Some(input.into());
            self
        }
        /// <p>Specifies the valid range of values for the parameter.</p>
        pub fn set_allowed_values(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.allowed_values = input;
            self
        }
        /// <p> Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can
        /// be modified. Some parameters have security or operational implications that prevent them
        /// from being changed. </p>
        pub fn is_modifiable(mut self, input: bool) -> Self {
            self.is_modifiable = Some(input);
            self
        }
        /// <p> Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can
        /// be modified. Some parameters have security or operational implications that prevent them
        /// from being changed. </p>
        pub fn set_is_modifiable(mut self, input: std::option::Option<bool>) -> Self {
            self.is_modifiable = input;
            self
        }
        /// <p>The earliest engine version to which the parameter can apply.</p>
        pub fn minimum_engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.minimum_engine_version = Some(input.into());
            self
        }
        /// <p>The earliest engine version to which the parameter can apply.</p>
        pub fn set_minimum_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minimum_engine_version = input;
            self
        }
        /// <p>Indicates when to apply parameter updates.</p>
        pub fn apply_method(mut self, input: crate::model::ApplyMethod) -> Self {
            self.apply_method = Some(input);
            self
        }
        /// <p>Indicates when to apply parameter updates.</p>
        pub fn set_apply_method(
            mut self,
            input: std::option::Option<crate::model::ApplyMethod>,
        ) -> Self {
            self.apply_method = input;
            self
        }
        /// Consumes the builder and constructs a [`Parameter`](crate::model::Parameter)
        pub fn build(self) -> crate::model::Parameter {
            crate::model::Parameter {
                parameter_name: self.parameter_name,
                parameter_value: self.parameter_value,
                description: self.description,
                source: self.source,
                apply_type: self.apply_type,
                data_type: self.data_type,
                allowed_values: self.allowed_values,
                is_modifiable: self.is_modifiable.unwrap_or_default(),
                minimum_engine_version: self.minimum_engine_version,
                apply_method: self.apply_method,
            }
        }
    }
}
impl Parameter {
    /// Creates a new builder-style object to manufacture [`Parameter`](crate::model::Parameter)
    pub fn builder() -> crate::model::parameter::Builder {
        crate::model::parameter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ApplyMethod {
    #[allow(missing_docs)] // documentation missing in model
    Immediate,
    #[allow(missing_docs)] // documentation missing in model
    PendingReboot,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ApplyMethod {
    fn from(s: &str) -> Self {
        match s {
            "immediate" => ApplyMethod::Immediate,
            "pending-reboot" => ApplyMethod::PendingReboot,
            other => ApplyMethod::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ApplyMethod {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ApplyMethod::from(s))
    }
}
impl ApplyMethod {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ApplyMethod::Immediate => "immediate",
            ApplyMethod::PendingReboot => "pending-reboot",
            ApplyMethod::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["immediate", "pending-reboot"]
    }
}
impl AsRef<str> for ApplyMethod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Detailed information about an event to which you have subscribed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventSubscription {
    /// <p>The Amazon Web Services customer account that is associated with the Amazon DocumentDB event notification
    /// subscription.</p>
    pub customer_aws_id: std::option::Option<std::string::String>,
    /// <p>The Amazon DocumentDB event notification subscription ID.</p>
    pub cust_subscription_id: std::option::Option<std::string::String>,
    /// <p>The topic ARN of the Amazon DocumentDB event notification subscription.</p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>The status of the Amazon DocumentDB event notification subscription.</p>
    /// <p>Constraints:</p>
    /// <p>Can be one of the following: <code>creating</code>, <code>modifying</code>,
    /// <code>deleting</code>, <code>active</code>, <code>no-permission</code>,
    /// <code>topic-not-exist</code>
    /// </p>
    /// <p>The <code>no-permission</code> status indicates that Amazon DocumentDB no longer has permission
    /// to post to the SNS topic. The <code>topic-not-exist</code> status indicates that the
    /// topic was deleted after the subscription was created.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The time at which the Amazon DocumentDB event notification subscription was created.</p>
    pub subscription_creation_time: std::option::Option<std::string::String>,
    /// <p>The source type for the Amazon DocumentDB event notification subscription.</p>
    pub source_type: std::option::Option<std::string::String>,
    /// <p>A list of source IDs for the Amazon DocumentDB event notification subscription.</p>
    pub source_ids_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of event categories for the Amazon DocumentDB event notification subscription.</p>
    pub event_categories_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A Boolean value indicating whether the subscription is enabled. A value of
    /// <code>true</code> indicates that the subscription is enabled.</p>
    pub enabled: bool,
    /// <p>The Amazon Resource Name (ARN) for the event subscription.</p>
    pub event_subscription_arn: std::option::Option<std::string::String>,
}
impl EventSubscription {
    /// <p>The Amazon Web Services customer account that is associated with the Amazon DocumentDB event notification
    /// subscription.</p>
    pub fn customer_aws_id(&self) -> std::option::Option<&str> {
        self.customer_aws_id.as_deref()
    }
    /// <p>The Amazon DocumentDB event notification subscription ID.</p>
    pub fn cust_subscription_id(&self) -> std::option::Option<&str> {
        self.cust_subscription_id.as_deref()
    }
    /// <p>The topic ARN of the Amazon DocumentDB event notification subscription.</p>
    pub fn sns_topic_arn(&self) -> std::option::Option<&str> {
        self.sns_topic_arn.as_deref()
    }
    /// <p>The status of the Amazon DocumentDB event notification subscription.</p>
    /// <p>Constraints:</p>
    /// <p>Can be one of the following: <code>creating</code>, <code>modifying</code>,
    /// <code>deleting</code>, <code>active</code>, <code>no-permission</code>,
    /// <code>topic-not-exist</code>
    /// </p>
    /// <p>The <code>no-permission</code> status indicates that Amazon DocumentDB no longer has permission
    /// to post to the SNS topic. The <code>topic-not-exist</code> status indicates that the
    /// topic was deleted after the subscription was created.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The time at which the Amazon DocumentDB event notification subscription was created.</p>
    pub fn subscription_creation_time(&self) -> std::option::Option<&str> {
        self.subscription_creation_time.as_deref()
    }
    /// <p>The source type for the Amazon DocumentDB event notification subscription.</p>
    pub fn source_type(&self) -> std::option::Option<&str> {
        self.source_type.as_deref()
    }
    /// <p>A list of source IDs for the Amazon DocumentDB event notification subscription.</p>
    pub fn source_ids_list(&self) -> std::option::Option<&[std::string::String]> {
        self.source_ids_list.as_deref()
    }
    /// <p>A list of event categories for the Amazon DocumentDB event notification subscription.</p>
    pub fn event_categories_list(&self) -> std::option::Option<&[std::string::String]> {
        self.event_categories_list.as_deref()
    }
    /// <p>A Boolean value indicating whether the subscription is enabled. A value of
    /// <code>true</code> indicates that the subscription is enabled.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>The Amazon Resource Name (ARN) for the event subscription.</p>
    pub fn event_subscription_arn(&self) -> std::option::Option<&str> {
        self.event_subscription_arn.as_deref()
    }
}
impl std::fmt::Debug for EventSubscription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventSubscription");
        formatter.field("customer_aws_id", &self.customer_aws_id);
        formatter.field("cust_subscription_id", &self.cust_subscription_id);
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.field("status", &self.status);
        formatter.field(
            "subscription_creation_time",
            &self.subscription_creation_time,
        );
        formatter.field("source_type", &self.source_type);
        formatter.field("source_ids_list", &self.source_ids_list);
        formatter.field("event_categories_list", &self.event_categories_list);
        formatter.field("enabled", &self.enabled);
        formatter.field("event_subscription_arn", &self.event_subscription_arn);
        formatter.finish()
    }
}
/// See [`EventSubscription`](crate::model::EventSubscription)
pub mod event_subscription {
    /// A builder for [`EventSubscription`](crate::model::EventSubscription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) customer_aws_id: std::option::Option<std::string::String>,
        pub(crate) cust_subscription_id: std::option::Option<std::string::String>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) subscription_creation_time: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<std::string::String>,
        pub(crate) source_ids_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) event_categories_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) event_subscription_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services customer account that is associated with the Amazon DocumentDB event notification
        /// subscription.</p>
        pub fn customer_aws_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_aws_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services customer account that is associated with the Amazon DocumentDB event notification
        /// subscription.</p>
        pub fn set_customer_aws_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_aws_id = input;
            self
        }
        /// <p>The Amazon DocumentDB event notification subscription ID.</p>
        pub fn cust_subscription_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cust_subscription_id = Some(input.into());
            self
        }
        /// <p>The Amazon DocumentDB event notification subscription ID.</p>
        pub fn set_cust_subscription_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cust_subscription_id = input;
            self
        }
        /// <p>The topic ARN of the Amazon DocumentDB event notification subscription.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>The topic ARN of the Amazon DocumentDB event notification subscription.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// <p>The status of the Amazon DocumentDB event notification subscription.</p>
        /// <p>Constraints:</p>
        /// <p>Can be one of the following: <code>creating</code>, <code>modifying</code>,
        /// <code>deleting</code>, <code>active</code>, <code>no-permission</code>,
        /// <code>topic-not-exist</code>
        /// </p>
        /// <p>The <code>no-permission</code> status indicates that Amazon DocumentDB no longer has permission
        /// to post to the SNS topic. The <code>topic-not-exist</code> status indicates that the
        /// topic was deleted after the subscription was created.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the Amazon DocumentDB event notification subscription.</p>
        /// <p>Constraints:</p>
        /// <p>Can be one of the following: <code>creating</code>, <code>modifying</code>,
        /// <code>deleting</code>, <code>active</code>, <code>no-permission</code>,
        /// <code>topic-not-exist</code>
        /// </p>
        /// <p>The <code>no-permission</code> status indicates that Amazon DocumentDB no longer has permission
        /// to post to the SNS topic. The <code>topic-not-exist</code> status indicates that the
        /// topic was deleted after the subscription was created.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The time at which the Amazon DocumentDB event notification subscription was created.</p>
        pub fn subscription_creation_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_creation_time = Some(input.into());
            self
        }
        /// <p>The time at which the Amazon DocumentDB event notification subscription was created.</p>
        pub fn set_subscription_creation_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_creation_time = input;
            self
        }
        /// <p>The source type for the Amazon DocumentDB event notification subscription.</p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_type = Some(input.into());
            self
        }
        /// <p>The source type for the Amazon DocumentDB event notification subscription.</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_type = input;
            self
        }
        /// Appends an item to `source_ids_list`.
        ///
        /// To override the contents of this collection use [`set_source_ids_list`](Self::set_source_ids_list).
        ///
        /// <p>A list of source IDs for the Amazon DocumentDB event notification subscription.</p>
        pub fn source_ids_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.source_ids_list.unwrap_or_default();
            v.push(input.into());
            self.source_ids_list = Some(v);
            self
        }
        /// <p>A list of source IDs for the Amazon DocumentDB event notification subscription.</p>
        pub fn set_source_ids_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.source_ids_list = input;
            self
        }
        /// Appends an item to `event_categories_list`.
        ///
        /// To override the contents of this collection use [`set_event_categories_list`](Self::set_event_categories_list).
        ///
        /// <p>A list of event categories for the Amazon DocumentDB event notification subscription.</p>
        pub fn event_categories_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_categories_list.unwrap_or_default();
            v.push(input.into());
            self.event_categories_list = Some(v);
            self
        }
        /// <p>A list of event categories for the Amazon DocumentDB event notification subscription.</p>
        pub fn set_event_categories_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_categories_list = input;
            self
        }
        /// <p>A Boolean value indicating whether the subscription is enabled. A value of
        /// <code>true</code> indicates that the subscription is enabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>A Boolean value indicating whether the subscription is enabled. A value of
        /// <code>true</code> indicates that the subscription is enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the event subscription.</p>
        pub fn event_subscription_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_subscription_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the event subscription.</p>
        pub fn set_event_subscription_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_subscription_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`EventSubscription`](crate::model::EventSubscription)
        pub fn build(self) -> crate::model::EventSubscription {
            crate::model::EventSubscription {
                customer_aws_id: self.customer_aws_id,
                cust_subscription_id: self.cust_subscription_id,
                sns_topic_arn: self.sns_topic_arn,
                status: self.status,
                subscription_creation_time: self.subscription_creation_time,
                source_type: self.source_type,
                source_ids_list: self.source_ids_list,
                event_categories_list: self.event_categories_list,
                enabled: self.enabled.unwrap_or_default(),
                event_subscription_arn: self.event_subscription_arn,
            }
        }
    }
}
impl EventSubscription {
    /// Creates a new builder-style object to manufacture [`EventSubscription`](crate::model::EventSubscription)
    pub fn builder() -> crate::model::event_subscription::Builder {
        crate::model::event_subscription::Builder::default()
    }
}

/// <p>A data type representing an Amazon DocumentDB global cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GlobalCluster {
    /// <p>Contains a user-supplied global  cluster identifier. This identifier is the unique key that identifies a global cluster. </p>
    pub global_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The Region-unique, immutable identifier for the global database cluster. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS customer master key (CMK) for the cluster is accessed. </p>
    pub global_cluster_resource_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the global cluster.</p>
    pub global_cluster_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the current state of this global cluster.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The Amazon DocumentDB database engine used by the global cluster. </p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>Indicates the database engine version.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The default database name within the new global cluster.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>The storage encryption setting for the global cluster.</p>
    pub storage_encrypted: std::option::Option<bool>,
    /// <p>The deletion protection setting for the new global cluster.</p>
    pub deletion_protection: std::option::Option<bool>,
    /// <p>The list of cluster IDs for secondary clusters within the global cluster. Currently limited to one item. </p>
    pub global_cluster_members:
        std::option::Option<std::vec::Vec<crate::model::GlobalClusterMember>>,
}
impl GlobalCluster {
    /// <p>Contains a user-supplied global  cluster identifier. This identifier is the unique key that identifies a global cluster. </p>
    pub fn global_cluster_identifier(&self) -> std::option::Option<&str> {
        self.global_cluster_identifier.as_deref()
    }
    /// <p>The Region-unique, immutable identifier for the global database cluster. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS customer master key (CMK) for the cluster is accessed. </p>
    pub fn global_cluster_resource_id(&self) -> std::option::Option<&str> {
        self.global_cluster_resource_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the global cluster.</p>
    pub fn global_cluster_arn(&self) -> std::option::Option<&str> {
        self.global_cluster_arn.as_deref()
    }
    /// <p>Specifies the current state of this global cluster.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The Amazon DocumentDB database engine used by the global cluster. </p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>Indicates the database engine version.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The default database name within the new global cluster.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>The storage encryption setting for the global cluster.</p>
    pub fn storage_encrypted(&self) -> std::option::Option<bool> {
        self.storage_encrypted
    }
    /// <p>The deletion protection setting for the new global cluster.</p>
    pub fn deletion_protection(&self) -> std::option::Option<bool> {
        self.deletion_protection
    }
    /// <p>The list of cluster IDs for secondary clusters within the global cluster. Currently limited to one item. </p>
    pub fn global_cluster_members(
        &self,
    ) -> std::option::Option<&[crate::model::GlobalClusterMember]> {
        self.global_cluster_members.as_deref()
    }
}
impl std::fmt::Debug for GlobalCluster {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GlobalCluster");
        formatter.field("global_cluster_identifier", &self.global_cluster_identifier);
        formatter.field(
            "global_cluster_resource_id",
            &self.global_cluster_resource_id,
        );
        formatter.field("global_cluster_arn", &self.global_cluster_arn);
        formatter.field("status", &self.status);
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("database_name", &self.database_name);
        formatter.field("storage_encrypted", &self.storage_encrypted);
        formatter.field("deletion_protection", &self.deletion_protection);
        formatter.field("global_cluster_members", &self.global_cluster_members);
        formatter.finish()
    }
}
/// See [`GlobalCluster`](crate::model::GlobalCluster)
pub mod global_cluster {
    /// A builder for [`GlobalCluster`](crate::model::GlobalCluster)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) global_cluster_resource_id: std::option::Option<std::string::String>,
        pub(crate) global_cluster_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) storage_encrypted: std::option::Option<bool>,
        pub(crate) deletion_protection: std::option::Option<bool>,
        pub(crate) global_cluster_members:
            std::option::Option<std::vec::Vec<crate::model::GlobalClusterMember>>,
    }
    impl Builder {
        /// <p>Contains a user-supplied global  cluster identifier. This identifier is the unique key that identifies a global cluster. </p>
        pub fn global_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_cluster_identifier = Some(input.into());
            self
        }
        /// <p>Contains a user-supplied global  cluster identifier. This identifier is the unique key that identifies a global cluster. </p>
        pub fn set_global_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_cluster_identifier = input;
            self
        }
        /// <p>The Region-unique, immutable identifier for the global database cluster. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS customer master key (CMK) for the cluster is accessed. </p>
        pub fn global_cluster_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_cluster_resource_id = Some(input.into());
            self
        }
        /// <p>The Region-unique, immutable identifier for the global database cluster. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS customer master key (CMK) for the cluster is accessed. </p>
        pub fn set_global_cluster_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_cluster_resource_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the global cluster.</p>
        pub fn global_cluster_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_cluster_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the global cluster.</p>
        pub fn set_global_cluster_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_cluster_arn = input;
            self
        }
        /// <p>Specifies the current state of this global cluster.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Specifies the current state of this global cluster.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon DocumentDB database engine used by the global cluster. </p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The Amazon DocumentDB database engine used by the global cluster. </p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>Indicates the database engine version.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>Indicates the database engine version.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The default database name within the new global cluster.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The default database name within the new global cluster.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>The storage encryption setting for the global cluster.</p>
        pub fn storage_encrypted(mut self, input: bool) -> Self {
            self.storage_encrypted = Some(input);
            self
        }
        /// <p>The storage encryption setting for the global cluster.</p>
        pub fn set_storage_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.storage_encrypted = input;
            self
        }
        /// <p>The deletion protection setting for the new global cluster.</p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.deletion_protection = Some(input);
            self
        }
        /// <p>The deletion protection setting for the new global cluster.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection = input;
            self
        }
        /// Appends an item to `global_cluster_members`.
        ///
        /// To override the contents of this collection use [`set_global_cluster_members`](Self::set_global_cluster_members).
        ///
        /// <p>The list of cluster IDs for secondary clusters within the global cluster. Currently limited to one item. </p>
        pub fn global_cluster_members(
            mut self,
            input: impl Into<crate::model::GlobalClusterMember>,
        ) -> Self {
            let mut v = self.global_cluster_members.unwrap_or_default();
            v.push(input.into());
            self.global_cluster_members = Some(v);
            self
        }
        /// <p>The list of cluster IDs for secondary clusters within the global cluster. Currently limited to one item. </p>
        pub fn set_global_cluster_members(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GlobalClusterMember>>,
        ) -> Self {
            self.global_cluster_members = input;
            self
        }
        /// Consumes the builder and constructs a [`GlobalCluster`](crate::model::GlobalCluster)
        pub fn build(self) -> crate::model::GlobalCluster {
            crate::model::GlobalCluster {
                global_cluster_identifier: self.global_cluster_identifier,
                global_cluster_resource_id: self.global_cluster_resource_id,
                global_cluster_arn: self.global_cluster_arn,
                status: self.status,
                engine: self.engine,
                engine_version: self.engine_version,
                database_name: self.database_name,
                storage_encrypted: self.storage_encrypted,
                deletion_protection: self.deletion_protection,
                global_cluster_members: self.global_cluster_members,
            }
        }
    }
}
impl GlobalCluster {
    /// Creates a new builder-style object to manufacture [`GlobalCluster`](crate::model::GlobalCluster)
    pub fn builder() -> crate::model::global_cluster::Builder {
        crate::model::global_cluster::Builder::default()
    }
}

/// <p>A data structure with information about any primary and secondary clusters associated with an Amazon DocumentDB global clusters. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GlobalClusterMember {
    /// <p>The Amazon Resource Name (ARN) for each Amazon DocumentDB cluster.</p>
    pub db_cluster_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the Aurora global cluster.</p>
    pub readers: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> Specifies whether the Amazon DocumentDB cluster is the primary cluster (that is, has read-write capability) for the Amazon DocumentDB global cluster with which it is associated. </p>
    pub is_writer: bool,
}
impl GlobalClusterMember {
    /// <p>The Amazon Resource Name (ARN) for each Amazon DocumentDB cluster.</p>
    pub fn db_cluster_arn(&self) -> std::option::Option<&str> {
        self.db_cluster_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the Aurora global cluster.</p>
    pub fn readers(&self) -> std::option::Option<&[std::string::String]> {
        self.readers.as_deref()
    }
    /// <p> Specifies whether the Amazon DocumentDB cluster is the primary cluster (that is, has read-write capability) for the Amazon DocumentDB global cluster with which it is associated. </p>
    pub fn is_writer(&self) -> bool {
        self.is_writer
    }
}
impl std::fmt::Debug for GlobalClusterMember {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GlobalClusterMember");
        formatter.field("db_cluster_arn", &self.db_cluster_arn);
        formatter.field("readers", &self.readers);
        formatter.field("is_writer", &self.is_writer);
        formatter.finish()
    }
}
/// See [`GlobalClusterMember`](crate::model::GlobalClusterMember)
pub mod global_cluster_member {
    /// A builder for [`GlobalClusterMember`](crate::model::GlobalClusterMember)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_arn: std::option::Option<std::string::String>,
        pub(crate) readers: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) is_writer: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for each Amazon DocumentDB cluster.</p>
        pub fn db_cluster_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for each Amazon DocumentDB cluster.</p>
        pub fn set_db_cluster_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_arn = input;
            self
        }
        /// Appends an item to `readers`.
        ///
        /// To override the contents of this collection use [`set_readers`](Self::set_readers).
        ///
        /// <p>The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the Aurora global cluster.</p>
        pub fn readers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.readers.unwrap_or_default();
            v.push(input.into());
            self.readers = Some(v);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the Aurora global cluster.</p>
        pub fn set_readers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.readers = input;
            self
        }
        /// <p> Specifies whether the Amazon DocumentDB cluster is the primary cluster (that is, has read-write capability) for the Amazon DocumentDB global cluster with which it is associated. </p>
        pub fn is_writer(mut self, input: bool) -> Self {
            self.is_writer = Some(input);
            self
        }
        /// <p> Specifies whether the Amazon DocumentDB cluster is the primary cluster (that is, has read-write capability) for the Amazon DocumentDB global cluster with which it is associated. </p>
        pub fn set_is_writer(mut self, input: std::option::Option<bool>) -> Self {
            self.is_writer = input;
            self
        }
        /// Consumes the builder and constructs a [`GlobalClusterMember`](crate::model::GlobalClusterMember)
        pub fn build(self) -> crate::model::GlobalClusterMember {
            crate::model::GlobalClusterMember {
                db_cluster_arn: self.db_cluster_arn,
                readers: self.readers,
                is_writer: self.is_writer.unwrap_or_default(),
            }
        }
    }
}
impl GlobalClusterMember {
    /// Creates a new builder-style object to manufacture [`GlobalClusterMember`](crate::model::GlobalClusterMember)
    pub fn builder() -> crate::model::global_cluster_member::Builder {
        crate::model::global_cluster_member::Builder::default()
    }
}

/// <p>Detailed information about an instance. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbInstance {
    /// <p>Contains a user-provided database identifier. This identifier is the unique key that
    /// identifies an instance.</p>
    pub db_instance_identifier: std::option::Option<std::string::String>,
    /// <p>Contains the name of the compute and memory capacity class of the instance.</p>
    pub db_instance_class: std::option::Option<std::string::String>,
    /// <p>Provides the name of the database engine to be used for this instance.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>Specifies the current state of this database.</p>
    pub db_instance_status: std::option::Option<std::string::String>,
    /// <p>Specifies the connection endpoint.</p>
    pub endpoint: std::option::Option<crate::model::Endpoint>,
    /// <p>Provides the date and time that the instance was created.</p>
    pub instance_create_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p> Specifies the daily time range during which automated backups are created if
    /// automated backups are enabled, as determined by the <code>BackupRetentionPeriod</code>.
    /// </p>
    pub preferred_backup_window: std::option::Option<std::string::String>,
    /// <p>Specifies the number of days for which automatic snapshots are retained.</p>
    pub backup_retention_period: i32,
    /// <p>Provides a list of VPC security group elements that the instance belongs to.</p>
    pub vpc_security_groups:
        std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
    /// <p>Specifies the name of the Availability Zone that the instance is located in.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>Specifies information on the subnet group that is associated with the instance, including the name, description, and subnets in the subnet group.</p>
    pub db_subnet_group: std::option::Option<crate::model::DbSubnetGroup>,
    /// <p>Specifies the weekly time range during which system maintenance can occur, in
    /// Universal Coordinated Time (UTC).</p>
    pub preferred_maintenance_window: std::option::Option<std::string::String>,
    /// <p>Specifies that changes to the instance are pending. This element is included only when changes are pending. Specific changes are identified by subelements.</p>
    pub pending_modified_values: std::option::Option<crate::model::PendingModifiedValues>,
    /// <p>Specifies the latest time to which a database can be restored with point-in-time
    /// restore.</p>
    pub latest_restorable_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Indicates the database engine version.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>Does not apply. This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.</p>
    pub auto_minor_version_upgrade: bool,
    /// <p>Not supported. Amazon DocumentDB does not currently support public endpoints. The value
    /// of <code>PubliclyAccessible</code> is always <code>false</code>.</p>
    pub publicly_accessible: bool,
    /// <p>The status of a read replica. If the instance is not a read replica, this is
    /// blank.</p>
    pub status_infos: std::option::Option<std::vec::Vec<crate::model::DbInstanceStatusInfo>>,
    /// <p>Contains the name of the cluster that the instance is a member of if the
    /// instance is a member of a cluster.</p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>Specifies whether or not the instance is encrypted.</p>
    pub storage_encrypted: bool,
    /// <p> If <code>StorageEncrypted</code> is <code>true</code>, the KMS key identifier for
    /// the encrypted instance. </p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The Region-unique, immutable identifier for the instance. This identifier is found in CloudTrail log entries whenever the KMS key for the instance is
    /// accessed.</p>
    pub dbi_resource_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the CA certificate for this DB instance.</p>
    pub ca_certificate_identifier: std::option::Option<std::string::String>,
    /// <p>A value that specifies the order in which an Amazon DocumentDB replica is promoted to the
    /// primary instance after a failure of the existing primary instance.</p>
    pub promotion_tier: std::option::Option<i32>,
    /// <p>The Amazon Resource Name (ARN) for the instance.</p>
    pub db_instance_arn: std::option::Option<std::string::String>,
    /// <p>A list of log types that this instance is configured to export to CloudWatch Logs.</p>
    pub enabled_cloudwatch_logs_exports: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DbInstance {
    /// <p>Contains a user-provided database identifier. This identifier is the unique key that
    /// identifies an instance.</p>
    pub fn db_instance_identifier(&self) -> std::option::Option<&str> {
        self.db_instance_identifier.as_deref()
    }
    /// <p>Contains the name of the compute and memory capacity class of the instance.</p>
    pub fn db_instance_class(&self) -> std::option::Option<&str> {
        self.db_instance_class.as_deref()
    }
    /// <p>Provides the name of the database engine to be used for this instance.</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>Specifies the current state of this database.</p>
    pub fn db_instance_status(&self) -> std::option::Option<&str> {
        self.db_instance_status.as_deref()
    }
    /// <p>Specifies the connection endpoint.</p>
    pub fn endpoint(&self) -> std::option::Option<&crate::model::Endpoint> {
        self.endpoint.as_ref()
    }
    /// <p>Provides the date and time that the instance was created.</p>
    pub fn instance_create_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.instance_create_time.as_ref()
    }
    /// <p> Specifies the daily time range during which automated backups are created if
    /// automated backups are enabled, as determined by the <code>BackupRetentionPeriod</code>.
    /// </p>
    pub fn preferred_backup_window(&self) -> std::option::Option<&str> {
        self.preferred_backup_window.as_deref()
    }
    /// <p>Specifies the number of days for which automatic snapshots are retained.</p>
    pub fn backup_retention_period(&self) -> i32 {
        self.backup_retention_period
    }
    /// <p>Provides a list of VPC security group elements that the instance belongs to.</p>
    pub fn vpc_security_groups(
        &self,
    ) -> std::option::Option<&[crate::model::VpcSecurityGroupMembership]> {
        self.vpc_security_groups.as_deref()
    }
    /// <p>Specifies the name of the Availability Zone that the instance is located in.</p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>Specifies information on the subnet group that is associated with the instance, including the name, description, and subnets in the subnet group.</p>
    pub fn db_subnet_group(&self) -> std::option::Option<&crate::model::DbSubnetGroup> {
        self.db_subnet_group.as_ref()
    }
    /// <p>Specifies the weekly time range during which system maintenance can occur, in
    /// Universal Coordinated Time (UTC).</p>
    pub fn preferred_maintenance_window(&self) -> std::option::Option<&str> {
        self.preferred_maintenance_window.as_deref()
    }
    /// <p>Specifies that changes to the instance are pending. This element is included only when changes are pending. Specific changes are identified by subelements.</p>
    pub fn pending_modified_values(
        &self,
    ) -> std::option::Option<&crate::model::PendingModifiedValues> {
        self.pending_modified_values.as_ref()
    }
    /// <p>Specifies the latest time to which a database can be restored with point-in-time
    /// restore.</p>
    pub fn latest_restorable_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.latest_restorable_time.as_ref()
    }
    /// <p>Indicates the database engine version.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>Does not apply. This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.</p>
    pub fn auto_minor_version_upgrade(&self) -> bool {
        self.auto_minor_version_upgrade
    }
    /// <p>Not supported. Amazon DocumentDB does not currently support public endpoints. The value
    /// of <code>PubliclyAccessible</code> is always <code>false</code>.</p>
    pub fn publicly_accessible(&self) -> bool {
        self.publicly_accessible
    }
    /// <p>The status of a read replica. If the instance is not a read replica, this is
    /// blank.</p>
    pub fn status_infos(&self) -> std::option::Option<&[crate::model::DbInstanceStatusInfo]> {
        self.status_infos.as_deref()
    }
    /// <p>Contains the name of the cluster that the instance is a member of if the
    /// instance is a member of a cluster.</p>
    pub fn db_cluster_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_identifier.as_deref()
    }
    /// <p>Specifies whether or not the instance is encrypted.</p>
    pub fn storage_encrypted(&self) -> bool {
        self.storage_encrypted
    }
    /// <p> If <code>StorageEncrypted</code> is <code>true</code>, the KMS key identifier for
    /// the encrypted instance. </p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The Region-unique, immutable identifier for the instance. This identifier is found in CloudTrail log entries whenever the KMS key for the instance is
    /// accessed.</p>
    pub fn dbi_resource_id(&self) -> std::option::Option<&str> {
        self.dbi_resource_id.as_deref()
    }
    /// <p>The identifier of the CA certificate for this DB instance.</p>
    pub fn ca_certificate_identifier(&self) -> std::option::Option<&str> {
        self.ca_certificate_identifier.as_deref()
    }
    /// <p>A value that specifies the order in which an Amazon DocumentDB replica is promoted to the
    /// primary instance after a failure of the existing primary instance.</p>
    pub fn promotion_tier(&self) -> std::option::Option<i32> {
        self.promotion_tier
    }
    /// <p>The Amazon Resource Name (ARN) for the instance.</p>
    pub fn db_instance_arn(&self) -> std::option::Option<&str> {
        self.db_instance_arn.as_deref()
    }
    /// <p>A list of log types that this instance is configured to export to CloudWatch Logs.</p>
    pub fn enabled_cloudwatch_logs_exports(&self) -> std::option::Option<&[std::string::String]> {
        self.enabled_cloudwatch_logs_exports.as_deref()
    }
}
impl std::fmt::Debug for DbInstance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbInstance");
        formatter.field("db_instance_identifier", &self.db_instance_identifier);
        formatter.field("db_instance_class", &self.db_instance_class);
        formatter.field("engine", &self.engine);
        formatter.field("db_instance_status", &self.db_instance_status);
        formatter.field("endpoint", &self.endpoint);
        formatter.field("instance_create_time", &self.instance_create_time);
        formatter.field("preferred_backup_window", &self.preferred_backup_window);
        formatter.field("backup_retention_period", &self.backup_retention_period);
        formatter.field("vpc_security_groups", &self.vpc_security_groups);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("db_subnet_group", &self.db_subnet_group);
        formatter.field(
            "preferred_maintenance_window",
            &self.preferred_maintenance_window,
        );
        formatter.field("pending_modified_values", &self.pending_modified_values);
        formatter.field("latest_restorable_time", &self.latest_restorable_time);
        formatter.field("engine_version", &self.engine_version);
        formatter.field(
            "auto_minor_version_upgrade",
            &self.auto_minor_version_upgrade,
        );
        formatter.field("publicly_accessible", &self.publicly_accessible);
        formatter.field("status_infos", &self.status_infos);
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field("storage_encrypted", &self.storage_encrypted);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("dbi_resource_id", &self.dbi_resource_id);
        formatter.field("ca_certificate_identifier", &self.ca_certificate_identifier);
        formatter.field("promotion_tier", &self.promotion_tier);
        formatter.field("db_instance_arn", &self.db_instance_arn);
        formatter.field(
            "enabled_cloudwatch_logs_exports",
            &self.enabled_cloudwatch_logs_exports,
        );
        formatter.finish()
    }
}
/// See [`DbInstance`](crate::model::DbInstance)
pub mod db_instance {
    /// A builder for [`DbInstance`](crate::model::DbInstance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) db_instance_class: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) db_instance_status: std::option::Option<std::string::String>,
        pub(crate) endpoint: std::option::Option<crate::model::Endpoint>,
        pub(crate) instance_create_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) preferred_backup_window: std::option::Option<std::string::String>,
        pub(crate) backup_retention_period: std::option::Option<i32>,
        pub(crate) vpc_security_groups:
            std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) db_subnet_group: std::option::Option<crate::model::DbSubnetGroup>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) pending_modified_values:
            std::option::Option<crate::model::PendingModifiedValues>,
        pub(crate) latest_restorable_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) auto_minor_version_upgrade: std::option::Option<bool>,
        pub(crate) publicly_accessible: std::option::Option<bool>,
        pub(crate) status_infos:
            std::option::Option<std::vec::Vec<crate::model::DbInstanceStatusInfo>>,
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) storage_encrypted: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) dbi_resource_id: std::option::Option<std::string::String>,
        pub(crate) ca_certificate_identifier: std::option::Option<std::string::String>,
        pub(crate) promotion_tier: std::option::Option<i32>,
        pub(crate) db_instance_arn: std::option::Option<std::string::String>,
        pub(crate) enabled_cloudwatch_logs_exports:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Contains a user-provided database identifier. This identifier is the unique key that
        /// identifies an instance.</p>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p>Contains a user-provided database identifier. This identifier is the unique key that
        /// identifies an instance.</p>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// <p>Contains the name of the compute and memory capacity class of the instance.</p>
        pub fn db_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_class = Some(input.into());
            self
        }
        /// <p>Contains the name of the compute and memory capacity class of the instance.</p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_class = input;
            self
        }
        /// <p>Provides the name of the database engine to be used for this instance.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>Provides the name of the database engine to be used for this instance.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>Specifies the current state of this database.</p>
        pub fn db_instance_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_status = Some(input.into());
            self
        }
        /// <p>Specifies the current state of this database.</p>
        pub fn set_db_instance_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_status = input;
            self
        }
        /// <p>Specifies the connection endpoint.</p>
        pub fn endpoint(mut self, input: crate::model::Endpoint) -> Self {
            self.endpoint = Some(input);
            self
        }
        /// <p>Specifies the connection endpoint.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<crate::model::Endpoint>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>Provides the date and time that the instance was created.</p>
        pub fn instance_create_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.instance_create_time = Some(input);
            self
        }
        /// <p>Provides the date and time that the instance was created.</p>
        pub fn set_instance_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.instance_create_time = input;
            self
        }
        /// <p> Specifies the daily time range during which automated backups are created if
        /// automated backups are enabled, as determined by the <code>BackupRetentionPeriod</code>.
        /// </p>
        pub fn preferred_backup_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.preferred_backup_window = Some(input.into());
            self
        }
        /// <p> Specifies the daily time range during which automated backups are created if
        /// automated backups are enabled, as determined by the <code>BackupRetentionPeriod</code>.
        /// </p>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_backup_window = input;
            self
        }
        /// <p>Specifies the number of days for which automatic snapshots are retained.</p>
        pub fn backup_retention_period(mut self, input: i32) -> Self {
            self.backup_retention_period = Some(input);
            self
        }
        /// <p>Specifies the number of days for which automatic snapshots are retained.</p>
        pub fn set_backup_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.backup_retention_period = input;
            self
        }
        /// Appends an item to `vpc_security_groups`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_groups`](Self::set_vpc_security_groups).
        ///
        /// <p>Provides a list of VPC security group elements that the instance belongs to.</p>
        pub fn vpc_security_groups(
            mut self,
            input: impl Into<crate::model::VpcSecurityGroupMembership>,
        ) -> Self {
            let mut v = self.vpc_security_groups.unwrap_or_default();
            v.push(input.into());
            self.vpc_security_groups = Some(v);
            self
        }
        /// <p>Provides a list of VPC security group elements that the instance belongs to.</p>
        pub fn set_vpc_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
        ) -> Self {
            self.vpc_security_groups = input;
            self
        }
        /// <p>Specifies the name of the Availability Zone that the instance is located in.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>Specifies the name of the Availability Zone that the instance is located in.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>Specifies information on the subnet group that is associated with the instance, including the name, description, and subnets in the subnet group.</p>
        pub fn db_subnet_group(mut self, input: crate::model::DbSubnetGroup) -> Self {
            self.db_subnet_group = Some(input);
            self
        }
        /// <p>Specifies information on the subnet group that is associated with the instance, including the name, description, and subnets in the subnet group.</p>
        pub fn set_db_subnet_group(
            mut self,
            input: std::option::Option<crate::model::DbSubnetGroup>,
        ) -> Self {
            self.db_subnet_group = input;
            self
        }
        /// <p>Specifies the weekly time range during which system maintenance can occur, in
        /// Universal Coordinated Time (UTC).</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>Specifies the weekly time range during which system maintenance can occur, in
        /// Universal Coordinated Time (UTC).</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p>Specifies that changes to the instance are pending. This element is included only when changes are pending. Specific changes are identified by subelements.</p>
        pub fn pending_modified_values(
            mut self,
            input: crate::model::PendingModifiedValues,
        ) -> Self {
            self.pending_modified_values = Some(input);
            self
        }
        /// <p>Specifies that changes to the instance are pending. This element is included only when changes are pending. Specific changes are identified by subelements.</p>
        pub fn set_pending_modified_values(
            mut self,
            input: std::option::Option<crate::model::PendingModifiedValues>,
        ) -> Self {
            self.pending_modified_values = input;
            self
        }
        /// <p>Specifies the latest time to which a database can be restored with point-in-time
        /// restore.</p>
        pub fn latest_restorable_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.latest_restorable_time = Some(input);
            self
        }
        /// <p>Specifies the latest time to which a database can be restored with point-in-time
        /// restore.</p>
        pub fn set_latest_restorable_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.latest_restorable_time = input;
            self
        }
        /// <p>Indicates the database engine version.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>Indicates the database engine version.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>Does not apply. This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.</p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.auto_minor_version_upgrade = Some(input);
            self
        }
        /// <p>Does not apply. This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.</p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_minor_version_upgrade = input;
            self
        }
        /// <p>Not supported. Amazon DocumentDB does not currently support public endpoints. The value
        /// of <code>PubliclyAccessible</code> is always <code>false</code>.</p>
        pub fn publicly_accessible(mut self, input: bool) -> Self {
            self.publicly_accessible = Some(input);
            self
        }
        /// <p>Not supported. Amazon DocumentDB does not currently support public endpoints. The value
        /// of <code>PubliclyAccessible</code> is always <code>false</code>.</p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.publicly_accessible = input;
            self
        }
        /// Appends an item to `status_infos`.
        ///
        /// To override the contents of this collection use [`set_status_infos`](Self::set_status_infos).
        ///
        /// <p>The status of a read replica. If the instance is not a read replica, this is
        /// blank.</p>
        pub fn status_infos(
            mut self,
            input: impl Into<crate::model::DbInstanceStatusInfo>,
        ) -> Self {
            let mut v = self.status_infos.unwrap_or_default();
            v.push(input.into());
            self.status_infos = Some(v);
            self
        }
        /// <p>The status of a read replica. If the instance is not a read replica, this is
        /// blank.</p>
        pub fn set_status_infos(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbInstanceStatusInfo>>,
        ) -> Self {
            self.status_infos = input;
            self
        }
        /// <p>Contains the name of the cluster that the instance is a member of if the
        /// instance is a member of a cluster.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>Contains the name of the cluster that the instance is a member of if the
        /// instance is a member of a cluster.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>Specifies whether or not the instance is encrypted.</p>
        pub fn storage_encrypted(mut self, input: bool) -> Self {
            self.storage_encrypted = Some(input);
            self
        }
        /// <p>Specifies whether or not the instance is encrypted.</p>
        pub fn set_storage_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.storage_encrypted = input;
            self
        }
        /// <p> If <code>StorageEncrypted</code> is <code>true</code>, the KMS key identifier for
        /// the encrypted instance. </p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p> If <code>StorageEncrypted</code> is <code>true</code>, the KMS key identifier for
        /// the encrypted instance. </p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The Region-unique, immutable identifier for the instance. This identifier is found in CloudTrail log entries whenever the KMS key for the instance is
        /// accessed.</p>
        pub fn dbi_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dbi_resource_id = Some(input.into());
            self
        }
        /// <p>The Region-unique, immutable identifier for the instance. This identifier is found in CloudTrail log entries whenever the KMS key for the instance is
        /// accessed.</p>
        pub fn set_dbi_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dbi_resource_id = input;
            self
        }
        /// <p>The identifier of the CA certificate for this DB instance.</p>
        pub fn ca_certificate_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.ca_certificate_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the CA certificate for this DB instance.</p>
        pub fn set_ca_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ca_certificate_identifier = input;
            self
        }
        /// <p>A value that specifies the order in which an Amazon DocumentDB replica is promoted to the
        /// primary instance after a failure of the existing primary instance.</p>
        pub fn promotion_tier(mut self, input: i32) -> Self {
            self.promotion_tier = Some(input);
            self
        }
        /// <p>A value that specifies the order in which an Amazon DocumentDB replica is promoted to the
        /// primary instance after a failure of the existing primary instance.</p>
        pub fn set_promotion_tier(mut self, input: std::option::Option<i32>) -> Self {
            self.promotion_tier = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the instance.</p>
        pub fn db_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the instance.</p>
        pub fn set_db_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_arn = input;
            self
        }
        /// Appends an item to `enabled_cloudwatch_logs_exports`.
        ///
        /// To override the contents of this collection use [`set_enabled_cloudwatch_logs_exports`](Self::set_enabled_cloudwatch_logs_exports).
        ///
        /// <p>A list of log types that this instance is configured to export to CloudWatch Logs.</p>
        pub fn enabled_cloudwatch_logs_exports(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.enabled_cloudwatch_logs_exports.unwrap_or_default();
            v.push(input.into());
            self.enabled_cloudwatch_logs_exports = Some(v);
            self
        }
        /// <p>A list of log types that this instance is configured to export to CloudWatch Logs.</p>
        pub fn set_enabled_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.enabled_cloudwatch_logs_exports = input;
            self
        }
        /// Consumes the builder and constructs a [`DbInstance`](crate::model::DbInstance)
        pub fn build(self) -> crate::model::DbInstance {
            crate::model::DbInstance {
                db_instance_identifier: self.db_instance_identifier,
                db_instance_class: self.db_instance_class,
                engine: self.engine,
                db_instance_status: self.db_instance_status,
                endpoint: self.endpoint,
                instance_create_time: self.instance_create_time,
                preferred_backup_window: self.preferred_backup_window,
                backup_retention_period: self.backup_retention_period.unwrap_or_default(),
                vpc_security_groups: self.vpc_security_groups,
                availability_zone: self.availability_zone,
                db_subnet_group: self.db_subnet_group,
                preferred_maintenance_window: self.preferred_maintenance_window,
                pending_modified_values: self.pending_modified_values,
                latest_restorable_time: self.latest_restorable_time,
                engine_version: self.engine_version,
                auto_minor_version_upgrade: self.auto_minor_version_upgrade.unwrap_or_default(),
                publicly_accessible: self.publicly_accessible.unwrap_or_default(),
                status_infos: self.status_infos,
                db_cluster_identifier: self.db_cluster_identifier,
                storage_encrypted: self.storage_encrypted.unwrap_or_default(),
                kms_key_id: self.kms_key_id,
                dbi_resource_id: self.dbi_resource_id,
                ca_certificate_identifier: self.ca_certificate_identifier,
                promotion_tier: self.promotion_tier,
                db_instance_arn: self.db_instance_arn,
                enabled_cloudwatch_logs_exports: self.enabled_cloudwatch_logs_exports,
            }
        }
    }
}
impl DbInstance {
    /// Creates a new builder-style object to manufacture [`DbInstance`](crate::model::DbInstance)
    pub fn builder() -> crate::model::db_instance::Builder {
        crate::model::db_instance::Builder::default()
    }
}

/// <p>Provides a list of status information for an instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbInstanceStatusInfo {
    /// <p>This value is currently "<code>read replication</code>."</p>
    pub status_type: std::option::Option<std::string::String>,
    /// <p>A Boolean value that is <code>true</code> if the instance is operating normally, or
    /// <code>false</code> if the instance is in an error state.</p>
    pub normal: bool,
    /// <p>Status of the instance. For a <code>StatusType</code> of read replica, the values
    /// can be <code>replicating</code>, error, <code>stopped</code>, or
    /// <code>terminated</code>.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>Details of the error if there is an error for the instance. If the instance is not in
    /// an error state, this value is blank.</p>
    pub message: std::option::Option<std::string::String>,
}
impl DbInstanceStatusInfo {
    /// <p>This value is currently "<code>read replication</code>."</p>
    pub fn status_type(&self) -> std::option::Option<&str> {
        self.status_type.as_deref()
    }
    /// <p>A Boolean value that is <code>true</code> if the instance is operating normally, or
    /// <code>false</code> if the instance is in an error state.</p>
    pub fn normal(&self) -> bool {
        self.normal
    }
    /// <p>Status of the instance. For a <code>StatusType</code> of read replica, the values
    /// can be <code>replicating</code>, error, <code>stopped</code>, or
    /// <code>terminated</code>.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>Details of the error if there is an error for the instance. If the instance is not in
    /// an error state, this value is blank.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for DbInstanceStatusInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbInstanceStatusInfo");
        formatter.field("status_type", &self.status_type);
        formatter.field("normal", &self.normal);
        formatter.field("status", &self.status);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`DbInstanceStatusInfo`](crate::model::DbInstanceStatusInfo)
pub mod db_instance_status_info {
    /// A builder for [`DbInstanceStatusInfo`](crate::model::DbInstanceStatusInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status_type: std::option::Option<std::string::String>,
        pub(crate) normal: std::option::Option<bool>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>This value is currently "<code>read replication</code>."</p>
        pub fn status_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_type = Some(input.into());
            self
        }
        /// <p>This value is currently "<code>read replication</code>."</p>
        pub fn set_status_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status_type = input;
            self
        }
        /// <p>A Boolean value that is <code>true</code> if the instance is operating normally, or
        /// <code>false</code> if the instance is in an error state.</p>
        pub fn normal(mut self, input: bool) -> Self {
            self.normal = Some(input);
            self
        }
        /// <p>A Boolean value that is <code>true</code> if the instance is operating normally, or
        /// <code>false</code> if the instance is in an error state.</p>
        pub fn set_normal(mut self, input: std::option::Option<bool>) -> Self {
            self.normal = input;
            self
        }
        /// <p>Status of the instance. For a <code>StatusType</code> of read replica, the values
        /// can be <code>replicating</code>, error, <code>stopped</code>, or
        /// <code>terminated</code>.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Status of the instance. For a <code>StatusType</code> of read replica, the values
        /// can be <code>replicating</code>, error, <code>stopped</code>, or
        /// <code>terminated</code>.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>Details of the error if there is an error for the instance. If the instance is not in
        /// an error state, this value is blank.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Details of the error if there is an error for the instance. If the instance is not in
        /// an error state, this value is blank.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbInstanceStatusInfo`](crate::model::DbInstanceStatusInfo)
        pub fn build(self) -> crate::model::DbInstanceStatusInfo {
            crate::model::DbInstanceStatusInfo {
                status_type: self.status_type,
                normal: self.normal.unwrap_or_default(),
                status: self.status,
                message: self.message,
            }
        }
    }
}
impl DbInstanceStatusInfo {
    /// Creates a new builder-style object to manufacture [`DbInstanceStatusInfo`](crate::model::DbInstanceStatusInfo)
    pub fn builder() -> crate::model::db_instance_status_info::Builder {
        crate::model::db_instance_status_info::Builder::default()
    }
}

/// <p> One or more modified settings for an instance. These modified settings have been
/// requested, but haven't been applied yet.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PendingModifiedValues {
    /// <p> Contains the new <code>DBInstanceClass</code> for the instance that will be
    /// applied or is currently being applied. </p>
    pub db_instance_class: std::option::Option<std::string::String>,
    /// <p> Contains the new <code>AllocatedStorage</code> size for then instance that will be
    /// applied or is currently being applied. </p>
    pub allocated_storage: std::option::Option<i32>,
    /// <p>Contains the pending or currently in-progress change of the master credentials for the
    /// instance.</p>
    pub master_user_password: std::option::Option<std::string::String>,
    /// <p>Specifies the pending port for the instance.</p>
    pub port: std::option::Option<i32>,
    /// <p>Specifies the pending number of days for which automated backups are retained.</p>
    pub backup_retention_period: std::option::Option<i32>,
    /// <p>Indicates that the Single-AZ instance is to change to a Multi-AZ deployment.</p>
    pub multi_az: std::option::Option<bool>,
    /// <p>Indicates the database engine version.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The license model for the instance.</p>
    /// <p>Valid values: <code>license-included</code>, <code>bring-your-own-license</code>,
    /// <code>general-public-license</code>
    /// </p>
    pub license_model: std::option::Option<std::string::String>,
    /// <p>Specifies the new Provisioned IOPS value for the instance that will be applied or
    /// is currently being applied.</p>
    pub iops: std::option::Option<i32>,
    /// <p> Contains the new <code>DBInstanceIdentifier</code> for the instance that will be
    /// applied or is currently being applied. </p>
    pub db_instance_identifier: std::option::Option<std::string::String>,
    /// <p>Specifies the storage type to be associated with the instance.</p>
    pub storage_type: std::option::Option<std::string::String>,
    /// <p>Specifies the identifier of the certificate authority (CA) certificate for the DB
    /// instance.</p>
    pub ca_certificate_identifier: std::option::Option<std::string::String>,
    /// <p>The new subnet group for the instance. </p>
    pub db_subnet_group_name: std::option::Option<std::string::String>,
    /// <p>A list of the log types whose configuration is still pending. These log types are in
    /// the process of being activated or deactivated.</p>
    pub pending_cloudwatch_logs_exports:
        std::option::Option<crate::model::PendingCloudwatchLogsExports>,
}
impl PendingModifiedValues {
    /// <p> Contains the new <code>DBInstanceClass</code> for the instance that will be
    /// applied or is currently being applied. </p>
    pub fn db_instance_class(&self) -> std::option::Option<&str> {
        self.db_instance_class.as_deref()
    }
    /// <p> Contains the new <code>AllocatedStorage</code> size for then instance that will be
    /// applied or is currently being applied. </p>
    pub fn allocated_storage(&self) -> std::option::Option<i32> {
        self.allocated_storage
    }
    /// <p>Contains the pending or currently in-progress change of the master credentials for the
    /// instance.</p>
    pub fn master_user_password(&self) -> std::option::Option<&str> {
        self.master_user_password.as_deref()
    }
    /// <p>Specifies the pending port for the instance.</p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
    /// <p>Specifies the pending number of days for which automated backups are retained.</p>
    pub fn backup_retention_period(&self) -> std::option::Option<i32> {
        self.backup_retention_period
    }
    /// <p>Indicates that the Single-AZ instance is to change to a Multi-AZ deployment.</p>
    pub fn multi_az(&self) -> std::option::Option<bool> {
        self.multi_az
    }
    /// <p>Indicates the database engine version.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The license model for the instance.</p>
    /// <p>Valid values: <code>license-included</code>, <code>bring-your-own-license</code>,
    /// <code>general-public-license</code>
    /// </p>
    pub fn license_model(&self) -> std::option::Option<&str> {
        self.license_model.as_deref()
    }
    /// <p>Specifies the new Provisioned IOPS value for the instance that will be applied or
    /// is currently being applied.</p>
    pub fn iops(&self) -> std::option::Option<i32> {
        self.iops
    }
    /// <p> Contains the new <code>DBInstanceIdentifier</code> for the instance that will be
    /// applied or is currently being applied. </p>
    pub fn db_instance_identifier(&self) -> std::option::Option<&str> {
        self.db_instance_identifier.as_deref()
    }
    /// <p>Specifies the storage type to be associated with the instance.</p>
    pub fn storage_type(&self) -> std::option::Option<&str> {
        self.storage_type.as_deref()
    }
    /// <p>Specifies the identifier of the certificate authority (CA) certificate for the DB
    /// instance.</p>
    pub fn ca_certificate_identifier(&self) -> std::option::Option<&str> {
        self.ca_certificate_identifier.as_deref()
    }
    /// <p>The new subnet group for the instance. </p>
    pub fn db_subnet_group_name(&self) -> std::option::Option<&str> {
        self.db_subnet_group_name.as_deref()
    }
    /// <p>A list of the log types whose configuration is still pending. These log types are in
    /// the process of being activated or deactivated.</p>
    pub fn pending_cloudwatch_logs_exports(
        &self,
    ) -> std::option::Option<&crate::model::PendingCloudwatchLogsExports> {
        self.pending_cloudwatch_logs_exports.as_ref()
    }
}
impl std::fmt::Debug for PendingModifiedValues {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PendingModifiedValues");
        formatter.field("db_instance_class", &self.db_instance_class);
        formatter.field("allocated_storage", &self.allocated_storage);
        formatter.field("master_user_password", &self.master_user_password);
        formatter.field("port", &self.port);
        formatter.field("backup_retention_period", &self.backup_retention_period);
        formatter.field("multi_az", &self.multi_az);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("license_model", &self.license_model);
        formatter.field("iops", &self.iops);
        formatter.field("db_instance_identifier", &self.db_instance_identifier);
        formatter.field("storage_type", &self.storage_type);
        formatter.field("ca_certificate_identifier", &self.ca_certificate_identifier);
        formatter.field("db_subnet_group_name", &self.db_subnet_group_name);
        formatter.field(
            "pending_cloudwatch_logs_exports",
            &self.pending_cloudwatch_logs_exports,
        );
        formatter.finish()
    }
}
/// See [`PendingModifiedValues`](crate::model::PendingModifiedValues)
pub mod pending_modified_values {
    /// A builder for [`PendingModifiedValues`](crate::model::PendingModifiedValues)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance_class: std::option::Option<std::string::String>,
        pub(crate) allocated_storage: std::option::Option<i32>,
        pub(crate) master_user_password: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) backup_retention_period: std::option::Option<i32>,
        pub(crate) multi_az: std::option::Option<bool>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) license_model: std::option::Option<std::string::String>,
        pub(crate) iops: std::option::Option<i32>,
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) storage_type: std::option::Option<std::string::String>,
        pub(crate) ca_certificate_identifier: std::option::Option<std::string::String>,
        pub(crate) db_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) pending_cloudwatch_logs_exports:
            std::option::Option<crate::model::PendingCloudwatchLogsExports>,
    }
    impl Builder {
        /// <p> Contains the new <code>DBInstanceClass</code> for the instance that will be
        /// applied or is currently being applied. </p>
        pub fn db_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_class = Some(input.into());
            self
        }
        /// <p> Contains the new <code>DBInstanceClass</code> for the instance that will be
        /// applied or is currently being applied. </p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_class = input;
            self
        }
        /// <p> Contains the new <code>AllocatedStorage</code> size for then instance that will be
        /// applied or is currently being applied. </p>
        pub fn allocated_storage(mut self, input: i32) -> Self {
            self.allocated_storage = Some(input);
            self
        }
        /// <p> Contains the new <code>AllocatedStorage</code> size for then instance that will be
        /// applied or is currently being applied. </p>
        pub fn set_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.allocated_storage = input;
            self
        }
        /// <p>Contains the pending or currently in-progress change of the master credentials for the
        /// instance.</p>
        pub fn master_user_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_user_password = Some(input.into());
            self
        }
        /// <p>Contains the pending or currently in-progress change of the master credentials for the
        /// instance.</p>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_user_password = input;
            self
        }
        /// <p>Specifies the pending port for the instance.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>Specifies the pending port for the instance.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Specifies the pending number of days for which automated backups are retained.</p>
        pub fn backup_retention_period(mut self, input: i32) -> Self {
            self.backup_retention_period = Some(input);
            self
        }
        /// <p>Specifies the pending number of days for which automated backups are retained.</p>
        pub fn set_backup_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.backup_retention_period = input;
            self
        }
        /// <p>Indicates that the Single-AZ instance is to change to a Multi-AZ deployment.</p>
        pub fn multi_az(mut self, input: bool) -> Self {
            self.multi_az = Some(input);
            self
        }
        /// <p>Indicates that the Single-AZ instance is to change to a Multi-AZ deployment.</p>
        pub fn set_multi_az(mut self, input: std::option::Option<bool>) -> Self {
            self.multi_az = input;
            self
        }
        /// <p>Indicates the database engine version.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>Indicates the database engine version.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The license model for the instance.</p>
        /// <p>Valid values: <code>license-included</code>, <code>bring-your-own-license</code>,
        /// <code>general-public-license</code>
        /// </p>
        pub fn license_model(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_model = Some(input.into());
            self
        }
        /// <p>The license model for the instance.</p>
        /// <p>Valid values: <code>license-included</code>, <code>bring-your-own-license</code>,
        /// <code>general-public-license</code>
        /// </p>
        pub fn set_license_model(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_model = input;
            self
        }
        /// <p>Specifies the new Provisioned IOPS value for the instance that will be applied or
        /// is currently being applied.</p>
        pub fn iops(mut self, input: i32) -> Self {
            self.iops = Some(input);
            self
        }
        /// <p>Specifies the new Provisioned IOPS value for the instance that will be applied or
        /// is currently being applied.</p>
        pub fn set_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.iops = input;
            self
        }
        /// <p> Contains the new <code>DBInstanceIdentifier</code> for the instance that will be
        /// applied or is currently being applied. </p>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p> Contains the new <code>DBInstanceIdentifier</code> for the instance that will be
        /// applied or is currently being applied. </p>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// <p>Specifies the storage type to be associated with the instance.</p>
        pub fn storage_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.storage_type = Some(input.into());
            self
        }
        /// <p>Specifies the storage type to be associated with the instance.</p>
        pub fn set_storage_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.storage_type = input;
            self
        }
        /// <p>Specifies the identifier of the certificate authority (CA) certificate for the DB
        /// instance.</p>
        pub fn ca_certificate_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.ca_certificate_identifier = Some(input.into());
            self
        }
        /// <p>Specifies the identifier of the certificate authority (CA) certificate for the DB
        /// instance.</p>
        pub fn set_ca_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ca_certificate_identifier = input;
            self
        }
        /// <p>The new subnet group for the instance. </p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The new subnet group for the instance. </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_name = input;
            self
        }
        /// <p>A list of the log types whose configuration is still pending. These log types are in
        /// the process of being activated or deactivated.</p>
        pub fn pending_cloudwatch_logs_exports(
            mut self,
            input: crate::model::PendingCloudwatchLogsExports,
        ) -> Self {
            self.pending_cloudwatch_logs_exports = Some(input);
            self
        }
        /// <p>A list of the log types whose configuration is still pending. These log types are in
        /// the process of being activated or deactivated.</p>
        pub fn set_pending_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<crate::model::PendingCloudwatchLogsExports>,
        ) -> Self {
            self.pending_cloudwatch_logs_exports = input;
            self
        }
        /// Consumes the builder and constructs a [`PendingModifiedValues`](crate::model::PendingModifiedValues)
        pub fn build(self) -> crate::model::PendingModifiedValues {
            crate::model::PendingModifiedValues {
                db_instance_class: self.db_instance_class,
                allocated_storage: self.allocated_storage,
                master_user_password: self.master_user_password,
                port: self.port,
                backup_retention_period: self.backup_retention_period,
                multi_az: self.multi_az,
                engine_version: self.engine_version,
                license_model: self.license_model,
                iops: self.iops,
                db_instance_identifier: self.db_instance_identifier,
                storage_type: self.storage_type,
                ca_certificate_identifier: self.ca_certificate_identifier,
                db_subnet_group_name: self.db_subnet_group_name,
                pending_cloudwatch_logs_exports: self.pending_cloudwatch_logs_exports,
            }
        }
    }
}
impl PendingModifiedValues {
    /// Creates a new builder-style object to manufacture [`PendingModifiedValues`](crate::model::PendingModifiedValues)
    pub fn builder() -> crate::model::pending_modified_values::Builder {
        crate::model::pending_modified_values::Builder::default()
    }
}

/// <p>A list of the log types whose configuration is still pending. These log types are in
/// the process of being activated or deactivated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PendingCloudwatchLogsExports {
    /// <p>Log types that are in the process of being deactivated. After they are deactivated,
    /// these log types aren't exported to CloudWatch Logs.</p>
    pub log_types_to_enable: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Log types that are in the process of being enabled. After they are enabled, these log
    /// types are exported to Amazon CloudWatch Logs.</p>
    pub log_types_to_disable: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl PendingCloudwatchLogsExports {
    /// <p>Log types that are in the process of being deactivated. After they are deactivated,
    /// these log types aren't exported to CloudWatch Logs.</p>
    pub fn log_types_to_enable(&self) -> std::option::Option<&[std::string::String]> {
        self.log_types_to_enable.as_deref()
    }
    /// <p>Log types that are in the process of being enabled. After they are enabled, these log
    /// types are exported to Amazon CloudWatch Logs.</p>
    pub fn log_types_to_disable(&self) -> std::option::Option<&[std::string::String]> {
        self.log_types_to_disable.as_deref()
    }
}
impl std::fmt::Debug for PendingCloudwatchLogsExports {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PendingCloudwatchLogsExports");
        formatter.field("log_types_to_enable", &self.log_types_to_enable);
        formatter.field("log_types_to_disable", &self.log_types_to_disable);
        formatter.finish()
    }
}
/// See [`PendingCloudwatchLogsExports`](crate::model::PendingCloudwatchLogsExports)
pub mod pending_cloudwatch_logs_exports {
    /// A builder for [`PendingCloudwatchLogsExports`](crate::model::PendingCloudwatchLogsExports)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_types_to_enable: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) log_types_to_disable: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `log_types_to_enable`.
        ///
        /// To override the contents of this collection use [`set_log_types_to_enable`](Self::set_log_types_to_enable).
        ///
        /// <p>Log types that are in the process of being deactivated. After they are deactivated,
        /// these log types aren't exported to CloudWatch Logs.</p>
        pub fn log_types_to_enable(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.log_types_to_enable.unwrap_or_default();
            v.push(input.into());
            self.log_types_to_enable = Some(v);
            self
        }
        /// <p>Log types that are in the process of being deactivated. After they are deactivated,
        /// these log types aren't exported to CloudWatch Logs.</p>
        pub fn set_log_types_to_enable(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.log_types_to_enable = input;
            self
        }
        /// Appends an item to `log_types_to_disable`.
        ///
        /// To override the contents of this collection use [`set_log_types_to_disable`](Self::set_log_types_to_disable).
        ///
        /// <p>Log types that are in the process of being enabled. After they are enabled, these log
        /// types are exported to Amazon CloudWatch Logs.</p>
        pub fn log_types_to_disable(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.log_types_to_disable.unwrap_or_default();
            v.push(input.into());
            self.log_types_to_disable = Some(v);
            self
        }
        /// <p>Log types that are in the process of being enabled. After they are enabled, these log
        /// types are exported to Amazon CloudWatch Logs.</p>
        pub fn set_log_types_to_disable(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.log_types_to_disable = input;
            self
        }
        /// Consumes the builder and constructs a [`PendingCloudwatchLogsExports`](crate::model::PendingCloudwatchLogsExports)
        pub fn build(self) -> crate::model::PendingCloudwatchLogsExports {
            crate::model::PendingCloudwatchLogsExports {
                log_types_to_enable: self.log_types_to_enable,
                log_types_to_disable: self.log_types_to_disable,
            }
        }
    }
}
impl PendingCloudwatchLogsExports {
    /// Creates a new builder-style object to manufacture [`PendingCloudwatchLogsExports`](crate::model::PendingCloudwatchLogsExports)
    pub fn builder() -> crate::model::pending_cloudwatch_logs_exports::Builder {
        crate::model::pending_cloudwatch_logs_exports::Builder::default()
    }
}

/// <p>Detailed information about a subnet group. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbSubnetGroup {
    /// <p>The name of the subnet group.</p>
    pub db_subnet_group_name: std::option::Option<std::string::String>,
    /// <p>Provides the description of the subnet group.</p>
    pub db_subnet_group_description: std::option::Option<std::string::String>,
    /// <p>Provides the virtual private cloud (VPC) ID of the subnet group.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>Provides the status of the subnet group.</p>
    pub subnet_group_status: std::option::Option<std::string::String>,
    /// <p>Detailed information about one or more subnets within a subnet group.</p>
    pub subnets: std::option::Option<std::vec::Vec<crate::model::Subnet>>,
    /// <p>The Amazon Resource Name (ARN) for the DB subnet group.</p>
    pub db_subnet_group_arn: std::option::Option<std::string::String>,
}
impl DbSubnetGroup {
    /// <p>The name of the subnet group.</p>
    pub fn db_subnet_group_name(&self) -> std::option::Option<&str> {
        self.db_subnet_group_name.as_deref()
    }
    /// <p>Provides the description of the subnet group.</p>
    pub fn db_subnet_group_description(&self) -> std::option::Option<&str> {
        self.db_subnet_group_description.as_deref()
    }
    /// <p>Provides the virtual private cloud (VPC) ID of the subnet group.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>Provides the status of the subnet group.</p>
    pub fn subnet_group_status(&self) -> std::option::Option<&str> {
        self.subnet_group_status.as_deref()
    }
    /// <p>Detailed information about one or more subnets within a subnet group.</p>
    pub fn subnets(&self) -> std::option::Option<&[crate::model::Subnet]> {
        self.subnets.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the DB subnet group.</p>
    pub fn db_subnet_group_arn(&self) -> std::option::Option<&str> {
        self.db_subnet_group_arn.as_deref()
    }
}
impl std::fmt::Debug for DbSubnetGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbSubnetGroup");
        formatter.field("db_subnet_group_name", &self.db_subnet_group_name);
        formatter.field(
            "db_subnet_group_description",
            &self.db_subnet_group_description,
        );
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("subnet_group_status", &self.subnet_group_status);
        formatter.field("subnets", &self.subnets);
        formatter.field("db_subnet_group_arn", &self.db_subnet_group_arn);
        formatter.finish()
    }
}
/// See [`DbSubnetGroup`](crate::model::DbSubnetGroup)
pub mod db_subnet_group {
    /// A builder for [`DbSubnetGroup`](crate::model::DbSubnetGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) db_subnet_group_description: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) subnet_group_status: std::option::Option<std::string::String>,
        pub(crate) subnets: std::option::Option<std::vec::Vec<crate::model::Subnet>>,
        pub(crate) db_subnet_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the subnet group.</p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the subnet group.</p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_name = input;
            self
        }
        /// <p>Provides the description of the subnet group.</p>
        pub fn db_subnet_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_subnet_group_description = Some(input.into());
            self
        }
        /// <p>Provides the description of the subnet group.</p>
        pub fn set_db_subnet_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_description = input;
            self
        }
        /// <p>Provides the virtual private cloud (VPC) ID of the subnet group.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>Provides the virtual private cloud (VPC) ID of the subnet group.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>Provides the status of the subnet group.</p>
        pub fn subnet_group_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_group_status = Some(input.into());
            self
        }
        /// <p>Provides the status of the subnet group.</p>
        pub fn set_subnet_group_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_group_status = input;
            self
        }
        /// Appends an item to `subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>Detailed information about one or more subnets within a subnet group.</p>
        pub fn subnets(mut self, input: impl Into<crate::model::Subnet>) -> Self {
            let mut v = self.subnets.unwrap_or_default();
            v.push(input.into());
            self.subnets = Some(v);
            self
        }
        /// <p>Detailed information about one or more subnets within a subnet group.</p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Subnet>>,
        ) -> Self {
            self.subnets = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the DB subnet group.</p>
        pub fn db_subnet_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the DB subnet group.</p>
        pub fn set_db_subnet_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DbSubnetGroup`](crate::model::DbSubnetGroup)
        pub fn build(self) -> crate::model::DbSubnetGroup {
            crate::model::DbSubnetGroup {
                db_subnet_group_name: self.db_subnet_group_name,
                db_subnet_group_description: self.db_subnet_group_description,
                vpc_id: self.vpc_id,
                subnet_group_status: self.subnet_group_status,
                subnets: self.subnets,
                db_subnet_group_arn: self.db_subnet_group_arn,
            }
        }
    }
}
impl DbSubnetGroup {
    /// Creates a new builder-style object to manufacture [`DbSubnetGroup`](crate::model::DbSubnetGroup)
    pub fn builder() -> crate::model::db_subnet_group::Builder {
        crate::model::db_subnet_group::Builder::default()
    }
}

/// <p> Detailed information about a subnet. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Subnet {
    /// <p>Specifies the identifier of the subnet.</p>
    pub subnet_identifier: std::option::Option<std::string::String>,
    /// <p>Specifies the Availability Zone for the subnet.</p>
    pub subnet_availability_zone: std::option::Option<crate::model::AvailabilityZone>,
    /// <p>Specifies the status of the subnet.</p>
    pub subnet_status: std::option::Option<std::string::String>,
}
impl Subnet {
    /// <p>Specifies the identifier of the subnet.</p>
    pub fn subnet_identifier(&self) -> std::option::Option<&str> {
        self.subnet_identifier.as_deref()
    }
    /// <p>Specifies the Availability Zone for the subnet.</p>
    pub fn subnet_availability_zone(&self) -> std::option::Option<&crate::model::AvailabilityZone> {
        self.subnet_availability_zone.as_ref()
    }
    /// <p>Specifies the status of the subnet.</p>
    pub fn subnet_status(&self) -> std::option::Option<&str> {
        self.subnet_status.as_deref()
    }
}
impl std::fmt::Debug for Subnet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Subnet");
        formatter.field("subnet_identifier", &self.subnet_identifier);
        formatter.field("subnet_availability_zone", &self.subnet_availability_zone);
        formatter.field("subnet_status", &self.subnet_status);
        formatter.finish()
    }
}
/// See [`Subnet`](crate::model::Subnet)
pub mod subnet {
    /// A builder for [`Subnet`](crate::model::Subnet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_identifier: std::option::Option<std::string::String>,
        pub(crate) subnet_availability_zone: std::option::Option<crate::model::AvailabilityZone>,
        pub(crate) subnet_status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the identifier of the subnet.</p>
        pub fn subnet_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_identifier = Some(input.into());
            self
        }
        /// <p>Specifies the identifier of the subnet.</p>
        pub fn set_subnet_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_identifier = input;
            self
        }
        /// <p>Specifies the Availability Zone for the subnet.</p>
        pub fn subnet_availability_zone(mut self, input: crate::model::AvailabilityZone) -> Self {
            self.subnet_availability_zone = Some(input);
            self
        }
        /// <p>Specifies the Availability Zone for the subnet.</p>
        pub fn set_subnet_availability_zone(
            mut self,
            input: std::option::Option<crate::model::AvailabilityZone>,
        ) -> Self {
            self.subnet_availability_zone = input;
            self
        }
        /// <p>Specifies the status of the subnet.</p>
        pub fn subnet_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_status = Some(input.into());
            self
        }
        /// <p>Specifies the status of the subnet.</p>
        pub fn set_subnet_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_status = input;
            self
        }
        /// Consumes the builder and constructs a [`Subnet`](crate::model::Subnet)
        pub fn build(self) -> crate::model::Subnet {
            crate::model::Subnet {
                subnet_identifier: self.subnet_identifier,
                subnet_availability_zone: self.subnet_availability_zone,
                subnet_status: self.subnet_status,
            }
        }
    }
}
impl Subnet {
    /// Creates a new builder-style object to manufacture [`Subnet`](crate::model::Subnet)
    pub fn builder() -> crate::model::subnet::Builder {
        crate::model::subnet::Builder::default()
    }
}

/// <p>Information about an Availability Zone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AvailabilityZone {
    /// <p>The name of the Availability Zone.</p>
    pub name: std::option::Option<std::string::String>,
}
impl AvailabilityZone {
    /// <p>The name of the Availability Zone.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for AvailabilityZone {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AvailabilityZone");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`AvailabilityZone`](crate::model::AvailabilityZone)
pub mod availability_zone {
    /// A builder for [`AvailabilityZone`](crate::model::AvailabilityZone)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Availability Zone.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Availability Zone.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`AvailabilityZone`](crate::model::AvailabilityZone)
        pub fn build(self) -> crate::model::AvailabilityZone {
            crate::model::AvailabilityZone { name: self.name }
        }
    }
}
impl AvailabilityZone {
    /// Creates a new builder-style object to manufacture [`AvailabilityZone`](crate::model::AvailabilityZone)
    pub fn builder() -> crate::model::availability_zone::Builder {
        crate::model::availability_zone::Builder::default()
    }
}

/// <p>Network information for accessing a cluster or instance. Client programs must
/// specify a valid endpoint to access these Amazon DocumentDB resources.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Endpoint {
    /// <p>Specifies the DNS address of the instance.</p>
    pub address: std::option::Option<std::string::String>,
    /// <p>Specifies the port that the database engine is listening on.</p>
    pub port: i32,
    /// <p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
}
impl Endpoint {
    /// <p>Specifies the DNS address of the instance.</p>
    pub fn address(&self) -> std::option::Option<&str> {
        self.address.as_deref()
    }
    /// <p>Specifies the port that the database engine is listening on.</p>
    pub fn port(&self) -> i32 {
        self.port
    }
    /// <p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>
    pub fn hosted_zone_id(&self) -> std::option::Option<&str> {
        self.hosted_zone_id.as_deref()
    }
}
impl std::fmt::Debug for Endpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Endpoint");
        formatter.field("address", &self.address);
        formatter.field("port", &self.port);
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.finish()
    }
}
/// See [`Endpoint`](crate::model::Endpoint)
pub mod endpoint {
    /// A builder for [`Endpoint`](crate::model::Endpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) address: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the DNS address of the instance.</p>
        pub fn address(mut self, input: impl Into<std::string::String>) -> Self {
            self.address = Some(input.into());
            self
        }
        /// <p>Specifies the DNS address of the instance.</p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address = input;
            self
        }
        /// <p>Specifies the port that the database engine is listening on.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>Specifies the port that the database engine is listening on.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Endpoint`](crate::model::Endpoint)
        pub fn build(self) -> crate::model::Endpoint {
            crate::model::Endpoint {
                address: self.address,
                port: self.port.unwrap_or_default(),
                hosted_zone_id: self.hosted_zone_id,
            }
        }
    }
}
impl Endpoint {
    /// Creates a new builder-style object to manufacture [`Endpoint`](crate::model::Endpoint)
    pub fn builder() -> crate::model::endpoint::Builder {
        crate::model::endpoint::Builder::default()
    }
}

/// <p>Detailed information about the attributes that are associated with a cluster
/// snapshot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterSnapshotAttributesResult {
    /// <p>The identifier of the cluster snapshot that the attributes apply to.</p>
    pub db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
    /// <p>The list of attributes and values for the cluster snapshot.</p>
    pub db_cluster_snapshot_attributes:
        std::option::Option<std::vec::Vec<crate::model::DbClusterSnapshotAttribute>>,
}
impl DbClusterSnapshotAttributesResult {
    /// <p>The identifier of the cluster snapshot that the attributes apply to.</p>
    pub fn db_cluster_snapshot_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_snapshot_identifier.as_deref()
    }
    /// <p>The list of attributes and values for the cluster snapshot.</p>
    pub fn db_cluster_snapshot_attributes(
        &self,
    ) -> std::option::Option<&[crate::model::DbClusterSnapshotAttribute]> {
        self.db_cluster_snapshot_attributes.as_deref()
    }
}
impl std::fmt::Debug for DbClusterSnapshotAttributesResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterSnapshotAttributesResult");
        formatter.field(
            "db_cluster_snapshot_identifier",
            &self.db_cluster_snapshot_identifier,
        );
        formatter.field(
            "db_cluster_snapshot_attributes",
            &self.db_cluster_snapshot_attributes,
        );
        formatter.finish()
    }
}
/// See [`DbClusterSnapshotAttributesResult`](crate::model::DbClusterSnapshotAttributesResult)
pub mod db_cluster_snapshot_attributes_result {
    /// A builder for [`DbClusterSnapshotAttributesResult`](crate::model::DbClusterSnapshotAttributesResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_snapshot_attributes:
            std::option::Option<std::vec::Vec<crate::model::DbClusterSnapshotAttribute>>,
    }
    impl Builder {
        /// <p>The identifier of the cluster snapshot that the attributes apply to.</p>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster snapshot that the attributes apply to.</p>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = input;
            self
        }
        /// Appends an item to `db_cluster_snapshot_attributes`.
        ///
        /// To override the contents of this collection use [`set_db_cluster_snapshot_attributes`](Self::set_db_cluster_snapshot_attributes).
        ///
        /// <p>The list of attributes and values for the cluster snapshot.</p>
        pub fn db_cluster_snapshot_attributes(
            mut self,
            input: impl Into<crate::model::DbClusterSnapshotAttribute>,
        ) -> Self {
            let mut v = self.db_cluster_snapshot_attributes.unwrap_or_default();
            v.push(input.into());
            self.db_cluster_snapshot_attributes = Some(v);
            self
        }
        /// <p>The list of attributes and values for the cluster snapshot.</p>
        pub fn set_db_cluster_snapshot_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbClusterSnapshotAttribute>>,
        ) -> Self {
            self.db_cluster_snapshot_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterSnapshotAttributesResult`](crate::model::DbClusterSnapshotAttributesResult)
        pub fn build(self) -> crate::model::DbClusterSnapshotAttributesResult {
            crate::model::DbClusterSnapshotAttributesResult {
                db_cluster_snapshot_identifier: self.db_cluster_snapshot_identifier,
                db_cluster_snapshot_attributes: self.db_cluster_snapshot_attributes,
            }
        }
    }
}
impl DbClusterSnapshotAttributesResult {
    /// Creates a new builder-style object to manufacture [`DbClusterSnapshotAttributesResult`](crate::model::DbClusterSnapshotAttributesResult)
    pub fn builder() -> crate::model::db_cluster_snapshot_attributes_result::Builder {
        crate::model::db_cluster_snapshot_attributes_result::Builder::default()
    }
}

/// <p>Contains the name and values of a manual cluster snapshot attribute.</p>
/// <p>Manual cluster snapshot attributes are used to authorize other accounts to restore a manual cluster snapshot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterSnapshotAttribute {
    /// <p>The name of the manual cluster snapshot attribute.</p>
    /// <p>The attribute named <code>restore</code> refers to the list of accounts that have permission to copy or restore the manual cluster snapshot.</p>
    pub attribute_name: std::option::Option<std::string::String>,
    /// <p>The values for the manual cluster snapshot attribute.</p>
    /// <p>If the <code>AttributeName</code> field is set to <code>restore</code>, then this element returns a list of IDs of the accounts that are authorized to copy or restore the manual cluster snapshot. If a value of <code>all</code> is in the list, then the manual cluster snapshot is public and available for any account to copy or restore.</p>
    pub attribute_values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DbClusterSnapshotAttribute {
    /// <p>The name of the manual cluster snapshot attribute.</p>
    /// <p>The attribute named <code>restore</code> refers to the list of accounts that have permission to copy or restore the manual cluster snapshot.</p>
    pub fn attribute_name(&self) -> std::option::Option<&str> {
        self.attribute_name.as_deref()
    }
    /// <p>The values for the manual cluster snapshot attribute.</p>
    /// <p>If the <code>AttributeName</code> field is set to <code>restore</code>, then this element returns a list of IDs of the accounts that are authorized to copy or restore the manual cluster snapshot. If a value of <code>all</code> is in the list, then the manual cluster snapshot is public and available for any account to copy or restore.</p>
    pub fn attribute_values(&self) -> std::option::Option<&[std::string::String]> {
        self.attribute_values.as_deref()
    }
}
impl std::fmt::Debug for DbClusterSnapshotAttribute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterSnapshotAttribute");
        formatter.field("attribute_name", &self.attribute_name);
        formatter.field("attribute_values", &self.attribute_values);
        formatter.finish()
    }
}
/// See [`DbClusterSnapshotAttribute`](crate::model::DbClusterSnapshotAttribute)
pub mod db_cluster_snapshot_attribute {
    /// A builder for [`DbClusterSnapshotAttribute`](crate::model::DbClusterSnapshotAttribute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_name: std::option::Option<std::string::String>,
        pub(crate) attribute_values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the manual cluster snapshot attribute.</p>
        /// <p>The attribute named <code>restore</code> refers to the list of accounts that have permission to copy or restore the manual cluster snapshot.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p>The name of the manual cluster snapshot attribute.</p>
        /// <p>The attribute named <code>restore</code> refers to the list of accounts that have permission to copy or restore the manual cluster snapshot.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// Appends an item to `attribute_values`.
        ///
        /// To override the contents of this collection use [`set_attribute_values`](Self::set_attribute_values).
        ///
        /// <p>The values for the manual cluster snapshot attribute.</p>
        /// <p>If the <code>AttributeName</code> field is set to <code>restore</code>, then this element returns a list of IDs of the accounts that are authorized to copy or restore the manual cluster snapshot. If a value of <code>all</code> is in the list, then the manual cluster snapshot is public and available for any account to copy or restore.</p>
        pub fn attribute_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.attribute_values.unwrap_or_default();
            v.push(input.into());
            self.attribute_values = Some(v);
            self
        }
        /// <p>The values for the manual cluster snapshot attribute.</p>
        /// <p>If the <code>AttributeName</code> field is set to <code>restore</code>, then this element returns a list of IDs of the accounts that are authorized to copy or restore the manual cluster snapshot. If a value of <code>all</code> is in the list, then the manual cluster snapshot is public and available for any account to copy or restore.</p>
        pub fn set_attribute_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.attribute_values = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterSnapshotAttribute`](crate::model::DbClusterSnapshotAttribute)
        pub fn build(self) -> crate::model::DbClusterSnapshotAttribute {
            crate::model::DbClusterSnapshotAttribute {
                attribute_name: self.attribute_name,
                attribute_values: self.attribute_values,
            }
        }
    }
}
impl DbClusterSnapshotAttribute {
    /// Creates a new builder-style object to manufacture [`DbClusterSnapshotAttribute`](crate::model::DbClusterSnapshotAttribute)
    pub fn builder() -> crate::model::db_cluster_snapshot_attribute::Builder {
        crate::model::db_cluster_snapshot_attribute::Builder::default()
    }
}

/// <p>The configuration setting for the log types to be enabled for export to Amazon
/// CloudWatch Logs for a specific instance or cluster.</p>
/// <p>The <code>EnableLogTypes</code> and <code>DisableLogTypes</code> arrays determine
/// which logs are exported (or not exported) to CloudWatch Logs. The values within these
/// arrays depend on the engine that is being used.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudwatchLogsExportConfiguration {
    /// <p>The list of log types to enable.</p>
    pub enable_log_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The list of log types to disable.</p>
    pub disable_log_types: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CloudwatchLogsExportConfiguration {
    /// <p>The list of log types to enable.</p>
    pub fn enable_log_types(&self) -> std::option::Option<&[std::string::String]> {
        self.enable_log_types.as_deref()
    }
    /// <p>The list of log types to disable.</p>
    pub fn disable_log_types(&self) -> std::option::Option<&[std::string::String]> {
        self.disable_log_types.as_deref()
    }
}
impl std::fmt::Debug for CloudwatchLogsExportConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudwatchLogsExportConfiguration");
        formatter.field("enable_log_types", &self.enable_log_types);
        formatter.field("disable_log_types", &self.disable_log_types);
        formatter.finish()
    }
}
/// See [`CloudwatchLogsExportConfiguration`](crate::model::CloudwatchLogsExportConfiguration)
pub mod cloudwatch_logs_export_configuration {
    /// A builder for [`CloudwatchLogsExportConfiguration`](crate::model::CloudwatchLogsExportConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enable_log_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) disable_log_types: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `enable_log_types`.
        ///
        /// To override the contents of this collection use [`set_enable_log_types`](Self::set_enable_log_types).
        ///
        /// <p>The list of log types to enable.</p>
        pub fn enable_log_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.enable_log_types.unwrap_or_default();
            v.push(input.into());
            self.enable_log_types = Some(v);
            self
        }
        /// <p>The list of log types to enable.</p>
        pub fn set_enable_log_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.enable_log_types = input;
            self
        }
        /// Appends an item to `disable_log_types`.
        ///
        /// To override the contents of this collection use [`set_disable_log_types`](Self::set_disable_log_types).
        ///
        /// <p>The list of log types to disable.</p>
        pub fn disable_log_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.disable_log_types.unwrap_or_default();
            v.push(input.into());
            self.disable_log_types = Some(v);
            self
        }
        /// <p>The list of log types to disable.</p>
        pub fn set_disable_log_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.disable_log_types = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudwatchLogsExportConfiguration`](crate::model::CloudwatchLogsExportConfiguration)
        pub fn build(self) -> crate::model::CloudwatchLogsExportConfiguration {
            crate::model::CloudwatchLogsExportConfiguration {
                enable_log_types: self.enable_log_types,
                disable_log_types: self.disable_log_types,
            }
        }
    }
}
impl CloudwatchLogsExportConfiguration {
    /// Creates a new builder-style object to manufacture [`CloudwatchLogsExportConfiguration`](crate::model::CloudwatchLogsExportConfiguration)
    pub fn builder() -> crate::model::cloudwatch_logs_export_configuration::Builder {
        crate::model::cloudwatch_logs_export_configuration::Builder::default()
    }
}

/// <p>A named set of filter values, used to return a more specific list of results. You can
/// use a filter to match a set of resources by specific criteria, such as IDs.</p>
/// <p>Wildcards are not supported in filters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Filter {
    /// <p>The name of the filter. Filter names are case sensitive.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>One or more filter values. Filter values are case sensitive.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Filter {
    /// <p>The name of the filter. Filter names are case sensitive.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>One or more filter values. Filter values are case sensitive.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for Filter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Filter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`Filter`](crate::model::Filter)
pub mod filter {
    /// A builder for [`Filter`](crate::model::Filter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the filter. Filter names are case sensitive.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the filter. Filter names are case sensitive.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>One or more filter values. Filter values are case sensitive.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>One or more filter values. Filter values are case sensitive.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`Filter`](crate::model::Filter)
        pub fn build(self) -> crate::model::Filter {
            crate::model::Filter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl Filter {
    /// Creates a new builder-style object to manufacture [`Filter`](crate::model::Filter)
    pub fn builder() -> crate::model::filter::Builder {
        crate::model::filter::Builder::default()
    }
}

/// <p>Represents the output of <a>ApplyPendingMaintenanceAction</a>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourcePendingMaintenanceActions {
    /// <p>The Amazon Resource Name (ARN) of the resource that has pending
    /// maintenance actions.</p>
    pub resource_identifier: std::option::Option<std::string::String>,
    /// <p>A list that provides details about the pending maintenance actions
    /// for the resource.</p>
    pub pending_maintenance_action_details:
        std::option::Option<std::vec::Vec<crate::model::PendingMaintenanceAction>>,
}
impl ResourcePendingMaintenanceActions {
    /// <p>The Amazon Resource Name (ARN) of the resource that has pending
    /// maintenance actions.</p>
    pub fn resource_identifier(&self) -> std::option::Option<&str> {
        self.resource_identifier.as_deref()
    }
    /// <p>A list that provides details about the pending maintenance actions
    /// for the resource.</p>
    pub fn pending_maintenance_action_details(
        &self,
    ) -> std::option::Option<&[crate::model::PendingMaintenanceAction]> {
        self.pending_maintenance_action_details.as_deref()
    }
}
impl std::fmt::Debug for ResourcePendingMaintenanceActions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourcePendingMaintenanceActions");
        formatter.field("resource_identifier", &self.resource_identifier);
        formatter.field(
            "pending_maintenance_action_details",
            &self.pending_maintenance_action_details,
        );
        formatter.finish()
    }
}
/// See [`ResourcePendingMaintenanceActions`](crate::model::ResourcePendingMaintenanceActions)
pub mod resource_pending_maintenance_actions {
    /// A builder for [`ResourcePendingMaintenanceActions`](crate::model::ResourcePendingMaintenanceActions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_identifier: std::option::Option<std::string::String>,
        pub(crate) pending_maintenance_action_details:
            std::option::Option<std::vec::Vec<crate::model::PendingMaintenanceAction>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource that has pending
        /// maintenance actions.</p>
        pub fn resource_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_identifier = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that has pending
        /// maintenance actions.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_identifier = input;
            self
        }
        /// Appends an item to `pending_maintenance_action_details`.
        ///
        /// To override the contents of this collection use [`set_pending_maintenance_action_details`](Self::set_pending_maintenance_action_details).
        ///
        /// <p>A list that provides details about the pending maintenance actions
        /// for the resource.</p>
        pub fn pending_maintenance_action_details(
            mut self,
            input: impl Into<crate::model::PendingMaintenanceAction>,
        ) -> Self {
            let mut v = self.pending_maintenance_action_details.unwrap_or_default();
            v.push(input.into());
            self.pending_maintenance_action_details = Some(v);
            self
        }
        /// <p>A list that provides details about the pending maintenance actions
        /// for the resource.</p>
        pub fn set_pending_maintenance_action_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PendingMaintenanceAction>>,
        ) -> Self {
            self.pending_maintenance_action_details = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourcePendingMaintenanceActions`](crate::model::ResourcePendingMaintenanceActions)
        pub fn build(self) -> crate::model::ResourcePendingMaintenanceActions {
            crate::model::ResourcePendingMaintenanceActions {
                resource_identifier: self.resource_identifier,
                pending_maintenance_action_details: self.pending_maintenance_action_details,
            }
        }
    }
}
impl ResourcePendingMaintenanceActions {
    /// Creates a new builder-style object to manufacture [`ResourcePendingMaintenanceActions`](crate::model::ResourcePendingMaintenanceActions)
    pub fn builder() -> crate::model::resource_pending_maintenance_actions::Builder {
        crate::model::resource_pending_maintenance_actions::Builder::default()
    }
}

/// <p>Provides information about a pending maintenance action for a resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PendingMaintenanceAction {
    /// <p>The type of pending maintenance action that is available for the resource.</p>
    pub action: std::option::Option<std::string::String>,
    /// <p>The date of the maintenance window when the action is applied. The maintenance action
    /// is applied to the resource during its first maintenance window after this date. If this
    /// date is specified, any <code>next-maintenance</code> opt-in requests are ignored.</p>
    pub auto_applied_after_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date when the maintenance action is automatically applied. The maintenance action
    /// is applied to the resource on this date regardless of the maintenance window for the
    /// resource. If this date is specified, any <code>immediate</code> opt-in requests are
    /// ignored.</p>
    pub forced_apply_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Indicates the type of opt-in request that has been received for the resource.</p>
    pub opt_in_status: std::option::Option<std::string::String>,
    /// <p>The effective date when the pending maintenance action is applied to the
    /// resource.</p>
    pub current_apply_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A description providing more detail about the maintenance action.</p>
    pub description: std::option::Option<std::string::String>,
}
impl PendingMaintenanceAction {
    /// <p>The type of pending maintenance action that is available for the resource.</p>
    pub fn action(&self) -> std::option::Option<&str> {
        self.action.as_deref()
    }
    /// <p>The date of the maintenance window when the action is applied. The maintenance action
    /// is applied to the resource during its first maintenance window after this date. If this
    /// date is specified, any <code>next-maintenance</code> opt-in requests are ignored.</p>
    pub fn auto_applied_after_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.auto_applied_after_date.as_ref()
    }
    /// <p>The date when the maintenance action is automatically applied. The maintenance action
    /// is applied to the resource on this date regardless of the maintenance window for the
    /// resource. If this date is specified, any <code>immediate</code> opt-in requests are
    /// ignored.</p>
    pub fn forced_apply_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.forced_apply_date.as_ref()
    }
    /// <p>Indicates the type of opt-in request that has been received for the resource.</p>
    pub fn opt_in_status(&self) -> std::option::Option<&str> {
        self.opt_in_status.as_deref()
    }
    /// <p>The effective date when the pending maintenance action is applied to the
    /// resource.</p>
    pub fn current_apply_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.current_apply_date.as_ref()
    }
    /// <p>A description providing more detail about the maintenance action.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for PendingMaintenanceAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PendingMaintenanceAction");
        formatter.field("action", &self.action);
        formatter.field("auto_applied_after_date", &self.auto_applied_after_date);
        formatter.field("forced_apply_date", &self.forced_apply_date);
        formatter.field("opt_in_status", &self.opt_in_status);
        formatter.field("current_apply_date", &self.current_apply_date);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`PendingMaintenanceAction`](crate::model::PendingMaintenanceAction)
pub mod pending_maintenance_action {
    /// A builder for [`PendingMaintenanceAction`](crate::model::PendingMaintenanceAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<std::string::String>,
        pub(crate) auto_applied_after_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) forced_apply_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) opt_in_status: std::option::Option<std::string::String>,
        pub(crate) current_apply_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of pending maintenance action that is available for the resource.</p>
        pub fn action(mut self, input: impl Into<std::string::String>) -> Self {
            self.action = Some(input.into());
            self
        }
        /// <p>The type of pending maintenance action that is available for the resource.</p>
        pub fn set_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action = input;
            self
        }
        /// <p>The date of the maintenance window when the action is applied. The maintenance action
        /// is applied to the resource during its first maintenance window after this date. If this
        /// date is specified, any <code>next-maintenance</code> opt-in requests are ignored.</p>
        pub fn auto_applied_after_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.auto_applied_after_date = Some(input);
            self
        }
        /// <p>The date of the maintenance window when the action is applied. The maintenance action
        /// is applied to the resource during its first maintenance window after this date. If this
        /// date is specified, any <code>next-maintenance</code> opt-in requests are ignored.</p>
        pub fn set_auto_applied_after_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.auto_applied_after_date = input;
            self
        }
        /// <p>The date when the maintenance action is automatically applied. The maintenance action
        /// is applied to the resource on this date regardless of the maintenance window for the
        /// resource. If this date is specified, any <code>immediate</code> opt-in requests are
        /// ignored.</p>
        pub fn forced_apply_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.forced_apply_date = Some(input);
            self
        }
        /// <p>The date when the maintenance action is automatically applied. The maintenance action
        /// is applied to the resource on this date regardless of the maintenance window for the
        /// resource. If this date is specified, any <code>immediate</code> opt-in requests are
        /// ignored.</p>
        pub fn set_forced_apply_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.forced_apply_date = input;
            self
        }
        /// <p>Indicates the type of opt-in request that has been received for the resource.</p>
        pub fn opt_in_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_in_status = Some(input.into());
            self
        }
        /// <p>Indicates the type of opt-in request that has been received for the resource.</p>
        pub fn set_opt_in_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opt_in_status = input;
            self
        }
        /// <p>The effective date when the pending maintenance action is applied to the
        /// resource.</p>
        pub fn current_apply_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.current_apply_date = Some(input);
            self
        }
        /// <p>The effective date when the pending maintenance action is applied to the
        /// resource.</p>
        pub fn set_current_apply_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.current_apply_date = input;
            self
        }
        /// <p>A description providing more detail about the maintenance action.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description providing more detail about the maintenance action.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`PendingMaintenanceAction`](crate::model::PendingMaintenanceAction)
        pub fn build(self) -> crate::model::PendingMaintenanceAction {
            crate::model::PendingMaintenanceAction {
                action: self.action,
                auto_applied_after_date: self.auto_applied_after_date,
                forced_apply_date: self.forced_apply_date,
                opt_in_status: self.opt_in_status,
                current_apply_date: self.current_apply_date,
                description: self.description,
            }
        }
    }
}
impl PendingMaintenanceAction {
    /// Creates a new builder-style object to manufacture [`PendingMaintenanceAction`](crate::model::PendingMaintenanceAction)
    pub fn builder() -> crate::model::pending_maintenance_action::Builder {
        crate::model::pending_maintenance_action::Builder::default()
    }
}

/// <p>The options that are available for an instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrderableDbInstanceOption {
    /// <p>The engine type of an instance.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The engine version of an instance.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The instance class for an instance.</p>
    pub db_instance_class: std::option::Option<std::string::String>,
    /// <p>The license model for an instance.</p>
    pub license_model: std::option::Option<std::string::String>,
    /// <p>A list of Availability Zones for an instance.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<crate::model::AvailabilityZone>>,
    /// <p>Indicates whether an instance is in a virtual private cloud (VPC).</p>
    pub vpc: bool,
}
impl OrderableDbInstanceOption {
    /// <p>The engine type of an instance.</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The engine version of an instance.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The instance class for an instance.</p>
    pub fn db_instance_class(&self) -> std::option::Option<&str> {
        self.db_instance_class.as_deref()
    }
    /// <p>The license model for an instance.</p>
    pub fn license_model(&self) -> std::option::Option<&str> {
        self.license_model.as_deref()
    }
    /// <p>A list of Availability Zones for an instance.</p>
    pub fn availability_zones(&self) -> std::option::Option<&[crate::model::AvailabilityZone]> {
        self.availability_zones.as_deref()
    }
    /// <p>Indicates whether an instance is in a virtual private cloud (VPC).</p>
    pub fn vpc(&self) -> bool {
        self.vpc
    }
}
impl std::fmt::Debug for OrderableDbInstanceOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrderableDbInstanceOption");
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("db_instance_class", &self.db_instance_class);
        formatter.field("license_model", &self.license_model);
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("vpc", &self.vpc);
        formatter.finish()
    }
}
/// See [`OrderableDbInstanceOption`](crate::model::OrderableDbInstanceOption)
pub mod orderable_db_instance_option {
    /// A builder for [`OrderableDbInstanceOption`](crate::model::OrderableDbInstanceOption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) db_instance_class: std::option::Option<std::string::String>,
        pub(crate) license_model: std::option::Option<std::string::String>,
        pub(crate) availability_zones:
            std::option::Option<std::vec::Vec<crate::model::AvailabilityZone>>,
        pub(crate) vpc: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The engine type of an instance.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The engine type of an instance.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The engine version of an instance.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The engine version of an instance.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The instance class for an instance.</p>
        pub fn db_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_class = Some(input.into());
            self
        }
        /// <p>The instance class for an instance.</p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_class = input;
            self
        }
        /// <p>The license model for an instance.</p>
        pub fn license_model(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_model = Some(input.into());
            self
        }
        /// <p>The license model for an instance.</p>
        pub fn set_license_model(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_model = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>A list of Availability Zones for an instance.</p>
        pub fn availability_zones(
            mut self,
            input: impl Into<crate::model::AvailabilityZone>,
        ) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>A list of Availability Zones for an instance.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AvailabilityZone>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// <p>Indicates whether an instance is in a virtual private cloud (VPC).</p>
        pub fn vpc(mut self, input: bool) -> Self {
            self.vpc = Some(input);
            self
        }
        /// <p>Indicates whether an instance is in a virtual private cloud (VPC).</p>
        pub fn set_vpc(mut self, input: std::option::Option<bool>) -> Self {
            self.vpc = input;
            self
        }
        /// Consumes the builder and constructs a [`OrderableDbInstanceOption`](crate::model::OrderableDbInstanceOption)
        pub fn build(self) -> crate::model::OrderableDbInstanceOption {
            crate::model::OrderableDbInstanceOption {
                engine: self.engine,
                engine_version: self.engine_version,
                db_instance_class: self.db_instance_class,
                license_model: self.license_model,
                availability_zones: self.availability_zones,
                vpc: self.vpc.unwrap_or_default(),
            }
        }
    }
}
impl OrderableDbInstanceOption {
    /// Creates a new builder-style object to manufacture [`OrderableDbInstanceOption`](crate::model::OrderableDbInstanceOption)
    pub fn builder() -> crate::model::orderable_db_instance_option::Builder {
        crate::model::orderable_db_instance_option::Builder::default()
    }
}

/// <p>Detailed information about an event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Event {
    /// <p>Provides the identifier for the source of the event.</p>
    pub source_identifier: std::option::Option<std::string::String>,
    /// <p>Specifies the source type for this event.</p>
    pub source_type: std::option::Option<crate::model::SourceType>,
    /// <p>Provides the text of this event.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>Specifies the category for the event.</p>
    pub event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies the date and time of the event.</p>
    pub date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Amazon Resource Name (ARN) for the event.</p>
    pub source_arn: std::option::Option<std::string::String>,
}
impl Event {
    /// <p>Provides the identifier for the source of the event.</p>
    pub fn source_identifier(&self) -> std::option::Option<&str> {
        self.source_identifier.as_deref()
    }
    /// <p>Specifies the source type for this event.</p>
    pub fn source_type(&self) -> std::option::Option<&crate::model::SourceType> {
        self.source_type.as_ref()
    }
    /// <p>Provides the text of this event.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>Specifies the category for the event.</p>
    pub fn event_categories(&self) -> std::option::Option<&[std::string::String]> {
        self.event_categories.as_deref()
    }
    /// <p>Specifies the date and time of the event.</p>
    pub fn date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.date.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) for the event.</p>
    pub fn source_arn(&self) -> std::option::Option<&str> {
        self.source_arn.as_deref()
    }
}
impl std::fmt::Debug for Event {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Event");
        formatter.field("source_identifier", &self.source_identifier);
        formatter.field("source_type", &self.source_type);
        formatter.field("message", &self.message);
        formatter.field("event_categories", &self.event_categories);
        formatter.field("date", &self.date);
        formatter.field("source_arn", &self.source_arn);
        formatter.finish()
    }
}
/// See [`Event`](crate::model::Event)
pub mod event {
    /// A builder for [`Event`](crate::model::Event)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_identifier: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<crate::model::SourceType>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) source_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Provides the identifier for the source of the event.</p>
        pub fn source_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_identifier = Some(input.into());
            self
        }
        /// <p>Provides the identifier for the source of the event.</p>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_identifier = input;
            self
        }
        /// <p>Specifies the source type for this event.</p>
        pub fn source_type(mut self, input: crate::model::SourceType) -> Self {
            self.source_type = Some(input);
            self
        }
        /// <p>Specifies the source type for this event.</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.source_type = input;
            self
        }
        /// <p>Provides the text of this event.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Provides the text of this event.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Appends an item to `event_categories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p>Specifies the category for the event.</p>
        pub fn event_categories(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_categories.unwrap_or_default();
            v.push(input.into());
            self.event_categories = Some(v);
            self
        }
        /// <p>Specifies the category for the event.</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_categories = input;
            self
        }
        /// <p>Specifies the date and time of the event.</p>
        pub fn date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.date = Some(input);
            self
        }
        /// <p>Specifies the date and time of the event.</p>
        pub fn set_date(mut self, input: std::option::Option<aws_smithy_types::Instant>) -> Self {
            self.date = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the event.</p>
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the event.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Event`](crate::model::Event)
        pub fn build(self) -> crate::model::Event {
            crate::model::Event {
                source_identifier: self.source_identifier,
                source_type: self.source_type,
                message: self.message,
                event_categories: self.event_categories,
                date: self.date,
                source_arn: self.source_arn,
            }
        }
    }
}
impl Event {
    /// Creates a new builder-style object to manufacture [`Event`](crate::model::Event)
    pub fn builder() -> crate::model::event::Builder {
        crate::model::event::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SourceType {
    #[allow(missing_docs)] // documentation missing in model
    DbCluster,
    #[allow(missing_docs)] // documentation missing in model
    DbClusterSnapshot,
    #[allow(missing_docs)] // documentation missing in model
    DbInstance,
    #[allow(missing_docs)] // documentation missing in model
    DbParameterGroup,
    #[allow(missing_docs)] // documentation missing in model
    DbSecurityGroup,
    #[allow(missing_docs)] // documentation missing in model
    DbSnapshot,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SourceType {
    fn from(s: &str) -> Self {
        match s {
            "db-cluster" => SourceType::DbCluster,
            "db-cluster-snapshot" => SourceType::DbClusterSnapshot,
            "db-instance" => SourceType::DbInstance,
            "db-parameter-group" => SourceType::DbParameterGroup,
            "db-security-group" => SourceType::DbSecurityGroup,
            "db-snapshot" => SourceType::DbSnapshot,
            other => SourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SourceType::from(s))
    }
}
impl SourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SourceType::DbCluster => "db-cluster",
            SourceType::DbClusterSnapshot => "db-cluster-snapshot",
            SourceType::DbInstance => "db-instance",
            SourceType::DbParameterGroup => "db-parameter-group",
            SourceType::DbSecurityGroup => "db-security-group",
            SourceType::DbSnapshot => "db-snapshot",
            SourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "db-cluster",
            "db-cluster-snapshot",
            "db-instance",
            "db-parameter-group",
            "db-security-group",
            "db-snapshot",
        ]
    }
}
impl AsRef<str> for SourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An event source type, accompanied by one or more event category names.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventCategoriesMap {
    /// <p>The source type that the returned categories belong to.</p>
    pub source_type: std::option::Option<std::string::String>,
    /// <p>The event categories for the specified source type.</p>
    pub event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl EventCategoriesMap {
    /// <p>The source type that the returned categories belong to.</p>
    pub fn source_type(&self) -> std::option::Option<&str> {
        self.source_type.as_deref()
    }
    /// <p>The event categories for the specified source type.</p>
    pub fn event_categories(&self) -> std::option::Option<&[std::string::String]> {
        self.event_categories.as_deref()
    }
}
impl std::fmt::Debug for EventCategoriesMap {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventCategoriesMap");
        formatter.field("source_type", &self.source_type);
        formatter.field("event_categories", &self.event_categories);
        formatter.finish()
    }
}
/// See [`EventCategoriesMap`](crate::model::EventCategoriesMap)
pub mod event_categories_map {
    /// A builder for [`EventCategoriesMap`](crate::model::EventCategoriesMap)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_type: std::option::Option<std::string::String>,
        pub(crate) event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The source type that the returned categories belong to.</p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_type = Some(input.into());
            self
        }
        /// <p>The source type that the returned categories belong to.</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_type = input;
            self
        }
        /// Appends an item to `event_categories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p>The event categories for the specified source type.</p>
        pub fn event_categories(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_categories.unwrap_or_default();
            v.push(input.into());
            self.event_categories = Some(v);
            self
        }
        /// <p>The event categories for the specified source type.</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_categories = input;
            self
        }
        /// Consumes the builder and constructs a [`EventCategoriesMap`](crate::model::EventCategoriesMap)
        pub fn build(self) -> crate::model::EventCategoriesMap {
            crate::model::EventCategoriesMap {
                source_type: self.source_type,
                event_categories: self.event_categories,
            }
        }
    }
}
impl EventCategoriesMap {
    /// Creates a new builder-style object to manufacture [`EventCategoriesMap`](crate::model::EventCategoriesMap)
    pub fn builder() -> crate::model::event_categories_map::Builder {
        crate::model::event_categories_map::Builder::default()
    }
}

/// <p>Contains the result of a successful invocation of the
/// <code>DescribeEngineDefaultClusterParameters</code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EngineDefaults {
    /// <p>The name of the cluster parameter group family to return the engine parameter information for.</p>
    pub db_parameter_group_family: std::option::Option<std::string::String>,
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
    /// includes only records beyond the marker, up to the value specified by
    /// <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The parameters of a particular cluster parameter group family.</p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
}
impl EngineDefaults {
    /// <p>The name of the cluster parameter group family to return the engine parameter information for.</p>
    pub fn db_parameter_group_family(&self) -> std::option::Option<&str> {
        self.db_parameter_group_family.as_deref()
    }
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
    /// includes only records beyond the marker, up to the value specified by
    /// <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The parameters of a particular cluster parameter group family.</p>
    pub fn parameters(&self) -> std::option::Option<&[crate::model::Parameter]> {
        self.parameters.as_deref()
    }
}
impl std::fmt::Debug for EngineDefaults {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EngineDefaults");
        formatter.field("db_parameter_group_family", &self.db_parameter_group_family);
        formatter.field("marker", &self.marker);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}
/// See [`EngineDefaults`](crate::model::EngineDefaults)
pub mod engine_defaults {
    /// A builder for [`EngineDefaults`](crate::model::EngineDefaults)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
    }
    impl Builder {
        /// <p>The name of the cluster parameter group family to return the engine parameter information for.</p>
        pub fn db_parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_family = Some(input.into());
            self
        }
        /// <p>The name of the cluster parameter group family to return the engine parameter information for.</p>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_family = input;
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The parameters of a particular cluster parameter group family.</p>
        pub fn parameters(mut self, input: impl Into<crate::model::Parameter>) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input.into());
            self.parameters = Some(v);
            self
        }
        /// <p>The parameters of a particular cluster parameter group family.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`EngineDefaults`](crate::model::EngineDefaults)
        pub fn build(self) -> crate::model::EngineDefaults {
            crate::model::EngineDefaults {
                db_parameter_group_family: self.db_parameter_group_family,
                marker: self.marker,
                parameters: self.parameters,
            }
        }
    }
}
impl EngineDefaults {
    /// Creates a new builder-style object to manufacture [`EngineDefaults`](crate::model::EngineDefaults)
    pub fn builder() -> crate::model::engine_defaults::Builder {
        crate::model::engine_defaults::Builder::default()
    }
}

/// <p> Detailed information about an engine version. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbEngineVersion {
    /// <p>The name of the database engine.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The version number of the database engine.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The name of the parameter group family for the database engine.</p>
    pub db_parameter_group_family: std::option::Option<std::string::String>,
    /// <p>The description of the database engine.</p>
    pub db_engine_description: std::option::Option<std::string::String>,
    /// <p>The description of the database engine version.</p>
    pub db_engine_version_description: std::option::Option<std::string::String>,
    /// <p>A list of engine versions that this database engine version can be upgraded to.</p>
    pub valid_upgrade_target: std::option::Option<std::vec::Vec<crate::model::UpgradeTarget>>,
    /// <p>The types of logs that the database engine has available for export to Amazon
    /// CloudWatch Logs.</p>
    pub exportable_log_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A value that indicates whether the engine version supports exporting the log types
    /// specified by <code>ExportableLogTypes</code> to CloudWatch Logs.</p>
    pub supports_log_exports_to_cloudwatch_logs: bool,
}
impl DbEngineVersion {
    /// <p>The name of the database engine.</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The version number of the database engine.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The name of the parameter group family for the database engine.</p>
    pub fn db_parameter_group_family(&self) -> std::option::Option<&str> {
        self.db_parameter_group_family.as_deref()
    }
    /// <p>The description of the database engine.</p>
    pub fn db_engine_description(&self) -> std::option::Option<&str> {
        self.db_engine_description.as_deref()
    }
    /// <p>The description of the database engine version.</p>
    pub fn db_engine_version_description(&self) -> std::option::Option<&str> {
        self.db_engine_version_description.as_deref()
    }
    /// <p>A list of engine versions that this database engine version can be upgraded to.</p>
    pub fn valid_upgrade_target(&self) -> std::option::Option<&[crate::model::UpgradeTarget]> {
        self.valid_upgrade_target.as_deref()
    }
    /// <p>The types of logs that the database engine has available for export to Amazon
    /// CloudWatch Logs.</p>
    pub fn exportable_log_types(&self) -> std::option::Option<&[std::string::String]> {
        self.exportable_log_types.as_deref()
    }
    /// <p>A value that indicates whether the engine version supports exporting the log types
    /// specified by <code>ExportableLogTypes</code> to CloudWatch Logs.</p>
    pub fn supports_log_exports_to_cloudwatch_logs(&self) -> bool {
        self.supports_log_exports_to_cloudwatch_logs
    }
}
impl std::fmt::Debug for DbEngineVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbEngineVersion");
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("db_parameter_group_family", &self.db_parameter_group_family);
        formatter.field("db_engine_description", &self.db_engine_description);
        formatter.field(
            "db_engine_version_description",
            &self.db_engine_version_description,
        );
        formatter.field("valid_upgrade_target", &self.valid_upgrade_target);
        formatter.field("exportable_log_types", &self.exportable_log_types);
        formatter.field(
            "supports_log_exports_to_cloudwatch_logs",
            &self.supports_log_exports_to_cloudwatch_logs,
        );
        formatter.finish()
    }
}
/// See [`DbEngineVersion`](crate::model::DbEngineVersion)
pub mod db_engine_version {
    /// A builder for [`DbEngineVersion`](crate::model::DbEngineVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) db_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) db_engine_description: std::option::Option<std::string::String>,
        pub(crate) db_engine_version_description: std::option::Option<std::string::String>,
        pub(crate) valid_upgrade_target:
            std::option::Option<std::vec::Vec<crate::model::UpgradeTarget>>,
        pub(crate) exportable_log_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) supports_log_exports_to_cloudwatch_logs: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the database engine.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The name of the database engine.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The version number of the database engine.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The version number of the database engine.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The name of the parameter group family for the database engine.</p>
        pub fn db_parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_family = Some(input.into());
            self
        }
        /// <p>The name of the parameter group family for the database engine.</p>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_family = input;
            self
        }
        /// <p>The description of the database engine.</p>
        pub fn db_engine_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_engine_description = Some(input.into());
            self
        }
        /// <p>The description of the database engine.</p>
        pub fn set_db_engine_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_engine_description = input;
            self
        }
        /// <p>The description of the database engine version.</p>
        pub fn db_engine_version_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_engine_version_description = Some(input.into());
            self
        }
        /// <p>The description of the database engine version.</p>
        pub fn set_db_engine_version_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_engine_version_description = input;
            self
        }
        /// Appends an item to `valid_upgrade_target`.
        ///
        /// To override the contents of this collection use [`set_valid_upgrade_target`](Self::set_valid_upgrade_target).
        ///
        /// <p>A list of engine versions that this database engine version can be upgraded to.</p>
        pub fn valid_upgrade_target(
            mut self,
            input: impl Into<crate::model::UpgradeTarget>,
        ) -> Self {
            let mut v = self.valid_upgrade_target.unwrap_or_default();
            v.push(input.into());
            self.valid_upgrade_target = Some(v);
            self
        }
        /// <p>A list of engine versions that this database engine version can be upgraded to.</p>
        pub fn set_valid_upgrade_target(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpgradeTarget>>,
        ) -> Self {
            self.valid_upgrade_target = input;
            self
        }
        /// Appends an item to `exportable_log_types`.
        ///
        /// To override the contents of this collection use [`set_exportable_log_types`](Self::set_exportable_log_types).
        ///
        /// <p>The types of logs that the database engine has available for export to Amazon
        /// CloudWatch Logs.</p>
        pub fn exportable_log_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.exportable_log_types.unwrap_or_default();
            v.push(input.into());
            self.exportable_log_types = Some(v);
            self
        }
        /// <p>The types of logs that the database engine has available for export to Amazon
        /// CloudWatch Logs.</p>
        pub fn set_exportable_log_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.exportable_log_types = input;
            self
        }
        /// <p>A value that indicates whether the engine version supports exporting the log types
        /// specified by <code>ExportableLogTypes</code> to CloudWatch Logs.</p>
        pub fn supports_log_exports_to_cloudwatch_logs(mut self, input: bool) -> Self {
            self.supports_log_exports_to_cloudwatch_logs = Some(input);
            self
        }
        /// <p>A value that indicates whether the engine version supports exporting the log types
        /// specified by <code>ExportableLogTypes</code> to CloudWatch Logs.</p>
        pub fn set_supports_log_exports_to_cloudwatch_logs(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.supports_log_exports_to_cloudwatch_logs = input;
            self
        }
        /// Consumes the builder and constructs a [`DbEngineVersion`](crate::model::DbEngineVersion)
        pub fn build(self) -> crate::model::DbEngineVersion {
            crate::model::DbEngineVersion {
                engine: self.engine,
                engine_version: self.engine_version,
                db_parameter_group_family: self.db_parameter_group_family,
                db_engine_description: self.db_engine_description,
                db_engine_version_description: self.db_engine_version_description,
                valid_upgrade_target: self.valid_upgrade_target,
                exportable_log_types: self.exportable_log_types,
                supports_log_exports_to_cloudwatch_logs: self
                    .supports_log_exports_to_cloudwatch_logs
                    .unwrap_or_default(),
            }
        }
    }
}
impl DbEngineVersion {
    /// Creates a new builder-style object to manufacture [`DbEngineVersion`](crate::model::DbEngineVersion)
    pub fn builder() -> crate::model::db_engine_version::Builder {
        crate::model::db_engine_version::Builder::default()
    }
}

/// <p>The version of the database engine that an instance can be upgraded to.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpgradeTarget {
    /// <p>The name of the upgrade target database engine.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The version number of the upgrade target database engine.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The version of the database engine that an instance can be upgraded to.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A value that indicates whether the target version is applied to any source DB instances that have <code>AutoMinorVersionUpgrade</code> set to <code>true</code>.</p>
    pub auto_upgrade: bool,
    /// <p>A value that indicates whether a database engine is upgraded to a major
    /// version.</p>
    pub is_major_version_upgrade: bool,
}
impl UpgradeTarget {
    /// <p>The name of the upgrade target database engine.</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The version number of the upgrade target database engine.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The version of the database engine that an instance can be upgraded to.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A value that indicates whether the target version is applied to any source DB instances that have <code>AutoMinorVersionUpgrade</code> set to <code>true</code>.</p>
    pub fn auto_upgrade(&self) -> bool {
        self.auto_upgrade
    }
    /// <p>A value that indicates whether a database engine is upgraded to a major
    /// version.</p>
    pub fn is_major_version_upgrade(&self) -> bool {
        self.is_major_version_upgrade
    }
}
impl std::fmt::Debug for UpgradeTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpgradeTarget");
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("description", &self.description);
        formatter.field("auto_upgrade", &self.auto_upgrade);
        formatter.field("is_major_version_upgrade", &self.is_major_version_upgrade);
        formatter.finish()
    }
}
/// See [`UpgradeTarget`](crate::model::UpgradeTarget)
pub mod upgrade_target {
    /// A builder for [`UpgradeTarget`](crate::model::UpgradeTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) auto_upgrade: std::option::Option<bool>,
        pub(crate) is_major_version_upgrade: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the upgrade target database engine.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The name of the upgrade target database engine.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The version number of the upgrade target database engine.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The version number of the upgrade target database engine.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The version of the database engine that an instance can be upgraded to.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The version of the database engine that an instance can be upgraded to.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A value that indicates whether the target version is applied to any source DB instances that have <code>AutoMinorVersionUpgrade</code> set to <code>true</code>.</p>
        pub fn auto_upgrade(mut self, input: bool) -> Self {
            self.auto_upgrade = Some(input);
            self
        }
        /// <p>A value that indicates whether the target version is applied to any source DB instances that have <code>AutoMinorVersionUpgrade</code> set to <code>true</code>.</p>
        pub fn set_auto_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_upgrade = input;
            self
        }
        /// <p>A value that indicates whether a database engine is upgraded to a major
        /// version.</p>
        pub fn is_major_version_upgrade(mut self, input: bool) -> Self {
            self.is_major_version_upgrade = Some(input);
            self
        }
        /// <p>A value that indicates whether a database engine is upgraded to a major
        /// version.</p>
        pub fn set_is_major_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.is_major_version_upgrade = input;
            self
        }
        /// Consumes the builder and constructs a [`UpgradeTarget`](crate::model::UpgradeTarget)
        pub fn build(self) -> crate::model::UpgradeTarget {
            crate::model::UpgradeTarget {
                engine: self.engine,
                engine_version: self.engine_version,
                description: self.description,
                auto_upgrade: self.auto_upgrade.unwrap_or_default(),
                is_major_version_upgrade: self.is_major_version_upgrade.unwrap_or_default(),
            }
        }
    }
}
impl UpgradeTarget {
    /// Creates a new builder-style object to manufacture [`UpgradeTarget`](crate::model::UpgradeTarget)
    pub fn builder() -> crate::model::upgrade_target::Builder {
        crate::model::upgrade_target::Builder::default()
    }
}

/// <p>Detailed information about a cluster snapshot. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterSnapshot {
    /// <p>Provides the list of Amazon EC2 Availability Zones that instances in the cluster
    /// snapshot can be restored in.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies the identifier for the cluster snapshot.</p>
    pub db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
    /// <p>Specifies the cluster identifier of the cluster that this cluster snapshot
    /// was created from.</p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>Provides the time when the snapshot was taken, in UTC.</p>
    pub snapshot_create_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Specifies the name of the database engine.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>Specifies the status of this cluster snapshot.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>Specifies the port that the cluster was listening on at the time of the
    /// snapshot.</p>
    pub port: i32,
    /// <p>Provides the virtual private cloud (VPC) ID that is associated with the cluster
    /// snapshot.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>Specifies the time when the cluster was created, in Universal Coordinated Time
    /// (UTC).</p>
    pub cluster_create_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Provides the master user name for the cluster snapshot.</p>
    pub master_username: std::option::Option<std::string::String>,
    /// <p>Provides the version of the database engine for this cluster snapshot.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>Provides the type of the cluster snapshot.</p>
    pub snapshot_type: std::option::Option<std::string::String>,
    /// <p>Specifies the percentage of the estimated data that has been transferred.</p>
    pub percent_progress: i32,
    /// <p>Specifies whether the cluster snapshot is encrypted.</p>
    pub storage_encrypted: bool,
    /// <p>If <code>StorageEncrypted</code> is <code>true</code>, the KMS key identifier for the encrypted cluster snapshot.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the cluster snapshot.</p>
    pub db_cluster_snapshot_arn: std::option::Option<std::string::String>,
    /// <p>If the cluster snapshot was copied from a source cluster snapshot, the ARN for
    /// the source cluster snapshot; otherwise, a null value.</p>
    pub source_db_cluster_snapshot_arn: std::option::Option<std::string::String>,
}
impl DbClusterSnapshot {
    /// <p>Provides the list of Amazon EC2 Availability Zones that instances in the cluster
    /// snapshot can be restored in.</p>
    pub fn availability_zones(&self) -> std::option::Option<&[std::string::String]> {
        self.availability_zones.as_deref()
    }
    /// <p>Specifies the identifier for the cluster snapshot.</p>
    pub fn db_cluster_snapshot_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_snapshot_identifier.as_deref()
    }
    /// <p>Specifies the cluster identifier of the cluster that this cluster snapshot
    /// was created from.</p>
    pub fn db_cluster_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_identifier.as_deref()
    }
    /// <p>Provides the time when the snapshot was taken, in UTC.</p>
    pub fn snapshot_create_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.snapshot_create_time.as_ref()
    }
    /// <p>Specifies the name of the database engine.</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>Specifies the status of this cluster snapshot.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>Specifies the port that the cluster was listening on at the time of the
    /// snapshot.</p>
    pub fn port(&self) -> i32 {
        self.port
    }
    /// <p>Provides the virtual private cloud (VPC) ID that is associated with the cluster
    /// snapshot.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>Specifies the time when the cluster was created, in Universal Coordinated Time
    /// (UTC).</p>
    pub fn cluster_create_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.cluster_create_time.as_ref()
    }
    /// <p>Provides the master user name for the cluster snapshot.</p>
    pub fn master_username(&self) -> std::option::Option<&str> {
        self.master_username.as_deref()
    }
    /// <p>Provides the version of the database engine for this cluster snapshot.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>Provides the type of the cluster snapshot.</p>
    pub fn snapshot_type(&self) -> std::option::Option<&str> {
        self.snapshot_type.as_deref()
    }
    /// <p>Specifies the percentage of the estimated data that has been transferred.</p>
    pub fn percent_progress(&self) -> i32 {
        self.percent_progress
    }
    /// <p>Specifies whether the cluster snapshot is encrypted.</p>
    pub fn storage_encrypted(&self) -> bool {
        self.storage_encrypted
    }
    /// <p>If <code>StorageEncrypted</code> is <code>true</code>, the KMS key identifier for the encrypted cluster snapshot.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the cluster snapshot.</p>
    pub fn db_cluster_snapshot_arn(&self) -> std::option::Option<&str> {
        self.db_cluster_snapshot_arn.as_deref()
    }
    /// <p>If the cluster snapshot was copied from a source cluster snapshot, the ARN for
    /// the source cluster snapshot; otherwise, a null value.</p>
    pub fn source_db_cluster_snapshot_arn(&self) -> std::option::Option<&str> {
        self.source_db_cluster_snapshot_arn.as_deref()
    }
}
impl std::fmt::Debug for DbClusterSnapshot {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterSnapshot");
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field(
            "db_cluster_snapshot_identifier",
            &self.db_cluster_snapshot_identifier,
        );
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field("snapshot_create_time", &self.snapshot_create_time);
        formatter.field("engine", &self.engine);
        formatter.field("status", &self.status);
        formatter.field("port", &self.port);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("cluster_create_time", &self.cluster_create_time);
        formatter.field("master_username", &self.master_username);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("snapshot_type", &self.snapshot_type);
        formatter.field("percent_progress", &self.percent_progress);
        formatter.field("storage_encrypted", &self.storage_encrypted);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("db_cluster_snapshot_arn", &self.db_cluster_snapshot_arn);
        formatter.field(
            "source_db_cluster_snapshot_arn",
            &self.source_db_cluster_snapshot_arn,
        );
        formatter.finish()
    }
}
/// See [`DbClusterSnapshot`](crate::model::DbClusterSnapshot)
pub mod db_cluster_snapshot {
    /// A builder for [`DbClusterSnapshot`](crate::model::DbClusterSnapshot)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) snapshot_create_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) cluster_create_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) master_username: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) snapshot_type: std::option::Option<std::string::String>,
        pub(crate) percent_progress: std::option::Option<i32>,
        pub(crate) storage_encrypted: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) db_cluster_snapshot_arn: std::option::Option<std::string::String>,
        pub(crate) source_db_cluster_snapshot_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>Provides the list of Amazon EC2 Availability Zones that instances in the cluster
        /// snapshot can be restored in.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>Provides the list of Amazon EC2 Availability Zones that instances in the cluster
        /// snapshot can be restored in.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// <p>Specifies the identifier for the cluster snapshot.</p>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>Specifies the identifier for the cluster snapshot.</p>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = input;
            self
        }
        /// <p>Specifies the cluster identifier of the cluster that this cluster snapshot
        /// was created from.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>Specifies the cluster identifier of the cluster that this cluster snapshot
        /// was created from.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>Provides the time when the snapshot was taken, in UTC.</p>
        pub fn snapshot_create_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.snapshot_create_time = Some(input);
            self
        }
        /// <p>Provides the time when the snapshot was taken, in UTC.</p>
        pub fn set_snapshot_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.snapshot_create_time = input;
            self
        }
        /// <p>Specifies the name of the database engine.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>Specifies the name of the database engine.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>Specifies the status of this cluster snapshot.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Specifies the status of this cluster snapshot.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>Specifies the port that the cluster was listening on at the time of the
        /// snapshot.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>Specifies the port that the cluster was listening on at the time of the
        /// snapshot.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Provides the virtual private cloud (VPC) ID that is associated with the cluster
        /// snapshot.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>Provides the virtual private cloud (VPC) ID that is associated with the cluster
        /// snapshot.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>Specifies the time when the cluster was created, in Universal Coordinated Time
        /// (UTC).</p>
        pub fn cluster_create_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.cluster_create_time = Some(input);
            self
        }
        /// <p>Specifies the time when the cluster was created, in Universal Coordinated Time
        /// (UTC).</p>
        pub fn set_cluster_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.cluster_create_time = input;
            self
        }
        /// <p>Provides the master user name for the cluster snapshot.</p>
        pub fn master_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_username = Some(input.into());
            self
        }
        /// <p>Provides the master user name for the cluster snapshot.</p>
        pub fn set_master_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_username = input;
            self
        }
        /// <p>Provides the version of the database engine for this cluster snapshot.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>Provides the version of the database engine for this cluster snapshot.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>Provides the type of the cluster snapshot.</p>
        pub fn snapshot_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_type = Some(input.into());
            self
        }
        /// <p>Provides the type of the cluster snapshot.</p>
        pub fn set_snapshot_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_type = input;
            self
        }
        /// <p>Specifies the percentage of the estimated data that has been transferred.</p>
        pub fn percent_progress(mut self, input: i32) -> Self {
            self.percent_progress = Some(input);
            self
        }
        /// <p>Specifies the percentage of the estimated data that has been transferred.</p>
        pub fn set_percent_progress(mut self, input: std::option::Option<i32>) -> Self {
            self.percent_progress = input;
            self
        }
        /// <p>Specifies whether the cluster snapshot is encrypted.</p>
        pub fn storage_encrypted(mut self, input: bool) -> Self {
            self.storage_encrypted = Some(input);
            self
        }
        /// <p>Specifies whether the cluster snapshot is encrypted.</p>
        pub fn set_storage_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.storage_encrypted = input;
            self
        }
        /// <p>If <code>StorageEncrypted</code> is <code>true</code>, the KMS key identifier for the encrypted cluster snapshot.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>If <code>StorageEncrypted</code> is <code>true</code>, the KMS key identifier for the encrypted cluster snapshot.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the cluster snapshot.</p>
        pub fn db_cluster_snapshot_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_snapshot_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the cluster snapshot.</p>
        pub fn set_db_cluster_snapshot_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_arn = input;
            self
        }
        /// <p>If the cluster snapshot was copied from a source cluster snapshot, the ARN for
        /// the source cluster snapshot; otherwise, a null value.</p>
        pub fn source_db_cluster_snapshot_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.source_db_cluster_snapshot_arn = Some(input.into());
            self
        }
        /// <p>If the cluster snapshot was copied from a source cluster snapshot, the ARN for
        /// the source cluster snapshot; otherwise, a null value.</p>
        pub fn set_source_db_cluster_snapshot_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_db_cluster_snapshot_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterSnapshot`](crate::model::DbClusterSnapshot)
        pub fn build(self) -> crate::model::DbClusterSnapshot {
            crate::model::DbClusterSnapshot {
                availability_zones: self.availability_zones,
                db_cluster_snapshot_identifier: self.db_cluster_snapshot_identifier,
                db_cluster_identifier: self.db_cluster_identifier,
                snapshot_create_time: self.snapshot_create_time,
                engine: self.engine,
                status: self.status,
                port: self.port.unwrap_or_default(),
                vpc_id: self.vpc_id,
                cluster_create_time: self.cluster_create_time,
                master_username: self.master_username,
                engine_version: self.engine_version,
                snapshot_type: self.snapshot_type,
                percent_progress: self.percent_progress.unwrap_or_default(),
                storage_encrypted: self.storage_encrypted.unwrap_or_default(),
                kms_key_id: self.kms_key_id,
                db_cluster_snapshot_arn: self.db_cluster_snapshot_arn,
                source_db_cluster_snapshot_arn: self.source_db_cluster_snapshot_arn,
            }
        }
    }
}
impl DbClusterSnapshot {
    /// Creates a new builder-style object to manufacture [`DbClusterSnapshot`](crate::model::DbClusterSnapshot)
    pub fn builder() -> crate::model::db_cluster_snapshot::Builder {
        crate::model::db_cluster_snapshot::Builder::default()
    }
}

/// <p>Detailed information about a cluster parameter group. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterParameterGroup {
    /// <p>Provides the name of the cluster parameter group.</p>
    pub db_cluster_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>Provides the name of the parameter group family that this cluster parameter
    /// group is compatible with.</p>
    pub db_parameter_group_family: std::option::Option<std::string::String>,
    /// <p>Provides the customer-specified description for this cluster parameter
    /// group.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the cluster parameter group.</p>
    pub db_cluster_parameter_group_arn: std::option::Option<std::string::String>,
}
impl DbClusterParameterGroup {
    /// <p>Provides the name of the cluster parameter group.</p>
    pub fn db_cluster_parameter_group_name(&self) -> std::option::Option<&str> {
        self.db_cluster_parameter_group_name.as_deref()
    }
    /// <p>Provides the name of the parameter group family that this cluster parameter
    /// group is compatible with.</p>
    pub fn db_parameter_group_family(&self) -> std::option::Option<&str> {
        self.db_parameter_group_family.as_deref()
    }
    /// <p>Provides the customer-specified description for this cluster parameter
    /// group.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the cluster parameter group.</p>
    pub fn db_cluster_parameter_group_arn(&self) -> std::option::Option<&str> {
        self.db_cluster_parameter_group_arn.as_deref()
    }
}
impl std::fmt::Debug for DbClusterParameterGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterParameterGroup");
        formatter.field(
            "db_cluster_parameter_group_name",
            &self.db_cluster_parameter_group_name,
        );
        formatter.field("db_parameter_group_family", &self.db_parameter_group_family);
        formatter.field("description", &self.description);
        formatter.field(
            "db_cluster_parameter_group_arn",
            &self.db_cluster_parameter_group_arn,
        );
        formatter.finish()
    }
}
/// See [`DbClusterParameterGroup`](crate::model::DbClusterParameterGroup)
pub mod db_cluster_parameter_group {
    /// A builder for [`DbClusterParameterGroup`](crate::model::DbClusterParameterGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) db_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) db_cluster_parameter_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Provides the name of the cluster parameter group.</p>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = Some(input.into());
            self
        }
        /// <p>Provides the name of the cluster parameter group.</p>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = input;
            self
        }
        /// <p>Provides the name of the parameter group family that this cluster parameter
        /// group is compatible with.</p>
        pub fn db_parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_family = Some(input.into());
            self
        }
        /// <p>Provides the name of the parameter group family that this cluster parameter
        /// group is compatible with.</p>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_family = input;
            self
        }
        /// <p>Provides the customer-specified description for this cluster parameter
        /// group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Provides the customer-specified description for this cluster parameter
        /// group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the cluster parameter group.</p>
        pub fn db_cluster_parameter_group_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the cluster parameter group.</p>
        pub fn set_db_cluster_parameter_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterParameterGroup`](crate::model::DbClusterParameterGroup)
        pub fn build(self) -> crate::model::DbClusterParameterGroup {
            crate::model::DbClusterParameterGroup {
                db_cluster_parameter_group_name: self.db_cluster_parameter_group_name,
                db_parameter_group_family: self.db_parameter_group_family,
                description: self.description,
                db_cluster_parameter_group_arn: self.db_cluster_parameter_group_arn,
            }
        }
    }
}
impl DbClusterParameterGroup {
    /// Creates a new builder-style object to manufacture [`DbClusterParameterGroup`](crate::model::DbClusterParameterGroup)
    pub fn builder() -> crate::model::db_cluster_parameter_group::Builder {
        crate::model::db_cluster_parameter_group::Builder::default()
    }
}

/// <p>A certificate authority (CA) certificate for an account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Certificate {
    /// <p>The unique key that identifies a certificate.</p>
    /// <p>Example: <code>rds-ca-2019</code>
    /// </p>
    pub certificate_identifier: std::option::Option<std::string::String>,
    /// <p>The type of the certificate.</p>
    /// <p>Example: <code>CA</code>
    /// </p>
    pub certificate_type: std::option::Option<std::string::String>,
    /// <p>The thumbprint of the certificate.</p>
    pub thumbprint: std::option::Option<std::string::String>,
    /// <p>The starting date-time from which the certificate is valid.</p>
    /// <p>Example: <code>2019-07-31T17:57:09Z</code>
    /// </p>
    pub valid_from: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date-time after which the certificate is no longer valid.</p>
    /// <p>Example: <code>2024-07-31T17:57:09Z</code>
    /// </p>
    pub valid_till: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Amazon Resource Name (ARN) for the certificate.</p>
    /// <p>Example: <code>arn:aws:rds:us-east-1::cert:rds-ca-2019</code>
    /// </p>
    pub certificate_arn: std::option::Option<std::string::String>,
}
impl Certificate {
    /// <p>The unique key that identifies a certificate.</p>
    /// <p>Example: <code>rds-ca-2019</code>
    /// </p>
    pub fn certificate_identifier(&self) -> std::option::Option<&str> {
        self.certificate_identifier.as_deref()
    }
    /// <p>The type of the certificate.</p>
    /// <p>Example: <code>CA</code>
    /// </p>
    pub fn certificate_type(&self) -> std::option::Option<&str> {
        self.certificate_type.as_deref()
    }
    /// <p>The thumbprint of the certificate.</p>
    pub fn thumbprint(&self) -> std::option::Option<&str> {
        self.thumbprint.as_deref()
    }
    /// <p>The starting date-time from which the certificate is valid.</p>
    /// <p>Example: <code>2019-07-31T17:57:09Z</code>
    /// </p>
    pub fn valid_from(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.valid_from.as_ref()
    }
    /// <p>The date-time after which the certificate is no longer valid.</p>
    /// <p>Example: <code>2024-07-31T17:57:09Z</code>
    /// </p>
    pub fn valid_till(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.valid_till.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) for the certificate.</p>
    /// <p>Example: <code>arn:aws:rds:us-east-1::cert:rds-ca-2019</code>
    /// </p>
    pub fn certificate_arn(&self) -> std::option::Option<&str> {
        self.certificate_arn.as_deref()
    }
}
impl std::fmt::Debug for Certificate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Certificate");
        formatter.field("certificate_identifier", &self.certificate_identifier);
        formatter.field("certificate_type", &self.certificate_type);
        formatter.field("thumbprint", &self.thumbprint);
        formatter.field("valid_from", &self.valid_from);
        formatter.field("valid_till", &self.valid_till);
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.finish()
    }
}
/// See [`Certificate`](crate::model::Certificate)
pub mod certificate {
    /// A builder for [`Certificate`](crate::model::Certificate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_identifier: std::option::Option<std::string::String>,
        pub(crate) certificate_type: std::option::Option<std::string::String>,
        pub(crate) thumbprint: std::option::Option<std::string::String>,
        pub(crate) valid_from: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) valid_till: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique key that identifies a certificate.</p>
        /// <p>Example: <code>rds-ca-2019</code>
        /// </p>
        pub fn certificate_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_identifier = Some(input.into());
            self
        }
        /// <p>The unique key that identifies a certificate.</p>
        /// <p>Example: <code>rds-ca-2019</code>
        /// </p>
        pub fn set_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_identifier = input;
            self
        }
        /// <p>The type of the certificate.</p>
        /// <p>Example: <code>CA</code>
        /// </p>
        pub fn certificate_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_type = Some(input.into());
            self
        }
        /// <p>The type of the certificate.</p>
        /// <p>Example: <code>CA</code>
        /// </p>
        pub fn set_certificate_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_type = input;
            self
        }
        /// <p>The thumbprint of the certificate.</p>
        pub fn thumbprint(mut self, input: impl Into<std::string::String>) -> Self {
            self.thumbprint = Some(input.into());
            self
        }
        /// <p>The thumbprint of the certificate.</p>
        pub fn set_thumbprint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thumbprint = input;
            self
        }
        /// <p>The starting date-time from which the certificate is valid.</p>
        /// <p>Example: <code>2019-07-31T17:57:09Z</code>
        /// </p>
        pub fn valid_from(mut self, input: aws_smithy_types::Instant) -> Self {
            self.valid_from = Some(input);
            self
        }
        /// <p>The starting date-time from which the certificate is valid.</p>
        /// <p>Example: <code>2019-07-31T17:57:09Z</code>
        /// </p>
        pub fn set_valid_from(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.valid_from = input;
            self
        }
        /// <p>The date-time after which the certificate is no longer valid.</p>
        /// <p>Example: <code>2024-07-31T17:57:09Z</code>
        /// </p>
        pub fn valid_till(mut self, input: aws_smithy_types::Instant) -> Self {
            self.valid_till = Some(input);
            self
        }
        /// <p>The date-time after which the certificate is no longer valid.</p>
        /// <p>Example: <code>2024-07-31T17:57:09Z</code>
        /// </p>
        pub fn set_valid_till(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.valid_till = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the certificate.</p>
        /// <p>Example: <code>arn:aws:rds:us-east-1::cert:rds-ca-2019</code>
        /// </p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the certificate.</p>
        /// <p>Example: <code>arn:aws:rds:us-east-1::cert:rds-ca-2019</code>
        /// </p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Certificate`](crate::model::Certificate)
        pub fn build(self) -> crate::model::Certificate {
            crate::model::Certificate {
                certificate_identifier: self.certificate_identifier,
                certificate_type: self.certificate_type,
                thumbprint: self.thumbprint,
                valid_from: self.valid_from,
                valid_till: self.valid_till,
                certificate_arn: self.certificate_arn,
            }
        }
    }
}
impl Certificate {
    /// Creates a new builder-style object to manufacture [`Certificate`](crate::model::Certificate)
    pub fn builder() -> crate::model::certificate::Builder {
        crate::model::certificate::Builder::default()
    }
}
