// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AddSourceIdentifierToSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_source_identifier_to_subscription`](crate::client::Client::add_source_identifier_to_subscription).
///
/// See [`crate::client::fluent_builders::AddSourceIdentifierToSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddSourceIdentifierToSubscription {
    _private: (),
}
impl AddSourceIdentifierToSubscription {
    /// Creates a new builder-style object to manufacture [`AddSourceIdentifierToSubscriptionInput`](crate::input::AddSourceIdentifierToSubscriptionInput)
    pub fn builder() -> crate::input::add_source_identifier_to_subscription_input::Builder {
        crate::input::add_source_identifier_to_subscription_input::Builder::default()
    }
    /// Creates a new `AddSourceIdentifierToSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddSourceIdentifierToSubscription {
    type Output = std::result::Result<
        crate::output::AddSourceIdentifierToSubscriptionOutput,
        crate::error::AddSourceIdentifierToSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_source_identifier_to_subscription_error(response)
        } else {
            crate::operation_deser::parse_add_source_identifier_to_subscription_response(response)
        }
    }
}

/// Operation shape for `AddTagsToResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_tags_to_resource`](crate::client::Client::add_tags_to_resource).
///
/// See [`crate::client::fluent_builders::AddTagsToResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddTagsToResource {
    _private: (),
}
impl AddTagsToResource {
    /// Creates a new builder-style object to manufacture [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
    pub fn builder() -> crate::input::add_tags_to_resource_input::Builder {
        crate::input::add_tags_to_resource_input::Builder::default()
    }
    /// Creates a new `AddTagsToResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddTagsToResource {
    type Output = std::result::Result<
        crate::output::AddTagsToResourceOutput,
        crate::error::AddTagsToResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_tags_to_resource_error(response)
        } else {
            crate::operation_deser::parse_add_tags_to_resource_response(response)
        }
    }
}

/// Operation shape for `ApplyPendingMaintenanceAction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`apply_pending_maintenance_action`](crate::client::Client::apply_pending_maintenance_action).
///
/// See [`crate::client::fluent_builders::ApplyPendingMaintenanceAction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ApplyPendingMaintenanceAction {
    _private: (),
}
impl ApplyPendingMaintenanceAction {
    /// Creates a new builder-style object to manufacture [`ApplyPendingMaintenanceActionInput`](crate::input::ApplyPendingMaintenanceActionInput)
    pub fn builder() -> crate::input::apply_pending_maintenance_action_input::Builder {
        crate::input::apply_pending_maintenance_action_input::Builder::default()
    }
    /// Creates a new `ApplyPendingMaintenanceAction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ApplyPendingMaintenanceAction {
    type Output = std::result::Result<
        crate::output::ApplyPendingMaintenanceActionOutput,
        crate::error::ApplyPendingMaintenanceActionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_apply_pending_maintenance_action_error(response)
        } else {
            crate::operation_deser::parse_apply_pending_maintenance_action_response(response)
        }
    }
}

/// Operation shape for `CopyDBClusterParameterGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`copy_db_cluster_parameter_group`](crate::client::Client::copy_db_cluster_parameter_group).
///
/// See [`crate::client::fluent_builders::CopyDBClusterParameterGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CopyDBClusterParameterGroup {
    _private: (),
}
impl CopyDBClusterParameterGroup {
    /// Creates a new builder-style object to manufacture [`CopyDbClusterParameterGroupInput`](crate::input::CopyDbClusterParameterGroupInput)
    pub fn builder() -> crate::input::copy_db_cluster_parameter_group_input::Builder {
        crate::input::copy_db_cluster_parameter_group_input::Builder::default()
    }
    /// Creates a new `CopyDBClusterParameterGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CopyDBClusterParameterGroup {
    type Output = std::result::Result<
        crate::output::CopyDbClusterParameterGroupOutput,
        crate::error::CopyDBClusterParameterGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_copy_db_cluster_parameter_group_error(response)
        } else {
            crate::operation_deser::parse_copy_db_cluster_parameter_group_response(response)
        }
    }
}

/// Operation shape for `CopyDBClusterSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`copy_db_cluster_snapshot`](crate::client::Client::copy_db_cluster_snapshot).
///
/// See [`crate::client::fluent_builders::CopyDBClusterSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CopyDBClusterSnapshot {
    _private: (),
}
impl CopyDBClusterSnapshot {
    /// Creates a new builder-style object to manufacture [`CopyDbClusterSnapshotInput`](crate::input::CopyDbClusterSnapshotInput)
    pub fn builder() -> crate::input::copy_db_cluster_snapshot_input::Builder {
        crate::input::copy_db_cluster_snapshot_input::Builder::default()
    }
    /// Creates a new `CopyDBClusterSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CopyDBClusterSnapshot {
    type Output = std::result::Result<
        crate::output::CopyDbClusterSnapshotOutput,
        crate::error::CopyDBClusterSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_copy_db_cluster_snapshot_error(response)
        } else {
            crate::operation_deser::parse_copy_db_cluster_snapshot_response(response)
        }
    }
}

/// Operation shape for `CreateDBCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_db_cluster`](crate::client::Client::create_db_cluster).
///
/// See [`crate::client::fluent_builders::CreateDBCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDBCluster {
    _private: (),
}
impl CreateDBCluster {
    /// Creates a new builder-style object to manufacture [`CreateDbClusterInput`](crate::input::CreateDbClusterInput)
    pub fn builder() -> crate::input::create_db_cluster_input::Builder {
        crate::input::create_db_cluster_input::Builder::default()
    }
    /// Creates a new `CreateDBCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDBCluster {
    type Output = std::result::Result<
        crate::output::CreateDbClusterOutput,
        crate::error::CreateDBClusterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_db_cluster_error(response)
        } else {
            crate::operation_deser::parse_create_db_cluster_response(response)
        }
    }
}

/// Operation shape for `CreateDBClusterParameterGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_db_cluster_parameter_group`](crate::client::Client::create_db_cluster_parameter_group).
///
/// See [`crate::client::fluent_builders::CreateDBClusterParameterGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDBClusterParameterGroup {
    _private: (),
}
impl CreateDBClusterParameterGroup {
    /// Creates a new builder-style object to manufacture [`CreateDbClusterParameterGroupInput`](crate::input::CreateDbClusterParameterGroupInput)
    pub fn builder() -> crate::input::create_db_cluster_parameter_group_input::Builder {
        crate::input::create_db_cluster_parameter_group_input::Builder::default()
    }
    /// Creates a new `CreateDBClusterParameterGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDBClusterParameterGroup {
    type Output = std::result::Result<
        crate::output::CreateDbClusterParameterGroupOutput,
        crate::error::CreateDBClusterParameterGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_db_cluster_parameter_group_error(response)
        } else {
            crate::operation_deser::parse_create_db_cluster_parameter_group_response(response)
        }
    }
}

/// Operation shape for `CreateDBClusterSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_db_cluster_snapshot`](crate::client::Client::create_db_cluster_snapshot).
///
/// See [`crate::client::fluent_builders::CreateDBClusterSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDBClusterSnapshot {
    _private: (),
}
impl CreateDBClusterSnapshot {
    /// Creates a new builder-style object to manufacture [`CreateDbClusterSnapshotInput`](crate::input::CreateDbClusterSnapshotInput)
    pub fn builder() -> crate::input::create_db_cluster_snapshot_input::Builder {
        crate::input::create_db_cluster_snapshot_input::Builder::default()
    }
    /// Creates a new `CreateDBClusterSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDBClusterSnapshot {
    type Output = std::result::Result<
        crate::output::CreateDbClusterSnapshotOutput,
        crate::error::CreateDBClusterSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_db_cluster_snapshot_error(response)
        } else {
            crate::operation_deser::parse_create_db_cluster_snapshot_response(response)
        }
    }
}

/// Operation shape for `CreateDBInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_db_instance`](crate::client::Client::create_db_instance).
///
/// See [`crate::client::fluent_builders::CreateDBInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDBInstance {
    _private: (),
}
impl CreateDBInstance {
    /// Creates a new builder-style object to manufacture [`CreateDbInstanceInput`](crate::input::CreateDbInstanceInput)
    pub fn builder() -> crate::input::create_db_instance_input::Builder {
        crate::input::create_db_instance_input::Builder::default()
    }
    /// Creates a new `CreateDBInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDBInstance {
    type Output = std::result::Result<
        crate::output::CreateDbInstanceOutput,
        crate::error::CreateDBInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_db_instance_error(response)
        } else {
            crate::operation_deser::parse_create_db_instance_response(response)
        }
    }
}

/// Operation shape for `CreateDBSubnetGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_db_subnet_group`](crate::client::Client::create_db_subnet_group).
///
/// See [`crate::client::fluent_builders::CreateDBSubnetGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDBSubnetGroup {
    _private: (),
}
impl CreateDBSubnetGroup {
    /// Creates a new builder-style object to manufacture [`CreateDbSubnetGroupInput`](crate::input::CreateDbSubnetGroupInput)
    pub fn builder() -> crate::input::create_db_subnet_group_input::Builder {
        crate::input::create_db_subnet_group_input::Builder::default()
    }
    /// Creates a new `CreateDBSubnetGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDBSubnetGroup {
    type Output = std::result::Result<
        crate::output::CreateDbSubnetGroupOutput,
        crate::error::CreateDBSubnetGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_db_subnet_group_error(response)
        } else {
            crate::operation_deser::parse_create_db_subnet_group_response(response)
        }
    }
}

/// Operation shape for `CreateEventSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_event_subscription`](crate::client::Client::create_event_subscription).
///
/// See [`crate::client::fluent_builders::CreateEventSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateEventSubscription {
    _private: (),
}
impl CreateEventSubscription {
    /// Creates a new builder-style object to manufacture [`CreateEventSubscriptionInput`](crate::input::CreateEventSubscriptionInput)
    pub fn builder() -> crate::input::create_event_subscription_input::Builder {
        crate::input::create_event_subscription_input::Builder::default()
    }
    /// Creates a new `CreateEventSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateEventSubscription {
    type Output = std::result::Result<
        crate::output::CreateEventSubscriptionOutput,
        crate::error::CreateEventSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_event_subscription_error(response)
        } else {
            crate::operation_deser::parse_create_event_subscription_response(response)
        }
    }
}

/// Operation shape for `CreateGlobalCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_global_cluster`](crate::client::Client::create_global_cluster).
///
/// See [`crate::client::fluent_builders::CreateGlobalCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateGlobalCluster {
    _private: (),
}
impl CreateGlobalCluster {
    /// Creates a new builder-style object to manufacture [`CreateGlobalClusterInput`](crate::input::CreateGlobalClusterInput)
    pub fn builder() -> crate::input::create_global_cluster_input::Builder {
        crate::input::create_global_cluster_input::Builder::default()
    }
    /// Creates a new `CreateGlobalCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateGlobalCluster {
    type Output = std::result::Result<
        crate::output::CreateGlobalClusterOutput,
        crate::error::CreateGlobalClusterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_global_cluster_error(response)
        } else {
            crate::operation_deser::parse_create_global_cluster_response(response)
        }
    }
}

/// Operation shape for `DeleteDBCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_db_cluster`](crate::client::Client::delete_db_cluster).
///
/// See [`crate::client::fluent_builders::DeleteDBCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDBCluster {
    _private: (),
}
impl DeleteDBCluster {
    /// Creates a new builder-style object to manufacture [`DeleteDbClusterInput`](crate::input::DeleteDbClusterInput)
    pub fn builder() -> crate::input::delete_db_cluster_input::Builder {
        crate::input::delete_db_cluster_input::Builder::default()
    }
    /// Creates a new `DeleteDBCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDBCluster {
    type Output = std::result::Result<
        crate::output::DeleteDbClusterOutput,
        crate::error::DeleteDBClusterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_db_cluster_error(response)
        } else {
            crate::operation_deser::parse_delete_db_cluster_response(response)
        }
    }
}

/// Operation shape for `DeleteDBClusterParameterGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_db_cluster_parameter_group`](crate::client::Client::delete_db_cluster_parameter_group).
///
/// See [`crate::client::fluent_builders::DeleteDBClusterParameterGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDBClusterParameterGroup {
    _private: (),
}
impl DeleteDBClusterParameterGroup {
    /// Creates a new builder-style object to manufacture [`DeleteDbClusterParameterGroupInput`](crate::input::DeleteDbClusterParameterGroupInput)
    pub fn builder() -> crate::input::delete_db_cluster_parameter_group_input::Builder {
        crate::input::delete_db_cluster_parameter_group_input::Builder::default()
    }
    /// Creates a new `DeleteDBClusterParameterGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDBClusterParameterGroup {
    type Output = std::result::Result<
        crate::output::DeleteDbClusterParameterGroupOutput,
        crate::error::DeleteDBClusterParameterGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_db_cluster_parameter_group_error(response)
        } else {
            crate::operation_deser::parse_delete_db_cluster_parameter_group_response(response)
        }
    }
}

/// Operation shape for `DeleteDBClusterSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_db_cluster_snapshot`](crate::client::Client::delete_db_cluster_snapshot).
///
/// See [`crate::client::fluent_builders::DeleteDBClusterSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDBClusterSnapshot {
    _private: (),
}
impl DeleteDBClusterSnapshot {
    /// Creates a new builder-style object to manufacture [`DeleteDbClusterSnapshotInput`](crate::input::DeleteDbClusterSnapshotInput)
    pub fn builder() -> crate::input::delete_db_cluster_snapshot_input::Builder {
        crate::input::delete_db_cluster_snapshot_input::Builder::default()
    }
    /// Creates a new `DeleteDBClusterSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDBClusterSnapshot {
    type Output = std::result::Result<
        crate::output::DeleteDbClusterSnapshotOutput,
        crate::error::DeleteDBClusterSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_db_cluster_snapshot_error(response)
        } else {
            crate::operation_deser::parse_delete_db_cluster_snapshot_response(response)
        }
    }
}

/// Operation shape for `DeleteDBInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_db_instance`](crate::client::Client::delete_db_instance).
///
/// See [`crate::client::fluent_builders::DeleteDBInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDBInstance {
    _private: (),
}
impl DeleteDBInstance {
    /// Creates a new builder-style object to manufacture [`DeleteDbInstanceInput`](crate::input::DeleteDbInstanceInput)
    pub fn builder() -> crate::input::delete_db_instance_input::Builder {
        crate::input::delete_db_instance_input::Builder::default()
    }
    /// Creates a new `DeleteDBInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDBInstance {
    type Output = std::result::Result<
        crate::output::DeleteDbInstanceOutput,
        crate::error::DeleteDBInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_db_instance_error(response)
        } else {
            crate::operation_deser::parse_delete_db_instance_response(response)
        }
    }
}

/// Operation shape for `DeleteDBSubnetGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_db_subnet_group`](crate::client::Client::delete_db_subnet_group).
///
/// See [`crate::client::fluent_builders::DeleteDBSubnetGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDBSubnetGroup {
    _private: (),
}
impl DeleteDBSubnetGroup {
    /// Creates a new builder-style object to manufacture [`DeleteDbSubnetGroupInput`](crate::input::DeleteDbSubnetGroupInput)
    pub fn builder() -> crate::input::delete_db_subnet_group_input::Builder {
        crate::input::delete_db_subnet_group_input::Builder::default()
    }
    /// Creates a new `DeleteDBSubnetGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDBSubnetGroup {
    type Output = std::result::Result<
        crate::output::DeleteDbSubnetGroupOutput,
        crate::error::DeleteDBSubnetGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_db_subnet_group_error(response)
        } else {
            crate::operation_deser::parse_delete_db_subnet_group_response(response)
        }
    }
}

/// Operation shape for `DeleteEventSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_event_subscription`](crate::client::Client::delete_event_subscription).
///
/// See [`crate::client::fluent_builders::DeleteEventSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEventSubscription {
    _private: (),
}
impl DeleteEventSubscription {
    /// Creates a new builder-style object to manufacture [`DeleteEventSubscriptionInput`](crate::input::DeleteEventSubscriptionInput)
    pub fn builder() -> crate::input::delete_event_subscription_input::Builder {
        crate::input::delete_event_subscription_input::Builder::default()
    }
    /// Creates a new `DeleteEventSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEventSubscription {
    type Output = std::result::Result<
        crate::output::DeleteEventSubscriptionOutput,
        crate::error::DeleteEventSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_event_subscription_error(response)
        } else {
            crate::operation_deser::parse_delete_event_subscription_response(response)
        }
    }
}

/// Operation shape for `DeleteGlobalCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_global_cluster`](crate::client::Client::delete_global_cluster).
///
/// See [`crate::client::fluent_builders::DeleteGlobalCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteGlobalCluster {
    _private: (),
}
impl DeleteGlobalCluster {
    /// Creates a new builder-style object to manufacture [`DeleteGlobalClusterInput`](crate::input::DeleteGlobalClusterInput)
    pub fn builder() -> crate::input::delete_global_cluster_input::Builder {
        crate::input::delete_global_cluster_input::Builder::default()
    }
    /// Creates a new `DeleteGlobalCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteGlobalCluster {
    type Output = std::result::Result<
        crate::output::DeleteGlobalClusterOutput,
        crate::error::DeleteGlobalClusterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_global_cluster_error(response)
        } else {
            crate::operation_deser::parse_delete_global_cluster_response(response)
        }
    }
}

/// Operation shape for `DescribeCertificates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_certificates`](crate::client::Client::describe_certificates).
///
/// See [`crate::client::fluent_builders::DescribeCertificates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCertificates {
    _private: (),
}
impl DescribeCertificates {
    /// Creates a new builder-style object to manufacture [`DescribeCertificatesInput`](crate::input::DescribeCertificatesInput)
    pub fn builder() -> crate::input::describe_certificates_input::Builder {
        crate::input::describe_certificates_input::Builder::default()
    }
    /// Creates a new `DescribeCertificates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCertificates {
    type Output = std::result::Result<
        crate::output::DescribeCertificatesOutput,
        crate::error::DescribeCertificatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_certificates_error(response)
        } else {
            crate::operation_deser::parse_describe_certificates_response(response)
        }
    }
}

/// Operation shape for `DescribeDBClusterParameterGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_db_cluster_parameter_groups`](crate::client::Client::describe_db_cluster_parameter_groups).
///
/// See [`crate::client::fluent_builders::DescribeDBClusterParameterGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDBClusterParameterGroups {
    _private: (),
}
impl DescribeDBClusterParameterGroups {
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterParameterGroupsInput`](crate::input::DescribeDbClusterParameterGroupsInput)
    pub fn builder() -> crate::input::describe_db_cluster_parameter_groups_input::Builder {
        crate::input::describe_db_cluster_parameter_groups_input::Builder::default()
    }
    /// Creates a new `DescribeDBClusterParameterGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDBClusterParameterGroups {
    type Output = std::result::Result<
        crate::output::DescribeDbClusterParameterGroupsOutput,
        crate::error::DescribeDBClusterParameterGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_db_cluster_parameter_groups_error(response)
        } else {
            crate::operation_deser::parse_describe_db_cluster_parameter_groups_response(response)
        }
    }
}

/// Operation shape for `DescribeDBClusterParameters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_db_cluster_parameters`](crate::client::Client::describe_db_cluster_parameters).
///
/// See [`crate::client::fluent_builders::DescribeDBClusterParameters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDBClusterParameters {
    _private: (),
}
impl DescribeDBClusterParameters {
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterParametersInput`](crate::input::DescribeDbClusterParametersInput)
    pub fn builder() -> crate::input::describe_db_cluster_parameters_input::Builder {
        crate::input::describe_db_cluster_parameters_input::Builder::default()
    }
    /// Creates a new `DescribeDBClusterParameters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDBClusterParameters {
    type Output = std::result::Result<
        crate::output::DescribeDbClusterParametersOutput,
        crate::error::DescribeDBClusterParametersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_db_cluster_parameters_error(response)
        } else {
            crate::operation_deser::parse_describe_db_cluster_parameters_response(response)
        }
    }
}

/// Operation shape for `DescribeDBClusters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_db_clusters`](crate::client::Client::describe_db_clusters).
///
/// See [`crate::client::fluent_builders::DescribeDBClusters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDBClusters {
    _private: (),
}
impl DescribeDBClusters {
    /// Creates a new builder-style object to manufacture [`DescribeDbClustersInput`](crate::input::DescribeDbClustersInput)
    pub fn builder() -> crate::input::describe_db_clusters_input::Builder {
        crate::input::describe_db_clusters_input::Builder::default()
    }
    /// Creates a new `DescribeDBClusters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDBClusters {
    type Output = std::result::Result<
        crate::output::DescribeDbClustersOutput,
        crate::error::DescribeDBClustersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_db_clusters_error(response)
        } else {
            crate::operation_deser::parse_describe_db_clusters_response(response)
        }
    }
}

/// Operation shape for `DescribeDBClusterSnapshotAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_db_cluster_snapshot_attributes`](crate::client::Client::describe_db_cluster_snapshot_attributes).
///
/// See [`crate::client::fluent_builders::DescribeDBClusterSnapshotAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDBClusterSnapshotAttributes {
    _private: (),
}
impl DescribeDBClusterSnapshotAttributes {
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterSnapshotAttributesInput`](crate::input::DescribeDbClusterSnapshotAttributesInput)
    pub fn builder() -> crate::input::describe_db_cluster_snapshot_attributes_input::Builder {
        crate::input::describe_db_cluster_snapshot_attributes_input::Builder::default()
    }
    /// Creates a new `DescribeDBClusterSnapshotAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDBClusterSnapshotAttributes {
    type Output = std::result::Result<
        crate::output::DescribeDbClusterSnapshotAttributesOutput,
        crate::error::DescribeDBClusterSnapshotAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_db_cluster_snapshot_attributes_error(response)
        } else {
            crate::operation_deser::parse_describe_db_cluster_snapshot_attributes_response(response)
        }
    }
}

/// Operation shape for `DescribeDBClusterSnapshots`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_db_cluster_snapshots`](crate::client::Client::describe_db_cluster_snapshots).
///
/// See [`crate::client::fluent_builders::DescribeDBClusterSnapshots`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDBClusterSnapshots {
    _private: (),
}
impl DescribeDBClusterSnapshots {
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterSnapshotsInput`](crate::input::DescribeDbClusterSnapshotsInput)
    pub fn builder() -> crate::input::describe_db_cluster_snapshots_input::Builder {
        crate::input::describe_db_cluster_snapshots_input::Builder::default()
    }
    /// Creates a new `DescribeDBClusterSnapshots` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDBClusterSnapshots {
    type Output = std::result::Result<
        crate::output::DescribeDbClusterSnapshotsOutput,
        crate::error::DescribeDBClusterSnapshotsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_db_cluster_snapshots_error(response)
        } else {
            crate::operation_deser::parse_describe_db_cluster_snapshots_response(response)
        }
    }
}

/// Operation shape for `DescribeDBEngineVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_db_engine_versions`](crate::client::Client::describe_db_engine_versions).
///
/// See [`crate::client::fluent_builders::DescribeDBEngineVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDBEngineVersions {
    _private: (),
}
impl DescribeDBEngineVersions {
    /// Creates a new builder-style object to manufacture [`DescribeDbEngineVersionsInput`](crate::input::DescribeDbEngineVersionsInput)
    pub fn builder() -> crate::input::describe_db_engine_versions_input::Builder {
        crate::input::describe_db_engine_versions_input::Builder::default()
    }
    /// Creates a new `DescribeDBEngineVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDBEngineVersions {
    type Output = std::result::Result<
        crate::output::DescribeDbEngineVersionsOutput,
        crate::error::DescribeDBEngineVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_db_engine_versions_error(response)
        } else {
            crate::operation_deser::parse_describe_db_engine_versions_response(response)
        }
    }
}

/// Operation shape for `DescribeDBInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_db_instances`](crate::client::Client::describe_db_instances).
///
/// See [`crate::client::fluent_builders::DescribeDBInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDBInstances {
    _private: (),
}
impl DescribeDBInstances {
    /// Creates a new builder-style object to manufacture [`DescribeDbInstancesInput`](crate::input::DescribeDbInstancesInput)
    pub fn builder() -> crate::input::describe_db_instances_input::Builder {
        crate::input::describe_db_instances_input::Builder::default()
    }
    /// Creates a new `DescribeDBInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDBInstances {
    type Output = std::result::Result<
        crate::output::DescribeDbInstancesOutput,
        crate::error::DescribeDBInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_db_instances_error(response)
        } else {
            crate::operation_deser::parse_describe_db_instances_response(response)
        }
    }
}

/// Operation shape for `DescribeDBSubnetGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_db_subnet_groups`](crate::client::Client::describe_db_subnet_groups).
///
/// See [`crate::client::fluent_builders::DescribeDBSubnetGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDBSubnetGroups {
    _private: (),
}
impl DescribeDBSubnetGroups {
    /// Creates a new builder-style object to manufacture [`DescribeDbSubnetGroupsInput`](crate::input::DescribeDbSubnetGroupsInput)
    pub fn builder() -> crate::input::describe_db_subnet_groups_input::Builder {
        crate::input::describe_db_subnet_groups_input::Builder::default()
    }
    /// Creates a new `DescribeDBSubnetGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDBSubnetGroups {
    type Output = std::result::Result<
        crate::output::DescribeDbSubnetGroupsOutput,
        crate::error::DescribeDBSubnetGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_db_subnet_groups_error(response)
        } else {
            crate::operation_deser::parse_describe_db_subnet_groups_response(response)
        }
    }
}

/// Operation shape for `DescribeEngineDefaultClusterParameters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_engine_default_cluster_parameters`](crate::client::Client::describe_engine_default_cluster_parameters).
///
/// See [`crate::client::fluent_builders::DescribeEngineDefaultClusterParameters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEngineDefaultClusterParameters {
    _private: (),
}
impl DescribeEngineDefaultClusterParameters {
    /// Creates a new builder-style object to manufacture [`DescribeEngineDefaultClusterParametersInput`](crate::input::DescribeEngineDefaultClusterParametersInput)
    pub fn builder() -> crate::input::describe_engine_default_cluster_parameters_input::Builder {
        crate::input::describe_engine_default_cluster_parameters_input::Builder::default()
    }
    /// Creates a new `DescribeEngineDefaultClusterParameters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEngineDefaultClusterParameters {
    type Output = std::result::Result<
        crate::output::DescribeEngineDefaultClusterParametersOutput,
        crate::error::DescribeEngineDefaultClusterParametersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_engine_default_cluster_parameters_error(response)
        } else {
            crate::operation_deser::parse_describe_engine_default_cluster_parameters_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeEventCategories`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_event_categories`](crate::client::Client::describe_event_categories).
///
/// See [`crate::client::fluent_builders::DescribeEventCategories`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEventCategories {
    _private: (),
}
impl DescribeEventCategories {
    /// Creates a new builder-style object to manufacture [`DescribeEventCategoriesInput`](crate::input::DescribeEventCategoriesInput)
    pub fn builder() -> crate::input::describe_event_categories_input::Builder {
        crate::input::describe_event_categories_input::Builder::default()
    }
    /// Creates a new `DescribeEventCategories` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEventCategories {
    type Output = std::result::Result<
        crate::output::DescribeEventCategoriesOutput,
        crate::error::DescribeEventCategoriesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_event_categories_error(response)
        } else {
            crate::operation_deser::parse_describe_event_categories_response(response)
        }
    }
}

/// Operation shape for `DescribeEvents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_events`](crate::client::Client::describe_events).
///
/// See [`crate::client::fluent_builders::DescribeEvents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEvents {
    _private: (),
}
impl DescribeEvents {
    /// Creates a new builder-style object to manufacture [`DescribeEventsInput`](crate::input::DescribeEventsInput)
    pub fn builder() -> crate::input::describe_events_input::Builder {
        crate::input::describe_events_input::Builder::default()
    }
    /// Creates a new `DescribeEvents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEvents {
    type Output =
        std::result::Result<crate::output::DescribeEventsOutput, crate::error::DescribeEventsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_events_error(response)
        } else {
            crate::operation_deser::parse_describe_events_response(response)
        }
    }
}

/// Operation shape for `DescribeEventSubscriptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_event_subscriptions`](crate::client::Client::describe_event_subscriptions).
///
/// See [`crate::client::fluent_builders::DescribeEventSubscriptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEventSubscriptions {
    _private: (),
}
impl DescribeEventSubscriptions {
    /// Creates a new builder-style object to manufacture [`DescribeEventSubscriptionsInput`](crate::input::DescribeEventSubscriptionsInput)
    pub fn builder() -> crate::input::describe_event_subscriptions_input::Builder {
        crate::input::describe_event_subscriptions_input::Builder::default()
    }
    /// Creates a new `DescribeEventSubscriptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEventSubscriptions {
    type Output = std::result::Result<
        crate::output::DescribeEventSubscriptionsOutput,
        crate::error::DescribeEventSubscriptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_event_subscriptions_error(response)
        } else {
            crate::operation_deser::parse_describe_event_subscriptions_response(response)
        }
    }
}

/// Operation shape for `DescribeGlobalClusters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_global_clusters`](crate::client::Client::describe_global_clusters).
///
/// See [`crate::client::fluent_builders::DescribeGlobalClusters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeGlobalClusters {
    _private: (),
}
impl DescribeGlobalClusters {
    /// Creates a new builder-style object to manufacture [`DescribeGlobalClustersInput`](crate::input::DescribeGlobalClustersInput)
    pub fn builder() -> crate::input::describe_global_clusters_input::Builder {
        crate::input::describe_global_clusters_input::Builder::default()
    }
    /// Creates a new `DescribeGlobalClusters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeGlobalClusters {
    type Output = std::result::Result<
        crate::output::DescribeGlobalClustersOutput,
        crate::error::DescribeGlobalClustersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_global_clusters_error(response)
        } else {
            crate::operation_deser::parse_describe_global_clusters_response(response)
        }
    }
}

/// Operation shape for `DescribeOrderableDBInstanceOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_orderable_db_instance_options`](crate::client::Client::describe_orderable_db_instance_options).
///
/// See [`crate::client::fluent_builders::DescribeOrderableDBInstanceOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeOrderableDBInstanceOptions {
    _private: (),
}
impl DescribeOrderableDBInstanceOptions {
    /// Creates a new builder-style object to manufacture [`DescribeOrderableDbInstanceOptionsInput`](crate::input::DescribeOrderableDbInstanceOptionsInput)
    pub fn builder() -> crate::input::describe_orderable_db_instance_options_input::Builder {
        crate::input::describe_orderable_db_instance_options_input::Builder::default()
    }
    /// Creates a new `DescribeOrderableDBInstanceOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeOrderableDBInstanceOptions {
    type Output = std::result::Result<
        crate::output::DescribeOrderableDbInstanceOptionsOutput,
        crate::error::DescribeOrderableDBInstanceOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_orderable_db_instance_options_error(response)
        } else {
            crate::operation_deser::parse_describe_orderable_db_instance_options_response(response)
        }
    }
}

/// Operation shape for `DescribePendingMaintenanceActions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_pending_maintenance_actions`](crate::client::Client::describe_pending_maintenance_actions).
///
/// See [`crate::client::fluent_builders::DescribePendingMaintenanceActions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePendingMaintenanceActions {
    _private: (),
}
impl DescribePendingMaintenanceActions {
    /// Creates a new builder-style object to manufacture [`DescribePendingMaintenanceActionsInput`](crate::input::DescribePendingMaintenanceActionsInput)
    pub fn builder() -> crate::input::describe_pending_maintenance_actions_input::Builder {
        crate::input::describe_pending_maintenance_actions_input::Builder::default()
    }
    /// Creates a new `DescribePendingMaintenanceActions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePendingMaintenanceActions {
    type Output = std::result::Result<
        crate::output::DescribePendingMaintenanceActionsOutput,
        crate::error::DescribePendingMaintenanceActionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_pending_maintenance_actions_error(response)
        } else {
            crate::operation_deser::parse_describe_pending_maintenance_actions_response(response)
        }
    }
}

/// Operation shape for `FailoverDBCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`failover_db_cluster`](crate::client::Client::failover_db_cluster).
///
/// See [`crate::client::fluent_builders::FailoverDBCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct FailoverDBCluster {
    _private: (),
}
impl FailoverDBCluster {
    /// Creates a new builder-style object to manufacture [`FailoverDbClusterInput`](crate::input::FailoverDbClusterInput)
    pub fn builder() -> crate::input::failover_db_cluster_input::Builder {
        crate::input::failover_db_cluster_input::Builder::default()
    }
    /// Creates a new `FailoverDBCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for FailoverDBCluster {
    type Output = std::result::Result<
        crate::output::FailoverDbClusterOutput,
        crate::error::FailoverDBClusterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_failover_db_cluster_error(response)
        } else {
            crate::operation_deser::parse_failover_db_cluster_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ModifyDBCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_db_cluster`](crate::client::Client::modify_db_cluster).
///
/// See [`crate::client::fluent_builders::ModifyDBCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyDBCluster {
    _private: (),
}
impl ModifyDBCluster {
    /// Creates a new builder-style object to manufacture [`ModifyDbClusterInput`](crate::input::ModifyDbClusterInput)
    pub fn builder() -> crate::input::modify_db_cluster_input::Builder {
        crate::input::modify_db_cluster_input::Builder::default()
    }
    /// Creates a new `ModifyDBCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyDBCluster {
    type Output = std::result::Result<
        crate::output::ModifyDbClusterOutput,
        crate::error::ModifyDBClusterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_db_cluster_error(response)
        } else {
            crate::operation_deser::parse_modify_db_cluster_response(response)
        }
    }
}

/// Operation shape for `ModifyDBClusterParameterGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_db_cluster_parameter_group`](crate::client::Client::modify_db_cluster_parameter_group).
///
/// See [`crate::client::fluent_builders::ModifyDBClusterParameterGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyDBClusterParameterGroup {
    _private: (),
}
impl ModifyDBClusterParameterGroup {
    /// Creates a new builder-style object to manufacture [`ModifyDbClusterParameterGroupInput`](crate::input::ModifyDbClusterParameterGroupInput)
    pub fn builder() -> crate::input::modify_db_cluster_parameter_group_input::Builder {
        crate::input::modify_db_cluster_parameter_group_input::Builder::default()
    }
    /// Creates a new `ModifyDBClusterParameterGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyDBClusterParameterGroup {
    type Output = std::result::Result<
        crate::output::ModifyDbClusterParameterGroupOutput,
        crate::error::ModifyDBClusterParameterGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_db_cluster_parameter_group_error(response)
        } else {
            crate::operation_deser::parse_modify_db_cluster_parameter_group_response(response)
        }
    }
}

/// Operation shape for `ModifyDBClusterSnapshotAttribute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_db_cluster_snapshot_attribute`](crate::client::Client::modify_db_cluster_snapshot_attribute).
///
/// See [`crate::client::fluent_builders::ModifyDBClusterSnapshotAttribute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyDBClusterSnapshotAttribute {
    _private: (),
}
impl ModifyDBClusterSnapshotAttribute {
    /// Creates a new builder-style object to manufacture [`ModifyDbClusterSnapshotAttributeInput`](crate::input::ModifyDbClusterSnapshotAttributeInput)
    pub fn builder() -> crate::input::modify_db_cluster_snapshot_attribute_input::Builder {
        crate::input::modify_db_cluster_snapshot_attribute_input::Builder::default()
    }
    /// Creates a new `ModifyDBClusterSnapshotAttribute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyDBClusterSnapshotAttribute {
    type Output = std::result::Result<
        crate::output::ModifyDbClusterSnapshotAttributeOutput,
        crate::error::ModifyDBClusterSnapshotAttributeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_db_cluster_snapshot_attribute_error(response)
        } else {
            crate::operation_deser::parse_modify_db_cluster_snapshot_attribute_response(response)
        }
    }
}

/// Operation shape for `ModifyDBInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_db_instance`](crate::client::Client::modify_db_instance).
///
/// See [`crate::client::fluent_builders::ModifyDBInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyDBInstance {
    _private: (),
}
impl ModifyDBInstance {
    /// Creates a new builder-style object to manufacture [`ModifyDbInstanceInput`](crate::input::ModifyDbInstanceInput)
    pub fn builder() -> crate::input::modify_db_instance_input::Builder {
        crate::input::modify_db_instance_input::Builder::default()
    }
    /// Creates a new `ModifyDBInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyDBInstance {
    type Output = std::result::Result<
        crate::output::ModifyDbInstanceOutput,
        crate::error::ModifyDBInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_db_instance_error(response)
        } else {
            crate::operation_deser::parse_modify_db_instance_response(response)
        }
    }
}

/// Operation shape for `ModifyDBSubnetGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_db_subnet_group`](crate::client::Client::modify_db_subnet_group).
///
/// See [`crate::client::fluent_builders::ModifyDBSubnetGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyDBSubnetGroup {
    _private: (),
}
impl ModifyDBSubnetGroup {
    /// Creates a new builder-style object to manufacture [`ModifyDbSubnetGroupInput`](crate::input::ModifyDbSubnetGroupInput)
    pub fn builder() -> crate::input::modify_db_subnet_group_input::Builder {
        crate::input::modify_db_subnet_group_input::Builder::default()
    }
    /// Creates a new `ModifyDBSubnetGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyDBSubnetGroup {
    type Output = std::result::Result<
        crate::output::ModifyDbSubnetGroupOutput,
        crate::error::ModifyDBSubnetGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_db_subnet_group_error(response)
        } else {
            crate::operation_deser::parse_modify_db_subnet_group_response(response)
        }
    }
}

/// Operation shape for `ModifyEventSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_event_subscription`](crate::client::Client::modify_event_subscription).
///
/// See [`crate::client::fluent_builders::ModifyEventSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyEventSubscription {
    _private: (),
}
impl ModifyEventSubscription {
    /// Creates a new builder-style object to manufacture [`ModifyEventSubscriptionInput`](crate::input::ModifyEventSubscriptionInput)
    pub fn builder() -> crate::input::modify_event_subscription_input::Builder {
        crate::input::modify_event_subscription_input::Builder::default()
    }
    /// Creates a new `ModifyEventSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyEventSubscription {
    type Output = std::result::Result<
        crate::output::ModifyEventSubscriptionOutput,
        crate::error::ModifyEventSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_event_subscription_error(response)
        } else {
            crate::operation_deser::parse_modify_event_subscription_response(response)
        }
    }
}

/// Operation shape for `ModifyGlobalCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_global_cluster`](crate::client::Client::modify_global_cluster).
///
/// See [`crate::client::fluent_builders::ModifyGlobalCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyGlobalCluster {
    _private: (),
}
impl ModifyGlobalCluster {
    /// Creates a new builder-style object to manufacture [`ModifyGlobalClusterInput`](crate::input::ModifyGlobalClusterInput)
    pub fn builder() -> crate::input::modify_global_cluster_input::Builder {
        crate::input::modify_global_cluster_input::Builder::default()
    }
    /// Creates a new `ModifyGlobalCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyGlobalCluster {
    type Output = std::result::Result<
        crate::output::ModifyGlobalClusterOutput,
        crate::error::ModifyGlobalClusterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_global_cluster_error(response)
        } else {
            crate::operation_deser::parse_modify_global_cluster_response(response)
        }
    }
}

/// Operation shape for `RebootDBInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reboot_db_instance`](crate::client::Client::reboot_db_instance).
///
/// See [`crate::client::fluent_builders::RebootDBInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RebootDBInstance {
    _private: (),
}
impl RebootDBInstance {
    /// Creates a new builder-style object to manufacture [`RebootDbInstanceInput`](crate::input::RebootDbInstanceInput)
    pub fn builder() -> crate::input::reboot_db_instance_input::Builder {
        crate::input::reboot_db_instance_input::Builder::default()
    }
    /// Creates a new `RebootDBInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RebootDBInstance {
    type Output = std::result::Result<
        crate::output::RebootDbInstanceOutput,
        crate::error::RebootDBInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reboot_db_instance_error(response)
        } else {
            crate::operation_deser::parse_reboot_db_instance_response(response)
        }
    }
}

/// Operation shape for `RemoveFromGlobalCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_from_global_cluster`](crate::client::Client::remove_from_global_cluster).
///
/// See [`crate::client::fluent_builders::RemoveFromGlobalCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveFromGlobalCluster {
    _private: (),
}
impl RemoveFromGlobalCluster {
    /// Creates a new builder-style object to manufacture [`RemoveFromGlobalClusterInput`](crate::input::RemoveFromGlobalClusterInput)
    pub fn builder() -> crate::input::remove_from_global_cluster_input::Builder {
        crate::input::remove_from_global_cluster_input::Builder::default()
    }
    /// Creates a new `RemoveFromGlobalCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveFromGlobalCluster {
    type Output = std::result::Result<
        crate::output::RemoveFromGlobalClusterOutput,
        crate::error::RemoveFromGlobalClusterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_from_global_cluster_error(response)
        } else {
            crate::operation_deser::parse_remove_from_global_cluster_response(response)
        }
    }
}

/// Operation shape for `RemoveSourceIdentifierFromSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_source_identifier_from_subscription`](crate::client::Client::remove_source_identifier_from_subscription).
///
/// See [`crate::client::fluent_builders::RemoveSourceIdentifierFromSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveSourceIdentifierFromSubscription {
    _private: (),
}
impl RemoveSourceIdentifierFromSubscription {
    /// Creates a new builder-style object to manufacture [`RemoveSourceIdentifierFromSubscriptionInput`](crate::input::RemoveSourceIdentifierFromSubscriptionInput)
    pub fn builder() -> crate::input::remove_source_identifier_from_subscription_input::Builder {
        crate::input::remove_source_identifier_from_subscription_input::Builder::default()
    }
    /// Creates a new `RemoveSourceIdentifierFromSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveSourceIdentifierFromSubscription {
    type Output = std::result::Result<
        crate::output::RemoveSourceIdentifierFromSubscriptionOutput,
        crate::error::RemoveSourceIdentifierFromSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_source_identifier_from_subscription_error(response)
        } else {
            crate::operation_deser::parse_remove_source_identifier_from_subscription_response(
                response,
            )
        }
    }
}

/// Operation shape for `RemoveTagsFromResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_tags_from_resource`](crate::client::Client::remove_tags_from_resource).
///
/// See [`crate::client::fluent_builders::RemoveTagsFromResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveTagsFromResource {
    _private: (),
}
impl RemoveTagsFromResource {
    /// Creates a new builder-style object to manufacture [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
    pub fn builder() -> crate::input::remove_tags_from_resource_input::Builder {
        crate::input::remove_tags_from_resource_input::Builder::default()
    }
    /// Creates a new `RemoveTagsFromResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveTagsFromResource {
    type Output = std::result::Result<
        crate::output::RemoveTagsFromResourceOutput,
        crate::error::RemoveTagsFromResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_tags_from_resource_error(response)
        } else {
            crate::operation_deser::parse_remove_tags_from_resource_response(response)
        }
    }
}

/// Operation shape for `ResetDBClusterParameterGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reset_db_cluster_parameter_group`](crate::client::Client::reset_db_cluster_parameter_group).
///
/// See [`crate::client::fluent_builders::ResetDBClusterParameterGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResetDBClusterParameterGroup {
    _private: (),
}
impl ResetDBClusterParameterGroup {
    /// Creates a new builder-style object to manufacture [`ResetDbClusterParameterGroupInput`](crate::input::ResetDbClusterParameterGroupInput)
    pub fn builder() -> crate::input::reset_db_cluster_parameter_group_input::Builder {
        crate::input::reset_db_cluster_parameter_group_input::Builder::default()
    }
    /// Creates a new `ResetDBClusterParameterGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResetDBClusterParameterGroup {
    type Output = std::result::Result<
        crate::output::ResetDbClusterParameterGroupOutput,
        crate::error::ResetDBClusterParameterGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reset_db_cluster_parameter_group_error(response)
        } else {
            crate::operation_deser::parse_reset_db_cluster_parameter_group_response(response)
        }
    }
}

/// Operation shape for `RestoreDBClusterFromSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`restore_db_cluster_from_snapshot`](crate::client::Client::restore_db_cluster_from_snapshot).
///
/// See [`crate::client::fluent_builders::RestoreDBClusterFromSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RestoreDBClusterFromSnapshot {
    _private: (),
}
impl RestoreDBClusterFromSnapshot {
    /// Creates a new builder-style object to manufacture [`RestoreDbClusterFromSnapshotInput`](crate::input::RestoreDbClusterFromSnapshotInput)
    pub fn builder() -> crate::input::restore_db_cluster_from_snapshot_input::Builder {
        crate::input::restore_db_cluster_from_snapshot_input::Builder::default()
    }
    /// Creates a new `RestoreDBClusterFromSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RestoreDBClusterFromSnapshot {
    type Output = std::result::Result<
        crate::output::RestoreDbClusterFromSnapshotOutput,
        crate::error::RestoreDBClusterFromSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_restore_db_cluster_from_snapshot_error(response)
        } else {
            crate::operation_deser::parse_restore_db_cluster_from_snapshot_response(response)
        }
    }
}

/// Operation shape for `RestoreDBClusterToPointInTime`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`restore_db_cluster_to_point_in_time`](crate::client::Client::restore_db_cluster_to_point_in_time).
///
/// See [`crate::client::fluent_builders::RestoreDBClusterToPointInTime`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RestoreDBClusterToPointInTime {
    _private: (),
}
impl RestoreDBClusterToPointInTime {
    /// Creates a new builder-style object to manufacture [`RestoreDbClusterToPointInTimeInput`](crate::input::RestoreDbClusterToPointInTimeInput)
    pub fn builder() -> crate::input::restore_db_cluster_to_point_in_time_input::Builder {
        crate::input::restore_db_cluster_to_point_in_time_input::Builder::default()
    }
    /// Creates a new `RestoreDBClusterToPointInTime` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RestoreDBClusterToPointInTime {
    type Output = std::result::Result<
        crate::output::RestoreDbClusterToPointInTimeOutput,
        crate::error::RestoreDBClusterToPointInTimeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_restore_db_cluster_to_point_in_time_error(response)
        } else {
            crate::operation_deser::parse_restore_db_cluster_to_point_in_time_response(response)
        }
    }
}

/// Operation shape for `StartDBCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_db_cluster`](crate::client::Client::start_db_cluster).
///
/// See [`crate::client::fluent_builders::StartDBCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartDBCluster {
    _private: (),
}
impl StartDBCluster {
    /// Creates a new builder-style object to manufacture [`StartDbClusterInput`](crate::input::StartDbClusterInput)
    pub fn builder() -> crate::input::start_db_cluster_input::Builder {
        crate::input::start_db_cluster_input::Builder::default()
    }
    /// Creates a new `StartDBCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartDBCluster {
    type Output =
        std::result::Result<crate::output::StartDbClusterOutput, crate::error::StartDBClusterError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_db_cluster_error(response)
        } else {
            crate::operation_deser::parse_start_db_cluster_response(response)
        }
    }
}

/// Operation shape for `StopDBCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_db_cluster`](crate::client::Client::stop_db_cluster).
///
/// See [`crate::client::fluent_builders::StopDBCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopDBCluster {
    _private: (),
}
impl StopDBCluster {
    /// Creates a new builder-style object to manufacture [`StopDbClusterInput`](crate::input::StopDbClusterInput)
    pub fn builder() -> crate::input::stop_db_cluster_input::Builder {
        crate::input::stop_db_cluster_input::Builder::default()
    }
    /// Creates a new `StopDBCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopDBCluster {
    type Output =
        std::result::Result<crate::output::StopDbClusterOutput, crate::error::StopDBClusterError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_db_cluster_error(response)
        } else {
            crate::operation_deser::parse_stop_db_cluster_response(response)
        }
    }
}
