// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AmazonRDSv19`.
///
/// This client allows ergonomic access to a `AmazonRDSv19`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AddSourceIdentifierToSubscription` operation.
    ///
    /// See [`AddSourceIdentifierToSubscription`](crate::client::fluent_builders::AddSourceIdentifierToSubscription) for more information about the
    /// operation and its arguments.
    pub fn add_source_identifier_to_subscription(
        &self,
    ) -> fluent_builders::AddSourceIdentifierToSubscription<C, M, R> {
        fluent_builders::AddSourceIdentifierToSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AddTagsToResource` operation.
    ///
    /// See [`AddTagsToResource`](crate::client::fluent_builders::AddTagsToResource) for more information about the
    /// operation and its arguments.
    pub fn add_tags_to_resource(&self) -> fluent_builders::AddTagsToResource<C, M, R> {
        fluent_builders::AddTagsToResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ApplyPendingMaintenanceAction` operation.
    ///
    /// See [`ApplyPendingMaintenanceAction`](crate::client::fluent_builders::ApplyPendingMaintenanceAction) for more information about the
    /// operation and its arguments.
    pub fn apply_pending_maintenance_action(
        &self,
    ) -> fluent_builders::ApplyPendingMaintenanceAction<C, M, R> {
        fluent_builders::ApplyPendingMaintenanceAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CopyDBClusterParameterGroup` operation.
    ///
    /// See [`CopyDBClusterParameterGroup`](crate::client::fluent_builders::CopyDBClusterParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn copy_db_cluster_parameter_group(
        &self,
    ) -> fluent_builders::CopyDBClusterParameterGroup<C, M, R> {
        fluent_builders::CopyDBClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CopyDBClusterSnapshot` operation.
    ///
    /// See [`CopyDBClusterSnapshot`](crate::client::fluent_builders::CopyDBClusterSnapshot) for more information about the
    /// operation and its arguments.
    pub fn copy_db_cluster_snapshot(&self) -> fluent_builders::CopyDBClusterSnapshot<C, M, R> {
        fluent_builders::CopyDBClusterSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDBCluster` operation.
    ///
    /// See [`CreateDBCluster`](crate::client::fluent_builders::CreateDBCluster) for more information about the
    /// operation and its arguments.
    pub fn create_db_cluster(&self) -> fluent_builders::CreateDBCluster<C, M, R> {
        fluent_builders::CreateDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDBClusterParameterGroup` operation.
    ///
    /// See [`CreateDBClusterParameterGroup`](crate::client::fluent_builders::CreateDBClusterParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn create_db_cluster_parameter_group(
        &self,
    ) -> fluent_builders::CreateDBClusterParameterGroup<C, M, R> {
        fluent_builders::CreateDBClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDBClusterSnapshot` operation.
    ///
    /// See [`CreateDBClusterSnapshot`](crate::client::fluent_builders::CreateDBClusterSnapshot) for more information about the
    /// operation and its arguments.
    pub fn create_db_cluster_snapshot(&self) -> fluent_builders::CreateDBClusterSnapshot<C, M, R> {
        fluent_builders::CreateDBClusterSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDBInstance` operation.
    ///
    /// See [`CreateDBInstance`](crate::client::fluent_builders::CreateDBInstance) for more information about the
    /// operation and its arguments.
    pub fn create_db_instance(&self) -> fluent_builders::CreateDBInstance<C, M, R> {
        fluent_builders::CreateDBInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDBSubnetGroup` operation.
    ///
    /// See [`CreateDBSubnetGroup`](crate::client::fluent_builders::CreateDBSubnetGroup) for more information about the
    /// operation and its arguments.
    pub fn create_db_subnet_group(&self) -> fluent_builders::CreateDBSubnetGroup<C, M, R> {
        fluent_builders::CreateDBSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateEventSubscription` operation.
    ///
    /// See [`CreateEventSubscription`](crate::client::fluent_builders::CreateEventSubscription) for more information about the
    /// operation and its arguments.
    pub fn create_event_subscription(&self) -> fluent_builders::CreateEventSubscription<C, M, R> {
        fluent_builders::CreateEventSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateGlobalCluster` operation.
    ///
    /// See [`CreateGlobalCluster`](crate::client::fluent_builders::CreateGlobalCluster) for more information about the
    /// operation and its arguments.
    pub fn create_global_cluster(&self) -> fluent_builders::CreateGlobalCluster<C, M, R> {
        fluent_builders::CreateGlobalCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDBCluster` operation.
    ///
    /// See [`DeleteDBCluster`](crate::client::fluent_builders::DeleteDBCluster) for more information about the
    /// operation and its arguments.
    pub fn delete_db_cluster(&self) -> fluent_builders::DeleteDBCluster<C, M, R> {
        fluent_builders::DeleteDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDBClusterParameterGroup` operation.
    ///
    /// See [`DeleteDBClusterParameterGroup`](crate::client::fluent_builders::DeleteDBClusterParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_db_cluster_parameter_group(
        &self,
    ) -> fluent_builders::DeleteDBClusterParameterGroup<C, M, R> {
        fluent_builders::DeleteDBClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDBClusterSnapshot` operation.
    ///
    /// See [`DeleteDBClusterSnapshot`](crate::client::fluent_builders::DeleteDBClusterSnapshot) for more information about the
    /// operation and its arguments.
    pub fn delete_db_cluster_snapshot(&self) -> fluent_builders::DeleteDBClusterSnapshot<C, M, R> {
        fluent_builders::DeleteDBClusterSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDBInstance` operation.
    ///
    /// See [`DeleteDBInstance`](crate::client::fluent_builders::DeleteDBInstance) for more information about the
    /// operation and its arguments.
    pub fn delete_db_instance(&self) -> fluent_builders::DeleteDBInstance<C, M, R> {
        fluent_builders::DeleteDBInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDBSubnetGroup` operation.
    ///
    /// See [`DeleteDBSubnetGroup`](crate::client::fluent_builders::DeleteDBSubnetGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_db_subnet_group(&self) -> fluent_builders::DeleteDBSubnetGroup<C, M, R> {
        fluent_builders::DeleteDBSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEventSubscription` operation.
    ///
    /// See [`DeleteEventSubscription`](crate::client::fluent_builders::DeleteEventSubscription) for more information about the
    /// operation and its arguments.
    pub fn delete_event_subscription(&self) -> fluent_builders::DeleteEventSubscription<C, M, R> {
        fluent_builders::DeleteEventSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteGlobalCluster` operation.
    ///
    /// See [`DeleteGlobalCluster`](crate::client::fluent_builders::DeleteGlobalCluster) for more information about the
    /// operation and its arguments.
    pub fn delete_global_cluster(&self) -> fluent_builders::DeleteGlobalCluster<C, M, R> {
        fluent_builders::DeleteGlobalCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCertificates` operation.
    ///
    /// See [`DescribeCertificates`](crate::client::fluent_builders::DescribeCertificates) for more information about the
    /// operation and its arguments.
    pub fn describe_certificates(&self) -> fluent_builders::DescribeCertificates<C, M, R> {
        fluent_builders::DescribeCertificates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBClusterParameterGroups` operation.
    ///
    /// See [`DescribeDBClusterParameterGroups`](crate::client::fluent_builders::DescribeDBClusterParameterGroups) for more information about the
    /// operation and its arguments.
    pub fn describe_db_cluster_parameter_groups(
        &self,
    ) -> fluent_builders::DescribeDBClusterParameterGroups<C, M, R> {
        fluent_builders::DescribeDBClusterParameterGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBClusterParameters` operation.
    ///
    /// See [`DescribeDBClusterParameters`](crate::client::fluent_builders::DescribeDBClusterParameters) for more information about the
    /// operation and its arguments.
    pub fn describe_db_cluster_parameters(
        &self,
    ) -> fluent_builders::DescribeDBClusterParameters<C, M, R> {
        fluent_builders::DescribeDBClusterParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBClusters` operation.
    ///
    /// See [`DescribeDBClusters`](crate::client::fluent_builders::DescribeDBClusters) for more information about the
    /// operation and its arguments.
    pub fn describe_db_clusters(&self) -> fluent_builders::DescribeDBClusters<C, M, R> {
        fluent_builders::DescribeDBClusters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBClusterSnapshotAttributes` operation.
    ///
    /// See [`DescribeDBClusterSnapshotAttributes`](crate::client::fluent_builders::DescribeDBClusterSnapshotAttributes) for more information about the
    /// operation and its arguments.
    pub fn describe_db_cluster_snapshot_attributes(
        &self,
    ) -> fluent_builders::DescribeDBClusterSnapshotAttributes<C, M, R> {
        fluent_builders::DescribeDBClusterSnapshotAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBClusterSnapshots` operation.
    ///
    /// See [`DescribeDBClusterSnapshots`](crate::client::fluent_builders::DescribeDBClusterSnapshots) for more information about the
    /// operation and its arguments.
    pub fn describe_db_cluster_snapshots(
        &self,
    ) -> fluent_builders::DescribeDBClusterSnapshots<C, M, R> {
        fluent_builders::DescribeDBClusterSnapshots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBEngineVersions` operation.
    ///
    /// See [`DescribeDBEngineVersions`](crate::client::fluent_builders::DescribeDBEngineVersions) for more information about the
    /// operation and its arguments.
    pub fn describe_db_engine_versions(
        &self,
    ) -> fluent_builders::DescribeDBEngineVersions<C, M, R> {
        fluent_builders::DescribeDBEngineVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBInstances` operation.
    ///
    /// See [`DescribeDBInstances`](crate::client::fluent_builders::DescribeDBInstances) for more information about the
    /// operation and its arguments.
    pub fn describe_db_instances(&self) -> fluent_builders::DescribeDBInstances<C, M, R> {
        fluent_builders::DescribeDBInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBSubnetGroups` operation.
    ///
    /// See [`DescribeDBSubnetGroups`](crate::client::fluent_builders::DescribeDBSubnetGroups) for more information about the
    /// operation and its arguments.
    pub fn describe_db_subnet_groups(&self) -> fluent_builders::DescribeDBSubnetGroups<C, M, R> {
        fluent_builders::DescribeDBSubnetGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEngineDefaultClusterParameters` operation.
    ///
    /// See [`DescribeEngineDefaultClusterParameters`](crate::client::fluent_builders::DescribeEngineDefaultClusterParameters) for more information about the
    /// operation and its arguments.
    pub fn describe_engine_default_cluster_parameters(
        &self,
    ) -> fluent_builders::DescribeEngineDefaultClusterParameters<C, M, R> {
        fluent_builders::DescribeEngineDefaultClusterParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEventCategories` operation.
    ///
    /// See [`DescribeEventCategories`](crate::client::fluent_builders::DescribeEventCategories) for more information about the
    /// operation and its arguments.
    pub fn describe_event_categories(&self) -> fluent_builders::DescribeEventCategories<C, M, R> {
        fluent_builders::DescribeEventCategories::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEvents` operation.
    ///
    /// See [`DescribeEvents`](crate::client::fluent_builders::DescribeEvents) for more information about the
    /// operation and its arguments.
    pub fn describe_events(&self) -> fluent_builders::DescribeEvents<C, M, R> {
        fluent_builders::DescribeEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEventSubscriptions` operation.
    ///
    /// See [`DescribeEventSubscriptions`](crate::client::fluent_builders::DescribeEventSubscriptions) for more information about the
    /// operation and its arguments.
    pub fn describe_event_subscriptions(
        &self,
    ) -> fluent_builders::DescribeEventSubscriptions<C, M, R> {
        fluent_builders::DescribeEventSubscriptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeGlobalClusters` operation.
    ///
    /// See [`DescribeGlobalClusters`](crate::client::fluent_builders::DescribeGlobalClusters) for more information about the
    /// operation and its arguments.
    pub fn describe_global_clusters(&self) -> fluent_builders::DescribeGlobalClusters<C, M, R> {
        fluent_builders::DescribeGlobalClusters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeOrderableDBInstanceOptions` operation.
    ///
    /// See [`DescribeOrderableDBInstanceOptions`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions) for more information about the
    /// operation and its arguments.
    pub fn describe_orderable_db_instance_options(
        &self,
    ) -> fluent_builders::DescribeOrderableDBInstanceOptions<C, M, R> {
        fluent_builders::DescribeOrderableDBInstanceOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePendingMaintenanceActions` operation.
    ///
    /// See [`DescribePendingMaintenanceActions`](crate::client::fluent_builders::DescribePendingMaintenanceActions) for more information about the
    /// operation and its arguments.
    pub fn describe_pending_maintenance_actions(
        &self,
    ) -> fluent_builders::DescribePendingMaintenanceActions<C, M, R> {
        fluent_builders::DescribePendingMaintenanceActions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `FailoverDBCluster` operation.
    ///
    /// See [`FailoverDBCluster`](crate::client::fluent_builders::FailoverDBCluster) for more information about the
    /// operation and its arguments.
    pub fn failover_db_cluster(&self) -> fluent_builders::FailoverDBCluster<C, M, R> {
        fluent_builders::FailoverDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyDBCluster` operation.
    ///
    /// See [`ModifyDBCluster`](crate::client::fluent_builders::ModifyDBCluster) for more information about the
    /// operation and its arguments.
    pub fn modify_db_cluster(&self) -> fluent_builders::ModifyDBCluster<C, M, R> {
        fluent_builders::ModifyDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyDBClusterParameterGroup` operation.
    ///
    /// See [`ModifyDBClusterParameterGroup`](crate::client::fluent_builders::ModifyDBClusterParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn modify_db_cluster_parameter_group(
        &self,
    ) -> fluent_builders::ModifyDBClusterParameterGroup<C, M, R> {
        fluent_builders::ModifyDBClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyDBClusterSnapshotAttribute` operation.
    ///
    /// See [`ModifyDBClusterSnapshotAttribute`](crate::client::fluent_builders::ModifyDBClusterSnapshotAttribute) for more information about the
    /// operation and its arguments.
    pub fn modify_db_cluster_snapshot_attribute(
        &self,
    ) -> fluent_builders::ModifyDBClusterSnapshotAttribute<C, M, R> {
        fluent_builders::ModifyDBClusterSnapshotAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyDBInstance` operation.
    ///
    /// See [`ModifyDBInstance`](crate::client::fluent_builders::ModifyDBInstance) for more information about the
    /// operation and its arguments.
    pub fn modify_db_instance(&self) -> fluent_builders::ModifyDBInstance<C, M, R> {
        fluent_builders::ModifyDBInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyDBSubnetGroup` operation.
    ///
    /// See [`ModifyDBSubnetGroup`](crate::client::fluent_builders::ModifyDBSubnetGroup) for more information about the
    /// operation and its arguments.
    pub fn modify_db_subnet_group(&self) -> fluent_builders::ModifyDBSubnetGroup<C, M, R> {
        fluent_builders::ModifyDBSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyEventSubscription` operation.
    ///
    /// See [`ModifyEventSubscription`](crate::client::fluent_builders::ModifyEventSubscription) for more information about the
    /// operation and its arguments.
    pub fn modify_event_subscription(&self) -> fluent_builders::ModifyEventSubscription<C, M, R> {
        fluent_builders::ModifyEventSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyGlobalCluster` operation.
    ///
    /// See [`ModifyGlobalCluster`](crate::client::fluent_builders::ModifyGlobalCluster) for more information about the
    /// operation and its arguments.
    pub fn modify_global_cluster(&self) -> fluent_builders::ModifyGlobalCluster<C, M, R> {
        fluent_builders::ModifyGlobalCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RebootDBInstance` operation.
    ///
    /// See [`RebootDBInstance`](crate::client::fluent_builders::RebootDBInstance) for more information about the
    /// operation and its arguments.
    pub fn reboot_db_instance(&self) -> fluent_builders::RebootDBInstance<C, M, R> {
        fluent_builders::RebootDBInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveFromGlobalCluster` operation.
    ///
    /// See [`RemoveFromGlobalCluster`](crate::client::fluent_builders::RemoveFromGlobalCluster) for more information about the
    /// operation and its arguments.
    pub fn remove_from_global_cluster(&self) -> fluent_builders::RemoveFromGlobalCluster<C, M, R> {
        fluent_builders::RemoveFromGlobalCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveSourceIdentifierFromSubscription` operation.
    ///
    /// See [`RemoveSourceIdentifierFromSubscription`](crate::client::fluent_builders::RemoveSourceIdentifierFromSubscription) for more information about the
    /// operation and its arguments.
    pub fn remove_source_identifier_from_subscription(
        &self,
    ) -> fluent_builders::RemoveSourceIdentifierFromSubscription<C, M, R> {
        fluent_builders::RemoveSourceIdentifierFromSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveTagsFromResource` operation.
    ///
    /// See [`RemoveTagsFromResource`](crate::client::fluent_builders::RemoveTagsFromResource) for more information about the
    /// operation and its arguments.
    pub fn remove_tags_from_resource(&self) -> fluent_builders::RemoveTagsFromResource<C, M, R> {
        fluent_builders::RemoveTagsFromResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResetDBClusterParameterGroup` operation.
    ///
    /// See [`ResetDBClusterParameterGroup`](crate::client::fluent_builders::ResetDBClusterParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn reset_db_cluster_parameter_group(
        &self,
    ) -> fluent_builders::ResetDBClusterParameterGroup<C, M, R> {
        fluent_builders::ResetDBClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RestoreDBClusterFromSnapshot` operation.
    ///
    /// See [`RestoreDBClusterFromSnapshot`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot) for more information about the
    /// operation and its arguments.
    pub fn restore_db_cluster_from_snapshot(
        &self,
    ) -> fluent_builders::RestoreDBClusterFromSnapshot<C, M, R> {
        fluent_builders::RestoreDBClusterFromSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RestoreDBClusterToPointInTime` operation.
    ///
    /// See [`RestoreDBClusterToPointInTime`](crate::client::fluent_builders::RestoreDBClusterToPointInTime) for more information about the
    /// operation and its arguments.
    pub fn restore_db_cluster_to_point_in_time(
        &self,
    ) -> fluent_builders::RestoreDBClusterToPointInTime<C, M, R> {
        fluent_builders::RestoreDBClusterToPointInTime::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartDBCluster` operation.
    ///
    /// See [`StartDBCluster`](crate::client::fluent_builders::StartDBCluster) for more information about the
    /// operation and its arguments.
    pub fn start_db_cluster(&self) -> fluent_builders::StartDBCluster<C, M, R> {
        fluent_builders::StartDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopDBCluster` operation.
    ///
    /// See [`StopDBCluster`](crate::client::fluent_builders::StopDBCluster) for more information about the
    /// operation and its arguments.
    pub fn stop_db_cluster(&self) -> fluent_builders::StopDBCluster<C, M, R> {
        fluent_builders::StopDBCluster::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddSourceIdentifierToSubscription`.
    ///
    /// <p>Adds a source identifier to an existing event notification
    /// subscription.</p>
    #[derive(std::fmt::Debug)]
    pub struct AddSourceIdentifierToSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_source_identifier_to_subscription_input::Builder,
    }
    impl<C, M, R> AddSourceIdentifierToSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddSourceIdentifierToSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddSourceIdentifierToSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::AddSourceIdentifierToSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddSourceIdentifierToSubscriptionInputOperationOutputAlias,
                crate::output::AddSourceIdentifierToSubscriptionOutput,
                crate::error::AddSourceIdentifierToSubscriptionError,
                crate::input::AddSourceIdentifierToSubscriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon DocumentDB event notification subscription that you
        /// want to add a source identifier to.</p>
        pub fn subscription_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(inp);
            self
        }
        /// <p>The name of the Amazon DocumentDB event notification subscription that you
        /// want to add a source identifier to.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
        /// <p>The identifier of the event source to be added:</p>
        /// <ul>
        /// <li>
        /// <p>If the source type is an instance, a
        /// <code>DBInstanceIdentifier</code> must be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a security group, a
        /// <code>DBSecurityGroupName</code> must be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a parameter group, a
        /// <code>DBParameterGroupName</code> must be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a snapshot, a
        /// <code>DBSnapshotIdentifier</code> must be provided.</p>
        /// </li>
        /// </ul>
        pub fn source_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_identifier(inp);
            self
        }
        /// <p>The identifier of the event source to be added:</p>
        /// <ul>
        /// <li>
        /// <p>If the source type is an instance, a
        /// <code>DBInstanceIdentifier</code> must be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a security group, a
        /// <code>DBSecurityGroupName</code> must be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a parameter group, a
        /// <code>DBParameterGroupName</code> must be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a snapshot, a
        /// <code>DBSnapshotIdentifier</code> must be provided.</p>
        /// </li>
        /// </ul>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddTagsToResource`.
    ///
    /// <p>Adds metadata tags to an Amazon DocumentDB resource. You can use these tags
    /// with cost allocation reporting to track costs that are associated
    /// with Amazon DocumentDB resources or in a <code>Condition</code> statement in
    /// an Identity and Access Management (IAM) policy for Amazon DocumentDB.</p>
    #[derive(std::fmt::Debug)]
    pub struct AddTagsToResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_tags_to_resource_input::Builder,
    }
    impl<C, M, R> AddTagsToResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddTagsToResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddTagsToResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::AddTagsToResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddTagsToResourceInputOperationOutputAlias,
                crate::output::AddTagsToResourceOutput,
                crate::error::AddTagsToResourceError,
                crate::input::AddTagsToResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon DocumentDB resource that the tags are added to. This value is an
        /// Amazon Resource Name .</p>
        pub fn resource_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(inp);
            self
        }
        /// <p>The Amazon DocumentDB resource that the tags are added to. This value is an
        /// Amazon Resource Name .</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the Amazon DocumentDB resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be assigned to the Amazon DocumentDB resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ApplyPendingMaintenanceAction`.
    ///
    /// <p>Applies a pending maintenance action to a resource (for example,
    /// to an Amazon DocumentDB instance).</p>
    #[derive(std::fmt::Debug)]
    pub struct ApplyPendingMaintenanceAction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::apply_pending_maintenance_action_input::Builder,
    }
    impl<C, M, R> ApplyPendingMaintenanceAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ApplyPendingMaintenanceAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ApplyPendingMaintenanceActionOutput,
            aws_smithy_http::result::SdkError<crate::error::ApplyPendingMaintenanceActionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ApplyPendingMaintenanceActionInputOperationOutputAlias,
                crate::output::ApplyPendingMaintenanceActionOutput,
                crate::error::ApplyPendingMaintenanceActionError,
                crate::input::ApplyPendingMaintenanceActionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that the pending
        /// maintenance action applies to.</p>
        pub fn resource_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_identifier(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that the pending
        /// maintenance action applies to.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
        /// <p>The pending maintenance action to apply to this resource.</p>
        /// <p>Valid values: <code>system-update</code>, <code>db-upgrade</code>
        /// </p>
        pub fn apply_action(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.apply_action(inp);
            self
        }
        /// <p>The pending maintenance action to apply to this resource.</p>
        /// <p>Valid values: <code>system-update</code>, <code>db-upgrade</code>
        /// </p>
        pub fn set_apply_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_apply_action(input);
            self
        }
        /// <p>A value that specifies the type of opt-in request or undoes an
        /// opt-in request. An opt-in request of type <code>immediate</code>
        /// can't be undone.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>immediate</code> - Apply the maintenance action
        /// immediately.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>next-maintenance</code> - Apply the maintenance
        /// action during the next maintenance window for the resource.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>undo-opt-in</code> - Cancel any existing
        /// <code>next-maintenance</code> opt-in requests.</p>
        /// </li>
        /// </ul>
        pub fn opt_in_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.opt_in_type(inp);
            self
        }
        /// <p>A value that specifies the type of opt-in request or undoes an
        /// opt-in request. An opt-in request of type <code>immediate</code>
        /// can't be undone.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>immediate</code> - Apply the maintenance action
        /// immediately.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>next-maintenance</code> - Apply the maintenance
        /// action during the next maintenance window for the resource.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>undo-opt-in</code> - Cancel any existing
        /// <code>next-maintenance</code> opt-in requests.</p>
        /// </li>
        /// </ul>
        pub fn set_opt_in_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_opt_in_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopyDBClusterParameterGroup`.
    ///
    /// <p>Copies the specified cluster parameter group.</p>
    #[derive(std::fmt::Debug)]
    pub struct CopyDBClusterParameterGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::copy_db_cluster_parameter_group_input::Builder,
    }
    impl<C, M, R> CopyDBClusterParameterGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CopyDBClusterParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyDbClusterParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyDBClusterParameterGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CopyDbClusterParameterGroupInputOperationOutputAlias,
                crate::output::CopyDbClusterParameterGroupOutput,
                crate::error::CopyDBClusterParameterGroupError,
                crate::input::CopyDbClusterParameterGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier or Amazon Resource Name (ARN) for the source cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must specify a valid cluster parameter group.</p>
        /// </li>
        /// <li>
        /// <p>If the source cluster parameter group is in the same Region as the copy, specify a valid parameter group identifier; for example, <code>my-db-cluster-param-group</code>, or a valid ARN.</p>
        /// </li>
        /// <li>
        /// <p>If the source parameter group is in a different Region than the copy, specify a valid cluster parameter group ARN; for example, <code>arn:aws:rds:us-east-1:123456789012:sample-cluster:sample-parameter-group</code>.</p>
        /// </li>
        /// </ul>
        pub fn source_db_cluster_parameter_group_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.source_db_cluster_parameter_group_identifier(inp);
            self
        }
        /// <p>The identifier or Amazon Resource Name (ARN) for the source cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must specify a valid cluster parameter group.</p>
        /// </li>
        /// <li>
        /// <p>If the source cluster parameter group is in the same Region as the copy, specify a valid parameter group identifier; for example, <code>my-db-cluster-param-group</code>, or a valid ARN.</p>
        /// </li>
        /// <li>
        /// <p>If the source parameter group is in a different Region than the copy, specify a valid cluster parameter group ARN; for example, <code>arn:aws:rds:us-east-1:123456789012:sample-cluster:sample-parameter-group</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_source_db_cluster_parameter_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_source_db_cluster_parameter_group_identifier(input);
            self
        }
        /// <p>The identifier for the copied cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Cannot be null, empty, or blank.</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 letters, numbers, or hyphens.
        /// </p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-param-group1</code>
        /// </p>
        pub fn target_db_cluster_parameter_group_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.target_db_cluster_parameter_group_identifier(inp);
            self
        }
        /// <p>The identifier for the copied cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Cannot be null, empty, or blank.</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 letters, numbers, or hyphens.
        /// </p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-param-group1</code>
        /// </p>
        pub fn set_target_db_cluster_parameter_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_target_db_cluster_parameter_group_identifier(input);
            self
        }
        /// <p>A description for the copied cluster parameter group.</p>
        pub fn target_db_cluster_parameter_group_description(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .target_db_cluster_parameter_group_description(inp);
            self
        }
        /// <p>A description for the copied cluster parameter group.</p>
        pub fn set_target_db_cluster_parameter_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_target_db_cluster_parameter_group_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags that are to be assigned to the parameter group.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags that are to be assigned to the parameter group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopyDBClusterSnapshot`.
    ///
    /// <p>Copies a snapshot of a cluster.</p>
    ///
    /// <p>To copy a cluster snapshot from a shared manual cluster snapshot,
    /// <code>SourceDBClusterSnapshotIdentifier</code> must be the Amazon
    /// Resource Name (ARN) of the shared cluster snapshot. You can only
    /// copy a shared DB cluster snapshot, whether encrypted or not, in the
    /// same Region.</p>
    ///
    /// <p>To cancel the copy operation after it is in progress, delete the
    /// target cluster snapshot identified by
    /// <code>TargetDBClusterSnapshotIdentifier</code> while that cluster
    /// snapshot is in the <i>copying</i> status.</p>
    #[derive(std::fmt::Debug)]
    pub struct CopyDBClusterSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::copy_db_cluster_snapshot_input::Builder,
    }
    impl<C, M, R> CopyDBClusterSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CopyDBClusterSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyDbClusterSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyDBClusterSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CopyDbClusterSnapshotInputOperationOutputAlias,
                crate::output::CopyDbClusterSnapshotOutput,
                crate::error::CopyDBClusterSnapshotError,
                crate::input::CopyDbClusterSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the cluster snapshot to copy. This parameter is
        /// not case sensitive.</p>
        ///
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must specify a valid system snapshot in the
        /// <i>available</i> state.</p>
        /// </li>
        /// <li>
        /// <p>If the source snapshot is in the same Region as the copy, specify a valid snapshot identifier.</p>
        /// </li>
        /// <li>
        ///
        /// <p>If the source snapshot is in a different Region than the copy, specify a valid cluster snapshot ARN.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot1</code>
        /// </p>
        pub fn source_db_cluster_snapshot_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.source_db_cluster_snapshot_identifier(inp);
            self
        }
        /// <p>The identifier of the cluster snapshot to copy. This parameter is
        /// not case sensitive.</p>
        ///
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must specify a valid system snapshot in the
        /// <i>available</i> state.</p>
        /// </li>
        /// <li>
        /// <p>If the source snapshot is in the same Region as the copy, specify a valid snapshot identifier.</p>
        /// </li>
        /// <li>
        ///
        /// <p>If the source snapshot is in a different Region than the copy, specify a valid cluster snapshot ARN.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot1</code>
        /// </p>
        pub fn set_source_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_db_cluster_snapshot_identifier(input);
            self
        }
        /// <p>The identifier of the new cluster snapshot to create from the
        /// source cluster snapshot. This parameter is not case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.
        /// </p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot2</code>
        /// </p>
        pub fn target_db_cluster_snapshot_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.target_db_cluster_snapshot_identifier(inp);
            self
        }
        /// <p>The identifier of the new cluster snapshot to create from the
        /// source cluster snapshot. This parameter is not case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.
        /// </p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot2</code>
        /// </p>
        pub fn set_target_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_db_cluster_snapshot_identifier(input);
            self
        }
        /// <p>The KMS key ID for an encrypted cluster snapshot. The KMS
        /// key ID is the Amazon Resource Name (ARN), KMS key identifier, or
        /// the KMS key alias for the KMS encryption key. </p>
        ///
        /// <p>If you copy an encrypted cluster snapshot from your account, you can specify a value for <code>KmsKeyId</code> to encrypt the copy with a new KMS encryption key. If you don't specify a value for <code>KmsKeyId</code>, then the copy of the cluster snapshot is encrypted with the same KMS key as the source cluster snapshot.</p>
        ///
        /// <p>If you copy an encrypted cluster snapshot that is shared from another account, then you must specify a value for <code>KmsKeyId</code>.</p>
        ///
        /// <p>To copy an encrypted cluster snapshot to another Region, set <code>KmsKeyId</code> to the KMS key ID that you want to use to encrypt the copy of the cluster snapshot in the destination Region. KMS encryption keys are specific to the Region that they are created in, and you can't use encryption keys from one Region in another Region.</p>
        ///
        /// <p>If you copy an unencrypted cluster snapshot and specify a value for the <code>KmsKeyId</code> parameter, an error is returned.</p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The KMS key ID for an encrypted cluster snapshot. The KMS
        /// key ID is the Amazon Resource Name (ARN), KMS key identifier, or
        /// the KMS key alias for the KMS encryption key. </p>
        ///
        /// <p>If you copy an encrypted cluster snapshot from your account, you can specify a value for <code>KmsKeyId</code> to encrypt the copy with a new KMS encryption key. If you don't specify a value for <code>KmsKeyId</code>, then the copy of the cluster snapshot is encrypted with the same KMS key as the source cluster snapshot.</p>
        ///
        /// <p>If you copy an encrypted cluster snapshot that is shared from another account, then you must specify a value for <code>KmsKeyId</code>.</p>
        ///
        /// <p>To copy an encrypted cluster snapshot to another Region, set <code>KmsKeyId</code> to the KMS key ID that you want to use to encrypt the copy of the cluster snapshot in the destination Region. KMS encryption keys are specific to the Region that they are created in, and you can't use encryption keys from one Region in another Region.</p>
        ///
        /// <p>If you copy an unencrypted cluster snapshot and specify a value for the <code>KmsKeyId</code> parameter, an error is returned.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>The URL that contains a Signature Version 4 signed request for the<code>CopyDBClusterSnapshot</code> API action in the Region that contains the source cluster snapshot to copy. You must use the <code>PreSignedUrl</code> parameter when copying a cluster snapshot from another Region.</p>
        ///
        /// <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify
        /// <code>SourceRegion</code> (or <code>--source-region</code> for the
        /// CLI) instead of specifying <code>PreSignedUrl</code> manually.
        /// Specifying <code>SourceRegion</code> autogenerates a pre-signed URL
        /// that is a valid request for the operation that can be executed in
        /// the source Region.</p>
        ///
        /// <p>The presigned URL must be a valid request for the
        /// <code>CopyDBClusterSnapshot</code> API action that can be executed
        /// in the source Region that contains the cluster snapshot to be
        /// copied. The presigned URL request must contain the following
        /// parameter values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SourceRegion</code> - The ID of the region that
        /// contains the snapshot to be copied.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SourceDBClusterSnapshotIdentifier</code> - The
        /// identifier for the the encrypted cluster snapshot to be
        /// copied. This identifier must be in the Amazon Resource Name
        /// (ARN) format for the source Region. For example, if you
        /// are copying an encrypted cluster snapshot from the us-east-1
        /// Region, then your
        /// <code>SourceDBClusterSnapshotIdentifier</code> looks
        /// something like the following:
        /// <code>arn:aws:rds:us-east-1:12345678012:sample-cluster:sample-cluster-snapshot</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TargetDBClusterSnapshotIdentifier</code> - The
        /// identifier for the new cluster snapshot to be created. This
        /// parameter isn't case sensitive.</p>
        /// </li>
        /// </ul>
        pub fn pre_signed_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pre_signed_url(inp);
            self
        }
        /// <p>The URL that contains a Signature Version 4 signed request for the<code>CopyDBClusterSnapshot</code> API action in the Region that contains the source cluster snapshot to copy. You must use the <code>PreSignedUrl</code> parameter when copying a cluster snapshot from another Region.</p>
        ///
        /// <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify
        /// <code>SourceRegion</code> (or <code>--source-region</code> for the
        /// CLI) instead of specifying <code>PreSignedUrl</code> manually.
        /// Specifying <code>SourceRegion</code> autogenerates a pre-signed URL
        /// that is a valid request for the operation that can be executed in
        /// the source Region.</p>
        ///
        /// <p>The presigned URL must be a valid request for the
        /// <code>CopyDBClusterSnapshot</code> API action that can be executed
        /// in the source Region that contains the cluster snapshot to be
        /// copied. The presigned URL request must contain the following
        /// parameter values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SourceRegion</code> - The ID of the region that
        /// contains the snapshot to be copied.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SourceDBClusterSnapshotIdentifier</code> - The
        /// identifier for the the encrypted cluster snapshot to be
        /// copied. This identifier must be in the Amazon Resource Name
        /// (ARN) format for the source Region. For example, if you
        /// are copying an encrypted cluster snapshot from the us-east-1
        /// Region, then your
        /// <code>SourceDBClusterSnapshotIdentifier</code> looks
        /// something like the following:
        /// <code>arn:aws:rds:us-east-1:12345678012:sample-cluster:sample-cluster-snapshot</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TargetDBClusterSnapshotIdentifier</code> - The
        /// identifier for the new cluster snapshot to be created. This
        /// parameter isn't case sensitive.</p>
        /// </li>
        /// </ul>
        pub fn set_pre_signed_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pre_signed_url(input);
            self
        }
        /// <p>Set to <code>true</code> to copy all tags from the source cluster
        /// snapshot to the target cluster snapshot, and otherwise
        /// <code>false</code>. The default is <code>false</code>.</p>
        pub fn copy_tags(mut self, inp: bool) -> Self {
            self.inner = self.inner.copy_tags(inp);
            self
        }
        /// <p>Set to <code>true</code> to copy all tags from the source cluster
        /// snapshot to the target cluster snapshot, and otherwise
        /// <code>false</code>. The default is <code>false</code>.</p>
        pub fn set_copy_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_copy_tags(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the cluster snapshot.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be assigned to the cluster snapshot.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBCluster`.
    ///
    /// <p>Creates a new Amazon DocumentDB cluster.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDBCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_db_cluster_input::Builder,
    }
    impl<C, M, R> CreateDBCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDbClusterInputOperationOutputAlias,
                crate::output::CreateDbClusterOutput,
                crate::error::CreateDBClusterError,
                crate::input::CreateDbClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AvailabilityZones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>A list of Amazon EC2 Availability Zones that instances in the
        /// cluster can be created in.</p>
        pub fn availability_zones(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zones(inp);
            self
        }
        /// <p>A list of Amazon EC2 Availability Zones that instances in the
        /// cluster can be created in.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_availability_zones(input);
            self
        }
        /// <p>The number of days for which automated backups are retained. You
        /// must specify a minimum value of 1.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be a value from 1 to 35.</p>
        /// </li>
        /// </ul>
        pub fn backup_retention_period(mut self, inp: i32) -> Self {
            self.inner = self.inner.backup_retention_period(inp);
            self
        }
        /// <p>The number of days for which automated backups are retained. You
        /// must specify a minimum value of 1.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be a value from 1 to 35.</p>
        /// </li>
        /// </ul>
        pub fn set_backup_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_backup_retention_period(input);
            self
        }
        /// <p>The cluster identifier. This parameter is stored as a lowercase
        /// string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.
        /// </p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster</code>
        /// </p>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The cluster identifier. This parameter is stored as a lowercase
        /// string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.
        /// </p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster</code>
        /// </p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>The name of the cluster parameter group to associate with this
        /// cluster.</p>
        pub fn db_cluster_parameter_group_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(inp);
            self
        }
        /// <p>The name of the cluster parameter group to associate with this
        /// cluster.</p>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of EC2 VPC security groups to associate with this cluster.
        /// </p>
        pub fn vpc_security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(inp);
            self
        }
        /// <p>A list of EC2 VPC security groups to associate with this cluster.
        /// </p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
        /// <p>A subnet group to associate with this cluster.</p>
        /// <p>Constraints: Must match the name of an existing
        /// <code>DBSubnetGroup</code>. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn db_subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(inp);
            self
        }
        /// <p>A subnet group to associate with this cluster.</p>
        /// <p>Constraints: Must match the name of an existing
        /// <code>DBSubnetGroup</code>. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
        /// <p>The name of the database engine to be used for this cluster.</p>
        /// <p>Valid values: <code>docdb</code>
        /// </p>
        pub fn engine(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(inp);
            self
        }
        /// <p>The name of the database engine to be used for this cluster.</p>
        /// <p>Valid values: <code>docdb</code>
        /// </p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>The version number of the database engine to use. The <code>--engine-version</code> will default to the latest major engine version. For production workloads, we recommend explicitly declaring this parameter with the intended major engine version.</p>
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        /// <p>The version number of the database engine to use. The <code>--engine-version</code> will default to the latest major engine version. For production workloads, we recommend explicitly declaring this parameter with the intended major engine version.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>The port number on which the instances in the cluster accept
        /// connections.</p>
        pub fn port(mut self, inp: i32) -> Self {
            self.inner = self.inner.port(inp);
            self
        }
        /// <p>The port number on which the instances in the cluster accept
        /// connections.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>The name of the master user for the cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be from 1 to 63 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot be a reserved word for the chosen database engine.
        /// </p>
        /// </li>
        /// </ul>
        pub fn master_username(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_username(inp);
            self
        }
        /// <p>The name of the master user for the cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be from 1 to 63 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot be a reserved word for the chosen database engine.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_master_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_username(input);
            self
        }
        /// <p>The password for the master database user. This password can
        /// contain any printable ASCII character except forward slash (/),
        /// double quote ("), or the "at" symbol (@).</p>
        /// <p>Constraints: Must contain from 8 to 100 characters.</p>
        pub fn master_user_password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_user_password(inp);
            self
        }
        /// <p>The password for the master database user. This password can
        /// contain any printable ASCII character except forward slash (/),
        /// double quote ("), or the "at" symbol (@).</p>
        /// <p>Constraints: Must contain from 8 to 100 characters.</p>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_user_password(input);
            self
        }
        /// <p>The daily time range during which automated backups are created if
        /// automated backups are enabled using the <code>BackupRetentionPeriod</code> parameter. </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Region. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p>
        /// </li>
        /// <li>
        /// <p>Must be in Universal Coordinated Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Must not conflict with the preferred maintenance window.
        /// </p>
        /// </li>
        /// <li>
        /// <p>Must be at least 30 minutes.</p>
        /// </li>
        /// </ul>
        pub fn preferred_backup_window(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_backup_window(inp);
            self
        }
        /// <p>The daily time range during which automated backups are created if
        /// automated backups are enabled using the <code>BackupRetentionPeriod</code> parameter. </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Region. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p>
        /// </li>
        /// <li>
        /// <p>Must be in Universal Coordinated Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Must not conflict with the preferred maintenance window.
        /// </p>
        /// </li>
        /// <li>
        /// <p>Must be at least 30 minutes.</p>
        /// </li>
        /// </ul>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_backup_window(input);
            self
        }
        /// <p>The weekly time range during which system maintenance can occur,
        /// in Universal Coordinated Time (UTC).</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Region, occurring on a random day of the week.</p>
        /// <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn preferred_maintenance_window(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_maintenance_window(inp);
            self
        }
        /// <p>The weekly time range during which system maintenance can occur,
        /// in Universal Coordinated Time (UTC).</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Region, occurring on a random day of the week.</p>
        /// <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the cluster.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be assigned to the cluster.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Specifies whether the cluster is encrypted.</p>
        pub fn storage_encrypted(mut self, inp: bool) -> Self {
            self.inner = self.inner.storage_encrypted(inp);
            self
        }
        /// <p>Specifies whether the cluster is encrypted.</p>
        pub fn set_storage_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_storage_encrypted(input);
            self
        }
        /// <p>The KMS key identifier for an encrypted cluster.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a cluster using the same account that owns the KMS encryption key that is used to encrypt the new cluster, you can use the KMS key alias instead of the ARN for the KMS encryption key.</p>
        /// <p>If an encryption key is not specified in <code>KmsKeyId</code>:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>If the <code>StorageEncrypted</code> parameter is
        /// <code>true</code>, Amazon DocumentDB uses your default encryption key.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>KMS creates the default encryption key for your account. Your account has a different default encryption key for each Regions.</p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The KMS key identifier for an encrypted cluster.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a cluster using the same account that owns the KMS encryption key that is used to encrypt the new cluster, you can use the KMS key alias instead of the ARN for the KMS encryption key.</p>
        /// <p>If an encryption key is not specified in <code>KmsKeyId</code>:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>If the <code>StorageEncrypted</code> parameter is
        /// <code>true</code>, Amazon DocumentDB uses your default encryption key.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>KMS creates the default encryption key for your account. Your account has a different default encryption key for each Regions.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>Not currently supported.
        /// </p>
        pub fn pre_signed_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pre_signed_url(inp);
            self
        }
        /// <p>Not currently supported.
        /// </p>
        pub fn set_pre_signed_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pre_signed_url(input);
            self
        }
        /// Appends an item to `EnableCloudwatchLogsExports`.
        ///
        /// To override the contents of this collection use [`set_enable_cloudwatch_logs_exports`](Self::set_enable_cloudwatch_logs_exports).
        ///
        /// <p>A list of log types that need to be enabled for exporting to Amazon
        /// CloudWatch Logs. You can enable audit logs or profiler logs. For more
        /// information, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/event-auditing.html">
        /// Auditing Amazon DocumentDB Events</a>
        /// and <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/profiling.html">
        /// Profiling Amazon DocumentDB Operations</a>.
        /// </p>
        pub fn enable_cloudwatch_logs_exports(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.enable_cloudwatch_logs_exports(inp);
            self
        }
        /// <p>A list of log types that need to be enabled for exporting to Amazon
        /// CloudWatch Logs. You can enable audit logs or profiler logs. For more
        /// information, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/event-auditing.html">
        /// Auditing Amazon DocumentDB Events</a>
        /// and <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/profiling.html">
        /// Profiling Amazon DocumentDB Operations</a>.
        /// </p>
        pub fn set_enable_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_enable_cloudwatch_logs_exports(input);
            self
        }
        /// <p>Specifies whether this cluster can be deleted. If
        /// <code>DeletionProtection</code> is enabled, the cluster cannot be
        /// deleted unless it is modified and <code>DeletionProtection</code> is
        /// disabled. <code>DeletionProtection</code> protects clusters from
        /// being accidentally deleted.</p>
        pub fn deletion_protection(mut self, inp: bool) -> Self {
            self.inner = self.inner.deletion_protection(inp);
            self
        }
        /// <p>Specifies whether this cluster can be deleted. If
        /// <code>DeletionProtection</code> is enabled, the cluster cannot be
        /// deleted unless it is modified and <code>DeletionProtection</code> is
        /// disabled. <code>DeletionProtection</code> protects clusters from
        /// being accidentally deleted.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deletion_protection(input);
            self
        }
        /// <p>The cluster identifier of the new global cluster.</p>
        pub fn global_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_cluster_identifier(inp);
            self
        }
        /// <p>The cluster identifier of the new global cluster.</p>
        pub fn set_global_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_cluster_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBClusterParameterGroup`.
    ///
    /// <p>Creates a new cluster parameter group.</p>
    /// <p>Parameters in a cluster parameter group apply to all of the
    /// instances in a cluster.</p>
    /// <p>A cluster parameter group is initially created with the default
    /// parameters for the database engine used by instances in the cluster.
    /// In Amazon DocumentDB, you cannot make modifications directly to the
    /// <code>default.docdb3.6</code> cluster parameter group. If your
    /// Amazon DocumentDB cluster is using the default cluster parameter group and you
    /// want to modify a value in it, you must first <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/cluster_parameter_group-create.html">
    /// create a new parameter group</a>
    /// or <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/cluster_parameter_group-copy.html">
    /// copy an existing parameter group</a>,
    /// modify it, and then apply the modified parameter group to your
    /// cluster. For the new cluster parameter group and associated settings
    /// to take effect, you must then reboot the instances in the cluster
    /// without failover. For more information,
    /// see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/cluster_parameter_group-modify.html">
    /// Modifying Amazon DocumentDB Cluster Parameter Groups</a>.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDBClusterParameterGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_db_cluster_parameter_group_input::Builder,
    }
    impl<C, M, R> CreateDBClusterParameterGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDBClusterParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbClusterParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBClusterParameterGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDbClusterParameterGroupInputOperationOutputAlias,
                crate::output::CreateDbClusterParameterGroupOutput,
                crate::error::CreateDBClusterParameterGroupError,
                crate::input::CreateDbClusterParameterGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must not match the name of an existing
        /// <code>DBClusterParameterGroup</code>.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn db_cluster_parameter_group_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(inp);
            self
        }
        /// <p>The name of the cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must not match the name of an existing
        /// <code>DBClusterParameterGroup</code>.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
        /// <p>The cluster parameter group family name.</p>
        pub fn db_parameter_group_family(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_family(inp);
            self
        }
        /// <p>The cluster parameter group family name.</p>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_family(input);
            self
        }
        /// <p>The description for the cluster parameter group.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description for the cluster parameter group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the cluster parameter group.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be assigned to the cluster parameter group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBClusterSnapshot`.
    ///
    /// <p>Creates a snapshot of a cluster. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDBClusterSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_db_cluster_snapshot_input::Builder,
    }
    impl<C, M, R> CreateDBClusterSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDBClusterSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbClusterSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBClusterSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDbClusterSnapshotInputOperationOutputAlias,
                crate::output::CreateDbClusterSnapshotOutput,
                crate::error::CreateDBClusterSnapshotError,
                crate::input::CreateDbClusterSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the cluster snapshot. This parameter is stored
        /// as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot1</code>
        /// </p>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_snapshot_identifier(inp);
            self
        }
        /// <p>The identifier of the cluster snapshot. This parameter is stored
        /// as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot1</code>
        /// </p>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_snapshot_identifier(input);
            self
        }
        /// <p>The identifier of the cluster to create a snapshot for. This
        /// parameter is not case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing
        /// <code>DBCluster</code>.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster</code>
        /// </p>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The identifier of the cluster to create a snapshot for. This
        /// parameter is not case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing
        /// <code>DBCluster</code>.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster</code>
        /// </p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the cluster snapshot.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be assigned to the cluster snapshot.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBInstance`.
    ///
    /// <p>Creates a new instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDBInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_db_instance_input::Builder,
    }
    impl<C, M, R> CreateDBInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDBInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDbInstanceInputOperationOutputAlias,
                crate::output::CreateDbInstanceOutput,
                crate::error::CreateDBInstanceError,
                crate::input::CreateDbInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The instance identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>mydbinstance</code>
        /// </p>
        pub fn db_instance_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_identifier(inp);
            self
        }
        /// <p>The instance identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>mydbinstance</code>
        /// </p>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_identifier(input);
            self
        }
        /// <p>The compute and memory capacity of the instance; for example,
        /// <code>db.r5.large</code>. </p>
        pub fn db_instance_class(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_class(inp);
            self
        }
        /// <p>The compute and memory capacity of the instance; for example,
        /// <code>db.r5.large</code>. </p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_class(input);
            self
        }
        /// <p>The name of the database engine to be used for this instance.</p>
        /// <p>Valid value: <code>docdb</code>
        /// </p>
        pub fn engine(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(inp);
            self
        }
        /// <p>The name of the database engine to be used for this instance.</p>
        /// <p>Valid value: <code>docdb</code>
        /// </p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>The Amazon EC2 Availability Zone that the instance is created in. </p>
        /// <p>Default: A random, system-chosen Availability Zone in the endpoint's Region.</p>
        /// <p>Example: <code>us-east-1d</code>
        /// </p>
        pub fn availability_zone(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone(inp);
            self
        }
        /// <p>The Amazon EC2 Availability Zone that the instance is created in. </p>
        /// <p>Default: A random, system-chosen Availability Zone in the endpoint's Region.</p>
        /// <p>Example: <code>us-east-1d</code>
        /// </p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone(input);
            self
        }
        /// <p>The time range each week during which system maintenance can occur, in Universal
        /// Coordinated Time (UTC).</p>
        /// <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for
        /// each Region, occurring on a random day of the week. </p>
        /// <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn preferred_maintenance_window(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_maintenance_window(inp);
            self
        }
        /// <p>The time range each week during which system maintenance can occur, in Universal
        /// Coordinated Time (UTC).</p>
        /// <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for
        /// each Region, occurring on a random day of the week. </p>
        /// <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// <p>This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn auto_minor_version_upgrade(mut self, inp: bool) -> Self {
            self.inner = self.inner.auto_minor_version_upgrade(inp);
            self
        }
        /// <p>This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_minor_version_upgrade(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the instance. You can assign up to
        /// 10 tags to an instance.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be assigned to the instance. You can assign up to
        /// 10 tags to an instance.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The identifier of the cluster that the instance will belong to.</p>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The identifier of the cluster that the instance will belong to.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>A value that specifies the order in which an Amazon DocumentDB replica is promoted to the
        /// primary instance after a failure of the existing primary instance.</p>
        /// <p>Default: 1</p>
        /// <p>Valid values: 0-15</p>
        pub fn promotion_tier(mut self, inp: i32) -> Self {
            self.inner = self.inner.promotion_tier(inp);
            self
        }
        /// <p>A value that specifies the order in which an Amazon DocumentDB replica is promoted to the
        /// primary instance after a failure of the existing primary instance.</p>
        /// <p>Default: 1</p>
        /// <p>Valid values: 0-15</p>
        pub fn set_promotion_tier(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_promotion_tier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBSubnetGroup`.
    ///
    /// <p>Creates a new subnet group. subnet groups must contain at least one subnet in at
    /// least two Availability Zones in the Region.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDBSubnetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_db_subnet_group_input::Builder,
    }
    impl<C, M, R> CreateDBSubnetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDBSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBSubnetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDbSubnetGroupInputOperationOutputAlias,
                crate::output::CreateDbSubnetGroupOutput,
                crate::error::CreateDBSubnetGroupError,
                crate::input::CreateDbSubnetGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the subnet group. This value is stored as a lowercase string.</p>
        /// <p>Constraints: Must contain no more than 255 letters, numbers, periods, underscores,
        /// spaces, or hyphens. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn db_subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(inp);
            self
        }
        /// <p>The name for the subnet group. This value is stored as a lowercase string.</p>
        /// <p>Constraints: Must contain no more than 255 letters, numbers, periods, underscores,
        /// spaces, or hyphens. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
        /// <p>The description for the subnet group.</p>
        pub fn db_subnet_group_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_description(inp);
            self
        }
        /// <p>The description for the subnet group.</p>
        pub fn set_db_subnet_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_description(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The Amazon EC2 subnet IDs for the subnet group.</p>
        pub fn subnet_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(inp);
            self
        }
        /// <p>The Amazon EC2 subnet IDs for the subnet group.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the subnet group.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be assigned to the subnet group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEventSubscription`.
    ///
    /// <p>Creates an Amazon DocumentDB event notification subscription. This action requires a topic Amazon Resource Name (ARN) created by using the Amazon DocumentDB console, the Amazon SNS console, or the Amazon SNS API. To obtain an ARN with Amazon SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the Amazon SNS console.</p>
    /// <p>You can specify the type of source (<code>SourceType</code>) that you want to be notified of. You can also provide a list of Amazon DocumentDB sources (<code>SourceIds</code>) that trigger the events, and you can provide a list of event categories (<code>EventCategories</code>) for events that you want to be notified of. For example, you can specify <code>SourceType = db-instance</code>, <code>SourceIds = mydbinstance1, mydbinstance2</code> and <code>EventCategories = Availability, Backup</code>.</p>
    /// <p>If you specify both the <code>SourceType</code> and <code>SourceIds</code> (such as <code>SourceType = db-instance</code> and <code>SourceIdentifier = myDBInstance1</code>), you are notified of all the <code>db-instance</code> events for the specified source. If you specify a <code>SourceType</code> but do not specify a <code>SourceIdentifier</code>, you receive notice of the events for that source type for all your Amazon DocumentDB sources. If you do not specify either the <code>SourceType</code> or the <code>SourceIdentifier</code>, you are notified of events generated from all Amazon DocumentDB sources belonging to your customer account.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateEventSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_event_subscription_input::Builder,
    }
    impl<C, M, R> CreateEventSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEventSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEventSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEventSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEventSubscriptionInputOperationOutputAlias,
                crate::output::CreateEventSubscriptionOutput,
                crate::error::CreateEventSubscriptionError,
                crate::input::CreateEventSubscriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the subscription.</p>
        /// <p>Constraints: The name must be fewer than 255 characters.</p>
        pub fn subscription_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(inp);
            self
        }
        /// <p>The name of the subscription.</p>
        /// <p>Constraints: The name must be fewer than 255 characters.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. Amazon SNS creates the ARN when you create a topic and subscribe to it.</p>
        pub fn sns_topic_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. Amazon SNS creates the ARN when you create a topic and subscribe to it.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_arn(input);
            self
        }
        /// <p>The type of source that is generating the events. For example, if you want to be notified of events generated by an instance, you would set this parameter to <code>db-instance</code>. If this value is not specified, all events are returned.</p>
        /// <p>Valid values: <code>db-instance</code>, <code>db-cluster</code>,
        /// <code>db-parameter-group</code>, <code>db-security-group</code>,
        /// <code>db-cluster-snapshot</code>
        /// </p>
        pub fn source_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_type(inp);
            self
        }
        /// <p>The type of source that is generating the events. For example, if you want to be notified of events generated by an instance, you would set this parameter to <code>db-instance</code>. If this value is not specified, all events are returned.</p>
        /// <p>Valid values: <code>db-instance</code>, <code>db-cluster</code>,
        /// <code>db-parameter-group</code>, <code>db-security-group</code>,
        /// <code>db-cluster-snapshot</code>
        /// </p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// Appends an item to `EventCategories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p> A list of event categories for a <code>SourceType</code> that you want to subscribe to. </p>
        pub fn event_categories(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_categories(inp);
            self
        }
        /// <p> A list of event categories for a <code>SourceType</code> that you want to subscribe to. </p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_event_categories(input);
            self
        }
        /// Appends an item to `SourceIds`.
        ///
        /// To override the contents of this collection use [`set_source_ids`](Self::set_source_ids).
        ///
        /// <p>The list of identifiers of the event sources for which events are returned. If not specified, then all sources are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a
        /// hyphen or contain two consecutive hyphens.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>SourceIds</code> are provided, <code>SourceType</code> must also be
        /// provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is an instance, a <code>DBInstanceIdentifier</code> must
        /// be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a security group, a <code>DBSecurityGroupName</code>
        /// must be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a parameter group, a
        /// <code>DBParameterGroupName</code> must be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a snapshot, a <code>DBSnapshotIdentifier</code> must
        /// be provided.</p>
        /// </li>
        /// </ul>
        pub fn source_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_ids(inp);
            self
        }
        /// <p>The list of identifiers of the event sources for which events are returned. If not specified, then all sources are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a
        /// hyphen or contain two consecutive hyphens.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>SourceIds</code> are provided, <code>SourceType</code> must also be
        /// provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is an instance, a <code>DBInstanceIdentifier</code> must
        /// be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a security group, a <code>DBSecurityGroupName</code>
        /// must be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a parameter group, a
        /// <code>DBParameterGroupName</code> must be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a snapshot, a <code>DBSnapshotIdentifier</code> must
        /// be provided.</p>
        /// </li>
        /// </ul>
        pub fn set_source_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_source_ids(input);
            self
        }
        /// <p> A Boolean value; set to <code>true</code> to activate the subscription, set to <code>false</code> to create the subscription but not active it. </p>
        pub fn enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.enabled(inp);
            self
        }
        /// <p> A Boolean value; set to <code>true</code> to activate the subscription, set to <code>false</code> to create the subscription but not active it. </p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the event subscription.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be assigned to the event subscription.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGlobalCluster`.
    ///
    /// <p>Creates an Amazon DocumentDB global cluster that can span multiple multiple Regions. The global cluster contains one primary cluster with read-write capability, and up-to give read-only secondary clusters. Global clusters uses storage-based fast replication across regions with latencies less than one second, using dedicated infrastructure with no impact to your workload’s performance.</p>
    /// <p></p>
    /// <p>You can create a global cluster that is initially empty, and then add a primary and a secondary to it. Or you can specify an existing cluster during the create operation, and this cluster becomes the primary of the global cluster. </p>
    /// <note>
    /// <p>This action only applies to Amazon DocumentDB clusters.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateGlobalCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_global_cluster_input::Builder,
    }
    impl<C, M, R> CreateGlobalCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateGlobalCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGlobalClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGlobalClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateGlobalClusterInputOperationOutputAlias,
                crate::output::CreateGlobalClusterOutput,
                crate::error::CreateGlobalClusterError,
                crate::input::CreateGlobalClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The cluster identifier of the new global cluster.</p>
        pub fn global_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_cluster_identifier(inp);
            self
        }
        /// <p>The cluster identifier of the new global cluster.</p>
        pub fn set_global_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_cluster_identifier(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) to use as the primary cluster of the global cluster. This parameter is optional.</p>
        pub fn source_db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_db_cluster_identifier(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) to use as the primary cluster of the global cluster. This parameter is optional.</p>
        pub fn set_source_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_db_cluster_identifier(input);
            self
        }
        /// <p>The name of the database engine to be used for this cluster.</p>
        pub fn engine(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(inp);
            self
        }
        /// <p>The name of the database engine to be used for this cluster.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>The engine version of the global cluster.</p>
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        /// <p>The engine version of the global cluster.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>The deletion protection setting for the new global cluster. The global cluster can't be deleted when deletion protection is enabled. </p>
        pub fn deletion_protection(mut self, inp: bool) -> Self {
            self.inner = self.inner.deletion_protection(inp);
            self
        }
        /// <p>The deletion protection setting for the new global cluster. The global cluster can't be deleted when deletion protection is enabled. </p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deletion_protection(input);
            self
        }
        /// <p>The name for your database of up to 64 alpha-numeric characters. If you do not provide a name, Amazon DocumentDB will not create a database in the global cluster you are creating.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name for your database of up to 64 alpha-numeric characters. If you do not provide a name, Amazon DocumentDB will not create a database in the global cluster you are creating.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The storage encryption setting for the new global cluster. </p>
        pub fn storage_encrypted(mut self, inp: bool) -> Self {
            self.inner = self.inner.storage_encrypted(inp);
            self
        }
        /// <p>The storage encryption setting for the new global cluster. </p>
        pub fn set_storage_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_storage_encrypted(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDBCluster`.
    ///
    /// <p>Deletes a previously provisioned cluster. When you delete a cluster, all automated backups for that cluster are deleted and can't be recovered. Manual DB cluster snapshots of the specified cluster are not deleted.</p>
    /// <p></p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDBCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_db_cluster_input::Builder,
    }
    impl<C, M, R> DeleteDBCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDbClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDbClusterInputOperationOutputAlias,
                crate::output::DeleteDbClusterOutput,
                crate::error::DeleteDBClusterError,
                crate::input::DeleteDbClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The cluster identifier for the cluster to be deleted. This parameter isn't case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match an existing <code>DBClusterIdentifier</code>.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The cluster identifier for the cluster to be deleted. This parameter isn't case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match an existing <code>DBClusterIdentifier</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p> Determines whether a final cluster snapshot is created before the cluster is deleted. If <code>true</code> is specified, no cluster snapshot is created. If <code>false</code> is specified, a cluster snapshot is created before the DB cluster is deleted. </p>
        /// <note>
        /// <p>If <code>SkipFinalSnapshot</code> is <code>false</code>, you must specify a <code>FinalDBSnapshotIdentifier</code> parameter.</p>
        /// </note>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn skip_final_snapshot(mut self, inp: bool) -> Self {
            self.inner = self.inner.skip_final_snapshot(inp);
            self
        }
        /// <p> Determines whether a final cluster snapshot is created before the cluster is deleted. If <code>true</code> is specified, no cluster snapshot is created. If <code>false</code> is specified, a cluster snapshot is created before the DB cluster is deleted. </p>
        /// <note>
        /// <p>If <code>SkipFinalSnapshot</code> is <code>false</code>, you must specify a <code>FinalDBSnapshotIdentifier</code> parameter.</p>
        /// </note>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_skip_final_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_skip_final_snapshot(input);
            self
        }
        /// <p> The cluster snapshot identifier of the new cluster snapshot created when <code>SkipFinalSnapshot</code> is set to <code>false</code>. </p>
        /// <note>
        /// <p> Specifying this parameter and also setting the <code>SkipFinalShapshot</code> parameter to <code>true</code> results in an error. </p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be from 1 to 255 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn final_db_snapshot_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.final_db_snapshot_identifier(inp);
            self
        }
        /// <p> The cluster snapshot identifier of the new cluster snapshot created when <code>SkipFinalSnapshot</code> is set to <code>false</code>. </p>
        /// <note>
        /// <p> Specifying this parameter and also setting the <code>SkipFinalShapshot</code> parameter to <code>true</code> results in an error. </p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be from 1 to 255 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn set_final_db_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_final_db_snapshot_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDBClusterParameterGroup`.
    ///
    /// <p>Deletes a specified cluster parameter group. The cluster parameter group to be deleted can't be associated with any clusters.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDBClusterParameterGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_db_cluster_parameter_group_input::Builder,
    }
    impl<C, M, R> DeleteDBClusterParameterGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDBClusterParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDbClusterParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterParameterGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDbClusterParameterGroupInputOperationOutputAlias,
                crate::output::DeleteDbClusterParameterGroupOutput,
                crate::error::DeleteDBClusterParameterGroupError,
                crate::input::DeleteDbClusterParameterGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be the name of an existing cluster parameter group.</p>
        /// </li>
        /// <li>
        /// <p>You can't delete a default cluster parameter group.</p>
        /// </li>
        /// <li>
        /// <p>Cannot be associated with any clusters.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_parameter_group_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(inp);
            self
        }
        /// <p>The name of the cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be the name of an existing cluster parameter group.</p>
        /// </li>
        /// <li>
        /// <p>You can't delete a default cluster parameter group.</p>
        /// </li>
        /// <li>
        /// <p>Cannot be associated with any clusters.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDBClusterSnapshot`.
    ///
    /// <p>Deletes a cluster snapshot. If the snapshot is being copied, the copy operation is terminated.</p>
    /// <note>
    /// <p>The cluster snapshot must be in the <code>available</code> state to be deleted.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDBClusterSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_db_cluster_snapshot_input::Builder,
    }
    impl<C, M, R> DeleteDBClusterSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDBClusterSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDbClusterSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDbClusterSnapshotInputOperationOutputAlias,
                crate::output::DeleteDbClusterSnapshotOutput,
                crate::error::DeleteDBClusterSnapshotError,
                crate::input::DeleteDbClusterSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the cluster snapshot to delete.</p>
        /// <p>Constraints: Must be the name of an existing cluster snapshot in the <code>available</code> state.</p>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_snapshot_identifier(inp);
            self
        }
        /// <p>The identifier of the cluster snapshot to delete.</p>
        /// <p>Constraints: Must be the name of an existing cluster snapshot in the <code>available</code> state.</p>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_snapshot_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDBInstance`.
    ///
    /// <p>Deletes a previously provisioned instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDBInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_db_instance_input::Builder,
    }
    impl<C, M, R> DeleteDBInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDBInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDbInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDBInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDbInstanceInputOperationOutputAlias,
                crate::output::DeleteDbInstanceOutput,
                crate::error::DeleteDBInstanceError,
                crate::input::DeleteDbInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The instance identifier for the instance to be deleted. This parameter isn't
        /// case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the name of an existing instance.</p>
        /// </li>
        /// </ul>
        pub fn db_instance_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_identifier(inp);
            self
        }
        /// <p>The instance identifier for the instance to be deleted. This parameter isn't
        /// case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the name of an existing instance.</p>
        /// </li>
        /// </ul>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDBSubnetGroup`.
    ///
    /// <p>Deletes a subnet group.</p>
    /// <note>
    /// <p>The specified database subnet group must not be associated with any DB
    /// instances.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDBSubnetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_db_subnet_group_input::Builder,
    }
    impl<C, M, R> DeleteDBSubnetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDBSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDbSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDBSubnetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDbSubnetGroupInputOperationOutputAlias,
                crate::output::DeleteDbSubnetGroupOutput,
                crate::error::DeleteDBSubnetGroupError,
                crate::input::DeleteDbSubnetGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the database subnet group to delete.</p>
        /// <note>
        /// <p>You can't delete the default subnet group.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <p>Must match the name of an existing <code>DBSubnetGroup</code>. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn db_subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(inp);
            self
        }
        /// <p>The name of the database subnet group to delete.</p>
        /// <note>
        /// <p>You can't delete the default subnet group.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <p>Must match the name of an existing <code>DBSubnetGroup</code>. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEventSubscription`.
    ///
    /// <p>Deletes an Amazon DocumentDB event notification subscription.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteEventSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_event_subscription_input::Builder,
    }
    impl<C, M, R> DeleteEventSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEventSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEventSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEventSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEventSubscriptionInputOperationOutputAlias,
                crate::output::DeleteEventSubscriptionOutput,
                crate::error::DeleteEventSubscriptionError,
                crate::input::DeleteEventSubscriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon DocumentDB event notification subscription that you want to delete.</p>
        pub fn subscription_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(inp);
            self
        }
        /// <p>The name of the Amazon DocumentDB event notification subscription that you want to delete.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGlobalCluster`.
    ///
    /// <p>Deletes a global cluster. The primary and secondary clusters must already be detached or deleted before attempting to delete a global cluster.</p>
    /// <note>
    /// <p>This action only applies to Amazon DocumentDB clusters.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteGlobalCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_global_cluster_input::Builder,
    }
    impl<C, M, R> DeleteGlobalCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteGlobalCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGlobalClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGlobalClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteGlobalClusterInputOperationOutputAlias,
                crate::output::DeleteGlobalClusterOutput,
                crate::error::DeleteGlobalClusterError,
                crate::input::DeleteGlobalClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The cluster identifier of the global cluster being deleted.</p>
        pub fn global_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_cluster_identifier(inp);
            self
        }
        /// <p>The cluster identifier of the global cluster being deleted.</p>
        pub fn set_global_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_cluster_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCertificates`.
    ///
    /// <p>Returns a list of certificate authority (CA) certificates provided by Amazon DocumentDB for this account.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeCertificates<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_certificates_input::Builder,
    }
    impl<C, M, R> DescribeCertificates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCertificates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCertificatesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCertificatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCertificatesInputOperationOutputAlias,
                crate::output::DescribeCertificatesOutput,
                crate::error::DescribeCertificatesError,
                crate::input::DescribeCertificatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The user-supplied certificate identifier. If this parameter is specified, information for only the specified certificate is returned. If this parameter is omitted, a list of up to <code>MaxRecords</code> certificates is returned. This parameter is not case sensitive.</p>
        /// <p>Constraints</p>
        /// <ul>
        /// <li>
        /// <p>Must match an existing <code>CertificateIdentifier</code>.</p>
        /// </li>
        /// </ul>
        pub fn certificate_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_identifier(inp);
            self
        }
        /// <p>The user-supplied certificate identifier. If this parameter is specified, information for only the specified certificate is returned. If this parameter is omitted, a list of up to <code>MaxRecords</code> certificates is returned. This parameter is not case sensitive.</p>
        /// <p>Constraints</p>
        /// <ul>
        /// <li>
        /// <p>Must match an existing <code>CertificateIdentifier</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_identifier(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Minimum: 20</p>
        /// </li>
        /// <li>
        /// <p>Maximum: 100</p>
        /// </li>
        /// </ul>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Minimum: 20</p>
        /// </li>
        /// <li>
        /// <p>Maximum: 100</p>
        /// </li>
        /// </ul>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeCertificates</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeCertificates</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBClusterParameterGroups`.
    ///
    /// <p>Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a <code>DBClusterParameterGroupName</code> parameter is specified, the list contains only the description of the specified cluster parameter group. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBClusterParameterGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_cluster_parameter_groups_input::Builder,
    }
    impl<C, M, R> DescribeDBClusterParameterGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBClusterParameterGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbClusterParameterGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterParameterGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbClusterParameterGroupsInputOperationOutputAlias,
                crate::output::DescribeDbClusterParameterGroupsOutput,
                crate::error::DescribeDBClusterParameterGroupsError,
                crate::input::DescribeDbClusterParameterGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a specific cluster parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If provided, must match the name of an existing
        /// <code>DBClusterParameterGroup</code>.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_parameter_group_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(inp);
            self
        }
        /// <p>The name of a specific cluster parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If provided, must match the name of an existing
        /// <code>DBClusterParameterGroup</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBClusterParameters`.
    ///
    /// <p>Returns the detailed parameter list for a particular cluster parameter
    /// group.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBClusterParameters<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_cluster_parameters_input::Builder,
    }
    impl<C, M, R> DescribeDBClusterParameters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBClusterParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbClusterParametersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterParametersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbClusterParametersInputOperationOutputAlias,
                crate::output::DescribeDbClusterParametersOutput,
                crate::error::DescribeDBClusterParametersError,
                crate::input::DescribeDbClusterParametersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a specific cluster parameter group to return parameter details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If provided, must match the name of an existing <code>DBClusterParameterGroup</code>.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_parameter_group_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(inp);
            self
        }
        /// <p>The name of a specific cluster parameter group to return parameter details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If provided, must match the name of an existing <code>DBClusterParameterGroup</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
        /// <p> A value that indicates to return only parameters for a specific source. Parameter sources can be <code>engine</code>, <code>service</code>, or <code>customer</code>.
        /// </p>
        pub fn source(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source(inp);
            self
        }
        /// <p> A value that indicates to return only parameters for a specific source. Parameter sources can be <code>engine</code>, <code>service</code>, or <code>customer</code>.
        /// </p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBClusters`.
    ///
    /// <p>Returns information about provisioned Amazon DocumentDB clusters. This API
    /// operation supports pagination. For certain management features
    /// such as cluster and instance lifecycle management, Amazon DocumentDB leverages
    /// operational technology that is shared with Amazon RDS and Amazon
    /// Neptune. Use the <code>filterName=engine,Values=docdb</code> filter
    /// parameter to return only Amazon DocumentDB clusters.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBClusters<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_clusters_input::Builder,
    }
    impl<C, M, R> DescribeDBClusters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBClusters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbClustersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBClustersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbClustersInputOperationOutputAlias,
                crate::output::DescribeDbClustersOutput,
                crate::error::DescribeDBClustersError,
                crate::input::DescribeDbClustersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The user-provided cluster identifier. If this parameter is specified, information from only the specific cluster is returned. This parameter isn't case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If provided, must match an existing <code>DBClusterIdentifier</code>.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The user-provided cluster identifier. If this parameter is specified, information from only the specific cluster is returned. This parameter isn't case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If provided, must match an existing <code>DBClusterIdentifier</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies one or more clusters to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-cluster-id</code> - Accepts cluster identifiers and cluster Amazon Resource Names (ARNs). The results list only includes information about the clusters identified by these ARNs.</p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>A filter that specifies one or more clusters to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-cluster-id</code> - Accepts cluster identifiers and cluster Amazon Resource Names (ARNs). The results list only includes information about the clusters identified by these ARNs.</p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBClusterSnapshotAttributes`.
    ///
    /// <p>Returns a list of cluster snapshot attribute names and values for a manual DB
    /// cluster snapshot.</p>
    /// <p>When you share snapshots with other accounts,
    /// <code>DescribeDBClusterSnapshotAttributes</code> returns the <code>restore</code> attribute and a list of IDs for the accounts that are authorized to copy or restore the manual cluster snapshot. If <code>all</code> is included in the list of values for the <code>restore</code> attribute, then the manual cluster snapshot is public and can be copied or restored by all accounts.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBClusterSnapshotAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_cluster_snapshot_attributes_input::Builder,
    }
    impl<C, M, R> DescribeDBClusterSnapshotAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBClusterSnapshotAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbClusterSnapshotAttributesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeDBClusterSnapshotAttributesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbClusterSnapshotAttributesInputOperationOutputAlias,
                crate::output::DescribeDbClusterSnapshotAttributesOutput,
                crate::error::DescribeDBClusterSnapshotAttributesError,
                crate::input::DescribeDbClusterSnapshotAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the cluster snapshot to describe the attributes for.</p>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_snapshot_identifier(inp);
            self
        }
        /// <p>The identifier for the cluster snapshot to describe the attributes for.</p>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_snapshot_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBClusterSnapshots`.
    ///
    /// <p>Returns information about cluster snapshots. This API operation supports pagination.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBClusterSnapshots<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_cluster_snapshots_input::Builder,
    }
    impl<C, M, R> DescribeDBClusterSnapshots<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBClusterSnapshots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbClusterSnapshotsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterSnapshotsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbClusterSnapshotsInputOperationOutputAlias,
                crate::output::DescribeDbClusterSnapshotsOutput,
                crate::error::DescribeDBClusterSnapshotsError,
                crate::input::DescribeDbClusterSnapshotsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the cluster to retrieve the list of cluster snapshots for. This parameter can't be used with the <code>DBClusterSnapshotIdentifier</code> parameter. This parameter is not case sensitive. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If provided, must match the identifier of an existing
        /// <code>DBCluster</code>.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The ID of the cluster to retrieve the list of cluster snapshots for. This parameter can't be used with the <code>DBClusterSnapshotIdentifier</code> parameter. This parameter is not case sensitive. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If provided, must match the identifier of an existing
        /// <code>DBCluster</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>A specific cluster snapshot identifier to describe. This parameter can't be used with the <code>DBClusterIdentifier</code> parameter. This value is stored as a lowercase string. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If provided, must match the identifier of an existing
        /// <code>DBClusterSnapshot</code>.</p>
        /// </li>
        /// <li>
        /// <p>If this identifier is for an automated snapshot, the <code>SnapshotType</code>
        /// parameter must also be specified.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_snapshot_identifier(inp);
            self
        }
        /// <p>A specific cluster snapshot identifier to describe. This parameter can't be used with the <code>DBClusterIdentifier</code> parameter. This value is stored as a lowercase string. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If provided, must match the identifier of an existing
        /// <code>DBClusterSnapshot</code>.</p>
        /// </li>
        /// <li>
        /// <p>If this identifier is for an automated snapshot, the <code>SnapshotType</code>
        /// parameter must also be specified.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_snapshot_identifier(input);
            self
        }
        /// <p>The type of cluster snapshots to be returned. You can specify one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>automated</code> - Return all cluster snapshots that Amazon DocumentDB has automatically created for your account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>manual</code> - Return all cluster snapshots that you have manually created for your account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>shared</code> - Return all manual cluster snapshots that have been shared to your account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>public</code> - Return all cluster snapshots that have been marked as public.</p>
        /// </li>
        /// </ul>
        /// <p>If you don't specify a <code>SnapshotType</code> value, then both automated and manual cluster snapshots are returned. You can include shared cluster snapshots with these results by setting the <code>IncludeShared</code> parameter to <code>true</code>. You can include public cluster snapshots with these results by setting the<code>IncludePublic</code> parameter to <code>true</code>.</p>
        /// <p>The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don't apply for <code>SnapshotType</code> values of <code>manual</code> or <code>automated</code>. The <code>IncludePublic</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>shared</code>. The <code>IncludeShared</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>public</code>.</p>
        pub fn snapshot_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_type(inp);
            self
        }
        /// <p>The type of cluster snapshots to be returned. You can specify one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>automated</code> - Return all cluster snapshots that Amazon DocumentDB has automatically created for your account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>manual</code> - Return all cluster snapshots that you have manually created for your account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>shared</code> - Return all manual cluster snapshots that have been shared to your account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>public</code> - Return all cluster snapshots that have been marked as public.</p>
        /// </li>
        /// </ul>
        /// <p>If you don't specify a <code>SnapshotType</code> value, then both automated and manual cluster snapshots are returned. You can include shared cluster snapshots with these results by setting the <code>IncludeShared</code> parameter to <code>true</code>. You can include public cluster snapshots with these results by setting the<code>IncludePublic</code> parameter to <code>true</code>.</p>
        /// <p>The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don't apply for <code>SnapshotType</code> values of <code>manual</code> or <code>automated</code>. The <code>IncludePublic</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>shared</code>. The <code>IncludeShared</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>public</code>.</p>
        pub fn set_snapshot_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_type(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Set to <code>true</code> to include shared manual cluster snapshots from other accounts that this account has been given permission to copy or restore, and otherwise <code>false</code>. The default is <code>false</code>.</p>
        pub fn include_shared(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_shared(inp);
            self
        }
        /// <p>Set to <code>true</code> to include shared manual cluster snapshots from other accounts that this account has been given permission to copy or restore, and otherwise <code>false</code>. The default is <code>false</code>.</p>
        pub fn set_include_shared(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_shared(input);
            self
        }
        /// <p>Set to <code>true</code> to include manual cluster snapshots that are public and can be copied or restored by any account, and otherwise <code>false</code>. The default is <code>false</code>.</p>
        pub fn include_public(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_public(inp);
            self
        }
        /// <p>Set to <code>true</code> to include manual cluster snapshots that are public and can be copied or restored by any account, and otherwise <code>false</code>. The default is <code>false</code>.</p>
        pub fn set_include_public(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_public(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBEngineVersions`.
    ///
    /// <p>Returns a list of the available engines.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBEngineVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_engine_versions_input::Builder,
    }
    impl<C, M, R> DescribeDBEngineVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBEngineVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbEngineVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBEngineVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbEngineVersionsInputOperationOutputAlias,
                crate::output::DescribeDbEngineVersionsOutput,
                crate::error::DescribeDBEngineVersionsError,
                crate::input::DescribeDbEngineVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The database engine to return.</p>
        pub fn engine(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(inp);
            self
        }
        /// <p>The database engine to return.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>The database engine version to return.</p>
        /// <p>Example: <code>3.6.0</code>
        /// </p>
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        /// <p>The database engine version to return.</p>
        /// <p>Example: <code>3.6.0</code>
        /// </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>The name of a specific parameter group family to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If provided, must match an existing
        /// <code>DBParameterGroupFamily</code>.</p>
        /// </li>
        /// </ul>
        pub fn db_parameter_group_family(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_family(inp);
            self
        }
        /// <p>The name of a specific parameter group family to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If provided, must match an existing
        /// <code>DBParameterGroupFamily</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_family(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Indicates that only the default version of the specified engine or engine and major
        /// version combination is returned.</p>
        pub fn default_only(mut self, inp: bool) -> Self {
            self.inner = self.inner.default_only(inp);
            self
        }
        /// <p>Indicates that only the default version of the specified engine or engine and major
        /// version combination is returned.</p>
        pub fn set_default_only(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_default_only(input);
            self
        }
        /// <p>If this parameter is specified and the requested engine supports the <code>CharacterSetName</code> parameter for <code>CreateDBInstance</code>, the response includes a list of supported character sets for each engine version. </p>
        pub fn list_supported_character_sets(mut self, inp: bool) -> Self {
            self.inner = self.inner.list_supported_character_sets(inp);
            self
        }
        /// <p>If this parameter is specified and the requested engine supports the <code>CharacterSetName</code> parameter for <code>CreateDBInstance</code>, the response includes a list of supported character sets for each engine version. </p>
        pub fn set_list_supported_character_sets(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_list_supported_character_sets(input);
            self
        }
        /// <p>If this parameter is specified and the requested engine supports the <code>TimeZone</code> parameter for <code>CreateDBInstance</code>, the response includes a list of supported time zones for each engine version. </p>
        pub fn list_supported_timezones(mut self, inp: bool) -> Self {
            self.inner = self.inner.list_supported_timezones(inp);
            self
        }
        /// <p>If this parameter is specified and the requested engine supports the <code>TimeZone</code> parameter for <code>CreateDBInstance</code>, the response includes a list of supported time zones for each engine version. </p>
        pub fn set_list_supported_timezones(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_list_supported_timezones(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBInstances`.
    ///
    /// <p>Returns information about provisioned Amazon DocumentDB instances. This API supports pagination.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_instances_input::Builder,
    }
    impl<C, M, R> DescribeDBInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBInstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbInstancesInputOperationOutputAlias,
                crate::output::DescribeDbInstancesOutput,
                crate::error::DescribeDBInstancesError,
                crate::input::DescribeDbInstancesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The user-provided instance identifier. If this parameter is specified, information from only the specific instance is returned. This parameter isn't case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If provided, must match the identifier of an existing
        /// <code>DBInstance</code>.</p>
        /// </li>
        /// </ul>
        pub fn db_instance_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_identifier(inp);
            self
        }
        /// <p>The user-provided instance identifier. If this parameter is specified, information from only the specific instance is returned. This parameter isn't case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If provided, must match the identifier of an existing
        /// <code>DBInstance</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_identifier(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies one or more instances to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-cluster-id</code> - Accepts cluster identifiers and cluster Amazon Resource Names (ARNs). The results list includes only the information about the instances that are associated with the clusters that are identified by these ARNs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db-instance-id</code> - Accepts instance identifiers and instance ARNs. The results list includes only the information about the instances that are identified by these ARNs.</p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>A filter that specifies one or more instances to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-cluster-id</code> - Accepts cluster identifiers and cluster Amazon Resource Names (ARNs). The results list includes only the information about the instances that are associated with the clusters that are identified by these ARNs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db-instance-id</code> - Accepts instance identifiers and instance ARNs. The results list includes only the information about the instances that are identified by these ARNs.</p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBSubnetGroups`.
    ///
    /// <p>Returns a list of <code>DBSubnetGroup</code> descriptions. If a
    /// <code>DBSubnetGroupName</code> is specified, the list will contain only the descriptions of the specified <code>DBSubnetGroup</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBSubnetGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_subnet_groups_input::Builder,
    }
    impl<C, M, R> DescribeDBSubnetGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBSubnetGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbSubnetGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBSubnetGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbSubnetGroupsInputOperationOutputAlias,
                crate::output::DescribeDbSubnetGroupsOutput,
                crate::error::DescribeDBSubnetGroupsError,
                crate::input::DescribeDbSubnetGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the subnet group to return details for.</p>
        pub fn db_subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(inp);
            self
        }
        /// <p>The name of the subnet group to return details for.</p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEngineDefaultClusterParameters`.
    ///
    /// <p>Returns the default engine and system parameter information for the cluster database
    /// engine.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEngineDefaultClusterParameters<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_engine_default_cluster_parameters_input::Builder,
    }
    impl<C, M, R> DescribeEngineDefaultClusterParameters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEngineDefaultClusterParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEngineDefaultClusterParametersOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeEngineDefaultClusterParametersError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEngineDefaultClusterParametersInputOperationOutputAlias,
                crate::output::DescribeEngineDefaultClusterParametersOutput,
                crate::error::DescribeEngineDefaultClusterParametersError,
                crate::input::DescribeEngineDefaultClusterParametersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster parameter group family to return the engine parameter
        /// information for.</p>
        pub fn db_parameter_group_family(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_family(inp);
            self
        }
        /// <p>The name of the cluster parameter group family to return the engine parameter
        /// information for.</p>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_family(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventCategories`.
    ///
    /// <p>Displays a list of categories for all event source types, or, if specified, for a
    /// specified source type. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEventCategories<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_event_categories_input::Builder,
    }
    impl<C, M, R> DescribeEventCategories<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEventCategories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventCategoriesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventCategoriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEventCategoriesInputOperationOutputAlias,
                crate::output::DescribeEventCategoriesOutput,
                crate::error::DescribeEventCategoriesError,
                crate::input::DescribeEventCategoriesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of source that is generating the events.</p>
        /// <p>Valid values: <code>db-instance</code>, <code>db-parameter-group</code>, <code>db-security-group</code>
        /// </p>
        pub fn source_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_type(inp);
            self
        }
        /// <p>The type of source that is generating the events.</p>
        /// <p>Valid values: <code>db-instance</code>, <code>db-parameter-group</code>, <code>db-security-group</code>
        /// </p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEvents`.
    ///
    /// <p>Returns events related to instances, security groups, snapshots, and DB parameter groups for the past 14 days. You can obtain events specific to a particular DB instance, security group, snapshot, or parameter group by providing the name as a parameter. By default, the events of the past hour are returned.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEvents<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_events_input::Builder,
    }
    impl<C, M, R> DescribeEvents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEventsInputOperationOutputAlias,
                crate::output::DescribeEventsOutput,
                crate::error::DescribeEventsError,
                crate::input::DescribeEventsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the event source for which events are returned. If not specified, then all sources are included in the response.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>SourceIdentifier</code> is provided, <code>SourceType</code> must also be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is <code>DBInstance</code>, a
        /// <code>DBInstanceIdentifier</code> must be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is <code>DBSecurityGroup</code>, a
        /// <code>DBSecurityGroupName</code> must be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is <code>DBParameterGroup</code>, a
        /// <code>DBParameterGroupName</code> must be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is <code>DBSnapshot</code>, a
        /// <code>DBSnapshotIdentifier</code> must be provided.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn source_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_identifier(inp);
            self
        }
        /// <p>The identifier of the event source for which events are returned. If not specified, then all sources are included in the response.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>SourceIdentifier</code> is provided, <code>SourceType</code> must also be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is <code>DBInstance</code>, a
        /// <code>DBInstanceIdentifier</code> must be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is <code>DBSecurityGroup</code>, a
        /// <code>DBSecurityGroupName</code> must be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is <code>DBParameterGroup</code>, a
        /// <code>DBParameterGroupName</code> must be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is <code>DBSnapshot</code>, a
        /// <code>DBSnapshotIdentifier</code> must be provided.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_identifier(input);
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
        pub fn source_type(mut self, inp: crate::model::SourceType) -> Self {
            self.inner = self.inner.source_type(inp);
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// <p> The beginning of the time interval to retrieve events for, specified in ISO 8601 format. </p>
        /// <p>Example: 2009-07-08T18:00Z</p>
        pub fn start_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p> The beginning of the time interval to retrieve events for, specified in ISO 8601 format. </p>
        /// <p>Example: 2009-07-08T18:00Z</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p> The end of the time interval for which to retrieve events, specified in ISO 8601
        /// format. </p>
        /// <p>Example: 2009-07-08T18:00Z</p>
        pub fn end_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p> The end of the time interval for which to retrieve events, specified in ISO 8601
        /// format. </p>
        /// <p>Example: 2009-07-08T18:00Z</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The number of minutes to retrieve events for.</p>
        /// <p>Default: 60</p>
        pub fn duration(mut self, inp: i32) -> Self {
            self.inner = self.inner.duration(inp);
            self
        }
        /// <p>The number of minutes to retrieve events for.</p>
        /// <p>Default: 60</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_duration(input);
            self
        }
        /// Appends an item to `EventCategories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p>A list of event categories that trigger notifications for an event notification
        /// subscription.</p>
        pub fn event_categories(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_categories(inp);
            self
        }
        /// <p>A list of event categories that trigger notifications for an event notification
        /// subscription.</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_event_categories(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventSubscriptions`.
    ///
    /// <p>Lists all the subscription descriptions for a customer account. The description for a subscription includes <code>SubscriptionName</code>, <code>SNSTopicARN</code>, <code>CustomerID</code>, <code>SourceType</code>, <code>SourceID</code>, <code>CreationTime</code>, and <code>Status</code>.</p>
    /// <p>If you specify a <code>SubscriptionName</code>, lists the description for that subscription.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEventSubscriptions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_event_subscriptions_input::Builder,
    }
    impl<C, M, R> DescribeEventSubscriptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEventSubscriptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventSubscriptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventSubscriptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEventSubscriptionsInputOperationOutputAlias,
                crate::output::DescribeEventSubscriptionsOutput,
                crate::error::DescribeEventSubscriptionsError,
                crate::input::DescribeEventSubscriptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon DocumentDB event notification subscription that you want to
        /// describe.</p>
        pub fn subscription_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(inp);
            self
        }
        /// <p>The name of the Amazon DocumentDB event notification subscription that you want to
        /// describe.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeGlobalClusters`.
    ///
    /// <p>Returns information about Amazon DocumentDB global  clusters. This API supports pagination.</p>
    /// <note>
    /// <p>This action only applies to Amazon DocumentDB clusters.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeGlobalClusters<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_global_clusters_input::Builder,
    }
    impl<C, M, R> DescribeGlobalClusters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeGlobalClusters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeGlobalClustersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeGlobalClustersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeGlobalClustersInputOperationOutputAlias,
                crate::output::DescribeGlobalClustersOutput,
                crate::error::DescribeGlobalClustersError,
                crate::input::DescribeGlobalClustersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The user-supplied  cluster identifier. If this parameter is specified, information from only the specific cluster is returned. This parameter isn't case-sensitive.</p>
        pub fn global_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_cluster_identifier(inp);
            self
        }
        /// <p>The user-supplied  cluster identifier. If this parameter is specified, information from only the specific cluster is returned. This parameter isn't case-sensitive.</p>
        pub fn set_global_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_cluster_identifier(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies one or more global DB clusters to describe.</p>
        /// <p>Supported filters: <code>db-cluster-id</code> accepts  cluster identifiers and  cluster Amazon Resource Names (ARNs). The results list will only include information about the clusters identified by these ARNs.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>A filter that specifies one or more global DB clusters to describe.</p>
        /// <p>Supported filters: <code>db-cluster-id</code> accepts  cluster identifiers and  cluster Amazon Resource Names (ARNs). The results list will only include information about the clusters identified by these ARNs.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results. </p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results. </p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeGlobalClusters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeGlobalClusters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOrderableDBInstanceOptions`.
    ///
    /// <p>Returns a list of orderable instance options for the specified engine.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeOrderableDBInstanceOptions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_orderable_db_instance_options_input::Builder,
    }
    impl<C, M, R> DescribeOrderableDBInstanceOptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeOrderableDBInstanceOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOrderableDbInstanceOptionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeOrderableDBInstanceOptionsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeOrderableDbInstanceOptionsInputOperationOutputAlias,
                crate::output::DescribeOrderableDbInstanceOptionsOutput,
                crate::error::DescribeOrderableDBInstanceOptionsError,
                crate::input::DescribeOrderableDbInstanceOptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the engine to retrieve instance options for.</p>
        pub fn engine(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(inp);
            self
        }
        /// <p>The name of the engine to retrieve instance options for.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>The engine version filter value. Specify this parameter to show only the available
        /// offerings that match the specified engine version.</p>
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        /// <p>The engine version filter value. Specify this parameter to show only the available
        /// offerings that match the specified engine version.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>The instance class filter value. Specify this parameter to show only the available
        /// offerings that match the specified instance class.</p>
        pub fn db_instance_class(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_class(inp);
            self
        }
        /// <p>The instance class filter value. Specify this parameter to show only the available
        /// offerings that match the specified instance class.</p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_class(input);
            self
        }
        /// <p>The license model filter value. Specify this parameter to show only the available
        /// offerings that match the specified license model.</p>
        pub fn license_model(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_model(inp);
            self
        }
        /// <p>The license model filter value. Specify this parameter to show only the available
        /// offerings that match the specified license model.</p>
        pub fn set_license_model(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_model(input);
            self
        }
        /// <p>The virtual private cloud (VPC) filter value. Specify this parameter to show only the
        /// available VPC or non-VPC offerings.</p>
        pub fn vpc(mut self, inp: bool) -> Self {
            self.inner = self.inner.vpc(inp);
            self
        }
        /// <p>The virtual private cloud (VPC) filter value. Specify this parameter to show only the
        /// available VPC or non-VPC offerings.</p>
        pub fn set_vpc(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_vpc(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePendingMaintenanceActions`.
    ///
    /// <p>Returns a list of resources (for example, instances) that have at least one pending
    /// maintenance action.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribePendingMaintenanceActions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_pending_maintenance_actions_input::Builder,
    }
    impl<C, M, R> DescribePendingMaintenanceActions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePendingMaintenanceActions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePendingMaintenanceActionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePendingMaintenanceActionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePendingMaintenanceActionsInputOperationOutputAlias,
                crate::output::DescribePendingMaintenanceActionsOutput,
                crate::error::DescribePendingMaintenanceActionsError,
                crate::input::DescribePendingMaintenanceActionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of a resource to return pending maintenance actions for.</p>
        pub fn resource_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_identifier(inp);
            self
        }
        /// <p>The ARN of a resource to return pending maintenance actions for.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies one or more resources to return pending maintenance actions
        /// for.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-cluster-id</code> - Accepts cluster identifiers and cluster
        /// Amazon Resource Names (ARNs). The results list includes only pending maintenance
        /// actions for the clusters identified by these ARNs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db-instance-id</code> - Accepts instance identifiers and instance
        /// ARNs. The results list includes only pending maintenance actions for the DB
        /// instances identified by these ARNs.</p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>A filter that specifies one or more resources to return pending maintenance actions
        /// for.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-cluster-id</code> - Accepts cluster identifiers and cluster
        /// Amazon Resource Names (ARNs). The results list includes only pending maintenance
        /// actions for the clusters identified by these ARNs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db-instance-id</code> - Accepts instance identifiers and instance
        /// ARNs. The results list includes only pending maintenance actions for the DB
        /// instances identified by these ARNs.</p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token (marker) is included
        /// in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
    }
    /// Fluent builder constructing a request to `FailoverDBCluster`.
    ///
    /// <p>Forces a failover for a cluster.</p>
    /// <p>A failover for a cluster promotes one of the Amazon DocumentDB replicas (read-only instances) in the cluster to be the primary instance (the cluster writer).</p>
    /// <p>If the primary instance fails, Amazon DocumentDB automatically fails over to an Amazon DocumentDB replica, if one exists. You can force a failover when you want to simulate a failure of a primary instance for testing.</p>
    #[derive(std::fmt::Debug)]
    pub struct FailoverDBCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::failover_db_cluster_input::Builder,
    }
    impl<C, M, R> FailoverDBCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `FailoverDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::FailoverDbClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::FailoverDBClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::FailoverDbClusterInputOperationOutputAlias,
                crate::output::FailoverDbClusterOutput,
                crate::error::FailoverDBClusterError,
                crate::input::FailoverDbClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A cluster identifier to force a failover for. This parameter is not case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing <code>DBCluster</code>.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>A cluster identifier to force a failover for. This parameter is not case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing <code>DBCluster</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>The name of the instance to promote to the primary instance.</p>
        /// <p>You must specify the instance identifier for an Amazon DocumentDB replica in the cluster. For
        /// example, <code>mydbcluster-replica1</code>.</p>
        pub fn target_db_instance_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.target_db_instance_identifier(inp);
            self
        }
        /// <p>The name of the instance to promote to the primary instance.</p>
        /// <p>You must specify the instance identifier for an Amazon DocumentDB replica in the cluster. For
        /// example, <code>mydbcluster-replica1</code>.</p>
        pub fn set_target_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_db_instance_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists all tags on an Amazon DocumentDB resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon DocumentDB resource with tags to be listed. This value is an Amazon Resource Name
        /// (ARN).</p>
        pub fn resource_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(inp);
            self
        }
        /// <p>The Amazon DocumentDB resource with tags to be listed. This value is an Amazon Resource Name
        /// (ARN).</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyDBCluster`.
    ///
    /// <p>Modifies a setting for an Amazon DocumentDB cluster. You can change one or more database
    /// configuration parameters by specifying these parameters and the new values in the
    /// request. </p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyDBCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_db_cluster_input::Builder,
    }
    impl<C, M, R> ModifyDBCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyDbClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyDBClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyDbClusterInputOperationOutputAlias,
                crate::output::ModifyDbClusterOutput,
                crate::error::ModifyDBClusterError,
                crate::input::ModifyDbClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The cluster identifier for the cluster that is being modified. This parameter is
        /// not case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing <code>DBCluster</code>.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The cluster identifier for the cluster that is being modified. This parameter is
        /// not case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing <code>DBCluster</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>The new cluster identifier for the cluster when renaming a cluster. This
        /// value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster2</code>
        /// </p>
        pub fn new_db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_db_cluster_identifier(inp);
            self
        }
        /// <p>The new cluster identifier for the cluster when renaming a cluster. This
        /// value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster2</code>
        /// </p>
        pub fn set_new_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_new_db_cluster_identifier(input);
            self
        }
        /// <p>A value that specifies whether the changes in this request and any pending changes are
        /// asynchronously applied as soon as possible, regardless of the
        /// <code>PreferredMaintenanceWindow</code> setting for the cluster. If this
        /// parameter is set to <code>false</code>, changes to the cluster are applied during the
        /// next maintenance window.</p>
        /// <p>The <code>ApplyImmediately</code> parameter affects only the
        /// <code>NewDBClusterIdentifier</code> and <code>MasterUserPassword</code> values. If
        /// you set this parameter value to <code>false</code>, the changes to the
        /// <code>NewDBClusterIdentifier</code> and <code>MasterUserPassword</code> values are
        /// applied during the next maintenance window. All other changes are applied immediately,
        /// regardless of the value of the <code>ApplyImmediately</code> parameter.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn apply_immediately(mut self, inp: bool) -> Self {
            self.inner = self.inner.apply_immediately(inp);
            self
        }
        /// <p>A value that specifies whether the changes in this request and any pending changes are
        /// asynchronously applied as soon as possible, regardless of the
        /// <code>PreferredMaintenanceWindow</code> setting for the cluster. If this
        /// parameter is set to <code>false</code>, changes to the cluster are applied during the
        /// next maintenance window.</p>
        /// <p>The <code>ApplyImmediately</code> parameter affects only the
        /// <code>NewDBClusterIdentifier</code> and <code>MasterUserPassword</code> values. If
        /// you set this parameter value to <code>false</code>, the changes to the
        /// <code>NewDBClusterIdentifier</code> and <code>MasterUserPassword</code> values are
        /// applied during the next maintenance window. All other changes are applied immediately,
        /// regardless of the value of the <code>ApplyImmediately</code> parameter.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_apply_immediately(input);
            self
        }
        /// <p>The number of days for which automated backups are retained. You must specify a
        /// minimum value of 1.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be a value from 1 to 35.</p>
        /// </li>
        /// </ul>
        pub fn backup_retention_period(mut self, inp: i32) -> Self {
            self.inner = self.inner.backup_retention_period(inp);
            self
        }
        /// <p>The number of days for which automated backups are retained. You must specify a
        /// minimum value of 1.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be a value from 1 to 35.</p>
        /// </li>
        /// </ul>
        pub fn set_backup_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_backup_retention_period(input);
            self
        }
        /// <p>The name of the cluster parameter group to use for the cluster.</p>
        pub fn db_cluster_parameter_group_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(inp);
            self
        }
        /// <p>The name of the cluster parameter group to use for the cluster.</p>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of virtual private cloud (VPC) security groups that the cluster will belong
        /// to.</p>
        pub fn vpc_security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(inp);
            self
        }
        /// <p>A list of virtual private cloud (VPC) security groups that the cluster will belong
        /// to.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
        /// <p>The port number on which the cluster accepts connections.</p>
        /// <p>Constraints: Must be a value from <code>1150</code> to <code>65535</code>. </p>
        /// <p>Default: The same port as the original cluster.</p>
        pub fn port(mut self, inp: i32) -> Self {
            self.inner = self.inner.port(inp);
            self
        }
        /// <p>The port number on which the cluster accepts connections.</p>
        /// <p>Constraints: Must be a value from <code>1150</code> to <code>65535</code>. </p>
        /// <p>Default: The same port as the original cluster.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>The password for the master database user. This password can contain any printable
        /// ASCII character except forward slash (/), double quote ("), or the "at" symbol
        /// (@).</p>
        /// <p>Constraints: Must contain from 8 to 100 characters.</p>
        pub fn master_user_password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_user_password(inp);
            self
        }
        /// <p>The password for the master database user. This password can contain any printable
        /// ASCII character except forward slash (/), double quote ("), or the "at" symbol
        /// (@).</p>
        /// <p>Constraints: Must contain from 8 to 100 characters.</p>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_user_password(input);
            self
        }
        /// <p>The daily time range during which automated backups are created if automated backups
        /// are enabled, using the <code>BackupRetentionPeriod</code> parameter. </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for
        /// each Region. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p>
        /// </li>
        /// <li>
        /// <p>Must be in Universal Coordinated Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Must not conflict with the preferred maintenance window.</p>
        /// </li>
        /// <li>
        /// <p>Must be at least 30 minutes.</p>
        /// </li>
        /// </ul>
        pub fn preferred_backup_window(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_backup_window(inp);
            self
        }
        /// <p>The daily time range during which automated backups are created if automated backups
        /// are enabled, using the <code>BackupRetentionPeriod</code> parameter. </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for
        /// each Region. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p>
        /// </li>
        /// <li>
        /// <p>Must be in Universal Coordinated Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Must not conflict with the preferred maintenance window.</p>
        /// </li>
        /// <li>
        /// <p>Must be at least 30 minutes.</p>
        /// </li>
        /// </ul>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_backup_window(input);
            self
        }
        /// <p>The weekly time range during which system maintenance can occur, in Universal
        /// Coordinated Time (UTC).</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for
        /// each Region, occurring on a random day of the week. </p>
        /// <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn preferred_maintenance_window(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_maintenance_window(inp);
            self
        }
        /// <p>The weekly time range during which system maintenance can occur, in Universal
        /// Coordinated Time (UTC).</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for
        /// each Region, occurring on a random day of the week. </p>
        /// <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// <p>The configuration setting for the log types to be enabled for export to Amazon
        /// CloudWatch Logs for a specific instance or cluster. The
        /// <code>EnableLogTypes</code> and <code>DisableLogTypes</code> arrays determine which
        /// logs are exported (or not exported) to CloudWatch Logs.</p>
        pub fn cloudwatch_logs_export_configuration(
            mut self,
            inp: crate::model::CloudwatchLogsExportConfiguration,
        ) -> Self {
            self.inner = self.inner.cloudwatch_logs_export_configuration(inp);
            self
        }
        /// <p>The configuration setting for the log types to be enabled for export to Amazon
        /// CloudWatch Logs for a specific instance or cluster. The
        /// <code>EnableLogTypes</code> and <code>DisableLogTypes</code> arrays determine which
        /// logs are exported (or not exported) to CloudWatch Logs.</p>
        pub fn set_cloudwatch_logs_export_configuration(
            mut self,
            input: std::option::Option<crate::model::CloudwatchLogsExportConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_cloudwatch_logs_export_configuration(input);
            self
        }
        /// <p>The version number of the database engine to which you want to upgrade. Modifying engine version is not supported on Amazon DocumentDB.</p>
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        /// <p>The version number of the database engine to which you want to upgrade. Modifying engine version is not supported on Amazon DocumentDB.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is
        /// enabled, the cluster cannot be deleted unless it is modified and
        /// <code>DeletionProtection</code> is disabled. <code>DeletionProtection</code>
        /// protects clusters from being accidentally deleted.</p>
        pub fn deletion_protection(mut self, inp: bool) -> Self {
            self.inner = self.inner.deletion_protection(inp);
            self
        }
        /// <p>Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is
        /// enabled, the cluster cannot be deleted unless it is modified and
        /// <code>DeletionProtection</code> is disabled. <code>DeletionProtection</code>
        /// protects clusters from being accidentally deleted.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deletion_protection(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyDBClusterParameterGroup`.
    ///
    /// <p> Modifies the parameters of a cluster parameter group. To modify more than one
    /// parameter, submit a list of the following: <code>ParameterName</code>,
    /// <code>ParameterValue</code>, and <code>ApplyMethod</code>. A maximum of 20
    /// parameters can be modified in a single request. </p>
    /// <note>
    /// <p>Changes to dynamic parameters are applied immediately. Changes to static
    /// parameters require a reboot or maintenance window
    ///
    /// before the change can take effect.</p>
    /// </note>
    /// <important>
    /// <p>After you create a cluster parameter group, you should wait at least 5 minutes
    /// before creating your first cluster that uses that cluster parameter group as
    /// the default parameter group. This allows Amazon DocumentDB to fully complete the create action
    /// before the parameter group is used as the default for a new cluster. This step is
    /// especially important for parameters that are critical when creating the default
    /// database for a cluster, such as the character set for the default database
    /// defined by the <code>character_set_database</code> parameter.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct ModifyDBClusterParameterGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_db_cluster_parameter_group_input::Builder,
    }
    impl<C, M, R> ModifyDBClusterParameterGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyDBClusterParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyDbClusterParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyDBClusterParameterGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyDbClusterParameterGroupInputOperationOutputAlias,
                crate::output::ModifyDbClusterParameterGroupOutput,
                crate::error::ModifyDBClusterParameterGroupError,
                crate::input::ModifyDbClusterParameterGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster parameter group to modify.</p>
        pub fn db_cluster_parameter_group_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(inp);
            self
        }
        /// <p>The name of the cluster parameter group to modify.</p>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
        /// Appends an item to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of parameters in the cluster parameter group to modify.</p>
        pub fn parameters(mut self, inp: impl Into<crate::model::Parameter>) -> Self {
            self.inner = self.inner.parameters(inp);
            self
        }
        /// <p>A list of parameters in the cluster parameter group to modify.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyDBClusterSnapshotAttribute`.
    ///
    /// <p>Adds an attribute and values to, or removes an attribute and values from, a manual cluster snapshot.</p>
    /// <p>To share a manual cluster snapshot with other accounts, specify <code>restore</code> as the <code>AttributeName</code>, and use the <code>ValuesToAdd</code> parameter to add a list of IDs of the accounts that are authorized to restore the manual cluster snapshot. Use the value <code>all</code> to make the manual cluster snapshot public, which means that it can be copied or restored by all accounts. Do not add the <code>all</code> value for any manual cluster snapshots that contain private information that you don't want available to all accounts. If a manual cluster snapshot is encrypted, it can be shared, but only by specifying a list of authorized account IDs for the <code>ValuesToAdd</code> parameter. You can't use <code>all</code> as a value for that parameter in this case.</p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyDBClusterSnapshotAttribute<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_db_cluster_snapshot_attribute_input::Builder,
    }
    impl<C, M, R> ModifyDBClusterSnapshotAttribute<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyDBClusterSnapshotAttribute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyDbClusterSnapshotAttributeOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyDBClusterSnapshotAttributeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyDbClusterSnapshotAttributeInputOperationOutputAlias,
                crate::output::ModifyDbClusterSnapshotAttributeOutput,
                crate::error::ModifyDBClusterSnapshotAttributeError,
                crate::input::ModifyDbClusterSnapshotAttributeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the cluster snapshot to modify the attributes for.</p>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_snapshot_identifier(inp);
            self
        }
        /// <p>The identifier for the cluster snapshot to modify the attributes for.</p>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_snapshot_identifier(input);
            self
        }
        /// <p>The name of the cluster snapshot attribute to modify.</p>
        /// <p>To manage authorization for other accounts to copy or restore a manual cluster
        /// snapshot, set this value to <code>restore</code>.</p>
        pub fn attribute_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attribute_name(inp);
            self
        }
        /// <p>The name of the cluster snapshot attribute to modify.</p>
        /// <p>To manage authorization for other accounts to copy or restore a manual cluster
        /// snapshot, set this value to <code>restore</code>.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attribute_name(input);
            self
        }
        /// Appends an item to `ValuesToAdd`.
        ///
        /// To override the contents of this collection use [`set_values_to_add`](Self::set_values_to_add).
        ///
        /// <p>A list of cluster snapshot attributes to add to the attribute specified by <code>AttributeName</code>.</p>
        /// <p>To authorize other accounts to copy or restore a manual cluster snapshot, set this list to include one or more account IDs. To make the manual cluster snapshot restorable by any account, set it to <code>all</code>. Do not add the <code>all</code> value for any manual cluster snapshots that contain private information that you don't want to be available to all accounts.</p>
        pub fn values_to_add(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.values_to_add(inp);
            self
        }
        /// <p>A list of cluster snapshot attributes to add to the attribute specified by <code>AttributeName</code>.</p>
        /// <p>To authorize other accounts to copy or restore a manual cluster snapshot, set this list to include one or more account IDs. To make the manual cluster snapshot restorable by any account, set it to <code>all</code>. Do not add the <code>all</code> value for any manual cluster snapshots that contain private information that you don't want to be available to all accounts.</p>
        pub fn set_values_to_add(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_values_to_add(input);
            self
        }
        /// Appends an item to `ValuesToRemove`.
        ///
        /// To override the contents of this collection use [`set_values_to_remove`](Self::set_values_to_remove).
        ///
        /// <p>A list of cluster snapshot attributes to remove from the attribute specified by <code>AttributeName</code>.</p>
        /// <p>To remove authorization for other accounts to copy or restore a manual cluster snapshot, set this list to include one or more account identifiers. To remove authorization for any account to copy or restore the cluster snapshot, set it to <code>all</code> . If you specify <code>all</code>, an account whose account ID is explicitly added to the <code>restore</code> attribute can still copy or restore a manual cluster snapshot.</p>
        pub fn values_to_remove(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.values_to_remove(inp);
            self
        }
        /// <p>A list of cluster snapshot attributes to remove from the attribute specified by <code>AttributeName</code>.</p>
        /// <p>To remove authorization for other accounts to copy or restore a manual cluster snapshot, set this list to include one or more account identifiers. To remove authorization for any account to copy or restore the cluster snapshot, set it to <code>all</code> . If you specify <code>all</code>, an account whose account ID is explicitly added to the <code>restore</code> attribute can still copy or restore a manual cluster snapshot.</p>
        pub fn set_values_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_values_to_remove(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyDBInstance`.
    ///
    /// <p>Modifies settings for an instance. You can change one or more database configuration parameters by specifying these parameters and the new values in the request.</p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyDBInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_db_instance_input::Builder,
    }
    impl<C, M, R> ModifyDBInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyDBInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyDbInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyDBInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyDbInstanceInputOperationOutputAlias,
                crate::output::ModifyDbInstanceOutput,
                crate::error::ModifyDBInstanceError,
                crate::input::ModifyDbInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The instance identifier. This value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing <code>DBInstance</code>.</p>
        /// </li>
        /// </ul>
        pub fn db_instance_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_identifier(inp);
            self
        }
        /// <p>The instance identifier. This value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing <code>DBInstance</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_identifier(input);
            self
        }
        /// <p>The new compute and memory capacity of the instance; for example, <code>db.r5.large</code>. Not all instance classes are available in all Regions. </p>
        /// <p>If you modify the instance class, an outage occurs during the change. The change is
        /// applied during the next maintenance window, unless <code>ApplyImmediately</code> is
        /// specified as <code>true</code> for this request. </p>
        /// <p>Default: Uses existing setting.</p>
        pub fn db_instance_class(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_class(inp);
            self
        }
        /// <p>The new compute and memory capacity of the instance; for example, <code>db.r5.large</code>. Not all instance classes are available in all Regions. </p>
        /// <p>If you modify the instance class, an outage occurs during the change. The change is
        /// applied during the next maintenance window, unless <code>ApplyImmediately</code> is
        /// specified as <code>true</code> for this request. </p>
        /// <p>Default: Uses existing setting.</p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_class(input);
            self
        }
        /// <p>Specifies whether the modifications in this request and any pending modifications are
        /// asynchronously applied as soon as possible, regardless of the
        /// <code>PreferredMaintenanceWindow</code> setting for the instance. </p>
        /// <p> If this parameter is set to <code>false</code>, changes to the instance are
        /// applied during the next maintenance window. Some parameter changes can cause an outage
        /// and are applied on the next reboot.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn apply_immediately(mut self, inp: bool) -> Self {
            self.inner = self.inner.apply_immediately(inp);
            self
        }
        /// <p>Specifies whether the modifications in this request and any pending modifications are
        /// asynchronously applied as soon as possible, regardless of the
        /// <code>PreferredMaintenanceWindow</code> setting for the instance. </p>
        /// <p> If this parameter is set to <code>false</code>, changes to the instance are
        /// applied during the next maintenance window. Some parameter changes can cause an outage
        /// and are applied on the next reboot.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_apply_immediately(input);
            self
        }
        /// <p>The weekly time range (in UTC) during which system maintenance can occur, which might
        /// result in an outage. Changing this parameter doesn't result in an outage except in the
        /// following situation, and the change is asynchronously applied as soon as possible. If
        /// there are pending actions that cause a reboot, and the maintenance window is changed to
        /// include the current time, changing this parameter causes a reboot of the instance. If
        /// you are moving this window to the current time, there must be at least 30 minutes
        /// between the current time and end of the window to ensure that pending changes are
        /// applied.</p>
        /// <p>Default: Uses existing setting.</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p>
        /// <p>Constraints: Must be at least 30 minutes.</p>
        pub fn preferred_maintenance_window(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_maintenance_window(inp);
            self
        }
        /// <p>The weekly time range (in UTC) during which system maintenance can occur, which might
        /// result in an outage. Changing this parameter doesn't result in an outage except in the
        /// following situation, and the change is asynchronously applied as soon as possible. If
        /// there are pending actions that cause a reboot, and the maintenance window is changed to
        /// include the current time, changing this parameter causes a reboot of the instance. If
        /// you are moving this window to the current time, there must be at least 30 minutes
        /// between the current time and end of the window to ensure that pending changes are
        /// applied.</p>
        /// <p>Default: Uses existing setting.</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p>
        /// <p>Constraints: Must be at least 30 minutes.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// <p>This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.</p>
        pub fn auto_minor_version_upgrade(mut self, inp: bool) -> Self {
            self.inner = self.inner.auto_minor_version_upgrade(inp);
            self
        }
        /// <p>This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.</p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_minor_version_upgrade(input);
            self
        }
        /// <p> The new instance identifier for the instance when renaming an instance. When you change the instance identifier, an instance reboot occurs immediately if you set <code>Apply Immediately</code> to <code>true</code>. It occurs during the next maintenance window if you set <code>Apply Immediately</code> to <code>false</code>. This value is stored as a lowercase string. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>mydbinstance</code>
        /// </p>
        pub fn new_db_instance_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_db_instance_identifier(inp);
            self
        }
        /// <p> The new instance identifier for the instance when renaming an instance. When you change the instance identifier, an instance reboot occurs immediately if you set <code>Apply Immediately</code> to <code>true</code>. It occurs during the next maintenance window if you set <code>Apply Immediately</code> to <code>false</code>. This value is stored as a lowercase string. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>mydbinstance</code>
        /// </p>
        pub fn set_new_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_new_db_instance_identifier(input);
            self
        }
        /// <p>Indicates the certificate that needs to be associated with the instance.</p>
        pub fn ca_certificate_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ca_certificate_identifier(inp);
            self
        }
        /// <p>Indicates the certificate that needs to be associated with the instance.</p>
        pub fn set_ca_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ca_certificate_identifier(input);
            self
        }
        /// <p>A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary instance after a failure of the existing primary instance.</p>
        /// <p>Default: 1</p>
        /// <p>Valid values: 0-15</p>
        pub fn promotion_tier(mut self, inp: i32) -> Self {
            self.inner = self.inner.promotion_tier(inp);
            self
        }
        /// <p>A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary instance after a failure of the existing primary instance.</p>
        /// <p>Default: 1</p>
        /// <p>Valid values: 0-15</p>
        pub fn set_promotion_tier(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_promotion_tier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyDBSubnetGroup`.
    ///
    /// <p>Modifies an existing subnet group. subnet groups must contain at least one subnet in at least two Availability Zones in the Region.</p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyDBSubnetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_db_subnet_group_input::Builder,
    }
    impl<C, M, R> ModifyDBSubnetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyDBSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyDbSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyDBSubnetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyDbSubnetGroupInputOperationOutputAlias,
                crate::output::ModifyDbSubnetGroupOutput,
                crate::error::ModifyDBSubnetGroupError,
                crate::input::ModifyDbSubnetGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the subnet group. This value is stored as a lowercase string. You can't modify the default subnet group. </p>
        /// <p>Constraints: Must match the name of an existing <code>DBSubnetGroup</code>. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn db_subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(inp);
            self
        }
        /// <p>The name for the subnet group. This value is stored as a lowercase string. You can't modify the default subnet group. </p>
        /// <p>Constraints: Must match the name of an existing <code>DBSubnetGroup</code>. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
        /// <p>The description for the subnet group.</p>
        pub fn db_subnet_group_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_description(inp);
            self
        }
        /// <p>The description for the subnet group.</p>
        pub fn set_db_subnet_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_description(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The Amazon EC2 subnet IDs for the subnet group.</p>
        pub fn subnet_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(inp);
            self
        }
        /// <p>The Amazon EC2 subnet IDs for the subnet group.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyEventSubscription`.
    ///
    /// <p>Modifies an existing Amazon DocumentDB event notification subscription.</p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyEventSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_event_subscription_input::Builder,
    }
    impl<C, M, R> ModifyEventSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyEventSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyEventSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyEventSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyEventSubscriptionInputOperationOutputAlias,
                crate::output::ModifyEventSubscriptionOutput,
                crate::error::ModifyEventSubscriptionError,
                crate::input::ModifyEventSubscriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon DocumentDB event notification subscription.</p>
        pub fn subscription_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(inp);
            self
        }
        /// <p>The name of the Amazon DocumentDB event notification subscription.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The
        /// ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>
        pub fn sns_topic_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The
        /// ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_arn(input);
            self
        }
        /// <p>The type of source that is generating the events. For example, if you want to be notified of events generated by an instance, set this parameter to <code>db-instance</code>. If this value is not specified, all events are returned.</p>
        /// <p>Valid values: <code>db-instance</code>, <code>db-parameter-group</code>, <code>db-security-group</code>
        /// </p>
        pub fn source_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_type(inp);
            self
        }
        /// <p>The type of source that is generating the events. For example, if you want to be notified of events generated by an instance, set this parameter to <code>db-instance</code>. If this value is not specified, all events are returned.</p>
        /// <p>Valid values: <code>db-instance</code>, <code>db-parameter-group</code>, <code>db-security-group</code>
        /// </p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// Appends an item to `EventCategories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p> A list of event categories for a <code>SourceType</code> that you want to subscribe
        /// to.</p>
        pub fn event_categories(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_categories(inp);
            self
        }
        /// <p> A list of event categories for a <code>SourceType</code> that you want to subscribe
        /// to.</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_event_categories(input);
            self
        }
        /// <p> A Boolean value; set to <code>true</code> to activate the subscription. </p>
        pub fn enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.enabled(inp);
            self
        }
        /// <p> A Boolean value; set to <code>true</code> to activate the subscription. </p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyGlobalCluster`.
    ///
    /// <p>Modify a setting for an Amazon DocumentDB global cluster. You can change one or more configuration parameters (for example: deletion protection), or the global cluster identifier by specifying these parameters and the new values in the request.</p>
    /// <note>
    /// <p>This action only applies to Amazon DocumentDB clusters.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ModifyGlobalCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_global_cluster_input::Builder,
    }
    impl<C, M, R> ModifyGlobalCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyGlobalCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyGlobalClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyGlobalClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyGlobalClusterInputOperationOutputAlias,
                crate::output::ModifyGlobalClusterOutput,
                crate::error::ModifyGlobalClusterError,
                crate::input::ModifyGlobalClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the global cluster being modified. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing global cluster.</p>
        /// </li>
        /// </ul>
        pub fn global_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_cluster_identifier(inp);
            self
        }
        /// <p>The identifier for the global cluster being modified. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing global cluster.</p>
        /// </li>
        /// </ul>
        pub fn set_global_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_cluster_identifier(input);
            self
        }
        /// <p>The new identifier for a global cluster when you modify a global cluster. This value is stored as a lowercase string.</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens</p>
        /// <p>The first character must be a letter</p>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster2</code>
        /// </p>
        pub fn new_global_cluster_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.new_global_cluster_identifier(inp);
            self
        }
        /// <p>The new identifier for a global cluster when you modify a global cluster. This value is stored as a lowercase string.</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens</p>
        /// <p>The first character must be a letter</p>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster2</code>
        /// </p>
        pub fn set_new_global_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_new_global_cluster_identifier(input);
            self
        }
        /// <p>Indicates if the global cluster has deletion protection enabled. The global cluster can't be deleted when deletion protection is enabled. </p>
        pub fn deletion_protection(mut self, inp: bool) -> Self {
            self.inner = self.inner.deletion_protection(inp);
            self
        }
        /// <p>Indicates if the global cluster has deletion protection enabled. The global cluster can't be deleted when deletion protection is enabled. </p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deletion_protection(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RebootDBInstance`.
    ///
    /// <p>You might need to reboot your instance, usually for maintenance reasons. For
    /// example, if you make certain changes, or if you change the cluster parameter group
    /// that is associated with the instance, you must reboot the instance for the changes to
    /// take effect. </p>
    /// <p>Rebooting an instance restarts the database engine service. Rebooting an instance
    /// results in a momentary outage, during which the instance status is set to
    /// <i>rebooting</i>. </p>
    #[derive(std::fmt::Debug)]
    pub struct RebootDBInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reboot_db_instance_input::Builder,
    }
    impl<C, M, R> RebootDBInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RebootDBInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RebootDbInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::RebootDBInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RebootDbInstanceInputOperationOutputAlias,
                crate::output::RebootDbInstanceOutput,
                crate::error::RebootDBInstanceError,
                crate::input::RebootDbInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The instance identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing <code>DBInstance</code>.</p>
        /// </li>
        /// </ul>
        pub fn db_instance_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_identifier(inp);
            self
        }
        /// <p>The instance identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing <code>DBInstance</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_identifier(input);
            self
        }
        /// <p> When <code>true</code>, the reboot is conducted through a Multi-AZ failover. </p>
        /// <p>Constraint: You can't specify <code>true</code> if the instance is not configured for
        /// Multi-AZ.</p>
        pub fn force_failover(mut self, inp: bool) -> Self {
            self.inner = self.inner.force_failover(inp);
            self
        }
        /// <p> When <code>true</code>, the reboot is conducted through a Multi-AZ failover. </p>
        /// <p>Constraint: You can't specify <code>true</code> if the instance is not configured for
        /// Multi-AZ.</p>
        pub fn set_force_failover(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_failover(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveFromGlobalCluster`.
    ///
    /// <p>Detaches an Amazon DocumentDB secondary cluster from a global cluster. The cluster becomes a standalone cluster with read-write capability instead of being read-only and receiving data from a primary in a different region. </p>
    /// <note>
    /// <p>This action only applies to Amazon DocumentDB clusters.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct RemoveFromGlobalCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_from_global_cluster_input::Builder,
    }
    impl<C, M, R> RemoveFromGlobalCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveFromGlobalCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveFromGlobalClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveFromGlobalClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveFromGlobalClusterInputOperationOutputAlias,
                crate::output::RemoveFromGlobalClusterOutput,
                crate::error::RemoveFromGlobalClusterError,
                crate::input::RemoveFromGlobalClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The cluster identifier to detach from the Amazon DocumentDB global cluster. </p>
        pub fn global_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_cluster_identifier(inp);
            self
        }
        /// <p>The cluster identifier to detach from the Amazon DocumentDB global cluster. </p>
        pub fn set_global_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_cluster_identifier(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) identifying the cluster that was detached from the Amazon DocumentDB global cluster. </p>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) identifying the cluster that was detached from the Amazon DocumentDB global cluster. </p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveSourceIdentifierFromSubscription`.
    ///
    /// <p>Removes a source identifier from an existing Amazon DocumentDB event notification
    /// subscription.</p>
    #[derive(std::fmt::Debug)]
    pub struct RemoveSourceIdentifierFromSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_source_identifier_from_subscription_input::Builder,
    }
    impl<C, M, R> RemoveSourceIdentifierFromSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveSourceIdentifierFromSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveSourceIdentifierFromSubscriptionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::RemoveSourceIdentifierFromSubscriptionError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveSourceIdentifierFromSubscriptionInputOperationOutputAlias,
                crate::output::RemoveSourceIdentifierFromSubscriptionOutput,
                crate::error::RemoveSourceIdentifierFromSubscriptionError,
                crate::input::RemoveSourceIdentifierFromSubscriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon DocumentDB event notification subscription that you want to remove a
        /// source identifier from.</p>
        pub fn subscription_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(inp);
            self
        }
        /// <p>The name of the Amazon DocumentDB event notification subscription that you want to remove a
        /// source identifier from.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
        /// <p> The source identifier to be removed from the subscription, such as the instance
        /// identifier for an instance, or the name of a security group. </p>
        pub fn source_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_identifier(inp);
            self
        }
        /// <p> The source identifier to be removed from the subscription, such as the instance
        /// identifier for an instance, or the name of a security group. </p>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveTagsFromResource`.
    ///
    /// <p>Removes metadata tags from an Amazon DocumentDB resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct RemoveTagsFromResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_tags_from_resource_input::Builder,
    }
    impl<C, M, R> RemoveTagsFromResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveTagsFromResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveTagsFromResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveTagsFromResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveTagsFromResourceInputOperationOutputAlias,
                crate::output::RemoveTagsFromResourceOutput,
                crate::error::RemoveTagsFromResourceError,
                crate::input::RemoveTagsFromResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon DocumentDB resource that the tags are removed from. This value is an Amazon Resource
        /// Name (ARN).</p>
        pub fn resource_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(inp);
            self
        }
        /// <p>The Amazon DocumentDB resource that the tags are removed from. This value is an Amazon Resource
        /// Name (ARN).</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag key (name) of the tag to be removed.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The tag key (name) of the tag to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResetDBClusterParameterGroup`.
    ///
    /// <p> Modifies the parameters of a cluster parameter group to the default value. To
    /// reset specific parameters, submit a list of the following: <code>ParameterName</code>
    /// and <code>ApplyMethod</code>. To reset the entire cluster parameter group, specify
    /// the <code>DBClusterParameterGroupName</code> and <code>ResetAllParameters</code>
    /// parameters. </p>
    /// <p> When you reset the entire group, dynamic parameters are updated immediately and
    /// static parameters are set to <code>pending-reboot</code> to take effect on the next DB
    /// instance reboot.</p>
    #[derive(std::fmt::Debug)]
    pub struct ResetDBClusterParameterGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reset_db_cluster_parameter_group_input::Builder,
    }
    impl<C, M, R> ResetDBClusterParameterGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResetDBClusterParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResetDbClusterParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ResetDBClusterParameterGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResetDbClusterParameterGroupInputOperationOutputAlias,
                crate::output::ResetDbClusterParameterGroupOutput,
                crate::error::ResetDBClusterParameterGroupError,
                crate::input::ResetDbClusterParameterGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster parameter group to reset.</p>
        pub fn db_cluster_parameter_group_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(inp);
            self
        }
        /// <p>The name of the cluster parameter group to reset.</p>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
        /// <p>A value that is set to <code>true</code> to reset all parameters in the cluster
        /// parameter group to their default values, and <code>false</code> otherwise. You can't use
        /// this parameter if there is a list of parameter names specified for the
        /// <code>Parameters</code> parameter.</p>
        pub fn reset_all_parameters(mut self, inp: bool) -> Self {
            self.inner = self.inner.reset_all_parameters(inp);
            self
        }
        /// <p>A value that is set to <code>true</code> to reset all parameters in the cluster
        /// parameter group to their default values, and <code>false</code> otherwise. You can't use
        /// this parameter if there is a list of parameter names specified for the
        /// <code>Parameters</code> parameter.</p>
        pub fn set_reset_all_parameters(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reset_all_parameters(input);
            self
        }
        /// Appends an item to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of parameter names in the cluster parameter group to reset to the default
        /// values. You can't use this parameter if the <code>ResetAllParameters</code> parameter is
        /// set to <code>true</code>.</p>
        pub fn parameters(mut self, inp: impl Into<crate::model::Parameter>) -> Self {
            self.inner = self.inner.parameters(inp);
            self
        }
        /// <p>A list of parameter names in the cluster parameter group to reset to the default
        /// values. You can't use this parameter if the <code>ResetAllParameters</code> parameter is
        /// set to <code>true</code>.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestoreDBClusterFromSnapshot`.
    ///
    /// <p>Creates a new cluster from a snapshot or cluster snapshot.</p>
    /// <p>If a snapshot is specified, the target cluster is created from the source DB snapshot with a default configuration and default security group.</p>
    /// <p>If a cluster snapshot is specified, the target cluster is created from the source cluster restore point with the same configuration as the original source DB cluster, except that the new cluster is created with the default security group.</p>
    #[derive(std::fmt::Debug)]
    pub struct RestoreDBClusterFromSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::restore_db_cluster_from_snapshot_input::Builder,
    }
    impl<C, M, R> RestoreDBClusterFromSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RestoreDBClusterFromSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestoreDbClusterFromSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::RestoreDBClusterFromSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RestoreDbClusterFromSnapshotInputOperationOutputAlias,
                crate::output::RestoreDbClusterFromSnapshotOutput,
                crate::error::RestoreDBClusterFromSnapshotError,
                crate::input::RestoreDbClusterFromSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AvailabilityZones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>Provides the list of Amazon EC2 Availability Zones that instances in the restored DB
        /// cluster can be created in.</p>
        pub fn availability_zones(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zones(inp);
            self
        }
        /// <p>Provides the list of Amazon EC2 Availability Zones that instances in the restored DB
        /// cluster can be created in.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_availability_zones(input);
            self
        }
        /// <p>The name of the cluster to create from the snapshot or cluster snapshot. This
        /// parameter isn't case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-snapshot-id</code>
        /// </p>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The name of the cluster to create from the snapshot or cluster snapshot. This
        /// parameter isn't case sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-snapshot-id</code>
        /// </p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>The identifier for the snapshot or cluster snapshot to restore from.</p>
        /// <p>You can use either the name or the Amazon Resource Name (ARN) to specify a cluster
        /// snapshot. However, you can use only the ARN to specify a snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing snapshot.</p>
        /// </li>
        /// </ul>
        pub fn snapshot_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_identifier(inp);
            self
        }
        /// <p>The identifier for the snapshot or cluster snapshot to restore from.</p>
        /// <p>You can use either the name or the Amazon Resource Name (ARN) to specify a cluster
        /// snapshot. However, you can use only the ARN to specify a snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing snapshot.</p>
        /// </li>
        /// </ul>
        pub fn set_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_identifier(input);
            self
        }
        /// <p>The database engine to use for the new cluster.</p>
        /// <p>Default: The same as source.</p>
        /// <p>Constraint: Must be compatible with the engine of the source.</p>
        pub fn engine(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(inp);
            self
        }
        /// <p>The database engine to use for the new cluster.</p>
        /// <p>Default: The same as source.</p>
        /// <p>Constraint: Must be compatible with the engine of the source.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>The version of the database engine to use for the new cluster.</p>
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        /// <p>The version of the database engine to use for the new cluster.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>The port number on which the new cluster accepts connections.</p>
        /// <p>Constraints: Must be a value from <code>1150</code> to <code>65535</code>.</p>
        /// <p>Default: The same port as the original cluster.</p>
        pub fn port(mut self, inp: i32) -> Self {
            self.inner = self.inner.port(inp);
            self
        }
        /// <p>The port number on which the new cluster accepts connections.</p>
        /// <p>Constraints: Must be a value from <code>1150</code> to <code>65535</code>.</p>
        /// <p>Default: The same port as the original cluster.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>The name of the subnet group to use for the new cluster.</p>
        /// <p>Constraints: If provided, must match the name of an existing
        /// <code>DBSubnetGroup</code>.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn db_subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(inp);
            self
        }
        /// <p>The name of the subnet group to use for the new cluster.</p>
        /// <p>Constraints: If provided, must match the name of an existing
        /// <code>DBSubnetGroup</code>.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of virtual private cloud (VPC) security groups that the new cluster will
        /// belong to.</p>
        pub fn vpc_security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(inp);
            self
        }
        /// <p>A list of virtual private cloud (VPC) security groups that the new cluster will
        /// belong to.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the restored cluster.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be assigned to the restored cluster.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The KMS key identifier to use when restoring an encrypted cluster from a DB snapshot or cluster snapshot.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a cluster with the same account that owns the KMS encryption key used to encrypt the new cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.</p>
        /// <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the
        /// following occurs:</p>
        /// <ul>
        /// <li>
        /// <p>If the snapshot or cluster snapshot in <code>SnapshotIdentifier</code> is encrypted, then the restored cluster is encrypted using the KMS key that was used to encrypt the snapshot or the cluster snapshot.</p>
        /// </li>
        /// <li>
        /// <p>If the snapshot or the cluster snapshot in
        /// <code>SnapshotIdentifier</code> is not encrypted, then the restored DB
        /// cluster is not encrypted.</p>
        /// </li>
        /// </ul>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The KMS key identifier to use when restoring an encrypted cluster from a DB snapshot or cluster snapshot.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a cluster with the same account that owns the KMS encryption key used to encrypt the new cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.</p>
        /// <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the
        /// following occurs:</p>
        /// <ul>
        /// <li>
        /// <p>If the snapshot or cluster snapshot in <code>SnapshotIdentifier</code> is encrypted, then the restored cluster is encrypted using the KMS key that was used to encrypt the snapshot or the cluster snapshot.</p>
        /// </li>
        /// <li>
        /// <p>If the snapshot or the cluster snapshot in
        /// <code>SnapshotIdentifier</code> is not encrypted, then the restored DB
        /// cluster is not encrypted.</p>
        /// </li>
        /// </ul>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// Appends an item to `EnableCloudwatchLogsExports`.
        ///
        /// To override the contents of this collection use [`set_enable_cloudwatch_logs_exports`](Self::set_enable_cloudwatch_logs_exports).
        ///
        /// <p>A list of log types that must be enabled for exporting to Amazon CloudWatch Logs.</p>
        pub fn enable_cloudwatch_logs_exports(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.enable_cloudwatch_logs_exports(inp);
            self
        }
        /// <p>A list of log types that must be enabled for exporting to Amazon CloudWatch Logs.</p>
        pub fn set_enable_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_enable_cloudwatch_logs_exports(input);
            self
        }
        /// <p>Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is enabled, the cluster cannot be deleted unless it is modified and <code>DeletionProtection</code> is disabled. <code>DeletionProtection</code> protects clusters from being accidentally deleted.</p>
        pub fn deletion_protection(mut self, inp: bool) -> Self {
            self.inner = self.inner.deletion_protection(inp);
            self
        }
        /// <p>Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is enabled, the cluster cannot be deleted unless it is modified and <code>DeletionProtection</code> is disabled. <code>DeletionProtection</code> protects clusters from being accidentally deleted.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deletion_protection(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestoreDBClusterToPointInTime`.
    ///
    /// <p>Restores a cluster to an arbitrary point in time. Users can restore to any point in
    /// time before <code>LatestRestorableTime</code> for up to
    /// <code>BackupRetentionPeriod</code> days. The target cluster is created from the
    /// source cluster with the same configuration as the original cluster, except that
    /// the new cluster is created with the default security group. </p>
    #[derive(std::fmt::Debug)]
    pub struct RestoreDBClusterToPointInTime<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::restore_db_cluster_to_point_in_time_input::Builder,
    }
    impl<C, M, R> RestoreDBClusterToPointInTime<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RestoreDBClusterToPointInTime`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestoreDbClusterToPointInTimeOutput,
            aws_smithy_http::result::SdkError<crate::error::RestoreDBClusterToPointInTimeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RestoreDbClusterToPointInTimeInputOperationOutputAlias,
                crate::output::RestoreDbClusterToPointInTimeOutput,
                crate::error::RestoreDBClusterToPointInTimeError,
                crate::input::RestoreDbClusterToPointInTimeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the new cluster to be created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The name of the new cluster to be created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>The identifier of the source cluster from which to restore.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing <code>DBCluster</code>.</p>
        /// </li>
        /// </ul>
        pub fn source_db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_db_cluster_identifier(inp);
            self
        }
        /// <p>The identifier of the source cluster from which to restore.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing <code>DBCluster</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_source_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_db_cluster_identifier(input);
            self
        }
        /// <p>The date and time to restore the cluster to.</p>
        /// <p>Valid values: A time in Universal Coordinated Time (UTC) format.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be before the latest restorable time for the instance.</p>
        /// </li>
        /// <li>
        /// <p>Must be specified if the <code>UseLatestRestorableTime</code> parameter is not provided.</p>
        /// </li>
        /// <li>
        /// <p>Cannot be specified if the <code>UseLatestRestorableTime</code> parameter is <code>true</code>.</p>
        /// </li>
        /// <li>
        /// <p>Cannot be specified if the <code>RestoreType</code> parameter is <code>copy-on-write</code>.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>2015-03-07T23:45:00Z</code>
        /// </p>
        pub fn restore_to_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.restore_to_time(inp);
            self
        }
        /// <p>The date and time to restore the cluster to.</p>
        /// <p>Valid values: A time in Universal Coordinated Time (UTC) format.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be before the latest restorable time for the instance.</p>
        /// </li>
        /// <li>
        /// <p>Must be specified if the <code>UseLatestRestorableTime</code> parameter is not provided.</p>
        /// </li>
        /// <li>
        /// <p>Cannot be specified if the <code>UseLatestRestorableTime</code> parameter is <code>true</code>.</p>
        /// </li>
        /// <li>
        /// <p>Cannot be specified if the <code>RestoreType</code> parameter is <code>copy-on-write</code>.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>2015-03-07T23:45:00Z</code>
        /// </p>
        pub fn set_restore_to_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_restore_to_time(input);
            self
        }
        /// <p>A value that is set to <code>true</code> to restore the cluster to the latest
        /// restorable backup time, and <code>false</code> otherwise. </p>
        /// <p>Default: <code>false</code>
        /// </p>
        /// <p>Constraints: Cannot be specified if the <code>RestoreToTime</code> parameter is
        /// provided.</p>
        pub fn use_latest_restorable_time(mut self, inp: bool) -> Self {
            self.inner = self.inner.use_latest_restorable_time(inp);
            self
        }
        /// <p>A value that is set to <code>true</code> to restore the cluster to the latest
        /// restorable backup time, and <code>false</code> otherwise. </p>
        /// <p>Default: <code>false</code>
        /// </p>
        /// <p>Constraints: Cannot be specified if the <code>RestoreToTime</code> parameter is
        /// provided.</p>
        pub fn set_use_latest_restorable_time(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_use_latest_restorable_time(input);
            self
        }
        /// <p>The port number on which the new cluster accepts connections.</p>
        /// <p>Constraints: Must be a value from <code>1150</code> to <code>65535</code>. </p>
        /// <p>Default: The default port for the engine.</p>
        pub fn port(mut self, inp: i32) -> Self {
            self.inner = self.inner.port(inp);
            self
        }
        /// <p>The port number on which the new cluster accepts connections.</p>
        /// <p>Constraints: Must be a value from <code>1150</code> to <code>65535</code>. </p>
        /// <p>Default: The default port for the engine.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>The subnet group name to use for the new cluster.</p>
        /// <p>Constraints: If provided, must match the name of an existing
        /// <code>DBSubnetGroup</code>.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn db_subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(inp);
            self
        }
        /// <p>The subnet group name to use for the new cluster.</p>
        /// <p>Constraints: If provided, must match the name of an existing
        /// <code>DBSubnetGroup</code>.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of VPC security groups that the new cluster belongs to.</p>
        pub fn vpc_security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(inp);
            self
        }
        /// <p>A list of VPC security groups that the new cluster belongs to.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the restored cluster.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be assigned to the restored cluster.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The KMS key identifier to use when restoring an encrypted cluster from an encrypted cluster.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a cluster with the same account that owns the KMS encryption key used to encrypt the new cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.</p>
        /// <p>You can restore to a new cluster and encrypt the new cluster with an KMS key that is different from the KMS key used to encrypt the source cluster. The new DB cluster is encrypted with the KMS key identified by the <code>KmsKeyId</code> parameter.</p>
        /// <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following occurs:</p>
        /// <ul>
        /// <li>
        /// <p>If the cluster is encrypted, then the restored cluster is encrypted using the KMS key that was used to encrypt the source cluster.</p>
        /// </li>
        /// <li>
        /// <p>If the cluster is not encrypted, then the restored cluster is not encrypted.</p>
        /// </li>
        /// </ul>
        /// <p>If <code>DBClusterIdentifier</code> refers to a cluster that is not encrypted, then
        /// the restore request is rejected.</p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The KMS key identifier to use when restoring an encrypted cluster from an encrypted cluster.</p>
        /// <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a cluster with the same account that owns the KMS encryption key used to encrypt the new cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.</p>
        /// <p>You can restore to a new cluster and encrypt the new cluster with an KMS key that is different from the KMS key used to encrypt the source cluster. The new DB cluster is encrypted with the KMS key identified by the <code>KmsKeyId</code> parameter.</p>
        /// <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following occurs:</p>
        /// <ul>
        /// <li>
        /// <p>If the cluster is encrypted, then the restored cluster is encrypted using the KMS key that was used to encrypt the source cluster.</p>
        /// </li>
        /// <li>
        /// <p>If the cluster is not encrypted, then the restored cluster is not encrypted.</p>
        /// </li>
        /// </ul>
        /// <p>If <code>DBClusterIdentifier</code> refers to a cluster that is not encrypted, then
        /// the restore request is rejected.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// Appends an item to `EnableCloudwatchLogsExports`.
        ///
        /// To override the contents of this collection use [`set_enable_cloudwatch_logs_exports`](Self::set_enable_cloudwatch_logs_exports).
        ///
        /// <p>A list of log types that must be enabled for exporting to Amazon CloudWatch
        /// Logs.</p>
        pub fn enable_cloudwatch_logs_exports(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.enable_cloudwatch_logs_exports(inp);
            self
        }
        /// <p>A list of log types that must be enabled for exporting to Amazon CloudWatch
        /// Logs.</p>
        pub fn set_enable_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_enable_cloudwatch_logs_exports(input);
            self
        }
        /// <p>Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is enabled, the cluster cannot be deleted unless it is modified and <code>DeletionProtection</code> is disabled. <code>DeletionProtection</code> protects clusters from being accidentally deleted.</p>
        pub fn deletion_protection(mut self, inp: bool) -> Self {
            self.inner = self.inner.deletion_protection(inp);
            self
        }
        /// <p>Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is enabled, the cluster cannot be deleted unless it is modified and <code>DeletionProtection</code> is disabled. <code>DeletionProtection</code> protects clusters from being accidentally deleted.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deletion_protection(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartDBCluster`.
    ///
    /// <p>Restarts the stopped cluster that is specified by <code>DBClusterIdentifier</code>.
    /// For more information, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-stop-start.html">Stopping and
    /// Starting an Amazon DocumentDB Cluster</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartDBCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_db_cluster_input::Builder,
    }
    impl<C, M, R> StartDBCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartDbClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::StartDBClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartDbClusterInputOperationOutputAlias,
                crate::output::StartDbClusterOutput,
                crate::error::StartDBClusterError,
                crate::input::StartDbClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the cluster to restart. Example:
        /// <code>docdb-2019-05-28-15-24-52</code>
        /// </p>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The identifier of the cluster to restart. Example:
        /// <code>docdb-2019-05-28-15-24-52</code>
        /// </p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopDBCluster`.
    ///
    /// <p>Stops the running cluster that is specified by <code>DBClusterIdentifier</code>. The
    /// cluster must be in the <i>available</i> state. For more information, see
    /// <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-stop-start.html">Stopping and
    /// Starting an Amazon DocumentDB Cluster</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopDBCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_db_cluster_input::Builder,
    }
    impl<C, M, R> StopDBCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopDbClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::StopDBClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopDbClusterInputOperationOutputAlias,
                crate::output::StopDbClusterOutput,
                crate::error::StopDBClusterError,
                crate::input::StopDbClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the cluster to stop. Example:
        /// <code>docdb-2019-05-28-15-24-52</code>
        /// </p>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The identifier of the cluster to stop. Example:
        /// <code>docdb-2019-05-28-15-24-52</code>
        /// </p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
