// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Specifies the configuration of a lifecycle policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyDetails {
    /// <p>The valid target resource types and actions a policy can manage. Specify <code>EBS_SNAPSHOT_MANAGEMENT</code>
    /// to create a lifecycle policy that manages the lifecycle of Amazon EBS snapshots. Specify <code>IMAGE_MANAGEMENT</code>
    /// to create a lifecycle policy that manages the lifecycle of EBS-backed AMIs. Specify <code>EVENT_BASED_POLICY </code>
    /// to create an event-based policy that performs specific actions when a defined event occurs in your Amazon Web Services account.</p>
    /// <p>The default is <code>EBS_SNAPSHOT_MANAGEMENT</code>.</p>
    pub policy_type: std::option::Option<crate::model::PolicyTypeValues>,
    /// <p>The target resource type for snapshot and AMI lifecycle policies. Use <code>VOLUME </code>to
    /// create snapshots of individual volumes or use <code>INSTANCE</code> to create multi-volume
    /// snapshots from the volumes for an instance.</p>
    /// <p>This parameter is required for snapshot and AMI policies only. If you are creating an event-based policy, omit this parameter.</p>
    pub resource_types: std::option::Option<std::vec::Vec<crate::model::ResourceTypeValues>>,
    /// <p>The location of the resources to backup. If the source resources are located in an Amazon Web Services Region,
    /// specify <code>CLOUD</code>. If the source resources are located on an Outpost
    /// in your account, specify <code>OUTPOST</code>. </p>
    /// <p>If you specify <code>OUTPOST</code>, Amazon Data Lifecycle Manager backs up all resources
    /// of the specified type with matching target tags across all of the Outposts in your account.</p>
    pub resource_locations:
        std::option::Option<std::vec::Vec<crate::model::ResourceLocationValues>>,
    /// <p>The single tag that identifies targeted resources for this policy.</p>
    /// <p>This parameter is required for snapshot and AMI policies only. If you are creating an event-based policy, omit this parameter.</p>
    pub target_tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The schedules of policy-defined actions for snapshot and AMI lifecycle policies. A policy
    /// can have up to four schedules—one mandatory schedule and up to three optional schedules.</p>
    /// <p>This parameter is required for snapshot and AMI policies only. If you are creating an event-based policy, omit this parameter.</p>
    pub schedules: std::option::Option<std::vec::Vec<crate::model::Schedule>>,
    /// <p>A set of optional parameters for snapshot and AMI lifecycle policies. </p>
    /// <p>This parameter is required for snapshot and AMI policies only. If you are creating an event-based policy, omit this parameter.</p>
    pub parameters: std::option::Option<crate::model::Parameters>,
    /// <p>The event that triggers the event-based policy. </p>
    /// <p>This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter.</p>
    pub event_source: std::option::Option<crate::model::EventSource>,
    /// <p>The actions to be performed when the event-based policy is triggered. You can specify
    /// only one action per policy.</p>
    /// <p>This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter.</p>
    pub actions: std::option::Option<std::vec::Vec<crate::model::Action>>,
}
impl std::fmt::Debug for PolicyDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyDetails");
        formatter.field("policy_type", &self.policy_type);
        formatter.field("resource_types", &self.resource_types);
        formatter.field("resource_locations", &self.resource_locations);
        formatter.field("target_tags", &self.target_tags);
        formatter.field("schedules", &self.schedules);
        formatter.field("parameters", &self.parameters);
        formatter.field("event_source", &self.event_source);
        formatter.field("actions", &self.actions);
        formatter.finish()
    }
}
/// See [`PolicyDetails`](crate::model::PolicyDetails)
pub mod policy_details {
    /// A builder for [`PolicyDetails`](crate::model::PolicyDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_type: std::option::Option<crate::model::PolicyTypeValues>,
        pub(crate) resource_types:
            std::option::Option<std::vec::Vec<crate::model::ResourceTypeValues>>,
        pub(crate) resource_locations:
            std::option::Option<std::vec::Vec<crate::model::ResourceLocationValues>>,
        pub(crate) target_tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) schedules: std::option::Option<std::vec::Vec<crate::model::Schedule>>,
        pub(crate) parameters: std::option::Option<crate::model::Parameters>,
        pub(crate) event_source: std::option::Option<crate::model::EventSource>,
        pub(crate) actions: std::option::Option<std::vec::Vec<crate::model::Action>>,
    }
    impl Builder {
        /// <p>The valid target resource types and actions a policy can manage. Specify <code>EBS_SNAPSHOT_MANAGEMENT</code>
        /// to create a lifecycle policy that manages the lifecycle of Amazon EBS snapshots. Specify <code>IMAGE_MANAGEMENT</code>
        /// to create a lifecycle policy that manages the lifecycle of EBS-backed AMIs. Specify <code>EVENT_BASED_POLICY </code>
        /// to create an event-based policy that performs specific actions when a defined event occurs in your Amazon Web Services account.</p>
        /// <p>The default is <code>EBS_SNAPSHOT_MANAGEMENT</code>.</p>
        pub fn policy_type(mut self, input: crate::model::PolicyTypeValues) -> Self {
            self.policy_type = Some(input);
            self
        }
        /// <p>The valid target resource types and actions a policy can manage. Specify <code>EBS_SNAPSHOT_MANAGEMENT</code>
        /// to create a lifecycle policy that manages the lifecycle of Amazon EBS snapshots. Specify <code>IMAGE_MANAGEMENT</code>
        /// to create a lifecycle policy that manages the lifecycle of EBS-backed AMIs. Specify <code>EVENT_BASED_POLICY </code>
        /// to create an event-based policy that performs specific actions when a defined event occurs in your Amazon Web Services account.</p>
        /// <p>The default is <code>EBS_SNAPSHOT_MANAGEMENT</code>.</p>
        pub fn set_policy_type(
            mut self,
            input: std::option::Option<crate::model::PolicyTypeValues>,
        ) -> Self {
            self.policy_type = input;
            self
        }
        /// Appends an item to `resource_types`.
        ///
        /// To override the contents of this collection use [`set_resource_types`](Self::set_resource_types).
        ///
        /// <p>The target resource type for snapshot and AMI lifecycle policies. Use <code>VOLUME </code>to
        /// create snapshots of individual volumes or use <code>INSTANCE</code> to create multi-volume
        /// snapshots from the volumes for an instance.</p>
        /// <p>This parameter is required for snapshot and AMI policies only. If you are creating an event-based policy, omit this parameter.</p>
        pub fn resource_types(
            mut self,
            input: impl Into<crate::model::ResourceTypeValues>,
        ) -> Self {
            let mut v = self.resource_types.unwrap_or_default();
            v.push(input.into());
            self.resource_types = Some(v);
            self
        }
        /// <p>The target resource type for snapshot and AMI lifecycle policies. Use <code>VOLUME </code>to
        /// create snapshots of individual volumes or use <code>INSTANCE</code> to create multi-volume
        /// snapshots from the volumes for an instance.</p>
        /// <p>This parameter is required for snapshot and AMI policies only. If you are creating an event-based policy, omit this parameter.</p>
        pub fn set_resource_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceTypeValues>>,
        ) -> Self {
            self.resource_types = input;
            self
        }
        /// Appends an item to `resource_locations`.
        ///
        /// To override the contents of this collection use [`set_resource_locations`](Self::set_resource_locations).
        ///
        /// <p>The location of the resources to backup. If the source resources are located in an Amazon Web Services Region,
        /// specify <code>CLOUD</code>. If the source resources are located on an Outpost
        /// in your account, specify <code>OUTPOST</code>. </p>
        /// <p>If you specify <code>OUTPOST</code>, Amazon Data Lifecycle Manager backs up all resources
        /// of the specified type with matching target tags across all of the Outposts in your account.</p>
        pub fn resource_locations(
            mut self,
            input: impl Into<crate::model::ResourceLocationValues>,
        ) -> Self {
            let mut v = self.resource_locations.unwrap_or_default();
            v.push(input.into());
            self.resource_locations = Some(v);
            self
        }
        /// <p>The location of the resources to backup. If the source resources are located in an Amazon Web Services Region,
        /// specify <code>CLOUD</code>. If the source resources are located on an Outpost
        /// in your account, specify <code>OUTPOST</code>. </p>
        /// <p>If you specify <code>OUTPOST</code>, Amazon Data Lifecycle Manager backs up all resources
        /// of the specified type with matching target tags across all of the Outposts in your account.</p>
        pub fn set_resource_locations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceLocationValues>>,
        ) -> Self {
            self.resource_locations = input;
            self
        }
        /// Appends an item to `target_tags`.
        ///
        /// To override the contents of this collection use [`set_target_tags`](Self::set_target_tags).
        ///
        /// <p>The single tag that identifies targeted resources for this policy.</p>
        /// <p>This parameter is required for snapshot and AMI policies only. If you are creating an event-based policy, omit this parameter.</p>
        pub fn target_tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.target_tags.unwrap_or_default();
            v.push(input.into());
            self.target_tags = Some(v);
            self
        }
        /// <p>The single tag that identifies targeted resources for this policy.</p>
        /// <p>This parameter is required for snapshot and AMI policies only. If you are creating an event-based policy, omit this parameter.</p>
        pub fn set_target_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.target_tags = input;
            self
        }
        /// Appends an item to `schedules`.
        ///
        /// To override the contents of this collection use [`set_schedules`](Self::set_schedules).
        ///
        /// <p>The schedules of policy-defined actions for snapshot and AMI lifecycle policies. A policy
        /// can have up to four schedules—one mandatory schedule and up to three optional schedules.</p>
        /// <p>This parameter is required for snapshot and AMI policies only. If you are creating an event-based policy, omit this parameter.</p>
        pub fn schedules(mut self, input: impl Into<crate::model::Schedule>) -> Self {
            let mut v = self.schedules.unwrap_or_default();
            v.push(input.into());
            self.schedules = Some(v);
            self
        }
        /// <p>The schedules of policy-defined actions for snapshot and AMI lifecycle policies. A policy
        /// can have up to four schedules—one mandatory schedule and up to three optional schedules.</p>
        /// <p>This parameter is required for snapshot and AMI policies only. If you are creating an event-based policy, omit this parameter.</p>
        pub fn set_schedules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Schedule>>,
        ) -> Self {
            self.schedules = input;
            self
        }
        /// <p>A set of optional parameters for snapshot and AMI lifecycle policies. </p>
        /// <p>This parameter is required for snapshot and AMI policies only. If you are creating an event-based policy, omit this parameter.</p>
        pub fn parameters(mut self, input: crate::model::Parameters) -> Self {
            self.parameters = Some(input);
            self
        }
        /// <p>A set of optional parameters for snapshot and AMI lifecycle policies. </p>
        /// <p>This parameter is required for snapshot and AMI policies only. If you are creating an event-based policy, omit this parameter.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<crate::model::Parameters>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>The event that triggers the event-based policy. </p>
        /// <p>This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter.</p>
        pub fn event_source(mut self, input: crate::model::EventSource) -> Self {
            self.event_source = Some(input);
            self
        }
        /// <p>The event that triggers the event-based policy. </p>
        /// <p>This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter.</p>
        pub fn set_event_source(
            mut self,
            input: std::option::Option<crate::model::EventSource>,
        ) -> Self {
            self.event_source = input;
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>The actions to be performed when the event-based policy is triggered. You can specify
        /// only one action per policy.</p>
        /// <p>This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter.</p>
        pub fn actions(mut self, input: impl Into<crate::model::Action>) -> Self {
            let mut v = self.actions.unwrap_or_default();
            v.push(input.into());
            self.actions = Some(v);
            self
        }
        /// <p>The actions to be performed when the event-based policy is triggered. You can specify
        /// only one action per policy.</p>
        /// <p>This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Action>>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyDetails`](crate::model::PolicyDetails)
        pub fn build(self) -> crate::model::PolicyDetails {
            crate::model::PolicyDetails {
                policy_type: self.policy_type,
                resource_types: self.resource_types,
                resource_locations: self.resource_locations,
                target_tags: self.target_tags,
                schedules: self.schedules,
                parameters: self.parameters,
                event_source: self.event_source,
                actions: self.actions,
            }
        }
    }
}
impl PolicyDetails {
    /// Creates a new builder-style object to manufacture [`PolicyDetails`](crate::model::PolicyDetails)
    pub fn builder() -> crate::model::policy_details::Builder {
        crate::model::policy_details::Builder::default()
    }
}

/// <p>Specifies an action for an event-based policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Action {
    /// <p>A descriptive name for the action.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The rule for copying shared snapshots across Regions.</p>
    pub cross_region_copy: std::option::Option<std::vec::Vec<crate::model::CrossRegionCopyAction>>,
}
impl std::fmt::Debug for Action {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Action");
        formatter.field("name", &self.name);
        formatter.field("cross_region_copy", &self.cross_region_copy);
        formatter.finish()
    }
}
/// See [`Action`](crate::model::Action)
pub mod action {
    /// A builder for [`Action`](crate::model::Action)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) cross_region_copy:
            std::option::Option<std::vec::Vec<crate::model::CrossRegionCopyAction>>,
    }
    impl Builder {
        /// <p>A descriptive name for the action.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A descriptive name for the action.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `cross_region_copy`.
        ///
        /// To override the contents of this collection use [`set_cross_region_copy`](Self::set_cross_region_copy).
        ///
        /// <p>The rule for copying shared snapshots across Regions.</p>
        pub fn cross_region_copy(
            mut self,
            input: impl Into<crate::model::CrossRegionCopyAction>,
        ) -> Self {
            let mut v = self.cross_region_copy.unwrap_or_default();
            v.push(input.into());
            self.cross_region_copy = Some(v);
            self
        }
        /// <p>The rule for copying shared snapshots across Regions.</p>
        pub fn set_cross_region_copy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CrossRegionCopyAction>>,
        ) -> Self {
            self.cross_region_copy = input;
            self
        }
        /// Consumes the builder and constructs a [`Action`](crate::model::Action)
        pub fn build(self) -> crate::model::Action {
            crate::model::Action {
                name: self.name,
                cross_region_copy: self.cross_region_copy,
            }
        }
    }
}
impl Action {
    /// Creates a new builder-style object to manufacture [`Action`](crate::model::Action)
    pub fn builder() -> crate::model::action::Builder {
        crate::model::action::Builder::default()
    }
}

/// <p>Specifies a rule for copying shared snapshots across Regions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CrossRegionCopyAction {
    /// <p>The target Region.</p>
    pub target: std::option::Option<std::string::String>,
    /// <p>The encryption settings for the copied snapshot.</p>
    pub encryption_configuration: std::option::Option<crate::model::EncryptionConfiguration>,
    /// <p>Specifies the retention rule for cross-Region snapshot copies.</p>
    pub retain_rule: std::option::Option<crate::model::CrossRegionCopyRetainRule>,
}
impl std::fmt::Debug for CrossRegionCopyAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CrossRegionCopyAction");
        formatter.field("target", &self.target);
        formatter.field("encryption_configuration", &self.encryption_configuration);
        formatter.field("retain_rule", &self.retain_rule);
        formatter.finish()
    }
}
/// See [`CrossRegionCopyAction`](crate::model::CrossRegionCopyAction)
pub mod cross_region_copy_action {
    /// A builder for [`CrossRegionCopyAction`](crate::model::CrossRegionCopyAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target: std::option::Option<std::string::String>,
        pub(crate) encryption_configuration:
            std::option::Option<crate::model::EncryptionConfiguration>,
        pub(crate) retain_rule: std::option::Option<crate::model::CrossRegionCopyRetainRule>,
    }
    impl Builder {
        /// <p>The target Region.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.target = Some(input.into());
            self
        }
        /// <p>The target Region.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target = input;
            self
        }
        /// <p>The encryption settings for the copied snapshot.</p>
        pub fn encryption_configuration(
            mut self,
            input: crate::model::EncryptionConfiguration,
        ) -> Self {
            self.encryption_configuration = Some(input);
            self
        }
        /// <p>The encryption settings for the copied snapshot.</p>
        pub fn set_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::EncryptionConfiguration>,
        ) -> Self {
            self.encryption_configuration = input;
            self
        }
        /// <p>Specifies the retention rule for cross-Region snapshot copies.</p>
        pub fn retain_rule(mut self, input: crate::model::CrossRegionCopyRetainRule) -> Self {
            self.retain_rule = Some(input);
            self
        }
        /// <p>Specifies the retention rule for cross-Region snapshot copies.</p>
        pub fn set_retain_rule(
            mut self,
            input: std::option::Option<crate::model::CrossRegionCopyRetainRule>,
        ) -> Self {
            self.retain_rule = input;
            self
        }
        /// Consumes the builder and constructs a [`CrossRegionCopyAction`](crate::model::CrossRegionCopyAction)
        pub fn build(self) -> crate::model::CrossRegionCopyAction {
            crate::model::CrossRegionCopyAction {
                target: self.target,
                encryption_configuration: self.encryption_configuration,
                retain_rule: self.retain_rule,
            }
        }
    }
}
impl CrossRegionCopyAction {
    /// Creates a new builder-style object to manufacture [`CrossRegionCopyAction`](crate::model::CrossRegionCopyAction)
    pub fn builder() -> crate::model::cross_region_copy_action::Builder {
        crate::model::cross_region_copy_action::Builder::default()
    }
}

/// <p>Specifies the retention rule for cross-Region snapshot copies.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CrossRegionCopyRetainRule {
    /// <p>The amount of time to retain each snapshot. The maximum is 100 years. This is
    /// equivalent to 1200 months, 5200 weeks, or 36500 days.</p>
    pub interval: i32,
    /// <p>The unit of time for time-based retention.</p>
    pub interval_unit: std::option::Option<crate::model::RetentionIntervalUnitValues>,
}
impl std::fmt::Debug for CrossRegionCopyRetainRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CrossRegionCopyRetainRule");
        formatter.field("interval", &self.interval);
        formatter.field("interval_unit", &self.interval_unit);
        formatter.finish()
    }
}
/// See [`CrossRegionCopyRetainRule`](crate::model::CrossRegionCopyRetainRule)
pub mod cross_region_copy_retain_rule {
    /// A builder for [`CrossRegionCopyRetainRule`](crate::model::CrossRegionCopyRetainRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) interval: std::option::Option<i32>,
        pub(crate) interval_unit: std::option::Option<crate::model::RetentionIntervalUnitValues>,
    }
    impl Builder {
        /// <p>The amount of time to retain each snapshot. The maximum is 100 years. This is
        /// equivalent to 1200 months, 5200 weeks, or 36500 days.</p>
        pub fn interval(mut self, input: i32) -> Self {
            self.interval = Some(input);
            self
        }
        /// <p>The amount of time to retain each snapshot. The maximum is 100 years. This is
        /// equivalent to 1200 months, 5200 weeks, or 36500 days.</p>
        pub fn set_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.interval = input;
            self
        }
        /// <p>The unit of time for time-based retention.</p>
        pub fn interval_unit(mut self, input: crate::model::RetentionIntervalUnitValues) -> Self {
            self.interval_unit = Some(input);
            self
        }
        /// <p>The unit of time for time-based retention.</p>
        pub fn set_interval_unit(
            mut self,
            input: std::option::Option<crate::model::RetentionIntervalUnitValues>,
        ) -> Self {
            self.interval_unit = input;
            self
        }
        /// Consumes the builder and constructs a [`CrossRegionCopyRetainRule`](crate::model::CrossRegionCopyRetainRule)
        pub fn build(self) -> crate::model::CrossRegionCopyRetainRule {
            crate::model::CrossRegionCopyRetainRule {
                interval: self.interval.unwrap_or_default(),
                interval_unit: self.interval_unit,
            }
        }
    }
}
impl CrossRegionCopyRetainRule {
    /// Creates a new builder-style object to manufacture [`CrossRegionCopyRetainRule`](crate::model::CrossRegionCopyRetainRule)
    pub fn builder() -> crate::model::cross_region_copy_retain_rule::Builder {
        crate::model::cross_region_copy_retain_rule::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RetentionIntervalUnitValues {
    #[allow(missing_docs)] // documentation missing in model
    Days,
    #[allow(missing_docs)] // documentation missing in model
    Months,
    #[allow(missing_docs)] // documentation missing in model
    Weeks,
    #[allow(missing_docs)] // documentation missing in model
    Years,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RetentionIntervalUnitValues {
    fn from(s: &str) -> Self {
        match s {
            "DAYS" => RetentionIntervalUnitValues::Days,
            "MONTHS" => RetentionIntervalUnitValues::Months,
            "WEEKS" => RetentionIntervalUnitValues::Weeks,
            "YEARS" => RetentionIntervalUnitValues::Years,
            other => RetentionIntervalUnitValues::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RetentionIntervalUnitValues {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RetentionIntervalUnitValues::from(s))
    }
}
impl RetentionIntervalUnitValues {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RetentionIntervalUnitValues::Days => "DAYS",
            RetentionIntervalUnitValues::Months => "MONTHS",
            RetentionIntervalUnitValues::Weeks => "WEEKS",
            RetentionIntervalUnitValues::Years => "YEARS",
            RetentionIntervalUnitValues::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DAYS", "MONTHS", "WEEKS", "YEARS"]
    }
}
impl AsRef<str> for RetentionIntervalUnitValues {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the encryption settings for shared snapshots that are copied across Regions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EncryptionConfiguration {
    /// <p>To encrypt a copy of an unencrypted snapshot when encryption by default is not enabled, enable
    /// encryption using this parameter. Copies of encrypted snapshots are encrypted, even if this
    /// parameter is false or when encryption by default is not enabled.</p>
    pub encrypted: std::option::Option<bool>,
    /// <p>The Amazon Resource Name (ARN) of the KMS key to use for EBS encryption. If
    /// this parameter is not specified, the default KMS key for the account is used.</p>
    pub cmk_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EncryptionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EncryptionConfiguration");
        formatter.field("encrypted", &self.encrypted);
        formatter.field("cmk_arn", &self.cmk_arn);
        formatter.finish()
    }
}
/// See [`EncryptionConfiguration`](crate::model::EncryptionConfiguration)
pub mod encryption_configuration {
    /// A builder for [`EncryptionConfiguration`](crate::model::EncryptionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encrypted: std::option::Option<bool>,
        pub(crate) cmk_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>To encrypt a copy of an unencrypted snapshot when encryption by default is not enabled, enable
        /// encryption using this parameter. Copies of encrypted snapshots are encrypted, even if this
        /// parameter is false or when encryption by default is not enabled.</p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.encrypted = Some(input);
            self
        }
        /// <p>To encrypt a copy of an unencrypted snapshot when encryption by default is not enabled, enable
        /// encryption using this parameter. Copies of encrypted snapshots are encrypted, even if this
        /// parameter is false or when encryption by default is not enabled.</p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.encrypted = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the KMS key to use for EBS encryption. If
        /// this parameter is not specified, the default KMS key for the account is used.</p>
        pub fn cmk_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cmk_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the KMS key to use for EBS encryption. If
        /// this parameter is not specified, the default KMS key for the account is used.</p>
        pub fn set_cmk_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cmk_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`EncryptionConfiguration`](crate::model::EncryptionConfiguration)
        pub fn build(self) -> crate::model::EncryptionConfiguration {
            crate::model::EncryptionConfiguration {
                encrypted: self.encrypted,
                cmk_arn: self.cmk_arn,
            }
        }
    }
}
impl EncryptionConfiguration {
    /// Creates a new builder-style object to manufacture [`EncryptionConfiguration`](crate::model::EncryptionConfiguration)
    pub fn builder() -> crate::model::encryption_configuration::Builder {
        crate::model::encryption_configuration::Builder::default()
    }
}

/// <p>Specifies an event that triggers an event-based policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventSource {
    /// <p>The source of the event. Currently only managed CloudWatch Events rules are supported.</p>
    pub r#type: std::option::Option<crate::model::EventSourceValues>,
    /// <p>Information about the event.</p>
    pub parameters: std::option::Option<crate::model::EventParameters>,
}
impl std::fmt::Debug for EventSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventSource");
        formatter.field("r#type", &self.r#type);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}
/// See [`EventSource`](crate::model::EventSource)
pub mod event_source {
    /// A builder for [`EventSource`](crate::model::EventSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::EventSourceValues>,
        pub(crate) parameters: std::option::Option<crate::model::EventParameters>,
    }
    impl Builder {
        /// <p>The source of the event. Currently only managed CloudWatch Events rules are supported.</p>
        pub fn r#type(mut self, input: crate::model::EventSourceValues) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The source of the event. Currently only managed CloudWatch Events rules are supported.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::EventSourceValues>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Information about the event.</p>
        pub fn parameters(mut self, input: crate::model::EventParameters) -> Self {
            self.parameters = Some(input);
            self
        }
        /// <p>Information about the event.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<crate::model::EventParameters>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`EventSource`](crate::model::EventSource)
        pub fn build(self) -> crate::model::EventSource {
            crate::model::EventSource {
                r#type: self.r#type,
                parameters: self.parameters,
            }
        }
    }
}
impl EventSource {
    /// Creates a new builder-style object to manufacture [`EventSource`](crate::model::EventSource)
    pub fn builder() -> crate::model::event_source::Builder {
        crate::model::event_source::Builder::default()
    }
}

/// <p>Specifies an event that triggers an event-based policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventParameters {
    /// <p>The type of event. Currently, only snapshot sharing events are supported.</p>
    pub event_type: std::option::Option<crate::model::EventTypeValues>,
    /// <p>The IDs of the Amazon Web Services accounts that can trigger policy by sharing snapshots with your account.
    /// The policy only runs if one of the specified Amazon Web Services accounts shares a snapshot with your account.</p>
    pub snapshot_owner: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The snapshot description that can trigger the policy. The description pattern is specified using
    /// a regular expression. The policy runs only if a snapshot with a description that matches the
    /// specified pattern is shared with your account.</p>
    /// <p>For example, specifying <code>^.*Created for policy: policy-1234567890abcdef0.*$</code>  
    /// configures the policy to run only if snapshots created by policy <code>policy-1234567890abcdef0</code>
    /// are shared with your account.</p>
    pub description_regex: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EventParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventParameters");
        formatter.field("event_type", &self.event_type);
        formatter.field("snapshot_owner", &self.snapshot_owner);
        formatter.field("description_regex", &self.description_regex);
        formatter.finish()
    }
}
/// See [`EventParameters`](crate::model::EventParameters)
pub mod event_parameters {
    /// A builder for [`EventParameters`](crate::model::EventParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_type: std::option::Option<crate::model::EventTypeValues>,
        pub(crate) snapshot_owner: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) description_regex: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of event. Currently, only snapshot sharing events are supported.</p>
        pub fn event_type(mut self, input: crate::model::EventTypeValues) -> Self {
            self.event_type = Some(input);
            self
        }
        /// <p>The type of event. Currently, only snapshot sharing events are supported.</p>
        pub fn set_event_type(
            mut self,
            input: std::option::Option<crate::model::EventTypeValues>,
        ) -> Self {
            self.event_type = input;
            self
        }
        /// Appends an item to `snapshot_owner`.
        ///
        /// To override the contents of this collection use [`set_snapshot_owner`](Self::set_snapshot_owner).
        ///
        /// <p>The IDs of the Amazon Web Services accounts that can trigger policy by sharing snapshots with your account.
        /// The policy only runs if one of the specified Amazon Web Services accounts shares a snapshot with your account.</p>
        pub fn snapshot_owner(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.snapshot_owner.unwrap_or_default();
            v.push(input.into());
            self.snapshot_owner = Some(v);
            self
        }
        /// <p>The IDs of the Amazon Web Services accounts that can trigger policy by sharing snapshots with your account.
        /// The policy only runs if one of the specified Amazon Web Services accounts shares a snapshot with your account.</p>
        pub fn set_snapshot_owner(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.snapshot_owner = input;
            self
        }
        /// <p>The snapshot description that can trigger the policy. The description pattern is specified using
        /// a regular expression. The policy runs only if a snapshot with a description that matches the
        /// specified pattern is shared with your account.</p>
        /// <p>For example, specifying <code>^.*Created for policy: policy-1234567890abcdef0.*$</code>  
        /// configures the policy to run only if snapshots created by policy <code>policy-1234567890abcdef0</code>
        /// are shared with your account.</p>
        pub fn description_regex(mut self, input: impl Into<std::string::String>) -> Self {
            self.description_regex = Some(input.into());
            self
        }
        /// <p>The snapshot description that can trigger the policy. The description pattern is specified using
        /// a regular expression. The policy runs only if a snapshot with a description that matches the
        /// specified pattern is shared with your account.</p>
        /// <p>For example, specifying <code>^.*Created for policy: policy-1234567890abcdef0.*$</code>  
        /// configures the policy to run only if snapshots created by policy <code>policy-1234567890abcdef0</code>
        /// are shared with your account.</p>
        pub fn set_description_regex(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.description_regex = input;
            self
        }
        /// Consumes the builder and constructs a [`EventParameters`](crate::model::EventParameters)
        pub fn build(self) -> crate::model::EventParameters {
            crate::model::EventParameters {
                event_type: self.event_type,
                snapshot_owner: self.snapshot_owner,
                description_regex: self.description_regex,
            }
        }
    }
}
impl EventParameters {
    /// Creates a new builder-style object to manufacture [`EventParameters`](crate::model::EventParameters)
    pub fn builder() -> crate::model::event_parameters::Builder {
        crate::model::event_parameters::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventTypeValues {
    #[allow(missing_docs)] // documentation missing in model
    ShareSnapshot,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventTypeValues {
    fn from(s: &str) -> Self {
        match s {
            "shareSnapshot" => EventTypeValues::ShareSnapshot,
            other => EventTypeValues::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventTypeValues {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventTypeValues::from(s))
    }
}
impl EventTypeValues {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventTypeValues::ShareSnapshot => "shareSnapshot",
            EventTypeValues::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["shareSnapshot"]
    }
}
impl AsRef<str> for EventTypeValues {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventSourceValues {
    #[allow(missing_docs)] // documentation missing in model
    ManagedCwe,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventSourceValues {
    fn from(s: &str) -> Self {
        match s {
            "MANAGED_CWE" => EventSourceValues::ManagedCwe,
            other => EventSourceValues::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventSourceValues {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventSourceValues::from(s))
    }
}
impl EventSourceValues {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventSourceValues::ManagedCwe => "MANAGED_CWE",
            EventSourceValues::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MANAGED_CWE"]
    }
}
impl AsRef<str> for EventSourceValues {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies optional parameters to add to a policy. The set of valid parameters depends
/// on the combination of policy type and resource type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Parameters {
    /// <p>[EBS Snapshot Management – Instance policies only] Indicates whether to exclude the
    /// root volume from snapshots created using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSnapshots.html">CreateSnapshots</a>.
    /// The default is false.</p>
    pub exclude_boot_volume: std::option::Option<bool>,
    /// <p>Applies to AMI lifecycle policies only. Indicates whether targeted instances are rebooted when the lifecycle
    /// policy runs. <code>true</code> indicates that targeted instances are not rebooted when the policy
    /// runs. <code>false</code> indicates that target instances are rebooted when the policy runs. The
    /// default is <code>true</code> (instances are not rebooted).</p>
    pub no_reboot: std::option::Option<bool>,
}
impl std::fmt::Debug for Parameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Parameters");
        formatter.field("exclude_boot_volume", &self.exclude_boot_volume);
        formatter.field("no_reboot", &self.no_reboot);
        formatter.finish()
    }
}
/// See [`Parameters`](crate::model::Parameters)
pub mod parameters {
    /// A builder for [`Parameters`](crate::model::Parameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) exclude_boot_volume: std::option::Option<bool>,
        pub(crate) no_reboot: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>[EBS Snapshot Management – Instance policies only] Indicates whether to exclude the
        /// root volume from snapshots created using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSnapshots.html">CreateSnapshots</a>.
        /// The default is false.</p>
        pub fn exclude_boot_volume(mut self, input: bool) -> Self {
            self.exclude_boot_volume = Some(input);
            self
        }
        /// <p>[EBS Snapshot Management – Instance policies only] Indicates whether to exclude the
        /// root volume from snapshots created using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSnapshots.html">CreateSnapshots</a>.
        /// The default is false.</p>
        pub fn set_exclude_boot_volume(mut self, input: std::option::Option<bool>) -> Self {
            self.exclude_boot_volume = input;
            self
        }
        /// <p>Applies to AMI lifecycle policies only. Indicates whether targeted instances are rebooted when the lifecycle
        /// policy runs. <code>true</code> indicates that targeted instances are not rebooted when the policy
        /// runs. <code>false</code> indicates that target instances are rebooted when the policy runs. The
        /// default is <code>true</code> (instances are not rebooted).</p>
        pub fn no_reboot(mut self, input: bool) -> Self {
            self.no_reboot = Some(input);
            self
        }
        /// <p>Applies to AMI lifecycle policies only. Indicates whether targeted instances are rebooted when the lifecycle
        /// policy runs. <code>true</code> indicates that targeted instances are not rebooted when the policy
        /// runs. <code>false</code> indicates that target instances are rebooted when the policy runs. The
        /// default is <code>true</code> (instances are not rebooted).</p>
        pub fn set_no_reboot(mut self, input: std::option::Option<bool>) -> Self {
            self.no_reboot = input;
            self
        }
        /// Consumes the builder and constructs a [`Parameters`](crate::model::Parameters)
        pub fn build(self) -> crate::model::Parameters {
            crate::model::Parameters {
                exclude_boot_volume: self.exclude_boot_volume,
                no_reboot: self.no_reboot,
            }
        }
    }
}
impl Parameters {
    /// Creates a new builder-style object to manufacture [`Parameters`](crate::model::Parameters)
    pub fn builder() -> crate::model::parameters::Builder {
        crate::model::parameters::Builder::default()
    }
}

/// <p>Specifies a backup schedule for a snapshot or AMI lifecycle policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Schedule {
    /// <p>The name of the schedule.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Copy all user-defined tags on a source volume to snapshots of the volume created by
    /// this policy.</p>
    pub copy_tags: bool,
    /// <p>The tags to apply to policy-created resources. These user-defined tags are in addition
    /// to the Amazon Web Services-added lifecycle tags.</p>
    pub tags_to_add: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>A collection of key/value pairs with values determined dynamically when the policy is
    /// executed. Keys may be any valid Amazon EC2 tag key. Values must be in one of the two
    /// following formats: <code>$(instance-id)</code> or <code>$(timestamp)</code>. Variable
    /// tags are only valid for EBS Snapshot Management – Instance policies.</p>
    pub variable_tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The creation rule.</p>
    pub create_rule: std::option::Option<crate::model::CreateRule>,
    /// <p>The retention rule.</p>
    pub retain_rule: std::option::Option<crate::model::RetainRule>,
    /// <p>The rule for enabling fast snapshot restore.</p>
    pub fast_restore_rule: std::option::Option<crate::model::FastRestoreRule>,
    /// <p>The rule for cross-Region snapshot copies.</p>
    /// <p>You can only specify cross-Region copy rules for policies that create snapshots in a Region.
    /// If the policy creates snapshots on an Outpost, then you cannot copy the snapshots to a Region or
    /// to an Outpost. If the policy creates snapshots in a Region, then snapshots can be copied to up to three
    /// Regions or Outposts.</p>
    pub cross_region_copy_rules:
        std::option::Option<std::vec::Vec<crate::model::CrossRegionCopyRule>>,
    /// <p>The rule for sharing snapshots with other Amazon Web Services accounts.</p>
    pub share_rules: std::option::Option<std::vec::Vec<crate::model::ShareRule>>,
    /// <p>The AMI deprecation rule for the schedule.</p>
    pub deprecate_rule: std::option::Option<crate::model::DeprecateRule>,
}
impl std::fmt::Debug for Schedule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Schedule");
        formatter.field("name", &self.name);
        formatter.field("copy_tags", &self.copy_tags);
        formatter.field("tags_to_add", &self.tags_to_add);
        formatter.field("variable_tags", &self.variable_tags);
        formatter.field("create_rule", &self.create_rule);
        formatter.field("retain_rule", &self.retain_rule);
        formatter.field("fast_restore_rule", &self.fast_restore_rule);
        formatter.field("cross_region_copy_rules", &self.cross_region_copy_rules);
        formatter.field("share_rules", &self.share_rules);
        formatter.field("deprecate_rule", &self.deprecate_rule);
        formatter.finish()
    }
}
/// See [`Schedule`](crate::model::Schedule)
pub mod schedule {
    /// A builder for [`Schedule`](crate::model::Schedule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) copy_tags: std::option::Option<bool>,
        pub(crate) tags_to_add: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) variable_tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) create_rule: std::option::Option<crate::model::CreateRule>,
        pub(crate) retain_rule: std::option::Option<crate::model::RetainRule>,
        pub(crate) fast_restore_rule: std::option::Option<crate::model::FastRestoreRule>,
        pub(crate) cross_region_copy_rules:
            std::option::Option<std::vec::Vec<crate::model::CrossRegionCopyRule>>,
        pub(crate) share_rules: std::option::Option<std::vec::Vec<crate::model::ShareRule>>,
        pub(crate) deprecate_rule: std::option::Option<crate::model::DeprecateRule>,
    }
    impl Builder {
        /// <p>The name of the schedule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the schedule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Copy all user-defined tags on a source volume to snapshots of the volume created by
        /// this policy.</p>
        pub fn copy_tags(mut self, input: bool) -> Self {
            self.copy_tags = Some(input);
            self
        }
        /// <p>Copy all user-defined tags on a source volume to snapshots of the volume created by
        /// this policy.</p>
        pub fn set_copy_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_tags = input;
            self
        }
        /// Appends an item to `tags_to_add`.
        ///
        /// To override the contents of this collection use [`set_tags_to_add`](Self::set_tags_to_add).
        ///
        /// <p>The tags to apply to policy-created resources. These user-defined tags are in addition
        /// to the Amazon Web Services-added lifecycle tags.</p>
        pub fn tags_to_add(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags_to_add.unwrap_or_default();
            v.push(input.into());
            self.tags_to_add = Some(v);
            self
        }
        /// <p>The tags to apply to policy-created resources. These user-defined tags are in addition
        /// to the Amazon Web Services-added lifecycle tags.</p>
        pub fn set_tags_to_add(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags_to_add = input;
            self
        }
        /// Appends an item to `variable_tags`.
        ///
        /// To override the contents of this collection use [`set_variable_tags`](Self::set_variable_tags).
        ///
        /// <p>A collection of key/value pairs with values determined dynamically when the policy is
        /// executed. Keys may be any valid Amazon EC2 tag key. Values must be in one of the two
        /// following formats: <code>$(instance-id)</code> or <code>$(timestamp)</code>. Variable
        /// tags are only valid for EBS Snapshot Management – Instance policies.</p>
        pub fn variable_tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.variable_tags.unwrap_or_default();
            v.push(input.into());
            self.variable_tags = Some(v);
            self
        }
        /// <p>A collection of key/value pairs with values determined dynamically when the policy is
        /// executed. Keys may be any valid Amazon EC2 tag key. Values must be in one of the two
        /// following formats: <code>$(instance-id)</code> or <code>$(timestamp)</code>. Variable
        /// tags are only valid for EBS Snapshot Management – Instance policies.</p>
        pub fn set_variable_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.variable_tags = input;
            self
        }
        /// <p>The creation rule.</p>
        pub fn create_rule(mut self, input: crate::model::CreateRule) -> Self {
            self.create_rule = Some(input);
            self
        }
        /// <p>The creation rule.</p>
        pub fn set_create_rule(
            mut self,
            input: std::option::Option<crate::model::CreateRule>,
        ) -> Self {
            self.create_rule = input;
            self
        }
        /// <p>The retention rule.</p>
        pub fn retain_rule(mut self, input: crate::model::RetainRule) -> Self {
            self.retain_rule = Some(input);
            self
        }
        /// <p>The retention rule.</p>
        pub fn set_retain_rule(
            mut self,
            input: std::option::Option<crate::model::RetainRule>,
        ) -> Self {
            self.retain_rule = input;
            self
        }
        /// <p>The rule for enabling fast snapshot restore.</p>
        pub fn fast_restore_rule(mut self, input: crate::model::FastRestoreRule) -> Self {
            self.fast_restore_rule = Some(input);
            self
        }
        /// <p>The rule for enabling fast snapshot restore.</p>
        pub fn set_fast_restore_rule(
            mut self,
            input: std::option::Option<crate::model::FastRestoreRule>,
        ) -> Self {
            self.fast_restore_rule = input;
            self
        }
        /// Appends an item to `cross_region_copy_rules`.
        ///
        /// To override the contents of this collection use [`set_cross_region_copy_rules`](Self::set_cross_region_copy_rules).
        ///
        /// <p>The rule for cross-Region snapshot copies.</p>
        /// <p>You can only specify cross-Region copy rules for policies that create snapshots in a Region.
        /// If the policy creates snapshots on an Outpost, then you cannot copy the snapshots to a Region or
        /// to an Outpost. If the policy creates snapshots in a Region, then snapshots can be copied to up to three
        /// Regions or Outposts.</p>
        pub fn cross_region_copy_rules(
            mut self,
            input: impl Into<crate::model::CrossRegionCopyRule>,
        ) -> Self {
            let mut v = self.cross_region_copy_rules.unwrap_or_default();
            v.push(input.into());
            self.cross_region_copy_rules = Some(v);
            self
        }
        /// <p>The rule for cross-Region snapshot copies.</p>
        /// <p>You can only specify cross-Region copy rules for policies that create snapshots in a Region.
        /// If the policy creates snapshots on an Outpost, then you cannot copy the snapshots to a Region or
        /// to an Outpost. If the policy creates snapshots in a Region, then snapshots can be copied to up to three
        /// Regions or Outposts.</p>
        pub fn set_cross_region_copy_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CrossRegionCopyRule>>,
        ) -> Self {
            self.cross_region_copy_rules = input;
            self
        }
        /// Appends an item to `share_rules`.
        ///
        /// To override the contents of this collection use [`set_share_rules`](Self::set_share_rules).
        ///
        /// <p>The rule for sharing snapshots with other Amazon Web Services accounts.</p>
        pub fn share_rules(mut self, input: impl Into<crate::model::ShareRule>) -> Self {
            let mut v = self.share_rules.unwrap_or_default();
            v.push(input.into());
            self.share_rules = Some(v);
            self
        }
        /// <p>The rule for sharing snapshots with other Amazon Web Services accounts.</p>
        pub fn set_share_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ShareRule>>,
        ) -> Self {
            self.share_rules = input;
            self
        }
        /// <p>The AMI deprecation rule for the schedule.</p>
        pub fn deprecate_rule(mut self, input: crate::model::DeprecateRule) -> Self {
            self.deprecate_rule = Some(input);
            self
        }
        /// <p>The AMI deprecation rule for the schedule.</p>
        pub fn set_deprecate_rule(
            mut self,
            input: std::option::Option<crate::model::DeprecateRule>,
        ) -> Self {
            self.deprecate_rule = input;
            self
        }
        /// Consumes the builder and constructs a [`Schedule`](crate::model::Schedule)
        pub fn build(self) -> crate::model::Schedule {
            crate::model::Schedule {
                name: self.name,
                copy_tags: self.copy_tags.unwrap_or_default(),
                tags_to_add: self.tags_to_add,
                variable_tags: self.variable_tags,
                create_rule: self.create_rule,
                retain_rule: self.retain_rule,
                fast_restore_rule: self.fast_restore_rule,
                cross_region_copy_rules: self.cross_region_copy_rules,
                share_rules: self.share_rules,
                deprecate_rule: self.deprecate_rule,
            }
        }
    }
}
impl Schedule {
    /// Creates a new builder-style object to manufacture [`Schedule`](crate::model::Schedule)
    pub fn builder() -> crate::model::schedule::Builder {
        crate::model::schedule::Builder::default()
    }
}

/// <p>Specifies an AMI deprecation rule for a schedule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeprecateRule {
    /// <p>If the schedule has a count-based retention rule, this parameter specifies the number of oldest
    /// AMIs to deprecate. The count must be less than or equal to the schedule's retention count, and it
    /// can't be greater than 1000.</p>
    pub count: i32,
    /// <p>If the schedule has an age-based retention rule, this parameter specifies the period after which
    /// to deprecate AMIs created by the schedule. The period must be less than or equal to the schedule's
    /// retention period, and it can't be greater than 10 years. This is equivalent to 120 months, 520
    /// weeks, or 3650 days.</p>
    pub interval: i32,
    /// <p>The unit of time in which to measure the <b>Interval</b>.</p>
    pub interval_unit: std::option::Option<crate::model::RetentionIntervalUnitValues>,
}
impl std::fmt::Debug for DeprecateRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeprecateRule");
        formatter.field("count", &self.count);
        formatter.field("interval", &self.interval);
        formatter.field("interval_unit", &self.interval_unit);
        formatter.finish()
    }
}
/// See [`DeprecateRule`](crate::model::DeprecateRule)
pub mod deprecate_rule {
    /// A builder for [`DeprecateRule`](crate::model::DeprecateRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) count: std::option::Option<i32>,
        pub(crate) interval: std::option::Option<i32>,
        pub(crate) interval_unit: std::option::Option<crate::model::RetentionIntervalUnitValues>,
    }
    impl Builder {
        /// <p>If the schedule has a count-based retention rule, this parameter specifies the number of oldest
        /// AMIs to deprecate. The count must be less than or equal to the schedule's retention count, and it
        /// can't be greater than 1000.</p>
        pub fn count(mut self, input: i32) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>If the schedule has a count-based retention rule, this parameter specifies the number of oldest
        /// AMIs to deprecate. The count must be less than or equal to the schedule's retention count, and it
        /// can't be greater than 1000.</p>
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.count = input;
            self
        }
        /// <p>If the schedule has an age-based retention rule, this parameter specifies the period after which
        /// to deprecate AMIs created by the schedule. The period must be less than or equal to the schedule's
        /// retention period, and it can't be greater than 10 years. This is equivalent to 120 months, 520
        /// weeks, or 3650 days.</p>
        pub fn interval(mut self, input: i32) -> Self {
            self.interval = Some(input);
            self
        }
        /// <p>If the schedule has an age-based retention rule, this parameter specifies the period after which
        /// to deprecate AMIs created by the schedule. The period must be less than or equal to the schedule's
        /// retention period, and it can't be greater than 10 years. This is equivalent to 120 months, 520
        /// weeks, or 3650 days.</p>
        pub fn set_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.interval = input;
            self
        }
        /// <p>The unit of time in which to measure the <b>Interval</b>.</p>
        pub fn interval_unit(mut self, input: crate::model::RetentionIntervalUnitValues) -> Self {
            self.interval_unit = Some(input);
            self
        }
        /// <p>The unit of time in which to measure the <b>Interval</b>.</p>
        pub fn set_interval_unit(
            mut self,
            input: std::option::Option<crate::model::RetentionIntervalUnitValues>,
        ) -> Self {
            self.interval_unit = input;
            self
        }
        /// Consumes the builder and constructs a [`DeprecateRule`](crate::model::DeprecateRule)
        pub fn build(self) -> crate::model::DeprecateRule {
            crate::model::DeprecateRule {
                count: self.count.unwrap_or_default(),
                interval: self.interval.unwrap_or_default(),
                interval_unit: self.interval_unit,
            }
        }
    }
}
impl DeprecateRule {
    /// Creates a new builder-style object to manufacture [`DeprecateRule`](crate::model::DeprecateRule)
    pub fn builder() -> crate::model::deprecate_rule::Builder {
        crate::model::deprecate_rule::Builder::default()
    }
}

/// <p>Specifies a rule for sharing snapshots across Amazon Web Services accounts.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ShareRule {
    /// <p>The IDs of the Amazon Web Services accounts with which to share the snapshots.</p>
    pub target_accounts: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The period after which snapshots that are shared with other Amazon Web Services accounts are automatically unshared.</p>
    pub unshare_interval: i32,
    /// <p>The unit of time for the automatic unsharing interval.</p>
    pub unshare_interval_unit: std::option::Option<crate::model::RetentionIntervalUnitValues>,
}
impl std::fmt::Debug for ShareRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ShareRule");
        formatter.field("target_accounts", &self.target_accounts);
        formatter.field("unshare_interval", &self.unshare_interval);
        formatter.field("unshare_interval_unit", &self.unshare_interval_unit);
        formatter.finish()
    }
}
/// See [`ShareRule`](crate::model::ShareRule)
pub mod share_rule {
    /// A builder for [`ShareRule`](crate::model::ShareRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_accounts: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) unshare_interval: std::option::Option<i32>,
        pub(crate) unshare_interval_unit:
            std::option::Option<crate::model::RetentionIntervalUnitValues>,
    }
    impl Builder {
        /// Appends an item to `target_accounts`.
        ///
        /// To override the contents of this collection use [`set_target_accounts`](Self::set_target_accounts).
        ///
        /// <p>The IDs of the Amazon Web Services accounts with which to share the snapshots.</p>
        pub fn target_accounts(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.target_accounts.unwrap_or_default();
            v.push(input.into());
            self.target_accounts = Some(v);
            self
        }
        /// <p>The IDs of the Amazon Web Services accounts with which to share the snapshots.</p>
        pub fn set_target_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.target_accounts = input;
            self
        }
        /// <p>The period after which snapshots that are shared with other Amazon Web Services accounts are automatically unshared.</p>
        pub fn unshare_interval(mut self, input: i32) -> Self {
            self.unshare_interval = Some(input);
            self
        }
        /// <p>The period after which snapshots that are shared with other Amazon Web Services accounts are automatically unshared.</p>
        pub fn set_unshare_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.unshare_interval = input;
            self
        }
        /// <p>The unit of time for the automatic unsharing interval.</p>
        pub fn unshare_interval_unit(
            mut self,
            input: crate::model::RetentionIntervalUnitValues,
        ) -> Self {
            self.unshare_interval_unit = Some(input);
            self
        }
        /// <p>The unit of time for the automatic unsharing interval.</p>
        pub fn set_unshare_interval_unit(
            mut self,
            input: std::option::Option<crate::model::RetentionIntervalUnitValues>,
        ) -> Self {
            self.unshare_interval_unit = input;
            self
        }
        /// Consumes the builder and constructs a [`ShareRule`](crate::model::ShareRule)
        pub fn build(self) -> crate::model::ShareRule {
            crate::model::ShareRule {
                target_accounts: self.target_accounts,
                unshare_interval: self.unshare_interval.unwrap_or_default(),
                unshare_interval_unit: self.unshare_interval_unit,
            }
        }
    }
}
impl ShareRule {
    /// Creates a new builder-style object to manufacture [`ShareRule`](crate::model::ShareRule)
    pub fn builder() -> crate::model::share_rule::Builder {
        crate::model::share_rule::Builder::default()
    }
}

/// <p>Specifies a rule for cross-Region snapshot copies.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CrossRegionCopyRule {
    /// <p>Avoid using this parameter when creating new policies. Instead, use <b>Target</b>
    /// to specify a target Region or a target Outpost for snapshot copies.</p>
    /// <p>For policies created before the <b>Target</b> parameter
    /// was introduced, this parameter indicates the target Region for snapshot copies.</p>
    pub target_region: std::option::Option<std::string::String>,
    /// <p>The target Region or the Amazon Resource Name (ARN) of the target Outpost for the
    /// snapshot copies.</p>
    /// <p>Use this parameter instead of <b>TargetRegion</b>. Do not
    /// specify both.</p>
    pub target: std::option::Option<std::string::String>,
    /// <p>To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled,
    /// enable encryption using this parameter. Copies of encrypted snapshots are encrypted,
    /// even if this parameter is false or if encryption by default is not enabled.</p>
    pub encrypted: std::option::Option<bool>,
    /// <p>The Amazon Resource Name (ARN) of the KMS key to use for EBS encryption. If this
    /// parameter is not specified, the default KMS key for the account is used.</p>
    pub cmk_arn: std::option::Option<std::string::String>,
    /// <p>Indicates whether to copy all user-defined tags from the source snapshot to the cross-Region
    /// snapshot copy.</p>
    pub copy_tags: std::option::Option<bool>,
    /// <p>The retention rule that indicates how long snapshot copies are to be retained in the
    /// destination Region.</p>
    pub retain_rule: std::option::Option<crate::model::CrossRegionCopyRetainRule>,
    /// <p>The AMI deprecation rule for cross-Region AMI copies created by the rule.</p>
    pub deprecate_rule: std::option::Option<crate::model::CrossRegionCopyDeprecateRule>,
}
impl std::fmt::Debug for CrossRegionCopyRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CrossRegionCopyRule");
        formatter.field("target_region", &self.target_region);
        formatter.field("target", &self.target);
        formatter.field("encrypted", &self.encrypted);
        formatter.field("cmk_arn", &self.cmk_arn);
        formatter.field("copy_tags", &self.copy_tags);
        formatter.field("retain_rule", &self.retain_rule);
        formatter.field("deprecate_rule", &self.deprecate_rule);
        formatter.finish()
    }
}
/// See [`CrossRegionCopyRule`](crate::model::CrossRegionCopyRule)
pub mod cross_region_copy_rule {
    /// A builder for [`CrossRegionCopyRule`](crate::model::CrossRegionCopyRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_region: std::option::Option<std::string::String>,
        pub(crate) target: std::option::Option<std::string::String>,
        pub(crate) encrypted: std::option::Option<bool>,
        pub(crate) cmk_arn: std::option::Option<std::string::String>,
        pub(crate) copy_tags: std::option::Option<bool>,
        pub(crate) retain_rule: std::option::Option<crate::model::CrossRegionCopyRetainRule>,
        pub(crate) deprecate_rule: std::option::Option<crate::model::CrossRegionCopyDeprecateRule>,
    }
    impl Builder {
        /// <p>Avoid using this parameter when creating new policies. Instead, use <b>Target</b>
        /// to specify a target Region or a target Outpost for snapshot copies.</p>
        /// <p>For policies created before the <b>Target</b> parameter
        /// was introduced, this parameter indicates the target Region for snapshot copies.</p>
        pub fn target_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_region = Some(input.into());
            self
        }
        /// <p>Avoid using this parameter when creating new policies. Instead, use <b>Target</b>
        /// to specify a target Region or a target Outpost for snapshot copies.</p>
        /// <p>For policies created before the <b>Target</b> parameter
        /// was introduced, this parameter indicates the target Region for snapshot copies.</p>
        pub fn set_target_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_region = input;
            self
        }
        /// <p>The target Region or the Amazon Resource Name (ARN) of the target Outpost for the
        /// snapshot copies.</p>
        /// <p>Use this parameter instead of <b>TargetRegion</b>. Do not
        /// specify both.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.target = Some(input.into());
            self
        }
        /// <p>The target Region or the Amazon Resource Name (ARN) of the target Outpost for the
        /// snapshot copies.</p>
        /// <p>Use this parameter instead of <b>TargetRegion</b>. Do not
        /// specify both.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target = input;
            self
        }
        /// <p>To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled,
        /// enable encryption using this parameter. Copies of encrypted snapshots are encrypted,
        /// even if this parameter is false or if encryption by default is not enabled.</p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.encrypted = Some(input);
            self
        }
        /// <p>To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled,
        /// enable encryption using this parameter. Copies of encrypted snapshots are encrypted,
        /// even if this parameter is false or if encryption by default is not enabled.</p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.encrypted = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the KMS key to use for EBS encryption. If this
        /// parameter is not specified, the default KMS key for the account is used.</p>
        pub fn cmk_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cmk_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the KMS key to use for EBS encryption. If this
        /// parameter is not specified, the default KMS key for the account is used.</p>
        pub fn set_cmk_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cmk_arn = input;
            self
        }
        /// <p>Indicates whether to copy all user-defined tags from the source snapshot to the cross-Region
        /// snapshot copy.</p>
        pub fn copy_tags(mut self, input: bool) -> Self {
            self.copy_tags = Some(input);
            self
        }
        /// <p>Indicates whether to copy all user-defined tags from the source snapshot to the cross-Region
        /// snapshot copy.</p>
        pub fn set_copy_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_tags = input;
            self
        }
        /// <p>The retention rule that indicates how long snapshot copies are to be retained in the
        /// destination Region.</p>
        pub fn retain_rule(mut self, input: crate::model::CrossRegionCopyRetainRule) -> Self {
            self.retain_rule = Some(input);
            self
        }
        /// <p>The retention rule that indicates how long snapshot copies are to be retained in the
        /// destination Region.</p>
        pub fn set_retain_rule(
            mut self,
            input: std::option::Option<crate::model::CrossRegionCopyRetainRule>,
        ) -> Self {
            self.retain_rule = input;
            self
        }
        /// <p>The AMI deprecation rule for cross-Region AMI copies created by the rule.</p>
        pub fn deprecate_rule(mut self, input: crate::model::CrossRegionCopyDeprecateRule) -> Self {
            self.deprecate_rule = Some(input);
            self
        }
        /// <p>The AMI deprecation rule for cross-Region AMI copies created by the rule.</p>
        pub fn set_deprecate_rule(
            mut self,
            input: std::option::Option<crate::model::CrossRegionCopyDeprecateRule>,
        ) -> Self {
            self.deprecate_rule = input;
            self
        }
        /// Consumes the builder and constructs a [`CrossRegionCopyRule`](crate::model::CrossRegionCopyRule)
        pub fn build(self) -> crate::model::CrossRegionCopyRule {
            crate::model::CrossRegionCopyRule {
                target_region: self.target_region,
                target: self.target,
                encrypted: self.encrypted,
                cmk_arn: self.cmk_arn,
                copy_tags: self.copy_tags,
                retain_rule: self.retain_rule,
                deprecate_rule: self.deprecate_rule,
            }
        }
    }
}
impl CrossRegionCopyRule {
    /// Creates a new builder-style object to manufacture [`CrossRegionCopyRule`](crate::model::CrossRegionCopyRule)
    pub fn builder() -> crate::model::cross_region_copy_rule::Builder {
        crate::model::cross_region_copy_rule::Builder::default()
    }
}

/// <p>Specifies an AMI deprecation rule for cross-Region AMI copies created by a cross-Region copy rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CrossRegionCopyDeprecateRule {
    /// <p>The period after which to deprecate the cross-Region AMI copies. The period must be less than or
    /// equal to the cross-Region AMI copy retention period, and it can't be greater than 10 years. This is
    /// equivalent to 120 months, 520 weeks, or 3650 days.</p>
    pub interval: i32,
    /// <p>The unit of time in which to measure the <b>Interval</b>.</p>
    pub interval_unit: std::option::Option<crate::model::RetentionIntervalUnitValues>,
}
impl std::fmt::Debug for CrossRegionCopyDeprecateRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CrossRegionCopyDeprecateRule");
        formatter.field("interval", &self.interval);
        formatter.field("interval_unit", &self.interval_unit);
        formatter.finish()
    }
}
/// See [`CrossRegionCopyDeprecateRule`](crate::model::CrossRegionCopyDeprecateRule)
pub mod cross_region_copy_deprecate_rule {
    /// A builder for [`CrossRegionCopyDeprecateRule`](crate::model::CrossRegionCopyDeprecateRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) interval: std::option::Option<i32>,
        pub(crate) interval_unit: std::option::Option<crate::model::RetentionIntervalUnitValues>,
    }
    impl Builder {
        /// <p>The period after which to deprecate the cross-Region AMI copies. The period must be less than or
        /// equal to the cross-Region AMI copy retention period, and it can't be greater than 10 years. This is
        /// equivalent to 120 months, 520 weeks, or 3650 days.</p>
        pub fn interval(mut self, input: i32) -> Self {
            self.interval = Some(input);
            self
        }
        /// <p>The period after which to deprecate the cross-Region AMI copies. The period must be less than or
        /// equal to the cross-Region AMI copy retention period, and it can't be greater than 10 years. This is
        /// equivalent to 120 months, 520 weeks, or 3650 days.</p>
        pub fn set_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.interval = input;
            self
        }
        /// <p>The unit of time in which to measure the <b>Interval</b>.</p>
        pub fn interval_unit(mut self, input: crate::model::RetentionIntervalUnitValues) -> Self {
            self.interval_unit = Some(input);
            self
        }
        /// <p>The unit of time in which to measure the <b>Interval</b>.</p>
        pub fn set_interval_unit(
            mut self,
            input: std::option::Option<crate::model::RetentionIntervalUnitValues>,
        ) -> Self {
            self.interval_unit = input;
            self
        }
        /// Consumes the builder and constructs a [`CrossRegionCopyDeprecateRule`](crate::model::CrossRegionCopyDeprecateRule)
        pub fn build(self) -> crate::model::CrossRegionCopyDeprecateRule {
            crate::model::CrossRegionCopyDeprecateRule {
                interval: self.interval.unwrap_or_default(),
                interval_unit: self.interval_unit,
            }
        }
    }
}
impl CrossRegionCopyDeprecateRule {
    /// Creates a new builder-style object to manufacture [`CrossRegionCopyDeprecateRule`](crate::model::CrossRegionCopyDeprecateRule)
    pub fn builder() -> crate::model::cross_region_copy_deprecate_rule::Builder {
        crate::model::cross_region_copy_deprecate_rule::Builder::default()
    }
}

/// <p>Specifies a rule for enabling fast snapshot restore. You can enable fast snapshot
/// restore based on either a count or a time interval.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FastRestoreRule {
    /// <p>The number of snapshots to be enabled with fast snapshot restore.</p>
    pub count: i32,
    /// <p>The amount of time to enable fast snapshot restore. The maximum is 100 years. This is
    /// equivalent to 1200 months, 5200 weeks, or 36500 days.</p>
    pub interval: i32,
    /// <p>The unit of time for enabling fast snapshot restore.</p>
    pub interval_unit: std::option::Option<crate::model::RetentionIntervalUnitValues>,
    /// <p>The Availability Zones in which to enable fast snapshot restore.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for FastRestoreRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FastRestoreRule");
        formatter.field("count", &self.count);
        formatter.field("interval", &self.interval);
        formatter.field("interval_unit", &self.interval_unit);
        formatter.field("availability_zones", &self.availability_zones);
        formatter.finish()
    }
}
/// See [`FastRestoreRule`](crate::model::FastRestoreRule)
pub mod fast_restore_rule {
    /// A builder for [`FastRestoreRule`](crate::model::FastRestoreRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) count: std::option::Option<i32>,
        pub(crate) interval: std::option::Option<i32>,
        pub(crate) interval_unit: std::option::Option<crate::model::RetentionIntervalUnitValues>,
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The number of snapshots to be enabled with fast snapshot restore.</p>
        pub fn count(mut self, input: i32) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>The number of snapshots to be enabled with fast snapshot restore.</p>
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.count = input;
            self
        }
        /// <p>The amount of time to enable fast snapshot restore. The maximum is 100 years. This is
        /// equivalent to 1200 months, 5200 weeks, or 36500 days.</p>
        pub fn interval(mut self, input: i32) -> Self {
            self.interval = Some(input);
            self
        }
        /// <p>The amount of time to enable fast snapshot restore. The maximum is 100 years. This is
        /// equivalent to 1200 months, 5200 weeks, or 36500 days.</p>
        pub fn set_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.interval = input;
            self
        }
        /// <p>The unit of time for enabling fast snapshot restore.</p>
        pub fn interval_unit(mut self, input: crate::model::RetentionIntervalUnitValues) -> Self {
            self.interval_unit = Some(input);
            self
        }
        /// <p>The unit of time for enabling fast snapshot restore.</p>
        pub fn set_interval_unit(
            mut self,
            input: std::option::Option<crate::model::RetentionIntervalUnitValues>,
        ) -> Self {
            self.interval_unit = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>The Availability Zones in which to enable fast snapshot restore.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>The Availability Zones in which to enable fast snapshot restore.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// Consumes the builder and constructs a [`FastRestoreRule`](crate::model::FastRestoreRule)
        pub fn build(self) -> crate::model::FastRestoreRule {
            crate::model::FastRestoreRule {
                count: self.count.unwrap_or_default(),
                interval: self.interval.unwrap_or_default(),
                interval_unit: self.interval_unit,
                availability_zones: self.availability_zones,
            }
        }
    }
}
impl FastRestoreRule {
    /// Creates a new builder-style object to manufacture [`FastRestoreRule`](crate::model::FastRestoreRule)
    pub fn builder() -> crate::model::fast_restore_rule::Builder {
        crate::model::fast_restore_rule::Builder::default()
    }
}

/// <p>Specifies the retention rule for a lifecycle policy. You can retain snapshots based on
/// either a count or a time interval.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RetainRule {
    /// <p>The number of snapshots to retain for each volume, up to a maximum of 1000.</p>
    pub count: i32,
    /// <p>The amount of time to retain each snapshot. The maximum is 100 years. This is
    /// equivalent to 1200 months, 5200 weeks, or 36500 days.</p>
    pub interval: i32,
    /// <p>The unit of time for time-based retention.</p>
    pub interval_unit: std::option::Option<crate::model::RetentionIntervalUnitValues>,
}
impl std::fmt::Debug for RetainRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RetainRule");
        formatter.field("count", &self.count);
        formatter.field("interval", &self.interval);
        formatter.field("interval_unit", &self.interval_unit);
        formatter.finish()
    }
}
/// See [`RetainRule`](crate::model::RetainRule)
pub mod retain_rule {
    /// A builder for [`RetainRule`](crate::model::RetainRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) count: std::option::Option<i32>,
        pub(crate) interval: std::option::Option<i32>,
        pub(crate) interval_unit: std::option::Option<crate::model::RetentionIntervalUnitValues>,
    }
    impl Builder {
        /// <p>The number of snapshots to retain for each volume, up to a maximum of 1000.</p>
        pub fn count(mut self, input: i32) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>The number of snapshots to retain for each volume, up to a maximum of 1000.</p>
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.count = input;
            self
        }
        /// <p>The amount of time to retain each snapshot. The maximum is 100 years. This is
        /// equivalent to 1200 months, 5200 weeks, or 36500 days.</p>
        pub fn interval(mut self, input: i32) -> Self {
            self.interval = Some(input);
            self
        }
        /// <p>The amount of time to retain each snapshot. The maximum is 100 years. This is
        /// equivalent to 1200 months, 5200 weeks, or 36500 days.</p>
        pub fn set_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.interval = input;
            self
        }
        /// <p>The unit of time for time-based retention.</p>
        pub fn interval_unit(mut self, input: crate::model::RetentionIntervalUnitValues) -> Self {
            self.interval_unit = Some(input);
            self
        }
        /// <p>The unit of time for time-based retention.</p>
        pub fn set_interval_unit(
            mut self,
            input: std::option::Option<crate::model::RetentionIntervalUnitValues>,
        ) -> Self {
            self.interval_unit = input;
            self
        }
        /// Consumes the builder and constructs a [`RetainRule`](crate::model::RetainRule)
        pub fn build(self) -> crate::model::RetainRule {
            crate::model::RetainRule {
                count: self.count.unwrap_or_default(),
                interval: self.interval.unwrap_or_default(),
                interval_unit: self.interval_unit,
            }
        }
    }
}
impl RetainRule {
    /// Creates a new builder-style object to manufacture [`RetainRule`](crate::model::RetainRule)
    pub fn builder() -> crate::model::retain_rule::Builder {
        crate::model::retain_rule::Builder::default()
    }
}

/// <p>Specifies when to create snapshots of EBS volumes.</p>
/// <p>You must specify either a Cron expression or an interval, interval unit, and start
/// time. You cannot specify both.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRule {
    /// <p>Specifies the destination for snapshots created by the policy. To create snapshots in the same
    /// Region as the source resource, specify <code>CLOUD</code>. To create snapshots on the same
    /// Outpost as the source resource, specify <code>OUTPOST_LOCAL</code>. If you omit this
    /// parameter, <code>CLOUD</code> is used by default.</p>
    /// <p>If the policy targets resources in an Amazon Web Services Region, then you must create snapshots in the same
    /// Region as the source resource.</p>
    /// <p>If the policy targets resources on an Outpost, then you can create snapshots on the same Outpost
    /// as the source resource, or in the Region of that Outpost.</p>
    pub location: std::option::Option<crate::model::LocationValues>,
    /// <p>The interval between snapshots. The supported values are 1, 2, 3, 4, 6, 8, 12, and
    /// 24.</p>
    pub interval: i32,
    /// <p>The interval unit.</p>
    pub interval_unit: std::option::Option<crate::model::IntervalUnitValues>,
    /// <p>The time, in UTC, to start the operation. The supported format is hh:mm.</p>
    /// <p>The operation occurs within a one-hour window following the specified time. If you do
    /// not specify a time, Amazon DLM selects a time within the next 24 hours.</p>
    pub times: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The schedule, as a Cron expression. The schedule interval must be between 1 hour and 1
    /// year. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron
    /// expressions</a> in the <i>Amazon CloudWatch User Guide</i>.</p>
    pub cron_expression: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRule");
        formatter.field("location", &self.location);
        formatter.field("interval", &self.interval);
        formatter.field("interval_unit", &self.interval_unit);
        formatter.field("times", &self.times);
        formatter.field("cron_expression", &self.cron_expression);
        formatter.finish()
    }
}
/// See [`CreateRule`](crate::model::CreateRule)
pub mod create_rule {
    /// A builder for [`CreateRule`](crate::model::CreateRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location: std::option::Option<crate::model::LocationValues>,
        pub(crate) interval: std::option::Option<i32>,
        pub(crate) interval_unit: std::option::Option<crate::model::IntervalUnitValues>,
        pub(crate) times: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) cron_expression: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the destination for snapshots created by the policy. To create snapshots in the same
        /// Region as the source resource, specify <code>CLOUD</code>. To create snapshots on the same
        /// Outpost as the source resource, specify <code>OUTPOST_LOCAL</code>. If you omit this
        /// parameter, <code>CLOUD</code> is used by default.</p>
        /// <p>If the policy targets resources in an Amazon Web Services Region, then you must create snapshots in the same
        /// Region as the source resource.</p>
        /// <p>If the policy targets resources on an Outpost, then you can create snapshots on the same Outpost
        /// as the source resource, or in the Region of that Outpost.</p>
        pub fn location(mut self, input: crate::model::LocationValues) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>Specifies the destination for snapshots created by the policy. To create snapshots in the same
        /// Region as the source resource, specify <code>CLOUD</code>. To create snapshots on the same
        /// Outpost as the source resource, specify <code>OUTPOST_LOCAL</code>. If you omit this
        /// parameter, <code>CLOUD</code> is used by default.</p>
        /// <p>If the policy targets resources in an Amazon Web Services Region, then you must create snapshots in the same
        /// Region as the source resource.</p>
        /// <p>If the policy targets resources on an Outpost, then you can create snapshots on the same Outpost
        /// as the source resource, or in the Region of that Outpost.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::LocationValues>,
        ) -> Self {
            self.location = input;
            self
        }
        /// <p>The interval between snapshots. The supported values are 1, 2, 3, 4, 6, 8, 12, and
        /// 24.</p>
        pub fn interval(mut self, input: i32) -> Self {
            self.interval = Some(input);
            self
        }
        /// <p>The interval between snapshots. The supported values are 1, 2, 3, 4, 6, 8, 12, and
        /// 24.</p>
        pub fn set_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.interval = input;
            self
        }
        /// <p>The interval unit.</p>
        pub fn interval_unit(mut self, input: crate::model::IntervalUnitValues) -> Self {
            self.interval_unit = Some(input);
            self
        }
        /// <p>The interval unit.</p>
        pub fn set_interval_unit(
            mut self,
            input: std::option::Option<crate::model::IntervalUnitValues>,
        ) -> Self {
            self.interval_unit = input;
            self
        }
        /// Appends an item to `times`.
        ///
        /// To override the contents of this collection use [`set_times`](Self::set_times).
        ///
        /// <p>The time, in UTC, to start the operation. The supported format is hh:mm.</p>
        /// <p>The operation occurs within a one-hour window following the specified time. If you do
        /// not specify a time, Amazon DLM selects a time within the next 24 hours.</p>
        pub fn times(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.times.unwrap_or_default();
            v.push(input.into());
            self.times = Some(v);
            self
        }
        /// <p>The time, in UTC, to start the operation. The supported format is hh:mm.</p>
        /// <p>The operation occurs within a one-hour window following the specified time. If you do
        /// not specify a time, Amazon DLM selects a time within the next 24 hours.</p>
        pub fn set_times(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.times = input;
            self
        }
        /// <p>The schedule, as a Cron expression. The schedule interval must be between 1 hour and 1
        /// year. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron
        /// expressions</a> in the <i>Amazon CloudWatch User Guide</i>.</p>
        pub fn cron_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.cron_expression = Some(input.into());
            self
        }
        /// <p>The schedule, as a Cron expression. The schedule interval must be between 1 hour and 1
        /// year. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron
        /// expressions</a> in the <i>Amazon CloudWatch User Guide</i>.</p>
        pub fn set_cron_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cron_expression = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRule`](crate::model::CreateRule)
        pub fn build(self) -> crate::model::CreateRule {
            crate::model::CreateRule {
                location: self.location,
                interval: self.interval.unwrap_or_default(),
                interval_unit: self.interval_unit,
                times: self.times,
                cron_expression: self.cron_expression,
            }
        }
    }
}
impl CreateRule {
    /// Creates a new builder-style object to manufacture [`CreateRule`](crate::model::CreateRule)
    pub fn builder() -> crate::model::create_rule::Builder {
        crate::model::create_rule::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IntervalUnitValues {
    #[allow(missing_docs)] // documentation missing in model
    Hours,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IntervalUnitValues {
    fn from(s: &str) -> Self {
        match s {
            "HOURS" => IntervalUnitValues::Hours,
            other => IntervalUnitValues::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IntervalUnitValues {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IntervalUnitValues::from(s))
    }
}
impl IntervalUnitValues {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IntervalUnitValues::Hours => "HOURS",
            IntervalUnitValues::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HOURS"]
    }
}
impl AsRef<str> for IntervalUnitValues {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LocationValues {
    #[allow(missing_docs)] // documentation missing in model
    Cloud,
    #[allow(missing_docs)] // documentation missing in model
    OutpostLocal,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LocationValues {
    fn from(s: &str) -> Self {
        match s {
            "CLOUD" => LocationValues::Cloud,
            "OUTPOST_LOCAL" => LocationValues::OutpostLocal,
            other => LocationValues::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LocationValues {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LocationValues::from(s))
    }
}
impl LocationValues {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LocationValues::Cloud => "CLOUD",
            LocationValues::OutpostLocal => "OUTPOST_LOCAL",
            LocationValues::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CLOUD", "OUTPOST_LOCAL"]
    }
}
impl AsRef<str> for LocationValues {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies a tag for a resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The tag key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The tag value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The tag key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The tag key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The tag value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The tag value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceLocationValues {
    #[allow(missing_docs)] // documentation missing in model
    Cloud,
    #[allow(missing_docs)] // documentation missing in model
    Outpost,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceLocationValues {
    fn from(s: &str) -> Self {
        match s {
            "CLOUD" => ResourceLocationValues::Cloud,
            "OUTPOST" => ResourceLocationValues::Outpost,
            other => ResourceLocationValues::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceLocationValues {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceLocationValues::from(s))
    }
}
impl ResourceLocationValues {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceLocationValues::Cloud => "CLOUD",
            ResourceLocationValues::Outpost => "OUTPOST",
            ResourceLocationValues::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CLOUD", "OUTPOST"]
    }
}
impl AsRef<str> for ResourceLocationValues {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceTypeValues {
    #[allow(missing_docs)] // documentation missing in model
    Instance,
    #[allow(missing_docs)] // documentation missing in model
    Volume,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceTypeValues {
    fn from(s: &str) -> Self {
        match s {
            "INSTANCE" => ResourceTypeValues::Instance,
            "VOLUME" => ResourceTypeValues::Volume,
            other => ResourceTypeValues::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceTypeValues {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceTypeValues::from(s))
    }
}
impl ResourceTypeValues {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceTypeValues::Instance => "INSTANCE",
            ResourceTypeValues::Volume => "VOLUME",
            ResourceTypeValues::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INSTANCE", "VOLUME"]
    }
}
impl AsRef<str> for ResourceTypeValues {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PolicyTypeValues {
    #[allow(missing_docs)] // documentation missing in model
    EbsSnapshotManagement,
    #[allow(missing_docs)] // documentation missing in model
    EventBasedPolicy,
    #[allow(missing_docs)] // documentation missing in model
    ImageManagement,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PolicyTypeValues {
    fn from(s: &str) -> Self {
        match s {
            "EBS_SNAPSHOT_MANAGEMENT" => PolicyTypeValues::EbsSnapshotManagement,
            "EVENT_BASED_POLICY" => PolicyTypeValues::EventBasedPolicy,
            "IMAGE_MANAGEMENT" => PolicyTypeValues::ImageManagement,
            other => PolicyTypeValues::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PolicyTypeValues {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PolicyTypeValues::from(s))
    }
}
impl PolicyTypeValues {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PolicyTypeValues::EbsSnapshotManagement => "EBS_SNAPSHOT_MANAGEMENT",
            PolicyTypeValues::EventBasedPolicy => "EVENT_BASED_POLICY",
            PolicyTypeValues::ImageManagement => "IMAGE_MANAGEMENT",
            PolicyTypeValues::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "EBS_SNAPSHOT_MANAGEMENT",
            "EVENT_BASED_POLICY",
            "IMAGE_MANAGEMENT",
        ]
    }
}
impl AsRef<str> for PolicyTypeValues {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SettablePolicyStateValues {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SettablePolicyStateValues {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => SettablePolicyStateValues::Disabled,
            "ENABLED" => SettablePolicyStateValues::Enabled,
            other => SettablePolicyStateValues::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SettablePolicyStateValues {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SettablePolicyStateValues::from(s))
    }
}
impl SettablePolicyStateValues {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SettablePolicyStateValues::Disabled => "DISABLED",
            SettablePolicyStateValues::Enabled => "ENABLED",
            SettablePolicyStateValues::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for SettablePolicyStateValues {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Detailed information about a lifecycle policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LifecyclePolicy {
    /// <p>The identifier of the lifecycle policy.</p>
    pub policy_id: std::option::Option<std::string::String>,
    /// <p>The description of the lifecycle policy.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The activation state of the lifecycle policy.</p>
    pub state: std::option::Option<crate::model::GettablePolicyStateValues>,
    /// <p>The description of the status.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by
    /// the lifecycle policy.</p>
    pub execution_role_arn: std::option::Option<std::string::String>,
    /// <p>The local date and time when the lifecycle policy was created.</p>
    pub date_created: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The local date and time when the lifecycle policy was last modified.</p>
    pub date_modified: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The configuration of the lifecycle policy</p>
    pub policy_details: std::option::Option<crate::model::PolicyDetails>,
    /// <p>The tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) of the policy.</p>
    pub policy_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LifecyclePolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LifecyclePolicy");
        formatter.field("policy_id", &self.policy_id);
        formatter.field("description", &self.description);
        formatter.field("state", &self.state);
        formatter.field("status_message", &self.status_message);
        formatter.field("execution_role_arn", &self.execution_role_arn);
        formatter.field("date_created", &self.date_created);
        formatter.field("date_modified", &self.date_modified);
        formatter.field("policy_details", &self.policy_details);
        formatter.field("tags", &self.tags);
        formatter.field("policy_arn", &self.policy_arn);
        formatter.finish()
    }
}
/// See [`LifecyclePolicy`](crate::model::LifecyclePolicy)
pub mod lifecycle_policy {
    /// A builder for [`LifecyclePolicy`](crate::model::LifecyclePolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::GettablePolicyStateValues>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) execution_role_arn: std::option::Option<std::string::String>,
        pub(crate) date_created: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) date_modified: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) policy_details: std::option::Option<crate::model::PolicyDetails>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) policy_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the lifecycle policy.</p>
        pub fn policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_id = Some(input.into());
            self
        }
        /// <p>The identifier of the lifecycle policy.</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_id = input;
            self
        }
        /// <p>The description of the lifecycle policy.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the lifecycle policy.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The activation state of the lifecycle policy.</p>
        pub fn state(mut self, input: crate::model::GettablePolicyStateValues) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The activation state of the lifecycle policy.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::GettablePolicyStateValues>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The description of the status.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>The description of the status.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by
        /// the lifecycle policy.</p>
        pub fn execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by
        /// the lifecycle policy.</p>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_role_arn = input;
            self
        }
        /// <p>The local date and time when the lifecycle policy was created.</p>
        pub fn date_created(mut self, input: aws_smithy_types::Instant) -> Self {
            self.date_created = Some(input);
            self
        }
        /// <p>The local date and time when the lifecycle policy was created.</p>
        pub fn set_date_created(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.date_created = input;
            self
        }
        /// <p>The local date and time when the lifecycle policy was last modified.</p>
        pub fn date_modified(mut self, input: aws_smithy_types::Instant) -> Self {
            self.date_modified = Some(input);
            self
        }
        /// <p>The local date and time when the lifecycle policy was last modified.</p>
        pub fn set_date_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.date_modified = input;
            self
        }
        /// <p>The configuration of the lifecycle policy</p>
        pub fn policy_details(mut self, input: crate::model::PolicyDetails) -> Self {
            self.policy_details = Some(input);
            self
        }
        /// <p>The configuration of the lifecycle policy</p>
        pub fn set_policy_details(
            mut self,
            input: std::option::Option<crate::model::PolicyDetails>,
        ) -> Self {
            self.policy_details = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the policy.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the policy.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`LifecyclePolicy`](crate::model::LifecyclePolicy)
        pub fn build(self) -> crate::model::LifecyclePolicy {
            crate::model::LifecyclePolicy {
                policy_id: self.policy_id,
                description: self.description,
                state: self.state,
                status_message: self.status_message,
                execution_role_arn: self.execution_role_arn,
                date_created: self.date_created,
                date_modified: self.date_modified,
                policy_details: self.policy_details,
                tags: self.tags,
                policy_arn: self.policy_arn,
            }
        }
    }
}
impl LifecyclePolicy {
    /// Creates a new builder-style object to manufacture [`LifecyclePolicy`](crate::model::LifecyclePolicy)
    pub fn builder() -> crate::model::lifecycle_policy::Builder {
        crate::model::lifecycle_policy::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GettablePolicyStateValues {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GettablePolicyStateValues {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => GettablePolicyStateValues::Disabled,
            "ENABLED" => GettablePolicyStateValues::Enabled,
            "ERROR" => GettablePolicyStateValues::Error,
            other => GettablePolicyStateValues::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GettablePolicyStateValues {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GettablePolicyStateValues::from(s))
    }
}
impl GettablePolicyStateValues {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GettablePolicyStateValues::Disabled => "DISABLED",
            GettablePolicyStateValues::Enabled => "ENABLED",
            GettablePolicyStateValues::Error => "ERROR",
            GettablePolicyStateValues::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED", "ERROR"]
    }
}
impl AsRef<str> for GettablePolicyStateValues {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary information about a lifecycle policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LifecyclePolicySummary {
    /// <p>The identifier of the lifecycle policy.</p>
    pub policy_id: std::option::Option<std::string::String>,
    /// <p>The description of the lifecycle policy.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The activation state of the lifecycle policy.</p>
    pub state: std::option::Option<crate::model::GettablePolicyStateValues>,
    /// <p>The tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The type of policy. <code>EBS_SNAPSHOT_MANAGEMENT</code> indicates that the policy
    /// manages the lifecycle of Amazon EBS snapshots. <code>IMAGE_MANAGEMENT</code>
    /// indicates that the policy manages the lifecycle of EBS-backed AMIs.</p>
    pub policy_type: std::option::Option<crate::model::PolicyTypeValues>,
}
impl std::fmt::Debug for LifecyclePolicySummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LifecyclePolicySummary");
        formatter.field("policy_id", &self.policy_id);
        formatter.field("description", &self.description);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.field("policy_type", &self.policy_type);
        formatter.finish()
    }
}
/// See [`LifecyclePolicySummary`](crate::model::LifecyclePolicySummary)
pub mod lifecycle_policy_summary {
    /// A builder for [`LifecyclePolicySummary`](crate::model::LifecyclePolicySummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::GettablePolicyStateValues>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) policy_type: std::option::Option<crate::model::PolicyTypeValues>,
    }
    impl Builder {
        /// <p>The identifier of the lifecycle policy.</p>
        pub fn policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_id = Some(input.into());
            self
        }
        /// <p>The identifier of the lifecycle policy.</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_id = input;
            self
        }
        /// <p>The description of the lifecycle policy.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the lifecycle policy.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The activation state of the lifecycle policy.</p>
        pub fn state(mut self, input: crate::model::GettablePolicyStateValues) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The activation state of the lifecycle policy.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::GettablePolicyStateValues>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The type of policy. <code>EBS_SNAPSHOT_MANAGEMENT</code> indicates that the policy
        /// manages the lifecycle of Amazon EBS snapshots. <code>IMAGE_MANAGEMENT</code>
        /// indicates that the policy manages the lifecycle of EBS-backed AMIs.</p>
        pub fn policy_type(mut self, input: crate::model::PolicyTypeValues) -> Self {
            self.policy_type = Some(input);
            self
        }
        /// <p>The type of policy. <code>EBS_SNAPSHOT_MANAGEMENT</code> indicates that the policy
        /// manages the lifecycle of Amazon EBS snapshots. <code>IMAGE_MANAGEMENT</code>
        /// indicates that the policy manages the lifecycle of EBS-backed AMIs.</p>
        pub fn set_policy_type(
            mut self,
            input: std::option::Option<crate::model::PolicyTypeValues>,
        ) -> Self {
            self.policy_type = input;
            self
        }
        /// Consumes the builder and constructs a [`LifecyclePolicySummary`](crate::model::LifecyclePolicySummary)
        pub fn build(self) -> crate::model::LifecyclePolicySummary {
            crate::model::LifecyclePolicySummary {
                policy_id: self.policy_id,
                description: self.description,
                state: self.state,
                tags: self.tags,
                policy_type: self.policy_type,
            }
        }
    }
}
impl LifecyclePolicySummary {
    /// Creates a new builder-style object to manufacture [`LifecyclePolicySummary`](crate::model::LifecyclePolicySummary)
    pub fn builder() -> crate::model::lifecycle_policy_summary::Builder {
        crate::model::lifecycle_policy_summary::Builder::default()
    }
}
