// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AcceptSharedDirectory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`accept_shared_directory`](crate::client::Client::accept_shared_directory).
///
/// See [`crate::client::fluent_builders::AcceptSharedDirectory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AcceptSharedDirectory {
    _private: (),
}
impl AcceptSharedDirectory {
    /// Creates a new builder-style object to manufacture [`AcceptSharedDirectoryInput`](crate::input::AcceptSharedDirectoryInput)
    pub fn builder() -> crate::input::accept_shared_directory_input::Builder {
        crate::input::accept_shared_directory_input::Builder::default()
    }
    /// Creates a new `AcceptSharedDirectory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AcceptSharedDirectory {
    type Output = std::result::Result<
        crate::output::AcceptSharedDirectoryOutput,
        crate::error::AcceptSharedDirectoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_accept_shared_directory_error(response)
        } else {
            crate::operation_deser::parse_accept_shared_directory_response(response)
        }
    }
}

/// Operation shape for `AddIpRoutes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_ip_routes`](crate::client::Client::add_ip_routes).
///
/// See [`crate::client::fluent_builders::AddIpRoutes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddIpRoutes {
    _private: (),
}
impl AddIpRoutes {
    /// Creates a new builder-style object to manufacture [`AddIpRoutesInput`](crate::input::AddIpRoutesInput)
    pub fn builder() -> crate::input::add_ip_routes_input::Builder {
        crate::input::add_ip_routes_input::Builder::default()
    }
    /// Creates a new `AddIpRoutes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddIpRoutes {
    type Output =
        std::result::Result<crate::output::AddIpRoutesOutput, crate::error::AddIpRoutesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_ip_routes_error(response)
        } else {
            crate::operation_deser::parse_add_ip_routes_response(response)
        }
    }
}

/// Operation shape for `AddRegion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_region`](crate::client::Client::add_region).
///
/// See [`crate::client::fluent_builders::AddRegion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddRegion {
    _private: (),
}
impl AddRegion {
    /// Creates a new builder-style object to manufacture [`AddRegionInput`](crate::input::AddRegionInput)
    pub fn builder() -> crate::input::add_region_input::Builder {
        crate::input::add_region_input::Builder::default()
    }
    /// Creates a new `AddRegion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddRegion {
    type Output = std::result::Result<crate::output::AddRegionOutput, crate::error::AddRegionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_region_error(response)
        } else {
            crate::operation_deser::parse_add_region_response(response)
        }
    }
}

/// Operation shape for `AddTagsToResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_tags_to_resource`](crate::client::Client::add_tags_to_resource).
///
/// See [`crate::client::fluent_builders::AddTagsToResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddTagsToResource {
    _private: (),
}
impl AddTagsToResource {
    /// Creates a new builder-style object to manufacture [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
    pub fn builder() -> crate::input::add_tags_to_resource_input::Builder {
        crate::input::add_tags_to_resource_input::Builder::default()
    }
    /// Creates a new `AddTagsToResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddTagsToResource {
    type Output = std::result::Result<
        crate::output::AddTagsToResourceOutput,
        crate::error::AddTagsToResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_tags_to_resource_error(response)
        } else {
            crate::operation_deser::parse_add_tags_to_resource_response(response)
        }
    }
}

/// Operation shape for `CancelSchemaExtension`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_schema_extension`](crate::client::Client::cancel_schema_extension).
///
/// See [`crate::client::fluent_builders::CancelSchemaExtension`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelSchemaExtension {
    _private: (),
}
impl CancelSchemaExtension {
    /// Creates a new builder-style object to manufacture [`CancelSchemaExtensionInput`](crate::input::CancelSchemaExtensionInput)
    pub fn builder() -> crate::input::cancel_schema_extension_input::Builder {
        crate::input::cancel_schema_extension_input::Builder::default()
    }
    /// Creates a new `CancelSchemaExtension` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelSchemaExtension {
    type Output = std::result::Result<
        crate::output::CancelSchemaExtensionOutput,
        crate::error::CancelSchemaExtensionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_schema_extension_error(response)
        } else {
            crate::operation_deser::parse_cancel_schema_extension_response(response)
        }
    }
}

/// Operation shape for `ConnectDirectory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`connect_directory`](crate::client::Client::connect_directory).
///
/// See [`crate::client::fluent_builders::ConnectDirectory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ConnectDirectory {
    _private: (),
}
impl ConnectDirectory {
    /// Creates a new builder-style object to manufacture [`ConnectDirectoryInput`](crate::input::ConnectDirectoryInput)
    pub fn builder() -> crate::input::connect_directory_input::Builder {
        crate::input::connect_directory_input::Builder::default()
    }
    /// Creates a new `ConnectDirectory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ConnectDirectory {
    type Output = std::result::Result<
        crate::output::ConnectDirectoryOutput,
        crate::error::ConnectDirectoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_connect_directory_error(response)
        } else {
            crate::operation_deser::parse_connect_directory_response(response)
        }
    }
}

/// Operation shape for `CreateAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_alias`](crate::client::Client::create_alias).
///
/// See [`crate::client::fluent_builders::CreateAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAlias {
    _private: (),
}
impl CreateAlias {
    /// Creates a new builder-style object to manufacture [`CreateAliasInput`](crate::input::CreateAliasInput)
    pub fn builder() -> crate::input::create_alias_input::Builder {
        crate::input::create_alias_input::Builder::default()
    }
    /// Creates a new `CreateAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAlias {
    type Output =
        std::result::Result<crate::output::CreateAliasOutput, crate::error::CreateAliasError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_alias_error(response)
        } else {
            crate::operation_deser::parse_create_alias_response(response)
        }
    }
}

/// Operation shape for `CreateComputer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_computer`](crate::client::Client::create_computer).
///
/// See [`crate::client::fluent_builders::CreateComputer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateComputer {
    _private: (),
}
impl CreateComputer {
    /// Creates a new builder-style object to manufacture [`CreateComputerInput`](crate::input::CreateComputerInput)
    pub fn builder() -> crate::input::create_computer_input::Builder {
        crate::input::create_computer_input::Builder::default()
    }
    /// Creates a new `CreateComputer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateComputer {
    type Output =
        std::result::Result<crate::output::CreateComputerOutput, crate::error::CreateComputerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_computer_error(response)
        } else {
            crate::operation_deser::parse_create_computer_response(response)
        }
    }
}

/// Operation shape for `CreateConditionalForwarder`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_conditional_forwarder`](crate::client::Client::create_conditional_forwarder).
///
/// See [`crate::client::fluent_builders::CreateConditionalForwarder`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateConditionalForwarder {
    _private: (),
}
impl CreateConditionalForwarder {
    /// Creates a new builder-style object to manufacture [`CreateConditionalForwarderInput`](crate::input::CreateConditionalForwarderInput)
    pub fn builder() -> crate::input::create_conditional_forwarder_input::Builder {
        crate::input::create_conditional_forwarder_input::Builder::default()
    }
    /// Creates a new `CreateConditionalForwarder` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateConditionalForwarder {
    type Output = std::result::Result<
        crate::output::CreateConditionalForwarderOutput,
        crate::error::CreateConditionalForwarderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_conditional_forwarder_error(response)
        } else {
            crate::operation_deser::parse_create_conditional_forwarder_response(response)
        }
    }
}

/// Operation shape for `CreateDirectory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_directory`](crate::client::Client::create_directory).
///
/// See [`crate::client::fluent_builders::CreateDirectory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDirectory {
    _private: (),
}
impl CreateDirectory {
    /// Creates a new builder-style object to manufacture [`CreateDirectoryInput`](crate::input::CreateDirectoryInput)
    pub fn builder() -> crate::input::create_directory_input::Builder {
        crate::input::create_directory_input::Builder::default()
    }
    /// Creates a new `CreateDirectory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDirectory {
    type Output = std::result::Result<
        crate::output::CreateDirectoryOutput,
        crate::error::CreateDirectoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_directory_error(response)
        } else {
            crate::operation_deser::parse_create_directory_response(response)
        }
    }
}

/// Operation shape for `CreateLogSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_log_subscription`](crate::client::Client::create_log_subscription).
///
/// See [`crate::client::fluent_builders::CreateLogSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLogSubscription {
    _private: (),
}
impl CreateLogSubscription {
    /// Creates a new builder-style object to manufacture [`CreateLogSubscriptionInput`](crate::input::CreateLogSubscriptionInput)
    pub fn builder() -> crate::input::create_log_subscription_input::Builder {
        crate::input::create_log_subscription_input::Builder::default()
    }
    /// Creates a new `CreateLogSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLogSubscription {
    type Output = std::result::Result<
        crate::output::CreateLogSubscriptionOutput,
        crate::error::CreateLogSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_log_subscription_error(response)
        } else {
            crate::operation_deser::parse_create_log_subscription_response(response)
        }
    }
}

/// Operation shape for `CreateMicrosoftAD`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_microsoft_ad`](crate::client::Client::create_microsoft_ad).
///
/// See [`crate::client::fluent_builders::CreateMicrosoftAD`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateMicrosoftAD {
    _private: (),
}
impl CreateMicrosoftAD {
    /// Creates a new builder-style object to manufacture [`CreateMicrosoftAdInput`](crate::input::CreateMicrosoftAdInput)
    pub fn builder() -> crate::input::create_microsoft_ad_input::Builder {
        crate::input::create_microsoft_ad_input::Builder::default()
    }
    /// Creates a new `CreateMicrosoftAD` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateMicrosoftAD {
    type Output = std::result::Result<
        crate::output::CreateMicrosoftAdOutput,
        crate::error::CreateMicrosoftADError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_microsoft_ad_error(response)
        } else {
            crate::operation_deser::parse_create_microsoft_ad_response(response)
        }
    }
}

/// Operation shape for `CreateSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_snapshot`](crate::client::Client::create_snapshot).
///
/// See [`crate::client::fluent_builders::CreateSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSnapshot {
    _private: (),
}
impl CreateSnapshot {
    /// Creates a new builder-style object to manufacture [`CreateSnapshotInput`](crate::input::CreateSnapshotInput)
    pub fn builder() -> crate::input::create_snapshot_input::Builder {
        crate::input::create_snapshot_input::Builder::default()
    }
    /// Creates a new `CreateSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSnapshot {
    type Output =
        std::result::Result<crate::output::CreateSnapshotOutput, crate::error::CreateSnapshotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_snapshot_error(response)
        } else {
            crate::operation_deser::parse_create_snapshot_response(response)
        }
    }
}

/// Operation shape for `CreateTrust`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_trust`](crate::client::Client::create_trust).
///
/// See [`crate::client::fluent_builders::CreateTrust`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTrust {
    _private: (),
}
impl CreateTrust {
    /// Creates a new builder-style object to manufacture [`CreateTrustInput`](crate::input::CreateTrustInput)
    pub fn builder() -> crate::input::create_trust_input::Builder {
        crate::input::create_trust_input::Builder::default()
    }
    /// Creates a new `CreateTrust` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTrust {
    type Output =
        std::result::Result<crate::output::CreateTrustOutput, crate::error::CreateTrustError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_trust_error(response)
        } else {
            crate::operation_deser::parse_create_trust_response(response)
        }
    }
}

/// Operation shape for `DeleteConditionalForwarder`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_conditional_forwarder`](crate::client::Client::delete_conditional_forwarder).
///
/// See [`crate::client::fluent_builders::DeleteConditionalForwarder`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteConditionalForwarder {
    _private: (),
}
impl DeleteConditionalForwarder {
    /// Creates a new builder-style object to manufacture [`DeleteConditionalForwarderInput`](crate::input::DeleteConditionalForwarderInput)
    pub fn builder() -> crate::input::delete_conditional_forwarder_input::Builder {
        crate::input::delete_conditional_forwarder_input::Builder::default()
    }
    /// Creates a new `DeleteConditionalForwarder` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteConditionalForwarder {
    type Output = std::result::Result<
        crate::output::DeleteConditionalForwarderOutput,
        crate::error::DeleteConditionalForwarderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_conditional_forwarder_error(response)
        } else {
            crate::operation_deser::parse_delete_conditional_forwarder_response(response)
        }
    }
}

/// Operation shape for `DeleteDirectory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_directory`](crate::client::Client::delete_directory).
///
/// See [`crate::client::fluent_builders::DeleteDirectory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDirectory {
    _private: (),
}
impl DeleteDirectory {
    /// Creates a new builder-style object to manufacture [`DeleteDirectoryInput`](crate::input::DeleteDirectoryInput)
    pub fn builder() -> crate::input::delete_directory_input::Builder {
        crate::input::delete_directory_input::Builder::default()
    }
    /// Creates a new `DeleteDirectory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDirectory {
    type Output = std::result::Result<
        crate::output::DeleteDirectoryOutput,
        crate::error::DeleteDirectoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_directory_error(response)
        } else {
            crate::operation_deser::parse_delete_directory_response(response)
        }
    }
}

/// Operation shape for `DeleteLogSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_log_subscription`](crate::client::Client::delete_log_subscription).
///
/// See [`crate::client::fluent_builders::DeleteLogSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLogSubscription {
    _private: (),
}
impl DeleteLogSubscription {
    /// Creates a new builder-style object to manufacture [`DeleteLogSubscriptionInput`](crate::input::DeleteLogSubscriptionInput)
    pub fn builder() -> crate::input::delete_log_subscription_input::Builder {
        crate::input::delete_log_subscription_input::Builder::default()
    }
    /// Creates a new `DeleteLogSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLogSubscription {
    type Output = std::result::Result<
        crate::output::DeleteLogSubscriptionOutput,
        crate::error::DeleteLogSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_log_subscription_error(response)
        } else {
            crate::operation_deser::parse_delete_log_subscription_response(response)
        }
    }
}

/// Operation shape for `DeleteSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_snapshot`](crate::client::Client::delete_snapshot).
///
/// See [`crate::client::fluent_builders::DeleteSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSnapshot {
    _private: (),
}
impl DeleteSnapshot {
    /// Creates a new builder-style object to manufacture [`DeleteSnapshotInput`](crate::input::DeleteSnapshotInput)
    pub fn builder() -> crate::input::delete_snapshot_input::Builder {
        crate::input::delete_snapshot_input::Builder::default()
    }
    /// Creates a new `DeleteSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSnapshot {
    type Output =
        std::result::Result<crate::output::DeleteSnapshotOutput, crate::error::DeleteSnapshotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_snapshot_error(response)
        } else {
            crate::operation_deser::parse_delete_snapshot_response(response)
        }
    }
}

/// Operation shape for `DeleteTrust`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_trust`](crate::client::Client::delete_trust).
///
/// See [`crate::client::fluent_builders::DeleteTrust`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTrust {
    _private: (),
}
impl DeleteTrust {
    /// Creates a new builder-style object to manufacture [`DeleteTrustInput`](crate::input::DeleteTrustInput)
    pub fn builder() -> crate::input::delete_trust_input::Builder {
        crate::input::delete_trust_input::Builder::default()
    }
    /// Creates a new `DeleteTrust` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTrust {
    type Output =
        std::result::Result<crate::output::DeleteTrustOutput, crate::error::DeleteTrustError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_trust_error(response)
        } else {
            crate::operation_deser::parse_delete_trust_response(response)
        }
    }
}

/// Operation shape for `DeregisterCertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_certificate`](crate::client::Client::deregister_certificate).
///
/// See [`crate::client::fluent_builders::DeregisterCertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterCertificate {
    _private: (),
}
impl DeregisterCertificate {
    /// Creates a new builder-style object to manufacture [`DeregisterCertificateInput`](crate::input::DeregisterCertificateInput)
    pub fn builder() -> crate::input::deregister_certificate_input::Builder {
        crate::input::deregister_certificate_input::Builder::default()
    }
    /// Creates a new `DeregisterCertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterCertificate {
    type Output = std::result::Result<
        crate::output::DeregisterCertificateOutput,
        crate::error::DeregisterCertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_certificate_error(response)
        } else {
            crate::operation_deser::parse_deregister_certificate_response(response)
        }
    }
}

/// Operation shape for `DeregisterEventTopic`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_event_topic`](crate::client::Client::deregister_event_topic).
///
/// See [`crate::client::fluent_builders::DeregisterEventTopic`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterEventTopic {
    _private: (),
}
impl DeregisterEventTopic {
    /// Creates a new builder-style object to manufacture [`DeregisterEventTopicInput`](crate::input::DeregisterEventTopicInput)
    pub fn builder() -> crate::input::deregister_event_topic_input::Builder {
        crate::input::deregister_event_topic_input::Builder::default()
    }
    /// Creates a new `DeregisterEventTopic` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterEventTopic {
    type Output = std::result::Result<
        crate::output::DeregisterEventTopicOutput,
        crate::error::DeregisterEventTopicError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_event_topic_error(response)
        } else {
            crate::operation_deser::parse_deregister_event_topic_response(response)
        }
    }
}

/// Operation shape for `DescribeCertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_certificate`](crate::client::Client::describe_certificate).
///
/// See [`crate::client::fluent_builders::DescribeCertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCertificate {
    _private: (),
}
impl DescribeCertificate {
    /// Creates a new builder-style object to manufacture [`DescribeCertificateInput`](crate::input::DescribeCertificateInput)
    pub fn builder() -> crate::input::describe_certificate_input::Builder {
        crate::input::describe_certificate_input::Builder::default()
    }
    /// Creates a new `DescribeCertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCertificate {
    type Output = std::result::Result<
        crate::output::DescribeCertificateOutput,
        crate::error::DescribeCertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_certificate_error(response)
        } else {
            crate::operation_deser::parse_describe_certificate_response(response)
        }
    }
}

/// Operation shape for `DescribeClientAuthenticationSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_client_authentication_settings`](crate::client::Client::describe_client_authentication_settings).
///
/// See [`crate::client::fluent_builders::DescribeClientAuthenticationSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeClientAuthenticationSettings {
    _private: (),
}
impl DescribeClientAuthenticationSettings {
    /// Creates a new builder-style object to manufacture [`DescribeClientAuthenticationSettingsInput`](crate::input::DescribeClientAuthenticationSettingsInput)
    pub fn builder() -> crate::input::describe_client_authentication_settings_input::Builder {
        crate::input::describe_client_authentication_settings_input::Builder::default()
    }
    /// Creates a new `DescribeClientAuthenticationSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeClientAuthenticationSettings {
    type Output = std::result::Result<
        crate::output::DescribeClientAuthenticationSettingsOutput,
        crate::error::DescribeClientAuthenticationSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_client_authentication_settings_error(response)
        } else {
            crate::operation_deser::parse_describe_client_authentication_settings_response(response)
        }
    }
}

/// Operation shape for `DescribeConditionalForwarders`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_conditional_forwarders`](crate::client::Client::describe_conditional_forwarders).
///
/// See [`crate::client::fluent_builders::DescribeConditionalForwarders`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeConditionalForwarders {
    _private: (),
}
impl DescribeConditionalForwarders {
    /// Creates a new builder-style object to manufacture [`DescribeConditionalForwardersInput`](crate::input::DescribeConditionalForwardersInput)
    pub fn builder() -> crate::input::describe_conditional_forwarders_input::Builder {
        crate::input::describe_conditional_forwarders_input::Builder::default()
    }
    /// Creates a new `DescribeConditionalForwarders` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeConditionalForwarders {
    type Output = std::result::Result<
        crate::output::DescribeConditionalForwardersOutput,
        crate::error::DescribeConditionalForwardersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_conditional_forwarders_error(response)
        } else {
            crate::operation_deser::parse_describe_conditional_forwarders_response(response)
        }
    }
}

/// Operation shape for `DescribeDirectories`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_directories`](crate::client::Client::describe_directories).
///
/// See [`crate::client::fluent_builders::DescribeDirectories`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDirectories {
    _private: (),
}
impl DescribeDirectories {
    /// Creates a new builder-style object to manufacture [`DescribeDirectoriesInput`](crate::input::DescribeDirectoriesInput)
    pub fn builder() -> crate::input::describe_directories_input::Builder {
        crate::input::describe_directories_input::Builder::default()
    }
    /// Creates a new `DescribeDirectories` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDirectories {
    type Output = std::result::Result<
        crate::output::DescribeDirectoriesOutput,
        crate::error::DescribeDirectoriesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_directories_error(response)
        } else {
            crate::operation_deser::parse_describe_directories_response(response)
        }
    }
}

/// Operation shape for `DescribeDomainControllers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_domain_controllers`](crate::client::Client::describe_domain_controllers).
///
/// See [`crate::client::fluent_builders::DescribeDomainControllers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDomainControllers {
    _private: (),
}
impl DescribeDomainControllers {
    /// Creates a new builder-style object to manufacture [`DescribeDomainControllersInput`](crate::input::DescribeDomainControllersInput)
    pub fn builder() -> crate::input::describe_domain_controllers_input::Builder {
        crate::input::describe_domain_controllers_input::Builder::default()
    }
    /// Creates a new `DescribeDomainControllers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDomainControllers {
    type Output = std::result::Result<
        crate::output::DescribeDomainControllersOutput,
        crate::error::DescribeDomainControllersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_domain_controllers_error(response)
        } else {
            crate::operation_deser::parse_describe_domain_controllers_response(response)
        }
    }
}

/// Operation shape for `DescribeEventTopics`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_event_topics`](crate::client::Client::describe_event_topics).
///
/// See [`crate::client::fluent_builders::DescribeEventTopics`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEventTopics {
    _private: (),
}
impl DescribeEventTopics {
    /// Creates a new builder-style object to manufacture [`DescribeEventTopicsInput`](crate::input::DescribeEventTopicsInput)
    pub fn builder() -> crate::input::describe_event_topics_input::Builder {
        crate::input::describe_event_topics_input::Builder::default()
    }
    /// Creates a new `DescribeEventTopics` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEventTopics {
    type Output = std::result::Result<
        crate::output::DescribeEventTopicsOutput,
        crate::error::DescribeEventTopicsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_event_topics_error(response)
        } else {
            crate::operation_deser::parse_describe_event_topics_response(response)
        }
    }
}

/// Operation shape for `DescribeLDAPSSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_ldaps_settings`](crate::client::Client::describe_ldaps_settings).
///
/// See [`crate::client::fluent_builders::DescribeLDAPSSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLDAPSSettings {
    _private: (),
}
impl DescribeLDAPSSettings {
    /// Creates a new builder-style object to manufacture [`DescribeLdapsSettingsInput`](crate::input::DescribeLdapsSettingsInput)
    pub fn builder() -> crate::input::describe_ldaps_settings_input::Builder {
        crate::input::describe_ldaps_settings_input::Builder::default()
    }
    /// Creates a new `DescribeLDAPSSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLDAPSSettings {
    type Output = std::result::Result<
        crate::output::DescribeLdapsSettingsOutput,
        crate::error::DescribeLDAPSSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_ldaps_settings_error(response)
        } else {
            crate::operation_deser::parse_describe_ldaps_settings_response(response)
        }
    }
}

/// Operation shape for `DescribeRegions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_regions`](crate::client::Client::describe_regions).
///
/// See [`crate::client::fluent_builders::DescribeRegions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRegions {
    _private: (),
}
impl DescribeRegions {
    /// Creates a new builder-style object to manufacture [`DescribeRegionsInput`](crate::input::DescribeRegionsInput)
    pub fn builder() -> crate::input::describe_regions_input::Builder {
        crate::input::describe_regions_input::Builder::default()
    }
    /// Creates a new `DescribeRegions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRegions {
    type Output = std::result::Result<
        crate::output::DescribeRegionsOutput,
        crate::error::DescribeRegionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_regions_error(response)
        } else {
            crate::operation_deser::parse_describe_regions_response(response)
        }
    }
}

/// Operation shape for `DescribeSharedDirectories`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_shared_directories`](crate::client::Client::describe_shared_directories).
///
/// See [`crate::client::fluent_builders::DescribeSharedDirectories`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSharedDirectories {
    _private: (),
}
impl DescribeSharedDirectories {
    /// Creates a new builder-style object to manufacture [`DescribeSharedDirectoriesInput`](crate::input::DescribeSharedDirectoriesInput)
    pub fn builder() -> crate::input::describe_shared_directories_input::Builder {
        crate::input::describe_shared_directories_input::Builder::default()
    }
    /// Creates a new `DescribeSharedDirectories` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSharedDirectories {
    type Output = std::result::Result<
        crate::output::DescribeSharedDirectoriesOutput,
        crate::error::DescribeSharedDirectoriesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_shared_directories_error(response)
        } else {
            crate::operation_deser::parse_describe_shared_directories_response(response)
        }
    }
}

/// Operation shape for `DescribeSnapshots`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_snapshots`](crate::client::Client::describe_snapshots).
///
/// See [`crate::client::fluent_builders::DescribeSnapshots`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSnapshots {
    _private: (),
}
impl DescribeSnapshots {
    /// Creates a new builder-style object to manufacture [`DescribeSnapshotsInput`](crate::input::DescribeSnapshotsInput)
    pub fn builder() -> crate::input::describe_snapshots_input::Builder {
        crate::input::describe_snapshots_input::Builder::default()
    }
    /// Creates a new `DescribeSnapshots` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSnapshots {
    type Output = std::result::Result<
        crate::output::DescribeSnapshotsOutput,
        crate::error::DescribeSnapshotsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_snapshots_error(response)
        } else {
            crate::operation_deser::parse_describe_snapshots_response(response)
        }
    }
}

/// Operation shape for `DescribeTrusts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_trusts`](crate::client::Client::describe_trusts).
///
/// See [`crate::client::fluent_builders::DescribeTrusts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTrusts {
    _private: (),
}
impl DescribeTrusts {
    /// Creates a new builder-style object to manufacture [`DescribeTrustsInput`](crate::input::DescribeTrustsInput)
    pub fn builder() -> crate::input::describe_trusts_input::Builder {
        crate::input::describe_trusts_input::Builder::default()
    }
    /// Creates a new `DescribeTrusts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTrusts {
    type Output =
        std::result::Result<crate::output::DescribeTrustsOutput, crate::error::DescribeTrustsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_trusts_error(response)
        } else {
            crate::operation_deser::parse_describe_trusts_response(response)
        }
    }
}

/// Operation shape for `DisableClientAuthentication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_client_authentication`](crate::client::Client::disable_client_authentication).
///
/// See [`crate::client::fluent_builders::DisableClientAuthentication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableClientAuthentication {
    _private: (),
}
impl DisableClientAuthentication {
    /// Creates a new builder-style object to manufacture [`DisableClientAuthenticationInput`](crate::input::DisableClientAuthenticationInput)
    pub fn builder() -> crate::input::disable_client_authentication_input::Builder {
        crate::input::disable_client_authentication_input::Builder::default()
    }
    /// Creates a new `DisableClientAuthentication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableClientAuthentication {
    type Output = std::result::Result<
        crate::output::DisableClientAuthenticationOutput,
        crate::error::DisableClientAuthenticationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_client_authentication_error(response)
        } else {
            crate::operation_deser::parse_disable_client_authentication_response(response)
        }
    }
}

/// Operation shape for `DisableLDAPS`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_ldaps`](crate::client::Client::disable_ldaps).
///
/// See [`crate::client::fluent_builders::DisableLDAPS`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableLDAPS {
    _private: (),
}
impl DisableLDAPS {
    /// Creates a new builder-style object to manufacture [`DisableLdapsInput`](crate::input::DisableLdapsInput)
    pub fn builder() -> crate::input::disable_ldaps_input::Builder {
        crate::input::disable_ldaps_input::Builder::default()
    }
    /// Creates a new `DisableLDAPS` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableLDAPS {
    type Output =
        std::result::Result<crate::output::DisableLdapsOutput, crate::error::DisableLDAPSError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_ldaps_error(response)
        } else {
            crate::operation_deser::parse_disable_ldaps_response(response)
        }
    }
}

/// Operation shape for `DisableRadius`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_radius`](crate::client::Client::disable_radius).
///
/// See [`crate::client::fluent_builders::DisableRadius`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableRadius {
    _private: (),
}
impl DisableRadius {
    /// Creates a new builder-style object to manufacture [`DisableRadiusInput`](crate::input::DisableRadiusInput)
    pub fn builder() -> crate::input::disable_radius_input::Builder {
        crate::input::disable_radius_input::Builder::default()
    }
    /// Creates a new `DisableRadius` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableRadius {
    type Output =
        std::result::Result<crate::output::DisableRadiusOutput, crate::error::DisableRadiusError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_radius_error(response)
        } else {
            crate::operation_deser::parse_disable_radius_response(response)
        }
    }
}

/// Operation shape for `DisableSso`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_sso`](crate::client::Client::disable_sso).
///
/// See [`crate::client::fluent_builders::DisableSso`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableSso {
    _private: (),
}
impl DisableSso {
    /// Creates a new builder-style object to manufacture [`DisableSsoInput`](crate::input::DisableSsoInput)
    pub fn builder() -> crate::input::disable_sso_input::Builder {
        crate::input::disable_sso_input::Builder::default()
    }
    /// Creates a new `DisableSso` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableSso {
    type Output =
        std::result::Result<crate::output::DisableSsoOutput, crate::error::DisableSsoError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_sso_error(response)
        } else {
            crate::operation_deser::parse_disable_sso_response(response)
        }
    }
}

/// Operation shape for `EnableClientAuthentication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_client_authentication`](crate::client::Client::enable_client_authentication).
///
/// See [`crate::client::fluent_builders::EnableClientAuthentication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableClientAuthentication {
    _private: (),
}
impl EnableClientAuthentication {
    /// Creates a new builder-style object to manufacture [`EnableClientAuthenticationInput`](crate::input::EnableClientAuthenticationInput)
    pub fn builder() -> crate::input::enable_client_authentication_input::Builder {
        crate::input::enable_client_authentication_input::Builder::default()
    }
    /// Creates a new `EnableClientAuthentication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableClientAuthentication {
    type Output = std::result::Result<
        crate::output::EnableClientAuthenticationOutput,
        crate::error::EnableClientAuthenticationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_client_authentication_error(response)
        } else {
            crate::operation_deser::parse_enable_client_authentication_response(response)
        }
    }
}

/// Operation shape for `EnableLDAPS`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_ldaps`](crate::client::Client::enable_ldaps).
///
/// See [`crate::client::fluent_builders::EnableLDAPS`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableLDAPS {
    _private: (),
}
impl EnableLDAPS {
    /// Creates a new builder-style object to manufacture [`EnableLdapsInput`](crate::input::EnableLdapsInput)
    pub fn builder() -> crate::input::enable_ldaps_input::Builder {
        crate::input::enable_ldaps_input::Builder::default()
    }
    /// Creates a new `EnableLDAPS` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableLDAPS {
    type Output =
        std::result::Result<crate::output::EnableLdapsOutput, crate::error::EnableLDAPSError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_ldaps_error(response)
        } else {
            crate::operation_deser::parse_enable_ldaps_response(response)
        }
    }
}

/// Operation shape for `EnableRadius`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_radius`](crate::client::Client::enable_radius).
///
/// See [`crate::client::fluent_builders::EnableRadius`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableRadius {
    _private: (),
}
impl EnableRadius {
    /// Creates a new builder-style object to manufacture [`EnableRadiusInput`](crate::input::EnableRadiusInput)
    pub fn builder() -> crate::input::enable_radius_input::Builder {
        crate::input::enable_radius_input::Builder::default()
    }
    /// Creates a new `EnableRadius` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableRadius {
    type Output =
        std::result::Result<crate::output::EnableRadiusOutput, crate::error::EnableRadiusError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_radius_error(response)
        } else {
            crate::operation_deser::parse_enable_radius_response(response)
        }
    }
}

/// Operation shape for `EnableSso`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_sso`](crate::client::Client::enable_sso).
///
/// See [`crate::client::fluent_builders::EnableSso`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableSso {
    _private: (),
}
impl EnableSso {
    /// Creates a new builder-style object to manufacture [`EnableSsoInput`](crate::input::EnableSsoInput)
    pub fn builder() -> crate::input::enable_sso_input::Builder {
        crate::input::enable_sso_input::Builder::default()
    }
    /// Creates a new `EnableSso` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableSso {
    type Output = std::result::Result<crate::output::EnableSsoOutput, crate::error::EnableSsoError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_sso_error(response)
        } else {
            crate::operation_deser::parse_enable_sso_response(response)
        }
    }
}

/// Operation shape for `GetDirectoryLimits`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_directory_limits`](crate::client::Client::get_directory_limits).
///
/// See [`crate::client::fluent_builders::GetDirectoryLimits`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDirectoryLimits {
    _private: (),
}
impl GetDirectoryLimits {
    /// Creates a new builder-style object to manufacture [`GetDirectoryLimitsInput`](crate::input::GetDirectoryLimitsInput)
    pub fn builder() -> crate::input::get_directory_limits_input::Builder {
        crate::input::get_directory_limits_input::Builder::default()
    }
    /// Creates a new `GetDirectoryLimits` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDirectoryLimits {
    type Output = std::result::Result<
        crate::output::GetDirectoryLimitsOutput,
        crate::error::GetDirectoryLimitsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_directory_limits_error(response)
        } else {
            crate::operation_deser::parse_get_directory_limits_response(response)
        }
    }
}

/// Operation shape for `GetSnapshotLimits`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_snapshot_limits`](crate::client::Client::get_snapshot_limits).
///
/// See [`crate::client::fluent_builders::GetSnapshotLimits`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSnapshotLimits {
    _private: (),
}
impl GetSnapshotLimits {
    /// Creates a new builder-style object to manufacture [`GetSnapshotLimitsInput`](crate::input::GetSnapshotLimitsInput)
    pub fn builder() -> crate::input::get_snapshot_limits_input::Builder {
        crate::input::get_snapshot_limits_input::Builder::default()
    }
    /// Creates a new `GetSnapshotLimits` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSnapshotLimits {
    type Output = std::result::Result<
        crate::output::GetSnapshotLimitsOutput,
        crate::error::GetSnapshotLimitsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_snapshot_limits_error(response)
        } else {
            crate::operation_deser::parse_get_snapshot_limits_response(response)
        }
    }
}

/// Operation shape for `ListCertificates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_certificates`](crate::client::Client::list_certificates).
///
/// See [`crate::client::fluent_builders::ListCertificates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCertificates {
    _private: (),
}
impl ListCertificates {
    /// Creates a new builder-style object to manufacture [`ListCertificatesInput`](crate::input::ListCertificatesInput)
    pub fn builder() -> crate::input::list_certificates_input::Builder {
        crate::input::list_certificates_input::Builder::default()
    }
    /// Creates a new `ListCertificates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCertificates {
    type Output = std::result::Result<
        crate::output::ListCertificatesOutput,
        crate::error::ListCertificatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_certificates_error(response)
        } else {
            crate::operation_deser::parse_list_certificates_response(response)
        }
    }
}

/// Operation shape for `ListIpRoutes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_ip_routes`](crate::client::Client::list_ip_routes).
///
/// See [`crate::client::fluent_builders::ListIpRoutes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListIpRoutes {
    _private: (),
}
impl ListIpRoutes {
    /// Creates a new builder-style object to manufacture [`ListIpRoutesInput`](crate::input::ListIpRoutesInput)
    pub fn builder() -> crate::input::list_ip_routes_input::Builder {
        crate::input::list_ip_routes_input::Builder::default()
    }
    /// Creates a new `ListIpRoutes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListIpRoutes {
    type Output =
        std::result::Result<crate::output::ListIpRoutesOutput, crate::error::ListIpRoutesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_ip_routes_error(response)
        } else {
            crate::operation_deser::parse_list_ip_routes_response(response)
        }
    }
}

/// Operation shape for `ListLogSubscriptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_log_subscriptions`](crate::client::Client::list_log_subscriptions).
///
/// See [`crate::client::fluent_builders::ListLogSubscriptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListLogSubscriptions {
    _private: (),
}
impl ListLogSubscriptions {
    /// Creates a new builder-style object to manufacture [`ListLogSubscriptionsInput`](crate::input::ListLogSubscriptionsInput)
    pub fn builder() -> crate::input::list_log_subscriptions_input::Builder {
        crate::input::list_log_subscriptions_input::Builder::default()
    }
    /// Creates a new `ListLogSubscriptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListLogSubscriptions {
    type Output = std::result::Result<
        crate::output::ListLogSubscriptionsOutput,
        crate::error::ListLogSubscriptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_log_subscriptions_error(response)
        } else {
            crate::operation_deser::parse_list_log_subscriptions_response(response)
        }
    }
}

/// Operation shape for `ListSchemaExtensions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_schema_extensions`](crate::client::Client::list_schema_extensions).
///
/// See [`crate::client::fluent_builders::ListSchemaExtensions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSchemaExtensions {
    _private: (),
}
impl ListSchemaExtensions {
    /// Creates a new builder-style object to manufacture [`ListSchemaExtensionsInput`](crate::input::ListSchemaExtensionsInput)
    pub fn builder() -> crate::input::list_schema_extensions_input::Builder {
        crate::input::list_schema_extensions_input::Builder::default()
    }
    /// Creates a new `ListSchemaExtensions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSchemaExtensions {
    type Output = std::result::Result<
        crate::output::ListSchemaExtensionsOutput,
        crate::error::ListSchemaExtensionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_schema_extensions_error(response)
        } else {
            crate::operation_deser::parse_list_schema_extensions_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `RegisterCertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_certificate`](crate::client::Client::register_certificate).
///
/// See [`crate::client::fluent_builders::RegisterCertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterCertificate {
    _private: (),
}
impl RegisterCertificate {
    /// Creates a new builder-style object to manufacture [`RegisterCertificateInput`](crate::input::RegisterCertificateInput)
    pub fn builder() -> crate::input::register_certificate_input::Builder {
        crate::input::register_certificate_input::Builder::default()
    }
    /// Creates a new `RegisterCertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterCertificate {
    type Output = std::result::Result<
        crate::output::RegisterCertificateOutput,
        crate::error::RegisterCertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_certificate_error(response)
        } else {
            crate::operation_deser::parse_register_certificate_response(response)
        }
    }
}

/// Operation shape for `RegisterEventTopic`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_event_topic`](crate::client::Client::register_event_topic).
///
/// See [`crate::client::fluent_builders::RegisterEventTopic`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterEventTopic {
    _private: (),
}
impl RegisterEventTopic {
    /// Creates a new builder-style object to manufacture [`RegisterEventTopicInput`](crate::input::RegisterEventTopicInput)
    pub fn builder() -> crate::input::register_event_topic_input::Builder {
        crate::input::register_event_topic_input::Builder::default()
    }
    /// Creates a new `RegisterEventTopic` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterEventTopic {
    type Output = std::result::Result<
        crate::output::RegisterEventTopicOutput,
        crate::error::RegisterEventTopicError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_event_topic_error(response)
        } else {
            crate::operation_deser::parse_register_event_topic_response(response)
        }
    }
}

/// Operation shape for `RejectSharedDirectory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reject_shared_directory`](crate::client::Client::reject_shared_directory).
///
/// See [`crate::client::fluent_builders::RejectSharedDirectory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RejectSharedDirectory {
    _private: (),
}
impl RejectSharedDirectory {
    /// Creates a new builder-style object to manufacture [`RejectSharedDirectoryInput`](crate::input::RejectSharedDirectoryInput)
    pub fn builder() -> crate::input::reject_shared_directory_input::Builder {
        crate::input::reject_shared_directory_input::Builder::default()
    }
    /// Creates a new `RejectSharedDirectory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RejectSharedDirectory {
    type Output = std::result::Result<
        crate::output::RejectSharedDirectoryOutput,
        crate::error::RejectSharedDirectoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reject_shared_directory_error(response)
        } else {
            crate::operation_deser::parse_reject_shared_directory_response(response)
        }
    }
}

/// Operation shape for `RemoveIpRoutes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_ip_routes`](crate::client::Client::remove_ip_routes).
///
/// See [`crate::client::fluent_builders::RemoveIpRoutes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveIpRoutes {
    _private: (),
}
impl RemoveIpRoutes {
    /// Creates a new builder-style object to manufacture [`RemoveIpRoutesInput`](crate::input::RemoveIpRoutesInput)
    pub fn builder() -> crate::input::remove_ip_routes_input::Builder {
        crate::input::remove_ip_routes_input::Builder::default()
    }
    /// Creates a new `RemoveIpRoutes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveIpRoutes {
    type Output =
        std::result::Result<crate::output::RemoveIpRoutesOutput, crate::error::RemoveIpRoutesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_ip_routes_error(response)
        } else {
            crate::operation_deser::parse_remove_ip_routes_response(response)
        }
    }
}

/// Operation shape for `RemoveRegion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_region`](crate::client::Client::remove_region).
///
/// See [`crate::client::fluent_builders::RemoveRegion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveRegion {
    _private: (),
}
impl RemoveRegion {
    /// Creates a new builder-style object to manufacture [`RemoveRegionInput`](crate::input::RemoveRegionInput)
    pub fn builder() -> crate::input::remove_region_input::Builder {
        crate::input::remove_region_input::Builder::default()
    }
    /// Creates a new `RemoveRegion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveRegion {
    type Output =
        std::result::Result<crate::output::RemoveRegionOutput, crate::error::RemoveRegionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_region_error(response)
        } else {
            crate::operation_deser::parse_remove_region_response(response)
        }
    }
}

/// Operation shape for `RemoveTagsFromResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_tags_from_resource`](crate::client::Client::remove_tags_from_resource).
///
/// See [`crate::client::fluent_builders::RemoveTagsFromResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveTagsFromResource {
    _private: (),
}
impl RemoveTagsFromResource {
    /// Creates a new builder-style object to manufacture [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
    pub fn builder() -> crate::input::remove_tags_from_resource_input::Builder {
        crate::input::remove_tags_from_resource_input::Builder::default()
    }
    /// Creates a new `RemoveTagsFromResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveTagsFromResource {
    type Output = std::result::Result<
        crate::output::RemoveTagsFromResourceOutput,
        crate::error::RemoveTagsFromResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_tags_from_resource_error(response)
        } else {
            crate::operation_deser::parse_remove_tags_from_resource_response(response)
        }
    }
}

/// Operation shape for `ResetUserPassword`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reset_user_password`](crate::client::Client::reset_user_password).
///
/// See [`crate::client::fluent_builders::ResetUserPassword`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResetUserPassword {
    _private: (),
}
impl ResetUserPassword {
    /// Creates a new builder-style object to manufacture [`ResetUserPasswordInput`](crate::input::ResetUserPasswordInput)
    pub fn builder() -> crate::input::reset_user_password_input::Builder {
        crate::input::reset_user_password_input::Builder::default()
    }
    /// Creates a new `ResetUserPassword` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResetUserPassword {
    type Output = std::result::Result<
        crate::output::ResetUserPasswordOutput,
        crate::error::ResetUserPasswordError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reset_user_password_error(response)
        } else {
            crate::operation_deser::parse_reset_user_password_response(response)
        }
    }
}

/// Operation shape for `RestoreFromSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`restore_from_snapshot`](crate::client::Client::restore_from_snapshot).
///
/// See [`crate::client::fluent_builders::RestoreFromSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RestoreFromSnapshot {
    _private: (),
}
impl RestoreFromSnapshot {
    /// Creates a new builder-style object to manufacture [`RestoreFromSnapshotInput`](crate::input::RestoreFromSnapshotInput)
    pub fn builder() -> crate::input::restore_from_snapshot_input::Builder {
        crate::input::restore_from_snapshot_input::Builder::default()
    }
    /// Creates a new `RestoreFromSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RestoreFromSnapshot {
    type Output = std::result::Result<
        crate::output::RestoreFromSnapshotOutput,
        crate::error::RestoreFromSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_restore_from_snapshot_error(response)
        } else {
            crate::operation_deser::parse_restore_from_snapshot_response(response)
        }
    }
}

/// Operation shape for `ShareDirectory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`share_directory`](crate::client::Client::share_directory).
///
/// See [`crate::client::fluent_builders::ShareDirectory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ShareDirectory {
    _private: (),
}
impl ShareDirectory {
    /// Creates a new builder-style object to manufacture [`ShareDirectoryInput`](crate::input::ShareDirectoryInput)
    pub fn builder() -> crate::input::share_directory_input::Builder {
        crate::input::share_directory_input::Builder::default()
    }
    /// Creates a new `ShareDirectory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ShareDirectory {
    type Output =
        std::result::Result<crate::output::ShareDirectoryOutput, crate::error::ShareDirectoryError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_share_directory_error(response)
        } else {
            crate::operation_deser::parse_share_directory_response(response)
        }
    }
}

/// Operation shape for `StartSchemaExtension`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_schema_extension`](crate::client::Client::start_schema_extension).
///
/// See [`crate::client::fluent_builders::StartSchemaExtension`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartSchemaExtension {
    _private: (),
}
impl StartSchemaExtension {
    /// Creates a new builder-style object to manufacture [`StartSchemaExtensionInput`](crate::input::StartSchemaExtensionInput)
    pub fn builder() -> crate::input::start_schema_extension_input::Builder {
        crate::input::start_schema_extension_input::Builder::default()
    }
    /// Creates a new `StartSchemaExtension` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartSchemaExtension {
    type Output = std::result::Result<
        crate::output::StartSchemaExtensionOutput,
        crate::error::StartSchemaExtensionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_schema_extension_error(response)
        } else {
            crate::operation_deser::parse_start_schema_extension_response(response)
        }
    }
}

/// Operation shape for `UnshareDirectory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`unshare_directory`](crate::client::Client::unshare_directory).
///
/// See [`crate::client::fluent_builders::UnshareDirectory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UnshareDirectory {
    _private: (),
}
impl UnshareDirectory {
    /// Creates a new builder-style object to manufacture [`UnshareDirectoryInput`](crate::input::UnshareDirectoryInput)
    pub fn builder() -> crate::input::unshare_directory_input::Builder {
        crate::input::unshare_directory_input::Builder::default()
    }
    /// Creates a new `UnshareDirectory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UnshareDirectory {
    type Output = std::result::Result<
        crate::output::UnshareDirectoryOutput,
        crate::error::UnshareDirectoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_unshare_directory_error(response)
        } else {
            crate::operation_deser::parse_unshare_directory_response(response)
        }
    }
}

/// Operation shape for `UpdateConditionalForwarder`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_conditional_forwarder`](crate::client::Client::update_conditional_forwarder).
///
/// See [`crate::client::fluent_builders::UpdateConditionalForwarder`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateConditionalForwarder {
    _private: (),
}
impl UpdateConditionalForwarder {
    /// Creates a new builder-style object to manufacture [`UpdateConditionalForwarderInput`](crate::input::UpdateConditionalForwarderInput)
    pub fn builder() -> crate::input::update_conditional_forwarder_input::Builder {
        crate::input::update_conditional_forwarder_input::Builder::default()
    }
    /// Creates a new `UpdateConditionalForwarder` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateConditionalForwarder {
    type Output = std::result::Result<
        crate::output::UpdateConditionalForwarderOutput,
        crate::error::UpdateConditionalForwarderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_conditional_forwarder_error(response)
        } else {
            crate::operation_deser::parse_update_conditional_forwarder_response(response)
        }
    }
}

/// Operation shape for `UpdateNumberOfDomainControllers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_number_of_domain_controllers`](crate::client::Client::update_number_of_domain_controllers).
///
/// See [`crate::client::fluent_builders::UpdateNumberOfDomainControllers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateNumberOfDomainControllers {
    _private: (),
}
impl UpdateNumberOfDomainControllers {
    /// Creates a new builder-style object to manufacture [`UpdateNumberOfDomainControllersInput`](crate::input::UpdateNumberOfDomainControllersInput)
    pub fn builder() -> crate::input::update_number_of_domain_controllers_input::Builder {
        crate::input::update_number_of_domain_controllers_input::Builder::default()
    }
    /// Creates a new `UpdateNumberOfDomainControllers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateNumberOfDomainControllers {
    type Output = std::result::Result<
        crate::output::UpdateNumberOfDomainControllersOutput,
        crate::error::UpdateNumberOfDomainControllersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_number_of_domain_controllers_error(response)
        } else {
            crate::operation_deser::parse_update_number_of_domain_controllers_response(response)
        }
    }
}

/// Operation shape for `UpdateRadius`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_radius`](crate::client::Client::update_radius).
///
/// See [`crate::client::fluent_builders::UpdateRadius`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRadius {
    _private: (),
}
impl UpdateRadius {
    /// Creates a new builder-style object to manufacture [`UpdateRadiusInput`](crate::input::UpdateRadiusInput)
    pub fn builder() -> crate::input::update_radius_input::Builder {
        crate::input::update_radius_input::Builder::default()
    }
    /// Creates a new `UpdateRadius` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRadius {
    type Output =
        std::result::Result<crate::output::UpdateRadiusOutput, crate::error::UpdateRadiusError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_radius_error(response)
        } else {
            crate::operation_deser::parse_update_radius_response(response)
        }
    }
}

/// Operation shape for `UpdateTrust`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_trust`](crate::client::Client::update_trust).
///
/// See [`crate::client::fluent_builders::UpdateTrust`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTrust {
    _private: (),
}
impl UpdateTrust {
    /// Creates a new builder-style object to manufacture [`UpdateTrustInput`](crate::input::UpdateTrustInput)
    pub fn builder() -> crate::input::update_trust_input::Builder {
        crate::input::update_trust_input::Builder::default()
    }
    /// Creates a new `UpdateTrust` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTrust {
    type Output =
        std::result::Result<crate::output::UpdateTrustOutput, crate::error::UpdateTrustError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_trust_error(response)
        } else {
            crate::operation_deser::parse_update_trust_response(response)
        }
    }
}

/// Operation shape for `VerifyTrust`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`verify_trust`](crate::client::Client::verify_trust).
///
/// See [`crate::client::fluent_builders::VerifyTrust`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct VerifyTrust {
    _private: (),
}
impl VerifyTrust {
    /// Creates a new builder-style object to manufacture [`VerifyTrustInput`](crate::input::VerifyTrustInput)
    pub fn builder() -> crate::input::verify_trust_input::Builder {
        crate::input::verify_trust_input::Builder::default()
    }
    /// Creates a new `VerifyTrust` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for VerifyTrust {
    type Output =
        std::result::Result<crate::output::VerifyTrustOutput, crate::error::VerifyTrustError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_verify_trust_error(response)
        } else {
            crate::operation_deser::parse_verify_trust_response(response)
        }
    }
}
