// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Directory Service
///
/// Client for invoking operations on AWS Directory Service. Each operation on AWS Directory Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_directory::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_directory::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_directory::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`AcceptSharedDirectory`](crate::client::fluent_builders::AcceptSharedDirectory) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`shared_directory_id(impl Into<String>)`](crate::client::fluent_builders::AcceptSharedDirectory::shared_directory_id) / [`set_shared_directory_id(Option<String>)`](crate::client::fluent_builders::AcceptSharedDirectory::set_shared_directory_id): <p>Identifier of the shared directory in the directory consumer account. This identifier is different for each directory owner account. </p>
    /// - On success, responds with [`AcceptSharedDirectoryOutput`](crate::output::AcceptSharedDirectoryOutput) with field(s):
    ///   - [`shared_directory(Option<SharedDirectory>)`](crate::output::AcceptSharedDirectoryOutput::shared_directory): <p>The shared directory in the directory consumer account.</p>
    /// - On failure, responds with [`SdkError<AcceptSharedDirectoryError>`](crate::error::AcceptSharedDirectoryError)
    pub fn accept_shared_directory(&self) -> fluent_builders::AcceptSharedDirectory<C, M, R> {
        fluent_builders::AcceptSharedDirectory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AddIpRoutes`](crate::client::fluent_builders::AddIpRoutes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::AddIpRoutes::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::AddIpRoutes::set_directory_id): <p>Identifier (ID) of the directory to which to add the address block.</p>
    ///   - [`ip_routes(Vec<IpRoute>)`](crate::client::fluent_builders::AddIpRoutes::ip_routes) / [`set_ip_routes(Option<Vec<IpRoute>>)`](crate::client::fluent_builders::AddIpRoutes::set_ip_routes): <p>IP address blocks, using CIDR format, of the traffic to route. This is often the IP address block of the DNS server used for your self-managed domain.</p>
    ///   - [`update_security_group_for_directory_controllers(bool)`](crate::client::fluent_builders::AddIpRoutes::update_security_group_for_directory_controllers) / [`set_update_security_group_for_directory_controllers(bool)`](crate::client::fluent_builders::AddIpRoutes::set_update_security_group_for_directory_controllers): <p>If set to true, updates the inbound and outbound rules of the security group that has the description: "Amazon Web Services created security group for <i>directory ID</i> directory controllers." Following are the new rules: </p>  <p>Inbound:</p>  <ul>   <li> <p>Type: Custom UDP Rule, Protocol: UDP, Range: 88, Source: 0.0.0.0/0</p> </li>   <li> <p>Type: Custom UDP Rule, Protocol: UDP, Range: 123, Source: 0.0.0.0/0</p> </li>   <li> <p>Type: Custom UDP Rule, Protocol: UDP, Range: 138, Source: 0.0.0.0/0</p> </li>   <li> <p>Type: Custom UDP Rule, Protocol: UDP, Range: 389, Source: 0.0.0.0/0</p> </li>   <li> <p>Type: Custom UDP Rule, Protocol: UDP, Range: 464, Source: 0.0.0.0/0</p> </li>   <li> <p>Type: Custom UDP Rule, Protocol: UDP, Range: 445, Source: 0.0.0.0/0</p> </li>   <li> <p>Type: Custom TCP Rule, Protocol: TCP, Range: 88, Source: 0.0.0.0/0</p> </li>   <li> <p>Type: Custom TCP Rule, Protocol: TCP, Range: 135, Source: 0.0.0.0/0</p> </li>   <li> <p>Type: Custom TCP Rule, Protocol: TCP, Range: 445, Source: 0.0.0.0/0</p> </li>   <li> <p>Type: Custom TCP Rule, Protocol: TCP, Range: 464, Source: 0.0.0.0/0</p> </li>   <li> <p>Type: Custom TCP Rule, Protocol: TCP, Range: 636, Source: 0.0.0.0/0</p> </li>   <li> <p>Type: Custom TCP Rule, Protocol: TCP, Range: 1024-65535, Source: 0.0.0.0/0</p> </li>   <li> <p>Type: Custom TCP Rule, Protocol: TCP, Range: 3268-33269, Source: 0.0.0.0/0</p> </li>   <li> <p>Type: DNS (UDP), Protocol: UDP, Range: 53, Source: 0.0.0.0/0</p> </li>   <li> <p>Type: DNS (TCP), Protocol: TCP, Range: 53, Source: 0.0.0.0/0</p> </li>   <li> <p>Type: LDAP, Protocol: TCP, Range: 389, Source: 0.0.0.0/0</p> </li>   <li> <p>Type: All ICMP, Protocol: All, Range: N/A, Source: 0.0.0.0/0</p> </li>  </ul>  <p></p>  <p>Outbound:</p>  <ul>   <li> <p>Type: All traffic, Protocol: All, Range: All, Destination: 0.0.0.0/0</p> </li>  </ul>  <p>These security rules impact an internal network interface that is not exposed publicly.</p>
    /// - On success, responds with [`AddIpRoutesOutput`](crate::output::AddIpRoutesOutput)

    /// - On failure, responds with [`SdkError<AddIpRoutesError>`](crate::error::AddIpRoutesError)
    pub fn add_ip_routes(&self) -> fluent_builders::AddIpRoutes<C, M, R> {
        fluent_builders::AddIpRoutes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AddRegion`](crate::client::fluent_builders::AddRegion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::AddRegion::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::AddRegion::set_directory_id): <p>The identifier of the directory to which you want to add Region replication.</p>
    ///   - [`region_name(impl Into<String>)`](crate::client::fluent_builders::AddRegion::region_name) / [`set_region_name(Option<String>)`](crate::client::fluent_builders::AddRegion::set_region_name): <p>The name of the Region where you want to add domain controllers for replication. For example, <code>us-east-1</code>.</p>
    ///   - [`vpc_settings(DirectoryVpcSettings)`](crate::client::fluent_builders::AddRegion::vpc_settings) / [`set_vpc_settings(Option<DirectoryVpcSettings>)`](crate::client::fluent_builders::AddRegion::set_vpc_settings): <p>Contains VPC information for the <code>CreateDirectory</code> or <code>CreateMicrosoftAD</code> operation.</p>
    /// - On success, responds with [`AddRegionOutput`](crate::output::AddRegionOutput)

    /// - On failure, responds with [`SdkError<AddRegionError>`](crate::error::AddRegionError)
    pub fn add_region(&self) -> fluent_builders::AddRegion<C, M, R> {
        fluent_builders::AddRegion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AddTagsToResource`](crate::client::fluent_builders::AddTagsToResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::AddTagsToResource::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::AddTagsToResource::set_resource_id): <p>Identifier (ID) for the directory to which to add the tag.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::AddTagsToResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::AddTagsToResource::set_tags): <p>The tags to be assigned to the directory.</p>
    /// - On success, responds with [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)

    /// - On failure, responds with [`SdkError<AddTagsToResourceError>`](crate::error::AddTagsToResourceError)
    pub fn add_tags_to_resource(&self) -> fluent_builders::AddTagsToResource<C, M, R> {
        fluent_builders::AddTagsToResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelSchemaExtension`](crate::client::fluent_builders::CancelSchemaExtension) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::CancelSchemaExtension::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::CancelSchemaExtension::set_directory_id): <p>The identifier of the directory whose schema extension will be canceled.</p>
    ///   - [`schema_extension_id(impl Into<String>)`](crate::client::fluent_builders::CancelSchemaExtension::schema_extension_id) / [`set_schema_extension_id(Option<String>)`](crate::client::fluent_builders::CancelSchemaExtension::set_schema_extension_id): <p>The identifier of the schema extension that will be canceled.</p>
    /// - On success, responds with [`CancelSchemaExtensionOutput`](crate::output::CancelSchemaExtensionOutput)

    /// - On failure, responds with [`SdkError<CancelSchemaExtensionError>`](crate::error::CancelSchemaExtensionError)
    pub fn cancel_schema_extension(&self) -> fluent_builders::CancelSchemaExtension<C, M, R> {
        fluent_builders::CancelSchemaExtension::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ConnectDirectory`](crate::client::fluent_builders::ConnectDirectory) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::ConnectDirectory::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::ConnectDirectory::set_name): <p>The fully qualified name of your self-managed directory, such as <code>corp.example.com</code>.</p>
    ///   - [`short_name(impl Into<String>)`](crate::client::fluent_builders::ConnectDirectory::short_name) / [`set_short_name(Option<String>)`](crate::client::fluent_builders::ConnectDirectory::set_short_name): <p>The NetBIOS name of your self-managed directory, such as <code>CORP</code>.</p>
    ///   - [`password(impl Into<String>)`](crate::client::fluent_builders::ConnectDirectory::password) / [`set_password(Option<String>)`](crate::client::fluent_builders::ConnectDirectory::set_password): <p>The password for your self-managed user account.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::ConnectDirectory::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::ConnectDirectory::set_description): <p>A description for the directory.</p>
    ///   - [`size(DirectorySize)`](crate::client::fluent_builders::ConnectDirectory::size) / [`set_size(Option<DirectorySize>)`](crate::client::fluent_builders::ConnectDirectory::set_size): <p>The size of the directory.</p>
    ///   - [`connect_settings(DirectoryConnectSettings)`](crate::client::fluent_builders::ConnectDirectory::connect_settings) / [`set_connect_settings(Option<DirectoryConnectSettings>)`](crate::client::fluent_builders::ConnectDirectory::set_connect_settings): <p>A <code>DirectoryConnectSettings</code> object that contains additional information for the operation.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::ConnectDirectory::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::ConnectDirectory::set_tags): <p>The tags to be assigned to AD Connector.</p>
    /// - On success, responds with [`ConnectDirectoryOutput`](crate::output::ConnectDirectoryOutput) with field(s):
    ///   - [`directory_id(Option<String>)`](crate::output::ConnectDirectoryOutput::directory_id): <p>The identifier of the new directory.</p>
    /// - On failure, responds with [`SdkError<ConnectDirectoryError>`](crate::error::ConnectDirectoryError)
    pub fn connect_directory(&self) -> fluent_builders::ConnectDirectory<C, M, R> {
        fluent_builders::ConnectDirectory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAlias`](crate::client::fluent_builders::CreateAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::CreateAlias::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::CreateAlias::set_directory_id): <p>The identifier of the directory for which to create the alias.</p>
    ///   - [`alias(impl Into<String>)`](crate::client::fluent_builders::CreateAlias::alias) / [`set_alias(Option<String>)`](crate::client::fluent_builders::CreateAlias::set_alias): <p>The requested alias.</p>  <p>The alias must be unique amongst all aliases in Amazon Web Services. This operation throws an <code>EntityAlreadyExistsException</code> error if the alias already exists.</p>
    /// - On success, responds with [`CreateAliasOutput`](crate::output::CreateAliasOutput) with field(s):
    ///   - [`directory_id(Option<String>)`](crate::output::CreateAliasOutput::directory_id): <p>The identifier of the directory.</p>
    ///   - [`alias(Option<String>)`](crate::output::CreateAliasOutput::alias): <p>The alias for the directory.</p>
    /// - On failure, responds with [`SdkError<CreateAliasError>`](crate::error::CreateAliasError)
    pub fn create_alias(&self) -> fluent_builders::CreateAlias<C, M, R> {
        fluent_builders::CreateAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateComputer`](crate::client::fluent_builders::CreateComputer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::CreateComputer::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::CreateComputer::set_directory_id): <p>The identifier of the directory in which to create the computer account.</p>
    ///   - [`computer_name(impl Into<String>)`](crate::client::fluent_builders::CreateComputer::computer_name) / [`set_computer_name(Option<String>)`](crate::client::fluent_builders::CreateComputer::set_computer_name): <p>The name of the computer account.</p>
    ///   - [`password(impl Into<String>)`](crate::client::fluent_builders::CreateComputer::password) / [`set_password(Option<String>)`](crate::client::fluent_builders::CreateComputer::set_password): <p>A one-time password that is used to join the computer to the directory. You should generate a random, strong password to use for this parameter.</p>
    ///   - [`organizational_unit_distinguished_name(impl Into<String>)`](crate::client::fluent_builders::CreateComputer::organizational_unit_distinguished_name) / [`set_organizational_unit_distinguished_name(Option<String>)`](crate::client::fluent_builders::CreateComputer::set_organizational_unit_distinguished_name): <p>The fully-qualified distinguished name of the organizational unit to place the computer account in.</p>
    ///   - [`computer_attributes(Vec<Attribute>)`](crate::client::fluent_builders::CreateComputer::computer_attributes) / [`set_computer_attributes(Option<Vec<Attribute>>)`](crate::client::fluent_builders::CreateComputer::set_computer_attributes): <p>An array of <code>Attribute</code> objects that contain any LDAP attributes to apply to the computer account.</p>
    /// - On success, responds with [`CreateComputerOutput`](crate::output::CreateComputerOutput) with field(s):
    ///   - [`computer(Option<Computer>)`](crate::output::CreateComputerOutput::computer): <p>A <code>Computer</code> object that represents the computer account.</p>
    /// - On failure, responds with [`SdkError<CreateComputerError>`](crate::error::CreateComputerError)
    pub fn create_computer(&self) -> fluent_builders::CreateComputer<C, M, R> {
        fluent_builders::CreateComputer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateConditionalForwarder`](crate::client::fluent_builders::CreateConditionalForwarder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::CreateConditionalForwarder::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::CreateConditionalForwarder::set_directory_id): <p>The directory ID of the Amazon Web Services directory for which you are creating the conditional forwarder.</p>
    ///   - [`remote_domain_name(impl Into<String>)`](crate::client::fluent_builders::CreateConditionalForwarder::remote_domain_name) / [`set_remote_domain_name(Option<String>)`](crate::client::fluent_builders::CreateConditionalForwarder::set_remote_domain_name): <p>The fully qualified domain name (FQDN) of the remote domain with which you will set up a trust relationship.</p>
    ///   - [`dns_ip_addrs(Vec<String>)`](crate::client::fluent_builders::CreateConditionalForwarder::dns_ip_addrs) / [`set_dns_ip_addrs(Option<Vec<String>>)`](crate::client::fluent_builders::CreateConditionalForwarder::set_dns_ip_addrs): <p>The IP addresses of the remote DNS server associated with RemoteDomainName.</p>
    /// - On success, responds with [`CreateConditionalForwarderOutput`](crate::output::CreateConditionalForwarderOutput)

    /// - On failure, responds with [`SdkError<CreateConditionalForwarderError>`](crate::error::CreateConditionalForwarderError)
    pub fn create_conditional_forwarder(
        &self,
    ) -> fluent_builders::CreateConditionalForwarder<C, M, R> {
        fluent_builders::CreateConditionalForwarder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDirectory`](crate::client::fluent_builders::CreateDirectory) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateDirectory::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateDirectory::set_name): <p>The fully qualified name for the directory, such as <code>corp.example.com</code>.</p>
    ///   - [`short_name(impl Into<String>)`](crate::client::fluent_builders::CreateDirectory::short_name) / [`set_short_name(Option<String>)`](crate::client::fluent_builders::CreateDirectory::set_short_name): <p>The NetBIOS name of the directory, such as <code>CORP</code>.</p>
    ///   - [`password(impl Into<String>)`](crate::client::fluent_builders::CreateDirectory::password) / [`set_password(Option<String>)`](crate::client::fluent_builders::CreateDirectory::set_password): <p>The password for the directory administrator. The directory creation process creates a directory administrator account with the user name <code>Administrator</code> and this password.</p>  <p>If you need to change the password for the administrator account, you can use the <code>ResetUserPassword</code> API call.</p>  <p>The regex pattern for this string is made up of the following conditions:</p>  <ul>   <li> <p>Length (?=^.{8,64}$) – Must be between 8 and 64 characters</p> </li>  </ul>  <p>AND any 3 of the following password complexity rules required by Active Directory:</p>  <ul>   <li> <p>Numbers and upper case and lowercase (?=.*\d)(?=.*[A-Z])(?=.*[a-z])</p> </li>   <li> <p>Numbers and special characters and lower case (?=.*\d)(?=.*[^A-Za-z0-9\s])(?=.*[a-z])</p> </li>   <li> <p>Special characters and upper case and lower case (?=.*[^A-Za-z0-9\s])(?=.*[A-Z])(?=.*[a-z])</p> </li>   <li> <p>Numbers and upper case and special characters (?=.*\d)(?=.*[A-Z])(?=.*[^A-Za-z0-9\s])</p> </li>  </ul>  <p>For additional information about how Active Directory passwords are enforced, see <a href="https://docs.microsoft.com/en-us/windows/security/threat-protection/security-policy-settings/password-must-meet-complexity-requirements">Password must meet complexity requirements</a> on the Microsoft website.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateDirectory::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateDirectory::set_description): <p>A description for the directory.</p>
    ///   - [`size(DirectorySize)`](crate::client::fluent_builders::CreateDirectory::size) / [`set_size(Option<DirectorySize>)`](crate::client::fluent_builders::CreateDirectory::set_size): <p>The size of the directory.</p>
    ///   - [`vpc_settings(DirectoryVpcSettings)`](crate::client::fluent_builders::CreateDirectory::vpc_settings) / [`set_vpc_settings(Option<DirectoryVpcSettings>)`](crate::client::fluent_builders::CreateDirectory::set_vpc_settings): <p>A <code>DirectoryVpcSettings</code> object that contains additional information for the operation.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDirectory::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDirectory::set_tags): <p>The tags to be assigned to the Simple AD directory.</p>
    /// - On success, responds with [`CreateDirectoryOutput`](crate::output::CreateDirectoryOutput) with field(s):
    ///   - [`directory_id(Option<String>)`](crate::output::CreateDirectoryOutput::directory_id): <p>The identifier of the directory that was created.</p>
    /// - On failure, responds with [`SdkError<CreateDirectoryError>`](crate::error::CreateDirectoryError)
    pub fn create_directory(&self) -> fluent_builders::CreateDirectory<C, M, R> {
        fluent_builders::CreateDirectory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLogSubscription`](crate::client::fluent_builders::CreateLogSubscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::CreateLogSubscription::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::CreateLogSubscription::set_directory_id): <p>Identifier of the directory to which you want to subscribe and receive real-time logs to your specified CloudWatch log group.</p>
    ///   - [`log_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateLogSubscription::log_group_name) / [`set_log_group_name(Option<String>)`](crate::client::fluent_builders::CreateLogSubscription::set_log_group_name): <p>The name of the CloudWatch log group where the real-time domain controller logs are forwarded.</p>
    /// - On success, responds with [`CreateLogSubscriptionOutput`](crate::output::CreateLogSubscriptionOutput)

    /// - On failure, responds with [`SdkError<CreateLogSubscriptionError>`](crate::error::CreateLogSubscriptionError)
    pub fn create_log_subscription(&self) -> fluent_builders::CreateLogSubscription<C, M, R> {
        fluent_builders::CreateLogSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateMicrosoftAD`](crate::client::fluent_builders::CreateMicrosoftAD) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateMicrosoftAD::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateMicrosoftAD::set_name): <p>The fully qualified domain name for the Managed Microsoft AD directory, such as <code>corp.example.com</code>. This name will resolve inside your VPC only. It does not need to be publicly resolvable.</p>
    ///   - [`short_name(impl Into<String>)`](crate::client::fluent_builders::CreateMicrosoftAD::short_name) / [`set_short_name(Option<String>)`](crate::client::fluent_builders::CreateMicrosoftAD::set_short_name): <p>The NetBIOS name for your domain, such as <code>CORP</code>. If you don't specify a NetBIOS name, it will default to the first part of your directory DNS. For example, <code>CORP</code> for the directory DNS <code>corp.example.com</code>. </p>
    ///   - [`password(impl Into<String>)`](crate::client::fluent_builders::CreateMicrosoftAD::password) / [`set_password(Option<String>)`](crate::client::fluent_builders::CreateMicrosoftAD::set_password): <p>The password for the default administrative user named <code>Admin</code>.</p>  <p>If you need to change the password for the administrator account, you can use the <code>ResetUserPassword</code> API call.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateMicrosoftAD::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateMicrosoftAD::set_description): <p>A description for the directory. This label will appear on the Amazon Web Services console <code>Directory Details</code> page after the directory is created.</p>
    ///   - [`vpc_settings(DirectoryVpcSettings)`](crate::client::fluent_builders::CreateMicrosoftAD::vpc_settings) / [`set_vpc_settings(Option<DirectoryVpcSettings>)`](crate::client::fluent_builders::CreateMicrosoftAD::set_vpc_settings): <p>Contains VPC information for the <code>CreateDirectory</code> or <code>CreateMicrosoftAD</code> operation.</p>
    ///   - [`edition(DirectoryEdition)`](crate::client::fluent_builders::CreateMicrosoftAD::edition) / [`set_edition(Option<DirectoryEdition>)`](crate::client::fluent_builders::CreateMicrosoftAD::set_edition): <p>Managed Microsoft AD is available in two editions: <code>Standard</code> and <code>Enterprise</code>. <code>Enterprise</code> is the default.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateMicrosoftAD::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateMicrosoftAD::set_tags): <p>The tags to be assigned to the Managed Microsoft AD directory.</p>
    /// - On success, responds with [`CreateMicrosoftAdOutput`](crate::output::CreateMicrosoftAdOutput) with field(s):
    ///   - [`directory_id(Option<String>)`](crate::output::CreateMicrosoftAdOutput::directory_id): <p>The identifier of the directory that was created.</p>
    /// - On failure, responds with [`SdkError<CreateMicrosoftADError>`](crate::error::CreateMicrosoftADError)
    pub fn create_microsoft_ad(&self) -> fluent_builders::CreateMicrosoftAD<C, M, R> {
        fluent_builders::CreateMicrosoftAD::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSnapshot`](crate::client::fluent_builders::CreateSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::CreateSnapshot::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::CreateSnapshot::set_directory_id): <p>The identifier of the directory of which to take a snapshot.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateSnapshot::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateSnapshot::set_name): <p>The descriptive name to apply to the snapshot.</p>
    /// - On success, responds with [`CreateSnapshotOutput`](crate::output::CreateSnapshotOutput) with field(s):
    ///   - [`snapshot_id(Option<String>)`](crate::output::CreateSnapshotOutput::snapshot_id): <p>The identifier of the snapshot that was created.</p>
    /// - On failure, responds with [`SdkError<CreateSnapshotError>`](crate::error::CreateSnapshotError)
    pub fn create_snapshot(&self) -> fluent_builders::CreateSnapshot<C, M, R> {
        fluent_builders::CreateSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTrust`](crate::client::fluent_builders::CreateTrust) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::CreateTrust::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::CreateTrust::set_directory_id): <p>The Directory ID of the Managed Microsoft AD directory for which to establish the trust relationship.</p>
    ///   - [`remote_domain_name(impl Into<String>)`](crate::client::fluent_builders::CreateTrust::remote_domain_name) / [`set_remote_domain_name(Option<String>)`](crate::client::fluent_builders::CreateTrust::set_remote_domain_name): <p>The Fully Qualified Domain Name (FQDN) of the external domain for which to create the trust relationship.</p>
    ///   - [`trust_password(impl Into<String>)`](crate::client::fluent_builders::CreateTrust::trust_password) / [`set_trust_password(Option<String>)`](crate::client::fluent_builders::CreateTrust::set_trust_password): <p>The trust password. The must be the same password that was used when creating the trust relationship on the external domain.</p>
    ///   - [`trust_direction(TrustDirection)`](crate::client::fluent_builders::CreateTrust::trust_direction) / [`set_trust_direction(Option<TrustDirection>)`](crate::client::fluent_builders::CreateTrust::set_trust_direction): <p>The direction of the trust relationship.</p>
    ///   - [`trust_type(TrustType)`](crate::client::fluent_builders::CreateTrust::trust_type) / [`set_trust_type(Option<TrustType>)`](crate::client::fluent_builders::CreateTrust::set_trust_type): <p>The trust relationship type. <code>Forest</code> is the default.</p>
    ///   - [`conditional_forwarder_ip_addrs(Vec<String>)`](crate::client::fluent_builders::CreateTrust::conditional_forwarder_ip_addrs) / [`set_conditional_forwarder_ip_addrs(Option<Vec<String>>)`](crate::client::fluent_builders::CreateTrust::set_conditional_forwarder_ip_addrs): <p>The IP addresses of the remote DNS server associated with RemoteDomainName.</p>
    ///   - [`selective_auth(SelectiveAuth)`](crate::client::fluent_builders::CreateTrust::selective_auth) / [`set_selective_auth(Option<SelectiveAuth>)`](crate::client::fluent_builders::CreateTrust::set_selective_auth): <p>Optional parameter to enable selective authentication for the trust.</p>
    /// - On success, responds with [`CreateTrustOutput`](crate::output::CreateTrustOutput) with field(s):
    ///   - [`trust_id(Option<String>)`](crate::output::CreateTrustOutput::trust_id): <p>A unique identifier for the trust relationship that was created.</p>
    /// - On failure, responds with [`SdkError<CreateTrustError>`](crate::error::CreateTrustError)
    pub fn create_trust(&self) -> fluent_builders::CreateTrust<C, M, R> {
        fluent_builders::CreateTrust::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteConditionalForwarder`](crate::client::fluent_builders::DeleteConditionalForwarder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::DeleteConditionalForwarder::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::DeleteConditionalForwarder::set_directory_id): <p>The directory ID for which you are deleting the conditional forwarder.</p>
    ///   - [`remote_domain_name(impl Into<String>)`](crate::client::fluent_builders::DeleteConditionalForwarder::remote_domain_name) / [`set_remote_domain_name(Option<String>)`](crate::client::fluent_builders::DeleteConditionalForwarder::set_remote_domain_name): <p>The fully qualified domain name (FQDN) of the remote domain with which you are deleting the conditional forwarder.</p>
    /// - On success, responds with [`DeleteConditionalForwarderOutput`](crate::output::DeleteConditionalForwarderOutput)

    /// - On failure, responds with [`SdkError<DeleteConditionalForwarderError>`](crate::error::DeleteConditionalForwarderError)
    pub fn delete_conditional_forwarder(
        &self,
    ) -> fluent_builders::DeleteConditionalForwarder<C, M, R> {
        fluent_builders::DeleteConditionalForwarder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDirectory`](crate::client::fluent_builders::DeleteDirectory) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDirectory::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::DeleteDirectory::set_directory_id): <p>The identifier of the directory to delete.</p>
    /// - On success, responds with [`DeleteDirectoryOutput`](crate::output::DeleteDirectoryOutput) with field(s):
    ///   - [`directory_id(Option<String>)`](crate::output::DeleteDirectoryOutput::directory_id): <p>The directory identifier.</p>
    /// - On failure, responds with [`SdkError<DeleteDirectoryError>`](crate::error::DeleteDirectoryError)
    pub fn delete_directory(&self) -> fluent_builders::DeleteDirectory<C, M, R> {
        fluent_builders::DeleteDirectory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteLogSubscription`](crate::client::fluent_builders::DeleteLogSubscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::DeleteLogSubscription::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::DeleteLogSubscription::set_directory_id): <p>Identifier of the directory whose log subscription you want to delete.</p>
    /// - On success, responds with [`DeleteLogSubscriptionOutput`](crate::output::DeleteLogSubscriptionOutput)

    /// - On failure, responds with [`SdkError<DeleteLogSubscriptionError>`](crate::error::DeleteLogSubscriptionError)
    pub fn delete_log_subscription(&self) -> fluent_builders::DeleteLogSubscription<C, M, R> {
        fluent_builders::DeleteLogSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSnapshot`](crate::client::fluent_builders::DeleteSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`snapshot_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSnapshot::snapshot_id) / [`set_snapshot_id(Option<String>)`](crate::client::fluent_builders::DeleteSnapshot::set_snapshot_id): <p>The identifier of the directory snapshot to be deleted.</p>
    /// - On success, responds with [`DeleteSnapshotOutput`](crate::output::DeleteSnapshotOutput) with field(s):
    ///   - [`snapshot_id(Option<String>)`](crate::output::DeleteSnapshotOutput::snapshot_id): <p>The identifier of the directory snapshot that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteSnapshotError>`](crate::error::DeleteSnapshotError)
    pub fn delete_snapshot(&self) -> fluent_builders::DeleteSnapshot<C, M, R> {
        fluent_builders::DeleteSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTrust`](crate::client::fluent_builders::DeleteTrust) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`trust_id(impl Into<String>)`](crate::client::fluent_builders::DeleteTrust::trust_id) / [`set_trust_id(Option<String>)`](crate::client::fluent_builders::DeleteTrust::set_trust_id): <p>The Trust ID of the trust relationship to be deleted.</p>
    ///   - [`delete_associated_conditional_forwarder(bool)`](crate::client::fluent_builders::DeleteTrust::delete_associated_conditional_forwarder) / [`set_delete_associated_conditional_forwarder(bool)`](crate::client::fluent_builders::DeleteTrust::set_delete_associated_conditional_forwarder): <p>Delete a conditional forwarder as part of a DeleteTrustRequest.</p>
    /// - On success, responds with [`DeleteTrustOutput`](crate::output::DeleteTrustOutput) with field(s):
    ///   - [`trust_id(Option<String>)`](crate::output::DeleteTrustOutput::trust_id): <p>The Trust ID of the trust relationship that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteTrustError>`](crate::error::DeleteTrustError)
    pub fn delete_trust(&self) -> fluent_builders::DeleteTrust<C, M, R> {
        fluent_builders::DeleteTrust::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeregisterCertificate`](crate::client::fluent_builders::DeregisterCertificate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::DeregisterCertificate::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::DeregisterCertificate::set_directory_id): <p>The identifier of the directory.</p>
    ///   - [`certificate_id(impl Into<String>)`](crate::client::fluent_builders::DeregisterCertificate::certificate_id) / [`set_certificate_id(Option<String>)`](crate::client::fluent_builders::DeregisterCertificate::set_certificate_id): <p>The identifier of the certificate.</p>
    /// - On success, responds with [`DeregisterCertificateOutput`](crate::output::DeregisterCertificateOutput)

    /// - On failure, responds with [`SdkError<DeregisterCertificateError>`](crate::error::DeregisterCertificateError)
    pub fn deregister_certificate(&self) -> fluent_builders::DeregisterCertificate<C, M, R> {
        fluent_builders::DeregisterCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeregisterEventTopic`](crate::client::fluent_builders::DeregisterEventTopic) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::DeregisterEventTopic::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::DeregisterEventTopic::set_directory_id): <p>The Directory ID to remove as a publisher. This directory will no longer send messages to the specified Amazon SNS topic.</p>
    ///   - [`topic_name(impl Into<String>)`](crate::client::fluent_builders::DeregisterEventTopic::topic_name) / [`set_topic_name(Option<String>)`](crate::client::fluent_builders::DeregisterEventTopic::set_topic_name): <p>The name of the Amazon SNS topic from which to remove the directory as a publisher.</p>
    /// - On success, responds with [`DeregisterEventTopicOutput`](crate::output::DeregisterEventTopicOutput)

    /// - On failure, responds with [`SdkError<DeregisterEventTopicError>`](crate::error::DeregisterEventTopicError)
    pub fn deregister_event_topic(&self) -> fluent_builders::DeregisterEventTopic<C, M, R> {
        fluent_builders::DeregisterEventTopic::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCertificate`](crate::client::fluent_builders::DescribeCertificate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::DescribeCertificate::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::DescribeCertificate::set_directory_id): <p>The identifier of the directory.</p>
    ///   - [`certificate_id(impl Into<String>)`](crate::client::fluent_builders::DescribeCertificate::certificate_id) / [`set_certificate_id(Option<String>)`](crate::client::fluent_builders::DescribeCertificate::set_certificate_id): <p>The identifier of the certificate.</p>
    /// - On success, responds with [`DescribeCertificateOutput`](crate::output::DescribeCertificateOutput) with field(s):
    ///   - [`certificate(Option<Certificate>)`](crate::output::DescribeCertificateOutput::certificate): <p>Information about the certificate, including registered date time, certificate state, the reason for the state, expiration date time, and certificate common name.</p>
    /// - On failure, responds with [`SdkError<DescribeCertificateError>`](crate::error::DescribeCertificateError)
    pub fn describe_certificate(&self) -> fluent_builders::DescribeCertificate<C, M, R> {
        fluent_builders::DescribeCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeClientAuthenticationSettings`](crate::client::fluent_builders::DescribeClientAuthenticationSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::DescribeClientAuthenticationSettings::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::DescribeClientAuthenticationSettings::set_directory_id): <p>The identifier of the directory for which to retrieve information.</p>
    ///   - [`r#type(ClientAuthenticationType)`](crate::client::fluent_builders::DescribeClientAuthenticationSettings::r#type) / [`set_type(Option<ClientAuthenticationType>)`](crate::client::fluent_builders::DescribeClientAuthenticationSettings::set_type): <p>The type of client authentication for which to retrieve information. If no type is specified, a list of all client authentication types that are supported for the specified directory is retrieved.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeClientAuthenticationSettings::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeClientAuthenticationSettings::set_next_token): <p>The <i>DescribeClientAuthenticationSettingsResult.NextToken</i> value from a previous call to <code>DescribeClientAuthenticationSettings</code>. Pass null if this is the first call.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeClientAuthenticationSettings::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeClientAuthenticationSettings::set_limit): <p>The maximum number of items to return. If this value is zero, the maximum number of items is specified by the limitations of the operation. </p>
    /// - On success, responds with [`DescribeClientAuthenticationSettingsOutput`](crate::output::DescribeClientAuthenticationSettingsOutput) with field(s):
    ///   - [`client_authentication_settings_info(Option<Vec<ClientAuthenticationSettingInfo>>)`](crate::output::DescribeClientAuthenticationSettingsOutput::client_authentication_settings_info): <p>Information about the type of client authentication for the specified directory. The following information is retrieved: The date and time when the status of the client authentication type was last updated, whether the client authentication type is enabled or disabled, and the type of client authentication.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeClientAuthenticationSettingsOutput::next_token): <p>The next token used to retrieve the client authentication settings if the number of setting types exceeds page limit and there is another page.</p>
    /// - On failure, responds with [`SdkError<DescribeClientAuthenticationSettingsError>`](crate::error::DescribeClientAuthenticationSettingsError)
    pub fn describe_client_authentication_settings(
        &self,
    ) -> fluent_builders::DescribeClientAuthenticationSettings<C, M, R> {
        fluent_builders::DescribeClientAuthenticationSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeConditionalForwarders`](crate::client::fluent_builders::DescribeConditionalForwarders) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::DescribeConditionalForwarders::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::DescribeConditionalForwarders::set_directory_id): <p>The directory ID for which to get the list of associated conditional forwarders.</p>
    ///   - [`remote_domain_names(Vec<String>)`](crate::client::fluent_builders::DescribeConditionalForwarders::remote_domain_names) / [`set_remote_domain_names(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeConditionalForwarders::set_remote_domain_names): <p>The fully qualified domain names (FQDN) of the remote domains for which to get the list of associated conditional forwarders. If this member is null, all conditional forwarders are returned.</p>
    /// - On success, responds with [`DescribeConditionalForwardersOutput`](crate::output::DescribeConditionalForwardersOutput) with field(s):
    ///   - [`conditional_forwarders(Option<Vec<ConditionalForwarder>>)`](crate::output::DescribeConditionalForwardersOutput::conditional_forwarders): <p>The list of conditional forwarders that have been created.</p>
    /// - On failure, responds with [`SdkError<DescribeConditionalForwardersError>`](crate::error::DescribeConditionalForwardersError)
    pub fn describe_conditional_forwarders(
        &self,
    ) -> fluent_builders::DescribeConditionalForwarders<C, M, R> {
        fluent_builders::DescribeConditionalForwarders::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDirectories`](crate::client::fluent_builders::DescribeDirectories) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_ids(Vec<String>)`](crate::client::fluent_builders::DescribeDirectories::directory_ids) / [`set_directory_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeDirectories::set_directory_ids): <p>A list of identifiers of the directories for which to obtain the information. If this member is null, all directories that belong to the current account are returned.</p>  <p>An empty list results in an <code>InvalidParameterException</code> being thrown.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeDirectories::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeDirectories::set_next_token): <p>The <code>DescribeDirectoriesResult.NextToken</code> value from a previous call to <code>DescribeDirectories</code>. Pass null if this is the first call.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeDirectories::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeDirectories::set_limit): <p>The maximum number of items to return. If this value is zero, the maximum number of items is specified by the limitations of the operation.</p>
    /// - On success, responds with [`DescribeDirectoriesOutput`](crate::output::DescribeDirectoriesOutput) with field(s):
    ///   - [`directory_descriptions(Option<Vec<DirectoryDescription>>)`](crate::output::DescribeDirectoriesOutput::directory_descriptions): <p>The list of <code>DirectoryDescription</code> objects that were retrieved.</p>  <p>It is possible that this list contains less than the number of items specified in the <code>Limit</code> member of the request. This occurs if there are less than the requested number of items left to retrieve, or if the limitations of the operation have been exceeded.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeDirectoriesOutput::next_token): <p>If not null, more results are available. Pass this value for the <code>NextToken</code> parameter in a subsequent call to <code>DescribeDirectories</code> to retrieve the next set of items.</p>
    /// - On failure, responds with [`SdkError<DescribeDirectoriesError>`](crate::error::DescribeDirectoriesError)
    pub fn describe_directories(&self) -> fluent_builders::DescribeDirectories<C, M, R> {
        fluent_builders::DescribeDirectories::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDomainControllers`](crate::client::fluent_builders::DescribeDomainControllers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDomainControllers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDomainControllers::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::DescribeDomainControllers::set_directory_id): <p>Identifier of the directory for which to retrieve the domain controller information.</p>
    ///   - [`domain_controller_ids(Vec<String>)`](crate::client::fluent_builders::DescribeDomainControllers::domain_controller_ids) / [`set_domain_controller_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeDomainControllers::set_domain_controller_ids): <p>A list of identifiers for the domain controllers whose information will be provided.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeDomainControllers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeDomainControllers::set_next_token): <p>The <i>DescribeDomainControllers.NextToken</i> value from a previous call to <code>DescribeDomainControllers</code>. Pass null if this is the first call. </p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeDomainControllers::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeDomainControllers::set_limit): <p>The maximum number of items to return.</p>
    /// - On success, responds with [`DescribeDomainControllersOutput`](crate::output::DescribeDomainControllersOutput) with field(s):
    ///   - [`domain_controllers(Option<Vec<DomainController>>)`](crate::output::DescribeDomainControllersOutput::domain_controllers): <p>List of the <code>DomainController</code> objects that were retrieved.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeDomainControllersOutput::next_token): <p>If not null, more results are available. Pass this value for the <code>NextToken</code> parameter in a subsequent call to <code>DescribeDomainControllers</code> retrieve the next set of items.</p>
    /// - On failure, responds with [`SdkError<DescribeDomainControllersError>`](crate::error::DescribeDomainControllersError)
    pub fn describe_domain_controllers(
        &self,
    ) -> fluent_builders::DescribeDomainControllers<C, M, R> {
        fluent_builders::DescribeDomainControllers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEventTopics`](crate::client::fluent_builders::DescribeEventTopics) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::DescribeEventTopics::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::DescribeEventTopics::set_directory_id): <p>The Directory ID for which to get the list of associated Amazon SNS topics. If this member is null, associations for all Directory IDs are returned.</p>
    ///   - [`topic_names(Vec<String>)`](crate::client::fluent_builders::DescribeEventTopics::topic_names) / [`set_topic_names(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeEventTopics::set_topic_names): <p>A list of Amazon SNS topic names for which to obtain the information. If this member is null, all associations for the specified Directory ID are returned.</p>  <p>An empty list results in an <code>InvalidParameterException</code> being thrown.</p>
    /// - On success, responds with [`DescribeEventTopicsOutput`](crate::output::DescribeEventTopicsOutput) with field(s):
    ///   - [`event_topics(Option<Vec<EventTopic>>)`](crate::output::DescribeEventTopicsOutput::event_topics): <p>A list of Amazon SNS topic names that receive status messages from the specified Directory ID.</p>
    /// - On failure, responds with [`SdkError<DescribeEventTopicsError>`](crate::error::DescribeEventTopicsError)
    pub fn describe_event_topics(&self) -> fluent_builders::DescribeEventTopics<C, M, R> {
        fluent_builders::DescribeEventTopics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLDAPSSettings`](crate::client::fluent_builders::DescribeLDAPSSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::DescribeLDAPSSettings::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::DescribeLDAPSSettings::set_directory_id): <p>The identifier of the directory.</p>
    ///   - [`r#type(LdapsType)`](crate::client::fluent_builders::DescribeLDAPSSettings::r#type) / [`set_type(Option<LdapsType>)`](crate::client::fluent_builders::DescribeLDAPSSettings::set_type): <p>The type of LDAP security to enable. Currently only the value <code>Client</code> is supported.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeLDAPSSettings::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeLDAPSSettings::set_next_token): <p>The type of next token used for pagination.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeLDAPSSettings::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeLDAPSSettings::set_limit): <p>Specifies the number of items that should be displayed on one page.</p>
    /// - On success, responds with [`DescribeLdapsSettingsOutput`](crate::output::DescribeLdapsSettingsOutput) with field(s):
    ///   - [`ldaps_settings_info(Option<Vec<LdapsSettingInfo>>)`](crate::output::DescribeLdapsSettingsOutput::ldaps_settings_info): <p>Information about LDAP security for the specified directory, including status of enablement, state last updated date time, and the reason for the state.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeLdapsSettingsOutput::next_token): <p>The next token used to retrieve the LDAPS settings if the number of setting types exceeds page limit and there is another page.</p>
    /// - On failure, responds with [`SdkError<DescribeLDAPSSettingsError>`](crate::error::DescribeLDAPSSettingsError)
    pub fn describe_ldaps_settings(&self) -> fluent_builders::DescribeLDAPSSettings<C, M, R> {
        fluent_builders::DescribeLDAPSSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeRegions`](crate::client::fluent_builders::DescribeRegions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::DescribeRegions::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::DescribeRegions::set_directory_id): <p>The identifier of the directory.</p>
    ///   - [`region_name(impl Into<String>)`](crate::client::fluent_builders::DescribeRegions::region_name) / [`set_region_name(Option<String>)`](crate::client::fluent_builders::DescribeRegions::set_region_name): <p>The name of the Region. For example, <code>us-east-1</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeRegions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeRegions::set_next_token): <p>The <code>DescribeRegionsResult.NextToken</code> value from a previous call to <code>DescribeRegions</code>. Pass null if this is the first call.</p>
    /// - On success, responds with [`DescribeRegionsOutput`](crate::output::DescribeRegionsOutput) with field(s):
    ///   - [`regions_description(Option<Vec<RegionDescription>>)`](crate::output::DescribeRegionsOutput::regions_description): <p>List of Region information related to the directory for each replicated Region.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeRegionsOutput::next_token): <p>If not null, more results are available. Pass this value for the <code>NextToken</code> parameter in a subsequent call to <code>DescribeRegions</code> to retrieve the next set of items.</p>
    /// - On failure, responds with [`SdkError<DescribeRegionsError>`](crate::error::DescribeRegionsError)
    pub fn describe_regions(&self) -> fluent_builders::DescribeRegions<C, M, R> {
        fluent_builders::DescribeRegions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSharedDirectories`](crate::client::fluent_builders::DescribeSharedDirectories) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`owner_directory_id(impl Into<String>)`](crate::client::fluent_builders::DescribeSharedDirectories::owner_directory_id) / [`set_owner_directory_id(Option<String>)`](crate::client::fluent_builders::DescribeSharedDirectories::set_owner_directory_id): <p>Returns the identifier of the directory in the directory owner account. </p>
    ///   - [`shared_directory_ids(Vec<String>)`](crate::client::fluent_builders::DescribeSharedDirectories::shared_directory_ids) / [`set_shared_directory_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeSharedDirectories::set_shared_directory_ids): <p>A list of identifiers of all shared directories in your account. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeSharedDirectories::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeSharedDirectories::set_next_token): <p>The <code>DescribeSharedDirectoriesResult.NextToken</code> value from a previous call to <code>DescribeSharedDirectories</code>. Pass null if this is the first call. </p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeSharedDirectories::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeSharedDirectories::set_limit): <p>The number of shared directories to return in the response object.</p>
    /// - On success, responds with [`DescribeSharedDirectoriesOutput`](crate::output::DescribeSharedDirectoriesOutput) with field(s):
    ///   - [`shared_directories(Option<Vec<SharedDirectory>>)`](crate::output::DescribeSharedDirectoriesOutput::shared_directories): <p>A list of all shared directories in your account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeSharedDirectoriesOutput::next_token): <p>If not null, token that indicates that more results are available. Pass this value for the <code>NextToken</code> parameter in a subsequent call to <code>DescribeSharedDirectories</code> to retrieve the next set of items.</p>
    /// - On failure, responds with [`SdkError<DescribeSharedDirectoriesError>`](crate::error::DescribeSharedDirectoriesError)
    pub fn describe_shared_directories(
        &self,
    ) -> fluent_builders::DescribeSharedDirectories<C, M, R> {
        fluent_builders::DescribeSharedDirectories::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSnapshots`](crate::client::fluent_builders::DescribeSnapshots) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::DescribeSnapshots::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::DescribeSnapshots::set_directory_id): <p>The identifier of the directory for which to retrieve snapshot information.</p>
    ///   - [`snapshot_ids(Vec<String>)`](crate::client::fluent_builders::DescribeSnapshots::snapshot_ids) / [`set_snapshot_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeSnapshots::set_snapshot_ids): <p>A list of identifiers of the snapshots to obtain the information for. If this member is null or empty, all snapshots are returned using the <i>Limit</i> and <i>NextToken</i> members.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeSnapshots::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeSnapshots::set_next_token): <p>The <i>DescribeSnapshotsResult.NextToken</i> value from a previous call to <code>DescribeSnapshots</code>. Pass null if this is the first call.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeSnapshots::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeSnapshots::set_limit): <p>The maximum number of objects to return.</p>
    /// - On success, responds with [`DescribeSnapshotsOutput`](crate::output::DescribeSnapshotsOutput) with field(s):
    ///   - [`snapshots(Option<Vec<Snapshot>>)`](crate::output::DescribeSnapshotsOutput::snapshots): <p>The list of <code>Snapshot</code> objects that were retrieved.</p>  <p>It is possible that this list contains less than the number of items specified in the <i>Limit</i> member of the request. This occurs if there are less than the requested number of items left to retrieve, or if the limitations of the operation have been exceeded.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeSnapshotsOutput::next_token): <p>If not null, more results are available. Pass this value in the <i>NextToken</i> member of a subsequent call to <code>DescribeSnapshots</code>.</p>
    /// - On failure, responds with [`SdkError<DescribeSnapshotsError>`](crate::error::DescribeSnapshotsError)
    pub fn describe_snapshots(&self) -> fluent_builders::DescribeSnapshots<C, M, R> {
        fluent_builders::DescribeSnapshots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTrusts`](crate::client::fluent_builders::DescribeTrusts) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::DescribeTrusts::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::DescribeTrusts::set_directory_id): <p>The Directory ID of the Amazon Web Services directory that is a part of the requested trust relationship.</p>
    ///   - [`trust_ids(Vec<String>)`](crate::client::fluent_builders::DescribeTrusts::trust_ids) / [`set_trust_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeTrusts::set_trust_ids): <p>A list of identifiers of the trust relationships for which to obtain the information. If this member is null, all trust relationships that belong to the current account are returned.</p>  <p>An empty list results in an <code>InvalidParameterException</code> being thrown.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeTrusts::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeTrusts::set_next_token): <p>The <i>DescribeTrustsResult.NextToken</i> value from a previous call to <code>DescribeTrusts</code>. Pass null if this is the first call.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeTrusts::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeTrusts::set_limit): <p>The maximum number of objects to return.</p>
    /// - On success, responds with [`DescribeTrustsOutput`](crate::output::DescribeTrustsOutput) with field(s):
    ///   - [`trusts(Option<Vec<Trust>>)`](crate::output::DescribeTrustsOutput::trusts): <p>The list of Trust objects that were retrieved.</p>  <p>It is possible that this list contains less than the number of items specified in the <i>Limit</i> member of the request. This occurs if there are less than the requested number of items left to retrieve, or if the limitations of the operation have been exceeded.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeTrustsOutput::next_token): <p>If not null, more results are available. Pass this value for the <i>NextToken</i> parameter in a subsequent call to <code>DescribeTrusts</code> to retrieve the next set of items.</p>
    /// - On failure, responds with [`SdkError<DescribeTrustsError>`](crate::error::DescribeTrustsError)
    pub fn describe_trusts(&self) -> fluent_builders::DescribeTrusts<C, M, R> {
        fluent_builders::DescribeTrusts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisableClientAuthentication`](crate::client::fluent_builders::DisableClientAuthentication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::DisableClientAuthentication::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::DisableClientAuthentication::set_directory_id): <p>The identifier of the directory </p>
    ///   - [`r#type(ClientAuthenticationType)`](crate::client::fluent_builders::DisableClientAuthentication::r#type) / [`set_type(Option<ClientAuthenticationType>)`](crate::client::fluent_builders::DisableClientAuthentication::set_type): <p>The type of client authentication to disable. Currently, only the parameter, <code>SmartCard</code> is supported.</p>
    /// - On success, responds with [`DisableClientAuthenticationOutput`](crate::output::DisableClientAuthenticationOutput)

    /// - On failure, responds with [`SdkError<DisableClientAuthenticationError>`](crate::error::DisableClientAuthenticationError)
    pub fn disable_client_authentication(
        &self,
    ) -> fluent_builders::DisableClientAuthentication<C, M, R> {
        fluent_builders::DisableClientAuthentication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisableLDAPS`](crate::client::fluent_builders::DisableLDAPS) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::DisableLDAPS::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::DisableLDAPS::set_directory_id): <p>The identifier of the directory.</p>
    ///   - [`r#type(LdapsType)`](crate::client::fluent_builders::DisableLDAPS::r#type) / [`set_type(Option<LdapsType>)`](crate::client::fluent_builders::DisableLDAPS::set_type): <p>The type of LDAP security to enable. Currently only the value <code>Client</code> is supported.</p>
    /// - On success, responds with [`DisableLdapsOutput`](crate::output::DisableLdapsOutput)

    /// - On failure, responds with [`SdkError<DisableLDAPSError>`](crate::error::DisableLDAPSError)
    pub fn disable_ldaps(&self) -> fluent_builders::DisableLDAPS<C, M, R> {
        fluent_builders::DisableLDAPS::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisableRadius`](crate::client::fluent_builders::DisableRadius) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::DisableRadius::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::DisableRadius::set_directory_id): <p>The identifier of the directory for which to disable MFA.</p>
    /// - On success, responds with [`DisableRadiusOutput`](crate::output::DisableRadiusOutput)

    /// - On failure, responds with [`SdkError<DisableRadiusError>`](crate::error::DisableRadiusError)
    pub fn disable_radius(&self) -> fluent_builders::DisableRadius<C, M, R> {
        fluent_builders::DisableRadius::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisableSso`](crate::client::fluent_builders::DisableSso) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::DisableSso::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::DisableSso::set_directory_id): <p>The identifier of the directory for which to disable single-sign on.</p>
    ///   - [`user_name(impl Into<String>)`](crate::client::fluent_builders::DisableSso::user_name) / [`set_user_name(Option<String>)`](crate::client::fluent_builders::DisableSso::set_user_name): <p>The username of an alternate account to use to disable single-sign on. This is only used for AD Connector directories. This account must have privileges to remove a service principal name.</p>  <p>If the AD Connector service account does not have privileges to remove a service principal name, you can specify an alternate account with the <i>UserName</i> and <i>Password</i> parameters. These credentials are only used to disable single sign-on and are not stored by the service. The AD Connector service account is not changed.</p>
    ///   - [`password(impl Into<String>)`](crate::client::fluent_builders::DisableSso::password) / [`set_password(Option<String>)`](crate::client::fluent_builders::DisableSso::set_password): <p>The password of an alternate account to use to disable single-sign on. This is only used for AD Connector directories. For more information, see the <i>UserName</i> parameter.</p>
    /// - On success, responds with [`DisableSsoOutput`](crate::output::DisableSsoOutput)

    /// - On failure, responds with [`SdkError<DisableSsoError>`](crate::error::DisableSsoError)
    pub fn disable_sso(&self) -> fluent_builders::DisableSso<C, M, R> {
        fluent_builders::DisableSso::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EnableClientAuthentication`](crate::client::fluent_builders::EnableClientAuthentication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::EnableClientAuthentication::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::EnableClientAuthentication::set_directory_id): <p>The identifier of the specified directory. </p>
    ///   - [`r#type(ClientAuthenticationType)`](crate::client::fluent_builders::EnableClientAuthentication::r#type) / [`set_type(Option<ClientAuthenticationType>)`](crate::client::fluent_builders::EnableClientAuthentication::set_type): <p>The type of client authentication to enable. Currently only the value <code>SmartCard</code> is supported. Smart card authentication in AD Connector requires that you enable Kerberos Constrained Delegation for the Service User to the LDAP service in your self-managed AD. </p>
    /// - On success, responds with [`EnableClientAuthenticationOutput`](crate::output::EnableClientAuthenticationOutput)

    /// - On failure, responds with [`SdkError<EnableClientAuthenticationError>`](crate::error::EnableClientAuthenticationError)
    pub fn enable_client_authentication(
        &self,
    ) -> fluent_builders::EnableClientAuthentication<C, M, R> {
        fluent_builders::EnableClientAuthentication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EnableLDAPS`](crate::client::fluent_builders::EnableLDAPS) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::EnableLDAPS::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::EnableLDAPS::set_directory_id): <p>The identifier of the directory.</p>
    ///   - [`r#type(LdapsType)`](crate::client::fluent_builders::EnableLDAPS::r#type) / [`set_type(Option<LdapsType>)`](crate::client::fluent_builders::EnableLDAPS::set_type): <p>The type of LDAP security to enable. Currently only the value <code>Client</code> is supported.</p>
    /// - On success, responds with [`EnableLdapsOutput`](crate::output::EnableLdapsOutput)

    /// - On failure, responds with [`SdkError<EnableLDAPSError>`](crate::error::EnableLDAPSError)
    pub fn enable_ldaps(&self) -> fluent_builders::EnableLDAPS<C, M, R> {
        fluent_builders::EnableLDAPS::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EnableRadius`](crate::client::fluent_builders::EnableRadius) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::EnableRadius::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::EnableRadius::set_directory_id): <p>The identifier of the directory for which to enable MFA.</p>
    ///   - [`radius_settings(RadiusSettings)`](crate::client::fluent_builders::EnableRadius::radius_settings) / [`set_radius_settings(Option<RadiusSettings>)`](crate::client::fluent_builders::EnableRadius::set_radius_settings): <p>A <code>RadiusSettings</code> object that contains information about the RADIUS server.</p>
    /// - On success, responds with [`EnableRadiusOutput`](crate::output::EnableRadiusOutput)

    /// - On failure, responds with [`SdkError<EnableRadiusError>`](crate::error::EnableRadiusError)
    pub fn enable_radius(&self) -> fluent_builders::EnableRadius<C, M, R> {
        fluent_builders::EnableRadius::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EnableSso`](crate::client::fluent_builders::EnableSso) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::EnableSso::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::EnableSso::set_directory_id): <p>The identifier of the directory for which to enable single-sign on.</p>
    ///   - [`user_name(impl Into<String>)`](crate::client::fluent_builders::EnableSso::user_name) / [`set_user_name(Option<String>)`](crate::client::fluent_builders::EnableSso::set_user_name): <p>The username of an alternate account to use to enable single-sign on. This is only used for AD Connector directories. This account must have privileges to add a service principal name.</p>  <p>If the AD Connector service account does not have privileges to add a service principal name, you can specify an alternate account with the <i>UserName</i> and <i>Password</i> parameters. These credentials are only used to enable single sign-on and are not stored by the service. The AD Connector service account is not changed.</p>
    ///   - [`password(impl Into<String>)`](crate::client::fluent_builders::EnableSso::password) / [`set_password(Option<String>)`](crate::client::fluent_builders::EnableSso::set_password): <p>The password of an alternate account to use to enable single-sign on. This is only used for AD Connector directories. For more information, see the <i>UserName</i> parameter.</p>
    /// - On success, responds with [`EnableSsoOutput`](crate::output::EnableSsoOutput)

    /// - On failure, responds with [`SdkError<EnableSsoError>`](crate::error::EnableSsoError)
    pub fn enable_sso(&self) -> fluent_builders::EnableSso<C, M, R> {
        fluent_builders::EnableSso::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDirectoryLimits`](crate::client::fluent_builders::GetDirectoryLimits) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetDirectoryLimits::send) it.

    /// - On success, responds with [`GetDirectoryLimitsOutput`](crate::output::GetDirectoryLimitsOutput) with field(s):
    ///   - [`directory_limits(Option<DirectoryLimits>)`](crate::output::GetDirectoryLimitsOutput::directory_limits): <p>A <code>DirectoryLimits</code> object that contains the directory limits for the current Region.</p>
    /// - On failure, responds with [`SdkError<GetDirectoryLimitsError>`](crate::error::GetDirectoryLimitsError)
    pub fn get_directory_limits(&self) -> fluent_builders::GetDirectoryLimits<C, M, R> {
        fluent_builders::GetDirectoryLimits::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSnapshotLimits`](crate::client::fluent_builders::GetSnapshotLimits) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::GetSnapshotLimits::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::GetSnapshotLimits::set_directory_id): <p>Contains the identifier of the directory to obtain the limits for.</p>
    /// - On success, responds with [`GetSnapshotLimitsOutput`](crate::output::GetSnapshotLimitsOutput) with field(s):
    ///   - [`snapshot_limits(Option<SnapshotLimits>)`](crate::output::GetSnapshotLimitsOutput::snapshot_limits): <p>A <code>SnapshotLimits</code> object that contains the manual snapshot limits for the specified directory.</p>
    /// - On failure, responds with [`SdkError<GetSnapshotLimitsError>`](crate::error::GetSnapshotLimitsError)
    pub fn get_snapshot_limits(&self) -> fluent_builders::GetSnapshotLimits<C, M, R> {
        fluent_builders::GetSnapshotLimits::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCertificates`](crate::client::fluent_builders::ListCertificates) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::ListCertificates::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::ListCertificates::set_directory_id): <p>The identifier of the directory.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListCertificates::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListCertificates::set_next_token): <p>A token for requesting another page of certificates if the <code>NextToken</code> response element indicates that more certificates are available. Use the value of the returned <code>NextToken</code> element in your request until the token comes back as <code>null</code>. Pass <code>null</code> if this is the first call.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListCertificates::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListCertificates::set_limit): <p>The number of items that should show up on one page</p>
    /// - On success, responds with [`ListCertificatesOutput`](crate::output::ListCertificatesOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListCertificatesOutput::next_token): <p>Indicates whether another page of certificates is available when the number of available certificates exceeds the page limit.</p>
    ///   - [`certificates_info(Option<Vec<CertificateInfo>>)`](crate::output::ListCertificatesOutput::certificates_info): <p>A list of certificates with basic details including certificate ID, certificate common name, certificate state.</p>
    /// - On failure, responds with [`SdkError<ListCertificatesError>`](crate::error::ListCertificatesError)
    pub fn list_certificates(&self) -> fluent_builders::ListCertificates<C, M, R> {
        fluent_builders::ListCertificates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListIpRoutes`](crate::client::fluent_builders::ListIpRoutes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::ListIpRoutes::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::ListIpRoutes::set_directory_id): <p>Identifier (ID) of the directory for which you want to retrieve the IP addresses.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListIpRoutes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListIpRoutes::set_next_token): <p>The <i>ListIpRoutes.NextToken</i> value from a previous call to <code>ListIpRoutes</code>. Pass null if this is the first call.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListIpRoutes::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListIpRoutes::set_limit): <p>Maximum number of items to return. If this value is zero, the maximum number of items is specified by the limitations of the operation.</p>
    /// - On success, responds with [`ListIpRoutesOutput`](crate::output::ListIpRoutesOutput) with field(s):
    ///   - [`ip_routes_info(Option<Vec<IpRouteInfo>>)`](crate::output::ListIpRoutesOutput::ip_routes_info): <p>A list of <code>IpRoute</code>s.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListIpRoutesOutput::next_token): <p>If not null, more results are available. Pass this value for the <i>NextToken</i> parameter in a subsequent call to <code>ListIpRoutes</code> to retrieve the next set of items.</p>
    /// - On failure, responds with [`SdkError<ListIpRoutesError>`](crate::error::ListIpRoutesError)
    pub fn list_ip_routes(&self) -> fluent_builders::ListIpRoutes<C, M, R> {
        fluent_builders::ListIpRoutes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListLogSubscriptions`](crate::client::fluent_builders::ListLogSubscriptions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::ListLogSubscriptions::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::ListLogSubscriptions::set_directory_id): <p>If a <i>DirectoryID</i> is provided, lists only the log subscription associated with that directory. If no <i>DirectoryId</i> is provided, lists all log subscriptions associated with your Amazon Web Services account. If there are no log subscriptions for the Amazon Web Services account or the directory, an empty list will be returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListLogSubscriptions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListLogSubscriptions::set_next_token): <p>The token for the next set of items to return.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListLogSubscriptions::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListLogSubscriptions::set_limit): <p>The maximum number of items returned.</p>
    /// - On success, responds with [`ListLogSubscriptionsOutput`](crate::output::ListLogSubscriptionsOutput) with field(s):
    ///   - [`log_subscriptions(Option<Vec<LogSubscription>>)`](crate::output::ListLogSubscriptionsOutput::log_subscriptions): <p>A list of active <code>LogSubscription</code> objects for calling the Amazon Web Services account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListLogSubscriptionsOutput::next_token): <p>The token for the next set of items to return.</p>
    /// - On failure, responds with [`SdkError<ListLogSubscriptionsError>`](crate::error::ListLogSubscriptionsError)
    pub fn list_log_subscriptions(&self) -> fluent_builders::ListLogSubscriptions<C, M, R> {
        fluent_builders::ListLogSubscriptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSchemaExtensions`](crate::client::fluent_builders::ListSchemaExtensions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::ListSchemaExtensions::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::ListSchemaExtensions::set_directory_id): <p>The identifier of the directory from which to retrieve the schema extension information.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSchemaExtensions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSchemaExtensions::set_next_token): <p>The <code>ListSchemaExtensions.NextToken</code> value from a previous call to <code>ListSchemaExtensions</code>. Pass null if this is the first call.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListSchemaExtensions::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListSchemaExtensions::set_limit): <p>The maximum number of items to return.</p>
    /// - On success, responds with [`ListSchemaExtensionsOutput`](crate::output::ListSchemaExtensionsOutput) with field(s):
    ///   - [`schema_extensions_info(Option<Vec<SchemaExtensionInfo>>)`](crate::output::ListSchemaExtensionsOutput::schema_extensions_info): <p>Information about the schema extensions applied to the directory.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListSchemaExtensionsOutput::next_token): <p>If not null, more results are available. Pass this value for the <code>NextToken</code> parameter in a subsequent call to <code>ListSchemaExtensions</code> to retrieve the next set of items.</p>
    /// - On failure, responds with [`SdkError<ListSchemaExtensionsError>`](crate::error::ListSchemaExtensionsError)
    pub fn list_schema_extensions(&self) -> fluent_builders::ListSchemaExtensions<C, M, R> {
        fluent_builders::ListSchemaExtensions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_id): <p>Identifier (ID) of the directory for which you want to retrieve tags.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_next_token): <p>Reserved for future use.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListTagsForResource::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListTagsForResource::set_limit): <p>Reserved for future use.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>List of tags returned by the ListTagsForResource operation.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTagsForResourceOutput::next_token): <p>Reserved for future use.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterCertificate`](crate::client::fluent_builders::RegisterCertificate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::RegisterCertificate::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::RegisterCertificate::set_directory_id): <p>The identifier of the directory.</p>
    ///   - [`certificate_data(impl Into<String>)`](crate::client::fluent_builders::RegisterCertificate::certificate_data) / [`set_certificate_data(Option<String>)`](crate::client::fluent_builders::RegisterCertificate::set_certificate_data): <p>The certificate PEM string that needs to be registered.</p>
    ///   - [`r#type(CertificateType)`](crate::client::fluent_builders::RegisterCertificate::r#type) / [`set_type(Option<CertificateType>)`](crate::client::fluent_builders::RegisterCertificate::set_type): <p>The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.</p>
    ///   - [`client_cert_auth_settings(ClientCertAuthSettings)`](crate::client::fluent_builders::RegisterCertificate::client_cert_auth_settings) / [`set_client_cert_auth_settings(Option<ClientCertAuthSettings>)`](crate::client::fluent_builders::RegisterCertificate::set_client_cert_auth_settings): <p>A <code>ClientCertAuthSettings</code> object that contains client certificate authentication settings.</p>
    /// - On success, responds with [`RegisterCertificateOutput`](crate::output::RegisterCertificateOutput) with field(s):
    ///   - [`certificate_id(Option<String>)`](crate::output::RegisterCertificateOutput::certificate_id): <p>The identifier of the certificate.</p>
    /// - On failure, responds with [`SdkError<RegisterCertificateError>`](crate::error::RegisterCertificateError)
    pub fn register_certificate(&self) -> fluent_builders::RegisterCertificate<C, M, R> {
        fluent_builders::RegisterCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterEventTopic`](crate::client::fluent_builders::RegisterEventTopic) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::RegisterEventTopic::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::RegisterEventTopic::set_directory_id): <p>The Directory ID that will publish status messages to the Amazon SNS topic.</p>
    ///   - [`topic_name(impl Into<String>)`](crate::client::fluent_builders::RegisterEventTopic::topic_name) / [`set_topic_name(Option<String>)`](crate::client::fluent_builders::RegisterEventTopic::set_topic_name): <p>The Amazon SNS topic name to which the directory will publish status messages. This Amazon SNS topic must be in the same region as the specified Directory ID.</p>
    /// - On success, responds with [`RegisterEventTopicOutput`](crate::output::RegisterEventTopicOutput)

    /// - On failure, responds with [`SdkError<RegisterEventTopicError>`](crate::error::RegisterEventTopicError)
    pub fn register_event_topic(&self) -> fluent_builders::RegisterEventTopic<C, M, R> {
        fluent_builders::RegisterEventTopic::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RejectSharedDirectory`](crate::client::fluent_builders::RejectSharedDirectory) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`shared_directory_id(impl Into<String>)`](crate::client::fluent_builders::RejectSharedDirectory::shared_directory_id) / [`set_shared_directory_id(Option<String>)`](crate::client::fluent_builders::RejectSharedDirectory::set_shared_directory_id): <p>Identifier of the shared directory in the directory consumer account. This identifier is different for each directory owner account.</p>
    /// - On success, responds with [`RejectSharedDirectoryOutput`](crate::output::RejectSharedDirectoryOutput) with field(s):
    ///   - [`shared_directory_id(Option<String>)`](crate::output::RejectSharedDirectoryOutput::shared_directory_id): <p>Identifier of the shared directory in the directory consumer account.</p>
    /// - On failure, responds with [`SdkError<RejectSharedDirectoryError>`](crate::error::RejectSharedDirectoryError)
    pub fn reject_shared_directory(&self) -> fluent_builders::RejectSharedDirectory<C, M, R> {
        fluent_builders::RejectSharedDirectory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveIpRoutes`](crate::client::fluent_builders::RemoveIpRoutes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::RemoveIpRoutes::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::RemoveIpRoutes::set_directory_id): <p>Identifier (ID) of the directory from which you want to remove the IP addresses.</p>
    ///   - [`cidr_ips(Vec<String>)`](crate::client::fluent_builders::RemoveIpRoutes::cidr_ips) / [`set_cidr_ips(Option<Vec<String>>)`](crate::client::fluent_builders::RemoveIpRoutes::set_cidr_ips): <p>IP address blocks that you want to remove.</p>
    /// - On success, responds with [`RemoveIpRoutesOutput`](crate::output::RemoveIpRoutesOutput)

    /// - On failure, responds with [`SdkError<RemoveIpRoutesError>`](crate::error::RemoveIpRoutesError)
    pub fn remove_ip_routes(&self) -> fluent_builders::RemoveIpRoutes<C, M, R> {
        fluent_builders::RemoveIpRoutes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveRegion`](crate::client::fluent_builders::RemoveRegion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::RemoveRegion::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::RemoveRegion::set_directory_id): <p>The identifier of the directory for which you want to remove Region replication.</p>
    /// - On success, responds with [`RemoveRegionOutput`](crate::output::RemoveRegionOutput)

    /// - On failure, responds with [`SdkError<RemoveRegionError>`](crate::error::RemoveRegionError)
    pub fn remove_region(&self) -> fluent_builders::RemoveRegion<C, M, R> {
        fluent_builders::RemoveRegion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveTagsFromResource`](crate::client::fluent_builders::RemoveTagsFromResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::RemoveTagsFromResource::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::RemoveTagsFromResource::set_resource_id): <p>Identifier (ID) of the directory from which to remove the tag.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::RemoveTagsFromResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::RemoveTagsFromResource::set_tag_keys): <p>The tag key (name) of the tag to be removed.</p>
    /// - On success, responds with [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)

    /// - On failure, responds with [`SdkError<RemoveTagsFromResourceError>`](crate::error::RemoveTagsFromResourceError)
    pub fn remove_tags_from_resource(&self) -> fluent_builders::RemoveTagsFromResource<C, M, R> {
        fluent_builders::RemoveTagsFromResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ResetUserPassword`](crate::client::fluent_builders::ResetUserPassword) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::ResetUserPassword::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::ResetUserPassword::set_directory_id): <p>Identifier of the Managed Microsoft AD or Simple AD directory in which the user resides.</p>
    ///   - [`user_name(impl Into<String>)`](crate::client::fluent_builders::ResetUserPassword::user_name) / [`set_user_name(Option<String>)`](crate::client::fluent_builders::ResetUserPassword::set_user_name): <p>The user name of the user whose password will be reset.</p>
    ///   - [`new_password(impl Into<String>)`](crate::client::fluent_builders::ResetUserPassword::new_password) / [`set_new_password(Option<String>)`](crate::client::fluent_builders::ResetUserPassword::set_new_password): <p>The new password that will be reset.</p>
    /// - On success, responds with [`ResetUserPasswordOutput`](crate::output::ResetUserPasswordOutput)

    /// - On failure, responds with [`SdkError<ResetUserPasswordError>`](crate::error::ResetUserPasswordError)
    pub fn reset_user_password(&self) -> fluent_builders::ResetUserPassword<C, M, R> {
        fluent_builders::ResetUserPassword::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RestoreFromSnapshot`](crate::client::fluent_builders::RestoreFromSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`snapshot_id(impl Into<String>)`](crate::client::fluent_builders::RestoreFromSnapshot::snapshot_id) / [`set_snapshot_id(Option<String>)`](crate::client::fluent_builders::RestoreFromSnapshot::set_snapshot_id): <p>The identifier of the snapshot to restore from.</p>
    /// - On success, responds with [`RestoreFromSnapshotOutput`](crate::output::RestoreFromSnapshotOutput)

    /// - On failure, responds with [`SdkError<RestoreFromSnapshotError>`](crate::error::RestoreFromSnapshotError)
    pub fn restore_from_snapshot(&self) -> fluent_builders::RestoreFromSnapshot<C, M, R> {
        fluent_builders::RestoreFromSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ShareDirectory`](crate::client::fluent_builders::ShareDirectory) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::ShareDirectory::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::ShareDirectory::set_directory_id): <p>Identifier of the Managed Microsoft AD directory that you want to share with other Amazon Web Services accounts.</p>
    ///   - [`share_notes(impl Into<String>)`](crate::client::fluent_builders::ShareDirectory::share_notes) / [`set_share_notes(Option<String>)`](crate::client::fluent_builders::ShareDirectory::set_share_notes): <p>A directory share request that is sent by the directory owner to the directory consumer. The request includes a typed message to help the directory consumer administrator determine whether to approve or reject the share invitation.</p>
    ///   - [`share_target(ShareTarget)`](crate::client::fluent_builders::ShareDirectory::share_target) / [`set_share_target(Option<ShareTarget>)`](crate::client::fluent_builders::ShareDirectory::set_share_target): <p>Identifier for the directory consumer account with whom the directory is to be shared.</p>
    ///   - [`share_method(ShareMethod)`](crate::client::fluent_builders::ShareDirectory::share_method) / [`set_share_method(Option<ShareMethod>)`](crate::client::fluent_builders::ShareDirectory::set_share_method): <p>The method used when sharing a directory to determine whether the directory should be shared within your Amazon Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services account by sending a directory sharing request (<code>HANDSHAKE</code>).</p>
    /// - On success, responds with [`ShareDirectoryOutput`](crate::output::ShareDirectoryOutput) with field(s):
    ///   - [`shared_directory_id(Option<String>)`](crate::output::ShareDirectoryOutput::shared_directory_id): <p>Identifier of the directory that is stored in the directory consumer account that is shared from the specified directory (<code>DirectoryId</code>).</p>
    /// - On failure, responds with [`SdkError<ShareDirectoryError>`](crate::error::ShareDirectoryError)
    pub fn share_directory(&self) -> fluent_builders::ShareDirectory<C, M, R> {
        fluent_builders::ShareDirectory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartSchemaExtension`](crate::client::fluent_builders::StartSchemaExtension) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::StartSchemaExtension::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::StartSchemaExtension::set_directory_id): <p>The identifier of the directory for which the schema extension will be applied to.</p>
    ///   - [`create_snapshot_before_schema_extension(bool)`](crate::client::fluent_builders::StartSchemaExtension::create_snapshot_before_schema_extension) / [`set_create_snapshot_before_schema_extension(bool)`](crate::client::fluent_builders::StartSchemaExtension::set_create_snapshot_before_schema_extension): <p>If true, creates a snapshot of the directory before applying the schema extension.</p>
    ///   - [`ldif_content(impl Into<String>)`](crate::client::fluent_builders::StartSchemaExtension::ldif_content) / [`set_ldif_content(Option<String>)`](crate::client::fluent_builders::StartSchemaExtension::set_ldif_content): <p>The LDIF file represented as a string. To construct the LdifContent string, precede each line as it would be formatted in an ldif file with \n. See the example request below for more details. The file size can be no larger than 1MB.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::StartSchemaExtension::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::StartSchemaExtension::set_description): <p>A description of the schema extension.</p>
    /// - On success, responds with [`StartSchemaExtensionOutput`](crate::output::StartSchemaExtensionOutput) with field(s):
    ///   - [`schema_extension_id(Option<String>)`](crate::output::StartSchemaExtensionOutput::schema_extension_id): <p>The identifier of the schema extension that will be applied.</p>
    /// - On failure, responds with [`SdkError<StartSchemaExtensionError>`](crate::error::StartSchemaExtensionError)
    pub fn start_schema_extension(&self) -> fluent_builders::StartSchemaExtension<C, M, R> {
        fluent_builders::StartSchemaExtension::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UnshareDirectory`](crate::client::fluent_builders::UnshareDirectory) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::UnshareDirectory::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::UnshareDirectory::set_directory_id): <p>The identifier of the Managed Microsoft AD directory that you want to stop sharing.</p>
    ///   - [`unshare_target(UnshareTarget)`](crate::client::fluent_builders::UnshareDirectory::unshare_target) / [`set_unshare_target(Option<UnshareTarget>)`](crate::client::fluent_builders::UnshareDirectory::set_unshare_target): <p>Identifier for the directory consumer account with whom the directory has to be unshared.</p>
    /// - On success, responds with [`UnshareDirectoryOutput`](crate::output::UnshareDirectoryOutput) with field(s):
    ///   - [`shared_directory_id(Option<String>)`](crate::output::UnshareDirectoryOutput::shared_directory_id): <p>Identifier of the directory stored in the directory consumer account that is to be unshared from the specified directory (<code>DirectoryId</code>).</p>
    /// - On failure, responds with [`SdkError<UnshareDirectoryError>`](crate::error::UnshareDirectoryError)
    pub fn unshare_directory(&self) -> fluent_builders::UnshareDirectory<C, M, R> {
        fluent_builders::UnshareDirectory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateConditionalForwarder`](crate::client::fluent_builders::UpdateConditionalForwarder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::UpdateConditionalForwarder::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::UpdateConditionalForwarder::set_directory_id): <p>The directory ID of the Amazon Web Services directory for which to update the conditional forwarder.</p>
    ///   - [`remote_domain_name(impl Into<String>)`](crate::client::fluent_builders::UpdateConditionalForwarder::remote_domain_name) / [`set_remote_domain_name(Option<String>)`](crate::client::fluent_builders::UpdateConditionalForwarder::set_remote_domain_name): <p>The fully qualified domain name (FQDN) of the remote domain with which you will set up a trust relationship.</p>
    ///   - [`dns_ip_addrs(Vec<String>)`](crate::client::fluent_builders::UpdateConditionalForwarder::dns_ip_addrs) / [`set_dns_ip_addrs(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateConditionalForwarder::set_dns_ip_addrs): <p>The updated IP addresses of the remote DNS server associated with the conditional forwarder.</p>
    /// - On success, responds with [`UpdateConditionalForwarderOutput`](crate::output::UpdateConditionalForwarderOutput)

    /// - On failure, responds with [`SdkError<UpdateConditionalForwarderError>`](crate::error::UpdateConditionalForwarderError)
    pub fn update_conditional_forwarder(
        &self,
    ) -> fluent_builders::UpdateConditionalForwarder<C, M, R> {
        fluent_builders::UpdateConditionalForwarder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateNumberOfDomainControllers`](crate::client::fluent_builders::UpdateNumberOfDomainControllers) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::UpdateNumberOfDomainControllers::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::UpdateNumberOfDomainControllers::set_directory_id): <p>Identifier of the directory to which the domain controllers will be added or removed.</p>
    ///   - [`desired_number(i32)`](crate::client::fluent_builders::UpdateNumberOfDomainControllers::desired_number) / [`set_desired_number(i32)`](crate::client::fluent_builders::UpdateNumberOfDomainControllers::set_desired_number): <p>The number of domain controllers desired in the directory.</p>
    /// - On success, responds with [`UpdateNumberOfDomainControllersOutput`](crate::output::UpdateNumberOfDomainControllersOutput)

    /// - On failure, responds with [`SdkError<UpdateNumberOfDomainControllersError>`](crate::error::UpdateNumberOfDomainControllersError)
    pub fn update_number_of_domain_controllers(
        &self,
    ) -> fluent_builders::UpdateNumberOfDomainControllers<C, M, R> {
        fluent_builders::UpdateNumberOfDomainControllers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRadius`](crate::client::fluent_builders::UpdateRadius) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRadius::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::UpdateRadius::set_directory_id): <p>The identifier of the directory for which to update the RADIUS server information.</p>
    ///   - [`radius_settings(RadiusSettings)`](crate::client::fluent_builders::UpdateRadius::radius_settings) / [`set_radius_settings(Option<RadiusSettings>)`](crate::client::fluent_builders::UpdateRadius::set_radius_settings): <p>A <code>RadiusSettings</code> object that contains information about the RADIUS server.</p>
    /// - On success, responds with [`UpdateRadiusOutput`](crate::output::UpdateRadiusOutput)

    /// - On failure, responds with [`SdkError<UpdateRadiusError>`](crate::error::UpdateRadiusError)
    pub fn update_radius(&self) -> fluent_builders::UpdateRadius<C, M, R> {
        fluent_builders::UpdateRadius::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateTrust`](crate::client::fluent_builders::UpdateTrust) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`trust_id(impl Into<String>)`](crate::client::fluent_builders::UpdateTrust::trust_id) / [`set_trust_id(Option<String>)`](crate::client::fluent_builders::UpdateTrust::set_trust_id): <p>Identifier of the trust relationship.</p>
    ///   - [`selective_auth(SelectiveAuth)`](crate::client::fluent_builders::UpdateTrust::selective_auth) / [`set_selective_auth(Option<SelectiveAuth>)`](crate::client::fluent_builders::UpdateTrust::set_selective_auth): <p>Updates selective authentication for the trust.</p>
    /// - On success, responds with [`UpdateTrustOutput`](crate::output::UpdateTrustOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::UpdateTrustOutput::request_id): <p>The Amazon Web Services request identifier.</p>
    ///   - [`trust_id(Option<String>)`](crate::output::UpdateTrustOutput::trust_id): <p>Identifier of the trust relationship.</p>
    /// - On failure, responds with [`SdkError<UpdateTrustError>`](crate::error::UpdateTrustError)
    pub fn update_trust(&self) -> fluent_builders::UpdateTrust<C, M, R> {
        fluent_builders::UpdateTrust::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`VerifyTrust`](crate::client::fluent_builders::VerifyTrust) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`trust_id(impl Into<String>)`](crate::client::fluent_builders::VerifyTrust::trust_id) / [`set_trust_id(Option<String>)`](crate::client::fluent_builders::VerifyTrust::set_trust_id): <p>The unique Trust ID of the trust relationship to verify.</p>
    /// - On success, responds with [`VerifyTrustOutput`](crate::output::VerifyTrustOutput) with field(s):
    ///   - [`trust_id(Option<String>)`](crate::output::VerifyTrustOutput::trust_id): <p>The unique Trust ID of the trust relationship that was verified.</p>
    /// - On failure, responds with [`SdkError<VerifyTrustError>`](crate::error::VerifyTrustError)
    pub fn verify_trust(&self) -> fluent_builders::VerifyTrust<C, M, R> {
        fluent_builders::VerifyTrust::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptSharedDirectory`.
    ///
    /// <p>Accepts a directory sharing request that was sent from the directory owner account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AcceptSharedDirectory<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::accept_shared_directory_input::Builder,
    }
    impl<C, M, R> AcceptSharedDirectory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcceptSharedDirectory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptSharedDirectoryOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptSharedDirectoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AcceptSharedDirectoryInputOperationOutputAlias,
                crate::output::AcceptSharedDirectoryOutput,
                crate::error::AcceptSharedDirectoryError,
                crate::input::AcceptSharedDirectoryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier of the shared directory in the directory consumer account. This identifier is different for each directory owner account. </p>
        pub fn shared_directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.shared_directory_id(input.into());
            self
        }
        /// <p>Identifier of the shared directory in the directory consumer account. This identifier is different for each directory owner account. </p>
        pub fn set_shared_directory_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_shared_directory_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddIpRoutes`.
    ///
    /// <p>If the DNS server for your self-managed domain uses a publicly addressable IP address, you must add a CIDR address block to correctly route traffic to and from your Microsoft AD on Amazon Web Services. <i>AddIpRoutes</i> adds this address block. You can also use <i>AddIpRoutes</i> to facilitate routing traffic that uses public IP ranges from your Microsoft AD on Amazon Web Services to a peer VPC. </p>
    /// <p>Before you call <i>AddIpRoutes</i>, ensure that all of the required permissions have been explicitly granted through a policy. For details about what permissions are required to run the <i>AddIpRoutes</i> operation, see <a href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html">Directory Service API Permissions: Actions, Resources, and Conditions Reference</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddIpRoutes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_ip_routes_input::Builder,
    }
    impl<C, M, R> AddIpRoutes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddIpRoutes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddIpRoutesOutput,
            aws_smithy_http::result::SdkError<crate::error::AddIpRoutesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddIpRoutesInputOperationOutputAlias,
                crate::output::AddIpRoutesOutput,
                crate::error::AddIpRoutesError,
                crate::input::AddIpRoutesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier (ID) of the directory to which to add the address block.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>Identifier (ID) of the directory to which to add the address block.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// Appends an item to `IpRoutes`.
        ///
        /// To override the contents of this collection use [`set_ip_routes`](Self::set_ip_routes).
        ///
        /// <p>IP address blocks, using CIDR format, of the traffic to route. This is often the IP address block of the DNS server used for your self-managed domain.</p>
        pub fn ip_routes(mut self, input: crate::model::IpRoute) -> Self {
            self.inner = self.inner.ip_routes(input);
            self
        }
        /// <p>IP address blocks, using CIDR format, of the traffic to route. This is often the IP address block of the DNS server used for your self-managed domain.</p>
        pub fn set_ip_routes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpRoute>>,
        ) -> Self {
            self.inner = self.inner.set_ip_routes(input);
            self
        }
        /// <p>If set to true, updates the inbound and outbound rules of the security group that has the description: "Amazon Web Services created security group for <i>directory ID</i> directory controllers." Following are the new rules: </p>
        /// <p>Inbound:</p>
        /// <ul>
        /// <li> <p>Type: Custom UDP Rule, Protocol: UDP, Range: 88, Source: 0.0.0.0/0</p> </li>
        /// <li> <p>Type: Custom UDP Rule, Protocol: UDP, Range: 123, Source: 0.0.0.0/0</p> </li>
        /// <li> <p>Type: Custom UDP Rule, Protocol: UDP, Range: 138, Source: 0.0.0.0/0</p> </li>
        /// <li> <p>Type: Custom UDP Rule, Protocol: UDP, Range: 389, Source: 0.0.0.0/0</p> </li>
        /// <li> <p>Type: Custom UDP Rule, Protocol: UDP, Range: 464, Source: 0.0.0.0/0</p> </li>
        /// <li> <p>Type: Custom UDP Rule, Protocol: UDP, Range: 445, Source: 0.0.0.0/0</p> </li>
        /// <li> <p>Type: Custom TCP Rule, Protocol: TCP, Range: 88, Source: 0.0.0.0/0</p> </li>
        /// <li> <p>Type: Custom TCP Rule, Protocol: TCP, Range: 135, Source: 0.0.0.0/0</p> </li>
        /// <li> <p>Type: Custom TCP Rule, Protocol: TCP, Range: 445, Source: 0.0.0.0/0</p> </li>
        /// <li> <p>Type: Custom TCP Rule, Protocol: TCP, Range: 464, Source: 0.0.0.0/0</p> </li>
        /// <li> <p>Type: Custom TCP Rule, Protocol: TCP, Range: 636, Source: 0.0.0.0/0</p> </li>
        /// <li> <p>Type: Custom TCP Rule, Protocol: TCP, Range: 1024-65535, Source: 0.0.0.0/0</p> </li>
        /// <li> <p>Type: Custom TCP Rule, Protocol: TCP, Range: 3268-33269, Source: 0.0.0.0/0</p> </li>
        /// <li> <p>Type: DNS (UDP), Protocol: UDP, Range: 53, Source: 0.0.0.0/0</p> </li>
        /// <li> <p>Type: DNS (TCP), Protocol: TCP, Range: 53, Source: 0.0.0.0/0</p> </li>
        /// <li> <p>Type: LDAP, Protocol: TCP, Range: 389, Source: 0.0.0.0/0</p> </li>
        /// <li> <p>Type: All ICMP, Protocol: All, Range: N/A, Source: 0.0.0.0/0</p> </li>
        /// </ul>
        /// <p></p>
        /// <p>Outbound:</p>
        /// <ul>
        /// <li> <p>Type: All traffic, Protocol: All, Range: All, Destination: 0.0.0.0/0</p> </li>
        /// </ul>
        /// <p>These security rules impact an internal network interface that is not exposed publicly.</p>
        pub fn update_security_group_for_directory_controllers(mut self, input: bool) -> Self {
            self.inner = self
                .inner
                .update_security_group_for_directory_controllers(input);
            self
        }
        /// <p>If set to true, updates the inbound and outbound rules of the security group that has the description: "Amazon Web Services created security group for <i>directory ID</i> directory controllers." Following are the new rules: </p>
        /// <p>Inbound:</p>
        /// <ul>
        /// <li> <p>Type: Custom UDP Rule, Protocol: UDP, Range: 88, Source: 0.0.0.0/0</p> </li>
        /// <li> <p>Type: Custom UDP Rule, Protocol: UDP, Range: 123, Source: 0.0.0.0/0</p> </li>
        /// <li> <p>Type: Custom UDP Rule, Protocol: UDP, Range: 138, Source: 0.0.0.0/0</p> </li>
        /// <li> <p>Type: Custom UDP Rule, Protocol: UDP, Range: 389, Source: 0.0.0.0/0</p> </li>
        /// <li> <p>Type: Custom UDP Rule, Protocol: UDP, Range: 464, Source: 0.0.0.0/0</p> </li>
        /// <li> <p>Type: Custom UDP Rule, Protocol: UDP, Range: 445, Source: 0.0.0.0/0</p> </li>
        /// <li> <p>Type: Custom TCP Rule, Protocol: TCP, Range: 88, Source: 0.0.0.0/0</p> </li>
        /// <li> <p>Type: Custom TCP Rule, Protocol: TCP, Range: 135, Source: 0.0.0.0/0</p> </li>
        /// <li> <p>Type: Custom TCP Rule, Protocol: TCP, Range: 445, Source: 0.0.0.0/0</p> </li>
        /// <li> <p>Type: Custom TCP Rule, Protocol: TCP, Range: 464, Source: 0.0.0.0/0</p> </li>
        /// <li> <p>Type: Custom TCP Rule, Protocol: TCP, Range: 636, Source: 0.0.0.0/0</p> </li>
        /// <li> <p>Type: Custom TCP Rule, Protocol: TCP, Range: 1024-65535, Source: 0.0.0.0/0</p> </li>
        /// <li> <p>Type: Custom TCP Rule, Protocol: TCP, Range: 3268-33269, Source: 0.0.0.0/0</p> </li>
        /// <li> <p>Type: DNS (UDP), Protocol: UDP, Range: 53, Source: 0.0.0.0/0</p> </li>
        /// <li> <p>Type: DNS (TCP), Protocol: TCP, Range: 53, Source: 0.0.0.0/0</p> </li>
        /// <li> <p>Type: LDAP, Protocol: TCP, Range: 389, Source: 0.0.0.0/0</p> </li>
        /// <li> <p>Type: All ICMP, Protocol: All, Range: N/A, Source: 0.0.0.0/0</p> </li>
        /// </ul>
        /// <p></p>
        /// <p>Outbound:</p>
        /// <ul>
        /// <li> <p>Type: All traffic, Protocol: All, Range: All, Destination: 0.0.0.0/0</p> </li>
        /// </ul>
        /// <p>These security rules impact an internal network interface that is not exposed publicly.</p>
        pub fn set_update_security_group_for_directory_controllers(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self
                .inner
                .set_update_security_group_for_directory_controllers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddRegion`.
    ///
    /// <p>Adds two domain controllers in the specified Region for the specified directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddRegion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_region_input::Builder,
    }
    impl<C, M, R> AddRegion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddRegion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddRegionOutput,
            aws_smithy_http::result::SdkError<crate::error::AddRegionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddRegionInputOperationOutputAlias,
                crate::output::AddRegionOutput,
                crate::error::AddRegionError,
                crate::input::AddRegionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory to which you want to add Region replication.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory to which you want to add Region replication.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The name of the Region where you want to add domain controllers for replication. For example, <code>us-east-1</code>.</p>
        pub fn region_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.region_name(input.into());
            self
        }
        /// <p>The name of the Region where you want to add domain controllers for replication. For example, <code>us-east-1</code>.</p>
        pub fn set_region_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_region_name(input);
            self
        }
        /// <p>Contains VPC information for the <code>CreateDirectory</code> or <code>CreateMicrosoftAD</code> operation.</p>
        pub fn vpc_settings(mut self, input: crate::model::DirectoryVpcSettings) -> Self {
            self.inner = self.inner.vpc_settings(input);
            self
        }
        /// <p>Contains VPC information for the <code>CreateDirectory</code> or <code>CreateMicrosoftAD</code> operation.</p>
        pub fn set_vpc_settings(
            mut self,
            input: std::option::Option<crate::model::DirectoryVpcSettings>,
        ) -> Self {
            self.inner = self.inner.set_vpc_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddTagsToResource`.
    ///
    /// <p>Adds or overwrites one or more tags for the specified directory. Each directory can have a maximum of 50 tags. Each tag consists of a key and optional value. Tag keys must be unique to each resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddTagsToResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_tags_to_resource_input::Builder,
    }
    impl<C, M, R> AddTagsToResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddTagsToResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddTagsToResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::AddTagsToResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddTagsToResourceInputOperationOutputAlias,
                crate::output::AddTagsToResourceOutput,
                crate::error::AddTagsToResourceError,
                crate::input::AddTagsToResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier (ID) for the directory to which to add the tag.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>Identifier (ID) for the directory to which to add the tag.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the directory.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to be assigned to the directory.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelSchemaExtension`.
    ///
    /// <p>Cancels an in-progress schema extension to a Microsoft AD directory. Once a schema extension has started replicating to all domain controllers, the task can no longer be canceled. A schema extension can be canceled during any of the following states; <code>Initializing</code>, <code>CreatingSnapshot</code>, and <code>UpdatingSchema</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelSchemaExtension<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_schema_extension_input::Builder,
    }
    impl<C, M, R> CancelSchemaExtension<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelSchemaExtension`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelSchemaExtensionOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelSchemaExtensionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelSchemaExtensionInputOperationOutputAlias,
                crate::output::CancelSchemaExtensionOutput,
                crate::error::CancelSchemaExtensionError,
                crate::input::CancelSchemaExtensionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory whose schema extension will be canceled.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory whose schema extension will be canceled.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The identifier of the schema extension that will be canceled.</p>
        pub fn schema_extension_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_extension_id(input.into());
            self
        }
        /// <p>The identifier of the schema extension that will be canceled.</p>
        pub fn set_schema_extension_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schema_extension_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ConnectDirectory`.
    ///
    /// <p>Creates an AD Connector to connect to a self-managed directory.</p>
    /// <p>Before you call <code>ConnectDirectory</code>, ensure that all of the required permissions have been explicitly granted through a policy. For details about what permissions are required to run the <code>ConnectDirectory</code> operation, see <a href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html">Directory Service API Permissions: Actions, Resources, and Conditions Reference</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ConnectDirectory<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::connect_directory_input::Builder,
    }
    impl<C, M, R> ConnectDirectory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ConnectDirectory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ConnectDirectoryOutput,
            aws_smithy_http::result::SdkError<crate::error::ConnectDirectoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ConnectDirectoryInputOperationOutputAlias,
                crate::output::ConnectDirectoryOutput,
                crate::error::ConnectDirectoryError,
                crate::input::ConnectDirectoryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The fully qualified name of your self-managed directory, such as <code>corp.example.com</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The fully qualified name of your self-managed directory, such as <code>corp.example.com</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The NetBIOS name of your self-managed directory, such as <code>CORP</code>.</p>
        pub fn short_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.short_name(input.into());
            self
        }
        /// <p>The NetBIOS name of your self-managed directory, such as <code>CORP</code>.</p>
        pub fn set_short_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_short_name(input);
            self
        }
        /// <p>The password for your self-managed user account.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(input.into());
            self
        }
        /// <p>The password for your self-managed user account.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
        /// <p>A description for the directory.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the directory.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The size of the directory.</p>
        pub fn size(mut self, input: crate::model::DirectorySize) -> Self {
            self.inner = self.inner.size(input);
            self
        }
        /// <p>The size of the directory.</p>
        pub fn set_size(mut self, input: std::option::Option<crate::model::DirectorySize>) -> Self {
            self.inner = self.inner.set_size(input);
            self
        }
        /// <p>A <code>DirectoryConnectSettings</code> object that contains additional information for the operation.</p>
        pub fn connect_settings(mut self, input: crate::model::DirectoryConnectSettings) -> Self {
            self.inner = self.inner.connect_settings(input);
            self
        }
        /// <p>A <code>DirectoryConnectSettings</code> object that contains additional information for the operation.</p>
        pub fn set_connect_settings(
            mut self,
            input: std::option::Option<crate::model::DirectoryConnectSettings>,
        ) -> Self {
            self.inner = self.inner.set_connect_settings(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to AD Connector.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to be assigned to AD Connector.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAlias`.
    ///
    /// <p>Creates an alias for a directory and assigns the alias to the directory. The alias is used to construct the access URL for the directory, such as <code>http://
    /// <alias>
    /// .awsapps.com
    /// </alias></code>.</p> <important>
    /// <p>After an alias has been created, it cannot be deleted or reused, so this operation should only be used when absolutely necessary.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_alias_input::Builder,
    }
    impl<C, M, R> CreateAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAliasInputOperationOutputAlias,
                crate::output::CreateAliasOutput,
                crate::error::CreateAliasError,
                crate::input::CreateAliasInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory for which to create the alias.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory for which to create the alias.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The requested alias.</p>
        /// <p>The alias must be unique amongst all aliases in Amazon Web Services. This operation throws an <code>EntityAlreadyExistsException</code> error if the alias already exists.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias(input.into());
            self
        }
        /// <p>The requested alias.</p>
        /// <p>The alias must be unique amongst all aliases in Amazon Web Services. This operation throws an <code>EntityAlreadyExistsException</code> error if the alias already exists.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateComputer`.
    ///
    /// <p>Creates an Active Directory computer object in the specified directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateComputer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_computer_input::Builder,
    }
    impl<C, M, R> CreateComputer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateComputer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateComputerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateComputerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateComputerInputOperationOutputAlias,
                crate::output::CreateComputerOutput,
                crate::error::CreateComputerError,
                crate::input::CreateComputerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory in which to create the computer account.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory in which to create the computer account.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The name of the computer account.</p>
        pub fn computer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.computer_name(input.into());
            self
        }
        /// <p>The name of the computer account.</p>
        pub fn set_computer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_computer_name(input);
            self
        }
        /// <p>A one-time password that is used to join the computer to the directory. You should generate a random, strong password to use for this parameter.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(input.into());
            self
        }
        /// <p>A one-time password that is used to join the computer to the directory. You should generate a random, strong password to use for this parameter.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
        /// <p>The fully-qualified distinguished name of the organizational unit to place the computer account in.</p>
        pub fn organizational_unit_distinguished_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .organizational_unit_distinguished_name(input.into());
            self
        }
        /// <p>The fully-qualified distinguished name of the organizational unit to place the computer account in.</p>
        pub fn set_organizational_unit_distinguished_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organizational_unit_distinguished_name(input);
            self
        }
        /// Appends an item to `ComputerAttributes`.
        ///
        /// To override the contents of this collection use [`set_computer_attributes`](Self::set_computer_attributes).
        ///
        /// <p>An array of <code>Attribute</code> objects that contain any LDAP attributes to apply to the computer account.</p>
        pub fn computer_attributes(mut self, input: crate::model::Attribute) -> Self {
            self.inner = self.inner.computer_attributes(input);
            self
        }
        /// <p>An array of <code>Attribute</code> objects that contain any LDAP attributes to apply to the computer account.</p>
        pub fn set_computer_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.inner = self.inner.set_computer_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConditionalForwarder`.
    ///
    /// <p>Creates a conditional forwarder associated with your Amazon Web Services directory. Conditional forwarders are required in order to set up a trust relationship with another domain. The conditional forwarder points to the trusted domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateConditionalForwarder<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_conditional_forwarder_input::Builder,
    }
    impl<C, M, R> CreateConditionalForwarder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateConditionalForwarder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConditionalForwarderOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConditionalForwarderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateConditionalForwarderInputOperationOutputAlias,
                crate::output::CreateConditionalForwarderOutput,
                crate::error::CreateConditionalForwarderError,
                crate::input::CreateConditionalForwarderInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The directory ID of the Amazon Web Services directory for which you are creating the conditional forwarder.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The directory ID of the Amazon Web Services directory for which you are creating the conditional forwarder.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The fully qualified domain name (FQDN) of the remote domain with which you will set up a trust relationship.</p>
        pub fn remote_domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.remote_domain_name(input.into());
            self
        }
        /// <p>The fully qualified domain name (FQDN) of the remote domain with which you will set up a trust relationship.</p>
        pub fn set_remote_domain_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_remote_domain_name(input);
            self
        }
        /// Appends an item to `DnsIpAddrs`.
        ///
        /// To override the contents of this collection use [`set_dns_ip_addrs`](Self::set_dns_ip_addrs).
        ///
        /// <p>The IP addresses of the remote DNS server associated with RemoteDomainName.</p>
        pub fn dns_ip_addrs(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dns_ip_addrs(input.into());
            self
        }
        /// <p>The IP addresses of the remote DNS server associated with RemoteDomainName.</p>
        pub fn set_dns_ip_addrs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_dns_ip_addrs(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDirectory`.
    ///
    /// <p>Creates a Simple AD directory. For more information, see <a href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_simple_ad.html">Simple Active Directory</a> in the <i>Directory Service Admin Guide</i>.</p>
    /// <p>Before you call <code>CreateDirectory</code>, ensure that all of the required permissions have been explicitly granted through a policy. For details about what permissions are required to run the <code>CreateDirectory</code> operation, see <a href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html">Directory Service API Permissions: Actions, Resources, and Conditions Reference</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDirectory<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_directory_input::Builder,
    }
    impl<C, M, R> CreateDirectory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDirectory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDirectoryOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDirectoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDirectoryInputOperationOutputAlias,
                crate::output::CreateDirectoryOutput,
                crate::error::CreateDirectoryError,
                crate::input::CreateDirectoryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The fully qualified name for the directory, such as <code>corp.example.com</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The fully qualified name for the directory, such as <code>corp.example.com</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The NetBIOS name of the directory, such as <code>CORP</code>.</p>
        pub fn short_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.short_name(input.into());
            self
        }
        /// <p>The NetBIOS name of the directory, such as <code>CORP</code>.</p>
        pub fn set_short_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_short_name(input);
            self
        }
        /// <p>The password for the directory administrator. The directory creation process creates a directory administrator account with the user name <code>Administrator</code> and this password.</p>
        /// <p>If you need to change the password for the administrator account, you can use the <code>ResetUserPassword</code> API call.</p>
        /// <p>The regex pattern for this string is made up of the following conditions:</p>
        /// <ul>
        /// <li> <p>Length (?=^.{8,64}$) – Must be between 8 and 64 characters</p> </li>
        /// </ul>
        /// <p>AND any 3 of the following password complexity rules required by Active Directory:</p>
        /// <ul>
        /// <li> <p>Numbers and upper case and lowercase (?=.*\d)(?=.*[A-Z])(?=.*[a-z])</p> </li>
        /// <li> <p>Numbers and special characters and lower case (?=.*\d)(?=.*[^A-Za-z0-9\s])(?=.*[a-z])</p> </li>
        /// <li> <p>Special characters and upper case and lower case (?=.*[^A-Za-z0-9\s])(?=.*[A-Z])(?=.*[a-z])</p> </li>
        /// <li> <p>Numbers and upper case and special characters (?=.*\d)(?=.*[A-Z])(?=.*[^A-Za-z0-9\s])</p> </li>
        /// </ul>
        /// <p>For additional information about how Active Directory passwords are enforced, see <a href="https://docs.microsoft.com/en-us/windows/security/threat-protection/security-policy-settings/password-must-meet-complexity-requirements">Password must meet complexity requirements</a> on the Microsoft website.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(input.into());
            self
        }
        /// <p>The password for the directory administrator. The directory creation process creates a directory administrator account with the user name <code>Administrator</code> and this password.</p>
        /// <p>If you need to change the password for the administrator account, you can use the <code>ResetUserPassword</code> API call.</p>
        /// <p>The regex pattern for this string is made up of the following conditions:</p>
        /// <ul>
        /// <li> <p>Length (?=^.{8,64}$) – Must be between 8 and 64 characters</p> </li>
        /// </ul>
        /// <p>AND any 3 of the following password complexity rules required by Active Directory:</p>
        /// <ul>
        /// <li> <p>Numbers and upper case and lowercase (?=.*\d)(?=.*[A-Z])(?=.*[a-z])</p> </li>
        /// <li> <p>Numbers and special characters and lower case (?=.*\d)(?=.*[^A-Za-z0-9\s])(?=.*[a-z])</p> </li>
        /// <li> <p>Special characters and upper case and lower case (?=.*[^A-Za-z0-9\s])(?=.*[A-Z])(?=.*[a-z])</p> </li>
        /// <li> <p>Numbers and upper case and special characters (?=.*\d)(?=.*[A-Z])(?=.*[^A-Za-z0-9\s])</p> </li>
        /// </ul>
        /// <p>For additional information about how Active Directory passwords are enforced, see <a href="https://docs.microsoft.com/en-us/windows/security/threat-protection/security-policy-settings/password-must-meet-complexity-requirements">Password must meet complexity requirements</a> on the Microsoft website.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
        /// <p>A description for the directory.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the directory.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The size of the directory.</p>
        pub fn size(mut self, input: crate::model::DirectorySize) -> Self {
            self.inner = self.inner.size(input);
            self
        }
        /// <p>The size of the directory.</p>
        pub fn set_size(mut self, input: std::option::Option<crate::model::DirectorySize>) -> Self {
            self.inner = self.inner.set_size(input);
            self
        }
        /// <p>A <code>DirectoryVpcSettings</code> object that contains additional information for the operation.</p>
        pub fn vpc_settings(mut self, input: crate::model::DirectoryVpcSettings) -> Self {
            self.inner = self.inner.vpc_settings(input);
            self
        }
        /// <p>A <code>DirectoryVpcSettings</code> object that contains additional information for the operation.</p>
        pub fn set_vpc_settings(
            mut self,
            input: std::option::Option<crate::model::DirectoryVpcSettings>,
        ) -> Self {
            self.inner = self.inner.set_vpc_settings(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the Simple AD directory.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to be assigned to the Simple AD directory.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLogSubscription`.
    ///
    /// <p>Creates a subscription to forward real-time Directory Service domain controller security logs to the specified Amazon CloudWatch log group in your Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLogSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_log_subscription_input::Builder,
    }
    impl<C, M, R> CreateLogSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLogSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLogSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLogSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLogSubscriptionInputOperationOutputAlias,
                crate::output::CreateLogSubscriptionOutput,
                crate::error::CreateLogSubscriptionError,
                crate::input::CreateLogSubscriptionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier of the directory to which you want to subscribe and receive real-time logs to your specified CloudWatch log group.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>Identifier of the directory to which you want to subscribe and receive real-time logs to your specified CloudWatch log group.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The name of the CloudWatch log group where the real-time domain controller logs are forwarded.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_group_name(input.into());
            self
        }
        /// <p>The name of the CloudWatch log group where the real-time domain controller logs are forwarded.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMicrosoftAD`.
    ///
    /// <p>Creates a Microsoft AD directory in the Amazon Web Services Cloud. For more information, see <a href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_microsoft_ad.html">Managed Microsoft AD</a> in the <i>Directory Service Admin Guide</i>.</p>
    /// <p>Before you call <i>CreateMicrosoftAD</i>, ensure that all of the required permissions have been explicitly granted through a policy. For details about what permissions are required to run the <i>CreateMicrosoftAD</i> operation, see <a href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html">Directory Service API Permissions: Actions, Resources, and Conditions Reference</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateMicrosoftAD<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_microsoft_ad_input::Builder,
    }
    impl<C, M, R> CreateMicrosoftAD<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMicrosoftAD`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMicrosoftAdOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMicrosoftADError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMicrosoftAdInputOperationOutputAlias,
                crate::output::CreateMicrosoftAdOutput,
                crate::error::CreateMicrosoftADError,
                crate::input::CreateMicrosoftAdInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The fully qualified domain name for the Managed Microsoft AD directory, such as <code>corp.example.com</code>. This name will resolve inside your VPC only. It does not need to be publicly resolvable.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The fully qualified domain name for the Managed Microsoft AD directory, such as <code>corp.example.com</code>. This name will resolve inside your VPC only. It does not need to be publicly resolvable.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The NetBIOS name for your domain, such as <code>CORP</code>. If you don't specify a NetBIOS name, it will default to the first part of your directory DNS. For example, <code>CORP</code> for the directory DNS <code>corp.example.com</code>. </p>
        pub fn short_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.short_name(input.into());
            self
        }
        /// <p>The NetBIOS name for your domain, such as <code>CORP</code>. If you don't specify a NetBIOS name, it will default to the first part of your directory DNS. For example, <code>CORP</code> for the directory DNS <code>corp.example.com</code>. </p>
        pub fn set_short_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_short_name(input);
            self
        }
        /// <p>The password for the default administrative user named <code>Admin</code>.</p>
        /// <p>If you need to change the password for the administrator account, you can use the <code>ResetUserPassword</code> API call.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(input.into());
            self
        }
        /// <p>The password for the default administrative user named <code>Admin</code>.</p>
        /// <p>If you need to change the password for the administrator account, you can use the <code>ResetUserPassword</code> API call.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
        /// <p>A description for the directory. This label will appear on the Amazon Web Services console <code>Directory Details</code> page after the directory is created.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the directory. This label will appear on the Amazon Web Services console <code>Directory Details</code> page after the directory is created.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Contains VPC information for the <code>CreateDirectory</code> or <code>CreateMicrosoftAD</code> operation.</p>
        pub fn vpc_settings(mut self, input: crate::model::DirectoryVpcSettings) -> Self {
            self.inner = self.inner.vpc_settings(input);
            self
        }
        /// <p>Contains VPC information for the <code>CreateDirectory</code> or <code>CreateMicrosoftAD</code> operation.</p>
        pub fn set_vpc_settings(
            mut self,
            input: std::option::Option<crate::model::DirectoryVpcSettings>,
        ) -> Self {
            self.inner = self.inner.set_vpc_settings(input);
            self
        }
        /// <p>Managed Microsoft AD is available in two editions: <code>Standard</code> and <code>Enterprise</code>. <code>Enterprise</code> is the default.</p>
        pub fn edition(mut self, input: crate::model::DirectoryEdition) -> Self {
            self.inner = self.inner.edition(input);
            self
        }
        /// <p>Managed Microsoft AD is available in two editions: <code>Standard</code> and <code>Enterprise</code>. <code>Enterprise</code> is the default.</p>
        pub fn set_edition(
            mut self,
            input: std::option::Option<crate::model::DirectoryEdition>,
        ) -> Self {
            self.inner = self.inner.set_edition(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the Managed Microsoft AD directory.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to be assigned to the Managed Microsoft AD directory.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSnapshot`.
    ///
    /// <p>Creates a snapshot of a Simple AD or Microsoft AD directory in the Amazon Web Services cloud.</p> <note>
    /// <p>You cannot take snapshots of AD Connector directories.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_snapshot_input::Builder,
    }
    impl<C, M, R> CreateSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSnapshotInputOperationOutputAlias,
                crate::output::CreateSnapshotOutput,
                crate::error::CreateSnapshotError,
                crate::input::CreateSnapshotInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory of which to take a snapshot.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory of which to take a snapshot.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The descriptive name to apply to the snapshot.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The descriptive name to apply to the snapshot.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTrust`.
    ///
    /// <p>Directory Service for Microsoft Active Directory allows you to configure trust relationships. For example, you can establish a trust between your Managed Microsoft AD directory, and your existing self-managed Microsoft Active Directory. This would allow you to provide users and groups access to resources in either domain, with a single set of credentials.</p>
    /// <p>This action initiates the creation of the Amazon Web Services side of a trust relationship between an Managed Microsoft AD directory and an external domain. You can create either a forest trust or an external trust.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTrust<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_trust_input::Builder,
    }
    impl<C, M, R> CreateTrust<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTrust`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTrustOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTrustError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTrustInputOperationOutputAlias,
                crate::output::CreateTrustOutput,
                crate::error::CreateTrustError,
                crate::input::CreateTrustInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Directory ID of the Managed Microsoft AD directory for which to establish the trust relationship.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The Directory ID of the Managed Microsoft AD directory for which to establish the trust relationship.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The Fully Qualified Domain Name (FQDN) of the external domain for which to create the trust relationship.</p>
        pub fn remote_domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.remote_domain_name(input.into());
            self
        }
        /// <p>The Fully Qualified Domain Name (FQDN) of the external domain for which to create the trust relationship.</p>
        pub fn set_remote_domain_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_remote_domain_name(input);
            self
        }
        /// <p>The trust password. The must be the same password that was used when creating the trust relationship on the external domain.</p>
        pub fn trust_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trust_password(input.into());
            self
        }
        /// <p>The trust password. The must be the same password that was used when creating the trust relationship on the external domain.</p>
        pub fn set_trust_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_trust_password(input);
            self
        }
        /// <p>The direction of the trust relationship.</p>
        pub fn trust_direction(mut self, input: crate::model::TrustDirection) -> Self {
            self.inner = self.inner.trust_direction(input);
            self
        }
        /// <p>The direction of the trust relationship.</p>
        pub fn set_trust_direction(
            mut self,
            input: std::option::Option<crate::model::TrustDirection>,
        ) -> Self {
            self.inner = self.inner.set_trust_direction(input);
            self
        }
        /// <p>The trust relationship type. <code>Forest</code> is the default.</p>
        pub fn trust_type(mut self, input: crate::model::TrustType) -> Self {
            self.inner = self.inner.trust_type(input);
            self
        }
        /// <p>The trust relationship type. <code>Forest</code> is the default.</p>
        pub fn set_trust_type(
            mut self,
            input: std::option::Option<crate::model::TrustType>,
        ) -> Self {
            self.inner = self.inner.set_trust_type(input);
            self
        }
        /// Appends an item to `ConditionalForwarderIpAddrs`.
        ///
        /// To override the contents of this collection use [`set_conditional_forwarder_ip_addrs`](Self::set_conditional_forwarder_ip_addrs).
        ///
        /// <p>The IP addresses of the remote DNS server associated with RemoteDomainName.</p>
        pub fn conditional_forwarder_ip_addrs(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.conditional_forwarder_ip_addrs(input.into());
            self
        }
        /// <p>The IP addresses of the remote DNS server associated with RemoteDomainName.</p>
        pub fn set_conditional_forwarder_ip_addrs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_conditional_forwarder_ip_addrs(input);
            self
        }
        /// <p>Optional parameter to enable selective authentication for the trust.</p>
        pub fn selective_auth(mut self, input: crate::model::SelectiveAuth) -> Self {
            self.inner = self.inner.selective_auth(input);
            self
        }
        /// <p>Optional parameter to enable selective authentication for the trust.</p>
        pub fn set_selective_auth(
            mut self,
            input: std::option::Option<crate::model::SelectiveAuth>,
        ) -> Self {
            self.inner = self.inner.set_selective_auth(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConditionalForwarder`.
    ///
    /// <p>Deletes a conditional forwarder that has been set up for your Amazon Web Services directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteConditionalForwarder<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_conditional_forwarder_input::Builder,
    }
    impl<C, M, R> DeleteConditionalForwarder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteConditionalForwarder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConditionalForwarderOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConditionalForwarderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteConditionalForwarderInputOperationOutputAlias,
                crate::output::DeleteConditionalForwarderOutput,
                crate::error::DeleteConditionalForwarderError,
                crate::input::DeleteConditionalForwarderInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The directory ID for which you are deleting the conditional forwarder.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The directory ID for which you are deleting the conditional forwarder.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The fully qualified domain name (FQDN) of the remote domain with which you are deleting the conditional forwarder.</p>
        pub fn remote_domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.remote_domain_name(input.into());
            self
        }
        /// <p>The fully qualified domain name (FQDN) of the remote domain with which you are deleting the conditional forwarder.</p>
        pub fn set_remote_domain_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_remote_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDirectory`.
    ///
    /// <p>Deletes an Directory Service directory.</p>
    /// <p>Before you call <code>DeleteDirectory</code>, ensure that all of the required permissions have been explicitly granted through a policy. For details about what permissions are required to run the <code>DeleteDirectory</code> operation, see <a href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html">Directory Service API Permissions: Actions, Resources, and Conditions Reference</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDirectory<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_directory_input::Builder,
    }
    impl<C, M, R> DeleteDirectory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDirectory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDirectoryOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDirectoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDirectoryInputOperationOutputAlias,
                crate::output::DeleteDirectoryOutput,
                crate::error::DeleteDirectoryError,
                crate::input::DeleteDirectoryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory to delete.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory to delete.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLogSubscription`.
    ///
    /// <p>Deletes the specified log subscription.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLogSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_log_subscription_input::Builder,
    }
    impl<C, M, R> DeleteLogSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLogSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLogSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLogSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLogSubscriptionInputOperationOutputAlias,
                crate::output::DeleteLogSubscriptionOutput,
                crate::error::DeleteLogSubscriptionError,
                crate::input::DeleteLogSubscriptionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier of the directory whose log subscription you want to delete.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>Identifier of the directory whose log subscription you want to delete.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSnapshot`.
    ///
    /// <p>Deletes a directory snapshot.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_snapshot_input::Builder,
    }
    impl<C, M, R> DeleteSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSnapshotInputOperationOutputAlias,
                crate::output::DeleteSnapshotOutput,
                crate::error::DeleteSnapshotError,
                crate::input::DeleteSnapshotInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory snapshot to be deleted.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_id(input.into());
            self
        }
        /// <p>The identifier of the directory snapshot to be deleted.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_snapshot_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTrust`.
    ///
    /// <p>Deletes an existing trust relationship between your Managed Microsoft AD directory and an external domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTrust<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_trust_input::Builder,
    }
    impl<C, M, R> DeleteTrust<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTrust`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTrustOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTrustError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTrustInputOperationOutputAlias,
                crate::output::DeleteTrustOutput,
                crate::error::DeleteTrustError,
                crate::input::DeleteTrustInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Trust ID of the trust relationship to be deleted.</p>
        pub fn trust_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trust_id(input.into());
            self
        }
        /// <p>The Trust ID of the trust relationship to be deleted.</p>
        pub fn set_trust_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_trust_id(input);
            self
        }
        /// <p>Delete a conditional forwarder as part of a DeleteTrustRequest.</p>
        pub fn delete_associated_conditional_forwarder(mut self, input: bool) -> Self {
            self.inner = self.inner.delete_associated_conditional_forwarder(input);
            self
        }
        /// <p>Delete a conditional forwarder as part of a DeleteTrustRequest.</p>
        pub fn set_delete_associated_conditional_forwarder(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self
                .inner
                .set_delete_associated_conditional_forwarder(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterCertificate`.
    ///
    /// <p>Deletes from the system the certificate that was registered for secure LDAP or client certificate authentication.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeregisterCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deregister_certificate_input::Builder,
    }
    impl<C, M, R> DeregisterCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeregisterCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeregisterCertificateInputOperationOutputAlias,
                crate::output::DeregisterCertificateOutput,
                crate::error::DeregisterCertificateError,
                crate::input::DeregisterCertificateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The identifier of the certificate.</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_id(input.into());
            self
        }
        /// <p>The identifier of the certificate.</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterEventTopic`.
    ///
    /// <p>Removes the specified directory as a publisher to the specified Amazon SNS topic.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeregisterEventTopic<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deregister_event_topic_input::Builder,
    }
    impl<C, M, R> DeregisterEventTopic<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeregisterEventTopic`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterEventTopicOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterEventTopicError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeregisterEventTopicInputOperationOutputAlias,
                crate::output::DeregisterEventTopicOutput,
                crate::error::DeregisterEventTopicError,
                crate::input::DeregisterEventTopicInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Directory ID to remove as a publisher. This directory will no longer send messages to the specified Amazon SNS topic.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The Directory ID to remove as a publisher. This directory will no longer send messages to the specified Amazon SNS topic.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The name of the Amazon SNS topic from which to remove the directory as a publisher.</p>
        pub fn topic_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.topic_name(input.into());
            self
        }
        /// <p>The name of the Amazon SNS topic from which to remove the directory as a publisher.</p>
        pub fn set_topic_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_topic_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCertificate`.
    ///
    /// <p>Displays information about the certificate registered for secure LDAP or client certificate authentication.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_certificate_input::Builder,
    }
    impl<C, M, R> DescribeCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCertificateInputOperationOutputAlias,
                crate::output::DescribeCertificateOutput,
                crate::error::DescribeCertificateError,
                crate::input::DescribeCertificateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The identifier of the certificate.</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_id(input.into());
            self
        }
        /// <p>The identifier of the certificate.</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeClientAuthenticationSettings`.
    ///
    /// <p>Retrieves information about the type of client authentication for the specified directory, if the type is specified. If no type is specified, information about all client authentication types that are supported for the specified directory is retrieved. Currently, only <code>SmartCard</code> is supported. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeClientAuthenticationSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_client_authentication_settings_input::Builder,
    }
    impl<C, M, R> DescribeClientAuthenticationSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeClientAuthenticationSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClientAuthenticationSettingsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeClientAuthenticationSettingsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeClientAuthenticationSettingsInputOperationOutputAlias,
                crate::output::DescribeClientAuthenticationSettingsOutput,
                crate::error::DescribeClientAuthenticationSettingsError,
                crate::input::DescribeClientAuthenticationSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory for which to retrieve information.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory for which to retrieve information.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The type of client authentication for which to retrieve information. If no type is specified, a list of all client authentication types that are supported for the specified directory is retrieved.</p>
        pub fn r#type(mut self, input: crate::model::ClientAuthenticationType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of client authentication for which to retrieve information. If no type is specified, a list of all client authentication types that are supported for the specified directory is retrieved.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ClientAuthenticationType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The <i>DescribeClientAuthenticationSettingsResult.NextToken</i> value from a previous call to <code>DescribeClientAuthenticationSettings</code>. Pass null if this is the first call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <i>DescribeClientAuthenticationSettingsResult.NextToken</i> value from a previous call to <code>DescribeClientAuthenticationSettings</code>. Pass null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return. If this value is zero, the maximum number of items is specified by the limitations of the operation. </p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of items to return. If this value is zero, the maximum number of items is specified by the limitations of the operation. </p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConditionalForwarders`.
    ///
    /// <p>Obtains information about the conditional forwarders for this account.</p>
    /// <p>If no input parameters are provided for RemoteDomainNames, this request describes all conditional forwarders for the specified directory ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConditionalForwarders<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_conditional_forwarders_input::Builder,
    }
    impl<C, M, R> DescribeConditionalForwarders<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeConditionalForwarders`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConditionalForwardersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConditionalForwardersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeConditionalForwardersInputOperationOutputAlias,
                crate::output::DescribeConditionalForwardersOutput,
                crate::error::DescribeConditionalForwardersError,
                crate::input::DescribeConditionalForwardersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The directory ID for which to get the list of associated conditional forwarders.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The directory ID for which to get the list of associated conditional forwarders.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// Appends an item to `RemoteDomainNames`.
        ///
        /// To override the contents of this collection use [`set_remote_domain_names`](Self::set_remote_domain_names).
        ///
        /// <p>The fully qualified domain names (FQDN) of the remote domains for which to get the list of associated conditional forwarders. If this member is null, all conditional forwarders are returned.</p>
        pub fn remote_domain_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.remote_domain_names(input.into());
            self
        }
        /// <p>The fully qualified domain names (FQDN) of the remote domains for which to get the list of associated conditional forwarders. If this member is null, all conditional forwarders are returned.</p>
        pub fn set_remote_domain_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_remote_domain_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDirectories`.
    ///
    /// <p>Obtains information about the directories that belong to this account.</p>
    /// <p>You can retrieve information about specific directories by passing the directory identifiers in the <code>DirectoryIds</code> parameter. Otherwise, all directories that belong to the current account are returned.</p>
    /// <p>This operation supports pagination with the use of the <code>NextToken</code> request and response parameters. If more results are available, the <code>DescribeDirectoriesResult.NextToken</code> member contains a token that you pass in the next call to <code>DescribeDirectories</code> to retrieve the next set of items.</p>
    /// <p>You can also specify a maximum number of return results with the <code>Limit</code> parameter.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDirectories<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_directories_input::Builder,
    }
    impl<C, M, R> DescribeDirectories<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDirectories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDirectoriesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDirectoriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDirectoriesInputOperationOutputAlias,
                crate::output::DescribeDirectoriesOutput,
                crate::error::DescribeDirectoriesError,
                crate::input::DescribeDirectoriesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `DirectoryIds`.
        ///
        /// To override the contents of this collection use [`set_directory_ids`](Self::set_directory_ids).
        ///
        /// <p>A list of identifiers of the directories for which to obtain the information. If this member is null, all directories that belong to the current account are returned.</p>
        /// <p>An empty list results in an <code>InvalidParameterException</code> being thrown.</p>
        pub fn directory_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_ids(input.into());
            self
        }
        /// <p>A list of identifiers of the directories for which to obtain the information. If this member is null, all directories that belong to the current account are returned.</p>
        /// <p>An empty list results in an <code>InvalidParameterException</code> being thrown.</p>
        pub fn set_directory_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_directory_ids(input);
            self
        }
        /// <p>The <code>DescribeDirectoriesResult.NextToken</code> value from a previous call to <code>DescribeDirectories</code>. Pass null if this is the first call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>DescribeDirectoriesResult.NextToken</code> value from a previous call to <code>DescribeDirectories</code>. Pass null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return. If this value is zero, the maximum number of items is specified by the limitations of the operation.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of items to return. If this value is zero, the maximum number of items is specified by the limitations of the operation.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDomainControllers`.
    ///
    /// <p>Provides information about any domain controllers in your directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDomainControllers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_domain_controllers_input::Builder,
    }
    impl<C, M, R> DescribeDomainControllers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDomainControllers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDomainControllersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDomainControllersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDomainControllersInputOperationOutputAlias,
                crate::output::DescribeDomainControllersOutput,
                crate::error::DescribeDomainControllersError,
                crate::input::DescribeDomainControllersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeDomainControllersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeDomainControllersPaginator<C, M, R> {
            crate::paginator::DescribeDomainControllersPaginator::new(self.handle, self.inner)
        }
        /// <p>Identifier of the directory for which to retrieve the domain controller information.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>Identifier of the directory for which to retrieve the domain controller information.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// Appends an item to `DomainControllerIds`.
        ///
        /// To override the contents of this collection use [`set_domain_controller_ids`](Self::set_domain_controller_ids).
        ///
        /// <p>A list of identifiers for the domain controllers whose information will be provided.</p>
        pub fn domain_controller_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_controller_ids(input.into());
            self
        }
        /// <p>A list of identifiers for the domain controllers whose information will be provided.</p>
        pub fn set_domain_controller_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_domain_controller_ids(input);
            self
        }
        /// <p>The <i>DescribeDomainControllers.NextToken</i> value from a previous call to <code>DescribeDomainControllers</code>. Pass null if this is the first call. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <i>DescribeDomainControllers.NextToken</i> value from a previous call to <code>DescribeDomainControllers</code>. Pass null if this is the first call. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventTopics`.
    ///
    /// <p>Obtains information about which Amazon SNS topics receive status messages from the specified directory.</p>
    /// <p>If no input parameters are provided, such as DirectoryId or TopicName, this request describes all of the associations in the account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEventTopics<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_event_topics_input::Builder,
    }
    impl<C, M, R> DescribeEventTopics<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEventTopics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventTopicsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventTopicsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEventTopicsInputOperationOutputAlias,
                crate::output::DescribeEventTopicsOutput,
                crate::error::DescribeEventTopicsError,
                crate::input::DescribeEventTopicsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Directory ID for which to get the list of associated Amazon SNS topics. If this member is null, associations for all Directory IDs are returned.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The Directory ID for which to get the list of associated Amazon SNS topics. If this member is null, associations for all Directory IDs are returned.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// Appends an item to `TopicNames`.
        ///
        /// To override the contents of this collection use [`set_topic_names`](Self::set_topic_names).
        ///
        /// <p>A list of Amazon SNS topic names for which to obtain the information. If this member is null, all associations for the specified Directory ID are returned.</p>
        /// <p>An empty list results in an <code>InvalidParameterException</code> being thrown.</p>
        pub fn topic_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.topic_names(input.into());
            self
        }
        /// <p>A list of Amazon SNS topic names for which to obtain the information. If this member is null, all associations for the specified Directory ID are returned.</p>
        /// <p>An empty list results in an <code>InvalidParameterException</code> being thrown.</p>
        pub fn set_topic_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_topic_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLDAPSSettings`.
    ///
    /// <p>Describes the status of LDAP security for the specified directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLDAPSSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_ldaps_settings_input::Builder,
    }
    impl<C, M, R> DescribeLDAPSSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeLDAPSSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLdapsSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLDAPSSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeLdapsSettingsInputOperationOutputAlias,
                crate::output::DescribeLdapsSettingsOutput,
                crate::error::DescribeLDAPSSettingsError,
                crate::input::DescribeLdapsSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The type of LDAP security to enable. Currently only the value <code>Client</code> is supported.</p>
        pub fn r#type(mut self, input: crate::model::LdapsType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of LDAP security to enable. Currently only the value <code>Client</code> is supported.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::LdapsType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The type of next token used for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The type of next token used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifies the number of items that should be displayed on one page.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Specifies the number of items that should be displayed on one page.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRegions`.
    ///
    /// <p>Provides information about the Regions that are configured for multi-Region replication.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRegions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_regions_input::Builder,
    }
    impl<C, M, R> DescribeRegions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRegions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRegionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRegionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRegionsInputOperationOutputAlias,
                crate::output::DescribeRegionsOutput,
                crate::error::DescribeRegionsError,
                crate::input::DescribeRegionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The name of the Region. For example, <code>us-east-1</code>.</p>
        pub fn region_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.region_name(input.into());
            self
        }
        /// <p>The name of the Region. For example, <code>us-east-1</code>.</p>
        pub fn set_region_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_region_name(input);
            self
        }
        /// <p>The <code>DescribeRegionsResult.NextToken</code> value from a previous call to <code>DescribeRegions</code>. Pass null if this is the first call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>DescribeRegionsResult.NextToken</code> value from a previous call to <code>DescribeRegions</code>. Pass null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSharedDirectories`.
    ///
    /// <p>Returns the shared directories in your account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSharedDirectories<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_shared_directories_input::Builder,
    }
    impl<C, M, R> DescribeSharedDirectories<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSharedDirectories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSharedDirectoriesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSharedDirectoriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSharedDirectoriesInputOperationOutputAlias,
                crate::output::DescribeSharedDirectoriesOutput,
                crate::error::DescribeSharedDirectoriesError,
                crate::input::DescribeSharedDirectoriesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Returns the identifier of the directory in the directory owner account. </p>
        pub fn owner_directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner_directory_id(input.into());
            self
        }
        /// <p>Returns the identifier of the directory in the directory owner account. </p>
        pub fn set_owner_directory_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_owner_directory_id(input);
            self
        }
        /// Appends an item to `SharedDirectoryIds`.
        ///
        /// To override the contents of this collection use [`set_shared_directory_ids`](Self::set_shared_directory_ids).
        ///
        /// <p>A list of identifiers of all shared directories in your account. </p>
        pub fn shared_directory_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.shared_directory_ids(input.into());
            self
        }
        /// <p>A list of identifiers of all shared directories in your account. </p>
        pub fn set_shared_directory_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_shared_directory_ids(input);
            self
        }
        /// <p>The <code>DescribeSharedDirectoriesResult.NextToken</code> value from a previous call to <code>DescribeSharedDirectories</code>. Pass null if this is the first call. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>DescribeSharedDirectoriesResult.NextToken</code> value from a previous call to <code>DescribeSharedDirectories</code>. Pass null if this is the first call. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of shared directories to return in the response object.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The number of shared directories to return in the response object.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSnapshots`.
    ///
    /// <p>Obtains information about the directory snapshots that belong to this account.</p>
    /// <p>This operation supports pagination with the use of the <i>NextToken</i> request and response parameters. If more results are available, the <i>DescribeSnapshots.NextToken</i> member contains a token that you pass in the next call to <code>DescribeSnapshots</code> to retrieve the next set of items.</p>
    /// <p>You can also specify a maximum number of return results with the <i>Limit</i> parameter.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSnapshots<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_snapshots_input::Builder,
    }
    impl<C, M, R> DescribeSnapshots<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSnapshots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSnapshotsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSnapshotsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSnapshotsInputOperationOutputAlias,
                crate::output::DescribeSnapshotsOutput,
                crate::error::DescribeSnapshotsError,
                crate::input::DescribeSnapshotsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory for which to retrieve snapshot information.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory for which to retrieve snapshot information.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// Appends an item to `SnapshotIds`.
        ///
        /// To override the contents of this collection use [`set_snapshot_ids`](Self::set_snapshot_ids).
        ///
        /// <p>A list of identifiers of the snapshots to obtain the information for. If this member is null or empty, all snapshots are returned using the <i>Limit</i> and <i>NextToken</i> members.</p>
        pub fn snapshot_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_ids(input.into());
            self
        }
        /// <p>A list of identifiers of the snapshots to obtain the information for. If this member is null or empty, all snapshots are returned using the <i>Limit</i> and <i>NextToken</i> members.</p>
        pub fn set_snapshot_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_ids(input);
            self
        }
        /// <p>The <i>DescribeSnapshotsResult.NextToken</i> value from a previous call to <code>DescribeSnapshots</code>. Pass null if this is the first call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <i>DescribeSnapshotsResult.NextToken</i> value from a previous call to <code>DescribeSnapshots</code>. Pass null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of objects to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTrusts`.
    ///
    /// <p>Obtains information about the trust relationships for this account.</p>
    /// <p>If no input parameters are provided, such as DirectoryId or TrustIds, this request describes all the trust relationships belonging to the account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTrusts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_trusts_input::Builder,
    }
    impl<C, M, R> DescribeTrusts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTrusts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTrustsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTrustsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTrustsInputOperationOutputAlias,
                crate::output::DescribeTrustsOutput,
                crate::error::DescribeTrustsError,
                crate::input::DescribeTrustsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Directory ID of the Amazon Web Services directory that is a part of the requested trust relationship.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The Directory ID of the Amazon Web Services directory that is a part of the requested trust relationship.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// Appends an item to `TrustIds`.
        ///
        /// To override the contents of this collection use [`set_trust_ids`](Self::set_trust_ids).
        ///
        /// <p>A list of identifiers of the trust relationships for which to obtain the information. If this member is null, all trust relationships that belong to the current account are returned.</p>
        /// <p>An empty list results in an <code>InvalidParameterException</code> being thrown.</p>
        pub fn trust_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trust_ids(input.into());
            self
        }
        /// <p>A list of identifiers of the trust relationships for which to obtain the information. If this member is null, all trust relationships that belong to the current account are returned.</p>
        /// <p>An empty list results in an <code>InvalidParameterException</code> being thrown.</p>
        pub fn set_trust_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_trust_ids(input);
            self
        }
        /// <p>The <i>DescribeTrustsResult.NextToken</i> value from a previous call to <code>DescribeTrusts</code>. Pass null if this is the first call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <i>DescribeTrustsResult.NextToken</i> value from a previous call to <code>DescribeTrusts</code>. Pass null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of objects to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableClientAuthentication`.
    ///
    /// <p>Disables alternative client authentication methods for the specified directory. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableClientAuthentication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_client_authentication_input::Builder,
    }
    impl<C, M, R> DisableClientAuthentication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableClientAuthentication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableClientAuthenticationOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableClientAuthenticationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableClientAuthenticationInputOperationOutputAlias,
                crate::output::DisableClientAuthenticationOutput,
                crate::error::DisableClientAuthenticationError,
                crate::input::DisableClientAuthenticationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory </p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory </p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The type of client authentication to disable. Currently, only the parameter, <code>SmartCard</code> is supported.</p>
        pub fn r#type(mut self, input: crate::model::ClientAuthenticationType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of client authentication to disable. Currently, only the parameter, <code>SmartCard</code> is supported.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ClientAuthenticationType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableLDAPS`.
    ///
    /// <p>Deactivates LDAP secure calls for the specified directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableLDAPS<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_ldaps_input::Builder,
    }
    impl<C, M, R> DisableLDAPS<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableLDAPS`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableLdapsOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableLDAPSError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableLdapsInputOperationOutputAlias,
                crate::output::DisableLdapsOutput,
                crate::error::DisableLDAPSError,
                crate::input::DisableLdapsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The type of LDAP security to enable. Currently only the value <code>Client</code> is supported.</p>
        pub fn r#type(mut self, input: crate::model::LdapsType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of LDAP security to enable. Currently only the value <code>Client</code> is supported.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::LdapsType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableRadius`.
    ///
    /// <p>Disables multi-factor authentication (MFA) with the Remote Authentication Dial In User Service (RADIUS) server for an AD Connector or Microsoft AD directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableRadius<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_radius_input::Builder,
    }
    impl<C, M, R> DisableRadius<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableRadius`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableRadiusOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableRadiusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableRadiusInputOperationOutputAlias,
                crate::output::DisableRadiusOutput,
                crate::error::DisableRadiusError,
                crate::input::DisableRadiusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory for which to disable MFA.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory for which to disable MFA.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableSso`.
    ///
    /// <p>Disables single-sign on for a directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableSso<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_sso_input::Builder,
    }
    impl<C, M, R> DisableSso<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableSso`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableSsoOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableSsoError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableSsoInputOperationOutputAlias,
                crate::output::DisableSsoOutput,
                crate::error::DisableSsoError,
                crate::input::DisableSsoInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory for which to disable single-sign on.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory for which to disable single-sign on.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The username of an alternate account to use to disable single-sign on. This is only used for AD Connector directories. This account must have privileges to remove a service principal name.</p>
        /// <p>If the AD Connector service account does not have privileges to remove a service principal name, you can specify an alternate account with the <i>UserName</i> and <i>Password</i> parameters. These credentials are only used to disable single sign-on and are not stored by the service. The AD Connector service account is not changed.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(input.into());
            self
        }
        /// <p>The username of an alternate account to use to disable single-sign on. This is only used for AD Connector directories. This account must have privileges to remove a service principal name.</p>
        /// <p>If the AD Connector service account does not have privileges to remove a service principal name, you can specify an alternate account with the <i>UserName</i> and <i>Password</i> parameters. These credentials are only used to disable single sign-on and are not stored by the service. The AD Connector service account is not changed.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The password of an alternate account to use to disable single-sign on. This is only used for AD Connector directories. For more information, see the <i>UserName</i> parameter.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(input.into());
            self
        }
        /// <p>The password of an alternate account to use to disable single-sign on. This is only used for AD Connector directories. For more information, see the <i>UserName</i> parameter.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableClientAuthentication`.
    ///
    /// <p>Enables alternative client authentication methods for the specified directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableClientAuthentication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_client_authentication_input::Builder,
    }
    impl<C, M, R> EnableClientAuthentication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableClientAuthentication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableClientAuthenticationOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableClientAuthenticationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableClientAuthenticationInputOperationOutputAlias,
                crate::output::EnableClientAuthenticationOutput,
                crate::error::EnableClientAuthenticationError,
                crate::input::EnableClientAuthenticationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the specified directory. </p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the specified directory. </p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The type of client authentication to enable. Currently only the value <code>SmartCard</code> is supported. Smart card authentication in AD Connector requires that you enable Kerberos Constrained Delegation for the Service User to the LDAP service in your self-managed AD. </p>
        pub fn r#type(mut self, input: crate::model::ClientAuthenticationType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of client authentication to enable. Currently only the value <code>SmartCard</code> is supported. Smart card authentication in AD Connector requires that you enable Kerberos Constrained Delegation for the Service User to the LDAP service in your self-managed AD. </p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ClientAuthenticationType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableLDAPS`.
    ///
    /// <p>Activates the switch for the specific directory to always use LDAP secure calls.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableLDAPS<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_ldaps_input::Builder,
    }
    impl<C, M, R> EnableLDAPS<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableLDAPS`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableLdapsOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableLDAPSError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableLdapsInputOperationOutputAlias,
                crate::output::EnableLdapsOutput,
                crate::error::EnableLDAPSError,
                crate::input::EnableLdapsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The type of LDAP security to enable. Currently only the value <code>Client</code> is supported.</p>
        pub fn r#type(mut self, input: crate::model::LdapsType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of LDAP security to enable. Currently only the value <code>Client</code> is supported.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::LdapsType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableRadius`.
    ///
    /// <p>Enables multi-factor authentication (MFA) with the Remote Authentication Dial In User Service (RADIUS) server for an AD Connector or Microsoft AD directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableRadius<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_radius_input::Builder,
    }
    impl<C, M, R> EnableRadius<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableRadius`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableRadiusOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableRadiusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableRadiusInputOperationOutputAlias,
                crate::output::EnableRadiusOutput,
                crate::error::EnableRadiusError,
                crate::input::EnableRadiusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory for which to enable MFA.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory for which to enable MFA.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>A <code>RadiusSettings</code> object that contains information about the RADIUS server.</p>
        pub fn radius_settings(mut self, input: crate::model::RadiusSettings) -> Self {
            self.inner = self.inner.radius_settings(input);
            self
        }
        /// <p>A <code>RadiusSettings</code> object that contains information about the RADIUS server.</p>
        pub fn set_radius_settings(
            mut self,
            input: std::option::Option<crate::model::RadiusSettings>,
        ) -> Self {
            self.inner = self.inner.set_radius_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableSso`.
    ///
    /// <p>Enables single sign-on for a directory. Single sign-on allows users in your directory to access certain Amazon Web Services services from a computer joined to the directory without having to enter their credentials separately.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableSso<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_sso_input::Builder,
    }
    impl<C, M, R> EnableSso<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableSso`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableSsoOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableSsoError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableSsoInputOperationOutputAlias,
                crate::output::EnableSsoOutput,
                crate::error::EnableSsoError,
                crate::input::EnableSsoInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory for which to enable single-sign on.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory for which to enable single-sign on.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The username of an alternate account to use to enable single-sign on. This is only used for AD Connector directories. This account must have privileges to add a service principal name.</p>
        /// <p>If the AD Connector service account does not have privileges to add a service principal name, you can specify an alternate account with the <i>UserName</i> and <i>Password</i> parameters. These credentials are only used to enable single sign-on and are not stored by the service. The AD Connector service account is not changed.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(input.into());
            self
        }
        /// <p>The username of an alternate account to use to enable single-sign on. This is only used for AD Connector directories. This account must have privileges to add a service principal name.</p>
        /// <p>If the AD Connector service account does not have privileges to add a service principal name, you can specify an alternate account with the <i>UserName</i> and <i>Password</i> parameters. These credentials are only used to enable single sign-on and are not stored by the service. The AD Connector service account is not changed.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The password of an alternate account to use to enable single-sign on. This is only used for AD Connector directories. For more information, see the <i>UserName</i> parameter.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(input.into());
            self
        }
        /// <p>The password of an alternate account to use to enable single-sign on. This is only used for AD Connector directories. For more information, see the <i>UserName</i> parameter.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDirectoryLimits`.
    ///
    /// <p>Obtains directory limit information for the current Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDirectoryLimits<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_directory_limits_input::Builder,
    }
    impl<C, M, R> GetDirectoryLimits<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDirectoryLimits`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDirectoryLimitsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDirectoryLimitsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDirectoryLimitsInputOperationOutputAlias,
                crate::output::GetDirectoryLimitsOutput,
                crate::error::GetDirectoryLimitsError,
                crate::input::GetDirectoryLimitsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetSnapshotLimits`.
    ///
    /// <p>Obtains the manual snapshot limits for a directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSnapshotLimits<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_snapshot_limits_input::Builder,
    }
    impl<C, M, R> GetSnapshotLimits<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSnapshotLimits`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSnapshotLimitsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSnapshotLimitsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSnapshotLimitsInputOperationOutputAlias,
                crate::output::GetSnapshotLimitsOutput,
                crate::error::GetSnapshotLimitsError,
                crate::input::GetSnapshotLimitsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Contains the identifier of the directory to obtain the limits for.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>Contains the identifier of the directory to obtain the limits for.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCertificates`.
    ///
    /// <p>For the specified directory, lists all the certificates registered for a secure LDAP or client certificate authentication.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCertificates<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_certificates_input::Builder,
    }
    impl<C, M, R> ListCertificates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCertificates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCertificatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCertificatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCertificatesInputOperationOutputAlias,
                crate::output::ListCertificatesOutput,
                crate::error::ListCertificatesError,
                crate::input::ListCertificatesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>A token for requesting another page of certificates if the <code>NextToken</code> response element indicates that more certificates are available. Use the value of the returned <code>NextToken</code> element in your request until the token comes back as <code>null</code>. Pass <code>null</code> if this is the first call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token for requesting another page of certificates if the <code>NextToken</code> response element indicates that more certificates are available. Use the value of the returned <code>NextToken</code> element in your request until the token comes back as <code>null</code>. Pass <code>null</code> if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of items that should show up on one page</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The number of items that should show up on one page</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIpRoutes`.
    ///
    /// <p>Lists the address blocks that you have added to a directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListIpRoutes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_ip_routes_input::Builder,
    }
    impl<C, M, R> ListIpRoutes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListIpRoutes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIpRoutesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIpRoutesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListIpRoutesInputOperationOutputAlias,
                crate::output::ListIpRoutesOutput,
                crate::error::ListIpRoutesError,
                crate::input::ListIpRoutesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier (ID) of the directory for which you want to retrieve the IP addresses.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>Identifier (ID) of the directory for which you want to retrieve the IP addresses.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The <i>ListIpRoutes.NextToken</i> value from a previous call to <code>ListIpRoutes</code>. Pass null if this is the first call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <i>ListIpRoutes.NextToken</i> value from a previous call to <code>ListIpRoutes</code>. Pass null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of items to return. If this value is zero, the maximum number of items is specified by the limitations of the operation.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Maximum number of items to return. If this value is zero, the maximum number of items is specified by the limitations of the operation.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLogSubscriptions`.
    ///
    /// <p>Lists the active log subscriptions for the Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLogSubscriptions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_log_subscriptions_input::Builder,
    }
    impl<C, M, R> ListLogSubscriptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLogSubscriptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLogSubscriptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLogSubscriptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLogSubscriptionsInputOperationOutputAlias,
                crate::output::ListLogSubscriptionsOutput,
                crate::error::ListLogSubscriptionsError,
                crate::input::ListLogSubscriptionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If a <i>DirectoryID</i> is provided, lists only the log subscription associated with that directory. If no <i>DirectoryId</i> is provided, lists all log subscriptions associated with your Amazon Web Services account. If there are no log subscriptions for the Amazon Web Services account or the directory, an empty list will be returned.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>If a <i>DirectoryID</i> is provided, lists only the log subscription associated with that directory. If no <i>DirectoryId</i> is provided, lists all log subscriptions associated with your Amazon Web Services account. If there are no log subscriptions for the Amazon Web Services account or the directory, an empty list will be returned.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The token for the next set of items to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items returned.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of items returned.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSchemaExtensions`.
    ///
    /// <p>Lists all schema extensions applied to a Microsoft AD Directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSchemaExtensions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_schema_extensions_input::Builder,
    }
    impl<C, M, R> ListSchemaExtensions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSchemaExtensions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSchemaExtensionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSchemaExtensionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSchemaExtensionsInputOperationOutputAlias,
                crate::output::ListSchemaExtensionsOutput,
                crate::error::ListSchemaExtensionsError,
                crate::input::ListSchemaExtensionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory from which to retrieve the schema extension information.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory from which to retrieve the schema extension information.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The <code>ListSchemaExtensions.NextToken</code> value from a previous call to <code>ListSchemaExtensions</code>. Pass null if this is the first call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>ListSchemaExtensions.NextToken</code> value from a previous call to <code>ListSchemaExtensions</code>. Pass null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists all tags on a directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier (ID) of the directory for which you want to retrieve tags.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>Identifier (ID) of the directory for which you want to retrieve tags.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterCertificate`.
    ///
    /// <p>Registers a certificate for a secure LDAP or client certificate authentication.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_certificate_input::Builder,
    }
    impl<C, M, R> RegisterCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterCertificateInputOperationOutputAlias,
                crate::output::RegisterCertificateOutput,
                crate::error::RegisterCertificateError,
                crate::input::RegisterCertificateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The certificate PEM string that needs to be registered.</p>
        pub fn certificate_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_data(input.into());
            self
        }
        /// <p>The certificate PEM string that needs to be registered.</p>
        pub fn set_certificate_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_data(input);
            self
        }
        /// <p>The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.</p>
        pub fn r#type(mut self, input: crate::model::CertificateType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::CertificateType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>A <code>ClientCertAuthSettings</code> object that contains client certificate authentication settings.</p>
        pub fn client_cert_auth_settings(
            mut self,
            input: crate::model::ClientCertAuthSettings,
        ) -> Self {
            self.inner = self.inner.client_cert_auth_settings(input);
            self
        }
        /// <p>A <code>ClientCertAuthSettings</code> object that contains client certificate authentication settings.</p>
        pub fn set_client_cert_auth_settings(
            mut self,
            input: std::option::Option<crate::model::ClientCertAuthSettings>,
        ) -> Self {
            self.inner = self.inner.set_client_cert_auth_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterEventTopic`.
    ///
    /// <p>Associates a directory with an Amazon SNS topic. This establishes the directory as a publisher to the specified Amazon SNS topic. You can then receive email or text (SMS) messages when the status of your directory changes. You get notified if your directory goes from an Active status to an Impaired or Inoperable status. You also receive a notification when the directory returns to an Active status.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterEventTopic<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_event_topic_input::Builder,
    }
    impl<C, M, R> RegisterEventTopic<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterEventTopic`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterEventTopicOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterEventTopicError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterEventTopicInputOperationOutputAlias,
                crate::output::RegisterEventTopicOutput,
                crate::error::RegisterEventTopicError,
                crate::input::RegisterEventTopicInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Directory ID that will publish status messages to the Amazon SNS topic.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The Directory ID that will publish status messages to the Amazon SNS topic.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The Amazon SNS topic name to which the directory will publish status messages. This Amazon SNS topic must be in the same region as the specified Directory ID.</p>
        pub fn topic_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.topic_name(input.into());
            self
        }
        /// <p>The Amazon SNS topic name to which the directory will publish status messages. This Amazon SNS topic must be in the same region as the specified Directory ID.</p>
        pub fn set_topic_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_topic_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RejectSharedDirectory`.
    ///
    /// <p>Rejects a directory sharing request that was sent from the directory owner account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RejectSharedDirectory<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reject_shared_directory_input::Builder,
    }
    impl<C, M, R> RejectSharedDirectory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RejectSharedDirectory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RejectSharedDirectoryOutput,
            aws_smithy_http::result::SdkError<crate::error::RejectSharedDirectoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RejectSharedDirectoryInputOperationOutputAlias,
                crate::output::RejectSharedDirectoryOutput,
                crate::error::RejectSharedDirectoryError,
                crate::input::RejectSharedDirectoryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier of the shared directory in the directory consumer account. This identifier is different for each directory owner account.</p>
        pub fn shared_directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.shared_directory_id(input.into());
            self
        }
        /// <p>Identifier of the shared directory in the directory consumer account. This identifier is different for each directory owner account.</p>
        pub fn set_shared_directory_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_shared_directory_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveIpRoutes`.
    ///
    /// <p>Removes IP address blocks from a directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveIpRoutes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_ip_routes_input::Builder,
    }
    impl<C, M, R> RemoveIpRoutes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveIpRoutes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveIpRoutesOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveIpRoutesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveIpRoutesInputOperationOutputAlias,
                crate::output::RemoveIpRoutesOutput,
                crate::error::RemoveIpRoutesError,
                crate::input::RemoveIpRoutesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier (ID) of the directory from which you want to remove the IP addresses.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>Identifier (ID) of the directory from which you want to remove the IP addresses.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// Appends an item to `CidrIps`.
        ///
        /// To override the contents of this collection use [`set_cidr_ips`](Self::set_cidr_ips).
        ///
        /// <p>IP address blocks that you want to remove.</p>
        pub fn cidr_ips(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cidr_ips(input.into());
            self
        }
        /// <p>IP address blocks that you want to remove.</p>
        pub fn set_cidr_ips(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cidr_ips(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveRegion`.
    ///
    /// <p>Stops all replication and removes the domain controllers from the specified Region. You cannot remove the primary Region with this operation. Instead, use the <code>DeleteDirectory</code> API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveRegion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_region_input::Builder,
    }
    impl<C, M, R> RemoveRegion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveRegion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveRegionOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveRegionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveRegionInputOperationOutputAlias,
                crate::output::RemoveRegionOutput,
                crate::error::RemoveRegionError,
                crate::input::RemoveRegionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory for which you want to remove Region replication.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory for which you want to remove Region replication.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveTagsFromResource`.
    ///
    /// <p>Removes tags from a directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveTagsFromResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_tags_from_resource_input::Builder,
    }
    impl<C, M, R> RemoveTagsFromResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveTagsFromResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveTagsFromResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveTagsFromResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveTagsFromResourceInputOperationOutputAlias,
                crate::output::RemoveTagsFromResourceOutput,
                crate::error::RemoveTagsFromResourceError,
                crate::input::RemoveTagsFromResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier (ID) of the directory from which to remove the tag.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>Identifier (ID) of the directory from which to remove the tag.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag key (name) of the tag to be removed.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag key (name) of the tag to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResetUserPassword`.
    ///
    /// <p>Resets the password for any user in your Managed Microsoft AD or Simple AD directory.</p>
    /// <p>You can reset the password for any user in your directory with the following exceptions:</p>
    /// <ul>
    /// <li> <p>For Simple AD, you cannot reset the password for any user that is a member of either the <b>Domain Admins</b> or <b>Enterprise Admins</b> group except for the administrator user.</p> </li>
    /// <li> <p>For Managed Microsoft AD, you can only reset the password for a user that is in an OU based off of the NetBIOS name that you typed when you created your directory. For example, you cannot reset the password for a user in the <b>Amazon Web Services Reserved</b> OU. For more information about the OU structure for an Managed Microsoft AD directory, see <a href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ms_ad_getting_started_what_gets_created.html">What Gets Created</a> in the <i>Directory Service Administration Guide</i>.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ResetUserPassword<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reset_user_password_input::Builder,
    }
    impl<C, M, R> ResetUserPassword<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResetUserPassword`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResetUserPasswordOutput,
            aws_smithy_http::result::SdkError<crate::error::ResetUserPasswordError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResetUserPasswordInputOperationOutputAlias,
                crate::output::ResetUserPasswordOutput,
                crate::error::ResetUserPasswordError,
                crate::input::ResetUserPasswordInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier of the Managed Microsoft AD or Simple AD directory in which the user resides.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>Identifier of the Managed Microsoft AD or Simple AD directory in which the user resides.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The user name of the user whose password will be reset.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(input.into());
            self
        }
        /// <p>The user name of the user whose password will be reset.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The new password that will be reset.</p>
        pub fn new_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_password(input.into());
            self
        }
        /// <p>The new password that will be reset.</p>
        pub fn set_new_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_new_password(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestoreFromSnapshot`.
    ///
    /// <p>Restores a directory using an existing directory snapshot.</p>
    /// <p>When you restore a directory from a snapshot, any changes made to the directory after the snapshot date are overwritten.</p>
    /// <p>This action returns as soon as the restore operation is initiated. You can monitor the progress of the restore operation by calling the <code>DescribeDirectories</code> operation with the directory identifier. When the <b>DirectoryDescription.Stage</b> value changes to <code>Active</code>, the restore operation is complete.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RestoreFromSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::restore_from_snapshot_input::Builder,
    }
    impl<C, M, R> RestoreFromSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RestoreFromSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestoreFromSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::RestoreFromSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RestoreFromSnapshotInputOperationOutputAlias,
                crate::output::RestoreFromSnapshotOutput,
                crate::error::RestoreFromSnapshotError,
                crate::input::RestoreFromSnapshotInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the snapshot to restore from.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_id(input.into());
            self
        }
        /// <p>The identifier of the snapshot to restore from.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_snapshot_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ShareDirectory`.
    ///
    /// <p>Shares a specified directory (<code>DirectoryId</code>) in your Amazon Web Services account (directory owner) with another Amazon Web Services account (directory consumer). With this operation you can use your directory from any Amazon Web Services account and from any Amazon VPC within an Amazon Web Services Region.</p>
    /// <p>When you share your Managed Microsoft AD directory, Directory Service creates a shared directory in the directory consumer account. This shared directory contains the metadata to provide access to the directory within the directory owner account. The shared directory is visible in all VPCs in the directory consumer account.</p>
    /// <p>The <code>ShareMethod</code> parameter determines whether the specified directory can be shared between Amazon Web Services accounts inside the same Amazon Web Services organization (<code>ORGANIZATIONS</code>). It also determines whether you can share the directory with any other Amazon Web Services account either inside or outside of the organization (<code>HANDSHAKE</code>).</p>
    /// <p>The <code>ShareNotes</code> parameter is only used when <code>HANDSHAKE</code> is called, which sends a directory sharing request to the directory consumer. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ShareDirectory<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::share_directory_input::Builder,
    }
    impl<C, M, R> ShareDirectory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ShareDirectory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ShareDirectoryOutput,
            aws_smithy_http::result::SdkError<crate::error::ShareDirectoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ShareDirectoryInputOperationOutputAlias,
                crate::output::ShareDirectoryOutput,
                crate::error::ShareDirectoryError,
                crate::input::ShareDirectoryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier of the Managed Microsoft AD directory that you want to share with other Amazon Web Services accounts.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>Identifier of the Managed Microsoft AD directory that you want to share with other Amazon Web Services accounts.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>A directory share request that is sent by the directory owner to the directory consumer. The request includes a typed message to help the directory consumer administrator determine whether to approve or reject the share invitation.</p>
        pub fn share_notes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.share_notes(input.into());
            self
        }
        /// <p>A directory share request that is sent by the directory owner to the directory consumer. The request includes a typed message to help the directory consumer administrator determine whether to approve or reject the share invitation.</p>
        pub fn set_share_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_share_notes(input);
            self
        }
        /// <p>Identifier for the directory consumer account with whom the directory is to be shared.</p>
        pub fn share_target(mut self, input: crate::model::ShareTarget) -> Self {
            self.inner = self.inner.share_target(input);
            self
        }
        /// <p>Identifier for the directory consumer account with whom the directory is to be shared.</p>
        pub fn set_share_target(
            mut self,
            input: std::option::Option<crate::model::ShareTarget>,
        ) -> Self {
            self.inner = self.inner.set_share_target(input);
            self
        }
        /// <p>The method used when sharing a directory to determine whether the directory should be shared within your Amazon Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services account by sending a directory sharing request (<code>HANDSHAKE</code>).</p>
        pub fn share_method(mut self, input: crate::model::ShareMethod) -> Self {
            self.inner = self.inner.share_method(input);
            self
        }
        /// <p>The method used when sharing a directory to determine whether the directory should be shared within your Amazon Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services account by sending a directory sharing request (<code>HANDSHAKE</code>).</p>
        pub fn set_share_method(
            mut self,
            input: std::option::Option<crate::model::ShareMethod>,
        ) -> Self {
            self.inner = self.inner.set_share_method(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartSchemaExtension`.
    ///
    /// <p>Applies a schema extension to a Microsoft AD directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartSchemaExtension<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_schema_extension_input::Builder,
    }
    impl<C, M, R> StartSchemaExtension<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartSchemaExtension`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartSchemaExtensionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartSchemaExtensionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartSchemaExtensionInputOperationOutputAlias,
                crate::output::StartSchemaExtensionOutput,
                crate::error::StartSchemaExtensionError,
                crate::input::StartSchemaExtensionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory for which the schema extension will be applied to.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory for which the schema extension will be applied to.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>If true, creates a snapshot of the directory before applying the schema extension.</p>
        pub fn create_snapshot_before_schema_extension(mut self, input: bool) -> Self {
            self.inner = self.inner.create_snapshot_before_schema_extension(input);
            self
        }
        /// <p>If true, creates a snapshot of the directory before applying the schema extension.</p>
        pub fn set_create_snapshot_before_schema_extension(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self
                .inner
                .set_create_snapshot_before_schema_extension(input);
            self
        }
        /// <p>The LDIF file represented as a string. To construct the LdifContent string, precede each line as it would be formatted in an ldif file with \n. See the example request below for more details. The file size can be no larger than 1MB.</p>
        pub fn ldif_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ldif_content(input.into());
            self
        }
        /// <p>The LDIF file represented as a string. To construct the LdifContent string, precede each line as it would be formatted in an ldif file with \n. See the example request below for more details. The file size can be no larger than 1MB.</p>
        pub fn set_ldif_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ldif_content(input);
            self
        }
        /// <p>A description of the schema extension.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the schema extension.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UnshareDirectory`.
    ///
    /// <p>Stops the directory sharing between the directory owner and consumer accounts. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UnshareDirectory<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::unshare_directory_input::Builder,
    }
    impl<C, M, R> UnshareDirectory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UnshareDirectory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UnshareDirectoryOutput,
            aws_smithy_http::result::SdkError<crate::error::UnshareDirectoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UnshareDirectoryInputOperationOutputAlias,
                crate::output::UnshareDirectoryOutput,
                crate::error::UnshareDirectoryError,
                crate::input::UnshareDirectoryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Managed Microsoft AD directory that you want to stop sharing.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the Managed Microsoft AD directory that you want to stop sharing.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>Identifier for the directory consumer account with whom the directory has to be unshared.</p>
        pub fn unshare_target(mut self, input: crate::model::UnshareTarget) -> Self {
            self.inner = self.inner.unshare_target(input);
            self
        }
        /// <p>Identifier for the directory consumer account with whom the directory has to be unshared.</p>
        pub fn set_unshare_target(
            mut self,
            input: std::option::Option<crate::model::UnshareTarget>,
        ) -> Self {
            self.inner = self.inner.set_unshare_target(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConditionalForwarder`.
    ///
    /// <p>Updates a conditional forwarder that has been set up for your Amazon Web Services directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateConditionalForwarder<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_conditional_forwarder_input::Builder,
    }
    impl<C, M, R> UpdateConditionalForwarder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateConditionalForwarder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConditionalForwarderOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateConditionalForwarderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateConditionalForwarderInputOperationOutputAlias,
                crate::output::UpdateConditionalForwarderOutput,
                crate::error::UpdateConditionalForwarderError,
                crate::input::UpdateConditionalForwarderInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The directory ID of the Amazon Web Services directory for which to update the conditional forwarder.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The directory ID of the Amazon Web Services directory for which to update the conditional forwarder.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The fully qualified domain name (FQDN) of the remote domain with which you will set up a trust relationship.</p>
        pub fn remote_domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.remote_domain_name(input.into());
            self
        }
        /// <p>The fully qualified domain name (FQDN) of the remote domain with which you will set up a trust relationship.</p>
        pub fn set_remote_domain_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_remote_domain_name(input);
            self
        }
        /// Appends an item to `DnsIpAddrs`.
        ///
        /// To override the contents of this collection use [`set_dns_ip_addrs`](Self::set_dns_ip_addrs).
        ///
        /// <p>The updated IP addresses of the remote DNS server associated with the conditional forwarder.</p>
        pub fn dns_ip_addrs(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dns_ip_addrs(input.into());
            self
        }
        /// <p>The updated IP addresses of the remote DNS server associated with the conditional forwarder.</p>
        pub fn set_dns_ip_addrs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_dns_ip_addrs(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateNumberOfDomainControllers`.
    ///
    /// <p>Adds or removes domain controllers to or from the directory. Based on the difference between current value and new value (provided through this API call), domain controllers will be added or removed. It may take up to 45 minutes for any new domain controllers to become fully active once the requested number of domain controllers is updated. During this time, you cannot make another update request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateNumberOfDomainControllers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_number_of_domain_controllers_input::Builder,
    }
    impl<C, M, R> UpdateNumberOfDomainControllers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateNumberOfDomainControllers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateNumberOfDomainControllersOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateNumberOfDomainControllersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateNumberOfDomainControllersInputOperationOutputAlias,
                crate::output::UpdateNumberOfDomainControllersOutput,
                crate::error::UpdateNumberOfDomainControllersError,
                crate::input::UpdateNumberOfDomainControllersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier of the directory to which the domain controllers will be added or removed.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>Identifier of the directory to which the domain controllers will be added or removed.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The number of domain controllers desired in the directory.</p>
        pub fn desired_number(mut self, input: i32) -> Self {
            self.inner = self.inner.desired_number(input);
            self
        }
        /// <p>The number of domain controllers desired in the directory.</p>
        pub fn set_desired_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_desired_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRadius`.
    ///
    /// <p>Updates the Remote Authentication Dial In User Service (RADIUS) server information for an AD Connector or Microsoft AD directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRadius<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_radius_input::Builder,
    }
    impl<C, M, R> UpdateRadius<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRadius`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRadiusOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRadiusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRadiusInputOperationOutputAlias,
                crate::output::UpdateRadiusOutput,
                crate::error::UpdateRadiusError,
                crate::input::UpdateRadiusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory for which to update the RADIUS server information.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory for which to update the RADIUS server information.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>A <code>RadiusSettings</code> object that contains information about the RADIUS server.</p>
        pub fn radius_settings(mut self, input: crate::model::RadiusSettings) -> Self {
            self.inner = self.inner.radius_settings(input);
            self
        }
        /// <p>A <code>RadiusSettings</code> object that contains information about the RADIUS server.</p>
        pub fn set_radius_settings(
            mut self,
            input: std::option::Option<crate::model::RadiusSettings>,
        ) -> Self {
            self.inner = self.inner.set_radius_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTrust`.
    ///
    /// <p>Updates the trust that has been set up between your Managed Microsoft AD directory and an self-managed Active Directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateTrust<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_trust_input::Builder,
    }
    impl<C, M, R> UpdateTrust<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTrust`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTrustOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTrustError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTrustInputOperationOutputAlias,
                crate::output::UpdateTrustOutput,
                crate::error::UpdateTrustError,
                crate::input::UpdateTrustInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier of the trust relationship.</p>
        pub fn trust_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trust_id(input.into());
            self
        }
        /// <p>Identifier of the trust relationship.</p>
        pub fn set_trust_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_trust_id(input);
            self
        }
        /// <p>Updates selective authentication for the trust.</p>
        pub fn selective_auth(mut self, input: crate::model::SelectiveAuth) -> Self {
            self.inner = self.inner.selective_auth(input);
            self
        }
        /// <p>Updates selective authentication for the trust.</p>
        pub fn set_selective_auth(
            mut self,
            input: std::option::Option<crate::model::SelectiveAuth>,
        ) -> Self {
            self.inner = self.inner.set_selective_auth(input);
            self
        }
    }
    /// Fluent builder constructing a request to `VerifyTrust`.
    ///
    /// <p>Directory Service for Microsoft Active Directory allows you to configure and verify trust relationships.</p>
    /// <p>This action verifies a trust relationship between your Managed Microsoft AD directory and an external domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct VerifyTrust<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::verify_trust_input::Builder,
    }
    impl<C, M, R> VerifyTrust<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `VerifyTrust`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::VerifyTrustOutput,
            aws_smithy_http::result::SdkError<crate::error::VerifyTrustError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::VerifyTrustInputOperationOutputAlias,
                crate::output::VerifyTrustOutput,
                crate::error::VerifyTrustError,
                crate::input::VerifyTrustInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique Trust ID of the trust relationship to verify.</p>
        pub fn trust_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trust_id(input.into());
            self
        }
        /// <p>The unique Trust ID of the trust relationship to verify.</p>
        pub fn set_trust_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_trust_id(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
