// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_accept_shared_directory_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AcceptSharedDirectoryOutput,
    crate::error::AcceptSharedDirectoryError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AcceptSharedDirectoryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AcceptSharedDirectoryError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::AcceptSharedDirectoryError {
                meta: generic,
                kind: crate::error::AcceptSharedDirectoryErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AcceptSharedDirectoryError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DirectoryAlreadySharedException" => crate::error::AcceptSharedDirectoryError {
            meta: generic,
            kind: crate::error::AcceptSharedDirectoryErrorKind::DirectoryAlreadySharedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::directory_already_shared_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_directory_already_shared_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AcceptSharedDirectoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EntityDoesNotExistException" => crate::error::AcceptSharedDirectoryError {
            meta: generic,
            kind: crate::error::AcceptSharedDirectoryErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AcceptSharedDirectoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::AcceptSharedDirectoryError {
            meta: generic,
            kind: crate::error::AcceptSharedDirectoryErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AcceptSharedDirectoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::AcceptSharedDirectoryError {
                meta: generic,
                kind: crate::error::AcceptSharedDirectoryErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AcceptSharedDirectoryError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::AcceptSharedDirectoryError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_accept_shared_directory_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AcceptSharedDirectoryOutput,
    crate::error::AcceptSharedDirectoryError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::accept_shared_directory_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_accept_shared_directory(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AcceptSharedDirectoryError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_ip_routes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddIpRoutesOutput, crate::error::AddIpRoutesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddIpRoutesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AddIpRoutesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::AddIpRoutesError {
                meta: generic,
                kind: crate::error::AddIpRoutesErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddIpRoutesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DirectoryUnavailableException" => crate::error::AddIpRoutesError {
            meta: generic,
            kind: crate::error::AddIpRoutesErrorKind::DirectoryUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::directory_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_directory_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddIpRoutesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EntityAlreadyExistsException" => crate::error::AddIpRoutesError {
            meta: generic,
            kind: crate::error::AddIpRoutesErrorKind::EntityAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddIpRoutesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EntityDoesNotExistException" => crate::error::AddIpRoutesError {
            meta: generic,
            kind: crate::error::AddIpRoutesErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddIpRoutesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::AddIpRoutesError {
            meta: generic,
            kind: crate::error::AddIpRoutesErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddIpRoutesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IpRouteLimitExceededException" => crate::error::AddIpRoutesError {
            meta: generic,
            kind: crate::error::AddIpRoutesErrorKind::IpRouteLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::ip_route_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_ip_route_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddIpRoutesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::AddIpRoutesError {
                meta: generic,
                kind: crate::error::AddIpRoutesErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddIpRoutesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::AddIpRoutesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_ip_routes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddIpRoutesOutput, crate::error::AddIpRoutesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::add_ip_routes_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_region_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddRegionOutput, crate::error::AddRegionError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddRegionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AddRegionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::AddRegionError {
            meta: generic,
            kind: crate::error::AddRegionErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddRegionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClientException" => {
            crate::error::AddRegionError {
                meta: generic,
                kind: crate::error::AddRegionErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddRegionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DirectoryAlreadyInRegionException" => crate::error::AddRegionError {
            meta: generic,
            kind: crate::error::AddRegionErrorKind::DirectoryAlreadyInRegionException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::directory_already_in_region_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_directory_already_in_region_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddRegionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DirectoryDoesNotExistException" => crate::error::AddRegionError {
            meta: generic,
            kind: crate::error::AddRegionErrorKind::DirectoryDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::directory_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_directory_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddRegionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DirectoryUnavailableException" => crate::error::AddRegionError {
            meta: generic,
            kind: crate::error::AddRegionErrorKind::DirectoryUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::directory_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_directory_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddRegionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EntityDoesNotExistException" => crate::error::AddRegionError {
            meta: generic,
            kind: crate::error::AddRegionErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddRegionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::AddRegionError {
            meta: generic,
            kind: crate::error::AddRegionErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddRegionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RegionLimitExceededException" => crate::error::AddRegionError {
            meta: generic,
            kind: crate::error::AddRegionErrorKind::RegionLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::region_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_region_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddRegionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::AddRegionError {
                meta: generic,
                kind: crate::error::AddRegionErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddRegionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperationException" => crate::error::AddRegionError {
            meta: generic,
            kind: crate::error::AddRegionErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddRegionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AddRegionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_region_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddRegionOutput, crate::error::AddRegionError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::add_region_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_tags_to_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddTagsToResourceOutput, crate::error::AddTagsToResourceError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddTagsToResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AddTagsToResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::AddTagsToResourceError {
                meta: generic,
                kind: crate::error::AddTagsToResourceErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsToResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityDoesNotExistException" => crate::error::AddTagsToResourceError {
            meta: generic,
            kind: crate::error::AddTagsToResourceErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsToResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::AddTagsToResourceError {
            meta: generic,
            kind: crate::error::AddTagsToResourceErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsToResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::AddTagsToResourceError {
                meta: generic,
                kind: crate::error::AddTagsToResourceErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsToResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TagLimitExceededException" => crate::error::AddTagsToResourceError {
            meta: generic,
            kind: crate::error::AddTagsToResourceErrorKind::TagLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::tag_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_tag_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsToResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AddTagsToResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_tags_to_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddTagsToResourceOutput, crate::error::AddTagsToResourceError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::add_tags_to_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_schema_extension_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CancelSchemaExtensionOutput,
    crate::error::CancelSchemaExtensionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CancelSchemaExtensionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CancelSchemaExtensionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::CancelSchemaExtensionError {
                meta: generic,
                kind: crate::error::CancelSchemaExtensionErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelSchemaExtensionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityDoesNotExistException" => crate::error::CancelSchemaExtensionError {
            meta: generic,
            kind: crate::error::CancelSchemaExtensionErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelSchemaExtensionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CancelSchemaExtensionError {
                meta: generic,
                kind: crate::error::CancelSchemaExtensionErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelSchemaExtensionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::CancelSchemaExtensionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_schema_extension_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CancelSchemaExtensionOutput,
    crate::error::CancelSchemaExtensionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::cancel_schema_extension_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_connect_directory_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ConnectDirectoryOutput, crate::error::ConnectDirectoryError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ConnectDirectoryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ConnectDirectoryError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::ConnectDirectoryError {
                meta: generic,
                kind: crate::error::ConnectDirectoryErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConnectDirectoryError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DirectoryLimitExceededException" => crate::error::ConnectDirectoryError {
            meta: generic,
            kind: crate::error::ConnectDirectoryErrorKind::DirectoryLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::directory_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_directory_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConnectDirectoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ConnectDirectoryError {
            meta: generic,
            kind: crate::error::ConnectDirectoryErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConnectDirectoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::ConnectDirectoryError {
                meta: generic,
                kind: crate::error::ConnectDirectoryErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConnectDirectoryError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ConnectDirectoryError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_connect_directory_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ConnectDirectoryOutput, crate::error::ConnectDirectoryError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::connect_directory_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_connect_directory(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ConnectDirectoryError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_alias_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateAliasOutput, crate::error::CreateAliasError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateAliasError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateAliasError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::CreateAliasError {
                meta: generic,
                kind: crate::error::CreateAliasErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAliasError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityAlreadyExistsException" => crate::error::CreateAliasError {
            meta: generic,
            kind: crate::error::CreateAliasErrorKind::EntityAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EntityDoesNotExistException" => crate::error::CreateAliasError {
            meta: generic,
            kind: crate::error::CreateAliasErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::CreateAliasError {
            meta: generic,
            kind: crate::error::CreateAliasErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateAliasError {
                meta: generic,
                kind: crate::error::CreateAliasErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAliasError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::CreateAliasError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_alias_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateAliasOutput, crate::error::CreateAliasError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_alias_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_alias(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateAliasError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_computer_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateComputerOutput, crate::error::CreateComputerError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateComputerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateComputerError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthenticationFailedException" => crate::error::CreateComputerError {
            meta: generic,
            kind: crate::error::CreateComputerErrorKind::AuthenticationFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authentication_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_authentication_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateComputerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClientException" => {
            crate::error::CreateComputerError {
                meta: generic,
                kind: crate::error::CreateComputerErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateComputerError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DirectoryUnavailableException" => crate::error::CreateComputerError {
            meta: generic,
            kind: crate::error::CreateComputerErrorKind::DirectoryUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::directory_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_directory_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateComputerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EntityAlreadyExistsException" => crate::error::CreateComputerError {
            meta: generic,
            kind: crate::error::CreateComputerErrorKind::EntityAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateComputerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EntityDoesNotExistException" => crate::error::CreateComputerError {
            meta: generic,
            kind: crate::error::CreateComputerErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateComputerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::CreateComputerError {
            meta: generic,
            kind: crate::error::CreateComputerErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateComputerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateComputerError {
                meta: generic,
                kind: crate::error::CreateComputerErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateComputerError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperationException" => crate::error::CreateComputerError {
            meta: generic,
            kind: crate::error::CreateComputerErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateComputerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateComputerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_computer_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateComputerOutput, crate::error::CreateComputerError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_computer_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_computer(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateComputerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_conditional_forwarder_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateConditionalForwarderOutput,
    crate::error::CreateConditionalForwarderError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateConditionalForwarderError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateConditionalForwarderError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::CreateConditionalForwarderError {
                meta: generic,
                kind: crate::error::CreateConditionalForwarderErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateConditionalForwarderError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DirectoryUnavailableException" => crate::error::CreateConditionalForwarderError {
            meta: generic,
            kind: crate::error::CreateConditionalForwarderErrorKind::DirectoryUnavailableException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::directory_unavailable_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_directory_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateConditionalForwarderError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "EntityAlreadyExistsException" => crate::error::CreateConditionalForwarderError {
            meta: generic,
            kind: crate::error::CreateConditionalForwarderErrorKind::EntityAlreadyExistsException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::entity_already_exists_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_entity_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateConditionalForwarderError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "EntityDoesNotExistException" => crate::error::CreateConditionalForwarderError {
            meta: generic,
            kind: crate::error::CreateConditionalForwarderErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateConditionalForwarderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::CreateConditionalForwarderError {
            meta: generic,
            kind: crate::error::CreateConditionalForwarderErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateConditionalForwarderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateConditionalForwarderError {
                meta: generic,
                kind: crate::error::CreateConditionalForwarderErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateConditionalForwarderError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperationException" => crate::error::CreateConditionalForwarderError {
            meta: generic,
            kind: crate::error::CreateConditionalForwarderErrorKind::UnsupportedOperationException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::unsupported_operation_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateConditionalForwarderError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::CreateConditionalForwarderError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_conditional_forwarder_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateConditionalForwarderOutput,
    crate::error::CreateConditionalForwarderError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_conditional_forwarder_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_directory_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateDirectoryOutput, crate::error::CreateDirectoryError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDirectoryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateDirectoryError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::CreateDirectoryError {
                meta: generic,
                kind: crate::error::CreateDirectoryErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDirectoryError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DirectoryLimitExceededException" => crate::error::CreateDirectoryError {
            meta: generic,
            kind: crate::error::CreateDirectoryErrorKind::DirectoryLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::directory_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_directory_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDirectoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::CreateDirectoryError {
            meta: generic,
            kind: crate::error::CreateDirectoryErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDirectoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateDirectoryError {
                meta: generic,
                kind: crate::error::CreateDirectoryErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDirectoryError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::CreateDirectoryError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_directory_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateDirectoryOutput, crate::error::CreateDirectoryError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_directory_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_directory(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateDirectoryError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_log_subscription_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateLogSubscriptionOutput,
    crate::error::CreateLogSubscriptionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateLogSubscriptionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateLogSubscriptionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::CreateLogSubscriptionError {
                meta: generic,
                kind: crate::error::CreateLogSubscriptionErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLogSubscriptionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityAlreadyExistsException" => crate::error::CreateLogSubscriptionError {
            meta: generic,
            kind: crate::error::CreateLogSubscriptionErrorKind::EntityAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLogSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EntityDoesNotExistException" => crate::error::CreateLogSubscriptionError {
            meta: generic,
            kind: crate::error::CreateLogSubscriptionErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLogSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InsufficientPermissionsException" => crate::error::CreateLogSubscriptionError {
            meta: generic,
            kind: crate::error::CreateLogSubscriptionErrorKind::InsufficientPermissionsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::insufficient_permissions_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_insufficient_permissions_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLogSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateLogSubscriptionError {
                meta: generic,
                kind: crate::error::CreateLogSubscriptionErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLogSubscriptionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperationException" => crate::error::CreateLogSubscriptionError {
            meta: generic,
            kind: crate::error::CreateLogSubscriptionErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLogSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateLogSubscriptionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_log_subscription_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateLogSubscriptionOutput,
    crate::error::CreateLogSubscriptionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_log_subscription_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_microsoft_ad_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateMicrosoftAdOutput, crate::error::CreateMicrosoftADError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateMicrosoftADError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateMicrosoftADError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::CreateMicrosoftADError {
                meta: generic,
                kind: crate::error::CreateMicrosoftADErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateMicrosoftADError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DirectoryLimitExceededException" => crate::error::CreateMicrosoftADError {
            meta: generic,
            kind: crate::error::CreateMicrosoftADErrorKind::DirectoryLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::directory_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_directory_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateMicrosoftADError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::CreateMicrosoftADError {
            meta: generic,
            kind: crate::error::CreateMicrosoftADErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateMicrosoftADError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateMicrosoftADError {
                meta: generic,
                kind: crate::error::CreateMicrosoftADErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateMicrosoftADError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperationException" => crate::error::CreateMicrosoftADError {
            meta: generic,
            kind: crate::error::CreateMicrosoftADErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateMicrosoftADError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateMicrosoftADError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_microsoft_ad_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateMicrosoftAdOutput, crate::error::CreateMicrosoftADError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_microsoft_ad_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_microsoft_ad(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateMicrosoftADError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateSnapshotOutput, crate::error::CreateSnapshotError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateSnapshotError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::CreateSnapshotError {
                meta: generic,
                kind: crate::error::CreateSnapshotErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityDoesNotExistException" => crate::error::CreateSnapshotError {
            meta: generic,
            kind: crate::error::CreateSnapshotErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::CreateSnapshotError {
            meta: generic,
            kind: crate::error::CreateSnapshotErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateSnapshotError {
                meta: generic,
                kind: crate::error::CreateSnapshotErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "SnapshotLimitExceededException" => crate::error::CreateSnapshotError {
            meta: generic,
            kind: crate::error::CreateSnapshotErrorKind::SnapshotLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::snapshot_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_snapshot_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateSnapshotError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateSnapshotOutput, crate::error::CreateSnapshotError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_snapshot_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_snapshot(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_trust_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTrustOutput, crate::error::CreateTrustError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateTrustError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateTrustError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::CreateTrustError {
                meta: generic,
                kind: crate::error::CreateTrustErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrustError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityAlreadyExistsException" => crate::error::CreateTrustError {
            meta: generic,
            kind: crate::error::CreateTrustErrorKind::EntityAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrustError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EntityDoesNotExistException" => crate::error::CreateTrustError {
            meta: generic,
            kind: crate::error::CreateTrustErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrustError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::CreateTrustError {
            meta: generic,
            kind: crate::error::CreateTrustErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrustError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateTrustError {
                meta: generic,
                kind: crate::error::CreateTrustErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrustError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperationException" => crate::error::CreateTrustError {
            meta: generic,
            kind: crate::error::CreateTrustErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrustError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateTrustError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_trust_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTrustOutput, crate::error::CreateTrustError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_trust_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_trust(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateTrustError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_conditional_forwarder_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteConditionalForwarderOutput,
    crate::error::DeleteConditionalForwarderError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteConditionalForwarderError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteConditionalForwarderError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DeleteConditionalForwarderError {
                meta: generic,
                kind: crate::error::DeleteConditionalForwarderErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteConditionalForwarderError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DirectoryUnavailableException" => crate::error::DeleteConditionalForwarderError {
            meta: generic,
            kind: crate::error::DeleteConditionalForwarderErrorKind::DirectoryUnavailableException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::directory_unavailable_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_directory_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteConditionalForwarderError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "EntityDoesNotExistException" => crate::error::DeleteConditionalForwarderError {
            meta: generic,
            kind: crate::error::DeleteConditionalForwarderErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteConditionalForwarderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DeleteConditionalForwarderError {
            meta: generic,
            kind: crate::error::DeleteConditionalForwarderErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteConditionalForwarderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeleteConditionalForwarderError {
                meta: generic,
                kind: crate::error::DeleteConditionalForwarderErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteConditionalForwarderError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperationException" => crate::error::DeleteConditionalForwarderError {
            meta: generic,
            kind: crate::error::DeleteConditionalForwarderErrorKind::UnsupportedOperationException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::unsupported_operation_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteConditionalForwarderError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DeleteConditionalForwarderError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_conditional_forwarder_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteConditionalForwarderOutput,
    crate::error::DeleteConditionalForwarderError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_conditional_forwarder_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_directory_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDirectoryOutput, crate::error::DeleteDirectoryError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteDirectoryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteDirectoryError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DeleteDirectoryError {
                meta: generic,
                kind: crate::error::DeleteDirectoryErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDirectoryError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityDoesNotExistException" => crate::error::DeleteDirectoryError {
            meta: generic,
            kind: crate::error::DeleteDirectoryErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDirectoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeleteDirectoryError {
                meta: generic,
                kind: crate::error::DeleteDirectoryErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDirectoryError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteDirectoryError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_directory_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDirectoryOutput, crate::error::DeleteDirectoryError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_directory_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_directory(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteDirectoryError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_log_subscription_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteLogSubscriptionOutput,
    crate::error::DeleteLogSubscriptionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteLogSubscriptionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteLogSubscriptionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DeleteLogSubscriptionError {
                meta: generic,
                kind: crate::error::DeleteLogSubscriptionErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLogSubscriptionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityDoesNotExistException" => crate::error::DeleteLogSubscriptionError {
            meta: generic,
            kind: crate::error::DeleteLogSubscriptionErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLogSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeleteLogSubscriptionError {
                meta: generic,
                kind: crate::error::DeleteLogSubscriptionErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLogSubscriptionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperationException" => crate::error::DeleteLogSubscriptionError {
            meta: generic,
            kind: crate::error::DeleteLogSubscriptionErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLogSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteLogSubscriptionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_log_subscription_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteLogSubscriptionOutput,
    crate::error::DeleteLogSubscriptionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_log_subscription_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteSnapshotOutput, crate::error::DeleteSnapshotError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteSnapshotError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DeleteSnapshotError {
                meta: generic,
                kind: crate::error::DeleteSnapshotErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSnapshotError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityDoesNotExistException" => crate::error::DeleteSnapshotError {
            meta: generic,
            kind: crate::error::DeleteSnapshotErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DeleteSnapshotError {
            meta: generic,
            kind: crate::error::DeleteSnapshotErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeleteSnapshotError {
                meta: generic,
                kind: crate::error::DeleteSnapshotErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSnapshotError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteSnapshotError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteSnapshotOutput, crate::error::DeleteSnapshotError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_snapshot_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_snapshot(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_trust_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTrustOutput, crate::error::DeleteTrustError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteTrustError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteTrustError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DeleteTrustError {
                meta: generic,
                kind: crate::error::DeleteTrustErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTrustError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityDoesNotExistException" => crate::error::DeleteTrustError {
            meta: generic,
            kind: crate::error::DeleteTrustErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTrustError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DeleteTrustError {
            meta: generic,
            kind: crate::error::DeleteTrustErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTrustError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeleteTrustError {
                meta: generic,
                kind: crate::error::DeleteTrustErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTrustError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperationException" => crate::error::DeleteTrustError {
            meta: generic,
            kind: crate::error::DeleteTrustErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTrustError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteTrustError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_trust_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTrustOutput, crate::error::DeleteTrustError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_trust_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_trust(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteTrustError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deregister_certificate_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeregisterCertificateOutput,
    crate::error::DeregisterCertificateError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeregisterCertificateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeregisterCertificateError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CertificateDoesNotExistException" => crate::error::DeregisterCertificateError {
            meta: generic,
            kind: crate::error::DeregisterCertificateErrorKind::CertificateDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::certificate_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_certificate_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CertificateInUseException" => crate::error::DeregisterCertificateError {
            meta: generic,
            kind: crate::error::DeregisterCertificateErrorKind::CertificateInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::certificate_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_certificate_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClientException" => {
            crate::error::DeregisterCertificateError {
                meta: generic,
                kind: crate::error::DeregisterCertificateErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterCertificateError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DirectoryDoesNotExistException" => crate::error::DeregisterCertificateError {
            meta: generic,
            kind: crate::error::DeregisterCertificateErrorKind::DirectoryDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::directory_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_directory_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DirectoryUnavailableException" => crate::error::DeregisterCertificateError {
            meta: generic,
            kind: crate::error::DeregisterCertificateErrorKind::DirectoryUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::directory_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_directory_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DeregisterCertificateError {
            meta: generic,
            kind: crate::error::DeregisterCertificateErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeregisterCertificateError {
                meta: generic,
                kind: crate::error::DeregisterCertificateErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterCertificateError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperationException" => crate::error::DeregisterCertificateError {
            meta: generic,
            kind: crate::error::DeregisterCertificateErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeregisterCertificateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deregister_certificate_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeregisterCertificateOutput,
    crate::error::DeregisterCertificateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::deregister_certificate_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deregister_event_topic_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeregisterEventTopicOutput,
    crate::error::DeregisterEventTopicError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeregisterEventTopicError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeregisterEventTopicError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DeregisterEventTopicError {
                meta: generic,
                kind: crate::error::DeregisterEventTopicErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterEventTopicError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityDoesNotExistException" => crate::error::DeregisterEventTopicError {
            meta: generic,
            kind: crate::error::DeregisterEventTopicErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterEventTopicError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DeregisterEventTopicError {
            meta: generic,
            kind: crate::error::DeregisterEventTopicErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterEventTopicError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeregisterEventTopicError {
                meta: generic,
                kind: crate::error::DeregisterEventTopicErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterEventTopicError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeregisterEventTopicError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deregister_event_topic_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeregisterEventTopicOutput,
    crate::error::DeregisterEventTopicError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::deregister_event_topic_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_certificate_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCertificateOutput,
    crate::error::DescribeCertificateError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeCertificateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeCertificateError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CertificateDoesNotExistException" => crate::error::DescribeCertificateError {
            meta: generic,
            kind: crate::error::DescribeCertificateErrorKind::CertificateDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::certificate_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_certificate_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClientException" => {
            crate::error::DescribeCertificateError {
                meta: generic,
                kind: crate::error::DescribeCertificateErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCertificateError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DirectoryDoesNotExistException" => crate::error::DescribeCertificateError {
            meta: generic,
            kind: crate::error::DescribeCertificateErrorKind::DirectoryDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::directory_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_directory_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeCertificateError {
            meta: generic,
            kind: crate::error::DescribeCertificateErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DescribeCertificateError {
                meta: generic,
                kind: crate::error::DescribeCertificateErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCertificateError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperationException" => crate::error::DescribeCertificateError {
            meta: generic,
            kind: crate::error::DescribeCertificateErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeCertificateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_certificate_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCertificateOutput,
    crate::error::DescribeCertificateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_certificate_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_certificate(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeCertificateError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_client_authentication_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeClientAuthenticationSettingsOutput,
    crate::error::DescribeClientAuthenticationSettingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeClientAuthenticationSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeClientAuthenticationSettingsError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DescribeClientAuthenticationSettingsError { meta: generic, kind: crate::error::DescribeClientAuthenticationSettingsErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeClientAuthenticationSettingsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ClientException" => crate::error::DescribeClientAuthenticationSettingsError { meta: generic, kind: crate::error::DescribeClientAuthenticationSettingsErrorKind::ClientException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeClientAuthenticationSettingsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DirectoryDoesNotExistException" => crate::error::DescribeClientAuthenticationSettingsError { meta: generic, kind: crate::error::DescribeClientAuthenticationSettingsErrorKind::DirectoryDoesNotExistException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::directory_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_directory_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeClientAuthenticationSettingsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterException" => crate::error::DescribeClientAuthenticationSettingsError { meta: generic, kind: crate::error::DescribeClientAuthenticationSettingsErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeClientAuthenticationSettingsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::DescribeClientAuthenticationSettingsError { meta: generic, kind: crate::error::DescribeClientAuthenticationSettingsErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeClientAuthenticationSettingsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedOperationException" => crate::error::DescribeClientAuthenticationSettingsError { meta: generic, kind: crate::error::DescribeClientAuthenticationSettingsErrorKind::UnsupportedOperationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeClientAuthenticationSettingsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeClientAuthenticationSettingsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_client_authentication_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeClientAuthenticationSettingsOutput,
    crate::error::DescribeClientAuthenticationSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_client_authentication_settings_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_client_authentication_settings(response.body().as_ref(), output).map_err(crate::error::DescribeClientAuthenticationSettingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_conditional_forwarders_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeConditionalForwardersOutput,
    crate::error::DescribeConditionalForwardersError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeConditionalForwardersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeConditionalForwardersError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DescribeConditionalForwardersError {
                meta: generic,
                kind: crate::error::DescribeConditionalForwardersErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeConditionalForwardersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DirectoryUnavailableException" => crate::error::DescribeConditionalForwardersError {
            meta: generic,
            kind:
                crate::error::DescribeConditionalForwardersErrorKind::DirectoryUnavailableException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::directory_unavailable_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_directory_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeConditionalForwardersError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "EntityDoesNotExistException" => crate::error::DescribeConditionalForwardersError {
            meta: generic,
            kind: crate::error::DescribeConditionalForwardersErrorKind::EntityDoesNotExistException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::entity_does_not_exist_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeConditionalForwardersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidParameterException" => crate::error::DescribeConditionalForwardersError {
            meta: generic,
            kind: crate::error::DescribeConditionalForwardersErrorKind::InvalidParameterException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_parameter_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeConditionalForwardersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ServiceException" => {
            crate::error::DescribeConditionalForwardersError {
                meta: generic,
                kind: crate::error::DescribeConditionalForwardersErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeConditionalForwardersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperationException" => crate::error::DescribeConditionalForwardersError {
            meta: generic,
            kind:
                crate::error::DescribeConditionalForwardersErrorKind::UnsupportedOperationException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::unsupported_operation_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeConditionalForwardersError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::DescribeConditionalForwardersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_conditional_forwarders_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeConditionalForwardersOutput,
    crate::error::DescribeConditionalForwardersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_conditional_forwarders_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_describe_conditional_forwarders(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeConditionalForwardersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_directories_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDirectoriesOutput,
    crate::error::DescribeDirectoriesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDirectoriesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeDirectoriesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DescribeDirectoriesError {
                meta: generic,
                kind: crate::error::DescribeDirectoriesErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDirectoriesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityDoesNotExistException" => crate::error::DescribeDirectoriesError {
            meta: generic,
            kind: crate::error::DescribeDirectoriesErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDirectoriesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::DescribeDirectoriesError {
            meta: generic,
            kind: crate::error::DescribeDirectoriesErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDirectoriesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeDirectoriesError {
            meta: generic,
            kind: crate::error::DescribeDirectoriesErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDirectoriesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DescribeDirectoriesError {
                meta: generic,
                kind: crate::error::DescribeDirectoriesErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDirectoriesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeDirectoriesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_directories_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDirectoriesOutput,
    crate::error::DescribeDirectoriesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_directories_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_directories(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeDirectoriesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_domain_controllers_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDomainControllersOutput,
    crate::error::DescribeDomainControllersError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDomainControllersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeDomainControllersError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DescribeDomainControllersError {
                meta: generic,
                kind: crate::error::DescribeDomainControllersErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDomainControllersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityDoesNotExistException" => crate::error::DescribeDomainControllersError {
            meta: generic,
            kind: crate::error::DescribeDomainControllersErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDomainControllersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::DescribeDomainControllersError {
            meta: generic,
            kind: crate::error::DescribeDomainControllersErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDomainControllersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeDomainControllersError {
            meta: generic,
            kind: crate::error::DescribeDomainControllersErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDomainControllersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DescribeDomainControllersError {
                meta: generic,
                kind: crate::error::DescribeDomainControllersErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDomainControllersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperationException" => crate::error::DescribeDomainControllersError {
            meta: generic,
            kind: crate::error::DescribeDomainControllersErrorKind::UnsupportedOperationException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::unsupported_operation_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDomainControllersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribeDomainControllersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_domain_controllers_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDomainControllersOutput,
    crate::error::DescribeDomainControllersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_domain_controllers_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_domain_controllers(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeDomainControllersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_event_topics_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEventTopicsOutput,
    crate::error::DescribeEventTopicsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEventTopicsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeEventTopicsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DescribeEventTopicsError {
                meta: generic,
                kind: crate::error::DescribeEventTopicsErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEventTopicsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityDoesNotExistException" => crate::error::DescribeEventTopicsError {
            meta: generic,
            kind: crate::error::DescribeEventTopicsErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEventTopicsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeEventTopicsError {
            meta: generic,
            kind: crate::error::DescribeEventTopicsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEventTopicsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DescribeEventTopicsError {
                meta: generic,
                kind: crate::error::DescribeEventTopicsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEventTopicsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeEventTopicsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_event_topics_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEventTopicsOutput,
    crate::error::DescribeEventTopicsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_event_topics_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_event_topics(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeEventTopicsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_ldaps_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLdapsSettingsOutput,
    crate::error::DescribeLDAPSSettingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeLDAPSSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeLDAPSSettingsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DescribeLDAPSSettingsError {
                meta: generic,
                kind: crate::error::DescribeLDAPSSettingsErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeLDAPSSettingsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DirectoryDoesNotExistException" => crate::error::DescribeLDAPSSettingsError {
            meta: generic,
            kind: crate::error::DescribeLDAPSSettingsErrorKind::DirectoryDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::directory_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_directory_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeLDAPSSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::DescribeLDAPSSettingsError {
            meta: generic,
            kind: crate::error::DescribeLDAPSSettingsErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeLDAPSSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeLDAPSSettingsError {
            meta: generic,
            kind: crate::error::DescribeLDAPSSettingsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeLDAPSSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DescribeLDAPSSettingsError {
                meta: generic,
                kind: crate::error::DescribeLDAPSSettingsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeLDAPSSettingsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperationException" => crate::error::DescribeLDAPSSettingsError {
            meta: generic,
            kind: crate::error::DescribeLDAPSSettingsErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeLDAPSSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeLDAPSSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_ldaps_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLdapsSettingsOutput,
    crate::error::DescribeLDAPSSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_ldaps_settings_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_ldaps_settings(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeLDAPSSettingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_regions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeRegionsOutput, crate::error::DescribeRegionsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeRegionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeRegionsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DescribeRegionsError {
            meta: generic,
            kind: crate::error::DescribeRegionsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeRegionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClientException" => {
            crate::error::DescribeRegionsError {
                meta: generic,
                kind: crate::error::DescribeRegionsErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeRegionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DirectoryDoesNotExistException" => crate::error::DescribeRegionsError {
            meta: generic,
            kind: crate::error::DescribeRegionsErrorKind::DirectoryDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::directory_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_directory_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeRegionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::DescribeRegionsError {
            meta: generic,
            kind: crate::error::DescribeRegionsErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeRegionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeRegionsError {
            meta: generic,
            kind: crate::error::DescribeRegionsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeRegionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DescribeRegionsError {
                meta: generic,
                kind: crate::error::DescribeRegionsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeRegionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperationException" => crate::error::DescribeRegionsError {
            meta: generic,
            kind: crate::error::DescribeRegionsErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeRegionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeRegionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_regions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeRegionsOutput, crate::error::DescribeRegionsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_regions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_regions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeRegionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_shared_directories_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeSharedDirectoriesOutput,
    crate::error::DescribeSharedDirectoriesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeSharedDirectoriesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeSharedDirectoriesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DescribeSharedDirectoriesError {
                meta: generic,
                kind: crate::error::DescribeSharedDirectoriesErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeSharedDirectoriesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityDoesNotExistException" => crate::error::DescribeSharedDirectoriesError {
            meta: generic,
            kind: crate::error::DescribeSharedDirectoriesErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeSharedDirectoriesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::DescribeSharedDirectoriesError {
            meta: generic,
            kind: crate::error::DescribeSharedDirectoriesErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeSharedDirectoriesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeSharedDirectoriesError {
            meta: generic,
            kind: crate::error::DescribeSharedDirectoriesErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeSharedDirectoriesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DescribeSharedDirectoriesError {
                meta: generic,
                kind: crate::error::DescribeSharedDirectoriesErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeSharedDirectoriesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperationException" => crate::error::DescribeSharedDirectoriesError {
            meta: generic,
            kind: crate::error::DescribeSharedDirectoriesErrorKind::UnsupportedOperationException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::unsupported_operation_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeSharedDirectoriesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribeSharedDirectoriesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_shared_directories_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeSharedDirectoriesOutput,
    crate::error::DescribeSharedDirectoriesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_shared_directories_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_shared_directories(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeSharedDirectoriesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_snapshots_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeSnapshotsOutput, crate::error::DescribeSnapshotsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeSnapshotsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeSnapshotsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DescribeSnapshotsError {
                meta: generic,
                kind: crate::error::DescribeSnapshotsErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeSnapshotsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityDoesNotExistException" => crate::error::DescribeSnapshotsError {
            meta: generic,
            kind: crate::error::DescribeSnapshotsErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeSnapshotsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::DescribeSnapshotsError {
            meta: generic,
            kind: crate::error::DescribeSnapshotsErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeSnapshotsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeSnapshotsError {
            meta: generic,
            kind: crate::error::DescribeSnapshotsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeSnapshotsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DescribeSnapshotsError {
                meta: generic,
                kind: crate::error::DescribeSnapshotsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeSnapshotsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeSnapshotsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_snapshots_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeSnapshotsOutput, crate::error::DescribeSnapshotsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_snapshots_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_snapshots(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeSnapshotsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_trusts_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTrustsOutput, crate::error::DescribeTrustsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTrustsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeTrustsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DescribeTrustsError {
                meta: generic,
                kind: crate::error::DescribeTrustsErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTrustsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityDoesNotExistException" => crate::error::DescribeTrustsError {
            meta: generic,
            kind: crate::error::DescribeTrustsErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTrustsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::DescribeTrustsError {
            meta: generic,
            kind: crate::error::DescribeTrustsErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTrustsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeTrustsError {
            meta: generic,
            kind: crate::error::DescribeTrustsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTrustsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DescribeTrustsError {
                meta: generic,
                kind: crate::error::DescribeTrustsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTrustsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperationException" => crate::error::DescribeTrustsError {
            meta: generic,
            kind: crate::error::DescribeTrustsErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTrustsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeTrustsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_trusts_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTrustsOutput, crate::error::DescribeTrustsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_trusts_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_trusts(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeTrustsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_client_authentication_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisableClientAuthenticationOutput,
    crate::error::DisableClientAuthenticationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisableClientAuthenticationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DisableClientAuthenticationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DisableClientAuthenticationError {
            meta: generic,
            kind: crate::error::DisableClientAuthenticationErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableClientAuthenticationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClientException" => {
            crate::error::DisableClientAuthenticationError {
                meta: generic,
                kind: crate::error::DisableClientAuthenticationErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableClientAuthenticationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DirectoryDoesNotExistException" => crate::error::DisableClientAuthenticationError {
            meta: generic,
            kind:
                crate::error::DisableClientAuthenticationErrorKind::DirectoryDoesNotExistException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::directory_does_not_exist_exception::Builder::default(
                                );
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_directory_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableClientAuthenticationError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidClientAuthStatusException" => crate::error::DisableClientAuthenticationError {
            meta: generic,
            kind:
                crate::error::DisableClientAuthenticationErrorKind::InvalidClientAuthStatusException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::invalid_client_auth_status_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_client_auth_status_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableClientAuthenticationError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ServiceException" => {
            crate::error::DisableClientAuthenticationError {
                meta: generic,
                kind: crate::error::DisableClientAuthenticationErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableClientAuthenticationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperationException" => crate::error::DisableClientAuthenticationError {
            meta: generic,
            kind: crate::error::DisableClientAuthenticationErrorKind::UnsupportedOperationException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::unsupported_operation_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableClientAuthenticationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DisableClientAuthenticationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_client_authentication_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisableClientAuthenticationOutput,
    crate::error::DisableClientAuthenticationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disable_client_authentication_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_ldaps_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DisableLdapsOutput, crate::error::DisableLDAPSError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisableLDAPSError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DisableLDAPSError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DisableLDAPSError {
                meta: generic,
                kind: crate::error::DisableLDAPSErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableLDAPSError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DirectoryDoesNotExistException" => crate::error::DisableLDAPSError {
            meta: generic,
            kind: crate::error::DisableLDAPSErrorKind::DirectoryDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::directory_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_directory_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableLDAPSError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DirectoryUnavailableException" => crate::error::DisableLDAPSError {
            meta: generic,
            kind: crate::error::DisableLDAPSErrorKind::DirectoryUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::directory_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_directory_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableLDAPSError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidLDAPSStatusException" => crate::error::DisableLDAPSError {
            meta: generic,
            kind: crate::error::DisableLDAPSErrorKind::InvalidLdapsStatusException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_ldaps_status_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_ldaps_status_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableLDAPSError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DisableLDAPSError {
            meta: generic,
            kind: crate::error::DisableLDAPSErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableLDAPSError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DisableLDAPSError {
                meta: generic,
                kind: crate::error::DisableLDAPSErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableLDAPSError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperationException" => crate::error::DisableLDAPSError {
            meta: generic,
            kind: crate::error::DisableLDAPSErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableLDAPSError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DisableLDAPSError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_ldaps_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DisableLdapsOutput, crate::error::DisableLDAPSError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disable_ldaps_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_radius_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DisableRadiusOutput, crate::error::DisableRadiusError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisableRadiusError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DisableRadiusError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DisableRadiusError {
                meta: generic,
                kind: crate::error::DisableRadiusErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableRadiusError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityDoesNotExistException" => crate::error::DisableRadiusError {
            meta: generic,
            kind: crate::error::DisableRadiusErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableRadiusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DisableRadiusError {
                meta: generic,
                kind: crate::error::DisableRadiusErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableRadiusError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DisableRadiusError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_radius_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DisableRadiusOutput, crate::error::DisableRadiusError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disable_radius_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_sso_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DisableSsoOutput, crate::error::DisableSsoError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisableSsoError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DisableSsoError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthenticationFailedException" => crate::error::DisableSsoError {
            meta: generic,
            kind: crate::error::DisableSsoErrorKind::AuthenticationFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authentication_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_authentication_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableSsoError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClientException" => {
            crate::error::DisableSsoError {
                meta: generic,
                kind: crate::error::DisableSsoErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableSsoError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityDoesNotExistException" => crate::error::DisableSsoError {
            meta: generic,
            kind: crate::error::DisableSsoErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableSsoError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InsufficientPermissionsException" => crate::error::DisableSsoError {
            meta: generic,
            kind: crate::error::DisableSsoErrorKind::InsufficientPermissionsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::insufficient_permissions_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_insufficient_permissions_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableSsoError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DisableSsoError {
                meta: generic,
                kind: crate::error::DisableSsoErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableSsoError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DisableSsoError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_sso_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DisableSsoOutput, crate::error::DisableSsoError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disable_sso_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_client_authentication_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::EnableClientAuthenticationOutput,
    crate::error::EnableClientAuthenticationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::EnableClientAuthenticationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::EnableClientAuthenticationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::EnableClientAuthenticationError {
            meta: generic,
            kind: crate::error::EnableClientAuthenticationErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableClientAuthenticationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClientException" => {
            crate::error::EnableClientAuthenticationError {
                meta: generic,
                kind: crate::error::EnableClientAuthenticationErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableClientAuthenticationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DirectoryDoesNotExistException" => crate::error::EnableClientAuthenticationError {
            meta: generic,
            kind: crate::error::EnableClientAuthenticationErrorKind::DirectoryDoesNotExistException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::directory_does_not_exist_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_directory_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableClientAuthenticationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidClientAuthStatusException" => crate::error::EnableClientAuthenticationError {
            meta: generic,
            kind:
                crate::error::EnableClientAuthenticationErrorKind::InvalidClientAuthStatusException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::invalid_client_auth_status_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_client_auth_status_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableClientAuthenticationError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "NoAvailableCertificateException" => crate::error::EnableClientAuthenticationError {
            meta: generic,
            kind:
                crate::error::EnableClientAuthenticationErrorKind::NoAvailableCertificateException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::no_available_certificate_exception::Builder::default(
                                );
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_no_available_certificate_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableClientAuthenticationError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ServiceException" => {
            crate::error::EnableClientAuthenticationError {
                meta: generic,
                kind: crate::error::EnableClientAuthenticationErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableClientAuthenticationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperationException" => crate::error::EnableClientAuthenticationError {
            meta: generic,
            kind: crate::error::EnableClientAuthenticationErrorKind::UnsupportedOperationException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::unsupported_operation_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableClientAuthenticationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::EnableClientAuthenticationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_client_authentication_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::EnableClientAuthenticationOutput,
    crate::error::EnableClientAuthenticationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::enable_client_authentication_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_ldaps_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::EnableLdapsOutput, crate::error::EnableLDAPSError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::EnableLDAPSError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::EnableLDAPSError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::EnableLDAPSError {
                meta: generic,
                kind: crate::error::EnableLDAPSErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableLDAPSError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DirectoryDoesNotExistException" => crate::error::EnableLDAPSError {
            meta: generic,
            kind: crate::error::EnableLDAPSErrorKind::DirectoryDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::directory_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_directory_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableLDAPSError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DirectoryUnavailableException" => crate::error::EnableLDAPSError {
            meta: generic,
            kind: crate::error::EnableLDAPSErrorKind::DirectoryUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::directory_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_directory_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableLDAPSError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidLDAPSStatusException" => crate::error::EnableLDAPSError {
            meta: generic,
            kind: crate::error::EnableLDAPSErrorKind::InvalidLdapsStatusException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_ldaps_status_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_ldaps_status_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableLDAPSError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::EnableLDAPSError {
            meta: generic,
            kind: crate::error::EnableLDAPSErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableLDAPSError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoAvailableCertificateException" => crate::error::EnableLDAPSError {
            meta: generic,
            kind: crate::error::EnableLDAPSErrorKind::NoAvailableCertificateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::no_available_certificate_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_no_available_certificate_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableLDAPSError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::EnableLDAPSError {
                meta: generic,
                kind: crate::error::EnableLDAPSErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableLDAPSError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperationException" => crate::error::EnableLDAPSError {
            meta: generic,
            kind: crate::error::EnableLDAPSErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableLDAPSError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::EnableLDAPSError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_ldaps_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::EnableLdapsOutput, crate::error::EnableLDAPSError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::enable_ldaps_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_radius_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::EnableRadiusOutput, crate::error::EnableRadiusError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::EnableRadiusError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::EnableRadiusError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::EnableRadiusError {
                meta: generic,
                kind: crate::error::EnableRadiusErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableRadiusError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityAlreadyExistsException" => crate::error::EnableRadiusError {
            meta: generic,
            kind: crate::error::EnableRadiusErrorKind::EntityAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableRadiusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EntityDoesNotExistException" => crate::error::EnableRadiusError {
            meta: generic,
            kind: crate::error::EnableRadiusErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableRadiusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::EnableRadiusError {
            meta: generic,
            kind: crate::error::EnableRadiusErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableRadiusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::EnableRadiusError {
                meta: generic,
                kind: crate::error::EnableRadiusErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableRadiusError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::EnableRadiusError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_radius_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::EnableRadiusOutput, crate::error::EnableRadiusError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::enable_radius_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_sso_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::EnableSsoOutput, crate::error::EnableSsoError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::EnableSsoError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::EnableSsoError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthenticationFailedException" => crate::error::EnableSsoError {
            meta: generic,
            kind: crate::error::EnableSsoErrorKind::AuthenticationFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authentication_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_authentication_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableSsoError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClientException" => {
            crate::error::EnableSsoError {
                meta: generic,
                kind: crate::error::EnableSsoErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableSsoError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityDoesNotExistException" => crate::error::EnableSsoError {
            meta: generic,
            kind: crate::error::EnableSsoErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableSsoError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InsufficientPermissionsException" => crate::error::EnableSsoError {
            meta: generic,
            kind: crate::error::EnableSsoErrorKind::InsufficientPermissionsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::insufficient_permissions_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_insufficient_permissions_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableSsoError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::EnableSsoError {
                meta: generic,
                kind: crate::error::EnableSsoErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableSsoError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::EnableSsoError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_sso_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::EnableSsoOutput, crate::error::EnableSsoError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::enable_sso_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_directory_limits_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetDirectoryLimitsOutput,
    crate::error::GetDirectoryLimitsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetDirectoryLimitsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetDirectoryLimitsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::GetDirectoryLimitsError {
                meta: generic,
                kind: crate::error::GetDirectoryLimitsErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDirectoryLimitsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityDoesNotExistException" => crate::error::GetDirectoryLimitsError {
            meta: generic,
            kind: crate::error::GetDirectoryLimitsErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDirectoryLimitsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetDirectoryLimitsError {
                meta: generic,
                kind: crate::error::GetDirectoryLimitsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDirectoryLimitsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::GetDirectoryLimitsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_directory_limits_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetDirectoryLimitsOutput,
    crate::error::GetDirectoryLimitsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_directory_limits_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_directory_limits(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetDirectoryLimitsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_snapshot_limits_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetSnapshotLimitsOutput, crate::error::GetSnapshotLimitsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetSnapshotLimitsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetSnapshotLimitsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::GetSnapshotLimitsError {
                meta: generic,
                kind: crate::error::GetSnapshotLimitsErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSnapshotLimitsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityDoesNotExistException" => crate::error::GetSnapshotLimitsError {
            meta: generic,
            kind: crate::error::GetSnapshotLimitsErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSnapshotLimitsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetSnapshotLimitsError {
                meta: generic,
                kind: crate::error::GetSnapshotLimitsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSnapshotLimitsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::GetSnapshotLimitsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_snapshot_limits_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetSnapshotLimitsOutput, crate::error::GetSnapshotLimitsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_snapshot_limits_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_snapshot_limits(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetSnapshotLimitsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_certificates_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListCertificatesOutput, crate::error::ListCertificatesError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListCertificatesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListCertificatesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::ListCertificatesError {
                meta: generic,
                kind: crate::error::ListCertificatesErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCertificatesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DirectoryDoesNotExistException" => crate::error::ListCertificatesError {
            meta: generic,
            kind: crate::error::ListCertificatesErrorKind::DirectoryDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::directory_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_directory_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCertificatesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::ListCertificatesError {
            meta: generic,
            kind: crate::error::ListCertificatesErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCertificatesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ListCertificatesError {
            meta: generic,
            kind: crate::error::ListCertificatesErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCertificatesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::ListCertificatesError {
                meta: generic,
                kind: crate::error::ListCertificatesErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCertificatesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperationException" => crate::error::ListCertificatesError {
            meta: generic,
            kind: crate::error::ListCertificatesErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCertificatesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListCertificatesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_certificates_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListCertificatesOutput, crate::error::ListCertificatesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_certificates_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_certificates(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListCertificatesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_ip_routes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListIpRoutesOutput, crate::error::ListIpRoutesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListIpRoutesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListIpRoutesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::ListIpRoutesError {
                meta: generic,
                kind: crate::error::ListIpRoutesErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListIpRoutesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityDoesNotExistException" => crate::error::ListIpRoutesError {
            meta: generic,
            kind: crate::error::ListIpRoutesErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListIpRoutesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::ListIpRoutesError {
            meta: generic,
            kind: crate::error::ListIpRoutesErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListIpRoutesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ListIpRoutesError {
            meta: generic,
            kind: crate::error::ListIpRoutesErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListIpRoutesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::ListIpRoutesError {
                meta: generic,
                kind: crate::error::ListIpRoutesErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListIpRoutesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListIpRoutesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_ip_routes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListIpRoutesOutput, crate::error::ListIpRoutesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_ip_routes_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_ip_routes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListIpRoutesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_log_subscriptions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListLogSubscriptionsOutput,
    crate::error::ListLogSubscriptionsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListLogSubscriptionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListLogSubscriptionsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::ListLogSubscriptionsError {
                meta: generic,
                kind: crate::error::ListLogSubscriptionsErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListLogSubscriptionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityDoesNotExistException" => crate::error::ListLogSubscriptionsError {
            meta: generic,
            kind: crate::error::ListLogSubscriptionsErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListLogSubscriptionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::ListLogSubscriptionsError {
            meta: generic,
            kind: crate::error::ListLogSubscriptionsErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListLogSubscriptionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::ListLogSubscriptionsError {
                meta: generic,
                kind: crate::error::ListLogSubscriptionsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListLogSubscriptionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListLogSubscriptionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_log_subscriptions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListLogSubscriptionsOutput,
    crate::error::ListLogSubscriptionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_log_subscriptions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_log_subscriptions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListLogSubscriptionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_schema_extensions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListSchemaExtensionsOutput,
    crate::error::ListSchemaExtensionsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListSchemaExtensionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListSchemaExtensionsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::ListSchemaExtensionsError {
                meta: generic,
                kind: crate::error::ListSchemaExtensionsErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListSchemaExtensionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityDoesNotExistException" => crate::error::ListSchemaExtensionsError {
            meta: generic,
            kind: crate::error::ListSchemaExtensionsErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListSchemaExtensionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::ListSchemaExtensionsError {
            meta: generic,
            kind: crate::error::ListSchemaExtensionsErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListSchemaExtensionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::ListSchemaExtensionsError {
                meta: generic,
                kind: crate::error::ListSchemaExtensionsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListSchemaExtensionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListSchemaExtensionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_schema_extensions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListSchemaExtensionsOutput,
    crate::error::ListSchemaExtensionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_schema_extensions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_schema_extensions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListSchemaExtensionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsForResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::ListTagsForResourceError {
                meta: generic,
                kind: crate::error::ListTagsForResourceErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityDoesNotExistException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::ListTagsForResourceError {
                meta: generic,
                kind: crate::error::ListTagsForResourceErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListTagsForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_for_resource_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tags_for_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_certificate_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RegisterCertificateOutput,
    crate::error::RegisterCertificateError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RegisterCertificateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RegisterCertificateError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CertificateAlreadyExistsException" => crate::error::RegisterCertificateError {
            meta: generic,
            kind: crate::error::RegisterCertificateErrorKind::CertificateAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::certificate_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_certificate_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CertificateLimitExceededException" => crate::error::RegisterCertificateError {
            meta: generic,
            kind: crate::error::RegisterCertificateErrorKind::CertificateLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::certificate_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_certificate_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClientException" => {
            crate::error::RegisterCertificateError {
                meta: generic,
                kind: crate::error::RegisterCertificateErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterCertificateError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DirectoryDoesNotExistException" => crate::error::RegisterCertificateError {
            meta: generic,
            kind: crate::error::RegisterCertificateErrorKind::DirectoryDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::directory_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_directory_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DirectoryUnavailableException" => crate::error::RegisterCertificateError {
            meta: generic,
            kind: crate::error::RegisterCertificateErrorKind::DirectoryUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::directory_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_directory_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidCertificateException" => crate::error::RegisterCertificateError {
            meta: generic,
            kind: crate::error::RegisterCertificateErrorKind::InvalidCertificateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_certificate_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_certificate_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::RegisterCertificateError {
            meta: generic,
            kind: crate::error::RegisterCertificateErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::RegisterCertificateError {
                meta: generic,
                kind: crate::error::RegisterCertificateErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterCertificateError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperationException" => crate::error::RegisterCertificateError {
            meta: generic,
            kind: crate::error::RegisterCertificateErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RegisterCertificateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_certificate_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RegisterCertificateOutput,
    crate::error::RegisterCertificateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::register_certificate_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_register_certificate(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RegisterCertificateError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_event_topic_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RegisterEventTopicOutput,
    crate::error::RegisterEventTopicError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RegisterEventTopicError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RegisterEventTopicError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::RegisterEventTopicError {
                meta: generic,
                kind: crate::error::RegisterEventTopicErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterEventTopicError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityDoesNotExistException" => crate::error::RegisterEventTopicError {
            meta: generic,
            kind: crate::error::RegisterEventTopicErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterEventTopicError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::RegisterEventTopicError {
            meta: generic,
            kind: crate::error::RegisterEventTopicErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterEventTopicError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::RegisterEventTopicError {
                meta: generic,
                kind: crate::error::RegisterEventTopicErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterEventTopicError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::RegisterEventTopicError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_event_topic_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RegisterEventTopicOutput,
    crate::error::RegisterEventTopicError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::register_event_topic_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reject_shared_directory_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RejectSharedDirectoryOutput,
    crate::error::RejectSharedDirectoryError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RejectSharedDirectoryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RejectSharedDirectoryError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::RejectSharedDirectoryError {
                meta: generic,
                kind: crate::error::RejectSharedDirectoryErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RejectSharedDirectoryError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DirectoryAlreadySharedException" => crate::error::RejectSharedDirectoryError {
            meta: generic,
            kind: crate::error::RejectSharedDirectoryErrorKind::DirectoryAlreadySharedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::directory_already_shared_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_directory_already_shared_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RejectSharedDirectoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EntityDoesNotExistException" => crate::error::RejectSharedDirectoryError {
            meta: generic,
            kind: crate::error::RejectSharedDirectoryErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RejectSharedDirectoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::RejectSharedDirectoryError {
            meta: generic,
            kind: crate::error::RejectSharedDirectoryErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RejectSharedDirectoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::RejectSharedDirectoryError {
                meta: generic,
                kind: crate::error::RejectSharedDirectoryErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RejectSharedDirectoryError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::RejectSharedDirectoryError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reject_shared_directory_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RejectSharedDirectoryOutput,
    crate::error::RejectSharedDirectoryError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::reject_shared_directory_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_reject_shared_directory(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RejectSharedDirectoryError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_ip_routes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RemoveIpRoutesOutput, crate::error::RemoveIpRoutesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RemoveIpRoutesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RemoveIpRoutesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::RemoveIpRoutesError {
                meta: generic,
                kind: crate::error::RemoveIpRoutesErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveIpRoutesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DirectoryUnavailableException" => crate::error::RemoveIpRoutesError {
            meta: generic,
            kind: crate::error::RemoveIpRoutesErrorKind::DirectoryUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::directory_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_directory_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveIpRoutesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EntityDoesNotExistException" => crate::error::RemoveIpRoutesError {
            meta: generic,
            kind: crate::error::RemoveIpRoutesErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveIpRoutesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::RemoveIpRoutesError {
            meta: generic,
            kind: crate::error::RemoveIpRoutesErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveIpRoutesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::RemoveIpRoutesError {
                meta: generic,
                kind: crate::error::RemoveIpRoutesErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveIpRoutesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::RemoveIpRoutesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_ip_routes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RemoveIpRoutesOutput, crate::error::RemoveIpRoutesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::remove_ip_routes_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_region_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RemoveRegionOutput, crate::error::RemoveRegionError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RemoveRegionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RemoveRegionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::RemoveRegionError {
            meta: generic,
            kind: crate::error::RemoveRegionErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveRegionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClientException" => {
            crate::error::RemoveRegionError {
                meta: generic,
                kind: crate::error::RemoveRegionErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveRegionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DirectoryDoesNotExistException" => crate::error::RemoveRegionError {
            meta: generic,
            kind: crate::error::RemoveRegionErrorKind::DirectoryDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::directory_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_directory_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveRegionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DirectoryUnavailableException" => crate::error::RemoveRegionError {
            meta: generic,
            kind: crate::error::RemoveRegionErrorKind::DirectoryUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::directory_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_directory_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveRegionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::RemoveRegionError {
                meta: generic,
                kind: crate::error::RemoveRegionErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveRegionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperationException" => crate::error::RemoveRegionError {
            meta: generic,
            kind: crate::error::RemoveRegionErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveRegionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RemoveRegionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_region_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RemoveRegionOutput, crate::error::RemoveRegionError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::remove_region_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_tags_from_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveTagsFromResourceOutput,
    crate::error::RemoveTagsFromResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RemoveTagsFromResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RemoveTagsFromResourceError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::RemoveTagsFromResourceError {
                meta: generic,
                kind: crate::error::RemoveTagsFromResourceErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsFromResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityDoesNotExistException" => crate::error::RemoveTagsFromResourceError {
            meta: generic,
            kind: crate::error::RemoveTagsFromResourceErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsFromResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::RemoveTagsFromResourceError {
            meta: generic,
            kind: crate::error::RemoveTagsFromResourceErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsFromResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::RemoveTagsFromResourceError {
                meta: generic,
                kind: crate::error::RemoveTagsFromResourceErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsFromResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::RemoveTagsFromResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_tags_from_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveTagsFromResourceOutput,
    crate::error::RemoveTagsFromResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::remove_tags_from_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reset_user_password_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ResetUserPasswordOutput, crate::error::ResetUserPasswordError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ResetUserPasswordError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ResetUserPasswordError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::ResetUserPasswordError {
                meta: generic,
                kind: crate::error::ResetUserPasswordErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ResetUserPasswordError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DirectoryUnavailableException" => crate::error::ResetUserPasswordError {
            meta: generic,
            kind: crate::error::ResetUserPasswordErrorKind::DirectoryUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::directory_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_directory_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ResetUserPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EntityDoesNotExistException" => crate::error::ResetUserPasswordError {
            meta: generic,
            kind: crate::error::ResetUserPasswordErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ResetUserPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidPasswordException" => crate::error::ResetUserPasswordError {
            meta: generic,
            kind: crate::error::ResetUserPasswordErrorKind::InvalidPasswordException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_password_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_password_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ResetUserPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::ResetUserPasswordError {
                meta: generic,
                kind: crate::error::ResetUserPasswordErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ResetUserPasswordError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperationException" => crate::error::ResetUserPasswordError {
            meta: generic,
            kind: crate::error::ResetUserPasswordErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ResetUserPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserDoesNotExistException" => crate::error::ResetUserPasswordError {
            meta: generic,
            kind: crate::error::ResetUserPasswordErrorKind::UserDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::user_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ResetUserPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ResetUserPasswordError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reset_user_password_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ResetUserPasswordOutput, crate::error::ResetUserPasswordError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::reset_user_password_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restore_from_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RestoreFromSnapshotOutput,
    crate::error::RestoreFromSnapshotError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RestoreFromSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RestoreFromSnapshotError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::RestoreFromSnapshotError {
                meta: generic,
                kind: crate::error::RestoreFromSnapshotErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreFromSnapshotError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityDoesNotExistException" => crate::error::RestoreFromSnapshotError {
            meta: generic,
            kind: crate::error::RestoreFromSnapshotErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreFromSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::RestoreFromSnapshotError {
            meta: generic,
            kind: crate::error::RestoreFromSnapshotErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreFromSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::RestoreFromSnapshotError {
                meta: generic,
                kind: crate::error::RestoreFromSnapshotErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreFromSnapshotError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::RestoreFromSnapshotError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restore_from_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RestoreFromSnapshotOutput,
    crate::error::RestoreFromSnapshotError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::restore_from_snapshot_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_share_directory_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ShareDirectoryOutput, crate::error::ShareDirectoryError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ShareDirectoryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ShareDirectoryError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ShareDirectoryError {
            meta: generic,
            kind: crate::error::ShareDirectoryErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ShareDirectoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClientException" => {
            crate::error::ShareDirectoryError {
                meta: generic,
                kind: crate::error::ShareDirectoryErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ShareDirectoryError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DirectoryAlreadySharedException" => crate::error::ShareDirectoryError {
            meta: generic,
            kind: crate::error::ShareDirectoryErrorKind::DirectoryAlreadySharedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::directory_already_shared_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_directory_already_shared_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ShareDirectoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EntityDoesNotExistException" => crate::error::ShareDirectoryError {
            meta: generic,
            kind: crate::error::ShareDirectoryErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ShareDirectoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ShareDirectoryError {
            meta: generic,
            kind: crate::error::ShareDirectoryErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ShareDirectoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTargetException" => crate::error::ShareDirectoryError {
            meta: generic,
            kind: crate::error::ShareDirectoryErrorKind::InvalidTargetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_target_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_target_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ShareDirectoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OrganizationsException" => crate::error::ShareDirectoryError {
            meta: generic,
            kind: crate::error::ShareDirectoryErrorKind::OrganizationsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::organizations_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_organizations_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ShareDirectoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::ShareDirectoryError {
                meta: generic,
                kind: crate::error::ShareDirectoryErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ShareDirectoryError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ShareLimitExceededException" => crate::error::ShareDirectoryError {
            meta: generic,
            kind: crate::error::ShareDirectoryErrorKind::ShareLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::share_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_share_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ShareDirectoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::ShareDirectoryError {
            meta: generic,
            kind: crate::error::ShareDirectoryErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ShareDirectoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ShareDirectoryError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_share_directory_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ShareDirectoryOutput, crate::error::ShareDirectoryError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::share_directory_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_share_directory(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ShareDirectoryError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_schema_extension_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartSchemaExtensionOutput,
    crate::error::StartSchemaExtensionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartSchemaExtensionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StartSchemaExtensionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::StartSchemaExtensionError {
                meta: generic,
                kind: crate::error::StartSchemaExtensionErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartSchemaExtensionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DirectoryUnavailableException" => crate::error::StartSchemaExtensionError {
            meta: generic,
            kind: crate::error::StartSchemaExtensionErrorKind::DirectoryUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::directory_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_directory_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartSchemaExtensionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EntityDoesNotExistException" => crate::error::StartSchemaExtensionError {
            meta: generic,
            kind: crate::error::StartSchemaExtensionErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartSchemaExtensionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::StartSchemaExtensionError {
            meta: generic,
            kind: crate::error::StartSchemaExtensionErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartSchemaExtensionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::StartSchemaExtensionError {
                meta: generic,
                kind: crate::error::StartSchemaExtensionErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartSchemaExtensionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "SnapshotLimitExceededException" => crate::error::StartSchemaExtensionError {
            meta: generic,
            kind: crate::error::StartSchemaExtensionErrorKind::SnapshotLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::snapshot_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_snapshot_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartSchemaExtensionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartSchemaExtensionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_schema_extension_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartSchemaExtensionOutput,
    crate::error::StartSchemaExtensionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_schema_extension_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_start_schema_extension(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartSchemaExtensionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_unshare_directory_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UnshareDirectoryOutput, crate::error::UnshareDirectoryError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UnshareDirectoryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UnshareDirectoryError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::UnshareDirectoryError {
                meta: generic,
                kind: crate::error::UnshareDirectoryErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UnshareDirectoryError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DirectoryNotSharedException" => crate::error::UnshareDirectoryError {
            meta: generic,
            kind: crate::error::UnshareDirectoryErrorKind::DirectoryNotSharedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::directory_not_shared_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_directory_not_shared_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UnshareDirectoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EntityDoesNotExistException" => crate::error::UnshareDirectoryError {
            meta: generic,
            kind: crate::error::UnshareDirectoryErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UnshareDirectoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTargetException" => crate::error::UnshareDirectoryError {
            meta: generic,
            kind: crate::error::UnshareDirectoryErrorKind::InvalidTargetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_target_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_target_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UnshareDirectoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::UnshareDirectoryError {
                meta: generic,
                kind: crate::error::UnshareDirectoryErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UnshareDirectoryError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UnshareDirectoryError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_unshare_directory_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UnshareDirectoryOutput, crate::error::UnshareDirectoryError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::unshare_directory_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_unshare_directory(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UnshareDirectoryError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_conditional_forwarder_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateConditionalForwarderOutput,
    crate::error::UpdateConditionalForwarderError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateConditionalForwarderError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateConditionalForwarderError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::UpdateConditionalForwarderError {
                meta: generic,
                kind: crate::error::UpdateConditionalForwarderErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateConditionalForwarderError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DirectoryUnavailableException" => crate::error::UpdateConditionalForwarderError {
            meta: generic,
            kind: crate::error::UpdateConditionalForwarderErrorKind::DirectoryUnavailableException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::directory_unavailable_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_directory_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateConditionalForwarderError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "EntityDoesNotExistException" => crate::error::UpdateConditionalForwarderError {
            meta: generic,
            kind: crate::error::UpdateConditionalForwarderErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateConditionalForwarderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::UpdateConditionalForwarderError {
            meta: generic,
            kind: crate::error::UpdateConditionalForwarderErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateConditionalForwarderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::UpdateConditionalForwarderError {
                meta: generic,
                kind: crate::error::UpdateConditionalForwarderErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateConditionalForwarderError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperationException" => crate::error::UpdateConditionalForwarderError {
            meta: generic,
            kind: crate::error::UpdateConditionalForwarderErrorKind::UnsupportedOperationException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::unsupported_operation_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateConditionalForwarderError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::UpdateConditionalForwarderError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_conditional_forwarder_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateConditionalForwarderOutput,
    crate::error::UpdateConditionalForwarderError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_conditional_forwarder_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_number_of_domain_controllers_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateNumberOfDomainControllersOutput,
    crate::error::UpdateNumberOfDomainControllersError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateNumberOfDomainControllersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateNumberOfDomainControllersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => crate::error::UpdateNumberOfDomainControllersError { meta: generic, kind: crate::error::UpdateNumberOfDomainControllersErrorKind::ClientException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::client_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateNumberOfDomainControllersError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DirectoryUnavailableException" => crate::error::UpdateNumberOfDomainControllersError { meta: generic, kind: crate::error::UpdateNumberOfDomainControllersErrorKind::DirectoryUnavailableException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::directory_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_directory_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateNumberOfDomainControllersError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DomainControllerLimitExceededException" => crate::error::UpdateNumberOfDomainControllersError { meta: generic, kind: crate::error::UpdateNumberOfDomainControllersErrorKind::DomainControllerLimitExceededException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::domain_controller_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_domain_controller_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateNumberOfDomainControllersError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "EntityDoesNotExistException" => crate::error::UpdateNumberOfDomainControllersError { meta: generic, kind: crate::error::UpdateNumberOfDomainControllersErrorKind::EntityDoesNotExistException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateNumberOfDomainControllersError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterException" => crate::error::UpdateNumberOfDomainControllersError { meta: generic, kind: crate::error::UpdateNumberOfDomainControllersErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateNumberOfDomainControllersError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::UpdateNumberOfDomainControllersError { meta: generic, kind: crate::error::UpdateNumberOfDomainControllersErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateNumberOfDomainControllersError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedOperationException" => crate::error::UpdateNumberOfDomainControllersError { meta: generic, kind: crate::error::UpdateNumberOfDomainControllersErrorKind::UnsupportedOperationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateNumberOfDomainControllersError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::UpdateNumberOfDomainControllersError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_number_of_domain_controllers_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateNumberOfDomainControllersOutput,
    crate::error::UpdateNumberOfDomainControllersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::update_number_of_domain_controllers_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_radius_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateRadiusOutput, crate::error::UpdateRadiusError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateRadiusError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateRadiusError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::UpdateRadiusError {
                meta: generic,
                kind: crate::error::UpdateRadiusErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRadiusError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityDoesNotExistException" => crate::error::UpdateRadiusError {
            meta: generic,
            kind: crate::error::UpdateRadiusErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRadiusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::UpdateRadiusError {
            meta: generic,
            kind: crate::error::UpdateRadiusErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRadiusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::UpdateRadiusError {
                meta: generic,
                kind: crate::error::UpdateRadiusErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRadiusError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdateRadiusError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_radius_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateRadiusOutput, crate::error::UpdateRadiusError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_radius_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_trust_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateTrustOutput, crate::error::UpdateTrustError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateTrustError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateTrustError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::UpdateTrustError {
                meta: generic,
                kind: crate::error::UpdateTrustErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrustError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityDoesNotExistException" => crate::error::UpdateTrustError {
            meta: generic,
            kind: crate::error::UpdateTrustErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrustError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::UpdateTrustError {
            meta: generic,
            kind: crate::error::UpdateTrustErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrustError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::UpdateTrustError {
                meta: generic,
                kind: crate::error::UpdateTrustErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrustError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdateTrustError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_trust_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateTrustOutput, crate::error::UpdateTrustError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_trust_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_trust(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateTrustError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_verify_trust_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::VerifyTrustOutput, crate::error::VerifyTrustError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::VerifyTrustError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::VerifyTrustError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::VerifyTrustError {
                meta: generic,
                kind: crate::error::VerifyTrustErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifyTrustError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EntityDoesNotExistException" => crate::error::VerifyTrustError {
            meta: generic,
            kind: crate::error::VerifyTrustErrorKind::EntityDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_entity_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifyTrustError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::VerifyTrustError {
            meta: generic,
            kind: crate::error::VerifyTrustErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifyTrustError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::VerifyTrustError {
                meta: generic,
                kind: crate::error::VerifyTrustErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifyTrustError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperationException" => crate::error::VerifyTrustError {
            meta: generic,
            kind: crate::error::VerifyTrustErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifyTrustError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::VerifyTrustError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_verify_trust_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::VerifyTrustOutput, crate::error::VerifyTrustError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::verify_trust_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_verify_trust(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::VerifyTrustError::unhandled)?;
        output.build()
    })
}
