// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Result of a VerifyTrust request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VerifyTrustOutput {
    /// <p>The unique Trust ID of the trust relationship that was verified.</p>
    pub trust_id: std::option::Option<std::string::String>,
}
impl VerifyTrustOutput {
    /// <p>The unique Trust ID of the trust relationship that was verified.</p>
    pub fn trust_id(&self) -> std::option::Option<&str> {
        self.trust_id.as_deref()
    }
}
impl std::fmt::Debug for VerifyTrustOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VerifyTrustOutput");
        formatter.field("trust_id", &self.trust_id);
        formatter.finish()
    }
}
/// See [`VerifyTrustOutput`](crate::output::VerifyTrustOutput)
pub mod verify_trust_output {
    /// A builder for [`VerifyTrustOutput`](crate::output::VerifyTrustOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trust_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique Trust ID of the trust relationship that was verified.</p>
        pub fn trust_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.trust_id = Some(input.into());
            self
        }
        /// <p>The unique Trust ID of the trust relationship that was verified.</p>
        pub fn set_trust_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trust_id = input;
            self
        }
        /// Consumes the builder and constructs a [`VerifyTrustOutput`](crate::output::VerifyTrustOutput)
        pub fn build(self) -> crate::output::VerifyTrustOutput {
            crate::output::VerifyTrustOutput {
                trust_id: self.trust_id,
            }
        }
    }
}
impl VerifyTrustOutput {
    /// Creates a new builder-style object to manufacture [`VerifyTrustOutput`](crate::output::VerifyTrustOutput)
    pub fn builder() -> crate::output::verify_trust_output::Builder {
        crate::output::verify_trust_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTrustOutput {
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>Identifier of the trust relationship.</p>
    pub trust_id: std::option::Option<std::string::String>,
}
impl UpdateTrustOutput {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>Identifier of the trust relationship.</p>
    pub fn trust_id(&self) -> std::option::Option<&str> {
        self.trust_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateTrustOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTrustOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("trust_id", &self.trust_id);
        formatter.finish()
    }
}
/// See [`UpdateTrustOutput`](crate::output::UpdateTrustOutput)
pub mod update_trust_output {
    /// A builder for [`UpdateTrustOutput`](crate::output::UpdateTrustOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) trust_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>Identifier of the trust relationship.</p>
        pub fn trust_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.trust_id = Some(input.into());
            self
        }
        /// <p>Identifier of the trust relationship.</p>
        pub fn set_trust_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trust_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTrustOutput`](crate::output::UpdateTrustOutput)
        pub fn build(self) -> crate::output::UpdateTrustOutput {
            crate::output::UpdateTrustOutput {
                request_id: self.request_id,
                trust_id: self.trust_id,
            }
        }
    }
}
impl UpdateTrustOutput {
    /// Creates a new builder-style object to manufacture [`UpdateTrustOutput`](crate::output::UpdateTrustOutput)
    pub fn builder() -> crate::output::update_trust_output::Builder {
        crate::output::update_trust_output::Builder::default()
    }
}

/// <p>Contains the results of the <a>UpdateRadius</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRadiusOutput {}
impl std::fmt::Debug for UpdateRadiusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRadiusOutput");
        formatter.finish()
    }
}
/// See [`UpdateRadiusOutput`](crate::output::UpdateRadiusOutput)
pub mod update_radius_output {
    /// A builder for [`UpdateRadiusOutput`](crate::output::UpdateRadiusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateRadiusOutput`](crate::output::UpdateRadiusOutput)
        pub fn build(self) -> crate::output::UpdateRadiusOutput {
            crate::output::UpdateRadiusOutput {}
        }
    }
}
impl UpdateRadiusOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRadiusOutput`](crate::output::UpdateRadiusOutput)
    pub fn builder() -> crate::output::update_radius_output::Builder {
        crate::output::update_radius_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateNumberOfDomainControllersOutput {}
impl std::fmt::Debug for UpdateNumberOfDomainControllersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateNumberOfDomainControllersOutput");
        formatter.finish()
    }
}
/// See [`UpdateNumberOfDomainControllersOutput`](crate::output::UpdateNumberOfDomainControllersOutput)
pub mod update_number_of_domain_controllers_output {
    /// A builder for [`UpdateNumberOfDomainControllersOutput`](crate::output::UpdateNumberOfDomainControllersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateNumberOfDomainControllersOutput`](crate::output::UpdateNumberOfDomainControllersOutput)
        pub fn build(self) -> crate::output::UpdateNumberOfDomainControllersOutput {
            crate::output::UpdateNumberOfDomainControllersOutput {}
        }
    }
}
impl UpdateNumberOfDomainControllersOutput {
    /// Creates a new builder-style object to manufacture [`UpdateNumberOfDomainControllersOutput`](crate::output::UpdateNumberOfDomainControllersOutput)
    pub fn builder() -> crate::output::update_number_of_domain_controllers_output::Builder {
        crate::output::update_number_of_domain_controllers_output::Builder::default()
    }
}

/// <p>The result of an UpdateConditionalForwarder request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConditionalForwarderOutput {}
impl std::fmt::Debug for UpdateConditionalForwarderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConditionalForwarderOutput");
        formatter.finish()
    }
}
/// See [`UpdateConditionalForwarderOutput`](crate::output::UpdateConditionalForwarderOutput)
pub mod update_conditional_forwarder_output {
    /// A builder for [`UpdateConditionalForwarderOutput`](crate::output::UpdateConditionalForwarderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateConditionalForwarderOutput`](crate::output::UpdateConditionalForwarderOutput)
        pub fn build(self) -> crate::output::UpdateConditionalForwarderOutput {
            crate::output::UpdateConditionalForwarderOutput {}
        }
    }
}
impl UpdateConditionalForwarderOutput {
    /// Creates a new builder-style object to manufacture [`UpdateConditionalForwarderOutput`](crate::output::UpdateConditionalForwarderOutput)
    pub fn builder() -> crate::output::update_conditional_forwarder_output::Builder {
        crate::output::update_conditional_forwarder_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnshareDirectoryOutput {
    /// <p>Identifier of the directory stored in the directory consumer account that is to be
    /// unshared from the specified directory (<code>DirectoryId</code>).</p>
    pub shared_directory_id: std::option::Option<std::string::String>,
}
impl UnshareDirectoryOutput {
    /// <p>Identifier of the directory stored in the directory consumer account that is to be
    /// unshared from the specified directory (<code>DirectoryId</code>).</p>
    pub fn shared_directory_id(&self) -> std::option::Option<&str> {
        self.shared_directory_id.as_deref()
    }
}
impl std::fmt::Debug for UnshareDirectoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnshareDirectoryOutput");
        formatter.field("shared_directory_id", &self.shared_directory_id);
        formatter.finish()
    }
}
/// See [`UnshareDirectoryOutput`](crate::output::UnshareDirectoryOutput)
pub mod unshare_directory_output {
    /// A builder for [`UnshareDirectoryOutput`](crate::output::UnshareDirectoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) shared_directory_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Identifier of the directory stored in the directory consumer account that is to be
        /// unshared from the specified directory (<code>DirectoryId</code>).</p>
        pub fn shared_directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.shared_directory_id = Some(input.into());
            self
        }
        /// <p>Identifier of the directory stored in the directory consumer account that is to be
        /// unshared from the specified directory (<code>DirectoryId</code>).</p>
        pub fn set_shared_directory_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.shared_directory_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UnshareDirectoryOutput`](crate::output::UnshareDirectoryOutput)
        pub fn build(self) -> crate::output::UnshareDirectoryOutput {
            crate::output::UnshareDirectoryOutput {
                shared_directory_id: self.shared_directory_id,
            }
        }
    }
}
impl UnshareDirectoryOutput {
    /// Creates a new builder-style object to manufacture [`UnshareDirectoryOutput`](crate::output::UnshareDirectoryOutput)
    pub fn builder() -> crate::output::unshare_directory_output::Builder {
        crate::output::unshare_directory_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartSchemaExtensionOutput {
    /// <p>The identifier of the schema extension that will be applied.</p>
    pub schema_extension_id: std::option::Option<std::string::String>,
}
impl StartSchemaExtensionOutput {
    /// <p>The identifier of the schema extension that will be applied.</p>
    pub fn schema_extension_id(&self) -> std::option::Option<&str> {
        self.schema_extension_id.as_deref()
    }
}
impl std::fmt::Debug for StartSchemaExtensionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartSchemaExtensionOutput");
        formatter.field("schema_extension_id", &self.schema_extension_id);
        formatter.finish()
    }
}
/// See [`StartSchemaExtensionOutput`](crate::output::StartSchemaExtensionOutput)
pub mod start_schema_extension_output {
    /// A builder for [`StartSchemaExtensionOutput`](crate::output::StartSchemaExtensionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_extension_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the schema extension that will be applied.</p>
        pub fn schema_extension_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_extension_id = Some(input.into());
            self
        }
        /// <p>The identifier of the schema extension that will be applied.</p>
        pub fn set_schema_extension_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_extension_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartSchemaExtensionOutput`](crate::output::StartSchemaExtensionOutput)
        pub fn build(self) -> crate::output::StartSchemaExtensionOutput {
            crate::output::StartSchemaExtensionOutput {
                schema_extension_id: self.schema_extension_id,
            }
        }
    }
}
impl StartSchemaExtensionOutput {
    /// Creates a new builder-style object to manufacture [`StartSchemaExtensionOutput`](crate::output::StartSchemaExtensionOutput)
    pub fn builder() -> crate::output::start_schema_extension_output::Builder {
        crate::output::start_schema_extension_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ShareDirectoryOutput {
    /// <p>Identifier of the directory that is stored in the directory consumer account that is
    /// shared from the specified directory (<code>DirectoryId</code>).</p>
    pub shared_directory_id: std::option::Option<std::string::String>,
}
impl ShareDirectoryOutput {
    /// <p>Identifier of the directory that is stored in the directory consumer account that is
    /// shared from the specified directory (<code>DirectoryId</code>).</p>
    pub fn shared_directory_id(&self) -> std::option::Option<&str> {
        self.shared_directory_id.as_deref()
    }
}
impl std::fmt::Debug for ShareDirectoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ShareDirectoryOutput");
        formatter.field("shared_directory_id", &self.shared_directory_id);
        formatter.finish()
    }
}
/// See [`ShareDirectoryOutput`](crate::output::ShareDirectoryOutput)
pub mod share_directory_output {
    /// A builder for [`ShareDirectoryOutput`](crate::output::ShareDirectoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) shared_directory_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Identifier of the directory that is stored in the directory consumer account that is
        /// shared from the specified directory (<code>DirectoryId</code>).</p>
        pub fn shared_directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.shared_directory_id = Some(input.into());
            self
        }
        /// <p>Identifier of the directory that is stored in the directory consumer account that is
        /// shared from the specified directory (<code>DirectoryId</code>).</p>
        pub fn set_shared_directory_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.shared_directory_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ShareDirectoryOutput`](crate::output::ShareDirectoryOutput)
        pub fn build(self) -> crate::output::ShareDirectoryOutput {
            crate::output::ShareDirectoryOutput {
                shared_directory_id: self.shared_directory_id,
            }
        }
    }
}
impl ShareDirectoryOutput {
    /// Creates a new builder-style object to manufacture [`ShareDirectoryOutput`](crate::output::ShareDirectoryOutput)
    pub fn builder() -> crate::output::share_directory_output::Builder {
        crate::output::share_directory_output::Builder::default()
    }
}

/// <p>Contains the results of the <a>RestoreFromSnapshot</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreFromSnapshotOutput {}
impl std::fmt::Debug for RestoreFromSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreFromSnapshotOutput");
        formatter.finish()
    }
}
/// See [`RestoreFromSnapshotOutput`](crate::output::RestoreFromSnapshotOutput)
pub mod restore_from_snapshot_output {
    /// A builder for [`RestoreFromSnapshotOutput`](crate::output::RestoreFromSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RestoreFromSnapshotOutput`](crate::output::RestoreFromSnapshotOutput)
        pub fn build(self) -> crate::output::RestoreFromSnapshotOutput {
            crate::output::RestoreFromSnapshotOutput {}
        }
    }
}
impl RestoreFromSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`RestoreFromSnapshotOutput`](crate::output::RestoreFromSnapshotOutput)
    pub fn builder() -> crate::output::restore_from_snapshot_output::Builder {
        crate::output::restore_from_snapshot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResetUserPasswordOutput {}
impl std::fmt::Debug for ResetUserPasswordOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResetUserPasswordOutput");
        formatter.finish()
    }
}
/// See [`ResetUserPasswordOutput`](crate::output::ResetUserPasswordOutput)
pub mod reset_user_password_output {
    /// A builder for [`ResetUserPasswordOutput`](crate::output::ResetUserPasswordOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ResetUserPasswordOutput`](crate::output::ResetUserPasswordOutput)
        pub fn build(self) -> crate::output::ResetUserPasswordOutput {
            crate::output::ResetUserPasswordOutput {}
        }
    }
}
impl ResetUserPasswordOutput {
    /// Creates a new builder-style object to manufacture [`ResetUserPasswordOutput`](crate::output::ResetUserPasswordOutput)
    pub fn builder() -> crate::output::reset_user_password_output::Builder {
        crate::output::reset_user_password_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTagsFromResourceOutput {}
impl std::fmt::Debug for RemoveTagsFromResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTagsFromResourceOutput");
        formatter.finish()
    }
}
/// See [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)
pub mod remove_tags_from_resource_output {
    /// A builder for [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)
        pub fn build(self) -> crate::output::RemoveTagsFromResourceOutput {
            crate::output::RemoveTagsFromResourceOutput {}
        }
    }
}
impl RemoveTagsFromResourceOutput {
    /// Creates a new builder-style object to manufacture [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)
    pub fn builder() -> crate::output::remove_tags_from_resource_output::Builder {
        crate::output::remove_tags_from_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveRegionOutput {}
impl std::fmt::Debug for RemoveRegionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveRegionOutput");
        formatter.finish()
    }
}
/// See [`RemoveRegionOutput`](crate::output::RemoveRegionOutput)
pub mod remove_region_output {
    /// A builder for [`RemoveRegionOutput`](crate::output::RemoveRegionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemoveRegionOutput`](crate::output::RemoveRegionOutput)
        pub fn build(self) -> crate::output::RemoveRegionOutput {
            crate::output::RemoveRegionOutput {}
        }
    }
}
impl RemoveRegionOutput {
    /// Creates a new builder-style object to manufacture [`RemoveRegionOutput`](crate::output::RemoveRegionOutput)
    pub fn builder() -> crate::output::remove_region_output::Builder {
        crate::output::remove_region_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveIpRoutesOutput {}
impl std::fmt::Debug for RemoveIpRoutesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveIpRoutesOutput");
        formatter.finish()
    }
}
/// See [`RemoveIpRoutesOutput`](crate::output::RemoveIpRoutesOutput)
pub mod remove_ip_routes_output {
    /// A builder for [`RemoveIpRoutesOutput`](crate::output::RemoveIpRoutesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemoveIpRoutesOutput`](crate::output::RemoveIpRoutesOutput)
        pub fn build(self) -> crate::output::RemoveIpRoutesOutput {
            crate::output::RemoveIpRoutesOutput {}
        }
    }
}
impl RemoveIpRoutesOutput {
    /// Creates a new builder-style object to manufacture [`RemoveIpRoutesOutput`](crate::output::RemoveIpRoutesOutput)
    pub fn builder() -> crate::output::remove_ip_routes_output::Builder {
        crate::output::remove_ip_routes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RejectSharedDirectoryOutput {
    /// <p>Identifier of the shared directory in the directory consumer account.</p>
    pub shared_directory_id: std::option::Option<std::string::String>,
}
impl RejectSharedDirectoryOutput {
    /// <p>Identifier of the shared directory in the directory consumer account.</p>
    pub fn shared_directory_id(&self) -> std::option::Option<&str> {
        self.shared_directory_id.as_deref()
    }
}
impl std::fmt::Debug for RejectSharedDirectoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RejectSharedDirectoryOutput");
        formatter.field("shared_directory_id", &self.shared_directory_id);
        formatter.finish()
    }
}
/// See [`RejectSharedDirectoryOutput`](crate::output::RejectSharedDirectoryOutput)
pub mod reject_shared_directory_output {
    /// A builder for [`RejectSharedDirectoryOutput`](crate::output::RejectSharedDirectoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) shared_directory_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Identifier of the shared directory in the directory consumer account.</p>
        pub fn shared_directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.shared_directory_id = Some(input.into());
            self
        }
        /// <p>Identifier of the shared directory in the directory consumer account.</p>
        pub fn set_shared_directory_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.shared_directory_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RejectSharedDirectoryOutput`](crate::output::RejectSharedDirectoryOutput)
        pub fn build(self) -> crate::output::RejectSharedDirectoryOutput {
            crate::output::RejectSharedDirectoryOutput {
                shared_directory_id: self.shared_directory_id,
            }
        }
    }
}
impl RejectSharedDirectoryOutput {
    /// Creates a new builder-style object to manufacture [`RejectSharedDirectoryOutput`](crate::output::RejectSharedDirectoryOutput)
    pub fn builder() -> crate::output::reject_shared_directory_output::Builder {
        crate::output::reject_shared_directory_output::Builder::default()
    }
}

/// <p>The result of a RegisterEventTopic request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterEventTopicOutput {}
impl std::fmt::Debug for RegisterEventTopicOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterEventTopicOutput");
        formatter.finish()
    }
}
/// See [`RegisterEventTopicOutput`](crate::output::RegisterEventTopicOutput)
pub mod register_event_topic_output {
    /// A builder for [`RegisterEventTopicOutput`](crate::output::RegisterEventTopicOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RegisterEventTopicOutput`](crate::output::RegisterEventTopicOutput)
        pub fn build(self) -> crate::output::RegisterEventTopicOutput {
            crate::output::RegisterEventTopicOutput {}
        }
    }
}
impl RegisterEventTopicOutput {
    /// Creates a new builder-style object to manufacture [`RegisterEventTopicOutput`](crate::output::RegisterEventTopicOutput)
    pub fn builder() -> crate::output::register_event_topic_output::Builder {
        crate::output::register_event_topic_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterCertificateOutput {
    /// <p>The identifier of the certificate.</p>
    pub certificate_id: std::option::Option<std::string::String>,
}
impl RegisterCertificateOutput {
    /// <p>The identifier of the certificate.</p>
    pub fn certificate_id(&self) -> std::option::Option<&str> {
        self.certificate_id.as_deref()
    }
}
impl std::fmt::Debug for RegisterCertificateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterCertificateOutput");
        formatter.field("certificate_id", &self.certificate_id);
        formatter.finish()
    }
}
/// See [`RegisterCertificateOutput`](crate::output::RegisterCertificateOutput)
pub mod register_certificate_output {
    /// A builder for [`RegisterCertificateOutput`](crate::output::RegisterCertificateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the certificate.</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_id = Some(input.into());
            self
        }
        /// <p>The identifier of the certificate.</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterCertificateOutput`](crate::output::RegisterCertificateOutput)
        pub fn build(self) -> crate::output::RegisterCertificateOutput {
            crate::output::RegisterCertificateOutput {
                certificate_id: self.certificate_id,
            }
        }
    }
}
impl RegisterCertificateOutput {
    /// Creates a new builder-style object to manufacture [`RegisterCertificateOutput`](crate::output::RegisterCertificateOutput)
    pub fn builder() -> crate::output::register_certificate_output::Builder {
        crate::output::register_certificate_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>List of tags returned by the ListTagsForResource operation.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Reserved for future use.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsForResourceOutput {
    /// <p>List of tags returned by the ListTagsForResource operation.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>Reserved for future use.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>List of tags returned by the ListTagsForResource operation.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>List of tags returned by the ListTagsForResource operation.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                tags: self.tags,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSchemaExtensionsOutput {
    /// <p>Information about the schema extensions applied to the directory.</p>
    pub schema_extensions_info:
        std::option::Option<std::vec::Vec<crate::model::SchemaExtensionInfo>>,
    /// <p>If not null, more results are available. Pass this value for the <code>NextToken</code>
    /// parameter in a subsequent call to <code>ListSchemaExtensions</code> to retrieve the next set
    /// of items.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListSchemaExtensionsOutput {
    /// <p>Information about the schema extensions applied to the directory.</p>
    pub fn schema_extensions_info(
        &self,
    ) -> std::option::Option<&[crate::model::SchemaExtensionInfo]> {
        self.schema_extensions_info.as_deref()
    }
    /// <p>If not null, more results are available. Pass this value for the <code>NextToken</code>
    /// parameter in a subsequent call to <code>ListSchemaExtensions</code> to retrieve the next set
    /// of items.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListSchemaExtensionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSchemaExtensionsOutput");
        formatter.field("schema_extensions_info", &self.schema_extensions_info);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListSchemaExtensionsOutput`](crate::output::ListSchemaExtensionsOutput)
pub mod list_schema_extensions_output {
    /// A builder for [`ListSchemaExtensionsOutput`](crate::output::ListSchemaExtensionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_extensions_info:
            std::option::Option<std::vec::Vec<crate::model::SchemaExtensionInfo>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `schema_extensions_info`.
        ///
        /// To override the contents of this collection use [`set_schema_extensions_info`](Self::set_schema_extensions_info).
        ///
        /// <p>Information about the schema extensions applied to the directory.</p>
        pub fn schema_extensions_info(
            mut self,
            input: impl Into<crate::model::SchemaExtensionInfo>,
        ) -> Self {
            let mut v = self.schema_extensions_info.unwrap_or_default();
            v.push(input.into());
            self.schema_extensions_info = Some(v);
            self
        }
        /// <p>Information about the schema extensions applied to the directory.</p>
        pub fn set_schema_extensions_info(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SchemaExtensionInfo>>,
        ) -> Self {
            self.schema_extensions_info = input;
            self
        }
        /// <p>If not null, more results are available. Pass this value for the <code>NextToken</code>
        /// parameter in a subsequent call to <code>ListSchemaExtensions</code> to retrieve the next set
        /// of items.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If not null, more results are available. Pass this value for the <code>NextToken</code>
        /// parameter in a subsequent call to <code>ListSchemaExtensions</code> to retrieve the next set
        /// of items.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSchemaExtensionsOutput`](crate::output::ListSchemaExtensionsOutput)
        pub fn build(self) -> crate::output::ListSchemaExtensionsOutput {
            crate::output::ListSchemaExtensionsOutput {
                schema_extensions_info: self.schema_extensions_info,
                next_token: self.next_token,
            }
        }
    }
}
impl ListSchemaExtensionsOutput {
    /// Creates a new builder-style object to manufacture [`ListSchemaExtensionsOutput`](crate::output::ListSchemaExtensionsOutput)
    pub fn builder() -> crate::output::list_schema_extensions_output::Builder {
        crate::output::list_schema_extensions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLogSubscriptionsOutput {
    /// <p>A list of active <a>LogSubscription</a> objects for calling the Amazon Web Services account.</p>
    pub log_subscriptions: std::option::Option<std::vec::Vec<crate::model::LogSubscription>>,
    /// <p>The token for the next set of items to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListLogSubscriptionsOutput {
    /// <p>A list of active <a>LogSubscription</a> objects for calling the Amazon Web Services account.</p>
    pub fn log_subscriptions(&self) -> std::option::Option<&[crate::model::LogSubscription]> {
        self.log_subscriptions.as_deref()
    }
    /// <p>The token for the next set of items to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListLogSubscriptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLogSubscriptionsOutput");
        formatter.field("log_subscriptions", &self.log_subscriptions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListLogSubscriptionsOutput`](crate::output::ListLogSubscriptionsOutput)
pub mod list_log_subscriptions_output {
    /// A builder for [`ListLogSubscriptionsOutput`](crate::output::ListLogSubscriptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_subscriptions:
            std::option::Option<std::vec::Vec<crate::model::LogSubscription>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `log_subscriptions`.
        ///
        /// To override the contents of this collection use [`set_log_subscriptions`](Self::set_log_subscriptions).
        ///
        /// <p>A list of active <a>LogSubscription</a> objects for calling the Amazon Web Services account.</p>
        pub fn log_subscriptions(
            mut self,
            input: impl Into<crate::model::LogSubscription>,
        ) -> Self {
            let mut v = self.log_subscriptions.unwrap_or_default();
            v.push(input.into());
            self.log_subscriptions = Some(v);
            self
        }
        /// <p>A list of active <a>LogSubscription</a> objects for calling the Amazon Web Services account.</p>
        pub fn set_log_subscriptions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LogSubscription>>,
        ) -> Self {
            self.log_subscriptions = input;
            self
        }
        /// <p>The token for the next set of items to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLogSubscriptionsOutput`](crate::output::ListLogSubscriptionsOutput)
        pub fn build(self) -> crate::output::ListLogSubscriptionsOutput {
            crate::output::ListLogSubscriptionsOutput {
                log_subscriptions: self.log_subscriptions,
                next_token: self.next_token,
            }
        }
    }
}
impl ListLogSubscriptionsOutput {
    /// Creates a new builder-style object to manufacture [`ListLogSubscriptionsOutput`](crate::output::ListLogSubscriptionsOutput)
    pub fn builder() -> crate::output::list_log_subscriptions_output::Builder {
        crate::output::list_log_subscriptions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListIpRoutesOutput {
    /// <p>A list of <a>IpRoute</a>s.</p>
    pub ip_routes_info: std::option::Option<std::vec::Vec<crate::model::IpRouteInfo>>,
    /// <p>If not null, more results are available. Pass this value for the
    /// <i>NextToken</i> parameter in a subsequent call to <a>ListIpRoutes</a> to retrieve the next set of items.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListIpRoutesOutput {
    /// <p>A list of <a>IpRoute</a>s.</p>
    pub fn ip_routes_info(&self) -> std::option::Option<&[crate::model::IpRouteInfo]> {
        self.ip_routes_info.as_deref()
    }
    /// <p>If not null, more results are available. Pass this value for the
    /// <i>NextToken</i> parameter in a subsequent call to <a>ListIpRoutes</a> to retrieve the next set of items.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListIpRoutesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListIpRoutesOutput");
        formatter.field("ip_routes_info", &self.ip_routes_info);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListIpRoutesOutput`](crate::output::ListIpRoutesOutput)
pub mod list_ip_routes_output {
    /// A builder for [`ListIpRoutesOutput`](crate::output::ListIpRoutesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ip_routes_info: std::option::Option<std::vec::Vec<crate::model::IpRouteInfo>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `ip_routes_info`.
        ///
        /// To override the contents of this collection use [`set_ip_routes_info`](Self::set_ip_routes_info).
        ///
        /// <p>A list of <a>IpRoute</a>s.</p>
        pub fn ip_routes_info(mut self, input: impl Into<crate::model::IpRouteInfo>) -> Self {
            let mut v = self.ip_routes_info.unwrap_or_default();
            v.push(input.into());
            self.ip_routes_info = Some(v);
            self
        }
        /// <p>A list of <a>IpRoute</a>s.</p>
        pub fn set_ip_routes_info(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpRouteInfo>>,
        ) -> Self {
            self.ip_routes_info = input;
            self
        }
        /// <p>If not null, more results are available. Pass this value for the
        /// <i>NextToken</i> parameter in a subsequent call to <a>ListIpRoutes</a> to retrieve the next set of items.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If not null, more results are available. Pass this value for the
        /// <i>NextToken</i> parameter in a subsequent call to <a>ListIpRoutes</a> to retrieve the next set of items.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIpRoutesOutput`](crate::output::ListIpRoutesOutput)
        pub fn build(self) -> crate::output::ListIpRoutesOutput {
            crate::output::ListIpRoutesOutput {
                ip_routes_info: self.ip_routes_info,
                next_token: self.next_token,
            }
        }
    }
}
impl ListIpRoutesOutput {
    /// Creates a new builder-style object to manufacture [`ListIpRoutesOutput`](crate::output::ListIpRoutesOutput)
    pub fn builder() -> crate::output::list_ip_routes_output::Builder {
        crate::output::list_ip_routes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCertificatesOutput {
    /// <p>Indicates whether another page of certificates is available when the number of available
    /// certificates exceeds the page limit.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of certificates with basic details including certificate ID, certificate common
    /// name, certificate state.</p>
    pub certificates_info: std::option::Option<std::vec::Vec<crate::model::CertificateInfo>>,
}
impl ListCertificatesOutput {
    /// <p>Indicates whether another page of certificates is available when the number of available
    /// certificates exceeds the page limit.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A list of certificates with basic details including certificate ID, certificate common
    /// name, certificate state.</p>
    pub fn certificates_info(&self) -> std::option::Option<&[crate::model::CertificateInfo]> {
        self.certificates_info.as_deref()
    }
}
impl std::fmt::Debug for ListCertificatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCertificatesOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("certificates_info", &self.certificates_info);
        formatter.finish()
    }
}
/// See [`ListCertificatesOutput`](crate::output::ListCertificatesOutput)
pub mod list_certificates_output {
    /// A builder for [`ListCertificatesOutput`](crate::output::ListCertificatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) certificates_info:
            std::option::Option<std::vec::Vec<crate::model::CertificateInfo>>,
    }
    impl Builder {
        /// <p>Indicates whether another page of certificates is available when the number of available
        /// certificates exceeds the page limit.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Indicates whether another page of certificates is available when the number of available
        /// certificates exceeds the page limit.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `certificates_info`.
        ///
        /// To override the contents of this collection use [`set_certificates_info`](Self::set_certificates_info).
        ///
        /// <p>A list of certificates with basic details including certificate ID, certificate common
        /// name, certificate state.</p>
        pub fn certificates_info(
            mut self,
            input: impl Into<crate::model::CertificateInfo>,
        ) -> Self {
            let mut v = self.certificates_info.unwrap_or_default();
            v.push(input.into());
            self.certificates_info = Some(v);
            self
        }
        /// <p>A list of certificates with basic details including certificate ID, certificate common
        /// name, certificate state.</p>
        pub fn set_certificates_info(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CertificateInfo>>,
        ) -> Self {
            self.certificates_info = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCertificatesOutput`](crate::output::ListCertificatesOutput)
        pub fn build(self) -> crate::output::ListCertificatesOutput {
            crate::output::ListCertificatesOutput {
                next_token: self.next_token,
                certificates_info: self.certificates_info,
            }
        }
    }
}
impl ListCertificatesOutput {
    /// Creates a new builder-style object to manufacture [`ListCertificatesOutput`](crate::output::ListCertificatesOutput)
    pub fn builder() -> crate::output::list_certificates_output::Builder {
        crate::output::list_certificates_output::Builder::default()
    }
}

/// <p>Contains the results of the <a>GetSnapshotLimits</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSnapshotLimitsOutput {
    /// <p>A <a>SnapshotLimits</a> object that contains the manual snapshot limits for the specified
    /// directory.</p>
    pub snapshot_limits: std::option::Option<crate::model::SnapshotLimits>,
}
impl GetSnapshotLimitsOutput {
    /// <p>A <a>SnapshotLimits</a> object that contains the manual snapshot limits for the specified
    /// directory.</p>
    pub fn snapshot_limits(&self) -> std::option::Option<&crate::model::SnapshotLimits> {
        self.snapshot_limits.as_ref()
    }
}
impl std::fmt::Debug for GetSnapshotLimitsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSnapshotLimitsOutput");
        formatter.field("snapshot_limits", &self.snapshot_limits);
        formatter.finish()
    }
}
/// See [`GetSnapshotLimitsOutput`](crate::output::GetSnapshotLimitsOutput)
pub mod get_snapshot_limits_output {
    /// A builder for [`GetSnapshotLimitsOutput`](crate::output::GetSnapshotLimitsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot_limits: std::option::Option<crate::model::SnapshotLimits>,
    }
    impl Builder {
        /// <p>A <a>SnapshotLimits</a> object that contains the manual snapshot limits for the specified
        /// directory.</p>
        pub fn snapshot_limits(mut self, input: crate::model::SnapshotLimits) -> Self {
            self.snapshot_limits = Some(input);
            self
        }
        /// <p>A <a>SnapshotLimits</a> object that contains the manual snapshot limits for the specified
        /// directory.</p>
        pub fn set_snapshot_limits(
            mut self,
            input: std::option::Option<crate::model::SnapshotLimits>,
        ) -> Self {
            self.snapshot_limits = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSnapshotLimitsOutput`](crate::output::GetSnapshotLimitsOutput)
        pub fn build(self) -> crate::output::GetSnapshotLimitsOutput {
            crate::output::GetSnapshotLimitsOutput {
                snapshot_limits: self.snapshot_limits,
            }
        }
    }
}
impl GetSnapshotLimitsOutput {
    /// Creates a new builder-style object to manufacture [`GetSnapshotLimitsOutput`](crate::output::GetSnapshotLimitsOutput)
    pub fn builder() -> crate::output::get_snapshot_limits_output::Builder {
        crate::output::get_snapshot_limits_output::Builder::default()
    }
}

/// <p>Contains the results of the <a>GetDirectoryLimits</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDirectoryLimitsOutput {
    /// <p>A <a>DirectoryLimits</a> object that contains the directory limits for the
    /// current Region.</p>
    pub directory_limits: std::option::Option<crate::model::DirectoryLimits>,
}
impl GetDirectoryLimitsOutput {
    /// <p>A <a>DirectoryLimits</a> object that contains the directory limits for the
    /// current Region.</p>
    pub fn directory_limits(&self) -> std::option::Option<&crate::model::DirectoryLimits> {
        self.directory_limits.as_ref()
    }
}
impl std::fmt::Debug for GetDirectoryLimitsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDirectoryLimitsOutput");
        formatter.field("directory_limits", &self.directory_limits);
        formatter.finish()
    }
}
/// See [`GetDirectoryLimitsOutput`](crate::output::GetDirectoryLimitsOutput)
pub mod get_directory_limits_output {
    /// A builder for [`GetDirectoryLimitsOutput`](crate::output::GetDirectoryLimitsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_limits: std::option::Option<crate::model::DirectoryLimits>,
    }
    impl Builder {
        /// <p>A <a>DirectoryLimits</a> object that contains the directory limits for the
        /// current Region.</p>
        pub fn directory_limits(mut self, input: crate::model::DirectoryLimits) -> Self {
            self.directory_limits = Some(input);
            self
        }
        /// <p>A <a>DirectoryLimits</a> object that contains the directory limits for the
        /// current Region.</p>
        pub fn set_directory_limits(
            mut self,
            input: std::option::Option<crate::model::DirectoryLimits>,
        ) -> Self {
            self.directory_limits = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDirectoryLimitsOutput`](crate::output::GetDirectoryLimitsOutput)
        pub fn build(self) -> crate::output::GetDirectoryLimitsOutput {
            crate::output::GetDirectoryLimitsOutput {
                directory_limits: self.directory_limits,
            }
        }
    }
}
impl GetDirectoryLimitsOutput {
    /// Creates a new builder-style object to manufacture [`GetDirectoryLimitsOutput`](crate::output::GetDirectoryLimitsOutput)
    pub fn builder() -> crate::output::get_directory_limits_output::Builder {
        crate::output::get_directory_limits_output::Builder::default()
    }
}

/// <p>Contains the results of the <a>EnableSso</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableSsoOutput {}
impl std::fmt::Debug for EnableSsoOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableSsoOutput");
        formatter.finish()
    }
}
/// See [`EnableSsoOutput`](crate::output::EnableSsoOutput)
pub mod enable_sso_output {
    /// A builder for [`EnableSsoOutput`](crate::output::EnableSsoOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`EnableSsoOutput`](crate::output::EnableSsoOutput)
        pub fn build(self) -> crate::output::EnableSsoOutput {
            crate::output::EnableSsoOutput {}
        }
    }
}
impl EnableSsoOutput {
    /// Creates a new builder-style object to manufacture [`EnableSsoOutput`](crate::output::EnableSsoOutput)
    pub fn builder() -> crate::output::enable_sso_output::Builder {
        crate::output::enable_sso_output::Builder::default()
    }
}

/// <p>Contains the results of the <a>EnableRadius</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableRadiusOutput {}
impl std::fmt::Debug for EnableRadiusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableRadiusOutput");
        formatter.finish()
    }
}
/// See [`EnableRadiusOutput`](crate::output::EnableRadiusOutput)
pub mod enable_radius_output {
    /// A builder for [`EnableRadiusOutput`](crate::output::EnableRadiusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`EnableRadiusOutput`](crate::output::EnableRadiusOutput)
        pub fn build(self) -> crate::output::EnableRadiusOutput {
            crate::output::EnableRadiusOutput {}
        }
    }
}
impl EnableRadiusOutput {
    /// Creates a new builder-style object to manufacture [`EnableRadiusOutput`](crate::output::EnableRadiusOutput)
    pub fn builder() -> crate::output::enable_radius_output::Builder {
        crate::output::enable_radius_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableLdapsOutput {}
impl std::fmt::Debug for EnableLdapsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableLdapsOutput");
        formatter.finish()
    }
}
/// See [`EnableLdapsOutput`](crate::output::EnableLdapsOutput)
pub mod enable_ldaps_output {
    /// A builder for [`EnableLdapsOutput`](crate::output::EnableLdapsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`EnableLdapsOutput`](crate::output::EnableLdapsOutput)
        pub fn build(self) -> crate::output::EnableLdapsOutput {
            crate::output::EnableLdapsOutput {}
        }
    }
}
impl EnableLdapsOutput {
    /// Creates a new builder-style object to manufacture [`EnableLdapsOutput`](crate::output::EnableLdapsOutput)
    pub fn builder() -> crate::output::enable_ldaps_output::Builder {
        crate::output::enable_ldaps_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableClientAuthenticationOutput {}
impl std::fmt::Debug for EnableClientAuthenticationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableClientAuthenticationOutput");
        formatter.finish()
    }
}
/// See [`EnableClientAuthenticationOutput`](crate::output::EnableClientAuthenticationOutput)
pub mod enable_client_authentication_output {
    /// A builder for [`EnableClientAuthenticationOutput`](crate::output::EnableClientAuthenticationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`EnableClientAuthenticationOutput`](crate::output::EnableClientAuthenticationOutput)
        pub fn build(self) -> crate::output::EnableClientAuthenticationOutput {
            crate::output::EnableClientAuthenticationOutput {}
        }
    }
}
impl EnableClientAuthenticationOutput {
    /// Creates a new builder-style object to manufacture [`EnableClientAuthenticationOutput`](crate::output::EnableClientAuthenticationOutput)
    pub fn builder() -> crate::output::enable_client_authentication_output::Builder {
        crate::output::enable_client_authentication_output::Builder::default()
    }
}

/// <p>Contains the results of the <a>DisableSso</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableSsoOutput {}
impl std::fmt::Debug for DisableSsoOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableSsoOutput");
        formatter.finish()
    }
}
/// See [`DisableSsoOutput`](crate::output::DisableSsoOutput)
pub mod disable_sso_output {
    /// A builder for [`DisableSsoOutput`](crate::output::DisableSsoOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisableSsoOutput`](crate::output::DisableSsoOutput)
        pub fn build(self) -> crate::output::DisableSsoOutput {
            crate::output::DisableSsoOutput {}
        }
    }
}
impl DisableSsoOutput {
    /// Creates a new builder-style object to manufacture [`DisableSsoOutput`](crate::output::DisableSsoOutput)
    pub fn builder() -> crate::output::disable_sso_output::Builder {
        crate::output::disable_sso_output::Builder::default()
    }
}

/// <p>Contains the results of the <a>DisableRadius</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableRadiusOutput {}
impl std::fmt::Debug for DisableRadiusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableRadiusOutput");
        formatter.finish()
    }
}
/// See [`DisableRadiusOutput`](crate::output::DisableRadiusOutput)
pub mod disable_radius_output {
    /// A builder for [`DisableRadiusOutput`](crate::output::DisableRadiusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisableRadiusOutput`](crate::output::DisableRadiusOutput)
        pub fn build(self) -> crate::output::DisableRadiusOutput {
            crate::output::DisableRadiusOutput {}
        }
    }
}
impl DisableRadiusOutput {
    /// Creates a new builder-style object to manufacture [`DisableRadiusOutput`](crate::output::DisableRadiusOutput)
    pub fn builder() -> crate::output::disable_radius_output::Builder {
        crate::output::disable_radius_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableLdapsOutput {}
impl std::fmt::Debug for DisableLdapsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableLdapsOutput");
        formatter.finish()
    }
}
/// See [`DisableLdapsOutput`](crate::output::DisableLdapsOutput)
pub mod disable_ldaps_output {
    /// A builder for [`DisableLdapsOutput`](crate::output::DisableLdapsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisableLdapsOutput`](crate::output::DisableLdapsOutput)
        pub fn build(self) -> crate::output::DisableLdapsOutput {
            crate::output::DisableLdapsOutput {}
        }
    }
}
impl DisableLdapsOutput {
    /// Creates a new builder-style object to manufacture [`DisableLdapsOutput`](crate::output::DisableLdapsOutput)
    pub fn builder() -> crate::output::disable_ldaps_output::Builder {
        crate::output::disable_ldaps_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableClientAuthenticationOutput {}
impl std::fmt::Debug for DisableClientAuthenticationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableClientAuthenticationOutput");
        formatter.finish()
    }
}
/// See [`DisableClientAuthenticationOutput`](crate::output::DisableClientAuthenticationOutput)
pub mod disable_client_authentication_output {
    /// A builder for [`DisableClientAuthenticationOutput`](crate::output::DisableClientAuthenticationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisableClientAuthenticationOutput`](crate::output::DisableClientAuthenticationOutput)
        pub fn build(self) -> crate::output::DisableClientAuthenticationOutput {
            crate::output::DisableClientAuthenticationOutput {}
        }
    }
}
impl DisableClientAuthenticationOutput {
    /// Creates a new builder-style object to manufacture [`DisableClientAuthenticationOutput`](crate::output::DisableClientAuthenticationOutput)
    pub fn builder() -> crate::output::disable_client_authentication_output::Builder {
        crate::output::disable_client_authentication_output::Builder::default()
    }
}

/// <p>The result of a DescribeTrust request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTrustsOutput {
    /// <p>The list of Trust objects that were retrieved.</p>
    /// <p>It is possible that this list contains less than the number of items specified in the
    /// <i>Limit</i> member of the request. This occurs if there are less than the
    /// requested number of items left to retrieve, or if the limitations of the operation have been
    /// exceeded.</p>
    pub trusts: std::option::Option<std::vec::Vec<crate::model::Trust>>,
    /// <p>If not null, more results are available. Pass this value for the
    /// <i>NextToken</i> parameter in a subsequent call to <a>DescribeTrusts</a> to retrieve the next set of items.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeTrustsOutput {
    /// <p>The list of Trust objects that were retrieved.</p>
    /// <p>It is possible that this list contains less than the number of items specified in the
    /// <i>Limit</i> member of the request. This occurs if there are less than the
    /// requested number of items left to retrieve, or if the limitations of the operation have been
    /// exceeded.</p>
    pub fn trusts(&self) -> std::option::Option<&[crate::model::Trust]> {
        self.trusts.as_deref()
    }
    /// <p>If not null, more results are available. Pass this value for the
    /// <i>NextToken</i> parameter in a subsequent call to <a>DescribeTrusts</a> to retrieve the next set of items.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeTrustsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTrustsOutput");
        formatter.field("trusts", &self.trusts);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeTrustsOutput`](crate::output::DescribeTrustsOutput)
pub mod describe_trusts_output {
    /// A builder for [`DescribeTrustsOutput`](crate::output::DescribeTrustsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trusts: std::option::Option<std::vec::Vec<crate::model::Trust>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `trusts`.
        ///
        /// To override the contents of this collection use [`set_trusts`](Self::set_trusts).
        ///
        /// <p>The list of Trust objects that were retrieved.</p>
        /// <p>It is possible that this list contains less than the number of items specified in the
        /// <i>Limit</i> member of the request. This occurs if there are less than the
        /// requested number of items left to retrieve, or if the limitations of the operation have been
        /// exceeded.</p>
        pub fn trusts(mut self, input: impl Into<crate::model::Trust>) -> Self {
            let mut v = self.trusts.unwrap_or_default();
            v.push(input.into());
            self.trusts = Some(v);
            self
        }
        /// <p>The list of Trust objects that were retrieved.</p>
        /// <p>It is possible that this list contains less than the number of items specified in the
        /// <i>Limit</i> member of the request. This occurs if there are less than the
        /// requested number of items left to retrieve, or if the limitations of the operation have been
        /// exceeded.</p>
        pub fn set_trusts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Trust>>,
        ) -> Self {
            self.trusts = input;
            self
        }
        /// <p>If not null, more results are available. Pass this value for the
        /// <i>NextToken</i> parameter in a subsequent call to <a>DescribeTrusts</a> to retrieve the next set of items.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If not null, more results are available. Pass this value for the
        /// <i>NextToken</i> parameter in a subsequent call to <a>DescribeTrusts</a> to retrieve the next set of items.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTrustsOutput`](crate::output::DescribeTrustsOutput)
        pub fn build(self) -> crate::output::DescribeTrustsOutput {
            crate::output::DescribeTrustsOutput {
                trusts: self.trusts,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeTrustsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTrustsOutput`](crate::output::DescribeTrustsOutput)
    pub fn builder() -> crate::output::describe_trusts_output::Builder {
        crate::output::describe_trusts_output::Builder::default()
    }
}

/// <p>Contains the results of the <a>DescribeSnapshots</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSnapshotsOutput {
    /// <p>The list of <a>Snapshot</a> objects that were retrieved.</p>
    /// <p>It is possible that this list contains less than the number of items specified in the
    /// <i>Limit</i> member of the request. This occurs if there are less than the requested
    /// number of items left to retrieve, or if the limitations of the operation have been
    /// exceeded.</p>
    pub snapshots: std::option::Option<std::vec::Vec<crate::model::Snapshot>>,
    /// <p>If not null, more results are available. Pass this value in the <i>NextToken</i> member of
    /// a subsequent call to <a>DescribeSnapshots</a>.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeSnapshotsOutput {
    /// <p>The list of <a>Snapshot</a> objects that were retrieved.</p>
    /// <p>It is possible that this list contains less than the number of items specified in the
    /// <i>Limit</i> member of the request. This occurs if there are less than the requested
    /// number of items left to retrieve, or if the limitations of the operation have been
    /// exceeded.</p>
    pub fn snapshots(&self) -> std::option::Option<&[crate::model::Snapshot]> {
        self.snapshots.as_deref()
    }
    /// <p>If not null, more results are available. Pass this value in the <i>NextToken</i> member of
    /// a subsequent call to <a>DescribeSnapshots</a>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeSnapshotsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSnapshotsOutput");
        formatter.field("snapshots", &self.snapshots);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeSnapshotsOutput`](crate::output::DescribeSnapshotsOutput)
pub mod describe_snapshots_output {
    /// A builder for [`DescribeSnapshotsOutput`](crate::output::DescribeSnapshotsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshots: std::option::Option<std::vec::Vec<crate::model::Snapshot>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `snapshots`.
        ///
        /// To override the contents of this collection use [`set_snapshots`](Self::set_snapshots).
        ///
        /// <p>The list of <a>Snapshot</a> objects that were retrieved.</p>
        /// <p>It is possible that this list contains less than the number of items specified in the
        /// <i>Limit</i> member of the request. This occurs if there are less than the requested
        /// number of items left to retrieve, or if the limitations of the operation have been
        /// exceeded.</p>
        pub fn snapshots(mut self, input: impl Into<crate::model::Snapshot>) -> Self {
            let mut v = self.snapshots.unwrap_or_default();
            v.push(input.into());
            self.snapshots = Some(v);
            self
        }
        /// <p>The list of <a>Snapshot</a> objects that were retrieved.</p>
        /// <p>It is possible that this list contains less than the number of items specified in the
        /// <i>Limit</i> member of the request. This occurs if there are less than the requested
        /// number of items left to retrieve, or if the limitations of the operation have been
        /// exceeded.</p>
        pub fn set_snapshots(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Snapshot>>,
        ) -> Self {
            self.snapshots = input;
            self
        }
        /// <p>If not null, more results are available. Pass this value in the <i>NextToken</i> member of
        /// a subsequent call to <a>DescribeSnapshots</a>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If not null, more results are available. Pass this value in the <i>NextToken</i> member of
        /// a subsequent call to <a>DescribeSnapshots</a>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSnapshotsOutput`](crate::output::DescribeSnapshotsOutput)
        pub fn build(self) -> crate::output::DescribeSnapshotsOutput {
            crate::output::DescribeSnapshotsOutput {
                snapshots: self.snapshots,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeSnapshotsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSnapshotsOutput`](crate::output::DescribeSnapshotsOutput)
    pub fn builder() -> crate::output::describe_snapshots_output::Builder {
        crate::output::describe_snapshots_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSharedDirectoriesOutput {
    /// <p>A list of all shared directories in your account.</p>
    pub shared_directories: std::option::Option<std::vec::Vec<crate::model::SharedDirectory>>,
    /// <p>If not null, token that indicates that more results are available. Pass this value for the
    /// <code>NextToken</code> parameter in a subsequent call to <a>DescribeSharedDirectories</a> to retrieve the next set of items.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeSharedDirectoriesOutput {
    /// <p>A list of all shared directories in your account.</p>
    pub fn shared_directories(&self) -> std::option::Option<&[crate::model::SharedDirectory]> {
        self.shared_directories.as_deref()
    }
    /// <p>If not null, token that indicates that more results are available. Pass this value for the
    /// <code>NextToken</code> parameter in a subsequent call to <a>DescribeSharedDirectories</a> to retrieve the next set of items.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeSharedDirectoriesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSharedDirectoriesOutput");
        formatter.field("shared_directories", &self.shared_directories);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeSharedDirectoriesOutput`](crate::output::DescribeSharedDirectoriesOutput)
pub mod describe_shared_directories_output {
    /// A builder for [`DescribeSharedDirectoriesOutput`](crate::output::DescribeSharedDirectoriesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) shared_directories:
            std::option::Option<std::vec::Vec<crate::model::SharedDirectory>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `shared_directories`.
        ///
        /// To override the contents of this collection use [`set_shared_directories`](Self::set_shared_directories).
        ///
        /// <p>A list of all shared directories in your account.</p>
        pub fn shared_directories(
            mut self,
            input: impl Into<crate::model::SharedDirectory>,
        ) -> Self {
            let mut v = self.shared_directories.unwrap_or_default();
            v.push(input.into());
            self.shared_directories = Some(v);
            self
        }
        /// <p>A list of all shared directories in your account.</p>
        pub fn set_shared_directories(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SharedDirectory>>,
        ) -> Self {
            self.shared_directories = input;
            self
        }
        /// <p>If not null, token that indicates that more results are available. Pass this value for the
        /// <code>NextToken</code> parameter in a subsequent call to <a>DescribeSharedDirectories</a> to retrieve the next set of items.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If not null, token that indicates that more results are available. Pass this value for the
        /// <code>NextToken</code> parameter in a subsequent call to <a>DescribeSharedDirectories</a> to retrieve the next set of items.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSharedDirectoriesOutput`](crate::output::DescribeSharedDirectoriesOutput)
        pub fn build(self) -> crate::output::DescribeSharedDirectoriesOutput {
            crate::output::DescribeSharedDirectoriesOutput {
                shared_directories: self.shared_directories,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeSharedDirectoriesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSharedDirectoriesOutput`](crate::output::DescribeSharedDirectoriesOutput)
    pub fn builder() -> crate::output::describe_shared_directories_output::Builder {
        crate::output::describe_shared_directories_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRegionsOutput {
    /// <p>List of Region information related to the directory for each replicated Region.</p>
    pub regions_description: std::option::Option<std::vec::Vec<crate::model::RegionDescription>>,
    /// <p>If not null, more results are available. Pass this value for the <code>NextToken</code>
    /// parameter in a subsequent call to <a>DescribeRegions</a> to retrieve the next set
    /// of items.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeRegionsOutput {
    /// <p>List of Region information related to the directory for each replicated Region.</p>
    pub fn regions_description(&self) -> std::option::Option<&[crate::model::RegionDescription]> {
        self.regions_description.as_deref()
    }
    /// <p>If not null, more results are available. Pass this value for the <code>NextToken</code>
    /// parameter in a subsequent call to <a>DescribeRegions</a> to retrieve the next set
    /// of items.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeRegionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRegionsOutput");
        formatter.field("regions_description", &self.regions_description);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeRegionsOutput`](crate::output::DescribeRegionsOutput)
pub mod describe_regions_output {
    /// A builder for [`DescribeRegionsOutput`](crate::output::DescribeRegionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) regions_description:
            std::option::Option<std::vec::Vec<crate::model::RegionDescription>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `regions_description`.
        ///
        /// To override the contents of this collection use [`set_regions_description`](Self::set_regions_description).
        ///
        /// <p>List of Region information related to the directory for each replicated Region.</p>
        pub fn regions_description(
            mut self,
            input: impl Into<crate::model::RegionDescription>,
        ) -> Self {
            let mut v = self.regions_description.unwrap_or_default();
            v.push(input.into());
            self.regions_description = Some(v);
            self
        }
        /// <p>List of Region information related to the directory for each replicated Region.</p>
        pub fn set_regions_description(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RegionDescription>>,
        ) -> Self {
            self.regions_description = input;
            self
        }
        /// <p>If not null, more results are available. Pass this value for the <code>NextToken</code>
        /// parameter in a subsequent call to <a>DescribeRegions</a> to retrieve the next set
        /// of items.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If not null, more results are available. Pass this value for the <code>NextToken</code>
        /// parameter in a subsequent call to <a>DescribeRegions</a> to retrieve the next set
        /// of items.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRegionsOutput`](crate::output::DescribeRegionsOutput)
        pub fn build(self) -> crate::output::DescribeRegionsOutput {
            crate::output::DescribeRegionsOutput {
                regions_description: self.regions_description,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeRegionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeRegionsOutput`](crate::output::DescribeRegionsOutput)
    pub fn builder() -> crate::output::describe_regions_output::Builder {
        crate::output::describe_regions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLdapsSettingsOutput {
    /// <p>Information about LDAP security for the specified directory, including status of
    /// enablement, state last updated date time, and the reason for the state.</p>
    pub ldaps_settings_info: std::option::Option<std::vec::Vec<crate::model::LdapsSettingInfo>>,
    /// <p>The next token used to retrieve the LDAPS settings if the number of setting types exceeds
    /// page limit and there is another page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeLdapsSettingsOutput {
    /// <p>Information about LDAP security for the specified directory, including status of
    /// enablement, state last updated date time, and the reason for the state.</p>
    pub fn ldaps_settings_info(&self) -> std::option::Option<&[crate::model::LdapsSettingInfo]> {
        self.ldaps_settings_info.as_deref()
    }
    /// <p>The next token used to retrieve the LDAPS settings if the number of setting types exceeds
    /// page limit and there is another page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeLdapsSettingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLdapsSettingsOutput");
        formatter.field("ldaps_settings_info", &self.ldaps_settings_info);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeLdapsSettingsOutput`](crate::output::DescribeLdapsSettingsOutput)
pub mod describe_ldaps_settings_output {
    /// A builder for [`DescribeLdapsSettingsOutput`](crate::output::DescribeLdapsSettingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ldaps_settings_info:
            std::option::Option<std::vec::Vec<crate::model::LdapsSettingInfo>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `ldaps_settings_info`.
        ///
        /// To override the contents of this collection use [`set_ldaps_settings_info`](Self::set_ldaps_settings_info).
        ///
        /// <p>Information about LDAP security for the specified directory, including status of
        /// enablement, state last updated date time, and the reason for the state.</p>
        pub fn ldaps_settings_info(
            mut self,
            input: impl Into<crate::model::LdapsSettingInfo>,
        ) -> Self {
            let mut v = self.ldaps_settings_info.unwrap_or_default();
            v.push(input.into());
            self.ldaps_settings_info = Some(v);
            self
        }
        /// <p>Information about LDAP security for the specified directory, including status of
        /// enablement, state last updated date time, and the reason for the state.</p>
        pub fn set_ldaps_settings_info(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LdapsSettingInfo>>,
        ) -> Self {
            self.ldaps_settings_info = input;
            self
        }
        /// <p>The next token used to retrieve the LDAPS settings if the number of setting types exceeds
        /// page limit and there is another page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next token used to retrieve the LDAPS settings if the number of setting types exceeds
        /// page limit and there is another page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLdapsSettingsOutput`](crate::output::DescribeLdapsSettingsOutput)
        pub fn build(self) -> crate::output::DescribeLdapsSettingsOutput {
            crate::output::DescribeLdapsSettingsOutput {
                ldaps_settings_info: self.ldaps_settings_info,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeLdapsSettingsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeLdapsSettingsOutput`](crate::output::DescribeLdapsSettingsOutput)
    pub fn builder() -> crate::output::describe_ldaps_settings_output::Builder {
        crate::output::describe_ldaps_settings_output::Builder::default()
    }
}

/// <p>The result of a DescribeEventTopic request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventTopicsOutput {
    /// <p>A list of Amazon SNS topic names that receive status messages from the specified Directory
    /// ID.</p>
    pub event_topics: std::option::Option<std::vec::Vec<crate::model::EventTopic>>,
}
impl DescribeEventTopicsOutput {
    /// <p>A list of Amazon SNS topic names that receive status messages from the specified Directory
    /// ID.</p>
    pub fn event_topics(&self) -> std::option::Option<&[crate::model::EventTopic]> {
        self.event_topics.as_deref()
    }
}
impl std::fmt::Debug for DescribeEventTopicsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventTopicsOutput");
        formatter.field("event_topics", &self.event_topics);
        formatter.finish()
    }
}
/// See [`DescribeEventTopicsOutput`](crate::output::DescribeEventTopicsOutput)
pub mod describe_event_topics_output {
    /// A builder for [`DescribeEventTopicsOutput`](crate::output::DescribeEventTopicsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_topics: std::option::Option<std::vec::Vec<crate::model::EventTopic>>,
    }
    impl Builder {
        /// Appends an item to `event_topics`.
        ///
        /// To override the contents of this collection use [`set_event_topics`](Self::set_event_topics).
        ///
        /// <p>A list of Amazon SNS topic names that receive status messages from the specified Directory
        /// ID.</p>
        pub fn event_topics(mut self, input: impl Into<crate::model::EventTopic>) -> Self {
            let mut v = self.event_topics.unwrap_or_default();
            v.push(input.into());
            self.event_topics = Some(v);
            self
        }
        /// <p>A list of Amazon SNS topic names that receive status messages from the specified Directory
        /// ID.</p>
        pub fn set_event_topics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventTopic>>,
        ) -> Self {
            self.event_topics = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventTopicsOutput`](crate::output::DescribeEventTopicsOutput)
        pub fn build(self) -> crate::output::DescribeEventTopicsOutput {
            crate::output::DescribeEventTopicsOutput {
                event_topics: self.event_topics,
            }
        }
    }
}
impl DescribeEventTopicsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEventTopicsOutput`](crate::output::DescribeEventTopicsOutput)
    pub fn builder() -> crate::output::describe_event_topics_output::Builder {
        crate::output::describe_event_topics_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDomainControllersOutput {
    /// <p>List of the <a>DomainController</a> objects that were retrieved.</p>
    pub domain_controllers: std::option::Option<std::vec::Vec<crate::model::DomainController>>,
    /// <p>If not null, more results are available. Pass this value for the <code>NextToken</code>
    /// parameter in a subsequent call to <a>DescribeDomainControllers</a> retrieve the
    /// next set of items.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeDomainControllersOutput {
    /// <p>List of the <a>DomainController</a> objects that were retrieved.</p>
    pub fn domain_controllers(&self) -> std::option::Option<&[crate::model::DomainController]> {
        self.domain_controllers.as_deref()
    }
    /// <p>If not null, more results are available. Pass this value for the <code>NextToken</code>
    /// parameter in a subsequent call to <a>DescribeDomainControllers</a> retrieve the
    /// next set of items.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeDomainControllersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDomainControllersOutput");
        formatter.field("domain_controllers", &self.domain_controllers);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeDomainControllersOutput`](crate::output::DescribeDomainControllersOutput)
pub mod describe_domain_controllers_output {
    /// A builder for [`DescribeDomainControllersOutput`](crate::output::DescribeDomainControllersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_controllers:
            std::option::Option<std::vec::Vec<crate::model::DomainController>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `domain_controllers`.
        ///
        /// To override the contents of this collection use [`set_domain_controllers`](Self::set_domain_controllers).
        ///
        /// <p>List of the <a>DomainController</a> objects that were retrieved.</p>
        pub fn domain_controllers(
            mut self,
            input: impl Into<crate::model::DomainController>,
        ) -> Self {
            let mut v = self.domain_controllers.unwrap_or_default();
            v.push(input.into());
            self.domain_controllers = Some(v);
            self
        }
        /// <p>List of the <a>DomainController</a> objects that were retrieved.</p>
        pub fn set_domain_controllers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainController>>,
        ) -> Self {
            self.domain_controllers = input;
            self
        }
        /// <p>If not null, more results are available. Pass this value for the <code>NextToken</code>
        /// parameter in a subsequent call to <a>DescribeDomainControllers</a> retrieve the
        /// next set of items.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If not null, more results are available. Pass this value for the <code>NextToken</code>
        /// parameter in a subsequent call to <a>DescribeDomainControllers</a> retrieve the
        /// next set of items.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDomainControllersOutput`](crate::output::DescribeDomainControllersOutput)
        pub fn build(self) -> crate::output::DescribeDomainControllersOutput {
            crate::output::DescribeDomainControllersOutput {
                domain_controllers: self.domain_controllers,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeDomainControllersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDomainControllersOutput`](crate::output::DescribeDomainControllersOutput)
    pub fn builder() -> crate::output::describe_domain_controllers_output::Builder {
        crate::output::describe_domain_controllers_output::Builder::default()
    }
}

/// <p>Contains the results of the <a>DescribeDirectories</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDirectoriesOutput {
    /// <p>The list of <a>DirectoryDescription</a> objects that were retrieved.</p>
    /// <p>It is possible that this list contains less than the number of items specified in the
    /// <code>Limit</code> member of the request. This occurs if there are less than the requested
    /// number of items left to retrieve, or if the limitations of the operation have been
    /// exceeded.</p>
    pub directory_descriptions:
        std::option::Option<std::vec::Vec<crate::model::DirectoryDescription>>,
    /// <p>If not null, more results are available. Pass this value for the <code>NextToken</code>
    /// parameter in a subsequent call to <a>DescribeDirectories</a> to retrieve the next
    /// set of items.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeDirectoriesOutput {
    /// <p>The list of <a>DirectoryDescription</a> objects that were retrieved.</p>
    /// <p>It is possible that this list contains less than the number of items specified in the
    /// <code>Limit</code> member of the request. This occurs if there are less than the requested
    /// number of items left to retrieve, or if the limitations of the operation have been
    /// exceeded.</p>
    pub fn directory_descriptions(
        &self,
    ) -> std::option::Option<&[crate::model::DirectoryDescription]> {
        self.directory_descriptions.as_deref()
    }
    /// <p>If not null, more results are available. Pass this value for the <code>NextToken</code>
    /// parameter in a subsequent call to <a>DescribeDirectories</a> to retrieve the next
    /// set of items.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeDirectoriesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDirectoriesOutput");
        formatter.field("directory_descriptions", &self.directory_descriptions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeDirectoriesOutput`](crate::output::DescribeDirectoriesOutput)
pub mod describe_directories_output {
    /// A builder for [`DescribeDirectoriesOutput`](crate::output::DescribeDirectoriesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_descriptions:
            std::option::Option<std::vec::Vec<crate::model::DirectoryDescription>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `directory_descriptions`.
        ///
        /// To override the contents of this collection use [`set_directory_descriptions`](Self::set_directory_descriptions).
        ///
        /// <p>The list of <a>DirectoryDescription</a> objects that were retrieved.</p>
        /// <p>It is possible that this list contains less than the number of items specified in the
        /// <code>Limit</code> member of the request. This occurs if there are less than the requested
        /// number of items left to retrieve, or if the limitations of the operation have been
        /// exceeded.</p>
        pub fn directory_descriptions(
            mut self,
            input: impl Into<crate::model::DirectoryDescription>,
        ) -> Self {
            let mut v = self.directory_descriptions.unwrap_or_default();
            v.push(input.into());
            self.directory_descriptions = Some(v);
            self
        }
        /// <p>The list of <a>DirectoryDescription</a> objects that were retrieved.</p>
        /// <p>It is possible that this list contains less than the number of items specified in the
        /// <code>Limit</code> member of the request. This occurs if there are less than the requested
        /// number of items left to retrieve, or if the limitations of the operation have been
        /// exceeded.</p>
        pub fn set_directory_descriptions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DirectoryDescription>>,
        ) -> Self {
            self.directory_descriptions = input;
            self
        }
        /// <p>If not null, more results are available. Pass this value for the <code>NextToken</code>
        /// parameter in a subsequent call to <a>DescribeDirectories</a> to retrieve the next
        /// set of items.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If not null, more results are available. Pass this value for the <code>NextToken</code>
        /// parameter in a subsequent call to <a>DescribeDirectories</a> to retrieve the next
        /// set of items.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDirectoriesOutput`](crate::output::DescribeDirectoriesOutput)
        pub fn build(self) -> crate::output::DescribeDirectoriesOutput {
            crate::output::DescribeDirectoriesOutput {
                directory_descriptions: self.directory_descriptions,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeDirectoriesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDirectoriesOutput`](crate::output::DescribeDirectoriesOutput)
    pub fn builder() -> crate::output::describe_directories_output::Builder {
        crate::output::describe_directories_output::Builder::default()
    }
}

/// <p>The result of a DescribeConditionalForwarder request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConditionalForwardersOutput {
    /// <p>The list of conditional forwarders that have been created.</p>
    pub conditional_forwarders:
        std::option::Option<std::vec::Vec<crate::model::ConditionalForwarder>>,
}
impl DescribeConditionalForwardersOutput {
    /// <p>The list of conditional forwarders that have been created.</p>
    pub fn conditional_forwarders(
        &self,
    ) -> std::option::Option<&[crate::model::ConditionalForwarder]> {
        self.conditional_forwarders.as_deref()
    }
}
impl std::fmt::Debug for DescribeConditionalForwardersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConditionalForwardersOutput");
        formatter.field("conditional_forwarders", &self.conditional_forwarders);
        formatter.finish()
    }
}
/// See [`DescribeConditionalForwardersOutput`](crate::output::DescribeConditionalForwardersOutput)
pub mod describe_conditional_forwarders_output {
    /// A builder for [`DescribeConditionalForwardersOutput`](crate::output::DescribeConditionalForwardersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) conditional_forwarders:
            std::option::Option<std::vec::Vec<crate::model::ConditionalForwarder>>,
    }
    impl Builder {
        /// Appends an item to `conditional_forwarders`.
        ///
        /// To override the contents of this collection use [`set_conditional_forwarders`](Self::set_conditional_forwarders).
        ///
        /// <p>The list of conditional forwarders that have been created.</p>
        pub fn conditional_forwarders(
            mut self,
            input: impl Into<crate::model::ConditionalForwarder>,
        ) -> Self {
            let mut v = self.conditional_forwarders.unwrap_or_default();
            v.push(input.into());
            self.conditional_forwarders = Some(v);
            self
        }
        /// <p>The list of conditional forwarders that have been created.</p>
        pub fn set_conditional_forwarders(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConditionalForwarder>>,
        ) -> Self {
            self.conditional_forwarders = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConditionalForwardersOutput`](crate::output::DescribeConditionalForwardersOutput)
        pub fn build(self) -> crate::output::DescribeConditionalForwardersOutput {
            crate::output::DescribeConditionalForwardersOutput {
                conditional_forwarders: self.conditional_forwarders,
            }
        }
    }
}
impl DescribeConditionalForwardersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeConditionalForwardersOutput`](crate::output::DescribeConditionalForwardersOutput)
    pub fn builder() -> crate::output::describe_conditional_forwarders_output::Builder {
        crate::output::describe_conditional_forwarders_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeClientAuthenticationSettingsOutput {
    /// <p>Information about the type of client authentication for the specified directory. The following information is retrieved: The date and time when the status of the client authentication type was last updated, whether the client authentication type is enabled or disabled, and the type of client authentication.</p>
    pub client_authentication_settings_info:
        std::option::Option<std::vec::Vec<crate::model::ClientAuthenticationSettingInfo>>,
    /// <p>The next token used to retrieve the client authentication settings if the number of setting types exceeds
    /// page limit and there is another page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeClientAuthenticationSettingsOutput {
    /// <p>Information about the type of client authentication for the specified directory. The following information is retrieved: The date and time when the status of the client authentication type was last updated, whether the client authentication type is enabled or disabled, and the type of client authentication.</p>
    pub fn client_authentication_settings_info(
        &self,
    ) -> std::option::Option<&[crate::model::ClientAuthenticationSettingInfo]> {
        self.client_authentication_settings_info.as_deref()
    }
    /// <p>The next token used to retrieve the client authentication settings if the number of setting types exceeds
    /// page limit and there is another page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeClientAuthenticationSettingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeClientAuthenticationSettingsOutput");
        formatter.field(
            "client_authentication_settings_info",
            &self.client_authentication_settings_info,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeClientAuthenticationSettingsOutput`](crate::output::DescribeClientAuthenticationSettingsOutput)
pub mod describe_client_authentication_settings_output {
    /// A builder for [`DescribeClientAuthenticationSettingsOutput`](crate::output::DescribeClientAuthenticationSettingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_authentication_settings_info:
            std::option::Option<std::vec::Vec<crate::model::ClientAuthenticationSettingInfo>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `client_authentication_settings_info`.
        ///
        /// To override the contents of this collection use [`set_client_authentication_settings_info`](Self::set_client_authentication_settings_info).
        ///
        /// <p>Information about the type of client authentication for the specified directory. The following information is retrieved: The date and time when the status of the client authentication type was last updated, whether the client authentication type is enabled or disabled, and the type of client authentication.</p>
        pub fn client_authentication_settings_info(
            mut self,
            input: impl Into<crate::model::ClientAuthenticationSettingInfo>,
        ) -> Self {
            let mut v = self.client_authentication_settings_info.unwrap_or_default();
            v.push(input.into());
            self.client_authentication_settings_info = Some(v);
            self
        }
        /// <p>Information about the type of client authentication for the specified directory. The following information is retrieved: The date and time when the status of the client authentication type was last updated, whether the client authentication type is enabled or disabled, and the type of client authentication.</p>
        pub fn set_client_authentication_settings_info(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ClientAuthenticationSettingInfo>,
            >,
        ) -> Self {
            self.client_authentication_settings_info = input;
            self
        }
        /// <p>The next token used to retrieve the client authentication settings if the number of setting types exceeds
        /// page limit and there is another page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next token used to retrieve the client authentication settings if the number of setting types exceeds
        /// page limit and there is another page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeClientAuthenticationSettingsOutput`](crate::output::DescribeClientAuthenticationSettingsOutput)
        pub fn build(self) -> crate::output::DescribeClientAuthenticationSettingsOutput {
            crate::output::DescribeClientAuthenticationSettingsOutput {
                client_authentication_settings_info: self.client_authentication_settings_info,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeClientAuthenticationSettingsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeClientAuthenticationSettingsOutput`](crate::output::DescribeClientAuthenticationSettingsOutput)
    pub fn builder() -> crate::output::describe_client_authentication_settings_output::Builder {
        crate::output::describe_client_authentication_settings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCertificateOutput {
    /// <p>Information about the certificate, including registered date time, certificate state, the
    /// reason for the state, expiration date time, and certificate common name.</p>
    pub certificate: std::option::Option<crate::model::Certificate>,
}
impl DescribeCertificateOutput {
    /// <p>Information about the certificate, including registered date time, certificate state, the
    /// reason for the state, expiration date time, and certificate common name.</p>
    pub fn certificate(&self) -> std::option::Option<&crate::model::Certificate> {
        self.certificate.as_ref()
    }
}
impl std::fmt::Debug for DescribeCertificateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCertificateOutput");
        formatter.field("certificate", &self.certificate);
        formatter.finish()
    }
}
/// See [`DescribeCertificateOutput`](crate::output::DescribeCertificateOutput)
pub mod describe_certificate_output {
    /// A builder for [`DescribeCertificateOutput`](crate::output::DescribeCertificateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate: std::option::Option<crate::model::Certificate>,
    }
    impl Builder {
        /// <p>Information about the certificate, including registered date time, certificate state, the
        /// reason for the state, expiration date time, and certificate common name.</p>
        pub fn certificate(mut self, input: crate::model::Certificate) -> Self {
            self.certificate = Some(input);
            self
        }
        /// <p>Information about the certificate, including registered date time, certificate state, the
        /// reason for the state, expiration date time, and certificate common name.</p>
        pub fn set_certificate(
            mut self,
            input: std::option::Option<crate::model::Certificate>,
        ) -> Self {
            self.certificate = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCertificateOutput`](crate::output::DescribeCertificateOutput)
        pub fn build(self) -> crate::output::DescribeCertificateOutput {
            crate::output::DescribeCertificateOutput {
                certificate: self.certificate,
            }
        }
    }
}
impl DescribeCertificateOutput {
    /// Creates a new builder-style object to manufacture [`DescribeCertificateOutput`](crate::output::DescribeCertificateOutput)
    pub fn builder() -> crate::output::describe_certificate_output::Builder {
        crate::output::describe_certificate_output::Builder::default()
    }
}

/// <p>The result of a DeregisterEventTopic request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterEventTopicOutput {}
impl std::fmt::Debug for DeregisterEventTopicOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterEventTopicOutput");
        formatter.finish()
    }
}
/// See [`DeregisterEventTopicOutput`](crate::output::DeregisterEventTopicOutput)
pub mod deregister_event_topic_output {
    /// A builder for [`DeregisterEventTopicOutput`](crate::output::DeregisterEventTopicOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeregisterEventTopicOutput`](crate::output::DeregisterEventTopicOutput)
        pub fn build(self) -> crate::output::DeregisterEventTopicOutput {
            crate::output::DeregisterEventTopicOutput {}
        }
    }
}
impl DeregisterEventTopicOutput {
    /// Creates a new builder-style object to manufacture [`DeregisterEventTopicOutput`](crate::output::DeregisterEventTopicOutput)
    pub fn builder() -> crate::output::deregister_event_topic_output::Builder {
        crate::output::deregister_event_topic_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterCertificateOutput {}
impl std::fmt::Debug for DeregisterCertificateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterCertificateOutput");
        formatter.finish()
    }
}
/// See [`DeregisterCertificateOutput`](crate::output::DeregisterCertificateOutput)
pub mod deregister_certificate_output {
    /// A builder for [`DeregisterCertificateOutput`](crate::output::DeregisterCertificateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeregisterCertificateOutput`](crate::output::DeregisterCertificateOutput)
        pub fn build(self) -> crate::output::DeregisterCertificateOutput {
            crate::output::DeregisterCertificateOutput {}
        }
    }
}
impl DeregisterCertificateOutput {
    /// Creates a new builder-style object to manufacture [`DeregisterCertificateOutput`](crate::output::DeregisterCertificateOutput)
    pub fn builder() -> crate::output::deregister_certificate_output::Builder {
        crate::output::deregister_certificate_output::Builder::default()
    }
}

/// <p>The result of a DeleteTrust request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTrustOutput {
    /// <p>The Trust ID of the trust relationship that was deleted.</p>
    pub trust_id: std::option::Option<std::string::String>,
}
impl DeleteTrustOutput {
    /// <p>The Trust ID of the trust relationship that was deleted.</p>
    pub fn trust_id(&self) -> std::option::Option<&str> {
        self.trust_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteTrustOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTrustOutput");
        formatter.field("trust_id", &self.trust_id);
        formatter.finish()
    }
}
/// See [`DeleteTrustOutput`](crate::output::DeleteTrustOutput)
pub mod delete_trust_output {
    /// A builder for [`DeleteTrustOutput`](crate::output::DeleteTrustOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trust_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Trust ID of the trust relationship that was deleted.</p>
        pub fn trust_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.trust_id = Some(input.into());
            self
        }
        /// <p>The Trust ID of the trust relationship that was deleted.</p>
        pub fn set_trust_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trust_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTrustOutput`](crate::output::DeleteTrustOutput)
        pub fn build(self) -> crate::output::DeleteTrustOutput {
            crate::output::DeleteTrustOutput {
                trust_id: self.trust_id,
            }
        }
    }
}
impl DeleteTrustOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTrustOutput`](crate::output::DeleteTrustOutput)
    pub fn builder() -> crate::output::delete_trust_output::Builder {
        crate::output::delete_trust_output::Builder::default()
    }
}

/// <p>Contains the results of the <a>DeleteSnapshot</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSnapshotOutput {
    /// <p>The identifier of the directory snapshot that was deleted.</p>
    pub snapshot_id: std::option::Option<std::string::String>,
}
impl DeleteSnapshotOutput {
    /// <p>The identifier of the directory snapshot that was deleted.</p>
    pub fn snapshot_id(&self) -> std::option::Option<&str> {
        self.snapshot_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSnapshotOutput");
        formatter.field("snapshot_id", &self.snapshot_id);
        formatter.finish()
    }
}
/// See [`DeleteSnapshotOutput`](crate::output::DeleteSnapshotOutput)
pub mod delete_snapshot_output {
    /// A builder for [`DeleteSnapshotOutput`](crate::output::DeleteSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the directory snapshot that was deleted.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory snapshot that was deleted.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSnapshotOutput`](crate::output::DeleteSnapshotOutput)
        pub fn build(self) -> crate::output::DeleteSnapshotOutput {
            crate::output::DeleteSnapshotOutput {
                snapshot_id: self.snapshot_id,
            }
        }
    }
}
impl DeleteSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSnapshotOutput`](crate::output::DeleteSnapshotOutput)
    pub fn builder() -> crate::output::delete_snapshot_output::Builder {
        crate::output::delete_snapshot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLogSubscriptionOutput {}
impl std::fmt::Debug for DeleteLogSubscriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLogSubscriptionOutput");
        formatter.finish()
    }
}
/// See [`DeleteLogSubscriptionOutput`](crate::output::DeleteLogSubscriptionOutput)
pub mod delete_log_subscription_output {
    /// A builder for [`DeleteLogSubscriptionOutput`](crate::output::DeleteLogSubscriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteLogSubscriptionOutput`](crate::output::DeleteLogSubscriptionOutput)
        pub fn build(self) -> crate::output::DeleteLogSubscriptionOutput {
            crate::output::DeleteLogSubscriptionOutput {}
        }
    }
}
impl DeleteLogSubscriptionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteLogSubscriptionOutput`](crate::output::DeleteLogSubscriptionOutput)
    pub fn builder() -> crate::output::delete_log_subscription_output::Builder {
        crate::output::delete_log_subscription_output::Builder::default()
    }
}

/// <p>Contains the results of the <a>DeleteDirectory</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDirectoryOutput {
    /// <p>The directory identifier.</p>
    pub directory_id: std::option::Option<std::string::String>,
}
impl DeleteDirectoryOutput {
    /// <p>The directory identifier.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteDirectoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDirectoryOutput");
        formatter.field("directory_id", &self.directory_id);
        formatter.finish()
    }
}
/// See [`DeleteDirectoryOutput`](crate::output::DeleteDirectoryOutput)
pub mod delete_directory_output {
    /// A builder for [`DeleteDirectoryOutput`](crate::output::DeleteDirectoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The directory identifier.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The directory identifier.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDirectoryOutput`](crate::output::DeleteDirectoryOutput)
        pub fn build(self) -> crate::output::DeleteDirectoryOutput {
            crate::output::DeleteDirectoryOutput {
                directory_id: self.directory_id,
            }
        }
    }
}
impl DeleteDirectoryOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDirectoryOutput`](crate::output::DeleteDirectoryOutput)
    pub fn builder() -> crate::output::delete_directory_output::Builder {
        crate::output::delete_directory_output::Builder::default()
    }
}

/// <p>The result of a DeleteConditionalForwarder request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConditionalForwarderOutput {}
impl std::fmt::Debug for DeleteConditionalForwarderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConditionalForwarderOutput");
        formatter.finish()
    }
}
/// See [`DeleteConditionalForwarderOutput`](crate::output::DeleteConditionalForwarderOutput)
pub mod delete_conditional_forwarder_output {
    /// A builder for [`DeleteConditionalForwarderOutput`](crate::output::DeleteConditionalForwarderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteConditionalForwarderOutput`](crate::output::DeleteConditionalForwarderOutput)
        pub fn build(self) -> crate::output::DeleteConditionalForwarderOutput {
            crate::output::DeleteConditionalForwarderOutput {}
        }
    }
}
impl DeleteConditionalForwarderOutput {
    /// Creates a new builder-style object to manufacture [`DeleteConditionalForwarderOutput`](crate::output::DeleteConditionalForwarderOutput)
    pub fn builder() -> crate::output::delete_conditional_forwarder_output::Builder {
        crate::output::delete_conditional_forwarder_output::Builder::default()
    }
}

/// <p>The result of a CreateTrust request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTrustOutput {
    /// <p>A unique identifier for the trust relationship that was created.</p>
    pub trust_id: std::option::Option<std::string::String>,
}
impl CreateTrustOutput {
    /// <p>A unique identifier for the trust relationship that was created.</p>
    pub fn trust_id(&self) -> std::option::Option<&str> {
        self.trust_id.as_deref()
    }
}
impl std::fmt::Debug for CreateTrustOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTrustOutput");
        formatter.field("trust_id", &self.trust_id);
        formatter.finish()
    }
}
/// See [`CreateTrustOutput`](crate::output::CreateTrustOutput)
pub mod create_trust_output {
    /// A builder for [`CreateTrustOutput`](crate::output::CreateTrustOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trust_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the trust relationship that was created.</p>
        pub fn trust_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.trust_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the trust relationship that was created.</p>
        pub fn set_trust_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trust_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTrustOutput`](crate::output::CreateTrustOutput)
        pub fn build(self) -> crate::output::CreateTrustOutput {
            crate::output::CreateTrustOutput {
                trust_id: self.trust_id,
            }
        }
    }
}
impl CreateTrustOutput {
    /// Creates a new builder-style object to manufacture [`CreateTrustOutput`](crate::output::CreateTrustOutput)
    pub fn builder() -> crate::output::create_trust_output::Builder {
        crate::output::create_trust_output::Builder::default()
    }
}

/// <p>Contains the results of the <a>CreateSnapshot</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSnapshotOutput {
    /// <p>The identifier of the snapshot that was created.</p>
    pub snapshot_id: std::option::Option<std::string::String>,
}
impl CreateSnapshotOutput {
    /// <p>The identifier of the snapshot that was created.</p>
    pub fn snapshot_id(&self) -> std::option::Option<&str> {
        self.snapshot_id.as_deref()
    }
}
impl std::fmt::Debug for CreateSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSnapshotOutput");
        formatter.field("snapshot_id", &self.snapshot_id);
        formatter.finish()
    }
}
/// See [`CreateSnapshotOutput`](crate::output::CreateSnapshotOutput)
pub mod create_snapshot_output {
    /// A builder for [`CreateSnapshotOutput`](crate::output::CreateSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the snapshot that was created.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the snapshot that was created.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSnapshotOutput`](crate::output::CreateSnapshotOutput)
        pub fn build(self) -> crate::output::CreateSnapshotOutput {
            crate::output::CreateSnapshotOutput {
                snapshot_id: self.snapshot_id,
            }
        }
    }
}
impl CreateSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`CreateSnapshotOutput`](crate::output::CreateSnapshotOutput)
    pub fn builder() -> crate::output::create_snapshot_output::Builder {
        crate::output::create_snapshot_output::Builder::default()
    }
}

/// <p>Result of a CreateMicrosoftAD request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMicrosoftAdOutput {
    /// <p>The identifier of the directory that was created.</p>
    pub directory_id: std::option::Option<std::string::String>,
}
impl CreateMicrosoftAdOutput {
    /// <p>The identifier of the directory that was created.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
}
impl std::fmt::Debug for CreateMicrosoftAdOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMicrosoftAdOutput");
        formatter.field("directory_id", &self.directory_id);
        formatter.finish()
    }
}
/// See [`CreateMicrosoftAdOutput`](crate::output::CreateMicrosoftAdOutput)
pub mod create_microsoft_ad_output {
    /// A builder for [`CreateMicrosoftAdOutput`](crate::output::CreateMicrosoftAdOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the directory that was created.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory that was created.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMicrosoftAdOutput`](crate::output::CreateMicrosoftAdOutput)
        pub fn build(self) -> crate::output::CreateMicrosoftAdOutput {
            crate::output::CreateMicrosoftAdOutput {
                directory_id: self.directory_id,
            }
        }
    }
}
impl CreateMicrosoftAdOutput {
    /// Creates a new builder-style object to manufacture [`CreateMicrosoftAdOutput`](crate::output::CreateMicrosoftAdOutput)
    pub fn builder() -> crate::output::create_microsoft_ad_output::Builder {
        crate::output::create_microsoft_ad_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLogSubscriptionOutput {}
impl std::fmt::Debug for CreateLogSubscriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLogSubscriptionOutput");
        formatter.finish()
    }
}
/// See [`CreateLogSubscriptionOutput`](crate::output::CreateLogSubscriptionOutput)
pub mod create_log_subscription_output {
    /// A builder for [`CreateLogSubscriptionOutput`](crate::output::CreateLogSubscriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateLogSubscriptionOutput`](crate::output::CreateLogSubscriptionOutput)
        pub fn build(self) -> crate::output::CreateLogSubscriptionOutput {
            crate::output::CreateLogSubscriptionOutput {}
        }
    }
}
impl CreateLogSubscriptionOutput {
    /// Creates a new builder-style object to manufacture [`CreateLogSubscriptionOutput`](crate::output::CreateLogSubscriptionOutput)
    pub fn builder() -> crate::output::create_log_subscription_output::Builder {
        crate::output::create_log_subscription_output::Builder::default()
    }
}

/// <p>Contains the results of the <a>CreateDirectory</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDirectoryOutput {
    /// <p>The identifier of the directory that was created.</p>
    pub directory_id: std::option::Option<std::string::String>,
}
impl CreateDirectoryOutput {
    /// <p>The identifier of the directory that was created.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
}
impl std::fmt::Debug for CreateDirectoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDirectoryOutput");
        formatter.field("directory_id", &self.directory_id);
        formatter.finish()
    }
}
/// See [`CreateDirectoryOutput`](crate::output::CreateDirectoryOutput)
pub mod create_directory_output {
    /// A builder for [`CreateDirectoryOutput`](crate::output::CreateDirectoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the directory that was created.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory that was created.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDirectoryOutput`](crate::output::CreateDirectoryOutput)
        pub fn build(self) -> crate::output::CreateDirectoryOutput {
            crate::output::CreateDirectoryOutput {
                directory_id: self.directory_id,
            }
        }
    }
}
impl CreateDirectoryOutput {
    /// Creates a new builder-style object to manufacture [`CreateDirectoryOutput`](crate::output::CreateDirectoryOutput)
    pub fn builder() -> crate::output::create_directory_output::Builder {
        crate::output::create_directory_output::Builder::default()
    }
}

/// <p>The result of a CreateConditinalForwarder request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConditionalForwarderOutput {}
impl std::fmt::Debug for CreateConditionalForwarderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConditionalForwarderOutput");
        formatter.finish()
    }
}
/// See [`CreateConditionalForwarderOutput`](crate::output::CreateConditionalForwarderOutput)
pub mod create_conditional_forwarder_output {
    /// A builder for [`CreateConditionalForwarderOutput`](crate::output::CreateConditionalForwarderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateConditionalForwarderOutput`](crate::output::CreateConditionalForwarderOutput)
        pub fn build(self) -> crate::output::CreateConditionalForwarderOutput {
            crate::output::CreateConditionalForwarderOutput {}
        }
    }
}
impl CreateConditionalForwarderOutput {
    /// Creates a new builder-style object to manufacture [`CreateConditionalForwarderOutput`](crate::output::CreateConditionalForwarderOutput)
    pub fn builder() -> crate::output::create_conditional_forwarder_output::Builder {
        crate::output::create_conditional_forwarder_output::Builder::default()
    }
}

/// <p>Contains the results for the <a>CreateComputer</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateComputerOutput {
    /// <p>A <a>Computer</a> object that represents the computer account.</p>
    pub computer: std::option::Option<crate::model::Computer>,
}
impl CreateComputerOutput {
    /// <p>A <a>Computer</a> object that represents the computer account.</p>
    pub fn computer(&self) -> std::option::Option<&crate::model::Computer> {
        self.computer.as_ref()
    }
}
impl std::fmt::Debug for CreateComputerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateComputerOutput");
        formatter.field("computer", &self.computer);
        formatter.finish()
    }
}
/// See [`CreateComputerOutput`](crate::output::CreateComputerOutput)
pub mod create_computer_output {
    /// A builder for [`CreateComputerOutput`](crate::output::CreateComputerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) computer: std::option::Option<crate::model::Computer>,
    }
    impl Builder {
        /// <p>A <a>Computer</a> object that represents the computer account.</p>
        pub fn computer(mut self, input: crate::model::Computer) -> Self {
            self.computer = Some(input);
            self
        }
        /// <p>A <a>Computer</a> object that represents the computer account.</p>
        pub fn set_computer(mut self, input: std::option::Option<crate::model::Computer>) -> Self {
            self.computer = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateComputerOutput`](crate::output::CreateComputerOutput)
        pub fn build(self) -> crate::output::CreateComputerOutput {
            crate::output::CreateComputerOutput {
                computer: self.computer,
            }
        }
    }
}
impl CreateComputerOutput {
    /// Creates a new builder-style object to manufacture [`CreateComputerOutput`](crate::output::CreateComputerOutput)
    pub fn builder() -> crate::output::create_computer_output::Builder {
        crate::output::create_computer_output::Builder::default()
    }
}

/// <p>Contains the results of the <a>CreateAlias</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAliasOutput {
    /// <p>The identifier of the directory.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The alias for the directory.</p>
    pub alias: std::option::Option<std::string::String>,
}
impl CreateAliasOutput {
    /// <p>The identifier of the directory.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The alias for the directory.</p>
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
}
impl std::fmt::Debug for CreateAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAliasOutput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("alias", &self.alias);
        formatter.finish()
    }
}
/// See [`CreateAliasOutput`](crate::output::CreateAliasOutput)
pub mod create_alias_output {
    /// A builder for [`CreateAliasOutput`](crate::output::CreateAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) alias: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the directory.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The alias for the directory.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// <p>The alias for the directory.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAliasOutput`](crate::output::CreateAliasOutput)
        pub fn build(self) -> crate::output::CreateAliasOutput {
            crate::output::CreateAliasOutput {
                directory_id: self.directory_id,
                alias: self.alias,
            }
        }
    }
}
impl CreateAliasOutput {
    /// Creates a new builder-style object to manufacture [`CreateAliasOutput`](crate::output::CreateAliasOutput)
    pub fn builder() -> crate::output::create_alias_output::Builder {
        crate::output::create_alias_output::Builder::default()
    }
}

/// <p>Contains the results of the <a>ConnectDirectory</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectDirectoryOutput {
    /// <p>The identifier of the new directory.</p>
    pub directory_id: std::option::Option<std::string::String>,
}
impl ConnectDirectoryOutput {
    /// <p>The identifier of the new directory.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
}
impl std::fmt::Debug for ConnectDirectoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectDirectoryOutput");
        formatter.field("directory_id", &self.directory_id);
        formatter.finish()
    }
}
/// See [`ConnectDirectoryOutput`](crate::output::ConnectDirectoryOutput)
pub mod connect_directory_output {
    /// A builder for [`ConnectDirectoryOutput`](crate::output::ConnectDirectoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the new directory.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the new directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectDirectoryOutput`](crate::output::ConnectDirectoryOutput)
        pub fn build(self) -> crate::output::ConnectDirectoryOutput {
            crate::output::ConnectDirectoryOutput {
                directory_id: self.directory_id,
            }
        }
    }
}
impl ConnectDirectoryOutput {
    /// Creates a new builder-style object to manufacture [`ConnectDirectoryOutput`](crate::output::ConnectDirectoryOutput)
    pub fn builder() -> crate::output::connect_directory_output::Builder {
        crate::output::connect_directory_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelSchemaExtensionOutput {}
impl std::fmt::Debug for CancelSchemaExtensionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelSchemaExtensionOutput");
        formatter.finish()
    }
}
/// See [`CancelSchemaExtensionOutput`](crate::output::CancelSchemaExtensionOutput)
pub mod cancel_schema_extension_output {
    /// A builder for [`CancelSchemaExtensionOutput`](crate::output::CancelSchemaExtensionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CancelSchemaExtensionOutput`](crate::output::CancelSchemaExtensionOutput)
        pub fn build(self) -> crate::output::CancelSchemaExtensionOutput {
            crate::output::CancelSchemaExtensionOutput {}
        }
    }
}
impl CancelSchemaExtensionOutput {
    /// Creates a new builder-style object to manufacture [`CancelSchemaExtensionOutput`](crate::output::CancelSchemaExtensionOutput)
    pub fn builder() -> crate::output::cancel_schema_extension_output::Builder {
        crate::output::cancel_schema_extension_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddTagsToResourceOutput {}
impl std::fmt::Debug for AddTagsToResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddTagsToResourceOutput");
        formatter.finish()
    }
}
/// See [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)
pub mod add_tags_to_resource_output {
    /// A builder for [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)
        pub fn build(self) -> crate::output::AddTagsToResourceOutput {
            crate::output::AddTagsToResourceOutput {}
        }
    }
}
impl AddTagsToResourceOutput {
    /// Creates a new builder-style object to manufacture [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)
    pub fn builder() -> crate::output::add_tags_to_resource_output::Builder {
        crate::output::add_tags_to_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddRegionOutput {}
impl std::fmt::Debug for AddRegionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddRegionOutput");
        formatter.finish()
    }
}
/// See [`AddRegionOutput`](crate::output::AddRegionOutput)
pub mod add_region_output {
    /// A builder for [`AddRegionOutput`](crate::output::AddRegionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AddRegionOutput`](crate::output::AddRegionOutput)
        pub fn build(self) -> crate::output::AddRegionOutput {
            crate::output::AddRegionOutput {}
        }
    }
}
impl AddRegionOutput {
    /// Creates a new builder-style object to manufacture [`AddRegionOutput`](crate::output::AddRegionOutput)
    pub fn builder() -> crate::output::add_region_output::Builder {
        crate::output::add_region_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddIpRoutesOutput {}
impl std::fmt::Debug for AddIpRoutesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddIpRoutesOutput");
        formatter.finish()
    }
}
/// See [`AddIpRoutesOutput`](crate::output::AddIpRoutesOutput)
pub mod add_ip_routes_output {
    /// A builder for [`AddIpRoutesOutput`](crate::output::AddIpRoutesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AddIpRoutesOutput`](crate::output::AddIpRoutesOutput)
        pub fn build(self) -> crate::output::AddIpRoutesOutput {
            crate::output::AddIpRoutesOutput {}
        }
    }
}
impl AddIpRoutesOutput {
    /// Creates a new builder-style object to manufacture [`AddIpRoutesOutput`](crate::output::AddIpRoutesOutput)
    pub fn builder() -> crate::output::add_ip_routes_output::Builder {
        crate::output::add_ip_routes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceptSharedDirectoryOutput {
    /// <p>The shared directory in the directory consumer account.</p>
    pub shared_directory: std::option::Option<crate::model::SharedDirectory>,
}
impl AcceptSharedDirectoryOutput {
    /// <p>The shared directory in the directory consumer account.</p>
    pub fn shared_directory(&self) -> std::option::Option<&crate::model::SharedDirectory> {
        self.shared_directory.as_ref()
    }
}
impl std::fmt::Debug for AcceptSharedDirectoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceptSharedDirectoryOutput");
        formatter.field("shared_directory", &self.shared_directory);
        formatter.finish()
    }
}
/// See [`AcceptSharedDirectoryOutput`](crate::output::AcceptSharedDirectoryOutput)
pub mod accept_shared_directory_output {
    /// A builder for [`AcceptSharedDirectoryOutput`](crate::output::AcceptSharedDirectoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) shared_directory: std::option::Option<crate::model::SharedDirectory>,
    }
    impl Builder {
        /// <p>The shared directory in the directory consumer account.</p>
        pub fn shared_directory(mut self, input: crate::model::SharedDirectory) -> Self {
            self.shared_directory = Some(input);
            self
        }
        /// <p>The shared directory in the directory consumer account.</p>
        pub fn set_shared_directory(
            mut self,
            input: std::option::Option<crate::model::SharedDirectory>,
        ) -> Self {
            self.shared_directory = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptSharedDirectoryOutput`](crate::output::AcceptSharedDirectoryOutput)
        pub fn build(self) -> crate::output::AcceptSharedDirectoryOutput {
            crate::output::AcceptSharedDirectoryOutput {
                shared_directory: self.shared_directory,
            }
        }
    }
}
impl AcceptSharedDirectoryOutput {
    /// Creates a new builder-style object to manufacture [`AcceptSharedDirectoryOutput`](crate::output::AcceptSharedDirectoryOutput)
    pub fn builder() -> crate::output::accept_shared_directory_output::Builder {
        crate::output::accept_shared_directory_output::Builder::default()
    }
}
