// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SelectiveAuth {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SelectiveAuth {
    fn from(s: &str) -> Self {
        match s {
            "Disabled" => SelectiveAuth::Disabled,
            "Enabled" => SelectiveAuth::Enabled,
            other => SelectiveAuth::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SelectiveAuth {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SelectiveAuth::from(s))
    }
}
impl SelectiveAuth {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SelectiveAuth::Disabled => "Disabled",
            SelectiveAuth::Enabled => "Enabled",
            SelectiveAuth::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Disabled", "Enabled"]
    }
}
impl AsRef<str> for SelectiveAuth {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a Remote Authentication Dial In User Service (RADIUS)
/// server.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RadiusSettings {
    /// <p>An array of strings that contains the fully qualified domain name (FQDN) or IP
    /// addresses of the RADIUS server endpoints, or the FQDN or IP addresses of your RADIUS server
    /// load balancer.</p>
    pub radius_servers: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The port that your RADIUS server is using for communications. Your self-managed
    /// network must allow inbound traffic over this port from the Directory Service servers.</p>
    pub radius_port: i32,
    /// <p>The amount of time, in seconds, to wait for the RADIUS server to respond.</p>
    pub radius_timeout: i32,
    /// <p>The maximum number of times that communication with the RADIUS server is
    /// attempted.</p>
    pub radius_retries: i32,
    /// <p>Required for enabling RADIUS on the directory.</p>
    pub shared_secret: std::option::Option<std::string::String>,
    /// <p>The protocol specified for your RADIUS endpoints.</p>
    pub authentication_protocol: std::option::Option<crate::model::RadiusAuthenticationProtocol>,
    /// <p>Not currently used.</p>
    pub display_label: std::option::Option<std::string::String>,
    /// <p>Not currently used.</p>
    pub use_same_username: bool,
}
impl RadiusSettings {
    /// <p>An array of strings that contains the fully qualified domain name (FQDN) or IP
    /// addresses of the RADIUS server endpoints, or the FQDN or IP addresses of your RADIUS server
    /// load balancer.</p>
    pub fn radius_servers(&self) -> std::option::Option<&[std::string::String]> {
        self.radius_servers.as_deref()
    }
    /// <p>The port that your RADIUS server is using for communications. Your self-managed
    /// network must allow inbound traffic over this port from the Directory Service servers.</p>
    pub fn radius_port(&self) -> i32 {
        self.radius_port
    }
    /// <p>The amount of time, in seconds, to wait for the RADIUS server to respond.</p>
    pub fn radius_timeout(&self) -> i32 {
        self.radius_timeout
    }
    /// <p>The maximum number of times that communication with the RADIUS server is
    /// attempted.</p>
    pub fn radius_retries(&self) -> i32 {
        self.radius_retries
    }
    /// <p>Required for enabling RADIUS on the directory.</p>
    pub fn shared_secret(&self) -> std::option::Option<&str> {
        self.shared_secret.as_deref()
    }
    /// <p>The protocol specified for your RADIUS endpoints.</p>
    pub fn authentication_protocol(
        &self,
    ) -> std::option::Option<&crate::model::RadiusAuthenticationProtocol> {
        self.authentication_protocol.as_ref()
    }
    /// <p>Not currently used.</p>
    pub fn display_label(&self) -> std::option::Option<&str> {
        self.display_label.as_deref()
    }
    /// <p>Not currently used.</p>
    pub fn use_same_username(&self) -> bool {
        self.use_same_username
    }
}
impl std::fmt::Debug for RadiusSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RadiusSettings");
        formatter.field("radius_servers", &self.radius_servers);
        formatter.field("radius_port", &self.radius_port);
        formatter.field("radius_timeout", &self.radius_timeout);
        formatter.field("radius_retries", &self.radius_retries);
        formatter.field("shared_secret", &"*** Sensitive Data Redacted ***");
        formatter.field("authentication_protocol", &self.authentication_protocol);
        formatter.field("display_label", &self.display_label);
        formatter.field("use_same_username", &self.use_same_username);
        formatter.finish()
    }
}
/// See [`RadiusSettings`](crate::model::RadiusSettings)
pub mod radius_settings {
    /// A builder for [`RadiusSettings`](crate::model::RadiusSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) radius_servers: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) radius_port: std::option::Option<i32>,
        pub(crate) radius_timeout: std::option::Option<i32>,
        pub(crate) radius_retries: std::option::Option<i32>,
        pub(crate) shared_secret: std::option::Option<std::string::String>,
        pub(crate) authentication_protocol:
            std::option::Option<crate::model::RadiusAuthenticationProtocol>,
        pub(crate) display_label: std::option::Option<std::string::String>,
        pub(crate) use_same_username: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `radius_servers`.
        ///
        /// To override the contents of this collection use [`set_radius_servers`](Self::set_radius_servers).
        ///
        /// <p>An array of strings that contains the fully qualified domain name (FQDN) or IP
        /// addresses of the RADIUS server endpoints, or the FQDN or IP addresses of your RADIUS server
        /// load balancer.</p>
        pub fn radius_servers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.radius_servers.unwrap_or_default();
            v.push(input.into());
            self.radius_servers = Some(v);
            self
        }
        /// <p>An array of strings that contains the fully qualified domain name (FQDN) or IP
        /// addresses of the RADIUS server endpoints, or the FQDN or IP addresses of your RADIUS server
        /// load balancer.</p>
        pub fn set_radius_servers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.radius_servers = input;
            self
        }
        /// <p>The port that your RADIUS server is using for communications. Your self-managed
        /// network must allow inbound traffic over this port from the Directory Service servers.</p>
        pub fn radius_port(mut self, input: i32) -> Self {
            self.radius_port = Some(input);
            self
        }
        /// <p>The port that your RADIUS server is using for communications. Your self-managed
        /// network must allow inbound traffic over this port from the Directory Service servers.</p>
        pub fn set_radius_port(mut self, input: std::option::Option<i32>) -> Self {
            self.radius_port = input;
            self
        }
        /// <p>The amount of time, in seconds, to wait for the RADIUS server to respond.</p>
        pub fn radius_timeout(mut self, input: i32) -> Self {
            self.radius_timeout = Some(input);
            self
        }
        /// <p>The amount of time, in seconds, to wait for the RADIUS server to respond.</p>
        pub fn set_radius_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.radius_timeout = input;
            self
        }
        /// <p>The maximum number of times that communication with the RADIUS server is
        /// attempted.</p>
        pub fn radius_retries(mut self, input: i32) -> Self {
            self.radius_retries = Some(input);
            self
        }
        /// <p>The maximum number of times that communication with the RADIUS server is
        /// attempted.</p>
        pub fn set_radius_retries(mut self, input: std::option::Option<i32>) -> Self {
            self.radius_retries = input;
            self
        }
        /// <p>Required for enabling RADIUS on the directory.</p>
        pub fn shared_secret(mut self, input: impl Into<std::string::String>) -> Self {
            self.shared_secret = Some(input.into());
            self
        }
        /// <p>Required for enabling RADIUS on the directory.</p>
        pub fn set_shared_secret(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.shared_secret = input;
            self
        }
        /// <p>The protocol specified for your RADIUS endpoints.</p>
        pub fn authentication_protocol(
            mut self,
            input: crate::model::RadiusAuthenticationProtocol,
        ) -> Self {
            self.authentication_protocol = Some(input);
            self
        }
        /// <p>The protocol specified for your RADIUS endpoints.</p>
        pub fn set_authentication_protocol(
            mut self,
            input: std::option::Option<crate::model::RadiusAuthenticationProtocol>,
        ) -> Self {
            self.authentication_protocol = input;
            self
        }
        /// <p>Not currently used.</p>
        pub fn display_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_label = Some(input.into());
            self
        }
        /// <p>Not currently used.</p>
        pub fn set_display_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.display_label = input;
            self
        }
        /// <p>Not currently used.</p>
        pub fn use_same_username(mut self, input: bool) -> Self {
            self.use_same_username = Some(input);
            self
        }
        /// <p>Not currently used.</p>
        pub fn set_use_same_username(mut self, input: std::option::Option<bool>) -> Self {
            self.use_same_username = input;
            self
        }
        /// Consumes the builder and constructs a [`RadiusSettings`](crate::model::RadiusSettings)
        pub fn build(self) -> crate::model::RadiusSettings {
            crate::model::RadiusSettings {
                radius_servers: self.radius_servers,
                radius_port: self.radius_port.unwrap_or_default(),
                radius_timeout: self.radius_timeout.unwrap_or_default(),
                radius_retries: self.radius_retries.unwrap_or_default(),
                shared_secret: self.shared_secret,
                authentication_protocol: self.authentication_protocol,
                display_label: self.display_label,
                use_same_username: self.use_same_username.unwrap_or_default(),
            }
        }
    }
}
impl RadiusSettings {
    /// Creates a new builder-style object to manufacture [`RadiusSettings`](crate::model::RadiusSettings)
    pub fn builder() -> crate::model::radius_settings::Builder {
        crate::model::radius_settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RadiusAuthenticationProtocol {
    #[allow(missing_docs)] // documentation missing in model
    Chap,
    #[allow(missing_docs)] // documentation missing in model
    Mschapv1,
    #[allow(missing_docs)] // documentation missing in model
    Mschapv2,
    #[allow(missing_docs)] // documentation missing in model
    Pap,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RadiusAuthenticationProtocol {
    fn from(s: &str) -> Self {
        match s {
            "CHAP" => RadiusAuthenticationProtocol::Chap,
            "MS-CHAPv1" => RadiusAuthenticationProtocol::Mschapv1,
            "MS-CHAPv2" => RadiusAuthenticationProtocol::Mschapv2,
            "PAP" => RadiusAuthenticationProtocol::Pap,
            other => RadiusAuthenticationProtocol::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RadiusAuthenticationProtocol {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RadiusAuthenticationProtocol::from(s))
    }
}
impl RadiusAuthenticationProtocol {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RadiusAuthenticationProtocol::Chap => "CHAP",
            RadiusAuthenticationProtocol::Mschapv1 => "MS-CHAPv1",
            RadiusAuthenticationProtocol::Mschapv2 => "MS-CHAPv2",
            RadiusAuthenticationProtocol::Pap => "PAP",
            RadiusAuthenticationProtocol::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CHAP", "MS-CHAPv1", "MS-CHAPv2", "PAP"]
    }
}
impl AsRef<str> for RadiusAuthenticationProtocol {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Identifier that contains details about the directory consumer account with whom the
/// directory is being unshared.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnshareTarget {
    /// <p>Identifier of the directory consumer account.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Type of identifier to be used in the <i>Id</i> field.</p>
    pub r#type: std::option::Option<crate::model::TargetType>,
}
impl UnshareTarget {
    /// <p>Identifier of the directory consumer account.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Type of identifier to be used in the <i>Id</i> field.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::TargetType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for UnshareTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnshareTarget");
        formatter.field("id", &self.id);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`UnshareTarget`](crate::model::UnshareTarget)
pub mod unshare_target {
    /// A builder for [`UnshareTarget`](crate::model::UnshareTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::TargetType>,
    }
    impl Builder {
        /// <p>Identifier of the directory consumer account.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>Identifier of the directory consumer account.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Type of identifier to be used in the <i>Id</i> field.</p>
        pub fn r#type(mut self, input: crate::model::TargetType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Type of identifier to be used in the <i>Id</i> field.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::TargetType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`UnshareTarget`](crate::model::UnshareTarget)
        pub fn build(self) -> crate::model::UnshareTarget {
            crate::model::UnshareTarget {
                id: self.id,
                r#type: self.r#type,
            }
        }
    }
}
impl UnshareTarget {
    /// Creates a new builder-style object to manufacture [`UnshareTarget`](crate::model::UnshareTarget)
    pub fn builder() -> crate::model::unshare_target::Builder {
        crate::model::unshare_target::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TargetType {
    #[allow(missing_docs)] // documentation missing in model
    Account,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TargetType {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT" => TargetType::Account,
            other => TargetType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TargetType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TargetType::from(s))
    }
}
impl TargetType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TargetType::Account => "ACCOUNT",
            TargetType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACCOUNT"]
    }
}
impl AsRef<str> for TargetType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ShareMethod {
    #[allow(missing_docs)] // documentation missing in model
    Handshake,
    #[allow(missing_docs)] // documentation missing in model
    Organizations,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ShareMethod {
    fn from(s: &str) -> Self {
        match s {
            "HANDSHAKE" => ShareMethod::Handshake,
            "ORGANIZATIONS" => ShareMethod::Organizations,
            other => ShareMethod::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ShareMethod {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ShareMethod::from(s))
    }
}
impl ShareMethod {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ShareMethod::Handshake => "HANDSHAKE",
            ShareMethod::Organizations => "ORGANIZATIONS",
            ShareMethod::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HANDSHAKE", "ORGANIZATIONS"]
    }
}
impl AsRef<str> for ShareMethod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Identifier that contains details about the directory consumer account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ShareTarget {
    /// <p>Identifier of the directory consumer account.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Type of identifier to be used in the <code>Id</code> field.</p>
    pub r#type: std::option::Option<crate::model::TargetType>,
}
impl ShareTarget {
    /// <p>Identifier of the directory consumer account.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Type of identifier to be used in the <code>Id</code> field.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::TargetType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for ShareTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ShareTarget");
        formatter.field("id", &self.id);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`ShareTarget`](crate::model::ShareTarget)
pub mod share_target {
    /// A builder for [`ShareTarget`](crate::model::ShareTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::TargetType>,
    }
    impl Builder {
        /// <p>Identifier of the directory consumer account.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>Identifier of the directory consumer account.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Type of identifier to be used in the <code>Id</code> field.</p>
        pub fn r#type(mut self, input: crate::model::TargetType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Type of identifier to be used in the <code>Id</code> field.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::TargetType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`ShareTarget`](crate::model::ShareTarget)
        pub fn build(self) -> crate::model::ShareTarget {
            crate::model::ShareTarget {
                id: self.id,
                r#type: self.r#type,
            }
        }
    }
}
impl ShareTarget {
    /// Creates a new builder-style object to manufacture [`ShareTarget`](crate::model::ShareTarget)
    pub fn builder() -> crate::model::share_target::Builder {
        crate::model::share_target::Builder::default()
    }
}

/// <p>Contains information about the client certificate authentication settings for the <code>RegisterCertificate</code> and <code>DescribeCertificate</code> operations. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClientCertAuthSettings {
    /// <p>Specifies the URL of the default OCSP server used to check for revocation status. A secondary value to any OCSP address found in the AIA extension of the user certificate.</p>
    pub ocsp_url: std::option::Option<std::string::String>,
}
impl ClientCertAuthSettings {
    /// <p>Specifies the URL of the default OCSP server used to check for revocation status. A secondary value to any OCSP address found in the AIA extension of the user certificate.</p>
    pub fn ocsp_url(&self) -> std::option::Option<&str> {
        self.ocsp_url.as_deref()
    }
}
impl std::fmt::Debug for ClientCertAuthSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClientCertAuthSettings");
        formatter.field("ocsp_url", &self.ocsp_url);
        formatter.finish()
    }
}
/// See [`ClientCertAuthSettings`](crate::model::ClientCertAuthSettings)
pub mod client_cert_auth_settings {
    /// A builder for [`ClientCertAuthSettings`](crate::model::ClientCertAuthSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ocsp_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the URL of the default OCSP server used to check for revocation status. A secondary value to any OCSP address found in the AIA extension of the user certificate.</p>
        pub fn ocsp_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.ocsp_url = Some(input.into());
            self
        }
        /// <p>Specifies the URL of the default OCSP server used to check for revocation status. A secondary value to any OCSP address found in the AIA extension of the user certificate.</p>
        pub fn set_ocsp_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ocsp_url = input;
            self
        }
        /// Consumes the builder and constructs a [`ClientCertAuthSettings`](crate::model::ClientCertAuthSettings)
        pub fn build(self) -> crate::model::ClientCertAuthSettings {
            crate::model::ClientCertAuthSettings {
                ocsp_url: self.ocsp_url,
            }
        }
    }
}
impl ClientCertAuthSettings {
    /// Creates a new builder-style object to manufacture [`ClientCertAuthSettings`](crate::model::ClientCertAuthSettings)
    pub fn builder() -> crate::model::client_cert_auth_settings::Builder {
        crate::model::client_cert_auth_settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CertificateType {
    #[allow(missing_docs)] // documentation missing in model
    ClientCertAuth,
    #[allow(missing_docs)] // documentation missing in model
    ClientLdaps,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CertificateType {
    fn from(s: &str) -> Self {
        match s {
            "ClientCertAuth" => CertificateType::ClientCertAuth,
            "ClientLDAPS" => CertificateType::ClientLdaps,
            other => CertificateType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CertificateType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CertificateType::from(s))
    }
}
impl CertificateType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CertificateType::ClientCertAuth => "ClientCertAuth",
            CertificateType::ClientLdaps => "ClientLDAPS",
            CertificateType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ClientCertAuth", "ClientLDAPS"]
    }
}
impl AsRef<str> for CertificateType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Metadata assigned to a directory consisting of a key-value pair.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>Required name of the tag. The string value can be Unicode characters and cannot be
    /// prefixed with "aws:". The string can contain only the set of Unicode letters, digits,
    /// white-space, '_', '.', '/', '=', '+', '-' (Java regex:
    /// "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The optional value of the tag. The string value can be Unicode characters. The string
    /// can contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-'
    /// (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>Required name of the tag. The string value can be Unicode characters and cannot be
    /// prefixed with "aws:". The string can contain only the set of Unicode letters, digits,
    /// white-space, '_', '.', '/', '=', '+', '-' (Java regex:
    /// "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The optional value of the tag. The string value can be Unicode characters. The string
    /// can contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-'
    /// (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Required name of the tag. The string value can be Unicode characters and cannot be
        /// prefixed with "aws:". The string can contain only the set of Unicode letters, digits,
        /// white-space, '_', '.', '/', '=', '+', '-' (Java regex:
        /// "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Required name of the tag. The string value can be Unicode characters and cannot be
        /// prefixed with "aws:". The string can contain only the set of Unicode letters, digits,
        /// white-space, '_', '.', '/', '=', '+', '-' (Java regex:
        /// "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The optional value of the tag. The string value can be Unicode characters. The string
        /// can contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-'
        /// (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The optional value of the tag. The string value can be Unicode characters. The string
        /// can contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-'
        /// (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Information about a schema extension.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SchemaExtensionInfo {
    /// <p>The identifier of the directory to which the schema extension is applied.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the schema extension.</p>
    pub schema_extension_id: std::option::Option<std::string::String>,
    /// <p>A description of the schema extension.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The current status of the schema extension.</p>
    pub schema_extension_status: std::option::Option<crate::model::SchemaExtensionStatus>,
    /// <p>The reason for the <code>SchemaExtensionStatus</code>.</p>
    pub schema_extension_status_reason: std::option::Option<std::string::String>,
    /// <p>The date and time that the schema extension started being applied to the
    /// directory.</p>
    pub start_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the schema extension was completed.</p>
    pub end_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl SchemaExtensionInfo {
    /// <p>The identifier of the directory to which the schema extension is applied.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The identifier of the schema extension.</p>
    pub fn schema_extension_id(&self) -> std::option::Option<&str> {
        self.schema_extension_id.as_deref()
    }
    /// <p>A description of the schema extension.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The current status of the schema extension.</p>
    pub fn schema_extension_status(
        &self,
    ) -> std::option::Option<&crate::model::SchemaExtensionStatus> {
        self.schema_extension_status.as_ref()
    }
    /// <p>The reason for the <code>SchemaExtensionStatus</code>.</p>
    pub fn schema_extension_status_reason(&self) -> std::option::Option<&str> {
        self.schema_extension_status_reason.as_deref()
    }
    /// <p>The date and time that the schema extension started being applied to the
    /// directory.</p>
    pub fn start_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_date_time.as_ref()
    }
    /// <p>The date and time that the schema extension was completed.</p>
    pub fn end_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_date_time.as_ref()
    }
}
impl std::fmt::Debug for SchemaExtensionInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SchemaExtensionInfo");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("schema_extension_id", &self.schema_extension_id);
        formatter.field("description", &self.description);
        formatter.field("schema_extension_status", &self.schema_extension_status);
        formatter.field(
            "schema_extension_status_reason",
            &self.schema_extension_status_reason,
        );
        formatter.field("start_date_time", &self.start_date_time);
        formatter.field("end_date_time", &self.end_date_time);
        formatter.finish()
    }
}
/// See [`SchemaExtensionInfo`](crate::model::SchemaExtensionInfo)
pub mod schema_extension_info {
    /// A builder for [`SchemaExtensionInfo`](crate::model::SchemaExtensionInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) schema_extension_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) schema_extension_status:
            std::option::Option<crate::model::SchemaExtensionStatus>,
        pub(crate) schema_extension_status_reason: std::option::Option<std::string::String>,
        pub(crate) start_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The identifier of the directory to which the schema extension is applied.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory to which the schema extension is applied.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The identifier of the schema extension.</p>
        pub fn schema_extension_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_extension_id = Some(input.into());
            self
        }
        /// <p>The identifier of the schema extension.</p>
        pub fn set_schema_extension_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_extension_id = input;
            self
        }
        /// <p>A description of the schema extension.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the schema extension.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The current status of the schema extension.</p>
        pub fn schema_extension_status(
            mut self,
            input: crate::model::SchemaExtensionStatus,
        ) -> Self {
            self.schema_extension_status = Some(input);
            self
        }
        /// <p>The current status of the schema extension.</p>
        pub fn set_schema_extension_status(
            mut self,
            input: std::option::Option<crate::model::SchemaExtensionStatus>,
        ) -> Self {
            self.schema_extension_status = input;
            self
        }
        /// <p>The reason for the <code>SchemaExtensionStatus</code>.</p>
        pub fn schema_extension_status_reason(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.schema_extension_status_reason = Some(input.into());
            self
        }
        /// <p>The reason for the <code>SchemaExtensionStatus</code>.</p>
        pub fn set_schema_extension_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_extension_status_reason = input;
            self
        }
        /// <p>The date and time that the schema extension started being applied to the
        /// directory.</p>
        pub fn start_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_date_time = Some(input);
            self
        }
        /// <p>The date and time that the schema extension started being applied to the
        /// directory.</p>
        pub fn set_start_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_date_time = input;
            self
        }
        /// <p>The date and time that the schema extension was completed.</p>
        pub fn end_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_date_time = Some(input);
            self
        }
        /// <p>The date and time that the schema extension was completed.</p>
        pub fn set_end_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`SchemaExtensionInfo`](crate::model::SchemaExtensionInfo)
        pub fn build(self) -> crate::model::SchemaExtensionInfo {
            crate::model::SchemaExtensionInfo {
                directory_id: self.directory_id,
                schema_extension_id: self.schema_extension_id,
                description: self.description,
                schema_extension_status: self.schema_extension_status,
                schema_extension_status_reason: self.schema_extension_status_reason,
                start_date_time: self.start_date_time,
                end_date_time: self.end_date_time,
            }
        }
    }
}
impl SchemaExtensionInfo {
    /// Creates a new builder-style object to manufacture [`SchemaExtensionInfo`](crate::model::SchemaExtensionInfo)
    pub fn builder() -> crate::model::schema_extension_info::Builder {
        crate::model::schema_extension_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SchemaExtensionStatus {
    #[allow(missing_docs)] // documentation missing in model
    CancelInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    CreatingSnapshot,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Initializing,
    #[allow(missing_docs)] // documentation missing in model
    Replicating,
    #[allow(missing_docs)] // documentation missing in model
    RollbackInProgress,
    #[allow(missing_docs)] // documentation missing in model
    UpdatingSchema,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SchemaExtensionStatus {
    fn from(s: &str) -> Self {
        match s {
            "CancelInProgress" => SchemaExtensionStatus::CancelInProgress,
            "Cancelled" => SchemaExtensionStatus::Cancelled,
            "Completed" => SchemaExtensionStatus::Completed,
            "CreatingSnapshot" => SchemaExtensionStatus::CreatingSnapshot,
            "Failed" => SchemaExtensionStatus::Failed,
            "Initializing" => SchemaExtensionStatus::Initializing,
            "Replicating" => SchemaExtensionStatus::Replicating,
            "RollbackInProgress" => SchemaExtensionStatus::RollbackInProgress,
            "UpdatingSchema" => SchemaExtensionStatus::UpdatingSchema,
            other => SchemaExtensionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SchemaExtensionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SchemaExtensionStatus::from(s))
    }
}
impl SchemaExtensionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SchemaExtensionStatus::CancelInProgress => "CancelInProgress",
            SchemaExtensionStatus::Cancelled => "Cancelled",
            SchemaExtensionStatus::Completed => "Completed",
            SchemaExtensionStatus::CreatingSnapshot => "CreatingSnapshot",
            SchemaExtensionStatus::Failed => "Failed",
            SchemaExtensionStatus::Initializing => "Initializing",
            SchemaExtensionStatus::Replicating => "Replicating",
            SchemaExtensionStatus::RollbackInProgress => "RollbackInProgress",
            SchemaExtensionStatus::UpdatingSchema => "UpdatingSchema",
            SchemaExtensionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CancelInProgress",
            "Cancelled",
            "Completed",
            "CreatingSnapshot",
            "Failed",
            "Initializing",
            "Replicating",
            "RollbackInProgress",
            "UpdatingSchema",
        ]
    }
}
impl AsRef<str> for SchemaExtensionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a log subscription, which tracks real-time data from a chosen log group to a
/// specified destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LogSubscription {
    /// <p>Identifier (ID) of the directory that you want to associate with the log
    /// subscription.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The name of the log group.</p>
    pub log_group_name: std::option::Option<std::string::String>,
    /// <p>The date and time that the log subscription was created.</p>
    pub subscription_created_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl LogSubscription {
    /// <p>Identifier (ID) of the directory that you want to associate with the log
    /// subscription.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The name of the log group.</p>
    pub fn log_group_name(&self) -> std::option::Option<&str> {
        self.log_group_name.as_deref()
    }
    /// <p>The date and time that the log subscription was created.</p>
    pub fn subscription_created_date_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.subscription_created_date_time.as_ref()
    }
}
impl std::fmt::Debug for LogSubscription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LogSubscription");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("log_group_name", &self.log_group_name);
        formatter.field(
            "subscription_created_date_time",
            &self.subscription_created_date_time,
        );
        formatter.finish()
    }
}
/// See [`LogSubscription`](crate::model::LogSubscription)
pub mod log_subscription {
    /// A builder for [`LogSubscription`](crate::model::LogSubscription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) log_group_name: std::option::Option<std::string::String>,
        pub(crate) subscription_created_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Identifier (ID) of the directory that you want to associate with the log
        /// subscription.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>Identifier (ID) of the directory that you want to associate with the log
        /// subscription.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The name of the log group.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group_name = Some(input.into());
            self
        }
        /// <p>The name of the log group.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_group_name = input;
            self
        }
        /// <p>The date and time that the log subscription was created.</p>
        pub fn subscription_created_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.subscription_created_date_time = Some(input);
            self
        }
        /// <p>The date and time that the log subscription was created.</p>
        pub fn set_subscription_created_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.subscription_created_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`LogSubscription`](crate::model::LogSubscription)
        pub fn build(self) -> crate::model::LogSubscription {
            crate::model::LogSubscription {
                directory_id: self.directory_id,
                log_group_name: self.log_group_name,
                subscription_created_date_time: self.subscription_created_date_time,
            }
        }
    }
}
impl LogSubscription {
    /// Creates a new builder-style object to manufacture [`LogSubscription`](crate::model::LogSubscription)
    pub fn builder() -> crate::model::log_subscription::Builder {
        crate::model::log_subscription::Builder::default()
    }
}

/// <p>Information about one or more IP address blocks.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IpRouteInfo {
    /// <p>Identifier (ID) of the directory associated with the IP addresses.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>IP address block in the <a>IpRoute</a>.</p>
    pub cidr_ip: std::option::Option<std::string::String>,
    /// <p>The status of the IP address block.</p>
    pub ip_route_status_msg: std::option::Option<crate::model::IpRouteStatusMsg>,
    /// <p>The date and time the address block was added to the directory.</p>
    pub added_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The reason for the IpRouteStatusMsg.</p>
    pub ip_route_status_reason: std::option::Option<std::string::String>,
    /// <p>Description of the <a>IpRouteInfo</a>.</p>
    pub description: std::option::Option<std::string::String>,
}
impl IpRouteInfo {
    /// <p>Identifier (ID) of the directory associated with the IP addresses.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>IP address block in the <a>IpRoute</a>.</p>
    pub fn cidr_ip(&self) -> std::option::Option<&str> {
        self.cidr_ip.as_deref()
    }
    /// <p>The status of the IP address block.</p>
    pub fn ip_route_status_msg(&self) -> std::option::Option<&crate::model::IpRouteStatusMsg> {
        self.ip_route_status_msg.as_ref()
    }
    /// <p>The date and time the address block was added to the directory.</p>
    pub fn added_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.added_date_time.as_ref()
    }
    /// <p>The reason for the IpRouteStatusMsg.</p>
    pub fn ip_route_status_reason(&self) -> std::option::Option<&str> {
        self.ip_route_status_reason.as_deref()
    }
    /// <p>Description of the <a>IpRouteInfo</a>.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for IpRouteInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IpRouteInfo");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("cidr_ip", &self.cidr_ip);
        formatter.field("ip_route_status_msg", &self.ip_route_status_msg);
        formatter.field("added_date_time", &self.added_date_time);
        formatter.field("ip_route_status_reason", &self.ip_route_status_reason);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`IpRouteInfo`](crate::model::IpRouteInfo)
pub mod ip_route_info {
    /// A builder for [`IpRouteInfo`](crate::model::IpRouteInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) cidr_ip: std::option::Option<std::string::String>,
        pub(crate) ip_route_status_msg: std::option::Option<crate::model::IpRouteStatusMsg>,
        pub(crate) added_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) ip_route_status_reason: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Identifier (ID) of the directory associated with the IP addresses.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>Identifier (ID) of the directory associated with the IP addresses.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>IP address block in the <a>IpRoute</a>.</p>
        pub fn cidr_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.cidr_ip = Some(input.into());
            self
        }
        /// <p>IP address block in the <a>IpRoute</a>.</p>
        pub fn set_cidr_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cidr_ip = input;
            self
        }
        /// <p>The status of the IP address block.</p>
        pub fn ip_route_status_msg(mut self, input: crate::model::IpRouteStatusMsg) -> Self {
            self.ip_route_status_msg = Some(input);
            self
        }
        /// <p>The status of the IP address block.</p>
        pub fn set_ip_route_status_msg(
            mut self,
            input: std::option::Option<crate::model::IpRouteStatusMsg>,
        ) -> Self {
            self.ip_route_status_msg = input;
            self
        }
        /// <p>The date and time the address block was added to the directory.</p>
        pub fn added_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.added_date_time = Some(input);
            self
        }
        /// <p>The date and time the address block was added to the directory.</p>
        pub fn set_added_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.added_date_time = input;
            self
        }
        /// <p>The reason for the IpRouteStatusMsg.</p>
        pub fn ip_route_status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_route_status_reason = Some(input.into());
            self
        }
        /// <p>The reason for the IpRouteStatusMsg.</p>
        pub fn set_ip_route_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ip_route_status_reason = input;
            self
        }
        /// <p>Description of the <a>IpRouteInfo</a>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Description of the <a>IpRouteInfo</a>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`IpRouteInfo`](crate::model::IpRouteInfo)
        pub fn build(self) -> crate::model::IpRouteInfo {
            crate::model::IpRouteInfo {
                directory_id: self.directory_id,
                cidr_ip: self.cidr_ip,
                ip_route_status_msg: self.ip_route_status_msg,
                added_date_time: self.added_date_time,
                ip_route_status_reason: self.ip_route_status_reason,
                description: self.description,
            }
        }
    }
}
impl IpRouteInfo {
    /// Creates a new builder-style object to manufacture [`IpRouteInfo`](crate::model::IpRouteInfo)
    pub fn builder() -> crate::model::ip_route_info::Builder {
        crate::model::ip_route_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IpRouteStatusMsg {
    #[allow(missing_docs)] // documentation missing in model
    AddFailed,
    #[allow(missing_docs)] // documentation missing in model
    Added,
    #[allow(missing_docs)] // documentation missing in model
    Adding,
    #[allow(missing_docs)] // documentation missing in model
    RemoveFailed,
    #[allow(missing_docs)] // documentation missing in model
    Removed,
    #[allow(missing_docs)] // documentation missing in model
    Removing,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IpRouteStatusMsg {
    fn from(s: &str) -> Self {
        match s {
            "AddFailed" => IpRouteStatusMsg::AddFailed,
            "Added" => IpRouteStatusMsg::Added,
            "Adding" => IpRouteStatusMsg::Adding,
            "RemoveFailed" => IpRouteStatusMsg::RemoveFailed,
            "Removed" => IpRouteStatusMsg::Removed,
            "Removing" => IpRouteStatusMsg::Removing,
            other => IpRouteStatusMsg::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IpRouteStatusMsg {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IpRouteStatusMsg::from(s))
    }
}
impl IpRouteStatusMsg {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IpRouteStatusMsg::AddFailed => "AddFailed",
            IpRouteStatusMsg::Added => "Added",
            IpRouteStatusMsg::Adding => "Adding",
            IpRouteStatusMsg::RemoveFailed => "RemoveFailed",
            IpRouteStatusMsg::Removed => "Removed",
            IpRouteStatusMsg::Removing => "Removing",
            IpRouteStatusMsg::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AddFailed",
            "Added",
            "Adding",
            "RemoveFailed",
            "Removed",
            "Removing",
        ]
    }
}
impl AsRef<str> for IpRouteStatusMsg {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains general information about a certificate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CertificateInfo {
    /// <p>The identifier of the certificate.</p>
    pub certificate_id: std::option::Option<std::string::String>,
    /// <p>The common name for the certificate.</p>
    pub common_name: std::option::Option<std::string::String>,
    /// <p>The state of the certificate.</p>
    pub state: std::option::Option<crate::model::CertificateState>,
    /// <p>The date and time when the certificate will expire.</p>
    pub expiry_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.</p>
    pub r#type: std::option::Option<crate::model::CertificateType>,
}
impl CertificateInfo {
    /// <p>The identifier of the certificate.</p>
    pub fn certificate_id(&self) -> std::option::Option<&str> {
        self.certificate_id.as_deref()
    }
    /// <p>The common name for the certificate.</p>
    pub fn common_name(&self) -> std::option::Option<&str> {
        self.common_name.as_deref()
    }
    /// <p>The state of the certificate.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::CertificateState> {
        self.state.as_ref()
    }
    /// <p>The date and time when the certificate will expire.</p>
    pub fn expiry_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.expiry_date_time.as_ref()
    }
    /// <p>The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::CertificateType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for CertificateInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CertificateInfo");
        formatter.field("certificate_id", &self.certificate_id);
        formatter.field("common_name", &self.common_name);
        formatter.field("state", &self.state);
        formatter.field("expiry_date_time", &self.expiry_date_time);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`CertificateInfo`](crate::model::CertificateInfo)
pub mod certificate_info {
    /// A builder for [`CertificateInfo`](crate::model::CertificateInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_id: std::option::Option<std::string::String>,
        pub(crate) common_name: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::CertificateState>,
        pub(crate) expiry_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) r#type: std::option::Option<crate::model::CertificateType>,
    }
    impl Builder {
        /// <p>The identifier of the certificate.</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_id = Some(input.into());
            self
        }
        /// <p>The identifier of the certificate.</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_id = input;
            self
        }
        /// <p>The common name for the certificate.</p>
        pub fn common_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.common_name = Some(input.into());
            self
        }
        /// <p>The common name for the certificate.</p>
        pub fn set_common_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.common_name = input;
            self
        }
        /// <p>The state of the certificate.</p>
        pub fn state(mut self, input: crate::model::CertificateState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the certificate.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::CertificateState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The date and time when the certificate will expire.</p>
        pub fn expiry_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.expiry_date_time = Some(input);
            self
        }
        /// <p>The date and time when the certificate will expire.</p>
        pub fn set_expiry_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.expiry_date_time = input;
            self
        }
        /// <p>The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.</p>
        pub fn r#type(mut self, input: crate::model::CertificateType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::CertificateType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`CertificateInfo`](crate::model::CertificateInfo)
        pub fn build(self) -> crate::model::CertificateInfo {
            crate::model::CertificateInfo {
                certificate_id: self.certificate_id,
                common_name: self.common_name,
                state: self.state,
                expiry_date_time: self.expiry_date_time,
                r#type: self.r#type,
            }
        }
    }
}
impl CertificateInfo {
    /// Creates a new builder-style object to manufacture [`CertificateInfo`](crate::model::CertificateInfo)
    pub fn builder() -> crate::model::certificate_info::Builder {
        crate::model::certificate_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CertificateState {
    #[allow(missing_docs)] // documentation missing in model
    DeregisterFailed,
    #[allow(missing_docs)] // documentation missing in model
    Deregistered,
    #[allow(missing_docs)] // documentation missing in model
    Deregistering,
    #[allow(missing_docs)] // documentation missing in model
    RegisterFailed,
    #[allow(missing_docs)] // documentation missing in model
    Registered,
    #[allow(missing_docs)] // documentation missing in model
    Registering,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CertificateState {
    fn from(s: &str) -> Self {
        match s {
            "DeregisterFailed" => CertificateState::DeregisterFailed,
            "Deregistered" => CertificateState::Deregistered,
            "Deregistering" => CertificateState::Deregistering,
            "RegisterFailed" => CertificateState::RegisterFailed,
            "Registered" => CertificateState::Registered,
            "Registering" => CertificateState::Registering,
            other => CertificateState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CertificateState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CertificateState::from(s))
    }
}
impl CertificateState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CertificateState::DeregisterFailed => "DeregisterFailed",
            CertificateState::Deregistered => "Deregistered",
            CertificateState::Deregistering => "Deregistering",
            CertificateState::RegisterFailed => "RegisterFailed",
            CertificateState::Registered => "Registered",
            CertificateState::Registering => "Registering",
            CertificateState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DeregisterFailed",
            "Deregistered",
            "Deregistering",
            "RegisterFailed",
            "Registered",
            "Registering",
        ]
    }
}
impl AsRef<str> for CertificateState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains manual snapshot limit information for a directory.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnapshotLimits {
    /// <p>The maximum number of manual snapshots allowed.</p>
    pub manual_snapshots_limit: std::option::Option<i32>,
    /// <p>The current number of manual snapshots of the directory.</p>
    pub manual_snapshots_current_count: std::option::Option<i32>,
    /// <p>Indicates if the manual snapshot limit has been reached.</p>
    pub manual_snapshots_limit_reached: bool,
}
impl SnapshotLimits {
    /// <p>The maximum number of manual snapshots allowed.</p>
    pub fn manual_snapshots_limit(&self) -> std::option::Option<i32> {
        self.manual_snapshots_limit
    }
    /// <p>The current number of manual snapshots of the directory.</p>
    pub fn manual_snapshots_current_count(&self) -> std::option::Option<i32> {
        self.manual_snapshots_current_count
    }
    /// <p>Indicates if the manual snapshot limit has been reached.</p>
    pub fn manual_snapshots_limit_reached(&self) -> bool {
        self.manual_snapshots_limit_reached
    }
}
impl std::fmt::Debug for SnapshotLimits {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnapshotLimits");
        formatter.field("manual_snapshots_limit", &self.manual_snapshots_limit);
        formatter.field(
            "manual_snapshots_current_count",
            &self.manual_snapshots_current_count,
        );
        formatter.field(
            "manual_snapshots_limit_reached",
            &self.manual_snapshots_limit_reached,
        );
        formatter.finish()
    }
}
/// See [`SnapshotLimits`](crate::model::SnapshotLimits)
pub mod snapshot_limits {
    /// A builder for [`SnapshotLimits`](crate::model::SnapshotLimits)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) manual_snapshots_limit: std::option::Option<i32>,
        pub(crate) manual_snapshots_current_count: std::option::Option<i32>,
        pub(crate) manual_snapshots_limit_reached: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The maximum number of manual snapshots allowed.</p>
        pub fn manual_snapshots_limit(mut self, input: i32) -> Self {
            self.manual_snapshots_limit = Some(input);
            self
        }
        /// <p>The maximum number of manual snapshots allowed.</p>
        pub fn set_manual_snapshots_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.manual_snapshots_limit = input;
            self
        }
        /// <p>The current number of manual snapshots of the directory.</p>
        pub fn manual_snapshots_current_count(mut self, input: i32) -> Self {
            self.manual_snapshots_current_count = Some(input);
            self
        }
        /// <p>The current number of manual snapshots of the directory.</p>
        pub fn set_manual_snapshots_current_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.manual_snapshots_current_count = input;
            self
        }
        /// <p>Indicates if the manual snapshot limit has been reached.</p>
        pub fn manual_snapshots_limit_reached(mut self, input: bool) -> Self {
            self.manual_snapshots_limit_reached = Some(input);
            self
        }
        /// <p>Indicates if the manual snapshot limit has been reached.</p>
        pub fn set_manual_snapshots_limit_reached(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.manual_snapshots_limit_reached = input;
            self
        }
        /// Consumes the builder and constructs a [`SnapshotLimits`](crate::model::SnapshotLimits)
        pub fn build(self) -> crate::model::SnapshotLimits {
            crate::model::SnapshotLimits {
                manual_snapshots_limit: self.manual_snapshots_limit,
                manual_snapshots_current_count: self.manual_snapshots_current_count,
                manual_snapshots_limit_reached: self
                    .manual_snapshots_limit_reached
                    .unwrap_or_default(),
            }
        }
    }
}
impl SnapshotLimits {
    /// Creates a new builder-style object to manufacture [`SnapshotLimits`](crate::model::SnapshotLimits)
    pub fn builder() -> crate::model::snapshot_limits::Builder {
        crate::model::snapshot_limits::Builder::default()
    }
}

/// <p>Contains directory limit information for a Region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DirectoryLimits {
    /// <p>The maximum number of cloud directories allowed in the Region.</p>
    pub cloud_only_directories_limit: std::option::Option<i32>,
    /// <p>The current number of cloud directories in the Region.</p>
    pub cloud_only_directories_current_count: std::option::Option<i32>,
    /// <p>Indicates if the cloud directory limit has been reached.</p>
    pub cloud_only_directories_limit_reached: bool,
    /// <p>The maximum number of Managed Microsoft AD directories allowed in the region.</p>
    pub cloud_only_microsoft_ad_limit: std::option::Option<i32>,
    /// <p>The current number of Managed Microsoft AD directories in the region.</p>
    pub cloud_only_microsoft_ad_current_count: std::option::Option<i32>,
    /// <p>Indicates if the Managed Microsoft AD directory limit has been reached.</p>
    pub cloud_only_microsoft_ad_limit_reached: bool,
    /// <p>The maximum number of connected directories allowed in the Region.</p>
    pub connected_directories_limit: std::option::Option<i32>,
    /// <p>The current number of connected directories in the Region.</p>
    pub connected_directories_current_count: std::option::Option<i32>,
    /// <p>Indicates if the connected directory limit has been reached.</p>
    pub connected_directories_limit_reached: bool,
}
impl DirectoryLimits {
    /// <p>The maximum number of cloud directories allowed in the Region.</p>
    pub fn cloud_only_directories_limit(&self) -> std::option::Option<i32> {
        self.cloud_only_directories_limit
    }
    /// <p>The current number of cloud directories in the Region.</p>
    pub fn cloud_only_directories_current_count(&self) -> std::option::Option<i32> {
        self.cloud_only_directories_current_count
    }
    /// <p>Indicates if the cloud directory limit has been reached.</p>
    pub fn cloud_only_directories_limit_reached(&self) -> bool {
        self.cloud_only_directories_limit_reached
    }
    /// <p>The maximum number of Managed Microsoft AD directories allowed in the region.</p>
    pub fn cloud_only_microsoft_ad_limit(&self) -> std::option::Option<i32> {
        self.cloud_only_microsoft_ad_limit
    }
    /// <p>The current number of Managed Microsoft AD directories in the region.</p>
    pub fn cloud_only_microsoft_ad_current_count(&self) -> std::option::Option<i32> {
        self.cloud_only_microsoft_ad_current_count
    }
    /// <p>Indicates if the Managed Microsoft AD directory limit has been reached.</p>
    pub fn cloud_only_microsoft_ad_limit_reached(&self) -> bool {
        self.cloud_only_microsoft_ad_limit_reached
    }
    /// <p>The maximum number of connected directories allowed in the Region.</p>
    pub fn connected_directories_limit(&self) -> std::option::Option<i32> {
        self.connected_directories_limit
    }
    /// <p>The current number of connected directories in the Region.</p>
    pub fn connected_directories_current_count(&self) -> std::option::Option<i32> {
        self.connected_directories_current_count
    }
    /// <p>Indicates if the connected directory limit has been reached.</p>
    pub fn connected_directories_limit_reached(&self) -> bool {
        self.connected_directories_limit_reached
    }
}
impl std::fmt::Debug for DirectoryLimits {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DirectoryLimits");
        formatter.field(
            "cloud_only_directories_limit",
            &self.cloud_only_directories_limit,
        );
        formatter.field(
            "cloud_only_directories_current_count",
            &self.cloud_only_directories_current_count,
        );
        formatter.field(
            "cloud_only_directories_limit_reached",
            &self.cloud_only_directories_limit_reached,
        );
        formatter.field(
            "cloud_only_microsoft_ad_limit",
            &self.cloud_only_microsoft_ad_limit,
        );
        formatter.field(
            "cloud_only_microsoft_ad_current_count",
            &self.cloud_only_microsoft_ad_current_count,
        );
        formatter.field(
            "cloud_only_microsoft_ad_limit_reached",
            &self.cloud_only_microsoft_ad_limit_reached,
        );
        formatter.field(
            "connected_directories_limit",
            &self.connected_directories_limit,
        );
        formatter.field(
            "connected_directories_current_count",
            &self.connected_directories_current_count,
        );
        formatter.field(
            "connected_directories_limit_reached",
            &self.connected_directories_limit_reached,
        );
        formatter.finish()
    }
}
/// See [`DirectoryLimits`](crate::model::DirectoryLimits)
pub mod directory_limits {
    /// A builder for [`DirectoryLimits`](crate::model::DirectoryLimits)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_only_directories_limit: std::option::Option<i32>,
        pub(crate) cloud_only_directories_current_count: std::option::Option<i32>,
        pub(crate) cloud_only_directories_limit_reached: std::option::Option<bool>,
        pub(crate) cloud_only_microsoft_ad_limit: std::option::Option<i32>,
        pub(crate) cloud_only_microsoft_ad_current_count: std::option::Option<i32>,
        pub(crate) cloud_only_microsoft_ad_limit_reached: std::option::Option<bool>,
        pub(crate) connected_directories_limit: std::option::Option<i32>,
        pub(crate) connected_directories_current_count: std::option::Option<i32>,
        pub(crate) connected_directories_limit_reached: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The maximum number of cloud directories allowed in the Region.</p>
        pub fn cloud_only_directories_limit(mut self, input: i32) -> Self {
            self.cloud_only_directories_limit = Some(input);
            self
        }
        /// <p>The maximum number of cloud directories allowed in the Region.</p>
        pub fn set_cloud_only_directories_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.cloud_only_directories_limit = input;
            self
        }
        /// <p>The current number of cloud directories in the Region.</p>
        pub fn cloud_only_directories_current_count(mut self, input: i32) -> Self {
            self.cloud_only_directories_current_count = Some(input);
            self
        }
        /// <p>The current number of cloud directories in the Region.</p>
        pub fn set_cloud_only_directories_current_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.cloud_only_directories_current_count = input;
            self
        }
        /// <p>Indicates if the cloud directory limit has been reached.</p>
        pub fn cloud_only_directories_limit_reached(mut self, input: bool) -> Self {
            self.cloud_only_directories_limit_reached = Some(input);
            self
        }
        /// <p>Indicates if the cloud directory limit has been reached.</p>
        pub fn set_cloud_only_directories_limit_reached(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.cloud_only_directories_limit_reached = input;
            self
        }
        /// <p>The maximum number of Managed Microsoft AD directories allowed in the region.</p>
        pub fn cloud_only_microsoft_ad_limit(mut self, input: i32) -> Self {
            self.cloud_only_microsoft_ad_limit = Some(input);
            self
        }
        /// <p>The maximum number of Managed Microsoft AD directories allowed in the region.</p>
        pub fn set_cloud_only_microsoft_ad_limit(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.cloud_only_microsoft_ad_limit = input;
            self
        }
        /// <p>The current number of Managed Microsoft AD directories in the region.</p>
        pub fn cloud_only_microsoft_ad_current_count(mut self, input: i32) -> Self {
            self.cloud_only_microsoft_ad_current_count = Some(input);
            self
        }
        /// <p>The current number of Managed Microsoft AD directories in the region.</p>
        pub fn set_cloud_only_microsoft_ad_current_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.cloud_only_microsoft_ad_current_count = input;
            self
        }
        /// <p>Indicates if the Managed Microsoft AD directory limit has been reached.</p>
        pub fn cloud_only_microsoft_ad_limit_reached(mut self, input: bool) -> Self {
            self.cloud_only_microsoft_ad_limit_reached = Some(input);
            self
        }
        /// <p>Indicates if the Managed Microsoft AD directory limit has been reached.</p>
        pub fn set_cloud_only_microsoft_ad_limit_reached(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.cloud_only_microsoft_ad_limit_reached = input;
            self
        }
        /// <p>The maximum number of connected directories allowed in the Region.</p>
        pub fn connected_directories_limit(mut self, input: i32) -> Self {
            self.connected_directories_limit = Some(input);
            self
        }
        /// <p>The maximum number of connected directories allowed in the Region.</p>
        pub fn set_connected_directories_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.connected_directories_limit = input;
            self
        }
        /// <p>The current number of connected directories in the Region.</p>
        pub fn connected_directories_current_count(mut self, input: i32) -> Self {
            self.connected_directories_current_count = Some(input);
            self
        }
        /// <p>The current number of connected directories in the Region.</p>
        pub fn set_connected_directories_current_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.connected_directories_current_count = input;
            self
        }
        /// <p>Indicates if the connected directory limit has been reached.</p>
        pub fn connected_directories_limit_reached(mut self, input: bool) -> Self {
            self.connected_directories_limit_reached = Some(input);
            self
        }
        /// <p>Indicates if the connected directory limit has been reached.</p>
        pub fn set_connected_directories_limit_reached(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.connected_directories_limit_reached = input;
            self
        }
        /// Consumes the builder and constructs a [`DirectoryLimits`](crate::model::DirectoryLimits)
        pub fn build(self) -> crate::model::DirectoryLimits {
            crate::model::DirectoryLimits {
                cloud_only_directories_limit: self.cloud_only_directories_limit,
                cloud_only_directories_current_count: self.cloud_only_directories_current_count,
                cloud_only_directories_limit_reached: self
                    .cloud_only_directories_limit_reached
                    .unwrap_or_default(),
                cloud_only_microsoft_ad_limit: self.cloud_only_microsoft_ad_limit,
                cloud_only_microsoft_ad_current_count: self.cloud_only_microsoft_ad_current_count,
                cloud_only_microsoft_ad_limit_reached: self
                    .cloud_only_microsoft_ad_limit_reached
                    .unwrap_or_default(),
                connected_directories_limit: self.connected_directories_limit,
                connected_directories_current_count: self.connected_directories_current_count,
                connected_directories_limit_reached: self
                    .connected_directories_limit_reached
                    .unwrap_or_default(),
            }
        }
    }
}
impl DirectoryLimits {
    /// Creates a new builder-style object to manufacture [`DirectoryLimits`](crate::model::DirectoryLimits)
    pub fn builder() -> crate::model::directory_limits::Builder {
        crate::model::directory_limits::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LdapsType {
    #[allow(missing_docs)] // documentation missing in model
    Client,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LdapsType {
    fn from(s: &str) -> Self {
        match s {
            "Client" => LdapsType::Client,
            other => LdapsType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LdapsType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LdapsType::from(s))
    }
}
impl LdapsType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LdapsType::Client => "Client",
            LdapsType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Client"]
    }
}
impl AsRef<str> for LdapsType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ClientAuthenticationType {
    #[allow(missing_docs)] // documentation missing in model
    SmartCard,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ClientAuthenticationType {
    fn from(s: &str) -> Self {
        match s {
            "SmartCard" => ClientAuthenticationType::SmartCard,
            other => ClientAuthenticationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ClientAuthenticationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ClientAuthenticationType::from(s))
    }
}
impl ClientAuthenticationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ClientAuthenticationType::SmartCard => "SmartCard",
            ClientAuthenticationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SmartCard"]
    }
}
impl AsRef<str> for ClientAuthenticationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a trust relationship between an Managed Microsoft AD directory and an external
/// domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Trust {
    /// <p>The Directory ID of the Amazon Web Services directory involved in the trust relationship.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The unique ID of the trust relationship.</p>
    pub trust_id: std::option::Option<std::string::String>,
    /// <p>The Fully Qualified Domain Name (FQDN) of the external domain involved in the trust
    /// relationship.</p>
    pub remote_domain_name: std::option::Option<std::string::String>,
    /// <p>The trust relationship type. <code>Forest</code> is the default.</p>
    pub trust_type: std::option::Option<crate::model::TrustType>,
    /// <p>The trust relationship direction.</p>
    pub trust_direction: std::option::Option<crate::model::TrustDirection>,
    /// <p>The trust relationship state.</p>
    pub trust_state: std::option::Option<crate::model::TrustState>,
    /// <p>The date and time that the trust relationship was created.</p>
    pub created_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the trust relationship was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the TrustState was last updated.</p>
    pub state_last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The reason for the TrustState.</p>
    pub trust_state_reason: std::option::Option<std::string::String>,
    /// <p>Current state of selective authentication for the trust.</p>
    pub selective_auth: std::option::Option<crate::model::SelectiveAuth>,
}
impl Trust {
    /// <p>The Directory ID of the Amazon Web Services directory involved in the trust relationship.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The unique ID of the trust relationship.</p>
    pub fn trust_id(&self) -> std::option::Option<&str> {
        self.trust_id.as_deref()
    }
    /// <p>The Fully Qualified Domain Name (FQDN) of the external domain involved in the trust
    /// relationship.</p>
    pub fn remote_domain_name(&self) -> std::option::Option<&str> {
        self.remote_domain_name.as_deref()
    }
    /// <p>The trust relationship type. <code>Forest</code> is the default.</p>
    pub fn trust_type(&self) -> std::option::Option<&crate::model::TrustType> {
        self.trust_type.as_ref()
    }
    /// <p>The trust relationship direction.</p>
    pub fn trust_direction(&self) -> std::option::Option<&crate::model::TrustDirection> {
        self.trust_direction.as_ref()
    }
    /// <p>The trust relationship state.</p>
    pub fn trust_state(&self) -> std::option::Option<&crate::model::TrustState> {
        self.trust_state.as_ref()
    }
    /// <p>The date and time that the trust relationship was created.</p>
    pub fn created_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_date_time.as_ref()
    }
    /// <p>The date and time that the trust relationship was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
    /// <p>The date and time that the TrustState was last updated.</p>
    pub fn state_last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.state_last_updated_date_time.as_ref()
    }
    /// <p>The reason for the TrustState.</p>
    pub fn trust_state_reason(&self) -> std::option::Option<&str> {
        self.trust_state_reason.as_deref()
    }
    /// <p>Current state of selective authentication for the trust.</p>
    pub fn selective_auth(&self) -> std::option::Option<&crate::model::SelectiveAuth> {
        self.selective_auth.as_ref()
    }
}
impl std::fmt::Debug for Trust {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Trust");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("trust_id", &self.trust_id);
        formatter.field("remote_domain_name", &self.remote_domain_name);
        formatter.field("trust_type", &self.trust_type);
        formatter.field("trust_direction", &self.trust_direction);
        formatter.field("trust_state", &self.trust_state);
        formatter.field("created_date_time", &self.created_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field(
            "state_last_updated_date_time",
            &self.state_last_updated_date_time,
        );
        formatter.field("trust_state_reason", &self.trust_state_reason);
        formatter.field("selective_auth", &self.selective_auth);
        formatter.finish()
    }
}
/// See [`Trust`](crate::model::Trust)
pub mod trust {
    /// A builder for [`Trust`](crate::model::Trust)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) trust_id: std::option::Option<std::string::String>,
        pub(crate) remote_domain_name: std::option::Option<std::string::String>,
        pub(crate) trust_type: std::option::Option<crate::model::TrustType>,
        pub(crate) trust_direction: std::option::Option<crate::model::TrustDirection>,
        pub(crate) trust_state: std::option::Option<crate::model::TrustState>,
        pub(crate) created_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) state_last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) trust_state_reason: std::option::Option<std::string::String>,
        pub(crate) selective_auth: std::option::Option<crate::model::SelectiveAuth>,
    }
    impl Builder {
        /// <p>The Directory ID of the Amazon Web Services directory involved in the trust relationship.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The Directory ID of the Amazon Web Services directory involved in the trust relationship.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The unique ID of the trust relationship.</p>
        pub fn trust_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.trust_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the trust relationship.</p>
        pub fn set_trust_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trust_id = input;
            self
        }
        /// <p>The Fully Qualified Domain Name (FQDN) of the external domain involved in the trust
        /// relationship.</p>
        pub fn remote_domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.remote_domain_name = Some(input.into());
            self
        }
        /// <p>The Fully Qualified Domain Name (FQDN) of the external domain involved in the trust
        /// relationship.</p>
        pub fn set_remote_domain_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.remote_domain_name = input;
            self
        }
        /// <p>The trust relationship type. <code>Forest</code> is the default.</p>
        pub fn trust_type(mut self, input: crate::model::TrustType) -> Self {
            self.trust_type = Some(input);
            self
        }
        /// <p>The trust relationship type. <code>Forest</code> is the default.</p>
        pub fn set_trust_type(
            mut self,
            input: std::option::Option<crate::model::TrustType>,
        ) -> Self {
            self.trust_type = input;
            self
        }
        /// <p>The trust relationship direction.</p>
        pub fn trust_direction(mut self, input: crate::model::TrustDirection) -> Self {
            self.trust_direction = Some(input);
            self
        }
        /// <p>The trust relationship direction.</p>
        pub fn set_trust_direction(
            mut self,
            input: std::option::Option<crate::model::TrustDirection>,
        ) -> Self {
            self.trust_direction = input;
            self
        }
        /// <p>The trust relationship state.</p>
        pub fn trust_state(mut self, input: crate::model::TrustState) -> Self {
            self.trust_state = Some(input);
            self
        }
        /// <p>The trust relationship state.</p>
        pub fn set_trust_state(
            mut self,
            input: std::option::Option<crate::model::TrustState>,
        ) -> Self {
            self.trust_state = input;
            self
        }
        /// <p>The date and time that the trust relationship was created.</p>
        pub fn created_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_date_time = Some(input);
            self
        }
        /// <p>The date and time that the trust relationship was created.</p>
        pub fn set_created_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_date_time = input;
            self
        }
        /// <p>The date and time that the trust relationship was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time that the trust relationship was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// <p>The date and time that the TrustState was last updated.</p>
        pub fn state_last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.state_last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time that the TrustState was last updated.</p>
        pub fn set_state_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.state_last_updated_date_time = input;
            self
        }
        /// <p>The reason for the TrustState.</p>
        pub fn trust_state_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.trust_state_reason = Some(input.into());
            self
        }
        /// <p>The reason for the TrustState.</p>
        pub fn set_trust_state_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.trust_state_reason = input;
            self
        }
        /// <p>Current state of selective authentication for the trust.</p>
        pub fn selective_auth(mut self, input: crate::model::SelectiveAuth) -> Self {
            self.selective_auth = Some(input);
            self
        }
        /// <p>Current state of selective authentication for the trust.</p>
        pub fn set_selective_auth(
            mut self,
            input: std::option::Option<crate::model::SelectiveAuth>,
        ) -> Self {
            self.selective_auth = input;
            self
        }
        /// Consumes the builder and constructs a [`Trust`](crate::model::Trust)
        pub fn build(self) -> crate::model::Trust {
            crate::model::Trust {
                directory_id: self.directory_id,
                trust_id: self.trust_id,
                remote_domain_name: self.remote_domain_name,
                trust_type: self.trust_type,
                trust_direction: self.trust_direction,
                trust_state: self.trust_state,
                created_date_time: self.created_date_time,
                last_updated_date_time: self.last_updated_date_time,
                state_last_updated_date_time: self.state_last_updated_date_time,
                trust_state_reason: self.trust_state_reason,
                selective_auth: self.selective_auth,
            }
        }
    }
}
impl Trust {
    /// Creates a new builder-style object to manufacture [`Trust`](crate::model::Trust)
    pub fn builder() -> crate::model::trust::Builder {
        crate::model::trust::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TrustState {
    #[allow(missing_docs)] // documentation missing in model
    Created,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    UpdateFailed,
    #[allow(missing_docs)] // documentation missing in model
    Updated,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    #[allow(missing_docs)] // documentation missing in model
    Verified,
    #[allow(missing_docs)] // documentation missing in model
    VerifyFailed,
    #[allow(missing_docs)] // documentation missing in model
    Verifying,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TrustState {
    fn from(s: &str) -> Self {
        match s {
            "Created" => TrustState::Created,
            "Creating" => TrustState::Creating,
            "Deleted" => TrustState::Deleted,
            "Deleting" => TrustState::Deleting,
            "Failed" => TrustState::Failed,
            "UpdateFailed" => TrustState::UpdateFailed,
            "Updated" => TrustState::Updated,
            "Updating" => TrustState::Updating,
            "Verified" => TrustState::Verified,
            "VerifyFailed" => TrustState::VerifyFailed,
            "Verifying" => TrustState::Verifying,
            other => TrustState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TrustState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TrustState::from(s))
    }
}
impl TrustState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TrustState::Created => "Created",
            TrustState::Creating => "Creating",
            TrustState::Deleted => "Deleted",
            TrustState::Deleting => "Deleting",
            TrustState::Failed => "Failed",
            TrustState::UpdateFailed => "UpdateFailed",
            TrustState::Updated => "Updated",
            TrustState::Updating => "Updating",
            TrustState::Verified => "Verified",
            TrustState::VerifyFailed => "VerifyFailed",
            TrustState::Verifying => "Verifying",
            TrustState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Created",
            "Creating",
            "Deleted",
            "Deleting",
            "Failed",
            "UpdateFailed",
            "Updated",
            "Updating",
            "Verified",
            "VerifyFailed",
            "Verifying",
        ]
    }
}
impl AsRef<str> for TrustState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TrustDirection {
    #[allow(missing_docs)] // documentation missing in model
    OneWayIncoming,
    #[allow(missing_docs)] // documentation missing in model
    OneWayOutgoing,
    #[allow(missing_docs)] // documentation missing in model
    TwoWay,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TrustDirection {
    fn from(s: &str) -> Self {
        match s {
            "One-Way: Incoming" => TrustDirection::OneWayIncoming,
            "One-Way: Outgoing" => TrustDirection::OneWayOutgoing,
            "Two-Way" => TrustDirection::TwoWay,
            other => TrustDirection::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TrustDirection {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TrustDirection::from(s))
    }
}
impl TrustDirection {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TrustDirection::OneWayIncoming => "One-Way: Incoming",
            TrustDirection::OneWayOutgoing => "One-Way: Outgoing",
            TrustDirection::TwoWay => "Two-Way",
            TrustDirection::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["One-Way: Incoming", "One-Way: Outgoing", "Two-Way"]
    }
}
impl AsRef<str> for TrustDirection {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TrustType {
    #[allow(missing_docs)] // documentation missing in model
    External,
    #[allow(missing_docs)] // documentation missing in model
    Forest,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TrustType {
    fn from(s: &str) -> Self {
        match s {
            "External" => TrustType::External,
            "Forest" => TrustType::Forest,
            other => TrustType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TrustType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TrustType::from(s))
    }
}
impl TrustType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TrustType::External => "External",
            TrustType::Forest => "Forest",
            TrustType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["External", "Forest"]
    }
}
impl AsRef<str> for TrustType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a directory snapshot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Snapshot {
    /// <p>The directory identifier.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The snapshot identifier.</p>
    pub snapshot_id: std::option::Option<std::string::String>,
    /// <p>The snapshot type.</p>
    pub r#type: std::option::Option<crate::model::SnapshotType>,
    /// <p>The descriptive name of the snapshot.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The snapshot status.</p>
    pub status: std::option::Option<crate::model::SnapshotStatus>,
    /// <p>The date and time that the snapshot was taken.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl Snapshot {
    /// <p>The directory identifier.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The snapshot identifier.</p>
    pub fn snapshot_id(&self) -> std::option::Option<&str> {
        self.snapshot_id.as_deref()
    }
    /// <p>The snapshot type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::SnapshotType> {
        self.r#type.as_ref()
    }
    /// <p>The descriptive name of the snapshot.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The snapshot status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::SnapshotStatus> {
        self.status.as_ref()
    }
    /// <p>The date and time that the snapshot was taken.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
}
impl std::fmt::Debug for Snapshot {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Snapshot");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("snapshot_id", &self.snapshot_id);
        formatter.field("r#type", &self.r#type);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("start_time", &self.start_time);
        formatter.finish()
    }
}
/// See [`Snapshot`](crate::model::Snapshot)
pub mod snapshot {
    /// A builder for [`Snapshot`](crate::model::Snapshot)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::SnapshotType>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::SnapshotStatus>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The directory identifier.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The directory identifier.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The snapshot identifier.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The snapshot identifier.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// <p>The snapshot type.</p>
        pub fn r#type(mut self, input: crate::model::SnapshotType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The snapshot type.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::SnapshotType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The descriptive name of the snapshot.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The descriptive name of the snapshot.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The snapshot status.</p>
        pub fn status(mut self, input: crate::model::SnapshotStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The snapshot status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SnapshotStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time that the snapshot was taken.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The date and time that the snapshot was taken.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Snapshot`](crate::model::Snapshot)
        pub fn build(self) -> crate::model::Snapshot {
            crate::model::Snapshot {
                directory_id: self.directory_id,
                snapshot_id: self.snapshot_id,
                r#type: self.r#type,
                name: self.name,
                status: self.status,
                start_time: self.start_time,
            }
        }
    }
}
impl Snapshot {
    /// Creates a new builder-style object to manufacture [`Snapshot`](crate::model::Snapshot)
    pub fn builder() -> crate::model::snapshot::Builder {
        crate::model::snapshot::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SnapshotStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SnapshotStatus {
    fn from(s: &str) -> Self {
        match s {
            "Completed" => SnapshotStatus::Completed,
            "Creating" => SnapshotStatus::Creating,
            "Failed" => SnapshotStatus::Failed,
            other => SnapshotStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SnapshotStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SnapshotStatus::from(s))
    }
}
impl SnapshotStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SnapshotStatus::Completed => "Completed",
            SnapshotStatus::Creating => "Creating",
            SnapshotStatus::Failed => "Failed",
            SnapshotStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Completed", "Creating", "Failed"]
    }
}
impl AsRef<str> for SnapshotStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SnapshotType {
    #[allow(missing_docs)] // documentation missing in model
    Auto,
    #[allow(missing_docs)] // documentation missing in model
    Manual,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SnapshotType {
    fn from(s: &str) -> Self {
        match s {
            "Auto" => SnapshotType::Auto,
            "Manual" => SnapshotType::Manual,
            other => SnapshotType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SnapshotType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SnapshotType::from(s))
    }
}
impl SnapshotType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SnapshotType::Auto => "Auto",
            SnapshotType::Manual => "Manual",
            SnapshotType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Auto", "Manual"]
    }
}
impl AsRef<str> for SnapshotType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details about the shared directory in the directory owner account for which the share
/// request in the directory consumer account has been accepted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SharedDirectory {
    /// <p>Identifier of the directory owner account, which contains the directory that has been
    /// shared to the consumer account.</p>
    pub owner_account_id: std::option::Option<std::string::String>,
    /// <p>Identifier of the directory in the directory owner account. </p>
    pub owner_directory_id: std::option::Option<std::string::String>,
    /// <p>The method used when sharing a directory to determine whether the directory should be
    /// shared within your Amazon Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services account by
    /// sending a shared directory request (<code>HANDSHAKE</code>).</p>
    pub share_method: std::option::Option<crate::model::ShareMethod>,
    /// <p>Identifier of the directory consumer account that has access to the shared directory
    /// (<code>OwnerDirectoryId</code>) in the directory owner account.</p>
    pub shared_account_id: std::option::Option<std::string::String>,
    /// <p>Identifier of the shared directory in the directory consumer account. This identifier is
    /// different for each directory owner account.</p>
    pub shared_directory_id: std::option::Option<std::string::String>,
    /// <p>Current directory status of the shared Managed Microsoft AD directory.</p>
    pub share_status: std::option::Option<crate::model::ShareStatus>,
    /// <p>A directory share request that is sent by the directory owner to the directory consumer.
    /// The request includes a typed message to help the directory consumer administrator determine
    /// whether to approve or reject the share invitation.</p>
    pub share_notes: std::option::Option<std::string::String>,
    /// <p>The date and time that the shared directory was created.</p>
    pub created_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the shared directory was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl SharedDirectory {
    /// <p>Identifier of the directory owner account, which contains the directory that has been
    /// shared to the consumer account.</p>
    pub fn owner_account_id(&self) -> std::option::Option<&str> {
        self.owner_account_id.as_deref()
    }
    /// <p>Identifier of the directory in the directory owner account. </p>
    pub fn owner_directory_id(&self) -> std::option::Option<&str> {
        self.owner_directory_id.as_deref()
    }
    /// <p>The method used when sharing a directory to determine whether the directory should be
    /// shared within your Amazon Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services account by
    /// sending a shared directory request (<code>HANDSHAKE</code>).</p>
    pub fn share_method(&self) -> std::option::Option<&crate::model::ShareMethod> {
        self.share_method.as_ref()
    }
    /// <p>Identifier of the directory consumer account that has access to the shared directory
    /// (<code>OwnerDirectoryId</code>) in the directory owner account.</p>
    pub fn shared_account_id(&self) -> std::option::Option<&str> {
        self.shared_account_id.as_deref()
    }
    /// <p>Identifier of the shared directory in the directory consumer account. This identifier is
    /// different for each directory owner account.</p>
    pub fn shared_directory_id(&self) -> std::option::Option<&str> {
        self.shared_directory_id.as_deref()
    }
    /// <p>Current directory status of the shared Managed Microsoft AD directory.</p>
    pub fn share_status(&self) -> std::option::Option<&crate::model::ShareStatus> {
        self.share_status.as_ref()
    }
    /// <p>A directory share request that is sent by the directory owner to the directory consumer.
    /// The request includes a typed message to help the directory consumer administrator determine
    /// whether to approve or reject the share invitation.</p>
    pub fn share_notes(&self) -> std::option::Option<&str> {
        self.share_notes.as_deref()
    }
    /// <p>The date and time that the shared directory was created.</p>
    pub fn created_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_date_time.as_ref()
    }
    /// <p>The date and time that the shared directory was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
}
impl std::fmt::Debug for SharedDirectory {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SharedDirectory");
        formatter.field("owner_account_id", &self.owner_account_id);
        formatter.field("owner_directory_id", &self.owner_directory_id);
        formatter.field("share_method", &self.share_method);
        formatter.field("shared_account_id", &self.shared_account_id);
        formatter.field("shared_directory_id", &self.shared_directory_id);
        formatter.field("share_status", &self.share_status);
        formatter.field("share_notes", &"*** Sensitive Data Redacted ***");
        formatter.field("created_date_time", &self.created_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`SharedDirectory`](crate::model::SharedDirectory)
pub mod shared_directory {
    /// A builder for [`SharedDirectory`](crate::model::SharedDirectory)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_account_id: std::option::Option<std::string::String>,
        pub(crate) owner_directory_id: std::option::Option<std::string::String>,
        pub(crate) share_method: std::option::Option<crate::model::ShareMethod>,
        pub(crate) shared_account_id: std::option::Option<std::string::String>,
        pub(crate) shared_directory_id: std::option::Option<std::string::String>,
        pub(crate) share_status: std::option::Option<crate::model::ShareStatus>,
        pub(crate) share_notes: std::option::Option<std::string::String>,
        pub(crate) created_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Identifier of the directory owner account, which contains the directory that has been
        /// shared to the consumer account.</p>
        pub fn owner_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account_id = Some(input.into());
            self
        }
        /// <p>Identifier of the directory owner account, which contains the directory that has been
        /// shared to the consumer account.</p>
        pub fn set_owner_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account_id = input;
            self
        }
        /// <p>Identifier of the directory in the directory owner account. </p>
        pub fn owner_directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_directory_id = Some(input.into());
            self
        }
        /// <p>Identifier of the directory in the directory owner account. </p>
        pub fn set_owner_directory_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_directory_id = input;
            self
        }
        /// <p>The method used when sharing a directory to determine whether the directory should be
        /// shared within your Amazon Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services account by
        /// sending a shared directory request (<code>HANDSHAKE</code>).</p>
        pub fn share_method(mut self, input: crate::model::ShareMethod) -> Self {
            self.share_method = Some(input);
            self
        }
        /// <p>The method used when sharing a directory to determine whether the directory should be
        /// shared within your Amazon Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services account by
        /// sending a shared directory request (<code>HANDSHAKE</code>).</p>
        pub fn set_share_method(
            mut self,
            input: std::option::Option<crate::model::ShareMethod>,
        ) -> Self {
            self.share_method = input;
            self
        }
        /// <p>Identifier of the directory consumer account that has access to the shared directory
        /// (<code>OwnerDirectoryId</code>) in the directory owner account.</p>
        pub fn shared_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.shared_account_id = Some(input.into());
            self
        }
        /// <p>Identifier of the directory consumer account that has access to the shared directory
        /// (<code>OwnerDirectoryId</code>) in the directory owner account.</p>
        pub fn set_shared_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.shared_account_id = input;
            self
        }
        /// <p>Identifier of the shared directory in the directory consumer account. This identifier is
        /// different for each directory owner account.</p>
        pub fn shared_directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.shared_directory_id = Some(input.into());
            self
        }
        /// <p>Identifier of the shared directory in the directory consumer account. This identifier is
        /// different for each directory owner account.</p>
        pub fn set_shared_directory_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.shared_directory_id = input;
            self
        }
        /// <p>Current directory status of the shared Managed Microsoft AD directory.</p>
        pub fn share_status(mut self, input: crate::model::ShareStatus) -> Self {
            self.share_status = Some(input);
            self
        }
        /// <p>Current directory status of the shared Managed Microsoft AD directory.</p>
        pub fn set_share_status(
            mut self,
            input: std::option::Option<crate::model::ShareStatus>,
        ) -> Self {
            self.share_status = input;
            self
        }
        /// <p>A directory share request that is sent by the directory owner to the directory consumer.
        /// The request includes a typed message to help the directory consumer administrator determine
        /// whether to approve or reject the share invitation.</p>
        pub fn share_notes(mut self, input: impl Into<std::string::String>) -> Self {
            self.share_notes = Some(input.into());
            self
        }
        /// <p>A directory share request that is sent by the directory owner to the directory consumer.
        /// The request includes a typed message to help the directory consumer administrator determine
        /// whether to approve or reject the share invitation.</p>
        pub fn set_share_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.share_notes = input;
            self
        }
        /// <p>The date and time that the shared directory was created.</p>
        pub fn created_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_date_time = Some(input);
            self
        }
        /// <p>The date and time that the shared directory was created.</p>
        pub fn set_created_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_date_time = input;
            self
        }
        /// <p>The date and time that the shared directory was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time that the shared directory was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`SharedDirectory`](crate::model::SharedDirectory)
        pub fn build(self) -> crate::model::SharedDirectory {
            crate::model::SharedDirectory {
                owner_account_id: self.owner_account_id,
                owner_directory_id: self.owner_directory_id,
                share_method: self.share_method,
                shared_account_id: self.shared_account_id,
                shared_directory_id: self.shared_directory_id,
                share_status: self.share_status,
                share_notes: self.share_notes,
                created_date_time: self.created_date_time,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl SharedDirectory {
    /// Creates a new builder-style object to manufacture [`SharedDirectory`](crate::model::SharedDirectory)
    pub fn builder() -> crate::model::shared_directory::Builder {
        crate::model::shared_directory::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ShareStatus {
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    PendingAcceptance,
    #[allow(missing_docs)] // documentation missing in model
    RejectFailed,
    #[allow(missing_docs)] // documentation missing in model
    Rejected,
    #[allow(missing_docs)] // documentation missing in model
    Rejecting,
    #[allow(missing_docs)] // documentation missing in model
    ShareFailed,
    #[allow(missing_docs)] // documentation missing in model
    Shared,
    #[allow(missing_docs)] // documentation missing in model
    Sharing,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ShareStatus {
    fn from(s: &str) -> Self {
        match s {
            "Deleted" => ShareStatus::Deleted,
            "Deleting" => ShareStatus::Deleting,
            "PendingAcceptance" => ShareStatus::PendingAcceptance,
            "RejectFailed" => ShareStatus::RejectFailed,
            "Rejected" => ShareStatus::Rejected,
            "Rejecting" => ShareStatus::Rejecting,
            "ShareFailed" => ShareStatus::ShareFailed,
            "Shared" => ShareStatus::Shared,
            "Sharing" => ShareStatus::Sharing,
            other => ShareStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ShareStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ShareStatus::from(s))
    }
}
impl ShareStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ShareStatus::Deleted => "Deleted",
            ShareStatus::Deleting => "Deleting",
            ShareStatus::PendingAcceptance => "PendingAcceptance",
            ShareStatus::RejectFailed => "RejectFailed",
            ShareStatus::Rejected => "Rejected",
            ShareStatus::Rejecting => "Rejecting",
            ShareStatus::ShareFailed => "ShareFailed",
            ShareStatus::Shared => "Shared",
            ShareStatus::Sharing => "Sharing",
            ShareStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Deleted",
            "Deleting",
            "PendingAcceptance",
            "RejectFailed",
            "Rejected",
            "Rejecting",
            "ShareFailed",
            "Shared",
            "Sharing",
        ]
    }
}
impl AsRef<str> for ShareStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The replicated Region information for a directory.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegionDescription {
    /// <p>The identifier of the directory.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The name of the Region. For example, <code>us-east-1</code>.</p>
    pub region_name: std::option::Option<std::string::String>,
    /// <p>Specifies whether the Region is the primary Region or an additional Region.</p>
    pub region_type: std::option::Option<crate::model::RegionType>,
    /// <p>The status of the replication process for the specified Region.</p>
    pub status: std::option::Option<crate::model::DirectoryStage>,
    /// <p>Contains VPC information for the <a>CreateDirectory</a> or <a>CreateMicrosoftAD</a> operation.</p>
    pub vpc_settings: std::option::Option<crate::model::DirectoryVpcSettings>,
    /// <p>The desired number of domain controllers in the specified Region for the specified
    /// directory.</p>
    pub desired_number_of_domain_controllers: i32,
    /// <p>Specifies when the Region replication began.</p>
    pub launch_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the Region status was last updated.</p>
    pub status_last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the Region description was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl RegionDescription {
    /// <p>The identifier of the directory.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The name of the Region. For example, <code>us-east-1</code>.</p>
    pub fn region_name(&self) -> std::option::Option<&str> {
        self.region_name.as_deref()
    }
    /// <p>Specifies whether the Region is the primary Region or an additional Region.</p>
    pub fn region_type(&self) -> std::option::Option<&crate::model::RegionType> {
        self.region_type.as_ref()
    }
    /// <p>The status of the replication process for the specified Region.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DirectoryStage> {
        self.status.as_ref()
    }
    /// <p>Contains VPC information for the <a>CreateDirectory</a> or <a>CreateMicrosoftAD</a> operation.</p>
    pub fn vpc_settings(&self) -> std::option::Option<&crate::model::DirectoryVpcSettings> {
        self.vpc_settings.as_ref()
    }
    /// <p>The desired number of domain controllers in the specified Region for the specified
    /// directory.</p>
    pub fn desired_number_of_domain_controllers(&self) -> i32 {
        self.desired_number_of_domain_controllers
    }
    /// <p>Specifies when the Region replication began.</p>
    pub fn launch_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.launch_time.as_ref()
    }
    /// <p>The date and time that the Region status was last updated.</p>
    pub fn status_last_updated_date_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.status_last_updated_date_time.as_ref()
    }
    /// <p>The date and time that the Region description was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
}
impl std::fmt::Debug for RegionDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegionDescription");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("region_name", &self.region_name);
        formatter.field("region_type", &self.region_type);
        formatter.field("status", &self.status);
        formatter.field("vpc_settings", &self.vpc_settings);
        formatter.field(
            "desired_number_of_domain_controllers",
            &self.desired_number_of_domain_controllers,
        );
        formatter.field("launch_time", &self.launch_time);
        formatter.field(
            "status_last_updated_date_time",
            &self.status_last_updated_date_time,
        );
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`RegionDescription`](crate::model::RegionDescription)
pub mod region_description {
    /// A builder for [`RegionDescription`](crate::model::RegionDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) region_name: std::option::Option<std::string::String>,
        pub(crate) region_type: std::option::Option<crate::model::RegionType>,
        pub(crate) status: std::option::Option<crate::model::DirectoryStage>,
        pub(crate) vpc_settings: std::option::Option<crate::model::DirectoryVpcSettings>,
        pub(crate) desired_number_of_domain_controllers: std::option::Option<i32>,
        pub(crate) launch_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status_last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The identifier of the directory.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The name of the Region. For example, <code>us-east-1</code>.</p>
        pub fn region_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.region_name = Some(input.into());
            self
        }
        /// <p>The name of the Region. For example, <code>us-east-1</code>.</p>
        pub fn set_region_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region_name = input;
            self
        }
        /// <p>Specifies whether the Region is the primary Region or an additional Region.</p>
        pub fn region_type(mut self, input: crate::model::RegionType) -> Self {
            self.region_type = Some(input);
            self
        }
        /// <p>Specifies whether the Region is the primary Region or an additional Region.</p>
        pub fn set_region_type(
            mut self,
            input: std::option::Option<crate::model::RegionType>,
        ) -> Self {
            self.region_type = input;
            self
        }
        /// <p>The status of the replication process for the specified Region.</p>
        pub fn status(mut self, input: crate::model::DirectoryStage) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the replication process for the specified Region.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DirectoryStage>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Contains VPC information for the <a>CreateDirectory</a> or <a>CreateMicrosoftAD</a> operation.</p>
        pub fn vpc_settings(mut self, input: crate::model::DirectoryVpcSettings) -> Self {
            self.vpc_settings = Some(input);
            self
        }
        /// <p>Contains VPC information for the <a>CreateDirectory</a> or <a>CreateMicrosoftAD</a> operation.</p>
        pub fn set_vpc_settings(
            mut self,
            input: std::option::Option<crate::model::DirectoryVpcSettings>,
        ) -> Self {
            self.vpc_settings = input;
            self
        }
        /// <p>The desired number of domain controllers in the specified Region for the specified
        /// directory.</p>
        pub fn desired_number_of_domain_controllers(mut self, input: i32) -> Self {
            self.desired_number_of_domain_controllers = Some(input);
            self
        }
        /// <p>The desired number of domain controllers in the specified Region for the specified
        /// directory.</p>
        pub fn set_desired_number_of_domain_controllers(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.desired_number_of_domain_controllers = input;
            self
        }
        /// <p>Specifies when the Region replication began.</p>
        pub fn launch_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.launch_time = Some(input);
            self
        }
        /// <p>Specifies when the Region replication began.</p>
        pub fn set_launch_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.launch_time = input;
            self
        }
        /// <p>The date and time that the Region status was last updated.</p>
        pub fn status_last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.status_last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time that the Region status was last updated.</p>
        pub fn set_status_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.status_last_updated_date_time = input;
            self
        }
        /// <p>The date and time that the Region description was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time that the Region description was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`RegionDescription`](crate::model::RegionDescription)
        pub fn build(self) -> crate::model::RegionDescription {
            crate::model::RegionDescription {
                directory_id: self.directory_id,
                region_name: self.region_name,
                region_type: self.region_type,
                status: self.status,
                vpc_settings: self.vpc_settings,
                desired_number_of_domain_controllers: self
                    .desired_number_of_domain_controllers
                    .unwrap_or_default(),
                launch_time: self.launch_time,
                status_last_updated_date_time: self.status_last_updated_date_time,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl RegionDescription {
    /// Creates a new builder-style object to manufacture [`RegionDescription`](crate::model::RegionDescription)
    pub fn builder() -> crate::model::region_description::Builder {
        crate::model::region_description::Builder::default()
    }
}

/// <p>Contains VPC information for the <a>CreateDirectory</a> or <a>CreateMicrosoftAD</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DirectoryVpcSettings {
    /// <p>The identifier of the VPC in which to create the directory.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The identifiers of the subnets for the directory servers. The two subnets must be in
    /// different Availability Zones. Directory Service creates a directory server and a DNS
    /// server in each of these subnets.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DirectoryVpcSettings {
    /// <p>The identifier of the VPC in which to create the directory.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The identifiers of the subnets for the directory servers. The two subnets must be in
    /// different Availability Zones. Directory Service creates a directory server and a DNS
    /// server in each of these subnets.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
}
impl std::fmt::Debug for DirectoryVpcSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DirectoryVpcSettings");
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.finish()
    }
}
/// See [`DirectoryVpcSettings`](crate::model::DirectoryVpcSettings)
pub mod directory_vpc_settings {
    /// A builder for [`DirectoryVpcSettings`](crate::model::DirectoryVpcSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The identifier of the VPC in which to create the directory.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The identifier of the VPC in which to create the directory.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The identifiers of the subnets for the directory servers. The two subnets must be in
        /// different Availability Zones. Directory Service creates a directory server and a DNS
        /// server in each of these subnets.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>The identifiers of the subnets for the directory servers. The two subnets must be in
        /// different Availability Zones. Directory Service creates a directory server and a DNS
        /// server in each of these subnets.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DirectoryVpcSettings`](crate::model::DirectoryVpcSettings)
        pub fn build(self) -> crate::model::DirectoryVpcSettings {
            crate::model::DirectoryVpcSettings {
                vpc_id: self.vpc_id,
                subnet_ids: self.subnet_ids,
            }
        }
    }
}
impl DirectoryVpcSettings {
    /// Creates a new builder-style object to manufacture [`DirectoryVpcSettings`](crate::model::DirectoryVpcSettings)
    pub fn builder() -> crate::model::directory_vpc_settings::Builder {
        crate::model::directory_vpc_settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DirectoryStage {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Created,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Impaired,
    #[allow(missing_docs)] // documentation missing in model
    Inoperable,
    #[allow(missing_docs)] // documentation missing in model
    Requested,
    #[allow(missing_docs)] // documentation missing in model
    Restorefailed,
    #[allow(missing_docs)] // documentation missing in model
    Restoring,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DirectoryStage {
    fn from(s: &str) -> Self {
        match s {
            "Active" => DirectoryStage::Active,
            "Created" => DirectoryStage::Created,
            "Creating" => DirectoryStage::Creating,
            "Deleted" => DirectoryStage::Deleted,
            "Deleting" => DirectoryStage::Deleting,
            "Failed" => DirectoryStage::Failed,
            "Impaired" => DirectoryStage::Impaired,
            "Inoperable" => DirectoryStage::Inoperable,
            "Requested" => DirectoryStage::Requested,
            "RestoreFailed" => DirectoryStage::Restorefailed,
            "Restoring" => DirectoryStage::Restoring,
            other => DirectoryStage::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DirectoryStage {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DirectoryStage::from(s))
    }
}
impl DirectoryStage {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DirectoryStage::Active => "Active",
            DirectoryStage::Created => "Created",
            DirectoryStage::Creating => "Creating",
            DirectoryStage::Deleted => "Deleted",
            DirectoryStage::Deleting => "Deleting",
            DirectoryStage::Failed => "Failed",
            DirectoryStage::Impaired => "Impaired",
            DirectoryStage::Inoperable => "Inoperable",
            DirectoryStage::Requested => "Requested",
            DirectoryStage::Restorefailed => "RestoreFailed",
            DirectoryStage::Restoring => "Restoring",
            DirectoryStage::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Active",
            "Created",
            "Creating",
            "Deleted",
            "Deleting",
            "Failed",
            "Impaired",
            "Inoperable",
            "Requested",
            "RestoreFailed",
            "Restoring",
        ]
    }
}
impl AsRef<str> for DirectoryStage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RegionType {
    #[allow(missing_docs)] // documentation missing in model
    Additional,
    #[allow(missing_docs)] // documentation missing in model
    Primary,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RegionType {
    fn from(s: &str) -> Self {
        match s {
            "Additional" => RegionType::Additional,
            "Primary" => RegionType::Primary,
            other => RegionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RegionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RegionType::from(s))
    }
}
impl RegionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RegionType::Additional => "Additional",
            RegionType::Primary => "Primary",
            RegionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Additional", "Primary"]
    }
}
impl AsRef<str> for RegionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains general information about the LDAPS settings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LdapsSettingInfo {
    /// <p>The state of the LDAPS settings.</p>
    pub ldaps_status: std::option::Option<crate::model::LdapsStatus>,
    /// <p>Describes a state change for LDAPS.</p>
    pub ldaps_status_reason: std::option::Option<std::string::String>,
    /// <p>The date and time when the LDAPS settings were last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl LdapsSettingInfo {
    /// <p>The state of the LDAPS settings.</p>
    pub fn ldaps_status(&self) -> std::option::Option<&crate::model::LdapsStatus> {
        self.ldaps_status.as_ref()
    }
    /// <p>Describes a state change for LDAPS.</p>
    pub fn ldaps_status_reason(&self) -> std::option::Option<&str> {
        self.ldaps_status_reason.as_deref()
    }
    /// <p>The date and time when the LDAPS settings were last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
}
impl std::fmt::Debug for LdapsSettingInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LdapsSettingInfo");
        formatter.field("ldaps_status", &self.ldaps_status);
        formatter.field("ldaps_status_reason", &self.ldaps_status_reason);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`LdapsSettingInfo`](crate::model::LdapsSettingInfo)
pub mod ldaps_setting_info {
    /// A builder for [`LdapsSettingInfo`](crate::model::LdapsSettingInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ldaps_status: std::option::Option<crate::model::LdapsStatus>,
        pub(crate) ldaps_status_reason: std::option::Option<std::string::String>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The state of the LDAPS settings.</p>
        pub fn ldaps_status(mut self, input: crate::model::LdapsStatus) -> Self {
            self.ldaps_status = Some(input);
            self
        }
        /// <p>The state of the LDAPS settings.</p>
        pub fn set_ldaps_status(
            mut self,
            input: std::option::Option<crate::model::LdapsStatus>,
        ) -> Self {
            self.ldaps_status = input;
            self
        }
        /// <p>Describes a state change for LDAPS.</p>
        pub fn ldaps_status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.ldaps_status_reason = Some(input.into());
            self
        }
        /// <p>Describes a state change for LDAPS.</p>
        pub fn set_ldaps_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ldaps_status_reason = input;
            self
        }
        /// <p>The date and time when the LDAPS settings were last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time when the LDAPS settings were last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`LdapsSettingInfo`](crate::model::LdapsSettingInfo)
        pub fn build(self) -> crate::model::LdapsSettingInfo {
            crate::model::LdapsSettingInfo {
                ldaps_status: self.ldaps_status,
                ldaps_status_reason: self.ldaps_status_reason,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl LdapsSettingInfo {
    /// Creates a new builder-style object to manufacture [`LdapsSettingInfo`](crate::model::LdapsSettingInfo)
    pub fn builder() -> crate::model::ldaps_setting_info::Builder {
        crate::model::ldaps_setting_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LdapsStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    EnableFailed,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabling,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LdapsStatus {
    fn from(s: &str) -> Self {
        match s {
            "Disabled" => LdapsStatus::Disabled,
            "EnableFailed" => LdapsStatus::EnableFailed,
            "Enabled" => LdapsStatus::Enabled,
            "Enabling" => LdapsStatus::Enabling,
            other => LdapsStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LdapsStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LdapsStatus::from(s))
    }
}
impl LdapsStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LdapsStatus::Disabled => "Disabled",
            LdapsStatus::EnableFailed => "EnableFailed",
            LdapsStatus::Enabled => "Enabled",
            LdapsStatus::Enabling => "Enabling",
            LdapsStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Disabled", "EnableFailed", "Enabled", "Enabling"]
    }
}
impl AsRef<str> for LdapsStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about Amazon SNS topic and Directory Service directory associations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventTopic {
    /// <p>The Directory ID of an Directory Service directory that will publish status messages to an Amazon SNS
    /// topic.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The name of an Amazon SNS topic the receives status messages from the directory.</p>
    pub topic_name: std::option::Option<std::string::String>,
    /// <p>The Amazon SNS topic ARN (Amazon Resource Name).</p>
    pub topic_arn: std::option::Option<std::string::String>,
    /// <p>The date and time of when you associated your directory with the Amazon SNS topic.</p>
    pub created_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The topic registration status.</p>
    pub status: std::option::Option<crate::model::TopicStatus>,
}
impl EventTopic {
    /// <p>The Directory ID of an Directory Service directory that will publish status messages to an Amazon SNS
    /// topic.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The name of an Amazon SNS topic the receives status messages from the directory.</p>
    pub fn topic_name(&self) -> std::option::Option<&str> {
        self.topic_name.as_deref()
    }
    /// <p>The Amazon SNS topic ARN (Amazon Resource Name).</p>
    pub fn topic_arn(&self) -> std::option::Option<&str> {
        self.topic_arn.as_deref()
    }
    /// <p>The date and time of when you associated your directory with the Amazon SNS topic.</p>
    pub fn created_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_date_time.as_ref()
    }
    /// <p>The topic registration status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::TopicStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for EventTopic {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventTopic");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("topic_name", &self.topic_name);
        formatter.field("topic_arn", &self.topic_arn);
        formatter.field("created_date_time", &self.created_date_time);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`EventTopic`](crate::model::EventTopic)
pub mod event_topic {
    /// A builder for [`EventTopic`](crate::model::EventTopic)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) topic_name: std::option::Option<std::string::String>,
        pub(crate) topic_arn: std::option::Option<std::string::String>,
        pub(crate) created_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::TopicStatus>,
    }
    impl Builder {
        /// <p>The Directory ID of an Directory Service directory that will publish status messages to an Amazon SNS
        /// topic.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The Directory ID of an Directory Service directory that will publish status messages to an Amazon SNS
        /// topic.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The name of an Amazon SNS topic the receives status messages from the directory.</p>
        pub fn topic_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_name = Some(input.into());
            self
        }
        /// <p>The name of an Amazon SNS topic the receives status messages from the directory.</p>
        pub fn set_topic_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_name = input;
            self
        }
        /// <p>The Amazon SNS topic ARN (Amazon Resource Name).</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon SNS topic ARN (Amazon Resource Name).</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// <p>The date and time of when you associated your directory with the Amazon SNS topic.</p>
        pub fn created_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_date_time = Some(input);
            self
        }
        /// <p>The date and time of when you associated your directory with the Amazon SNS topic.</p>
        pub fn set_created_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_date_time = input;
            self
        }
        /// <p>The topic registration status.</p>
        pub fn status(mut self, input: crate::model::TopicStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The topic registration status.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::TopicStatus>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`EventTopic`](crate::model::EventTopic)
        pub fn build(self) -> crate::model::EventTopic {
            crate::model::EventTopic {
                directory_id: self.directory_id,
                topic_name: self.topic_name,
                topic_arn: self.topic_arn,
                created_date_time: self.created_date_time,
                status: self.status,
            }
        }
    }
}
impl EventTopic {
    /// Creates a new builder-style object to manufacture [`EventTopic`](crate::model::EventTopic)
    pub fn builder() -> crate::model::event_topic::Builder {
        crate::model::event_topic::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TopicStatus {
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Registered,
    #[allow(missing_docs)] // documentation missing in model
    TopicNotFound,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TopicStatus {
    fn from(s: &str) -> Self {
        match s {
            "Deleted" => TopicStatus::Deleted,
            "Failed" => TopicStatus::Failed,
            "Registered" => TopicStatus::Registered,
            "Topic not found" => TopicStatus::TopicNotFound,
            other => TopicStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TopicStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TopicStatus::from(s))
    }
}
impl TopicStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TopicStatus::Deleted => "Deleted",
            TopicStatus::Failed => "Failed",
            TopicStatus::Registered => "Registered",
            TopicStatus::TopicNotFound => "Topic not found",
            TopicStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Deleted", "Failed", "Registered", "Topic not found"]
    }
}
impl AsRef<str> for TopicStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the domain controllers for a specified directory.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainController {
    /// <p>Identifier of the directory where the domain controller resides.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>Identifies a specific domain controller in the directory.</p>
    pub domain_controller_id: std::option::Option<std::string::String>,
    /// <p>The IP address of the domain controller.</p>
    pub dns_ip_addr: std::option::Option<std::string::String>,
    /// <p>The identifier of the VPC that contains the domain controller.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>Identifier of the subnet in the VPC that contains the domain controller.</p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>The Availability Zone where the domain controller is located.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The status of the domain controller.</p>
    pub status: std::option::Option<crate::model::DomainControllerStatus>,
    /// <p>A description of the domain controller state.</p>
    pub status_reason: std::option::Option<std::string::String>,
    /// <p>Specifies when the domain controller was created.</p>
    pub launch_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the status was last updated.</p>
    pub status_last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DomainController {
    /// <p>Identifier of the directory where the domain controller resides.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>Identifies a specific domain controller in the directory.</p>
    pub fn domain_controller_id(&self) -> std::option::Option<&str> {
        self.domain_controller_id.as_deref()
    }
    /// <p>The IP address of the domain controller.</p>
    pub fn dns_ip_addr(&self) -> std::option::Option<&str> {
        self.dns_ip_addr.as_deref()
    }
    /// <p>The identifier of the VPC that contains the domain controller.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>Identifier of the subnet in the VPC that contains the domain controller.</p>
    pub fn subnet_id(&self) -> std::option::Option<&str> {
        self.subnet_id.as_deref()
    }
    /// <p>The Availability Zone where the domain controller is located.</p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>The status of the domain controller.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DomainControllerStatus> {
        self.status.as_ref()
    }
    /// <p>A description of the domain controller state.</p>
    pub fn status_reason(&self) -> std::option::Option<&str> {
        self.status_reason.as_deref()
    }
    /// <p>Specifies when the domain controller was created.</p>
    pub fn launch_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.launch_time.as_ref()
    }
    /// <p>The date and time that the status was last updated.</p>
    pub fn status_last_updated_date_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.status_last_updated_date_time.as_ref()
    }
}
impl std::fmt::Debug for DomainController {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainController");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("domain_controller_id", &self.domain_controller_id);
        formatter.field("dns_ip_addr", &self.dns_ip_addr);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("status", &self.status);
        formatter.field("status_reason", &self.status_reason);
        formatter.field("launch_time", &self.launch_time);
        formatter.field(
            "status_last_updated_date_time",
            &self.status_last_updated_date_time,
        );
        formatter.finish()
    }
}
/// See [`DomainController`](crate::model::DomainController)
pub mod domain_controller {
    /// A builder for [`DomainController`](crate::model::DomainController)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) domain_controller_id: std::option::Option<std::string::String>,
        pub(crate) dns_ip_addr: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::DomainControllerStatus>,
        pub(crate) status_reason: std::option::Option<std::string::String>,
        pub(crate) launch_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status_last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Identifier of the directory where the domain controller resides.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>Identifier of the directory where the domain controller resides.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>Identifies a specific domain controller in the directory.</p>
        pub fn domain_controller_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_controller_id = Some(input.into());
            self
        }
        /// <p>Identifies a specific domain controller in the directory.</p>
        pub fn set_domain_controller_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.domain_controller_id = input;
            self
        }
        /// <p>The IP address of the domain controller.</p>
        pub fn dns_ip_addr(mut self, input: impl Into<std::string::String>) -> Self {
            self.dns_ip_addr = Some(input.into());
            self
        }
        /// <p>The IP address of the domain controller.</p>
        pub fn set_dns_ip_addr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dns_ip_addr = input;
            self
        }
        /// <p>The identifier of the VPC that contains the domain controller.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The identifier of the VPC that contains the domain controller.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>Identifier of the subnet in the VPC that contains the domain controller.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>Identifier of the subnet in the VPC that contains the domain controller.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>The Availability Zone where the domain controller is located.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone where the domain controller is located.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The status of the domain controller.</p>
        pub fn status(mut self, input: crate::model::DomainControllerStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the domain controller.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DomainControllerStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A description of the domain controller state.</p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// <p>A description of the domain controller state.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// <p>Specifies when the domain controller was created.</p>
        pub fn launch_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.launch_time = Some(input);
            self
        }
        /// <p>Specifies when the domain controller was created.</p>
        pub fn set_launch_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.launch_time = input;
            self
        }
        /// <p>The date and time that the status was last updated.</p>
        pub fn status_last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.status_last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time that the status was last updated.</p>
        pub fn set_status_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.status_last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainController`](crate::model::DomainController)
        pub fn build(self) -> crate::model::DomainController {
            crate::model::DomainController {
                directory_id: self.directory_id,
                domain_controller_id: self.domain_controller_id,
                dns_ip_addr: self.dns_ip_addr,
                vpc_id: self.vpc_id,
                subnet_id: self.subnet_id,
                availability_zone: self.availability_zone,
                status: self.status,
                status_reason: self.status_reason,
                launch_time: self.launch_time,
                status_last_updated_date_time: self.status_last_updated_date_time,
            }
        }
    }
}
impl DomainController {
    /// Creates a new builder-style object to manufacture [`DomainController`](crate::model::DomainController)
    pub fn builder() -> crate::model::domain_controller::Builder {
        crate::model::domain_controller::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DomainControllerStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Impaired,
    #[allow(missing_docs)] // documentation missing in model
    Restoring,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DomainControllerStatus {
    fn from(s: &str) -> Self {
        match s {
            "Active" => DomainControllerStatus::Active,
            "Creating" => DomainControllerStatus::Creating,
            "Deleted" => DomainControllerStatus::Deleted,
            "Deleting" => DomainControllerStatus::Deleting,
            "Failed" => DomainControllerStatus::Failed,
            "Impaired" => DomainControllerStatus::Impaired,
            "Restoring" => DomainControllerStatus::Restoring,
            other => DomainControllerStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DomainControllerStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DomainControllerStatus::from(s))
    }
}
impl DomainControllerStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DomainControllerStatus::Active => "Active",
            DomainControllerStatus::Creating => "Creating",
            DomainControllerStatus::Deleted => "Deleted",
            DomainControllerStatus::Deleting => "Deleting",
            DomainControllerStatus::Failed => "Failed",
            DomainControllerStatus::Impaired => "Impaired",
            DomainControllerStatus::Restoring => "Restoring",
            DomainControllerStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Active",
            "Creating",
            "Deleted",
            "Deleting",
            "Failed",
            "Impaired",
            "Restoring",
        ]
    }
}
impl AsRef<str> for DomainControllerStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about an Directory Service directory.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DirectoryDescription {
    /// <p>The directory identifier.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The fully qualified name of the directory.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The short name of the directory.</p>
    pub short_name: std::option::Option<std::string::String>,
    /// <p>The directory size.</p>
    pub size: std::option::Option<crate::model::DirectorySize>,
    /// <p>The edition associated with this directory.</p>
    pub edition: std::option::Option<crate::model::DirectoryEdition>,
    /// <p>The alias for the directory. If no alias has been created for the directory, the alias is
    /// the directory identifier, such as <code>d-XXXXXXXXXX</code>.</p>
    pub alias: std::option::Option<std::string::String>,
    /// <p>The access URL for the directory, such as
    /// <code>http://<alias>.awsapps.com</code>. If no alias has been created for the
    /// directory, <code><alias></code> is the directory identifier, such as
    /// <code>d-XXXXXXXXXX</code>.</p>
    pub access_url: std::option::Option<std::string::String>,
    /// <p>The description for the directory.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The IP addresses of the DNS servers for the directory. For a Simple AD or Microsoft AD
    /// directory, these are the IP addresses of the Simple AD or Microsoft AD directory servers. For
    /// an AD Connector directory, these are the IP addresses of the DNS servers or domain controllers
    /// in your self-managed directory to which the AD Connector is connected.</p>
    pub dns_ip_addrs: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The current stage of the directory.</p>
    pub stage: std::option::Option<crate::model::DirectoryStage>,
    /// <p>Current directory status of the shared Managed Microsoft AD directory.</p>
    pub share_status: std::option::Option<crate::model::ShareStatus>,
    /// <p>The method used when sharing a directory to determine whether the directory should be
    /// shared within your Amazon Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services account by
    /// sending a shared directory request (<code>HANDSHAKE</code>).</p>
    pub share_method: std::option::Option<crate::model::ShareMethod>,
    /// <p>A directory share request that is sent by the directory owner to the directory consumer.
    /// The request includes a typed message to help the directory consumer administrator determine
    /// whether to approve or reject the share invitation.</p>
    pub share_notes: std::option::Option<std::string::String>,
    /// <p>Specifies when the directory was created.</p>
    pub launch_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the stage was last updated.</p>
    pub stage_last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The directory size.</p>
    pub r#type: std::option::Option<crate::model::DirectoryType>,
    /// <p>A <a>DirectoryVpcSettingsDescription</a> object that contains additional
    /// information about a directory. This member is only present if the directory is a Simple AD or
    /// Managed Microsoft AD directory.</p>
    pub vpc_settings: std::option::Option<crate::model::DirectoryVpcSettingsDescription>,
    /// <p>A <a>DirectoryConnectSettingsDescription</a> object that contains additional
    /// information about an AD Connector directory. This member is only present if the directory is
    /// an AD Connector directory.</p>
    pub connect_settings: std::option::Option<crate::model::DirectoryConnectSettingsDescription>,
    /// <p>A <a>RadiusSettings</a> object that contains information about the RADIUS
    /// server configured for this directory.</p>
    pub radius_settings: std::option::Option<crate::model::RadiusSettings>,
    /// <p>The status of the RADIUS MFA server connection.</p>
    pub radius_status: std::option::Option<crate::model::RadiusStatus>,
    /// <p>Additional information about the directory stage.</p>
    pub stage_reason: std::option::Option<std::string::String>,
    /// <p>Indicates if single sign-on is enabled for the directory. For more information, see <a>EnableSso</a> and <a>DisableSso</a>.</p>
    pub sso_enabled: bool,
    /// <p>The desired number of domain controllers in the directory if the directory is Microsoft
    /// AD.</p>
    pub desired_number_of_domain_controllers: i32,
    /// <p>Describes the Managed Microsoft AD directory in the directory owner account.</p>
    pub owner_directory_description: std::option::Option<crate::model::OwnerDirectoryDescription>,
    /// <p>Lists the Regions where the directory has replicated.</p>
    pub regions_info: std::option::Option<crate::model::RegionsInfo>,
}
impl DirectoryDescription {
    /// <p>The directory identifier.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The fully qualified name of the directory.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The short name of the directory.</p>
    pub fn short_name(&self) -> std::option::Option<&str> {
        self.short_name.as_deref()
    }
    /// <p>The directory size.</p>
    pub fn size(&self) -> std::option::Option<&crate::model::DirectorySize> {
        self.size.as_ref()
    }
    /// <p>The edition associated with this directory.</p>
    pub fn edition(&self) -> std::option::Option<&crate::model::DirectoryEdition> {
        self.edition.as_ref()
    }
    /// <p>The alias for the directory. If no alias has been created for the directory, the alias is
    /// the directory identifier, such as <code>d-XXXXXXXXXX</code>.</p>
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
    /// <p>The access URL for the directory, such as
    /// <code>http://<alias>.awsapps.com</code>. If no alias has been created for the
    /// directory, <code><alias></code> is the directory identifier, such as
    /// <code>d-XXXXXXXXXX</code>.</p>
    pub fn access_url(&self) -> std::option::Option<&str> {
        self.access_url.as_deref()
    }
    /// <p>The description for the directory.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The IP addresses of the DNS servers for the directory. For a Simple AD or Microsoft AD
    /// directory, these are the IP addresses of the Simple AD or Microsoft AD directory servers. For
    /// an AD Connector directory, these are the IP addresses of the DNS servers or domain controllers
    /// in your self-managed directory to which the AD Connector is connected.</p>
    pub fn dns_ip_addrs(&self) -> std::option::Option<&[std::string::String]> {
        self.dns_ip_addrs.as_deref()
    }
    /// <p>The current stage of the directory.</p>
    pub fn stage(&self) -> std::option::Option<&crate::model::DirectoryStage> {
        self.stage.as_ref()
    }
    /// <p>Current directory status of the shared Managed Microsoft AD directory.</p>
    pub fn share_status(&self) -> std::option::Option<&crate::model::ShareStatus> {
        self.share_status.as_ref()
    }
    /// <p>The method used when sharing a directory to determine whether the directory should be
    /// shared within your Amazon Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services account by
    /// sending a shared directory request (<code>HANDSHAKE</code>).</p>
    pub fn share_method(&self) -> std::option::Option<&crate::model::ShareMethod> {
        self.share_method.as_ref()
    }
    /// <p>A directory share request that is sent by the directory owner to the directory consumer.
    /// The request includes a typed message to help the directory consumer administrator determine
    /// whether to approve or reject the share invitation.</p>
    pub fn share_notes(&self) -> std::option::Option<&str> {
        self.share_notes.as_deref()
    }
    /// <p>Specifies when the directory was created.</p>
    pub fn launch_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.launch_time.as_ref()
    }
    /// <p>The date and time that the stage was last updated.</p>
    pub fn stage_last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.stage_last_updated_date_time.as_ref()
    }
    /// <p>The directory size.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::DirectoryType> {
        self.r#type.as_ref()
    }
    /// <p>A <a>DirectoryVpcSettingsDescription</a> object that contains additional
    /// information about a directory. This member is only present if the directory is a Simple AD or
    /// Managed Microsoft AD directory.</p>
    pub fn vpc_settings(
        &self,
    ) -> std::option::Option<&crate::model::DirectoryVpcSettingsDescription> {
        self.vpc_settings.as_ref()
    }
    /// <p>A <a>DirectoryConnectSettingsDescription</a> object that contains additional
    /// information about an AD Connector directory. This member is only present if the directory is
    /// an AD Connector directory.</p>
    pub fn connect_settings(
        &self,
    ) -> std::option::Option<&crate::model::DirectoryConnectSettingsDescription> {
        self.connect_settings.as_ref()
    }
    /// <p>A <a>RadiusSettings</a> object that contains information about the RADIUS
    /// server configured for this directory.</p>
    pub fn radius_settings(&self) -> std::option::Option<&crate::model::RadiusSettings> {
        self.radius_settings.as_ref()
    }
    /// <p>The status of the RADIUS MFA server connection.</p>
    pub fn radius_status(&self) -> std::option::Option<&crate::model::RadiusStatus> {
        self.radius_status.as_ref()
    }
    /// <p>Additional information about the directory stage.</p>
    pub fn stage_reason(&self) -> std::option::Option<&str> {
        self.stage_reason.as_deref()
    }
    /// <p>Indicates if single sign-on is enabled for the directory. For more information, see <a>EnableSso</a> and <a>DisableSso</a>.</p>
    pub fn sso_enabled(&self) -> bool {
        self.sso_enabled
    }
    /// <p>The desired number of domain controllers in the directory if the directory is Microsoft
    /// AD.</p>
    pub fn desired_number_of_domain_controllers(&self) -> i32 {
        self.desired_number_of_domain_controllers
    }
    /// <p>Describes the Managed Microsoft AD directory in the directory owner account.</p>
    pub fn owner_directory_description(
        &self,
    ) -> std::option::Option<&crate::model::OwnerDirectoryDescription> {
        self.owner_directory_description.as_ref()
    }
    /// <p>Lists the Regions where the directory has replicated.</p>
    pub fn regions_info(&self) -> std::option::Option<&crate::model::RegionsInfo> {
        self.regions_info.as_ref()
    }
}
impl std::fmt::Debug for DirectoryDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DirectoryDescription");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("name", &self.name);
        formatter.field("short_name", &self.short_name);
        formatter.field("size", &self.size);
        formatter.field("edition", &self.edition);
        formatter.field("alias", &self.alias);
        formatter.field("access_url", &self.access_url);
        formatter.field("description", &self.description);
        formatter.field("dns_ip_addrs", &self.dns_ip_addrs);
        formatter.field("stage", &self.stage);
        formatter.field("share_status", &self.share_status);
        formatter.field("share_method", &self.share_method);
        formatter.field("share_notes", &"*** Sensitive Data Redacted ***");
        formatter.field("launch_time", &self.launch_time);
        formatter.field(
            "stage_last_updated_date_time",
            &self.stage_last_updated_date_time,
        );
        formatter.field("r#type", &self.r#type);
        formatter.field("vpc_settings", &self.vpc_settings);
        formatter.field("connect_settings", &self.connect_settings);
        formatter.field("radius_settings", &self.radius_settings);
        formatter.field("radius_status", &self.radius_status);
        formatter.field("stage_reason", &self.stage_reason);
        formatter.field("sso_enabled", &self.sso_enabled);
        formatter.field(
            "desired_number_of_domain_controllers",
            &self.desired_number_of_domain_controllers,
        );
        formatter.field(
            "owner_directory_description",
            &self.owner_directory_description,
        );
        formatter.field("regions_info", &self.regions_info);
        formatter.finish()
    }
}
/// See [`DirectoryDescription`](crate::model::DirectoryDescription)
pub mod directory_description {
    /// A builder for [`DirectoryDescription`](crate::model::DirectoryDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) short_name: std::option::Option<std::string::String>,
        pub(crate) size: std::option::Option<crate::model::DirectorySize>,
        pub(crate) edition: std::option::Option<crate::model::DirectoryEdition>,
        pub(crate) alias: std::option::Option<std::string::String>,
        pub(crate) access_url: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) dns_ip_addrs: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) stage: std::option::Option<crate::model::DirectoryStage>,
        pub(crate) share_status: std::option::Option<crate::model::ShareStatus>,
        pub(crate) share_method: std::option::Option<crate::model::ShareMethod>,
        pub(crate) share_notes: std::option::Option<std::string::String>,
        pub(crate) launch_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) stage_last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) r#type: std::option::Option<crate::model::DirectoryType>,
        pub(crate) vpc_settings: std::option::Option<crate::model::DirectoryVpcSettingsDescription>,
        pub(crate) connect_settings:
            std::option::Option<crate::model::DirectoryConnectSettingsDescription>,
        pub(crate) radius_settings: std::option::Option<crate::model::RadiusSettings>,
        pub(crate) radius_status: std::option::Option<crate::model::RadiusStatus>,
        pub(crate) stage_reason: std::option::Option<std::string::String>,
        pub(crate) sso_enabled: std::option::Option<bool>,
        pub(crate) desired_number_of_domain_controllers: std::option::Option<i32>,
        pub(crate) owner_directory_description:
            std::option::Option<crate::model::OwnerDirectoryDescription>,
        pub(crate) regions_info: std::option::Option<crate::model::RegionsInfo>,
    }
    impl Builder {
        /// <p>The directory identifier.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The directory identifier.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The fully qualified name of the directory.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The fully qualified name of the directory.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The short name of the directory.</p>
        pub fn short_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.short_name = Some(input.into());
            self
        }
        /// <p>The short name of the directory.</p>
        pub fn set_short_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.short_name = input;
            self
        }
        /// <p>The directory size.</p>
        pub fn size(mut self, input: crate::model::DirectorySize) -> Self {
            self.size = Some(input);
            self
        }
        /// <p>The directory size.</p>
        pub fn set_size(mut self, input: std::option::Option<crate::model::DirectorySize>) -> Self {
            self.size = input;
            self
        }
        /// <p>The edition associated with this directory.</p>
        pub fn edition(mut self, input: crate::model::DirectoryEdition) -> Self {
            self.edition = Some(input);
            self
        }
        /// <p>The edition associated with this directory.</p>
        pub fn set_edition(
            mut self,
            input: std::option::Option<crate::model::DirectoryEdition>,
        ) -> Self {
            self.edition = input;
            self
        }
        /// <p>The alias for the directory. If no alias has been created for the directory, the alias is
        /// the directory identifier, such as <code>d-XXXXXXXXXX</code>.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// <p>The alias for the directory. If no alias has been created for the directory, the alias is
        /// the directory identifier, such as <code>d-XXXXXXXXXX</code>.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// <p>The access URL for the directory, such as
        /// <code>http://<alias>.awsapps.com</code>. If no alias has been created for the
        /// directory, <code><alias></code> is the directory identifier, such as
        /// <code>d-XXXXXXXXXX</code>.</p>
        pub fn access_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_url = Some(input.into());
            self
        }
        /// <p>The access URL for the directory, such as
        /// <code>http://<alias>.awsapps.com</code>. If no alias has been created for the
        /// directory, <code><alias></code> is the directory identifier, such as
        /// <code>d-XXXXXXXXXX</code>.</p>
        pub fn set_access_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_url = input;
            self
        }
        /// <p>The description for the directory.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the directory.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `dns_ip_addrs`.
        ///
        /// To override the contents of this collection use [`set_dns_ip_addrs`](Self::set_dns_ip_addrs).
        ///
        /// <p>The IP addresses of the DNS servers for the directory. For a Simple AD or Microsoft AD
        /// directory, these are the IP addresses of the Simple AD or Microsoft AD directory servers. For
        /// an AD Connector directory, these are the IP addresses of the DNS servers or domain controllers
        /// in your self-managed directory to which the AD Connector is connected.</p>
        pub fn dns_ip_addrs(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.dns_ip_addrs.unwrap_or_default();
            v.push(input.into());
            self.dns_ip_addrs = Some(v);
            self
        }
        /// <p>The IP addresses of the DNS servers for the directory. For a Simple AD or Microsoft AD
        /// directory, these are the IP addresses of the Simple AD or Microsoft AD directory servers. For
        /// an AD Connector directory, these are the IP addresses of the DNS servers or domain controllers
        /// in your self-managed directory to which the AD Connector is connected.</p>
        pub fn set_dns_ip_addrs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.dns_ip_addrs = input;
            self
        }
        /// <p>The current stage of the directory.</p>
        pub fn stage(mut self, input: crate::model::DirectoryStage) -> Self {
            self.stage = Some(input);
            self
        }
        /// <p>The current stage of the directory.</p>
        pub fn set_stage(
            mut self,
            input: std::option::Option<crate::model::DirectoryStage>,
        ) -> Self {
            self.stage = input;
            self
        }
        /// <p>Current directory status of the shared Managed Microsoft AD directory.</p>
        pub fn share_status(mut self, input: crate::model::ShareStatus) -> Self {
            self.share_status = Some(input);
            self
        }
        /// <p>Current directory status of the shared Managed Microsoft AD directory.</p>
        pub fn set_share_status(
            mut self,
            input: std::option::Option<crate::model::ShareStatus>,
        ) -> Self {
            self.share_status = input;
            self
        }
        /// <p>The method used when sharing a directory to determine whether the directory should be
        /// shared within your Amazon Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services account by
        /// sending a shared directory request (<code>HANDSHAKE</code>).</p>
        pub fn share_method(mut self, input: crate::model::ShareMethod) -> Self {
            self.share_method = Some(input);
            self
        }
        /// <p>The method used when sharing a directory to determine whether the directory should be
        /// shared within your Amazon Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services account by
        /// sending a shared directory request (<code>HANDSHAKE</code>).</p>
        pub fn set_share_method(
            mut self,
            input: std::option::Option<crate::model::ShareMethod>,
        ) -> Self {
            self.share_method = input;
            self
        }
        /// <p>A directory share request that is sent by the directory owner to the directory consumer.
        /// The request includes a typed message to help the directory consumer administrator determine
        /// whether to approve or reject the share invitation.</p>
        pub fn share_notes(mut self, input: impl Into<std::string::String>) -> Self {
            self.share_notes = Some(input.into());
            self
        }
        /// <p>A directory share request that is sent by the directory owner to the directory consumer.
        /// The request includes a typed message to help the directory consumer administrator determine
        /// whether to approve or reject the share invitation.</p>
        pub fn set_share_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.share_notes = input;
            self
        }
        /// <p>Specifies when the directory was created.</p>
        pub fn launch_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.launch_time = Some(input);
            self
        }
        /// <p>Specifies when the directory was created.</p>
        pub fn set_launch_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.launch_time = input;
            self
        }
        /// <p>The date and time that the stage was last updated.</p>
        pub fn stage_last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.stage_last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time that the stage was last updated.</p>
        pub fn set_stage_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.stage_last_updated_date_time = input;
            self
        }
        /// <p>The directory size.</p>
        pub fn r#type(mut self, input: crate::model::DirectoryType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The directory size.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::DirectoryType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>A <a>DirectoryVpcSettingsDescription</a> object that contains additional
        /// information about a directory. This member is only present if the directory is a Simple AD or
        /// Managed Microsoft AD directory.</p>
        pub fn vpc_settings(
            mut self,
            input: crate::model::DirectoryVpcSettingsDescription,
        ) -> Self {
            self.vpc_settings = Some(input);
            self
        }
        /// <p>A <a>DirectoryVpcSettingsDescription</a> object that contains additional
        /// information about a directory. This member is only present if the directory is a Simple AD or
        /// Managed Microsoft AD directory.</p>
        pub fn set_vpc_settings(
            mut self,
            input: std::option::Option<crate::model::DirectoryVpcSettingsDescription>,
        ) -> Self {
            self.vpc_settings = input;
            self
        }
        /// <p>A <a>DirectoryConnectSettingsDescription</a> object that contains additional
        /// information about an AD Connector directory. This member is only present if the directory is
        /// an AD Connector directory.</p>
        pub fn connect_settings(
            mut self,
            input: crate::model::DirectoryConnectSettingsDescription,
        ) -> Self {
            self.connect_settings = Some(input);
            self
        }
        /// <p>A <a>DirectoryConnectSettingsDescription</a> object that contains additional
        /// information about an AD Connector directory. This member is only present if the directory is
        /// an AD Connector directory.</p>
        pub fn set_connect_settings(
            mut self,
            input: std::option::Option<crate::model::DirectoryConnectSettingsDescription>,
        ) -> Self {
            self.connect_settings = input;
            self
        }
        /// <p>A <a>RadiusSettings</a> object that contains information about the RADIUS
        /// server configured for this directory.</p>
        pub fn radius_settings(mut self, input: crate::model::RadiusSettings) -> Self {
            self.radius_settings = Some(input);
            self
        }
        /// <p>A <a>RadiusSettings</a> object that contains information about the RADIUS
        /// server configured for this directory.</p>
        pub fn set_radius_settings(
            mut self,
            input: std::option::Option<crate::model::RadiusSettings>,
        ) -> Self {
            self.radius_settings = input;
            self
        }
        /// <p>The status of the RADIUS MFA server connection.</p>
        pub fn radius_status(mut self, input: crate::model::RadiusStatus) -> Self {
            self.radius_status = Some(input);
            self
        }
        /// <p>The status of the RADIUS MFA server connection.</p>
        pub fn set_radius_status(
            mut self,
            input: std::option::Option<crate::model::RadiusStatus>,
        ) -> Self {
            self.radius_status = input;
            self
        }
        /// <p>Additional information about the directory stage.</p>
        pub fn stage_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_reason = Some(input.into());
            self
        }
        /// <p>Additional information about the directory stage.</p>
        pub fn set_stage_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_reason = input;
            self
        }
        /// <p>Indicates if single sign-on is enabled for the directory. For more information, see <a>EnableSso</a> and <a>DisableSso</a>.</p>
        pub fn sso_enabled(mut self, input: bool) -> Self {
            self.sso_enabled = Some(input);
            self
        }
        /// <p>Indicates if single sign-on is enabled for the directory. For more information, see <a>EnableSso</a> and <a>DisableSso</a>.</p>
        pub fn set_sso_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.sso_enabled = input;
            self
        }
        /// <p>The desired number of domain controllers in the directory if the directory is Microsoft
        /// AD.</p>
        pub fn desired_number_of_domain_controllers(mut self, input: i32) -> Self {
            self.desired_number_of_domain_controllers = Some(input);
            self
        }
        /// <p>The desired number of domain controllers in the directory if the directory is Microsoft
        /// AD.</p>
        pub fn set_desired_number_of_domain_controllers(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.desired_number_of_domain_controllers = input;
            self
        }
        /// <p>Describes the Managed Microsoft AD directory in the directory owner account.</p>
        pub fn owner_directory_description(
            mut self,
            input: crate::model::OwnerDirectoryDescription,
        ) -> Self {
            self.owner_directory_description = Some(input);
            self
        }
        /// <p>Describes the Managed Microsoft AD directory in the directory owner account.</p>
        pub fn set_owner_directory_description(
            mut self,
            input: std::option::Option<crate::model::OwnerDirectoryDescription>,
        ) -> Self {
            self.owner_directory_description = input;
            self
        }
        /// <p>Lists the Regions where the directory has replicated.</p>
        pub fn regions_info(mut self, input: crate::model::RegionsInfo) -> Self {
            self.regions_info = Some(input);
            self
        }
        /// <p>Lists the Regions where the directory has replicated.</p>
        pub fn set_regions_info(
            mut self,
            input: std::option::Option<crate::model::RegionsInfo>,
        ) -> Self {
            self.regions_info = input;
            self
        }
        /// Consumes the builder and constructs a [`DirectoryDescription`](crate::model::DirectoryDescription)
        pub fn build(self) -> crate::model::DirectoryDescription {
            crate::model::DirectoryDescription {
                directory_id: self.directory_id,
                name: self.name,
                short_name: self.short_name,
                size: self.size,
                edition: self.edition,
                alias: self.alias,
                access_url: self.access_url,
                description: self.description,
                dns_ip_addrs: self.dns_ip_addrs,
                stage: self.stage,
                share_status: self.share_status,
                share_method: self.share_method,
                share_notes: self.share_notes,
                launch_time: self.launch_time,
                stage_last_updated_date_time: self.stage_last_updated_date_time,
                r#type: self.r#type,
                vpc_settings: self.vpc_settings,
                connect_settings: self.connect_settings,
                radius_settings: self.radius_settings,
                radius_status: self.radius_status,
                stage_reason: self.stage_reason,
                sso_enabled: self.sso_enabled.unwrap_or_default(),
                desired_number_of_domain_controllers: self
                    .desired_number_of_domain_controllers
                    .unwrap_or_default(),
                owner_directory_description: self.owner_directory_description,
                regions_info: self.regions_info,
            }
        }
    }
}
impl DirectoryDescription {
    /// Creates a new builder-style object to manufacture [`DirectoryDescription`](crate::model::DirectoryDescription)
    pub fn builder() -> crate::model::directory_description::Builder {
        crate::model::directory_description::Builder::default()
    }
}

/// <p>Provides information about the Regions that are configured for multi-Region
/// replication.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegionsInfo {
    /// <p>The Region where the Managed Microsoft AD directory was originally created.</p>
    pub primary_region: std::option::Option<std::string::String>,
    /// <p>Lists the Regions where the directory has been replicated, excluding the primary
    /// Region.</p>
    pub additional_regions: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl RegionsInfo {
    /// <p>The Region where the Managed Microsoft AD directory was originally created.</p>
    pub fn primary_region(&self) -> std::option::Option<&str> {
        self.primary_region.as_deref()
    }
    /// <p>Lists the Regions where the directory has been replicated, excluding the primary
    /// Region.</p>
    pub fn additional_regions(&self) -> std::option::Option<&[std::string::String]> {
        self.additional_regions.as_deref()
    }
}
impl std::fmt::Debug for RegionsInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegionsInfo");
        formatter.field("primary_region", &self.primary_region);
        formatter.field("additional_regions", &self.additional_regions);
        formatter.finish()
    }
}
/// See [`RegionsInfo`](crate::model::RegionsInfo)
pub mod regions_info {
    /// A builder for [`RegionsInfo`](crate::model::RegionsInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) primary_region: std::option::Option<std::string::String>,
        pub(crate) additional_regions: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Region where the Managed Microsoft AD directory was originally created.</p>
        pub fn primary_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.primary_region = Some(input.into());
            self
        }
        /// <p>The Region where the Managed Microsoft AD directory was originally created.</p>
        pub fn set_primary_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.primary_region = input;
            self
        }
        /// Appends an item to `additional_regions`.
        ///
        /// To override the contents of this collection use [`set_additional_regions`](Self::set_additional_regions).
        ///
        /// <p>Lists the Regions where the directory has been replicated, excluding the primary
        /// Region.</p>
        pub fn additional_regions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.additional_regions.unwrap_or_default();
            v.push(input.into());
            self.additional_regions = Some(v);
            self
        }
        /// <p>Lists the Regions where the directory has been replicated, excluding the primary
        /// Region.</p>
        pub fn set_additional_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.additional_regions = input;
            self
        }
        /// Consumes the builder and constructs a [`RegionsInfo`](crate::model::RegionsInfo)
        pub fn build(self) -> crate::model::RegionsInfo {
            crate::model::RegionsInfo {
                primary_region: self.primary_region,
                additional_regions: self.additional_regions,
            }
        }
    }
}
impl RegionsInfo {
    /// Creates a new builder-style object to manufacture [`RegionsInfo`](crate::model::RegionsInfo)
    pub fn builder() -> crate::model::regions_info::Builder {
        crate::model::regions_info::Builder::default()
    }
}

/// <p>Describes the directory owner account details that have been shared to the directory
/// consumer account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OwnerDirectoryDescription {
    /// <p>Identifier of the Managed Microsoft AD directory in the directory owner
    /// account.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>Identifier of the directory owner account.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>IP address of the directory’s domain controllers.</p>
    pub dns_ip_addrs: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Information about the VPC settings for the directory.</p>
    pub vpc_settings: std::option::Option<crate::model::DirectoryVpcSettingsDescription>,
    /// <p>A <a>RadiusSettings</a> object that contains information about the RADIUS
    /// server.</p>
    pub radius_settings: std::option::Option<crate::model::RadiusSettings>,
    /// <p>Information about the status of the RADIUS server.</p>
    pub radius_status: std::option::Option<crate::model::RadiusStatus>,
}
impl OwnerDirectoryDescription {
    /// <p>Identifier of the Managed Microsoft AD directory in the directory owner
    /// account.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>Identifier of the directory owner account.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>IP address of the directory’s domain controllers.</p>
    pub fn dns_ip_addrs(&self) -> std::option::Option<&[std::string::String]> {
        self.dns_ip_addrs.as_deref()
    }
    /// <p>Information about the VPC settings for the directory.</p>
    pub fn vpc_settings(
        &self,
    ) -> std::option::Option<&crate::model::DirectoryVpcSettingsDescription> {
        self.vpc_settings.as_ref()
    }
    /// <p>A <a>RadiusSettings</a> object that contains information about the RADIUS
    /// server.</p>
    pub fn radius_settings(&self) -> std::option::Option<&crate::model::RadiusSettings> {
        self.radius_settings.as_ref()
    }
    /// <p>Information about the status of the RADIUS server.</p>
    pub fn radius_status(&self) -> std::option::Option<&crate::model::RadiusStatus> {
        self.radius_status.as_ref()
    }
}
impl std::fmt::Debug for OwnerDirectoryDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OwnerDirectoryDescription");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("account_id", &self.account_id);
        formatter.field("dns_ip_addrs", &self.dns_ip_addrs);
        formatter.field("vpc_settings", &self.vpc_settings);
        formatter.field("radius_settings", &self.radius_settings);
        formatter.field("radius_status", &self.radius_status);
        formatter.finish()
    }
}
/// See [`OwnerDirectoryDescription`](crate::model::OwnerDirectoryDescription)
pub mod owner_directory_description {
    /// A builder for [`OwnerDirectoryDescription`](crate::model::OwnerDirectoryDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) dns_ip_addrs: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) vpc_settings: std::option::Option<crate::model::DirectoryVpcSettingsDescription>,
        pub(crate) radius_settings: std::option::Option<crate::model::RadiusSettings>,
        pub(crate) radius_status: std::option::Option<crate::model::RadiusStatus>,
    }
    impl Builder {
        /// <p>Identifier of the Managed Microsoft AD directory in the directory owner
        /// account.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>Identifier of the Managed Microsoft AD directory in the directory owner
        /// account.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>Identifier of the directory owner account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>Identifier of the directory owner account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Appends an item to `dns_ip_addrs`.
        ///
        /// To override the contents of this collection use [`set_dns_ip_addrs`](Self::set_dns_ip_addrs).
        ///
        /// <p>IP address of the directory’s domain controllers.</p>
        pub fn dns_ip_addrs(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.dns_ip_addrs.unwrap_or_default();
            v.push(input.into());
            self.dns_ip_addrs = Some(v);
            self
        }
        /// <p>IP address of the directory’s domain controllers.</p>
        pub fn set_dns_ip_addrs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.dns_ip_addrs = input;
            self
        }
        /// <p>Information about the VPC settings for the directory.</p>
        pub fn vpc_settings(
            mut self,
            input: crate::model::DirectoryVpcSettingsDescription,
        ) -> Self {
            self.vpc_settings = Some(input);
            self
        }
        /// <p>Information about the VPC settings for the directory.</p>
        pub fn set_vpc_settings(
            mut self,
            input: std::option::Option<crate::model::DirectoryVpcSettingsDescription>,
        ) -> Self {
            self.vpc_settings = input;
            self
        }
        /// <p>A <a>RadiusSettings</a> object that contains information about the RADIUS
        /// server.</p>
        pub fn radius_settings(mut self, input: crate::model::RadiusSettings) -> Self {
            self.radius_settings = Some(input);
            self
        }
        /// <p>A <a>RadiusSettings</a> object that contains information about the RADIUS
        /// server.</p>
        pub fn set_radius_settings(
            mut self,
            input: std::option::Option<crate::model::RadiusSettings>,
        ) -> Self {
            self.radius_settings = input;
            self
        }
        /// <p>Information about the status of the RADIUS server.</p>
        pub fn radius_status(mut self, input: crate::model::RadiusStatus) -> Self {
            self.radius_status = Some(input);
            self
        }
        /// <p>Information about the status of the RADIUS server.</p>
        pub fn set_radius_status(
            mut self,
            input: std::option::Option<crate::model::RadiusStatus>,
        ) -> Self {
            self.radius_status = input;
            self
        }
        /// Consumes the builder and constructs a [`OwnerDirectoryDescription`](crate::model::OwnerDirectoryDescription)
        pub fn build(self) -> crate::model::OwnerDirectoryDescription {
            crate::model::OwnerDirectoryDescription {
                directory_id: self.directory_id,
                account_id: self.account_id,
                dns_ip_addrs: self.dns_ip_addrs,
                vpc_settings: self.vpc_settings,
                radius_settings: self.radius_settings,
                radius_status: self.radius_status,
            }
        }
    }
}
impl OwnerDirectoryDescription {
    /// Creates a new builder-style object to manufacture [`OwnerDirectoryDescription`](crate::model::OwnerDirectoryDescription)
    pub fn builder() -> crate::model::owner_directory_description::Builder {
        crate::model::owner_directory_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RadiusStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RadiusStatus {
    fn from(s: &str) -> Self {
        match s {
            "Completed" => RadiusStatus::Completed,
            "Creating" => RadiusStatus::Creating,
            "Failed" => RadiusStatus::Failed,
            other => RadiusStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RadiusStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RadiusStatus::from(s))
    }
}
impl RadiusStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RadiusStatus::Completed => "Completed",
            RadiusStatus::Creating => "Creating",
            RadiusStatus::Failed => "Failed",
            RadiusStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Completed", "Creating", "Failed"]
    }
}
impl AsRef<str> for RadiusStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the directory.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DirectoryVpcSettingsDescription {
    /// <p>The identifier of the VPC that the directory is in.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The identifiers of the subnets for the directory servers.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The domain controller security group identifier for the directory.</p>
    pub security_group_id: std::option::Option<std::string::String>,
    /// <p>The list of Availability Zones that the directory is in.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DirectoryVpcSettingsDescription {
    /// <p>The identifier of the VPC that the directory is in.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The identifiers of the subnets for the directory servers.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>The domain controller security group identifier for the directory.</p>
    pub fn security_group_id(&self) -> std::option::Option<&str> {
        self.security_group_id.as_deref()
    }
    /// <p>The list of Availability Zones that the directory is in.</p>
    pub fn availability_zones(&self) -> std::option::Option<&[std::string::String]> {
        self.availability_zones.as_deref()
    }
}
impl std::fmt::Debug for DirectoryVpcSettingsDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DirectoryVpcSettingsDescription");
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("security_group_id", &self.security_group_id);
        formatter.field("availability_zones", &self.availability_zones);
        formatter.finish()
    }
}
/// See [`DirectoryVpcSettingsDescription`](crate::model::DirectoryVpcSettingsDescription)
pub mod directory_vpc_settings_description {
    /// A builder for [`DirectoryVpcSettingsDescription`](crate::model::DirectoryVpcSettingsDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_group_id: std::option::Option<std::string::String>,
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The identifier of the VPC that the directory is in.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The identifier of the VPC that the directory is in.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The identifiers of the subnets for the directory servers.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>The identifiers of the subnets for the directory servers.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// <p>The domain controller security group identifier for the directory.</p>
        pub fn security_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_group_id = Some(input.into());
            self
        }
        /// <p>The domain controller security group identifier for the directory.</p>
        pub fn set_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_group_id = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>The list of Availability Zones that the directory is in.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>The list of Availability Zones that the directory is in.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// Consumes the builder and constructs a [`DirectoryVpcSettingsDescription`](crate::model::DirectoryVpcSettingsDescription)
        pub fn build(self) -> crate::model::DirectoryVpcSettingsDescription {
            crate::model::DirectoryVpcSettingsDescription {
                vpc_id: self.vpc_id,
                subnet_ids: self.subnet_ids,
                security_group_id: self.security_group_id,
                availability_zones: self.availability_zones,
            }
        }
    }
}
impl DirectoryVpcSettingsDescription {
    /// Creates a new builder-style object to manufacture [`DirectoryVpcSettingsDescription`](crate::model::DirectoryVpcSettingsDescription)
    pub fn builder() -> crate::model::directory_vpc_settings_description::Builder {
        crate::model::directory_vpc_settings_description::Builder::default()
    }
}

/// <p>Contains information about an AD Connector directory.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DirectoryConnectSettingsDescription {
    /// <p>The identifier of the VPC that the AD Connector is in.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>A list of subnet identifiers in the VPC that the AD Connector is in.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The user name of the service account in your self-managed directory.</p>
    pub customer_user_name: std::option::Option<std::string::String>,
    /// <p>The security group identifier for the AD Connector directory.</p>
    pub security_group_id: std::option::Option<std::string::String>,
    /// <p>A list of the Availability Zones that the directory is in.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The IP addresses of the AD Connector servers.</p>
    pub connect_ips: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DirectoryConnectSettingsDescription {
    /// <p>The identifier of the VPC that the AD Connector is in.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>A list of subnet identifiers in the VPC that the AD Connector is in.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>The user name of the service account in your self-managed directory.</p>
    pub fn customer_user_name(&self) -> std::option::Option<&str> {
        self.customer_user_name.as_deref()
    }
    /// <p>The security group identifier for the AD Connector directory.</p>
    pub fn security_group_id(&self) -> std::option::Option<&str> {
        self.security_group_id.as_deref()
    }
    /// <p>A list of the Availability Zones that the directory is in.</p>
    pub fn availability_zones(&self) -> std::option::Option<&[std::string::String]> {
        self.availability_zones.as_deref()
    }
    /// <p>The IP addresses of the AD Connector servers.</p>
    pub fn connect_ips(&self) -> std::option::Option<&[std::string::String]> {
        self.connect_ips.as_deref()
    }
}
impl std::fmt::Debug for DirectoryConnectSettingsDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DirectoryConnectSettingsDescription");
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("customer_user_name", &self.customer_user_name);
        formatter.field("security_group_id", &self.security_group_id);
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("connect_ips", &self.connect_ips);
        formatter.finish()
    }
}
/// See [`DirectoryConnectSettingsDescription`](crate::model::DirectoryConnectSettingsDescription)
pub mod directory_connect_settings_description {
    /// A builder for [`DirectoryConnectSettingsDescription`](crate::model::DirectoryConnectSettingsDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) customer_user_name: std::option::Option<std::string::String>,
        pub(crate) security_group_id: std::option::Option<std::string::String>,
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) connect_ips: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The identifier of the VPC that the AD Connector is in.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The identifier of the VPC that the AD Connector is in.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of subnet identifiers in the VPC that the AD Connector is in.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>A list of subnet identifiers in the VPC that the AD Connector is in.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// <p>The user name of the service account in your self-managed directory.</p>
        pub fn customer_user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_user_name = Some(input.into());
            self
        }
        /// <p>The user name of the service account in your self-managed directory.</p>
        pub fn set_customer_user_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_user_name = input;
            self
        }
        /// <p>The security group identifier for the AD Connector directory.</p>
        pub fn security_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_group_id = Some(input.into());
            self
        }
        /// <p>The security group identifier for the AD Connector directory.</p>
        pub fn set_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_group_id = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>A list of the Availability Zones that the directory is in.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>A list of the Availability Zones that the directory is in.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// Appends an item to `connect_ips`.
        ///
        /// To override the contents of this collection use [`set_connect_ips`](Self::set_connect_ips).
        ///
        /// <p>The IP addresses of the AD Connector servers.</p>
        pub fn connect_ips(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.connect_ips.unwrap_or_default();
            v.push(input.into());
            self.connect_ips = Some(v);
            self
        }
        /// <p>The IP addresses of the AD Connector servers.</p>
        pub fn set_connect_ips(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.connect_ips = input;
            self
        }
        /// Consumes the builder and constructs a [`DirectoryConnectSettingsDescription`](crate::model::DirectoryConnectSettingsDescription)
        pub fn build(self) -> crate::model::DirectoryConnectSettingsDescription {
            crate::model::DirectoryConnectSettingsDescription {
                vpc_id: self.vpc_id,
                subnet_ids: self.subnet_ids,
                customer_user_name: self.customer_user_name,
                security_group_id: self.security_group_id,
                availability_zones: self.availability_zones,
                connect_ips: self.connect_ips,
            }
        }
    }
}
impl DirectoryConnectSettingsDescription {
    /// Creates a new builder-style object to manufacture [`DirectoryConnectSettingsDescription`](crate::model::DirectoryConnectSettingsDescription)
    pub fn builder() -> crate::model::directory_connect_settings_description::Builder {
        crate::model::directory_connect_settings_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DirectoryType {
    #[allow(missing_docs)] // documentation missing in model
    AdConnector,
    #[allow(missing_docs)] // documentation missing in model
    MicrosoftAd,
    #[allow(missing_docs)] // documentation missing in model
    SharedMicrosoftAd,
    #[allow(missing_docs)] // documentation missing in model
    SimpleAd,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DirectoryType {
    fn from(s: &str) -> Self {
        match s {
            "ADConnector" => DirectoryType::AdConnector,
            "MicrosoftAD" => DirectoryType::MicrosoftAd,
            "SharedMicrosoftAD" => DirectoryType::SharedMicrosoftAd,
            "SimpleAD" => DirectoryType::SimpleAd,
            other => DirectoryType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DirectoryType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DirectoryType::from(s))
    }
}
impl DirectoryType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DirectoryType::AdConnector => "ADConnector",
            DirectoryType::MicrosoftAd => "MicrosoftAD",
            DirectoryType::SharedMicrosoftAd => "SharedMicrosoftAD",
            DirectoryType::SimpleAd => "SimpleAD",
            DirectoryType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADConnector",
            "MicrosoftAD",
            "SharedMicrosoftAD",
            "SimpleAD",
        ]
    }
}
impl AsRef<str> for DirectoryType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DirectoryEdition {
    #[allow(missing_docs)] // documentation missing in model
    Enterprise,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DirectoryEdition {
    fn from(s: &str) -> Self {
        match s {
            "Enterprise" => DirectoryEdition::Enterprise,
            "Standard" => DirectoryEdition::Standard,
            other => DirectoryEdition::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DirectoryEdition {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DirectoryEdition::from(s))
    }
}
impl DirectoryEdition {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DirectoryEdition::Enterprise => "Enterprise",
            DirectoryEdition::Standard => "Standard",
            DirectoryEdition::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Enterprise", "Standard"]
    }
}
impl AsRef<str> for DirectoryEdition {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DirectorySize {
    #[allow(missing_docs)] // documentation missing in model
    Large,
    #[allow(missing_docs)] // documentation missing in model
    Small,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DirectorySize {
    fn from(s: &str) -> Self {
        match s {
            "Large" => DirectorySize::Large,
            "Small" => DirectorySize::Small,
            other => DirectorySize::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DirectorySize {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DirectorySize::from(s))
    }
}
impl DirectorySize {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DirectorySize::Large => "Large",
            DirectorySize::Small => "Small",
            DirectorySize::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Large", "Small"]
    }
}
impl AsRef<str> for DirectorySize {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Points to a remote domain with which you are setting up a trust relationship.
/// Conditional forwarders are required in order to set up a trust relationship with another
/// domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConditionalForwarder {
    /// <p>The fully qualified domain name (FQDN) of the remote domains pointed to by the
    /// conditional forwarder.</p>
    pub remote_domain_name: std::option::Option<std::string::String>,
    /// <p>The IP addresses of the remote DNS server associated with RemoteDomainName. This is the
    /// IP address of the DNS server that your conditional forwarder points to.</p>
    pub dns_ip_addrs: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The replication scope of the conditional forwarder. The only allowed value is
    /// <code>Domain</code>, which will replicate the conditional forwarder to all of the domain
    /// controllers for your Amazon Web Services directory.</p>
    pub replication_scope: std::option::Option<crate::model::ReplicationScope>,
}
impl ConditionalForwarder {
    /// <p>The fully qualified domain name (FQDN) of the remote domains pointed to by the
    /// conditional forwarder.</p>
    pub fn remote_domain_name(&self) -> std::option::Option<&str> {
        self.remote_domain_name.as_deref()
    }
    /// <p>The IP addresses of the remote DNS server associated with RemoteDomainName. This is the
    /// IP address of the DNS server that your conditional forwarder points to.</p>
    pub fn dns_ip_addrs(&self) -> std::option::Option<&[std::string::String]> {
        self.dns_ip_addrs.as_deref()
    }
    /// <p>The replication scope of the conditional forwarder. The only allowed value is
    /// <code>Domain</code>, which will replicate the conditional forwarder to all of the domain
    /// controllers for your Amazon Web Services directory.</p>
    pub fn replication_scope(&self) -> std::option::Option<&crate::model::ReplicationScope> {
        self.replication_scope.as_ref()
    }
}
impl std::fmt::Debug for ConditionalForwarder {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConditionalForwarder");
        formatter.field("remote_domain_name", &self.remote_domain_name);
        formatter.field("dns_ip_addrs", &self.dns_ip_addrs);
        formatter.field("replication_scope", &self.replication_scope);
        formatter.finish()
    }
}
/// See [`ConditionalForwarder`](crate::model::ConditionalForwarder)
pub mod conditional_forwarder {
    /// A builder for [`ConditionalForwarder`](crate::model::ConditionalForwarder)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) remote_domain_name: std::option::Option<std::string::String>,
        pub(crate) dns_ip_addrs: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) replication_scope: std::option::Option<crate::model::ReplicationScope>,
    }
    impl Builder {
        /// <p>The fully qualified domain name (FQDN) of the remote domains pointed to by the
        /// conditional forwarder.</p>
        pub fn remote_domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.remote_domain_name = Some(input.into());
            self
        }
        /// <p>The fully qualified domain name (FQDN) of the remote domains pointed to by the
        /// conditional forwarder.</p>
        pub fn set_remote_domain_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.remote_domain_name = input;
            self
        }
        /// Appends an item to `dns_ip_addrs`.
        ///
        /// To override the contents of this collection use [`set_dns_ip_addrs`](Self::set_dns_ip_addrs).
        ///
        /// <p>The IP addresses of the remote DNS server associated with RemoteDomainName. This is the
        /// IP address of the DNS server that your conditional forwarder points to.</p>
        pub fn dns_ip_addrs(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.dns_ip_addrs.unwrap_or_default();
            v.push(input.into());
            self.dns_ip_addrs = Some(v);
            self
        }
        /// <p>The IP addresses of the remote DNS server associated with RemoteDomainName. This is the
        /// IP address of the DNS server that your conditional forwarder points to.</p>
        pub fn set_dns_ip_addrs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.dns_ip_addrs = input;
            self
        }
        /// <p>The replication scope of the conditional forwarder. The only allowed value is
        /// <code>Domain</code>, which will replicate the conditional forwarder to all of the domain
        /// controllers for your Amazon Web Services directory.</p>
        pub fn replication_scope(mut self, input: crate::model::ReplicationScope) -> Self {
            self.replication_scope = Some(input);
            self
        }
        /// <p>The replication scope of the conditional forwarder. The only allowed value is
        /// <code>Domain</code>, which will replicate the conditional forwarder to all of the domain
        /// controllers for your Amazon Web Services directory.</p>
        pub fn set_replication_scope(
            mut self,
            input: std::option::Option<crate::model::ReplicationScope>,
        ) -> Self {
            self.replication_scope = input;
            self
        }
        /// Consumes the builder and constructs a [`ConditionalForwarder`](crate::model::ConditionalForwarder)
        pub fn build(self) -> crate::model::ConditionalForwarder {
            crate::model::ConditionalForwarder {
                remote_domain_name: self.remote_domain_name,
                dns_ip_addrs: self.dns_ip_addrs,
                replication_scope: self.replication_scope,
            }
        }
    }
}
impl ConditionalForwarder {
    /// Creates a new builder-style object to manufacture [`ConditionalForwarder`](crate::model::ConditionalForwarder)
    pub fn builder() -> crate::model::conditional_forwarder::Builder {
        crate::model::conditional_forwarder::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReplicationScope {
    #[allow(missing_docs)] // documentation missing in model
    Domain,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReplicationScope {
    fn from(s: &str) -> Self {
        match s {
            "Domain" => ReplicationScope::Domain,
            other => ReplicationScope::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReplicationScope {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReplicationScope::from(s))
    }
}
impl ReplicationScope {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReplicationScope::Domain => "Domain",
            ReplicationScope::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Domain"]
    }
}
impl AsRef<str> for ReplicationScope {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a client authentication method for a directory.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClientAuthenticationSettingInfo {
    /// <p>The type of client authentication for the specified directory. If no type is specified, a list of all client authentication types that are supported for the directory is retrieved. </p>
    pub r#type: std::option::Option<crate::model::ClientAuthenticationType>,
    /// <p>Whether the client authentication type is enabled or disabled for the specified directory.</p>
    pub status: std::option::Option<crate::model::ClientAuthenticationStatus>,
    /// <p>The date and time when the status of the client authentication type was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl ClientAuthenticationSettingInfo {
    /// <p>The type of client authentication for the specified directory. If no type is specified, a list of all client authentication types that are supported for the directory is retrieved. </p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ClientAuthenticationType> {
        self.r#type.as_ref()
    }
    /// <p>Whether the client authentication type is enabled or disabled for the specified directory.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ClientAuthenticationStatus> {
        self.status.as_ref()
    }
    /// <p>The date and time when the status of the client authentication type was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
}
impl std::fmt::Debug for ClientAuthenticationSettingInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClientAuthenticationSettingInfo");
        formatter.field("r#type", &self.r#type);
        formatter.field("status", &self.status);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`ClientAuthenticationSettingInfo`](crate::model::ClientAuthenticationSettingInfo)
pub mod client_authentication_setting_info {
    /// A builder for [`ClientAuthenticationSettingInfo`](crate::model::ClientAuthenticationSettingInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::ClientAuthenticationType>,
        pub(crate) status: std::option::Option<crate::model::ClientAuthenticationStatus>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The type of client authentication for the specified directory. If no type is specified, a list of all client authentication types that are supported for the directory is retrieved. </p>
        pub fn r#type(mut self, input: crate::model::ClientAuthenticationType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of client authentication for the specified directory. If no type is specified, a list of all client authentication types that are supported for the directory is retrieved. </p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ClientAuthenticationType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Whether the client authentication type is enabled or disabled for the specified directory.</p>
        pub fn status(mut self, input: crate::model::ClientAuthenticationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Whether the client authentication type is enabled or disabled for the specified directory.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ClientAuthenticationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time when the status of the client authentication type was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time when the status of the client authentication type was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ClientAuthenticationSettingInfo`](crate::model::ClientAuthenticationSettingInfo)
        pub fn build(self) -> crate::model::ClientAuthenticationSettingInfo {
            crate::model::ClientAuthenticationSettingInfo {
                r#type: self.r#type,
                status: self.status,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl ClientAuthenticationSettingInfo {
    /// Creates a new builder-style object to manufacture [`ClientAuthenticationSettingInfo`](crate::model::ClientAuthenticationSettingInfo)
    pub fn builder() -> crate::model::client_authentication_setting_info::Builder {
        crate::model::client_authentication_setting_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ClientAuthenticationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ClientAuthenticationStatus {
    fn from(s: &str) -> Self {
        match s {
            "Disabled" => ClientAuthenticationStatus::Disabled,
            "Enabled" => ClientAuthenticationStatus::Enabled,
            other => ClientAuthenticationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ClientAuthenticationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ClientAuthenticationStatus::from(s))
    }
}
impl ClientAuthenticationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ClientAuthenticationStatus::Disabled => "Disabled",
            ClientAuthenticationStatus::Enabled => "Enabled",
            ClientAuthenticationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Disabled", "Enabled"]
    }
}
impl AsRef<str> for ClientAuthenticationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the certificate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Certificate {
    /// <p>The identifier of the certificate.</p>
    pub certificate_id: std::option::Option<std::string::String>,
    /// <p>The state of the certificate.</p>
    pub state: std::option::Option<crate::model::CertificateState>,
    /// <p>Describes a state change for the certificate.</p>
    pub state_reason: std::option::Option<std::string::String>,
    /// <p>The common name for the certificate.</p>
    pub common_name: std::option::Option<std::string::String>,
    /// <p>The date and time that the certificate was registered.</p>
    pub registered_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time when the certificate will expire.</p>
    pub expiry_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.</p>
    pub r#type: std::option::Option<crate::model::CertificateType>,
    /// <p>A <code>ClientCertAuthSettings</code> object that contains client certificate authentication settings.</p>
    pub client_cert_auth_settings: std::option::Option<crate::model::ClientCertAuthSettings>,
}
impl Certificate {
    /// <p>The identifier of the certificate.</p>
    pub fn certificate_id(&self) -> std::option::Option<&str> {
        self.certificate_id.as_deref()
    }
    /// <p>The state of the certificate.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::CertificateState> {
        self.state.as_ref()
    }
    /// <p>Describes a state change for the certificate.</p>
    pub fn state_reason(&self) -> std::option::Option<&str> {
        self.state_reason.as_deref()
    }
    /// <p>The common name for the certificate.</p>
    pub fn common_name(&self) -> std::option::Option<&str> {
        self.common_name.as_deref()
    }
    /// <p>The date and time that the certificate was registered.</p>
    pub fn registered_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.registered_date_time.as_ref()
    }
    /// <p>The date and time when the certificate will expire.</p>
    pub fn expiry_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.expiry_date_time.as_ref()
    }
    /// <p>The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::CertificateType> {
        self.r#type.as_ref()
    }
    /// <p>A <code>ClientCertAuthSettings</code> object that contains client certificate authentication settings.</p>
    pub fn client_cert_auth_settings(
        &self,
    ) -> std::option::Option<&crate::model::ClientCertAuthSettings> {
        self.client_cert_auth_settings.as_ref()
    }
}
impl std::fmt::Debug for Certificate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Certificate");
        formatter.field("certificate_id", &self.certificate_id);
        formatter.field("state", &self.state);
        formatter.field("state_reason", &self.state_reason);
        formatter.field("common_name", &self.common_name);
        formatter.field("registered_date_time", &self.registered_date_time);
        formatter.field("expiry_date_time", &self.expiry_date_time);
        formatter.field("r#type", &self.r#type);
        formatter.field("client_cert_auth_settings", &self.client_cert_auth_settings);
        formatter.finish()
    }
}
/// See [`Certificate`](crate::model::Certificate)
pub mod certificate {
    /// A builder for [`Certificate`](crate::model::Certificate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::CertificateState>,
        pub(crate) state_reason: std::option::Option<std::string::String>,
        pub(crate) common_name: std::option::Option<std::string::String>,
        pub(crate) registered_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) expiry_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) r#type: std::option::Option<crate::model::CertificateType>,
        pub(crate) client_cert_auth_settings:
            std::option::Option<crate::model::ClientCertAuthSettings>,
    }
    impl Builder {
        /// <p>The identifier of the certificate.</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_id = Some(input.into());
            self
        }
        /// <p>The identifier of the certificate.</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_id = input;
            self
        }
        /// <p>The state of the certificate.</p>
        pub fn state(mut self, input: crate::model::CertificateState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the certificate.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::CertificateState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>Describes a state change for the certificate.</p>
        pub fn state_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_reason = Some(input.into());
            self
        }
        /// <p>Describes a state change for the certificate.</p>
        pub fn set_state_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state_reason = input;
            self
        }
        /// <p>The common name for the certificate.</p>
        pub fn common_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.common_name = Some(input.into());
            self
        }
        /// <p>The common name for the certificate.</p>
        pub fn set_common_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.common_name = input;
            self
        }
        /// <p>The date and time that the certificate was registered.</p>
        pub fn registered_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.registered_date_time = Some(input);
            self
        }
        /// <p>The date and time that the certificate was registered.</p>
        pub fn set_registered_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.registered_date_time = input;
            self
        }
        /// <p>The date and time when the certificate will expire.</p>
        pub fn expiry_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.expiry_date_time = Some(input);
            self
        }
        /// <p>The date and time when the certificate will expire.</p>
        pub fn set_expiry_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.expiry_date_time = input;
            self
        }
        /// <p>The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.</p>
        pub fn r#type(mut self, input: crate::model::CertificateType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::CertificateType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>A <code>ClientCertAuthSettings</code> object that contains client certificate authentication settings.</p>
        pub fn client_cert_auth_settings(
            mut self,
            input: crate::model::ClientCertAuthSettings,
        ) -> Self {
            self.client_cert_auth_settings = Some(input);
            self
        }
        /// <p>A <code>ClientCertAuthSettings</code> object that contains client certificate authentication settings.</p>
        pub fn set_client_cert_auth_settings(
            mut self,
            input: std::option::Option<crate::model::ClientCertAuthSettings>,
        ) -> Self {
            self.client_cert_auth_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`Certificate`](crate::model::Certificate)
        pub fn build(self) -> crate::model::Certificate {
            crate::model::Certificate {
                certificate_id: self.certificate_id,
                state: self.state,
                state_reason: self.state_reason,
                common_name: self.common_name,
                registered_date_time: self.registered_date_time,
                expiry_date_time: self.expiry_date_time,
                r#type: self.r#type,
                client_cert_auth_settings: self.client_cert_auth_settings,
            }
        }
    }
}
impl Certificate {
    /// Creates a new builder-style object to manufacture [`Certificate`](crate::model::Certificate)
    pub fn builder() -> crate::model::certificate::Builder {
        crate::model::certificate::Builder::default()
    }
}

/// <p>Contains information about a computer account in a directory.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Computer {
    /// <p>The identifier of the computer.</p>
    pub computer_id: std::option::Option<std::string::String>,
    /// <p>The computer name.</p>
    pub computer_name: std::option::Option<std::string::String>,
    /// <p>An array of <a>Attribute</a> objects containing the LDAP attributes that belong to the
    /// computer account.</p>
    pub computer_attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
}
impl Computer {
    /// <p>The identifier of the computer.</p>
    pub fn computer_id(&self) -> std::option::Option<&str> {
        self.computer_id.as_deref()
    }
    /// <p>The computer name.</p>
    pub fn computer_name(&self) -> std::option::Option<&str> {
        self.computer_name.as_deref()
    }
    /// <p>An array of <a>Attribute</a> objects containing the LDAP attributes that belong to the
    /// computer account.</p>
    pub fn computer_attributes(&self) -> std::option::Option<&[crate::model::Attribute]> {
        self.computer_attributes.as_deref()
    }
}
impl std::fmt::Debug for Computer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Computer");
        formatter.field("computer_id", &self.computer_id);
        formatter.field("computer_name", &self.computer_name);
        formatter.field("computer_attributes", &self.computer_attributes);
        formatter.finish()
    }
}
/// See [`Computer`](crate::model::Computer)
pub mod computer {
    /// A builder for [`Computer`](crate::model::Computer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) computer_id: std::option::Option<std::string::String>,
        pub(crate) computer_name: std::option::Option<std::string::String>,
        pub(crate) computer_attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
    }
    impl Builder {
        /// <p>The identifier of the computer.</p>
        pub fn computer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.computer_id = Some(input.into());
            self
        }
        /// <p>The identifier of the computer.</p>
        pub fn set_computer_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.computer_id = input;
            self
        }
        /// <p>The computer name.</p>
        pub fn computer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.computer_name = Some(input.into());
            self
        }
        /// <p>The computer name.</p>
        pub fn set_computer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.computer_name = input;
            self
        }
        /// Appends an item to `computer_attributes`.
        ///
        /// To override the contents of this collection use [`set_computer_attributes`](Self::set_computer_attributes).
        ///
        /// <p>An array of <a>Attribute</a> objects containing the LDAP attributes that belong to the
        /// computer account.</p>
        pub fn computer_attributes(mut self, input: impl Into<crate::model::Attribute>) -> Self {
            let mut v = self.computer_attributes.unwrap_or_default();
            v.push(input.into());
            self.computer_attributes = Some(v);
            self
        }
        /// <p>An array of <a>Attribute</a> objects containing the LDAP attributes that belong to the
        /// computer account.</p>
        pub fn set_computer_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.computer_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`Computer`](crate::model::Computer)
        pub fn build(self) -> crate::model::Computer {
            crate::model::Computer {
                computer_id: self.computer_id,
                computer_name: self.computer_name,
                computer_attributes: self.computer_attributes,
            }
        }
    }
}
impl Computer {
    /// Creates a new builder-style object to manufacture [`Computer`](crate::model::Computer)
    pub fn builder() -> crate::model::computer::Builder {
        crate::model::computer::Builder::default()
    }
}

/// <p>Represents a named directory attribute.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Attribute {
    /// <p>The name of the attribute.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value of the attribute.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Attribute {
    /// <p>The name of the attribute.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The value of the attribute.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Attribute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Attribute");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Attribute`](crate::model::Attribute)
pub mod attribute {
    /// A builder for [`Attribute`](crate::model::Attribute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the attribute.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the attribute.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value of the attribute.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the attribute.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Attribute`](crate::model::Attribute)
        pub fn build(self) -> crate::model::Attribute {
            crate::model::Attribute {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl Attribute {
    /// Creates a new builder-style object to manufacture [`Attribute`](crate::model::Attribute)
    pub fn builder() -> crate::model::attribute::Builder {
        crate::model::attribute::Builder::default()
    }
}

/// <p>Contains information for the <a>ConnectDirectory</a> operation when an AD
/// Connector directory is being created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DirectoryConnectSettings {
    /// <p>The identifier of the VPC in which the AD Connector is created.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>A list of subnet identifiers in the VPC in which the AD Connector is created.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of one or more IP addresses of DNS servers or domain controllers in your self-managed
    /// directory.</p>
    pub customer_dns_ips: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The user name of an account in your self-managed directory that is used to connect to the
    /// directory. This account must have the following permissions:</p>
    /// <ul>
    /// <li>
    /// <p>Read users and groups</p>
    /// </li>
    /// <li>
    /// <p>Create computer objects</p>
    /// </li>
    /// <li>
    /// <p>Join computers to the domain</p>
    /// </li>
    /// </ul>
    pub customer_user_name: std::option::Option<std::string::String>,
}
impl DirectoryConnectSettings {
    /// <p>The identifier of the VPC in which the AD Connector is created.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>A list of subnet identifiers in the VPC in which the AD Connector is created.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>A list of one or more IP addresses of DNS servers or domain controllers in your self-managed
    /// directory.</p>
    pub fn customer_dns_ips(&self) -> std::option::Option<&[std::string::String]> {
        self.customer_dns_ips.as_deref()
    }
    /// <p>The user name of an account in your self-managed directory that is used to connect to the
    /// directory. This account must have the following permissions:</p>
    /// <ul>
    /// <li>
    /// <p>Read users and groups</p>
    /// </li>
    /// <li>
    /// <p>Create computer objects</p>
    /// </li>
    /// <li>
    /// <p>Join computers to the domain</p>
    /// </li>
    /// </ul>
    pub fn customer_user_name(&self) -> std::option::Option<&str> {
        self.customer_user_name.as_deref()
    }
}
impl std::fmt::Debug for DirectoryConnectSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DirectoryConnectSettings");
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("customer_dns_ips", &self.customer_dns_ips);
        formatter.field("customer_user_name", &self.customer_user_name);
        formatter.finish()
    }
}
/// See [`DirectoryConnectSettings`](crate::model::DirectoryConnectSettings)
pub mod directory_connect_settings {
    /// A builder for [`DirectoryConnectSettings`](crate::model::DirectoryConnectSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) customer_dns_ips: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) customer_user_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the VPC in which the AD Connector is created.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The identifier of the VPC in which the AD Connector is created.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of subnet identifiers in the VPC in which the AD Connector is created.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>A list of subnet identifiers in the VPC in which the AD Connector is created.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Appends an item to `customer_dns_ips`.
        ///
        /// To override the contents of this collection use [`set_customer_dns_ips`](Self::set_customer_dns_ips).
        ///
        /// <p>A list of one or more IP addresses of DNS servers or domain controllers in your self-managed
        /// directory.</p>
        pub fn customer_dns_ips(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.customer_dns_ips.unwrap_or_default();
            v.push(input.into());
            self.customer_dns_ips = Some(v);
            self
        }
        /// <p>A list of one or more IP addresses of DNS servers or domain controllers in your self-managed
        /// directory.</p>
        pub fn set_customer_dns_ips(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.customer_dns_ips = input;
            self
        }
        /// <p>The user name of an account in your self-managed directory that is used to connect to the
        /// directory. This account must have the following permissions:</p>
        /// <ul>
        /// <li>
        /// <p>Read users and groups</p>
        /// </li>
        /// <li>
        /// <p>Create computer objects</p>
        /// </li>
        /// <li>
        /// <p>Join computers to the domain</p>
        /// </li>
        /// </ul>
        pub fn customer_user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_user_name = Some(input.into());
            self
        }
        /// <p>The user name of an account in your self-managed directory that is used to connect to the
        /// directory. This account must have the following permissions:</p>
        /// <ul>
        /// <li>
        /// <p>Read users and groups</p>
        /// </li>
        /// <li>
        /// <p>Create computer objects</p>
        /// </li>
        /// <li>
        /// <p>Join computers to the domain</p>
        /// </li>
        /// </ul>
        pub fn set_customer_user_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_user_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DirectoryConnectSettings`](crate::model::DirectoryConnectSettings)
        pub fn build(self) -> crate::model::DirectoryConnectSettings {
            crate::model::DirectoryConnectSettings {
                vpc_id: self.vpc_id,
                subnet_ids: self.subnet_ids,
                customer_dns_ips: self.customer_dns_ips,
                customer_user_name: self.customer_user_name,
            }
        }
    }
}
impl DirectoryConnectSettings {
    /// Creates a new builder-style object to manufacture [`DirectoryConnectSettings`](crate::model::DirectoryConnectSettings)
    pub fn builder() -> crate::model::directory_connect_settings::Builder {
        crate::model::directory_connect_settings::Builder::default()
    }
}

/// <p>IP address block. This is often the address block of the DNS server used for your
/// self-managed domain. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IpRoute {
    /// <p>IP address block using CIDR format, for example 10.0.0.0/24. This is often the
    /// address block of the DNS server used for your self-managed domain. For a single IP address
    /// use a CIDR address block with /32. For example 10.0.0.0/32.</p>
    pub cidr_ip: std::option::Option<std::string::String>,
    /// <p>Description of the address block.</p>
    pub description: std::option::Option<std::string::String>,
}
impl IpRoute {
    /// <p>IP address block using CIDR format, for example 10.0.0.0/24. This is often the
    /// address block of the DNS server used for your self-managed domain. For a single IP address
    /// use a CIDR address block with /32. For example 10.0.0.0/32.</p>
    pub fn cidr_ip(&self) -> std::option::Option<&str> {
        self.cidr_ip.as_deref()
    }
    /// <p>Description of the address block.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for IpRoute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IpRoute");
        formatter.field("cidr_ip", &self.cidr_ip);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`IpRoute`](crate::model::IpRoute)
pub mod ip_route {
    /// A builder for [`IpRoute`](crate::model::IpRoute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cidr_ip: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>IP address block using CIDR format, for example 10.0.0.0/24. This is often the
        /// address block of the DNS server used for your self-managed domain. For a single IP address
        /// use a CIDR address block with /32. For example 10.0.0.0/32.</p>
        pub fn cidr_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.cidr_ip = Some(input.into());
            self
        }
        /// <p>IP address block using CIDR format, for example 10.0.0.0/24. This is often the
        /// address block of the DNS server used for your self-managed domain. For a single IP address
        /// use a CIDR address block with /32. For example 10.0.0.0/32.</p>
        pub fn set_cidr_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cidr_ip = input;
            self
        }
        /// <p>Description of the address block.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Description of the address block.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`IpRoute`](crate::model::IpRoute)
        pub fn build(self) -> crate::model::IpRoute {
            crate::model::IpRoute {
                cidr_ip: self.cidr_ip,
                description: self.description,
            }
        }
    }
}
impl IpRoute {
    /// Creates a new builder-style object to manufacture [`IpRoute`](crate::model::IpRoute)
    pub fn builder() -> crate::model::ip_route::Builder {
        crate::model::ip_route::Builder::default()
    }
}
