// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AcceptSharedDirectoryInput`](crate::input::AcceptSharedDirectoryInput)
pub mod accept_shared_directory_input {
    /// A builder for [`AcceptSharedDirectoryInput`](crate::input::AcceptSharedDirectoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) shared_directory_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Identifier of the shared directory in the directory consumer account. This identifier is
        /// different for each directory owner account. </p>
        pub fn shared_directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.shared_directory_id = Some(input.into());
            self
        }
        /// <p>Identifier of the shared directory in the directory consumer account. This identifier is
        /// different for each directory owner account. </p>
        pub fn set_shared_directory_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.shared_directory_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptSharedDirectoryInput`](crate::input::AcceptSharedDirectoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AcceptSharedDirectoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AcceptSharedDirectoryInput {
                shared_directory_id: self.shared_directory_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AcceptSharedDirectoryInputOperationOutputAlias = crate::operation::AcceptSharedDirectory;
#[doc(hidden)]
pub type AcceptSharedDirectoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AcceptSharedDirectoryInput {
    /// Consumes the builder and constructs an Operation<[`AcceptSharedDirectory`](crate::operation::AcceptSharedDirectory)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AcceptSharedDirectory,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AcceptSharedDirectoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AcceptSharedDirectoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AcceptSharedDirectoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.AcceptSharedDirectory",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_accept_shared_directory(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AcceptSharedDirectory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AcceptSharedDirectory",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AcceptSharedDirectoryInput`](crate::input::AcceptSharedDirectoryInput)
    pub fn builder() -> crate::input::accept_shared_directory_input::Builder {
        crate::input::accept_shared_directory_input::Builder::default()
    }
}

/// See [`AddIpRoutesInput`](crate::input::AddIpRoutesInput)
pub mod add_ip_routes_input {
    /// A builder for [`AddIpRoutesInput`](crate::input::AddIpRoutesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) ip_routes: std::option::Option<std::vec::Vec<crate::model::IpRoute>>,
        pub(crate) update_security_group_for_directory_controllers: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Identifier (ID) of the directory to which to add the address block.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>Identifier (ID) of the directory to which to add the address block.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// Appends an item to `ip_routes`.
        ///
        /// To override the contents of this collection use [`set_ip_routes`](Self::set_ip_routes).
        ///
        /// <p>IP address blocks, using CIDR format, of the traffic to route. This is often the IP
        /// address block of the DNS server used for your self-managed domain.</p>
        pub fn ip_routes(mut self, input: impl Into<crate::model::IpRoute>) -> Self {
            let mut v = self.ip_routes.unwrap_or_default();
            v.push(input.into());
            self.ip_routes = Some(v);
            self
        }
        /// <p>IP address blocks, using CIDR format, of the traffic to route. This is often the IP
        /// address block of the DNS server used for your self-managed domain.</p>
        pub fn set_ip_routes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpRoute>>,
        ) -> Self {
            self.ip_routes = input;
            self
        }
        /// <p>If set to true, updates the inbound and outbound rules of the security group that has
        /// the description: "Amazon Web Services created security group for <i>directory ID</i>
        /// directory controllers." Following are the new rules: </p>
        /// <p>Inbound:</p>
        /// <ul>
        /// <li>
        /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 88, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 123, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 138, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 389, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 464, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 445, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 88, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 135, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 445, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 464, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 636, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 1024-65535, Source:
        /// 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 3268-33269, Source:
        /// 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: DNS (UDP), Protocol: UDP, Range: 53, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: DNS (TCP), Protocol: TCP, Range: 53, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: LDAP, Protocol: TCP, Range: 389, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: All ICMP, Protocol: All, Range: N/A, Source: 0.0.0.0/0</p>
        /// </li>
        /// </ul>
        ///
        /// <p></p>
        /// <p>Outbound:</p>
        /// <ul>
        /// <li>
        /// <p>Type: All traffic, Protocol: All, Range: All, Destination: 0.0.0.0/0</p>
        /// </li>
        /// </ul>
        /// <p>These security rules impact an internal network interface that is not exposed
        /// publicly.</p>
        pub fn update_security_group_for_directory_controllers(mut self, input: bool) -> Self {
            self.update_security_group_for_directory_controllers = Some(input);
            self
        }
        /// <p>If set to true, updates the inbound and outbound rules of the security group that has
        /// the description: "Amazon Web Services created security group for <i>directory ID</i>
        /// directory controllers." Following are the new rules: </p>
        /// <p>Inbound:</p>
        /// <ul>
        /// <li>
        /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 88, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 123, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 138, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 389, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 464, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 445, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 88, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 135, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 445, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 464, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 636, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 1024-65535, Source:
        /// 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 3268-33269, Source:
        /// 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: DNS (UDP), Protocol: UDP, Range: 53, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: DNS (TCP), Protocol: TCP, Range: 53, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: LDAP, Protocol: TCP, Range: 389, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: All ICMP, Protocol: All, Range: N/A, Source: 0.0.0.0/0</p>
        /// </li>
        /// </ul>
        ///
        /// <p></p>
        /// <p>Outbound:</p>
        /// <ul>
        /// <li>
        /// <p>Type: All traffic, Protocol: All, Range: All, Destination: 0.0.0.0/0</p>
        /// </li>
        /// </ul>
        /// <p>These security rules impact an internal network interface that is not exposed
        /// publicly.</p>
        pub fn set_update_security_group_for_directory_controllers(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.update_security_group_for_directory_controllers = input;
            self
        }
        /// Consumes the builder and constructs a [`AddIpRoutesInput`](crate::input::AddIpRoutesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddIpRoutesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddIpRoutesInput {
                directory_id: self.directory_id,
                ip_routes: self.ip_routes,
                update_security_group_for_directory_controllers: self
                    .update_security_group_for_directory_controllers
                    .unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type AddIpRoutesInputOperationOutputAlias = crate::operation::AddIpRoutes;
#[doc(hidden)]
pub type AddIpRoutesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddIpRoutesInput {
    /// Consumes the builder and constructs an Operation<[`AddIpRoutes`](crate::operation::AddIpRoutes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddIpRoutes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddIpRoutesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddIpRoutesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddIpRoutesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.AddIpRoutes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_add_ip_routes(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddIpRoutes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddIpRoutes",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddIpRoutesInput`](crate::input::AddIpRoutesInput)
    pub fn builder() -> crate::input::add_ip_routes_input::Builder {
        crate::input::add_ip_routes_input::Builder::default()
    }
}

/// See [`AddRegionInput`](crate::input::AddRegionInput)
pub mod add_region_input {
    /// A builder for [`AddRegionInput`](crate::input::AddRegionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) region_name: std::option::Option<std::string::String>,
        pub(crate) vpc_settings: std::option::Option<crate::model::DirectoryVpcSettings>,
    }
    impl Builder {
        /// <p>The identifier of the directory to which you want to add Region replication.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory to which you want to add Region replication.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The name of the Region where you want to add domain controllers for replication. For
        /// example, <code>us-east-1</code>.</p>
        pub fn region_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.region_name = Some(input.into());
            self
        }
        /// <p>The name of the Region where you want to add domain controllers for replication. For
        /// example, <code>us-east-1</code>.</p>
        pub fn set_region_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region_name = input;
            self
        }
        /// <p>Contains VPC information for the <a>CreateDirectory</a> or <a>CreateMicrosoftAD</a> operation.</p>
        pub fn vpc_settings(mut self, input: crate::model::DirectoryVpcSettings) -> Self {
            self.vpc_settings = Some(input);
            self
        }
        /// <p>Contains VPC information for the <a>CreateDirectory</a> or <a>CreateMicrosoftAD</a> operation.</p>
        pub fn set_vpc_settings(
            mut self,
            input: std::option::Option<crate::model::DirectoryVpcSettings>,
        ) -> Self {
            self.vpc_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`AddRegionInput`](crate::input::AddRegionInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::AddRegionInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::AddRegionInput {
                directory_id: self.directory_id,
                region_name: self.region_name,
                vpc_settings: self.vpc_settings,
            })
        }
    }
}
#[doc(hidden)]
pub type AddRegionInputOperationOutputAlias = crate::operation::AddRegion;
#[doc(hidden)]
pub type AddRegionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddRegionInput {
    /// Consumes the builder and constructs an Operation<[`AddRegion`](crate::operation::AddRegion)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddRegion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddRegionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddRegionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddRegionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.AddRegion",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_add_region(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::AddRegion::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "AddRegion",
                    "directoryservice",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddRegionInput`](crate::input::AddRegionInput)
    pub fn builder() -> crate::input::add_region_input::Builder {
        crate::input::add_region_input::Builder::default()
    }
}

/// See [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
pub mod add_tags_to_resource_input {
    /// A builder for [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Identifier (ID) for the directory to which to add the tag.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>Identifier (ID) for the directory to which to add the tag.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the directory.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be assigned to the directory.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddTagsToResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddTagsToResourceInput {
                resource_id: self.resource_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type AddTagsToResourceInputOperationOutputAlias = crate::operation::AddTagsToResource;
#[doc(hidden)]
pub type AddTagsToResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddTagsToResourceInput {
    /// Consumes the builder and constructs an Operation<[`AddTagsToResource`](crate::operation::AddTagsToResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddTagsToResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddTagsToResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddTagsToResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddTagsToResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.AddTagsToResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_tags_to_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddTagsToResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddTagsToResource",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
    pub fn builder() -> crate::input::add_tags_to_resource_input::Builder {
        crate::input::add_tags_to_resource_input::Builder::default()
    }
}

/// See [`CancelSchemaExtensionInput`](crate::input::CancelSchemaExtensionInput)
pub mod cancel_schema_extension_input {
    /// A builder for [`CancelSchemaExtensionInput`](crate::input::CancelSchemaExtensionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) schema_extension_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the directory whose schema extension will be canceled.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory whose schema extension will be canceled.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The identifier of the schema extension that will be canceled.</p>
        pub fn schema_extension_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_extension_id = Some(input.into());
            self
        }
        /// <p>The identifier of the schema extension that will be canceled.</p>
        pub fn set_schema_extension_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_extension_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelSchemaExtensionInput`](crate::input::CancelSchemaExtensionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelSchemaExtensionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelSchemaExtensionInput {
                directory_id: self.directory_id,
                schema_extension_id: self.schema_extension_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelSchemaExtensionInputOperationOutputAlias = crate::operation::CancelSchemaExtension;
#[doc(hidden)]
pub type CancelSchemaExtensionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CancelSchemaExtensionInput {
    /// Consumes the builder and constructs an Operation<[`CancelSchemaExtension`](crate::operation::CancelSchemaExtension)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelSchemaExtension,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelSchemaExtensionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelSchemaExtensionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelSchemaExtensionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.CancelSchemaExtension",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_cancel_schema_extension(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelSchemaExtension::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelSchemaExtension",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelSchemaExtensionInput`](crate::input::CancelSchemaExtensionInput)
    pub fn builder() -> crate::input::cancel_schema_extension_input::Builder {
        crate::input::cancel_schema_extension_input::Builder::default()
    }
}

/// See [`ConnectDirectoryInput`](crate::input::ConnectDirectoryInput)
pub mod connect_directory_input {
    /// A builder for [`ConnectDirectoryInput`](crate::input::ConnectDirectoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) short_name: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) size: std::option::Option<crate::model::DirectorySize>,
        pub(crate) connect_settings: std::option::Option<crate::model::DirectoryConnectSettings>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The fully qualified name of your self-managed directory, such as
        /// <code>corp.example.com</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The fully qualified name of your self-managed directory, such as
        /// <code>corp.example.com</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The NetBIOS name of your self-managed directory, such as <code>CORP</code>.</p>
        pub fn short_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.short_name = Some(input.into());
            self
        }
        /// <p>The NetBIOS name of your self-managed directory, such as <code>CORP</code>.</p>
        pub fn set_short_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.short_name = input;
            self
        }
        /// <p>The password for your self-managed user account.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>The password for your self-managed user account.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p>A description for the directory.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the directory.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The size of the directory.</p>
        pub fn size(mut self, input: crate::model::DirectorySize) -> Self {
            self.size = Some(input);
            self
        }
        /// <p>The size of the directory.</p>
        pub fn set_size(mut self, input: std::option::Option<crate::model::DirectorySize>) -> Self {
            self.size = input;
            self
        }
        /// <p>A <a>DirectoryConnectSettings</a> object that contains additional information
        /// for the operation.</p>
        pub fn connect_settings(mut self, input: crate::model::DirectoryConnectSettings) -> Self {
            self.connect_settings = Some(input);
            self
        }
        /// <p>A <a>DirectoryConnectSettings</a> object that contains additional information
        /// for the operation.</p>
        pub fn set_connect_settings(
            mut self,
            input: std::option::Option<crate::model::DirectoryConnectSettings>,
        ) -> Self {
            self.connect_settings = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to AD Connector.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be assigned to AD Connector.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectDirectoryInput`](crate::input::ConnectDirectoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ConnectDirectoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ConnectDirectoryInput {
                name: self.name,
                short_name: self.short_name,
                password: self.password,
                description: self.description,
                size: self.size,
                connect_settings: self.connect_settings,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type ConnectDirectoryInputOperationOutputAlias = crate::operation::ConnectDirectory;
#[doc(hidden)]
pub type ConnectDirectoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ConnectDirectoryInput {
    /// Consumes the builder and constructs an Operation<[`ConnectDirectory`](crate::operation::ConnectDirectory)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ConnectDirectory,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ConnectDirectoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ConnectDirectoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ConnectDirectoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.ConnectDirectory",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_connect_directory(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ConnectDirectory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ConnectDirectory",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ConnectDirectoryInput`](crate::input::ConnectDirectoryInput)
    pub fn builder() -> crate::input::connect_directory_input::Builder {
        crate::input::connect_directory_input::Builder::default()
    }
}

/// See [`CreateAliasInput`](crate::input::CreateAliasInput)
pub mod create_alias_input {
    /// A builder for [`CreateAliasInput`](crate::input::CreateAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) alias: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the directory for which to create the alias.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory for which to create the alias.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The requested alias.</p>
        /// <p>The alias must be unique amongst all aliases in Amazon Web Services. This operation throws an
        /// <code>EntityAlreadyExistsException</code> error if the alias already exists.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// <p>The requested alias.</p>
        /// <p>The alias must be unique amongst all aliases in Amazon Web Services. This operation throws an
        /// <code>EntityAlreadyExistsException</code> error if the alias already exists.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAliasInput`](crate::input::CreateAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAliasInput {
                directory_id: self.directory_id,
                alias: self.alias,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAliasInputOperationOutputAlias = crate::operation::CreateAlias;
#[doc(hidden)]
pub type CreateAliasInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateAliasInput {
    /// Consumes the builder and constructs an Operation<[`CreateAlias`](crate::operation::CreateAlias)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAlias,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAliasInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAliasInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAliasInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.CreateAlias",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_alias(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAlias",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAliasInput`](crate::input::CreateAliasInput)
    pub fn builder() -> crate::input::create_alias_input::Builder {
        crate::input::create_alias_input::Builder::default()
    }
}

/// See [`CreateComputerInput`](crate::input::CreateComputerInput)
pub mod create_computer_input {
    /// A builder for [`CreateComputerInput`](crate::input::CreateComputerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) computer_name: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) organizational_unit_distinguished_name: std::option::Option<std::string::String>,
        pub(crate) computer_attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
    }
    impl Builder {
        /// <p>The identifier of the directory in which to create the computer account.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory in which to create the computer account.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The name of the computer account.</p>
        pub fn computer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.computer_name = Some(input.into());
            self
        }
        /// <p>The name of the computer account.</p>
        pub fn set_computer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.computer_name = input;
            self
        }
        /// <p>A one-time password that is used to join the computer to the directory. You should generate a random, strong password to use for this parameter.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>A one-time password that is used to join the computer to the directory. You should generate a random, strong password to use for this parameter.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p>The fully-qualified distinguished name of the organizational unit to place the computer account in.</p>
        pub fn organizational_unit_distinguished_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.organizational_unit_distinguished_name = Some(input.into());
            self
        }
        /// <p>The fully-qualified distinguished name of the organizational unit to place the computer account in.</p>
        pub fn set_organizational_unit_distinguished_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organizational_unit_distinguished_name = input;
            self
        }
        /// Appends an item to `computer_attributes`.
        ///
        /// To override the contents of this collection use [`set_computer_attributes`](Self::set_computer_attributes).
        ///
        /// <p>An array of <a>Attribute</a> objects that contain any LDAP attributes to apply to the
        /// computer account.</p>
        pub fn computer_attributes(mut self, input: impl Into<crate::model::Attribute>) -> Self {
            let mut v = self.computer_attributes.unwrap_or_default();
            v.push(input.into());
            self.computer_attributes = Some(v);
            self
        }
        /// <p>An array of <a>Attribute</a> objects that contain any LDAP attributes to apply to the
        /// computer account.</p>
        pub fn set_computer_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.computer_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateComputerInput`](crate::input::CreateComputerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateComputerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateComputerInput {
                directory_id: self.directory_id,
                computer_name: self.computer_name,
                password: self.password,
                organizational_unit_distinguished_name: self.organizational_unit_distinguished_name,
                computer_attributes: self.computer_attributes,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateComputerInputOperationOutputAlias = crate::operation::CreateComputer;
#[doc(hidden)]
pub type CreateComputerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateComputerInput {
    /// Consumes the builder and constructs an Operation<[`CreateComputer`](crate::operation::CreateComputer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateComputer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateComputerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateComputerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateComputerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.CreateComputer",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_computer(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateComputer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateComputer",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateComputerInput`](crate::input::CreateComputerInput)
    pub fn builder() -> crate::input::create_computer_input::Builder {
        crate::input::create_computer_input::Builder::default()
    }
}

/// See [`CreateConditionalForwarderInput`](crate::input::CreateConditionalForwarderInput)
pub mod create_conditional_forwarder_input {
    /// A builder for [`CreateConditionalForwarderInput`](crate::input::CreateConditionalForwarderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) remote_domain_name: std::option::Option<std::string::String>,
        pub(crate) dns_ip_addrs: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The directory ID of the Amazon Web Services directory for which you are creating the conditional
        /// forwarder.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The directory ID of the Amazon Web Services directory for which you are creating the conditional
        /// forwarder.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The fully qualified domain name (FQDN) of the remote domain with which you will set up
        /// a trust relationship.</p>
        pub fn remote_domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.remote_domain_name = Some(input.into());
            self
        }
        /// <p>The fully qualified domain name (FQDN) of the remote domain with which you will set up
        /// a trust relationship.</p>
        pub fn set_remote_domain_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.remote_domain_name = input;
            self
        }
        /// Appends an item to `dns_ip_addrs`.
        ///
        /// To override the contents of this collection use [`set_dns_ip_addrs`](Self::set_dns_ip_addrs).
        ///
        /// <p>The IP addresses of the remote DNS server associated with RemoteDomainName.</p>
        pub fn dns_ip_addrs(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.dns_ip_addrs.unwrap_or_default();
            v.push(input.into());
            self.dns_ip_addrs = Some(v);
            self
        }
        /// <p>The IP addresses of the remote DNS server associated with RemoteDomainName.</p>
        pub fn set_dns_ip_addrs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.dns_ip_addrs = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConditionalForwarderInput`](crate::input::CreateConditionalForwarderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateConditionalForwarderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateConditionalForwarderInput {
                directory_id: self.directory_id,
                remote_domain_name: self.remote_domain_name,
                dns_ip_addrs: self.dns_ip_addrs,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateConditionalForwarderInputOperationOutputAlias =
    crate::operation::CreateConditionalForwarder;
#[doc(hidden)]
pub type CreateConditionalForwarderInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateConditionalForwarderInput {
    /// Consumes the builder and constructs an Operation<[`CreateConditionalForwarder`](crate::operation::CreateConditionalForwarder)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateConditionalForwarder,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateConditionalForwarderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateConditionalForwarderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateConditionalForwarderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.CreateConditionalForwarder",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_conditional_forwarder(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateConditionalForwarder::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateConditionalForwarder",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateConditionalForwarderInput`](crate::input::CreateConditionalForwarderInput)
    pub fn builder() -> crate::input::create_conditional_forwarder_input::Builder {
        crate::input::create_conditional_forwarder_input::Builder::default()
    }
}

/// See [`CreateDirectoryInput`](crate::input::CreateDirectoryInput)
pub mod create_directory_input {
    /// A builder for [`CreateDirectoryInput`](crate::input::CreateDirectoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) short_name: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) size: std::option::Option<crate::model::DirectorySize>,
        pub(crate) vpc_settings: std::option::Option<crate::model::DirectoryVpcSettings>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The fully qualified name for the directory, such as <code>corp.example.com</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The fully qualified name for the directory, such as <code>corp.example.com</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The NetBIOS name of the directory, such as <code>CORP</code>.</p>
        pub fn short_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.short_name = Some(input.into());
            self
        }
        /// <p>The NetBIOS name of the directory, such as <code>CORP</code>.</p>
        pub fn set_short_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.short_name = input;
            self
        }
        /// <p>The password for the directory administrator. The directory creation process creates a
        /// directory administrator account with the user name <code>Administrator</code> and this
        /// password.</p>
        /// <p>If you need to change the password for the administrator account, you can use the <a>ResetUserPassword</a> API call.</p>
        /// <p>The regex pattern for this string is made up of the following conditions:</p>
        /// <ul>
        /// <li>
        /// <p>Length (?=^.{8,64}$) – Must be between 8 and 64 characters</p>
        /// </li>
        /// </ul>
        /// <p>AND any 3 of the following password complexity rules required by Active Directory:</p>
        /// <ul>
        /// <li>
        /// <p>Numbers and upper case and lowercase (?=.*\d)(?=.*[A-Z])(?=.*[a-z])</p>
        /// </li>
        /// <li>
        /// <p>Numbers and special characters and lower case
        /// (?=.*\d)(?=.*[^A-Za-z0-9\s])(?=.*[a-z])</p>
        /// </li>
        /// <li>
        /// <p>Special characters and upper case and lower case
        /// (?=.*[^A-Za-z0-9\s])(?=.*[A-Z])(?=.*[a-z])</p>
        /// </li>
        /// <li>
        /// <p>Numbers and upper case and special characters
        /// (?=.*\d)(?=.*[A-Z])(?=.*[^A-Za-z0-9\s])</p>
        /// </li>
        /// </ul>
        /// <p>For additional information about how Active Directory passwords are enforced, see <a href="https://docs.microsoft.com/en-us/windows/security/threat-protection/security-policy-settings/password-must-meet-complexity-requirements">Password must meet complexity requirements</a> on the Microsoft website.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>The password for the directory administrator. The directory creation process creates a
        /// directory administrator account with the user name <code>Administrator</code> and this
        /// password.</p>
        /// <p>If you need to change the password for the administrator account, you can use the <a>ResetUserPassword</a> API call.</p>
        /// <p>The regex pattern for this string is made up of the following conditions:</p>
        /// <ul>
        /// <li>
        /// <p>Length (?=^.{8,64}$) – Must be between 8 and 64 characters</p>
        /// </li>
        /// </ul>
        /// <p>AND any 3 of the following password complexity rules required by Active Directory:</p>
        /// <ul>
        /// <li>
        /// <p>Numbers and upper case and lowercase (?=.*\d)(?=.*[A-Z])(?=.*[a-z])</p>
        /// </li>
        /// <li>
        /// <p>Numbers and special characters and lower case
        /// (?=.*\d)(?=.*[^A-Za-z0-9\s])(?=.*[a-z])</p>
        /// </li>
        /// <li>
        /// <p>Special characters and upper case and lower case
        /// (?=.*[^A-Za-z0-9\s])(?=.*[A-Z])(?=.*[a-z])</p>
        /// </li>
        /// <li>
        /// <p>Numbers and upper case and special characters
        /// (?=.*\d)(?=.*[A-Z])(?=.*[^A-Za-z0-9\s])</p>
        /// </li>
        /// </ul>
        /// <p>For additional information about how Active Directory passwords are enforced, see <a href="https://docs.microsoft.com/en-us/windows/security/threat-protection/security-policy-settings/password-must-meet-complexity-requirements">Password must meet complexity requirements</a> on the Microsoft website.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p>A description for the directory.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the directory.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The size of the directory.</p>
        pub fn size(mut self, input: crate::model::DirectorySize) -> Self {
            self.size = Some(input);
            self
        }
        /// <p>The size of the directory.</p>
        pub fn set_size(mut self, input: std::option::Option<crate::model::DirectorySize>) -> Self {
            self.size = input;
            self
        }
        /// <p>A <a>DirectoryVpcSettings</a> object that contains additional information for
        /// the operation.</p>
        pub fn vpc_settings(mut self, input: crate::model::DirectoryVpcSettings) -> Self {
            self.vpc_settings = Some(input);
            self
        }
        /// <p>A <a>DirectoryVpcSettings</a> object that contains additional information for
        /// the operation.</p>
        pub fn set_vpc_settings(
            mut self,
            input: std::option::Option<crate::model::DirectoryVpcSettings>,
        ) -> Self {
            self.vpc_settings = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the Simple AD directory.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be assigned to the Simple AD directory.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDirectoryInput`](crate::input::CreateDirectoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDirectoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDirectoryInput {
                name: self.name,
                short_name: self.short_name,
                password: self.password,
                description: self.description,
                size: self.size,
                vpc_settings: self.vpc_settings,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDirectoryInputOperationOutputAlias = crate::operation::CreateDirectory;
#[doc(hidden)]
pub type CreateDirectoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDirectoryInput {
    /// Consumes the builder and constructs an Operation<[`CreateDirectory`](crate::operation::CreateDirectory)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDirectory,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDirectoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDirectoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDirectoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.CreateDirectory",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_directory(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDirectory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDirectory",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDirectoryInput`](crate::input::CreateDirectoryInput)
    pub fn builder() -> crate::input::create_directory_input::Builder {
        crate::input::create_directory_input::Builder::default()
    }
}

/// See [`CreateLogSubscriptionInput`](crate::input::CreateLogSubscriptionInput)
pub mod create_log_subscription_input {
    /// A builder for [`CreateLogSubscriptionInput`](crate::input::CreateLogSubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) log_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Identifier of the directory to which you want to subscribe and receive real-time logs to
        /// your specified CloudWatch log group.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>Identifier of the directory to which you want to subscribe and receive real-time logs to
        /// your specified CloudWatch log group.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The name of the CloudWatch log group where the real-time domain controller logs are
        /// forwarded.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group_name = Some(input.into());
            self
        }
        /// <p>The name of the CloudWatch log group where the real-time domain controller logs are
        /// forwarded.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLogSubscriptionInput`](crate::input::CreateLogSubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLogSubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateLogSubscriptionInput {
                directory_id: self.directory_id,
                log_group_name: self.log_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLogSubscriptionInputOperationOutputAlias = crate::operation::CreateLogSubscription;
#[doc(hidden)]
pub type CreateLogSubscriptionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateLogSubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`CreateLogSubscription`](crate::operation::CreateLogSubscription)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLogSubscription,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateLogSubscriptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateLogSubscriptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateLogSubscriptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.CreateLogSubscription",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_log_subscription(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLogSubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLogSubscription",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateLogSubscriptionInput`](crate::input::CreateLogSubscriptionInput)
    pub fn builder() -> crate::input::create_log_subscription_input::Builder {
        crate::input::create_log_subscription_input::Builder::default()
    }
}

/// See [`CreateMicrosoftAdInput`](crate::input::CreateMicrosoftAdInput)
pub mod create_microsoft_ad_input {
    /// A builder for [`CreateMicrosoftAdInput`](crate::input::CreateMicrosoftAdInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) short_name: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) vpc_settings: std::option::Option<crate::model::DirectoryVpcSettings>,
        pub(crate) edition: std::option::Option<crate::model::DirectoryEdition>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The fully qualified domain name for the Managed Microsoft AD directory, such as
        /// <code>corp.example.com</code>. This name will resolve inside your VPC only. It does not need
        /// to be publicly resolvable.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The fully qualified domain name for the Managed Microsoft AD directory, such as
        /// <code>corp.example.com</code>. This name will resolve inside your VPC only. It does not need
        /// to be publicly resolvable.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The NetBIOS name for your domain, such as <code>CORP</code>. If you don't specify a
        /// NetBIOS name, it will default to the first part of your directory DNS. For example,
        /// <code>CORP</code> for the directory DNS <code>corp.example.com</code>. </p>
        pub fn short_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.short_name = Some(input.into());
            self
        }
        /// <p>The NetBIOS name for your domain, such as <code>CORP</code>. If you don't specify a
        /// NetBIOS name, it will default to the first part of your directory DNS. For example,
        /// <code>CORP</code> for the directory DNS <code>corp.example.com</code>. </p>
        pub fn set_short_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.short_name = input;
            self
        }
        /// <p>The password for the default administrative user named <code>Admin</code>.</p>
        /// <p>If you need to change the password for the administrator account, you can use the <a>ResetUserPassword</a> API call.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>The password for the default administrative user named <code>Admin</code>.</p>
        /// <p>If you need to change the password for the administrator account, you can use the <a>ResetUserPassword</a> API call.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p>A description for the directory. This label will appear on the Amazon Web Services console
        /// <code>Directory Details</code> page after the directory is created.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the directory. This label will appear on the Amazon Web Services console
        /// <code>Directory Details</code> page after the directory is created.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Contains VPC information for the <a>CreateDirectory</a> or <a>CreateMicrosoftAD</a> operation.</p>
        pub fn vpc_settings(mut self, input: crate::model::DirectoryVpcSettings) -> Self {
            self.vpc_settings = Some(input);
            self
        }
        /// <p>Contains VPC information for the <a>CreateDirectory</a> or <a>CreateMicrosoftAD</a> operation.</p>
        pub fn set_vpc_settings(
            mut self,
            input: std::option::Option<crate::model::DirectoryVpcSettings>,
        ) -> Self {
            self.vpc_settings = input;
            self
        }
        /// <p>Managed Microsoft AD is available in two editions: <code>Standard</code> and
        /// <code>Enterprise</code>. <code>Enterprise</code> is the default.</p>
        pub fn edition(mut self, input: crate::model::DirectoryEdition) -> Self {
            self.edition = Some(input);
            self
        }
        /// <p>Managed Microsoft AD is available in two editions: <code>Standard</code> and
        /// <code>Enterprise</code>. <code>Enterprise</code> is the default.</p>
        pub fn set_edition(
            mut self,
            input: std::option::Option<crate::model::DirectoryEdition>,
        ) -> Self {
            self.edition = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the Managed Microsoft AD directory.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be assigned to the Managed Microsoft AD directory.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMicrosoftAdInput`](crate::input::CreateMicrosoftAdInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateMicrosoftAdInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateMicrosoftAdInput {
                name: self.name,
                short_name: self.short_name,
                password: self.password,
                description: self.description,
                vpc_settings: self.vpc_settings,
                edition: self.edition,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateMicrosoftAdInputOperationOutputAlias = crate::operation::CreateMicrosoftAD;
#[doc(hidden)]
pub type CreateMicrosoftAdInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateMicrosoftAdInput {
    /// Consumes the builder and constructs an Operation<[`CreateMicrosoftAD`](crate::operation::CreateMicrosoftAD)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateMicrosoftAD,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateMicrosoftAdInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateMicrosoftAdInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateMicrosoftAdInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.CreateMicrosoftAD",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_microsoft_ad(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateMicrosoftAD::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateMicrosoftAD",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateMicrosoftAdInput`](crate::input::CreateMicrosoftAdInput)
    pub fn builder() -> crate::input::create_microsoft_ad_input::Builder {
        crate::input::create_microsoft_ad_input::Builder::default()
    }
}

/// See [`CreateSnapshotInput`](crate::input::CreateSnapshotInput)
pub mod create_snapshot_input {
    /// A builder for [`CreateSnapshotInput`](crate::input::CreateSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the directory of which to take a snapshot.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory of which to take a snapshot.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The descriptive name to apply to the snapshot.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The descriptive name to apply to the snapshot.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSnapshotInput`](crate::input::CreateSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSnapshotInput {
                directory_id: self.directory_id,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSnapshotInputOperationOutputAlias = crate::operation::CreateSnapshot;
#[doc(hidden)]
pub type CreateSnapshotInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`CreateSnapshot`](crate::operation::CreateSnapshot)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSnapshot,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSnapshotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSnapshotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSnapshotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.CreateSnapshot",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_snapshot(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSnapshot",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSnapshotInput`](crate::input::CreateSnapshotInput)
    pub fn builder() -> crate::input::create_snapshot_input::Builder {
        crate::input::create_snapshot_input::Builder::default()
    }
}

/// See [`CreateTrustInput`](crate::input::CreateTrustInput)
pub mod create_trust_input {
    /// A builder for [`CreateTrustInput`](crate::input::CreateTrustInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) remote_domain_name: std::option::Option<std::string::String>,
        pub(crate) trust_password: std::option::Option<std::string::String>,
        pub(crate) trust_direction: std::option::Option<crate::model::TrustDirection>,
        pub(crate) trust_type: std::option::Option<crate::model::TrustType>,
        pub(crate) conditional_forwarder_ip_addrs:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) selective_auth: std::option::Option<crate::model::SelectiveAuth>,
    }
    impl Builder {
        /// <p>The Directory ID of the Managed Microsoft AD directory for which to establish the trust
        /// relationship.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The Directory ID of the Managed Microsoft AD directory for which to establish the trust
        /// relationship.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The Fully Qualified Domain Name (FQDN) of the external domain for which to create the
        /// trust relationship.</p>
        pub fn remote_domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.remote_domain_name = Some(input.into());
            self
        }
        /// <p>The Fully Qualified Domain Name (FQDN) of the external domain for which to create the
        /// trust relationship.</p>
        pub fn set_remote_domain_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.remote_domain_name = input;
            self
        }
        /// <p>The trust password. The must be the same password that was used when creating the trust
        /// relationship on the external domain.</p>
        pub fn trust_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.trust_password = Some(input.into());
            self
        }
        /// <p>The trust password. The must be the same password that was used when creating the trust
        /// relationship on the external domain.</p>
        pub fn set_trust_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.trust_password = input;
            self
        }
        /// <p>The direction of the trust relationship.</p>
        pub fn trust_direction(mut self, input: crate::model::TrustDirection) -> Self {
            self.trust_direction = Some(input);
            self
        }
        /// <p>The direction of the trust relationship.</p>
        pub fn set_trust_direction(
            mut self,
            input: std::option::Option<crate::model::TrustDirection>,
        ) -> Self {
            self.trust_direction = input;
            self
        }
        /// <p>The trust relationship type. <code>Forest</code> is the default.</p>
        pub fn trust_type(mut self, input: crate::model::TrustType) -> Self {
            self.trust_type = Some(input);
            self
        }
        /// <p>The trust relationship type. <code>Forest</code> is the default.</p>
        pub fn set_trust_type(
            mut self,
            input: std::option::Option<crate::model::TrustType>,
        ) -> Self {
            self.trust_type = input;
            self
        }
        /// Appends an item to `conditional_forwarder_ip_addrs`.
        ///
        /// To override the contents of this collection use [`set_conditional_forwarder_ip_addrs`](Self::set_conditional_forwarder_ip_addrs).
        ///
        /// <p>The IP addresses of the remote DNS server associated with RemoteDomainName.</p>
        pub fn conditional_forwarder_ip_addrs(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.conditional_forwarder_ip_addrs.unwrap_or_default();
            v.push(input.into());
            self.conditional_forwarder_ip_addrs = Some(v);
            self
        }
        /// <p>The IP addresses of the remote DNS server associated with RemoteDomainName.</p>
        pub fn set_conditional_forwarder_ip_addrs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.conditional_forwarder_ip_addrs = input;
            self
        }
        /// <p>Optional parameter to enable selective authentication for the trust.</p>
        pub fn selective_auth(mut self, input: crate::model::SelectiveAuth) -> Self {
            self.selective_auth = Some(input);
            self
        }
        /// <p>Optional parameter to enable selective authentication for the trust.</p>
        pub fn set_selective_auth(
            mut self,
            input: std::option::Option<crate::model::SelectiveAuth>,
        ) -> Self {
            self.selective_auth = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTrustInput`](crate::input::CreateTrustInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTrustInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTrustInput {
                directory_id: self.directory_id,
                remote_domain_name: self.remote_domain_name,
                trust_password: self.trust_password,
                trust_direction: self.trust_direction,
                trust_type: self.trust_type,
                conditional_forwarder_ip_addrs: self.conditional_forwarder_ip_addrs,
                selective_auth: self.selective_auth,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTrustInputOperationOutputAlias = crate::operation::CreateTrust;
#[doc(hidden)]
pub type CreateTrustInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateTrustInput {
    /// Consumes the builder and constructs an Operation<[`CreateTrust`](crate::operation::CreateTrust)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTrust,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateTrustInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateTrustInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateTrustInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.CreateTrust",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_trust(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTrust::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTrust",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateTrustInput`](crate::input::CreateTrustInput)
    pub fn builder() -> crate::input::create_trust_input::Builder {
        crate::input::create_trust_input::Builder::default()
    }
}

/// See [`DeleteConditionalForwarderInput`](crate::input::DeleteConditionalForwarderInput)
pub mod delete_conditional_forwarder_input {
    /// A builder for [`DeleteConditionalForwarderInput`](crate::input::DeleteConditionalForwarderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) remote_domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The directory ID for which you are deleting the conditional forwarder.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The directory ID for which you are deleting the conditional forwarder.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The fully qualified domain name (FQDN) of the remote domain with which you are deleting
        /// the conditional forwarder.</p>
        pub fn remote_domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.remote_domain_name = Some(input.into());
            self
        }
        /// <p>The fully qualified domain name (FQDN) of the remote domain with which you are deleting
        /// the conditional forwarder.</p>
        pub fn set_remote_domain_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.remote_domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConditionalForwarderInput`](crate::input::DeleteConditionalForwarderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteConditionalForwarderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteConditionalForwarderInput {
                directory_id: self.directory_id,
                remote_domain_name: self.remote_domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteConditionalForwarderInputOperationOutputAlias =
    crate::operation::DeleteConditionalForwarder;
#[doc(hidden)]
pub type DeleteConditionalForwarderInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteConditionalForwarderInput {
    /// Consumes the builder and constructs an Operation<[`DeleteConditionalForwarder`](crate::operation::DeleteConditionalForwarder)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteConditionalForwarder,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteConditionalForwarderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteConditionalForwarderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteConditionalForwarderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.DeleteConditionalForwarder",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_conditional_forwarder(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteConditionalForwarder::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteConditionalForwarder",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteConditionalForwarderInput`](crate::input::DeleteConditionalForwarderInput)
    pub fn builder() -> crate::input::delete_conditional_forwarder_input::Builder {
        crate::input::delete_conditional_forwarder_input::Builder::default()
    }
}

/// See [`DeleteDirectoryInput`](crate::input::DeleteDirectoryInput)
pub mod delete_directory_input {
    /// A builder for [`DeleteDirectoryInput`](crate::input::DeleteDirectoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the directory to delete.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory to delete.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDirectoryInput`](crate::input::DeleteDirectoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDirectoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDirectoryInput {
                directory_id: self.directory_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDirectoryInputOperationOutputAlias = crate::operation::DeleteDirectory;
#[doc(hidden)]
pub type DeleteDirectoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDirectoryInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDirectory`](crate::operation::DeleteDirectory)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDirectory,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDirectoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDirectoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDirectoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.DeleteDirectory",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_directory(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDirectory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDirectory",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDirectoryInput`](crate::input::DeleteDirectoryInput)
    pub fn builder() -> crate::input::delete_directory_input::Builder {
        crate::input::delete_directory_input::Builder::default()
    }
}

/// See [`DeleteLogSubscriptionInput`](crate::input::DeleteLogSubscriptionInput)
pub mod delete_log_subscription_input {
    /// A builder for [`DeleteLogSubscriptionInput`](crate::input::DeleteLogSubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Identifier of the directory whose log subscription you want to delete.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>Identifier of the directory whose log subscription you want to delete.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLogSubscriptionInput`](crate::input::DeleteLogSubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteLogSubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteLogSubscriptionInput {
                directory_id: self.directory_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteLogSubscriptionInputOperationOutputAlias = crate::operation::DeleteLogSubscription;
#[doc(hidden)]
pub type DeleteLogSubscriptionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteLogSubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteLogSubscription`](crate::operation::DeleteLogSubscription)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteLogSubscription,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteLogSubscriptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteLogSubscriptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteLogSubscriptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.DeleteLogSubscription",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_log_subscription(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteLogSubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteLogSubscription",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteLogSubscriptionInput`](crate::input::DeleteLogSubscriptionInput)
    pub fn builder() -> crate::input::delete_log_subscription_input::Builder {
        crate::input::delete_log_subscription_input::Builder::default()
    }
}

/// See [`DeleteSnapshotInput`](crate::input::DeleteSnapshotInput)
pub mod delete_snapshot_input {
    /// A builder for [`DeleteSnapshotInput`](crate::input::DeleteSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the directory snapshot to be deleted.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory snapshot to be deleted.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSnapshotInput`](crate::input::DeleteSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSnapshotInput {
                snapshot_id: self.snapshot_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSnapshotInputOperationOutputAlias = crate::operation::DeleteSnapshot;
#[doc(hidden)]
pub type DeleteSnapshotInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSnapshot`](crate::operation::DeleteSnapshot)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSnapshot,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSnapshotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSnapshotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSnapshotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.DeleteSnapshot",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_snapshot(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSnapshot",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSnapshotInput`](crate::input::DeleteSnapshotInput)
    pub fn builder() -> crate::input::delete_snapshot_input::Builder {
        crate::input::delete_snapshot_input::Builder::default()
    }
}

/// See [`DeleteTrustInput`](crate::input::DeleteTrustInput)
pub mod delete_trust_input {
    /// A builder for [`DeleteTrustInput`](crate::input::DeleteTrustInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trust_id: std::option::Option<std::string::String>,
        pub(crate) delete_associated_conditional_forwarder: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Trust ID of the trust relationship to be deleted.</p>
        pub fn trust_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.trust_id = Some(input.into());
            self
        }
        /// <p>The Trust ID of the trust relationship to be deleted.</p>
        pub fn set_trust_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trust_id = input;
            self
        }
        /// <p>Delete a conditional forwarder as part of a DeleteTrustRequest.</p>
        pub fn delete_associated_conditional_forwarder(mut self, input: bool) -> Self {
            self.delete_associated_conditional_forwarder = Some(input);
            self
        }
        /// <p>Delete a conditional forwarder as part of a DeleteTrustRequest.</p>
        pub fn set_delete_associated_conditional_forwarder(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.delete_associated_conditional_forwarder = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTrustInput`](crate::input::DeleteTrustInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTrustInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTrustInput {
                trust_id: self.trust_id,
                delete_associated_conditional_forwarder: self
                    .delete_associated_conditional_forwarder
                    .unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTrustInputOperationOutputAlias = crate::operation::DeleteTrust;
#[doc(hidden)]
pub type DeleteTrustInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteTrustInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTrust`](crate::operation::DeleteTrust)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTrust,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteTrustInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteTrustInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteTrustInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.DeleteTrust",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_trust(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTrust::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTrust",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteTrustInput`](crate::input::DeleteTrustInput)
    pub fn builder() -> crate::input::delete_trust_input::Builder {
        crate::input::delete_trust_input::Builder::default()
    }
}

/// See [`DeregisterCertificateInput`](crate::input::DeregisterCertificateInput)
pub mod deregister_certificate_input {
    /// A builder for [`DeregisterCertificateInput`](crate::input::DeregisterCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) certificate_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the directory.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The identifier of the certificate.</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_id = Some(input.into());
            self
        }
        /// <p>The identifier of the certificate.</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterCertificateInput`](crate::input::DeregisterCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeregisterCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeregisterCertificateInput {
                directory_id: self.directory_id,
                certificate_id: self.certificate_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeregisterCertificateInputOperationOutputAlias = crate::operation::DeregisterCertificate;
#[doc(hidden)]
pub type DeregisterCertificateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeregisterCertificateInput {
    /// Consumes the builder and constructs an Operation<[`DeregisterCertificate`](crate::operation::DeregisterCertificate)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeregisterCertificate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeregisterCertificateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeregisterCertificateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeregisterCertificateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.DeregisterCertificate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deregister_certificate(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeregisterCertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeregisterCertificate",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeregisterCertificateInput`](crate::input::DeregisterCertificateInput)
    pub fn builder() -> crate::input::deregister_certificate_input::Builder {
        crate::input::deregister_certificate_input::Builder::default()
    }
}

/// See [`DeregisterEventTopicInput`](crate::input::DeregisterEventTopicInput)
pub mod deregister_event_topic_input {
    /// A builder for [`DeregisterEventTopicInput`](crate::input::DeregisterEventTopicInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) topic_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Directory ID to remove as a publisher. This directory will no longer send messages
        /// to the specified Amazon SNS topic.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The Directory ID to remove as a publisher. This directory will no longer send messages
        /// to the specified Amazon SNS topic.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The name of the Amazon SNS topic from which to remove the directory as a
        /// publisher.</p>
        pub fn topic_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon SNS topic from which to remove the directory as a
        /// publisher.</p>
        pub fn set_topic_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterEventTopicInput`](crate::input::DeregisterEventTopicInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeregisterEventTopicInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeregisterEventTopicInput {
                directory_id: self.directory_id,
                topic_name: self.topic_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeregisterEventTopicInputOperationOutputAlias = crate::operation::DeregisterEventTopic;
#[doc(hidden)]
pub type DeregisterEventTopicInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeregisterEventTopicInput {
    /// Consumes the builder and constructs an Operation<[`DeregisterEventTopic`](crate::operation::DeregisterEventTopic)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeregisterEventTopic,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeregisterEventTopicInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeregisterEventTopicInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeregisterEventTopicInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.DeregisterEventTopic",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deregister_event_topic(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeregisterEventTopic::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeregisterEventTopic",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeregisterEventTopicInput`](crate::input::DeregisterEventTopicInput)
    pub fn builder() -> crate::input::deregister_event_topic_input::Builder {
        crate::input::deregister_event_topic_input::Builder::default()
    }
}

/// See [`DescribeCertificateInput`](crate::input::DescribeCertificateInput)
pub mod describe_certificate_input {
    /// A builder for [`DescribeCertificateInput`](crate::input::DescribeCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) certificate_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the directory.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The identifier of the certificate.</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_id = Some(input.into());
            self
        }
        /// <p>The identifier of the certificate.</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCertificateInput`](crate::input::DescribeCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCertificateInput {
                directory_id: self.directory_id,
                certificate_id: self.certificate_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCertificateInputOperationOutputAlias = crate::operation::DescribeCertificate;
#[doc(hidden)]
pub type DescribeCertificateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeCertificateInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCertificate`](crate::operation::DescribeCertificate)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCertificate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCertificateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCertificateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCertificateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.DescribeCertificate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_certificate(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCertificate",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCertificateInput`](crate::input::DescribeCertificateInput)
    pub fn builder() -> crate::input::describe_certificate_input::Builder {
        crate::input::describe_certificate_input::Builder::default()
    }
}

/// See [`DescribeClientAuthenticationSettingsInput`](crate::input::DescribeClientAuthenticationSettingsInput)
pub mod describe_client_authentication_settings_input {
    /// A builder for [`DescribeClientAuthenticationSettingsInput`](crate::input::DescribeClientAuthenticationSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ClientAuthenticationType>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the directory for which to retrieve information.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory for which to retrieve information.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The type of client authentication for which to retrieve information. If no type is specified, a list of all client authentication types that are supported for the specified directory is retrieved.</p>
        pub fn r#type(mut self, input: crate::model::ClientAuthenticationType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of client authentication for which to retrieve information. If no type is specified, a list of all client authentication types that are supported for the specified directory is retrieved.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ClientAuthenticationType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The <i>DescribeClientAuthenticationSettingsResult.NextToken</i> value from a previous call to <a>DescribeClientAuthenticationSettings</a>. Pass null if this is the first call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <i>DescribeClientAuthenticationSettingsResult.NextToken</i> value from a previous call to <a>DescribeClientAuthenticationSettings</a>. Pass null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return. If this value is zero, the maximum number of items is specified by the limitations of the operation. </p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of items to return. If this value is zero, the maximum number of items is specified by the limitations of the operation. </p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeClientAuthenticationSettingsInput`](crate::input::DescribeClientAuthenticationSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeClientAuthenticationSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeClientAuthenticationSettingsInput {
                directory_id: self.directory_id,
                r#type: self.r#type,
                next_token: self.next_token,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeClientAuthenticationSettingsInputOperationOutputAlias =
    crate::operation::DescribeClientAuthenticationSettings;
#[doc(hidden)]
pub type DescribeClientAuthenticationSettingsInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeClientAuthenticationSettingsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeClientAuthenticationSettings`](crate::operation::DescribeClientAuthenticationSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeClientAuthenticationSettings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeClientAuthenticationSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeClientAuthenticationSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeClientAuthenticationSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.DescribeClientAuthenticationSettings",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_client_authentication_settings(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeClientAuthenticationSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeClientAuthenticationSettings",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeClientAuthenticationSettingsInput`](crate::input::DescribeClientAuthenticationSettingsInput)
    pub fn builder() -> crate::input::describe_client_authentication_settings_input::Builder {
        crate::input::describe_client_authentication_settings_input::Builder::default()
    }
}

/// See [`DescribeConditionalForwardersInput`](crate::input::DescribeConditionalForwardersInput)
pub mod describe_conditional_forwarders_input {
    /// A builder for [`DescribeConditionalForwardersInput`](crate::input::DescribeConditionalForwardersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) remote_domain_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The directory ID for which to get the list of associated conditional
        /// forwarders.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The directory ID for which to get the list of associated conditional
        /// forwarders.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// Appends an item to `remote_domain_names`.
        ///
        /// To override the contents of this collection use [`set_remote_domain_names`](Self::set_remote_domain_names).
        ///
        /// <p>The fully qualified domain names (FQDN) of the remote domains for which to get the list
        /// of associated conditional forwarders. If this member is null, all conditional forwarders are
        /// returned.</p>
        pub fn remote_domain_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.remote_domain_names.unwrap_or_default();
            v.push(input.into());
            self.remote_domain_names = Some(v);
            self
        }
        /// <p>The fully qualified domain names (FQDN) of the remote domains for which to get the list
        /// of associated conditional forwarders. If this member is null, all conditional forwarders are
        /// returned.</p>
        pub fn set_remote_domain_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.remote_domain_names = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConditionalForwardersInput`](crate::input::DescribeConditionalForwardersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeConditionalForwardersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeConditionalForwardersInput {
                directory_id: self.directory_id,
                remote_domain_names: self.remote_domain_names,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeConditionalForwardersInputOperationOutputAlias =
    crate::operation::DescribeConditionalForwarders;
#[doc(hidden)]
pub type DescribeConditionalForwardersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeConditionalForwardersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeConditionalForwarders`](crate::operation::DescribeConditionalForwarders)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeConditionalForwarders,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeConditionalForwardersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeConditionalForwardersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeConditionalForwardersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.DescribeConditionalForwarders",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_conditional_forwarders(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeConditionalForwarders::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeConditionalForwarders",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeConditionalForwardersInput`](crate::input::DescribeConditionalForwardersInput)
    pub fn builder() -> crate::input::describe_conditional_forwarders_input::Builder {
        crate::input::describe_conditional_forwarders_input::Builder::default()
    }
}

/// See [`DescribeDirectoriesInput`](crate::input::DescribeDirectoriesInput)
pub mod describe_directories_input {
    /// A builder for [`DescribeDirectoriesInput`](crate::input::DescribeDirectoriesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `directory_ids`.
        ///
        /// To override the contents of this collection use [`set_directory_ids`](Self::set_directory_ids).
        ///
        /// <p>A list of identifiers of the directories for which to obtain the information. If this
        /// member is null, all directories that belong to the current account are returned.</p>
        /// <p>An empty list results in an <code>InvalidParameterException</code> being thrown.</p>
        pub fn directory_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.directory_ids.unwrap_or_default();
            v.push(input.into());
            self.directory_ids = Some(v);
            self
        }
        /// <p>A list of identifiers of the directories for which to obtain the information. If this
        /// member is null, all directories that belong to the current account are returned.</p>
        /// <p>An empty list results in an <code>InvalidParameterException</code> being thrown.</p>
        pub fn set_directory_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.directory_ids = input;
            self
        }
        /// <p>The <code>DescribeDirectoriesResult.NextToken</code> value from a previous call to <a>DescribeDirectories</a>. Pass null if this is the first call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>DescribeDirectoriesResult.NextToken</code> value from a previous call to <a>DescribeDirectories</a>. Pass null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return. If this value is zero, the maximum number of items
        /// is specified by the limitations of the operation.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of items to return. If this value is zero, the maximum number of items
        /// is specified by the limitations of the operation.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDirectoriesInput`](crate::input::DescribeDirectoriesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDirectoriesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDirectoriesInput {
                directory_ids: self.directory_ids,
                next_token: self.next_token,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDirectoriesInputOperationOutputAlias = crate::operation::DescribeDirectories;
#[doc(hidden)]
pub type DescribeDirectoriesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDirectoriesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDirectories`](crate::operation::DescribeDirectories)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDirectories,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDirectoriesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDirectoriesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDirectoriesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.DescribeDirectories",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_directories(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDirectories::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDirectories",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDirectoriesInput`](crate::input::DescribeDirectoriesInput)
    pub fn builder() -> crate::input::describe_directories_input::Builder {
        crate::input::describe_directories_input::Builder::default()
    }
}

/// See [`DescribeDomainControllersInput`](crate::input::DescribeDomainControllersInput)
pub mod describe_domain_controllers_input {
    /// A builder for [`DescribeDomainControllersInput`](crate::input::DescribeDomainControllersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) domain_controller_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Identifier of the directory for which to retrieve the domain controller
        /// information.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>Identifier of the directory for which to retrieve the domain controller
        /// information.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// Appends an item to `domain_controller_ids`.
        ///
        /// To override the contents of this collection use [`set_domain_controller_ids`](Self::set_domain_controller_ids).
        ///
        /// <p>A list of identifiers for the domain controllers whose information will be
        /// provided.</p>
        pub fn domain_controller_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.domain_controller_ids.unwrap_or_default();
            v.push(input.into());
            self.domain_controller_ids = Some(v);
            self
        }
        /// <p>A list of identifiers for the domain controllers whose information will be
        /// provided.</p>
        pub fn set_domain_controller_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.domain_controller_ids = input;
            self
        }
        /// <p>The <i>DescribeDomainControllers.NextToken</i> value from a previous call
        /// to <a>DescribeDomainControllers</a>. Pass null if this is the first call.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <i>DescribeDomainControllers.NextToken</i> value from a previous call
        /// to <a>DescribeDomainControllers</a>. Pass null if this is the first call.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDomainControllersInput`](crate::input::DescribeDomainControllersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDomainControllersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDomainControllersInput {
                directory_id: self.directory_id,
                domain_controller_ids: self.domain_controller_ids,
                next_token: self.next_token,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDomainControllersInputOperationOutputAlias =
    crate::operation::DescribeDomainControllers;
#[doc(hidden)]
pub type DescribeDomainControllersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDomainControllersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDomainControllers`](crate::operation::DescribeDomainControllers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDomainControllers,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDomainControllersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDomainControllersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDomainControllersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.DescribeDomainControllers",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_domain_controllers(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDomainControllers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDomainControllers",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDomainControllersInput`](crate::input::DescribeDomainControllersInput)
    pub fn builder() -> crate::input::describe_domain_controllers_input::Builder {
        crate::input::describe_domain_controllers_input::Builder::default()
    }
}

/// See [`DescribeEventTopicsInput`](crate::input::DescribeEventTopicsInput)
pub mod describe_event_topics_input {
    /// A builder for [`DescribeEventTopicsInput`](crate::input::DescribeEventTopicsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) topic_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Directory ID for which to get the list of associated Amazon SNS topics. If this member
        /// is null, associations for all Directory IDs are returned.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The Directory ID for which to get the list of associated Amazon SNS topics. If this member
        /// is null, associations for all Directory IDs are returned.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// Appends an item to `topic_names`.
        ///
        /// To override the contents of this collection use [`set_topic_names`](Self::set_topic_names).
        ///
        /// <p>A list of Amazon SNS topic names for which to obtain the information. If this member is
        /// null, all associations for the specified Directory ID are returned.</p>
        /// <p>An empty list results in an <code>InvalidParameterException</code> being
        /// thrown.</p>
        pub fn topic_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.topic_names.unwrap_or_default();
            v.push(input.into());
            self.topic_names = Some(v);
            self
        }
        /// <p>A list of Amazon SNS topic names for which to obtain the information. If this member is
        /// null, all associations for the specified Directory ID are returned.</p>
        /// <p>An empty list results in an <code>InvalidParameterException</code> being
        /// thrown.</p>
        pub fn set_topic_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.topic_names = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventTopicsInput`](crate::input::DescribeEventTopicsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEventTopicsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEventTopicsInput {
                directory_id: self.directory_id,
                topic_names: self.topic_names,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEventTopicsInputOperationOutputAlias = crate::operation::DescribeEventTopics;
#[doc(hidden)]
pub type DescribeEventTopicsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEventTopicsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEventTopics`](crate::operation::DescribeEventTopics)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEventTopics,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEventTopicsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEventTopicsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEventTopicsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.DescribeEventTopics",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_event_topics(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEventTopics::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEventTopics",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEventTopicsInput`](crate::input::DescribeEventTopicsInput)
    pub fn builder() -> crate::input::describe_event_topics_input::Builder {
        crate::input::describe_event_topics_input::Builder::default()
    }
}

/// See [`DescribeLdapsSettingsInput`](crate::input::DescribeLdapsSettingsInput)
pub mod describe_ldaps_settings_input {
    /// A builder for [`DescribeLdapsSettingsInput`](crate::input::DescribeLdapsSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::LdapsType>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the directory.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The type of LDAP security to enable. Currently only the value <code>Client</code> is
        /// supported.</p>
        pub fn r#type(mut self, input: crate::model::LdapsType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of LDAP security to enable. Currently only the value <code>Client</code> is
        /// supported.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::LdapsType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The type of next token used for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The type of next token used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Specifies the number of items that should be displayed on one page.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>Specifies the number of items that should be displayed on one page.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLdapsSettingsInput`](crate::input::DescribeLdapsSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeLdapsSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeLdapsSettingsInput {
                directory_id: self.directory_id,
                r#type: self.r#type,
                next_token: self.next_token,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeLdapsSettingsInputOperationOutputAlias = crate::operation::DescribeLDAPSSettings;
#[doc(hidden)]
pub type DescribeLdapsSettingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeLdapsSettingsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeLDAPSSettings`](crate::operation::DescribeLDAPSSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeLDAPSSettings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeLdapsSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeLdapsSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeLdapsSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.DescribeLDAPSSettings",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_ldaps_settings(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeLDAPSSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeLDAPSSettings",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeLdapsSettingsInput`](crate::input::DescribeLdapsSettingsInput)
    pub fn builder() -> crate::input::describe_ldaps_settings_input::Builder {
        crate::input::describe_ldaps_settings_input::Builder::default()
    }
}

/// See [`DescribeRegionsInput`](crate::input::DescribeRegionsInput)
pub mod describe_regions_input {
    /// A builder for [`DescribeRegionsInput`](crate::input::DescribeRegionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) region_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the directory.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The name of the Region. For example, <code>us-east-1</code>.</p>
        pub fn region_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.region_name = Some(input.into());
            self
        }
        /// <p>The name of the Region. For example, <code>us-east-1</code>.</p>
        pub fn set_region_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region_name = input;
            self
        }
        /// <p>The <code>DescribeRegionsResult.NextToken</code> value from a previous call to <a>DescribeRegions</a>. Pass null if this is the first call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>DescribeRegionsResult.NextToken</code> value from a previous call to <a>DescribeRegions</a>. Pass null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRegionsInput`](crate::input::DescribeRegionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRegionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRegionsInput {
                directory_id: self.directory_id,
                region_name: self.region_name,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRegionsInputOperationOutputAlias = crate::operation::DescribeRegions;
#[doc(hidden)]
pub type DescribeRegionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeRegionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRegions`](crate::operation::DescribeRegions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRegions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeRegionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeRegionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeRegionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.DescribeRegions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_regions(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRegions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRegions",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeRegionsInput`](crate::input::DescribeRegionsInput)
    pub fn builder() -> crate::input::describe_regions_input::Builder {
        crate::input::describe_regions_input::Builder::default()
    }
}

/// See [`DescribeSharedDirectoriesInput`](crate::input::DescribeSharedDirectoriesInput)
pub mod describe_shared_directories_input {
    /// A builder for [`DescribeSharedDirectoriesInput`](crate::input::DescribeSharedDirectoriesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_directory_id: std::option::Option<std::string::String>,
        pub(crate) shared_directory_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Returns the identifier of the directory in the directory owner account. </p>
        pub fn owner_directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_directory_id = Some(input.into());
            self
        }
        /// <p>Returns the identifier of the directory in the directory owner account. </p>
        pub fn set_owner_directory_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_directory_id = input;
            self
        }
        /// Appends an item to `shared_directory_ids`.
        ///
        /// To override the contents of this collection use [`set_shared_directory_ids`](Self::set_shared_directory_ids).
        ///
        /// <p>A list of identifiers of all shared directories in your account. </p>
        pub fn shared_directory_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.shared_directory_ids.unwrap_or_default();
            v.push(input.into());
            self.shared_directory_ids = Some(v);
            self
        }
        /// <p>A list of identifiers of all shared directories in your account. </p>
        pub fn set_shared_directory_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.shared_directory_ids = input;
            self
        }
        /// <p>The <code>DescribeSharedDirectoriesResult.NextToken</code> value from a previous call to
        /// <a>DescribeSharedDirectories</a>. Pass null if this is the first call. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>DescribeSharedDirectoriesResult.NextToken</code> value from a previous call to
        /// <a>DescribeSharedDirectories</a>. Pass null if this is the first call. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The number of shared directories to return in the response object.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The number of shared directories to return in the response object.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSharedDirectoriesInput`](crate::input::DescribeSharedDirectoriesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSharedDirectoriesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSharedDirectoriesInput {
                owner_directory_id: self.owner_directory_id,
                shared_directory_ids: self.shared_directory_ids,
                next_token: self.next_token,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSharedDirectoriesInputOperationOutputAlias =
    crate::operation::DescribeSharedDirectories;
#[doc(hidden)]
pub type DescribeSharedDirectoriesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeSharedDirectoriesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSharedDirectories`](crate::operation::DescribeSharedDirectories)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSharedDirectories,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSharedDirectoriesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSharedDirectoriesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSharedDirectoriesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.DescribeSharedDirectories",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_shared_directories(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSharedDirectories::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSharedDirectories",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSharedDirectoriesInput`](crate::input::DescribeSharedDirectoriesInput)
    pub fn builder() -> crate::input::describe_shared_directories_input::Builder {
        crate::input::describe_shared_directories_input::Builder::default()
    }
}

/// See [`DescribeSnapshotsInput`](crate::input::DescribeSnapshotsInput)
pub mod describe_snapshots_input {
    /// A builder for [`DescribeSnapshotsInput`](crate::input::DescribeSnapshotsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) snapshot_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the directory for which to retrieve snapshot information.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory for which to retrieve snapshot information.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// Appends an item to `snapshot_ids`.
        ///
        /// To override the contents of this collection use [`set_snapshot_ids`](Self::set_snapshot_ids).
        ///
        /// <p>A list of identifiers of the snapshots to obtain the information for. If this member is
        /// null or empty, all snapshots are returned using the <i>Limit</i> and <i>NextToken</i>
        /// members.</p>
        pub fn snapshot_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.snapshot_ids.unwrap_or_default();
            v.push(input.into());
            self.snapshot_ids = Some(v);
            self
        }
        /// <p>A list of identifiers of the snapshots to obtain the information for. If this member is
        /// null or empty, all snapshots are returned using the <i>Limit</i> and <i>NextToken</i>
        /// members.</p>
        pub fn set_snapshot_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.snapshot_ids = input;
            self
        }
        /// <p>The <i>DescribeSnapshotsResult.NextToken</i> value from a previous call to
        /// <a>DescribeSnapshots</a>. Pass null if this is the first call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <i>DescribeSnapshotsResult.NextToken</i> value from a previous call to
        /// <a>DescribeSnapshots</a>. Pass null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of objects to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of objects to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSnapshotsInput`](crate::input::DescribeSnapshotsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSnapshotsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSnapshotsInput {
                directory_id: self.directory_id,
                snapshot_ids: self.snapshot_ids,
                next_token: self.next_token,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSnapshotsInputOperationOutputAlias = crate::operation::DescribeSnapshots;
#[doc(hidden)]
pub type DescribeSnapshotsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeSnapshotsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSnapshots`](crate::operation::DescribeSnapshots)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSnapshots,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSnapshotsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSnapshotsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSnapshotsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.DescribeSnapshots",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_snapshots(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSnapshots::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSnapshots",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSnapshotsInput`](crate::input::DescribeSnapshotsInput)
    pub fn builder() -> crate::input::describe_snapshots_input::Builder {
        crate::input::describe_snapshots_input::Builder::default()
    }
}

/// See [`DescribeTrustsInput`](crate::input::DescribeTrustsInput)
pub mod describe_trusts_input {
    /// A builder for [`DescribeTrustsInput`](crate::input::DescribeTrustsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) trust_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Directory ID of the Amazon Web Services directory that is a part of the requested trust
        /// relationship.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The Directory ID of the Amazon Web Services directory that is a part of the requested trust
        /// relationship.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// Appends an item to `trust_ids`.
        ///
        /// To override the contents of this collection use [`set_trust_ids`](Self::set_trust_ids).
        ///
        /// <p>A list of identifiers of the trust relationships for which to obtain the information. If
        /// this member is null, all trust relationships that belong to the current account are
        /// returned.</p>
        /// <p>An empty list results in an <code>InvalidParameterException</code> being thrown.</p>
        pub fn trust_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.trust_ids.unwrap_or_default();
            v.push(input.into());
            self.trust_ids = Some(v);
            self
        }
        /// <p>A list of identifiers of the trust relationships for which to obtain the information. If
        /// this member is null, all trust relationships that belong to the current account are
        /// returned.</p>
        /// <p>An empty list results in an <code>InvalidParameterException</code> being thrown.</p>
        pub fn set_trust_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.trust_ids = input;
            self
        }
        /// <p>The <i>DescribeTrustsResult.NextToken</i> value from a previous call to
        /// <a>DescribeTrusts</a>. Pass null if this is the first call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <i>DescribeTrustsResult.NextToken</i> value from a previous call to
        /// <a>DescribeTrusts</a>. Pass null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of objects to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of objects to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTrustsInput`](crate::input::DescribeTrustsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTrustsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTrustsInput {
                directory_id: self.directory_id,
                trust_ids: self.trust_ids,
                next_token: self.next_token,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTrustsInputOperationOutputAlias = crate::operation::DescribeTrusts;
#[doc(hidden)]
pub type DescribeTrustsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeTrustsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTrusts`](crate::operation::DescribeTrusts)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTrusts,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTrustsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTrustsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTrustsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.DescribeTrusts",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_trusts(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTrusts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTrusts",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTrustsInput`](crate::input::DescribeTrustsInput)
    pub fn builder() -> crate::input::describe_trusts_input::Builder {
        crate::input::describe_trusts_input::Builder::default()
    }
}

/// See [`DisableClientAuthenticationInput`](crate::input::DisableClientAuthenticationInput)
pub mod disable_client_authentication_input {
    /// A builder for [`DisableClientAuthenticationInput`](crate::input::DisableClientAuthenticationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ClientAuthenticationType>,
    }
    impl Builder {
        /// <p>The identifier of the directory </p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory </p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The type of client authentication to disable. Currently, only the parameter, <code>SmartCard</code> is supported.</p>
        pub fn r#type(mut self, input: crate::model::ClientAuthenticationType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of client authentication to disable. Currently, only the parameter, <code>SmartCard</code> is supported.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ClientAuthenticationType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableClientAuthenticationInput`](crate::input::DisableClientAuthenticationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisableClientAuthenticationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisableClientAuthenticationInput {
                directory_id: self.directory_id,
                r#type: self.r#type,
            })
        }
    }
}
#[doc(hidden)]
pub type DisableClientAuthenticationInputOperationOutputAlias =
    crate::operation::DisableClientAuthentication;
#[doc(hidden)]
pub type DisableClientAuthenticationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisableClientAuthenticationInput {
    /// Consumes the builder and constructs an Operation<[`DisableClientAuthentication`](crate::operation::DisableClientAuthentication)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisableClientAuthentication,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisableClientAuthenticationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisableClientAuthenticationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisableClientAuthenticationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.DisableClientAuthentication",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disable_client_authentication(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisableClientAuthentication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisableClientAuthentication",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisableClientAuthenticationInput`](crate::input::DisableClientAuthenticationInput)
    pub fn builder() -> crate::input::disable_client_authentication_input::Builder {
        crate::input::disable_client_authentication_input::Builder::default()
    }
}

/// See [`DisableLdapsInput`](crate::input::DisableLdapsInput)
pub mod disable_ldaps_input {
    /// A builder for [`DisableLdapsInput`](crate::input::DisableLdapsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::LdapsType>,
    }
    impl Builder {
        /// <p>The identifier of the directory.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The type of LDAP security to enable. Currently only the value <code>Client</code> is
        /// supported.</p>
        pub fn r#type(mut self, input: crate::model::LdapsType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of LDAP security to enable. Currently only the value <code>Client</code> is
        /// supported.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::LdapsType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableLdapsInput`](crate::input::DisableLdapsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisableLdapsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisableLdapsInput {
                directory_id: self.directory_id,
                r#type: self.r#type,
            })
        }
    }
}
#[doc(hidden)]
pub type DisableLdapsInputOperationOutputAlias = crate::operation::DisableLDAPS;
#[doc(hidden)]
pub type DisableLdapsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisableLdapsInput {
    /// Consumes the builder and constructs an Operation<[`DisableLDAPS`](crate::operation::DisableLDAPS)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisableLDAPS,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisableLdapsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisableLdapsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisableLdapsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.DisableLDAPS",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_disable_ldaps(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisableLDAPS::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisableLDAPS",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisableLdapsInput`](crate::input::DisableLdapsInput)
    pub fn builder() -> crate::input::disable_ldaps_input::Builder {
        crate::input::disable_ldaps_input::Builder::default()
    }
}

/// See [`DisableRadiusInput`](crate::input::DisableRadiusInput)
pub mod disable_radius_input {
    /// A builder for [`DisableRadiusInput`](crate::input::DisableRadiusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the directory for which to disable MFA.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory for which to disable MFA.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableRadiusInput`](crate::input::DisableRadiusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisableRadiusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisableRadiusInput {
                directory_id: self.directory_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DisableRadiusInputOperationOutputAlias = crate::operation::DisableRadius;
#[doc(hidden)]
pub type DisableRadiusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisableRadiusInput {
    /// Consumes the builder and constructs an Operation<[`DisableRadius`](crate::operation::DisableRadius)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisableRadius,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisableRadiusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisableRadiusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisableRadiusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.DisableRadius",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_disable_radius(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisableRadius::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisableRadius",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisableRadiusInput`](crate::input::DisableRadiusInput)
    pub fn builder() -> crate::input::disable_radius_input::Builder {
        crate::input::disable_radius_input::Builder::default()
    }
}

/// See [`DisableSsoInput`](crate::input::DisableSsoInput)
pub mod disable_sso_input {
    /// A builder for [`DisableSsoInput`](crate::input::DisableSsoInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the directory for which to disable single-sign on.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory for which to disable single-sign on.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The username of an alternate account to use to disable single-sign on. This is only used
        /// for AD Connector directories. This account must have privileges to remove a service
        /// principal name.</p>
        /// <p>If the AD Connector service account does not have privileges to remove a service
        /// principal name, you can specify an alternate account with the <i>UserName</i>
        /// and <i>Password</i> parameters. These credentials are only used to disable
        /// single sign-on and are not stored by the service. The AD Connector service account is not
        /// changed.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The username of an alternate account to use to disable single-sign on. This is only used
        /// for AD Connector directories. This account must have privileges to remove a service
        /// principal name.</p>
        /// <p>If the AD Connector service account does not have privileges to remove a service
        /// principal name, you can specify an alternate account with the <i>UserName</i>
        /// and <i>Password</i> parameters. These credentials are only used to disable
        /// single sign-on and are not stored by the service. The AD Connector service account is not
        /// changed.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The password of an alternate account to use to disable single-sign on. This is only used
        /// for AD Connector directories. For more information, see the <i>UserName</i>
        /// parameter.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>The password of an alternate account to use to disable single-sign on. This is only used
        /// for AD Connector directories. For more information, see the <i>UserName</i>
        /// parameter.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableSsoInput`](crate::input::DisableSsoInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisableSsoInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisableSsoInput {
                directory_id: self.directory_id,
                user_name: self.user_name,
                password: self.password,
            })
        }
    }
}
#[doc(hidden)]
pub type DisableSsoInputOperationOutputAlias = crate::operation::DisableSso;
#[doc(hidden)]
pub type DisableSsoInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisableSsoInput {
    /// Consumes the builder and constructs an Operation<[`DisableSso`](crate::operation::DisableSso)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisableSso,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisableSsoInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisableSsoInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisableSsoInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.DisableSso",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_disable_sso(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisableSso::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisableSso",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisableSsoInput`](crate::input::DisableSsoInput)
    pub fn builder() -> crate::input::disable_sso_input::Builder {
        crate::input::disable_sso_input::Builder::default()
    }
}

/// See [`EnableClientAuthenticationInput`](crate::input::EnableClientAuthenticationInput)
pub mod enable_client_authentication_input {
    /// A builder for [`EnableClientAuthenticationInput`](crate::input::EnableClientAuthenticationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ClientAuthenticationType>,
    }
    impl Builder {
        /// <p>The identifier of the specified directory. </p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the specified directory. </p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The type of client authentication to enable. Currently only the value <code>SmartCard</code> is
        /// supported. Smart card authentication in AD Connector requires that you enable Kerberos
        /// Constrained Delegation for the Service User to the LDAP service in your self-managed AD.
        /// </p>
        pub fn r#type(mut self, input: crate::model::ClientAuthenticationType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of client authentication to enable. Currently only the value <code>SmartCard</code> is
        /// supported. Smart card authentication in AD Connector requires that you enable Kerberos
        /// Constrained Delegation for the Service User to the LDAP service in your self-managed AD.
        /// </p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ClientAuthenticationType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableClientAuthenticationInput`](crate::input::EnableClientAuthenticationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EnableClientAuthenticationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EnableClientAuthenticationInput {
                directory_id: self.directory_id,
                r#type: self.r#type,
            })
        }
    }
}
#[doc(hidden)]
pub type EnableClientAuthenticationInputOperationOutputAlias =
    crate::operation::EnableClientAuthentication;
#[doc(hidden)]
pub type EnableClientAuthenticationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl EnableClientAuthenticationInput {
    /// Consumes the builder and constructs an Operation<[`EnableClientAuthentication`](crate::operation::EnableClientAuthentication)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnableClientAuthentication,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::EnableClientAuthenticationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::EnableClientAuthenticationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::EnableClientAuthenticationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.EnableClientAuthentication",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_enable_client_authentication(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EnableClientAuthentication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EnableClientAuthentication",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`EnableClientAuthenticationInput`](crate::input::EnableClientAuthenticationInput)
    pub fn builder() -> crate::input::enable_client_authentication_input::Builder {
        crate::input::enable_client_authentication_input::Builder::default()
    }
}

/// See [`EnableLdapsInput`](crate::input::EnableLdapsInput)
pub mod enable_ldaps_input {
    /// A builder for [`EnableLdapsInput`](crate::input::EnableLdapsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::LdapsType>,
    }
    impl Builder {
        /// <p>The identifier of the directory.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The type of LDAP security to enable. Currently only the value <code>Client</code> is
        /// supported.</p>
        pub fn r#type(mut self, input: crate::model::LdapsType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of LDAP security to enable. Currently only the value <code>Client</code> is
        /// supported.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::LdapsType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableLdapsInput`](crate::input::EnableLdapsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EnableLdapsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EnableLdapsInput {
                directory_id: self.directory_id,
                r#type: self.r#type,
            })
        }
    }
}
#[doc(hidden)]
pub type EnableLdapsInputOperationOutputAlias = crate::operation::EnableLDAPS;
#[doc(hidden)]
pub type EnableLdapsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl EnableLdapsInput {
    /// Consumes the builder and constructs an Operation<[`EnableLDAPS`](crate::operation::EnableLDAPS)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnableLDAPS,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::EnableLdapsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::EnableLdapsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::EnableLdapsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.EnableLDAPS",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_enable_ldaps(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EnableLDAPS::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EnableLDAPS",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`EnableLdapsInput`](crate::input::EnableLdapsInput)
    pub fn builder() -> crate::input::enable_ldaps_input::Builder {
        crate::input::enable_ldaps_input::Builder::default()
    }
}

/// See [`EnableRadiusInput`](crate::input::EnableRadiusInput)
pub mod enable_radius_input {
    /// A builder for [`EnableRadiusInput`](crate::input::EnableRadiusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) radius_settings: std::option::Option<crate::model::RadiusSettings>,
    }
    impl Builder {
        /// <p>The identifier of the directory for which to enable MFA.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory for which to enable MFA.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>A <a>RadiusSettings</a> object that contains information about the RADIUS
        /// server.</p>
        pub fn radius_settings(mut self, input: crate::model::RadiusSettings) -> Self {
            self.radius_settings = Some(input);
            self
        }
        /// <p>A <a>RadiusSettings</a> object that contains information about the RADIUS
        /// server.</p>
        pub fn set_radius_settings(
            mut self,
            input: std::option::Option<crate::model::RadiusSettings>,
        ) -> Self {
            self.radius_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableRadiusInput`](crate::input::EnableRadiusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EnableRadiusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EnableRadiusInput {
                directory_id: self.directory_id,
                radius_settings: self.radius_settings,
            })
        }
    }
}
#[doc(hidden)]
pub type EnableRadiusInputOperationOutputAlias = crate::operation::EnableRadius;
#[doc(hidden)]
pub type EnableRadiusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl EnableRadiusInput {
    /// Consumes the builder and constructs an Operation<[`EnableRadius`](crate::operation::EnableRadius)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnableRadius,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::EnableRadiusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::EnableRadiusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::EnableRadiusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.EnableRadius",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_enable_radius(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EnableRadius::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EnableRadius",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`EnableRadiusInput`](crate::input::EnableRadiusInput)
    pub fn builder() -> crate::input::enable_radius_input::Builder {
        crate::input::enable_radius_input::Builder::default()
    }
}

/// See [`EnableSsoInput`](crate::input::EnableSsoInput)
pub mod enable_sso_input {
    /// A builder for [`EnableSsoInput`](crate::input::EnableSsoInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the directory for which to enable single-sign on.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory for which to enable single-sign on.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The username of an alternate account to use to enable single-sign on. This is only used
        /// for AD Connector directories. This account must have privileges to add a service principal
        /// name.</p>
        /// <p>If the AD Connector service account does not have privileges to add a service principal
        /// name, you can specify an alternate account with the <i>UserName</i> and
        /// <i>Password</i> parameters. These credentials are only used to enable single
        /// sign-on and are not stored by the service. The AD Connector service account is not
        /// changed.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The username of an alternate account to use to enable single-sign on. This is only used
        /// for AD Connector directories. This account must have privileges to add a service principal
        /// name.</p>
        /// <p>If the AD Connector service account does not have privileges to add a service principal
        /// name, you can specify an alternate account with the <i>UserName</i> and
        /// <i>Password</i> parameters. These credentials are only used to enable single
        /// sign-on and are not stored by the service. The AD Connector service account is not
        /// changed.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The password of an alternate account to use to enable single-sign on. This is only used
        /// for AD Connector directories. For more information, see the <i>UserName</i>
        /// parameter.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>The password of an alternate account to use to enable single-sign on. This is only used
        /// for AD Connector directories. For more information, see the <i>UserName</i>
        /// parameter.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableSsoInput`](crate::input::EnableSsoInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::EnableSsoInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::EnableSsoInput {
                directory_id: self.directory_id,
                user_name: self.user_name,
                password: self.password,
            })
        }
    }
}
#[doc(hidden)]
pub type EnableSsoInputOperationOutputAlias = crate::operation::EnableSso;
#[doc(hidden)]
pub type EnableSsoInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl EnableSsoInput {
    /// Consumes the builder and constructs an Operation<[`EnableSso`](crate::operation::EnableSso)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnableSso,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::EnableSsoInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::EnableSsoInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::EnableSsoInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.EnableSso",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_enable_sso(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::EnableSso::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "EnableSso",
                    "directoryservice",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`EnableSsoInput`](crate::input::EnableSsoInput)
    pub fn builder() -> crate::input::enable_sso_input::Builder {
        crate::input::enable_sso_input::Builder::default()
    }
}

/// See [`GetDirectoryLimitsInput`](crate::input::GetDirectoryLimitsInput)
pub mod get_directory_limits_input {
    /// A builder for [`GetDirectoryLimitsInput`](crate::input::GetDirectoryLimitsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetDirectoryLimitsInput`](crate::input::GetDirectoryLimitsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDirectoryLimitsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDirectoryLimitsInput {})
        }
    }
}
#[doc(hidden)]
pub type GetDirectoryLimitsInputOperationOutputAlias = crate::operation::GetDirectoryLimits;
#[doc(hidden)]
pub type GetDirectoryLimitsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDirectoryLimitsInput {
    /// Consumes the builder and constructs an Operation<[`GetDirectoryLimits`](crate::operation::GetDirectoryLimits)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDirectoryLimits,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDirectoryLimitsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDirectoryLimitsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDirectoryLimitsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.GetDirectoryLimits",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_directory_limits(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDirectoryLimits::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDirectoryLimits",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDirectoryLimitsInput`](crate::input::GetDirectoryLimitsInput)
    pub fn builder() -> crate::input::get_directory_limits_input::Builder {
        crate::input::get_directory_limits_input::Builder::default()
    }
}

/// See [`GetSnapshotLimitsInput`](crate::input::GetSnapshotLimitsInput)
pub mod get_snapshot_limits_input {
    /// A builder for [`GetSnapshotLimitsInput`](crate::input::GetSnapshotLimitsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Contains the identifier of the directory to obtain the limits for.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>Contains the identifier of the directory to obtain the limits for.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSnapshotLimitsInput`](crate::input::GetSnapshotLimitsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSnapshotLimitsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSnapshotLimitsInput {
                directory_id: self.directory_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSnapshotLimitsInputOperationOutputAlias = crate::operation::GetSnapshotLimits;
#[doc(hidden)]
pub type GetSnapshotLimitsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSnapshotLimitsInput {
    /// Consumes the builder and constructs an Operation<[`GetSnapshotLimits`](crate::operation::GetSnapshotLimits)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSnapshotLimits,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSnapshotLimitsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSnapshotLimitsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSnapshotLimitsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.GetSnapshotLimits",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_snapshot_limits(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSnapshotLimits::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSnapshotLimits",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSnapshotLimitsInput`](crate::input::GetSnapshotLimitsInput)
    pub fn builder() -> crate::input::get_snapshot_limits_input::Builder {
        crate::input::get_snapshot_limits_input::Builder::default()
    }
}

/// See [`ListCertificatesInput`](crate::input::ListCertificatesInput)
pub mod list_certificates_input {
    /// A builder for [`ListCertificatesInput`](crate::input::ListCertificatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the directory.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>A token for requesting another page of certificates if the <code>NextToken</code> response
        /// element indicates that more certificates are available. Use the value of the returned
        /// <code>NextToken</code> element in your request until the token comes back as
        /// <code>null</code>. Pass <code>null</code> if this is the first call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token for requesting another page of certificates if the <code>NextToken</code> response
        /// element indicates that more certificates are available. Use the value of the returned
        /// <code>NextToken</code> element in your request until the token comes back as
        /// <code>null</code>. Pass <code>null</code> if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The number of items that should show up on one page</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The number of items that should show up on one page</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCertificatesInput`](crate::input::ListCertificatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListCertificatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListCertificatesInput {
                directory_id: self.directory_id,
                next_token: self.next_token,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type ListCertificatesInputOperationOutputAlias = crate::operation::ListCertificates;
#[doc(hidden)]
pub type ListCertificatesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListCertificatesInput {
    /// Consumes the builder and constructs an Operation<[`ListCertificates`](crate::operation::ListCertificates)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListCertificates,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListCertificatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListCertificatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListCertificatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.ListCertificates",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_certificates(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListCertificates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListCertificates",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListCertificatesInput`](crate::input::ListCertificatesInput)
    pub fn builder() -> crate::input::list_certificates_input::Builder {
        crate::input::list_certificates_input::Builder::default()
    }
}

/// See [`ListIpRoutesInput`](crate::input::ListIpRoutesInput)
pub mod list_ip_routes_input {
    /// A builder for [`ListIpRoutesInput`](crate::input::ListIpRoutesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Identifier (ID) of the directory for which you want to retrieve the IP
        /// addresses.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>Identifier (ID) of the directory for which you want to retrieve the IP
        /// addresses.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The <i>ListIpRoutes.NextToken</i> value from a previous call to <a>ListIpRoutes</a>. Pass null if this is the first call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <i>ListIpRoutes.NextToken</i> value from a previous call to <a>ListIpRoutes</a>. Pass null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Maximum number of items to return. If this value is zero, the maximum number of items
        /// is specified by the limitations of the operation.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>Maximum number of items to return. If this value is zero, the maximum number of items
        /// is specified by the limitations of the operation.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIpRoutesInput`](crate::input::ListIpRoutesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListIpRoutesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListIpRoutesInput {
                directory_id: self.directory_id,
                next_token: self.next_token,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type ListIpRoutesInputOperationOutputAlias = crate::operation::ListIpRoutes;
#[doc(hidden)]
pub type ListIpRoutesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListIpRoutesInput {
    /// Consumes the builder and constructs an Operation<[`ListIpRoutes`](crate::operation::ListIpRoutes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListIpRoutes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListIpRoutesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListIpRoutesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListIpRoutesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.ListIpRoutes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_ip_routes(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListIpRoutes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListIpRoutes",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListIpRoutesInput`](crate::input::ListIpRoutesInput)
    pub fn builder() -> crate::input::list_ip_routes_input::Builder {
        crate::input::list_ip_routes_input::Builder::default()
    }
}

/// See [`ListLogSubscriptionsInput`](crate::input::ListLogSubscriptionsInput)
pub mod list_log_subscriptions_input {
    /// A builder for [`ListLogSubscriptionsInput`](crate::input::ListLogSubscriptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>If a <i>DirectoryID</i> is provided, lists only the log subscription
        /// associated with that directory. If no <i>DirectoryId</i> is provided, lists all
        /// log subscriptions associated with your Amazon Web Services account. If there are no log subscriptions for the
        /// Amazon Web Services account or the directory, an empty list will be returned.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>If a <i>DirectoryID</i> is provided, lists only the log subscription
        /// associated with that directory. If no <i>DirectoryId</i> is provided, lists all
        /// log subscriptions associated with your Amazon Web Services account. If there are no log subscriptions for the
        /// Amazon Web Services account or the directory, an empty list will be returned.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The token for the next set of items to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items returned.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of items returned.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLogSubscriptionsInput`](crate::input::ListLogSubscriptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListLogSubscriptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListLogSubscriptionsInput {
                directory_id: self.directory_id,
                next_token: self.next_token,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type ListLogSubscriptionsInputOperationOutputAlias = crate::operation::ListLogSubscriptions;
#[doc(hidden)]
pub type ListLogSubscriptionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListLogSubscriptionsInput {
    /// Consumes the builder and constructs an Operation<[`ListLogSubscriptions`](crate::operation::ListLogSubscriptions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListLogSubscriptions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListLogSubscriptionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListLogSubscriptionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListLogSubscriptionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.ListLogSubscriptions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_log_subscriptions(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListLogSubscriptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListLogSubscriptions",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListLogSubscriptionsInput`](crate::input::ListLogSubscriptionsInput)
    pub fn builder() -> crate::input::list_log_subscriptions_input::Builder {
        crate::input::list_log_subscriptions_input::Builder::default()
    }
}

/// See [`ListSchemaExtensionsInput`](crate::input::ListSchemaExtensionsInput)
pub mod list_schema_extensions_input {
    /// A builder for [`ListSchemaExtensionsInput`](crate::input::ListSchemaExtensionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the directory from which to retrieve the schema extension
        /// information.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory from which to retrieve the schema extension
        /// information.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The <code>ListSchemaExtensions.NextToken</code> value from a previous call to
        /// <code>ListSchemaExtensions</code>. Pass null if this is the first call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>ListSchemaExtensions.NextToken</code> value from a previous call to
        /// <code>ListSchemaExtensions</code>. Pass null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSchemaExtensionsInput`](crate::input::ListSchemaExtensionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSchemaExtensionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSchemaExtensionsInput {
                directory_id: self.directory_id,
                next_token: self.next_token,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSchemaExtensionsInputOperationOutputAlias = crate::operation::ListSchemaExtensions;
#[doc(hidden)]
pub type ListSchemaExtensionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListSchemaExtensionsInput {
    /// Consumes the builder and constructs an Operation<[`ListSchemaExtensions`](crate::operation::ListSchemaExtensions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSchemaExtensions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSchemaExtensionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSchemaExtensionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSchemaExtensionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.ListSchemaExtensions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_schema_extensions(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSchemaExtensions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSchemaExtensions",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSchemaExtensionsInput`](crate::input::ListSchemaExtensionsInput)
    pub fn builder() -> crate::input::list_schema_extensions_input::Builder {
        crate::input::list_schema_extensions_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Identifier (ID) of the directory for which you want to retrieve tags.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>Identifier (ID) of the directory for which you want to retrieve tags.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_id: self.resource_id,
                next_token: self.next_token,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`RegisterCertificateInput`](crate::input::RegisterCertificateInput)
pub mod register_certificate_input {
    /// A builder for [`RegisterCertificateInput`](crate::input::RegisterCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) certificate_data: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::CertificateType>,
        pub(crate) client_cert_auth_settings:
            std::option::Option<crate::model::ClientCertAuthSettings>,
    }
    impl Builder {
        /// <p>The identifier of the directory.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The certificate PEM string that needs to be registered.</p>
        pub fn certificate_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_data = Some(input.into());
            self
        }
        /// <p>The certificate PEM string that needs to be registered.</p>
        pub fn set_certificate_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_data = input;
            self
        }
        /// <p>The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.</p>
        pub fn r#type(mut self, input: crate::model::CertificateType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::CertificateType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>A <code>ClientCertAuthSettings</code> object that contains client certificate authentication settings.</p>
        pub fn client_cert_auth_settings(
            mut self,
            input: crate::model::ClientCertAuthSettings,
        ) -> Self {
            self.client_cert_auth_settings = Some(input);
            self
        }
        /// <p>A <code>ClientCertAuthSettings</code> object that contains client certificate authentication settings.</p>
        pub fn set_client_cert_auth_settings(
            mut self,
            input: std::option::Option<crate::model::ClientCertAuthSettings>,
        ) -> Self {
            self.client_cert_auth_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterCertificateInput`](crate::input::RegisterCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterCertificateInput {
                directory_id: self.directory_id,
                certificate_data: self.certificate_data,
                r#type: self.r#type,
                client_cert_auth_settings: self.client_cert_auth_settings,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterCertificateInputOperationOutputAlias = crate::operation::RegisterCertificate;
#[doc(hidden)]
pub type RegisterCertificateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RegisterCertificateInput {
    /// Consumes the builder and constructs an Operation<[`RegisterCertificate`](crate::operation::RegisterCertificate)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterCertificate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RegisterCertificateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RegisterCertificateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RegisterCertificateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.RegisterCertificate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_register_certificate(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterCertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterCertificate",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RegisterCertificateInput`](crate::input::RegisterCertificateInput)
    pub fn builder() -> crate::input::register_certificate_input::Builder {
        crate::input::register_certificate_input::Builder::default()
    }
}

/// See [`RegisterEventTopicInput`](crate::input::RegisterEventTopicInput)
pub mod register_event_topic_input {
    /// A builder for [`RegisterEventTopicInput`](crate::input::RegisterEventTopicInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) topic_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Directory ID that will publish status messages to the Amazon SNS topic.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The Directory ID that will publish status messages to the Amazon SNS topic.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The Amazon SNS topic name to which the directory will publish status messages. This Amazon SNS
        /// topic must be in the same region as the specified Directory ID.</p>
        pub fn topic_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_name = Some(input.into());
            self
        }
        /// <p>The Amazon SNS topic name to which the directory will publish status messages. This Amazon SNS
        /// topic must be in the same region as the specified Directory ID.</p>
        pub fn set_topic_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_name = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterEventTopicInput`](crate::input::RegisterEventTopicInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterEventTopicInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterEventTopicInput {
                directory_id: self.directory_id,
                topic_name: self.topic_name,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterEventTopicInputOperationOutputAlias = crate::operation::RegisterEventTopic;
#[doc(hidden)]
pub type RegisterEventTopicInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RegisterEventTopicInput {
    /// Consumes the builder and constructs an Operation<[`RegisterEventTopic`](crate::operation::RegisterEventTopic)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterEventTopic,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RegisterEventTopicInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RegisterEventTopicInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RegisterEventTopicInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.RegisterEventTopic",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_register_event_topic(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterEventTopic::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterEventTopic",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RegisterEventTopicInput`](crate::input::RegisterEventTopicInput)
    pub fn builder() -> crate::input::register_event_topic_input::Builder {
        crate::input::register_event_topic_input::Builder::default()
    }
}

/// See [`RejectSharedDirectoryInput`](crate::input::RejectSharedDirectoryInput)
pub mod reject_shared_directory_input {
    /// A builder for [`RejectSharedDirectoryInput`](crate::input::RejectSharedDirectoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) shared_directory_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Identifier of the shared directory in the directory consumer account. This identifier is
        /// different for each directory owner account.</p>
        pub fn shared_directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.shared_directory_id = Some(input.into());
            self
        }
        /// <p>Identifier of the shared directory in the directory consumer account. This identifier is
        /// different for each directory owner account.</p>
        pub fn set_shared_directory_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.shared_directory_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RejectSharedDirectoryInput`](crate::input::RejectSharedDirectoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RejectSharedDirectoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RejectSharedDirectoryInput {
                shared_directory_id: self.shared_directory_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RejectSharedDirectoryInputOperationOutputAlias = crate::operation::RejectSharedDirectory;
#[doc(hidden)]
pub type RejectSharedDirectoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RejectSharedDirectoryInput {
    /// Consumes the builder and constructs an Operation<[`RejectSharedDirectory`](crate::operation::RejectSharedDirectory)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RejectSharedDirectory,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RejectSharedDirectoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RejectSharedDirectoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RejectSharedDirectoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.RejectSharedDirectory",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_reject_shared_directory(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RejectSharedDirectory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RejectSharedDirectory",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RejectSharedDirectoryInput`](crate::input::RejectSharedDirectoryInput)
    pub fn builder() -> crate::input::reject_shared_directory_input::Builder {
        crate::input::reject_shared_directory_input::Builder::default()
    }
}

/// See [`RemoveIpRoutesInput`](crate::input::RemoveIpRoutesInput)
pub mod remove_ip_routes_input {
    /// A builder for [`RemoveIpRoutesInput`](crate::input::RemoveIpRoutesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) cidr_ips: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Identifier (ID) of the directory from which you want to remove the IP
        /// addresses.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>Identifier (ID) of the directory from which you want to remove the IP
        /// addresses.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// Appends an item to `cidr_ips`.
        ///
        /// To override the contents of this collection use [`set_cidr_ips`](Self::set_cidr_ips).
        ///
        /// <p>IP address blocks that you want to remove.</p>
        pub fn cidr_ips(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cidr_ips.unwrap_or_default();
            v.push(input.into());
            self.cidr_ips = Some(v);
            self
        }
        /// <p>IP address blocks that you want to remove.</p>
        pub fn set_cidr_ips(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cidr_ips = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveIpRoutesInput`](crate::input::RemoveIpRoutesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveIpRoutesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveIpRoutesInput {
                directory_id: self.directory_id,
                cidr_ips: self.cidr_ips,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveIpRoutesInputOperationOutputAlias = crate::operation::RemoveIpRoutes;
#[doc(hidden)]
pub type RemoveIpRoutesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemoveIpRoutesInput {
    /// Consumes the builder and constructs an Operation<[`RemoveIpRoutes`](crate::operation::RemoveIpRoutes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveIpRoutes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveIpRoutesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveIpRoutesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveIpRoutesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.RemoveIpRoutes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_remove_ip_routes(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveIpRoutes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveIpRoutes",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveIpRoutesInput`](crate::input::RemoveIpRoutesInput)
    pub fn builder() -> crate::input::remove_ip_routes_input::Builder {
        crate::input::remove_ip_routes_input::Builder::default()
    }
}

/// See [`RemoveRegionInput`](crate::input::RemoveRegionInput)
pub mod remove_region_input {
    /// A builder for [`RemoveRegionInput`](crate::input::RemoveRegionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the directory for which you want to remove Region replication.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory for which you want to remove Region replication.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveRegionInput`](crate::input::RemoveRegionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveRegionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveRegionInput {
                directory_id: self.directory_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveRegionInputOperationOutputAlias = crate::operation::RemoveRegion;
#[doc(hidden)]
pub type RemoveRegionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemoveRegionInput {
    /// Consumes the builder and constructs an Operation<[`RemoveRegion`](crate::operation::RemoveRegion)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveRegion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveRegionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveRegionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveRegionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.RemoveRegion",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_remove_region(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveRegion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveRegion",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveRegionInput`](crate::input::RemoveRegionInput)
    pub fn builder() -> crate::input::remove_region_input::Builder {
        crate::input::remove_region_input::Builder::default()
    }
}

/// See [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
pub mod remove_tags_from_resource_input {
    /// A builder for [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Identifier (ID) of the directory from which to remove the tag.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>Identifier (ID) of the directory from which to remove the tag.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag key (name) of the tag to be removed.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The tag key (name) of the tag to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveTagsFromResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveTagsFromResourceInput {
                resource_id: self.resource_id,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveTagsFromResourceInputOperationOutputAlias = crate::operation::RemoveTagsFromResource;
#[doc(hidden)]
pub type RemoveTagsFromResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemoveTagsFromResourceInput {
    /// Consumes the builder and constructs an Operation<[`RemoveTagsFromResource`](crate::operation::RemoveTagsFromResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveTagsFromResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveTagsFromResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveTagsFromResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveTagsFromResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.RemoveTagsFromResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_remove_tags_from_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveTagsFromResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveTagsFromResource",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
    pub fn builder() -> crate::input::remove_tags_from_resource_input::Builder {
        crate::input::remove_tags_from_resource_input::Builder::default()
    }
}

/// See [`ResetUserPasswordInput`](crate::input::ResetUserPasswordInput)
pub mod reset_user_password_input {
    /// A builder for [`ResetUserPasswordInput`](crate::input::ResetUserPasswordInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) new_password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Identifier of the Managed Microsoft AD or Simple AD directory in which the user
        /// resides.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>Identifier of the Managed Microsoft AD or Simple AD directory in which the user
        /// resides.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The user name of the user whose password will be reset.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The user name of the user whose password will be reset.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The new password that will be reset.</p>
        pub fn new_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.new_password = Some(input.into());
            self
        }
        /// <p>The new password that will be reset.</p>
        pub fn set_new_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.new_password = input;
            self
        }
        /// Consumes the builder and constructs a [`ResetUserPasswordInput`](crate::input::ResetUserPasswordInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ResetUserPasswordInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ResetUserPasswordInput {
                directory_id: self.directory_id,
                user_name: self.user_name,
                new_password: self.new_password,
            })
        }
    }
}
#[doc(hidden)]
pub type ResetUserPasswordInputOperationOutputAlias = crate::operation::ResetUserPassword;
#[doc(hidden)]
pub type ResetUserPasswordInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ResetUserPasswordInput {
    /// Consumes the builder and constructs an Operation<[`ResetUserPassword`](crate::operation::ResetUserPassword)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ResetUserPassword,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ResetUserPasswordInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ResetUserPasswordInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ResetUserPasswordInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.ResetUserPassword",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_reset_user_password(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ResetUserPassword::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ResetUserPassword",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ResetUserPasswordInput`](crate::input::ResetUserPasswordInput)
    pub fn builder() -> crate::input::reset_user_password_input::Builder {
        crate::input::reset_user_password_input::Builder::default()
    }
}

/// See [`RestoreFromSnapshotInput`](crate::input::RestoreFromSnapshotInput)
pub mod restore_from_snapshot_input {
    /// A builder for [`RestoreFromSnapshotInput`](crate::input::RestoreFromSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the snapshot to restore from.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the snapshot to restore from.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreFromSnapshotInput`](crate::input::RestoreFromSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RestoreFromSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RestoreFromSnapshotInput {
                snapshot_id: self.snapshot_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RestoreFromSnapshotInputOperationOutputAlias = crate::operation::RestoreFromSnapshot;
#[doc(hidden)]
pub type RestoreFromSnapshotInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RestoreFromSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`RestoreFromSnapshot`](crate::operation::RestoreFromSnapshot)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RestoreFromSnapshot,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RestoreFromSnapshotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RestoreFromSnapshotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RestoreFromSnapshotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.RestoreFromSnapshot",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_restore_from_snapshot(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RestoreFromSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RestoreFromSnapshot",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RestoreFromSnapshotInput`](crate::input::RestoreFromSnapshotInput)
    pub fn builder() -> crate::input::restore_from_snapshot_input::Builder {
        crate::input::restore_from_snapshot_input::Builder::default()
    }
}

/// See [`ShareDirectoryInput`](crate::input::ShareDirectoryInput)
pub mod share_directory_input {
    /// A builder for [`ShareDirectoryInput`](crate::input::ShareDirectoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) share_notes: std::option::Option<std::string::String>,
        pub(crate) share_target: std::option::Option<crate::model::ShareTarget>,
        pub(crate) share_method: std::option::Option<crate::model::ShareMethod>,
    }
    impl Builder {
        /// <p>Identifier of the Managed Microsoft AD directory that you want to share with other Amazon Web Services accounts.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>Identifier of the Managed Microsoft AD directory that you want to share with other Amazon Web Services accounts.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>A directory share request that is sent by the directory owner to the directory consumer.
        /// The request includes a typed message to help the directory consumer administrator determine
        /// whether to approve or reject the share invitation.</p>
        pub fn share_notes(mut self, input: impl Into<std::string::String>) -> Self {
            self.share_notes = Some(input.into());
            self
        }
        /// <p>A directory share request that is sent by the directory owner to the directory consumer.
        /// The request includes a typed message to help the directory consumer administrator determine
        /// whether to approve or reject the share invitation.</p>
        pub fn set_share_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.share_notes = input;
            self
        }
        /// <p>Identifier for the directory consumer account with whom the directory is to be
        /// shared.</p>
        pub fn share_target(mut self, input: crate::model::ShareTarget) -> Self {
            self.share_target = Some(input);
            self
        }
        /// <p>Identifier for the directory consumer account with whom the directory is to be
        /// shared.</p>
        pub fn set_share_target(
            mut self,
            input: std::option::Option<crate::model::ShareTarget>,
        ) -> Self {
            self.share_target = input;
            self
        }
        /// <p>The method used when sharing a directory to determine whether the directory should be
        /// shared within your Amazon Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services account by
        /// sending a directory sharing request (<code>HANDSHAKE</code>).</p>
        pub fn share_method(mut self, input: crate::model::ShareMethod) -> Self {
            self.share_method = Some(input);
            self
        }
        /// <p>The method used when sharing a directory to determine whether the directory should be
        /// shared within your Amazon Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services account by
        /// sending a directory sharing request (<code>HANDSHAKE</code>).</p>
        pub fn set_share_method(
            mut self,
            input: std::option::Option<crate::model::ShareMethod>,
        ) -> Self {
            self.share_method = input;
            self
        }
        /// Consumes the builder and constructs a [`ShareDirectoryInput`](crate::input::ShareDirectoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ShareDirectoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ShareDirectoryInput {
                directory_id: self.directory_id,
                share_notes: self.share_notes,
                share_target: self.share_target,
                share_method: self.share_method,
            })
        }
    }
}
#[doc(hidden)]
pub type ShareDirectoryInputOperationOutputAlias = crate::operation::ShareDirectory;
#[doc(hidden)]
pub type ShareDirectoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ShareDirectoryInput {
    /// Consumes the builder and constructs an Operation<[`ShareDirectory`](crate::operation::ShareDirectory)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ShareDirectory,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ShareDirectoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ShareDirectoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ShareDirectoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.ShareDirectory",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_share_directory(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ShareDirectory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ShareDirectory",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ShareDirectoryInput`](crate::input::ShareDirectoryInput)
    pub fn builder() -> crate::input::share_directory_input::Builder {
        crate::input::share_directory_input::Builder::default()
    }
}

/// See [`StartSchemaExtensionInput`](crate::input::StartSchemaExtensionInput)
pub mod start_schema_extension_input {
    /// A builder for [`StartSchemaExtensionInput`](crate::input::StartSchemaExtensionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) create_snapshot_before_schema_extension: std::option::Option<bool>,
        pub(crate) ldif_content: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the directory for which the schema extension will be applied
        /// to.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory for which the schema extension will be applied
        /// to.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>If true, creates a snapshot of the directory before applying the schema
        /// extension.</p>
        pub fn create_snapshot_before_schema_extension(mut self, input: bool) -> Self {
            self.create_snapshot_before_schema_extension = Some(input);
            self
        }
        /// <p>If true, creates a snapshot of the directory before applying the schema
        /// extension.</p>
        pub fn set_create_snapshot_before_schema_extension(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.create_snapshot_before_schema_extension = input;
            self
        }
        /// <p>The LDIF file represented as a string. To construct the LdifContent string, precede
        /// each line as it would be formatted in an ldif file with \n. See the example request below for
        /// more details. The file size can be no larger than 1MB.</p>
        pub fn ldif_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.ldif_content = Some(input.into());
            self
        }
        /// <p>The LDIF file represented as a string. To construct the LdifContent string, precede
        /// each line as it would be formatted in an ldif file with \n. See the example request below for
        /// more details. The file size can be no larger than 1MB.</p>
        pub fn set_ldif_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ldif_content = input;
            self
        }
        /// <p>A description of the schema extension.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the schema extension.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`StartSchemaExtensionInput`](crate::input::StartSchemaExtensionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartSchemaExtensionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartSchemaExtensionInput {
                directory_id: self.directory_id,
                create_snapshot_before_schema_extension: self
                    .create_snapshot_before_schema_extension
                    .unwrap_or_default(),
                ldif_content: self.ldif_content,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type StartSchemaExtensionInputOperationOutputAlias = crate::operation::StartSchemaExtension;
#[doc(hidden)]
pub type StartSchemaExtensionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartSchemaExtensionInput {
    /// Consumes the builder and constructs an Operation<[`StartSchemaExtension`](crate::operation::StartSchemaExtension)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartSchemaExtension,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartSchemaExtensionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartSchemaExtensionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartSchemaExtensionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.StartSchemaExtension",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_schema_extension(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartSchemaExtension::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartSchemaExtension",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartSchemaExtensionInput`](crate::input::StartSchemaExtensionInput)
    pub fn builder() -> crate::input::start_schema_extension_input::Builder {
        crate::input::start_schema_extension_input::Builder::default()
    }
}

/// See [`UnshareDirectoryInput`](crate::input::UnshareDirectoryInput)
pub mod unshare_directory_input {
    /// A builder for [`UnshareDirectoryInput`](crate::input::UnshareDirectoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) unshare_target: std::option::Option<crate::model::UnshareTarget>,
    }
    impl Builder {
        /// <p>The identifier of the Managed Microsoft AD directory that you want to stop
        /// sharing.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Managed Microsoft AD directory that you want to stop
        /// sharing.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>Identifier for the directory consumer account with whom the directory has to be
        /// unshared.</p>
        pub fn unshare_target(mut self, input: crate::model::UnshareTarget) -> Self {
            self.unshare_target = Some(input);
            self
        }
        /// <p>Identifier for the directory consumer account with whom the directory has to be
        /// unshared.</p>
        pub fn set_unshare_target(
            mut self,
            input: std::option::Option<crate::model::UnshareTarget>,
        ) -> Self {
            self.unshare_target = input;
            self
        }
        /// Consumes the builder and constructs a [`UnshareDirectoryInput`](crate::input::UnshareDirectoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UnshareDirectoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UnshareDirectoryInput {
                directory_id: self.directory_id,
                unshare_target: self.unshare_target,
            })
        }
    }
}
#[doc(hidden)]
pub type UnshareDirectoryInputOperationOutputAlias = crate::operation::UnshareDirectory;
#[doc(hidden)]
pub type UnshareDirectoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UnshareDirectoryInput {
    /// Consumes the builder and constructs an Operation<[`UnshareDirectory`](crate::operation::UnshareDirectory)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UnshareDirectory,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UnshareDirectoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UnshareDirectoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UnshareDirectoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.UnshareDirectory",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_unshare_directory(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UnshareDirectory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UnshareDirectory",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UnshareDirectoryInput`](crate::input::UnshareDirectoryInput)
    pub fn builder() -> crate::input::unshare_directory_input::Builder {
        crate::input::unshare_directory_input::Builder::default()
    }
}

/// See [`UpdateConditionalForwarderInput`](crate::input::UpdateConditionalForwarderInput)
pub mod update_conditional_forwarder_input {
    /// A builder for [`UpdateConditionalForwarderInput`](crate::input::UpdateConditionalForwarderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) remote_domain_name: std::option::Option<std::string::String>,
        pub(crate) dns_ip_addrs: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The directory ID of the Amazon Web Services directory for which to update the conditional
        /// forwarder.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The directory ID of the Amazon Web Services directory for which to update the conditional
        /// forwarder.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The fully qualified domain name (FQDN) of the remote domain with which you will set up
        /// a trust relationship.</p>
        pub fn remote_domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.remote_domain_name = Some(input.into());
            self
        }
        /// <p>The fully qualified domain name (FQDN) of the remote domain with which you will set up
        /// a trust relationship.</p>
        pub fn set_remote_domain_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.remote_domain_name = input;
            self
        }
        /// Appends an item to `dns_ip_addrs`.
        ///
        /// To override the contents of this collection use [`set_dns_ip_addrs`](Self::set_dns_ip_addrs).
        ///
        /// <p>The updated IP addresses of the remote DNS server associated with the conditional
        /// forwarder.</p>
        pub fn dns_ip_addrs(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.dns_ip_addrs.unwrap_or_default();
            v.push(input.into());
            self.dns_ip_addrs = Some(v);
            self
        }
        /// <p>The updated IP addresses of the remote DNS server associated with the conditional
        /// forwarder.</p>
        pub fn set_dns_ip_addrs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.dns_ip_addrs = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConditionalForwarderInput`](crate::input::UpdateConditionalForwarderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateConditionalForwarderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateConditionalForwarderInput {
                directory_id: self.directory_id,
                remote_domain_name: self.remote_domain_name,
                dns_ip_addrs: self.dns_ip_addrs,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateConditionalForwarderInputOperationOutputAlias =
    crate::operation::UpdateConditionalForwarder;
#[doc(hidden)]
pub type UpdateConditionalForwarderInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateConditionalForwarderInput {
    /// Consumes the builder and constructs an Operation<[`UpdateConditionalForwarder`](crate::operation::UpdateConditionalForwarder)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateConditionalForwarder,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateConditionalForwarderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateConditionalForwarderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateConditionalForwarderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.UpdateConditionalForwarder",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_conditional_forwarder(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateConditionalForwarder::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateConditionalForwarder",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateConditionalForwarderInput`](crate::input::UpdateConditionalForwarderInput)
    pub fn builder() -> crate::input::update_conditional_forwarder_input::Builder {
        crate::input::update_conditional_forwarder_input::Builder::default()
    }
}

/// See [`UpdateNumberOfDomainControllersInput`](crate::input::UpdateNumberOfDomainControllersInput)
pub mod update_number_of_domain_controllers_input {
    /// A builder for [`UpdateNumberOfDomainControllersInput`](crate::input::UpdateNumberOfDomainControllersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) desired_number: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Identifier of the directory to which the domain controllers will be added or
        /// removed.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>Identifier of the directory to which the domain controllers will be added or
        /// removed.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The number of domain controllers desired in the directory.</p>
        pub fn desired_number(mut self, input: i32) -> Self {
            self.desired_number = Some(input);
            self
        }
        /// <p>The number of domain controllers desired in the directory.</p>
        pub fn set_desired_number(mut self, input: std::option::Option<i32>) -> Self {
            self.desired_number = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateNumberOfDomainControllersInput`](crate::input::UpdateNumberOfDomainControllersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateNumberOfDomainControllersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateNumberOfDomainControllersInput {
                directory_id: self.directory_id,
                desired_number: self.desired_number.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateNumberOfDomainControllersInputOperationOutputAlias =
    crate::operation::UpdateNumberOfDomainControllers;
#[doc(hidden)]
pub type UpdateNumberOfDomainControllersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateNumberOfDomainControllersInput {
    /// Consumes the builder and constructs an Operation<[`UpdateNumberOfDomainControllers`](crate::operation::UpdateNumberOfDomainControllers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateNumberOfDomainControllers,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateNumberOfDomainControllersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateNumberOfDomainControllersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateNumberOfDomainControllersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.UpdateNumberOfDomainControllers",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_number_of_domain_controllers(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateNumberOfDomainControllers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateNumberOfDomainControllers",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateNumberOfDomainControllersInput`](crate::input::UpdateNumberOfDomainControllersInput)
    pub fn builder() -> crate::input::update_number_of_domain_controllers_input::Builder {
        crate::input::update_number_of_domain_controllers_input::Builder::default()
    }
}

/// See [`UpdateRadiusInput`](crate::input::UpdateRadiusInput)
pub mod update_radius_input {
    /// A builder for [`UpdateRadiusInput`](crate::input::UpdateRadiusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) radius_settings: std::option::Option<crate::model::RadiusSettings>,
    }
    impl Builder {
        /// <p>The identifier of the directory for which to update the RADIUS server
        /// information.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory for which to update the RADIUS server
        /// information.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>A <a>RadiusSettings</a> object that contains information about the RADIUS
        /// server.</p>
        pub fn radius_settings(mut self, input: crate::model::RadiusSettings) -> Self {
            self.radius_settings = Some(input);
            self
        }
        /// <p>A <a>RadiusSettings</a> object that contains information about the RADIUS
        /// server.</p>
        pub fn set_radius_settings(
            mut self,
            input: std::option::Option<crate::model::RadiusSettings>,
        ) -> Self {
            self.radius_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRadiusInput`](crate::input::UpdateRadiusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateRadiusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateRadiusInput {
                directory_id: self.directory_id,
                radius_settings: self.radius_settings,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateRadiusInputOperationOutputAlias = crate::operation::UpdateRadius;
#[doc(hidden)]
pub type UpdateRadiusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateRadiusInput {
    /// Consumes the builder and constructs an Operation<[`UpdateRadius`](crate::operation::UpdateRadius)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateRadius,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateRadiusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateRadiusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateRadiusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.UpdateRadius",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_radius(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateRadius::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateRadius",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateRadiusInput`](crate::input::UpdateRadiusInput)
    pub fn builder() -> crate::input::update_radius_input::Builder {
        crate::input::update_radius_input::Builder::default()
    }
}

/// See [`UpdateTrustInput`](crate::input::UpdateTrustInput)
pub mod update_trust_input {
    /// A builder for [`UpdateTrustInput`](crate::input::UpdateTrustInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trust_id: std::option::Option<std::string::String>,
        pub(crate) selective_auth: std::option::Option<crate::model::SelectiveAuth>,
    }
    impl Builder {
        /// <p>Identifier of the trust relationship.</p>
        pub fn trust_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.trust_id = Some(input.into());
            self
        }
        /// <p>Identifier of the trust relationship.</p>
        pub fn set_trust_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trust_id = input;
            self
        }
        /// <p>Updates selective authentication for the trust.</p>
        pub fn selective_auth(mut self, input: crate::model::SelectiveAuth) -> Self {
            self.selective_auth = Some(input);
            self
        }
        /// <p>Updates selective authentication for the trust.</p>
        pub fn set_selective_auth(
            mut self,
            input: std::option::Option<crate::model::SelectiveAuth>,
        ) -> Self {
            self.selective_auth = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTrustInput`](crate::input::UpdateTrustInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateTrustInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateTrustInput {
                trust_id: self.trust_id,
                selective_auth: self.selective_auth,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateTrustInputOperationOutputAlias = crate::operation::UpdateTrust;
#[doc(hidden)]
pub type UpdateTrustInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateTrustInput {
    /// Consumes the builder and constructs an Operation<[`UpdateTrust`](crate::operation::UpdateTrust)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateTrust,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateTrustInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateTrustInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateTrustInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.UpdateTrust",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_trust(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateTrust::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateTrust",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateTrustInput`](crate::input::UpdateTrustInput)
    pub fn builder() -> crate::input::update_trust_input::Builder {
        crate::input::update_trust_input::Builder::default()
    }
}

/// See [`VerifyTrustInput`](crate::input::VerifyTrustInput)
pub mod verify_trust_input {
    /// A builder for [`VerifyTrustInput`](crate::input::VerifyTrustInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trust_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique Trust ID of the trust relationship to verify.</p>
        pub fn trust_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.trust_id = Some(input.into());
            self
        }
        /// <p>The unique Trust ID of the trust relationship to verify.</p>
        pub fn set_trust_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trust_id = input;
            self
        }
        /// Consumes the builder and constructs a [`VerifyTrustInput`](crate::input::VerifyTrustInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::VerifyTrustInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::VerifyTrustInput {
                trust_id: self.trust_id,
            })
        }
    }
}
#[doc(hidden)]
pub type VerifyTrustInputOperationOutputAlias = crate::operation::VerifyTrust;
#[doc(hidden)]
pub type VerifyTrustInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl VerifyTrustInput {
    /// Consumes the builder and constructs an Operation<[`VerifyTrust`](crate::operation::VerifyTrust)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::VerifyTrust,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::VerifyTrustInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::VerifyTrustInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::VerifyTrustInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DirectoryService_20150416.VerifyTrust",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_verify_trust(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::VerifyTrust::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "VerifyTrust",
            "directoryservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`VerifyTrustInput`](crate::input::VerifyTrustInput)
    pub fn builder() -> crate::input::verify_trust_input::Builder {
        crate::input::verify_trust_input::Builder::default()
    }
}

/// <p>Initiates the verification of an existing trust relationship between an Managed Microsoft AD
/// directory and an external domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VerifyTrustInput {
    /// <p>The unique Trust ID of the trust relationship to verify.</p>
    pub trust_id: std::option::Option<std::string::String>,
}
impl VerifyTrustInput {
    /// <p>The unique Trust ID of the trust relationship to verify.</p>
    pub fn trust_id(&self) -> std::option::Option<&str> {
        self.trust_id.as_deref()
    }
}
impl std::fmt::Debug for VerifyTrustInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VerifyTrustInput");
        formatter.field("trust_id", &self.trust_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTrustInput {
    /// <p>Identifier of the trust relationship.</p>
    pub trust_id: std::option::Option<std::string::String>,
    /// <p>Updates selective authentication for the trust.</p>
    pub selective_auth: std::option::Option<crate::model::SelectiveAuth>,
}
impl UpdateTrustInput {
    /// <p>Identifier of the trust relationship.</p>
    pub fn trust_id(&self) -> std::option::Option<&str> {
        self.trust_id.as_deref()
    }
    /// <p>Updates selective authentication for the trust.</p>
    pub fn selective_auth(&self) -> std::option::Option<&crate::model::SelectiveAuth> {
        self.selective_auth.as_ref()
    }
}
impl std::fmt::Debug for UpdateTrustInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTrustInput");
        formatter.field("trust_id", &self.trust_id);
        formatter.field("selective_auth", &self.selective_auth);
        formatter.finish()
    }
}

/// <p>Contains the inputs for the <a>UpdateRadius</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRadiusInput {
    /// <p>The identifier of the directory for which to update the RADIUS server
    /// information.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>A <a>RadiusSettings</a> object that contains information about the RADIUS
    /// server.</p>
    pub radius_settings: std::option::Option<crate::model::RadiusSettings>,
}
impl UpdateRadiusInput {
    /// <p>The identifier of the directory for which to update the RADIUS server
    /// information.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>A <a>RadiusSettings</a> object that contains information about the RADIUS
    /// server.</p>
    pub fn radius_settings(&self) -> std::option::Option<&crate::model::RadiusSettings> {
        self.radius_settings.as_ref()
    }
}
impl std::fmt::Debug for UpdateRadiusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRadiusInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("radius_settings", &self.radius_settings);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateNumberOfDomainControllersInput {
    /// <p>Identifier of the directory to which the domain controllers will be added or
    /// removed.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The number of domain controllers desired in the directory.</p>
    pub desired_number: i32,
}
impl UpdateNumberOfDomainControllersInput {
    /// <p>Identifier of the directory to which the domain controllers will be added or
    /// removed.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The number of domain controllers desired in the directory.</p>
    pub fn desired_number(&self) -> i32 {
        self.desired_number
    }
}
impl std::fmt::Debug for UpdateNumberOfDomainControllersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateNumberOfDomainControllersInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("desired_number", &self.desired_number);
        formatter.finish()
    }
}

/// <p>Updates a conditional forwarder.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConditionalForwarderInput {
    /// <p>The directory ID of the Amazon Web Services directory for which to update the conditional
    /// forwarder.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The fully qualified domain name (FQDN) of the remote domain with which you will set up
    /// a trust relationship.</p>
    pub remote_domain_name: std::option::Option<std::string::String>,
    /// <p>The updated IP addresses of the remote DNS server associated with the conditional
    /// forwarder.</p>
    pub dns_ip_addrs: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UpdateConditionalForwarderInput {
    /// <p>The directory ID of the Amazon Web Services directory for which to update the conditional
    /// forwarder.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The fully qualified domain name (FQDN) of the remote domain with which you will set up
    /// a trust relationship.</p>
    pub fn remote_domain_name(&self) -> std::option::Option<&str> {
        self.remote_domain_name.as_deref()
    }
    /// <p>The updated IP addresses of the remote DNS server associated with the conditional
    /// forwarder.</p>
    pub fn dns_ip_addrs(&self) -> std::option::Option<&[std::string::String]> {
        self.dns_ip_addrs.as_deref()
    }
}
impl std::fmt::Debug for UpdateConditionalForwarderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConditionalForwarderInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("remote_domain_name", &self.remote_domain_name);
        formatter.field("dns_ip_addrs", &self.dns_ip_addrs);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnshareDirectoryInput {
    /// <p>The identifier of the Managed Microsoft AD directory that you want to stop
    /// sharing.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>Identifier for the directory consumer account with whom the directory has to be
    /// unshared.</p>
    pub unshare_target: std::option::Option<crate::model::UnshareTarget>,
}
impl UnshareDirectoryInput {
    /// <p>The identifier of the Managed Microsoft AD directory that you want to stop
    /// sharing.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>Identifier for the directory consumer account with whom the directory has to be
    /// unshared.</p>
    pub fn unshare_target(&self) -> std::option::Option<&crate::model::UnshareTarget> {
        self.unshare_target.as_ref()
    }
}
impl std::fmt::Debug for UnshareDirectoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnshareDirectoryInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("unshare_target", &self.unshare_target);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartSchemaExtensionInput {
    /// <p>The identifier of the directory for which the schema extension will be applied
    /// to.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>If true, creates a snapshot of the directory before applying the schema
    /// extension.</p>
    pub create_snapshot_before_schema_extension: bool,
    /// <p>The LDIF file represented as a string. To construct the LdifContent string, precede
    /// each line as it would be formatted in an ldif file with \n. See the example request below for
    /// more details. The file size can be no larger than 1MB.</p>
    pub ldif_content: std::option::Option<std::string::String>,
    /// <p>A description of the schema extension.</p>
    pub description: std::option::Option<std::string::String>,
}
impl StartSchemaExtensionInput {
    /// <p>The identifier of the directory for which the schema extension will be applied
    /// to.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>If true, creates a snapshot of the directory before applying the schema
    /// extension.</p>
    pub fn create_snapshot_before_schema_extension(&self) -> bool {
        self.create_snapshot_before_schema_extension
    }
    /// <p>The LDIF file represented as a string. To construct the LdifContent string, precede
    /// each line as it would be formatted in an ldif file with \n. See the example request below for
    /// more details. The file size can be no larger than 1MB.</p>
    pub fn ldif_content(&self) -> std::option::Option<&str> {
        self.ldif_content.as_deref()
    }
    /// <p>A description of the schema extension.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for StartSchemaExtensionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartSchemaExtensionInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field(
            "create_snapshot_before_schema_extension",
            &self.create_snapshot_before_schema_extension,
        );
        formatter.field("ldif_content", &self.ldif_content);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ShareDirectoryInput {
    /// <p>Identifier of the Managed Microsoft AD directory that you want to share with other Amazon Web Services accounts.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>A directory share request that is sent by the directory owner to the directory consumer.
    /// The request includes a typed message to help the directory consumer administrator determine
    /// whether to approve or reject the share invitation.</p>
    pub share_notes: std::option::Option<std::string::String>,
    /// <p>Identifier for the directory consumer account with whom the directory is to be
    /// shared.</p>
    pub share_target: std::option::Option<crate::model::ShareTarget>,
    /// <p>The method used when sharing a directory to determine whether the directory should be
    /// shared within your Amazon Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services account by
    /// sending a directory sharing request (<code>HANDSHAKE</code>).</p>
    pub share_method: std::option::Option<crate::model::ShareMethod>,
}
impl ShareDirectoryInput {
    /// <p>Identifier of the Managed Microsoft AD directory that you want to share with other Amazon Web Services accounts.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>A directory share request that is sent by the directory owner to the directory consumer.
    /// The request includes a typed message to help the directory consumer administrator determine
    /// whether to approve or reject the share invitation.</p>
    pub fn share_notes(&self) -> std::option::Option<&str> {
        self.share_notes.as_deref()
    }
    /// <p>Identifier for the directory consumer account with whom the directory is to be
    /// shared.</p>
    pub fn share_target(&self) -> std::option::Option<&crate::model::ShareTarget> {
        self.share_target.as_ref()
    }
    /// <p>The method used when sharing a directory to determine whether the directory should be
    /// shared within your Amazon Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services account by
    /// sending a directory sharing request (<code>HANDSHAKE</code>).</p>
    pub fn share_method(&self) -> std::option::Option<&crate::model::ShareMethod> {
        self.share_method.as_ref()
    }
}
impl std::fmt::Debug for ShareDirectoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ShareDirectoryInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("share_notes", &"*** Sensitive Data Redacted ***");
        formatter.field("share_target", &self.share_target);
        formatter.field("share_method", &self.share_method);
        formatter.finish()
    }
}

/// <p>An object representing the inputs for the <a>RestoreFromSnapshot</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreFromSnapshotInput {
    /// <p>The identifier of the snapshot to restore from.</p>
    pub snapshot_id: std::option::Option<std::string::String>,
}
impl RestoreFromSnapshotInput {
    /// <p>The identifier of the snapshot to restore from.</p>
    pub fn snapshot_id(&self) -> std::option::Option<&str> {
        self.snapshot_id.as_deref()
    }
}
impl std::fmt::Debug for RestoreFromSnapshotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreFromSnapshotInput");
        formatter.field("snapshot_id", &self.snapshot_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResetUserPasswordInput {
    /// <p>Identifier of the Managed Microsoft AD or Simple AD directory in which the user
    /// resides.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The user name of the user whose password will be reset.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The new password that will be reset.</p>
    pub new_password: std::option::Option<std::string::String>,
}
impl ResetUserPasswordInput {
    /// <p>Identifier of the Managed Microsoft AD or Simple AD directory in which the user
    /// resides.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The user name of the user whose password will be reset.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The new password that will be reset.</p>
    pub fn new_password(&self) -> std::option::Option<&str> {
        self.new_password.as_deref()
    }
}
impl std::fmt::Debug for ResetUserPasswordInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResetUserPasswordInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("user_name", &self.user_name);
        formatter.field("new_password", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTagsFromResourceInput {
    /// <p>Identifier (ID) of the directory from which to remove the tag.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The tag key (name) of the tag to be removed.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl RemoveTagsFromResourceInput {
    /// <p>Identifier (ID) of the directory from which to remove the tag.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The tag key (name) of the tag to be removed.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for RemoveTagsFromResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTagsFromResourceInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveRegionInput {
    /// <p>The identifier of the directory for which you want to remove Region replication.</p>
    pub directory_id: std::option::Option<std::string::String>,
}
impl RemoveRegionInput {
    /// <p>The identifier of the directory for which you want to remove Region replication.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
}
impl std::fmt::Debug for RemoveRegionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveRegionInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveIpRoutesInput {
    /// <p>Identifier (ID) of the directory from which you want to remove the IP
    /// addresses.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>IP address blocks that you want to remove.</p>
    pub cidr_ips: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl RemoveIpRoutesInput {
    /// <p>Identifier (ID) of the directory from which you want to remove the IP
    /// addresses.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>IP address blocks that you want to remove.</p>
    pub fn cidr_ips(&self) -> std::option::Option<&[std::string::String]> {
        self.cidr_ips.as_deref()
    }
}
impl std::fmt::Debug for RemoveIpRoutesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveIpRoutesInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("cidr_ips", &self.cidr_ips);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RejectSharedDirectoryInput {
    /// <p>Identifier of the shared directory in the directory consumer account. This identifier is
    /// different for each directory owner account.</p>
    pub shared_directory_id: std::option::Option<std::string::String>,
}
impl RejectSharedDirectoryInput {
    /// <p>Identifier of the shared directory in the directory consumer account. This identifier is
    /// different for each directory owner account.</p>
    pub fn shared_directory_id(&self) -> std::option::Option<&str> {
        self.shared_directory_id.as_deref()
    }
}
impl std::fmt::Debug for RejectSharedDirectoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RejectSharedDirectoryInput");
        formatter.field("shared_directory_id", &self.shared_directory_id);
        formatter.finish()
    }
}

/// <p>Registers a new event topic.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterEventTopicInput {
    /// <p>The Directory ID that will publish status messages to the Amazon SNS topic.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The Amazon SNS topic name to which the directory will publish status messages. This Amazon SNS
    /// topic must be in the same region as the specified Directory ID.</p>
    pub topic_name: std::option::Option<std::string::String>,
}
impl RegisterEventTopicInput {
    /// <p>The Directory ID that will publish status messages to the Amazon SNS topic.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The Amazon SNS topic name to which the directory will publish status messages. This Amazon SNS
    /// topic must be in the same region as the specified Directory ID.</p>
    pub fn topic_name(&self) -> std::option::Option<&str> {
        self.topic_name.as_deref()
    }
}
impl std::fmt::Debug for RegisterEventTopicInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterEventTopicInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("topic_name", &self.topic_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterCertificateInput {
    /// <p>The identifier of the directory.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The certificate PEM string that needs to be registered.</p>
    pub certificate_data: std::option::Option<std::string::String>,
    /// <p>The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.</p>
    pub r#type: std::option::Option<crate::model::CertificateType>,
    /// <p>A <code>ClientCertAuthSettings</code> object that contains client certificate authentication settings.</p>
    pub client_cert_auth_settings: std::option::Option<crate::model::ClientCertAuthSettings>,
}
impl RegisterCertificateInput {
    /// <p>The identifier of the directory.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The certificate PEM string that needs to be registered.</p>
    pub fn certificate_data(&self) -> std::option::Option<&str> {
        self.certificate_data.as_deref()
    }
    /// <p>The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::CertificateType> {
        self.r#type.as_ref()
    }
    /// <p>A <code>ClientCertAuthSettings</code> object that contains client certificate authentication settings.</p>
    pub fn client_cert_auth_settings(
        &self,
    ) -> std::option::Option<&crate::model::ClientCertAuthSettings> {
        self.client_cert_auth_settings.as_ref()
    }
}
impl std::fmt::Debug for RegisterCertificateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterCertificateInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("certificate_data", &self.certificate_data);
        formatter.field("r#type", &self.r#type);
        formatter.field("client_cert_auth_settings", &self.client_cert_auth_settings);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>Identifier (ID) of the directory for which you want to retrieve tags.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>Reserved for future use.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Reserved for future use.</p>
    pub limit: std::option::Option<i32>,
}
impl ListTagsForResourceInput {
    /// <p>Identifier (ID) of the directory for which you want to retrieve tags.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>Reserved for future use.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Reserved for future use.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSchemaExtensionsInput {
    /// <p>The identifier of the directory from which to retrieve the schema extension
    /// information.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The <code>ListSchemaExtensions.NextToken</code> value from a previous call to
    /// <code>ListSchemaExtensions</code>. Pass null if this is the first call.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return.</p>
    pub limit: std::option::Option<i32>,
}
impl ListSchemaExtensionsInput {
    /// <p>The identifier of the directory from which to retrieve the schema extension
    /// information.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The <code>ListSchemaExtensions.NextToken</code> value from a previous call to
    /// <code>ListSchemaExtensions</code>. Pass null if this is the first call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to return.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for ListSchemaExtensionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSchemaExtensionsInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLogSubscriptionsInput {
    /// <p>If a <i>DirectoryID</i> is provided, lists only the log subscription
    /// associated with that directory. If no <i>DirectoryId</i> is provided, lists all
    /// log subscriptions associated with your Amazon Web Services account. If there are no log subscriptions for the
    /// Amazon Web Services account or the directory, an empty list will be returned.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The token for the next set of items to return.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items returned.</p>
    pub limit: std::option::Option<i32>,
}
impl ListLogSubscriptionsInput {
    /// <p>If a <i>DirectoryID</i> is provided, lists only the log subscription
    /// associated with that directory. If no <i>DirectoryId</i> is provided, lists all
    /// log subscriptions associated with your Amazon Web Services account. If there are no log subscriptions for the
    /// Amazon Web Services account or the directory, an empty list will be returned.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The token for the next set of items to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items returned.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for ListLogSubscriptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLogSubscriptionsInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListIpRoutesInput {
    /// <p>Identifier (ID) of the directory for which you want to retrieve the IP
    /// addresses.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The <i>ListIpRoutes.NextToken</i> value from a previous call to <a>ListIpRoutes</a>. Pass null if this is the first call.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Maximum number of items to return. If this value is zero, the maximum number of items
    /// is specified by the limitations of the operation.</p>
    pub limit: std::option::Option<i32>,
}
impl ListIpRoutesInput {
    /// <p>Identifier (ID) of the directory for which you want to retrieve the IP
    /// addresses.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The <i>ListIpRoutes.NextToken</i> value from a previous call to <a>ListIpRoutes</a>. Pass null if this is the first call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Maximum number of items to return. If this value is zero, the maximum number of items
    /// is specified by the limitations of the operation.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for ListIpRoutesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListIpRoutesInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCertificatesInput {
    /// <p>The identifier of the directory.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>A token for requesting another page of certificates if the <code>NextToken</code> response
    /// element indicates that more certificates are available. Use the value of the returned
    /// <code>NextToken</code> element in your request until the token comes back as
    /// <code>null</code>. Pass <code>null</code> if this is the first call.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The number of items that should show up on one page</p>
    pub limit: std::option::Option<i32>,
}
impl ListCertificatesInput {
    /// <p>The identifier of the directory.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>A token for requesting another page of certificates if the <code>NextToken</code> response
    /// element indicates that more certificates are available. Use the value of the returned
    /// <code>NextToken</code> element in your request until the token comes back as
    /// <code>null</code>. Pass <code>null</code> if this is the first call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The number of items that should show up on one page</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for ListCertificatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCertificatesInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

/// <p>Contains the inputs for the <a>GetSnapshotLimits</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSnapshotLimitsInput {
    /// <p>Contains the identifier of the directory to obtain the limits for.</p>
    pub directory_id: std::option::Option<std::string::String>,
}
impl GetSnapshotLimitsInput {
    /// <p>Contains the identifier of the directory to obtain the limits for.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
}
impl std::fmt::Debug for GetSnapshotLimitsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSnapshotLimitsInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.finish()
    }
}

/// <p>Contains the inputs for the <a>GetDirectoryLimits</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDirectoryLimitsInput {}
impl std::fmt::Debug for GetDirectoryLimitsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDirectoryLimitsInput");
        formatter.finish()
    }
}

/// <p>Contains the inputs for the <a>EnableSso</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableSsoInput {
    /// <p>The identifier of the directory for which to enable single-sign on.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The username of an alternate account to use to enable single-sign on. This is only used
    /// for AD Connector directories. This account must have privileges to add a service principal
    /// name.</p>
    /// <p>If the AD Connector service account does not have privileges to add a service principal
    /// name, you can specify an alternate account with the <i>UserName</i> and
    /// <i>Password</i> parameters. These credentials are only used to enable single
    /// sign-on and are not stored by the service. The AD Connector service account is not
    /// changed.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The password of an alternate account to use to enable single-sign on. This is only used
    /// for AD Connector directories. For more information, see the <i>UserName</i>
    /// parameter.</p>
    pub password: std::option::Option<std::string::String>,
}
impl EnableSsoInput {
    /// <p>The identifier of the directory for which to enable single-sign on.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The username of an alternate account to use to enable single-sign on. This is only used
    /// for AD Connector directories. This account must have privileges to add a service principal
    /// name.</p>
    /// <p>If the AD Connector service account does not have privileges to add a service principal
    /// name, you can specify an alternate account with the <i>UserName</i> and
    /// <i>Password</i> parameters. These credentials are only used to enable single
    /// sign-on and are not stored by the service. The AD Connector service account is not
    /// changed.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The password of an alternate account to use to enable single-sign on. This is only used
    /// for AD Connector directories. For more information, see the <i>UserName</i>
    /// parameter.</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
}
impl std::fmt::Debug for EnableSsoInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableSsoInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("user_name", &self.user_name);
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

/// <p>Contains the inputs for the <a>EnableRadius</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableRadiusInput {
    /// <p>The identifier of the directory for which to enable MFA.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>A <a>RadiusSettings</a> object that contains information about the RADIUS
    /// server.</p>
    pub radius_settings: std::option::Option<crate::model::RadiusSettings>,
}
impl EnableRadiusInput {
    /// <p>The identifier of the directory for which to enable MFA.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>A <a>RadiusSettings</a> object that contains information about the RADIUS
    /// server.</p>
    pub fn radius_settings(&self) -> std::option::Option<&crate::model::RadiusSettings> {
        self.radius_settings.as_ref()
    }
}
impl std::fmt::Debug for EnableRadiusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableRadiusInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("radius_settings", &self.radius_settings);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableLdapsInput {
    /// <p>The identifier of the directory.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The type of LDAP security to enable. Currently only the value <code>Client</code> is
    /// supported.</p>
    pub r#type: std::option::Option<crate::model::LdapsType>,
}
impl EnableLdapsInput {
    /// <p>The identifier of the directory.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The type of LDAP security to enable. Currently only the value <code>Client</code> is
    /// supported.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::LdapsType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for EnableLdapsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableLdapsInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableClientAuthenticationInput {
    /// <p>The identifier of the specified directory. </p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The type of client authentication to enable. Currently only the value <code>SmartCard</code> is
    /// supported. Smart card authentication in AD Connector requires that you enable Kerberos
    /// Constrained Delegation for the Service User to the LDAP service in your self-managed AD.
    /// </p>
    pub r#type: std::option::Option<crate::model::ClientAuthenticationType>,
}
impl EnableClientAuthenticationInput {
    /// <p>The identifier of the specified directory. </p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The type of client authentication to enable. Currently only the value <code>SmartCard</code> is
    /// supported. Smart card authentication in AD Connector requires that you enable Kerberos
    /// Constrained Delegation for the Service User to the LDAP service in your self-managed AD.
    /// </p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ClientAuthenticationType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for EnableClientAuthenticationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableClientAuthenticationInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}

/// <p>Contains the inputs for the <a>DisableSso</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableSsoInput {
    /// <p>The identifier of the directory for which to disable single-sign on.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The username of an alternate account to use to disable single-sign on. This is only used
    /// for AD Connector directories. This account must have privileges to remove a service
    /// principal name.</p>
    /// <p>If the AD Connector service account does not have privileges to remove a service
    /// principal name, you can specify an alternate account with the <i>UserName</i>
    /// and <i>Password</i> parameters. These credentials are only used to disable
    /// single sign-on and are not stored by the service. The AD Connector service account is not
    /// changed.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The password of an alternate account to use to disable single-sign on. This is only used
    /// for AD Connector directories. For more information, see the <i>UserName</i>
    /// parameter.</p>
    pub password: std::option::Option<std::string::String>,
}
impl DisableSsoInput {
    /// <p>The identifier of the directory for which to disable single-sign on.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The username of an alternate account to use to disable single-sign on. This is only used
    /// for AD Connector directories. This account must have privileges to remove a service
    /// principal name.</p>
    /// <p>If the AD Connector service account does not have privileges to remove a service
    /// principal name, you can specify an alternate account with the <i>UserName</i>
    /// and <i>Password</i> parameters. These credentials are only used to disable
    /// single sign-on and are not stored by the service. The AD Connector service account is not
    /// changed.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The password of an alternate account to use to disable single-sign on. This is only used
    /// for AD Connector directories. For more information, see the <i>UserName</i>
    /// parameter.</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
}
impl std::fmt::Debug for DisableSsoInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableSsoInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("user_name", &self.user_name);
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

/// <p>Contains the inputs for the <a>DisableRadius</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableRadiusInput {
    /// <p>The identifier of the directory for which to disable MFA.</p>
    pub directory_id: std::option::Option<std::string::String>,
}
impl DisableRadiusInput {
    /// <p>The identifier of the directory for which to disable MFA.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
}
impl std::fmt::Debug for DisableRadiusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableRadiusInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableLdapsInput {
    /// <p>The identifier of the directory.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The type of LDAP security to enable. Currently only the value <code>Client</code> is
    /// supported.</p>
    pub r#type: std::option::Option<crate::model::LdapsType>,
}
impl DisableLdapsInput {
    /// <p>The identifier of the directory.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The type of LDAP security to enable. Currently only the value <code>Client</code> is
    /// supported.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::LdapsType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for DisableLdapsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableLdapsInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableClientAuthenticationInput {
    /// <p>The identifier of the directory </p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The type of client authentication to disable. Currently, only the parameter, <code>SmartCard</code> is supported.</p>
    pub r#type: std::option::Option<crate::model::ClientAuthenticationType>,
}
impl DisableClientAuthenticationInput {
    /// <p>The identifier of the directory </p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The type of client authentication to disable. Currently, only the parameter, <code>SmartCard</code> is supported.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ClientAuthenticationType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for DisableClientAuthenticationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableClientAuthenticationInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}

/// <p>Describes the trust relationships for a particular Managed Microsoft AD directory. If no input
/// parameters are provided, such as directory ID or trust ID, this request describes all the
/// trust relationships.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTrustsInput {
    /// <p>The Directory ID of the Amazon Web Services directory that is a part of the requested trust
    /// relationship.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>A list of identifiers of the trust relationships for which to obtain the information. If
    /// this member is null, all trust relationships that belong to the current account are
    /// returned.</p>
    /// <p>An empty list results in an <code>InvalidParameterException</code> being thrown.</p>
    pub trust_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The <i>DescribeTrustsResult.NextToken</i> value from a previous call to
    /// <a>DescribeTrusts</a>. Pass null if this is the first call.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of objects to return.</p>
    pub limit: std::option::Option<i32>,
}
impl DescribeTrustsInput {
    /// <p>The Directory ID of the Amazon Web Services directory that is a part of the requested trust
    /// relationship.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>A list of identifiers of the trust relationships for which to obtain the information. If
    /// this member is null, all trust relationships that belong to the current account are
    /// returned.</p>
    /// <p>An empty list results in an <code>InvalidParameterException</code> being thrown.</p>
    pub fn trust_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.trust_ids.as_deref()
    }
    /// <p>The <i>DescribeTrustsResult.NextToken</i> value from a previous call to
    /// <a>DescribeTrusts</a>. Pass null if this is the first call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of objects to return.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for DescribeTrustsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTrustsInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("trust_ids", &self.trust_ids);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

/// <p>Contains the inputs for the <a>DescribeSnapshots</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSnapshotsInput {
    /// <p>The identifier of the directory for which to retrieve snapshot information.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>A list of identifiers of the snapshots to obtain the information for. If this member is
    /// null or empty, all snapshots are returned using the <i>Limit</i> and <i>NextToken</i>
    /// members.</p>
    pub snapshot_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The <i>DescribeSnapshotsResult.NextToken</i> value from a previous call to
    /// <a>DescribeSnapshots</a>. Pass null if this is the first call.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of objects to return.</p>
    pub limit: std::option::Option<i32>,
}
impl DescribeSnapshotsInput {
    /// <p>The identifier of the directory for which to retrieve snapshot information.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>A list of identifiers of the snapshots to obtain the information for. If this member is
    /// null or empty, all snapshots are returned using the <i>Limit</i> and <i>NextToken</i>
    /// members.</p>
    pub fn snapshot_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.snapshot_ids.as_deref()
    }
    /// <p>The <i>DescribeSnapshotsResult.NextToken</i> value from a previous call to
    /// <a>DescribeSnapshots</a>. Pass null if this is the first call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of objects to return.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for DescribeSnapshotsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSnapshotsInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("snapshot_ids", &self.snapshot_ids);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSharedDirectoriesInput {
    /// <p>Returns the identifier of the directory in the directory owner account. </p>
    pub owner_directory_id: std::option::Option<std::string::String>,
    /// <p>A list of identifiers of all shared directories in your account. </p>
    pub shared_directory_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The <code>DescribeSharedDirectoriesResult.NextToken</code> value from a previous call to
    /// <a>DescribeSharedDirectories</a>. Pass null if this is the first call. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The number of shared directories to return in the response object.</p>
    pub limit: std::option::Option<i32>,
}
impl DescribeSharedDirectoriesInput {
    /// <p>Returns the identifier of the directory in the directory owner account. </p>
    pub fn owner_directory_id(&self) -> std::option::Option<&str> {
        self.owner_directory_id.as_deref()
    }
    /// <p>A list of identifiers of all shared directories in your account. </p>
    pub fn shared_directory_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.shared_directory_ids.as_deref()
    }
    /// <p>The <code>DescribeSharedDirectoriesResult.NextToken</code> value from a previous call to
    /// <a>DescribeSharedDirectories</a>. Pass null if this is the first call. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The number of shared directories to return in the response object.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for DescribeSharedDirectoriesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSharedDirectoriesInput");
        formatter.field("owner_directory_id", &self.owner_directory_id);
        formatter.field("shared_directory_ids", &self.shared_directory_ids);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRegionsInput {
    /// <p>The identifier of the directory.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The name of the Region. For example, <code>us-east-1</code>.</p>
    pub region_name: std::option::Option<std::string::String>,
    /// <p>The <code>DescribeRegionsResult.NextToken</code> value from a previous call to <a>DescribeRegions</a>. Pass null if this is the first call.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeRegionsInput {
    /// <p>The identifier of the directory.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The name of the Region. For example, <code>us-east-1</code>.</p>
    pub fn region_name(&self) -> std::option::Option<&str> {
        self.region_name.as_deref()
    }
    /// <p>The <code>DescribeRegionsResult.NextToken</code> value from a previous call to <a>DescribeRegions</a>. Pass null if this is the first call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeRegionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRegionsInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("region_name", &self.region_name);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLdapsSettingsInput {
    /// <p>The identifier of the directory.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The type of LDAP security to enable. Currently only the value <code>Client</code> is
    /// supported.</p>
    pub r#type: std::option::Option<crate::model::LdapsType>,
    /// <p>The type of next token used for pagination.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Specifies the number of items that should be displayed on one page.</p>
    pub limit: std::option::Option<i32>,
}
impl DescribeLdapsSettingsInput {
    /// <p>The identifier of the directory.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The type of LDAP security to enable. Currently only the value <code>Client</code> is
    /// supported.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::LdapsType> {
        self.r#type.as_ref()
    }
    /// <p>The type of next token used for pagination.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Specifies the number of items that should be displayed on one page.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for DescribeLdapsSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLdapsSettingsInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("r#type", &self.r#type);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

/// <p>Describes event topics.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventTopicsInput {
    /// <p>The Directory ID for which to get the list of associated Amazon SNS topics. If this member
    /// is null, associations for all Directory IDs are returned.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>A list of Amazon SNS topic names for which to obtain the information. If this member is
    /// null, all associations for the specified Directory ID are returned.</p>
    /// <p>An empty list results in an <code>InvalidParameterException</code> being
    /// thrown.</p>
    pub topic_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeEventTopicsInput {
    /// <p>The Directory ID for which to get the list of associated Amazon SNS topics. If this member
    /// is null, associations for all Directory IDs are returned.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>A list of Amazon SNS topic names for which to obtain the information. If this member is
    /// null, all associations for the specified Directory ID are returned.</p>
    /// <p>An empty list results in an <code>InvalidParameterException</code> being
    /// thrown.</p>
    pub fn topic_names(&self) -> std::option::Option<&[std::string::String]> {
        self.topic_names.as_deref()
    }
}
impl std::fmt::Debug for DescribeEventTopicsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventTopicsInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("topic_names", &self.topic_names);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDomainControllersInput {
    /// <p>Identifier of the directory for which to retrieve the domain controller
    /// information.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>A list of identifiers for the domain controllers whose information will be
    /// provided.</p>
    pub domain_controller_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The <i>DescribeDomainControllers.NextToken</i> value from a previous call
    /// to <a>DescribeDomainControllers</a>. Pass null if this is the first call.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return.</p>
    pub limit: std::option::Option<i32>,
}
impl DescribeDomainControllersInput {
    /// <p>Identifier of the directory for which to retrieve the domain controller
    /// information.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>A list of identifiers for the domain controllers whose information will be
    /// provided.</p>
    pub fn domain_controller_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.domain_controller_ids.as_deref()
    }
    /// <p>The <i>DescribeDomainControllers.NextToken</i> value from a previous call
    /// to <a>DescribeDomainControllers</a>. Pass null if this is the first call.
    /// </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to return.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for DescribeDomainControllersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDomainControllersInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("domain_controller_ids", &self.domain_controller_ids);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

/// <p>Contains the inputs for the <a>DescribeDirectories</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDirectoriesInput {
    /// <p>A list of identifiers of the directories for which to obtain the information. If this
    /// member is null, all directories that belong to the current account are returned.</p>
    /// <p>An empty list results in an <code>InvalidParameterException</code> being thrown.</p>
    pub directory_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The <code>DescribeDirectoriesResult.NextToken</code> value from a previous call to <a>DescribeDirectories</a>. Pass null if this is the first call.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return. If this value is zero, the maximum number of items
    /// is specified by the limitations of the operation.</p>
    pub limit: std::option::Option<i32>,
}
impl DescribeDirectoriesInput {
    /// <p>A list of identifiers of the directories for which to obtain the information. If this
    /// member is null, all directories that belong to the current account are returned.</p>
    /// <p>An empty list results in an <code>InvalidParameterException</code> being thrown.</p>
    pub fn directory_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.directory_ids.as_deref()
    }
    /// <p>The <code>DescribeDirectoriesResult.NextToken</code> value from a previous call to <a>DescribeDirectories</a>. Pass null if this is the first call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to return. If this value is zero, the maximum number of items
    /// is specified by the limitations of the operation.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for DescribeDirectoriesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDirectoriesInput");
        formatter.field("directory_ids", &self.directory_ids);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

/// <p>Describes a conditional forwarder.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConditionalForwardersInput {
    /// <p>The directory ID for which to get the list of associated conditional
    /// forwarders.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The fully qualified domain names (FQDN) of the remote domains for which to get the list
    /// of associated conditional forwarders. If this member is null, all conditional forwarders are
    /// returned.</p>
    pub remote_domain_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeConditionalForwardersInput {
    /// <p>The directory ID for which to get the list of associated conditional
    /// forwarders.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The fully qualified domain names (FQDN) of the remote domains for which to get the list
    /// of associated conditional forwarders. If this member is null, all conditional forwarders are
    /// returned.</p>
    pub fn remote_domain_names(&self) -> std::option::Option<&[std::string::String]> {
        self.remote_domain_names.as_deref()
    }
}
impl std::fmt::Debug for DescribeConditionalForwardersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConditionalForwardersInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("remote_domain_names", &self.remote_domain_names);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeClientAuthenticationSettingsInput {
    /// <p>The identifier of the directory for which to retrieve information.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The type of client authentication for which to retrieve information. If no type is specified, a list of all client authentication types that are supported for the specified directory is retrieved.</p>
    pub r#type: std::option::Option<crate::model::ClientAuthenticationType>,
    /// <p>The <i>DescribeClientAuthenticationSettingsResult.NextToken</i> value from a previous call to <a>DescribeClientAuthenticationSettings</a>. Pass null if this is the first call.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return. If this value is zero, the maximum number of items is specified by the limitations of the operation. </p>
    pub limit: std::option::Option<i32>,
}
impl DescribeClientAuthenticationSettingsInput {
    /// <p>The identifier of the directory for which to retrieve information.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The type of client authentication for which to retrieve information. If no type is specified, a list of all client authentication types that are supported for the specified directory is retrieved.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ClientAuthenticationType> {
        self.r#type.as_ref()
    }
    /// <p>The <i>DescribeClientAuthenticationSettingsResult.NextToken</i> value from a previous call to <a>DescribeClientAuthenticationSettings</a>. Pass null if this is the first call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to return. If this value is zero, the maximum number of items is specified by the limitations of the operation. </p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for DescribeClientAuthenticationSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeClientAuthenticationSettingsInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("r#type", &self.r#type);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCertificateInput {
    /// <p>The identifier of the directory.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the certificate.</p>
    pub certificate_id: std::option::Option<std::string::String>,
}
impl DescribeCertificateInput {
    /// <p>The identifier of the directory.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The identifier of the certificate.</p>
    pub fn certificate_id(&self) -> std::option::Option<&str> {
        self.certificate_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeCertificateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCertificateInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("certificate_id", &self.certificate_id);
        formatter.finish()
    }
}

/// <p>Removes the specified directory as a publisher to the specified Amazon SNS topic.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterEventTopicInput {
    /// <p>The Directory ID to remove as a publisher. This directory will no longer send messages
    /// to the specified Amazon SNS topic.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon SNS topic from which to remove the directory as a
    /// publisher.</p>
    pub topic_name: std::option::Option<std::string::String>,
}
impl DeregisterEventTopicInput {
    /// <p>The Directory ID to remove as a publisher. This directory will no longer send messages
    /// to the specified Amazon SNS topic.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The name of the Amazon SNS topic from which to remove the directory as a
    /// publisher.</p>
    pub fn topic_name(&self) -> std::option::Option<&str> {
        self.topic_name.as_deref()
    }
}
impl std::fmt::Debug for DeregisterEventTopicInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterEventTopicInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("topic_name", &self.topic_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterCertificateInput {
    /// <p>The identifier of the directory.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the certificate.</p>
    pub certificate_id: std::option::Option<std::string::String>,
}
impl DeregisterCertificateInput {
    /// <p>The identifier of the directory.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The identifier of the certificate.</p>
    pub fn certificate_id(&self) -> std::option::Option<&str> {
        self.certificate_id.as_deref()
    }
}
impl std::fmt::Debug for DeregisterCertificateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterCertificateInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("certificate_id", &self.certificate_id);
        formatter.finish()
    }
}

/// <p>Deletes the local side of an existing trust relationship between the Managed Microsoft AD
/// directory and the external domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTrustInput {
    /// <p>The Trust ID of the trust relationship to be deleted.</p>
    pub trust_id: std::option::Option<std::string::String>,
    /// <p>Delete a conditional forwarder as part of a DeleteTrustRequest.</p>
    pub delete_associated_conditional_forwarder: bool,
}
impl DeleteTrustInput {
    /// <p>The Trust ID of the trust relationship to be deleted.</p>
    pub fn trust_id(&self) -> std::option::Option<&str> {
        self.trust_id.as_deref()
    }
    /// <p>Delete a conditional forwarder as part of a DeleteTrustRequest.</p>
    pub fn delete_associated_conditional_forwarder(&self) -> bool {
        self.delete_associated_conditional_forwarder
    }
}
impl std::fmt::Debug for DeleteTrustInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTrustInput");
        formatter.field("trust_id", &self.trust_id);
        formatter.field(
            "delete_associated_conditional_forwarder",
            &self.delete_associated_conditional_forwarder,
        );
        formatter.finish()
    }
}

/// <p>Contains the inputs for the <a>DeleteSnapshot</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSnapshotInput {
    /// <p>The identifier of the directory snapshot to be deleted.</p>
    pub snapshot_id: std::option::Option<std::string::String>,
}
impl DeleteSnapshotInput {
    /// <p>The identifier of the directory snapshot to be deleted.</p>
    pub fn snapshot_id(&self) -> std::option::Option<&str> {
        self.snapshot_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteSnapshotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSnapshotInput");
        formatter.field("snapshot_id", &self.snapshot_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLogSubscriptionInput {
    /// <p>Identifier of the directory whose log subscription you want to delete.</p>
    pub directory_id: std::option::Option<std::string::String>,
}
impl DeleteLogSubscriptionInput {
    /// <p>Identifier of the directory whose log subscription you want to delete.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteLogSubscriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLogSubscriptionInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.finish()
    }
}

/// <p>Contains the inputs for the <a>DeleteDirectory</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDirectoryInput {
    /// <p>The identifier of the directory to delete.</p>
    pub directory_id: std::option::Option<std::string::String>,
}
impl DeleteDirectoryInput {
    /// <p>The identifier of the directory to delete.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteDirectoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDirectoryInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.finish()
    }
}

/// <p>Deletes a conditional forwarder.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConditionalForwarderInput {
    /// <p>The directory ID for which you are deleting the conditional forwarder.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The fully qualified domain name (FQDN) of the remote domain with which you are deleting
    /// the conditional forwarder.</p>
    pub remote_domain_name: std::option::Option<std::string::String>,
}
impl DeleteConditionalForwarderInput {
    /// <p>The directory ID for which you are deleting the conditional forwarder.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The fully qualified domain name (FQDN) of the remote domain with which you are deleting
    /// the conditional forwarder.</p>
    pub fn remote_domain_name(&self) -> std::option::Option<&str> {
        self.remote_domain_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteConditionalForwarderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConditionalForwarderInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("remote_domain_name", &self.remote_domain_name);
        formatter.finish()
    }
}

/// <p>Directory Service for Microsoft Active Directory allows you to configure trust relationships. For
/// example, you can establish a trust between your Managed Microsoft AD directory, and your existing
/// self-managed Microsoft Active Directory. This would allow you to provide users and groups
/// access to resources in either domain, with a single set of credentials.</p>
/// <p>This action initiates the creation of the Amazon Web Services side of a trust relationship between an
/// Managed Microsoft AD directory and an external domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTrustInput {
    /// <p>The Directory ID of the Managed Microsoft AD directory for which to establish the trust
    /// relationship.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The Fully Qualified Domain Name (FQDN) of the external domain for which to create the
    /// trust relationship.</p>
    pub remote_domain_name: std::option::Option<std::string::String>,
    /// <p>The trust password. The must be the same password that was used when creating the trust
    /// relationship on the external domain.</p>
    pub trust_password: std::option::Option<std::string::String>,
    /// <p>The direction of the trust relationship.</p>
    pub trust_direction: std::option::Option<crate::model::TrustDirection>,
    /// <p>The trust relationship type. <code>Forest</code> is the default.</p>
    pub trust_type: std::option::Option<crate::model::TrustType>,
    /// <p>The IP addresses of the remote DNS server associated with RemoteDomainName.</p>
    pub conditional_forwarder_ip_addrs: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Optional parameter to enable selective authentication for the trust.</p>
    pub selective_auth: std::option::Option<crate::model::SelectiveAuth>,
}
impl CreateTrustInput {
    /// <p>The Directory ID of the Managed Microsoft AD directory for which to establish the trust
    /// relationship.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The Fully Qualified Domain Name (FQDN) of the external domain for which to create the
    /// trust relationship.</p>
    pub fn remote_domain_name(&self) -> std::option::Option<&str> {
        self.remote_domain_name.as_deref()
    }
    /// <p>The trust password. The must be the same password that was used when creating the trust
    /// relationship on the external domain.</p>
    pub fn trust_password(&self) -> std::option::Option<&str> {
        self.trust_password.as_deref()
    }
    /// <p>The direction of the trust relationship.</p>
    pub fn trust_direction(&self) -> std::option::Option<&crate::model::TrustDirection> {
        self.trust_direction.as_ref()
    }
    /// <p>The trust relationship type. <code>Forest</code> is the default.</p>
    pub fn trust_type(&self) -> std::option::Option<&crate::model::TrustType> {
        self.trust_type.as_ref()
    }
    /// <p>The IP addresses of the remote DNS server associated with RemoteDomainName.</p>
    pub fn conditional_forwarder_ip_addrs(&self) -> std::option::Option<&[std::string::String]> {
        self.conditional_forwarder_ip_addrs.as_deref()
    }
    /// <p>Optional parameter to enable selective authentication for the trust.</p>
    pub fn selective_auth(&self) -> std::option::Option<&crate::model::SelectiveAuth> {
        self.selective_auth.as_ref()
    }
}
impl std::fmt::Debug for CreateTrustInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTrustInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("remote_domain_name", &self.remote_domain_name);
        formatter.field("trust_password", &"*** Sensitive Data Redacted ***");
        formatter.field("trust_direction", &self.trust_direction);
        formatter.field("trust_type", &self.trust_type);
        formatter.field(
            "conditional_forwarder_ip_addrs",
            &self.conditional_forwarder_ip_addrs,
        );
        formatter.field("selective_auth", &self.selective_auth);
        formatter.finish()
    }
}

/// <p>Contains the inputs for the <a>CreateSnapshot</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSnapshotInput {
    /// <p>The identifier of the directory of which to take a snapshot.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The descriptive name to apply to the snapshot.</p>
    pub name: std::option::Option<std::string::String>,
}
impl CreateSnapshotInput {
    /// <p>The identifier of the directory of which to take a snapshot.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The descriptive name to apply to the snapshot.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for CreateSnapshotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSnapshotInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

/// <p>Creates an Managed Microsoft AD directory.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMicrosoftAdInput {
    /// <p>The fully qualified domain name for the Managed Microsoft AD directory, such as
    /// <code>corp.example.com</code>. This name will resolve inside your VPC only. It does not need
    /// to be publicly resolvable.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The NetBIOS name for your domain, such as <code>CORP</code>. If you don't specify a
    /// NetBIOS name, it will default to the first part of your directory DNS. For example,
    /// <code>CORP</code> for the directory DNS <code>corp.example.com</code>. </p>
    pub short_name: std::option::Option<std::string::String>,
    /// <p>The password for the default administrative user named <code>Admin</code>.</p>
    /// <p>If you need to change the password for the administrator account, you can use the <a>ResetUserPassword</a> API call.</p>
    pub password: std::option::Option<std::string::String>,
    /// <p>A description for the directory. This label will appear on the Amazon Web Services console
    /// <code>Directory Details</code> page after the directory is created.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Contains VPC information for the <a>CreateDirectory</a> or <a>CreateMicrosoftAD</a> operation.</p>
    pub vpc_settings: std::option::Option<crate::model::DirectoryVpcSettings>,
    /// <p>Managed Microsoft AD is available in two editions: <code>Standard</code> and
    /// <code>Enterprise</code>. <code>Enterprise</code> is the default.</p>
    pub edition: std::option::Option<crate::model::DirectoryEdition>,
    /// <p>The tags to be assigned to the Managed Microsoft AD directory.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateMicrosoftAdInput {
    /// <p>The fully qualified domain name for the Managed Microsoft AD directory, such as
    /// <code>corp.example.com</code>. This name will resolve inside your VPC only. It does not need
    /// to be publicly resolvable.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The NetBIOS name for your domain, such as <code>CORP</code>. If you don't specify a
    /// NetBIOS name, it will default to the first part of your directory DNS. For example,
    /// <code>CORP</code> for the directory DNS <code>corp.example.com</code>. </p>
    pub fn short_name(&self) -> std::option::Option<&str> {
        self.short_name.as_deref()
    }
    /// <p>The password for the default administrative user named <code>Admin</code>.</p>
    /// <p>If you need to change the password for the administrator account, you can use the <a>ResetUserPassword</a> API call.</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
    /// <p>A description for the directory. This label will appear on the Amazon Web Services console
    /// <code>Directory Details</code> page after the directory is created.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Contains VPC information for the <a>CreateDirectory</a> or <a>CreateMicrosoftAD</a> operation.</p>
    pub fn vpc_settings(&self) -> std::option::Option<&crate::model::DirectoryVpcSettings> {
        self.vpc_settings.as_ref()
    }
    /// <p>Managed Microsoft AD is available in two editions: <code>Standard</code> and
    /// <code>Enterprise</code>. <code>Enterprise</code> is the default.</p>
    pub fn edition(&self) -> std::option::Option<&crate::model::DirectoryEdition> {
        self.edition.as_ref()
    }
    /// <p>The tags to be assigned to the Managed Microsoft AD directory.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateMicrosoftAdInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMicrosoftAdInput");
        formatter.field("name", &self.name);
        formatter.field("short_name", &self.short_name);
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.field("description", &self.description);
        formatter.field("vpc_settings", &self.vpc_settings);
        formatter.field("edition", &self.edition);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLogSubscriptionInput {
    /// <p>Identifier of the directory to which you want to subscribe and receive real-time logs to
    /// your specified CloudWatch log group.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The name of the CloudWatch log group where the real-time domain controller logs are
    /// forwarded.</p>
    pub log_group_name: std::option::Option<std::string::String>,
}
impl CreateLogSubscriptionInput {
    /// <p>Identifier of the directory to which you want to subscribe and receive real-time logs to
    /// your specified CloudWatch log group.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The name of the CloudWatch log group where the real-time domain controller logs are
    /// forwarded.</p>
    pub fn log_group_name(&self) -> std::option::Option<&str> {
        self.log_group_name.as_deref()
    }
}
impl std::fmt::Debug for CreateLogSubscriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLogSubscriptionInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("log_group_name", &self.log_group_name);
        formatter.finish()
    }
}

/// <p>Contains the inputs for the <a>CreateDirectory</a> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDirectoryInput {
    /// <p>The fully qualified name for the directory, such as <code>corp.example.com</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The NetBIOS name of the directory, such as <code>CORP</code>.</p>
    pub short_name: std::option::Option<std::string::String>,
    /// <p>The password for the directory administrator. The directory creation process creates a
    /// directory administrator account with the user name <code>Administrator</code> and this
    /// password.</p>
    /// <p>If you need to change the password for the administrator account, you can use the <a>ResetUserPassword</a> API call.</p>
    /// <p>The regex pattern for this string is made up of the following conditions:</p>
    /// <ul>
    /// <li>
    /// <p>Length (?=^.{8,64}$) – Must be between 8 and 64 characters</p>
    /// </li>
    /// </ul>
    /// <p>AND any 3 of the following password complexity rules required by Active Directory:</p>
    /// <ul>
    /// <li>
    /// <p>Numbers and upper case and lowercase (?=.*\d)(?=.*[A-Z])(?=.*[a-z])</p>
    /// </li>
    /// <li>
    /// <p>Numbers and special characters and lower case
    /// (?=.*\d)(?=.*[^A-Za-z0-9\s])(?=.*[a-z])</p>
    /// </li>
    /// <li>
    /// <p>Special characters and upper case and lower case
    /// (?=.*[^A-Za-z0-9\s])(?=.*[A-Z])(?=.*[a-z])</p>
    /// </li>
    /// <li>
    /// <p>Numbers and upper case and special characters
    /// (?=.*\d)(?=.*[A-Z])(?=.*[^A-Za-z0-9\s])</p>
    /// </li>
    /// </ul>
    /// <p>For additional information about how Active Directory passwords are enforced, see <a href="https://docs.microsoft.com/en-us/windows/security/threat-protection/security-policy-settings/password-must-meet-complexity-requirements">Password must meet complexity requirements</a> on the Microsoft website.</p>
    pub password: std::option::Option<std::string::String>,
    /// <p>A description for the directory.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The size of the directory.</p>
    pub size: std::option::Option<crate::model::DirectorySize>,
    /// <p>A <a>DirectoryVpcSettings</a> object that contains additional information for
    /// the operation.</p>
    pub vpc_settings: std::option::Option<crate::model::DirectoryVpcSettings>,
    /// <p>The tags to be assigned to the Simple AD directory.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateDirectoryInput {
    /// <p>The fully qualified name for the directory, such as <code>corp.example.com</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The NetBIOS name of the directory, such as <code>CORP</code>.</p>
    pub fn short_name(&self) -> std::option::Option<&str> {
        self.short_name.as_deref()
    }
    /// <p>The password for the directory administrator. The directory creation process creates a
    /// directory administrator account with the user name <code>Administrator</code> and this
    /// password.</p>
    /// <p>If you need to change the password for the administrator account, you can use the <a>ResetUserPassword</a> API call.</p>
    /// <p>The regex pattern for this string is made up of the following conditions:</p>
    /// <ul>
    /// <li>
    /// <p>Length (?=^.{8,64}$) – Must be between 8 and 64 characters</p>
    /// </li>
    /// </ul>
    /// <p>AND any 3 of the following password complexity rules required by Active Directory:</p>
    /// <ul>
    /// <li>
    /// <p>Numbers and upper case and lowercase (?=.*\d)(?=.*[A-Z])(?=.*[a-z])</p>
    /// </li>
    /// <li>
    /// <p>Numbers and special characters and lower case
    /// (?=.*\d)(?=.*[^A-Za-z0-9\s])(?=.*[a-z])</p>
    /// </li>
    /// <li>
    /// <p>Special characters and upper case and lower case
    /// (?=.*[^A-Za-z0-9\s])(?=.*[A-Z])(?=.*[a-z])</p>
    /// </li>
    /// <li>
    /// <p>Numbers and upper case and special characters
    /// (?=.*\d)(?=.*[A-Z])(?=.*[^A-Za-z0-9\s])</p>
    /// </li>
    /// </ul>
    /// <p>For additional information about how Active Directory passwords are enforced, see <a href="https://docs.microsoft.com/en-us/windows/security/threat-protection/security-policy-settings/password-must-meet-complexity-requirements">Password must meet complexity requirements</a> on the Microsoft website.</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
    /// <p>A description for the directory.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The size of the directory.</p>
    pub fn size(&self) -> std::option::Option<&crate::model::DirectorySize> {
        self.size.as_ref()
    }
    /// <p>A <a>DirectoryVpcSettings</a> object that contains additional information for
    /// the operation.</p>
    pub fn vpc_settings(&self) -> std::option::Option<&crate::model::DirectoryVpcSettings> {
        self.vpc_settings.as_ref()
    }
    /// <p>The tags to be assigned to the Simple AD directory.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateDirectoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDirectoryInput");
        formatter.field("name", &self.name);
        formatter.field("short_name", &self.short_name);
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.field("description", &self.description);
        formatter.field("size", &self.size);
        formatter.field("vpc_settings", &self.vpc_settings);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Initiates the creation of a conditional forwarder for your Directory Service for Microsoft Active
/// Directory. Conditional forwarders are required in order to set up a trust relationship with
/// another domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConditionalForwarderInput {
    /// <p>The directory ID of the Amazon Web Services directory for which you are creating the conditional
    /// forwarder.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The fully qualified domain name (FQDN) of the remote domain with which you will set up
    /// a trust relationship.</p>
    pub remote_domain_name: std::option::Option<std::string::String>,
    /// <p>The IP addresses of the remote DNS server associated with RemoteDomainName.</p>
    pub dns_ip_addrs: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CreateConditionalForwarderInput {
    /// <p>The directory ID of the Amazon Web Services directory for which you are creating the conditional
    /// forwarder.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The fully qualified domain name (FQDN) of the remote domain with which you will set up
    /// a trust relationship.</p>
    pub fn remote_domain_name(&self) -> std::option::Option<&str> {
        self.remote_domain_name.as_deref()
    }
    /// <p>The IP addresses of the remote DNS server associated with RemoteDomainName.</p>
    pub fn dns_ip_addrs(&self) -> std::option::Option<&[std::string::String]> {
        self.dns_ip_addrs.as_deref()
    }
}
impl std::fmt::Debug for CreateConditionalForwarderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConditionalForwarderInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("remote_domain_name", &self.remote_domain_name);
        formatter.field("dns_ip_addrs", &self.dns_ip_addrs);
        formatter.finish()
    }
}

/// <p>Contains the inputs for the <a>CreateComputer</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateComputerInput {
    /// <p>The identifier of the directory in which to create the computer account.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The name of the computer account.</p>
    pub computer_name: std::option::Option<std::string::String>,
    /// <p>A one-time password that is used to join the computer to the directory. You should generate a random, strong password to use for this parameter.</p>
    pub password: std::option::Option<std::string::String>,
    /// <p>The fully-qualified distinguished name of the organizational unit to place the computer account in.</p>
    pub organizational_unit_distinguished_name: std::option::Option<std::string::String>,
    /// <p>An array of <a>Attribute</a> objects that contain any LDAP attributes to apply to the
    /// computer account.</p>
    pub computer_attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
}
impl CreateComputerInput {
    /// <p>The identifier of the directory in which to create the computer account.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The name of the computer account.</p>
    pub fn computer_name(&self) -> std::option::Option<&str> {
        self.computer_name.as_deref()
    }
    /// <p>A one-time password that is used to join the computer to the directory. You should generate a random, strong password to use for this parameter.</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
    /// <p>The fully-qualified distinguished name of the organizational unit to place the computer account in.</p>
    pub fn organizational_unit_distinguished_name(&self) -> std::option::Option<&str> {
        self.organizational_unit_distinguished_name.as_deref()
    }
    /// <p>An array of <a>Attribute</a> objects that contain any LDAP attributes to apply to the
    /// computer account.</p>
    pub fn computer_attributes(&self) -> std::option::Option<&[crate::model::Attribute]> {
        self.computer_attributes.as_deref()
    }
}
impl std::fmt::Debug for CreateComputerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateComputerInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("computer_name", &self.computer_name);
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.field(
            "organizational_unit_distinguished_name",
            &self.organizational_unit_distinguished_name,
        );
        formatter.field("computer_attributes", &self.computer_attributes);
        formatter.finish()
    }
}

/// <p>Contains the inputs for the <a>CreateAlias</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAliasInput {
    /// <p>The identifier of the directory for which to create the alias.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The requested alias.</p>
    /// <p>The alias must be unique amongst all aliases in Amazon Web Services. This operation throws an
    /// <code>EntityAlreadyExistsException</code> error if the alias already exists.</p>
    pub alias: std::option::Option<std::string::String>,
}
impl CreateAliasInput {
    /// <p>The identifier of the directory for which to create the alias.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The requested alias.</p>
    /// <p>The alias must be unique amongst all aliases in Amazon Web Services. This operation throws an
    /// <code>EntityAlreadyExistsException</code> error if the alias already exists.</p>
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
}
impl std::fmt::Debug for CreateAliasInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAliasInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("alias", &self.alias);
        formatter.finish()
    }
}

/// <p>Contains the inputs for the <a>ConnectDirectory</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectDirectoryInput {
    /// <p>The fully qualified name of your self-managed directory, such as
    /// <code>corp.example.com</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The NetBIOS name of your self-managed directory, such as <code>CORP</code>.</p>
    pub short_name: std::option::Option<std::string::String>,
    /// <p>The password for your self-managed user account.</p>
    pub password: std::option::Option<std::string::String>,
    /// <p>A description for the directory.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The size of the directory.</p>
    pub size: std::option::Option<crate::model::DirectorySize>,
    /// <p>A <a>DirectoryConnectSettings</a> object that contains additional information
    /// for the operation.</p>
    pub connect_settings: std::option::Option<crate::model::DirectoryConnectSettings>,
    /// <p>The tags to be assigned to AD Connector.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ConnectDirectoryInput {
    /// <p>The fully qualified name of your self-managed directory, such as
    /// <code>corp.example.com</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The NetBIOS name of your self-managed directory, such as <code>CORP</code>.</p>
    pub fn short_name(&self) -> std::option::Option<&str> {
        self.short_name.as_deref()
    }
    /// <p>The password for your self-managed user account.</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
    /// <p>A description for the directory.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The size of the directory.</p>
    pub fn size(&self) -> std::option::Option<&crate::model::DirectorySize> {
        self.size.as_ref()
    }
    /// <p>A <a>DirectoryConnectSettings</a> object that contains additional information
    /// for the operation.</p>
    pub fn connect_settings(&self) -> std::option::Option<&crate::model::DirectoryConnectSettings> {
        self.connect_settings.as_ref()
    }
    /// <p>The tags to be assigned to AD Connector.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ConnectDirectoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectDirectoryInput");
        formatter.field("name", &self.name);
        formatter.field("short_name", &self.short_name);
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.field("description", &self.description);
        formatter.field("size", &self.size);
        formatter.field("connect_settings", &self.connect_settings);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelSchemaExtensionInput {
    /// <p>The identifier of the directory whose schema extension will be canceled.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the schema extension that will be canceled.</p>
    pub schema_extension_id: std::option::Option<std::string::String>,
}
impl CancelSchemaExtensionInput {
    /// <p>The identifier of the directory whose schema extension will be canceled.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The identifier of the schema extension that will be canceled.</p>
    pub fn schema_extension_id(&self) -> std::option::Option<&str> {
        self.schema_extension_id.as_deref()
    }
}
impl std::fmt::Debug for CancelSchemaExtensionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelSchemaExtensionInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("schema_extension_id", &self.schema_extension_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddTagsToResourceInput {
    /// <p>Identifier (ID) for the directory to which to add the tag.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The tags to be assigned to the directory.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl AddTagsToResourceInput {
    /// <p>Identifier (ID) for the directory to which to add the tag.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The tags to be assigned to the directory.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for AddTagsToResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddTagsToResourceInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddRegionInput {
    /// <p>The identifier of the directory to which you want to add Region replication.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The name of the Region where you want to add domain controllers for replication. For
    /// example, <code>us-east-1</code>.</p>
    pub region_name: std::option::Option<std::string::String>,
    /// <p>Contains VPC information for the <a>CreateDirectory</a> or <a>CreateMicrosoftAD</a> operation.</p>
    pub vpc_settings: std::option::Option<crate::model::DirectoryVpcSettings>,
}
impl AddRegionInput {
    /// <p>The identifier of the directory to which you want to add Region replication.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The name of the Region where you want to add domain controllers for replication. For
    /// example, <code>us-east-1</code>.</p>
    pub fn region_name(&self) -> std::option::Option<&str> {
        self.region_name.as_deref()
    }
    /// <p>Contains VPC information for the <a>CreateDirectory</a> or <a>CreateMicrosoftAD</a> operation.</p>
    pub fn vpc_settings(&self) -> std::option::Option<&crate::model::DirectoryVpcSettings> {
        self.vpc_settings.as_ref()
    }
}
impl std::fmt::Debug for AddRegionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddRegionInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("region_name", &self.region_name);
        formatter.field("vpc_settings", &self.vpc_settings);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddIpRoutesInput {
    /// <p>Identifier (ID) of the directory to which to add the address block.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>IP address blocks, using CIDR format, of the traffic to route. This is often the IP
    /// address block of the DNS server used for your self-managed domain.</p>
    pub ip_routes: std::option::Option<std::vec::Vec<crate::model::IpRoute>>,
    /// <p>If set to true, updates the inbound and outbound rules of the security group that has
    /// the description: "Amazon Web Services created security group for <i>directory ID</i>
    /// directory controllers." Following are the new rules: </p>
    /// <p>Inbound:</p>
    /// <ul>
    /// <li>
    /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 88, Source: 0.0.0.0/0</p>
    /// </li>
    /// <li>
    /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 123, Source: 0.0.0.0/0</p>
    /// </li>
    /// <li>
    /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 138, Source: 0.0.0.0/0</p>
    /// </li>
    /// <li>
    /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 389, Source: 0.0.0.0/0</p>
    /// </li>
    /// <li>
    /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 464, Source: 0.0.0.0/0</p>
    /// </li>
    /// <li>
    /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 445, Source: 0.0.0.0/0</p>
    /// </li>
    /// <li>
    /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 88, Source: 0.0.0.0/0</p>
    /// </li>
    /// <li>
    /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 135, Source: 0.0.0.0/0</p>
    /// </li>
    /// <li>
    /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 445, Source: 0.0.0.0/0</p>
    /// </li>
    /// <li>
    /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 464, Source: 0.0.0.0/0</p>
    /// </li>
    /// <li>
    /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 636, Source: 0.0.0.0/0</p>
    /// </li>
    /// <li>
    /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 1024-65535, Source:
    /// 0.0.0.0/0</p>
    /// </li>
    /// <li>
    /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 3268-33269, Source:
    /// 0.0.0.0/0</p>
    /// </li>
    /// <li>
    /// <p>Type: DNS (UDP), Protocol: UDP, Range: 53, Source: 0.0.0.0/0</p>
    /// </li>
    /// <li>
    /// <p>Type: DNS (TCP), Protocol: TCP, Range: 53, Source: 0.0.0.0/0</p>
    /// </li>
    /// <li>
    /// <p>Type: LDAP, Protocol: TCP, Range: 389, Source: 0.0.0.0/0</p>
    /// </li>
    /// <li>
    /// <p>Type: All ICMP, Protocol: All, Range: N/A, Source: 0.0.0.0/0</p>
    /// </li>
    /// </ul>
    ///
    /// <p></p>
    /// <p>Outbound:</p>
    /// <ul>
    /// <li>
    /// <p>Type: All traffic, Protocol: All, Range: All, Destination: 0.0.0.0/0</p>
    /// </li>
    /// </ul>
    /// <p>These security rules impact an internal network interface that is not exposed
    /// publicly.</p>
    pub update_security_group_for_directory_controllers: bool,
}
impl AddIpRoutesInput {
    /// <p>Identifier (ID) of the directory to which to add the address block.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>IP address blocks, using CIDR format, of the traffic to route. This is often the IP
    /// address block of the DNS server used for your self-managed domain.</p>
    pub fn ip_routes(&self) -> std::option::Option<&[crate::model::IpRoute]> {
        self.ip_routes.as_deref()
    }
    /// <p>If set to true, updates the inbound and outbound rules of the security group that has
    /// the description: "Amazon Web Services created security group for <i>directory ID</i>
    /// directory controllers." Following are the new rules: </p>
    /// <p>Inbound:</p>
    /// <ul>
    /// <li>
    /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 88, Source: 0.0.0.0/0</p>
    /// </li>
    /// <li>
    /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 123, Source: 0.0.0.0/0</p>
    /// </li>
    /// <li>
    /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 138, Source: 0.0.0.0/0</p>
    /// </li>
    /// <li>
    /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 389, Source: 0.0.0.0/0</p>
    /// </li>
    /// <li>
    /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 464, Source: 0.0.0.0/0</p>
    /// </li>
    /// <li>
    /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 445, Source: 0.0.0.0/0</p>
    /// </li>
    /// <li>
    /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 88, Source: 0.0.0.0/0</p>
    /// </li>
    /// <li>
    /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 135, Source: 0.0.0.0/0</p>
    /// </li>
    /// <li>
    /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 445, Source: 0.0.0.0/0</p>
    /// </li>
    /// <li>
    /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 464, Source: 0.0.0.0/0</p>
    /// </li>
    /// <li>
    /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 636, Source: 0.0.0.0/0</p>
    /// </li>
    /// <li>
    /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 1024-65535, Source:
    /// 0.0.0.0/0</p>
    /// </li>
    /// <li>
    /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 3268-33269, Source:
    /// 0.0.0.0/0</p>
    /// </li>
    /// <li>
    /// <p>Type: DNS (UDP), Protocol: UDP, Range: 53, Source: 0.0.0.0/0</p>
    /// </li>
    /// <li>
    /// <p>Type: DNS (TCP), Protocol: TCP, Range: 53, Source: 0.0.0.0/0</p>
    /// </li>
    /// <li>
    /// <p>Type: LDAP, Protocol: TCP, Range: 389, Source: 0.0.0.0/0</p>
    /// </li>
    /// <li>
    /// <p>Type: All ICMP, Protocol: All, Range: N/A, Source: 0.0.0.0/0</p>
    /// </li>
    /// </ul>
    ///
    /// <p></p>
    /// <p>Outbound:</p>
    /// <ul>
    /// <li>
    /// <p>Type: All traffic, Protocol: All, Range: All, Destination: 0.0.0.0/0</p>
    /// </li>
    /// </ul>
    /// <p>These security rules impact an internal network interface that is not exposed
    /// publicly.</p>
    pub fn update_security_group_for_directory_controllers(&self) -> bool {
        self.update_security_group_for_directory_controllers
    }
}
impl std::fmt::Debug for AddIpRoutesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddIpRoutesInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("ip_routes", &self.ip_routes);
        formatter.field(
            "update_security_group_for_directory_controllers",
            &self.update_security_group_for_directory_controllers,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceptSharedDirectoryInput {
    /// <p>Identifier of the shared directory in the directory consumer account. This identifier is
    /// different for each directory owner account. </p>
    pub shared_directory_id: std::option::Option<std::string::String>,
}
impl AcceptSharedDirectoryInput {
    /// <p>Identifier of the shared directory in the directory consumer account. This identifier is
    /// different for each directory owner account. </p>
    pub fn shared_directory_id(&self) -> std::option::Option<&str> {
        self.shared_directory_id.as_deref()
    }
}
impl std::fmt::Debug for AcceptSharedDirectoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceptSharedDirectoryInput");
        formatter.field("shared_directory_id", &self.shared_directory_id);
        formatter.finish()
    }
}
