// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>Client authentication is not available in this region at this time.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An authentication error occurred.</p>
    AuthenticationFailedException(crate::error::AuthenticationFailedException),
    /// <p>The certificate has already been registered into the system.</p>
    CertificateAlreadyExistsException(crate::error::CertificateAlreadyExistsException),
    /// <p>The certificate is not present in the system for describe or deregister activities.</p>
    CertificateDoesNotExistException(crate::error::CertificateDoesNotExistException),
    /// <p>The certificate is being used for the LDAP security connection and cannot be removed
    /// without disabling LDAP security.</p>
    CertificateInUseException(crate::error::CertificateInUseException),
    /// <p>The certificate could not be added because the certificate limit has been reached.</p>
    CertificateLimitExceededException(crate::error::CertificateLimitExceededException),
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The Region you specified is the same Region where the Managed Microsoft AD directory
    /// was created. Specify a different Region and try again.</p>
    DirectoryAlreadyInRegionException(crate::error::DirectoryAlreadyInRegionException),
    /// <p>The specified directory has already been shared with this Amazon Web Services account.</p>
    DirectoryAlreadySharedException(crate::error::DirectoryAlreadySharedException),
    /// <p>The specified directory does not exist in the system.</p>
    DirectoryDoesNotExistException(crate::error::DirectoryDoesNotExistException),
    /// <p>The maximum number of directories in the region has been reached. You can use the
    /// <a>GetDirectoryLimits</a> operation to determine your directory limits in
    /// the region.</p>
    DirectoryLimitExceededException(crate::error::DirectoryLimitExceededException),
    /// <p>The specified directory has not been shared with this Amazon Web Services account.</p>
    DirectoryNotSharedException(crate::error::DirectoryNotSharedException),
    /// <p>The specified directory is unavailable or could not be found.</p>
    DirectoryUnavailableException(crate::error::DirectoryUnavailableException),
    /// <p>The maximum allowed number of domain controllers per directory was exceeded. The
    /// default limit per directory is 20 domain controllers.</p>
    DomainControllerLimitExceededException(crate::error::DomainControllerLimitExceededException),
    /// <p>The specified entity already exists.</p>
    EntityAlreadyExistsException(crate::error::EntityAlreadyExistsException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>The account does not have sufficient permission to perform the operation.</p>
    InsufficientPermissionsException(crate::error::InsufficientPermissionsException),
    /// <p>The certificate PEM that was provided has incorrect encoding.</p>
    InvalidCertificateException(crate::error::InvalidCertificateException),
    /// <p>Client authentication is already enabled.</p>
    InvalidClientAuthStatusException(crate::error::InvalidClientAuthStatusException),
    /// <p>The LDAP activities could not be performed because they are limited by the LDAPS
    /// status.</p>
    InvalidLdapsStatusException(crate::error::InvalidLdapsStatusException),
    /// <p>The <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The new password provided by the user does not meet the password complexity
    /// requirements defined in your directory.</p>
    InvalidPasswordException(crate::error::InvalidPasswordException),
    /// <p>The specified shared target is not valid.</p>
    InvalidTargetException(crate::error::InvalidTargetException),
    /// <p>The maximum allowed number of IP addresses was exceeded. The default limit is 100 IP
    /// address blocks.</p>
    IpRouteLimitExceededException(crate::error::IpRouteLimitExceededException),
    /// <p>Client authentication setup could not be completed because at least one valid certificate must be
    /// registered in the system.</p>
    NoAvailableCertificateException(crate::error::NoAvailableCertificateException),
    /// <p>Exception encountered while trying to access your Amazon Web Services organization.</p>
    OrganizationsException(crate::error::OrganizationsException),
    /// <p>You have reached the limit for maximum number of simultaneous Region replications per
    /// directory.</p>
    RegionLimitExceededException(crate::error::RegionLimitExceededException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The maximum number of Amazon Web Services accounts that you can share with this directory has been
    /// reached.</p>
    ShareLimitExceededException(crate::error::ShareLimitExceededException),
    /// <p>The maximum number of manual snapshots for the directory has been reached. You can
    /// use the <a>GetSnapshotLimits</a> operation to determine the snapshot limits
    /// for a directory.</p>
    SnapshotLimitExceededException(crate::error::SnapshotLimitExceededException),
    /// <p>The maximum allowed number of tags was exceeded.</p>
    TagLimitExceededException(crate::error::TagLimitExceededException),
    /// <p>The operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// <p>The user provided a username that does not exist in your directory.</p>
    UserDoesNotExistException(crate::error::UserDoesNotExistException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::AccessDeniedException(inner) => inner.fmt(f),
            Error::AuthenticationFailedException(inner) => inner.fmt(f),
            Error::CertificateAlreadyExistsException(inner) => inner.fmt(f),
            Error::CertificateDoesNotExistException(inner) => inner.fmt(f),
            Error::CertificateInUseException(inner) => inner.fmt(f),
            Error::CertificateLimitExceededException(inner) => inner.fmt(f),
            Error::ClientException(inner) => inner.fmt(f),
            Error::DirectoryAlreadyInRegionException(inner) => inner.fmt(f),
            Error::DirectoryAlreadySharedException(inner) => inner.fmt(f),
            Error::DirectoryDoesNotExistException(inner) => inner.fmt(f),
            Error::DirectoryLimitExceededException(inner) => inner.fmt(f),
            Error::DirectoryNotSharedException(inner) => inner.fmt(f),
            Error::DirectoryUnavailableException(inner) => inner.fmt(f),
            Error::DomainControllerLimitExceededException(inner) => inner.fmt(f),
            Error::EntityAlreadyExistsException(inner) => inner.fmt(f),
            Error::EntityDoesNotExistException(inner) => inner.fmt(f),
            Error::InsufficientPermissionsException(inner) => inner.fmt(f),
            Error::InvalidCertificateException(inner) => inner.fmt(f),
            Error::InvalidClientAuthStatusException(inner) => inner.fmt(f),
            Error::InvalidLdapsStatusException(inner) => inner.fmt(f),
            Error::InvalidNextTokenException(inner) => inner.fmt(f),
            Error::InvalidParameterException(inner) => inner.fmt(f),
            Error::InvalidPasswordException(inner) => inner.fmt(f),
            Error::InvalidTargetException(inner) => inner.fmt(f),
            Error::IpRouteLimitExceededException(inner) => inner.fmt(f),
            Error::NoAvailableCertificateException(inner) => inner.fmt(f),
            Error::OrganizationsException(inner) => inner.fmt(f),
            Error::RegionLimitExceededException(inner) => inner.fmt(f),
            Error::ServiceException(inner) => inner.fmt(f),
            Error::ShareLimitExceededException(inner) => inner.fmt(f),
            Error::SnapshotLimitExceededException(inner) => inner.fmt(f),
            Error::TagLimitExceededException(inner) => inner.fmt(f),
            Error::UnsupportedOperationException(inner) => inner.fmt(f),
            Error::UserDoesNotExistException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AcceptSharedDirectoryError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AcceptSharedDirectoryError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AcceptSharedDirectoryErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::AcceptSharedDirectoryErrorKind::DirectoryAlreadySharedException(
                    inner,
                ) => Error::DirectoryAlreadySharedException(inner),
                crate::error::AcceptSharedDirectoryErrorKind::EntityDoesNotExistException(
                    inner,
                ) => Error::EntityDoesNotExistException(inner),
                crate::error::AcceptSharedDirectoryErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::AcceptSharedDirectoryErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::AcceptSharedDirectoryErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AddIpRoutesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::AddIpRoutesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AddIpRoutesErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::AddIpRoutesErrorKind::DirectoryUnavailableException(inner) => {
                    Error::DirectoryUnavailableException(inner)
                }
                crate::error::AddIpRoutesErrorKind::EntityAlreadyExistsException(inner) => {
                    Error::EntityAlreadyExistsException(inner)
                }
                crate::error::AddIpRoutesErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::AddIpRoutesErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::AddIpRoutesErrorKind::IpRouteLimitExceededException(inner) => {
                    Error::IpRouteLimitExceededException(inner)
                }
                crate::error::AddIpRoutesErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::AddIpRoutesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AddRegionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::AddRegionError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AddRegionErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::AddRegionErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::AddRegionErrorKind::DirectoryAlreadyInRegionException(inner) => {
                    Error::DirectoryAlreadyInRegionException(inner)
                }
                crate::error::AddRegionErrorKind::DirectoryDoesNotExistException(inner) => {
                    Error::DirectoryDoesNotExistException(inner)
                }
                crate::error::AddRegionErrorKind::DirectoryUnavailableException(inner) => {
                    Error::DirectoryUnavailableException(inner)
                }
                crate::error::AddRegionErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::AddRegionErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::AddRegionErrorKind::RegionLimitExceededException(inner) => {
                    Error::RegionLimitExceededException(inner)
                }
                crate::error::AddRegionErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::AddRegionErrorKind::UnsupportedOperationException(inner) => {
                    Error::UnsupportedOperationException(inner)
                }
                crate::error::AddRegionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AddTagsToResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AddTagsToResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AddTagsToResourceErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::AddTagsToResourceErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::AddTagsToResourceErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::AddTagsToResourceErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::AddTagsToResourceErrorKind::TagLimitExceededException(inner) => {
                    Error::TagLimitExceededException(inner)
                }
                crate::error::AddTagsToResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CancelSchemaExtensionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CancelSchemaExtensionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CancelSchemaExtensionErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::CancelSchemaExtensionErrorKind::EntityDoesNotExistException(
                    inner,
                ) => Error::EntityDoesNotExistException(inner),
                crate::error::CancelSchemaExtensionErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::CancelSchemaExtensionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ConnectDirectoryError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ConnectDirectoryError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ConnectDirectoryErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::ConnectDirectoryErrorKind::DirectoryLimitExceededException(inner) => {
                    Error::DirectoryLimitExceededException(inner)
                }
                crate::error::ConnectDirectoryErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ConnectDirectoryErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::ConnectDirectoryErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateAliasError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateAliasError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateAliasErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::CreateAliasErrorKind::EntityAlreadyExistsException(inner) => {
                    Error::EntityAlreadyExistsException(inner)
                }
                crate::error::CreateAliasErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::CreateAliasErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::CreateAliasErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::CreateAliasErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateComputerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateComputerError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateComputerErrorKind::AuthenticationFailedException(inner) => {
                    Error::AuthenticationFailedException(inner)
                }
                crate::error::CreateComputerErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::CreateComputerErrorKind::DirectoryUnavailableException(inner) => {
                    Error::DirectoryUnavailableException(inner)
                }
                crate::error::CreateComputerErrorKind::EntityAlreadyExistsException(inner) => {
                    Error::EntityAlreadyExistsException(inner)
                }
                crate::error::CreateComputerErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::CreateComputerErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::CreateComputerErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::CreateComputerErrorKind::UnsupportedOperationException(inner) => {
                    Error::UnsupportedOperationException(inner)
                }
                crate::error::CreateComputerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateConditionalForwarderError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateConditionalForwarderError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateConditionalForwarderErrorKind::ClientException(inner) => Error::ClientException(inner),
                crate::error::CreateConditionalForwarderErrorKind::DirectoryUnavailableException(inner) => Error::DirectoryUnavailableException(inner),
                crate::error::CreateConditionalForwarderErrorKind::EntityAlreadyExistsException(inner) => Error::EntityAlreadyExistsException(inner),
                crate::error::CreateConditionalForwarderErrorKind::EntityDoesNotExistException(inner) => Error::EntityDoesNotExistException(inner),
                crate::error::CreateConditionalForwarderErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::CreateConditionalForwarderErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::CreateConditionalForwarderErrorKind::UnsupportedOperationException(inner) => Error::UnsupportedOperationException(inner),
                crate::error::CreateConditionalForwarderErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDirectoryError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateDirectoryError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateDirectoryErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::CreateDirectoryErrorKind::DirectoryLimitExceededException(inner) => {
                    Error::DirectoryLimitExceededException(inner)
                }
                crate::error::CreateDirectoryErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::CreateDirectoryErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::CreateDirectoryErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateLogSubscriptionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateLogSubscriptionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateLogSubscriptionErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::CreateLogSubscriptionErrorKind::EntityAlreadyExistsException(
                    inner,
                ) => Error::EntityAlreadyExistsException(inner),
                crate::error::CreateLogSubscriptionErrorKind::EntityDoesNotExistException(
                    inner,
                ) => Error::EntityDoesNotExistException(inner),
                crate::error::CreateLogSubscriptionErrorKind::InsufficientPermissionsException(
                    inner,
                ) => Error::InsufficientPermissionsException(inner),
                crate::error::CreateLogSubscriptionErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::CreateLogSubscriptionErrorKind::UnsupportedOperationException(
                    inner,
                ) => Error::UnsupportedOperationException(inner),
                crate::error::CreateLogSubscriptionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateMicrosoftADError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateMicrosoftADError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateMicrosoftADErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::CreateMicrosoftADErrorKind::DirectoryLimitExceededException(
                    inner,
                ) => Error::DirectoryLimitExceededException(inner),
                crate::error::CreateMicrosoftADErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::CreateMicrosoftADErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::CreateMicrosoftADErrorKind::UnsupportedOperationException(inner) => {
                    Error::UnsupportedOperationException(inner)
                }
                crate::error::CreateMicrosoftADErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateSnapshotError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateSnapshotError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateSnapshotErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::CreateSnapshotErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::CreateSnapshotErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::CreateSnapshotErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::CreateSnapshotErrorKind::SnapshotLimitExceededException(inner) => {
                    Error::SnapshotLimitExceededException(inner)
                }
                crate::error::CreateSnapshotErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateTrustError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateTrustError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateTrustErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::CreateTrustErrorKind::EntityAlreadyExistsException(inner) => {
                    Error::EntityAlreadyExistsException(inner)
                }
                crate::error::CreateTrustErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::CreateTrustErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::CreateTrustErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::CreateTrustErrorKind::UnsupportedOperationException(inner) => {
                    Error::UnsupportedOperationException(inner)
                }
                crate::error::CreateTrustErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteConditionalForwarderError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteConditionalForwarderError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteConditionalForwarderErrorKind::ClientException(inner) => Error::ClientException(inner),
                crate::error::DeleteConditionalForwarderErrorKind::DirectoryUnavailableException(inner) => Error::DirectoryUnavailableException(inner),
                crate::error::DeleteConditionalForwarderErrorKind::EntityDoesNotExistException(inner) => Error::EntityDoesNotExistException(inner),
                crate::error::DeleteConditionalForwarderErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::DeleteConditionalForwarderErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::DeleteConditionalForwarderErrorKind::UnsupportedOperationException(inner) => Error::UnsupportedOperationException(inner),
                crate::error::DeleteConditionalForwarderErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDirectoryError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteDirectoryError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteDirectoryErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DeleteDirectoryErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::DeleteDirectoryErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DeleteDirectoryErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteLogSubscriptionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteLogSubscriptionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteLogSubscriptionErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DeleteLogSubscriptionErrorKind::EntityDoesNotExistException(
                    inner,
                ) => Error::EntityDoesNotExistException(inner),
                crate::error::DeleteLogSubscriptionErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DeleteLogSubscriptionErrorKind::UnsupportedOperationException(
                    inner,
                ) => Error::UnsupportedOperationException(inner),
                crate::error::DeleteLogSubscriptionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteSnapshotError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteSnapshotError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteSnapshotErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DeleteSnapshotErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::DeleteSnapshotErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DeleteSnapshotErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DeleteSnapshotErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteTrustError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteTrustError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteTrustErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DeleteTrustErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::DeleteTrustErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DeleteTrustErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DeleteTrustErrorKind::UnsupportedOperationException(inner) => {
                    Error::UnsupportedOperationException(inner)
                }
                crate::error::DeleteTrustErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeregisterCertificateError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeregisterCertificateError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeregisterCertificateErrorKind::CertificateDoesNotExistException(
                    inner,
                ) => Error::CertificateDoesNotExistException(inner),
                crate::error::DeregisterCertificateErrorKind::CertificateInUseException(inner) => {
                    Error::CertificateInUseException(inner)
                }
                crate::error::DeregisterCertificateErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DeregisterCertificateErrorKind::DirectoryDoesNotExistException(
                    inner,
                ) => Error::DirectoryDoesNotExistException(inner),
                crate::error::DeregisterCertificateErrorKind::DirectoryUnavailableException(
                    inner,
                ) => Error::DirectoryUnavailableException(inner),
                crate::error::DeregisterCertificateErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DeregisterCertificateErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DeregisterCertificateErrorKind::UnsupportedOperationException(
                    inner,
                ) => Error::UnsupportedOperationException(inner),
                crate::error::DeregisterCertificateErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeregisterEventTopicError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeregisterEventTopicError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeregisterEventTopicErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DeregisterEventTopicErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::DeregisterEventTopicErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DeregisterEventTopicErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DeregisterEventTopicErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeCertificateError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeCertificateError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeCertificateErrorKind::CertificateDoesNotExistException(
                    inner,
                ) => Error::CertificateDoesNotExistException(inner),
                crate::error::DescribeCertificateErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DescribeCertificateErrorKind::DirectoryDoesNotExistException(
                    inner,
                ) => Error::DirectoryDoesNotExistException(inner),
                crate::error::DescribeCertificateErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DescribeCertificateErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DescribeCertificateErrorKind::UnsupportedOperationException(
                    inner,
                ) => Error::UnsupportedOperationException(inner),
                crate::error::DescribeCertificateErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeClientAuthenticationSettingsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeClientAuthenticationSettingsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeClientAuthenticationSettingsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DescribeClientAuthenticationSettingsErrorKind::ClientException(inner) => Error::ClientException(inner),
                crate::error::DescribeClientAuthenticationSettingsErrorKind::DirectoryDoesNotExistException(inner) => Error::DirectoryDoesNotExistException(inner),
                crate::error::DescribeClientAuthenticationSettingsErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::DescribeClientAuthenticationSettingsErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::DescribeClientAuthenticationSettingsErrorKind::UnsupportedOperationException(inner) => Error::UnsupportedOperationException(inner),
                crate::error::DescribeClientAuthenticationSettingsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeConditionalForwardersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeConditionalForwardersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeConditionalForwardersErrorKind::ClientException(inner) => Error::ClientException(inner),
                crate::error::DescribeConditionalForwardersErrorKind::DirectoryUnavailableException(inner) => Error::DirectoryUnavailableException(inner),
                crate::error::DescribeConditionalForwardersErrorKind::EntityDoesNotExistException(inner) => Error::EntityDoesNotExistException(inner),
                crate::error::DescribeConditionalForwardersErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::DescribeConditionalForwardersErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::DescribeConditionalForwardersErrorKind::UnsupportedOperationException(inner) => Error::UnsupportedOperationException(inner),
                crate::error::DescribeConditionalForwardersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDirectoriesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDirectoriesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDirectoriesErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DescribeDirectoriesErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::DescribeDirectoriesErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::DescribeDirectoriesErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DescribeDirectoriesErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DescribeDirectoriesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDomainControllersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDomainControllersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDomainControllersErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DescribeDomainControllersErrorKind::EntityDoesNotExistException(
                    inner,
                ) => Error::EntityDoesNotExistException(inner),
                crate::error::DescribeDomainControllersErrorKind::InvalidNextTokenException(
                    inner,
                ) => Error::InvalidNextTokenException(inner),
                crate::error::DescribeDomainControllersErrorKind::InvalidParameterException(
                    inner,
                ) => Error::InvalidParameterException(inner),
                crate::error::DescribeDomainControllersErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DescribeDomainControllersErrorKind::UnsupportedOperationException(
                    inner,
                ) => Error::UnsupportedOperationException(inner),
                crate::error::DescribeDomainControllersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeEventTopicsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeEventTopicsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEventTopicsErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DescribeEventTopicsErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::DescribeEventTopicsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DescribeEventTopicsErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DescribeEventTopicsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeLDAPSSettingsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeLDAPSSettingsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeLDAPSSettingsErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DescribeLDAPSSettingsErrorKind::DirectoryDoesNotExistException(
                    inner,
                ) => Error::DirectoryDoesNotExistException(inner),
                crate::error::DescribeLDAPSSettingsErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::DescribeLDAPSSettingsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DescribeLDAPSSettingsErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DescribeLDAPSSettingsErrorKind::UnsupportedOperationException(
                    inner,
                ) => Error::UnsupportedOperationException(inner),
                crate::error::DescribeLDAPSSettingsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeRegionsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeRegionsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeRegionsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DescribeRegionsErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DescribeRegionsErrorKind::DirectoryDoesNotExistException(inner) => {
                    Error::DirectoryDoesNotExistException(inner)
                }
                crate::error::DescribeRegionsErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::DescribeRegionsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DescribeRegionsErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DescribeRegionsErrorKind::UnsupportedOperationException(inner) => {
                    Error::UnsupportedOperationException(inner)
                }
                crate::error::DescribeRegionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeSharedDirectoriesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeSharedDirectoriesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeSharedDirectoriesErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DescribeSharedDirectoriesErrorKind::EntityDoesNotExistException(
                    inner,
                ) => Error::EntityDoesNotExistException(inner),
                crate::error::DescribeSharedDirectoriesErrorKind::InvalidNextTokenException(
                    inner,
                ) => Error::InvalidNextTokenException(inner),
                crate::error::DescribeSharedDirectoriesErrorKind::InvalidParameterException(
                    inner,
                ) => Error::InvalidParameterException(inner),
                crate::error::DescribeSharedDirectoriesErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DescribeSharedDirectoriesErrorKind::UnsupportedOperationException(
                    inner,
                ) => Error::UnsupportedOperationException(inner),
                crate::error::DescribeSharedDirectoriesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeSnapshotsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeSnapshotsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeSnapshotsErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DescribeSnapshotsErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::DescribeSnapshotsErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::DescribeSnapshotsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DescribeSnapshotsErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DescribeSnapshotsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeTrustsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeTrustsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeTrustsErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DescribeTrustsErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::DescribeTrustsErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::DescribeTrustsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DescribeTrustsErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DescribeTrustsErrorKind::UnsupportedOperationException(inner) => {
                    Error::UnsupportedOperationException(inner)
                }
                crate::error::DescribeTrustsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DisableClientAuthenticationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DisableClientAuthenticationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DisableClientAuthenticationErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DisableClientAuthenticationErrorKind::ClientException(inner) => Error::ClientException(inner),
                crate::error::DisableClientAuthenticationErrorKind::DirectoryDoesNotExistException(inner) => Error::DirectoryDoesNotExistException(inner),
                crate::error::DisableClientAuthenticationErrorKind::InvalidClientAuthStatusException(inner) => Error::InvalidClientAuthStatusException(inner),
                crate::error::DisableClientAuthenticationErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::DisableClientAuthenticationErrorKind::UnsupportedOperationException(inner) => Error::UnsupportedOperationException(inner),
                crate::error::DisableClientAuthenticationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DisableLDAPSError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DisableLDAPSError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DisableLDAPSErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DisableLDAPSErrorKind::DirectoryDoesNotExistException(inner) => {
                    Error::DirectoryDoesNotExistException(inner)
                }
                crate::error::DisableLDAPSErrorKind::DirectoryUnavailableException(inner) => {
                    Error::DirectoryUnavailableException(inner)
                }
                crate::error::DisableLDAPSErrorKind::InvalidLdapsStatusException(inner) => {
                    Error::InvalidLdapsStatusException(inner)
                }
                crate::error::DisableLDAPSErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DisableLDAPSErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DisableLDAPSErrorKind::UnsupportedOperationException(inner) => {
                    Error::UnsupportedOperationException(inner)
                }
                crate::error::DisableLDAPSErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DisableRadiusError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DisableRadiusError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DisableRadiusErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DisableRadiusErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::DisableRadiusErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DisableRadiusErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DisableSsoError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DisableSsoError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DisableSsoErrorKind::AuthenticationFailedException(inner) => {
                    Error::AuthenticationFailedException(inner)
                }
                crate::error::DisableSsoErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DisableSsoErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::DisableSsoErrorKind::InsufficientPermissionsException(inner) => {
                    Error::InsufficientPermissionsException(inner)
                }
                crate::error::DisableSsoErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DisableSsoErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::EnableClientAuthenticationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::EnableClientAuthenticationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::EnableClientAuthenticationErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::EnableClientAuthenticationErrorKind::ClientException(inner) => Error::ClientException(inner),
                crate::error::EnableClientAuthenticationErrorKind::DirectoryDoesNotExistException(inner) => Error::DirectoryDoesNotExistException(inner),
                crate::error::EnableClientAuthenticationErrorKind::InvalidClientAuthStatusException(inner) => Error::InvalidClientAuthStatusException(inner),
                crate::error::EnableClientAuthenticationErrorKind::NoAvailableCertificateException(inner) => Error::NoAvailableCertificateException(inner),
                crate::error::EnableClientAuthenticationErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::EnableClientAuthenticationErrorKind::UnsupportedOperationException(inner) => Error::UnsupportedOperationException(inner),
                crate::error::EnableClientAuthenticationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::EnableLDAPSError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::EnableLDAPSError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::EnableLDAPSErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::EnableLDAPSErrorKind::DirectoryDoesNotExistException(inner) => {
                    Error::DirectoryDoesNotExistException(inner)
                }
                crate::error::EnableLDAPSErrorKind::DirectoryUnavailableException(inner) => {
                    Error::DirectoryUnavailableException(inner)
                }
                crate::error::EnableLDAPSErrorKind::InvalidLdapsStatusException(inner) => {
                    Error::InvalidLdapsStatusException(inner)
                }
                crate::error::EnableLDAPSErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::EnableLDAPSErrorKind::NoAvailableCertificateException(inner) => {
                    Error::NoAvailableCertificateException(inner)
                }
                crate::error::EnableLDAPSErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::EnableLDAPSErrorKind::UnsupportedOperationException(inner) => {
                    Error::UnsupportedOperationException(inner)
                }
                crate::error::EnableLDAPSErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::EnableRadiusError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::EnableRadiusError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::EnableRadiusErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::EnableRadiusErrorKind::EntityAlreadyExistsException(inner) => {
                    Error::EntityAlreadyExistsException(inner)
                }
                crate::error::EnableRadiusErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::EnableRadiusErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::EnableRadiusErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::EnableRadiusErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::EnableSsoError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::EnableSsoError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::EnableSsoErrorKind::AuthenticationFailedException(inner) => {
                    Error::AuthenticationFailedException(inner)
                }
                crate::error::EnableSsoErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::EnableSsoErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::EnableSsoErrorKind::InsufficientPermissionsException(inner) => {
                    Error::InsufficientPermissionsException(inner)
                }
                crate::error::EnableSsoErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::EnableSsoErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDirectoryLimitsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetDirectoryLimitsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetDirectoryLimitsErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::GetDirectoryLimitsErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::GetDirectoryLimitsErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetDirectoryLimitsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetSnapshotLimitsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetSnapshotLimitsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetSnapshotLimitsErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::GetSnapshotLimitsErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::GetSnapshotLimitsErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetSnapshotLimitsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListCertificatesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListCertificatesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListCertificatesErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::ListCertificatesErrorKind::DirectoryDoesNotExistException(inner) => {
                    Error::DirectoryDoesNotExistException(inner)
                }
                crate::error::ListCertificatesErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListCertificatesErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListCertificatesErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::ListCertificatesErrorKind::UnsupportedOperationException(inner) => {
                    Error::UnsupportedOperationException(inner)
                }
                crate::error::ListCertificatesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListIpRoutesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListIpRoutesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListIpRoutesErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::ListIpRoutesErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::ListIpRoutesErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListIpRoutesErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListIpRoutesErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::ListIpRoutesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListLogSubscriptionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListLogSubscriptionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListLogSubscriptionsErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::ListLogSubscriptionsErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::ListLogSubscriptionsErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListLogSubscriptionsErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::ListLogSubscriptionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListSchemaExtensionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListSchemaExtensionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListSchemaExtensionsErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::ListSchemaExtensionsErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::ListSchemaExtensionsErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListSchemaExtensionsErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::ListSchemaExtensionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsForResourceErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RegisterCertificateError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RegisterCertificateError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RegisterCertificateErrorKind::CertificateAlreadyExistsException(
                    inner,
                ) => Error::CertificateAlreadyExistsException(inner),
                crate::error::RegisterCertificateErrorKind::CertificateLimitExceededException(
                    inner,
                ) => Error::CertificateLimitExceededException(inner),
                crate::error::RegisterCertificateErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::RegisterCertificateErrorKind::DirectoryDoesNotExistException(
                    inner,
                ) => Error::DirectoryDoesNotExistException(inner),
                crate::error::RegisterCertificateErrorKind::DirectoryUnavailableException(
                    inner,
                ) => Error::DirectoryUnavailableException(inner),
                crate::error::RegisterCertificateErrorKind::InvalidCertificateException(inner) => {
                    Error::InvalidCertificateException(inner)
                }
                crate::error::RegisterCertificateErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::RegisterCertificateErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::RegisterCertificateErrorKind::UnsupportedOperationException(
                    inner,
                ) => Error::UnsupportedOperationException(inner),
                crate::error::RegisterCertificateErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RegisterEventTopicError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RegisterEventTopicError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RegisterEventTopicErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::RegisterEventTopicErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::RegisterEventTopicErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::RegisterEventTopicErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::RegisterEventTopicErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RejectSharedDirectoryError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RejectSharedDirectoryError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RejectSharedDirectoryErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::RejectSharedDirectoryErrorKind::DirectoryAlreadySharedException(
                    inner,
                ) => Error::DirectoryAlreadySharedException(inner),
                crate::error::RejectSharedDirectoryErrorKind::EntityDoesNotExistException(
                    inner,
                ) => Error::EntityDoesNotExistException(inner),
                crate::error::RejectSharedDirectoryErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::RejectSharedDirectoryErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::RejectSharedDirectoryErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RemoveIpRoutesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::RemoveIpRoutesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RemoveIpRoutesErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::RemoveIpRoutesErrorKind::DirectoryUnavailableException(inner) => {
                    Error::DirectoryUnavailableException(inner)
                }
                crate::error::RemoveIpRoutesErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::RemoveIpRoutesErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::RemoveIpRoutesErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::RemoveIpRoutesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RemoveRegionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::RemoveRegionError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RemoveRegionErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::RemoveRegionErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::RemoveRegionErrorKind::DirectoryDoesNotExistException(inner) => {
                    Error::DirectoryDoesNotExistException(inner)
                }
                crate::error::RemoveRegionErrorKind::DirectoryUnavailableException(inner) => {
                    Error::DirectoryUnavailableException(inner)
                }
                crate::error::RemoveRegionErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::RemoveRegionErrorKind::UnsupportedOperationException(inner) => {
                    Error::UnsupportedOperationException(inner)
                }
                crate::error::RemoveRegionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RemoveTagsFromResourceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RemoveTagsFromResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RemoveTagsFromResourceErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::RemoveTagsFromResourceErrorKind::EntityDoesNotExistException(
                    inner,
                ) => Error::EntityDoesNotExistException(inner),
                crate::error::RemoveTagsFromResourceErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::RemoveTagsFromResourceErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::RemoveTagsFromResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ResetUserPasswordError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ResetUserPasswordError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ResetUserPasswordErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::ResetUserPasswordErrorKind::DirectoryUnavailableException(inner) => {
                    Error::DirectoryUnavailableException(inner)
                }
                crate::error::ResetUserPasswordErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::ResetUserPasswordErrorKind::InvalidPasswordException(inner) => {
                    Error::InvalidPasswordException(inner)
                }
                crate::error::ResetUserPasswordErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::ResetUserPasswordErrorKind::UnsupportedOperationException(inner) => {
                    Error::UnsupportedOperationException(inner)
                }
                crate::error::ResetUserPasswordErrorKind::UserDoesNotExistException(inner) => {
                    Error::UserDoesNotExistException(inner)
                }
                crate::error::ResetUserPasswordErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RestoreFromSnapshotError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RestoreFromSnapshotError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RestoreFromSnapshotErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::RestoreFromSnapshotErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::RestoreFromSnapshotErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::RestoreFromSnapshotErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::RestoreFromSnapshotErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ShareDirectoryError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ShareDirectoryError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ShareDirectoryErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ShareDirectoryErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::ShareDirectoryErrorKind::DirectoryAlreadySharedException(inner) => {
                    Error::DirectoryAlreadySharedException(inner)
                }
                crate::error::ShareDirectoryErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::ShareDirectoryErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ShareDirectoryErrorKind::InvalidTargetException(inner) => {
                    Error::InvalidTargetException(inner)
                }
                crate::error::ShareDirectoryErrorKind::OrganizationsException(inner) => {
                    Error::OrganizationsException(inner)
                }
                crate::error::ShareDirectoryErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::ShareDirectoryErrorKind::ShareLimitExceededException(inner) => {
                    Error::ShareLimitExceededException(inner)
                }
                crate::error::ShareDirectoryErrorKind::UnsupportedOperationException(inner) => {
                    Error::UnsupportedOperationException(inner)
                }
                crate::error::ShareDirectoryErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartSchemaExtensionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartSchemaExtensionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartSchemaExtensionErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::StartSchemaExtensionErrorKind::DirectoryUnavailableException(
                    inner,
                ) => Error::DirectoryUnavailableException(inner),
                crate::error::StartSchemaExtensionErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::StartSchemaExtensionErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::StartSchemaExtensionErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::StartSchemaExtensionErrorKind::SnapshotLimitExceededException(
                    inner,
                ) => Error::SnapshotLimitExceededException(inner),
                crate::error::StartSchemaExtensionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UnshareDirectoryError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UnshareDirectoryError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UnshareDirectoryErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::UnshareDirectoryErrorKind::DirectoryNotSharedException(inner) => {
                    Error::DirectoryNotSharedException(inner)
                }
                crate::error::UnshareDirectoryErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::UnshareDirectoryErrorKind::InvalidTargetException(inner) => {
                    Error::InvalidTargetException(inner)
                }
                crate::error::UnshareDirectoryErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::UnshareDirectoryErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateConditionalForwarderError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateConditionalForwarderError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateConditionalForwarderErrorKind::ClientException(inner) => Error::ClientException(inner),
                crate::error::UpdateConditionalForwarderErrorKind::DirectoryUnavailableException(inner) => Error::DirectoryUnavailableException(inner),
                crate::error::UpdateConditionalForwarderErrorKind::EntityDoesNotExistException(inner) => Error::EntityDoesNotExistException(inner),
                crate::error::UpdateConditionalForwarderErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::UpdateConditionalForwarderErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::UpdateConditionalForwarderErrorKind::UnsupportedOperationException(inner) => Error::UnsupportedOperationException(inner),
                crate::error::UpdateConditionalForwarderErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::UpdateNumberOfDomainControllersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::UpdateNumberOfDomainControllersError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateNumberOfDomainControllersErrorKind::ClientException(inner) => Error::ClientException(inner),
                crate::error::UpdateNumberOfDomainControllersErrorKind::DirectoryUnavailableException(inner) => Error::DirectoryUnavailableException(inner),
                crate::error::UpdateNumberOfDomainControllersErrorKind::DomainControllerLimitExceededException(inner) => Error::DomainControllerLimitExceededException(inner),
                crate::error::UpdateNumberOfDomainControllersErrorKind::EntityDoesNotExistException(inner) => Error::EntityDoesNotExistException(inner),
                crate::error::UpdateNumberOfDomainControllersErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::UpdateNumberOfDomainControllersErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::UpdateNumberOfDomainControllersErrorKind::UnsupportedOperationException(inner) => Error::UnsupportedOperationException(inner),
                crate::error::UpdateNumberOfDomainControllersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateRadiusError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateRadiusError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateRadiusErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::UpdateRadiusErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::UpdateRadiusErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::UpdateRadiusErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::UpdateRadiusErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateTrustError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateTrustError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateTrustErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::UpdateTrustErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::UpdateTrustErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::UpdateTrustErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::UpdateTrustErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::VerifyTrustError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::VerifyTrustError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::VerifyTrustErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::VerifyTrustErrorKind::EntityDoesNotExistException(inner) => {
                    Error::EntityDoesNotExistException(inner)
                }
                crate::error::VerifyTrustErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::VerifyTrustErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::VerifyTrustErrorKind::UnsupportedOperationException(inner) => {
                    Error::UnsupportedOperationException(inner)
                }
                crate::error::VerifyTrustErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
