// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AcceptSharedDirectory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AcceptSharedDirectoryError {
    /// Kind of error that occurred.
    pub kind: AcceptSharedDirectoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AcceptSharedDirectory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AcceptSharedDirectoryErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified directory has already been shared with this Amazon Web Services account.</p>
    DirectoryAlreadySharedException(crate::error::DirectoryAlreadySharedException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AcceptSharedDirectoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AcceptSharedDirectoryErrorKind::ClientException(_inner) => _inner.fmt(f),
            AcceptSharedDirectoryErrorKind::DirectoryAlreadySharedException(_inner) => {
                _inner.fmt(f)
            }
            AcceptSharedDirectoryErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            AcceptSharedDirectoryErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AcceptSharedDirectoryErrorKind::ServiceException(_inner) => _inner.fmt(f),
            AcceptSharedDirectoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AcceptSharedDirectoryError {
    fn code(&self) -> Option<&str> {
        AcceptSharedDirectoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AcceptSharedDirectoryError {
    /// Creates a new `AcceptSharedDirectoryError`.
    pub fn new(kind: AcceptSharedDirectoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AcceptSharedDirectoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AcceptSharedDirectoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AcceptSharedDirectoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AcceptSharedDirectoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AcceptSharedDirectoryErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptSharedDirectoryErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptSharedDirectoryErrorKind::DirectoryAlreadySharedException`.
    pub fn is_directory_already_shared_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptSharedDirectoryErrorKind::DirectoryAlreadySharedException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptSharedDirectoryErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptSharedDirectoryErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptSharedDirectoryErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptSharedDirectoryErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptSharedDirectoryErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptSharedDirectoryErrorKind::ServiceException(_)
        )
    }
}
impl std::error::Error for AcceptSharedDirectoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AcceptSharedDirectoryErrorKind::ClientException(_inner) => Some(_inner),
            AcceptSharedDirectoryErrorKind::DirectoryAlreadySharedException(_inner) => Some(_inner),
            AcceptSharedDirectoryErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            AcceptSharedDirectoryErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AcceptSharedDirectoryErrorKind::ServiceException(_inner) => Some(_inner),
            AcceptSharedDirectoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AddIpRoutes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddIpRoutesError {
    /// Kind of error that occurred.
    pub kind: AddIpRoutesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddIpRoutes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddIpRoutesErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified directory is unavailable or could not be found.</p>
    DirectoryUnavailableException(crate::error::DirectoryUnavailableException),
    /// <p>The specified entity already exists.</p>
    EntityAlreadyExistsException(crate::error::EntityAlreadyExistsException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The maximum allowed number of IP addresses was exceeded. The default limit is 100 IP
    /// address blocks.</p>
    IpRouteLimitExceededException(crate::error::IpRouteLimitExceededException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddIpRoutesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddIpRoutesErrorKind::ClientException(_inner) => _inner.fmt(f),
            AddIpRoutesErrorKind::DirectoryUnavailableException(_inner) => _inner.fmt(f),
            AddIpRoutesErrorKind::EntityAlreadyExistsException(_inner) => _inner.fmt(f),
            AddIpRoutesErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            AddIpRoutesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AddIpRoutesErrorKind::IpRouteLimitExceededException(_inner) => _inner.fmt(f),
            AddIpRoutesErrorKind::ServiceException(_inner) => _inner.fmt(f),
            AddIpRoutesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddIpRoutesError {
    fn code(&self) -> Option<&str> {
        AddIpRoutesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddIpRoutesError {
    /// Creates a new `AddIpRoutesError`.
    pub fn new(kind: AddIpRoutesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddIpRoutesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddIpRoutesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddIpRoutesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddIpRoutesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddIpRoutesErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, AddIpRoutesErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `AddIpRoutesErrorKind::DirectoryUnavailableException`.
    pub fn is_directory_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddIpRoutesErrorKind::DirectoryUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `AddIpRoutesErrorKind::EntityAlreadyExistsException`.
    pub fn is_entity_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddIpRoutesErrorKind::EntityAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `AddIpRoutesErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddIpRoutesErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `AddIpRoutesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddIpRoutesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AddIpRoutesErrorKind::IpRouteLimitExceededException`.
    pub fn is_ip_route_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddIpRoutesErrorKind::IpRouteLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AddIpRoutesErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, AddIpRoutesErrorKind::ServiceException(_))
    }
}
impl std::error::Error for AddIpRoutesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddIpRoutesErrorKind::ClientException(_inner) => Some(_inner),
            AddIpRoutesErrorKind::DirectoryUnavailableException(_inner) => Some(_inner),
            AddIpRoutesErrorKind::EntityAlreadyExistsException(_inner) => Some(_inner),
            AddIpRoutesErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            AddIpRoutesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AddIpRoutesErrorKind::IpRouteLimitExceededException(_inner) => Some(_inner),
            AddIpRoutesErrorKind::ServiceException(_inner) => Some(_inner),
            AddIpRoutesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AddRegion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddRegionError {
    /// Kind of error that occurred.
    pub kind: AddRegionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddRegion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddRegionErrorKind {
    /// <p>Client authentication is not available in this region at this time.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The Region you specified is the same Region where the Managed Microsoft AD directory
    /// was created. Specify a different Region and try again.</p>
    DirectoryAlreadyInRegionException(crate::error::DirectoryAlreadyInRegionException),
    /// <p>The specified directory does not exist in the system.</p>
    DirectoryDoesNotExistException(crate::error::DirectoryDoesNotExistException),
    /// <p>The specified directory is unavailable or could not be found.</p>
    DirectoryUnavailableException(crate::error::DirectoryUnavailableException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>You have reached the limit for maximum number of simultaneous Region replications per
    /// directory.</p>
    RegionLimitExceededException(crate::error::RegionLimitExceededException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddRegionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddRegionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AddRegionErrorKind::ClientException(_inner) => _inner.fmt(f),
            AddRegionErrorKind::DirectoryAlreadyInRegionException(_inner) => _inner.fmt(f),
            AddRegionErrorKind::DirectoryDoesNotExistException(_inner) => _inner.fmt(f),
            AddRegionErrorKind::DirectoryUnavailableException(_inner) => _inner.fmt(f),
            AddRegionErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            AddRegionErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AddRegionErrorKind::RegionLimitExceededException(_inner) => _inner.fmt(f),
            AddRegionErrorKind::ServiceException(_inner) => _inner.fmt(f),
            AddRegionErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            AddRegionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddRegionError {
    fn code(&self) -> Option<&str> {
        AddRegionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddRegionError {
    /// Creates a new `AddRegionError`.
    pub fn new(kind: AddRegionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddRegionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddRegionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddRegionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddRegionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddRegionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, AddRegionErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `AddRegionErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, AddRegionErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `AddRegionErrorKind::DirectoryAlreadyInRegionException`.
    pub fn is_directory_already_in_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddRegionErrorKind::DirectoryAlreadyInRegionException(_)
        )
    }
    /// Returns `true` if the error kind is `AddRegionErrorKind::DirectoryDoesNotExistException`.
    pub fn is_directory_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddRegionErrorKind::DirectoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `AddRegionErrorKind::DirectoryUnavailableException`.
    pub fn is_directory_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddRegionErrorKind::DirectoryUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `AddRegionErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddRegionErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `AddRegionErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(&self.kind, AddRegionErrorKind::InvalidParameterException(_))
    }
    /// Returns `true` if the error kind is `AddRegionErrorKind::RegionLimitExceededException`.
    pub fn is_region_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddRegionErrorKind::RegionLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AddRegionErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, AddRegionErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `AddRegionErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddRegionErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for AddRegionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddRegionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AddRegionErrorKind::ClientException(_inner) => Some(_inner),
            AddRegionErrorKind::DirectoryAlreadyInRegionException(_inner) => Some(_inner),
            AddRegionErrorKind::DirectoryDoesNotExistException(_inner) => Some(_inner),
            AddRegionErrorKind::DirectoryUnavailableException(_inner) => Some(_inner),
            AddRegionErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            AddRegionErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AddRegionErrorKind::RegionLimitExceededException(_inner) => Some(_inner),
            AddRegionErrorKind::ServiceException(_inner) => Some(_inner),
            AddRegionErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            AddRegionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AddTagsToResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddTagsToResourceError {
    /// Kind of error that occurred.
    pub kind: AddTagsToResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddTagsToResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddTagsToResourceErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The maximum allowed number of tags was exceeded.</p>
    TagLimitExceededException(crate::error::TagLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddTagsToResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddTagsToResourceErrorKind::ClientException(_inner) => _inner.fmt(f),
            AddTagsToResourceErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            AddTagsToResourceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AddTagsToResourceErrorKind::ServiceException(_inner) => _inner.fmt(f),
            AddTagsToResourceErrorKind::TagLimitExceededException(_inner) => _inner.fmt(f),
            AddTagsToResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddTagsToResourceError {
    fn code(&self) -> Option<&str> {
        AddTagsToResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddTagsToResourceError {
    /// Creates a new `AddTagsToResourceError`.
    pub fn new(kind: AddTagsToResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddTagsToResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddTagsToResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddTagsToResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddTagsToResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddTagsToResourceErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, AddTagsToResourceErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `AddTagsToResourceErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToResourceErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `AddTagsToResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AddTagsToResourceErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, AddTagsToResourceErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `AddTagsToResourceErrorKind::TagLimitExceededException`.
    pub fn is_tag_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToResourceErrorKind::TagLimitExceededException(_)
        )
    }
}
impl std::error::Error for AddTagsToResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddTagsToResourceErrorKind::ClientException(_inner) => Some(_inner),
            AddTagsToResourceErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            AddTagsToResourceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AddTagsToResourceErrorKind::ServiceException(_inner) => Some(_inner),
            AddTagsToResourceErrorKind::TagLimitExceededException(_inner) => Some(_inner),
            AddTagsToResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelSchemaExtension` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelSchemaExtensionError {
    /// Kind of error that occurred.
    pub kind: CancelSchemaExtensionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelSchemaExtension` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelSchemaExtensionErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelSchemaExtensionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelSchemaExtensionErrorKind::ClientException(_inner) => _inner.fmt(f),
            CancelSchemaExtensionErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            CancelSchemaExtensionErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CancelSchemaExtensionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelSchemaExtensionError {
    fn code(&self) -> Option<&str> {
        CancelSchemaExtensionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelSchemaExtensionError {
    /// Creates a new `CancelSchemaExtensionError`.
    pub fn new(kind: CancelSchemaExtensionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelSchemaExtensionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelSchemaExtensionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelSchemaExtensionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelSchemaExtensionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelSchemaExtensionErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelSchemaExtensionErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelSchemaExtensionErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelSchemaExtensionErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelSchemaExtensionErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelSchemaExtensionErrorKind::ServiceException(_)
        )
    }
}
impl std::error::Error for CancelSchemaExtensionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelSchemaExtensionErrorKind::ClientException(_inner) => Some(_inner),
            CancelSchemaExtensionErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            CancelSchemaExtensionErrorKind::ServiceException(_inner) => Some(_inner),
            CancelSchemaExtensionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ConnectDirectory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ConnectDirectoryError {
    /// Kind of error that occurred.
    pub kind: ConnectDirectoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ConnectDirectory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ConnectDirectoryErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The maximum number of directories in the region has been reached. You can use the
    /// <a>GetDirectoryLimits</a> operation to determine your directory limits in
    /// the region.</p>
    DirectoryLimitExceededException(crate::error::DirectoryLimitExceededException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ConnectDirectoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ConnectDirectoryErrorKind::ClientException(_inner) => _inner.fmt(f),
            ConnectDirectoryErrorKind::DirectoryLimitExceededException(_inner) => _inner.fmt(f),
            ConnectDirectoryErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ConnectDirectoryErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ConnectDirectoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ConnectDirectoryError {
    fn code(&self) -> Option<&str> {
        ConnectDirectoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ConnectDirectoryError {
    /// Creates a new `ConnectDirectoryError`.
    pub fn new(kind: ConnectDirectoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ConnectDirectoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ConnectDirectoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ConnectDirectoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ConnectDirectoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ConnectDirectoryErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, ConnectDirectoryErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `ConnectDirectoryErrorKind::DirectoryLimitExceededException`.
    pub fn is_directory_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConnectDirectoryErrorKind::DirectoryLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ConnectDirectoryErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConnectDirectoryErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ConnectDirectoryErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, ConnectDirectoryErrorKind::ServiceException(_))
    }
}
impl std::error::Error for ConnectDirectoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ConnectDirectoryErrorKind::ClientException(_inner) => Some(_inner),
            ConnectDirectoryErrorKind::DirectoryLimitExceededException(_inner) => Some(_inner),
            ConnectDirectoryErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ConnectDirectoryErrorKind::ServiceException(_inner) => Some(_inner),
            ConnectDirectoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAliasError {
    /// Kind of error that occurred.
    pub kind: CreateAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAliasErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity already exists.</p>
    EntityAlreadyExistsException(crate::error::EntityAlreadyExistsException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAliasErrorKind::ClientException(_inner) => _inner.fmt(f),
            CreateAliasErrorKind::EntityAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateAliasErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            CreateAliasErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateAliasErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAliasError {
    fn code(&self) -> Option<&str> {
        CreateAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAliasError {
    /// Creates a new `CreateAliasError`.
    pub fn new(kind: CreateAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAliasErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAliasErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, CreateAliasErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `CreateAliasErrorKind::EntityAlreadyExistsException`.
    pub fn is_entity_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAliasErrorKind::EntityAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAliasErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAliasErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAliasErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAliasErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAliasErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, CreateAliasErrorKind::ServiceException(_))
    }
}
impl std::error::Error for CreateAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAliasErrorKind::ClientException(_inner) => Some(_inner),
            CreateAliasErrorKind::EntityAlreadyExistsException(_inner) => Some(_inner),
            CreateAliasErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            CreateAliasErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateAliasErrorKind::ServiceException(_inner) => Some(_inner),
            CreateAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateComputer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateComputerError {
    /// Kind of error that occurred.
    pub kind: CreateComputerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateComputer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateComputerErrorKind {
    /// <p>An authentication error occurred.</p>
    AuthenticationFailedException(crate::error::AuthenticationFailedException),
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified directory is unavailable or could not be found.</p>
    DirectoryUnavailableException(crate::error::DirectoryUnavailableException),
    /// <p>The specified entity already exists.</p>
    EntityAlreadyExistsException(crate::error::EntityAlreadyExistsException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateComputerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateComputerErrorKind::AuthenticationFailedException(_inner) => _inner.fmt(f),
            CreateComputerErrorKind::ClientException(_inner) => _inner.fmt(f),
            CreateComputerErrorKind::DirectoryUnavailableException(_inner) => _inner.fmt(f),
            CreateComputerErrorKind::EntityAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateComputerErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            CreateComputerErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateComputerErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateComputerErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            CreateComputerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateComputerError {
    fn code(&self) -> Option<&str> {
        CreateComputerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateComputerError {
    /// Creates a new `CreateComputerError`.
    pub fn new(kind: CreateComputerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateComputerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateComputerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateComputerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateComputerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateComputerErrorKind::AuthenticationFailedException`.
    pub fn is_authentication_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateComputerErrorKind::AuthenticationFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateComputerErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, CreateComputerErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `CreateComputerErrorKind::DirectoryUnavailableException`.
    pub fn is_directory_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateComputerErrorKind::DirectoryUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateComputerErrorKind::EntityAlreadyExistsException`.
    pub fn is_entity_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateComputerErrorKind::EntityAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateComputerErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateComputerErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateComputerErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateComputerErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateComputerErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, CreateComputerErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `CreateComputerErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateComputerErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for CreateComputerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateComputerErrorKind::AuthenticationFailedException(_inner) => Some(_inner),
            CreateComputerErrorKind::ClientException(_inner) => Some(_inner),
            CreateComputerErrorKind::DirectoryUnavailableException(_inner) => Some(_inner),
            CreateComputerErrorKind::EntityAlreadyExistsException(_inner) => Some(_inner),
            CreateComputerErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            CreateComputerErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateComputerErrorKind::ServiceException(_inner) => Some(_inner),
            CreateComputerErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            CreateComputerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateConditionalForwarder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateConditionalForwarderError {
    /// Kind of error that occurred.
    pub kind: CreateConditionalForwarderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateConditionalForwarder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateConditionalForwarderErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified directory is unavailable or could not be found.</p>
    DirectoryUnavailableException(crate::error::DirectoryUnavailableException),
    /// <p>The specified entity already exists.</p>
    EntityAlreadyExistsException(crate::error::EntityAlreadyExistsException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateConditionalForwarderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateConditionalForwarderErrorKind::ClientException(_inner) => _inner.fmt(f),
            CreateConditionalForwarderErrorKind::DirectoryUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            CreateConditionalForwarderErrorKind::EntityAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            CreateConditionalForwarderErrorKind::EntityDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            CreateConditionalForwarderErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateConditionalForwarderErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateConditionalForwarderErrorKind::UnsupportedOperationException(_inner) => {
                _inner.fmt(f)
            }
            CreateConditionalForwarderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateConditionalForwarderError {
    fn code(&self) -> Option<&str> {
        CreateConditionalForwarderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateConditionalForwarderError {
    /// Creates a new `CreateConditionalForwarderError`.
    pub fn new(kind: CreateConditionalForwarderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateConditionalForwarderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateConditionalForwarderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateConditionalForwarderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateConditionalForwarderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateConditionalForwarderErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConditionalForwarderErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConditionalForwarderErrorKind::DirectoryUnavailableException`.
    pub fn is_directory_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConditionalForwarderErrorKind::DirectoryUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConditionalForwarderErrorKind::EntityAlreadyExistsException`.
    pub fn is_entity_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConditionalForwarderErrorKind::EntityAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConditionalForwarderErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConditionalForwarderErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConditionalForwarderErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConditionalForwarderErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConditionalForwarderErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConditionalForwarderErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConditionalForwarderErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConditionalForwarderErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for CreateConditionalForwarderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateConditionalForwarderErrorKind::ClientException(_inner) => Some(_inner),
            CreateConditionalForwarderErrorKind::DirectoryUnavailableException(_inner) => {
                Some(_inner)
            }
            CreateConditionalForwarderErrorKind::EntityAlreadyExistsException(_inner) => {
                Some(_inner)
            }
            CreateConditionalForwarderErrorKind::EntityDoesNotExistException(_inner) => {
                Some(_inner)
            }
            CreateConditionalForwarderErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateConditionalForwarderErrorKind::ServiceException(_inner) => Some(_inner),
            CreateConditionalForwarderErrorKind::UnsupportedOperationException(_inner) => {
                Some(_inner)
            }
            CreateConditionalForwarderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDirectory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDirectoryError {
    /// Kind of error that occurred.
    pub kind: CreateDirectoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDirectory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDirectoryErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The maximum number of directories in the region has been reached. You can use the
    /// <a>GetDirectoryLimits</a> operation to determine your directory limits in
    /// the region.</p>
    DirectoryLimitExceededException(crate::error::DirectoryLimitExceededException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDirectoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDirectoryErrorKind::ClientException(_inner) => _inner.fmt(f),
            CreateDirectoryErrorKind::DirectoryLimitExceededException(_inner) => _inner.fmt(f),
            CreateDirectoryErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateDirectoryErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateDirectoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDirectoryError {
    fn code(&self) -> Option<&str> {
        CreateDirectoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDirectoryError {
    /// Creates a new `CreateDirectoryError`.
    pub fn new(kind: CreateDirectoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDirectoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDirectoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDirectoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDirectoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDirectoryErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, CreateDirectoryErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `CreateDirectoryErrorKind::DirectoryLimitExceededException`.
    pub fn is_directory_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDirectoryErrorKind::DirectoryLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDirectoryErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDirectoryErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDirectoryErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, CreateDirectoryErrorKind::ServiceException(_))
    }
}
impl std::error::Error for CreateDirectoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDirectoryErrorKind::ClientException(_inner) => Some(_inner),
            CreateDirectoryErrorKind::DirectoryLimitExceededException(_inner) => Some(_inner),
            CreateDirectoryErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateDirectoryErrorKind::ServiceException(_inner) => Some(_inner),
            CreateDirectoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateLogSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLogSubscriptionError {
    /// Kind of error that occurred.
    pub kind: CreateLogSubscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLogSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLogSubscriptionErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity already exists.</p>
    EntityAlreadyExistsException(crate::error::EntityAlreadyExistsException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>The account does not have sufficient permission to perform the operation.</p>
    InsufficientPermissionsException(crate::error::InsufficientPermissionsException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLogSubscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLogSubscriptionErrorKind::ClientException(_inner) => _inner.fmt(f),
            CreateLogSubscriptionErrorKind::EntityAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateLogSubscriptionErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            CreateLogSubscriptionErrorKind::InsufficientPermissionsException(_inner) => {
                _inner.fmt(f)
            }
            CreateLogSubscriptionErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateLogSubscriptionErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            CreateLogSubscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLogSubscriptionError {
    fn code(&self) -> Option<&str> {
        CreateLogSubscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLogSubscriptionError {
    /// Creates a new `CreateLogSubscriptionError`.
    pub fn new(kind: CreateLogSubscriptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLogSubscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLogSubscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLogSubscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLogSubscriptionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateLogSubscriptionErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLogSubscriptionErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLogSubscriptionErrorKind::EntityAlreadyExistsException`.
    pub fn is_entity_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLogSubscriptionErrorKind::EntityAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLogSubscriptionErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLogSubscriptionErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLogSubscriptionErrorKind::InsufficientPermissionsException`.
    pub fn is_insufficient_permissions_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLogSubscriptionErrorKind::InsufficientPermissionsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLogSubscriptionErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLogSubscriptionErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLogSubscriptionErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLogSubscriptionErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for CreateLogSubscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLogSubscriptionErrorKind::ClientException(_inner) => Some(_inner),
            CreateLogSubscriptionErrorKind::EntityAlreadyExistsException(_inner) => Some(_inner),
            CreateLogSubscriptionErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            CreateLogSubscriptionErrorKind::InsufficientPermissionsException(_inner) => {
                Some(_inner)
            }
            CreateLogSubscriptionErrorKind::ServiceException(_inner) => Some(_inner),
            CreateLogSubscriptionErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            CreateLogSubscriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateMicrosoftAD` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateMicrosoftADError {
    /// Kind of error that occurred.
    pub kind: CreateMicrosoftADErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateMicrosoftAD` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateMicrosoftADErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The maximum number of directories in the region has been reached. You can use the
    /// <a>GetDirectoryLimits</a> operation to determine your directory limits in
    /// the region.</p>
    DirectoryLimitExceededException(crate::error::DirectoryLimitExceededException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateMicrosoftADError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateMicrosoftADErrorKind::ClientException(_inner) => _inner.fmt(f),
            CreateMicrosoftADErrorKind::DirectoryLimitExceededException(_inner) => _inner.fmt(f),
            CreateMicrosoftADErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateMicrosoftADErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateMicrosoftADErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            CreateMicrosoftADErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateMicrosoftADError {
    fn code(&self) -> Option<&str> {
        CreateMicrosoftADError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateMicrosoftADError {
    /// Creates a new `CreateMicrosoftADError`.
    pub fn new(kind: CreateMicrosoftADErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateMicrosoftADError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateMicrosoftADErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateMicrosoftADError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateMicrosoftADErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateMicrosoftADErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, CreateMicrosoftADErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `CreateMicrosoftADErrorKind::DirectoryLimitExceededException`.
    pub fn is_directory_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMicrosoftADErrorKind::DirectoryLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMicrosoftADErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMicrosoftADErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMicrosoftADErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, CreateMicrosoftADErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `CreateMicrosoftADErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMicrosoftADErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for CreateMicrosoftADError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateMicrosoftADErrorKind::ClientException(_inner) => Some(_inner),
            CreateMicrosoftADErrorKind::DirectoryLimitExceededException(_inner) => Some(_inner),
            CreateMicrosoftADErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateMicrosoftADErrorKind::ServiceException(_inner) => Some(_inner),
            CreateMicrosoftADErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            CreateMicrosoftADErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSnapshotError {
    /// Kind of error that occurred.
    pub kind: CreateSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSnapshotErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The maximum number of manual snapshots for the directory has been reached. You can
    /// use the <a>GetSnapshotLimits</a> operation to determine the snapshot limits
    /// for a directory.</p>
    SnapshotLimitExceededException(crate::error::SnapshotLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSnapshotErrorKind::ClientException(_inner) => _inner.fmt(f),
            CreateSnapshotErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            CreateSnapshotErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateSnapshotErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateSnapshotErrorKind::SnapshotLimitExceededException(_inner) => _inner.fmt(f),
            CreateSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSnapshotError {
    fn code(&self) -> Option<&str> {
        CreateSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSnapshotError {
    /// Creates a new `CreateSnapshotError`.
    pub fn new(kind: CreateSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSnapshotErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, CreateSnapshotErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `CreateSnapshotErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSnapshotErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSnapshotErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSnapshotErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSnapshotErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, CreateSnapshotErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `CreateSnapshotErrorKind::SnapshotLimitExceededException`.
    pub fn is_snapshot_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSnapshotErrorKind::SnapshotLimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSnapshotErrorKind::ClientException(_inner) => Some(_inner),
            CreateSnapshotErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            CreateSnapshotErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateSnapshotErrorKind::ServiceException(_inner) => Some(_inner),
            CreateSnapshotErrorKind::SnapshotLimitExceededException(_inner) => Some(_inner),
            CreateSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTrust` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTrustError {
    /// Kind of error that occurred.
    pub kind: CreateTrustErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTrust` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTrustErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity already exists.</p>
    EntityAlreadyExistsException(crate::error::EntityAlreadyExistsException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTrustError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTrustErrorKind::ClientException(_inner) => _inner.fmt(f),
            CreateTrustErrorKind::EntityAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateTrustErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            CreateTrustErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateTrustErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateTrustErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            CreateTrustErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTrustError {
    fn code(&self) -> Option<&str> {
        CreateTrustError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTrustError {
    /// Creates a new `CreateTrustError`.
    pub fn new(kind: CreateTrustErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTrustError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTrustErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTrustError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTrustErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateTrustErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, CreateTrustErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `CreateTrustErrorKind::EntityAlreadyExistsException`.
    pub fn is_entity_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrustErrorKind::EntityAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrustErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrustErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrustErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrustErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrustErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, CreateTrustErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `CreateTrustErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrustErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for CreateTrustError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTrustErrorKind::ClientException(_inner) => Some(_inner),
            CreateTrustErrorKind::EntityAlreadyExistsException(_inner) => Some(_inner),
            CreateTrustErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            CreateTrustErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateTrustErrorKind::ServiceException(_inner) => Some(_inner),
            CreateTrustErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            CreateTrustErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteConditionalForwarder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteConditionalForwarderError {
    /// Kind of error that occurred.
    pub kind: DeleteConditionalForwarderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteConditionalForwarder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteConditionalForwarderErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified directory is unavailable or could not be found.</p>
    DirectoryUnavailableException(crate::error::DirectoryUnavailableException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteConditionalForwarderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteConditionalForwarderErrorKind::ClientException(_inner) => _inner.fmt(f),
            DeleteConditionalForwarderErrorKind::DirectoryUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DeleteConditionalForwarderErrorKind::EntityDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            DeleteConditionalForwarderErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteConditionalForwarderErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteConditionalForwarderErrorKind::UnsupportedOperationException(_inner) => {
                _inner.fmt(f)
            }
            DeleteConditionalForwarderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteConditionalForwarderError {
    fn code(&self) -> Option<&str> {
        DeleteConditionalForwarderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteConditionalForwarderError {
    /// Creates a new `DeleteConditionalForwarderError`.
    pub fn new(kind: DeleteConditionalForwarderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteConditionalForwarderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteConditionalForwarderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteConditionalForwarderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteConditionalForwarderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteConditionalForwarderErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConditionalForwarderErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConditionalForwarderErrorKind::DirectoryUnavailableException`.
    pub fn is_directory_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConditionalForwarderErrorKind::DirectoryUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConditionalForwarderErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConditionalForwarderErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConditionalForwarderErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConditionalForwarderErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConditionalForwarderErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConditionalForwarderErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConditionalForwarderErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConditionalForwarderErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for DeleteConditionalForwarderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteConditionalForwarderErrorKind::ClientException(_inner) => Some(_inner),
            DeleteConditionalForwarderErrorKind::DirectoryUnavailableException(_inner) => {
                Some(_inner)
            }
            DeleteConditionalForwarderErrorKind::EntityDoesNotExistException(_inner) => {
                Some(_inner)
            }
            DeleteConditionalForwarderErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteConditionalForwarderErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteConditionalForwarderErrorKind::UnsupportedOperationException(_inner) => {
                Some(_inner)
            }
            DeleteConditionalForwarderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDirectory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDirectoryError {
    /// Kind of error that occurred.
    pub kind: DeleteDirectoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDirectory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDirectoryErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDirectoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDirectoryErrorKind::ClientException(_inner) => _inner.fmt(f),
            DeleteDirectoryErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            DeleteDirectoryErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteDirectoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDirectoryError {
    fn code(&self) -> Option<&str> {
        DeleteDirectoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDirectoryError {
    /// Creates a new `DeleteDirectoryError`.
    pub fn new(kind: DeleteDirectoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDirectoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDirectoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDirectoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDirectoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDirectoryErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, DeleteDirectoryErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `DeleteDirectoryErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDirectoryErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDirectoryErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DeleteDirectoryErrorKind::ServiceException(_))
    }
}
impl std::error::Error for DeleteDirectoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDirectoryErrorKind::ClientException(_inner) => Some(_inner),
            DeleteDirectoryErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            DeleteDirectoryErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteDirectoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteLogSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteLogSubscriptionError {
    /// Kind of error that occurred.
    pub kind: DeleteLogSubscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteLogSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteLogSubscriptionErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteLogSubscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteLogSubscriptionErrorKind::ClientException(_inner) => _inner.fmt(f),
            DeleteLogSubscriptionErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            DeleteLogSubscriptionErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteLogSubscriptionErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            DeleteLogSubscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteLogSubscriptionError {
    fn code(&self) -> Option<&str> {
        DeleteLogSubscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteLogSubscriptionError {
    /// Creates a new `DeleteLogSubscriptionError`.
    pub fn new(kind: DeleteLogSubscriptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteLogSubscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteLogSubscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteLogSubscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteLogSubscriptionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteLogSubscriptionErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLogSubscriptionErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLogSubscriptionErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLogSubscriptionErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLogSubscriptionErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLogSubscriptionErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLogSubscriptionErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLogSubscriptionErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for DeleteLogSubscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteLogSubscriptionErrorKind::ClientException(_inner) => Some(_inner),
            DeleteLogSubscriptionErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            DeleteLogSubscriptionErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteLogSubscriptionErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            DeleteLogSubscriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSnapshotError {
    /// Kind of error that occurred.
    pub kind: DeleteSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSnapshotErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSnapshotErrorKind::ClientException(_inner) => _inner.fmt(f),
            DeleteSnapshotErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            DeleteSnapshotErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteSnapshotErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSnapshotError {
    fn code(&self) -> Option<&str> {
        DeleteSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSnapshotError {
    /// Creates a new `DeleteSnapshotError`.
    pub fn new(kind: DeleteSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSnapshotErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, DeleteSnapshotErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `DeleteSnapshotErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSnapshotErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSnapshotErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSnapshotErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSnapshotErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DeleteSnapshotErrorKind::ServiceException(_))
    }
}
impl std::error::Error for DeleteSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSnapshotErrorKind::ClientException(_inner) => Some(_inner),
            DeleteSnapshotErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            DeleteSnapshotErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteSnapshotErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTrust` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTrustError {
    /// Kind of error that occurred.
    pub kind: DeleteTrustErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTrust` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTrustErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTrustError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTrustErrorKind::ClientException(_inner) => _inner.fmt(f),
            DeleteTrustErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            DeleteTrustErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteTrustErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteTrustErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            DeleteTrustErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTrustError {
    fn code(&self) -> Option<&str> {
        DeleteTrustError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTrustError {
    /// Creates a new `DeleteTrustError`.
    pub fn new(kind: DeleteTrustErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTrustError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTrustErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTrustError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTrustErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteTrustErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, DeleteTrustErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `DeleteTrustErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTrustErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTrustErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTrustErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTrustErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DeleteTrustErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `DeleteTrustErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTrustErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for DeleteTrustError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTrustErrorKind::ClientException(_inner) => Some(_inner),
            DeleteTrustErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            DeleteTrustErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteTrustErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteTrustErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            DeleteTrustErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeregisterCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeregisterCertificateError {
    /// Kind of error that occurred.
    pub kind: DeregisterCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeregisterCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeregisterCertificateErrorKind {
    /// <p>The certificate is not present in the system for describe or deregister activities.</p>
    CertificateDoesNotExistException(crate::error::CertificateDoesNotExistException),
    /// <p>The certificate is being used for the LDAP security connection and cannot be removed
    /// without disabling LDAP security.</p>
    CertificateInUseException(crate::error::CertificateInUseException),
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified directory does not exist in the system.</p>
    DirectoryDoesNotExistException(crate::error::DirectoryDoesNotExistException),
    /// <p>The specified directory is unavailable or could not be found.</p>
    DirectoryUnavailableException(crate::error::DirectoryUnavailableException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeregisterCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeregisterCertificateErrorKind::CertificateDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            DeregisterCertificateErrorKind::CertificateInUseException(_inner) => _inner.fmt(f),
            DeregisterCertificateErrorKind::ClientException(_inner) => _inner.fmt(f),
            DeregisterCertificateErrorKind::DirectoryDoesNotExistException(_inner) => _inner.fmt(f),
            DeregisterCertificateErrorKind::DirectoryUnavailableException(_inner) => _inner.fmt(f),
            DeregisterCertificateErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeregisterCertificateErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeregisterCertificateErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            DeregisterCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeregisterCertificateError {
    fn code(&self) -> Option<&str> {
        DeregisterCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeregisterCertificateError {
    /// Creates a new `DeregisterCertificateError`.
    pub fn new(kind: DeregisterCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeregisterCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeregisterCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeregisterCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeregisterCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeregisterCertificateErrorKind::CertificateDoesNotExistException`.
    pub fn is_certificate_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterCertificateErrorKind::CertificateDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterCertificateErrorKind::CertificateInUseException`.
    pub fn is_certificate_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterCertificateErrorKind::CertificateInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterCertificateErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterCertificateErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterCertificateErrorKind::DirectoryDoesNotExistException`.
    pub fn is_directory_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterCertificateErrorKind::DirectoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterCertificateErrorKind::DirectoryUnavailableException`.
    pub fn is_directory_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterCertificateErrorKind::DirectoryUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterCertificateErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterCertificateErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterCertificateErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterCertificateErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterCertificateErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterCertificateErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for DeregisterCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeregisterCertificateErrorKind::CertificateDoesNotExistException(_inner) => {
                Some(_inner)
            }
            DeregisterCertificateErrorKind::CertificateInUseException(_inner) => Some(_inner),
            DeregisterCertificateErrorKind::ClientException(_inner) => Some(_inner),
            DeregisterCertificateErrorKind::DirectoryDoesNotExistException(_inner) => Some(_inner),
            DeregisterCertificateErrorKind::DirectoryUnavailableException(_inner) => Some(_inner),
            DeregisterCertificateErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeregisterCertificateErrorKind::ServiceException(_inner) => Some(_inner),
            DeregisterCertificateErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            DeregisterCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeregisterEventTopic` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeregisterEventTopicError {
    /// Kind of error that occurred.
    pub kind: DeregisterEventTopicErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeregisterEventTopic` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeregisterEventTopicErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeregisterEventTopicError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeregisterEventTopicErrorKind::ClientException(_inner) => _inner.fmt(f),
            DeregisterEventTopicErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            DeregisterEventTopicErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeregisterEventTopicErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeregisterEventTopicErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeregisterEventTopicError {
    fn code(&self) -> Option<&str> {
        DeregisterEventTopicError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeregisterEventTopicError {
    /// Creates a new `DeregisterEventTopicError`.
    pub fn new(kind: DeregisterEventTopicErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeregisterEventTopicError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeregisterEventTopicErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeregisterEventTopicError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeregisterEventTopicErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeregisterEventTopicErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterEventTopicErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterEventTopicErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterEventTopicErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterEventTopicErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterEventTopicErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterEventTopicErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterEventTopicErrorKind::ServiceException(_)
        )
    }
}
impl std::error::Error for DeregisterEventTopicError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeregisterEventTopicErrorKind::ClientException(_inner) => Some(_inner),
            DeregisterEventTopicErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            DeregisterEventTopicErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeregisterEventTopicErrorKind::ServiceException(_inner) => Some(_inner),
            DeregisterEventTopicErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeCertificateError {
    /// Kind of error that occurred.
    pub kind: DescribeCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeCertificateErrorKind {
    /// <p>The certificate is not present in the system for describe or deregister activities.</p>
    CertificateDoesNotExistException(crate::error::CertificateDoesNotExistException),
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified directory does not exist in the system.</p>
    DirectoryDoesNotExistException(crate::error::DirectoryDoesNotExistException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeCertificateErrorKind::CertificateDoesNotExistException(_inner) => _inner.fmt(f),
            DescribeCertificateErrorKind::ClientException(_inner) => _inner.fmt(f),
            DescribeCertificateErrorKind::DirectoryDoesNotExistException(_inner) => _inner.fmt(f),
            DescribeCertificateErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeCertificateErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DescribeCertificateErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            DescribeCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeCertificateError {
    fn code(&self) -> Option<&str> {
        DescribeCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeCertificateError {
    /// Creates a new `DescribeCertificateError`.
    pub fn new(kind: DescribeCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeCertificateErrorKind::CertificateDoesNotExistException`.
    pub fn is_certificate_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCertificateErrorKind::CertificateDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCertificateErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, DescribeCertificateErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `DescribeCertificateErrorKind::DirectoryDoesNotExistException`.
    pub fn is_directory_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCertificateErrorKind::DirectoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCertificateErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCertificateErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCertificateErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCertificateErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCertificateErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCertificateErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for DescribeCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeCertificateErrorKind::CertificateDoesNotExistException(_inner) => Some(_inner),
            DescribeCertificateErrorKind::ClientException(_inner) => Some(_inner),
            DescribeCertificateErrorKind::DirectoryDoesNotExistException(_inner) => Some(_inner),
            DescribeCertificateErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeCertificateErrorKind::ServiceException(_inner) => Some(_inner),
            DescribeCertificateErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            DescribeCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeClientAuthenticationSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeClientAuthenticationSettingsError {
    /// Kind of error that occurred.
    pub kind: DescribeClientAuthenticationSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeClientAuthenticationSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeClientAuthenticationSettingsErrorKind {
    /// <p>Client authentication is not available in this region at this time.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified directory does not exist in the system.</p>
    DirectoryDoesNotExistException(crate::error::DirectoryDoesNotExistException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeClientAuthenticationSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeClientAuthenticationSettingsErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeClientAuthenticationSettingsErrorKind::ClientException(_inner) => _inner.fmt(f),
            DescribeClientAuthenticationSettingsErrorKind::DirectoryDoesNotExistException(
                _inner,
            ) => _inner.fmt(f),
            DescribeClientAuthenticationSettingsErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DescribeClientAuthenticationSettingsErrorKind::ServiceException(_inner) => {
                _inner.fmt(f)
            }
            DescribeClientAuthenticationSettingsErrorKind::UnsupportedOperationException(
                _inner,
            ) => _inner.fmt(f),
            DescribeClientAuthenticationSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeClientAuthenticationSettingsError {
    fn code(&self) -> Option<&str> {
        DescribeClientAuthenticationSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeClientAuthenticationSettingsError {
    /// Creates a new `DescribeClientAuthenticationSettingsError`.
    pub fn new(
        kind: DescribeClientAuthenticationSettingsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeClientAuthenticationSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeClientAuthenticationSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeClientAuthenticationSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeClientAuthenticationSettingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeClientAuthenticationSettingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClientAuthenticationSettingsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeClientAuthenticationSettingsErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClientAuthenticationSettingsErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeClientAuthenticationSettingsErrorKind::DirectoryDoesNotExistException`.
    pub fn is_directory_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClientAuthenticationSettingsErrorKind::DirectoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeClientAuthenticationSettingsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClientAuthenticationSettingsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeClientAuthenticationSettingsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClientAuthenticationSettingsErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeClientAuthenticationSettingsErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClientAuthenticationSettingsErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for DescribeClientAuthenticationSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeClientAuthenticationSettingsErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DescribeClientAuthenticationSettingsErrorKind::ClientException(_inner) => Some(_inner),
            DescribeClientAuthenticationSettingsErrorKind::DirectoryDoesNotExistException(
                _inner,
            ) => Some(_inner),
            DescribeClientAuthenticationSettingsErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            DescribeClientAuthenticationSettingsErrorKind::ServiceException(_inner) => Some(_inner),
            DescribeClientAuthenticationSettingsErrorKind::UnsupportedOperationException(
                _inner,
            ) => Some(_inner),
            DescribeClientAuthenticationSettingsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeConditionalForwarders` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeConditionalForwardersError {
    /// Kind of error that occurred.
    pub kind: DescribeConditionalForwardersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeConditionalForwarders` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeConditionalForwardersErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified directory is unavailable or could not be found.</p>
    DirectoryUnavailableException(crate::error::DirectoryUnavailableException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeConditionalForwardersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeConditionalForwardersErrorKind::ClientException(_inner) => _inner.fmt(f),
            DescribeConditionalForwardersErrorKind::DirectoryUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DescribeConditionalForwardersErrorKind::EntityDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            DescribeConditionalForwardersErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DescribeConditionalForwardersErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DescribeConditionalForwardersErrorKind::UnsupportedOperationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeConditionalForwardersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeConditionalForwardersError {
    fn code(&self) -> Option<&str> {
        DescribeConditionalForwardersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeConditionalForwardersError {
    /// Creates a new `DescribeConditionalForwardersError`.
    pub fn new(
        kind: DescribeConditionalForwardersErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeConditionalForwardersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeConditionalForwardersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeConditionalForwardersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeConditionalForwardersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeConditionalForwardersErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConditionalForwardersErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConditionalForwardersErrorKind::DirectoryUnavailableException`.
    pub fn is_directory_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConditionalForwardersErrorKind::DirectoryUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConditionalForwardersErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConditionalForwardersErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConditionalForwardersErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConditionalForwardersErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConditionalForwardersErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConditionalForwardersErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConditionalForwardersErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConditionalForwardersErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for DescribeConditionalForwardersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeConditionalForwardersErrorKind::ClientException(_inner) => Some(_inner),
            DescribeConditionalForwardersErrorKind::DirectoryUnavailableException(_inner) => {
                Some(_inner)
            }
            DescribeConditionalForwardersErrorKind::EntityDoesNotExistException(_inner) => {
                Some(_inner)
            }
            DescribeConditionalForwardersErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            DescribeConditionalForwardersErrorKind::ServiceException(_inner) => Some(_inner),
            DescribeConditionalForwardersErrorKind::UnsupportedOperationException(_inner) => {
                Some(_inner)
            }
            DescribeConditionalForwardersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDirectories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDirectoriesError {
    /// Kind of error that occurred.
    pub kind: DescribeDirectoriesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDirectories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDirectoriesErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>The <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDirectoriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDirectoriesErrorKind::ClientException(_inner) => _inner.fmt(f),
            DescribeDirectoriesErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            DescribeDirectoriesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            DescribeDirectoriesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeDirectoriesErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DescribeDirectoriesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDirectoriesError {
    fn code(&self) -> Option<&str> {
        DescribeDirectoriesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDirectoriesError {
    /// Creates a new `DescribeDirectoriesError`.
    pub fn new(kind: DescribeDirectoriesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDirectoriesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDirectoriesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDirectoriesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDirectoriesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDirectoriesErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, DescribeDirectoriesErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `DescribeDirectoriesErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDirectoriesErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDirectoriesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDirectoriesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDirectoriesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDirectoriesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDirectoriesErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDirectoriesErrorKind::ServiceException(_)
        )
    }
}
impl std::error::Error for DescribeDirectoriesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDirectoriesErrorKind::ClientException(_inner) => Some(_inner),
            DescribeDirectoriesErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            DescribeDirectoriesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            DescribeDirectoriesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeDirectoriesErrorKind::ServiceException(_inner) => Some(_inner),
            DescribeDirectoriesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDomainControllers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDomainControllersError {
    /// Kind of error that occurred.
    pub kind: DescribeDomainControllersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDomainControllers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDomainControllersErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>The <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDomainControllersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDomainControllersErrorKind::ClientException(_inner) => _inner.fmt(f),
            DescribeDomainControllersErrorKind::EntityDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDomainControllersErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            DescribeDomainControllersErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeDomainControllersErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DescribeDomainControllersErrorKind::UnsupportedOperationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDomainControllersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDomainControllersError {
    fn code(&self) -> Option<&str> {
        DescribeDomainControllersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDomainControllersError {
    /// Creates a new `DescribeDomainControllersError`.
    pub fn new(kind: DescribeDomainControllersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDomainControllersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDomainControllersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDomainControllersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDomainControllersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDomainControllersErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainControllersErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDomainControllersErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainControllersErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDomainControllersErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainControllersErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDomainControllersErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainControllersErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDomainControllersErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainControllersErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDomainControllersErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainControllersErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for DescribeDomainControllersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDomainControllersErrorKind::ClientException(_inner) => Some(_inner),
            DescribeDomainControllersErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            DescribeDomainControllersErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            DescribeDomainControllersErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeDomainControllersErrorKind::ServiceException(_inner) => Some(_inner),
            DescribeDomainControllersErrorKind::UnsupportedOperationException(_inner) => {
                Some(_inner)
            }
            DescribeDomainControllersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEventTopics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEventTopicsError {
    /// Kind of error that occurred.
    pub kind: DescribeEventTopicsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEventTopics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEventTopicsErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEventTopicsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEventTopicsErrorKind::ClientException(_inner) => _inner.fmt(f),
            DescribeEventTopicsErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            DescribeEventTopicsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeEventTopicsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DescribeEventTopicsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEventTopicsError {
    fn code(&self) -> Option<&str> {
        DescribeEventTopicsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEventTopicsError {
    /// Creates a new `DescribeEventTopicsError`.
    pub fn new(kind: DescribeEventTopicsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEventTopicsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEventTopicsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEventTopicsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEventTopicsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeEventTopicsErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, DescribeEventTopicsErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `DescribeEventTopicsErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventTopicsErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEventTopicsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventTopicsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEventTopicsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventTopicsErrorKind::ServiceException(_)
        )
    }
}
impl std::error::Error for DescribeEventTopicsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEventTopicsErrorKind::ClientException(_inner) => Some(_inner),
            DescribeEventTopicsErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            DescribeEventTopicsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeEventTopicsErrorKind::ServiceException(_inner) => Some(_inner),
            DescribeEventTopicsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeLDAPSSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLDAPSSettingsError {
    /// Kind of error that occurred.
    pub kind: DescribeLDAPSSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLDAPSSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLDAPSSettingsErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified directory does not exist in the system.</p>
    DirectoryDoesNotExistException(crate::error::DirectoryDoesNotExistException),
    /// <p>The <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLDAPSSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLDAPSSettingsErrorKind::ClientException(_inner) => _inner.fmt(f),
            DescribeLDAPSSettingsErrorKind::DirectoryDoesNotExistException(_inner) => _inner.fmt(f),
            DescribeLDAPSSettingsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            DescribeLDAPSSettingsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeLDAPSSettingsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DescribeLDAPSSettingsErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            DescribeLDAPSSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLDAPSSettingsError {
    fn code(&self) -> Option<&str> {
        DescribeLDAPSSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLDAPSSettingsError {
    /// Creates a new `DescribeLDAPSSettingsError`.
    pub fn new(kind: DescribeLDAPSSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLDAPSSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLDAPSSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLDAPSSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLDAPSSettingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeLDAPSSettingsErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLDAPSSettingsErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLDAPSSettingsErrorKind::DirectoryDoesNotExistException`.
    pub fn is_directory_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLDAPSSettingsErrorKind::DirectoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLDAPSSettingsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLDAPSSettingsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLDAPSSettingsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLDAPSSettingsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLDAPSSettingsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLDAPSSettingsErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLDAPSSettingsErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLDAPSSettingsErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for DescribeLDAPSSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLDAPSSettingsErrorKind::ClientException(_inner) => Some(_inner),
            DescribeLDAPSSettingsErrorKind::DirectoryDoesNotExistException(_inner) => Some(_inner),
            DescribeLDAPSSettingsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            DescribeLDAPSSettingsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeLDAPSSettingsErrorKind::ServiceException(_inner) => Some(_inner),
            DescribeLDAPSSettingsErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            DescribeLDAPSSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeRegions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeRegionsError {
    /// Kind of error that occurred.
    pub kind: DescribeRegionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeRegions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeRegionsErrorKind {
    /// <p>Client authentication is not available in this region at this time.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified directory does not exist in the system.</p>
    DirectoryDoesNotExistException(crate::error::DirectoryDoesNotExistException),
    /// <p>The <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeRegionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeRegionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeRegionsErrorKind::ClientException(_inner) => _inner.fmt(f),
            DescribeRegionsErrorKind::DirectoryDoesNotExistException(_inner) => _inner.fmt(f),
            DescribeRegionsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            DescribeRegionsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeRegionsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DescribeRegionsErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            DescribeRegionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeRegionsError {
    fn code(&self) -> Option<&str> {
        DescribeRegionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeRegionsError {
    /// Creates a new `DescribeRegionsError`.
    pub fn new(kind: DescribeRegionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeRegionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeRegionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeRegionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeRegionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeRegionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRegionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRegionsErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, DescribeRegionsErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `DescribeRegionsErrorKind::DirectoryDoesNotExistException`.
    pub fn is_directory_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRegionsErrorKind::DirectoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRegionsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRegionsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRegionsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRegionsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRegionsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DescribeRegionsErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `DescribeRegionsErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRegionsErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for DescribeRegionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeRegionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeRegionsErrorKind::ClientException(_inner) => Some(_inner),
            DescribeRegionsErrorKind::DirectoryDoesNotExistException(_inner) => Some(_inner),
            DescribeRegionsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            DescribeRegionsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeRegionsErrorKind::ServiceException(_inner) => Some(_inner),
            DescribeRegionsErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            DescribeRegionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSharedDirectories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSharedDirectoriesError {
    /// Kind of error that occurred.
    pub kind: DescribeSharedDirectoriesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSharedDirectories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSharedDirectoriesErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>The <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSharedDirectoriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSharedDirectoriesErrorKind::ClientException(_inner) => _inner.fmt(f),
            DescribeSharedDirectoriesErrorKind::EntityDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            DescribeSharedDirectoriesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            DescribeSharedDirectoriesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeSharedDirectoriesErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DescribeSharedDirectoriesErrorKind::UnsupportedOperationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeSharedDirectoriesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSharedDirectoriesError {
    fn code(&self) -> Option<&str> {
        DescribeSharedDirectoriesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSharedDirectoriesError {
    /// Creates a new `DescribeSharedDirectoriesError`.
    pub fn new(kind: DescribeSharedDirectoriesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSharedDirectoriesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSharedDirectoriesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSharedDirectoriesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSharedDirectoriesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeSharedDirectoriesErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSharedDirectoriesErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSharedDirectoriesErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSharedDirectoriesErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSharedDirectoriesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSharedDirectoriesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSharedDirectoriesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSharedDirectoriesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSharedDirectoriesErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSharedDirectoriesErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSharedDirectoriesErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSharedDirectoriesErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for DescribeSharedDirectoriesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSharedDirectoriesErrorKind::ClientException(_inner) => Some(_inner),
            DescribeSharedDirectoriesErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            DescribeSharedDirectoriesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            DescribeSharedDirectoriesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeSharedDirectoriesErrorKind::ServiceException(_inner) => Some(_inner),
            DescribeSharedDirectoriesErrorKind::UnsupportedOperationException(_inner) => {
                Some(_inner)
            }
            DescribeSharedDirectoriesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSnapshotsError {
    /// Kind of error that occurred.
    pub kind: DescribeSnapshotsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSnapshotsErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>The <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSnapshotsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSnapshotsErrorKind::ClientException(_inner) => _inner.fmt(f),
            DescribeSnapshotsErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            DescribeSnapshotsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            DescribeSnapshotsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeSnapshotsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DescribeSnapshotsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSnapshotsError {
    fn code(&self) -> Option<&str> {
        DescribeSnapshotsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSnapshotsError {
    /// Creates a new `DescribeSnapshotsError`.
    pub fn new(kind: DescribeSnapshotsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSnapshotsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSnapshotsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSnapshotsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSnapshotsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeSnapshotsErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, DescribeSnapshotsErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `DescribeSnapshotsErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSnapshotsErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSnapshotsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSnapshotsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSnapshotsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSnapshotsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSnapshotsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DescribeSnapshotsErrorKind::ServiceException(_))
    }
}
impl std::error::Error for DescribeSnapshotsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSnapshotsErrorKind::ClientException(_inner) => Some(_inner),
            DescribeSnapshotsErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            DescribeSnapshotsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            DescribeSnapshotsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeSnapshotsErrorKind::ServiceException(_inner) => Some(_inner),
            DescribeSnapshotsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTrusts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTrustsError {
    /// Kind of error that occurred.
    pub kind: DescribeTrustsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTrusts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTrustsErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>The <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTrustsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTrustsErrorKind::ClientException(_inner) => _inner.fmt(f),
            DescribeTrustsErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            DescribeTrustsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            DescribeTrustsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeTrustsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DescribeTrustsErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            DescribeTrustsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTrustsError {
    fn code(&self) -> Option<&str> {
        DescribeTrustsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTrustsError {
    /// Creates a new `DescribeTrustsError`.
    pub fn new(kind: DescribeTrustsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTrustsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTrustsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTrustsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTrustsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTrustsErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, DescribeTrustsErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `DescribeTrustsErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTrustsErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTrustsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTrustsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTrustsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTrustsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTrustsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DescribeTrustsErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `DescribeTrustsErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTrustsErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for DescribeTrustsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTrustsErrorKind::ClientException(_inner) => Some(_inner),
            DescribeTrustsErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            DescribeTrustsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            DescribeTrustsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeTrustsErrorKind::ServiceException(_inner) => Some(_inner),
            DescribeTrustsErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            DescribeTrustsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisableClientAuthentication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableClientAuthenticationError {
    /// Kind of error that occurred.
    pub kind: DisableClientAuthenticationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableClientAuthentication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableClientAuthenticationErrorKind {
    /// <p>Client authentication is not available in this region at this time.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified directory does not exist in the system.</p>
    DirectoryDoesNotExistException(crate::error::DirectoryDoesNotExistException),
    /// <p>Client authentication is already enabled.</p>
    InvalidClientAuthStatusException(crate::error::InvalidClientAuthStatusException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableClientAuthenticationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableClientAuthenticationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DisableClientAuthenticationErrorKind::ClientException(_inner) => _inner.fmt(f),
            DisableClientAuthenticationErrorKind::DirectoryDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            DisableClientAuthenticationErrorKind::InvalidClientAuthStatusException(_inner) => {
                _inner.fmt(f)
            }
            DisableClientAuthenticationErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DisableClientAuthenticationErrorKind::UnsupportedOperationException(_inner) => {
                _inner.fmt(f)
            }
            DisableClientAuthenticationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableClientAuthenticationError {
    fn code(&self) -> Option<&str> {
        DisableClientAuthenticationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisableClientAuthenticationError {
    /// Creates a new `DisableClientAuthenticationError`.
    pub fn new(kind: DisableClientAuthenticationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableClientAuthenticationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableClientAuthenticationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableClientAuthenticationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableClientAuthenticationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisableClientAuthenticationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableClientAuthenticationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableClientAuthenticationErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableClientAuthenticationErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableClientAuthenticationErrorKind::DirectoryDoesNotExistException`.
    pub fn is_directory_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableClientAuthenticationErrorKind::DirectoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableClientAuthenticationErrorKind::InvalidClientAuthStatusException`.
    pub fn is_invalid_client_auth_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableClientAuthenticationErrorKind::InvalidClientAuthStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableClientAuthenticationErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableClientAuthenticationErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableClientAuthenticationErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableClientAuthenticationErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for DisableClientAuthenticationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableClientAuthenticationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisableClientAuthenticationErrorKind::ClientException(_inner) => Some(_inner),
            DisableClientAuthenticationErrorKind::DirectoryDoesNotExistException(_inner) => {
                Some(_inner)
            }
            DisableClientAuthenticationErrorKind::InvalidClientAuthStatusException(_inner) => {
                Some(_inner)
            }
            DisableClientAuthenticationErrorKind::ServiceException(_inner) => Some(_inner),
            DisableClientAuthenticationErrorKind::UnsupportedOperationException(_inner) => {
                Some(_inner)
            }
            DisableClientAuthenticationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisableLDAPS` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableLDAPSError {
    /// Kind of error that occurred.
    pub kind: DisableLDAPSErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableLDAPS` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableLDAPSErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified directory does not exist in the system.</p>
    DirectoryDoesNotExistException(crate::error::DirectoryDoesNotExistException),
    /// <p>The specified directory is unavailable or could not be found.</p>
    DirectoryUnavailableException(crate::error::DirectoryUnavailableException),
    /// <p>The LDAP activities could not be performed because they are limited by the LDAPS
    /// status.</p>
    InvalidLdapsStatusException(crate::error::InvalidLdapsStatusException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableLDAPSError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableLDAPSErrorKind::ClientException(_inner) => _inner.fmt(f),
            DisableLDAPSErrorKind::DirectoryDoesNotExistException(_inner) => _inner.fmt(f),
            DisableLDAPSErrorKind::DirectoryUnavailableException(_inner) => _inner.fmt(f),
            DisableLDAPSErrorKind::InvalidLdapsStatusException(_inner) => _inner.fmt(f),
            DisableLDAPSErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DisableLDAPSErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DisableLDAPSErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            DisableLDAPSErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableLDAPSError {
    fn code(&self) -> Option<&str> {
        DisableLDAPSError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisableLDAPSError {
    /// Creates a new `DisableLDAPSError`.
    pub fn new(kind: DisableLDAPSErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableLDAPSError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableLDAPSErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableLDAPSError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableLDAPSErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisableLDAPSErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, DisableLDAPSErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `DisableLDAPSErrorKind::DirectoryDoesNotExistException`.
    pub fn is_directory_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableLDAPSErrorKind::DirectoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableLDAPSErrorKind::DirectoryUnavailableException`.
    pub fn is_directory_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableLDAPSErrorKind::DirectoryUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableLDAPSErrorKind::InvalidLdapsStatusException`.
    pub fn is_invalid_ldaps_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableLDAPSErrorKind::InvalidLdapsStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableLDAPSErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableLDAPSErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableLDAPSErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DisableLDAPSErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `DisableLDAPSErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableLDAPSErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for DisableLDAPSError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableLDAPSErrorKind::ClientException(_inner) => Some(_inner),
            DisableLDAPSErrorKind::DirectoryDoesNotExistException(_inner) => Some(_inner),
            DisableLDAPSErrorKind::DirectoryUnavailableException(_inner) => Some(_inner),
            DisableLDAPSErrorKind::InvalidLdapsStatusException(_inner) => Some(_inner),
            DisableLDAPSErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DisableLDAPSErrorKind::ServiceException(_inner) => Some(_inner),
            DisableLDAPSErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            DisableLDAPSErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisableRadius` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableRadiusError {
    /// Kind of error that occurred.
    pub kind: DisableRadiusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableRadius` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableRadiusErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableRadiusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableRadiusErrorKind::ClientException(_inner) => _inner.fmt(f),
            DisableRadiusErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            DisableRadiusErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DisableRadiusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableRadiusError {
    fn code(&self) -> Option<&str> {
        DisableRadiusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisableRadiusError {
    /// Creates a new `DisableRadiusError`.
    pub fn new(kind: DisableRadiusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableRadiusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableRadiusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableRadiusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableRadiusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisableRadiusErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, DisableRadiusErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `DisableRadiusErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableRadiusErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableRadiusErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DisableRadiusErrorKind::ServiceException(_))
    }
}
impl std::error::Error for DisableRadiusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableRadiusErrorKind::ClientException(_inner) => Some(_inner),
            DisableRadiusErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            DisableRadiusErrorKind::ServiceException(_inner) => Some(_inner),
            DisableRadiusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisableSso` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableSsoError {
    /// Kind of error that occurred.
    pub kind: DisableSsoErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableSso` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableSsoErrorKind {
    /// <p>An authentication error occurred.</p>
    AuthenticationFailedException(crate::error::AuthenticationFailedException),
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>The account does not have sufficient permission to perform the operation.</p>
    InsufficientPermissionsException(crate::error::InsufficientPermissionsException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableSsoError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableSsoErrorKind::AuthenticationFailedException(_inner) => _inner.fmt(f),
            DisableSsoErrorKind::ClientException(_inner) => _inner.fmt(f),
            DisableSsoErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            DisableSsoErrorKind::InsufficientPermissionsException(_inner) => _inner.fmt(f),
            DisableSsoErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DisableSsoErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableSsoError {
    fn code(&self) -> Option<&str> {
        DisableSsoError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisableSsoError {
    /// Creates a new `DisableSsoError`.
    pub fn new(kind: DisableSsoErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableSsoError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableSsoErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableSsoError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableSsoErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisableSsoErrorKind::AuthenticationFailedException`.
    pub fn is_authentication_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableSsoErrorKind::AuthenticationFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableSsoErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, DisableSsoErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `DisableSsoErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableSsoErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableSsoErrorKind::InsufficientPermissionsException`.
    pub fn is_insufficient_permissions_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableSsoErrorKind::InsufficientPermissionsException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableSsoErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DisableSsoErrorKind::ServiceException(_))
    }
}
impl std::error::Error for DisableSsoError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableSsoErrorKind::AuthenticationFailedException(_inner) => Some(_inner),
            DisableSsoErrorKind::ClientException(_inner) => Some(_inner),
            DisableSsoErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            DisableSsoErrorKind::InsufficientPermissionsException(_inner) => Some(_inner),
            DisableSsoErrorKind::ServiceException(_inner) => Some(_inner),
            DisableSsoErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnableClientAuthentication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableClientAuthenticationError {
    /// Kind of error that occurred.
    pub kind: EnableClientAuthenticationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableClientAuthentication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableClientAuthenticationErrorKind {
    /// <p>Client authentication is not available in this region at this time.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified directory does not exist in the system.</p>
    DirectoryDoesNotExistException(crate::error::DirectoryDoesNotExistException),
    /// <p>Client authentication is already enabled.</p>
    InvalidClientAuthStatusException(crate::error::InvalidClientAuthStatusException),
    /// <p>Client authentication setup could not be completed because at least one valid certificate must be
    /// registered in the system.</p>
    NoAvailableCertificateException(crate::error::NoAvailableCertificateException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableClientAuthenticationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableClientAuthenticationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            EnableClientAuthenticationErrorKind::ClientException(_inner) => _inner.fmt(f),
            EnableClientAuthenticationErrorKind::DirectoryDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            EnableClientAuthenticationErrorKind::InvalidClientAuthStatusException(_inner) => {
                _inner.fmt(f)
            }
            EnableClientAuthenticationErrorKind::NoAvailableCertificateException(_inner) => {
                _inner.fmt(f)
            }
            EnableClientAuthenticationErrorKind::ServiceException(_inner) => _inner.fmt(f),
            EnableClientAuthenticationErrorKind::UnsupportedOperationException(_inner) => {
                _inner.fmt(f)
            }
            EnableClientAuthenticationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableClientAuthenticationError {
    fn code(&self) -> Option<&str> {
        EnableClientAuthenticationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableClientAuthenticationError {
    /// Creates a new `EnableClientAuthenticationError`.
    pub fn new(kind: EnableClientAuthenticationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableClientAuthenticationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableClientAuthenticationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableClientAuthenticationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableClientAuthenticationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnableClientAuthenticationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableClientAuthenticationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableClientAuthenticationErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableClientAuthenticationErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableClientAuthenticationErrorKind::DirectoryDoesNotExistException`.
    pub fn is_directory_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableClientAuthenticationErrorKind::DirectoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableClientAuthenticationErrorKind::InvalidClientAuthStatusException`.
    pub fn is_invalid_client_auth_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableClientAuthenticationErrorKind::InvalidClientAuthStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableClientAuthenticationErrorKind::NoAvailableCertificateException`.
    pub fn is_no_available_certificate_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableClientAuthenticationErrorKind::NoAvailableCertificateException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableClientAuthenticationErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableClientAuthenticationErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableClientAuthenticationErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableClientAuthenticationErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for EnableClientAuthenticationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableClientAuthenticationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            EnableClientAuthenticationErrorKind::ClientException(_inner) => Some(_inner),
            EnableClientAuthenticationErrorKind::DirectoryDoesNotExistException(_inner) => {
                Some(_inner)
            }
            EnableClientAuthenticationErrorKind::InvalidClientAuthStatusException(_inner) => {
                Some(_inner)
            }
            EnableClientAuthenticationErrorKind::NoAvailableCertificateException(_inner) => {
                Some(_inner)
            }
            EnableClientAuthenticationErrorKind::ServiceException(_inner) => Some(_inner),
            EnableClientAuthenticationErrorKind::UnsupportedOperationException(_inner) => {
                Some(_inner)
            }
            EnableClientAuthenticationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnableLDAPS` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableLDAPSError {
    /// Kind of error that occurred.
    pub kind: EnableLDAPSErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableLDAPS` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableLDAPSErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified directory does not exist in the system.</p>
    DirectoryDoesNotExistException(crate::error::DirectoryDoesNotExistException),
    /// <p>The specified directory is unavailable or could not be found.</p>
    DirectoryUnavailableException(crate::error::DirectoryUnavailableException),
    /// <p>The LDAP activities could not be performed because they are limited by the LDAPS
    /// status.</p>
    InvalidLdapsStatusException(crate::error::InvalidLdapsStatusException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Client authentication setup could not be completed because at least one valid certificate must be
    /// registered in the system.</p>
    NoAvailableCertificateException(crate::error::NoAvailableCertificateException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableLDAPSError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableLDAPSErrorKind::ClientException(_inner) => _inner.fmt(f),
            EnableLDAPSErrorKind::DirectoryDoesNotExistException(_inner) => _inner.fmt(f),
            EnableLDAPSErrorKind::DirectoryUnavailableException(_inner) => _inner.fmt(f),
            EnableLDAPSErrorKind::InvalidLdapsStatusException(_inner) => _inner.fmt(f),
            EnableLDAPSErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            EnableLDAPSErrorKind::NoAvailableCertificateException(_inner) => _inner.fmt(f),
            EnableLDAPSErrorKind::ServiceException(_inner) => _inner.fmt(f),
            EnableLDAPSErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            EnableLDAPSErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableLDAPSError {
    fn code(&self) -> Option<&str> {
        EnableLDAPSError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableLDAPSError {
    /// Creates a new `EnableLDAPSError`.
    pub fn new(kind: EnableLDAPSErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableLDAPSError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableLDAPSErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableLDAPSError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableLDAPSErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnableLDAPSErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, EnableLDAPSErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `EnableLDAPSErrorKind::DirectoryDoesNotExistException`.
    pub fn is_directory_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableLDAPSErrorKind::DirectoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableLDAPSErrorKind::DirectoryUnavailableException`.
    pub fn is_directory_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableLDAPSErrorKind::DirectoryUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableLDAPSErrorKind::InvalidLdapsStatusException`.
    pub fn is_invalid_ldaps_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableLDAPSErrorKind::InvalidLdapsStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableLDAPSErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableLDAPSErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableLDAPSErrorKind::NoAvailableCertificateException`.
    pub fn is_no_available_certificate_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableLDAPSErrorKind::NoAvailableCertificateException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableLDAPSErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, EnableLDAPSErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `EnableLDAPSErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableLDAPSErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for EnableLDAPSError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableLDAPSErrorKind::ClientException(_inner) => Some(_inner),
            EnableLDAPSErrorKind::DirectoryDoesNotExistException(_inner) => Some(_inner),
            EnableLDAPSErrorKind::DirectoryUnavailableException(_inner) => Some(_inner),
            EnableLDAPSErrorKind::InvalidLdapsStatusException(_inner) => Some(_inner),
            EnableLDAPSErrorKind::InvalidParameterException(_inner) => Some(_inner),
            EnableLDAPSErrorKind::NoAvailableCertificateException(_inner) => Some(_inner),
            EnableLDAPSErrorKind::ServiceException(_inner) => Some(_inner),
            EnableLDAPSErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            EnableLDAPSErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnableRadius` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableRadiusError {
    /// Kind of error that occurred.
    pub kind: EnableRadiusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableRadius` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableRadiusErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity already exists.</p>
    EntityAlreadyExistsException(crate::error::EntityAlreadyExistsException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableRadiusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableRadiusErrorKind::ClientException(_inner) => _inner.fmt(f),
            EnableRadiusErrorKind::EntityAlreadyExistsException(_inner) => _inner.fmt(f),
            EnableRadiusErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            EnableRadiusErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            EnableRadiusErrorKind::ServiceException(_inner) => _inner.fmt(f),
            EnableRadiusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableRadiusError {
    fn code(&self) -> Option<&str> {
        EnableRadiusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableRadiusError {
    /// Creates a new `EnableRadiusError`.
    pub fn new(kind: EnableRadiusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableRadiusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableRadiusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableRadiusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableRadiusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnableRadiusErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, EnableRadiusErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `EnableRadiusErrorKind::EntityAlreadyExistsException`.
    pub fn is_entity_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableRadiusErrorKind::EntityAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableRadiusErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableRadiusErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableRadiusErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableRadiusErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableRadiusErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, EnableRadiusErrorKind::ServiceException(_))
    }
}
impl std::error::Error for EnableRadiusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableRadiusErrorKind::ClientException(_inner) => Some(_inner),
            EnableRadiusErrorKind::EntityAlreadyExistsException(_inner) => Some(_inner),
            EnableRadiusErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            EnableRadiusErrorKind::InvalidParameterException(_inner) => Some(_inner),
            EnableRadiusErrorKind::ServiceException(_inner) => Some(_inner),
            EnableRadiusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnableSso` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableSsoError {
    /// Kind of error that occurred.
    pub kind: EnableSsoErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableSso` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableSsoErrorKind {
    /// <p>An authentication error occurred.</p>
    AuthenticationFailedException(crate::error::AuthenticationFailedException),
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>The account does not have sufficient permission to perform the operation.</p>
    InsufficientPermissionsException(crate::error::InsufficientPermissionsException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableSsoError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableSsoErrorKind::AuthenticationFailedException(_inner) => _inner.fmt(f),
            EnableSsoErrorKind::ClientException(_inner) => _inner.fmt(f),
            EnableSsoErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            EnableSsoErrorKind::InsufficientPermissionsException(_inner) => _inner.fmt(f),
            EnableSsoErrorKind::ServiceException(_inner) => _inner.fmt(f),
            EnableSsoErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableSsoError {
    fn code(&self) -> Option<&str> {
        EnableSsoError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableSsoError {
    /// Creates a new `EnableSsoError`.
    pub fn new(kind: EnableSsoErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableSsoError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableSsoErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableSsoError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableSsoErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnableSsoErrorKind::AuthenticationFailedException`.
    pub fn is_authentication_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableSsoErrorKind::AuthenticationFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableSsoErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, EnableSsoErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `EnableSsoErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableSsoErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableSsoErrorKind::InsufficientPermissionsException`.
    pub fn is_insufficient_permissions_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableSsoErrorKind::InsufficientPermissionsException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableSsoErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, EnableSsoErrorKind::ServiceException(_))
    }
}
impl std::error::Error for EnableSsoError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableSsoErrorKind::AuthenticationFailedException(_inner) => Some(_inner),
            EnableSsoErrorKind::ClientException(_inner) => Some(_inner),
            EnableSsoErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            EnableSsoErrorKind::InsufficientPermissionsException(_inner) => Some(_inner),
            EnableSsoErrorKind::ServiceException(_inner) => Some(_inner),
            EnableSsoErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDirectoryLimits` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDirectoryLimitsError {
    /// Kind of error that occurred.
    pub kind: GetDirectoryLimitsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDirectoryLimits` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDirectoryLimitsErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDirectoryLimitsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDirectoryLimitsErrorKind::ClientException(_inner) => _inner.fmt(f),
            GetDirectoryLimitsErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            GetDirectoryLimitsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetDirectoryLimitsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDirectoryLimitsError {
    fn code(&self) -> Option<&str> {
        GetDirectoryLimitsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDirectoryLimitsError {
    /// Creates a new `GetDirectoryLimitsError`.
    pub fn new(kind: GetDirectoryLimitsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDirectoryLimitsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDirectoryLimitsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDirectoryLimitsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDirectoryLimitsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDirectoryLimitsErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, GetDirectoryLimitsErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `GetDirectoryLimitsErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDirectoryLimitsErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDirectoryLimitsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetDirectoryLimitsErrorKind::ServiceException(_))
    }
}
impl std::error::Error for GetDirectoryLimitsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDirectoryLimitsErrorKind::ClientException(_inner) => Some(_inner),
            GetDirectoryLimitsErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            GetDirectoryLimitsErrorKind::ServiceException(_inner) => Some(_inner),
            GetDirectoryLimitsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSnapshotLimits` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSnapshotLimitsError {
    /// Kind of error that occurred.
    pub kind: GetSnapshotLimitsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSnapshotLimits` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSnapshotLimitsErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSnapshotLimitsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSnapshotLimitsErrorKind::ClientException(_inner) => _inner.fmt(f),
            GetSnapshotLimitsErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            GetSnapshotLimitsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetSnapshotLimitsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSnapshotLimitsError {
    fn code(&self) -> Option<&str> {
        GetSnapshotLimitsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSnapshotLimitsError {
    /// Creates a new `GetSnapshotLimitsError`.
    pub fn new(kind: GetSnapshotLimitsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSnapshotLimitsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSnapshotLimitsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSnapshotLimitsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSnapshotLimitsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSnapshotLimitsErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, GetSnapshotLimitsErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `GetSnapshotLimitsErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSnapshotLimitsErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSnapshotLimitsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetSnapshotLimitsErrorKind::ServiceException(_))
    }
}
impl std::error::Error for GetSnapshotLimitsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSnapshotLimitsErrorKind::ClientException(_inner) => Some(_inner),
            GetSnapshotLimitsErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            GetSnapshotLimitsErrorKind::ServiceException(_inner) => Some(_inner),
            GetSnapshotLimitsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCertificatesError {
    /// Kind of error that occurred.
    pub kind: ListCertificatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCertificatesErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified directory does not exist in the system.</p>
    DirectoryDoesNotExistException(crate::error::DirectoryDoesNotExistException),
    /// <p>The <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCertificatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCertificatesErrorKind::ClientException(_inner) => _inner.fmt(f),
            ListCertificatesErrorKind::DirectoryDoesNotExistException(_inner) => _inner.fmt(f),
            ListCertificatesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListCertificatesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListCertificatesErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListCertificatesErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            ListCertificatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCertificatesError {
    fn code(&self) -> Option<&str> {
        ListCertificatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCertificatesError {
    /// Creates a new `ListCertificatesError`.
    pub fn new(kind: ListCertificatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCertificatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCertificatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCertificatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCertificatesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListCertificatesErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, ListCertificatesErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `ListCertificatesErrorKind::DirectoryDoesNotExistException`.
    pub fn is_directory_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCertificatesErrorKind::DirectoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCertificatesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCertificatesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCertificatesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCertificatesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCertificatesErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, ListCertificatesErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `ListCertificatesErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCertificatesErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for ListCertificatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCertificatesErrorKind::ClientException(_inner) => Some(_inner),
            ListCertificatesErrorKind::DirectoryDoesNotExistException(_inner) => Some(_inner),
            ListCertificatesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListCertificatesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListCertificatesErrorKind::ServiceException(_inner) => Some(_inner),
            ListCertificatesErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            ListCertificatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListIpRoutes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListIpRoutesError {
    /// Kind of error that occurred.
    pub kind: ListIpRoutesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListIpRoutes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListIpRoutesErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>The <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListIpRoutesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListIpRoutesErrorKind::ClientException(_inner) => _inner.fmt(f),
            ListIpRoutesErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            ListIpRoutesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListIpRoutesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListIpRoutesErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListIpRoutesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListIpRoutesError {
    fn code(&self) -> Option<&str> {
        ListIpRoutesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListIpRoutesError {
    /// Creates a new `ListIpRoutesError`.
    pub fn new(kind: ListIpRoutesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListIpRoutesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListIpRoutesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListIpRoutesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListIpRoutesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListIpRoutesErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, ListIpRoutesErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `ListIpRoutesErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIpRoutesErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIpRoutesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIpRoutesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIpRoutesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIpRoutesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIpRoutesErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, ListIpRoutesErrorKind::ServiceException(_))
    }
}
impl std::error::Error for ListIpRoutesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListIpRoutesErrorKind::ClientException(_inner) => Some(_inner),
            ListIpRoutesErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            ListIpRoutesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListIpRoutesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListIpRoutesErrorKind::ServiceException(_inner) => Some(_inner),
            ListIpRoutesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListLogSubscriptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListLogSubscriptionsError {
    /// Kind of error that occurred.
    pub kind: ListLogSubscriptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListLogSubscriptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListLogSubscriptionsErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>The <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListLogSubscriptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListLogSubscriptionsErrorKind::ClientException(_inner) => _inner.fmt(f),
            ListLogSubscriptionsErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            ListLogSubscriptionsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListLogSubscriptionsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListLogSubscriptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListLogSubscriptionsError {
    fn code(&self) -> Option<&str> {
        ListLogSubscriptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListLogSubscriptionsError {
    /// Creates a new `ListLogSubscriptionsError`.
    pub fn new(kind: ListLogSubscriptionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListLogSubscriptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListLogSubscriptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListLogSubscriptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListLogSubscriptionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListLogSubscriptionsErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLogSubscriptionsErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLogSubscriptionsErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLogSubscriptionsErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLogSubscriptionsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLogSubscriptionsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLogSubscriptionsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLogSubscriptionsErrorKind::ServiceException(_)
        )
    }
}
impl std::error::Error for ListLogSubscriptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListLogSubscriptionsErrorKind::ClientException(_inner) => Some(_inner),
            ListLogSubscriptionsErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            ListLogSubscriptionsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListLogSubscriptionsErrorKind::ServiceException(_inner) => Some(_inner),
            ListLogSubscriptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSchemaExtensions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSchemaExtensionsError {
    /// Kind of error that occurred.
    pub kind: ListSchemaExtensionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSchemaExtensions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSchemaExtensionsErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>The <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSchemaExtensionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSchemaExtensionsErrorKind::ClientException(_inner) => _inner.fmt(f),
            ListSchemaExtensionsErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            ListSchemaExtensionsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListSchemaExtensionsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListSchemaExtensionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSchemaExtensionsError {
    fn code(&self) -> Option<&str> {
        ListSchemaExtensionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSchemaExtensionsError {
    /// Creates a new `ListSchemaExtensionsError`.
    pub fn new(kind: ListSchemaExtensionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSchemaExtensionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSchemaExtensionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSchemaExtensionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSchemaExtensionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSchemaExtensionsErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSchemaExtensionsErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSchemaExtensionsErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSchemaExtensionsErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSchemaExtensionsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSchemaExtensionsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSchemaExtensionsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSchemaExtensionsErrorKind::ServiceException(_)
        )
    }
}
impl std::error::Error for ListSchemaExtensionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSchemaExtensionsErrorKind::ClientException(_inner) => Some(_inner),
            ListSchemaExtensionsErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            ListSchemaExtensionsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListSchemaExtensionsErrorKind::ServiceException(_inner) => Some(_inner),
            ListSchemaExtensionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>The <code>NextToken</code> value is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::ClientException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, ListTagsForResourceErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ServiceException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::ClientException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ServiceException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterCertificateError {
    /// Kind of error that occurred.
    pub kind: RegisterCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterCertificateErrorKind {
    /// <p>The certificate has already been registered into the system.</p>
    CertificateAlreadyExistsException(crate::error::CertificateAlreadyExistsException),
    /// <p>The certificate could not be added because the certificate limit has been reached.</p>
    CertificateLimitExceededException(crate::error::CertificateLimitExceededException),
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified directory does not exist in the system.</p>
    DirectoryDoesNotExistException(crate::error::DirectoryDoesNotExistException),
    /// <p>The specified directory is unavailable or could not be found.</p>
    DirectoryUnavailableException(crate::error::DirectoryUnavailableException),
    /// <p>The certificate PEM that was provided has incorrect encoding.</p>
    InvalidCertificateException(crate::error::InvalidCertificateException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterCertificateErrorKind::CertificateAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            RegisterCertificateErrorKind::CertificateLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            RegisterCertificateErrorKind::ClientException(_inner) => _inner.fmt(f),
            RegisterCertificateErrorKind::DirectoryDoesNotExistException(_inner) => _inner.fmt(f),
            RegisterCertificateErrorKind::DirectoryUnavailableException(_inner) => _inner.fmt(f),
            RegisterCertificateErrorKind::InvalidCertificateException(_inner) => _inner.fmt(f),
            RegisterCertificateErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            RegisterCertificateErrorKind::ServiceException(_inner) => _inner.fmt(f),
            RegisterCertificateErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            RegisterCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterCertificateError {
    fn code(&self) -> Option<&str> {
        RegisterCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterCertificateError {
    /// Creates a new `RegisterCertificateError`.
    pub fn new(kind: RegisterCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterCertificateErrorKind::CertificateAlreadyExistsException`.
    pub fn is_certificate_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterCertificateErrorKind::CertificateAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterCertificateErrorKind::CertificateLimitExceededException`.
    pub fn is_certificate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterCertificateErrorKind::CertificateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterCertificateErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, RegisterCertificateErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `RegisterCertificateErrorKind::DirectoryDoesNotExistException`.
    pub fn is_directory_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterCertificateErrorKind::DirectoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterCertificateErrorKind::DirectoryUnavailableException`.
    pub fn is_directory_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterCertificateErrorKind::DirectoryUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterCertificateErrorKind::InvalidCertificateException`.
    pub fn is_invalid_certificate_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterCertificateErrorKind::InvalidCertificateException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterCertificateErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterCertificateErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterCertificateErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterCertificateErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterCertificateErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterCertificateErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for RegisterCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterCertificateErrorKind::CertificateAlreadyExistsException(_inner) => Some(_inner),
            RegisterCertificateErrorKind::CertificateLimitExceededException(_inner) => Some(_inner),
            RegisterCertificateErrorKind::ClientException(_inner) => Some(_inner),
            RegisterCertificateErrorKind::DirectoryDoesNotExistException(_inner) => Some(_inner),
            RegisterCertificateErrorKind::DirectoryUnavailableException(_inner) => Some(_inner),
            RegisterCertificateErrorKind::InvalidCertificateException(_inner) => Some(_inner),
            RegisterCertificateErrorKind::InvalidParameterException(_inner) => Some(_inner),
            RegisterCertificateErrorKind::ServiceException(_inner) => Some(_inner),
            RegisterCertificateErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            RegisterCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterEventTopic` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterEventTopicError {
    /// Kind of error that occurred.
    pub kind: RegisterEventTopicErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterEventTopic` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterEventTopicErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterEventTopicError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterEventTopicErrorKind::ClientException(_inner) => _inner.fmt(f),
            RegisterEventTopicErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            RegisterEventTopicErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            RegisterEventTopicErrorKind::ServiceException(_inner) => _inner.fmt(f),
            RegisterEventTopicErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterEventTopicError {
    fn code(&self) -> Option<&str> {
        RegisterEventTopicError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterEventTopicError {
    /// Creates a new `RegisterEventTopicError`.
    pub fn new(kind: RegisterEventTopicErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterEventTopicError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterEventTopicErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterEventTopicError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterEventTopicErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterEventTopicErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, RegisterEventTopicErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `RegisterEventTopicErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterEventTopicErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterEventTopicErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterEventTopicErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterEventTopicErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, RegisterEventTopicErrorKind::ServiceException(_))
    }
}
impl std::error::Error for RegisterEventTopicError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterEventTopicErrorKind::ClientException(_inner) => Some(_inner),
            RegisterEventTopicErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            RegisterEventTopicErrorKind::InvalidParameterException(_inner) => Some(_inner),
            RegisterEventTopicErrorKind::ServiceException(_inner) => Some(_inner),
            RegisterEventTopicErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RejectSharedDirectory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RejectSharedDirectoryError {
    /// Kind of error that occurred.
    pub kind: RejectSharedDirectoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RejectSharedDirectory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RejectSharedDirectoryErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified directory has already been shared with this Amazon Web Services account.</p>
    DirectoryAlreadySharedException(crate::error::DirectoryAlreadySharedException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RejectSharedDirectoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RejectSharedDirectoryErrorKind::ClientException(_inner) => _inner.fmt(f),
            RejectSharedDirectoryErrorKind::DirectoryAlreadySharedException(_inner) => {
                _inner.fmt(f)
            }
            RejectSharedDirectoryErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            RejectSharedDirectoryErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            RejectSharedDirectoryErrorKind::ServiceException(_inner) => _inner.fmt(f),
            RejectSharedDirectoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RejectSharedDirectoryError {
    fn code(&self) -> Option<&str> {
        RejectSharedDirectoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RejectSharedDirectoryError {
    /// Creates a new `RejectSharedDirectoryError`.
    pub fn new(kind: RejectSharedDirectoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RejectSharedDirectoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RejectSharedDirectoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RejectSharedDirectoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RejectSharedDirectoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RejectSharedDirectoryErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectSharedDirectoryErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectSharedDirectoryErrorKind::DirectoryAlreadySharedException`.
    pub fn is_directory_already_shared_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectSharedDirectoryErrorKind::DirectoryAlreadySharedException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectSharedDirectoryErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectSharedDirectoryErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectSharedDirectoryErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectSharedDirectoryErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectSharedDirectoryErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectSharedDirectoryErrorKind::ServiceException(_)
        )
    }
}
impl std::error::Error for RejectSharedDirectoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RejectSharedDirectoryErrorKind::ClientException(_inner) => Some(_inner),
            RejectSharedDirectoryErrorKind::DirectoryAlreadySharedException(_inner) => Some(_inner),
            RejectSharedDirectoryErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            RejectSharedDirectoryErrorKind::InvalidParameterException(_inner) => Some(_inner),
            RejectSharedDirectoryErrorKind::ServiceException(_inner) => Some(_inner),
            RejectSharedDirectoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveIpRoutes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveIpRoutesError {
    /// Kind of error that occurred.
    pub kind: RemoveIpRoutesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveIpRoutes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveIpRoutesErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified directory is unavailable or could not be found.</p>
    DirectoryUnavailableException(crate::error::DirectoryUnavailableException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveIpRoutesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveIpRoutesErrorKind::ClientException(_inner) => _inner.fmt(f),
            RemoveIpRoutesErrorKind::DirectoryUnavailableException(_inner) => _inner.fmt(f),
            RemoveIpRoutesErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            RemoveIpRoutesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            RemoveIpRoutesErrorKind::ServiceException(_inner) => _inner.fmt(f),
            RemoveIpRoutesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveIpRoutesError {
    fn code(&self) -> Option<&str> {
        RemoveIpRoutesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveIpRoutesError {
    /// Creates a new `RemoveIpRoutesError`.
    pub fn new(kind: RemoveIpRoutesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveIpRoutesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveIpRoutesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveIpRoutesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveIpRoutesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveIpRoutesErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, RemoveIpRoutesErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `RemoveIpRoutesErrorKind::DirectoryUnavailableException`.
    pub fn is_directory_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveIpRoutesErrorKind::DirectoryUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveIpRoutesErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveIpRoutesErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveIpRoutesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveIpRoutesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveIpRoutesErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, RemoveIpRoutesErrorKind::ServiceException(_))
    }
}
impl std::error::Error for RemoveIpRoutesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveIpRoutesErrorKind::ClientException(_inner) => Some(_inner),
            RemoveIpRoutesErrorKind::DirectoryUnavailableException(_inner) => Some(_inner),
            RemoveIpRoutesErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            RemoveIpRoutesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            RemoveIpRoutesErrorKind::ServiceException(_inner) => Some(_inner),
            RemoveIpRoutesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveRegion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveRegionError {
    /// Kind of error that occurred.
    pub kind: RemoveRegionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveRegion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveRegionErrorKind {
    /// <p>Client authentication is not available in this region at this time.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified directory does not exist in the system.</p>
    DirectoryDoesNotExistException(crate::error::DirectoryDoesNotExistException),
    /// <p>The specified directory is unavailable or could not be found.</p>
    DirectoryUnavailableException(crate::error::DirectoryUnavailableException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveRegionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveRegionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            RemoveRegionErrorKind::ClientException(_inner) => _inner.fmt(f),
            RemoveRegionErrorKind::DirectoryDoesNotExistException(_inner) => _inner.fmt(f),
            RemoveRegionErrorKind::DirectoryUnavailableException(_inner) => _inner.fmt(f),
            RemoveRegionErrorKind::ServiceException(_inner) => _inner.fmt(f),
            RemoveRegionErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            RemoveRegionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveRegionError {
    fn code(&self) -> Option<&str> {
        RemoveRegionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveRegionError {
    /// Creates a new `RemoveRegionError`.
    pub fn new(kind: RemoveRegionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveRegionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveRegionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveRegionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveRegionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveRegionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, RemoveRegionErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `RemoveRegionErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, RemoveRegionErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `RemoveRegionErrorKind::DirectoryDoesNotExistException`.
    pub fn is_directory_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveRegionErrorKind::DirectoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveRegionErrorKind::DirectoryUnavailableException`.
    pub fn is_directory_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveRegionErrorKind::DirectoryUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveRegionErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, RemoveRegionErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `RemoveRegionErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveRegionErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for RemoveRegionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveRegionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            RemoveRegionErrorKind::ClientException(_inner) => Some(_inner),
            RemoveRegionErrorKind::DirectoryDoesNotExistException(_inner) => Some(_inner),
            RemoveRegionErrorKind::DirectoryUnavailableException(_inner) => Some(_inner),
            RemoveRegionErrorKind::ServiceException(_inner) => Some(_inner),
            RemoveRegionErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            RemoveRegionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveTagsFromResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveTagsFromResourceError {
    /// Kind of error that occurred.
    pub kind: RemoveTagsFromResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveTagsFromResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveTagsFromResourceErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveTagsFromResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveTagsFromResourceErrorKind::ClientException(_inner) => _inner.fmt(f),
            RemoveTagsFromResourceErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            RemoveTagsFromResourceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            RemoveTagsFromResourceErrorKind::ServiceException(_inner) => _inner.fmt(f),
            RemoveTagsFromResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveTagsFromResourceError {
    fn code(&self) -> Option<&str> {
        RemoveTagsFromResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveTagsFromResourceError {
    /// Creates a new `RemoveTagsFromResourceError`.
    pub fn new(kind: RemoveTagsFromResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveTagsFromResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveTagsFromResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveTagsFromResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveTagsFromResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveTagsFromResourceErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromResourceErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTagsFromResourceErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromResourceErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTagsFromResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTagsFromResourceErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromResourceErrorKind::ServiceException(_)
        )
    }
}
impl std::error::Error for RemoveTagsFromResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveTagsFromResourceErrorKind::ClientException(_inner) => Some(_inner),
            RemoveTagsFromResourceErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            RemoveTagsFromResourceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            RemoveTagsFromResourceErrorKind::ServiceException(_inner) => Some(_inner),
            RemoveTagsFromResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResetUserPassword` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResetUserPasswordError {
    /// Kind of error that occurred.
    pub kind: ResetUserPasswordErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResetUserPassword` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResetUserPasswordErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified directory is unavailable or could not be found.</p>
    DirectoryUnavailableException(crate::error::DirectoryUnavailableException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>The new password provided by the user does not meet the password complexity
    /// requirements defined in your directory.</p>
    InvalidPasswordException(crate::error::InvalidPasswordException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// <p>The user provided a username that does not exist in your directory.</p>
    UserDoesNotExistException(crate::error::UserDoesNotExistException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResetUserPasswordError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResetUserPasswordErrorKind::ClientException(_inner) => _inner.fmt(f),
            ResetUserPasswordErrorKind::DirectoryUnavailableException(_inner) => _inner.fmt(f),
            ResetUserPasswordErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            ResetUserPasswordErrorKind::InvalidPasswordException(_inner) => _inner.fmt(f),
            ResetUserPasswordErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ResetUserPasswordErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            ResetUserPasswordErrorKind::UserDoesNotExistException(_inner) => _inner.fmt(f),
            ResetUserPasswordErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResetUserPasswordError {
    fn code(&self) -> Option<&str> {
        ResetUserPasswordError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResetUserPasswordError {
    /// Creates a new `ResetUserPasswordError`.
    pub fn new(kind: ResetUserPasswordErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResetUserPasswordError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResetUserPasswordErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResetUserPasswordError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResetUserPasswordErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ResetUserPasswordErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, ResetUserPasswordErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `ResetUserPasswordErrorKind::DirectoryUnavailableException`.
    pub fn is_directory_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetUserPasswordErrorKind::DirectoryUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ResetUserPasswordErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetUserPasswordErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `ResetUserPasswordErrorKind::InvalidPasswordException`.
    pub fn is_invalid_password_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetUserPasswordErrorKind::InvalidPasswordException(_)
        )
    }
    /// Returns `true` if the error kind is `ResetUserPasswordErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, ResetUserPasswordErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `ResetUserPasswordErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetUserPasswordErrorKind::UnsupportedOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `ResetUserPasswordErrorKind::UserDoesNotExistException`.
    pub fn is_user_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetUserPasswordErrorKind::UserDoesNotExistException(_)
        )
    }
}
impl std::error::Error for ResetUserPasswordError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResetUserPasswordErrorKind::ClientException(_inner) => Some(_inner),
            ResetUserPasswordErrorKind::DirectoryUnavailableException(_inner) => Some(_inner),
            ResetUserPasswordErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            ResetUserPasswordErrorKind::InvalidPasswordException(_inner) => Some(_inner),
            ResetUserPasswordErrorKind::ServiceException(_inner) => Some(_inner),
            ResetUserPasswordErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            ResetUserPasswordErrorKind::UserDoesNotExistException(_inner) => Some(_inner),
            ResetUserPasswordErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RestoreFromSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RestoreFromSnapshotError {
    /// Kind of error that occurred.
    pub kind: RestoreFromSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RestoreFromSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RestoreFromSnapshotErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RestoreFromSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RestoreFromSnapshotErrorKind::ClientException(_inner) => _inner.fmt(f),
            RestoreFromSnapshotErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            RestoreFromSnapshotErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            RestoreFromSnapshotErrorKind::ServiceException(_inner) => _inner.fmt(f),
            RestoreFromSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RestoreFromSnapshotError {
    fn code(&self) -> Option<&str> {
        RestoreFromSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RestoreFromSnapshotError {
    /// Creates a new `RestoreFromSnapshotError`.
    pub fn new(kind: RestoreFromSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RestoreFromSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RestoreFromSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RestoreFromSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RestoreFromSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RestoreFromSnapshotErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, RestoreFromSnapshotErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `RestoreFromSnapshotErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreFromSnapshotErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreFromSnapshotErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreFromSnapshotErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreFromSnapshotErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreFromSnapshotErrorKind::ServiceException(_)
        )
    }
}
impl std::error::Error for RestoreFromSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RestoreFromSnapshotErrorKind::ClientException(_inner) => Some(_inner),
            RestoreFromSnapshotErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            RestoreFromSnapshotErrorKind::InvalidParameterException(_inner) => Some(_inner),
            RestoreFromSnapshotErrorKind::ServiceException(_inner) => Some(_inner),
            RestoreFromSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ShareDirectory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ShareDirectoryError {
    /// Kind of error that occurred.
    pub kind: ShareDirectoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ShareDirectory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ShareDirectoryErrorKind {
    /// <p>Client authentication is not available in this region at this time.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified directory has already been shared with this Amazon Web Services account.</p>
    DirectoryAlreadySharedException(crate::error::DirectoryAlreadySharedException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified shared target is not valid.</p>
    InvalidTargetException(crate::error::InvalidTargetException),
    /// <p>Exception encountered while trying to access your Amazon Web Services organization.</p>
    OrganizationsException(crate::error::OrganizationsException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The maximum number of Amazon Web Services accounts that you can share with this directory has been
    /// reached.</p>
    ShareLimitExceededException(crate::error::ShareLimitExceededException),
    /// <p>The operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ShareDirectoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ShareDirectoryErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ShareDirectoryErrorKind::ClientException(_inner) => _inner.fmt(f),
            ShareDirectoryErrorKind::DirectoryAlreadySharedException(_inner) => _inner.fmt(f),
            ShareDirectoryErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            ShareDirectoryErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ShareDirectoryErrorKind::InvalidTargetException(_inner) => _inner.fmt(f),
            ShareDirectoryErrorKind::OrganizationsException(_inner) => _inner.fmt(f),
            ShareDirectoryErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ShareDirectoryErrorKind::ShareLimitExceededException(_inner) => _inner.fmt(f),
            ShareDirectoryErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            ShareDirectoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ShareDirectoryError {
    fn code(&self) -> Option<&str> {
        ShareDirectoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ShareDirectoryError {
    /// Creates a new `ShareDirectoryError`.
    pub fn new(kind: ShareDirectoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ShareDirectoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ShareDirectoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ShareDirectoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ShareDirectoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ShareDirectoryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ShareDirectoryErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ShareDirectoryErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, ShareDirectoryErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `ShareDirectoryErrorKind::DirectoryAlreadySharedException`.
    pub fn is_directory_already_shared_exception(&self) -> bool {
        matches!(
            &self.kind,
            ShareDirectoryErrorKind::DirectoryAlreadySharedException(_)
        )
    }
    /// Returns `true` if the error kind is `ShareDirectoryErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            ShareDirectoryErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `ShareDirectoryErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ShareDirectoryErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ShareDirectoryErrorKind::InvalidTargetException`.
    pub fn is_invalid_target_exception(&self) -> bool {
        matches!(
            &self.kind,
            ShareDirectoryErrorKind::InvalidTargetException(_)
        )
    }
    /// Returns `true` if the error kind is `ShareDirectoryErrorKind::OrganizationsException`.
    pub fn is_organizations_exception(&self) -> bool {
        matches!(
            &self.kind,
            ShareDirectoryErrorKind::OrganizationsException(_)
        )
    }
    /// Returns `true` if the error kind is `ShareDirectoryErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, ShareDirectoryErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `ShareDirectoryErrorKind::ShareLimitExceededException`.
    pub fn is_share_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ShareDirectoryErrorKind::ShareLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ShareDirectoryErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ShareDirectoryErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for ShareDirectoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ShareDirectoryErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ShareDirectoryErrorKind::ClientException(_inner) => Some(_inner),
            ShareDirectoryErrorKind::DirectoryAlreadySharedException(_inner) => Some(_inner),
            ShareDirectoryErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            ShareDirectoryErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ShareDirectoryErrorKind::InvalidTargetException(_inner) => Some(_inner),
            ShareDirectoryErrorKind::OrganizationsException(_inner) => Some(_inner),
            ShareDirectoryErrorKind::ServiceException(_inner) => Some(_inner),
            ShareDirectoryErrorKind::ShareLimitExceededException(_inner) => Some(_inner),
            ShareDirectoryErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            ShareDirectoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartSchemaExtension` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartSchemaExtensionError {
    /// Kind of error that occurred.
    pub kind: StartSchemaExtensionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartSchemaExtension` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartSchemaExtensionErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified directory is unavailable or could not be found.</p>
    DirectoryUnavailableException(crate::error::DirectoryUnavailableException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The maximum number of manual snapshots for the directory has been reached. You can
    /// use the <a>GetSnapshotLimits</a> operation to determine the snapshot limits
    /// for a directory.</p>
    SnapshotLimitExceededException(crate::error::SnapshotLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartSchemaExtensionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartSchemaExtensionErrorKind::ClientException(_inner) => _inner.fmt(f),
            StartSchemaExtensionErrorKind::DirectoryUnavailableException(_inner) => _inner.fmt(f),
            StartSchemaExtensionErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            StartSchemaExtensionErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            StartSchemaExtensionErrorKind::ServiceException(_inner) => _inner.fmt(f),
            StartSchemaExtensionErrorKind::SnapshotLimitExceededException(_inner) => _inner.fmt(f),
            StartSchemaExtensionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartSchemaExtensionError {
    fn code(&self) -> Option<&str> {
        StartSchemaExtensionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartSchemaExtensionError {
    /// Creates a new `StartSchemaExtensionError`.
    pub fn new(kind: StartSchemaExtensionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartSchemaExtensionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartSchemaExtensionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartSchemaExtensionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartSchemaExtensionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartSchemaExtensionErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSchemaExtensionErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `StartSchemaExtensionErrorKind::DirectoryUnavailableException`.
    pub fn is_directory_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSchemaExtensionErrorKind::DirectoryUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `StartSchemaExtensionErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSchemaExtensionErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `StartSchemaExtensionErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSchemaExtensionErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `StartSchemaExtensionErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSchemaExtensionErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `StartSchemaExtensionErrorKind::SnapshotLimitExceededException`.
    pub fn is_snapshot_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSchemaExtensionErrorKind::SnapshotLimitExceededException(_)
        )
    }
}
impl std::error::Error for StartSchemaExtensionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartSchemaExtensionErrorKind::ClientException(_inner) => Some(_inner),
            StartSchemaExtensionErrorKind::DirectoryUnavailableException(_inner) => Some(_inner),
            StartSchemaExtensionErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            StartSchemaExtensionErrorKind::InvalidParameterException(_inner) => Some(_inner),
            StartSchemaExtensionErrorKind::ServiceException(_inner) => Some(_inner),
            StartSchemaExtensionErrorKind::SnapshotLimitExceededException(_inner) => Some(_inner),
            StartSchemaExtensionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UnshareDirectory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UnshareDirectoryError {
    /// Kind of error that occurred.
    pub kind: UnshareDirectoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UnshareDirectory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UnshareDirectoryErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified directory has not been shared with this Amazon Web Services account.</p>
    DirectoryNotSharedException(crate::error::DirectoryNotSharedException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>The specified shared target is not valid.</p>
    InvalidTargetException(crate::error::InvalidTargetException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UnshareDirectoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UnshareDirectoryErrorKind::ClientException(_inner) => _inner.fmt(f),
            UnshareDirectoryErrorKind::DirectoryNotSharedException(_inner) => _inner.fmt(f),
            UnshareDirectoryErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            UnshareDirectoryErrorKind::InvalidTargetException(_inner) => _inner.fmt(f),
            UnshareDirectoryErrorKind::ServiceException(_inner) => _inner.fmt(f),
            UnshareDirectoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UnshareDirectoryError {
    fn code(&self) -> Option<&str> {
        UnshareDirectoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UnshareDirectoryError {
    /// Creates a new `UnshareDirectoryError`.
    pub fn new(kind: UnshareDirectoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UnshareDirectoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UnshareDirectoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UnshareDirectoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UnshareDirectoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UnshareDirectoryErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, UnshareDirectoryErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `UnshareDirectoryErrorKind::DirectoryNotSharedException`.
    pub fn is_directory_not_shared_exception(&self) -> bool {
        matches!(
            &self.kind,
            UnshareDirectoryErrorKind::DirectoryNotSharedException(_)
        )
    }
    /// Returns `true` if the error kind is `UnshareDirectoryErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            UnshareDirectoryErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `UnshareDirectoryErrorKind::InvalidTargetException`.
    pub fn is_invalid_target_exception(&self) -> bool {
        matches!(
            &self.kind,
            UnshareDirectoryErrorKind::InvalidTargetException(_)
        )
    }
    /// Returns `true` if the error kind is `UnshareDirectoryErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, UnshareDirectoryErrorKind::ServiceException(_))
    }
}
impl std::error::Error for UnshareDirectoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UnshareDirectoryErrorKind::ClientException(_inner) => Some(_inner),
            UnshareDirectoryErrorKind::DirectoryNotSharedException(_inner) => Some(_inner),
            UnshareDirectoryErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            UnshareDirectoryErrorKind::InvalidTargetException(_inner) => Some(_inner),
            UnshareDirectoryErrorKind::ServiceException(_inner) => Some(_inner),
            UnshareDirectoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateConditionalForwarder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateConditionalForwarderError {
    /// Kind of error that occurred.
    pub kind: UpdateConditionalForwarderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateConditionalForwarder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateConditionalForwarderErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified directory is unavailable or could not be found.</p>
    DirectoryUnavailableException(crate::error::DirectoryUnavailableException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateConditionalForwarderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateConditionalForwarderErrorKind::ClientException(_inner) => _inner.fmt(f),
            UpdateConditionalForwarderErrorKind::DirectoryUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            UpdateConditionalForwarderErrorKind::EntityDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            UpdateConditionalForwarderErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateConditionalForwarderErrorKind::ServiceException(_inner) => _inner.fmt(f),
            UpdateConditionalForwarderErrorKind::UnsupportedOperationException(_inner) => {
                _inner.fmt(f)
            }
            UpdateConditionalForwarderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateConditionalForwarderError {
    fn code(&self) -> Option<&str> {
        UpdateConditionalForwarderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateConditionalForwarderError {
    /// Creates a new `UpdateConditionalForwarderError`.
    pub fn new(kind: UpdateConditionalForwarderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateConditionalForwarderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateConditionalForwarderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateConditionalForwarderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateConditionalForwarderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateConditionalForwarderErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConditionalForwarderErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConditionalForwarderErrorKind::DirectoryUnavailableException`.
    pub fn is_directory_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConditionalForwarderErrorKind::DirectoryUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConditionalForwarderErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConditionalForwarderErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConditionalForwarderErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConditionalForwarderErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConditionalForwarderErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConditionalForwarderErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConditionalForwarderErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConditionalForwarderErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for UpdateConditionalForwarderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateConditionalForwarderErrorKind::ClientException(_inner) => Some(_inner),
            UpdateConditionalForwarderErrorKind::DirectoryUnavailableException(_inner) => {
                Some(_inner)
            }
            UpdateConditionalForwarderErrorKind::EntityDoesNotExistException(_inner) => {
                Some(_inner)
            }
            UpdateConditionalForwarderErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateConditionalForwarderErrorKind::ServiceException(_inner) => Some(_inner),
            UpdateConditionalForwarderErrorKind::UnsupportedOperationException(_inner) => {
                Some(_inner)
            }
            UpdateConditionalForwarderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateNumberOfDomainControllers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateNumberOfDomainControllersError {
    /// Kind of error that occurred.
    pub kind: UpdateNumberOfDomainControllersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateNumberOfDomainControllers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateNumberOfDomainControllersErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified directory is unavailable or could not be found.</p>
    DirectoryUnavailableException(crate::error::DirectoryUnavailableException),
    /// <p>The maximum allowed number of domain controllers per directory was exceeded. The
    /// default limit per directory is 20 domain controllers.</p>
    DomainControllerLimitExceededException(crate::error::DomainControllerLimitExceededException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateNumberOfDomainControllersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateNumberOfDomainControllersErrorKind::ClientException(_inner) => _inner.fmt(f),
            UpdateNumberOfDomainControllersErrorKind::DirectoryUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            UpdateNumberOfDomainControllersErrorKind::DomainControllerLimitExceededException(
                _inner,
            ) => _inner.fmt(f),
            UpdateNumberOfDomainControllersErrorKind::EntityDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            UpdateNumberOfDomainControllersErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            UpdateNumberOfDomainControllersErrorKind::ServiceException(_inner) => _inner.fmt(f),
            UpdateNumberOfDomainControllersErrorKind::UnsupportedOperationException(_inner) => {
                _inner.fmt(f)
            }
            UpdateNumberOfDomainControllersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateNumberOfDomainControllersError {
    fn code(&self) -> Option<&str> {
        UpdateNumberOfDomainControllersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateNumberOfDomainControllersError {
    /// Creates a new `UpdateNumberOfDomainControllersError`.
    pub fn new(
        kind: UpdateNumberOfDomainControllersErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateNumberOfDomainControllersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateNumberOfDomainControllersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateNumberOfDomainControllersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateNumberOfDomainControllersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateNumberOfDomainControllersErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNumberOfDomainControllersErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNumberOfDomainControllersErrorKind::DirectoryUnavailableException`.
    pub fn is_directory_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNumberOfDomainControllersErrorKind::DirectoryUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNumberOfDomainControllersErrorKind::DomainControllerLimitExceededException`.
    pub fn is_domain_controller_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNumberOfDomainControllersErrorKind::DomainControllerLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNumberOfDomainControllersErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNumberOfDomainControllersErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNumberOfDomainControllersErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNumberOfDomainControllersErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNumberOfDomainControllersErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNumberOfDomainControllersErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNumberOfDomainControllersErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNumberOfDomainControllersErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for UpdateNumberOfDomainControllersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateNumberOfDomainControllersErrorKind::ClientException(_inner) => Some(_inner),
            UpdateNumberOfDomainControllersErrorKind::DirectoryUnavailableException(_inner) => {
                Some(_inner)
            }
            UpdateNumberOfDomainControllersErrorKind::DomainControllerLimitExceededException(
                _inner,
            ) => Some(_inner),
            UpdateNumberOfDomainControllersErrorKind::EntityDoesNotExistException(_inner) => {
                Some(_inner)
            }
            UpdateNumberOfDomainControllersErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            UpdateNumberOfDomainControllersErrorKind::ServiceException(_inner) => Some(_inner),
            UpdateNumberOfDomainControllersErrorKind::UnsupportedOperationException(_inner) => {
                Some(_inner)
            }
            UpdateNumberOfDomainControllersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRadius` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRadiusError {
    /// Kind of error that occurred.
    pub kind: UpdateRadiusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRadius` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRadiusErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRadiusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRadiusErrorKind::ClientException(_inner) => _inner.fmt(f),
            UpdateRadiusErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            UpdateRadiusErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateRadiusErrorKind::ServiceException(_inner) => _inner.fmt(f),
            UpdateRadiusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRadiusError {
    fn code(&self) -> Option<&str> {
        UpdateRadiusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRadiusError {
    /// Creates a new `UpdateRadiusError`.
    pub fn new(kind: UpdateRadiusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRadiusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRadiusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRadiusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRadiusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateRadiusErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, UpdateRadiusErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `UpdateRadiusErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRadiusErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRadiusErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRadiusErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRadiusErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, UpdateRadiusErrorKind::ServiceException(_))
    }
}
impl std::error::Error for UpdateRadiusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRadiusErrorKind::ClientException(_inner) => Some(_inner),
            UpdateRadiusErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            UpdateRadiusErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateRadiusErrorKind::ServiceException(_inner) => Some(_inner),
            UpdateRadiusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateTrust` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateTrustError {
    /// Kind of error that occurred.
    pub kind: UpdateTrustErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateTrust` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateTrustErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateTrustError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateTrustErrorKind::ClientException(_inner) => _inner.fmt(f),
            UpdateTrustErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            UpdateTrustErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateTrustErrorKind::ServiceException(_inner) => _inner.fmt(f),
            UpdateTrustErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateTrustError {
    fn code(&self) -> Option<&str> {
        UpdateTrustError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateTrustError {
    /// Creates a new `UpdateTrustError`.
    pub fn new(kind: UpdateTrustErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateTrustError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateTrustErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateTrustError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateTrustErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateTrustErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, UpdateTrustErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `UpdateTrustErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrustErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrustErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrustErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrustErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, UpdateTrustErrorKind::ServiceException(_))
    }
}
impl std::error::Error for UpdateTrustError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateTrustErrorKind::ClientException(_inner) => Some(_inner),
            UpdateTrustErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            UpdateTrustErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateTrustErrorKind::ServiceException(_inner) => Some(_inner),
            UpdateTrustErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `VerifyTrust` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct VerifyTrustError {
    /// Kind of error that occurred.
    pub kind: VerifyTrustErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `VerifyTrust` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum VerifyTrustErrorKind {
    /// <p>A client exception has occurred.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified entity could not be found.</p>
    EntityDoesNotExistException(crate::error::EntityDoesNotExistException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An exception has occurred in Directory Service.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for VerifyTrustError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            VerifyTrustErrorKind::ClientException(_inner) => _inner.fmt(f),
            VerifyTrustErrorKind::EntityDoesNotExistException(_inner) => _inner.fmt(f),
            VerifyTrustErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            VerifyTrustErrorKind::ServiceException(_inner) => _inner.fmt(f),
            VerifyTrustErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            VerifyTrustErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for VerifyTrustError {
    fn code(&self) -> Option<&str> {
        VerifyTrustError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl VerifyTrustError {
    /// Creates a new `VerifyTrustError`.
    pub fn new(kind: VerifyTrustErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `VerifyTrustError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: VerifyTrustErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `VerifyTrustError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: VerifyTrustErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `VerifyTrustErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, VerifyTrustErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `VerifyTrustErrorKind::EntityDoesNotExistException`.
    pub fn is_entity_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            VerifyTrustErrorKind::EntityDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `VerifyTrustErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            VerifyTrustErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `VerifyTrustErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, VerifyTrustErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `VerifyTrustErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            VerifyTrustErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for VerifyTrustError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            VerifyTrustErrorKind::ClientException(_inner) => Some(_inner),
            VerifyTrustErrorKind::EntityDoesNotExistException(_inner) => Some(_inner),
            VerifyTrustErrorKind::InvalidParameterException(_inner) => Some(_inner),
            VerifyTrustErrorKind::ServiceException(_inner) => Some(_inner),
            VerifyTrustErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            VerifyTrustErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The operation is not supported.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedOperationException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl UnsupportedOperationException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for UnsupportedOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedOperationException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl UnsupportedOperationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedOperationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedOperationException {}
/// See [`UnsupportedOperationException`](crate::error::UnsupportedOperationException)
pub mod unsupported_operation_exception {
    /// A builder for [`UnsupportedOperationException`](crate::error::UnsupportedOperationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedOperationException`](crate::error::UnsupportedOperationException)
        pub fn build(self) -> crate::error::UnsupportedOperationException {
            crate::error::UnsupportedOperationException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl UnsupportedOperationException {
    /// Creates a new builder-style object to manufacture [`UnsupportedOperationException`](crate::error::UnsupportedOperationException)
    pub fn builder() -> crate::error::unsupported_operation_exception::Builder {
        crate::error::unsupported_operation_exception::Builder::default()
    }
}

/// <p>An exception has occurred in Directory Service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl ServiceException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for ServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl ServiceException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceException {}
/// See [`ServiceException`](crate::error::ServiceException)
pub mod service_exception {
    /// A builder for [`ServiceException`](crate::error::ServiceException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceException`](crate::error::ServiceException)
        pub fn build(self) -> crate::error::ServiceException {
            crate::error::ServiceException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl ServiceException {
    /// Creates a new builder-style object to manufacture [`ServiceException`](crate::error::ServiceException)
    pub fn builder() -> crate::error::service_exception::Builder {
        crate::error::service_exception::Builder::default()
    }
}

/// <p>One or more parameters are not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl InvalidParameterException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl InvalidParameterException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterException {}
/// See [`InvalidParameterException`](crate::error::InvalidParameterException)
pub mod invalid_parameter_exception {
    /// A builder for [`InvalidParameterException`](crate::error::InvalidParameterException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterException`](crate::error::InvalidParameterException)
        pub fn build(self) -> crate::error::InvalidParameterException {
            crate::error::InvalidParameterException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl InvalidParameterException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterException`](crate::error::InvalidParameterException)
    pub fn builder() -> crate::error::invalid_parameter_exception::Builder {
        crate::error::invalid_parameter_exception::Builder::default()
    }
}

/// <p>The specified entity could not be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntityDoesNotExistException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl EntityDoesNotExistException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for EntityDoesNotExistException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntityDoesNotExistException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl EntityDoesNotExistException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EntityDoesNotExistException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EntityDoesNotExistException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for EntityDoesNotExistException {}
/// See [`EntityDoesNotExistException`](crate::error::EntityDoesNotExistException)
pub mod entity_does_not_exist_exception {
    /// A builder for [`EntityDoesNotExistException`](crate::error::EntityDoesNotExistException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`EntityDoesNotExistException`](crate::error::EntityDoesNotExistException)
        pub fn build(self) -> crate::error::EntityDoesNotExistException {
            crate::error::EntityDoesNotExistException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl EntityDoesNotExistException {
    /// Creates a new builder-style object to manufacture [`EntityDoesNotExistException`](crate::error::EntityDoesNotExistException)
    pub fn builder() -> crate::error::entity_does_not_exist_exception::Builder {
        crate::error::entity_does_not_exist_exception::Builder::default()
    }
}

/// <p>A client exception has occurred.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClientException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl ClientException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for ClientException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClientException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl ClientException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClientException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClientException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClientException {}
/// See [`ClientException`](crate::error::ClientException)
pub mod client_exception {
    /// A builder for [`ClientException`](crate::error::ClientException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ClientException`](crate::error::ClientException)
        pub fn build(self) -> crate::error::ClientException {
            crate::error::ClientException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl ClientException {
    /// Creates a new builder-style object to manufacture [`ClientException`](crate::error::ClientException)
    pub fn builder() -> crate::error::client_exception::Builder {
        crate::error::client_exception::Builder::default()
    }
}

/// <p>The maximum allowed number of domain controllers per directory was exceeded. The
/// default limit per directory is 20 domain controllers.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainControllerLimitExceededException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl DomainControllerLimitExceededException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for DomainControllerLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainControllerLimitExceededException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl DomainControllerLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DomainControllerLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DomainControllerLimitExceededException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for DomainControllerLimitExceededException {}
/// See [`DomainControllerLimitExceededException`](crate::error::DomainControllerLimitExceededException)
pub mod domain_controller_limit_exceeded_exception {
    /// A builder for [`DomainControllerLimitExceededException`](crate::error::DomainControllerLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainControllerLimitExceededException`](crate::error::DomainControllerLimitExceededException)
        pub fn build(self) -> crate::error::DomainControllerLimitExceededException {
            crate::error::DomainControllerLimitExceededException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl DomainControllerLimitExceededException {
    /// Creates a new builder-style object to manufacture [`DomainControllerLimitExceededException`](crate::error::DomainControllerLimitExceededException)
    pub fn builder() -> crate::error::domain_controller_limit_exceeded_exception::Builder {
        crate::error::domain_controller_limit_exceeded_exception::Builder::default()
    }
}

/// <p>The specified directory is unavailable or could not be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DirectoryUnavailableException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl DirectoryUnavailableException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for DirectoryUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DirectoryUnavailableException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl DirectoryUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DirectoryUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DirectoryUnavailableException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for DirectoryUnavailableException {}
/// See [`DirectoryUnavailableException`](crate::error::DirectoryUnavailableException)
pub mod directory_unavailable_exception {
    /// A builder for [`DirectoryUnavailableException`](crate::error::DirectoryUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DirectoryUnavailableException`](crate::error::DirectoryUnavailableException)
        pub fn build(self) -> crate::error::DirectoryUnavailableException {
            crate::error::DirectoryUnavailableException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl DirectoryUnavailableException {
    /// Creates a new builder-style object to manufacture [`DirectoryUnavailableException`](crate::error::DirectoryUnavailableException)
    pub fn builder() -> crate::error::directory_unavailable_exception::Builder {
        crate::error::directory_unavailable_exception::Builder::default()
    }
}

/// <p>The specified shared target is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidTargetException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl InvalidTargetException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for InvalidTargetException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidTargetException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl InvalidTargetException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidTargetException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidTargetException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidTargetException {}
/// See [`InvalidTargetException`](crate::error::InvalidTargetException)
pub mod invalid_target_exception {
    /// A builder for [`InvalidTargetException`](crate::error::InvalidTargetException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidTargetException`](crate::error::InvalidTargetException)
        pub fn build(self) -> crate::error::InvalidTargetException {
            crate::error::InvalidTargetException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl InvalidTargetException {
    /// Creates a new builder-style object to manufacture [`InvalidTargetException`](crate::error::InvalidTargetException)
    pub fn builder() -> crate::error::invalid_target_exception::Builder {
        crate::error::invalid_target_exception::Builder::default()
    }
}

/// <p>The specified directory has not been shared with this Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DirectoryNotSharedException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl DirectoryNotSharedException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for DirectoryNotSharedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DirectoryNotSharedException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl DirectoryNotSharedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DirectoryNotSharedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DirectoryNotSharedException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for DirectoryNotSharedException {}
/// See [`DirectoryNotSharedException`](crate::error::DirectoryNotSharedException)
pub mod directory_not_shared_exception {
    /// A builder for [`DirectoryNotSharedException`](crate::error::DirectoryNotSharedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DirectoryNotSharedException`](crate::error::DirectoryNotSharedException)
        pub fn build(self) -> crate::error::DirectoryNotSharedException {
            crate::error::DirectoryNotSharedException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl DirectoryNotSharedException {
    /// Creates a new builder-style object to manufacture [`DirectoryNotSharedException`](crate::error::DirectoryNotSharedException)
    pub fn builder() -> crate::error::directory_not_shared_exception::Builder {
        crate::error::directory_not_shared_exception::Builder::default()
    }
}

/// <p>The maximum number of manual snapshots for the directory has been reached. You can
/// use the <a>GetSnapshotLimits</a> operation to determine the snapshot limits
/// for a directory.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnapshotLimitExceededException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl SnapshotLimitExceededException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for SnapshotLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnapshotLimitExceededException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl SnapshotLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SnapshotLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SnapshotLimitExceededException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for SnapshotLimitExceededException {}
/// See [`SnapshotLimitExceededException`](crate::error::SnapshotLimitExceededException)
pub mod snapshot_limit_exceeded_exception {
    /// A builder for [`SnapshotLimitExceededException`](crate::error::SnapshotLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SnapshotLimitExceededException`](crate::error::SnapshotLimitExceededException)
        pub fn build(self) -> crate::error::SnapshotLimitExceededException {
            crate::error::SnapshotLimitExceededException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl SnapshotLimitExceededException {
    /// Creates a new builder-style object to manufacture [`SnapshotLimitExceededException`](crate::error::SnapshotLimitExceededException)
    pub fn builder() -> crate::error::snapshot_limit_exceeded_exception::Builder {
        crate::error::snapshot_limit_exceeded_exception::Builder::default()
    }
}

/// <p>The maximum number of Amazon Web Services accounts that you can share with this directory has been
/// reached.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ShareLimitExceededException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl ShareLimitExceededException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for ShareLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ShareLimitExceededException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl ShareLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ShareLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ShareLimitExceededException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for ShareLimitExceededException {}
/// See [`ShareLimitExceededException`](crate::error::ShareLimitExceededException)
pub mod share_limit_exceeded_exception {
    /// A builder for [`ShareLimitExceededException`](crate::error::ShareLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ShareLimitExceededException`](crate::error::ShareLimitExceededException)
        pub fn build(self) -> crate::error::ShareLimitExceededException {
            crate::error::ShareLimitExceededException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl ShareLimitExceededException {
    /// Creates a new builder-style object to manufacture [`ShareLimitExceededException`](crate::error::ShareLimitExceededException)
    pub fn builder() -> crate::error::share_limit_exceeded_exception::Builder {
        crate::error::share_limit_exceeded_exception::Builder::default()
    }
}

/// <p>Exception encountered while trying to access your Amazon Web Services organization.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationsException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl OrganizationsException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for OrganizationsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationsException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl OrganizationsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OrganizationsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OrganizationsException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for OrganizationsException {}
/// See [`OrganizationsException`](crate::error::OrganizationsException)
pub mod organizations_exception {
    /// A builder for [`OrganizationsException`](crate::error::OrganizationsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationsException`](crate::error::OrganizationsException)
        pub fn build(self) -> crate::error::OrganizationsException {
            crate::error::OrganizationsException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl OrganizationsException {
    /// Creates a new builder-style object to manufacture [`OrganizationsException`](crate::error::OrganizationsException)
    pub fn builder() -> crate::error::organizations_exception::Builder {
        crate::error::organizations_exception::Builder::default()
    }
}

/// <p>The specified directory has already been shared with this Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DirectoryAlreadySharedException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl DirectoryAlreadySharedException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for DirectoryAlreadySharedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DirectoryAlreadySharedException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl DirectoryAlreadySharedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DirectoryAlreadySharedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DirectoryAlreadySharedException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for DirectoryAlreadySharedException {}
/// See [`DirectoryAlreadySharedException`](crate::error::DirectoryAlreadySharedException)
pub mod directory_already_shared_exception {
    /// A builder for [`DirectoryAlreadySharedException`](crate::error::DirectoryAlreadySharedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DirectoryAlreadySharedException`](crate::error::DirectoryAlreadySharedException)
        pub fn build(self) -> crate::error::DirectoryAlreadySharedException {
            crate::error::DirectoryAlreadySharedException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl DirectoryAlreadySharedException {
    /// Creates a new builder-style object to manufacture [`DirectoryAlreadySharedException`](crate::error::DirectoryAlreadySharedException)
    pub fn builder() -> crate::error::directory_already_shared_exception::Builder {
        crate::error::directory_already_shared_exception::Builder::default()
    }
}

/// <p>Client authentication is not available in this region at this time.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl AccessDeniedException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>The user provided a username that does not exist in your directory.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserDoesNotExistException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl UserDoesNotExistException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for UserDoesNotExistException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserDoesNotExistException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl UserDoesNotExistException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UserDoesNotExistException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UserDoesNotExistException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for UserDoesNotExistException {}
/// See [`UserDoesNotExistException`](crate::error::UserDoesNotExistException)
pub mod user_does_not_exist_exception {
    /// A builder for [`UserDoesNotExistException`](crate::error::UserDoesNotExistException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UserDoesNotExistException`](crate::error::UserDoesNotExistException)
        pub fn build(self) -> crate::error::UserDoesNotExistException {
            crate::error::UserDoesNotExistException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl UserDoesNotExistException {
    /// Creates a new builder-style object to manufacture [`UserDoesNotExistException`](crate::error::UserDoesNotExistException)
    pub fn builder() -> crate::error::user_does_not_exist_exception::Builder {
        crate::error::user_does_not_exist_exception::Builder::default()
    }
}

/// <p>The new password provided by the user does not meet the password complexity
/// requirements defined in your directory.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidPasswordException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl InvalidPasswordException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for InvalidPasswordException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidPasswordException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl InvalidPasswordException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidPasswordException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidPasswordException")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidPasswordException {}
/// See [`InvalidPasswordException`](crate::error::InvalidPasswordException)
pub mod invalid_password_exception {
    /// A builder for [`InvalidPasswordException`](crate::error::InvalidPasswordException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidPasswordException`](crate::error::InvalidPasswordException)
        pub fn build(self) -> crate::error::InvalidPasswordException {
            crate::error::InvalidPasswordException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl InvalidPasswordException {
    /// Creates a new builder-style object to manufacture [`InvalidPasswordException`](crate::error::InvalidPasswordException)
    pub fn builder() -> crate::error::invalid_password_exception::Builder {
        crate::error::invalid_password_exception::Builder::default()
    }
}

/// <p>The specified directory does not exist in the system.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DirectoryDoesNotExistException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl DirectoryDoesNotExistException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for DirectoryDoesNotExistException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DirectoryDoesNotExistException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl DirectoryDoesNotExistException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DirectoryDoesNotExistException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DirectoryDoesNotExistException")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for DirectoryDoesNotExistException {}
/// See [`DirectoryDoesNotExistException`](crate::error::DirectoryDoesNotExistException)
pub mod directory_does_not_exist_exception {
    /// A builder for [`DirectoryDoesNotExistException`](crate::error::DirectoryDoesNotExistException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DirectoryDoesNotExistException`](crate::error::DirectoryDoesNotExistException)
        pub fn build(self) -> crate::error::DirectoryDoesNotExistException {
            crate::error::DirectoryDoesNotExistException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl DirectoryDoesNotExistException {
    /// Creates a new builder-style object to manufacture [`DirectoryDoesNotExistException`](crate::error::DirectoryDoesNotExistException)
    pub fn builder() -> crate::error::directory_does_not_exist_exception::Builder {
        crate::error::directory_does_not_exist_exception::Builder::default()
    }
}

/// <p>The certificate PEM that was provided has incorrect encoding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidCertificateException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl InvalidCertificateException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for InvalidCertificateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidCertificateException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl InvalidCertificateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidCertificateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidCertificateException")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidCertificateException {}
/// See [`InvalidCertificateException`](crate::error::InvalidCertificateException)
pub mod invalid_certificate_exception {
    /// A builder for [`InvalidCertificateException`](crate::error::InvalidCertificateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidCertificateException`](crate::error::InvalidCertificateException)
        pub fn build(self) -> crate::error::InvalidCertificateException {
            crate::error::InvalidCertificateException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl InvalidCertificateException {
    /// Creates a new builder-style object to manufacture [`InvalidCertificateException`](crate::error::InvalidCertificateException)
    pub fn builder() -> crate::error::invalid_certificate_exception::Builder {
        crate::error::invalid_certificate_exception::Builder::default()
    }
}

/// <p>The certificate could not be added because the certificate limit has been reached.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CertificateLimitExceededException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl CertificateLimitExceededException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for CertificateLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CertificateLimitExceededException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl CertificateLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CertificateLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CertificateLimitExceededException")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for CertificateLimitExceededException {}
/// See [`CertificateLimitExceededException`](crate::error::CertificateLimitExceededException)
pub mod certificate_limit_exceeded_exception {
    /// A builder for [`CertificateLimitExceededException`](crate::error::CertificateLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CertificateLimitExceededException`](crate::error::CertificateLimitExceededException)
        pub fn build(self) -> crate::error::CertificateLimitExceededException {
            crate::error::CertificateLimitExceededException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl CertificateLimitExceededException {
    /// Creates a new builder-style object to manufacture [`CertificateLimitExceededException`](crate::error::CertificateLimitExceededException)
    pub fn builder() -> crate::error::certificate_limit_exceeded_exception::Builder {
        crate::error::certificate_limit_exceeded_exception::Builder::default()
    }
}

/// <p>The certificate has already been registered into the system.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CertificateAlreadyExistsException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl CertificateAlreadyExistsException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for CertificateAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CertificateAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl CertificateAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CertificateAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CertificateAlreadyExistsException")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for CertificateAlreadyExistsException {}
/// See [`CertificateAlreadyExistsException`](crate::error::CertificateAlreadyExistsException)
pub mod certificate_already_exists_exception {
    /// A builder for [`CertificateAlreadyExistsException`](crate::error::CertificateAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CertificateAlreadyExistsException`](crate::error::CertificateAlreadyExistsException)
        pub fn build(self) -> crate::error::CertificateAlreadyExistsException {
            crate::error::CertificateAlreadyExistsException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl CertificateAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`CertificateAlreadyExistsException`](crate::error::CertificateAlreadyExistsException)
    pub fn builder() -> crate::error::certificate_already_exists_exception::Builder {
        crate::error::certificate_already_exists_exception::Builder::default()
    }
}

/// <p>The <code>NextToken</code> value is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidNextTokenException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl InvalidNextTokenException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidNextTokenException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl InvalidNextTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidNextTokenException")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidNextTokenException {}
/// See [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
pub mod invalid_next_token_exception {
    /// A builder for [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
        pub fn build(self) -> crate::error::InvalidNextTokenException {
            crate::error::InvalidNextTokenException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl InvalidNextTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    pub fn builder() -> crate::error::invalid_next_token_exception::Builder {
        crate::error::invalid_next_token_exception::Builder::default()
    }
}

/// <p>The account does not have sufficient permission to perform the operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsufficientPermissionsException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl InsufficientPermissionsException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for InsufficientPermissionsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsufficientPermissionsException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl InsufficientPermissionsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InsufficientPermissionsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InsufficientPermissionsException")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for InsufficientPermissionsException {}
/// See [`InsufficientPermissionsException`](crate::error::InsufficientPermissionsException)
pub mod insufficient_permissions_exception {
    /// A builder for [`InsufficientPermissionsException`](crate::error::InsufficientPermissionsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`InsufficientPermissionsException`](crate::error::InsufficientPermissionsException)
        pub fn build(self) -> crate::error::InsufficientPermissionsException {
            crate::error::InsufficientPermissionsException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl InsufficientPermissionsException {
    /// Creates a new builder-style object to manufacture [`InsufficientPermissionsException`](crate::error::InsufficientPermissionsException)
    pub fn builder() -> crate::error::insufficient_permissions_exception::Builder {
        crate::error::insufficient_permissions_exception::Builder::default()
    }
}

/// <p>An authentication error occurred.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthenticationFailedException {
    /// <p>The textual message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The identifier of the request that caused the exception.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl AuthenticationFailedException {
    /// <p>The identifier of the request that caused the exception.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for AuthenticationFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthenticationFailedException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl AuthenticationFailedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AuthenticationFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AuthenticationFailedException")?;
        if let Some(inner_23) = &self.message {
            write!(f, ": {}", inner_23)?;
        }
        Ok(())
    }
}
impl std::error::Error for AuthenticationFailedException {}
/// See [`AuthenticationFailedException`](crate::error::AuthenticationFailedException)
pub mod authentication_failed_exception {
    /// A builder for [`AuthenticationFailedException`](crate::error::AuthenticationFailedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The textual message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The textual message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The identifier of the request that caused the exception.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The identifier of the request that caused the exception.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthenticationFailedException`](crate::error::AuthenticationFailedException)
        pub fn build(self) -> crate::error::AuthenticationFailedException {
            crate::error::AuthenticationFailedException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl AuthenticationFailedException {
    /// Creates a new builder-style object to manufacture [`AuthenticationFailedException`](crate::error::AuthenticationFailedException)
    pub fn builder() -> crate::error::authentication_failed_exception::Builder {
        crate::error::authentication_failed_exception::Builder::default()
    }
}

/// <p>The specified entity already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntityAlreadyExistsException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl EntityAlreadyExistsException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for EntityAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntityAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl EntityAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EntityAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EntityAlreadyExistsException")?;
        if let Some(inner_24) = &self.message {
            write!(f, ": {}", inner_24)?;
        }
        Ok(())
    }
}
impl std::error::Error for EntityAlreadyExistsException {}
/// See [`EntityAlreadyExistsException`](crate::error::EntityAlreadyExistsException)
pub mod entity_already_exists_exception {
    /// A builder for [`EntityAlreadyExistsException`](crate::error::EntityAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`EntityAlreadyExistsException`](crate::error::EntityAlreadyExistsException)
        pub fn build(self) -> crate::error::EntityAlreadyExistsException {
            crate::error::EntityAlreadyExistsException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl EntityAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`EntityAlreadyExistsException`](crate::error::EntityAlreadyExistsException)
    pub fn builder() -> crate::error::entity_already_exists_exception::Builder {
        crate::error::entity_already_exists_exception::Builder::default()
    }
}

/// <p>Client authentication setup could not be completed because at least one valid certificate must be
/// registered in the system.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoAvailableCertificateException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl NoAvailableCertificateException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for NoAvailableCertificateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoAvailableCertificateException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl NoAvailableCertificateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoAvailableCertificateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoAvailableCertificateException")?;
        if let Some(inner_25) = &self.message {
            write!(f, ": {}", inner_25)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoAvailableCertificateException {}
/// See [`NoAvailableCertificateException`](crate::error::NoAvailableCertificateException)
pub mod no_available_certificate_exception {
    /// A builder for [`NoAvailableCertificateException`](crate::error::NoAvailableCertificateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`NoAvailableCertificateException`](crate::error::NoAvailableCertificateException)
        pub fn build(self) -> crate::error::NoAvailableCertificateException {
            crate::error::NoAvailableCertificateException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl NoAvailableCertificateException {
    /// Creates a new builder-style object to manufacture [`NoAvailableCertificateException`](crate::error::NoAvailableCertificateException)
    pub fn builder() -> crate::error::no_available_certificate_exception::Builder {
        crate::error::no_available_certificate_exception::Builder::default()
    }
}

/// <p>The LDAP activities could not be performed because they are limited by the LDAPS
/// status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidLdapsStatusException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl InvalidLdapsStatusException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for InvalidLdapsStatusException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidLdapsStatusException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl InvalidLdapsStatusException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidLdapsStatusException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "InvalidLdapsStatusException [InvalidLDAPSStatusException]"
        )?;
        if let Some(inner_26) = &self.message {
            write!(f, ": {}", inner_26)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidLdapsStatusException {}
/// See [`InvalidLdapsStatusException`](crate::error::InvalidLdapsStatusException)
pub mod invalid_ldaps_status_exception {
    /// A builder for [`InvalidLdapsStatusException`](crate::error::InvalidLdapsStatusException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidLdapsStatusException`](crate::error::InvalidLdapsStatusException)
        pub fn build(self) -> crate::error::InvalidLdapsStatusException {
            crate::error::InvalidLdapsStatusException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl InvalidLdapsStatusException {
    /// Creates a new builder-style object to manufacture [`InvalidLdapsStatusException`](crate::error::InvalidLdapsStatusException)
    pub fn builder() -> crate::error::invalid_ldaps_status_exception::Builder {
        crate::error::invalid_ldaps_status_exception::Builder::default()
    }
}

/// <p>Client authentication is already enabled.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidClientAuthStatusException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl InvalidClientAuthStatusException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for InvalidClientAuthStatusException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidClientAuthStatusException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl InvalidClientAuthStatusException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidClientAuthStatusException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidClientAuthStatusException")?;
        if let Some(inner_27) = &self.message {
            write!(f, ": {}", inner_27)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidClientAuthStatusException {}
/// See [`InvalidClientAuthStatusException`](crate::error::InvalidClientAuthStatusException)
pub mod invalid_client_auth_status_exception {
    /// A builder for [`InvalidClientAuthStatusException`](crate::error::InvalidClientAuthStatusException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidClientAuthStatusException`](crate::error::InvalidClientAuthStatusException)
        pub fn build(self) -> crate::error::InvalidClientAuthStatusException {
            crate::error::InvalidClientAuthStatusException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl InvalidClientAuthStatusException {
    /// Creates a new builder-style object to manufacture [`InvalidClientAuthStatusException`](crate::error::InvalidClientAuthStatusException)
    pub fn builder() -> crate::error::invalid_client_auth_status_exception::Builder {
        crate::error::invalid_client_auth_status_exception::Builder::default()
    }
}

/// <p>The certificate is not present in the system for describe or deregister activities.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CertificateDoesNotExistException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl CertificateDoesNotExistException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for CertificateDoesNotExistException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CertificateDoesNotExistException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl CertificateDoesNotExistException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CertificateDoesNotExistException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CertificateDoesNotExistException")?;
        if let Some(inner_28) = &self.message {
            write!(f, ": {}", inner_28)?;
        }
        Ok(())
    }
}
impl std::error::Error for CertificateDoesNotExistException {}
/// See [`CertificateDoesNotExistException`](crate::error::CertificateDoesNotExistException)
pub mod certificate_does_not_exist_exception {
    /// A builder for [`CertificateDoesNotExistException`](crate::error::CertificateDoesNotExistException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CertificateDoesNotExistException`](crate::error::CertificateDoesNotExistException)
        pub fn build(self) -> crate::error::CertificateDoesNotExistException {
            crate::error::CertificateDoesNotExistException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl CertificateDoesNotExistException {
    /// Creates a new builder-style object to manufacture [`CertificateDoesNotExistException`](crate::error::CertificateDoesNotExistException)
    pub fn builder() -> crate::error::certificate_does_not_exist_exception::Builder {
        crate::error::certificate_does_not_exist_exception::Builder::default()
    }
}

/// <p>The certificate is being used for the LDAP security connection and cannot be removed
/// without disabling LDAP security.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CertificateInUseException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl CertificateInUseException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for CertificateInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CertificateInUseException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl CertificateInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CertificateInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CertificateInUseException")?;
        if let Some(inner_29) = &self.message {
            write!(f, ": {}", inner_29)?;
        }
        Ok(())
    }
}
impl std::error::Error for CertificateInUseException {}
/// See [`CertificateInUseException`](crate::error::CertificateInUseException)
pub mod certificate_in_use_exception {
    /// A builder for [`CertificateInUseException`](crate::error::CertificateInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CertificateInUseException`](crate::error::CertificateInUseException)
        pub fn build(self) -> crate::error::CertificateInUseException {
            crate::error::CertificateInUseException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl CertificateInUseException {
    /// Creates a new builder-style object to manufacture [`CertificateInUseException`](crate::error::CertificateInUseException)
    pub fn builder() -> crate::error::certificate_in_use_exception::Builder {
        crate::error::certificate_in_use_exception::Builder::default()
    }
}

/// <p>The maximum number of directories in the region has been reached. You can use the
/// <a>GetDirectoryLimits</a> operation to determine your directory limits in
/// the region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DirectoryLimitExceededException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl DirectoryLimitExceededException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for DirectoryLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DirectoryLimitExceededException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl DirectoryLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DirectoryLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DirectoryLimitExceededException")?;
        if let Some(inner_30) = &self.message {
            write!(f, ": {}", inner_30)?;
        }
        Ok(())
    }
}
impl std::error::Error for DirectoryLimitExceededException {}
/// See [`DirectoryLimitExceededException`](crate::error::DirectoryLimitExceededException)
pub mod directory_limit_exceeded_exception {
    /// A builder for [`DirectoryLimitExceededException`](crate::error::DirectoryLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DirectoryLimitExceededException`](crate::error::DirectoryLimitExceededException)
        pub fn build(self) -> crate::error::DirectoryLimitExceededException {
            crate::error::DirectoryLimitExceededException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl DirectoryLimitExceededException {
    /// Creates a new builder-style object to manufacture [`DirectoryLimitExceededException`](crate::error::DirectoryLimitExceededException)
    pub fn builder() -> crate::error::directory_limit_exceeded_exception::Builder {
        crate::error::directory_limit_exceeded_exception::Builder::default()
    }
}

/// <p>The maximum allowed number of tags was exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagLimitExceededException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl TagLimitExceededException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for TagLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagLimitExceededException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl TagLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TagLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TagLimitExceededException")?;
        if let Some(inner_31) = &self.message {
            write!(f, ": {}", inner_31)?;
        }
        Ok(())
    }
}
impl std::error::Error for TagLimitExceededException {}
/// See [`TagLimitExceededException`](crate::error::TagLimitExceededException)
pub mod tag_limit_exceeded_exception {
    /// A builder for [`TagLimitExceededException`](crate::error::TagLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`TagLimitExceededException`](crate::error::TagLimitExceededException)
        pub fn build(self) -> crate::error::TagLimitExceededException {
            crate::error::TagLimitExceededException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl TagLimitExceededException {
    /// Creates a new builder-style object to manufacture [`TagLimitExceededException`](crate::error::TagLimitExceededException)
    pub fn builder() -> crate::error::tag_limit_exceeded_exception::Builder {
        crate::error::tag_limit_exceeded_exception::Builder::default()
    }
}

/// <p>You have reached the limit for maximum number of simultaneous Region replications per
/// directory.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegionLimitExceededException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl RegionLimitExceededException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for RegionLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegionLimitExceededException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl RegionLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RegionLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RegionLimitExceededException")?;
        if let Some(inner_32) = &self.message {
            write!(f, ": {}", inner_32)?;
        }
        Ok(())
    }
}
impl std::error::Error for RegionLimitExceededException {}
/// See [`RegionLimitExceededException`](crate::error::RegionLimitExceededException)
pub mod region_limit_exceeded_exception {
    /// A builder for [`RegionLimitExceededException`](crate::error::RegionLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RegionLimitExceededException`](crate::error::RegionLimitExceededException)
        pub fn build(self) -> crate::error::RegionLimitExceededException {
            crate::error::RegionLimitExceededException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl RegionLimitExceededException {
    /// Creates a new builder-style object to manufacture [`RegionLimitExceededException`](crate::error::RegionLimitExceededException)
    pub fn builder() -> crate::error::region_limit_exceeded_exception::Builder {
        crate::error::region_limit_exceeded_exception::Builder::default()
    }
}

/// <p>The Region you specified is the same Region where the Managed Microsoft AD directory
/// was created. Specify a different Region and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DirectoryAlreadyInRegionException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl DirectoryAlreadyInRegionException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for DirectoryAlreadyInRegionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DirectoryAlreadyInRegionException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl DirectoryAlreadyInRegionException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DirectoryAlreadyInRegionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DirectoryAlreadyInRegionException")?;
        if let Some(inner_33) = &self.message {
            write!(f, ": {}", inner_33)?;
        }
        Ok(())
    }
}
impl std::error::Error for DirectoryAlreadyInRegionException {}
/// See [`DirectoryAlreadyInRegionException`](crate::error::DirectoryAlreadyInRegionException)
pub mod directory_already_in_region_exception {
    /// A builder for [`DirectoryAlreadyInRegionException`](crate::error::DirectoryAlreadyInRegionException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DirectoryAlreadyInRegionException`](crate::error::DirectoryAlreadyInRegionException)
        pub fn build(self) -> crate::error::DirectoryAlreadyInRegionException {
            crate::error::DirectoryAlreadyInRegionException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl DirectoryAlreadyInRegionException {
    /// Creates a new builder-style object to manufacture [`DirectoryAlreadyInRegionException`](crate::error::DirectoryAlreadyInRegionException)
    pub fn builder() -> crate::error::directory_already_in_region_exception::Builder {
        crate::error::directory_already_in_region_exception::Builder::default()
    }
}

/// <p>The maximum allowed number of IP addresses was exceeded. The default limit is 100 IP
/// address blocks.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IpRouteLimitExceededException {
    /// <p>The descriptive message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request identifier.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl IpRouteLimitExceededException {
    /// <p>The Amazon Web Services request identifier.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for IpRouteLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IpRouteLimitExceededException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl IpRouteLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IpRouteLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IpRouteLimitExceededException")?;
        if let Some(inner_34) = &self.message {
            write!(f, ": {}", inner_34)?;
        }
        Ok(())
    }
}
impl std::error::Error for IpRouteLimitExceededException {}
/// See [`IpRouteLimitExceededException`](crate::error::IpRouteLimitExceededException)
pub mod ip_route_limit_exceeded_exception {
    /// A builder for [`IpRouteLimitExceededException`](crate::error::IpRouteLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The descriptive message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request identifier.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`IpRouteLimitExceededException`](crate::error::IpRouteLimitExceededException)
        pub fn build(self) -> crate::error::IpRouteLimitExceededException {
            crate::error::IpRouteLimitExceededException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl IpRouteLimitExceededException {
    /// Creates a new builder-style object to manufacture [`IpRouteLimitExceededException`](crate::error::IpRouteLimitExceededException)
    pub fn builder() -> crate::error::ip_route_limit_exceeded_exception::Builder {
        crate::error::ip_route_limit_exceeded_exception::Builder::default()
    }
}
