// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `DirectoryService_20150416`.
///
/// This client allows ergonomic access to a `DirectoryService_20150416`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AcceptSharedDirectory` operation.
    ///
    /// See [`AcceptSharedDirectory`](crate::client::fluent_builders::AcceptSharedDirectory) for more information about the
    /// operation and its arguments.
    pub fn accept_shared_directory(&self) -> fluent_builders::AcceptSharedDirectory<C, M, R> {
        fluent_builders::AcceptSharedDirectory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AddIpRoutes` operation.
    ///
    /// See [`AddIpRoutes`](crate::client::fluent_builders::AddIpRoutes) for more information about the
    /// operation and its arguments.
    pub fn add_ip_routes(&self) -> fluent_builders::AddIpRoutes<C, M, R> {
        fluent_builders::AddIpRoutes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AddRegion` operation.
    ///
    /// See [`AddRegion`](crate::client::fluent_builders::AddRegion) for more information about the
    /// operation and its arguments.
    pub fn add_region(&self) -> fluent_builders::AddRegion<C, M, R> {
        fluent_builders::AddRegion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AddTagsToResource` operation.
    ///
    /// See [`AddTagsToResource`](crate::client::fluent_builders::AddTagsToResource) for more information about the
    /// operation and its arguments.
    pub fn add_tags_to_resource(&self) -> fluent_builders::AddTagsToResource<C, M, R> {
        fluent_builders::AddTagsToResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelSchemaExtension` operation.
    ///
    /// See [`CancelSchemaExtension`](crate::client::fluent_builders::CancelSchemaExtension) for more information about the
    /// operation and its arguments.
    pub fn cancel_schema_extension(&self) -> fluent_builders::CancelSchemaExtension<C, M, R> {
        fluent_builders::CancelSchemaExtension::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ConnectDirectory` operation.
    ///
    /// See [`ConnectDirectory`](crate::client::fluent_builders::ConnectDirectory) for more information about the
    /// operation and its arguments.
    pub fn connect_directory(&self) -> fluent_builders::ConnectDirectory<C, M, R> {
        fluent_builders::ConnectDirectory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAlias` operation.
    ///
    /// See [`CreateAlias`](crate::client::fluent_builders::CreateAlias) for more information about the
    /// operation and its arguments.
    pub fn create_alias(&self) -> fluent_builders::CreateAlias<C, M, R> {
        fluent_builders::CreateAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateComputer` operation.
    ///
    /// See [`CreateComputer`](crate::client::fluent_builders::CreateComputer) for more information about the
    /// operation and its arguments.
    pub fn create_computer(&self) -> fluent_builders::CreateComputer<C, M, R> {
        fluent_builders::CreateComputer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateConditionalForwarder` operation.
    ///
    /// See [`CreateConditionalForwarder`](crate::client::fluent_builders::CreateConditionalForwarder) for more information about the
    /// operation and its arguments.
    pub fn create_conditional_forwarder(
        &self,
    ) -> fluent_builders::CreateConditionalForwarder<C, M, R> {
        fluent_builders::CreateConditionalForwarder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDirectory` operation.
    ///
    /// See [`CreateDirectory`](crate::client::fluent_builders::CreateDirectory) for more information about the
    /// operation and its arguments.
    pub fn create_directory(&self) -> fluent_builders::CreateDirectory<C, M, R> {
        fluent_builders::CreateDirectory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLogSubscription` operation.
    ///
    /// See [`CreateLogSubscription`](crate::client::fluent_builders::CreateLogSubscription) for more information about the
    /// operation and its arguments.
    pub fn create_log_subscription(&self) -> fluent_builders::CreateLogSubscription<C, M, R> {
        fluent_builders::CreateLogSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateMicrosoftAD` operation.
    ///
    /// See [`CreateMicrosoftAD`](crate::client::fluent_builders::CreateMicrosoftAD) for more information about the
    /// operation and its arguments.
    pub fn create_microsoft_ad(&self) -> fluent_builders::CreateMicrosoftAD<C, M, R> {
        fluent_builders::CreateMicrosoftAD::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSnapshot` operation.
    ///
    /// See [`CreateSnapshot`](crate::client::fluent_builders::CreateSnapshot) for more information about the
    /// operation and its arguments.
    pub fn create_snapshot(&self) -> fluent_builders::CreateSnapshot<C, M, R> {
        fluent_builders::CreateSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTrust` operation.
    ///
    /// See [`CreateTrust`](crate::client::fluent_builders::CreateTrust) for more information about the
    /// operation and its arguments.
    pub fn create_trust(&self) -> fluent_builders::CreateTrust<C, M, R> {
        fluent_builders::CreateTrust::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteConditionalForwarder` operation.
    ///
    /// See [`DeleteConditionalForwarder`](crate::client::fluent_builders::DeleteConditionalForwarder) for more information about the
    /// operation and its arguments.
    pub fn delete_conditional_forwarder(
        &self,
    ) -> fluent_builders::DeleteConditionalForwarder<C, M, R> {
        fluent_builders::DeleteConditionalForwarder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDirectory` operation.
    ///
    /// See [`DeleteDirectory`](crate::client::fluent_builders::DeleteDirectory) for more information about the
    /// operation and its arguments.
    pub fn delete_directory(&self) -> fluent_builders::DeleteDirectory<C, M, R> {
        fluent_builders::DeleteDirectory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLogSubscription` operation.
    ///
    /// See [`DeleteLogSubscription`](crate::client::fluent_builders::DeleteLogSubscription) for more information about the
    /// operation and its arguments.
    pub fn delete_log_subscription(&self) -> fluent_builders::DeleteLogSubscription<C, M, R> {
        fluent_builders::DeleteLogSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSnapshot` operation.
    ///
    /// See [`DeleteSnapshot`](crate::client::fluent_builders::DeleteSnapshot) for more information about the
    /// operation and its arguments.
    pub fn delete_snapshot(&self) -> fluent_builders::DeleteSnapshot<C, M, R> {
        fluent_builders::DeleteSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTrust` operation.
    ///
    /// See [`DeleteTrust`](crate::client::fluent_builders::DeleteTrust) for more information about the
    /// operation and its arguments.
    pub fn delete_trust(&self) -> fluent_builders::DeleteTrust<C, M, R> {
        fluent_builders::DeleteTrust::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeregisterCertificate` operation.
    ///
    /// See [`DeregisterCertificate`](crate::client::fluent_builders::DeregisterCertificate) for more information about the
    /// operation and its arguments.
    pub fn deregister_certificate(&self) -> fluent_builders::DeregisterCertificate<C, M, R> {
        fluent_builders::DeregisterCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeregisterEventTopic` operation.
    ///
    /// See [`DeregisterEventTopic`](crate::client::fluent_builders::DeregisterEventTopic) for more information about the
    /// operation and its arguments.
    pub fn deregister_event_topic(&self) -> fluent_builders::DeregisterEventTopic<C, M, R> {
        fluent_builders::DeregisterEventTopic::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCertificate` operation.
    ///
    /// See [`DescribeCertificate`](crate::client::fluent_builders::DescribeCertificate) for more information about the
    /// operation and its arguments.
    pub fn describe_certificate(&self) -> fluent_builders::DescribeCertificate<C, M, R> {
        fluent_builders::DescribeCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeClientAuthenticationSettings` operation.
    ///
    /// See [`DescribeClientAuthenticationSettings`](crate::client::fluent_builders::DescribeClientAuthenticationSettings) for more information about the
    /// operation and its arguments.
    pub fn describe_client_authentication_settings(
        &self,
    ) -> fluent_builders::DescribeClientAuthenticationSettings<C, M, R> {
        fluent_builders::DescribeClientAuthenticationSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeConditionalForwarders` operation.
    ///
    /// See [`DescribeConditionalForwarders`](crate::client::fluent_builders::DescribeConditionalForwarders) for more information about the
    /// operation and its arguments.
    pub fn describe_conditional_forwarders(
        &self,
    ) -> fluent_builders::DescribeConditionalForwarders<C, M, R> {
        fluent_builders::DescribeConditionalForwarders::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDirectories` operation.
    ///
    /// See [`DescribeDirectories`](crate::client::fluent_builders::DescribeDirectories) for more information about the
    /// operation and its arguments.
    pub fn describe_directories(&self) -> fluent_builders::DescribeDirectories<C, M, R> {
        fluent_builders::DescribeDirectories::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDomainControllers` operation.
    ///
    /// See [`DescribeDomainControllers`](crate::client::fluent_builders::DescribeDomainControllers) for more information about the
    /// operation and its arguments.
    pub fn describe_domain_controllers(
        &self,
    ) -> fluent_builders::DescribeDomainControllers<C, M, R> {
        fluent_builders::DescribeDomainControllers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEventTopics` operation.
    ///
    /// See [`DescribeEventTopics`](crate::client::fluent_builders::DescribeEventTopics) for more information about the
    /// operation and its arguments.
    pub fn describe_event_topics(&self) -> fluent_builders::DescribeEventTopics<C, M, R> {
        fluent_builders::DescribeEventTopics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLDAPSSettings` operation.
    ///
    /// See [`DescribeLDAPSSettings`](crate::client::fluent_builders::DescribeLDAPSSettings) for more information about the
    /// operation and its arguments.
    pub fn describe_ldaps_settings(&self) -> fluent_builders::DescribeLDAPSSettings<C, M, R> {
        fluent_builders::DescribeLDAPSSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRegions` operation.
    ///
    /// See [`DescribeRegions`](crate::client::fluent_builders::DescribeRegions) for more information about the
    /// operation and its arguments.
    pub fn describe_regions(&self) -> fluent_builders::DescribeRegions<C, M, R> {
        fluent_builders::DescribeRegions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSharedDirectories` operation.
    ///
    /// See [`DescribeSharedDirectories`](crate::client::fluent_builders::DescribeSharedDirectories) for more information about the
    /// operation and its arguments.
    pub fn describe_shared_directories(
        &self,
    ) -> fluent_builders::DescribeSharedDirectories<C, M, R> {
        fluent_builders::DescribeSharedDirectories::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSnapshots` operation.
    ///
    /// See [`DescribeSnapshots`](crate::client::fluent_builders::DescribeSnapshots) for more information about the
    /// operation and its arguments.
    pub fn describe_snapshots(&self) -> fluent_builders::DescribeSnapshots<C, M, R> {
        fluent_builders::DescribeSnapshots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTrusts` operation.
    ///
    /// See [`DescribeTrusts`](crate::client::fluent_builders::DescribeTrusts) for more information about the
    /// operation and its arguments.
    pub fn describe_trusts(&self) -> fluent_builders::DescribeTrusts<C, M, R> {
        fluent_builders::DescribeTrusts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableClientAuthentication` operation.
    ///
    /// See [`DisableClientAuthentication`](crate::client::fluent_builders::DisableClientAuthentication) for more information about the
    /// operation and its arguments.
    pub fn disable_client_authentication(
        &self,
    ) -> fluent_builders::DisableClientAuthentication<C, M, R> {
        fluent_builders::DisableClientAuthentication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableLDAPS` operation.
    ///
    /// See [`DisableLDAPS`](crate::client::fluent_builders::DisableLDAPS) for more information about the
    /// operation and its arguments.
    pub fn disable_ldaps(&self) -> fluent_builders::DisableLDAPS<C, M, R> {
        fluent_builders::DisableLDAPS::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableRadius` operation.
    ///
    /// See [`DisableRadius`](crate::client::fluent_builders::DisableRadius) for more information about the
    /// operation and its arguments.
    pub fn disable_radius(&self) -> fluent_builders::DisableRadius<C, M, R> {
        fluent_builders::DisableRadius::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableSso` operation.
    ///
    /// See [`DisableSso`](crate::client::fluent_builders::DisableSso) for more information about the
    /// operation and its arguments.
    pub fn disable_sso(&self) -> fluent_builders::DisableSso<C, M, R> {
        fluent_builders::DisableSso::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableClientAuthentication` operation.
    ///
    /// See [`EnableClientAuthentication`](crate::client::fluent_builders::EnableClientAuthentication) for more information about the
    /// operation and its arguments.
    pub fn enable_client_authentication(
        &self,
    ) -> fluent_builders::EnableClientAuthentication<C, M, R> {
        fluent_builders::EnableClientAuthentication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableLDAPS` operation.
    ///
    /// See [`EnableLDAPS`](crate::client::fluent_builders::EnableLDAPS) for more information about the
    /// operation and its arguments.
    pub fn enable_ldaps(&self) -> fluent_builders::EnableLDAPS<C, M, R> {
        fluent_builders::EnableLDAPS::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableRadius` operation.
    ///
    /// See [`EnableRadius`](crate::client::fluent_builders::EnableRadius) for more information about the
    /// operation and its arguments.
    pub fn enable_radius(&self) -> fluent_builders::EnableRadius<C, M, R> {
        fluent_builders::EnableRadius::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableSso` operation.
    ///
    /// See [`EnableSso`](crate::client::fluent_builders::EnableSso) for more information about the
    /// operation and its arguments.
    pub fn enable_sso(&self) -> fluent_builders::EnableSso<C, M, R> {
        fluent_builders::EnableSso::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDirectoryLimits` operation.
    ///
    /// See [`GetDirectoryLimits`](crate::client::fluent_builders::GetDirectoryLimits) for more information about the
    /// operation and its arguments.
    pub fn get_directory_limits(&self) -> fluent_builders::GetDirectoryLimits<C, M, R> {
        fluent_builders::GetDirectoryLimits::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSnapshotLimits` operation.
    ///
    /// See [`GetSnapshotLimits`](crate::client::fluent_builders::GetSnapshotLimits) for more information about the
    /// operation and its arguments.
    pub fn get_snapshot_limits(&self) -> fluent_builders::GetSnapshotLimits<C, M, R> {
        fluent_builders::GetSnapshotLimits::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCertificates` operation.
    ///
    /// See [`ListCertificates`](crate::client::fluent_builders::ListCertificates) for more information about the
    /// operation and its arguments.
    pub fn list_certificates(&self) -> fluent_builders::ListCertificates<C, M, R> {
        fluent_builders::ListCertificates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListIpRoutes` operation.
    ///
    /// See [`ListIpRoutes`](crate::client::fluent_builders::ListIpRoutes) for more information about the
    /// operation and its arguments.
    pub fn list_ip_routes(&self) -> fluent_builders::ListIpRoutes<C, M, R> {
        fluent_builders::ListIpRoutes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLogSubscriptions` operation.
    ///
    /// See [`ListLogSubscriptions`](crate::client::fluent_builders::ListLogSubscriptions) for more information about the
    /// operation and its arguments.
    pub fn list_log_subscriptions(&self) -> fluent_builders::ListLogSubscriptions<C, M, R> {
        fluent_builders::ListLogSubscriptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSchemaExtensions` operation.
    ///
    /// See [`ListSchemaExtensions`](crate::client::fluent_builders::ListSchemaExtensions) for more information about the
    /// operation and its arguments.
    pub fn list_schema_extensions(&self) -> fluent_builders::ListSchemaExtensions<C, M, R> {
        fluent_builders::ListSchemaExtensions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterCertificate` operation.
    ///
    /// See [`RegisterCertificate`](crate::client::fluent_builders::RegisterCertificate) for more information about the
    /// operation and its arguments.
    pub fn register_certificate(&self) -> fluent_builders::RegisterCertificate<C, M, R> {
        fluent_builders::RegisterCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterEventTopic` operation.
    ///
    /// See [`RegisterEventTopic`](crate::client::fluent_builders::RegisterEventTopic) for more information about the
    /// operation and its arguments.
    pub fn register_event_topic(&self) -> fluent_builders::RegisterEventTopic<C, M, R> {
        fluent_builders::RegisterEventTopic::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RejectSharedDirectory` operation.
    ///
    /// See [`RejectSharedDirectory`](crate::client::fluent_builders::RejectSharedDirectory) for more information about the
    /// operation and its arguments.
    pub fn reject_shared_directory(&self) -> fluent_builders::RejectSharedDirectory<C, M, R> {
        fluent_builders::RejectSharedDirectory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveIpRoutes` operation.
    ///
    /// See [`RemoveIpRoutes`](crate::client::fluent_builders::RemoveIpRoutes) for more information about the
    /// operation and its arguments.
    pub fn remove_ip_routes(&self) -> fluent_builders::RemoveIpRoutes<C, M, R> {
        fluent_builders::RemoveIpRoutes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveRegion` operation.
    ///
    /// See [`RemoveRegion`](crate::client::fluent_builders::RemoveRegion) for more information about the
    /// operation and its arguments.
    pub fn remove_region(&self) -> fluent_builders::RemoveRegion<C, M, R> {
        fluent_builders::RemoveRegion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveTagsFromResource` operation.
    ///
    /// See [`RemoveTagsFromResource`](crate::client::fluent_builders::RemoveTagsFromResource) for more information about the
    /// operation and its arguments.
    pub fn remove_tags_from_resource(&self) -> fluent_builders::RemoveTagsFromResource<C, M, R> {
        fluent_builders::RemoveTagsFromResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResetUserPassword` operation.
    ///
    /// See [`ResetUserPassword`](crate::client::fluent_builders::ResetUserPassword) for more information about the
    /// operation and its arguments.
    pub fn reset_user_password(&self) -> fluent_builders::ResetUserPassword<C, M, R> {
        fluent_builders::ResetUserPassword::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RestoreFromSnapshot` operation.
    ///
    /// See [`RestoreFromSnapshot`](crate::client::fluent_builders::RestoreFromSnapshot) for more information about the
    /// operation and its arguments.
    pub fn restore_from_snapshot(&self) -> fluent_builders::RestoreFromSnapshot<C, M, R> {
        fluent_builders::RestoreFromSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ShareDirectory` operation.
    ///
    /// See [`ShareDirectory`](crate::client::fluent_builders::ShareDirectory) for more information about the
    /// operation and its arguments.
    pub fn share_directory(&self) -> fluent_builders::ShareDirectory<C, M, R> {
        fluent_builders::ShareDirectory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartSchemaExtension` operation.
    ///
    /// See [`StartSchemaExtension`](crate::client::fluent_builders::StartSchemaExtension) for more information about the
    /// operation and its arguments.
    pub fn start_schema_extension(&self) -> fluent_builders::StartSchemaExtension<C, M, R> {
        fluent_builders::StartSchemaExtension::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UnshareDirectory` operation.
    ///
    /// See [`UnshareDirectory`](crate::client::fluent_builders::UnshareDirectory) for more information about the
    /// operation and its arguments.
    pub fn unshare_directory(&self) -> fluent_builders::UnshareDirectory<C, M, R> {
        fluent_builders::UnshareDirectory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateConditionalForwarder` operation.
    ///
    /// See [`UpdateConditionalForwarder`](crate::client::fluent_builders::UpdateConditionalForwarder) for more information about the
    /// operation and its arguments.
    pub fn update_conditional_forwarder(
        &self,
    ) -> fluent_builders::UpdateConditionalForwarder<C, M, R> {
        fluent_builders::UpdateConditionalForwarder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateNumberOfDomainControllers` operation.
    ///
    /// See [`UpdateNumberOfDomainControllers`](crate::client::fluent_builders::UpdateNumberOfDomainControllers) for more information about the
    /// operation and its arguments.
    pub fn update_number_of_domain_controllers(
        &self,
    ) -> fluent_builders::UpdateNumberOfDomainControllers<C, M, R> {
        fluent_builders::UpdateNumberOfDomainControllers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRadius` operation.
    ///
    /// See [`UpdateRadius`](crate::client::fluent_builders::UpdateRadius) for more information about the
    /// operation and its arguments.
    pub fn update_radius(&self) -> fluent_builders::UpdateRadius<C, M, R> {
        fluent_builders::UpdateRadius::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTrust` operation.
    ///
    /// See [`UpdateTrust`](crate::client::fluent_builders::UpdateTrust) for more information about the
    /// operation and its arguments.
    pub fn update_trust(&self) -> fluent_builders::UpdateTrust<C, M, R> {
        fluent_builders::UpdateTrust::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `VerifyTrust` operation.
    ///
    /// See [`VerifyTrust`](crate::client::fluent_builders::VerifyTrust) for more information about the
    /// operation and its arguments.
    pub fn verify_trust(&self) -> fluent_builders::VerifyTrust<C, M, R> {
        fluent_builders::VerifyTrust::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptSharedDirectory`.
    ///
    /// <p>Accepts a directory sharing request that was sent from the directory owner account.</p>
    #[derive(std::fmt::Debug)]
    pub struct AcceptSharedDirectory<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::accept_shared_directory_input::Builder,
    }
    impl<C, M, R> AcceptSharedDirectory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcceptSharedDirectory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptSharedDirectoryOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptSharedDirectoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AcceptSharedDirectoryInputOperationOutputAlias,
                crate::output::AcceptSharedDirectoryOutput,
                crate::error::AcceptSharedDirectoryError,
                crate::input::AcceptSharedDirectoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier of the shared directory in the directory consumer account. This identifier is
        /// different for each directory owner account. </p>
        pub fn shared_directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.shared_directory_id(inp);
            self
        }
        /// <p>Identifier of the shared directory in the directory consumer account. This identifier is
        /// different for each directory owner account. </p>
        pub fn set_shared_directory_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_shared_directory_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddIpRoutes`.
    ///
    /// <p>If the DNS server for your self-managed domain uses a publicly addressable IP address,
    /// you must add a CIDR address block to correctly route traffic to and from your Microsoft AD
    /// on Amazon Web Services. <i>AddIpRoutes</i> adds this address block. You can
    /// also use <i>AddIpRoutes</i> to facilitate routing traffic that uses public IP
    /// ranges from your Microsoft AD on Amazon Web Services to a peer VPC. </p>
    /// <p>Before you call <i>AddIpRoutes</i>, ensure that all of the required
    /// permissions have been explicitly granted through a policy. For details about what
    /// permissions are required to run the <i>AddIpRoutes</i> operation, see <a href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html">Directory Service API Permissions: Actions, Resources, and Conditions Reference</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct AddIpRoutes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_ip_routes_input::Builder,
    }
    impl<C, M, R> AddIpRoutes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddIpRoutes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddIpRoutesOutput,
            aws_smithy_http::result::SdkError<crate::error::AddIpRoutesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddIpRoutesInputOperationOutputAlias,
                crate::output::AddIpRoutesOutput,
                crate::error::AddIpRoutesError,
                crate::input::AddIpRoutesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier (ID) of the directory to which to add the address block.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>Identifier (ID) of the directory to which to add the address block.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// Appends an item to `IpRoutes`.
        ///
        /// To override the contents of this collection use [`set_ip_routes`](Self::set_ip_routes).
        ///
        /// <p>IP address blocks, using CIDR format, of the traffic to route. This is often the IP
        /// address block of the DNS server used for your self-managed domain.</p>
        pub fn ip_routes(mut self, inp: impl Into<crate::model::IpRoute>) -> Self {
            self.inner = self.inner.ip_routes(inp);
            self
        }
        /// <p>IP address blocks, using CIDR format, of the traffic to route. This is often the IP
        /// address block of the DNS server used for your self-managed domain.</p>
        pub fn set_ip_routes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpRoute>>,
        ) -> Self {
            self.inner = self.inner.set_ip_routes(input);
            self
        }
        /// <p>If set to true, updates the inbound and outbound rules of the security group that has
        /// the description: "Amazon Web Services created security group for <i>directory ID</i>
        /// directory controllers." Following are the new rules: </p>
        /// <p>Inbound:</p>
        /// <ul>
        /// <li>
        /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 88, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 123, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 138, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 389, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 464, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 445, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 88, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 135, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 445, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 464, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 636, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 1024-65535, Source:
        /// 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 3268-33269, Source:
        /// 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: DNS (UDP), Protocol: UDP, Range: 53, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: DNS (TCP), Protocol: TCP, Range: 53, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: LDAP, Protocol: TCP, Range: 389, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: All ICMP, Protocol: All, Range: N/A, Source: 0.0.0.0/0</p>
        /// </li>
        /// </ul>
        ///
        /// <p></p>
        /// <p>Outbound:</p>
        /// <ul>
        /// <li>
        /// <p>Type: All traffic, Protocol: All, Range: All, Destination: 0.0.0.0/0</p>
        /// </li>
        /// </ul>
        /// <p>These security rules impact an internal network interface that is not exposed
        /// publicly.</p>
        pub fn update_security_group_for_directory_controllers(mut self, inp: bool) -> Self {
            self.inner = self
                .inner
                .update_security_group_for_directory_controllers(inp);
            self
        }
        /// <p>If set to true, updates the inbound and outbound rules of the security group that has
        /// the description: "Amazon Web Services created security group for <i>directory ID</i>
        /// directory controllers." Following are the new rules: </p>
        /// <p>Inbound:</p>
        /// <ul>
        /// <li>
        /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 88, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 123, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 138, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 389, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 464, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom UDP Rule, Protocol: UDP, Range: 445, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 88, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 135, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 445, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 464, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 636, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 1024-65535, Source:
        /// 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: Custom TCP Rule, Protocol: TCP, Range: 3268-33269, Source:
        /// 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: DNS (UDP), Protocol: UDP, Range: 53, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: DNS (TCP), Protocol: TCP, Range: 53, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: LDAP, Protocol: TCP, Range: 389, Source: 0.0.0.0/0</p>
        /// </li>
        /// <li>
        /// <p>Type: All ICMP, Protocol: All, Range: N/A, Source: 0.0.0.0/0</p>
        /// </li>
        /// </ul>
        ///
        /// <p></p>
        /// <p>Outbound:</p>
        /// <ul>
        /// <li>
        /// <p>Type: All traffic, Protocol: All, Range: All, Destination: 0.0.0.0/0</p>
        /// </li>
        /// </ul>
        /// <p>These security rules impact an internal network interface that is not exposed
        /// publicly.</p>
        pub fn set_update_security_group_for_directory_controllers(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self
                .inner
                .set_update_security_group_for_directory_controllers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddRegion`.
    ///
    /// <p>Adds two domain controllers in the specified Region for the specified directory.</p>
    #[derive(std::fmt::Debug)]
    pub struct AddRegion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_region_input::Builder,
    }
    impl<C, M, R> AddRegion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddRegion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddRegionOutput,
            aws_smithy_http::result::SdkError<crate::error::AddRegionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddRegionInputOperationOutputAlias,
                crate::output::AddRegionOutput,
                crate::error::AddRegionError,
                crate::input::AddRegionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory to which you want to add Region replication.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The identifier of the directory to which you want to add Region replication.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The name of the Region where you want to add domain controllers for replication. For
        /// example, <code>us-east-1</code>.</p>
        pub fn region_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.region_name(inp);
            self
        }
        /// <p>The name of the Region where you want to add domain controllers for replication. For
        /// example, <code>us-east-1</code>.</p>
        pub fn set_region_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_region_name(input);
            self
        }
        /// <p>Contains VPC information for the <a>CreateDirectory</a> or <a>CreateMicrosoftAD</a> operation.</p>
        pub fn vpc_settings(mut self, inp: crate::model::DirectoryVpcSettings) -> Self {
            self.inner = self.inner.vpc_settings(inp);
            self
        }
        /// <p>Contains VPC information for the <a>CreateDirectory</a> or <a>CreateMicrosoftAD</a> operation.</p>
        pub fn set_vpc_settings(
            mut self,
            input: std::option::Option<crate::model::DirectoryVpcSettings>,
        ) -> Self {
            self.inner = self.inner.set_vpc_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddTagsToResource`.
    ///
    /// <p>Adds or overwrites one or more tags for the specified directory. Each directory can
    /// have a maximum of 50 tags. Each tag consists of a key and optional value. Tag keys must be
    /// unique to each resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct AddTagsToResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_tags_to_resource_input::Builder,
    }
    impl<C, M, R> AddTagsToResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddTagsToResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddTagsToResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::AddTagsToResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddTagsToResourceInputOperationOutputAlias,
                crate::output::AddTagsToResourceOutput,
                crate::error::AddTagsToResourceError,
                crate::input::AddTagsToResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier (ID) for the directory to which to add the tag.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>Identifier (ID) for the directory to which to add the tag.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the directory.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be assigned to the directory.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelSchemaExtension`.
    ///
    /// <p>Cancels an in-progress schema extension to a Microsoft AD directory. Once a schema
    /// extension has started replicating to all domain controllers, the task can no longer be
    /// canceled. A schema extension can be canceled during any of the following states;
    /// <code>Initializing</code>, <code>CreatingSnapshot</code>, and
    /// <code>UpdatingSchema</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CancelSchemaExtension<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_schema_extension_input::Builder,
    }
    impl<C, M, R> CancelSchemaExtension<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelSchemaExtension`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelSchemaExtensionOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelSchemaExtensionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelSchemaExtensionInputOperationOutputAlias,
                crate::output::CancelSchemaExtensionOutput,
                crate::error::CancelSchemaExtensionError,
                crate::input::CancelSchemaExtensionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory whose schema extension will be canceled.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The identifier of the directory whose schema extension will be canceled.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The identifier of the schema extension that will be canceled.</p>
        pub fn schema_extension_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_extension_id(inp);
            self
        }
        /// <p>The identifier of the schema extension that will be canceled.</p>
        pub fn set_schema_extension_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schema_extension_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ConnectDirectory`.
    ///
    /// <p>Creates an AD Connector to connect to a self-managed directory.</p>
    /// <p>Before you call <code>ConnectDirectory</code>, ensure that all of the required permissions
    /// have been explicitly granted through a policy. For details about what permissions are required
    /// to run the <code>ConnectDirectory</code> operation, see <a href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html">Directory Service API Permissions: Actions, Resources, and Conditions
    /// Reference</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ConnectDirectory<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::connect_directory_input::Builder,
    }
    impl<C, M, R> ConnectDirectory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ConnectDirectory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ConnectDirectoryOutput,
            aws_smithy_http::result::SdkError<crate::error::ConnectDirectoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ConnectDirectoryInputOperationOutputAlias,
                crate::output::ConnectDirectoryOutput,
                crate::error::ConnectDirectoryError,
                crate::input::ConnectDirectoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The fully qualified name of your self-managed directory, such as
        /// <code>corp.example.com</code>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The fully qualified name of your self-managed directory, such as
        /// <code>corp.example.com</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The NetBIOS name of your self-managed directory, such as <code>CORP</code>.</p>
        pub fn short_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.short_name(inp);
            self
        }
        /// <p>The NetBIOS name of your self-managed directory, such as <code>CORP</code>.</p>
        pub fn set_short_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_short_name(input);
            self
        }
        /// <p>The password for your self-managed user account.</p>
        pub fn password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(inp);
            self
        }
        /// <p>The password for your self-managed user account.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
        /// <p>A description for the directory.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description for the directory.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The size of the directory.</p>
        pub fn size(mut self, inp: crate::model::DirectorySize) -> Self {
            self.inner = self.inner.size(inp);
            self
        }
        /// <p>The size of the directory.</p>
        pub fn set_size(mut self, input: std::option::Option<crate::model::DirectorySize>) -> Self {
            self.inner = self.inner.set_size(input);
            self
        }
        /// <p>A <a>DirectoryConnectSettings</a> object that contains additional information
        /// for the operation.</p>
        pub fn connect_settings(mut self, inp: crate::model::DirectoryConnectSettings) -> Self {
            self.inner = self.inner.connect_settings(inp);
            self
        }
        /// <p>A <a>DirectoryConnectSettings</a> object that contains additional information
        /// for the operation.</p>
        pub fn set_connect_settings(
            mut self,
            input: std::option::Option<crate::model::DirectoryConnectSettings>,
        ) -> Self {
            self.inner = self.inner.set_connect_settings(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to AD Connector.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be assigned to AD Connector.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAlias`.
    ///
    /// <p>Creates an alias for a directory and assigns the alias to the directory. The alias is used
    /// to construct the access URL for the directory, such as
    /// <code>http://<alias>.awsapps.com</code>.</p>
    /// <important>
    /// <p>After an alias has been created, it cannot be deleted or reused, so this operation should only be used when absolutely necessary.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct CreateAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_alias_input::Builder,
    }
    impl<C, M, R> CreateAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAliasInputOperationOutputAlias,
                crate::output::CreateAliasOutput,
                crate::error::CreateAliasError,
                crate::input::CreateAliasInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory for which to create the alias.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The identifier of the directory for which to create the alias.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The requested alias.</p>
        /// <p>The alias must be unique amongst all aliases in Amazon Web Services. This operation throws an
        /// <code>EntityAlreadyExistsException</code> error if the alias already exists.</p>
        pub fn alias(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias(inp);
            self
        }
        /// <p>The requested alias.</p>
        /// <p>The alias must be unique amongst all aliases in Amazon Web Services. This operation throws an
        /// <code>EntityAlreadyExistsException</code> error if the alias already exists.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateComputer`.
    ///
    /// <p>Creates an Active Directory computer object in the specified directory.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateComputer<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_computer_input::Builder,
    }
    impl<C, M, R> CreateComputer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateComputer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateComputerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateComputerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateComputerInputOperationOutputAlias,
                crate::output::CreateComputerOutput,
                crate::error::CreateComputerError,
                crate::input::CreateComputerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory in which to create the computer account.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The identifier of the directory in which to create the computer account.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The name of the computer account.</p>
        pub fn computer_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.computer_name(inp);
            self
        }
        /// <p>The name of the computer account.</p>
        pub fn set_computer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_computer_name(input);
            self
        }
        /// <p>A one-time password that is used to join the computer to the directory. You should generate a random, strong password to use for this parameter.</p>
        pub fn password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(inp);
            self
        }
        /// <p>A one-time password that is used to join the computer to the directory. You should generate a random, strong password to use for this parameter.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
        /// <p>The fully-qualified distinguished name of the organizational unit to place the computer account in.</p>
        pub fn organizational_unit_distinguished_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.organizational_unit_distinguished_name(inp);
            self
        }
        /// <p>The fully-qualified distinguished name of the organizational unit to place the computer account in.</p>
        pub fn set_organizational_unit_distinguished_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organizational_unit_distinguished_name(input);
            self
        }
        /// Appends an item to `ComputerAttributes`.
        ///
        /// To override the contents of this collection use [`set_computer_attributes`](Self::set_computer_attributes).
        ///
        /// <p>An array of <a>Attribute</a> objects that contain any LDAP attributes to apply to the
        /// computer account.</p>
        pub fn computer_attributes(mut self, inp: impl Into<crate::model::Attribute>) -> Self {
            self.inner = self.inner.computer_attributes(inp);
            self
        }
        /// <p>An array of <a>Attribute</a> objects that contain any LDAP attributes to apply to the
        /// computer account.</p>
        pub fn set_computer_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.inner = self.inner.set_computer_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConditionalForwarder`.
    ///
    /// <p>Creates a conditional forwarder associated with your Amazon Web Services directory. Conditional
    /// forwarders are required in order to set up a trust relationship with another domain. The
    /// conditional forwarder points to the trusted domain.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateConditionalForwarder<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_conditional_forwarder_input::Builder,
    }
    impl<C, M, R> CreateConditionalForwarder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateConditionalForwarder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConditionalForwarderOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConditionalForwarderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateConditionalForwarderInputOperationOutputAlias,
                crate::output::CreateConditionalForwarderOutput,
                crate::error::CreateConditionalForwarderError,
                crate::input::CreateConditionalForwarderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The directory ID of the Amazon Web Services directory for which you are creating the conditional
        /// forwarder.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The directory ID of the Amazon Web Services directory for which you are creating the conditional
        /// forwarder.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The fully qualified domain name (FQDN) of the remote domain with which you will set up
        /// a trust relationship.</p>
        pub fn remote_domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.remote_domain_name(inp);
            self
        }
        /// <p>The fully qualified domain name (FQDN) of the remote domain with which you will set up
        /// a trust relationship.</p>
        pub fn set_remote_domain_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_remote_domain_name(input);
            self
        }
        /// Appends an item to `DnsIpAddrs`.
        ///
        /// To override the contents of this collection use [`set_dns_ip_addrs`](Self::set_dns_ip_addrs).
        ///
        /// <p>The IP addresses of the remote DNS server associated with RemoteDomainName.</p>
        pub fn dns_ip_addrs(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dns_ip_addrs(inp);
            self
        }
        /// <p>The IP addresses of the remote DNS server associated with RemoteDomainName.</p>
        pub fn set_dns_ip_addrs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_dns_ip_addrs(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDirectory`.
    ///
    /// <p>Creates a Simple AD directory. For more information, see <a href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_simple_ad.html">Simple Active Directory</a> in the <i>Directory Service Admin
    /// Guide</i>.</p>
    /// <p>Before you call <code>CreateDirectory</code>, ensure that all of the required permissions
    /// have been explicitly granted through a policy. For details about what permissions are required
    /// to run the <code>CreateDirectory</code> operation, see <a href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html">Directory Service API Permissions: Actions, Resources, and Conditions
    /// Reference</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDirectory<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_directory_input::Builder,
    }
    impl<C, M, R> CreateDirectory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDirectory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDirectoryOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDirectoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDirectoryInputOperationOutputAlias,
                crate::output::CreateDirectoryOutput,
                crate::error::CreateDirectoryError,
                crate::input::CreateDirectoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The fully qualified name for the directory, such as <code>corp.example.com</code>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The fully qualified name for the directory, such as <code>corp.example.com</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The NetBIOS name of the directory, such as <code>CORP</code>.</p>
        pub fn short_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.short_name(inp);
            self
        }
        /// <p>The NetBIOS name of the directory, such as <code>CORP</code>.</p>
        pub fn set_short_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_short_name(input);
            self
        }
        /// <p>The password for the directory administrator. The directory creation process creates a
        /// directory administrator account with the user name <code>Administrator</code> and this
        /// password.</p>
        /// <p>If you need to change the password for the administrator account, you can use the <a>ResetUserPassword</a> API call.</p>
        /// <p>The regex pattern for this string is made up of the following conditions:</p>
        /// <ul>
        /// <li>
        /// <p>Length (?=^.{8,64}$) – Must be between 8 and 64 characters</p>
        /// </li>
        /// </ul>
        /// <p>AND any 3 of the following password complexity rules required by Active Directory:</p>
        /// <ul>
        /// <li>
        /// <p>Numbers and upper case and lowercase (?=.*\d)(?=.*[A-Z])(?=.*[a-z])</p>
        /// </li>
        /// <li>
        /// <p>Numbers and special characters and lower case
        /// (?=.*\d)(?=.*[^A-Za-z0-9\s])(?=.*[a-z])</p>
        /// </li>
        /// <li>
        /// <p>Special characters and upper case and lower case
        /// (?=.*[^A-Za-z0-9\s])(?=.*[A-Z])(?=.*[a-z])</p>
        /// </li>
        /// <li>
        /// <p>Numbers and upper case and special characters
        /// (?=.*\d)(?=.*[A-Z])(?=.*[^A-Za-z0-9\s])</p>
        /// </li>
        /// </ul>
        /// <p>For additional information about how Active Directory passwords are enforced, see <a href="https://docs.microsoft.com/en-us/windows/security/threat-protection/security-policy-settings/password-must-meet-complexity-requirements">Password must meet complexity requirements</a> on the Microsoft website.</p>
        pub fn password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(inp);
            self
        }
        /// <p>The password for the directory administrator. The directory creation process creates a
        /// directory administrator account with the user name <code>Administrator</code> and this
        /// password.</p>
        /// <p>If you need to change the password for the administrator account, you can use the <a>ResetUserPassword</a> API call.</p>
        /// <p>The regex pattern for this string is made up of the following conditions:</p>
        /// <ul>
        /// <li>
        /// <p>Length (?=^.{8,64}$) – Must be between 8 and 64 characters</p>
        /// </li>
        /// </ul>
        /// <p>AND any 3 of the following password complexity rules required by Active Directory:</p>
        /// <ul>
        /// <li>
        /// <p>Numbers and upper case and lowercase (?=.*\d)(?=.*[A-Z])(?=.*[a-z])</p>
        /// </li>
        /// <li>
        /// <p>Numbers and special characters and lower case
        /// (?=.*\d)(?=.*[^A-Za-z0-9\s])(?=.*[a-z])</p>
        /// </li>
        /// <li>
        /// <p>Special characters and upper case and lower case
        /// (?=.*[^A-Za-z0-9\s])(?=.*[A-Z])(?=.*[a-z])</p>
        /// </li>
        /// <li>
        /// <p>Numbers and upper case and special characters
        /// (?=.*\d)(?=.*[A-Z])(?=.*[^A-Za-z0-9\s])</p>
        /// </li>
        /// </ul>
        /// <p>For additional information about how Active Directory passwords are enforced, see <a href="https://docs.microsoft.com/en-us/windows/security/threat-protection/security-policy-settings/password-must-meet-complexity-requirements">Password must meet complexity requirements</a> on the Microsoft website.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
        /// <p>A description for the directory.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description for the directory.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The size of the directory.</p>
        pub fn size(mut self, inp: crate::model::DirectorySize) -> Self {
            self.inner = self.inner.size(inp);
            self
        }
        /// <p>The size of the directory.</p>
        pub fn set_size(mut self, input: std::option::Option<crate::model::DirectorySize>) -> Self {
            self.inner = self.inner.set_size(input);
            self
        }
        /// <p>A <a>DirectoryVpcSettings</a> object that contains additional information for
        /// the operation.</p>
        pub fn vpc_settings(mut self, inp: crate::model::DirectoryVpcSettings) -> Self {
            self.inner = self.inner.vpc_settings(inp);
            self
        }
        /// <p>A <a>DirectoryVpcSettings</a> object that contains additional information for
        /// the operation.</p>
        pub fn set_vpc_settings(
            mut self,
            input: std::option::Option<crate::model::DirectoryVpcSettings>,
        ) -> Self {
            self.inner = self.inner.set_vpc_settings(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the Simple AD directory.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be assigned to the Simple AD directory.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLogSubscription`.
    ///
    /// <p>Creates a subscription to forward real-time Directory Service domain controller security
    /// logs to the specified Amazon CloudWatch log group in your Amazon Web Services account.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateLogSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_log_subscription_input::Builder,
    }
    impl<C, M, R> CreateLogSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLogSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLogSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLogSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLogSubscriptionInputOperationOutputAlias,
                crate::output::CreateLogSubscriptionOutput,
                crate::error::CreateLogSubscriptionError,
                crate::input::CreateLogSubscriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier of the directory to which you want to subscribe and receive real-time logs to
        /// your specified CloudWatch log group.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>Identifier of the directory to which you want to subscribe and receive real-time logs to
        /// your specified CloudWatch log group.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The name of the CloudWatch log group where the real-time domain controller logs are
        /// forwarded.</p>
        pub fn log_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_group_name(inp);
            self
        }
        /// <p>The name of the CloudWatch log group where the real-time domain controller logs are
        /// forwarded.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMicrosoftAD`.
    ///
    /// <p>Creates a Microsoft AD directory in the Amazon Web Services Cloud. For more information, see <a href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_microsoft_ad.html">Managed Microsoft AD</a> in the <i>Directory Service Admin Guide</i>.</p>
    /// <p>Before you call <i>CreateMicrosoftAD</i>, ensure that all of the required
    /// permissions have been explicitly granted through a policy. For details about what permissions
    /// are required to run the <i>CreateMicrosoftAD</i> operation, see <a href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html">Directory Service API Permissions: Actions, Resources, and Conditions Reference</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateMicrosoftAD<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_microsoft_ad_input::Builder,
    }
    impl<C, M, R> CreateMicrosoftAD<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMicrosoftAD`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMicrosoftAdOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMicrosoftADError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMicrosoftAdInputOperationOutputAlias,
                crate::output::CreateMicrosoftAdOutput,
                crate::error::CreateMicrosoftADError,
                crate::input::CreateMicrosoftAdInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The fully qualified domain name for the Managed Microsoft AD directory, such as
        /// <code>corp.example.com</code>. This name will resolve inside your VPC only. It does not need
        /// to be publicly resolvable.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The fully qualified domain name for the Managed Microsoft AD directory, such as
        /// <code>corp.example.com</code>. This name will resolve inside your VPC only. It does not need
        /// to be publicly resolvable.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The NetBIOS name for your domain, such as <code>CORP</code>. If you don't specify a
        /// NetBIOS name, it will default to the first part of your directory DNS. For example,
        /// <code>CORP</code> for the directory DNS <code>corp.example.com</code>. </p>
        pub fn short_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.short_name(inp);
            self
        }
        /// <p>The NetBIOS name for your domain, such as <code>CORP</code>. If you don't specify a
        /// NetBIOS name, it will default to the first part of your directory DNS. For example,
        /// <code>CORP</code> for the directory DNS <code>corp.example.com</code>. </p>
        pub fn set_short_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_short_name(input);
            self
        }
        /// <p>The password for the default administrative user named <code>Admin</code>.</p>
        /// <p>If you need to change the password for the administrator account, you can use the <a>ResetUserPassword</a> API call.</p>
        pub fn password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(inp);
            self
        }
        /// <p>The password for the default administrative user named <code>Admin</code>.</p>
        /// <p>If you need to change the password for the administrator account, you can use the <a>ResetUserPassword</a> API call.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
        /// <p>A description for the directory. This label will appear on the Amazon Web Services console
        /// <code>Directory Details</code> page after the directory is created.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description for the directory. This label will appear on the Amazon Web Services console
        /// <code>Directory Details</code> page after the directory is created.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Contains VPC information for the <a>CreateDirectory</a> or <a>CreateMicrosoftAD</a> operation.</p>
        pub fn vpc_settings(mut self, inp: crate::model::DirectoryVpcSettings) -> Self {
            self.inner = self.inner.vpc_settings(inp);
            self
        }
        /// <p>Contains VPC information for the <a>CreateDirectory</a> or <a>CreateMicrosoftAD</a> operation.</p>
        pub fn set_vpc_settings(
            mut self,
            input: std::option::Option<crate::model::DirectoryVpcSettings>,
        ) -> Self {
            self.inner = self.inner.set_vpc_settings(input);
            self
        }
        /// <p>Managed Microsoft AD is available in two editions: <code>Standard</code> and
        /// <code>Enterprise</code>. <code>Enterprise</code> is the default.</p>
        pub fn edition(mut self, inp: crate::model::DirectoryEdition) -> Self {
            self.inner = self.inner.edition(inp);
            self
        }
        /// <p>Managed Microsoft AD is available in two editions: <code>Standard</code> and
        /// <code>Enterprise</code>. <code>Enterprise</code> is the default.</p>
        pub fn set_edition(
            mut self,
            input: std::option::Option<crate::model::DirectoryEdition>,
        ) -> Self {
            self.inner = self.inner.set_edition(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the Managed Microsoft AD directory.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be assigned to the Managed Microsoft AD directory.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSnapshot`.
    ///
    /// <p>Creates a snapshot of a Simple AD or Microsoft AD directory in the Amazon Web Services cloud.</p>
    /// <note>
    /// <p>You cannot take snapshots of AD Connector directories.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_snapshot_input::Builder,
    }
    impl<C, M, R> CreateSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSnapshotInputOperationOutputAlias,
                crate::output::CreateSnapshotOutput,
                crate::error::CreateSnapshotError,
                crate::input::CreateSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory of which to take a snapshot.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The identifier of the directory of which to take a snapshot.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The descriptive name to apply to the snapshot.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The descriptive name to apply to the snapshot.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTrust`.
    ///
    /// <p>Directory Service for Microsoft Active Directory allows you to configure trust relationships. For
    /// example, you can establish a trust between your Managed Microsoft AD directory, and your existing
    /// self-managed Microsoft Active Directory. This would allow you to provide users and groups
    /// access to resources in either domain, with a single set of credentials.</p>
    /// <p>This action initiates the creation of the Amazon Web Services side of a trust relationship between an
    /// Managed Microsoft AD directory and an external domain. You can create either a forest trust or an
    /// external trust.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateTrust<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_trust_input::Builder,
    }
    impl<C, M, R> CreateTrust<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTrust`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTrustOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTrustError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTrustInputOperationOutputAlias,
                crate::output::CreateTrustOutput,
                crate::error::CreateTrustError,
                crate::input::CreateTrustInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Directory ID of the Managed Microsoft AD directory for which to establish the trust
        /// relationship.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The Directory ID of the Managed Microsoft AD directory for which to establish the trust
        /// relationship.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The Fully Qualified Domain Name (FQDN) of the external domain for which to create the
        /// trust relationship.</p>
        pub fn remote_domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.remote_domain_name(inp);
            self
        }
        /// <p>The Fully Qualified Domain Name (FQDN) of the external domain for which to create the
        /// trust relationship.</p>
        pub fn set_remote_domain_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_remote_domain_name(input);
            self
        }
        /// <p>The trust password. The must be the same password that was used when creating the trust
        /// relationship on the external domain.</p>
        pub fn trust_password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trust_password(inp);
            self
        }
        /// <p>The trust password. The must be the same password that was used when creating the trust
        /// relationship on the external domain.</p>
        pub fn set_trust_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_trust_password(input);
            self
        }
        /// <p>The direction of the trust relationship.</p>
        pub fn trust_direction(mut self, inp: crate::model::TrustDirection) -> Self {
            self.inner = self.inner.trust_direction(inp);
            self
        }
        /// <p>The direction of the trust relationship.</p>
        pub fn set_trust_direction(
            mut self,
            input: std::option::Option<crate::model::TrustDirection>,
        ) -> Self {
            self.inner = self.inner.set_trust_direction(input);
            self
        }
        /// <p>The trust relationship type. <code>Forest</code> is the default.</p>
        pub fn trust_type(mut self, inp: crate::model::TrustType) -> Self {
            self.inner = self.inner.trust_type(inp);
            self
        }
        /// <p>The trust relationship type. <code>Forest</code> is the default.</p>
        pub fn set_trust_type(
            mut self,
            input: std::option::Option<crate::model::TrustType>,
        ) -> Self {
            self.inner = self.inner.set_trust_type(input);
            self
        }
        /// Appends an item to `ConditionalForwarderIpAddrs`.
        ///
        /// To override the contents of this collection use [`set_conditional_forwarder_ip_addrs`](Self::set_conditional_forwarder_ip_addrs).
        ///
        /// <p>The IP addresses of the remote DNS server associated with RemoteDomainName.</p>
        pub fn conditional_forwarder_ip_addrs(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.conditional_forwarder_ip_addrs(inp);
            self
        }
        /// <p>The IP addresses of the remote DNS server associated with RemoteDomainName.</p>
        pub fn set_conditional_forwarder_ip_addrs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_conditional_forwarder_ip_addrs(input);
            self
        }
        /// <p>Optional parameter to enable selective authentication for the trust.</p>
        pub fn selective_auth(mut self, inp: crate::model::SelectiveAuth) -> Self {
            self.inner = self.inner.selective_auth(inp);
            self
        }
        /// <p>Optional parameter to enable selective authentication for the trust.</p>
        pub fn set_selective_auth(
            mut self,
            input: std::option::Option<crate::model::SelectiveAuth>,
        ) -> Self {
            self.inner = self.inner.set_selective_auth(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConditionalForwarder`.
    ///
    /// <p>Deletes a conditional forwarder that has been set up for your Amazon Web Services
    /// directory.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteConditionalForwarder<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_conditional_forwarder_input::Builder,
    }
    impl<C, M, R> DeleteConditionalForwarder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteConditionalForwarder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConditionalForwarderOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConditionalForwarderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteConditionalForwarderInputOperationOutputAlias,
                crate::output::DeleteConditionalForwarderOutput,
                crate::error::DeleteConditionalForwarderError,
                crate::input::DeleteConditionalForwarderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The directory ID for which you are deleting the conditional forwarder.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The directory ID for which you are deleting the conditional forwarder.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The fully qualified domain name (FQDN) of the remote domain with which you are deleting
        /// the conditional forwarder.</p>
        pub fn remote_domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.remote_domain_name(inp);
            self
        }
        /// <p>The fully qualified domain name (FQDN) of the remote domain with which you are deleting
        /// the conditional forwarder.</p>
        pub fn set_remote_domain_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_remote_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDirectory`.
    ///
    /// <p>Deletes an Directory Service directory.</p>
    /// <p>Before you call <code>DeleteDirectory</code>, ensure that all of the required permissions
    /// have been explicitly granted through a policy. For details about what permissions are required
    /// to run the <code>DeleteDirectory</code> operation, see <a href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html">Directory Service API Permissions: Actions, Resources, and Conditions
    /// Reference</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDirectory<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_directory_input::Builder,
    }
    impl<C, M, R> DeleteDirectory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDirectory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDirectoryOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDirectoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDirectoryInputOperationOutputAlias,
                crate::output::DeleteDirectoryOutput,
                crate::error::DeleteDirectoryError,
                crate::input::DeleteDirectoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory to delete.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The identifier of the directory to delete.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLogSubscription`.
    ///
    /// <p>Deletes the specified log subscription.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteLogSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_log_subscription_input::Builder,
    }
    impl<C, M, R> DeleteLogSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLogSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLogSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLogSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLogSubscriptionInputOperationOutputAlias,
                crate::output::DeleteLogSubscriptionOutput,
                crate::error::DeleteLogSubscriptionError,
                crate::input::DeleteLogSubscriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier of the directory whose log subscription you want to delete.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>Identifier of the directory whose log subscription you want to delete.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSnapshot`.
    ///
    /// <p>Deletes a directory snapshot.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_snapshot_input::Builder,
    }
    impl<C, M, R> DeleteSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSnapshotInputOperationOutputAlias,
                crate::output::DeleteSnapshotOutput,
                crate::error::DeleteSnapshotError,
                crate::input::DeleteSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory snapshot to be deleted.</p>
        pub fn snapshot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_id(inp);
            self
        }
        /// <p>The identifier of the directory snapshot to be deleted.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_snapshot_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTrust`.
    ///
    /// <p>Deletes an existing trust relationship between your Managed Microsoft AD directory and an external
    /// domain.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteTrust<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_trust_input::Builder,
    }
    impl<C, M, R> DeleteTrust<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTrust`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTrustOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTrustError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTrustInputOperationOutputAlias,
                crate::output::DeleteTrustOutput,
                crate::error::DeleteTrustError,
                crate::input::DeleteTrustInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Trust ID of the trust relationship to be deleted.</p>
        pub fn trust_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trust_id(inp);
            self
        }
        /// <p>The Trust ID of the trust relationship to be deleted.</p>
        pub fn set_trust_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_trust_id(input);
            self
        }
        /// <p>Delete a conditional forwarder as part of a DeleteTrustRequest.</p>
        pub fn delete_associated_conditional_forwarder(mut self, inp: bool) -> Self {
            self.inner = self.inner.delete_associated_conditional_forwarder(inp);
            self
        }
        /// <p>Delete a conditional forwarder as part of a DeleteTrustRequest.</p>
        pub fn set_delete_associated_conditional_forwarder(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self
                .inner
                .set_delete_associated_conditional_forwarder(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterCertificate`.
    ///
    /// <p>Deletes from the system the certificate that was registered for secure LDAP or client certificate authentication.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeregisterCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deregister_certificate_input::Builder,
    }
    impl<C, M, R> DeregisterCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeregisterCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeregisterCertificateInputOperationOutputAlias,
                crate::output::DeregisterCertificateOutput,
                crate::error::DeregisterCertificateError,
                crate::input::DeregisterCertificateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The identifier of the certificate.</p>
        pub fn certificate_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_id(inp);
            self
        }
        /// <p>The identifier of the certificate.</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterEventTopic`.
    ///
    /// <p>Removes the specified directory as a publisher to the specified Amazon SNS topic.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeregisterEventTopic<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deregister_event_topic_input::Builder,
    }
    impl<C, M, R> DeregisterEventTopic<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeregisterEventTopic`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterEventTopicOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterEventTopicError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeregisterEventTopicInputOperationOutputAlias,
                crate::output::DeregisterEventTopicOutput,
                crate::error::DeregisterEventTopicError,
                crate::input::DeregisterEventTopicInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Directory ID to remove as a publisher. This directory will no longer send messages
        /// to the specified Amazon SNS topic.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The Directory ID to remove as a publisher. This directory will no longer send messages
        /// to the specified Amazon SNS topic.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The name of the Amazon SNS topic from which to remove the directory as a
        /// publisher.</p>
        pub fn topic_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.topic_name(inp);
            self
        }
        /// <p>The name of the Amazon SNS topic from which to remove the directory as a
        /// publisher.</p>
        pub fn set_topic_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_topic_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCertificate`.
    ///
    /// <p>Displays information about the certificate registered for secure LDAP or client certificate authentication.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_certificate_input::Builder,
    }
    impl<C, M, R> DescribeCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCertificateInputOperationOutputAlias,
                crate::output::DescribeCertificateOutput,
                crate::error::DescribeCertificateError,
                crate::input::DescribeCertificateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The identifier of the certificate.</p>
        pub fn certificate_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_id(inp);
            self
        }
        /// <p>The identifier of the certificate.</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeClientAuthenticationSettings`.
    ///
    /// <p>Retrieves information about the type of client authentication for the specified directory, if the type is specified. If no type is specified, information about all client authentication types that are supported for the specified directory is retrieved. Currently, only <code>SmartCard</code> is supported.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeClientAuthenticationSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_client_authentication_settings_input::Builder,
    }
    impl<C, M, R> DescribeClientAuthenticationSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeClientAuthenticationSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClientAuthenticationSettingsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeClientAuthenticationSettingsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeClientAuthenticationSettingsInputOperationOutputAlias,
                crate::output::DescribeClientAuthenticationSettingsOutput,
                crate::error::DescribeClientAuthenticationSettingsError,
                crate::input::DescribeClientAuthenticationSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory for which to retrieve information.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The identifier of the directory for which to retrieve information.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The type of client authentication for which to retrieve information. If no type is specified, a list of all client authentication types that are supported for the specified directory is retrieved.</p>
        pub fn r#type(mut self, inp: crate::model::ClientAuthenticationType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of client authentication for which to retrieve information. If no type is specified, a list of all client authentication types that are supported for the specified directory is retrieved.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ClientAuthenticationType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The <i>DescribeClientAuthenticationSettingsResult.NextToken</i> value from a previous call to <a>DescribeClientAuthenticationSettings</a>. Pass null if this is the first call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <i>DescribeClientAuthenticationSettingsResult.NextToken</i> value from a previous call to <a>DescribeClientAuthenticationSettings</a>. Pass null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return. If this value is zero, the maximum number of items is specified by the limitations of the operation. </p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of items to return. If this value is zero, the maximum number of items is specified by the limitations of the operation. </p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConditionalForwarders`.
    ///
    /// <p>Obtains information about the conditional forwarders for this account.</p>
    /// <p>If no input parameters are provided for RemoteDomainNames, this request describes all
    /// conditional forwarders for the specified directory ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeConditionalForwarders<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_conditional_forwarders_input::Builder,
    }
    impl<C, M, R> DescribeConditionalForwarders<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeConditionalForwarders`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConditionalForwardersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConditionalForwardersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeConditionalForwardersInputOperationOutputAlias,
                crate::output::DescribeConditionalForwardersOutput,
                crate::error::DescribeConditionalForwardersError,
                crate::input::DescribeConditionalForwardersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The directory ID for which to get the list of associated conditional
        /// forwarders.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The directory ID for which to get the list of associated conditional
        /// forwarders.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// Appends an item to `RemoteDomainNames`.
        ///
        /// To override the contents of this collection use [`set_remote_domain_names`](Self::set_remote_domain_names).
        ///
        /// <p>The fully qualified domain names (FQDN) of the remote domains for which to get the list
        /// of associated conditional forwarders. If this member is null, all conditional forwarders are
        /// returned.</p>
        pub fn remote_domain_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.remote_domain_names(inp);
            self
        }
        /// <p>The fully qualified domain names (FQDN) of the remote domains for which to get the list
        /// of associated conditional forwarders. If this member is null, all conditional forwarders are
        /// returned.</p>
        pub fn set_remote_domain_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_remote_domain_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDirectories`.
    ///
    /// <p>Obtains information about the directories that belong to this account.</p>
    /// <p>You can retrieve information about specific directories by passing the directory
    /// identifiers in the <code>DirectoryIds</code> parameter. Otherwise, all directories that belong
    /// to the current account are returned.</p>
    /// <p>This operation supports pagination with the use of the <code>NextToken</code> request and
    /// response parameters. If more results are available, the
    /// <code>DescribeDirectoriesResult.NextToken</code> member contains a token that you pass in
    /// the next call to <a>DescribeDirectories</a> to retrieve the next set of
    /// items.</p>
    /// <p>You can also specify a maximum number of return results with the <code>Limit</code>
    /// parameter.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDirectories<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_directories_input::Builder,
    }
    impl<C, M, R> DescribeDirectories<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDirectories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDirectoriesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDirectoriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDirectoriesInputOperationOutputAlias,
                crate::output::DescribeDirectoriesOutput,
                crate::error::DescribeDirectoriesError,
                crate::input::DescribeDirectoriesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `DirectoryIds`.
        ///
        /// To override the contents of this collection use [`set_directory_ids`](Self::set_directory_ids).
        ///
        /// <p>A list of identifiers of the directories for which to obtain the information. If this
        /// member is null, all directories that belong to the current account are returned.</p>
        /// <p>An empty list results in an <code>InvalidParameterException</code> being thrown.</p>
        pub fn directory_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_ids(inp);
            self
        }
        /// <p>A list of identifiers of the directories for which to obtain the information. If this
        /// member is null, all directories that belong to the current account are returned.</p>
        /// <p>An empty list results in an <code>InvalidParameterException</code> being thrown.</p>
        pub fn set_directory_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_directory_ids(input);
            self
        }
        /// <p>The <code>DescribeDirectoriesResult.NextToken</code> value from a previous call to <a>DescribeDirectories</a>. Pass null if this is the first call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>DescribeDirectoriesResult.NextToken</code> value from a previous call to <a>DescribeDirectories</a>. Pass null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return. If this value is zero, the maximum number of items
        /// is specified by the limitations of the operation.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of items to return. If this value is zero, the maximum number of items
        /// is specified by the limitations of the operation.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDomainControllers`.
    ///
    /// <p>Provides information about any domain controllers in your directory.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDomainControllers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_domain_controllers_input::Builder,
    }
    impl<C, M, R> DescribeDomainControllers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDomainControllers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDomainControllersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDomainControllersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDomainControllersInputOperationOutputAlias,
                crate::output::DescribeDomainControllersOutput,
                crate::error::DescribeDomainControllersError,
                crate::input::DescribeDomainControllersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier of the directory for which to retrieve the domain controller
        /// information.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>Identifier of the directory for which to retrieve the domain controller
        /// information.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// Appends an item to `DomainControllerIds`.
        ///
        /// To override the contents of this collection use [`set_domain_controller_ids`](Self::set_domain_controller_ids).
        ///
        /// <p>A list of identifiers for the domain controllers whose information will be
        /// provided.</p>
        pub fn domain_controller_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_controller_ids(inp);
            self
        }
        /// <p>A list of identifiers for the domain controllers whose information will be
        /// provided.</p>
        pub fn set_domain_controller_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_domain_controller_ids(input);
            self
        }
        /// <p>The <i>DescribeDomainControllers.NextToken</i> value from a previous call
        /// to <a>DescribeDomainControllers</a>. Pass null if this is the first call.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <i>DescribeDomainControllers.NextToken</i> value from a previous call
        /// to <a>DescribeDomainControllers</a>. Pass null if this is the first call.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventTopics`.
    ///
    /// <p>Obtains information about which Amazon SNS topics receive status messages from the specified
    /// directory.</p>
    /// <p>If no input parameters are provided, such as DirectoryId or TopicName, this request
    /// describes all of the associations in the account.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEventTopics<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_event_topics_input::Builder,
    }
    impl<C, M, R> DescribeEventTopics<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEventTopics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventTopicsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventTopicsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEventTopicsInputOperationOutputAlias,
                crate::output::DescribeEventTopicsOutput,
                crate::error::DescribeEventTopicsError,
                crate::input::DescribeEventTopicsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Directory ID for which to get the list of associated Amazon SNS topics. If this member
        /// is null, associations for all Directory IDs are returned.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The Directory ID for which to get the list of associated Amazon SNS topics. If this member
        /// is null, associations for all Directory IDs are returned.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// Appends an item to `TopicNames`.
        ///
        /// To override the contents of this collection use [`set_topic_names`](Self::set_topic_names).
        ///
        /// <p>A list of Amazon SNS topic names for which to obtain the information. If this member is
        /// null, all associations for the specified Directory ID are returned.</p>
        /// <p>An empty list results in an <code>InvalidParameterException</code> being
        /// thrown.</p>
        pub fn topic_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.topic_names(inp);
            self
        }
        /// <p>A list of Amazon SNS topic names for which to obtain the information. If this member is
        /// null, all associations for the specified Directory ID are returned.</p>
        /// <p>An empty list results in an <code>InvalidParameterException</code> being
        /// thrown.</p>
        pub fn set_topic_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_topic_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLDAPSSettings`.
    ///
    /// <p>Describes the status of LDAP security for the specified directory.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeLDAPSSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_ldaps_settings_input::Builder,
    }
    impl<C, M, R> DescribeLDAPSSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeLDAPSSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLdapsSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLDAPSSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeLdapsSettingsInputOperationOutputAlias,
                crate::output::DescribeLdapsSettingsOutput,
                crate::error::DescribeLDAPSSettingsError,
                crate::input::DescribeLdapsSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The type of LDAP security to enable. Currently only the value <code>Client</code> is
        /// supported.</p>
        pub fn r#type(mut self, inp: crate::model::LdapsType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of LDAP security to enable. Currently only the value <code>Client</code> is
        /// supported.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::LdapsType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The type of next token used for pagination.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The type of next token used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifies the number of items that should be displayed on one page.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>Specifies the number of items that should be displayed on one page.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRegions`.
    ///
    /// <p>Provides information about the Regions that are configured for multi-Region
    /// replication.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeRegions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_regions_input::Builder,
    }
    impl<C, M, R> DescribeRegions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRegions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRegionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRegionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRegionsInputOperationOutputAlias,
                crate::output::DescribeRegionsOutput,
                crate::error::DescribeRegionsError,
                crate::input::DescribeRegionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The name of the Region. For example, <code>us-east-1</code>.</p>
        pub fn region_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.region_name(inp);
            self
        }
        /// <p>The name of the Region. For example, <code>us-east-1</code>.</p>
        pub fn set_region_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_region_name(input);
            self
        }
        /// <p>The <code>DescribeRegionsResult.NextToken</code> value from a previous call to <a>DescribeRegions</a>. Pass null if this is the first call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>DescribeRegionsResult.NextToken</code> value from a previous call to <a>DescribeRegions</a>. Pass null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSharedDirectories`.
    ///
    /// <p>Returns the shared directories in your account. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSharedDirectories<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_shared_directories_input::Builder,
    }
    impl<C, M, R> DescribeSharedDirectories<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSharedDirectories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSharedDirectoriesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSharedDirectoriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSharedDirectoriesInputOperationOutputAlias,
                crate::output::DescribeSharedDirectoriesOutput,
                crate::error::DescribeSharedDirectoriesError,
                crate::input::DescribeSharedDirectoriesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Returns the identifier of the directory in the directory owner account. </p>
        pub fn owner_directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner_directory_id(inp);
            self
        }
        /// <p>Returns the identifier of the directory in the directory owner account. </p>
        pub fn set_owner_directory_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_owner_directory_id(input);
            self
        }
        /// Appends an item to `SharedDirectoryIds`.
        ///
        /// To override the contents of this collection use [`set_shared_directory_ids`](Self::set_shared_directory_ids).
        ///
        /// <p>A list of identifiers of all shared directories in your account. </p>
        pub fn shared_directory_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.shared_directory_ids(inp);
            self
        }
        /// <p>A list of identifiers of all shared directories in your account. </p>
        pub fn set_shared_directory_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_shared_directory_ids(input);
            self
        }
        /// <p>The <code>DescribeSharedDirectoriesResult.NextToken</code> value from a previous call to
        /// <a>DescribeSharedDirectories</a>. Pass null if this is the first call. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>DescribeSharedDirectoriesResult.NextToken</code> value from a previous call to
        /// <a>DescribeSharedDirectories</a>. Pass null if this is the first call. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of shared directories to return in the response object.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The number of shared directories to return in the response object.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSnapshots`.
    ///
    /// <p>Obtains information about the directory snapshots that belong to this account.</p>
    /// <p>This operation supports pagination with the use of the <i>NextToken</i> request and
    /// response parameters. If more results are available, the <i>DescribeSnapshots.NextToken</i>
    /// member contains a token that you pass in the next call to <a>DescribeSnapshots</a> to
    /// retrieve the next set of items.</p>
    /// <p>You can also specify a maximum number of return results with the <i>Limit</i>
    /// parameter.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSnapshots<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_snapshots_input::Builder,
    }
    impl<C, M, R> DescribeSnapshots<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSnapshots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSnapshotsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSnapshotsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSnapshotsInputOperationOutputAlias,
                crate::output::DescribeSnapshotsOutput,
                crate::error::DescribeSnapshotsError,
                crate::input::DescribeSnapshotsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory for which to retrieve snapshot information.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The identifier of the directory for which to retrieve snapshot information.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// Appends an item to `SnapshotIds`.
        ///
        /// To override the contents of this collection use [`set_snapshot_ids`](Self::set_snapshot_ids).
        ///
        /// <p>A list of identifiers of the snapshots to obtain the information for. If this member is
        /// null or empty, all snapshots are returned using the <i>Limit</i> and <i>NextToken</i>
        /// members.</p>
        pub fn snapshot_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_ids(inp);
            self
        }
        /// <p>A list of identifiers of the snapshots to obtain the information for. If this member is
        /// null or empty, all snapshots are returned using the <i>Limit</i> and <i>NextToken</i>
        /// members.</p>
        pub fn set_snapshot_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_ids(input);
            self
        }
        /// <p>The <i>DescribeSnapshotsResult.NextToken</i> value from a previous call to
        /// <a>DescribeSnapshots</a>. Pass null if this is the first call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <i>DescribeSnapshotsResult.NextToken</i> value from a previous call to
        /// <a>DescribeSnapshots</a>. Pass null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects to return.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of objects to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTrusts`.
    ///
    /// <p>Obtains information about the trust relationships for this account.</p>
    /// <p>If no input parameters are provided, such as DirectoryId or TrustIds, this request
    /// describes all the trust relationships belonging to the account.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeTrusts<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_trusts_input::Builder,
    }
    impl<C, M, R> DescribeTrusts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTrusts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTrustsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTrustsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTrustsInputOperationOutputAlias,
                crate::output::DescribeTrustsOutput,
                crate::error::DescribeTrustsError,
                crate::input::DescribeTrustsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Directory ID of the Amazon Web Services directory that is a part of the requested trust
        /// relationship.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The Directory ID of the Amazon Web Services directory that is a part of the requested trust
        /// relationship.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// Appends an item to `TrustIds`.
        ///
        /// To override the contents of this collection use [`set_trust_ids`](Self::set_trust_ids).
        ///
        /// <p>A list of identifiers of the trust relationships for which to obtain the information. If
        /// this member is null, all trust relationships that belong to the current account are
        /// returned.</p>
        /// <p>An empty list results in an <code>InvalidParameterException</code> being thrown.</p>
        pub fn trust_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trust_ids(inp);
            self
        }
        /// <p>A list of identifiers of the trust relationships for which to obtain the information. If
        /// this member is null, all trust relationships that belong to the current account are
        /// returned.</p>
        /// <p>An empty list results in an <code>InvalidParameterException</code> being thrown.</p>
        pub fn set_trust_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_trust_ids(input);
            self
        }
        /// <p>The <i>DescribeTrustsResult.NextToken</i> value from a previous call to
        /// <a>DescribeTrusts</a>. Pass null if this is the first call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <i>DescribeTrustsResult.NextToken</i> value from a previous call to
        /// <a>DescribeTrusts</a>. Pass null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects to return.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of objects to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableClientAuthentication`.
    ///
    /// <p>Disables alternative client authentication methods for the specified directory. </p>
    #[derive(std::fmt::Debug)]
    pub struct DisableClientAuthentication<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_client_authentication_input::Builder,
    }
    impl<C, M, R> DisableClientAuthentication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableClientAuthentication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableClientAuthenticationOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableClientAuthenticationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableClientAuthenticationInputOperationOutputAlias,
                crate::output::DisableClientAuthenticationOutput,
                crate::error::DisableClientAuthenticationError,
                crate::input::DisableClientAuthenticationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory </p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The identifier of the directory </p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The type of client authentication to disable. Currently, only the parameter, <code>SmartCard</code> is supported.</p>
        pub fn r#type(mut self, inp: crate::model::ClientAuthenticationType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of client authentication to disable. Currently, only the parameter, <code>SmartCard</code> is supported.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ClientAuthenticationType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableLDAPS`.
    ///
    /// <p>Deactivates LDAP secure calls for the specified directory.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisableLDAPS<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_ldaps_input::Builder,
    }
    impl<C, M, R> DisableLDAPS<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableLDAPS`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableLdapsOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableLDAPSError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableLdapsInputOperationOutputAlias,
                crate::output::DisableLdapsOutput,
                crate::error::DisableLDAPSError,
                crate::input::DisableLdapsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The type of LDAP security to enable. Currently only the value <code>Client</code> is
        /// supported.</p>
        pub fn r#type(mut self, inp: crate::model::LdapsType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of LDAP security to enable. Currently only the value <code>Client</code> is
        /// supported.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::LdapsType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableRadius`.
    ///
    /// <p>Disables multi-factor authentication (MFA) with the Remote Authentication Dial In
    /// User Service (RADIUS) server for an AD Connector or Microsoft AD directory.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisableRadius<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_radius_input::Builder,
    }
    impl<C, M, R> DisableRadius<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableRadius`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableRadiusOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableRadiusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableRadiusInputOperationOutputAlias,
                crate::output::DisableRadiusOutput,
                crate::error::DisableRadiusError,
                crate::input::DisableRadiusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory for which to disable MFA.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The identifier of the directory for which to disable MFA.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableSso`.
    ///
    /// <p>Disables single-sign on for a directory.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisableSso<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_sso_input::Builder,
    }
    impl<C, M, R> DisableSso<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableSso`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableSsoOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableSsoError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableSsoInputOperationOutputAlias,
                crate::output::DisableSsoOutput,
                crate::error::DisableSsoError,
                crate::input::DisableSsoInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory for which to disable single-sign on.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The identifier of the directory for which to disable single-sign on.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The username of an alternate account to use to disable single-sign on. This is only used
        /// for AD Connector directories. This account must have privileges to remove a service
        /// principal name.</p>
        /// <p>If the AD Connector service account does not have privileges to remove a service
        /// principal name, you can specify an alternate account with the <i>UserName</i>
        /// and <i>Password</i> parameters. These credentials are only used to disable
        /// single sign-on and are not stored by the service. The AD Connector service account is not
        /// changed.</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The username of an alternate account to use to disable single-sign on. This is only used
        /// for AD Connector directories. This account must have privileges to remove a service
        /// principal name.</p>
        /// <p>If the AD Connector service account does not have privileges to remove a service
        /// principal name, you can specify an alternate account with the <i>UserName</i>
        /// and <i>Password</i> parameters. These credentials are only used to disable
        /// single sign-on and are not stored by the service. The AD Connector service account is not
        /// changed.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The password of an alternate account to use to disable single-sign on. This is only used
        /// for AD Connector directories. For more information, see the <i>UserName</i>
        /// parameter.</p>
        pub fn password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(inp);
            self
        }
        /// <p>The password of an alternate account to use to disable single-sign on. This is only used
        /// for AD Connector directories. For more information, see the <i>UserName</i>
        /// parameter.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableClientAuthentication`.
    ///
    /// <p>Enables alternative client authentication methods for the specified directory.</p>
    #[derive(std::fmt::Debug)]
    pub struct EnableClientAuthentication<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_client_authentication_input::Builder,
    }
    impl<C, M, R> EnableClientAuthentication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableClientAuthentication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableClientAuthenticationOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableClientAuthenticationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableClientAuthenticationInputOperationOutputAlias,
                crate::output::EnableClientAuthenticationOutput,
                crate::error::EnableClientAuthenticationError,
                crate::input::EnableClientAuthenticationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the specified directory. </p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The identifier of the specified directory. </p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The type of client authentication to enable. Currently only the value <code>SmartCard</code> is
        /// supported. Smart card authentication in AD Connector requires that you enable Kerberos
        /// Constrained Delegation for the Service User to the LDAP service in your self-managed AD.
        /// </p>
        pub fn r#type(mut self, inp: crate::model::ClientAuthenticationType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of client authentication to enable. Currently only the value <code>SmartCard</code> is
        /// supported. Smart card authentication in AD Connector requires that you enable Kerberos
        /// Constrained Delegation for the Service User to the LDAP service in your self-managed AD.
        /// </p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ClientAuthenticationType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableLDAPS`.
    ///
    /// <p>Activates the switch for the specific directory to always use LDAP secure calls.</p>
    #[derive(std::fmt::Debug)]
    pub struct EnableLDAPS<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_ldaps_input::Builder,
    }
    impl<C, M, R> EnableLDAPS<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableLDAPS`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableLdapsOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableLDAPSError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableLdapsInputOperationOutputAlias,
                crate::output::EnableLdapsOutput,
                crate::error::EnableLDAPSError,
                crate::input::EnableLdapsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The type of LDAP security to enable. Currently only the value <code>Client</code> is
        /// supported.</p>
        pub fn r#type(mut self, inp: crate::model::LdapsType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of LDAP security to enable. Currently only the value <code>Client</code> is
        /// supported.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::LdapsType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableRadius`.
    ///
    /// <p>Enables multi-factor authentication (MFA) with the Remote Authentication Dial In User
    /// Service (RADIUS) server for an AD Connector or Microsoft AD directory.</p>
    #[derive(std::fmt::Debug)]
    pub struct EnableRadius<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_radius_input::Builder,
    }
    impl<C, M, R> EnableRadius<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableRadius`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableRadiusOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableRadiusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableRadiusInputOperationOutputAlias,
                crate::output::EnableRadiusOutput,
                crate::error::EnableRadiusError,
                crate::input::EnableRadiusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory for which to enable MFA.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The identifier of the directory for which to enable MFA.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>A <a>RadiusSettings</a> object that contains information about the RADIUS
        /// server.</p>
        pub fn radius_settings(mut self, inp: crate::model::RadiusSettings) -> Self {
            self.inner = self.inner.radius_settings(inp);
            self
        }
        /// <p>A <a>RadiusSettings</a> object that contains information about the RADIUS
        /// server.</p>
        pub fn set_radius_settings(
            mut self,
            input: std::option::Option<crate::model::RadiusSettings>,
        ) -> Self {
            self.inner = self.inner.set_radius_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableSso`.
    ///
    /// <p>Enables single sign-on for a directory. Single sign-on allows users in your directory to
    /// access certain Amazon Web Services services from a computer joined to the directory without having to enter
    /// their credentials separately.</p>
    #[derive(std::fmt::Debug)]
    pub struct EnableSso<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_sso_input::Builder,
    }
    impl<C, M, R> EnableSso<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableSso`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableSsoOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableSsoError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableSsoInputOperationOutputAlias,
                crate::output::EnableSsoOutput,
                crate::error::EnableSsoError,
                crate::input::EnableSsoInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory for which to enable single-sign on.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The identifier of the directory for which to enable single-sign on.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The username of an alternate account to use to enable single-sign on. This is only used
        /// for AD Connector directories. This account must have privileges to add a service principal
        /// name.</p>
        /// <p>If the AD Connector service account does not have privileges to add a service principal
        /// name, you can specify an alternate account with the <i>UserName</i> and
        /// <i>Password</i> parameters. These credentials are only used to enable single
        /// sign-on and are not stored by the service. The AD Connector service account is not
        /// changed.</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The username of an alternate account to use to enable single-sign on. This is only used
        /// for AD Connector directories. This account must have privileges to add a service principal
        /// name.</p>
        /// <p>If the AD Connector service account does not have privileges to add a service principal
        /// name, you can specify an alternate account with the <i>UserName</i> and
        /// <i>Password</i> parameters. These credentials are only used to enable single
        /// sign-on and are not stored by the service. The AD Connector service account is not
        /// changed.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The password of an alternate account to use to enable single-sign on. This is only used
        /// for AD Connector directories. For more information, see the <i>UserName</i>
        /// parameter.</p>
        pub fn password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(inp);
            self
        }
        /// <p>The password of an alternate account to use to enable single-sign on. This is only used
        /// for AD Connector directories. For more information, see the <i>UserName</i>
        /// parameter.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDirectoryLimits`.
    ///
    /// <p>Obtains directory limit information for the current Region.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDirectoryLimits<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_directory_limits_input::Builder,
    }
    impl<C, M, R> GetDirectoryLimits<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDirectoryLimits`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDirectoryLimitsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDirectoryLimitsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDirectoryLimitsInputOperationOutputAlias,
                crate::output::GetDirectoryLimitsOutput,
                crate::error::GetDirectoryLimitsError,
                crate::input::GetDirectoryLimitsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetSnapshotLimits`.
    ///
    /// <p>Obtains the manual snapshot limits for a directory.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSnapshotLimits<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_snapshot_limits_input::Builder,
    }
    impl<C, M, R> GetSnapshotLimits<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSnapshotLimits`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSnapshotLimitsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSnapshotLimitsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSnapshotLimitsInputOperationOutputAlias,
                crate::output::GetSnapshotLimitsOutput,
                crate::error::GetSnapshotLimitsError,
                crate::input::GetSnapshotLimitsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Contains the identifier of the directory to obtain the limits for.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>Contains the identifier of the directory to obtain the limits for.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCertificates`.
    ///
    /// <p>For the specified directory, lists all the certificates registered for a secure LDAP or client certificate authentication.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListCertificates<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_certificates_input::Builder,
    }
    impl<C, M, R> ListCertificates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCertificates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCertificatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCertificatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCertificatesInputOperationOutputAlias,
                crate::output::ListCertificatesOutput,
                crate::error::ListCertificatesError,
                crate::input::ListCertificatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>A token for requesting another page of certificates if the <code>NextToken</code> response
        /// element indicates that more certificates are available. Use the value of the returned
        /// <code>NextToken</code> element in your request until the token comes back as
        /// <code>null</code>. Pass <code>null</code> if this is the first call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token for requesting another page of certificates if the <code>NextToken</code> response
        /// element indicates that more certificates are available. Use the value of the returned
        /// <code>NextToken</code> element in your request until the token comes back as
        /// <code>null</code>. Pass <code>null</code> if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of items that should show up on one page</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The number of items that should show up on one page</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIpRoutes`.
    ///
    /// <p>Lists the address blocks that you have added to a directory.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListIpRoutes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_ip_routes_input::Builder,
    }
    impl<C, M, R> ListIpRoutes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListIpRoutes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIpRoutesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIpRoutesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListIpRoutesInputOperationOutputAlias,
                crate::output::ListIpRoutesOutput,
                crate::error::ListIpRoutesError,
                crate::input::ListIpRoutesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier (ID) of the directory for which you want to retrieve the IP
        /// addresses.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>Identifier (ID) of the directory for which you want to retrieve the IP
        /// addresses.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The <i>ListIpRoutes.NextToken</i> value from a previous call to <a>ListIpRoutes</a>. Pass null if this is the first call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <i>ListIpRoutes.NextToken</i> value from a previous call to <a>ListIpRoutes</a>. Pass null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of items to return. If this value is zero, the maximum number of items
        /// is specified by the limitations of the operation.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>Maximum number of items to return. If this value is zero, the maximum number of items
        /// is specified by the limitations of the operation.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLogSubscriptions`.
    ///
    /// <p>Lists the active log subscriptions for the Amazon Web Services account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListLogSubscriptions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_log_subscriptions_input::Builder,
    }
    impl<C, M, R> ListLogSubscriptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLogSubscriptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLogSubscriptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLogSubscriptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLogSubscriptionsInputOperationOutputAlias,
                crate::output::ListLogSubscriptionsOutput,
                crate::error::ListLogSubscriptionsError,
                crate::input::ListLogSubscriptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>If a <i>DirectoryID</i> is provided, lists only the log subscription
        /// associated with that directory. If no <i>DirectoryId</i> is provided, lists all
        /// log subscriptions associated with your Amazon Web Services account. If there are no log subscriptions for the
        /// Amazon Web Services account or the directory, an empty list will be returned.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>If a <i>DirectoryID</i> is provided, lists only the log subscription
        /// associated with that directory. If no <i>DirectoryId</i> is provided, lists all
        /// log subscriptions associated with your Amazon Web Services account. If there are no log subscriptions for the
        /// Amazon Web Services account or the directory, an empty list will be returned.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The token for the next set of items to return.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items returned.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of items returned.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSchemaExtensions`.
    ///
    /// <p>Lists all schema extensions applied to a Microsoft AD Directory.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSchemaExtensions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_schema_extensions_input::Builder,
    }
    impl<C, M, R> ListSchemaExtensions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSchemaExtensions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSchemaExtensionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSchemaExtensionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSchemaExtensionsInputOperationOutputAlias,
                crate::output::ListSchemaExtensionsOutput,
                crate::error::ListSchemaExtensionsError,
                crate::input::ListSchemaExtensionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory from which to retrieve the schema extension
        /// information.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The identifier of the directory from which to retrieve the schema extension
        /// information.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The <code>ListSchemaExtensions.NextToken</code> value from a previous call to
        /// <code>ListSchemaExtensions</code>. Pass null if this is the first call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>ListSchemaExtensions.NextToken</code> value from a previous call to
        /// <code>ListSchemaExtensions</code>. Pass null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists all tags on a directory.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier (ID) of the directory for which you want to retrieve tags.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>Identifier (ID) of the directory for which you want to retrieve tags.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterCertificate`.
    ///
    /// <p>Registers a certificate for a secure LDAP or client certificate authentication.</p>
    #[derive(std::fmt::Debug)]
    pub struct RegisterCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_certificate_input::Builder,
    }
    impl<C, M, R> RegisterCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterCertificateInputOperationOutputAlias,
                crate::output::RegisterCertificateOutput,
                crate::error::RegisterCertificateError,
                crate::input::RegisterCertificateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The certificate PEM string that needs to be registered.</p>
        pub fn certificate_data(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_data(inp);
            self
        }
        /// <p>The certificate PEM string that needs to be registered.</p>
        pub fn set_certificate_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_data(input);
            self
        }
        /// <p>The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.</p>
        pub fn r#type(mut self, inp: crate::model::CertificateType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::CertificateType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>A <code>ClientCertAuthSettings</code> object that contains client certificate authentication settings.</p>
        pub fn client_cert_auth_settings(
            mut self,
            inp: crate::model::ClientCertAuthSettings,
        ) -> Self {
            self.inner = self.inner.client_cert_auth_settings(inp);
            self
        }
        /// <p>A <code>ClientCertAuthSettings</code> object that contains client certificate authentication settings.</p>
        pub fn set_client_cert_auth_settings(
            mut self,
            input: std::option::Option<crate::model::ClientCertAuthSettings>,
        ) -> Self {
            self.inner = self.inner.set_client_cert_auth_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterEventTopic`.
    ///
    /// <p>Associates a directory with an Amazon SNS topic. This establishes the directory as a
    /// publisher to the specified Amazon SNS topic. You can then receive email or text (SMS) messages when
    /// the status of your directory changes. You get notified if your directory goes from an Active
    /// status to an Impaired or Inoperable status. You also receive a notification when the directory
    /// returns to an Active status.</p>
    #[derive(std::fmt::Debug)]
    pub struct RegisterEventTopic<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_event_topic_input::Builder,
    }
    impl<C, M, R> RegisterEventTopic<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterEventTopic`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterEventTopicOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterEventTopicError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterEventTopicInputOperationOutputAlias,
                crate::output::RegisterEventTopicOutput,
                crate::error::RegisterEventTopicError,
                crate::input::RegisterEventTopicInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Directory ID that will publish status messages to the Amazon SNS topic.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The Directory ID that will publish status messages to the Amazon SNS topic.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The Amazon SNS topic name to which the directory will publish status messages. This Amazon SNS
        /// topic must be in the same region as the specified Directory ID.</p>
        pub fn topic_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.topic_name(inp);
            self
        }
        /// <p>The Amazon SNS topic name to which the directory will publish status messages. This Amazon SNS
        /// topic must be in the same region as the specified Directory ID.</p>
        pub fn set_topic_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_topic_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RejectSharedDirectory`.
    ///
    /// <p>Rejects a directory sharing request that was sent from the directory owner account.</p>
    #[derive(std::fmt::Debug)]
    pub struct RejectSharedDirectory<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reject_shared_directory_input::Builder,
    }
    impl<C, M, R> RejectSharedDirectory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RejectSharedDirectory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RejectSharedDirectoryOutput,
            aws_smithy_http::result::SdkError<crate::error::RejectSharedDirectoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RejectSharedDirectoryInputOperationOutputAlias,
                crate::output::RejectSharedDirectoryOutput,
                crate::error::RejectSharedDirectoryError,
                crate::input::RejectSharedDirectoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier of the shared directory in the directory consumer account. This identifier is
        /// different for each directory owner account.</p>
        pub fn shared_directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.shared_directory_id(inp);
            self
        }
        /// <p>Identifier of the shared directory in the directory consumer account. This identifier is
        /// different for each directory owner account.</p>
        pub fn set_shared_directory_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_shared_directory_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveIpRoutes`.
    ///
    /// <p>Removes IP address blocks from a directory.</p>
    #[derive(std::fmt::Debug)]
    pub struct RemoveIpRoutes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_ip_routes_input::Builder,
    }
    impl<C, M, R> RemoveIpRoutes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveIpRoutes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveIpRoutesOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveIpRoutesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveIpRoutesInputOperationOutputAlias,
                crate::output::RemoveIpRoutesOutput,
                crate::error::RemoveIpRoutesError,
                crate::input::RemoveIpRoutesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier (ID) of the directory from which you want to remove the IP
        /// addresses.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>Identifier (ID) of the directory from which you want to remove the IP
        /// addresses.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// Appends an item to `CidrIps`.
        ///
        /// To override the contents of this collection use [`set_cidr_ips`](Self::set_cidr_ips).
        ///
        /// <p>IP address blocks that you want to remove.</p>
        pub fn cidr_ips(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cidr_ips(inp);
            self
        }
        /// <p>IP address blocks that you want to remove.</p>
        pub fn set_cidr_ips(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cidr_ips(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveRegion`.
    ///
    /// <p>Stops all replication and removes the domain controllers from the specified Region. You
    /// cannot remove the primary Region with this operation. Instead, use the
    /// <code>DeleteDirectory</code> API.</p>
    #[derive(std::fmt::Debug)]
    pub struct RemoveRegion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_region_input::Builder,
    }
    impl<C, M, R> RemoveRegion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveRegion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveRegionOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveRegionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveRegionInputOperationOutputAlias,
                crate::output::RemoveRegionOutput,
                crate::error::RemoveRegionError,
                crate::input::RemoveRegionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory for which you want to remove Region replication.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The identifier of the directory for which you want to remove Region replication.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveTagsFromResource`.
    ///
    /// <p>Removes tags from a directory.</p>
    #[derive(std::fmt::Debug)]
    pub struct RemoveTagsFromResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_tags_from_resource_input::Builder,
    }
    impl<C, M, R> RemoveTagsFromResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveTagsFromResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveTagsFromResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveTagsFromResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveTagsFromResourceInputOperationOutputAlias,
                crate::output::RemoveTagsFromResourceOutput,
                crate::error::RemoveTagsFromResourceError,
                crate::input::RemoveTagsFromResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier (ID) of the directory from which to remove the tag.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>Identifier (ID) of the directory from which to remove the tag.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag key (name) of the tag to be removed.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The tag key (name) of the tag to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResetUserPassword`.
    ///
    /// <p>Resets the password for any user in your Managed Microsoft AD or Simple AD
    /// directory.</p>
    /// <p>You can reset the password for any user in your directory with the following
    /// exceptions:</p>
    /// <ul>
    /// <li>
    /// <p>For Simple AD, you cannot reset the password for any user that is a member of either
    /// the <b>Domain Admins</b> or <b>Enterprise
    /// Admins</b> group except for the administrator user.</p>
    /// </li>
    /// <li>
    /// <p>For Managed Microsoft AD, you can only reset the password for a user that is in an
    /// OU based off of the NetBIOS name that you typed when you created your directory. For
    /// example, you cannot reset the password for a user in the <b>Amazon Web Services
    /// Reserved</b> OU. For more information about the OU structure for an Managed Microsoft AD directory, see <a href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ms_ad_getting_started_what_gets_created.html">What Gets Created</a> in the <i>Directory Service Administration
    /// Guide</i>.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct ResetUserPassword<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reset_user_password_input::Builder,
    }
    impl<C, M, R> ResetUserPassword<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResetUserPassword`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResetUserPasswordOutput,
            aws_smithy_http::result::SdkError<crate::error::ResetUserPasswordError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResetUserPasswordInputOperationOutputAlias,
                crate::output::ResetUserPasswordOutput,
                crate::error::ResetUserPasswordError,
                crate::input::ResetUserPasswordInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier of the Managed Microsoft AD or Simple AD directory in which the user
        /// resides.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>Identifier of the Managed Microsoft AD or Simple AD directory in which the user
        /// resides.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The user name of the user whose password will be reset.</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The user name of the user whose password will be reset.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The new password that will be reset.</p>
        pub fn new_password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_password(inp);
            self
        }
        /// <p>The new password that will be reset.</p>
        pub fn set_new_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_new_password(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestoreFromSnapshot`.
    ///
    /// <p>Restores a directory using an existing directory snapshot.</p>
    /// <p>When you restore a directory from a snapshot, any changes made to the directory after the snapshot date are overwritten.</p>
    /// <p>This action returns as soon as the restore operation is initiated. You can monitor the
    /// progress of the restore operation by calling the <a>DescribeDirectories</a> operation with
    /// the directory identifier. When the <b>DirectoryDescription.Stage</b> value changes to
    /// <code>Active</code>, the restore operation is complete.</p>
    #[derive(std::fmt::Debug)]
    pub struct RestoreFromSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::restore_from_snapshot_input::Builder,
    }
    impl<C, M, R> RestoreFromSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RestoreFromSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestoreFromSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::RestoreFromSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RestoreFromSnapshotInputOperationOutputAlias,
                crate::output::RestoreFromSnapshotOutput,
                crate::error::RestoreFromSnapshotError,
                crate::input::RestoreFromSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the snapshot to restore from.</p>
        pub fn snapshot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_id(inp);
            self
        }
        /// <p>The identifier of the snapshot to restore from.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_snapshot_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ShareDirectory`.
    ///
    /// <p>Shares a specified directory (<code>DirectoryId</code>) in your Amazon Web Services account (directory
    /// owner) with another Amazon Web Services account (directory consumer). With this operation you can use your
    /// directory from any Amazon Web Services account and from any Amazon VPC within an Amazon Web Services Region.</p>
    /// <p>When you share your Managed Microsoft AD directory, Directory Service creates a
    /// shared directory in the directory consumer account. This shared directory contains the
    /// metadata to provide access to the directory within the directory owner account. The shared
    /// directory is visible in all VPCs in the directory consumer account.</p>
    /// <p>The <code>ShareMethod</code> parameter determines whether the specified directory can be
    /// shared between Amazon Web Services accounts inside the same Amazon Web Services organization (<code>ORGANIZATIONS</code>). It
    /// also determines whether you can share the directory with any other Amazon Web Services account either inside
    /// or outside of the organization (<code>HANDSHAKE</code>).</p>
    /// <p>The <code>ShareNotes</code> parameter is only used when <code>HANDSHAKE</code> is called,
    /// which sends a directory sharing request to the directory consumer. </p>
    #[derive(std::fmt::Debug)]
    pub struct ShareDirectory<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::share_directory_input::Builder,
    }
    impl<C, M, R> ShareDirectory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ShareDirectory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ShareDirectoryOutput,
            aws_smithy_http::result::SdkError<crate::error::ShareDirectoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ShareDirectoryInputOperationOutputAlias,
                crate::output::ShareDirectoryOutput,
                crate::error::ShareDirectoryError,
                crate::input::ShareDirectoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier of the Managed Microsoft AD directory that you want to share with other Amazon Web Services accounts.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>Identifier of the Managed Microsoft AD directory that you want to share with other Amazon Web Services accounts.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>A directory share request that is sent by the directory owner to the directory consumer.
        /// The request includes a typed message to help the directory consumer administrator determine
        /// whether to approve or reject the share invitation.</p>
        pub fn share_notes(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.share_notes(inp);
            self
        }
        /// <p>A directory share request that is sent by the directory owner to the directory consumer.
        /// The request includes a typed message to help the directory consumer administrator determine
        /// whether to approve or reject the share invitation.</p>
        pub fn set_share_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_share_notes(input);
            self
        }
        /// <p>Identifier for the directory consumer account with whom the directory is to be
        /// shared.</p>
        pub fn share_target(mut self, inp: crate::model::ShareTarget) -> Self {
            self.inner = self.inner.share_target(inp);
            self
        }
        /// <p>Identifier for the directory consumer account with whom the directory is to be
        /// shared.</p>
        pub fn set_share_target(
            mut self,
            input: std::option::Option<crate::model::ShareTarget>,
        ) -> Self {
            self.inner = self.inner.set_share_target(input);
            self
        }
        /// <p>The method used when sharing a directory to determine whether the directory should be
        /// shared within your Amazon Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services account by
        /// sending a directory sharing request (<code>HANDSHAKE</code>).</p>
        pub fn share_method(mut self, inp: crate::model::ShareMethod) -> Self {
            self.inner = self.inner.share_method(inp);
            self
        }
        /// <p>The method used when sharing a directory to determine whether the directory should be
        /// shared within your Amazon Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services account by
        /// sending a directory sharing request (<code>HANDSHAKE</code>).</p>
        pub fn set_share_method(
            mut self,
            input: std::option::Option<crate::model::ShareMethod>,
        ) -> Self {
            self.inner = self.inner.set_share_method(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartSchemaExtension`.
    ///
    /// <p>Applies a schema extension to a Microsoft AD directory.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartSchemaExtension<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_schema_extension_input::Builder,
    }
    impl<C, M, R> StartSchemaExtension<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartSchemaExtension`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartSchemaExtensionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartSchemaExtensionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartSchemaExtensionInputOperationOutputAlias,
                crate::output::StartSchemaExtensionOutput,
                crate::error::StartSchemaExtensionError,
                crate::input::StartSchemaExtensionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory for which the schema extension will be applied
        /// to.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The identifier of the directory for which the schema extension will be applied
        /// to.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>If true, creates a snapshot of the directory before applying the schema
        /// extension.</p>
        pub fn create_snapshot_before_schema_extension(mut self, inp: bool) -> Self {
            self.inner = self.inner.create_snapshot_before_schema_extension(inp);
            self
        }
        /// <p>If true, creates a snapshot of the directory before applying the schema
        /// extension.</p>
        pub fn set_create_snapshot_before_schema_extension(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self
                .inner
                .set_create_snapshot_before_schema_extension(input);
            self
        }
        /// <p>The LDIF file represented as a string. To construct the LdifContent string, precede
        /// each line as it would be formatted in an ldif file with \n. See the example request below for
        /// more details. The file size can be no larger than 1MB.</p>
        pub fn ldif_content(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ldif_content(inp);
            self
        }
        /// <p>The LDIF file represented as a string. To construct the LdifContent string, precede
        /// each line as it would be formatted in an ldif file with \n. See the example request below for
        /// more details. The file size can be no larger than 1MB.</p>
        pub fn set_ldif_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ldif_content(input);
            self
        }
        /// <p>A description of the schema extension.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the schema extension.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UnshareDirectory`.
    ///
    /// <p>Stops the directory sharing between the directory owner and consumer accounts. </p>
    #[derive(std::fmt::Debug)]
    pub struct UnshareDirectory<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::unshare_directory_input::Builder,
    }
    impl<C, M, R> UnshareDirectory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UnshareDirectory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UnshareDirectoryOutput,
            aws_smithy_http::result::SdkError<crate::error::UnshareDirectoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UnshareDirectoryInputOperationOutputAlias,
                crate::output::UnshareDirectoryOutput,
                crate::error::UnshareDirectoryError,
                crate::input::UnshareDirectoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Managed Microsoft AD directory that you want to stop
        /// sharing.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The identifier of the Managed Microsoft AD directory that you want to stop
        /// sharing.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>Identifier for the directory consumer account with whom the directory has to be
        /// unshared.</p>
        pub fn unshare_target(mut self, inp: crate::model::UnshareTarget) -> Self {
            self.inner = self.inner.unshare_target(inp);
            self
        }
        /// <p>Identifier for the directory consumer account with whom the directory has to be
        /// unshared.</p>
        pub fn set_unshare_target(
            mut self,
            input: std::option::Option<crate::model::UnshareTarget>,
        ) -> Self {
            self.inner = self.inner.set_unshare_target(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConditionalForwarder`.
    ///
    /// <p>Updates a conditional forwarder that has been set up for your Amazon Web Services
    /// directory.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateConditionalForwarder<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_conditional_forwarder_input::Builder,
    }
    impl<C, M, R> UpdateConditionalForwarder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateConditionalForwarder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConditionalForwarderOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateConditionalForwarderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateConditionalForwarderInputOperationOutputAlias,
                crate::output::UpdateConditionalForwarderOutput,
                crate::error::UpdateConditionalForwarderError,
                crate::input::UpdateConditionalForwarderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The directory ID of the Amazon Web Services directory for which to update the conditional
        /// forwarder.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The directory ID of the Amazon Web Services directory for which to update the conditional
        /// forwarder.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The fully qualified domain name (FQDN) of the remote domain with which you will set up
        /// a trust relationship.</p>
        pub fn remote_domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.remote_domain_name(inp);
            self
        }
        /// <p>The fully qualified domain name (FQDN) of the remote domain with which you will set up
        /// a trust relationship.</p>
        pub fn set_remote_domain_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_remote_domain_name(input);
            self
        }
        /// Appends an item to `DnsIpAddrs`.
        ///
        /// To override the contents of this collection use [`set_dns_ip_addrs`](Self::set_dns_ip_addrs).
        ///
        /// <p>The updated IP addresses of the remote DNS server associated with the conditional
        /// forwarder.</p>
        pub fn dns_ip_addrs(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dns_ip_addrs(inp);
            self
        }
        /// <p>The updated IP addresses of the remote DNS server associated with the conditional
        /// forwarder.</p>
        pub fn set_dns_ip_addrs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_dns_ip_addrs(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateNumberOfDomainControllers`.
    ///
    /// <p>Adds or removes domain controllers to or from the directory. Based on the difference
    /// between current value and new value (provided through this API call), domain controllers will
    /// be added or removed. It may take up to 45 minutes for any new domain controllers to become
    /// fully active once the requested number of domain controllers is updated. During this time, you
    /// cannot make another update request.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateNumberOfDomainControllers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_number_of_domain_controllers_input::Builder,
    }
    impl<C, M, R> UpdateNumberOfDomainControllers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateNumberOfDomainControllers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateNumberOfDomainControllersOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateNumberOfDomainControllersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateNumberOfDomainControllersInputOperationOutputAlias,
                crate::output::UpdateNumberOfDomainControllersOutput,
                crate::error::UpdateNumberOfDomainControllersError,
                crate::input::UpdateNumberOfDomainControllersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier of the directory to which the domain controllers will be added or
        /// removed.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>Identifier of the directory to which the domain controllers will be added or
        /// removed.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The number of domain controllers desired in the directory.</p>
        pub fn desired_number(mut self, inp: i32) -> Self {
            self.inner = self.inner.desired_number(inp);
            self
        }
        /// <p>The number of domain controllers desired in the directory.</p>
        pub fn set_desired_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_desired_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRadius`.
    ///
    /// <p>Updates the Remote Authentication Dial In User Service (RADIUS) server information
    /// for an AD Connector or Microsoft AD directory.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRadius<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_radius_input::Builder,
    }
    impl<C, M, R> UpdateRadius<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRadius`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRadiusOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRadiusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRadiusInputOperationOutputAlias,
                crate::output::UpdateRadiusOutput,
                crate::error::UpdateRadiusError,
                crate::input::UpdateRadiusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory for which to update the RADIUS server
        /// information.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The identifier of the directory for which to update the RADIUS server
        /// information.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>A <a>RadiusSettings</a> object that contains information about the RADIUS
        /// server.</p>
        pub fn radius_settings(mut self, inp: crate::model::RadiusSettings) -> Self {
            self.inner = self.inner.radius_settings(inp);
            self
        }
        /// <p>A <a>RadiusSettings</a> object that contains information about the RADIUS
        /// server.</p>
        pub fn set_radius_settings(
            mut self,
            input: std::option::Option<crate::model::RadiusSettings>,
        ) -> Self {
            self.inner = self.inner.set_radius_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTrust`.
    ///
    /// <p>Updates the trust that has been set up between your Managed Microsoft AD directory and an
    /// self-managed Active Directory.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateTrust<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_trust_input::Builder,
    }
    impl<C, M, R> UpdateTrust<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTrust`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTrustOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTrustError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTrustInputOperationOutputAlias,
                crate::output::UpdateTrustOutput,
                crate::error::UpdateTrustError,
                crate::input::UpdateTrustInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier of the trust relationship.</p>
        pub fn trust_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trust_id(inp);
            self
        }
        /// <p>Identifier of the trust relationship.</p>
        pub fn set_trust_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_trust_id(input);
            self
        }
        /// <p>Updates selective authentication for the trust.</p>
        pub fn selective_auth(mut self, inp: crate::model::SelectiveAuth) -> Self {
            self.inner = self.inner.selective_auth(inp);
            self
        }
        /// <p>Updates selective authentication for the trust.</p>
        pub fn set_selective_auth(
            mut self,
            input: std::option::Option<crate::model::SelectiveAuth>,
        ) -> Self {
            self.inner = self.inner.set_selective_auth(input);
            self
        }
    }
    /// Fluent builder constructing a request to `VerifyTrust`.
    ///
    /// <p>Directory Service for Microsoft Active Directory allows you to configure and verify trust
    /// relationships.</p>
    /// <p>This action verifies a trust relationship between your Managed Microsoft AD directory and an
    /// external domain.</p>
    #[derive(std::fmt::Debug)]
    pub struct VerifyTrust<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::verify_trust_input::Builder,
    }
    impl<C, M, R> VerifyTrust<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `VerifyTrust`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::VerifyTrustOutput,
            aws_smithy_http::result::SdkError<crate::error::VerifyTrustError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::VerifyTrustInputOperationOutputAlias,
                crate::output::VerifyTrustOutput,
                crate::error::VerifyTrustError,
                crate::input::VerifyTrustInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique Trust ID of the trust relationship to verify.</p>
        pub fn trust_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trust_id(inp);
            self
        }
        /// <p>The unique Trust ID of the trust relationship to verify.</p>
        pub fn set_trust_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_trust_id(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
