// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Direct Connect
///
/// Client for invoking operations on AWS Direct Connect. Each operation on AWS Direct Connect is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_directconnect::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_directconnect::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_directconnect::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AcceptDirectConnectGatewayAssociationProposal`](crate::client::fluent_builders::AcceptDirectConnectGatewayAssociationProposal) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`direct_connect_gateway_id(impl Into<String>)`](crate::client::fluent_builders::AcceptDirectConnectGatewayAssociationProposal::direct_connect_gateway_id) / [`set_direct_connect_gateway_id(Option<String>)`](crate::client::fluent_builders::AcceptDirectConnectGatewayAssociationProposal::set_direct_connect_gateway_id): <p>The ID of the Direct Connect gateway.</p>
    ///   - [`proposal_id(impl Into<String>)`](crate::client::fluent_builders::AcceptDirectConnectGatewayAssociationProposal::proposal_id) / [`set_proposal_id(Option<String>)`](crate::client::fluent_builders::AcceptDirectConnectGatewayAssociationProposal::set_proposal_id): <p>The ID of the request proposal.</p>
    ///   - [`associated_gateway_owner_account(impl Into<String>)`](crate::client::fluent_builders::AcceptDirectConnectGatewayAssociationProposal::associated_gateway_owner_account) / [`set_associated_gateway_owner_account(Option<String>)`](crate::client::fluent_builders::AcceptDirectConnectGatewayAssociationProposal::set_associated_gateway_owner_account): <p>The ID of the Amazon Web Services account that owns the virtual private gateway or transit gateway.</p>
    ///   - [`override_allowed_prefixes_to_direct_connect_gateway(Vec<RouteFilterPrefix>)`](crate::client::fluent_builders::AcceptDirectConnectGatewayAssociationProposal::override_allowed_prefixes_to_direct_connect_gateway) / [`set_override_allowed_prefixes_to_direct_connect_gateway(Option<Vec<RouteFilterPrefix>>)`](crate::client::fluent_builders::AcceptDirectConnectGatewayAssociationProposal::set_override_allowed_prefixes_to_direct_connect_gateway): <p>Overrides the Amazon VPC prefixes advertised to the Direct Connect gateway.</p>  <p>For information about how to set the prefixes, see <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes">Allowed Prefixes</a> in the <i>Direct Connect User Guide</i>.</p>
    /// - On success, responds with [`AcceptDirectConnectGatewayAssociationProposalOutput`](crate::output::AcceptDirectConnectGatewayAssociationProposalOutput) with field(s):
    ///   - [`direct_connect_gateway_association(Option<DirectConnectGatewayAssociation>)`](crate::output::AcceptDirectConnectGatewayAssociationProposalOutput::direct_connect_gateway_association): <p>Information about an association between a Direct Connect gateway and a virtual private gateway or transit gateway.</p>
    /// - On failure, responds with [`SdkError<AcceptDirectConnectGatewayAssociationProposalError>`](crate::error::AcceptDirectConnectGatewayAssociationProposalError)
    pub fn accept_direct_connect_gateway_association_proposal(
        &self,
    ) -> fluent_builders::AcceptDirectConnectGatewayAssociationProposal {
        fluent_builders::AcceptDirectConnectGatewayAssociationProposal::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AllocateConnectionOnInterconnect`](crate::client::fluent_builders::AllocateConnectionOnInterconnect) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bandwidth(impl Into<String>)`](crate::client::fluent_builders::AllocateConnectionOnInterconnect::bandwidth) / [`set_bandwidth(Option<String>)`](crate::client::fluent_builders::AllocateConnectionOnInterconnect::set_bandwidth): <p>The bandwidth of the connection. The possible values are 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, and 10Gbps. Note that only those Direct Connect Partners who have met specific requirements are allowed to create a 1Gbps, 2Gbps, 5Gbps or 10Gbps hosted connection.</p>
    ///   - [`connection_name(impl Into<String>)`](crate::client::fluent_builders::AllocateConnectionOnInterconnect::connection_name) / [`set_connection_name(Option<String>)`](crate::client::fluent_builders::AllocateConnectionOnInterconnect::set_connection_name): <p>The name of the provisioned connection.</p>
    ///   - [`owner_account(impl Into<String>)`](crate::client::fluent_builders::AllocateConnectionOnInterconnect::owner_account) / [`set_owner_account(Option<String>)`](crate::client::fluent_builders::AllocateConnectionOnInterconnect::set_owner_account): <p>The ID of the Amazon Web Services account of the customer for whom the connection will be provisioned.</p>
    ///   - [`interconnect_id(impl Into<String>)`](crate::client::fluent_builders::AllocateConnectionOnInterconnect::interconnect_id) / [`set_interconnect_id(Option<String>)`](crate::client::fluent_builders::AllocateConnectionOnInterconnect::set_interconnect_id): <p>The ID of the interconnect on which the connection will be provisioned.</p>
    ///   - [`vlan(i32)`](crate::client::fluent_builders::AllocateConnectionOnInterconnect::vlan) / [`set_vlan(i32)`](crate::client::fluent_builders::AllocateConnectionOnInterconnect::set_vlan): <p>The dedicated VLAN provisioned to the connection.</p>
    /// - On success, responds with [`AllocateConnectionOnInterconnectOutput`](crate::output::AllocateConnectionOnInterconnectOutput) with field(s):
    ///   - [`owner_account(Option<String>)`](crate::output::AllocateConnectionOnInterconnectOutput::owner_account): <p>The ID of the Amazon Web Services account that owns the connection.</p>
    ///   - [`connection_id(Option<String>)`](crate::output::AllocateConnectionOnInterconnectOutput::connection_id): <p>The ID of the connection.</p>
    ///   - [`connection_name(Option<String>)`](crate::output::AllocateConnectionOnInterconnectOutput::connection_name): <p>The name of the connection.</p>
    ///   - [`connection_state(Option<ConnectionState>)`](crate::output::AllocateConnectionOnInterconnectOutput::connection_state): <p>The state of the connection. The following are the possible values:</p>  <ul>   <li> <p> <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p> </li>   <li> <p> <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p> </li>   <li> <p> <code>pending</code>: The connection has been approved and is being initialized.</p> </li>   <li> <p> <code>available</code>: The network link is up and the connection is ready for use.</p> </li>   <li> <p> <code>down</code>: The network link is down.</p> </li>   <li> <p> <code>deleting</code>: The connection is being deleted.</p> </li>   <li> <p> <code>deleted</code>: The connection has been deleted.</p> </li>   <li> <p> <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p> </li>   <li> <p> <code>unknown</code>: The state of the connection is not available.</p> </li>  </ul>
    ///   - [`region(Option<String>)`](crate::output::AllocateConnectionOnInterconnectOutput::region): <p>The Amazon Web Services Region where the connection is located.</p>
    ///   - [`location(Option<String>)`](crate::output::AllocateConnectionOnInterconnectOutput::location): <p>The location of the connection.</p>
    ///   - [`bandwidth(Option<String>)`](crate::output::AllocateConnectionOnInterconnectOutput::bandwidth): <p>The bandwidth of the connection.</p>
    ///   - [`vlan(i32)`](crate::output::AllocateConnectionOnInterconnectOutput::vlan): <p>The ID of the VLAN.</p>
    ///   - [`partner_name(Option<String>)`](crate::output::AllocateConnectionOnInterconnectOutput::partner_name): <p>The name of the Direct Connect service provider associated with the connection.</p>
    ///   - [`loa_issue_time(Option<DateTime>)`](crate::output::AllocateConnectionOnInterconnectOutput::loa_issue_time): <p>The time of the most recent call to <code>DescribeLoa</code> for this connection.</p>
    ///   - [`lag_id(Option<String>)`](crate::output::AllocateConnectionOnInterconnectOutput::lag_id): <p>The ID of the LAG.</p>
    ///   - [`aws_device(Option<String>)`](crate::output::AllocateConnectionOnInterconnectOutput::aws_device): <p>The Direct Connect endpoint on which the physical connection terminates.</p>
    ///   - [`jumbo_frame_capable(Option<bool>)`](crate::output::AllocateConnectionOnInterconnectOutput::jumbo_frame_capable): <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    ///   - [`aws_device_v2(Option<String>)`](crate::output::AllocateConnectionOnInterconnectOutput::aws_device_v2): <p>The Direct Connect endpoint that terminates the physical connection.</p>
    ///   - [`aws_logical_device_id(Option<String>)`](crate::output::AllocateConnectionOnInterconnectOutput::aws_logical_device_id): <p>The Direct Connect endpoint that terminates the logical connection. This device might be different than the device that terminates the physical connection.</p>
    ///   - [`has_logical_redundancy(Option<HasLogicalRedundancy>)`](crate::output::AllocateConnectionOnInterconnectOutput::has_logical_redundancy): <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::AllocateConnectionOnInterconnectOutput::tags): <p>The tags associated with the connection.</p>
    ///   - [`provider_name(Option<String>)`](crate::output::AllocateConnectionOnInterconnectOutput::provider_name): <p>The name of the service provider associated with the connection.</p>
    ///   - [`mac_sec_capable(Option<bool>)`](crate::output::AllocateConnectionOnInterconnectOutput::mac_sec_capable): <p>Indicates whether the connection supports MAC Security (MACsec).</p>
    ///   - [`port_encryption_status(Option<String>)`](crate::output::AllocateConnectionOnInterconnectOutput::port_encryption_status): <p>The MAC Security (MACsec) port link status of the connection.</p>  <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
    ///   - [`encryption_mode(Option<String>)`](crate::output::AllocateConnectionOnInterconnectOutput::encryption_mode): <p>The MAC Security (MACsec) connection encryption mode.</p>  <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
    ///   - [`mac_sec_keys(Option<Vec<MacSecKey>>)`](crate::output::AllocateConnectionOnInterconnectOutput::mac_sec_keys): <p>The MAC Security (MACsec) security keys associated with the connection.</p>
    /// - On failure, responds with [`SdkError<AllocateConnectionOnInterconnectError>`](crate::error::AllocateConnectionOnInterconnectError)
    pub fn allocate_connection_on_interconnect(
        &self,
    ) -> fluent_builders::AllocateConnectionOnInterconnect {
        fluent_builders::AllocateConnectionOnInterconnect::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AllocateHostedConnection`](crate::client::fluent_builders::AllocateHostedConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connection_id(impl Into<String>)`](crate::client::fluent_builders::AllocateHostedConnection::connection_id) / [`set_connection_id(Option<String>)`](crate::client::fluent_builders::AllocateHostedConnection::set_connection_id): <p>The ID of the interconnect or LAG.</p>
    ///   - [`owner_account(impl Into<String>)`](crate::client::fluent_builders::AllocateHostedConnection::owner_account) / [`set_owner_account(Option<String>)`](crate::client::fluent_builders::AllocateHostedConnection::set_owner_account): <p>The ID of the Amazon Web Services account ID of the customer for the connection.</p>
    ///   - [`bandwidth(impl Into<String>)`](crate::client::fluent_builders::AllocateHostedConnection::bandwidth) / [`set_bandwidth(Option<String>)`](crate::client::fluent_builders::AllocateHostedConnection::set_bandwidth): <p>The bandwidth of the connection. The possible values are 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, and 10Gbps. Note that only those Direct Connect Partners who have met specific requirements are allowed to create a 1Gbps, 2Gbps, 5Gbps or 10Gbps hosted connection. </p>
    ///   - [`connection_name(impl Into<String>)`](crate::client::fluent_builders::AllocateHostedConnection::connection_name) / [`set_connection_name(Option<String>)`](crate::client::fluent_builders::AllocateHostedConnection::set_connection_name): <p>The name of the hosted connection.</p>
    ///   - [`vlan(i32)`](crate::client::fluent_builders::AllocateHostedConnection::vlan) / [`set_vlan(i32)`](crate::client::fluent_builders::AllocateHostedConnection::set_vlan): <p>The dedicated VLAN provisioned to the hosted connection.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::AllocateHostedConnection::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::AllocateHostedConnection::set_tags): <p>The tags associated with the connection.</p>
    /// - On success, responds with [`AllocateHostedConnectionOutput`](crate::output::AllocateHostedConnectionOutput) with field(s):
    ///   - [`owner_account(Option<String>)`](crate::output::AllocateHostedConnectionOutput::owner_account): <p>The ID of the Amazon Web Services account that owns the connection.</p>
    ///   - [`connection_id(Option<String>)`](crate::output::AllocateHostedConnectionOutput::connection_id): <p>The ID of the connection.</p>
    ///   - [`connection_name(Option<String>)`](crate::output::AllocateHostedConnectionOutput::connection_name): <p>The name of the connection.</p>
    ///   - [`connection_state(Option<ConnectionState>)`](crate::output::AllocateHostedConnectionOutput::connection_state): <p>The state of the connection. The following are the possible values:</p>  <ul>   <li> <p> <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p> </li>   <li> <p> <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p> </li>   <li> <p> <code>pending</code>: The connection has been approved and is being initialized.</p> </li>   <li> <p> <code>available</code>: The network link is up and the connection is ready for use.</p> </li>   <li> <p> <code>down</code>: The network link is down.</p> </li>   <li> <p> <code>deleting</code>: The connection is being deleted.</p> </li>   <li> <p> <code>deleted</code>: The connection has been deleted.</p> </li>   <li> <p> <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p> </li>   <li> <p> <code>unknown</code>: The state of the connection is not available.</p> </li>  </ul>
    ///   - [`region(Option<String>)`](crate::output::AllocateHostedConnectionOutput::region): <p>The Amazon Web Services Region where the connection is located.</p>
    ///   - [`location(Option<String>)`](crate::output::AllocateHostedConnectionOutput::location): <p>The location of the connection.</p>
    ///   - [`bandwidth(Option<String>)`](crate::output::AllocateHostedConnectionOutput::bandwidth): <p>The bandwidth of the connection.</p>
    ///   - [`vlan(i32)`](crate::output::AllocateHostedConnectionOutput::vlan): <p>The ID of the VLAN.</p>
    ///   - [`partner_name(Option<String>)`](crate::output::AllocateHostedConnectionOutput::partner_name): <p>The name of the Direct Connect service provider associated with the connection.</p>
    ///   - [`loa_issue_time(Option<DateTime>)`](crate::output::AllocateHostedConnectionOutput::loa_issue_time): <p>The time of the most recent call to <code>DescribeLoa</code> for this connection.</p>
    ///   - [`lag_id(Option<String>)`](crate::output::AllocateHostedConnectionOutput::lag_id): <p>The ID of the LAG.</p>
    ///   - [`aws_device(Option<String>)`](crate::output::AllocateHostedConnectionOutput::aws_device): <p>The Direct Connect endpoint on which the physical connection terminates.</p>
    ///   - [`jumbo_frame_capable(Option<bool>)`](crate::output::AllocateHostedConnectionOutput::jumbo_frame_capable): <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    ///   - [`aws_device_v2(Option<String>)`](crate::output::AllocateHostedConnectionOutput::aws_device_v2): <p>The Direct Connect endpoint that terminates the physical connection.</p>
    ///   - [`aws_logical_device_id(Option<String>)`](crate::output::AllocateHostedConnectionOutput::aws_logical_device_id): <p>The Direct Connect endpoint that terminates the logical connection. This device might be different than the device that terminates the physical connection.</p>
    ///   - [`has_logical_redundancy(Option<HasLogicalRedundancy>)`](crate::output::AllocateHostedConnectionOutput::has_logical_redundancy): <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::AllocateHostedConnectionOutput::tags): <p>The tags associated with the connection.</p>
    ///   - [`provider_name(Option<String>)`](crate::output::AllocateHostedConnectionOutput::provider_name): <p>The name of the service provider associated with the connection.</p>
    ///   - [`mac_sec_capable(Option<bool>)`](crate::output::AllocateHostedConnectionOutput::mac_sec_capable): <p>Indicates whether the connection supports MAC Security (MACsec).</p>
    ///   - [`port_encryption_status(Option<String>)`](crate::output::AllocateHostedConnectionOutput::port_encryption_status): <p>The MAC Security (MACsec) port link status of the connection.</p>  <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
    ///   - [`encryption_mode(Option<String>)`](crate::output::AllocateHostedConnectionOutput::encryption_mode): <p>The MAC Security (MACsec) connection encryption mode.</p>  <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
    ///   - [`mac_sec_keys(Option<Vec<MacSecKey>>)`](crate::output::AllocateHostedConnectionOutput::mac_sec_keys): <p>The MAC Security (MACsec) security keys associated with the connection.</p>
    /// - On failure, responds with [`SdkError<AllocateHostedConnectionError>`](crate::error::AllocateHostedConnectionError)
    pub fn allocate_hosted_connection(&self) -> fluent_builders::AllocateHostedConnection {
        fluent_builders::AllocateHostedConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AllocatePrivateVirtualInterface`](crate::client::fluent_builders::AllocatePrivateVirtualInterface) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connection_id(impl Into<String>)`](crate::client::fluent_builders::AllocatePrivateVirtualInterface::connection_id) / [`set_connection_id(Option<String>)`](crate::client::fluent_builders::AllocatePrivateVirtualInterface::set_connection_id): <p>The ID of the connection on which the private virtual interface is provisioned.</p>
    ///   - [`owner_account(impl Into<String>)`](crate::client::fluent_builders::AllocatePrivateVirtualInterface::owner_account) / [`set_owner_account(Option<String>)`](crate::client::fluent_builders::AllocatePrivateVirtualInterface::set_owner_account): <p>The ID of the Amazon Web Services account that owns the virtual private interface.</p>
    ///   - [`new_private_virtual_interface_allocation(NewPrivateVirtualInterfaceAllocation)`](crate::client::fluent_builders::AllocatePrivateVirtualInterface::new_private_virtual_interface_allocation) / [`set_new_private_virtual_interface_allocation(Option<NewPrivateVirtualInterfaceAllocation>)`](crate::client::fluent_builders::AllocatePrivateVirtualInterface::set_new_private_virtual_interface_allocation): <p>Information about the private virtual interface.</p>
    /// - On success, responds with [`AllocatePrivateVirtualInterfaceOutput`](crate::output::AllocatePrivateVirtualInterfaceOutput) with field(s):
    ///   - [`owner_account(Option<String>)`](crate::output::AllocatePrivateVirtualInterfaceOutput::owner_account): <p>The ID of the Amazon Web Services account that owns the virtual interface.</p>
    ///   - [`virtual_interface_id(Option<String>)`](crate::output::AllocatePrivateVirtualInterfaceOutput::virtual_interface_id): <p>The ID of the virtual interface.</p>
    ///   - [`location(Option<String>)`](crate::output::AllocatePrivateVirtualInterfaceOutput::location): <p>The location of the connection.</p>
    ///   - [`connection_id(Option<String>)`](crate::output::AllocatePrivateVirtualInterfaceOutput::connection_id): <p>The ID of the connection.</p>
    ///   - [`virtual_interface_type(Option<String>)`](crate::output::AllocatePrivateVirtualInterfaceOutput::virtual_interface_type): <p>The type of virtual interface. The possible values are <code>private</code> and <code>public</code>.</p>
    ///   - [`virtual_interface_name(Option<String>)`](crate::output::AllocatePrivateVirtualInterfaceOutput::virtual_interface_name): <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
    ///   - [`vlan(i32)`](crate::output::AllocatePrivateVirtualInterfaceOutput::vlan): <p>The ID of the VLAN.</p>
    ///   - [`asn(i32)`](crate::output::AllocatePrivateVirtualInterfaceOutput::asn): <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>  <p>The valid values are 1-2147483647.</p>
    ///   - [`amazon_side_asn(Option<i64>)`](crate::output::AllocatePrivateVirtualInterfaceOutput::amazon_side_asn): <p>The autonomous system number (ASN) for the Amazon side of the connection.</p>
    ///   - [`auth_key(Option<String>)`](crate::output::AllocatePrivateVirtualInterfaceOutput::auth_key): <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
    ///   - [`amazon_address(Option<String>)`](crate::output::AllocatePrivateVirtualInterfaceOutput::amazon_address): <p>The IP address assigned to the Amazon interface.</p>
    ///   - [`customer_address(Option<String>)`](crate::output::AllocatePrivateVirtualInterfaceOutput::customer_address): <p>The IP address assigned to the customer interface.</p>
    ///   - [`address_family(Option<AddressFamily>)`](crate::output::AllocatePrivateVirtualInterfaceOutput::address_family): <p>The address family for the BGP peer.</p>
    ///   - [`virtual_interface_state(Option<VirtualInterfaceState>)`](crate::output::AllocatePrivateVirtualInterfaceOutput::virtual_interface_state): <p>The state of the virtual interface. The following are the possible values:</p>  <ul>   <li> <p> <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p> </li>   <li> <p> <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p> </li>   <li> <p> <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p> </li>   <li> <p> <code>available</code>: A virtual interface that is able to forward traffic.</p> </li>   <li> <p> <code>down</code>: A virtual interface that is BGP down.</p> </li>   <li> <p> <code>deleting</code>: A virtual interface is in this state immediately after calling <code>DeleteVirtualInterface</code> until it can no longer forward traffic.</p> </li>   <li> <p> <code>deleted</code>: A virtual interface that cannot forward traffic.</p> </li>   <li> <p> <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p> </li>   <li> <p> <code>unknown</code>: The state of the virtual interface is not available.</p> </li>  </ul>
    ///   - [`customer_router_config(Option<String>)`](crate::output::AllocatePrivateVirtualInterfaceOutput::customer_router_config): <p>The customer router configuration.</p>
    ///   - [`mtu(Option<i32>)`](crate::output::AllocatePrivateVirtualInterfaceOutput::mtu): <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
    ///   - [`jumbo_frame_capable(Option<bool>)`](crate::output::AllocatePrivateVirtualInterfaceOutput::jumbo_frame_capable): <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    ///   - [`virtual_gateway_id(Option<String>)`](crate::output::AllocatePrivateVirtualInterfaceOutput::virtual_gateway_id): <p>The ID of the virtual private gateway. Applies only to private virtual interfaces.</p>
    ///   - [`direct_connect_gateway_id(Option<String>)`](crate::output::AllocatePrivateVirtualInterfaceOutput::direct_connect_gateway_id): <p>The ID of the Direct Connect gateway.</p>
    ///   - [`route_filter_prefixes(Option<Vec<RouteFilterPrefix>>)`](crate::output::AllocatePrivateVirtualInterfaceOutput::route_filter_prefixes): <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
    ///   - [`bgp_peers(Option<Vec<BgpPeer>>)`](crate::output::AllocatePrivateVirtualInterfaceOutput::bgp_peers): <p>The BGP peers configured on this virtual interface.</p>
    ///   - [`region(Option<String>)`](crate::output::AllocatePrivateVirtualInterfaceOutput::region): <p>The Amazon Web Services Region where the virtual interface is located.</p>
    ///   - [`aws_device_v2(Option<String>)`](crate::output::AllocatePrivateVirtualInterfaceOutput::aws_device_v2): <p>The Direct Connect endpoint that terminates the physical connection.</p>
    ///   - [`aws_logical_device_id(Option<String>)`](crate::output::AllocatePrivateVirtualInterfaceOutput::aws_logical_device_id): <p>The Direct Connect endpoint that terminates the logical connection. This device might be different than the device that terminates the physical connection.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::AllocatePrivateVirtualInterfaceOutput::tags): <p>The tags associated with the virtual interface.</p>
    ///   - [`site_link_enabled(Option<bool>)`](crate::output::AllocatePrivateVirtualInterfaceOutput::site_link_enabled): <p>Indicates whether SiteLink is enabled.</p>
    /// - On failure, responds with [`SdkError<AllocatePrivateVirtualInterfaceError>`](crate::error::AllocatePrivateVirtualInterfaceError)
    pub fn allocate_private_virtual_interface(
        &self,
    ) -> fluent_builders::AllocatePrivateVirtualInterface {
        fluent_builders::AllocatePrivateVirtualInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AllocatePublicVirtualInterface`](crate::client::fluent_builders::AllocatePublicVirtualInterface) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connection_id(impl Into<String>)`](crate::client::fluent_builders::AllocatePublicVirtualInterface::connection_id) / [`set_connection_id(Option<String>)`](crate::client::fluent_builders::AllocatePublicVirtualInterface::set_connection_id): <p>The ID of the connection on which the public virtual interface is provisioned.</p>
    ///   - [`owner_account(impl Into<String>)`](crate::client::fluent_builders::AllocatePublicVirtualInterface::owner_account) / [`set_owner_account(Option<String>)`](crate::client::fluent_builders::AllocatePublicVirtualInterface::set_owner_account): <p>The ID of the Amazon Web Services account that owns the public virtual interface.</p>
    ///   - [`new_public_virtual_interface_allocation(NewPublicVirtualInterfaceAllocation)`](crate::client::fluent_builders::AllocatePublicVirtualInterface::new_public_virtual_interface_allocation) / [`set_new_public_virtual_interface_allocation(Option<NewPublicVirtualInterfaceAllocation>)`](crate::client::fluent_builders::AllocatePublicVirtualInterface::set_new_public_virtual_interface_allocation): <p>Information about the public virtual interface.</p>
    /// - On success, responds with [`AllocatePublicVirtualInterfaceOutput`](crate::output::AllocatePublicVirtualInterfaceOutput) with field(s):
    ///   - [`owner_account(Option<String>)`](crate::output::AllocatePublicVirtualInterfaceOutput::owner_account): <p>The ID of the Amazon Web Services account that owns the virtual interface.</p>
    ///   - [`virtual_interface_id(Option<String>)`](crate::output::AllocatePublicVirtualInterfaceOutput::virtual_interface_id): <p>The ID of the virtual interface.</p>
    ///   - [`location(Option<String>)`](crate::output::AllocatePublicVirtualInterfaceOutput::location): <p>The location of the connection.</p>
    ///   - [`connection_id(Option<String>)`](crate::output::AllocatePublicVirtualInterfaceOutput::connection_id): <p>The ID of the connection.</p>
    ///   - [`virtual_interface_type(Option<String>)`](crate::output::AllocatePublicVirtualInterfaceOutput::virtual_interface_type): <p>The type of virtual interface. The possible values are <code>private</code> and <code>public</code>.</p>
    ///   - [`virtual_interface_name(Option<String>)`](crate::output::AllocatePublicVirtualInterfaceOutput::virtual_interface_name): <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
    ///   - [`vlan(i32)`](crate::output::AllocatePublicVirtualInterfaceOutput::vlan): <p>The ID of the VLAN.</p>
    ///   - [`asn(i32)`](crate::output::AllocatePublicVirtualInterfaceOutput::asn): <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>  <p>The valid values are 1-2147483647.</p>
    ///   - [`amazon_side_asn(Option<i64>)`](crate::output::AllocatePublicVirtualInterfaceOutput::amazon_side_asn): <p>The autonomous system number (ASN) for the Amazon side of the connection.</p>
    ///   - [`auth_key(Option<String>)`](crate::output::AllocatePublicVirtualInterfaceOutput::auth_key): <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
    ///   - [`amazon_address(Option<String>)`](crate::output::AllocatePublicVirtualInterfaceOutput::amazon_address): <p>The IP address assigned to the Amazon interface.</p>
    ///   - [`customer_address(Option<String>)`](crate::output::AllocatePublicVirtualInterfaceOutput::customer_address): <p>The IP address assigned to the customer interface.</p>
    ///   - [`address_family(Option<AddressFamily>)`](crate::output::AllocatePublicVirtualInterfaceOutput::address_family): <p>The address family for the BGP peer.</p>
    ///   - [`virtual_interface_state(Option<VirtualInterfaceState>)`](crate::output::AllocatePublicVirtualInterfaceOutput::virtual_interface_state): <p>The state of the virtual interface. The following are the possible values:</p>  <ul>   <li> <p> <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p> </li>   <li> <p> <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p> </li>   <li> <p> <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p> </li>   <li> <p> <code>available</code>: A virtual interface that is able to forward traffic.</p> </li>   <li> <p> <code>down</code>: A virtual interface that is BGP down.</p> </li>   <li> <p> <code>deleting</code>: A virtual interface is in this state immediately after calling <code>DeleteVirtualInterface</code> until it can no longer forward traffic.</p> </li>   <li> <p> <code>deleted</code>: A virtual interface that cannot forward traffic.</p> </li>   <li> <p> <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p> </li>   <li> <p> <code>unknown</code>: The state of the virtual interface is not available.</p> </li>  </ul>
    ///   - [`customer_router_config(Option<String>)`](crate::output::AllocatePublicVirtualInterfaceOutput::customer_router_config): <p>The customer router configuration.</p>
    ///   - [`mtu(Option<i32>)`](crate::output::AllocatePublicVirtualInterfaceOutput::mtu): <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
    ///   - [`jumbo_frame_capable(Option<bool>)`](crate::output::AllocatePublicVirtualInterfaceOutput::jumbo_frame_capable): <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    ///   - [`virtual_gateway_id(Option<String>)`](crate::output::AllocatePublicVirtualInterfaceOutput::virtual_gateway_id): <p>The ID of the virtual private gateway. Applies only to private virtual interfaces.</p>
    ///   - [`direct_connect_gateway_id(Option<String>)`](crate::output::AllocatePublicVirtualInterfaceOutput::direct_connect_gateway_id): <p>The ID of the Direct Connect gateway.</p>
    ///   - [`route_filter_prefixes(Option<Vec<RouteFilterPrefix>>)`](crate::output::AllocatePublicVirtualInterfaceOutput::route_filter_prefixes): <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
    ///   - [`bgp_peers(Option<Vec<BgpPeer>>)`](crate::output::AllocatePublicVirtualInterfaceOutput::bgp_peers): <p>The BGP peers configured on this virtual interface.</p>
    ///   - [`region(Option<String>)`](crate::output::AllocatePublicVirtualInterfaceOutput::region): <p>The Amazon Web Services Region where the virtual interface is located.</p>
    ///   - [`aws_device_v2(Option<String>)`](crate::output::AllocatePublicVirtualInterfaceOutput::aws_device_v2): <p>The Direct Connect endpoint that terminates the physical connection.</p>
    ///   - [`aws_logical_device_id(Option<String>)`](crate::output::AllocatePublicVirtualInterfaceOutput::aws_logical_device_id): <p>The Direct Connect endpoint that terminates the logical connection. This device might be different than the device that terminates the physical connection.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::AllocatePublicVirtualInterfaceOutput::tags): <p>The tags associated with the virtual interface.</p>
    ///   - [`site_link_enabled(Option<bool>)`](crate::output::AllocatePublicVirtualInterfaceOutput::site_link_enabled): <p>Indicates whether SiteLink is enabled.</p>
    /// - On failure, responds with [`SdkError<AllocatePublicVirtualInterfaceError>`](crate::error::AllocatePublicVirtualInterfaceError)
    pub fn allocate_public_virtual_interface(
        &self,
    ) -> fluent_builders::AllocatePublicVirtualInterface {
        fluent_builders::AllocatePublicVirtualInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AllocateTransitVirtualInterface`](crate::client::fluent_builders::AllocateTransitVirtualInterface) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connection_id(impl Into<String>)`](crate::client::fluent_builders::AllocateTransitVirtualInterface::connection_id) / [`set_connection_id(Option<String>)`](crate::client::fluent_builders::AllocateTransitVirtualInterface::set_connection_id): <p>The ID of the connection on which the transit virtual interface is provisioned.</p>
    ///   - [`owner_account(impl Into<String>)`](crate::client::fluent_builders::AllocateTransitVirtualInterface::owner_account) / [`set_owner_account(Option<String>)`](crate::client::fluent_builders::AllocateTransitVirtualInterface::set_owner_account): <p>The ID of the Amazon Web Services account that owns the transit virtual interface.</p>
    ///   - [`new_transit_virtual_interface_allocation(NewTransitVirtualInterfaceAllocation)`](crate::client::fluent_builders::AllocateTransitVirtualInterface::new_transit_virtual_interface_allocation) / [`set_new_transit_virtual_interface_allocation(Option<NewTransitVirtualInterfaceAllocation>)`](crate::client::fluent_builders::AllocateTransitVirtualInterface::set_new_transit_virtual_interface_allocation): <p>Information about the transit virtual interface.</p>
    /// - On success, responds with [`AllocateTransitVirtualInterfaceOutput`](crate::output::AllocateTransitVirtualInterfaceOutput) with field(s):
    ///   - [`virtual_interface(Option<VirtualInterface>)`](crate::output::AllocateTransitVirtualInterfaceOutput::virtual_interface): <p>Information about a virtual interface.</p>
    /// - On failure, responds with [`SdkError<AllocateTransitVirtualInterfaceError>`](crate::error::AllocateTransitVirtualInterfaceError)
    pub fn allocate_transit_virtual_interface(
        &self,
    ) -> fluent_builders::AllocateTransitVirtualInterface {
        fluent_builders::AllocateTransitVirtualInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateConnectionWithLag`](crate::client::fluent_builders::AssociateConnectionWithLag) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connection_id(impl Into<String>)`](crate::client::fluent_builders::AssociateConnectionWithLag::connection_id) / [`set_connection_id(Option<String>)`](crate::client::fluent_builders::AssociateConnectionWithLag::set_connection_id): <p>The ID of the connection.</p>
    ///   - [`lag_id(impl Into<String>)`](crate::client::fluent_builders::AssociateConnectionWithLag::lag_id) / [`set_lag_id(Option<String>)`](crate::client::fluent_builders::AssociateConnectionWithLag::set_lag_id): <p>The ID of the LAG with which to associate the connection.</p>
    /// - On success, responds with [`AssociateConnectionWithLagOutput`](crate::output::AssociateConnectionWithLagOutput) with field(s):
    ///   - [`owner_account(Option<String>)`](crate::output::AssociateConnectionWithLagOutput::owner_account): <p>The ID of the Amazon Web Services account that owns the connection.</p>
    ///   - [`connection_id(Option<String>)`](crate::output::AssociateConnectionWithLagOutput::connection_id): <p>The ID of the connection.</p>
    ///   - [`connection_name(Option<String>)`](crate::output::AssociateConnectionWithLagOutput::connection_name): <p>The name of the connection.</p>
    ///   - [`connection_state(Option<ConnectionState>)`](crate::output::AssociateConnectionWithLagOutput::connection_state): <p>The state of the connection. The following are the possible values:</p>  <ul>   <li> <p> <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p> </li>   <li> <p> <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p> </li>   <li> <p> <code>pending</code>: The connection has been approved and is being initialized.</p> </li>   <li> <p> <code>available</code>: The network link is up and the connection is ready for use.</p> </li>   <li> <p> <code>down</code>: The network link is down.</p> </li>   <li> <p> <code>deleting</code>: The connection is being deleted.</p> </li>   <li> <p> <code>deleted</code>: The connection has been deleted.</p> </li>   <li> <p> <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p> </li>   <li> <p> <code>unknown</code>: The state of the connection is not available.</p> </li>  </ul>
    ///   - [`region(Option<String>)`](crate::output::AssociateConnectionWithLagOutput::region): <p>The Amazon Web Services Region where the connection is located.</p>
    ///   - [`location(Option<String>)`](crate::output::AssociateConnectionWithLagOutput::location): <p>The location of the connection.</p>
    ///   - [`bandwidth(Option<String>)`](crate::output::AssociateConnectionWithLagOutput::bandwidth): <p>The bandwidth of the connection.</p>
    ///   - [`vlan(i32)`](crate::output::AssociateConnectionWithLagOutput::vlan): <p>The ID of the VLAN.</p>
    ///   - [`partner_name(Option<String>)`](crate::output::AssociateConnectionWithLagOutput::partner_name): <p>The name of the Direct Connect service provider associated with the connection.</p>
    ///   - [`loa_issue_time(Option<DateTime>)`](crate::output::AssociateConnectionWithLagOutput::loa_issue_time): <p>The time of the most recent call to <code>DescribeLoa</code> for this connection.</p>
    ///   - [`lag_id(Option<String>)`](crate::output::AssociateConnectionWithLagOutput::lag_id): <p>The ID of the LAG.</p>
    ///   - [`aws_device(Option<String>)`](crate::output::AssociateConnectionWithLagOutput::aws_device): <p>The Direct Connect endpoint on which the physical connection terminates.</p>
    ///   - [`jumbo_frame_capable(Option<bool>)`](crate::output::AssociateConnectionWithLagOutput::jumbo_frame_capable): <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    ///   - [`aws_device_v2(Option<String>)`](crate::output::AssociateConnectionWithLagOutput::aws_device_v2): <p>The Direct Connect endpoint that terminates the physical connection.</p>
    ///   - [`aws_logical_device_id(Option<String>)`](crate::output::AssociateConnectionWithLagOutput::aws_logical_device_id): <p>The Direct Connect endpoint that terminates the logical connection. This device might be different than the device that terminates the physical connection.</p>
    ///   - [`has_logical_redundancy(Option<HasLogicalRedundancy>)`](crate::output::AssociateConnectionWithLagOutput::has_logical_redundancy): <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::AssociateConnectionWithLagOutput::tags): <p>The tags associated with the connection.</p>
    ///   - [`provider_name(Option<String>)`](crate::output::AssociateConnectionWithLagOutput::provider_name): <p>The name of the service provider associated with the connection.</p>
    ///   - [`mac_sec_capable(Option<bool>)`](crate::output::AssociateConnectionWithLagOutput::mac_sec_capable): <p>Indicates whether the connection supports MAC Security (MACsec).</p>
    ///   - [`port_encryption_status(Option<String>)`](crate::output::AssociateConnectionWithLagOutput::port_encryption_status): <p>The MAC Security (MACsec) port link status of the connection.</p>  <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
    ///   - [`encryption_mode(Option<String>)`](crate::output::AssociateConnectionWithLagOutput::encryption_mode): <p>The MAC Security (MACsec) connection encryption mode.</p>  <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
    ///   - [`mac_sec_keys(Option<Vec<MacSecKey>>)`](crate::output::AssociateConnectionWithLagOutput::mac_sec_keys): <p>The MAC Security (MACsec) security keys associated with the connection.</p>
    /// - On failure, responds with [`SdkError<AssociateConnectionWithLagError>`](crate::error::AssociateConnectionWithLagError)
    pub fn associate_connection_with_lag(&self) -> fluent_builders::AssociateConnectionWithLag {
        fluent_builders::AssociateConnectionWithLag::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateHostedConnection`](crate::client::fluent_builders::AssociateHostedConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connection_id(impl Into<String>)`](crate::client::fluent_builders::AssociateHostedConnection::connection_id) / [`set_connection_id(Option<String>)`](crate::client::fluent_builders::AssociateHostedConnection::set_connection_id): <p>The ID of the hosted connection.</p>
    ///   - [`parent_connection_id(impl Into<String>)`](crate::client::fluent_builders::AssociateHostedConnection::parent_connection_id) / [`set_parent_connection_id(Option<String>)`](crate::client::fluent_builders::AssociateHostedConnection::set_parent_connection_id): <p>The ID of the interconnect or the LAG.</p>
    /// - On success, responds with [`AssociateHostedConnectionOutput`](crate::output::AssociateHostedConnectionOutput) with field(s):
    ///   - [`owner_account(Option<String>)`](crate::output::AssociateHostedConnectionOutput::owner_account): <p>The ID of the Amazon Web Services account that owns the connection.</p>
    ///   - [`connection_id(Option<String>)`](crate::output::AssociateHostedConnectionOutput::connection_id): <p>The ID of the connection.</p>
    ///   - [`connection_name(Option<String>)`](crate::output::AssociateHostedConnectionOutput::connection_name): <p>The name of the connection.</p>
    ///   - [`connection_state(Option<ConnectionState>)`](crate::output::AssociateHostedConnectionOutput::connection_state): <p>The state of the connection. The following are the possible values:</p>  <ul>   <li> <p> <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p> </li>   <li> <p> <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p> </li>   <li> <p> <code>pending</code>: The connection has been approved and is being initialized.</p> </li>   <li> <p> <code>available</code>: The network link is up and the connection is ready for use.</p> </li>   <li> <p> <code>down</code>: The network link is down.</p> </li>   <li> <p> <code>deleting</code>: The connection is being deleted.</p> </li>   <li> <p> <code>deleted</code>: The connection has been deleted.</p> </li>   <li> <p> <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p> </li>   <li> <p> <code>unknown</code>: The state of the connection is not available.</p> </li>  </ul>
    ///   - [`region(Option<String>)`](crate::output::AssociateHostedConnectionOutput::region): <p>The Amazon Web Services Region where the connection is located.</p>
    ///   - [`location(Option<String>)`](crate::output::AssociateHostedConnectionOutput::location): <p>The location of the connection.</p>
    ///   - [`bandwidth(Option<String>)`](crate::output::AssociateHostedConnectionOutput::bandwidth): <p>The bandwidth of the connection.</p>
    ///   - [`vlan(i32)`](crate::output::AssociateHostedConnectionOutput::vlan): <p>The ID of the VLAN.</p>
    ///   - [`partner_name(Option<String>)`](crate::output::AssociateHostedConnectionOutput::partner_name): <p>The name of the Direct Connect service provider associated with the connection.</p>
    ///   - [`loa_issue_time(Option<DateTime>)`](crate::output::AssociateHostedConnectionOutput::loa_issue_time): <p>The time of the most recent call to <code>DescribeLoa</code> for this connection.</p>
    ///   - [`lag_id(Option<String>)`](crate::output::AssociateHostedConnectionOutput::lag_id): <p>The ID of the LAG.</p>
    ///   - [`aws_device(Option<String>)`](crate::output::AssociateHostedConnectionOutput::aws_device): <p>The Direct Connect endpoint on which the physical connection terminates.</p>
    ///   - [`jumbo_frame_capable(Option<bool>)`](crate::output::AssociateHostedConnectionOutput::jumbo_frame_capable): <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    ///   - [`aws_device_v2(Option<String>)`](crate::output::AssociateHostedConnectionOutput::aws_device_v2): <p>The Direct Connect endpoint that terminates the physical connection.</p>
    ///   - [`aws_logical_device_id(Option<String>)`](crate::output::AssociateHostedConnectionOutput::aws_logical_device_id): <p>The Direct Connect endpoint that terminates the logical connection. This device might be different than the device that terminates the physical connection.</p>
    ///   - [`has_logical_redundancy(Option<HasLogicalRedundancy>)`](crate::output::AssociateHostedConnectionOutput::has_logical_redundancy): <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::AssociateHostedConnectionOutput::tags): <p>The tags associated with the connection.</p>
    ///   - [`provider_name(Option<String>)`](crate::output::AssociateHostedConnectionOutput::provider_name): <p>The name of the service provider associated with the connection.</p>
    ///   - [`mac_sec_capable(Option<bool>)`](crate::output::AssociateHostedConnectionOutput::mac_sec_capable): <p>Indicates whether the connection supports MAC Security (MACsec).</p>
    ///   - [`port_encryption_status(Option<String>)`](crate::output::AssociateHostedConnectionOutput::port_encryption_status): <p>The MAC Security (MACsec) port link status of the connection.</p>  <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
    ///   - [`encryption_mode(Option<String>)`](crate::output::AssociateHostedConnectionOutput::encryption_mode): <p>The MAC Security (MACsec) connection encryption mode.</p>  <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
    ///   - [`mac_sec_keys(Option<Vec<MacSecKey>>)`](crate::output::AssociateHostedConnectionOutput::mac_sec_keys): <p>The MAC Security (MACsec) security keys associated with the connection.</p>
    /// - On failure, responds with [`SdkError<AssociateHostedConnectionError>`](crate::error::AssociateHostedConnectionError)
    pub fn associate_hosted_connection(&self) -> fluent_builders::AssociateHostedConnection {
        fluent_builders::AssociateHostedConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateMacSecKey`](crate::client::fluent_builders::AssociateMacSecKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connection_id(impl Into<String>)`](crate::client::fluent_builders::AssociateMacSecKey::connection_id) / [`set_connection_id(Option<String>)`](crate::client::fluent_builders::AssociateMacSecKey::set_connection_id): <p>The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).</p>  <p>You can use <code>DescribeConnections</code> or <code>DescribeLags</code> to retrieve connection ID.</p>
    ///   - [`secret_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateMacSecKey::secret_arn) / [`set_secret_arn(Option<String>)`](crate::client::fluent_builders::AssociateMacSecKey::set_secret_arn): <p>The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key to associate with the dedicated connection.</p>  <p>You can use <code>DescribeConnections</code> or <code>DescribeLags</code> to retrieve the MAC Security (MACsec) secret key.</p>  <p>If you use this request parameter, you do not use the <code>ckn</code> and <code>cak</code> request parameters.</p>
    ///   - [`ckn(impl Into<String>)`](crate::client::fluent_builders::AssociateMacSecKey::ckn) / [`set_ckn(Option<String>)`](crate::client::fluent_builders::AssociateMacSecKey::set_ckn): <p>The MAC Security (MACsec) CKN to associate with the dedicated connection.</p>  <p>You can create the CKN/CAK pair using an industry standard tool.</p>  <p> The valid values are 64 hexadecimal characters (0-9, A-E).</p>  <p>If you use this request parameter, you must use the <code>cak</code> request parameter and not use the <code>secretARN</code> request parameter.</p>
    ///   - [`cak(impl Into<String>)`](crate::client::fluent_builders::AssociateMacSecKey::cak) / [`set_cak(Option<String>)`](crate::client::fluent_builders::AssociateMacSecKey::set_cak): <p>The MAC Security (MACsec) CAK to associate with the dedicated connection.</p>  <p>You can create the CKN/CAK pair using an industry standard tool.</p>  <p> The valid values are 64 hexadecimal characters (0-9, A-E).</p>  <p>If you use this request parameter, you must use the <code>ckn</code> request parameter and not use the <code>secretARN</code> request parameter.</p>
    /// - On success, responds with [`AssociateMacSecKeyOutput`](crate::output::AssociateMacSecKeyOutput) with field(s):
    ///   - [`connection_id(Option<String>)`](crate::output::AssociateMacSecKeyOutput::connection_id): <p>The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).</p>
    ///   - [`mac_sec_keys(Option<Vec<MacSecKey>>)`](crate::output::AssociateMacSecKeyOutput::mac_sec_keys): <p>The MAC Security (MACsec) security keys associated with the dedicated connection.</p>
    /// - On failure, responds with [`SdkError<AssociateMacSecKeyError>`](crate::error::AssociateMacSecKeyError)
    pub fn associate_mac_sec_key(&self) -> fluent_builders::AssociateMacSecKey {
        fluent_builders::AssociateMacSecKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateVirtualInterface`](crate::client::fluent_builders::AssociateVirtualInterface) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`virtual_interface_id(impl Into<String>)`](crate::client::fluent_builders::AssociateVirtualInterface::virtual_interface_id) / [`set_virtual_interface_id(Option<String>)`](crate::client::fluent_builders::AssociateVirtualInterface::set_virtual_interface_id): <p>The ID of the virtual interface.</p>
    ///   - [`connection_id(impl Into<String>)`](crate::client::fluent_builders::AssociateVirtualInterface::connection_id) / [`set_connection_id(Option<String>)`](crate::client::fluent_builders::AssociateVirtualInterface::set_connection_id): <p>The ID of the LAG or connection.</p>
    /// - On success, responds with [`AssociateVirtualInterfaceOutput`](crate::output::AssociateVirtualInterfaceOutput) with field(s):
    ///   - [`owner_account(Option<String>)`](crate::output::AssociateVirtualInterfaceOutput::owner_account): <p>The ID of the Amazon Web Services account that owns the virtual interface.</p>
    ///   - [`virtual_interface_id(Option<String>)`](crate::output::AssociateVirtualInterfaceOutput::virtual_interface_id): <p>The ID of the virtual interface.</p>
    ///   - [`location(Option<String>)`](crate::output::AssociateVirtualInterfaceOutput::location): <p>The location of the connection.</p>
    ///   - [`connection_id(Option<String>)`](crate::output::AssociateVirtualInterfaceOutput::connection_id): <p>The ID of the connection.</p>
    ///   - [`virtual_interface_type(Option<String>)`](crate::output::AssociateVirtualInterfaceOutput::virtual_interface_type): <p>The type of virtual interface. The possible values are <code>private</code> and <code>public</code>.</p>
    ///   - [`virtual_interface_name(Option<String>)`](crate::output::AssociateVirtualInterfaceOutput::virtual_interface_name): <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
    ///   - [`vlan(i32)`](crate::output::AssociateVirtualInterfaceOutput::vlan): <p>The ID of the VLAN.</p>
    ///   - [`asn(i32)`](crate::output::AssociateVirtualInterfaceOutput::asn): <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>  <p>The valid values are 1-2147483647.</p>
    ///   - [`amazon_side_asn(Option<i64>)`](crate::output::AssociateVirtualInterfaceOutput::amazon_side_asn): <p>The autonomous system number (ASN) for the Amazon side of the connection.</p>
    ///   - [`auth_key(Option<String>)`](crate::output::AssociateVirtualInterfaceOutput::auth_key): <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
    ///   - [`amazon_address(Option<String>)`](crate::output::AssociateVirtualInterfaceOutput::amazon_address): <p>The IP address assigned to the Amazon interface.</p>
    ///   - [`customer_address(Option<String>)`](crate::output::AssociateVirtualInterfaceOutput::customer_address): <p>The IP address assigned to the customer interface.</p>
    ///   - [`address_family(Option<AddressFamily>)`](crate::output::AssociateVirtualInterfaceOutput::address_family): <p>The address family for the BGP peer.</p>
    ///   - [`virtual_interface_state(Option<VirtualInterfaceState>)`](crate::output::AssociateVirtualInterfaceOutput::virtual_interface_state): <p>The state of the virtual interface. The following are the possible values:</p>  <ul>   <li> <p> <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p> </li>   <li> <p> <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p> </li>   <li> <p> <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p> </li>   <li> <p> <code>available</code>: A virtual interface that is able to forward traffic.</p> </li>   <li> <p> <code>down</code>: A virtual interface that is BGP down.</p> </li>   <li> <p> <code>deleting</code>: A virtual interface is in this state immediately after calling <code>DeleteVirtualInterface</code> until it can no longer forward traffic.</p> </li>   <li> <p> <code>deleted</code>: A virtual interface that cannot forward traffic.</p> </li>   <li> <p> <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p> </li>   <li> <p> <code>unknown</code>: The state of the virtual interface is not available.</p> </li>  </ul>
    ///   - [`customer_router_config(Option<String>)`](crate::output::AssociateVirtualInterfaceOutput::customer_router_config): <p>The customer router configuration.</p>
    ///   - [`mtu(Option<i32>)`](crate::output::AssociateVirtualInterfaceOutput::mtu): <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
    ///   - [`jumbo_frame_capable(Option<bool>)`](crate::output::AssociateVirtualInterfaceOutput::jumbo_frame_capable): <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    ///   - [`virtual_gateway_id(Option<String>)`](crate::output::AssociateVirtualInterfaceOutput::virtual_gateway_id): <p>The ID of the virtual private gateway. Applies only to private virtual interfaces.</p>
    ///   - [`direct_connect_gateway_id(Option<String>)`](crate::output::AssociateVirtualInterfaceOutput::direct_connect_gateway_id): <p>The ID of the Direct Connect gateway.</p>
    ///   - [`route_filter_prefixes(Option<Vec<RouteFilterPrefix>>)`](crate::output::AssociateVirtualInterfaceOutput::route_filter_prefixes): <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
    ///   - [`bgp_peers(Option<Vec<BgpPeer>>)`](crate::output::AssociateVirtualInterfaceOutput::bgp_peers): <p>The BGP peers configured on this virtual interface.</p>
    ///   - [`region(Option<String>)`](crate::output::AssociateVirtualInterfaceOutput::region): <p>The Amazon Web Services Region where the virtual interface is located.</p>
    ///   - [`aws_device_v2(Option<String>)`](crate::output::AssociateVirtualInterfaceOutput::aws_device_v2): <p>The Direct Connect endpoint that terminates the physical connection.</p>
    ///   - [`aws_logical_device_id(Option<String>)`](crate::output::AssociateVirtualInterfaceOutput::aws_logical_device_id): <p>The Direct Connect endpoint that terminates the logical connection. This device might be different than the device that terminates the physical connection.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::AssociateVirtualInterfaceOutput::tags): <p>The tags associated with the virtual interface.</p>
    ///   - [`site_link_enabled(Option<bool>)`](crate::output::AssociateVirtualInterfaceOutput::site_link_enabled): <p>Indicates whether SiteLink is enabled.</p>
    /// - On failure, responds with [`SdkError<AssociateVirtualInterfaceError>`](crate::error::AssociateVirtualInterfaceError)
    pub fn associate_virtual_interface(&self) -> fluent_builders::AssociateVirtualInterface {
        fluent_builders::AssociateVirtualInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ConfirmConnection`](crate::client::fluent_builders::ConfirmConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connection_id(impl Into<String>)`](crate::client::fluent_builders::ConfirmConnection::connection_id) / [`set_connection_id(Option<String>)`](crate::client::fluent_builders::ConfirmConnection::set_connection_id): <p>The ID of the hosted connection.</p>
    /// - On success, responds with [`ConfirmConnectionOutput`](crate::output::ConfirmConnectionOutput) with field(s):
    ///   - [`connection_state(Option<ConnectionState>)`](crate::output::ConfirmConnectionOutput::connection_state): <p>The state of the connection. The following are the possible values:</p>  <ul>   <li> <p> <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p> </li>   <li> <p> <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p> </li>   <li> <p> <code>pending</code>: The connection has been approved and is being initialized.</p> </li>   <li> <p> <code>available</code>: The network link is up and the connection is ready for use.</p> </li>   <li> <p> <code>down</code>: The network link is down.</p> </li>   <li> <p> <code>deleting</code>: The connection is being deleted.</p> </li>   <li> <p> <code>deleted</code>: The connection has been deleted.</p> </li>   <li> <p> <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p> </li>   <li> <p> <code>unknown</code>: The state of the connection is not available.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<ConfirmConnectionError>`](crate::error::ConfirmConnectionError)
    pub fn confirm_connection(&self) -> fluent_builders::ConfirmConnection {
        fluent_builders::ConfirmConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ConfirmCustomerAgreement`](crate::client::fluent_builders::ConfirmCustomerAgreement) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`agreement_name(impl Into<String>)`](crate::client::fluent_builders::ConfirmCustomerAgreement::agreement_name) / [`set_agreement_name(Option<String>)`](crate::client::fluent_builders::ConfirmCustomerAgreement::set_agreement_name): <p> The name of the customer agreement. </p>
    /// - On success, responds with [`ConfirmCustomerAgreementOutput`](crate::output::ConfirmCustomerAgreementOutput) with field(s):
    ///   - [`status(Option<String>)`](crate::output::ConfirmCustomerAgreementOutput::status): <p> The status of the customer agreement when the connection was created. This will be either <code>signed</code> or <code>unsigned</code>. </p>
    /// - On failure, responds with [`SdkError<ConfirmCustomerAgreementError>`](crate::error::ConfirmCustomerAgreementError)
    pub fn confirm_customer_agreement(&self) -> fluent_builders::ConfirmCustomerAgreement {
        fluent_builders::ConfirmCustomerAgreement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ConfirmPrivateVirtualInterface`](crate::client::fluent_builders::ConfirmPrivateVirtualInterface) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`virtual_interface_id(impl Into<String>)`](crate::client::fluent_builders::ConfirmPrivateVirtualInterface::virtual_interface_id) / [`set_virtual_interface_id(Option<String>)`](crate::client::fluent_builders::ConfirmPrivateVirtualInterface::set_virtual_interface_id): <p>The ID of the virtual interface.</p>
    ///   - [`virtual_gateway_id(impl Into<String>)`](crate::client::fluent_builders::ConfirmPrivateVirtualInterface::virtual_gateway_id) / [`set_virtual_gateway_id(Option<String>)`](crate::client::fluent_builders::ConfirmPrivateVirtualInterface::set_virtual_gateway_id): <p>The ID of the virtual private gateway.</p>
    ///   - [`direct_connect_gateway_id(impl Into<String>)`](crate::client::fluent_builders::ConfirmPrivateVirtualInterface::direct_connect_gateway_id) / [`set_direct_connect_gateway_id(Option<String>)`](crate::client::fluent_builders::ConfirmPrivateVirtualInterface::set_direct_connect_gateway_id): <p>The ID of the Direct Connect gateway.</p>
    /// - On success, responds with [`ConfirmPrivateVirtualInterfaceOutput`](crate::output::ConfirmPrivateVirtualInterfaceOutput) with field(s):
    ///   - [`virtual_interface_state(Option<VirtualInterfaceState>)`](crate::output::ConfirmPrivateVirtualInterfaceOutput::virtual_interface_state): <p>The state of the virtual interface. The following are the possible values:</p>  <ul>   <li> <p> <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p> </li>   <li> <p> <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p> </li>   <li> <p> <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p> </li>   <li> <p> <code>available</code>: A virtual interface that is able to forward traffic.</p> </li>   <li> <p> <code>down</code>: A virtual interface that is BGP down.</p> </li>   <li> <p> <code>deleting</code>: A virtual interface is in this state immediately after calling <code>DeleteVirtualInterface</code> until it can no longer forward traffic.</p> </li>   <li> <p> <code>deleted</code>: A virtual interface that cannot forward traffic.</p> </li>   <li> <p> <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p> </li>   <li> <p> <code>unknown</code>: The state of the virtual interface is not available.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<ConfirmPrivateVirtualInterfaceError>`](crate::error::ConfirmPrivateVirtualInterfaceError)
    pub fn confirm_private_virtual_interface(
        &self,
    ) -> fluent_builders::ConfirmPrivateVirtualInterface {
        fluent_builders::ConfirmPrivateVirtualInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ConfirmPublicVirtualInterface`](crate::client::fluent_builders::ConfirmPublicVirtualInterface) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`virtual_interface_id(impl Into<String>)`](crate::client::fluent_builders::ConfirmPublicVirtualInterface::virtual_interface_id) / [`set_virtual_interface_id(Option<String>)`](crate::client::fluent_builders::ConfirmPublicVirtualInterface::set_virtual_interface_id): <p>The ID of the virtual interface.</p>
    /// - On success, responds with [`ConfirmPublicVirtualInterfaceOutput`](crate::output::ConfirmPublicVirtualInterfaceOutput) with field(s):
    ///   - [`virtual_interface_state(Option<VirtualInterfaceState>)`](crate::output::ConfirmPublicVirtualInterfaceOutput::virtual_interface_state): <p>The state of the virtual interface. The following are the possible values:</p>  <ul>   <li> <p> <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p> </li>   <li> <p> <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p> </li>   <li> <p> <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p> </li>   <li> <p> <code>available</code>: A virtual interface that is able to forward traffic.</p> </li>   <li> <p> <code>down</code>: A virtual interface that is BGP down.</p> </li>   <li> <p> <code>deleting</code>: A virtual interface is in this state immediately after calling <code>DeleteVirtualInterface</code> until it can no longer forward traffic.</p> </li>   <li> <p> <code>deleted</code>: A virtual interface that cannot forward traffic.</p> </li>   <li> <p> <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p> </li>   <li> <p> <code>unknown</code>: The state of the virtual interface is not available.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<ConfirmPublicVirtualInterfaceError>`](crate::error::ConfirmPublicVirtualInterfaceError)
    pub fn confirm_public_virtual_interface(
        &self,
    ) -> fluent_builders::ConfirmPublicVirtualInterface {
        fluent_builders::ConfirmPublicVirtualInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ConfirmTransitVirtualInterface`](crate::client::fluent_builders::ConfirmTransitVirtualInterface) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`virtual_interface_id(impl Into<String>)`](crate::client::fluent_builders::ConfirmTransitVirtualInterface::virtual_interface_id) / [`set_virtual_interface_id(Option<String>)`](crate::client::fluent_builders::ConfirmTransitVirtualInterface::set_virtual_interface_id): <p>The ID of the virtual interface.</p>
    ///   - [`direct_connect_gateway_id(impl Into<String>)`](crate::client::fluent_builders::ConfirmTransitVirtualInterface::direct_connect_gateway_id) / [`set_direct_connect_gateway_id(Option<String>)`](crate::client::fluent_builders::ConfirmTransitVirtualInterface::set_direct_connect_gateway_id): <p>The ID of the Direct Connect gateway.</p>
    /// - On success, responds with [`ConfirmTransitVirtualInterfaceOutput`](crate::output::ConfirmTransitVirtualInterfaceOutput) with field(s):
    ///   - [`virtual_interface_state(Option<VirtualInterfaceState>)`](crate::output::ConfirmTransitVirtualInterfaceOutput::virtual_interface_state): <p>The state of the virtual interface. The following are the possible values:</p>  <ul>   <li> <p> <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p> </li>   <li> <p> <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p> </li>   <li> <p> <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p> </li>   <li> <p> <code>available</code>: A virtual interface that is able to forward traffic.</p> </li>   <li> <p> <code>down</code>: A virtual interface that is BGP down.</p> </li>   <li> <p> <code>deleting</code>: A virtual interface is in this state immediately after calling <code>DeleteVirtualInterface</code> until it can no longer forward traffic.</p> </li>   <li> <p> <code>deleted</code>: A virtual interface that cannot forward traffic.</p> </li>   <li> <p> <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p> </li>   <li> <p> <code>unknown</code>: The state of the virtual interface is not available.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<ConfirmTransitVirtualInterfaceError>`](crate::error::ConfirmTransitVirtualInterfaceError)
    pub fn confirm_transit_virtual_interface(
        &self,
    ) -> fluent_builders::ConfirmTransitVirtualInterface {
        fluent_builders::ConfirmTransitVirtualInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateBGPPeer`](crate::client::fluent_builders::CreateBGPPeer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`virtual_interface_id(impl Into<String>)`](crate::client::fluent_builders::CreateBGPPeer::virtual_interface_id) / [`set_virtual_interface_id(Option<String>)`](crate::client::fluent_builders::CreateBGPPeer::set_virtual_interface_id): <p>The ID of the virtual interface.</p>
    ///   - [`new_bgp_peer(NewBgpPeer)`](crate::client::fluent_builders::CreateBGPPeer::new_bgp_peer) / [`set_new_bgp_peer(Option<NewBgpPeer>)`](crate::client::fluent_builders::CreateBGPPeer::set_new_bgp_peer): <p>Information about the BGP peer.</p>
    /// - On success, responds with [`CreateBgpPeerOutput`](crate::output::CreateBgpPeerOutput) with field(s):
    ///   - [`virtual_interface(Option<VirtualInterface>)`](crate::output::CreateBgpPeerOutput::virtual_interface): <p>The virtual interface.</p>
    /// - On failure, responds with [`SdkError<CreateBGPPeerError>`](crate::error::CreateBGPPeerError)
    pub fn create_bgp_peer(&self) -> fluent_builders::CreateBGPPeer {
        fluent_builders::CreateBGPPeer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateConnection`](crate::client::fluent_builders::CreateConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`location(impl Into<String>)`](crate::client::fluent_builders::CreateConnection::location) / [`set_location(Option<String>)`](crate::client::fluent_builders::CreateConnection::set_location): <p>The location of the connection.</p>
    ///   - [`bandwidth(impl Into<String>)`](crate::client::fluent_builders::CreateConnection::bandwidth) / [`set_bandwidth(Option<String>)`](crate::client::fluent_builders::CreateConnection::set_bandwidth): <p>The bandwidth of the connection.</p>
    ///   - [`connection_name(impl Into<String>)`](crate::client::fluent_builders::CreateConnection::connection_name) / [`set_connection_name(Option<String>)`](crate::client::fluent_builders::CreateConnection::set_connection_name): <p>The name of the connection.</p>
    ///   - [`lag_id(impl Into<String>)`](crate::client::fluent_builders::CreateConnection::lag_id) / [`set_lag_id(Option<String>)`](crate::client::fluent_builders::CreateConnection::set_lag_id): <p>The ID of the LAG.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateConnection::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateConnection::set_tags): <p>The tags to associate with the lag.</p>
    ///   - [`provider_name(impl Into<String>)`](crate::client::fluent_builders::CreateConnection::provider_name) / [`set_provider_name(Option<String>)`](crate::client::fluent_builders::CreateConnection::set_provider_name): <p>The name of the service provider associated with the requested connection.</p>
    ///   - [`request_mac_sec(bool)`](crate::client::fluent_builders::CreateConnection::request_mac_sec) / [`set_request_mac_sec(Option<bool>)`](crate::client::fluent_builders::CreateConnection::set_request_mac_sec): <p>Indicates whether you want the connection to support MAC Security (MACsec).</p>  <p>MAC Security (MACsec) is only available on dedicated connections. For information about MAC Security (MACsec) prerequisties, see <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites">MACsec prerequisties</a> in the <i>Direct Connect User Guide</i>.</p>
    /// - On success, responds with [`CreateConnectionOutput`](crate::output::CreateConnectionOutput) with field(s):
    ///   - [`owner_account(Option<String>)`](crate::output::CreateConnectionOutput::owner_account): <p>The ID of the Amazon Web Services account that owns the connection.</p>
    ///   - [`connection_id(Option<String>)`](crate::output::CreateConnectionOutput::connection_id): <p>The ID of the connection.</p>
    ///   - [`connection_name(Option<String>)`](crate::output::CreateConnectionOutput::connection_name): <p>The name of the connection.</p>
    ///   - [`connection_state(Option<ConnectionState>)`](crate::output::CreateConnectionOutput::connection_state): <p>The state of the connection. The following are the possible values:</p>  <ul>   <li> <p> <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p> </li>   <li> <p> <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p> </li>   <li> <p> <code>pending</code>: The connection has been approved and is being initialized.</p> </li>   <li> <p> <code>available</code>: The network link is up and the connection is ready for use.</p> </li>   <li> <p> <code>down</code>: The network link is down.</p> </li>   <li> <p> <code>deleting</code>: The connection is being deleted.</p> </li>   <li> <p> <code>deleted</code>: The connection has been deleted.</p> </li>   <li> <p> <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p> </li>   <li> <p> <code>unknown</code>: The state of the connection is not available.</p> </li>  </ul>
    ///   - [`region(Option<String>)`](crate::output::CreateConnectionOutput::region): <p>The Amazon Web Services Region where the connection is located.</p>
    ///   - [`location(Option<String>)`](crate::output::CreateConnectionOutput::location): <p>The location of the connection.</p>
    ///   - [`bandwidth(Option<String>)`](crate::output::CreateConnectionOutput::bandwidth): <p>The bandwidth of the connection.</p>
    ///   - [`vlan(i32)`](crate::output::CreateConnectionOutput::vlan): <p>The ID of the VLAN.</p>
    ///   - [`partner_name(Option<String>)`](crate::output::CreateConnectionOutput::partner_name): <p>The name of the Direct Connect service provider associated with the connection.</p>
    ///   - [`loa_issue_time(Option<DateTime>)`](crate::output::CreateConnectionOutput::loa_issue_time): <p>The time of the most recent call to <code>DescribeLoa</code> for this connection.</p>
    ///   - [`lag_id(Option<String>)`](crate::output::CreateConnectionOutput::lag_id): <p>The ID of the LAG.</p>
    ///   - [`aws_device(Option<String>)`](crate::output::CreateConnectionOutput::aws_device): <p>The Direct Connect endpoint on which the physical connection terminates.</p>
    ///   - [`jumbo_frame_capable(Option<bool>)`](crate::output::CreateConnectionOutput::jumbo_frame_capable): <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    ///   - [`aws_device_v2(Option<String>)`](crate::output::CreateConnectionOutput::aws_device_v2): <p>The Direct Connect endpoint that terminates the physical connection.</p>
    ///   - [`aws_logical_device_id(Option<String>)`](crate::output::CreateConnectionOutput::aws_logical_device_id): <p>The Direct Connect endpoint that terminates the logical connection. This device might be different than the device that terminates the physical connection.</p>
    ///   - [`has_logical_redundancy(Option<HasLogicalRedundancy>)`](crate::output::CreateConnectionOutput::has_logical_redundancy): <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::CreateConnectionOutput::tags): <p>The tags associated with the connection.</p>
    ///   - [`provider_name(Option<String>)`](crate::output::CreateConnectionOutput::provider_name): <p>The name of the service provider associated with the connection.</p>
    ///   - [`mac_sec_capable(Option<bool>)`](crate::output::CreateConnectionOutput::mac_sec_capable): <p>Indicates whether the connection supports MAC Security (MACsec).</p>
    ///   - [`port_encryption_status(Option<String>)`](crate::output::CreateConnectionOutput::port_encryption_status): <p>The MAC Security (MACsec) port link status of the connection.</p>  <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
    ///   - [`encryption_mode(Option<String>)`](crate::output::CreateConnectionOutput::encryption_mode): <p>The MAC Security (MACsec) connection encryption mode.</p>  <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
    ///   - [`mac_sec_keys(Option<Vec<MacSecKey>>)`](crate::output::CreateConnectionOutput::mac_sec_keys): <p>The MAC Security (MACsec) security keys associated with the connection.</p>
    /// - On failure, responds with [`SdkError<CreateConnectionError>`](crate::error::CreateConnectionError)
    pub fn create_connection(&self) -> fluent_builders::CreateConnection {
        fluent_builders::CreateConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDirectConnectGateway`](crate::client::fluent_builders::CreateDirectConnectGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`direct_connect_gateway_name(impl Into<String>)`](crate::client::fluent_builders::CreateDirectConnectGateway::direct_connect_gateway_name) / [`set_direct_connect_gateway_name(Option<String>)`](crate::client::fluent_builders::CreateDirectConnectGateway::set_direct_connect_gateway_name): <p>The name of the Direct Connect gateway.</p>
    ///   - [`amazon_side_asn(i64)`](crate::client::fluent_builders::CreateDirectConnectGateway::amazon_side_asn) / [`set_amazon_side_asn(Option<i64>)`](crate::client::fluent_builders::CreateDirectConnectGateway::set_amazon_side_asn): <p>The autonomous system number (ASN) for Border Gateway Protocol (BGP) to be configured on the Amazon side of the connection. The ASN must be in the private range of 64,512 to 65,534 or 4,200,000,000 to 4,294,967,294. The default is 64512.</p>
    /// - On success, responds with [`CreateDirectConnectGatewayOutput`](crate::output::CreateDirectConnectGatewayOutput) with field(s):
    ///   - [`direct_connect_gateway(Option<DirectConnectGateway>)`](crate::output::CreateDirectConnectGatewayOutput::direct_connect_gateway): <p>The Direct Connect gateway.</p>
    /// - On failure, responds with [`SdkError<CreateDirectConnectGatewayError>`](crate::error::CreateDirectConnectGatewayError)
    pub fn create_direct_connect_gateway(&self) -> fluent_builders::CreateDirectConnectGateway {
        fluent_builders::CreateDirectConnectGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDirectConnectGatewayAssociation`](crate::client::fluent_builders::CreateDirectConnectGatewayAssociation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`direct_connect_gateway_id(impl Into<String>)`](crate::client::fluent_builders::CreateDirectConnectGatewayAssociation::direct_connect_gateway_id) / [`set_direct_connect_gateway_id(Option<String>)`](crate::client::fluent_builders::CreateDirectConnectGatewayAssociation::set_direct_connect_gateway_id): <p>The ID of the Direct Connect gateway.</p>
    ///   - [`gateway_id(impl Into<String>)`](crate::client::fluent_builders::CreateDirectConnectGatewayAssociation::gateway_id) / [`set_gateway_id(Option<String>)`](crate::client::fluent_builders::CreateDirectConnectGatewayAssociation::set_gateway_id): <p>The ID of the virtual private gateway or transit gateway.</p>
    ///   - [`add_allowed_prefixes_to_direct_connect_gateway(Vec<RouteFilterPrefix>)`](crate::client::fluent_builders::CreateDirectConnectGatewayAssociation::add_allowed_prefixes_to_direct_connect_gateway) / [`set_add_allowed_prefixes_to_direct_connect_gateway(Option<Vec<RouteFilterPrefix>>)`](crate::client::fluent_builders::CreateDirectConnectGatewayAssociation::set_add_allowed_prefixes_to_direct_connect_gateway): <p>The Amazon VPC prefixes to advertise to the Direct Connect gateway</p>  <p>This parameter is required when you create an association to a transit gateway.</p>  <p>For information about how to set the prefixes, see <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes">Allowed Prefixes</a> in the <i>Direct Connect User Guide</i>.</p>
    ///   - [`virtual_gateway_id(impl Into<String>)`](crate::client::fluent_builders::CreateDirectConnectGatewayAssociation::virtual_gateway_id) / [`set_virtual_gateway_id(Option<String>)`](crate::client::fluent_builders::CreateDirectConnectGatewayAssociation::set_virtual_gateway_id): <p>The ID of the virtual private gateway.</p>
    /// - On success, responds with [`CreateDirectConnectGatewayAssociationOutput`](crate::output::CreateDirectConnectGatewayAssociationOutput) with field(s):
    ///   - [`direct_connect_gateway_association(Option<DirectConnectGatewayAssociation>)`](crate::output::CreateDirectConnectGatewayAssociationOutput::direct_connect_gateway_association): <p>The association to be created.</p>
    /// - On failure, responds with [`SdkError<CreateDirectConnectGatewayAssociationError>`](crate::error::CreateDirectConnectGatewayAssociationError)
    pub fn create_direct_connect_gateway_association(
        &self,
    ) -> fluent_builders::CreateDirectConnectGatewayAssociation {
        fluent_builders::CreateDirectConnectGatewayAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDirectConnectGatewayAssociationProposal`](crate::client::fluent_builders::CreateDirectConnectGatewayAssociationProposal) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`direct_connect_gateway_id(impl Into<String>)`](crate::client::fluent_builders::CreateDirectConnectGatewayAssociationProposal::direct_connect_gateway_id) / [`set_direct_connect_gateway_id(Option<String>)`](crate::client::fluent_builders::CreateDirectConnectGatewayAssociationProposal::set_direct_connect_gateway_id): <p>The ID of the Direct Connect gateway.</p>
    ///   - [`direct_connect_gateway_owner_account(impl Into<String>)`](crate::client::fluent_builders::CreateDirectConnectGatewayAssociationProposal::direct_connect_gateway_owner_account) / [`set_direct_connect_gateway_owner_account(Option<String>)`](crate::client::fluent_builders::CreateDirectConnectGatewayAssociationProposal::set_direct_connect_gateway_owner_account): <p>The ID of the Amazon Web Services account that owns the Direct Connect gateway.</p>
    ///   - [`gateway_id(impl Into<String>)`](crate::client::fluent_builders::CreateDirectConnectGatewayAssociationProposal::gateway_id) / [`set_gateway_id(Option<String>)`](crate::client::fluent_builders::CreateDirectConnectGatewayAssociationProposal::set_gateway_id): <p>The ID of the virtual private gateway or transit gateway.</p>
    ///   - [`add_allowed_prefixes_to_direct_connect_gateway(Vec<RouteFilterPrefix>)`](crate::client::fluent_builders::CreateDirectConnectGatewayAssociationProposal::add_allowed_prefixes_to_direct_connect_gateway) / [`set_add_allowed_prefixes_to_direct_connect_gateway(Option<Vec<RouteFilterPrefix>>)`](crate::client::fluent_builders::CreateDirectConnectGatewayAssociationProposal::set_add_allowed_prefixes_to_direct_connect_gateway): <p>The Amazon VPC prefixes to advertise to the Direct Connect gateway.</p>
    ///   - [`remove_allowed_prefixes_to_direct_connect_gateway(Vec<RouteFilterPrefix>)`](crate::client::fluent_builders::CreateDirectConnectGatewayAssociationProposal::remove_allowed_prefixes_to_direct_connect_gateway) / [`set_remove_allowed_prefixes_to_direct_connect_gateway(Option<Vec<RouteFilterPrefix>>)`](crate::client::fluent_builders::CreateDirectConnectGatewayAssociationProposal::set_remove_allowed_prefixes_to_direct_connect_gateway): <p>The Amazon VPC prefixes to no longer advertise to the Direct Connect gateway.</p>
    /// - On success, responds with [`CreateDirectConnectGatewayAssociationProposalOutput`](crate::output::CreateDirectConnectGatewayAssociationProposalOutput) with field(s):
    ///   - [`direct_connect_gateway_association_proposal(Option<DirectConnectGatewayAssociationProposal>)`](crate::output::CreateDirectConnectGatewayAssociationProposalOutput::direct_connect_gateway_association_proposal): <p>Information about the Direct Connect gateway proposal.</p>
    /// - On failure, responds with [`SdkError<CreateDirectConnectGatewayAssociationProposalError>`](crate::error::CreateDirectConnectGatewayAssociationProposalError)
    pub fn create_direct_connect_gateway_association_proposal(
        &self,
    ) -> fluent_builders::CreateDirectConnectGatewayAssociationProposal {
        fluent_builders::CreateDirectConnectGatewayAssociationProposal::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateInterconnect`](crate::client::fluent_builders::CreateInterconnect) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`interconnect_name(impl Into<String>)`](crate::client::fluent_builders::CreateInterconnect::interconnect_name) / [`set_interconnect_name(Option<String>)`](crate::client::fluent_builders::CreateInterconnect::set_interconnect_name): <p>The name of the interconnect.</p>
    ///   - [`bandwidth(impl Into<String>)`](crate::client::fluent_builders::CreateInterconnect::bandwidth) / [`set_bandwidth(Option<String>)`](crate::client::fluent_builders::CreateInterconnect::set_bandwidth): <p>The port bandwidth, in Gbps. The possible values are 1 and 10.</p>
    ///   - [`location(impl Into<String>)`](crate::client::fluent_builders::CreateInterconnect::location) / [`set_location(Option<String>)`](crate::client::fluent_builders::CreateInterconnect::set_location): <p>The location of the interconnect.</p>
    ///   - [`lag_id(impl Into<String>)`](crate::client::fluent_builders::CreateInterconnect::lag_id) / [`set_lag_id(Option<String>)`](crate::client::fluent_builders::CreateInterconnect::set_lag_id): <p>The ID of the LAG.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateInterconnect::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateInterconnect::set_tags): <p>The tags to associate with the interconnect.</p>
    ///   - [`provider_name(impl Into<String>)`](crate::client::fluent_builders::CreateInterconnect::provider_name) / [`set_provider_name(Option<String>)`](crate::client::fluent_builders::CreateInterconnect::set_provider_name): <p>The name of the service provider associated with the interconnect.</p>
    /// - On success, responds with [`CreateInterconnectOutput`](crate::output::CreateInterconnectOutput) with field(s):
    ///   - [`interconnect_id(Option<String>)`](crate::output::CreateInterconnectOutput::interconnect_id): <p>The ID of the interconnect.</p>
    ///   - [`interconnect_name(Option<String>)`](crate::output::CreateInterconnectOutput::interconnect_name): <p>The name of the interconnect.</p>
    ///   - [`interconnect_state(Option<InterconnectState>)`](crate::output::CreateInterconnectOutput::interconnect_state): <p>The state of the interconnect. The following are the possible values:</p>  <ul>   <li> <p> <code>requested</code>: The initial state of an interconnect. The interconnect stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p> </li>   <li> <p> <code>pending</code>: The interconnect is approved, and is being initialized.</p> </li>   <li> <p> <code>available</code>: The network link is up, and the interconnect is ready for use.</p> </li>   <li> <p> <code>down</code>: The network link is down.</p> </li>   <li> <p> <code>deleting</code>: The interconnect is being deleted.</p> </li>   <li> <p> <code>deleted</code>: The interconnect is deleted.</p> </li>   <li> <p> <code>unknown</code>: The state of the interconnect is not available.</p> </li>  </ul>
    ///   - [`region(Option<String>)`](crate::output::CreateInterconnectOutput::region): <p>The Amazon Web Services Region where the connection is located.</p>
    ///   - [`location(Option<String>)`](crate::output::CreateInterconnectOutput::location): <p>The location of the connection.</p>
    ///   - [`bandwidth(Option<String>)`](crate::output::CreateInterconnectOutput::bandwidth): <p>The bandwidth of the connection.</p>
    ///   - [`loa_issue_time(Option<DateTime>)`](crate::output::CreateInterconnectOutput::loa_issue_time): <p>The time of the most recent call to <code>DescribeLoa</code> for this connection.</p>
    ///   - [`lag_id(Option<String>)`](crate::output::CreateInterconnectOutput::lag_id): <p>The ID of the LAG.</p>
    ///   - [`aws_device(Option<String>)`](crate::output::CreateInterconnectOutput::aws_device): <p>The Direct Connect endpoint on which the physical connection terminates.</p>
    ///   - [`jumbo_frame_capable(Option<bool>)`](crate::output::CreateInterconnectOutput::jumbo_frame_capable): <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    ///   - [`aws_device_v2(Option<String>)`](crate::output::CreateInterconnectOutput::aws_device_v2): <p>The Direct Connect endpoint that terminates the physical connection.</p>
    ///   - [`aws_logical_device_id(Option<String>)`](crate::output::CreateInterconnectOutput::aws_logical_device_id): <p>The Direct Connect endpoint that terminates the logical connection. This device might be different than the device that terminates the physical connection.</p>
    ///   - [`has_logical_redundancy(Option<HasLogicalRedundancy>)`](crate::output::CreateInterconnectOutput::has_logical_redundancy): <p>Indicates whether the interconnect supports a secondary BGP in the same address family (IPv4/IPv6).</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::CreateInterconnectOutput::tags): <p>The tags associated with the interconnect.</p>
    ///   - [`provider_name(Option<String>)`](crate::output::CreateInterconnectOutput::provider_name): <p>The name of the service provider associated with the interconnect.</p>
    /// - On failure, responds with [`SdkError<CreateInterconnectError>`](crate::error::CreateInterconnectError)
    pub fn create_interconnect(&self) -> fluent_builders::CreateInterconnect {
        fluent_builders::CreateInterconnect::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLag`](crate::client::fluent_builders::CreateLag) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`number_of_connections(i32)`](crate::client::fluent_builders::CreateLag::number_of_connections) / [`set_number_of_connections(i32)`](crate::client::fluent_builders::CreateLag::set_number_of_connections): <p>The number of physical dedicated connections initially provisioned and bundled by the LAG.</p>
    ///   - [`location(impl Into<String>)`](crate::client::fluent_builders::CreateLag::location) / [`set_location(Option<String>)`](crate::client::fluent_builders::CreateLag::set_location): <p>The location for the LAG.</p>
    ///   - [`connections_bandwidth(impl Into<String>)`](crate::client::fluent_builders::CreateLag::connections_bandwidth) / [`set_connections_bandwidth(Option<String>)`](crate::client::fluent_builders::CreateLag::set_connections_bandwidth): <p>The bandwidth of the individual physical dedicated connections bundled by the LAG. The possible values are 1Gbps and 10Gbps. </p>
    ///   - [`lag_name(impl Into<String>)`](crate::client::fluent_builders::CreateLag::lag_name) / [`set_lag_name(Option<String>)`](crate::client::fluent_builders::CreateLag::set_lag_name): <p>The name of the LAG.</p>
    ///   - [`connection_id(impl Into<String>)`](crate::client::fluent_builders::CreateLag::connection_id) / [`set_connection_id(Option<String>)`](crate::client::fluent_builders::CreateLag::set_connection_id): <p>The ID of an existing dedicated connection to migrate to the LAG.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateLag::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateLag::set_tags): <p>The tags to associate with the LAG.</p>
    ///   - [`child_connection_tags(Vec<Tag>)`](crate::client::fluent_builders::CreateLag::child_connection_tags) / [`set_child_connection_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateLag::set_child_connection_tags): <p>The tags to associate with the automtically created LAGs.</p>
    ///   - [`provider_name(impl Into<String>)`](crate::client::fluent_builders::CreateLag::provider_name) / [`set_provider_name(Option<String>)`](crate::client::fluent_builders::CreateLag::set_provider_name): <p>The name of the service provider associated with the LAG.</p>
    ///   - [`request_mac_sec(bool)`](crate::client::fluent_builders::CreateLag::request_mac_sec) / [`set_request_mac_sec(Option<bool>)`](crate::client::fluent_builders::CreateLag::set_request_mac_sec): <p>Indicates whether the connection will support MAC Security (MACsec).</p> <note>   <p>All connections in the LAG must be capable of supporting MAC Security (MACsec). For information about MAC Security (MACsec) prerequisties, see <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites">MACsec prerequisties</a> in the <i>Direct Connect User Guide</i>.</p>  </note>
    /// - On success, responds with [`CreateLagOutput`](crate::output::CreateLagOutput) with field(s):
    ///   - [`connections_bandwidth(Option<String>)`](crate::output::CreateLagOutput::connections_bandwidth): <p>The individual bandwidth of the physical connections bundled by the LAG. The possible values are 1Gbps and 10Gbps. </p>
    ///   - [`number_of_connections(i32)`](crate::output::CreateLagOutput::number_of_connections): <p>The number of physical dedicated connections bundled by the LAG, up to a maximum of 10.</p>
    ///   - [`lag_id(Option<String>)`](crate::output::CreateLagOutput::lag_id): <p>The ID of the LAG.</p>
    ///   - [`owner_account(Option<String>)`](crate::output::CreateLagOutput::owner_account): <p>The ID of the Amazon Web Services account that owns the LAG.</p>
    ///   - [`lag_name(Option<String>)`](crate::output::CreateLagOutput::lag_name): <p>The name of the LAG.</p>
    ///   - [`lag_state(Option<LagState>)`](crate::output::CreateLagOutput::lag_state): <p>The state of the LAG. The following are the possible values:</p>  <ul>   <li> <p> <code>requested</code>: The initial state of a LAG. The LAG stays in the requested state until the Letter of Authorization (LOA) is available.</p> </li>   <li> <p> <code>pending</code>: The LAG has been approved and is being initialized.</p> </li>   <li> <p> <code>available</code>: The network link is established and the LAG is ready for use.</p> </li>   <li> <p> <code>down</code>: The network link is down.</p> </li>   <li> <p> <code>deleting</code>: The LAG is being deleted.</p> </li>   <li> <p> <code>deleted</code>: The LAG is deleted.</p> </li>   <li> <p> <code>unknown</code>: The state of the LAG is not available.</p> </li>  </ul>
    ///   - [`location(Option<String>)`](crate::output::CreateLagOutput::location): <p>The location of the LAG.</p>
    ///   - [`region(Option<String>)`](crate::output::CreateLagOutput::region): <p>The Amazon Web Services Region where the connection is located.</p>
    ///   - [`minimum_links(i32)`](crate::output::CreateLagOutput::minimum_links): <p>The minimum number of physical dedicated connections that must be operational for the LAG itself to be operational.</p>
    ///   - [`aws_device(Option<String>)`](crate::output::CreateLagOutput::aws_device): <p>The Direct Connect endpoint that hosts the LAG.</p>
    ///   - [`aws_device_v2(Option<String>)`](crate::output::CreateLagOutput::aws_device_v2): <p>The Direct Connect endpoint that hosts the LAG.</p>
    ///   - [`aws_logical_device_id(Option<String>)`](crate::output::CreateLagOutput::aws_logical_device_id): <p>The Direct Connect endpoint that terminates the logical connection. This device might be different than the device that terminates the physical connection.</p>
    ///   - [`connections(Option<Vec<Connection>>)`](crate::output::CreateLagOutput::connections): <p>The connections bundled by the LAG.</p>
    ///   - [`allows_hosted_connections(bool)`](crate::output::CreateLagOutput::allows_hosted_connections): <p>Indicates whether the LAG can host other connections.</p>
    ///   - [`jumbo_frame_capable(Option<bool>)`](crate::output::CreateLagOutput::jumbo_frame_capable): <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    ///   - [`has_logical_redundancy(Option<HasLogicalRedundancy>)`](crate::output::CreateLagOutput::has_logical_redundancy): <p>Indicates whether the LAG supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::CreateLagOutput::tags): <p>The tags associated with the LAG.</p>
    ///   - [`provider_name(Option<String>)`](crate::output::CreateLagOutput::provider_name): <p>The name of the service provider associated with the LAG.</p>
    ///   - [`mac_sec_capable(Option<bool>)`](crate::output::CreateLagOutput::mac_sec_capable): <p>Indicates whether the LAG supports MAC Security (MACsec).</p>
    ///   - [`encryption_mode(Option<String>)`](crate::output::CreateLagOutput::encryption_mode): <p>The LAG MAC Security (MACsec) encryption mode.</p>  <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
    ///   - [`mac_sec_keys(Option<Vec<MacSecKey>>)`](crate::output::CreateLagOutput::mac_sec_keys): <p>The MAC Security (MACsec) security keys associated with the LAG.</p>
    /// - On failure, responds with [`SdkError<CreateLagError>`](crate::error::CreateLagError)
    pub fn create_lag(&self) -> fluent_builders::CreateLag {
        fluent_builders::CreateLag::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePrivateVirtualInterface`](crate::client::fluent_builders::CreatePrivateVirtualInterface) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connection_id(impl Into<String>)`](crate::client::fluent_builders::CreatePrivateVirtualInterface::connection_id) / [`set_connection_id(Option<String>)`](crate::client::fluent_builders::CreatePrivateVirtualInterface::set_connection_id): <p>The ID of the connection.</p>
    ///   - [`new_private_virtual_interface(NewPrivateVirtualInterface)`](crate::client::fluent_builders::CreatePrivateVirtualInterface::new_private_virtual_interface) / [`set_new_private_virtual_interface(Option<NewPrivateVirtualInterface>)`](crate::client::fluent_builders::CreatePrivateVirtualInterface::set_new_private_virtual_interface): <p>Information about the private virtual interface.</p>
    /// - On success, responds with [`CreatePrivateVirtualInterfaceOutput`](crate::output::CreatePrivateVirtualInterfaceOutput) with field(s):
    ///   - [`owner_account(Option<String>)`](crate::output::CreatePrivateVirtualInterfaceOutput::owner_account): <p>The ID of the Amazon Web Services account that owns the virtual interface.</p>
    ///   - [`virtual_interface_id(Option<String>)`](crate::output::CreatePrivateVirtualInterfaceOutput::virtual_interface_id): <p>The ID of the virtual interface.</p>
    ///   - [`location(Option<String>)`](crate::output::CreatePrivateVirtualInterfaceOutput::location): <p>The location of the connection.</p>
    ///   - [`connection_id(Option<String>)`](crate::output::CreatePrivateVirtualInterfaceOutput::connection_id): <p>The ID of the connection.</p>
    ///   - [`virtual_interface_type(Option<String>)`](crate::output::CreatePrivateVirtualInterfaceOutput::virtual_interface_type): <p>The type of virtual interface. The possible values are <code>private</code> and <code>public</code>.</p>
    ///   - [`virtual_interface_name(Option<String>)`](crate::output::CreatePrivateVirtualInterfaceOutput::virtual_interface_name): <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
    ///   - [`vlan(i32)`](crate::output::CreatePrivateVirtualInterfaceOutput::vlan): <p>The ID of the VLAN.</p>
    ///   - [`asn(i32)`](crate::output::CreatePrivateVirtualInterfaceOutput::asn): <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>  <p>The valid values are 1-2147483647.</p>
    ///   - [`amazon_side_asn(Option<i64>)`](crate::output::CreatePrivateVirtualInterfaceOutput::amazon_side_asn): <p>The autonomous system number (ASN) for the Amazon side of the connection.</p>
    ///   - [`auth_key(Option<String>)`](crate::output::CreatePrivateVirtualInterfaceOutput::auth_key): <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
    ///   - [`amazon_address(Option<String>)`](crate::output::CreatePrivateVirtualInterfaceOutput::amazon_address): <p>The IP address assigned to the Amazon interface.</p>
    ///   - [`customer_address(Option<String>)`](crate::output::CreatePrivateVirtualInterfaceOutput::customer_address): <p>The IP address assigned to the customer interface.</p>
    ///   - [`address_family(Option<AddressFamily>)`](crate::output::CreatePrivateVirtualInterfaceOutput::address_family): <p>The address family for the BGP peer.</p>
    ///   - [`virtual_interface_state(Option<VirtualInterfaceState>)`](crate::output::CreatePrivateVirtualInterfaceOutput::virtual_interface_state): <p>The state of the virtual interface. The following are the possible values:</p>  <ul>   <li> <p> <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p> </li>   <li> <p> <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p> </li>   <li> <p> <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p> </li>   <li> <p> <code>available</code>: A virtual interface that is able to forward traffic.</p> </li>   <li> <p> <code>down</code>: A virtual interface that is BGP down.</p> </li>   <li> <p> <code>deleting</code>: A virtual interface is in this state immediately after calling <code>DeleteVirtualInterface</code> until it can no longer forward traffic.</p> </li>   <li> <p> <code>deleted</code>: A virtual interface that cannot forward traffic.</p> </li>   <li> <p> <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p> </li>   <li> <p> <code>unknown</code>: The state of the virtual interface is not available.</p> </li>  </ul>
    ///   - [`customer_router_config(Option<String>)`](crate::output::CreatePrivateVirtualInterfaceOutput::customer_router_config): <p>The customer router configuration.</p>
    ///   - [`mtu(Option<i32>)`](crate::output::CreatePrivateVirtualInterfaceOutput::mtu): <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
    ///   - [`jumbo_frame_capable(Option<bool>)`](crate::output::CreatePrivateVirtualInterfaceOutput::jumbo_frame_capable): <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    ///   - [`virtual_gateway_id(Option<String>)`](crate::output::CreatePrivateVirtualInterfaceOutput::virtual_gateway_id): <p>The ID of the virtual private gateway. Applies only to private virtual interfaces.</p>
    ///   - [`direct_connect_gateway_id(Option<String>)`](crate::output::CreatePrivateVirtualInterfaceOutput::direct_connect_gateway_id): <p>The ID of the Direct Connect gateway.</p>
    ///   - [`route_filter_prefixes(Option<Vec<RouteFilterPrefix>>)`](crate::output::CreatePrivateVirtualInterfaceOutput::route_filter_prefixes): <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
    ///   - [`bgp_peers(Option<Vec<BgpPeer>>)`](crate::output::CreatePrivateVirtualInterfaceOutput::bgp_peers): <p>The BGP peers configured on this virtual interface.</p>
    ///   - [`region(Option<String>)`](crate::output::CreatePrivateVirtualInterfaceOutput::region): <p>The Amazon Web Services Region where the virtual interface is located.</p>
    ///   - [`aws_device_v2(Option<String>)`](crate::output::CreatePrivateVirtualInterfaceOutput::aws_device_v2): <p>The Direct Connect endpoint that terminates the physical connection.</p>
    ///   - [`aws_logical_device_id(Option<String>)`](crate::output::CreatePrivateVirtualInterfaceOutput::aws_logical_device_id): <p>The Direct Connect endpoint that terminates the logical connection. This device might be different than the device that terminates the physical connection.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::CreatePrivateVirtualInterfaceOutput::tags): <p>The tags associated with the virtual interface.</p>
    ///   - [`site_link_enabled(Option<bool>)`](crate::output::CreatePrivateVirtualInterfaceOutput::site_link_enabled): <p>Indicates whether SiteLink is enabled.</p>
    /// - On failure, responds with [`SdkError<CreatePrivateVirtualInterfaceError>`](crate::error::CreatePrivateVirtualInterfaceError)
    pub fn create_private_virtual_interface(
        &self,
    ) -> fluent_builders::CreatePrivateVirtualInterface {
        fluent_builders::CreatePrivateVirtualInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePublicVirtualInterface`](crate::client::fluent_builders::CreatePublicVirtualInterface) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connection_id(impl Into<String>)`](crate::client::fluent_builders::CreatePublicVirtualInterface::connection_id) / [`set_connection_id(Option<String>)`](crate::client::fluent_builders::CreatePublicVirtualInterface::set_connection_id): <p>The ID of the connection.</p>
    ///   - [`new_public_virtual_interface(NewPublicVirtualInterface)`](crate::client::fluent_builders::CreatePublicVirtualInterface::new_public_virtual_interface) / [`set_new_public_virtual_interface(Option<NewPublicVirtualInterface>)`](crate::client::fluent_builders::CreatePublicVirtualInterface::set_new_public_virtual_interface): <p>Information about the public virtual interface.</p>
    /// - On success, responds with [`CreatePublicVirtualInterfaceOutput`](crate::output::CreatePublicVirtualInterfaceOutput) with field(s):
    ///   - [`owner_account(Option<String>)`](crate::output::CreatePublicVirtualInterfaceOutput::owner_account): <p>The ID of the Amazon Web Services account that owns the virtual interface.</p>
    ///   - [`virtual_interface_id(Option<String>)`](crate::output::CreatePublicVirtualInterfaceOutput::virtual_interface_id): <p>The ID of the virtual interface.</p>
    ///   - [`location(Option<String>)`](crate::output::CreatePublicVirtualInterfaceOutput::location): <p>The location of the connection.</p>
    ///   - [`connection_id(Option<String>)`](crate::output::CreatePublicVirtualInterfaceOutput::connection_id): <p>The ID of the connection.</p>
    ///   - [`virtual_interface_type(Option<String>)`](crate::output::CreatePublicVirtualInterfaceOutput::virtual_interface_type): <p>The type of virtual interface. The possible values are <code>private</code> and <code>public</code>.</p>
    ///   - [`virtual_interface_name(Option<String>)`](crate::output::CreatePublicVirtualInterfaceOutput::virtual_interface_name): <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
    ///   - [`vlan(i32)`](crate::output::CreatePublicVirtualInterfaceOutput::vlan): <p>The ID of the VLAN.</p>
    ///   - [`asn(i32)`](crate::output::CreatePublicVirtualInterfaceOutput::asn): <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>  <p>The valid values are 1-2147483647.</p>
    ///   - [`amazon_side_asn(Option<i64>)`](crate::output::CreatePublicVirtualInterfaceOutput::amazon_side_asn): <p>The autonomous system number (ASN) for the Amazon side of the connection.</p>
    ///   - [`auth_key(Option<String>)`](crate::output::CreatePublicVirtualInterfaceOutput::auth_key): <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
    ///   - [`amazon_address(Option<String>)`](crate::output::CreatePublicVirtualInterfaceOutput::amazon_address): <p>The IP address assigned to the Amazon interface.</p>
    ///   - [`customer_address(Option<String>)`](crate::output::CreatePublicVirtualInterfaceOutput::customer_address): <p>The IP address assigned to the customer interface.</p>
    ///   - [`address_family(Option<AddressFamily>)`](crate::output::CreatePublicVirtualInterfaceOutput::address_family): <p>The address family for the BGP peer.</p>
    ///   - [`virtual_interface_state(Option<VirtualInterfaceState>)`](crate::output::CreatePublicVirtualInterfaceOutput::virtual_interface_state): <p>The state of the virtual interface. The following are the possible values:</p>  <ul>   <li> <p> <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p> </li>   <li> <p> <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p> </li>   <li> <p> <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p> </li>   <li> <p> <code>available</code>: A virtual interface that is able to forward traffic.</p> </li>   <li> <p> <code>down</code>: A virtual interface that is BGP down.</p> </li>   <li> <p> <code>deleting</code>: A virtual interface is in this state immediately after calling <code>DeleteVirtualInterface</code> until it can no longer forward traffic.</p> </li>   <li> <p> <code>deleted</code>: A virtual interface that cannot forward traffic.</p> </li>   <li> <p> <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p> </li>   <li> <p> <code>unknown</code>: The state of the virtual interface is not available.</p> </li>  </ul>
    ///   - [`customer_router_config(Option<String>)`](crate::output::CreatePublicVirtualInterfaceOutput::customer_router_config): <p>The customer router configuration.</p>
    ///   - [`mtu(Option<i32>)`](crate::output::CreatePublicVirtualInterfaceOutput::mtu): <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
    ///   - [`jumbo_frame_capable(Option<bool>)`](crate::output::CreatePublicVirtualInterfaceOutput::jumbo_frame_capable): <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    ///   - [`virtual_gateway_id(Option<String>)`](crate::output::CreatePublicVirtualInterfaceOutput::virtual_gateway_id): <p>The ID of the virtual private gateway. Applies only to private virtual interfaces.</p>
    ///   - [`direct_connect_gateway_id(Option<String>)`](crate::output::CreatePublicVirtualInterfaceOutput::direct_connect_gateway_id): <p>The ID of the Direct Connect gateway.</p>
    ///   - [`route_filter_prefixes(Option<Vec<RouteFilterPrefix>>)`](crate::output::CreatePublicVirtualInterfaceOutput::route_filter_prefixes): <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
    ///   - [`bgp_peers(Option<Vec<BgpPeer>>)`](crate::output::CreatePublicVirtualInterfaceOutput::bgp_peers): <p>The BGP peers configured on this virtual interface.</p>
    ///   - [`region(Option<String>)`](crate::output::CreatePublicVirtualInterfaceOutput::region): <p>The Amazon Web Services Region where the virtual interface is located.</p>
    ///   - [`aws_device_v2(Option<String>)`](crate::output::CreatePublicVirtualInterfaceOutput::aws_device_v2): <p>The Direct Connect endpoint that terminates the physical connection.</p>
    ///   - [`aws_logical_device_id(Option<String>)`](crate::output::CreatePublicVirtualInterfaceOutput::aws_logical_device_id): <p>The Direct Connect endpoint that terminates the logical connection. This device might be different than the device that terminates the physical connection.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::CreatePublicVirtualInterfaceOutput::tags): <p>The tags associated with the virtual interface.</p>
    ///   - [`site_link_enabled(Option<bool>)`](crate::output::CreatePublicVirtualInterfaceOutput::site_link_enabled): <p>Indicates whether SiteLink is enabled.</p>
    /// - On failure, responds with [`SdkError<CreatePublicVirtualInterfaceError>`](crate::error::CreatePublicVirtualInterfaceError)
    pub fn create_public_virtual_interface(&self) -> fluent_builders::CreatePublicVirtualInterface {
        fluent_builders::CreatePublicVirtualInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTransitVirtualInterface`](crate::client::fluent_builders::CreateTransitVirtualInterface) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connection_id(impl Into<String>)`](crate::client::fluent_builders::CreateTransitVirtualInterface::connection_id) / [`set_connection_id(Option<String>)`](crate::client::fluent_builders::CreateTransitVirtualInterface::set_connection_id): <p>The ID of the connection.</p>
    ///   - [`new_transit_virtual_interface(NewTransitVirtualInterface)`](crate::client::fluent_builders::CreateTransitVirtualInterface::new_transit_virtual_interface) / [`set_new_transit_virtual_interface(Option<NewTransitVirtualInterface>)`](crate::client::fluent_builders::CreateTransitVirtualInterface::set_new_transit_virtual_interface): <p>Information about the transit virtual interface.</p>
    /// - On success, responds with [`CreateTransitVirtualInterfaceOutput`](crate::output::CreateTransitVirtualInterfaceOutput) with field(s):
    ///   - [`virtual_interface(Option<VirtualInterface>)`](crate::output::CreateTransitVirtualInterfaceOutput::virtual_interface): <p>Information about a virtual interface.</p>
    /// - On failure, responds with [`SdkError<CreateTransitVirtualInterfaceError>`](crate::error::CreateTransitVirtualInterfaceError)
    pub fn create_transit_virtual_interface(
        &self,
    ) -> fluent_builders::CreateTransitVirtualInterface {
        fluent_builders::CreateTransitVirtualInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBGPPeer`](crate::client::fluent_builders::DeleteBGPPeer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`virtual_interface_id(impl Into<String>)`](crate::client::fluent_builders::DeleteBGPPeer::virtual_interface_id) / [`set_virtual_interface_id(Option<String>)`](crate::client::fluent_builders::DeleteBGPPeer::set_virtual_interface_id): <p>The ID of the virtual interface.</p>
    ///   - [`asn(i32)`](crate::client::fluent_builders::DeleteBGPPeer::asn) / [`set_asn(i32)`](crate::client::fluent_builders::DeleteBGPPeer::set_asn): <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
    ///   - [`customer_address(impl Into<String>)`](crate::client::fluent_builders::DeleteBGPPeer::customer_address) / [`set_customer_address(Option<String>)`](crate::client::fluent_builders::DeleteBGPPeer::set_customer_address): <p>The IP address assigned to the customer interface.</p>
    ///   - [`bgp_peer_id(impl Into<String>)`](crate::client::fluent_builders::DeleteBGPPeer::bgp_peer_id) / [`set_bgp_peer_id(Option<String>)`](crate::client::fluent_builders::DeleteBGPPeer::set_bgp_peer_id): <p>The ID of the BGP peer.</p>
    /// - On success, responds with [`DeleteBgpPeerOutput`](crate::output::DeleteBgpPeerOutput) with field(s):
    ///   - [`virtual_interface(Option<VirtualInterface>)`](crate::output::DeleteBgpPeerOutput::virtual_interface): <p>The virtual interface.</p>
    /// - On failure, responds with [`SdkError<DeleteBGPPeerError>`](crate::error::DeleteBGPPeerError)
    pub fn delete_bgp_peer(&self) -> fluent_builders::DeleteBGPPeer {
        fluent_builders::DeleteBGPPeer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteConnection`](crate::client::fluent_builders::DeleteConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connection_id(impl Into<String>)`](crate::client::fluent_builders::DeleteConnection::connection_id) / [`set_connection_id(Option<String>)`](crate::client::fluent_builders::DeleteConnection::set_connection_id): <p>The ID of the connection.</p>
    /// - On success, responds with [`DeleteConnectionOutput`](crate::output::DeleteConnectionOutput) with field(s):
    ///   - [`owner_account(Option<String>)`](crate::output::DeleteConnectionOutput::owner_account): <p>The ID of the Amazon Web Services account that owns the connection.</p>
    ///   - [`connection_id(Option<String>)`](crate::output::DeleteConnectionOutput::connection_id): <p>The ID of the connection.</p>
    ///   - [`connection_name(Option<String>)`](crate::output::DeleteConnectionOutput::connection_name): <p>The name of the connection.</p>
    ///   - [`connection_state(Option<ConnectionState>)`](crate::output::DeleteConnectionOutput::connection_state): <p>The state of the connection. The following are the possible values:</p>  <ul>   <li> <p> <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p> </li>   <li> <p> <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p> </li>   <li> <p> <code>pending</code>: The connection has been approved and is being initialized.</p> </li>   <li> <p> <code>available</code>: The network link is up and the connection is ready for use.</p> </li>   <li> <p> <code>down</code>: The network link is down.</p> </li>   <li> <p> <code>deleting</code>: The connection is being deleted.</p> </li>   <li> <p> <code>deleted</code>: The connection has been deleted.</p> </li>   <li> <p> <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p> </li>   <li> <p> <code>unknown</code>: The state of the connection is not available.</p> </li>  </ul>
    ///   - [`region(Option<String>)`](crate::output::DeleteConnectionOutput::region): <p>The Amazon Web Services Region where the connection is located.</p>
    ///   - [`location(Option<String>)`](crate::output::DeleteConnectionOutput::location): <p>The location of the connection.</p>
    ///   - [`bandwidth(Option<String>)`](crate::output::DeleteConnectionOutput::bandwidth): <p>The bandwidth of the connection.</p>
    ///   - [`vlan(i32)`](crate::output::DeleteConnectionOutput::vlan): <p>The ID of the VLAN.</p>
    ///   - [`partner_name(Option<String>)`](crate::output::DeleteConnectionOutput::partner_name): <p>The name of the Direct Connect service provider associated with the connection.</p>
    ///   - [`loa_issue_time(Option<DateTime>)`](crate::output::DeleteConnectionOutput::loa_issue_time): <p>The time of the most recent call to <code>DescribeLoa</code> for this connection.</p>
    ///   - [`lag_id(Option<String>)`](crate::output::DeleteConnectionOutput::lag_id): <p>The ID of the LAG.</p>
    ///   - [`aws_device(Option<String>)`](crate::output::DeleteConnectionOutput::aws_device): <p>The Direct Connect endpoint on which the physical connection terminates.</p>
    ///   - [`jumbo_frame_capable(Option<bool>)`](crate::output::DeleteConnectionOutput::jumbo_frame_capable): <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    ///   - [`aws_device_v2(Option<String>)`](crate::output::DeleteConnectionOutput::aws_device_v2): <p>The Direct Connect endpoint that terminates the physical connection.</p>
    ///   - [`aws_logical_device_id(Option<String>)`](crate::output::DeleteConnectionOutput::aws_logical_device_id): <p>The Direct Connect endpoint that terminates the logical connection. This device might be different than the device that terminates the physical connection.</p>
    ///   - [`has_logical_redundancy(Option<HasLogicalRedundancy>)`](crate::output::DeleteConnectionOutput::has_logical_redundancy): <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::DeleteConnectionOutput::tags): <p>The tags associated with the connection.</p>
    ///   - [`provider_name(Option<String>)`](crate::output::DeleteConnectionOutput::provider_name): <p>The name of the service provider associated with the connection.</p>
    ///   - [`mac_sec_capable(Option<bool>)`](crate::output::DeleteConnectionOutput::mac_sec_capable): <p>Indicates whether the connection supports MAC Security (MACsec).</p>
    ///   - [`port_encryption_status(Option<String>)`](crate::output::DeleteConnectionOutput::port_encryption_status): <p>The MAC Security (MACsec) port link status of the connection.</p>  <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
    ///   - [`encryption_mode(Option<String>)`](crate::output::DeleteConnectionOutput::encryption_mode): <p>The MAC Security (MACsec) connection encryption mode.</p>  <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
    ///   - [`mac_sec_keys(Option<Vec<MacSecKey>>)`](crate::output::DeleteConnectionOutput::mac_sec_keys): <p>The MAC Security (MACsec) security keys associated with the connection.</p>
    /// - On failure, responds with [`SdkError<DeleteConnectionError>`](crate::error::DeleteConnectionError)
    pub fn delete_connection(&self) -> fluent_builders::DeleteConnection {
        fluent_builders::DeleteConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDirectConnectGateway`](crate::client::fluent_builders::DeleteDirectConnectGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`direct_connect_gateway_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDirectConnectGateway::direct_connect_gateway_id) / [`set_direct_connect_gateway_id(Option<String>)`](crate::client::fluent_builders::DeleteDirectConnectGateway::set_direct_connect_gateway_id): <p>The ID of the Direct Connect gateway.</p>
    /// - On success, responds with [`DeleteDirectConnectGatewayOutput`](crate::output::DeleteDirectConnectGatewayOutput) with field(s):
    ///   - [`direct_connect_gateway(Option<DirectConnectGateway>)`](crate::output::DeleteDirectConnectGatewayOutput::direct_connect_gateway): <p>The Direct Connect gateway.</p>
    /// - On failure, responds with [`SdkError<DeleteDirectConnectGatewayError>`](crate::error::DeleteDirectConnectGatewayError)
    pub fn delete_direct_connect_gateway(&self) -> fluent_builders::DeleteDirectConnectGateway {
        fluent_builders::DeleteDirectConnectGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDirectConnectGatewayAssociation`](crate::client::fluent_builders::DeleteDirectConnectGatewayAssociation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`association_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDirectConnectGatewayAssociation::association_id) / [`set_association_id(Option<String>)`](crate::client::fluent_builders::DeleteDirectConnectGatewayAssociation::set_association_id): <p>The ID of the Direct Connect gateway association.</p>
    ///   - [`direct_connect_gateway_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDirectConnectGatewayAssociation::direct_connect_gateway_id) / [`set_direct_connect_gateway_id(Option<String>)`](crate::client::fluent_builders::DeleteDirectConnectGatewayAssociation::set_direct_connect_gateway_id): <p>The ID of the Direct Connect gateway.</p>
    ///   - [`virtual_gateway_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDirectConnectGatewayAssociation::virtual_gateway_id) / [`set_virtual_gateway_id(Option<String>)`](crate::client::fluent_builders::DeleteDirectConnectGatewayAssociation::set_virtual_gateway_id): <p>The ID of the virtual private gateway.</p>
    /// - On success, responds with [`DeleteDirectConnectGatewayAssociationOutput`](crate::output::DeleteDirectConnectGatewayAssociationOutput) with field(s):
    ///   - [`direct_connect_gateway_association(Option<DirectConnectGatewayAssociation>)`](crate::output::DeleteDirectConnectGatewayAssociationOutput::direct_connect_gateway_association): <p>Information about the deleted association.</p>
    /// - On failure, responds with [`SdkError<DeleteDirectConnectGatewayAssociationError>`](crate::error::DeleteDirectConnectGatewayAssociationError)
    pub fn delete_direct_connect_gateway_association(
        &self,
    ) -> fluent_builders::DeleteDirectConnectGatewayAssociation {
        fluent_builders::DeleteDirectConnectGatewayAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDirectConnectGatewayAssociationProposal`](crate::client::fluent_builders::DeleteDirectConnectGatewayAssociationProposal) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`proposal_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDirectConnectGatewayAssociationProposal::proposal_id) / [`set_proposal_id(Option<String>)`](crate::client::fluent_builders::DeleteDirectConnectGatewayAssociationProposal::set_proposal_id): <p>The ID of the proposal.</p>
    /// - On success, responds with [`DeleteDirectConnectGatewayAssociationProposalOutput`](crate::output::DeleteDirectConnectGatewayAssociationProposalOutput) with field(s):
    ///   - [`direct_connect_gateway_association_proposal(Option<DirectConnectGatewayAssociationProposal>)`](crate::output::DeleteDirectConnectGatewayAssociationProposalOutput::direct_connect_gateway_association_proposal): <p>The ID of the associated gateway.</p>
    /// - On failure, responds with [`SdkError<DeleteDirectConnectGatewayAssociationProposalError>`](crate::error::DeleteDirectConnectGatewayAssociationProposalError)
    pub fn delete_direct_connect_gateway_association_proposal(
        &self,
    ) -> fluent_builders::DeleteDirectConnectGatewayAssociationProposal {
        fluent_builders::DeleteDirectConnectGatewayAssociationProposal::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteInterconnect`](crate::client::fluent_builders::DeleteInterconnect) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`interconnect_id(impl Into<String>)`](crate::client::fluent_builders::DeleteInterconnect::interconnect_id) / [`set_interconnect_id(Option<String>)`](crate::client::fluent_builders::DeleteInterconnect::set_interconnect_id): <p>The ID of the interconnect.</p>
    /// - On success, responds with [`DeleteInterconnectOutput`](crate::output::DeleteInterconnectOutput) with field(s):
    ///   - [`interconnect_state(Option<InterconnectState>)`](crate::output::DeleteInterconnectOutput::interconnect_state): <p>The state of the interconnect. The following are the possible values:</p>  <ul>   <li> <p> <code>requested</code>: The initial state of an interconnect. The interconnect stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p> </li>   <li> <p> <code>pending</code>: The interconnect is approved, and is being initialized.</p> </li>   <li> <p> <code>available</code>: The network link is up, and the interconnect is ready for use.</p> </li>   <li> <p> <code>down</code>: The network link is down.</p> </li>   <li> <p> <code>deleting</code>: The interconnect is being deleted.</p> </li>   <li> <p> <code>deleted</code>: The interconnect is deleted.</p> </li>   <li> <p> <code>unknown</code>: The state of the interconnect is not available.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<DeleteInterconnectError>`](crate::error::DeleteInterconnectError)
    pub fn delete_interconnect(&self) -> fluent_builders::DeleteInterconnect {
        fluent_builders::DeleteInterconnect::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteLag`](crate::client::fluent_builders::DeleteLag) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`lag_id(impl Into<String>)`](crate::client::fluent_builders::DeleteLag::lag_id) / [`set_lag_id(Option<String>)`](crate::client::fluent_builders::DeleteLag::set_lag_id): <p>The ID of the LAG.</p>
    /// - On success, responds with [`DeleteLagOutput`](crate::output::DeleteLagOutput) with field(s):
    ///   - [`connections_bandwidth(Option<String>)`](crate::output::DeleteLagOutput::connections_bandwidth): <p>The individual bandwidth of the physical connections bundled by the LAG. The possible values are 1Gbps and 10Gbps. </p>
    ///   - [`number_of_connections(i32)`](crate::output::DeleteLagOutput::number_of_connections): <p>The number of physical dedicated connections bundled by the LAG, up to a maximum of 10.</p>
    ///   - [`lag_id(Option<String>)`](crate::output::DeleteLagOutput::lag_id): <p>The ID of the LAG.</p>
    ///   - [`owner_account(Option<String>)`](crate::output::DeleteLagOutput::owner_account): <p>The ID of the Amazon Web Services account that owns the LAG.</p>
    ///   - [`lag_name(Option<String>)`](crate::output::DeleteLagOutput::lag_name): <p>The name of the LAG.</p>
    ///   - [`lag_state(Option<LagState>)`](crate::output::DeleteLagOutput::lag_state): <p>The state of the LAG. The following are the possible values:</p>  <ul>   <li> <p> <code>requested</code>: The initial state of a LAG. The LAG stays in the requested state until the Letter of Authorization (LOA) is available.</p> </li>   <li> <p> <code>pending</code>: The LAG has been approved and is being initialized.</p> </li>   <li> <p> <code>available</code>: The network link is established and the LAG is ready for use.</p> </li>   <li> <p> <code>down</code>: The network link is down.</p> </li>   <li> <p> <code>deleting</code>: The LAG is being deleted.</p> </li>   <li> <p> <code>deleted</code>: The LAG is deleted.</p> </li>   <li> <p> <code>unknown</code>: The state of the LAG is not available.</p> </li>  </ul>
    ///   - [`location(Option<String>)`](crate::output::DeleteLagOutput::location): <p>The location of the LAG.</p>
    ///   - [`region(Option<String>)`](crate::output::DeleteLagOutput::region): <p>The Amazon Web Services Region where the connection is located.</p>
    ///   - [`minimum_links(i32)`](crate::output::DeleteLagOutput::minimum_links): <p>The minimum number of physical dedicated connections that must be operational for the LAG itself to be operational.</p>
    ///   - [`aws_device(Option<String>)`](crate::output::DeleteLagOutput::aws_device): <p>The Direct Connect endpoint that hosts the LAG.</p>
    ///   - [`aws_device_v2(Option<String>)`](crate::output::DeleteLagOutput::aws_device_v2): <p>The Direct Connect endpoint that hosts the LAG.</p>
    ///   - [`aws_logical_device_id(Option<String>)`](crate::output::DeleteLagOutput::aws_logical_device_id): <p>The Direct Connect endpoint that terminates the logical connection. This device might be different than the device that terminates the physical connection.</p>
    ///   - [`connections(Option<Vec<Connection>>)`](crate::output::DeleteLagOutput::connections): <p>The connections bundled by the LAG.</p>
    ///   - [`allows_hosted_connections(bool)`](crate::output::DeleteLagOutput::allows_hosted_connections): <p>Indicates whether the LAG can host other connections.</p>
    ///   - [`jumbo_frame_capable(Option<bool>)`](crate::output::DeleteLagOutput::jumbo_frame_capable): <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    ///   - [`has_logical_redundancy(Option<HasLogicalRedundancy>)`](crate::output::DeleteLagOutput::has_logical_redundancy): <p>Indicates whether the LAG supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::DeleteLagOutput::tags): <p>The tags associated with the LAG.</p>
    ///   - [`provider_name(Option<String>)`](crate::output::DeleteLagOutput::provider_name): <p>The name of the service provider associated with the LAG.</p>
    ///   - [`mac_sec_capable(Option<bool>)`](crate::output::DeleteLagOutput::mac_sec_capable): <p>Indicates whether the LAG supports MAC Security (MACsec).</p>
    ///   - [`encryption_mode(Option<String>)`](crate::output::DeleteLagOutput::encryption_mode): <p>The LAG MAC Security (MACsec) encryption mode.</p>  <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
    ///   - [`mac_sec_keys(Option<Vec<MacSecKey>>)`](crate::output::DeleteLagOutput::mac_sec_keys): <p>The MAC Security (MACsec) security keys associated with the LAG.</p>
    /// - On failure, responds with [`SdkError<DeleteLagError>`](crate::error::DeleteLagError)
    pub fn delete_lag(&self) -> fluent_builders::DeleteLag {
        fluent_builders::DeleteLag::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVirtualInterface`](crate::client::fluent_builders::DeleteVirtualInterface) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`virtual_interface_id(impl Into<String>)`](crate::client::fluent_builders::DeleteVirtualInterface::virtual_interface_id) / [`set_virtual_interface_id(Option<String>)`](crate::client::fluent_builders::DeleteVirtualInterface::set_virtual_interface_id): <p>The ID of the virtual interface.</p>
    /// - On success, responds with [`DeleteVirtualInterfaceOutput`](crate::output::DeleteVirtualInterfaceOutput) with field(s):
    ///   - [`virtual_interface_state(Option<VirtualInterfaceState>)`](crate::output::DeleteVirtualInterfaceOutput::virtual_interface_state): <p>The state of the virtual interface. The following are the possible values:</p>  <ul>   <li> <p> <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p> </li>   <li> <p> <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p> </li>   <li> <p> <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p> </li>   <li> <p> <code>available</code>: A virtual interface that is able to forward traffic.</p> </li>   <li> <p> <code>down</code>: A virtual interface that is BGP down.</p> </li>   <li> <p> <code>deleting</code>: A virtual interface is in this state immediately after calling <code>DeleteVirtualInterface</code> until it can no longer forward traffic.</p> </li>   <li> <p> <code>deleted</code>: A virtual interface that cannot forward traffic.</p> </li>   <li> <p> <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p> </li>   <li> <p> <code>unknown</code>: The state of the virtual interface is not available.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<DeleteVirtualInterfaceError>`](crate::error::DeleteVirtualInterfaceError)
    pub fn delete_virtual_interface(&self) -> fluent_builders::DeleteVirtualInterface {
        fluent_builders::DeleteVirtualInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeConnectionLoa`](crate::client::fluent_builders::DescribeConnectionLoa) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connection_id(impl Into<String>)`](crate::client::fluent_builders::DescribeConnectionLoa::connection_id) / [`set_connection_id(Option<String>)`](crate::client::fluent_builders::DescribeConnectionLoa::set_connection_id): <p>The ID of the connection.</p>
    ///   - [`provider_name(impl Into<String>)`](crate::client::fluent_builders::DescribeConnectionLoa::provider_name) / [`set_provider_name(Option<String>)`](crate::client::fluent_builders::DescribeConnectionLoa::set_provider_name): <p>The name of the APN partner or service provider who establishes connectivity on your behalf. If you specify this parameter, the LOA-CFA lists the provider name alongside your company name as the requester of the cross connect.</p>
    ///   - [`loa_content_type(LoaContentType)`](crate::client::fluent_builders::DescribeConnectionLoa::loa_content_type) / [`set_loa_content_type(Option<LoaContentType>)`](crate::client::fluent_builders::DescribeConnectionLoa::set_loa_content_type): <p>The standard media type for the LOA-CFA document. The only supported value is application/pdf.</p>
    /// - On success, responds with [`DescribeConnectionLoaOutput`](crate::output::DescribeConnectionLoaOutput) with field(s):
    ///   - [`loa(Option<Loa>)`](crate::output::DescribeConnectionLoaOutput::loa): <p>The Letter of Authorization - Connecting Facility Assignment (LOA-CFA).</p>
    /// - On failure, responds with [`SdkError<DescribeConnectionLoaError>`](crate::error::DescribeConnectionLoaError)
    pub fn describe_connection_loa(&self) -> fluent_builders::DescribeConnectionLoa {
        fluent_builders::DescribeConnectionLoa::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeConnections`](crate::client::fluent_builders::DescribeConnections) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connection_id(impl Into<String>)`](crate::client::fluent_builders::DescribeConnections::connection_id) / [`set_connection_id(Option<String>)`](crate::client::fluent_builders::DescribeConnections::set_connection_id): <p>The ID of the connection.</p>
    /// - On success, responds with [`DescribeConnectionsOutput`](crate::output::DescribeConnectionsOutput) with field(s):
    ///   - [`connections(Option<Vec<Connection>>)`](crate::output::DescribeConnectionsOutput::connections): <p>The connections.</p>
    /// - On failure, responds with [`SdkError<DescribeConnectionsError>`](crate::error::DescribeConnectionsError)
    pub fn describe_connections(&self) -> fluent_builders::DescribeConnections {
        fluent_builders::DescribeConnections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeConnectionsOnInterconnect`](crate::client::fluent_builders::DescribeConnectionsOnInterconnect) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`interconnect_id(impl Into<String>)`](crate::client::fluent_builders::DescribeConnectionsOnInterconnect::interconnect_id) / [`set_interconnect_id(Option<String>)`](crate::client::fluent_builders::DescribeConnectionsOnInterconnect::set_interconnect_id): <p>The ID of the interconnect.</p>
    /// - On success, responds with [`DescribeConnectionsOnInterconnectOutput`](crate::output::DescribeConnectionsOnInterconnectOutput) with field(s):
    ///   - [`connections(Option<Vec<Connection>>)`](crate::output::DescribeConnectionsOnInterconnectOutput::connections): <p>The connections.</p>
    /// - On failure, responds with [`SdkError<DescribeConnectionsOnInterconnectError>`](crate::error::DescribeConnectionsOnInterconnectError)
    pub fn describe_connections_on_interconnect(
        &self,
    ) -> fluent_builders::DescribeConnectionsOnInterconnect {
        fluent_builders::DescribeConnectionsOnInterconnect::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCustomerMetadata`](crate::client::fluent_builders::DescribeCustomerMetadata) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeCustomerMetadata::send) it.

    /// - On success, responds with [`DescribeCustomerMetadataOutput`](crate::output::DescribeCustomerMetadataOutput) with field(s):
    ///   - [`agreements(Option<Vec<CustomerAgreement>>)`](crate::output::DescribeCustomerMetadataOutput::agreements): <p>The list of customer agreements.</p>
    ///   - [`nni_partner_type(Option<NniPartnerType>)`](crate::output::DescribeCustomerMetadataOutput::nni_partner_type): <p>The type of network-to-network interface (NNI) partner. The partner type will be one of the following:</p>  <ul>   <li> <p>V1: This partner can only allocate 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, or 500Mbps subgigabit connections.</p> </li>   <li> <p>V2: This partner can only allocate 1GB, 2GB, 5GB, or 10GB hosted connections.</p> </li>   <li> <p>nonPartner: The customer is not a partner.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<DescribeCustomerMetadataError>`](crate::error::DescribeCustomerMetadataError)
    pub fn describe_customer_metadata(&self) -> fluent_builders::DescribeCustomerMetadata {
        fluent_builders::DescribeCustomerMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDirectConnectGatewayAssociationProposals`](crate::client::fluent_builders::DescribeDirectConnectGatewayAssociationProposals) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`direct_connect_gateway_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDirectConnectGatewayAssociationProposals::direct_connect_gateway_id) / [`set_direct_connect_gateway_id(Option<String>)`](crate::client::fluent_builders::DescribeDirectConnectGatewayAssociationProposals::set_direct_connect_gateway_id): <p>The ID of the Direct Connect gateway.</p>
    ///   - [`proposal_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDirectConnectGatewayAssociationProposals::proposal_id) / [`set_proposal_id(Option<String>)`](crate::client::fluent_builders::DescribeDirectConnectGatewayAssociationProposals::set_proposal_id): <p>The ID of the proposal.</p>
    ///   - [`associated_gateway_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDirectConnectGatewayAssociationProposals::associated_gateway_id) / [`set_associated_gateway_id(Option<String>)`](crate::client::fluent_builders::DescribeDirectConnectGatewayAssociationProposals::set_associated_gateway_id): <p>The ID of the associated gateway.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeDirectConnectGatewayAssociationProposals::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeDirectConnectGatewayAssociationProposals::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>  <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeDirectConnectGatewayAssociationProposals::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeDirectConnectGatewayAssociationProposals::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`DescribeDirectConnectGatewayAssociationProposalsOutput`](crate::output::DescribeDirectConnectGatewayAssociationProposalsOutput) with field(s):
    ///   - [`direct_connect_gateway_association_proposals(Option<Vec<DirectConnectGatewayAssociationProposal>>)`](crate::output::DescribeDirectConnectGatewayAssociationProposalsOutput::direct_connect_gateway_association_proposals): <p>Describes the Direct Connect gateway association proposals.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeDirectConnectGatewayAssociationProposalsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeDirectConnectGatewayAssociationProposalsError>`](crate::error::DescribeDirectConnectGatewayAssociationProposalsError)
    pub fn describe_direct_connect_gateway_association_proposals(
        &self,
    ) -> fluent_builders::DescribeDirectConnectGatewayAssociationProposals {
        fluent_builders::DescribeDirectConnectGatewayAssociationProposals::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDirectConnectGatewayAssociations`](crate::client::fluent_builders::DescribeDirectConnectGatewayAssociations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`association_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDirectConnectGatewayAssociations::association_id) / [`set_association_id(Option<String>)`](crate::client::fluent_builders::DescribeDirectConnectGatewayAssociations::set_association_id): <p>The ID of the Direct Connect gateway association.</p>
    ///   - [`associated_gateway_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDirectConnectGatewayAssociations::associated_gateway_id) / [`set_associated_gateway_id(Option<String>)`](crate::client::fluent_builders::DescribeDirectConnectGatewayAssociations::set_associated_gateway_id): <p>The ID of the associated gateway.</p>
    ///   - [`direct_connect_gateway_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDirectConnectGatewayAssociations::direct_connect_gateway_id) / [`set_direct_connect_gateway_id(Option<String>)`](crate::client::fluent_builders::DescribeDirectConnectGatewayAssociations::set_direct_connect_gateway_id): <p>The ID of the Direct Connect gateway.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeDirectConnectGatewayAssociations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeDirectConnectGatewayAssociations::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>  <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeDirectConnectGatewayAssociations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeDirectConnectGatewayAssociations::set_next_token): <p>The token provided in the previous call to retrieve the next page.</p>
    ///   - [`virtual_gateway_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDirectConnectGatewayAssociations::virtual_gateway_id) / [`set_virtual_gateway_id(Option<String>)`](crate::client::fluent_builders::DescribeDirectConnectGatewayAssociations::set_virtual_gateway_id): <p>The ID of the virtual private gateway or transit gateway.</p>
    /// - On success, responds with [`DescribeDirectConnectGatewayAssociationsOutput`](crate::output::DescribeDirectConnectGatewayAssociationsOutput) with field(s):
    ///   - [`direct_connect_gateway_associations(Option<Vec<DirectConnectGatewayAssociation>>)`](crate::output::DescribeDirectConnectGatewayAssociationsOutput::direct_connect_gateway_associations): <p>Information about the associations.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeDirectConnectGatewayAssociationsOutput::next_token): <p>The token to retrieve the next page.</p>
    /// - On failure, responds with [`SdkError<DescribeDirectConnectGatewayAssociationsError>`](crate::error::DescribeDirectConnectGatewayAssociationsError)
    pub fn describe_direct_connect_gateway_associations(
        &self,
    ) -> fluent_builders::DescribeDirectConnectGatewayAssociations {
        fluent_builders::DescribeDirectConnectGatewayAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDirectConnectGatewayAttachments`](crate::client::fluent_builders::DescribeDirectConnectGatewayAttachments) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`direct_connect_gateway_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDirectConnectGatewayAttachments::direct_connect_gateway_id) / [`set_direct_connect_gateway_id(Option<String>)`](crate::client::fluent_builders::DescribeDirectConnectGatewayAttachments::set_direct_connect_gateway_id): <p>The ID of the Direct Connect gateway.</p>
    ///   - [`virtual_interface_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDirectConnectGatewayAttachments::virtual_interface_id) / [`set_virtual_interface_id(Option<String>)`](crate::client::fluent_builders::DescribeDirectConnectGatewayAttachments::set_virtual_interface_id): <p>The ID of the virtual interface.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeDirectConnectGatewayAttachments::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeDirectConnectGatewayAttachments::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>  <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeDirectConnectGatewayAttachments::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeDirectConnectGatewayAttachments::set_next_token): <p>The token provided in the previous call to retrieve the next page.</p>
    /// - On success, responds with [`DescribeDirectConnectGatewayAttachmentsOutput`](crate::output::DescribeDirectConnectGatewayAttachmentsOutput) with field(s):
    ///   - [`direct_connect_gateway_attachments(Option<Vec<DirectConnectGatewayAttachment>>)`](crate::output::DescribeDirectConnectGatewayAttachmentsOutput::direct_connect_gateway_attachments): <p>The attachments.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeDirectConnectGatewayAttachmentsOutput::next_token): <p>The token to retrieve the next page.</p>
    /// - On failure, responds with [`SdkError<DescribeDirectConnectGatewayAttachmentsError>`](crate::error::DescribeDirectConnectGatewayAttachmentsError)
    pub fn describe_direct_connect_gateway_attachments(
        &self,
    ) -> fluent_builders::DescribeDirectConnectGatewayAttachments {
        fluent_builders::DescribeDirectConnectGatewayAttachments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDirectConnectGateways`](crate::client::fluent_builders::DescribeDirectConnectGateways) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`direct_connect_gateway_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDirectConnectGateways::direct_connect_gateway_id) / [`set_direct_connect_gateway_id(Option<String>)`](crate::client::fluent_builders::DescribeDirectConnectGateways::set_direct_connect_gateway_id): <p>The ID of the Direct Connect gateway.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeDirectConnectGateways::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeDirectConnectGateways::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>  <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeDirectConnectGateways::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeDirectConnectGateways::set_next_token): <p>The token provided in the previous call to retrieve the next page.</p>
    /// - On success, responds with [`DescribeDirectConnectGatewaysOutput`](crate::output::DescribeDirectConnectGatewaysOutput) with field(s):
    ///   - [`direct_connect_gateways(Option<Vec<DirectConnectGateway>>)`](crate::output::DescribeDirectConnectGatewaysOutput::direct_connect_gateways): <p>The Direct Connect gateways.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeDirectConnectGatewaysOutput::next_token): <p>The token to retrieve the next page.</p>
    /// - On failure, responds with [`SdkError<DescribeDirectConnectGatewaysError>`](crate::error::DescribeDirectConnectGatewaysError)
    pub fn describe_direct_connect_gateways(
        &self,
    ) -> fluent_builders::DescribeDirectConnectGateways {
        fluent_builders::DescribeDirectConnectGateways::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeHostedConnections`](crate::client::fluent_builders::DescribeHostedConnections) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connection_id(impl Into<String>)`](crate::client::fluent_builders::DescribeHostedConnections::connection_id) / [`set_connection_id(Option<String>)`](crate::client::fluent_builders::DescribeHostedConnections::set_connection_id): <p>The ID of the interconnect or LAG.</p>
    /// - On success, responds with [`DescribeHostedConnectionsOutput`](crate::output::DescribeHostedConnectionsOutput) with field(s):
    ///   - [`connections(Option<Vec<Connection>>)`](crate::output::DescribeHostedConnectionsOutput::connections): <p>The connections.</p>
    /// - On failure, responds with [`SdkError<DescribeHostedConnectionsError>`](crate::error::DescribeHostedConnectionsError)
    pub fn describe_hosted_connections(&self) -> fluent_builders::DescribeHostedConnections {
        fluent_builders::DescribeHostedConnections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeInterconnectLoa`](crate::client::fluent_builders::DescribeInterconnectLoa) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`interconnect_id(impl Into<String>)`](crate::client::fluent_builders::DescribeInterconnectLoa::interconnect_id) / [`set_interconnect_id(Option<String>)`](crate::client::fluent_builders::DescribeInterconnectLoa::set_interconnect_id): <p>The ID of the interconnect.</p>
    ///   - [`provider_name(impl Into<String>)`](crate::client::fluent_builders::DescribeInterconnectLoa::provider_name) / [`set_provider_name(Option<String>)`](crate::client::fluent_builders::DescribeInterconnectLoa::set_provider_name): <p>The name of the service provider who establishes connectivity on your behalf. If you supply this parameter, the LOA-CFA lists the provider name alongside your company name as the requester of the cross connect.</p>
    ///   - [`loa_content_type(LoaContentType)`](crate::client::fluent_builders::DescribeInterconnectLoa::loa_content_type) / [`set_loa_content_type(Option<LoaContentType>)`](crate::client::fluent_builders::DescribeInterconnectLoa::set_loa_content_type): <p>The standard media type for the LOA-CFA document. The only supported value is application/pdf.</p>
    /// - On success, responds with [`DescribeInterconnectLoaOutput`](crate::output::DescribeInterconnectLoaOutput) with field(s):
    ///   - [`loa(Option<Loa>)`](crate::output::DescribeInterconnectLoaOutput::loa): <p>The Letter of Authorization - Connecting Facility Assignment (LOA-CFA).</p>
    /// - On failure, responds with [`SdkError<DescribeInterconnectLoaError>`](crate::error::DescribeInterconnectLoaError)
    pub fn describe_interconnect_loa(&self) -> fluent_builders::DescribeInterconnectLoa {
        fluent_builders::DescribeInterconnectLoa::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeInterconnects`](crate::client::fluent_builders::DescribeInterconnects) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`interconnect_id(impl Into<String>)`](crate::client::fluent_builders::DescribeInterconnects::interconnect_id) / [`set_interconnect_id(Option<String>)`](crate::client::fluent_builders::DescribeInterconnects::set_interconnect_id): <p>The ID of the interconnect.</p>
    /// - On success, responds with [`DescribeInterconnectsOutput`](crate::output::DescribeInterconnectsOutput) with field(s):
    ///   - [`interconnects(Option<Vec<Interconnect>>)`](crate::output::DescribeInterconnectsOutput::interconnects): <p>The interconnects.</p>
    /// - On failure, responds with [`SdkError<DescribeInterconnectsError>`](crate::error::DescribeInterconnectsError)
    pub fn describe_interconnects(&self) -> fluent_builders::DescribeInterconnects {
        fluent_builders::DescribeInterconnects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLags`](crate::client::fluent_builders::DescribeLags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`lag_id(impl Into<String>)`](crate::client::fluent_builders::DescribeLags::lag_id) / [`set_lag_id(Option<String>)`](crate::client::fluent_builders::DescribeLags::set_lag_id): <p>The ID of the LAG.</p>
    /// - On success, responds with [`DescribeLagsOutput`](crate::output::DescribeLagsOutput) with field(s):
    ///   - [`lags(Option<Vec<Lag>>)`](crate::output::DescribeLagsOutput::lags): <p>The LAGs.</p>
    /// - On failure, responds with [`SdkError<DescribeLagsError>`](crate::error::DescribeLagsError)
    pub fn describe_lags(&self) -> fluent_builders::DescribeLags {
        fluent_builders::DescribeLags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLoa`](crate::client::fluent_builders::DescribeLoa) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connection_id(impl Into<String>)`](crate::client::fluent_builders::DescribeLoa::connection_id) / [`set_connection_id(Option<String>)`](crate::client::fluent_builders::DescribeLoa::set_connection_id): <p>The ID of a connection, LAG, or interconnect.</p>
    ///   - [`provider_name(impl Into<String>)`](crate::client::fluent_builders::DescribeLoa::provider_name) / [`set_provider_name(Option<String>)`](crate::client::fluent_builders::DescribeLoa::set_provider_name): <p>The name of the service provider who establishes connectivity on your behalf. If you specify this parameter, the LOA-CFA lists the provider name alongside your company name as the requester of the cross connect.</p>
    ///   - [`loa_content_type(LoaContentType)`](crate::client::fluent_builders::DescribeLoa::loa_content_type) / [`set_loa_content_type(Option<LoaContentType>)`](crate::client::fluent_builders::DescribeLoa::set_loa_content_type): <p>The standard media type for the LOA-CFA document. The only supported value is application/pdf.</p>
    /// - On success, responds with [`DescribeLoaOutput`](crate::output::DescribeLoaOutput) with field(s):
    ///   - [`loa_content(Option<Blob>)`](crate::output::DescribeLoaOutput::loa_content): <p>The binary contents of the LOA-CFA document.</p>
    ///   - [`loa_content_type(Option<LoaContentType>)`](crate::output::DescribeLoaOutput::loa_content_type): <p>The standard media type for the LOA-CFA document. The only supported value is application/pdf.</p>
    /// - On failure, responds with [`SdkError<DescribeLoaError>`](crate::error::DescribeLoaError)
    pub fn describe_loa(&self) -> fluent_builders::DescribeLoa {
        fluent_builders::DescribeLoa::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLocations`](crate::client::fluent_builders::DescribeLocations) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeLocations::send) it.

    /// - On success, responds with [`DescribeLocationsOutput`](crate::output::DescribeLocationsOutput) with field(s):
    ///   - [`locations(Option<Vec<Location>>)`](crate::output::DescribeLocationsOutput::locations): <p>The locations.</p>
    /// - On failure, responds with [`SdkError<DescribeLocationsError>`](crate::error::DescribeLocationsError)
    pub fn describe_locations(&self) -> fluent_builders::DescribeLocations {
        fluent_builders::DescribeLocations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeRouterConfiguration`](crate::client::fluent_builders::DescribeRouterConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`virtual_interface_id(impl Into<String>)`](crate::client::fluent_builders::DescribeRouterConfiguration::virtual_interface_id) / [`set_virtual_interface_id(Option<String>)`](crate::client::fluent_builders::DescribeRouterConfiguration::set_virtual_interface_id): <p>The ID of the virtual interface.</p>
    ///   - [`router_type_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeRouterConfiguration::router_type_identifier) / [`set_router_type_identifier(Option<String>)`](crate::client::fluent_builders::DescribeRouterConfiguration::set_router_type_identifier): <p>Identifies the router by a combination of vendor, platform, and software version. For example, <code>CiscoSystemsInc-2900SeriesRouters-IOS124</code>.</p>
    /// - On success, responds with [`DescribeRouterConfigurationOutput`](crate::output::DescribeRouterConfigurationOutput) with field(s):
    ///   - [`customer_router_config(Option<String>)`](crate::output::DescribeRouterConfigurationOutput::customer_router_config): <p>The customer router configuration.</p>
    ///   - [`router(Option<RouterType>)`](crate::output::DescribeRouterConfigurationOutput::router): <p>The details about the router.</p>
    ///   - [`virtual_interface_id(Option<String>)`](crate::output::DescribeRouterConfigurationOutput::virtual_interface_id): <p>The ID assigned to the virtual interface.</p>
    ///   - [`virtual_interface_name(Option<String>)`](crate::output::DescribeRouterConfigurationOutput::virtual_interface_name): <p>Provides the details about a virtual interface's router.</p>
    /// - On failure, responds with [`SdkError<DescribeRouterConfigurationError>`](crate::error::DescribeRouterConfigurationError)
    pub fn describe_router_configuration(&self) -> fluent_builders::DescribeRouterConfiguration {
        fluent_builders::DescribeRouterConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTags`](crate::client::fluent_builders::DescribeTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arns(Vec<String>)`](crate::client::fluent_builders::DescribeTags::resource_arns) / [`set_resource_arns(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeTags::set_resource_arns): <p>The Amazon Resource Names (ARNs) of the resources.</p>
    /// - On success, responds with [`DescribeTagsOutput`](crate::output::DescribeTagsOutput) with field(s):
    ///   - [`resource_tags(Option<Vec<ResourceTag>>)`](crate::output::DescribeTagsOutput::resource_tags): <p>Information about the tags.</p>
    /// - On failure, responds with [`SdkError<DescribeTagsError>`](crate::error::DescribeTagsError)
    pub fn describe_tags(&self) -> fluent_builders::DescribeTags {
        fluent_builders::DescribeTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeVirtualGateways`](crate::client::fluent_builders::DescribeVirtualGateways) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeVirtualGateways::send) it.

    /// - On success, responds with [`DescribeVirtualGatewaysOutput`](crate::output::DescribeVirtualGatewaysOutput) with field(s):
    ///   - [`virtual_gateways(Option<Vec<VirtualGateway>>)`](crate::output::DescribeVirtualGatewaysOutput::virtual_gateways): <p>The virtual private gateways.</p>
    /// - On failure, responds with [`SdkError<DescribeVirtualGatewaysError>`](crate::error::DescribeVirtualGatewaysError)
    pub fn describe_virtual_gateways(&self) -> fluent_builders::DescribeVirtualGateways {
        fluent_builders::DescribeVirtualGateways::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeVirtualInterfaces`](crate::client::fluent_builders::DescribeVirtualInterfaces) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connection_id(impl Into<String>)`](crate::client::fluent_builders::DescribeVirtualInterfaces::connection_id) / [`set_connection_id(Option<String>)`](crate::client::fluent_builders::DescribeVirtualInterfaces::set_connection_id): <p>The ID of the connection.</p>
    ///   - [`virtual_interface_id(impl Into<String>)`](crate::client::fluent_builders::DescribeVirtualInterfaces::virtual_interface_id) / [`set_virtual_interface_id(Option<String>)`](crate::client::fluent_builders::DescribeVirtualInterfaces::set_virtual_interface_id): <p>The ID of the virtual interface.</p>
    /// - On success, responds with [`DescribeVirtualInterfacesOutput`](crate::output::DescribeVirtualInterfacesOutput) with field(s):
    ///   - [`virtual_interfaces(Option<Vec<VirtualInterface>>)`](crate::output::DescribeVirtualInterfacesOutput::virtual_interfaces): <p>The virtual interfaces</p>
    /// - On failure, responds with [`SdkError<DescribeVirtualInterfacesError>`](crate::error::DescribeVirtualInterfacesError)
    pub fn describe_virtual_interfaces(&self) -> fluent_builders::DescribeVirtualInterfaces {
        fluent_builders::DescribeVirtualInterfaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateConnectionFromLag`](crate::client::fluent_builders::DisassociateConnectionFromLag) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connection_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateConnectionFromLag::connection_id) / [`set_connection_id(Option<String>)`](crate::client::fluent_builders::DisassociateConnectionFromLag::set_connection_id): <p>The ID of the connection.</p>
    ///   - [`lag_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateConnectionFromLag::lag_id) / [`set_lag_id(Option<String>)`](crate::client::fluent_builders::DisassociateConnectionFromLag::set_lag_id): <p>The ID of the LAG.</p>
    /// - On success, responds with [`DisassociateConnectionFromLagOutput`](crate::output::DisassociateConnectionFromLagOutput) with field(s):
    ///   - [`owner_account(Option<String>)`](crate::output::DisassociateConnectionFromLagOutput::owner_account): <p>The ID of the Amazon Web Services account that owns the connection.</p>
    ///   - [`connection_id(Option<String>)`](crate::output::DisassociateConnectionFromLagOutput::connection_id): <p>The ID of the connection.</p>
    ///   - [`connection_name(Option<String>)`](crate::output::DisassociateConnectionFromLagOutput::connection_name): <p>The name of the connection.</p>
    ///   - [`connection_state(Option<ConnectionState>)`](crate::output::DisassociateConnectionFromLagOutput::connection_state): <p>The state of the connection. The following are the possible values:</p>  <ul>   <li> <p> <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p> </li>   <li> <p> <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p> </li>   <li> <p> <code>pending</code>: The connection has been approved and is being initialized.</p> </li>   <li> <p> <code>available</code>: The network link is up and the connection is ready for use.</p> </li>   <li> <p> <code>down</code>: The network link is down.</p> </li>   <li> <p> <code>deleting</code>: The connection is being deleted.</p> </li>   <li> <p> <code>deleted</code>: The connection has been deleted.</p> </li>   <li> <p> <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p> </li>   <li> <p> <code>unknown</code>: The state of the connection is not available.</p> </li>  </ul>
    ///   - [`region(Option<String>)`](crate::output::DisassociateConnectionFromLagOutput::region): <p>The Amazon Web Services Region where the connection is located.</p>
    ///   - [`location(Option<String>)`](crate::output::DisassociateConnectionFromLagOutput::location): <p>The location of the connection.</p>
    ///   - [`bandwidth(Option<String>)`](crate::output::DisassociateConnectionFromLagOutput::bandwidth): <p>The bandwidth of the connection.</p>
    ///   - [`vlan(i32)`](crate::output::DisassociateConnectionFromLagOutput::vlan): <p>The ID of the VLAN.</p>
    ///   - [`partner_name(Option<String>)`](crate::output::DisassociateConnectionFromLagOutput::partner_name): <p>The name of the Direct Connect service provider associated with the connection.</p>
    ///   - [`loa_issue_time(Option<DateTime>)`](crate::output::DisassociateConnectionFromLagOutput::loa_issue_time): <p>The time of the most recent call to <code>DescribeLoa</code> for this connection.</p>
    ///   - [`lag_id(Option<String>)`](crate::output::DisassociateConnectionFromLagOutput::lag_id): <p>The ID of the LAG.</p>
    ///   - [`aws_device(Option<String>)`](crate::output::DisassociateConnectionFromLagOutput::aws_device): <p>The Direct Connect endpoint on which the physical connection terminates.</p>
    ///   - [`jumbo_frame_capable(Option<bool>)`](crate::output::DisassociateConnectionFromLagOutput::jumbo_frame_capable): <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    ///   - [`aws_device_v2(Option<String>)`](crate::output::DisassociateConnectionFromLagOutput::aws_device_v2): <p>The Direct Connect endpoint that terminates the physical connection.</p>
    ///   - [`aws_logical_device_id(Option<String>)`](crate::output::DisassociateConnectionFromLagOutput::aws_logical_device_id): <p>The Direct Connect endpoint that terminates the logical connection. This device might be different than the device that terminates the physical connection.</p>
    ///   - [`has_logical_redundancy(Option<HasLogicalRedundancy>)`](crate::output::DisassociateConnectionFromLagOutput::has_logical_redundancy): <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::DisassociateConnectionFromLagOutput::tags): <p>The tags associated with the connection.</p>
    ///   - [`provider_name(Option<String>)`](crate::output::DisassociateConnectionFromLagOutput::provider_name): <p>The name of the service provider associated with the connection.</p>
    ///   - [`mac_sec_capable(Option<bool>)`](crate::output::DisassociateConnectionFromLagOutput::mac_sec_capable): <p>Indicates whether the connection supports MAC Security (MACsec).</p>
    ///   - [`port_encryption_status(Option<String>)`](crate::output::DisassociateConnectionFromLagOutput::port_encryption_status): <p>The MAC Security (MACsec) port link status of the connection.</p>  <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
    ///   - [`encryption_mode(Option<String>)`](crate::output::DisassociateConnectionFromLagOutput::encryption_mode): <p>The MAC Security (MACsec) connection encryption mode.</p>  <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
    ///   - [`mac_sec_keys(Option<Vec<MacSecKey>>)`](crate::output::DisassociateConnectionFromLagOutput::mac_sec_keys): <p>The MAC Security (MACsec) security keys associated with the connection.</p>
    /// - On failure, responds with [`SdkError<DisassociateConnectionFromLagError>`](crate::error::DisassociateConnectionFromLagError)
    pub fn disassociate_connection_from_lag(
        &self,
    ) -> fluent_builders::DisassociateConnectionFromLag {
        fluent_builders::DisassociateConnectionFromLag::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateMacSecKey`](crate::client::fluent_builders::DisassociateMacSecKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connection_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateMacSecKey::connection_id) / [`set_connection_id(Option<String>)`](crate::client::fluent_builders::DisassociateMacSecKey::set_connection_id): <p>The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).</p>  <p>You can use <code>DescribeConnections</code> or <code>DescribeLags</code> to retrieve connection ID.</p>
    ///   - [`secret_arn(impl Into<String>)`](crate::client::fluent_builders::DisassociateMacSecKey::secret_arn) / [`set_secret_arn(Option<String>)`](crate::client::fluent_builders::DisassociateMacSecKey::set_secret_arn): <p>The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key.</p>  <p>You can use <code>DescribeConnections</code> to retrieve the ARN of the MAC Security (MACsec) secret key.</p>
    /// - On success, responds with [`DisassociateMacSecKeyOutput`](crate::output::DisassociateMacSecKeyOutput) with field(s):
    ///   - [`connection_id(Option<String>)`](crate::output::DisassociateMacSecKeyOutput::connection_id): <p>The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).</p>
    ///   - [`mac_sec_keys(Option<Vec<MacSecKey>>)`](crate::output::DisassociateMacSecKeyOutput::mac_sec_keys): <p>The MAC Security (MACsec) security keys no longer associated with the dedicated connection.</p>
    /// - On failure, responds with [`SdkError<DisassociateMacSecKeyError>`](crate::error::DisassociateMacSecKeyError)
    pub fn disassociate_mac_sec_key(&self) -> fluent_builders::DisassociateMacSecKey {
        fluent_builders::DisassociateMacSecKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListVirtualInterfaceTestHistory`](crate::client::fluent_builders::ListVirtualInterfaceTestHistory) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`test_id(impl Into<String>)`](crate::client::fluent_builders::ListVirtualInterfaceTestHistory::test_id) / [`set_test_id(Option<String>)`](crate::client::fluent_builders::ListVirtualInterfaceTestHistory::set_test_id): <p>The ID of the virtual interface failover test.</p>
    ///   - [`virtual_interface_id(impl Into<String>)`](crate::client::fluent_builders::ListVirtualInterfaceTestHistory::virtual_interface_id) / [`set_virtual_interface_id(Option<String>)`](crate::client::fluent_builders::ListVirtualInterfaceTestHistory::set_virtual_interface_id): <p>The ID of the virtual interface that was tested.</p>
    ///   - [`bgp_peers(Vec<String>)`](crate::client::fluent_builders::ListVirtualInterfaceTestHistory::bgp_peers) / [`set_bgp_peers(Option<Vec<String>>)`](crate::client::fluent_builders::ListVirtualInterfaceTestHistory::set_bgp_peers): <p>The BGP peers that were placed in the DOWN state during the virtual interface failover test.</p>
    ///   - [`status(impl Into<String>)`](crate::client::fluent_builders::ListVirtualInterfaceTestHistory::status) / [`set_status(Option<String>)`](crate::client::fluent_builders::ListVirtualInterfaceTestHistory::set_status): <p>The status of the virtual interface failover test.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListVirtualInterfaceTestHistory::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListVirtualInterfaceTestHistory::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>  <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListVirtualInterfaceTestHistory::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListVirtualInterfaceTestHistory::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`ListVirtualInterfaceTestHistoryOutput`](crate::output::ListVirtualInterfaceTestHistoryOutput) with field(s):
    ///   - [`virtual_interface_test_history(Option<Vec<VirtualInterfaceTestHistory>>)`](crate::output::ListVirtualInterfaceTestHistoryOutput::virtual_interface_test_history): <p>The ID of the tested virtual interface.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListVirtualInterfaceTestHistoryOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListVirtualInterfaceTestHistoryError>`](crate::error::ListVirtualInterfaceTestHistoryError)
    pub fn list_virtual_interface_test_history(
        &self,
    ) -> fluent_builders::ListVirtualInterfaceTestHistory {
        fluent_builders::ListVirtualInterfaceTestHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartBgpFailoverTest`](crate::client::fluent_builders::StartBgpFailoverTest) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`virtual_interface_id(impl Into<String>)`](crate::client::fluent_builders::StartBgpFailoverTest::virtual_interface_id) / [`set_virtual_interface_id(Option<String>)`](crate::client::fluent_builders::StartBgpFailoverTest::set_virtual_interface_id): <p>The ID of the virtual interface you want to test.</p>
    ///   - [`bgp_peers(Vec<String>)`](crate::client::fluent_builders::StartBgpFailoverTest::bgp_peers) / [`set_bgp_peers(Option<Vec<String>>)`](crate::client::fluent_builders::StartBgpFailoverTest::set_bgp_peers): <p>The BGP peers to place in the DOWN state.</p>
    ///   - [`test_duration_in_minutes(i32)`](crate::client::fluent_builders::StartBgpFailoverTest::test_duration_in_minutes) / [`set_test_duration_in_minutes(Option<i32>)`](crate::client::fluent_builders::StartBgpFailoverTest::set_test_duration_in_minutes): <p>The time in minutes that the virtual interface failover test will last.</p>  <p>Maximum value: 180 minutes (3 hours).</p>  <p>Default: 180 minutes (3 hours).</p>
    /// - On success, responds with [`StartBgpFailoverTestOutput`](crate::output::StartBgpFailoverTestOutput) with field(s):
    ///   - [`virtual_interface_test(Option<VirtualInterfaceTestHistory>)`](crate::output::StartBgpFailoverTestOutput::virtual_interface_test): <p>Information about the virtual interface failover test.</p>
    /// - On failure, responds with [`SdkError<StartBgpFailoverTestError>`](crate::error::StartBgpFailoverTestError)
    pub fn start_bgp_failover_test(&self) -> fluent_builders::StartBgpFailoverTest {
        fluent_builders::StartBgpFailoverTest::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopBgpFailoverTest`](crate::client::fluent_builders::StopBgpFailoverTest) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`virtual_interface_id(impl Into<String>)`](crate::client::fluent_builders::StopBgpFailoverTest::virtual_interface_id) / [`set_virtual_interface_id(Option<String>)`](crate::client::fluent_builders::StopBgpFailoverTest::set_virtual_interface_id): <p>The ID of the virtual interface you no longer want to test.</p>
    /// - On success, responds with [`StopBgpFailoverTestOutput`](crate::output::StopBgpFailoverTestOutput) with field(s):
    ///   - [`virtual_interface_test(Option<VirtualInterfaceTestHistory>)`](crate::output::StopBgpFailoverTestOutput::virtual_interface_test): <p>Information about the virtual interface failover test.</p>
    /// - On failure, responds with [`SdkError<StopBgpFailoverTestError>`](crate::error::StopBgpFailoverTestError)
    pub fn stop_bgp_failover_test(&self) -> fluent_builders::StopBgpFailoverTest {
        fluent_builders::StopBgpFailoverTest::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags to add.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The tag keys of the tags to remove.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateConnection`](crate::client::fluent_builders::UpdateConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connection_id(impl Into<String>)`](crate::client::fluent_builders::UpdateConnection::connection_id) / [`set_connection_id(Option<String>)`](crate::client::fluent_builders::UpdateConnection::set_connection_id): <p>The ID of the dedicated connection.</p>  <p>You can use <code>DescribeConnections</code> to retrieve the connection ID.</p>
    ///   - [`connection_name(impl Into<String>)`](crate::client::fluent_builders::UpdateConnection::connection_name) / [`set_connection_name(Option<String>)`](crate::client::fluent_builders::UpdateConnection::set_connection_name): <p>The name of the connection.</p>
    ///   - [`encryption_mode(impl Into<String>)`](crate::client::fluent_builders::UpdateConnection::encryption_mode) / [`set_encryption_mode(Option<String>)`](crate::client::fluent_builders::UpdateConnection::set_encryption_mode): <p>The connection MAC Security (MACsec) encryption mode.</p>  <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
    /// - On success, responds with [`UpdateConnectionOutput`](crate::output::UpdateConnectionOutput) with field(s):
    ///   - [`owner_account(Option<String>)`](crate::output::UpdateConnectionOutput::owner_account): <p>The ID of the Amazon Web Services account that owns the connection.</p>
    ///   - [`connection_id(Option<String>)`](crate::output::UpdateConnectionOutput::connection_id): <p>The ID of the connection.</p>
    ///   - [`connection_name(Option<String>)`](crate::output::UpdateConnectionOutput::connection_name): <p>The name of the connection.</p>
    ///   - [`connection_state(Option<ConnectionState>)`](crate::output::UpdateConnectionOutput::connection_state): <p>The state of the connection. The following are the possible values:</p>  <ul>   <li> <p> <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p> </li>   <li> <p> <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p> </li>   <li> <p> <code>pending</code>: The connection has been approved and is being initialized.</p> </li>   <li> <p> <code>available</code>: The network link is up and the connection is ready for use.</p> </li>   <li> <p> <code>down</code>: The network link is down.</p> </li>   <li> <p> <code>deleting</code>: The connection is being deleted.</p> </li>   <li> <p> <code>deleted</code>: The connection has been deleted.</p> </li>   <li> <p> <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p> </li>   <li> <p> <code>unknown</code>: The state of the connection is not available.</p> </li>  </ul>
    ///   - [`region(Option<String>)`](crate::output::UpdateConnectionOutput::region): <p>The Amazon Web Services Region where the connection is located.</p>
    ///   - [`location(Option<String>)`](crate::output::UpdateConnectionOutput::location): <p>The location of the connection.</p>
    ///   - [`bandwidth(Option<String>)`](crate::output::UpdateConnectionOutput::bandwidth): <p>The bandwidth of the connection.</p>
    ///   - [`vlan(i32)`](crate::output::UpdateConnectionOutput::vlan): <p>The ID of the VLAN.</p>
    ///   - [`partner_name(Option<String>)`](crate::output::UpdateConnectionOutput::partner_name): <p>The name of the Direct Connect service provider associated with the connection.</p>
    ///   - [`loa_issue_time(Option<DateTime>)`](crate::output::UpdateConnectionOutput::loa_issue_time): <p>The time of the most recent call to <code>DescribeLoa</code> for this connection.</p>
    ///   - [`lag_id(Option<String>)`](crate::output::UpdateConnectionOutput::lag_id): <p>The ID of the LAG.</p>
    ///   - [`aws_device(Option<String>)`](crate::output::UpdateConnectionOutput::aws_device): <p>The Direct Connect endpoint on which the physical connection terminates.</p>
    ///   - [`jumbo_frame_capable(Option<bool>)`](crate::output::UpdateConnectionOutput::jumbo_frame_capable): <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    ///   - [`aws_device_v2(Option<String>)`](crate::output::UpdateConnectionOutput::aws_device_v2): <p>The Direct Connect endpoint that terminates the physical connection.</p>
    ///   - [`aws_logical_device_id(Option<String>)`](crate::output::UpdateConnectionOutput::aws_logical_device_id): <p>The Direct Connect endpoint that terminates the logical connection. This device might be different than the device that terminates the physical connection.</p>
    ///   - [`has_logical_redundancy(Option<HasLogicalRedundancy>)`](crate::output::UpdateConnectionOutput::has_logical_redundancy): <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::UpdateConnectionOutput::tags): <p>The tags associated with the connection.</p>
    ///   - [`provider_name(Option<String>)`](crate::output::UpdateConnectionOutput::provider_name): <p>The name of the service provider associated with the connection.</p>
    ///   - [`mac_sec_capable(Option<bool>)`](crate::output::UpdateConnectionOutput::mac_sec_capable): <p>Indicates whether the connection supports MAC Security (MACsec).</p>
    ///   - [`port_encryption_status(Option<String>)`](crate::output::UpdateConnectionOutput::port_encryption_status): <p>The MAC Security (MACsec) port link status of the connection.</p>  <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
    ///   - [`encryption_mode(Option<String>)`](crate::output::UpdateConnectionOutput::encryption_mode): <p>The MAC Security (MACsec) connection encryption mode.</p>  <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
    ///   - [`mac_sec_keys(Option<Vec<MacSecKey>>)`](crate::output::UpdateConnectionOutput::mac_sec_keys): <p>The MAC Security (MACsec) security keys associated with the connection.</p>
    /// - On failure, responds with [`SdkError<UpdateConnectionError>`](crate::error::UpdateConnectionError)
    pub fn update_connection(&self) -> fluent_builders::UpdateConnection {
        fluent_builders::UpdateConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDirectConnectGateway`](crate::client::fluent_builders::UpdateDirectConnectGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`direct_connect_gateway_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDirectConnectGateway::direct_connect_gateway_id) / [`set_direct_connect_gateway_id(Option<String>)`](crate::client::fluent_builders::UpdateDirectConnectGateway::set_direct_connect_gateway_id): <p>The ID of the Direct Connect gateway to update.</p>
    ///   - [`new_direct_connect_gateway_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDirectConnectGateway::new_direct_connect_gateway_name) / [`set_new_direct_connect_gateway_name(Option<String>)`](crate::client::fluent_builders::UpdateDirectConnectGateway::set_new_direct_connect_gateway_name): <p>The new name for the Direct Connect gateway.</p>
    /// - On success, responds with [`UpdateDirectConnectGatewayOutput`](crate::output::UpdateDirectConnectGatewayOutput) with field(s):
    ///   - [`direct_connect_gateway(Option<DirectConnectGateway>)`](crate::output::UpdateDirectConnectGatewayOutput::direct_connect_gateway): <p>Information about a Direct Connect gateway, which enables you to connect virtual interfaces and virtual private gateway or transit gateways.</p>
    /// - On failure, responds with [`SdkError<UpdateDirectConnectGatewayError>`](crate::error::UpdateDirectConnectGatewayError)
    pub fn update_direct_connect_gateway(&self) -> fluent_builders::UpdateDirectConnectGateway {
        fluent_builders::UpdateDirectConnectGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDirectConnectGatewayAssociation`](crate::client::fluent_builders::UpdateDirectConnectGatewayAssociation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`association_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDirectConnectGatewayAssociation::association_id) / [`set_association_id(Option<String>)`](crate::client::fluent_builders::UpdateDirectConnectGatewayAssociation::set_association_id): <p>The ID of the Direct Connect gateway association.</p>
    ///   - [`add_allowed_prefixes_to_direct_connect_gateway(Vec<RouteFilterPrefix>)`](crate::client::fluent_builders::UpdateDirectConnectGatewayAssociation::add_allowed_prefixes_to_direct_connect_gateway) / [`set_add_allowed_prefixes_to_direct_connect_gateway(Option<Vec<RouteFilterPrefix>>)`](crate::client::fluent_builders::UpdateDirectConnectGatewayAssociation::set_add_allowed_prefixes_to_direct_connect_gateway): <p>The Amazon VPC prefixes to advertise to the Direct Connect gateway.</p>
    ///   - [`remove_allowed_prefixes_to_direct_connect_gateway(Vec<RouteFilterPrefix>)`](crate::client::fluent_builders::UpdateDirectConnectGatewayAssociation::remove_allowed_prefixes_to_direct_connect_gateway) / [`set_remove_allowed_prefixes_to_direct_connect_gateway(Option<Vec<RouteFilterPrefix>>)`](crate::client::fluent_builders::UpdateDirectConnectGatewayAssociation::set_remove_allowed_prefixes_to_direct_connect_gateway): <p>The Amazon VPC prefixes to no longer advertise to the Direct Connect gateway.</p>
    /// - On success, responds with [`UpdateDirectConnectGatewayAssociationOutput`](crate::output::UpdateDirectConnectGatewayAssociationOutput) with field(s):
    ///   - [`direct_connect_gateway_association(Option<DirectConnectGatewayAssociation>)`](crate::output::UpdateDirectConnectGatewayAssociationOutput::direct_connect_gateway_association): <p>Information about an association between a Direct Connect gateway and a virtual private gateway or transit gateway.</p>
    /// - On failure, responds with [`SdkError<UpdateDirectConnectGatewayAssociationError>`](crate::error::UpdateDirectConnectGatewayAssociationError)
    pub fn update_direct_connect_gateway_association(
        &self,
    ) -> fluent_builders::UpdateDirectConnectGatewayAssociation {
        fluent_builders::UpdateDirectConnectGatewayAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateLag`](crate::client::fluent_builders::UpdateLag) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`lag_id(impl Into<String>)`](crate::client::fluent_builders::UpdateLag::lag_id) / [`set_lag_id(Option<String>)`](crate::client::fluent_builders::UpdateLag::set_lag_id): <p>The ID of the LAG.</p>
    ///   - [`lag_name(impl Into<String>)`](crate::client::fluent_builders::UpdateLag::lag_name) / [`set_lag_name(Option<String>)`](crate::client::fluent_builders::UpdateLag::set_lag_name): <p>The name of the LAG.</p>
    ///   - [`minimum_links(i32)`](crate::client::fluent_builders::UpdateLag::minimum_links) / [`set_minimum_links(i32)`](crate::client::fluent_builders::UpdateLag::set_minimum_links): <p>The minimum number of physical connections that must be operational for the LAG itself to be operational.</p>
    ///   - [`encryption_mode(impl Into<String>)`](crate::client::fluent_builders::UpdateLag::encryption_mode) / [`set_encryption_mode(Option<String>)`](crate::client::fluent_builders::UpdateLag::set_encryption_mode): <p>The LAG MAC Security (MACsec) encryption mode.</p>  <p>Amazon Web Services applies the value to all connections which are part of the LAG.</p>
    /// - On success, responds with [`UpdateLagOutput`](crate::output::UpdateLagOutput) with field(s):
    ///   - [`connections_bandwidth(Option<String>)`](crate::output::UpdateLagOutput::connections_bandwidth): <p>The individual bandwidth of the physical connections bundled by the LAG. The possible values are 1Gbps and 10Gbps. </p>
    ///   - [`number_of_connections(i32)`](crate::output::UpdateLagOutput::number_of_connections): <p>The number of physical dedicated connections bundled by the LAG, up to a maximum of 10.</p>
    ///   - [`lag_id(Option<String>)`](crate::output::UpdateLagOutput::lag_id): <p>The ID of the LAG.</p>
    ///   - [`owner_account(Option<String>)`](crate::output::UpdateLagOutput::owner_account): <p>The ID of the Amazon Web Services account that owns the LAG.</p>
    ///   - [`lag_name(Option<String>)`](crate::output::UpdateLagOutput::lag_name): <p>The name of the LAG.</p>
    ///   - [`lag_state(Option<LagState>)`](crate::output::UpdateLagOutput::lag_state): <p>The state of the LAG. The following are the possible values:</p>  <ul>   <li> <p> <code>requested</code>: The initial state of a LAG. The LAG stays in the requested state until the Letter of Authorization (LOA) is available.</p> </li>   <li> <p> <code>pending</code>: The LAG has been approved and is being initialized.</p> </li>   <li> <p> <code>available</code>: The network link is established and the LAG is ready for use.</p> </li>   <li> <p> <code>down</code>: The network link is down.</p> </li>   <li> <p> <code>deleting</code>: The LAG is being deleted.</p> </li>   <li> <p> <code>deleted</code>: The LAG is deleted.</p> </li>   <li> <p> <code>unknown</code>: The state of the LAG is not available.</p> </li>  </ul>
    ///   - [`location(Option<String>)`](crate::output::UpdateLagOutput::location): <p>The location of the LAG.</p>
    ///   - [`region(Option<String>)`](crate::output::UpdateLagOutput::region): <p>The Amazon Web Services Region where the connection is located.</p>
    ///   - [`minimum_links(i32)`](crate::output::UpdateLagOutput::minimum_links): <p>The minimum number of physical dedicated connections that must be operational for the LAG itself to be operational.</p>
    ///   - [`aws_device(Option<String>)`](crate::output::UpdateLagOutput::aws_device): <p>The Direct Connect endpoint that hosts the LAG.</p>
    ///   - [`aws_device_v2(Option<String>)`](crate::output::UpdateLagOutput::aws_device_v2): <p>The Direct Connect endpoint that hosts the LAG.</p>
    ///   - [`aws_logical_device_id(Option<String>)`](crate::output::UpdateLagOutput::aws_logical_device_id): <p>The Direct Connect endpoint that terminates the logical connection. This device might be different than the device that terminates the physical connection.</p>
    ///   - [`connections(Option<Vec<Connection>>)`](crate::output::UpdateLagOutput::connections): <p>The connections bundled by the LAG.</p>
    ///   - [`allows_hosted_connections(bool)`](crate::output::UpdateLagOutput::allows_hosted_connections): <p>Indicates whether the LAG can host other connections.</p>
    ///   - [`jumbo_frame_capable(Option<bool>)`](crate::output::UpdateLagOutput::jumbo_frame_capable): <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    ///   - [`has_logical_redundancy(Option<HasLogicalRedundancy>)`](crate::output::UpdateLagOutput::has_logical_redundancy): <p>Indicates whether the LAG supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::UpdateLagOutput::tags): <p>The tags associated with the LAG.</p>
    ///   - [`provider_name(Option<String>)`](crate::output::UpdateLagOutput::provider_name): <p>The name of the service provider associated with the LAG.</p>
    ///   - [`mac_sec_capable(Option<bool>)`](crate::output::UpdateLagOutput::mac_sec_capable): <p>Indicates whether the LAG supports MAC Security (MACsec).</p>
    ///   - [`encryption_mode(Option<String>)`](crate::output::UpdateLagOutput::encryption_mode): <p>The LAG MAC Security (MACsec) encryption mode.</p>  <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
    ///   - [`mac_sec_keys(Option<Vec<MacSecKey>>)`](crate::output::UpdateLagOutput::mac_sec_keys): <p>The MAC Security (MACsec) security keys associated with the LAG.</p>
    /// - On failure, responds with [`SdkError<UpdateLagError>`](crate::error::UpdateLagError)
    pub fn update_lag(&self) -> fluent_builders::UpdateLag {
        fluent_builders::UpdateLag::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateVirtualInterfaceAttributes`](crate::client::fluent_builders::UpdateVirtualInterfaceAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`virtual_interface_id(impl Into<String>)`](crate::client::fluent_builders::UpdateVirtualInterfaceAttributes::virtual_interface_id) / [`set_virtual_interface_id(Option<String>)`](crate::client::fluent_builders::UpdateVirtualInterfaceAttributes::set_virtual_interface_id): <p>The ID of the virtual private interface.</p>
    ///   - [`mtu(i32)`](crate::client::fluent_builders::UpdateVirtualInterfaceAttributes::mtu) / [`set_mtu(Option<i32>)`](crate::client::fluent_builders::UpdateVirtualInterfaceAttributes::set_mtu): <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
    ///   - [`enable_site_link(bool)`](crate::client::fluent_builders::UpdateVirtualInterfaceAttributes::enable_site_link) / [`set_enable_site_link(Option<bool>)`](crate::client::fluent_builders::UpdateVirtualInterfaceAttributes::set_enable_site_link): <p>Indicates whether to enable or disable SiteLink.</p>
    ///   - [`virtual_interface_name(impl Into<String>)`](crate::client::fluent_builders::UpdateVirtualInterfaceAttributes::virtual_interface_name) / [`set_virtual_interface_name(Option<String>)`](crate::client::fluent_builders::UpdateVirtualInterfaceAttributes::set_virtual_interface_name): <p>The name of the virtual private interface.</p>
    /// - On success, responds with [`UpdateVirtualInterfaceAttributesOutput`](crate::output::UpdateVirtualInterfaceAttributesOutput) with field(s):
    ///   - [`owner_account(Option<String>)`](crate::output::UpdateVirtualInterfaceAttributesOutput::owner_account): <p>The ID of the Amazon Web Services account that owns the virtual interface.</p>
    ///   - [`virtual_interface_id(Option<String>)`](crate::output::UpdateVirtualInterfaceAttributesOutput::virtual_interface_id): <p>The ID of the virtual interface.</p>
    ///   - [`location(Option<String>)`](crate::output::UpdateVirtualInterfaceAttributesOutput::location): <p>The location of the connection.</p>
    ///   - [`connection_id(Option<String>)`](crate::output::UpdateVirtualInterfaceAttributesOutput::connection_id): <p>The ID of the connection.</p>
    ///   - [`virtual_interface_type(Option<String>)`](crate::output::UpdateVirtualInterfaceAttributesOutput::virtual_interface_type): <p>The type of virtual interface. The possible values are <code>private</code> and <code>public</code>.</p>
    ///   - [`virtual_interface_name(Option<String>)`](crate::output::UpdateVirtualInterfaceAttributesOutput::virtual_interface_name): <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
    ///   - [`vlan(i32)`](crate::output::UpdateVirtualInterfaceAttributesOutput::vlan): <p>The ID of the VLAN.</p>
    ///   - [`asn(i32)`](crate::output::UpdateVirtualInterfaceAttributesOutput::asn): <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>  <p>The valid values are 1-2147483647.</p>
    ///   - [`amazon_side_asn(Option<i64>)`](crate::output::UpdateVirtualInterfaceAttributesOutput::amazon_side_asn): <p>The autonomous system number (ASN) for the Amazon side of the connection.</p>
    ///   - [`auth_key(Option<String>)`](crate::output::UpdateVirtualInterfaceAttributesOutput::auth_key): <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
    ///   - [`amazon_address(Option<String>)`](crate::output::UpdateVirtualInterfaceAttributesOutput::amazon_address): <p>The IP address assigned to the Amazon interface.</p>
    ///   - [`customer_address(Option<String>)`](crate::output::UpdateVirtualInterfaceAttributesOutput::customer_address): <p>The IP address assigned to the customer interface.</p>
    ///   - [`address_family(Option<AddressFamily>)`](crate::output::UpdateVirtualInterfaceAttributesOutput::address_family): <p>The address family for the BGP peer.</p>
    ///   - [`virtual_interface_state(Option<VirtualInterfaceState>)`](crate::output::UpdateVirtualInterfaceAttributesOutput::virtual_interface_state): <p>The state of the virtual interface. The following are the possible values:</p>  <ul>   <li> <p> <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p> </li>   <li> <p> <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p> </li>   <li> <p> <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p> </li>   <li> <p> <code>available</code>: A virtual interface that is able to forward traffic.</p> </li>   <li> <p> <code>down</code>: A virtual interface that is BGP down.</p> </li>   <li> <p> <code>deleting</code>: A virtual interface is in this state immediately after calling <code>DeleteVirtualInterface</code> until it can no longer forward traffic.</p> </li>   <li> <p> <code>deleted</code>: A virtual interface that cannot forward traffic.</p> </li>   <li> <p> <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p> </li>   <li> <p> <code>unknown</code>: The state of the virtual interface is not available.</p> </li>  </ul>
    ///   - [`customer_router_config(Option<String>)`](crate::output::UpdateVirtualInterfaceAttributesOutput::customer_router_config): <p>The customer router configuration.</p>
    ///   - [`mtu(Option<i32>)`](crate::output::UpdateVirtualInterfaceAttributesOutput::mtu): <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
    ///   - [`jumbo_frame_capable(Option<bool>)`](crate::output::UpdateVirtualInterfaceAttributesOutput::jumbo_frame_capable): <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    ///   - [`virtual_gateway_id(Option<String>)`](crate::output::UpdateVirtualInterfaceAttributesOutput::virtual_gateway_id): <p>The ID of the virtual private gateway. Applies only to private virtual interfaces.</p>
    ///   - [`direct_connect_gateway_id(Option<String>)`](crate::output::UpdateVirtualInterfaceAttributesOutput::direct_connect_gateway_id): <p>The ID of the Direct Connect gateway.</p>
    ///   - [`route_filter_prefixes(Option<Vec<RouteFilterPrefix>>)`](crate::output::UpdateVirtualInterfaceAttributesOutput::route_filter_prefixes): <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
    ///   - [`bgp_peers(Option<Vec<BgpPeer>>)`](crate::output::UpdateVirtualInterfaceAttributesOutput::bgp_peers): <p>The BGP peers configured on this virtual interface.</p>
    ///   - [`region(Option<String>)`](crate::output::UpdateVirtualInterfaceAttributesOutput::region): <p>The Amazon Web Services Region where the virtual interface is located.</p>
    ///   - [`aws_device_v2(Option<String>)`](crate::output::UpdateVirtualInterfaceAttributesOutput::aws_device_v2): <p>The Direct Connect endpoint that terminates the physical connection.</p>
    ///   - [`aws_logical_device_id(Option<String>)`](crate::output::UpdateVirtualInterfaceAttributesOutput::aws_logical_device_id): <p>The Direct Connect endpoint that terminates the logical connection. This device might be different than the device that terminates the physical connection.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::UpdateVirtualInterfaceAttributesOutput::tags): <p>The tags associated with the virtual interface.</p>
    ///   - [`site_link_enabled(Option<bool>)`](crate::output::UpdateVirtualInterfaceAttributesOutput::site_link_enabled): <p>Indicates whether SiteLink is enabled.</p>
    /// - On failure, responds with [`SdkError<UpdateVirtualInterfaceAttributesError>`](crate::error::UpdateVirtualInterfaceAttributesError)
    pub fn update_virtual_interface_attributes(
        &self,
    ) -> fluent_builders::UpdateVirtualInterfaceAttributes {
        fluent_builders::UpdateVirtualInterfaceAttributes::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptDirectConnectGatewayAssociationProposal`.
    ///
    /// <p>Accepts a proposal request to attach a virtual private gateway or transit gateway to a Direct Connect gateway.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AcceptDirectConnectGatewayAssociationProposal {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::accept_direct_connect_gateway_association_proposal_input::Builder,
    }
    impl AcceptDirectConnectGatewayAssociationProposal {
        /// Creates a new `AcceptDirectConnectGatewayAssociationProposal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptDirectConnectGatewayAssociationProposalOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AcceptDirectConnectGatewayAssociationProposalError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.direct_connect_gateway_id(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_direct_connect_gateway_id(input);
            self
        }
        /// <p>The ID of the request proposal.</p>
        pub fn proposal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.proposal_id(input.into());
            self
        }
        /// <p>The ID of the request proposal.</p>
        pub fn set_proposal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_proposal_id(input);
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the virtual private gateway or transit gateway.</p>
        pub fn associated_gateway_owner_account(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.associated_gateway_owner_account(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the virtual private gateway or transit gateway.</p>
        pub fn set_associated_gateway_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_associated_gateway_owner_account(input);
            self
        }
        /// Appends an item to `overrideAllowedPrefixesToDirectConnectGateway`.
        ///
        /// To override the contents of this collection use [`set_override_allowed_prefixes_to_direct_connect_gateway`](Self::set_override_allowed_prefixes_to_direct_connect_gateway).
        ///
        /// <p>Overrides the Amazon VPC prefixes advertised to the Direct Connect gateway.</p>
        /// <p>For information about how to set the prefixes, see <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes">Allowed Prefixes</a> in the <i>Direct Connect User Guide</i>.</p>
        pub fn override_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: crate::model::RouteFilterPrefix,
        ) -> Self {
            self.inner = self
                .inner
                .override_allowed_prefixes_to_direct_connect_gateway(input);
            self
        }
        /// <p>Overrides the Amazon VPC prefixes advertised to the Direct Connect gateway.</p>
        /// <p>For information about how to set the prefixes, see <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes">Allowed Prefixes</a> in the <i>Direct Connect User Guide</i>.</p>
        pub fn set_override_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_override_allowed_prefixes_to_direct_connect_gateway(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AllocateConnectionOnInterconnect`.
    ///
    /// <p>Deprecated. Use <code>AllocateHostedConnection</code> instead.</p>
    /// <p>Creates a hosted connection on an interconnect.</p>
    /// <p>Allocates a VLAN number and a specified amount of bandwidth for use by a hosted connection on the specified interconnect.</p> <note>
    /// <p>Intended for use by Direct Connect Partners only.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AllocateConnectionOnInterconnect {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::allocate_connection_on_interconnect_input::Builder,
    }
    impl AllocateConnectionOnInterconnect {
        /// Creates a new `AllocateConnectionOnInterconnect`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AllocateConnectionOnInterconnectOutput,
            aws_smithy_http::result::SdkError<crate::error::AllocateConnectionOnInterconnectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The bandwidth of the connection. The possible values are 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, and 10Gbps. Note that only those Direct Connect Partners who have met specific requirements are allowed to create a 1Gbps, 2Gbps, 5Gbps or 10Gbps hosted connection.</p>
        pub fn bandwidth(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bandwidth(input.into());
            self
        }
        /// <p>The bandwidth of the connection. The possible values are 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, and 10Gbps. Note that only those Direct Connect Partners who have met specific requirements are allowed to create a 1Gbps, 2Gbps, 5Gbps or 10Gbps hosted connection.</p>
        pub fn set_bandwidth(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bandwidth(input);
            self
        }
        /// <p>The name of the provisioned connection.</p>
        pub fn connection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_name(input.into());
            self
        }
        /// <p>The name of the provisioned connection.</p>
        pub fn set_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_name(input);
            self
        }
        /// <p>The ID of the Amazon Web Services account of the customer for whom the connection will be provisioned.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner_account(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account of the customer for whom the connection will be provisioned.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_owner_account(input);
            self
        }
        /// <p>The ID of the interconnect on which the connection will be provisioned.</p>
        pub fn interconnect_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.interconnect_id(input.into());
            self
        }
        /// <p>The ID of the interconnect on which the connection will be provisioned.</p>
        pub fn set_interconnect_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_interconnect_id(input);
            self
        }
        /// <p>The dedicated VLAN provisioned to the connection.</p>
        pub fn vlan(mut self, input: i32) -> Self {
            self.inner = self.inner.vlan(input);
            self
        }
        /// <p>The dedicated VLAN provisioned to the connection.</p>
        pub fn set_vlan(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_vlan(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AllocateHostedConnection`.
    ///
    /// <p>Creates a hosted connection on the specified interconnect or a link aggregation group (LAG) of interconnects.</p>
    /// <p>Allocates a VLAN number and a specified amount of capacity (bandwidth) for use by a hosted connection on the specified interconnect or LAG of interconnects. Amazon Web Services polices the hosted connection for the specified capacity and the Direct Connect Partner must also police the hosted connection for the specified capacity.</p> <note>
    /// <p>Intended for use by Direct Connect Partners only.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AllocateHostedConnection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::allocate_hosted_connection_input::Builder,
    }
    impl AllocateHostedConnection {
        /// Creates a new `AllocateHostedConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AllocateHostedConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::AllocateHostedConnectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the interconnect or LAG.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of the interconnect or LAG.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>The ID of the Amazon Web Services account ID of the customer for the connection.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner_account(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account ID of the customer for the connection.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_owner_account(input);
            self
        }
        /// <p>The bandwidth of the connection. The possible values are 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, and 10Gbps. Note that only those Direct Connect Partners who have met specific requirements are allowed to create a 1Gbps, 2Gbps, 5Gbps or 10Gbps hosted connection. </p>
        pub fn bandwidth(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bandwidth(input.into());
            self
        }
        /// <p>The bandwidth of the connection. The possible values are 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, and 10Gbps. Note that only those Direct Connect Partners who have met specific requirements are allowed to create a 1Gbps, 2Gbps, 5Gbps or 10Gbps hosted connection. </p>
        pub fn set_bandwidth(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bandwidth(input);
            self
        }
        /// <p>The name of the hosted connection.</p>
        pub fn connection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_name(input.into());
            self
        }
        /// <p>The name of the hosted connection.</p>
        pub fn set_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_name(input);
            self
        }
        /// <p>The dedicated VLAN provisioned to the hosted connection.</p>
        pub fn vlan(mut self, input: i32) -> Self {
            self.inner = self.inner.vlan(input);
            self
        }
        /// <p>The dedicated VLAN provisioned to the hosted connection.</p>
        pub fn set_vlan(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_vlan(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the connection.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags associated with the connection.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AllocatePrivateVirtualInterface`.
    ///
    /// <p>Provisions a private virtual interface to be owned by the specified Amazon Web Services account.</p>
    /// <p>Virtual interfaces created using this action must be confirmed by the owner using <code>ConfirmPrivateVirtualInterface</code>. Until then, the virtual interface is in the <code>Confirming</code> state and is not available to handle traffic.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AllocatePrivateVirtualInterface {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::allocate_private_virtual_interface_input::Builder,
    }
    impl AllocatePrivateVirtualInterface {
        /// Creates a new `AllocatePrivateVirtualInterface`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AllocatePrivateVirtualInterfaceOutput,
            aws_smithy_http::result::SdkError<crate::error::AllocatePrivateVirtualInterfaceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the connection on which the private virtual interface is provisioned.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of the connection on which the private virtual interface is provisioned.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the virtual private interface.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner_account(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the virtual private interface.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_owner_account(input);
            self
        }
        /// <p>Information about the private virtual interface.</p>
        pub fn new_private_virtual_interface_allocation(
            mut self,
            input: crate::model::NewPrivateVirtualInterfaceAllocation,
        ) -> Self {
            self.inner = self.inner.new_private_virtual_interface_allocation(input);
            self
        }
        /// <p>Information about the private virtual interface.</p>
        pub fn set_new_private_virtual_interface_allocation(
            mut self,
            input: std::option::Option<crate::model::NewPrivateVirtualInterfaceAllocation>,
        ) -> Self {
            self.inner = self
                .inner
                .set_new_private_virtual_interface_allocation(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AllocatePublicVirtualInterface`.
    ///
    /// <p>Provisions a public virtual interface to be owned by the specified Amazon Web Services account.</p>
    /// <p>The owner of a connection calls this function to provision a public virtual interface to be owned by the specified Amazon Web Services account.</p>
    /// <p>Virtual interfaces created using this function must be confirmed by the owner using <code>ConfirmPublicVirtualInterface</code>. Until this step has been completed, the virtual interface is in the <code>confirming</code> state and is not available to handle traffic.</p>
    /// <p>When creating an IPv6 public virtual interface, omit the Amazon address and customer address. IPv6 addresses are automatically assigned from the Amazon pool of IPv6 addresses; you cannot specify custom IPv6 addresses.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AllocatePublicVirtualInterface {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::allocate_public_virtual_interface_input::Builder,
    }
    impl AllocatePublicVirtualInterface {
        /// Creates a new `AllocatePublicVirtualInterface`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AllocatePublicVirtualInterfaceOutput,
            aws_smithy_http::result::SdkError<crate::error::AllocatePublicVirtualInterfaceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the connection on which the public virtual interface is provisioned.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of the connection on which the public virtual interface is provisioned.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the public virtual interface.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner_account(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the public virtual interface.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_owner_account(input);
            self
        }
        /// <p>Information about the public virtual interface.</p>
        pub fn new_public_virtual_interface_allocation(
            mut self,
            input: crate::model::NewPublicVirtualInterfaceAllocation,
        ) -> Self {
            self.inner = self.inner.new_public_virtual_interface_allocation(input);
            self
        }
        /// <p>Information about the public virtual interface.</p>
        pub fn set_new_public_virtual_interface_allocation(
            mut self,
            input: std::option::Option<crate::model::NewPublicVirtualInterfaceAllocation>,
        ) -> Self {
            self.inner = self
                .inner
                .set_new_public_virtual_interface_allocation(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AllocateTransitVirtualInterface`.
    ///
    /// <p>Provisions a transit virtual interface to be owned by the specified Amazon Web Services account. Use this type of interface to connect a transit gateway to your Direct Connect gateway.</p>
    /// <p>The owner of a connection provisions a transit virtual interface to be owned by the specified Amazon Web Services account.</p>
    /// <p>After you create a transit virtual interface, it must be confirmed by the owner using <code>ConfirmTransitVirtualInterface</code>. Until this step has been completed, the transit virtual interface is in the <code>requested</code> state and is not available to handle traffic.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AllocateTransitVirtualInterface {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::allocate_transit_virtual_interface_input::Builder,
    }
    impl AllocateTransitVirtualInterface {
        /// Creates a new `AllocateTransitVirtualInterface`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AllocateTransitVirtualInterfaceOutput,
            aws_smithy_http::result::SdkError<crate::error::AllocateTransitVirtualInterfaceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the connection on which the transit virtual interface is provisioned.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of the connection on which the transit virtual interface is provisioned.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the transit virtual interface.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner_account(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the transit virtual interface.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_owner_account(input);
            self
        }
        /// <p>Information about the transit virtual interface.</p>
        pub fn new_transit_virtual_interface_allocation(
            mut self,
            input: crate::model::NewTransitVirtualInterfaceAllocation,
        ) -> Self {
            self.inner = self.inner.new_transit_virtual_interface_allocation(input);
            self
        }
        /// <p>Information about the transit virtual interface.</p>
        pub fn set_new_transit_virtual_interface_allocation(
            mut self,
            input: std::option::Option<crate::model::NewTransitVirtualInterfaceAllocation>,
        ) -> Self {
            self.inner = self
                .inner
                .set_new_transit_virtual_interface_allocation(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateConnectionWithLag`.
    ///
    /// <p>Associates an existing connection with a link aggregation group (LAG). The connection is interrupted and re-established as a member of the LAG (connectivity to Amazon Web Services is interrupted). The connection must be hosted on the same Direct Connect endpoint as the LAG, and its bandwidth must match the bandwidth for the LAG. You can re-associate a connection that's currently associated with a different LAG; however, if removing the connection would cause the original LAG to fall below its setting for minimum number of operational connections, the request fails.</p>
    /// <p>Any virtual interfaces that are directly associated with the connection are automatically re-associated with the LAG. If the connection was originally associated with a different LAG, the virtual interfaces remain associated with the original LAG.</p>
    /// <p>For interconnects, any hosted connections are automatically re-associated with the LAG. If the interconnect was originally associated with a different LAG, the hosted connections remain associated with the original LAG.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateConnectionWithLag {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_connection_with_lag_input::Builder,
    }
    impl AssociateConnectionWithLag {
        /// Creates a new `AssociateConnectionWithLag`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateConnectionWithLagOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateConnectionWithLagError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>The ID of the LAG with which to associate the connection.</p>
        pub fn lag_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lag_id(input.into());
            self
        }
        /// <p>The ID of the LAG with which to associate the connection.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lag_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateHostedConnection`.
    ///
    /// <p>Associates a hosted connection and its virtual interfaces with a link aggregation group (LAG) or interconnect. If the target interconnect or LAG has an existing hosted connection with a conflicting VLAN number or IP address, the operation fails. This action temporarily interrupts the hosted connection's connectivity to Amazon Web Services as it is being migrated.</p> <note>
    /// <p>Intended for use by Direct Connect Partners only.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateHostedConnection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_hosted_connection_input::Builder,
    }
    impl AssociateHostedConnection {
        /// Creates a new `AssociateHostedConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateHostedConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateHostedConnectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the hosted connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of the hosted connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>The ID of the interconnect or the LAG.</p>
        pub fn parent_connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_connection_id(input.into());
            self
        }
        /// <p>The ID of the interconnect or the LAG.</p>
        pub fn set_parent_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parent_connection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateMacSecKey`.
    ///
    /// <p>Associates a MAC Security (MACsec) Connection Key Name (CKN)/ Connectivity Association Key (CAK) pair with an Direct Connect dedicated connection.</p>
    /// <p>You must supply either the <code>secretARN,</code> or the CKN/CAK (<code>ckn</code> and <code>cak</code>) pair in the request.</p>
    /// <p>For information about MAC Security (MACsec) key considerations, see <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-key-consideration">MACsec pre-shared CKN/CAK key considerations </a> in the <i>Direct Connect User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateMacSecKey {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_mac_sec_key_input::Builder,
    }
    impl AssociateMacSecKey {
        /// Creates a new `AssociateMacSecKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateMacSecKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateMacSecKeyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).</p>
        /// <p>You can use <code>DescribeConnections</code> or <code>DescribeLags</code> to retrieve connection ID.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).</p>
        /// <p>You can use <code>DescribeConnections</code> or <code>DescribeLags</code> to retrieve connection ID.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key to associate with the dedicated connection.</p>
        /// <p>You can use <code>DescribeConnections</code> or <code>DescribeLags</code> to retrieve the MAC Security (MACsec) secret key.</p>
        /// <p>If you use this request parameter, you do not use the <code>ckn</code> and <code>cak</code> request parameters.</p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key to associate with the dedicated connection.</p>
        /// <p>You can use <code>DescribeConnections</code> or <code>DescribeLags</code> to retrieve the MAC Security (MACsec) secret key.</p>
        /// <p>If you use this request parameter, you do not use the <code>ckn</code> and <code>cak</code> request parameters.</p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_arn(input);
            self
        }
        /// <p>The MAC Security (MACsec) CKN to associate with the dedicated connection.</p>
        /// <p>You can create the CKN/CAK pair using an industry standard tool.</p>
        /// <p> The valid values are 64 hexadecimal characters (0-9, A-E).</p>
        /// <p>If you use this request parameter, you must use the <code>cak</code> request parameter and not use the <code>secretARN</code> request parameter.</p>
        pub fn ckn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ckn(input.into());
            self
        }
        /// <p>The MAC Security (MACsec) CKN to associate with the dedicated connection.</p>
        /// <p>You can create the CKN/CAK pair using an industry standard tool.</p>
        /// <p> The valid values are 64 hexadecimal characters (0-9, A-E).</p>
        /// <p>If you use this request parameter, you must use the <code>cak</code> request parameter and not use the <code>secretARN</code> request parameter.</p>
        pub fn set_ckn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ckn(input);
            self
        }
        /// <p>The MAC Security (MACsec) CAK to associate with the dedicated connection.</p>
        /// <p>You can create the CKN/CAK pair using an industry standard tool.</p>
        /// <p> The valid values are 64 hexadecimal characters (0-9, A-E).</p>
        /// <p>If you use this request parameter, you must use the <code>ckn</code> request parameter and not use the <code>secretARN</code> request parameter.</p>
        pub fn cak(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cak(input.into());
            self
        }
        /// <p>The MAC Security (MACsec) CAK to associate with the dedicated connection.</p>
        /// <p>You can create the CKN/CAK pair using an industry standard tool.</p>
        /// <p> The valid values are 64 hexadecimal characters (0-9, A-E).</p>
        /// <p>If you use this request parameter, you must use the <code>ckn</code> request parameter and not use the <code>secretARN</code> request parameter.</p>
        pub fn set_cak(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cak(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateVirtualInterface`.
    ///
    /// <p>Associates a virtual interface with a specified link aggregation group (LAG) or connection. Connectivity to Amazon Web Services is temporarily interrupted as the virtual interface is being migrated. If the target connection or LAG has an associated virtual interface with a conflicting VLAN number or a conflicting IP address, the operation fails.</p>
    /// <p>Virtual interfaces associated with a hosted connection cannot be associated with a LAG; hosted connections must be migrated along with their virtual interfaces using <code>AssociateHostedConnection</code>.</p>
    /// <p>To reassociate a virtual interface to a new connection or LAG, the requester must own either the virtual interface itself or the connection to which the virtual interface is currently associated. Additionally, the requester must own the connection or LAG for the association.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateVirtualInterface {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_virtual_interface_input::Builder,
    }
    impl AssociateVirtualInterface {
        /// Creates a new `AssociateVirtualInterface`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateVirtualInterfaceOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateVirtualInterfaceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_interface_id(input.into());
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_interface_id(input);
            self
        }
        /// <p>The ID of the LAG or connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of the LAG or connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ConfirmConnection`.
    ///
    /// <p>Confirms the creation of the specified hosted connection on an interconnect.</p>
    /// <p>Upon creation, the hosted connection is initially in the <code>Ordering</code> state, and remains in this state until the owner confirms creation of the hosted connection.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ConfirmConnection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::confirm_connection_input::Builder,
    }
    impl ConfirmConnection {
        /// Creates a new `ConfirmConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ConfirmConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::ConfirmConnectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the hosted connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of the hosted connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ConfirmCustomerAgreement`.
    ///
    /// <p> The confirmation of the terms of agreement when creating the connection/link aggregation group (LAG). </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ConfirmCustomerAgreement {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::confirm_customer_agreement_input::Builder,
    }
    impl ConfirmCustomerAgreement {
        /// Creates a new `ConfirmCustomerAgreement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ConfirmCustomerAgreementOutput,
            aws_smithy_http::result::SdkError<crate::error::ConfirmCustomerAgreementError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the customer agreement. </p>
        pub fn agreement_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agreement_name(input.into());
            self
        }
        /// <p> The name of the customer agreement. </p>
        pub fn set_agreement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_agreement_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ConfirmPrivateVirtualInterface`.
    ///
    /// <p>Accepts ownership of a private virtual interface created by another Amazon Web Services account.</p>
    /// <p>After the virtual interface owner makes this call, the virtual interface is created and attached to the specified virtual private gateway or Direct Connect gateway, and is made available to handle traffic.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ConfirmPrivateVirtualInterface {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::confirm_private_virtual_interface_input::Builder,
    }
    impl ConfirmPrivateVirtualInterface {
        /// Creates a new `ConfirmPrivateVirtualInterface`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ConfirmPrivateVirtualInterfaceOutput,
            aws_smithy_http::result::SdkError<crate::error::ConfirmPrivateVirtualInterfaceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_interface_id(input.into());
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_interface_id(input);
            self
        }
        /// <p>The ID of the virtual private gateway.</p>
        pub fn virtual_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_gateway_id(input.into());
            self
        }
        /// <p>The ID of the virtual private gateway.</p>
        pub fn set_virtual_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_gateway_id(input);
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.direct_connect_gateway_id(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_direct_connect_gateway_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ConfirmPublicVirtualInterface`.
    ///
    /// <p>Accepts ownership of a public virtual interface created by another Amazon Web Services account.</p>
    /// <p>After the virtual interface owner makes this call, the specified virtual interface is created and made available to handle traffic.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ConfirmPublicVirtualInterface {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::confirm_public_virtual_interface_input::Builder,
    }
    impl ConfirmPublicVirtualInterface {
        /// Creates a new `ConfirmPublicVirtualInterface`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ConfirmPublicVirtualInterfaceOutput,
            aws_smithy_http::result::SdkError<crate::error::ConfirmPublicVirtualInterfaceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_interface_id(input.into());
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_interface_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ConfirmTransitVirtualInterface`.
    ///
    /// <p>Accepts ownership of a transit virtual interface created by another Amazon Web Services account.</p>
    /// <p> After the owner of the transit virtual interface makes this call, the specified transit virtual interface is created and made available to handle traffic.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ConfirmTransitVirtualInterface {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::confirm_transit_virtual_interface_input::Builder,
    }
    impl ConfirmTransitVirtualInterface {
        /// Creates a new `ConfirmTransitVirtualInterface`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ConfirmTransitVirtualInterfaceOutput,
            aws_smithy_http::result::SdkError<crate::error::ConfirmTransitVirtualInterfaceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_interface_id(input.into());
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_interface_id(input);
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.direct_connect_gateway_id(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_direct_connect_gateway_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBGPPeer`.
    ///
    /// <p>Creates a BGP peer on the specified virtual interface.</p>
    /// <p>You must create a BGP peer for the corresponding address family (IPv4/IPv6) in order to access Amazon Web Services resources that also use that address family.</p>
    /// <p>If logical redundancy is not supported by the connection, interconnect, or LAG, the BGP peer cannot be in the same address family as an existing BGP peer on the virtual interface.</p>
    /// <p>When creating a IPv6 BGP peer, omit the Amazon address and customer address. IPv6 addresses are automatically assigned from the Amazon pool of IPv6 addresses; you cannot specify custom IPv6 addresses.</p>
    /// <p>For a public virtual interface, the Autonomous System Number (ASN) must be private or already on the allow list for the virtual interface.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateBGPPeer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_bgp_peer_input::Builder,
    }
    impl CreateBGPPeer {
        /// Creates a new `CreateBGPPeer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBgpPeerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBGPPeerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_interface_id(input.into());
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_interface_id(input);
            self
        }
        /// <p>Information about the BGP peer.</p>
        pub fn new_bgp_peer(mut self, input: crate::model::NewBgpPeer) -> Self {
            self.inner = self.inner.new_bgp_peer(input);
            self
        }
        /// <p>Information about the BGP peer.</p>
        pub fn set_new_bgp_peer(
            mut self,
            input: std::option::Option<crate::model::NewBgpPeer>,
        ) -> Self {
            self.inner = self.inner.set_new_bgp_peer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConnection`.
    ///
    /// <p>Creates a connection between a customer network and a specific Direct Connect location.</p>
    /// <p>A connection links your internal network to an Direct Connect location over a standard Ethernet fiber-optic cable. One end of the cable is connected to your router, the other to an Direct Connect router.</p>
    /// <p>To find the locations for your Region, use <code>DescribeLocations</code>.</p>
    /// <p>You can automatically add the new connection to a link aggregation group (LAG) by specifying a LAG ID in the request. This ensures that the new connection is allocated on the same Direct Connect endpoint that hosts the specified LAG. If there are no available ports on the endpoint, the request fails and no connection is created.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateConnection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_connection_input::Builder,
    }
    impl CreateConnection {
        /// Creates a new `CreateConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConnectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The location of the connection.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location(input.into());
            self
        }
        /// <p>The location of the connection.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location(input);
            self
        }
        /// <p>The bandwidth of the connection.</p>
        pub fn bandwidth(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bandwidth(input.into());
            self
        }
        /// <p>The bandwidth of the connection.</p>
        pub fn set_bandwidth(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bandwidth(input);
            self
        }
        /// <p>The name of the connection.</p>
        pub fn connection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_name(input.into());
            self
        }
        /// <p>The name of the connection.</p>
        pub fn set_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_name(input);
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lag_id(input.into());
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lag_id(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to associate with the lag.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to associate with the lag.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The name of the service provider associated with the requested connection.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider_name(input.into());
            self
        }
        /// <p>The name of the service provider associated with the requested connection.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provider_name(input);
            self
        }
        /// <p>Indicates whether you want the connection to support MAC Security (MACsec).</p>
        /// <p>MAC Security (MACsec) is only available on dedicated connections. For information about MAC Security (MACsec) prerequisties, see <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites">MACsec prerequisties</a> in the <i>Direct Connect User Guide</i>.</p>
        pub fn request_mac_sec(mut self, input: bool) -> Self {
            self.inner = self.inner.request_mac_sec(input);
            self
        }
        /// <p>Indicates whether you want the connection to support MAC Security (MACsec).</p>
        /// <p>MAC Security (MACsec) is only available on dedicated connections. For information about MAC Security (MACsec) prerequisties, see <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites">MACsec prerequisties</a> in the <i>Direct Connect User Guide</i>.</p>
        pub fn set_request_mac_sec(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_request_mac_sec(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDirectConnectGateway`.
    ///
    /// <p>Creates a Direct Connect gateway, which is an intermediate object that enables you to connect a set of virtual interfaces and virtual private gateways. A Direct Connect gateway is global and visible in any Amazon Web Services Region after it is created. The virtual interfaces and virtual private gateways that are connected through a Direct Connect gateway can be in different Amazon Web Services Regions. This enables you to connect to a VPC in any Region, regardless of the Region in which the virtual interfaces are located, and pass traffic between them.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDirectConnectGateway {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_direct_connect_gateway_input::Builder,
    }
    impl CreateDirectConnectGateway {
        /// Creates a new `CreateDirectConnectGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDirectConnectGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDirectConnectGatewayError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.direct_connect_gateway_name(input.into());
            self
        }
        /// <p>The name of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_direct_connect_gateway_name(input);
            self
        }
        /// <p>The autonomous system number (ASN) for Border Gateway Protocol (BGP) to be configured on the Amazon side of the connection. The ASN must be in the private range of 64,512 to 65,534 or 4,200,000,000 to 4,294,967,294. The default is 64512.</p>
        pub fn amazon_side_asn(mut self, input: i64) -> Self {
            self.inner = self.inner.amazon_side_asn(input);
            self
        }
        /// <p>The autonomous system number (ASN) for Border Gateway Protocol (BGP) to be configured on the Amazon side of the connection. The ASN must be in the private range of 64,512 to 65,534 or 4,200,000,000 to 4,294,967,294. The default is 64512.</p>
        pub fn set_amazon_side_asn(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_amazon_side_asn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDirectConnectGatewayAssociation`.
    ///
    /// <p>Creates an association between a Direct Connect gateway and a virtual private gateway. The virtual private gateway must be attached to a VPC and must not be associated with another Direct Connect gateway.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDirectConnectGatewayAssociation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_direct_connect_gateway_association_input::Builder,
    }
    impl CreateDirectConnectGatewayAssociation {
        /// Creates a new `CreateDirectConnectGatewayAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDirectConnectGatewayAssociationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateDirectConnectGatewayAssociationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.direct_connect_gateway_id(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_direct_connect_gateway_id(input);
            self
        }
        /// <p>The ID of the virtual private gateway or transit gateway.</p>
        pub fn gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_id(input.into());
            self
        }
        /// <p>The ID of the virtual private gateway or transit gateway.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_id(input);
            self
        }
        /// Appends an item to `addAllowedPrefixesToDirectConnectGateway`.
        ///
        /// To override the contents of this collection use [`set_add_allowed_prefixes_to_direct_connect_gateway`](Self::set_add_allowed_prefixes_to_direct_connect_gateway).
        ///
        /// <p>The Amazon VPC prefixes to advertise to the Direct Connect gateway</p>
        /// <p>This parameter is required when you create an association to a transit gateway.</p>
        /// <p>For information about how to set the prefixes, see <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes">Allowed Prefixes</a> in the <i>Direct Connect User Guide</i>.</p>
        pub fn add_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: crate::model::RouteFilterPrefix,
        ) -> Self {
            self.inner = self
                .inner
                .add_allowed_prefixes_to_direct_connect_gateway(input);
            self
        }
        /// <p>The Amazon VPC prefixes to advertise to the Direct Connect gateway</p>
        /// <p>This parameter is required when you create an association to a transit gateway.</p>
        /// <p>For information about how to set the prefixes, see <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes">Allowed Prefixes</a> in the <i>Direct Connect User Guide</i>.</p>
        pub fn set_add_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_add_allowed_prefixes_to_direct_connect_gateway(input);
            self
        }
        /// <p>The ID of the virtual private gateway.</p>
        pub fn virtual_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_gateway_id(input.into());
            self
        }
        /// <p>The ID of the virtual private gateway.</p>
        pub fn set_virtual_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_gateway_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDirectConnectGatewayAssociationProposal`.
    ///
    /// <p>Creates a proposal to associate the specified virtual private gateway or transit gateway with the specified Direct Connect gateway.</p>
    /// <p>You can associate a Direct Connect gateway and virtual private gateway or transit gateway that is owned by any Amazon Web Services account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDirectConnectGatewayAssociationProposal {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_direct_connect_gateway_association_proposal_input::Builder,
    }
    impl CreateDirectConnectGatewayAssociationProposal {
        /// Creates a new `CreateDirectConnectGatewayAssociationProposal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDirectConnectGatewayAssociationProposalOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateDirectConnectGatewayAssociationProposalError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.direct_connect_gateway_id(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_direct_connect_gateway_id(input);
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_owner_account(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .direct_connect_gateway_owner_account(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_direct_connect_gateway_owner_account(input);
            self
        }
        /// <p>The ID of the virtual private gateway or transit gateway.</p>
        pub fn gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_id(input.into());
            self
        }
        /// <p>The ID of the virtual private gateway or transit gateway.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_id(input);
            self
        }
        /// Appends an item to `addAllowedPrefixesToDirectConnectGateway`.
        ///
        /// To override the contents of this collection use [`set_add_allowed_prefixes_to_direct_connect_gateway`](Self::set_add_allowed_prefixes_to_direct_connect_gateway).
        ///
        /// <p>The Amazon VPC prefixes to advertise to the Direct Connect gateway.</p>
        pub fn add_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: crate::model::RouteFilterPrefix,
        ) -> Self {
            self.inner = self
                .inner
                .add_allowed_prefixes_to_direct_connect_gateway(input);
            self
        }
        /// <p>The Amazon VPC prefixes to advertise to the Direct Connect gateway.</p>
        pub fn set_add_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_add_allowed_prefixes_to_direct_connect_gateway(input);
            self
        }
        /// Appends an item to `removeAllowedPrefixesToDirectConnectGateway`.
        ///
        /// To override the contents of this collection use [`set_remove_allowed_prefixes_to_direct_connect_gateway`](Self::set_remove_allowed_prefixes_to_direct_connect_gateway).
        ///
        /// <p>The Amazon VPC prefixes to no longer advertise to the Direct Connect gateway.</p>
        pub fn remove_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: crate::model::RouteFilterPrefix,
        ) -> Self {
            self.inner = self
                .inner
                .remove_allowed_prefixes_to_direct_connect_gateway(input);
            self
        }
        /// <p>The Amazon VPC prefixes to no longer advertise to the Direct Connect gateway.</p>
        pub fn set_remove_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_remove_allowed_prefixes_to_direct_connect_gateway(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateInterconnect`.
    ///
    /// <p>Creates an interconnect between an Direct Connect Partner's network and a specific Direct Connect location.</p>
    /// <p>An interconnect is a connection that is capable of hosting other connections. The Direct Connect Partner can use an interconnect to provide Direct Connect hosted connections to customers through their own network services. Like a standard connection, an interconnect links the partner's network to an Direct Connect location over a standard Ethernet fiber-optic cable. One end is connected to the partner's router, the other to an Direct Connect router.</p>
    /// <p>You can automatically add the new interconnect to a link aggregation group (LAG) by specifying a LAG ID in the request. This ensures that the new interconnect is allocated on the same Direct Connect endpoint that hosts the specified LAG. If there are no available ports on the endpoint, the request fails and no interconnect is created.</p>
    /// <p>For each end customer, the Direct Connect Partner provisions a connection on their interconnect by calling <code>AllocateHostedConnection</code>. The end customer can then connect to Amazon Web Services resources by creating a virtual interface on their connection, using the VLAN assigned to them by the Direct Connect Partner.</p> <note>
    /// <p>Intended for use by Direct Connect Partners only.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateInterconnect {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_interconnect_input::Builder,
    }
    impl CreateInterconnect {
        /// Creates a new `CreateInterconnect`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateInterconnectOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateInterconnectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the interconnect.</p>
        pub fn interconnect_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.interconnect_name(input.into());
            self
        }
        /// <p>The name of the interconnect.</p>
        pub fn set_interconnect_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_interconnect_name(input);
            self
        }
        /// <p>The port bandwidth, in Gbps. The possible values are 1 and 10.</p>
        pub fn bandwidth(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bandwidth(input.into());
            self
        }
        /// <p>The port bandwidth, in Gbps. The possible values are 1 and 10.</p>
        pub fn set_bandwidth(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bandwidth(input);
            self
        }
        /// <p>The location of the interconnect.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location(input.into());
            self
        }
        /// <p>The location of the interconnect.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location(input);
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lag_id(input.into());
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lag_id(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to associate with the interconnect.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to associate with the interconnect.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The name of the service provider associated with the interconnect.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider_name(input.into());
            self
        }
        /// <p>The name of the service provider associated with the interconnect.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provider_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLag`.
    ///
    /// <p>Creates a link aggregation group (LAG) with the specified number of bundled physical dedicated connections between the customer network and a specific Direct Connect location. A LAG is a logical interface that uses the Link Aggregation Control Protocol (LACP) to aggregate multiple interfaces, enabling you to treat them as a single interface.</p>
    /// <p>All connections in a LAG must use the same bandwidth (either 1Gbps or 10Gbps) and must terminate at the same Direct Connect endpoint.</p>
    /// <p>You can have up to 10 dedicated connections per LAG. Regardless of this limit, if you request more connections for the LAG than Direct Connect can allocate on a single endpoint, no LAG is created.</p>
    /// <p>You can specify an existing physical dedicated connection or interconnect to include in the LAG (which counts towards the total number of connections). Doing so interrupts the current physical dedicated connection, and re-establishes them as a member of the LAG. The LAG will be created on the same Direct Connect endpoint to which the dedicated connection terminates. Any virtual interfaces associated with the dedicated connection are automatically disassociated and re-associated with the LAG. The connection ID does not change.</p>
    /// <p>If the Amazon Web Services account used to create a LAG is a registered Direct Connect Partner, the LAG is automatically enabled to host sub-connections. For a LAG owned by a partner, any associated virtual interfaces cannot be directly configured.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLag {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_lag_input::Builder,
    }
    impl CreateLag {
        /// Creates a new `CreateLag`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLagOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLagError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The number of physical dedicated connections initially provisioned and bundled by the LAG.</p>
        pub fn number_of_connections(mut self, input: i32) -> Self {
            self.inner = self.inner.number_of_connections(input);
            self
        }
        /// <p>The number of physical dedicated connections initially provisioned and bundled by the LAG.</p>
        pub fn set_number_of_connections(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_number_of_connections(input);
            self
        }
        /// <p>The location for the LAG.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location(input.into());
            self
        }
        /// <p>The location for the LAG.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location(input);
            self
        }
        /// <p>The bandwidth of the individual physical dedicated connections bundled by the LAG. The possible values are 1Gbps and 10Gbps. </p>
        pub fn connections_bandwidth(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connections_bandwidth(input.into());
            self
        }
        /// <p>The bandwidth of the individual physical dedicated connections bundled by the LAG. The possible values are 1Gbps and 10Gbps. </p>
        pub fn set_connections_bandwidth(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connections_bandwidth(input);
            self
        }
        /// <p>The name of the LAG.</p>
        pub fn lag_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lag_name(input.into());
            self
        }
        /// <p>The name of the LAG.</p>
        pub fn set_lag_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lag_name(input);
            self
        }
        /// <p>The ID of an existing dedicated connection to migrate to the LAG.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of an existing dedicated connection to migrate to the LAG.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to associate with the LAG.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to associate with the LAG.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `childConnectionTags`.
        ///
        /// To override the contents of this collection use [`set_child_connection_tags`](Self::set_child_connection_tags).
        ///
        /// <p>The tags to associate with the automtically created LAGs.</p>
        pub fn child_connection_tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.child_connection_tags(input);
            self
        }
        /// <p>The tags to associate with the automtically created LAGs.</p>
        pub fn set_child_connection_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_child_connection_tags(input);
            self
        }
        /// <p>The name of the service provider associated with the LAG.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider_name(input.into());
            self
        }
        /// <p>The name of the service provider associated with the LAG.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provider_name(input);
            self
        }
        /// <p>Indicates whether the connection will support MAC Security (MACsec).</p> <note>
        /// <p>All connections in the LAG must be capable of supporting MAC Security (MACsec). For information about MAC Security (MACsec) prerequisties, see <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites">MACsec prerequisties</a> in the <i>Direct Connect User Guide</i>.</p>
        /// </note>
        pub fn request_mac_sec(mut self, input: bool) -> Self {
            self.inner = self.inner.request_mac_sec(input);
            self
        }
        /// <p>Indicates whether the connection will support MAC Security (MACsec).</p> <note>
        /// <p>All connections in the LAG must be capable of supporting MAC Security (MACsec). For information about MAC Security (MACsec) prerequisties, see <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites">MACsec prerequisties</a> in the <i>Direct Connect User Guide</i>.</p>
        /// </note>
        pub fn set_request_mac_sec(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_request_mac_sec(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePrivateVirtualInterface`.
    ///
    /// <p>Creates a private virtual interface. A virtual interface is the VLAN that transports Direct Connect traffic. A private virtual interface can be connected to either a Direct Connect gateway or a Virtual Private Gateway (VGW). Connecting the private virtual interface to a Direct Connect gateway enables the possibility for connecting to multiple VPCs, including VPCs in different Amazon Web Services Regions. Connecting the private virtual interface to a VGW only provides access to a single VPC within the same Region.</p>
    /// <p>Setting the MTU of a virtual interface to 9001 (jumbo frames) can cause an update to the underlying physical connection if it wasn't updated to support jumbo frames. Updating the connection disrupts network connectivity for all virtual interfaces associated with the connection for up to 30 seconds. To check whether your connection supports jumbo frames, call <code>DescribeConnections</code>. To check whether your virtual interface supports jumbo frames, call <code>DescribeVirtualInterfaces</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePrivateVirtualInterface {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_private_virtual_interface_input::Builder,
    }
    impl CreatePrivateVirtualInterface {
        /// Creates a new `CreatePrivateVirtualInterface`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePrivateVirtualInterfaceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePrivateVirtualInterfaceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>Information about the private virtual interface.</p>
        pub fn new_private_virtual_interface(
            mut self,
            input: crate::model::NewPrivateVirtualInterface,
        ) -> Self {
            self.inner = self.inner.new_private_virtual_interface(input);
            self
        }
        /// <p>Information about the private virtual interface.</p>
        pub fn set_new_private_virtual_interface(
            mut self,
            input: std::option::Option<crate::model::NewPrivateVirtualInterface>,
        ) -> Self {
            self.inner = self.inner.set_new_private_virtual_interface(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePublicVirtualInterface`.
    ///
    /// <p>Creates a public virtual interface. A virtual interface is the VLAN that transports Direct Connect traffic. A public virtual interface supports sending traffic to public services of Amazon Web Services such as Amazon S3.</p>
    /// <p>When creating an IPv6 public virtual interface (<code>addressFamily</code> is <code>ipv6</code>), leave the <code>customer</code> and <code>amazon</code> address fields blank to use auto-assigned IPv6 space. Custom IPv6 addresses are not supported.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePublicVirtualInterface {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_public_virtual_interface_input::Builder,
    }
    impl CreatePublicVirtualInterface {
        /// Creates a new `CreatePublicVirtualInterface`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePublicVirtualInterfaceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePublicVirtualInterfaceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>Information about the public virtual interface.</p>
        pub fn new_public_virtual_interface(
            mut self,
            input: crate::model::NewPublicVirtualInterface,
        ) -> Self {
            self.inner = self.inner.new_public_virtual_interface(input);
            self
        }
        /// <p>Information about the public virtual interface.</p>
        pub fn set_new_public_virtual_interface(
            mut self,
            input: std::option::Option<crate::model::NewPublicVirtualInterface>,
        ) -> Self {
            self.inner = self.inner.set_new_public_virtual_interface(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTransitVirtualInterface`.
    ///
    /// <p>Creates a transit virtual interface. A transit virtual interface should be used to access one or more transit gateways associated with Direct Connect gateways. A transit virtual interface enables the connection of multiple VPCs attached to a transit gateway to a Direct Connect gateway.</p> <important>
    /// <p>If you associate your transit gateway with one or more Direct Connect gateways, the Autonomous System Number (ASN) used by the transit gateway and the Direct Connect gateway must be different. For example, if you use the default ASN 64512 for both your the transit gateway and Direct Connect gateway, the association request fails.</p>
    /// </important>
    /// <p>Setting the MTU of a virtual interface to 8500 (jumbo frames) can cause an update to the underlying physical connection if it wasn't updated to support jumbo frames. Updating the connection disrupts network connectivity for all virtual interfaces associated with the connection for up to 30 seconds. To check whether your connection supports jumbo frames, call <code>DescribeConnections</code>. To check whether your virtual interface supports jumbo frames, call <code>DescribeVirtualInterfaces</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTransitVirtualInterface {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_transit_virtual_interface_input::Builder,
    }
    impl CreateTransitVirtualInterface {
        /// Creates a new `CreateTransitVirtualInterface`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTransitVirtualInterfaceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTransitVirtualInterfaceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>Information about the transit virtual interface.</p>
        pub fn new_transit_virtual_interface(
            mut self,
            input: crate::model::NewTransitVirtualInterface,
        ) -> Self {
            self.inner = self.inner.new_transit_virtual_interface(input);
            self
        }
        /// <p>Information about the transit virtual interface.</p>
        pub fn set_new_transit_virtual_interface(
            mut self,
            input: std::option::Option<crate::model::NewTransitVirtualInterface>,
        ) -> Self {
            self.inner = self.inner.set_new_transit_virtual_interface(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBGPPeer`.
    ///
    /// <p>Deletes the specified BGP peer on the specified virtual interface with the specified customer address and ASN.</p>
    /// <p>You cannot delete the last BGP peer from a virtual interface.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBGPPeer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_bgp_peer_input::Builder,
    }
    impl DeleteBGPPeer {
        /// Creates a new `DeleteBGPPeer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBgpPeerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBGPPeerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_interface_id(input.into());
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_interface_id(input);
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        pub fn asn(mut self, input: i32) -> Self {
            self.inner = self.inner.asn(input);
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        pub fn set_asn(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_asn(input);
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn customer_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.customer_address(input.into());
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn set_customer_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_customer_address(input);
            self
        }
        /// <p>The ID of the BGP peer.</p>
        pub fn bgp_peer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bgp_peer_id(input.into());
            self
        }
        /// <p>The ID of the BGP peer.</p>
        pub fn set_bgp_peer_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bgp_peer_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConnection`.
    ///
    /// <p>Deletes the specified connection.</p>
    /// <p>Deleting a connection only stops the Direct Connect port hour and data transfer charges. If you are partnering with any third parties to connect with the Direct Connect location, you must cancel your service with them separately.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteConnection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_connection_input::Builder,
    }
    impl DeleteConnection {
        /// Creates a new `DeleteConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConnectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDirectConnectGateway`.
    ///
    /// <p>Deletes the specified Direct Connect gateway. You must first delete all virtual interfaces that are attached to the Direct Connect gateway and disassociate all virtual private gateways associated with the Direct Connect gateway.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDirectConnectGateway {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_direct_connect_gateway_input::Builder,
    }
    impl DeleteDirectConnectGateway {
        /// Creates a new `DeleteDirectConnectGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDirectConnectGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDirectConnectGatewayError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.direct_connect_gateway_id(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_direct_connect_gateway_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDirectConnectGatewayAssociation`.
    ///
    /// <p>Deletes the association between the specified Direct Connect gateway and virtual private gateway.</p>
    /// <p>We recommend that you specify the <code>associationID</code> to delete the association. Alternatively, if you own virtual gateway and a Direct Connect gateway association, you can specify the <code>virtualGatewayId</code> and <code>directConnectGatewayId</code> to delete an association.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDirectConnectGatewayAssociation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_direct_connect_gateway_association_input::Builder,
    }
    impl DeleteDirectConnectGatewayAssociation {
        /// Creates a new `DeleteDirectConnectGatewayAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDirectConnectGatewayAssociationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteDirectConnectGatewayAssociationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Direct Connect gateway association.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_id(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway association.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_id(input);
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.direct_connect_gateway_id(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_direct_connect_gateway_id(input);
            self
        }
        /// <p>The ID of the virtual private gateway.</p>
        pub fn virtual_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_gateway_id(input.into());
            self
        }
        /// <p>The ID of the virtual private gateway.</p>
        pub fn set_virtual_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_gateway_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDirectConnectGatewayAssociationProposal`.
    ///
    /// <p>Deletes the association proposal request between the specified Direct Connect gateway and virtual private gateway or transit gateway.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDirectConnectGatewayAssociationProposal {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_direct_connect_gateway_association_proposal_input::Builder,
    }
    impl DeleteDirectConnectGatewayAssociationProposal {
        /// Creates a new `DeleteDirectConnectGatewayAssociationProposal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDirectConnectGatewayAssociationProposalOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteDirectConnectGatewayAssociationProposalError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the proposal.</p>
        pub fn proposal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.proposal_id(input.into());
            self
        }
        /// <p>The ID of the proposal.</p>
        pub fn set_proposal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_proposal_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteInterconnect`.
    ///
    /// <p>Deletes the specified interconnect.</p> <note>
    /// <p>Intended for use by Direct Connect Partners only.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteInterconnect {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_interconnect_input::Builder,
    }
    impl DeleteInterconnect {
        /// Creates a new `DeleteInterconnect`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteInterconnectOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteInterconnectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the interconnect.</p>
        pub fn interconnect_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.interconnect_id(input.into());
            self
        }
        /// <p>The ID of the interconnect.</p>
        pub fn set_interconnect_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_interconnect_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLag`.
    ///
    /// <p>Deletes the specified link aggregation group (LAG). You cannot delete a LAG if it has active virtual interfaces or hosted connections.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLag {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_lag_input::Builder,
    }
    impl DeleteLag {
        /// Creates a new `DeleteLag`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLagOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLagError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lag_id(input.into());
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lag_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVirtualInterface`.
    ///
    /// <p>Deletes a virtual interface.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteVirtualInterface {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_virtual_interface_input::Builder,
    }
    impl DeleteVirtualInterface {
        /// Creates a new `DeleteVirtualInterface`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVirtualInterfaceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVirtualInterfaceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_interface_id(input.into());
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_interface_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConnectionLoa`.
    ///
    /// <p>Deprecated. Use <code>DescribeLoa</code> instead.</p>
    /// <p>Gets the LOA-CFA for a connection.</p>
    /// <p>The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is a document that your APN partner or service provider uses when establishing your cross connect to Amazon Web Services at the colocation facility. For more information, see <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html">Requesting Cross Connects at Direct Connect Locations</a> in the <i>Direct Connect User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConnectionLoa {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_connection_loa_input::Builder,
    }
    impl DescribeConnectionLoa {
        /// Creates a new `DescribeConnectionLoa`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConnectionLoaOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConnectionLoaError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>The name of the APN partner or service provider who establishes connectivity on your behalf. If you specify this parameter, the LOA-CFA lists the provider name alongside your company name as the requester of the cross connect.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider_name(input.into());
            self
        }
        /// <p>The name of the APN partner or service provider who establishes connectivity on your behalf. If you specify this parameter, the LOA-CFA lists the provider name alongside your company name as the requester of the cross connect.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provider_name(input);
            self
        }
        /// <p>The standard media type for the LOA-CFA document. The only supported value is application/pdf.</p>
        pub fn loa_content_type(mut self, input: crate::model::LoaContentType) -> Self {
            self.inner = self.inner.loa_content_type(input);
            self
        }
        /// <p>The standard media type for the LOA-CFA document. The only supported value is application/pdf.</p>
        pub fn set_loa_content_type(
            mut self,
            input: std::option::Option<crate::model::LoaContentType>,
        ) -> Self {
            self.inner = self.inner.set_loa_content_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConnections`.
    ///
    /// <p>Displays the specified connection or all connections in this Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConnections {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_connections_input::Builder,
    }
    impl DescribeConnections {
        /// Creates a new `DescribeConnections`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConnectionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConnectionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConnectionsOnInterconnect`.
    ///
    /// <p>Deprecated. Use <code>DescribeHostedConnections</code> instead.</p>
    /// <p>Lists the connections that have been provisioned on the specified interconnect.</p> <note>
    /// <p>Intended for use by Direct Connect Partners only.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConnectionsOnInterconnect {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_connections_on_interconnect_input::Builder,
    }
    impl DescribeConnectionsOnInterconnect {
        /// Creates a new `DescribeConnectionsOnInterconnect`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConnectionsOnInterconnectOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConnectionsOnInterconnectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the interconnect.</p>
        pub fn interconnect_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.interconnect_id(input.into());
            self
        }
        /// <p>The ID of the interconnect.</p>
        pub fn set_interconnect_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_interconnect_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCustomerMetadata`.
    ///
    /// <p>Get and view a list of customer agreements, along with their signed status and whether the customer is an NNIPartner, NNIPartnerV2, or a nonPartner. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCustomerMetadata {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_customer_metadata_input::Builder,
    }
    impl DescribeCustomerMetadata {
        /// Creates a new `DescribeCustomerMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCustomerMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCustomerMetadataError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeDirectConnectGatewayAssociationProposals`.
    ///
    /// <p>Describes one or more association proposals for connection between a virtual private gateway or transit gateway and a Direct Connect gateway. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDirectConnectGatewayAssociationProposals {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_direct_connect_gateway_association_proposals_input::Builder,
    }
    impl DescribeDirectConnectGatewayAssociationProposals {
        /// Creates a new `DescribeDirectConnectGatewayAssociationProposals`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDirectConnectGatewayAssociationProposalsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeDirectConnectGatewayAssociationProposalsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.direct_connect_gateway_id(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_direct_connect_gateway_id(input);
            self
        }
        /// <p>The ID of the proposal.</p>
        pub fn proposal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.proposal_id(input.into());
            self
        }
        /// <p>The ID of the proposal.</p>
        pub fn set_proposal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_proposal_id(input);
            self
        }
        /// <p>The ID of the associated gateway.</p>
        pub fn associated_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.associated_gateway_id(input.into());
            self
        }
        /// <p>The ID of the associated gateway.</p>
        pub fn set_associated_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_associated_gateway_id(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDirectConnectGatewayAssociations`.
    ///
    /// <p>Lists the associations between your Direct Connect gateways and virtual private gateways and transit gateways. You must specify one of the following:</p>
    /// <ul>
    /// <li> <p>A Direct Connect gateway</p> <p>The response contains all virtual private gateways and transit gateways associated with the Direct Connect gateway.</p> </li>
    /// <li> <p>A virtual private gateway</p> <p>The response contains the Direct Connect gateway.</p> </li>
    /// <li> <p>A transit gateway</p> <p>The response contains the Direct Connect gateway.</p> </li>
    /// <li> <p>A Direct Connect gateway and a virtual private gateway</p> <p>The response contains the association between the Direct Connect gateway and virtual private gateway.</p> </li>
    /// <li> <p>A Direct Connect gateway and a transit gateway</p> <p>The response contains the association between the Direct Connect gateway and transit gateway.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDirectConnectGatewayAssociations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_direct_connect_gateway_associations_input::Builder,
    }
    impl DescribeDirectConnectGatewayAssociations {
        /// Creates a new `DescribeDirectConnectGatewayAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDirectConnectGatewayAssociationsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeDirectConnectGatewayAssociationsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Direct Connect gateway association.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_id(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway association.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_id(input);
            self
        }
        /// <p>The ID of the associated gateway.</p>
        pub fn associated_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.associated_gateway_id(input.into());
            self
        }
        /// <p>The ID of the associated gateway.</p>
        pub fn set_associated_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_associated_gateway_id(input);
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.direct_connect_gateway_id(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_direct_connect_gateway_id(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token provided in the previous call to retrieve the next page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token provided in the previous call to retrieve the next page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The ID of the virtual private gateway or transit gateway.</p>
        pub fn virtual_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_gateway_id(input.into());
            self
        }
        /// <p>The ID of the virtual private gateway or transit gateway.</p>
        pub fn set_virtual_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_gateway_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDirectConnectGatewayAttachments`.
    ///
    /// <p>Lists the attachments between your Direct Connect gateways and virtual interfaces. You must specify a Direct Connect gateway, a virtual interface, or both. If you specify a Direct Connect gateway, the response contains all virtual interfaces attached to the Direct Connect gateway. If you specify a virtual interface, the response contains all Direct Connect gateways attached to the virtual interface. If you specify both, the response contains the attachment between the Direct Connect gateway and the virtual interface.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDirectConnectGatewayAttachments {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_direct_connect_gateway_attachments_input::Builder,
    }
    impl DescribeDirectConnectGatewayAttachments {
        /// Creates a new `DescribeDirectConnectGatewayAttachments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDirectConnectGatewayAttachmentsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeDirectConnectGatewayAttachmentsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.direct_connect_gateway_id(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_direct_connect_gateway_id(input);
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_interface_id(input.into());
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_interface_id(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token provided in the previous call to retrieve the next page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token provided in the previous call to retrieve the next page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDirectConnectGateways`.
    ///
    /// <p>Lists all your Direct Connect gateways or only the specified Direct Connect gateway. Deleted Direct Connect gateways are not returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDirectConnectGateways {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_direct_connect_gateways_input::Builder,
    }
    impl DescribeDirectConnectGateways {
        /// Creates a new `DescribeDirectConnectGateways`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDirectConnectGatewaysOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDirectConnectGatewaysError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.direct_connect_gateway_id(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_direct_connect_gateway_id(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token provided in the previous call to retrieve the next page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token provided in the previous call to retrieve the next page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeHostedConnections`.
    ///
    /// <p>Lists the hosted connections that have been provisioned on the specified interconnect or link aggregation group (LAG).</p> <note>
    /// <p>Intended for use by Direct Connect Partners only.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeHostedConnections {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_hosted_connections_input::Builder,
    }
    impl DescribeHostedConnections {
        /// Creates a new `DescribeHostedConnections`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeHostedConnectionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeHostedConnectionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the interconnect or LAG.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of the interconnect or LAG.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInterconnectLoa`.
    ///
    /// <p>Deprecated. Use <code>DescribeLoa</code> instead.</p>
    /// <p>Gets the LOA-CFA for the specified interconnect.</p>
    /// <p>The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is a document that is used when establishing your cross connect to Amazon Web Services at the colocation facility. For more information, see <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html">Requesting Cross Connects at Direct Connect Locations</a> in the <i>Direct Connect User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeInterconnectLoa {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_interconnect_loa_input::Builder,
    }
    impl DescribeInterconnectLoa {
        /// Creates a new `DescribeInterconnectLoa`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInterconnectLoaOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInterconnectLoaError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the interconnect.</p>
        pub fn interconnect_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.interconnect_id(input.into());
            self
        }
        /// <p>The ID of the interconnect.</p>
        pub fn set_interconnect_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_interconnect_id(input);
            self
        }
        /// <p>The name of the service provider who establishes connectivity on your behalf. If you supply this parameter, the LOA-CFA lists the provider name alongside your company name as the requester of the cross connect.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider_name(input.into());
            self
        }
        /// <p>The name of the service provider who establishes connectivity on your behalf. If you supply this parameter, the LOA-CFA lists the provider name alongside your company name as the requester of the cross connect.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provider_name(input);
            self
        }
        /// <p>The standard media type for the LOA-CFA document. The only supported value is application/pdf.</p>
        pub fn loa_content_type(mut self, input: crate::model::LoaContentType) -> Self {
            self.inner = self.inner.loa_content_type(input);
            self
        }
        /// <p>The standard media type for the LOA-CFA document. The only supported value is application/pdf.</p>
        pub fn set_loa_content_type(
            mut self,
            input: std::option::Option<crate::model::LoaContentType>,
        ) -> Self {
            self.inner = self.inner.set_loa_content_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInterconnects`.
    ///
    /// <p>Lists the interconnects owned by the Amazon Web Services account or only the specified interconnect.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeInterconnects {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_interconnects_input::Builder,
    }
    impl DescribeInterconnects {
        /// Creates a new `DescribeInterconnects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInterconnectsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInterconnectsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the interconnect.</p>
        pub fn interconnect_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.interconnect_id(input.into());
            self
        }
        /// <p>The ID of the interconnect.</p>
        pub fn set_interconnect_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_interconnect_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLags`.
    ///
    /// <p>Describes all your link aggregation groups (LAG) or the specified LAG.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_lags_input::Builder,
    }
    impl DescribeLags {
        /// Creates a new `DescribeLags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLagsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lag_id(input.into());
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lag_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLoa`.
    ///
    /// <p>Gets the LOA-CFA for a connection, interconnect, or link aggregation group (LAG).</p>
    /// <p>The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is a document that is used when establishing your cross connect to Amazon Web Services at the colocation facility. For more information, see <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html">Requesting Cross Connects at Direct Connect Locations</a> in the <i>Direct Connect User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLoa {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_loa_input::Builder,
    }
    impl DescribeLoa {
        /// Creates a new `DescribeLoa`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLoaOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLoaError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a connection, LAG, or interconnect.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of a connection, LAG, or interconnect.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>The name of the service provider who establishes connectivity on your behalf. If you specify this parameter, the LOA-CFA lists the provider name alongside your company name as the requester of the cross connect.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider_name(input.into());
            self
        }
        /// <p>The name of the service provider who establishes connectivity on your behalf. If you specify this parameter, the LOA-CFA lists the provider name alongside your company name as the requester of the cross connect.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provider_name(input);
            self
        }
        /// <p>The standard media type for the LOA-CFA document. The only supported value is application/pdf.</p>
        pub fn loa_content_type(mut self, input: crate::model::LoaContentType) -> Self {
            self.inner = self.inner.loa_content_type(input);
            self
        }
        /// <p>The standard media type for the LOA-CFA document. The only supported value is application/pdf.</p>
        pub fn set_loa_content_type(
            mut self,
            input: std::option::Option<crate::model::LoaContentType>,
        ) -> Self {
            self.inner = self.inner.set_loa_content_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLocations`.
    ///
    /// <p>Lists the Direct Connect locations in the current Amazon Web Services Region. These are the locations that can be selected when calling <code>CreateConnection</code> or <code>CreateInterconnect</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLocations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_locations_input::Builder,
    }
    impl DescribeLocations {
        /// Creates a new `DescribeLocations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLocationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLocationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeRouterConfiguration`.
    ///
    /// <p> Details about the router. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRouterConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_router_configuration_input::Builder,
    }
    impl DescribeRouterConfiguration {
        /// Creates a new `DescribeRouterConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRouterConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRouterConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_interface_id(input.into());
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_interface_id(input);
            self
        }
        /// <p>Identifies the router by a combination of vendor, platform, and software version. For example, <code>CiscoSystemsInc-2900SeriesRouters-IOS124</code>.</p>
        pub fn router_type_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.router_type_identifier(input.into());
            self
        }
        /// <p>Identifies the router by a combination of vendor, platform, and software version. For example, <code>CiscoSystemsInc-2900SeriesRouters-IOS124</code>.</p>
        pub fn set_router_type_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_router_type_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTags`.
    ///
    /// <p>Describes the tags associated with the specified Direct Connect resources.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_tags_input::Builder,
    }
    impl DescribeTags {
        /// Creates a new `DescribeTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `resourceArns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arns(input.into());
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeVirtualGateways`.
    ///
    /// <p>Lists the virtual private gateways owned by the Amazon Web Services account.</p>
    /// <p>You can create one or more Direct Connect private virtual interfaces linked to a virtual private gateway.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeVirtualGateways {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_virtual_gateways_input::Builder,
    }
    impl DescribeVirtualGateways {
        /// Creates a new `DescribeVirtualGateways`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeVirtualGatewaysOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeVirtualGatewaysError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeVirtualInterfaces`.
    ///
    /// <p>Displays all virtual interfaces for an Amazon Web Services account. Virtual interfaces deleted fewer than 15 minutes before you make the request are also returned. If you specify a connection ID, only the virtual interfaces associated with the connection are returned. If you specify a virtual interface ID, then only a single virtual interface is returned.</p>
    /// <p>A virtual interface (VLAN) transmits the traffic between the Direct Connect location and the customer network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeVirtualInterfaces {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_virtual_interfaces_input::Builder,
    }
    impl DescribeVirtualInterfaces {
        /// Creates a new `DescribeVirtualInterfaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeVirtualInterfacesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeVirtualInterfacesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_interface_id(input.into());
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_interface_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateConnectionFromLag`.
    ///
    /// <p>Disassociates a connection from a link aggregation group (LAG). The connection is interrupted and re-established as a standalone connection (the connection is not deleted; to delete the connection, use the <code>DeleteConnection</code> request). If the LAG has associated virtual interfaces or hosted connections, they remain associated with the LAG. A disassociated connection owned by an Direct Connect Partner is automatically converted to an interconnect.</p>
    /// <p>If disassociating the connection would cause the LAG to fall below its setting for minimum number of operational connections, the request fails, except when it's the last member of the LAG. If all connections are disassociated, the LAG continues to exist as an empty LAG with no physical connections. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateConnectionFromLag {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_connection_from_lag_input::Builder,
    }
    impl DisassociateConnectionFromLag {
        /// Creates a new `DisassociateConnectionFromLag`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateConnectionFromLagOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateConnectionFromLagError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lag_id(input.into());
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lag_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateMacSecKey`.
    ///
    /// <p>Removes the association between a MAC Security (MACsec) security key and an Direct Connect dedicated connection.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateMacSecKey {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_mac_sec_key_input::Builder,
    }
    impl DisassociateMacSecKey {
        /// Creates a new `DisassociateMacSecKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateMacSecKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateMacSecKeyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).</p>
        /// <p>You can use <code>DescribeConnections</code> or <code>DescribeLags</code> to retrieve connection ID.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).</p>
        /// <p>You can use <code>DescribeConnections</code> or <code>DescribeLags</code> to retrieve connection ID.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key.</p>
        /// <p>You can use <code>DescribeConnections</code> to retrieve the ARN of the MAC Security (MACsec) secret key.</p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key.</p>
        /// <p>You can use <code>DescribeConnections</code> to retrieve the ARN of the MAC Security (MACsec) secret key.</p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVirtualInterfaceTestHistory`.
    ///
    /// <p>Lists the virtual interface failover test history.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListVirtualInterfaceTestHistory {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_virtual_interface_test_history_input::Builder,
    }
    impl ListVirtualInterfaceTestHistory {
        /// Creates a new `ListVirtualInterfaceTestHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVirtualInterfaceTestHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::ListVirtualInterfaceTestHistoryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the virtual interface failover test.</p>
        pub fn test_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.test_id(input.into());
            self
        }
        /// <p>The ID of the virtual interface failover test.</p>
        pub fn set_test_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_test_id(input);
            self
        }
        /// <p>The ID of the virtual interface that was tested.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_interface_id(input.into());
            self
        }
        /// <p>The ID of the virtual interface that was tested.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_interface_id(input);
            self
        }
        /// Appends an item to `bgpPeers`.
        ///
        /// To override the contents of this collection use [`set_bgp_peers`](Self::set_bgp_peers).
        ///
        /// <p>The BGP peers that were placed in the DOWN state during the virtual interface failover test.</p>
        pub fn bgp_peers(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bgp_peers(input.into());
            self
        }
        /// <p>The BGP peers that were placed in the DOWN state during the virtual interface failover test.</p>
        pub fn set_bgp_peers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_bgp_peers(input);
            self
        }
        /// <p>The status of the virtual interface failover test.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status(input.into());
            self
        }
        /// <p>The status of the virtual interface failover test.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartBgpFailoverTest`.
    ///
    /// <p>Starts the virtual interface failover test that verifies your configuration meets your resiliency requirements by placing the BGP peering session in the DOWN state. You can then send traffic to verify that there are no outages.</p>
    /// <p>You can run the test on public, private, transit, and hosted virtual interfaces.</p>
    /// <p>You can use <a href="https://docs.aws.amazon.com/directconnect/latest/APIReference/API_ListVirtualInterfaceTestHistory.html">ListVirtualInterfaceTestHistory</a> to view the virtual interface test history.</p>
    /// <p>If you need to stop the test before the test interval completes, use <a href="https://docs.aws.amazon.com/directconnect/latest/APIReference/API_StopBgpFailoverTest.html">StopBgpFailoverTest</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartBgpFailoverTest {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_bgp_failover_test_input::Builder,
    }
    impl StartBgpFailoverTest {
        /// Creates a new `StartBgpFailoverTest`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartBgpFailoverTestOutput,
            aws_smithy_http::result::SdkError<crate::error::StartBgpFailoverTestError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the virtual interface you want to test.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_interface_id(input.into());
            self
        }
        /// <p>The ID of the virtual interface you want to test.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_interface_id(input);
            self
        }
        /// Appends an item to `bgpPeers`.
        ///
        /// To override the contents of this collection use [`set_bgp_peers`](Self::set_bgp_peers).
        ///
        /// <p>The BGP peers to place in the DOWN state.</p>
        pub fn bgp_peers(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bgp_peers(input.into());
            self
        }
        /// <p>The BGP peers to place in the DOWN state.</p>
        pub fn set_bgp_peers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_bgp_peers(input);
            self
        }
        /// <p>The time in minutes that the virtual interface failover test will last.</p>
        /// <p>Maximum value: 180 minutes (3 hours).</p>
        /// <p>Default: 180 minutes (3 hours).</p>
        pub fn test_duration_in_minutes(mut self, input: i32) -> Self {
            self.inner = self.inner.test_duration_in_minutes(input);
            self
        }
        /// <p>The time in minutes that the virtual interface failover test will last.</p>
        /// <p>Maximum value: 180 minutes (3 hours).</p>
        /// <p>Default: 180 minutes (3 hours).</p>
        pub fn set_test_duration_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_test_duration_in_minutes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopBgpFailoverTest`.
    ///
    /// <p>Stops the virtual interface failover test.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopBgpFailoverTest {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_bgp_failover_test_input::Builder,
    }
    impl StopBgpFailoverTest {
        /// Creates a new `StopBgpFailoverTest`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopBgpFailoverTestOutput,
            aws_smithy_http::result::SdkError<crate::error::StopBgpFailoverTestError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the virtual interface you no longer want to test.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_interface_id(input.into());
            self
        }
        /// <p>The ID of the virtual interface you no longer want to test.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_interface_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds the specified tags to the specified Direct Connect resource. Each resource can have a maximum of 50 tags.</p>
    /// <p>Each tag consists of a key and an optional value. If a tag with the same key is already associated with the resource, this action updates its value.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to add.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from the specified Direct Connect resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys of the tags to remove.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag keys of the tags to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConnection`.
    ///
    /// <p>Updates the Direct Connect dedicated connection configuration.</p>
    /// <p>You can update the following parameters for a connection:</p>
    /// <ul>
    /// <li> <p>The connection name</p> </li>
    /// <li> <p>The connection's MAC Security (MACsec) encryption mode.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateConnection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_connection_input::Builder,
    }
    impl UpdateConnection {
        /// Creates a new `UpdateConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateConnectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the dedicated connection.</p>
        /// <p>You can use <code>DescribeConnections</code> to retrieve the connection ID.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(input.into());
            self
        }
        /// <p>The ID of the dedicated connection.</p>
        /// <p>You can use <code>DescribeConnections</code> to retrieve the connection ID.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>The name of the connection.</p>
        pub fn connection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_name(input.into());
            self
        }
        /// <p>The name of the connection.</p>
        pub fn set_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_name(input);
            self
        }
        /// <p>The connection MAC Security (MACsec) encryption mode.</p>
        /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
        pub fn encryption_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.encryption_mode(input.into());
            self
        }
        /// <p>The connection MAC Security (MACsec) encryption mode.</p>
        /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_encryption_mode(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDirectConnectGateway`.
    ///
    /// <p>Updates the name of a current Direct Connect gateway.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDirectConnectGateway {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_direct_connect_gateway_input::Builder,
    }
    impl UpdateDirectConnectGateway {
        /// Creates a new `UpdateDirectConnectGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDirectConnectGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDirectConnectGatewayError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Direct Connect gateway to update.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.direct_connect_gateway_id(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway to update.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_direct_connect_gateway_id(input);
            self
        }
        /// <p>The new name for the Direct Connect gateway.</p>
        pub fn new_direct_connect_gateway_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.new_direct_connect_gateway_name(input.into());
            self
        }
        /// <p>The new name for the Direct Connect gateway.</p>
        pub fn set_new_direct_connect_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_new_direct_connect_gateway_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDirectConnectGatewayAssociation`.
    ///
    /// <p>Updates the specified attributes of the Direct Connect gateway association.</p>
    /// <p>Add or remove prefixes from the association.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDirectConnectGatewayAssociation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_direct_connect_gateway_association_input::Builder,
    }
    impl UpdateDirectConnectGatewayAssociation {
        /// Creates a new `UpdateDirectConnectGatewayAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDirectConnectGatewayAssociationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateDirectConnectGatewayAssociationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Direct Connect gateway association.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_id(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway association.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_id(input);
            self
        }
        /// Appends an item to `addAllowedPrefixesToDirectConnectGateway`.
        ///
        /// To override the contents of this collection use [`set_add_allowed_prefixes_to_direct_connect_gateway`](Self::set_add_allowed_prefixes_to_direct_connect_gateway).
        ///
        /// <p>The Amazon VPC prefixes to advertise to the Direct Connect gateway.</p>
        pub fn add_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: crate::model::RouteFilterPrefix,
        ) -> Self {
            self.inner = self
                .inner
                .add_allowed_prefixes_to_direct_connect_gateway(input);
            self
        }
        /// <p>The Amazon VPC prefixes to advertise to the Direct Connect gateway.</p>
        pub fn set_add_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_add_allowed_prefixes_to_direct_connect_gateway(input);
            self
        }
        /// Appends an item to `removeAllowedPrefixesToDirectConnectGateway`.
        ///
        /// To override the contents of this collection use [`set_remove_allowed_prefixes_to_direct_connect_gateway`](Self::set_remove_allowed_prefixes_to_direct_connect_gateway).
        ///
        /// <p>The Amazon VPC prefixes to no longer advertise to the Direct Connect gateway.</p>
        pub fn remove_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: crate::model::RouteFilterPrefix,
        ) -> Self {
            self.inner = self
                .inner
                .remove_allowed_prefixes_to_direct_connect_gateway(input);
            self
        }
        /// <p>The Amazon VPC prefixes to no longer advertise to the Direct Connect gateway.</p>
        pub fn set_remove_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_remove_allowed_prefixes_to_direct_connect_gateway(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLag`.
    ///
    /// <p>Updates the attributes of the specified link aggregation group (LAG).</p>
    /// <p>You can update the following LAG attributes:</p>
    /// <ul>
    /// <li> <p>The name of the LAG.</p> </li>
    /// <li> <p>The value for the minimum number of connections that must be operational for the LAG itself to be operational. </p> </li>
    /// <li> <p>The LAG's MACsec encryption mode.</p> <p>Amazon Web Services assigns this value to each connection which is part of the LAG.</p> </li>
    /// <li> <p>The tags</p> </li>
    /// </ul> <note>
    /// <p>If you adjust the threshold value for the minimum number of operational connections, ensure that the new value does not cause the LAG to fall below the threshold and become non-operational.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateLag {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_lag_input::Builder,
    }
    impl UpdateLag {
        /// Creates a new `UpdateLag`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLagOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLagError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lag_id(input.into());
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lag_id(input);
            self
        }
        /// <p>The name of the LAG.</p>
        pub fn lag_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lag_name(input.into());
            self
        }
        /// <p>The name of the LAG.</p>
        pub fn set_lag_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lag_name(input);
            self
        }
        /// <p>The minimum number of physical connections that must be operational for the LAG itself to be operational.</p>
        pub fn minimum_links(mut self, input: i32) -> Self {
            self.inner = self.inner.minimum_links(input);
            self
        }
        /// <p>The minimum number of physical connections that must be operational for the LAG itself to be operational.</p>
        pub fn set_minimum_links(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_minimum_links(input);
            self
        }
        /// <p>The LAG MAC Security (MACsec) encryption mode.</p>
        /// <p>Amazon Web Services applies the value to all connections which are part of the LAG.</p>
        pub fn encryption_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.encryption_mode(input.into());
            self
        }
        /// <p>The LAG MAC Security (MACsec) encryption mode.</p>
        /// <p>Amazon Web Services applies the value to all connections which are part of the LAG.</p>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_encryption_mode(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateVirtualInterfaceAttributes`.
    ///
    /// <p>Updates the specified attributes of the specified virtual private interface.</p>
    /// <p>Setting the MTU of a virtual interface to 9001 (jumbo frames) can cause an update to the underlying physical connection if it wasn't updated to support jumbo frames. Updating the connection disrupts network connectivity for all virtual interfaces associated with the connection for up to 30 seconds. To check whether your connection supports jumbo frames, call <code>DescribeConnections</code>. To check whether your virtual q interface supports jumbo frames, call <code>DescribeVirtualInterfaces</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateVirtualInterfaceAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_virtual_interface_attributes_input::Builder,
    }
    impl UpdateVirtualInterfaceAttributes {
        /// Creates a new `UpdateVirtualInterfaceAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateVirtualInterfaceAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateVirtualInterfaceAttributesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the virtual private interface.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_interface_id(input.into());
            self
        }
        /// <p>The ID of the virtual private interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_interface_id(input);
            self
        }
        /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
        pub fn mtu(mut self, input: i32) -> Self {
            self.inner = self.inner.mtu(input);
            self
        }
        /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
        pub fn set_mtu(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_mtu(input);
            self
        }
        /// <p>Indicates whether to enable or disable SiteLink.</p>
        pub fn enable_site_link(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_site_link(input);
            self
        }
        /// <p>Indicates whether to enable or disable SiteLink.</p>
        pub fn set_enable_site_link(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_site_link(input);
            self
        }
        /// <p>The name of the virtual private interface.</p>
        pub fn virtual_interface_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_interface_name(input.into());
            self
        }
        /// <p>The name of the virtual private interface.</p>
        pub fn set_virtual_interface_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_interface_name(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
