// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Information about a tag.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Information about a BGP peer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BgpPeer {
    /// <p>The ID of the BGP peer.</p>
    pub bgp_peer_id: std::option::Option<std::string::String>,
    /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
    pub asn: i32,
    /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
    pub auth_key: std::option::Option<std::string::String>,
    /// <p>The address family for the BGP peer.</p>
    pub address_family: std::option::Option<crate::model::AddressFamily>,
    /// <p>The IP address assigned to the Amazon interface.</p>
    pub amazon_address: std::option::Option<std::string::String>,
    /// <p>The IP address assigned to the customer interface.</p>
    pub customer_address: std::option::Option<std::string::String>,
    /// <p>The state of the BGP peer. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>verifying</code>: The BGP peering addresses or ASN require validation before the BGP peer can be created. This state applies only to public virtual interfaces.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: The BGP peer is created, and remains in this state until it is ready to be established.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: The BGP peer is ready to be established.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>:  The BGP peer is being deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>:  The BGP peer is deleted and cannot be established.</p>
    /// </li>
    /// </ul>
    pub bgp_peer_state: std::option::Option<crate::model::BgpPeerState>,
    /// <p>The status of the BGP peer. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>up</code>: The BGP peer is established. This state does not indicate the
    /// state of the routing function. Ensure that you are receiving routes over the BGP session.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: The BGP peer is down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The BGP peer status is not available.</p>
    /// </li>
    /// </ul>
    pub bgp_status: std::option::Option<crate::model::BgpStatus>,
    /// <p>The Direct Connect endpoint that terminates the BGP peer.</p>
    pub aws_device_v2: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
    /// different than the device that terminates the physical connection.</p>
    pub aws_logical_device_id: std::option::Option<std::string::String>,
}
impl BgpPeer {
    /// <p>The ID of the BGP peer.</p>
    pub fn bgp_peer_id(&self) -> std::option::Option<&str> {
        self.bgp_peer_id.as_deref()
    }
    /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
    pub fn asn(&self) -> i32 {
        self.asn
    }
    /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
    pub fn auth_key(&self) -> std::option::Option<&str> {
        self.auth_key.as_deref()
    }
    /// <p>The address family for the BGP peer.</p>
    pub fn address_family(&self) -> std::option::Option<&crate::model::AddressFamily> {
        self.address_family.as_ref()
    }
    /// <p>The IP address assigned to the Amazon interface.</p>
    pub fn amazon_address(&self) -> std::option::Option<&str> {
        self.amazon_address.as_deref()
    }
    /// <p>The IP address assigned to the customer interface.</p>
    pub fn customer_address(&self) -> std::option::Option<&str> {
        self.customer_address.as_deref()
    }
    /// <p>The state of the BGP peer. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>verifying</code>: The BGP peering addresses or ASN require validation before the BGP peer can be created. This state applies only to public virtual interfaces.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: The BGP peer is created, and remains in this state until it is ready to be established.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: The BGP peer is ready to be established.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>:  The BGP peer is being deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>:  The BGP peer is deleted and cannot be established.</p>
    /// </li>
    /// </ul>
    pub fn bgp_peer_state(&self) -> std::option::Option<&crate::model::BgpPeerState> {
        self.bgp_peer_state.as_ref()
    }
    /// <p>The status of the BGP peer. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>up</code>: The BGP peer is established. This state does not indicate the
    /// state of the routing function. Ensure that you are receiving routes over the BGP session.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: The BGP peer is down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The BGP peer status is not available.</p>
    /// </li>
    /// </ul>
    pub fn bgp_status(&self) -> std::option::Option<&crate::model::BgpStatus> {
        self.bgp_status.as_ref()
    }
    /// <p>The Direct Connect endpoint that terminates the BGP peer.</p>
    pub fn aws_device_v2(&self) -> std::option::Option<&str> {
        self.aws_device_v2.as_deref()
    }
    /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
    /// different than the device that terminates the physical connection.</p>
    pub fn aws_logical_device_id(&self) -> std::option::Option<&str> {
        self.aws_logical_device_id.as_deref()
    }
}
impl std::fmt::Debug for BgpPeer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BgpPeer");
        formatter.field("bgp_peer_id", &self.bgp_peer_id);
        formatter.field("asn", &self.asn);
        formatter.field("auth_key", &self.auth_key);
        formatter.field("address_family", &self.address_family);
        formatter.field("amazon_address", &self.amazon_address);
        formatter.field("customer_address", &self.customer_address);
        formatter.field("bgp_peer_state", &self.bgp_peer_state);
        formatter.field("bgp_status", &self.bgp_status);
        formatter.field("aws_device_v2", &self.aws_device_v2);
        formatter.field("aws_logical_device_id", &self.aws_logical_device_id);
        formatter.finish()
    }
}
/// See [`BgpPeer`](crate::model::BgpPeer)
pub mod bgp_peer {
    /// A builder for [`BgpPeer`](crate::model::BgpPeer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bgp_peer_id: std::option::Option<std::string::String>,
        pub(crate) asn: std::option::Option<i32>,
        pub(crate) auth_key: std::option::Option<std::string::String>,
        pub(crate) address_family: std::option::Option<crate::model::AddressFamily>,
        pub(crate) amazon_address: std::option::Option<std::string::String>,
        pub(crate) customer_address: std::option::Option<std::string::String>,
        pub(crate) bgp_peer_state: std::option::Option<crate::model::BgpPeerState>,
        pub(crate) bgp_status: std::option::Option<crate::model::BgpStatus>,
        pub(crate) aws_device_v2: std::option::Option<std::string::String>,
        pub(crate) aws_logical_device_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the BGP peer.</p>
        pub fn bgp_peer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bgp_peer_id = Some(input.into());
            self
        }
        /// <p>The ID of the BGP peer.</p>
        pub fn set_bgp_peer_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bgp_peer_id = input;
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        pub fn asn(mut self, input: i32) -> Self {
            self.asn = Some(input);
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        pub fn set_asn(mut self, input: std::option::Option<i32>) -> Self {
            self.asn = input;
            self
        }
        /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
        pub fn auth_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.auth_key = Some(input.into());
            self
        }
        /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
        pub fn set_auth_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.auth_key = input;
            self
        }
        /// <p>The address family for the BGP peer.</p>
        pub fn address_family(mut self, input: crate::model::AddressFamily) -> Self {
            self.address_family = Some(input);
            self
        }
        /// <p>The address family for the BGP peer.</p>
        pub fn set_address_family(
            mut self,
            input: std::option::Option<crate::model::AddressFamily>,
        ) -> Self {
            self.address_family = input;
            self
        }
        /// <p>The IP address assigned to the Amazon interface.</p>
        pub fn amazon_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.amazon_address = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the Amazon interface.</p>
        pub fn set_amazon_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amazon_address = input;
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn customer_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_address = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn set_customer_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_address = input;
            self
        }
        /// <p>The state of the BGP peer. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>verifying</code>: The BGP peering addresses or ASN require validation before the BGP peer can be created. This state applies only to public virtual interfaces.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The BGP peer is created, and remains in this state until it is ready to be established.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The BGP peer is ready to be established.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>:  The BGP peer is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>:  The BGP peer is deleted and cannot be established.</p>
        /// </li>
        /// </ul>
        pub fn bgp_peer_state(mut self, input: crate::model::BgpPeerState) -> Self {
            self.bgp_peer_state = Some(input);
            self
        }
        /// <p>The state of the BGP peer. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>verifying</code>: The BGP peering addresses or ASN require validation before the BGP peer can be created. This state applies only to public virtual interfaces.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The BGP peer is created, and remains in this state until it is ready to be established.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The BGP peer is ready to be established.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>:  The BGP peer is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>:  The BGP peer is deleted and cannot be established.</p>
        /// </li>
        /// </ul>
        pub fn set_bgp_peer_state(
            mut self,
            input: std::option::Option<crate::model::BgpPeerState>,
        ) -> Self {
            self.bgp_peer_state = input;
            self
        }
        /// <p>The status of the BGP peer. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>up</code>: The BGP peer is established. This state does not indicate the
        /// state of the routing function. Ensure that you are receiving routes over the BGP session.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The BGP peer is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The BGP peer status is not available.</p>
        /// </li>
        /// </ul>
        pub fn bgp_status(mut self, input: crate::model::BgpStatus) -> Self {
            self.bgp_status = Some(input);
            self
        }
        /// <p>The status of the BGP peer. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>up</code>: The BGP peer is established. This state does not indicate the
        /// state of the routing function. Ensure that you are receiving routes over the BGP session.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The BGP peer is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The BGP peer status is not available.</p>
        /// </li>
        /// </ul>
        pub fn set_bgp_status(
            mut self,
            input: std::option::Option<crate::model::BgpStatus>,
        ) -> Self {
            self.bgp_status = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the BGP peer.</p>
        pub fn aws_device_v2(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device_v2 = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the BGP peer.</p>
        pub fn set_aws_device_v2(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_device_v2 = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn aws_logical_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_logical_device_id = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn set_aws_logical_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_logical_device_id = input;
            self
        }
        /// Consumes the builder and constructs a [`BgpPeer`](crate::model::BgpPeer)
        pub fn build(self) -> crate::model::BgpPeer {
            crate::model::BgpPeer {
                bgp_peer_id: self.bgp_peer_id,
                asn: self.asn.unwrap_or_default(),
                auth_key: self.auth_key,
                address_family: self.address_family,
                amazon_address: self.amazon_address,
                customer_address: self.customer_address,
                bgp_peer_state: self.bgp_peer_state,
                bgp_status: self.bgp_status,
                aws_device_v2: self.aws_device_v2,
                aws_logical_device_id: self.aws_logical_device_id,
            }
        }
    }
}
impl BgpPeer {
    /// Creates a new builder-style object to manufacture [`BgpPeer`](crate::model::BgpPeer)
    pub fn builder() -> crate::model::bgp_peer::Builder {
        crate::model::bgp_peer::Builder::default()
    }
}

/// _Note: `BgpStatus::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BgpStatus {
    #[allow(missing_docs)] // documentation missing in model
    Down,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    #[allow(missing_docs)] // documentation missing in model
    Up,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BgpStatus {
    fn from(s: &str) -> Self {
        match s {
            "down" => BgpStatus::Down,
            "unknown" => BgpStatus::UnknownValue,
            "up" => BgpStatus::Up,
            other => BgpStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BgpStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BgpStatus::from(s))
    }
}
impl BgpStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BgpStatus::Down => "down",
            BgpStatus::UnknownValue => "unknown",
            BgpStatus::Up => "up",
            BgpStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["down", "unknown", "up"]
    }
}
impl AsRef<str> for BgpStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BgpPeerState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Verifying,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BgpPeerState {
    fn from(s: &str) -> Self {
        match s {
            "available" => BgpPeerState::Available,
            "deleted" => BgpPeerState::Deleted,
            "deleting" => BgpPeerState::Deleting,
            "pending" => BgpPeerState::Pending,
            "verifying" => BgpPeerState::Verifying,
            other => BgpPeerState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BgpPeerState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BgpPeerState::from(s))
    }
}
impl BgpPeerState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BgpPeerState::Available => "available",
            BgpPeerState::Deleted => "deleted",
            BgpPeerState::Deleting => "deleting",
            BgpPeerState::Pending => "pending",
            BgpPeerState::Verifying => "verifying",
            BgpPeerState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["available", "deleted", "deleting", "pending", "verifying"]
    }
}
impl AsRef<str> for BgpPeerState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AddressFamily {
    #[allow(missing_docs)] // documentation missing in model
    IPv4,
    #[allow(missing_docs)] // documentation missing in model
    IPv6,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AddressFamily {
    fn from(s: &str) -> Self {
        match s {
            "ipv4" => AddressFamily::IPv4,
            "ipv6" => AddressFamily::IPv6,
            other => AddressFamily::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AddressFamily {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AddressFamily::from(s))
    }
}
impl AddressFamily {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AddressFamily::IPv4 => "ipv4",
            AddressFamily::IPv6 => "ipv6",
            AddressFamily::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ipv4", "ipv6"]
    }
}
impl AsRef<str> for AddressFamily {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a route filter prefix that a customer can advertise through Border Gateway Protocol (BGP)
/// over a public virtual interface.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RouteFilterPrefix {
    /// <p>The CIDR block for the advertised route. Separate multiple routes using commas. An IPv6 CIDR must use /64 or shorter.</p>
    pub cidr: std::option::Option<std::string::String>,
}
impl RouteFilterPrefix {
    /// <p>The CIDR block for the advertised route. Separate multiple routes using commas. An IPv6 CIDR must use /64 or shorter.</p>
    pub fn cidr(&self) -> std::option::Option<&str> {
        self.cidr.as_deref()
    }
}
impl std::fmt::Debug for RouteFilterPrefix {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RouteFilterPrefix");
        formatter.field("cidr", &self.cidr);
        formatter.finish()
    }
}
/// See [`RouteFilterPrefix`](crate::model::RouteFilterPrefix)
pub mod route_filter_prefix {
    /// A builder for [`RouteFilterPrefix`](crate::model::RouteFilterPrefix)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cidr: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The CIDR block for the advertised route. Separate multiple routes using commas. An IPv6 CIDR must use /64 or shorter.</p>
        pub fn cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.cidr = Some(input.into());
            self
        }
        /// <p>The CIDR block for the advertised route. Separate multiple routes using commas. An IPv6 CIDR must use /64 or shorter.</p>
        pub fn set_cidr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cidr = input;
            self
        }
        /// Consumes the builder and constructs a [`RouteFilterPrefix`](crate::model::RouteFilterPrefix)
        pub fn build(self) -> crate::model::RouteFilterPrefix {
            crate::model::RouteFilterPrefix { cidr: self.cidr }
        }
    }
}
impl RouteFilterPrefix {
    /// Creates a new builder-style object to manufacture [`RouteFilterPrefix`](crate::model::RouteFilterPrefix)
    pub fn builder() -> crate::model::route_filter_prefix::Builder {
        crate::model::route_filter_prefix::Builder::default()
    }
}

/// _Note: `VirtualInterfaceState::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VirtualInterfaceState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Confirming,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Down,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Rejected,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    #[allow(missing_docs)] // documentation missing in model
    Verifying,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VirtualInterfaceState {
    fn from(s: &str) -> Self {
        match s {
            "available" => VirtualInterfaceState::Available,
            "confirming" => VirtualInterfaceState::Confirming,
            "deleted" => VirtualInterfaceState::Deleted,
            "deleting" => VirtualInterfaceState::Deleting,
            "down" => VirtualInterfaceState::Down,
            "pending" => VirtualInterfaceState::Pending,
            "rejected" => VirtualInterfaceState::Rejected,
            "unknown" => VirtualInterfaceState::UnknownValue,
            "verifying" => VirtualInterfaceState::Verifying,
            other => VirtualInterfaceState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VirtualInterfaceState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VirtualInterfaceState::from(s))
    }
}
impl VirtualInterfaceState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VirtualInterfaceState::Available => "available",
            VirtualInterfaceState::Confirming => "confirming",
            VirtualInterfaceState::Deleted => "deleted",
            VirtualInterfaceState::Deleting => "deleting",
            VirtualInterfaceState::Down => "down",
            VirtualInterfaceState::Pending => "pending",
            VirtualInterfaceState::Rejected => "rejected",
            VirtualInterfaceState::UnknownValue => "unknown",
            VirtualInterfaceState::Verifying => "verifying",
            VirtualInterfaceState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "available",
            "confirming",
            "deleted",
            "deleting",
            "down",
            "pending",
            "rejected",
            "unknown",
            "verifying",
        ]
    }
}
impl AsRef<str> for VirtualInterfaceState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the MAC Security (MACsec) secret key.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MacSecKey {
    /// <p>The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key.</p>
    pub secret_arn: std::option::Option<std::string::String>,
    /// <p>The Connection Key Name (CKN) for the MAC Security secret key.</p>
    pub ckn: std::option::Option<std::string::String>,
    /// <p>The state of the MAC Security (MACsec) secret key.</p>
    /// <p>The possible values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>associating</code>: The MAC Security (MACsec) secret key is being validated and not yet associated with the connection or LAG.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>associated</code>: The MAC Security (MACsec) secret key is validated and associated with the connection or LAG.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>disassociating</code>: The MAC Security (MACsec) secret key is being disassociated from the connection or LAG</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>disassociated</code>: The MAC Security (MACsec) secret key is no longer associated with the connection or LAG.</p>
    /// </li>
    /// </ul>
    pub state: std::option::Option<std::string::String>,
    /// <p>The date that the MAC Security (MACsec) secret key takes effect. The value is displayed in UTC format.</p>
    pub start_on: std::option::Option<std::string::String>,
}
impl MacSecKey {
    /// <p>The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key.</p>
    pub fn secret_arn(&self) -> std::option::Option<&str> {
        self.secret_arn.as_deref()
    }
    /// <p>The Connection Key Name (CKN) for the MAC Security secret key.</p>
    pub fn ckn(&self) -> std::option::Option<&str> {
        self.ckn.as_deref()
    }
    /// <p>The state of the MAC Security (MACsec) secret key.</p>
    /// <p>The possible values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>associating</code>: The MAC Security (MACsec) secret key is being validated and not yet associated with the connection or LAG.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>associated</code>: The MAC Security (MACsec) secret key is validated and associated with the connection or LAG.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>disassociating</code>: The MAC Security (MACsec) secret key is being disassociated from the connection or LAG</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>disassociated</code>: The MAC Security (MACsec) secret key is no longer associated with the connection or LAG.</p>
    /// </li>
    /// </ul>
    pub fn state(&self) -> std::option::Option<&str> {
        self.state.as_deref()
    }
    /// <p>The date that the MAC Security (MACsec) secret key takes effect. The value is displayed in UTC format.</p>
    pub fn start_on(&self) -> std::option::Option<&str> {
        self.start_on.as_deref()
    }
}
impl std::fmt::Debug for MacSecKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MacSecKey");
        formatter.field("secret_arn", &self.secret_arn);
        formatter.field("ckn", &self.ckn);
        formatter.field("state", &self.state);
        formatter.field("start_on", &self.start_on);
        formatter.finish()
    }
}
/// See [`MacSecKey`](crate::model::MacSecKey)
pub mod mac_sec_key {
    /// A builder for [`MacSecKey`](crate::model::MacSecKey)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) secret_arn: std::option::Option<std::string::String>,
        pub(crate) ckn: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<std::string::String>,
        pub(crate) start_on: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key.</p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key.</p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_arn = input;
            self
        }
        /// <p>The Connection Key Name (CKN) for the MAC Security secret key.</p>
        pub fn ckn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ckn = Some(input.into());
            self
        }
        /// <p>The Connection Key Name (CKN) for the MAC Security secret key.</p>
        pub fn set_ckn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ckn = input;
            self
        }
        /// <p>The state of the MAC Security (MACsec) secret key.</p>
        /// <p>The possible values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>associating</code>: The MAC Security (MACsec) secret key is being validated and not yet associated with the connection or LAG.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>associated</code>: The MAC Security (MACsec) secret key is validated and associated with the connection or LAG.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>disassociating</code>: The MAC Security (MACsec) secret key is being disassociated from the connection or LAG</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>disassociated</code>: The MAC Security (MACsec) secret key is no longer associated with the connection or LAG.</p>
        /// </li>
        /// </ul>
        pub fn state(mut self, input: impl Into<std::string::String>) -> Self {
            self.state = Some(input.into());
            self
        }
        /// <p>The state of the MAC Security (MACsec) secret key.</p>
        /// <p>The possible values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>associating</code>: The MAC Security (MACsec) secret key is being validated and not yet associated with the connection or LAG.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>associated</code>: The MAC Security (MACsec) secret key is validated and associated with the connection or LAG.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>disassociating</code>: The MAC Security (MACsec) secret key is being disassociated from the connection or LAG</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>disassociated</code>: The MAC Security (MACsec) secret key is no longer associated with the connection or LAG.</p>
        /// </li>
        /// </ul>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state = input;
            self
        }
        /// <p>The date that the MAC Security (MACsec) secret key takes effect. The value is displayed in UTC format.</p>
        pub fn start_on(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_on = Some(input.into());
            self
        }
        /// <p>The date that the MAC Security (MACsec) secret key takes effect. The value is displayed in UTC format.</p>
        pub fn set_start_on(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start_on = input;
            self
        }
        /// Consumes the builder and constructs a [`MacSecKey`](crate::model::MacSecKey)
        pub fn build(self) -> crate::model::MacSecKey {
            crate::model::MacSecKey {
                secret_arn: self.secret_arn,
                ckn: self.ckn,
                state: self.state,
                start_on: self.start_on,
            }
        }
    }
}
impl MacSecKey {
    /// Creates a new builder-style object to manufacture [`MacSecKey`](crate::model::MacSecKey)
    pub fn builder() -> crate::model::mac_sec_key::Builder {
        crate::model::mac_sec_key::Builder::default()
    }
}

/// _Note: `HasLogicalRedundancy::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HasLogicalRedundancy {
    #[allow(missing_docs)] // documentation missing in model
    No,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    #[allow(missing_docs)] // documentation missing in model
    Yes,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HasLogicalRedundancy {
    fn from(s: &str) -> Self {
        match s {
            "no" => HasLogicalRedundancy::No,
            "unknown" => HasLogicalRedundancy::UnknownValue,
            "yes" => HasLogicalRedundancy::Yes,
            other => HasLogicalRedundancy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HasLogicalRedundancy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HasLogicalRedundancy::from(s))
    }
}
impl HasLogicalRedundancy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HasLogicalRedundancy::No => "no",
            HasLogicalRedundancy::UnknownValue => "unknown",
            HasLogicalRedundancy::Yes => "yes",
            HasLogicalRedundancy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["no", "unknown", "yes"]
    }
}
impl AsRef<str> for HasLogicalRedundancy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about an Direct Connect connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Connection {
    /// <p>The ID of the Amazon Web Services account that owns the connection.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>The ID of the connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The name of the connection.</p>
    pub connection_name: std::option::Option<std::string::String>,
    /// <p>The state of the connection. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: The connection has been approved and is being initialized.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: The network link is up and the connection is ready for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: The network link is down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: The connection is being deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: The connection has been deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The state of the connection is not available.</p>
    /// </li>
    /// </ul>
    pub connection_state: std::option::Option<crate::model::ConnectionState>,
    /// <p>The Amazon Web Services Region where the connection is located.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The location of the connection.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The bandwidth of the connection.</p>
    pub bandwidth: std::option::Option<std::string::String>,
    /// <p>The ID of the VLAN.</p>
    pub vlan: i32,
    /// <p>The name of the Direct Connect service provider associated with the connection.</p>
    pub partner_name: std::option::Option<std::string::String>,
    /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
    pub loa_issue_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The ID of the LAG.</p>
    pub lag_id: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
    pub aws_device: std::option::Option<std::string::String>,
    /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    pub jumbo_frame_capable: std::option::Option<bool>,
    /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
    pub aws_device_v2: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
    /// different than the device that terminates the physical connection.</p>
    pub aws_logical_device_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
    pub has_logical_redundancy: std::option::Option<crate::model::HasLogicalRedundancy>,
    /// <p>The tags associated with the connection.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The name of the service provider associated with the connection.</p>
    pub provider_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether the connection supports MAC Security (MACsec).</p>
    pub mac_sec_capable: std::option::Option<bool>,
    /// <p>The MAC Security (MACsec) port link status of the connection.</p>
    /// <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
    pub port_encryption_status: std::option::Option<std::string::String>,
    /// <p>The MAC Security (MACsec) connection encryption mode.</p>
    /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
    pub encryption_mode: std::option::Option<std::string::String>,
    /// <p>The MAC Security (MACsec) security keys associated with the connection.</p>
    pub mac_sec_keys: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
}
impl Connection {
    /// <p>The ID of the Amazon Web Services account that owns the connection.</p>
    pub fn owner_account(&self) -> std::option::Option<&str> {
        self.owner_account.as_deref()
    }
    /// <p>The ID of the connection.</p>
    pub fn connection_id(&self) -> std::option::Option<&str> {
        self.connection_id.as_deref()
    }
    /// <p>The name of the connection.</p>
    pub fn connection_name(&self) -> std::option::Option<&str> {
        self.connection_name.as_deref()
    }
    /// <p>The state of the connection. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: The connection has been approved and is being initialized.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: The network link is up and the connection is ready for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: The network link is down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: The connection is being deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: The connection has been deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The state of the connection is not available.</p>
    /// </li>
    /// </ul>
    pub fn connection_state(&self) -> std::option::Option<&crate::model::ConnectionState> {
        self.connection_state.as_ref()
    }
    /// <p>The Amazon Web Services Region where the connection is located.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>The location of the connection.</p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
    /// <p>The bandwidth of the connection.</p>
    pub fn bandwidth(&self) -> std::option::Option<&str> {
        self.bandwidth.as_deref()
    }
    /// <p>The ID of the VLAN.</p>
    pub fn vlan(&self) -> i32 {
        self.vlan
    }
    /// <p>The name of the Direct Connect service provider associated with the connection.</p>
    pub fn partner_name(&self) -> std::option::Option<&str> {
        self.partner_name.as_deref()
    }
    /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
    pub fn loa_issue_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.loa_issue_time.as_ref()
    }
    /// <p>The ID of the LAG.</p>
    pub fn lag_id(&self) -> std::option::Option<&str> {
        self.lag_id.as_deref()
    }
    /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
    pub fn aws_device(&self) -> std::option::Option<&str> {
        self.aws_device.as_deref()
    }
    /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    pub fn jumbo_frame_capable(&self) -> std::option::Option<bool> {
        self.jumbo_frame_capable
    }
    /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
    pub fn aws_device_v2(&self) -> std::option::Option<&str> {
        self.aws_device_v2.as_deref()
    }
    /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
    /// different than the device that terminates the physical connection.</p>
    pub fn aws_logical_device_id(&self) -> std::option::Option<&str> {
        self.aws_logical_device_id.as_deref()
    }
    /// <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
    pub fn has_logical_redundancy(
        &self,
    ) -> std::option::Option<&crate::model::HasLogicalRedundancy> {
        self.has_logical_redundancy.as_ref()
    }
    /// <p>The tags associated with the connection.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The name of the service provider associated with the connection.</p>
    pub fn provider_name(&self) -> std::option::Option<&str> {
        self.provider_name.as_deref()
    }
    /// <p>Indicates whether the connection supports MAC Security (MACsec).</p>
    pub fn mac_sec_capable(&self) -> std::option::Option<bool> {
        self.mac_sec_capable
    }
    /// <p>The MAC Security (MACsec) port link status of the connection.</p>
    /// <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
    pub fn port_encryption_status(&self) -> std::option::Option<&str> {
        self.port_encryption_status.as_deref()
    }
    /// <p>The MAC Security (MACsec) connection encryption mode.</p>
    /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
    pub fn encryption_mode(&self) -> std::option::Option<&str> {
        self.encryption_mode.as_deref()
    }
    /// <p>The MAC Security (MACsec) security keys associated with the connection.</p>
    pub fn mac_sec_keys(&self) -> std::option::Option<&[crate::model::MacSecKey]> {
        self.mac_sec_keys.as_deref()
    }
}
impl std::fmt::Debug for Connection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Connection");
        formatter.field("owner_account", &self.owner_account);
        formatter.field("connection_id", &self.connection_id);
        formatter.field("connection_name", &self.connection_name);
        formatter.field("connection_state", &self.connection_state);
        formatter.field("region", &self.region);
        formatter.field("location", &self.location);
        formatter.field("bandwidth", &self.bandwidth);
        formatter.field("vlan", &self.vlan);
        formatter.field("partner_name", &self.partner_name);
        formatter.field("loa_issue_time", &self.loa_issue_time);
        formatter.field("lag_id", &self.lag_id);
        formatter.field("aws_device", &self.aws_device);
        formatter.field("jumbo_frame_capable", &self.jumbo_frame_capable);
        formatter.field("aws_device_v2", &self.aws_device_v2);
        formatter.field("aws_logical_device_id", &self.aws_logical_device_id);
        formatter.field("has_logical_redundancy", &self.has_logical_redundancy);
        formatter.field("tags", &self.tags);
        formatter.field("provider_name", &self.provider_name);
        formatter.field("mac_sec_capable", &self.mac_sec_capable);
        formatter.field("port_encryption_status", &self.port_encryption_status);
        formatter.field("encryption_mode", &self.encryption_mode);
        formatter.field("mac_sec_keys", &self.mac_sec_keys);
        formatter.finish()
    }
}
/// See [`Connection`](crate::model::Connection)
pub mod connection {
    /// A builder for [`Connection`](crate::model::Connection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) connection_name: std::option::Option<std::string::String>,
        pub(crate) connection_state: std::option::Option<crate::model::ConnectionState>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) bandwidth: std::option::Option<std::string::String>,
        pub(crate) vlan: std::option::Option<i32>,
        pub(crate) partner_name: std::option::Option<std::string::String>,
        pub(crate) loa_issue_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) lag_id: std::option::Option<std::string::String>,
        pub(crate) aws_device: std::option::Option<std::string::String>,
        pub(crate) jumbo_frame_capable: std::option::Option<bool>,
        pub(crate) aws_device_v2: std::option::Option<std::string::String>,
        pub(crate) aws_logical_device_id: std::option::Option<std::string::String>,
        pub(crate) has_logical_redundancy: std::option::Option<crate::model::HasLogicalRedundancy>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) provider_name: std::option::Option<std::string::String>,
        pub(crate) mac_sec_capable: std::option::Option<bool>,
        pub(crate) port_encryption_status: std::option::Option<std::string::String>,
        pub(crate) encryption_mode: std::option::Option<std::string::String>,
        pub(crate) mac_sec_keys: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that owns the connection.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the connection.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The name of the connection.</p>
        pub fn connection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_name = Some(input.into());
            self
        }
        /// <p>The name of the connection.</p>
        pub fn set_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_name = input;
            self
        }
        /// <p>The state of the connection. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The connection has been approved and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is up and the connection is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The connection is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The connection has been deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the connection is not available.</p>
        /// </li>
        /// </ul>
        pub fn connection_state(mut self, input: crate::model::ConnectionState) -> Self {
            self.connection_state = Some(input);
            self
        }
        /// <p>The state of the connection. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The connection has been approved and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is up and the connection is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The connection is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The connection has been deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the connection is not available.</p>
        /// </li>
        /// </ul>
        pub fn set_connection_state(
            mut self,
            input: std::option::Option<crate::model::ConnectionState>,
        ) -> Self {
            self.connection_state = input;
            self
        }
        /// <p>The Amazon Web Services Region where the connection is located.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region where the connection is located.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The location of the connection.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The location of the connection.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The bandwidth of the connection.</p>
        pub fn bandwidth(mut self, input: impl Into<std::string::String>) -> Self {
            self.bandwidth = Some(input.into());
            self
        }
        /// <p>The bandwidth of the connection.</p>
        pub fn set_bandwidth(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bandwidth = input;
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn vlan(mut self, input: i32) -> Self {
            self.vlan = Some(input);
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn set_vlan(mut self, input: std::option::Option<i32>) -> Self {
            self.vlan = input;
            self
        }
        /// <p>The name of the Direct Connect service provider associated with the connection.</p>
        pub fn partner_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.partner_name = Some(input.into());
            self
        }
        /// <p>The name of the Direct Connect service provider associated with the connection.</p>
        pub fn set_partner_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.partner_name = input;
            self
        }
        /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
        pub fn loa_issue_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.loa_issue_time = Some(input);
            self
        }
        /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
        pub fn set_loa_issue_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.loa_issue_time = input;
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.lag_id = Some(input.into());
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lag_id = input;
            self
        }
        /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
        pub fn aws_device(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
        pub fn set_aws_device(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_device = input;
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn jumbo_frame_capable(mut self, input: bool) -> Self {
            self.jumbo_frame_capable = Some(input);
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn set_jumbo_frame_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.jumbo_frame_capable = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn aws_device_v2(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device_v2 = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn set_aws_device_v2(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_device_v2 = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn aws_logical_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_logical_device_id = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn set_aws_logical_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_logical_device_id = input;
            self
        }
        /// <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
        pub fn has_logical_redundancy(mut self, input: crate::model::HasLogicalRedundancy) -> Self {
            self.has_logical_redundancy = Some(input);
            self
        }
        /// <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
        pub fn set_has_logical_redundancy(
            mut self,
            input: std::option::Option<crate::model::HasLogicalRedundancy>,
        ) -> Self {
            self.has_logical_redundancy = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the connection.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the connection.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name of the service provider associated with the connection.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The name of the service provider associated with the connection.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// <p>Indicates whether the connection supports MAC Security (MACsec).</p>
        pub fn mac_sec_capable(mut self, input: bool) -> Self {
            self.mac_sec_capable = Some(input);
            self
        }
        /// <p>Indicates whether the connection supports MAC Security (MACsec).</p>
        pub fn set_mac_sec_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.mac_sec_capable = input;
            self
        }
        /// <p>The MAC Security (MACsec) port link status of the connection.</p>
        /// <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
        pub fn port_encryption_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.port_encryption_status = Some(input.into());
            self
        }
        /// <p>The MAC Security (MACsec) port link status of the connection.</p>
        /// <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
        pub fn set_port_encryption_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.port_encryption_status = input;
            self
        }
        /// <p>The MAC Security (MACsec) connection encryption mode.</p>
        /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
        pub fn encryption_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_mode = Some(input.into());
            self
        }
        /// <p>The MAC Security (MACsec) connection encryption mode.</p>
        /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_mode = input;
            self
        }
        /// Appends an item to `mac_sec_keys`.
        ///
        /// To override the contents of this collection use [`set_mac_sec_keys`](Self::set_mac_sec_keys).
        ///
        /// <p>The MAC Security (MACsec) security keys associated with the connection.</p>
        pub fn mac_sec_keys(mut self, input: impl Into<crate::model::MacSecKey>) -> Self {
            let mut v = self.mac_sec_keys.unwrap_or_default();
            v.push(input.into());
            self.mac_sec_keys = Some(v);
            self
        }
        /// <p>The MAC Security (MACsec) security keys associated with the connection.</p>
        pub fn set_mac_sec_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
        ) -> Self {
            self.mac_sec_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`Connection`](crate::model::Connection)
        pub fn build(self) -> crate::model::Connection {
            crate::model::Connection {
                owner_account: self.owner_account,
                connection_id: self.connection_id,
                connection_name: self.connection_name,
                connection_state: self.connection_state,
                region: self.region,
                location: self.location,
                bandwidth: self.bandwidth,
                vlan: self.vlan.unwrap_or_default(),
                partner_name: self.partner_name,
                loa_issue_time: self.loa_issue_time,
                lag_id: self.lag_id,
                aws_device: self.aws_device,
                jumbo_frame_capable: self.jumbo_frame_capable,
                aws_device_v2: self.aws_device_v2,
                aws_logical_device_id: self.aws_logical_device_id,
                has_logical_redundancy: self.has_logical_redundancy,
                tags: self.tags,
                provider_name: self.provider_name,
                mac_sec_capable: self.mac_sec_capable,
                port_encryption_status: self.port_encryption_status,
                encryption_mode: self.encryption_mode,
                mac_sec_keys: self.mac_sec_keys,
            }
        }
    }
}
impl Connection {
    /// Creates a new builder-style object to manufacture [`Connection`](crate::model::Connection)
    pub fn builder() -> crate::model::connection::Builder {
        crate::model::connection::Builder::default()
    }
}

/// _Note: `ConnectionState::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConnectionState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Down,
    #[allow(missing_docs)] // documentation missing in model
    Ordering,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Rejected,
    #[allow(missing_docs)] // documentation missing in model
    Requested,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConnectionState {
    fn from(s: &str) -> Self {
        match s {
            "available" => ConnectionState::Available,
            "deleted" => ConnectionState::Deleted,
            "deleting" => ConnectionState::Deleting,
            "down" => ConnectionState::Down,
            "ordering" => ConnectionState::Ordering,
            "pending" => ConnectionState::Pending,
            "rejected" => ConnectionState::Rejected,
            "requested" => ConnectionState::Requested,
            "unknown" => ConnectionState::UnknownValue,
            other => ConnectionState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConnectionState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConnectionState::from(s))
    }
}
impl ConnectionState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConnectionState::Available => "available",
            ConnectionState::Deleted => "deleted",
            ConnectionState::Deleting => "deleting",
            ConnectionState::Down => "down",
            ConnectionState::Ordering => "ordering",
            ConnectionState::Pending => "pending",
            ConnectionState::Rejected => "rejected",
            ConnectionState::Requested => "requested",
            ConnectionState::UnknownValue => "unknown",
            ConnectionState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "available",
            "deleted",
            "deleting",
            "down",
            "ordering",
            "pending",
            "rejected",
            "requested",
            "unknown",
        ]
    }
}
impl AsRef<str> for ConnectionState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// _Note: `LagState::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LagState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Down,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Requested,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LagState {
    fn from(s: &str) -> Self {
        match s {
            "available" => LagState::Available,
            "deleted" => LagState::Deleted,
            "deleting" => LagState::Deleting,
            "down" => LagState::Down,
            "pending" => LagState::Pending,
            "requested" => LagState::Requested,
            "unknown" => LagState::UnknownValue,
            other => LagState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LagState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LagState::from(s))
    }
}
impl LagState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LagState::Available => "available",
            LagState::Deleted => "deleted",
            LagState::Deleting => "deleting",
            LagState::Down => "down",
            LagState::Pending => "pending",
            LagState::Requested => "requested",
            LagState::UnknownValue => "unknown",
            LagState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "available",
            "deleted",
            "deleting",
            "down",
            "pending",
            "requested",
            "unknown",
        ]
    }
}
impl AsRef<str> for LagState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about an association between a Direct Connect gateway and a virtual private gateway or transit gateway.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DirectConnectGatewayAssociation {
    /// <p>The ID of the Direct Connect gateway.</p>
    pub direct_connect_gateway_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Web Services account that owns the associated gateway.</p>
    pub direct_connect_gateway_owner_account: std::option::Option<std::string::String>,
    /// <p>The state of the association. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>associating</code>: The initial state after calling <a>CreateDirectConnectGatewayAssociation</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>associated</code>: The Direct Connect gateway and virtual private gateway or transit gateway are successfully associated and ready to pass traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>disassociating</code>: The initial state after calling <a>DeleteDirectConnectGatewayAssociation</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>disassociated</code>: The virtual private gateway or transit gateway is disassociated from the Direct Connect gateway. Traffic flow between the Direct Connect gateway and virtual private gateway or transit gateway is stopped.</p>
    /// </li>
    /// </ul>
    pub association_state: std::option::Option<crate::model::DirectConnectGatewayAssociationState>,
    /// <p>The error message if the state of an object failed to advance.</p>
    pub state_change_error: std::option::Option<std::string::String>,
    /// <p>Information about the associated gateway.</p>
    pub associated_gateway: std::option::Option<crate::model::AssociatedGateway>,
    /// <p>The ID of the Direct Connect gateway association.</p>
    pub association_id: std::option::Option<std::string::String>,
    /// <p>The Amazon VPC prefixes to advertise to the Direct Connect gateway.</p>
    pub allowed_prefixes_to_direct_connect_gateway:
        std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
    /// <p>The ID of the virtual private gateway. Applies only to private virtual interfaces.</p>
    pub virtual_gateway_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region where the virtual private gateway is located.</p>
    pub virtual_gateway_region: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Web Services account that owns the virtual private gateway.</p>
    pub virtual_gateway_owner_account: std::option::Option<std::string::String>,
}
impl DirectConnectGatewayAssociation {
    /// <p>The ID of the Direct Connect gateway.</p>
    pub fn direct_connect_gateway_id(&self) -> std::option::Option<&str> {
        self.direct_connect_gateway_id.as_deref()
    }
    /// <p>The ID of the Amazon Web Services account that owns the associated gateway.</p>
    pub fn direct_connect_gateway_owner_account(&self) -> std::option::Option<&str> {
        self.direct_connect_gateway_owner_account.as_deref()
    }
    /// <p>The state of the association. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>associating</code>: The initial state after calling <a>CreateDirectConnectGatewayAssociation</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>associated</code>: The Direct Connect gateway and virtual private gateway or transit gateway are successfully associated and ready to pass traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>disassociating</code>: The initial state after calling <a>DeleteDirectConnectGatewayAssociation</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>disassociated</code>: The virtual private gateway or transit gateway is disassociated from the Direct Connect gateway. Traffic flow between the Direct Connect gateway and virtual private gateway or transit gateway is stopped.</p>
    /// </li>
    /// </ul>
    pub fn association_state(
        &self,
    ) -> std::option::Option<&crate::model::DirectConnectGatewayAssociationState> {
        self.association_state.as_ref()
    }
    /// <p>The error message if the state of an object failed to advance.</p>
    pub fn state_change_error(&self) -> std::option::Option<&str> {
        self.state_change_error.as_deref()
    }
    /// <p>Information about the associated gateway.</p>
    pub fn associated_gateway(&self) -> std::option::Option<&crate::model::AssociatedGateway> {
        self.associated_gateway.as_ref()
    }
    /// <p>The ID of the Direct Connect gateway association.</p>
    pub fn association_id(&self) -> std::option::Option<&str> {
        self.association_id.as_deref()
    }
    /// <p>The Amazon VPC prefixes to advertise to the Direct Connect gateway.</p>
    pub fn allowed_prefixes_to_direct_connect_gateway(
        &self,
    ) -> std::option::Option<&[crate::model::RouteFilterPrefix]> {
        self.allowed_prefixes_to_direct_connect_gateway.as_deref()
    }
    /// <p>The ID of the virtual private gateway. Applies only to private virtual interfaces.</p>
    pub fn virtual_gateway_id(&self) -> std::option::Option<&str> {
        self.virtual_gateway_id.as_deref()
    }
    /// <p>The Amazon Web Services Region where the virtual private gateway is located.</p>
    pub fn virtual_gateway_region(&self) -> std::option::Option<&str> {
        self.virtual_gateway_region.as_deref()
    }
    /// <p>The ID of the Amazon Web Services account that owns the virtual private gateway.</p>
    pub fn virtual_gateway_owner_account(&self) -> std::option::Option<&str> {
        self.virtual_gateway_owner_account.as_deref()
    }
}
impl std::fmt::Debug for DirectConnectGatewayAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DirectConnectGatewayAssociation");
        formatter.field("direct_connect_gateway_id", &self.direct_connect_gateway_id);
        formatter.field(
            "direct_connect_gateway_owner_account",
            &self.direct_connect_gateway_owner_account,
        );
        formatter.field("association_state", &self.association_state);
        formatter.field("state_change_error", &self.state_change_error);
        formatter.field("associated_gateway", &self.associated_gateway);
        formatter.field("association_id", &self.association_id);
        formatter.field(
            "allowed_prefixes_to_direct_connect_gateway",
            &self.allowed_prefixes_to_direct_connect_gateway,
        );
        formatter.field("virtual_gateway_id", &self.virtual_gateway_id);
        formatter.field("virtual_gateway_region", &self.virtual_gateway_region);
        formatter.field(
            "virtual_gateway_owner_account",
            &self.virtual_gateway_owner_account,
        );
        formatter.finish()
    }
}
/// See [`DirectConnectGatewayAssociation`](crate::model::DirectConnectGatewayAssociation)
pub mod direct_connect_gateway_association {
    /// A builder for [`DirectConnectGatewayAssociation`](crate::model::DirectConnectGatewayAssociation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) direct_connect_gateway_id: std::option::Option<std::string::String>,
        pub(crate) direct_connect_gateway_owner_account: std::option::Option<std::string::String>,
        pub(crate) association_state:
            std::option::Option<crate::model::DirectConnectGatewayAssociationState>,
        pub(crate) state_change_error: std::option::Option<std::string::String>,
        pub(crate) associated_gateway: std::option::Option<crate::model::AssociatedGateway>,
        pub(crate) association_id: std::option::Option<std::string::String>,
        pub(crate) allowed_prefixes_to_direct_connect_gateway:
            std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        pub(crate) virtual_gateway_id: std::option::Option<std::string::String>,
        pub(crate) virtual_gateway_region: std::option::Option<std::string::String>,
        pub(crate) virtual_gateway_owner_account: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.direct_connect_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_id = input;
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the associated gateway.</p>
        pub fn direct_connect_gateway_owner_account(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the associated gateway.</p>
        pub fn set_direct_connect_gateway_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_owner_account = input;
            self
        }
        /// <p>The state of the association. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>associating</code>: The initial state after calling <a>CreateDirectConnectGatewayAssociation</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>associated</code>: The Direct Connect gateway and virtual private gateway or transit gateway are successfully associated and ready to pass traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>disassociating</code>: The initial state after calling <a>DeleteDirectConnectGatewayAssociation</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>disassociated</code>: The virtual private gateway or transit gateway is disassociated from the Direct Connect gateway. Traffic flow between the Direct Connect gateway and virtual private gateway or transit gateway is stopped.</p>
        /// </li>
        /// </ul>
        pub fn association_state(
            mut self,
            input: crate::model::DirectConnectGatewayAssociationState,
        ) -> Self {
            self.association_state = Some(input);
            self
        }
        /// <p>The state of the association. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>associating</code>: The initial state after calling <a>CreateDirectConnectGatewayAssociation</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>associated</code>: The Direct Connect gateway and virtual private gateway or transit gateway are successfully associated and ready to pass traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>disassociating</code>: The initial state after calling <a>DeleteDirectConnectGatewayAssociation</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>disassociated</code>: The virtual private gateway or transit gateway is disassociated from the Direct Connect gateway. Traffic flow between the Direct Connect gateway and virtual private gateway or transit gateway is stopped.</p>
        /// </li>
        /// </ul>
        pub fn set_association_state(
            mut self,
            input: std::option::Option<crate::model::DirectConnectGatewayAssociationState>,
        ) -> Self {
            self.association_state = input;
            self
        }
        /// <p>The error message if the state of an object failed to advance.</p>
        pub fn state_change_error(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_change_error = Some(input.into());
            self
        }
        /// <p>The error message if the state of an object failed to advance.</p>
        pub fn set_state_change_error(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_change_error = input;
            self
        }
        /// <p>Information about the associated gateway.</p>
        pub fn associated_gateway(mut self, input: crate::model::AssociatedGateway) -> Self {
            self.associated_gateway = Some(input);
            self
        }
        /// <p>Information about the associated gateway.</p>
        pub fn set_associated_gateway(
            mut self,
            input: std::option::Option<crate::model::AssociatedGateway>,
        ) -> Self {
            self.associated_gateway = input;
            self
        }
        /// <p>The ID of the Direct Connect gateway association.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_id = Some(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway association.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_id = input;
            self
        }
        /// Appends an item to `allowed_prefixes_to_direct_connect_gateway`.
        ///
        /// To override the contents of this collection use [`set_allowed_prefixes_to_direct_connect_gateway`](Self::set_allowed_prefixes_to_direct_connect_gateway).
        ///
        /// <p>The Amazon VPC prefixes to advertise to the Direct Connect gateway.</p>
        pub fn allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: impl Into<crate::model::RouteFilterPrefix>,
        ) -> Self {
            let mut v = self
                .allowed_prefixes_to_direct_connect_gateway
                .unwrap_or_default();
            v.push(input.into());
            self.allowed_prefixes_to_direct_connect_gateway = Some(v);
            self
        }
        /// <p>The Amazon VPC prefixes to advertise to the Direct Connect gateway.</p>
        pub fn set_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        ) -> Self {
            self.allowed_prefixes_to_direct_connect_gateway = input;
            self
        }
        /// <p>The ID of the virtual private gateway. Applies only to private virtual interfaces.</p>
        pub fn virtual_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual private gateway. Applies only to private virtual interfaces.</p>
        pub fn set_virtual_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_gateway_id = input;
            self
        }
        /// <p>The Amazon Web Services Region where the virtual private gateway is located.</p>
        pub fn virtual_gateway_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_gateway_region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region where the virtual private gateway is located.</p>
        pub fn set_virtual_gateway_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_gateway_region = input;
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the virtual private gateway.</p>
        pub fn virtual_gateway_owner_account(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.virtual_gateway_owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the virtual private gateway.</p>
        pub fn set_virtual_gateway_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_gateway_owner_account = input;
            self
        }
        /// Consumes the builder and constructs a [`DirectConnectGatewayAssociation`](crate::model::DirectConnectGatewayAssociation)
        pub fn build(self) -> crate::model::DirectConnectGatewayAssociation {
            crate::model::DirectConnectGatewayAssociation {
                direct_connect_gateway_id: self.direct_connect_gateway_id,
                direct_connect_gateway_owner_account: self.direct_connect_gateway_owner_account,
                association_state: self.association_state,
                state_change_error: self.state_change_error,
                associated_gateway: self.associated_gateway,
                association_id: self.association_id,
                allowed_prefixes_to_direct_connect_gateway: self
                    .allowed_prefixes_to_direct_connect_gateway,
                virtual_gateway_id: self.virtual_gateway_id,
                virtual_gateway_region: self.virtual_gateway_region,
                virtual_gateway_owner_account: self.virtual_gateway_owner_account,
            }
        }
    }
}
impl DirectConnectGatewayAssociation {
    /// Creates a new builder-style object to manufacture [`DirectConnectGatewayAssociation`](crate::model::DirectConnectGatewayAssociation)
    pub fn builder() -> crate::model::direct_connect_gateway_association::Builder {
        crate::model::direct_connect_gateway_association::Builder::default()
    }
}

/// <p>Information about the associated gateway.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociatedGateway {
    /// <p>The ID of the associated gateway.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The type of associated gateway.</p>
    pub r#type: std::option::Option<crate::model::GatewayType>,
    /// <p>The ID of the Amazon Web Services account that owns the associated virtual private gateway or transit gateway.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>The Region where the associated gateway is located.</p>
    pub region: std::option::Option<std::string::String>,
}
impl AssociatedGateway {
    /// <p>The ID of the associated gateway.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The type of associated gateway.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::GatewayType> {
        self.r#type.as_ref()
    }
    /// <p>The ID of the Amazon Web Services account that owns the associated virtual private gateway or transit gateway.</p>
    pub fn owner_account(&self) -> std::option::Option<&str> {
        self.owner_account.as_deref()
    }
    /// <p>The Region where the associated gateway is located.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
}
impl std::fmt::Debug for AssociatedGateway {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociatedGateway");
        formatter.field("id", &self.id);
        formatter.field("r#type", &self.r#type);
        formatter.field("owner_account", &self.owner_account);
        formatter.field("region", &self.region);
        formatter.finish()
    }
}
/// See [`AssociatedGateway`](crate::model::AssociatedGateway)
pub mod associated_gateway {
    /// A builder for [`AssociatedGateway`](crate::model::AssociatedGateway)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::GatewayType>,
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the associated gateway.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the associated gateway.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The type of associated gateway.</p>
        pub fn r#type(mut self, input: crate::model::GatewayType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of associated gateway.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::GatewayType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the associated virtual private gateway or transit gateway.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the associated virtual private gateway or transit gateway.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>The Region where the associated gateway is located.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Region where the associated gateway is located.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociatedGateway`](crate::model::AssociatedGateway)
        pub fn build(self) -> crate::model::AssociatedGateway {
            crate::model::AssociatedGateway {
                id: self.id,
                r#type: self.r#type,
                owner_account: self.owner_account,
                region: self.region,
            }
        }
    }
}
impl AssociatedGateway {
    /// Creates a new builder-style object to manufacture [`AssociatedGateway`](crate::model::AssociatedGateway)
    pub fn builder() -> crate::model::associated_gateway::Builder {
        crate::model::associated_gateway::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GatewayType {
    #[allow(missing_docs)] // documentation missing in model
    TransitGateway,
    #[allow(missing_docs)] // documentation missing in model
    VirtualPrivateGateway,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GatewayType {
    fn from(s: &str) -> Self {
        match s {
            "transitGateway" => GatewayType::TransitGateway,
            "virtualPrivateGateway" => GatewayType::VirtualPrivateGateway,
            other => GatewayType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GatewayType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GatewayType::from(s))
    }
}
impl GatewayType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GatewayType::TransitGateway => "transitGateway",
            GatewayType::VirtualPrivateGateway => "virtualPrivateGateway",
            GatewayType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["transitGateway", "virtualPrivateGateway"]
    }
}
impl AsRef<str> for GatewayType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DirectConnectGatewayAssociationState {
    #[allow(missing_docs)] // documentation missing in model
    Associated,
    #[allow(missing_docs)] // documentation missing in model
    Associating,
    #[allow(missing_docs)] // documentation missing in model
    Disassociated,
    #[allow(missing_docs)] // documentation missing in model
    Disassociating,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DirectConnectGatewayAssociationState {
    fn from(s: &str) -> Self {
        match s {
            "associated" => DirectConnectGatewayAssociationState::Associated,
            "associating" => DirectConnectGatewayAssociationState::Associating,
            "disassociated" => DirectConnectGatewayAssociationState::Disassociated,
            "disassociating" => DirectConnectGatewayAssociationState::Disassociating,
            "updating" => DirectConnectGatewayAssociationState::Updating,
            other => DirectConnectGatewayAssociationState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DirectConnectGatewayAssociationState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DirectConnectGatewayAssociationState::from(s))
    }
}
impl DirectConnectGatewayAssociationState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DirectConnectGatewayAssociationState::Associated => "associated",
            DirectConnectGatewayAssociationState::Associating => "associating",
            DirectConnectGatewayAssociationState::Disassociated => "disassociated",
            DirectConnectGatewayAssociationState::Disassociating => "disassociating",
            DirectConnectGatewayAssociationState::Updating => "updating",
            DirectConnectGatewayAssociationState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "associated",
            "associating",
            "disassociated",
            "disassociating",
            "updating",
        ]
    }
}
impl AsRef<str> for DirectConnectGatewayAssociationState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a Direct Connect gateway, which enables you to connect virtual interfaces and virtual private gateway or transit gateways.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DirectConnectGateway {
    /// <p>The ID of the Direct Connect gateway.</p>
    pub direct_connect_gateway_id: std::option::Option<std::string::String>,
    /// <p>The name of the Direct Connect gateway.</p>
    pub direct_connect_gateway_name: std::option::Option<std::string::String>,
    /// <p>The autonomous system number (ASN) for the Amazon side of the connection.</p>
    pub amazon_side_asn: std::option::Option<i64>,
    /// <p>The ID of the Amazon Web Services account that owns the Direct Connect gateway.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>The state of the Direct Connect gateway. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>pending</code>: The initial state after calling <a>CreateDirectConnectGateway</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: The Direct Connect gateway is ready for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: The initial state after calling <a>DeleteDirectConnectGateway</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: The Direct Connect gateway is deleted and cannot pass traffic.</p>
    /// </li>
    /// </ul>
    pub direct_connect_gateway_state: std::option::Option<crate::model::DirectConnectGatewayState>,
    /// <p>The error message if the state of an object failed to advance.</p>
    pub state_change_error: std::option::Option<std::string::String>,
}
impl DirectConnectGateway {
    /// <p>The ID of the Direct Connect gateway.</p>
    pub fn direct_connect_gateway_id(&self) -> std::option::Option<&str> {
        self.direct_connect_gateway_id.as_deref()
    }
    /// <p>The name of the Direct Connect gateway.</p>
    pub fn direct_connect_gateway_name(&self) -> std::option::Option<&str> {
        self.direct_connect_gateway_name.as_deref()
    }
    /// <p>The autonomous system number (ASN) for the Amazon side of the connection.</p>
    pub fn amazon_side_asn(&self) -> std::option::Option<i64> {
        self.amazon_side_asn
    }
    /// <p>The ID of the Amazon Web Services account that owns the Direct Connect gateway.</p>
    pub fn owner_account(&self) -> std::option::Option<&str> {
        self.owner_account.as_deref()
    }
    /// <p>The state of the Direct Connect gateway. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>pending</code>: The initial state after calling <a>CreateDirectConnectGateway</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: The Direct Connect gateway is ready for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: The initial state after calling <a>DeleteDirectConnectGateway</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: The Direct Connect gateway is deleted and cannot pass traffic.</p>
    /// </li>
    /// </ul>
    pub fn direct_connect_gateway_state(
        &self,
    ) -> std::option::Option<&crate::model::DirectConnectGatewayState> {
        self.direct_connect_gateway_state.as_ref()
    }
    /// <p>The error message if the state of an object failed to advance.</p>
    pub fn state_change_error(&self) -> std::option::Option<&str> {
        self.state_change_error.as_deref()
    }
}
impl std::fmt::Debug for DirectConnectGateway {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DirectConnectGateway");
        formatter.field("direct_connect_gateway_id", &self.direct_connect_gateway_id);
        formatter.field(
            "direct_connect_gateway_name",
            &self.direct_connect_gateway_name,
        );
        formatter.field("amazon_side_asn", &self.amazon_side_asn);
        formatter.field("owner_account", &self.owner_account);
        formatter.field(
            "direct_connect_gateway_state",
            &self.direct_connect_gateway_state,
        );
        formatter.field("state_change_error", &self.state_change_error);
        formatter.finish()
    }
}
/// See [`DirectConnectGateway`](crate::model::DirectConnectGateway)
pub mod direct_connect_gateway {
    /// A builder for [`DirectConnectGateway`](crate::model::DirectConnectGateway)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) direct_connect_gateway_id: std::option::Option<std::string::String>,
        pub(crate) direct_connect_gateway_name: std::option::Option<std::string::String>,
        pub(crate) amazon_side_asn: std::option::Option<i64>,
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) direct_connect_gateway_state:
            std::option::Option<crate::model::DirectConnectGatewayState>,
        pub(crate) state_change_error: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.direct_connect_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_id = input;
            self
        }
        /// <p>The name of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_name = Some(input.into());
            self
        }
        /// <p>The name of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_name = input;
            self
        }
        /// <p>The autonomous system number (ASN) for the Amazon side of the connection.</p>
        pub fn amazon_side_asn(mut self, input: i64) -> Self {
            self.amazon_side_asn = Some(input);
            self
        }
        /// <p>The autonomous system number (ASN) for the Amazon side of the connection.</p>
        pub fn set_amazon_side_asn(mut self, input: std::option::Option<i64>) -> Self {
            self.amazon_side_asn = input;
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the Direct Connect gateway.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the Direct Connect gateway.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>The state of the Direct Connect gateway. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>pending</code>: The initial state after calling <a>CreateDirectConnectGateway</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The Direct Connect gateway is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The initial state after calling <a>DeleteDirectConnectGateway</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The Direct Connect gateway is deleted and cannot pass traffic.</p>
        /// </li>
        /// </ul>
        pub fn direct_connect_gateway_state(
            mut self,
            input: crate::model::DirectConnectGatewayState,
        ) -> Self {
            self.direct_connect_gateway_state = Some(input);
            self
        }
        /// <p>The state of the Direct Connect gateway. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>pending</code>: The initial state after calling <a>CreateDirectConnectGateway</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The Direct Connect gateway is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The initial state after calling <a>DeleteDirectConnectGateway</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The Direct Connect gateway is deleted and cannot pass traffic.</p>
        /// </li>
        /// </ul>
        pub fn set_direct_connect_gateway_state(
            mut self,
            input: std::option::Option<crate::model::DirectConnectGatewayState>,
        ) -> Self {
            self.direct_connect_gateway_state = input;
            self
        }
        /// <p>The error message if the state of an object failed to advance.</p>
        pub fn state_change_error(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_change_error = Some(input.into());
            self
        }
        /// <p>The error message if the state of an object failed to advance.</p>
        pub fn set_state_change_error(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_change_error = input;
            self
        }
        /// Consumes the builder and constructs a [`DirectConnectGateway`](crate::model::DirectConnectGateway)
        pub fn build(self) -> crate::model::DirectConnectGateway {
            crate::model::DirectConnectGateway {
                direct_connect_gateway_id: self.direct_connect_gateway_id,
                direct_connect_gateway_name: self.direct_connect_gateway_name,
                amazon_side_asn: self.amazon_side_asn,
                owner_account: self.owner_account,
                direct_connect_gateway_state: self.direct_connect_gateway_state,
                state_change_error: self.state_change_error,
            }
        }
    }
}
impl DirectConnectGateway {
    /// Creates a new builder-style object to manufacture [`DirectConnectGateway`](crate::model::DirectConnectGateway)
    pub fn builder() -> crate::model::direct_connect_gateway::Builder {
        crate::model::direct_connect_gateway::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DirectConnectGatewayState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DirectConnectGatewayState {
    fn from(s: &str) -> Self {
        match s {
            "available" => DirectConnectGatewayState::Available,
            "deleted" => DirectConnectGatewayState::Deleted,
            "deleting" => DirectConnectGatewayState::Deleting,
            "pending" => DirectConnectGatewayState::Pending,
            other => DirectConnectGatewayState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DirectConnectGatewayState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DirectConnectGatewayState::from(s))
    }
}
impl DirectConnectGatewayState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DirectConnectGatewayState::Available => "available",
            DirectConnectGatewayState::Deleted => "deleted",
            DirectConnectGatewayState::Deleting => "deleting",
            DirectConnectGatewayState::Pending => "pending",
            DirectConnectGatewayState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["available", "deleted", "deleting", "pending"]
    }
}
impl AsRef<str> for DirectConnectGatewayState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the virtual interface failover test.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualInterfaceTestHistory {
    /// <p>The ID of the virtual interface failover test.</p>
    pub test_id: std::option::Option<std::string::String>,
    /// <p>The ID of the tested virtual interface.</p>
    pub virtual_interface_id: std::option::Option<std::string::String>,
    /// <p>The BGP peers that were put in the DOWN state as part of the virtual interface failover test.</p>
    pub bgp_peers: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The status of the virtual interface failover test.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The owner ID of the tested virtual interface.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>The time that the virtual interface failover test ran in minutes.</p>
    pub test_duration_in_minutes: std::option::Option<i32>,
    /// <p>The time that the virtual interface moves to the DOWN state.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time that the virtual interface moves out of the DOWN state.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl VirtualInterfaceTestHistory {
    /// <p>The ID of the virtual interface failover test.</p>
    pub fn test_id(&self) -> std::option::Option<&str> {
        self.test_id.as_deref()
    }
    /// <p>The ID of the tested virtual interface.</p>
    pub fn virtual_interface_id(&self) -> std::option::Option<&str> {
        self.virtual_interface_id.as_deref()
    }
    /// <p>The BGP peers that were put in the DOWN state as part of the virtual interface failover test.</p>
    pub fn bgp_peers(&self) -> std::option::Option<&[std::string::String]> {
        self.bgp_peers.as_deref()
    }
    /// <p>The status of the virtual interface failover test.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The owner ID of the tested virtual interface.</p>
    pub fn owner_account(&self) -> std::option::Option<&str> {
        self.owner_account.as_deref()
    }
    /// <p>The time that the virtual interface failover test ran in minutes.</p>
    pub fn test_duration_in_minutes(&self) -> std::option::Option<i32> {
        self.test_duration_in_minutes
    }
    /// <p>The time that the virtual interface moves to the DOWN state.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The time that the virtual interface moves out of the DOWN state.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
}
impl std::fmt::Debug for VirtualInterfaceTestHistory {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualInterfaceTestHistory");
        formatter.field("test_id", &self.test_id);
        formatter.field("virtual_interface_id", &self.virtual_interface_id);
        formatter.field("bgp_peers", &self.bgp_peers);
        formatter.field("status", &self.status);
        formatter.field("owner_account", &self.owner_account);
        formatter.field("test_duration_in_minutes", &self.test_duration_in_minutes);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.finish()
    }
}
/// See [`VirtualInterfaceTestHistory`](crate::model::VirtualInterfaceTestHistory)
pub mod virtual_interface_test_history {
    /// A builder for [`VirtualInterfaceTestHistory`](crate::model::VirtualInterfaceTestHistory)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) test_id: std::option::Option<std::string::String>,
        pub(crate) virtual_interface_id: std::option::Option<std::string::String>,
        pub(crate) bgp_peers: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) test_duration_in_minutes: std::option::Option<i32>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ID of the virtual interface failover test.</p>
        pub fn test_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.test_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual interface failover test.</p>
        pub fn set_test_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.test_id = input;
            self
        }
        /// <p>The ID of the tested virtual interface.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the tested virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_id = input;
            self
        }
        /// Appends an item to `bgp_peers`.
        ///
        /// To override the contents of this collection use [`set_bgp_peers`](Self::set_bgp_peers).
        ///
        /// <p>The BGP peers that were put in the DOWN state as part of the virtual interface failover test.</p>
        pub fn bgp_peers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.bgp_peers.unwrap_or_default();
            v.push(input.into());
            self.bgp_peers = Some(v);
            self
        }
        /// <p>The BGP peers that were put in the DOWN state as part of the virtual interface failover test.</p>
        pub fn set_bgp_peers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.bgp_peers = input;
            self
        }
        /// <p>The status of the virtual interface failover test.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the virtual interface failover test.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The owner ID of the tested virtual interface.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The owner ID of the tested virtual interface.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>The time that the virtual interface failover test ran in minutes.</p>
        pub fn test_duration_in_minutes(mut self, input: i32) -> Self {
            self.test_duration_in_minutes = Some(input);
            self
        }
        /// <p>The time that the virtual interface failover test ran in minutes.</p>
        pub fn set_test_duration_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.test_duration_in_minutes = input;
            self
        }
        /// <p>The time that the virtual interface moves to the DOWN state.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The time that the virtual interface moves to the DOWN state.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The time that the virtual interface moves out of the DOWN state.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The time that the virtual interface moves out of the DOWN state.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualInterfaceTestHistory`](crate::model::VirtualInterfaceTestHistory)
        pub fn build(self) -> crate::model::VirtualInterfaceTestHistory {
            crate::model::VirtualInterfaceTestHistory {
                test_id: self.test_id,
                virtual_interface_id: self.virtual_interface_id,
                bgp_peers: self.bgp_peers,
                status: self.status,
                owner_account: self.owner_account,
                test_duration_in_minutes: self.test_duration_in_minutes,
                start_time: self.start_time,
                end_time: self.end_time,
            }
        }
    }
}
impl VirtualInterfaceTestHistory {
    /// Creates a new builder-style object to manufacture [`VirtualInterfaceTestHistory`](crate::model::VirtualInterfaceTestHistory)
    pub fn builder() -> crate::model::virtual_interface_test_history::Builder {
        crate::model::virtual_interface_test_history::Builder::default()
    }
}

/// <p>Information about a virtual interface.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualInterface {
    /// <p>The ID of the Amazon Web Services account that owns the virtual interface.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>The ID of the virtual interface.</p>
    pub virtual_interface_id: std::option::Option<std::string::String>,
    /// <p>The location of the connection.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The ID of the connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The type of virtual interface. The possible values are <code>private</code> and <code>public</code>.</p>
    pub virtual_interface_type: std::option::Option<std::string::String>,
    /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
    pub virtual_interface_name: std::option::Option<std::string::String>,
    /// <p>The ID of the VLAN.</p>
    pub vlan: i32,
    /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
    /// <p>The valid values are 1-2147483647.</p>
    pub asn: i32,
    /// <p>The autonomous system number (ASN) for the Amazon side of the connection.</p>
    pub amazon_side_asn: std::option::Option<i64>,
    /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
    pub auth_key: std::option::Option<std::string::String>,
    /// <p>The IP address assigned to the Amazon interface.</p>
    pub amazon_address: std::option::Option<std::string::String>,
    /// <p>The IP address assigned to the customer interface.</p>
    pub customer_address: std::option::Option<std::string::String>,
    /// <p>The address family for the BGP peer.</p>
    pub address_family: std::option::Option<crate::model::AddressFamily>,
    /// <p>The state of the virtual interface. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: A virtual interface that is BGP down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The state of the virtual interface is not available.</p>
    /// </li>
    /// </ul>
    pub virtual_interface_state: std::option::Option<crate::model::VirtualInterfaceState>,
    /// <p>The customer router configuration.</p>
    pub customer_router_config: std::option::Option<std::string::String>,
    /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
    pub mtu: std::option::Option<i32>,
    /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    pub jumbo_frame_capable: std::option::Option<bool>,
    /// <p>The ID of the virtual private gateway. Applies only to private virtual interfaces.</p>
    pub virtual_gateway_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Direct Connect gateway.</p>
    pub direct_connect_gateway_id: std::option::Option<std::string::String>,
    /// <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
    pub route_filter_prefixes: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
    /// <p>The BGP peers configured on this virtual interface.</p>
    pub bgp_peers: std::option::Option<std::vec::Vec<crate::model::BgpPeer>>,
    /// <p>The Amazon Web Services Region where the virtual interface is located.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
    pub aws_device_v2: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
    /// different than the device that terminates the physical connection.</p>
    pub aws_logical_device_id: std::option::Option<std::string::String>,
    /// <p>The tags associated with the virtual interface.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl VirtualInterface {
    /// <p>The ID of the Amazon Web Services account that owns the virtual interface.</p>
    pub fn owner_account(&self) -> std::option::Option<&str> {
        self.owner_account.as_deref()
    }
    /// <p>The ID of the virtual interface.</p>
    pub fn virtual_interface_id(&self) -> std::option::Option<&str> {
        self.virtual_interface_id.as_deref()
    }
    /// <p>The location of the connection.</p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
    /// <p>The ID of the connection.</p>
    pub fn connection_id(&self) -> std::option::Option<&str> {
        self.connection_id.as_deref()
    }
    /// <p>The type of virtual interface. The possible values are <code>private</code> and <code>public</code>.</p>
    pub fn virtual_interface_type(&self) -> std::option::Option<&str> {
        self.virtual_interface_type.as_deref()
    }
    /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
    pub fn virtual_interface_name(&self) -> std::option::Option<&str> {
        self.virtual_interface_name.as_deref()
    }
    /// <p>The ID of the VLAN.</p>
    pub fn vlan(&self) -> i32 {
        self.vlan
    }
    /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
    /// <p>The valid values are 1-2147483647.</p>
    pub fn asn(&self) -> i32 {
        self.asn
    }
    /// <p>The autonomous system number (ASN) for the Amazon side of the connection.</p>
    pub fn amazon_side_asn(&self) -> std::option::Option<i64> {
        self.amazon_side_asn
    }
    /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
    pub fn auth_key(&self) -> std::option::Option<&str> {
        self.auth_key.as_deref()
    }
    /// <p>The IP address assigned to the Amazon interface.</p>
    pub fn amazon_address(&self) -> std::option::Option<&str> {
        self.amazon_address.as_deref()
    }
    /// <p>The IP address assigned to the customer interface.</p>
    pub fn customer_address(&self) -> std::option::Option<&str> {
        self.customer_address.as_deref()
    }
    /// <p>The address family for the BGP peer.</p>
    pub fn address_family(&self) -> std::option::Option<&crate::model::AddressFamily> {
        self.address_family.as_ref()
    }
    /// <p>The state of the virtual interface. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: A virtual interface that is BGP down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The state of the virtual interface is not available.</p>
    /// </li>
    /// </ul>
    pub fn virtual_interface_state(
        &self,
    ) -> std::option::Option<&crate::model::VirtualInterfaceState> {
        self.virtual_interface_state.as_ref()
    }
    /// <p>The customer router configuration.</p>
    pub fn customer_router_config(&self) -> std::option::Option<&str> {
        self.customer_router_config.as_deref()
    }
    /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
    pub fn mtu(&self) -> std::option::Option<i32> {
        self.mtu
    }
    /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    pub fn jumbo_frame_capable(&self) -> std::option::Option<bool> {
        self.jumbo_frame_capable
    }
    /// <p>The ID of the virtual private gateway. Applies only to private virtual interfaces.</p>
    pub fn virtual_gateway_id(&self) -> std::option::Option<&str> {
        self.virtual_gateway_id.as_deref()
    }
    /// <p>The ID of the Direct Connect gateway.</p>
    pub fn direct_connect_gateway_id(&self) -> std::option::Option<&str> {
        self.direct_connect_gateway_id.as_deref()
    }
    /// <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
    pub fn route_filter_prefixes(&self) -> std::option::Option<&[crate::model::RouteFilterPrefix]> {
        self.route_filter_prefixes.as_deref()
    }
    /// <p>The BGP peers configured on this virtual interface.</p>
    pub fn bgp_peers(&self) -> std::option::Option<&[crate::model::BgpPeer]> {
        self.bgp_peers.as_deref()
    }
    /// <p>The Amazon Web Services Region where the virtual interface is located.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
    pub fn aws_device_v2(&self) -> std::option::Option<&str> {
        self.aws_device_v2.as_deref()
    }
    /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
    /// different than the device that terminates the physical connection.</p>
    pub fn aws_logical_device_id(&self) -> std::option::Option<&str> {
        self.aws_logical_device_id.as_deref()
    }
    /// <p>The tags associated with the virtual interface.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for VirtualInterface {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualInterface");
        formatter.field("owner_account", &self.owner_account);
        formatter.field("virtual_interface_id", &self.virtual_interface_id);
        formatter.field("location", &self.location);
        formatter.field("connection_id", &self.connection_id);
        formatter.field("virtual_interface_type", &self.virtual_interface_type);
        formatter.field("virtual_interface_name", &self.virtual_interface_name);
        formatter.field("vlan", &self.vlan);
        formatter.field("asn", &self.asn);
        formatter.field("amazon_side_asn", &self.amazon_side_asn);
        formatter.field("auth_key", &self.auth_key);
        formatter.field("amazon_address", &self.amazon_address);
        formatter.field("customer_address", &self.customer_address);
        formatter.field("address_family", &self.address_family);
        formatter.field("virtual_interface_state", &self.virtual_interface_state);
        formatter.field("customer_router_config", &self.customer_router_config);
        formatter.field("mtu", &self.mtu);
        formatter.field("jumbo_frame_capable", &self.jumbo_frame_capable);
        formatter.field("virtual_gateway_id", &self.virtual_gateway_id);
        formatter.field("direct_connect_gateway_id", &self.direct_connect_gateway_id);
        formatter.field("route_filter_prefixes", &self.route_filter_prefixes);
        formatter.field("bgp_peers", &self.bgp_peers);
        formatter.field("region", &self.region);
        formatter.field("aws_device_v2", &self.aws_device_v2);
        formatter.field("aws_logical_device_id", &self.aws_logical_device_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`VirtualInterface`](crate::model::VirtualInterface)
pub mod virtual_interface {
    /// A builder for [`VirtualInterface`](crate::model::VirtualInterface)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) virtual_interface_id: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) virtual_interface_type: std::option::Option<std::string::String>,
        pub(crate) virtual_interface_name: std::option::Option<std::string::String>,
        pub(crate) vlan: std::option::Option<i32>,
        pub(crate) asn: std::option::Option<i32>,
        pub(crate) amazon_side_asn: std::option::Option<i64>,
        pub(crate) auth_key: std::option::Option<std::string::String>,
        pub(crate) amazon_address: std::option::Option<std::string::String>,
        pub(crate) customer_address: std::option::Option<std::string::String>,
        pub(crate) address_family: std::option::Option<crate::model::AddressFamily>,
        pub(crate) virtual_interface_state:
            std::option::Option<crate::model::VirtualInterfaceState>,
        pub(crate) customer_router_config: std::option::Option<std::string::String>,
        pub(crate) mtu: std::option::Option<i32>,
        pub(crate) jumbo_frame_capable: std::option::Option<bool>,
        pub(crate) virtual_gateway_id: std::option::Option<std::string::String>,
        pub(crate) direct_connect_gateway_id: std::option::Option<std::string::String>,
        pub(crate) route_filter_prefixes:
            std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        pub(crate) bgp_peers: std::option::Option<std::vec::Vec<crate::model::BgpPeer>>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) aws_device_v2: std::option::Option<std::string::String>,
        pub(crate) aws_logical_device_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that owns the virtual interface.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the virtual interface.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_id = input;
            self
        }
        /// <p>The location of the connection.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The location of the connection.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The type of virtual interface. The possible values are <code>private</code> and <code>public</code>.</p>
        pub fn virtual_interface_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_type = Some(input.into());
            self
        }
        /// <p>The type of virtual interface. The possible values are <code>private</code> and <code>public</code>.</p>
        pub fn set_virtual_interface_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_type = input;
            self
        }
        /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
        pub fn virtual_interface_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
        pub fn set_virtual_interface_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_name = input;
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn vlan(mut self, input: i32) -> Self {
            self.vlan = Some(input);
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn set_vlan(mut self, input: std::option::Option<i32>) -> Self {
            self.vlan = input;
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        /// <p>The valid values are 1-2147483647.</p>
        pub fn asn(mut self, input: i32) -> Self {
            self.asn = Some(input);
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        /// <p>The valid values are 1-2147483647.</p>
        pub fn set_asn(mut self, input: std::option::Option<i32>) -> Self {
            self.asn = input;
            self
        }
        /// <p>The autonomous system number (ASN) for the Amazon side of the connection.</p>
        pub fn amazon_side_asn(mut self, input: i64) -> Self {
            self.amazon_side_asn = Some(input);
            self
        }
        /// <p>The autonomous system number (ASN) for the Amazon side of the connection.</p>
        pub fn set_amazon_side_asn(mut self, input: std::option::Option<i64>) -> Self {
            self.amazon_side_asn = input;
            self
        }
        /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
        pub fn auth_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.auth_key = Some(input.into());
            self
        }
        /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
        pub fn set_auth_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.auth_key = input;
            self
        }
        /// <p>The IP address assigned to the Amazon interface.</p>
        pub fn amazon_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.amazon_address = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the Amazon interface.</p>
        pub fn set_amazon_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amazon_address = input;
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn customer_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_address = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn set_customer_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_address = input;
            self
        }
        /// <p>The address family for the BGP peer.</p>
        pub fn address_family(mut self, input: crate::model::AddressFamily) -> Self {
            self.address_family = Some(input);
            self
        }
        /// <p>The address family for the BGP peer.</p>
        pub fn set_address_family(
            mut self,
            input: std::option::Option<crate::model::AddressFamily>,
        ) -> Self {
            self.address_family = input;
            self
        }
        /// <p>The state of the virtual interface. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: A virtual interface that is BGP down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the virtual interface is not available.</p>
        /// </li>
        /// </ul>
        pub fn virtual_interface_state(
            mut self,
            input: crate::model::VirtualInterfaceState,
        ) -> Self {
            self.virtual_interface_state = Some(input);
            self
        }
        /// <p>The state of the virtual interface. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: A virtual interface that is BGP down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the virtual interface is not available.</p>
        /// </li>
        /// </ul>
        pub fn set_virtual_interface_state(
            mut self,
            input: std::option::Option<crate::model::VirtualInterfaceState>,
        ) -> Self {
            self.virtual_interface_state = input;
            self
        }
        /// <p>The customer router configuration.</p>
        pub fn customer_router_config(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_router_config = Some(input.into());
            self
        }
        /// <p>The customer router configuration.</p>
        pub fn set_customer_router_config(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_router_config = input;
            self
        }
        /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
        pub fn mtu(mut self, input: i32) -> Self {
            self.mtu = Some(input);
            self
        }
        /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
        pub fn set_mtu(mut self, input: std::option::Option<i32>) -> Self {
            self.mtu = input;
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn jumbo_frame_capable(mut self, input: bool) -> Self {
            self.jumbo_frame_capable = Some(input);
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn set_jumbo_frame_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.jumbo_frame_capable = input;
            self
        }
        /// <p>The ID of the virtual private gateway. Applies only to private virtual interfaces.</p>
        pub fn virtual_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual private gateway. Applies only to private virtual interfaces.</p>
        pub fn set_virtual_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_gateway_id = input;
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.direct_connect_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_id = input;
            self
        }
        /// Appends an item to `route_filter_prefixes`.
        ///
        /// To override the contents of this collection use [`set_route_filter_prefixes`](Self::set_route_filter_prefixes).
        ///
        /// <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
        pub fn route_filter_prefixes(
            mut self,
            input: impl Into<crate::model::RouteFilterPrefix>,
        ) -> Self {
            let mut v = self.route_filter_prefixes.unwrap_or_default();
            v.push(input.into());
            self.route_filter_prefixes = Some(v);
            self
        }
        /// <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
        pub fn set_route_filter_prefixes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        ) -> Self {
            self.route_filter_prefixes = input;
            self
        }
        /// Appends an item to `bgp_peers`.
        ///
        /// To override the contents of this collection use [`set_bgp_peers`](Self::set_bgp_peers).
        ///
        /// <p>The BGP peers configured on this virtual interface.</p>
        pub fn bgp_peers(mut self, input: impl Into<crate::model::BgpPeer>) -> Self {
            let mut v = self.bgp_peers.unwrap_or_default();
            v.push(input.into());
            self.bgp_peers = Some(v);
            self
        }
        /// <p>The BGP peers configured on this virtual interface.</p>
        pub fn set_bgp_peers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BgpPeer>>,
        ) -> Self {
            self.bgp_peers = input;
            self
        }
        /// <p>The Amazon Web Services Region where the virtual interface is located.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region where the virtual interface is located.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn aws_device_v2(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device_v2 = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn set_aws_device_v2(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_device_v2 = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn aws_logical_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_logical_device_id = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn set_aws_logical_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_logical_device_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the virtual interface.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the virtual interface.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualInterface`](crate::model::VirtualInterface)
        pub fn build(self) -> crate::model::VirtualInterface {
            crate::model::VirtualInterface {
                owner_account: self.owner_account,
                virtual_interface_id: self.virtual_interface_id,
                location: self.location,
                connection_id: self.connection_id,
                virtual_interface_type: self.virtual_interface_type,
                virtual_interface_name: self.virtual_interface_name,
                vlan: self.vlan.unwrap_or_default(),
                asn: self.asn.unwrap_or_default(),
                amazon_side_asn: self.amazon_side_asn,
                auth_key: self.auth_key,
                amazon_address: self.amazon_address,
                customer_address: self.customer_address,
                address_family: self.address_family,
                virtual_interface_state: self.virtual_interface_state,
                customer_router_config: self.customer_router_config,
                mtu: self.mtu,
                jumbo_frame_capable: self.jumbo_frame_capable,
                virtual_gateway_id: self.virtual_gateway_id,
                direct_connect_gateway_id: self.direct_connect_gateway_id,
                route_filter_prefixes: self.route_filter_prefixes,
                bgp_peers: self.bgp_peers,
                region: self.region,
                aws_device_v2: self.aws_device_v2,
                aws_logical_device_id: self.aws_logical_device_id,
                tags: self.tags,
            }
        }
    }
}
impl VirtualInterface {
    /// Creates a new builder-style object to manufacture [`VirtualInterface`](crate::model::VirtualInterface)
    pub fn builder() -> crate::model::virtual_interface::Builder {
        crate::model::virtual_interface::Builder::default()
    }
}

/// <p>Information about a virtual private gateway for a private virtual interface.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualGateway {
    /// <p>The ID of the virtual private gateway.</p>
    pub virtual_gateway_id: std::option::Option<std::string::String>,
    /// <p>The state of the virtual private gateway. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>pending</code>: Initial state after creating the virtual private gateway.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: Ready for use by a private virtual interface.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: Initial state after deleting the virtual private gateway.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: The virtual private gateway is deleted. The private virtual interface is unable to send traffic over this gateway.</p>
    /// </li>
    /// </ul>
    pub virtual_gateway_state: std::option::Option<std::string::String>,
}
impl VirtualGateway {
    /// <p>The ID of the virtual private gateway.</p>
    pub fn virtual_gateway_id(&self) -> std::option::Option<&str> {
        self.virtual_gateway_id.as_deref()
    }
    /// <p>The state of the virtual private gateway. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>pending</code>: Initial state after creating the virtual private gateway.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: Ready for use by a private virtual interface.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: Initial state after deleting the virtual private gateway.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: The virtual private gateway is deleted. The private virtual interface is unable to send traffic over this gateway.</p>
    /// </li>
    /// </ul>
    pub fn virtual_gateway_state(&self) -> std::option::Option<&str> {
        self.virtual_gateway_state.as_deref()
    }
}
impl std::fmt::Debug for VirtualGateway {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualGateway");
        formatter.field("virtual_gateway_id", &self.virtual_gateway_id);
        formatter.field("virtual_gateway_state", &self.virtual_gateway_state);
        formatter.finish()
    }
}
/// See [`VirtualGateway`](crate::model::VirtualGateway)
pub mod virtual_gateway {
    /// A builder for [`VirtualGateway`](crate::model::VirtualGateway)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_gateway_id: std::option::Option<std::string::String>,
        pub(crate) virtual_gateway_state: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the virtual private gateway.</p>
        pub fn virtual_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual private gateway.</p>
        pub fn set_virtual_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_gateway_id = input;
            self
        }
        /// <p>The state of the virtual private gateway. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>pending</code>: Initial state after creating the virtual private gateway.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: Ready for use by a private virtual interface.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: Initial state after deleting the virtual private gateway.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The virtual private gateway is deleted. The private virtual interface is unable to send traffic over this gateway.</p>
        /// </li>
        /// </ul>
        pub fn virtual_gateway_state(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_gateway_state = Some(input.into());
            self
        }
        /// <p>The state of the virtual private gateway. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>pending</code>: Initial state after creating the virtual private gateway.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: Ready for use by a private virtual interface.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: Initial state after deleting the virtual private gateway.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The virtual private gateway is deleted. The private virtual interface is unable to send traffic over this gateway.</p>
        /// </li>
        /// </ul>
        pub fn set_virtual_gateway_state(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_gateway_state = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualGateway`](crate::model::VirtualGateway)
        pub fn build(self) -> crate::model::VirtualGateway {
            crate::model::VirtualGateway {
                virtual_gateway_id: self.virtual_gateway_id,
                virtual_gateway_state: self.virtual_gateway_state,
            }
        }
    }
}
impl VirtualGateway {
    /// Creates a new builder-style object to manufacture [`VirtualGateway`](crate::model::VirtualGateway)
    pub fn builder() -> crate::model::virtual_gateway::Builder {
        crate::model::virtual_gateway::Builder::default()
    }
}

/// <p>Information about a tag associated with an Direct Connect resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceTag {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ResourceTag {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tags.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ResourceTag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceTag");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ResourceTag`](crate::model::ResourceTag)
pub mod resource_tag {
    /// A builder for [`ResourceTag`](crate::model::ResourceTag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceTag`](crate::model::ResourceTag)
        pub fn build(self) -> crate::model::ResourceTag {
            crate::model::ResourceTag {
                resource_arn: self.resource_arn,
                tags: self.tags,
            }
        }
    }
}
impl ResourceTag {
    /// Creates a new builder-style object to manufacture [`ResourceTag`](crate::model::ResourceTag)
    pub fn builder() -> crate::model::resource_tag::Builder {
        crate::model::resource_tag::Builder::default()
    }
}

/// <p>Information about the virtual router.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RouterType {
    /// <p>The vendor for the virtual interface's router.</p>
    pub vendor: std::option::Option<std::string::String>,
    /// <p>The virtual interface router platform.</p>
    pub platform: std::option::Option<std::string::String>,
    /// <p>The router software. </p>
    pub software: std::option::Option<std::string::String>,
    /// <p>The template for the virtual interface's router.</p>
    pub xslt_template_name: std::option::Option<std::string::String>,
    /// <p>The MAC Security (MACsec) template for the virtual interface's router.</p>
    pub xslt_template_name_for_mac_sec: std::option::Option<std::string::String>,
    /// <p>Identifies the router by a combination of vendor, platform, and software version. For example, <code>CiscoSystemsInc-2900SeriesRouters-IOS124</code>.</p>
    pub router_type_identifier: std::option::Option<std::string::String>,
}
impl RouterType {
    /// <p>The vendor for the virtual interface's router.</p>
    pub fn vendor(&self) -> std::option::Option<&str> {
        self.vendor.as_deref()
    }
    /// <p>The virtual interface router platform.</p>
    pub fn platform(&self) -> std::option::Option<&str> {
        self.platform.as_deref()
    }
    /// <p>The router software. </p>
    pub fn software(&self) -> std::option::Option<&str> {
        self.software.as_deref()
    }
    /// <p>The template for the virtual interface's router.</p>
    pub fn xslt_template_name(&self) -> std::option::Option<&str> {
        self.xslt_template_name.as_deref()
    }
    /// <p>The MAC Security (MACsec) template for the virtual interface's router.</p>
    pub fn xslt_template_name_for_mac_sec(&self) -> std::option::Option<&str> {
        self.xslt_template_name_for_mac_sec.as_deref()
    }
    /// <p>Identifies the router by a combination of vendor, platform, and software version. For example, <code>CiscoSystemsInc-2900SeriesRouters-IOS124</code>.</p>
    pub fn router_type_identifier(&self) -> std::option::Option<&str> {
        self.router_type_identifier.as_deref()
    }
}
impl std::fmt::Debug for RouterType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RouterType");
        formatter.field("vendor", &self.vendor);
        formatter.field("platform", &self.platform);
        formatter.field("software", &self.software);
        formatter.field("xslt_template_name", &self.xslt_template_name);
        formatter.field(
            "xslt_template_name_for_mac_sec",
            &self.xslt_template_name_for_mac_sec,
        );
        formatter.field("router_type_identifier", &self.router_type_identifier);
        formatter.finish()
    }
}
/// See [`RouterType`](crate::model::RouterType)
pub mod router_type {
    /// A builder for [`RouterType`](crate::model::RouterType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vendor: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<std::string::String>,
        pub(crate) software: std::option::Option<std::string::String>,
        pub(crate) xslt_template_name: std::option::Option<std::string::String>,
        pub(crate) xslt_template_name_for_mac_sec: std::option::Option<std::string::String>,
        pub(crate) router_type_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The vendor for the virtual interface's router.</p>
        pub fn vendor(mut self, input: impl Into<std::string::String>) -> Self {
            self.vendor = Some(input.into());
            self
        }
        /// <p>The vendor for the virtual interface's router.</p>
        pub fn set_vendor(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vendor = input;
            self
        }
        /// <p>The virtual interface router platform.</p>
        pub fn platform(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform = Some(input.into());
            self
        }
        /// <p>The virtual interface router platform.</p>
        pub fn set_platform(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform = input;
            self
        }
        /// <p>The router software. </p>
        pub fn software(mut self, input: impl Into<std::string::String>) -> Self {
            self.software = Some(input.into());
            self
        }
        /// <p>The router software. </p>
        pub fn set_software(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.software = input;
            self
        }
        /// <p>The template for the virtual interface's router.</p>
        pub fn xslt_template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.xslt_template_name = Some(input.into());
            self
        }
        /// <p>The template for the virtual interface's router.</p>
        pub fn set_xslt_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.xslt_template_name = input;
            self
        }
        /// <p>The MAC Security (MACsec) template for the virtual interface's router.</p>
        pub fn xslt_template_name_for_mac_sec(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.xslt_template_name_for_mac_sec = Some(input.into());
            self
        }
        /// <p>The MAC Security (MACsec) template for the virtual interface's router.</p>
        pub fn set_xslt_template_name_for_mac_sec(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.xslt_template_name_for_mac_sec = input;
            self
        }
        /// <p>Identifies the router by a combination of vendor, platform, and software version. For example, <code>CiscoSystemsInc-2900SeriesRouters-IOS124</code>.</p>
        pub fn router_type_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.router_type_identifier = Some(input.into());
            self
        }
        /// <p>Identifies the router by a combination of vendor, platform, and software version. For example, <code>CiscoSystemsInc-2900SeriesRouters-IOS124</code>.</p>
        pub fn set_router_type_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.router_type_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`RouterType`](crate::model::RouterType)
        pub fn build(self) -> crate::model::RouterType {
            crate::model::RouterType {
                vendor: self.vendor,
                platform: self.platform,
                software: self.software,
                xslt_template_name: self.xslt_template_name,
                xslt_template_name_for_mac_sec: self.xslt_template_name_for_mac_sec,
                router_type_identifier: self.router_type_identifier,
            }
        }
    }
}
impl RouterType {
    /// Creates a new builder-style object to manufacture [`RouterType`](crate::model::RouterType)
    pub fn builder() -> crate::model::router_type::Builder {
        crate::model::router_type::Builder::default()
    }
}

/// <p>Information about an Direct Connect location.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Location {
    /// <p>The code for the location.</p>
    pub location_code: std::option::Option<std::string::String>,
    /// <p>The name of the location. This includes the name of the colocation partner and the physical site of the building.</p>
    pub location_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region for the location.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The available port speeds for the location.</p>
    pub available_port_speeds: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the service provider for the location.</p>
    pub available_providers: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The available MAC Security (MACsec) port speeds for the location.</p>
    pub available_mac_sec_port_speeds: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Location {
    /// <p>The code for the location.</p>
    pub fn location_code(&self) -> std::option::Option<&str> {
        self.location_code.as_deref()
    }
    /// <p>The name of the location. This includes the name of the colocation partner and the physical site of the building.</p>
    pub fn location_name(&self) -> std::option::Option<&str> {
        self.location_name.as_deref()
    }
    /// <p>The Amazon Web Services Region for the location.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>The available port speeds for the location.</p>
    pub fn available_port_speeds(&self) -> std::option::Option<&[std::string::String]> {
        self.available_port_speeds.as_deref()
    }
    /// <p>The name of the service provider for the location.</p>
    pub fn available_providers(&self) -> std::option::Option<&[std::string::String]> {
        self.available_providers.as_deref()
    }
    /// <p>The available MAC Security (MACsec) port speeds for the location.</p>
    pub fn available_mac_sec_port_speeds(&self) -> std::option::Option<&[std::string::String]> {
        self.available_mac_sec_port_speeds.as_deref()
    }
}
impl std::fmt::Debug for Location {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Location");
        formatter.field("location_code", &self.location_code);
        formatter.field("location_name", &self.location_name);
        formatter.field("region", &self.region);
        formatter.field("available_port_speeds", &self.available_port_speeds);
        formatter.field("available_providers", &self.available_providers);
        formatter.field(
            "available_mac_sec_port_speeds",
            &self.available_mac_sec_port_speeds,
        );
        formatter.finish()
    }
}
/// See [`Location`](crate::model::Location)
pub mod location {
    /// A builder for [`Location`](crate::model::Location)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location_code: std::option::Option<std::string::String>,
        pub(crate) location_name: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) available_port_speeds: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) available_providers: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) available_mac_sec_port_speeds:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The code for the location.</p>
        pub fn location_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_code = Some(input.into());
            self
        }
        /// <p>The code for the location.</p>
        pub fn set_location_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.location_code = input;
            self
        }
        /// <p>The name of the location. This includes the name of the colocation partner and the physical site of the building.</p>
        pub fn location_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_name = Some(input.into());
            self
        }
        /// <p>The name of the location. This includes the name of the colocation partner and the physical site of the building.</p>
        pub fn set_location_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.location_name = input;
            self
        }
        /// <p>The Amazon Web Services Region for the location.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region for the location.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// Appends an item to `available_port_speeds`.
        ///
        /// To override the contents of this collection use [`set_available_port_speeds`](Self::set_available_port_speeds).
        ///
        /// <p>The available port speeds for the location.</p>
        pub fn available_port_speeds(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.available_port_speeds.unwrap_or_default();
            v.push(input.into());
            self.available_port_speeds = Some(v);
            self
        }
        /// <p>The available port speeds for the location.</p>
        pub fn set_available_port_speeds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.available_port_speeds = input;
            self
        }
        /// Appends an item to `available_providers`.
        ///
        /// To override the contents of this collection use [`set_available_providers`](Self::set_available_providers).
        ///
        /// <p>The name of the service provider for the location.</p>
        pub fn available_providers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.available_providers.unwrap_or_default();
            v.push(input.into());
            self.available_providers = Some(v);
            self
        }
        /// <p>The name of the service provider for the location.</p>
        pub fn set_available_providers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.available_providers = input;
            self
        }
        /// Appends an item to `available_mac_sec_port_speeds`.
        ///
        /// To override the contents of this collection use [`set_available_mac_sec_port_speeds`](Self::set_available_mac_sec_port_speeds).
        ///
        /// <p>The available MAC Security (MACsec) port speeds for the location.</p>
        pub fn available_mac_sec_port_speeds(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.available_mac_sec_port_speeds.unwrap_or_default();
            v.push(input.into());
            self.available_mac_sec_port_speeds = Some(v);
            self
        }
        /// <p>The available MAC Security (MACsec) port speeds for the location.</p>
        pub fn set_available_mac_sec_port_speeds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.available_mac_sec_port_speeds = input;
            self
        }
        /// Consumes the builder and constructs a [`Location`](crate::model::Location)
        pub fn build(self) -> crate::model::Location {
            crate::model::Location {
                location_code: self.location_code,
                location_name: self.location_name,
                region: self.region,
                available_port_speeds: self.available_port_speeds,
                available_providers: self.available_providers,
                available_mac_sec_port_speeds: self.available_mac_sec_port_speeds,
            }
        }
    }
}
impl Location {
    /// Creates a new builder-style object to manufacture [`Location`](crate::model::Location)
    pub fn builder() -> crate::model::location::Builder {
        crate::model::location::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LoaContentType {
    #[allow(missing_docs)] // documentation missing in model
    Pdf,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LoaContentType {
    fn from(s: &str) -> Self {
        match s {
            "application/pdf" => LoaContentType::Pdf,
            other => LoaContentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LoaContentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LoaContentType::from(s))
    }
}
impl LoaContentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LoaContentType::Pdf => "application/pdf",
            LoaContentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["application/pdf"]
    }
}
impl AsRef<str> for LoaContentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a link aggregation group (LAG).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Lag {
    /// <p>The individual bandwidth of the physical connections bundled by the LAG. The possible
    /// values are 1Gbps and 10Gbps. </p>
    pub connections_bandwidth: std::option::Option<std::string::String>,
    /// <p>The number of physical dedicated connections bundled by the LAG, up to a maximum of 10.</p>
    pub number_of_connections: i32,
    /// <p>The ID of the LAG.</p>
    pub lag_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Web Services account that owns the LAG.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>The name of the LAG.</p>
    pub lag_name: std::option::Option<std::string::String>,
    /// <p>The state of the LAG. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>requested</code>: The initial state of a LAG. The LAG stays in the
    /// requested state until the Letter of Authorization (LOA) is available.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: The LAG has been approved and is being initialized.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: The network link is established and the LAG is ready for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: The network link is down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: The LAG is being deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: The LAG is deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The state of the LAG is not available.</p>
    /// </li>
    /// </ul>
    pub lag_state: std::option::Option<crate::model::LagState>,
    /// <p>The location of the LAG.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region where the connection is located.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The minimum number of physical dedicated connections that must be operational for the LAG itself to be operational.</p>
    pub minimum_links: i32,
    /// <p>The Direct Connect endpoint that hosts the LAG.</p>
    pub aws_device: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that hosts the LAG.</p>
    pub aws_device_v2: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
    /// different than the device that terminates the physical connection.</p>
    pub aws_logical_device_id: std::option::Option<std::string::String>,
    /// <p>The connections bundled by the LAG.</p>
    pub connections: std::option::Option<std::vec::Vec<crate::model::Connection>>,
    /// <p>Indicates whether the LAG can host other connections.</p>
    pub allows_hosted_connections: bool,
    /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    pub jumbo_frame_capable: std::option::Option<bool>,
    /// <p>Indicates whether the LAG supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
    pub has_logical_redundancy: std::option::Option<crate::model::HasLogicalRedundancy>,
    /// <p>The tags associated with the LAG.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The name of the service provider associated with the LAG.</p>
    pub provider_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether the LAG supports MAC Security (MACsec).</p>
    pub mac_sec_capable: std::option::Option<bool>,
    /// <p>The LAG MAC Security (MACsec) encryption mode.</p>
    /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
    pub encryption_mode: std::option::Option<std::string::String>,
    /// <p>The MAC Security (MACsec) security keys associated with the LAG.</p>
    pub mac_sec_keys: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
}
impl Lag {
    /// <p>The individual bandwidth of the physical connections bundled by the LAG. The possible
    /// values are 1Gbps and 10Gbps. </p>
    pub fn connections_bandwidth(&self) -> std::option::Option<&str> {
        self.connections_bandwidth.as_deref()
    }
    /// <p>The number of physical dedicated connections bundled by the LAG, up to a maximum of 10.</p>
    pub fn number_of_connections(&self) -> i32 {
        self.number_of_connections
    }
    /// <p>The ID of the LAG.</p>
    pub fn lag_id(&self) -> std::option::Option<&str> {
        self.lag_id.as_deref()
    }
    /// <p>The ID of the Amazon Web Services account that owns the LAG.</p>
    pub fn owner_account(&self) -> std::option::Option<&str> {
        self.owner_account.as_deref()
    }
    /// <p>The name of the LAG.</p>
    pub fn lag_name(&self) -> std::option::Option<&str> {
        self.lag_name.as_deref()
    }
    /// <p>The state of the LAG. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>requested</code>: The initial state of a LAG. The LAG stays in the
    /// requested state until the Letter of Authorization (LOA) is available.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: The LAG has been approved and is being initialized.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: The network link is established and the LAG is ready for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: The network link is down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: The LAG is being deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: The LAG is deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The state of the LAG is not available.</p>
    /// </li>
    /// </ul>
    pub fn lag_state(&self) -> std::option::Option<&crate::model::LagState> {
        self.lag_state.as_ref()
    }
    /// <p>The location of the LAG.</p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
    /// <p>The Amazon Web Services Region where the connection is located.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>The minimum number of physical dedicated connections that must be operational for the LAG itself to be operational.</p>
    pub fn minimum_links(&self) -> i32 {
        self.minimum_links
    }
    /// <p>The Direct Connect endpoint that hosts the LAG.</p>
    pub fn aws_device(&self) -> std::option::Option<&str> {
        self.aws_device.as_deref()
    }
    /// <p>The Direct Connect endpoint that hosts the LAG.</p>
    pub fn aws_device_v2(&self) -> std::option::Option<&str> {
        self.aws_device_v2.as_deref()
    }
    /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
    /// different than the device that terminates the physical connection.</p>
    pub fn aws_logical_device_id(&self) -> std::option::Option<&str> {
        self.aws_logical_device_id.as_deref()
    }
    /// <p>The connections bundled by the LAG.</p>
    pub fn connections(&self) -> std::option::Option<&[crate::model::Connection]> {
        self.connections.as_deref()
    }
    /// <p>Indicates whether the LAG can host other connections.</p>
    pub fn allows_hosted_connections(&self) -> bool {
        self.allows_hosted_connections
    }
    /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    pub fn jumbo_frame_capable(&self) -> std::option::Option<bool> {
        self.jumbo_frame_capable
    }
    /// <p>Indicates whether the LAG supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
    pub fn has_logical_redundancy(
        &self,
    ) -> std::option::Option<&crate::model::HasLogicalRedundancy> {
        self.has_logical_redundancy.as_ref()
    }
    /// <p>The tags associated with the LAG.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The name of the service provider associated with the LAG.</p>
    pub fn provider_name(&self) -> std::option::Option<&str> {
        self.provider_name.as_deref()
    }
    /// <p>Indicates whether the LAG supports MAC Security (MACsec).</p>
    pub fn mac_sec_capable(&self) -> std::option::Option<bool> {
        self.mac_sec_capable
    }
    /// <p>The LAG MAC Security (MACsec) encryption mode.</p>
    /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
    pub fn encryption_mode(&self) -> std::option::Option<&str> {
        self.encryption_mode.as_deref()
    }
    /// <p>The MAC Security (MACsec) security keys associated with the LAG.</p>
    pub fn mac_sec_keys(&self) -> std::option::Option<&[crate::model::MacSecKey]> {
        self.mac_sec_keys.as_deref()
    }
}
impl std::fmt::Debug for Lag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Lag");
        formatter.field("connections_bandwidth", &self.connections_bandwidth);
        formatter.field("number_of_connections", &self.number_of_connections);
        formatter.field("lag_id", &self.lag_id);
        formatter.field("owner_account", &self.owner_account);
        formatter.field("lag_name", &self.lag_name);
        formatter.field("lag_state", &self.lag_state);
        formatter.field("location", &self.location);
        formatter.field("region", &self.region);
        formatter.field("minimum_links", &self.minimum_links);
        formatter.field("aws_device", &self.aws_device);
        formatter.field("aws_device_v2", &self.aws_device_v2);
        formatter.field("aws_logical_device_id", &self.aws_logical_device_id);
        formatter.field("connections", &self.connections);
        formatter.field("allows_hosted_connections", &self.allows_hosted_connections);
        formatter.field("jumbo_frame_capable", &self.jumbo_frame_capable);
        formatter.field("has_logical_redundancy", &self.has_logical_redundancy);
        formatter.field("tags", &self.tags);
        formatter.field("provider_name", &self.provider_name);
        formatter.field("mac_sec_capable", &self.mac_sec_capable);
        formatter.field("encryption_mode", &self.encryption_mode);
        formatter.field("mac_sec_keys", &self.mac_sec_keys);
        formatter.finish()
    }
}
/// See [`Lag`](crate::model::Lag)
pub mod lag {
    /// A builder for [`Lag`](crate::model::Lag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connections_bandwidth: std::option::Option<std::string::String>,
        pub(crate) number_of_connections: std::option::Option<i32>,
        pub(crate) lag_id: std::option::Option<std::string::String>,
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) lag_name: std::option::Option<std::string::String>,
        pub(crate) lag_state: std::option::Option<crate::model::LagState>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) minimum_links: std::option::Option<i32>,
        pub(crate) aws_device: std::option::Option<std::string::String>,
        pub(crate) aws_device_v2: std::option::Option<std::string::String>,
        pub(crate) aws_logical_device_id: std::option::Option<std::string::String>,
        pub(crate) connections: std::option::Option<std::vec::Vec<crate::model::Connection>>,
        pub(crate) allows_hosted_connections: std::option::Option<bool>,
        pub(crate) jumbo_frame_capable: std::option::Option<bool>,
        pub(crate) has_logical_redundancy: std::option::Option<crate::model::HasLogicalRedundancy>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) provider_name: std::option::Option<std::string::String>,
        pub(crate) mac_sec_capable: std::option::Option<bool>,
        pub(crate) encryption_mode: std::option::Option<std::string::String>,
        pub(crate) mac_sec_keys: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
    }
    impl Builder {
        /// <p>The individual bandwidth of the physical connections bundled by the LAG. The possible
        /// values are 1Gbps and 10Gbps. </p>
        pub fn connections_bandwidth(mut self, input: impl Into<std::string::String>) -> Self {
            self.connections_bandwidth = Some(input.into());
            self
        }
        /// <p>The individual bandwidth of the physical connections bundled by the LAG. The possible
        /// values are 1Gbps and 10Gbps. </p>
        pub fn set_connections_bandwidth(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connections_bandwidth = input;
            self
        }
        /// <p>The number of physical dedicated connections bundled by the LAG, up to a maximum of 10.</p>
        pub fn number_of_connections(mut self, input: i32) -> Self {
            self.number_of_connections = Some(input);
            self
        }
        /// <p>The number of physical dedicated connections bundled by the LAG, up to a maximum of 10.</p>
        pub fn set_number_of_connections(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_connections = input;
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.lag_id = Some(input.into());
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lag_id = input;
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the LAG.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the LAG.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>The name of the LAG.</p>
        pub fn lag_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.lag_name = Some(input.into());
            self
        }
        /// <p>The name of the LAG.</p>
        pub fn set_lag_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lag_name = input;
            self
        }
        /// <p>The state of the LAG. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of a LAG. The LAG stays in the
        /// requested state until the Letter of Authorization (LOA) is available.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The LAG has been approved and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is established and the LAG is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The LAG is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The LAG is deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the LAG is not available.</p>
        /// </li>
        /// </ul>
        pub fn lag_state(mut self, input: crate::model::LagState) -> Self {
            self.lag_state = Some(input);
            self
        }
        /// <p>The state of the LAG. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of a LAG. The LAG stays in the
        /// requested state until the Letter of Authorization (LOA) is available.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The LAG has been approved and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is established and the LAG is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The LAG is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The LAG is deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the LAG is not available.</p>
        /// </li>
        /// </ul>
        pub fn set_lag_state(mut self, input: std::option::Option<crate::model::LagState>) -> Self {
            self.lag_state = input;
            self
        }
        /// <p>The location of the LAG.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The location of the LAG.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The Amazon Web Services Region where the connection is located.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region where the connection is located.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The minimum number of physical dedicated connections that must be operational for the LAG itself to be operational.</p>
        pub fn minimum_links(mut self, input: i32) -> Self {
            self.minimum_links = Some(input);
            self
        }
        /// <p>The minimum number of physical dedicated connections that must be operational for the LAG itself to be operational.</p>
        pub fn set_minimum_links(mut self, input: std::option::Option<i32>) -> Self {
            self.minimum_links = input;
            self
        }
        /// <p>The Direct Connect endpoint that hosts the LAG.</p>
        pub fn aws_device(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that hosts the LAG.</p>
        pub fn set_aws_device(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_device = input;
            self
        }
        /// <p>The Direct Connect endpoint that hosts the LAG.</p>
        pub fn aws_device_v2(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device_v2 = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that hosts the LAG.</p>
        pub fn set_aws_device_v2(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_device_v2 = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn aws_logical_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_logical_device_id = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn set_aws_logical_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_logical_device_id = input;
            self
        }
        /// Appends an item to `connections`.
        ///
        /// To override the contents of this collection use [`set_connections`](Self::set_connections).
        ///
        /// <p>The connections bundled by the LAG.</p>
        pub fn connections(mut self, input: impl Into<crate::model::Connection>) -> Self {
            let mut v = self.connections.unwrap_or_default();
            v.push(input.into());
            self.connections = Some(v);
            self
        }
        /// <p>The connections bundled by the LAG.</p>
        pub fn set_connections(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Connection>>,
        ) -> Self {
            self.connections = input;
            self
        }
        /// <p>Indicates whether the LAG can host other connections.</p>
        pub fn allows_hosted_connections(mut self, input: bool) -> Self {
            self.allows_hosted_connections = Some(input);
            self
        }
        /// <p>Indicates whether the LAG can host other connections.</p>
        pub fn set_allows_hosted_connections(mut self, input: std::option::Option<bool>) -> Self {
            self.allows_hosted_connections = input;
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn jumbo_frame_capable(mut self, input: bool) -> Self {
            self.jumbo_frame_capable = Some(input);
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn set_jumbo_frame_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.jumbo_frame_capable = input;
            self
        }
        /// <p>Indicates whether the LAG supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
        pub fn has_logical_redundancy(mut self, input: crate::model::HasLogicalRedundancy) -> Self {
            self.has_logical_redundancy = Some(input);
            self
        }
        /// <p>Indicates whether the LAG supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
        pub fn set_has_logical_redundancy(
            mut self,
            input: std::option::Option<crate::model::HasLogicalRedundancy>,
        ) -> Self {
            self.has_logical_redundancy = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the LAG.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the LAG.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name of the service provider associated with the LAG.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The name of the service provider associated with the LAG.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// <p>Indicates whether the LAG supports MAC Security (MACsec).</p>
        pub fn mac_sec_capable(mut self, input: bool) -> Self {
            self.mac_sec_capable = Some(input);
            self
        }
        /// <p>Indicates whether the LAG supports MAC Security (MACsec).</p>
        pub fn set_mac_sec_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.mac_sec_capable = input;
            self
        }
        /// <p>The LAG MAC Security (MACsec) encryption mode.</p>
        /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
        pub fn encryption_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_mode = Some(input.into());
            self
        }
        /// <p>The LAG MAC Security (MACsec) encryption mode.</p>
        /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_mode = input;
            self
        }
        /// Appends an item to `mac_sec_keys`.
        ///
        /// To override the contents of this collection use [`set_mac_sec_keys`](Self::set_mac_sec_keys).
        ///
        /// <p>The MAC Security (MACsec) security keys associated with the LAG.</p>
        pub fn mac_sec_keys(mut self, input: impl Into<crate::model::MacSecKey>) -> Self {
            let mut v = self.mac_sec_keys.unwrap_or_default();
            v.push(input.into());
            self.mac_sec_keys = Some(v);
            self
        }
        /// <p>The MAC Security (MACsec) security keys associated with the LAG.</p>
        pub fn set_mac_sec_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
        ) -> Self {
            self.mac_sec_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`Lag`](crate::model::Lag)
        pub fn build(self) -> crate::model::Lag {
            crate::model::Lag {
                connections_bandwidth: self.connections_bandwidth,
                number_of_connections: self.number_of_connections.unwrap_or_default(),
                lag_id: self.lag_id,
                owner_account: self.owner_account,
                lag_name: self.lag_name,
                lag_state: self.lag_state,
                location: self.location,
                region: self.region,
                minimum_links: self.minimum_links.unwrap_or_default(),
                aws_device: self.aws_device,
                aws_device_v2: self.aws_device_v2,
                aws_logical_device_id: self.aws_logical_device_id,
                connections: self.connections,
                allows_hosted_connections: self.allows_hosted_connections.unwrap_or_default(),
                jumbo_frame_capable: self.jumbo_frame_capable,
                has_logical_redundancy: self.has_logical_redundancy,
                tags: self.tags,
                provider_name: self.provider_name,
                mac_sec_capable: self.mac_sec_capable,
                encryption_mode: self.encryption_mode,
                mac_sec_keys: self.mac_sec_keys,
            }
        }
    }
}
impl Lag {
    /// Creates a new builder-style object to manufacture [`Lag`](crate::model::Lag)
    pub fn builder() -> crate::model::lag::Builder {
        crate::model::lag::Builder::default()
    }
}

/// <p>Information about an interconnect.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Interconnect {
    /// <p>The ID of the interconnect.</p>
    pub interconnect_id: std::option::Option<std::string::String>,
    /// <p>The name of the interconnect.</p>
    pub interconnect_name: std::option::Option<std::string::String>,
    /// <p>The state of the interconnect. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>requested</code>: The initial state of an interconnect. The interconnect stays in the
    /// requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: The interconnect is approved, and is being initialized.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: The network link is up, and the interconnect is ready for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: The network link is down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: The interconnect is being deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: The interconnect is deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The state of the interconnect is not available.</p>
    /// </li>
    /// </ul>
    pub interconnect_state: std::option::Option<crate::model::InterconnectState>,
    /// <p>The Amazon Web Services Region where the connection is located.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The location of the connection.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The bandwidth of the connection.</p>
    pub bandwidth: std::option::Option<std::string::String>,
    /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
    pub loa_issue_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The ID of the LAG.</p>
    pub lag_id: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
    pub aws_device: std::option::Option<std::string::String>,
    /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    pub jumbo_frame_capable: std::option::Option<bool>,
    /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
    pub aws_device_v2: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
    /// different than the device that terminates the physical connection.</p>
    pub aws_logical_device_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether the interconnect supports a secondary BGP in the same address family (IPv4/IPv6).</p>
    pub has_logical_redundancy: std::option::Option<crate::model::HasLogicalRedundancy>,
    /// <p>The tags associated with the interconnect.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The name of the service provider associated with the interconnect.</p>
    pub provider_name: std::option::Option<std::string::String>,
}
impl Interconnect {
    /// <p>The ID of the interconnect.</p>
    pub fn interconnect_id(&self) -> std::option::Option<&str> {
        self.interconnect_id.as_deref()
    }
    /// <p>The name of the interconnect.</p>
    pub fn interconnect_name(&self) -> std::option::Option<&str> {
        self.interconnect_name.as_deref()
    }
    /// <p>The state of the interconnect. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>requested</code>: The initial state of an interconnect. The interconnect stays in the
    /// requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: The interconnect is approved, and is being initialized.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: The network link is up, and the interconnect is ready for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: The network link is down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: The interconnect is being deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: The interconnect is deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The state of the interconnect is not available.</p>
    /// </li>
    /// </ul>
    pub fn interconnect_state(&self) -> std::option::Option<&crate::model::InterconnectState> {
        self.interconnect_state.as_ref()
    }
    /// <p>The Amazon Web Services Region where the connection is located.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>The location of the connection.</p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
    /// <p>The bandwidth of the connection.</p>
    pub fn bandwidth(&self) -> std::option::Option<&str> {
        self.bandwidth.as_deref()
    }
    /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
    pub fn loa_issue_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.loa_issue_time.as_ref()
    }
    /// <p>The ID of the LAG.</p>
    pub fn lag_id(&self) -> std::option::Option<&str> {
        self.lag_id.as_deref()
    }
    /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
    pub fn aws_device(&self) -> std::option::Option<&str> {
        self.aws_device.as_deref()
    }
    /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    pub fn jumbo_frame_capable(&self) -> std::option::Option<bool> {
        self.jumbo_frame_capable
    }
    /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
    pub fn aws_device_v2(&self) -> std::option::Option<&str> {
        self.aws_device_v2.as_deref()
    }
    /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
    /// different than the device that terminates the physical connection.</p>
    pub fn aws_logical_device_id(&self) -> std::option::Option<&str> {
        self.aws_logical_device_id.as_deref()
    }
    /// <p>Indicates whether the interconnect supports a secondary BGP in the same address family (IPv4/IPv6).</p>
    pub fn has_logical_redundancy(
        &self,
    ) -> std::option::Option<&crate::model::HasLogicalRedundancy> {
        self.has_logical_redundancy.as_ref()
    }
    /// <p>The tags associated with the interconnect.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The name of the service provider associated with the interconnect.</p>
    pub fn provider_name(&self) -> std::option::Option<&str> {
        self.provider_name.as_deref()
    }
}
impl std::fmt::Debug for Interconnect {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Interconnect");
        formatter.field("interconnect_id", &self.interconnect_id);
        formatter.field("interconnect_name", &self.interconnect_name);
        formatter.field("interconnect_state", &self.interconnect_state);
        formatter.field("region", &self.region);
        formatter.field("location", &self.location);
        formatter.field("bandwidth", &self.bandwidth);
        formatter.field("loa_issue_time", &self.loa_issue_time);
        formatter.field("lag_id", &self.lag_id);
        formatter.field("aws_device", &self.aws_device);
        formatter.field("jumbo_frame_capable", &self.jumbo_frame_capable);
        formatter.field("aws_device_v2", &self.aws_device_v2);
        formatter.field("aws_logical_device_id", &self.aws_logical_device_id);
        formatter.field("has_logical_redundancy", &self.has_logical_redundancy);
        formatter.field("tags", &self.tags);
        formatter.field("provider_name", &self.provider_name);
        formatter.finish()
    }
}
/// See [`Interconnect`](crate::model::Interconnect)
pub mod interconnect {
    /// A builder for [`Interconnect`](crate::model::Interconnect)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) interconnect_id: std::option::Option<std::string::String>,
        pub(crate) interconnect_name: std::option::Option<std::string::String>,
        pub(crate) interconnect_state: std::option::Option<crate::model::InterconnectState>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) bandwidth: std::option::Option<std::string::String>,
        pub(crate) loa_issue_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) lag_id: std::option::Option<std::string::String>,
        pub(crate) aws_device: std::option::Option<std::string::String>,
        pub(crate) jumbo_frame_capable: std::option::Option<bool>,
        pub(crate) aws_device_v2: std::option::Option<std::string::String>,
        pub(crate) aws_logical_device_id: std::option::Option<std::string::String>,
        pub(crate) has_logical_redundancy: std::option::Option<crate::model::HasLogicalRedundancy>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) provider_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the interconnect.</p>
        pub fn interconnect_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.interconnect_id = Some(input.into());
            self
        }
        /// <p>The ID of the interconnect.</p>
        pub fn set_interconnect_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.interconnect_id = input;
            self
        }
        /// <p>The name of the interconnect.</p>
        pub fn interconnect_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.interconnect_name = Some(input.into());
            self
        }
        /// <p>The name of the interconnect.</p>
        pub fn set_interconnect_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.interconnect_name = input;
            self
        }
        /// <p>The state of the interconnect. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of an interconnect. The interconnect stays in the
        /// requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The interconnect is approved, and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is up, and the interconnect is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The interconnect is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The interconnect is deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the interconnect is not available.</p>
        /// </li>
        /// </ul>
        pub fn interconnect_state(mut self, input: crate::model::InterconnectState) -> Self {
            self.interconnect_state = Some(input);
            self
        }
        /// <p>The state of the interconnect. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of an interconnect. The interconnect stays in the
        /// requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The interconnect is approved, and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is up, and the interconnect is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The interconnect is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The interconnect is deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the interconnect is not available.</p>
        /// </li>
        /// </ul>
        pub fn set_interconnect_state(
            mut self,
            input: std::option::Option<crate::model::InterconnectState>,
        ) -> Self {
            self.interconnect_state = input;
            self
        }
        /// <p>The Amazon Web Services Region where the connection is located.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region where the connection is located.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The location of the connection.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The location of the connection.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The bandwidth of the connection.</p>
        pub fn bandwidth(mut self, input: impl Into<std::string::String>) -> Self {
            self.bandwidth = Some(input.into());
            self
        }
        /// <p>The bandwidth of the connection.</p>
        pub fn set_bandwidth(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bandwidth = input;
            self
        }
        /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
        pub fn loa_issue_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.loa_issue_time = Some(input);
            self
        }
        /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
        pub fn set_loa_issue_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.loa_issue_time = input;
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.lag_id = Some(input.into());
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lag_id = input;
            self
        }
        /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
        pub fn aws_device(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
        pub fn set_aws_device(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_device = input;
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn jumbo_frame_capable(mut self, input: bool) -> Self {
            self.jumbo_frame_capable = Some(input);
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn set_jumbo_frame_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.jumbo_frame_capable = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn aws_device_v2(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device_v2 = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn set_aws_device_v2(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_device_v2 = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn aws_logical_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_logical_device_id = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn set_aws_logical_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_logical_device_id = input;
            self
        }
        /// <p>Indicates whether the interconnect supports a secondary BGP in the same address family (IPv4/IPv6).</p>
        pub fn has_logical_redundancy(mut self, input: crate::model::HasLogicalRedundancy) -> Self {
            self.has_logical_redundancy = Some(input);
            self
        }
        /// <p>Indicates whether the interconnect supports a secondary BGP in the same address family (IPv4/IPv6).</p>
        pub fn set_has_logical_redundancy(
            mut self,
            input: std::option::Option<crate::model::HasLogicalRedundancy>,
        ) -> Self {
            self.has_logical_redundancy = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the interconnect.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the interconnect.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name of the service provider associated with the interconnect.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The name of the service provider associated with the interconnect.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// Consumes the builder and constructs a [`Interconnect`](crate::model::Interconnect)
        pub fn build(self) -> crate::model::Interconnect {
            crate::model::Interconnect {
                interconnect_id: self.interconnect_id,
                interconnect_name: self.interconnect_name,
                interconnect_state: self.interconnect_state,
                region: self.region,
                location: self.location,
                bandwidth: self.bandwidth,
                loa_issue_time: self.loa_issue_time,
                lag_id: self.lag_id,
                aws_device: self.aws_device,
                jumbo_frame_capable: self.jumbo_frame_capable,
                aws_device_v2: self.aws_device_v2,
                aws_logical_device_id: self.aws_logical_device_id,
                has_logical_redundancy: self.has_logical_redundancy,
                tags: self.tags,
                provider_name: self.provider_name,
            }
        }
    }
}
impl Interconnect {
    /// Creates a new builder-style object to manufacture [`Interconnect`](crate::model::Interconnect)
    pub fn builder() -> crate::model::interconnect::Builder {
        crate::model::interconnect::Builder::default()
    }
}

/// _Note: `InterconnectState::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InterconnectState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Down,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Requested,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InterconnectState {
    fn from(s: &str) -> Self {
        match s {
            "available" => InterconnectState::Available,
            "deleted" => InterconnectState::Deleted,
            "deleting" => InterconnectState::Deleting,
            "down" => InterconnectState::Down,
            "pending" => InterconnectState::Pending,
            "requested" => InterconnectState::Requested,
            "unknown" => InterconnectState::UnknownValue,
            other => InterconnectState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InterconnectState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InterconnectState::from(s))
    }
}
impl InterconnectState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InterconnectState::Available => "available",
            InterconnectState::Deleted => "deleted",
            InterconnectState::Deleting => "deleting",
            InterconnectState::Down => "down",
            InterconnectState::Pending => "pending",
            InterconnectState::Requested => "requested",
            InterconnectState::UnknownValue => "unknown",
            InterconnectState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "available",
            "deleted",
            "deleting",
            "down",
            "pending",
            "requested",
            "unknown",
        ]
    }
}
impl AsRef<str> for InterconnectState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a Letter of Authorization - Connecting Facility Assignment (LOA-CFA) for a connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Loa {
    /// <p>The binary contents of the LOA-CFA document.</p>
    pub loa_content: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The standard media type for the LOA-CFA document. The only supported value is application/pdf.</p>
    pub loa_content_type: std::option::Option<crate::model::LoaContentType>,
}
impl Loa {
    /// <p>The binary contents of the LOA-CFA document.</p>
    pub fn loa_content(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.loa_content.as_ref()
    }
    /// <p>The standard media type for the LOA-CFA document. The only supported value is application/pdf.</p>
    pub fn loa_content_type(&self) -> std::option::Option<&crate::model::LoaContentType> {
        self.loa_content_type.as_ref()
    }
}
impl std::fmt::Debug for Loa {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Loa");
        formatter.field("loa_content", &self.loa_content);
        formatter.field("loa_content_type", &self.loa_content_type);
        formatter.finish()
    }
}
/// See [`Loa`](crate::model::Loa)
pub mod loa {
    /// A builder for [`Loa`](crate::model::Loa)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) loa_content: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) loa_content_type: std::option::Option<crate::model::LoaContentType>,
    }
    impl Builder {
        /// <p>The binary contents of the LOA-CFA document.</p>
        pub fn loa_content(mut self, input: aws_smithy_types::Blob) -> Self {
            self.loa_content = Some(input);
            self
        }
        /// <p>The binary contents of the LOA-CFA document.</p>
        pub fn set_loa_content(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.loa_content = input;
            self
        }
        /// <p>The standard media type for the LOA-CFA document. The only supported value is application/pdf.</p>
        pub fn loa_content_type(mut self, input: crate::model::LoaContentType) -> Self {
            self.loa_content_type = Some(input);
            self
        }
        /// <p>The standard media type for the LOA-CFA document. The only supported value is application/pdf.</p>
        pub fn set_loa_content_type(
            mut self,
            input: std::option::Option<crate::model::LoaContentType>,
        ) -> Self {
            self.loa_content_type = input;
            self
        }
        /// Consumes the builder and constructs a [`Loa`](crate::model::Loa)
        pub fn build(self) -> crate::model::Loa {
            crate::model::Loa {
                loa_content: self.loa_content,
                loa_content_type: self.loa_content_type,
            }
        }
    }
}
impl Loa {
    /// Creates a new builder-style object to manufacture [`Loa`](crate::model::Loa)
    pub fn builder() -> crate::model::loa::Builder {
        crate::model::loa::Builder::default()
    }
}

/// <p>Information about an attachment between a Direct Connect gateway and a virtual interface.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DirectConnectGatewayAttachment {
    /// <p>The ID of the Direct Connect gateway.</p>
    pub direct_connect_gateway_id: std::option::Option<std::string::String>,
    /// <p>The ID of the virtual interface.</p>
    pub virtual_interface_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region where the virtual interface is located.</p>
    pub virtual_interface_region: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Web Services account that owns the virtual interface.</p>
    pub virtual_interface_owner_account: std::option::Option<std::string::String>,
    /// <p>The state of the attachment. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>attaching</code>: The initial state after a virtual interface is created using the Direct Connect gateway.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>attached</code>: The Direct Connect gateway and virtual interface are attached and ready to pass traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>detaching</code>: The initial state after calling <a>DeleteVirtualInterface</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>detached</code>: The virtual interface is detached from the Direct Connect gateway. Traffic flow between the Direct Connect gateway and virtual interface is stopped.</p>
    /// </li>
    /// </ul>
    pub attachment_state: std::option::Option<crate::model::DirectConnectGatewayAttachmentState>,
    /// <p>The type of attachment.</p>
    pub attachment_type: std::option::Option<crate::model::DirectConnectGatewayAttachmentType>,
    /// <p>The error message if the state of an object failed to advance.</p>
    pub state_change_error: std::option::Option<std::string::String>,
}
impl DirectConnectGatewayAttachment {
    /// <p>The ID of the Direct Connect gateway.</p>
    pub fn direct_connect_gateway_id(&self) -> std::option::Option<&str> {
        self.direct_connect_gateway_id.as_deref()
    }
    /// <p>The ID of the virtual interface.</p>
    pub fn virtual_interface_id(&self) -> std::option::Option<&str> {
        self.virtual_interface_id.as_deref()
    }
    /// <p>The Amazon Web Services Region where the virtual interface is located.</p>
    pub fn virtual_interface_region(&self) -> std::option::Option<&str> {
        self.virtual_interface_region.as_deref()
    }
    /// <p>The ID of the Amazon Web Services account that owns the virtual interface.</p>
    pub fn virtual_interface_owner_account(&self) -> std::option::Option<&str> {
        self.virtual_interface_owner_account.as_deref()
    }
    /// <p>The state of the attachment. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>attaching</code>: The initial state after a virtual interface is created using the Direct Connect gateway.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>attached</code>: The Direct Connect gateway and virtual interface are attached and ready to pass traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>detaching</code>: The initial state after calling <a>DeleteVirtualInterface</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>detached</code>: The virtual interface is detached from the Direct Connect gateway. Traffic flow between the Direct Connect gateway and virtual interface is stopped.</p>
    /// </li>
    /// </ul>
    pub fn attachment_state(
        &self,
    ) -> std::option::Option<&crate::model::DirectConnectGatewayAttachmentState> {
        self.attachment_state.as_ref()
    }
    /// <p>The type of attachment.</p>
    pub fn attachment_type(
        &self,
    ) -> std::option::Option<&crate::model::DirectConnectGatewayAttachmentType> {
        self.attachment_type.as_ref()
    }
    /// <p>The error message if the state of an object failed to advance.</p>
    pub fn state_change_error(&self) -> std::option::Option<&str> {
        self.state_change_error.as_deref()
    }
}
impl std::fmt::Debug for DirectConnectGatewayAttachment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DirectConnectGatewayAttachment");
        formatter.field("direct_connect_gateway_id", &self.direct_connect_gateway_id);
        formatter.field("virtual_interface_id", &self.virtual_interface_id);
        formatter.field("virtual_interface_region", &self.virtual_interface_region);
        formatter.field(
            "virtual_interface_owner_account",
            &self.virtual_interface_owner_account,
        );
        formatter.field("attachment_state", &self.attachment_state);
        formatter.field("attachment_type", &self.attachment_type);
        formatter.field("state_change_error", &self.state_change_error);
        formatter.finish()
    }
}
/// See [`DirectConnectGatewayAttachment`](crate::model::DirectConnectGatewayAttachment)
pub mod direct_connect_gateway_attachment {
    /// A builder for [`DirectConnectGatewayAttachment`](crate::model::DirectConnectGatewayAttachment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) direct_connect_gateway_id: std::option::Option<std::string::String>,
        pub(crate) virtual_interface_id: std::option::Option<std::string::String>,
        pub(crate) virtual_interface_region: std::option::Option<std::string::String>,
        pub(crate) virtual_interface_owner_account: std::option::Option<std::string::String>,
        pub(crate) attachment_state:
            std::option::Option<crate::model::DirectConnectGatewayAttachmentState>,
        pub(crate) attachment_type:
            std::option::Option<crate::model::DirectConnectGatewayAttachmentType>,
        pub(crate) state_change_error: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.direct_connect_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_id = input;
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_id = input;
            self
        }
        /// <p>The Amazon Web Services Region where the virtual interface is located.</p>
        pub fn virtual_interface_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region where the virtual interface is located.</p>
        pub fn set_virtual_interface_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_region = input;
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the virtual interface.</p>
        pub fn virtual_interface_owner_account(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.virtual_interface_owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the virtual interface.</p>
        pub fn set_virtual_interface_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_owner_account = input;
            self
        }
        /// <p>The state of the attachment. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>attaching</code>: The initial state after a virtual interface is created using the Direct Connect gateway.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>attached</code>: The Direct Connect gateway and virtual interface are attached and ready to pass traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>detaching</code>: The initial state after calling <a>DeleteVirtualInterface</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>detached</code>: The virtual interface is detached from the Direct Connect gateway. Traffic flow between the Direct Connect gateway and virtual interface is stopped.</p>
        /// </li>
        /// </ul>
        pub fn attachment_state(
            mut self,
            input: crate::model::DirectConnectGatewayAttachmentState,
        ) -> Self {
            self.attachment_state = Some(input);
            self
        }
        /// <p>The state of the attachment. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>attaching</code>: The initial state after a virtual interface is created using the Direct Connect gateway.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>attached</code>: The Direct Connect gateway and virtual interface are attached and ready to pass traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>detaching</code>: The initial state after calling <a>DeleteVirtualInterface</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>detached</code>: The virtual interface is detached from the Direct Connect gateway. Traffic flow between the Direct Connect gateway and virtual interface is stopped.</p>
        /// </li>
        /// </ul>
        pub fn set_attachment_state(
            mut self,
            input: std::option::Option<crate::model::DirectConnectGatewayAttachmentState>,
        ) -> Self {
            self.attachment_state = input;
            self
        }
        /// <p>The type of attachment.</p>
        pub fn attachment_type(
            mut self,
            input: crate::model::DirectConnectGatewayAttachmentType,
        ) -> Self {
            self.attachment_type = Some(input);
            self
        }
        /// <p>The type of attachment.</p>
        pub fn set_attachment_type(
            mut self,
            input: std::option::Option<crate::model::DirectConnectGatewayAttachmentType>,
        ) -> Self {
            self.attachment_type = input;
            self
        }
        /// <p>The error message if the state of an object failed to advance.</p>
        pub fn state_change_error(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_change_error = Some(input.into());
            self
        }
        /// <p>The error message if the state of an object failed to advance.</p>
        pub fn set_state_change_error(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_change_error = input;
            self
        }
        /// Consumes the builder and constructs a [`DirectConnectGatewayAttachment`](crate::model::DirectConnectGatewayAttachment)
        pub fn build(self) -> crate::model::DirectConnectGatewayAttachment {
            crate::model::DirectConnectGatewayAttachment {
                direct_connect_gateway_id: self.direct_connect_gateway_id,
                virtual_interface_id: self.virtual_interface_id,
                virtual_interface_region: self.virtual_interface_region,
                virtual_interface_owner_account: self.virtual_interface_owner_account,
                attachment_state: self.attachment_state,
                attachment_type: self.attachment_type,
                state_change_error: self.state_change_error,
            }
        }
    }
}
impl DirectConnectGatewayAttachment {
    /// Creates a new builder-style object to manufacture [`DirectConnectGatewayAttachment`](crate::model::DirectConnectGatewayAttachment)
    pub fn builder() -> crate::model::direct_connect_gateway_attachment::Builder {
        crate::model::direct_connect_gateway_attachment::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DirectConnectGatewayAttachmentType {
    #[allow(missing_docs)] // documentation missing in model
    PrivateVirtualInterface,
    #[allow(missing_docs)] // documentation missing in model
    TransitVirtualInterface,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DirectConnectGatewayAttachmentType {
    fn from(s: &str) -> Self {
        match s {
            "PrivateVirtualInterface" => {
                DirectConnectGatewayAttachmentType::PrivateVirtualInterface
            }
            "TransitVirtualInterface" => {
                DirectConnectGatewayAttachmentType::TransitVirtualInterface
            }
            other => DirectConnectGatewayAttachmentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DirectConnectGatewayAttachmentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DirectConnectGatewayAttachmentType::from(s))
    }
}
impl DirectConnectGatewayAttachmentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DirectConnectGatewayAttachmentType::PrivateVirtualInterface => {
                "PrivateVirtualInterface"
            }
            DirectConnectGatewayAttachmentType::TransitVirtualInterface => {
                "TransitVirtualInterface"
            }
            DirectConnectGatewayAttachmentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PrivateVirtualInterface", "TransitVirtualInterface"]
    }
}
impl AsRef<str> for DirectConnectGatewayAttachmentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DirectConnectGatewayAttachmentState {
    #[allow(missing_docs)] // documentation missing in model
    Attached,
    #[allow(missing_docs)] // documentation missing in model
    Attaching,
    #[allow(missing_docs)] // documentation missing in model
    Detached,
    #[allow(missing_docs)] // documentation missing in model
    Detaching,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DirectConnectGatewayAttachmentState {
    fn from(s: &str) -> Self {
        match s {
            "attached" => DirectConnectGatewayAttachmentState::Attached,
            "attaching" => DirectConnectGatewayAttachmentState::Attaching,
            "detached" => DirectConnectGatewayAttachmentState::Detached,
            "detaching" => DirectConnectGatewayAttachmentState::Detaching,
            other => DirectConnectGatewayAttachmentState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DirectConnectGatewayAttachmentState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DirectConnectGatewayAttachmentState::from(s))
    }
}
impl DirectConnectGatewayAttachmentState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DirectConnectGatewayAttachmentState::Attached => "attached",
            DirectConnectGatewayAttachmentState::Attaching => "attaching",
            DirectConnectGatewayAttachmentState::Detached => "detached",
            DirectConnectGatewayAttachmentState::Detaching => "detaching",
            DirectConnectGatewayAttachmentState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["attached", "attaching", "detached", "detaching"]
    }
}
impl AsRef<str> for DirectConnectGatewayAttachmentState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the  proposal request to attach a virtual private gateway to a Direct Connect gateway. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DirectConnectGatewayAssociationProposal {
    /// <p>The ID of the association proposal.</p>
    pub proposal_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Direct Connect gateway.</p>
    pub direct_connect_gateway_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Web Services account that owns the Direct Connect gateway.</p>
    pub direct_connect_gateway_owner_account: std::option::Option<std::string::String>,
    /// <p>The state of the proposal. The following are possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>accepted</code>: The proposal has been accepted. The Direct Connect gateway association is available to use in this state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: The proposal has been deleted by the owner that made the proposal.  The Direct Connect gateway association cannot be used in this state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>requested</code>: The proposal has been requested. The Direct Connect gateway association cannot be used in this state.</p>
    /// </li>
    /// </ul>
    pub proposal_state:
        std::option::Option<crate::model::DirectConnectGatewayAssociationProposalState>,
    /// <p>Information about the associated gateway.</p>
    pub associated_gateway: std::option::Option<crate::model::AssociatedGateway>,
    /// <p>The existing Amazon VPC prefixes advertised to the Direct Connect gateway.</p>
    pub existing_allowed_prefixes_to_direct_connect_gateway:
        std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
    /// <p>The Amazon VPC prefixes to advertise to the Direct Connect gateway.</p>
    pub requested_allowed_prefixes_to_direct_connect_gateway:
        std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
}
impl DirectConnectGatewayAssociationProposal {
    /// <p>The ID of the association proposal.</p>
    pub fn proposal_id(&self) -> std::option::Option<&str> {
        self.proposal_id.as_deref()
    }
    /// <p>The ID of the Direct Connect gateway.</p>
    pub fn direct_connect_gateway_id(&self) -> std::option::Option<&str> {
        self.direct_connect_gateway_id.as_deref()
    }
    /// <p>The ID of the Amazon Web Services account that owns the Direct Connect gateway.</p>
    pub fn direct_connect_gateway_owner_account(&self) -> std::option::Option<&str> {
        self.direct_connect_gateway_owner_account.as_deref()
    }
    /// <p>The state of the proposal. The following are possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>accepted</code>: The proposal has been accepted. The Direct Connect gateway association is available to use in this state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: The proposal has been deleted by the owner that made the proposal.  The Direct Connect gateway association cannot be used in this state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>requested</code>: The proposal has been requested. The Direct Connect gateway association cannot be used in this state.</p>
    /// </li>
    /// </ul>
    pub fn proposal_state(
        &self,
    ) -> std::option::Option<&crate::model::DirectConnectGatewayAssociationProposalState> {
        self.proposal_state.as_ref()
    }
    /// <p>Information about the associated gateway.</p>
    pub fn associated_gateway(&self) -> std::option::Option<&crate::model::AssociatedGateway> {
        self.associated_gateway.as_ref()
    }
    /// <p>The existing Amazon VPC prefixes advertised to the Direct Connect gateway.</p>
    pub fn existing_allowed_prefixes_to_direct_connect_gateway(
        &self,
    ) -> std::option::Option<&[crate::model::RouteFilterPrefix]> {
        self.existing_allowed_prefixes_to_direct_connect_gateway
            .as_deref()
    }
    /// <p>The Amazon VPC prefixes to advertise to the Direct Connect gateway.</p>
    pub fn requested_allowed_prefixes_to_direct_connect_gateway(
        &self,
    ) -> std::option::Option<&[crate::model::RouteFilterPrefix]> {
        self.requested_allowed_prefixes_to_direct_connect_gateway
            .as_deref()
    }
}
impl std::fmt::Debug for DirectConnectGatewayAssociationProposal {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DirectConnectGatewayAssociationProposal");
        formatter.field("proposal_id", &self.proposal_id);
        formatter.field("direct_connect_gateway_id", &self.direct_connect_gateway_id);
        formatter.field(
            "direct_connect_gateway_owner_account",
            &self.direct_connect_gateway_owner_account,
        );
        formatter.field("proposal_state", &self.proposal_state);
        formatter.field("associated_gateway", &self.associated_gateway);
        formatter.field(
            "existing_allowed_prefixes_to_direct_connect_gateway",
            &self.existing_allowed_prefixes_to_direct_connect_gateway,
        );
        formatter.field(
            "requested_allowed_prefixes_to_direct_connect_gateway",
            &self.requested_allowed_prefixes_to_direct_connect_gateway,
        );
        formatter.finish()
    }
}
/// See [`DirectConnectGatewayAssociationProposal`](crate::model::DirectConnectGatewayAssociationProposal)
pub mod direct_connect_gateway_association_proposal {
    /// A builder for [`DirectConnectGatewayAssociationProposal`](crate::model::DirectConnectGatewayAssociationProposal)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) proposal_id: std::option::Option<std::string::String>,
        pub(crate) direct_connect_gateway_id: std::option::Option<std::string::String>,
        pub(crate) direct_connect_gateway_owner_account: std::option::Option<std::string::String>,
        pub(crate) proposal_state:
            std::option::Option<crate::model::DirectConnectGatewayAssociationProposalState>,
        pub(crate) associated_gateway: std::option::Option<crate::model::AssociatedGateway>,
        pub(crate) existing_allowed_prefixes_to_direct_connect_gateway:
            std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        pub(crate) requested_allowed_prefixes_to_direct_connect_gateway:
            std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
    }
    impl Builder {
        /// <p>The ID of the association proposal.</p>
        pub fn proposal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.proposal_id = Some(input.into());
            self
        }
        /// <p>The ID of the association proposal.</p>
        pub fn set_proposal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.proposal_id = input;
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.direct_connect_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_id = input;
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_owner_account(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_owner_account = input;
            self
        }
        /// <p>The state of the proposal. The following are possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>accepted</code>: The proposal has been accepted. The Direct Connect gateway association is available to use in this state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The proposal has been deleted by the owner that made the proposal.  The Direct Connect gateway association cannot be used in this state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>requested</code>: The proposal has been requested. The Direct Connect gateway association cannot be used in this state.</p>
        /// </li>
        /// </ul>
        pub fn proposal_state(
            mut self,
            input: crate::model::DirectConnectGatewayAssociationProposalState,
        ) -> Self {
            self.proposal_state = Some(input);
            self
        }
        /// <p>The state of the proposal. The following are possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>accepted</code>: The proposal has been accepted. The Direct Connect gateway association is available to use in this state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The proposal has been deleted by the owner that made the proposal.  The Direct Connect gateway association cannot be used in this state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>requested</code>: The proposal has been requested. The Direct Connect gateway association cannot be used in this state.</p>
        /// </li>
        /// </ul>
        pub fn set_proposal_state(
            mut self,
            input: std::option::Option<crate::model::DirectConnectGatewayAssociationProposalState>,
        ) -> Self {
            self.proposal_state = input;
            self
        }
        /// <p>Information about the associated gateway.</p>
        pub fn associated_gateway(mut self, input: crate::model::AssociatedGateway) -> Self {
            self.associated_gateway = Some(input);
            self
        }
        /// <p>Information about the associated gateway.</p>
        pub fn set_associated_gateway(
            mut self,
            input: std::option::Option<crate::model::AssociatedGateway>,
        ) -> Self {
            self.associated_gateway = input;
            self
        }
        /// Appends an item to `existing_allowed_prefixes_to_direct_connect_gateway`.
        ///
        /// To override the contents of this collection use [`set_existing_allowed_prefixes_to_direct_connect_gateway`](Self::set_existing_allowed_prefixes_to_direct_connect_gateway).
        ///
        /// <p>The existing Amazon VPC prefixes advertised to the Direct Connect gateway.</p>
        pub fn existing_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: impl Into<crate::model::RouteFilterPrefix>,
        ) -> Self {
            let mut v = self
                .existing_allowed_prefixes_to_direct_connect_gateway
                .unwrap_or_default();
            v.push(input.into());
            self.existing_allowed_prefixes_to_direct_connect_gateway = Some(v);
            self
        }
        /// <p>The existing Amazon VPC prefixes advertised to the Direct Connect gateway.</p>
        pub fn set_existing_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        ) -> Self {
            self.existing_allowed_prefixes_to_direct_connect_gateway = input;
            self
        }
        /// Appends an item to `requested_allowed_prefixes_to_direct_connect_gateway`.
        ///
        /// To override the contents of this collection use [`set_requested_allowed_prefixes_to_direct_connect_gateway`](Self::set_requested_allowed_prefixes_to_direct_connect_gateway).
        ///
        /// <p>The Amazon VPC prefixes to advertise to the Direct Connect gateway.</p>
        pub fn requested_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: impl Into<crate::model::RouteFilterPrefix>,
        ) -> Self {
            let mut v = self
                .requested_allowed_prefixes_to_direct_connect_gateway
                .unwrap_or_default();
            v.push(input.into());
            self.requested_allowed_prefixes_to_direct_connect_gateway = Some(v);
            self
        }
        /// <p>The Amazon VPC prefixes to advertise to the Direct Connect gateway.</p>
        pub fn set_requested_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        ) -> Self {
            self.requested_allowed_prefixes_to_direct_connect_gateway = input;
            self
        }
        /// Consumes the builder and constructs a [`DirectConnectGatewayAssociationProposal`](crate::model::DirectConnectGatewayAssociationProposal)
        pub fn build(self) -> crate::model::DirectConnectGatewayAssociationProposal {
            crate::model::DirectConnectGatewayAssociationProposal {
                proposal_id: self.proposal_id,
                direct_connect_gateway_id: self.direct_connect_gateway_id,
                direct_connect_gateway_owner_account: self.direct_connect_gateway_owner_account,
                proposal_state: self.proposal_state,
                associated_gateway: self.associated_gateway,
                existing_allowed_prefixes_to_direct_connect_gateway: self
                    .existing_allowed_prefixes_to_direct_connect_gateway,
                requested_allowed_prefixes_to_direct_connect_gateway: self
                    .requested_allowed_prefixes_to_direct_connect_gateway,
            }
        }
    }
}
impl DirectConnectGatewayAssociationProposal {
    /// Creates a new builder-style object to manufacture [`DirectConnectGatewayAssociationProposal`](crate::model::DirectConnectGatewayAssociationProposal)
    pub fn builder() -> crate::model::direct_connect_gateway_association_proposal::Builder {
        crate::model::direct_connect_gateway_association_proposal::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DirectConnectGatewayAssociationProposalState {
    #[allow(missing_docs)] // documentation missing in model
    Accepted,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Requested,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DirectConnectGatewayAssociationProposalState {
    fn from(s: &str) -> Self {
        match s {
            "accepted" => DirectConnectGatewayAssociationProposalState::Accepted,
            "deleted" => DirectConnectGatewayAssociationProposalState::Deleted,
            "requested" => DirectConnectGatewayAssociationProposalState::Requested,
            other => DirectConnectGatewayAssociationProposalState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DirectConnectGatewayAssociationProposalState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DirectConnectGatewayAssociationProposalState::from(s))
    }
}
impl DirectConnectGatewayAssociationProposalState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DirectConnectGatewayAssociationProposalState::Accepted => "accepted",
            DirectConnectGatewayAssociationProposalState::Deleted => "deleted",
            DirectConnectGatewayAssociationProposalState::Requested => "requested",
            DirectConnectGatewayAssociationProposalState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["accepted", "deleted", "requested"]
    }
}
impl AsRef<str> for DirectConnectGatewayAssociationProposalState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NniPartnerType {
    #[allow(missing_docs)] // documentation missing in model
    NonPartner,
    #[allow(missing_docs)] // documentation missing in model
    V1,
    #[allow(missing_docs)] // documentation missing in model
    V2,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NniPartnerType {
    fn from(s: &str) -> Self {
        match s {
            "nonPartner" => NniPartnerType::NonPartner,
            "v1" => NniPartnerType::V1,
            "v2" => NniPartnerType::V2,
            other => NniPartnerType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NniPartnerType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NniPartnerType::from(s))
    }
}
impl NniPartnerType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NniPartnerType::NonPartner => "nonPartner",
            NniPartnerType::V1 => "v1",
            NniPartnerType::V2 => "v2",
            NniPartnerType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["nonPartner", "v1", "v2"]
    }
}
impl AsRef<str> for NniPartnerType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The name and status of a customer agreement. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomerAgreement {
    /// <p>The name of the agreement.</p>
    pub agreement_name: std::option::Option<std::string::String>,
    /// <p>The status of the customer agreement. This will be either <code>signed</code> or <code>unsigned</code>
    /// </p>
    pub status: std::option::Option<std::string::String>,
}
impl CustomerAgreement {
    /// <p>The name of the agreement.</p>
    pub fn agreement_name(&self) -> std::option::Option<&str> {
        self.agreement_name.as_deref()
    }
    /// <p>The status of the customer agreement. This will be either <code>signed</code> or <code>unsigned</code>
    /// </p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for CustomerAgreement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomerAgreement");
        formatter.field("agreement_name", &self.agreement_name);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CustomerAgreement`](crate::model::CustomerAgreement)
pub mod customer_agreement {
    /// A builder for [`CustomerAgreement`](crate::model::CustomerAgreement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) agreement_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the agreement.</p>
        pub fn agreement_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.agreement_name = Some(input.into());
            self
        }
        /// <p>The name of the agreement.</p>
        pub fn set_agreement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.agreement_name = input;
            self
        }
        /// <p>The status of the customer agreement. This will be either <code>signed</code> or <code>unsigned</code>
        /// </p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the customer agreement. This will be either <code>signed</code> or <code>unsigned</code>
        /// </p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomerAgreement`](crate::model::CustomerAgreement)
        pub fn build(self) -> crate::model::CustomerAgreement {
            crate::model::CustomerAgreement {
                agreement_name: self.agreement_name,
                status: self.status,
            }
        }
    }
}
impl CustomerAgreement {
    /// Creates a new builder-style object to manufacture [`CustomerAgreement`](crate::model::CustomerAgreement)
    pub fn builder() -> crate::model::customer_agreement::Builder {
        crate::model::customer_agreement::Builder::default()
    }
}

/// <p>Information about a transit virtual interface.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NewTransitVirtualInterface {
    /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
    pub virtual_interface_name: std::option::Option<std::string::String>,
    /// <p>The ID of the VLAN.</p>
    pub vlan: i32,
    /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
    /// <p>The valid values are 1-2147483647.</p>
    pub asn: i32,
    /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
    pub mtu: std::option::Option<i32>,
    /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
    pub auth_key: std::option::Option<std::string::String>,
    /// <p>The IP address assigned to the Amazon interface.</p>
    pub amazon_address: std::option::Option<std::string::String>,
    /// <p>The IP address assigned to the customer interface.</p>
    pub customer_address: std::option::Option<std::string::String>,
    /// <p>The address family for the BGP peer.</p>
    pub address_family: std::option::Option<crate::model::AddressFamily>,
    /// <p>The ID of the Direct Connect gateway.</p>
    pub direct_connect_gateway_id: std::option::Option<std::string::String>,
    /// <p>The tags associated with the transitive virtual interface.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl NewTransitVirtualInterface {
    /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
    pub fn virtual_interface_name(&self) -> std::option::Option<&str> {
        self.virtual_interface_name.as_deref()
    }
    /// <p>The ID of the VLAN.</p>
    pub fn vlan(&self) -> i32 {
        self.vlan
    }
    /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
    /// <p>The valid values are 1-2147483647.</p>
    pub fn asn(&self) -> i32 {
        self.asn
    }
    /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
    pub fn mtu(&self) -> std::option::Option<i32> {
        self.mtu
    }
    /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
    pub fn auth_key(&self) -> std::option::Option<&str> {
        self.auth_key.as_deref()
    }
    /// <p>The IP address assigned to the Amazon interface.</p>
    pub fn amazon_address(&self) -> std::option::Option<&str> {
        self.amazon_address.as_deref()
    }
    /// <p>The IP address assigned to the customer interface.</p>
    pub fn customer_address(&self) -> std::option::Option<&str> {
        self.customer_address.as_deref()
    }
    /// <p>The address family for the BGP peer.</p>
    pub fn address_family(&self) -> std::option::Option<&crate::model::AddressFamily> {
        self.address_family.as_ref()
    }
    /// <p>The ID of the Direct Connect gateway.</p>
    pub fn direct_connect_gateway_id(&self) -> std::option::Option<&str> {
        self.direct_connect_gateway_id.as_deref()
    }
    /// <p>The tags associated with the transitive virtual interface.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for NewTransitVirtualInterface {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NewTransitVirtualInterface");
        formatter.field("virtual_interface_name", &self.virtual_interface_name);
        formatter.field("vlan", &self.vlan);
        formatter.field("asn", &self.asn);
        formatter.field("mtu", &self.mtu);
        formatter.field("auth_key", &self.auth_key);
        formatter.field("amazon_address", &self.amazon_address);
        formatter.field("customer_address", &self.customer_address);
        formatter.field("address_family", &self.address_family);
        formatter.field("direct_connect_gateway_id", &self.direct_connect_gateway_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`NewTransitVirtualInterface`](crate::model::NewTransitVirtualInterface)
pub mod new_transit_virtual_interface {
    /// A builder for [`NewTransitVirtualInterface`](crate::model::NewTransitVirtualInterface)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_interface_name: std::option::Option<std::string::String>,
        pub(crate) vlan: std::option::Option<i32>,
        pub(crate) asn: std::option::Option<i32>,
        pub(crate) mtu: std::option::Option<i32>,
        pub(crate) auth_key: std::option::Option<std::string::String>,
        pub(crate) amazon_address: std::option::Option<std::string::String>,
        pub(crate) customer_address: std::option::Option<std::string::String>,
        pub(crate) address_family: std::option::Option<crate::model::AddressFamily>,
        pub(crate) direct_connect_gateway_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
        pub fn virtual_interface_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
        pub fn set_virtual_interface_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_name = input;
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn vlan(mut self, input: i32) -> Self {
            self.vlan = Some(input);
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn set_vlan(mut self, input: std::option::Option<i32>) -> Self {
            self.vlan = input;
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        /// <p>The valid values are 1-2147483647.</p>
        pub fn asn(mut self, input: i32) -> Self {
            self.asn = Some(input);
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        /// <p>The valid values are 1-2147483647.</p>
        pub fn set_asn(mut self, input: std::option::Option<i32>) -> Self {
            self.asn = input;
            self
        }
        /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
        pub fn mtu(mut self, input: i32) -> Self {
            self.mtu = Some(input);
            self
        }
        /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
        pub fn set_mtu(mut self, input: std::option::Option<i32>) -> Self {
            self.mtu = input;
            self
        }
        /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
        pub fn auth_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.auth_key = Some(input.into());
            self
        }
        /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
        pub fn set_auth_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.auth_key = input;
            self
        }
        /// <p>The IP address assigned to the Amazon interface.</p>
        pub fn amazon_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.amazon_address = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the Amazon interface.</p>
        pub fn set_amazon_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amazon_address = input;
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn customer_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_address = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn set_customer_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_address = input;
            self
        }
        /// <p>The address family for the BGP peer.</p>
        pub fn address_family(mut self, input: crate::model::AddressFamily) -> Self {
            self.address_family = Some(input);
            self
        }
        /// <p>The address family for the BGP peer.</p>
        pub fn set_address_family(
            mut self,
            input: std::option::Option<crate::model::AddressFamily>,
        ) -> Self {
            self.address_family = input;
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.direct_connect_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the transitive virtual interface.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the transitive virtual interface.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`NewTransitVirtualInterface`](crate::model::NewTransitVirtualInterface)
        pub fn build(self) -> crate::model::NewTransitVirtualInterface {
            crate::model::NewTransitVirtualInterface {
                virtual_interface_name: self.virtual_interface_name,
                vlan: self.vlan.unwrap_or_default(),
                asn: self.asn.unwrap_or_default(),
                mtu: self.mtu,
                auth_key: self.auth_key,
                amazon_address: self.amazon_address,
                customer_address: self.customer_address,
                address_family: self.address_family,
                direct_connect_gateway_id: self.direct_connect_gateway_id,
                tags: self.tags,
            }
        }
    }
}
impl NewTransitVirtualInterface {
    /// Creates a new builder-style object to manufacture [`NewTransitVirtualInterface`](crate::model::NewTransitVirtualInterface)
    pub fn builder() -> crate::model::new_transit_virtual_interface::Builder {
        crate::model::new_transit_virtual_interface::Builder::default()
    }
}

/// <p>Information about a public virtual interface.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NewPublicVirtualInterface {
    /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
    pub virtual_interface_name: std::option::Option<std::string::String>,
    /// <p>The ID of the VLAN.</p>
    pub vlan: i32,
    /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
    /// <p>The valid values are 1-2147483647.</p>
    pub asn: i32,
    /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
    pub auth_key: std::option::Option<std::string::String>,
    /// <p>The IP address assigned to the Amazon interface.</p>
    pub amazon_address: std::option::Option<std::string::String>,
    /// <p>The IP address assigned to the customer interface.</p>
    pub customer_address: std::option::Option<std::string::String>,
    /// <p>The address family for the BGP peer.</p>
    pub address_family: std::option::Option<crate::model::AddressFamily>,
    /// <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
    pub route_filter_prefixes: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
    /// <p>The tags associated with the public virtual interface.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl NewPublicVirtualInterface {
    /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
    pub fn virtual_interface_name(&self) -> std::option::Option<&str> {
        self.virtual_interface_name.as_deref()
    }
    /// <p>The ID of the VLAN.</p>
    pub fn vlan(&self) -> i32 {
        self.vlan
    }
    /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
    /// <p>The valid values are 1-2147483647.</p>
    pub fn asn(&self) -> i32 {
        self.asn
    }
    /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
    pub fn auth_key(&self) -> std::option::Option<&str> {
        self.auth_key.as_deref()
    }
    /// <p>The IP address assigned to the Amazon interface.</p>
    pub fn amazon_address(&self) -> std::option::Option<&str> {
        self.amazon_address.as_deref()
    }
    /// <p>The IP address assigned to the customer interface.</p>
    pub fn customer_address(&self) -> std::option::Option<&str> {
        self.customer_address.as_deref()
    }
    /// <p>The address family for the BGP peer.</p>
    pub fn address_family(&self) -> std::option::Option<&crate::model::AddressFamily> {
        self.address_family.as_ref()
    }
    /// <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
    pub fn route_filter_prefixes(&self) -> std::option::Option<&[crate::model::RouteFilterPrefix]> {
        self.route_filter_prefixes.as_deref()
    }
    /// <p>The tags associated with the public virtual interface.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for NewPublicVirtualInterface {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NewPublicVirtualInterface");
        formatter.field("virtual_interface_name", &self.virtual_interface_name);
        formatter.field("vlan", &self.vlan);
        formatter.field("asn", &self.asn);
        formatter.field("auth_key", &self.auth_key);
        formatter.field("amazon_address", &self.amazon_address);
        formatter.field("customer_address", &self.customer_address);
        formatter.field("address_family", &self.address_family);
        formatter.field("route_filter_prefixes", &self.route_filter_prefixes);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`NewPublicVirtualInterface`](crate::model::NewPublicVirtualInterface)
pub mod new_public_virtual_interface {
    /// A builder for [`NewPublicVirtualInterface`](crate::model::NewPublicVirtualInterface)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_interface_name: std::option::Option<std::string::String>,
        pub(crate) vlan: std::option::Option<i32>,
        pub(crate) asn: std::option::Option<i32>,
        pub(crate) auth_key: std::option::Option<std::string::String>,
        pub(crate) amazon_address: std::option::Option<std::string::String>,
        pub(crate) customer_address: std::option::Option<std::string::String>,
        pub(crate) address_family: std::option::Option<crate::model::AddressFamily>,
        pub(crate) route_filter_prefixes:
            std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
        pub fn virtual_interface_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
        pub fn set_virtual_interface_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_name = input;
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn vlan(mut self, input: i32) -> Self {
            self.vlan = Some(input);
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn set_vlan(mut self, input: std::option::Option<i32>) -> Self {
            self.vlan = input;
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        /// <p>The valid values are 1-2147483647.</p>
        pub fn asn(mut self, input: i32) -> Self {
            self.asn = Some(input);
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        /// <p>The valid values are 1-2147483647.</p>
        pub fn set_asn(mut self, input: std::option::Option<i32>) -> Self {
            self.asn = input;
            self
        }
        /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
        pub fn auth_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.auth_key = Some(input.into());
            self
        }
        /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
        pub fn set_auth_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.auth_key = input;
            self
        }
        /// <p>The IP address assigned to the Amazon interface.</p>
        pub fn amazon_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.amazon_address = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the Amazon interface.</p>
        pub fn set_amazon_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amazon_address = input;
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn customer_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_address = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn set_customer_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_address = input;
            self
        }
        /// <p>The address family for the BGP peer.</p>
        pub fn address_family(mut self, input: crate::model::AddressFamily) -> Self {
            self.address_family = Some(input);
            self
        }
        /// <p>The address family for the BGP peer.</p>
        pub fn set_address_family(
            mut self,
            input: std::option::Option<crate::model::AddressFamily>,
        ) -> Self {
            self.address_family = input;
            self
        }
        /// Appends an item to `route_filter_prefixes`.
        ///
        /// To override the contents of this collection use [`set_route_filter_prefixes`](Self::set_route_filter_prefixes).
        ///
        /// <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
        pub fn route_filter_prefixes(
            mut self,
            input: impl Into<crate::model::RouteFilterPrefix>,
        ) -> Self {
            let mut v = self.route_filter_prefixes.unwrap_or_default();
            v.push(input.into());
            self.route_filter_prefixes = Some(v);
            self
        }
        /// <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
        pub fn set_route_filter_prefixes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        ) -> Self {
            self.route_filter_prefixes = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the public virtual interface.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the public virtual interface.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`NewPublicVirtualInterface`](crate::model::NewPublicVirtualInterface)
        pub fn build(self) -> crate::model::NewPublicVirtualInterface {
            crate::model::NewPublicVirtualInterface {
                virtual_interface_name: self.virtual_interface_name,
                vlan: self.vlan.unwrap_or_default(),
                asn: self.asn.unwrap_or_default(),
                auth_key: self.auth_key,
                amazon_address: self.amazon_address,
                customer_address: self.customer_address,
                address_family: self.address_family,
                route_filter_prefixes: self.route_filter_prefixes,
                tags: self.tags,
            }
        }
    }
}
impl NewPublicVirtualInterface {
    /// Creates a new builder-style object to manufacture [`NewPublicVirtualInterface`](crate::model::NewPublicVirtualInterface)
    pub fn builder() -> crate::model::new_public_virtual_interface::Builder {
        crate::model::new_public_virtual_interface::Builder::default()
    }
}

/// <p>Information about a private virtual interface.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NewPrivateVirtualInterface {
    /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
    pub virtual_interface_name: std::option::Option<std::string::String>,
    /// <p>The ID of the VLAN.</p>
    pub vlan: i32,
    /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
    /// <p>The valid values are 1-2147483647.</p>
    pub asn: i32,
    /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
    pub mtu: std::option::Option<i32>,
    /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
    pub auth_key: std::option::Option<std::string::String>,
    /// <p>The IP address assigned to the Amazon interface.</p>
    pub amazon_address: std::option::Option<std::string::String>,
    /// <p>The IP address assigned to the customer interface.</p>
    pub customer_address: std::option::Option<std::string::String>,
    /// <p>The address family for the BGP peer.</p>
    pub address_family: std::option::Option<crate::model::AddressFamily>,
    /// <p>The ID of the virtual private gateway.</p>
    pub virtual_gateway_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Direct Connect gateway.</p>
    pub direct_connect_gateway_id: std::option::Option<std::string::String>,
    /// <p>The tags associated with the private virtual interface.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl NewPrivateVirtualInterface {
    /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
    pub fn virtual_interface_name(&self) -> std::option::Option<&str> {
        self.virtual_interface_name.as_deref()
    }
    /// <p>The ID of the VLAN.</p>
    pub fn vlan(&self) -> i32 {
        self.vlan
    }
    /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
    /// <p>The valid values are 1-2147483647.</p>
    pub fn asn(&self) -> i32 {
        self.asn
    }
    /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
    pub fn mtu(&self) -> std::option::Option<i32> {
        self.mtu
    }
    /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
    pub fn auth_key(&self) -> std::option::Option<&str> {
        self.auth_key.as_deref()
    }
    /// <p>The IP address assigned to the Amazon interface.</p>
    pub fn amazon_address(&self) -> std::option::Option<&str> {
        self.amazon_address.as_deref()
    }
    /// <p>The IP address assigned to the customer interface.</p>
    pub fn customer_address(&self) -> std::option::Option<&str> {
        self.customer_address.as_deref()
    }
    /// <p>The address family for the BGP peer.</p>
    pub fn address_family(&self) -> std::option::Option<&crate::model::AddressFamily> {
        self.address_family.as_ref()
    }
    /// <p>The ID of the virtual private gateway.</p>
    pub fn virtual_gateway_id(&self) -> std::option::Option<&str> {
        self.virtual_gateway_id.as_deref()
    }
    /// <p>The ID of the Direct Connect gateway.</p>
    pub fn direct_connect_gateway_id(&self) -> std::option::Option<&str> {
        self.direct_connect_gateway_id.as_deref()
    }
    /// <p>The tags associated with the private virtual interface.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for NewPrivateVirtualInterface {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NewPrivateVirtualInterface");
        formatter.field("virtual_interface_name", &self.virtual_interface_name);
        formatter.field("vlan", &self.vlan);
        formatter.field("asn", &self.asn);
        formatter.field("mtu", &self.mtu);
        formatter.field("auth_key", &self.auth_key);
        formatter.field("amazon_address", &self.amazon_address);
        formatter.field("customer_address", &self.customer_address);
        formatter.field("address_family", &self.address_family);
        formatter.field("virtual_gateway_id", &self.virtual_gateway_id);
        formatter.field("direct_connect_gateway_id", &self.direct_connect_gateway_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`NewPrivateVirtualInterface`](crate::model::NewPrivateVirtualInterface)
pub mod new_private_virtual_interface {
    /// A builder for [`NewPrivateVirtualInterface`](crate::model::NewPrivateVirtualInterface)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_interface_name: std::option::Option<std::string::String>,
        pub(crate) vlan: std::option::Option<i32>,
        pub(crate) asn: std::option::Option<i32>,
        pub(crate) mtu: std::option::Option<i32>,
        pub(crate) auth_key: std::option::Option<std::string::String>,
        pub(crate) amazon_address: std::option::Option<std::string::String>,
        pub(crate) customer_address: std::option::Option<std::string::String>,
        pub(crate) address_family: std::option::Option<crate::model::AddressFamily>,
        pub(crate) virtual_gateway_id: std::option::Option<std::string::String>,
        pub(crate) direct_connect_gateway_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
        pub fn virtual_interface_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
        pub fn set_virtual_interface_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_name = input;
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn vlan(mut self, input: i32) -> Self {
            self.vlan = Some(input);
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn set_vlan(mut self, input: std::option::Option<i32>) -> Self {
            self.vlan = input;
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        /// <p>The valid values are 1-2147483647.</p>
        pub fn asn(mut self, input: i32) -> Self {
            self.asn = Some(input);
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        /// <p>The valid values are 1-2147483647.</p>
        pub fn set_asn(mut self, input: std::option::Option<i32>) -> Self {
            self.asn = input;
            self
        }
        /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
        pub fn mtu(mut self, input: i32) -> Self {
            self.mtu = Some(input);
            self
        }
        /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
        pub fn set_mtu(mut self, input: std::option::Option<i32>) -> Self {
            self.mtu = input;
            self
        }
        /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
        pub fn auth_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.auth_key = Some(input.into());
            self
        }
        /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
        pub fn set_auth_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.auth_key = input;
            self
        }
        /// <p>The IP address assigned to the Amazon interface.</p>
        pub fn amazon_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.amazon_address = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the Amazon interface.</p>
        pub fn set_amazon_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amazon_address = input;
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn customer_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_address = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn set_customer_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_address = input;
            self
        }
        /// <p>The address family for the BGP peer.</p>
        pub fn address_family(mut self, input: crate::model::AddressFamily) -> Self {
            self.address_family = Some(input);
            self
        }
        /// <p>The address family for the BGP peer.</p>
        pub fn set_address_family(
            mut self,
            input: std::option::Option<crate::model::AddressFamily>,
        ) -> Self {
            self.address_family = input;
            self
        }
        /// <p>The ID of the virtual private gateway.</p>
        pub fn virtual_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual private gateway.</p>
        pub fn set_virtual_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_gateway_id = input;
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.direct_connect_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the private virtual interface.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the private virtual interface.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`NewPrivateVirtualInterface`](crate::model::NewPrivateVirtualInterface)
        pub fn build(self) -> crate::model::NewPrivateVirtualInterface {
            crate::model::NewPrivateVirtualInterface {
                virtual_interface_name: self.virtual_interface_name,
                vlan: self.vlan.unwrap_or_default(),
                asn: self.asn.unwrap_or_default(),
                mtu: self.mtu,
                auth_key: self.auth_key,
                amazon_address: self.amazon_address,
                customer_address: self.customer_address,
                address_family: self.address_family,
                virtual_gateway_id: self.virtual_gateway_id,
                direct_connect_gateway_id: self.direct_connect_gateway_id,
                tags: self.tags,
            }
        }
    }
}
impl NewPrivateVirtualInterface {
    /// Creates a new builder-style object to manufacture [`NewPrivateVirtualInterface`](crate::model::NewPrivateVirtualInterface)
    pub fn builder() -> crate::model::new_private_virtual_interface::Builder {
        crate::model::new_private_virtual_interface::Builder::default()
    }
}

/// <p>Information about a new BGP peer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NewBgpPeer {
    /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
    pub asn: i32,
    /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
    pub auth_key: std::option::Option<std::string::String>,
    /// <p>The address family for the BGP peer.</p>
    pub address_family: std::option::Option<crate::model::AddressFamily>,
    /// <p>The IP address assigned to the Amazon interface.</p>
    pub amazon_address: std::option::Option<std::string::String>,
    /// <p>The IP address assigned to the customer interface.</p>
    pub customer_address: std::option::Option<std::string::String>,
}
impl NewBgpPeer {
    /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
    pub fn asn(&self) -> i32 {
        self.asn
    }
    /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
    pub fn auth_key(&self) -> std::option::Option<&str> {
        self.auth_key.as_deref()
    }
    /// <p>The address family for the BGP peer.</p>
    pub fn address_family(&self) -> std::option::Option<&crate::model::AddressFamily> {
        self.address_family.as_ref()
    }
    /// <p>The IP address assigned to the Amazon interface.</p>
    pub fn amazon_address(&self) -> std::option::Option<&str> {
        self.amazon_address.as_deref()
    }
    /// <p>The IP address assigned to the customer interface.</p>
    pub fn customer_address(&self) -> std::option::Option<&str> {
        self.customer_address.as_deref()
    }
}
impl std::fmt::Debug for NewBgpPeer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NewBgpPeer");
        formatter.field("asn", &self.asn);
        formatter.field("auth_key", &self.auth_key);
        formatter.field("address_family", &self.address_family);
        formatter.field("amazon_address", &self.amazon_address);
        formatter.field("customer_address", &self.customer_address);
        formatter.finish()
    }
}
/// See [`NewBgpPeer`](crate::model::NewBgpPeer)
pub mod new_bgp_peer {
    /// A builder for [`NewBgpPeer`](crate::model::NewBgpPeer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asn: std::option::Option<i32>,
        pub(crate) auth_key: std::option::Option<std::string::String>,
        pub(crate) address_family: std::option::Option<crate::model::AddressFamily>,
        pub(crate) amazon_address: std::option::Option<std::string::String>,
        pub(crate) customer_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        pub fn asn(mut self, input: i32) -> Self {
            self.asn = Some(input);
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        pub fn set_asn(mut self, input: std::option::Option<i32>) -> Self {
            self.asn = input;
            self
        }
        /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
        pub fn auth_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.auth_key = Some(input.into());
            self
        }
        /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
        pub fn set_auth_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.auth_key = input;
            self
        }
        /// <p>The address family for the BGP peer.</p>
        pub fn address_family(mut self, input: crate::model::AddressFamily) -> Self {
            self.address_family = Some(input);
            self
        }
        /// <p>The address family for the BGP peer.</p>
        pub fn set_address_family(
            mut self,
            input: std::option::Option<crate::model::AddressFamily>,
        ) -> Self {
            self.address_family = input;
            self
        }
        /// <p>The IP address assigned to the Amazon interface.</p>
        pub fn amazon_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.amazon_address = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the Amazon interface.</p>
        pub fn set_amazon_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amazon_address = input;
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn customer_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_address = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn set_customer_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_address = input;
            self
        }
        /// Consumes the builder and constructs a [`NewBgpPeer`](crate::model::NewBgpPeer)
        pub fn build(self) -> crate::model::NewBgpPeer {
            crate::model::NewBgpPeer {
                asn: self.asn.unwrap_or_default(),
                auth_key: self.auth_key,
                address_family: self.address_family,
                amazon_address: self.amazon_address,
                customer_address: self.customer_address,
            }
        }
    }
}
impl NewBgpPeer {
    /// Creates a new builder-style object to manufacture [`NewBgpPeer`](crate::model::NewBgpPeer)
    pub fn builder() -> crate::model::new_bgp_peer::Builder {
        crate::model::new_bgp_peer::Builder::default()
    }
}

/// <p>Information about a transit virtual interface to be provisioned on a connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NewTransitVirtualInterfaceAllocation {
    /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
    pub virtual_interface_name: std::option::Option<std::string::String>,
    /// <p>The ID of the VLAN.</p>
    pub vlan: i32,
    /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
    /// <p>The valid values are 1-2147483647.</p>
    pub asn: i32,
    /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500. </p>
    pub mtu: std::option::Option<i32>,
    /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
    pub auth_key: std::option::Option<std::string::String>,
    /// <p>The IP address assigned to the Amazon interface.</p>
    pub amazon_address: std::option::Option<std::string::String>,
    /// <p>The IP address assigned to the customer interface.</p>
    pub customer_address: std::option::Option<std::string::String>,
    /// <p>The address family for the BGP peer.</p>
    pub address_family: std::option::Option<crate::model::AddressFamily>,
    /// <p>The tags associated with the transitive virtual interface.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl NewTransitVirtualInterfaceAllocation {
    /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
    pub fn virtual_interface_name(&self) -> std::option::Option<&str> {
        self.virtual_interface_name.as_deref()
    }
    /// <p>The ID of the VLAN.</p>
    pub fn vlan(&self) -> i32 {
        self.vlan
    }
    /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
    /// <p>The valid values are 1-2147483647.</p>
    pub fn asn(&self) -> i32 {
        self.asn
    }
    /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500. </p>
    pub fn mtu(&self) -> std::option::Option<i32> {
        self.mtu
    }
    /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
    pub fn auth_key(&self) -> std::option::Option<&str> {
        self.auth_key.as_deref()
    }
    /// <p>The IP address assigned to the Amazon interface.</p>
    pub fn amazon_address(&self) -> std::option::Option<&str> {
        self.amazon_address.as_deref()
    }
    /// <p>The IP address assigned to the customer interface.</p>
    pub fn customer_address(&self) -> std::option::Option<&str> {
        self.customer_address.as_deref()
    }
    /// <p>The address family for the BGP peer.</p>
    pub fn address_family(&self) -> std::option::Option<&crate::model::AddressFamily> {
        self.address_family.as_ref()
    }
    /// <p>The tags associated with the transitive virtual interface.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for NewTransitVirtualInterfaceAllocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NewTransitVirtualInterfaceAllocation");
        formatter.field("virtual_interface_name", &self.virtual_interface_name);
        formatter.field("vlan", &self.vlan);
        formatter.field("asn", &self.asn);
        formatter.field("mtu", &self.mtu);
        formatter.field("auth_key", &self.auth_key);
        formatter.field("amazon_address", &self.amazon_address);
        formatter.field("customer_address", &self.customer_address);
        formatter.field("address_family", &self.address_family);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`NewTransitVirtualInterfaceAllocation`](crate::model::NewTransitVirtualInterfaceAllocation)
pub mod new_transit_virtual_interface_allocation {
    /// A builder for [`NewTransitVirtualInterfaceAllocation`](crate::model::NewTransitVirtualInterfaceAllocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_interface_name: std::option::Option<std::string::String>,
        pub(crate) vlan: std::option::Option<i32>,
        pub(crate) asn: std::option::Option<i32>,
        pub(crate) mtu: std::option::Option<i32>,
        pub(crate) auth_key: std::option::Option<std::string::String>,
        pub(crate) amazon_address: std::option::Option<std::string::String>,
        pub(crate) customer_address: std::option::Option<std::string::String>,
        pub(crate) address_family: std::option::Option<crate::model::AddressFamily>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
        pub fn virtual_interface_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
        pub fn set_virtual_interface_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_name = input;
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn vlan(mut self, input: i32) -> Self {
            self.vlan = Some(input);
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn set_vlan(mut self, input: std::option::Option<i32>) -> Self {
            self.vlan = input;
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        /// <p>The valid values are 1-2147483647.</p>
        pub fn asn(mut self, input: i32) -> Self {
            self.asn = Some(input);
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        /// <p>The valid values are 1-2147483647.</p>
        pub fn set_asn(mut self, input: std::option::Option<i32>) -> Self {
            self.asn = input;
            self
        }
        /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500. </p>
        pub fn mtu(mut self, input: i32) -> Self {
            self.mtu = Some(input);
            self
        }
        /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500. </p>
        pub fn set_mtu(mut self, input: std::option::Option<i32>) -> Self {
            self.mtu = input;
            self
        }
        /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
        pub fn auth_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.auth_key = Some(input.into());
            self
        }
        /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
        pub fn set_auth_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.auth_key = input;
            self
        }
        /// <p>The IP address assigned to the Amazon interface.</p>
        pub fn amazon_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.amazon_address = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the Amazon interface.</p>
        pub fn set_amazon_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amazon_address = input;
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn customer_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_address = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn set_customer_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_address = input;
            self
        }
        /// <p>The address family for the BGP peer.</p>
        pub fn address_family(mut self, input: crate::model::AddressFamily) -> Self {
            self.address_family = Some(input);
            self
        }
        /// <p>The address family for the BGP peer.</p>
        pub fn set_address_family(
            mut self,
            input: std::option::Option<crate::model::AddressFamily>,
        ) -> Self {
            self.address_family = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the transitive virtual interface.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the transitive virtual interface.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`NewTransitVirtualInterfaceAllocation`](crate::model::NewTransitVirtualInterfaceAllocation)
        pub fn build(self) -> crate::model::NewTransitVirtualInterfaceAllocation {
            crate::model::NewTransitVirtualInterfaceAllocation {
                virtual_interface_name: self.virtual_interface_name,
                vlan: self.vlan.unwrap_or_default(),
                asn: self.asn.unwrap_or_default(),
                mtu: self.mtu,
                auth_key: self.auth_key,
                amazon_address: self.amazon_address,
                customer_address: self.customer_address,
                address_family: self.address_family,
                tags: self.tags,
            }
        }
    }
}
impl NewTransitVirtualInterfaceAllocation {
    /// Creates a new builder-style object to manufacture [`NewTransitVirtualInterfaceAllocation`](crate::model::NewTransitVirtualInterfaceAllocation)
    pub fn builder() -> crate::model::new_transit_virtual_interface_allocation::Builder {
        crate::model::new_transit_virtual_interface_allocation::Builder::default()
    }
}

/// <p>Information about a public virtual interface to be provisioned on a connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NewPublicVirtualInterfaceAllocation {
    /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
    pub virtual_interface_name: std::option::Option<std::string::String>,
    /// <p>The ID of the VLAN.</p>
    pub vlan: i32,
    /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
    /// <p>The valid values are 1-2147483647.</p>
    pub asn: i32,
    /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
    pub auth_key: std::option::Option<std::string::String>,
    /// <p>The IP address assigned to the Amazon interface.</p>
    pub amazon_address: std::option::Option<std::string::String>,
    /// <p>The IP address assigned to the customer interface.</p>
    pub customer_address: std::option::Option<std::string::String>,
    /// <p>The address family for the BGP peer.</p>
    pub address_family: std::option::Option<crate::model::AddressFamily>,
    /// <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
    pub route_filter_prefixes: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
    /// <p>The tags associated with the public virtual interface.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl NewPublicVirtualInterfaceAllocation {
    /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
    pub fn virtual_interface_name(&self) -> std::option::Option<&str> {
        self.virtual_interface_name.as_deref()
    }
    /// <p>The ID of the VLAN.</p>
    pub fn vlan(&self) -> i32 {
        self.vlan
    }
    /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
    /// <p>The valid values are 1-2147483647.</p>
    pub fn asn(&self) -> i32 {
        self.asn
    }
    /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
    pub fn auth_key(&self) -> std::option::Option<&str> {
        self.auth_key.as_deref()
    }
    /// <p>The IP address assigned to the Amazon interface.</p>
    pub fn amazon_address(&self) -> std::option::Option<&str> {
        self.amazon_address.as_deref()
    }
    /// <p>The IP address assigned to the customer interface.</p>
    pub fn customer_address(&self) -> std::option::Option<&str> {
        self.customer_address.as_deref()
    }
    /// <p>The address family for the BGP peer.</p>
    pub fn address_family(&self) -> std::option::Option<&crate::model::AddressFamily> {
        self.address_family.as_ref()
    }
    /// <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
    pub fn route_filter_prefixes(&self) -> std::option::Option<&[crate::model::RouteFilterPrefix]> {
        self.route_filter_prefixes.as_deref()
    }
    /// <p>The tags associated with the public virtual interface.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for NewPublicVirtualInterfaceAllocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NewPublicVirtualInterfaceAllocation");
        formatter.field("virtual_interface_name", &self.virtual_interface_name);
        formatter.field("vlan", &self.vlan);
        formatter.field("asn", &self.asn);
        formatter.field("auth_key", &self.auth_key);
        formatter.field("amazon_address", &self.amazon_address);
        formatter.field("customer_address", &self.customer_address);
        formatter.field("address_family", &self.address_family);
        formatter.field("route_filter_prefixes", &self.route_filter_prefixes);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`NewPublicVirtualInterfaceAllocation`](crate::model::NewPublicVirtualInterfaceAllocation)
pub mod new_public_virtual_interface_allocation {
    /// A builder for [`NewPublicVirtualInterfaceAllocation`](crate::model::NewPublicVirtualInterfaceAllocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_interface_name: std::option::Option<std::string::String>,
        pub(crate) vlan: std::option::Option<i32>,
        pub(crate) asn: std::option::Option<i32>,
        pub(crate) auth_key: std::option::Option<std::string::String>,
        pub(crate) amazon_address: std::option::Option<std::string::String>,
        pub(crate) customer_address: std::option::Option<std::string::String>,
        pub(crate) address_family: std::option::Option<crate::model::AddressFamily>,
        pub(crate) route_filter_prefixes:
            std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
        pub fn virtual_interface_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
        pub fn set_virtual_interface_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_name = input;
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn vlan(mut self, input: i32) -> Self {
            self.vlan = Some(input);
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn set_vlan(mut self, input: std::option::Option<i32>) -> Self {
            self.vlan = input;
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        /// <p>The valid values are 1-2147483647.</p>
        pub fn asn(mut self, input: i32) -> Self {
            self.asn = Some(input);
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        /// <p>The valid values are 1-2147483647.</p>
        pub fn set_asn(mut self, input: std::option::Option<i32>) -> Self {
            self.asn = input;
            self
        }
        /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
        pub fn auth_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.auth_key = Some(input.into());
            self
        }
        /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
        pub fn set_auth_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.auth_key = input;
            self
        }
        /// <p>The IP address assigned to the Amazon interface.</p>
        pub fn amazon_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.amazon_address = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the Amazon interface.</p>
        pub fn set_amazon_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amazon_address = input;
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn customer_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_address = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn set_customer_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_address = input;
            self
        }
        /// <p>The address family for the BGP peer.</p>
        pub fn address_family(mut self, input: crate::model::AddressFamily) -> Self {
            self.address_family = Some(input);
            self
        }
        /// <p>The address family for the BGP peer.</p>
        pub fn set_address_family(
            mut self,
            input: std::option::Option<crate::model::AddressFamily>,
        ) -> Self {
            self.address_family = input;
            self
        }
        /// Appends an item to `route_filter_prefixes`.
        ///
        /// To override the contents of this collection use [`set_route_filter_prefixes`](Self::set_route_filter_prefixes).
        ///
        /// <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
        pub fn route_filter_prefixes(
            mut self,
            input: impl Into<crate::model::RouteFilterPrefix>,
        ) -> Self {
            let mut v = self.route_filter_prefixes.unwrap_or_default();
            v.push(input.into());
            self.route_filter_prefixes = Some(v);
            self
        }
        /// <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
        pub fn set_route_filter_prefixes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        ) -> Self {
            self.route_filter_prefixes = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the public virtual interface.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the public virtual interface.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`NewPublicVirtualInterfaceAllocation`](crate::model::NewPublicVirtualInterfaceAllocation)
        pub fn build(self) -> crate::model::NewPublicVirtualInterfaceAllocation {
            crate::model::NewPublicVirtualInterfaceAllocation {
                virtual_interface_name: self.virtual_interface_name,
                vlan: self.vlan.unwrap_or_default(),
                asn: self.asn.unwrap_or_default(),
                auth_key: self.auth_key,
                amazon_address: self.amazon_address,
                customer_address: self.customer_address,
                address_family: self.address_family,
                route_filter_prefixes: self.route_filter_prefixes,
                tags: self.tags,
            }
        }
    }
}
impl NewPublicVirtualInterfaceAllocation {
    /// Creates a new builder-style object to manufacture [`NewPublicVirtualInterfaceAllocation`](crate::model::NewPublicVirtualInterfaceAllocation)
    pub fn builder() -> crate::model::new_public_virtual_interface_allocation::Builder {
        crate::model::new_public_virtual_interface_allocation::Builder::default()
    }
}

/// <p>Information about a private virtual interface to be provisioned on a connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NewPrivateVirtualInterfaceAllocation {
    /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
    pub virtual_interface_name: std::option::Option<std::string::String>,
    /// <p>The ID of the VLAN.</p>
    pub vlan: i32,
    /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
    /// <p>The valid values are 1-2147483647.</p>
    pub asn: i32,
    /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
    pub mtu: std::option::Option<i32>,
    /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
    pub auth_key: std::option::Option<std::string::String>,
    /// <p>The IP address assigned to the Amazon interface.</p>
    pub amazon_address: std::option::Option<std::string::String>,
    /// <p>The address family for the BGP peer.</p>
    pub address_family: std::option::Option<crate::model::AddressFamily>,
    /// <p>The IP address assigned to the customer interface.</p>
    pub customer_address: std::option::Option<std::string::String>,
    /// <p>The tags associated with the private virtual interface.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl NewPrivateVirtualInterfaceAllocation {
    /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
    pub fn virtual_interface_name(&self) -> std::option::Option<&str> {
        self.virtual_interface_name.as_deref()
    }
    /// <p>The ID of the VLAN.</p>
    pub fn vlan(&self) -> i32 {
        self.vlan
    }
    /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
    /// <p>The valid values are 1-2147483647.</p>
    pub fn asn(&self) -> i32 {
        self.asn
    }
    /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
    pub fn mtu(&self) -> std::option::Option<i32> {
        self.mtu
    }
    /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
    pub fn auth_key(&self) -> std::option::Option<&str> {
        self.auth_key.as_deref()
    }
    /// <p>The IP address assigned to the Amazon interface.</p>
    pub fn amazon_address(&self) -> std::option::Option<&str> {
        self.amazon_address.as_deref()
    }
    /// <p>The address family for the BGP peer.</p>
    pub fn address_family(&self) -> std::option::Option<&crate::model::AddressFamily> {
        self.address_family.as_ref()
    }
    /// <p>The IP address assigned to the customer interface.</p>
    pub fn customer_address(&self) -> std::option::Option<&str> {
        self.customer_address.as_deref()
    }
    /// <p>The tags associated with the private virtual interface.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for NewPrivateVirtualInterfaceAllocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NewPrivateVirtualInterfaceAllocation");
        formatter.field("virtual_interface_name", &self.virtual_interface_name);
        formatter.field("vlan", &self.vlan);
        formatter.field("asn", &self.asn);
        formatter.field("mtu", &self.mtu);
        formatter.field("auth_key", &self.auth_key);
        formatter.field("amazon_address", &self.amazon_address);
        formatter.field("address_family", &self.address_family);
        formatter.field("customer_address", &self.customer_address);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`NewPrivateVirtualInterfaceAllocation`](crate::model::NewPrivateVirtualInterfaceAllocation)
pub mod new_private_virtual_interface_allocation {
    /// A builder for [`NewPrivateVirtualInterfaceAllocation`](crate::model::NewPrivateVirtualInterfaceAllocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_interface_name: std::option::Option<std::string::String>,
        pub(crate) vlan: std::option::Option<i32>,
        pub(crate) asn: std::option::Option<i32>,
        pub(crate) mtu: std::option::Option<i32>,
        pub(crate) auth_key: std::option::Option<std::string::String>,
        pub(crate) amazon_address: std::option::Option<std::string::String>,
        pub(crate) address_family: std::option::Option<crate::model::AddressFamily>,
        pub(crate) customer_address: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
        pub fn virtual_interface_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
        pub fn set_virtual_interface_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_name = input;
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn vlan(mut self, input: i32) -> Self {
            self.vlan = Some(input);
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn set_vlan(mut self, input: std::option::Option<i32>) -> Self {
            self.vlan = input;
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        /// <p>The valid values are 1-2147483647.</p>
        pub fn asn(mut self, input: i32) -> Self {
            self.asn = Some(input);
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        /// <p>The valid values are 1-2147483647.</p>
        pub fn set_asn(mut self, input: std::option::Option<i32>) -> Self {
            self.asn = input;
            self
        }
        /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
        pub fn mtu(mut self, input: i32) -> Self {
            self.mtu = Some(input);
            self
        }
        /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
        pub fn set_mtu(mut self, input: std::option::Option<i32>) -> Self {
            self.mtu = input;
            self
        }
        /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
        pub fn auth_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.auth_key = Some(input.into());
            self
        }
        /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
        pub fn set_auth_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.auth_key = input;
            self
        }
        /// <p>The IP address assigned to the Amazon interface.</p>
        pub fn amazon_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.amazon_address = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the Amazon interface.</p>
        pub fn set_amazon_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amazon_address = input;
            self
        }
        /// <p>The address family for the BGP peer.</p>
        pub fn address_family(mut self, input: crate::model::AddressFamily) -> Self {
            self.address_family = Some(input);
            self
        }
        /// <p>The address family for the BGP peer.</p>
        pub fn set_address_family(
            mut self,
            input: std::option::Option<crate::model::AddressFamily>,
        ) -> Self {
            self.address_family = input;
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn customer_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_address = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn set_customer_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_address = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the private virtual interface.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the private virtual interface.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`NewPrivateVirtualInterfaceAllocation`](crate::model::NewPrivateVirtualInterfaceAllocation)
        pub fn build(self) -> crate::model::NewPrivateVirtualInterfaceAllocation {
            crate::model::NewPrivateVirtualInterfaceAllocation {
                virtual_interface_name: self.virtual_interface_name,
                vlan: self.vlan.unwrap_or_default(),
                asn: self.asn.unwrap_or_default(),
                mtu: self.mtu,
                auth_key: self.auth_key,
                amazon_address: self.amazon_address,
                address_family: self.address_family,
                customer_address: self.customer_address,
                tags: self.tags,
            }
        }
    }
}
impl NewPrivateVirtualInterfaceAllocation {
    /// Creates a new builder-style object to manufacture [`NewPrivateVirtualInterfaceAllocation`](crate::model::NewPrivateVirtualInterfaceAllocation)
    pub fn builder() -> crate::model::new_private_virtual_interface_allocation::Builder {
        crate::model::new_private_virtual_interface_allocation::Builder::default()
    }
}
