// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for AWS Direct Connect
///
/// Client for invoking operations on AWS Direct Connect. Each operation on AWS Direct Connect is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_directconnect::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operationname>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_directconnect::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_directconnect::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AcceptDirectConnectGatewayAssociationProposal` operation.
    ///
    /// See [`AcceptDirectConnectGatewayAssociationProposal`](crate::client::fluent_builders::AcceptDirectConnectGatewayAssociationProposal) for more information about the
    /// operation and its arguments.
    pub fn accept_direct_connect_gateway_association_proposal(
        &self,
    ) -> fluent_builders::AcceptDirectConnectGatewayAssociationProposal<C, M, R> {
        fluent_builders::AcceptDirectConnectGatewayAssociationProposal::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AllocateConnectionOnInterconnect` operation.
    ///
    /// See [`AllocateConnectionOnInterconnect`](crate::client::fluent_builders::AllocateConnectionOnInterconnect) for more information about the
    /// operation and its arguments.
    pub fn allocate_connection_on_interconnect(
        &self,
    ) -> fluent_builders::AllocateConnectionOnInterconnect<C, M, R> {
        fluent_builders::AllocateConnectionOnInterconnect::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AllocateHostedConnection` operation.
    ///
    /// See [`AllocateHostedConnection`](crate::client::fluent_builders::AllocateHostedConnection) for more information about the
    /// operation and its arguments.
    pub fn allocate_hosted_connection(&self) -> fluent_builders::AllocateHostedConnection<C, M, R> {
        fluent_builders::AllocateHostedConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AllocatePrivateVirtualInterface` operation.
    ///
    /// See [`AllocatePrivateVirtualInterface`](crate::client::fluent_builders::AllocatePrivateVirtualInterface) for more information about the
    /// operation and its arguments.
    pub fn allocate_private_virtual_interface(
        &self,
    ) -> fluent_builders::AllocatePrivateVirtualInterface<C, M, R> {
        fluent_builders::AllocatePrivateVirtualInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AllocatePublicVirtualInterface` operation.
    ///
    /// See [`AllocatePublicVirtualInterface`](crate::client::fluent_builders::AllocatePublicVirtualInterface) for more information about the
    /// operation and its arguments.
    pub fn allocate_public_virtual_interface(
        &self,
    ) -> fluent_builders::AllocatePublicVirtualInterface<C, M, R> {
        fluent_builders::AllocatePublicVirtualInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AllocateTransitVirtualInterface` operation.
    ///
    /// See [`AllocateTransitVirtualInterface`](crate::client::fluent_builders::AllocateTransitVirtualInterface) for more information about the
    /// operation and its arguments.
    pub fn allocate_transit_virtual_interface(
        &self,
    ) -> fluent_builders::AllocateTransitVirtualInterface<C, M, R> {
        fluent_builders::AllocateTransitVirtualInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateConnectionWithLag` operation.
    ///
    /// See [`AssociateConnectionWithLag`](crate::client::fluent_builders::AssociateConnectionWithLag) for more information about the
    /// operation and its arguments.
    pub fn associate_connection_with_lag(
        &self,
    ) -> fluent_builders::AssociateConnectionWithLag<C, M, R> {
        fluent_builders::AssociateConnectionWithLag::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateHostedConnection` operation.
    ///
    /// See [`AssociateHostedConnection`](crate::client::fluent_builders::AssociateHostedConnection) for more information about the
    /// operation and its arguments.
    pub fn associate_hosted_connection(
        &self,
    ) -> fluent_builders::AssociateHostedConnection<C, M, R> {
        fluent_builders::AssociateHostedConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateMacSecKey` operation.
    ///
    /// See [`AssociateMacSecKey`](crate::client::fluent_builders::AssociateMacSecKey) for more information about the
    /// operation and its arguments.
    pub fn associate_mac_sec_key(&self) -> fluent_builders::AssociateMacSecKey<C, M, R> {
        fluent_builders::AssociateMacSecKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateVirtualInterface` operation.
    ///
    /// See [`AssociateVirtualInterface`](crate::client::fluent_builders::AssociateVirtualInterface) for more information about the
    /// operation and its arguments.
    pub fn associate_virtual_interface(
        &self,
    ) -> fluent_builders::AssociateVirtualInterface<C, M, R> {
        fluent_builders::AssociateVirtualInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ConfirmConnection` operation.
    ///
    /// See [`ConfirmConnection`](crate::client::fluent_builders::ConfirmConnection) for more information about the
    /// operation and its arguments.
    pub fn confirm_connection(&self) -> fluent_builders::ConfirmConnection<C, M, R> {
        fluent_builders::ConfirmConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ConfirmCustomerAgreement` operation.
    ///
    /// See [`ConfirmCustomerAgreement`](crate::client::fluent_builders::ConfirmCustomerAgreement) for more information about the
    /// operation and its arguments.
    pub fn confirm_customer_agreement(&self) -> fluent_builders::ConfirmCustomerAgreement<C, M, R> {
        fluent_builders::ConfirmCustomerAgreement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ConfirmPrivateVirtualInterface` operation.
    ///
    /// See [`ConfirmPrivateVirtualInterface`](crate::client::fluent_builders::ConfirmPrivateVirtualInterface) for more information about the
    /// operation and its arguments.
    pub fn confirm_private_virtual_interface(
        &self,
    ) -> fluent_builders::ConfirmPrivateVirtualInterface<C, M, R> {
        fluent_builders::ConfirmPrivateVirtualInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ConfirmPublicVirtualInterface` operation.
    ///
    /// See [`ConfirmPublicVirtualInterface`](crate::client::fluent_builders::ConfirmPublicVirtualInterface) for more information about the
    /// operation and its arguments.
    pub fn confirm_public_virtual_interface(
        &self,
    ) -> fluent_builders::ConfirmPublicVirtualInterface<C, M, R> {
        fluent_builders::ConfirmPublicVirtualInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ConfirmTransitVirtualInterface` operation.
    ///
    /// See [`ConfirmTransitVirtualInterface`](crate::client::fluent_builders::ConfirmTransitVirtualInterface) for more information about the
    /// operation and its arguments.
    pub fn confirm_transit_virtual_interface(
        &self,
    ) -> fluent_builders::ConfirmTransitVirtualInterface<C, M, R> {
        fluent_builders::ConfirmTransitVirtualInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateBGPPeer` operation.
    ///
    /// See [`CreateBGPPeer`](crate::client::fluent_builders::CreateBGPPeer) for more information about the
    /// operation and its arguments.
    pub fn create_bgp_peer(&self) -> fluent_builders::CreateBGPPeer<C, M, R> {
        fluent_builders::CreateBGPPeer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateConnection` operation.
    ///
    /// See [`CreateConnection`](crate::client::fluent_builders::CreateConnection) for more information about the
    /// operation and its arguments.
    pub fn create_connection(&self) -> fluent_builders::CreateConnection<C, M, R> {
        fluent_builders::CreateConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDirectConnectGateway` operation.
    ///
    /// See [`CreateDirectConnectGateway`](crate::client::fluent_builders::CreateDirectConnectGateway) for more information about the
    /// operation and its arguments.
    pub fn create_direct_connect_gateway(
        &self,
    ) -> fluent_builders::CreateDirectConnectGateway<C, M, R> {
        fluent_builders::CreateDirectConnectGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDirectConnectGatewayAssociation` operation.
    ///
    /// See [`CreateDirectConnectGatewayAssociation`](crate::client::fluent_builders::CreateDirectConnectGatewayAssociation) for more information about the
    /// operation and its arguments.
    pub fn create_direct_connect_gateway_association(
        &self,
    ) -> fluent_builders::CreateDirectConnectGatewayAssociation<C, M, R> {
        fluent_builders::CreateDirectConnectGatewayAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDirectConnectGatewayAssociationProposal` operation.
    ///
    /// See [`CreateDirectConnectGatewayAssociationProposal`](crate::client::fluent_builders::CreateDirectConnectGatewayAssociationProposal) for more information about the
    /// operation and its arguments.
    pub fn create_direct_connect_gateway_association_proposal(
        &self,
    ) -> fluent_builders::CreateDirectConnectGatewayAssociationProposal<C, M, R> {
        fluent_builders::CreateDirectConnectGatewayAssociationProposal::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateInterconnect` operation.
    ///
    /// See [`CreateInterconnect`](crate::client::fluent_builders::CreateInterconnect) for more information about the
    /// operation and its arguments.
    pub fn create_interconnect(&self) -> fluent_builders::CreateInterconnect<C, M, R> {
        fluent_builders::CreateInterconnect::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLag` operation.
    ///
    /// See [`CreateLag`](crate::client::fluent_builders::CreateLag) for more information about the
    /// operation and its arguments.
    pub fn create_lag(&self) -> fluent_builders::CreateLag<C, M, R> {
        fluent_builders::CreateLag::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePrivateVirtualInterface` operation.
    ///
    /// See [`CreatePrivateVirtualInterface`](crate::client::fluent_builders::CreatePrivateVirtualInterface) for more information about the
    /// operation and its arguments.
    pub fn create_private_virtual_interface(
        &self,
    ) -> fluent_builders::CreatePrivateVirtualInterface<C, M, R> {
        fluent_builders::CreatePrivateVirtualInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePublicVirtualInterface` operation.
    ///
    /// See [`CreatePublicVirtualInterface`](crate::client::fluent_builders::CreatePublicVirtualInterface) for more information about the
    /// operation and its arguments.
    pub fn create_public_virtual_interface(
        &self,
    ) -> fluent_builders::CreatePublicVirtualInterface<C, M, R> {
        fluent_builders::CreatePublicVirtualInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTransitVirtualInterface` operation.
    ///
    /// See [`CreateTransitVirtualInterface`](crate::client::fluent_builders::CreateTransitVirtualInterface) for more information about the
    /// operation and its arguments.
    pub fn create_transit_virtual_interface(
        &self,
    ) -> fluent_builders::CreateTransitVirtualInterface<C, M, R> {
        fluent_builders::CreateTransitVirtualInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBGPPeer` operation.
    ///
    /// See [`DeleteBGPPeer`](crate::client::fluent_builders::DeleteBGPPeer) for more information about the
    /// operation and its arguments.
    pub fn delete_bgp_peer(&self) -> fluent_builders::DeleteBGPPeer<C, M, R> {
        fluent_builders::DeleteBGPPeer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteConnection` operation.
    ///
    /// See [`DeleteConnection`](crate::client::fluent_builders::DeleteConnection) for more information about the
    /// operation and its arguments.
    pub fn delete_connection(&self) -> fluent_builders::DeleteConnection<C, M, R> {
        fluent_builders::DeleteConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDirectConnectGateway` operation.
    ///
    /// See [`DeleteDirectConnectGateway`](crate::client::fluent_builders::DeleteDirectConnectGateway) for more information about the
    /// operation and its arguments.
    pub fn delete_direct_connect_gateway(
        &self,
    ) -> fluent_builders::DeleteDirectConnectGateway<C, M, R> {
        fluent_builders::DeleteDirectConnectGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDirectConnectGatewayAssociation` operation.
    ///
    /// See [`DeleteDirectConnectGatewayAssociation`](crate::client::fluent_builders::DeleteDirectConnectGatewayAssociation) for more information about the
    /// operation and its arguments.
    pub fn delete_direct_connect_gateway_association(
        &self,
    ) -> fluent_builders::DeleteDirectConnectGatewayAssociation<C, M, R> {
        fluent_builders::DeleteDirectConnectGatewayAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDirectConnectGatewayAssociationProposal` operation.
    ///
    /// See [`DeleteDirectConnectGatewayAssociationProposal`](crate::client::fluent_builders::DeleteDirectConnectGatewayAssociationProposal) for more information about the
    /// operation and its arguments.
    pub fn delete_direct_connect_gateway_association_proposal(
        &self,
    ) -> fluent_builders::DeleteDirectConnectGatewayAssociationProposal<C, M, R> {
        fluent_builders::DeleteDirectConnectGatewayAssociationProposal::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteInterconnect` operation.
    ///
    /// See [`DeleteInterconnect`](crate::client::fluent_builders::DeleteInterconnect) for more information about the
    /// operation and its arguments.
    pub fn delete_interconnect(&self) -> fluent_builders::DeleteInterconnect<C, M, R> {
        fluent_builders::DeleteInterconnect::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLag` operation.
    ///
    /// See [`DeleteLag`](crate::client::fluent_builders::DeleteLag) for more information about the
    /// operation and its arguments.
    pub fn delete_lag(&self) -> fluent_builders::DeleteLag<C, M, R> {
        fluent_builders::DeleteLag::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteVirtualInterface` operation.
    ///
    /// See [`DeleteVirtualInterface`](crate::client::fluent_builders::DeleteVirtualInterface) for more information about the
    /// operation and its arguments.
    pub fn delete_virtual_interface(&self) -> fluent_builders::DeleteVirtualInterface<C, M, R> {
        fluent_builders::DeleteVirtualInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeConnectionLoa` operation.
    ///
    /// See [`DescribeConnectionLoa`](crate::client::fluent_builders::DescribeConnectionLoa) for more information about the
    /// operation and its arguments.
    pub fn describe_connection_loa(&self) -> fluent_builders::DescribeConnectionLoa<C, M, R> {
        fluent_builders::DescribeConnectionLoa::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeConnections` operation.
    ///
    /// See [`DescribeConnections`](crate::client::fluent_builders::DescribeConnections) for more information about the
    /// operation and its arguments.
    pub fn describe_connections(&self) -> fluent_builders::DescribeConnections<C, M, R> {
        fluent_builders::DescribeConnections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeConnectionsOnInterconnect` operation.
    ///
    /// See [`DescribeConnectionsOnInterconnect`](crate::client::fluent_builders::DescribeConnectionsOnInterconnect) for more information about the
    /// operation and its arguments.
    pub fn describe_connections_on_interconnect(
        &self,
    ) -> fluent_builders::DescribeConnectionsOnInterconnect<C, M, R> {
        fluent_builders::DescribeConnectionsOnInterconnect::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCustomerMetadata` operation.
    ///
    /// See [`DescribeCustomerMetadata`](crate::client::fluent_builders::DescribeCustomerMetadata) for more information about the
    /// operation and its arguments.
    pub fn describe_customer_metadata(&self) -> fluent_builders::DescribeCustomerMetadata<C, M, R> {
        fluent_builders::DescribeCustomerMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDirectConnectGatewayAssociationProposals` operation.
    ///
    /// See [`DescribeDirectConnectGatewayAssociationProposals`](crate::client::fluent_builders::DescribeDirectConnectGatewayAssociationProposals) for more information about the
    /// operation and its arguments.
    pub fn describe_direct_connect_gateway_association_proposals(
        &self,
    ) -> fluent_builders::DescribeDirectConnectGatewayAssociationProposals<C, M, R> {
        fluent_builders::DescribeDirectConnectGatewayAssociationProposals::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDirectConnectGatewayAssociations` operation.
    ///
    /// See [`DescribeDirectConnectGatewayAssociations`](crate::client::fluent_builders::DescribeDirectConnectGatewayAssociations) for more information about the
    /// operation and its arguments.
    pub fn describe_direct_connect_gateway_associations(
        &self,
    ) -> fluent_builders::DescribeDirectConnectGatewayAssociations<C, M, R> {
        fluent_builders::DescribeDirectConnectGatewayAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDirectConnectGatewayAttachments` operation.
    ///
    /// See [`DescribeDirectConnectGatewayAttachments`](crate::client::fluent_builders::DescribeDirectConnectGatewayAttachments) for more information about the
    /// operation and its arguments.
    pub fn describe_direct_connect_gateway_attachments(
        &self,
    ) -> fluent_builders::DescribeDirectConnectGatewayAttachments<C, M, R> {
        fluent_builders::DescribeDirectConnectGatewayAttachments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDirectConnectGateways` operation.
    ///
    /// See [`DescribeDirectConnectGateways`](crate::client::fluent_builders::DescribeDirectConnectGateways) for more information about the
    /// operation and its arguments.
    pub fn describe_direct_connect_gateways(
        &self,
    ) -> fluent_builders::DescribeDirectConnectGateways<C, M, R> {
        fluent_builders::DescribeDirectConnectGateways::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeHostedConnections` operation.
    ///
    /// See [`DescribeHostedConnections`](crate::client::fluent_builders::DescribeHostedConnections) for more information about the
    /// operation and its arguments.
    pub fn describe_hosted_connections(
        &self,
    ) -> fluent_builders::DescribeHostedConnections<C, M, R> {
        fluent_builders::DescribeHostedConnections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInterconnectLoa` operation.
    ///
    /// See [`DescribeInterconnectLoa`](crate::client::fluent_builders::DescribeInterconnectLoa) for more information about the
    /// operation and its arguments.
    pub fn describe_interconnect_loa(&self) -> fluent_builders::DescribeInterconnectLoa<C, M, R> {
        fluent_builders::DescribeInterconnectLoa::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInterconnects` operation.
    ///
    /// See [`DescribeInterconnects`](crate::client::fluent_builders::DescribeInterconnects) for more information about the
    /// operation and its arguments.
    pub fn describe_interconnects(&self) -> fluent_builders::DescribeInterconnects<C, M, R> {
        fluent_builders::DescribeInterconnects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLags` operation.
    ///
    /// See [`DescribeLags`](crate::client::fluent_builders::DescribeLags) for more information about the
    /// operation and its arguments.
    pub fn describe_lags(&self) -> fluent_builders::DescribeLags<C, M, R> {
        fluent_builders::DescribeLags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLoa` operation.
    ///
    /// See [`DescribeLoa`](crate::client::fluent_builders::DescribeLoa) for more information about the
    /// operation and its arguments.
    pub fn describe_loa(&self) -> fluent_builders::DescribeLoa<C, M, R> {
        fluent_builders::DescribeLoa::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLocations` operation.
    ///
    /// See [`DescribeLocations`](crate::client::fluent_builders::DescribeLocations) for more information about the
    /// operation and its arguments.
    pub fn describe_locations(&self) -> fluent_builders::DescribeLocations<C, M, R> {
        fluent_builders::DescribeLocations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRouterConfiguration` operation.
    ///
    /// See [`DescribeRouterConfiguration`](crate::client::fluent_builders::DescribeRouterConfiguration) for more information about the
    /// operation and its arguments.
    pub fn describe_router_configuration(
        &self,
    ) -> fluent_builders::DescribeRouterConfiguration<C, M, R> {
        fluent_builders::DescribeRouterConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTags` operation.
    ///
    /// See [`DescribeTags`](crate::client::fluent_builders::DescribeTags) for more information about the
    /// operation and its arguments.
    pub fn describe_tags(&self) -> fluent_builders::DescribeTags<C, M, R> {
        fluent_builders::DescribeTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeVirtualGateways` operation.
    ///
    /// See [`DescribeVirtualGateways`](crate::client::fluent_builders::DescribeVirtualGateways) for more information about the
    /// operation and its arguments.
    pub fn describe_virtual_gateways(&self) -> fluent_builders::DescribeVirtualGateways<C, M, R> {
        fluent_builders::DescribeVirtualGateways::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeVirtualInterfaces` operation.
    ///
    /// See [`DescribeVirtualInterfaces`](crate::client::fluent_builders::DescribeVirtualInterfaces) for more information about the
    /// operation and its arguments.
    pub fn describe_virtual_interfaces(
        &self,
    ) -> fluent_builders::DescribeVirtualInterfaces<C, M, R> {
        fluent_builders::DescribeVirtualInterfaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateConnectionFromLag` operation.
    ///
    /// See [`DisassociateConnectionFromLag`](crate::client::fluent_builders::DisassociateConnectionFromLag) for more information about the
    /// operation and its arguments.
    pub fn disassociate_connection_from_lag(
        &self,
    ) -> fluent_builders::DisassociateConnectionFromLag<C, M, R> {
        fluent_builders::DisassociateConnectionFromLag::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateMacSecKey` operation.
    ///
    /// See [`DisassociateMacSecKey`](crate::client::fluent_builders::DisassociateMacSecKey) for more information about the
    /// operation and its arguments.
    pub fn disassociate_mac_sec_key(&self) -> fluent_builders::DisassociateMacSecKey<C, M, R> {
        fluent_builders::DisassociateMacSecKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListVirtualInterfaceTestHistory` operation.
    ///
    /// See [`ListVirtualInterfaceTestHistory`](crate::client::fluent_builders::ListVirtualInterfaceTestHistory) for more information about the
    /// operation and its arguments.
    pub fn list_virtual_interface_test_history(
        &self,
    ) -> fluent_builders::ListVirtualInterfaceTestHistory<C, M, R> {
        fluent_builders::ListVirtualInterfaceTestHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartBgpFailoverTest` operation.
    ///
    /// See [`StartBgpFailoverTest`](crate::client::fluent_builders::StartBgpFailoverTest) for more information about the
    /// operation and its arguments.
    pub fn start_bgp_failover_test(&self) -> fluent_builders::StartBgpFailoverTest<C, M, R> {
        fluent_builders::StartBgpFailoverTest::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopBgpFailoverTest` operation.
    ///
    /// See [`StopBgpFailoverTest`](crate::client::fluent_builders::StopBgpFailoverTest) for more information about the
    /// operation and its arguments.
    pub fn stop_bgp_failover_test(&self) -> fluent_builders::StopBgpFailoverTest<C, M, R> {
        fluent_builders::StopBgpFailoverTest::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateConnection` operation.
    ///
    /// See [`UpdateConnection`](crate::client::fluent_builders::UpdateConnection) for more information about the
    /// operation and its arguments.
    pub fn update_connection(&self) -> fluent_builders::UpdateConnection<C, M, R> {
        fluent_builders::UpdateConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDirectConnectGateway` operation.
    ///
    /// See [`UpdateDirectConnectGateway`](crate::client::fluent_builders::UpdateDirectConnectGateway) for more information about the
    /// operation and its arguments.
    pub fn update_direct_connect_gateway(
        &self,
    ) -> fluent_builders::UpdateDirectConnectGateway<C, M, R> {
        fluent_builders::UpdateDirectConnectGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDirectConnectGatewayAssociation` operation.
    ///
    /// See [`UpdateDirectConnectGatewayAssociation`](crate::client::fluent_builders::UpdateDirectConnectGatewayAssociation) for more information about the
    /// operation and its arguments.
    pub fn update_direct_connect_gateway_association(
        &self,
    ) -> fluent_builders::UpdateDirectConnectGatewayAssociation<C, M, R> {
        fluent_builders::UpdateDirectConnectGatewayAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateLag` operation.
    ///
    /// See [`UpdateLag`](crate::client::fluent_builders::UpdateLag) for more information about the
    /// operation and its arguments.
    pub fn update_lag(&self) -> fluent_builders::UpdateLag<C, M, R> {
        fluent_builders::UpdateLag::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateVirtualInterfaceAttributes` operation.
    ///
    /// See [`UpdateVirtualInterfaceAttributes`](crate::client::fluent_builders::UpdateVirtualInterfaceAttributes) for more information about the
    /// operation and its arguments.
    pub fn update_virtual_interface_attributes(
        &self,
    ) -> fluent_builders::UpdateVirtualInterfaceAttributes<C, M, R> {
        fluent_builders::UpdateVirtualInterfaceAttributes::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptDirectConnectGatewayAssociationProposal`.
    ///
    /// <p>Accepts a proposal request to attach a virtual private gateway or transit gateway to a Direct Connect gateway.</p>
    #[derive(std::fmt::Debug)]
    pub struct AcceptDirectConnectGatewayAssociationProposal<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::accept_direct_connect_gateway_association_proposal_input::Builder,
    }
    impl<C, M, R> AcceptDirectConnectGatewayAssociationProposal<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcceptDirectConnectGatewayAssociationProposal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::AcceptDirectConnectGatewayAssociationProposalOutput, aws_smithy_http::result::SdkError<crate::error::AcceptDirectConnectGatewayAssociationProposalError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::AcceptDirectConnectGatewayAssociationProposalInputOperationOutputAlias,
                                    crate::output::AcceptDirectConnectGatewayAssociationProposalOutput,
                                    crate::error::AcceptDirectConnectGatewayAssociationProposalError,
                                    crate::input::AcceptDirectConnectGatewayAssociationProposalInputOperationRetryAlias>,
                                {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.direct_connect_gateway_id(inp);
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_direct_connect_gateway_id(input);
            self
        }
        /// <p>The ID of the request proposal.</p>
        pub fn proposal_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.proposal_id(inp);
            self
        }
        /// <p>The ID of the request proposal.</p>
        pub fn set_proposal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_proposal_id(input);
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the virtual private gateway or transit gateway.</p>
        pub fn associated_gateway_owner_account(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.associated_gateway_owner_account(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the virtual private gateway or transit gateway.</p>
        pub fn set_associated_gateway_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_associated_gateway_owner_account(input);
            self
        }
        /// Appends an item to `overrideAllowedPrefixesToDirectConnectGateway`.
        ///
        /// To override the contents of this collection use [`set_override_allowed_prefixes_to_direct_connect_gateway`](Self::set_override_allowed_prefixes_to_direct_connect_gateway).
        ///
        /// <p>Overrides the Amazon VPC prefixes advertised to the Direct Connect gateway.</p>
        /// <p>For information about how to set the prefixes, see <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes">Allowed Prefixes</a> in the <i>Direct Connect User Guide</i>.</p>
        pub fn override_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            inp: impl Into<crate::model::RouteFilterPrefix>,
        ) -> Self {
            self.inner = self
                .inner
                .override_allowed_prefixes_to_direct_connect_gateway(inp);
            self
        }
        /// <p>Overrides the Amazon VPC prefixes advertised to the Direct Connect gateway.</p>
        /// <p>For information about how to set the prefixes, see <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes">Allowed Prefixes</a> in the <i>Direct Connect User Guide</i>.</p>
        pub fn set_override_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_override_allowed_prefixes_to_direct_connect_gateway(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AllocateConnectionOnInterconnect`.
    ///
    /// <p>Deprecated. Use <a>AllocateHostedConnection</a> instead.</p>
    /// <p>Creates a hosted connection on an interconnect.</p>
    /// <p>Allocates a VLAN number and a specified amount of bandwidth for use by a hosted connection on the specified interconnect.</p>
    /// <note>
    /// <p>Intended for use by Direct Connect Partners only.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct AllocateConnectionOnInterconnect<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::allocate_connection_on_interconnect_input::Builder,
    }
    impl<C, M, R> AllocateConnectionOnInterconnect<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AllocateConnectionOnInterconnect`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AllocateConnectionOnInterconnectOutput,
            aws_smithy_http::result::SdkError<crate::error::AllocateConnectionOnInterconnectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AllocateConnectionOnInterconnectInputOperationOutputAlias,
                crate::output::AllocateConnectionOnInterconnectOutput,
                crate::error::AllocateConnectionOnInterconnectError,
                crate::input::AllocateConnectionOnInterconnectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The bandwidth of the connection. The possible values are 50Mbps, 100Mbps, 200Mbps,
        /// 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, and 10Gbps. Note that only those Direct Connect Partners
        /// who have met specific requirements
        /// are allowed to create a 1Gbps, 2Gbps, 5Gbps or 10Gbps hosted connection.</p>
        pub fn bandwidth(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bandwidth(inp);
            self
        }
        /// <p>The bandwidth of the connection. The possible values are 50Mbps, 100Mbps, 200Mbps,
        /// 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, and 10Gbps. Note that only those Direct Connect Partners
        /// who have met specific requirements
        /// are allowed to create a 1Gbps, 2Gbps, 5Gbps or 10Gbps hosted connection.</p>
        pub fn set_bandwidth(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bandwidth(input);
            self
        }
        /// <p>The name of the provisioned connection.</p>
        pub fn connection_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_name(inp);
            self
        }
        /// <p>The name of the provisioned connection.</p>
        pub fn set_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_name(input);
            self
        }
        /// <p>The ID of the Amazon Web Services account of the customer for whom the connection will be provisioned.</p>
        pub fn owner_account(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner_account(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account of the customer for whom the connection will be provisioned.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_owner_account(input);
            self
        }
        /// <p>The ID of the interconnect on which the connection will be provisioned.</p>
        pub fn interconnect_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.interconnect_id(inp);
            self
        }
        /// <p>The ID of the interconnect on which the connection will be provisioned.</p>
        pub fn set_interconnect_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_interconnect_id(input);
            self
        }
        /// <p>The dedicated VLAN provisioned to the connection.</p>
        pub fn vlan(mut self, inp: i32) -> Self {
            self.inner = self.inner.vlan(inp);
            self
        }
        /// <p>The dedicated VLAN provisioned to the connection.</p>
        pub fn set_vlan(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_vlan(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AllocateHostedConnection`.
    ///
    /// <p>Creates a hosted connection on the specified interconnect or a link aggregation group (LAG) of interconnects.</p>
    /// <p>Allocates a VLAN number and a specified amount of capacity (bandwidth) for use by a hosted connection on the specified interconnect or LAG of interconnects.
    /// Amazon Web Services polices the hosted connection for the specified capacity and the Direct Connect Partner must also police the hosted connection for the specified capacity.</p>
    /// <note>
    /// <p>Intended for use by Direct Connect Partners only.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct AllocateHostedConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::allocate_hosted_connection_input::Builder,
    }
    impl<C, M, R> AllocateHostedConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AllocateHostedConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AllocateHostedConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::AllocateHostedConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AllocateHostedConnectionInputOperationOutputAlias,
                crate::output::AllocateHostedConnectionOutput,
                crate::error::AllocateHostedConnectionError,
                crate::input::AllocateHostedConnectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the interconnect or LAG.</p>
        pub fn connection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(inp);
            self
        }
        /// <p>The ID of the interconnect or LAG.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>The ID of the Amazon Web Services account ID of the customer for the connection.</p>
        pub fn owner_account(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner_account(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account ID of the customer for the connection.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_owner_account(input);
            self
        }
        /// <p>The bandwidth of the connection. The possible values are 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, and 10Gbps. Note that only those Direct Connect Partners who have met specific requirements are allowed to create a 1Gbps, 2Gbps, 5Gbps or 10Gbps hosted connection. </p>
        pub fn bandwidth(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bandwidth(inp);
            self
        }
        /// <p>The bandwidth of the connection. The possible values are 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, and 10Gbps. Note that only those Direct Connect Partners who have met specific requirements are allowed to create a 1Gbps, 2Gbps, 5Gbps or 10Gbps hosted connection. </p>
        pub fn set_bandwidth(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bandwidth(input);
            self
        }
        /// <p>The name of the hosted connection.</p>
        pub fn connection_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_name(inp);
            self
        }
        /// <p>The name of the hosted connection.</p>
        pub fn set_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_name(input);
            self
        }
        /// <p>The dedicated VLAN provisioned to the hosted connection.</p>
        pub fn vlan(mut self, inp: i32) -> Self {
            self.inner = self.inner.vlan(inp);
            self
        }
        /// <p>The dedicated VLAN provisioned to the hosted connection.</p>
        pub fn set_vlan(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_vlan(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the connection.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags associated with the connection.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AllocatePrivateVirtualInterface`.
    ///
    /// <p>Provisions a private virtual interface to be owned by the specified Amazon Web Services account.</p>
    /// <p>Virtual interfaces created using this action must be confirmed by the owner using <a>ConfirmPrivateVirtualInterface</a>.
    /// Until then, the virtual interface is in the <code>Confirming</code> state and is not available to handle traffic.</p>
    #[derive(std::fmt::Debug)]
    pub struct AllocatePrivateVirtualInterface<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::allocate_private_virtual_interface_input::Builder,
    }
    impl<C, M, R> AllocatePrivateVirtualInterface<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AllocatePrivateVirtualInterface`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AllocatePrivateVirtualInterfaceOutput,
            aws_smithy_http::result::SdkError<crate::error::AllocatePrivateVirtualInterfaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AllocatePrivateVirtualInterfaceInputOperationOutputAlias,
                crate::output::AllocatePrivateVirtualInterfaceOutput,
                crate::error::AllocatePrivateVirtualInterfaceError,
                crate::input::AllocatePrivateVirtualInterfaceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the connection on which the private virtual interface is provisioned.</p>
        pub fn connection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(inp);
            self
        }
        /// <p>The ID of the connection on which the private virtual interface is provisioned.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the virtual private interface.</p>
        pub fn owner_account(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner_account(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the virtual private interface.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_owner_account(input);
            self
        }
        /// <p>Information about the private virtual interface.</p>
        pub fn new_private_virtual_interface_allocation(
            mut self,
            inp: crate::model::NewPrivateVirtualInterfaceAllocation,
        ) -> Self {
            self.inner = self.inner.new_private_virtual_interface_allocation(inp);
            self
        }
        /// <p>Information about the private virtual interface.</p>
        pub fn set_new_private_virtual_interface_allocation(
            mut self,
            input: std::option::Option<crate::model::NewPrivateVirtualInterfaceAllocation>,
        ) -> Self {
            self.inner = self
                .inner
                .set_new_private_virtual_interface_allocation(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AllocatePublicVirtualInterface`.
    ///
    /// <p>Provisions a public virtual interface to be owned by the specified Amazon Web Services account.</p>
    /// <p>The owner of a connection calls this function to provision a public virtual interface to be owned by the specified Amazon Web Services account.</p>
    /// <p>Virtual interfaces created using this function must be confirmed by the owner using <a>ConfirmPublicVirtualInterface</a>.
    /// Until this step has been completed, the virtual interface is in the <code>confirming</code> state and is not available to handle traffic.</p>
    /// <p>When creating an IPv6 public virtual interface, omit the Amazon address and customer address. IPv6 addresses are automatically assigned from
    /// the Amazon pool of IPv6 addresses; you cannot specify custom IPv6 addresses.</p>
    #[derive(std::fmt::Debug)]
    pub struct AllocatePublicVirtualInterface<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::allocate_public_virtual_interface_input::Builder,
    }
    impl<C, M, R> AllocatePublicVirtualInterface<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AllocatePublicVirtualInterface`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AllocatePublicVirtualInterfaceOutput,
            aws_smithy_http::result::SdkError<crate::error::AllocatePublicVirtualInterfaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AllocatePublicVirtualInterfaceInputOperationOutputAlias,
                crate::output::AllocatePublicVirtualInterfaceOutput,
                crate::error::AllocatePublicVirtualInterfaceError,
                crate::input::AllocatePublicVirtualInterfaceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the connection on which the public virtual interface is provisioned.</p>
        pub fn connection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(inp);
            self
        }
        /// <p>The ID of the connection on which the public virtual interface is provisioned.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the public virtual interface.</p>
        pub fn owner_account(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner_account(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the public virtual interface.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_owner_account(input);
            self
        }
        /// <p>Information about the public virtual interface.</p>
        pub fn new_public_virtual_interface_allocation(
            mut self,
            inp: crate::model::NewPublicVirtualInterfaceAllocation,
        ) -> Self {
            self.inner = self.inner.new_public_virtual_interface_allocation(inp);
            self
        }
        /// <p>Information about the public virtual interface.</p>
        pub fn set_new_public_virtual_interface_allocation(
            mut self,
            input: std::option::Option<crate::model::NewPublicVirtualInterfaceAllocation>,
        ) -> Self {
            self.inner = self
                .inner
                .set_new_public_virtual_interface_allocation(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AllocateTransitVirtualInterface`.
    ///
    /// <p>Provisions a transit virtual interface to be owned by the specified Amazon Web Services account. Use this type of interface to connect a transit gateway to your Direct Connect gateway.</p>
    /// <p>The owner of a connection provisions a transit virtual interface to be owned by the specified Amazon Web Services account.</p>
    /// <p>After you create a transit virtual interface, it must be confirmed by the owner using <a>ConfirmTransitVirtualInterface</a>. Until this step has been completed, the transit virtual interface is in the <code>requested</code> state and is not available to handle traffic.</p>
    #[derive(std::fmt::Debug)]
    pub struct AllocateTransitVirtualInterface<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::allocate_transit_virtual_interface_input::Builder,
    }
    impl<C, M, R> AllocateTransitVirtualInterface<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AllocateTransitVirtualInterface`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AllocateTransitVirtualInterfaceOutput,
            aws_smithy_http::result::SdkError<crate::error::AllocateTransitVirtualInterfaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AllocateTransitVirtualInterfaceInputOperationOutputAlias,
                crate::output::AllocateTransitVirtualInterfaceOutput,
                crate::error::AllocateTransitVirtualInterfaceError,
                crate::input::AllocateTransitVirtualInterfaceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the connection on which the transit virtual interface is provisioned.</p>
        pub fn connection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(inp);
            self
        }
        /// <p>The ID of the connection on which the transit virtual interface is provisioned.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the transit virtual interface.</p>
        pub fn owner_account(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner_account(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the transit virtual interface.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_owner_account(input);
            self
        }
        /// <p>Information about the transit virtual interface.</p>
        pub fn new_transit_virtual_interface_allocation(
            mut self,
            inp: crate::model::NewTransitVirtualInterfaceAllocation,
        ) -> Self {
            self.inner = self.inner.new_transit_virtual_interface_allocation(inp);
            self
        }
        /// <p>Information about the transit virtual interface.</p>
        pub fn set_new_transit_virtual_interface_allocation(
            mut self,
            input: std::option::Option<crate::model::NewTransitVirtualInterfaceAllocation>,
        ) -> Self {
            self.inner = self
                .inner
                .set_new_transit_virtual_interface_allocation(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateConnectionWithLag`.
    ///
    /// <p>Associates an existing connection with a link aggregation group (LAG). The connection
    /// is interrupted and re-established as a member of the LAG (connectivity to Amazon Web Services is
    /// interrupted). The connection must be hosted on the same Direct Connect endpoint as the LAG, and its
    /// bandwidth must match the bandwidth for the LAG. You can re-associate a connection that's
    /// currently associated with a different LAG; however, if removing the connection would cause
    /// the original LAG to fall below its setting for minimum number of operational connections,
    /// the request fails.</p>
    /// <p>Any virtual interfaces that are directly associated with the connection are
    /// automatically re-associated with the LAG. If the connection was originally associated
    /// with a different LAG, the virtual interfaces remain associated with the original
    /// LAG.</p>
    /// <p>For interconnects, any hosted connections are automatically re-associated with the
    /// LAG. If the interconnect was originally associated with a different LAG, the hosted
    /// connections remain associated with the original LAG.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateConnectionWithLag<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_connection_with_lag_input::Builder,
    }
    impl<C, M, R> AssociateConnectionWithLag<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateConnectionWithLag`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateConnectionWithLagOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateConnectionWithLagError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateConnectionWithLagInputOperationOutputAlias,
                crate::output::AssociateConnectionWithLagOutput,
                crate::error::AssociateConnectionWithLagError,
                crate::input::AssociateConnectionWithLagInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(inp);
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>The ID of the LAG with which to associate the connection.</p>
        pub fn lag_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lag_id(inp);
            self
        }
        /// <p>The ID of the LAG with which to associate the connection.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lag_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateHostedConnection`.
    ///
    /// <p>Associates a hosted connection and its virtual interfaces with a link aggregation
    /// group (LAG) or interconnect. If the target interconnect or LAG has an existing hosted
    /// connection with a conflicting VLAN number or IP address, the operation fails. This
    /// action temporarily interrupts the hosted connection's connectivity to Amazon Web Services
    /// as it is being migrated.</p>
    /// <note>
    /// <p>Intended for use by Direct Connect Partners only.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct AssociateHostedConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_hosted_connection_input::Builder,
    }
    impl<C, M, R> AssociateHostedConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateHostedConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateHostedConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateHostedConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateHostedConnectionInputOperationOutputAlias,
                crate::output::AssociateHostedConnectionOutput,
                crate::error::AssociateHostedConnectionError,
                crate::input::AssociateHostedConnectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the hosted connection.</p>
        pub fn connection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(inp);
            self
        }
        /// <p>The ID of the hosted connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>The ID of the interconnect or the LAG.</p>
        pub fn parent_connection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_connection_id(inp);
            self
        }
        /// <p>The ID of the interconnect or the LAG.</p>
        pub fn set_parent_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parent_connection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateMacSecKey`.
    ///
    /// <p>Associates a MAC Security (MACsec) Connection Key Name (CKN)/ Connectivity Association Key (CAK) pair with an Direct Connect dedicated connection.</p>
    /// <p>You must supply either the <code>secretARN,</code> or the CKN/CAK (<code>ckn</code> and <code>cak</code>) pair in the request.</p>
    /// <p>For information about MAC Security (MACsec) key considerations, see  <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-key-consideration">MACsec pre-shared CKN/CAK key considerations </a> in the <i>Direct Connect User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateMacSecKey<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_mac_sec_key_input::Builder,
    }
    impl<C, M, R> AssociateMacSecKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateMacSecKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateMacSecKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateMacSecKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateMacSecKeyInputOperationOutputAlias,
                crate::output::AssociateMacSecKeyOutput,
                crate::error::AssociateMacSecKeyError,
                crate::input::AssociateMacSecKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).</p>
        /// <p>You can use <a>DescribeConnections</a> or <a>DescribeLags</a> to retrieve connection ID.</p>
        pub fn connection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(inp);
            self
        }
        /// <p>The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).</p>
        /// <p>You can use <a>DescribeConnections</a> or <a>DescribeLags</a> to retrieve connection ID.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key to associate with the dedicated connection.</p>
        /// <p>You can use <a>DescribeConnections</a> or <a>DescribeLags</a> to retrieve the MAC Security (MACsec) secret key.</p>
        /// <p>If you use this request parameter, you do not use the <code>ckn</code> and <code>cak</code> request parameters.</p>
        pub fn secret_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key to associate with the dedicated connection.</p>
        /// <p>You can use <a>DescribeConnections</a> or <a>DescribeLags</a> to retrieve the MAC Security (MACsec) secret key.</p>
        /// <p>If you use this request parameter, you do not use the <code>ckn</code> and <code>cak</code> request parameters.</p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_arn(input);
            self
        }
        /// <p>The MAC Security (MACsec) CKN to associate with the dedicated connection.</p>
        /// <p>You can create the CKN/CAK pair using an industry standard tool.</p>
        /// <p> The valid values are 64 hexadecimal characters (0-9, A-E).</p>
        /// <p>If you use this request parameter, you must use the <code>cak</code> request parameter and not use the <code>secretARN</code> request parameter.</p>
        pub fn ckn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ckn(inp);
            self
        }
        /// <p>The MAC Security (MACsec) CKN to associate with the dedicated connection.</p>
        /// <p>You can create the CKN/CAK pair using an industry standard tool.</p>
        /// <p> The valid values are 64 hexadecimal characters (0-9, A-E).</p>
        /// <p>If you use this request parameter, you must use the <code>cak</code> request parameter and not use the <code>secretARN</code> request parameter.</p>
        pub fn set_ckn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ckn(input);
            self
        }
        /// <p>The MAC Security (MACsec) CAK to associate with the dedicated connection.</p>
        /// <p>You can create the CKN/CAK pair using an industry standard tool.</p>
        /// <p> The valid values are 64 hexadecimal characters (0-9, A-E).</p>
        /// <p>If you use this request parameter, you must use the <code>ckn</code> request parameter and not use the <code>secretARN</code> request parameter.</p>
        pub fn cak(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cak(inp);
            self
        }
        /// <p>The MAC Security (MACsec) CAK to associate with the dedicated connection.</p>
        /// <p>You can create the CKN/CAK pair using an industry standard tool.</p>
        /// <p> The valid values are 64 hexadecimal characters (0-9, A-E).</p>
        /// <p>If you use this request parameter, you must use the <code>ckn</code> request parameter and not use the <code>secretARN</code> request parameter.</p>
        pub fn set_cak(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cak(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateVirtualInterface`.
    ///
    /// <p>Associates a virtual interface with a specified link aggregation group (LAG) or
    /// connection. Connectivity to Amazon Web Services is temporarily interrupted as the virtual interface is
    /// being migrated. If the target connection or LAG has an associated virtual interface with
    /// a conflicting VLAN number or a conflicting IP address, the operation fails.</p>
    /// <p>Virtual interfaces associated with a hosted connection cannot be associated with a
    /// LAG; hosted connections must be migrated along with their virtual interfaces using <a>AssociateHostedConnection</a>.</p>
    /// <p>To reassociate a virtual interface to a new connection or LAG, the requester
    /// must own either the virtual interface itself or the connection to which the virtual
    /// interface is currently associated. Additionally, the requester must own the connection
    /// or LAG for the association.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateVirtualInterface<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_virtual_interface_input::Builder,
    }
    impl<C, M, R> AssociateVirtualInterface<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateVirtualInterface`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateVirtualInterfaceOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateVirtualInterfaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateVirtualInterfaceInputOperationOutputAlias,
                crate::output::AssociateVirtualInterfaceOutput,
                crate::error::AssociateVirtualInterfaceError,
                crate::input::AssociateVirtualInterfaceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_interface_id(inp);
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_interface_id(input);
            self
        }
        /// <p>The ID of the LAG or connection.</p>
        pub fn connection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(inp);
            self
        }
        /// <p>The ID of the LAG or connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ConfirmConnection`.
    ///
    /// <p>Confirms the creation of the specified hosted connection on an interconnect.</p>
    /// <p>Upon creation, the hosted connection is initially in the <code>Ordering</code> state, and
    /// remains in this state until the owner confirms creation of the hosted connection.</p>
    #[derive(std::fmt::Debug)]
    pub struct ConfirmConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::confirm_connection_input::Builder,
    }
    impl<C, M, R> ConfirmConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ConfirmConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ConfirmConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::ConfirmConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ConfirmConnectionInputOperationOutputAlias,
                crate::output::ConfirmConnectionOutput,
                crate::error::ConfirmConnectionError,
                crate::input::ConfirmConnectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the hosted connection.</p>
        pub fn connection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(inp);
            self
        }
        /// <p>The ID of the hosted connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ConfirmCustomerAgreement`.
    ///
    /// <p>
    /// The confirmation of the terms of agreement when creating the connection/link aggregation group (LAG).
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ConfirmCustomerAgreement<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::confirm_customer_agreement_input::Builder,
    }
    impl<C, M, R> ConfirmCustomerAgreement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ConfirmCustomerAgreement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ConfirmCustomerAgreementOutput,
            aws_smithy_http::result::SdkError<crate::error::ConfirmCustomerAgreementError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ConfirmCustomerAgreementInputOperationOutputAlias,
                crate::output::ConfirmCustomerAgreementOutput,
                crate::error::ConfirmCustomerAgreementError,
                crate::input::ConfirmCustomerAgreementInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the customer agreement.
        /// </p>
        pub fn agreement_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agreement_name(inp);
            self
        }
        /// <p>
        /// The name of the customer agreement.
        /// </p>
        pub fn set_agreement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_agreement_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ConfirmPrivateVirtualInterface`.
    ///
    /// <p>Accepts ownership of a private virtual interface created by another Amazon Web Services account.</p>
    /// <p>After the virtual interface owner makes this call, the virtual interface is
    /// created and attached to the specified virtual private gateway or Direct Connect gateway, and is
    /// made available to handle traffic.</p>
    #[derive(std::fmt::Debug)]
    pub struct ConfirmPrivateVirtualInterface<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::confirm_private_virtual_interface_input::Builder,
    }
    impl<C, M, R> ConfirmPrivateVirtualInterface<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ConfirmPrivateVirtualInterface`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ConfirmPrivateVirtualInterfaceOutput,
            aws_smithy_http::result::SdkError<crate::error::ConfirmPrivateVirtualInterfaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ConfirmPrivateVirtualInterfaceInputOperationOutputAlias,
                crate::output::ConfirmPrivateVirtualInterfaceOutput,
                crate::error::ConfirmPrivateVirtualInterfaceError,
                crate::input::ConfirmPrivateVirtualInterfaceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_interface_id(inp);
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_interface_id(input);
            self
        }
        /// <p>The ID of the virtual private gateway.</p>
        pub fn virtual_gateway_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_gateway_id(inp);
            self
        }
        /// <p>The ID of the virtual private gateway.</p>
        pub fn set_virtual_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_gateway_id(input);
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.direct_connect_gateway_id(inp);
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_direct_connect_gateway_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ConfirmPublicVirtualInterface`.
    ///
    /// <p>Accepts ownership of a public virtual interface created by another Amazon Web Services account.</p>
    /// <p>After the virtual interface owner makes this call, the specified virtual interface is
    /// created and made available to handle traffic.</p>
    #[derive(std::fmt::Debug)]
    pub struct ConfirmPublicVirtualInterface<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::confirm_public_virtual_interface_input::Builder,
    }
    impl<C, M, R> ConfirmPublicVirtualInterface<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ConfirmPublicVirtualInterface`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ConfirmPublicVirtualInterfaceOutput,
            aws_smithy_http::result::SdkError<crate::error::ConfirmPublicVirtualInterfaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ConfirmPublicVirtualInterfaceInputOperationOutputAlias,
                crate::output::ConfirmPublicVirtualInterfaceOutput,
                crate::error::ConfirmPublicVirtualInterfaceError,
                crate::input::ConfirmPublicVirtualInterfaceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_interface_id(inp);
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_interface_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ConfirmTransitVirtualInterface`.
    ///
    /// <p>Accepts ownership of a transit virtual interface created by another Amazon Web Services account.</p>
    ///
    /// <p> After the owner of the transit virtual interface makes this call, the specified transit virtual interface is created and made available to handle traffic.</p>
    #[derive(std::fmt::Debug)]
    pub struct ConfirmTransitVirtualInterface<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::confirm_transit_virtual_interface_input::Builder,
    }
    impl<C, M, R> ConfirmTransitVirtualInterface<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ConfirmTransitVirtualInterface`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ConfirmTransitVirtualInterfaceOutput,
            aws_smithy_http::result::SdkError<crate::error::ConfirmTransitVirtualInterfaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ConfirmTransitVirtualInterfaceInputOperationOutputAlias,
                crate::output::ConfirmTransitVirtualInterfaceOutput,
                crate::error::ConfirmTransitVirtualInterfaceError,
                crate::input::ConfirmTransitVirtualInterfaceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_interface_id(inp);
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_interface_id(input);
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.direct_connect_gateway_id(inp);
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_direct_connect_gateway_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBGPPeer`.
    ///
    /// <p>Creates a BGP peer on the specified virtual interface.</p>
    /// <p>You must create a BGP peer for the corresponding address family (IPv4/IPv6) in order to access Amazon Web Services resources that also use that address family.</p>
    /// <p>If logical redundancy is not supported by the connection, interconnect, or LAG, the BGP peer cannot
    /// be in the same address family as an existing BGP peer on the virtual interface.</p>
    /// <p>When creating a IPv6 BGP peer, omit the Amazon address and customer address. IPv6 addresses are automatically assigned from
    /// the Amazon pool of IPv6 addresses; you cannot specify custom IPv6 addresses.</p>
    /// <p>For a public virtual interface, the Autonomous System Number (ASN) must be private or already on the allow list for the virtual interface.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateBGPPeer<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_bgp_peer_input::Builder,
    }
    impl<C, M, R> CreateBGPPeer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBGPPeer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBgpPeerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBGPPeerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBgpPeerInputOperationOutputAlias,
                crate::output::CreateBgpPeerOutput,
                crate::error::CreateBGPPeerError,
                crate::input::CreateBgpPeerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_interface_id(inp);
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_interface_id(input);
            self
        }
        /// <p>Information about the BGP peer.</p>
        pub fn new_bgp_peer(mut self, inp: crate::model::NewBgpPeer) -> Self {
            self.inner = self.inner.new_bgp_peer(inp);
            self
        }
        /// <p>Information about the BGP peer.</p>
        pub fn set_new_bgp_peer(
            mut self,
            input: std::option::Option<crate::model::NewBgpPeer>,
        ) -> Self {
            self.inner = self.inner.set_new_bgp_peer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConnection`.
    ///
    /// <p>Creates a connection between a customer network and a specific Direct Connect location.</p>
    ///
    /// <p>A connection links your internal network to an Direct Connect location over a standard Ethernet fiber-optic
    /// cable. One end of the cable is connected to your router, the other to an Direct Connect router.</p>
    /// <p>To find the locations for your Region, use <a>DescribeLocations</a>.</p>
    /// <p>You can automatically add the new connection to a link aggregation group (LAG) by
    /// specifying a LAG ID in the request. This ensures that the new connection is allocated on the
    /// same Direct Connect endpoint that hosts the specified LAG. If there are no available ports on the endpoint,
    /// the request fails and no connection is created.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_connection_input::Builder,
    }
    impl<C, M, R> CreateConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateConnectionInputOperationOutputAlias,
                crate::output::CreateConnectionOutput,
                crate::error::CreateConnectionError,
                crate::input::CreateConnectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The location of the connection.</p>
        pub fn location(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location(inp);
            self
        }
        /// <p>The location of the connection.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location(input);
            self
        }
        /// <p>The bandwidth of the connection.</p>
        pub fn bandwidth(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bandwidth(inp);
            self
        }
        /// <p>The bandwidth of the connection.</p>
        pub fn set_bandwidth(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bandwidth(input);
            self
        }
        /// <p>The name of the connection.</p>
        pub fn connection_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_name(inp);
            self
        }
        /// <p>The name of the connection.</p>
        pub fn set_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_name(input);
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lag_id(inp);
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lag_id(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to associate with the lag.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to associate with the lag.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The name of the service provider associated with the requested connection.</p>
        pub fn provider_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider_name(inp);
            self
        }
        /// <p>The name of the service provider associated with the requested connection.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provider_name(input);
            self
        }
        /// <p>Indicates whether you want the connection to support MAC Security (MACsec).</p>
        /// <p>MAC Security (MACsec) is only available on dedicated connections. For information about MAC Security (MACsec) prerequisties, see  <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites">MACsec prerequisties</a> in the <i>Direct Connect User Guide</i>.</p>
        pub fn request_mac_sec(mut self, inp: bool) -> Self {
            self.inner = self.inner.request_mac_sec(inp);
            self
        }
        /// <p>Indicates whether you want the connection to support MAC Security (MACsec).</p>
        /// <p>MAC Security (MACsec) is only available on dedicated connections. For information about MAC Security (MACsec) prerequisties, see  <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites">MACsec prerequisties</a> in the <i>Direct Connect User Guide</i>.</p>
        pub fn set_request_mac_sec(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_request_mac_sec(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDirectConnectGateway`.
    ///
    /// <p>Creates a Direct Connect gateway, which is an intermediate object that enables you to connect a set
    /// of virtual interfaces and virtual private gateways. A Direct Connect gateway is global and visible in any
    /// Amazon Web Services Region after it is created. The virtual interfaces and virtual private gateways that
    /// are connected through a Direct Connect gateway can be in different Amazon Web Services Regions. This enables you to
    /// connect to a VPC in any Region, regardless of the Region in which the virtual interfaces
    /// are located, and pass traffic between them.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDirectConnectGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_direct_connect_gateway_input::Builder,
    }
    impl<C, M, R> CreateDirectConnectGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDirectConnectGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDirectConnectGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDirectConnectGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDirectConnectGatewayInputOperationOutputAlias,
                crate::output::CreateDirectConnectGatewayOutput,
                crate::error::CreateDirectConnectGatewayError,
                crate::input::CreateDirectConnectGatewayInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.direct_connect_gateway_name(inp);
            self
        }
        /// <p>The name of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_direct_connect_gateway_name(input);
            self
        }
        /// <p>The autonomous system number (ASN) for Border Gateway Protocol (BGP) to be configured
        /// on the Amazon side of the connection. The ASN must be in the private range of 64,512 to
        /// 65,534 or 4,200,000,000 to 4,294,967,294. The default is 64512.</p>
        pub fn amazon_side_asn(mut self, inp: i64) -> Self {
            self.inner = self.inner.amazon_side_asn(inp);
            self
        }
        /// <p>The autonomous system number (ASN) for Border Gateway Protocol (BGP) to be configured
        /// on the Amazon side of the connection. The ASN must be in the private range of 64,512 to
        /// 65,534 or 4,200,000,000 to 4,294,967,294. The default is 64512.</p>
        pub fn set_amazon_side_asn(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_amazon_side_asn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDirectConnectGatewayAssociation`.
    ///
    /// <p>Creates an association between a Direct Connect gateway and a virtual private gateway. The virtual
    /// private gateway must be attached to a VPC and must not be associated with another Direct Connect gateway.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDirectConnectGatewayAssociation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_direct_connect_gateway_association_input::Builder,
    }
    impl<C, M, R> CreateDirectConnectGatewayAssociation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDirectConnectGatewayAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDirectConnectGatewayAssociationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateDirectConnectGatewayAssociationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDirectConnectGatewayAssociationInputOperationOutputAlias,
                crate::output::CreateDirectConnectGatewayAssociationOutput,
                crate::error::CreateDirectConnectGatewayAssociationError,
                crate::input::CreateDirectConnectGatewayAssociationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.direct_connect_gateway_id(inp);
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_direct_connect_gateway_id(input);
            self
        }
        /// <p>The ID of the virtual private gateway or transit gateway.</p>
        pub fn gateway_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_id(inp);
            self
        }
        /// <p>The ID of the virtual private gateway or transit gateway.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_id(input);
            self
        }
        /// Appends an item to `addAllowedPrefixesToDirectConnectGateway`.
        ///
        /// To override the contents of this collection use [`set_add_allowed_prefixes_to_direct_connect_gateway`](Self::set_add_allowed_prefixes_to_direct_connect_gateway).
        ///
        /// <p>The Amazon VPC prefixes to advertise to the Direct Connect gateway</p>
        /// <p>This parameter is required when you create an association to a transit gateway.</p>
        /// <p>For information about how to set the prefixes, see <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes">Allowed Prefixes</a> in the <i>Direct Connect User Guide</i>.</p>
        pub fn add_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            inp: impl Into<crate::model::RouteFilterPrefix>,
        ) -> Self {
            self.inner = self
                .inner
                .add_allowed_prefixes_to_direct_connect_gateway(inp);
            self
        }
        /// <p>The Amazon VPC prefixes to advertise to the Direct Connect gateway</p>
        /// <p>This parameter is required when you create an association to a transit gateway.</p>
        /// <p>For information about how to set the prefixes, see <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes">Allowed Prefixes</a> in the <i>Direct Connect User Guide</i>.</p>
        pub fn set_add_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_add_allowed_prefixes_to_direct_connect_gateway(input);
            self
        }
        /// <p>The ID of the virtual private gateway.</p>
        pub fn virtual_gateway_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_gateway_id(inp);
            self
        }
        /// <p>The ID of the virtual private gateway.</p>
        pub fn set_virtual_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_gateway_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDirectConnectGatewayAssociationProposal`.
    ///
    /// <p>Creates a proposal to associate the specified virtual private gateway or transit gateway with the specified Direct Connect gateway.</p>
    /// <p>You can associate a Direct Connect gateway and virtual private gateway or transit gateway that is owned by any Amazon Web Services account. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDirectConnectGatewayAssociationProposal<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_direct_connect_gateway_association_proposal_input::Builder,
    }
    impl<C, M, R> CreateDirectConnectGatewayAssociationProposal<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDirectConnectGatewayAssociationProposal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::CreateDirectConnectGatewayAssociationProposalOutput, aws_smithy_http::result::SdkError<crate::error::CreateDirectConnectGatewayAssociationProposalError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::CreateDirectConnectGatewayAssociationProposalInputOperationOutputAlias,
                                    crate::output::CreateDirectConnectGatewayAssociationProposalOutput,
                                    crate::error::CreateDirectConnectGatewayAssociationProposalError,
                                    crate::input::CreateDirectConnectGatewayAssociationProposalInputOperationRetryAlias>,
                                {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.direct_connect_gateway_id(inp);
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_direct_connect_gateway_id(input);
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_owner_account(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.direct_connect_gateway_owner_account(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_direct_connect_gateway_owner_account(input);
            self
        }
        /// <p>The ID of the virtual private gateway or transit gateway.</p>
        pub fn gateway_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_id(inp);
            self
        }
        /// <p>The ID of the virtual private gateway or transit gateway.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_id(input);
            self
        }
        /// Appends an item to `addAllowedPrefixesToDirectConnectGateway`.
        ///
        /// To override the contents of this collection use [`set_add_allowed_prefixes_to_direct_connect_gateway`](Self::set_add_allowed_prefixes_to_direct_connect_gateway).
        ///
        /// <p>The Amazon VPC prefixes to advertise to the Direct Connect gateway.</p>
        pub fn add_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            inp: impl Into<crate::model::RouteFilterPrefix>,
        ) -> Self {
            self.inner = self
                .inner
                .add_allowed_prefixes_to_direct_connect_gateway(inp);
            self
        }
        /// <p>The Amazon VPC prefixes to advertise to the Direct Connect gateway.</p>
        pub fn set_add_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_add_allowed_prefixes_to_direct_connect_gateway(input);
            self
        }
        /// Appends an item to `removeAllowedPrefixesToDirectConnectGateway`.
        ///
        /// To override the contents of this collection use [`set_remove_allowed_prefixes_to_direct_connect_gateway`](Self::set_remove_allowed_prefixes_to_direct_connect_gateway).
        ///
        /// <p>The Amazon VPC prefixes to no longer advertise to the Direct Connect gateway.</p>
        pub fn remove_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            inp: impl Into<crate::model::RouteFilterPrefix>,
        ) -> Self {
            self.inner = self
                .inner
                .remove_allowed_prefixes_to_direct_connect_gateway(inp);
            self
        }
        /// <p>The Amazon VPC prefixes to no longer advertise to the Direct Connect gateway.</p>
        pub fn set_remove_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_remove_allowed_prefixes_to_direct_connect_gateway(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateInterconnect`.
    ///
    /// <p>Creates an interconnect between an Direct Connect Partner's network and a specific Direct Connect location.</p>
    /// <p>An interconnect is a connection that is capable of hosting other connections. The
    /// Direct Connect Partner can use an interconnect to provide Direct Connect hosted
    /// connections to customers through their own network services. Like a standard connection, an
    /// interconnect links the partner's network to an Direct Connect location over a standard Ethernet
    /// fiber-optic cable. One end is connected to the partner's router, the other to an Direct Connect
    /// router.</p>
    /// <p>You can automatically add the new interconnect to a link aggregation group (LAG) by
    /// specifying a LAG ID in the request. This ensures that the new interconnect is allocated on
    /// the same Direct Connect endpoint that hosts the specified LAG. If there are no available ports on the
    /// endpoint, the request fails and no interconnect is created.</p>
    /// <p>For each end customer, the Direct Connect Partner provisions a connection on their interconnect by calling <a>AllocateHostedConnection</a>.
    /// The end customer can then connect to Amazon Web Services resources by creating a virtual interface on their connection, using the VLAN assigned to them by the Direct Connect Partner.</p>
    /// <note>
    /// <p>Intended for use by Direct Connect Partners only.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateInterconnect<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_interconnect_input::Builder,
    }
    impl<C, M, R> CreateInterconnect<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateInterconnect`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateInterconnectOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateInterconnectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateInterconnectInputOperationOutputAlias,
                crate::output::CreateInterconnectOutput,
                crate::error::CreateInterconnectError,
                crate::input::CreateInterconnectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the interconnect.</p>
        pub fn interconnect_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.interconnect_name(inp);
            self
        }
        /// <p>The name of the interconnect.</p>
        pub fn set_interconnect_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_interconnect_name(input);
            self
        }
        /// <p>The port bandwidth, in Gbps. The possible values are 1 and 10.</p>
        pub fn bandwidth(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bandwidth(inp);
            self
        }
        /// <p>The port bandwidth, in Gbps. The possible values are 1 and 10.</p>
        pub fn set_bandwidth(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bandwidth(input);
            self
        }
        /// <p>The location of the interconnect.</p>
        pub fn location(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location(inp);
            self
        }
        /// <p>The location of the interconnect.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location(input);
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lag_id(inp);
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lag_id(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to associate with the interconnect.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to associate with the interconnect.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The name of the service provider associated with the interconnect.</p>
        pub fn provider_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider_name(inp);
            self
        }
        /// <p>The name of the service provider associated with the interconnect.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provider_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLag`.
    ///
    /// <p>Creates a link aggregation group (LAG) with the specified number of bundled
    /// physical dedicated connections between the customer network and a specific Direct Connect location.
    /// A LAG is a logical interface that uses the Link Aggregation Control Protocol
    /// (LACP) to aggregate multiple interfaces, enabling you to treat them as a single
    /// interface.</p>
    /// <p>All connections in a LAG must use the same bandwidth (either 1Gbps or 10Gbps) and must terminate at the same Direct Connect endpoint.</p>
    /// <p>You can have up to 10 dedicated connections per LAG. Regardless of this limit, if you
    /// request more connections for the LAG than Direct Connect can allocate on a single endpoint, no LAG is
    /// created.</p>
    /// <p>You can specify an existing physical dedicated connection or interconnect to include in
    /// the LAG (which counts towards the total number of connections). Doing so interrupts the
    /// current physical dedicated connection, and re-establishes them as a member of the LAG. The LAG
    /// will be created on the same Direct Connect endpoint to which the dedicated connection terminates. Any
    /// virtual interfaces associated with the dedicated connection are automatically disassociated
    /// and re-associated with the LAG. The connection ID does not change.</p>
    /// <p>If the Amazon Web Services account used to create a LAG is a registered Direct Connect Partner, the LAG is
    /// automatically enabled to host sub-connections. For a LAG owned by a partner, any associated virtual
    /// interfaces cannot be directly configured.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateLag<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_lag_input::Builder,
    }
    impl<C, M, R> CreateLag<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLag`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLagOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLagError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLagInputOperationOutputAlias,
                crate::output::CreateLagOutput,
                crate::error::CreateLagError,
                crate::input::CreateLagInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The number of physical dedicated connections initially provisioned and bundled by the
        /// LAG.</p>
        pub fn number_of_connections(mut self, inp: i32) -> Self {
            self.inner = self.inner.number_of_connections(inp);
            self
        }
        /// <p>The number of physical dedicated connections initially provisioned and bundled by the
        /// LAG.</p>
        pub fn set_number_of_connections(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_number_of_connections(input);
            self
        }
        /// <p>The location for the LAG.</p>
        pub fn location(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location(inp);
            self
        }
        /// <p>The location for the LAG.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location(input);
            self
        }
        /// <p>The bandwidth of the individual physical dedicated connections bundled by the LAG. The
        /// possible values are 1Gbps and 10Gbps. </p>
        pub fn connections_bandwidth(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connections_bandwidth(inp);
            self
        }
        /// <p>The bandwidth of the individual physical dedicated connections bundled by the LAG. The
        /// possible values are 1Gbps and 10Gbps. </p>
        pub fn set_connections_bandwidth(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connections_bandwidth(input);
            self
        }
        /// <p>The name of the LAG.</p>
        pub fn lag_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lag_name(inp);
            self
        }
        /// <p>The name of the LAG.</p>
        pub fn set_lag_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lag_name(input);
            self
        }
        /// <p>The ID of an existing dedicated connection to migrate to the LAG.</p>
        pub fn connection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(inp);
            self
        }
        /// <p>The ID of an existing dedicated connection to migrate to the LAG.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to associate with the LAG.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to associate with the LAG.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `childConnectionTags`.
        ///
        /// To override the contents of this collection use [`set_child_connection_tags`](Self::set_child_connection_tags).
        ///
        /// <p>The tags to associate with the automtically created LAGs.</p>
        pub fn child_connection_tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.child_connection_tags(inp);
            self
        }
        /// <p>The tags to associate with the automtically created LAGs.</p>
        pub fn set_child_connection_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_child_connection_tags(input);
            self
        }
        /// <p>The name of the service provider associated with the LAG.</p>
        pub fn provider_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider_name(inp);
            self
        }
        /// <p>The name of the service provider associated with the LAG.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provider_name(input);
            self
        }
        /// <p>Indicates whether the connection will support MAC Security (MACsec).</p>
        /// <note>
        /// <p>All connections in the LAG must be capable of  supporting MAC Security (MACsec). For information about MAC Security (MACsec) prerequisties, see  <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites">MACsec prerequisties</a> in the <i>Direct Connect User Guide</i>.</p>
        /// </note>
        pub fn request_mac_sec(mut self, inp: bool) -> Self {
            self.inner = self.inner.request_mac_sec(inp);
            self
        }
        /// <p>Indicates whether the connection will support MAC Security (MACsec).</p>
        /// <note>
        /// <p>All connections in the LAG must be capable of  supporting MAC Security (MACsec). For information about MAC Security (MACsec) prerequisties, see  <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites">MACsec prerequisties</a> in the <i>Direct Connect User Guide</i>.</p>
        /// </note>
        pub fn set_request_mac_sec(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_request_mac_sec(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePrivateVirtualInterface`.
    ///
    /// <p>Creates a private virtual interface. A virtual interface is the VLAN that transports Direct Connect traffic.
    /// A private virtual interface can be connected to either a Direct Connect gateway or a Virtual Private Gateway (VGW).
    /// Connecting the private virtual interface to a Direct Connect gateway enables the possibility for connecting to multiple
    /// VPCs, including VPCs in different Amazon Web Services Regions. Connecting the private virtual interface
    /// to a VGW only provides access to a single VPC within the same Region.</p>
    /// <p>Setting the MTU of a virtual interface to 9001 (jumbo frames) can cause an update to
    /// the underlying physical connection if it wasn't updated to support jumbo frames. Updating
    /// the connection disrupts network connectivity for all virtual interfaces associated with
    /// the connection for up to 30 seconds. To check whether your connection supports jumbo
    /// frames, call <a>DescribeConnections</a>. To check whether your virtual
    /// interface supports jumbo frames, call <a>DescribeVirtualInterfaces</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreatePrivateVirtualInterface<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_private_virtual_interface_input::Builder,
    }
    impl<C, M, R> CreatePrivateVirtualInterface<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePrivateVirtualInterface`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePrivateVirtualInterfaceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePrivateVirtualInterfaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePrivateVirtualInterfaceInputOperationOutputAlias,
                crate::output::CreatePrivateVirtualInterfaceOutput,
                crate::error::CreatePrivateVirtualInterfaceError,
                crate::input::CreatePrivateVirtualInterfaceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(inp);
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>Information about the private virtual interface.</p>
        pub fn new_private_virtual_interface(
            mut self,
            inp: crate::model::NewPrivateVirtualInterface,
        ) -> Self {
            self.inner = self.inner.new_private_virtual_interface(inp);
            self
        }
        /// <p>Information about the private virtual interface.</p>
        pub fn set_new_private_virtual_interface(
            mut self,
            input: std::option::Option<crate::model::NewPrivateVirtualInterface>,
        ) -> Self {
            self.inner = self.inner.set_new_private_virtual_interface(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePublicVirtualInterface`.
    ///
    /// <p>Creates a public virtual interface. A virtual interface is the VLAN that transports Direct Connect traffic.
    /// A public virtual interface supports sending traffic to public services of Amazon Web Services such as Amazon S3.</p>
    /// <p>When creating an IPv6 public virtual interface (<code>addressFamily</code> is <code>ipv6</code>), leave the <code>customer</code>
    /// and <code>amazon</code> address fields blank to use auto-assigned IPv6 space. Custom IPv6 addresses are not supported.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreatePublicVirtualInterface<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_public_virtual_interface_input::Builder,
    }
    impl<C, M, R> CreatePublicVirtualInterface<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePublicVirtualInterface`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePublicVirtualInterfaceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePublicVirtualInterfaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePublicVirtualInterfaceInputOperationOutputAlias,
                crate::output::CreatePublicVirtualInterfaceOutput,
                crate::error::CreatePublicVirtualInterfaceError,
                crate::input::CreatePublicVirtualInterfaceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(inp);
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>Information about the public virtual interface.</p>
        pub fn new_public_virtual_interface(
            mut self,
            inp: crate::model::NewPublicVirtualInterface,
        ) -> Self {
            self.inner = self.inner.new_public_virtual_interface(inp);
            self
        }
        /// <p>Information about the public virtual interface.</p>
        pub fn set_new_public_virtual_interface(
            mut self,
            input: std::option::Option<crate::model::NewPublicVirtualInterface>,
        ) -> Self {
            self.inner = self.inner.set_new_public_virtual_interface(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTransitVirtualInterface`.
    ///
    /// <p>Creates a transit virtual interface. A transit virtual interface should be used to access one or more transit gateways associated with Direct Connect gateways. A transit virtual interface enables the connection of multiple VPCs attached to a transit gateway to a Direct Connect gateway.</p>
    /// <important>
    /// <p>If you associate your transit gateway with one or more Direct Connect gateways, the Autonomous System Number (ASN) used by the transit gateway and the Direct Connect gateway must be different. For example, if you use the default ASN 64512 for both your the transit gateway and Direct Connect gateway, the association request fails.</p>
    /// </important>
    /// <p>Setting the MTU of a virtual interface to 8500 (jumbo frames) can cause an update to
    /// the underlying physical connection if it wasn't updated to support jumbo frames. Updating
    /// the connection disrupts network connectivity for all virtual interfaces associated with
    /// the connection for up to 30 seconds. To check whether your connection supports jumbo
    /// frames, call <a>DescribeConnections</a>. To check whether your virtual
    /// interface supports jumbo frames, call <a>DescribeVirtualInterfaces</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateTransitVirtualInterface<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_transit_virtual_interface_input::Builder,
    }
    impl<C, M, R> CreateTransitVirtualInterface<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTransitVirtualInterface`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTransitVirtualInterfaceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTransitVirtualInterfaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTransitVirtualInterfaceInputOperationOutputAlias,
                crate::output::CreateTransitVirtualInterfaceOutput,
                crate::error::CreateTransitVirtualInterfaceError,
                crate::input::CreateTransitVirtualInterfaceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(inp);
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>Information about the transit virtual interface.</p>
        pub fn new_transit_virtual_interface(
            mut self,
            inp: crate::model::NewTransitVirtualInterface,
        ) -> Self {
            self.inner = self.inner.new_transit_virtual_interface(inp);
            self
        }
        /// <p>Information about the transit virtual interface.</p>
        pub fn set_new_transit_virtual_interface(
            mut self,
            input: std::option::Option<crate::model::NewTransitVirtualInterface>,
        ) -> Self {
            self.inner = self.inner.set_new_transit_virtual_interface(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBGPPeer`.
    ///
    /// <p>Deletes the specified BGP peer on the specified virtual interface with the specified customer address and ASN.</p>
    /// <p>You cannot delete the last BGP peer from a virtual interface.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBGPPeer<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_bgp_peer_input::Builder,
    }
    impl<C, M, R> DeleteBGPPeer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBGPPeer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBgpPeerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBGPPeerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBgpPeerInputOperationOutputAlias,
                crate::output::DeleteBgpPeerOutput,
                crate::error::DeleteBGPPeerError,
                crate::input::DeleteBgpPeerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_interface_id(inp);
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_interface_id(input);
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        pub fn asn(mut self, inp: i32) -> Self {
            self.inner = self.inner.asn(inp);
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        pub fn set_asn(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_asn(input);
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn customer_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.customer_address(inp);
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn set_customer_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_customer_address(input);
            self
        }
        /// <p>The ID of the BGP peer.</p>
        pub fn bgp_peer_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bgp_peer_id(inp);
            self
        }
        /// <p>The ID of the BGP peer.</p>
        pub fn set_bgp_peer_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bgp_peer_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConnection`.
    ///
    /// <p>Deletes the specified connection.</p>
    /// <p>Deleting a connection only stops the Direct Connect port hour and data transfer charges.
    /// If you are partnering with any third parties to connect with the Direct Connect location,
    /// you must cancel your service with them separately.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_connection_input::Builder,
    }
    impl<C, M, R> DeleteConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteConnectionInputOperationOutputAlias,
                crate::output::DeleteConnectionOutput,
                crate::error::DeleteConnectionError,
                crate::input::DeleteConnectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(inp);
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDirectConnectGateway`.
    ///
    /// <p>Deletes the specified Direct Connect gateway. You must first delete all virtual interfaces that are
    /// attached to the Direct Connect gateway and disassociate all virtual private gateways associated
    /// with the Direct Connect gateway.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDirectConnectGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_direct_connect_gateway_input::Builder,
    }
    impl<C, M, R> DeleteDirectConnectGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDirectConnectGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDirectConnectGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDirectConnectGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDirectConnectGatewayInputOperationOutputAlias,
                crate::output::DeleteDirectConnectGatewayOutput,
                crate::error::DeleteDirectConnectGatewayError,
                crate::input::DeleteDirectConnectGatewayInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.direct_connect_gateway_id(inp);
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_direct_connect_gateway_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDirectConnectGatewayAssociation`.
    ///
    /// <p>Deletes the association between the specified Direct Connect gateway and virtual private gateway.</p>
    /// <p>We recommend that you specify the <code>associationID</code> to delete the association. Alternatively, if you own virtual gateway and a Direct Connect gateway association, you can specify the <code>virtualGatewayId</code> and <code>directConnectGatewayId</code> to delete an association.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDirectConnectGatewayAssociation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_direct_connect_gateway_association_input::Builder,
    }
    impl<C, M, R> DeleteDirectConnectGatewayAssociation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDirectConnectGatewayAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDirectConnectGatewayAssociationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteDirectConnectGatewayAssociationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDirectConnectGatewayAssociationInputOperationOutputAlias,
                crate::output::DeleteDirectConnectGatewayAssociationOutput,
                crate::error::DeleteDirectConnectGatewayAssociationError,
                crate::input::DeleteDirectConnectGatewayAssociationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Direct Connect gateway association.</p>
        pub fn association_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_id(inp);
            self
        }
        /// <p>The ID of the Direct Connect gateway association.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_id(input);
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.direct_connect_gateway_id(inp);
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_direct_connect_gateway_id(input);
            self
        }
        /// <p>The ID of the virtual private gateway.</p>
        pub fn virtual_gateway_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_gateway_id(inp);
            self
        }
        /// <p>The ID of the virtual private gateway.</p>
        pub fn set_virtual_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_gateway_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDirectConnectGatewayAssociationProposal`.
    ///
    /// <p>Deletes the association proposal request between the specified Direct Connect gateway and virtual private gateway or transit gateway.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDirectConnectGatewayAssociationProposal<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_direct_connect_gateway_association_proposal_input::Builder,
    }
    impl<C, M, R> DeleteDirectConnectGatewayAssociationProposal<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDirectConnectGatewayAssociationProposal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::DeleteDirectConnectGatewayAssociationProposalOutput, aws_smithy_http::result::SdkError<crate::error::DeleteDirectConnectGatewayAssociationProposalError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::DeleteDirectConnectGatewayAssociationProposalInputOperationOutputAlias,
                                    crate::output::DeleteDirectConnectGatewayAssociationProposalOutput,
                                    crate::error::DeleteDirectConnectGatewayAssociationProposalError,
                                    crate::input::DeleteDirectConnectGatewayAssociationProposalInputOperationRetryAlias>,
                                {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the proposal.</p>
        pub fn proposal_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.proposal_id(inp);
            self
        }
        /// <p>The ID of the proposal.</p>
        pub fn set_proposal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_proposal_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteInterconnect`.
    ///
    /// <p>Deletes the specified interconnect.</p>
    /// <note>
    /// <p>Intended for use
    /// by Direct Connect Partners only.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteInterconnect<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_interconnect_input::Builder,
    }
    impl<C, M, R> DeleteInterconnect<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteInterconnect`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteInterconnectOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteInterconnectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteInterconnectInputOperationOutputAlias,
                crate::output::DeleteInterconnectOutput,
                crate::error::DeleteInterconnectError,
                crate::input::DeleteInterconnectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the interconnect.</p>
        pub fn interconnect_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.interconnect_id(inp);
            self
        }
        /// <p>The ID of the interconnect.</p>
        pub fn set_interconnect_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_interconnect_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLag`.
    ///
    /// <p>Deletes the specified link aggregation group (LAG). You cannot delete a LAG if it has active
    /// virtual interfaces or hosted connections.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteLag<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_lag_input::Builder,
    }
    impl<C, M, R> DeleteLag<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLag`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLagOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLagError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLagInputOperationOutputAlias,
                crate::output::DeleteLagOutput,
                crate::error::DeleteLagError,
                crate::input::DeleteLagInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lag_id(inp);
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lag_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVirtualInterface`.
    ///
    /// <p>Deletes a virtual interface.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteVirtualInterface<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_virtual_interface_input::Builder,
    }
    impl<C, M, R> DeleteVirtualInterface<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVirtualInterface`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVirtualInterfaceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVirtualInterfaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVirtualInterfaceInputOperationOutputAlias,
                crate::output::DeleteVirtualInterfaceOutput,
                crate::error::DeleteVirtualInterfaceError,
                crate::input::DeleteVirtualInterfaceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_interface_id(inp);
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_interface_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConnectionLoa`.
    ///
    /// <p>Deprecated. Use <a>DescribeLoa</a> instead.</p>
    /// <p>Gets the LOA-CFA for a connection.</p>
    /// <p>The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is a document that your APN partner or
    /// service provider uses when establishing your cross connect to Amazon Web Services at the colocation facility. For more information,
    /// see <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html">Requesting Cross Connects
    /// at Direct Connect Locations</a> in the <i>Direct Connect User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeConnectionLoa<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_connection_loa_input::Builder,
    }
    impl<C, M, R> DescribeConnectionLoa<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeConnectionLoa`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConnectionLoaOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConnectionLoaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeConnectionLoaInputOperationOutputAlias,
                crate::output::DescribeConnectionLoaOutput,
                crate::error::DescribeConnectionLoaError,
                crate::input::DescribeConnectionLoaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(inp);
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>The name of the APN partner or service provider who establishes connectivity on your behalf. If you specify this parameter,
        /// the LOA-CFA lists the provider name alongside your company name as the requester of the cross connect.</p>
        pub fn provider_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider_name(inp);
            self
        }
        /// <p>The name of the APN partner or service provider who establishes connectivity on your behalf. If you specify this parameter,
        /// the LOA-CFA lists the provider name alongside your company name as the requester of the cross connect.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provider_name(input);
            self
        }
        /// <p>The standard media type for the LOA-CFA document. The only supported value is application/pdf.</p>
        pub fn loa_content_type(mut self, inp: crate::model::LoaContentType) -> Self {
            self.inner = self.inner.loa_content_type(inp);
            self
        }
        /// <p>The standard media type for the LOA-CFA document. The only supported value is application/pdf.</p>
        pub fn set_loa_content_type(
            mut self,
            input: std::option::Option<crate::model::LoaContentType>,
        ) -> Self {
            self.inner = self.inner.set_loa_content_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConnections`.
    ///
    /// <p>Displays the specified connection or all connections in this Region.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeConnections<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_connections_input::Builder,
    }
    impl<C, M, R> DescribeConnections<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeConnections`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConnectionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConnectionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeConnectionsInputOperationOutputAlias,
                crate::output::DescribeConnectionsOutput,
                crate::error::DescribeConnectionsError,
                crate::input::DescribeConnectionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(inp);
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConnectionsOnInterconnect`.
    ///
    /// <p>Deprecated. Use <a>DescribeHostedConnections</a> instead.</p>
    /// <p>Lists the connections that have been provisioned on the specified interconnect.</p>
    /// <note>
    /// <p>Intended for use by Direct Connect Partners only.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeConnectionsOnInterconnect<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_connections_on_interconnect_input::Builder,
    }
    impl<C, M, R> DescribeConnectionsOnInterconnect<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeConnectionsOnInterconnect`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConnectionsOnInterconnectOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConnectionsOnInterconnectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeConnectionsOnInterconnectInputOperationOutputAlias,
                crate::output::DescribeConnectionsOnInterconnectOutput,
                crate::error::DescribeConnectionsOnInterconnectError,
                crate::input::DescribeConnectionsOnInterconnectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the interconnect.</p>
        pub fn interconnect_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.interconnect_id(inp);
            self
        }
        /// <p>The ID of the interconnect.</p>
        pub fn set_interconnect_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_interconnect_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCustomerMetadata`.
    ///
    /// <p>Get and view a list of customer agreements, along with their signed status and whether the customer is an NNIPartner, NNIPartnerV2, or a nonPartner. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeCustomerMetadata<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_customer_metadata_input::Builder,
    }
    impl<C, M, R> DescribeCustomerMetadata<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCustomerMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCustomerMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCustomerMetadataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCustomerMetadataInputOperationOutputAlias,
                crate::output::DescribeCustomerMetadataOutput,
                crate::error::DescribeCustomerMetadataError,
                crate::input::DescribeCustomerMetadataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeDirectConnectGatewayAssociationProposals`.
    ///
    /// <p>Describes one or more association proposals for connection between a virtual private gateway or transit gateway and a Direct Connect gateway. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDirectConnectGatewayAssociationProposals<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_direct_connect_gateway_association_proposals_input::Builder,
    }
    impl<C, M, R> DescribeDirectConnectGatewayAssociationProposals<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDirectConnectGatewayAssociationProposals`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::DescribeDirectConnectGatewayAssociationProposalsOutput, aws_smithy_http::result::SdkError<crate::error::DescribeDirectConnectGatewayAssociationProposalsError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::DescribeDirectConnectGatewayAssociationProposalsInputOperationOutputAlias,
                                    crate::output::DescribeDirectConnectGatewayAssociationProposalsOutput,
                                    crate::error::DescribeDirectConnectGatewayAssociationProposalsError,
                                    crate::input::DescribeDirectConnectGatewayAssociationProposalsInputOperationRetryAlias>,
                                {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.direct_connect_gateway_id(inp);
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_direct_connect_gateway_id(input);
            self
        }
        /// <p>The ID of the proposal.</p>
        pub fn proposal_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.proposal_id(inp);
            self
        }
        /// <p>The ID of the proposal.</p>
        pub fn set_proposal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_proposal_id(input);
            self
        }
        /// <p>The ID of the associated gateway.</p>
        pub fn associated_gateway_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.associated_gateway_id(inp);
            self
        }
        /// <p>The ID of the associated gateway.</p>
        pub fn set_associated_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_associated_gateway_id(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are
        /// returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are
        /// returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDirectConnectGatewayAssociations`.
    ///
    /// <p>Lists the associations between your Direct Connect gateways and virtual private gateways and transit gateways. You must specify one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>A Direct Connect gateway</p>
    /// <p>The response contains all virtual private gateways and transit gateways associated with the Direct Connect gateway.</p>
    /// </li>
    /// <li>
    /// <p>A virtual private gateway</p>
    /// <p>The response contains the Direct Connect gateway.</p>
    /// </li>
    /// <li>
    /// <p>A transit gateway</p>
    /// <p>The response contains the Direct Connect gateway.</p>
    /// </li>
    /// <li>
    /// <p>A Direct Connect gateway and a virtual private gateway</p>
    /// <p>The response contains the association between the Direct Connect gateway and virtual private gateway.</p>
    /// </li>
    /// <li>
    /// <p>A Direct Connect gateway and a transit gateway</p>
    /// <p>The response contains the association between the Direct Connect gateway and transit gateway.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDirectConnectGatewayAssociations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_direct_connect_gateway_associations_input::Builder,
    }
    impl<C, M, R> DescribeDirectConnectGatewayAssociations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDirectConnectGatewayAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDirectConnectGatewayAssociationsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeDirectConnectGatewayAssociationsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDirectConnectGatewayAssociationsInputOperationOutputAlias,
                crate::output::DescribeDirectConnectGatewayAssociationsOutput,
                crate::error::DescribeDirectConnectGatewayAssociationsError,
                crate::input::DescribeDirectConnectGatewayAssociationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Direct Connect gateway association.</p>
        pub fn association_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_id(inp);
            self
        }
        /// <p>The ID of the Direct Connect gateway association.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_id(input);
            self
        }
        /// <p>The ID of the associated gateway.</p>
        pub fn associated_gateway_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.associated_gateway_id(inp);
            self
        }
        /// <p>The ID of the associated gateway.</p>
        pub fn set_associated_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_associated_gateway_id(input);
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.direct_connect_gateway_id(inp);
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_direct_connect_gateway_id(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are
        /// returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are
        /// returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token provided in the previous call to retrieve the next page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token provided in the previous call to retrieve the next page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The ID of the virtual private gateway or transit gateway.</p>
        pub fn virtual_gateway_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_gateway_id(inp);
            self
        }
        /// <p>The ID of the virtual private gateway or transit gateway.</p>
        pub fn set_virtual_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_gateway_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDirectConnectGatewayAttachments`.
    ///
    /// <p>Lists the attachments between your Direct Connect gateways and virtual interfaces. You must specify
    /// a Direct Connect gateway, a virtual interface, or both. If you specify a Direct Connect gateway, the response contains
    /// all virtual interfaces attached to the Direct Connect gateway. If you specify a virtual interface, the
    /// response contains all Direct Connect gateways attached to the virtual interface. If you specify both,
    /// the response contains the attachment between the Direct Connect gateway and the virtual interface.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDirectConnectGatewayAttachments<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_direct_connect_gateway_attachments_input::Builder,
    }
    impl<C, M, R> DescribeDirectConnectGatewayAttachments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDirectConnectGatewayAttachments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDirectConnectGatewayAttachmentsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeDirectConnectGatewayAttachmentsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDirectConnectGatewayAttachmentsInputOperationOutputAlias,
                crate::output::DescribeDirectConnectGatewayAttachmentsOutput,
                crate::error::DescribeDirectConnectGatewayAttachmentsError,
                crate::input::DescribeDirectConnectGatewayAttachmentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.direct_connect_gateway_id(inp);
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_direct_connect_gateway_id(input);
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_interface_id(inp);
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_interface_id(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are
        /// returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are
        /// returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token provided in the previous call to retrieve the next page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token provided in the previous call to retrieve the next page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDirectConnectGateways`.
    ///
    /// <p>Lists all your Direct Connect gateways or only the specified Direct Connect gateway. Deleted Direct Connect gateways are not returned.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDirectConnectGateways<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_direct_connect_gateways_input::Builder,
    }
    impl<C, M, R> DescribeDirectConnectGateways<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDirectConnectGateways`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDirectConnectGatewaysOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDirectConnectGatewaysError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDirectConnectGatewaysInputOperationOutputAlias,
                crate::output::DescribeDirectConnectGatewaysOutput,
                crate::error::DescribeDirectConnectGatewaysError,
                crate::input::DescribeDirectConnectGatewaysInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.direct_connect_gateway_id(inp);
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_direct_connect_gateway_id(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are
        /// returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are
        /// returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token provided in the previous call to retrieve the next page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token provided in the previous call to retrieve the next page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeHostedConnections`.
    ///
    /// <p>Lists the hosted connections that have been provisioned on the specified
    /// interconnect or link aggregation group (LAG).</p>
    /// <note>
    /// <p>Intended for use by Direct Connect Partners only.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeHostedConnections<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_hosted_connections_input::Builder,
    }
    impl<C, M, R> DescribeHostedConnections<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeHostedConnections`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeHostedConnectionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeHostedConnectionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeHostedConnectionsInputOperationOutputAlias,
                crate::output::DescribeHostedConnectionsOutput,
                crate::error::DescribeHostedConnectionsError,
                crate::input::DescribeHostedConnectionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the interconnect or LAG.</p>
        pub fn connection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(inp);
            self
        }
        /// <p>The ID of the interconnect or LAG.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInterconnectLoa`.
    ///
    /// <p>Deprecated. Use <a>DescribeLoa</a> instead.</p>
    /// <p>Gets the LOA-CFA for the specified interconnect.</p>
    /// <p>The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is a document that is used when establishing your cross connect to Amazon Web Services at the colocation facility.
    /// For more information, see <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html">Requesting Cross Connects at Direct Connect Locations</a>
    /// in the <i>Direct Connect User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeInterconnectLoa<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_interconnect_loa_input::Builder,
    }
    impl<C, M, R> DescribeInterconnectLoa<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeInterconnectLoa`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInterconnectLoaOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInterconnectLoaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeInterconnectLoaInputOperationOutputAlias,
                crate::output::DescribeInterconnectLoaOutput,
                crate::error::DescribeInterconnectLoaError,
                crate::input::DescribeInterconnectLoaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the interconnect.</p>
        pub fn interconnect_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.interconnect_id(inp);
            self
        }
        /// <p>The ID of the interconnect.</p>
        pub fn set_interconnect_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_interconnect_id(input);
            self
        }
        /// <p>The name of the service provider who establishes connectivity on your behalf. If you supply this parameter, the LOA-CFA lists the provider name alongside your company name as the requester of the cross connect.</p>
        pub fn provider_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider_name(inp);
            self
        }
        /// <p>The name of the service provider who establishes connectivity on your behalf. If you supply this parameter, the LOA-CFA lists the provider name alongside your company name as the requester of the cross connect.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provider_name(input);
            self
        }
        /// <p>The standard media type for the LOA-CFA document. The only supported value is application/pdf.</p>
        pub fn loa_content_type(mut self, inp: crate::model::LoaContentType) -> Self {
            self.inner = self.inner.loa_content_type(inp);
            self
        }
        /// <p>The standard media type for the LOA-CFA document. The only supported value is application/pdf.</p>
        pub fn set_loa_content_type(
            mut self,
            input: std::option::Option<crate::model::LoaContentType>,
        ) -> Self {
            self.inner = self.inner.set_loa_content_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInterconnects`.
    ///
    /// <p>Lists the interconnects owned by the Amazon Web Services account or only the specified interconnect.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeInterconnects<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_interconnects_input::Builder,
    }
    impl<C, M, R> DescribeInterconnects<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeInterconnects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInterconnectsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInterconnectsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeInterconnectsInputOperationOutputAlias,
                crate::output::DescribeInterconnectsOutput,
                crate::error::DescribeInterconnectsError,
                crate::input::DescribeInterconnectsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the interconnect.</p>
        pub fn interconnect_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.interconnect_id(inp);
            self
        }
        /// <p>The ID of the interconnect.</p>
        pub fn set_interconnect_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_interconnect_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLags`.
    ///
    /// <p>Describes all your link aggregation groups (LAG) or the specified LAG.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeLags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_lags_input::Builder,
    }
    impl<C, M, R> DescribeLags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeLags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLagsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeLagsInputOperationOutputAlias,
                crate::output::DescribeLagsOutput,
                crate::error::DescribeLagsError,
                crate::input::DescribeLagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lag_id(inp);
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lag_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLoa`.
    ///
    /// <p>Gets the LOA-CFA for a connection, interconnect, or link aggregation group (LAG).</p>
    /// <p>The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is a document that is used when establishing
    /// your cross connect to Amazon Web Services at the colocation facility. For more information, see <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html">Requesting Cross Connects at Direct Connect Locations</a>
    /// in the <i>Direct Connect User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeLoa<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_loa_input::Builder,
    }
    impl<C, M, R> DescribeLoa<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeLoa`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLoaOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLoaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeLoaInputOperationOutputAlias,
                crate::output::DescribeLoaOutput,
                crate::error::DescribeLoaError,
                crate::input::DescribeLoaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a connection, LAG, or interconnect.</p>
        pub fn connection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(inp);
            self
        }
        /// <p>The ID of a connection, LAG, or interconnect.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>The name of the service provider who establishes connectivity on your behalf. If you specify this parameter, the
        /// LOA-CFA lists the provider name alongside your company name as the requester of the cross connect.</p>
        pub fn provider_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider_name(inp);
            self
        }
        /// <p>The name of the service provider who establishes connectivity on your behalf. If you specify this parameter, the
        /// LOA-CFA lists the provider name alongside your company name as the requester of the cross connect.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provider_name(input);
            self
        }
        /// <p>The standard media type for the LOA-CFA document. The only supported value is application/pdf.</p>
        pub fn loa_content_type(mut self, inp: crate::model::LoaContentType) -> Self {
            self.inner = self.inner.loa_content_type(inp);
            self
        }
        /// <p>The standard media type for the LOA-CFA document. The only supported value is application/pdf.</p>
        pub fn set_loa_content_type(
            mut self,
            input: std::option::Option<crate::model::LoaContentType>,
        ) -> Self {
            self.inner = self.inner.set_loa_content_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLocations`.
    ///
    /// <p>Lists the Direct Connect locations in the current Amazon Web Services Region. These are the locations that can be selected when calling
    /// <a>CreateConnection</a> or <a>CreateInterconnect</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeLocations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_locations_input::Builder,
    }
    impl<C, M, R> DescribeLocations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeLocations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLocationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLocationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeLocationsInputOperationOutputAlias,
                crate::output::DescribeLocationsOutput,
                crate::error::DescribeLocationsError,
                crate::input::DescribeLocationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeRouterConfiguration`.
    ///
    /// <p>
    /// Details about the router.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeRouterConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_router_configuration_input::Builder,
    }
    impl<C, M, R> DescribeRouterConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRouterConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRouterConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRouterConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRouterConfigurationInputOperationOutputAlias,
                crate::output::DescribeRouterConfigurationOutput,
                crate::error::DescribeRouterConfigurationError,
                crate::input::DescribeRouterConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_interface_id(inp);
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_interface_id(input);
            self
        }
        /// <p>Identifies the router by a combination of vendor, platform, and software version. For example, <code>CiscoSystemsInc-2900SeriesRouters-IOS124</code>.</p>
        pub fn router_type_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.router_type_identifier(inp);
            self
        }
        /// <p>Identifies the router by a combination of vendor, platform, and software version. For example, <code>CiscoSystemsInc-2900SeriesRouters-IOS124</code>.</p>
        pub fn set_router_type_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_router_type_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTags`.
    ///
    /// <p>Describes the tags associated with the specified Direct Connect resources.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_tags_input::Builder,
    }
    impl<C, M, R> DescribeTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTagsInputOperationOutputAlias,
                crate::output::DescribeTagsOutput,
                crate::error::DescribeTagsError,
                crate::input::DescribeTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `resourceArns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
        pub fn resource_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arns(inp);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeVirtualGateways`.
    ///
    /// <p>Lists the virtual private gateways owned by the Amazon Web Services account.</p>
    /// <p>You can create one or more Direct Connect private virtual interfaces linked to a virtual private gateway.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeVirtualGateways<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_virtual_gateways_input::Builder,
    }
    impl<C, M, R> DescribeVirtualGateways<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeVirtualGateways`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeVirtualGatewaysOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeVirtualGatewaysError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeVirtualGatewaysInputOperationOutputAlias,
                crate::output::DescribeVirtualGatewaysOutput,
                crate::error::DescribeVirtualGatewaysError,
                crate::input::DescribeVirtualGatewaysInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeVirtualInterfaces`.
    ///
    /// <p>Displays all virtual interfaces for an Amazon Web Services account. Virtual interfaces deleted fewer
    /// than 15 minutes before you make the request are also returned. If you specify a
    /// connection ID, only the virtual interfaces associated with the connection are returned.
    /// If you specify a virtual interface ID, then only a single virtual interface is returned.</p>
    /// <p>A virtual interface (VLAN) transmits the traffic between the Direct Connect location and the customer network.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeVirtualInterfaces<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_virtual_interfaces_input::Builder,
    }
    impl<C, M, R> DescribeVirtualInterfaces<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeVirtualInterfaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeVirtualInterfacesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeVirtualInterfacesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeVirtualInterfacesInputOperationOutputAlias,
                crate::output::DescribeVirtualInterfacesOutput,
                crate::error::DescribeVirtualInterfacesError,
                crate::input::DescribeVirtualInterfacesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(inp);
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_interface_id(inp);
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_interface_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateConnectionFromLag`.
    ///
    /// <p>Disassociates a connection from a link aggregation group (LAG). The connection is
    /// interrupted and re-established as a standalone connection (the connection is not
    /// deleted; to delete the connection, use the <a>DeleteConnection</a> request).
    /// If the LAG has associated virtual interfaces or hosted connections, they remain
    /// associated with the LAG. A disassociated connection owned by an Direct Connect Partner is
    /// automatically converted to an interconnect.</p>
    /// <p>If disassociating the connection would cause the LAG to fall below its setting for
    /// minimum number of operational connections, the request fails, except when it's the last
    /// member of the LAG. If all connections are disassociated, the LAG continues to exist as
    /// an empty LAG with no physical connections. </p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateConnectionFromLag<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_connection_from_lag_input::Builder,
    }
    impl<C, M, R> DisassociateConnectionFromLag<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateConnectionFromLag`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateConnectionFromLagOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateConnectionFromLagError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateConnectionFromLagInputOperationOutputAlias,
                crate::output::DisassociateConnectionFromLagOutput,
                crate::error::DisassociateConnectionFromLagError,
                crate::input::DisassociateConnectionFromLagInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(inp);
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lag_id(inp);
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lag_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateMacSecKey`.
    ///
    /// <p>Removes the association between a MAC Security (MACsec) security key and an Direct Connect dedicated connection.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateMacSecKey<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_mac_sec_key_input::Builder,
    }
    impl<C, M, R> DisassociateMacSecKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateMacSecKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateMacSecKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateMacSecKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateMacSecKeyInputOperationOutputAlias,
                crate::output::DisassociateMacSecKeyOutput,
                crate::error::DisassociateMacSecKeyError,
                crate::input::DisassociateMacSecKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).</p>
        /// <p>You can use <a>DescribeConnections</a> or <a>DescribeLags</a> to retrieve connection ID.</p>
        pub fn connection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(inp);
            self
        }
        /// <p>The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).</p>
        /// <p>You can use <a>DescribeConnections</a> or <a>DescribeLags</a> to retrieve connection ID.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key.</p>
        /// <p>You can use <a>DescribeConnections</a> to retrieve the ARN of the MAC Security (MACsec) secret key.</p>
        pub fn secret_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key.</p>
        /// <p>You can use <a>DescribeConnections</a> to retrieve the ARN of the MAC Security (MACsec) secret key.</p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVirtualInterfaceTestHistory`.
    ///
    /// <p>Lists the virtual interface failover test history.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListVirtualInterfaceTestHistory<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_virtual_interface_test_history_input::Builder,
    }
    impl<C, M, R> ListVirtualInterfaceTestHistory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListVirtualInterfaceTestHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVirtualInterfaceTestHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::ListVirtualInterfaceTestHistoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListVirtualInterfaceTestHistoryInputOperationOutputAlias,
                crate::output::ListVirtualInterfaceTestHistoryOutput,
                crate::error::ListVirtualInterfaceTestHistoryError,
                crate::input::ListVirtualInterfaceTestHistoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the virtual interface failover test.</p>
        pub fn test_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.test_id(inp);
            self
        }
        /// <p>The ID of the virtual interface failover test.</p>
        pub fn set_test_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_test_id(input);
            self
        }
        /// <p>The ID of the virtual interface that was tested.</p>
        pub fn virtual_interface_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_interface_id(inp);
            self
        }
        /// <p>The ID of the virtual interface that was tested.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_interface_id(input);
            self
        }
        /// Appends an item to `bgpPeers`.
        ///
        /// To override the contents of this collection use [`set_bgp_peers`](Self::set_bgp_peers).
        ///
        /// <p>The BGP peers that were placed in the DOWN state during the virtual interface failover test.</p>
        pub fn bgp_peers(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bgp_peers(inp);
            self
        }
        /// <p>The BGP peers that were placed in the DOWN state during the virtual interface failover test.</p>
        pub fn set_bgp_peers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_bgp_peers(input);
            self
        }
        /// <p>The status of the virtual interface failover test.</p>
        pub fn status(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>The status of the virtual interface failover test.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are
        /// returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are
        /// returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartBgpFailoverTest`.
    ///
    /// <p>Starts the virtual interface failover test that verifies your configuration meets your resiliency requirements by placing the BGP peering session in the DOWN state. You can then send traffic to verify that there are no outages.</p>
    /// <p>You can run the test on public, private, transit, and hosted virtual interfaces.</p>
    /// <p>You can use <a href="https://docs.aws.amazon.com/directconnect/latest/APIReference/API_ListVirtualInterfaceTestHistory.html">ListVirtualInterfaceTestHistory</a> to view the virtual interface test history.</p>
    /// <p>If you need to stop the test before the test interval completes, use <a href="https://docs.aws.amazon.com/directconnect/latest/APIReference/API_StopBgpFailoverTest.html">StopBgpFailoverTest</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartBgpFailoverTest<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_bgp_failover_test_input::Builder,
    }
    impl<C, M, R> StartBgpFailoverTest<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartBgpFailoverTest`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartBgpFailoverTestOutput,
            aws_smithy_http::result::SdkError<crate::error::StartBgpFailoverTestError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartBgpFailoverTestInputOperationOutputAlias,
                crate::output::StartBgpFailoverTestOutput,
                crate::error::StartBgpFailoverTestError,
                crate::input::StartBgpFailoverTestInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the virtual interface you want to test.</p>
        pub fn virtual_interface_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_interface_id(inp);
            self
        }
        /// <p>The ID of the virtual interface you want to test.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_interface_id(input);
            self
        }
        /// Appends an item to `bgpPeers`.
        ///
        /// To override the contents of this collection use [`set_bgp_peers`](Self::set_bgp_peers).
        ///
        /// <p>The BGP peers to place in the DOWN state.</p>
        pub fn bgp_peers(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bgp_peers(inp);
            self
        }
        /// <p>The BGP peers to place in the DOWN state.</p>
        pub fn set_bgp_peers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_bgp_peers(input);
            self
        }
        /// <p>The time in minutes that the virtual interface failover test will last.</p>
        /// <p>Maximum value: 180 minutes (3 hours).</p>
        /// <p>Default: 180 minutes (3 hours).</p>
        pub fn test_duration_in_minutes(mut self, inp: i32) -> Self {
            self.inner = self.inner.test_duration_in_minutes(inp);
            self
        }
        /// <p>The time in minutes that the virtual interface failover test will last.</p>
        /// <p>Maximum value: 180 minutes (3 hours).</p>
        /// <p>Default: 180 minutes (3 hours).</p>
        pub fn set_test_duration_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_test_duration_in_minutes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopBgpFailoverTest`.
    ///
    /// <p>Stops the virtual interface failover test.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopBgpFailoverTest<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_bgp_failover_test_input::Builder,
    }
    impl<C, M, R> StopBgpFailoverTest<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopBgpFailoverTest`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopBgpFailoverTestOutput,
            aws_smithy_http::result::SdkError<crate::error::StopBgpFailoverTestError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopBgpFailoverTestInputOperationOutputAlias,
                crate::output::StopBgpFailoverTestOutput,
                crate::error::StopBgpFailoverTestError,
                crate::input::StopBgpFailoverTestInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the virtual interface you no longer want to test.</p>
        pub fn virtual_interface_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_interface_id(inp);
            self
        }
        /// <p>The ID of the virtual interface you no longer want to test.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_interface_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds the specified tags to the specified Direct Connect resource. Each resource can have a maximum of 50 tags.</p>
    /// <p>Each tag consists of a key and an optional value. If a tag with the same key is already associated with the resource, this action updates its value.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to add.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from the specified Direct Connect resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys of the tags to remove.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The tag keys of the tags to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConnection`.
    ///
    /// <p>Updates the Direct Connect dedicated connection configuration.</p>
    /// <p>You can update the following parameters for a connection:</p>
    /// <ul>
    /// <li>
    /// <p>The connection name</p>
    /// </li>
    /// <li>
    /// <p>The connection's MAC Security (MACsec) encryption mode.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct UpdateConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_connection_input::Builder,
    }
    impl<C, M, R> UpdateConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateConnectionInputOperationOutputAlias,
                crate::output::UpdateConnectionOutput,
                crate::error::UpdateConnectionError,
                crate::input::UpdateConnectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the dedicated connection.</p>
        /// <p>You can use <a>DescribeConnections</a> to retrieve the connection ID.</p>
        pub fn connection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_id(inp);
            self
        }
        /// <p>The ID of the dedicated connection.</p>
        /// <p>You can use <a>DescribeConnections</a> to retrieve the connection ID.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_id(input);
            self
        }
        /// <p>The name of the connection.</p>
        pub fn connection_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_name(inp);
            self
        }
        /// <p>The name of the connection.</p>
        pub fn set_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_name(input);
            self
        }
        /// <p>The connection MAC Security (MACsec) encryption mode.</p>
        /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
        pub fn encryption_mode(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.encryption_mode(inp);
            self
        }
        /// <p>The connection MAC Security (MACsec) encryption mode.</p>
        /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_encryption_mode(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDirectConnectGateway`.
    ///
    /// <p>Updates the name of a current Direct Connect gateway.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDirectConnectGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_direct_connect_gateway_input::Builder,
    }
    impl<C, M, R> UpdateDirectConnectGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDirectConnectGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDirectConnectGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDirectConnectGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDirectConnectGatewayInputOperationOutputAlias,
                crate::output::UpdateDirectConnectGatewayOutput,
                crate::error::UpdateDirectConnectGatewayError,
                crate::input::UpdateDirectConnectGatewayInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Direct Connect gateway to update.</p>
        pub fn direct_connect_gateway_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.direct_connect_gateway_id(inp);
            self
        }
        /// <p>The ID of the Direct Connect gateway to update.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_direct_connect_gateway_id(input);
            self
        }
        /// <p>The new name for the Direct Connect gateway.</p>
        pub fn new_direct_connect_gateway_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.new_direct_connect_gateway_name(inp);
            self
        }
        /// <p>The new name for the Direct Connect gateway.</p>
        pub fn set_new_direct_connect_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_new_direct_connect_gateway_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDirectConnectGatewayAssociation`.
    ///
    /// <p>Updates the specified attributes of the Direct Connect gateway association.</p>
    /// <p>Add or remove prefixes from the association.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDirectConnectGatewayAssociation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_direct_connect_gateway_association_input::Builder,
    }
    impl<C, M, R> UpdateDirectConnectGatewayAssociation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDirectConnectGatewayAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDirectConnectGatewayAssociationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateDirectConnectGatewayAssociationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDirectConnectGatewayAssociationInputOperationOutputAlias,
                crate::output::UpdateDirectConnectGatewayAssociationOutput,
                crate::error::UpdateDirectConnectGatewayAssociationError,
                crate::input::UpdateDirectConnectGatewayAssociationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Direct Connect gateway association.</p>
        pub fn association_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_id(inp);
            self
        }
        /// <p>The ID of the Direct Connect gateway association.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_id(input);
            self
        }
        /// Appends an item to `addAllowedPrefixesToDirectConnectGateway`.
        ///
        /// To override the contents of this collection use [`set_add_allowed_prefixes_to_direct_connect_gateway`](Self::set_add_allowed_prefixes_to_direct_connect_gateway).
        ///
        /// <p>The Amazon VPC prefixes to advertise to the Direct Connect gateway.</p>
        pub fn add_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            inp: impl Into<crate::model::RouteFilterPrefix>,
        ) -> Self {
            self.inner = self
                .inner
                .add_allowed_prefixes_to_direct_connect_gateway(inp);
            self
        }
        /// <p>The Amazon VPC prefixes to advertise to the Direct Connect gateway.</p>
        pub fn set_add_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_add_allowed_prefixes_to_direct_connect_gateway(input);
            self
        }
        /// Appends an item to `removeAllowedPrefixesToDirectConnectGateway`.
        ///
        /// To override the contents of this collection use [`set_remove_allowed_prefixes_to_direct_connect_gateway`](Self::set_remove_allowed_prefixes_to_direct_connect_gateway).
        ///
        /// <p>The Amazon VPC prefixes to no longer advertise to the Direct Connect gateway.</p>
        pub fn remove_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            inp: impl Into<crate::model::RouteFilterPrefix>,
        ) -> Self {
            self.inner = self
                .inner
                .remove_allowed_prefixes_to_direct_connect_gateway(inp);
            self
        }
        /// <p>The Amazon VPC prefixes to no longer advertise to the Direct Connect gateway.</p>
        pub fn set_remove_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_remove_allowed_prefixes_to_direct_connect_gateway(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLag`.
    ///
    /// <p>Updates the attributes of the specified link aggregation group (LAG).</p>
    /// <p>You can update the following LAG attributes:</p>
    /// <ul>
    /// <li>
    /// <p>The name of the LAG.</p>
    /// </li>
    /// <li>
    /// <p>The value for the minimum number of connections that must be operational
    /// for the LAG itself to be operational. </p>
    /// </li>
    /// <li>
    /// <p>The LAG's MACsec encryption mode.</p>
    /// <p>Amazon Web Services assigns this value to each connection which is part of the LAG.</p>
    /// </li>
    /// <li>
    /// <p>The tags</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>If you adjust the threshold value for the minimum number of operational connections, ensure
    /// that the new value does not cause the LAG to fall below the threshold and become
    /// non-operational.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct UpdateLag<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_lag_input::Builder,
    }
    impl<C, M, R> UpdateLag<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLag`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLagOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLagError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLagInputOperationOutputAlias,
                crate::output::UpdateLagOutput,
                crate::error::UpdateLagError,
                crate::input::UpdateLagInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lag_id(inp);
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lag_id(input);
            self
        }
        /// <p>The name of the LAG.</p>
        pub fn lag_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lag_name(inp);
            self
        }
        /// <p>The name of the LAG.</p>
        pub fn set_lag_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lag_name(input);
            self
        }
        /// <p>The minimum number of physical connections that must be operational for the LAG itself to be operational.</p>
        pub fn minimum_links(mut self, inp: i32) -> Self {
            self.inner = self.inner.minimum_links(inp);
            self
        }
        /// <p>The minimum number of physical connections that must be operational for the LAG itself to be operational.</p>
        pub fn set_minimum_links(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_minimum_links(input);
            self
        }
        /// <p>The LAG MAC Security (MACsec) encryption mode.</p>
        /// <p>Amazon Web Services applies the value to all connections which are part of the LAG.</p>
        pub fn encryption_mode(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.encryption_mode(inp);
            self
        }
        /// <p>The LAG MAC Security (MACsec) encryption mode.</p>
        /// <p>Amazon Web Services applies the value to all connections which are part of the LAG.</p>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_encryption_mode(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateVirtualInterfaceAttributes`.
    ///
    /// <p>Updates the specified attributes of the specified virtual private interface.</p>
    /// <p>Setting the MTU of a virtual interface to 9001 (jumbo frames) can cause an update to
    /// the underlying physical connection if it wasn't updated to support jumbo frames. Updating
    /// the connection disrupts network connectivity for all virtual interfaces associated with
    /// the connection for up to 30 seconds. To check whether your connection supports jumbo
    /// frames, call <a>DescribeConnections</a>. To check whether your virtual q
    /// interface supports jumbo frames, call <a>DescribeVirtualInterfaces</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateVirtualInterfaceAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_virtual_interface_attributes_input::Builder,
    }
    impl<C, M, R> UpdateVirtualInterfaceAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateVirtualInterfaceAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateVirtualInterfaceAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateVirtualInterfaceAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateVirtualInterfaceAttributesInputOperationOutputAlias,
                crate::output::UpdateVirtualInterfaceAttributesOutput,
                crate::error::UpdateVirtualInterfaceAttributesError,
                crate::input::UpdateVirtualInterfaceAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the virtual private interface.</p>
        pub fn virtual_interface_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_interface_id(inp);
            self
        }
        /// <p>The ID of the virtual private interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_interface_id(input);
            self
        }
        /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
        pub fn mtu(mut self, inp: i32) -> Self {
            self.inner = self.inner.mtu(inp);
            self
        }
        /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
        pub fn set_mtu(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_mtu(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
