// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// <p>A tag key was specified more than once.</p>
    DuplicateTagKeysException(crate::error::DuplicateTagKeysException),
    /// <p>You have reached the limit on the number of tags that can be assigned.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::DirectConnectClientException(inner) => inner.fmt(f),
            Error::DirectConnectServerException(inner) => inner.fmt(f),
            Error::DuplicateTagKeysException(inner) => inner.fmt(f),
            Error::TooManyTagsException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::AcceptDirectConnectGatewayAssociationProposalError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::AcceptDirectConnectGatewayAssociationProposalError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AcceptDirectConnectGatewayAssociationProposalErrorKind::DirectConnectClientException(inner) => Error::DirectConnectClientException(inner),
                crate::error::AcceptDirectConnectGatewayAssociationProposalErrorKind::DirectConnectServerException(inner) => Error::DirectConnectServerException(inner),
                crate::error::AcceptDirectConnectGatewayAssociationProposalErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::AllocateConnectionOnInterconnectError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::AllocateConnectionOnInterconnectError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AllocateConnectionOnInterconnectErrorKind::DirectConnectClientException(inner) => Error::DirectConnectClientException(inner),
                crate::error::AllocateConnectionOnInterconnectErrorKind::DirectConnectServerException(inner) => Error::DirectConnectServerException(inner),
                crate::error::AllocateConnectionOnInterconnectErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AllocateHostedConnectionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AllocateHostedConnectionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AllocateHostedConnectionErrorKind::DirectConnectClientException(
                    inner,
                ) => Error::DirectConnectClientException(inner),
                crate::error::AllocateHostedConnectionErrorKind::DirectConnectServerException(
                    inner,
                ) => Error::DirectConnectServerException(inner),
                crate::error::AllocateHostedConnectionErrorKind::DuplicateTagKeysException(
                    inner,
                ) => Error::DuplicateTagKeysException(inner),
                crate::error::AllocateHostedConnectionErrorKind::TooManyTagsException(inner) => {
                    Error::TooManyTagsException(inner)
                }
                crate::error::AllocateHostedConnectionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::AllocatePrivateVirtualInterfaceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::AllocatePrivateVirtualInterfaceError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AllocatePrivateVirtualInterfaceErrorKind::DirectConnectClientException(inner) => Error::DirectConnectClientException(inner),
                crate::error::AllocatePrivateVirtualInterfaceErrorKind::DirectConnectServerException(inner) => Error::DirectConnectServerException(inner),
                crate::error::AllocatePrivateVirtualInterfaceErrorKind::DuplicateTagKeysException(inner) => Error::DuplicateTagKeysException(inner),
                crate::error::AllocatePrivateVirtualInterfaceErrorKind::TooManyTagsException(inner) => Error::TooManyTagsException(inner),
                crate::error::AllocatePrivateVirtualInterfaceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::AllocatePublicVirtualInterfaceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::AllocatePublicVirtualInterfaceError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AllocatePublicVirtualInterfaceErrorKind::DirectConnectClientException(inner) => Error::DirectConnectClientException(inner),
                crate::error::AllocatePublicVirtualInterfaceErrorKind::DirectConnectServerException(inner) => Error::DirectConnectServerException(inner),
                crate::error::AllocatePublicVirtualInterfaceErrorKind::DuplicateTagKeysException(inner) => Error::DuplicateTagKeysException(inner),
                crate::error::AllocatePublicVirtualInterfaceErrorKind::TooManyTagsException(inner) => Error::TooManyTagsException(inner),
                crate::error::AllocatePublicVirtualInterfaceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::AllocateTransitVirtualInterfaceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::AllocateTransitVirtualInterfaceError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AllocateTransitVirtualInterfaceErrorKind::DirectConnectClientException(inner) => Error::DirectConnectClientException(inner),
                crate::error::AllocateTransitVirtualInterfaceErrorKind::DirectConnectServerException(inner) => Error::DirectConnectServerException(inner),
                crate::error::AllocateTransitVirtualInterfaceErrorKind::DuplicateTagKeysException(inner) => Error::DuplicateTagKeysException(inner),
                crate::error::AllocateTransitVirtualInterfaceErrorKind::TooManyTagsException(inner) => Error::TooManyTagsException(inner),
                crate::error::AllocateTransitVirtualInterfaceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AssociateConnectionWithLagError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AssociateConnectionWithLagError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AssociateConnectionWithLagErrorKind::DirectConnectClientException(
                    inner,
                ) => Error::DirectConnectClientException(inner),
                crate::error::AssociateConnectionWithLagErrorKind::DirectConnectServerException(
                    inner,
                ) => Error::DirectConnectServerException(inner),
                crate::error::AssociateConnectionWithLagErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AssociateHostedConnectionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AssociateHostedConnectionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AssociateHostedConnectionErrorKind::DirectConnectClientException(
                    inner,
                ) => Error::DirectConnectClientException(inner),
                crate::error::AssociateHostedConnectionErrorKind::DirectConnectServerException(
                    inner,
                ) => Error::DirectConnectServerException(inner),
                crate::error::AssociateHostedConnectionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AssociateMacSecKeyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AssociateMacSecKeyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AssociateMacSecKeyErrorKind::DirectConnectClientException(inner) => {
                    Error::DirectConnectClientException(inner)
                }
                crate::error::AssociateMacSecKeyErrorKind::DirectConnectServerException(inner) => {
                    Error::DirectConnectServerException(inner)
                }
                crate::error::AssociateMacSecKeyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AssociateVirtualInterfaceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AssociateVirtualInterfaceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AssociateVirtualInterfaceErrorKind::DirectConnectClientException(
                    inner,
                ) => Error::DirectConnectClientException(inner),
                crate::error::AssociateVirtualInterfaceErrorKind::DirectConnectServerException(
                    inner,
                ) => Error::DirectConnectServerException(inner),
                crate::error::AssociateVirtualInterfaceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ConfirmConnectionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ConfirmConnectionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ConfirmConnectionErrorKind::DirectConnectClientException(inner) => {
                    Error::DirectConnectClientException(inner)
                }
                crate::error::ConfirmConnectionErrorKind::DirectConnectServerException(inner) => {
                    Error::DirectConnectServerException(inner)
                }
                crate::error::ConfirmConnectionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ConfirmCustomerAgreementError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ConfirmCustomerAgreementError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ConfirmCustomerAgreementErrorKind::DirectConnectClientException(
                    inner,
                ) => Error::DirectConnectClientException(inner),
                crate::error::ConfirmCustomerAgreementErrorKind::DirectConnectServerException(
                    inner,
                ) => Error::DirectConnectServerException(inner),
                crate::error::ConfirmCustomerAgreementErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ConfirmPrivateVirtualInterfaceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ConfirmPrivateVirtualInterfaceError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ConfirmPrivateVirtualInterfaceErrorKind::DirectConnectClientException(inner) => Error::DirectConnectClientException(inner),
                crate::error::ConfirmPrivateVirtualInterfaceErrorKind::DirectConnectServerException(inner) => Error::DirectConnectServerException(inner),
                crate::error::ConfirmPrivateVirtualInterfaceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ConfirmPublicVirtualInterfaceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ConfirmPublicVirtualInterfaceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ConfirmPublicVirtualInterfaceErrorKind::DirectConnectClientException(inner) => Error::DirectConnectClientException(inner),
                crate::error::ConfirmPublicVirtualInterfaceErrorKind::DirectConnectServerException(inner) => Error::DirectConnectServerException(inner),
                crate::error::ConfirmPublicVirtualInterfaceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ConfirmTransitVirtualInterfaceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ConfirmTransitVirtualInterfaceError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ConfirmTransitVirtualInterfaceErrorKind::DirectConnectClientException(inner) => Error::DirectConnectClientException(inner),
                crate::error::ConfirmTransitVirtualInterfaceErrorKind::DirectConnectServerException(inner) => Error::DirectConnectServerException(inner),
                crate::error::ConfirmTransitVirtualInterfaceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateBGPPeerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateBGPPeerError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateBGPPeerErrorKind::DirectConnectClientException(inner) => {
                    Error::DirectConnectClientException(inner)
                }
                crate::error::CreateBGPPeerErrorKind::DirectConnectServerException(inner) => {
                    Error::DirectConnectServerException(inner)
                }
                crate::error::CreateBGPPeerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateConnectionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateConnectionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateConnectionErrorKind::DirectConnectClientException(inner) => {
                    Error::DirectConnectClientException(inner)
                }
                crate::error::CreateConnectionErrorKind::DirectConnectServerException(inner) => {
                    Error::DirectConnectServerException(inner)
                }
                crate::error::CreateConnectionErrorKind::DuplicateTagKeysException(inner) => {
                    Error::DuplicateTagKeysException(inner)
                }
                crate::error::CreateConnectionErrorKind::TooManyTagsException(inner) => {
                    Error::TooManyTagsException(inner)
                }
                crate::error::CreateConnectionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDirectConnectGatewayError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDirectConnectGatewayError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateDirectConnectGatewayErrorKind::DirectConnectClientException(
                    inner,
                ) => Error::DirectConnectClientException(inner),
                crate::error::CreateDirectConnectGatewayErrorKind::DirectConnectServerException(
                    inner,
                ) => Error::DirectConnectServerException(inner),
                crate::error::CreateDirectConnectGatewayErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::CreateDirectConnectGatewayAssociationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::CreateDirectConnectGatewayAssociationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateDirectConnectGatewayAssociationErrorKind::DirectConnectClientException(inner) => Error::DirectConnectClientException(inner),
                crate::error::CreateDirectConnectGatewayAssociationErrorKind::DirectConnectServerException(inner) => Error::DirectConnectServerException(inner),
                crate::error::CreateDirectConnectGatewayAssociationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::CreateDirectConnectGatewayAssociationProposalError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::CreateDirectConnectGatewayAssociationProposalError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateDirectConnectGatewayAssociationProposalErrorKind::DirectConnectClientException(inner) => Error::DirectConnectClientException(inner),
                crate::error::CreateDirectConnectGatewayAssociationProposalErrorKind::DirectConnectServerException(inner) => Error::DirectConnectServerException(inner),
                crate::error::CreateDirectConnectGatewayAssociationProposalErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateInterconnectError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateInterconnectError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateInterconnectErrorKind::DirectConnectClientException(inner) => {
                    Error::DirectConnectClientException(inner)
                }
                crate::error::CreateInterconnectErrorKind::DirectConnectServerException(inner) => {
                    Error::DirectConnectServerException(inner)
                }
                crate::error::CreateInterconnectErrorKind::DuplicateTagKeysException(inner) => {
                    Error::DuplicateTagKeysException(inner)
                }
                crate::error::CreateInterconnectErrorKind::TooManyTagsException(inner) => {
                    Error::TooManyTagsException(inner)
                }
                crate::error::CreateInterconnectErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateLagError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateLagError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateLagErrorKind::DirectConnectClientException(inner) => {
                    Error::DirectConnectClientException(inner)
                }
                crate::error::CreateLagErrorKind::DirectConnectServerException(inner) => {
                    Error::DirectConnectServerException(inner)
                }
                crate::error::CreateLagErrorKind::DuplicateTagKeysException(inner) => {
                    Error::DuplicateTagKeysException(inner)
                }
                crate::error::CreateLagErrorKind::TooManyTagsException(inner) => {
                    Error::TooManyTagsException(inner)
                }
                crate::error::CreateLagErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreatePrivateVirtualInterfaceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreatePrivateVirtualInterfaceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreatePrivateVirtualInterfaceErrorKind::DirectConnectClientException(inner) => Error::DirectConnectClientException(inner),
                crate::error::CreatePrivateVirtualInterfaceErrorKind::DirectConnectServerException(inner) => Error::DirectConnectServerException(inner),
                crate::error::CreatePrivateVirtualInterfaceErrorKind::DuplicateTagKeysException(inner) => Error::DuplicateTagKeysException(inner),
                crate::error::CreatePrivateVirtualInterfaceErrorKind::TooManyTagsException(inner) => Error::TooManyTagsException(inner),
                crate::error::CreatePrivateVirtualInterfaceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreatePublicVirtualInterfaceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreatePublicVirtualInterfaceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreatePublicVirtualInterfaceErrorKind::DirectConnectClientException(inner) => Error::DirectConnectClientException(inner),
                crate::error::CreatePublicVirtualInterfaceErrorKind::DirectConnectServerException(inner) => Error::DirectConnectServerException(inner),
                crate::error::CreatePublicVirtualInterfaceErrorKind::DuplicateTagKeysException(inner) => Error::DuplicateTagKeysException(inner),
                crate::error::CreatePublicVirtualInterfaceErrorKind::TooManyTagsException(inner) => Error::TooManyTagsException(inner),
                crate::error::CreatePublicVirtualInterfaceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateTransitVirtualInterfaceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateTransitVirtualInterfaceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateTransitVirtualInterfaceErrorKind::DirectConnectClientException(inner) => Error::DirectConnectClientException(inner),
                crate::error::CreateTransitVirtualInterfaceErrorKind::DirectConnectServerException(inner) => Error::DirectConnectServerException(inner),
                crate::error::CreateTransitVirtualInterfaceErrorKind::DuplicateTagKeysException(inner) => Error::DuplicateTagKeysException(inner),
                crate::error::CreateTransitVirtualInterfaceErrorKind::TooManyTagsException(inner) => Error::TooManyTagsException(inner),
                crate::error::CreateTransitVirtualInterfaceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteBGPPeerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteBGPPeerError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteBGPPeerErrorKind::DirectConnectClientException(inner) => {
                    Error::DirectConnectClientException(inner)
                }
                crate::error::DeleteBGPPeerErrorKind::DirectConnectServerException(inner) => {
                    Error::DirectConnectServerException(inner)
                }
                crate::error::DeleteBGPPeerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteConnectionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteConnectionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteConnectionErrorKind::DirectConnectClientException(inner) => {
                    Error::DirectConnectClientException(inner)
                }
                crate::error::DeleteConnectionErrorKind::DirectConnectServerException(inner) => {
                    Error::DirectConnectServerException(inner)
                }
                crate::error::DeleteConnectionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDirectConnectGatewayError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteDirectConnectGatewayError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteDirectConnectGatewayErrorKind::DirectConnectClientException(
                    inner,
                ) => Error::DirectConnectClientException(inner),
                crate::error::DeleteDirectConnectGatewayErrorKind::DirectConnectServerException(
                    inner,
                ) => Error::DirectConnectServerException(inner),
                crate::error::DeleteDirectConnectGatewayErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DeleteDirectConnectGatewayAssociationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeleteDirectConnectGatewayAssociationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteDirectConnectGatewayAssociationErrorKind::DirectConnectClientException(inner) => Error::DirectConnectClientException(inner),
                crate::error::DeleteDirectConnectGatewayAssociationErrorKind::DirectConnectServerException(inner) => Error::DirectConnectServerException(inner),
                crate::error::DeleteDirectConnectGatewayAssociationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DeleteDirectConnectGatewayAssociationProposalError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeleteDirectConnectGatewayAssociationProposalError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteDirectConnectGatewayAssociationProposalErrorKind::DirectConnectClientException(inner) => Error::DirectConnectClientException(inner),
                crate::error::DeleteDirectConnectGatewayAssociationProposalErrorKind::DirectConnectServerException(inner) => Error::DirectConnectServerException(inner),
                crate::error::DeleteDirectConnectGatewayAssociationProposalErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteInterconnectError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteInterconnectError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteInterconnectErrorKind::DirectConnectClientException(inner) => {
                    Error::DirectConnectClientException(inner)
                }
                crate::error::DeleteInterconnectErrorKind::DirectConnectServerException(inner) => {
                    Error::DirectConnectServerException(inner)
                }
                crate::error::DeleteInterconnectErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteLagError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteLagError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteLagErrorKind::DirectConnectClientException(inner) => {
                    Error::DirectConnectClientException(inner)
                }
                crate::error::DeleteLagErrorKind::DirectConnectServerException(inner) => {
                    Error::DirectConnectServerException(inner)
                }
                crate::error::DeleteLagErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteVirtualInterfaceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteVirtualInterfaceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteVirtualInterfaceErrorKind::DirectConnectClientException(
                    inner,
                ) => Error::DirectConnectClientException(inner),
                crate::error::DeleteVirtualInterfaceErrorKind::DirectConnectServerException(
                    inner,
                ) => Error::DirectConnectServerException(inner),
                crate::error::DeleteVirtualInterfaceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeConnectionLoaError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeConnectionLoaError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeConnectionLoaErrorKind::DirectConnectClientException(
                    inner,
                ) => Error::DirectConnectClientException(inner),
                crate::error::DescribeConnectionLoaErrorKind::DirectConnectServerException(
                    inner,
                ) => Error::DirectConnectServerException(inner),
                crate::error::DescribeConnectionLoaErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeConnectionsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeConnectionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeConnectionsErrorKind::DirectConnectClientException(inner) => {
                    Error::DirectConnectClientException(inner)
                }
                crate::error::DescribeConnectionsErrorKind::DirectConnectServerException(inner) => {
                    Error::DirectConnectServerException(inner)
                }
                crate::error::DescribeConnectionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeConnectionsOnInterconnectError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeConnectionsOnInterconnectError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeConnectionsOnInterconnectErrorKind::DirectConnectClientException(inner) => Error::DirectConnectClientException(inner),
                crate::error::DescribeConnectionsOnInterconnectErrorKind::DirectConnectServerException(inner) => Error::DirectConnectServerException(inner),
                crate::error::DescribeConnectionsOnInterconnectErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeCustomerMetadataError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeCustomerMetadataError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeCustomerMetadataErrorKind::DirectConnectClientException(
                    inner,
                ) => Error::DirectConnectClientException(inner),
                crate::error::DescribeCustomerMetadataErrorKind::DirectConnectServerException(
                    inner,
                ) => Error::DirectConnectServerException(inner),
                crate::error::DescribeCustomerMetadataErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeDirectConnectGatewayAssociationProposalsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeDirectConnectGatewayAssociationProposalsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeDirectConnectGatewayAssociationProposalsErrorKind::DirectConnectClientException(inner) => Error::DirectConnectClientException(inner),
                crate::error::DescribeDirectConnectGatewayAssociationProposalsErrorKind::DirectConnectServerException(inner) => Error::DirectConnectServerException(inner),
                crate::error::DescribeDirectConnectGatewayAssociationProposalsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeDirectConnectGatewayAssociationsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeDirectConnectGatewayAssociationsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeDirectConnectGatewayAssociationsErrorKind::DirectConnectClientException(inner) => Error::DirectConnectClientException(inner),
                crate::error::DescribeDirectConnectGatewayAssociationsErrorKind::DirectConnectServerException(inner) => Error::DirectConnectServerException(inner),
                crate::error::DescribeDirectConnectGatewayAssociationsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeDirectConnectGatewayAttachmentsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeDirectConnectGatewayAttachmentsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeDirectConnectGatewayAttachmentsErrorKind::DirectConnectClientException(inner) => Error::DirectConnectClientException(inner),
                crate::error::DescribeDirectConnectGatewayAttachmentsErrorKind::DirectConnectServerException(inner) => Error::DirectConnectServerException(inner),
                crate::error::DescribeDirectConnectGatewayAttachmentsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDirectConnectGatewaysError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDirectConnectGatewaysError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeDirectConnectGatewaysErrorKind::DirectConnectClientException(inner) => Error::DirectConnectClientException(inner),
                crate::error::DescribeDirectConnectGatewaysErrorKind::DirectConnectServerException(inner) => Error::DirectConnectServerException(inner),
                crate::error::DescribeDirectConnectGatewaysErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeHostedConnectionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeHostedConnectionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeHostedConnectionsErrorKind::DirectConnectClientException(
                    inner,
                ) => Error::DirectConnectClientException(inner),
                crate::error::DescribeHostedConnectionsErrorKind::DirectConnectServerException(
                    inner,
                ) => Error::DirectConnectServerException(inner),
                crate::error::DescribeHostedConnectionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeInterconnectLoaError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeInterconnectLoaError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeInterconnectLoaErrorKind::DirectConnectClientException(
                    inner,
                ) => Error::DirectConnectClientException(inner),
                crate::error::DescribeInterconnectLoaErrorKind::DirectConnectServerException(
                    inner,
                ) => Error::DirectConnectServerException(inner),
                crate::error::DescribeInterconnectLoaErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeInterconnectsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeInterconnectsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeInterconnectsErrorKind::DirectConnectClientException(
                    inner,
                ) => Error::DirectConnectClientException(inner),
                crate::error::DescribeInterconnectsErrorKind::DirectConnectServerException(
                    inner,
                ) => Error::DirectConnectServerException(inner),
                crate::error::DescribeInterconnectsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeLagsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeLagsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeLagsErrorKind::DirectConnectClientException(inner) => {
                    Error::DirectConnectClientException(inner)
                }
                crate::error::DescribeLagsErrorKind::DirectConnectServerException(inner) => {
                    Error::DirectConnectServerException(inner)
                }
                crate::error::DescribeLagsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeLoaError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeLoaError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeLoaErrorKind::DirectConnectClientException(inner) => {
                    Error::DirectConnectClientException(inner)
                }
                crate::error::DescribeLoaErrorKind::DirectConnectServerException(inner) => {
                    Error::DirectConnectServerException(inner)
                }
                crate::error::DescribeLoaErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeLocationsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeLocationsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeLocationsErrorKind::DirectConnectClientException(inner) => {
                    Error::DirectConnectClientException(inner)
                }
                crate::error::DescribeLocationsErrorKind::DirectConnectServerException(inner) => {
                    Error::DirectConnectServerException(inner)
                }
                crate::error::DescribeLocationsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeRouterConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeRouterConfigurationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeRouterConfigurationErrorKind::DirectConnectClientException(inner) => Error::DirectConnectClientException(inner),
                crate::error::DescribeRouterConfigurationErrorKind::DirectConnectServerException(inner) => Error::DirectConnectServerException(inner),
                crate::error::DescribeRouterConfigurationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeTagsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeTagsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeTagsErrorKind::DirectConnectClientException(inner) => {
                    Error::DirectConnectClientException(inner)
                }
                crate::error::DescribeTagsErrorKind::DirectConnectServerException(inner) => {
                    Error::DirectConnectServerException(inner)
                }
                crate::error::DescribeTagsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeVirtualGatewaysError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeVirtualGatewaysError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeVirtualGatewaysErrorKind::DirectConnectClientException(
                    inner,
                ) => Error::DirectConnectClientException(inner),
                crate::error::DescribeVirtualGatewaysErrorKind::DirectConnectServerException(
                    inner,
                ) => Error::DirectConnectServerException(inner),
                crate::error::DescribeVirtualGatewaysErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeVirtualInterfacesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeVirtualInterfacesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeVirtualInterfacesErrorKind::DirectConnectClientException(
                    inner,
                ) => Error::DirectConnectClientException(inner),
                crate::error::DescribeVirtualInterfacesErrorKind::DirectConnectServerException(
                    inner,
                ) => Error::DirectConnectServerException(inner),
                crate::error::DescribeVirtualInterfacesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DisassociateConnectionFromLagError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DisassociateConnectionFromLagError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DisassociateConnectionFromLagErrorKind::DirectConnectClientException(inner) => Error::DirectConnectClientException(inner),
                crate::error::DisassociateConnectionFromLagErrorKind::DirectConnectServerException(inner) => Error::DirectConnectServerException(inner),
                crate::error::DisassociateConnectionFromLagErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DisassociateMacSecKeyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DisassociateMacSecKeyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DisassociateMacSecKeyErrorKind::DirectConnectClientException(
                    inner,
                ) => Error::DirectConnectClientException(inner),
                crate::error::DisassociateMacSecKeyErrorKind::DirectConnectServerException(
                    inner,
                ) => Error::DirectConnectServerException(inner),
                crate::error::DisassociateMacSecKeyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ListVirtualInterfaceTestHistoryError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListVirtualInterfaceTestHistoryError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListVirtualInterfaceTestHistoryErrorKind::DirectConnectClientException(inner) => Error::DirectConnectClientException(inner),
                crate::error::ListVirtualInterfaceTestHistoryErrorKind::DirectConnectServerException(inner) => Error::DirectConnectServerException(inner),
                crate::error::ListVirtualInterfaceTestHistoryErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartBgpFailoverTestError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartBgpFailoverTestError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartBgpFailoverTestErrorKind::DirectConnectClientException(
                    inner,
                ) => Error::DirectConnectClientException(inner),
                crate::error::StartBgpFailoverTestErrorKind::DirectConnectServerException(
                    inner,
                ) => Error::DirectConnectServerException(inner),
                crate::error::StartBgpFailoverTestErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopBgpFailoverTestError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StopBgpFailoverTestError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StopBgpFailoverTestErrorKind::DirectConnectClientException(inner) => {
                    Error::DirectConnectClientException(inner)
                }
                crate::error::StopBgpFailoverTestErrorKind::DirectConnectServerException(inner) => {
                    Error::DirectConnectServerException(inner)
                }
                crate::error::StopBgpFailoverTestErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TagResourceErrorKind::DirectConnectClientException(inner) => {
                    Error::DirectConnectClientException(inner)
                }
                crate::error::TagResourceErrorKind::DirectConnectServerException(inner) => {
                    Error::DirectConnectServerException(inner)
                }
                crate::error::TagResourceErrorKind::DuplicateTagKeysException(inner) => {
                    Error::DuplicateTagKeysException(inner)
                }
                crate::error::TagResourceErrorKind::TooManyTagsException(inner) => {
                    Error::TooManyTagsException(inner)
                }
                crate::error::TagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UntagResourceErrorKind::DirectConnectClientException(inner) => {
                    Error::DirectConnectClientException(inner)
                }
                crate::error::UntagResourceErrorKind::DirectConnectServerException(inner) => {
                    Error::DirectConnectServerException(inner)
                }
                crate::error::UntagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateConnectionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateConnectionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateConnectionErrorKind::DirectConnectClientException(inner) => {
                    Error::DirectConnectClientException(inner)
                }
                crate::error::UpdateConnectionErrorKind::DirectConnectServerException(inner) => {
                    Error::DirectConnectServerException(inner)
                }
                crate::error::UpdateConnectionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateDirectConnectGatewayError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateDirectConnectGatewayError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateDirectConnectGatewayErrorKind::DirectConnectClientException(
                    inner,
                ) => Error::DirectConnectClientException(inner),
                crate::error::UpdateDirectConnectGatewayErrorKind::DirectConnectServerException(
                    inner,
                ) => Error::DirectConnectServerException(inner),
                crate::error::UpdateDirectConnectGatewayErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::UpdateDirectConnectGatewayAssociationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::UpdateDirectConnectGatewayAssociationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateDirectConnectGatewayAssociationErrorKind::DirectConnectClientException(inner) => Error::DirectConnectClientException(inner),
                crate::error::UpdateDirectConnectGatewayAssociationErrorKind::DirectConnectServerException(inner) => Error::DirectConnectServerException(inner),
                crate::error::UpdateDirectConnectGatewayAssociationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateLagError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateLagError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateLagErrorKind::DirectConnectClientException(inner) => {
                    Error::DirectConnectClientException(inner)
                }
                crate::error::UpdateLagErrorKind::DirectConnectServerException(inner) => {
                    Error::DirectConnectServerException(inner)
                }
                crate::error::UpdateLagErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::UpdateVirtualInterfaceAttributesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::UpdateVirtualInterfaceAttributesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateVirtualInterfaceAttributesErrorKind::DirectConnectClientException(inner) => Error::DirectConnectClientException(inner),
                crate::error::UpdateVirtualInterfaceAttributesErrorKind::DirectConnectServerException(inner) => Error::DirectConnectServerException(inner),
                crate::error::UpdateVirtualInterfaceAttributesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
