// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Information about a virtual interface.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateVirtualInterfaceAttributesOutput {
    /// <p>The ID of the account that owns the virtual interface.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>The ID of the virtual interface.</p>
    pub virtual_interface_id: std::option::Option<std::string::String>,
    /// <p>The location of the connection.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The ID of the connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The type of virtual interface. The possible values are <code>private</code> and <code>public</code>.</p>
    pub virtual_interface_type: std::option::Option<std::string::String>,
    /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
    pub virtual_interface_name: std::option::Option<std::string::String>,
    /// <p>The ID of the VLAN.</p>
    pub vlan: i32,
    /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
    /// <p>The valid values are 1-2147483647.</p>
    pub asn: i32,
    /// <p>The autonomous system number (ASN) for the Amazon side of the connection.</p>
    pub amazon_side_asn: std::option::Option<i64>,
    /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
    pub auth_key: std::option::Option<std::string::String>,
    /// <p>The IP address assigned to the Amazon interface.</p>
    pub amazon_address: std::option::Option<std::string::String>,
    /// <p>The IP address assigned to the customer interface.</p>
    pub customer_address: std::option::Option<std::string::String>,
    /// <p>The address family for the BGP peer.</p>
    pub address_family: std::option::Option<crate::model::AddressFamily>,
    /// <p>The state of the virtual interface. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: A virtual interface that is BGP down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The state of the virtual interface is not available.</p>
    /// </li>
    /// </ul>
    pub virtual_interface_state: std::option::Option<crate::model::VirtualInterfaceState>,
    /// <p>The customer router configuration.</p>
    pub customer_router_config: std::option::Option<std::string::String>,
    /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
    pub mtu: std::option::Option<i32>,
    /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    pub jumbo_frame_capable: std::option::Option<bool>,
    /// <p>The ID of the virtual private gateway. Applies only to private virtual interfaces.</p>
    pub virtual_gateway_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Direct Connect gateway.</p>
    pub direct_connect_gateway_id: std::option::Option<std::string::String>,
    /// <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
    pub route_filter_prefixes: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
    /// <p>The BGP peers configured on this virtual interface.</p>
    pub bgp_peers: std::option::Option<std::vec::Vec<crate::model::BgpPeer>>,
    /// <p>The Region where the virtual interface is located.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
    pub aws_device_v2: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
    /// different than the device that terminates the physical connection.</p>
    pub aws_logical_device_id: std::option::Option<std::string::String>,
    /// <p>The tags associated with the virtual interface.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for UpdateVirtualInterfaceAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateVirtualInterfaceAttributesOutput");
        formatter.field("owner_account", &self.owner_account);
        formatter.field("virtual_interface_id", &self.virtual_interface_id);
        formatter.field("location", &self.location);
        formatter.field("connection_id", &self.connection_id);
        formatter.field("virtual_interface_type", &self.virtual_interface_type);
        formatter.field("virtual_interface_name", &self.virtual_interface_name);
        formatter.field("vlan", &self.vlan);
        formatter.field("asn", &self.asn);
        formatter.field("amazon_side_asn", &self.amazon_side_asn);
        formatter.field("auth_key", &self.auth_key);
        formatter.field("amazon_address", &self.amazon_address);
        formatter.field("customer_address", &self.customer_address);
        formatter.field("address_family", &self.address_family);
        formatter.field("virtual_interface_state", &self.virtual_interface_state);
        formatter.field("customer_router_config", &self.customer_router_config);
        formatter.field("mtu", &self.mtu);
        formatter.field("jumbo_frame_capable", &self.jumbo_frame_capable);
        formatter.field("virtual_gateway_id", &self.virtual_gateway_id);
        formatter.field("direct_connect_gateway_id", &self.direct_connect_gateway_id);
        formatter.field("route_filter_prefixes", &self.route_filter_prefixes);
        formatter.field("bgp_peers", &self.bgp_peers);
        formatter.field("region", &self.region);
        formatter.field("aws_device_v2", &self.aws_device_v2);
        formatter.field("aws_logical_device_id", &self.aws_logical_device_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`UpdateVirtualInterfaceAttributesOutput`](crate::output::UpdateVirtualInterfaceAttributesOutput)
pub mod update_virtual_interface_attributes_output {
    /// A builder for [`UpdateVirtualInterfaceAttributesOutput`](crate::output::UpdateVirtualInterfaceAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) virtual_interface_id: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) virtual_interface_type: std::option::Option<std::string::String>,
        pub(crate) virtual_interface_name: std::option::Option<std::string::String>,
        pub(crate) vlan: std::option::Option<i32>,
        pub(crate) asn: std::option::Option<i32>,
        pub(crate) amazon_side_asn: std::option::Option<i64>,
        pub(crate) auth_key: std::option::Option<std::string::String>,
        pub(crate) amazon_address: std::option::Option<std::string::String>,
        pub(crate) customer_address: std::option::Option<std::string::String>,
        pub(crate) address_family: std::option::Option<crate::model::AddressFamily>,
        pub(crate) virtual_interface_state:
            std::option::Option<crate::model::VirtualInterfaceState>,
        pub(crate) customer_router_config: std::option::Option<std::string::String>,
        pub(crate) mtu: std::option::Option<i32>,
        pub(crate) jumbo_frame_capable: std::option::Option<bool>,
        pub(crate) virtual_gateway_id: std::option::Option<std::string::String>,
        pub(crate) direct_connect_gateway_id: std::option::Option<std::string::String>,
        pub(crate) route_filter_prefixes:
            std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        pub(crate) bgp_peers: std::option::Option<std::vec::Vec<crate::model::BgpPeer>>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) aws_device_v2: std::option::Option<std::string::String>,
        pub(crate) aws_logical_device_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the account that owns the virtual interface.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the account that owns the virtual interface.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_id = input;
            self
        }
        /// <p>The location of the connection.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The location of the connection.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The type of virtual interface. The possible values are <code>private</code> and <code>public</code>.</p>
        pub fn virtual_interface_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_type = Some(input.into());
            self
        }
        /// <p>The type of virtual interface. The possible values are <code>private</code> and <code>public</code>.</p>
        pub fn set_virtual_interface_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_type = input;
            self
        }
        /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
        pub fn virtual_interface_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
        pub fn set_virtual_interface_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_name = input;
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn vlan(mut self, input: i32) -> Self {
            self.vlan = Some(input);
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn set_vlan(mut self, input: std::option::Option<i32>) -> Self {
            self.vlan = input;
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        /// <p>The valid values are 1-2147483647.</p>
        pub fn asn(mut self, input: i32) -> Self {
            self.asn = Some(input);
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        /// <p>The valid values are 1-2147483647.</p>
        pub fn set_asn(mut self, input: std::option::Option<i32>) -> Self {
            self.asn = input;
            self
        }
        /// <p>The autonomous system number (ASN) for the Amazon side of the connection.</p>
        pub fn amazon_side_asn(mut self, input: i64) -> Self {
            self.amazon_side_asn = Some(input);
            self
        }
        /// <p>The autonomous system number (ASN) for the Amazon side of the connection.</p>
        pub fn set_amazon_side_asn(mut self, input: std::option::Option<i64>) -> Self {
            self.amazon_side_asn = input;
            self
        }
        /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
        pub fn auth_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.auth_key = Some(input.into());
            self
        }
        /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
        pub fn set_auth_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.auth_key = input;
            self
        }
        /// <p>The IP address assigned to the Amazon interface.</p>
        pub fn amazon_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.amazon_address = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the Amazon interface.</p>
        pub fn set_amazon_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amazon_address = input;
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn customer_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_address = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn set_customer_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_address = input;
            self
        }
        /// <p>The address family for the BGP peer.</p>
        pub fn address_family(mut self, input: crate::model::AddressFamily) -> Self {
            self.address_family = Some(input);
            self
        }
        /// <p>The address family for the BGP peer.</p>
        pub fn set_address_family(
            mut self,
            input: std::option::Option<crate::model::AddressFamily>,
        ) -> Self {
            self.address_family = input;
            self
        }
        /// <p>The state of the virtual interface. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: A virtual interface that is BGP down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the virtual interface is not available.</p>
        /// </li>
        /// </ul>
        pub fn virtual_interface_state(
            mut self,
            input: crate::model::VirtualInterfaceState,
        ) -> Self {
            self.virtual_interface_state = Some(input);
            self
        }
        /// <p>The state of the virtual interface. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: A virtual interface that is BGP down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the virtual interface is not available.</p>
        /// </li>
        /// </ul>
        pub fn set_virtual_interface_state(
            mut self,
            input: std::option::Option<crate::model::VirtualInterfaceState>,
        ) -> Self {
            self.virtual_interface_state = input;
            self
        }
        /// <p>The customer router configuration.</p>
        pub fn customer_router_config(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_router_config = Some(input.into());
            self
        }
        /// <p>The customer router configuration.</p>
        pub fn set_customer_router_config(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_router_config = input;
            self
        }
        /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
        pub fn mtu(mut self, input: i32) -> Self {
            self.mtu = Some(input);
            self
        }
        /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
        pub fn set_mtu(mut self, input: std::option::Option<i32>) -> Self {
            self.mtu = input;
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn jumbo_frame_capable(mut self, input: bool) -> Self {
            self.jumbo_frame_capable = Some(input);
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn set_jumbo_frame_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.jumbo_frame_capable = input;
            self
        }
        /// <p>The ID of the virtual private gateway. Applies only to private virtual interfaces.</p>
        pub fn virtual_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual private gateway. Applies only to private virtual interfaces.</p>
        pub fn set_virtual_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_gateway_id = input;
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.direct_connect_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_id = input;
            self
        }
        /// Appends an item to `route_filter_prefixes`.
        ///
        /// To override the contents of this collection use [`set_route_filter_prefixes`](Self::set_route_filter_prefixes).
        ///
        /// <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
        pub fn route_filter_prefixes(
            mut self,
            input: impl Into<crate::model::RouteFilterPrefix>,
        ) -> Self {
            let mut v = self.route_filter_prefixes.unwrap_or_default();
            v.push(input.into());
            self.route_filter_prefixes = Some(v);
            self
        }
        /// <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
        pub fn set_route_filter_prefixes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        ) -> Self {
            self.route_filter_prefixes = input;
            self
        }
        /// Appends an item to `bgp_peers`.
        ///
        /// To override the contents of this collection use [`set_bgp_peers`](Self::set_bgp_peers).
        ///
        /// <p>The BGP peers configured on this virtual interface.</p>
        pub fn bgp_peers(mut self, input: impl Into<crate::model::BgpPeer>) -> Self {
            let mut v = self.bgp_peers.unwrap_or_default();
            v.push(input.into());
            self.bgp_peers = Some(v);
            self
        }
        /// <p>The BGP peers configured on this virtual interface.</p>
        pub fn set_bgp_peers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BgpPeer>>,
        ) -> Self {
            self.bgp_peers = input;
            self
        }
        /// <p>The Region where the virtual interface is located.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Region where the virtual interface is located.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn aws_device_v2(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device_v2 = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn set_aws_device_v2(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_device_v2 = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn aws_logical_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_logical_device_id = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn set_aws_logical_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_logical_device_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the virtual interface.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the virtual interface.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateVirtualInterfaceAttributesOutput`](crate::output::UpdateVirtualInterfaceAttributesOutput)
        pub fn build(self) -> crate::output::UpdateVirtualInterfaceAttributesOutput {
            crate::output::UpdateVirtualInterfaceAttributesOutput {
                owner_account: self.owner_account,
                virtual_interface_id: self.virtual_interface_id,
                location: self.location,
                connection_id: self.connection_id,
                virtual_interface_type: self.virtual_interface_type,
                virtual_interface_name: self.virtual_interface_name,
                vlan: self.vlan.unwrap_or_default(),
                asn: self.asn.unwrap_or_default(),
                amazon_side_asn: self.amazon_side_asn,
                auth_key: self.auth_key,
                amazon_address: self.amazon_address,
                customer_address: self.customer_address,
                address_family: self.address_family,
                virtual_interface_state: self.virtual_interface_state,
                customer_router_config: self.customer_router_config,
                mtu: self.mtu,
                jumbo_frame_capable: self.jumbo_frame_capable,
                virtual_gateway_id: self.virtual_gateway_id,
                direct_connect_gateway_id: self.direct_connect_gateway_id,
                route_filter_prefixes: self.route_filter_prefixes,
                bgp_peers: self.bgp_peers,
                region: self.region,
                aws_device_v2: self.aws_device_v2,
                aws_logical_device_id: self.aws_logical_device_id,
                tags: self.tags,
            }
        }
    }
}
impl UpdateVirtualInterfaceAttributesOutput {
    /// Creates a new builder-style object to manufacture [`UpdateVirtualInterfaceAttributesOutput`](crate::output::UpdateVirtualInterfaceAttributesOutput)
    pub fn builder() -> crate::output::update_virtual_interface_attributes_output::Builder {
        crate::output::update_virtual_interface_attributes_output::Builder::default()
    }
}

/// <p>Information about a link aggregation group (LAG).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLagOutput {
    /// <p>The individual bandwidth of the physical connections bundled by the LAG. The possible
    /// values are 1Gbps and 10Gbps. </p>
    pub connections_bandwidth: std::option::Option<std::string::String>,
    /// <p>The number of physical dedicated connections bundled by the LAG, up to a maximum of 10.</p>
    pub number_of_connections: i32,
    /// <p>The ID of the LAG.</p>
    pub lag_id: std::option::Option<std::string::String>,
    /// <p>The ID of the account that owns the LAG.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>The name of the LAG.</p>
    pub lag_name: std::option::Option<std::string::String>,
    /// <p>The state of the LAG. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>requested</code>: The initial state of a LAG. The LAG stays in the
    /// requested state until the Letter of Authorization (LOA) is available.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: The LAG has been approved and is being initialized.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: The network link is established and the LAG is ready for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: The network link is down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: The LAG is being deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: The LAG is deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The state of the LAG is not available.</p>
    /// </li>
    /// </ul>
    pub lag_state: std::option::Option<crate::model::LagState>,
    /// <p>The location of the LAG.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The Region where the connection is located.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The minimum number of physical dedicated connections that must be operational for the LAG itself to be operational.</p>
    pub minimum_links: i32,
    /// <p>The Direct Connect endpoint that hosts the LAG.</p>
    pub aws_device: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that hosts the LAG.</p>
    pub aws_device_v2: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
    /// different than the device that terminates the physical connection.</p>
    pub aws_logical_device_id: std::option::Option<std::string::String>,
    /// <p>The connections bundled by the LAG.</p>
    pub connections: std::option::Option<std::vec::Vec<crate::model::Connection>>,
    /// <p>Indicates whether the LAG can host other connections.</p>
    pub allows_hosted_connections: bool,
    /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    pub jumbo_frame_capable: std::option::Option<bool>,
    /// <p>Indicates whether the LAG supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
    pub has_logical_redundancy: std::option::Option<crate::model::HasLogicalRedundancy>,
    /// <p>The tags associated with the LAG.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The name of the service provider associated with the LAG.</p>
    pub provider_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether the LAG supports MAC Security (MACsec).</p>
    pub mac_sec_capable: std::option::Option<bool>,
    /// <p>The LAG MAC Security (MACsec) encryption mode.</p>
    /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
    pub encryption_mode: std::option::Option<std::string::String>,
    /// <p>The MAC Security (MACsec) security keys associated with the LAG.</p>
    pub mac_sec_keys: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
}
impl std::fmt::Debug for UpdateLagOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLagOutput");
        formatter.field("connections_bandwidth", &self.connections_bandwidth);
        formatter.field("number_of_connections", &self.number_of_connections);
        formatter.field("lag_id", &self.lag_id);
        formatter.field("owner_account", &self.owner_account);
        formatter.field("lag_name", &self.lag_name);
        formatter.field("lag_state", &self.lag_state);
        formatter.field("location", &self.location);
        formatter.field("region", &self.region);
        formatter.field("minimum_links", &self.minimum_links);
        formatter.field("aws_device", &self.aws_device);
        formatter.field("aws_device_v2", &self.aws_device_v2);
        formatter.field("aws_logical_device_id", &self.aws_logical_device_id);
        formatter.field("connections", &self.connections);
        formatter.field("allows_hosted_connections", &self.allows_hosted_connections);
        formatter.field("jumbo_frame_capable", &self.jumbo_frame_capable);
        formatter.field("has_logical_redundancy", &self.has_logical_redundancy);
        formatter.field("tags", &self.tags);
        formatter.field("provider_name", &self.provider_name);
        formatter.field("mac_sec_capable", &self.mac_sec_capable);
        formatter.field("encryption_mode", &self.encryption_mode);
        formatter.field("mac_sec_keys", &self.mac_sec_keys);
        formatter.finish()
    }
}
/// See [`UpdateLagOutput`](crate::output::UpdateLagOutput)
pub mod update_lag_output {
    /// A builder for [`UpdateLagOutput`](crate::output::UpdateLagOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connections_bandwidth: std::option::Option<std::string::String>,
        pub(crate) number_of_connections: std::option::Option<i32>,
        pub(crate) lag_id: std::option::Option<std::string::String>,
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) lag_name: std::option::Option<std::string::String>,
        pub(crate) lag_state: std::option::Option<crate::model::LagState>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) minimum_links: std::option::Option<i32>,
        pub(crate) aws_device: std::option::Option<std::string::String>,
        pub(crate) aws_device_v2: std::option::Option<std::string::String>,
        pub(crate) aws_logical_device_id: std::option::Option<std::string::String>,
        pub(crate) connections: std::option::Option<std::vec::Vec<crate::model::Connection>>,
        pub(crate) allows_hosted_connections: std::option::Option<bool>,
        pub(crate) jumbo_frame_capable: std::option::Option<bool>,
        pub(crate) has_logical_redundancy: std::option::Option<crate::model::HasLogicalRedundancy>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) provider_name: std::option::Option<std::string::String>,
        pub(crate) mac_sec_capable: std::option::Option<bool>,
        pub(crate) encryption_mode: std::option::Option<std::string::String>,
        pub(crate) mac_sec_keys: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
    }
    impl Builder {
        /// <p>The individual bandwidth of the physical connections bundled by the LAG. The possible
        /// values are 1Gbps and 10Gbps. </p>
        pub fn connections_bandwidth(mut self, input: impl Into<std::string::String>) -> Self {
            self.connections_bandwidth = Some(input.into());
            self
        }
        /// <p>The individual bandwidth of the physical connections bundled by the LAG. The possible
        /// values are 1Gbps and 10Gbps. </p>
        pub fn set_connections_bandwidth(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connections_bandwidth = input;
            self
        }
        /// <p>The number of physical dedicated connections bundled by the LAG, up to a maximum of 10.</p>
        pub fn number_of_connections(mut self, input: i32) -> Self {
            self.number_of_connections = Some(input);
            self
        }
        /// <p>The number of physical dedicated connections bundled by the LAG, up to a maximum of 10.</p>
        pub fn set_number_of_connections(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_connections = input;
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.lag_id = Some(input.into());
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lag_id = input;
            self
        }
        /// <p>The ID of the account that owns the LAG.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the account that owns the LAG.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>The name of the LAG.</p>
        pub fn lag_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.lag_name = Some(input.into());
            self
        }
        /// <p>The name of the LAG.</p>
        pub fn set_lag_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lag_name = input;
            self
        }
        /// <p>The state of the LAG. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of a LAG. The LAG stays in the
        /// requested state until the Letter of Authorization (LOA) is available.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The LAG has been approved and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is established and the LAG is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The LAG is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The LAG is deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the LAG is not available.</p>
        /// </li>
        /// </ul>
        pub fn lag_state(mut self, input: crate::model::LagState) -> Self {
            self.lag_state = Some(input);
            self
        }
        /// <p>The state of the LAG. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of a LAG. The LAG stays in the
        /// requested state until the Letter of Authorization (LOA) is available.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The LAG has been approved and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is established and the LAG is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The LAG is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The LAG is deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the LAG is not available.</p>
        /// </li>
        /// </ul>
        pub fn set_lag_state(mut self, input: std::option::Option<crate::model::LagState>) -> Self {
            self.lag_state = input;
            self
        }
        /// <p>The location of the LAG.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The location of the LAG.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The Region where the connection is located.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Region where the connection is located.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The minimum number of physical dedicated connections that must be operational for the LAG itself to be operational.</p>
        pub fn minimum_links(mut self, input: i32) -> Self {
            self.minimum_links = Some(input);
            self
        }
        /// <p>The minimum number of physical dedicated connections that must be operational for the LAG itself to be operational.</p>
        pub fn set_minimum_links(mut self, input: std::option::Option<i32>) -> Self {
            self.minimum_links = input;
            self
        }
        /// <p>The Direct Connect endpoint that hosts the LAG.</p>
        pub fn aws_device(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that hosts the LAG.</p>
        pub fn set_aws_device(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_device = input;
            self
        }
        /// <p>The Direct Connect endpoint that hosts the LAG.</p>
        pub fn aws_device_v2(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device_v2 = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that hosts the LAG.</p>
        pub fn set_aws_device_v2(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_device_v2 = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn aws_logical_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_logical_device_id = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn set_aws_logical_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_logical_device_id = input;
            self
        }
        /// Appends an item to `connections`.
        ///
        /// To override the contents of this collection use [`set_connections`](Self::set_connections).
        ///
        /// <p>The connections bundled by the LAG.</p>
        pub fn connections(mut self, input: impl Into<crate::model::Connection>) -> Self {
            let mut v = self.connections.unwrap_or_default();
            v.push(input.into());
            self.connections = Some(v);
            self
        }
        /// <p>The connections bundled by the LAG.</p>
        pub fn set_connections(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Connection>>,
        ) -> Self {
            self.connections = input;
            self
        }
        /// <p>Indicates whether the LAG can host other connections.</p>
        pub fn allows_hosted_connections(mut self, input: bool) -> Self {
            self.allows_hosted_connections = Some(input);
            self
        }
        /// <p>Indicates whether the LAG can host other connections.</p>
        pub fn set_allows_hosted_connections(mut self, input: std::option::Option<bool>) -> Self {
            self.allows_hosted_connections = input;
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn jumbo_frame_capable(mut self, input: bool) -> Self {
            self.jumbo_frame_capable = Some(input);
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn set_jumbo_frame_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.jumbo_frame_capable = input;
            self
        }
        /// <p>Indicates whether the LAG supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
        pub fn has_logical_redundancy(mut self, input: crate::model::HasLogicalRedundancy) -> Self {
            self.has_logical_redundancy = Some(input);
            self
        }
        /// <p>Indicates whether the LAG supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
        pub fn set_has_logical_redundancy(
            mut self,
            input: std::option::Option<crate::model::HasLogicalRedundancy>,
        ) -> Self {
            self.has_logical_redundancy = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the LAG.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the LAG.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name of the service provider associated with the LAG.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The name of the service provider associated with the LAG.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// <p>Indicates whether the LAG supports MAC Security (MACsec).</p>
        pub fn mac_sec_capable(mut self, input: bool) -> Self {
            self.mac_sec_capable = Some(input);
            self
        }
        /// <p>Indicates whether the LAG supports MAC Security (MACsec).</p>
        pub fn set_mac_sec_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.mac_sec_capable = input;
            self
        }
        /// <p>The LAG MAC Security (MACsec) encryption mode.</p>
        /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
        pub fn encryption_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_mode = Some(input.into());
            self
        }
        /// <p>The LAG MAC Security (MACsec) encryption mode.</p>
        /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_mode = input;
            self
        }
        /// Appends an item to `mac_sec_keys`.
        ///
        /// To override the contents of this collection use [`set_mac_sec_keys`](Self::set_mac_sec_keys).
        ///
        /// <p>The MAC Security (MACsec) security keys associated with the LAG.</p>
        pub fn mac_sec_keys(mut self, input: impl Into<crate::model::MacSecKey>) -> Self {
            let mut v = self.mac_sec_keys.unwrap_or_default();
            v.push(input.into());
            self.mac_sec_keys = Some(v);
            self
        }
        /// <p>The MAC Security (MACsec) security keys associated with the LAG.</p>
        pub fn set_mac_sec_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
        ) -> Self {
            self.mac_sec_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateLagOutput`](crate::output::UpdateLagOutput)
        pub fn build(self) -> crate::output::UpdateLagOutput {
            crate::output::UpdateLagOutput {
                connections_bandwidth: self.connections_bandwidth,
                number_of_connections: self.number_of_connections.unwrap_or_default(),
                lag_id: self.lag_id,
                owner_account: self.owner_account,
                lag_name: self.lag_name,
                lag_state: self.lag_state,
                location: self.location,
                region: self.region,
                minimum_links: self.minimum_links.unwrap_or_default(),
                aws_device: self.aws_device,
                aws_device_v2: self.aws_device_v2,
                aws_logical_device_id: self.aws_logical_device_id,
                connections: self.connections,
                allows_hosted_connections: self.allows_hosted_connections.unwrap_or_default(),
                jumbo_frame_capable: self.jumbo_frame_capable,
                has_logical_redundancy: self.has_logical_redundancy,
                tags: self.tags,
                provider_name: self.provider_name,
                mac_sec_capable: self.mac_sec_capable,
                encryption_mode: self.encryption_mode,
                mac_sec_keys: self.mac_sec_keys,
            }
        }
    }
}
impl UpdateLagOutput {
    /// Creates a new builder-style object to manufacture [`UpdateLagOutput`](crate::output::UpdateLagOutput)
    pub fn builder() -> crate::output::update_lag_output::Builder {
        crate::output::update_lag_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDirectConnectGatewayAssociationOutput {
    /// <p>Information about an association between a Direct Connect gateway and a virtual private gateway or transit gateway.</p>
    pub direct_connect_gateway_association:
        std::option::Option<crate::model::DirectConnectGatewayAssociation>,
}
impl std::fmt::Debug for UpdateDirectConnectGatewayAssociationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDirectConnectGatewayAssociationOutput");
        formatter.field(
            "direct_connect_gateway_association",
            &self.direct_connect_gateway_association,
        );
        formatter.finish()
    }
}
/// See [`UpdateDirectConnectGatewayAssociationOutput`](crate::output::UpdateDirectConnectGatewayAssociationOutput)
pub mod update_direct_connect_gateway_association_output {
    /// A builder for [`UpdateDirectConnectGatewayAssociationOutput`](crate::output::UpdateDirectConnectGatewayAssociationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) direct_connect_gateway_association:
            std::option::Option<crate::model::DirectConnectGatewayAssociation>,
    }
    impl Builder {
        /// <p>Information about an association between a Direct Connect gateway and a virtual private gateway or transit gateway.</p>
        pub fn direct_connect_gateway_association(
            mut self,
            input: crate::model::DirectConnectGatewayAssociation,
        ) -> Self {
            self.direct_connect_gateway_association = Some(input);
            self
        }
        /// <p>Information about an association between a Direct Connect gateway and a virtual private gateway or transit gateway.</p>
        pub fn set_direct_connect_gateway_association(
            mut self,
            input: std::option::Option<crate::model::DirectConnectGatewayAssociation>,
        ) -> Self {
            self.direct_connect_gateway_association = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDirectConnectGatewayAssociationOutput`](crate::output::UpdateDirectConnectGatewayAssociationOutput)
        pub fn build(self) -> crate::output::UpdateDirectConnectGatewayAssociationOutput {
            crate::output::UpdateDirectConnectGatewayAssociationOutput {
                direct_connect_gateway_association: self.direct_connect_gateway_association,
            }
        }
    }
}
impl UpdateDirectConnectGatewayAssociationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDirectConnectGatewayAssociationOutput`](crate::output::UpdateDirectConnectGatewayAssociationOutput)
    pub fn builder() -> crate::output::update_direct_connect_gateway_association_output::Builder {
        crate::output::update_direct_connect_gateway_association_output::Builder::default()
    }
}

/// <p>Information about an Direct Connect connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConnectionOutput {
    /// <p>The ID of the account that owns the connection.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>The ID of the connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The name of the connection.</p>
    pub connection_name: std::option::Option<std::string::String>,
    /// <p>The state of the connection. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: The connection has been approved and is being initialized.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: The network link is up and the connection is ready for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: The network link is down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: The connection is being deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: The connection has been deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The state of the connection is not available.</p>
    /// </li>
    /// </ul>
    pub connection_state: std::option::Option<crate::model::ConnectionState>,
    /// <p>The Region where the connection is located.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The location of the connection.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The bandwidth of the connection.</p>
    pub bandwidth: std::option::Option<std::string::String>,
    /// <p>The ID of the VLAN.</p>
    pub vlan: i32,
    /// <p>The name of the Direct Connect service provider associated with the connection.</p>
    pub partner_name: std::option::Option<std::string::String>,
    /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
    pub loa_issue_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The ID of the LAG.</p>
    pub lag_id: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
    pub aws_device: std::option::Option<std::string::String>,
    /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    pub jumbo_frame_capable: std::option::Option<bool>,
    /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
    pub aws_device_v2: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
    /// different than the device that terminates the physical connection.</p>
    pub aws_logical_device_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
    pub has_logical_redundancy: std::option::Option<crate::model::HasLogicalRedundancy>,
    /// <p>The tags associated with the connection.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The name of the service provider associated with the connection.</p>
    pub provider_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether the connection supports MAC Security (MACsec).</p>
    pub mac_sec_capable: std::option::Option<bool>,
    /// <p>The MAC Security (MACsec) port link status of the connection.</p>
    /// <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
    pub port_encryption_status: std::option::Option<std::string::String>,
    /// <p>The MAC Security (MACsec) connection encryption mode.</p>
    /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
    pub encryption_mode: std::option::Option<std::string::String>,
    /// <p>The MAC Security (MACsec) security keys associated with the connection.</p>
    pub mac_sec_keys: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
}
impl std::fmt::Debug for UpdateConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConnectionOutput");
        formatter.field("owner_account", &self.owner_account);
        formatter.field("connection_id", &self.connection_id);
        formatter.field("connection_name", &self.connection_name);
        formatter.field("connection_state", &self.connection_state);
        formatter.field("region", &self.region);
        formatter.field("location", &self.location);
        formatter.field("bandwidth", &self.bandwidth);
        formatter.field("vlan", &self.vlan);
        formatter.field("partner_name", &self.partner_name);
        formatter.field("loa_issue_time", &self.loa_issue_time);
        formatter.field("lag_id", &self.lag_id);
        formatter.field("aws_device", &self.aws_device);
        formatter.field("jumbo_frame_capable", &self.jumbo_frame_capable);
        formatter.field("aws_device_v2", &self.aws_device_v2);
        formatter.field("aws_logical_device_id", &self.aws_logical_device_id);
        formatter.field("has_logical_redundancy", &self.has_logical_redundancy);
        formatter.field("tags", &self.tags);
        formatter.field("provider_name", &self.provider_name);
        formatter.field("mac_sec_capable", &self.mac_sec_capable);
        formatter.field("port_encryption_status", &self.port_encryption_status);
        formatter.field("encryption_mode", &self.encryption_mode);
        formatter.field("mac_sec_keys", &self.mac_sec_keys);
        formatter.finish()
    }
}
/// See [`UpdateConnectionOutput`](crate::output::UpdateConnectionOutput)
pub mod update_connection_output {
    /// A builder for [`UpdateConnectionOutput`](crate::output::UpdateConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) connection_name: std::option::Option<std::string::String>,
        pub(crate) connection_state: std::option::Option<crate::model::ConnectionState>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) bandwidth: std::option::Option<std::string::String>,
        pub(crate) vlan: std::option::Option<i32>,
        pub(crate) partner_name: std::option::Option<std::string::String>,
        pub(crate) loa_issue_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) lag_id: std::option::Option<std::string::String>,
        pub(crate) aws_device: std::option::Option<std::string::String>,
        pub(crate) jumbo_frame_capable: std::option::Option<bool>,
        pub(crate) aws_device_v2: std::option::Option<std::string::String>,
        pub(crate) aws_logical_device_id: std::option::Option<std::string::String>,
        pub(crate) has_logical_redundancy: std::option::Option<crate::model::HasLogicalRedundancy>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) provider_name: std::option::Option<std::string::String>,
        pub(crate) mac_sec_capable: std::option::Option<bool>,
        pub(crate) port_encryption_status: std::option::Option<std::string::String>,
        pub(crate) encryption_mode: std::option::Option<std::string::String>,
        pub(crate) mac_sec_keys: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
    }
    impl Builder {
        /// <p>The ID of the account that owns the connection.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the account that owns the connection.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The name of the connection.</p>
        pub fn connection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_name = Some(input.into());
            self
        }
        /// <p>The name of the connection.</p>
        pub fn set_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_name = input;
            self
        }
        /// <p>The state of the connection. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The connection has been approved and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is up and the connection is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The connection is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The connection has been deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the connection is not available.</p>
        /// </li>
        /// </ul>
        pub fn connection_state(mut self, input: crate::model::ConnectionState) -> Self {
            self.connection_state = Some(input);
            self
        }
        /// <p>The state of the connection. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The connection has been approved and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is up and the connection is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The connection is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The connection has been deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the connection is not available.</p>
        /// </li>
        /// </ul>
        pub fn set_connection_state(
            mut self,
            input: std::option::Option<crate::model::ConnectionState>,
        ) -> Self {
            self.connection_state = input;
            self
        }
        /// <p>The Region where the connection is located.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Region where the connection is located.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The location of the connection.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The location of the connection.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The bandwidth of the connection.</p>
        pub fn bandwidth(mut self, input: impl Into<std::string::String>) -> Self {
            self.bandwidth = Some(input.into());
            self
        }
        /// <p>The bandwidth of the connection.</p>
        pub fn set_bandwidth(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bandwidth = input;
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn vlan(mut self, input: i32) -> Self {
            self.vlan = Some(input);
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn set_vlan(mut self, input: std::option::Option<i32>) -> Self {
            self.vlan = input;
            self
        }
        /// <p>The name of the Direct Connect service provider associated with the connection.</p>
        pub fn partner_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.partner_name = Some(input.into());
            self
        }
        /// <p>The name of the Direct Connect service provider associated with the connection.</p>
        pub fn set_partner_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.partner_name = input;
            self
        }
        /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
        pub fn loa_issue_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.loa_issue_time = Some(input);
            self
        }
        /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
        pub fn set_loa_issue_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.loa_issue_time = input;
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.lag_id = Some(input.into());
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lag_id = input;
            self
        }
        /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
        pub fn aws_device(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
        pub fn set_aws_device(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_device = input;
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn jumbo_frame_capable(mut self, input: bool) -> Self {
            self.jumbo_frame_capable = Some(input);
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn set_jumbo_frame_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.jumbo_frame_capable = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn aws_device_v2(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device_v2 = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn set_aws_device_v2(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_device_v2 = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn aws_logical_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_logical_device_id = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn set_aws_logical_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_logical_device_id = input;
            self
        }
        /// <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
        pub fn has_logical_redundancy(mut self, input: crate::model::HasLogicalRedundancy) -> Self {
            self.has_logical_redundancy = Some(input);
            self
        }
        /// <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
        pub fn set_has_logical_redundancy(
            mut self,
            input: std::option::Option<crate::model::HasLogicalRedundancy>,
        ) -> Self {
            self.has_logical_redundancy = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the connection.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the connection.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name of the service provider associated with the connection.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The name of the service provider associated with the connection.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// <p>Indicates whether the connection supports MAC Security (MACsec).</p>
        pub fn mac_sec_capable(mut self, input: bool) -> Self {
            self.mac_sec_capable = Some(input);
            self
        }
        /// <p>Indicates whether the connection supports MAC Security (MACsec).</p>
        pub fn set_mac_sec_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.mac_sec_capable = input;
            self
        }
        /// <p>The MAC Security (MACsec) port link status of the connection.</p>
        /// <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
        pub fn port_encryption_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.port_encryption_status = Some(input.into());
            self
        }
        /// <p>The MAC Security (MACsec) port link status of the connection.</p>
        /// <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
        pub fn set_port_encryption_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.port_encryption_status = input;
            self
        }
        /// <p>The MAC Security (MACsec) connection encryption mode.</p>
        /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
        pub fn encryption_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_mode = Some(input.into());
            self
        }
        /// <p>The MAC Security (MACsec) connection encryption mode.</p>
        /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_mode = input;
            self
        }
        /// Appends an item to `mac_sec_keys`.
        ///
        /// To override the contents of this collection use [`set_mac_sec_keys`](Self::set_mac_sec_keys).
        ///
        /// <p>The MAC Security (MACsec) security keys associated with the connection.</p>
        pub fn mac_sec_keys(mut self, input: impl Into<crate::model::MacSecKey>) -> Self {
            let mut v = self.mac_sec_keys.unwrap_or_default();
            v.push(input.into());
            self.mac_sec_keys = Some(v);
            self
        }
        /// <p>The MAC Security (MACsec) security keys associated with the connection.</p>
        pub fn set_mac_sec_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
        ) -> Self {
            self.mac_sec_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConnectionOutput`](crate::output::UpdateConnectionOutput)
        pub fn build(self) -> crate::output::UpdateConnectionOutput {
            crate::output::UpdateConnectionOutput {
                owner_account: self.owner_account,
                connection_id: self.connection_id,
                connection_name: self.connection_name,
                connection_state: self.connection_state,
                region: self.region,
                location: self.location,
                bandwidth: self.bandwidth,
                vlan: self.vlan.unwrap_or_default(),
                partner_name: self.partner_name,
                loa_issue_time: self.loa_issue_time,
                lag_id: self.lag_id,
                aws_device: self.aws_device,
                jumbo_frame_capable: self.jumbo_frame_capable,
                aws_device_v2: self.aws_device_v2,
                aws_logical_device_id: self.aws_logical_device_id,
                has_logical_redundancy: self.has_logical_redundancy,
                tags: self.tags,
                provider_name: self.provider_name,
                mac_sec_capable: self.mac_sec_capable,
                port_encryption_status: self.port_encryption_status,
                encryption_mode: self.encryption_mode,
                mac_sec_keys: self.mac_sec_keys,
            }
        }
    }
}
impl UpdateConnectionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateConnectionOutput`](crate::output::UpdateConnectionOutput)
    pub fn builder() -> crate::output::update_connection_output::Builder {
        crate::output::update_connection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopBgpFailoverTestOutput {
    /// <p>Information about the virtual interface failover test.</p>
    pub virtual_interface_test: std::option::Option<crate::model::VirtualInterfaceTestHistory>,
}
impl std::fmt::Debug for StopBgpFailoverTestOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopBgpFailoverTestOutput");
        formatter.field("virtual_interface_test", &self.virtual_interface_test);
        formatter.finish()
    }
}
/// See [`StopBgpFailoverTestOutput`](crate::output::StopBgpFailoverTestOutput)
pub mod stop_bgp_failover_test_output {
    /// A builder for [`StopBgpFailoverTestOutput`](crate::output::StopBgpFailoverTestOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_interface_test:
            std::option::Option<crate::model::VirtualInterfaceTestHistory>,
    }
    impl Builder {
        /// <p>Information about the virtual interface failover test.</p>
        pub fn virtual_interface_test(
            mut self,
            input: crate::model::VirtualInterfaceTestHistory,
        ) -> Self {
            self.virtual_interface_test = Some(input);
            self
        }
        /// <p>Information about the virtual interface failover test.</p>
        pub fn set_virtual_interface_test(
            mut self,
            input: std::option::Option<crate::model::VirtualInterfaceTestHistory>,
        ) -> Self {
            self.virtual_interface_test = input;
            self
        }
        /// Consumes the builder and constructs a [`StopBgpFailoverTestOutput`](crate::output::StopBgpFailoverTestOutput)
        pub fn build(self) -> crate::output::StopBgpFailoverTestOutput {
            crate::output::StopBgpFailoverTestOutput {
                virtual_interface_test: self.virtual_interface_test,
            }
        }
    }
}
impl StopBgpFailoverTestOutput {
    /// Creates a new builder-style object to manufacture [`StopBgpFailoverTestOutput`](crate::output::StopBgpFailoverTestOutput)
    pub fn builder() -> crate::output::stop_bgp_failover_test_output::Builder {
        crate::output::stop_bgp_failover_test_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartBgpFailoverTestOutput {
    /// <p>Information about the virtual interface failover test.</p>
    pub virtual_interface_test: std::option::Option<crate::model::VirtualInterfaceTestHistory>,
}
impl std::fmt::Debug for StartBgpFailoverTestOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartBgpFailoverTestOutput");
        formatter.field("virtual_interface_test", &self.virtual_interface_test);
        formatter.finish()
    }
}
/// See [`StartBgpFailoverTestOutput`](crate::output::StartBgpFailoverTestOutput)
pub mod start_bgp_failover_test_output {
    /// A builder for [`StartBgpFailoverTestOutput`](crate::output::StartBgpFailoverTestOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_interface_test:
            std::option::Option<crate::model::VirtualInterfaceTestHistory>,
    }
    impl Builder {
        /// <p>Information about the virtual interface failover test.</p>
        pub fn virtual_interface_test(
            mut self,
            input: crate::model::VirtualInterfaceTestHistory,
        ) -> Self {
            self.virtual_interface_test = Some(input);
            self
        }
        /// <p>Information about the virtual interface failover test.</p>
        pub fn set_virtual_interface_test(
            mut self,
            input: std::option::Option<crate::model::VirtualInterfaceTestHistory>,
        ) -> Self {
            self.virtual_interface_test = input;
            self
        }
        /// Consumes the builder and constructs a [`StartBgpFailoverTestOutput`](crate::output::StartBgpFailoverTestOutput)
        pub fn build(self) -> crate::output::StartBgpFailoverTestOutput {
            crate::output::StartBgpFailoverTestOutput {
                virtual_interface_test: self.virtual_interface_test,
            }
        }
    }
}
impl StartBgpFailoverTestOutput {
    /// Creates a new builder-style object to manufacture [`StartBgpFailoverTestOutput`](crate::output::StartBgpFailoverTestOutput)
    pub fn builder() -> crate::output::start_bgp_failover_test_output::Builder {
        crate::output::start_bgp_failover_test_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListVirtualInterfaceTestHistoryOutput {
    /// <p>The ID of the tested virtual interface.</p>
    pub virtual_interface_test_history:
        std::option::Option<std::vec::Vec<crate::model::VirtualInterfaceTestHistory>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListVirtualInterfaceTestHistoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListVirtualInterfaceTestHistoryOutput");
        formatter.field(
            "virtual_interface_test_history",
            &self.virtual_interface_test_history,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListVirtualInterfaceTestHistoryOutput`](crate::output::ListVirtualInterfaceTestHistoryOutput)
pub mod list_virtual_interface_test_history_output {
    /// A builder for [`ListVirtualInterfaceTestHistoryOutput`](crate::output::ListVirtualInterfaceTestHistoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_interface_test_history:
            std::option::Option<std::vec::Vec<crate::model::VirtualInterfaceTestHistory>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `virtual_interface_test_history`.
        ///
        /// To override the contents of this collection use [`set_virtual_interface_test_history`](Self::set_virtual_interface_test_history).
        ///
        /// <p>The ID of the tested virtual interface.</p>
        pub fn virtual_interface_test_history(
            mut self,
            input: impl Into<crate::model::VirtualInterfaceTestHistory>,
        ) -> Self {
            let mut v = self.virtual_interface_test_history.unwrap_or_default();
            v.push(input.into());
            self.virtual_interface_test_history = Some(v);
            self
        }
        /// <p>The ID of the tested virtual interface.</p>
        pub fn set_virtual_interface_test_history(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VirtualInterfaceTestHistory>>,
        ) -> Self {
            self.virtual_interface_test_history = input;
            self
        }
        /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListVirtualInterfaceTestHistoryOutput`](crate::output::ListVirtualInterfaceTestHistoryOutput)
        pub fn build(self) -> crate::output::ListVirtualInterfaceTestHistoryOutput {
            crate::output::ListVirtualInterfaceTestHistoryOutput {
                virtual_interface_test_history: self.virtual_interface_test_history,
                next_token: self.next_token,
            }
        }
    }
}
impl ListVirtualInterfaceTestHistoryOutput {
    /// Creates a new builder-style object to manufacture [`ListVirtualInterfaceTestHistoryOutput`](crate::output::ListVirtualInterfaceTestHistoryOutput)
    pub fn builder() -> crate::output::list_virtual_interface_test_history_output::Builder {
        crate::output::list_virtual_interface_test_history_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateMacSecKeyOutput {
    /// <p>The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The MAC Security (MACsec) security keys no longer associated with the dedicated connection.</p>
    pub mac_sec_keys: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
}
impl std::fmt::Debug for DisassociateMacSecKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateMacSecKeyOutput");
        formatter.field("connection_id", &self.connection_id);
        formatter.field("mac_sec_keys", &self.mac_sec_keys);
        formatter.finish()
    }
}
/// See [`DisassociateMacSecKeyOutput`](crate::output::DisassociateMacSecKeyOutput)
pub mod disassociate_mac_sec_key_output {
    /// A builder for [`DisassociateMacSecKeyOutput`](crate::output::DisassociateMacSecKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) mac_sec_keys: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
    }
    impl Builder {
        /// <p>The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// Appends an item to `mac_sec_keys`.
        ///
        /// To override the contents of this collection use [`set_mac_sec_keys`](Self::set_mac_sec_keys).
        ///
        /// <p>The MAC Security (MACsec) security keys no longer associated with the dedicated connection.</p>
        pub fn mac_sec_keys(mut self, input: impl Into<crate::model::MacSecKey>) -> Self {
            let mut v = self.mac_sec_keys.unwrap_or_default();
            v.push(input.into());
            self.mac_sec_keys = Some(v);
            self
        }
        /// <p>The MAC Security (MACsec) security keys no longer associated with the dedicated connection.</p>
        pub fn set_mac_sec_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
        ) -> Self {
            self.mac_sec_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateMacSecKeyOutput`](crate::output::DisassociateMacSecKeyOutput)
        pub fn build(self) -> crate::output::DisassociateMacSecKeyOutput {
            crate::output::DisassociateMacSecKeyOutput {
                connection_id: self.connection_id,
                mac_sec_keys: self.mac_sec_keys,
            }
        }
    }
}
impl DisassociateMacSecKeyOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateMacSecKeyOutput`](crate::output::DisassociateMacSecKeyOutput)
    pub fn builder() -> crate::output::disassociate_mac_sec_key_output::Builder {
        crate::output::disassociate_mac_sec_key_output::Builder::default()
    }
}

/// <p>Information about an Direct Connect connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateConnectionFromLagOutput {
    /// <p>The ID of the account that owns the connection.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>The ID of the connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The name of the connection.</p>
    pub connection_name: std::option::Option<std::string::String>,
    /// <p>The state of the connection. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: The connection has been approved and is being initialized.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: The network link is up and the connection is ready for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: The network link is down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: The connection is being deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: The connection has been deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The state of the connection is not available.</p>
    /// </li>
    /// </ul>
    pub connection_state: std::option::Option<crate::model::ConnectionState>,
    /// <p>The Region where the connection is located.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The location of the connection.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The bandwidth of the connection.</p>
    pub bandwidth: std::option::Option<std::string::String>,
    /// <p>The ID of the VLAN.</p>
    pub vlan: i32,
    /// <p>The name of the Direct Connect service provider associated with the connection.</p>
    pub partner_name: std::option::Option<std::string::String>,
    /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
    pub loa_issue_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The ID of the LAG.</p>
    pub lag_id: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
    pub aws_device: std::option::Option<std::string::String>,
    /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    pub jumbo_frame_capable: std::option::Option<bool>,
    /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
    pub aws_device_v2: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
    /// different than the device that terminates the physical connection.</p>
    pub aws_logical_device_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
    pub has_logical_redundancy: std::option::Option<crate::model::HasLogicalRedundancy>,
    /// <p>The tags associated with the connection.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The name of the service provider associated with the connection.</p>
    pub provider_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether the connection supports MAC Security (MACsec).</p>
    pub mac_sec_capable: std::option::Option<bool>,
    /// <p>The MAC Security (MACsec) port link status of the connection.</p>
    /// <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
    pub port_encryption_status: std::option::Option<std::string::String>,
    /// <p>The MAC Security (MACsec) connection encryption mode.</p>
    /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
    pub encryption_mode: std::option::Option<std::string::String>,
    /// <p>The MAC Security (MACsec) security keys associated with the connection.</p>
    pub mac_sec_keys: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
}
impl std::fmt::Debug for DisassociateConnectionFromLagOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateConnectionFromLagOutput");
        formatter.field("owner_account", &self.owner_account);
        formatter.field("connection_id", &self.connection_id);
        formatter.field("connection_name", &self.connection_name);
        formatter.field("connection_state", &self.connection_state);
        formatter.field("region", &self.region);
        formatter.field("location", &self.location);
        formatter.field("bandwidth", &self.bandwidth);
        formatter.field("vlan", &self.vlan);
        formatter.field("partner_name", &self.partner_name);
        formatter.field("loa_issue_time", &self.loa_issue_time);
        formatter.field("lag_id", &self.lag_id);
        formatter.field("aws_device", &self.aws_device);
        formatter.field("jumbo_frame_capable", &self.jumbo_frame_capable);
        formatter.field("aws_device_v2", &self.aws_device_v2);
        formatter.field("aws_logical_device_id", &self.aws_logical_device_id);
        formatter.field("has_logical_redundancy", &self.has_logical_redundancy);
        formatter.field("tags", &self.tags);
        formatter.field("provider_name", &self.provider_name);
        formatter.field("mac_sec_capable", &self.mac_sec_capable);
        formatter.field("port_encryption_status", &self.port_encryption_status);
        formatter.field("encryption_mode", &self.encryption_mode);
        formatter.field("mac_sec_keys", &self.mac_sec_keys);
        formatter.finish()
    }
}
/// See [`DisassociateConnectionFromLagOutput`](crate::output::DisassociateConnectionFromLagOutput)
pub mod disassociate_connection_from_lag_output {
    /// A builder for [`DisassociateConnectionFromLagOutput`](crate::output::DisassociateConnectionFromLagOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) connection_name: std::option::Option<std::string::String>,
        pub(crate) connection_state: std::option::Option<crate::model::ConnectionState>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) bandwidth: std::option::Option<std::string::String>,
        pub(crate) vlan: std::option::Option<i32>,
        pub(crate) partner_name: std::option::Option<std::string::String>,
        pub(crate) loa_issue_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) lag_id: std::option::Option<std::string::String>,
        pub(crate) aws_device: std::option::Option<std::string::String>,
        pub(crate) jumbo_frame_capable: std::option::Option<bool>,
        pub(crate) aws_device_v2: std::option::Option<std::string::String>,
        pub(crate) aws_logical_device_id: std::option::Option<std::string::String>,
        pub(crate) has_logical_redundancy: std::option::Option<crate::model::HasLogicalRedundancy>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) provider_name: std::option::Option<std::string::String>,
        pub(crate) mac_sec_capable: std::option::Option<bool>,
        pub(crate) port_encryption_status: std::option::Option<std::string::String>,
        pub(crate) encryption_mode: std::option::Option<std::string::String>,
        pub(crate) mac_sec_keys: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
    }
    impl Builder {
        /// <p>The ID of the account that owns the connection.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the account that owns the connection.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The name of the connection.</p>
        pub fn connection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_name = Some(input.into());
            self
        }
        /// <p>The name of the connection.</p>
        pub fn set_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_name = input;
            self
        }
        /// <p>The state of the connection. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The connection has been approved and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is up and the connection is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The connection is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The connection has been deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the connection is not available.</p>
        /// </li>
        /// </ul>
        pub fn connection_state(mut self, input: crate::model::ConnectionState) -> Self {
            self.connection_state = Some(input);
            self
        }
        /// <p>The state of the connection. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The connection has been approved and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is up and the connection is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The connection is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The connection has been deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the connection is not available.</p>
        /// </li>
        /// </ul>
        pub fn set_connection_state(
            mut self,
            input: std::option::Option<crate::model::ConnectionState>,
        ) -> Self {
            self.connection_state = input;
            self
        }
        /// <p>The Region where the connection is located.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Region where the connection is located.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The location of the connection.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The location of the connection.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The bandwidth of the connection.</p>
        pub fn bandwidth(mut self, input: impl Into<std::string::String>) -> Self {
            self.bandwidth = Some(input.into());
            self
        }
        /// <p>The bandwidth of the connection.</p>
        pub fn set_bandwidth(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bandwidth = input;
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn vlan(mut self, input: i32) -> Self {
            self.vlan = Some(input);
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn set_vlan(mut self, input: std::option::Option<i32>) -> Self {
            self.vlan = input;
            self
        }
        /// <p>The name of the Direct Connect service provider associated with the connection.</p>
        pub fn partner_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.partner_name = Some(input.into());
            self
        }
        /// <p>The name of the Direct Connect service provider associated with the connection.</p>
        pub fn set_partner_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.partner_name = input;
            self
        }
        /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
        pub fn loa_issue_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.loa_issue_time = Some(input);
            self
        }
        /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
        pub fn set_loa_issue_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.loa_issue_time = input;
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.lag_id = Some(input.into());
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lag_id = input;
            self
        }
        /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
        pub fn aws_device(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
        pub fn set_aws_device(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_device = input;
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn jumbo_frame_capable(mut self, input: bool) -> Self {
            self.jumbo_frame_capable = Some(input);
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn set_jumbo_frame_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.jumbo_frame_capable = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn aws_device_v2(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device_v2 = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn set_aws_device_v2(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_device_v2 = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn aws_logical_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_logical_device_id = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn set_aws_logical_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_logical_device_id = input;
            self
        }
        /// <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
        pub fn has_logical_redundancy(mut self, input: crate::model::HasLogicalRedundancy) -> Self {
            self.has_logical_redundancy = Some(input);
            self
        }
        /// <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
        pub fn set_has_logical_redundancy(
            mut self,
            input: std::option::Option<crate::model::HasLogicalRedundancy>,
        ) -> Self {
            self.has_logical_redundancy = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the connection.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the connection.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name of the service provider associated with the connection.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The name of the service provider associated with the connection.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// <p>Indicates whether the connection supports MAC Security (MACsec).</p>
        pub fn mac_sec_capable(mut self, input: bool) -> Self {
            self.mac_sec_capable = Some(input);
            self
        }
        /// <p>Indicates whether the connection supports MAC Security (MACsec).</p>
        pub fn set_mac_sec_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.mac_sec_capable = input;
            self
        }
        /// <p>The MAC Security (MACsec) port link status of the connection.</p>
        /// <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
        pub fn port_encryption_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.port_encryption_status = Some(input.into());
            self
        }
        /// <p>The MAC Security (MACsec) port link status of the connection.</p>
        /// <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
        pub fn set_port_encryption_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.port_encryption_status = input;
            self
        }
        /// <p>The MAC Security (MACsec) connection encryption mode.</p>
        /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
        pub fn encryption_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_mode = Some(input.into());
            self
        }
        /// <p>The MAC Security (MACsec) connection encryption mode.</p>
        /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_mode = input;
            self
        }
        /// Appends an item to `mac_sec_keys`.
        ///
        /// To override the contents of this collection use [`set_mac_sec_keys`](Self::set_mac_sec_keys).
        ///
        /// <p>The MAC Security (MACsec) security keys associated with the connection.</p>
        pub fn mac_sec_keys(mut self, input: impl Into<crate::model::MacSecKey>) -> Self {
            let mut v = self.mac_sec_keys.unwrap_or_default();
            v.push(input.into());
            self.mac_sec_keys = Some(v);
            self
        }
        /// <p>The MAC Security (MACsec) security keys associated with the connection.</p>
        pub fn set_mac_sec_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
        ) -> Self {
            self.mac_sec_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateConnectionFromLagOutput`](crate::output::DisassociateConnectionFromLagOutput)
        pub fn build(self) -> crate::output::DisassociateConnectionFromLagOutput {
            crate::output::DisassociateConnectionFromLagOutput {
                owner_account: self.owner_account,
                connection_id: self.connection_id,
                connection_name: self.connection_name,
                connection_state: self.connection_state,
                region: self.region,
                location: self.location,
                bandwidth: self.bandwidth,
                vlan: self.vlan.unwrap_or_default(),
                partner_name: self.partner_name,
                loa_issue_time: self.loa_issue_time,
                lag_id: self.lag_id,
                aws_device: self.aws_device,
                jumbo_frame_capable: self.jumbo_frame_capable,
                aws_device_v2: self.aws_device_v2,
                aws_logical_device_id: self.aws_logical_device_id,
                has_logical_redundancy: self.has_logical_redundancy,
                tags: self.tags,
                provider_name: self.provider_name,
                mac_sec_capable: self.mac_sec_capable,
                port_encryption_status: self.port_encryption_status,
                encryption_mode: self.encryption_mode,
                mac_sec_keys: self.mac_sec_keys,
            }
        }
    }
}
impl DisassociateConnectionFromLagOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateConnectionFromLagOutput`](crate::output::DisassociateConnectionFromLagOutput)
    pub fn builder() -> crate::output::disassociate_connection_from_lag_output::Builder {
        crate::output::disassociate_connection_from_lag_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeVirtualInterfacesOutput {
    /// <p>The virtual interfaces</p>
    pub virtual_interfaces: std::option::Option<std::vec::Vec<crate::model::VirtualInterface>>,
}
impl std::fmt::Debug for DescribeVirtualInterfacesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeVirtualInterfacesOutput");
        formatter.field("virtual_interfaces", &self.virtual_interfaces);
        formatter.finish()
    }
}
/// See [`DescribeVirtualInterfacesOutput`](crate::output::DescribeVirtualInterfacesOutput)
pub mod describe_virtual_interfaces_output {
    /// A builder for [`DescribeVirtualInterfacesOutput`](crate::output::DescribeVirtualInterfacesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_interfaces:
            std::option::Option<std::vec::Vec<crate::model::VirtualInterface>>,
    }
    impl Builder {
        /// Appends an item to `virtual_interfaces`.
        ///
        /// To override the contents of this collection use [`set_virtual_interfaces`](Self::set_virtual_interfaces).
        ///
        /// <p>The virtual interfaces</p>
        pub fn virtual_interfaces(
            mut self,
            input: impl Into<crate::model::VirtualInterface>,
        ) -> Self {
            let mut v = self.virtual_interfaces.unwrap_or_default();
            v.push(input.into());
            self.virtual_interfaces = Some(v);
            self
        }
        /// <p>The virtual interfaces</p>
        pub fn set_virtual_interfaces(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VirtualInterface>>,
        ) -> Self {
            self.virtual_interfaces = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeVirtualInterfacesOutput`](crate::output::DescribeVirtualInterfacesOutput)
        pub fn build(self) -> crate::output::DescribeVirtualInterfacesOutput {
            crate::output::DescribeVirtualInterfacesOutput {
                virtual_interfaces: self.virtual_interfaces,
            }
        }
    }
}
impl DescribeVirtualInterfacesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeVirtualInterfacesOutput`](crate::output::DescribeVirtualInterfacesOutput)
    pub fn builder() -> crate::output::describe_virtual_interfaces_output::Builder {
        crate::output::describe_virtual_interfaces_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeVirtualGatewaysOutput {
    /// <p>The virtual private gateways.</p>
    pub virtual_gateways: std::option::Option<std::vec::Vec<crate::model::VirtualGateway>>,
}
impl std::fmt::Debug for DescribeVirtualGatewaysOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeVirtualGatewaysOutput");
        formatter.field("virtual_gateways", &self.virtual_gateways);
        formatter.finish()
    }
}
/// See [`DescribeVirtualGatewaysOutput`](crate::output::DescribeVirtualGatewaysOutput)
pub mod describe_virtual_gateways_output {
    /// A builder for [`DescribeVirtualGatewaysOutput`](crate::output::DescribeVirtualGatewaysOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_gateways:
            std::option::Option<std::vec::Vec<crate::model::VirtualGateway>>,
    }
    impl Builder {
        /// Appends an item to `virtual_gateways`.
        ///
        /// To override the contents of this collection use [`set_virtual_gateways`](Self::set_virtual_gateways).
        ///
        /// <p>The virtual private gateways.</p>
        pub fn virtual_gateways(mut self, input: impl Into<crate::model::VirtualGateway>) -> Self {
            let mut v = self.virtual_gateways.unwrap_or_default();
            v.push(input.into());
            self.virtual_gateways = Some(v);
            self
        }
        /// <p>The virtual private gateways.</p>
        pub fn set_virtual_gateways(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VirtualGateway>>,
        ) -> Self {
            self.virtual_gateways = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeVirtualGatewaysOutput`](crate::output::DescribeVirtualGatewaysOutput)
        pub fn build(self) -> crate::output::DescribeVirtualGatewaysOutput {
            crate::output::DescribeVirtualGatewaysOutput {
                virtual_gateways: self.virtual_gateways,
            }
        }
    }
}
impl DescribeVirtualGatewaysOutput {
    /// Creates a new builder-style object to manufacture [`DescribeVirtualGatewaysOutput`](crate::output::DescribeVirtualGatewaysOutput)
    pub fn builder() -> crate::output::describe_virtual_gateways_output::Builder {
        crate::output::describe_virtual_gateways_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTagsOutput {
    /// <p>Information about the tags.</p>
    pub resource_tags: std::option::Option<std::vec::Vec<crate::model::ResourceTag>>,
}
impl std::fmt::Debug for DescribeTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTagsOutput");
        formatter.field("resource_tags", &self.resource_tags);
        formatter.finish()
    }
}
/// See [`DescribeTagsOutput`](crate::output::DescribeTagsOutput)
pub mod describe_tags_output {
    /// A builder for [`DescribeTagsOutput`](crate::output::DescribeTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_tags: std::option::Option<std::vec::Vec<crate::model::ResourceTag>>,
    }
    impl Builder {
        /// Appends an item to `resource_tags`.
        ///
        /// To override the contents of this collection use [`set_resource_tags`](Self::set_resource_tags).
        ///
        /// <p>Information about the tags.</p>
        pub fn resource_tags(mut self, input: impl Into<crate::model::ResourceTag>) -> Self {
            let mut v = self.resource_tags.unwrap_or_default();
            v.push(input.into());
            self.resource_tags = Some(v);
            self
        }
        /// <p>Information about the tags.</p>
        pub fn set_resource_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceTag>>,
        ) -> Self {
            self.resource_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTagsOutput`](crate::output::DescribeTagsOutput)
        pub fn build(self) -> crate::output::DescribeTagsOutput {
            crate::output::DescribeTagsOutput {
                resource_tags: self.resource_tags,
            }
        }
    }
}
impl DescribeTagsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTagsOutput`](crate::output::DescribeTagsOutput)
    pub fn builder() -> crate::output::describe_tags_output::Builder {
        crate::output::describe_tags_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLocationsOutput {
    /// <p>The locations.</p>
    pub locations: std::option::Option<std::vec::Vec<crate::model::Location>>,
}
impl std::fmt::Debug for DescribeLocationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLocationsOutput");
        formatter.field("locations", &self.locations);
        formatter.finish()
    }
}
/// See [`DescribeLocationsOutput`](crate::output::DescribeLocationsOutput)
pub mod describe_locations_output {
    /// A builder for [`DescribeLocationsOutput`](crate::output::DescribeLocationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) locations: std::option::Option<std::vec::Vec<crate::model::Location>>,
    }
    impl Builder {
        /// Appends an item to `locations`.
        ///
        /// To override the contents of this collection use [`set_locations`](Self::set_locations).
        ///
        /// <p>The locations.</p>
        pub fn locations(mut self, input: impl Into<crate::model::Location>) -> Self {
            let mut v = self.locations.unwrap_or_default();
            v.push(input.into());
            self.locations = Some(v);
            self
        }
        /// <p>The locations.</p>
        pub fn set_locations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Location>>,
        ) -> Self {
            self.locations = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLocationsOutput`](crate::output::DescribeLocationsOutput)
        pub fn build(self) -> crate::output::DescribeLocationsOutput {
            crate::output::DescribeLocationsOutput {
                locations: self.locations,
            }
        }
    }
}
impl DescribeLocationsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeLocationsOutput`](crate::output::DescribeLocationsOutput)
    pub fn builder() -> crate::output::describe_locations_output::Builder {
        crate::output::describe_locations_output::Builder::default()
    }
}

/// <p>Information about a Letter of Authorization - Connecting Facility Assignment (LOA-CFA) for a connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLoaOutput {
    /// <p>The binary contents of the LOA-CFA document.</p>
    pub loa_content: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The standard media type for the LOA-CFA document. The only supported value is application/pdf.</p>
    pub loa_content_type: std::option::Option<crate::model::LoaContentType>,
}
impl std::fmt::Debug for DescribeLoaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLoaOutput");
        formatter.field("loa_content", &self.loa_content);
        formatter.field("loa_content_type", &self.loa_content_type);
        formatter.finish()
    }
}
/// See [`DescribeLoaOutput`](crate::output::DescribeLoaOutput)
pub mod describe_loa_output {
    /// A builder for [`DescribeLoaOutput`](crate::output::DescribeLoaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) loa_content: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) loa_content_type: std::option::Option<crate::model::LoaContentType>,
    }
    impl Builder {
        /// <p>The binary contents of the LOA-CFA document.</p>
        pub fn loa_content(mut self, input: aws_smithy_types::Blob) -> Self {
            self.loa_content = Some(input);
            self
        }
        /// <p>The binary contents of the LOA-CFA document.</p>
        pub fn set_loa_content(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.loa_content = input;
            self
        }
        /// <p>The standard media type for the LOA-CFA document. The only supported value is application/pdf.</p>
        pub fn loa_content_type(mut self, input: crate::model::LoaContentType) -> Self {
            self.loa_content_type = Some(input);
            self
        }
        /// <p>The standard media type for the LOA-CFA document. The only supported value is application/pdf.</p>
        pub fn set_loa_content_type(
            mut self,
            input: std::option::Option<crate::model::LoaContentType>,
        ) -> Self {
            self.loa_content_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLoaOutput`](crate::output::DescribeLoaOutput)
        pub fn build(self) -> crate::output::DescribeLoaOutput {
            crate::output::DescribeLoaOutput {
                loa_content: self.loa_content,
                loa_content_type: self.loa_content_type,
            }
        }
    }
}
impl DescribeLoaOutput {
    /// Creates a new builder-style object to manufacture [`DescribeLoaOutput`](crate::output::DescribeLoaOutput)
    pub fn builder() -> crate::output::describe_loa_output::Builder {
        crate::output::describe_loa_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLagsOutput {
    /// <p>The LAGs.</p>
    pub lags: std::option::Option<std::vec::Vec<crate::model::Lag>>,
}
impl std::fmt::Debug for DescribeLagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLagsOutput");
        formatter.field("lags", &self.lags);
        formatter.finish()
    }
}
/// See [`DescribeLagsOutput`](crate::output::DescribeLagsOutput)
pub mod describe_lags_output {
    /// A builder for [`DescribeLagsOutput`](crate::output::DescribeLagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lags: std::option::Option<std::vec::Vec<crate::model::Lag>>,
    }
    impl Builder {
        /// Appends an item to `lags`.
        ///
        /// To override the contents of this collection use [`set_lags`](Self::set_lags).
        ///
        /// <p>The LAGs.</p>
        pub fn lags(mut self, input: impl Into<crate::model::Lag>) -> Self {
            let mut v = self.lags.unwrap_or_default();
            v.push(input.into());
            self.lags = Some(v);
            self
        }
        /// <p>The LAGs.</p>
        pub fn set_lags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Lag>>,
        ) -> Self {
            self.lags = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLagsOutput`](crate::output::DescribeLagsOutput)
        pub fn build(self) -> crate::output::DescribeLagsOutput {
            crate::output::DescribeLagsOutput { lags: self.lags }
        }
    }
}
impl DescribeLagsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeLagsOutput`](crate::output::DescribeLagsOutput)
    pub fn builder() -> crate::output::describe_lags_output::Builder {
        crate::output::describe_lags_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInterconnectsOutput {
    /// <p>The interconnects.</p>
    pub interconnects: std::option::Option<std::vec::Vec<crate::model::Interconnect>>,
}
impl std::fmt::Debug for DescribeInterconnectsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInterconnectsOutput");
        formatter.field("interconnects", &self.interconnects);
        formatter.finish()
    }
}
/// See [`DescribeInterconnectsOutput`](crate::output::DescribeInterconnectsOutput)
pub mod describe_interconnects_output {
    /// A builder for [`DescribeInterconnectsOutput`](crate::output::DescribeInterconnectsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) interconnects: std::option::Option<std::vec::Vec<crate::model::Interconnect>>,
    }
    impl Builder {
        /// Appends an item to `interconnects`.
        ///
        /// To override the contents of this collection use [`set_interconnects`](Self::set_interconnects).
        ///
        /// <p>The interconnects.</p>
        pub fn interconnects(mut self, input: impl Into<crate::model::Interconnect>) -> Self {
            let mut v = self.interconnects.unwrap_or_default();
            v.push(input.into());
            self.interconnects = Some(v);
            self
        }
        /// <p>The interconnects.</p>
        pub fn set_interconnects(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Interconnect>>,
        ) -> Self {
            self.interconnects = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInterconnectsOutput`](crate::output::DescribeInterconnectsOutput)
        pub fn build(self) -> crate::output::DescribeInterconnectsOutput {
            crate::output::DescribeInterconnectsOutput {
                interconnects: self.interconnects,
            }
        }
    }
}
impl DescribeInterconnectsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeInterconnectsOutput`](crate::output::DescribeInterconnectsOutput)
    pub fn builder() -> crate::output::describe_interconnects_output::Builder {
        crate::output::describe_interconnects_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInterconnectLoaOutput {
    /// <p>The Letter of Authorization - Connecting Facility Assignment (LOA-CFA).</p>
    pub loa: std::option::Option<crate::model::Loa>,
}
impl std::fmt::Debug for DescribeInterconnectLoaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInterconnectLoaOutput");
        formatter.field("loa", &self.loa);
        formatter.finish()
    }
}
/// See [`DescribeInterconnectLoaOutput`](crate::output::DescribeInterconnectLoaOutput)
pub mod describe_interconnect_loa_output {
    /// A builder for [`DescribeInterconnectLoaOutput`](crate::output::DescribeInterconnectLoaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) loa: std::option::Option<crate::model::Loa>,
    }
    impl Builder {
        /// <p>The Letter of Authorization - Connecting Facility Assignment (LOA-CFA).</p>
        pub fn loa(mut self, input: crate::model::Loa) -> Self {
            self.loa = Some(input);
            self
        }
        /// <p>The Letter of Authorization - Connecting Facility Assignment (LOA-CFA).</p>
        pub fn set_loa(mut self, input: std::option::Option<crate::model::Loa>) -> Self {
            self.loa = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInterconnectLoaOutput`](crate::output::DescribeInterconnectLoaOutput)
        pub fn build(self) -> crate::output::DescribeInterconnectLoaOutput {
            crate::output::DescribeInterconnectLoaOutput { loa: self.loa }
        }
    }
}
impl DescribeInterconnectLoaOutput {
    /// Creates a new builder-style object to manufacture [`DescribeInterconnectLoaOutput`](crate::output::DescribeInterconnectLoaOutput)
    pub fn builder() -> crate::output::describe_interconnect_loa_output::Builder {
        crate::output::describe_interconnect_loa_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeHostedConnectionsOutput {
    /// <p>The connections.</p>
    pub connections: std::option::Option<std::vec::Vec<crate::model::Connection>>,
}
impl std::fmt::Debug for DescribeHostedConnectionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeHostedConnectionsOutput");
        formatter.field("connections", &self.connections);
        formatter.finish()
    }
}
/// See [`DescribeHostedConnectionsOutput`](crate::output::DescribeHostedConnectionsOutput)
pub mod describe_hosted_connections_output {
    /// A builder for [`DescribeHostedConnectionsOutput`](crate::output::DescribeHostedConnectionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connections: std::option::Option<std::vec::Vec<crate::model::Connection>>,
    }
    impl Builder {
        /// Appends an item to `connections`.
        ///
        /// To override the contents of this collection use [`set_connections`](Self::set_connections).
        ///
        /// <p>The connections.</p>
        pub fn connections(mut self, input: impl Into<crate::model::Connection>) -> Self {
            let mut v = self.connections.unwrap_or_default();
            v.push(input.into());
            self.connections = Some(v);
            self
        }
        /// <p>The connections.</p>
        pub fn set_connections(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Connection>>,
        ) -> Self {
            self.connections = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeHostedConnectionsOutput`](crate::output::DescribeHostedConnectionsOutput)
        pub fn build(self) -> crate::output::DescribeHostedConnectionsOutput {
            crate::output::DescribeHostedConnectionsOutput {
                connections: self.connections,
            }
        }
    }
}
impl DescribeHostedConnectionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeHostedConnectionsOutput`](crate::output::DescribeHostedConnectionsOutput)
    pub fn builder() -> crate::output::describe_hosted_connections_output::Builder {
        crate::output::describe_hosted_connections_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDirectConnectGatewaysOutput {
    /// <p>The Direct Connect gateways.</p>
    pub direct_connect_gateways:
        std::option::Option<std::vec::Vec<crate::model::DirectConnectGateway>>,
    /// <p>The token to retrieve the next page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeDirectConnectGatewaysOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDirectConnectGatewaysOutput");
        formatter.field("direct_connect_gateways", &self.direct_connect_gateways);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeDirectConnectGatewaysOutput`](crate::output::DescribeDirectConnectGatewaysOutput)
pub mod describe_direct_connect_gateways_output {
    /// A builder for [`DescribeDirectConnectGatewaysOutput`](crate::output::DescribeDirectConnectGatewaysOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) direct_connect_gateways:
            std::option::Option<std::vec::Vec<crate::model::DirectConnectGateway>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `direct_connect_gateways`.
        ///
        /// To override the contents of this collection use [`set_direct_connect_gateways`](Self::set_direct_connect_gateways).
        ///
        /// <p>The Direct Connect gateways.</p>
        pub fn direct_connect_gateways(
            mut self,
            input: impl Into<crate::model::DirectConnectGateway>,
        ) -> Self {
            let mut v = self.direct_connect_gateways.unwrap_or_default();
            v.push(input.into());
            self.direct_connect_gateways = Some(v);
            self
        }
        /// <p>The Direct Connect gateways.</p>
        pub fn set_direct_connect_gateways(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DirectConnectGateway>>,
        ) -> Self {
            self.direct_connect_gateways = input;
            self
        }
        /// <p>The token to retrieve the next page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to retrieve the next page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDirectConnectGatewaysOutput`](crate::output::DescribeDirectConnectGatewaysOutput)
        pub fn build(self) -> crate::output::DescribeDirectConnectGatewaysOutput {
            crate::output::DescribeDirectConnectGatewaysOutput {
                direct_connect_gateways: self.direct_connect_gateways,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeDirectConnectGatewaysOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDirectConnectGatewaysOutput`](crate::output::DescribeDirectConnectGatewaysOutput)
    pub fn builder() -> crate::output::describe_direct_connect_gateways_output::Builder {
        crate::output::describe_direct_connect_gateways_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDirectConnectGatewayAttachmentsOutput {
    /// <p>The attachments.</p>
    pub direct_connect_gateway_attachments:
        std::option::Option<std::vec::Vec<crate::model::DirectConnectGatewayAttachment>>,
    /// <p>The token to retrieve the next page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeDirectConnectGatewayAttachmentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDirectConnectGatewayAttachmentsOutput");
        formatter.field(
            "direct_connect_gateway_attachments",
            &self.direct_connect_gateway_attachments,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeDirectConnectGatewayAttachmentsOutput`](crate::output::DescribeDirectConnectGatewayAttachmentsOutput)
pub mod describe_direct_connect_gateway_attachments_output {
    /// A builder for [`DescribeDirectConnectGatewayAttachmentsOutput`](crate::output::DescribeDirectConnectGatewayAttachmentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) direct_connect_gateway_attachments:
            std::option::Option<std::vec::Vec<crate::model::DirectConnectGatewayAttachment>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `direct_connect_gateway_attachments`.
        ///
        /// To override the contents of this collection use [`set_direct_connect_gateway_attachments`](Self::set_direct_connect_gateway_attachments).
        ///
        /// <p>The attachments.</p>
        pub fn direct_connect_gateway_attachments(
            mut self,
            input: impl Into<crate::model::DirectConnectGatewayAttachment>,
        ) -> Self {
            let mut v = self.direct_connect_gateway_attachments.unwrap_or_default();
            v.push(input.into());
            self.direct_connect_gateway_attachments = Some(v);
            self
        }
        /// <p>The attachments.</p>
        pub fn set_direct_connect_gateway_attachments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DirectConnectGatewayAttachment>>,
        ) -> Self {
            self.direct_connect_gateway_attachments = input;
            self
        }
        /// <p>The token to retrieve the next page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to retrieve the next page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDirectConnectGatewayAttachmentsOutput`](crate::output::DescribeDirectConnectGatewayAttachmentsOutput)
        pub fn build(self) -> crate::output::DescribeDirectConnectGatewayAttachmentsOutput {
            crate::output::DescribeDirectConnectGatewayAttachmentsOutput {
                direct_connect_gateway_attachments: self.direct_connect_gateway_attachments,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeDirectConnectGatewayAttachmentsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDirectConnectGatewayAttachmentsOutput`](crate::output::DescribeDirectConnectGatewayAttachmentsOutput)
    pub fn builder() -> crate::output::describe_direct_connect_gateway_attachments_output::Builder {
        crate::output::describe_direct_connect_gateway_attachments_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDirectConnectGatewayAssociationsOutput {
    /// <p>Information about the associations.</p>
    pub direct_connect_gateway_associations:
        std::option::Option<std::vec::Vec<crate::model::DirectConnectGatewayAssociation>>,
    /// <p>The token to retrieve the next page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeDirectConnectGatewayAssociationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDirectConnectGatewayAssociationsOutput");
        formatter.field(
            "direct_connect_gateway_associations",
            &self.direct_connect_gateway_associations,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeDirectConnectGatewayAssociationsOutput`](crate::output::DescribeDirectConnectGatewayAssociationsOutput)
pub mod describe_direct_connect_gateway_associations_output {
    /// A builder for [`DescribeDirectConnectGatewayAssociationsOutput`](crate::output::DescribeDirectConnectGatewayAssociationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) direct_connect_gateway_associations:
            std::option::Option<std::vec::Vec<crate::model::DirectConnectGatewayAssociation>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `direct_connect_gateway_associations`.
        ///
        /// To override the contents of this collection use [`set_direct_connect_gateway_associations`](Self::set_direct_connect_gateway_associations).
        ///
        /// <p>Information about the associations.</p>
        pub fn direct_connect_gateway_associations(
            mut self,
            input: impl Into<crate::model::DirectConnectGatewayAssociation>,
        ) -> Self {
            let mut v = self.direct_connect_gateway_associations.unwrap_or_default();
            v.push(input.into());
            self.direct_connect_gateway_associations = Some(v);
            self
        }
        /// <p>Information about the associations.</p>
        pub fn set_direct_connect_gateway_associations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::DirectConnectGatewayAssociation>,
            >,
        ) -> Self {
            self.direct_connect_gateway_associations = input;
            self
        }
        /// <p>The token to retrieve the next page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to retrieve the next page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDirectConnectGatewayAssociationsOutput`](crate::output::DescribeDirectConnectGatewayAssociationsOutput)
        pub fn build(self) -> crate::output::DescribeDirectConnectGatewayAssociationsOutput {
            crate::output::DescribeDirectConnectGatewayAssociationsOutput {
                direct_connect_gateway_associations: self.direct_connect_gateway_associations,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeDirectConnectGatewayAssociationsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDirectConnectGatewayAssociationsOutput`](crate::output::DescribeDirectConnectGatewayAssociationsOutput)
    pub fn builder() -> crate::output::describe_direct_connect_gateway_associations_output::Builder
    {
        crate::output::describe_direct_connect_gateway_associations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDirectConnectGatewayAssociationProposalsOutput {
    /// <p>Describes the Direct Connect gateway association proposals.</p>
    pub direct_connect_gateway_association_proposals:
        std::option::Option<std::vec::Vec<crate::model::DirectConnectGatewayAssociationProposal>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeDirectConnectGatewayAssociationProposalsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("DescribeDirectConnectGatewayAssociationProposalsOutput");
        formatter.field(
            "direct_connect_gateway_association_proposals",
            &self.direct_connect_gateway_association_proposals,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeDirectConnectGatewayAssociationProposalsOutput`](crate::output::DescribeDirectConnectGatewayAssociationProposalsOutput)
pub mod describe_direct_connect_gateway_association_proposals_output {
    /// A builder for [`DescribeDirectConnectGatewayAssociationProposalsOutput`](crate::output::DescribeDirectConnectGatewayAssociationProposalsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) direct_connect_gateway_association_proposals: std::option::Option<
            std::vec::Vec<crate::model::DirectConnectGatewayAssociationProposal>,
        >,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `direct_connect_gateway_association_proposals`.
        ///
        /// To override the contents of this collection use [`set_direct_connect_gateway_association_proposals`](Self::set_direct_connect_gateway_association_proposals).
        ///
        /// <p>Describes the Direct Connect gateway association proposals.</p>
        pub fn direct_connect_gateway_association_proposals(
            mut self,
            input: impl Into<crate::model::DirectConnectGatewayAssociationProposal>,
        ) -> Self {
            let mut v = self
                .direct_connect_gateway_association_proposals
                .unwrap_or_default();
            v.push(input.into());
            self.direct_connect_gateway_association_proposals = Some(v);
            self
        }
        /// <p>Describes the Direct Connect gateway association proposals.</p>
        pub fn set_direct_connect_gateway_association_proposals(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::DirectConnectGatewayAssociationProposal>,
            >,
        ) -> Self {
            self.direct_connect_gateway_association_proposals = input;
            self
        }
        /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDirectConnectGatewayAssociationProposalsOutput`](crate::output::DescribeDirectConnectGatewayAssociationProposalsOutput)
        pub fn build(
            self,
        ) -> crate::output::DescribeDirectConnectGatewayAssociationProposalsOutput {
            crate::output::DescribeDirectConnectGatewayAssociationProposalsOutput {
                direct_connect_gateway_association_proposals: self
                    .direct_connect_gateway_association_proposals,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeDirectConnectGatewayAssociationProposalsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDirectConnectGatewayAssociationProposalsOutput`](crate::output::DescribeDirectConnectGatewayAssociationProposalsOutput)
    pub fn builder(
    ) -> crate::output::describe_direct_connect_gateway_association_proposals_output::Builder {
        crate::output::describe_direct_connect_gateway_association_proposals_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConnectionsOnInterconnectOutput {
    /// <p>The connections.</p>
    pub connections: std::option::Option<std::vec::Vec<crate::model::Connection>>,
}
impl std::fmt::Debug for DescribeConnectionsOnInterconnectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConnectionsOnInterconnectOutput");
        formatter.field("connections", &self.connections);
        formatter.finish()
    }
}
/// See [`DescribeConnectionsOnInterconnectOutput`](crate::output::DescribeConnectionsOnInterconnectOutput)
pub mod describe_connections_on_interconnect_output {
    /// A builder for [`DescribeConnectionsOnInterconnectOutput`](crate::output::DescribeConnectionsOnInterconnectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connections: std::option::Option<std::vec::Vec<crate::model::Connection>>,
    }
    impl Builder {
        /// Appends an item to `connections`.
        ///
        /// To override the contents of this collection use [`set_connections`](Self::set_connections).
        ///
        /// <p>The connections.</p>
        pub fn connections(mut self, input: impl Into<crate::model::Connection>) -> Self {
            let mut v = self.connections.unwrap_or_default();
            v.push(input.into());
            self.connections = Some(v);
            self
        }
        /// <p>The connections.</p>
        pub fn set_connections(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Connection>>,
        ) -> Self {
            self.connections = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConnectionsOnInterconnectOutput`](crate::output::DescribeConnectionsOnInterconnectOutput)
        pub fn build(self) -> crate::output::DescribeConnectionsOnInterconnectOutput {
            crate::output::DescribeConnectionsOnInterconnectOutput {
                connections: self.connections,
            }
        }
    }
}
impl DescribeConnectionsOnInterconnectOutput {
    /// Creates a new builder-style object to manufacture [`DescribeConnectionsOnInterconnectOutput`](crate::output::DescribeConnectionsOnInterconnectOutput)
    pub fn builder() -> crate::output::describe_connections_on_interconnect_output::Builder {
        crate::output::describe_connections_on_interconnect_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConnectionsOutput {
    /// <p>The connections.</p>
    pub connections: std::option::Option<std::vec::Vec<crate::model::Connection>>,
}
impl std::fmt::Debug for DescribeConnectionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConnectionsOutput");
        formatter.field("connections", &self.connections);
        formatter.finish()
    }
}
/// See [`DescribeConnectionsOutput`](crate::output::DescribeConnectionsOutput)
pub mod describe_connections_output {
    /// A builder for [`DescribeConnectionsOutput`](crate::output::DescribeConnectionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connections: std::option::Option<std::vec::Vec<crate::model::Connection>>,
    }
    impl Builder {
        /// Appends an item to `connections`.
        ///
        /// To override the contents of this collection use [`set_connections`](Self::set_connections).
        ///
        /// <p>The connections.</p>
        pub fn connections(mut self, input: impl Into<crate::model::Connection>) -> Self {
            let mut v = self.connections.unwrap_or_default();
            v.push(input.into());
            self.connections = Some(v);
            self
        }
        /// <p>The connections.</p>
        pub fn set_connections(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Connection>>,
        ) -> Self {
            self.connections = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConnectionsOutput`](crate::output::DescribeConnectionsOutput)
        pub fn build(self) -> crate::output::DescribeConnectionsOutput {
            crate::output::DescribeConnectionsOutput {
                connections: self.connections,
            }
        }
    }
}
impl DescribeConnectionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeConnectionsOutput`](crate::output::DescribeConnectionsOutput)
    pub fn builder() -> crate::output::describe_connections_output::Builder {
        crate::output::describe_connections_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConnectionLoaOutput {
    /// <p>The Letter of Authorization - Connecting Facility Assignment (LOA-CFA).</p>
    pub loa: std::option::Option<crate::model::Loa>,
}
impl std::fmt::Debug for DescribeConnectionLoaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConnectionLoaOutput");
        formatter.field("loa", &self.loa);
        formatter.finish()
    }
}
/// See [`DescribeConnectionLoaOutput`](crate::output::DescribeConnectionLoaOutput)
pub mod describe_connection_loa_output {
    /// A builder for [`DescribeConnectionLoaOutput`](crate::output::DescribeConnectionLoaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) loa: std::option::Option<crate::model::Loa>,
    }
    impl Builder {
        /// <p>The Letter of Authorization - Connecting Facility Assignment (LOA-CFA).</p>
        pub fn loa(mut self, input: crate::model::Loa) -> Self {
            self.loa = Some(input);
            self
        }
        /// <p>The Letter of Authorization - Connecting Facility Assignment (LOA-CFA).</p>
        pub fn set_loa(mut self, input: std::option::Option<crate::model::Loa>) -> Self {
            self.loa = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConnectionLoaOutput`](crate::output::DescribeConnectionLoaOutput)
        pub fn build(self) -> crate::output::DescribeConnectionLoaOutput {
            crate::output::DescribeConnectionLoaOutput { loa: self.loa }
        }
    }
}
impl DescribeConnectionLoaOutput {
    /// Creates a new builder-style object to manufacture [`DescribeConnectionLoaOutput`](crate::output::DescribeConnectionLoaOutput)
    pub fn builder() -> crate::output::describe_connection_loa_output::Builder {
        crate::output::describe_connection_loa_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVirtualInterfaceOutput {
    /// <p>The state of the virtual interface. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: A virtual interface that is BGP down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The state of the virtual interface is not available.</p>
    /// </li>
    /// </ul>
    pub virtual_interface_state: std::option::Option<crate::model::VirtualInterfaceState>,
}
impl std::fmt::Debug for DeleteVirtualInterfaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVirtualInterfaceOutput");
        formatter.field("virtual_interface_state", &self.virtual_interface_state);
        formatter.finish()
    }
}
/// See [`DeleteVirtualInterfaceOutput`](crate::output::DeleteVirtualInterfaceOutput)
pub mod delete_virtual_interface_output {
    /// A builder for [`DeleteVirtualInterfaceOutput`](crate::output::DeleteVirtualInterfaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_interface_state:
            std::option::Option<crate::model::VirtualInterfaceState>,
    }
    impl Builder {
        /// <p>The state of the virtual interface. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: A virtual interface that is BGP down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the virtual interface is not available.</p>
        /// </li>
        /// </ul>
        pub fn virtual_interface_state(
            mut self,
            input: crate::model::VirtualInterfaceState,
        ) -> Self {
            self.virtual_interface_state = Some(input);
            self
        }
        /// <p>The state of the virtual interface. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: A virtual interface that is BGP down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the virtual interface is not available.</p>
        /// </li>
        /// </ul>
        pub fn set_virtual_interface_state(
            mut self,
            input: std::option::Option<crate::model::VirtualInterfaceState>,
        ) -> Self {
            self.virtual_interface_state = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVirtualInterfaceOutput`](crate::output::DeleteVirtualInterfaceOutput)
        pub fn build(self) -> crate::output::DeleteVirtualInterfaceOutput {
            crate::output::DeleteVirtualInterfaceOutput {
                virtual_interface_state: self.virtual_interface_state,
            }
        }
    }
}
impl DeleteVirtualInterfaceOutput {
    /// Creates a new builder-style object to manufacture [`DeleteVirtualInterfaceOutput`](crate::output::DeleteVirtualInterfaceOutput)
    pub fn builder() -> crate::output::delete_virtual_interface_output::Builder {
        crate::output::delete_virtual_interface_output::Builder::default()
    }
}

/// <p>Information about a link aggregation group (LAG).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLagOutput {
    /// <p>The individual bandwidth of the physical connections bundled by the LAG. The possible
    /// values are 1Gbps and 10Gbps. </p>
    pub connections_bandwidth: std::option::Option<std::string::String>,
    /// <p>The number of physical dedicated connections bundled by the LAG, up to a maximum of 10.</p>
    pub number_of_connections: i32,
    /// <p>The ID of the LAG.</p>
    pub lag_id: std::option::Option<std::string::String>,
    /// <p>The ID of the account that owns the LAG.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>The name of the LAG.</p>
    pub lag_name: std::option::Option<std::string::String>,
    /// <p>The state of the LAG. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>requested</code>: The initial state of a LAG. The LAG stays in the
    /// requested state until the Letter of Authorization (LOA) is available.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: The LAG has been approved and is being initialized.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: The network link is established and the LAG is ready for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: The network link is down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: The LAG is being deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: The LAG is deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The state of the LAG is not available.</p>
    /// </li>
    /// </ul>
    pub lag_state: std::option::Option<crate::model::LagState>,
    /// <p>The location of the LAG.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The Region where the connection is located.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The minimum number of physical dedicated connections that must be operational for the LAG itself to be operational.</p>
    pub minimum_links: i32,
    /// <p>The Direct Connect endpoint that hosts the LAG.</p>
    pub aws_device: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that hosts the LAG.</p>
    pub aws_device_v2: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
    /// different than the device that terminates the physical connection.</p>
    pub aws_logical_device_id: std::option::Option<std::string::String>,
    /// <p>The connections bundled by the LAG.</p>
    pub connections: std::option::Option<std::vec::Vec<crate::model::Connection>>,
    /// <p>Indicates whether the LAG can host other connections.</p>
    pub allows_hosted_connections: bool,
    /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    pub jumbo_frame_capable: std::option::Option<bool>,
    /// <p>Indicates whether the LAG supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
    pub has_logical_redundancy: std::option::Option<crate::model::HasLogicalRedundancy>,
    /// <p>The tags associated with the LAG.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The name of the service provider associated with the LAG.</p>
    pub provider_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether the LAG supports MAC Security (MACsec).</p>
    pub mac_sec_capable: std::option::Option<bool>,
    /// <p>The LAG MAC Security (MACsec) encryption mode.</p>
    /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
    pub encryption_mode: std::option::Option<std::string::String>,
    /// <p>The MAC Security (MACsec) security keys associated with the LAG.</p>
    pub mac_sec_keys: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
}
impl std::fmt::Debug for DeleteLagOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLagOutput");
        formatter.field("connections_bandwidth", &self.connections_bandwidth);
        formatter.field("number_of_connections", &self.number_of_connections);
        formatter.field("lag_id", &self.lag_id);
        formatter.field("owner_account", &self.owner_account);
        formatter.field("lag_name", &self.lag_name);
        formatter.field("lag_state", &self.lag_state);
        formatter.field("location", &self.location);
        formatter.field("region", &self.region);
        formatter.field("minimum_links", &self.minimum_links);
        formatter.field("aws_device", &self.aws_device);
        formatter.field("aws_device_v2", &self.aws_device_v2);
        formatter.field("aws_logical_device_id", &self.aws_logical_device_id);
        formatter.field("connections", &self.connections);
        formatter.field("allows_hosted_connections", &self.allows_hosted_connections);
        formatter.field("jumbo_frame_capable", &self.jumbo_frame_capable);
        formatter.field("has_logical_redundancy", &self.has_logical_redundancy);
        formatter.field("tags", &self.tags);
        formatter.field("provider_name", &self.provider_name);
        formatter.field("mac_sec_capable", &self.mac_sec_capable);
        formatter.field("encryption_mode", &self.encryption_mode);
        formatter.field("mac_sec_keys", &self.mac_sec_keys);
        formatter.finish()
    }
}
/// See [`DeleteLagOutput`](crate::output::DeleteLagOutput)
pub mod delete_lag_output {
    /// A builder for [`DeleteLagOutput`](crate::output::DeleteLagOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connections_bandwidth: std::option::Option<std::string::String>,
        pub(crate) number_of_connections: std::option::Option<i32>,
        pub(crate) lag_id: std::option::Option<std::string::String>,
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) lag_name: std::option::Option<std::string::String>,
        pub(crate) lag_state: std::option::Option<crate::model::LagState>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) minimum_links: std::option::Option<i32>,
        pub(crate) aws_device: std::option::Option<std::string::String>,
        pub(crate) aws_device_v2: std::option::Option<std::string::String>,
        pub(crate) aws_logical_device_id: std::option::Option<std::string::String>,
        pub(crate) connections: std::option::Option<std::vec::Vec<crate::model::Connection>>,
        pub(crate) allows_hosted_connections: std::option::Option<bool>,
        pub(crate) jumbo_frame_capable: std::option::Option<bool>,
        pub(crate) has_logical_redundancy: std::option::Option<crate::model::HasLogicalRedundancy>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) provider_name: std::option::Option<std::string::String>,
        pub(crate) mac_sec_capable: std::option::Option<bool>,
        pub(crate) encryption_mode: std::option::Option<std::string::String>,
        pub(crate) mac_sec_keys: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
    }
    impl Builder {
        /// <p>The individual bandwidth of the physical connections bundled by the LAG. The possible
        /// values are 1Gbps and 10Gbps. </p>
        pub fn connections_bandwidth(mut self, input: impl Into<std::string::String>) -> Self {
            self.connections_bandwidth = Some(input.into());
            self
        }
        /// <p>The individual bandwidth of the physical connections bundled by the LAG. The possible
        /// values are 1Gbps and 10Gbps. </p>
        pub fn set_connections_bandwidth(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connections_bandwidth = input;
            self
        }
        /// <p>The number of physical dedicated connections bundled by the LAG, up to a maximum of 10.</p>
        pub fn number_of_connections(mut self, input: i32) -> Self {
            self.number_of_connections = Some(input);
            self
        }
        /// <p>The number of physical dedicated connections bundled by the LAG, up to a maximum of 10.</p>
        pub fn set_number_of_connections(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_connections = input;
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.lag_id = Some(input.into());
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lag_id = input;
            self
        }
        /// <p>The ID of the account that owns the LAG.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the account that owns the LAG.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>The name of the LAG.</p>
        pub fn lag_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.lag_name = Some(input.into());
            self
        }
        /// <p>The name of the LAG.</p>
        pub fn set_lag_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lag_name = input;
            self
        }
        /// <p>The state of the LAG. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of a LAG. The LAG stays in the
        /// requested state until the Letter of Authorization (LOA) is available.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The LAG has been approved and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is established and the LAG is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The LAG is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The LAG is deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the LAG is not available.</p>
        /// </li>
        /// </ul>
        pub fn lag_state(mut self, input: crate::model::LagState) -> Self {
            self.lag_state = Some(input);
            self
        }
        /// <p>The state of the LAG. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of a LAG. The LAG stays in the
        /// requested state until the Letter of Authorization (LOA) is available.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The LAG has been approved and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is established and the LAG is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The LAG is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The LAG is deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the LAG is not available.</p>
        /// </li>
        /// </ul>
        pub fn set_lag_state(mut self, input: std::option::Option<crate::model::LagState>) -> Self {
            self.lag_state = input;
            self
        }
        /// <p>The location of the LAG.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The location of the LAG.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The Region where the connection is located.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Region where the connection is located.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The minimum number of physical dedicated connections that must be operational for the LAG itself to be operational.</p>
        pub fn minimum_links(mut self, input: i32) -> Self {
            self.minimum_links = Some(input);
            self
        }
        /// <p>The minimum number of physical dedicated connections that must be operational for the LAG itself to be operational.</p>
        pub fn set_minimum_links(mut self, input: std::option::Option<i32>) -> Self {
            self.minimum_links = input;
            self
        }
        /// <p>The Direct Connect endpoint that hosts the LAG.</p>
        pub fn aws_device(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that hosts the LAG.</p>
        pub fn set_aws_device(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_device = input;
            self
        }
        /// <p>The Direct Connect endpoint that hosts the LAG.</p>
        pub fn aws_device_v2(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device_v2 = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that hosts the LAG.</p>
        pub fn set_aws_device_v2(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_device_v2 = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn aws_logical_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_logical_device_id = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn set_aws_logical_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_logical_device_id = input;
            self
        }
        /// Appends an item to `connections`.
        ///
        /// To override the contents of this collection use [`set_connections`](Self::set_connections).
        ///
        /// <p>The connections bundled by the LAG.</p>
        pub fn connections(mut self, input: impl Into<crate::model::Connection>) -> Self {
            let mut v = self.connections.unwrap_or_default();
            v.push(input.into());
            self.connections = Some(v);
            self
        }
        /// <p>The connections bundled by the LAG.</p>
        pub fn set_connections(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Connection>>,
        ) -> Self {
            self.connections = input;
            self
        }
        /// <p>Indicates whether the LAG can host other connections.</p>
        pub fn allows_hosted_connections(mut self, input: bool) -> Self {
            self.allows_hosted_connections = Some(input);
            self
        }
        /// <p>Indicates whether the LAG can host other connections.</p>
        pub fn set_allows_hosted_connections(mut self, input: std::option::Option<bool>) -> Self {
            self.allows_hosted_connections = input;
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn jumbo_frame_capable(mut self, input: bool) -> Self {
            self.jumbo_frame_capable = Some(input);
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn set_jumbo_frame_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.jumbo_frame_capable = input;
            self
        }
        /// <p>Indicates whether the LAG supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
        pub fn has_logical_redundancy(mut self, input: crate::model::HasLogicalRedundancy) -> Self {
            self.has_logical_redundancy = Some(input);
            self
        }
        /// <p>Indicates whether the LAG supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
        pub fn set_has_logical_redundancy(
            mut self,
            input: std::option::Option<crate::model::HasLogicalRedundancy>,
        ) -> Self {
            self.has_logical_redundancy = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the LAG.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the LAG.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name of the service provider associated with the LAG.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The name of the service provider associated with the LAG.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// <p>Indicates whether the LAG supports MAC Security (MACsec).</p>
        pub fn mac_sec_capable(mut self, input: bool) -> Self {
            self.mac_sec_capable = Some(input);
            self
        }
        /// <p>Indicates whether the LAG supports MAC Security (MACsec).</p>
        pub fn set_mac_sec_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.mac_sec_capable = input;
            self
        }
        /// <p>The LAG MAC Security (MACsec) encryption mode.</p>
        /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
        pub fn encryption_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_mode = Some(input.into());
            self
        }
        /// <p>The LAG MAC Security (MACsec) encryption mode.</p>
        /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_mode = input;
            self
        }
        /// Appends an item to `mac_sec_keys`.
        ///
        /// To override the contents of this collection use [`set_mac_sec_keys`](Self::set_mac_sec_keys).
        ///
        /// <p>The MAC Security (MACsec) security keys associated with the LAG.</p>
        pub fn mac_sec_keys(mut self, input: impl Into<crate::model::MacSecKey>) -> Self {
            let mut v = self.mac_sec_keys.unwrap_or_default();
            v.push(input.into());
            self.mac_sec_keys = Some(v);
            self
        }
        /// <p>The MAC Security (MACsec) security keys associated with the LAG.</p>
        pub fn set_mac_sec_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
        ) -> Self {
            self.mac_sec_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLagOutput`](crate::output::DeleteLagOutput)
        pub fn build(self) -> crate::output::DeleteLagOutput {
            crate::output::DeleteLagOutput {
                connections_bandwidth: self.connections_bandwidth,
                number_of_connections: self.number_of_connections.unwrap_or_default(),
                lag_id: self.lag_id,
                owner_account: self.owner_account,
                lag_name: self.lag_name,
                lag_state: self.lag_state,
                location: self.location,
                region: self.region,
                minimum_links: self.minimum_links.unwrap_or_default(),
                aws_device: self.aws_device,
                aws_device_v2: self.aws_device_v2,
                aws_logical_device_id: self.aws_logical_device_id,
                connections: self.connections,
                allows_hosted_connections: self.allows_hosted_connections.unwrap_or_default(),
                jumbo_frame_capable: self.jumbo_frame_capable,
                has_logical_redundancy: self.has_logical_redundancy,
                tags: self.tags,
                provider_name: self.provider_name,
                mac_sec_capable: self.mac_sec_capable,
                encryption_mode: self.encryption_mode,
                mac_sec_keys: self.mac_sec_keys,
            }
        }
    }
}
impl DeleteLagOutput {
    /// Creates a new builder-style object to manufacture [`DeleteLagOutput`](crate::output::DeleteLagOutput)
    pub fn builder() -> crate::output::delete_lag_output::Builder {
        crate::output::delete_lag_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteInterconnectOutput {
    /// <p>The state of the interconnect. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>requested</code>: The initial state of an interconnect. The interconnect stays in the
    /// requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: The interconnect is approved, and is being initialized.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: The network link is up, and the interconnect is ready for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: The network link is down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: The interconnect is being deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: The interconnect is deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The state of the interconnect is not available.</p>
    /// </li>
    /// </ul>
    pub interconnect_state: std::option::Option<crate::model::InterconnectState>,
}
impl std::fmt::Debug for DeleteInterconnectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteInterconnectOutput");
        formatter.field("interconnect_state", &self.interconnect_state);
        formatter.finish()
    }
}
/// See [`DeleteInterconnectOutput`](crate::output::DeleteInterconnectOutput)
pub mod delete_interconnect_output {
    /// A builder for [`DeleteInterconnectOutput`](crate::output::DeleteInterconnectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) interconnect_state: std::option::Option<crate::model::InterconnectState>,
    }
    impl Builder {
        /// <p>The state of the interconnect. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of an interconnect. The interconnect stays in the
        /// requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The interconnect is approved, and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is up, and the interconnect is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The interconnect is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The interconnect is deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the interconnect is not available.</p>
        /// </li>
        /// </ul>
        pub fn interconnect_state(mut self, input: crate::model::InterconnectState) -> Self {
            self.interconnect_state = Some(input);
            self
        }
        /// <p>The state of the interconnect. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of an interconnect. The interconnect stays in the
        /// requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The interconnect is approved, and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is up, and the interconnect is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The interconnect is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The interconnect is deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the interconnect is not available.</p>
        /// </li>
        /// </ul>
        pub fn set_interconnect_state(
            mut self,
            input: std::option::Option<crate::model::InterconnectState>,
        ) -> Self {
            self.interconnect_state = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteInterconnectOutput`](crate::output::DeleteInterconnectOutput)
        pub fn build(self) -> crate::output::DeleteInterconnectOutput {
            crate::output::DeleteInterconnectOutput {
                interconnect_state: self.interconnect_state,
            }
        }
    }
}
impl DeleteInterconnectOutput {
    /// Creates a new builder-style object to manufacture [`DeleteInterconnectOutput`](crate::output::DeleteInterconnectOutput)
    pub fn builder() -> crate::output::delete_interconnect_output::Builder {
        crate::output::delete_interconnect_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDirectConnectGatewayAssociationProposalOutput {
    /// <p>The ID of the associated gateway.</p>
    pub direct_connect_gateway_association_proposal:
        std::option::Option<crate::model::DirectConnectGatewayAssociationProposal>,
}
impl std::fmt::Debug for DeleteDirectConnectGatewayAssociationProposalOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDirectConnectGatewayAssociationProposalOutput");
        formatter.field(
            "direct_connect_gateway_association_proposal",
            &self.direct_connect_gateway_association_proposal,
        );
        formatter.finish()
    }
}
/// See [`DeleteDirectConnectGatewayAssociationProposalOutput`](crate::output::DeleteDirectConnectGatewayAssociationProposalOutput)
pub mod delete_direct_connect_gateway_association_proposal_output {
    /// A builder for [`DeleteDirectConnectGatewayAssociationProposalOutput`](crate::output::DeleteDirectConnectGatewayAssociationProposalOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) direct_connect_gateway_association_proposal:
            std::option::Option<crate::model::DirectConnectGatewayAssociationProposal>,
    }
    impl Builder {
        /// <p>The ID of the associated gateway.</p>
        pub fn direct_connect_gateway_association_proposal(
            mut self,
            input: crate::model::DirectConnectGatewayAssociationProposal,
        ) -> Self {
            self.direct_connect_gateway_association_proposal = Some(input);
            self
        }
        /// <p>The ID of the associated gateway.</p>
        pub fn set_direct_connect_gateway_association_proposal(
            mut self,
            input: std::option::Option<crate::model::DirectConnectGatewayAssociationProposal>,
        ) -> Self {
            self.direct_connect_gateway_association_proposal = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDirectConnectGatewayAssociationProposalOutput`](crate::output::DeleteDirectConnectGatewayAssociationProposalOutput)
        pub fn build(self) -> crate::output::DeleteDirectConnectGatewayAssociationProposalOutput {
            crate::output::DeleteDirectConnectGatewayAssociationProposalOutput {
                direct_connect_gateway_association_proposal: self
                    .direct_connect_gateway_association_proposal,
            }
        }
    }
}
impl DeleteDirectConnectGatewayAssociationProposalOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDirectConnectGatewayAssociationProposalOutput`](crate::output::DeleteDirectConnectGatewayAssociationProposalOutput)
    pub fn builder(
    ) -> crate::output::delete_direct_connect_gateway_association_proposal_output::Builder {
        crate::output::delete_direct_connect_gateway_association_proposal_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDirectConnectGatewayAssociationOutput {
    /// <p>Information about the deleted association.</p>
    pub direct_connect_gateway_association:
        std::option::Option<crate::model::DirectConnectGatewayAssociation>,
}
impl std::fmt::Debug for DeleteDirectConnectGatewayAssociationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDirectConnectGatewayAssociationOutput");
        formatter.field(
            "direct_connect_gateway_association",
            &self.direct_connect_gateway_association,
        );
        formatter.finish()
    }
}
/// See [`DeleteDirectConnectGatewayAssociationOutput`](crate::output::DeleteDirectConnectGatewayAssociationOutput)
pub mod delete_direct_connect_gateway_association_output {
    /// A builder for [`DeleteDirectConnectGatewayAssociationOutput`](crate::output::DeleteDirectConnectGatewayAssociationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) direct_connect_gateway_association:
            std::option::Option<crate::model::DirectConnectGatewayAssociation>,
    }
    impl Builder {
        /// <p>Information about the deleted association.</p>
        pub fn direct_connect_gateway_association(
            mut self,
            input: crate::model::DirectConnectGatewayAssociation,
        ) -> Self {
            self.direct_connect_gateway_association = Some(input);
            self
        }
        /// <p>Information about the deleted association.</p>
        pub fn set_direct_connect_gateway_association(
            mut self,
            input: std::option::Option<crate::model::DirectConnectGatewayAssociation>,
        ) -> Self {
            self.direct_connect_gateway_association = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDirectConnectGatewayAssociationOutput`](crate::output::DeleteDirectConnectGatewayAssociationOutput)
        pub fn build(self) -> crate::output::DeleteDirectConnectGatewayAssociationOutput {
            crate::output::DeleteDirectConnectGatewayAssociationOutput {
                direct_connect_gateway_association: self.direct_connect_gateway_association,
            }
        }
    }
}
impl DeleteDirectConnectGatewayAssociationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDirectConnectGatewayAssociationOutput`](crate::output::DeleteDirectConnectGatewayAssociationOutput)
    pub fn builder() -> crate::output::delete_direct_connect_gateway_association_output::Builder {
        crate::output::delete_direct_connect_gateway_association_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDirectConnectGatewayOutput {
    /// <p>The Direct Connect gateway.</p>
    pub direct_connect_gateway: std::option::Option<crate::model::DirectConnectGateway>,
}
impl std::fmt::Debug for DeleteDirectConnectGatewayOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDirectConnectGatewayOutput");
        formatter.field("direct_connect_gateway", &self.direct_connect_gateway);
        formatter.finish()
    }
}
/// See [`DeleteDirectConnectGatewayOutput`](crate::output::DeleteDirectConnectGatewayOutput)
pub mod delete_direct_connect_gateway_output {
    /// A builder for [`DeleteDirectConnectGatewayOutput`](crate::output::DeleteDirectConnectGatewayOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) direct_connect_gateway: std::option::Option<crate::model::DirectConnectGateway>,
    }
    impl Builder {
        /// <p>The Direct Connect gateway.</p>
        pub fn direct_connect_gateway(mut self, input: crate::model::DirectConnectGateway) -> Self {
            self.direct_connect_gateway = Some(input);
            self
        }
        /// <p>The Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway(
            mut self,
            input: std::option::Option<crate::model::DirectConnectGateway>,
        ) -> Self {
            self.direct_connect_gateway = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDirectConnectGatewayOutput`](crate::output::DeleteDirectConnectGatewayOutput)
        pub fn build(self) -> crate::output::DeleteDirectConnectGatewayOutput {
            crate::output::DeleteDirectConnectGatewayOutput {
                direct_connect_gateway: self.direct_connect_gateway,
            }
        }
    }
}
impl DeleteDirectConnectGatewayOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDirectConnectGatewayOutput`](crate::output::DeleteDirectConnectGatewayOutput)
    pub fn builder() -> crate::output::delete_direct_connect_gateway_output::Builder {
        crate::output::delete_direct_connect_gateway_output::Builder::default()
    }
}

/// <p>Information about an Direct Connect connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConnectionOutput {
    /// <p>The ID of the account that owns the connection.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>The ID of the connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The name of the connection.</p>
    pub connection_name: std::option::Option<std::string::String>,
    /// <p>The state of the connection. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: The connection has been approved and is being initialized.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: The network link is up and the connection is ready for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: The network link is down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: The connection is being deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: The connection has been deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The state of the connection is not available.</p>
    /// </li>
    /// </ul>
    pub connection_state: std::option::Option<crate::model::ConnectionState>,
    /// <p>The Region where the connection is located.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The location of the connection.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The bandwidth of the connection.</p>
    pub bandwidth: std::option::Option<std::string::String>,
    /// <p>The ID of the VLAN.</p>
    pub vlan: i32,
    /// <p>The name of the Direct Connect service provider associated with the connection.</p>
    pub partner_name: std::option::Option<std::string::String>,
    /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
    pub loa_issue_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The ID of the LAG.</p>
    pub lag_id: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
    pub aws_device: std::option::Option<std::string::String>,
    /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    pub jumbo_frame_capable: std::option::Option<bool>,
    /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
    pub aws_device_v2: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
    /// different than the device that terminates the physical connection.</p>
    pub aws_logical_device_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
    pub has_logical_redundancy: std::option::Option<crate::model::HasLogicalRedundancy>,
    /// <p>The tags associated with the connection.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The name of the service provider associated with the connection.</p>
    pub provider_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether the connection supports MAC Security (MACsec).</p>
    pub mac_sec_capable: std::option::Option<bool>,
    /// <p>The MAC Security (MACsec) port link status of the connection.</p>
    /// <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
    pub port_encryption_status: std::option::Option<std::string::String>,
    /// <p>The MAC Security (MACsec) connection encryption mode.</p>
    /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
    pub encryption_mode: std::option::Option<std::string::String>,
    /// <p>The MAC Security (MACsec) security keys associated with the connection.</p>
    pub mac_sec_keys: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
}
impl std::fmt::Debug for DeleteConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConnectionOutput");
        formatter.field("owner_account", &self.owner_account);
        formatter.field("connection_id", &self.connection_id);
        formatter.field("connection_name", &self.connection_name);
        formatter.field("connection_state", &self.connection_state);
        formatter.field("region", &self.region);
        formatter.field("location", &self.location);
        formatter.field("bandwidth", &self.bandwidth);
        formatter.field("vlan", &self.vlan);
        formatter.field("partner_name", &self.partner_name);
        formatter.field("loa_issue_time", &self.loa_issue_time);
        formatter.field("lag_id", &self.lag_id);
        formatter.field("aws_device", &self.aws_device);
        formatter.field("jumbo_frame_capable", &self.jumbo_frame_capable);
        formatter.field("aws_device_v2", &self.aws_device_v2);
        formatter.field("aws_logical_device_id", &self.aws_logical_device_id);
        formatter.field("has_logical_redundancy", &self.has_logical_redundancy);
        formatter.field("tags", &self.tags);
        formatter.field("provider_name", &self.provider_name);
        formatter.field("mac_sec_capable", &self.mac_sec_capable);
        formatter.field("port_encryption_status", &self.port_encryption_status);
        formatter.field("encryption_mode", &self.encryption_mode);
        formatter.field("mac_sec_keys", &self.mac_sec_keys);
        formatter.finish()
    }
}
/// See [`DeleteConnectionOutput`](crate::output::DeleteConnectionOutput)
pub mod delete_connection_output {
    /// A builder for [`DeleteConnectionOutput`](crate::output::DeleteConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) connection_name: std::option::Option<std::string::String>,
        pub(crate) connection_state: std::option::Option<crate::model::ConnectionState>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) bandwidth: std::option::Option<std::string::String>,
        pub(crate) vlan: std::option::Option<i32>,
        pub(crate) partner_name: std::option::Option<std::string::String>,
        pub(crate) loa_issue_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) lag_id: std::option::Option<std::string::String>,
        pub(crate) aws_device: std::option::Option<std::string::String>,
        pub(crate) jumbo_frame_capable: std::option::Option<bool>,
        pub(crate) aws_device_v2: std::option::Option<std::string::String>,
        pub(crate) aws_logical_device_id: std::option::Option<std::string::String>,
        pub(crate) has_logical_redundancy: std::option::Option<crate::model::HasLogicalRedundancy>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) provider_name: std::option::Option<std::string::String>,
        pub(crate) mac_sec_capable: std::option::Option<bool>,
        pub(crate) port_encryption_status: std::option::Option<std::string::String>,
        pub(crate) encryption_mode: std::option::Option<std::string::String>,
        pub(crate) mac_sec_keys: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
    }
    impl Builder {
        /// <p>The ID of the account that owns the connection.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the account that owns the connection.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The name of the connection.</p>
        pub fn connection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_name = Some(input.into());
            self
        }
        /// <p>The name of the connection.</p>
        pub fn set_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_name = input;
            self
        }
        /// <p>The state of the connection. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The connection has been approved and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is up and the connection is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The connection is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The connection has been deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the connection is not available.</p>
        /// </li>
        /// </ul>
        pub fn connection_state(mut self, input: crate::model::ConnectionState) -> Self {
            self.connection_state = Some(input);
            self
        }
        /// <p>The state of the connection. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The connection has been approved and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is up and the connection is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The connection is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The connection has been deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the connection is not available.</p>
        /// </li>
        /// </ul>
        pub fn set_connection_state(
            mut self,
            input: std::option::Option<crate::model::ConnectionState>,
        ) -> Self {
            self.connection_state = input;
            self
        }
        /// <p>The Region where the connection is located.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Region where the connection is located.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The location of the connection.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The location of the connection.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The bandwidth of the connection.</p>
        pub fn bandwidth(mut self, input: impl Into<std::string::String>) -> Self {
            self.bandwidth = Some(input.into());
            self
        }
        /// <p>The bandwidth of the connection.</p>
        pub fn set_bandwidth(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bandwidth = input;
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn vlan(mut self, input: i32) -> Self {
            self.vlan = Some(input);
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn set_vlan(mut self, input: std::option::Option<i32>) -> Self {
            self.vlan = input;
            self
        }
        /// <p>The name of the Direct Connect service provider associated with the connection.</p>
        pub fn partner_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.partner_name = Some(input.into());
            self
        }
        /// <p>The name of the Direct Connect service provider associated with the connection.</p>
        pub fn set_partner_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.partner_name = input;
            self
        }
        /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
        pub fn loa_issue_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.loa_issue_time = Some(input);
            self
        }
        /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
        pub fn set_loa_issue_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.loa_issue_time = input;
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.lag_id = Some(input.into());
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lag_id = input;
            self
        }
        /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
        pub fn aws_device(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
        pub fn set_aws_device(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_device = input;
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn jumbo_frame_capable(mut self, input: bool) -> Self {
            self.jumbo_frame_capable = Some(input);
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn set_jumbo_frame_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.jumbo_frame_capable = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn aws_device_v2(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device_v2 = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn set_aws_device_v2(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_device_v2 = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn aws_logical_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_logical_device_id = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn set_aws_logical_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_logical_device_id = input;
            self
        }
        /// <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
        pub fn has_logical_redundancy(mut self, input: crate::model::HasLogicalRedundancy) -> Self {
            self.has_logical_redundancy = Some(input);
            self
        }
        /// <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
        pub fn set_has_logical_redundancy(
            mut self,
            input: std::option::Option<crate::model::HasLogicalRedundancy>,
        ) -> Self {
            self.has_logical_redundancy = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the connection.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the connection.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name of the service provider associated with the connection.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The name of the service provider associated with the connection.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// <p>Indicates whether the connection supports MAC Security (MACsec).</p>
        pub fn mac_sec_capable(mut self, input: bool) -> Self {
            self.mac_sec_capable = Some(input);
            self
        }
        /// <p>Indicates whether the connection supports MAC Security (MACsec).</p>
        pub fn set_mac_sec_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.mac_sec_capable = input;
            self
        }
        /// <p>The MAC Security (MACsec) port link status of the connection.</p>
        /// <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
        pub fn port_encryption_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.port_encryption_status = Some(input.into());
            self
        }
        /// <p>The MAC Security (MACsec) port link status of the connection.</p>
        /// <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
        pub fn set_port_encryption_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.port_encryption_status = input;
            self
        }
        /// <p>The MAC Security (MACsec) connection encryption mode.</p>
        /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
        pub fn encryption_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_mode = Some(input.into());
            self
        }
        /// <p>The MAC Security (MACsec) connection encryption mode.</p>
        /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_mode = input;
            self
        }
        /// Appends an item to `mac_sec_keys`.
        ///
        /// To override the contents of this collection use [`set_mac_sec_keys`](Self::set_mac_sec_keys).
        ///
        /// <p>The MAC Security (MACsec) security keys associated with the connection.</p>
        pub fn mac_sec_keys(mut self, input: impl Into<crate::model::MacSecKey>) -> Self {
            let mut v = self.mac_sec_keys.unwrap_or_default();
            v.push(input.into());
            self.mac_sec_keys = Some(v);
            self
        }
        /// <p>The MAC Security (MACsec) security keys associated with the connection.</p>
        pub fn set_mac_sec_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
        ) -> Self {
            self.mac_sec_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConnectionOutput`](crate::output::DeleteConnectionOutput)
        pub fn build(self) -> crate::output::DeleteConnectionOutput {
            crate::output::DeleteConnectionOutput {
                owner_account: self.owner_account,
                connection_id: self.connection_id,
                connection_name: self.connection_name,
                connection_state: self.connection_state,
                region: self.region,
                location: self.location,
                bandwidth: self.bandwidth,
                vlan: self.vlan.unwrap_or_default(),
                partner_name: self.partner_name,
                loa_issue_time: self.loa_issue_time,
                lag_id: self.lag_id,
                aws_device: self.aws_device,
                jumbo_frame_capable: self.jumbo_frame_capable,
                aws_device_v2: self.aws_device_v2,
                aws_logical_device_id: self.aws_logical_device_id,
                has_logical_redundancy: self.has_logical_redundancy,
                tags: self.tags,
                provider_name: self.provider_name,
                mac_sec_capable: self.mac_sec_capable,
                port_encryption_status: self.port_encryption_status,
                encryption_mode: self.encryption_mode,
                mac_sec_keys: self.mac_sec_keys,
            }
        }
    }
}
impl DeleteConnectionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteConnectionOutput`](crate::output::DeleteConnectionOutput)
    pub fn builder() -> crate::output::delete_connection_output::Builder {
        crate::output::delete_connection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBgpPeerOutput {
    /// <p>The virtual interface.</p>
    pub virtual_interface: std::option::Option<crate::model::VirtualInterface>,
}
impl std::fmt::Debug for DeleteBgpPeerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBgpPeerOutput");
        formatter.field("virtual_interface", &self.virtual_interface);
        formatter.finish()
    }
}
/// See [`DeleteBgpPeerOutput`](crate::output::DeleteBgpPeerOutput)
pub mod delete_bgp_peer_output {
    /// A builder for [`DeleteBgpPeerOutput`](crate::output::DeleteBgpPeerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_interface: std::option::Option<crate::model::VirtualInterface>,
    }
    impl Builder {
        /// <p>The virtual interface.</p>
        pub fn virtual_interface(mut self, input: crate::model::VirtualInterface) -> Self {
            self.virtual_interface = Some(input);
            self
        }
        /// <p>The virtual interface.</p>
        pub fn set_virtual_interface(
            mut self,
            input: std::option::Option<crate::model::VirtualInterface>,
        ) -> Self {
            self.virtual_interface = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBgpPeerOutput`](crate::output::DeleteBgpPeerOutput)
        pub fn build(self) -> crate::output::DeleteBgpPeerOutput {
            crate::output::DeleteBgpPeerOutput {
                virtual_interface: self.virtual_interface,
            }
        }
    }
}
impl DeleteBgpPeerOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBgpPeerOutput`](crate::output::DeleteBgpPeerOutput)
    pub fn builder() -> crate::output::delete_bgp_peer_output::Builder {
        crate::output::delete_bgp_peer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTransitVirtualInterfaceOutput {
    /// <p>Information about a virtual interface.</p>
    pub virtual_interface: std::option::Option<crate::model::VirtualInterface>,
}
impl std::fmt::Debug for CreateTransitVirtualInterfaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTransitVirtualInterfaceOutput");
        formatter.field("virtual_interface", &self.virtual_interface);
        formatter.finish()
    }
}
/// See [`CreateTransitVirtualInterfaceOutput`](crate::output::CreateTransitVirtualInterfaceOutput)
pub mod create_transit_virtual_interface_output {
    /// A builder for [`CreateTransitVirtualInterfaceOutput`](crate::output::CreateTransitVirtualInterfaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_interface: std::option::Option<crate::model::VirtualInterface>,
    }
    impl Builder {
        /// <p>Information about a virtual interface.</p>
        pub fn virtual_interface(mut self, input: crate::model::VirtualInterface) -> Self {
            self.virtual_interface = Some(input);
            self
        }
        /// <p>Information about a virtual interface.</p>
        pub fn set_virtual_interface(
            mut self,
            input: std::option::Option<crate::model::VirtualInterface>,
        ) -> Self {
            self.virtual_interface = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTransitVirtualInterfaceOutput`](crate::output::CreateTransitVirtualInterfaceOutput)
        pub fn build(self) -> crate::output::CreateTransitVirtualInterfaceOutput {
            crate::output::CreateTransitVirtualInterfaceOutput {
                virtual_interface: self.virtual_interface,
            }
        }
    }
}
impl CreateTransitVirtualInterfaceOutput {
    /// Creates a new builder-style object to manufacture [`CreateTransitVirtualInterfaceOutput`](crate::output::CreateTransitVirtualInterfaceOutput)
    pub fn builder() -> crate::output::create_transit_virtual_interface_output::Builder {
        crate::output::create_transit_virtual_interface_output::Builder::default()
    }
}

/// <p>Information about a virtual interface.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePublicVirtualInterfaceOutput {
    /// <p>The ID of the account that owns the virtual interface.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>The ID of the virtual interface.</p>
    pub virtual_interface_id: std::option::Option<std::string::String>,
    /// <p>The location of the connection.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The ID of the connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The type of virtual interface. The possible values are <code>private</code> and <code>public</code>.</p>
    pub virtual_interface_type: std::option::Option<std::string::String>,
    /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
    pub virtual_interface_name: std::option::Option<std::string::String>,
    /// <p>The ID of the VLAN.</p>
    pub vlan: i32,
    /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
    /// <p>The valid values are 1-2147483647.</p>
    pub asn: i32,
    /// <p>The autonomous system number (ASN) for the Amazon side of the connection.</p>
    pub amazon_side_asn: std::option::Option<i64>,
    /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
    pub auth_key: std::option::Option<std::string::String>,
    /// <p>The IP address assigned to the Amazon interface.</p>
    pub amazon_address: std::option::Option<std::string::String>,
    /// <p>The IP address assigned to the customer interface.</p>
    pub customer_address: std::option::Option<std::string::String>,
    /// <p>The address family for the BGP peer.</p>
    pub address_family: std::option::Option<crate::model::AddressFamily>,
    /// <p>The state of the virtual interface. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: A virtual interface that is BGP down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The state of the virtual interface is not available.</p>
    /// </li>
    /// </ul>
    pub virtual_interface_state: std::option::Option<crate::model::VirtualInterfaceState>,
    /// <p>The customer router configuration.</p>
    pub customer_router_config: std::option::Option<std::string::String>,
    /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
    pub mtu: std::option::Option<i32>,
    /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    pub jumbo_frame_capable: std::option::Option<bool>,
    /// <p>The ID of the virtual private gateway. Applies only to private virtual interfaces.</p>
    pub virtual_gateway_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Direct Connect gateway.</p>
    pub direct_connect_gateway_id: std::option::Option<std::string::String>,
    /// <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
    pub route_filter_prefixes: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
    /// <p>The BGP peers configured on this virtual interface.</p>
    pub bgp_peers: std::option::Option<std::vec::Vec<crate::model::BgpPeer>>,
    /// <p>The Region where the virtual interface is located.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
    pub aws_device_v2: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
    /// different than the device that terminates the physical connection.</p>
    pub aws_logical_device_id: std::option::Option<std::string::String>,
    /// <p>The tags associated with the virtual interface.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreatePublicVirtualInterfaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePublicVirtualInterfaceOutput");
        formatter.field("owner_account", &self.owner_account);
        formatter.field("virtual_interface_id", &self.virtual_interface_id);
        formatter.field("location", &self.location);
        formatter.field("connection_id", &self.connection_id);
        formatter.field("virtual_interface_type", &self.virtual_interface_type);
        formatter.field("virtual_interface_name", &self.virtual_interface_name);
        formatter.field("vlan", &self.vlan);
        formatter.field("asn", &self.asn);
        formatter.field("amazon_side_asn", &self.amazon_side_asn);
        formatter.field("auth_key", &self.auth_key);
        formatter.field("amazon_address", &self.amazon_address);
        formatter.field("customer_address", &self.customer_address);
        formatter.field("address_family", &self.address_family);
        formatter.field("virtual_interface_state", &self.virtual_interface_state);
        formatter.field("customer_router_config", &self.customer_router_config);
        formatter.field("mtu", &self.mtu);
        formatter.field("jumbo_frame_capable", &self.jumbo_frame_capable);
        formatter.field("virtual_gateway_id", &self.virtual_gateway_id);
        formatter.field("direct_connect_gateway_id", &self.direct_connect_gateway_id);
        formatter.field("route_filter_prefixes", &self.route_filter_prefixes);
        formatter.field("bgp_peers", &self.bgp_peers);
        formatter.field("region", &self.region);
        formatter.field("aws_device_v2", &self.aws_device_v2);
        formatter.field("aws_logical_device_id", &self.aws_logical_device_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreatePublicVirtualInterfaceOutput`](crate::output::CreatePublicVirtualInterfaceOutput)
pub mod create_public_virtual_interface_output {
    /// A builder for [`CreatePublicVirtualInterfaceOutput`](crate::output::CreatePublicVirtualInterfaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) virtual_interface_id: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) virtual_interface_type: std::option::Option<std::string::String>,
        pub(crate) virtual_interface_name: std::option::Option<std::string::String>,
        pub(crate) vlan: std::option::Option<i32>,
        pub(crate) asn: std::option::Option<i32>,
        pub(crate) amazon_side_asn: std::option::Option<i64>,
        pub(crate) auth_key: std::option::Option<std::string::String>,
        pub(crate) amazon_address: std::option::Option<std::string::String>,
        pub(crate) customer_address: std::option::Option<std::string::String>,
        pub(crate) address_family: std::option::Option<crate::model::AddressFamily>,
        pub(crate) virtual_interface_state:
            std::option::Option<crate::model::VirtualInterfaceState>,
        pub(crate) customer_router_config: std::option::Option<std::string::String>,
        pub(crate) mtu: std::option::Option<i32>,
        pub(crate) jumbo_frame_capable: std::option::Option<bool>,
        pub(crate) virtual_gateway_id: std::option::Option<std::string::String>,
        pub(crate) direct_connect_gateway_id: std::option::Option<std::string::String>,
        pub(crate) route_filter_prefixes:
            std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        pub(crate) bgp_peers: std::option::Option<std::vec::Vec<crate::model::BgpPeer>>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) aws_device_v2: std::option::Option<std::string::String>,
        pub(crate) aws_logical_device_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the account that owns the virtual interface.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the account that owns the virtual interface.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_id = input;
            self
        }
        /// <p>The location of the connection.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The location of the connection.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The type of virtual interface. The possible values are <code>private</code> and <code>public</code>.</p>
        pub fn virtual_interface_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_type = Some(input.into());
            self
        }
        /// <p>The type of virtual interface. The possible values are <code>private</code> and <code>public</code>.</p>
        pub fn set_virtual_interface_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_type = input;
            self
        }
        /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
        pub fn virtual_interface_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
        pub fn set_virtual_interface_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_name = input;
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn vlan(mut self, input: i32) -> Self {
            self.vlan = Some(input);
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn set_vlan(mut self, input: std::option::Option<i32>) -> Self {
            self.vlan = input;
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        /// <p>The valid values are 1-2147483647.</p>
        pub fn asn(mut self, input: i32) -> Self {
            self.asn = Some(input);
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        /// <p>The valid values are 1-2147483647.</p>
        pub fn set_asn(mut self, input: std::option::Option<i32>) -> Self {
            self.asn = input;
            self
        }
        /// <p>The autonomous system number (ASN) for the Amazon side of the connection.</p>
        pub fn amazon_side_asn(mut self, input: i64) -> Self {
            self.amazon_side_asn = Some(input);
            self
        }
        /// <p>The autonomous system number (ASN) for the Amazon side of the connection.</p>
        pub fn set_amazon_side_asn(mut self, input: std::option::Option<i64>) -> Self {
            self.amazon_side_asn = input;
            self
        }
        /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
        pub fn auth_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.auth_key = Some(input.into());
            self
        }
        /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
        pub fn set_auth_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.auth_key = input;
            self
        }
        /// <p>The IP address assigned to the Amazon interface.</p>
        pub fn amazon_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.amazon_address = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the Amazon interface.</p>
        pub fn set_amazon_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amazon_address = input;
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn customer_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_address = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn set_customer_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_address = input;
            self
        }
        /// <p>The address family for the BGP peer.</p>
        pub fn address_family(mut self, input: crate::model::AddressFamily) -> Self {
            self.address_family = Some(input);
            self
        }
        /// <p>The address family for the BGP peer.</p>
        pub fn set_address_family(
            mut self,
            input: std::option::Option<crate::model::AddressFamily>,
        ) -> Self {
            self.address_family = input;
            self
        }
        /// <p>The state of the virtual interface. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: A virtual interface that is BGP down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the virtual interface is not available.</p>
        /// </li>
        /// </ul>
        pub fn virtual_interface_state(
            mut self,
            input: crate::model::VirtualInterfaceState,
        ) -> Self {
            self.virtual_interface_state = Some(input);
            self
        }
        /// <p>The state of the virtual interface. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: A virtual interface that is BGP down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the virtual interface is not available.</p>
        /// </li>
        /// </ul>
        pub fn set_virtual_interface_state(
            mut self,
            input: std::option::Option<crate::model::VirtualInterfaceState>,
        ) -> Self {
            self.virtual_interface_state = input;
            self
        }
        /// <p>The customer router configuration.</p>
        pub fn customer_router_config(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_router_config = Some(input.into());
            self
        }
        /// <p>The customer router configuration.</p>
        pub fn set_customer_router_config(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_router_config = input;
            self
        }
        /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
        pub fn mtu(mut self, input: i32) -> Self {
            self.mtu = Some(input);
            self
        }
        /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
        pub fn set_mtu(mut self, input: std::option::Option<i32>) -> Self {
            self.mtu = input;
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn jumbo_frame_capable(mut self, input: bool) -> Self {
            self.jumbo_frame_capable = Some(input);
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn set_jumbo_frame_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.jumbo_frame_capable = input;
            self
        }
        /// <p>The ID of the virtual private gateway. Applies only to private virtual interfaces.</p>
        pub fn virtual_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual private gateway. Applies only to private virtual interfaces.</p>
        pub fn set_virtual_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_gateway_id = input;
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.direct_connect_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_id = input;
            self
        }
        /// Appends an item to `route_filter_prefixes`.
        ///
        /// To override the contents of this collection use [`set_route_filter_prefixes`](Self::set_route_filter_prefixes).
        ///
        /// <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
        pub fn route_filter_prefixes(
            mut self,
            input: impl Into<crate::model::RouteFilterPrefix>,
        ) -> Self {
            let mut v = self.route_filter_prefixes.unwrap_or_default();
            v.push(input.into());
            self.route_filter_prefixes = Some(v);
            self
        }
        /// <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
        pub fn set_route_filter_prefixes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        ) -> Self {
            self.route_filter_prefixes = input;
            self
        }
        /// Appends an item to `bgp_peers`.
        ///
        /// To override the contents of this collection use [`set_bgp_peers`](Self::set_bgp_peers).
        ///
        /// <p>The BGP peers configured on this virtual interface.</p>
        pub fn bgp_peers(mut self, input: impl Into<crate::model::BgpPeer>) -> Self {
            let mut v = self.bgp_peers.unwrap_or_default();
            v.push(input.into());
            self.bgp_peers = Some(v);
            self
        }
        /// <p>The BGP peers configured on this virtual interface.</p>
        pub fn set_bgp_peers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BgpPeer>>,
        ) -> Self {
            self.bgp_peers = input;
            self
        }
        /// <p>The Region where the virtual interface is located.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Region where the virtual interface is located.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn aws_device_v2(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device_v2 = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn set_aws_device_v2(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_device_v2 = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn aws_logical_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_logical_device_id = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn set_aws_logical_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_logical_device_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the virtual interface.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the virtual interface.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePublicVirtualInterfaceOutput`](crate::output::CreatePublicVirtualInterfaceOutput)
        pub fn build(self) -> crate::output::CreatePublicVirtualInterfaceOutput {
            crate::output::CreatePublicVirtualInterfaceOutput {
                owner_account: self.owner_account,
                virtual_interface_id: self.virtual_interface_id,
                location: self.location,
                connection_id: self.connection_id,
                virtual_interface_type: self.virtual_interface_type,
                virtual_interface_name: self.virtual_interface_name,
                vlan: self.vlan.unwrap_or_default(),
                asn: self.asn.unwrap_or_default(),
                amazon_side_asn: self.amazon_side_asn,
                auth_key: self.auth_key,
                amazon_address: self.amazon_address,
                customer_address: self.customer_address,
                address_family: self.address_family,
                virtual_interface_state: self.virtual_interface_state,
                customer_router_config: self.customer_router_config,
                mtu: self.mtu,
                jumbo_frame_capable: self.jumbo_frame_capable,
                virtual_gateway_id: self.virtual_gateway_id,
                direct_connect_gateway_id: self.direct_connect_gateway_id,
                route_filter_prefixes: self.route_filter_prefixes,
                bgp_peers: self.bgp_peers,
                region: self.region,
                aws_device_v2: self.aws_device_v2,
                aws_logical_device_id: self.aws_logical_device_id,
                tags: self.tags,
            }
        }
    }
}
impl CreatePublicVirtualInterfaceOutput {
    /// Creates a new builder-style object to manufacture [`CreatePublicVirtualInterfaceOutput`](crate::output::CreatePublicVirtualInterfaceOutput)
    pub fn builder() -> crate::output::create_public_virtual_interface_output::Builder {
        crate::output::create_public_virtual_interface_output::Builder::default()
    }
}

/// <p>Information about a virtual interface.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePrivateVirtualInterfaceOutput {
    /// <p>The ID of the account that owns the virtual interface.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>The ID of the virtual interface.</p>
    pub virtual_interface_id: std::option::Option<std::string::String>,
    /// <p>The location of the connection.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The ID of the connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The type of virtual interface. The possible values are <code>private</code> and <code>public</code>.</p>
    pub virtual_interface_type: std::option::Option<std::string::String>,
    /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
    pub virtual_interface_name: std::option::Option<std::string::String>,
    /// <p>The ID of the VLAN.</p>
    pub vlan: i32,
    /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
    /// <p>The valid values are 1-2147483647.</p>
    pub asn: i32,
    /// <p>The autonomous system number (ASN) for the Amazon side of the connection.</p>
    pub amazon_side_asn: std::option::Option<i64>,
    /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
    pub auth_key: std::option::Option<std::string::String>,
    /// <p>The IP address assigned to the Amazon interface.</p>
    pub amazon_address: std::option::Option<std::string::String>,
    /// <p>The IP address assigned to the customer interface.</p>
    pub customer_address: std::option::Option<std::string::String>,
    /// <p>The address family for the BGP peer.</p>
    pub address_family: std::option::Option<crate::model::AddressFamily>,
    /// <p>The state of the virtual interface. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: A virtual interface that is BGP down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The state of the virtual interface is not available.</p>
    /// </li>
    /// </ul>
    pub virtual_interface_state: std::option::Option<crate::model::VirtualInterfaceState>,
    /// <p>The customer router configuration.</p>
    pub customer_router_config: std::option::Option<std::string::String>,
    /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
    pub mtu: std::option::Option<i32>,
    /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    pub jumbo_frame_capable: std::option::Option<bool>,
    /// <p>The ID of the virtual private gateway. Applies only to private virtual interfaces.</p>
    pub virtual_gateway_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Direct Connect gateway.</p>
    pub direct_connect_gateway_id: std::option::Option<std::string::String>,
    /// <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
    pub route_filter_prefixes: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
    /// <p>The BGP peers configured on this virtual interface.</p>
    pub bgp_peers: std::option::Option<std::vec::Vec<crate::model::BgpPeer>>,
    /// <p>The Region where the virtual interface is located.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
    pub aws_device_v2: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
    /// different than the device that terminates the physical connection.</p>
    pub aws_logical_device_id: std::option::Option<std::string::String>,
    /// <p>The tags associated with the virtual interface.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreatePrivateVirtualInterfaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePrivateVirtualInterfaceOutput");
        formatter.field("owner_account", &self.owner_account);
        formatter.field("virtual_interface_id", &self.virtual_interface_id);
        formatter.field("location", &self.location);
        formatter.field("connection_id", &self.connection_id);
        formatter.field("virtual_interface_type", &self.virtual_interface_type);
        formatter.field("virtual_interface_name", &self.virtual_interface_name);
        formatter.field("vlan", &self.vlan);
        formatter.field("asn", &self.asn);
        formatter.field("amazon_side_asn", &self.amazon_side_asn);
        formatter.field("auth_key", &self.auth_key);
        formatter.field("amazon_address", &self.amazon_address);
        formatter.field("customer_address", &self.customer_address);
        formatter.field("address_family", &self.address_family);
        formatter.field("virtual_interface_state", &self.virtual_interface_state);
        formatter.field("customer_router_config", &self.customer_router_config);
        formatter.field("mtu", &self.mtu);
        formatter.field("jumbo_frame_capable", &self.jumbo_frame_capable);
        formatter.field("virtual_gateway_id", &self.virtual_gateway_id);
        formatter.field("direct_connect_gateway_id", &self.direct_connect_gateway_id);
        formatter.field("route_filter_prefixes", &self.route_filter_prefixes);
        formatter.field("bgp_peers", &self.bgp_peers);
        formatter.field("region", &self.region);
        formatter.field("aws_device_v2", &self.aws_device_v2);
        formatter.field("aws_logical_device_id", &self.aws_logical_device_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreatePrivateVirtualInterfaceOutput`](crate::output::CreatePrivateVirtualInterfaceOutput)
pub mod create_private_virtual_interface_output {
    /// A builder for [`CreatePrivateVirtualInterfaceOutput`](crate::output::CreatePrivateVirtualInterfaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) virtual_interface_id: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) virtual_interface_type: std::option::Option<std::string::String>,
        pub(crate) virtual_interface_name: std::option::Option<std::string::String>,
        pub(crate) vlan: std::option::Option<i32>,
        pub(crate) asn: std::option::Option<i32>,
        pub(crate) amazon_side_asn: std::option::Option<i64>,
        pub(crate) auth_key: std::option::Option<std::string::String>,
        pub(crate) amazon_address: std::option::Option<std::string::String>,
        pub(crate) customer_address: std::option::Option<std::string::String>,
        pub(crate) address_family: std::option::Option<crate::model::AddressFamily>,
        pub(crate) virtual_interface_state:
            std::option::Option<crate::model::VirtualInterfaceState>,
        pub(crate) customer_router_config: std::option::Option<std::string::String>,
        pub(crate) mtu: std::option::Option<i32>,
        pub(crate) jumbo_frame_capable: std::option::Option<bool>,
        pub(crate) virtual_gateway_id: std::option::Option<std::string::String>,
        pub(crate) direct_connect_gateway_id: std::option::Option<std::string::String>,
        pub(crate) route_filter_prefixes:
            std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        pub(crate) bgp_peers: std::option::Option<std::vec::Vec<crate::model::BgpPeer>>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) aws_device_v2: std::option::Option<std::string::String>,
        pub(crate) aws_logical_device_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the account that owns the virtual interface.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the account that owns the virtual interface.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_id = input;
            self
        }
        /// <p>The location of the connection.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The location of the connection.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The type of virtual interface. The possible values are <code>private</code> and <code>public</code>.</p>
        pub fn virtual_interface_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_type = Some(input.into());
            self
        }
        /// <p>The type of virtual interface. The possible values are <code>private</code> and <code>public</code>.</p>
        pub fn set_virtual_interface_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_type = input;
            self
        }
        /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
        pub fn virtual_interface_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
        pub fn set_virtual_interface_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_name = input;
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn vlan(mut self, input: i32) -> Self {
            self.vlan = Some(input);
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn set_vlan(mut self, input: std::option::Option<i32>) -> Self {
            self.vlan = input;
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        /// <p>The valid values are 1-2147483647.</p>
        pub fn asn(mut self, input: i32) -> Self {
            self.asn = Some(input);
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        /// <p>The valid values are 1-2147483647.</p>
        pub fn set_asn(mut self, input: std::option::Option<i32>) -> Self {
            self.asn = input;
            self
        }
        /// <p>The autonomous system number (ASN) for the Amazon side of the connection.</p>
        pub fn amazon_side_asn(mut self, input: i64) -> Self {
            self.amazon_side_asn = Some(input);
            self
        }
        /// <p>The autonomous system number (ASN) for the Amazon side of the connection.</p>
        pub fn set_amazon_side_asn(mut self, input: std::option::Option<i64>) -> Self {
            self.amazon_side_asn = input;
            self
        }
        /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
        pub fn auth_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.auth_key = Some(input.into());
            self
        }
        /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
        pub fn set_auth_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.auth_key = input;
            self
        }
        /// <p>The IP address assigned to the Amazon interface.</p>
        pub fn amazon_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.amazon_address = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the Amazon interface.</p>
        pub fn set_amazon_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amazon_address = input;
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn customer_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_address = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn set_customer_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_address = input;
            self
        }
        /// <p>The address family for the BGP peer.</p>
        pub fn address_family(mut self, input: crate::model::AddressFamily) -> Self {
            self.address_family = Some(input);
            self
        }
        /// <p>The address family for the BGP peer.</p>
        pub fn set_address_family(
            mut self,
            input: std::option::Option<crate::model::AddressFamily>,
        ) -> Self {
            self.address_family = input;
            self
        }
        /// <p>The state of the virtual interface. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: A virtual interface that is BGP down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the virtual interface is not available.</p>
        /// </li>
        /// </ul>
        pub fn virtual_interface_state(
            mut self,
            input: crate::model::VirtualInterfaceState,
        ) -> Self {
            self.virtual_interface_state = Some(input);
            self
        }
        /// <p>The state of the virtual interface. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: A virtual interface that is BGP down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the virtual interface is not available.</p>
        /// </li>
        /// </ul>
        pub fn set_virtual_interface_state(
            mut self,
            input: std::option::Option<crate::model::VirtualInterfaceState>,
        ) -> Self {
            self.virtual_interface_state = input;
            self
        }
        /// <p>The customer router configuration.</p>
        pub fn customer_router_config(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_router_config = Some(input.into());
            self
        }
        /// <p>The customer router configuration.</p>
        pub fn set_customer_router_config(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_router_config = input;
            self
        }
        /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
        pub fn mtu(mut self, input: i32) -> Self {
            self.mtu = Some(input);
            self
        }
        /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
        pub fn set_mtu(mut self, input: std::option::Option<i32>) -> Self {
            self.mtu = input;
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn jumbo_frame_capable(mut self, input: bool) -> Self {
            self.jumbo_frame_capable = Some(input);
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn set_jumbo_frame_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.jumbo_frame_capable = input;
            self
        }
        /// <p>The ID of the virtual private gateway. Applies only to private virtual interfaces.</p>
        pub fn virtual_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual private gateway. Applies only to private virtual interfaces.</p>
        pub fn set_virtual_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_gateway_id = input;
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.direct_connect_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_id = input;
            self
        }
        /// Appends an item to `route_filter_prefixes`.
        ///
        /// To override the contents of this collection use [`set_route_filter_prefixes`](Self::set_route_filter_prefixes).
        ///
        /// <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
        pub fn route_filter_prefixes(
            mut self,
            input: impl Into<crate::model::RouteFilterPrefix>,
        ) -> Self {
            let mut v = self.route_filter_prefixes.unwrap_or_default();
            v.push(input.into());
            self.route_filter_prefixes = Some(v);
            self
        }
        /// <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
        pub fn set_route_filter_prefixes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        ) -> Self {
            self.route_filter_prefixes = input;
            self
        }
        /// Appends an item to `bgp_peers`.
        ///
        /// To override the contents of this collection use [`set_bgp_peers`](Self::set_bgp_peers).
        ///
        /// <p>The BGP peers configured on this virtual interface.</p>
        pub fn bgp_peers(mut self, input: impl Into<crate::model::BgpPeer>) -> Self {
            let mut v = self.bgp_peers.unwrap_or_default();
            v.push(input.into());
            self.bgp_peers = Some(v);
            self
        }
        /// <p>The BGP peers configured on this virtual interface.</p>
        pub fn set_bgp_peers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BgpPeer>>,
        ) -> Self {
            self.bgp_peers = input;
            self
        }
        /// <p>The Region where the virtual interface is located.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Region where the virtual interface is located.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn aws_device_v2(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device_v2 = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn set_aws_device_v2(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_device_v2 = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn aws_logical_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_logical_device_id = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn set_aws_logical_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_logical_device_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the virtual interface.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the virtual interface.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePrivateVirtualInterfaceOutput`](crate::output::CreatePrivateVirtualInterfaceOutput)
        pub fn build(self) -> crate::output::CreatePrivateVirtualInterfaceOutput {
            crate::output::CreatePrivateVirtualInterfaceOutput {
                owner_account: self.owner_account,
                virtual_interface_id: self.virtual_interface_id,
                location: self.location,
                connection_id: self.connection_id,
                virtual_interface_type: self.virtual_interface_type,
                virtual_interface_name: self.virtual_interface_name,
                vlan: self.vlan.unwrap_or_default(),
                asn: self.asn.unwrap_or_default(),
                amazon_side_asn: self.amazon_side_asn,
                auth_key: self.auth_key,
                amazon_address: self.amazon_address,
                customer_address: self.customer_address,
                address_family: self.address_family,
                virtual_interface_state: self.virtual_interface_state,
                customer_router_config: self.customer_router_config,
                mtu: self.mtu,
                jumbo_frame_capable: self.jumbo_frame_capable,
                virtual_gateway_id: self.virtual_gateway_id,
                direct_connect_gateway_id: self.direct_connect_gateway_id,
                route_filter_prefixes: self.route_filter_prefixes,
                bgp_peers: self.bgp_peers,
                region: self.region,
                aws_device_v2: self.aws_device_v2,
                aws_logical_device_id: self.aws_logical_device_id,
                tags: self.tags,
            }
        }
    }
}
impl CreatePrivateVirtualInterfaceOutput {
    /// Creates a new builder-style object to manufacture [`CreatePrivateVirtualInterfaceOutput`](crate::output::CreatePrivateVirtualInterfaceOutput)
    pub fn builder() -> crate::output::create_private_virtual_interface_output::Builder {
        crate::output::create_private_virtual_interface_output::Builder::default()
    }
}

/// <p>Information about a link aggregation group (LAG).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLagOutput {
    /// <p>The individual bandwidth of the physical connections bundled by the LAG. The possible
    /// values are 1Gbps and 10Gbps. </p>
    pub connections_bandwidth: std::option::Option<std::string::String>,
    /// <p>The number of physical dedicated connections bundled by the LAG, up to a maximum of 10.</p>
    pub number_of_connections: i32,
    /// <p>The ID of the LAG.</p>
    pub lag_id: std::option::Option<std::string::String>,
    /// <p>The ID of the account that owns the LAG.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>The name of the LAG.</p>
    pub lag_name: std::option::Option<std::string::String>,
    /// <p>The state of the LAG. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>requested</code>: The initial state of a LAG. The LAG stays in the
    /// requested state until the Letter of Authorization (LOA) is available.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: The LAG has been approved and is being initialized.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: The network link is established and the LAG is ready for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: The network link is down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: The LAG is being deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: The LAG is deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The state of the LAG is not available.</p>
    /// </li>
    /// </ul>
    pub lag_state: std::option::Option<crate::model::LagState>,
    /// <p>The location of the LAG.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The Region where the connection is located.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The minimum number of physical dedicated connections that must be operational for the LAG itself to be operational.</p>
    pub minimum_links: i32,
    /// <p>The Direct Connect endpoint that hosts the LAG.</p>
    pub aws_device: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that hosts the LAG.</p>
    pub aws_device_v2: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
    /// different than the device that terminates the physical connection.</p>
    pub aws_logical_device_id: std::option::Option<std::string::String>,
    /// <p>The connections bundled by the LAG.</p>
    pub connections: std::option::Option<std::vec::Vec<crate::model::Connection>>,
    /// <p>Indicates whether the LAG can host other connections.</p>
    pub allows_hosted_connections: bool,
    /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    pub jumbo_frame_capable: std::option::Option<bool>,
    /// <p>Indicates whether the LAG supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
    pub has_logical_redundancy: std::option::Option<crate::model::HasLogicalRedundancy>,
    /// <p>The tags associated with the LAG.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The name of the service provider associated with the LAG.</p>
    pub provider_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether the LAG supports MAC Security (MACsec).</p>
    pub mac_sec_capable: std::option::Option<bool>,
    /// <p>The LAG MAC Security (MACsec) encryption mode.</p>
    /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
    pub encryption_mode: std::option::Option<std::string::String>,
    /// <p>The MAC Security (MACsec) security keys associated with the LAG.</p>
    pub mac_sec_keys: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
}
impl std::fmt::Debug for CreateLagOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLagOutput");
        formatter.field("connections_bandwidth", &self.connections_bandwidth);
        formatter.field("number_of_connections", &self.number_of_connections);
        formatter.field("lag_id", &self.lag_id);
        formatter.field("owner_account", &self.owner_account);
        formatter.field("lag_name", &self.lag_name);
        formatter.field("lag_state", &self.lag_state);
        formatter.field("location", &self.location);
        formatter.field("region", &self.region);
        formatter.field("minimum_links", &self.minimum_links);
        formatter.field("aws_device", &self.aws_device);
        formatter.field("aws_device_v2", &self.aws_device_v2);
        formatter.field("aws_logical_device_id", &self.aws_logical_device_id);
        formatter.field("connections", &self.connections);
        formatter.field("allows_hosted_connections", &self.allows_hosted_connections);
        formatter.field("jumbo_frame_capable", &self.jumbo_frame_capable);
        formatter.field("has_logical_redundancy", &self.has_logical_redundancy);
        formatter.field("tags", &self.tags);
        formatter.field("provider_name", &self.provider_name);
        formatter.field("mac_sec_capable", &self.mac_sec_capable);
        formatter.field("encryption_mode", &self.encryption_mode);
        formatter.field("mac_sec_keys", &self.mac_sec_keys);
        formatter.finish()
    }
}
/// See [`CreateLagOutput`](crate::output::CreateLagOutput)
pub mod create_lag_output {
    /// A builder for [`CreateLagOutput`](crate::output::CreateLagOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connections_bandwidth: std::option::Option<std::string::String>,
        pub(crate) number_of_connections: std::option::Option<i32>,
        pub(crate) lag_id: std::option::Option<std::string::String>,
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) lag_name: std::option::Option<std::string::String>,
        pub(crate) lag_state: std::option::Option<crate::model::LagState>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) minimum_links: std::option::Option<i32>,
        pub(crate) aws_device: std::option::Option<std::string::String>,
        pub(crate) aws_device_v2: std::option::Option<std::string::String>,
        pub(crate) aws_logical_device_id: std::option::Option<std::string::String>,
        pub(crate) connections: std::option::Option<std::vec::Vec<crate::model::Connection>>,
        pub(crate) allows_hosted_connections: std::option::Option<bool>,
        pub(crate) jumbo_frame_capable: std::option::Option<bool>,
        pub(crate) has_logical_redundancy: std::option::Option<crate::model::HasLogicalRedundancy>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) provider_name: std::option::Option<std::string::String>,
        pub(crate) mac_sec_capable: std::option::Option<bool>,
        pub(crate) encryption_mode: std::option::Option<std::string::String>,
        pub(crate) mac_sec_keys: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
    }
    impl Builder {
        /// <p>The individual bandwidth of the physical connections bundled by the LAG. The possible
        /// values are 1Gbps and 10Gbps. </p>
        pub fn connections_bandwidth(mut self, input: impl Into<std::string::String>) -> Self {
            self.connections_bandwidth = Some(input.into());
            self
        }
        /// <p>The individual bandwidth of the physical connections bundled by the LAG. The possible
        /// values are 1Gbps and 10Gbps. </p>
        pub fn set_connections_bandwidth(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connections_bandwidth = input;
            self
        }
        /// <p>The number of physical dedicated connections bundled by the LAG, up to a maximum of 10.</p>
        pub fn number_of_connections(mut self, input: i32) -> Self {
            self.number_of_connections = Some(input);
            self
        }
        /// <p>The number of physical dedicated connections bundled by the LAG, up to a maximum of 10.</p>
        pub fn set_number_of_connections(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_connections = input;
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.lag_id = Some(input.into());
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lag_id = input;
            self
        }
        /// <p>The ID of the account that owns the LAG.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the account that owns the LAG.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>The name of the LAG.</p>
        pub fn lag_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.lag_name = Some(input.into());
            self
        }
        /// <p>The name of the LAG.</p>
        pub fn set_lag_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lag_name = input;
            self
        }
        /// <p>The state of the LAG. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of a LAG. The LAG stays in the
        /// requested state until the Letter of Authorization (LOA) is available.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The LAG has been approved and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is established and the LAG is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The LAG is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The LAG is deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the LAG is not available.</p>
        /// </li>
        /// </ul>
        pub fn lag_state(mut self, input: crate::model::LagState) -> Self {
            self.lag_state = Some(input);
            self
        }
        /// <p>The state of the LAG. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of a LAG. The LAG stays in the
        /// requested state until the Letter of Authorization (LOA) is available.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The LAG has been approved and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is established and the LAG is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The LAG is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The LAG is deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the LAG is not available.</p>
        /// </li>
        /// </ul>
        pub fn set_lag_state(mut self, input: std::option::Option<crate::model::LagState>) -> Self {
            self.lag_state = input;
            self
        }
        /// <p>The location of the LAG.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The location of the LAG.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The Region where the connection is located.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Region where the connection is located.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The minimum number of physical dedicated connections that must be operational for the LAG itself to be operational.</p>
        pub fn minimum_links(mut self, input: i32) -> Self {
            self.minimum_links = Some(input);
            self
        }
        /// <p>The minimum number of physical dedicated connections that must be operational for the LAG itself to be operational.</p>
        pub fn set_minimum_links(mut self, input: std::option::Option<i32>) -> Self {
            self.minimum_links = input;
            self
        }
        /// <p>The Direct Connect endpoint that hosts the LAG.</p>
        pub fn aws_device(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that hosts the LAG.</p>
        pub fn set_aws_device(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_device = input;
            self
        }
        /// <p>The Direct Connect endpoint that hosts the LAG.</p>
        pub fn aws_device_v2(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device_v2 = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that hosts the LAG.</p>
        pub fn set_aws_device_v2(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_device_v2 = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn aws_logical_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_logical_device_id = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn set_aws_logical_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_logical_device_id = input;
            self
        }
        /// Appends an item to `connections`.
        ///
        /// To override the contents of this collection use [`set_connections`](Self::set_connections).
        ///
        /// <p>The connections bundled by the LAG.</p>
        pub fn connections(mut self, input: impl Into<crate::model::Connection>) -> Self {
            let mut v = self.connections.unwrap_or_default();
            v.push(input.into());
            self.connections = Some(v);
            self
        }
        /// <p>The connections bundled by the LAG.</p>
        pub fn set_connections(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Connection>>,
        ) -> Self {
            self.connections = input;
            self
        }
        /// <p>Indicates whether the LAG can host other connections.</p>
        pub fn allows_hosted_connections(mut self, input: bool) -> Self {
            self.allows_hosted_connections = Some(input);
            self
        }
        /// <p>Indicates whether the LAG can host other connections.</p>
        pub fn set_allows_hosted_connections(mut self, input: std::option::Option<bool>) -> Self {
            self.allows_hosted_connections = input;
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn jumbo_frame_capable(mut self, input: bool) -> Self {
            self.jumbo_frame_capable = Some(input);
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn set_jumbo_frame_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.jumbo_frame_capable = input;
            self
        }
        /// <p>Indicates whether the LAG supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
        pub fn has_logical_redundancy(mut self, input: crate::model::HasLogicalRedundancy) -> Self {
            self.has_logical_redundancy = Some(input);
            self
        }
        /// <p>Indicates whether the LAG supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
        pub fn set_has_logical_redundancy(
            mut self,
            input: std::option::Option<crate::model::HasLogicalRedundancy>,
        ) -> Self {
            self.has_logical_redundancy = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the LAG.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the LAG.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name of the service provider associated with the LAG.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The name of the service provider associated with the LAG.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// <p>Indicates whether the LAG supports MAC Security (MACsec).</p>
        pub fn mac_sec_capable(mut self, input: bool) -> Self {
            self.mac_sec_capable = Some(input);
            self
        }
        /// <p>Indicates whether the LAG supports MAC Security (MACsec).</p>
        pub fn set_mac_sec_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.mac_sec_capable = input;
            self
        }
        /// <p>The LAG MAC Security (MACsec) encryption mode.</p>
        /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
        pub fn encryption_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_mode = Some(input.into());
            self
        }
        /// <p>The LAG MAC Security (MACsec) encryption mode.</p>
        /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_mode = input;
            self
        }
        /// Appends an item to `mac_sec_keys`.
        ///
        /// To override the contents of this collection use [`set_mac_sec_keys`](Self::set_mac_sec_keys).
        ///
        /// <p>The MAC Security (MACsec) security keys associated with the LAG.</p>
        pub fn mac_sec_keys(mut self, input: impl Into<crate::model::MacSecKey>) -> Self {
            let mut v = self.mac_sec_keys.unwrap_or_default();
            v.push(input.into());
            self.mac_sec_keys = Some(v);
            self
        }
        /// <p>The MAC Security (MACsec) security keys associated with the LAG.</p>
        pub fn set_mac_sec_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
        ) -> Self {
            self.mac_sec_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLagOutput`](crate::output::CreateLagOutput)
        pub fn build(self) -> crate::output::CreateLagOutput {
            crate::output::CreateLagOutput {
                connections_bandwidth: self.connections_bandwidth,
                number_of_connections: self.number_of_connections.unwrap_or_default(),
                lag_id: self.lag_id,
                owner_account: self.owner_account,
                lag_name: self.lag_name,
                lag_state: self.lag_state,
                location: self.location,
                region: self.region,
                minimum_links: self.minimum_links.unwrap_or_default(),
                aws_device: self.aws_device,
                aws_device_v2: self.aws_device_v2,
                aws_logical_device_id: self.aws_logical_device_id,
                connections: self.connections,
                allows_hosted_connections: self.allows_hosted_connections.unwrap_or_default(),
                jumbo_frame_capable: self.jumbo_frame_capable,
                has_logical_redundancy: self.has_logical_redundancy,
                tags: self.tags,
                provider_name: self.provider_name,
                mac_sec_capable: self.mac_sec_capable,
                encryption_mode: self.encryption_mode,
                mac_sec_keys: self.mac_sec_keys,
            }
        }
    }
}
impl CreateLagOutput {
    /// Creates a new builder-style object to manufacture [`CreateLagOutput`](crate::output::CreateLagOutput)
    pub fn builder() -> crate::output::create_lag_output::Builder {
        crate::output::create_lag_output::Builder::default()
    }
}

/// <p>Information about an interconnect.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateInterconnectOutput {
    /// <p>The ID of the interconnect.</p>
    pub interconnect_id: std::option::Option<std::string::String>,
    /// <p>The name of the interconnect.</p>
    pub interconnect_name: std::option::Option<std::string::String>,
    /// <p>The state of the interconnect. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>requested</code>: The initial state of an interconnect. The interconnect stays in the
    /// requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: The interconnect is approved, and is being initialized.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: The network link is up, and the interconnect is ready for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: The network link is down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: The interconnect is being deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: The interconnect is deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The state of the interconnect is not available.</p>
    /// </li>
    /// </ul>
    pub interconnect_state: std::option::Option<crate::model::InterconnectState>,
    /// <p>The Region where the connection is located.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The location of the connection.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The bandwidth of the connection.</p>
    pub bandwidth: std::option::Option<std::string::String>,
    /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
    pub loa_issue_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The ID of the LAG.</p>
    pub lag_id: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
    pub aws_device: std::option::Option<std::string::String>,
    /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    pub jumbo_frame_capable: std::option::Option<bool>,
    /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
    pub aws_device_v2: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
    /// different than the device that terminates the physical connection.</p>
    pub aws_logical_device_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether the interconnect supports a secondary BGP in the same address family (IPv4/IPv6).</p>
    pub has_logical_redundancy: std::option::Option<crate::model::HasLogicalRedundancy>,
    /// <p>The tags associated with the interconnect.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The name of the service provider associated with the interconnect.</p>
    pub provider_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateInterconnectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateInterconnectOutput");
        formatter.field("interconnect_id", &self.interconnect_id);
        formatter.field("interconnect_name", &self.interconnect_name);
        formatter.field("interconnect_state", &self.interconnect_state);
        formatter.field("region", &self.region);
        formatter.field("location", &self.location);
        formatter.field("bandwidth", &self.bandwidth);
        formatter.field("loa_issue_time", &self.loa_issue_time);
        formatter.field("lag_id", &self.lag_id);
        formatter.field("aws_device", &self.aws_device);
        formatter.field("jumbo_frame_capable", &self.jumbo_frame_capable);
        formatter.field("aws_device_v2", &self.aws_device_v2);
        formatter.field("aws_logical_device_id", &self.aws_logical_device_id);
        formatter.field("has_logical_redundancy", &self.has_logical_redundancy);
        formatter.field("tags", &self.tags);
        formatter.field("provider_name", &self.provider_name);
        formatter.finish()
    }
}
/// See [`CreateInterconnectOutput`](crate::output::CreateInterconnectOutput)
pub mod create_interconnect_output {
    /// A builder for [`CreateInterconnectOutput`](crate::output::CreateInterconnectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) interconnect_id: std::option::Option<std::string::String>,
        pub(crate) interconnect_name: std::option::Option<std::string::String>,
        pub(crate) interconnect_state: std::option::Option<crate::model::InterconnectState>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) bandwidth: std::option::Option<std::string::String>,
        pub(crate) loa_issue_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) lag_id: std::option::Option<std::string::String>,
        pub(crate) aws_device: std::option::Option<std::string::String>,
        pub(crate) jumbo_frame_capable: std::option::Option<bool>,
        pub(crate) aws_device_v2: std::option::Option<std::string::String>,
        pub(crate) aws_logical_device_id: std::option::Option<std::string::String>,
        pub(crate) has_logical_redundancy: std::option::Option<crate::model::HasLogicalRedundancy>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) provider_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the interconnect.</p>
        pub fn interconnect_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.interconnect_id = Some(input.into());
            self
        }
        /// <p>The ID of the interconnect.</p>
        pub fn set_interconnect_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.interconnect_id = input;
            self
        }
        /// <p>The name of the interconnect.</p>
        pub fn interconnect_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.interconnect_name = Some(input.into());
            self
        }
        /// <p>The name of the interconnect.</p>
        pub fn set_interconnect_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.interconnect_name = input;
            self
        }
        /// <p>The state of the interconnect. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of an interconnect. The interconnect stays in the
        /// requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The interconnect is approved, and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is up, and the interconnect is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The interconnect is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The interconnect is deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the interconnect is not available.</p>
        /// </li>
        /// </ul>
        pub fn interconnect_state(mut self, input: crate::model::InterconnectState) -> Self {
            self.interconnect_state = Some(input);
            self
        }
        /// <p>The state of the interconnect. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of an interconnect. The interconnect stays in the
        /// requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The interconnect is approved, and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is up, and the interconnect is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The interconnect is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The interconnect is deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the interconnect is not available.</p>
        /// </li>
        /// </ul>
        pub fn set_interconnect_state(
            mut self,
            input: std::option::Option<crate::model::InterconnectState>,
        ) -> Self {
            self.interconnect_state = input;
            self
        }
        /// <p>The Region where the connection is located.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Region where the connection is located.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The location of the connection.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The location of the connection.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The bandwidth of the connection.</p>
        pub fn bandwidth(mut self, input: impl Into<std::string::String>) -> Self {
            self.bandwidth = Some(input.into());
            self
        }
        /// <p>The bandwidth of the connection.</p>
        pub fn set_bandwidth(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bandwidth = input;
            self
        }
        /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
        pub fn loa_issue_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.loa_issue_time = Some(input);
            self
        }
        /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
        pub fn set_loa_issue_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.loa_issue_time = input;
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.lag_id = Some(input.into());
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lag_id = input;
            self
        }
        /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
        pub fn aws_device(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
        pub fn set_aws_device(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_device = input;
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn jumbo_frame_capable(mut self, input: bool) -> Self {
            self.jumbo_frame_capable = Some(input);
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn set_jumbo_frame_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.jumbo_frame_capable = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn aws_device_v2(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device_v2 = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn set_aws_device_v2(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_device_v2 = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn aws_logical_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_logical_device_id = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn set_aws_logical_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_logical_device_id = input;
            self
        }
        /// <p>Indicates whether the interconnect supports a secondary BGP in the same address family (IPv4/IPv6).</p>
        pub fn has_logical_redundancy(mut self, input: crate::model::HasLogicalRedundancy) -> Self {
            self.has_logical_redundancy = Some(input);
            self
        }
        /// <p>Indicates whether the interconnect supports a secondary BGP in the same address family (IPv4/IPv6).</p>
        pub fn set_has_logical_redundancy(
            mut self,
            input: std::option::Option<crate::model::HasLogicalRedundancy>,
        ) -> Self {
            self.has_logical_redundancy = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the interconnect.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the interconnect.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name of the service provider associated with the interconnect.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The name of the service provider associated with the interconnect.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateInterconnectOutput`](crate::output::CreateInterconnectOutput)
        pub fn build(self) -> crate::output::CreateInterconnectOutput {
            crate::output::CreateInterconnectOutput {
                interconnect_id: self.interconnect_id,
                interconnect_name: self.interconnect_name,
                interconnect_state: self.interconnect_state,
                region: self.region,
                location: self.location,
                bandwidth: self.bandwidth,
                loa_issue_time: self.loa_issue_time,
                lag_id: self.lag_id,
                aws_device: self.aws_device,
                jumbo_frame_capable: self.jumbo_frame_capable,
                aws_device_v2: self.aws_device_v2,
                aws_logical_device_id: self.aws_logical_device_id,
                has_logical_redundancy: self.has_logical_redundancy,
                tags: self.tags,
                provider_name: self.provider_name,
            }
        }
    }
}
impl CreateInterconnectOutput {
    /// Creates a new builder-style object to manufacture [`CreateInterconnectOutput`](crate::output::CreateInterconnectOutput)
    pub fn builder() -> crate::output::create_interconnect_output::Builder {
        crate::output::create_interconnect_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDirectConnectGatewayAssociationProposalOutput {
    /// <p>Information about the Direct Connect gateway proposal.</p>
    pub direct_connect_gateway_association_proposal:
        std::option::Option<crate::model::DirectConnectGatewayAssociationProposal>,
}
impl std::fmt::Debug for CreateDirectConnectGatewayAssociationProposalOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDirectConnectGatewayAssociationProposalOutput");
        formatter.field(
            "direct_connect_gateway_association_proposal",
            &self.direct_connect_gateway_association_proposal,
        );
        formatter.finish()
    }
}
/// See [`CreateDirectConnectGatewayAssociationProposalOutput`](crate::output::CreateDirectConnectGatewayAssociationProposalOutput)
pub mod create_direct_connect_gateway_association_proposal_output {
    /// A builder for [`CreateDirectConnectGatewayAssociationProposalOutput`](crate::output::CreateDirectConnectGatewayAssociationProposalOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) direct_connect_gateway_association_proposal:
            std::option::Option<crate::model::DirectConnectGatewayAssociationProposal>,
    }
    impl Builder {
        /// <p>Information about the Direct Connect gateway proposal.</p>
        pub fn direct_connect_gateway_association_proposal(
            mut self,
            input: crate::model::DirectConnectGatewayAssociationProposal,
        ) -> Self {
            self.direct_connect_gateway_association_proposal = Some(input);
            self
        }
        /// <p>Information about the Direct Connect gateway proposal.</p>
        pub fn set_direct_connect_gateway_association_proposal(
            mut self,
            input: std::option::Option<crate::model::DirectConnectGatewayAssociationProposal>,
        ) -> Self {
            self.direct_connect_gateway_association_proposal = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDirectConnectGatewayAssociationProposalOutput`](crate::output::CreateDirectConnectGatewayAssociationProposalOutput)
        pub fn build(self) -> crate::output::CreateDirectConnectGatewayAssociationProposalOutput {
            crate::output::CreateDirectConnectGatewayAssociationProposalOutput {
                direct_connect_gateway_association_proposal: self
                    .direct_connect_gateway_association_proposal,
            }
        }
    }
}
impl CreateDirectConnectGatewayAssociationProposalOutput {
    /// Creates a new builder-style object to manufacture [`CreateDirectConnectGatewayAssociationProposalOutput`](crate::output::CreateDirectConnectGatewayAssociationProposalOutput)
    pub fn builder(
    ) -> crate::output::create_direct_connect_gateway_association_proposal_output::Builder {
        crate::output::create_direct_connect_gateway_association_proposal_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDirectConnectGatewayAssociationOutput {
    /// <p>The association to be created.</p>
    pub direct_connect_gateway_association:
        std::option::Option<crate::model::DirectConnectGatewayAssociation>,
}
impl std::fmt::Debug for CreateDirectConnectGatewayAssociationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDirectConnectGatewayAssociationOutput");
        formatter.field(
            "direct_connect_gateway_association",
            &self.direct_connect_gateway_association,
        );
        formatter.finish()
    }
}
/// See [`CreateDirectConnectGatewayAssociationOutput`](crate::output::CreateDirectConnectGatewayAssociationOutput)
pub mod create_direct_connect_gateway_association_output {
    /// A builder for [`CreateDirectConnectGatewayAssociationOutput`](crate::output::CreateDirectConnectGatewayAssociationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) direct_connect_gateway_association:
            std::option::Option<crate::model::DirectConnectGatewayAssociation>,
    }
    impl Builder {
        /// <p>The association to be created.</p>
        pub fn direct_connect_gateway_association(
            mut self,
            input: crate::model::DirectConnectGatewayAssociation,
        ) -> Self {
            self.direct_connect_gateway_association = Some(input);
            self
        }
        /// <p>The association to be created.</p>
        pub fn set_direct_connect_gateway_association(
            mut self,
            input: std::option::Option<crate::model::DirectConnectGatewayAssociation>,
        ) -> Self {
            self.direct_connect_gateway_association = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDirectConnectGatewayAssociationOutput`](crate::output::CreateDirectConnectGatewayAssociationOutput)
        pub fn build(self) -> crate::output::CreateDirectConnectGatewayAssociationOutput {
            crate::output::CreateDirectConnectGatewayAssociationOutput {
                direct_connect_gateway_association: self.direct_connect_gateway_association,
            }
        }
    }
}
impl CreateDirectConnectGatewayAssociationOutput {
    /// Creates a new builder-style object to manufacture [`CreateDirectConnectGatewayAssociationOutput`](crate::output::CreateDirectConnectGatewayAssociationOutput)
    pub fn builder() -> crate::output::create_direct_connect_gateway_association_output::Builder {
        crate::output::create_direct_connect_gateway_association_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDirectConnectGatewayOutput {
    /// <p>The Direct Connect gateway.</p>
    pub direct_connect_gateway: std::option::Option<crate::model::DirectConnectGateway>,
}
impl std::fmt::Debug for CreateDirectConnectGatewayOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDirectConnectGatewayOutput");
        formatter.field("direct_connect_gateway", &self.direct_connect_gateway);
        formatter.finish()
    }
}
/// See [`CreateDirectConnectGatewayOutput`](crate::output::CreateDirectConnectGatewayOutput)
pub mod create_direct_connect_gateway_output {
    /// A builder for [`CreateDirectConnectGatewayOutput`](crate::output::CreateDirectConnectGatewayOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) direct_connect_gateway: std::option::Option<crate::model::DirectConnectGateway>,
    }
    impl Builder {
        /// <p>The Direct Connect gateway.</p>
        pub fn direct_connect_gateway(mut self, input: crate::model::DirectConnectGateway) -> Self {
            self.direct_connect_gateway = Some(input);
            self
        }
        /// <p>The Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway(
            mut self,
            input: std::option::Option<crate::model::DirectConnectGateway>,
        ) -> Self {
            self.direct_connect_gateway = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDirectConnectGatewayOutput`](crate::output::CreateDirectConnectGatewayOutput)
        pub fn build(self) -> crate::output::CreateDirectConnectGatewayOutput {
            crate::output::CreateDirectConnectGatewayOutput {
                direct_connect_gateway: self.direct_connect_gateway,
            }
        }
    }
}
impl CreateDirectConnectGatewayOutput {
    /// Creates a new builder-style object to manufacture [`CreateDirectConnectGatewayOutput`](crate::output::CreateDirectConnectGatewayOutput)
    pub fn builder() -> crate::output::create_direct_connect_gateway_output::Builder {
        crate::output::create_direct_connect_gateway_output::Builder::default()
    }
}

/// <p>Information about an Direct Connect connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConnectionOutput {
    /// <p>The ID of the account that owns the connection.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>The ID of the connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The name of the connection.</p>
    pub connection_name: std::option::Option<std::string::String>,
    /// <p>The state of the connection. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: The connection has been approved and is being initialized.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: The network link is up and the connection is ready for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: The network link is down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: The connection is being deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: The connection has been deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The state of the connection is not available.</p>
    /// </li>
    /// </ul>
    pub connection_state: std::option::Option<crate::model::ConnectionState>,
    /// <p>The Region where the connection is located.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The location of the connection.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The bandwidth of the connection.</p>
    pub bandwidth: std::option::Option<std::string::String>,
    /// <p>The ID of the VLAN.</p>
    pub vlan: i32,
    /// <p>The name of the Direct Connect service provider associated with the connection.</p>
    pub partner_name: std::option::Option<std::string::String>,
    /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
    pub loa_issue_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The ID of the LAG.</p>
    pub lag_id: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
    pub aws_device: std::option::Option<std::string::String>,
    /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    pub jumbo_frame_capable: std::option::Option<bool>,
    /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
    pub aws_device_v2: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
    /// different than the device that terminates the physical connection.</p>
    pub aws_logical_device_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
    pub has_logical_redundancy: std::option::Option<crate::model::HasLogicalRedundancy>,
    /// <p>The tags associated with the connection.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The name of the service provider associated with the connection.</p>
    pub provider_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether the connection supports MAC Security (MACsec).</p>
    pub mac_sec_capable: std::option::Option<bool>,
    /// <p>The MAC Security (MACsec) port link status of the connection.</p>
    /// <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
    pub port_encryption_status: std::option::Option<std::string::String>,
    /// <p>The MAC Security (MACsec) connection encryption mode.</p>
    /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
    pub encryption_mode: std::option::Option<std::string::String>,
    /// <p>The MAC Security (MACsec) security keys associated with the connection.</p>
    pub mac_sec_keys: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
}
impl std::fmt::Debug for CreateConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConnectionOutput");
        formatter.field("owner_account", &self.owner_account);
        formatter.field("connection_id", &self.connection_id);
        formatter.field("connection_name", &self.connection_name);
        formatter.field("connection_state", &self.connection_state);
        formatter.field("region", &self.region);
        formatter.field("location", &self.location);
        formatter.field("bandwidth", &self.bandwidth);
        formatter.field("vlan", &self.vlan);
        formatter.field("partner_name", &self.partner_name);
        formatter.field("loa_issue_time", &self.loa_issue_time);
        formatter.field("lag_id", &self.lag_id);
        formatter.field("aws_device", &self.aws_device);
        formatter.field("jumbo_frame_capable", &self.jumbo_frame_capable);
        formatter.field("aws_device_v2", &self.aws_device_v2);
        formatter.field("aws_logical_device_id", &self.aws_logical_device_id);
        formatter.field("has_logical_redundancy", &self.has_logical_redundancy);
        formatter.field("tags", &self.tags);
        formatter.field("provider_name", &self.provider_name);
        formatter.field("mac_sec_capable", &self.mac_sec_capable);
        formatter.field("port_encryption_status", &self.port_encryption_status);
        formatter.field("encryption_mode", &self.encryption_mode);
        formatter.field("mac_sec_keys", &self.mac_sec_keys);
        formatter.finish()
    }
}
/// See [`CreateConnectionOutput`](crate::output::CreateConnectionOutput)
pub mod create_connection_output {
    /// A builder for [`CreateConnectionOutput`](crate::output::CreateConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) connection_name: std::option::Option<std::string::String>,
        pub(crate) connection_state: std::option::Option<crate::model::ConnectionState>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) bandwidth: std::option::Option<std::string::String>,
        pub(crate) vlan: std::option::Option<i32>,
        pub(crate) partner_name: std::option::Option<std::string::String>,
        pub(crate) loa_issue_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) lag_id: std::option::Option<std::string::String>,
        pub(crate) aws_device: std::option::Option<std::string::String>,
        pub(crate) jumbo_frame_capable: std::option::Option<bool>,
        pub(crate) aws_device_v2: std::option::Option<std::string::String>,
        pub(crate) aws_logical_device_id: std::option::Option<std::string::String>,
        pub(crate) has_logical_redundancy: std::option::Option<crate::model::HasLogicalRedundancy>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) provider_name: std::option::Option<std::string::String>,
        pub(crate) mac_sec_capable: std::option::Option<bool>,
        pub(crate) port_encryption_status: std::option::Option<std::string::String>,
        pub(crate) encryption_mode: std::option::Option<std::string::String>,
        pub(crate) mac_sec_keys: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
    }
    impl Builder {
        /// <p>The ID of the account that owns the connection.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the account that owns the connection.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The name of the connection.</p>
        pub fn connection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_name = Some(input.into());
            self
        }
        /// <p>The name of the connection.</p>
        pub fn set_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_name = input;
            self
        }
        /// <p>The state of the connection. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The connection has been approved and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is up and the connection is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The connection is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The connection has been deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the connection is not available.</p>
        /// </li>
        /// </ul>
        pub fn connection_state(mut self, input: crate::model::ConnectionState) -> Self {
            self.connection_state = Some(input);
            self
        }
        /// <p>The state of the connection. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The connection has been approved and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is up and the connection is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The connection is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The connection has been deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the connection is not available.</p>
        /// </li>
        /// </ul>
        pub fn set_connection_state(
            mut self,
            input: std::option::Option<crate::model::ConnectionState>,
        ) -> Self {
            self.connection_state = input;
            self
        }
        /// <p>The Region where the connection is located.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Region where the connection is located.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The location of the connection.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The location of the connection.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The bandwidth of the connection.</p>
        pub fn bandwidth(mut self, input: impl Into<std::string::String>) -> Self {
            self.bandwidth = Some(input.into());
            self
        }
        /// <p>The bandwidth of the connection.</p>
        pub fn set_bandwidth(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bandwidth = input;
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn vlan(mut self, input: i32) -> Self {
            self.vlan = Some(input);
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn set_vlan(mut self, input: std::option::Option<i32>) -> Self {
            self.vlan = input;
            self
        }
        /// <p>The name of the Direct Connect service provider associated with the connection.</p>
        pub fn partner_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.partner_name = Some(input.into());
            self
        }
        /// <p>The name of the Direct Connect service provider associated with the connection.</p>
        pub fn set_partner_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.partner_name = input;
            self
        }
        /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
        pub fn loa_issue_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.loa_issue_time = Some(input);
            self
        }
        /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
        pub fn set_loa_issue_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.loa_issue_time = input;
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.lag_id = Some(input.into());
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lag_id = input;
            self
        }
        /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
        pub fn aws_device(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
        pub fn set_aws_device(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_device = input;
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn jumbo_frame_capable(mut self, input: bool) -> Self {
            self.jumbo_frame_capable = Some(input);
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn set_jumbo_frame_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.jumbo_frame_capable = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn aws_device_v2(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device_v2 = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn set_aws_device_v2(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_device_v2 = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn aws_logical_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_logical_device_id = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn set_aws_logical_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_logical_device_id = input;
            self
        }
        /// <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
        pub fn has_logical_redundancy(mut self, input: crate::model::HasLogicalRedundancy) -> Self {
            self.has_logical_redundancy = Some(input);
            self
        }
        /// <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
        pub fn set_has_logical_redundancy(
            mut self,
            input: std::option::Option<crate::model::HasLogicalRedundancy>,
        ) -> Self {
            self.has_logical_redundancy = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the connection.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the connection.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name of the service provider associated with the connection.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The name of the service provider associated with the connection.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// <p>Indicates whether the connection supports MAC Security (MACsec).</p>
        pub fn mac_sec_capable(mut self, input: bool) -> Self {
            self.mac_sec_capable = Some(input);
            self
        }
        /// <p>Indicates whether the connection supports MAC Security (MACsec).</p>
        pub fn set_mac_sec_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.mac_sec_capable = input;
            self
        }
        /// <p>The MAC Security (MACsec) port link status of the connection.</p>
        /// <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
        pub fn port_encryption_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.port_encryption_status = Some(input.into());
            self
        }
        /// <p>The MAC Security (MACsec) port link status of the connection.</p>
        /// <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
        pub fn set_port_encryption_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.port_encryption_status = input;
            self
        }
        /// <p>The MAC Security (MACsec) connection encryption mode.</p>
        /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
        pub fn encryption_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_mode = Some(input.into());
            self
        }
        /// <p>The MAC Security (MACsec) connection encryption mode.</p>
        /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_mode = input;
            self
        }
        /// Appends an item to `mac_sec_keys`.
        ///
        /// To override the contents of this collection use [`set_mac_sec_keys`](Self::set_mac_sec_keys).
        ///
        /// <p>The MAC Security (MACsec) security keys associated with the connection.</p>
        pub fn mac_sec_keys(mut self, input: impl Into<crate::model::MacSecKey>) -> Self {
            let mut v = self.mac_sec_keys.unwrap_or_default();
            v.push(input.into());
            self.mac_sec_keys = Some(v);
            self
        }
        /// <p>The MAC Security (MACsec) security keys associated with the connection.</p>
        pub fn set_mac_sec_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
        ) -> Self {
            self.mac_sec_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConnectionOutput`](crate::output::CreateConnectionOutput)
        pub fn build(self) -> crate::output::CreateConnectionOutput {
            crate::output::CreateConnectionOutput {
                owner_account: self.owner_account,
                connection_id: self.connection_id,
                connection_name: self.connection_name,
                connection_state: self.connection_state,
                region: self.region,
                location: self.location,
                bandwidth: self.bandwidth,
                vlan: self.vlan.unwrap_or_default(),
                partner_name: self.partner_name,
                loa_issue_time: self.loa_issue_time,
                lag_id: self.lag_id,
                aws_device: self.aws_device,
                jumbo_frame_capable: self.jumbo_frame_capable,
                aws_device_v2: self.aws_device_v2,
                aws_logical_device_id: self.aws_logical_device_id,
                has_logical_redundancy: self.has_logical_redundancy,
                tags: self.tags,
                provider_name: self.provider_name,
                mac_sec_capable: self.mac_sec_capable,
                port_encryption_status: self.port_encryption_status,
                encryption_mode: self.encryption_mode,
                mac_sec_keys: self.mac_sec_keys,
            }
        }
    }
}
impl CreateConnectionOutput {
    /// Creates a new builder-style object to manufacture [`CreateConnectionOutput`](crate::output::CreateConnectionOutput)
    pub fn builder() -> crate::output::create_connection_output::Builder {
        crate::output::create_connection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBgpPeerOutput {
    /// <p>The virtual interface.</p>
    pub virtual_interface: std::option::Option<crate::model::VirtualInterface>,
}
impl std::fmt::Debug for CreateBgpPeerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBgpPeerOutput");
        formatter.field("virtual_interface", &self.virtual_interface);
        formatter.finish()
    }
}
/// See [`CreateBgpPeerOutput`](crate::output::CreateBgpPeerOutput)
pub mod create_bgp_peer_output {
    /// A builder for [`CreateBgpPeerOutput`](crate::output::CreateBgpPeerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_interface: std::option::Option<crate::model::VirtualInterface>,
    }
    impl Builder {
        /// <p>The virtual interface.</p>
        pub fn virtual_interface(mut self, input: crate::model::VirtualInterface) -> Self {
            self.virtual_interface = Some(input);
            self
        }
        /// <p>The virtual interface.</p>
        pub fn set_virtual_interface(
            mut self,
            input: std::option::Option<crate::model::VirtualInterface>,
        ) -> Self {
            self.virtual_interface = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBgpPeerOutput`](crate::output::CreateBgpPeerOutput)
        pub fn build(self) -> crate::output::CreateBgpPeerOutput {
            crate::output::CreateBgpPeerOutput {
                virtual_interface: self.virtual_interface,
            }
        }
    }
}
impl CreateBgpPeerOutput {
    /// Creates a new builder-style object to manufacture [`CreateBgpPeerOutput`](crate::output::CreateBgpPeerOutput)
    pub fn builder() -> crate::output::create_bgp_peer_output::Builder {
        crate::output::create_bgp_peer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfirmTransitVirtualInterfaceOutput {
    /// <p>The state of the virtual interface. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: A virtual interface that is BGP down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The state of the virtual interface is not available.</p>
    /// </li>
    /// </ul>
    pub virtual_interface_state: std::option::Option<crate::model::VirtualInterfaceState>,
}
impl std::fmt::Debug for ConfirmTransitVirtualInterfaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfirmTransitVirtualInterfaceOutput");
        formatter.field("virtual_interface_state", &self.virtual_interface_state);
        formatter.finish()
    }
}
/// See [`ConfirmTransitVirtualInterfaceOutput`](crate::output::ConfirmTransitVirtualInterfaceOutput)
pub mod confirm_transit_virtual_interface_output {
    /// A builder for [`ConfirmTransitVirtualInterfaceOutput`](crate::output::ConfirmTransitVirtualInterfaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_interface_state:
            std::option::Option<crate::model::VirtualInterfaceState>,
    }
    impl Builder {
        /// <p>The state of the virtual interface. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: A virtual interface that is BGP down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the virtual interface is not available.</p>
        /// </li>
        /// </ul>
        pub fn virtual_interface_state(
            mut self,
            input: crate::model::VirtualInterfaceState,
        ) -> Self {
            self.virtual_interface_state = Some(input);
            self
        }
        /// <p>The state of the virtual interface. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: A virtual interface that is BGP down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the virtual interface is not available.</p>
        /// </li>
        /// </ul>
        pub fn set_virtual_interface_state(
            mut self,
            input: std::option::Option<crate::model::VirtualInterfaceState>,
        ) -> Self {
            self.virtual_interface_state = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfirmTransitVirtualInterfaceOutput`](crate::output::ConfirmTransitVirtualInterfaceOutput)
        pub fn build(self) -> crate::output::ConfirmTransitVirtualInterfaceOutput {
            crate::output::ConfirmTransitVirtualInterfaceOutput {
                virtual_interface_state: self.virtual_interface_state,
            }
        }
    }
}
impl ConfirmTransitVirtualInterfaceOutput {
    /// Creates a new builder-style object to manufacture [`ConfirmTransitVirtualInterfaceOutput`](crate::output::ConfirmTransitVirtualInterfaceOutput)
    pub fn builder() -> crate::output::confirm_transit_virtual_interface_output::Builder {
        crate::output::confirm_transit_virtual_interface_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfirmPublicVirtualInterfaceOutput {
    /// <p>The state of the virtual interface. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: A virtual interface that is BGP down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The state of the virtual interface is not available.</p>
    /// </li>
    /// </ul>
    pub virtual_interface_state: std::option::Option<crate::model::VirtualInterfaceState>,
}
impl std::fmt::Debug for ConfirmPublicVirtualInterfaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfirmPublicVirtualInterfaceOutput");
        formatter.field("virtual_interface_state", &self.virtual_interface_state);
        formatter.finish()
    }
}
/// See [`ConfirmPublicVirtualInterfaceOutput`](crate::output::ConfirmPublicVirtualInterfaceOutput)
pub mod confirm_public_virtual_interface_output {
    /// A builder for [`ConfirmPublicVirtualInterfaceOutput`](crate::output::ConfirmPublicVirtualInterfaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_interface_state:
            std::option::Option<crate::model::VirtualInterfaceState>,
    }
    impl Builder {
        /// <p>The state of the virtual interface. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: A virtual interface that is BGP down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the virtual interface is not available.</p>
        /// </li>
        /// </ul>
        pub fn virtual_interface_state(
            mut self,
            input: crate::model::VirtualInterfaceState,
        ) -> Self {
            self.virtual_interface_state = Some(input);
            self
        }
        /// <p>The state of the virtual interface. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: A virtual interface that is BGP down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the virtual interface is not available.</p>
        /// </li>
        /// </ul>
        pub fn set_virtual_interface_state(
            mut self,
            input: std::option::Option<crate::model::VirtualInterfaceState>,
        ) -> Self {
            self.virtual_interface_state = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfirmPublicVirtualInterfaceOutput`](crate::output::ConfirmPublicVirtualInterfaceOutput)
        pub fn build(self) -> crate::output::ConfirmPublicVirtualInterfaceOutput {
            crate::output::ConfirmPublicVirtualInterfaceOutput {
                virtual_interface_state: self.virtual_interface_state,
            }
        }
    }
}
impl ConfirmPublicVirtualInterfaceOutput {
    /// Creates a new builder-style object to manufacture [`ConfirmPublicVirtualInterfaceOutput`](crate::output::ConfirmPublicVirtualInterfaceOutput)
    pub fn builder() -> crate::output::confirm_public_virtual_interface_output::Builder {
        crate::output::confirm_public_virtual_interface_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfirmPrivateVirtualInterfaceOutput {
    /// <p>The state of the virtual interface. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: A virtual interface that is BGP down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The state of the virtual interface is not available.</p>
    /// </li>
    /// </ul>
    pub virtual_interface_state: std::option::Option<crate::model::VirtualInterfaceState>,
}
impl std::fmt::Debug for ConfirmPrivateVirtualInterfaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfirmPrivateVirtualInterfaceOutput");
        formatter.field("virtual_interface_state", &self.virtual_interface_state);
        formatter.finish()
    }
}
/// See [`ConfirmPrivateVirtualInterfaceOutput`](crate::output::ConfirmPrivateVirtualInterfaceOutput)
pub mod confirm_private_virtual_interface_output {
    /// A builder for [`ConfirmPrivateVirtualInterfaceOutput`](crate::output::ConfirmPrivateVirtualInterfaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_interface_state:
            std::option::Option<crate::model::VirtualInterfaceState>,
    }
    impl Builder {
        /// <p>The state of the virtual interface. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: A virtual interface that is BGP down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the virtual interface is not available.</p>
        /// </li>
        /// </ul>
        pub fn virtual_interface_state(
            mut self,
            input: crate::model::VirtualInterfaceState,
        ) -> Self {
            self.virtual_interface_state = Some(input);
            self
        }
        /// <p>The state of the virtual interface. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: A virtual interface that is BGP down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the virtual interface is not available.</p>
        /// </li>
        /// </ul>
        pub fn set_virtual_interface_state(
            mut self,
            input: std::option::Option<crate::model::VirtualInterfaceState>,
        ) -> Self {
            self.virtual_interface_state = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfirmPrivateVirtualInterfaceOutput`](crate::output::ConfirmPrivateVirtualInterfaceOutput)
        pub fn build(self) -> crate::output::ConfirmPrivateVirtualInterfaceOutput {
            crate::output::ConfirmPrivateVirtualInterfaceOutput {
                virtual_interface_state: self.virtual_interface_state,
            }
        }
    }
}
impl ConfirmPrivateVirtualInterfaceOutput {
    /// Creates a new builder-style object to manufacture [`ConfirmPrivateVirtualInterfaceOutput`](crate::output::ConfirmPrivateVirtualInterfaceOutput)
    pub fn builder() -> crate::output::confirm_private_virtual_interface_output::Builder {
        crate::output::confirm_private_virtual_interface_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfirmConnectionOutput {
    /// <p>The state of the connection. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: The connection has been approved and is being initialized.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: The network link is up and the connection is ready for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: The network link is down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: The connection is being deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: The connection has been deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The state of the connection is not available.</p>
    /// </li>
    /// </ul>
    pub connection_state: std::option::Option<crate::model::ConnectionState>,
}
impl std::fmt::Debug for ConfirmConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfirmConnectionOutput");
        formatter.field("connection_state", &self.connection_state);
        formatter.finish()
    }
}
/// See [`ConfirmConnectionOutput`](crate::output::ConfirmConnectionOutput)
pub mod confirm_connection_output {
    /// A builder for [`ConfirmConnectionOutput`](crate::output::ConfirmConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_state: std::option::Option<crate::model::ConnectionState>,
    }
    impl Builder {
        /// <p>The state of the connection. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The connection has been approved and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is up and the connection is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The connection is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The connection has been deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the connection is not available.</p>
        /// </li>
        /// </ul>
        pub fn connection_state(mut self, input: crate::model::ConnectionState) -> Self {
            self.connection_state = Some(input);
            self
        }
        /// <p>The state of the connection. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The connection has been approved and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is up and the connection is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The connection is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The connection has been deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the connection is not available.</p>
        /// </li>
        /// </ul>
        pub fn set_connection_state(
            mut self,
            input: std::option::Option<crate::model::ConnectionState>,
        ) -> Self {
            self.connection_state = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfirmConnectionOutput`](crate::output::ConfirmConnectionOutput)
        pub fn build(self) -> crate::output::ConfirmConnectionOutput {
            crate::output::ConfirmConnectionOutput {
                connection_state: self.connection_state,
            }
        }
    }
}
impl ConfirmConnectionOutput {
    /// Creates a new builder-style object to manufacture [`ConfirmConnectionOutput`](crate::output::ConfirmConnectionOutput)
    pub fn builder() -> crate::output::confirm_connection_output::Builder {
        crate::output::confirm_connection_output::Builder::default()
    }
}

/// <p>Information about a virtual interface.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateVirtualInterfaceOutput {
    /// <p>The ID of the account that owns the virtual interface.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>The ID of the virtual interface.</p>
    pub virtual_interface_id: std::option::Option<std::string::String>,
    /// <p>The location of the connection.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The ID of the connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The type of virtual interface. The possible values are <code>private</code> and <code>public</code>.</p>
    pub virtual_interface_type: std::option::Option<std::string::String>,
    /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
    pub virtual_interface_name: std::option::Option<std::string::String>,
    /// <p>The ID of the VLAN.</p>
    pub vlan: i32,
    /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
    /// <p>The valid values are 1-2147483647.</p>
    pub asn: i32,
    /// <p>The autonomous system number (ASN) for the Amazon side of the connection.</p>
    pub amazon_side_asn: std::option::Option<i64>,
    /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
    pub auth_key: std::option::Option<std::string::String>,
    /// <p>The IP address assigned to the Amazon interface.</p>
    pub amazon_address: std::option::Option<std::string::String>,
    /// <p>The IP address assigned to the customer interface.</p>
    pub customer_address: std::option::Option<std::string::String>,
    /// <p>The address family for the BGP peer.</p>
    pub address_family: std::option::Option<crate::model::AddressFamily>,
    /// <p>The state of the virtual interface. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: A virtual interface that is BGP down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The state of the virtual interface is not available.</p>
    /// </li>
    /// </ul>
    pub virtual_interface_state: std::option::Option<crate::model::VirtualInterfaceState>,
    /// <p>The customer router configuration.</p>
    pub customer_router_config: std::option::Option<std::string::String>,
    /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
    pub mtu: std::option::Option<i32>,
    /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    pub jumbo_frame_capable: std::option::Option<bool>,
    /// <p>The ID of the virtual private gateway. Applies only to private virtual interfaces.</p>
    pub virtual_gateway_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Direct Connect gateway.</p>
    pub direct_connect_gateway_id: std::option::Option<std::string::String>,
    /// <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
    pub route_filter_prefixes: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
    /// <p>The BGP peers configured on this virtual interface.</p>
    pub bgp_peers: std::option::Option<std::vec::Vec<crate::model::BgpPeer>>,
    /// <p>The Region where the virtual interface is located.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
    pub aws_device_v2: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
    /// different than the device that terminates the physical connection.</p>
    pub aws_logical_device_id: std::option::Option<std::string::String>,
    /// <p>The tags associated with the virtual interface.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for AssociateVirtualInterfaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateVirtualInterfaceOutput");
        formatter.field("owner_account", &self.owner_account);
        formatter.field("virtual_interface_id", &self.virtual_interface_id);
        formatter.field("location", &self.location);
        formatter.field("connection_id", &self.connection_id);
        formatter.field("virtual_interface_type", &self.virtual_interface_type);
        formatter.field("virtual_interface_name", &self.virtual_interface_name);
        formatter.field("vlan", &self.vlan);
        formatter.field("asn", &self.asn);
        formatter.field("amazon_side_asn", &self.amazon_side_asn);
        formatter.field("auth_key", &self.auth_key);
        formatter.field("amazon_address", &self.amazon_address);
        formatter.field("customer_address", &self.customer_address);
        formatter.field("address_family", &self.address_family);
        formatter.field("virtual_interface_state", &self.virtual_interface_state);
        formatter.field("customer_router_config", &self.customer_router_config);
        formatter.field("mtu", &self.mtu);
        formatter.field("jumbo_frame_capable", &self.jumbo_frame_capable);
        formatter.field("virtual_gateway_id", &self.virtual_gateway_id);
        formatter.field("direct_connect_gateway_id", &self.direct_connect_gateway_id);
        formatter.field("route_filter_prefixes", &self.route_filter_prefixes);
        formatter.field("bgp_peers", &self.bgp_peers);
        formatter.field("region", &self.region);
        formatter.field("aws_device_v2", &self.aws_device_v2);
        formatter.field("aws_logical_device_id", &self.aws_logical_device_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`AssociateVirtualInterfaceOutput`](crate::output::AssociateVirtualInterfaceOutput)
pub mod associate_virtual_interface_output {
    /// A builder for [`AssociateVirtualInterfaceOutput`](crate::output::AssociateVirtualInterfaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) virtual_interface_id: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) virtual_interface_type: std::option::Option<std::string::String>,
        pub(crate) virtual_interface_name: std::option::Option<std::string::String>,
        pub(crate) vlan: std::option::Option<i32>,
        pub(crate) asn: std::option::Option<i32>,
        pub(crate) amazon_side_asn: std::option::Option<i64>,
        pub(crate) auth_key: std::option::Option<std::string::String>,
        pub(crate) amazon_address: std::option::Option<std::string::String>,
        pub(crate) customer_address: std::option::Option<std::string::String>,
        pub(crate) address_family: std::option::Option<crate::model::AddressFamily>,
        pub(crate) virtual_interface_state:
            std::option::Option<crate::model::VirtualInterfaceState>,
        pub(crate) customer_router_config: std::option::Option<std::string::String>,
        pub(crate) mtu: std::option::Option<i32>,
        pub(crate) jumbo_frame_capable: std::option::Option<bool>,
        pub(crate) virtual_gateway_id: std::option::Option<std::string::String>,
        pub(crate) direct_connect_gateway_id: std::option::Option<std::string::String>,
        pub(crate) route_filter_prefixes:
            std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        pub(crate) bgp_peers: std::option::Option<std::vec::Vec<crate::model::BgpPeer>>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) aws_device_v2: std::option::Option<std::string::String>,
        pub(crate) aws_logical_device_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the account that owns the virtual interface.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the account that owns the virtual interface.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_id = input;
            self
        }
        /// <p>The location of the connection.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The location of the connection.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The type of virtual interface. The possible values are <code>private</code> and <code>public</code>.</p>
        pub fn virtual_interface_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_type = Some(input.into());
            self
        }
        /// <p>The type of virtual interface. The possible values are <code>private</code> and <code>public</code>.</p>
        pub fn set_virtual_interface_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_type = input;
            self
        }
        /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
        pub fn virtual_interface_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
        pub fn set_virtual_interface_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_name = input;
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn vlan(mut self, input: i32) -> Self {
            self.vlan = Some(input);
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn set_vlan(mut self, input: std::option::Option<i32>) -> Self {
            self.vlan = input;
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        /// <p>The valid values are 1-2147483647.</p>
        pub fn asn(mut self, input: i32) -> Self {
            self.asn = Some(input);
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        /// <p>The valid values are 1-2147483647.</p>
        pub fn set_asn(mut self, input: std::option::Option<i32>) -> Self {
            self.asn = input;
            self
        }
        /// <p>The autonomous system number (ASN) for the Amazon side of the connection.</p>
        pub fn amazon_side_asn(mut self, input: i64) -> Self {
            self.amazon_side_asn = Some(input);
            self
        }
        /// <p>The autonomous system number (ASN) for the Amazon side of the connection.</p>
        pub fn set_amazon_side_asn(mut self, input: std::option::Option<i64>) -> Self {
            self.amazon_side_asn = input;
            self
        }
        /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
        pub fn auth_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.auth_key = Some(input.into());
            self
        }
        /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
        pub fn set_auth_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.auth_key = input;
            self
        }
        /// <p>The IP address assigned to the Amazon interface.</p>
        pub fn amazon_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.amazon_address = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the Amazon interface.</p>
        pub fn set_amazon_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amazon_address = input;
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn customer_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_address = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn set_customer_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_address = input;
            self
        }
        /// <p>The address family for the BGP peer.</p>
        pub fn address_family(mut self, input: crate::model::AddressFamily) -> Self {
            self.address_family = Some(input);
            self
        }
        /// <p>The address family for the BGP peer.</p>
        pub fn set_address_family(
            mut self,
            input: std::option::Option<crate::model::AddressFamily>,
        ) -> Self {
            self.address_family = input;
            self
        }
        /// <p>The state of the virtual interface. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: A virtual interface that is BGP down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the virtual interface is not available.</p>
        /// </li>
        /// </ul>
        pub fn virtual_interface_state(
            mut self,
            input: crate::model::VirtualInterfaceState,
        ) -> Self {
            self.virtual_interface_state = Some(input);
            self
        }
        /// <p>The state of the virtual interface. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: A virtual interface that is BGP down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the virtual interface is not available.</p>
        /// </li>
        /// </ul>
        pub fn set_virtual_interface_state(
            mut self,
            input: std::option::Option<crate::model::VirtualInterfaceState>,
        ) -> Self {
            self.virtual_interface_state = input;
            self
        }
        /// <p>The customer router configuration.</p>
        pub fn customer_router_config(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_router_config = Some(input.into());
            self
        }
        /// <p>The customer router configuration.</p>
        pub fn set_customer_router_config(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_router_config = input;
            self
        }
        /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
        pub fn mtu(mut self, input: i32) -> Self {
            self.mtu = Some(input);
            self
        }
        /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
        pub fn set_mtu(mut self, input: std::option::Option<i32>) -> Self {
            self.mtu = input;
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn jumbo_frame_capable(mut self, input: bool) -> Self {
            self.jumbo_frame_capable = Some(input);
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn set_jumbo_frame_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.jumbo_frame_capable = input;
            self
        }
        /// <p>The ID of the virtual private gateway. Applies only to private virtual interfaces.</p>
        pub fn virtual_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual private gateway. Applies only to private virtual interfaces.</p>
        pub fn set_virtual_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_gateway_id = input;
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.direct_connect_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_id = input;
            self
        }
        /// Appends an item to `route_filter_prefixes`.
        ///
        /// To override the contents of this collection use [`set_route_filter_prefixes`](Self::set_route_filter_prefixes).
        ///
        /// <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
        pub fn route_filter_prefixes(
            mut self,
            input: impl Into<crate::model::RouteFilterPrefix>,
        ) -> Self {
            let mut v = self.route_filter_prefixes.unwrap_or_default();
            v.push(input.into());
            self.route_filter_prefixes = Some(v);
            self
        }
        /// <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
        pub fn set_route_filter_prefixes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        ) -> Self {
            self.route_filter_prefixes = input;
            self
        }
        /// Appends an item to `bgp_peers`.
        ///
        /// To override the contents of this collection use [`set_bgp_peers`](Self::set_bgp_peers).
        ///
        /// <p>The BGP peers configured on this virtual interface.</p>
        pub fn bgp_peers(mut self, input: impl Into<crate::model::BgpPeer>) -> Self {
            let mut v = self.bgp_peers.unwrap_or_default();
            v.push(input.into());
            self.bgp_peers = Some(v);
            self
        }
        /// <p>The BGP peers configured on this virtual interface.</p>
        pub fn set_bgp_peers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BgpPeer>>,
        ) -> Self {
            self.bgp_peers = input;
            self
        }
        /// <p>The Region where the virtual interface is located.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Region where the virtual interface is located.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn aws_device_v2(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device_v2 = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn set_aws_device_v2(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_device_v2 = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn aws_logical_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_logical_device_id = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn set_aws_logical_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_logical_device_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the virtual interface.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the virtual interface.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateVirtualInterfaceOutput`](crate::output::AssociateVirtualInterfaceOutput)
        pub fn build(self) -> crate::output::AssociateVirtualInterfaceOutput {
            crate::output::AssociateVirtualInterfaceOutput {
                owner_account: self.owner_account,
                virtual_interface_id: self.virtual_interface_id,
                location: self.location,
                connection_id: self.connection_id,
                virtual_interface_type: self.virtual_interface_type,
                virtual_interface_name: self.virtual_interface_name,
                vlan: self.vlan.unwrap_or_default(),
                asn: self.asn.unwrap_or_default(),
                amazon_side_asn: self.amazon_side_asn,
                auth_key: self.auth_key,
                amazon_address: self.amazon_address,
                customer_address: self.customer_address,
                address_family: self.address_family,
                virtual_interface_state: self.virtual_interface_state,
                customer_router_config: self.customer_router_config,
                mtu: self.mtu,
                jumbo_frame_capable: self.jumbo_frame_capable,
                virtual_gateway_id: self.virtual_gateway_id,
                direct_connect_gateway_id: self.direct_connect_gateway_id,
                route_filter_prefixes: self.route_filter_prefixes,
                bgp_peers: self.bgp_peers,
                region: self.region,
                aws_device_v2: self.aws_device_v2,
                aws_logical_device_id: self.aws_logical_device_id,
                tags: self.tags,
            }
        }
    }
}
impl AssociateVirtualInterfaceOutput {
    /// Creates a new builder-style object to manufacture [`AssociateVirtualInterfaceOutput`](crate::output::AssociateVirtualInterfaceOutput)
    pub fn builder() -> crate::output::associate_virtual_interface_output::Builder {
        crate::output::associate_virtual_interface_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateMacSecKeyOutput {
    /// <p>The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The MAC Security (MACsec) security keys associated with the dedicated connection.</p>
    pub mac_sec_keys: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
}
impl std::fmt::Debug for AssociateMacSecKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateMacSecKeyOutput");
        formatter.field("connection_id", &self.connection_id);
        formatter.field("mac_sec_keys", &self.mac_sec_keys);
        formatter.finish()
    }
}
/// See [`AssociateMacSecKeyOutput`](crate::output::AssociateMacSecKeyOutput)
pub mod associate_mac_sec_key_output {
    /// A builder for [`AssociateMacSecKeyOutput`](crate::output::AssociateMacSecKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) mac_sec_keys: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
    }
    impl Builder {
        /// <p>The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// Appends an item to `mac_sec_keys`.
        ///
        /// To override the contents of this collection use [`set_mac_sec_keys`](Self::set_mac_sec_keys).
        ///
        /// <p>The MAC Security (MACsec) security keys associated with the dedicated connection.</p>
        pub fn mac_sec_keys(mut self, input: impl Into<crate::model::MacSecKey>) -> Self {
            let mut v = self.mac_sec_keys.unwrap_or_default();
            v.push(input.into());
            self.mac_sec_keys = Some(v);
            self
        }
        /// <p>The MAC Security (MACsec) security keys associated with the dedicated connection.</p>
        pub fn set_mac_sec_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
        ) -> Self {
            self.mac_sec_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateMacSecKeyOutput`](crate::output::AssociateMacSecKeyOutput)
        pub fn build(self) -> crate::output::AssociateMacSecKeyOutput {
            crate::output::AssociateMacSecKeyOutput {
                connection_id: self.connection_id,
                mac_sec_keys: self.mac_sec_keys,
            }
        }
    }
}
impl AssociateMacSecKeyOutput {
    /// Creates a new builder-style object to manufacture [`AssociateMacSecKeyOutput`](crate::output::AssociateMacSecKeyOutput)
    pub fn builder() -> crate::output::associate_mac_sec_key_output::Builder {
        crate::output::associate_mac_sec_key_output::Builder::default()
    }
}

/// <p>Information about an Direct Connect connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateHostedConnectionOutput {
    /// <p>The ID of the account that owns the connection.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>The ID of the connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The name of the connection.</p>
    pub connection_name: std::option::Option<std::string::String>,
    /// <p>The state of the connection. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: The connection has been approved and is being initialized.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: The network link is up and the connection is ready for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: The network link is down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: The connection is being deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: The connection has been deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The state of the connection is not available.</p>
    /// </li>
    /// </ul>
    pub connection_state: std::option::Option<crate::model::ConnectionState>,
    /// <p>The Region where the connection is located.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The location of the connection.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The bandwidth of the connection.</p>
    pub bandwidth: std::option::Option<std::string::String>,
    /// <p>The ID of the VLAN.</p>
    pub vlan: i32,
    /// <p>The name of the Direct Connect service provider associated with the connection.</p>
    pub partner_name: std::option::Option<std::string::String>,
    /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
    pub loa_issue_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The ID of the LAG.</p>
    pub lag_id: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
    pub aws_device: std::option::Option<std::string::String>,
    /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    pub jumbo_frame_capable: std::option::Option<bool>,
    /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
    pub aws_device_v2: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
    /// different than the device that terminates the physical connection.</p>
    pub aws_logical_device_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
    pub has_logical_redundancy: std::option::Option<crate::model::HasLogicalRedundancy>,
    /// <p>The tags associated with the connection.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The name of the service provider associated with the connection.</p>
    pub provider_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether the connection supports MAC Security (MACsec).</p>
    pub mac_sec_capable: std::option::Option<bool>,
    /// <p>The MAC Security (MACsec) port link status of the connection.</p>
    /// <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
    pub port_encryption_status: std::option::Option<std::string::String>,
    /// <p>The MAC Security (MACsec) connection encryption mode.</p>
    /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
    pub encryption_mode: std::option::Option<std::string::String>,
    /// <p>The MAC Security (MACsec) security keys associated with the connection.</p>
    pub mac_sec_keys: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
}
impl std::fmt::Debug for AssociateHostedConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateHostedConnectionOutput");
        formatter.field("owner_account", &self.owner_account);
        formatter.field("connection_id", &self.connection_id);
        formatter.field("connection_name", &self.connection_name);
        formatter.field("connection_state", &self.connection_state);
        formatter.field("region", &self.region);
        formatter.field("location", &self.location);
        formatter.field("bandwidth", &self.bandwidth);
        formatter.field("vlan", &self.vlan);
        formatter.field("partner_name", &self.partner_name);
        formatter.field("loa_issue_time", &self.loa_issue_time);
        formatter.field("lag_id", &self.lag_id);
        formatter.field("aws_device", &self.aws_device);
        formatter.field("jumbo_frame_capable", &self.jumbo_frame_capable);
        formatter.field("aws_device_v2", &self.aws_device_v2);
        formatter.field("aws_logical_device_id", &self.aws_logical_device_id);
        formatter.field("has_logical_redundancy", &self.has_logical_redundancy);
        formatter.field("tags", &self.tags);
        formatter.field("provider_name", &self.provider_name);
        formatter.field("mac_sec_capable", &self.mac_sec_capable);
        formatter.field("port_encryption_status", &self.port_encryption_status);
        formatter.field("encryption_mode", &self.encryption_mode);
        formatter.field("mac_sec_keys", &self.mac_sec_keys);
        formatter.finish()
    }
}
/// See [`AssociateHostedConnectionOutput`](crate::output::AssociateHostedConnectionOutput)
pub mod associate_hosted_connection_output {
    /// A builder for [`AssociateHostedConnectionOutput`](crate::output::AssociateHostedConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) connection_name: std::option::Option<std::string::String>,
        pub(crate) connection_state: std::option::Option<crate::model::ConnectionState>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) bandwidth: std::option::Option<std::string::String>,
        pub(crate) vlan: std::option::Option<i32>,
        pub(crate) partner_name: std::option::Option<std::string::String>,
        pub(crate) loa_issue_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) lag_id: std::option::Option<std::string::String>,
        pub(crate) aws_device: std::option::Option<std::string::String>,
        pub(crate) jumbo_frame_capable: std::option::Option<bool>,
        pub(crate) aws_device_v2: std::option::Option<std::string::String>,
        pub(crate) aws_logical_device_id: std::option::Option<std::string::String>,
        pub(crate) has_logical_redundancy: std::option::Option<crate::model::HasLogicalRedundancy>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) provider_name: std::option::Option<std::string::String>,
        pub(crate) mac_sec_capable: std::option::Option<bool>,
        pub(crate) port_encryption_status: std::option::Option<std::string::String>,
        pub(crate) encryption_mode: std::option::Option<std::string::String>,
        pub(crate) mac_sec_keys: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
    }
    impl Builder {
        /// <p>The ID of the account that owns the connection.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the account that owns the connection.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The name of the connection.</p>
        pub fn connection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_name = Some(input.into());
            self
        }
        /// <p>The name of the connection.</p>
        pub fn set_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_name = input;
            self
        }
        /// <p>The state of the connection. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The connection has been approved and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is up and the connection is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The connection is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The connection has been deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the connection is not available.</p>
        /// </li>
        /// </ul>
        pub fn connection_state(mut self, input: crate::model::ConnectionState) -> Self {
            self.connection_state = Some(input);
            self
        }
        /// <p>The state of the connection. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The connection has been approved and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is up and the connection is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The connection is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The connection has been deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the connection is not available.</p>
        /// </li>
        /// </ul>
        pub fn set_connection_state(
            mut self,
            input: std::option::Option<crate::model::ConnectionState>,
        ) -> Self {
            self.connection_state = input;
            self
        }
        /// <p>The Region where the connection is located.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Region where the connection is located.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The location of the connection.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The location of the connection.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The bandwidth of the connection.</p>
        pub fn bandwidth(mut self, input: impl Into<std::string::String>) -> Self {
            self.bandwidth = Some(input.into());
            self
        }
        /// <p>The bandwidth of the connection.</p>
        pub fn set_bandwidth(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bandwidth = input;
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn vlan(mut self, input: i32) -> Self {
            self.vlan = Some(input);
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn set_vlan(mut self, input: std::option::Option<i32>) -> Self {
            self.vlan = input;
            self
        }
        /// <p>The name of the Direct Connect service provider associated with the connection.</p>
        pub fn partner_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.partner_name = Some(input.into());
            self
        }
        /// <p>The name of the Direct Connect service provider associated with the connection.</p>
        pub fn set_partner_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.partner_name = input;
            self
        }
        /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
        pub fn loa_issue_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.loa_issue_time = Some(input);
            self
        }
        /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
        pub fn set_loa_issue_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.loa_issue_time = input;
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.lag_id = Some(input.into());
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lag_id = input;
            self
        }
        /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
        pub fn aws_device(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
        pub fn set_aws_device(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_device = input;
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn jumbo_frame_capable(mut self, input: bool) -> Self {
            self.jumbo_frame_capable = Some(input);
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn set_jumbo_frame_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.jumbo_frame_capable = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn aws_device_v2(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device_v2 = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn set_aws_device_v2(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_device_v2 = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn aws_logical_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_logical_device_id = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn set_aws_logical_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_logical_device_id = input;
            self
        }
        /// <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
        pub fn has_logical_redundancy(mut self, input: crate::model::HasLogicalRedundancy) -> Self {
            self.has_logical_redundancy = Some(input);
            self
        }
        /// <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
        pub fn set_has_logical_redundancy(
            mut self,
            input: std::option::Option<crate::model::HasLogicalRedundancy>,
        ) -> Self {
            self.has_logical_redundancy = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the connection.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the connection.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name of the service provider associated with the connection.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The name of the service provider associated with the connection.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// <p>Indicates whether the connection supports MAC Security (MACsec).</p>
        pub fn mac_sec_capable(mut self, input: bool) -> Self {
            self.mac_sec_capable = Some(input);
            self
        }
        /// <p>Indicates whether the connection supports MAC Security (MACsec).</p>
        pub fn set_mac_sec_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.mac_sec_capable = input;
            self
        }
        /// <p>The MAC Security (MACsec) port link status of the connection.</p>
        /// <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
        pub fn port_encryption_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.port_encryption_status = Some(input.into());
            self
        }
        /// <p>The MAC Security (MACsec) port link status of the connection.</p>
        /// <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
        pub fn set_port_encryption_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.port_encryption_status = input;
            self
        }
        /// <p>The MAC Security (MACsec) connection encryption mode.</p>
        /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
        pub fn encryption_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_mode = Some(input.into());
            self
        }
        /// <p>The MAC Security (MACsec) connection encryption mode.</p>
        /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_mode = input;
            self
        }
        /// Appends an item to `mac_sec_keys`.
        ///
        /// To override the contents of this collection use [`set_mac_sec_keys`](Self::set_mac_sec_keys).
        ///
        /// <p>The MAC Security (MACsec) security keys associated with the connection.</p>
        pub fn mac_sec_keys(mut self, input: impl Into<crate::model::MacSecKey>) -> Self {
            let mut v = self.mac_sec_keys.unwrap_or_default();
            v.push(input.into());
            self.mac_sec_keys = Some(v);
            self
        }
        /// <p>The MAC Security (MACsec) security keys associated with the connection.</p>
        pub fn set_mac_sec_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
        ) -> Self {
            self.mac_sec_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateHostedConnectionOutput`](crate::output::AssociateHostedConnectionOutput)
        pub fn build(self) -> crate::output::AssociateHostedConnectionOutput {
            crate::output::AssociateHostedConnectionOutput {
                owner_account: self.owner_account,
                connection_id: self.connection_id,
                connection_name: self.connection_name,
                connection_state: self.connection_state,
                region: self.region,
                location: self.location,
                bandwidth: self.bandwidth,
                vlan: self.vlan.unwrap_or_default(),
                partner_name: self.partner_name,
                loa_issue_time: self.loa_issue_time,
                lag_id: self.lag_id,
                aws_device: self.aws_device,
                jumbo_frame_capable: self.jumbo_frame_capable,
                aws_device_v2: self.aws_device_v2,
                aws_logical_device_id: self.aws_logical_device_id,
                has_logical_redundancy: self.has_logical_redundancy,
                tags: self.tags,
                provider_name: self.provider_name,
                mac_sec_capable: self.mac_sec_capable,
                port_encryption_status: self.port_encryption_status,
                encryption_mode: self.encryption_mode,
                mac_sec_keys: self.mac_sec_keys,
            }
        }
    }
}
impl AssociateHostedConnectionOutput {
    /// Creates a new builder-style object to manufacture [`AssociateHostedConnectionOutput`](crate::output::AssociateHostedConnectionOutput)
    pub fn builder() -> crate::output::associate_hosted_connection_output::Builder {
        crate::output::associate_hosted_connection_output::Builder::default()
    }
}

/// <p>Information about an Direct Connect connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateConnectionWithLagOutput {
    /// <p>The ID of the account that owns the connection.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>The ID of the connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The name of the connection.</p>
    pub connection_name: std::option::Option<std::string::String>,
    /// <p>The state of the connection. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: The connection has been approved and is being initialized.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: The network link is up and the connection is ready for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: The network link is down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: The connection is being deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: The connection has been deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The state of the connection is not available.</p>
    /// </li>
    /// </ul>
    pub connection_state: std::option::Option<crate::model::ConnectionState>,
    /// <p>The Region where the connection is located.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The location of the connection.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The bandwidth of the connection.</p>
    pub bandwidth: std::option::Option<std::string::String>,
    /// <p>The ID of the VLAN.</p>
    pub vlan: i32,
    /// <p>The name of the Direct Connect service provider associated with the connection.</p>
    pub partner_name: std::option::Option<std::string::String>,
    /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
    pub loa_issue_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The ID of the LAG.</p>
    pub lag_id: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
    pub aws_device: std::option::Option<std::string::String>,
    /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    pub jumbo_frame_capable: std::option::Option<bool>,
    /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
    pub aws_device_v2: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
    /// different than the device that terminates the physical connection.</p>
    pub aws_logical_device_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
    pub has_logical_redundancy: std::option::Option<crate::model::HasLogicalRedundancy>,
    /// <p>The tags associated with the connection.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The name of the service provider associated with the connection.</p>
    pub provider_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether the connection supports MAC Security (MACsec).</p>
    pub mac_sec_capable: std::option::Option<bool>,
    /// <p>The MAC Security (MACsec) port link status of the connection.</p>
    /// <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
    pub port_encryption_status: std::option::Option<std::string::String>,
    /// <p>The MAC Security (MACsec) connection encryption mode.</p>
    /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
    pub encryption_mode: std::option::Option<std::string::String>,
    /// <p>The MAC Security (MACsec) security keys associated with the connection.</p>
    pub mac_sec_keys: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
}
impl std::fmt::Debug for AssociateConnectionWithLagOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateConnectionWithLagOutput");
        formatter.field("owner_account", &self.owner_account);
        formatter.field("connection_id", &self.connection_id);
        formatter.field("connection_name", &self.connection_name);
        formatter.field("connection_state", &self.connection_state);
        formatter.field("region", &self.region);
        formatter.field("location", &self.location);
        formatter.field("bandwidth", &self.bandwidth);
        formatter.field("vlan", &self.vlan);
        formatter.field("partner_name", &self.partner_name);
        formatter.field("loa_issue_time", &self.loa_issue_time);
        formatter.field("lag_id", &self.lag_id);
        formatter.field("aws_device", &self.aws_device);
        formatter.field("jumbo_frame_capable", &self.jumbo_frame_capable);
        formatter.field("aws_device_v2", &self.aws_device_v2);
        formatter.field("aws_logical_device_id", &self.aws_logical_device_id);
        formatter.field("has_logical_redundancy", &self.has_logical_redundancy);
        formatter.field("tags", &self.tags);
        formatter.field("provider_name", &self.provider_name);
        formatter.field("mac_sec_capable", &self.mac_sec_capable);
        formatter.field("port_encryption_status", &self.port_encryption_status);
        formatter.field("encryption_mode", &self.encryption_mode);
        formatter.field("mac_sec_keys", &self.mac_sec_keys);
        formatter.finish()
    }
}
/// See [`AssociateConnectionWithLagOutput`](crate::output::AssociateConnectionWithLagOutput)
pub mod associate_connection_with_lag_output {
    /// A builder for [`AssociateConnectionWithLagOutput`](crate::output::AssociateConnectionWithLagOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) connection_name: std::option::Option<std::string::String>,
        pub(crate) connection_state: std::option::Option<crate::model::ConnectionState>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) bandwidth: std::option::Option<std::string::String>,
        pub(crate) vlan: std::option::Option<i32>,
        pub(crate) partner_name: std::option::Option<std::string::String>,
        pub(crate) loa_issue_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) lag_id: std::option::Option<std::string::String>,
        pub(crate) aws_device: std::option::Option<std::string::String>,
        pub(crate) jumbo_frame_capable: std::option::Option<bool>,
        pub(crate) aws_device_v2: std::option::Option<std::string::String>,
        pub(crate) aws_logical_device_id: std::option::Option<std::string::String>,
        pub(crate) has_logical_redundancy: std::option::Option<crate::model::HasLogicalRedundancy>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) provider_name: std::option::Option<std::string::String>,
        pub(crate) mac_sec_capable: std::option::Option<bool>,
        pub(crate) port_encryption_status: std::option::Option<std::string::String>,
        pub(crate) encryption_mode: std::option::Option<std::string::String>,
        pub(crate) mac_sec_keys: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
    }
    impl Builder {
        /// <p>The ID of the account that owns the connection.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the account that owns the connection.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The name of the connection.</p>
        pub fn connection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_name = Some(input.into());
            self
        }
        /// <p>The name of the connection.</p>
        pub fn set_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_name = input;
            self
        }
        /// <p>The state of the connection. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The connection has been approved and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is up and the connection is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The connection is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The connection has been deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the connection is not available.</p>
        /// </li>
        /// </ul>
        pub fn connection_state(mut self, input: crate::model::ConnectionState) -> Self {
            self.connection_state = Some(input);
            self
        }
        /// <p>The state of the connection. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The connection has been approved and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is up and the connection is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The connection is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The connection has been deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the connection is not available.</p>
        /// </li>
        /// </ul>
        pub fn set_connection_state(
            mut self,
            input: std::option::Option<crate::model::ConnectionState>,
        ) -> Self {
            self.connection_state = input;
            self
        }
        /// <p>The Region where the connection is located.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Region where the connection is located.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The location of the connection.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The location of the connection.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The bandwidth of the connection.</p>
        pub fn bandwidth(mut self, input: impl Into<std::string::String>) -> Self {
            self.bandwidth = Some(input.into());
            self
        }
        /// <p>The bandwidth of the connection.</p>
        pub fn set_bandwidth(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bandwidth = input;
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn vlan(mut self, input: i32) -> Self {
            self.vlan = Some(input);
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn set_vlan(mut self, input: std::option::Option<i32>) -> Self {
            self.vlan = input;
            self
        }
        /// <p>The name of the Direct Connect service provider associated with the connection.</p>
        pub fn partner_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.partner_name = Some(input.into());
            self
        }
        /// <p>The name of the Direct Connect service provider associated with the connection.</p>
        pub fn set_partner_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.partner_name = input;
            self
        }
        /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
        pub fn loa_issue_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.loa_issue_time = Some(input);
            self
        }
        /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
        pub fn set_loa_issue_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.loa_issue_time = input;
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.lag_id = Some(input.into());
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lag_id = input;
            self
        }
        /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
        pub fn aws_device(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
        pub fn set_aws_device(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_device = input;
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn jumbo_frame_capable(mut self, input: bool) -> Self {
            self.jumbo_frame_capable = Some(input);
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn set_jumbo_frame_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.jumbo_frame_capable = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn aws_device_v2(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device_v2 = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn set_aws_device_v2(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_device_v2 = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn aws_logical_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_logical_device_id = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn set_aws_logical_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_logical_device_id = input;
            self
        }
        /// <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
        pub fn has_logical_redundancy(mut self, input: crate::model::HasLogicalRedundancy) -> Self {
            self.has_logical_redundancy = Some(input);
            self
        }
        /// <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
        pub fn set_has_logical_redundancy(
            mut self,
            input: std::option::Option<crate::model::HasLogicalRedundancy>,
        ) -> Self {
            self.has_logical_redundancy = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the connection.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the connection.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name of the service provider associated with the connection.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The name of the service provider associated with the connection.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// <p>Indicates whether the connection supports MAC Security (MACsec).</p>
        pub fn mac_sec_capable(mut self, input: bool) -> Self {
            self.mac_sec_capable = Some(input);
            self
        }
        /// <p>Indicates whether the connection supports MAC Security (MACsec).</p>
        pub fn set_mac_sec_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.mac_sec_capable = input;
            self
        }
        /// <p>The MAC Security (MACsec) port link status of the connection.</p>
        /// <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
        pub fn port_encryption_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.port_encryption_status = Some(input.into());
            self
        }
        /// <p>The MAC Security (MACsec) port link status of the connection.</p>
        /// <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
        pub fn set_port_encryption_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.port_encryption_status = input;
            self
        }
        /// <p>The MAC Security (MACsec) connection encryption mode.</p>
        /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
        pub fn encryption_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_mode = Some(input.into());
            self
        }
        /// <p>The MAC Security (MACsec) connection encryption mode.</p>
        /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_mode = input;
            self
        }
        /// Appends an item to `mac_sec_keys`.
        ///
        /// To override the contents of this collection use [`set_mac_sec_keys`](Self::set_mac_sec_keys).
        ///
        /// <p>The MAC Security (MACsec) security keys associated with the connection.</p>
        pub fn mac_sec_keys(mut self, input: impl Into<crate::model::MacSecKey>) -> Self {
            let mut v = self.mac_sec_keys.unwrap_or_default();
            v.push(input.into());
            self.mac_sec_keys = Some(v);
            self
        }
        /// <p>The MAC Security (MACsec) security keys associated with the connection.</p>
        pub fn set_mac_sec_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
        ) -> Self {
            self.mac_sec_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateConnectionWithLagOutput`](crate::output::AssociateConnectionWithLagOutput)
        pub fn build(self) -> crate::output::AssociateConnectionWithLagOutput {
            crate::output::AssociateConnectionWithLagOutput {
                owner_account: self.owner_account,
                connection_id: self.connection_id,
                connection_name: self.connection_name,
                connection_state: self.connection_state,
                region: self.region,
                location: self.location,
                bandwidth: self.bandwidth,
                vlan: self.vlan.unwrap_or_default(),
                partner_name: self.partner_name,
                loa_issue_time: self.loa_issue_time,
                lag_id: self.lag_id,
                aws_device: self.aws_device,
                jumbo_frame_capable: self.jumbo_frame_capable,
                aws_device_v2: self.aws_device_v2,
                aws_logical_device_id: self.aws_logical_device_id,
                has_logical_redundancy: self.has_logical_redundancy,
                tags: self.tags,
                provider_name: self.provider_name,
                mac_sec_capable: self.mac_sec_capable,
                port_encryption_status: self.port_encryption_status,
                encryption_mode: self.encryption_mode,
                mac_sec_keys: self.mac_sec_keys,
            }
        }
    }
}
impl AssociateConnectionWithLagOutput {
    /// Creates a new builder-style object to manufacture [`AssociateConnectionWithLagOutput`](crate::output::AssociateConnectionWithLagOutput)
    pub fn builder() -> crate::output::associate_connection_with_lag_output::Builder {
        crate::output::associate_connection_with_lag_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AllocateTransitVirtualInterfaceOutput {
    /// <p>Information about a virtual interface.</p>
    pub virtual_interface: std::option::Option<crate::model::VirtualInterface>,
}
impl std::fmt::Debug for AllocateTransitVirtualInterfaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AllocateTransitVirtualInterfaceOutput");
        formatter.field("virtual_interface", &self.virtual_interface);
        formatter.finish()
    }
}
/// See [`AllocateTransitVirtualInterfaceOutput`](crate::output::AllocateTransitVirtualInterfaceOutput)
pub mod allocate_transit_virtual_interface_output {
    /// A builder for [`AllocateTransitVirtualInterfaceOutput`](crate::output::AllocateTransitVirtualInterfaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_interface: std::option::Option<crate::model::VirtualInterface>,
    }
    impl Builder {
        /// <p>Information about a virtual interface.</p>
        pub fn virtual_interface(mut self, input: crate::model::VirtualInterface) -> Self {
            self.virtual_interface = Some(input);
            self
        }
        /// <p>Information about a virtual interface.</p>
        pub fn set_virtual_interface(
            mut self,
            input: std::option::Option<crate::model::VirtualInterface>,
        ) -> Self {
            self.virtual_interface = input;
            self
        }
        /// Consumes the builder and constructs a [`AllocateTransitVirtualInterfaceOutput`](crate::output::AllocateTransitVirtualInterfaceOutput)
        pub fn build(self) -> crate::output::AllocateTransitVirtualInterfaceOutput {
            crate::output::AllocateTransitVirtualInterfaceOutput {
                virtual_interface: self.virtual_interface,
            }
        }
    }
}
impl AllocateTransitVirtualInterfaceOutput {
    /// Creates a new builder-style object to manufacture [`AllocateTransitVirtualInterfaceOutput`](crate::output::AllocateTransitVirtualInterfaceOutput)
    pub fn builder() -> crate::output::allocate_transit_virtual_interface_output::Builder {
        crate::output::allocate_transit_virtual_interface_output::Builder::default()
    }
}

/// <p>Information about a virtual interface.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AllocatePublicVirtualInterfaceOutput {
    /// <p>The ID of the account that owns the virtual interface.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>The ID of the virtual interface.</p>
    pub virtual_interface_id: std::option::Option<std::string::String>,
    /// <p>The location of the connection.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The ID of the connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The type of virtual interface. The possible values are <code>private</code> and <code>public</code>.</p>
    pub virtual_interface_type: std::option::Option<std::string::String>,
    /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
    pub virtual_interface_name: std::option::Option<std::string::String>,
    /// <p>The ID of the VLAN.</p>
    pub vlan: i32,
    /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
    /// <p>The valid values are 1-2147483647.</p>
    pub asn: i32,
    /// <p>The autonomous system number (ASN) for the Amazon side of the connection.</p>
    pub amazon_side_asn: std::option::Option<i64>,
    /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
    pub auth_key: std::option::Option<std::string::String>,
    /// <p>The IP address assigned to the Amazon interface.</p>
    pub amazon_address: std::option::Option<std::string::String>,
    /// <p>The IP address assigned to the customer interface.</p>
    pub customer_address: std::option::Option<std::string::String>,
    /// <p>The address family for the BGP peer.</p>
    pub address_family: std::option::Option<crate::model::AddressFamily>,
    /// <p>The state of the virtual interface. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: A virtual interface that is BGP down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The state of the virtual interface is not available.</p>
    /// </li>
    /// </ul>
    pub virtual_interface_state: std::option::Option<crate::model::VirtualInterfaceState>,
    /// <p>The customer router configuration.</p>
    pub customer_router_config: std::option::Option<std::string::String>,
    /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
    pub mtu: std::option::Option<i32>,
    /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    pub jumbo_frame_capable: std::option::Option<bool>,
    /// <p>The ID of the virtual private gateway. Applies only to private virtual interfaces.</p>
    pub virtual_gateway_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Direct Connect gateway.</p>
    pub direct_connect_gateway_id: std::option::Option<std::string::String>,
    /// <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
    pub route_filter_prefixes: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
    /// <p>The BGP peers configured on this virtual interface.</p>
    pub bgp_peers: std::option::Option<std::vec::Vec<crate::model::BgpPeer>>,
    /// <p>The Region where the virtual interface is located.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
    pub aws_device_v2: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
    /// different than the device that terminates the physical connection.</p>
    pub aws_logical_device_id: std::option::Option<std::string::String>,
    /// <p>The tags associated with the virtual interface.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for AllocatePublicVirtualInterfaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AllocatePublicVirtualInterfaceOutput");
        formatter.field("owner_account", &self.owner_account);
        formatter.field("virtual_interface_id", &self.virtual_interface_id);
        formatter.field("location", &self.location);
        formatter.field("connection_id", &self.connection_id);
        formatter.field("virtual_interface_type", &self.virtual_interface_type);
        formatter.field("virtual_interface_name", &self.virtual_interface_name);
        formatter.field("vlan", &self.vlan);
        formatter.field("asn", &self.asn);
        formatter.field("amazon_side_asn", &self.amazon_side_asn);
        formatter.field("auth_key", &self.auth_key);
        formatter.field("amazon_address", &self.amazon_address);
        formatter.field("customer_address", &self.customer_address);
        formatter.field("address_family", &self.address_family);
        formatter.field("virtual_interface_state", &self.virtual_interface_state);
        formatter.field("customer_router_config", &self.customer_router_config);
        formatter.field("mtu", &self.mtu);
        formatter.field("jumbo_frame_capable", &self.jumbo_frame_capable);
        formatter.field("virtual_gateway_id", &self.virtual_gateway_id);
        formatter.field("direct_connect_gateway_id", &self.direct_connect_gateway_id);
        formatter.field("route_filter_prefixes", &self.route_filter_prefixes);
        formatter.field("bgp_peers", &self.bgp_peers);
        formatter.field("region", &self.region);
        formatter.field("aws_device_v2", &self.aws_device_v2);
        formatter.field("aws_logical_device_id", &self.aws_logical_device_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`AllocatePublicVirtualInterfaceOutput`](crate::output::AllocatePublicVirtualInterfaceOutput)
pub mod allocate_public_virtual_interface_output {
    /// A builder for [`AllocatePublicVirtualInterfaceOutput`](crate::output::AllocatePublicVirtualInterfaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) virtual_interface_id: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) virtual_interface_type: std::option::Option<std::string::String>,
        pub(crate) virtual_interface_name: std::option::Option<std::string::String>,
        pub(crate) vlan: std::option::Option<i32>,
        pub(crate) asn: std::option::Option<i32>,
        pub(crate) amazon_side_asn: std::option::Option<i64>,
        pub(crate) auth_key: std::option::Option<std::string::String>,
        pub(crate) amazon_address: std::option::Option<std::string::String>,
        pub(crate) customer_address: std::option::Option<std::string::String>,
        pub(crate) address_family: std::option::Option<crate::model::AddressFamily>,
        pub(crate) virtual_interface_state:
            std::option::Option<crate::model::VirtualInterfaceState>,
        pub(crate) customer_router_config: std::option::Option<std::string::String>,
        pub(crate) mtu: std::option::Option<i32>,
        pub(crate) jumbo_frame_capable: std::option::Option<bool>,
        pub(crate) virtual_gateway_id: std::option::Option<std::string::String>,
        pub(crate) direct_connect_gateway_id: std::option::Option<std::string::String>,
        pub(crate) route_filter_prefixes:
            std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        pub(crate) bgp_peers: std::option::Option<std::vec::Vec<crate::model::BgpPeer>>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) aws_device_v2: std::option::Option<std::string::String>,
        pub(crate) aws_logical_device_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the account that owns the virtual interface.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the account that owns the virtual interface.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_id = input;
            self
        }
        /// <p>The location of the connection.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The location of the connection.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The type of virtual interface. The possible values are <code>private</code> and <code>public</code>.</p>
        pub fn virtual_interface_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_type = Some(input.into());
            self
        }
        /// <p>The type of virtual interface. The possible values are <code>private</code> and <code>public</code>.</p>
        pub fn set_virtual_interface_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_type = input;
            self
        }
        /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
        pub fn virtual_interface_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
        pub fn set_virtual_interface_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_name = input;
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn vlan(mut self, input: i32) -> Self {
            self.vlan = Some(input);
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn set_vlan(mut self, input: std::option::Option<i32>) -> Self {
            self.vlan = input;
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        /// <p>The valid values are 1-2147483647.</p>
        pub fn asn(mut self, input: i32) -> Self {
            self.asn = Some(input);
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        /// <p>The valid values are 1-2147483647.</p>
        pub fn set_asn(mut self, input: std::option::Option<i32>) -> Self {
            self.asn = input;
            self
        }
        /// <p>The autonomous system number (ASN) for the Amazon side of the connection.</p>
        pub fn amazon_side_asn(mut self, input: i64) -> Self {
            self.amazon_side_asn = Some(input);
            self
        }
        /// <p>The autonomous system number (ASN) for the Amazon side of the connection.</p>
        pub fn set_amazon_side_asn(mut self, input: std::option::Option<i64>) -> Self {
            self.amazon_side_asn = input;
            self
        }
        /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
        pub fn auth_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.auth_key = Some(input.into());
            self
        }
        /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
        pub fn set_auth_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.auth_key = input;
            self
        }
        /// <p>The IP address assigned to the Amazon interface.</p>
        pub fn amazon_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.amazon_address = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the Amazon interface.</p>
        pub fn set_amazon_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amazon_address = input;
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn customer_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_address = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn set_customer_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_address = input;
            self
        }
        /// <p>The address family for the BGP peer.</p>
        pub fn address_family(mut self, input: crate::model::AddressFamily) -> Self {
            self.address_family = Some(input);
            self
        }
        /// <p>The address family for the BGP peer.</p>
        pub fn set_address_family(
            mut self,
            input: std::option::Option<crate::model::AddressFamily>,
        ) -> Self {
            self.address_family = input;
            self
        }
        /// <p>The state of the virtual interface. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: A virtual interface that is BGP down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the virtual interface is not available.</p>
        /// </li>
        /// </ul>
        pub fn virtual_interface_state(
            mut self,
            input: crate::model::VirtualInterfaceState,
        ) -> Self {
            self.virtual_interface_state = Some(input);
            self
        }
        /// <p>The state of the virtual interface. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: A virtual interface that is BGP down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the virtual interface is not available.</p>
        /// </li>
        /// </ul>
        pub fn set_virtual_interface_state(
            mut self,
            input: std::option::Option<crate::model::VirtualInterfaceState>,
        ) -> Self {
            self.virtual_interface_state = input;
            self
        }
        /// <p>The customer router configuration.</p>
        pub fn customer_router_config(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_router_config = Some(input.into());
            self
        }
        /// <p>The customer router configuration.</p>
        pub fn set_customer_router_config(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_router_config = input;
            self
        }
        /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
        pub fn mtu(mut self, input: i32) -> Self {
            self.mtu = Some(input);
            self
        }
        /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
        pub fn set_mtu(mut self, input: std::option::Option<i32>) -> Self {
            self.mtu = input;
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn jumbo_frame_capable(mut self, input: bool) -> Self {
            self.jumbo_frame_capable = Some(input);
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn set_jumbo_frame_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.jumbo_frame_capable = input;
            self
        }
        /// <p>The ID of the virtual private gateway. Applies only to private virtual interfaces.</p>
        pub fn virtual_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual private gateway. Applies only to private virtual interfaces.</p>
        pub fn set_virtual_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_gateway_id = input;
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.direct_connect_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_id = input;
            self
        }
        /// Appends an item to `route_filter_prefixes`.
        ///
        /// To override the contents of this collection use [`set_route_filter_prefixes`](Self::set_route_filter_prefixes).
        ///
        /// <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
        pub fn route_filter_prefixes(
            mut self,
            input: impl Into<crate::model::RouteFilterPrefix>,
        ) -> Self {
            let mut v = self.route_filter_prefixes.unwrap_or_default();
            v.push(input.into());
            self.route_filter_prefixes = Some(v);
            self
        }
        /// <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
        pub fn set_route_filter_prefixes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        ) -> Self {
            self.route_filter_prefixes = input;
            self
        }
        /// Appends an item to `bgp_peers`.
        ///
        /// To override the contents of this collection use [`set_bgp_peers`](Self::set_bgp_peers).
        ///
        /// <p>The BGP peers configured on this virtual interface.</p>
        pub fn bgp_peers(mut self, input: impl Into<crate::model::BgpPeer>) -> Self {
            let mut v = self.bgp_peers.unwrap_or_default();
            v.push(input.into());
            self.bgp_peers = Some(v);
            self
        }
        /// <p>The BGP peers configured on this virtual interface.</p>
        pub fn set_bgp_peers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BgpPeer>>,
        ) -> Self {
            self.bgp_peers = input;
            self
        }
        /// <p>The Region where the virtual interface is located.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Region where the virtual interface is located.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn aws_device_v2(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device_v2 = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn set_aws_device_v2(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_device_v2 = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn aws_logical_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_logical_device_id = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn set_aws_logical_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_logical_device_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the virtual interface.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the virtual interface.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`AllocatePublicVirtualInterfaceOutput`](crate::output::AllocatePublicVirtualInterfaceOutput)
        pub fn build(self) -> crate::output::AllocatePublicVirtualInterfaceOutput {
            crate::output::AllocatePublicVirtualInterfaceOutput {
                owner_account: self.owner_account,
                virtual_interface_id: self.virtual_interface_id,
                location: self.location,
                connection_id: self.connection_id,
                virtual_interface_type: self.virtual_interface_type,
                virtual_interface_name: self.virtual_interface_name,
                vlan: self.vlan.unwrap_or_default(),
                asn: self.asn.unwrap_or_default(),
                amazon_side_asn: self.amazon_side_asn,
                auth_key: self.auth_key,
                amazon_address: self.amazon_address,
                customer_address: self.customer_address,
                address_family: self.address_family,
                virtual_interface_state: self.virtual_interface_state,
                customer_router_config: self.customer_router_config,
                mtu: self.mtu,
                jumbo_frame_capable: self.jumbo_frame_capable,
                virtual_gateway_id: self.virtual_gateway_id,
                direct_connect_gateway_id: self.direct_connect_gateway_id,
                route_filter_prefixes: self.route_filter_prefixes,
                bgp_peers: self.bgp_peers,
                region: self.region,
                aws_device_v2: self.aws_device_v2,
                aws_logical_device_id: self.aws_logical_device_id,
                tags: self.tags,
            }
        }
    }
}
impl AllocatePublicVirtualInterfaceOutput {
    /// Creates a new builder-style object to manufacture [`AllocatePublicVirtualInterfaceOutput`](crate::output::AllocatePublicVirtualInterfaceOutput)
    pub fn builder() -> crate::output::allocate_public_virtual_interface_output::Builder {
        crate::output::allocate_public_virtual_interface_output::Builder::default()
    }
}

/// <p>Information about a virtual interface.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AllocatePrivateVirtualInterfaceOutput {
    /// <p>The ID of the account that owns the virtual interface.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>The ID of the virtual interface.</p>
    pub virtual_interface_id: std::option::Option<std::string::String>,
    /// <p>The location of the connection.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The ID of the connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The type of virtual interface. The possible values are <code>private</code> and <code>public</code>.</p>
    pub virtual_interface_type: std::option::Option<std::string::String>,
    /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
    pub virtual_interface_name: std::option::Option<std::string::String>,
    /// <p>The ID of the VLAN.</p>
    pub vlan: i32,
    /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
    /// <p>The valid values are 1-2147483647.</p>
    pub asn: i32,
    /// <p>The autonomous system number (ASN) for the Amazon side of the connection.</p>
    pub amazon_side_asn: std::option::Option<i64>,
    /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
    pub auth_key: std::option::Option<std::string::String>,
    /// <p>The IP address assigned to the Amazon interface.</p>
    pub amazon_address: std::option::Option<std::string::String>,
    /// <p>The IP address assigned to the customer interface.</p>
    pub customer_address: std::option::Option<std::string::String>,
    /// <p>The address family for the BGP peer.</p>
    pub address_family: std::option::Option<crate::model::AddressFamily>,
    /// <p>The state of the virtual interface. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: A virtual interface that is BGP down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The state of the virtual interface is not available.</p>
    /// </li>
    /// </ul>
    pub virtual_interface_state: std::option::Option<crate::model::VirtualInterfaceState>,
    /// <p>The customer router configuration.</p>
    pub customer_router_config: std::option::Option<std::string::String>,
    /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
    pub mtu: std::option::Option<i32>,
    /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    pub jumbo_frame_capable: std::option::Option<bool>,
    /// <p>The ID of the virtual private gateway. Applies only to private virtual interfaces.</p>
    pub virtual_gateway_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Direct Connect gateway.</p>
    pub direct_connect_gateway_id: std::option::Option<std::string::String>,
    /// <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
    pub route_filter_prefixes: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
    /// <p>The BGP peers configured on this virtual interface.</p>
    pub bgp_peers: std::option::Option<std::vec::Vec<crate::model::BgpPeer>>,
    /// <p>The Region where the virtual interface is located.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
    pub aws_device_v2: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
    /// different than the device that terminates the physical connection.</p>
    pub aws_logical_device_id: std::option::Option<std::string::String>,
    /// <p>The tags associated with the virtual interface.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for AllocatePrivateVirtualInterfaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AllocatePrivateVirtualInterfaceOutput");
        formatter.field("owner_account", &self.owner_account);
        formatter.field("virtual_interface_id", &self.virtual_interface_id);
        formatter.field("location", &self.location);
        formatter.field("connection_id", &self.connection_id);
        formatter.field("virtual_interface_type", &self.virtual_interface_type);
        formatter.field("virtual_interface_name", &self.virtual_interface_name);
        formatter.field("vlan", &self.vlan);
        formatter.field("asn", &self.asn);
        formatter.field("amazon_side_asn", &self.amazon_side_asn);
        formatter.field("auth_key", &self.auth_key);
        formatter.field("amazon_address", &self.amazon_address);
        formatter.field("customer_address", &self.customer_address);
        formatter.field("address_family", &self.address_family);
        formatter.field("virtual_interface_state", &self.virtual_interface_state);
        formatter.field("customer_router_config", &self.customer_router_config);
        formatter.field("mtu", &self.mtu);
        formatter.field("jumbo_frame_capable", &self.jumbo_frame_capable);
        formatter.field("virtual_gateway_id", &self.virtual_gateway_id);
        formatter.field("direct_connect_gateway_id", &self.direct_connect_gateway_id);
        formatter.field("route_filter_prefixes", &self.route_filter_prefixes);
        formatter.field("bgp_peers", &self.bgp_peers);
        formatter.field("region", &self.region);
        formatter.field("aws_device_v2", &self.aws_device_v2);
        formatter.field("aws_logical_device_id", &self.aws_logical_device_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`AllocatePrivateVirtualInterfaceOutput`](crate::output::AllocatePrivateVirtualInterfaceOutput)
pub mod allocate_private_virtual_interface_output {
    /// A builder for [`AllocatePrivateVirtualInterfaceOutput`](crate::output::AllocatePrivateVirtualInterfaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) virtual_interface_id: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) virtual_interface_type: std::option::Option<std::string::String>,
        pub(crate) virtual_interface_name: std::option::Option<std::string::String>,
        pub(crate) vlan: std::option::Option<i32>,
        pub(crate) asn: std::option::Option<i32>,
        pub(crate) amazon_side_asn: std::option::Option<i64>,
        pub(crate) auth_key: std::option::Option<std::string::String>,
        pub(crate) amazon_address: std::option::Option<std::string::String>,
        pub(crate) customer_address: std::option::Option<std::string::String>,
        pub(crate) address_family: std::option::Option<crate::model::AddressFamily>,
        pub(crate) virtual_interface_state:
            std::option::Option<crate::model::VirtualInterfaceState>,
        pub(crate) customer_router_config: std::option::Option<std::string::String>,
        pub(crate) mtu: std::option::Option<i32>,
        pub(crate) jumbo_frame_capable: std::option::Option<bool>,
        pub(crate) virtual_gateway_id: std::option::Option<std::string::String>,
        pub(crate) direct_connect_gateway_id: std::option::Option<std::string::String>,
        pub(crate) route_filter_prefixes:
            std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        pub(crate) bgp_peers: std::option::Option<std::vec::Vec<crate::model::BgpPeer>>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) aws_device_v2: std::option::Option<std::string::String>,
        pub(crate) aws_logical_device_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the account that owns the virtual interface.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the account that owns the virtual interface.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_id = input;
            self
        }
        /// <p>The location of the connection.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The location of the connection.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The type of virtual interface. The possible values are <code>private</code> and <code>public</code>.</p>
        pub fn virtual_interface_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_type = Some(input.into());
            self
        }
        /// <p>The type of virtual interface. The possible values are <code>private</code> and <code>public</code>.</p>
        pub fn set_virtual_interface_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_type = input;
            self
        }
        /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
        pub fn virtual_interface_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).</p>
        pub fn set_virtual_interface_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_name = input;
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn vlan(mut self, input: i32) -> Self {
            self.vlan = Some(input);
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn set_vlan(mut self, input: std::option::Option<i32>) -> Self {
            self.vlan = input;
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        /// <p>The valid values are 1-2147483647.</p>
        pub fn asn(mut self, input: i32) -> Self {
            self.asn = Some(input);
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        /// <p>The valid values are 1-2147483647.</p>
        pub fn set_asn(mut self, input: std::option::Option<i32>) -> Self {
            self.asn = input;
            self
        }
        /// <p>The autonomous system number (ASN) for the Amazon side of the connection.</p>
        pub fn amazon_side_asn(mut self, input: i64) -> Self {
            self.amazon_side_asn = Some(input);
            self
        }
        /// <p>The autonomous system number (ASN) for the Amazon side of the connection.</p>
        pub fn set_amazon_side_asn(mut self, input: std::option::Option<i64>) -> Self {
            self.amazon_side_asn = input;
            self
        }
        /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
        pub fn auth_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.auth_key = Some(input.into());
            self
        }
        /// <p>The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.</p>
        pub fn set_auth_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.auth_key = input;
            self
        }
        /// <p>The IP address assigned to the Amazon interface.</p>
        pub fn amazon_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.amazon_address = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the Amazon interface.</p>
        pub fn set_amazon_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amazon_address = input;
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn customer_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_address = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn set_customer_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_address = input;
            self
        }
        /// <p>The address family for the BGP peer.</p>
        pub fn address_family(mut self, input: crate::model::AddressFamily) -> Self {
            self.address_family = Some(input);
            self
        }
        /// <p>The address family for the BGP peer.</p>
        pub fn set_address_family(
            mut self,
            input: std::option::Option<crate::model::AddressFamily>,
        ) -> Self {
            self.address_family = input;
            self
        }
        /// <p>The state of the virtual interface. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: A virtual interface that is BGP down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the virtual interface is not available.</p>
        /// </li>
        /// </ul>
        pub fn virtual_interface_state(
            mut self,
            input: crate::model::VirtualInterfaceState,
        ) -> Self {
            self.virtual_interface_state = Some(input);
            self
        }
        /// <p>The state of the virtual interface. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: A virtual interface that is able to forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: A virtual interface that is BGP down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: A virtual interface is in this state immediately after calling <a>DeleteVirtualInterface</a> until it can no longer forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: A virtual interface that cannot forward traffic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface enters the <code>Rejected</code> state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the virtual interface is not available.</p>
        /// </li>
        /// </ul>
        pub fn set_virtual_interface_state(
            mut self,
            input: std::option::Option<crate::model::VirtualInterfaceState>,
        ) -> Self {
            self.virtual_interface_state = input;
            self
        }
        /// <p>The customer router configuration.</p>
        pub fn customer_router_config(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_router_config = Some(input.into());
            self
        }
        /// <p>The customer router configuration.</p>
        pub fn set_customer_router_config(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_router_config = input;
            self
        }
        /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
        pub fn mtu(mut self, input: i32) -> Self {
            self.mtu = Some(input);
            self
        }
        /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
        pub fn set_mtu(mut self, input: std::option::Option<i32>) -> Self {
            self.mtu = input;
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn jumbo_frame_capable(mut self, input: bool) -> Self {
            self.jumbo_frame_capable = Some(input);
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn set_jumbo_frame_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.jumbo_frame_capable = input;
            self
        }
        /// <p>The ID of the virtual private gateway. Applies only to private virtual interfaces.</p>
        pub fn virtual_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual private gateway. Applies only to private virtual interfaces.</p>
        pub fn set_virtual_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_gateway_id = input;
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.direct_connect_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_id = input;
            self
        }
        /// Appends an item to `route_filter_prefixes`.
        ///
        /// To override the contents of this collection use [`set_route_filter_prefixes`](Self::set_route_filter_prefixes).
        ///
        /// <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
        pub fn route_filter_prefixes(
            mut self,
            input: impl Into<crate::model::RouteFilterPrefix>,
        ) -> Self {
            let mut v = self.route_filter_prefixes.unwrap_or_default();
            v.push(input.into());
            self.route_filter_prefixes = Some(v);
            self
        }
        /// <p>The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.</p>
        pub fn set_route_filter_prefixes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        ) -> Self {
            self.route_filter_prefixes = input;
            self
        }
        /// Appends an item to `bgp_peers`.
        ///
        /// To override the contents of this collection use [`set_bgp_peers`](Self::set_bgp_peers).
        ///
        /// <p>The BGP peers configured on this virtual interface.</p>
        pub fn bgp_peers(mut self, input: impl Into<crate::model::BgpPeer>) -> Self {
            let mut v = self.bgp_peers.unwrap_or_default();
            v.push(input.into());
            self.bgp_peers = Some(v);
            self
        }
        /// <p>The BGP peers configured on this virtual interface.</p>
        pub fn set_bgp_peers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BgpPeer>>,
        ) -> Self {
            self.bgp_peers = input;
            self
        }
        /// <p>The Region where the virtual interface is located.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Region where the virtual interface is located.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn aws_device_v2(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device_v2 = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn set_aws_device_v2(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_device_v2 = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn aws_logical_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_logical_device_id = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn set_aws_logical_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_logical_device_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the virtual interface.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the virtual interface.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`AllocatePrivateVirtualInterfaceOutput`](crate::output::AllocatePrivateVirtualInterfaceOutput)
        pub fn build(self) -> crate::output::AllocatePrivateVirtualInterfaceOutput {
            crate::output::AllocatePrivateVirtualInterfaceOutput {
                owner_account: self.owner_account,
                virtual_interface_id: self.virtual_interface_id,
                location: self.location,
                connection_id: self.connection_id,
                virtual_interface_type: self.virtual_interface_type,
                virtual_interface_name: self.virtual_interface_name,
                vlan: self.vlan.unwrap_or_default(),
                asn: self.asn.unwrap_or_default(),
                amazon_side_asn: self.amazon_side_asn,
                auth_key: self.auth_key,
                amazon_address: self.amazon_address,
                customer_address: self.customer_address,
                address_family: self.address_family,
                virtual_interface_state: self.virtual_interface_state,
                customer_router_config: self.customer_router_config,
                mtu: self.mtu,
                jumbo_frame_capable: self.jumbo_frame_capable,
                virtual_gateway_id: self.virtual_gateway_id,
                direct_connect_gateway_id: self.direct_connect_gateway_id,
                route_filter_prefixes: self.route_filter_prefixes,
                bgp_peers: self.bgp_peers,
                region: self.region,
                aws_device_v2: self.aws_device_v2,
                aws_logical_device_id: self.aws_logical_device_id,
                tags: self.tags,
            }
        }
    }
}
impl AllocatePrivateVirtualInterfaceOutput {
    /// Creates a new builder-style object to manufacture [`AllocatePrivateVirtualInterfaceOutput`](crate::output::AllocatePrivateVirtualInterfaceOutput)
    pub fn builder() -> crate::output::allocate_private_virtual_interface_output::Builder {
        crate::output::allocate_private_virtual_interface_output::Builder::default()
    }
}

/// <p>Information about an Direct Connect connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AllocateHostedConnectionOutput {
    /// <p>The ID of the account that owns the connection.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>The ID of the connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The name of the connection.</p>
    pub connection_name: std::option::Option<std::string::String>,
    /// <p>The state of the connection. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: The connection has been approved and is being initialized.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: The network link is up and the connection is ready for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: The network link is down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: The connection is being deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: The connection has been deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The state of the connection is not available.</p>
    /// </li>
    /// </ul>
    pub connection_state: std::option::Option<crate::model::ConnectionState>,
    /// <p>The Region where the connection is located.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The location of the connection.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The bandwidth of the connection.</p>
    pub bandwidth: std::option::Option<std::string::String>,
    /// <p>The ID of the VLAN.</p>
    pub vlan: i32,
    /// <p>The name of the Direct Connect service provider associated with the connection.</p>
    pub partner_name: std::option::Option<std::string::String>,
    /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
    pub loa_issue_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The ID of the LAG.</p>
    pub lag_id: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
    pub aws_device: std::option::Option<std::string::String>,
    /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    pub jumbo_frame_capable: std::option::Option<bool>,
    /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
    pub aws_device_v2: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
    /// different than the device that terminates the physical connection.</p>
    pub aws_logical_device_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
    pub has_logical_redundancy: std::option::Option<crate::model::HasLogicalRedundancy>,
    /// <p>The tags associated with the connection.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The name of the service provider associated with the connection.</p>
    pub provider_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether the connection supports MAC Security (MACsec).</p>
    pub mac_sec_capable: std::option::Option<bool>,
    /// <p>The MAC Security (MACsec) port link status of the connection.</p>
    /// <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
    pub port_encryption_status: std::option::Option<std::string::String>,
    /// <p>The MAC Security (MACsec) connection encryption mode.</p>
    /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
    pub encryption_mode: std::option::Option<std::string::String>,
    /// <p>The MAC Security (MACsec) security keys associated with the connection.</p>
    pub mac_sec_keys: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
}
impl std::fmt::Debug for AllocateHostedConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AllocateHostedConnectionOutput");
        formatter.field("owner_account", &self.owner_account);
        formatter.field("connection_id", &self.connection_id);
        formatter.field("connection_name", &self.connection_name);
        formatter.field("connection_state", &self.connection_state);
        formatter.field("region", &self.region);
        formatter.field("location", &self.location);
        formatter.field("bandwidth", &self.bandwidth);
        formatter.field("vlan", &self.vlan);
        formatter.field("partner_name", &self.partner_name);
        formatter.field("loa_issue_time", &self.loa_issue_time);
        formatter.field("lag_id", &self.lag_id);
        formatter.field("aws_device", &self.aws_device);
        formatter.field("jumbo_frame_capable", &self.jumbo_frame_capable);
        formatter.field("aws_device_v2", &self.aws_device_v2);
        formatter.field("aws_logical_device_id", &self.aws_logical_device_id);
        formatter.field("has_logical_redundancy", &self.has_logical_redundancy);
        formatter.field("tags", &self.tags);
        formatter.field("provider_name", &self.provider_name);
        formatter.field("mac_sec_capable", &self.mac_sec_capable);
        formatter.field("port_encryption_status", &self.port_encryption_status);
        formatter.field("encryption_mode", &self.encryption_mode);
        formatter.field("mac_sec_keys", &self.mac_sec_keys);
        formatter.finish()
    }
}
/// See [`AllocateHostedConnectionOutput`](crate::output::AllocateHostedConnectionOutput)
pub mod allocate_hosted_connection_output {
    /// A builder for [`AllocateHostedConnectionOutput`](crate::output::AllocateHostedConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) connection_name: std::option::Option<std::string::String>,
        pub(crate) connection_state: std::option::Option<crate::model::ConnectionState>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) bandwidth: std::option::Option<std::string::String>,
        pub(crate) vlan: std::option::Option<i32>,
        pub(crate) partner_name: std::option::Option<std::string::String>,
        pub(crate) loa_issue_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) lag_id: std::option::Option<std::string::String>,
        pub(crate) aws_device: std::option::Option<std::string::String>,
        pub(crate) jumbo_frame_capable: std::option::Option<bool>,
        pub(crate) aws_device_v2: std::option::Option<std::string::String>,
        pub(crate) aws_logical_device_id: std::option::Option<std::string::String>,
        pub(crate) has_logical_redundancy: std::option::Option<crate::model::HasLogicalRedundancy>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) provider_name: std::option::Option<std::string::String>,
        pub(crate) mac_sec_capable: std::option::Option<bool>,
        pub(crate) port_encryption_status: std::option::Option<std::string::String>,
        pub(crate) encryption_mode: std::option::Option<std::string::String>,
        pub(crate) mac_sec_keys: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
    }
    impl Builder {
        /// <p>The ID of the account that owns the connection.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the account that owns the connection.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The name of the connection.</p>
        pub fn connection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_name = Some(input.into());
            self
        }
        /// <p>The name of the connection.</p>
        pub fn set_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_name = input;
            self
        }
        /// <p>The state of the connection. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The connection has been approved and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is up and the connection is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The connection is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The connection has been deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the connection is not available.</p>
        /// </li>
        /// </ul>
        pub fn connection_state(mut self, input: crate::model::ConnectionState) -> Self {
            self.connection_state = Some(input);
            self
        }
        /// <p>The state of the connection. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The connection has been approved and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is up and the connection is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The connection is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The connection has been deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the connection is not available.</p>
        /// </li>
        /// </ul>
        pub fn set_connection_state(
            mut self,
            input: std::option::Option<crate::model::ConnectionState>,
        ) -> Self {
            self.connection_state = input;
            self
        }
        /// <p>The Region where the connection is located.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Region where the connection is located.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The location of the connection.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The location of the connection.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The bandwidth of the connection.</p>
        pub fn bandwidth(mut self, input: impl Into<std::string::String>) -> Self {
            self.bandwidth = Some(input.into());
            self
        }
        /// <p>The bandwidth of the connection.</p>
        pub fn set_bandwidth(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bandwidth = input;
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn vlan(mut self, input: i32) -> Self {
            self.vlan = Some(input);
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn set_vlan(mut self, input: std::option::Option<i32>) -> Self {
            self.vlan = input;
            self
        }
        /// <p>The name of the Direct Connect service provider associated with the connection.</p>
        pub fn partner_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.partner_name = Some(input.into());
            self
        }
        /// <p>The name of the Direct Connect service provider associated with the connection.</p>
        pub fn set_partner_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.partner_name = input;
            self
        }
        /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
        pub fn loa_issue_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.loa_issue_time = Some(input);
            self
        }
        /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
        pub fn set_loa_issue_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.loa_issue_time = input;
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.lag_id = Some(input.into());
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lag_id = input;
            self
        }
        /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
        pub fn aws_device(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
        pub fn set_aws_device(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_device = input;
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn jumbo_frame_capable(mut self, input: bool) -> Self {
            self.jumbo_frame_capable = Some(input);
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn set_jumbo_frame_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.jumbo_frame_capable = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn aws_device_v2(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device_v2 = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn set_aws_device_v2(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_device_v2 = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn aws_logical_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_logical_device_id = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn set_aws_logical_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_logical_device_id = input;
            self
        }
        /// <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
        pub fn has_logical_redundancy(mut self, input: crate::model::HasLogicalRedundancy) -> Self {
            self.has_logical_redundancy = Some(input);
            self
        }
        /// <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
        pub fn set_has_logical_redundancy(
            mut self,
            input: std::option::Option<crate::model::HasLogicalRedundancy>,
        ) -> Self {
            self.has_logical_redundancy = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the connection.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the connection.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name of the service provider associated with the connection.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The name of the service provider associated with the connection.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// <p>Indicates whether the connection supports MAC Security (MACsec).</p>
        pub fn mac_sec_capable(mut self, input: bool) -> Self {
            self.mac_sec_capable = Some(input);
            self
        }
        /// <p>Indicates whether the connection supports MAC Security (MACsec).</p>
        pub fn set_mac_sec_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.mac_sec_capable = input;
            self
        }
        /// <p>The MAC Security (MACsec) port link status of the connection.</p>
        /// <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
        pub fn port_encryption_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.port_encryption_status = Some(input.into());
            self
        }
        /// <p>The MAC Security (MACsec) port link status of the connection.</p>
        /// <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
        pub fn set_port_encryption_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.port_encryption_status = input;
            self
        }
        /// <p>The MAC Security (MACsec) connection encryption mode.</p>
        /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
        pub fn encryption_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_mode = Some(input.into());
            self
        }
        /// <p>The MAC Security (MACsec) connection encryption mode.</p>
        /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_mode = input;
            self
        }
        /// Appends an item to `mac_sec_keys`.
        ///
        /// To override the contents of this collection use [`set_mac_sec_keys`](Self::set_mac_sec_keys).
        ///
        /// <p>The MAC Security (MACsec) security keys associated with the connection.</p>
        pub fn mac_sec_keys(mut self, input: impl Into<crate::model::MacSecKey>) -> Self {
            let mut v = self.mac_sec_keys.unwrap_or_default();
            v.push(input.into());
            self.mac_sec_keys = Some(v);
            self
        }
        /// <p>The MAC Security (MACsec) security keys associated with the connection.</p>
        pub fn set_mac_sec_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
        ) -> Self {
            self.mac_sec_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`AllocateHostedConnectionOutput`](crate::output::AllocateHostedConnectionOutput)
        pub fn build(self) -> crate::output::AllocateHostedConnectionOutput {
            crate::output::AllocateHostedConnectionOutput {
                owner_account: self.owner_account,
                connection_id: self.connection_id,
                connection_name: self.connection_name,
                connection_state: self.connection_state,
                region: self.region,
                location: self.location,
                bandwidth: self.bandwidth,
                vlan: self.vlan.unwrap_or_default(),
                partner_name: self.partner_name,
                loa_issue_time: self.loa_issue_time,
                lag_id: self.lag_id,
                aws_device: self.aws_device,
                jumbo_frame_capable: self.jumbo_frame_capable,
                aws_device_v2: self.aws_device_v2,
                aws_logical_device_id: self.aws_logical_device_id,
                has_logical_redundancy: self.has_logical_redundancy,
                tags: self.tags,
                provider_name: self.provider_name,
                mac_sec_capable: self.mac_sec_capable,
                port_encryption_status: self.port_encryption_status,
                encryption_mode: self.encryption_mode,
                mac_sec_keys: self.mac_sec_keys,
            }
        }
    }
}
impl AllocateHostedConnectionOutput {
    /// Creates a new builder-style object to manufacture [`AllocateHostedConnectionOutput`](crate::output::AllocateHostedConnectionOutput)
    pub fn builder() -> crate::output::allocate_hosted_connection_output::Builder {
        crate::output::allocate_hosted_connection_output::Builder::default()
    }
}

/// <p>Information about an Direct Connect connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AllocateConnectionOnInterconnectOutput {
    /// <p>The ID of the account that owns the connection.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>The ID of the connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The name of the connection.</p>
    pub connection_name: std::option::Option<std::string::String>,
    /// <p>The state of the connection. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: The connection has been approved and is being initialized.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>available</code>: The network link is up and the connection is ready for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>down</code>: The network link is down.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleting</code>: The connection is being deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deleted</code>: The connection has been deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unknown</code>: The state of the connection is not available.</p>
    /// </li>
    /// </ul>
    pub connection_state: std::option::Option<crate::model::ConnectionState>,
    /// <p>The Region where the connection is located.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The location of the connection.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The bandwidth of the connection.</p>
    pub bandwidth: std::option::Option<std::string::String>,
    /// <p>The ID of the VLAN.</p>
    pub vlan: i32,
    /// <p>The name of the Direct Connect service provider associated with the connection.</p>
    pub partner_name: std::option::Option<std::string::String>,
    /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
    pub loa_issue_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The ID of the LAG.</p>
    pub lag_id: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
    pub aws_device: std::option::Option<std::string::String>,
    /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
    pub jumbo_frame_capable: std::option::Option<bool>,
    /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
    pub aws_device_v2: std::option::Option<std::string::String>,
    /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
    /// different than the device that terminates the physical connection.</p>
    pub aws_logical_device_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
    pub has_logical_redundancy: std::option::Option<crate::model::HasLogicalRedundancy>,
    /// <p>The tags associated with the connection.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The name of the service provider associated with the connection.</p>
    pub provider_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether the connection supports MAC Security (MACsec).</p>
    pub mac_sec_capable: std::option::Option<bool>,
    /// <p>The MAC Security (MACsec) port link status of the connection.</p>
    /// <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
    pub port_encryption_status: std::option::Option<std::string::String>,
    /// <p>The MAC Security (MACsec) connection encryption mode.</p>
    /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
    pub encryption_mode: std::option::Option<std::string::String>,
    /// <p>The MAC Security (MACsec) security keys associated with the connection.</p>
    pub mac_sec_keys: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
}
impl std::fmt::Debug for AllocateConnectionOnInterconnectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AllocateConnectionOnInterconnectOutput");
        formatter.field("owner_account", &self.owner_account);
        formatter.field("connection_id", &self.connection_id);
        formatter.field("connection_name", &self.connection_name);
        formatter.field("connection_state", &self.connection_state);
        formatter.field("region", &self.region);
        formatter.field("location", &self.location);
        formatter.field("bandwidth", &self.bandwidth);
        formatter.field("vlan", &self.vlan);
        formatter.field("partner_name", &self.partner_name);
        formatter.field("loa_issue_time", &self.loa_issue_time);
        formatter.field("lag_id", &self.lag_id);
        formatter.field("aws_device", &self.aws_device);
        formatter.field("jumbo_frame_capable", &self.jumbo_frame_capable);
        formatter.field("aws_device_v2", &self.aws_device_v2);
        formatter.field("aws_logical_device_id", &self.aws_logical_device_id);
        formatter.field("has_logical_redundancy", &self.has_logical_redundancy);
        formatter.field("tags", &self.tags);
        formatter.field("provider_name", &self.provider_name);
        formatter.field("mac_sec_capable", &self.mac_sec_capable);
        formatter.field("port_encryption_status", &self.port_encryption_status);
        formatter.field("encryption_mode", &self.encryption_mode);
        formatter.field("mac_sec_keys", &self.mac_sec_keys);
        formatter.finish()
    }
}
/// See [`AllocateConnectionOnInterconnectOutput`](crate::output::AllocateConnectionOnInterconnectOutput)
pub mod allocate_connection_on_interconnect_output {
    /// A builder for [`AllocateConnectionOnInterconnectOutput`](crate::output::AllocateConnectionOnInterconnectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) connection_name: std::option::Option<std::string::String>,
        pub(crate) connection_state: std::option::Option<crate::model::ConnectionState>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) bandwidth: std::option::Option<std::string::String>,
        pub(crate) vlan: std::option::Option<i32>,
        pub(crate) partner_name: std::option::Option<std::string::String>,
        pub(crate) loa_issue_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) lag_id: std::option::Option<std::string::String>,
        pub(crate) aws_device: std::option::Option<std::string::String>,
        pub(crate) jumbo_frame_capable: std::option::Option<bool>,
        pub(crate) aws_device_v2: std::option::Option<std::string::String>,
        pub(crate) aws_logical_device_id: std::option::Option<std::string::String>,
        pub(crate) has_logical_redundancy: std::option::Option<crate::model::HasLogicalRedundancy>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) provider_name: std::option::Option<std::string::String>,
        pub(crate) mac_sec_capable: std::option::Option<bool>,
        pub(crate) port_encryption_status: std::option::Option<std::string::String>,
        pub(crate) encryption_mode: std::option::Option<std::string::String>,
        pub(crate) mac_sec_keys: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
    }
    impl Builder {
        /// <p>The ID of the account that owns the connection.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the account that owns the connection.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The name of the connection.</p>
        pub fn connection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_name = Some(input.into());
            self
        }
        /// <p>The name of the connection.</p>
        pub fn set_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_name = input;
            self
        }
        /// <p>The state of the connection. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The connection has been approved and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is up and the connection is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The connection is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The connection has been deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the connection is not available.</p>
        /// </li>
        /// </ul>
        pub fn connection_state(mut self, input: crate::model::ConnectionState) -> Self {
            self.connection_state = Some(input);
            self
        }
        /// <p>The state of the connection. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: The connection has been approved and is being initialized.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>available</code>: The network link is up and the connection is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>down</code>: The network link is down.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleting</code>: The connection is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deleted</code>: The connection has been deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code> state if it is deleted by the customer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unknown</code>: The state of the connection is not available.</p>
        /// </li>
        /// </ul>
        pub fn set_connection_state(
            mut self,
            input: std::option::Option<crate::model::ConnectionState>,
        ) -> Self {
            self.connection_state = input;
            self
        }
        /// <p>The Region where the connection is located.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Region where the connection is located.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The location of the connection.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The location of the connection.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The bandwidth of the connection.</p>
        pub fn bandwidth(mut self, input: impl Into<std::string::String>) -> Self {
            self.bandwidth = Some(input.into());
            self
        }
        /// <p>The bandwidth of the connection.</p>
        pub fn set_bandwidth(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bandwidth = input;
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn vlan(mut self, input: i32) -> Self {
            self.vlan = Some(input);
            self
        }
        /// <p>The ID of the VLAN.</p>
        pub fn set_vlan(mut self, input: std::option::Option<i32>) -> Self {
            self.vlan = input;
            self
        }
        /// <p>The name of the Direct Connect service provider associated with the connection.</p>
        pub fn partner_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.partner_name = Some(input.into());
            self
        }
        /// <p>The name of the Direct Connect service provider associated with the connection.</p>
        pub fn set_partner_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.partner_name = input;
            self
        }
        /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
        pub fn loa_issue_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.loa_issue_time = Some(input);
            self
        }
        /// <p>The time of the most recent call to <a>DescribeLoa</a> for this connection.</p>
        pub fn set_loa_issue_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.loa_issue_time = input;
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.lag_id = Some(input.into());
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lag_id = input;
            self
        }
        /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
        pub fn aws_device(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint on which the physical connection terminates.</p>
        pub fn set_aws_device(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_device = input;
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn jumbo_frame_capable(mut self, input: bool) -> Self {
            self.jumbo_frame_capable = Some(input);
            self
        }
        /// <p>Indicates whether jumbo frames (9001 MTU) are supported.</p>
        pub fn set_jumbo_frame_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.jumbo_frame_capable = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn aws_device_v2(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_device_v2 = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the physical connection.</p>
        pub fn set_aws_device_v2(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_device_v2 = input;
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn aws_logical_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_logical_device_id = Some(input.into());
            self
        }
        /// <p>The Direct Connect endpoint that terminates the logical connection. This device might be
        /// different than the device that terminates the physical connection.</p>
        pub fn set_aws_logical_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_logical_device_id = input;
            self
        }
        /// <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
        pub fn has_logical_redundancy(mut self, input: crate::model::HasLogicalRedundancy) -> Self {
            self.has_logical_redundancy = Some(input);
            self
        }
        /// <p>Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).</p>
        pub fn set_has_logical_redundancy(
            mut self,
            input: std::option::Option<crate::model::HasLogicalRedundancy>,
        ) -> Self {
            self.has_logical_redundancy = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the connection.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the connection.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name of the service provider associated with the connection.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The name of the service provider associated with the connection.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// <p>Indicates whether the connection supports MAC Security (MACsec).</p>
        pub fn mac_sec_capable(mut self, input: bool) -> Self {
            self.mac_sec_capable = Some(input);
            self
        }
        /// <p>Indicates whether the connection supports MAC Security (MACsec).</p>
        pub fn set_mac_sec_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.mac_sec_capable = input;
            self
        }
        /// <p>The MAC Security (MACsec) port link status of the connection.</p>
        /// <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
        pub fn port_encryption_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.port_encryption_status = Some(input.into());
            self
        }
        /// <p>The MAC Security (MACsec) port link status of the connection.</p>
        /// <p>The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or <code>Encryption Down</code>.</p>
        pub fn set_port_encryption_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.port_encryption_status = input;
            self
        }
        /// <p>The MAC Security (MACsec) connection encryption mode.</p>
        /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
        pub fn encryption_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_mode = Some(input.into());
            self
        }
        /// <p>The MAC Security (MACsec) connection encryption mode.</p>
        /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_mode = input;
            self
        }
        /// Appends an item to `mac_sec_keys`.
        ///
        /// To override the contents of this collection use [`set_mac_sec_keys`](Self::set_mac_sec_keys).
        ///
        /// <p>The MAC Security (MACsec) security keys associated with the connection.</p>
        pub fn mac_sec_keys(mut self, input: impl Into<crate::model::MacSecKey>) -> Self {
            let mut v = self.mac_sec_keys.unwrap_or_default();
            v.push(input.into());
            self.mac_sec_keys = Some(v);
            self
        }
        /// <p>The MAC Security (MACsec) security keys associated with the connection.</p>
        pub fn set_mac_sec_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MacSecKey>>,
        ) -> Self {
            self.mac_sec_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`AllocateConnectionOnInterconnectOutput`](crate::output::AllocateConnectionOnInterconnectOutput)
        pub fn build(self) -> crate::output::AllocateConnectionOnInterconnectOutput {
            crate::output::AllocateConnectionOnInterconnectOutput {
                owner_account: self.owner_account,
                connection_id: self.connection_id,
                connection_name: self.connection_name,
                connection_state: self.connection_state,
                region: self.region,
                location: self.location,
                bandwidth: self.bandwidth,
                vlan: self.vlan.unwrap_or_default(),
                partner_name: self.partner_name,
                loa_issue_time: self.loa_issue_time,
                lag_id: self.lag_id,
                aws_device: self.aws_device,
                jumbo_frame_capable: self.jumbo_frame_capable,
                aws_device_v2: self.aws_device_v2,
                aws_logical_device_id: self.aws_logical_device_id,
                has_logical_redundancy: self.has_logical_redundancy,
                tags: self.tags,
                provider_name: self.provider_name,
                mac_sec_capable: self.mac_sec_capable,
                port_encryption_status: self.port_encryption_status,
                encryption_mode: self.encryption_mode,
                mac_sec_keys: self.mac_sec_keys,
            }
        }
    }
}
impl AllocateConnectionOnInterconnectOutput {
    /// Creates a new builder-style object to manufacture [`AllocateConnectionOnInterconnectOutput`](crate::output::AllocateConnectionOnInterconnectOutput)
    pub fn builder() -> crate::output::allocate_connection_on_interconnect_output::Builder {
        crate::output::allocate_connection_on_interconnect_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceptDirectConnectGatewayAssociationProposalOutput {
    /// <p>Information about an association between a Direct Connect gateway and a virtual private gateway or transit gateway.</p>
    pub direct_connect_gateway_association:
        std::option::Option<crate::model::DirectConnectGatewayAssociation>,
}
impl std::fmt::Debug for AcceptDirectConnectGatewayAssociationProposalOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceptDirectConnectGatewayAssociationProposalOutput");
        formatter.field(
            "direct_connect_gateway_association",
            &self.direct_connect_gateway_association,
        );
        formatter.finish()
    }
}
/// See [`AcceptDirectConnectGatewayAssociationProposalOutput`](crate::output::AcceptDirectConnectGatewayAssociationProposalOutput)
pub mod accept_direct_connect_gateway_association_proposal_output {
    /// A builder for [`AcceptDirectConnectGatewayAssociationProposalOutput`](crate::output::AcceptDirectConnectGatewayAssociationProposalOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) direct_connect_gateway_association:
            std::option::Option<crate::model::DirectConnectGatewayAssociation>,
    }
    impl Builder {
        /// <p>Information about an association between a Direct Connect gateway and a virtual private gateway or transit gateway.</p>
        pub fn direct_connect_gateway_association(
            mut self,
            input: crate::model::DirectConnectGatewayAssociation,
        ) -> Self {
            self.direct_connect_gateway_association = Some(input);
            self
        }
        /// <p>Information about an association between a Direct Connect gateway and a virtual private gateway or transit gateway.</p>
        pub fn set_direct_connect_gateway_association(
            mut self,
            input: std::option::Option<crate::model::DirectConnectGatewayAssociation>,
        ) -> Self {
            self.direct_connect_gateway_association = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptDirectConnectGatewayAssociationProposalOutput`](crate::output::AcceptDirectConnectGatewayAssociationProposalOutput)
        pub fn build(self) -> crate::output::AcceptDirectConnectGatewayAssociationProposalOutput {
            crate::output::AcceptDirectConnectGatewayAssociationProposalOutput {
                direct_connect_gateway_association: self.direct_connect_gateway_association,
            }
        }
    }
}
impl AcceptDirectConnectGatewayAssociationProposalOutput {
    /// Creates a new builder-style object to manufacture [`AcceptDirectConnectGatewayAssociationProposalOutput`](crate::output::AcceptDirectConnectGatewayAssociationProposalOutput)
    pub fn builder(
    ) -> crate::output::accept_direct_connect_gateway_association_proposal_output::Builder {
        crate::output::accept_direct_connect_gateway_association_proposal_output::Builder::default()
    }
}
