// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AcceptDirectConnectGatewayAssociationProposalInput`](crate::input::AcceptDirectConnectGatewayAssociationProposalInput)
pub mod accept_direct_connect_gateway_association_proposal_input {
    /// A builder for [`AcceptDirectConnectGatewayAssociationProposalInput`](crate::input::AcceptDirectConnectGatewayAssociationProposalInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) direct_connect_gateway_id: std::option::Option<std::string::String>,
        pub(crate) proposal_id: std::option::Option<std::string::String>,
        pub(crate) associated_gateway_owner_account: std::option::Option<std::string::String>,
        pub(crate) override_allowed_prefixes_to_direct_connect_gateway:
            std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
    }
    impl Builder {
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.direct_connect_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_id = input;
            self
        }
        /// <p>The ID of the request proposal.</p>
        pub fn proposal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.proposal_id = Some(input.into());
            self
        }
        /// <p>The ID of the request proposal.</p>
        pub fn set_proposal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.proposal_id = input;
            self
        }
        /// <p>The ID of the account that owns the virtual private gateway or transit gateway.</p>
        pub fn associated_gateway_owner_account(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.associated_gateway_owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the account that owns the virtual private gateway or transit gateway.</p>
        pub fn set_associated_gateway_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.associated_gateway_owner_account = input;
            self
        }
        /// Appends an item to `override_allowed_prefixes_to_direct_connect_gateway`.
        ///
        /// To override the contents of this collection use [`set_override_allowed_prefixes_to_direct_connect_gateway`](Self::set_override_allowed_prefixes_to_direct_connect_gateway).
        ///
        /// <p>Overrides the Amazon VPC prefixes advertised to the Direct Connect gateway.</p>
        /// <p>For information about how to set the prefixes, see <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes">Allowed Prefixes</a> in the <i>Direct Connect User Guide</i>.</p>
        pub fn override_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: impl Into<crate::model::RouteFilterPrefix>,
        ) -> Self {
            let mut v = self
                .override_allowed_prefixes_to_direct_connect_gateway
                .unwrap_or_default();
            v.push(input.into());
            self.override_allowed_prefixes_to_direct_connect_gateway = Some(v);
            self
        }
        /// <p>Overrides the Amazon VPC prefixes advertised to the Direct Connect gateway.</p>
        /// <p>For information about how to set the prefixes, see <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes">Allowed Prefixes</a> in the <i>Direct Connect User Guide</i>.</p>
        pub fn set_override_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        ) -> Self {
            self.override_allowed_prefixes_to_direct_connect_gateway = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptDirectConnectGatewayAssociationProposalInput`](crate::input::AcceptDirectConnectGatewayAssociationProposalInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AcceptDirectConnectGatewayAssociationProposalInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::AcceptDirectConnectGatewayAssociationProposalInput {
                    direct_connect_gateway_id: self.direct_connect_gateway_id,
                    proposal_id: self.proposal_id,
                    associated_gateway_owner_account: self.associated_gateway_owner_account,
                    override_allowed_prefixes_to_direct_connect_gateway: self
                        .override_allowed_prefixes_to_direct_connect_gateway,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type AcceptDirectConnectGatewayAssociationProposalInputOperationOutputAlias =
    crate::operation::AcceptDirectConnectGatewayAssociationProposal;
#[doc(hidden)]
pub type AcceptDirectConnectGatewayAssociationProposalInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl AcceptDirectConnectGatewayAssociationProposalInput {
    /// Consumes the builder and constructs an Operation<[`AcceptDirectConnectGatewayAssociationProposal`](crate::operation::AcceptDirectConnectGatewayAssociationProposal)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AcceptDirectConnectGatewayAssociationProposal,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AcceptDirectConnectGatewayAssociationProposalInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AcceptDirectConnectGatewayAssociationProposalInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AcceptDirectConnectGatewayAssociationProposalInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.AcceptDirectConnectGatewayAssociationProposal",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_accept_direct_connect_gateway_association_proposal(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AcceptDirectConnectGatewayAssociationProposal::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AcceptDirectConnectGatewayAssociationProposal",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AcceptDirectConnectGatewayAssociationProposalInput`](crate::input::AcceptDirectConnectGatewayAssociationProposalInput)
    pub fn builder(
    ) -> crate::input::accept_direct_connect_gateway_association_proposal_input::Builder {
        crate::input::accept_direct_connect_gateway_association_proposal_input::Builder::default()
    }
}

/// See [`AllocateConnectionOnInterconnectInput`](crate::input::AllocateConnectionOnInterconnectInput)
pub mod allocate_connection_on_interconnect_input {
    /// A builder for [`AllocateConnectionOnInterconnectInput`](crate::input::AllocateConnectionOnInterconnectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bandwidth: std::option::Option<std::string::String>,
        pub(crate) connection_name: std::option::Option<std::string::String>,
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) interconnect_id: std::option::Option<std::string::String>,
        pub(crate) vlan: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The bandwidth of the connection. The possible values are 50Mbps, 100Mbps, 200Mbps,
        /// 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, and 10Gbps. Note that only those Direct Connect Partners
        /// who have met specific requirements
        /// are allowed to create a 1Gbps, 2Gbps, 5Gbps or 10Gbps hosted connection.</p>
        pub fn bandwidth(mut self, input: impl Into<std::string::String>) -> Self {
            self.bandwidth = Some(input.into());
            self
        }
        /// <p>The bandwidth of the connection. The possible values are 50Mbps, 100Mbps, 200Mbps,
        /// 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, and 10Gbps. Note that only those Direct Connect Partners
        /// who have met specific requirements
        /// are allowed to create a 1Gbps, 2Gbps, 5Gbps or 10Gbps hosted connection.</p>
        pub fn set_bandwidth(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bandwidth = input;
            self
        }
        /// <p>The name of the provisioned connection.</p>
        pub fn connection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_name = Some(input.into());
            self
        }
        /// <p>The name of the provisioned connection.</p>
        pub fn set_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_name = input;
            self
        }
        /// <p>The ID of the account of the customer for whom the connection will be provisioned.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the account of the customer for whom the connection will be provisioned.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>The ID of the interconnect on which the connection will be provisioned.</p>
        pub fn interconnect_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.interconnect_id = Some(input.into());
            self
        }
        /// <p>The ID of the interconnect on which the connection will be provisioned.</p>
        pub fn set_interconnect_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.interconnect_id = input;
            self
        }
        /// <p>The dedicated VLAN provisioned to the connection.</p>
        pub fn vlan(mut self, input: i32) -> Self {
            self.vlan = Some(input);
            self
        }
        /// <p>The dedicated VLAN provisioned to the connection.</p>
        pub fn set_vlan(mut self, input: std::option::Option<i32>) -> Self {
            self.vlan = input;
            self
        }
        /// Consumes the builder and constructs a [`AllocateConnectionOnInterconnectInput`](crate::input::AllocateConnectionOnInterconnectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AllocateConnectionOnInterconnectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AllocateConnectionOnInterconnectInput {
                bandwidth: self.bandwidth,
                connection_name: self.connection_name,
                owner_account: self.owner_account,
                interconnect_id: self.interconnect_id,
                vlan: self.vlan.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type AllocateConnectionOnInterconnectInputOperationOutputAlias =
    crate::operation::AllocateConnectionOnInterconnect;
#[doc(hidden)]
pub type AllocateConnectionOnInterconnectInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AllocateConnectionOnInterconnectInput {
    /// Consumes the builder and constructs an Operation<[`AllocateConnectionOnInterconnect`](crate::operation::AllocateConnectionOnInterconnect)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AllocateConnectionOnInterconnect,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AllocateConnectionOnInterconnectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AllocateConnectionOnInterconnectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AllocateConnectionOnInterconnectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.AllocateConnectionOnInterconnect",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_allocate_connection_on_interconnect(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AllocateConnectionOnInterconnect::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AllocateConnectionOnInterconnect",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AllocateConnectionOnInterconnectInput`](crate::input::AllocateConnectionOnInterconnectInput)
    pub fn builder() -> crate::input::allocate_connection_on_interconnect_input::Builder {
        crate::input::allocate_connection_on_interconnect_input::Builder::default()
    }
}

/// See [`AllocateHostedConnectionInput`](crate::input::AllocateHostedConnectionInput)
pub mod allocate_hosted_connection_input {
    /// A builder for [`AllocateHostedConnectionInput`](crate::input::AllocateHostedConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) bandwidth: std::option::Option<std::string::String>,
        pub(crate) connection_name: std::option::Option<std::string::String>,
        pub(crate) vlan: std::option::Option<i32>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the interconnect or LAG.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the interconnect or LAG.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The ID of the account ID of the customer for the connection.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the account ID of the customer for the connection.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>The bandwidth of the connection. The possible values are 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, and 10Gbps. Note that only those Direct Connect Partners who have met specific requirements are allowed to create a 1Gbps, 2Gbps, 5Gbps or 10Gbps hosted connection. </p>
        pub fn bandwidth(mut self, input: impl Into<std::string::String>) -> Self {
            self.bandwidth = Some(input.into());
            self
        }
        /// <p>The bandwidth of the connection. The possible values are 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, and 10Gbps. Note that only those Direct Connect Partners who have met specific requirements are allowed to create a 1Gbps, 2Gbps, 5Gbps or 10Gbps hosted connection. </p>
        pub fn set_bandwidth(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bandwidth = input;
            self
        }
        /// <p>The name of the hosted connection.</p>
        pub fn connection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_name = Some(input.into());
            self
        }
        /// <p>The name of the hosted connection.</p>
        pub fn set_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_name = input;
            self
        }
        /// <p>The dedicated VLAN provisioned to the hosted connection.</p>
        pub fn vlan(mut self, input: i32) -> Self {
            self.vlan = Some(input);
            self
        }
        /// <p>The dedicated VLAN provisioned to the hosted connection.</p>
        pub fn set_vlan(mut self, input: std::option::Option<i32>) -> Self {
            self.vlan = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the connection.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the connection.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`AllocateHostedConnectionInput`](crate::input::AllocateHostedConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AllocateHostedConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AllocateHostedConnectionInput {
                connection_id: self.connection_id,
                owner_account: self.owner_account,
                bandwidth: self.bandwidth,
                connection_name: self.connection_name,
                vlan: self.vlan.unwrap_or_default(),
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type AllocateHostedConnectionInputOperationOutputAlias =
    crate::operation::AllocateHostedConnection;
#[doc(hidden)]
pub type AllocateHostedConnectionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AllocateHostedConnectionInput {
    /// Consumes the builder and constructs an Operation<[`AllocateHostedConnection`](crate::operation::AllocateHostedConnection)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AllocateHostedConnection,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AllocateHostedConnectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AllocateHostedConnectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AllocateHostedConnectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.AllocateHostedConnection",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_allocate_hosted_connection(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AllocateHostedConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AllocateHostedConnection",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AllocateHostedConnectionInput`](crate::input::AllocateHostedConnectionInput)
    pub fn builder() -> crate::input::allocate_hosted_connection_input::Builder {
        crate::input::allocate_hosted_connection_input::Builder::default()
    }
}

/// See [`AllocatePrivateVirtualInterfaceInput`](crate::input::AllocatePrivateVirtualInterfaceInput)
pub mod allocate_private_virtual_interface_input {
    /// A builder for [`AllocatePrivateVirtualInterfaceInput`](crate::input::AllocatePrivateVirtualInterfaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) new_private_virtual_interface_allocation:
            std::option::Option<crate::model::NewPrivateVirtualInterfaceAllocation>,
    }
    impl Builder {
        /// <p>The ID of the connection on which the private virtual interface is provisioned.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the connection on which the private virtual interface is provisioned.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The ID of the account that owns the virtual private interface.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the account that owns the virtual private interface.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>Information about the private virtual interface.</p>
        pub fn new_private_virtual_interface_allocation(
            mut self,
            input: crate::model::NewPrivateVirtualInterfaceAllocation,
        ) -> Self {
            self.new_private_virtual_interface_allocation = Some(input);
            self
        }
        /// <p>Information about the private virtual interface.</p>
        pub fn set_new_private_virtual_interface_allocation(
            mut self,
            input: std::option::Option<crate::model::NewPrivateVirtualInterfaceAllocation>,
        ) -> Self {
            self.new_private_virtual_interface_allocation = input;
            self
        }
        /// Consumes the builder and constructs a [`AllocatePrivateVirtualInterfaceInput`](crate::input::AllocatePrivateVirtualInterfaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AllocatePrivateVirtualInterfaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AllocatePrivateVirtualInterfaceInput {
                connection_id: self.connection_id,
                owner_account: self.owner_account,
                new_private_virtual_interface_allocation: self
                    .new_private_virtual_interface_allocation,
            })
        }
    }
}
#[doc(hidden)]
pub type AllocatePrivateVirtualInterfaceInputOperationOutputAlias =
    crate::operation::AllocatePrivateVirtualInterface;
#[doc(hidden)]
pub type AllocatePrivateVirtualInterfaceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AllocatePrivateVirtualInterfaceInput {
    /// Consumes the builder and constructs an Operation<[`AllocatePrivateVirtualInterface`](crate::operation::AllocatePrivateVirtualInterface)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AllocatePrivateVirtualInterface,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AllocatePrivateVirtualInterfaceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AllocatePrivateVirtualInterfaceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AllocatePrivateVirtualInterfaceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.AllocatePrivateVirtualInterface",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_allocate_private_virtual_interface(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AllocatePrivateVirtualInterface::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AllocatePrivateVirtualInterface",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AllocatePrivateVirtualInterfaceInput`](crate::input::AllocatePrivateVirtualInterfaceInput)
    pub fn builder() -> crate::input::allocate_private_virtual_interface_input::Builder {
        crate::input::allocate_private_virtual_interface_input::Builder::default()
    }
}

/// See [`AllocatePublicVirtualInterfaceInput`](crate::input::AllocatePublicVirtualInterfaceInput)
pub mod allocate_public_virtual_interface_input {
    /// A builder for [`AllocatePublicVirtualInterfaceInput`](crate::input::AllocatePublicVirtualInterfaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) new_public_virtual_interface_allocation:
            std::option::Option<crate::model::NewPublicVirtualInterfaceAllocation>,
    }
    impl Builder {
        /// <p>The ID of the connection on which the public virtual interface is provisioned.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the connection on which the public virtual interface is provisioned.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The ID of the account that owns the public virtual interface.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the account that owns the public virtual interface.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>Information about the public virtual interface.</p>
        pub fn new_public_virtual_interface_allocation(
            mut self,
            input: crate::model::NewPublicVirtualInterfaceAllocation,
        ) -> Self {
            self.new_public_virtual_interface_allocation = Some(input);
            self
        }
        /// <p>Information about the public virtual interface.</p>
        pub fn set_new_public_virtual_interface_allocation(
            mut self,
            input: std::option::Option<crate::model::NewPublicVirtualInterfaceAllocation>,
        ) -> Self {
            self.new_public_virtual_interface_allocation = input;
            self
        }
        /// Consumes the builder and constructs a [`AllocatePublicVirtualInterfaceInput`](crate::input::AllocatePublicVirtualInterfaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AllocatePublicVirtualInterfaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AllocatePublicVirtualInterfaceInput {
                connection_id: self.connection_id,
                owner_account: self.owner_account,
                new_public_virtual_interface_allocation: self
                    .new_public_virtual_interface_allocation,
            })
        }
    }
}
#[doc(hidden)]
pub type AllocatePublicVirtualInterfaceInputOperationOutputAlias =
    crate::operation::AllocatePublicVirtualInterface;
#[doc(hidden)]
pub type AllocatePublicVirtualInterfaceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AllocatePublicVirtualInterfaceInput {
    /// Consumes the builder and constructs an Operation<[`AllocatePublicVirtualInterface`](crate::operation::AllocatePublicVirtualInterface)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AllocatePublicVirtualInterface,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AllocatePublicVirtualInterfaceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AllocatePublicVirtualInterfaceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AllocatePublicVirtualInterfaceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.AllocatePublicVirtualInterface",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_allocate_public_virtual_interface(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AllocatePublicVirtualInterface::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AllocatePublicVirtualInterface",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AllocatePublicVirtualInterfaceInput`](crate::input::AllocatePublicVirtualInterfaceInput)
    pub fn builder() -> crate::input::allocate_public_virtual_interface_input::Builder {
        crate::input::allocate_public_virtual_interface_input::Builder::default()
    }
}

/// See [`AllocateTransitVirtualInterfaceInput`](crate::input::AllocateTransitVirtualInterfaceInput)
pub mod allocate_transit_virtual_interface_input {
    /// A builder for [`AllocateTransitVirtualInterfaceInput`](crate::input::AllocateTransitVirtualInterfaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) new_transit_virtual_interface_allocation:
            std::option::Option<crate::model::NewTransitVirtualInterfaceAllocation>,
    }
    impl Builder {
        /// <p>The ID of the connection on which the transit virtual interface is provisioned.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the connection on which the transit virtual interface is provisioned.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The ID of the account that owns the transit virtual interface.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the account that owns the transit virtual interface.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>Information about the transit virtual interface.</p>
        pub fn new_transit_virtual_interface_allocation(
            mut self,
            input: crate::model::NewTransitVirtualInterfaceAllocation,
        ) -> Self {
            self.new_transit_virtual_interface_allocation = Some(input);
            self
        }
        /// <p>Information about the transit virtual interface.</p>
        pub fn set_new_transit_virtual_interface_allocation(
            mut self,
            input: std::option::Option<crate::model::NewTransitVirtualInterfaceAllocation>,
        ) -> Self {
            self.new_transit_virtual_interface_allocation = input;
            self
        }
        /// Consumes the builder and constructs a [`AllocateTransitVirtualInterfaceInput`](crate::input::AllocateTransitVirtualInterfaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AllocateTransitVirtualInterfaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AllocateTransitVirtualInterfaceInput {
                connection_id: self.connection_id,
                owner_account: self.owner_account,
                new_transit_virtual_interface_allocation: self
                    .new_transit_virtual_interface_allocation,
            })
        }
    }
}
#[doc(hidden)]
pub type AllocateTransitVirtualInterfaceInputOperationOutputAlias =
    crate::operation::AllocateTransitVirtualInterface;
#[doc(hidden)]
pub type AllocateTransitVirtualInterfaceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AllocateTransitVirtualInterfaceInput {
    /// Consumes the builder and constructs an Operation<[`AllocateTransitVirtualInterface`](crate::operation::AllocateTransitVirtualInterface)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AllocateTransitVirtualInterface,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AllocateTransitVirtualInterfaceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AllocateTransitVirtualInterfaceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AllocateTransitVirtualInterfaceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.AllocateTransitVirtualInterface",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_allocate_transit_virtual_interface(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AllocateTransitVirtualInterface::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AllocateTransitVirtualInterface",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AllocateTransitVirtualInterfaceInput`](crate::input::AllocateTransitVirtualInterfaceInput)
    pub fn builder() -> crate::input::allocate_transit_virtual_interface_input::Builder {
        crate::input::allocate_transit_virtual_interface_input::Builder::default()
    }
}

/// See [`AssociateConnectionWithLagInput`](crate::input::AssociateConnectionWithLagInput)
pub mod associate_connection_with_lag_input {
    /// A builder for [`AssociateConnectionWithLagInput`](crate::input::AssociateConnectionWithLagInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) lag_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The ID of the LAG with which to associate the connection.</p>
        pub fn lag_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.lag_id = Some(input.into());
            self
        }
        /// <p>The ID of the LAG with which to associate the connection.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lag_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateConnectionWithLagInput`](crate::input::AssociateConnectionWithLagInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateConnectionWithLagInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateConnectionWithLagInput {
                connection_id: self.connection_id,
                lag_id: self.lag_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateConnectionWithLagInputOperationOutputAlias =
    crate::operation::AssociateConnectionWithLag;
#[doc(hidden)]
pub type AssociateConnectionWithLagInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateConnectionWithLagInput {
    /// Consumes the builder and constructs an Operation<[`AssociateConnectionWithLag`](crate::operation::AssociateConnectionWithLag)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateConnectionWithLag,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateConnectionWithLagInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateConnectionWithLagInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateConnectionWithLagInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.AssociateConnectionWithLag",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_connection_with_lag(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateConnectionWithLag::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateConnectionWithLag",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateConnectionWithLagInput`](crate::input::AssociateConnectionWithLagInput)
    pub fn builder() -> crate::input::associate_connection_with_lag_input::Builder {
        crate::input::associate_connection_with_lag_input::Builder::default()
    }
}

/// See [`AssociateHostedConnectionInput`](crate::input::AssociateHostedConnectionInput)
pub mod associate_hosted_connection_input {
    /// A builder for [`AssociateHostedConnectionInput`](crate::input::AssociateHostedConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) parent_connection_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the hosted connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the hosted connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The ID of the interconnect or the LAG.</p>
        pub fn parent_connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the interconnect or the LAG.</p>
        pub fn set_parent_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_connection_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateHostedConnectionInput`](crate::input::AssociateHostedConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateHostedConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateHostedConnectionInput {
                connection_id: self.connection_id,
                parent_connection_id: self.parent_connection_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateHostedConnectionInputOperationOutputAlias =
    crate::operation::AssociateHostedConnection;
#[doc(hidden)]
pub type AssociateHostedConnectionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateHostedConnectionInput {
    /// Consumes the builder and constructs an Operation<[`AssociateHostedConnection`](crate::operation::AssociateHostedConnection)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateHostedConnection,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateHostedConnectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateHostedConnectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateHostedConnectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.AssociateHostedConnection",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_hosted_connection(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateHostedConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateHostedConnection",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateHostedConnectionInput`](crate::input::AssociateHostedConnectionInput)
    pub fn builder() -> crate::input::associate_hosted_connection_input::Builder {
        crate::input::associate_hosted_connection_input::Builder::default()
    }
}

/// See [`AssociateMacSecKeyInput`](crate::input::AssociateMacSecKeyInput)
pub mod associate_mac_sec_key_input {
    /// A builder for [`AssociateMacSecKeyInput`](crate::input::AssociateMacSecKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) secret_arn: std::option::Option<std::string::String>,
        pub(crate) ckn: std::option::Option<std::string::String>,
        pub(crate) cak: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).</p>
        /// <p>You can use <a>DescribeConnections</a> or <a>DescribeLags</a> to retrieve connection ID.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).</p>
        /// <p>You can use <a>DescribeConnections</a> or <a>DescribeLags</a> to retrieve connection ID.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key to associate with the dedicated connection.</p>
        /// <p>You can use <a>DescribeConnections</a> or <a>DescribeLags</a> to retrieve the MAC Security (MACsec) secret key.</p>
        /// <p>If you use this request parameter, you do not use the <code>ckn</code> and <code>cak</code> request parameters.</p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key to associate with the dedicated connection.</p>
        /// <p>You can use <a>DescribeConnections</a> or <a>DescribeLags</a> to retrieve the MAC Security (MACsec) secret key.</p>
        /// <p>If you use this request parameter, you do not use the <code>ckn</code> and <code>cak</code> request parameters.</p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_arn = input;
            self
        }
        /// <p>The MAC Security (MACsec) CKN to associate with the dedicated connection.</p>
        /// <p>You can create the CKN/CAK pair using an industry standard tool.</p>
        /// <p> The valid values are 64 hexadecimal characters (0-9, A-E).</p>
        /// <p>If you use this request parameter, you must use the <code>cak</code> request parameter and not use the <code>secretARN</code> request parameter.</p>
        pub fn ckn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ckn = Some(input.into());
            self
        }
        /// <p>The MAC Security (MACsec) CKN to associate with the dedicated connection.</p>
        /// <p>You can create the CKN/CAK pair using an industry standard tool.</p>
        /// <p> The valid values are 64 hexadecimal characters (0-9, A-E).</p>
        /// <p>If you use this request parameter, you must use the <code>cak</code> request parameter and not use the <code>secretARN</code> request parameter.</p>
        pub fn set_ckn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ckn = input;
            self
        }
        /// <p>The MAC Security (MACsec) CAK to associate with the dedicated connection.</p>
        /// <p>You can create the CKN/CAK pair using an industry standard tool.</p>
        /// <p> The valid values are 64 hexadecimal characters (0-9, A-E).</p>
        /// <p>If you use this request parameter, you must use the <code>ckn</code> request parameter and not use the <code>secretARN</code> request parameter.</p>
        pub fn cak(mut self, input: impl Into<std::string::String>) -> Self {
            self.cak = Some(input.into());
            self
        }
        /// <p>The MAC Security (MACsec) CAK to associate with the dedicated connection.</p>
        /// <p>You can create the CKN/CAK pair using an industry standard tool.</p>
        /// <p> The valid values are 64 hexadecimal characters (0-9, A-E).</p>
        /// <p>If you use this request parameter, you must use the <code>ckn</code> request parameter and not use the <code>secretARN</code> request parameter.</p>
        pub fn set_cak(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cak = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateMacSecKeyInput`](crate::input::AssociateMacSecKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateMacSecKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateMacSecKeyInput {
                connection_id: self.connection_id,
                secret_arn: self.secret_arn,
                ckn: self.ckn,
                cak: self.cak,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateMacSecKeyInputOperationOutputAlias = crate::operation::AssociateMacSecKey;
#[doc(hidden)]
pub type AssociateMacSecKeyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateMacSecKeyInput {
    /// Consumes the builder and constructs an Operation<[`AssociateMacSecKey`](crate::operation::AssociateMacSecKey)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateMacSecKey,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateMacSecKeyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateMacSecKeyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateMacSecKeyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.AssociateMacSecKey",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_mac_sec_key(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateMacSecKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateMacSecKey",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateMacSecKeyInput`](crate::input::AssociateMacSecKeyInput)
    pub fn builder() -> crate::input::associate_mac_sec_key_input::Builder {
        crate::input::associate_mac_sec_key_input::Builder::default()
    }
}

/// See [`AssociateVirtualInterfaceInput`](crate::input::AssociateVirtualInterfaceInput)
pub mod associate_virtual_interface_input {
    /// A builder for [`AssociateVirtualInterfaceInput`](crate::input::AssociateVirtualInterfaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_interface_id: std::option::Option<std::string::String>,
        pub(crate) connection_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_id = input;
            self
        }
        /// <p>The ID of the LAG or connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the LAG or connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateVirtualInterfaceInput`](crate::input::AssociateVirtualInterfaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateVirtualInterfaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateVirtualInterfaceInput {
                virtual_interface_id: self.virtual_interface_id,
                connection_id: self.connection_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateVirtualInterfaceInputOperationOutputAlias =
    crate::operation::AssociateVirtualInterface;
#[doc(hidden)]
pub type AssociateVirtualInterfaceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateVirtualInterfaceInput {
    /// Consumes the builder and constructs an Operation<[`AssociateVirtualInterface`](crate::operation::AssociateVirtualInterface)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateVirtualInterface,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateVirtualInterfaceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateVirtualInterfaceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateVirtualInterfaceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.AssociateVirtualInterface",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_virtual_interface(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateVirtualInterface::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateVirtualInterface",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateVirtualInterfaceInput`](crate::input::AssociateVirtualInterfaceInput)
    pub fn builder() -> crate::input::associate_virtual_interface_input::Builder {
        crate::input::associate_virtual_interface_input::Builder::default()
    }
}

/// See [`ConfirmConnectionInput`](crate::input::ConfirmConnectionInput)
pub mod confirm_connection_input {
    /// A builder for [`ConfirmConnectionInput`](crate::input::ConfirmConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the hosted connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the hosted connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfirmConnectionInput`](crate::input::ConfirmConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ConfirmConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ConfirmConnectionInput {
                connection_id: self.connection_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ConfirmConnectionInputOperationOutputAlias = crate::operation::ConfirmConnection;
#[doc(hidden)]
pub type ConfirmConnectionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ConfirmConnectionInput {
    /// Consumes the builder and constructs an Operation<[`ConfirmConnection`](crate::operation::ConfirmConnection)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ConfirmConnection,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ConfirmConnectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ConfirmConnectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ConfirmConnectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.ConfirmConnection",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_confirm_connection(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ConfirmConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ConfirmConnection",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ConfirmConnectionInput`](crate::input::ConfirmConnectionInput)
    pub fn builder() -> crate::input::confirm_connection_input::Builder {
        crate::input::confirm_connection_input::Builder::default()
    }
}

/// See [`ConfirmPrivateVirtualInterfaceInput`](crate::input::ConfirmPrivateVirtualInterfaceInput)
pub mod confirm_private_virtual_interface_input {
    /// A builder for [`ConfirmPrivateVirtualInterfaceInput`](crate::input::ConfirmPrivateVirtualInterfaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_interface_id: std::option::Option<std::string::String>,
        pub(crate) virtual_gateway_id: std::option::Option<std::string::String>,
        pub(crate) direct_connect_gateway_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_id = input;
            self
        }
        /// <p>The ID of the virtual private gateway.</p>
        pub fn virtual_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual private gateway.</p>
        pub fn set_virtual_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_gateway_id = input;
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.direct_connect_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfirmPrivateVirtualInterfaceInput`](crate::input::ConfirmPrivateVirtualInterfaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ConfirmPrivateVirtualInterfaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ConfirmPrivateVirtualInterfaceInput {
                virtual_interface_id: self.virtual_interface_id,
                virtual_gateway_id: self.virtual_gateway_id,
                direct_connect_gateway_id: self.direct_connect_gateway_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ConfirmPrivateVirtualInterfaceInputOperationOutputAlias =
    crate::operation::ConfirmPrivateVirtualInterface;
#[doc(hidden)]
pub type ConfirmPrivateVirtualInterfaceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ConfirmPrivateVirtualInterfaceInput {
    /// Consumes the builder and constructs an Operation<[`ConfirmPrivateVirtualInterface`](crate::operation::ConfirmPrivateVirtualInterface)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ConfirmPrivateVirtualInterface,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ConfirmPrivateVirtualInterfaceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ConfirmPrivateVirtualInterfaceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ConfirmPrivateVirtualInterfaceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.ConfirmPrivateVirtualInterface",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_confirm_private_virtual_interface(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ConfirmPrivateVirtualInterface::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ConfirmPrivateVirtualInterface",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ConfirmPrivateVirtualInterfaceInput`](crate::input::ConfirmPrivateVirtualInterfaceInput)
    pub fn builder() -> crate::input::confirm_private_virtual_interface_input::Builder {
        crate::input::confirm_private_virtual_interface_input::Builder::default()
    }
}

/// See [`ConfirmPublicVirtualInterfaceInput`](crate::input::ConfirmPublicVirtualInterfaceInput)
pub mod confirm_public_virtual_interface_input {
    /// A builder for [`ConfirmPublicVirtualInterfaceInput`](crate::input::ConfirmPublicVirtualInterfaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_interface_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfirmPublicVirtualInterfaceInput`](crate::input::ConfirmPublicVirtualInterfaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ConfirmPublicVirtualInterfaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ConfirmPublicVirtualInterfaceInput {
                virtual_interface_id: self.virtual_interface_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ConfirmPublicVirtualInterfaceInputOperationOutputAlias =
    crate::operation::ConfirmPublicVirtualInterface;
#[doc(hidden)]
pub type ConfirmPublicVirtualInterfaceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ConfirmPublicVirtualInterfaceInput {
    /// Consumes the builder and constructs an Operation<[`ConfirmPublicVirtualInterface`](crate::operation::ConfirmPublicVirtualInterface)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ConfirmPublicVirtualInterface,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ConfirmPublicVirtualInterfaceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ConfirmPublicVirtualInterfaceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ConfirmPublicVirtualInterfaceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.ConfirmPublicVirtualInterface",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_confirm_public_virtual_interface(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ConfirmPublicVirtualInterface::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ConfirmPublicVirtualInterface",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ConfirmPublicVirtualInterfaceInput`](crate::input::ConfirmPublicVirtualInterfaceInput)
    pub fn builder() -> crate::input::confirm_public_virtual_interface_input::Builder {
        crate::input::confirm_public_virtual_interface_input::Builder::default()
    }
}

/// See [`ConfirmTransitVirtualInterfaceInput`](crate::input::ConfirmTransitVirtualInterfaceInput)
pub mod confirm_transit_virtual_interface_input {
    /// A builder for [`ConfirmTransitVirtualInterfaceInput`](crate::input::ConfirmTransitVirtualInterfaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_interface_id: std::option::Option<std::string::String>,
        pub(crate) direct_connect_gateway_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_id = input;
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.direct_connect_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfirmTransitVirtualInterfaceInput`](crate::input::ConfirmTransitVirtualInterfaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ConfirmTransitVirtualInterfaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ConfirmTransitVirtualInterfaceInput {
                virtual_interface_id: self.virtual_interface_id,
                direct_connect_gateway_id: self.direct_connect_gateway_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ConfirmTransitVirtualInterfaceInputOperationOutputAlias =
    crate::operation::ConfirmTransitVirtualInterface;
#[doc(hidden)]
pub type ConfirmTransitVirtualInterfaceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ConfirmTransitVirtualInterfaceInput {
    /// Consumes the builder and constructs an Operation<[`ConfirmTransitVirtualInterface`](crate::operation::ConfirmTransitVirtualInterface)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ConfirmTransitVirtualInterface,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ConfirmTransitVirtualInterfaceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ConfirmTransitVirtualInterfaceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ConfirmTransitVirtualInterfaceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.ConfirmTransitVirtualInterface",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_confirm_transit_virtual_interface(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ConfirmTransitVirtualInterface::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ConfirmTransitVirtualInterface",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ConfirmTransitVirtualInterfaceInput`](crate::input::ConfirmTransitVirtualInterfaceInput)
    pub fn builder() -> crate::input::confirm_transit_virtual_interface_input::Builder {
        crate::input::confirm_transit_virtual_interface_input::Builder::default()
    }
}

/// See [`CreateBgpPeerInput`](crate::input::CreateBgpPeerInput)
pub mod create_bgp_peer_input {
    /// A builder for [`CreateBgpPeerInput`](crate::input::CreateBgpPeerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_interface_id: std::option::Option<std::string::String>,
        pub(crate) new_bgp_peer: std::option::Option<crate::model::NewBgpPeer>,
    }
    impl Builder {
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_id = input;
            self
        }
        /// <p>Information about the BGP peer.</p>
        pub fn new_bgp_peer(mut self, input: crate::model::NewBgpPeer) -> Self {
            self.new_bgp_peer = Some(input);
            self
        }
        /// <p>Information about the BGP peer.</p>
        pub fn set_new_bgp_peer(
            mut self,
            input: std::option::Option<crate::model::NewBgpPeer>,
        ) -> Self {
            self.new_bgp_peer = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBgpPeerInput`](crate::input::CreateBgpPeerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBgpPeerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBgpPeerInput {
                virtual_interface_id: self.virtual_interface_id,
                new_bgp_peer: self.new_bgp_peer,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBgpPeerInputOperationOutputAlias = crate::operation::CreateBGPPeer;
#[doc(hidden)]
pub type CreateBgpPeerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateBgpPeerInput {
    /// Consumes the builder and constructs an Operation<[`CreateBGPPeer`](crate::operation::CreateBGPPeer)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBGPPeer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateBgpPeerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateBgpPeerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateBgpPeerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.CreateBGPPeer",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_bgp_peer(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBGPPeer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBGPPeer",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateBgpPeerInput`](crate::input::CreateBgpPeerInput)
    pub fn builder() -> crate::input::create_bgp_peer_input::Builder {
        crate::input::create_bgp_peer_input::Builder::default()
    }
}

/// See [`CreateConnectionInput`](crate::input::CreateConnectionInput)
pub mod create_connection_input {
    /// A builder for [`CreateConnectionInput`](crate::input::CreateConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) bandwidth: std::option::Option<std::string::String>,
        pub(crate) connection_name: std::option::Option<std::string::String>,
        pub(crate) lag_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) provider_name: std::option::Option<std::string::String>,
        pub(crate) request_mac_sec: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The location of the connection.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The location of the connection.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The bandwidth of the connection.</p>
        pub fn bandwidth(mut self, input: impl Into<std::string::String>) -> Self {
            self.bandwidth = Some(input.into());
            self
        }
        /// <p>The bandwidth of the connection.</p>
        pub fn set_bandwidth(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bandwidth = input;
            self
        }
        /// <p>The name of the connection.</p>
        pub fn connection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_name = Some(input.into());
            self
        }
        /// <p>The name of the connection.</p>
        pub fn set_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_name = input;
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.lag_id = Some(input.into());
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lag_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to associate with the lag.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to associate with the lag.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name of the service provider associated with the requested connection.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The name of the service provider associated with the requested connection.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// <p>Indicates whether you want the connection to support MAC Security (MACsec).</p>
        /// <p>MAC Security (MACsec) is only available on dedicated connections. For information about MAC Security (MACsec) prerequisties, see  <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites">MACsec prerequisties</a> in the <i>Direct Connect User Guide</i>.</p>
        pub fn request_mac_sec(mut self, input: bool) -> Self {
            self.request_mac_sec = Some(input);
            self
        }
        /// <p>Indicates whether you want the connection to support MAC Security (MACsec).</p>
        /// <p>MAC Security (MACsec) is only available on dedicated connections. For information about MAC Security (MACsec) prerequisties, see  <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites">MACsec prerequisties</a> in the <i>Direct Connect User Guide</i>.</p>
        pub fn set_request_mac_sec(mut self, input: std::option::Option<bool>) -> Self {
            self.request_mac_sec = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConnectionInput`](crate::input::CreateConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateConnectionInput {
                location: self.location,
                bandwidth: self.bandwidth,
                connection_name: self.connection_name,
                lag_id: self.lag_id,
                tags: self.tags,
                provider_name: self.provider_name,
                request_mac_sec: self.request_mac_sec,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateConnectionInputOperationOutputAlias = crate::operation::CreateConnection;
#[doc(hidden)]
pub type CreateConnectionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateConnectionInput {
    /// Consumes the builder and constructs an Operation<[`CreateConnection`](crate::operation::CreateConnection)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateConnection,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateConnectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateConnectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateConnectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.CreateConnection",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_connection(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateConnection",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateConnectionInput`](crate::input::CreateConnectionInput)
    pub fn builder() -> crate::input::create_connection_input::Builder {
        crate::input::create_connection_input::Builder::default()
    }
}

/// See [`CreateDirectConnectGatewayInput`](crate::input::CreateDirectConnectGatewayInput)
pub mod create_direct_connect_gateway_input {
    /// A builder for [`CreateDirectConnectGatewayInput`](crate::input::CreateDirectConnectGatewayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) direct_connect_gateway_name: std::option::Option<std::string::String>,
        pub(crate) amazon_side_asn: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_name = Some(input.into());
            self
        }
        /// <p>The name of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_name = input;
            self
        }
        /// <p>The autonomous system number (ASN) for Border Gateway Protocol (BGP) to be configured
        /// on the Amazon side of the connection. The ASN must be in the private range of 64,512 to
        /// 65,534 or 4,200,000,000 to 4,294,967,294. The default is 64512.</p>
        pub fn amazon_side_asn(mut self, input: i64) -> Self {
            self.amazon_side_asn = Some(input);
            self
        }
        /// <p>The autonomous system number (ASN) for Border Gateway Protocol (BGP) to be configured
        /// on the Amazon side of the connection. The ASN must be in the private range of 64,512 to
        /// 65,534 or 4,200,000,000 to 4,294,967,294. The default is 64512.</p>
        pub fn set_amazon_side_asn(mut self, input: std::option::Option<i64>) -> Self {
            self.amazon_side_asn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDirectConnectGatewayInput`](crate::input::CreateDirectConnectGatewayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDirectConnectGatewayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDirectConnectGatewayInput {
                direct_connect_gateway_name: self.direct_connect_gateway_name,
                amazon_side_asn: self.amazon_side_asn,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDirectConnectGatewayInputOperationOutputAlias =
    crate::operation::CreateDirectConnectGateway;
#[doc(hidden)]
pub type CreateDirectConnectGatewayInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDirectConnectGatewayInput {
    /// Consumes the builder and constructs an Operation<[`CreateDirectConnectGateway`](crate::operation::CreateDirectConnectGateway)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDirectConnectGateway,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDirectConnectGatewayInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDirectConnectGatewayInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDirectConnectGatewayInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.CreateDirectConnectGateway",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_direct_connect_gateway(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDirectConnectGateway::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDirectConnectGateway",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDirectConnectGatewayInput`](crate::input::CreateDirectConnectGatewayInput)
    pub fn builder() -> crate::input::create_direct_connect_gateway_input::Builder {
        crate::input::create_direct_connect_gateway_input::Builder::default()
    }
}

/// See [`CreateDirectConnectGatewayAssociationInput`](crate::input::CreateDirectConnectGatewayAssociationInput)
pub mod create_direct_connect_gateway_association_input {
    /// A builder for [`CreateDirectConnectGatewayAssociationInput`](crate::input::CreateDirectConnectGatewayAssociationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) direct_connect_gateway_id: std::option::Option<std::string::String>,
        pub(crate) gateway_id: std::option::Option<std::string::String>,
        pub(crate) add_allowed_prefixes_to_direct_connect_gateway:
            std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        pub(crate) virtual_gateway_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.direct_connect_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_id = input;
            self
        }
        /// <p>The ID of the virtual private gateway or transit gateway.</p>
        pub fn gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual private gateway or transit gateway.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_id = input;
            self
        }
        /// Appends an item to `add_allowed_prefixes_to_direct_connect_gateway`.
        ///
        /// To override the contents of this collection use [`set_add_allowed_prefixes_to_direct_connect_gateway`](Self::set_add_allowed_prefixes_to_direct_connect_gateway).
        ///
        /// <p>The Amazon VPC prefixes to advertise to the Direct Connect gateway</p>
        /// <p>This parameter is required when you create an association to a transit gateway.</p>
        /// <p>For information about how to set the prefixes, see <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes">Allowed Prefixes</a> in the <i>Direct Connect User Guide</i>.</p>
        pub fn add_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: impl Into<crate::model::RouteFilterPrefix>,
        ) -> Self {
            let mut v = self
                .add_allowed_prefixes_to_direct_connect_gateway
                .unwrap_or_default();
            v.push(input.into());
            self.add_allowed_prefixes_to_direct_connect_gateway = Some(v);
            self
        }
        /// <p>The Amazon VPC prefixes to advertise to the Direct Connect gateway</p>
        /// <p>This parameter is required when you create an association to a transit gateway.</p>
        /// <p>For information about how to set the prefixes, see <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes">Allowed Prefixes</a> in the <i>Direct Connect User Guide</i>.</p>
        pub fn set_add_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        ) -> Self {
            self.add_allowed_prefixes_to_direct_connect_gateway = input;
            self
        }
        /// <p>The ID of the virtual private gateway.</p>
        pub fn virtual_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual private gateway.</p>
        pub fn set_virtual_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_gateway_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDirectConnectGatewayAssociationInput`](crate::input::CreateDirectConnectGatewayAssociationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDirectConnectGatewayAssociationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDirectConnectGatewayAssociationInput {
                direct_connect_gateway_id: self.direct_connect_gateway_id,
                gateway_id: self.gateway_id,
                add_allowed_prefixes_to_direct_connect_gateway: self
                    .add_allowed_prefixes_to_direct_connect_gateway,
                virtual_gateway_id: self.virtual_gateway_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDirectConnectGatewayAssociationInputOperationOutputAlias =
    crate::operation::CreateDirectConnectGatewayAssociation;
#[doc(hidden)]
pub type CreateDirectConnectGatewayAssociationInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl CreateDirectConnectGatewayAssociationInput {
    /// Consumes the builder and constructs an Operation<[`CreateDirectConnectGatewayAssociation`](crate::operation::CreateDirectConnectGatewayAssociation)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDirectConnectGatewayAssociation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDirectConnectGatewayAssociationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDirectConnectGatewayAssociationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDirectConnectGatewayAssociationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.CreateDirectConnectGatewayAssociation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_direct_connect_gateway_association(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDirectConnectGatewayAssociation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDirectConnectGatewayAssociation",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDirectConnectGatewayAssociationInput`](crate::input::CreateDirectConnectGatewayAssociationInput)
    pub fn builder() -> crate::input::create_direct_connect_gateway_association_input::Builder {
        crate::input::create_direct_connect_gateway_association_input::Builder::default()
    }
}

/// See [`CreateDirectConnectGatewayAssociationProposalInput`](crate::input::CreateDirectConnectGatewayAssociationProposalInput)
pub mod create_direct_connect_gateway_association_proposal_input {
    /// A builder for [`CreateDirectConnectGatewayAssociationProposalInput`](crate::input::CreateDirectConnectGatewayAssociationProposalInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) direct_connect_gateway_id: std::option::Option<std::string::String>,
        pub(crate) direct_connect_gateway_owner_account: std::option::Option<std::string::String>,
        pub(crate) gateway_id: std::option::Option<std::string::String>,
        pub(crate) add_allowed_prefixes_to_direct_connect_gateway:
            std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        pub(crate) remove_allowed_prefixes_to_direct_connect_gateway:
            std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
    }
    impl Builder {
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.direct_connect_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_id = input;
            self
        }
        /// <p>The ID of the account that owns the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_owner_account(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_owner_account = Some(input.into());
            self
        }
        /// <p>The ID of the account that owns the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_owner_account = input;
            self
        }
        /// <p>The ID of the virtual private gateway or transit gateway.</p>
        pub fn gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual private gateway or transit gateway.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_id = input;
            self
        }
        /// Appends an item to `add_allowed_prefixes_to_direct_connect_gateway`.
        ///
        /// To override the contents of this collection use [`set_add_allowed_prefixes_to_direct_connect_gateway`](Self::set_add_allowed_prefixes_to_direct_connect_gateway).
        ///
        /// <p>The Amazon VPC prefixes to advertise to the Direct Connect gateway.</p>
        pub fn add_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: impl Into<crate::model::RouteFilterPrefix>,
        ) -> Self {
            let mut v = self
                .add_allowed_prefixes_to_direct_connect_gateway
                .unwrap_or_default();
            v.push(input.into());
            self.add_allowed_prefixes_to_direct_connect_gateway = Some(v);
            self
        }
        /// <p>The Amazon VPC prefixes to advertise to the Direct Connect gateway.</p>
        pub fn set_add_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        ) -> Self {
            self.add_allowed_prefixes_to_direct_connect_gateway = input;
            self
        }
        /// Appends an item to `remove_allowed_prefixes_to_direct_connect_gateway`.
        ///
        /// To override the contents of this collection use [`set_remove_allowed_prefixes_to_direct_connect_gateway`](Self::set_remove_allowed_prefixes_to_direct_connect_gateway).
        ///
        /// <p>The Amazon VPC prefixes to no longer advertise to the Direct Connect gateway.</p>
        pub fn remove_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: impl Into<crate::model::RouteFilterPrefix>,
        ) -> Self {
            let mut v = self
                .remove_allowed_prefixes_to_direct_connect_gateway
                .unwrap_or_default();
            v.push(input.into());
            self.remove_allowed_prefixes_to_direct_connect_gateway = Some(v);
            self
        }
        /// <p>The Amazon VPC prefixes to no longer advertise to the Direct Connect gateway.</p>
        pub fn set_remove_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        ) -> Self {
            self.remove_allowed_prefixes_to_direct_connect_gateway = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDirectConnectGatewayAssociationProposalInput`](crate::input::CreateDirectConnectGatewayAssociationProposalInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDirectConnectGatewayAssociationProposalInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::CreateDirectConnectGatewayAssociationProposalInput {
                    direct_connect_gateway_id: self.direct_connect_gateway_id,
                    direct_connect_gateway_owner_account: self.direct_connect_gateway_owner_account,
                    gateway_id: self.gateway_id,
                    add_allowed_prefixes_to_direct_connect_gateway: self
                        .add_allowed_prefixes_to_direct_connect_gateway,
                    remove_allowed_prefixes_to_direct_connect_gateway: self
                        .remove_allowed_prefixes_to_direct_connect_gateway,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type CreateDirectConnectGatewayAssociationProposalInputOperationOutputAlias =
    crate::operation::CreateDirectConnectGatewayAssociationProposal;
#[doc(hidden)]
pub type CreateDirectConnectGatewayAssociationProposalInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl CreateDirectConnectGatewayAssociationProposalInput {
    /// Consumes the builder and constructs an Operation<[`CreateDirectConnectGatewayAssociationProposal`](crate::operation::CreateDirectConnectGatewayAssociationProposal)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDirectConnectGatewayAssociationProposal,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDirectConnectGatewayAssociationProposalInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDirectConnectGatewayAssociationProposalInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDirectConnectGatewayAssociationProposalInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.CreateDirectConnectGatewayAssociationProposal",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_direct_connect_gateway_association_proposal(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDirectConnectGatewayAssociationProposal::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDirectConnectGatewayAssociationProposal",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDirectConnectGatewayAssociationProposalInput`](crate::input::CreateDirectConnectGatewayAssociationProposalInput)
    pub fn builder(
    ) -> crate::input::create_direct_connect_gateway_association_proposal_input::Builder {
        crate::input::create_direct_connect_gateway_association_proposal_input::Builder::default()
    }
}

/// See [`CreateInterconnectInput`](crate::input::CreateInterconnectInput)
pub mod create_interconnect_input {
    /// A builder for [`CreateInterconnectInput`](crate::input::CreateInterconnectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) interconnect_name: std::option::Option<std::string::String>,
        pub(crate) bandwidth: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) lag_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) provider_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the interconnect.</p>
        pub fn interconnect_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.interconnect_name = Some(input.into());
            self
        }
        /// <p>The name of the interconnect.</p>
        pub fn set_interconnect_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.interconnect_name = input;
            self
        }
        /// <p>The port bandwidth, in Gbps. The possible values are 1 and 10.</p>
        pub fn bandwidth(mut self, input: impl Into<std::string::String>) -> Self {
            self.bandwidth = Some(input.into());
            self
        }
        /// <p>The port bandwidth, in Gbps. The possible values are 1 and 10.</p>
        pub fn set_bandwidth(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bandwidth = input;
            self
        }
        /// <p>The location of the interconnect.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The location of the interconnect.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.lag_id = Some(input.into());
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lag_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to associate with the interconnect.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to associate with the interconnect.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name of the service provider associated with the interconnect.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The name of the service provider associated with the interconnect.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateInterconnectInput`](crate::input::CreateInterconnectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateInterconnectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateInterconnectInput {
                interconnect_name: self.interconnect_name,
                bandwidth: self.bandwidth,
                location: self.location,
                lag_id: self.lag_id,
                tags: self.tags,
                provider_name: self.provider_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateInterconnectInputOperationOutputAlias = crate::operation::CreateInterconnect;
#[doc(hidden)]
pub type CreateInterconnectInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateInterconnectInput {
    /// Consumes the builder and constructs an Operation<[`CreateInterconnect`](crate::operation::CreateInterconnect)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateInterconnect,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateInterconnectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateInterconnectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateInterconnectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.CreateInterconnect",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_interconnect(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateInterconnect::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateInterconnect",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateInterconnectInput`](crate::input::CreateInterconnectInput)
    pub fn builder() -> crate::input::create_interconnect_input::Builder {
        crate::input::create_interconnect_input::Builder::default()
    }
}

/// See [`CreateLagInput`](crate::input::CreateLagInput)
pub mod create_lag_input {
    /// A builder for [`CreateLagInput`](crate::input::CreateLagInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) number_of_connections: std::option::Option<i32>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) connections_bandwidth: std::option::Option<std::string::String>,
        pub(crate) lag_name: std::option::Option<std::string::String>,
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) child_connection_tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) provider_name: std::option::Option<std::string::String>,
        pub(crate) request_mac_sec: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The number of physical dedicated connections initially provisioned and bundled by the
        /// LAG.</p>
        pub fn number_of_connections(mut self, input: i32) -> Self {
            self.number_of_connections = Some(input);
            self
        }
        /// <p>The number of physical dedicated connections initially provisioned and bundled by the
        /// LAG.</p>
        pub fn set_number_of_connections(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_connections = input;
            self
        }
        /// <p>The location for the LAG.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The location for the LAG.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The bandwidth of the individual physical dedicated connections bundled by the LAG. The
        /// possible values are 1Gbps and 10Gbps. </p>
        pub fn connections_bandwidth(mut self, input: impl Into<std::string::String>) -> Self {
            self.connections_bandwidth = Some(input.into());
            self
        }
        /// <p>The bandwidth of the individual physical dedicated connections bundled by the LAG. The
        /// possible values are 1Gbps and 10Gbps. </p>
        pub fn set_connections_bandwidth(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connections_bandwidth = input;
            self
        }
        /// <p>The name of the LAG.</p>
        pub fn lag_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.lag_name = Some(input.into());
            self
        }
        /// <p>The name of the LAG.</p>
        pub fn set_lag_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lag_name = input;
            self
        }
        /// <p>The ID of an existing dedicated connection to migrate to the LAG.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of an existing dedicated connection to migrate to the LAG.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to associate with the LAG.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to associate with the LAG.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `child_connection_tags`.
        ///
        /// To override the contents of this collection use [`set_child_connection_tags`](Self::set_child_connection_tags).
        ///
        /// <p>The tags to associate with the automtically created LAGs.</p>
        pub fn child_connection_tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.child_connection_tags.unwrap_or_default();
            v.push(input.into());
            self.child_connection_tags = Some(v);
            self
        }
        /// <p>The tags to associate with the automtically created LAGs.</p>
        pub fn set_child_connection_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.child_connection_tags = input;
            self
        }
        /// <p>The name of the service provider associated with the LAG.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The name of the service provider associated with the LAG.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// <p>Indicates whether the connection will support MAC Security (MACsec).</p>
        /// <note>
        /// <p>All connections in the LAG must be capable of  supporting MAC Security (MACsec). For information about MAC Security (MACsec) prerequisties, see  <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites">MACsec prerequisties</a> in the <i>Direct Connect User Guide</i>.</p>
        /// </note>
        pub fn request_mac_sec(mut self, input: bool) -> Self {
            self.request_mac_sec = Some(input);
            self
        }
        /// <p>Indicates whether the connection will support MAC Security (MACsec).</p>
        /// <note>
        /// <p>All connections in the LAG must be capable of  supporting MAC Security (MACsec). For information about MAC Security (MACsec) prerequisties, see  <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites">MACsec prerequisties</a> in the <i>Direct Connect User Guide</i>.</p>
        /// </note>
        pub fn set_request_mac_sec(mut self, input: std::option::Option<bool>) -> Self {
            self.request_mac_sec = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLagInput`](crate::input::CreateLagInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::CreateLagInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::CreateLagInput {
                number_of_connections: self.number_of_connections.unwrap_or_default(),
                location: self.location,
                connections_bandwidth: self.connections_bandwidth,
                lag_name: self.lag_name,
                connection_id: self.connection_id,
                tags: self.tags,
                child_connection_tags: self.child_connection_tags,
                provider_name: self.provider_name,
                request_mac_sec: self.request_mac_sec,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLagInputOperationOutputAlias = crate::operation::CreateLag;
#[doc(hidden)]
pub type CreateLagInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateLagInput {
    /// Consumes the builder and constructs an Operation<[`CreateLag`](crate::operation::CreateLag)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLag,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateLagInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateLagInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateLagInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.CreateLag",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_lag(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::CreateLag::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "CreateLag",
                    "directconnect",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateLagInput`](crate::input::CreateLagInput)
    pub fn builder() -> crate::input::create_lag_input::Builder {
        crate::input::create_lag_input::Builder::default()
    }
}

/// See [`CreatePrivateVirtualInterfaceInput`](crate::input::CreatePrivateVirtualInterfaceInput)
pub mod create_private_virtual_interface_input {
    /// A builder for [`CreatePrivateVirtualInterfaceInput`](crate::input::CreatePrivateVirtualInterfaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) new_private_virtual_interface:
            std::option::Option<crate::model::NewPrivateVirtualInterface>,
    }
    impl Builder {
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>Information about the private virtual interface.</p>
        pub fn new_private_virtual_interface(
            mut self,
            input: crate::model::NewPrivateVirtualInterface,
        ) -> Self {
            self.new_private_virtual_interface = Some(input);
            self
        }
        /// <p>Information about the private virtual interface.</p>
        pub fn set_new_private_virtual_interface(
            mut self,
            input: std::option::Option<crate::model::NewPrivateVirtualInterface>,
        ) -> Self {
            self.new_private_virtual_interface = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePrivateVirtualInterfaceInput`](crate::input::CreatePrivateVirtualInterfaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePrivateVirtualInterfaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePrivateVirtualInterfaceInput {
                connection_id: self.connection_id,
                new_private_virtual_interface: self.new_private_virtual_interface,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePrivateVirtualInterfaceInputOperationOutputAlias =
    crate::operation::CreatePrivateVirtualInterface;
#[doc(hidden)]
pub type CreatePrivateVirtualInterfaceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreatePrivateVirtualInterfaceInput {
    /// Consumes the builder and constructs an Operation<[`CreatePrivateVirtualInterface`](crate::operation::CreatePrivateVirtualInterface)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePrivateVirtualInterface,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreatePrivateVirtualInterfaceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreatePrivateVirtualInterfaceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreatePrivateVirtualInterfaceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.CreatePrivateVirtualInterface",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_private_virtual_interface(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePrivateVirtualInterface::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePrivateVirtualInterface",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreatePrivateVirtualInterfaceInput`](crate::input::CreatePrivateVirtualInterfaceInput)
    pub fn builder() -> crate::input::create_private_virtual_interface_input::Builder {
        crate::input::create_private_virtual_interface_input::Builder::default()
    }
}

/// See [`CreatePublicVirtualInterfaceInput`](crate::input::CreatePublicVirtualInterfaceInput)
pub mod create_public_virtual_interface_input {
    /// A builder for [`CreatePublicVirtualInterfaceInput`](crate::input::CreatePublicVirtualInterfaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) new_public_virtual_interface:
            std::option::Option<crate::model::NewPublicVirtualInterface>,
    }
    impl Builder {
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>Information about the public virtual interface.</p>
        pub fn new_public_virtual_interface(
            mut self,
            input: crate::model::NewPublicVirtualInterface,
        ) -> Self {
            self.new_public_virtual_interface = Some(input);
            self
        }
        /// <p>Information about the public virtual interface.</p>
        pub fn set_new_public_virtual_interface(
            mut self,
            input: std::option::Option<crate::model::NewPublicVirtualInterface>,
        ) -> Self {
            self.new_public_virtual_interface = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePublicVirtualInterfaceInput`](crate::input::CreatePublicVirtualInterfaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePublicVirtualInterfaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePublicVirtualInterfaceInput {
                connection_id: self.connection_id,
                new_public_virtual_interface: self.new_public_virtual_interface,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePublicVirtualInterfaceInputOperationOutputAlias =
    crate::operation::CreatePublicVirtualInterface;
#[doc(hidden)]
pub type CreatePublicVirtualInterfaceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreatePublicVirtualInterfaceInput {
    /// Consumes the builder and constructs an Operation<[`CreatePublicVirtualInterface`](crate::operation::CreatePublicVirtualInterface)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePublicVirtualInterface,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreatePublicVirtualInterfaceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreatePublicVirtualInterfaceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreatePublicVirtualInterfaceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.CreatePublicVirtualInterface",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_public_virtual_interface(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePublicVirtualInterface::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePublicVirtualInterface",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreatePublicVirtualInterfaceInput`](crate::input::CreatePublicVirtualInterfaceInput)
    pub fn builder() -> crate::input::create_public_virtual_interface_input::Builder {
        crate::input::create_public_virtual_interface_input::Builder::default()
    }
}

/// See [`CreateTransitVirtualInterfaceInput`](crate::input::CreateTransitVirtualInterfaceInput)
pub mod create_transit_virtual_interface_input {
    /// A builder for [`CreateTransitVirtualInterfaceInput`](crate::input::CreateTransitVirtualInterfaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) new_transit_virtual_interface:
            std::option::Option<crate::model::NewTransitVirtualInterface>,
    }
    impl Builder {
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>Information about the transit virtual interface.</p>
        pub fn new_transit_virtual_interface(
            mut self,
            input: crate::model::NewTransitVirtualInterface,
        ) -> Self {
            self.new_transit_virtual_interface = Some(input);
            self
        }
        /// <p>Information about the transit virtual interface.</p>
        pub fn set_new_transit_virtual_interface(
            mut self,
            input: std::option::Option<crate::model::NewTransitVirtualInterface>,
        ) -> Self {
            self.new_transit_virtual_interface = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTransitVirtualInterfaceInput`](crate::input::CreateTransitVirtualInterfaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTransitVirtualInterfaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTransitVirtualInterfaceInput {
                connection_id: self.connection_id,
                new_transit_virtual_interface: self.new_transit_virtual_interface,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTransitVirtualInterfaceInputOperationOutputAlias =
    crate::operation::CreateTransitVirtualInterface;
#[doc(hidden)]
pub type CreateTransitVirtualInterfaceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateTransitVirtualInterfaceInput {
    /// Consumes the builder and constructs an Operation<[`CreateTransitVirtualInterface`](crate::operation::CreateTransitVirtualInterface)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTransitVirtualInterface,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateTransitVirtualInterfaceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateTransitVirtualInterfaceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateTransitVirtualInterfaceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.CreateTransitVirtualInterface",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_transit_virtual_interface(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTransitVirtualInterface::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTransitVirtualInterface",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateTransitVirtualInterfaceInput`](crate::input::CreateTransitVirtualInterfaceInput)
    pub fn builder() -> crate::input::create_transit_virtual_interface_input::Builder {
        crate::input::create_transit_virtual_interface_input::Builder::default()
    }
}

/// See [`DeleteBgpPeerInput`](crate::input::DeleteBgpPeerInput)
pub mod delete_bgp_peer_input {
    /// A builder for [`DeleteBgpPeerInput`](crate::input::DeleteBgpPeerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_interface_id: std::option::Option<std::string::String>,
        pub(crate) asn: std::option::Option<i32>,
        pub(crate) customer_address: std::option::Option<std::string::String>,
        pub(crate) bgp_peer_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_id = input;
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        pub fn asn(mut self, input: i32) -> Self {
            self.asn = Some(input);
            self
        }
        /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
        pub fn set_asn(mut self, input: std::option::Option<i32>) -> Self {
            self.asn = input;
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn customer_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_address = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the customer interface.</p>
        pub fn set_customer_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_address = input;
            self
        }
        /// <p>The ID of the BGP peer.</p>
        pub fn bgp_peer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bgp_peer_id = Some(input.into());
            self
        }
        /// <p>The ID of the BGP peer.</p>
        pub fn set_bgp_peer_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bgp_peer_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBgpPeerInput`](crate::input::DeleteBgpPeerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBgpPeerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBgpPeerInput {
                virtual_interface_id: self.virtual_interface_id,
                asn: self.asn.unwrap_or_default(),
                customer_address: self.customer_address,
                bgp_peer_id: self.bgp_peer_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBgpPeerInputOperationOutputAlias = crate::operation::DeleteBGPPeer;
#[doc(hidden)]
pub type DeleteBgpPeerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteBgpPeerInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBGPPeer`](crate::operation::DeleteBGPPeer)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBGPPeer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBgpPeerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBgpPeerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBgpPeerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.DeleteBGPPeer",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_bgp_peer(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBGPPeer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBGPPeer",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBgpPeerInput`](crate::input::DeleteBgpPeerInput)
    pub fn builder() -> crate::input::delete_bgp_peer_input::Builder {
        crate::input::delete_bgp_peer_input::Builder::default()
    }
}

/// See [`DeleteConnectionInput`](crate::input::DeleteConnectionInput)
pub mod delete_connection_input {
    /// A builder for [`DeleteConnectionInput`](crate::input::DeleteConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConnectionInput`](crate::input::DeleteConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteConnectionInput {
                connection_id: self.connection_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteConnectionInputOperationOutputAlias = crate::operation::DeleteConnection;
#[doc(hidden)]
pub type DeleteConnectionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteConnectionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteConnection`](crate::operation::DeleteConnection)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteConnection,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteConnectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteConnectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteConnectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.DeleteConnection",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_connection(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteConnection",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteConnectionInput`](crate::input::DeleteConnectionInput)
    pub fn builder() -> crate::input::delete_connection_input::Builder {
        crate::input::delete_connection_input::Builder::default()
    }
}

/// See [`DeleteDirectConnectGatewayInput`](crate::input::DeleteDirectConnectGatewayInput)
pub mod delete_direct_connect_gateway_input {
    /// A builder for [`DeleteDirectConnectGatewayInput`](crate::input::DeleteDirectConnectGatewayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) direct_connect_gateway_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.direct_connect_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDirectConnectGatewayInput`](crate::input::DeleteDirectConnectGatewayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDirectConnectGatewayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDirectConnectGatewayInput {
                direct_connect_gateway_id: self.direct_connect_gateway_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDirectConnectGatewayInputOperationOutputAlias =
    crate::operation::DeleteDirectConnectGateway;
#[doc(hidden)]
pub type DeleteDirectConnectGatewayInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDirectConnectGatewayInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDirectConnectGateway`](crate::operation::DeleteDirectConnectGateway)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDirectConnectGateway,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDirectConnectGatewayInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDirectConnectGatewayInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDirectConnectGatewayInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.DeleteDirectConnectGateway",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_direct_connect_gateway(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDirectConnectGateway::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDirectConnectGateway",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDirectConnectGatewayInput`](crate::input::DeleteDirectConnectGatewayInput)
    pub fn builder() -> crate::input::delete_direct_connect_gateway_input::Builder {
        crate::input::delete_direct_connect_gateway_input::Builder::default()
    }
}

/// See [`DeleteDirectConnectGatewayAssociationInput`](crate::input::DeleteDirectConnectGatewayAssociationInput)
pub mod delete_direct_connect_gateway_association_input {
    /// A builder for [`DeleteDirectConnectGatewayAssociationInput`](crate::input::DeleteDirectConnectGatewayAssociationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) association_id: std::option::Option<std::string::String>,
        pub(crate) direct_connect_gateway_id: std::option::Option<std::string::String>,
        pub(crate) virtual_gateway_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Direct Connect gateway association.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_id = Some(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway association.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_id = input;
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.direct_connect_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_id = input;
            self
        }
        /// <p>The ID of the virtual private gateway.</p>
        pub fn virtual_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual private gateway.</p>
        pub fn set_virtual_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_gateway_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDirectConnectGatewayAssociationInput`](crate::input::DeleteDirectConnectGatewayAssociationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDirectConnectGatewayAssociationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDirectConnectGatewayAssociationInput {
                association_id: self.association_id,
                direct_connect_gateway_id: self.direct_connect_gateway_id,
                virtual_gateway_id: self.virtual_gateway_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDirectConnectGatewayAssociationInputOperationOutputAlias =
    crate::operation::DeleteDirectConnectGatewayAssociation;
#[doc(hidden)]
pub type DeleteDirectConnectGatewayAssociationInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DeleteDirectConnectGatewayAssociationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDirectConnectGatewayAssociation`](crate::operation::DeleteDirectConnectGatewayAssociation)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDirectConnectGatewayAssociation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDirectConnectGatewayAssociationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDirectConnectGatewayAssociationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDirectConnectGatewayAssociationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.DeleteDirectConnectGatewayAssociation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_direct_connect_gateway_association(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDirectConnectGatewayAssociation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDirectConnectGatewayAssociation",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDirectConnectGatewayAssociationInput`](crate::input::DeleteDirectConnectGatewayAssociationInput)
    pub fn builder() -> crate::input::delete_direct_connect_gateway_association_input::Builder {
        crate::input::delete_direct_connect_gateway_association_input::Builder::default()
    }
}

/// See [`DeleteDirectConnectGatewayAssociationProposalInput`](crate::input::DeleteDirectConnectGatewayAssociationProposalInput)
pub mod delete_direct_connect_gateway_association_proposal_input {
    /// A builder for [`DeleteDirectConnectGatewayAssociationProposalInput`](crate::input::DeleteDirectConnectGatewayAssociationProposalInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) proposal_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the proposal.</p>
        pub fn proposal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.proposal_id = Some(input.into());
            self
        }
        /// <p>The ID of the proposal.</p>
        pub fn set_proposal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.proposal_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDirectConnectGatewayAssociationProposalInput`](crate::input::DeleteDirectConnectGatewayAssociationProposalInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDirectConnectGatewayAssociationProposalInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DeleteDirectConnectGatewayAssociationProposalInput {
                    proposal_id: self.proposal_id,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DeleteDirectConnectGatewayAssociationProposalInputOperationOutputAlias =
    crate::operation::DeleteDirectConnectGatewayAssociationProposal;
#[doc(hidden)]
pub type DeleteDirectConnectGatewayAssociationProposalInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DeleteDirectConnectGatewayAssociationProposalInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDirectConnectGatewayAssociationProposal`](crate::operation::DeleteDirectConnectGatewayAssociationProposal)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDirectConnectGatewayAssociationProposal,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDirectConnectGatewayAssociationProposalInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDirectConnectGatewayAssociationProposalInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDirectConnectGatewayAssociationProposalInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.DeleteDirectConnectGatewayAssociationProposal",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_direct_connect_gateway_association_proposal(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDirectConnectGatewayAssociationProposal::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDirectConnectGatewayAssociationProposal",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDirectConnectGatewayAssociationProposalInput`](crate::input::DeleteDirectConnectGatewayAssociationProposalInput)
    pub fn builder(
    ) -> crate::input::delete_direct_connect_gateway_association_proposal_input::Builder {
        crate::input::delete_direct_connect_gateway_association_proposal_input::Builder::default()
    }
}

/// See [`DeleteInterconnectInput`](crate::input::DeleteInterconnectInput)
pub mod delete_interconnect_input {
    /// A builder for [`DeleteInterconnectInput`](crate::input::DeleteInterconnectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) interconnect_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the interconnect.</p>
        pub fn interconnect_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.interconnect_id = Some(input.into());
            self
        }
        /// <p>The ID of the interconnect.</p>
        pub fn set_interconnect_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.interconnect_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteInterconnectInput`](crate::input::DeleteInterconnectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteInterconnectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteInterconnectInput {
                interconnect_id: self.interconnect_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteInterconnectInputOperationOutputAlias = crate::operation::DeleteInterconnect;
#[doc(hidden)]
pub type DeleteInterconnectInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteInterconnectInput {
    /// Consumes the builder and constructs an Operation<[`DeleteInterconnect`](crate::operation::DeleteInterconnect)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteInterconnect,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteInterconnectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteInterconnectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteInterconnectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.DeleteInterconnect",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_interconnect(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteInterconnect::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteInterconnect",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteInterconnectInput`](crate::input::DeleteInterconnectInput)
    pub fn builder() -> crate::input::delete_interconnect_input::Builder {
        crate::input::delete_interconnect_input::Builder::default()
    }
}

/// See [`DeleteLagInput`](crate::input::DeleteLagInput)
pub mod delete_lag_input {
    /// A builder for [`DeleteLagInput`](crate::input::DeleteLagInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lag_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.lag_id = Some(input.into());
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lag_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLagInput`](crate::input::DeleteLagInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::DeleteLagInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::DeleteLagInput {
                lag_id: self.lag_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteLagInputOperationOutputAlias = crate::operation::DeleteLag;
#[doc(hidden)]
pub type DeleteLagInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteLagInput {
    /// Consumes the builder and constructs an Operation<[`DeleteLag`](crate::operation::DeleteLag)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteLag,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteLagInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteLagInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteLagInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.DeleteLag",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_lag(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::DeleteLag::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "DeleteLag",
                    "directconnect",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteLagInput`](crate::input::DeleteLagInput)
    pub fn builder() -> crate::input::delete_lag_input::Builder {
        crate::input::delete_lag_input::Builder::default()
    }
}

/// See [`DeleteVirtualInterfaceInput`](crate::input::DeleteVirtualInterfaceInput)
pub mod delete_virtual_interface_input {
    /// A builder for [`DeleteVirtualInterfaceInput`](crate::input::DeleteVirtualInterfaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_interface_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVirtualInterfaceInput`](crate::input::DeleteVirtualInterfaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteVirtualInterfaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteVirtualInterfaceInput {
                virtual_interface_id: self.virtual_interface_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteVirtualInterfaceInputOperationOutputAlias = crate::operation::DeleteVirtualInterface;
#[doc(hidden)]
pub type DeleteVirtualInterfaceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteVirtualInterfaceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteVirtualInterface`](crate::operation::DeleteVirtualInterface)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteVirtualInterface,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteVirtualInterfaceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteVirtualInterfaceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteVirtualInterfaceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.DeleteVirtualInterface",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_virtual_interface(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteVirtualInterface::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteVirtualInterface",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteVirtualInterfaceInput`](crate::input::DeleteVirtualInterfaceInput)
    pub fn builder() -> crate::input::delete_virtual_interface_input::Builder {
        crate::input::delete_virtual_interface_input::Builder::default()
    }
}

/// See [`DescribeConnectionLoaInput`](crate::input::DescribeConnectionLoaInput)
pub mod describe_connection_loa_input {
    /// A builder for [`DescribeConnectionLoaInput`](crate::input::DescribeConnectionLoaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) provider_name: std::option::Option<std::string::String>,
        pub(crate) loa_content_type: std::option::Option<crate::model::LoaContentType>,
    }
    impl Builder {
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The name of the APN partner or service provider who establishes connectivity on your behalf. If you specify this parameter,
        /// the LOA-CFA lists the provider name alongside your company name as the requester of the cross connect.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The name of the APN partner or service provider who establishes connectivity on your behalf. If you specify this parameter,
        /// the LOA-CFA lists the provider name alongside your company name as the requester of the cross connect.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// <p>The standard media type for the LOA-CFA document. The only supported value is application/pdf.</p>
        pub fn loa_content_type(mut self, input: crate::model::LoaContentType) -> Self {
            self.loa_content_type = Some(input);
            self
        }
        /// <p>The standard media type for the LOA-CFA document. The only supported value is application/pdf.</p>
        pub fn set_loa_content_type(
            mut self,
            input: std::option::Option<crate::model::LoaContentType>,
        ) -> Self {
            self.loa_content_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConnectionLoaInput`](crate::input::DescribeConnectionLoaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeConnectionLoaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeConnectionLoaInput {
                connection_id: self.connection_id,
                provider_name: self.provider_name,
                loa_content_type: self.loa_content_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeConnectionLoaInputOperationOutputAlias = crate::operation::DescribeConnectionLoa;
#[doc(hidden)]
pub type DescribeConnectionLoaInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeConnectionLoaInput {
    /// Consumes the builder and constructs an Operation<[`DescribeConnectionLoa`](crate::operation::DescribeConnectionLoa)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeConnectionLoa,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeConnectionLoaInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeConnectionLoaInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeConnectionLoaInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.DescribeConnectionLoa",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_connection_loa(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeConnectionLoa::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeConnectionLoa",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeConnectionLoaInput`](crate::input::DescribeConnectionLoaInput)
    pub fn builder() -> crate::input::describe_connection_loa_input::Builder {
        crate::input::describe_connection_loa_input::Builder::default()
    }
}

/// See [`DescribeConnectionsInput`](crate::input::DescribeConnectionsInput)
pub mod describe_connections_input {
    /// A builder for [`DescribeConnectionsInput`](crate::input::DescribeConnectionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConnectionsInput`](crate::input::DescribeConnectionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeConnectionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeConnectionsInput {
                connection_id: self.connection_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeConnectionsInputOperationOutputAlias = crate::operation::DescribeConnections;
#[doc(hidden)]
pub type DescribeConnectionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeConnectionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeConnections`](crate::operation::DescribeConnections)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeConnections,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeConnectionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeConnectionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeConnectionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.DescribeConnections",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_connections(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeConnections::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeConnections",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeConnectionsInput`](crate::input::DescribeConnectionsInput)
    pub fn builder() -> crate::input::describe_connections_input::Builder {
        crate::input::describe_connections_input::Builder::default()
    }
}

/// See [`DescribeConnectionsOnInterconnectInput`](crate::input::DescribeConnectionsOnInterconnectInput)
pub mod describe_connections_on_interconnect_input {
    /// A builder for [`DescribeConnectionsOnInterconnectInput`](crate::input::DescribeConnectionsOnInterconnectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) interconnect_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the interconnect.</p>
        pub fn interconnect_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.interconnect_id = Some(input.into());
            self
        }
        /// <p>The ID of the interconnect.</p>
        pub fn set_interconnect_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.interconnect_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConnectionsOnInterconnectInput`](crate::input::DescribeConnectionsOnInterconnectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeConnectionsOnInterconnectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeConnectionsOnInterconnectInput {
                interconnect_id: self.interconnect_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeConnectionsOnInterconnectInputOperationOutputAlias =
    crate::operation::DescribeConnectionsOnInterconnect;
#[doc(hidden)]
pub type DescribeConnectionsOnInterconnectInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeConnectionsOnInterconnectInput {
    /// Consumes the builder and constructs an Operation<[`DescribeConnectionsOnInterconnect`](crate::operation::DescribeConnectionsOnInterconnect)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeConnectionsOnInterconnect,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeConnectionsOnInterconnectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeConnectionsOnInterconnectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeConnectionsOnInterconnectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.DescribeConnectionsOnInterconnect",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_connections_on_interconnect(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeConnectionsOnInterconnect::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeConnectionsOnInterconnect",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeConnectionsOnInterconnectInput`](crate::input::DescribeConnectionsOnInterconnectInput)
    pub fn builder() -> crate::input::describe_connections_on_interconnect_input::Builder {
        crate::input::describe_connections_on_interconnect_input::Builder::default()
    }
}

/// See [`DescribeDirectConnectGatewayAssociationProposalsInput`](crate::input::DescribeDirectConnectGatewayAssociationProposalsInput)
pub mod describe_direct_connect_gateway_association_proposals_input {
    /// A builder for [`DescribeDirectConnectGatewayAssociationProposalsInput`](crate::input::DescribeDirectConnectGatewayAssociationProposalsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) direct_connect_gateway_id: std::option::Option<std::string::String>,
        pub(crate) proposal_id: std::option::Option<std::string::String>,
        pub(crate) associated_gateway_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.direct_connect_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_id = input;
            self
        }
        /// <p>The ID of the proposal.</p>
        pub fn proposal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.proposal_id = Some(input.into());
            self
        }
        /// <p>The ID of the proposal.</p>
        pub fn set_proposal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.proposal_id = input;
            self
        }
        /// <p>The ID of the associated gateway.</p>
        pub fn associated_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.associated_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the associated gateway.</p>
        pub fn set_associated_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.associated_gateway_id = input;
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are
        /// returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are
        /// returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDirectConnectGatewayAssociationProposalsInput`](crate::input::DescribeDirectConnectGatewayAssociationProposalsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDirectConnectGatewayAssociationProposalsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DescribeDirectConnectGatewayAssociationProposalsInput {
                    direct_connect_gateway_id: self.direct_connect_gateway_id,
                    proposal_id: self.proposal_id,
                    associated_gateway_id: self.associated_gateway_id,
                    max_results: self.max_results,
                    next_token: self.next_token,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DescribeDirectConnectGatewayAssociationProposalsInputOperationOutputAlias =
    crate::operation::DescribeDirectConnectGatewayAssociationProposals;
#[doc(hidden)]
pub type DescribeDirectConnectGatewayAssociationProposalsInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeDirectConnectGatewayAssociationProposalsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDirectConnectGatewayAssociationProposals`](crate::operation::DescribeDirectConnectGatewayAssociationProposals)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDirectConnectGatewayAssociationProposals,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDirectConnectGatewayAssociationProposalsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDirectConnectGatewayAssociationProposalsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDirectConnectGatewayAssociationProposalsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.DescribeDirectConnectGatewayAssociationProposals",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_direct_connect_gateway_association_proposals(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDirectConnectGatewayAssociationProposals::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDirectConnectGatewayAssociationProposals",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDirectConnectGatewayAssociationProposalsInput`](crate::input::DescribeDirectConnectGatewayAssociationProposalsInput)
    pub fn builder(
    ) -> crate::input::describe_direct_connect_gateway_association_proposals_input::Builder {
        crate::input::describe_direct_connect_gateway_association_proposals_input::Builder::default(
        )
    }
}

/// See [`DescribeDirectConnectGatewayAssociationsInput`](crate::input::DescribeDirectConnectGatewayAssociationsInput)
pub mod describe_direct_connect_gateway_associations_input {
    /// A builder for [`DescribeDirectConnectGatewayAssociationsInput`](crate::input::DescribeDirectConnectGatewayAssociationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) association_id: std::option::Option<std::string::String>,
        pub(crate) associated_gateway_id: std::option::Option<std::string::String>,
        pub(crate) direct_connect_gateway_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) virtual_gateway_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Direct Connect gateway association.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_id = Some(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway association.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_id = input;
            self
        }
        /// <p>The ID of the associated gateway.</p>
        pub fn associated_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.associated_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the associated gateway.</p>
        pub fn set_associated_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.associated_gateway_id = input;
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.direct_connect_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_id = input;
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are
        /// returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are
        /// returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token provided in the previous call to retrieve the next page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token provided in the previous call to retrieve the next page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The ID of the virtual private gateway or transit gateway.</p>
        pub fn virtual_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual private gateway or transit gateway.</p>
        pub fn set_virtual_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_gateway_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDirectConnectGatewayAssociationsInput`](crate::input::DescribeDirectConnectGatewayAssociationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDirectConnectGatewayAssociationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DescribeDirectConnectGatewayAssociationsInput {
                    association_id: self.association_id,
                    associated_gateway_id: self.associated_gateway_id,
                    direct_connect_gateway_id: self.direct_connect_gateway_id,
                    max_results: self.max_results,
                    next_token: self.next_token,
                    virtual_gateway_id: self.virtual_gateway_id,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DescribeDirectConnectGatewayAssociationsInputOperationOutputAlias =
    crate::operation::DescribeDirectConnectGatewayAssociations;
#[doc(hidden)]
pub type DescribeDirectConnectGatewayAssociationsInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeDirectConnectGatewayAssociationsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDirectConnectGatewayAssociations`](crate::operation::DescribeDirectConnectGatewayAssociations)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDirectConnectGatewayAssociations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDirectConnectGatewayAssociationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDirectConnectGatewayAssociationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDirectConnectGatewayAssociationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.DescribeDirectConnectGatewayAssociations",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_direct_connect_gateway_associations(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDirectConnectGatewayAssociations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDirectConnectGatewayAssociations",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDirectConnectGatewayAssociationsInput`](crate::input::DescribeDirectConnectGatewayAssociationsInput)
    pub fn builder() -> crate::input::describe_direct_connect_gateway_associations_input::Builder {
        crate::input::describe_direct_connect_gateway_associations_input::Builder::default()
    }
}

/// See [`DescribeDirectConnectGatewayAttachmentsInput`](crate::input::DescribeDirectConnectGatewayAttachmentsInput)
pub mod describe_direct_connect_gateway_attachments_input {
    /// A builder for [`DescribeDirectConnectGatewayAttachmentsInput`](crate::input::DescribeDirectConnectGatewayAttachmentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) direct_connect_gateway_id: std::option::Option<std::string::String>,
        pub(crate) virtual_interface_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.direct_connect_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_id = input;
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_id = input;
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are
        /// returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are
        /// returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token provided in the previous call to retrieve the next page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token provided in the previous call to retrieve the next page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDirectConnectGatewayAttachmentsInput`](crate::input::DescribeDirectConnectGatewayAttachmentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDirectConnectGatewayAttachmentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDirectConnectGatewayAttachmentsInput {
                direct_connect_gateway_id: self.direct_connect_gateway_id,
                virtual_interface_id: self.virtual_interface_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDirectConnectGatewayAttachmentsInputOperationOutputAlias =
    crate::operation::DescribeDirectConnectGatewayAttachments;
#[doc(hidden)]
pub type DescribeDirectConnectGatewayAttachmentsInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeDirectConnectGatewayAttachmentsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDirectConnectGatewayAttachments`](crate::operation::DescribeDirectConnectGatewayAttachments)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDirectConnectGatewayAttachments,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDirectConnectGatewayAttachmentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDirectConnectGatewayAttachmentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDirectConnectGatewayAttachmentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.DescribeDirectConnectGatewayAttachments",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_direct_connect_gateway_attachments(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDirectConnectGatewayAttachments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDirectConnectGatewayAttachments",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDirectConnectGatewayAttachmentsInput`](crate::input::DescribeDirectConnectGatewayAttachmentsInput)
    pub fn builder() -> crate::input::describe_direct_connect_gateway_attachments_input::Builder {
        crate::input::describe_direct_connect_gateway_attachments_input::Builder::default()
    }
}

/// See [`DescribeDirectConnectGatewaysInput`](crate::input::DescribeDirectConnectGatewaysInput)
pub mod describe_direct_connect_gateways_input {
    /// A builder for [`DescribeDirectConnectGatewaysInput`](crate::input::DescribeDirectConnectGatewaysInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) direct_connect_gateway_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn direct_connect_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.direct_connect_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway.</p>
        pub fn set_direct_connect_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.direct_connect_gateway_id = input;
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are
        /// returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are
        /// returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token provided in the previous call to retrieve the next page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token provided in the previous call to retrieve the next page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDirectConnectGatewaysInput`](crate::input::DescribeDirectConnectGatewaysInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDirectConnectGatewaysInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDirectConnectGatewaysInput {
                direct_connect_gateway_id: self.direct_connect_gateway_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDirectConnectGatewaysInputOperationOutputAlias =
    crate::operation::DescribeDirectConnectGateways;
#[doc(hidden)]
pub type DescribeDirectConnectGatewaysInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDirectConnectGatewaysInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDirectConnectGateways`](crate::operation::DescribeDirectConnectGateways)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDirectConnectGateways,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDirectConnectGatewaysInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDirectConnectGatewaysInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDirectConnectGatewaysInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.DescribeDirectConnectGateways",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_direct_connect_gateways(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDirectConnectGateways::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDirectConnectGateways",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDirectConnectGatewaysInput`](crate::input::DescribeDirectConnectGatewaysInput)
    pub fn builder() -> crate::input::describe_direct_connect_gateways_input::Builder {
        crate::input::describe_direct_connect_gateways_input::Builder::default()
    }
}

/// See [`DescribeHostedConnectionsInput`](crate::input::DescribeHostedConnectionsInput)
pub mod describe_hosted_connections_input {
    /// A builder for [`DescribeHostedConnectionsInput`](crate::input::DescribeHostedConnectionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the interconnect or LAG.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the interconnect or LAG.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeHostedConnectionsInput`](crate::input::DescribeHostedConnectionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeHostedConnectionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeHostedConnectionsInput {
                connection_id: self.connection_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeHostedConnectionsInputOperationOutputAlias =
    crate::operation::DescribeHostedConnections;
#[doc(hidden)]
pub type DescribeHostedConnectionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeHostedConnectionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeHostedConnections`](crate::operation::DescribeHostedConnections)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeHostedConnections,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeHostedConnectionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeHostedConnectionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeHostedConnectionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.DescribeHostedConnections",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_hosted_connections(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeHostedConnections::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeHostedConnections",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeHostedConnectionsInput`](crate::input::DescribeHostedConnectionsInput)
    pub fn builder() -> crate::input::describe_hosted_connections_input::Builder {
        crate::input::describe_hosted_connections_input::Builder::default()
    }
}

/// See [`DescribeInterconnectLoaInput`](crate::input::DescribeInterconnectLoaInput)
pub mod describe_interconnect_loa_input {
    /// A builder for [`DescribeInterconnectLoaInput`](crate::input::DescribeInterconnectLoaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) interconnect_id: std::option::Option<std::string::String>,
        pub(crate) provider_name: std::option::Option<std::string::String>,
        pub(crate) loa_content_type: std::option::Option<crate::model::LoaContentType>,
    }
    impl Builder {
        /// <p>The ID of the interconnect.</p>
        pub fn interconnect_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.interconnect_id = Some(input.into());
            self
        }
        /// <p>The ID of the interconnect.</p>
        pub fn set_interconnect_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.interconnect_id = input;
            self
        }
        /// <p>The name of the service provider who establishes connectivity on your behalf. If you supply this parameter, the LOA-CFA lists the provider name alongside your company name as the requester of the cross connect.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The name of the service provider who establishes connectivity on your behalf. If you supply this parameter, the LOA-CFA lists the provider name alongside your company name as the requester of the cross connect.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// <p>The standard media type for the LOA-CFA document. The only supported value is application/pdf.</p>
        pub fn loa_content_type(mut self, input: crate::model::LoaContentType) -> Self {
            self.loa_content_type = Some(input);
            self
        }
        /// <p>The standard media type for the LOA-CFA document. The only supported value is application/pdf.</p>
        pub fn set_loa_content_type(
            mut self,
            input: std::option::Option<crate::model::LoaContentType>,
        ) -> Self {
            self.loa_content_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInterconnectLoaInput`](crate::input::DescribeInterconnectLoaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeInterconnectLoaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeInterconnectLoaInput {
                interconnect_id: self.interconnect_id,
                provider_name: self.provider_name,
                loa_content_type: self.loa_content_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeInterconnectLoaInputOperationOutputAlias =
    crate::operation::DescribeInterconnectLoa;
#[doc(hidden)]
pub type DescribeInterconnectLoaInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeInterconnectLoaInput {
    /// Consumes the builder and constructs an Operation<[`DescribeInterconnectLoa`](crate::operation::DescribeInterconnectLoa)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeInterconnectLoa,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeInterconnectLoaInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeInterconnectLoaInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeInterconnectLoaInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.DescribeInterconnectLoa",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_interconnect_loa(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeInterconnectLoa::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeInterconnectLoa",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeInterconnectLoaInput`](crate::input::DescribeInterconnectLoaInput)
    pub fn builder() -> crate::input::describe_interconnect_loa_input::Builder {
        crate::input::describe_interconnect_loa_input::Builder::default()
    }
}

/// See [`DescribeInterconnectsInput`](crate::input::DescribeInterconnectsInput)
pub mod describe_interconnects_input {
    /// A builder for [`DescribeInterconnectsInput`](crate::input::DescribeInterconnectsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) interconnect_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the interconnect.</p>
        pub fn interconnect_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.interconnect_id = Some(input.into());
            self
        }
        /// <p>The ID of the interconnect.</p>
        pub fn set_interconnect_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.interconnect_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInterconnectsInput`](crate::input::DescribeInterconnectsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeInterconnectsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeInterconnectsInput {
                interconnect_id: self.interconnect_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeInterconnectsInputOperationOutputAlias = crate::operation::DescribeInterconnects;
#[doc(hidden)]
pub type DescribeInterconnectsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeInterconnectsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeInterconnects`](crate::operation::DescribeInterconnects)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeInterconnects,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeInterconnectsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeInterconnectsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeInterconnectsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.DescribeInterconnects",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_interconnects(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeInterconnects::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeInterconnects",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeInterconnectsInput`](crate::input::DescribeInterconnectsInput)
    pub fn builder() -> crate::input::describe_interconnects_input::Builder {
        crate::input::describe_interconnects_input::Builder::default()
    }
}

/// See [`DescribeLagsInput`](crate::input::DescribeLagsInput)
pub mod describe_lags_input {
    /// A builder for [`DescribeLagsInput`](crate::input::DescribeLagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lag_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.lag_id = Some(input.into());
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lag_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLagsInput`](crate::input::DescribeLagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeLagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeLagsInput {
                lag_id: self.lag_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeLagsInputOperationOutputAlias = crate::operation::DescribeLags;
#[doc(hidden)]
pub type DescribeLagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeLagsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeLags`](crate::operation::DescribeLags)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeLags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeLagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeLagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeLagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.DescribeLags",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_lags(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeLags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeLags",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeLagsInput`](crate::input::DescribeLagsInput)
    pub fn builder() -> crate::input::describe_lags_input::Builder {
        crate::input::describe_lags_input::Builder::default()
    }
}

/// See [`DescribeLoaInput`](crate::input::DescribeLoaInput)
pub mod describe_loa_input {
    /// A builder for [`DescribeLoaInput`](crate::input::DescribeLoaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) provider_name: std::option::Option<std::string::String>,
        pub(crate) loa_content_type: std::option::Option<crate::model::LoaContentType>,
    }
    impl Builder {
        /// <p>The ID of a connection, LAG, or interconnect.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of a connection, LAG, or interconnect.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The name of the service provider who establishes connectivity on your behalf. If you specify this parameter, the
        /// LOA-CFA lists the provider name alongside your company name as the requester of the cross connect.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The name of the service provider who establishes connectivity on your behalf. If you specify this parameter, the
        /// LOA-CFA lists the provider name alongside your company name as the requester of the cross connect.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// <p>The standard media type for the LOA-CFA document. The only supported value is application/pdf.</p>
        pub fn loa_content_type(mut self, input: crate::model::LoaContentType) -> Self {
            self.loa_content_type = Some(input);
            self
        }
        /// <p>The standard media type for the LOA-CFA document. The only supported value is application/pdf.</p>
        pub fn set_loa_content_type(
            mut self,
            input: std::option::Option<crate::model::LoaContentType>,
        ) -> Self {
            self.loa_content_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLoaInput`](crate::input::DescribeLoaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeLoaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeLoaInput {
                connection_id: self.connection_id,
                provider_name: self.provider_name,
                loa_content_type: self.loa_content_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeLoaInputOperationOutputAlias = crate::operation::DescribeLoa;
#[doc(hidden)]
pub type DescribeLoaInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeLoaInput {
    /// Consumes the builder and constructs an Operation<[`DescribeLoa`](crate::operation::DescribeLoa)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeLoa,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeLoaInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeLoaInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeLoaInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.DescribeLoa",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_loa(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeLoa::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeLoa",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeLoaInput`](crate::input::DescribeLoaInput)
    pub fn builder() -> crate::input::describe_loa_input::Builder {
        crate::input::describe_loa_input::Builder::default()
    }
}

/// See [`DescribeLocationsInput`](crate::input::DescribeLocationsInput)
pub mod describe_locations_input {
    /// A builder for [`DescribeLocationsInput`](crate::input::DescribeLocationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeLocationsInput`](crate::input::DescribeLocationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeLocationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeLocationsInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeLocationsInputOperationOutputAlias = crate::operation::DescribeLocations;
#[doc(hidden)]
pub type DescribeLocationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeLocationsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeLocations`](crate::operation::DescribeLocations)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeLocations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeLocationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeLocationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeLocationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.DescribeLocations",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_locations(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeLocations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeLocations",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeLocationsInput`](crate::input::DescribeLocationsInput)
    pub fn builder() -> crate::input::describe_locations_input::Builder {
        crate::input::describe_locations_input::Builder::default()
    }
}

/// See [`DescribeTagsInput`](crate::input::DescribeTagsInput)
pub mod describe_tags_input {
    /// A builder for [`DescribeTagsInput`](crate::input::DescribeTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `resource_arns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_arns.unwrap_or_default();
            v.push(input.into());
            self.resource_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTagsInput`](crate::input::DescribeTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTagsInput {
                resource_arns: self.resource_arns,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTagsInputOperationOutputAlias = crate::operation::DescribeTags;
#[doc(hidden)]
pub type DescribeTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeTagsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTags`](crate::operation::DescribeTags)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.DescribeTags",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_tags(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTags",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTagsInput`](crate::input::DescribeTagsInput)
    pub fn builder() -> crate::input::describe_tags_input::Builder {
        crate::input::describe_tags_input::Builder::default()
    }
}

/// See [`DescribeVirtualGatewaysInput`](crate::input::DescribeVirtualGatewaysInput)
pub mod describe_virtual_gateways_input {
    /// A builder for [`DescribeVirtualGatewaysInput`](crate::input::DescribeVirtualGatewaysInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeVirtualGatewaysInput`](crate::input::DescribeVirtualGatewaysInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeVirtualGatewaysInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeVirtualGatewaysInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeVirtualGatewaysInputOperationOutputAlias =
    crate::operation::DescribeVirtualGateways;
#[doc(hidden)]
pub type DescribeVirtualGatewaysInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeVirtualGatewaysInput {
    /// Consumes the builder and constructs an Operation<[`DescribeVirtualGateways`](crate::operation::DescribeVirtualGateways)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeVirtualGateways,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeVirtualGatewaysInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeVirtualGatewaysInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeVirtualGatewaysInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.DescribeVirtualGateways",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_virtual_gateways(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeVirtualGateways::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeVirtualGateways",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeVirtualGatewaysInput`](crate::input::DescribeVirtualGatewaysInput)
    pub fn builder() -> crate::input::describe_virtual_gateways_input::Builder {
        crate::input::describe_virtual_gateways_input::Builder::default()
    }
}

/// See [`DescribeVirtualInterfacesInput`](crate::input::DescribeVirtualInterfacesInput)
pub mod describe_virtual_interfaces_input {
    /// A builder for [`DescribeVirtualInterfacesInput`](crate::input::DescribeVirtualInterfacesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) virtual_interface_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeVirtualInterfacesInput`](crate::input::DescribeVirtualInterfacesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeVirtualInterfacesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeVirtualInterfacesInput {
                connection_id: self.connection_id,
                virtual_interface_id: self.virtual_interface_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeVirtualInterfacesInputOperationOutputAlias =
    crate::operation::DescribeVirtualInterfaces;
#[doc(hidden)]
pub type DescribeVirtualInterfacesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeVirtualInterfacesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeVirtualInterfaces`](crate::operation::DescribeVirtualInterfaces)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeVirtualInterfaces,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeVirtualInterfacesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeVirtualInterfacesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeVirtualInterfacesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.DescribeVirtualInterfaces",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_virtual_interfaces(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeVirtualInterfaces::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeVirtualInterfaces",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeVirtualInterfacesInput`](crate::input::DescribeVirtualInterfacesInput)
    pub fn builder() -> crate::input::describe_virtual_interfaces_input::Builder {
        crate::input::describe_virtual_interfaces_input::Builder::default()
    }
}

/// See [`DisassociateConnectionFromLagInput`](crate::input::DisassociateConnectionFromLagInput)
pub mod disassociate_connection_from_lag_input {
    /// A builder for [`DisassociateConnectionFromLagInput`](crate::input::DisassociateConnectionFromLagInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) lag_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.lag_id = Some(input.into());
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lag_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateConnectionFromLagInput`](crate::input::DisassociateConnectionFromLagInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateConnectionFromLagInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateConnectionFromLagInput {
                connection_id: self.connection_id,
                lag_id: self.lag_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateConnectionFromLagInputOperationOutputAlias =
    crate::operation::DisassociateConnectionFromLag;
#[doc(hidden)]
pub type DisassociateConnectionFromLagInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateConnectionFromLagInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateConnectionFromLag`](crate::operation::DisassociateConnectionFromLag)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateConnectionFromLag,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateConnectionFromLagInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateConnectionFromLagInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateConnectionFromLagInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.DisassociateConnectionFromLag",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_connection_from_lag(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateConnectionFromLag::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateConnectionFromLag",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateConnectionFromLagInput`](crate::input::DisassociateConnectionFromLagInput)
    pub fn builder() -> crate::input::disassociate_connection_from_lag_input::Builder {
        crate::input::disassociate_connection_from_lag_input::Builder::default()
    }
}

/// See [`DisassociateMacSecKeyInput`](crate::input::DisassociateMacSecKeyInput)
pub mod disassociate_mac_sec_key_input {
    /// A builder for [`DisassociateMacSecKeyInput`](crate::input::DisassociateMacSecKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) secret_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).</p>
        /// <p>You can use <a>DescribeConnections</a> or <a>DescribeLags</a> to retrieve connection ID.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).</p>
        /// <p>You can use <a>DescribeConnections</a> or <a>DescribeLags</a> to retrieve connection ID.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key.</p>
        /// <p>You can use <a>DescribeConnections</a> to retrieve the ARN of the MAC Security (MACsec) secret key.</p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key.</p>
        /// <p>You can use <a>DescribeConnections</a> to retrieve the ARN of the MAC Security (MACsec) secret key.</p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateMacSecKeyInput`](crate::input::DisassociateMacSecKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateMacSecKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateMacSecKeyInput {
                connection_id: self.connection_id,
                secret_arn: self.secret_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateMacSecKeyInputOperationOutputAlias = crate::operation::DisassociateMacSecKey;
#[doc(hidden)]
pub type DisassociateMacSecKeyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateMacSecKeyInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateMacSecKey`](crate::operation::DisassociateMacSecKey)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateMacSecKey,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateMacSecKeyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateMacSecKeyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateMacSecKeyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.DisassociateMacSecKey",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_mac_sec_key(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateMacSecKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateMacSecKey",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateMacSecKeyInput`](crate::input::DisassociateMacSecKeyInput)
    pub fn builder() -> crate::input::disassociate_mac_sec_key_input::Builder {
        crate::input::disassociate_mac_sec_key_input::Builder::default()
    }
}

/// See [`ListVirtualInterfaceTestHistoryInput`](crate::input::ListVirtualInterfaceTestHistoryInput)
pub mod list_virtual_interface_test_history_input {
    /// A builder for [`ListVirtualInterfaceTestHistoryInput`](crate::input::ListVirtualInterfaceTestHistoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) test_id: std::option::Option<std::string::String>,
        pub(crate) virtual_interface_id: std::option::Option<std::string::String>,
        pub(crate) bgp_peers: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the virtual interface failover test.</p>
        pub fn test_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.test_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual interface failover test.</p>
        pub fn set_test_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.test_id = input;
            self
        }
        /// <p>The ID of the virtual interface that was tested.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual interface that was tested.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_id = input;
            self
        }
        /// Appends an item to `bgp_peers`.
        ///
        /// To override the contents of this collection use [`set_bgp_peers`](Self::set_bgp_peers).
        ///
        /// <p>The BGP peers that were placed in the DOWN state during the virtual interface failover test.</p>
        pub fn bgp_peers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.bgp_peers.unwrap_or_default();
            v.push(input.into());
            self.bgp_peers = Some(v);
            self
        }
        /// <p>The BGP peers that were placed in the DOWN state during the virtual interface failover test.</p>
        pub fn set_bgp_peers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.bgp_peers = input;
            self
        }
        /// <p>The status of the virtual interface failover test.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the virtual interface failover test.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are
        /// returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are
        /// returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListVirtualInterfaceTestHistoryInput`](crate::input::ListVirtualInterfaceTestHistoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListVirtualInterfaceTestHistoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListVirtualInterfaceTestHistoryInput {
                test_id: self.test_id,
                virtual_interface_id: self.virtual_interface_id,
                bgp_peers: self.bgp_peers,
                status: self.status,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListVirtualInterfaceTestHistoryInputOperationOutputAlias =
    crate::operation::ListVirtualInterfaceTestHistory;
#[doc(hidden)]
pub type ListVirtualInterfaceTestHistoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListVirtualInterfaceTestHistoryInput {
    /// Consumes the builder and constructs an Operation<[`ListVirtualInterfaceTestHistory`](crate::operation::ListVirtualInterfaceTestHistory)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListVirtualInterfaceTestHistory,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListVirtualInterfaceTestHistoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListVirtualInterfaceTestHistoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListVirtualInterfaceTestHistoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.ListVirtualInterfaceTestHistory",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_virtual_interface_test_history(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListVirtualInterfaceTestHistory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListVirtualInterfaceTestHistory",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListVirtualInterfaceTestHistoryInput`](crate::input::ListVirtualInterfaceTestHistoryInput)
    pub fn builder() -> crate::input::list_virtual_interface_test_history_input::Builder {
        crate::input::list_virtual_interface_test_history_input::Builder::default()
    }
}

/// See [`StartBgpFailoverTestInput`](crate::input::StartBgpFailoverTestInput)
pub mod start_bgp_failover_test_input {
    /// A builder for [`StartBgpFailoverTestInput`](crate::input::StartBgpFailoverTestInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_interface_id: std::option::Option<std::string::String>,
        pub(crate) bgp_peers: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) test_duration_in_minutes: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the virtual interface you want to test.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual interface you want to test.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_id = input;
            self
        }
        /// Appends an item to `bgp_peers`.
        ///
        /// To override the contents of this collection use [`set_bgp_peers`](Self::set_bgp_peers).
        ///
        /// <p>The BGP peers to place in the DOWN state.</p>
        pub fn bgp_peers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.bgp_peers.unwrap_or_default();
            v.push(input.into());
            self.bgp_peers = Some(v);
            self
        }
        /// <p>The BGP peers to place in the DOWN state.</p>
        pub fn set_bgp_peers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.bgp_peers = input;
            self
        }
        /// <p>The time in minutes that the virtual interface failover test will last.</p>
        /// <p>Maximum value: 180 minutes (3 hours).</p>
        /// <p>Default: 180 minutes (3 hours).</p>
        pub fn test_duration_in_minutes(mut self, input: i32) -> Self {
            self.test_duration_in_minutes = Some(input);
            self
        }
        /// <p>The time in minutes that the virtual interface failover test will last.</p>
        /// <p>Maximum value: 180 minutes (3 hours).</p>
        /// <p>Default: 180 minutes (3 hours).</p>
        pub fn set_test_duration_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.test_duration_in_minutes = input;
            self
        }
        /// Consumes the builder and constructs a [`StartBgpFailoverTestInput`](crate::input::StartBgpFailoverTestInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartBgpFailoverTestInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartBgpFailoverTestInput {
                virtual_interface_id: self.virtual_interface_id,
                bgp_peers: self.bgp_peers,
                test_duration_in_minutes: self.test_duration_in_minutes,
            })
        }
    }
}
#[doc(hidden)]
pub type StartBgpFailoverTestInputOperationOutputAlias = crate::operation::StartBgpFailoverTest;
#[doc(hidden)]
pub type StartBgpFailoverTestInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartBgpFailoverTestInput {
    /// Consumes the builder and constructs an Operation<[`StartBgpFailoverTest`](crate::operation::StartBgpFailoverTest)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartBgpFailoverTest,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartBgpFailoverTestInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartBgpFailoverTestInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartBgpFailoverTestInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.StartBgpFailoverTest",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_bgp_failover_test(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartBgpFailoverTest::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartBgpFailoverTest",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartBgpFailoverTestInput`](crate::input::StartBgpFailoverTestInput)
    pub fn builder() -> crate::input::start_bgp_failover_test_input::Builder {
        crate::input::start_bgp_failover_test_input::Builder::default()
    }
}

/// See [`StopBgpFailoverTestInput`](crate::input::StopBgpFailoverTestInput)
pub mod stop_bgp_failover_test_input {
    /// A builder for [`StopBgpFailoverTestInput`](crate::input::StopBgpFailoverTestInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_interface_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the virtual interface you no longer want to test.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual interface you no longer want to test.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopBgpFailoverTestInput`](crate::input::StopBgpFailoverTestInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopBgpFailoverTestInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopBgpFailoverTestInput {
                virtual_interface_id: self.virtual_interface_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StopBgpFailoverTestInputOperationOutputAlias = crate::operation::StopBgpFailoverTest;
#[doc(hidden)]
pub type StopBgpFailoverTestInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StopBgpFailoverTestInput {
    /// Consumes the builder and constructs an Operation<[`StopBgpFailoverTest`](crate::operation::StopBgpFailoverTest)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopBgpFailoverTest,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopBgpFailoverTestInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopBgpFailoverTestInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopBgpFailoverTestInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.StopBgpFailoverTest",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_stop_bgp_failover_test(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopBgpFailoverTest::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopBgpFailoverTest",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopBgpFailoverTestInput`](crate::input::StopBgpFailoverTestInput)
    pub fn builder() -> crate::input::stop_bgp_failover_test_input::Builder {
        crate::input::stop_bgp_failover_test_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to add.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys of the tags to remove.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The tag keys of the tags to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateConnectionInput`](crate::input::UpdateConnectionInput)
pub mod update_connection_input {
    /// A builder for [`UpdateConnectionInput`](crate::input::UpdateConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) connection_name: std::option::Option<std::string::String>,
        pub(crate) encryption_mode: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the dedicated connection.</p>
        /// <p>You can use <a>DescribeConnections</a> to retrieve the connection ID.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the dedicated connection.</p>
        /// <p>You can use <a>DescribeConnections</a> to retrieve the connection ID.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The name of the connection.</p>
        pub fn connection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_name = Some(input.into());
            self
        }
        /// <p>The name of the connection.</p>
        pub fn set_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_name = input;
            self
        }
        /// <p>The connection MAC Security (MACsec) encryption mode.</p>
        /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
        pub fn encryption_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_mode = Some(input.into());
            self
        }
        /// <p>The connection MAC Security (MACsec) encryption mode.</p>
        /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConnectionInput`](crate::input::UpdateConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateConnectionInput {
                connection_id: self.connection_id,
                connection_name: self.connection_name,
                encryption_mode: self.encryption_mode,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateConnectionInputOperationOutputAlias = crate::operation::UpdateConnection;
#[doc(hidden)]
pub type UpdateConnectionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateConnectionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateConnection`](crate::operation::UpdateConnection)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateConnection,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateConnectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateConnectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateConnectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.UpdateConnection",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_connection(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateConnection",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateConnectionInput`](crate::input::UpdateConnectionInput)
    pub fn builder() -> crate::input::update_connection_input::Builder {
        crate::input::update_connection_input::Builder::default()
    }
}

/// See [`UpdateDirectConnectGatewayAssociationInput`](crate::input::UpdateDirectConnectGatewayAssociationInput)
pub mod update_direct_connect_gateway_association_input {
    /// A builder for [`UpdateDirectConnectGatewayAssociationInput`](crate::input::UpdateDirectConnectGatewayAssociationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) association_id: std::option::Option<std::string::String>,
        pub(crate) add_allowed_prefixes_to_direct_connect_gateway:
            std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        pub(crate) remove_allowed_prefixes_to_direct_connect_gateway:
            std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
    }
    impl Builder {
        /// <p>The ID of the Direct Connect gateway association.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_id = Some(input.into());
            self
        }
        /// <p>The ID of the Direct Connect gateway association.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_id = input;
            self
        }
        /// Appends an item to `add_allowed_prefixes_to_direct_connect_gateway`.
        ///
        /// To override the contents of this collection use [`set_add_allowed_prefixes_to_direct_connect_gateway`](Self::set_add_allowed_prefixes_to_direct_connect_gateway).
        ///
        /// <p>The Amazon VPC prefixes to advertise to the Direct Connect gateway.</p>
        pub fn add_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: impl Into<crate::model::RouteFilterPrefix>,
        ) -> Self {
            let mut v = self
                .add_allowed_prefixes_to_direct_connect_gateway
                .unwrap_or_default();
            v.push(input.into());
            self.add_allowed_prefixes_to_direct_connect_gateway = Some(v);
            self
        }
        /// <p>The Amazon VPC prefixes to advertise to the Direct Connect gateway.</p>
        pub fn set_add_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        ) -> Self {
            self.add_allowed_prefixes_to_direct_connect_gateway = input;
            self
        }
        /// Appends an item to `remove_allowed_prefixes_to_direct_connect_gateway`.
        ///
        /// To override the contents of this collection use [`set_remove_allowed_prefixes_to_direct_connect_gateway`](Self::set_remove_allowed_prefixes_to_direct_connect_gateway).
        ///
        /// <p>The Amazon VPC prefixes to no longer advertise to the Direct Connect gateway.</p>
        pub fn remove_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: impl Into<crate::model::RouteFilterPrefix>,
        ) -> Self {
            let mut v = self
                .remove_allowed_prefixes_to_direct_connect_gateway
                .unwrap_or_default();
            v.push(input.into());
            self.remove_allowed_prefixes_to_direct_connect_gateway = Some(v);
            self
        }
        /// <p>The Amazon VPC prefixes to no longer advertise to the Direct Connect gateway.</p>
        pub fn set_remove_allowed_prefixes_to_direct_connect_gateway(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
        ) -> Self {
            self.remove_allowed_prefixes_to_direct_connect_gateway = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDirectConnectGatewayAssociationInput`](crate::input::UpdateDirectConnectGatewayAssociationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDirectConnectGatewayAssociationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDirectConnectGatewayAssociationInput {
                association_id: self.association_id,
                add_allowed_prefixes_to_direct_connect_gateway: self
                    .add_allowed_prefixes_to_direct_connect_gateway,
                remove_allowed_prefixes_to_direct_connect_gateway: self
                    .remove_allowed_prefixes_to_direct_connect_gateway,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDirectConnectGatewayAssociationInputOperationOutputAlias =
    crate::operation::UpdateDirectConnectGatewayAssociation;
#[doc(hidden)]
pub type UpdateDirectConnectGatewayAssociationInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl UpdateDirectConnectGatewayAssociationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDirectConnectGatewayAssociation`](crate::operation::UpdateDirectConnectGatewayAssociation)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDirectConnectGatewayAssociation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDirectConnectGatewayAssociationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDirectConnectGatewayAssociationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDirectConnectGatewayAssociationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.UpdateDirectConnectGatewayAssociation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_direct_connect_gateway_association(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDirectConnectGatewayAssociation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDirectConnectGatewayAssociation",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDirectConnectGatewayAssociationInput`](crate::input::UpdateDirectConnectGatewayAssociationInput)
    pub fn builder() -> crate::input::update_direct_connect_gateway_association_input::Builder {
        crate::input::update_direct_connect_gateway_association_input::Builder::default()
    }
}

/// See [`UpdateLagInput`](crate::input::UpdateLagInput)
pub mod update_lag_input {
    /// A builder for [`UpdateLagInput`](crate::input::UpdateLagInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lag_id: std::option::Option<std::string::String>,
        pub(crate) lag_name: std::option::Option<std::string::String>,
        pub(crate) minimum_links: std::option::Option<i32>,
        pub(crate) encryption_mode: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the LAG.</p>
        pub fn lag_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.lag_id = Some(input.into());
            self
        }
        /// <p>The ID of the LAG.</p>
        pub fn set_lag_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lag_id = input;
            self
        }
        /// <p>The name of the LAG.</p>
        pub fn lag_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.lag_name = Some(input.into());
            self
        }
        /// <p>The name of the LAG.</p>
        pub fn set_lag_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lag_name = input;
            self
        }
        /// <p>The minimum number of physical connections that must be operational for the LAG itself to be operational.</p>
        pub fn minimum_links(mut self, input: i32) -> Self {
            self.minimum_links = Some(input);
            self
        }
        /// <p>The minimum number of physical connections that must be operational for the LAG itself to be operational.</p>
        pub fn set_minimum_links(mut self, input: std::option::Option<i32>) -> Self {
            self.minimum_links = input;
            self
        }
        /// <p>The LAG MAC Security (MACsec) encryption mode.</p>
        /// <p>Amazon Web Services applies the value to all connections which are part of the LAG.</p>
        pub fn encryption_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_mode = Some(input.into());
            self
        }
        /// <p>The LAG MAC Security (MACsec) encryption mode.</p>
        /// <p>Amazon Web Services applies the value to all connections which are part of the LAG.</p>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateLagInput`](crate::input::UpdateLagInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::UpdateLagInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::UpdateLagInput {
                lag_id: self.lag_id,
                lag_name: self.lag_name,
                minimum_links: self.minimum_links.unwrap_or_default(),
                encryption_mode: self.encryption_mode,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateLagInputOperationOutputAlias = crate::operation::UpdateLag;
#[doc(hidden)]
pub type UpdateLagInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateLagInput {
    /// Consumes the builder and constructs an Operation<[`UpdateLag`](crate::operation::UpdateLag)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateLag,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateLagInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateLagInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateLagInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.UpdateLag",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_lag(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::UpdateLag::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "UpdateLag",
                    "directconnect",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateLagInput`](crate::input::UpdateLagInput)
    pub fn builder() -> crate::input::update_lag_input::Builder {
        crate::input::update_lag_input::Builder::default()
    }
}

/// See [`UpdateVirtualInterfaceAttributesInput`](crate::input::UpdateVirtualInterfaceAttributesInput)
pub mod update_virtual_interface_attributes_input {
    /// A builder for [`UpdateVirtualInterfaceAttributesInput`](crate::input::UpdateVirtualInterfaceAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_interface_id: std::option::Option<std::string::String>,
        pub(crate) mtu: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the virtual private interface.</p>
        pub fn virtual_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual private interface.</p>
        pub fn set_virtual_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_interface_id = input;
            self
        }
        /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
        pub fn mtu(mut self, input: i32) -> Self {
            self.mtu = Some(input);
            self
        }
        /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
        pub fn set_mtu(mut self, input: std::option::Option<i32>) -> Self {
            self.mtu = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateVirtualInterfaceAttributesInput`](crate::input::UpdateVirtualInterfaceAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateVirtualInterfaceAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateVirtualInterfaceAttributesInput {
                virtual_interface_id: self.virtual_interface_id,
                mtu: self.mtu,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateVirtualInterfaceAttributesInputOperationOutputAlias =
    crate::operation::UpdateVirtualInterfaceAttributes;
#[doc(hidden)]
pub type UpdateVirtualInterfaceAttributesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateVirtualInterfaceAttributesInput {
    /// Consumes the builder and constructs an Operation<[`UpdateVirtualInterfaceAttributes`](crate::operation::UpdateVirtualInterfaceAttributes)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateVirtualInterfaceAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateVirtualInterfaceAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateVirtualInterfaceAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateVirtualInterfaceAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "OvertureService.UpdateVirtualInterfaceAttributes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_virtual_interface_attributes(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateVirtualInterfaceAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateVirtualInterfaceAttributes",
            "directconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateVirtualInterfaceAttributesInput`](crate::input::UpdateVirtualInterfaceAttributesInput)
    pub fn builder() -> crate::input::update_virtual_interface_attributes_input::Builder {
        crate::input::update_virtual_interface_attributes_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateVirtualInterfaceAttributesInput {
    /// <p>The ID of the virtual private interface.</p>
    pub virtual_interface_id: std::option::Option<std::string::String>,
    /// <p>The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.</p>
    pub mtu: std::option::Option<i32>,
}
impl std::fmt::Debug for UpdateVirtualInterfaceAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateVirtualInterfaceAttributesInput");
        formatter.field("virtual_interface_id", &self.virtual_interface_id);
        formatter.field("mtu", &self.mtu);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLagInput {
    /// <p>The ID of the LAG.</p>
    pub lag_id: std::option::Option<std::string::String>,
    /// <p>The name of the LAG.</p>
    pub lag_name: std::option::Option<std::string::String>,
    /// <p>The minimum number of physical connections that must be operational for the LAG itself to be operational.</p>
    pub minimum_links: i32,
    /// <p>The LAG MAC Security (MACsec) encryption mode.</p>
    /// <p>Amazon Web Services applies the value to all connections which are part of the LAG.</p>
    pub encryption_mode: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateLagInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLagInput");
        formatter.field("lag_id", &self.lag_id);
        formatter.field("lag_name", &self.lag_name);
        formatter.field("minimum_links", &self.minimum_links);
        formatter.field("encryption_mode", &self.encryption_mode);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDirectConnectGatewayAssociationInput {
    /// <p>The ID of the Direct Connect gateway association.</p>
    pub association_id: std::option::Option<std::string::String>,
    /// <p>The Amazon VPC prefixes to advertise to the Direct Connect gateway.</p>
    pub add_allowed_prefixes_to_direct_connect_gateway:
        std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
    /// <p>The Amazon VPC prefixes to no longer advertise to the Direct Connect gateway.</p>
    pub remove_allowed_prefixes_to_direct_connect_gateway:
        std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
}
impl std::fmt::Debug for UpdateDirectConnectGatewayAssociationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDirectConnectGatewayAssociationInput");
        formatter.field("association_id", &self.association_id);
        formatter.field(
            "add_allowed_prefixes_to_direct_connect_gateway",
            &self.add_allowed_prefixes_to_direct_connect_gateway,
        );
        formatter.field(
            "remove_allowed_prefixes_to_direct_connect_gateway",
            &self.remove_allowed_prefixes_to_direct_connect_gateway,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConnectionInput {
    /// <p>The ID of the dedicated connection.</p>
    /// <p>You can use <a>DescribeConnections</a> to retrieve the connection ID.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The name of the connection.</p>
    pub connection_name: std::option::Option<std::string::String>,
    /// <p>The connection MAC Security (MACsec) encryption mode.</p>
    /// <p>The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.</p>
    pub encryption_mode: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConnectionInput");
        formatter.field("connection_id", &self.connection_id);
        formatter.field("connection_name", &self.connection_name);
        formatter.field("encryption_mode", &self.encryption_mode);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tag keys of the tags to remove.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags to add.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopBgpFailoverTestInput {
    /// <p>The ID of the virtual interface you no longer want to test.</p>
    pub virtual_interface_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StopBgpFailoverTestInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopBgpFailoverTestInput");
        formatter.field("virtual_interface_id", &self.virtual_interface_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartBgpFailoverTestInput {
    /// <p>The ID of the virtual interface you want to test.</p>
    pub virtual_interface_id: std::option::Option<std::string::String>,
    /// <p>The BGP peers to place in the DOWN state.</p>
    pub bgp_peers: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The time in minutes that the virtual interface failover test will last.</p>
    /// <p>Maximum value: 180 minutes (3 hours).</p>
    /// <p>Default: 180 minutes (3 hours).</p>
    pub test_duration_in_minutes: std::option::Option<i32>,
}
impl std::fmt::Debug for StartBgpFailoverTestInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartBgpFailoverTestInput");
        formatter.field("virtual_interface_id", &self.virtual_interface_id);
        formatter.field("bgp_peers", &self.bgp_peers);
        formatter.field("test_duration_in_minutes", &self.test_duration_in_minutes);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListVirtualInterfaceTestHistoryInput {
    /// <p>The ID of the virtual interface failover test.</p>
    pub test_id: std::option::Option<std::string::String>,
    /// <p>The ID of the virtual interface that was tested.</p>
    pub virtual_interface_id: std::option::Option<std::string::String>,
    /// <p>The BGP peers that were placed in the DOWN state during the virtual interface failover test.</p>
    pub bgp_peers: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The status of the virtual interface failover test.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with a single call.
    /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are
    /// returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListVirtualInterfaceTestHistoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListVirtualInterfaceTestHistoryInput");
        formatter.field("test_id", &self.test_id);
        formatter.field("virtual_interface_id", &self.virtual_interface_id);
        formatter.field("bgp_peers", &self.bgp_peers);
        formatter.field("status", &self.status);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateMacSecKeyInput {
    /// <p>The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).</p>
    /// <p>You can use <a>DescribeConnections</a> or <a>DescribeLags</a> to retrieve connection ID.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key.</p>
    /// <p>You can use <a>DescribeConnections</a> to retrieve the ARN of the MAC Security (MACsec) secret key.</p>
    pub secret_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DisassociateMacSecKeyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateMacSecKeyInput");
        formatter.field("connection_id", &self.connection_id);
        formatter.field("secret_arn", &self.secret_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateConnectionFromLagInput {
    /// <p>The ID of the connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The ID of the LAG.</p>
    pub lag_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DisassociateConnectionFromLagInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateConnectionFromLagInput");
        formatter.field("connection_id", &self.connection_id);
        formatter.field("lag_id", &self.lag_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeVirtualInterfacesInput {
    /// <p>The ID of the connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The ID of the virtual interface.</p>
    pub virtual_interface_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeVirtualInterfacesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeVirtualInterfacesInput");
        formatter.field("connection_id", &self.connection_id);
        formatter.field("virtual_interface_id", &self.virtual_interface_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeVirtualGatewaysInput {}
impl std::fmt::Debug for DescribeVirtualGatewaysInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeVirtualGatewaysInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTagsInput {
    /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
    pub resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for DescribeTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTagsInput");
        formatter.field("resource_arns", &self.resource_arns);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLocationsInput {}
impl std::fmt::Debug for DescribeLocationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLocationsInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLoaInput {
    /// <p>The ID of a connection, LAG, or interconnect.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The name of the service provider who establishes connectivity on your behalf. If you specify this parameter, the
    /// LOA-CFA lists the provider name alongside your company name as the requester of the cross connect.</p>
    pub provider_name: std::option::Option<std::string::String>,
    /// <p>The standard media type for the LOA-CFA document. The only supported value is application/pdf.</p>
    pub loa_content_type: std::option::Option<crate::model::LoaContentType>,
}
impl std::fmt::Debug for DescribeLoaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLoaInput");
        formatter.field("connection_id", &self.connection_id);
        formatter.field("provider_name", &self.provider_name);
        formatter.field("loa_content_type", &self.loa_content_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLagsInput {
    /// <p>The ID of the LAG.</p>
    pub lag_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeLagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLagsInput");
        formatter.field("lag_id", &self.lag_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInterconnectsInput {
    /// <p>The ID of the interconnect.</p>
    pub interconnect_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeInterconnectsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInterconnectsInput");
        formatter.field("interconnect_id", &self.interconnect_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInterconnectLoaInput {
    /// <p>The ID of the interconnect.</p>
    pub interconnect_id: std::option::Option<std::string::String>,
    /// <p>The name of the service provider who establishes connectivity on your behalf. If you supply this parameter, the LOA-CFA lists the provider name alongside your company name as the requester of the cross connect.</p>
    pub provider_name: std::option::Option<std::string::String>,
    /// <p>The standard media type for the LOA-CFA document. The only supported value is application/pdf.</p>
    pub loa_content_type: std::option::Option<crate::model::LoaContentType>,
}
impl std::fmt::Debug for DescribeInterconnectLoaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInterconnectLoaInput");
        formatter.field("interconnect_id", &self.interconnect_id);
        formatter.field("provider_name", &self.provider_name);
        formatter.field("loa_content_type", &self.loa_content_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeHostedConnectionsInput {
    /// <p>The ID of the interconnect or LAG.</p>
    pub connection_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeHostedConnectionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeHostedConnectionsInput");
        formatter.field("connection_id", &self.connection_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDirectConnectGatewaysInput {
    /// <p>The ID of the Direct Connect gateway.</p>
    pub direct_connect_gateway_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with a single call.
    /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are
    /// returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token provided in the previous call to retrieve the next page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeDirectConnectGatewaysInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDirectConnectGatewaysInput");
        formatter.field("direct_connect_gateway_id", &self.direct_connect_gateway_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDirectConnectGatewayAttachmentsInput {
    /// <p>The ID of the Direct Connect gateway.</p>
    pub direct_connect_gateway_id: std::option::Option<std::string::String>,
    /// <p>The ID of the virtual interface.</p>
    pub virtual_interface_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with a single call.
    /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are
    /// returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token provided in the previous call to retrieve the next page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeDirectConnectGatewayAttachmentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDirectConnectGatewayAttachmentsInput");
        formatter.field("direct_connect_gateway_id", &self.direct_connect_gateway_id);
        formatter.field("virtual_interface_id", &self.virtual_interface_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDirectConnectGatewayAssociationsInput {
    /// <p>The ID of the Direct Connect gateway association.</p>
    pub association_id: std::option::Option<std::string::String>,
    /// <p>The ID of the associated gateway.</p>
    pub associated_gateway_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Direct Connect gateway.</p>
    pub direct_connect_gateway_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with a single call.
    /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are
    /// returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token provided in the previous call to retrieve the next page.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The ID of the virtual private gateway or transit gateway.</p>
    pub virtual_gateway_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeDirectConnectGatewayAssociationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDirectConnectGatewayAssociationsInput");
        formatter.field("association_id", &self.association_id);
        formatter.field("associated_gateway_id", &self.associated_gateway_id);
        formatter.field("direct_connect_gateway_id", &self.direct_connect_gateway_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("virtual_gateway_id", &self.virtual_gateway_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDirectConnectGatewayAssociationProposalsInput {
    /// <p>The ID of the Direct Connect gateway.</p>
    pub direct_connect_gateway_id: std::option::Option<std::string::String>,
    /// <p>The ID of the proposal.</p>
    pub proposal_id: std::option::Option<std::string::String>,
    /// <p>The ID of the associated gateway.</p>
    pub associated_gateway_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with a single call.
    /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    /// <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are
    /// returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeDirectConnectGatewayAssociationProposalsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDirectConnectGatewayAssociationProposalsInput");
        formatter.field("direct_connect_gateway_id", &self.direct_connect_gateway_id);
        formatter.field("proposal_id", &self.proposal_id);
        formatter.field("associated_gateway_id", &self.associated_gateway_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConnectionsOnInterconnectInput {
    /// <p>The ID of the interconnect.</p>
    pub interconnect_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeConnectionsOnInterconnectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConnectionsOnInterconnectInput");
        formatter.field("interconnect_id", &self.interconnect_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConnectionsInput {
    /// <p>The ID of the connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeConnectionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConnectionsInput");
        formatter.field("connection_id", &self.connection_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConnectionLoaInput {
    /// <p>The ID of the connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The name of the APN partner or service provider who establishes connectivity on your behalf. If you specify this parameter,
    /// the LOA-CFA lists the provider name alongside your company name as the requester of the cross connect.</p>
    pub provider_name: std::option::Option<std::string::String>,
    /// <p>The standard media type for the LOA-CFA document. The only supported value is application/pdf.</p>
    pub loa_content_type: std::option::Option<crate::model::LoaContentType>,
}
impl std::fmt::Debug for DescribeConnectionLoaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConnectionLoaInput");
        formatter.field("connection_id", &self.connection_id);
        formatter.field("provider_name", &self.provider_name);
        formatter.field("loa_content_type", &self.loa_content_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVirtualInterfaceInput {
    /// <p>The ID of the virtual interface.</p>
    pub virtual_interface_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteVirtualInterfaceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVirtualInterfaceInput");
        formatter.field("virtual_interface_id", &self.virtual_interface_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLagInput {
    /// <p>The ID of the LAG.</p>
    pub lag_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteLagInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLagInput");
        formatter.field("lag_id", &self.lag_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteInterconnectInput {
    /// <p>The ID of the interconnect.</p>
    pub interconnect_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteInterconnectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteInterconnectInput");
        formatter.field("interconnect_id", &self.interconnect_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDirectConnectGatewayAssociationProposalInput {
    /// <p>The ID of the proposal.</p>
    pub proposal_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteDirectConnectGatewayAssociationProposalInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDirectConnectGatewayAssociationProposalInput");
        formatter.field("proposal_id", &self.proposal_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDirectConnectGatewayAssociationInput {
    /// <p>The ID of the Direct Connect gateway association.</p>
    pub association_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Direct Connect gateway.</p>
    pub direct_connect_gateway_id: std::option::Option<std::string::String>,
    /// <p>The ID of the virtual private gateway.</p>
    pub virtual_gateway_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteDirectConnectGatewayAssociationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDirectConnectGatewayAssociationInput");
        formatter.field("association_id", &self.association_id);
        formatter.field("direct_connect_gateway_id", &self.direct_connect_gateway_id);
        formatter.field("virtual_gateway_id", &self.virtual_gateway_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDirectConnectGatewayInput {
    /// <p>The ID of the Direct Connect gateway.</p>
    pub direct_connect_gateway_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteDirectConnectGatewayInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDirectConnectGatewayInput");
        formatter.field("direct_connect_gateway_id", &self.direct_connect_gateway_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConnectionInput {
    /// <p>The ID of the connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConnectionInput");
        formatter.field("connection_id", &self.connection_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBgpPeerInput {
    /// <p>The ID of the virtual interface.</p>
    pub virtual_interface_id: std::option::Option<std::string::String>,
    /// <p>The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
    pub asn: i32,
    /// <p>The IP address assigned to the customer interface.</p>
    pub customer_address: std::option::Option<std::string::String>,
    /// <p>The ID of the BGP peer.</p>
    pub bgp_peer_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteBgpPeerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBgpPeerInput");
        formatter.field("virtual_interface_id", &self.virtual_interface_id);
        formatter.field("asn", &self.asn);
        formatter.field("customer_address", &self.customer_address);
        formatter.field("bgp_peer_id", &self.bgp_peer_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTransitVirtualInterfaceInput {
    /// <p>The ID of the connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>Information about the transit virtual interface.</p>
    pub new_transit_virtual_interface:
        std::option::Option<crate::model::NewTransitVirtualInterface>,
}
impl std::fmt::Debug for CreateTransitVirtualInterfaceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTransitVirtualInterfaceInput");
        formatter.field("connection_id", &self.connection_id);
        formatter.field(
            "new_transit_virtual_interface",
            &self.new_transit_virtual_interface,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePublicVirtualInterfaceInput {
    /// <p>The ID of the connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>Information about the public virtual interface.</p>
    pub new_public_virtual_interface: std::option::Option<crate::model::NewPublicVirtualInterface>,
}
impl std::fmt::Debug for CreatePublicVirtualInterfaceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePublicVirtualInterfaceInput");
        formatter.field("connection_id", &self.connection_id);
        formatter.field(
            "new_public_virtual_interface",
            &self.new_public_virtual_interface,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePrivateVirtualInterfaceInput {
    /// <p>The ID of the connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>Information about the private virtual interface.</p>
    pub new_private_virtual_interface:
        std::option::Option<crate::model::NewPrivateVirtualInterface>,
}
impl std::fmt::Debug for CreatePrivateVirtualInterfaceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePrivateVirtualInterfaceInput");
        formatter.field("connection_id", &self.connection_id);
        formatter.field(
            "new_private_virtual_interface",
            &self.new_private_virtual_interface,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLagInput {
    /// <p>The number of physical dedicated connections initially provisioned and bundled by the
    /// LAG.</p>
    pub number_of_connections: i32,
    /// <p>The location for the LAG.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The bandwidth of the individual physical dedicated connections bundled by the LAG. The
    /// possible values are 1Gbps and 10Gbps. </p>
    pub connections_bandwidth: std::option::Option<std::string::String>,
    /// <p>The name of the LAG.</p>
    pub lag_name: std::option::Option<std::string::String>,
    /// <p>The ID of an existing dedicated connection to migrate to the LAG.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The tags to associate with the LAG.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The tags to associate with the automtically created LAGs.</p>
    pub child_connection_tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The name of the service provider associated with the LAG.</p>
    pub provider_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether the connection will support MAC Security (MACsec).</p>
    /// <note>
    /// <p>All connections in the LAG must be capable of  supporting MAC Security (MACsec). For information about MAC Security (MACsec) prerequisties, see  <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites">MACsec prerequisties</a> in the <i>Direct Connect User Guide</i>.</p>
    /// </note>
    pub request_mac_sec: std::option::Option<bool>,
}
impl std::fmt::Debug for CreateLagInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLagInput");
        formatter.field("number_of_connections", &self.number_of_connections);
        formatter.field("location", &self.location);
        formatter.field("connections_bandwidth", &self.connections_bandwidth);
        formatter.field("lag_name", &self.lag_name);
        formatter.field("connection_id", &self.connection_id);
        formatter.field("tags", &self.tags);
        formatter.field("child_connection_tags", &self.child_connection_tags);
        formatter.field("provider_name", &self.provider_name);
        formatter.field("request_mac_sec", &self.request_mac_sec);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateInterconnectInput {
    /// <p>The name of the interconnect.</p>
    pub interconnect_name: std::option::Option<std::string::String>,
    /// <p>The port bandwidth, in Gbps. The possible values are 1 and 10.</p>
    pub bandwidth: std::option::Option<std::string::String>,
    /// <p>The location of the interconnect.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The ID of the LAG.</p>
    pub lag_id: std::option::Option<std::string::String>,
    /// <p>The tags to associate with the interconnect.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The name of the service provider associated with the interconnect.</p>
    pub provider_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateInterconnectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateInterconnectInput");
        formatter.field("interconnect_name", &self.interconnect_name);
        formatter.field("bandwidth", &self.bandwidth);
        formatter.field("location", &self.location);
        formatter.field("lag_id", &self.lag_id);
        formatter.field("tags", &self.tags);
        formatter.field("provider_name", &self.provider_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDirectConnectGatewayAssociationProposalInput {
    /// <p>The ID of the Direct Connect gateway.</p>
    pub direct_connect_gateway_id: std::option::Option<std::string::String>,
    /// <p>The ID of the account that owns the Direct Connect gateway.</p>
    pub direct_connect_gateway_owner_account: std::option::Option<std::string::String>,
    /// <p>The ID of the virtual private gateway or transit gateway.</p>
    pub gateway_id: std::option::Option<std::string::String>,
    /// <p>The Amazon VPC prefixes to advertise to the Direct Connect gateway.</p>
    pub add_allowed_prefixes_to_direct_connect_gateway:
        std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
    /// <p>The Amazon VPC prefixes to no longer advertise to the Direct Connect gateway.</p>
    pub remove_allowed_prefixes_to_direct_connect_gateway:
        std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
}
impl std::fmt::Debug for CreateDirectConnectGatewayAssociationProposalInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDirectConnectGatewayAssociationProposalInput");
        formatter.field("direct_connect_gateway_id", &self.direct_connect_gateway_id);
        formatter.field(
            "direct_connect_gateway_owner_account",
            &self.direct_connect_gateway_owner_account,
        );
        formatter.field("gateway_id", &self.gateway_id);
        formatter.field(
            "add_allowed_prefixes_to_direct_connect_gateway",
            &self.add_allowed_prefixes_to_direct_connect_gateway,
        );
        formatter.field(
            "remove_allowed_prefixes_to_direct_connect_gateway",
            &self.remove_allowed_prefixes_to_direct_connect_gateway,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDirectConnectGatewayAssociationInput {
    /// <p>The ID of the Direct Connect gateway.</p>
    pub direct_connect_gateway_id: std::option::Option<std::string::String>,
    /// <p>The ID of the virtual private gateway or transit gateway.</p>
    pub gateway_id: std::option::Option<std::string::String>,
    /// <p>The Amazon VPC prefixes to advertise to the Direct Connect gateway</p>
    /// <p>This parameter is required when you create an association to a transit gateway.</p>
    /// <p>For information about how to set the prefixes, see <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes">Allowed Prefixes</a> in the <i>Direct Connect User Guide</i>.</p>
    pub add_allowed_prefixes_to_direct_connect_gateway:
        std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
    /// <p>The ID of the virtual private gateway.</p>
    pub virtual_gateway_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateDirectConnectGatewayAssociationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDirectConnectGatewayAssociationInput");
        formatter.field("direct_connect_gateway_id", &self.direct_connect_gateway_id);
        formatter.field("gateway_id", &self.gateway_id);
        formatter.field(
            "add_allowed_prefixes_to_direct_connect_gateway",
            &self.add_allowed_prefixes_to_direct_connect_gateway,
        );
        formatter.field("virtual_gateway_id", &self.virtual_gateway_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDirectConnectGatewayInput {
    /// <p>The name of the Direct Connect gateway.</p>
    pub direct_connect_gateway_name: std::option::Option<std::string::String>,
    /// <p>The autonomous system number (ASN) for Border Gateway Protocol (BGP) to be configured
    /// on the Amazon side of the connection. The ASN must be in the private range of 64,512 to
    /// 65,534 or 4,200,000,000 to 4,294,967,294. The default is 64512.</p>
    pub amazon_side_asn: std::option::Option<i64>,
}
impl std::fmt::Debug for CreateDirectConnectGatewayInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDirectConnectGatewayInput");
        formatter.field(
            "direct_connect_gateway_name",
            &self.direct_connect_gateway_name,
        );
        formatter.field("amazon_side_asn", &self.amazon_side_asn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConnectionInput {
    /// <p>The location of the connection.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The bandwidth of the connection.</p>
    pub bandwidth: std::option::Option<std::string::String>,
    /// <p>The name of the connection.</p>
    pub connection_name: std::option::Option<std::string::String>,
    /// <p>The ID of the LAG.</p>
    pub lag_id: std::option::Option<std::string::String>,
    /// <p>The tags to associate with the lag.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The name of the service provider associated with the requested connection.</p>
    pub provider_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether you want the connection to support MAC Security (MACsec).</p>
    /// <p>MAC Security (MACsec) is only available on dedicated connections. For information about MAC Security (MACsec) prerequisties, see  <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites">MACsec prerequisties</a> in the <i>Direct Connect User Guide</i>.</p>
    pub request_mac_sec: std::option::Option<bool>,
}
impl std::fmt::Debug for CreateConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConnectionInput");
        formatter.field("location", &self.location);
        formatter.field("bandwidth", &self.bandwidth);
        formatter.field("connection_name", &self.connection_name);
        formatter.field("lag_id", &self.lag_id);
        formatter.field("tags", &self.tags);
        formatter.field("provider_name", &self.provider_name);
        formatter.field("request_mac_sec", &self.request_mac_sec);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBgpPeerInput {
    /// <p>The ID of the virtual interface.</p>
    pub virtual_interface_id: std::option::Option<std::string::String>,
    /// <p>Information about the BGP peer.</p>
    pub new_bgp_peer: std::option::Option<crate::model::NewBgpPeer>,
}
impl std::fmt::Debug for CreateBgpPeerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBgpPeerInput");
        formatter.field("virtual_interface_id", &self.virtual_interface_id);
        formatter.field("new_bgp_peer", &self.new_bgp_peer);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfirmTransitVirtualInterfaceInput {
    /// <p>The ID of the virtual interface.</p>
    pub virtual_interface_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Direct Connect gateway.</p>
    pub direct_connect_gateway_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConfirmTransitVirtualInterfaceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfirmTransitVirtualInterfaceInput");
        formatter.field("virtual_interface_id", &self.virtual_interface_id);
        formatter.field("direct_connect_gateway_id", &self.direct_connect_gateway_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfirmPublicVirtualInterfaceInput {
    /// <p>The ID of the virtual interface.</p>
    pub virtual_interface_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConfirmPublicVirtualInterfaceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfirmPublicVirtualInterfaceInput");
        formatter.field("virtual_interface_id", &self.virtual_interface_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfirmPrivateVirtualInterfaceInput {
    /// <p>The ID of the virtual interface.</p>
    pub virtual_interface_id: std::option::Option<std::string::String>,
    /// <p>The ID of the virtual private gateway.</p>
    pub virtual_gateway_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Direct Connect gateway.</p>
    pub direct_connect_gateway_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConfirmPrivateVirtualInterfaceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfirmPrivateVirtualInterfaceInput");
        formatter.field("virtual_interface_id", &self.virtual_interface_id);
        formatter.field("virtual_gateway_id", &self.virtual_gateway_id);
        formatter.field("direct_connect_gateway_id", &self.direct_connect_gateway_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfirmConnectionInput {
    /// <p>The ID of the hosted connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConfirmConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfirmConnectionInput");
        formatter.field("connection_id", &self.connection_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateVirtualInterfaceInput {
    /// <p>The ID of the virtual interface.</p>
    pub virtual_interface_id: std::option::Option<std::string::String>,
    /// <p>The ID of the LAG or connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AssociateVirtualInterfaceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateVirtualInterfaceInput");
        formatter.field("virtual_interface_id", &self.virtual_interface_id);
        formatter.field("connection_id", &self.connection_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateMacSecKeyInput {
    /// <p>The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).</p>
    /// <p>You can use <a>DescribeConnections</a> or <a>DescribeLags</a> to retrieve connection ID.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key to associate with the dedicated connection.</p>
    /// <p>You can use <a>DescribeConnections</a> or <a>DescribeLags</a> to retrieve the MAC Security (MACsec) secret key.</p>
    /// <p>If you use this request parameter, you do not use the <code>ckn</code> and <code>cak</code> request parameters.</p>
    pub secret_arn: std::option::Option<std::string::String>,
    /// <p>The MAC Security (MACsec) CKN to associate with the dedicated connection.</p>
    /// <p>You can create the CKN/CAK pair using an industry standard tool.</p>
    /// <p> The valid values are 64 hexadecimal characters (0-9, A-E).</p>
    /// <p>If you use this request parameter, you must use the <code>cak</code> request parameter and not use the <code>secretARN</code> request parameter.</p>
    pub ckn: std::option::Option<std::string::String>,
    /// <p>The MAC Security (MACsec) CAK to associate with the dedicated connection.</p>
    /// <p>You can create the CKN/CAK pair using an industry standard tool.</p>
    /// <p> The valid values are 64 hexadecimal characters (0-9, A-E).</p>
    /// <p>If you use this request parameter, you must use the <code>ckn</code> request parameter and not use the <code>secretARN</code> request parameter.</p>
    pub cak: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AssociateMacSecKeyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateMacSecKeyInput");
        formatter.field("connection_id", &self.connection_id);
        formatter.field("secret_arn", &self.secret_arn);
        formatter.field("ckn", &self.ckn);
        formatter.field("cak", &self.cak);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateHostedConnectionInput {
    /// <p>The ID of the hosted connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The ID of the interconnect or the LAG.</p>
    pub parent_connection_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AssociateHostedConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateHostedConnectionInput");
        formatter.field("connection_id", &self.connection_id);
        formatter.field("parent_connection_id", &self.parent_connection_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateConnectionWithLagInput {
    /// <p>The ID of the connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The ID of the LAG with which to associate the connection.</p>
    pub lag_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AssociateConnectionWithLagInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateConnectionWithLagInput");
        formatter.field("connection_id", &self.connection_id);
        formatter.field("lag_id", &self.lag_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AllocateTransitVirtualInterfaceInput {
    /// <p>The ID of the connection on which the transit virtual interface is provisioned.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The ID of the account that owns the transit virtual interface.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>Information about the transit virtual interface.</p>
    pub new_transit_virtual_interface_allocation:
        std::option::Option<crate::model::NewTransitVirtualInterfaceAllocation>,
}
impl std::fmt::Debug for AllocateTransitVirtualInterfaceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AllocateTransitVirtualInterfaceInput");
        formatter.field("connection_id", &self.connection_id);
        formatter.field("owner_account", &self.owner_account);
        formatter.field(
            "new_transit_virtual_interface_allocation",
            &self.new_transit_virtual_interface_allocation,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AllocatePublicVirtualInterfaceInput {
    /// <p>The ID of the connection on which the public virtual interface is provisioned.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The ID of the account that owns the public virtual interface.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>Information about the public virtual interface.</p>
    pub new_public_virtual_interface_allocation:
        std::option::Option<crate::model::NewPublicVirtualInterfaceAllocation>,
}
impl std::fmt::Debug for AllocatePublicVirtualInterfaceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AllocatePublicVirtualInterfaceInput");
        formatter.field("connection_id", &self.connection_id);
        formatter.field("owner_account", &self.owner_account);
        formatter.field(
            "new_public_virtual_interface_allocation",
            &self.new_public_virtual_interface_allocation,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AllocatePrivateVirtualInterfaceInput {
    /// <p>The ID of the connection on which the private virtual interface is provisioned.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The ID of the account that owns the virtual private interface.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>Information about the private virtual interface.</p>
    pub new_private_virtual_interface_allocation:
        std::option::Option<crate::model::NewPrivateVirtualInterfaceAllocation>,
}
impl std::fmt::Debug for AllocatePrivateVirtualInterfaceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AllocatePrivateVirtualInterfaceInput");
        formatter.field("connection_id", &self.connection_id);
        formatter.field("owner_account", &self.owner_account);
        formatter.field(
            "new_private_virtual_interface_allocation",
            &self.new_private_virtual_interface_allocation,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AllocateHostedConnectionInput {
    /// <p>The ID of the interconnect or LAG.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The ID of the account ID of the customer for the connection.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>The bandwidth of the connection. The possible values are 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, and 10Gbps. Note that only those Direct Connect Partners who have met specific requirements are allowed to create a 1Gbps, 2Gbps, 5Gbps or 10Gbps hosted connection. </p>
    pub bandwidth: std::option::Option<std::string::String>,
    /// <p>The name of the hosted connection.</p>
    pub connection_name: std::option::Option<std::string::String>,
    /// <p>The dedicated VLAN provisioned to the hosted connection.</p>
    pub vlan: i32,
    /// <p>The tags associated with the connection.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for AllocateHostedConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AllocateHostedConnectionInput");
        formatter.field("connection_id", &self.connection_id);
        formatter.field("owner_account", &self.owner_account);
        formatter.field("bandwidth", &self.bandwidth);
        formatter.field("connection_name", &self.connection_name);
        formatter.field("vlan", &self.vlan);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AllocateConnectionOnInterconnectInput {
    /// <p>The bandwidth of the connection. The possible values are 50Mbps, 100Mbps, 200Mbps,
    /// 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, and 10Gbps. Note that only those Direct Connect Partners
    /// who have met specific requirements
    /// are allowed to create a 1Gbps, 2Gbps, 5Gbps or 10Gbps hosted connection.</p>
    pub bandwidth: std::option::Option<std::string::String>,
    /// <p>The name of the provisioned connection.</p>
    pub connection_name: std::option::Option<std::string::String>,
    /// <p>The ID of the account of the customer for whom the connection will be provisioned.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>The ID of the interconnect on which the connection will be provisioned.</p>
    pub interconnect_id: std::option::Option<std::string::String>,
    /// <p>The dedicated VLAN provisioned to the connection.</p>
    pub vlan: i32,
}
impl std::fmt::Debug for AllocateConnectionOnInterconnectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AllocateConnectionOnInterconnectInput");
        formatter.field("bandwidth", &self.bandwidth);
        formatter.field("connection_name", &self.connection_name);
        formatter.field("owner_account", &self.owner_account);
        formatter.field("interconnect_id", &self.interconnect_id);
        formatter.field("vlan", &self.vlan);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceptDirectConnectGatewayAssociationProposalInput {
    /// <p>The ID of the Direct Connect gateway.</p>
    pub direct_connect_gateway_id: std::option::Option<std::string::String>,
    /// <p>The ID of the request proposal.</p>
    pub proposal_id: std::option::Option<std::string::String>,
    /// <p>The ID of the account that owns the virtual private gateway or transit gateway.</p>
    pub associated_gateway_owner_account: std::option::Option<std::string::String>,
    /// <p>Overrides the Amazon VPC prefixes advertised to the Direct Connect gateway.</p>
    /// <p>For information about how to set the prefixes, see <a href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes">Allowed Prefixes</a> in the <i>Direct Connect User Guide</i>.</p>
    pub override_allowed_prefixes_to_direct_connect_gateway:
        std::option::Option<std::vec::Vec<crate::model::RouteFilterPrefix>>,
}
impl std::fmt::Debug for AcceptDirectConnectGatewayAssociationProposalInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceptDirectConnectGatewayAssociationProposalInput");
        formatter.field("direct_connect_gateway_id", &self.direct_connect_gateway_id);
        formatter.field("proposal_id", &self.proposal_id);
        formatter.field(
            "associated_gateway_owner_account",
            &self.associated_gateway_owner_account,
        );
        formatter.field(
            "override_allowed_prefixes_to_direct_connect_gateway",
            &self.override_allowed_prefixes_to_direct_connect_gateway,
        );
        formatter.finish()
    }
}
