// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AcceptDirectConnectGatewayAssociationProposal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AcceptDirectConnectGatewayAssociationProposalError {
    /// Kind of error that occurred.
    pub kind: AcceptDirectConnectGatewayAssociationProposalErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AcceptDirectConnectGatewayAssociationProposal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AcceptDirectConnectGatewayAssociationProposalErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AcceptDirectConnectGatewayAssociationProposalError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AcceptDirectConnectGatewayAssociationProposalErrorKind::DirectConnectClientException(_inner) =>
            _inner.fmt(f)
            ,
            AcceptDirectConnectGatewayAssociationProposalErrorKind::DirectConnectServerException(_inner) =>
            _inner.fmt(f)
            ,
            AcceptDirectConnectGatewayAssociationProposalErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for AcceptDirectConnectGatewayAssociationProposalError
{
    fn code(&self) -> Option<&str> {
        AcceptDirectConnectGatewayAssociationProposalError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AcceptDirectConnectGatewayAssociationProposalError {
    /// Creates a new `AcceptDirectConnectGatewayAssociationProposalError`.
    pub fn new(
        kind: AcceptDirectConnectGatewayAssociationProposalErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AcceptDirectConnectGatewayAssociationProposalError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AcceptDirectConnectGatewayAssociationProposalErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AcceptDirectConnectGatewayAssociationProposalError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AcceptDirectConnectGatewayAssociationProposalErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AcceptDirectConnectGatewayAssociationProposalErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptDirectConnectGatewayAssociationProposalErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `AcceptDirectConnectGatewayAssociationProposalErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptDirectConnectGatewayAssociationProposalErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for AcceptDirectConnectGatewayAssociationProposalError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AcceptDirectConnectGatewayAssociationProposalErrorKind::DirectConnectClientException(_inner) =>
            Some(_inner)
            ,
            AcceptDirectConnectGatewayAssociationProposalErrorKind::DirectConnectServerException(_inner) =>
            Some(_inner)
            ,
            AcceptDirectConnectGatewayAssociationProposalErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `AllocateConnectionOnInterconnect` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AllocateConnectionOnInterconnectError {
    /// Kind of error that occurred.
    pub kind: AllocateConnectionOnInterconnectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AllocateConnectionOnInterconnect` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AllocateConnectionOnInterconnectErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AllocateConnectionOnInterconnectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AllocateConnectionOnInterconnectErrorKind::DirectConnectClientException(_inner) => {
                _inner.fmt(f)
            }
            AllocateConnectionOnInterconnectErrorKind::DirectConnectServerException(_inner) => {
                _inner.fmt(f)
            }
            AllocateConnectionOnInterconnectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AllocateConnectionOnInterconnectError {
    fn code(&self) -> Option<&str> {
        AllocateConnectionOnInterconnectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AllocateConnectionOnInterconnectError {
    /// Creates a new `AllocateConnectionOnInterconnectError`.
    pub fn new(
        kind: AllocateConnectionOnInterconnectErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AllocateConnectionOnInterconnectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AllocateConnectionOnInterconnectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AllocateConnectionOnInterconnectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AllocateConnectionOnInterconnectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AllocateConnectionOnInterconnectErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            AllocateConnectionOnInterconnectErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `AllocateConnectionOnInterconnectErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AllocateConnectionOnInterconnectErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for AllocateConnectionOnInterconnectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AllocateConnectionOnInterconnectErrorKind::DirectConnectClientException(_inner) => {
                Some(_inner)
            }
            AllocateConnectionOnInterconnectErrorKind::DirectConnectServerException(_inner) => {
                Some(_inner)
            }
            AllocateConnectionOnInterconnectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AllocateHostedConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AllocateHostedConnectionError {
    /// Kind of error that occurred.
    pub kind: AllocateHostedConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AllocateHostedConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AllocateHostedConnectionErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// <p>A tag key was specified more than once.</p>
    DuplicateTagKeysException(crate::error::DuplicateTagKeysException),
    /// <p>You have reached the limit on the number of tags that can be assigned.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AllocateHostedConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AllocateHostedConnectionErrorKind::DirectConnectClientException(_inner) => {
                _inner.fmt(f)
            }
            AllocateHostedConnectionErrorKind::DirectConnectServerException(_inner) => {
                _inner.fmt(f)
            }
            AllocateHostedConnectionErrorKind::DuplicateTagKeysException(_inner) => _inner.fmt(f),
            AllocateHostedConnectionErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            AllocateHostedConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AllocateHostedConnectionError {
    fn code(&self) -> Option<&str> {
        AllocateHostedConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AllocateHostedConnectionError {
    /// Creates a new `AllocateHostedConnectionError`.
    pub fn new(kind: AllocateHostedConnectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AllocateHostedConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AllocateHostedConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AllocateHostedConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AllocateHostedConnectionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AllocateHostedConnectionErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            AllocateHostedConnectionErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `AllocateHostedConnectionErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AllocateHostedConnectionErrorKind::DirectConnectServerException(_)
        )
    }
    /// Returns true if the error kind is `AllocateHostedConnectionErrorKind::DuplicateTagKeysException`.
    pub fn is_duplicate_tag_keys_exception(&self) -> bool {
        matches!(
            &self.kind,
            AllocateHostedConnectionErrorKind::DuplicateTagKeysException(_)
        )
    }
    /// Returns true if the error kind is `AllocateHostedConnectionErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            AllocateHostedConnectionErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for AllocateHostedConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AllocateHostedConnectionErrorKind::DirectConnectClientException(_inner) => Some(_inner),
            AllocateHostedConnectionErrorKind::DirectConnectServerException(_inner) => Some(_inner),
            AllocateHostedConnectionErrorKind::DuplicateTagKeysException(_inner) => Some(_inner),
            AllocateHostedConnectionErrorKind::TooManyTagsException(_inner) => Some(_inner),
            AllocateHostedConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AllocatePrivateVirtualInterface` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AllocatePrivateVirtualInterfaceError {
    /// Kind of error that occurred.
    pub kind: AllocatePrivateVirtualInterfaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AllocatePrivateVirtualInterface` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AllocatePrivateVirtualInterfaceErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// <p>A tag key was specified more than once.</p>
    DuplicateTagKeysException(crate::error::DuplicateTagKeysException),
    /// <p>You have reached the limit on the number of tags that can be assigned.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AllocatePrivateVirtualInterfaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AllocatePrivateVirtualInterfaceErrorKind::DirectConnectClientException(_inner) => {
                _inner.fmt(f)
            }
            AllocatePrivateVirtualInterfaceErrorKind::DirectConnectServerException(_inner) => {
                _inner.fmt(f)
            }
            AllocatePrivateVirtualInterfaceErrorKind::DuplicateTagKeysException(_inner) => {
                _inner.fmt(f)
            }
            AllocatePrivateVirtualInterfaceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            AllocatePrivateVirtualInterfaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AllocatePrivateVirtualInterfaceError {
    fn code(&self) -> Option<&str> {
        AllocatePrivateVirtualInterfaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AllocatePrivateVirtualInterfaceError {
    /// Creates a new `AllocatePrivateVirtualInterfaceError`.
    pub fn new(
        kind: AllocatePrivateVirtualInterfaceErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AllocatePrivateVirtualInterfaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AllocatePrivateVirtualInterfaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AllocatePrivateVirtualInterfaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AllocatePrivateVirtualInterfaceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AllocatePrivateVirtualInterfaceErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            AllocatePrivateVirtualInterfaceErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `AllocatePrivateVirtualInterfaceErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AllocatePrivateVirtualInterfaceErrorKind::DirectConnectServerException(_)
        )
    }
    /// Returns true if the error kind is `AllocatePrivateVirtualInterfaceErrorKind::DuplicateTagKeysException`.
    pub fn is_duplicate_tag_keys_exception(&self) -> bool {
        matches!(
            &self.kind,
            AllocatePrivateVirtualInterfaceErrorKind::DuplicateTagKeysException(_)
        )
    }
    /// Returns true if the error kind is `AllocatePrivateVirtualInterfaceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            AllocatePrivateVirtualInterfaceErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for AllocatePrivateVirtualInterfaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AllocatePrivateVirtualInterfaceErrorKind::DirectConnectClientException(_inner) => {
                Some(_inner)
            }
            AllocatePrivateVirtualInterfaceErrorKind::DirectConnectServerException(_inner) => {
                Some(_inner)
            }
            AllocatePrivateVirtualInterfaceErrorKind::DuplicateTagKeysException(_inner) => {
                Some(_inner)
            }
            AllocatePrivateVirtualInterfaceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            AllocatePrivateVirtualInterfaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AllocatePublicVirtualInterface` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AllocatePublicVirtualInterfaceError {
    /// Kind of error that occurred.
    pub kind: AllocatePublicVirtualInterfaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AllocatePublicVirtualInterface` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AllocatePublicVirtualInterfaceErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// <p>A tag key was specified more than once.</p>
    DuplicateTagKeysException(crate::error::DuplicateTagKeysException),
    /// <p>You have reached the limit on the number of tags that can be assigned.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AllocatePublicVirtualInterfaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AllocatePublicVirtualInterfaceErrorKind::DirectConnectClientException(_inner) => {
                _inner.fmt(f)
            }
            AllocatePublicVirtualInterfaceErrorKind::DirectConnectServerException(_inner) => {
                _inner.fmt(f)
            }
            AllocatePublicVirtualInterfaceErrorKind::DuplicateTagKeysException(_inner) => {
                _inner.fmt(f)
            }
            AllocatePublicVirtualInterfaceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            AllocatePublicVirtualInterfaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AllocatePublicVirtualInterfaceError {
    fn code(&self) -> Option<&str> {
        AllocatePublicVirtualInterfaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AllocatePublicVirtualInterfaceError {
    /// Creates a new `AllocatePublicVirtualInterfaceError`.
    pub fn new(
        kind: AllocatePublicVirtualInterfaceErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AllocatePublicVirtualInterfaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AllocatePublicVirtualInterfaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AllocatePublicVirtualInterfaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AllocatePublicVirtualInterfaceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AllocatePublicVirtualInterfaceErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            AllocatePublicVirtualInterfaceErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `AllocatePublicVirtualInterfaceErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AllocatePublicVirtualInterfaceErrorKind::DirectConnectServerException(_)
        )
    }
    /// Returns true if the error kind is `AllocatePublicVirtualInterfaceErrorKind::DuplicateTagKeysException`.
    pub fn is_duplicate_tag_keys_exception(&self) -> bool {
        matches!(
            &self.kind,
            AllocatePublicVirtualInterfaceErrorKind::DuplicateTagKeysException(_)
        )
    }
    /// Returns true if the error kind is `AllocatePublicVirtualInterfaceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            AllocatePublicVirtualInterfaceErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for AllocatePublicVirtualInterfaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AllocatePublicVirtualInterfaceErrorKind::DirectConnectClientException(_inner) => {
                Some(_inner)
            }
            AllocatePublicVirtualInterfaceErrorKind::DirectConnectServerException(_inner) => {
                Some(_inner)
            }
            AllocatePublicVirtualInterfaceErrorKind::DuplicateTagKeysException(_inner) => {
                Some(_inner)
            }
            AllocatePublicVirtualInterfaceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            AllocatePublicVirtualInterfaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AllocateTransitVirtualInterface` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AllocateTransitVirtualInterfaceError {
    /// Kind of error that occurred.
    pub kind: AllocateTransitVirtualInterfaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AllocateTransitVirtualInterface` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AllocateTransitVirtualInterfaceErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// <p>A tag key was specified more than once.</p>
    DuplicateTagKeysException(crate::error::DuplicateTagKeysException),
    /// <p>You have reached the limit on the number of tags that can be assigned.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AllocateTransitVirtualInterfaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AllocateTransitVirtualInterfaceErrorKind::DirectConnectClientException(_inner) => {
                _inner.fmt(f)
            }
            AllocateTransitVirtualInterfaceErrorKind::DirectConnectServerException(_inner) => {
                _inner.fmt(f)
            }
            AllocateTransitVirtualInterfaceErrorKind::DuplicateTagKeysException(_inner) => {
                _inner.fmt(f)
            }
            AllocateTransitVirtualInterfaceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            AllocateTransitVirtualInterfaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AllocateTransitVirtualInterfaceError {
    fn code(&self) -> Option<&str> {
        AllocateTransitVirtualInterfaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AllocateTransitVirtualInterfaceError {
    /// Creates a new `AllocateTransitVirtualInterfaceError`.
    pub fn new(
        kind: AllocateTransitVirtualInterfaceErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AllocateTransitVirtualInterfaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AllocateTransitVirtualInterfaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AllocateTransitVirtualInterfaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AllocateTransitVirtualInterfaceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AllocateTransitVirtualInterfaceErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            AllocateTransitVirtualInterfaceErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `AllocateTransitVirtualInterfaceErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AllocateTransitVirtualInterfaceErrorKind::DirectConnectServerException(_)
        )
    }
    /// Returns true if the error kind is `AllocateTransitVirtualInterfaceErrorKind::DuplicateTagKeysException`.
    pub fn is_duplicate_tag_keys_exception(&self) -> bool {
        matches!(
            &self.kind,
            AllocateTransitVirtualInterfaceErrorKind::DuplicateTagKeysException(_)
        )
    }
    /// Returns true if the error kind is `AllocateTransitVirtualInterfaceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            AllocateTransitVirtualInterfaceErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for AllocateTransitVirtualInterfaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AllocateTransitVirtualInterfaceErrorKind::DirectConnectClientException(_inner) => {
                Some(_inner)
            }
            AllocateTransitVirtualInterfaceErrorKind::DirectConnectServerException(_inner) => {
                Some(_inner)
            }
            AllocateTransitVirtualInterfaceErrorKind::DuplicateTagKeysException(_inner) => {
                Some(_inner)
            }
            AllocateTransitVirtualInterfaceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            AllocateTransitVirtualInterfaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateConnectionWithLag` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateConnectionWithLagError {
    /// Kind of error that occurred.
    pub kind: AssociateConnectionWithLagErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateConnectionWithLag` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateConnectionWithLagErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateConnectionWithLagError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateConnectionWithLagErrorKind::DirectConnectClientException(_inner) => {
                _inner.fmt(f)
            }
            AssociateConnectionWithLagErrorKind::DirectConnectServerException(_inner) => {
                _inner.fmt(f)
            }
            AssociateConnectionWithLagErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateConnectionWithLagError {
    fn code(&self) -> Option<&str> {
        AssociateConnectionWithLagError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateConnectionWithLagError {
    /// Creates a new `AssociateConnectionWithLagError`.
    pub fn new(kind: AssociateConnectionWithLagErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateConnectionWithLagError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateConnectionWithLagErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateConnectionWithLagError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateConnectionWithLagErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AssociateConnectionWithLagErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateConnectionWithLagErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `AssociateConnectionWithLagErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateConnectionWithLagErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for AssociateConnectionWithLagError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateConnectionWithLagErrorKind::DirectConnectClientException(_inner) => {
                Some(_inner)
            }
            AssociateConnectionWithLagErrorKind::DirectConnectServerException(_inner) => {
                Some(_inner)
            }
            AssociateConnectionWithLagErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateHostedConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateHostedConnectionError {
    /// Kind of error that occurred.
    pub kind: AssociateHostedConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateHostedConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateHostedConnectionErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateHostedConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateHostedConnectionErrorKind::DirectConnectClientException(_inner) => {
                _inner.fmt(f)
            }
            AssociateHostedConnectionErrorKind::DirectConnectServerException(_inner) => {
                _inner.fmt(f)
            }
            AssociateHostedConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateHostedConnectionError {
    fn code(&self) -> Option<&str> {
        AssociateHostedConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateHostedConnectionError {
    /// Creates a new `AssociateHostedConnectionError`.
    pub fn new(kind: AssociateHostedConnectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateHostedConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateHostedConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateHostedConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateHostedConnectionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AssociateHostedConnectionErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateHostedConnectionErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `AssociateHostedConnectionErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateHostedConnectionErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for AssociateHostedConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateHostedConnectionErrorKind::DirectConnectClientException(_inner) => {
                Some(_inner)
            }
            AssociateHostedConnectionErrorKind::DirectConnectServerException(_inner) => {
                Some(_inner)
            }
            AssociateHostedConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateMacSecKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateMacSecKeyError {
    /// Kind of error that occurred.
    pub kind: AssociateMacSecKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateMacSecKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateMacSecKeyErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateMacSecKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateMacSecKeyErrorKind::DirectConnectClientException(_inner) => _inner.fmt(f),
            AssociateMacSecKeyErrorKind::DirectConnectServerException(_inner) => _inner.fmt(f),
            AssociateMacSecKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateMacSecKeyError {
    fn code(&self) -> Option<&str> {
        AssociateMacSecKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateMacSecKeyError {
    /// Creates a new `AssociateMacSecKeyError`.
    pub fn new(kind: AssociateMacSecKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateMacSecKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateMacSecKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateMacSecKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateMacSecKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AssociateMacSecKeyErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateMacSecKeyErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `AssociateMacSecKeyErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateMacSecKeyErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for AssociateMacSecKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateMacSecKeyErrorKind::DirectConnectClientException(_inner) => Some(_inner),
            AssociateMacSecKeyErrorKind::DirectConnectServerException(_inner) => Some(_inner),
            AssociateMacSecKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateVirtualInterface` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateVirtualInterfaceError {
    /// Kind of error that occurred.
    pub kind: AssociateVirtualInterfaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateVirtualInterface` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateVirtualInterfaceErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateVirtualInterfaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateVirtualInterfaceErrorKind::DirectConnectClientException(_inner) => {
                _inner.fmt(f)
            }
            AssociateVirtualInterfaceErrorKind::DirectConnectServerException(_inner) => {
                _inner.fmt(f)
            }
            AssociateVirtualInterfaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateVirtualInterfaceError {
    fn code(&self) -> Option<&str> {
        AssociateVirtualInterfaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateVirtualInterfaceError {
    /// Creates a new `AssociateVirtualInterfaceError`.
    pub fn new(kind: AssociateVirtualInterfaceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateVirtualInterfaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateVirtualInterfaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateVirtualInterfaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateVirtualInterfaceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AssociateVirtualInterfaceErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateVirtualInterfaceErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `AssociateVirtualInterfaceErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateVirtualInterfaceErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for AssociateVirtualInterfaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateVirtualInterfaceErrorKind::DirectConnectClientException(_inner) => {
                Some(_inner)
            }
            AssociateVirtualInterfaceErrorKind::DirectConnectServerException(_inner) => {
                Some(_inner)
            }
            AssociateVirtualInterfaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ConfirmConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ConfirmConnectionError {
    /// Kind of error that occurred.
    pub kind: ConfirmConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ConfirmConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ConfirmConnectionErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ConfirmConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ConfirmConnectionErrorKind::DirectConnectClientException(_inner) => _inner.fmt(f),
            ConfirmConnectionErrorKind::DirectConnectServerException(_inner) => _inner.fmt(f),
            ConfirmConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ConfirmConnectionError {
    fn code(&self) -> Option<&str> {
        ConfirmConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ConfirmConnectionError {
    /// Creates a new `ConfirmConnectionError`.
    pub fn new(kind: ConfirmConnectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ConfirmConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ConfirmConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ConfirmConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ConfirmConnectionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ConfirmConnectionErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmConnectionErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `ConfirmConnectionErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmConnectionErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for ConfirmConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ConfirmConnectionErrorKind::DirectConnectClientException(_inner) => Some(_inner),
            ConfirmConnectionErrorKind::DirectConnectServerException(_inner) => Some(_inner),
            ConfirmConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ConfirmPrivateVirtualInterface` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ConfirmPrivateVirtualInterfaceError {
    /// Kind of error that occurred.
    pub kind: ConfirmPrivateVirtualInterfaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ConfirmPrivateVirtualInterface` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ConfirmPrivateVirtualInterfaceErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ConfirmPrivateVirtualInterfaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ConfirmPrivateVirtualInterfaceErrorKind::DirectConnectClientException(_inner) => {
                _inner.fmt(f)
            }
            ConfirmPrivateVirtualInterfaceErrorKind::DirectConnectServerException(_inner) => {
                _inner.fmt(f)
            }
            ConfirmPrivateVirtualInterfaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ConfirmPrivateVirtualInterfaceError {
    fn code(&self) -> Option<&str> {
        ConfirmPrivateVirtualInterfaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ConfirmPrivateVirtualInterfaceError {
    /// Creates a new `ConfirmPrivateVirtualInterfaceError`.
    pub fn new(
        kind: ConfirmPrivateVirtualInterfaceErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ConfirmPrivateVirtualInterfaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ConfirmPrivateVirtualInterfaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ConfirmPrivateVirtualInterfaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ConfirmPrivateVirtualInterfaceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ConfirmPrivateVirtualInterfaceErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmPrivateVirtualInterfaceErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `ConfirmPrivateVirtualInterfaceErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmPrivateVirtualInterfaceErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for ConfirmPrivateVirtualInterfaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ConfirmPrivateVirtualInterfaceErrorKind::DirectConnectClientException(_inner) => {
                Some(_inner)
            }
            ConfirmPrivateVirtualInterfaceErrorKind::DirectConnectServerException(_inner) => {
                Some(_inner)
            }
            ConfirmPrivateVirtualInterfaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ConfirmPublicVirtualInterface` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ConfirmPublicVirtualInterfaceError {
    /// Kind of error that occurred.
    pub kind: ConfirmPublicVirtualInterfaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ConfirmPublicVirtualInterface` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ConfirmPublicVirtualInterfaceErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ConfirmPublicVirtualInterfaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ConfirmPublicVirtualInterfaceErrorKind::DirectConnectClientException(_inner) => {
                _inner.fmt(f)
            }
            ConfirmPublicVirtualInterfaceErrorKind::DirectConnectServerException(_inner) => {
                _inner.fmt(f)
            }
            ConfirmPublicVirtualInterfaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ConfirmPublicVirtualInterfaceError {
    fn code(&self) -> Option<&str> {
        ConfirmPublicVirtualInterfaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ConfirmPublicVirtualInterfaceError {
    /// Creates a new `ConfirmPublicVirtualInterfaceError`.
    pub fn new(
        kind: ConfirmPublicVirtualInterfaceErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ConfirmPublicVirtualInterfaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ConfirmPublicVirtualInterfaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ConfirmPublicVirtualInterfaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ConfirmPublicVirtualInterfaceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ConfirmPublicVirtualInterfaceErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmPublicVirtualInterfaceErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `ConfirmPublicVirtualInterfaceErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmPublicVirtualInterfaceErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for ConfirmPublicVirtualInterfaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ConfirmPublicVirtualInterfaceErrorKind::DirectConnectClientException(_inner) => {
                Some(_inner)
            }
            ConfirmPublicVirtualInterfaceErrorKind::DirectConnectServerException(_inner) => {
                Some(_inner)
            }
            ConfirmPublicVirtualInterfaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ConfirmTransitVirtualInterface` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ConfirmTransitVirtualInterfaceError {
    /// Kind of error that occurred.
    pub kind: ConfirmTransitVirtualInterfaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ConfirmTransitVirtualInterface` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ConfirmTransitVirtualInterfaceErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ConfirmTransitVirtualInterfaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ConfirmTransitVirtualInterfaceErrorKind::DirectConnectClientException(_inner) => {
                _inner.fmt(f)
            }
            ConfirmTransitVirtualInterfaceErrorKind::DirectConnectServerException(_inner) => {
                _inner.fmt(f)
            }
            ConfirmTransitVirtualInterfaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ConfirmTransitVirtualInterfaceError {
    fn code(&self) -> Option<&str> {
        ConfirmTransitVirtualInterfaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ConfirmTransitVirtualInterfaceError {
    /// Creates a new `ConfirmTransitVirtualInterfaceError`.
    pub fn new(
        kind: ConfirmTransitVirtualInterfaceErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ConfirmTransitVirtualInterfaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ConfirmTransitVirtualInterfaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ConfirmTransitVirtualInterfaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ConfirmTransitVirtualInterfaceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ConfirmTransitVirtualInterfaceErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmTransitVirtualInterfaceErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `ConfirmTransitVirtualInterfaceErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmTransitVirtualInterfaceErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for ConfirmTransitVirtualInterfaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ConfirmTransitVirtualInterfaceErrorKind::DirectConnectClientException(_inner) => {
                Some(_inner)
            }
            ConfirmTransitVirtualInterfaceErrorKind::DirectConnectServerException(_inner) => {
                Some(_inner)
            }
            ConfirmTransitVirtualInterfaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateBGPPeer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBGPPeerError {
    /// Kind of error that occurred.
    pub kind: CreateBGPPeerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBGPPeer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBGPPeerErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBGPPeerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBGPPeerErrorKind::DirectConnectClientException(_inner) => _inner.fmt(f),
            CreateBGPPeerErrorKind::DirectConnectServerException(_inner) => _inner.fmt(f),
            CreateBGPPeerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBGPPeerError {
    fn code(&self) -> Option<&str> {
        CreateBGPPeerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBGPPeerError {
    /// Creates a new `CreateBGPPeerError`.
    pub fn new(kind: CreateBGPPeerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBGPPeerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBGPPeerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBGPPeerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBGPPeerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateBGPPeerErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBGPPeerErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `CreateBGPPeerErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBGPPeerErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for CreateBGPPeerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBGPPeerErrorKind::DirectConnectClientException(_inner) => Some(_inner),
            CreateBGPPeerErrorKind::DirectConnectServerException(_inner) => Some(_inner),
            CreateBGPPeerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateConnectionError {
    /// Kind of error that occurred.
    pub kind: CreateConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateConnectionErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// <p>A tag key was specified more than once.</p>
    DuplicateTagKeysException(crate::error::DuplicateTagKeysException),
    /// <p>You have reached the limit on the number of tags that can be assigned.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateConnectionErrorKind::DirectConnectClientException(_inner) => _inner.fmt(f),
            CreateConnectionErrorKind::DirectConnectServerException(_inner) => _inner.fmt(f),
            CreateConnectionErrorKind::DuplicateTagKeysException(_inner) => _inner.fmt(f),
            CreateConnectionErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateConnectionError {
    fn code(&self) -> Option<&str> {
        CreateConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateConnectionError {
    /// Creates a new `CreateConnectionError`.
    pub fn new(kind: CreateConnectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateConnectionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateConnectionErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectionErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `CreateConnectionErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectionErrorKind::DirectConnectServerException(_)
        )
    }
    /// Returns true if the error kind is `CreateConnectionErrorKind::DuplicateTagKeysException`.
    pub fn is_duplicate_tag_keys_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectionErrorKind::DuplicateTagKeysException(_)
        )
    }
    /// Returns true if the error kind is `CreateConnectionErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectionErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for CreateConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateConnectionErrorKind::DirectConnectClientException(_inner) => Some(_inner),
            CreateConnectionErrorKind::DirectConnectServerException(_inner) => Some(_inner),
            CreateConnectionErrorKind::DuplicateTagKeysException(_inner) => Some(_inner),
            CreateConnectionErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDirectConnectGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDirectConnectGatewayError {
    /// Kind of error that occurred.
    pub kind: CreateDirectConnectGatewayErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDirectConnectGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDirectConnectGatewayErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDirectConnectGatewayError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDirectConnectGatewayErrorKind::DirectConnectClientException(_inner) => {
                _inner.fmt(f)
            }
            CreateDirectConnectGatewayErrorKind::DirectConnectServerException(_inner) => {
                _inner.fmt(f)
            }
            CreateDirectConnectGatewayErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDirectConnectGatewayError {
    fn code(&self) -> Option<&str> {
        CreateDirectConnectGatewayError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDirectConnectGatewayError {
    /// Creates a new `CreateDirectConnectGatewayError`.
    pub fn new(kind: CreateDirectConnectGatewayErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDirectConnectGatewayError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDirectConnectGatewayErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDirectConnectGatewayError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDirectConnectGatewayErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateDirectConnectGatewayErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDirectConnectGatewayErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `CreateDirectConnectGatewayErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDirectConnectGatewayErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for CreateDirectConnectGatewayError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDirectConnectGatewayErrorKind::DirectConnectClientException(_inner) => {
                Some(_inner)
            }
            CreateDirectConnectGatewayErrorKind::DirectConnectServerException(_inner) => {
                Some(_inner)
            }
            CreateDirectConnectGatewayErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDirectConnectGatewayAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDirectConnectGatewayAssociationError {
    /// Kind of error that occurred.
    pub kind: CreateDirectConnectGatewayAssociationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDirectConnectGatewayAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDirectConnectGatewayAssociationErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDirectConnectGatewayAssociationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDirectConnectGatewayAssociationErrorKind::DirectConnectClientException(
                _inner,
            ) => _inner.fmt(f),
            CreateDirectConnectGatewayAssociationErrorKind::DirectConnectServerException(
                _inner,
            ) => _inner.fmt(f),
            CreateDirectConnectGatewayAssociationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDirectConnectGatewayAssociationError {
    fn code(&self) -> Option<&str> {
        CreateDirectConnectGatewayAssociationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDirectConnectGatewayAssociationError {
    /// Creates a new `CreateDirectConnectGatewayAssociationError`.
    pub fn new(
        kind: CreateDirectConnectGatewayAssociationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDirectConnectGatewayAssociationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDirectConnectGatewayAssociationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDirectConnectGatewayAssociationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDirectConnectGatewayAssociationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateDirectConnectGatewayAssociationErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDirectConnectGatewayAssociationErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `CreateDirectConnectGatewayAssociationErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDirectConnectGatewayAssociationErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for CreateDirectConnectGatewayAssociationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDirectConnectGatewayAssociationErrorKind::DirectConnectClientException(
                _inner,
            ) => Some(_inner),
            CreateDirectConnectGatewayAssociationErrorKind::DirectConnectServerException(
                _inner,
            ) => Some(_inner),
            CreateDirectConnectGatewayAssociationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `CreateDirectConnectGatewayAssociationProposal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDirectConnectGatewayAssociationProposalError {
    /// Kind of error that occurred.
    pub kind: CreateDirectConnectGatewayAssociationProposalErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDirectConnectGatewayAssociationProposal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDirectConnectGatewayAssociationProposalErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDirectConnectGatewayAssociationProposalError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDirectConnectGatewayAssociationProposalErrorKind::DirectConnectClientException(_inner) =>
            _inner.fmt(f)
            ,
            CreateDirectConnectGatewayAssociationProposalErrorKind::DirectConnectServerException(_inner) =>
            _inner.fmt(f)
            ,
            CreateDirectConnectGatewayAssociationProposalErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for CreateDirectConnectGatewayAssociationProposalError
{
    fn code(&self) -> Option<&str> {
        CreateDirectConnectGatewayAssociationProposalError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDirectConnectGatewayAssociationProposalError {
    /// Creates a new `CreateDirectConnectGatewayAssociationProposalError`.
    pub fn new(
        kind: CreateDirectConnectGatewayAssociationProposalErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDirectConnectGatewayAssociationProposalError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDirectConnectGatewayAssociationProposalErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDirectConnectGatewayAssociationProposalError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDirectConnectGatewayAssociationProposalErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateDirectConnectGatewayAssociationProposalErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDirectConnectGatewayAssociationProposalErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `CreateDirectConnectGatewayAssociationProposalErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDirectConnectGatewayAssociationProposalErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for CreateDirectConnectGatewayAssociationProposalError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDirectConnectGatewayAssociationProposalErrorKind::DirectConnectClientException(_inner) =>
            Some(_inner)
            ,
            CreateDirectConnectGatewayAssociationProposalErrorKind::DirectConnectServerException(_inner) =>
            Some(_inner)
            ,
            CreateDirectConnectGatewayAssociationProposalErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `CreateInterconnect` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateInterconnectError {
    /// Kind of error that occurred.
    pub kind: CreateInterconnectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateInterconnect` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateInterconnectErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// <p>A tag key was specified more than once.</p>
    DuplicateTagKeysException(crate::error::DuplicateTagKeysException),
    /// <p>You have reached the limit on the number of tags that can be assigned.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateInterconnectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateInterconnectErrorKind::DirectConnectClientException(_inner) => _inner.fmt(f),
            CreateInterconnectErrorKind::DirectConnectServerException(_inner) => _inner.fmt(f),
            CreateInterconnectErrorKind::DuplicateTagKeysException(_inner) => _inner.fmt(f),
            CreateInterconnectErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateInterconnectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateInterconnectError {
    fn code(&self) -> Option<&str> {
        CreateInterconnectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateInterconnectError {
    /// Creates a new `CreateInterconnectError`.
    pub fn new(kind: CreateInterconnectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateInterconnectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateInterconnectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateInterconnectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateInterconnectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateInterconnectErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInterconnectErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `CreateInterconnectErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInterconnectErrorKind::DirectConnectServerException(_)
        )
    }
    /// Returns true if the error kind is `CreateInterconnectErrorKind::DuplicateTagKeysException`.
    pub fn is_duplicate_tag_keys_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInterconnectErrorKind::DuplicateTagKeysException(_)
        )
    }
    /// Returns true if the error kind is `CreateInterconnectErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInterconnectErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for CreateInterconnectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateInterconnectErrorKind::DirectConnectClientException(_inner) => Some(_inner),
            CreateInterconnectErrorKind::DirectConnectServerException(_inner) => Some(_inner),
            CreateInterconnectErrorKind::DuplicateTagKeysException(_inner) => Some(_inner),
            CreateInterconnectErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateInterconnectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateLag` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLagError {
    /// Kind of error that occurred.
    pub kind: CreateLagErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLag` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLagErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// <p>A tag key was specified more than once.</p>
    DuplicateTagKeysException(crate::error::DuplicateTagKeysException),
    /// <p>You have reached the limit on the number of tags that can be assigned.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLagError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLagErrorKind::DirectConnectClientException(_inner) => _inner.fmt(f),
            CreateLagErrorKind::DirectConnectServerException(_inner) => _inner.fmt(f),
            CreateLagErrorKind::DuplicateTagKeysException(_inner) => _inner.fmt(f),
            CreateLagErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateLagErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLagError {
    fn code(&self) -> Option<&str> {
        CreateLagError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLagError {
    /// Creates a new `CreateLagError`.
    pub fn new(kind: CreateLagErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLagError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLagErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLagError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLagErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateLagErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLagErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `CreateLagErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLagErrorKind::DirectConnectServerException(_)
        )
    }
    /// Returns true if the error kind is `CreateLagErrorKind::DuplicateTagKeysException`.
    pub fn is_duplicate_tag_keys_exception(&self) -> bool {
        matches!(&self.kind, CreateLagErrorKind::DuplicateTagKeysException(_))
    }
    /// Returns true if the error kind is `CreateLagErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, CreateLagErrorKind::TooManyTagsException(_))
    }
}
impl std::error::Error for CreateLagError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLagErrorKind::DirectConnectClientException(_inner) => Some(_inner),
            CreateLagErrorKind::DirectConnectServerException(_inner) => Some(_inner),
            CreateLagErrorKind::DuplicateTagKeysException(_inner) => Some(_inner),
            CreateLagErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateLagErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePrivateVirtualInterface` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePrivateVirtualInterfaceError {
    /// Kind of error that occurred.
    pub kind: CreatePrivateVirtualInterfaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePrivateVirtualInterface` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePrivateVirtualInterfaceErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// <p>A tag key was specified more than once.</p>
    DuplicateTagKeysException(crate::error::DuplicateTagKeysException),
    /// <p>You have reached the limit on the number of tags that can be assigned.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePrivateVirtualInterfaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePrivateVirtualInterfaceErrorKind::DirectConnectClientException(_inner) => {
                _inner.fmt(f)
            }
            CreatePrivateVirtualInterfaceErrorKind::DirectConnectServerException(_inner) => {
                _inner.fmt(f)
            }
            CreatePrivateVirtualInterfaceErrorKind::DuplicateTagKeysException(_inner) => {
                _inner.fmt(f)
            }
            CreatePrivateVirtualInterfaceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreatePrivateVirtualInterfaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePrivateVirtualInterfaceError {
    fn code(&self) -> Option<&str> {
        CreatePrivateVirtualInterfaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePrivateVirtualInterfaceError {
    /// Creates a new `CreatePrivateVirtualInterfaceError`.
    pub fn new(
        kind: CreatePrivateVirtualInterfaceErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePrivateVirtualInterfaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePrivateVirtualInterfaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePrivateVirtualInterfaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePrivateVirtualInterfaceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreatePrivateVirtualInterfaceErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePrivateVirtualInterfaceErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `CreatePrivateVirtualInterfaceErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePrivateVirtualInterfaceErrorKind::DirectConnectServerException(_)
        )
    }
    /// Returns true if the error kind is `CreatePrivateVirtualInterfaceErrorKind::DuplicateTagKeysException`.
    pub fn is_duplicate_tag_keys_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePrivateVirtualInterfaceErrorKind::DuplicateTagKeysException(_)
        )
    }
    /// Returns true if the error kind is `CreatePrivateVirtualInterfaceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePrivateVirtualInterfaceErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for CreatePrivateVirtualInterfaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePrivateVirtualInterfaceErrorKind::DirectConnectClientException(_inner) => {
                Some(_inner)
            }
            CreatePrivateVirtualInterfaceErrorKind::DirectConnectServerException(_inner) => {
                Some(_inner)
            }
            CreatePrivateVirtualInterfaceErrorKind::DuplicateTagKeysException(_inner) => {
                Some(_inner)
            }
            CreatePrivateVirtualInterfaceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreatePrivateVirtualInterfaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePublicVirtualInterface` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePublicVirtualInterfaceError {
    /// Kind of error that occurred.
    pub kind: CreatePublicVirtualInterfaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePublicVirtualInterface` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePublicVirtualInterfaceErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// <p>A tag key was specified more than once.</p>
    DuplicateTagKeysException(crate::error::DuplicateTagKeysException),
    /// <p>You have reached the limit on the number of tags that can be assigned.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePublicVirtualInterfaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePublicVirtualInterfaceErrorKind::DirectConnectClientException(_inner) => {
                _inner.fmt(f)
            }
            CreatePublicVirtualInterfaceErrorKind::DirectConnectServerException(_inner) => {
                _inner.fmt(f)
            }
            CreatePublicVirtualInterfaceErrorKind::DuplicateTagKeysException(_inner) => {
                _inner.fmt(f)
            }
            CreatePublicVirtualInterfaceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreatePublicVirtualInterfaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePublicVirtualInterfaceError {
    fn code(&self) -> Option<&str> {
        CreatePublicVirtualInterfaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePublicVirtualInterfaceError {
    /// Creates a new `CreatePublicVirtualInterfaceError`.
    pub fn new(kind: CreatePublicVirtualInterfaceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePublicVirtualInterfaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePublicVirtualInterfaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePublicVirtualInterfaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePublicVirtualInterfaceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreatePublicVirtualInterfaceErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePublicVirtualInterfaceErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `CreatePublicVirtualInterfaceErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePublicVirtualInterfaceErrorKind::DirectConnectServerException(_)
        )
    }
    /// Returns true if the error kind is `CreatePublicVirtualInterfaceErrorKind::DuplicateTagKeysException`.
    pub fn is_duplicate_tag_keys_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePublicVirtualInterfaceErrorKind::DuplicateTagKeysException(_)
        )
    }
    /// Returns true if the error kind is `CreatePublicVirtualInterfaceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePublicVirtualInterfaceErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for CreatePublicVirtualInterfaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePublicVirtualInterfaceErrorKind::DirectConnectClientException(_inner) => {
                Some(_inner)
            }
            CreatePublicVirtualInterfaceErrorKind::DirectConnectServerException(_inner) => {
                Some(_inner)
            }
            CreatePublicVirtualInterfaceErrorKind::DuplicateTagKeysException(_inner) => {
                Some(_inner)
            }
            CreatePublicVirtualInterfaceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreatePublicVirtualInterfaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTransitVirtualInterface` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTransitVirtualInterfaceError {
    /// Kind of error that occurred.
    pub kind: CreateTransitVirtualInterfaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTransitVirtualInterface` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTransitVirtualInterfaceErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// <p>A tag key was specified more than once.</p>
    DuplicateTagKeysException(crate::error::DuplicateTagKeysException),
    /// <p>You have reached the limit on the number of tags that can be assigned.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTransitVirtualInterfaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTransitVirtualInterfaceErrorKind::DirectConnectClientException(_inner) => {
                _inner.fmt(f)
            }
            CreateTransitVirtualInterfaceErrorKind::DirectConnectServerException(_inner) => {
                _inner.fmt(f)
            }
            CreateTransitVirtualInterfaceErrorKind::DuplicateTagKeysException(_inner) => {
                _inner.fmt(f)
            }
            CreateTransitVirtualInterfaceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateTransitVirtualInterfaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTransitVirtualInterfaceError {
    fn code(&self) -> Option<&str> {
        CreateTransitVirtualInterfaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTransitVirtualInterfaceError {
    /// Creates a new `CreateTransitVirtualInterfaceError`.
    pub fn new(
        kind: CreateTransitVirtualInterfaceErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTransitVirtualInterfaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTransitVirtualInterfaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTransitVirtualInterfaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTransitVirtualInterfaceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateTransitVirtualInterfaceErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTransitVirtualInterfaceErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `CreateTransitVirtualInterfaceErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTransitVirtualInterfaceErrorKind::DirectConnectServerException(_)
        )
    }
    /// Returns true if the error kind is `CreateTransitVirtualInterfaceErrorKind::DuplicateTagKeysException`.
    pub fn is_duplicate_tag_keys_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTransitVirtualInterfaceErrorKind::DuplicateTagKeysException(_)
        )
    }
    /// Returns true if the error kind is `CreateTransitVirtualInterfaceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTransitVirtualInterfaceErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for CreateTransitVirtualInterfaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTransitVirtualInterfaceErrorKind::DirectConnectClientException(_inner) => {
                Some(_inner)
            }
            CreateTransitVirtualInterfaceErrorKind::DirectConnectServerException(_inner) => {
                Some(_inner)
            }
            CreateTransitVirtualInterfaceErrorKind::DuplicateTagKeysException(_inner) => {
                Some(_inner)
            }
            CreateTransitVirtualInterfaceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateTransitVirtualInterfaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBGPPeer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBGPPeerError {
    /// Kind of error that occurred.
    pub kind: DeleteBGPPeerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBGPPeer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBGPPeerErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBGPPeerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBGPPeerErrorKind::DirectConnectClientException(_inner) => _inner.fmt(f),
            DeleteBGPPeerErrorKind::DirectConnectServerException(_inner) => _inner.fmt(f),
            DeleteBGPPeerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBGPPeerError {
    fn code(&self) -> Option<&str> {
        DeleteBGPPeerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBGPPeerError {
    /// Creates a new `DeleteBGPPeerError`.
    pub fn new(kind: DeleteBGPPeerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBGPPeerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBGPPeerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBGPPeerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBGPPeerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteBGPPeerErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBGPPeerErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `DeleteBGPPeerErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBGPPeerErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for DeleteBGPPeerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBGPPeerErrorKind::DirectConnectClientException(_inner) => Some(_inner),
            DeleteBGPPeerErrorKind::DirectConnectServerException(_inner) => Some(_inner),
            DeleteBGPPeerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteConnectionError {
    /// Kind of error that occurred.
    pub kind: DeleteConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteConnectionErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteConnectionErrorKind::DirectConnectClientException(_inner) => _inner.fmt(f),
            DeleteConnectionErrorKind::DirectConnectServerException(_inner) => _inner.fmt(f),
            DeleteConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteConnectionError {
    fn code(&self) -> Option<&str> {
        DeleteConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteConnectionError {
    /// Creates a new `DeleteConnectionError`.
    pub fn new(kind: DeleteConnectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteConnectionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteConnectionErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectionErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `DeleteConnectionErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectionErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for DeleteConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteConnectionErrorKind::DirectConnectClientException(_inner) => Some(_inner),
            DeleteConnectionErrorKind::DirectConnectServerException(_inner) => Some(_inner),
            DeleteConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDirectConnectGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDirectConnectGatewayError {
    /// Kind of error that occurred.
    pub kind: DeleteDirectConnectGatewayErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDirectConnectGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDirectConnectGatewayErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDirectConnectGatewayError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDirectConnectGatewayErrorKind::DirectConnectClientException(_inner) => {
                _inner.fmt(f)
            }
            DeleteDirectConnectGatewayErrorKind::DirectConnectServerException(_inner) => {
                _inner.fmt(f)
            }
            DeleteDirectConnectGatewayErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDirectConnectGatewayError {
    fn code(&self) -> Option<&str> {
        DeleteDirectConnectGatewayError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDirectConnectGatewayError {
    /// Creates a new `DeleteDirectConnectGatewayError`.
    pub fn new(kind: DeleteDirectConnectGatewayErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDirectConnectGatewayError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDirectConnectGatewayErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDirectConnectGatewayError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDirectConnectGatewayErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteDirectConnectGatewayErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDirectConnectGatewayErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDirectConnectGatewayErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDirectConnectGatewayErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for DeleteDirectConnectGatewayError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDirectConnectGatewayErrorKind::DirectConnectClientException(_inner) => {
                Some(_inner)
            }
            DeleteDirectConnectGatewayErrorKind::DirectConnectServerException(_inner) => {
                Some(_inner)
            }
            DeleteDirectConnectGatewayErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDirectConnectGatewayAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDirectConnectGatewayAssociationError {
    /// Kind of error that occurred.
    pub kind: DeleteDirectConnectGatewayAssociationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDirectConnectGatewayAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDirectConnectGatewayAssociationErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDirectConnectGatewayAssociationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDirectConnectGatewayAssociationErrorKind::DirectConnectClientException(
                _inner,
            ) => _inner.fmt(f),
            DeleteDirectConnectGatewayAssociationErrorKind::DirectConnectServerException(
                _inner,
            ) => _inner.fmt(f),
            DeleteDirectConnectGatewayAssociationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDirectConnectGatewayAssociationError {
    fn code(&self) -> Option<&str> {
        DeleteDirectConnectGatewayAssociationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDirectConnectGatewayAssociationError {
    /// Creates a new `DeleteDirectConnectGatewayAssociationError`.
    pub fn new(
        kind: DeleteDirectConnectGatewayAssociationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDirectConnectGatewayAssociationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDirectConnectGatewayAssociationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDirectConnectGatewayAssociationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDirectConnectGatewayAssociationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteDirectConnectGatewayAssociationErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDirectConnectGatewayAssociationErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDirectConnectGatewayAssociationErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDirectConnectGatewayAssociationErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for DeleteDirectConnectGatewayAssociationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDirectConnectGatewayAssociationErrorKind::DirectConnectClientException(
                _inner,
            ) => Some(_inner),
            DeleteDirectConnectGatewayAssociationErrorKind::DirectConnectServerException(
                _inner,
            ) => Some(_inner),
            DeleteDirectConnectGatewayAssociationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DeleteDirectConnectGatewayAssociationProposal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDirectConnectGatewayAssociationProposalError {
    /// Kind of error that occurred.
    pub kind: DeleteDirectConnectGatewayAssociationProposalErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDirectConnectGatewayAssociationProposal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDirectConnectGatewayAssociationProposalErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDirectConnectGatewayAssociationProposalError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDirectConnectGatewayAssociationProposalErrorKind::DirectConnectClientException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteDirectConnectGatewayAssociationProposalErrorKind::DirectConnectServerException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteDirectConnectGatewayAssociationProposalErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for DeleteDirectConnectGatewayAssociationProposalError
{
    fn code(&self) -> Option<&str> {
        DeleteDirectConnectGatewayAssociationProposalError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDirectConnectGatewayAssociationProposalError {
    /// Creates a new `DeleteDirectConnectGatewayAssociationProposalError`.
    pub fn new(
        kind: DeleteDirectConnectGatewayAssociationProposalErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDirectConnectGatewayAssociationProposalError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDirectConnectGatewayAssociationProposalErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDirectConnectGatewayAssociationProposalError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDirectConnectGatewayAssociationProposalErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteDirectConnectGatewayAssociationProposalErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDirectConnectGatewayAssociationProposalErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDirectConnectGatewayAssociationProposalErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDirectConnectGatewayAssociationProposalErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for DeleteDirectConnectGatewayAssociationProposalError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDirectConnectGatewayAssociationProposalErrorKind::DirectConnectClientException(_inner) =>
            Some(_inner)
            ,
            DeleteDirectConnectGatewayAssociationProposalErrorKind::DirectConnectServerException(_inner) =>
            Some(_inner)
            ,
            DeleteDirectConnectGatewayAssociationProposalErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DeleteInterconnect` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteInterconnectError {
    /// Kind of error that occurred.
    pub kind: DeleteInterconnectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteInterconnect` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteInterconnectErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteInterconnectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteInterconnectErrorKind::DirectConnectClientException(_inner) => _inner.fmt(f),
            DeleteInterconnectErrorKind::DirectConnectServerException(_inner) => _inner.fmt(f),
            DeleteInterconnectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteInterconnectError {
    fn code(&self) -> Option<&str> {
        DeleteInterconnectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteInterconnectError {
    /// Creates a new `DeleteInterconnectError`.
    pub fn new(kind: DeleteInterconnectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteInterconnectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteInterconnectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteInterconnectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteInterconnectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteInterconnectErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInterconnectErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `DeleteInterconnectErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInterconnectErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for DeleteInterconnectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteInterconnectErrorKind::DirectConnectClientException(_inner) => Some(_inner),
            DeleteInterconnectErrorKind::DirectConnectServerException(_inner) => Some(_inner),
            DeleteInterconnectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteLag` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteLagError {
    /// Kind of error that occurred.
    pub kind: DeleteLagErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteLag` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteLagErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteLagError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteLagErrorKind::DirectConnectClientException(_inner) => _inner.fmt(f),
            DeleteLagErrorKind::DirectConnectServerException(_inner) => _inner.fmt(f),
            DeleteLagErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteLagError {
    fn code(&self) -> Option<&str> {
        DeleteLagError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteLagError {
    /// Creates a new `DeleteLagError`.
    pub fn new(kind: DeleteLagErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteLagError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteLagErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteLagError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteLagErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteLagErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLagErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `DeleteLagErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLagErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for DeleteLagError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteLagErrorKind::DirectConnectClientException(_inner) => Some(_inner),
            DeleteLagErrorKind::DirectConnectServerException(_inner) => Some(_inner),
            DeleteLagErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteVirtualInterface` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteVirtualInterfaceError {
    /// Kind of error that occurred.
    pub kind: DeleteVirtualInterfaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteVirtualInterface` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteVirtualInterfaceErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteVirtualInterfaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteVirtualInterfaceErrorKind::DirectConnectClientException(_inner) => _inner.fmt(f),
            DeleteVirtualInterfaceErrorKind::DirectConnectServerException(_inner) => _inner.fmt(f),
            DeleteVirtualInterfaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteVirtualInterfaceError {
    fn code(&self) -> Option<&str> {
        DeleteVirtualInterfaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteVirtualInterfaceError {
    /// Creates a new `DeleteVirtualInterfaceError`.
    pub fn new(kind: DeleteVirtualInterfaceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteVirtualInterfaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteVirtualInterfaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteVirtualInterfaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteVirtualInterfaceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteVirtualInterfaceErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualInterfaceErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `DeleteVirtualInterfaceErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualInterfaceErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for DeleteVirtualInterfaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteVirtualInterfaceErrorKind::DirectConnectClientException(_inner) => Some(_inner),
            DeleteVirtualInterfaceErrorKind::DirectConnectServerException(_inner) => Some(_inner),
            DeleteVirtualInterfaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeConnectionLoa` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeConnectionLoaError {
    /// Kind of error that occurred.
    pub kind: DescribeConnectionLoaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeConnectionLoa` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeConnectionLoaErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeConnectionLoaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeConnectionLoaErrorKind::DirectConnectClientException(_inner) => _inner.fmt(f),
            DescribeConnectionLoaErrorKind::DirectConnectServerException(_inner) => _inner.fmt(f),
            DescribeConnectionLoaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeConnectionLoaError {
    fn code(&self) -> Option<&str> {
        DescribeConnectionLoaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeConnectionLoaError {
    /// Creates a new `DescribeConnectionLoaError`.
    pub fn new(kind: DescribeConnectionLoaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeConnectionLoaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeConnectionLoaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeConnectionLoaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeConnectionLoaErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeConnectionLoaErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectionLoaErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `DescribeConnectionLoaErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectionLoaErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for DescribeConnectionLoaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeConnectionLoaErrorKind::DirectConnectClientException(_inner) => Some(_inner),
            DescribeConnectionLoaErrorKind::DirectConnectServerException(_inner) => Some(_inner),
            DescribeConnectionLoaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeConnections` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeConnectionsError {
    /// Kind of error that occurred.
    pub kind: DescribeConnectionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeConnections` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeConnectionsErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeConnectionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeConnectionsErrorKind::DirectConnectClientException(_inner) => _inner.fmt(f),
            DescribeConnectionsErrorKind::DirectConnectServerException(_inner) => _inner.fmt(f),
            DescribeConnectionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeConnectionsError {
    fn code(&self) -> Option<&str> {
        DescribeConnectionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeConnectionsError {
    /// Creates a new `DescribeConnectionsError`.
    pub fn new(kind: DescribeConnectionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeConnectionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeConnectionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeConnectionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeConnectionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeConnectionsErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectionsErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `DescribeConnectionsErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectionsErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for DescribeConnectionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeConnectionsErrorKind::DirectConnectClientException(_inner) => Some(_inner),
            DescribeConnectionsErrorKind::DirectConnectServerException(_inner) => Some(_inner),
            DescribeConnectionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeConnectionsOnInterconnect` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeConnectionsOnInterconnectError {
    /// Kind of error that occurred.
    pub kind: DescribeConnectionsOnInterconnectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeConnectionsOnInterconnect` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeConnectionsOnInterconnectErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeConnectionsOnInterconnectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeConnectionsOnInterconnectErrorKind::DirectConnectClientException(_inner) => {
                _inner.fmt(f)
            }
            DescribeConnectionsOnInterconnectErrorKind::DirectConnectServerException(_inner) => {
                _inner.fmt(f)
            }
            DescribeConnectionsOnInterconnectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeConnectionsOnInterconnectError {
    fn code(&self) -> Option<&str> {
        DescribeConnectionsOnInterconnectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeConnectionsOnInterconnectError {
    /// Creates a new `DescribeConnectionsOnInterconnectError`.
    pub fn new(
        kind: DescribeConnectionsOnInterconnectErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeConnectionsOnInterconnectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeConnectionsOnInterconnectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeConnectionsOnInterconnectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeConnectionsOnInterconnectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeConnectionsOnInterconnectErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectionsOnInterconnectErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `DescribeConnectionsOnInterconnectErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectionsOnInterconnectErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for DescribeConnectionsOnInterconnectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeConnectionsOnInterconnectErrorKind::DirectConnectClientException(_inner) => {
                Some(_inner)
            }
            DescribeConnectionsOnInterconnectErrorKind::DirectConnectServerException(_inner) => {
                Some(_inner)
            }
            DescribeConnectionsOnInterconnectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDirectConnectGatewayAssociationProposals` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDirectConnectGatewayAssociationProposalsError {
    /// Kind of error that occurred.
    pub kind: DescribeDirectConnectGatewayAssociationProposalsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDirectConnectGatewayAssociationProposals` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDirectConnectGatewayAssociationProposalsErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDirectConnectGatewayAssociationProposalsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDirectConnectGatewayAssociationProposalsErrorKind::DirectConnectClientException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeDirectConnectGatewayAssociationProposalsErrorKind::DirectConnectServerException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeDirectConnectGatewayAssociationProposalsErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for DescribeDirectConnectGatewayAssociationProposalsError
{
    fn code(&self) -> Option<&str> {
        DescribeDirectConnectGatewayAssociationProposalsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDirectConnectGatewayAssociationProposalsError {
    /// Creates a new `DescribeDirectConnectGatewayAssociationProposalsError`.
    pub fn new(
        kind: DescribeDirectConnectGatewayAssociationProposalsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDirectConnectGatewayAssociationProposalsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDirectConnectGatewayAssociationProposalsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDirectConnectGatewayAssociationProposalsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDirectConnectGatewayAssociationProposalsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeDirectConnectGatewayAssociationProposalsErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDirectConnectGatewayAssociationProposalsErrorKind::DirectConnectClientException(
                _
            )
        )
    }
    /// Returns true if the error kind is `DescribeDirectConnectGatewayAssociationProposalsErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDirectConnectGatewayAssociationProposalsErrorKind::DirectConnectServerException(
                _
            )
        )
    }
}
impl std::error::Error for DescribeDirectConnectGatewayAssociationProposalsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDirectConnectGatewayAssociationProposalsErrorKind::DirectConnectClientException(_inner) =>
            Some(_inner)
            ,
            DescribeDirectConnectGatewayAssociationProposalsErrorKind::DirectConnectServerException(_inner) =>
            Some(_inner)
            ,
            DescribeDirectConnectGatewayAssociationProposalsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeDirectConnectGatewayAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDirectConnectGatewayAssociationsError {
    /// Kind of error that occurred.
    pub kind: DescribeDirectConnectGatewayAssociationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDirectConnectGatewayAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDirectConnectGatewayAssociationsErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDirectConnectGatewayAssociationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDirectConnectGatewayAssociationsErrorKind::DirectConnectClientException(
                _inner,
            ) => _inner.fmt(f),
            DescribeDirectConnectGatewayAssociationsErrorKind::DirectConnectServerException(
                _inner,
            ) => _inner.fmt(f),
            DescribeDirectConnectGatewayAssociationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDirectConnectGatewayAssociationsError {
    fn code(&self) -> Option<&str> {
        DescribeDirectConnectGatewayAssociationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDirectConnectGatewayAssociationsError {
    /// Creates a new `DescribeDirectConnectGatewayAssociationsError`.
    pub fn new(
        kind: DescribeDirectConnectGatewayAssociationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDirectConnectGatewayAssociationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDirectConnectGatewayAssociationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDirectConnectGatewayAssociationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDirectConnectGatewayAssociationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeDirectConnectGatewayAssociationsErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDirectConnectGatewayAssociationsErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `DescribeDirectConnectGatewayAssociationsErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDirectConnectGatewayAssociationsErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for DescribeDirectConnectGatewayAssociationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDirectConnectGatewayAssociationsErrorKind::DirectConnectClientException(
                _inner,
            ) => Some(_inner),
            DescribeDirectConnectGatewayAssociationsErrorKind::DirectConnectServerException(
                _inner,
            ) => Some(_inner),
            DescribeDirectConnectGatewayAssociationsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeDirectConnectGatewayAttachments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDirectConnectGatewayAttachmentsError {
    /// Kind of error that occurred.
    pub kind: DescribeDirectConnectGatewayAttachmentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDirectConnectGatewayAttachments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDirectConnectGatewayAttachmentsErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDirectConnectGatewayAttachmentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDirectConnectGatewayAttachmentsErrorKind::DirectConnectClientException(
                _inner,
            ) => _inner.fmt(f),
            DescribeDirectConnectGatewayAttachmentsErrorKind::DirectConnectServerException(
                _inner,
            ) => _inner.fmt(f),
            DescribeDirectConnectGatewayAttachmentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDirectConnectGatewayAttachmentsError {
    fn code(&self) -> Option<&str> {
        DescribeDirectConnectGatewayAttachmentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDirectConnectGatewayAttachmentsError {
    /// Creates a new `DescribeDirectConnectGatewayAttachmentsError`.
    pub fn new(
        kind: DescribeDirectConnectGatewayAttachmentsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDirectConnectGatewayAttachmentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDirectConnectGatewayAttachmentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDirectConnectGatewayAttachmentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDirectConnectGatewayAttachmentsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeDirectConnectGatewayAttachmentsErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDirectConnectGatewayAttachmentsErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `DescribeDirectConnectGatewayAttachmentsErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDirectConnectGatewayAttachmentsErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for DescribeDirectConnectGatewayAttachmentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDirectConnectGatewayAttachmentsErrorKind::DirectConnectClientException(
                _inner,
            ) => Some(_inner),
            DescribeDirectConnectGatewayAttachmentsErrorKind::DirectConnectServerException(
                _inner,
            ) => Some(_inner),
            DescribeDirectConnectGatewayAttachmentsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeDirectConnectGateways` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDirectConnectGatewaysError {
    /// Kind of error that occurred.
    pub kind: DescribeDirectConnectGatewaysErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDirectConnectGateways` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDirectConnectGatewaysErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDirectConnectGatewaysError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDirectConnectGatewaysErrorKind::DirectConnectClientException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDirectConnectGatewaysErrorKind::DirectConnectServerException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDirectConnectGatewaysErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDirectConnectGatewaysError {
    fn code(&self) -> Option<&str> {
        DescribeDirectConnectGatewaysError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDirectConnectGatewaysError {
    /// Creates a new `DescribeDirectConnectGatewaysError`.
    pub fn new(
        kind: DescribeDirectConnectGatewaysErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDirectConnectGatewaysError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDirectConnectGatewaysErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDirectConnectGatewaysError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDirectConnectGatewaysErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeDirectConnectGatewaysErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDirectConnectGatewaysErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `DescribeDirectConnectGatewaysErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDirectConnectGatewaysErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for DescribeDirectConnectGatewaysError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDirectConnectGatewaysErrorKind::DirectConnectClientException(_inner) => {
                Some(_inner)
            }
            DescribeDirectConnectGatewaysErrorKind::DirectConnectServerException(_inner) => {
                Some(_inner)
            }
            DescribeDirectConnectGatewaysErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeHostedConnections` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeHostedConnectionsError {
    /// Kind of error that occurred.
    pub kind: DescribeHostedConnectionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeHostedConnections` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeHostedConnectionsErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeHostedConnectionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeHostedConnectionsErrorKind::DirectConnectClientException(_inner) => {
                _inner.fmt(f)
            }
            DescribeHostedConnectionsErrorKind::DirectConnectServerException(_inner) => {
                _inner.fmt(f)
            }
            DescribeHostedConnectionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeHostedConnectionsError {
    fn code(&self) -> Option<&str> {
        DescribeHostedConnectionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeHostedConnectionsError {
    /// Creates a new `DescribeHostedConnectionsError`.
    pub fn new(kind: DescribeHostedConnectionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeHostedConnectionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeHostedConnectionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeHostedConnectionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeHostedConnectionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeHostedConnectionsErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeHostedConnectionsErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `DescribeHostedConnectionsErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeHostedConnectionsErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for DescribeHostedConnectionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeHostedConnectionsErrorKind::DirectConnectClientException(_inner) => {
                Some(_inner)
            }
            DescribeHostedConnectionsErrorKind::DirectConnectServerException(_inner) => {
                Some(_inner)
            }
            DescribeHostedConnectionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeInterconnectLoa` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeInterconnectLoaError {
    /// Kind of error that occurred.
    pub kind: DescribeInterconnectLoaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeInterconnectLoa` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeInterconnectLoaErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeInterconnectLoaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeInterconnectLoaErrorKind::DirectConnectClientException(_inner) => _inner.fmt(f),
            DescribeInterconnectLoaErrorKind::DirectConnectServerException(_inner) => _inner.fmt(f),
            DescribeInterconnectLoaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeInterconnectLoaError {
    fn code(&self) -> Option<&str> {
        DescribeInterconnectLoaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeInterconnectLoaError {
    /// Creates a new `DescribeInterconnectLoaError`.
    pub fn new(kind: DescribeInterconnectLoaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeInterconnectLoaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeInterconnectLoaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeInterconnectLoaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeInterconnectLoaErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeInterconnectLoaErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInterconnectLoaErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `DescribeInterconnectLoaErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInterconnectLoaErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for DescribeInterconnectLoaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeInterconnectLoaErrorKind::DirectConnectClientException(_inner) => Some(_inner),
            DescribeInterconnectLoaErrorKind::DirectConnectServerException(_inner) => Some(_inner),
            DescribeInterconnectLoaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeInterconnects` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeInterconnectsError {
    /// Kind of error that occurred.
    pub kind: DescribeInterconnectsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeInterconnects` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeInterconnectsErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeInterconnectsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeInterconnectsErrorKind::DirectConnectClientException(_inner) => _inner.fmt(f),
            DescribeInterconnectsErrorKind::DirectConnectServerException(_inner) => _inner.fmt(f),
            DescribeInterconnectsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeInterconnectsError {
    fn code(&self) -> Option<&str> {
        DescribeInterconnectsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeInterconnectsError {
    /// Creates a new `DescribeInterconnectsError`.
    pub fn new(kind: DescribeInterconnectsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeInterconnectsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeInterconnectsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeInterconnectsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeInterconnectsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeInterconnectsErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInterconnectsErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `DescribeInterconnectsErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInterconnectsErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for DescribeInterconnectsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeInterconnectsErrorKind::DirectConnectClientException(_inner) => Some(_inner),
            DescribeInterconnectsErrorKind::DirectConnectServerException(_inner) => Some(_inner),
            DescribeInterconnectsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeLags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLagsError {
    /// Kind of error that occurred.
    pub kind: DescribeLagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLagsErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLagsErrorKind::DirectConnectClientException(_inner) => _inner.fmt(f),
            DescribeLagsErrorKind::DirectConnectServerException(_inner) => _inner.fmt(f),
            DescribeLagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLagsError {
    fn code(&self) -> Option<&str> {
        DescribeLagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLagsError {
    /// Creates a new `DescribeLagsError`.
    pub fn new(kind: DescribeLagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeLagsErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLagsErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `DescribeLagsErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLagsErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for DescribeLagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLagsErrorKind::DirectConnectClientException(_inner) => Some(_inner),
            DescribeLagsErrorKind::DirectConnectServerException(_inner) => Some(_inner),
            DescribeLagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeLoa` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLoaError {
    /// Kind of error that occurred.
    pub kind: DescribeLoaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLoa` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLoaErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLoaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLoaErrorKind::DirectConnectClientException(_inner) => _inner.fmt(f),
            DescribeLoaErrorKind::DirectConnectServerException(_inner) => _inner.fmt(f),
            DescribeLoaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLoaError {
    fn code(&self) -> Option<&str> {
        DescribeLoaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLoaError {
    /// Creates a new `DescribeLoaError`.
    pub fn new(kind: DescribeLoaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLoaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLoaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLoaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLoaErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeLoaErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLoaErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `DescribeLoaErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLoaErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for DescribeLoaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLoaErrorKind::DirectConnectClientException(_inner) => Some(_inner),
            DescribeLoaErrorKind::DirectConnectServerException(_inner) => Some(_inner),
            DescribeLoaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeLocations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLocationsError {
    /// Kind of error that occurred.
    pub kind: DescribeLocationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLocations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLocationsErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLocationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLocationsErrorKind::DirectConnectClientException(_inner) => _inner.fmt(f),
            DescribeLocationsErrorKind::DirectConnectServerException(_inner) => _inner.fmt(f),
            DescribeLocationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLocationsError {
    fn code(&self) -> Option<&str> {
        DescribeLocationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLocationsError {
    /// Creates a new `DescribeLocationsError`.
    pub fn new(kind: DescribeLocationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLocationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLocationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLocationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLocationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeLocationsErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLocationsErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `DescribeLocationsErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLocationsErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for DescribeLocationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLocationsErrorKind::DirectConnectClientException(_inner) => Some(_inner),
            DescribeLocationsErrorKind::DirectConnectServerException(_inner) => Some(_inner),
            DescribeLocationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTagsError {
    /// Kind of error that occurred.
    pub kind: DescribeTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTagsErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTagsErrorKind::DirectConnectClientException(_inner) => _inner.fmt(f),
            DescribeTagsErrorKind::DirectConnectServerException(_inner) => _inner.fmt(f),
            DescribeTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTagsError {
    fn code(&self) -> Option<&str> {
        DescribeTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTagsError {
    /// Creates a new `DescribeTagsError`.
    pub fn new(kind: DescribeTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeTagsErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTagsErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `DescribeTagsErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTagsErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for DescribeTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTagsErrorKind::DirectConnectClientException(_inner) => Some(_inner),
            DescribeTagsErrorKind::DirectConnectServerException(_inner) => Some(_inner),
            DescribeTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeVirtualGateways` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeVirtualGatewaysError {
    /// Kind of error that occurred.
    pub kind: DescribeVirtualGatewaysErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeVirtualGateways` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeVirtualGatewaysErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeVirtualGatewaysError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeVirtualGatewaysErrorKind::DirectConnectClientException(_inner) => _inner.fmt(f),
            DescribeVirtualGatewaysErrorKind::DirectConnectServerException(_inner) => _inner.fmt(f),
            DescribeVirtualGatewaysErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeVirtualGatewaysError {
    fn code(&self) -> Option<&str> {
        DescribeVirtualGatewaysError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeVirtualGatewaysError {
    /// Creates a new `DescribeVirtualGatewaysError`.
    pub fn new(kind: DescribeVirtualGatewaysErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeVirtualGatewaysError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeVirtualGatewaysErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeVirtualGatewaysError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeVirtualGatewaysErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeVirtualGatewaysErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVirtualGatewaysErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `DescribeVirtualGatewaysErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVirtualGatewaysErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for DescribeVirtualGatewaysError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeVirtualGatewaysErrorKind::DirectConnectClientException(_inner) => Some(_inner),
            DescribeVirtualGatewaysErrorKind::DirectConnectServerException(_inner) => Some(_inner),
            DescribeVirtualGatewaysErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeVirtualInterfaces` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeVirtualInterfacesError {
    /// Kind of error that occurred.
    pub kind: DescribeVirtualInterfacesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeVirtualInterfaces` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeVirtualInterfacesErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeVirtualInterfacesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeVirtualInterfacesErrorKind::DirectConnectClientException(_inner) => {
                _inner.fmt(f)
            }
            DescribeVirtualInterfacesErrorKind::DirectConnectServerException(_inner) => {
                _inner.fmt(f)
            }
            DescribeVirtualInterfacesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeVirtualInterfacesError {
    fn code(&self) -> Option<&str> {
        DescribeVirtualInterfacesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeVirtualInterfacesError {
    /// Creates a new `DescribeVirtualInterfacesError`.
    pub fn new(kind: DescribeVirtualInterfacesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeVirtualInterfacesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeVirtualInterfacesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeVirtualInterfacesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeVirtualInterfacesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeVirtualInterfacesErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVirtualInterfacesErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `DescribeVirtualInterfacesErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVirtualInterfacesErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for DescribeVirtualInterfacesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeVirtualInterfacesErrorKind::DirectConnectClientException(_inner) => {
                Some(_inner)
            }
            DescribeVirtualInterfacesErrorKind::DirectConnectServerException(_inner) => {
                Some(_inner)
            }
            DescribeVirtualInterfacesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateConnectionFromLag` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateConnectionFromLagError {
    /// Kind of error that occurred.
    pub kind: DisassociateConnectionFromLagErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateConnectionFromLag` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateConnectionFromLagErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateConnectionFromLagError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateConnectionFromLagErrorKind::DirectConnectClientException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateConnectionFromLagErrorKind::DirectConnectServerException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateConnectionFromLagErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateConnectionFromLagError {
    fn code(&self) -> Option<&str> {
        DisassociateConnectionFromLagError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateConnectionFromLagError {
    /// Creates a new `DisassociateConnectionFromLagError`.
    pub fn new(
        kind: DisassociateConnectionFromLagErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateConnectionFromLagError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateConnectionFromLagErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateConnectionFromLagError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateConnectionFromLagErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DisassociateConnectionFromLagErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateConnectionFromLagErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateConnectionFromLagErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateConnectionFromLagErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for DisassociateConnectionFromLagError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateConnectionFromLagErrorKind::DirectConnectClientException(_inner) => {
                Some(_inner)
            }
            DisassociateConnectionFromLagErrorKind::DirectConnectServerException(_inner) => {
                Some(_inner)
            }
            DisassociateConnectionFromLagErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateMacSecKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateMacSecKeyError {
    /// Kind of error that occurred.
    pub kind: DisassociateMacSecKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateMacSecKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateMacSecKeyErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateMacSecKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateMacSecKeyErrorKind::DirectConnectClientException(_inner) => _inner.fmt(f),
            DisassociateMacSecKeyErrorKind::DirectConnectServerException(_inner) => _inner.fmt(f),
            DisassociateMacSecKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateMacSecKeyError {
    fn code(&self) -> Option<&str> {
        DisassociateMacSecKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateMacSecKeyError {
    /// Creates a new `DisassociateMacSecKeyError`.
    pub fn new(kind: DisassociateMacSecKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateMacSecKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateMacSecKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateMacSecKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateMacSecKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DisassociateMacSecKeyErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateMacSecKeyErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateMacSecKeyErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateMacSecKeyErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for DisassociateMacSecKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateMacSecKeyErrorKind::DirectConnectClientException(_inner) => Some(_inner),
            DisassociateMacSecKeyErrorKind::DirectConnectServerException(_inner) => Some(_inner),
            DisassociateMacSecKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListVirtualInterfaceTestHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListVirtualInterfaceTestHistoryError {
    /// Kind of error that occurred.
    pub kind: ListVirtualInterfaceTestHistoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListVirtualInterfaceTestHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListVirtualInterfaceTestHistoryErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListVirtualInterfaceTestHistoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListVirtualInterfaceTestHistoryErrorKind::DirectConnectClientException(_inner) => {
                _inner.fmt(f)
            }
            ListVirtualInterfaceTestHistoryErrorKind::DirectConnectServerException(_inner) => {
                _inner.fmt(f)
            }
            ListVirtualInterfaceTestHistoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListVirtualInterfaceTestHistoryError {
    fn code(&self) -> Option<&str> {
        ListVirtualInterfaceTestHistoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListVirtualInterfaceTestHistoryError {
    /// Creates a new `ListVirtualInterfaceTestHistoryError`.
    pub fn new(
        kind: ListVirtualInterfaceTestHistoryErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListVirtualInterfaceTestHistoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListVirtualInterfaceTestHistoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListVirtualInterfaceTestHistoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListVirtualInterfaceTestHistoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListVirtualInterfaceTestHistoryErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVirtualInterfaceTestHistoryErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `ListVirtualInterfaceTestHistoryErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVirtualInterfaceTestHistoryErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for ListVirtualInterfaceTestHistoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListVirtualInterfaceTestHistoryErrorKind::DirectConnectClientException(_inner) => {
                Some(_inner)
            }
            ListVirtualInterfaceTestHistoryErrorKind::DirectConnectServerException(_inner) => {
                Some(_inner)
            }
            ListVirtualInterfaceTestHistoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartBgpFailoverTest` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartBgpFailoverTestError {
    /// Kind of error that occurred.
    pub kind: StartBgpFailoverTestErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartBgpFailoverTest` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartBgpFailoverTestErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartBgpFailoverTestError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartBgpFailoverTestErrorKind::DirectConnectClientException(_inner) => _inner.fmt(f),
            StartBgpFailoverTestErrorKind::DirectConnectServerException(_inner) => _inner.fmt(f),
            StartBgpFailoverTestErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartBgpFailoverTestError {
    fn code(&self) -> Option<&str> {
        StartBgpFailoverTestError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartBgpFailoverTestError {
    /// Creates a new `StartBgpFailoverTestError`.
    pub fn new(kind: StartBgpFailoverTestErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartBgpFailoverTestError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartBgpFailoverTestErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartBgpFailoverTestError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartBgpFailoverTestErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `StartBgpFailoverTestErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartBgpFailoverTestErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `StartBgpFailoverTestErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartBgpFailoverTestErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for StartBgpFailoverTestError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartBgpFailoverTestErrorKind::DirectConnectClientException(_inner) => Some(_inner),
            StartBgpFailoverTestErrorKind::DirectConnectServerException(_inner) => Some(_inner),
            StartBgpFailoverTestErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopBgpFailoverTest` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopBgpFailoverTestError {
    /// Kind of error that occurred.
    pub kind: StopBgpFailoverTestErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopBgpFailoverTest` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopBgpFailoverTestErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopBgpFailoverTestError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopBgpFailoverTestErrorKind::DirectConnectClientException(_inner) => _inner.fmt(f),
            StopBgpFailoverTestErrorKind::DirectConnectServerException(_inner) => _inner.fmt(f),
            StopBgpFailoverTestErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopBgpFailoverTestError {
    fn code(&self) -> Option<&str> {
        StopBgpFailoverTestError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopBgpFailoverTestError {
    /// Creates a new `StopBgpFailoverTestError`.
    pub fn new(kind: StopBgpFailoverTestErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopBgpFailoverTestError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopBgpFailoverTestErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopBgpFailoverTestError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopBgpFailoverTestErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `StopBgpFailoverTestErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopBgpFailoverTestErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `StopBgpFailoverTestErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopBgpFailoverTestErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for StopBgpFailoverTestError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopBgpFailoverTestErrorKind::DirectConnectClientException(_inner) => Some(_inner),
            StopBgpFailoverTestErrorKind::DirectConnectServerException(_inner) => Some(_inner),
            StopBgpFailoverTestErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// <p>A tag key was specified more than once.</p>
    DuplicateTagKeysException(crate::error::DuplicateTagKeysException),
    /// <p>You have reached the limit on the number of tags that can be assigned.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::DirectConnectClientException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::DirectConnectServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::DuplicateTagKeysException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `TagResourceErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::DirectConnectServerException(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::DuplicateTagKeysException`.
    pub fn is_duplicate_tag_keys_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::DuplicateTagKeysException(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::TooManyTagsException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::DirectConnectClientException(_inner) => Some(_inner),
            TagResourceErrorKind::DirectConnectServerException(_inner) => Some(_inner),
            TagResourceErrorKind::DuplicateTagKeysException(_inner) => Some(_inner),
            TagResourceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::DirectConnectClientException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::DirectConnectServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::DirectConnectClientException(_inner) => Some(_inner),
            UntagResourceErrorKind::DirectConnectServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateConnectionError {
    /// Kind of error that occurred.
    pub kind: UpdateConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateConnectionErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateConnectionErrorKind::DirectConnectClientException(_inner) => _inner.fmt(f),
            UpdateConnectionErrorKind::DirectConnectServerException(_inner) => _inner.fmt(f),
            UpdateConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateConnectionError {
    fn code(&self) -> Option<&str> {
        UpdateConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateConnectionError {
    /// Creates a new `UpdateConnectionError`.
    pub fn new(kind: UpdateConnectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateConnectionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateConnectionErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectionErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `UpdateConnectionErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectionErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for UpdateConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateConnectionErrorKind::DirectConnectClientException(_inner) => Some(_inner),
            UpdateConnectionErrorKind::DirectConnectServerException(_inner) => Some(_inner),
            UpdateConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDirectConnectGatewayAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDirectConnectGatewayAssociationError {
    /// Kind of error that occurred.
    pub kind: UpdateDirectConnectGatewayAssociationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDirectConnectGatewayAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDirectConnectGatewayAssociationErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDirectConnectGatewayAssociationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDirectConnectGatewayAssociationErrorKind::DirectConnectClientException(
                _inner,
            ) => _inner.fmt(f),
            UpdateDirectConnectGatewayAssociationErrorKind::DirectConnectServerException(
                _inner,
            ) => _inner.fmt(f),
            UpdateDirectConnectGatewayAssociationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDirectConnectGatewayAssociationError {
    fn code(&self) -> Option<&str> {
        UpdateDirectConnectGatewayAssociationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDirectConnectGatewayAssociationError {
    /// Creates a new `UpdateDirectConnectGatewayAssociationError`.
    pub fn new(
        kind: UpdateDirectConnectGatewayAssociationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDirectConnectGatewayAssociationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDirectConnectGatewayAssociationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDirectConnectGatewayAssociationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDirectConnectGatewayAssociationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateDirectConnectGatewayAssociationErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDirectConnectGatewayAssociationErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDirectConnectGatewayAssociationErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDirectConnectGatewayAssociationErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for UpdateDirectConnectGatewayAssociationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDirectConnectGatewayAssociationErrorKind::DirectConnectClientException(
                _inner,
            ) => Some(_inner),
            UpdateDirectConnectGatewayAssociationErrorKind::DirectConnectServerException(
                _inner,
            ) => Some(_inner),
            UpdateDirectConnectGatewayAssociationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `UpdateLag` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateLagError {
    /// Kind of error that occurred.
    pub kind: UpdateLagErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateLag` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateLagErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateLagError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateLagErrorKind::DirectConnectClientException(_inner) => _inner.fmt(f),
            UpdateLagErrorKind::DirectConnectServerException(_inner) => _inner.fmt(f),
            UpdateLagErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateLagError {
    fn code(&self) -> Option<&str> {
        UpdateLagError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateLagError {
    /// Creates a new `UpdateLagError`.
    pub fn new(kind: UpdateLagErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateLagError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateLagErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateLagError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateLagErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateLagErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLagErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `UpdateLagErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLagErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for UpdateLagError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateLagErrorKind::DirectConnectClientException(_inner) => Some(_inner),
            UpdateLagErrorKind::DirectConnectServerException(_inner) => Some(_inner),
            UpdateLagErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateVirtualInterfaceAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateVirtualInterfaceAttributesError {
    /// Kind of error that occurred.
    pub kind: UpdateVirtualInterfaceAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateVirtualInterfaceAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateVirtualInterfaceAttributesErrorKind {
    /// <p>One or more parameters are not valid.</p>
    DirectConnectClientException(crate::error::DirectConnectClientException),
    /// <p>A server-side error occurred.</p>
    DirectConnectServerException(crate::error::DirectConnectServerException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateVirtualInterfaceAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateVirtualInterfaceAttributesErrorKind::DirectConnectClientException(_inner) => {
                _inner.fmt(f)
            }
            UpdateVirtualInterfaceAttributesErrorKind::DirectConnectServerException(_inner) => {
                _inner.fmt(f)
            }
            UpdateVirtualInterfaceAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateVirtualInterfaceAttributesError {
    fn code(&self) -> Option<&str> {
        UpdateVirtualInterfaceAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateVirtualInterfaceAttributesError {
    /// Creates a new `UpdateVirtualInterfaceAttributesError`.
    pub fn new(
        kind: UpdateVirtualInterfaceAttributesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateVirtualInterfaceAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateVirtualInterfaceAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateVirtualInterfaceAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateVirtualInterfaceAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateVirtualInterfaceAttributesErrorKind::DirectConnectClientException`.
    pub fn is_direct_connect_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVirtualInterfaceAttributesErrorKind::DirectConnectClientException(_)
        )
    }
    /// Returns true if the error kind is `UpdateVirtualInterfaceAttributesErrorKind::DirectConnectServerException`.
    pub fn is_direct_connect_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVirtualInterfaceAttributesErrorKind::DirectConnectServerException(_)
        )
    }
}
impl std::error::Error for UpdateVirtualInterfaceAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateVirtualInterfaceAttributesErrorKind::DirectConnectClientException(_inner) => {
                Some(_inner)
            }
            UpdateVirtualInterfaceAttributesErrorKind::DirectConnectServerException(_inner) => {
                Some(_inner)
            }
            UpdateVirtualInterfaceAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>A server-side error occurred.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DirectConnectServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DirectConnectServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DirectConnectServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DirectConnectServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DirectConnectServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DirectConnectServerException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for DirectConnectServerException {}
/// See [`DirectConnectServerException`](crate::error::DirectConnectServerException)
pub mod direct_connect_server_exception {
    /// A builder for [`DirectConnectServerException`](crate::error::DirectConnectServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DirectConnectServerException`](crate::error::DirectConnectServerException)
        pub fn build(self) -> crate::error::DirectConnectServerException {
            crate::error::DirectConnectServerException {
                message: self.message,
            }
        }
    }
}
impl DirectConnectServerException {
    /// Creates a new builder-style object to manufacture [`DirectConnectServerException`](crate::error::DirectConnectServerException)
    pub fn builder() -> crate::error::direct_connect_server_exception::Builder {
        crate::error::direct_connect_server_exception::Builder::default()
    }
}

/// <p>One or more parameters are not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DirectConnectClientException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DirectConnectClientException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DirectConnectClientException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DirectConnectClientException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DirectConnectClientException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DirectConnectClientException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for DirectConnectClientException {}
/// See [`DirectConnectClientException`](crate::error::DirectConnectClientException)
pub mod direct_connect_client_exception {
    /// A builder for [`DirectConnectClientException`](crate::error::DirectConnectClientException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DirectConnectClientException`](crate::error::DirectConnectClientException)
        pub fn build(self) -> crate::error::DirectConnectClientException {
            crate::error::DirectConnectClientException {
                message: self.message,
            }
        }
    }
}
impl DirectConnectClientException {
    /// Creates a new builder-style object to manufacture [`DirectConnectClientException`](crate::error::DirectConnectClientException)
    pub fn builder() -> crate::error::direct_connect_client_exception::Builder {
        crate::error::direct_connect_client_exception::Builder::default()
    }
}

/// <p>You have reached the limit on the number of tags that can be assigned.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTagsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTagsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyTagsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTagsException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTagsException {}
/// See [`TooManyTagsException`](crate::error::TooManyTagsException)
pub mod too_many_tags_exception {
    /// A builder for [`TooManyTagsException`](crate::error::TooManyTagsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTagsException`](crate::error::TooManyTagsException)
        pub fn build(self) -> crate::error::TooManyTagsException {
            crate::error::TooManyTagsException {
                message: self.message,
            }
        }
    }
}
impl TooManyTagsException {
    /// Creates a new builder-style object to manufacture [`TooManyTagsException`](crate::error::TooManyTagsException)
    pub fn builder() -> crate::error::too_many_tags_exception::Builder {
        crate::error::too_many_tags_exception::Builder::default()
    }
}

/// <p>A tag key was specified more than once.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DuplicateTagKeysException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DuplicateTagKeysException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DuplicateTagKeysException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DuplicateTagKeysException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DuplicateTagKeysException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DuplicateTagKeysException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for DuplicateTagKeysException {}
/// See [`DuplicateTagKeysException`](crate::error::DuplicateTagKeysException)
pub mod duplicate_tag_keys_exception {
    /// A builder for [`DuplicateTagKeysException`](crate::error::DuplicateTagKeysException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DuplicateTagKeysException`](crate::error::DuplicateTagKeysException)
        pub fn build(self) -> crate::error::DuplicateTagKeysException {
            crate::error::DuplicateTagKeysException {
                message: self.message,
            }
        }
    }
}
impl DuplicateTagKeysException {
    /// Creates a new builder-style object to manufacture [`DuplicateTagKeysException`](crate::error::DuplicateTagKeysException)
    pub fn builder() -> crate::error::duplicate_tag_keys_exception::Builder {
        crate::error::duplicate_tag_keys_exception::Builder::default()
    }
}
