// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p> The field associated with the validation exception. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationExceptionField {
    /// <p> The name of the field. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The message associated with the validation exception with information to help determine its cause. </p>
    pub message: std::option::Option<std::string::String>,
}
impl ValidationExceptionField {
    /// <p> The name of the field. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> The message associated with the validation exception with information to help determine its cause. </p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for ValidationExceptionField {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationExceptionField");
        formatter.field("name", &self.name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ValidationExceptionField`](crate::model::ValidationExceptionField)
pub mod validation_exception_field {
    /// A builder for [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the field. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the field. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The message associated with the validation exception with information to help determine its cause. </p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p> The message associated with the validation exception with information to help determine its cause. </p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationExceptionField`](crate::model::ValidationExceptionField)
        pub fn build(self) -> crate::model::ValidationExceptionField {
            crate::model::ValidationExceptionField {
                name: self.name,
                message: self.message,
            }
        }
    }
}
impl ValidationExceptionField {
    /// Creates a new builder-style object to manufacture [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    pub fn builder() -> crate::model::validation_exception_field::Builder {
        crate::model::validation_exception_field::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ValidationExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    CannotParse,
    #[allow(missing_docs)] // documentation missing in model
    FieldValidationFailed,
    #[allow(missing_docs)] // documentation missing in model
    InvalidParameterCombination,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    ParameterInconsistentWithServiceState,
    #[allow(missing_docs)] // documentation missing in model
    UnknownOperation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ValidationExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "CANNOT_PARSE" => ValidationExceptionReason::CannotParse,
            "FIELD_VALIDATION_FAILED" => ValidationExceptionReason::FieldValidationFailed,
            "INVALID_PARAMETER_COMBINATION" => {
                ValidationExceptionReason::InvalidParameterCombination
            }
            "OTHER" => ValidationExceptionReason::Other,
            "PARAMETER_INCONSISTENT_WITH_SERVICE_STATE" => {
                ValidationExceptionReason::ParameterInconsistentWithServiceState
            }
            "UNKNOWN_OPERATION" => ValidationExceptionReason::UnknownOperation,
            other => ValidationExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ValidationExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ValidationExceptionReason::from(s))
    }
}
impl ValidationExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ValidationExceptionReason::CannotParse => "CANNOT_PARSE",
            ValidationExceptionReason::FieldValidationFailed => "FIELD_VALIDATION_FAILED",
            ValidationExceptionReason::InvalidParameterCombination => {
                "INVALID_PARAMETER_COMBINATION"
            }
            ValidationExceptionReason::Other => "OTHER",
            ValidationExceptionReason::ParameterInconsistentWithServiceState => {
                "PARAMETER_INCONSISTENT_WITH_SERVICE_STATE"
            }
            ValidationExceptionReason::UnknownOperation => "UNKNOWN_OPERATION",
            ValidationExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANNOT_PARSE",
            "FIELD_VALIDATION_FAILED",
            "INVALID_PARAMETER_COMBINATION",
            "OTHER",
            "PARAMETER_INCONSISTENT_WITH_SERVICE_STATE",
            "UNKNOWN_OPERATION",
        ]
    }
}
impl AsRef<str> for ValidationExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Information about updating the integration status of an Amazon Web Services service, such as Amazon Web Services Systems Manager, with DevOps Guru. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateServiceIntegrationConfig {
    /// <p> Information about whether DevOps Guru is configured to create an OpsItem in Amazon Web Services Systems Manager OpsCenter for each created insight. </p>
    pub ops_center: std::option::Option<crate::model::OpsCenterIntegrationConfig>,
}
impl UpdateServiceIntegrationConfig {
    /// <p> Information about whether DevOps Guru is configured to create an OpsItem in Amazon Web Services Systems Manager OpsCenter for each created insight. </p>
    pub fn ops_center(&self) -> std::option::Option<&crate::model::OpsCenterIntegrationConfig> {
        self.ops_center.as_ref()
    }
}
impl std::fmt::Debug for UpdateServiceIntegrationConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateServiceIntegrationConfig");
        formatter.field("ops_center", &self.ops_center);
        formatter.finish()
    }
}
/// See [`UpdateServiceIntegrationConfig`](crate::model::UpdateServiceIntegrationConfig)
pub mod update_service_integration_config {
    /// A builder for [`UpdateServiceIntegrationConfig`](crate::model::UpdateServiceIntegrationConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ops_center: std::option::Option<crate::model::OpsCenterIntegrationConfig>,
    }
    impl Builder {
        /// <p> Information about whether DevOps Guru is configured to create an OpsItem in Amazon Web Services Systems Manager OpsCenter for each created insight. </p>
        pub fn ops_center(mut self, input: crate::model::OpsCenterIntegrationConfig) -> Self {
            self.ops_center = Some(input);
            self
        }
        /// <p> Information about whether DevOps Guru is configured to create an OpsItem in Amazon Web Services Systems Manager OpsCenter for each created insight. </p>
        pub fn set_ops_center(
            mut self,
            input: std::option::Option<crate::model::OpsCenterIntegrationConfig>,
        ) -> Self {
            self.ops_center = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateServiceIntegrationConfig`](crate::model::UpdateServiceIntegrationConfig)
        pub fn build(self) -> crate::model::UpdateServiceIntegrationConfig {
            crate::model::UpdateServiceIntegrationConfig {
                ops_center: self.ops_center,
            }
        }
    }
}
impl UpdateServiceIntegrationConfig {
    /// Creates a new builder-style object to manufacture [`UpdateServiceIntegrationConfig`](crate::model::UpdateServiceIntegrationConfig)
    pub fn builder() -> crate::model::update_service_integration_config::Builder {
        crate::model::update_service_integration_config::Builder::default()
    }
}

/// <p> Information about whether DevOps Guru is configured to create an OpsItem in Amazon Web Services Systems Manager OpsCenter for each created insight. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpsCenterIntegrationConfig {
    /// <p> Specifies if DevOps Guru is enabled to create an Amazon Web Services Systems Manager OpsItem for each created insight. </p>
    pub opt_in_status: std::option::Option<crate::model::OptInStatus>,
}
impl OpsCenterIntegrationConfig {
    /// <p> Specifies if DevOps Guru is enabled to create an Amazon Web Services Systems Manager OpsItem for each created insight. </p>
    pub fn opt_in_status(&self) -> std::option::Option<&crate::model::OptInStatus> {
        self.opt_in_status.as_ref()
    }
}
impl std::fmt::Debug for OpsCenterIntegrationConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpsCenterIntegrationConfig");
        formatter.field("opt_in_status", &self.opt_in_status);
        formatter.finish()
    }
}
/// See [`OpsCenterIntegrationConfig`](crate::model::OpsCenterIntegrationConfig)
pub mod ops_center_integration_config {
    /// A builder for [`OpsCenterIntegrationConfig`](crate::model::OpsCenterIntegrationConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) opt_in_status: std::option::Option<crate::model::OptInStatus>,
    }
    impl Builder {
        /// <p> Specifies if DevOps Guru is enabled to create an Amazon Web Services Systems Manager OpsItem for each created insight. </p>
        pub fn opt_in_status(mut self, input: crate::model::OptInStatus) -> Self {
            self.opt_in_status = Some(input);
            self
        }
        /// <p> Specifies if DevOps Guru is enabled to create an Amazon Web Services Systems Manager OpsItem for each created insight. </p>
        pub fn set_opt_in_status(
            mut self,
            input: std::option::Option<crate::model::OptInStatus>,
        ) -> Self {
            self.opt_in_status = input;
            self
        }
        /// Consumes the builder and constructs a [`OpsCenterIntegrationConfig`](crate::model::OpsCenterIntegrationConfig)
        pub fn build(self) -> crate::model::OpsCenterIntegrationConfig {
            crate::model::OpsCenterIntegrationConfig {
                opt_in_status: self.opt_in_status,
            }
        }
    }
}
impl OpsCenterIntegrationConfig {
    /// Creates a new builder-style object to manufacture [`OpsCenterIntegrationConfig`](crate::model::OpsCenterIntegrationConfig)
    pub fn builder() -> crate::model::ops_center_integration_config::Builder {
        crate::model::ops_center_integration_config::Builder::default()
    }
}

/// <p> Specifies if DevOps Guru is enabled to create an Amazon Web Services Systems Manager OpsItem for each created
/// insight. </p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OptInStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OptInStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => OptInStatus::Disabled,
            "ENABLED" => OptInStatus::Enabled,
            other => OptInStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OptInStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OptInStatus::from(s))
    }
}
impl OptInStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OptInStatus::Disabled => "DISABLED",
            OptInStatus::Enabled => "ENABLED",
            OptInStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for OptInStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Contains information used to update a collection of Amazon Web Services resources. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateResourceCollectionFilter {
    /// <p> A collection of Amazon Web Services CloudFormation stacks. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub cloud_formation: std::option::Option<crate::model::UpdateCloudFormationCollectionFilter>,
    /// <p>The updated Amazon Web Services tags used to filter the resources in the resource collection.</p>
    /// <p>Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an Lambda function. For more information about using tags, see the <a href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best practices</a> whitepaper. </p>
    /// <p>Each Amazon Web Services tag has two parts. </p>
    /// <ul>
    /// <li> <p>A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag <i>keys</i> are case-sensitive.</p> </li>
    /// <li> <p>An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.</p> </li>
    /// </ul>
    /// <p>Together these are known as <i>key</i>-<i>value</i> pairs.</p> <important>
    /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
    /// </important>
    pub tags: std::option::Option<std::vec::Vec<crate::model::UpdateTagCollectionFilter>>,
}
impl UpdateResourceCollectionFilter {
    /// <p> A collection of Amazon Web Services CloudFormation stacks. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub fn cloud_formation(
        &self,
    ) -> std::option::Option<&crate::model::UpdateCloudFormationCollectionFilter> {
        self.cloud_formation.as_ref()
    }
    /// <p>The updated Amazon Web Services tags used to filter the resources in the resource collection.</p>
    /// <p>Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an Lambda function. For more information about using tags, see the <a href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best practices</a> whitepaper. </p>
    /// <p>Each Amazon Web Services tag has two parts. </p>
    /// <ul>
    /// <li> <p>A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag <i>keys</i> are case-sensitive.</p> </li>
    /// <li> <p>An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.</p> </li>
    /// </ul>
    /// <p>Together these are known as <i>key</i>-<i>value</i> pairs.</p> <important>
    /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
    /// </important>
    pub fn tags(&self) -> std::option::Option<&[crate::model::UpdateTagCollectionFilter]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for UpdateResourceCollectionFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateResourceCollectionFilter");
        formatter.field("cloud_formation", &self.cloud_formation);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`UpdateResourceCollectionFilter`](crate::model::UpdateResourceCollectionFilter)
pub mod update_resource_collection_filter {
    /// A builder for [`UpdateResourceCollectionFilter`](crate::model::UpdateResourceCollectionFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_formation:
            std::option::Option<crate::model::UpdateCloudFormationCollectionFilter>,
        pub(crate) tags:
            std::option::Option<std::vec::Vec<crate::model::UpdateTagCollectionFilter>>,
    }
    impl Builder {
        /// <p> A collection of Amazon Web Services CloudFormation stacks. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn cloud_formation(
            mut self,
            input: crate::model::UpdateCloudFormationCollectionFilter,
        ) -> Self {
            self.cloud_formation = Some(input);
            self
        }
        /// <p> A collection of Amazon Web Services CloudFormation stacks. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn set_cloud_formation(
            mut self,
            input: std::option::Option<crate::model::UpdateCloudFormationCollectionFilter>,
        ) -> Self {
            self.cloud_formation = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The updated Amazon Web Services tags used to filter the resources in the resource collection.</p>
        /// <p>Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an Lambda function. For more information about using tags, see the <a href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best practices</a> whitepaper. </p>
        /// <p>Each Amazon Web Services tag has two parts. </p>
        /// <ul>
        /// <li> <p>A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag <i>keys</i> are case-sensitive.</p> </li>
        /// <li> <p>An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.</p> </li>
        /// </ul>
        /// <p>Together these are known as <i>key</i>-<i>value</i> pairs.</p> <important>
        /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
        /// </important>
        pub fn tags(mut self, input: crate::model::UpdateTagCollectionFilter) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The updated Amazon Web Services tags used to filter the resources in the resource collection.</p>
        /// <p>Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an Lambda function. For more information about using tags, see the <a href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best practices</a> whitepaper. </p>
        /// <p>Each Amazon Web Services tag has two parts. </p>
        /// <ul>
        /// <li> <p>A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag <i>keys</i> are case-sensitive.</p> </li>
        /// <li> <p>An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.</p> </li>
        /// </ul>
        /// <p>Together these are known as <i>key</i>-<i>value</i> pairs.</p> <important>
        /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
        /// </important>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpdateTagCollectionFilter>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateResourceCollectionFilter`](crate::model::UpdateResourceCollectionFilter)
        pub fn build(self) -> crate::model::UpdateResourceCollectionFilter {
            crate::model::UpdateResourceCollectionFilter {
                cloud_formation: self.cloud_formation,
                tags: self.tags,
            }
        }
    }
}
impl UpdateResourceCollectionFilter {
    /// Creates a new builder-style object to manufacture [`UpdateResourceCollectionFilter`](crate::model::UpdateResourceCollectionFilter)
    pub fn builder() -> crate::model::update_resource_collection_filter::Builder {
        crate::model::update_resource_collection_filter::Builder::default()
    }
}

/// <p>A new collection of Amazon Web Services resources that are defined by an Amazon Web Services tag or tag <i>key</i>/<i>value</i> pair.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTagCollectionFilter {
    /// <p>An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this <i>key</i> make up your DevOps Guru application and analysis boundary.</p> <important>
    /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
    /// </important>
    pub app_boundary_key: std::option::Option<std::string::String>,
    /// <p>The values in an Amazon Web Services tag collection.</p>
    /// <p>The tag's <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and <i>value</i> are the tag's <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of 256 characters for a tag value.</p>
    pub tag_values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UpdateTagCollectionFilter {
    /// <p>An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this <i>key</i> make up your DevOps Guru application and analysis boundary.</p> <important>
    /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
    /// </important>
    pub fn app_boundary_key(&self) -> std::option::Option<&str> {
        self.app_boundary_key.as_deref()
    }
    /// <p>The values in an Amazon Web Services tag collection.</p>
    /// <p>The tag's <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and <i>value</i> are the tag's <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of 256 characters for a tag value.</p>
    pub fn tag_values(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_values.as_deref()
    }
}
impl std::fmt::Debug for UpdateTagCollectionFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTagCollectionFilter");
        formatter.field("app_boundary_key", &self.app_boundary_key);
        formatter.field("tag_values", &self.tag_values);
        formatter.finish()
    }
}
/// See [`UpdateTagCollectionFilter`](crate::model::UpdateTagCollectionFilter)
pub mod update_tag_collection_filter {
    /// A builder for [`UpdateTagCollectionFilter`](crate::model::UpdateTagCollectionFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_boundary_key: std::option::Option<std::string::String>,
        pub(crate) tag_values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this <i>key</i> make up your DevOps Guru application and analysis boundary.</p> <important>
        /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
        /// </important>
        pub fn app_boundary_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_boundary_key = Some(input.into());
            self
        }
        /// <p>An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this <i>key</i> make up your DevOps Guru application and analysis boundary.</p> <important>
        /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
        /// </important>
        pub fn set_app_boundary_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_boundary_key = input;
            self
        }
        /// Appends an item to `tag_values`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>The values in an Amazon Web Services tag collection.</p>
        /// <p>The tag's <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and <i>value</i> are the tag's <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of 256 characters for a tag value.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_values.unwrap_or_default();
            v.push(input.into());
            self.tag_values = Some(v);
            self
        }
        /// <p>The values in an Amazon Web Services tag collection.</p>
        /// <p>The tag's <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and <i>value</i> are the tag's <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of 256 characters for a tag value.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_values = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTagCollectionFilter`](crate::model::UpdateTagCollectionFilter)
        pub fn build(self) -> crate::model::UpdateTagCollectionFilter {
            crate::model::UpdateTagCollectionFilter {
                app_boundary_key: self.app_boundary_key,
                tag_values: self.tag_values,
            }
        }
    }
}
impl UpdateTagCollectionFilter {
    /// Creates a new builder-style object to manufacture [`UpdateTagCollectionFilter`](crate::model::UpdateTagCollectionFilter)
    pub fn builder() -> crate::model::update_tag_collection_filter::Builder {
        crate::model::update_tag_collection_filter::Builder::default()
    }
}

/// <p> Contains the names of Amazon Web Services CloudFormation stacks used to update a collection of stacks. You can specify up to 500 Amazon Web Services CloudFormation stacks.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCloudFormationCollectionFilter {
    /// <p> An array of the names of the Amazon Web Services CloudFormation stacks to update. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub stack_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UpdateCloudFormationCollectionFilter {
    /// <p> An array of the names of the Amazon Web Services CloudFormation stacks to update. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub fn stack_names(&self) -> std::option::Option<&[std::string::String]> {
        self.stack_names.as_deref()
    }
}
impl std::fmt::Debug for UpdateCloudFormationCollectionFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCloudFormationCollectionFilter");
        formatter.field("stack_names", &self.stack_names);
        formatter.finish()
    }
}
/// See [`UpdateCloudFormationCollectionFilter`](crate::model::UpdateCloudFormationCollectionFilter)
pub mod update_cloud_formation_collection_filter {
    /// A builder for [`UpdateCloudFormationCollectionFilter`](crate::model::UpdateCloudFormationCollectionFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `stack_names`.
        ///
        /// To override the contents of this collection use [`set_stack_names`](Self::set_stack_names).
        ///
        /// <p> An array of the names of the Amazon Web Services CloudFormation stacks to update. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn stack_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.stack_names.unwrap_or_default();
            v.push(input.into());
            self.stack_names = Some(v);
            self
        }
        /// <p> An array of the names of the Amazon Web Services CloudFormation stacks to update. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn set_stack_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.stack_names = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCloudFormationCollectionFilter`](crate::model::UpdateCloudFormationCollectionFilter)
        pub fn build(self) -> crate::model::UpdateCloudFormationCollectionFilter {
            crate::model::UpdateCloudFormationCollectionFilter {
                stack_names: self.stack_names,
            }
        }
    }
}
impl UpdateCloudFormationCollectionFilter {
    /// Creates a new builder-style object to manufacture [`UpdateCloudFormationCollectionFilter`](crate::model::UpdateCloudFormationCollectionFilter)
    pub fn builder() -> crate::model::update_cloud_formation_collection_filter::Builder {
        crate::model::update_cloud_formation_collection_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UpdateResourceCollectionAction {
    #[allow(missing_docs)] // documentation missing in model
    Add,
    #[allow(missing_docs)] // documentation missing in model
    Remove,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UpdateResourceCollectionAction {
    fn from(s: &str) -> Self {
        match s {
            "ADD" => UpdateResourceCollectionAction::Add,
            "REMOVE" => UpdateResourceCollectionAction::Remove,
            other => UpdateResourceCollectionAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UpdateResourceCollectionAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UpdateResourceCollectionAction::from(s))
    }
}
impl UpdateResourceCollectionAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UpdateResourceCollectionAction::Add => "ADD",
            UpdateResourceCollectionAction::Remove => "REMOVE",
            UpdateResourceCollectionAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ADD", "REMOVE"]
    }
}
impl AsRef<str> for UpdateResourceCollectionAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the event sources.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventSourcesConfig {
    /// <p></p>
    pub amazon_code_guru_profiler:
        std::option::Option<crate::model::AmazonCodeGuruProfilerIntegration>,
}
impl EventSourcesConfig {
    /// <p></p>
    pub fn amazon_code_guru_profiler(
        &self,
    ) -> std::option::Option<&crate::model::AmazonCodeGuruProfilerIntegration> {
        self.amazon_code_guru_profiler.as_ref()
    }
}
impl std::fmt::Debug for EventSourcesConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventSourcesConfig");
        formatter.field("amazon_code_guru_profiler", &self.amazon_code_guru_profiler);
        formatter.finish()
    }
}
/// See [`EventSourcesConfig`](crate::model::EventSourcesConfig)
pub mod event_sources_config {
    /// A builder for [`EventSourcesConfig`](crate::model::EventSourcesConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amazon_code_guru_profiler:
            std::option::Option<crate::model::AmazonCodeGuruProfilerIntegration>,
    }
    impl Builder {
        /// <p></p>
        pub fn amazon_code_guru_profiler(
            mut self,
            input: crate::model::AmazonCodeGuruProfilerIntegration,
        ) -> Self {
            self.amazon_code_guru_profiler = Some(input);
            self
        }
        /// <p></p>
        pub fn set_amazon_code_guru_profiler(
            mut self,
            input: std::option::Option<crate::model::AmazonCodeGuruProfilerIntegration>,
        ) -> Self {
            self.amazon_code_guru_profiler = input;
            self
        }
        /// Consumes the builder and constructs a [`EventSourcesConfig`](crate::model::EventSourcesConfig)
        pub fn build(self) -> crate::model::EventSourcesConfig {
            crate::model::EventSourcesConfig {
                amazon_code_guru_profiler: self.amazon_code_guru_profiler,
            }
        }
    }
}
impl EventSourcesConfig {
    /// Creates a new builder-style object to manufacture [`EventSourcesConfig`](crate::model::EventSourcesConfig)
    pub fn builder() -> crate::model::event_sources_config::Builder {
        crate::model::event_sources_config::Builder::default()
    }
}

/// <p>Information about your account's integration with Amazon CodeGuru Profiler.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AmazonCodeGuruProfilerIntegration {
    /// <p>The status of the CodeGuru Profiler integration.</p>
    pub status: std::option::Option<crate::model::EventSourceOptInStatus>,
}
impl AmazonCodeGuruProfilerIntegration {
    /// <p>The status of the CodeGuru Profiler integration.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::EventSourceOptInStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for AmazonCodeGuruProfilerIntegration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AmazonCodeGuruProfilerIntegration");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`AmazonCodeGuruProfilerIntegration`](crate::model::AmazonCodeGuruProfilerIntegration)
pub mod amazon_code_guru_profiler_integration {
    /// A builder for [`AmazonCodeGuruProfilerIntegration`](crate::model::AmazonCodeGuruProfilerIntegration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::EventSourceOptInStatus>,
    }
    impl Builder {
        /// <p>The status of the CodeGuru Profiler integration.</p>
        pub fn status(mut self, input: crate::model::EventSourceOptInStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the CodeGuru Profiler integration.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::EventSourceOptInStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`AmazonCodeGuruProfilerIntegration`](crate::model::AmazonCodeGuruProfilerIntegration)
        pub fn build(self) -> crate::model::AmazonCodeGuruProfilerIntegration {
            crate::model::AmazonCodeGuruProfilerIntegration {
                status: self.status,
            }
        }
    }
}
impl AmazonCodeGuruProfilerIntegration {
    /// Creates a new builder-style object to manufacture [`AmazonCodeGuruProfilerIntegration`](crate::model::AmazonCodeGuruProfilerIntegration)
    pub fn builder() -> crate::model::amazon_code_guru_profiler_integration::Builder {
        crate::model::amazon_code_guru_profiler_integration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventSourceOptInStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventSourceOptInStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => EventSourceOptInStatus::Disabled,
            "ENABLED" => EventSourceOptInStatus::Enabled,
            other => EventSourceOptInStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventSourceOptInStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventSourceOptInStatus::from(s))
    }
}
impl EventSourceOptInStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventSourceOptInStatus::Disabled => "DISABLED",
            EventSourceOptInStatus::Enabled => "ENABLED",
            EventSourceOptInStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for EventSourceOptInStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a filter used to specify which Amazon Web Services resources are analyzed to create a monthly DevOps Guru cost estimate. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html">Estimate your Amazon DevOps Guru costs</a> and <a href="http://aws.amazon.com/devops-guru/pricing/">Amazon DevOps Guru pricing</a>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CostEstimationResourceCollectionFilter {
    /// <p>An object that specifies the CloudFormation stack that defines the Amazon Web Services resources used to create a monthly estimate for DevOps Guru.</p>
    pub cloud_formation:
        std::option::Option<crate::model::CloudFormationCostEstimationResourceCollectionFilter>,
    /// <p>The Amazon Web Services tags used to filter the resource collection that is used for a cost estimate.</p>
    /// <p>Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an Lambda function. For more information about using tags, see the <a href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best practices</a> whitepaper. </p>
    /// <p>Each Amazon Web Services tag has two parts. </p>
    /// <ul>
    /// <li> <p>A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag <i>keys</i> are case-sensitive.</p> </li>
    /// <li> <p>An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.</p> </li>
    /// </ul>
    /// <p>Together these are known as <i>key</i>-<i>value</i> pairs.</p> <important>
    /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
    /// </important>
    pub tags:
        std::option::Option<std::vec::Vec<crate::model::TagCostEstimationResourceCollectionFilter>>,
}
impl CostEstimationResourceCollectionFilter {
    /// <p>An object that specifies the CloudFormation stack that defines the Amazon Web Services resources used to create a monthly estimate for DevOps Guru.</p>
    pub fn cloud_formation(
        &self,
    ) -> std::option::Option<&crate::model::CloudFormationCostEstimationResourceCollectionFilter>
    {
        self.cloud_formation.as_ref()
    }
    /// <p>The Amazon Web Services tags used to filter the resource collection that is used for a cost estimate.</p>
    /// <p>Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an Lambda function. For more information about using tags, see the <a href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best practices</a> whitepaper. </p>
    /// <p>Each Amazon Web Services tag has two parts. </p>
    /// <ul>
    /// <li> <p>A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag <i>keys</i> are case-sensitive.</p> </li>
    /// <li> <p>An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.</p> </li>
    /// </ul>
    /// <p>Together these are known as <i>key</i>-<i>value</i> pairs.</p> <important>
    /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
    /// </important>
    pub fn tags(
        &self,
    ) -> std::option::Option<&[crate::model::TagCostEstimationResourceCollectionFilter]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CostEstimationResourceCollectionFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CostEstimationResourceCollectionFilter");
        formatter.field("cloud_formation", &self.cloud_formation);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CostEstimationResourceCollectionFilter`](crate::model::CostEstimationResourceCollectionFilter)
pub mod cost_estimation_resource_collection_filter {
    /// A builder for [`CostEstimationResourceCollectionFilter`](crate::model::CostEstimationResourceCollectionFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_formation:
            std::option::Option<crate::model::CloudFormationCostEstimationResourceCollectionFilter>,
        pub(crate) tags: std::option::Option<
            std::vec::Vec<crate::model::TagCostEstimationResourceCollectionFilter>,
        >,
    }
    impl Builder {
        /// <p>An object that specifies the CloudFormation stack that defines the Amazon Web Services resources used to create a monthly estimate for DevOps Guru.</p>
        pub fn cloud_formation(
            mut self,
            input: crate::model::CloudFormationCostEstimationResourceCollectionFilter,
        ) -> Self {
            self.cloud_formation = Some(input);
            self
        }
        /// <p>An object that specifies the CloudFormation stack that defines the Amazon Web Services resources used to create a monthly estimate for DevOps Guru.</p>
        pub fn set_cloud_formation(
            mut self,
            input: std::option::Option<
                crate::model::CloudFormationCostEstimationResourceCollectionFilter,
            >,
        ) -> Self {
            self.cloud_formation = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The Amazon Web Services tags used to filter the resource collection that is used for a cost estimate.</p>
        /// <p>Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an Lambda function. For more information about using tags, see the <a href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best practices</a> whitepaper. </p>
        /// <p>Each Amazon Web Services tag has two parts. </p>
        /// <ul>
        /// <li> <p>A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag <i>keys</i> are case-sensitive.</p> </li>
        /// <li> <p>An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.</p> </li>
        /// </ul>
        /// <p>Together these are known as <i>key</i>-<i>value</i> pairs.</p> <important>
        /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
        /// </important>
        pub fn tags(
            mut self,
            input: crate::model::TagCostEstimationResourceCollectionFilter,
        ) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The Amazon Web Services tags used to filter the resource collection that is used for a cost estimate.</p>
        /// <p>Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an Lambda function. For more information about using tags, see the <a href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best practices</a> whitepaper. </p>
        /// <p>Each Amazon Web Services tag has two parts. </p>
        /// <ul>
        /// <li> <p>A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag <i>keys</i> are case-sensitive.</p> </li>
        /// <li> <p>An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.</p> </li>
        /// </ul>
        /// <p>Together these are known as <i>key</i>-<i>value</i> pairs.</p> <important>
        /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
        /// </important>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::TagCostEstimationResourceCollectionFilter>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CostEstimationResourceCollectionFilter`](crate::model::CostEstimationResourceCollectionFilter)
        pub fn build(self) -> crate::model::CostEstimationResourceCollectionFilter {
            crate::model::CostEstimationResourceCollectionFilter {
                cloud_formation: self.cloud_formation,
                tags: self.tags,
            }
        }
    }
}
impl CostEstimationResourceCollectionFilter {
    /// Creates a new builder-style object to manufacture [`CostEstimationResourceCollectionFilter`](crate::model::CostEstimationResourceCollectionFilter)
    pub fn builder() -> crate::model::cost_estimation_resource_collection_filter::Builder {
        crate::model::cost_estimation_resource_collection_filter::Builder::default()
    }
}

/// <p>Information about a collection of Amazon Web Services resources that are identified by an Amazon Web Services tag. This collection of resources is used to create a monthly cost estimate for DevOps Guru to analyze Amazon Web Services resources. The maximum number of tags you can specify for a cost estimate is one. The estimate created is for the cost to analyze the Amazon Web Services resources defined by the tag. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a> in the <i>Amazon Web Services CloudFormation User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagCostEstimationResourceCollectionFilter {
    /// <p>An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this <i>key</i> make up your DevOps Guru application and analysis boundary.</p> <important>
    /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
    /// </important>
    pub app_boundary_key: std::option::Option<std::string::String>,
    /// <p>The values in an Amazon Web Services tag collection.</p>
    /// <p>The tag's <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and <i>value</i> are the tag's <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of 256 characters for a tag value.</p>
    pub tag_values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl TagCostEstimationResourceCollectionFilter {
    /// <p>An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this <i>key</i> make up your DevOps Guru application and analysis boundary.</p> <important>
    /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
    /// </important>
    pub fn app_boundary_key(&self) -> std::option::Option<&str> {
        self.app_boundary_key.as_deref()
    }
    /// <p>The values in an Amazon Web Services tag collection.</p>
    /// <p>The tag's <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and <i>value</i> are the tag's <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of 256 characters for a tag value.</p>
    pub fn tag_values(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_values.as_deref()
    }
}
impl std::fmt::Debug for TagCostEstimationResourceCollectionFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagCostEstimationResourceCollectionFilter");
        formatter.field("app_boundary_key", &self.app_boundary_key);
        formatter.field("tag_values", &self.tag_values);
        formatter.finish()
    }
}
/// See [`TagCostEstimationResourceCollectionFilter`](crate::model::TagCostEstimationResourceCollectionFilter)
pub mod tag_cost_estimation_resource_collection_filter {
    /// A builder for [`TagCostEstimationResourceCollectionFilter`](crate::model::TagCostEstimationResourceCollectionFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_boundary_key: std::option::Option<std::string::String>,
        pub(crate) tag_values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this <i>key</i> make up your DevOps Guru application and analysis boundary.</p> <important>
        /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
        /// </important>
        pub fn app_boundary_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_boundary_key = Some(input.into());
            self
        }
        /// <p>An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this <i>key</i> make up your DevOps Guru application and analysis boundary.</p> <important>
        /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
        /// </important>
        pub fn set_app_boundary_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_boundary_key = input;
            self
        }
        /// Appends an item to `tag_values`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>The values in an Amazon Web Services tag collection.</p>
        /// <p>The tag's <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and <i>value</i> are the tag's <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of 256 characters for a tag value.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_values.unwrap_or_default();
            v.push(input.into());
            self.tag_values = Some(v);
            self
        }
        /// <p>The values in an Amazon Web Services tag collection.</p>
        /// <p>The tag's <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and <i>value</i> are the tag's <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of 256 characters for a tag value.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_values = input;
            self
        }
        /// Consumes the builder and constructs a [`TagCostEstimationResourceCollectionFilter`](crate::model::TagCostEstimationResourceCollectionFilter)
        pub fn build(self) -> crate::model::TagCostEstimationResourceCollectionFilter {
            crate::model::TagCostEstimationResourceCollectionFilter {
                app_boundary_key: self.app_boundary_key,
                tag_values: self.tag_values,
            }
        }
    }
}
impl TagCostEstimationResourceCollectionFilter {
    /// Creates a new builder-style object to manufacture [`TagCostEstimationResourceCollectionFilter`](crate::model::TagCostEstimationResourceCollectionFilter)
    pub fn builder() -> crate::model::tag_cost_estimation_resource_collection_filter::Builder {
        crate::model::tag_cost_estimation_resource_collection_filter::Builder::default()
    }
}

/// <p>Information about an Amazon Web Services CloudFormation stack used to create a monthly cost estimate for DevOps Guru to analyze Amazon Web Services resources. The maximum number of stacks you can specify for a cost estimate is one. The estimate created is for the cost to analyze the Amazon Web Services resources defined by the stack. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a> in the <i>Amazon Web Services CloudFormation User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudFormationCostEstimationResourceCollectionFilter {
    /// <p>An array of CloudFormation stack names. Its size is fixed at 1 item.</p>
    pub stack_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CloudFormationCostEstimationResourceCollectionFilter {
    /// <p>An array of CloudFormation stack names. Its size is fixed at 1 item.</p>
    pub fn stack_names(&self) -> std::option::Option<&[std::string::String]> {
        self.stack_names.as_deref()
    }
}
impl std::fmt::Debug for CloudFormationCostEstimationResourceCollectionFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudFormationCostEstimationResourceCollectionFilter");
        formatter.field("stack_names", &self.stack_names);
        formatter.finish()
    }
}
/// See [`CloudFormationCostEstimationResourceCollectionFilter`](crate::model::CloudFormationCostEstimationResourceCollectionFilter)
pub mod cloud_formation_cost_estimation_resource_collection_filter {
    /// A builder for [`CloudFormationCostEstimationResourceCollectionFilter`](crate::model::CloudFormationCostEstimationResourceCollectionFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `stack_names`.
        ///
        /// To override the contents of this collection use [`set_stack_names`](Self::set_stack_names).
        ///
        /// <p>An array of CloudFormation stack names. Its size is fixed at 1 item.</p>
        pub fn stack_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.stack_names.unwrap_or_default();
            v.push(input.into());
            self.stack_names = Some(v);
            self
        }
        /// <p>An array of CloudFormation stack names. Its size is fixed at 1 item.</p>
        pub fn set_stack_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.stack_names = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudFormationCostEstimationResourceCollectionFilter`](crate::model::CloudFormationCostEstimationResourceCollectionFilter)
        pub fn build(self) -> crate::model::CloudFormationCostEstimationResourceCollectionFilter {
            crate::model::CloudFormationCostEstimationResourceCollectionFilter {
                stack_names: self.stack_names,
            }
        }
    }
}
impl CloudFormationCostEstimationResourceCollectionFilter {
    /// Creates a new builder-style object to manufacture [`CloudFormationCostEstimationResourceCollectionFilter`](crate::model::CloudFormationCostEstimationResourceCollectionFilter)
    pub fn builder(
    ) -> crate::model::cloud_formation_cost_estimation_resource_collection_filter::Builder {
        crate::model::cloud_formation_cost_estimation_resource_collection_filter::Builder::default()
    }
}

/// <p> Information about a reactive insight. This object is returned by <code>DescribeInsight.</code> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReactiveInsightSummary {
    /// <p> The ID of a reactive summary. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p> The name of a reactive insight. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The severity of the insight. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
    pub severity: std::option::Option<crate::model::InsightSeverity>,
    /// <p> The status of a reactive insight. </p>
    pub status: std::option::Option<crate::model::InsightStatus>,
    /// <p> A time ranged that specifies when the observed behavior in an insight started and ended. </p>
    pub insight_time_range: std::option::Option<crate::model::InsightTimeRange>,
    /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub resource_collection: std::option::Option<crate::model::ResourceCollection>,
    /// <p>A collection of the names of Amazon Web Services services.</p>
    pub service_collection: std::option::Option<crate::model::ServiceCollection>,
    /// <p>The Amazon Resource Names (ARNs) of the Amazon Web Services resources that generated this insight.</p>
    pub associated_resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ReactiveInsightSummary {
    /// <p> The ID of a reactive summary. </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p> The name of a reactive insight. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The severity of the insight. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
    pub fn severity(&self) -> std::option::Option<&crate::model::InsightSeverity> {
        self.severity.as_ref()
    }
    /// <p> The status of a reactive insight. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::InsightStatus> {
        self.status.as_ref()
    }
    /// <p> A time ranged that specifies when the observed behavior in an insight started and ended. </p>
    pub fn insight_time_range(&self) -> std::option::Option<&crate::model::InsightTimeRange> {
        self.insight_time_range.as_ref()
    }
    /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub fn resource_collection(&self) -> std::option::Option<&crate::model::ResourceCollection> {
        self.resource_collection.as_ref()
    }
    /// <p>A collection of the names of Amazon Web Services services.</p>
    pub fn service_collection(&self) -> std::option::Option<&crate::model::ServiceCollection> {
        self.service_collection.as_ref()
    }
    /// <p>The Amazon Resource Names (ARNs) of the Amazon Web Services resources that generated this insight.</p>
    pub fn associated_resource_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.associated_resource_arns.as_deref()
    }
}
impl std::fmt::Debug for ReactiveInsightSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReactiveInsightSummary");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("severity", &self.severity);
        formatter.field("status", &self.status);
        formatter.field("insight_time_range", &self.insight_time_range);
        formatter.field("resource_collection", &self.resource_collection);
        formatter.field("service_collection", &self.service_collection);
        formatter.field("associated_resource_arns", &self.associated_resource_arns);
        formatter.finish()
    }
}
/// See [`ReactiveInsightSummary`](crate::model::ReactiveInsightSummary)
pub mod reactive_insight_summary {
    /// A builder for [`ReactiveInsightSummary`](crate::model::ReactiveInsightSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<crate::model::InsightSeverity>,
        pub(crate) status: std::option::Option<crate::model::InsightStatus>,
        pub(crate) insight_time_range: std::option::Option<crate::model::InsightTimeRange>,
        pub(crate) resource_collection: std::option::Option<crate::model::ResourceCollection>,
        pub(crate) service_collection: std::option::Option<crate::model::ServiceCollection>,
        pub(crate) associated_resource_arns:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p> The ID of a reactive summary. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The ID of a reactive summary. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p> The name of a reactive insight. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of a reactive insight. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The severity of the insight. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
        pub fn severity(mut self, input: crate::model::InsightSeverity) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>The severity of the insight. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
        pub fn set_severity(
            mut self,
            input: std::option::Option<crate::model::InsightSeverity>,
        ) -> Self {
            self.severity = input;
            self
        }
        /// <p> The status of a reactive insight. </p>
        pub fn status(mut self, input: crate::model::InsightStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The status of a reactive insight. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::InsightStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> A time ranged that specifies when the observed behavior in an insight started and ended. </p>
        pub fn insight_time_range(mut self, input: crate::model::InsightTimeRange) -> Self {
            self.insight_time_range = Some(input);
            self
        }
        /// <p> A time ranged that specifies when the observed behavior in an insight started and ended. </p>
        pub fn set_insight_time_range(
            mut self,
            input: std::option::Option<crate::model::InsightTimeRange>,
        ) -> Self {
            self.insight_time_range = input;
            self
        }
        /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn resource_collection(mut self, input: crate::model::ResourceCollection) -> Self {
            self.resource_collection = Some(input);
            self
        }
        /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn set_resource_collection(
            mut self,
            input: std::option::Option<crate::model::ResourceCollection>,
        ) -> Self {
            self.resource_collection = input;
            self
        }
        /// <p>A collection of the names of Amazon Web Services services.</p>
        pub fn service_collection(mut self, input: crate::model::ServiceCollection) -> Self {
            self.service_collection = Some(input);
            self
        }
        /// <p>A collection of the names of Amazon Web Services services.</p>
        pub fn set_service_collection(
            mut self,
            input: std::option::Option<crate::model::ServiceCollection>,
        ) -> Self {
            self.service_collection = input;
            self
        }
        /// Appends an item to `associated_resource_arns`.
        ///
        /// To override the contents of this collection use [`set_associated_resource_arns`](Self::set_associated_resource_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the Amazon Web Services resources that generated this insight.</p>
        pub fn associated_resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.associated_resource_arns.unwrap_or_default();
            v.push(input.into());
            self.associated_resource_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the Amazon Web Services resources that generated this insight.</p>
        pub fn set_associated_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.associated_resource_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`ReactiveInsightSummary`](crate::model::ReactiveInsightSummary)
        pub fn build(self) -> crate::model::ReactiveInsightSummary {
            crate::model::ReactiveInsightSummary {
                id: self.id,
                name: self.name,
                severity: self.severity,
                status: self.status,
                insight_time_range: self.insight_time_range,
                resource_collection: self.resource_collection,
                service_collection: self.service_collection,
                associated_resource_arns: self.associated_resource_arns,
            }
        }
    }
}
impl ReactiveInsightSummary {
    /// Creates a new builder-style object to manufacture [`ReactiveInsightSummary`](crate::model::ReactiveInsightSummary)
    pub fn builder() -> crate::model::reactive_insight_summary::Builder {
        crate::model::reactive_insight_summary::Builder::default()
    }
}

/// <p>A collection of the names of Amazon Web Services services.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceCollection {
    /// <p>An array of strings that each specifies the name of an Amazon Web Services service.</p>
    pub service_names: std::option::Option<std::vec::Vec<crate::model::ServiceName>>,
}
impl ServiceCollection {
    /// <p>An array of strings that each specifies the name of an Amazon Web Services service.</p>
    pub fn service_names(&self) -> std::option::Option<&[crate::model::ServiceName]> {
        self.service_names.as_deref()
    }
}
impl std::fmt::Debug for ServiceCollection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceCollection");
        formatter.field("service_names", &self.service_names);
        formatter.finish()
    }
}
/// See [`ServiceCollection`](crate::model::ServiceCollection)
pub mod service_collection {
    /// A builder for [`ServiceCollection`](crate::model::ServiceCollection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_names: std::option::Option<std::vec::Vec<crate::model::ServiceName>>,
    }
    impl Builder {
        /// Appends an item to `service_names`.
        ///
        /// To override the contents of this collection use [`set_service_names`](Self::set_service_names).
        ///
        /// <p>An array of strings that each specifies the name of an Amazon Web Services service.</p>
        pub fn service_names(mut self, input: crate::model::ServiceName) -> Self {
            let mut v = self.service_names.unwrap_or_default();
            v.push(input);
            self.service_names = Some(v);
            self
        }
        /// <p>An array of strings that each specifies the name of an Amazon Web Services service.</p>
        pub fn set_service_names(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceName>>,
        ) -> Self {
            self.service_names = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceCollection`](crate::model::ServiceCollection)
        pub fn build(self) -> crate::model::ServiceCollection {
            crate::model::ServiceCollection {
                service_names: self.service_names,
            }
        }
    }
}
impl ServiceCollection {
    /// Creates a new builder-style object to manufacture [`ServiceCollection`](crate::model::ServiceCollection)
    pub fn builder() -> crate::model::service_collection::Builder {
        crate::model::service_collection::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServiceName {
    #[allow(missing_docs)] // documentation missing in model
    ApiGateway,
    #[allow(missing_docs)] // documentation missing in model
    ApplicationElb,
    #[allow(missing_docs)] // documentation missing in model
    AutoScalingGroup,
    #[allow(missing_docs)] // documentation missing in model
    CloudFront,
    #[allow(missing_docs)] // documentation missing in model
    DynamoDb,
    #[allow(missing_docs)] // documentation missing in model
    Ec2,
    #[allow(missing_docs)] // documentation missing in model
    Ecs,
    #[allow(missing_docs)] // documentation missing in model
    Eks,
    #[allow(missing_docs)] // documentation missing in model
    ElasticBeanstalk,
    #[allow(missing_docs)] // documentation missing in model
    ElastiCache,
    #[allow(missing_docs)] // documentation missing in model
    Elb,
    #[allow(missing_docs)] // documentation missing in model
    Es,
    #[allow(missing_docs)] // documentation missing in model
    Kinesis,
    #[allow(missing_docs)] // documentation missing in model
    Lambda,
    #[allow(missing_docs)] // documentation missing in model
    NatGateway,
    #[allow(missing_docs)] // documentation missing in model
    NetworkElb,
    #[allow(missing_docs)] // documentation missing in model
    Rds,
    #[allow(missing_docs)] // documentation missing in model
    Redshift,
    #[allow(missing_docs)] // documentation missing in model
    Route53,
    #[allow(missing_docs)] // documentation missing in model
    S3,
    #[allow(missing_docs)] // documentation missing in model
    SageMaker,
    #[allow(missing_docs)] // documentation missing in model
    Sns,
    #[allow(missing_docs)] // documentation missing in model
    Sqs,
    #[allow(missing_docs)] // documentation missing in model
    StepFunctions,
    #[allow(missing_docs)] // documentation missing in model
    Swf,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServiceName {
    fn from(s: &str) -> Self {
        match s {
            "API_GATEWAY" => ServiceName::ApiGateway,
            "APPLICATION_ELB" => ServiceName::ApplicationElb,
            "AUTO_SCALING_GROUP" => ServiceName::AutoScalingGroup,
            "CLOUD_FRONT" => ServiceName::CloudFront,
            "DYNAMO_DB" => ServiceName::DynamoDb,
            "EC2" => ServiceName::Ec2,
            "ECS" => ServiceName::Ecs,
            "EKS" => ServiceName::Eks,
            "ELASTIC_BEANSTALK" => ServiceName::ElasticBeanstalk,
            "ELASTI_CACHE" => ServiceName::ElastiCache,
            "ELB" => ServiceName::Elb,
            "ES" => ServiceName::Es,
            "KINESIS" => ServiceName::Kinesis,
            "LAMBDA" => ServiceName::Lambda,
            "NAT_GATEWAY" => ServiceName::NatGateway,
            "NETWORK_ELB" => ServiceName::NetworkElb,
            "RDS" => ServiceName::Rds,
            "REDSHIFT" => ServiceName::Redshift,
            "ROUTE_53" => ServiceName::Route53,
            "S3" => ServiceName::S3,
            "SAGE_MAKER" => ServiceName::SageMaker,
            "SNS" => ServiceName::Sns,
            "SQS" => ServiceName::Sqs,
            "STEP_FUNCTIONS" => ServiceName::StepFunctions,
            "SWF" => ServiceName::Swf,
            other => ServiceName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServiceName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServiceName::from(s))
    }
}
impl ServiceName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServiceName::ApiGateway => "API_GATEWAY",
            ServiceName::ApplicationElb => "APPLICATION_ELB",
            ServiceName::AutoScalingGroup => "AUTO_SCALING_GROUP",
            ServiceName::CloudFront => "CLOUD_FRONT",
            ServiceName::DynamoDb => "DYNAMO_DB",
            ServiceName::Ec2 => "EC2",
            ServiceName::Ecs => "ECS",
            ServiceName::Eks => "EKS",
            ServiceName::ElasticBeanstalk => "ELASTIC_BEANSTALK",
            ServiceName::ElastiCache => "ELASTI_CACHE",
            ServiceName::Elb => "ELB",
            ServiceName::Es => "ES",
            ServiceName::Kinesis => "KINESIS",
            ServiceName::Lambda => "LAMBDA",
            ServiceName::NatGateway => "NAT_GATEWAY",
            ServiceName::NetworkElb => "NETWORK_ELB",
            ServiceName::Rds => "RDS",
            ServiceName::Redshift => "REDSHIFT",
            ServiceName::Route53 => "ROUTE_53",
            ServiceName::S3 => "S3",
            ServiceName::SageMaker => "SAGE_MAKER",
            ServiceName::Sns => "SNS",
            ServiceName::Sqs => "SQS",
            ServiceName::StepFunctions => "STEP_FUNCTIONS",
            ServiceName::Swf => "SWF",
            ServiceName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "API_GATEWAY",
            "APPLICATION_ELB",
            "AUTO_SCALING_GROUP",
            "CLOUD_FRONT",
            "DYNAMO_DB",
            "EC2",
            "ECS",
            "EKS",
            "ELASTIC_BEANSTALK",
            "ELASTI_CACHE",
            "ELB",
            "ES",
            "KINESIS",
            "LAMBDA",
            "NAT_GATEWAY",
            "NETWORK_ELB",
            "RDS",
            "REDSHIFT",
            "ROUTE_53",
            "S3",
            "SAGE_MAKER",
            "SNS",
            "SQS",
            "STEP_FUNCTIONS",
            "SWF",
        ]
    }
}
impl AsRef<str> for ServiceName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceCollection {
    /// <p> An array of the names of Amazon Web Services CloudFormation stacks. The stacks define Amazon Web Services resources that DevOps Guru analyzes. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub cloud_formation: std::option::Option<crate::model::CloudFormationCollection>,
    /// <p>The Amazon Web Services tags that are used by resources in the resource collection.</p>
    /// <p>Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an Lambda function. For more information about using tags, see the <a href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best practices</a> whitepaper. </p>
    /// <p>Each Amazon Web Services tag has two parts. </p>
    /// <ul>
    /// <li> <p>A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag <i>keys</i> are case-sensitive.</p> </li>
    /// <li> <p>An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.</p> </li>
    /// </ul>
    /// <p>Together these are known as <i>key</i>-<i>value</i> pairs.</p> <important>
    /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
    /// </important>
    pub tags: std::option::Option<std::vec::Vec<crate::model::TagCollection>>,
}
impl ResourceCollection {
    /// <p> An array of the names of Amazon Web Services CloudFormation stacks. The stacks define Amazon Web Services resources that DevOps Guru analyzes. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub fn cloud_formation(&self) -> std::option::Option<&crate::model::CloudFormationCollection> {
        self.cloud_formation.as_ref()
    }
    /// <p>The Amazon Web Services tags that are used by resources in the resource collection.</p>
    /// <p>Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an Lambda function. For more information about using tags, see the <a href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best practices</a> whitepaper. </p>
    /// <p>Each Amazon Web Services tag has two parts. </p>
    /// <ul>
    /// <li> <p>A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag <i>keys</i> are case-sensitive.</p> </li>
    /// <li> <p>An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.</p> </li>
    /// </ul>
    /// <p>Together these are known as <i>key</i>-<i>value</i> pairs.</p> <important>
    /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
    /// </important>
    pub fn tags(&self) -> std::option::Option<&[crate::model::TagCollection]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ResourceCollection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceCollection");
        formatter.field("cloud_formation", &self.cloud_formation);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ResourceCollection`](crate::model::ResourceCollection)
pub mod resource_collection {
    /// A builder for [`ResourceCollection`](crate::model::ResourceCollection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_formation: std::option::Option<crate::model::CloudFormationCollection>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::TagCollection>>,
    }
    impl Builder {
        /// <p> An array of the names of Amazon Web Services CloudFormation stacks. The stacks define Amazon Web Services resources that DevOps Guru analyzes. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn cloud_formation(mut self, input: crate::model::CloudFormationCollection) -> Self {
            self.cloud_formation = Some(input);
            self
        }
        /// <p> An array of the names of Amazon Web Services CloudFormation stacks. The stacks define Amazon Web Services resources that DevOps Guru analyzes. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn set_cloud_formation(
            mut self,
            input: std::option::Option<crate::model::CloudFormationCollection>,
        ) -> Self {
            self.cloud_formation = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The Amazon Web Services tags that are used by resources in the resource collection.</p>
        /// <p>Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an Lambda function. For more information about using tags, see the <a href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best practices</a> whitepaper. </p>
        /// <p>Each Amazon Web Services tag has two parts. </p>
        /// <ul>
        /// <li> <p>A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag <i>keys</i> are case-sensitive.</p> </li>
        /// <li> <p>An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.</p> </li>
        /// </ul>
        /// <p>Together these are known as <i>key</i>-<i>value</i> pairs.</p> <important>
        /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
        /// </important>
        pub fn tags(mut self, input: crate::model::TagCollection) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The Amazon Web Services tags that are used by resources in the resource collection.</p>
        /// <p>Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an Lambda function. For more information about using tags, see the <a href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best practices</a> whitepaper. </p>
        /// <p>Each Amazon Web Services tag has two parts. </p>
        /// <ul>
        /// <li> <p>A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag <i>keys</i> are case-sensitive.</p> </li>
        /// <li> <p>An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.</p> </li>
        /// </ul>
        /// <p>Together these are known as <i>key</i>-<i>value</i> pairs.</p> <important>
        /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
        /// </important>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagCollection>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceCollection`](crate::model::ResourceCollection)
        pub fn build(self) -> crate::model::ResourceCollection {
            crate::model::ResourceCollection {
                cloud_formation: self.cloud_formation,
                tags: self.tags,
            }
        }
    }
}
impl ResourceCollection {
    /// Creates a new builder-style object to manufacture [`ResourceCollection`](crate::model::ResourceCollection)
    pub fn builder() -> crate::model::resource_collection::Builder {
        crate::model::resource_collection::Builder::default()
    }
}

/// <p>A collection of Amazon Web Services stags.</p>
/// <p>Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an Lambda function. For more information about using tags, see the <a href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best practices</a> whitepaper. </p>
/// <p>Each Amazon Web Services tag has two parts. </p>
/// <ul>
/// <li> <p>A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag <i>keys</i> are case-sensitive.</p> </li>
/// <li> <p>An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.</p> </li>
/// </ul>
/// <p>Together these are known as <i>key</i>-<i>value</i> pairs.</p> <important>
/// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
/// </important>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagCollection {
    /// <p>An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this <i>key</i> make up your DevOps Guru application and analysis boundary.</p> <important>
    /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
    /// </important>
    pub app_boundary_key: std::option::Option<std::string::String>,
    /// <p>The values in an Amazon Web Services tag collection.</p>
    /// <p>The tag's <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and <i>value</i> are the tag's <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of 256 characters for a tag value.</p>
    pub tag_values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl TagCollection {
    /// <p>An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this <i>key</i> make up your DevOps Guru application and analysis boundary.</p> <important>
    /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
    /// </important>
    pub fn app_boundary_key(&self) -> std::option::Option<&str> {
        self.app_boundary_key.as_deref()
    }
    /// <p>The values in an Amazon Web Services tag collection.</p>
    /// <p>The tag's <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and <i>value</i> are the tag's <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of 256 characters for a tag value.</p>
    pub fn tag_values(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_values.as_deref()
    }
}
impl std::fmt::Debug for TagCollection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagCollection");
        formatter.field("app_boundary_key", &self.app_boundary_key);
        formatter.field("tag_values", &self.tag_values);
        formatter.finish()
    }
}
/// See [`TagCollection`](crate::model::TagCollection)
pub mod tag_collection {
    /// A builder for [`TagCollection`](crate::model::TagCollection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_boundary_key: std::option::Option<std::string::String>,
        pub(crate) tag_values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this <i>key</i> make up your DevOps Guru application and analysis boundary.</p> <important>
        /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
        /// </important>
        pub fn app_boundary_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_boundary_key = Some(input.into());
            self
        }
        /// <p>An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this <i>key</i> make up your DevOps Guru application and analysis boundary.</p> <important>
        /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
        /// </important>
        pub fn set_app_boundary_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_boundary_key = input;
            self
        }
        /// Appends an item to `tag_values`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>The values in an Amazon Web Services tag collection.</p>
        /// <p>The tag's <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and <i>value</i> are the tag's <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of 256 characters for a tag value.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_values.unwrap_or_default();
            v.push(input.into());
            self.tag_values = Some(v);
            self
        }
        /// <p>The values in an Amazon Web Services tag collection.</p>
        /// <p>The tag's <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and <i>value</i> are the tag's <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of 256 characters for a tag value.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_values = input;
            self
        }
        /// Consumes the builder and constructs a [`TagCollection`](crate::model::TagCollection)
        pub fn build(self) -> crate::model::TagCollection {
            crate::model::TagCollection {
                app_boundary_key: self.app_boundary_key,
                tag_values: self.tag_values,
            }
        }
    }
}
impl TagCollection {
    /// Creates a new builder-style object to manufacture [`TagCollection`](crate::model::TagCollection)
    pub fn builder() -> crate::model::tag_collection::Builder {
        crate::model::tag_collection::Builder::default()
    }
}

/// <p> Information about Amazon Web Services CloudFormation stacks. You can use up to 500 stacks to specify which Amazon Web Services resources in your account to analyze. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a> in the <i>Amazon Web Services CloudFormation User Guide</i>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudFormationCollection {
    /// <p> An array of CloudFormation stack names. </p>
    pub stack_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CloudFormationCollection {
    /// <p> An array of CloudFormation stack names. </p>
    pub fn stack_names(&self) -> std::option::Option<&[std::string::String]> {
        self.stack_names.as_deref()
    }
}
impl std::fmt::Debug for CloudFormationCollection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudFormationCollection");
        formatter.field("stack_names", &self.stack_names);
        formatter.finish()
    }
}
/// See [`CloudFormationCollection`](crate::model::CloudFormationCollection)
pub mod cloud_formation_collection {
    /// A builder for [`CloudFormationCollection`](crate::model::CloudFormationCollection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `stack_names`.
        ///
        /// To override the contents of this collection use [`set_stack_names`](Self::set_stack_names).
        ///
        /// <p> An array of CloudFormation stack names. </p>
        pub fn stack_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.stack_names.unwrap_or_default();
            v.push(input.into());
            self.stack_names = Some(v);
            self
        }
        /// <p> An array of CloudFormation stack names. </p>
        pub fn set_stack_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.stack_names = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudFormationCollection`](crate::model::CloudFormationCollection)
        pub fn build(self) -> crate::model::CloudFormationCollection {
            crate::model::CloudFormationCollection {
                stack_names: self.stack_names,
            }
        }
    }
}
impl CloudFormationCollection {
    /// Creates a new builder-style object to manufacture [`CloudFormationCollection`](crate::model::CloudFormationCollection)
    pub fn builder() -> crate::model::cloud_formation_collection::Builder {
        crate::model::cloud_formation_collection::Builder::default()
    }
}

/// <p> A time ranged that specifies when the observed behavior in an insight started and ended. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsightTimeRange {
    /// <p> The time when the behavior described in an insight started. </p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The time when the behavior described in an insight ended. </p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl InsightTimeRange {
    /// <p> The time when the behavior described in an insight started. </p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p> The time when the behavior described in an insight ended. </p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
}
impl std::fmt::Debug for InsightTimeRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsightTimeRange");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.finish()
    }
}
/// See [`InsightTimeRange`](crate::model::InsightTimeRange)
pub mod insight_time_range {
    /// A builder for [`InsightTimeRange`](crate::model::InsightTimeRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p> The time when the behavior described in an insight started. </p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p> The time when the behavior described in an insight started. </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p> The time when the behavior described in an insight ended. </p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p> The time when the behavior described in an insight ended. </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`InsightTimeRange`](crate::model::InsightTimeRange)
        pub fn build(self) -> crate::model::InsightTimeRange {
            crate::model::InsightTimeRange {
                start_time: self.start_time,
                end_time: self.end_time,
            }
        }
    }
}
impl InsightTimeRange {
    /// Creates a new builder-style object to manufacture [`InsightTimeRange`](crate::model::InsightTimeRange)
    pub fn builder() -> crate::model::insight_time_range::Builder {
        crate::model::insight_time_range::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InsightStatus {
    #[allow(missing_docs)] // documentation missing in model
    Closed,
    #[allow(missing_docs)] // documentation missing in model
    Ongoing,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InsightStatus {
    fn from(s: &str) -> Self {
        match s {
            "CLOSED" => InsightStatus::Closed,
            "ONGOING" => InsightStatus::Ongoing,
            other => InsightStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InsightStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InsightStatus::from(s))
    }
}
impl InsightStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InsightStatus::Closed => "CLOSED",
            InsightStatus::Ongoing => "ONGOING",
            InsightStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CLOSED", "ONGOING"]
    }
}
impl AsRef<str> for InsightStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InsightSeverity {
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InsightSeverity {
    fn from(s: &str) -> Self {
        match s {
            "HIGH" => InsightSeverity::High,
            "LOW" => InsightSeverity::Low,
            "MEDIUM" => InsightSeverity::Medium,
            other => InsightSeverity::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InsightSeverity {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InsightSeverity::from(s))
    }
}
impl InsightSeverity {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InsightSeverity::High => "HIGH",
            InsightSeverity::Low => "LOW",
            InsightSeverity::Medium => "MEDIUM",
            InsightSeverity::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HIGH", "LOW", "MEDIUM"]
    }
}
impl AsRef<str> for InsightSeverity {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details about a proactive insight. This object is returned by <code>DescribeInsight.</code> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProactiveInsightSummary {
    /// <p>The ID of the proactive insight. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the proactive insight. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The severity of the insight. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
    pub severity: std::option::Option<crate::model::InsightSeverity>,
    /// <p>The status of the proactive insight. </p>
    pub status: std::option::Option<crate::model::InsightStatus>,
    /// <p> A time ranged that specifies when the observed behavior in an insight started and ended. </p>
    pub insight_time_range: std::option::Option<crate::model::InsightTimeRange>,
    /// <p> The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur. </p>
    pub prediction_time_range: std::option::Option<crate::model::PredictionTimeRange>,
    /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub resource_collection: std::option::Option<crate::model::ResourceCollection>,
    /// <p>A collection of the names of Amazon Web Services services.</p>
    pub service_collection: std::option::Option<crate::model::ServiceCollection>,
    /// <p>The Amazon Resource Names (ARNs) of the Amazon Web Services resources that generated this insight.</p>
    pub associated_resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ProactiveInsightSummary {
    /// <p>The ID of the proactive insight. </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the proactive insight. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The severity of the insight. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
    pub fn severity(&self) -> std::option::Option<&crate::model::InsightSeverity> {
        self.severity.as_ref()
    }
    /// <p>The status of the proactive insight. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::InsightStatus> {
        self.status.as_ref()
    }
    /// <p> A time ranged that specifies when the observed behavior in an insight started and ended. </p>
    pub fn insight_time_range(&self) -> std::option::Option<&crate::model::InsightTimeRange> {
        self.insight_time_range.as_ref()
    }
    /// <p> The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur. </p>
    pub fn prediction_time_range(&self) -> std::option::Option<&crate::model::PredictionTimeRange> {
        self.prediction_time_range.as_ref()
    }
    /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub fn resource_collection(&self) -> std::option::Option<&crate::model::ResourceCollection> {
        self.resource_collection.as_ref()
    }
    /// <p>A collection of the names of Amazon Web Services services.</p>
    pub fn service_collection(&self) -> std::option::Option<&crate::model::ServiceCollection> {
        self.service_collection.as_ref()
    }
    /// <p>The Amazon Resource Names (ARNs) of the Amazon Web Services resources that generated this insight.</p>
    pub fn associated_resource_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.associated_resource_arns.as_deref()
    }
}
impl std::fmt::Debug for ProactiveInsightSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProactiveInsightSummary");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("severity", &self.severity);
        formatter.field("status", &self.status);
        formatter.field("insight_time_range", &self.insight_time_range);
        formatter.field("prediction_time_range", &self.prediction_time_range);
        formatter.field("resource_collection", &self.resource_collection);
        formatter.field("service_collection", &self.service_collection);
        formatter.field("associated_resource_arns", &self.associated_resource_arns);
        formatter.finish()
    }
}
/// See [`ProactiveInsightSummary`](crate::model::ProactiveInsightSummary)
pub mod proactive_insight_summary {
    /// A builder for [`ProactiveInsightSummary`](crate::model::ProactiveInsightSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<crate::model::InsightSeverity>,
        pub(crate) status: std::option::Option<crate::model::InsightStatus>,
        pub(crate) insight_time_range: std::option::Option<crate::model::InsightTimeRange>,
        pub(crate) prediction_time_range: std::option::Option<crate::model::PredictionTimeRange>,
        pub(crate) resource_collection: std::option::Option<crate::model::ResourceCollection>,
        pub(crate) service_collection: std::option::Option<crate::model::ServiceCollection>,
        pub(crate) associated_resource_arns:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ID of the proactive insight. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the proactive insight. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the proactive insight. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the proactive insight. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The severity of the insight. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
        pub fn severity(mut self, input: crate::model::InsightSeverity) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>The severity of the insight. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
        pub fn set_severity(
            mut self,
            input: std::option::Option<crate::model::InsightSeverity>,
        ) -> Self {
            self.severity = input;
            self
        }
        /// <p>The status of the proactive insight. </p>
        pub fn status(mut self, input: crate::model::InsightStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the proactive insight. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::InsightStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> A time ranged that specifies when the observed behavior in an insight started and ended. </p>
        pub fn insight_time_range(mut self, input: crate::model::InsightTimeRange) -> Self {
            self.insight_time_range = Some(input);
            self
        }
        /// <p> A time ranged that specifies when the observed behavior in an insight started and ended. </p>
        pub fn set_insight_time_range(
            mut self,
            input: std::option::Option<crate::model::InsightTimeRange>,
        ) -> Self {
            self.insight_time_range = input;
            self
        }
        /// <p> The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur. </p>
        pub fn prediction_time_range(mut self, input: crate::model::PredictionTimeRange) -> Self {
            self.prediction_time_range = Some(input);
            self
        }
        /// <p> The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur. </p>
        pub fn set_prediction_time_range(
            mut self,
            input: std::option::Option<crate::model::PredictionTimeRange>,
        ) -> Self {
            self.prediction_time_range = input;
            self
        }
        /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn resource_collection(mut self, input: crate::model::ResourceCollection) -> Self {
            self.resource_collection = Some(input);
            self
        }
        /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn set_resource_collection(
            mut self,
            input: std::option::Option<crate::model::ResourceCollection>,
        ) -> Self {
            self.resource_collection = input;
            self
        }
        /// <p>A collection of the names of Amazon Web Services services.</p>
        pub fn service_collection(mut self, input: crate::model::ServiceCollection) -> Self {
            self.service_collection = Some(input);
            self
        }
        /// <p>A collection of the names of Amazon Web Services services.</p>
        pub fn set_service_collection(
            mut self,
            input: std::option::Option<crate::model::ServiceCollection>,
        ) -> Self {
            self.service_collection = input;
            self
        }
        /// Appends an item to `associated_resource_arns`.
        ///
        /// To override the contents of this collection use [`set_associated_resource_arns`](Self::set_associated_resource_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the Amazon Web Services resources that generated this insight.</p>
        pub fn associated_resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.associated_resource_arns.unwrap_or_default();
            v.push(input.into());
            self.associated_resource_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the Amazon Web Services resources that generated this insight.</p>
        pub fn set_associated_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.associated_resource_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`ProactiveInsightSummary`](crate::model::ProactiveInsightSummary)
        pub fn build(self) -> crate::model::ProactiveInsightSummary {
            crate::model::ProactiveInsightSummary {
                id: self.id,
                name: self.name,
                severity: self.severity,
                status: self.status,
                insight_time_range: self.insight_time_range,
                prediction_time_range: self.prediction_time_range,
                resource_collection: self.resource_collection,
                service_collection: self.service_collection,
                associated_resource_arns: self.associated_resource_arns,
            }
        }
    }
}
impl ProactiveInsightSummary {
    /// Creates a new builder-style object to manufacture [`ProactiveInsightSummary`](crate::model::ProactiveInsightSummary)
    pub fn builder() -> crate::model::proactive_insight_summary::Builder {
        crate::model::proactive_insight_summary::Builder::default()
    }
}

/// <p> The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PredictionTimeRange {
    /// <p> The time range during which a metric limit is expected to be exceeded. This applies to proactive insights only. </p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The time when the behavior in a proactive insight is expected to end. </p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl PredictionTimeRange {
    /// <p> The time range during which a metric limit is expected to be exceeded. This applies to proactive insights only. </p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p> The time when the behavior in a proactive insight is expected to end. </p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
}
impl std::fmt::Debug for PredictionTimeRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PredictionTimeRange");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.finish()
    }
}
/// See [`PredictionTimeRange`](crate::model::PredictionTimeRange)
pub mod prediction_time_range {
    /// A builder for [`PredictionTimeRange`](crate::model::PredictionTimeRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p> The time range during which a metric limit is expected to be exceeded. This applies to proactive insights only. </p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p> The time range during which a metric limit is expected to be exceeded. This applies to proactive insights only. </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p> The time when the behavior in a proactive insight is expected to end. </p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p> The time when the behavior in a proactive insight is expected to end. </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`PredictionTimeRange`](crate::model::PredictionTimeRange)
        pub fn build(self) -> crate::model::PredictionTimeRange {
            crate::model::PredictionTimeRange {
                start_time: self.start_time,
                end_time: self.end_time,
            }
        }
    }
}
impl PredictionTimeRange {
    /// Creates a new builder-style object to manufacture [`PredictionTimeRange`](crate::model::PredictionTimeRange)
    pub fn builder() -> crate::model::prediction_time_range::Builder {
        crate::model::prediction_time_range::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InsightType {
    #[allow(missing_docs)] // documentation missing in model
    Proactive,
    #[allow(missing_docs)] // documentation missing in model
    Reactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InsightType {
    fn from(s: &str) -> Self {
        match s {
            "PROACTIVE" => InsightType::Proactive,
            "REACTIVE" => InsightType::Reactive,
            other => InsightType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InsightType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InsightType::from(s))
    }
}
impl InsightType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InsightType::Proactive => "PROACTIVE",
            InsightType::Reactive => "REACTIVE",
            InsightType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PROACTIVE", "REACTIVE"]
    }
}
impl AsRef<str> for InsightType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Filters you can use to specify which events are returned when <code>ListEvents</code> is called. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchOrganizationInsightsFilters {
    /// <p> An array of severity values used to search for insights. </p>
    pub severities: std::option::Option<std::vec::Vec<crate::model::InsightSeverity>>,
    /// <p> An array of status values used to search for insights. </p>
    pub statuses: std::option::Option<std::vec::Vec<crate::model::InsightStatus>>,
    /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub resource_collection: std::option::Option<crate::model::ResourceCollection>,
    /// <p>A collection of the names of Amazon Web Services services.</p>
    pub service_collection: std::option::Option<crate::model::ServiceCollection>,
}
impl SearchOrganizationInsightsFilters {
    /// <p> An array of severity values used to search for insights. </p>
    pub fn severities(&self) -> std::option::Option<&[crate::model::InsightSeverity]> {
        self.severities.as_deref()
    }
    /// <p> An array of status values used to search for insights. </p>
    pub fn statuses(&self) -> std::option::Option<&[crate::model::InsightStatus]> {
        self.statuses.as_deref()
    }
    /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub fn resource_collection(&self) -> std::option::Option<&crate::model::ResourceCollection> {
        self.resource_collection.as_ref()
    }
    /// <p>A collection of the names of Amazon Web Services services.</p>
    pub fn service_collection(&self) -> std::option::Option<&crate::model::ServiceCollection> {
        self.service_collection.as_ref()
    }
}
impl std::fmt::Debug for SearchOrganizationInsightsFilters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchOrganizationInsightsFilters");
        formatter.field("severities", &self.severities);
        formatter.field("statuses", &self.statuses);
        formatter.field("resource_collection", &self.resource_collection);
        formatter.field("service_collection", &self.service_collection);
        formatter.finish()
    }
}
/// See [`SearchOrganizationInsightsFilters`](crate::model::SearchOrganizationInsightsFilters)
pub mod search_organization_insights_filters {
    /// A builder for [`SearchOrganizationInsightsFilters`](crate::model::SearchOrganizationInsightsFilters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) severities: std::option::Option<std::vec::Vec<crate::model::InsightSeverity>>,
        pub(crate) statuses: std::option::Option<std::vec::Vec<crate::model::InsightStatus>>,
        pub(crate) resource_collection: std::option::Option<crate::model::ResourceCollection>,
        pub(crate) service_collection: std::option::Option<crate::model::ServiceCollection>,
    }
    impl Builder {
        /// Appends an item to `severities`.
        ///
        /// To override the contents of this collection use [`set_severities`](Self::set_severities).
        ///
        /// <p> An array of severity values used to search for insights. </p>
        pub fn severities(mut self, input: crate::model::InsightSeverity) -> Self {
            let mut v = self.severities.unwrap_or_default();
            v.push(input);
            self.severities = Some(v);
            self
        }
        /// <p> An array of severity values used to search for insights. </p>
        pub fn set_severities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InsightSeverity>>,
        ) -> Self {
            self.severities = input;
            self
        }
        /// Appends an item to `statuses`.
        ///
        /// To override the contents of this collection use [`set_statuses`](Self::set_statuses).
        ///
        /// <p> An array of status values used to search for insights. </p>
        pub fn statuses(mut self, input: crate::model::InsightStatus) -> Self {
            let mut v = self.statuses.unwrap_or_default();
            v.push(input);
            self.statuses = Some(v);
            self
        }
        /// <p> An array of status values used to search for insights. </p>
        pub fn set_statuses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InsightStatus>>,
        ) -> Self {
            self.statuses = input;
            self
        }
        /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn resource_collection(mut self, input: crate::model::ResourceCollection) -> Self {
            self.resource_collection = Some(input);
            self
        }
        /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn set_resource_collection(
            mut self,
            input: std::option::Option<crate::model::ResourceCollection>,
        ) -> Self {
            self.resource_collection = input;
            self
        }
        /// <p>A collection of the names of Amazon Web Services services.</p>
        pub fn service_collection(mut self, input: crate::model::ServiceCollection) -> Self {
            self.service_collection = Some(input);
            self
        }
        /// <p>A collection of the names of Amazon Web Services services.</p>
        pub fn set_service_collection(
            mut self,
            input: std::option::Option<crate::model::ServiceCollection>,
        ) -> Self {
            self.service_collection = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchOrganizationInsightsFilters`](crate::model::SearchOrganizationInsightsFilters)
        pub fn build(self) -> crate::model::SearchOrganizationInsightsFilters {
            crate::model::SearchOrganizationInsightsFilters {
                severities: self.severities,
                statuses: self.statuses,
                resource_collection: self.resource_collection,
                service_collection: self.service_collection,
            }
        }
    }
}
impl SearchOrganizationInsightsFilters {
    /// Creates a new builder-style object to manufacture [`SearchOrganizationInsightsFilters`](crate::model::SearchOrganizationInsightsFilters)
    pub fn builder() -> crate::model::search_organization_insights_filters::Builder {
        crate::model::search_organization_insights_filters::Builder::default()
    }
}

/// <p> A time range used to specify when the behavior of an insight or anomaly started. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartTimeRange {
    /// <p> The start time of the time range. </p>
    pub from_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The end time of the time range. </p>
    pub to_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl StartTimeRange {
    /// <p> The start time of the time range. </p>
    pub fn from_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.from_time.as_ref()
    }
    /// <p> The end time of the time range. </p>
    pub fn to_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.to_time.as_ref()
    }
}
impl std::fmt::Debug for StartTimeRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartTimeRange");
        formatter.field("from_time", &self.from_time);
        formatter.field("to_time", &self.to_time);
        formatter.finish()
    }
}
/// See [`StartTimeRange`](crate::model::StartTimeRange)
pub mod start_time_range {
    /// A builder for [`StartTimeRange`](crate::model::StartTimeRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) to_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p> The start time of the time range. </p>
        pub fn from_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.from_time = Some(input);
            self
        }
        /// <p> The start time of the time range. </p>
        pub fn set_from_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.from_time = input;
            self
        }
        /// <p> The end time of the time range. </p>
        pub fn to_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.to_time = Some(input);
            self
        }
        /// <p> The end time of the time range. </p>
        pub fn set_to_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.to_time = input;
            self
        }
        /// Consumes the builder and constructs a [`StartTimeRange`](crate::model::StartTimeRange)
        pub fn build(self) -> crate::model::StartTimeRange {
            crate::model::StartTimeRange {
                from_time: self.from_time,
                to_time: self.to_time,
            }
        }
    }
}
impl StartTimeRange {
    /// Creates a new builder-style object to manufacture [`StartTimeRange`](crate::model::StartTimeRange)
    pub fn builder() -> crate::model::start_time_range::Builder {
        crate::model::start_time_range::Builder::default()
    }
}

/// <p> Specifies one or more severity values and one or more status values that are used to search for insights. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchInsightsFilters {
    /// <p> An array of severity values used to search for insights. </p>
    pub severities: std::option::Option<std::vec::Vec<crate::model::InsightSeverity>>,
    /// <p> An array of status values used to search for insights. </p>
    pub statuses: std::option::Option<std::vec::Vec<crate::model::InsightStatus>>,
    /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub resource_collection: std::option::Option<crate::model::ResourceCollection>,
    /// <p>A collection of the names of Amazon Web Services services.</p>
    pub service_collection: std::option::Option<crate::model::ServiceCollection>,
}
impl SearchInsightsFilters {
    /// <p> An array of severity values used to search for insights. </p>
    pub fn severities(&self) -> std::option::Option<&[crate::model::InsightSeverity]> {
        self.severities.as_deref()
    }
    /// <p> An array of status values used to search for insights. </p>
    pub fn statuses(&self) -> std::option::Option<&[crate::model::InsightStatus]> {
        self.statuses.as_deref()
    }
    /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub fn resource_collection(&self) -> std::option::Option<&crate::model::ResourceCollection> {
        self.resource_collection.as_ref()
    }
    /// <p>A collection of the names of Amazon Web Services services.</p>
    pub fn service_collection(&self) -> std::option::Option<&crate::model::ServiceCollection> {
        self.service_collection.as_ref()
    }
}
impl std::fmt::Debug for SearchInsightsFilters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchInsightsFilters");
        formatter.field("severities", &self.severities);
        formatter.field("statuses", &self.statuses);
        formatter.field("resource_collection", &self.resource_collection);
        formatter.field("service_collection", &self.service_collection);
        formatter.finish()
    }
}
/// See [`SearchInsightsFilters`](crate::model::SearchInsightsFilters)
pub mod search_insights_filters {
    /// A builder for [`SearchInsightsFilters`](crate::model::SearchInsightsFilters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) severities: std::option::Option<std::vec::Vec<crate::model::InsightSeverity>>,
        pub(crate) statuses: std::option::Option<std::vec::Vec<crate::model::InsightStatus>>,
        pub(crate) resource_collection: std::option::Option<crate::model::ResourceCollection>,
        pub(crate) service_collection: std::option::Option<crate::model::ServiceCollection>,
    }
    impl Builder {
        /// Appends an item to `severities`.
        ///
        /// To override the contents of this collection use [`set_severities`](Self::set_severities).
        ///
        /// <p> An array of severity values used to search for insights. </p>
        pub fn severities(mut self, input: crate::model::InsightSeverity) -> Self {
            let mut v = self.severities.unwrap_or_default();
            v.push(input);
            self.severities = Some(v);
            self
        }
        /// <p> An array of severity values used to search for insights. </p>
        pub fn set_severities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InsightSeverity>>,
        ) -> Self {
            self.severities = input;
            self
        }
        /// Appends an item to `statuses`.
        ///
        /// To override the contents of this collection use [`set_statuses`](Self::set_statuses).
        ///
        /// <p> An array of status values used to search for insights. </p>
        pub fn statuses(mut self, input: crate::model::InsightStatus) -> Self {
            let mut v = self.statuses.unwrap_or_default();
            v.push(input);
            self.statuses = Some(v);
            self
        }
        /// <p> An array of status values used to search for insights. </p>
        pub fn set_statuses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InsightStatus>>,
        ) -> Self {
            self.statuses = input;
            self
        }
        /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn resource_collection(mut self, input: crate::model::ResourceCollection) -> Self {
            self.resource_collection = Some(input);
            self
        }
        /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn set_resource_collection(
            mut self,
            input: std::option::Option<crate::model::ResourceCollection>,
        ) -> Self {
            self.resource_collection = input;
            self
        }
        /// <p>A collection of the names of Amazon Web Services services.</p>
        pub fn service_collection(mut self, input: crate::model::ServiceCollection) -> Self {
            self.service_collection = Some(input);
            self
        }
        /// <p>A collection of the names of Amazon Web Services services.</p>
        pub fn set_service_collection(
            mut self,
            input: std::option::Option<crate::model::ServiceCollection>,
        ) -> Self {
            self.service_collection = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchInsightsFilters`](crate::model::SearchInsightsFilters)
        pub fn build(self) -> crate::model::SearchInsightsFilters {
            crate::model::SearchInsightsFilters {
                severities: self.severities,
                statuses: self.statuses,
                resource_collection: self.resource_collection,
                service_collection: self.service_collection,
            }
        }
    }
}
impl SearchInsightsFilters {
    /// Creates a new builder-style object to manufacture [`SearchInsightsFilters`](crate::model::SearchInsightsFilters)
    pub fn builder() -> crate::model::search_insights_filters::Builder {
        crate::model::search_insights_filters::Builder::default()
    }
}

/// <p> Information about insight feedback received from a customer. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsightFeedback {
    /// <p> The insight feedback ID. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p> The feedback provided by the customer. </p>
    pub feedback: std::option::Option<crate::model::InsightFeedbackOption>,
}
impl InsightFeedback {
    /// <p> The insight feedback ID. </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p> The feedback provided by the customer. </p>
    pub fn feedback(&self) -> std::option::Option<&crate::model::InsightFeedbackOption> {
        self.feedback.as_ref()
    }
}
impl std::fmt::Debug for InsightFeedback {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsightFeedback");
        formatter.field("id", &self.id);
        formatter.field("feedback", &self.feedback);
        formatter.finish()
    }
}
/// See [`InsightFeedback`](crate::model::InsightFeedback)
pub mod insight_feedback {
    /// A builder for [`InsightFeedback`](crate::model::InsightFeedback)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) feedback: std::option::Option<crate::model::InsightFeedbackOption>,
    }
    impl Builder {
        /// <p> The insight feedback ID. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The insight feedback ID. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p> The feedback provided by the customer. </p>
        pub fn feedback(mut self, input: crate::model::InsightFeedbackOption) -> Self {
            self.feedback = Some(input);
            self
        }
        /// <p> The feedback provided by the customer. </p>
        pub fn set_feedback(
            mut self,
            input: std::option::Option<crate::model::InsightFeedbackOption>,
        ) -> Self {
            self.feedback = input;
            self
        }
        /// Consumes the builder and constructs a [`InsightFeedback`](crate::model::InsightFeedback)
        pub fn build(self) -> crate::model::InsightFeedback {
            crate::model::InsightFeedback {
                id: self.id,
                feedback: self.feedback,
            }
        }
    }
}
impl InsightFeedback {
    /// Creates a new builder-style object to manufacture [`InsightFeedback`](crate::model::InsightFeedback)
    pub fn builder() -> crate::model::insight_feedback::Builder {
        crate::model::insight_feedback::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InsightFeedbackOption {
    #[allow(missing_docs)] // documentation missing in model
    AlertTooSensitive,
    #[allow(missing_docs)] // documentation missing in model
    DataIncorrect,
    #[allow(missing_docs)] // documentation missing in model
    DataNoisyAnomaly,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationUseful,
    #[allow(missing_docs)] // documentation missing in model
    ValidCollection,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InsightFeedbackOption {
    fn from(s: &str) -> Self {
        match s {
            "ALERT_TOO_SENSITIVE" => InsightFeedbackOption::AlertTooSensitive,
            "DATA_INCORRECT" => InsightFeedbackOption::DataIncorrect,
            "DATA_NOISY_ANOMALY" => InsightFeedbackOption::DataNoisyAnomaly,
            "RECOMMENDATION_USEFUL" => InsightFeedbackOption::RecommendationUseful,
            "VALID_COLLECTION" => InsightFeedbackOption::ValidCollection,
            other => InsightFeedbackOption::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InsightFeedbackOption {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InsightFeedbackOption::from(s))
    }
}
impl InsightFeedbackOption {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InsightFeedbackOption::AlertTooSensitive => "ALERT_TOO_SENSITIVE",
            InsightFeedbackOption::DataIncorrect => "DATA_INCORRECT",
            InsightFeedbackOption::DataNoisyAnomaly => "DATA_NOISY_ANOMALY",
            InsightFeedbackOption::RecommendationUseful => "RECOMMENDATION_USEFUL",
            InsightFeedbackOption::ValidCollection => "VALID_COLLECTION",
            InsightFeedbackOption::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ALERT_TOO_SENSITIVE",
            "DATA_INCORRECT",
            "DATA_NOISY_ANOMALY",
            "RECOMMENDATION_USEFUL",
            "VALID_COLLECTION",
        ]
    }
}
impl AsRef<str> for InsightFeedbackOption {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Recommendation information to help you remediate detected anomalous behavior that generated an insight. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Recommendation {
    /// <p> A description of the problem. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> A hyperlink to information to help you address the problem. </p>
    pub link: std::option::Option<std::string::String>,
    /// <p> The name of the recommendation. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The reason DevOps Guru flagged the anomalous behavior as a problem. </p>
    pub reason: std::option::Option<std::string::String>,
    /// <p> Events that are related to the problem. Use these events to learn more about what's happening and to help address the issue. </p>
    pub related_events:
        std::option::Option<std::vec::Vec<crate::model::RecommendationRelatedEvent>>,
    /// <p> Anomalies that are related to the problem. Use these Anomalies to learn more about what's happening and to help address the issue. </p>
    pub related_anomalies:
        std::option::Option<std::vec::Vec<crate::model::RecommendationRelatedAnomaly>>,
    /// <p>The category type of the recommendation.</p>
    pub category: std::option::Option<std::string::String>,
}
impl Recommendation {
    /// <p> A description of the problem. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> A hyperlink to information to help you address the problem. </p>
    pub fn link(&self) -> std::option::Option<&str> {
        self.link.as_deref()
    }
    /// <p> The name of the recommendation. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> The reason DevOps Guru flagged the anomalous behavior as a problem. </p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
    /// <p> Events that are related to the problem. Use these events to learn more about what's happening and to help address the issue. </p>
    pub fn related_events(
        &self,
    ) -> std::option::Option<&[crate::model::RecommendationRelatedEvent]> {
        self.related_events.as_deref()
    }
    /// <p> Anomalies that are related to the problem. Use these Anomalies to learn more about what's happening and to help address the issue. </p>
    pub fn related_anomalies(
        &self,
    ) -> std::option::Option<&[crate::model::RecommendationRelatedAnomaly]> {
        self.related_anomalies.as_deref()
    }
    /// <p>The category type of the recommendation.</p>
    pub fn category(&self) -> std::option::Option<&str> {
        self.category.as_deref()
    }
}
impl std::fmt::Debug for Recommendation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Recommendation");
        formatter.field("description", &self.description);
        formatter.field("link", &self.link);
        formatter.field("name", &self.name);
        formatter.field("reason", &self.reason);
        formatter.field("related_events", &self.related_events);
        formatter.field("related_anomalies", &self.related_anomalies);
        formatter.field("category", &self.category);
        formatter.finish()
    }
}
/// See [`Recommendation`](crate::model::Recommendation)
pub mod recommendation {
    /// A builder for [`Recommendation`](crate::model::Recommendation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) link: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<std::string::String>,
        pub(crate) related_events:
            std::option::Option<std::vec::Vec<crate::model::RecommendationRelatedEvent>>,
        pub(crate) related_anomalies:
            std::option::Option<std::vec::Vec<crate::model::RecommendationRelatedAnomaly>>,
        pub(crate) category: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> A description of the problem. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> A description of the problem. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> A hyperlink to information to help you address the problem. </p>
        pub fn link(mut self, input: impl Into<std::string::String>) -> Self {
            self.link = Some(input.into());
            self
        }
        /// <p> A hyperlink to information to help you address the problem. </p>
        pub fn set_link(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link = input;
            self
        }
        /// <p> The name of the recommendation. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the recommendation. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The reason DevOps Guru flagged the anomalous behavior as a problem. </p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p> The reason DevOps Guru flagged the anomalous behavior as a problem. </p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Appends an item to `related_events`.
        ///
        /// To override the contents of this collection use [`set_related_events`](Self::set_related_events).
        ///
        /// <p> Events that are related to the problem. Use these events to learn more about what's happening and to help address the issue. </p>
        pub fn related_events(mut self, input: crate::model::RecommendationRelatedEvent) -> Self {
            let mut v = self.related_events.unwrap_or_default();
            v.push(input);
            self.related_events = Some(v);
            self
        }
        /// <p> Events that are related to the problem. Use these events to learn more about what's happening and to help address the issue. </p>
        pub fn set_related_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecommendationRelatedEvent>>,
        ) -> Self {
            self.related_events = input;
            self
        }
        /// Appends an item to `related_anomalies`.
        ///
        /// To override the contents of this collection use [`set_related_anomalies`](Self::set_related_anomalies).
        ///
        /// <p> Anomalies that are related to the problem. Use these Anomalies to learn more about what's happening and to help address the issue. </p>
        pub fn related_anomalies(
            mut self,
            input: crate::model::RecommendationRelatedAnomaly,
        ) -> Self {
            let mut v = self.related_anomalies.unwrap_or_default();
            v.push(input);
            self.related_anomalies = Some(v);
            self
        }
        /// <p> Anomalies that are related to the problem. Use these Anomalies to learn more about what's happening and to help address the issue. </p>
        pub fn set_related_anomalies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecommendationRelatedAnomaly>>,
        ) -> Self {
            self.related_anomalies = input;
            self
        }
        /// <p>The category type of the recommendation.</p>
        pub fn category(mut self, input: impl Into<std::string::String>) -> Self {
            self.category = Some(input.into());
            self
        }
        /// <p>The category type of the recommendation.</p>
        pub fn set_category(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.category = input;
            self
        }
        /// Consumes the builder and constructs a [`Recommendation`](crate::model::Recommendation)
        pub fn build(self) -> crate::model::Recommendation {
            crate::model::Recommendation {
                description: self.description,
                link: self.link,
                name: self.name,
                reason: self.reason,
                related_events: self.related_events,
                related_anomalies: self.related_anomalies,
                category: self.category,
            }
        }
    }
}
impl Recommendation {
    /// Creates a new builder-style object to manufacture [`Recommendation`](crate::model::Recommendation)
    pub fn builder() -> crate::model::recommendation::Builder {
        crate::model::recommendation::Builder::default()
    }
}

/// <p> Information about an anomaly that is related to a recommendation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecommendationRelatedAnomaly {
    /// <p> An array of objects that represent resources in which DevOps Guru detected anomalous behavior. Each object contains the name and type of the resource. </p>
    pub resources:
        std::option::Option<std::vec::Vec<crate::model::RecommendationRelatedAnomalyResource>>,
    /// <p> Information about where the anomalous behavior related the recommendation was found. For example, details in Amazon CloudWatch metrics. </p>
    pub source_details:
        std::option::Option<std::vec::Vec<crate::model::RecommendationRelatedAnomalySourceDetail>>,
    /// <p>The ID of an anomaly that generated the insight with this recommendation.</p>
    pub anomaly_id: std::option::Option<std::string::String>,
}
impl RecommendationRelatedAnomaly {
    /// <p> An array of objects that represent resources in which DevOps Guru detected anomalous behavior. Each object contains the name and type of the resource. </p>
    pub fn resources(
        &self,
    ) -> std::option::Option<&[crate::model::RecommendationRelatedAnomalyResource]> {
        self.resources.as_deref()
    }
    /// <p> Information about where the anomalous behavior related the recommendation was found. For example, details in Amazon CloudWatch metrics. </p>
    pub fn source_details(
        &self,
    ) -> std::option::Option<&[crate::model::RecommendationRelatedAnomalySourceDetail]> {
        self.source_details.as_deref()
    }
    /// <p>The ID of an anomaly that generated the insight with this recommendation.</p>
    pub fn anomaly_id(&self) -> std::option::Option<&str> {
        self.anomaly_id.as_deref()
    }
}
impl std::fmt::Debug for RecommendationRelatedAnomaly {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecommendationRelatedAnomaly");
        formatter.field("resources", &self.resources);
        formatter.field("source_details", &self.source_details);
        formatter.field("anomaly_id", &self.anomaly_id);
        formatter.finish()
    }
}
/// See [`RecommendationRelatedAnomaly`](crate::model::RecommendationRelatedAnomaly)
pub mod recommendation_related_anomaly {
    /// A builder for [`RecommendationRelatedAnomaly`](crate::model::RecommendationRelatedAnomaly)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resources:
            std::option::Option<std::vec::Vec<crate::model::RecommendationRelatedAnomalyResource>>,
        pub(crate) source_details: std::option::Option<
            std::vec::Vec<crate::model::RecommendationRelatedAnomalySourceDetail>,
        >,
        pub(crate) anomaly_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p> An array of objects that represent resources in which DevOps Guru detected anomalous behavior. Each object contains the name and type of the resource. </p>
        pub fn resources(
            mut self,
            input: crate::model::RecommendationRelatedAnomalyResource,
        ) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input);
            self.resources = Some(v);
            self
        }
        /// <p> An array of objects that represent resources in which DevOps Guru detected anomalous behavior. Each object contains the name and type of the resource. </p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::RecommendationRelatedAnomalyResource>,
            >,
        ) -> Self {
            self.resources = input;
            self
        }
        /// Appends an item to `source_details`.
        ///
        /// To override the contents of this collection use [`set_source_details`](Self::set_source_details).
        ///
        /// <p> Information about where the anomalous behavior related the recommendation was found. For example, details in Amazon CloudWatch metrics. </p>
        pub fn source_details(
            mut self,
            input: crate::model::RecommendationRelatedAnomalySourceDetail,
        ) -> Self {
            let mut v = self.source_details.unwrap_or_default();
            v.push(input);
            self.source_details = Some(v);
            self
        }
        /// <p> Information about where the anomalous behavior related the recommendation was found. For example, details in Amazon CloudWatch metrics. </p>
        pub fn set_source_details(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::RecommendationRelatedAnomalySourceDetail>,
            >,
        ) -> Self {
            self.source_details = input;
            self
        }
        /// <p>The ID of an anomaly that generated the insight with this recommendation.</p>
        pub fn anomaly_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_id = Some(input.into());
            self
        }
        /// <p>The ID of an anomaly that generated the insight with this recommendation.</p>
        pub fn set_anomaly_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.anomaly_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RecommendationRelatedAnomaly`](crate::model::RecommendationRelatedAnomaly)
        pub fn build(self) -> crate::model::RecommendationRelatedAnomaly {
            crate::model::RecommendationRelatedAnomaly {
                resources: self.resources,
                source_details: self.source_details,
                anomaly_id: self.anomaly_id,
            }
        }
    }
}
impl RecommendationRelatedAnomaly {
    /// Creates a new builder-style object to manufacture [`RecommendationRelatedAnomaly`](crate::model::RecommendationRelatedAnomaly)
    pub fn builder() -> crate::model::recommendation_related_anomaly::Builder {
        crate::model::recommendation_related_anomaly::Builder::default()
    }
}

/// <p> Contains an array of <code>RecommendationRelatedCloudWatchMetricsSourceDetail</code> objects that contain the name and namespace of an Amazon CloudWatch metric. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecommendationRelatedAnomalySourceDetail {
    /// <p> An array of <code>CloudWatchMetricsDetail</code> objects that contains information about the analyzed metrics that displayed anomalous behavior. </p>
    pub cloud_watch_metrics: std::option::Option<
        std::vec::Vec<crate::model::RecommendationRelatedCloudWatchMetricsSourceDetail>,
    >,
}
impl RecommendationRelatedAnomalySourceDetail {
    /// <p> An array of <code>CloudWatchMetricsDetail</code> objects that contains information about the analyzed metrics that displayed anomalous behavior. </p>
    pub fn cloud_watch_metrics(
        &self,
    ) -> std::option::Option<&[crate::model::RecommendationRelatedCloudWatchMetricsSourceDetail]>
    {
        self.cloud_watch_metrics.as_deref()
    }
}
impl std::fmt::Debug for RecommendationRelatedAnomalySourceDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecommendationRelatedAnomalySourceDetail");
        formatter.field("cloud_watch_metrics", &self.cloud_watch_metrics);
        formatter.finish()
    }
}
/// See [`RecommendationRelatedAnomalySourceDetail`](crate::model::RecommendationRelatedAnomalySourceDetail)
pub mod recommendation_related_anomaly_source_detail {
    /// A builder for [`RecommendationRelatedAnomalySourceDetail`](crate::model::RecommendationRelatedAnomalySourceDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_watch_metrics: std::option::Option<
            std::vec::Vec<crate::model::RecommendationRelatedCloudWatchMetricsSourceDetail>,
        >,
    }
    impl Builder {
        /// Appends an item to `cloud_watch_metrics`.
        ///
        /// To override the contents of this collection use [`set_cloud_watch_metrics`](Self::set_cloud_watch_metrics).
        ///
        /// <p> An array of <code>CloudWatchMetricsDetail</code> objects that contains information about the analyzed metrics that displayed anomalous behavior. </p>
        pub fn cloud_watch_metrics(
            mut self,
            input: crate::model::RecommendationRelatedCloudWatchMetricsSourceDetail,
        ) -> Self {
            let mut v = self.cloud_watch_metrics.unwrap_or_default();
            v.push(input);
            self.cloud_watch_metrics = Some(v);
            self
        }
        /// <p> An array of <code>CloudWatchMetricsDetail</code> objects that contains information about the analyzed metrics that displayed anomalous behavior. </p>
        pub fn set_cloud_watch_metrics(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::RecommendationRelatedCloudWatchMetricsSourceDetail>,
            >,
        ) -> Self {
            self.cloud_watch_metrics = input;
            self
        }
        /// Consumes the builder and constructs a [`RecommendationRelatedAnomalySourceDetail`](crate::model::RecommendationRelatedAnomalySourceDetail)
        pub fn build(self) -> crate::model::RecommendationRelatedAnomalySourceDetail {
            crate::model::RecommendationRelatedAnomalySourceDetail {
                cloud_watch_metrics: self.cloud_watch_metrics,
            }
        }
    }
}
impl RecommendationRelatedAnomalySourceDetail {
    /// Creates a new builder-style object to manufacture [`RecommendationRelatedAnomalySourceDetail`](crate::model::RecommendationRelatedAnomalySourceDetail)
    pub fn builder() -> crate::model::recommendation_related_anomaly_source_detail::Builder {
        crate::model::recommendation_related_anomaly_source_detail::Builder::default()
    }
}

/// <p> Information about an Amazon CloudWatch metric that is analyzed by DevOps Guru. It is one of many analyzed metrics that are used to generate insights. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecommendationRelatedCloudWatchMetricsSourceDetail {
    /// <p>The name of the CloudWatch metric.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>The namespace of the CloudWatch metric. A namespace is a container for CloudWatch metrics.</p>
    pub namespace: std::option::Option<std::string::String>,
}
impl RecommendationRelatedCloudWatchMetricsSourceDetail {
    /// <p>The name of the CloudWatch metric.</p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p>The namespace of the CloudWatch metric. A namespace is a container for CloudWatch metrics.</p>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
}
impl std::fmt::Debug for RecommendationRelatedCloudWatchMetricsSourceDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecommendationRelatedCloudWatchMetricsSourceDetail");
        formatter.field("metric_name", &self.metric_name);
        formatter.field("namespace", &self.namespace);
        formatter.finish()
    }
}
/// See [`RecommendationRelatedCloudWatchMetricsSourceDetail`](crate::model::RecommendationRelatedCloudWatchMetricsSourceDetail)
pub mod recommendation_related_cloud_watch_metrics_source_detail {
    /// A builder for [`RecommendationRelatedCloudWatchMetricsSourceDetail`](crate::model::RecommendationRelatedCloudWatchMetricsSourceDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the CloudWatch metric.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The name of the CloudWatch metric.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The namespace of the CloudWatch metric. A namespace is a container for CloudWatch metrics.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace of the CloudWatch metric. A namespace is a container for CloudWatch metrics.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Consumes the builder and constructs a [`RecommendationRelatedCloudWatchMetricsSourceDetail`](crate::model::RecommendationRelatedCloudWatchMetricsSourceDetail)
        pub fn build(self) -> crate::model::RecommendationRelatedCloudWatchMetricsSourceDetail {
            crate::model::RecommendationRelatedCloudWatchMetricsSourceDetail {
                metric_name: self.metric_name,
                namespace: self.namespace,
            }
        }
    }
}
impl RecommendationRelatedCloudWatchMetricsSourceDetail {
    /// Creates a new builder-style object to manufacture [`RecommendationRelatedCloudWatchMetricsSourceDetail`](crate::model::RecommendationRelatedCloudWatchMetricsSourceDetail)
    pub fn builder(
    ) -> crate::model::recommendation_related_cloud_watch_metrics_source_detail::Builder {
        crate::model::recommendation_related_cloud_watch_metrics_source_detail::Builder::default()
    }
}

/// <p> Information about a resource in which DevOps Guru detected anomalous behavior. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecommendationRelatedAnomalyResource {
    /// <p> The name of the resource. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The type of the resource. Resource types take the same form that is used by Amazon Web Services CloudFormation resource type identifiers, <code>service-provider::service-name::data-type-name</code>. For example, <code>AWS::RDS::DBCluster</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services resource and property types reference</a> in the <i>Amazon Web Services CloudFormation User Guide</i>.</p>
    pub r#type: std::option::Option<std::string::String>,
}
impl RecommendationRelatedAnomalyResource {
    /// <p> The name of the resource. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> The type of the resource. Resource types take the same form that is used by Amazon Web Services CloudFormation resource type identifiers, <code>service-provider::service-name::data-type-name</code>. For example, <code>AWS::RDS::DBCluster</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services resource and property types reference</a> in the <i>Amazon Web Services CloudFormation User Guide</i>.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for RecommendationRelatedAnomalyResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecommendationRelatedAnomalyResource");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`RecommendationRelatedAnomalyResource`](crate::model::RecommendationRelatedAnomalyResource)
pub mod recommendation_related_anomaly_resource {
    /// A builder for [`RecommendationRelatedAnomalyResource`](crate::model::RecommendationRelatedAnomalyResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the resource. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the resource. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The type of the resource. Resource types take the same form that is used by Amazon Web Services CloudFormation resource type identifiers, <code>service-provider::service-name::data-type-name</code>. For example, <code>AWS::RDS::DBCluster</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services resource and property types reference</a> in the <i>Amazon Web Services CloudFormation User Guide</i>.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p> The type of the resource. Resource types take the same form that is used by Amazon Web Services CloudFormation resource type identifiers, <code>service-provider::service-name::data-type-name</code>. For example, <code>AWS::RDS::DBCluster</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services resource and property types reference</a> in the <i>Amazon Web Services CloudFormation User Guide</i>.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`RecommendationRelatedAnomalyResource`](crate::model::RecommendationRelatedAnomalyResource)
        pub fn build(self) -> crate::model::RecommendationRelatedAnomalyResource {
            crate::model::RecommendationRelatedAnomalyResource {
                name: self.name,
                r#type: self.r#type,
            }
        }
    }
}
impl RecommendationRelatedAnomalyResource {
    /// Creates a new builder-style object to manufacture [`RecommendationRelatedAnomalyResource`](crate::model::RecommendationRelatedAnomalyResource)
    pub fn builder() -> crate::model::recommendation_related_anomaly_resource::Builder {
        crate::model::recommendation_related_anomaly_resource::Builder::default()
    }
}

/// <p> Information about an event that is related to a recommendation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecommendationRelatedEvent {
    /// <p> The name of the event. This corresponds to the <code>Name</code> field in an <code>Event</code> object. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> A <code>ResourceCollection</code> object that contains arrays of the names of Amazon Web Services CloudFormation stacks. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub resources:
        std::option::Option<std::vec::Vec<crate::model::RecommendationRelatedEventResource>>,
}
impl RecommendationRelatedEvent {
    /// <p> The name of the event. This corresponds to the <code>Name</code> field in an <code>Event</code> object. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> A <code>ResourceCollection</code> object that contains arrays of the names of Amazon Web Services CloudFormation stacks. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub fn resources(
        &self,
    ) -> std::option::Option<&[crate::model::RecommendationRelatedEventResource]> {
        self.resources.as_deref()
    }
}
impl std::fmt::Debug for RecommendationRelatedEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecommendationRelatedEvent");
        formatter.field("name", &self.name);
        formatter.field("resources", &self.resources);
        formatter.finish()
    }
}
/// See [`RecommendationRelatedEvent`](crate::model::RecommendationRelatedEvent)
pub mod recommendation_related_event {
    /// A builder for [`RecommendationRelatedEvent`](crate::model::RecommendationRelatedEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) resources:
            std::option::Option<std::vec::Vec<crate::model::RecommendationRelatedEventResource>>,
    }
    impl Builder {
        /// <p> The name of the event. This corresponds to the <code>Name</code> field in an <code>Event</code> object. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the event. This corresponds to the <code>Name</code> field in an <code>Event</code> object. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p> A <code>ResourceCollection</code> object that contains arrays of the names of Amazon Web Services CloudFormation stacks. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn resources(
            mut self,
            input: crate::model::RecommendationRelatedEventResource,
        ) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input);
            self.resources = Some(v);
            self
        }
        /// <p> A <code>ResourceCollection</code> object that contains arrays of the names of Amazon Web Services CloudFormation stacks. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::RecommendationRelatedEventResource>,
            >,
        ) -> Self {
            self.resources = input;
            self
        }
        /// Consumes the builder and constructs a [`RecommendationRelatedEvent`](crate::model::RecommendationRelatedEvent)
        pub fn build(self) -> crate::model::RecommendationRelatedEvent {
            crate::model::RecommendationRelatedEvent {
                name: self.name,
                resources: self.resources,
            }
        }
    }
}
impl RecommendationRelatedEvent {
    /// Creates a new builder-style object to manufacture [`RecommendationRelatedEvent`](crate::model::RecommendationRelatedEvent)
    pub fn builder() -> crate::model::recommendation_related_event::Builder {
        crate::model::recommendation_related_event::Builder::default()
    }
}

/// <p> Information about an Amazon Web Services resource that emitted and event that is related to a recommendation in an insight. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecommendationRelatedEventResource {
    /// <p> The name of the resource that emitted the event. This corresponds to the <code>Name</code> field in an <code>EventResource</code> object. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The type of the resource that emitted the event. This corresponds to the <code>Type</code> field in an <code>EventResource</code> object. </p>
    pub r#type: std::option::Option<std::string::String>,
}
impl RecommendationRelatedEventResource {
    /// <p> The name of the resource that emitted the event. This corresponds to the <code>Name</code> field in an <code>EventResource</code> object. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> The type of the resource that emitted the event. This corresponds to the <code>Type</code> field in an <code>EventResource</code> object. </p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for RecommendationRelatedEventResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecommendationRelatedEventResource");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`RecommendationRelatedEventResource`](crate::model::RecommendationRelatedEventResource)
pub mod recommendation_related_event_resource {
    /// A builder for [`RecommendationRelatedEventResource`](crate::model::RecommendationRelatedEventResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the resource that emitted the event. This corresponds to the <code>Name</code> field in an <code>EventResource</code> object. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the resource that emitted the event. This corresponds to the <code>Name</code> field in an <code>EventResource</code> object. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The type of the resource that emitted the event. This corresponds to the <code>Type</code> field in an <code>EventResource</code> object. </p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p> The type of the resource that emitted the event. This corresponds to the <code>Type</code> field in an <code>EventResource</code> object. </p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`RecommendationRelatedEventResource`](crate::model::RecommendationRelatedEventResource)
        pub fn build(self) -> crate::model::RecommendationRelatedEventResource {
            crate::model::RecommendationRelatedEventResource {
                name: self.name,
                r#type: self.r#type,
            }
        }
    }
}
impl RecommendationRelatedEventResource {
    /// Creates a new builder-style object to manufacture [`RecommendationRelatedEventResource`](crate::model::RecommendationRelatedEventResource)
    pub fn builder() -> crate::model::recommendation_related_event_resource::Builder {
        crate::model::recommendation_related_event_resource::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Locale {
    #[allow(missing_docs)] // documentation missing in model
    DeDe,
    #[allow(missing_docs)] // documentation missing in model
    EnGb,
    #[allow(missing_docs)] // documentation missing in model
    EnUs,
    #[allow(missing_docs)] // documentation missing in model
    EsEs,
    #[allow(missing_docs)] // documentation missing in model
    FrFr,
    #[allow(missing_docs)] // documentation missing in model
    ItIt,
    #[allow(missing_docs)] // documentation missing in model
    JaJp,
    #[allow(missing_docs)] // documentation missing in model
    KoKr,
    #[allow(missing_docs)] // documentation missing in model
    PtBr,
    #[allow(missing_docs)] // documentation missing in model
    ZhCn,
    #[allow(missing_docs)] // documentation missing in model
    ZhTw,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Locale {
    fn from(s: &str) -> Self {
        match s {
            "DE_DE" => Locale::DeDe,
            "EN_GB" => Locale::EnGb,
            "EN_US" => Locale::EnUs,
            "ES_ES" => Locale::EsEs,
            "FR_FR" => Locale::FrFr,
            "IT_IT" => Locale::ItIt,
            "JA_JP" => Locale::JaJp,
            "KO_KR" => Locale::KoKr,
            "PT_BR" => Locale::PtBr,
            "ZH_CN" => Locale::ZhCn,
            "ZH_TW" => Locale::ZhTw,
            other => Locale::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Locale {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Locale::from(s))
    }
}
impl Locale {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Locale::DeDe => "DE_DE",
            Locale::EnGb => "EN_GB",
            Locale::EnUs => "EN_US",
            Locale::EsEs => "ES_ES",
            Locale::FrFr => "FR_FR",
            Locale::ItIt => "IT_IT",
            Locale::JaJp => "JA_JP",
            Locale::KoKr => "KO_KR",
            Locale::PtBr => "PT_BR",
            Locale::ZhCn => "ZH_CN",
            Locale::ZhTw => "ZH_TW",
            Locale::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DE_DE", "EN_GB", "EN_US", "ES_ES", "FR_FR", "IT_IT", "JA_JP", "KO_KR", "PT_BR",
            "ZH_CN", "ZH_TW",
        ]
    }
}
impl AsRef<str> for Locale {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a reactive insight. This object is returned by <code>DescribeInsight</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReactiveOrganizationInsightSummary {
    /// <p>The ID of the insight summary.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Web Services account. </p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The ID of the organizational unit.</p>
    pub organizational_unit_id: std::option::Option<std::string::String>,
    /// <p>The name of the insight summary.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p> An array of severity values used to search for insights. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
    pub severity: std::option::Option<crate::model::InsightSeverity>,
    /// <p> An array of status values used to search for insights. </p>
    pub status: std::option::Option<crate::model::InsightStatus>,
    /// <p> A time ranged that specifies when the observed behavior in an insight started and ended. </p>
    pub insight_time_range: std::option::Option<crate::model::InsightTimeRange>,
    /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub resource_collection: std::option::Option<crate::model::ResourceCollection>,
    /// <p>A collection of the names of Amazon Web Services services.</p>
    pub service_collection: std::option::Option<crate::model::ServiceCollection>,
}
impl ReactiveOrganizationInsightSummary {
    /// <p>The ID of the insight summary.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The ID of the Amazon Web Services account. </p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The ID of the organizational unit.</p>
    pub fn organizational_unit_id(&self) -> std::option::Option<&str> {
        self.organizational_unit_id.as_deref()
    }
    /// <p>The name of the insight summary.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> An array of severity values used to search for insights. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
    pub fn severity(&self) -> std::option::Option<&crate::model::InsightSeverity> {
        self.severity.as_ref()
    }
    /// <p> An array of status values used to search for insights. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::InsightStatus> {
        self.status.as_ref()
    }
    /// <p> A time ranged that specifies when the observed behavior in an insight started and ended. </p>
    pub fn insight_time_range(&self) -> std::option::Option<&crate::model::InsightTimeRange> {
        self.insight_time_range.as_ref()
    }
    /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub fn resource_collection(&self) -> std::option::Option<&crate::model::ResourceCollection> {
        self.resource_collection.as_ref()
    }
    /// <p>A collection of the names of Amazon Web Services services.</p>
    pub fn service_collection(&self) -> std::option::Option<&crate::model::ServiceCollection> {
        self.service_collection.as_ref()
    }
}
impl std::fmt::Debug for ReactiveOrganizationInsightSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReactiveOrganizationInsightSummary");
        formatter.field("id", &self.id);
        formatter.field("account_id", &self.account_id);
        formatter.field("organizational_unit_id", &self.organizational_unit_id);
        formatter.field("name", &self.name);
        formatter.field("severity", &self.severity);
        formatter.field("status", &self.status);
        formatter.field("insight_time_range", &self.insight_time_range);
        formatter.field("resource_collection", &self.resource_collection);
        formatter.field("service_collection", &self.service_collection);
        formatter.finish()
    }
}
/// See [`ReactiveOrganizationInsightSummary`](crate::model::ReactiveOrganizationInsightSummary)
pub mod reactive_organization_insight_summary {
    /// A builder for [`ReactiveOrganizationInsightSummary`](crate::model::ReactiveOrganizationInsightSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) organizational_unit_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<crate::model::InsightSeverity>,
        pub(crate) status: std::option::Option<crate::model::InsightStatus>,
        pub(crate) insight_time_range: std::option::Option<crate::model::InsightTimeRange>,
        pub(crate) resource_collection: std::option::Option<crate::model::ResourceCollection>,
        pub(crate) service_collection: std::option::Option<crate::model::ServiceCollection>,
    }
    impl Builder {
        /// <p>The ID of the insight summary.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the insight summary.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The ID of the organizational unit.</p>
        pub fn organizational_unit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organizational_unit_id = Some(input.into());
            self
        }
        /// <p>The ID of the organizational unit.</p>
        pub fn set_organizational_unit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organizational_unit_id = input;
            self
        }
        /// <p>The name of the insight summary.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the insight summary.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> An array of severity values used to search for insights. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
        pub fn severity(mut self, input: crate::model::InsightSeverity) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p> An array of severity values used to search for insights. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
        pub fn set_severity(
            mut self,
            input: std::option::Option<crate::model::InsightSeverity>,
        ) -> Self {
            self.severity = input;
            self
        }
        /// <p> An array of status values used to search for insights. </p>
        pub fn status(mut self, input: crate::model::InsightStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> An array of status values used to search for insights. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::InsightStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> A time ranged that specifies when the observed behavior in an insight started and ended. </p>
        pub fn insight_time_range(mut self, input: crate::model::InsightTimeRange) -> Self {
            self.insight_time_range = Some(input);
            self
        }
        /// <p> A time ranged that specifies when the observed behavior in an insight started and ended. </p>
        pub fn set_insight_time_range(
            mut self,
            input: std::option::Option<crate::model::InsightTimeRange>,
        ) -> Self {
            self.insight_time_range = input;
            self
        }
        /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn resource_collection(mut self, input: crate::model::ResourceCollection) -> Self {
            self.resource_collection = Some(input);
            self
        }
        /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn set_resource_collection(
            mut self,
            input: std::option::Option<crate::model::ResourceCollection>,
        ) -> Self {
            self.resource_collection = input;
            self
        }
        /// <p>A collection of the names of Amazon Web Services services.</p>
        pub fn service_collection(mut self, input: crate::model::ServiceCollection) -> Self {
            self.service_collection = Some(input);
            self
        }
        /// <p>A collection of the names of Amazon Web Services services.</p>
        pub fn set_service_collection(
            mut self,
            input: std::option::Option<crate::model::ServiceCollection>,
        ) -> Self {
            self.service_collection = input;
            self
        }
        /// Consumes the builder and constructs a [`ReactiveOrganizationInsightSummary`](crate::model::ReactiveOrganizationInsightSummary)
        pub fn build(self) -> crate::model::ReactiveOrganizationInsightSummary {
            crate::model::ReactiveOrganizationInsightSummary {
                id: self.id,
                account_id: self.account_id,
                organizational_unit_id: self.organizational_unit_id,
                name: self.name,
                severity: self.severity,
                status: self.status,
                insight_time_range: self.insight_time_range,
                resource_collection: self.resource_collection,
                service_collection: self.service_collection,
            }
        }
    }
}
impl ReactiveOrganizationInsightSummary {
    /// Creates a new builder-style object to manufacture [`ReactiveOrganizationInsightSummary`](crate::model::ReactiveOrganizationInsightSummary)
    pub fn builder() -> crate::model::reactive_organization_insight_summary::Builder {
        crate::model::reactive_organization_insight_summary::Builder::default()
    }
}

/// <p>Details about a proactive insight. This object is returned by <code>DescribeInsight</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProactiveOrganizationInsightSummary {
    /// <p>The ID of the insight summary.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Web Services account.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The ID of the organizational unit.</p>
    pub organizational_unit_id: std::option::Option<std::string::String>,
    /// <p>The name of the insight summary.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p> An array of severity values used to search for insights. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
    pub severity: std::option::Option<crate::model::InsightSeverity>,
    /// <p> An array of status values used to search for insights. </p>
    pub status: std::option::Option<crate::model::InsightStatus>,
    /// <p> A time ranged that specifies when the observed behavior in an insight started and ended. </p>
    pub insight_time_range: std::option::Option<crate::model::InsightTimeRange>,
    /// <p> The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur. </p>
    pub prediction_time_range: std::option::Option<crate::model::PredictionTimeRange>,
    /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub resource_collection: std::option::Option<crate::model::ResourceCollection>,
    /// <p>A collection of the names of Amazon Web Services services.</p>
    pub service_collection: std::option::Option<crate::model::ServiceCollection>,
}
impl ProactiveOrganizationInsightSummary {
    /// <p>The ID of the insight summary.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The ID of the Amazon Web Services account.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The ID of the organizational unit.</p>
    pub fn organizational_unit_id(&self) -> std::option::Option<&str> {
        self.organizational_unit_id.as_deref()
    }
    /// <p>The name of the insight summary.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> An array of severity values used to search for insights. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
    pub fn severity(&self) -> std::option::Option<&crate::model::InsightSeverity> {
        self.severity.as_ref()
    }
    /// <p> An array of status values used to search for insights. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::InsightStatus> {
        self.status.as_ref()
    }
    /// <p> A time ranged that specifies when the observed behavior in an insight started and ended. </p>
    pub fn insight_time_range(&self) -> std::option::Option<&crate::model::InsightTimeRange> {
        self.insight_time_range.as_ref()
    }
    /// <p> The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur. </p>
    pub fn prediction_time_range(&self) -> std::option::Option<&crate::model::PredictionTimeRange> {
        self.prediction_time_range.as_ref()
    }
    /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub fn resource_collection(&self) -> std::option::Option<&crate::model::ResourceCollection> {
        self.resource_collection.as_ref()
    }
    /// <p>A collection of the names of Amazon Web Services services.</p>
    pub fn service_collection(&self) -> std::option::Option<&crate::model::ServiceCollection> {
        self.service_collection.as_ref()
    }
}
impl std::fmt::Debug for ProactiveOrganizationInsightSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProactiveOrganizationInsightSummary");
        formatter.field("id", &self.id);
        formatter.field("account_id", &self.account_id);
        formatter.field("organizational_unit_id", &self.organizational_unit_id);
        formatter.field("name", &self.name);
        formatter.field("severity", &self.severity);
        formatter.field("status", &self.status);
        formatter.field("insight_time_range", &self.insight_time_range);
        formatter.field("prediction_time_range", &self.prediction_time_range);
        formatter.field("resource_collection", &self.resource_collection);
        formatter.field("service_collection", &self.service_collection);
        formatter.finish()
    }
}
/// See [`ProactiveOrganizationInsightSummary`](crate::model::ProactiveOrganizationInsightSummary)
pub mod proactive_organization_insight_summary {
    /// A builder for [`ProactiveOrganizationInsightSummary`](crate::model::ProactiveOrganizationInsightSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) organizational_unit_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<crate::model::InsightSeverity>,
        pub(crate) status: std::option::Option<crate::model::InsightStatus>,
        pub(crate) insight_time_range: std::option::Option<crate::model::InsightTimeRange>,
        pub(crate) prediction_time_range: std::option::Option<crate::model::PredictionTimeRange>,
        pub(crate) resource_collection: std::option::Option<crate::model::ResourceCollection>,
        pub(crate) service_collection: std::option::Option<crate::model::ServiceCollection>,
    }
    impl Builder {
        /// <p>The ID of the insight summary.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the insight summary.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ID of the Amazon Web Services account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The ID of the organizational unit.</p>
        pub fn organizational_unit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organizational_unit_id = Some(input.into());
            self
        }
        /// <p>The ID of the organizational unit.</p>
        pub fn set_organizational_unit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organizational_unit_id = input;
            self
        }
        /// <p>The name of the insight summary.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the insight summary.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> An array of severity values used to search for insights. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
        pub fn severity(mut self, input: crate::model::InsightSeverity) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p> An array of severity values used to search for insights. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
        pub fn set_severity(
            mut self,
            input: std::option::Option<crate::model::InsightSeverity>,
        ) -> Self {
            self.severity = input;
            self
        }
        /// <p> An array of status values used to search for insights. </p>
        pub fn status(mut self, input: crate::model::InsightStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> An array of status values used to search for insights. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::InsightStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> A time ranged that specifies when the observed behavior in an insight started and ended. </p>
        pub fn insight_time_range(mut self, input: crate::model::InsightTimeRange) -> Self {
            self.insight_time_range = Some(input);
            self
        }
        /// <p> A time ranged that specifies when the observed behavior in an insight started and ended. </p>
        pub fn set_insight_time_range(
            mut self,
            input: std::option::Option<crate::model::InsightTimeRange>,
        ) -> Self {
            self.insight_time_range = input;
            self
        }
        /// <p> The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur. </p>
        pub fn prediction_time_range(mut self, input: crate::model::PredictionTimeRange) -> Self {
            self.prediction_time_range = Some(input);
            self
        }
        /// <p> The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur. </p>
        pub fn set_prediction_time_range(
            mut self,
            input: std::option::Option<crate::model::PredictionTimeRange>,
        ) -> Self {
            self.prediction_time_range = input;
            self
        }
        /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn resource_collection(mut self, input: crate::model::ResourceCollection) -> Self {
            self.resource_collection = Some(input);
            self
        }
        /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn set_resource_collection(
            mut self,
            input: std::option::Option<crate::model::ResourceCollection>,
        ) -> Self {
            self.resource_collection = input;
            self
        }
        /// <p>A collection of the names of Amazon Web Services services.</p>
        pub fn service_collection(mut self, input: crate::model::ServiceCollection) -> Self {
            self.service_collection = Some(input);
            self
        }
        /// <p>A collection of the names of Amazon Web Services services.</p>
        pub fn set_service_collection(
            mut self,
            input: std::option::Option<crate::model::ServiceCollection>,
        ) -> Self {
            self.service_collection = input;
            self
        }
        /// Consumes the builder and constructs a [`ProactiveOrganizationInsightSummary`](crate::model::ProactiveOrganizationInsightSummary)
        pub fn build(self) -> crate::model::ProactiveOrganizationInsightSummary {
            crate::model::ProactiveOrganizationInsightSummary {
                id: self.id,
                account_id: self.account_id,
                organizational_unit_id: self.organizational_unit_id,
                name: self.name,
                severity: self.severity,
                status: self.status,
                insight_time_range: self.insight_time_range,
                prediction_time_range: self.prediction_time_range,
                resource_collection: self.resource_collection,
                service_collection: self.service_collection,
            }
        }
    }
}
impl ProactiveOrganizationInsightSummary {
    /// Creates a new builder-style object to manufacture [`ProactiveOrganizationInsightSummary`](crate::model::ProactiveOrganizationInsightSummary)
    pub fn builder() -> crate::model::proactive_organization_insight_summary::Builder {
        crate::model::proactive_organization_insight_summary::Builder::default()
    }
}

/// <p> A filter used by <code>ListInsights</code> to specify which insights to return. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInsightsStatusFilter {
    /// <p> A <code>ListInsightsAnyStatusFilter</code> that specifies ongoing insights that are either <code>REACTIVE</code> or <code>PROACTIVE</code>. </p>
    pub ongoing: std::option::Option<crate::model::ListInsightsOngoingStatusFilter>,
    /// <p> A <code>ListInsightsClosedStatusFilter</code> that specifies closed insights that are either <code>REACTIVE</code> or <code>PROACTIVE</code>. </p>
    pub closed: std::option::Option<crate::model::ListInsightsClosedStatusFilter>,
    /// <p> A <code>ListInsightsAnyStatusFilter</code> that specifies insights of any status that are either <code>REACTIVE</code> or <code>PROACTIVE</code>. </p>
    pub any: std::option::Option<crate::model::ListInsightsAnyStatusFilter>,
}
impl ListInsightsStatusFilter {
    /// <p> A <code>ListInsightsAnyStatusFilter</code> that specifies ongoing insights that are either <code>REACTIVE</code> or <code>PROACTIVE</code>. </p>
    pub fn ongoing(&self) -> std::option::Option<&crate::model::ListInsightsOngoingStatusFilter> {
        self.ongoing.as_ref()
    }
    /// <p> A <code>ListInsightsClosedStatusFilter</code> that specifies closed insights that are either <code>REACTIVE</code> or <code>PROACTIVE</code>. </p>
    pub fn closed(&self) -> std::option::Option<&crate::model::ListInsightsClosedStatusFilter> {
        self.closed.as_ref()
    }
    /// <p> A <code>ListInsightsAnyStatusFilter</code> that specifies insights of any status that are either <code>REACTIVE</code> or <code>PROACTIVE</code>. </p>
    pub fn any(&self) -> std::option::Option<&crate::model::ListInsightsAnyStatusFilter> {
        self.any.as_ref()
    }
}
impl std::fmt::Debug for ListInsightsStatusFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInsightsStatusFilter");
        formatter.field("ongoing", &self.ongoing);
        formatter.field("closed", &self.closed);
        formatter.field("any", &self.any);
        formatter.finish()
    }
}
/// See [`ListInsightsStatusFilter`](crate::model::ListInsightsStatusFilter)
pub mod list_insights_status_filter {
    /// A builder for [`ListInsightsStatusFilter`](crate::model::ListInsightsStatusFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ongoing: std::option::Option<crate::model::ListInsightsOngoingStatusFilter>,
        pub(crate) closed: std::option::Option<crate::model::ListInsightsClosedStatusFilter>,
        pub(crate) any: std::option::Option<crate::model::ListInsightsAnyStatusFilter>,
    }
    impl Builder {
        /// <p> A <code>ListInsightsAnyStatusFilter</code> that specifies ongoing insights that are either <code>REACTIVE</code> or <code>PROACTIVE</code>. </p>
        pub fn ongoing(mut self, input: crate::model::ListInsightsOngoingStatusFilter) -> Self {
            self.ongoing = Some(input);
            self
        }
        /// <p> A <code>ListInsightsAnyStatusFilter</code> that specifies ongoing insights that are either <code>REACTIVE</code> or <code>PROACTIVE</code>. </p>
        pub fn set_ongoing(
            mut self,
            input: std::option::Option<crate::model::ListInsightsOngoingStatusFilter>,
        ) -> Self {
            self.ongoing = input;
            self
        }
        /// <p> A <code>ListInsightsClosedStatusFilter</code> that specifies closed insights that are either <code>REACTIVE</code> or <code>PROACTIVE</code>. </p>
        pub fn closed(mut self, input: crate::model::ListInsightsClosedStatusFilter) -> Self {
            self.closed = Some(input);
            self
        }
        /// <p> A <code>ListInsightsClosedStatusFilter</code> that specifies closed insights that are either <code>REACTIVE</code> or <code>PROACTIVE</code>. </p>
        pub fn set_closed(
            mut self,
            input: std::option::Option<crate::model::ListInsightsClosedStatusFilter>,
        ) -> Self {
            self.closed = input;
            self
        }
        /// <p> A <code>ListInsightsAnyStatusFilter</code> that specifies insights of any status that are either <code>REACTIVE</code> or <code>PROACTIVE</code>. </p>
        pub fn any(mut self, input: crate::model::ListInsightsAnyStatusFilter) -> Self {
            self.any = Some(input);
            self
        }
        /// <p> A <code>ListInsightsAnyStatusFilter</code> that specifies insights of any status that are either <code>REACTIVE</code> or <code>PROACTIVE</code>. </p>
        pub fn set_any(
            mut self,
            input: std::option::Option<crate::model::ListInsightsAnyStatusFilter>,
        ) -> Self {
            self.any = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInsightsStatusFilter`](crate::model::ListInsightsStatusFilter)
        pub fn build(self) -> crate::model::ListInsightsStatusFilter {
            crate::model::ListInsightsStatusFilter {
                ongoing: self.ongoing,
                closed: self.closed,
                any: self.any,
            }
        }
    }
}
impl ListInsightsStatusFilter {
    /// Creates a new builder-style object to manufacture [`ListInsightsStatusFilter`](crate::model::ListInsightsStatusFilter)
    pub fn builder() -> crate::model::list_insights_status_filter::Builder {
        crate::model::list_insights_status_filter::Builder::default()
    }
}

/// <p> Used to filter for insights that have any status. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInsightsAnyStatusFilter {
    /// <p> Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights. </p>
    pub r#type: std::option::Option<crate::model::InsightType>,
    /// <p> A time range used to specify when the behavior of the filtered insights started. </p>
    pub start_time_range: std::option::Option<crate::model::StartTimeRange>,
}
impl ListInsightsAnyStatusFilter {
    /// <p> Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights. </p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::InsightType> {
        self.r#type.as_ref()
    }
    /// <p> A time range used to specify when the behavior of the filtered insights started. </p>
    pub fn start_time_range(&self) -> std::option::Option<&crate::model::StartTimeRange> {
        self.start_time_range.as_ref()
    }
}
impl std::fmt::Debug for ListInsightsAnyStatusFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInsightsAnyStatusFilter");
        formatter.field("r#type", &self.r#type);
        formatter.field("start_time_range", &self.start_time_range);
        formatter.finish()
    }
}
/// See [`ListInsightsAnyStatusFilter`](crate::model::ListInsightsAnyStatusFilter)
pub mod list_insights_any_status_filter {
    /// A builder for [`ListInsightsAnyStatusFilter`](crate::model::ListInsightsAnyStatusFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::InsightType>,
        pub(crate) start_time_range: std::option::Option<crate::model::StartTimeRange>,
    }
    impl Builder {
        /// <p> Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights. </p>
        pub fn r#type(mut self, input: crate::model::InsightType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p> Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights. </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::InsightType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p> A time range used to specify when the behavior of the filtered insights started. </p>
        pub fn start_time_range(mut self, input: crate::model::StartTimeRange) -> Self {
            self.start_time_range = Some(input);
            self
        }
        /// <p> A time range used to specify when the behavior of the filtered insights started. </p>
        pub fn set_start_time_range(
            mut self,
            input: std::option::Option<crate::model::StartTimeRange>,
        ) -> Self {
            self.start_time_range = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInsightsAnyStatusFilter`](crate::model::ListInsightsAnyStatusFilter)
        pub fn build(self) -> crate::model::ListInsightsAnyStatusFilter {
            crate::model::ListInsightsAnyStatusFilter {
                r#type: self.r#type,
                start_time_range: self.start_time_range,
            }
        }
    }
}
impl ListInsightsAnyStatusFilter {
    /// Creates a new builder-style object to manufacture [`ListInsightsAnyStatusFilter`](crate::model::ListInsightsAnyStatusFilter)
    pub fn builder() -> crate::model::list_insights_any_status_filter::Builder {
        crate::model::list_insights_any_status_filter::Builder::default()
    }
}

/// <p> Used to filter for insights that have the status <code>CLOSED</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInsightsClosedStatusFilter {
    /// <p> Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights. </p>
    pub r#type: std::option::Option<crate::model::InsightType>,
    /// <p> A time range used to specify when the behavior of the filtered insights ended. </p>
    pub end_time_range: std::option::Option<crate::model::EndTimeRange>,
}
impl ListInsightsClosedStatusFilter {
    /// <p> Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights. </p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::InsightType> {
        self.r#type.as_ref()
    }
    /// <p> A time range used to specify when the behavior of the filtered insights ended. </p>
    pub fn end_time_range(&self) -> std::option::Option<&crate::model::EndTimeRange> {
        self.end_time_range.as_ref()
    }
}
impl std::fmt::Debug for ListInsightsClosedStatusFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInsightsClosedStatusFilter");
        formatter.field("r#type", &self.r#type);
        formatter.field("end_time_range", &self.end_time_range);
        formatter.finish()
    }
}
/// See [`ListInsightsClosedStatusFilter`](crate::model::ListInsightsClosedStatusFilter)
pub mod list_insights_closed_status_filter {
    /// A builder for [`ListInsightsClosedStatusFilter`](crate::model::ListInsightsClosedStatusFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::InsightType>,
        pub(crate) end_time_range: std::option::Option<crate::model::EndTimeRange>,
    }
    impl Builder {
        /// <p> Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights. </p>
        pub fn r#type(mut self, input: crate::model::InsightType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p> Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights. </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::InsightType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p> A time range used to specify when the behavior of the filtered insights ended. </p>
        pub fn end_time_range(mut self, input: crate::model::EndTimeRange) -> Self {
            self.end_time_range = Some(input);
            self
        }
        /// <p> A time range used to specify when the behavior of the filtered insights ended. </p>
        pub fn set_end_time_range(
            mut self,
            input: std::option::Option<crate::model::EndTimeRange>,
        ) -> Self {
            self.end_time_range = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInsightsClosedStatusFilter`](crate::model::ListInsightsClosedStatusFilter)
        pub fn build(self) -> crate::model::ListInsightsClosedStatusFilter {
            crate::model::ListInsightsClosedStatusFilter {
                r#type: self.r#type,
                end_time_range: self.end_time_range,
            }
        }
    }
}
impl ListInsightsClosedStatusFilter {
    /// Creates a new builder-style object to manufacture [`ListInsightsClosedStatusFilter`](crate::model::ListInsightsClosedStatusFilter)
    pub fn builder() -> crate::model::list_insights_closed_status_filter::Builder {
        crate::model::list_insights_closed_status_filter::Builder::default()
    }
}

/// <p> A range of time that specifies when anomalous behavior in an anomaly or insight ended. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndTimeRange {
    /// <p> The earliest end time in the time range. </p>
    pub from_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The latest end time in the time range. </p>
    pub to_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl EndTimeRange {
    /// <p> The earliest end time in the time range. </p>
    pub fn from_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.from_time.as_ref()
    }
    /// <p> The latest end time in the time range. </p>
    pub fn to_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.to_time.as_ref()
    }
}
impl std::fmt::Debug for EndTimeRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndTimeRange");
        formatter.field("from_time", &self.from_time);
        formatter.field("to_time", &self.to_time);
        formatter.finish()
    }
}
/// See [`EndTimeRange`](crate::model::EndTimeRange)
pub mod end_time_range {
    /// A builder for [`EndTimeRange`](crate::model::EndTimeRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) to_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p> The earliest end time in the time range. </p>
        pub fn from_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.from_time = Some(input);
            self
        }
        /// <p> The earliest end time in the time range. </p>
        pub fn set_from_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.from_time = input;
            self
        }
        /// <p> The latest end time in the time range. </p>
        pub fn to_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.to_time = Some(input);
            self
        }
        /// <p> The latest end time in the time range. </p>
        pub fn set_to_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.to_time = input;
            self
        }
        /// Consumes the builder and constructs a [`EndTimeRange`](crate::model::EndTimeRange)
        pub fn build(self) -> crate::model::EndTimeRange {
            crate::model::EndTimeRange {
                from_time: self.from_time,
                to_time: self.to_time,
            }
        }
    }
}
impl EndTimeRange {
    /// Creates a new builder-style object to manufacture [`EndTimeRange`](crate::model::EndTimeRange)
    pub fn builder() -> crate::model::end_time_range::Builder {
        crate::model::end_time_range::Builder::default()
    }
}

/// <p> Used to filter for insights that have the status <code>ONGOING</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInsightsOngoingStatusFilter {
    /// <p> Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights. </p>
    pub r#type: std::option::Option<crate::model::InsightType>,
}
impl ListInsightsOngoingStatusFilter {
    /// <p> Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights. </p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::InsightType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for ListInsightsOngoingStatusFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInsightsOngoingStatusFilter");
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`ListInsightsOngoingStatusFilter`](crate::model::ListInsightsOngoingStatusFilter)
pub mod list_insights_ongoing_status_filter {
    /// A builder for [`ListInsightsOngoingStatusFilter`](crate::model::ListInsightsOngoingStatusFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::InsightType>,
    }
    impl Builder {
        /// <p> Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights. </p>
        pub fn r#type(mut self, input: crate::model::InsightType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p> Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights. </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::InsightType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInsightsOngoingStatusFilter`](crate::model::ListInsightsOngoingStatusFilter)
        pub fn build(self) -> crate::model::ListInsightsOngoingStatusFilter {
            crate::model::ListInsightsOngoingStatusFilter {
                r#type: self.r#type,
            }
        }
    }
}
impl ListInsightsOngoingStatusFilter {
    /// Creates a new builder-style object to manufacture [`ListInsightsOngoingStatusFilter`](crate::model::ListInsightsOngoingStatusFilter)
    pub fn builder() -> crate::model::list_insights_ongoing_status_filter::Builder {
        crate::model::list_insights_ongoing_status_filter::Builder::default()
    }
}

/// <p> Information about a notification channel. A notification channel is used to notify you when DevOps Guru creates an insight. The one supported notification channel is Amazon Simple Notification Service (Amazon SNS). </p>
/// <p>If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html">Permissions for cross account Amazon SNS topics</a>.</p>
/// <p>If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key Management Service customer-managed key (CMK), then you must add permissions to the CMK. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html">Permissions for Amazon Web Services KMS–encrypted Amazon SNS topics</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotificationChannel {
    /// <p> The ID of a notification channel. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p> A <code>NotificationChannelConfig</code> object that contains information about configured notification channels. </p>
    pub config: std::option::Option<crate::model::NotificationChannelConfig>,
}
impl NotificationChannel {
    /// <p> The ID of a notification channel. </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p> A <code>NotificationChannelConfig</code> object that contains information about configured notification channels. </p>
    pub fn config(&self) -> std::option::Option<&crate::model::NotificationChannelConfig> {
        self.config.as_ref()
    }
}
impl std::fmt::Debug for NotificationChannel {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotificationChannel");
        formatter.field("id", &self.id);
        formatter.field("config", &self.config);
        formatter.finish()
    }
}
/// See [`NotificationChannel`](crate::model::NotificationChannel)
pub mod notification_channel {
    /// A builder for [`NotificationChannel`](crate::model::NotificationChannel)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) config: std::option::Option<crate::model::NotificationChannelConfig>,
    }
    impl Builder {
        /// <p> The ID of a notification channel. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The ID of a notification channel. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p> A <code>NotificationChannelConfig</code> object that contains information about configured notification channels. </p>
        pub fn config(mut self, input: crate::model::NotificationChannelConfig) -> Self {
            self.config = Some(input);
            self
        }
        /// <p> A <code>NotificationChannelConfig</code> object that contains information about configured notification channels. </p>
        pub fn set_config(
            mut self,
            input: std::option::Option<crate::model::NotificationChannelConfig>,
        ) -> Self {
            self.config = input;
            self
        }
        /// Consumes the builder and constructs a [`NotificationChannel`](crate::model::NotificationChannel)
        pub fn build(self) -> crate::model::NotificationChannel {
            crate::model::NotificationChannel {
                id: self.id,
                config: self.config,
            }
        }
    }
}
impl NotificationChannel {
    /// Creates a new builder-style object to manufacture [`NotificationChannel`](crate::model::NotificationChannel)
    pub fn builder() -> crate::model::notification_channel::Builder {
        crate::model::notification_channel::Builder::default()
    }
}

/// <p> Information about notification channels you have configured with DevOps Guru. The one supported notification channel is Amazon Simple Notification Service (Amazon SNS).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotificationChannelConfig {
    /// <p> Information about a notification channel configured in DevOps Guru to send notifications when insights are created. </p>
    /// <p>If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html">Permissions for cross account Amazon SNS topics</a>.</p>
    /// <p>If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key Management Service customer-managed key (CMK), then you must add permissions to the CMK. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html">Permissions for Amazon Web Services KMS–encrypted Amazon SNS topics</a>.</p>
    pub sns: std::option::Option<crate::model::SnsChannelConfig>,
}
impl NotificationChannelConfig {
    /// <p> Information about a notification channel configured in DevOps Guru to send notifications when insights are created. </p>
    /// <p>If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html">Permissions for cross account Amazon SNS topics</a>.</p>
    /// <p>If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key Management Service customer-managed key (CMK), then you must add permissions to the CMK. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html">Permissions for Amazon Web Services KMS–encrypted Amazon SNS topics</a>.</p>
    pub fn sns(&self) -> std::option::Option<&crate::model::SnsChannelConfig> {
        self.sns.as_ref()
    }
}
impl std::fmt::Debug for NotificationChannelConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotificationChannelConfig");
        formatter.field("sns", &self.sns);
        formatter.finish()
    }
}
/// See [`NotificationChannelConfig`](crate::model::NotificationChannelConfig)
pub mod notification_channel_config {
    /// A builder for [`NotificationChannelConfig`](crate::model::NotificationChannelConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sns: std::option::Option<crate::model::SnsChannelConfig>,
    }
    impl Builder {
        /// <p> Information about a notification channel configured in DevOps Guru to send notifications when insights are created. </p>
        /// <p>If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html">Permissions for cross account Amazon SNS topics</a>.</p>
        /// <p>If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key Management Service customer-managed key (CMK), then you must add permissions to the CMK. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html">Permissions for Amazon Web Services KMS–encrypted Amazon SNS topics</a>.</p>
        pub fn sns(mut self, input: crate::model::SnsChannelConfig) -> Self {
            self.sns = Some(input);
            self
        }
        /// <p> Information about a notification channel configured in DevOps Guru to send notifications when insights are created. </p>
        /// <p>If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html">Permissions for cross account Amazon SNS topics</a>.</p>
        /// <p>If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key Management Service customer-managed key (CMK), then you must add permissions to the CMK. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html">Permissions for Amazon Web Services KMS–encrypted Amazon SNS topics</a>.</p>
        pub fn set_sns(
            mut self,
            input: std::option::Option<crate::model::SnsChannelConfig>,
        ) -> Self {
            self.sns = input;
            self
        }
        /// Consumes the builder and constructs a [`NotificationChannelConfig`](crate::model::NotificationChannelConfig)
        pub fn build(self) -> crate::model::NotificationChannelConfig {
            crate::model::NotificationChannelConfig { sns: self.sns }
        }
    }
}
impl NotificationChannelConfig {
    /// Creates a new builder-style object to manufacture [`NotificationChannelConfig`](crate::model::NotificationChannelConfig)
    pub fn builder() -> crate::model::notification_channel_config::Builder {
        crate::model::notification_channel_config::Builder::default()
    }
}

/// <p> Contains the Amazon Resource Name (ARN) of an Amazon Simple Notification Service topic. </p>
/// <p>If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html">Permissions for cross account Amazon SNS topics</a>.</p>
/// <p>If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key Management Service customer-managed key (CMK), then you must add permissions to the CMK. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html">Permissions for Amazon Web Services KMS–encrypted Amazon SNS topics</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnsChannelConfig {
    /// <p> The Amazon Resource Name (ARN) of an Amazon Simple Notification Service topic. </p>
    pub topic_arn: std::option::Option<std::string::String>,
}
impl SnsChannelConfig {
    /// <p> The Amazon Resource Name (ARN) of an Amazon Simple Notification Service topic. </p>
    pub fn topic_arn(&self) -> std::option::Option<&str> {
        self.topic_arn.as_deref()
    }
}
impl std::fmt::Debug for SnsChannelConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnsChannelConfig");
        formatter.field("topic_arn", &self.topic_arn);
        formatter.finish()
    }
}
/// See [`SnsChannelConfig`](crate::model::SnsChannelConfig)
pub mod sns_channel_config {
    /// A builder for [`SnsChannelConfig`](crate::model::SnsChannelConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of an Amazon Simple Notification Service topic. </p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of an Amazon Simple Notification Service topic. </p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`SnsChannelConfig`](crate::model::SnsChannelConfig)
        pub fn build(self) -> crate::model::SnsChannelConfig {
            crate::model::SnsChannelConfig {
                topic_arn: self.topic_arn,
            }
        }
    }
}
impl SnsChannelConfig {
    /// Creates a new builder-style object to manufacture [`SnsChannelConfig`](crate::model::SnsChannelConfig)
    pub fn builder() -> crate::model::sns_channel_config::Builder {
        crate::model::sns_channel_config::Builder::default()
    }
}

/// <p> An Amazon Web Services resource event. Amazon Web Services resource events and metrics are analyzed by DevOps Guru to find anomalous behavior and provide recommendations to improve your operational solutions. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Event {
    /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub resource_collection: std::option::Option<crate::model::ResourceCollection>,
    /// <p> The ID of the event. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p> A <code>Timestamp</code> that specifies the time the event occurred. </p>
    pub time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The Amazon Web Services source that emitted the event. </p>
    pub event_source: std::option::Option<std::string::String>,
    /// <p> The name of the event. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, where DevOps Guru analysis found the event. </p>
    pub data_source: std::option::Option<crate::model::EventDataSource>,
    /// <p> The class of the event. The class specifies what the event is related to, such as an infrastructure change, a deployment, or a schema change. </p>
    pub event_class: std::option::Option<crate::model::EventClass>,
    /// <p> An <code>EventResource</code> object that contains information about the resource that emitted the event. </p>
    pub resources: std::option::Option<std::vec::Vec<crate::model::EventResource>>,
}
impl Event {
    /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub fn resource_collection(&self) -> std::option::Option<&crate::model::ResourceCollection> {
        self.resource_collection.as_ref()
    }
    /// <p> The ID of the event. </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p> A <code>Timestamp</code> that specifies the time the event occurred. </p>
    pub fn time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.time.as_ref()
    }
    /// <p> The Amazon Web Services source that emitted the event. </p>
    pub fn event_source(&self) -> std::option::Option<&str> {
        self.event_source.as_deref()
    }
    /// <p> The name of the event. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, where DevOps Guru analysis found the event. </p>
    pub fn data_source(&self) -> std::option::Option<&crate::model::EventDataSource> {
        self.data_source.as_ref()
    }
    /// <p> The class of the event. The class specifies what the event is related to, such as an infrastructure change, a deployment, or a schema change. </p>
    pub fn event_class(&self) -> std::option::Option<&crate::model::EventClass> {
        self.event_class.as_ref()
    }
    /// <p> An <code>EventResource</code> object that contains information about the resource that emitted the event. </p>
    pub fn resources(&self) -> std::option::Option<&[crate::model::EventResource]> {
        self.resources.as_deref()
    }
}
impl std::fmt::Debug for Event {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Event");
        formatter.field("resource_collection", &self.resource_collection);
        formatter.field("id", &self.id);
        formatter.field("time", &self.time);
        formatter.field("event_source", &self.event_source);
        formatter.field("name", &self.name);
        formatter.field("data_source", &self.data_source);
        formatter.field("event_class", &self.event_class);
        formatter.field("resources", &self.resources);
        formatter.finish()
    }
}
/// See [`Event`](crate::model::Event)
pub mod event {
    /// A builder for [`Event`](crate::model::Event)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_collection: std::option::Option<crate::model::ResourceCollection>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) event_source: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) data_source: std::option::Option<crate::model::EventDataSource>,
        pub(crate) event_class: std::option::Option<crate::model::EventClass>,
        pub(crate) resources: std::option::Option<std::vec::Vec<crate::model::EventResource>>,
    }
    impl Builder {
        /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn resource_collection(mut self, input: crate::model::ResourceCollection) -> Self {
            self.resource_collection = Some(input);
            self
        }
        /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn set_resource_collection(
            mut self,
            input: std::option::Option<crate::model::ResourceCollection>,
        ) -> Self {
            self.resource_collection = input;
            self
        }
        /// <p> The ID of the event. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The ID of the event. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p> A <code>Timestamp</code> that specifies the time the event occurred. </p>
        pub fn time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.time = Some(input);
            self
        }
        /// <p> A <code>Timestamp</code> that specifies the time the event occurred. </p>
        pub fn set_time(mut self, input: std::option::Option<aws_smithy_types::DateTime>) -> Self {
            self.time = input;
            self
        }
        /// <p> The Amazon Web Services source that emitted the event. </p>
        pub fn event_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_source = Some(input.into());
            self
        }
        /// <p> The Amazon Web Services source that emitted the event. </p>
        pub fn set_event_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_source = input;
            self
        }
        /// <p> The name of the event. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the event. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, where DevOps Guru analysis found the event. </p>
        pub fn data_source(mut self, input: crate::model::EventDataSource) -> Self {
            self.data_source = Some(input);
            self
        }
        /// <p> The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, where DevOps Guru analysis found the event. </p>
        pub fn set_data_source(
            mut self,
            input: std::option::Option<crate::model::EventDataSource>,
        ) -> Self {
            self.data_source = input;
            self
        }
        /// <p> The class of the event. The class specifies what the event is related to, such as an infrastructure change, a deployment, or a schema change. </p>
        pub fn event_class(mut self, input: crate::model::EventClass) -> Self {
            self.event_class = Some(input);
            self
        }
        /// <p> The class of the event. The class specifies what the event is related to, such as an infrastructure change, a deployment, or a schema change. </p>
        pub fn set_event_class(
            mut self,
            input: std::option::Option<crate::model::EventClass>,
        ) -> Self {
            self.event_class = input;
            self
        }
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p> An <code>EventResource</code> object that contains information about the resource that emitted the event. </p>
        pub fn resources(mut self, input: crate::model::EventResource) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input);
            self.resources = Some(v);
            self
        }
        /// <p> An <code>EventResource</code> object that contains information about the resource that emitted the event. </p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventResource>>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// Consumes the builder and constructs a [`Event`](crate::model::Event)
        pub fn build(self) -> crate::model::Event {
            crate::model::Event {
                resource_collection: self.resource_collection,
                id: self.id,
                time: self.time,
                event_source: self.event_source,
                name: self.name,
                data_source: self.data_source,
                event_class: self.event_class,
                resources: self.resources,
            }
        }
    }
}
impl Event {
    /// Creates a new builder-style object to manufacture [`Event`](crate::model::Event)
    pub fn builder() -> crate::model::event::Builder {
        crate::model::event::Builder::default()
    }
}

/// <p> The Amazon Web Services resource that emitted an event. Amazon Web Services resource events and metrics are analyzed by DevOps Guru to find anomalous behavior and provide recommendations to improve your operational solutions. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventResource {
    /// <p> The type of resource that emitted an event. </p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p> The name of the resource that emitted an event. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) of the resource that emitted an event. </p>
    pub arn: std::option::Option<std::string::String>,
}
impl EventResource {
    /// <p> The type of resource that emitted an event. </p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p> The name of the resource that emitted an event. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) of the resource that emitted an event. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for EventResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventResource");
        formatter.field("r#type", &self.r#type);
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`EventResource`](crate::model::EventResource)
pub mod event_resource {
    /// A builder for [`EventResource`](crate::model::EventResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The type of resource that emitted an event. </p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p> The type of resource that emitted an event. </p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p> The name of the resource that emitted an event. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the resource that emitted an event. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the resource that emitted an event. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the resource that emitted an event. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`EventResource`](crate::model::EventResource)
        pub fn build(self) -> crate::model::EventResource {
            crate::model::EventResource {
                r#type: self.r#type,
                name: self.name,
                arn: self.arn,
            }
        }
    }
}
impl EventResource {
    /// Creates a new builder-style object to manufacture [`EventResource`](crate::model::EventResource)
    pub fn builder() -> crate::model::event_resource::Builder {
        crate::model::event_resource::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventClass {
    #[allow(missing_docs)] // documentation missing in model
    ConfigChange,
    #[allow(missing_docs)] // documentation missing in model
    Deployment,
    #[allow(missing_docs)] // documentation missing in model
    Infrastructure,
    #[allow(missing_docs)] // documentation missing in model
    SchemaChange,
    #[allow(missing_docs)] // documentation missing in model
    SecurityChange,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventClass {
    fn from(s: &str) -> Self {
        match s {
            "CONFIG_CHANGE" => EventClass::ConfigChange,
            "DEPLOYMENT" => EventClass::Deployment,
            "INFRASTRUCTURE" => EventClass::Infrastructure,
            "SCHEMA_CHANGE" => EventClass::SchemaChange,
            "SECURITY_CHANGE" => EventClass::SecurityChange,
            other => EventClass::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventClass {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventClass::from(s))
    }
}
impl EventClass {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventClass::ConfigChange => "CONFIG_CHANGE",
            EventClass::Deployment => "DEPLOYMENT",
            EventClass::Infrastructure => "INFRASTRUCTURE",
            EventClass::SchemaChange => "SCHEMA_CHANGE",
            EventClass::SecurityChange => "SECURITY_CHANGE",
            EventClass::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CONFIG_CHANGE",
            "DEPLOYMENT",
            "INFRASTRUCTURE",
            "SCHEMA_CHANGE",
            "SECURITY_CHANGE",
        ]
    }
}
impl AsRef<str> for EventClass {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventDataSource {
    #[allow(missing_docs)] // documentation missing in model
    AwsCloudTrail,
    #[allow(missing_docs)] // documentation missing in model
    AwsCodeDeploy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventDataSource {
    fn from(s: &str) -> Self {
        match s {
            "AWS_CLOUD_TRAIL" => EventDataSource::AwsCloudTrail,
            "AWS_CODE_DEPLOY" => EventDataSource::AwsCodeDeploy,
            other => EventDataSource::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventDataSource {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventDataSource::from(s))
    }
}
impl EventDataSource {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventDataSource::AwsCloudTrail => "AWS_CLOUD_TRAIL",
            EventDataSource::AwsCodeDeploy => "AWS_CODE_DEPLOY",
            EventDataSource::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS_CLOUD_TRAIL", "AWS_CODE_DEPLOY"]
    }
}
impl AsRef<str> for EventDataSource {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Filters you can use to specify which events are returned when <code>ListEvents</code> is called. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEventsFilters {
    /// <p> An ID of an insight that is related to the events you want to filter for. </p>
    pub insight_id: std::option::Option<std::string::String>,
    /// <p> A time range during which you want the filtered events to have occurred. </p>
    pub event_time_range: std::option::Option<crate::model::EventTimeRange>,
    /// <p> The class of the events you want to filter for, such as an infrastructure change, a deployment, or a schema change. </p>
    pub event_class: std::option::Option<crate::model::EventClass>,
    /// <p> The Amazon Web Services source that emitted the events you want to filter for. </p>
    pub event_source: std::option::Option<std::string::String>,
    /// <p> The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, of the events you want returned. </p>
    pub data_source: std::option::Option<crate::model::EventDataSource>,
    /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub resource_collection: std::option::Option<crate::model::ResourceCollection>,
}
impl ListEventsFilters {
    /// <p> An ID of an insight that is related to the events you want to filter for. </p>
    pub fn insight_id(&self) -> std::option::Option<&str> {
        self.insight_id.as_deref()
    }
    /// <p> A time range during which you want the filtered events to have occurred. </p>
    pub fn event_time_range(&self) -> std::option::Option<&crate::model::EventTimeRange> {
        self.event_time_range.as_ref()
    }
    /// <p> The class of the events you want to filter for, such as an infrastructure change, a deployment, or a schema change. </p>
    pub fn event_class(&self) -> std::option::Option<&crate::model::EventClass> {
        self.event_class.as_ref()
    }
    /// <p> The Amazon Web Services source that emitted the events you want to filter for. </p>
    pub fn event_source(&self) -> std::option::Option<&str> {
        self.event_source.as_deref()
    }
    /// <p> The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, of the events you want returned. </p>
    pub fn data_source(&self) -> std::option::Option<&crate::model::EventDataSource> {
        self.data_source.as_ref()
    }
    /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub fn resource_collection(&self) -> std::option::Option<&crate::model::ResourceCollection> {
        self.resource_collection.as_ref()
    }
}
impl std::fmt::Debug for ListEventsFilters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEventsFilters");
        formatter.field("insight_id", &self.insight_id);
        formatter.field("event_time_range", &self.event_time_range);
        formatter.field("event_class", &self.event_class);
        formatter.field("event_source", &self.event_source);
        formatter.field("data_source", &self.data_source);
        formatter.field("resource_collection", &self.resource_collection);
        formatter.finish()
    }
}
/// See [`ListEventsFilters`](crate::model::ListEventsFilters)
pub mod list_events_filters {
    /// A builder for [`ListEventsFilters`](crate::model::ListEventsFilters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) insight_id: std::option::Option<std::string::String>,
        pub(crate) event_time_range: std::option::Option<crate::model::EventTimeRange>,
        pub(crate) event_class: std::option::Option<crate::model::EventClass>,
        pub(crate) event_source: std::option::Option<std::string::String>,
        pub(crate) data_source: std::option::Option<crate::model::EventDataSource>,
        pub(crate) resource_collection: std::option::Option<crate::model::ResourceCollection>,
    }
    impl Builder {
        /// <p> An ID of an insight that is related to the events you want to filter for. </p>
        pub fn insight_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.insight_id = Some(input.into());
            self
        }
        /// <p> An ID of an insight that is related to the events you want to filter for. </p>
        pub fn set_insight_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.insight_id = input;
            self
        }
        /// <p> A time range during which you want the filtered events to have occurred. </p>
        pub fn event_time_range(mut self, input: crate::model::EventTimeRange) -> Self {
            self.event_time_range = Some(input);
            self
        }
        /// <p> A time range during which you want the filtered events to have occurred. </p>
        pub fn set_event_time_range(
            mut self,
            input: std::option::Option<crate::model::EventTimeRange>,
        ) -> Self {
            self.event_time_range = input;
            self
        }
        /// <p> The class of the events you want to filter for, such as an infrastructure change, a deployment, or a schema change. </p>
        pub fn event_class(mut self, input: crate::model::EventClass) -> Self {
            self.event_class = Some(input);
            self
        }
        /// <p> The class of the events you want to filter for, such as an infrastructure change, a deployment, or a schema change. </p>
        pub fn set_event_class(
            mut self,
            input: std::option::Option<crate::model::EventClass>,
        ) -> Self {
            self.event_class = input;
            self
        }
        /// <p> The Amazon Web Services source that emitted the events you want to filter for. </p>
        pub fn event_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_source = Some(input.into());
            self
        }
        /// <p> The Amazon Web Services source that emitted the events you want to filter for. </p>
        pub fn set_event_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_source = input;
            self
        }
        /// <p> The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, of the events you want returned. </p>
        pub fn data_source(mut self, input: crate::model::EventDataSource) -> Self {
            self.data_source = Some(input);
            self
        }
        /// <p> The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, of the events you want returned. </p>
        pub fn set_data_source(
            mut self,
            input: std::option::Option<crate::model::EventDataSource>,
        ) -> Self {
            self.data_source = input;
            self
        }
        /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn resource_collection(mut self, input: crate::model::ResourceCollection) -> Self {
            self.resource_collection = Some(input);
            self
        }
        /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn set_resource_collection(
            mut self,
            input: std::option::Option<crate::model::ResourceCollection>,
        ) -> Self {
            self.resource_collection = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEventsFilters`](crate::model::ListEventsFilters)
        pub fn build(self) -> crate::model::ListEventsFilters {
            crate::model::ListEventsFilters {
                insight_id: self.insight_id,
                event_time_range: self.event_time_range,
                event_class: self.event_class,
                event_source: self.event_source,
                data_source: self.data_source,
                resource_collection: self.resource_collection,
            }
        }
    }
}
impl ListEventsFilters {
    /// Creates a new builder-style object to manufacture [`ListEventsFilters`](crate::model::ListEventsFilters)
    pub fn builder() -> crate::model::list_events_filters::Builder {
        crate::model::list_events_filters::Builder::default()
    }
}

/// <p> The time range during which an Amazon Web Services event occurred. Amazon Web Services resource events and metrics are analyzed by DevOps Guru to find anomalous behavior and provide recommendations to improve your operational solutions. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventTimeRange {
    /// <p> The time when the event started. </p>
    pub from_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The time when the event ended. </p>
    pub to_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl EventTimeRange {
    /// <p> The time when the event started. </p>
    pub fn from_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.from_time.as_ref()
    }
    /// <p> The time when the event ended. </p>
    pub fn to_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.to_time.as_ref()
    }
}
impl std::fmt::Debug for EventTimeRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventTimeRange");
        formatter.field("from_time", &self.from_time);
        formatter.field("to_time", &self.to_time);
        formatter.finish()
    }
}
/// See [`EventTimeRange`](crate::model::EventTimeRange)
pub mod event_time_range {
    /// A builder for [`EventTimeRange`](crate::model::EventTimeRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) to_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p> The time when the event started. </p>
        pub fn from_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.from_time = Some(input);
            self
        }
        /// <p> The time when the event started. </p>
        pub fn set_from_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.from_time = input;
            self
        }
        /// <p> The time when the event ended. </p>
        pub fn to_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.to_time = Some(input);
            self
        }
        /// <p> The time when the event ended. </p>
        pub fn set_to_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.to_time = input;
            self
        }
        /// Consumes the builder and constructs a [`EventTimeRange`](crate::model::EventTimeRange)
        pub fn build(self) -> crate::model::EventTimeRange {
            crate::model::EventTimeRange {
                from_time: self.from_time,
                to_time: self.to_time,
            }
        }
    }
}
impl EventTimeRange {
    /// Creates a new builder-style object to manufacture [`EventTimeRange`](crate::model::EventTimeRange)
    pub fn builder() -> crate::model::event_time_range::Builder {
        crate::model::event_time_range::Builder::default()
    }
}

/// <p>Details about a reactive anomaly. This object is returned by <code>DescribeAnomaly.</code> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReactiveAnomalySummary {
    /// <p> The ID of the reactive anomaly. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The severity of the anomaly. The severity of anomalies that generate an insight determine that insight's severity. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
    pub severity: std::option::Option<crate::model::AnomalySeverity>,
    /// <p> The status of the reactive anomaly. </p>
    pub status: std::option::Option<crate::model::AnomalyStatus>,
    /// <p> A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from <code>AnomalyReportedTimeRange</code>, which specifies the time range when DevOps Guru opens and then closes an anomaly. </p>
    pub anomaly_time_range: std::option::Option<crate::model::AnomalyTimeRange>,
    /// <p> An <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed. </p>
    pub anomaly_reported_time_range: std::option::Option<crate::model::AnomalyReportedTimeRange>,
    /// <p> Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics. </p>
    pub source_details: std::option::Option<crate::model::AnomalySourceDetails>,
    /// <p> The ID of the insight that contains this anomaly. An insight is composed of related anomalies. </p>
    pub associated_insight_id: std::option::Option<std::string::String>,
    /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub resource_collection: std::option::Option<crate::model::ResourceCollection>,
    /// <p>The type of the reactive anomaly. It can be one of the following types.</p>
    /// <ul>
    /// <li> <p> <code>CAUSAL</code> - the anomaly can cause a new insight.</p> </li>
    /// <li> <p> <code>CONTEXTUAL</code> - the anomaly contains additional information about an insight or its causal anomaly.</p> </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::AnomalyType>,
    /// <p>The name of the reactive anomaly.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the reactive anomaly.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ID of the causal anomaly that is associated with this reactive anomaly. The ID of a `CAUSAL` anomaly is always `NULL`.</p>
    pub causal_anomaly_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services resources in which anomalous behavior was detected by DevOps Guru.</p>
    pub anomaly_resources: std::option::Option<std::vec::Vec<crate::model::AnomalyResource>>,
}
impl ReactiveAnomalySummary {
    /// <p> The ID of the reactive anomaly. </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The severity of the anomaly. The severity of anomalies that generate an insight determine that insight's severity. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
    pub fn severity(&self) -> std::option::Option<&crate::model::AnomalySeverity> {
        self.severity.as_ref()
    }
    /// <p> The status of the reactive anomaly. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::AnomalyStatus> {
        self.status.as_ref()
    }
    /// <p> A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from <code>AnomalyReportedTimeRange</code>, which specifies the time range when DevOps Guru opens and then closes an anomaly. </p>
    pub fn anomaly_time_range(&self) -> std::option::Option<&crate::model::AnomalyTimeRange> {
        self.anomaly_time_range.as_ref()
    }
    /// <p> An <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed. </p>
    pub fn anomaly_reported_time_range(
        &self,
    ) -> std::option::Option<&crate::model::AnomalyReportedTimeRange> {
        self.anomaly_reported_time_range.as_ref()
    }
    /// <p> Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics. </p>
    pub fn source_details(&self) -> std::option::Option<&crate::model::AnomalySourceDetails> {
        self.source_details.as_ref()
    }
    /// <p> The ID of the insight that contains this anomaly. An insight is composed of related anomalies. </p>
    pub fn associated_insight_id(&self) -> std::option::Option<&str> {
        self.associated_insight_id.as_deref()
    }
    /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub fn resource_collection(&self) -> std::option::Option<&crate::model::ResourceCollection> {
        self.resource_collection.as_ref()
    }
    /// <p>The type of the reactive anomaly. It can be one of the following types.</p>
    /// <ul>
    /// <li> <p> <code>CAUSAL</code> - the anomaly can cause a new insight.</p> </li>
    /// <li> <p> <code>CONTEXTUAL</code> - the anomaly contains additional information about an insight or its causal anomaly.</p> </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::AnomalyType> {
        self.r#type.as_ref()
    }
    /// <p>The name of the reactive anomaly.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the reactive anomaly.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ID of the causal anomaly that is associated with this reactive anomaly. The ID of a `CAUSAL` anomaly is always `NULL`.</p>
    pub fn causal_anomaly_id(&self) -> std::option::Option<&str> {
        self.causal_anomaly_id.as_deref()
    }
    /// <p>The Amazon Web Services resources in which anomalous behavior was detected by DevOps Guru.</p>
    pub fn anomaly_resources(&self) -> std::option::Option<&[crate::model::AnomalyResource]> {
        self.anomaly_resources.as_deref()
    }
}
impl std::fmt::Debug for ReactiveAnomalySummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReactiveAnomalySummary");
        formatter.field("id", &self.id);
        formatter.field("severity", &self.severity);
        formatter.field("status", &self.status);
        formatter.field("anomaly_time_range", &self.anomaly_time_range);
        formatter.field(
            "anomaly_reported_time_range",
            &self.anomaly_reported_time_range,
        );
        formatter.field("source_details", &self.source_details);
        formatter.field("associated_insight_id", &self.associated_insight_id);
        formatter.field("resource_collection", &self.resource_collection);
        formatter.field("r#type", &self.r#type);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("causal_anomaly_id", &self.causal_anomaly_id);
        formatter.field("anomaly_resources", &self.anomaly_resources);
        formatter.finish()
    }
}
/// See [`ReactiveAnomalySummary`](crate::model::ReactiveAnomalySummary)
pub mod reactive_anomaly_summary {
    /// A builder for [`ReactiveAnomalySummary`](crate::model::ReactiveAnomalySummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<crate::model::AnomalySeverity>,
        pub(crate) status: std::option::Option<crate::model::AnomalyStatus>,
        pub(crate) anomaly_time_range: std::option::Option<crate::model::AnomalyTimeRange>,
        pub(crate) anomaly_reported_time_range:
            std::option::Option<crate::model::AnomalyReportedTimeRange>,
        pub(crate) source_details: std::option::Option<crate::model::AnomalySourceDetails>,
        pub(crate) associated_insight_id: std::option::Option<std::string::String>,
        pub(crate) resource_collection: std::option::Option<crate::model::ResourceCollection>,
        pub(crate) r#type: std::option::Option<crate::model::AnomalyType>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) causal_anomaly_id: std::option::Option<std::string::String>,
        pub(crate) anomaly_resources:
            std::option::Option<std::vec::Vec<crate::model::AnomalyResource>>,
    }
    impl Builder {
        /// <p> The ID of the reactive anomaly. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The ID of the reactive anomaly. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The severity of the anomaly. The severity of anomalies that generate an insight determine that insight's severity. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
        pub fn severity(mut self, input: crate::model::AnomalySeverity) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>The severity of the anomaly. The severity of anomalies that generate an insight determine that insight's severity. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
        pub fn set_severity(
            mut self,
            input: std::option::Option<crate::model::AnomalySeverity>,
        ) -> Self {
            self.severity = input;
            self
        }
        /// <p> The status of the reactive anomaly. </p>
        pub fn status(mut self, input: crate::model::AnomalyStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The status of the reactive anomaly. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AnomalyStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from <code>AnomalyReportedTimeRange</code>, which specifies the time range when DevOps Guru opens and then closes an anomaly. </p>
        pub fn anomaly_time_range(mut self, input: crate::model::AnomalyTimeRange) -> Self {
            self.anomaly_time_range = Some(input);
            self
        }
        /// <p> A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from <code>AnomalyReportedTimeRange</code>, which specifies the time range when DevOps Guru opens and then closes an anomaly. </p>
        pub fn set_anomaly_time_range(
            mut self,
            input: std::option::Option<crate::model::AnomalyTimeRange>,
        ) -> Self {
            self.anomaly_time_range = input;
            self
        }
        /// <p> An <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed. </p>
        pub fn anomaly_reported_time_range(
            mut self,
            input: crate::model::AnomalyReportedTimeRange,
        ) -> Self {
            self.anomaly_reported_time_range = Some(input);
            self
        }
        /// <p> An <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed. </p>
        pub fn set_anomaly_reported_time_range(
            mut self,
            input: std::option::Option<crate::model::AnomalyReportedTimeRange>,
        ) -> Self {
            self.anomaly_reported_time_range = input;
            self
        }
        /// <p> Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics. </p>
        pub fn source_details(mut self, input: crate::model::AnomalySourceDetails) -> Self {
            self.source_details = Some(input);
            self
        }
        /// <p> Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics. </p>
        pub fn set_source_details(
            mut self,
            input: std::option::Option<crate::model::AnomalySourceDetails>,
        ) -> Self {
            self.source_details = input;
            self
        }
        /// <p> The ID of the insight that contains this anomaly. An insight is composed of related anomalies. </p>
        pub fn associated_insight_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.associated_insight_id = Some(input.into());
            self
        }
        /// <p> The ID of the insight that contains this anomaly. An insight is composed of related anomalies. </p>
        pub fn set_associated_insight_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.associated_insight_id = input;
            self
        }
        /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn resource_collection(mut self, input: crate::model::ResourceCollection) -> Self {
            self.resource_collection = Some(input);
            self
        }
        /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn set_resource_collection(
            mut self,
            input: std::option::Option<crate::model::ResourceCollection>,
        ) -> Self {
            self.resource_collection = input;
            self
        }
        /// <p>The type of the reactive anomaly. It can be one of the following types.</p>
        /// <ul>
        /// <li> <p> <code>CAUSAL</code> - the anomaly can cause a new insight.</p> </li>
        /// <li> <p> <code>CONTEXTUAL</code> - the anomaly contains additional information about an insight or its causal anomaly.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::AnomalyType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the reactive anomaly. It can be one of the following types.</p>
        /// <ul>
        /// <li> <p> <code>CAUSAL</code> - the anomaly can cause a new insight.</p> </li>
        /// <li> <p> <code>CONTEXTUAL</code> - the anomaly contains additional information about an insight or its causal anomaly.</p> </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::AnomalyType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The name of the reactive anomaly.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the reactive anomaly.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the reactive anomaly.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the reactive anomaly.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ID of the causal anomaly that is associated with this reactive anomaly. The ID of a `CAUSAL` anomaly is always `NULL`.</p>
        pub fn causal_anomaly_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.causal_anomaly_id = Some(input.into());
            self
        }
        /// <p>The ID of the causal anomaly that is associated with this reactive anomaly. The ID of a `CAUSAL` anomaly is always `NULL`.</p>
        pub fn set_causal_anomaly_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.causal_anomaly_id = input;
            self
        }
        /// Appends an item to `anomaly_resources`.
        ///
        /// To override the contents of this collection use [`set_anomaly_resources`](Self::set_anomaly_resources).
        ///
        /// <p>The Amazon Web Services resources in which anomalous behavior was detected by DevOps Guru.</p>
        pub fn anomaly_resources(mut self, input: crate::model::AnomalyResource) -> Self {
            let mut v = self.anomaly_resources.unwrap_or_default();
            v.push(input);
            self.anomaly_resources = Some(v);
            self
        }
        /// <p>The Amazon Web Services resources in which anomalous behavior was detected by DevOps Guru.</p>
        pub fn set_anomaly_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AnomalyResource>>,
        ) -> Self {
            self.anomaly_resources = input;
            self
        }
        /// Consumes the builder and constructs a [`ReactiveAnomalySummary`](crate::model::ReactiveAnomalySummary)
        pub fn build(self) -> crate::model::ReactiveAnomalySummary {
            crate::model::ReactiveAnomalySummary {
                id: self.id,
                severity: self.severity,
                status: self.status,
                anomaly_time_range: self.anomaly_time_range,
                anomaly_reported_time_range: self.anomaly_reported_time_range,
                source_details: self.source_details,
                associated_insight_id: self.associated_insight_id,
                resource_collection: self.resource_collection,
                r#type: self.r#type,
                name: self.name,
                description: self.description,
                causal_anomaly_id: self.causal_anomaly_id,
                anomaly_resources: self.anomaly_resources,
            }
        }
    }
}
impl ReactiveAnomalySummary {
    /// Creates a new builder-style object to manufacture [`ReactiveAnomalySummary`](crate::model::ReactiveAnomalySummary)
    pub fn builder() -> crate::model::reactive_anomaly_summary::Builder {
        crate::model::reactive_anomaly_summary::Builder::default()
    }
}

/// <p>The Amazon Web Services resources in which DevOps Guru detected unusual behavior that resulted in the generation of an anomaly. When DevOps Guru detects multiple related anomalies, it creates and insight with details about the anomalous behavior and suggestions about how to correct the problem.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnomalyResource {
    /// <p>The name of the Amazon Web Services resource.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of the Amazon Web Services resource.</p>
    pub r#type: std::option::Option<std::string::String>,
}
impl AnomalyResource {
    /// <p>The name of the Amazon Web Services resource.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of the Amazon Web Services resource.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for AnomalyResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnomalyResource");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`AnomalyResource`](crate::model::AnomalyResource)
pub mod anomaly_resource {
    /// A builder for [`AnomalyResource`](crate::model::AnomalyResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon Web Services resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Web Services resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of the Amazon Web Services resource.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of the Amazon Web Services resource.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`AnomalyResource`](crate::model::AnomalyResource)
        pub fn build(self) -> crate::model::AnomalyResource {
            crate::model::AnomalyResource {
                name: self.name,
                r#type: self.r#type,
            }
        }
    }
}
impl AnomalyResource {
    /// Creates a new builder-style object to manufacture [`AnomalyResource`](crate::model::AnomalyResource)
    pub fn builder() -> crate::model::anomaly_resource::Builder {
        crate::model::anomaly_resource::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AnomalyType {
    #[allow(missing_docs)] // documentation missing in model
    Causal,
    #[allow(missing_docs)] // documentation missing in model
    Contextual,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AnomalyType {
    fn from(s: &str) -> Self {
        match s {
            "CAUSAL" => AnomalyType::Causal,
            "CONTEXTUAL" => AnomalyType::Contextual,
            other => AnomalyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AnomalyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AnomalyType::from(s))
    }
}
impl AnomalyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AnomalyType::Causal => "CAUSAL",
            AnomalyType::Contextual => "CONTEXTUAL",
            AnomalyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CAUSAL", "CONTEXTUAL"]
    }
}
impl AsRef<str> for AnomalyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Details about the source of the anomalous operational data that triggered the anomaly.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnomalySourceDetails {
    /// <p>An array of <code>CloudWatchMetricsDetail</code> objects that contain information about analyzed CloudWatch metrics that show anomalous behavior. </p>
    pub cloud_watch_metrics:
        std::option::Option<std::vec::Vec<crate::model::CloudWatchMetricsDetail>>,
    /// <p>An array of <code>PerformanceInsightsMetricsDetail</code> objects that contain information about analyzed Performance Insights metrics that show anomalous behavior.</p>
    pub performance_insights_metrics:
        std::option::Option<std::vec::Vec<crate::model::PerformanceInsightsMetricsDetail>>,
}
impl AnomalySourceDetails {
    /// <p>An array of <code>CloudWatchMetricsDetail</code> objects that contain information about analyzed CloudWatch metrics that show anomalous behavior. </p>
    pub fn cloud_watch_metrics(
        &self,
    ) -> std::option::Option<&[crate::model::CloudWatchMetricsDetail]> {
        self.cloud_watch_metrics.as_deref()
    }
    /// <p>An array of <code>PerformanceInsightsMetricsDetail</code> objects that contain information about analyzed Performance Insights metrics that show anomalous behavior.</p>
    pub fn performance_insights_metrics(
        &self,
    ) -> std::option::Option<&[crate::model::PerformanceInsightsMetricsDetail]> {
        self.performance_insights_metrics.as_deref()
    }
}
impl std::fmt::Debug for AnomalySourceDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnomalySourceDetails");
        formatter.field("cloud_watch_metrics", &self.cloud_watch_metrics);
        formatter.field(
            "performance_insights_metrics",
            &self.performance_insights_metrics,
        );
        formatter.finish()
    }
}
/// See [`AnomalySourceDetails`](crate::model::AnomalySourceDetails)
pub mod anomaly_source_details {
    /// A builder for [`AnomalySourceDetails`](crate::model::AnomalySourceDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_watch_metrics:
            std::option::Option<std::vec::Vec<crate::model::CloudWatchMetricsDetail>>,
        pub(crate) performance_insights_metrics:
            std::option::Option<std::vec::Vec<crate::model::PerformanceInsightsMetricsDetail>>,
    }
    impl Builder {
        /// Appends an item to `cloud_watch_metrics`.
        ///
        /// To override the contents of this collection use [`set_cloud_watch_metrics`](Self::set_cloud_watch_metrics).
        ///
        /// <p>An array of <code>CloudWatchMetricsDetail</code> objects that contain information about analyzed CloudWatch metrics that show anomalous behavior. </p>
        pub fn cloud_watch_metrics(mut self, input: crate::model::CloudWatchMetricsDetail) -> Self {
            let mut v = self.cloud_watch_metrics.unwrap_or_default();
            v.push(input);
            self.cloud_watch_metrics = Some(v);
            self
        }
        /// <p>An array of <code>CloudWatchMetricsDetail</code> objects that contain information about analyzed CloudWatch metrics that show anomalous behavior. </p>
        pub fn set_cloud_watch_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CloudWatchMetricsDetail>>,
        ) -> Self {
            self.cloud_watch_metrics = input;
            self
        }
        /// Appends an item to `performance_insights_metrics`.
        ///
        /// To override the contents of this collection use [`set_performance_insights_metrics`](Self::set_performance_insights_metrics).
        ///
        /// <p>An array of <code>PerformanceInsightsMetricsDetail</code> objects that contain information about analyzed Performance Insights metrics that show anomalous behavior.</p>
        pub fn performance_insights_metrics(
            mut self,
            input: crate::model::PerformanceInsightsMetricsDetail,
        ) -> Self {
            let mut v = self.performance_insights_metrics.unwrap_or_default();
            v.push(input);
            self.performance_insights_metrics = Some(v);
            self
        }
        /// <p>An array of <code>PerformanceInsightsMetricsDetail</code> objects that contain information about analyzed Performance Insights metrics that show anomalous behavior.</p>
        pub fn set_performance_insights_metrics(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::PerformanceInsightsMetricsDetail>,
            >,
        ) -> Self {
            self.performance_insights_metrics = input;
            self
        }
        /// Consumes the builder and constructs a [`AnomalySourceDetails`](crate::model::AnomalySourceDetails)
        pub fn build(self) -> crate::model::AnomalySourceDetails {
            crate::model::AnomalySourceDetails {
                cloud_watch_metrics: self.cloud_watch_metrics,
                performance_insights_metrics: self.performance_insights_metrics,
            }
        }
    }
}
impl AnomalySourceDetails {
    /// Creates a new builder-style object to manufacture [`AnomalySourceDetails`](crate::model::AnomalySourceDetails)
    pub fn builder() -> crate::model::anomaly_source_details::Builder {
        crate::model::anomaly_source_details::Builder::default()
    }
}

/// <p>Details about Performance Insights metrics.</p>
/// <p>Amazon RDS Performance Insights enables you to monitor and explore different dimensions of database load based on data captured from a running DB instance. DB load is measured as average active sessions. Performance Insights provides the data to API consumers as a two-dimensional time-series dataset. The time dimension provides DB load data for each time point in the queried time range. Each time point decomposes overall load in relation to the requested dimensions, measured at that time point. Examples include SQL, Wait event, User, and Host. </p>
/// <ul>
/// <li> <p>To learn more about Performance Insights and Amazon Aurora DB instances, go to the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights.html"> Amazon Aurora User Guide</a>. </p> </li>
/// <li> <p>To learn more about Performance Insights and Amazon RDS DB instances, go to the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html"> Amazon RDS User Guide</a>. </p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PerformanceInsightsMetricsDetail {
    /// <p>The name used for a specific Performance Insights metric.</p>
    pub metric_display_name: std::option::Option<std::string::String>,
    /// <p>The unit of measure for a metric. For example, a session or a process.</p>
    pub unit: std::option::Option<std::string::String>,
    /// <p>A single query to be processed for the metric. For more information, see <code> <a href="https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsMetricQuery.html">PerformanceInsightsMetricQuery</a> </code>.</p>
    pub metric_query: std::option::Option<crate::model::PerformanceInsightsMetricQuery>,
    /// <p> For more information, see <code> <a href="https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsReferenceData.html">PerformanceInsightsReferenceData</a> </code>. </p>
    pub reference_data:
        std::option::Option<std::vec::Vec<crate::model::PerformanceInsightsReferenceData>>,
    /// <p>The metric statistics during the anomalous period detected by DevOps Guru;</p>
    pub stats_at_anomaly: std::option::Option<std::vec::Vec<crate::model::PerformanceInsightsStat>>,
    /// <p>Typical metric statistics that are not considered anomalous. When DevOps Guru analyzes metrics, it compares them to <code>StatsAtBaseline</code> to help determine if they are anomalous.</p>
    pub stats_at_baseline:
        std::option::Option<std::vec::Vec<crate::model::PerformanceInsightsStat>>,
}
impl PerformanceInsightsMetricsDetail {
    /// <p>The name used for a specific Performance Insights metric.</p>
    pub fn metric_display_name(&self) -> std::option::Option<&str> {
        self.metric_display_name.as_deref()
    }
    /// <p>The unit of measure for a metric. For example, a session or a process.</p>
    pub fn unit(&self) -> std::option::Option<&str> {
        self.unit.as_deref()
    }
    /// <p>A single query to be processed for the metric. For more information, see <code> <a href="https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsMetricQuery.html">PerformanceInsightsMetricQuery</a> </code>.</p>
    pub fn metric_query(
        &self,
    ) -> std::option::Option<&crate::model::PerformanceInsightsMetricQuery> {
        self.metric_query.as_ref()
    }
    /// <p> For more information, see <code> <a href="https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsReferenceData.html">PerformanceInsightsReferenceData</a> </code>. </p>
    pub fn reference_data(
        &self,
    ) -> std::option::Option<&[crate::model::PerformanceInsightsReferenceData]> {
        self.reference_data.as_deref()
    }
    /// <p>The metric statistics during the anomalous period detected by DevOps Guru;</p>
    pub fn stats_at_anomaly(
        &self,
    ) -> std::option::Option<&[crate::model::PerformanceInsightsStat]> {
        self.stats_at_anomaly.as_deref()
    }
    /// <p>Typical metric statistics that are not considered anomalous. When DevOps Guru analyzes metrics, it compares them to <code>StatsAtBaseline</code> to help determine if they are anomalous.</p>
    pub fn stats_at_baseline(
        &self,
    ) -> std::option::Option<&[crate::model::PerformanceInsightsStat]> {
        self.stats_at_baseline.as_deref()
    }
}
impl std::fmt::Debug for PerformanceInsightsMetricsDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PerformanceInsightsMetricsDetail");
        formatter.field("metric_display_name", &self.metric_display_name);
        formatter.field("unit", &self.unit);
        formatter.field("metric_query", &self.metric_query);
        formatter.field("reference_data", &self.reference_data);
        formatter.field("stats_at_anomaly", &self.stats_at_anomaly);
        formatter.field("stats_at_baseline", &self.stats_at_baseline);
        formatter.finish()
    }
}
/// See [`PerformanceInsightsMetricsDetail`](crate::model::PerformanceInsightsMetricsDetail)
pub mod performance_insights_metrics_detail {
    /// A builder for [`PerformanceInsightsMetricsDetail`](crate::model::PerformanceInsightsMetricsDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_display_name: std::option::Option<std::string::String>,
        pub(crate) unit: std::option::Option<std::string::String>,
        pub(crate) metric_query: std::option::Option<crate::model::PerformanceInsightsMetricQuery>,
        pub(crate) reference_data:
            std::option::Option<std::vec::Vec<crate::model::PerformanceInsightsReferenceData>>,
        pub(crate) stats_at_anomaly:
            std::option::Option<std::vec::Vec<crate::model::PerformanceInsightsStat>>,
        pub(crate) stats_at_baseline:
            std::option::Option<std::vec::Vec<crate::model::PerformanceInsightsStat>>,
    }
    impl Builder {
        /// <p>The name used for a specific Performance Insights metric.</p>
        pub fn metric_display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_display_name = Some(input.into());
            self
        }
        /// <p>The name used for a specific Performance Insights metric.</p>
        pub fn set_metric_display_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.metric_display_name = input;
            self
        }
        /// <p>The unit of measure for a metric. For example, a session or a process.</p>
        pub fn unit(mut self, input: impl Into<std::string::String>) -> Self {
            self.unit = Some(input.into());
            self
        }
        /// <p>The unit of measure for a metric. For example, a session or a process.</p>
        pub fn set_unit(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.unit = input;
            self
        }
        /// <p>A single query to be processed for the metric. For more information, see <code> <a href="https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsMetricQuery.html">PerformanceInsightsMetricQuery</a> </code>.</p>
        pub fn metric_query(mut self, input: crate::model::PerformanceInsightsMetricQuery) -> Self {
            self.metric_query = Some(input);
            self
        }
        /// <p>A single query to be processed for the metric. For more information, see <code> <a href="https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsMetricQuery.html">PerformanceInsightsMetricQuery</a> </code>.</p>
        pub fn set_metric_query(
            mut self,
            input: std::option::Option<crate::model::PerformanceInsightsMetricQuery>,
        ) -> Self {
            self.metric_query = input;
            self
        }
        /// Appends an item to `reference_data`.
        ///
        /// To override the contents of this collection use [`set_reference_data`](Self::set_reference_data).
        ///
        /// <p> For more information, see <code> <a href="https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsReferenceData.html">PerformanceInsightsReferenceData</a> </code>. </p>
        pub fn reference_data(
            mut self,
            input: crate::model::PerformanceInsightsReferenceData,
        ) -> Self {
            let mut v = self.reference_data.unwrap_or_default();
            v.push(input);
            self.reference_data = Some(v);
            self
        }
        /// <p> For more information, see <code> <a href="https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsReferenceData.html">PerformanceInsightsReferenceData</a> </code>. </p>
        pub fn set_reference_data(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::PerformanceInsightsReferenceData>,
            >,
        ) -> Self {
            self.reference_data = input;
            self
        }
        /// Appends an item to `stats_at_anomaly`.
        ///
        /// To override the contents of this collection use [`set_stats_at_anomaly`](Self::set_stats_at_anomaly).
        ///
        /// <p>The metric statistics during the anomalous period detected by DevOps Guru;</p>
        pub fn stats_at_anomaly(mut self, input: crate::model::PerformanceInsightsStat) -> Self {
            let mut v = self.stats_at_anomaly.unwrap_or_default();
            v.push(input);
            self.stats_at_anomaly = Some(v);
            self
        }
        /// <p>The metric statistics during the anomalous period detected by DevOps Guru;</p>
        pub fn set_stats_at_anomaly(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PerformanceInsightsStat>>,
        ) -> Self {
            self.stats_at_anomaly = input;
            self
        }
        /// Appends an item to `stats_at_baseline`.
        ///
        /// To override the contents of this collection use [`set_stats_at_baseline`](Self::set_stats_at_baseline).
        ///
        /// <p>Typical metric statistics that are not considered anomalous. When DevOps Guru analyzes metrics, it compares them to <code>StatsAtBaseline</code> to help determine if they are anomalous.</p>
        pub fn stats_at_baseline(mut self, input: crate::model::PerformanceInsightsStat) -> Self {
            let mut v = self.stats_at_baseline.unwrap_or_default();
            v.push(input);
            self.stats_at_baseline = Some(v);
            self
        }
        /// <p>Typical metric statistics that are not considered anomalous. When DevOps Guru analyzes metrics, it compares them to <code>StatsAtBaseline</code> to help determine if they are anomalous.</p>
        pub fn set_stats_at_baseline(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PerformanceInsightsStat>>,
        ) -> Self {
            self.stats_at_baseline = input;
            self
        }
        /// Consumes the builder and constructs a [`PerformanceInsightsMetricsDetail`](crate::model::PerformanceInsightsMetricsDetail)
        pub fn build(self) -> crate::model::PerformanceInsightsMetricsDetail {
            crate::model::PerformanceInsightsMetricsDetail {
                metric_display_name: self.metric_display_name,
                unit: self.unit,
                metric_query: self.metric_query,
                reference_data: self.reference_data,
                stats_at_anomaly: self.stats_at_anomaly,
                stats_at_baseline: self.stats_at_baseline,
            }
        }
    }
}
impl PerformanceInsightsMetricsDetail {
    /// Creates a new builder-style object to manufacture [`PerformanceInsightsMetricsDetail`](crate::model::PerformanceInsightsMetricsDetail)
    pub fn builder() -> crate::model::performance_insights_metrics_detail::Builder {
        crate::model::performance_insights_metrics_detail::Builder::default()
    }
}

/// <p>A statistic in a Performance Insights collection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PerformanceInsightsStat {
    /// <p>The statistic type.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The value of the statistic.</p>
    pub value: std::option::Option<f64>,
}
impl PerformanceInsightsStat {
    /// <p>The statistic type.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The value of the statistic.</p>
    pub fn value(&self) -> std::option::Option<f64> {
        self.value
    }
}
impl std::fmt::Debug for PerformanceInsightsStat {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PerformanceInsightsStat");
        formatter.field("r#type", &self.r#type);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`PerformanceInsightsStat`](crate::model::PerformanceInsightsStat)
pub mod performance_insights_stat {
    /// A builder for [`PerformanceInsightsStat`](crate::model::PerformanceInsightsStat)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The statistic type.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The statistic type.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The value of the statistic.</p>
        pub fn value(mut self, input: f64) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value of the statistic.</p>
        pub fn set_value(mut self, input: std::option::Option<f64>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`PerformanceInsightsStat`](crate::model::PerformanceInsightsStat)
        pub fn build(self) -> crate::model::PerformanceInsightsStat {
            crate::model::PerformanceInsightsStat {
                r#type: self.r#type,
                value: self.value,
            }
        }
    }
}
impl PerformanceInsightsStat {
    /// Creates a new builder-style object to manufacture [`PerformanceInsightsStat`](crate::model::PerformanceInsightsStat)
    pub fn builder() -> crate::model::performance_insights_stat::Builder {
        crate::model::performance_insights_stat::Builder::default()
    }
}

/// <p>Reference data used to evaluate Performance Insights to determine if its performance is anomalous or not.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PerformanceInsightsReferenceData {
    /// <p>The name of the reference data.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The specific reference values used to evaluate the Performance Insights. For more information, see <code> <a href="https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsReferenceComparisonValues.html">PerformanceInsightsReferenceComparisonValues</a> </code>. </p>
    pub comparison_values:
        std::option::Option<crate::model::PerformanceInsightsReferenceComparisonValues>,
}
impl PerformanceInsightsReferenceData {
    /// <p>The name of the reference data.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The specific reference values used to evaluate the Performance Insights. For more information, see <code> <a href="https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsReferenceComparisonValues.html">PerformanceInsightsReferenceComparisonValues</a> </code>. </p>
    pub fn comparison_values(
        &self,
    ) -> std::option::Option<&crate::model::PerformanceInsightsReferenceComparisonValues> {
        self.comparison_values.as_ref()
    }
}
impl std::fmt::Debug for PerformanceInsightsReferenceData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PerformanceInsightsReferenceData");
        formatter.field("name", &self.name);
        formatter.field("comparison_values", &self.comparison_values);
        formatter.finish()
    }
}
/// See [`PerformanceInsightsReferenceData`](crate::model::PerformanceInsightsReferenceData)
pub mod performance_insights_reference_data {
    /// A builder for [`PerformanceInsightsReferenceData`](crate::model::PerformanceInsightsReferenceData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) comparison_values:
            std::option::Option<crate::model::PerformanceInsightsReferenceComparisonValues>,
    }
    impl Builder {
        /// <p>The name of the reference data.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the reference data.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The specific reference values used to evaluate the Performance Insights. For more information, see <code> <a href="https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsReferenceComparisonValues.html">PerformanceInsightsReferenceComparisonValues</a> </code>. </p>
        pub fn comparison_values(
            mut self,
            input: crate::model::PerformanceInsightsReferenceComparisonValues,
        ) -> Self {
            self.comparison_values = Some(input);
            self
        }
        /// <p>The specific reference values used to evaluate the Performance Insights. For more information, see <code> <a href="https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsReferenceComparisonValues.html">PerformanceInsightsReferenceComparisonValues</a> </code>. </p>
        pub fn set_comparison_values(
            mut self,
            input: std::option::Option<crate::model::PerformanceInsightsReferenceComparisonValues>,
        ) -> Self {
            self.comparison_values = input;
            self
        }
        /// Consumes the builder and constructs a [`PerformanceInsightsReferenceData`](crate::model::PerformanceInsightsReferenceData)
        pub fn build(self) -> crate::model::PerformanceInsightsReferenceData {
            crate::model::PerformanceInsightsReferenceData {
                name: self.name,
                comparison_values: self.comparison_values,
            }
        }
    }
}
impl PerformanceInsightsReferenceData {
    /// Creates a new builder-style object to manufacture [`PerformanceInsightsReferenceData`](crate::model::PerformanceInsightsReferenceData)
    pub fn builder() -> crate::model::performance_insights_reference_data::Builder {
        crate::model::performance_insights_reference_data::Builder::default()
    }
}

/// <p>Reference scalar values and other metrics that DevOps Guru displays on a graph in its console along with the actual metrics it analyzed. Compare these reference values to your actual metrics to help you understand anomalous behavior that DevOps Guru detected.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PerformanceInsightsReferenceComparisonValues {
    /// <p>A scalar value DevOps Guru for a metric that DevOps Guru compares to actual metric values. This reference value is used to determine if an actual metric value should be considered anomalous.</p>
    pub reference_scalar: std::option::Option<crate::model::PerformanceInsightsReferenceScalar>,
    /// <p>A metric that DevOps Guru compares to actual metric values. This reference metric is used to determine if an actual metric should be considered anomalous.</p>
    pub reference_metric: std::option::Option<crate::model::PerformanceInsightsReferenceMetric>,
}
impl PerformanceInsightsReferenceComparisonValues {
    /// <p>A scalar value DevOps Guru for a metric that DevOps Guru compares to actual metric values. This reference value is used to determine if an actual metric value should be considered anomalous.</p>
    pub fn reference_scalar(
        &self,
    ) -> std::option::Option<&crate::model::PerformanceInsightsReferenceScalar> {
        self.reference_scalar.as_ref()
    }
    /// <p>A metric that DevOps Guru compares to actual metric values. This reference metric is used to determine if an actual metric should be considered anomalous.</p>
    pub fn reference_metric(
        &self,
    ) -> std::option::Option<&crate::model::PerformanceInsightsReferenceMetric> {
        self.reference_metric.as_ref()
    }
}
impl std::fmt::Debug for PerformanceInsightsReferenceComparisonValues {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PerformanceInsightsReferenceComparisonValues");
        formatter.field("reference_scalar", &self.reference_scalar);
        formatter.field("reference_metric", &self.reference_metric);
        formatter.finish()
    }
}
/// See [`PerformanceInsightsReferenceComparisonValues`](crate::model::PerformanceInsightsReferenceComparisonValues)
pub mod performance_insights_reference_comparison_values {
    /// A builder for [`PerformanceInsightsReferenceComparisonValues`](crate::model::PerformanceInsightsReferenceComparisonValues)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reference_scalar:
            std::option::Option<crate::model::PerformanceInsightsReferenceScalar>,
        pub(crate) reference_metric:
            std::option::Option<crate::model::PerformanceInsightsReferenceMetric>,
    }
    impl Builder {
        /// <p>A scalar value DevOps Guru for a metric that DevOps Guru compares to actual metric values. This reference value is used to determine if an actual metric value should be considered anomalous.</p>
        pub fn reference_scalar(
            mut self,
            input: crate::model::PerformanceInsightsReferenceScalar,
        ) -> Self {
            self.reference_scalar = Some(input);
            self
        }
        /// <p>A scalar value DevOps Guru for a metric that DevOps Guru compares to actual metric values. This reference value is used to determine if an actual metric value should be considered anomalous.</p>
        pub fn set_reference_scalar(
            mut self,
            input: std::option::Option<crate::model::PerformanceInsightsReferenceScalar>,
        ) -> Self {
            self.reference_scalar = input;
            self
        }
        /// <p>A metric that DevOps Guru compares to actual metric values. This reference metric is used to determine if an actual metric should be considered anomalous.</p>
        pub fn reference_metric(
            mut self,
            input: crate::model::PerformanceInsightsReferenceMetric,
        ) -> Self {
            self.reference_metric = Some(input);
            self
        }
        /// <p>A metric that DevOps Guru compares to actual metric values. This reference metric is used to determine if an actual metric should be considered anomalous.</p>
        pub fn set_reference_metric(
            mut self,
            input: std::option::Option<crate::model::PerformanceInsightsReferenceMetric>,
        ) -> Self {
            self.reference_metric = input;
            self
        }
        /// Consumes the builder and constructs a [`PerformanceInsightsReferenceComparisonValues`](crate::model::PerformanceInsightsReferenceComparisonValues)
        pub fn build(self) -> crate::model::PerformanceInsightsReferenceComparisonValues {
            crate::model::PerformanceInsightsReferenceComparisonValues {
                reference_scalar: self.reference_scalar,
                reference_metric: self.reference_metric,
            }
        }
    }
}
impl PerformanceInsightsReferenceComparisonValues {
    /// Creates a new builder-style object to manufacture [`PerformanceInsightsReferenceComparisonValues`](crate::model::PerformanceInsightsReferenceComparisonValues)
    pub fn builder() -> crate::model::performance_insights_reference_comparison_values::Builder {
        crate::model::performance_insights_reference_comparison_values::Builder::default()
    }
}

/// <p>Information about a reference metric used to evaluate Performance Insights.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PerformanceInsightsReferenceMetric {
    /// <p>A query to be processed on the metric.</p>
    pub metric_query: std::option::Option<crate::model::PerformanceInsightsMetricQuery>,
}
impl PerformanceInsightsReferenceMetric {
    /// <p>A query to be processed on the metric.</p>
    pub fn metric_query(
        &self,
    ) -> std::option::Option<&crate::model::PerformanceInsightsMetricQuery> {
        self.metric_query.as_ref()
    }
}
impl std::fmt::Debug for PerformanceInsightsReferenceMetric {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PerformanceInsightsReferenceMetric");
        formatter.field("metric_query", &self.metric_query);
        formatter.finish()
    }
}
/// See [`PerformanceInsightsReferenceMetric`](crate::model::PerformanceInsightsReferenceMetric)
pub mod performance_insights_reference_metric {
    /// A builder for [`PerformanceInsightsReferenceMetric`](crate::model::PerformanceInsightsReferenceMetric)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_query: std::option::Option<crate::model::PerformanceInsightsMetricQuery>,
    }
    impl Builder {
        /// <p>A query to be processed on the metric.</p>
        pub fn metric_query(mut self, input: crate::model::PerformanceInsightsMetricQuery) -> Self {
            self.metric_query = Some(input);
            self
        }
        /// <p>A query to be processed on the metric.</p>
        pub fn set_metric_query(
            mut self,
            input: std::option::Option<crate::model::PerformanceInsightsMetricQuery>,
        ) -> Self {
            self.metric_query = input;
            self
        }
        /// Consumes the builder and constructs a [`PerformanceInsightsReferenceMetric`](crate::model::PerformanceInsightsReferenceMetric)
        pub fn build(self) -> crate::model::PerformanceInsightsReferenceMetric {
            crate::model::PerformanceInsightsReferenceMetric {
                metric_query: self.metric_query,
            }
        }
    }
}
impl PerformanceInsightsReferenceMetric {
    /// Creates a new builder-style object to manufacture [`PerformanceInsightsReferenceMetric`](crate::model::PerformanceInsightsReferenceMetric)
    pub fn builder() -> crate::model::performance_insights_reference_metric::Builder {
        crate::model::performance_insights_reference_metric::Builder::default()
    }
}

/// <p>A single query to be processed. Use these parameters to query the Performance Insights <code>GetResourceMetrics</code> API to retrieve the metrics for an anomaly. For more information, see <code> <a href="https://docs.aws.amazon.com/performance-insights/latest/APIReference/API_GetResourceMetrics.html">GetResourceMetrics</a> </code> in the <i>Amazon RDS Performance Insights API Reference</i>.</p>
/// <p>Amazon RDS Performance Insights enables you to monitor and explore different dimensions of database load based on data captured from a running DB instance. DB load is measured as average active sessions. Performance Insights provides the data to API consumers as a two-dimensional time-series dataset. The time dimension provides DB load data for each time point in the queried time range. Each time point decomposes overall load in relation to the requested dimensions, measured at that time point. Examples include SQL, Wait event, User, and Host. </p>
/// <ul>
/// <li> <p>To learn more about Performance Insights and Amazon Aurora DB instances, go to the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights.html"> Amazon Aurora User Guide</a>. </p> </li>
/// <li> <p>To learn more about Performance Insights and Amazon RDS DB instances, go to the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html"> Amazon RDS User Guide</a>. </p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PerformanceInsightsMetricQuery {
    /// <p>The name of the meteric used used when querying an Performance Insights <code>GetResourceMetrics</code> API for anomaly metrics.</p>
    /// <p>Valid values for <code>Metric</code> are:</p>
    /// <ul>
    /// <li> <p> <code>db.load.avg</code> - a scaled representation of the number of active sessions for the database engine.</p> </li>
    /// <li> <p> <code>db.sampledload.avg</code> - the raw number of active sessions for the database engine.</p> </li>
    /// </ul>
    /// <p>If the number of active sessions is less than an internal Performance Insights threshold, <code>db.load.avg</code> and <code>db.sampledload.avg</code> are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with <code>db.load.avg</code> showing the scaled values, <code>db.sampledload.avg</code> showing the raw values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>. For most use cases, you can query <code>db.load.avg</code> only. </p>
    pub metric: std::option::Option<std::string::String>,
    /// <p>The specification for how to aggregate the data points from a Performance Insights <code>GetResourceMetrics</code> API query. The Performance Insights query returns all of the dimensions within that group, unless you provide the names of specific dimensions within that group. You can also request that Performance Insights return a limited number of values for a dimension.</p>
    pub group_by: std::option::Option<crate::model::PerformanceInsightsMetricDimensionGroup>,
    /// <p>One or more filters to apply to a Performance Insights <code>GetResourceMetrics</code> API query. Restrictions:</p>
    /// <ul>
    /// <li> <p>Any number of filters by the same dimension, as specified in the <code>GroupBy</code> parameter.</p> </li>
    /// <li> <p>A single filter for any other dimension in this dimension group.</p> </li>
    /// </ul>
    pub filter:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl PerformanceInsightsMetricQuery {
    /// <p>The name of the meteric used used when querying an Performance Insights <code>GetResourceMetrics</code> API for anomaly metrics.</p>
    /// <p>Valid values for <code>Metric</code> are:</p>
    /// <ul>
    /// <li> <p> <code>db.load.avg</code> - a scaled representation of the number of active sessions for the database engine.</p> </li>
    /// <li> <p> <code>db.sampledload.avg</code> - the raw number of active sessions for the database engine.</p> </li>
    /// </ul>
    /// <p>If the number of active sessions is less than an internal Performance Insights threshold, <code>db.load.avg</code> and <code>db.sampledload.avg</code> are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with <code>db.load.avg</code> showing the scaled values, <code>db.sampledload.avg</code> showing the raw values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>. For most use cases, you can query <code>db.load.avg</code> only. </p>
    pub fn metric(&self) -> std::option::Option<&str> {
        self.metric.as_deref()
    }
    /// <p>The specification for how to aggregate the data points from a Performance Insights <code>GetResourceMetrics</code> API query. The Performance Insights query returns all of the dimensions within that group, unless you provide the names of specific dimensions within that group. You can also request that Performance Insights return a limited number of values for a dimension.</p>
    pub fn group_by(
        &self,
    ) -> std::option::Option<&crate::model::PerformanceInsightsMetricDimensionGroup> {
        self.group_by.as_ref()
    }
    /// <p>One or more filters to apply to a Performance Insights <code>GetResourceMetrics</code> API query. Restrictions:</p>
    /// <ul>
    /// <li> <p>Any number of filters by the same dimension, as specified in the <code>GroupBy</code> parameter.</p> </li>
    /// <li> <p>A single filter for any other dimension in this dimension group.</p> </li>
    /// </ul>
    pub fn filter(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.filter.as_ref()
    }
}
impl std::fmt::Debug for PerformanceInsightsMetricQuery {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PerformanceInsightsMetricQuery");
        formatter.field("metric", &self.metric);
        formatter.field("group_by", &self.group_by);
        formatter.field("filter", &self.filter);
        formatter.finish()
    }
}
/// See [`PerformanceInsightsMetricQuery`](crate::model::PerformanceInsightsMetricQuery)
pub mod performance_insights_metric_query {
    /// A builder for [`PerformanceInsightsMetricQuery`](crate::model::PerformanceInsightsMetricQuery)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric: std::option::Option<std::string::String>,
        pub(crate) group_by:
            std::option::Option<crate::model::PerformanceInsightsMetricDimensionGroup>,
        pub(crate) filter: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the meteric used used when querying an Performance Insights <code>GetResourceMetrics</code> API for anomaly metrics.</p>
        /// <p>Valid values for <code>Metric</code> are:</p>
        /// <ul>
        /// <li> <p> <code>db.load.avg</code> - a scaled representation of the number of active sessions for the database engine.</p> </li>
        /// <li> <p> <code>db.sampledload.avg</code> - the raw number of active sessions for the database engine.</p> </li>
        /// </ul>
        /// <p>If the number of active sessions is less than an internal Performance Insights threshold, <code>db.load.avg</code> and <code>db.sampledload.avg</code> are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with <code>db.load.avg</code> showing the scaled values, <code>db.sampledload.avg</code> showing the raw values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>. For most use cases, you can query <code>db.load.avg</code> only. </p>
        pub fn metric(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric = Some(input.into());
            self
        }
        /// <p>The name of the meteric used used when querying an Performance Insights <code>GetResourceMetrics</code> API for anomaly metrics.</p>
        /// <p>Valid values for <code>Metric</code> are:</p>
        /// <ul>
        /// <li> <p> <code>db.load.avg</code> - a scaled representation of the number of active sessions for the database engine.</p> </li>
        /// <li> <p> <code>db.sampledload.avg</code> - the raw number of active sessions for the database engine.</p> </li>
        /// </ul>
        /// <p>If the number of active sessions is less than an internal Performance Insights threshold, <code>db.load.avg</code> and <code>db.sampledload.avg</code> are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with <code>db.load.avg</code> showing the scaled values, <code>db.sampledload.avg</code> showing the raw values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>. For most use cases, you can query <code>db.load.avg</code> only. </p>
        pub fn set_metric(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric = input;
            self
        }
        /// <p>The specification for how to aggregate the data points from a Performance Insights <code>GetResourceMetrics</code> API query. The Performance Insights query returns all of the dimensions within that group, unless you provide the names of specific dimensions within that group. You can also request that Performance Insights return a limited number of values for a dimension.</p>
        pub fn group_by(
            mut self,
            input: crate::model::PerformanceInsightsMetricDimensionGroup,
        ) -> Self {
            self.group_by = Some(input);
            self
        }
        /// <p>The specification for how to aggregate the data points from a Performance Insights <code>GetResourceMetrics</code> API query. The Performance Insights query returns all of the dimensions within that group, unless you provide the names of specific dimensions within that group. You can also request that Performance Insights return a limited number of values for a dimension.</p>
        pub fn set_group_by(
            mut self,
            input: std::option::Option<crate::model::PerformanceInsightsMetricDimensionGroup>,
        ) -> Self {
            self.group_by = input;
            self
        }
        /// Adds a key-value pair to `filter`.
        ///
        /// To override the contents of this collection use [`set_filter`](Self::set_filter).
        ///
        /// <p>One or more filters to apply to a Performance Insights <code>GetResourceMetrics</code> API query. Restrictions:</p>
        /// <ul>
        /// <li> <p>Any number of filters by the same dimension, as specified in the <code>GroupBy</code> parameter.</p> </li>
        /// <li> <p>A single filter for any other dimension in this dimension group.</p> </li>
        /// </ul>
        pub fn filter(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.filter.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.filter = Some(hash_map);
            self
        }
        /// <p>One or more filters to apply to a Performance Insights <code>GetResourceMetrics</code> API query. Restrictions:</p>
        /// <ul>
        /// <li> <p>Any number of filters by the same dimension, as specified in the <code>GroupBy</code> parameter.</p> </li>
        /// <li> <p>A single filter for any other dimension in this dimension group.</p> </li>
        /// </ul>
        pub fn set_filter(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.filter = input;
            self
        }
        /// Consumes the builder and constructs a [`PerformanceInsightsMetricQuery`](crate::model::PerformanceInsightsMetricQuery)
        pub fn build(self) -> crate::model::PerformanceInsightsMetricQuery {
            crate::model::PerformanceInsightsMetricQuery {
                metric: self.metric,
                group_by: self.group_by,
                filter: self.filter,
            }
        }
    }
}
impl PerformanceInsightsMetricQuery {
    /// Creates a new builder-style object to manufacture [`PerformanceInsightsMetricQuery`](crate::model::PerformanceInsightsMetricQuery)
    pub fn builder() -> crate::model::performance_insights_metric_query::Builder {
        crate::model::performance_insights_metric_query::Builder::default()
    }
}

/// <p>A logical grouping of Performance Insights metrics for a related subject area. For example, the <code>db.sql</code> dimension group consists of the following dimensions: <code>db.sql.id</code>, <code>db.sql.db_id</code>, <code>db.sql.statement</code>, and <code>db.sql.tokenized_id</code>.</p> <note>
/// <p>Each response element returns a maximum of 500 bytes. For larger elements, such as SQL statements, only the first 500 bytes are returned.</p>
/// </note>
/// <p>Amazon RDS Performance Insights enables you to monitor and explore different dimensions of database load based on data captured from a running DB instance. DB load is measured as average active sessions. Performance Insights provides the data to API consumers as a two-dimensional time-series dataset. The time dimension provides DB load data for each time point in the queried time range. Each time point decomposes overall load in relation to the requested dimensions, measured at that time point. Examples include SQL, Wait event, User, and Host. </p>
/// <ul>
/// <li> <p>To learn more about Performance Insights and Amazon Aurora DB instances, go to the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights.html"> Amazon Aurora User Guide</a>. </p> </li>
/// <li> <p>To learn more about Performance Insights and Amazon RDS DB instances, go to the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html"> Amazon RDS User Guide</a>. </p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PerformanceInsightsMetricDimensionGroup {
    /// <p>The name of the dimension group. Its valid values are:</p>
    /// <ul>
    /// <li> <p> <code>db</code> - The name of the database to which the client is connected (only Aurora PostgreSQL, Amazon RDS PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)</p> </li>
    /// <li> <p> <code>db.application</code> - The name of the application that is connected to the database (only Aurora PostgreSQL and RDS PostgreSQL)</p> </li>
    /// <li> <p> <code>db.host</code> - The host name of the connected client (all engines)</p> </li>
    /// <li> <p> <code>db.session_type</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)</p> </li>
    /// <li> <p> <code>db.sql</code> - The SQL that is currently executing (all engines)</p> </li>
    /// <li> <p> <code>db.sql_tokenized</code> - The SQL digest (all engines)</p> </li>
    /// <li> <p> <code>db.wait_event</code> - The event for which the database backend is waiting (all engines)</p> </li>
    /// <li> <p> <code>db.wait_event_type</code> - The type of event for which the database backend is waiting (all engines)</p> </li>
    /// <li> <p> <code>db.user</code> - The user logged in to the database (all engines)</p> </li>
    /// </ul>
    pub group: std::option::Option<std::string::String>,
    /// <p>A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies that all of the dimensions in the group were requested or are present in the response.</p>
    /// <p>Valid values for elements in the <code>Dimensions</code> array are:</p>
    /// <ul>
    /// <li> <p> <code>db.application.name</code> - The name of the application that is connected to the database (only Aurora PostgreSQL and RDS PostgreSQL)</p> </li>
    /// <li> <p> <code>db.host.id</code> - The host ID of the connected client (all engines)</p> </li>
    /// <li> <p> <code>db.host.name</code> - The host name of the connected client (all engines)</p> </li>
    /// <li> <p> <code>db.name</code> - The name of the database to which the client is connected (only Aurora PostgreSQL, Amazon RDS PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)</p> </li>
    /// <li> <p> <code>db.session_type.name</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)</p> </li>
    /// <li> <p> <code>db.sql.id</code> - The SQL ID generated by Performance Insights (all engines)</p> </li>
    /// <li> <p> <code>db.sql.db_id</code> - The SQL ID generated by the database (all engines)</p> </li>
    /// <li> <p> <code>db.sql.statement</code> - The SQL text that is being executed (all engines)</p> </li>
    /// <li> <p> <code>db.sql.tokenized_id</code> </p> </li>
    /// <li> <p> <code>db.sql_tokenized.id</code> - The SQL digest ID generated by Performance Insights (all engines)</p> </li>
    /// <li> <p> <code>db.sql_tokenized.db_id</code> - SQL digest ID generated by the database (all engines)</p> </li>
    /// <li> <p> <code>db.sql_tokenized.statement</code> - The SQL digest text (all engines)</p> </li>
    /// <li> <p> <code>db.user.id</code> - The ID of the user logged in to the database (all engines)</p> </li>
    /// <li> <p> <code>db.user.name</code> - The name of the user logged in to the database (all engines)</p> </li>
    /// <li> <p> <code>db.wait_event.name</code> - The event for which the backend is waiting (all engines)</p> </li>
    /// <li> <p> <code>db.wait_event.type</code> - The type of event for which the backend is waiting (all engines)</p> </li>
    /// <li> <p> <code>db.wait_event_type.name</code> - The name of the event type for which the backend is waiting (all engines)</p> </li>
    /// </ul>
    pub dimensions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum number of items to fetch for this dimension group.</p>
    pub limit: std::option::Option<i32>,
}
impl PerformanceInsightsMetricDimensionGroup {
    /// <p>The name of the dimension group. Its valid values are:</p>
    /// <ul>
    /// <li> <p> <code>db</code> - The name of the database to which the client is connected (only Aurora PostgreSQL, Amazon RDS PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)</p> </li>
    /// <li> <p> <code>db.application</code> - The name of the application that is connected to the database (only Aurora PostgreSQL and RDS PostgreSQL)</p> </li>
    /// <li> <p> <code>db.host</code> - The host name of the connected client (all engines)</p> </li>
    /// <li> <p> <code>db.session_type</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)</p> </li>
    /// <li> <p> <code>db.sql</code> - The SQL that is currently executing (all engines)</p> </li>
    /// <li> <p> <code>db.sql_tokenized</code> - The SQL digest (all engines)</p> </li>
    /// <li> <p> <code>db.wait_event</code> - The event for which the database backend is waiting (all engines)</p> </li>
    /// <li> <p> <code>db.wait_event_type</code> - The type of event for which the database backend is waiting (all engines)</p> </li>
    /// <li> <p> <code>db.user</code> - The user logged in to the database (all engines)</p> </li>
    /// </ul>
    pub fn group(&self) -> std::option::Option<&str> {
        self.group.as_deref()
    }
    /// <p>A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies that all of the dimensions in the group were requested or are present in the response.</p>
    /// <p>Valid values for elements in the <code>Dimensions</code> array are:</p>
    /// <ul>
    /// <li> <p> <code>db.application.name</code> - The name of the application that is connected to the database (only Aurora PostgreSQL and RDS PostgreSQL)</p> </li>
    /// <li> <p> <code>db.host.id</code> - The host ID of the connected client (all engines)</p> </li>
    /// <li> <p> <code>db.host.name</code> - The host name of the connected client (all engines)</p> </li>
    /// <li> <p> <code>db.name</code> - The name of the database to which the client is connected (only Aurora PostgreSQL, Amazon RDS PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)</p> </li>
    /// <li> <p> <code>db.session_type.name</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)</p> </li>
    /// <li> <p> <code>db.sql.id</code> - The SQL ID generated by Performance Insights (all engines)</p> </li>
    /// <li> <p> <code>db.sql.db_id</code> - The SQL ID generated by the database (all engines)</p> </li>
    /// <li> <p> <code>db.sql.statement</code> - The SQL text that is being executed (all engines)</p> </li>
    /// <li> <p> <code>db.sql.tokenized_id</code> </p> </li>
    /// <li> <p> <code>db.sql_tokenized.id</code> - The SQL digest ID generated by Performance Insights (all engines)</p> </li>
    /// <li> <p> <code>db.sql_tokenized.db_id</code> - SQL digest ID generated by the database (all engines)</p> </li>
    /// <li> <p> <code>db.sql_tokenized.statement</code> - The SQL digest text (all engines)</p> </li>
    /// <li> <p> <code>db.user.id</code> - The ID of the user logged in to the database (all engines)</p> </li>
    /// <li> <p> <code>db.user.name</code> - The name of the user logged in to the database (all engines)</p> </li>
    /// <li> <p> <code>db.wait_event.name</code> - The event for which the backend is waiting (all engines)</p> </li>
    /// <li> <p> <code>db.wait_event.type</code> - The type of event for which the backend is waiting (all engines)</p> </li>
    /// <li> <p> <code>db.wait_event_type.name</code> - The name of the event type for which the backend is waiting (all engines)</p> </li>
    /// </ul>
    pub fn dimensions(&self) -> std::option::Option<&[std::string::String]> {
        self.dimensions.as_deref()
    }
    /// <p>The maximum number of items to fetch for this dimension group.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for PerformanceInsightsMetricDimensionGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PerformanceInsightsMetricDimensionGroup");
        formatter.field("group", &self.group);
        formatter.field("dimensions", &self.dimensions);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}
/// See [`PerformanceInsightsMetricDimensionGroup`](crate::model::PerformanceInsightsMetricDimensionGroup)
pub mod performance_insights_metric_dimension_group {
    /// A builder for [`PerformanceInsightsMetricDimensionGroup`](crate::model::PerformanceInsightsMetricDimensionGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group: std::option::Option<std::string::String>,
        pub(crate) dimensions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the dimension group. Its valid values are:</p>
        /// <ul>
        /// <li> <p> <code>db</code> - The name of the database to which the client is connected (only Aurora PostgreSQL, Amazon RDS PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)</p> </li>
        /// <li> <p> <code>db.application</code> - The name of the application that is connected to the database (only Aurora PostgreSQL and RDS PostgreSQL)</p> </li>
        /// <li> <p> <code>db.host</code> - The host name of the connected client (all engines)</p> </li>
        /// <li> <p> <code>db.session_type</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)</p> </li>
        /// <li> <p> <code>db.sql</code> - The SQL that is currently executing (all engines)</p> </li>
        /// <li> <p> <code>db.sql_tokenized</code> - The SQL digest (all engines)</p> </li>
        /// <li> <p> <code>db.wait_event</code> - The event for which the database backend is waiting (all engines)</p> </li>
        /// <li> <p> <code>db.wait_event_type</code> - The type of event for which the database backend is waiting (all engines)</p> </li>
        /// <li> <p> <code>db.user</code> - The user logged in to the database (all engines)</p> </li>
        /// </ul>
        pub fn group(mut self, input: impl Into<std::string::String>) -> Self {
            self.group = Some(input.into());
            self
        }
        /// <p>The name of the dimension group. Its valid values are:</p>
        /// <ul>
        /// <li> <p> <code>db</code> - The name of the database to which the client is connected (only Aurora PostgreSQL, Amazon RDS PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)</p> </li>
        /// <li> <p> <code>db.application</code> - The name of the application that is connected to the database (only Aurora PostgreSQL and RDS PostgreSQL)</p> </li>
        /// <li> <p> <code>db.host</code> - The host name of the connected client (all engines)</p> </li>
        /// <li> <p> <code>db.session_type</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)</p> </li>
        /// <li> <p> <code>db.sql</code> - The SQL that is currently executing (all engines)</p> </li>
        /// <li> <p> <code>db.sql_tokenized</code> - The SQL digest (all engines)</p> </li>
        /// <li> <p> <code>db.wait_event</code> - The event for which the database backend is waiting (all engines)</p> </li>
        /// <li> <p> <code>db.wait_event_type</code> - The type of event for which the database backend is waiting (all engines)</p> </li>
        /// <li> <p> <code>db.user</code> - The user logged in to the database (all engines)</p> </li>
        /// </ul>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group = input;
            self
        }
        /// Appends an item to `dimensions`.
        ///
        /// To override the contents of this collection use [`set_dimensions`](Self::set_dimensions).
        ///
        /// <p>A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies that all of the dimensions in the group were requested or are present in the response.</p>
        /// <p>Valid values for elements in the <code>Dimensions</code> array are:</p>
        /// <ul>
        /// <li> <p> <code>db.application.name</code> - The name of the application that is connected to the database (only Aurora PostgreSQL and RDS PostgreSQL)</p> </li>
        /// <li> <p> <code>db.host.id</code> - The host ID of the connected client (all engines)</p> </li>
        /// <li> <p> <code>db.host.name</code> - The host name of the connected client (all engines)</p> </li>
        /// <li> <p> <code>db.name</code> - The name of the database to which the client is connected (only Aurora PostgreSQL, Amazon RDS PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)</p> </li>
        /// <li> <p> <code>db.session_type.name</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)</p> </li>
        /// <li> <p> <code>db.sql.id</code> - The SQL ID generated by Performance Insights (all engines)</p> </li>
        /// <li> <p> <code>db.sql.db_id</code> - The SQL ID generated by the database (all engines)</p> </li>
        /// <li> <p> <code>db.sql.statement</code> - The SQL text that is being executed (all engines)</p> </li>
        /// <li> <p> <code>db.sql.tokenized_id</code> </p> </li>
        /// <li> <p> <code>db.sql_tokenized.id</code> - The SQL digest ID generated by Performance Insights (all engines)</p> </li>
        /// <li> <p> <code>db.sql_tokenized.db_id</code> - SQL digest ID generated by the database (all engines)</p> </li>
        /// <li> <p> <code>db.sql_tokenized.statement</code> - The SQL digest text (all engines)</p> </li>
        /// <li> <p> <code>db.user.id</code> - The ID of the user logged in to the database (all engines)</p> </li>
        /// <li> <p> <code>db.user.name</code> - The name of the user logged in to the database (all engines)</p> </li>
        /// <li> <p> <code>db.wait_event.name</code> - The event for which the backend is waiting (all engines)</p> </li>
        /// <li> <p> <code>db.wait_event.type</code> - The type of event for which the backend is waiting (all engines)</p> </li>
        /// <li> <p> <code>db.wait_event_type.name</code> - The name of the event type for which the backend is waiting (all engines)</p> </li>
        /// </ul>
        pub fn dimensions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.dimensions.unwrap_or_default();
            v.push(input.into());
            self.dimensions = Some(v);
            self
        }
        /// <p>A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies that all of the dimensions in the group were requested or are present in the response.</p>
        /// <p>Valid values for elements in the <code>Dimensions</code> array are:</p>
        /// <ul>
        /// <li> <p> <code>db.application.name</code> - The name of the application that is connected to the database (only Aurora PostgreSQL and RDS PostgreSQL)</p> </li>
        /// <li> <p> <code>db.host.id</code> - The host ID of the connected client (all engines)</p> </li>
        /// <li> <p> <code>db.host.name</code> - The host name of the connected client (all engines)</p> </li>
        /// <li> <p> <code>db.name</code> - The name of the database to which the client is connected (only Aurora PostgreSQL, Amazon RDS PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)</p> </li>
        /// <li> <p> <code>db.session_type.name</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)</p> </li>
        /// <li> <p> <code>db.sql.id</code> - The SQL ID generated by Performance Insights (all engines)</p> </li>
        /// <li> <p> <code>db.sql.db_id</code> - The SQL ID generated by the database (all engines)</p> </li>
        /// <li> <p> <code>db.sql.statement</code> - The SQL text that is being executed (all engines)</p> </li>
        /// <li> <p> <code>db.sql.tokenized_id</code> </p> </li>
        /// <li> <p> <code>db.sql_tokenized.id</code> - The SQL digest ID generated by Performance Insights (all engines)</p> </li>
        /// <li> <p> <code>db.sql_tokenized.db_id</code> - SQL digest ID generated by the database (all engines)</p> </li>
        /// <li> <p> <code>db.sql_tokenized.statement</code> - The SQL digest text (all engines)</p> </li>
        /// <li> <p> <code>db.user.id</code> - The ID of the user logged in to the database (all engines)</p> </li>
        /// <li> <p> <code>db.user.name</code> - The name of the user logged in to the database (all engines)</p> </li>
        /// <li> <p> <code>db.wait_event.name</code> - The event for which the backend is waiting (all engines)</p> </li>
        /// <li> <p> <code>db.wait_event.type</code> - The type of event for which the backend is waiting (all engines)</p> </li>
        /// <li> <p> <code>db.wait_event_type.name</code> - The name of the event type for which the backend is waiting (all engines)</p> </li>
        /// </ul>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// <p>The maximum number of items to fetch for this dimension group.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of items to fetch for this dimension group.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`PerformanceInsightsMetricDimensionGroup`](crate::model::PerformanceInsightsMetricDimensionGroup)
        pub fn build(self) -> crate::model::PerformanceInsightsMetricDimensionGroup {
            crate::model::PerformanceInsightsMetricDimensionGroup {
                group: self.group,
                dimensions: self.dimensions,
                limit: self.limit,
            }
        }
    }
}
impl PerformanceInsightsMetricDimensionGroup {
    /// Creates a new builder-style object to manufacture [`PerformanceInsightsMetricDimensionGroup`](crate::model::PerformanceInsightsMetricDimensionGroup)
    pub fn builder() -> crate::model::performance_insights_metric_dimension_group::Builder {
        crate::model::performance_insights_metric_dimension_group::Builder::default()
    }
}

/// <p>A reference value to compare Performance Insights metrics against to determine if the metrics demonstrate anomalous behavior.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PerformanceInsightsReferenceScalar {
    /// <p>The reference value.</p>
    pub value: std::option::Option<f64>,
}
impl PerformanceInsightsReferenceScalar {
    /// <p>The reference value.</p>
    pub fn value(&self) -> std::option::Option<f64> {
        self.value
    }
}
impl std::fmt::Debug for PerformanceInsightsReferenceScalar {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PerformanceInsightsReferenceScalar");
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`PerformanceInsightsReferenceScalar`](crate::model::PerformanceInsightsReferenceScalar)
pub mod performance_insights_reference_scalar {
    /// A builder for [`PerformanceInsightsReferenceScalar`](crate::model::PerformanceInsightsReferenceScalar)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The reference value.</p>
        pub fn value(mut self, input: f64) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The reference value.</p>
        pub fn set_value(mut self, input: std::option::Option<f64>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`PerformanceInsightsReferenceScalar`](crate::model::PerformanceInsightsReferenceScalar)
        pub fn build(self) -> crate::model::PerformanceInsightsReferenceScalar {
            crate::model::PerformanceInsightsReferenceScalar { value: self.value }
        }
    }
}
impl PerformanceInsightsReferenceScalar {
    /// Creates a new builder-style object to manufacture [`PerformanceInsightsReferenceScalar`](crate::model::PerformanceInsightsReferenceScalar)
    pub fn builder() -> crate::model::performance_insights_reference_scalar::Builder {
        crate::model::performance_insights_reference_scalar::Builder::default()
    }
}

/// <p> Information about an Amazon CloudWatch metric. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchMetricsDetail {
    /// <p> The name of the CloudWatch metric. </p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p> The namespace of the CloudWatch metric. A namespace is a container for CloudWatch metrics. </p>
    pub namespace: std::option::Option<std::string::String>,
    /// <p> An array of CloudWatch dimensions associated with </p>
    pub dimensions: std::option::Option<std::vec::Vec<crate::model::CloudWatchMetricsDimension>>,
    /// <p> The type of statistic associated with the CloudWatch metric. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic">Statistics</a> in the <i>Amazon CloudWatch User Guide</i>. </p>
    pub stat: std::option::Option<crate::model::CloudWatchMetricsStat>,
    /// <p> The unit of measure used for the CloudWatch metric. For example, <code>Bytes</code>, <code>Seconds</code>, <code>Count</code>, and <code>Percent</code>. </p>
    pub unit: std::option::Option<std::string::String>,
    /// <p> The length of time associated with the CloudWatch metric in number of seconds. </p>
    pub period: i32,
    /// <p>This object returns anomaly metric data.</p>
    pub metric_data_summary: std::option::Option<crate::model::CloudWatchMetricsDataSummary>,
}
impl CloudWatchMetricsDetail {
    /// <p> The name of the CloudWatch metric. </p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p> The namespace of the CloudWatch metric. A namespace is a container for CloudWatch metrics. </p>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p> An array of CloudWatch dimensions associated with </p>
    pub fn dimensions(&self) -> std::option::Option<&[crate::model::CloudWatchMetricsDimension]> {
        self.dimensions.as_deref()
    }
    /// <p> The type of statistic associated with the CloudWatch metric. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic">Statistics</a> in the <i>Amazon CloudWatch User Guide</i>. </p>
    pub fn stat(&self) -> std::option::Option<&crate::model::CloudWatchMetricsStat> {
        self.stat.as_ref()
    }
    /// <p> The unit of measure used for the CloudWatch metric. For example, <code>Bytes</code>, <code>Seconds</code>, <code>Count</code>, and <code>Percent</code>. </p>
    pub fn unit(&self) -> std::option::Option<&str> {
        self.unit.as_deref()
    }
    /// <p> The length of time associated with the CloudWatch metric in number of seconds. </p>
    pub fn period(&self) -> i32 {
        self.period
    }
    /// <p>This object returns anomaly metric data.</p>
    pub fn metric_data_summary(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchMetricsDataSummary> {
        self.metric_data_summary.as_ref()
    }
}
impl std::fmt::Debug for CloudWatchMetricsDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchMetricsDetail");
        formatter.field("metric_name", &self.metric_name);
        formatter.field("namespace", &self.namespace);
        formatter.field("dimensions", &self.dimensions);
        formatter.field("stat", &self.stat);
        formatter.field("unit", &self.unit);
        formatter.field("period", &self.period);
        formatter.field("metric_data_summary", &self.metric_data_summary);
        formatter.finish()
    }
}
/// See [`CloudWatchMetricsDetail`](crate::model::CloudWatchMetricsDetail)
pub mod cloud_watch_metrics_detail {
    /// A builder for [`CloudWatchMetricsDetail`](crate::model::CloudWatchMetricsDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) dimensions:
            std::option::Option<std::vec::Vec<crate::model::CloudWatchMetricsDimension>>,
        pub(crate) stat: std::option::Option<crate::model::CloudWatchMetricsStat>,
        pub(crate) unit: std::option::Option<std::string::String>,
        pub(crate) period: std::option::Option<i32>,
        pub(crate) metric_data_summary:
            std::option::Option<crate::model::CloudWatchMetricsDataSummary>,
    }
    impl Builder {
        /// <p> The name of the CloudWatch metric. </p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p> The name of the CloudWatch metric. </p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p> The namespace of the CloudWatch metric. A namespace is a container for CloudWatch metrics. </p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p> The namespace of the CloudWatch metric. A namespace is a container for CloudWatch metrics. </p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Appends an item to `dimensions`.
        ///
        /// To override the contents of this collection use [`set_dimensions`](Self::set_dimensions).
        ///
        /// <p> An array of CloudWatch dimensions associated with </p>
        pub fn dimensions(mut self, input: crate::model::CloudWatchMetricsDimension) -> Self {
            let mut v = self.dimensions.unwrap_or_default();
            v.push(input);
            self.dimensions = Some(v);
            self
        }
        /// <p> An array of CloudWatch dimensions associated with </p>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CloudWatchMetricsDimension>>,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// <p> The type of statistic associated with the CloudWatch metric. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic">Statistics</a> in the <i>Amazon CloudWatch User Guide</i>. </p>
        pub fn stat(mut self, input: crate::model::CloudWatchMetricsStat) -> Self {
            self.stat = Some(input);
            self
        }
        /// <p> The type of statistic associated with the CloudWatch metric. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic">Statistics</a> in the <i>Amazon CloudWatch User Guide</i>. </p>
        pub fn set_stat(
            mut self,
            input: std::option::Option<crate::model::CloudWatchMetricsStat>,
        ) -> Self {
            self.stat = input;
            self
        }
        /// <p> The unit of measure used for the CloudWatch metric. For example, <code>Bytes</code>, <code>Seconds</code>, <code>Count</code>, and <code>Percent</code>. </p>
        pub fn unit(mut self, input: impl Into<std::string::String>) -> Self {
            self.unit = Some(input.into());
            self
        }
        /// <p> The unit of measure used for the CloudWatch metric. For example, <code>Bytes</code>, <code>Seconds</code>, <code>Count</code>, and <code>Percent</code>. </p>
        pub fn set_unit(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.unit = input;
            self
        }
        /// <p> The length of time associated with the CloudWatch metric in number of seconds. </p>
        pub fn period(mut self, input: i32) -> Self {
            self.period = Some(input);
            self
        }
        /// <p> The length of time associated with the CloudWatch metric in number of seconds. </p>
        pub fn set_period(mut self, input: std::option::Option<i32>) -> Self {
            self.period = input;
            self
        }
        /// <p>This object returns anomaly metric data.</p>
        pub fn metric_data_summary(
            mut self,
            input: crate::model::CloudWatchMetricsDataSummary,
        ) -> Self {
            self.metric_data_summary = Some(input);
            self
        }
        /// <p>This object returns anomaly metric data.</p>
        pub fn set_metric_data_summary(
            mut self,
            input: std::option::Option<crate::model::CloudWatchMetricsDataSummary>,
        ) -> Self {
            self.metric_data_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchMetricsDetail`](crate::model::CloudWatchMetricsDetail)
        pub fn build(self) -> crate::model::CloudWatchMetricsDetail {
            crate::model::CloudWatchMetricsDetail {
                metric_name: self.metric_name,
                namespace: self.namespace,
                dimensions: self.dimensions,
                stat: self.stat,
                unit: self.unit,
                period: self.period.unwrap_or_default(),
                metric_data_summary: self.metric_data_summary,
            }
        }
    }
}
impl CloudWatchMetricsDetail {
    /// Creates a new builder-style object to manufacture [`CloudWatchMetricsDetail`](crate::model::CloudWatchMetricsDetail)
    pub fn builder() -> crate::model::cloud_watch_metrics_detail::Builder {
        crate::model::cloud_watch_metrics_detail::Builder::default()
    }
}

/// <p>Contains information about the analyzed metrics that displayed anomalous behavior. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchMetricsDataSummary {
    /// <p>This is a list of Amazon CloudWatch metric values at given timestamp.</p>
    pub timestamp_metric_value_pair_list:
        std::option::Option<std::vec::Vec<crate::model::TimestampMetricValuePair>>,
    /// <p>This is an enum of the status showing whether the metric value pair list has partial or complete data, or if there was an error.</p>
    pub status_code: std::option::Option<crate::model::CloudWatchMetricDataStatusCode>,
}
impl CloudWatchMetricsDataSummary {
    /// <p>This is a list of Amazon CloudWatch metric values at given timestamp.</p>
    pub fn timestamp_metric_value_pair_list(
        &self,
    ) -> std::option::Option<&[crate::model::TimestampMetricValuePair]> {
        self.timestamp_metric_value_pair_list.as_deref()
    }
    /// <p>This is an enum of the status showing whether the metric value pair list has partial or complete data, or if there was an error.</p>
    pub fn status_code(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchMetricDataStatusCode> {
        self.status_code.as_ref()
    }
}
impl std::fmt::Debug for CloudWatchMetricsDataSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchMetricsDataSummary");
        formatter.field(
            "timestamp_metric_value_pair_list",
            &self.timestamp_metric_value_pair_list,
        );
        formatter.field("status_code", &self.status_code);
        formatter.finish()
    }
}
/// See [`CloudWatchMetricsDataSummary`](crate::model::CloudWatchMetricsDataSummary)
pub mod cloud_watch_metrics_data_summary {
    /// A builder for [`CloudWatchMetricsDataSummary`](crate::model::CloudWatchMetricsDataSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timestamp_metric_value_pair_list:
            std::option::Option<std::vec::Vec<crate::model::TimestampMetricValuePair>>,
        pub(crate) status_code: std::option::Option<crate::model::CloudWatchMetricDataStatusCode>,
    }
    impl Builder {
        /// Appends an item to `timestamp_metric_value_pair_list`.
        ///
        /// To override the contents of this collection use [`set_timestamp_metric_value_pair_list`](Self::set_timestamp_metric_value_pair_list).
        ///
        /// <p>This is a list of Amazon CloudWatch metric values at given timestamp.</p>
        pub fn timestamp_metric_value_pair_list(
            mut self,
            input: crate::model::TimestampMetricValuePair,
        ) -> Self {
            let mut v = self.timestamp_metric_value_pair_list.unwrap_or_default();
            v.push(input);
            self.timestamp_metric_value_pair_list = Some(v);
            self
        }
        /// <p>This is a list of Amazon CloudWatch metric values at given timestamp.</p>
        pub fn set_timestamp_metric_value_pair_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TimestampMetricValuePair>>,
        ) -> Self {
            self.timestamp_metric_value_pair_list = input;
            self
        }
        /// <p>This is an enum of the status showing whether the metric value pair list has partial or complete data, or if there was an error.</p>
        pub fn status_code(mut self, input: crate::model::CloudWatchMetricDataStatusCode) -> Self {
            self.status_code = Some(input);
            self
        }
        /// <p>This is an enum of the status showing whether the metric value pair list has partial or complete data, or if there was an error.</p>
        pub fn set_status_code(
            mut self,
            input: std::option::Option<crate::model::CloudWatchMetricDataStatusCode>,
        ) -> Self {
            self.status_code = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchMetricsDataSummary`](crate::model::CloudWatchMetricsDataSummary)
        pub fn build(self) -> crate::model::CloudWatchMetricsDataSummary {
            crate::model::CloudWatchMetricsDataSummary {
                timestamp_metric_value_pair_list: self.timestamp_metric_value_pair_list,
                status_code: self.status_code,
            }
        }
    }
}
impl CloudWatchMetricsDataSummary {
    /// Creates a new builder-style object to manufacture [`CloudWatchMetricsDataSummary`](crate::model::CloudWatchMetricsDataSummary)
    pub fn builder() -> crate::model::cloud_watch_metrics_data_summary::Builder {
        crate::model::cloud_watch_metrics_data_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CloudWatchMetricDataStatusCode {
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    #[allow(missing_docs)] // documentation missing in model
    PartialData,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CloudWatchMetricDataStatusCode {
    fn from(s: &str) -> Self {
        match s {
            "Complete" => CloudWatchMetricDataStatusCode::Complete,
            "InternalError" => CloudWatchMetricDataStatusCode::InternalError,
            "PartialData" => CloudWatchMetricDataStatusCode::PartialData,
            other => CloudWatchMetricDataStatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CloudWatchMetricDataStatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CloudWatchMetricDataStatusCode::from(s))
    }
}
impl CloudWatchMetricDataStatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CloudWatchMetricDataStatusCode::Complete => "Complete",
            CloudWatchMetricDataStatusCode::InternalError => "InternalError",
            CloudWatchMetricDataStatusCode::PartialData => "PartialData",
            CloudWatchMetricDataStatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Complete", "InternalError", "PartialData"]
    }
}
impl AsRef<str> for CloudWatchMetricDataStatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A pair that contains metric values at the respective timestamp.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimestampMetricValuePair {
    /// <p>A <code>Timestamp</code> that specifies the time the event occurred. </p>
    pub timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Value of the anomalous metric data point at respective Timestamp.</p>
    pub metric_value: std::option::Option<f64>,
}
impl TimestampMetricValuePair {
    /// <p>A <code>Timestamp</code> that specifies the time the event occurred. </p>
    pub fn timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.timestamp.as_ref()
    }
    /// <p>Value of the anomalous metric data point at respective Timestamp.</p>
    pub fn metric_value(&self) -> std::option::Option<f64> {
        self.metric_value
    }
}
impl std::fmt::Debug for TimestampMetricValuePair {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimestampMetricValuePair");
        formatter.field("timestamp", &self.timestamp);
        formatter.field("metric_value", &self.metric_value);
        formatter.finish()
    }
}
/// See [`TimestampMetricValuePair`](crate::model::TimestampMetricValuePair)
pub mod timestamp_metric_value_pair {
    /// A builder for [`TimestampMetricValuePair`](crate::model::TimestampMetricValuePair)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) metric_value: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>A <code>Timestamp</code> that specifies the time the event occurred. </p>
        pub fn timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>A <code>Timestamp</code> that specifies the time the event occurred. </p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>Value of the anomalous metric data point at respective Timestamp.</p>
        pub fn metric_value(mut self, input: f64) -> Self {
            self.metric_value = Some(input);
            self
        }
        /// <p>Value of the anomalous metric data point at respective Timestamp.</p>
        pub fn set_metric_value(mut self, input: std::option::Option<f64>) -> Self {
            self.metric_value = input;
            self
        }
        /// Consumes the builder and constructs a [`TimestampMetricValuePair`](crate::model::TimestampMetricValuePair)
        pub fn build(self) -> crate::model::TimestampMetricValuePair {
            crate::model::TimestampMetricValuePair {
                timestamp: self.timestamp,
                metric_value: self.metric_value,
            }
        }
    }
}
impl TimestampMetricValuePair {
    /// Creates a new builder-style object to manufacture [`TimestampMetricValuePair`](crate::model::TimestampMetricValuePair)
    pub fn builder() -> crate::model::timestamp_metric_value_pair::Builder {
        crate::model::timestamp_metric_value_pair::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CloudWatchMetricsStat {
    #[allow(missing_docs)] // documentation missing in model
    Average,
    #[allow(missing_docs)] // documentation missing in model
    Maximum,
    #[allow(missing_docs)] // documentation missing in model
    Minimum,
    #[allow(missing_docs)] // documentation missing in model
    SampleCount,
    #[allow(missing_docs)] // documentation missing in model
    Sum,
    #[allow(missing_docs)] // documentation missing in model
    P50,
    #[allow(missing_docs)] // documentation missing in model
    P90,
    #[allow(missing_docs)] // documentation missing in model
    P99,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CloudWatchMetricsStat {
    fn from(s: &str) -> Self {
        match s {
            "Average" => CloudWatchMetricsStat::Average,
            "Maximum" => CloudWatchMetricsStat::Maximum,
            "Minimum" => CloudWatchMetricsStat::Minimum,
            "SampleCount" => CloudWatchMetricsStat::SampleCount,
            "Sum" => CloudWatchMetricsStat::Sum,
            "p50" => CloudWatchMetricsStat::P50,
            "p90" => CloudWatchMetricsStat::P90,
            "p99" => CloudWatchMetricsStat::P99,
            other => CloudWatchMetricsStat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CloudWatchMetricsStat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CloudWatchMetricsStat::from(s))
    }
}
impl CloudWatchMetricsStat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CloudWatchMetricsStat::Average => "Average",
            CloudWatchMetricsStat::Maximum => "Maximum",
            CloudWatchMetricsStat::Minimum => "Minimum",
            CloudWatchMetricsStat::SampleCount => "SampleCount",
            CloudWatchMetricsStat::Sum => "Sum",
            CloudWatchMetricsStat::P50 => "p50",
            CloudWatchMetricsStat::P90 => "p90",
            CloudWatchMetricsStat::P99 => "p99",
            CloudWatchMetricsStat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Average",
            "Maximum",
            "Minimum",
            "SampleCount",
            "Sum",
            "p50",
            "p90",
            "p99",
        ]
    }
}
impl AsRef<str> for CloudWatchMetricsStat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The dimension of am Amazon CloudWatch metric that is used when DevOps Guru analyzes the resources in your account for operational problems and anomalous behavior. A dimension is a name/value pair that is part of the identity of a metric. A metric can have up to 10 dimensions. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Dimension">Dimensions</a> in the <i>Amazon CloudWatch User Guide</i>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchMetricsDimension {
    /// <p> The name of the CloudWatch dimension. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The value of the CloudWatch dimension. </p>
    pub value: std::option::Option<std::string::String>,
}
impl CloudWatchMetricsDimension {
    /// <p> The name of the CloudWatch dimension. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> The value of the CloudWatch dimension. </p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for CloudWatchMetricsDimension {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchMetricsDimension");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`CloudWatchMetricsDimension`](crate::model::CloudWatchMetricsDimension)
pub mod cloud_watch_metrics_dimension {
    /// A builder for [`CloudWatchMetricsDimension`](crate::model::CloudWatchMetricsDimension)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the CloudWatch dimension. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the CloudWatch dimension. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The value of the CloudWatch dimension. </p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p> The value of the CloudWatch dimension. </p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchMetricsDimension`](crate::model::CloudWatchMetricsDimension)
        pub fn build(self) -> crate::model::CloudWatchMetricsDimension {
            crate::model::CloudWatchMetricsDimension {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl CloudWatchMetricsDimension {
    /// Creates a new builder-style object to manufacture [`CloudWatchMetricsDimension`](crate::model::CloudWatchMetricsDimension)
    pub fn builder() -> crate::model::cloud_watch_metrics_dimension::Builder {
        crate::model::cloud_watch_metrics_dimension::Builder::default()
    }
}

/// <p> A time range that specifies when DevOps Guru opens and then closes an anomaly. This is different from <code>AnomalyTimeRange</code>, which specifies the time range when DevOps Guru actually observes the anomalous behavior. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnomalyReportedTimeRange {
    /// <p> The time when an anomaly is opened. </p>
    pub open_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The time when an anomaly is closed. </p>
    pub close_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl AnomalyReportedTimeRange {
    /// <p> The time when an anomaly is opened. </p>
    pub fn open_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.open_time.as_ref()
    }
    /// <p> The time when an anomaly is closed. </p>
    pub fn close_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.close_time.as_ref()
    }
}
impl std::fmt::Debug for AnomalyReportedTimeRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnomalyReportedTimeRange");
        formatter.field("open_time", &self.open_time);
        formatter.field("close_time", &self.close_time);
        formatter.finish()
    }
}
/// See [`AnomalyReportedTimeRange`](crate::model::AnomalyReportedTimeRange)
pub mod anomaly_reported_time_range {
    /// A builder for [`AnomalyReportedTimeRange`](crate::model::AnomalyReportedTimeRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) open_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) close_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p> The time when an anomaly is opened. </p>
        pub fn open_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.open_time = Some(input);
            self
        }
        /// <p> The time when an anomaly is opened. </p>
        pub fn set_open_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.open_time = input;
            self
        }
        /// <p> The time when an anomaly is closed. </p>
        pub fn close_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.close_time = Some(input);
            self
        }
        /// <p> The time when an anomaly is closed. </p>
        pub fn set_close_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.close_time = input;
            self
        }
        /// Consumes the builder and constructs a [`AnomalyReportedTimeRange`](crate::model::AnomalyReportedTimeRange)
        pub fn build(self) -> crate::model::AnomalyReportedTimeRange {
            crate::model::AnomalyReportedTimeRange {
                open_time: self.open_time,
                close_time: self.close_time,
            }
        }
    }
}
impl AnomalyReportedTimeRange {
    /// Creates a new builder-style object to manufacture [`AnomalyReportedTimeRange`](crate::model::AnomalyReportedTimeRange)
    pub fn builder() -> crate::model::anomaly_reported_time_range::Builder {
        crate::model::anomaly_reported_time_range::Builder::default()
    }
}

/// <p> A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from <code>AnomalyReportedTimeRange</code>, which specifies the time range when DevOps Guru opens and then closes an anomaly. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnomalyTimeRange {
    /// <p> The time when the anomalous behavior started. </p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The time when the anomalous behavior ended. </p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl AnomalyTimeRange {
    /// <p> The time when the anomalous behavior started. </p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p> The time when the anomalous behavior ended. </p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
}
impl std::fmt::Debug for AnomalyTimeRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnomalyTimeRange");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.finish()
    }
}
/// See [`AnomalyTimeRange`](crate::model::AnomalyTimeRange)
pub mod anomaly_time_range {
    /// A builder for [`AnomalyTimeRange`](crate::model::AnomalyTimeRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p> The time when the anomalous behavior started. </p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p> The time when the anomalous behavior started. </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p> The time when the anomalous behavior ended. </p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p> The time when the anomalous behavior ended. </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`AnomalyTimeRange`](crate::model::AnomalyTimeRange)
        pub fn build(self) -> crate::model::AnomalyTimeRange {
            crate::model::AnomalyTimeRange {
                start_time: self.start_time,
                end_time: self.end_time,
            }
        }
    }
}
impl AnomalyTimeRange {
    /// Creates a new builder-style object to manufacture [`AnomalyTimeRange`](crate::model::AnomalyTimeRange)
    pub fn builder() -> crate::model::anomaly_time_range::Builder {
        crate::model::anomaly_time_range::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AnomalyStatus {
    #[allow(missing_docs)] // documentation missing in model
    Closed,
    #[allow(missing_docs)] // documentation missing in model
    Ongoing,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AnomalyStatus {
    fn from(s: &str) -> Self {
        match s {
            "CLOSED" => AnomalyStatus::Closed,
            "ONGOING" => AnomalyStatus::Ongoing,
            other => AnomalyStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AnomalyStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AnomalyStatus::from(s))
    }
}
impl AnomalyStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AnomalyStatus::Closed => "CLOSED",
            AnomalyStatus::Ongoing => "ONGOING",
            AnomalyStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CLOSED", "ONGOING"]
    }
}
impl AsRef<str> for AnomalyStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AnomalySeverity {
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AnomalySeverity {
    fn from(s: &str) -> Self {
        match s {
            "HIGH" => AnomalySeverity::High,
            "LOW" => AnomalySeverity::Low,
            "MEDIUM" => AnomalySeverity::Medium,
            other => AnomalySeverity::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AnomalySeverity {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AnomalySeverity::from(s))
    }
}
impl AnomalySeverity {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AnomalySeverity::High => "HIGH",
            AnomalySeverity::Low => "LOW",
            AnomalySeverity::Medium => "MEDIUM",
            AnomalySeverity::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HIGH", "LOW", "MEDIUM"]
    }
}
impl AsRef<str> for AnomalySeverity {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details about a proactive anomaly. This object is returned by <code>DescribeAnomaly.</code> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProactiveAnomalySummary {
    /// <p>The ID of the anomaly.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The severity of the anomaly. The severity of anomalies that generate an insight determine that insight's severity. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
    pub severity: std::option::Option<crate::model::AnomalySeverity>,
    /// <p>The status of the anomaly.</p>
    pub status: std::option::Option<crate::model::AnomalyStatus>,
    /// <p> The time of the anomaly's most recent update. </p>
    pub update_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from <code>AnomalyReportedTimeRange</code>, which specifies the time range when DevOps Guru opens and then closes an anomaly. </p>
    pub anomaly_time_range: std::option::Option<crate::model::AnomalyTimeRange>,
    /// <p> An <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed. </p>
    pub anomaly_reported_time_range: std::option::Option<crate::model::AnomalyReportedTimeRange>,
    /// <p> The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur. </p>
    pub prediction_time_range: std::option::Option<crate::model::PredictionTimeRange>,
    /// <p> Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics. </p>
    pub source_details: std::option::Option<crate::model::AnomalySourceDetails>,
    /// <p> The ID of the insight that contains this anomaly. An insight is composed of related anomalies. </p>
    pub associated_insight_id: std::option::Option<std::string::String>,
    /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub resource_collection: std::option::Option<crate::model::ResourceCollection>,
    /// <p> A threshold that was exceeded by behavior in analyzed resources. Exceeding this threshold is related to the anomalous behavior that generated this anomaly. </p>
    pub limit: std::option::Option<f64>,
    /// <p>Returns the metadata of the source.</p>
    pub source_metadata: std::option::Option<crate::model::AnomalySourceMetadata>,
    /// <p>Information about a resource in which DevOps Guru detected anomalous behavior.</p>
    pub anomaly_resources: std::option::Option<std::vec::Vec<crate::model::AnomalyResource>>,
}
impl ProactiveAnomalySummary {
    /// <p>The ID of the anomaly.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The severity of the anomaly. The severity of anomalies that generate an insight determine that insight's severity. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
    pub fn severity(&self) -> std::option::Option<&crate::model::AnomalySeverity> {
        self.severity.as_ref()
    }
    /// <p>The status of the anomaly.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::AnomalyStatus> {
        self.status.as_ref()
    }
    /// <p> The time of the anomaly's most recent update. </p>
    pub fn update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_time.as_ref()
    }
    /// <p> A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from <code>AnomalyReportedTimeRange</code>, which specifies the time range when DevOps Guru opens and then closes an anomaly. </p>
    pub fn anomaly_time_range(&self) -> std::option::Option<&crate::model::AnomalyTimeRange> {
        self.anomaly_time_range.as_ref()
    }
    /// <p> An <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed. </p>
    pub fn anomaly_reported_time_range(
        &self,
    ) -> std::option::Option<&crate::model::AnomalyReportedTimeRange> {
        self.anomaly_reported_time_range.as_ref()
    }
    /// <p> The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur. </p>
    pub fn prediction_time_range(&self) -> std::option::Option<&crate::model::PredictionTimeRange> {
        self.prediction_time_range.as_ref()
    }
    /// <p> Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics. </p>
    pub fn source_details(&self) -> std::option::Option<&crate::model::AnomalySourceDetails> {
        self.source_details.as_ref()
    }
    /// <p> The ID of the insight that contains this anomaly. An insight is composed of related anomalies. </p>
    pub fn associated_insight_id(&self) -> std::option::Option<&str> {
        self.associated_insight_id.as_deref()
    }
    /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub fn resource_collection(&self) -> std::option::Option<&crate::model::ResourceCollection> {
        self.resource_collection.as_ref()
    }
    /// <p> A threshold that was exceeded by behavior in analyzed resources. Exceeding this threshold is related to the anomalous behavior that generated this anomaly. </p>
    pub fn limit(&self) -> std::option::Option<f64> {
        self.limit
    }
    /// <p>Returns the metadata of the source.</p>
    pub fn source_metadata(&self) -> std::option::Option<&crate::model::AnomalySourceMetadata> {
        self.source_metadata.as_ref()
    }
    /// <p>Information about a resource in which DevOps Guru detected anomalous behavior.</p>
    pub fn anomaly_resources(&self) -> std::option::Option<&[crate::model::AnomalyResource]> {
        self.anomaly_resources.as_deref()
    }
}
impl std::fmt::Debug for ProactiveAnomalySummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProactiveAnomalySummary");
        formatter.field("id", &self.id);
        formatter.field("severity", &self.severity);
        formatter.field("status", &self.status);
        formatter.field("update_time", &self.update_time);
        formatter.field("anomaly_time_range", &self.anomaly_time_range);
        formatter.field(
            "anomaly_reported_time_range",
            &self.anomaly_reported_time_range,
        );
        formatter.field("prediction_time_range", &self.prediction_time_range);
        formatter.field("source_details", &self.source_details);
        formatter.field("associated_insight_id", &self.associated_insight_id);
        formatter.field("resource_collection", &self.resource_collection);
        formatter.field("limit", &self.limit);
        formatter.field("source_metadata", &self.source_metadata);
        formatter.field("anomaly_resources", &self.anomaly_resources);
        formatter.finish()
    }
}
/// See [`ProactiveAnomalySummary`](crate::model::ProactiveAnomalySummary)
pub mod proactive_anomaly_summary {
    /// A builder for [`ProactiveAnomalySummary`](crate::model::ProactiveAnomalySummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<crate::model::AnomalySeverity>,
        pub(crate) status: std::option::Option<crate::model::AnomalyStatus>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) anomaly_time_range: std::option::Option<crate::model::AnomalyTimeRange>,
        pub(crate) anomaly_reported_time_range:
            std::option::Option<crate::model::AnomalyReportedTimeRange>,
        pub(crate) prediction_time_range: std::option::Option<crate::model::PredictionTimeRange>,
        pub(crate) source_details: std::option::Option<crate::model::AnomalySourceDetails>,
        pub(crate) associated_insight_id: std::option::Option<std::string::String>,
        pub(crate) resource_collection: std::option::Option<crate::model::ResourceCollection>,
        pub(crate) limit: std::option::Option<f64>,
        pub(crate) source_metadata: std::option::Option<crate::model::AnomalySourceMetadata>,
        pub(crate) anomaly_resources:
            std::option::Option<std::vec::Vec<crate::model::AnomalyResource>>,
    }
    impl Builder {
        /// <p>The ID of the anomaly.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the anomaly.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The severity of the anomaly. The severity of anomalies that generate an insight determine that insight's severity. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
        pub fn severity(mut self, input: crate::model::AnomalySeverity) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>The severity of the anomaly. The severity of anomalies that generate an insight determine that insight's severity. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
        pub fn set_severity(
            mut self,
            input: std::option::Option<crate::model::AnomalySeverity>,
        ) -> Self {
            self.severity = input;
            self
        }
        /// <p>The status of the anomaly.</p>
        pub fn status(mut self, input: crate::model::AnomalyStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the anomaly.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AnomalyStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> The time of the anomaly's most recent update. </p>
        pub fn update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p> The time of the anomaly's most recent update. </p>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// <p> A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from <code>AnomalyReportedTimeRange</code>, which specifies the time range when DevOps Guru opens and then closes an anomaly. </p>
        pub fn anomaly_time_range(mut self, input: crate::model::AnomalyTimeRange) -> Self {
            self.anomaly_time_range = Some(input);
            self
        }
        /// <p> A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from <code>AnomalyReportedTimeRange</code>, which specifies the time range when DevOps Guru opens and then closes an anomaly. </p>
        pub fn set_anomaly_time_range(
            mut self,
            input: std::option::Option<crate::model::AnomalyTimeRange>,
        ) -> Self {
            self.anomaly_time_range = input;
            self
        }
        /// <p> An <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed. </p>
        pub fn anomaly_reported_time_range(
            mut self,
            input: crate::model::AnomalyReportedTimeRange,
        ) -> Self {
            self.anomaly_reported_time_range = Some(input);
            self
        }
        /// <p> An <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed. </p>
        pub fn set_anomaly_reported_time_range(
            mut self,
            input: std::option::Option<crate::model::AnomalyReportedTimeRange>,
        ) -> Self {
            self.anomaly_reported_time_range = input;
            self
        }
        /// <p> The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur. </p>
        pub fn prediction_time_range(mut self, input: crate::model::PredictionTimeRange) -> Self {
            self.prediction_time_range = Some(input);
            self
        }
        /// <p> The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur. </p>
        pub fn set_prediction_time_range(
            mut self,
            input: std::option::Option<crate::model::PredictionTimeRange>,
        ) -> Self {
            self.prediction_time_range = input;
            self
        }
        /// <p> Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics. </p>
        pub fn source_details(mut self, input: crate::model::AnomalySourceDetails) -> Self {
            self.source_details = Some(input);
            self
        }
        /// <p> Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics. </p>
        pub fn set_source_details(
            mut self,
            input: std::option::Option<crate::model::AnomalySourceDetails>,
        ) -> Self {
            self.source_details = input;
            self
        }
        /// <p> The ID of the insight that contains this anomaly. An insight is composed of related anomalies. </p>
        pub fn associated_insight_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.associated_insight_id = Some(input.into());
            self
        }
        /// <p> The ID of the insight that contains this anomaly. An insight is composed of related anomalies. </p>
        pub fn set_associated_insight_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.associated_insight_id = input;
            self
        }
        /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn resource_collection(mut self, input: crate::model::ResourceCollection) -> Self {
            self.resource_collection = Some(input);
            self
        }
        /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn set_resource_collection(
            mut self,
            input: std::option::Option<crate::model::ResourceCollection>,
        ) -> Self {
            self.resource_collection = input;
            self
        }
        /// <p> A threshold that was exceeded by behavior in analyzed resources. Exceeding this threshold is related to the anomalous behavior that generated this anomaly. </p>
        pub fn limit(mut self, input: f64) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p> A threshold that was exceeded by behavior in analyzed resources. Exceeding this threshold is related to the anomalous behavior that generated this anomaly. </p>
        pub fn set_limit(mut self, input: std::option::Option<f64>) -> Self {
            self.limit = input;
            self
        }
        /// <p>Returns the metadata of the source.</p>
        pub fn source_metadata(mut self, input: crate::model::AnomalySourceMetadata) -> Self {
            self.source_metadata = Some(input);
            self
        }
        /// <p>Returns the metadata of the source.</p>
        pub fn set_source_metadata(
            mut self,
            input: std::option::Option<crate::model::AnomalySourceMetadata>,
        ) -> Self {
            self.source_metadata = input;
            self
        }
        /// Appends an item to `anomaly_resources`.
        ///
        /// To override the contents of this collection use [`set_anomaly_resources`](Self::set_anomaly_resources).
        ///
        /// <p>Information about a resource in which DevOps Guru detected anomalous behavior.</p>
        pub fn anomaly_resources(mut self, input: crate::model::AnomalyResource) -> Self {
            let mut v = self.anomaly_resources.unwrap_or_default();
            v.push(input);
            self.anomaly_resources = Some(v);
            self
        }
        /// <p>Information about a resource in which DevOps Guru detected anomalous behavior.</p>
        pub fn set_anomaly_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AnomalyResource>>,
        ) -> Self {
            self.anomaly_resources = input;
            self
        }
        /// Consumes the builder and constructs a [`ProactiveAnomalySummary`](crate::model::ProactiveAnomalySummary)
        pub fn build(self) -> crate::model::ProactiveAnomalySummary {
            crate::model::ProactiveAnomalySummary {
                id: self.id,
                severity: self.severity,
                status: self.status,
                update_time: self.update_time,
                anomaly_time_range: self.anomaly_time_range,
                anomaly_reported_time_range: self.anomaly_reported_time_range,
                prediction_time_range: self.prediction_time_range,
                source_details: self.source_details,
                associated_insight_id: self.associated_insight_id,
                resource_collection: self.resource_collection,
                limit: self.limit,
                source_metadata: self.source_metadata,
                anomaly_resources: self.anomaly_resources,
            }
        }
    }
}
impl ProactiveAnomalySummary {
    /// Creates a new builder-style object to manufacture [`ProactiveAnomalySummary`](crate::model::ProactiveAnomalySummary)
    pub fn builder() -> crate::model::proactive_anomaly_summary::Builder {
        crate::model::proactive_anomaly_summary::Builder::default()
    }
}

/// <p>Metadata about an anomaly. The anomaly is detected using analysis of the metric data  over a period of time</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnomalySourceMetadata {
    /// <p>The source of the anomaly.</p>
    pub source: std::option::Option<std::string::String>,
    /// <p>The name of the anomaly's resource.</p>
    pub source_resource_name: std::option::Option<std::string::String>,
    /// <p>The anomaly's resource type.</p>
    pub source_resource_type: std::option::Option<std::string::String>,
}
impl AnomalySourceMetadata {
    /// <p>The source of the anomaly.</p>
    pub fn source(&self) -> std::option::Option<&str> {
        self.source.as_deref()
    }
    /// <p>The name of the anomaly's resource.</p>
    pub fn source_resource_name(&self) -> std::option::Option<&str> {
        self.source_resource_name.as_deref()
    }
    /// <p>The anomaly's resource type.</p>
    pub fn source_resource_type(&self) -> std::option::Option<&str> {
        self.source_resource_type.as_deref()
    }
}
impl std::fmt::Debug for AnomalySourceMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnomalySourceMetadata");
        formatter.field("source", &self.source);
        formatter.field("source_resource_name", &self.source_resource_name);
        formatter.field("source_resource_type", &self.source_resource_type);
        formatter.finish()
    }
}
/// See [`AnomalySourceMetadata`](crate::model::AnomalySourceMetadata)
pub mod anomaly_source_metadata {
    /// A builder for [`AnomalySourceMetadata`](crate::model::AnomalySourceMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) source_resource_name: std::option::Option<std::string::String>,
        pub(crate) source_resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The source of the anomaly.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>The source of the anomaly.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// <p>The name of the anomaly's resource.</p>
        pub fn source_resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_resource_name = Some(input.into());
            self
        }
        /// <p>The name of the anomaly's resource.</p>
        pub fn set_source_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_resource_name = input;
            self
        }
        /// <p>The anomaly's resource type.</p>
        pub fn source_resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_resource_type = Some(input.into());
            self
        }
        /// <p>The anomaly's resource type.</p>
        pub fn set_source_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`AnomalySourceMetadata`](crate::model::AnomalySourceMetadata)
        pub fn build(self) -> crate::model::AnomalySourceMetadata {
            crate::model::AnomalySourceMetadata {
                source: self.source,
                source_resource_name: self.source_resource_name,
                source_resource_type: self.source_resource_type,
            }
        }
    }
}
impl AnomalySourceMetadata {
    /// Creates a new builder-style object to manufacture [`AnomalySourceMetadata`](crate::model::AnomalySourceMetadata)
    pub fn builder() -> crate::model::anomaly_source_metadata::Builder {
        crate::model::anomaly_source_metadata::Builder::default()
    }
}

/// <p> Information about a filter used to specify which Amazon Web Services resources are analyzed for anomalous behavior by DevOps Guru. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceCollectionFilter {
    /// <p> Information about Amazon Web Services CloudFormation stacks. You can use up to 500 stacks to specify which Amazon Web Services resources in your account to analyze. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a> in the <i>Amazon Web Services CloudFormation User Guide</i>. </p>
    pub cloud_formation: std::option::Option<crate::model::CloudFormationCollectionFilter>,
    /// <p>The Amazon Web Services tags used to filter the resources in the resource collection.</p>
    /// <p>Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an Lambda function. For more information about using tags, see the <a href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best practices</a> whitepaper. </p>
    /// <p>Each Amazon Web Services tag has two parts. </p>
    /// <ul>
    /// <li> <p>A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag <i>keys</i> are case-sensitive.</p> </li>
    /// <li> <p>An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.</p> </li>
    /// </ul>
    /// <p>Together these are known as <i>key</i>-<i>value</i> pairs.</p> <important>
    /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
    /// </important>
    pub tags: std::option::Option<std::vec::Vec<crate::model::TagCollectionFilter>>,
}
impl ResourceCollectionFilter {
    /// <p> Information about Amazon Web Services CloudFormation stacks. You can use up to 500 stacks to specify which Amazon Web Services resources in your account to analyze. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a> in the <i>Amazon Web Services CloudFormation User Guide</i>. </p>
    pub fn cloud_formation(
        &self,
    ) -> std::option::Option<&crate::model::CloudFormationCollectionFilter> {
        self.cloud_formation.as_ref()
    }
    /// <p>The Amazon Web Services tags used to filter the resources in the resource collection.</p>
    /// <p>Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an Lambda function. For more information about using tags, see the <a href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best practices</a> whitepaper. </p>
    /// <p>Each Amazon Web Services tag has two parts. </p>
    /// <ul>
    /// <li> <p>A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag <i>keys</i> are case-sensitive.</p> </li>
    /// <li> <p>An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.</p> </li>
    /// </ul>
    /// <p>Together these are known as <i>key</i>-<i>value</i> pairs.</p> <important>
    /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
    /// </important>
    pub fn tags(&self) -> std::option::Option<&[crate::model::TagCollectionFilter]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ResourceCollectionFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceCollectionFilter");
        formatter.field("cloud_formation", &self.cloud_formation);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ResourceCollectionFilter`](crate::model::ResourceCollectionFilter)
pub mod resource_collection_filter {
    /// A builder for [`ResourceCollectionFilter`](crate::model::ResourceCollectionFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_formation:
            std::option::Option<crate::model::CloudFormationCollectionFilter>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::TagCollectionFilter>>,
    }
    impl Builder {
        /// <p> Information about Amazon Web Services CloudFormation stacks. You can use up to 500 stacks to specify which Amazon Web Services resources in your account to analyze. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a> in the <i>Amazon Web Services CloudFormation User Guide</i>. </p>
        pub fn cloud_formation(
            mut self,
            input: crate::model::CloudFormationCollectionFilter,
        ) -> Self {
            self.cloud_formation = Some(input);
            self
        }
        /// <p> Information about Amazon Web Services CloudFormation stacks. You can use up to 500 stacks to specify which Amazon Web Services resources in your account to analyze. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a> in the <i>Amazon Web Services CloudFormation User Guide</i>. </p>
        pub fn set_cloud_formation(
            mut self,
            input: std::option::Option<crate::model::CloudFormationCollectionFilter>,
        ) -> Self {
            self.cloud_formation = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The Amazon Web Services tags used to filter the resources in the resource collection.</p>
        /// <p>Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an Lambda function. For more information about using tags, see the <a href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best practices</a> whitepaper. </p>
        /// <p>Each Amazon Web Services tag has two parts. </p>
        /// <ul>
        /// <li> <p>A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag <i>keys</i> are case-sensitive.</p> </li>
        /// <li> <p>An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.</p> </li>
        /// </ul>
        /// <p>Together these are known as <i>key</i>-<i>value</i> pairs.</p> <important>
        /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
        /// </important>
        pub fn tags(mut self, input: crate::model::TagCollectionFilter) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The Amazon Web Services tags used to filter the resources in the resource collection.</p>
        /// <p>Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an Lambda function. For more information about using tags, see the <a href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best practices</a> whitepaper. </p>
        /// <p>Each Amazon Web Services tag has two parts. </p>
        /// <ul>
        /// <li> <p>A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag <i>keys</i> are case-sensitive.</p> </li>
        /// <li> <p>An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.</p> </li>
        /// </ul>
        /// <p>Together these are known as <i>key</i>-<i>value</i> pairs.</p> <important>
        /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
        /// </important>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagCollectionFilter>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceCollectionFilter`](crate::model::ResourceCollectionFilter)
        pub fn build(self) -> crate::model::ResourceCollectionFilter {
            crate::model::ResourceCollectionFilter {
                cloud_formation: self.cloud_formation,
                tags: self.tags,
            }
        }
    }
}
impl ResourceCollectionFilter {
    /// Creates a new builder-style object to manufacture [`ResourceCollectionFilter`](crate::model::ResourceCollectionFilter)
    pub fn builder() -> crate::model::resource_collection_filter::Builder {
        crate::model::resource_collection_filter::Builder::default()
    }
}

/// <p>A collection of Amazon Web Services tags used to filter insights. This is used to return insights generated from only resources that contain the tags in the tag collection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagCollectionFilter {
    /// <p>An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this <i>key</i> make up your DevOps Guru application and analysis boundary.</p> <important>
    /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
    /// </important>
    pub app_boundary_key: std::option::Option<std::string::String>,
    /// <p>The values in an Amazon Web Services tag collection.</p>
    /// <p>The tag's <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and <i>value</i> are the tag's <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of 256 characters for a tag value.</p>
    pub tag_values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl TagCollectionFilter {
    /// <p>An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this <i>key</i> make up your DevOps Guru application and analysis boundary.</p> <important>
    /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
    /// </important>
    pub fn app_boundary_key(&self) -> std::option::Option<&str> {
        self.app_boundary_key.as_deref()
    }
    /// <p>The values in an Amazon Web Services tag collection.</p>
    /// <p>The tag's <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and <i>value</i> are the tag's <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of 256 characters for a tag value.</p>
    pub fn tag_values(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_values.as_deref()
    }
}
impl std::fmt::Debug for TagCollectionFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagCollectionFilter");
        formatter.field("app_boundary_key", &self.app_boundary_key);
        formatter.field("tag_values", &self.tag_values);
        formatter.finish()
    }
}
/// See [`TagCollectionFilter`](crate::model::TagCollectionFilter)
pub mod tag_collection_filter {
    /// A builder for [`TagCollectionFilter`](crate::model::TagCollectionFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_boundary_key: std::option::Option<std::string::String>,
        pub(crate) tag_values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this <i>key</i> make up your DevOps Guru application and analysis boundary.</p> <important>
        /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
        /// </important>
        pub fn app_boundary_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_boundary_key = Some(input.into());
            self
        }
        /// <p>An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this <i>key</i> make up your DevOps Guru application and analysis boundary.</p> <important>
        /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
        /// </important>
        pub fn set_app_boundary_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_boundary_key = input;
            self
        }
        /// Appends an item to `tag_values`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>The values in an Amazon Web Services tag collection.</p>
        /// <p>The tag's <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and <i>value</i> are the tag's <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of 256 characters for a tag value.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_values.unwrap_or_default();
            v.push(input.into());
            self.tag_values = Some(v);
            self
        }
        /// <p>The values in an Amazon Web Services tag collection.</p>
        /// <p>The tag's <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and <i>value</i> are the tag's <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of 256 characters for a tag value.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_values = input;
            self
        }
        /// Consumes the builder and constructs a [`TagCollectionFilter`](crate::model::TagCollectionFilter)
        pub fn build(self) -> crate::model::TagCollectionFilter {
            crate::model::TagCollectionFilter {
                app_boundary_key: self.app_boundary_key,
                tag_values: self.tag_values,
            }
        }
    }
}
impl TagCollectionFilter {
    /// Creates a new builder-style object to manufacture [`TagCollectionFilter`](crate::model::TagCollectionFilter)
    pub fn builder() -> crate::model::tag_collection_filter::Builder {
        crate::model::tag_collection_filter::Builder::default()
    }
}

/// <p> Information about Amazon Web Services CloudFormation stacks. You can use up to 500 stacks to specify which Amazon Web Services resources in your account to analyze. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a> in the <i>Amazon Web Services CloudFormation User Guide</i>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudFormationCollectionFilter {
    /// <p> An array of CloudFormation stack names. </p>
    pub stack_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CloudFormationCollectionFilter {
    /// <p> An array of CloudFormation stack names. </p>
    pub fn stack_names(&self) -> std::option::Option<&[std::string::String]> {
        self.stack_names.as_deref()
    }
}
impl std::fmt::Debug for CloudFormationCollectionFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudFormationCollectionFilter");
        formatter.field("stack_names", &self.stack_names);
        formatter.finish()
    }
}
/// See [`CloudFormationCollectionFilter`](crate::model::CloudFormationCollectionFilter)
pub mod cloud_formation_collection_filter {
    /// A builder for [`CloudFormationCollectionFilter`](crate::model::CloudFormationCollectionFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `stack_names`.
        ///
        /// To override the contents of this collection use [`set_stack_names`](Self::set_stack_names).
        ///
        /// <p> An array of CloudFormation stack names. </p>
        pub fn stack_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.stack_names.unwrap_or_default();
            v.push(input.into());
            self.stack_names = Some(v);
            self
        }
        /// <p> An array of CloudFormation stack names. </p>
        pub fn set_stack_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.stack_names = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudFormationCollectionFilter`](crate::model::CloudFormationCollectionFilter)
        pub fn build(self) -> crate::model::CloudFormationCollectionFilter {
            crate::model::CloudFormationCollectionFilter {
                stack_names: self.stack_names,
            }
        }
    }
}
impl CloudFormationCollectionFilter {
    /// Creates a new builder-style object to manufacture [`CloudFormationCollectionFilter`](crate::model::CloudFormationCollectionFilter)
    pub fn builder() -> crate::model::cloud_formation_collection_filter::Builder {
        crate::model::cloud_formation_collection_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceCollectionType {
    #[allow(missing_docs)] // documentation missing in model
    AwsCloudFormation,
    #[allow(missing_docs)] // documentation missing in model
    AwsService,
    #[allow(missing_docs)] // documentation missing in model
    AwsTags,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceCollectionType {
    fn from(s: &str) -> Self {
        match s {
            "AWS_CLOUD_FORMATION" => ResourceCollectionType::AwsCloudFormation,
            "AWS_SERVICE" => ResourceCollectionType::AwsService,
            "AWS_TAGS" => ResourceCollectionType::AwsTags,
            other => ResourceCollectionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceCollectionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceCollectionType::from(s))
    }
}
impl ResourceCollectionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceCollectionType::AwsCloudFormation => "AWS_CLOUD_FORMATION",
            ResourceCollectionType::AwsService => "AWS_SERVICE",
            ResourceCollectionType::AwsTags => "AWS_TAGS",
            ResourceCollectionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS_CLOUD_FORMATION", "AWS_SERVICE", "AWS_TAGS"]
    }
}
impl AsRef<str> for ResourceCollectionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The time range of a cost estimation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CostEstimationTimeRange {
    /// <p>The start time of the cost estimation.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The end time of the cost estimation.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl CostEstimationTimeRange {
    /// <p>The start time of the cost estimation.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The end time of the cost estimation.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
}
impl std::fmt::Debug for CostEstimationTimeRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CostEstimationTimeRange");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.finish()
    }
}
/// See [`CostEstimationTimeRange`](crate::model::CostEstimationTimeRange)
pub mod cost_estimation_time_range {
    /// A builder for [`CostEstimationTimeRange`](crate::model::CostEstimationTimeRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The start time of the cost estimation.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start time of the cost estimation.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end time of the cost estimation.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end time of the cost estimation.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`CostEstimationTimeRange`](crate::model::CostEstimationTimeRange)
        pub fn build(self) -> crate::model::CostEstimationTimeRange {
            crate::model::CostEstimationTimeRange {
                start_time: self.start_time,
                end_time: self.end_time,
            }
        }
    }
}
impl CostEstimationTimeRange {
    /// Creates a new builder-style object to manufacture [`CostEstimationTimeRange`](crate::model::CostEstimationTimeRange)
    pub fn builder() -> crate::model::cost_estimation_time_range::Builder {
        crate::model::cost_estimation_time_range::Builder::default()
    }
}

/// <p>An object that contains information about the estimated monthly cost to analyze an Amazon Web Services resource. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html">Estimate your Amazon DevOps Guru costs</a> and <a href="http://aws.amazon.com/devops-guru/pricing/">Amazon DevOps Guru pricing</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceResourceCost {
    /// <p>The type of the Amazon Web Services resource.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The state of the resource. The resource is <code>ACTIVE</code> if it produces metrics, events, or logs within an hour, otherwise it is <code>INACTIVE</code>. You pay for the number of active Amazon Web Services resource hours analyzed for each resource. Inactive resources are not charged. </p>
    pub state: std::option::Option<crate::model::CostEstimationServiceResourceState>,
    /// <p>The number of active resources analyzed for this service to create a monthly cost estimate.</p>
    pub count: i32,
    /// <p>The price per hour to analyze the resources in the service. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html">Estimate your Amazon DevOps Guru costs</a> and <a href="http://aws.amazon.com/devops-guru/pricing/">Amazon DevOps Guru pricing</a>.</p>
    pub unit_cost: f64,
    /// <p>The total estimated monthly cost to analyze the active resources for this resource.</p>
    pub cost: f64,
}
impl ServiceResourceCost {
    /// <p>The type of the Amazon Web Services resource.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The state of the resource. The resource is <code>ACTIVE</code> if it produces metrics, events, or logs within an hour, otherwise it is <code>INACTIVE</code>. You pay for the number of active Amazon Web Services resource hours analyzed for each resource. Inactive resources are not charged. </p>
    pub fn state(&self) -> std::option::Option<&crate::model::CostEstimationServiceResourceState> {
        self.state.as_ref()
    }
    /// <p>The number of active resources analyzed for this service to create a monthly cost estimate.</p>
    pub fn count(&self) -> i32 {
        self.count
    }
    /// <p>The price per hour to analyze the resources in the service. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html">Estimate your Amazon DevOps Guru costs</a> and <a href="http://aws.amazon.com/devops-guru/pricing/">Amazon DevOps Guru pricing</a>.</p>
    pub fn unit_cost(&self) -> f64 {
        self.unit_cost
    }
    /// <p>The total estimated monthly cost to analyze the active resources for this resource.</p>
    pub fn cost(&self) -> f64 {
        self.cost
    }
}
impl std::fmt::Debug for ServiceResourceCost {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceResourceCost");
        formatter.field("r#type", &self.r#type);
        formatter.field("state", &self.state);
        formatter.field("count", &self.count);
        formatter.field("unit_cost", &self.unit_cost);
        formatter.field("cost", &self.cost);
        formatter.finish()
    }
}
/// See [`ServiceResourceCost`](crate::model::ServiceResourceCost)
pub mod service_resource_cost {
    /// A builder for [`ServiceResourceCost`](crate::model::ServiceResourceCost)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::CostEstimationServiceResourceState>,
        pub(crate) count: std::option::Option<i32>,
        pub(crate) unit_cost: std::option::Option<f64>,
        pub(crate) cost: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The type of the Amazon Web Services resource.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of the Amazon Web Services resource.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The state of the resource. The resource is <code>ACTIVE</code> if it produces metrics, events, or logs within an hour, otherwise it is <code>INACTIVE</code>. You pay for the number of active Amazon Web Services resource hours analyzed for each resource. Inactive resources are not charged. </p>
        pub fn state(mut self, input: crate::model::CostEstimationServiceResourceState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the resource. The resource is <code>ACTIVE</code> if it produces metrics, events, or logs within an hour, otherwise it is <code>INACTIVE</code>. You pay for the number of active Amazon Web Services resource hours analyzed for each resource. Inactive resources are not charged. </p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::CostEstimationServiceResourceState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The number of active resources analyzed for this service to create a monthly cost estimate.</p>
        pub fn count(mut self, input: i32) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>The number of active resources analyzed for this service to create a monthly cost estimate.</p>
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.count = input;
            self
        }
        /// <p>The price per hour to analyze the resources in the service. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html">Estimate your Amazon DevOps Guru costs</a> and <a href="http://aws.amazon.com/devops-guru/pricing/">Amazon DevOps Guru pricing</a>.</p>
        pub fn unit_cost(mut self, input: f64) -> Self {
            self.unit_cost = Some(input);
            self
        }
        /// <p>The price per hour to analyze the resources in the service. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html">Estimate your Amazon DevOps Guru costs</a> and <a href="http://aws.amazon.com/devops-guru/pricing/">Amazon DevOps Guru pricing</a>.</p>
        pub fn set_unit_cost(mut self, input: std::option::Option<f64>) -> Self {
            self.unit_cost = input;
            self
        }
        /// <p>The total estimated monthly cost to analyze the active resources for this resource.</p>
        pub fn cost(mut self, input: f64) -> Self {
            self.cost = Some(input);
            self
        }
        /// <p>The total estimated monthly cost to analyze the active resources for this resource.</p>
        pub fn set_cost(mut self, input: std::option::Option<f64>) -> Self {
            self.cost = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceResourceCost`](crate::model::ServiceResourceCost)
        pub fn build(self) -> crate::model::ServiceResourceCost {
            crate::model::ServiceResourceCost {
                r#type: self.r#type,
                state: self.state,
                count: self.count.unwrap_or_default(),
                unit_cost: self.unit_cost.unwrap_or_default(),
                cost: self.cost.unwrap_or_default(),
            }
        }
    }
}
impl ServiceResourceCost {
    /// Creates a new builder-style object to manufacture [`ServiceResourceCost`](crate::model::ServiceResourceCost)
    pub fn builder() -> crate::model::service_resource_cost::Builder {
        crate::model::service_resource_cost::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CostEstimationServiceResourceState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CostEstimationServiceResourceState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => CostEstimationServiceResourceState::Active,
            "INACTIVE" => CostEstimationServiceResourceState::Inactive,
            other => CostEstimationServiceResourceState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CostEstimationServiceResourceState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CostEstimationServiceResourceState::from(s))
    }
}
impl CostEstimationServiceResourceState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CostEstimationServiceResourceState::Active => "ACTIVE",
            CostEstimationServiceResourceState::Inactive => "INACTIVE",
            CostEstimationServiceResourceState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "INACTIVE"]
    }
}
impl AsRef<str> for CostEstimationServiceResourceState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CostEstimationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Ongoing,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CostEstimationStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => CostEstimationStatus::Completed,
            "ONGOING" => CostEstimationStatus::Ongoing,
            other => CostEstimationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CostEstimationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CostEstimationStatus::from(s))
    }
}
impl CostEstimationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CostEstimationStatus::Completed => "COMPLETED",
            CostEstimationStatus::Ongoing => "ONGOING",
            CostEstimationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETED", "ONGOING"]
    }
}
impl AsRef<str> for CostEstimationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Information about the integration of DevOps Guru with another Amazon Web Services service, such as Amazon Web Services Systems Manager. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceIntegrationConfig {
    /// <p> Information about whether DevOps Guru is configured to create an OpsItem in Amazon Web Services Systems Manager OpsCenter for each created insight. </p>
    pub ops_center: std::option::Option<crate::model::OpsCenterIntegration>,
}
impl ServiceIntegrationConfig {
    /// <p> Information about whether DevOps Guru is configured to create an OpsItem in Amazon Web Services Systems Manager OpsCenter for each created insight. </p>
    pub fn ops_center(&self) -> std::option::Option<&crate::model::OpsCenterIntegration> {
        self.ops_center.as_ref()
    }
}
impl std::fmt::Debug for ServiceIntegrationConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceIntegrationConfig");
        formatter.field("ops_center", &self.ops_center);
        formatter.finish()
    }
}
/// See [`ServiceIntegrationConfig`](crate::model::ServiceIntegrationConfig)
pub mod service_integration_config {
    /// A builder for [`ServiceIntegrationConfig`](crate::model::ServiceIntegrationConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ops_center: std::option::Option<crate::model::OpsCenterIntegration>,
    }
    impl Builder {
        /// <p> Information about whether DevOps Guru is configured to create an OpsItem in Amazon Web Services Systems Manager OpsCenter for each created insight. </p>
        pub fn ops_center(mut self, input: crate::model::OpsCenterIntegration) -> Self {
            self.ops_center = Some(input);
            self
        }
        /// <p> Information about whether DevOps Guru is configured to create an OpsItem in Amazon Web Services Systems Manager OpsCenter for each created insight. </p>
        pub fn set_ops_center(
            mut self,
            input: std::option::Option<crate::model::OpsCenterIntegration>,
        ) -> Self {
            self.ops_center = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceIntegrationConfig`](crate::model::ServiceIntegrationConfig)
        pub fn build(self) -> crate::model::ServiceIntegrationConfig {
            crate::model::ServiceIntegrationConfig {
                ops_center: self.ops_center,
            }
        }
    }
}
impl ServiceIntegrationConfig {
    /// Creates a new builder-style object to manufacture [`ServiceIntegrationConfig`](crate::model::ServiceIntegrationConfig)
    pub fn builder() -> crate::model::service_integration_config::Builder {
        crate::model::service_integration_config::Builder::default()
    }
}

/// <p> Information about whether DevOps Guru is configured to create an OpsItem in Amazon Web Services Systems Manager OpsCenter for each created insight. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpsCenterIntegration {
    /// <p> Specifies if DevOps Guru is enabled to create an Amazon Web Services Systems Manager OpsItem for each created insight. </p>
    pub opt_in_status: std::option::Option<crate::model::OptInStatus>,
}
impl OpsCenterIntegration {
    /// <p> Specifies if DevOps Guru is enabled to create an Amazon Web Services Systems Manager OpsItem for each created insight. </p>
    pub fn opt_in_status(&self) -> std::option::Option<&crate::model::OptInStatus> {
        self.opt_in_status.as_ref()
    }
}
impl std::fmt::Debug for OpsCenterIntegration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpsCenterIntegration");
        formatter.field("opt_in_status", &self.opt_in_status);
        formatter.finish()
    }
}
/// See [`OpsCenterIntegration`](crate::model::OpsCenterIntegration)
pub mod ops_center_integration {
    /// A builder for [`OpsCenterIntegration`](crate::model::OpsCenterIntegration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) opt_in_status: std::option::Option<crate::model::OptInStatus>,
    }
    impl Builder {
        /// <p> Specifies if DevOps Guru is enabled to create an Amazon Web Services Systems Manager OpsItem for each created insight. </p>
        pub fn opt_in_status(mut self, input: crate::model::OptInStatus) -> Self {
            self.opt_in_status = Some(input);
            self
        }
        /// <p> Specifies if DevOps Guru is enabled to create an Amazon Web Services Systems Manager OpsItem for each created insight. </p>
        pub fn set_opt_in_status(
            mut self,
            input: std::option::Option<crate::model::OptInStatus>,
        ) -> Self {
            self.opt_in_status = input;
            self
        }
        /// Consumes the builder and constructs a [`OpsCenterIntegration`](crate::model::OpsCenterIntegration)
        pub fn build(self) -> crate::model::OpsCenterIntegration {
            crate::model::OpsCenterIntegration {
                opt_in_status: self.opt_in_status,
            }
        }
    }
}
impl OpsCenterIntegration {
    /// Creates a new builder-style object to manufacture [`OpsCenterIntegration`](crate::model::OpsCenterIntegration)
    pub fn builder() -> crate::model::ops_center_integration::Builder {
        crate::model::ops_center_integration::Builder::default()
    }
}

/// <p> Information about the health of Amazon Web Services resources in your account that are specified by an Amazon Web Services tag <i>key</i>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagHealth {
    /// <p>An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this <i>key</i> make up your DevOps Guru application and analysis boundary.</p> <important>
    /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
    /// </important>
    pub app_boundary_key: std::option::Option<std::string::String>,
    /// <p>The value in an Amazon Web Services tag.</p>
    /// <p>The tag's <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and <i>value</i> are the tag's <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of 256 characters for a tag value.</p>
    pub tag_value: std::option::Option<std::string::String>,
    /// <p>Information about the health of the Amazon Web Services resources in your account that are specified by an Amazon Web Services tag, including the number of open proactive, open reactive insights, and the Mean Time to Recover (MTTR) of closed insights. </p>
    pub insight: std::option::Option<crate::model::InsightHealth>,
}
impl TagHealth {
    /// <p>An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this <i>key</i> make up your DevOps Guru application and analysis boundary.</p> <important>
    /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
    /// </important>
    pub fn app_boundary_key(&self) -> std::option::Option<&str> {
        self.app_boundary_key.as_deref()
    }
    /// <p>The value in an Amazon Web Services tag.</p>
    /// <p>The tag's <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and <i>value</i> are the tag's <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of 256 characters for a tag value.</p>
    pub fn tag_value(&self) -> std::option::Option<&str> {
        self.tag_value.as_deref()
    }
    /// <p>Information about the health of the Amazon Web Services resources in your account that are specified by an Amazon Web Services tag, including the number of open proactive, open reactive insights, and the Mean Time to Recover (MTTR) of closed insights. </p>
    pub fn insight(&self) -> std::option::Option<&crate::model::InsightHealth> {
        self.insight.as_ref()
    }
}
impl std::fmt::Debug for TagHealth {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagHealth");
        formatter.field("app_boundary_key", &self.app_boundary_key);
        formatter.field("tag_value", &self.tag_value);
        formatter.field("insight", &self.insight);
        formatter.finish()
    }
}
/// See [`TagHealth`](crate::model::TagHealth)
pub mod tag_health {
    /// A builder for [`TagHealth`](crate::model::TagHealth)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_boundary_key: std::option::Option<std::string::String>,
        pub(crate) tag_value: std::option::Option<std::string::String>,
        pub(crate) insight: std::option::Option<crate::model::InsightHealth>,
    }
    impl Builder {
        /// <p>An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this <i>key</i> make up your DevOps Guru application and analysis boundary.</p> <important>
        /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
        /// </important>
        pub fn app_boundary_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_boundary_key = Some(input.into());
            self
        }
        /// <p>An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this <i>key</i> make up your DevOps Guru application and analysis boundary.</p> <important>
        /// <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>
        /// </important>
        pub fn set_app_boundary_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_boundary_key = input;
            self
        }
        /// <p>The value in an Amazon Web Services tag.</p>
        /// <p>The tag's <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and <i>value</i> are the tag's <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of 256 characters for a tag value.</p>
        pub fn tag_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.tag_value = Some(input.into());
            self
        }
        /// <p>The value in an Amazon Web Services tag.</p>
        /// <p>The tag's <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and <i>value</i> are the tag's <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of 256 characters for a tag value.</p>
        pub fn set_tag_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tag_value = input;
            self
        }
        /// <p>Information about the health of the Amazon Web Services resources in your account that are specified by an Amazon Web Services tag, including the number of open proactive, open reactive insights, and the Mean Time to Recover (MTTR) of closed insights. </p>
        pub fn insight(mut self, input: crate::model::InsightHealth) -> Self {
            self.insight = Some(input);
            self
        }
        /// <p>Information about the health of the Amazon Web Services resources in your account that are specified by an Amazon Web Services tag, including the number of open proactive, open reactive insights, and the Mean Time to Recover (MTTR) of closed insights. </p>
        pub fn set_insight(
            mut self,
            input: std::option::Option<crate::model::InsightHealth>,
        ) -> Self {
            self.insight = input;
            self
        }
        /// Consumes the builder and constructs a [`TagHealth`](crate::model::TagHealth)
        pub fn build(self) -> crate::model::TagHealth {
            crate::model::TagHealth {
                app_boundary_key: self.app_boundary_key,
                tag_value: self.tag_value,
                insight: self.insight,
            }
        }
    }
}
impl TagHealth {
    /// Creates a new builder-style object to manufacture [`TagHealth`](crate::model::TagHealth)
    pub fn builder() -> crate::model::tag_health::Builder {
        crate::model::tag_health::Builder::default()
    }
}

/// <p> Information about the number of open reactive and proactive insights that can be used to gauge the health of your system. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsightHealth {
    /// <p> The number of open proactive insights. </p>
    pub open_proactive_insights: i32,
    /// <p> The number of open reactive insights. </p>
    pub open_reactive_insights: i32,
    /// <p> The Meant Time to Recover (MTTR) for the insight. </p>
    pub mean_time_to_recover_in_milliseconds: std::option::Option<i64>,
}
impl InsightHealth {
    /// <p> The number of open proactive insights. </p>
    pub fn open_proactive_insights(&self) -> i32 {
        self.open_proactive_insights
    }
    /// <p> The number of open reactive insights. </p>
    pub fn open_reactive_insights(&self) -> i32 {
        self.open_reactive_insights
    }
    /// <p> The Meant Time to Recover (MTTR) for the insight. </p>
    pub fn mean_time_to_recover_in_milliseconds(&self) -> std::option::Option<i64> {
        self.mean_time_to_recover_in_milliseconds
    }
}
impl std::fmt::Debug for InsightHealth {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsightHealth");
        formatter.field("open_proactive_insights", &self.open_proactive_insights);
        formatter.field("open_reactive_insights", &self.open_reactive_insights);
        formatter.field(
            "mean_time_to_recover_in_milliseconds",
            &self.mean_time_to_recover_in_milliseconds,
        );
        formatter.finish()
    }
}
/// See [`InsightHealth`](crate::model::InsightHealth)
pub mod insight_health {
    /// A builder for [`InsightHealth`](crate::model::InsightHealth)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) open_proactive_insights: std::option::Option<i32>,
        pub(crate) open_reactive_insights: std::option::Option<i32>,
        pub(crate) mean_time_to_recover_in_milliseconds: std::option::Option<i64>,
    }
    impl Builder {
        /// <p> The number of open proactive insights. </p>
        pub fn open_proactive_insights(mut self, input: i32) -> Self {
            self.open_proactive_insights = Some(input);
            self
        }
        /// <p> The number of open proactive insights. </p>
        pub fn set_open_proactive_insights(mut self, input: std::option::Option<i32>) -> Self {
            self.open_proactive_insights = input;
            self
        }
        /// <p> The number of open reactive insights. </p>
        pub fn open_reactive_insights(mut self, input: i32) -> Self {
            self.open_reactive_insights = Some(input);
            self
        }
        /// <p> The number of open reactive insights. </p>
        pub fn set_open_reactive_insights(mut self, input: std::option::Option<i32>) -> Self {
            self.open_reactive_insights = input;
            self
        }
        /// <p> The Meant Time to Recover (MTTR) for the insight. </p>
        pub fn mean_time_to_recover_in_milliseconds(mut self, input: i64) -> Self {
            self.mean_time_to_recover_in_milliseconds = Some(input);
            self
        }
        /// <p> The Meant Time to Recover (MTTR) for the insight. </p>
        pub fn set_mean_time_to_recover_in_milliseconds(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.mean_time_to_recover_in_milliseconds = input;
            self
        }
        /// Consumes the builder and constructs a [`InsightHealth`](crate::model::InsightHealth)
        pub fn build(self) -> crate::model::InsightHealth {
            crate::model::InsightHealth {
                open_proactive_insights: self.open_proactive_insights.unwrap_or_default(),
                open_reactive_insights: self.open_reactive_insights.unwrap_or_default(),
                mean_time_to_recover_in_milliseconds: self.mean_time_to_recover_in_milliseconds,
            }
        }
    }
}
impl InsightHealth {
    /// Creates a new builder-style object to manufacture [`InsightHealth`](crate::model::InsightHealth)
    pub fn builder() -> crate::model::insight_health::Builder {
        crate::model::insight_health::Builder::default()
    }
}

/// <p>Represents the health of an Amazon Web Services service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceHealth {
    /// <p>The name of the Amazon Web Services service.</p>
    pub service_name: std::option::Option<crate::model::ServiceName>,
    /// <p>Represents the health of an Amazon Web Services service. This is a <code>ServiceInsightHealth</code> that contains the number of open proactive and reactive insights for this service.</p>
    pub insight: std::option::Option<crate::model::ServiceInsightHealth>,
}
impl ServiceHealth {
    /// <p>The name of the Amazon Web Services service.</p>
    pub fn service_name(&self) -> std::option::Option<&crate::model::ServiceName> {
        self.service_name.as_ref()
    }
    /// <p>Represents the health of an Amazon Web Services service. This is a <code>ServiceInsightHealth</code> that contains the number of open proactive and reactive insights for this service.</p>
    pub fn insight(&self) -> std::option::Option<&crate::model::ServiceInsightHealth> {
        self.insight.as_ref()
    }
}
impl std::fmt::Debug for ServiceHealth {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceHealth");
        formatter.field("service_name", &self.service_name);
        formatter.field("insight", &self.insight);
        formatter.finish()
    }
}
/// See [`ServiceHealth`](crate::model::ServiceHealth)
pub mod service_health {
    /// A builder for [`ServiceHealth`](crate::model::ServiceHealth)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_name: std::option::Option<crate::model::ServiceName>,
        pub(crate) insight: std::option::Option<crate::model::ServiceInsightHealth>,
    }
    impl Builder {
        /// <p>The name of the Amazon Web Services service.</p>
        pub fn service_name(mut self, input: crate::model::ServiceName) -> Self {
            self.service_name = Some(input);
            self
        }
        /// <p>The name of the Amazon Web Services service.</p>
        pub fn set_service_name(
            mut self,
            input: std::option::Option<crate::model::ServiceName>,
        ) -> Self {
            self.service_name = input;
            self
        }
        /// <p>Represents the health of an Amazon Web Services service. This is a <code>ServiceInsightHealth</code> that contains the number of open proactive and reactive insights for this service.</p>
        pub fn insight(mut self, input: crate::model::ServiceInsightHealth) -> Self {
            self.insight = Some(input);
            self
        }
        /// <p>Represents the health of an Amazon Web Services service. This is a <code>ServiceInsightHealth</code> that contains the number of open proactive and reactive insights for this service.</p>
        pub fn set_insight(
            mut self,
            input: std::option::Option<crate::model::ServiceInsightHealth>,
        ) -> Self {
            self.insight = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceHealth`](crate::model::ServiceHealth)
        pub fn build(self) -> crate::model::ServiceHealth {
            crate::model::ServiceHealth {
                service_name: self.service_name,
                insight: self.insight,
            }
        }
    }
}
impl ServiceHealth {
    /// Creates a new builder-style object to manufacture [`ServiceHealth`](crate::model::ServiceHealth)
    pub fn builder() -> crate::model::service_health::Builder {
        crate::model::service_health::Builder::default()
    }
}

/// <p>Contains the number of open proactive and reactive insights in an analyzed Amazon Web Services service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceInsightHealth {
    /// <p>The number of open proactive insights in the Amazon Web Services service</p>
    pub open_proactive_insights: i32,
    /// <p>The number of open reactive insights in the Amazon Web Services service</p>
    pub open_reactive_insights: i32,
}
impl ServiceInsightHealth {
    /// <p>The number of open proactive insights in the Amazon Web Services service</p>
    pub fn open_proactive_insights(&self) -> i32 {
        self.open_proactive_insights
    }
    /// <p>The number of open reactive insights in the Amazon Web Services service</p>
    pub fn open_reactive_insights(&self) -> i32 {
        self.open_reactive_insights
    }
}
impl std::fmt::Debug for ServiceInsightHealth {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceInsightHealth");
        formatter.field("open_proactive_insights", &self.open_proactive_insights);
        formatter.field("open_reactive_insights", &self.open_reactive_insights);
        formatter.finish()
    }
}
/// See [`ServiceInsightHealth`](crate::model::ServiceInsightHealth)
pub mod service_insight_health {
    /// A builder for [`ServiceInsightHealth`](crate::model::ServiceInsightHealth)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) open_proactive_insights: std::option::Option<i32>,
        pub(crate) open_reactive_insights: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The number of open proactive insights in the Amazon Web Services service</p>
        pub fn open_proactive_insights(mut self, input: i32) -> Self {
            self.open_proactive_insights = Some(input);
            self
        }
        /// <p>The number of open proactive insights in the Amazon Web Services service</p>
        pub fn set_open_proactive_insights(mut self, input: std::option::Option<i32>) -> Self {
            self.open_proactive_insights = input;
            self
        }
        /// <p>The number of open reactive insights in the Amazon Web Services service</p>
        pub fn open_reactive_insights(mut self, input: i32) -> Self {
            self.open_reactive_insights = Some(input);
            self
        }
        /// <p>The number of open reactive insights in the Amazon Web Services service</p>
        pub fn set_open_reactive_insights(mut self, input: std::option::Option<i32>) -> Self {
            self.open_reactive_insights = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceInsightHealth`](crate::model::ServiceInsightHealth)
        pub fn build(self) -> crate::model::ServiceInsightHealth {
            crate::model::ServiceInsightHealth {
                open_proactive_insights: self.open_proactive_insights.unwrap_or_default(),
                open_reactive_insights: self.open_reactive_insights.unwrap_or_default(),
            }
        }
    }
}
impl ServiceInsightHealth {
    /// Creates a new builder-style object to manufacture [`ServiceInsightHealth`](crate::model::ServiceInsightHealth)
    pub fn builder() -> crate::model::service_insight_health::Builder {
        crate::model::service_insight_health::Builder::default()
    }
}

/// <p> Information about the health of Amazon Web Services resources in your account that are specified by an Amazon Web Services CloudFormation stack. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudFormationHealth {
    /// <p> The name of the CloudFormation stack. </p>
    pub stack_name: std::option::Option<std::string::String>,
    /// <p> Information about the health of the Amazon Web Services resources in your account that are specified by an Amazon Web Services CloudFormation stack, including the number of open proactive, open reactive insights, and the Mean Time to Recover (MTTR) of closed insights. </p>
    pub insight: std::option::Option<crate::model::InsightHealth>,
}
impl CloudFormationHealth {
    /// <p> The name of the CloudFormation stack. </p>
    pub fn stack_name(&self) -> std::option::Option<&str> {
        self.stack_name.as_deref()
    }
    /// <p> Information about the health of the Amazon Web Services resources in your account that are specified by an Amazon Web Services CloudFormation stack, including the number of open proactive, open reactive insights, and the Mean Time to Recover (MTTR) of closed insights. </p>
    pub fn insight(&self) -> std::option::Option<&crate::model::InsightHealth> {
        self.insight.as_ref()
    }
}
impl std::fmt::Debug for CloudFormationHealth {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudFormationHealth");
        formatter.field("stack_name", &self.stack_name);
        formatter.field("insight", &self.insight);
        formatter.finish()
    }
}
/// See [`CloudFormationHealth`](crate::model::CloudFormationHealth)
pub mod cloud_formation_health {
    /// A builder for [`CloudFormationHealth`](crate::model::CloudFormationHealth)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) insight: std::option::Option<crate::model::InsightHealth>,
    }
    impl Builder {
        /// <p> The name of the CloudFormation stack. </p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p> The name of the CloudFormation stack. </p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p> Information about the health of the Amazon Web Services resources in your account that are specified by an Amazon Web Services CloudFormation stack, including the number of open proactive, open reactive insights, and the Mean Time to Recover (MTTR) of closed insights. </p>
        pub fn insight(mut self, input: crate::model::InsightHealth) -> Self {
            self.insight = Some(input);
            self
        }
        /// <p> Information about the health of the Amazon Web Services resources in your account that are specified by an Amazon Web Services CloudFormation stack, including the number of open proactive, open reactive insights, and the Mean Time to Recover (MTTR) of closed insights. </p>
        pub fn set_insight(
            mut self,
            input: std::option::Option<crate::model::InsightHealth>,
        ) -> Self {
            self.insight = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudFormationHealth`](crate::model::CloudFormationHealth)
        pub fn build(self) -> crate::model::CloudFormationHealth {
            crate::model::CloudFormationHealth {
                stack_name: self.stack_name,
                insight: self.insight,
            }
        }
    }
}
impl CloudFormationHealth {
    /// Creates a new builder-style object to manufacture [`CloudFormationHealth`](crate::model::CloudFormationHealth)
    pub fn builder() -> crate::model::cloud_formation_health::Builder {
        crate::model::cloud_formation_health::Builder::default()
    }
}

/// <p> Returns the number of open reactive insights, the number of open proactive insights, and the number of metrics analyzed in your Amazon Web Services account. Use these numbers to gauge the health of operations in your Amazon Web Services account. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountHealth {
    /// <p>The ID of the Amazon Web Services account. </p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p> Information about the health of the Amazon Web Services resources in your account, including the number of open proactive, open reactive insights, and the Mean Time to Recover (MTTR) of closed insights. </p>
    pub insight: std::option::Option<crate::model::AccountInsightHealth>,
}
impl AccountHealth {
    /// <p>The ID of the Amazon Web Services account. </p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p> Information about the health of the Amazon Web Services resources in your account, including the number of open proactive, open reactive insights, and the Mean Time to Recover (MTTR) of closed insights. </p>
    pub fn insight(&self) -> std::option::Option<&crate::model::AccountInsightHealth> {
        self.insight.as_ref()
    }
}
impl std::fmt::Debug for AccountHealth {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountHealth");
        formatter.field("account_id", &self.account_id);
        formatter.field("insight", &self.insight);
        formatter.finish()
    }
}
/// See [`AccountHealth`](crate::model::AccountHealth)
pub mod account_health {
    /// A builder for [`AccountHealth`](crate::model::AccountHealth)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) insight: std::option::Option<crate::model::AccountInsightHealth>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p> Information about the health of the Amazon Web Services resources in your account, including the number of open proactive, open reactive insights, and the Mean Time to Recover (MTTR) of closed insights. </p>
        pub fn insight(mut self, input: crate::model::AccountInsightHealth) -> Self {
            self.insight = Some(input);
            self
        }
        /// <p> Information about the health of the Amazon Web Services resources in your account, including the number of open proactive, open reactive insights, and the Mean Time to Recover (MTTR) of closed insights. </p>
        pub fn set_insight(
            mut self,
            input: std::option::Option<crate::model::AccountInsightHealth>,
        ) -> Self {
            self.insight = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountHealth`](crate::model::AccountHealth)
        pub fn build(self) -> crate::model::AccountHealth {
            crate::model::AccountHealth {
                account_id: self.account_id,
                insight: self.insight,
            }
        }
    }
}
impl AccountHealth {
    /// Creates a new builder-style object to manufacture [`AccountHealth`](crate::model::AccountHealth)
    pub fn builder() -> crate::model::account_health::Builder {
        crate::model::account_health::Builder::default()
    }
}

/// <p> Information about the number of open reactive and proactive insights that can be used to gauge the health of your system. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountInsightHealth {
    /// <p>An integer that specifies the number of open proactive insights in your Amazon Web Services account.</p>
    pub open_proactive_insights: i32,
    /// <p>An integer that specifies the number of open reactive insights in your Amazon Web Services account.</p>
    pub open_reactive_insights: i32,
}
impl AccountInsightHealth {
    /// <p>An integer that specifies the number of open proactive insights in your Amazon Web Services account.</p>
    pub fn open_proactive_insights(&self) -> i32 {
        self.open_proactive_insights
    }
    /// <p>An integer that specifies the number of open reactive insights in your Amazon Web Services account.</p>
    pub fn open_reactive_insights(&self) -> i32 {
        self.open_reactive_insights
    }
}
impl std::fmt::Debug for AccountInsightHealth {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountInsightHealth");
        formatter.field("open_proactive_insights", &self.open_proactive_insights);
        formatter.field("open_reactive_insights", &self.open_reactive_insights);
        formatter.finish()
    }
}
/// See [`AccountInsightHealth`](crate::model::AccountInsightHealth)
pub mod account_insight_health {
    /// A builder for [`AccountInsightHealth`](crate::model::AccountInsightHealth)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) open_proactive_insights: std::option::Option<i32>,
        pub(crate) open_reactive_insights: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>An integer that specifies the number of open proactive insights in your Amazon Web Services account.</p>
        pub fn open_proactive_insights(mut self, input: i32) -> Self {
            self.open_proactive_insights = Some(input);
            self
        }
        /// <p>An integer that specifies the number of open proactive insights in your Amazon Web Services account.</p>
        pub fn set_open_proactive_insights(mut self, input: std::option::Option<i32>) -> Self {
            self.open_proactive_insights = input;
            self
        }
        /// <p>An integer that specifies the number of open reactive insights in your Amazon Web Services account.</p>
        pub fn open_reactive_insights(mut self, input: i32) -> Self {
            self.open_reactive_insights = Some(input);
            self
        }
        /// <p>An integer that specifies the number of open reactive insights in your Amazon Web Services account.</p>
        pub fn set_open_reactive_insights(mut self, input: std::option::Option<i32>) -> Self {
            self.open_reactive_insights = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountInsightHealth`](crate::model::AccountInsightHealth)
        pub fn build(self) -> crate::model::AccountInsightHealth {
            crate::model::AccountInsightHealth {
                open_proactive_insights: self.open_proactive_insights.unwrap_or_default(),
                open_reactive_insights: self.open_reactive_insights.unwrap_or_default(),
            }
        }
    }
}
impl AccountInsightHealth {
    /// Creates a new builder-style object to manufacture [`AccountInsightHealth`](crate::model::AccountInsightHealth)
    pub fn builder() -> crate::model::account_insight_health::Builder {
        crate::model::account_insight_health::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OrganizationResourceCollectionType {
    #[allow(missing_docs)] // documentation missing in model
    AwsAccount,
    #[allow(missing_docs)] // documentation missing in model
    AwsCloudFormation,
    #[allow(missing_docs)] // documentation missing in model
    AwsService,
    #[allow(missing_docs)] // documentation missing in model
    AwsTags,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OrganizationResourceCollectionType {
    fn from(s: &str) -> Self {
        match s {
            "AWS_ACCOUNT" => OrganizationResourceCollectionType::AwsAccount,
            "AWS_CLOUD_FORMATION" => OrganizationResourceCollectionType::AwsCloudFormation,
            "AWS_SERVICE" => OrganizationResourceCollectionType::AwsService,
            "AWS_TAGS" => OrganizationResourceCollectionType::AwsTags,
            other => OrganizationResourceCollectionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OrganizationResourceCollectionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OrganizationResourceCollectionType::from(s))
    }
}
impl OrganizationResourceCollectionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OrganizationResourceCollectionType::AwsAccount => "AWS_ACCOUNT",
            OrganizationResourceCollectionType::AwsCloudFormation => "AWS_CLOUD_FORMATION",
            OrganizationResourceCollectionType::AwsService => "AWS_SERVICE",
            OrganizationResourceCollectionType::AwsTags => "AWS_TAGS",
            OrganizationResourceCollectionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AWS_ACCOUNT",
            "AWS_CLOUD_FORMATION",
            "AWS_SERVICE",
            "AWS_TAGS",
        ]
    }
}
impl AsRef<str> for OrganizationResourceCollectionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Information about a reactive insight. This object is returned by <code>ListInsights</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReactiveInsight {
    /// <p> The ID of a reactive insight. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p> The name of a reactive insight. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The severity of the insight. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
    pub severity: std::option::Option<crate::model::InsightSeverity>,
    /// <p> The status of a reactive insight. </p>
    pub status: std::option::Option<crate::model::InsightStatus>,
    /// <p> A time ranged that specifies when the observed behavior in an insight started and ended. </p>
    pub insight_time_range: std::option::Option<crate::model::InsightTimeRange>,
    /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub resource_collection: std::option::Option<crate::model::ResourceCollection>,
    /// <p> The ID of the Amazon Web Services System Manager OpsItem created for this insight. You must enable the creation of OpstItems insights before they are created for each insight. </p>
    pub ssm_ops_item_id: std::option::Option<std::string::String>,
    /// <p>Describes the reactive insight.</p>
    pub description: std::option::Option<std::string::String>,
}
impl ReactiveInsight {
    /// <p> The ID of a reactive insight. </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p> The name of a reactive insight. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The severity of the insight. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
    pub fn severity(&self) -> std::option::Option<&crate::model::InsightSeverity> {
        self.severity.as_ref()
    }
    /// <p> The status of a reactive insight. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::InsightStatus> {
        self.status.as_ref()
    }
    /// <p> A time ranged that specifies when the observed behavior in an insight started and ended. </p>
    pub fn insight_time_range(&self) -> std::option::Option<&crate::model::InsightTimeRange> {
        self.insight_time_range.as_ref()
    }
    /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub fn resource_collection(&self) -> std::option::Option<&crate::model::ResourceCollection> {
        self.resource_collection.as_ref()
    }
    /// <p> The ID of the Amazon Web Services System Manager OpsItem created for this insight. You must enable the creation of OpstItems insights before they are created for each insight. </p>
    pub fn ssm_ops_item_id(&self) -> std::option::Option<&str> {
        self.ssm_ops_item_id.as_deref()
    }
    /// <p>Describes the reactive insight.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for ReactiveInsight {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReactiveInsight");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("severity", &self.severity);
        formatter.field("status", &self.status);
        formatter.field("insight_time_range", &self.insight_time_range);
        formatter.field("resource_collection", &self.resource_collection);
        formatter.field("ssm_ops_item_id", &self.ssm_ops_item_id);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`ReactiveInsight`](crate::model::ReactiveInsight)
pub mod reactive_insight {
    /// A builder for [`ReactiveInsight`](crate::model::ReactiveInsight)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<crate::model::InsightSeverity>,
        pub(crate) status: std::option::Option<crate::model::InsightStatus>,
        pub(crate) insight_time_range: std::option::Option<crate::model::InsightTimeRange>,
        pub(crate) resource_collection: std::option::Option<crate::model::ResourceCollection>,
        pub(crate) ssm_ops_item_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The ID of a reactive insight. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The ID of a reactive insight. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p> The name of a reactive insight. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of a reactive insight. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The severity of the insight. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
        pub fn severity(mut self, input: crate::model::InsightSeverity) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>The severity of the insight. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
        pub fn set_severity(
            mut self,
            input: std::option::Option<crate::model::InsightSeverity>,
        ) -> Self {
            self.severity = input;
            self
        }
        /// <p> The status of a reactive insight. </p>
        pub fn status(mut self, input: crate::model::InsightStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The status of a reactive insight. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::InsightStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> A time ranged that specifies when the observed behavior in an insight started and ended. </p>
        pub fn insight_time_range(mut self, input: crate::model::InsightTimeRange) -> Self {
            self.insight_time_range = Some(input);
            self
        }
        /// <p> A time ranged that specifies when the observed behavior in an insight started and ended. </p>
        pub fn set_insight_time_range(
            mut self,
            input: std::option::Option<crate::model::InsightTimeRange>,
        ) -> Self {
            self.insight_time_range = input;
            self
        }
        /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn resource_collection(mut self, input: crate::model::ResourceCollection) -> Self {
            self.resource_collection = Some(input);
            self
        }
        /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn set_resource_collection(
            mut self,
            input: std::option::Option<crate::model::ResourceCollection>,
        ) -> Self {
            self.resource_collection = input;
            self
        }
        /// <p> The ID of the Amazon Web Services System Manager OpsItem created for this insight. You must enable the creation of OpstItems insights before they are created for each insight. </p>
        pub fn ssm_ops_item_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssm_ops_item_id = Some(input.into());
            self
        }
        /// <p> The ID of the Amazon Web Services System Manager OpsItem created for this insight. You must enable the creation of OpstItems insights before they are created for each insight. </p>
        pub fn set_ssm_ops_item_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssm_ops_item_id = input;
            self
        }
        /// <p>Describes the reactive insight.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Describes the reactive insight.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`ReactiveInsight`](crate::model::ReactiveInsight)
        pub fn build(self) -> crate::model::ReactiveInsight {
            crate::model::ReactiveInsight {
                id: self.id,
                name: self.name,
                severity: self.severity,
                status: self.status,
                insight_time_range: self.insight_time_range,
                resource_collection: self.resource_collection,
                ssm_ops_item_id: self.ssm_ops_item_id,
                description: self.description,
            }
        }
    }
}
impl ReactiveInsight {
    /// Creates a new builder-style object to manufacture [`ReactiveInsight`](crate::model::ReactiveInsight)
    pub fn builder() -> crate::model::reactive_insight::Builder {
        crate::model::reactive_insight::Builder::default()
    }
}

/// <p>Details about a proactive insight. This object is returned by <code>ListInsights</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProactiveInsight {
    /// <p>The ID of the proactive insight. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the proactive insight. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The severity of the insight. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
    pub severity: std::option::Option<crate::model::InsightSeverity>,
    /// <p>The status of the proactive insight. </p>
    pub status: std::option::Option<crate::model::InsightStatus>,
    /// <p> A time ranged that specifies when the observed behavior in an insight started and ended. </p>
    pub insight_time_range: std::option::Option<crate::model::InsightTimeRange>,
    /// <p> The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur. </p>
    pub prediction_time_range: std::option::Option<crate::model::PredictionTimeRange>,
    /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub resource_collection: std::option::Option<crate::model::ResourceCollection>,
    /// <p> The ID of the Amazon Web Services System Manager OpsItem created for this insight. You must enable the creation of OpstItems insights before they are created for each insight. </p>
    pub ssm_ops_item_id: std::option::Option<std::string::String>,
    /// <p>Describes the proactive insight.</p>
    pub description: std::option::Option<std::string::String>,
}
impl ProactiveInsight {
    /// <p>The ID of the proactive insight. </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the proactive insight. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The severity of the insight. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
    pub fn severity(&self) -> std::option::Option<&crate::model::InsightSeverity> {
        self.severity.as_ref()
    }
    /// <p>The status of the proactive insight. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::InsightStatus> {
        self.status.as_ref()
    }
    /// <p> A time ranged that specifies when the observed behavior in an insight started and ended. </p>
    pub fn insight_time_range(&self) -> std::option::Option<&crate::model::InsightTimeRange> {
        self.insight_time_range.as_ref()
    }
    /// <p> The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur. </p>
    pub fn prediction_time_range(&self) -> std::option::Option<&crate::model::PredictionTimeRange> {
        self.prediction_time_range.as_ref()
    }
    /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub fn resource_collection(&self) -> std::option::Option<&crate::model::ResourceCollection> {
        self.resource_collection.as_ref()
    }
    /// <p> The ID of the Amazon Web Services System Manager OpsItem created for this insight. You must enable the creation of OpstItems insights before they are created for each insight. </p>
    pub fn ssm_ops_item_id(&self) -> std::option::Option<&str> {
        self.ssm_ops_item_id.as_deref()
    }
    /// <p>Describes the proactive insight.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for ProactiveInsight {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProactiveInsight");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("severity", &self.severity);
        formatter.field("status", &self.status);
        formatter.field("insight_time_range", &self.insight_time_range);
        formatter.field("prediction_time_range", &self.prediction_time_range);
        formatter.field("resource_collection", &self.resource_collection);
        formatter.field("ssm_ops_item_id", &self.ssm_ops_item_id);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`ProactiveInsight`](crate::model::ProactiveInsight)
pub mod proactive_insight {
    /// A builder for [`ProactiveInsight`](crate::model::ProactiveInsight)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<crate::model::InsightSeverity>,
        pub(crate) status: std::option::Option<crate::model::InsightStatus>,
        pub(crate) insight_time_range: std::option::Option<crate::model::InsightTimeRange>,
        pub(crate) prediction_time_range: std::option::Option<crate::model::PredictionTimeRange>,
        pub(crate) resource_collection: std::option::Option<crate::model::ResourceCollection>,
        pub(crate) ssm_ops_item_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the proactive insight. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the proactive insight. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the proactive insight. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the proactive insight. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The severity of the insight. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
        pub fn severity(mut self, input: crate::model::InsightSeverity) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>The severity of the insight. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
        pub fn set_severity(
            mut self,
            input: std::option::Option<crate::model::InsightSeverity>,
        ) -> Self {
            self.severity = input;
            self
        }
        /// <p>The status of the proactive insight. </p>
        pub fn status(mut self, input: crate::model::InsightStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the proactive insight. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::InsightStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> A time ranged that specifies when the observed behavior in an insight started and ended. </p>
        pub fn insight_time_range(mut self, input: crate::model::InsightTimeRange) -> Self {
            self.insight_time_range = Some(input);
            self
        }
        /// <p> A time ranged that specifies when the observed behavior in an insight started and ended. </p>
        pub fn set_insight_time_range(
            mut self,
            input: std::option::Option<crate::model::InsightTimeRange>,
        ) -> Self {
            self.insight_time_range = input;
            self
        }
        /// <p> The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur. </p>
        pub fn prediction_time_range(mut self, input: crate::model::PredictionTimeRange) -> Self {
            self.prediction_time_range = Some(input);
            self
        }
        /// <p> The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur. </p>
        pub fn set_prediction_time_range(
            mut self,
            input: std::option::Option<crate::model::PredictionTimeRange>,
        ) -> Self {
            self.prediction_time_range = input;
            self
        }
        /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn resource_collection(mut self, input: crate::model::ResourceCollection) -> Self {
            self.resource_collection = Some(input);
            self
        }
        /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn set_resource_collection(
            mut self,
            input: std::option::Option<crate::model::ResourceCollection>,
        ) -> Self {
            self.resource_collection = input;
            self
        }
        /// <p> The ID of the Amazon Web Services System Manager OpsItem created for this insight. You must enable the creation of OpstItems insights before they are created for each insight. </p>
        pub fn ssm_ops_item_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssm_ops_item_id = Some(input.into());
            self
        }
        /// <p> The ID of the Amazon Web Services System Manager OpsItem created for this insight. You must enable the creation of OpstItems insights before they are created for each insight. </p>
        pub fn set_ssm_ops_item_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssm_ops_item_id = input;
            self
        }
        /// <p>Describes the proactive insight.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Describes the proactive insight.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`ProactiveInsight`](crate::model::ProactiveInsight)
        pub fn build(self) -> crate::model::ProactiveInsight {
            crate::model::ProactiveInsight {
                id: self.id,
                name: self.name,
                severity: self.severity,
                status: self.status,
                insight_time_range: self.insight_time_range,
                prediction_time_range: self.prediction_time_range,
                resource_collection: self.resource_collection,
                ssm_ops_item_id: self.ssm_ops_item_id,
                description: self.description,
            }
        }
    }
}
impl ProactiveInsight {
    /// Creates a new builder-style object to manufacture [`ProactiveInsight`](crate::model::ProactiveInsight)
    pub fn builder() -> crate::model::proactive_insight::Builder {
        crate::model::proactive_insight::Builder::default()
    }
}

/// <p>Details about a reactive anomaly. This object is returned by <code>ListAnomalies</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReactiveAnomaly {
    /// <p>The ID of the reactive anomaly. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The severity of the anomaly. The severity of anomalies that generate an insight determine that insight's severity. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
    pub severity: std::option::Option<crate::model::AnomalySeverity>,
    /// <p> The status of the anomaly. </p>
    pub status: std::option::Option<crate::model::AnomalyStatus>,
    /// <p> A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from <code>AnomalyReportedTimeRange</code>, which specifies the time range when DevOps Guru opens and then closes an anomaly. </p>
    pub anomaly_time_range: std::option::Option<crate::model::AnomalyTimeRange>,
    /// <p> An <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed. </p>
    pub anomaly_reported_time_range: std::option::Option<crate::model::AnomalyReportedTimeRange>,
    /// <p> Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics. </p>
    pub source_details: std::option::Option<crate::model::AnomalySourceDetails>,
    /// <p> The ID of the insight that contains this anomaly. An insight is composed of related anomalies. </p>
    pub associated_insight_id: std::option::Option<std::string::String>,
    /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub resource_collection: std::option::Option<crate::model::ResourceCollection>,
    /// <p>The type of the reactive anomaly. It can be one of the following types.</p>
    /// <ul>
    /// <li> <p> <code>CAUSAL</code> - the anomaly can cause a new insight.</p> </li>
    /// <li> <p> <code>CONTEXTUAL</code> - the anomaly contains additional information about an insight or its causal anomaly.</p> </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::AnomalyType>,
    /// <p>The name of the reactive anomaly.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the reactive anomaly.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ID of the causal anomaly that is associated with this reactive anomaly. The ID of a `CAUSAL` anomaly is always `NULL`.</p>
    pub causal_anomaly_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services resources in which anomalous behavior was detected by DevOps Guru.</p>
    pub anomaly_resources: std::option::Option<std::vec::Vec<crate::model::AnomalyResource>>,
}
impl ReactiveAnomaly {
    /// <p>The ID of the reactive anomaly. </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The severity of the anomaly. The severity of anomalies that generate an insight determine that insight's severity. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
    pub fn severity(&self) -> std::option::Option<&crate::model::AnomalySeverity> {
        self.severity.as_ref()
    }
    /// <p> The status of the anomaly. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::AnomalyStatus> {
        self.status.as_ref()
    }
    /// <p> A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from <code>AnomalyReportedTimeRange</code>, which specifies the time range when DevOps Guru opens and then closes an anomaly. </p>
    pub fn anomaly_time_range(&self) -> std::option::Option<&crate::model::AnomalyTimeRange> {
        self.anomaly_time_range.as_ref()
    }
    /// <p> An <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed. </p>
    pub fn anomaly_reported_time_range(
        &self,
    ) -> std::option::Option<&crate::model::AnomalyReportedTimeRange> {
        self.anomaly_reported_time_range.as_ref()
    }
    /// <p> Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics. </p>
    pub fn source_details(&self) -> std::option::Option<&crate::model::AnomalySourceDetails> {
        self.source_details.as_ref()
    }
    /// <p> The ID of the insight that contains this anomaly. An insight is composed of related anomalies. </p>
    pub fn associated_insight_id(&self) -> std::option::Option<&str> {
        self.associated_insight_id.as_deref()
    }
    /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub fn resource_collection(&self) -> std::option::Option<&crate::model::ResourceCollection> {
        self.resource_collection.as_ref()
    }
    /// <p>The type of the reactive anomaly. It can be one of the following types.</p>
    /// <ul>
    /// <li> <p> <code>CAUSAL</code> - the anomaly can cause a new insight.</p> </li>
    /// <li> <p> <code>CONTEXTUAL</code> - the anomaly contains additional information about an insight or its causal anomaly.</p> </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::AnomalyType> {
        self.r#type.as_ref()
    }
    /// <p>The name of the reactive anomaly.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the reactive anomaly.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ID of the causal anomaly that is associated with this reactive anomaly. The ID of a `CAUSAL` anomaly is always `NULL`.</p>
    pub fn causal_anomaly_id(&self) -> std::option::Option<&str> {
        self.causal_anomaly_id.as_deref()
    }
    /// <p>The Amazon Web Services resources in which anomalous behavior was detected by DevOps Guru.</p>
    pub fn anomaly_resources(&self) -> std::option::Option<&[crate::model::AnomalyResource]> {
        self.anomaly_resources.as_deref()
    }
}
impl std::fmt::Debug for ReactiveAnomaly {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReactiveAnomaly");
        formatter.field("id", &self.id);
        formatter.field("severity", &self.severity);
        formatter.field("status", &self.status);
        formatter.field("anomaly_time_range", &self.anomaly_time_range);
        formatter.field(
            "anomaly_reported_time_range",
            &self.anomaly_reported_time_range,
        );
        formatter.field("source_details", &self.source_details);
        formatter.field("associated_insight_id", &self.associated_insight_id);
        formatter.field("resource_collection", &self.resource_collection);
        formatter.field("r#type", &self.r#type);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("causal_anomaly_id", &self.causal_anomaly_id);
        formatter.field("anomaly_resources", &self.anomaly_resources);
        formatter.finish()
    }
}
/// See [`ReactiveAnomaly`](crate::model::ReactiveAnomaly)
pub mod reactive_anomaly {
    /// A builder for [`ReactiveAnomaly`](crate::model::ReactiveAnomaly)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<crate::model::AnomalySeverity>,
        pub(crate) status: std::option::Option<crate::model::AnomalyStatus>,
        pub(crate) anomaly_time_range: std::option::Option<crate::model::AnomalyTimeRange>,
        pub(crate) anomaly_reported_time_range:
            std::option::Option<crate::model::AnomalyReportedTimeRange>,
        pub(crate) source_details: std::option::Option<crate::model::AnomalySourceDetails>,
        pub(crate) associated_insight_id: std::option::Option<std::string::String>,
        pub(crate) resource_collection: std::option::Option<crate::model::ResourceCollection>,
        pub(crate) r#type: std::option::Option<crate::model::AnomalyType>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) causal_anomaly_id: std::option::Option<std::string::String>,
        pub(crate) anomaly_resources:
            std::option::Option<std::vec::Vec<crate::model::AnomalyResource>>,
    }
    impl Builder {
        /// <p>The ID of the reactive anomaly. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the reactive anomaly. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The severity of the anomaly. The severity of anomalies that generate an insight determine that insight's severity. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
        pub fn severity(mut self, input: crate::model::AnomalySeverity) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>The severity of the anomaly. The severity of anomalies that generate an insight determine that insight's severity. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
        pub fn set_severity(
            mut self,
            input: std::option::Option<crate::model::AnomalySeverity>,
        ) -> Self {
            self.severity = input;
            self
        }
        /// <p> The status of the anomaly. </p>
        pub fn status(mut self, input: crate::model::AnomalyStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The status of the anomaly. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AnomalyStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from <code>AnomalyReportedTimeRange</code>, which specifies the time range when DevOps Guru opens and then closes an anomaly. </p>
        pub fn anomaly_time_range(mut self, input: crate::model::AnomalyTimeRange) -> Self {
            self.anomaly_time_range = Some(input);
            self
        }
        /// <p> A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from <code>AnomalyReportedTimeRange</code>, which specifies the time range when DevOps Guru opens and then closes an anomaly. </p>
        pub fn set_anomaly_time_range(
            mut self,
            input: std::option::Option<crate::model::AnomalyTimeRange>,
        ) -> Self {
            self.anomaly_time_range = input;
            self
        }
        /// <p> An <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed. </p>
        pub fn anomaly_reported_time_range(
            mut self,
            input: crate::model::AnomalyReportedTimeRange,
        ) -> Self {
            self.anomaly_reported_time_range = Some(input);
            self
        }
        /// <p> An <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed. </p>
        pub fn set_anomaly_reported_time_range(
            mut self,
            input: std::option::Option<crate::model::AnomalyReportedTimeRange>,
        ) -> Self {
            self.anomaly_reported_time_range = input;
            self
        }
        /// <p> Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics. </p>
        pub fn source_details(mut self, input: crate::model::AnomalySourceDetails) -> Self {
            self.source_details = Some(input);
            self
        }
        /// <p> Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics. </p>
        pub fn set_source_details(
            mut self,
            input: std::option::Option<crate::model::AnomalySourceDetails>,
        ) -> Self {
            self.source_details = input;
            self
        }
        /// <p> The ID of the insight that contains this anomaly. An insight is composed of related anomalies. </p>
        pub fn associated_insight_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.associated_insight_id = Some(input.into());
            self
        }
        /// <p> The ID of the insight that contains this anomaly. An insight is composed of related anomalies. </p>
        pub fn set_associated_insight_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.associated_insight_id = input;
            self
        }
        /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn resource_collection(mut self, input: crate::model::ResourceCollection) -> Self {
            self.resource_collection = Some(input);
            self
        }
        /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn set_resource_collection(
            mut self,
            input: std::option::Option<crate::model::ResourceCollection>,
        ) -> Self {
            self.resource_collection = input;
            self
        }
        /// <p>The type of the reactive anomaly. It can be one of the following types.</p>
        /// <ul>
        /// <li> <p> <code>CAUSAL</code> - the anomaly can cause a new insight.</p> </li>
        /// <li> <p> <code>CONTEXTUAL</code> - the anomaly contains additional information about an insight or its causal anomaly.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::AnomalyType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the reactive anomaly. It can be one of the following types.</p>
        /// <ul>
        /// <li> <p> <code>CAUSAL</code> - the anomaly can cause a new insight.</p> </li>
        /// <li> <p> <code>CONTEXTUAL</code> - the anomaly contains additional information about an insight or its causal anomaly.</p> </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::AnomalyType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The name of the reactive anomaly.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the reactive anomaly.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the reactive anomaly.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the reactive anomaly.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ID of the causal anomaly that is associated with this reactive anomaly. The ID of a `CAUSAL` anomaly is always `NULL`.</p>
        pub fn causal_anomaly_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.causal_anomaly_id = Some(input.into());
            self
        }
        /// <p>The ID of the causal anomaly that is associated with this reactive anomaly. The ID of a `CAUSAL` anomaly is always `NULL`.</p>
        pub fn set_causal_anomaly_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.causal_anomaly_id = input;
            self
        }
        /// Appends an item to `anomaly_resources`.
        ///
        /// To override the contents of this collection use [`set_anomaly_resources`](Self::set_anomaly_resources).
        ///
        /// <p>The Amazon Web Services resources in which anomalous behavior was detected by DevOps Guru.</p>
        pub fn anomaly_resources(mut self, input: crate::model::AnomalyResource) -> Self {
            let mut v = self.anomaly_resources.unwrap_or_default();
            v.push(input);
            self.anomaly_resources = Some(v);
            self
        }
        /// <p>The Amazon Web Services resources in which anomalous behavior was detected by DevOps Guru.</p>
        pub fn set_anomaly_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AnomalyResource>>,
        ) -> Self {
            self.anomaly_resources = input;
            self
        }
        /// Consumes the builder and constructs a [`ReactiveAnomaly`](crate::model::ReactiveAnomaly)
        pub fn build(self) -> crate::model::ReactiveAnomaly {
            crate::model::ReactiveAnomaly {
                id: self.id,
                severity: self.severity,
                status: self.status,
                anomaly_time_range: self.anomaly_time_range,
                anomaly_reported_time_range: self.anomaly_reported_time_range,
                source_details: self.source_details,
                associated_insight_id: self.associated_insight_id,
                resource_collection: self.resource_collection,
                r#type: self.r#type,
                name: self.name,
                description: self.description,
                causal_anomaly_id: self.causal_anomaly_id,
                anomaly_resources: self.anomaly_resources,
            }
        }
    }
}
impl ReactiveAnomaly {
    /// Creates a new builder-style object to manufacture [`ReactiveAnomaly`](crate::model::ReactiveAnomaly)
    pub fn builder() -> crate::model::reactive_anomaly::Builder {
        crate::model::reactive_anomaly::Builder::default()
    }
}

/// <p>Information about an anomaly. This object is returned by <code>ListAnomalies</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProactiveAnomaly {
    /// <p> The ID of a proactive anomaly. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The severity of the anomaly. The severity of anomalies that generate an insight determine that insight's severity. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
    pub severity: std::option::Option<crate::model::AnomalySeverity>,
    /// <p> The status of a proactive anomaly. </p>
    pub status: std::option::Option<crate::model::AnomalyStatus>,
    /// <p> The time of the anomaly's most recent update. </p>
    pub update_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from <code>AnomalyReportedTimeRange</code>, which specifies the time range when DevOps Guru opens and then closes an anomaly. </p>
    pub anomaly_time_range: std::option::Option<crate::model::AnomalyTimeRange>,
    /// <p> An <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed. </p>
    pub anomaly_reported_time_range: std::option::Option<crate::model::AnomalyReportedTimeRange>,
    /// <p> The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur. </p>
    pub prediction_time_range: std::option::Option<crate::model::PredictionTimeRange>,
    /// <p> Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics. </p>
    pub source_details: std::option::Option<crate::model::AnomalySourceDetails>,
    /// <p> The ID of the insight that contains this anomaly. An insight is composed of related anomalies. </p>
    pub associated_insight_id: std::option::Option<std::string::String>,
    /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub resource_collection: std::option::Option<crate::model::ResourceCollection>,
    /// <p> A threshold that was exceeded by behavior in analyzed resources. Exceeding this threshold is related to the anomalous behavior that generated this anomaly. </p>
    pub limit: std::option::Option<f64>,
    /// <p>The metadata for the anomaly.</p>
    pub source_metadata: std::option::Option<crate::model::AnomalySourceMetadata>,
    /// <p>Information about a resource in which DevOps Guru detected anomalous behavior.</p>
    pub anomaly_resources: std::option::Option<std::vec::Vec<crate::model::AnomalyResource>>,
}
impl ProactiveAnomaly {
    /// <p> The ID of a proactive anomaly. </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The severity of the anomaly. The severity of anomalies that generate an insight determine that insight's severity. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
    pub fn severity(&self) -> std::option::Option<&crate::model::AnomalySeverity> {
        self.severity.as_ref()
    }
    /// <p> The status of a proactive anomaly. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::AnomalyStatus> {
        self.status.as_ref()
    }
    /// <p> The time of the anomaly's most recent update. </p>
    pub fn update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_time.as_ref()
    }
    /// <p> A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from <code>AnomalyReportedTimeRange</code>, which specifies the time range when DevOps Guru opens and then closes an anomaly. </p>
    pub fn anomaly_time_range(&self) -> std::option::Option<&crate::model::AnomalyTimeRange> {
        self.anomaly_time_range.as_ref()
    }
    /// <p> An <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed. </p>
    pub fn anomaly_reported_time_range(
        &self,
    ) -> std::option::Option<&crate::model::AnomalyReportedTimeRange> {
        self.anomaly_reported_time_range.as_ref()
    }
    /// <p> The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur. </p>
    pub fn prediction_time_range(&self) -> std::option::Option<&crate::model::PredictionTimeRange> {
        self.prediction_time_range.as_ref()
    }
    /// <p> Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics. </p>
    pub fn source_details(&self) -> std::option::Option<&crate::model::AnomalySourceDetails> {
        self.source_details.as_ref()
    }
    /// <p> The ID of the insight that contains this anomaly. An insight is composed of related anomalies. </p>
    pub fn associated_insight_id(&self) -> std::option::Option<&str> {
        self.associated_insight_id.as_deref()
    }
    /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub fn resource_collection(&self) -> std::option::Option<&crate::model::ResourceCollection> {
        self.resource_collection.as_ref()
    }
    /// <p> A threshold that was exceeded by behavior in analyzed resources. Exceeding this threshold is related to the anomalous behavior that generated this anomaly. </p>
    pub fn limit(&self) -> std::option::Option<f64> {
        self.limit
    }
    /// <p>The metadata for the anomaly.</p>
    pub fn source_metadata(&self) -> std::option::Option<&crate::model::AnomalySourceMetadata> {
        self.source_metadata.as_ref()
    }
    /// <p>Information about a resource in which DevOps Guru detected anomalous behavior.</p>
    pub fn anomaly_resources(&self) -> std::option::Option<&[crate::model::AnomalyResource]> {
        self.anomaly_resources.as_deref()
    }
}
impl std::fmt::Debug for ProactiveAnomaly {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProactiveAnomaly");
        formatter.field("id", &self.id);
        formatter.field("severity", &self.severity);
        formatter.field("status", &self.status);
        formatter.field("update_time", &self.update_time);
        formatter.field("anomaly_time_range", &self.anomaly_time_range);
        formatter.field(
            "anomaly_reported_time_range",
            &self.anomaly_reported_time_range,
        );
        formatter.field("prediction_time_range", &self.prediction_time_range);
        formatter.field("source_details", &self.source_details);
        formatter.field("associated_insight_id", &self.associated_insight_id);
        formatter.field("resource_collection", &self.resource_collection);
        formatter.field("limit", &self.limit);
        formatter.field("source_metadata", &self.source_metadata);
        formatter.field("anomaly_resources", &self.anomaly_resources);
        formatter.finish()
    }
}
/// See [`ProactiveAnomaly`](crate::model::ProactiveAnomaly)
pub mod proactive_anomaly {
    /// A builder for [`ProactiveAnomaly`](crate::model::ProactiveAnomaly)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<crate::model::AnomalySeverity>,
        pub(crate) status: std::option::Option<crate::model::AnomalyStatus>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) anomaly_time_range: std::option::Option<crate::model::AnomalyTimeRange>,
        pub(crate) anomaly_reported_time_range:
            std::option::Option<crate::model::AnomalyReportedTimeRange>,
        pub(crate) prediction_time_range: std::option::Option<crate::model::PredictionTimeRange>,
        pub(crate) source_details: std::option::Option<crate::model::AnomalySourceDetails>,
        pub(crate) associated_insight_id: std::option::Option<std::string::String>,
        pub(crate) resource_collection: std::option::Option<crate::model::ResourceCollection>,
        pub(crate) limit: std::option::Option<f64>,
        pub(crate) source_metadata: std::option::Option<crate::model::AnomalySourceMetadata>,
        pub(crate) anomaly_resources:
            std::option::Option<std::vec::Vec<crate::model::AnomalyResource>>,
    }
    impl Builder {
        /// <p> The ID of a proactive anomaly. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The ID of a proactive anomaly. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The severity of the anomaly. The severity of anomalies that generate an insight determine that insight's severity. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
        pub fn severity(mut self, input: crate::model::AnomalySeverity) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>The severity of the anomaly. The severity of anomalies that generate an insight determine that insight's severity. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>
        pub fn set_severity(
            mut self,
            input: std::option::Option<crate::model::AnomalySeverity>,
        ) -> Self {
            self.severity = input;
            self
        }
        /// <p> The status of a proactive anomaly. </p>
        pub fn status(mut self, input: crate::model::AnomalyStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The status of a proactive anomaly. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AnomalyStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> The time of the anomaly's most recent update. </p>
        pub fn update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p> The time of the anomaly's most recent update. </p>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// <p> A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from <code>AnomalyReportedTimeRange</code>, which specifies the time range when DevOps Guru opens and then closes an anomaly. </p>
        pub fn anomaly_time_range(mut self, input: crate::model::AnomalyTimeRange) -> Self {
            self.anomaly_time_range = Some(input);
            self
        }
        /// <p> A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from <code>AnomalyReportedTimeRange</code>, which specifies the time range when DevOps Guru opens and then closes an anomaly. </p>
        pub fn set_anomaly_time_range(
            mut self,
            input: std::option::Option<crate::model::AnomalyTimeRange>,
        ) -> Self {
            self.anomaly_time_range = input;
            self
        }
        /// <p> An <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed. </p>
        pub fn anomaly_reported_time_range(
            mut self,
            input: crate::model::AnomalyReportedTimeRange,
        ) -> Self {
            self.anomaly_reported_time_range = Some(input);
            self
        }
        /// <p> An <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed. </p>
        pub fn set_anomaly_reported_time_range(
            mut self,
            input: std::option::Option<crate::model::AnomalyReportedTimeRange>,
        ) -> Self {
            self.anomaly_reported_time_range = input;
            self
        }
        /// <p> The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur. </p>
        pub fn prediction_time_range(mut self, input: crate::model::PredictionTimeRange) -> Self {
            self.prediction_time_range = Some(input);
            self
        }
        /// <p> The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur. </p>
        pub fn set_prediction_time_range(
            mut self,
            input: std::option::Option<crate::model::PredictionTimeRange>,
        ) -> Self {
            self.prediction_time_range = input;
            self
        }
        /// <p> Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics. </p>
        pub fn source_details(mut self, input: crate::model::AnomalySourceDetails) -> Self {
            self.source_details = Some(input);
            self
        }
        /// <p> Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics. </p>
        pub fn set_source_details(
            mut self,
            input: std::option::Option<crate::model::AnomalySourceDetails>,
        ) -> Self {
            self.source_details = input;
            self
        }
        /// <p> The ID of the insight that contains this anomaly. An insight is composed of related anomalies. </p>
        pub fn associated_insight_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.associated_insight_id = Some(input.into());
            self
        }
        /// <p> The ID of the insight that contains this anomaly. An insight is composed of related anomalies. </p>
        pub fn set_associated_insight_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.associated_insight_id = input;
            self
        }
        /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn resource_collection(mut self, input: crate::model::ResourceCollection) -> Self {
            self.resource_collection = Some(input);
            self
        }
        /// <p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn set_resource_collection(
            mut self,
            input: std::option::Option<crate::model::ResourceCollection>,
        ) -> Self {
            self.resource_collection = input;
            self
        }
        /// <p> A threshold that was exceeded by behavior in analyzed resources. Exceeding this threshold is related to the anomalous behavior that generated this anomaly. </p>
        pub fn limit(mut self, input: f64) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p> A threshold that was exceeded by behavior in analyzed resources. Exceeding this threshold is related to the anomalous behavior that generated this anomaly. </p>
        pub fn set_limit(mut self, input: std::option::Option<f64>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The metadata for the anomaly.</p>
        pub fn source_metadata(mut self, input: crate::model::AnomalySourceMetadata) -> Self {
            self.source_metadata = Some(input);
            self
        }
        /// <p>The metadata for the anomaly.</p>
        pub fn set_source_metadata(
            mut self,
            input: std::option::Option<crate::model::AnomalySourceMetadata>,
        ) -> Self {
            self.source_metadata = input;
            self
        }
        /// Appends an item to `anomaly_resources`.
        ///
        /// To override the contents of this collection use [`set_anomaly_resources`](Self::set_anomaly_resources).
        ///
        /// <p>Information about a resource in which DevOps Guru detected anomalous behavior.</p>
        pub fn anomaly_resources(mut self, input: crate::model::AnomalyResource) -> Self {
            let mut v = self.anomaly_resources.unwrap_or_default();
            v.push(input);
            self.anomaly_resources = Some(v);
            self
        }
        /// <p>Information about a resource in which DevOps Guru detected anomalous behavior.</p>
        pub fn set_anomaly_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AnomalyResource>>,
        ) -> Self {
            self.anomaly_resources = input;
            self
        }
        /// Consumes the builder and constructs a [`ProactiveAnomaly`](crate::model::ProactiveAnomaly)
        pub fn build(self) -> crate::model::ProactiveAnomaly {
            crate::model::ProactiveAnomaly {
                id: self.id,
                severity: self.severity,
                status: self.status,
                update_time: self.update_time,
                anomaly_time_range: self.anomaly_time_range,
                anomaly_reported_time_range: self.anomaly_reported_time_range,
                prediction_time_range: self.prediction_time_range,
                source_details: self.source_details,
                associated_insight_id: self.associated_insight_id,
                resource_collection: self.resource_collection,
                limit: self.limit,
                source_metadata: self.source_metadata,
                anomaly_resources: self.anomaly_resources,
            }
        }
    }
}
impl ProactiveAnomaly {
    /// Creates a new builder-style object to manufacture [`ProactiveAnomaly`](crate::model::ProactiveAnomaly)
    pub fn builder() -> crate::model::proactive_anomaly::Builder {
        crate::model::proactive_anomaly::Builder::default()
    }
}
